/********************************************************************************
*                                                                               *
*                Device Context (DC) helper routines                            *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXDCHELPER_H
#define FXDCHELPER_H

namespace FXEX {

/**
 * FXDCHelper provides drawing support routines which can be used in your custom widgets.
 * eg drawing various styles of rectangles.
 *
 * It takes frame style options (FRAME_*) for specifying the specific types of frame styles
 */
class FXAPI FXDCHelper {

protected:
  FXApp   *app;              // application
  FXuint   options;          // options
  FXDC    *device;           // the device to be drawn into
  FXColor  baseColor;        // Base color
  FXColor  hiliteColor;      // Highlight color
  FXColor  shadowColor;      // Shadow color
  FXColor  borderColor;      // Border color
  FXint    border;           // Border width

public: // we can draw these routines

  /// various rectangles that can be drawn
  void drawBorderRectangle(FXint x,FXint y,FXint w,FXint h);
  void drawRaisedRectangle(FXint x,FXint y,FXint w,FXint h);
  void drawSunkenRectangle(FXint x,FXint y,FXint w,FXint h);
  void drawRidgeRectangle(FXint x,FXint y,FXint w,FXint h);
  void drawGrooveRectangle(FXint x,FXint y,FXint w,FXint h);
  void drawDoubleRaisedRectangle(FXint x,FXint y,FXint w,FXint h);
  void drawDoubleSunkenRectangle(FXint x,FXint y,FXint w,FXint h);
  void drawFocusRectangle(FXint x,FXint y,FXint w,FXint h);
  void drawFrame(FXint x,FXint y,FXint w,FXint h);

  /// fill region
  void fillRegion(const FXRegion& region);

  /// fill an arc centered at x,y
  /// width,height from center
  /// start-angle,end-angle in degrees from 12 oclock, clockwise
  void fillArc(FXint x,FXint y,FXint w,FXint h,FXfloat start,FXfloat end);

public:
  /// Construct packer layout manager
  FXDCHelper(FXApp *a,FXDC *dc=NULL,FXuint opts=0);

  /// Construct based on existing helper
  FXDCHelper(const FXDCHelper& h);

  /// assign from other DC helper
  FXDCHelper &operator=(const FXDCHelper& h);

  /// get application
  FXApp* getApp() { return app; }

  /// set's the current DC
  void setDC(FXDC *dc) { device=dc; }

  /// get the curretn DC
  FXDC *getDC() const { return device; }

  /// Change frame style
  void setFrameStyle(FXuint style);

  /// Get current frame style
  FXuint getFrameStyle() const;

  /// Get border width
  FXint getBorderWidth() const { return border; }

  /// Change highlight color
  void setHiliteColor(FXColor clr);

  /// Get highlight color
  FXColor getHiliteColor() const { return hiliteColor; }

  /// Change shadow color
  void setShadowColor(FXColor clr);

  /// Get shadow color
  FXColor getShadowColor() const { return shadowColor; }

  /// Change border color
  void setBorderColor(FXColor clr);

  /// Get border color
  FXColor getBorderColor() const { return borderColor; }

  /// Change base gui color
  void setBaseColor(FXColor clr);

  /// Get base gui color
  FXColor getBaseColor() const { return baseColor; }

  /// dtor
  virtual ~FXDCHelper();
  };

} // namespace FXEX
#endif // FXDCHELPER_H

