#include "mainwindow.h"
#include "FXSocketClient.h"
#include "FXSocketServer.h"

#define PORT 20002

FXDEFMAP(mainwindow) mainwindowMap[]={
  FXMAPFUNC(SEL_CLOSE,0,mainwindow::onCmdQuit),
  FXMAPFUNC(SEL_CLOSE,mainwindow::ID_MAINWINDOW,mainwindow::onCmdQuit),
  FXMAPFUNC(SEL_SIGNAL,mainwindow::ID_QUIT,mainwindow::onCmdQuit),
  FXMAPFUNC(SEL_COMMAND,mainwindow::ID_QUIT,mainwindow::onCmdQuit),
  FXMAPFUNC(SEL_OPENED,mainwindow::ID_SOCKET,mainwindow::onSocketOpened),
  FXMAPFUNC(SEL_DESTROY,mainwindow::ID_SOCKET,mainwindow::onSocketDestroyed),
  FXMAPFUNC(SEL_COMMAND,mainwindow::ID_SOCKET,mainwindow::onSocketRead),
  };
FXIMPLEMENT(mainwindow,FXMainWindow,mainwindowMap,ARRAYNUMBER(mainwindowMap))

mainwindow::mainwindow(FXApp* a) : FXMainWindow(a,"Testapp"){
  setTarget(this);
  setSelector(ID_MAINWINDOW);
  setWidth(100);
  setHeight(100);
  setX(100);
  setY(100);
  enable();
  new FXTooltip(getApp());

  // Menubar & statusbar
  FXToolbarShell* menushell=new FXToolbarShell(this,FRAME_RAISED|FRAME_THICK);
  menubar=new FXMenubar(this,menushell,LAYOUT_FILL_X);
  new FXToolbarGrip(menubar,menubar,FXMenubar::ID_TOOLBARGRIP,TOOLBARGRIP_DOUBLE);
  statusbar=new FXStatusbar(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);

  // File Menu entries
  filemenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"&File",NULL,filemenu);
  new FXMenuCommand(filemenu,"&Quit\tAlt-F4",NULL,this,ID_QUIT,MENU_DEFAULT);
  }

mainwindow::~mainwindow(){
  delete filemenu;
  delete statusbar;
  delete menubar;
  }

void mainwindow::create(){
  FXMainWindow::create();
//  show();
  fxTraceLevel=51;

/*
  sock = new FXSocketClient(getApp(),"localhost",PORT,this,ID_SOCKET,FXSocketFamilyUnix);
  sock->create();
  if (sock->getStatus() == FXSocketStatusOk){
    sock->setText("Mat woz ere");
    //FXSocketData data;
    //data.socket = sock->getHandle();
    //data.data = (FXuchar*) msg;
    //data.no = strlen(msg);
    //sock->handle(this,MKUINT(FXSocket::ID_SEND,SEL_COMMAND),(void*)&data);
    }
*/
  sock = new FXSocketServer(getApp(),PORT,5,this,ID_SOCKET,FXSocketFamilyUnix);
  sock->create();

  }

long mainwindow::onCmdQuit(FXObject*,FXSelector,void*){
  getApp()->exit();
  return 1;
  }

long mainwindow::onSocketOpened(FXObject* sender,FXSelector,void *ptr){
  FXSocket *s = (FXSocket*) ptr;
//  fxmessage("socket opened\n");
//  s->setText("Hi there\n");
  return 1;
  }

long mainwindow::onSocketRead(FXObject* sender,FXSelector,void *ptr){
  FXSocket *s = (FXSocket*) sender;
  fxmessage("socket: %i    data: '%s'\n",s->getHandle(),s->getText().text());
  return 1;
  }

long mainwindow::onSocketDestroyed(FXObject* sender,FXSelector,void *ptr){
  FXSocket *s = (FXSocket*) sender;
  fxmessage("socket destroyed: %i\n",s->getHandle());
  return 1;
  }

