(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    155858,       3829]
NotebookOptionsPosition[    148577,       3646]
NotebookOutlinePosition[    149685,       3685]
CellTagsIndexPosition[    149642,       3682]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"F", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, {3.498942973601361*^9, 3.4989429891913824`*^9}, 
   3.4989514778524313`*^9, {3.5153724508197913`*^9, 3.5153724597430067`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, {
   3.498943480642071*^9, 3.49894348747208*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"F", "[", "z", "]"}], "n"]}]], 
     SuperscriptBox[
      RowBox[{"F", "[", "z", "]"}], 
      RowBox[{"n", "/", "2"}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, 3.498943692912368*^9, 
   3.4989441337829847`*^9, {3.5153723960480947`*^9, 3.5153724351105633`*^9}, {
   3.5153727842235765`*^9, 3.5153727862827806`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox["n", "2"], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"m", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4989441763830442`*^9, 3.498944245943142*^9}, {
   3.498944728853818*^9, 3.4989447351038265`*^9}, {3.498944917184082*^9, 
   3.498944929424099*^9}, {3.5153725216439157`*^9, 3.5153725239995193`*^9}, {
   3.515372618722886*^9, 3.5153726239332952`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"F", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox["c", 
      RowBox[{"m", "-", 
       FractionBox["1", "2"]}]]}]}], 
   FractionBox[
    SqrtBox[
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"F", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"]}]], 
    SuperscriptBox[
     RowBox[{"F", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"n", "/", "2"}]]], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox[
      RowBox[{"F", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"m", " ", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.498943014451418*^9, 3.4989430594714813`*^9}, {
   3.4989432548417544`*^9, 3.4989432833517942`*^9}, {3.4989433383218718`*^9, 
   3.4989433424018774`*^9}, {3.498943436782009*^9, 3.4989434491020265`*^9}, {
   3.4989435984022355`*^9, 3.4989436254622736`*^9}, {3.4989440169528217`*^9, 
   3.4989440197028255`*^9}, {3.4989514819084387`*^9, 
   3.4989514842328424`*^9}, {3.5153724697738247`*^9, 3.5153724777766385`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{
         RowBox[{"F_", "[", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ")"}], "^", 
      "m_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"c", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "*", 
         RowBox[{
          RowBox[{"F", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], "]"}], "/", 
       RowBox[{
        RowBox[{"F", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "/", "2"}], ")"}]}]}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"F", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "/", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "Sin", ",", "Cos", ",", "Tan", ",", "Cot", ",", "Sinh", ",", "Cosh", 
        ",", "Tanh", ",", "Coth"}], "}"}], ",", "F"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, {
   3.49894315890162*^9, 3.498943232111723*^9}, 3.498943819612545*^9, {
   3.498944373563321*^9, 3.498944379663329*^9}, {3.4989446931837683`*^9, 
   3.498944705793786*^9}, {3.498951487399648*^9, 3.4989514940608597`*^9}, {
   3.515372532719935*^9, 3.5153727134150524`*^9}, {3.515372772039955*^9, 
   3.5153727726015563`*^9}, {3.5153806471875563`*^9, 3.515380684565222*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, {
   3.498943480642071*^9, 3.49894348747208*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"F", "[", "z", "]"}], 
      RowBox[{"n", "/", "2"}]], 
     SqrtBox[
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"F", "[", "z", "]"}], "n"]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, 3.498943692912368*^9, 
   3.4989441337829847`*^9, 3.498944810803933*^9, {3.5153727337574883`*^9, 
   3.515372750137517*^9}, 3.515372857340905*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox["n", "2"], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"m", "<", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4989441763830442`*^9, 3.498944245943142*^9}, {
   3.498944728853818*^9, 3.4989447351038265`*^9}, {3.498944940874115*^9, 
   3.49894494435412*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"F", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox["c", 
      RowBox[{"m", "+", 
       FractionBox["1", "2"]}]]}]}], 
   FractionBox[
    SuperscriptBox[
     RowBox[{"F", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"n", "/", "2"}]], 
    SqrtBox[
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"F", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"]}]]], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox[
      RowBox[{"F", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"m", " ", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.498943014451418*^9, 3.4989430594714813`*^9}, {
   3.4989432548417544`*^9, 3.4989432833517942`*^9}, {3.4989433383218718`*^9, 
   3.4989433424018774`*^9}, {3.498943436782009*^9, 3.4989434491020265`*^9}, {
   3.4989435984022355`*^9, 3.4989436254622736`*^9}, {3.4989440169528217`*^9, 
   3.4989440197028255`*^9}, {3.498944781463892*^9, 3.498944792193907*^9}, {
   3.4989448634640064`*^9, 3.4989448638840075`*^9}, {3.49895151125209*^9, 
   3.498951513061693*^9}, {3.515372794737995*^9, 3.515372805268014*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{
         RowBox[{"F_", "[", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ")"}], "^", 
      "m_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"c", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{
        RowBox[{"F", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "/", "2"}], ")"}]}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "*", 
         RowBox[{
          RowBox[{"F", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], "]"}]}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"F", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "/", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", "0"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "Sin", ",", "Cos", ",", "Tan", ",", "Cot", ",", "Sinh", ",", "Cosh", 
        ",", "Tanh", ",", "Coth"}], "}"}], ",", "F"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, {
   3.49894315890162*^9, 3.498943232111723*^9}, 3.498943819612545*^9, {
   3.498944373563321*^9, 3.498944379663329*^9}, {3.4989447099537916`*^9, 
   3.4989447156637993`*^9}, {3.498944969244155*^9, 3.4989449925541873`*^9}, {
   3.498951529675722*^9, 3.498951535868933*^9}, {3.5153727628983393`*^9, 
   3.5153727765327635`*^9}, {3.515372812880827*^9, 3.5153728223500433`*^9}, {
   3.5153807143612747`*^9, 3.5153807211160865`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Sin", "[", "u", "]"}], "]"}], 
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"Sin", "[", "u", "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978178569916706`*^9, 3.497819935984581*^9, {
   3.499013365776951*^9, 3.4990134267106576`*^9}, 3.4990137262467837`*^9, {
   3.4990137895984955`*^9, 3.4990138005965147`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Sin", "[", "z", "]"}], "]"}], " ", 
    RowBox[{"Cos", "[", "z", "]"}]}], "=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Sin", "[", "z", "]"}], "]"}], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Sin", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   RowBox[{"Cos", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.4990159735023313`*^9, 3.4990159813959455`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"SubstFor", "[", 
            RowBox[{
             RowBox[{"Sin", "[", 
              RowBox[{"c", "*", 
               RowBox[{"(", 
                RowBox[{"a", "+", 
                 RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
             "x"}], "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", 
       ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x", ",", 
      "True"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Sin", "[", "z", "]"}], "]"}], " ", 
    RowBox[{"Cot", "[", "z", "]"}]}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"f", "[", 
      RowBox[{"Sin", "[", "z", "]"}], "]"}], 
     RowBox[{"Sin", "[", "z", "]"}]], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Sin", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.4990140227097044`*^9, 
   3.4990140412425375`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   RowBox[{"Cot", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"f", "[", "x", "]"}], "x"], " ", 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.499014076264599*^9, 3.4990140852814145`*^9}, {3.499014340607063*^9, 
   3.499014341465064*^9}, {3.4990159855455523`*^9, 3.4990159957635703`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"SubstFor", "[", 
             RowBox[{
              RowBox[{"Sin", "[", 
               RowBox[{"c", "*", 
                RowBox[{"(", 
                 RowBox[{"a", "+", 
                  RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
              "x"}], "]"}], "/", "x"}], ",", "x"}], "]"}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x", ",", 
      "True"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, 3.4990140566397643`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Cos", "[", "u", "]"}], "]"}], 
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"Cos", "[", "u", "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978178569916706`*^9, 3.497819935984581*^9, {
   3.499013365776951*^9, 3.4990134267106576`*^9}, 3.4990137262467837`*^9, {
   3.4990137895984955`*^9, 3.4990138005965147`*^9}, {3.499014556542642*^9, 
   3.4990145567922425`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Cos", "[", "z", "]"}], "]"}], " ", 
    RowBox[{"Sin", "[", "z", "]"}]}], "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"f", "[", 
      RowBox[{"Cos", "[", "z", "]"}], "]"}]}], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Cos", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.499014557665844*^9, 
   3.499014558633046*^9}, {3.4990146074423313`*^9, 3.4990146147119446`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Cos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   RowBox[{"Sin", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", "b"]}]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.499014559210247*^9, 3.499014560520649*^9}, {3.4990148709579945`*^9, 
   3.4990148886952257`*^9}, {3.4990161263357997`*^9, 3.4990161358050165`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Regularize", "[", 
           RowBox[{
            RowBox[{"SubstFor", "[", 
             RowBox[{
              RowBox[{"Cos", "[", 
               RowBox[{"c", "*", 
                RowBox[{"(", 
                 RowBox[{"a", "+", 
                  RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
              "x"}], "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", 
        ",", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x", ",", 
      "True"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, {3.4990145607546496`*^9, 3.4990145612382507`*^9}, 
   3.499014624617962*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Cos", "[", "z", "]"}], "]"}], " ", 
    RowBox[{"Tan", "[", "z", "]"}]}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"f", "[", 
       RowBox[{"Cos", "[", "z", "]"}], "]"}], 
      RowBox[{"Cos", "[", "z", "]"}]]}], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Cos", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.4990140227097044`*^9, 
   3.4990140412425375`*^9}, {3.499014561503451*^9, 3.4990145621586523`*^9}, {
   3.49901479993107*^9, 3.4990148211939073`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Cos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   RowBox[{"Tan", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", "b"]}]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"f", "[", "x", "]"}], "x"], " ", 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.499014076264599*^9, 3.4990140852814145`*^9}, {3.499014340607063*^9, 
   3.499014341465064*^9}, {3.4990145623770523`*^9, 3.4990145625486526`*^9}, {
   3.499014876386804*^9, 3.4990148922520323`*^9}, {3.499016141358626*^9, 
   3.49901614900264*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Tan", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Regularize", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"SubstFor", "[", 
              RowBox[{
               RowBox[{"Cos", "[", 
                RowBox[{"c", "*", 
                 RowBox[{"(", 
                  RowBox[{"a", "+", 
                   RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
               "x"}], "]"}], "/", "x"}], ",", "x"}], "]"}], ",", "x"}], "]"}],
         ",", "x", ",", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x", ",", 
      "True"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, 3.4990140566397643`*^9, {3.499014562735853*^9, 
   3.4990145631258535`*^9}, 3.499014757218195*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Cot", "[", "u", "]"}], "]"}], 
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"Cot", "[", "u", "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978178569916706`*^9, 3.497819935984581*^9, {
   3.499013365776951*^9, 3.4990134267106576`*^9}, 3.4990137262467837`*^9, {
   3.4990137895984955`*^9, 3.4990138005965147`*^9}, {3.4990150904815803`*^9, 
   3.4990150908403807`*^9}, {3.499016244708808*^9, 3.4990162449584084`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Cot", "[", "z", "]"}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", "z", "]"}], "2"]}], "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"f", "[", 
      RowBox[{"Cot", "[", "z", "]"}], "]"}]}], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Cot", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.499015091604782*^9, 
   3.4990150922911835`*^9}, 3.4990152330314307`*^9, {3.499016245364009*^9, 
   3.4990162458632097`*^9}, {3.4990163512369947`*^9, 3.4990163541854*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Cot", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", "b"]}]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Cot", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.499015092634384*^9, 3.4990150929619846`*^9}, {3.499015243483449*^9, 
   3.499015253030666*^9}, {3.4990158796369667`*^9, 3.499015891414987*^9}, {
   3.4990162460816097`*^9, 3.4990162465808105`*^9}, 3.499016373591834*^9, {
   3.4990165083292704`*^9, 3.4990165087972713`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Regularize", "[", 
           RowBox[{
            RowBox[{"SubstFor", "[", 
             RowBox[{
              RowBox[{"Cot", "[", 
               RowBox[{"c", "*", 
                RowBox[{"(", 
                 RowBox[{"a", "+", 
                  RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
              "x"}], "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", 
        ",", 
        RowBox[{"Cot", "[", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x", ",", 
      "True"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonsumQ", "[", "u", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, {3.4990150935391855`*^9, 3.4990150942099867`*^9}, 
   3.4990151653273115`*^9, {3.499016246612011*^9, 3.4990162466744113`*^9}, 
   3.4990163142961297`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Cot", "[", "z", "]"}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", "z", "]"}], "n"]}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"f", "[", 
       RowBox[{"Cot", "[", "z", "]"}], "]"}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Cot", "[", "z", "]"}], "n"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox[
          RowBox[{"Cot", "[", "z", "]"}], "2"]}], ")"}]}]]}], 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Cot", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.4990140227097044`*^9, 
   3.4990140412425375`*^9}, {3.499015094521987*^9, 3.4990150954579887`*^9}, {
   3.499015358627251*^9, 3.4990154123693457`*^9}, {3.499016246705611*^9, 
   3.499016246830411*^9}, {3.4990164208287168`*^9, 3.4990164275523286`*^9}}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9, {3.49901546622064*^9, 
   3.499015466719841*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Cot", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   SuperscriptBox[
    RowBox[{"Tan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", "b"]}]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"f", "[", "x", "]"}], 
        RowBox[{
         SuperscriptBox["x", "n"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox["x", "2"]}], ")"}]}]], " ", 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Cot", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.499014076264599*^9, 3.4990140852814145`*^9}, {3.499014340607063*^9, 
   3.499014341465064*^9}, {3.4990150958167896`*^9, 3.49901509609759*^9}, {
   3.4990154382965913`*^9, 3.499015444099801*^9}, 3.4990155034423056`*^9, {
   3.4990158990122004`*^9, 3.499015911227022*^9}, {3.4990162468616114`*^9, 
   3.4990162468928113`*^9}, 3.499016381173447*^9, {3.499016501933259*^9, 
   3.49901650222966*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Regularize", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"SubstFor", "[", 
              RowBox[{
               RowBox[{"Cot", "[", 
                RowBox[{"c", "*", 
                 RowBox[{"(", 
                  RowBox[{"a", "+", 
                   RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
               "x"}], "]"}], "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"x", "^", "n"}], "*", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 RowBox[{"x", "^", "2"}]}], ")"}]}], ")"}]}], ",", "x"}], 
           "]"}], ",", "x"}], "]"}], ",", "x", ",", 
        RowBox[{"Cot", "[", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x", ",", 
      "True"}], "]"}], " ", "&&", " ", 
    RowBox[{"TryPureTanSubst", "[", 
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{
        RowBox[{"Tan", "[", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], "^", "n"}]}], ",", 
      "x"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, 3.4990140566397643`*^9, {3.4990150963939905`*^9, 
   3.4990150969555917`*^9}, 3.499015172409724*^9, {3.4990162469240117`*^9, 
   3.499016275656062*^9}, 3.4990163228137445`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Cot", "[", "z", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"f", "[", 
       RowBox[{"Cot", "[", "z", "]"}], "]"}], 
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{"Cot", "[", "z", "]"}], "2"]}]]}], 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Cot", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.4990140227097044`*^9, 
   3.4990140412425375`*^9}, {3.499014141223113*^9, 3.499014304336999*^9}, {
   3.4990144633324785`*^9, 3.499014471413293*^9}, {3.4990150974391923`*^9, 
   3.499015098343994*^9}, 3.499015758861554*^9, {3.4990162474856124`*^9, 
   3.499016248312414*^9}, 3.4990164672543983`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Cot", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", "b"]}]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"f", "[", "x", "]"}], 
        RowBox[{"1", "+", 
         SuperscriptBox["x", "2"]}]], " ", 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Cot", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.499014076264599*^9, 3.4990140852814145`*^9}, {3.499014390511551*^9, 
   3.499014431820423*^9}, 3.499014491911729*^9, {3.4990150986715946`*^9, 
   3.4990150991863956`*^9}, 3.499015605747285*^9, {3.4990156487097607`*^9, 
   3.4990157151658773`*^9}, {3.499016248749215*^9, 3.499016249045615*^9}, 
   3.4990163858378553`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"v", "=", 
         RowBox[{"FunctionOfTrig", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[Cot[a+b*x]],x]\>\"", ",", 
          "\"\<Subst[Int[f[x]/(1+x^2),x],x,Cot[a+b*x]]/b\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", 
              RowBox[{"Coefficient", "[", 
               RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"Regularize", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"SubstFor", "[", 
                    RowBox[{
                    RowBox[{"Cot", "[", "v", "]"}], ",", "u", ",", "x"}], 
                    "]"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], 
                 ",", "x"}], "]"}], ",", "x", ",", 
               RowBox[{"Cot", "[", "v", "]"}]}], "]"}]}], "]"}], "]"}]}], 
         "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
         RowBox[{"FunctionOfQ", "[", 
          RowBox[{
           RowBox[{"Cot", "[", "v", "]"}], ",", "u", ",", "x", ",", "True"}], 
          "]"}], " ", "&&", " ", 
         RowBox[{"TryPureTanSubst", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}]}]}], "]"}], " ", "/;", "\n", 
     "SimplifyFlag"}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"v", "=", 
        RowBox[{"FunctionOfTrig", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", 
          RowBox[{"Coefficient", "[", 
           RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
         RowBox[{"Subst", "[", 
          RowBox[{
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{"Regularize", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"SubstFor", "[", 
                 RowBox[{
                  RowBox[{"Cot", "[", "v", "]"}], ",", "u", ",", "x"}], "]"}],
                 "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], ",", 
             "x"}], "]"}], ",", "x", ",", 
           RowBox[{"Cot", "[", "v", "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
       " ", 
       RowBox[{
        RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
        RowBox[{"FunctionOfQ", "[", 
         RowBox[{
          RowBox[{"Cot", "[", "v", "]"}], ",", "u", ",", "x", ",", "True"}], 
         "]"}], " ", "&&", " ", 
        RowBox[{"TryPureTanSubst", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}]}]}], "]"}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, 3.4990140566397643`*^9, 3.4990141257790856`*^9, {
   3.4990150996699963`*^9, 3.4990151017292*^9}, 3.49901518139534*^9, {
   3.4990162492796154`*^9, 3.499016276670064*^9}, 3.499016332267361*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Tan", "[", "u", "]"}], "]"}], 
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"Tan", "[", "u", "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978178569916706`*^9, 3.497819935984581*^9, {
   3.499013365776951*^9, 3.4990134267106576`*^9}, 3.4990137262467837`*^9, {
   3.4990137895984955`*^9, 3.4990138005965147`*^9}, {3.4990150904815803`*^9, 
   3.4990150908403807`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Tan", "[", "z", "]"}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "z", "]"}], "2"]}], "=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Tan", "[", "z", "]"}], "]"}], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Tan", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.499015091604782*^9, 
   3.4990150922911835`*^9}, 3.4990152330314307`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Tan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.499015092634384*^9, 3.4990150929619846`*^9}, {3.499015243483449*^9, 
   3.499015253030666*^9}, {3.4990158796369667`*^9, 3.499015891414987*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"SubstFor", "[", 
            RowBox[{
             RowBox[{"Tan", "[", 
              RowBox[{"c", "*", 
               RowBox[{"(", 
                RowBox[{"a", "+", 
                 RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
             "x"}], "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", 
       ",", 
       RowBox[{"Tan", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x", ",", 
      "True"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonsumQ", "[", "u", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, {3.4990150935391855`*^9, 3.4990150942099867`*^9}, 
   3.4990151653273115`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"Tan", "[", "z", "]"}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Cot", "[", "z", "]"}], "n"]}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"f", "[", 
      RowBox[{"Tan", "[", "z", "]"}], "]"}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Tan", "[", "z", "]"}], "n"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"Tan", "[", "z", "]"}], "2"]}], ")"}]}]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Tan", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.4990140227097044`*^9, 
   3.4990140412425375`*^9}, {3.499015094521987*^9, 3.4990150954579887`*^9}, {
   3.499015358627251*^9, 3.4990154123693457`*^9}}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9, {3.49901546622064*^9, 
   3.499015466719841*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Tan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   SuperscriptBox[
    RowBox[{"Cot", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"f", "[", "x", "]"}], 
        RowBox[{
         SuperscriptBox["x", "n"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox["x", "2"]}], ")"}]}]], " ", 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.499014076264599*^9, 3.4990140852814145`*^9}, {3.499014340607063*^9, 
   3.499014341465064*^9}, {3.4990150958167896`*^9, 3.49901509609759*^9}, {
   3.4990154382965913`*^9, 3.499015444099801*^9}, 3.4990155034423056`*^9, {
   3.4990158990122004`*^9, 3.499015911227022*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"SubstFor", "[", 
             RowBox[{
              RowBox[{"Tan", "[", 
               RowBox[{"c", "*", 
                RowBox[{"(", 
                 RowBox[{"a", "+", 
                  RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
              "x"}], "]"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"x", "^", "n"}], "*", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"x", "^", "2"}]}], ")"}]}], ")"}]}], ",", "x"}], 
          "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"Tan", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x", ",", 
      "True"}], "]"}], " ", "&&", " ", 
    RowBox[{"TryPureTanSubst", "[", 
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{
        RowBox[{"Cot", "[", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], "^", "n"}]}], ",", 
      "x"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, 3.4990140566397643`*^9, {3.4990150963939905`*^9, 
   3.4990150969555917`*^9}, 3.499015172409724*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9, 3.4990134673955293`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Tan", "[", "z", "]"}], "]"}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"f", "[", 
      RowBox[{"Tan", "[", "z", "]"}], "]"}], 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"Tan", "[", "z", "]"}], "2"]}]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "z"], 
     RowBox[{"Tan", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.499013486817563*^9, 
   3.4990134954287786`*^9}, 3.499013543196062*^9, {3.4990140227097044`*^9, 
   3.4990140412425375`*^9}, {3.499014141223113*^9, 3.499014304336999*^9}, {
   3.4990144633324785`*^9, 3.499014471413293*^9}, {3.4990150974391923`*^9, 
   3.499015098343994*^9}, 3.499015758861554*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, 3.4990139034474955`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Tan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"f", "[", "x", "]"}], 
        RowBox[{"1", "+", 
         SuperscriptBox["x", "2"]}]], " ", 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.4990137351075993`*^9, 
   3.4990137374476037`*^9}, {3.499013817148144*^9, 3.4990138763034477`*^9}, {
   3.499014076264599*^9, 3.4990140852814145`*^9}, {3.499014390511551*^9, 
   3.499014431820423*^9}, 3.499014491911729*^9, {3.4990150986715946`*^9, 
   3.4990150991863956`*^9}, 3.499015605747285*^9, {3.4990156487097607`*^9, 
   3.4990157151658773`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"v", "=", 
         RowBox[{"FunctionOfTrig", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[Tan[a+b*x]],x]\>\"", ",", 
          "\"\<Subst[Int[f[x]/(1+x^2),x],x,Tan[a+b*x]]/b\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"Coefficient", "[", 
               RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"Regularize", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"SubstFor", "[", 
                    RowBox[{
                    RowBox[{"Tan", "[", "v", "]"}], ",", "u", ",", "x"}], 
                    "]"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], 
                 ",", "x"}], "]"}], ",", "x", ",", 
               RowBox[{"Tan", "[", "v", "]"}]}], "]"}]}], "]"}], "]"}]}], 
         "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
         RowBox[{"FunctionOfQ", "[", 
          RowBox[{
           RowBox[{"Tan", "[", "v", "]"}], ",", "u", ",", "x", ",", "True"}], 
          "]"}], " ", "&&", " ", 
         RowBox[{"TryPureTanSubst", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}]}]}], "]"}], " ", "/;", "\n", 
     "SimplifyFlag"}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"v", "=", 
        RowBox[{"FunctionOfTrig", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"Coefficient", "[", 
           RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
         RowBox[{"Subst", "[", 
          RowBox[{
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{"Regularize", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"SubstFor", "[", 
                 RowBox[{
                  RowBox[{"Tan", "[", "v", "]"}], ",", "u", ",", "x"}], "]"}],
                 "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], ",", 
             "x"}], "]"}], ",", "x", ",", 
           RowBox[{"Tan", "[", "v", "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
       " ", 
       RowBox[{
        RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
        RowBox[{"FunctionOfQ", "[", 
         RowBox[{
          RowBox[{"Tan", "[", "v", "]"}], ",", "u", ",", "x", ",", "True"}], 
         "]"}], " ", "&&", " ", 
        RowBox[{"TryPureTanSubst", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}]}]}], "]"}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.4990136009005637`*^9, 3.4990140566397643`*^9, 3.4990141257790856`*^9, {
   3.4990150996699963`*^9, 3.4990151017292*^9}, 3.49901518139534*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, {3.497676099158681*^9, 3.4976761165836773`*^9}, {
   3.497676783343814*^9, 3.4976767893021545`*^9}, 3.4979216300334096`*^9, {
   3.50014803844258*^9, 3.5001480688314333`*^9}, {3.5001489164214487`*^9, 
   3.500148916981449*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["\<\
Note: This rule should be moved just before the tangent \[Theta]/2 \
substitution rules for linear trigonometric expressions\
\>", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497676151127653*^9, {3.5001481383451557`*^9, 
   3.5001481405447593`*^9}, {3.5001482079504566`*^9, 
   3.5001482123304625`*^9}, {3.500149419932153*^9, 3.500149423362158*^9}, {
   3.5002594945359473`*^9, 3.500259563456868*^9}, {3.5010148341804357`*^9, 
   3.5010148370804396`*^9}}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic expansion\
\>", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497676151127653*^9, {3.5001481383451557`*^9, 
   3.5001481405447593`*^9}, {3.5001482079504566`*^9, 
   3.5001482123304625`*^9}, {3.500149419932153*^9, 3.500149423362158*^9}}],

Cell[TextData[{
 "Basis: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", "z", "]"}]}]}]], 
     RowBox[{
      RowBox[{"Cos", "[", 
       FractionBox["z", "2"], "]"}], "+", 
      RowBox[{
       FractionBox["a", "b"], 
       RowBox[{"Sin", "[", 
        FractionBox["z", "2"], "]"}]}]}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, 3.497676213204204*^9, {3.4979216146673827`*^9, 
   3.4979216448690357`*^9}, {3.4979823501345844`*^9, 3.4979823501345844`*^9}, 
   3.50014820316045*^9, {3.5001483828607016`*^9, 3.5001483850407047`*^9}, {
   3.5001484251107607`*^9, 3.500148431220769*^9}, {3.5001490951216984`*^9, 
   3.5001490977617025`*^9}, {3.5001491406517625`*^9, 
   3.5001491583617873`*^9}, {3.50101383696904*^9, 3.5010138584590693`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976762514733925`*^9, 3.497676285304328*^9}, {
   3.499116130444688*^9, 3.4991161370846972`*^9}, {3.5001484707308245`*^9, 
   3.5001484897008505`*^9}, {3.5001491942318373`*^9, 3.5001492156318674`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{
    "x", "  ", "\[LongRightArrow]", 
     "                                                                        \
                       ", "\[IndentingNewLine]", 
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{
       RowBox[{"Cos", "[", 
        FractionBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "2"], "]"}], "+", 
       RowBox[{
        FractionBox["a", "b"], 
        RowBox[{"Sin", "[", 
         FractionBox[
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "2"], "]"}]}]}]]}]}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{"u", " ", 
       RowBox[{"Cos", "[", 
        FractionBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "2"], "]"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
        RowBox[{"n", "-", 
         FractionBox["1", "2"]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], "+", 
     RowBox[{
      FractionBox["a", "b"], 
      RowBox[{"\[Integral]", 
       RowBox[{"u", " ", 
        RowBox[{"Sin", "[", 
         FractionBox[
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "2"], "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
         RowBox[{"n", "-", 
          FractionBox["1", "2"]}]], 
        RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], ")"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, 3.4976760887800875`*^9, 3.49767613463171*^9, {
   3.4979216146673827`*^9, 3.4979216448690357`*^9}, 3.497982439709942*^9, {
   3.5001482472205114`*^9, 3.5001482843005633`*^9}, 3.5001483178806105`*^9, {
   3.5001483521006584`*^9, 3.5001483785506954`*^9}, {3.5001484497907953`*^9, 
   3.5001484515307975`*^9}, {3.5001485038708706`*^9, 
   3.5001485116608815`*^9}, {3.500148932771471*^9, 3.5001489476314917`*^9}, {
   3.5001489802415376`*^9, 3.500148985201545*^9}, {3.5001490192415924`*^9, 
   3.500149057751646*^9}, {3.500149448142193*^9, 3.500149528422305*^9}, {
   3.500149576592373*^9, 3.5001495871623874`*^9}, 3.500256685307169*^9, {
   3.5002606017382927`*^9, 3.500260607026702*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u_", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], 
     ",", "x_Symbol"}], "]"}], " ", ":=", "\[IndentingNewLine]", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{
          RowBox[{"c", "/", "2"}], "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "/", "2"}]}]}], "]"}], "+", 
        RowBox[{
         RowBox[{"a", "/", "b"}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"c", "/", "2"}], "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}]}]}], ")"}]}], "*", "\n", 
     "    ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"u", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"c", "/", "2"}], "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "/", "2"}]}]}], "]"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", 
             RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}], " ", 
       "+", "\n", "     ", 
       RowBox[{
        RowBox[{"a", "/", "b"}], "*", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"u", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{
             RowBox[{"c", "/", "2"}], "+", 
             RowBox[{"d", "*", 
              RowBox[{"x", "/", "2"}]}]}], "]"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"Sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"n", "-", 
              RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}]}]}], 
      ")"}]}], " ", "/;", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}],
      " ", "&&", " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "-", 
       RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"n", "-", 
       RowBox[{"1", "/", "2"}]}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976760612205105`*^9, {
   3.4979216146673827`*^9, 3.4979216448690357`*^9}, 3.497982323006137*^9, {
   3.497982386981849*^9, 3.497982393877061*^9}, {3.499116123264678*^9, 
   3.4991161253346806`*^9}, 3.5001480987054863`*^9, {3.500148609121018*^9, 
   3.5001486141710253`*^9}, {3.5001487914012733`*^9, 3.500148819181312*^9}, {
   3.5001490807716784`*^9, 3.5001490834616823`*^9}, {3.5001492360318956`*^9, 
   3.5001492795319567`*^9}, {3.500149382632101*^9, 3.5001494102621393`*^9}, {
   3.500149611882422*^9, 3.500149680812518*^9}, 3.5002567018271923`*^9, {
   3.50025973536917*^9, 3.500259739596778*^9}, {3.500260643062765*^9, 
   3.5002606913604503`*^9}, {3.500260725992511*^9, 3.500260741842139*^9}, {
   3.5002607838998127`*^9, 3.50026078798702*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, {3.497676099158681*^9, 3.4976761165836773`*^9}, {
   3.497676783343814*^9, 3.4976767893021545`*^9}, 3.4979216300334096`*^9, {
   3.50014803844258*^9, 3.5001480688314333`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["\<\
Note: These rules should be moved just before the tangent \[Theta]/2 \
substitution rules for linear trigonometric expressions\
\>", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497676151127653*^9, {3.5001481383451557`*^9, 
   3.5001481405447593`*^9}, {3.5001482079504566`*^9, 
   3.5001482123304625`*^9}, {3.500149419932153*^9, 3.500149423362158*^9}, {
   3.5002594945359473`*^9, 3.500259563456868*^9}}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497676151127653*^9, {3.5001481383451557`*^9, 
   3.5001481405447593`*^9}, {3.5001482079504566`*^9, 3.5001482123304625`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", "z", "]"}]}]}]], 
     RowBox[{"Cos", "[", 
      FractionBox["z", "2"], "]"}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, 3.497676213204204*^9, {3.4979216146673827`*^9, 
   3.4979216448690357`*^9}, {3.4979823501345844`*^9, 3.4979823501345844`*^9}, 
   3.50014820316045*^9, {3.5001483828607016`*^9, 3.5001483850407047`*^9}, {
   3.5001484251107607`*^9, 3.500148431220769*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "-", 
    FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976762514733925`*^9, 3.497676285304328*^9}, {
   3.499116130444688*^9, 3.4991161370846972`*^9}, {3.5001484707308245`*^9, 
   3.5001484897008505`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{"Cos", "[", 
       FractionBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "2"], "]"}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     RowBox[{"Cos", "[", 
      FractionBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "2"], "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", 
       FractionBox["1", "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, 3.4976760887800875`*^9, 3.49767613463171*^9, {
   3.4979216146673827`*^9, 3.4979216448690357`*^9}, 3.497982439709942*^9, {
   3.5001482472205114`*^9, 3.5001482843005633`*^9}, 3.5001483178806105`*^9, {
   3.5001483521006584`*^9, 3.5001483785506954`*^9}, {3.5001484497907953`*^9, 
   3.5001484515307975`*^9}, {3.5001485038708706`*^9, 3.5001485116608815`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u_", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], 
     ",", "x_Symbol"}], "]"}], " ", ":=", "\[IndentingNewLine]", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"c", "/", "2"}], "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "/", "2"}]}]}], "]"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{
          RowBox[{"c", "/", "2"}], "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "/", "2"}]}]}], "]"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", 
           RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}]}], " ", "/;",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}],
      " ", "&&", " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{"a", "-", "b"}], "]"}], " ", "&&", " ", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"n", "-", 
       RowBox[{"1", "/", "2"}]}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976760612205105`*^9, {
   3.4979216146673827`*^9, 3.4979216448690357`*^9}, 3.497982323006137*^9, {
   3.497982386981849*^9, 3.497982393877061*^9}, {3.499116123264678*^9, 
   3.4991161253346806`*^9}, 3.5001480987054863`*^9, {3.500148609121018*^9, 
   3.5001486141710253`*^9}, {3.5001487914012733`*^9, 3.500148819181312*^9}, {
   3.500259744354786*^9, 3.500259747693192*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497676151127653*^9, {3.5001481383451557`*^9, 
   3.5001481405447593`*^9}, {3.5001482079504566`*^9, 3.5001482123304625`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "-", 
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", "z", "]"}]}]}]], 
     RowBox[{"Sin", "[", 
      FractionBox["z", "2"], "]"}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, 3.497676213204204*^9, {3.4979216146673827`*^9, 
   3.4979216448690357`*^9}, {3.4979823501345844`*^9, 3.4979823501345844`*^9}, 
   3.50014820316045*^9, {3.5001483828607016`*^9, 3.5001483850407047`*^9}, {
   3.5001484251107607`*^9, 3.500148431220769*^9}, {3.5001487136311646`*^9, 
   3.50014871736117*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "-", 
    FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976762514733925`*^9, 3.497676285304328*^9}, {
   3.499116130444688*^9, 3.4991161370846972`*^9}, {3.5001484707308245`*^9, 
   3.5001484897008505`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "-", 
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{"a", "-", 
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{"Sin", "[", 
       FractionBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "2"], "]"}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     RowBox[{"Sin", "[", 
      FractionBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "2"], "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", 
       FractionBox["1", "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, 3.4976760887800875`*^9, 3.49767613463171*^9, {
   3.4979216146673827`*^9, 3.4979216448690357`*^9}, 3.497982439709942*^9, {
   3.5001482472205114`*^9, 3.5001482843005633`*^9}, 3.5001483178806105`*^9, {
   3.5001483521006584`*^9, 3.5001483785506954`*^9}, {3.5001484497907953`*^9, 
   3.5001484515307975`*^9}, {3.5001485038708706`*^9, 
   3.5001485116608815`*^9}, {3.5001486957811394`*^9, 
   3.5001487029011497`*^9}, {3.5001487471512117`*^9, 3.500148751101217*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u_", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], 
     ",", "x_Symbol"}], "]"}], " ", ":=", "\[IndentingNewLine]", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"c", "/", "2"}], "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "/", "2"}]}]}], "]"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"c", "/", "2"}], "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "/", "2"}]}]}], "]"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", 
           RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}]}], " ", "/;",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}],
      " ", "&&", " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"n", "-", 
       RowBox[{"1", "/", "2"}]}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976760612205105`*^9, {
   3.4979216146673827`*^9, 3.4979216448690357`*^9}, 3.497982323006137*^9, {
   3.497982386981849*^9, 3.497982393877061*^9}, {3.499116123264678*^9, 
   3.4991161253346806`*^9}, 3.5001480987054863`*^9, {3.500148609121018*^9, 
   3.5001486141710253`*^9}, {3.5001486907611322`*^9, 3.500148691371133*^9}, {
   3.500148766211238*^9, 3.500148784051263*^9}, 3.500148840251342*^9, {
   3.500259751593199*^9, 3.500259755040805*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"c", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, {3.497676099158681*^9, 3.4976761165836773`*^9}, {
   3.497676783343814*^9, 3.4976767893021545`*^9}, 3.4979216300334096`*^9, {
   3.50014803844258*^9, 3.5001480688314333`*^9}, {3.501013623868741*^9, 
   3.5010136290387487`*^9}, {3.5010150310118046`*^9, 
   3.5010150315288343`*^9}, {3.501015071267107*^9, 3.501015071685131*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["\<\
Note: This rule should be moved just before the tangent \[Theta]/2 \
substitution rules for linear trigonometric expressions\
\>", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497676151127653*^9, {3.5001481383451557`*^9, 
   3.5001481405447593`*^9}, {3.5001482079504566`*^9, 
   3.5001482123304625`*^9}, {3.500149419932153*^9, 3.500149423362158*^9}, {
   3.5002594945359473`*^9, 3.500259563456868*^9}, {3.501013683568825*^9, 
   3.501013685678828*^9}, 3.50101484449045*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic expansion\
\>", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497676151127653*^9, {3.5001481383451557`*^9, 
   3.5001481405447593`*^9}, {3.5001482079504566`*^9, 
   3.5001482123304625`*^9}, {3.500149419932153*^9, 3.500149423362158*^9}}],

Cell[TextData[{
 "Basis: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", "z", "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", "z", "]"}]}]}]], 
     RowBox[{
      RowBox[{"c", " ", 
       RowBox[{"Cos", "[", 
        FractionBox["z", "2"], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "-", "b"}], ")"}], " ", 
       RowBox[{"Sin", "[", 
        FractionBox["z", "2"], "]"}]}]}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, 3.497676213204204*^9, {3.4979216146673827`*^9, 
   3.4979216448690357`*^9}, {3.4979823501345844`*^9, 3.4979823501345844`*^9}, 
   3.50014820316045*^9, {3.5001483828607016`*^9, 3.5001483850407047`*^9}, {
   3.5001484251107607`*^9, 3.500148431220769*^9}, {3.5001490951216984`*^9, 
   3.5001490977617025`*^9}, {3.5001491406517625`*^9, 
   3.5001491583617873`*^9}, {3.50101383696904*^9, 3.5010138584590693`*^9}, 
   3.501013999019266*^9, 3.501014041349326*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976762514733925`*^9, 3.497676285304328*^9}, {
   3.499116130444688*^9, 3.4991161370846972`*^9}, {3.5001484707308245`*^9, 
   3.5001484897008505`*^9}, {3.5001491942318373`*^9, 
   3.5001492156318674`*^9}, {3.501013712288865*^9, 3.501013716708871*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"u", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                      ", 
      "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"c", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"c", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}]]}], 
       RowBox[{
        RowBox[{"c", " ", 
         RowBox[{"Cos", "[", 
          FractionBox[
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "2"], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], 
         RowBox[{"Sin", "[", 
          FractionBox[
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "2"], "]"}]}]}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{"u", " ", 
      RowBox[{"Cos", "[", 
       FractionBox[
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "2"], "]"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "-", 
        FractionBox["1", "2"]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", "\[IndentingNewLine]", 
  "     ", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}]]}], 
    RowBox[{
     RowBox[{"c", " ", 
      RowBox[{"Cos", "[", 
       FractionBox[
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "2"], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], 
      RowBox[{"Sin", "[", 
       FractionBox[
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], "2"], "]"}]}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     RowBox[{"Sin", "[", 
      FractionBox[
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], "2"], "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", 
       FractionBox["1", "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, 3.4976760887800875`*^9, 3.49767613463171*^9, {
   3.4979216146673827`*^9, 3.4979216448690357`*^9}, 3.497982439709942*^9, {
   3.5001482472205114`*^9, 3.5001482843005633`*^9}, 3.5001483178806105`*^9, {
   3.5001483521006584`*^9, 3.5001483785506954`*^9}, {3.5001484497907953`*^9, 
   3.5001484515307975`*^9}, {3.5001485038708706`*^9, 
   3.5001485116608815`*^9}, {3.500148932771471*^9, 3.5001489476314917`*^9}, {
   3.5001489802415376`*^9, 3.500148985201545*^9}, {3.5001490192415924`*^9, 
   3.500149057751646*^9}, {3.500149448142193*^9, 3.500149528422305*^9}, {
   3.500149576592373*^9, 3.5001495871623874`*^9}, 3.500256685307169*^9, {
   3.5002606017382927`*^9, 3.500260607026702*^9}, {3.501014085219387*^9, 
   3.501014128929448*^9}, {3.5010142219695787`*^9, 3.501014229129589*^9}, {
   3.501014297969685*^9, 3.5010143351197367`*^9}, {3.501015035362054*^9, 
   3.501015077626471*^9}, {3.5010220453059998`*^9, 3.50102209128963*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u_", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d_.", "+", 
            RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
         RowBox[{"c_.", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d_.", "+", 
            RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], 
     ",", "x_Symbol"}], "]"}], " ", ":=", "\[IndentingNewLine]", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"c", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], ")"}], "/", "2"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "b"}], ")"}], "*", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], ")"}], "/", "2"}], "]"}]}]}], 
        ")"}]}], "*", "\n", "    ", 
      RowBox[{"Dist", "[", 
       RowBox[{"c", ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"u", "*", 
           RowBox[{"Cos", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"Cos", "[", 
                RowBox[{"d", "+", 
                 RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
              RowBox[{"c", "*", 
               RowBox[{"Sin", "[", 
                RowBox[{"d", "+", 
                 RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"n", "-", 
              RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
       "]"}]}], " ", "+", " ", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"c", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], ")"}], "/", "2"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "-", "b"}], ")"}], "*", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", "x"}]}], ")"}], "/", "2"}], "]"}]}]}], 
        ")"}]}], "*", "\n", "    ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"a", "-", "b"}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"u", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"d", "+", 
               RowBox[{"e", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"Cos", "[", 
                RowBox[{"d", "+", 
                 RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
              RowBox[{"c", "*", 
               RowBox[{"Sin", "[", 
                RowBox[{"d", "+", 
                 RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"n", "-", 
              RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], " ", "/;", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
       "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "-", 
       RowBox[{"b", "^", "2"}], "-", 
       RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"n", "-", 
       RowBox[{"1", "/", "2"}]}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976760612205105`*^9, {
   3.4979216146673827`*^9, 3.4979216448690357`*^9}, 3.497982323006137*^9, {
   3.497982386981849*^9, 3.497982393877061*^9}, {3.499116123264678*^9, 
   3.4991161253346806`*^9}, 3.5001480987054863`*^9, {3.500148609121018*^9, 
   3.5001486141710253`*^9}, {3.5001487914012733`*^9, 3.500148819181312*^9}, {
   3.5001490807716784`*^9, 3.5001490834616823`*^9}, {3.5001492360318956`*^9, 
   3.5001492795319567`*^9}, {3.500149382632101*^9, 3.5001494102621393`*^9}, {
   3.500149611882422*^9, 3.500149680812518*^9}, 3.5002567018271923`*^9, {
   3.50025973536917*^9, 3.500259739596778*^9}, {3.500260643062765*^9, 
   3.5002606913604503`*^9}, {3.500260725992511*^9, 3.500260741842139*^9}, {
   3.5002607838998127`*^9, 3.50026078798702*^9}, {3.501014352069761*^9, 
   3.501014355559766*^9}, {3.501014580670081*^9, 3.5010145904900947`*^9}, {
   3.501014819420415*^9, 3.501014823730421*^9}, {3.501014995974801*^9, 
   3.5010150000990367`*^9}, {3.501015046893713*^9, 3.5010150856369295`*^9}, {
   3.501015150927664*^9, 3.50101516991975*^9}, {3.501015448593689*^9, 
   3.501015454624034*^9}, {3.5010220581657352`*^9, 3.501022061906949*^9}, {
   3.5010221539452133`*^9, 3.501022177581565*^9}, {3.501022725821923*^9, 
   3.50102273137724*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Trig Substitution Integration Rules", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1380, 28, 118, "Title"],
Cell[1950, 52, 282, 4, 93, "Subsubsection"],
Cell[2235, 58, 735, 20, 139, "Subsubsection"],
Cell[2973, 80, 1288, 26, 104, "Subsubsection"],
Cell[4264, 108, 1969, 50, 216, "Subsubtitle"],
Cell[6236, 160, 771, 11, 93, "Subsubsection"],
Cell[7010, 173, 2551, 70, 351, "Code"],
Cell[9564, 245, 89, 2, 93, "Subsubsection"],
Cell[9656, 249, 282, 4, 65, "Subsubsection"],
Cell[9941, 255, 727, 20, 139, "Subsubsection"],
Cell[10671, 277, 1185, 25, 104, "Subsubsection"],
Cell[11859, 304, 2060, 51, 216, "Subsubtitle"],
Cell[13922, 357, 771, 11, 93, "Subsubsection"],
Cell[14696, 370, 2607, 71, 351, "Code"],
Cell[17306, 443, 44, 1, 8, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[17387, 449, 1375, 27, 80, "Title"],
Cell[18765, 478, 305, 4, 67, "Subsubsection"],
Cell[19073, 484, 754, 20, 50, "Subsubsection"],
Cell[19830, 506, 936, 13, 47, "Subsubsection"],
Cell[20769, 521, 1521, 36, 114, "Subsubtitle"],
Cell[22293, 559, 771, 11, 67, "Subsubsection"],
Cell[23067, 572, 1912, 57, 202, "Code"],
Cell[24982, 631, 89, 2, 67, "Subsubsection"],
Cell[25074, 635, 305, 4, 47, "Subsubsection"],
Cell[25382, 641, 866, 23, 75, "Subsubsection"],
Cell[26251, 666, 936, 13, 47, "Subsubsection"],
Cell[27190, 681, 1651, 38, 114, "Subsubtitle"],
Cell[28844, 721, 771, 11, 67, "Subsubsection"],
Cell[29618, 734, 1976, 58, 202, "Code"],
Cell[31597, 794, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[31678, 800, 1427, 28, 80, "Title"],
Cell[33108, 830, 305, 4, 67, "Subsubsection"],
Cell[33416, 836, 876, 22, 50, "Subsubsection"],
Cell[34295, 860, 936, 13, 47, "Subsubsection"],
Cell[35234, 875, 1643, 38, 114, "Subsubtitle"],
Cell[36880, 915, 771, 11, 67, "Subsubsection"],
Cell[37654, 928, 2032, 59, 202, "Code"],
Cell[39689, 989, 89, 2, 67, "Subsubsection"],
Cell[39781, 993, 305, 4, 47, "Subsubsection"],
Cell[40089, 999, 989, 25, 75, "Subsubsection"],
Cell[41081, 1026, 936, 13, 47, "Subsubsection"],
Cell[42020, 1041, 1774, 41, 114, "Subsubtitle"],
Cell[43797, 1084, 771, 11, 67, "Subsubsection"],
Cell[44571, 1097, 2095, 60, 202, "Code"],
Cell[46669, 1159, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[46750, 1165, 1477, 28, 80, "Title"],
Cell[48230, 1195, 305, 4, 7279, "Subsubsection"],
Cell[48538, 1201, 977, 24, 5361, "Subsubsection"],
Cell[49518, 1227, 936, 13, 4989, "Subsubsection"],
Cell[50457, 1242, 1797, 41, 12496, "Subsubtitle"],
Cell[52257, 1285, 771, 11, 7279, "Subsubsection"],
Cell[53031, 1298, 2199, 62, 22264, "Code"],
Cell[55233, 1362, 89, 2, 7279, "Subsubsection"],
Cell[55325, 1366, 305, 4, 4989, "Subsubsection"],
Cell[55633, 1372, 1387, 36, 8887, "Subsubsection"],
Cell[57023, 1410, 1096, 20, 5361, "Subsubsection"],
Cell[58122, 1432, 2105, 49, 14265, "Subsubtitle"],
Cell[60230, 1483, 771, 11, 7279, "Subsubsection"],
Cell[61004, 1496, 2799, 79, 22264, "Code"],
Cell[63806, 1577, 89, 2, 7279, "Subsubsection"],
Cell[63898, 1581, 305, 4, 4989, "Subsubsection"],
Cell[64206, 1587, 1133, 27, 8115, "Subsubsection"],
Cell[65342, 1616, 936, 13, 4989, "Subsubsection"],
Cell[66281, 1631, 1822, 41, 12948, "Subsubtitle"],
Cell[68106, 1674, 771, 11, 7279, "Subsubsection"],
Cell[68880, 1687, 4051, 99, 76711, "Code"],
Cell[72934, 1788, 44, 1, 527, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[73015, 1794, 1429, 28, 80, "Title"],
Cell[74447, 1824, 305, 4, 130, "Subsubsection"],
Cell[74755, 1830, 857, 22, 96, "Subsubsection"],
Cell[75615, 1854, 936, 13, 90, "Subsubsection"],
Cell[76554, 1869, 1645, 38, 222, "Subsubtitle"],
Cell[78202, 1909, 771, 11, 130, "Subsubsection"],
Cell[78976, 1922, 2079, 60, 394, "Code"],
Cell[81058, 1984, 89, 2, 130, "Subsubsection"],
Cell[81150, 1988, 305, 4, 90, "Subsubsection"],
Cell[81458, 1994, 1257, 34, 158, "Subsubsection"],
Cell[82718, 2030, 1096, 20, 96, "Subsubsection"],
Cell[83817, 2052, 1958, 46, 253, "Subsubtitle"],
Cell[85778, 2100, 771, 11, 130, "Subsubsection"],
Cell[86552, 2113, 2672, 77, 394, "Code"],
Cell[89227, 2192, 89, 2, 130, "Subsubsection"],
Cell[89319, 2196, 305, 4, 90, "Subsubsection"],
Cell[89627, 2202, 1031, 25, 145, "Subsubsection"],
Cell[90661, 2229, 936, 13, 90, "Subsubsection"],
Cell[91600, 2244, 1726, 39, 230, "Subsubtitle"],
Cell[93329, 2285, 771, 11, 130, "Subsubsection"],
Cell[94103, 2298, 3921, 96, 1355, "Code"],
Cell[98027, 2396, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[98108, 2402, 1549, 31, 80, "Title"],
Cell[99660, 2435, 705, 12, 692, "Subsubsection"],
Cell[100368, 2449, 540, 9, 475, "Subsubsection"],
Cell[100911, 2460, 1287, 35, 998, "Subsubsection"],
Cell[102201, 2497, 1342, 26, 771, "Subsubsection"],
Cell[103546, 2525, 3460, 89, 3163, "Subsubtitle"],
Cell[107009, 2616, 771, 11, 692, "Subsubsection"],
Cell[107783, 2629, 4060, 107, 3144, "Code"],
Cell[111846, 2738, 44, 1, 51, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[111927, 2744, 1497, 30, 80, "Title"],
Cell[113427, 2776, 653, 11, 692, "Subsubsection"],
Cell[114083, 2789, 458, 6, 475, "Subsubsection"],
Cell[114544, 2797, 853, 21, 998, "Subsubsection"],
Cell[115400, 2820, 1148, 21, 737, "Subsubsection"],
Cell[116551, 2843, 2141, 54, 1693, "Subsubtitle"],
Cell[118695, 2899, 771, 11, 692, "Subsubsection"],
Cell[119469, 2912, 2505, 67, 2113, "Code"],
Cell[121977, 2981, 89, 2, 692, "Subsubsection"],
Cell[122069, 2985, 458, 6, 475, "Subsubsection"],
Cell[122530, 2993, 904, 22, 998, "Subsubsection"],
Cell[123437, 3017, 1148, 21, 737, "Subsubsection"],
Cell[124588, 3040, 2247, 56, 1693, "Subsubtitle"],
Cell[126838, 3098, 771, 11, 692, "Subsubsection"],
Cell[127612, 3111, 2577, 68, 2113, "Code"],
Cell[130192, 3181, 44, 1, 51, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[130273, 3187, 1780, 36, 80, "Title"],
Cell[132056, 3225, 722, 12, 253, "Subsubsection"],
Cell[132781, 3239, 540, 9, 174, "Subsubsection"],
Cell[133324, 3250, 1510, 41, 365, "Subsubsection"],
Cell[134837, 3293, 1428, 28, 282, "Subsubsection"],
Cell[136268, 3323, 5112, 138, 1794, "Subsubtitle"],
Cell[141383, 3463, 771, 11, 253, "Subsubsection"],
Cell[142157, 3476, 6357, 164, 1338, "Code"],
Cell[148517, 3642, 44, 1, 20, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}
]
*)

(* End of internal cache information *)
