(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    431488,      10976]
NotebookOptionsPosition[    415532,      10606]
NotebookOutlinePosition[    416643,      10645]
CellTagsIndexPosition[    416600,      10642]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, {3.498320501706756*^9, 3.4983205022215567`*^9}, 
   3.498331990236905*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4983206021865325`*^9, 3.498332035446968*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.498070579139242*^9, 3.49807059487967*^9}, {3.4983253783384385`*^9, 
   3.4983254083060913`*^9}, {3.4983320992270575`*^9, 3.498332105357066*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SuperscriptBox["x", "m"], " ", 
         RowBox[{"ArcTan", "[", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"\[ImaginaryI]", " ", "a"}], "+", 
            RowBox[{"\[ImaginaryI]", " ", "b", " ", "x"}]}]], "]"}]}], 
        "b"]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "\[ImaginaryI]", " ", "m"}], "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     RowBox[{"ArcTan", "[", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "a"}], "+", 
        RowBox[{"\[ImaginaryI]", " ", "b", " ", "x"}]}]], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.4983205558700514`*^9, 3.4983205610648603`*^9}, {
   3.4983320657270107`*^9, 3.4983320747870235`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Sec", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", "I", "*", 
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"I", "*", "a"}], "+", 
          RowBox[{"I", "*", "b", "*", "x"}]}], ")"}]}], "]"}], "/", "b"}]}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "I", "*", 
       RowBox[{"m", "/", "b"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"ArcTan", "[", 
          RowBox[{"E", "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"I", "*", "a"}], "+", 
             RowBox[{"I", "*", "b", "*", "x"}]}], ")"}]}], "]"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.498332020206947*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Csc", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", 
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{
      RowBox[{"ArcTanh", "[", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"I", "*", "a"}], "+", 
          RowBox[{"I", "*", "b", "*", "x"}]}], ")"}]}], "]"}], "/", "b"}]}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"m", "/", "b"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"ArcTanh", "[", 
          RowBox[{"E", "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"I", "*", "a"}], "+", 
             RowBox[{"I", "*", "b", "*", "x"}]}], ")"}]}], "]"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.498332020206947*^9, 3.498347135523964*^9, {
   3.498347213204073*^9, 3.498347213204073*^9}, 3.498348608116026*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 430, A&S 4.3.125", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.4983207715092297`*^9, 3.49833223686725*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.498070579139242*^9, 3.49807059487967*^9}, {3.4983253783384385`*^9, 
   3.4983254083060913`*^9}, {3.4983320992270575`*^9, 3.498332105357066*^9}, {
   3.4983323632374268`*^9, 3.498332364057428*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", "m"], " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], "b"]}]}]}]}], "-", 
  RowBox[{
   FractionBox["m", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498332278987309*^9, 3.498332289127323*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "2"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"Tan", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.498331997476915*^9, 3.4983322285172386`*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: CRC 428, A&S 4.3.121", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.4983207715092297`*^9, 3.49833223686725*^9, 3.4983488095863075`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "2"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", "m"}]}], "*", 
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"Cot", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.498331997476915*^9, 3.4983322285172386`*^9, 
   3.498347135533964*^9, {3.4983472132340727`*^9, 3.4983472132340727`*^9}, 
   3.4983486187760406`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: G&R 2.643.2 special case when ",
 Cell[BoxData[
  RowBox[{"m", "=", "1"}]]],
 ", CRC 431, A&S 4.3.126"
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4980704231233683`*^9, 
   3.4980705306387577`*^9, 3.498325256642625*^9, 3.498332429137519*^9, {
   3.498332733347945*^9, 3.498332749677968*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", "2"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.498070579139242*^9, 3.49807059487967*^9}, {3.4983253783384385`*^9, 
   3.4983254083060913`*^9}, {3.4983324529175525`*^9, 3.498332460397563*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "-", "2"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]]}]}]}]}], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"n", "-", "2"}]], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"n", "-", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "-", "2"}], ")"}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "2"}], 
    RowBox[{"n", "-", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{"x", " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4980704970362988`*^9, 3.498070514508329*^9}, {
   3.4983253487451863`*^9, 3.498325362520011*^9}, {3.4983324045574846`*^9, 
   3.498332412897496*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "-", "2"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.498320521643591*^9, 3.498325246845807*^9, {3.498325723613845*^9, 
   3.4983257282158527`*^9}, 3.498332000356919*^9, 3.498332378997449*^9, {
   3.4983324734275813`*^9, 3.4983324758775845`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.643.1 special case when ",
 Cell[BoxData[
  RowBox[{"m", "=", "1"}]]],
 ", ",
 "CRC 429', A&S 4.3.122"
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4980704231233683`*^9, 
   3.4980705306387577`*^9, 3.498325256642625*^9, 3.498332429137519*^9, {
   3.498332733347945*^9, 3.498332749677968*^9}, {3.4983487773662624`*^9, 
   3.498348786866276*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "-", "2"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.498320521643591*^9, 3.498325246845807*^9, {3.498325723613845*^9, 
   3.4983257282158527`*^9}, 3.498332000356919*^9, 3.498332378997449*^9, {
   3.4983324734275813`*^9, 3.4983324758775845`*^9}, {3.498347135533964*^9, 
   3.498347135543964*^9}, 3.498347213254073*^9, {3.4983486328260603`*^9, 
   3.4983486381360674`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.643.2", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.4980705234471445`*^9, 3.4980706229285192`*^9, 3.4983254541701717`*^9, 
   3.4983325229576507`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", "2"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.498070579139242*^9, 3.49807059487967*^9}, {3.4983253783384385`*^9, 
   3.4983254083060913`*^9}, {3.4983257109154224`*^9, 3.498325711726624*^9}, {
   3.498332537277671*^9, 3.498332556087697*^9}, {3.4983326120577755`*^9, 
   3.4983326249677935`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", "m"], " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "-", "2"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"m", " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "-", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"n", "-", "2"}]]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"n", "-", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "-", "2"}], ")"}]}]], "+", "                          ", 
  "\[IndentingNewLine]", "                                            ", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "2"}], 
    RowBox[{"n", "-", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", "1"}], ")"}]}], 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"n", "-", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"n", "-", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4980704970362988`*^9, 3.498070514508329*^9}, 
   3.498070660243785*^9, {3.498325497288647*^9, 3.498325508739067*^9}, 
   3.4983325809177313`*^9, {3.498332688167882*^9, 3.4983327013879004`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"m", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.498320518570386*^9, 3.4983254473373594`*^9, {
   3.4983257317882595`*^9, 3.498325739588273*^9}, 3.498332003116923*^9, 
   3.498332516747642*^9, {3.498332568227714*^9, 3.498332595577752*^9}},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.643.1", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.4980705234471445`*^9, 3.4980706229285192`*^9, 3.4983254541701717`*^9, 
   3.4983325229576507`*^9, 3.4983487586662364`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", "m"}]}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"m", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.498320518570386*^9, 3.4983254473373594`*^9, {
   3.4983257317882595`*^9, 3.498325739588273*^9}, 3.498332003116923*^9, 
   3.498332516747642*^9, {3.498332568227714*^9, 3.498332595577752*^9}, {
   3.4983471355539637`*^9, 3.498347135563964*^9}, 3.4983472132740726`*^9, {
   3.4983486514460864`*^9, 3.498348673176117*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: G&R 2.631.3 special case when ",
 Cell[BoxData[
  RowBox[{"m", "=", "1"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4980704231233683`*^9, 
   3.4980705306387577`*^9, 3.498325256642625*^9, 3.498332429137519*^9, {
   3.498332733347945*^9, 3.498332749677968*^9}, {3.498332875418144*^9, 
   3.4983328861181593`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "<", 
   RowBox[{"-", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.498070579139242*^9, 3.49807059487967*^9}, {3.4983253783384385`*^9, 
   3.4983254083060913`*^9}, {3.4983324529175525`*^9, 3.498332460397563*^9}, {
   3.4983328556681166`*^9, 3.4983328600981226`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"Sec", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["n", "2"]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"n", "+", "1"}]]}], 
   RowBox[{"b", " ", "n"}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "+", "1"}], "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{"x", " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4980704970362988`*^9, 3.498070514508329*^9}, {
   3.4983253487451863`*^9, 3.498325362520011*^9}, {3.4983324045574846`*^9, 
   3.498332412897496*^9}, 3.498332840608095*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}]}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.498320521643591*^9, 3.498325246845807*^9, {3.498325723613845*^9, 
   3.4983257282158527`*^9}, 3.498332000356919*^9, 3.498332378997449*^9, {
   3.4983324734275813`*^9, 3.4983324758775845`*^9}, 3.4983328149380593`*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.631.2 special case when ",
 Cell[BoxData[
  RowBox[{"m", "=", "1"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4980704231233683`*^9, 
   3.4980705306387577`*^9, 3.498325256642625*^9, 3.498332429137519*^9, {
   3.498332733347945*^9, 3.498332749677968*^9}, {3.498332875418144*^9, 
   3.4983328861181593`*^9}, {3.4983487377262073`*^9, 3.4983487387162085`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.498320521643591*^9, 3.498325246845807*^9, {3.498325723613845*^9, 
   3.4983257282158527`*^9}, 3.498332000356919*^9, 3.498332378997449*^9, {
   3.4983324734275813`*^9, 3.4983324758775845`*^9}, 3.4983328149380593`*^9, {
   3.498347135573964*^9, 3.498347135573964*^9}, 3.498347528314514*^9, 
   3.498348686756136*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.631.3", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.4980705234471445`*^9, 3.4980706229285192`*^9, 3.4983254541701717`*^9, 
   3.4983325229576507`*^9, 3.498332914798199*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.498070579139242*^9, 3.49807059487967*^9}, {3.4983253783384385`*^9, 
   3.4983254083060913`*^9}, {3.4983257109154224`*^9, 3.498325711726624*^9}, {
   3.498332537277671*^9, 3.498332556087697*^9}, {3.4983326120577755`*^9, 
   3.4983326249677935`*^9}, {3.4983329276982174`*^9, 3.4983329308982215`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"m", " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "-", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], "n"]}], 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["n", "2"]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"n", "+", "1"}]]}], 
   RowBox[{"b", " ", "n"}]], "+", "                      ", 
  "\[IndentingNewLine]", 
  "                                                                      ", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "+", "1"}], "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", "1"}], ")"}]}], 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4980704970362988`*^9, 3.498070514508329*^9}, 
   3.498070660243785*^9, {3.498325497288647*^9, 3.498325508739067*^9}, 
   3.4983325809177313`*^9, {3.498332688167882*^9, 3.4983327013879004`*^9}, {
   3.498332965828271*^9, 3.498332977038286*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"m", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.498320518570386*^9, 3.4983254473373594`*^9, {
   3.4983257317882595`*^9, 3.498325739588273*^9}, 3.498332003116923*^9, 
   3.498332516747642*^9, {3.498332568227714*^9, 3.498332595577752*^9}, 
   3.49833280787805*^9, {3.4983329098781924`*^9, 3.49833292266821*^9}},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.631.2", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.4980705234471445`*^9, 3.4980706229285192`*^9, 3.4983254541701717`*^9, 
   3.4983325229576507`*^9, 3.498332914798199*^9, 3.498348712966172*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"m", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.498320518570386*^9, 3.4983254473373594`*^9, {
   3.4983257317882595`*^9, 3.498325739588273*^9}, 3.498332003116923*^9, 
   3.498332516747642*^9, {3.498332568227714*^9, 3.498332595577752*^9}, 
   3.49833280787805*^9, {3.4983329098781924`*^9, 3.49833292266821*^9}, {
   3.4983471355839643`*^9, 3.498347135593964*^9}, 3.498347528324514*^9, 
   3.4983487044961605`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sec", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "n"]}]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, {3.498320501706756*^9, 3.4983205022215567`*^9}, 
   3.4983363352582846`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4983206021865325`*^9, 3.498336379671563*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", "b"}], "=", "0"}]]],
 ", then  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", "z", "]"}], "2"]}]}], "=", 
   RowBox[{"b", " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", "z", "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, {3.4983206471458116`*^9, 
   3.4983206654446435`*^9}, {3.4983363975959945`*^9, 3.4983364187184315`*^9}, 
   3.498336544688653*^9, {3.4988871530692167`*^9, 3.498887164755885*^9}, {
   3.498887228386524*^9, 3.4988872314487*^9}, {3.49888727673629*^9, 
   3.4988872791254263`*^9}}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", "b"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983365404610453`*^9, 3.498336572612702*^9}, {
   3.4988873903157864`*^9, 3.498887396069115*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sec", "[", "v", "]"}], "2"]}]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox["b", "m"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox[
      RowBox[{"Tan", "[", "v", "]"}], 
      RowBox[{"2", "m"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.4983205558700514`*^9, 3.4983205610648603`*^9}, 
   3.498336457110099*^9, {3.498336504112982*^9, 3.498336507076987*^9}, 
   3.4988870875554695`*^9, {3.498887425032772*^9, 3.4988874530183725`*^9}, {
   3.498887531861882*^9, 3.498887558849426*^9}, {3.4988877813521523`*^9, 
   3.498887783848295*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"Sec", "[", "v_", "]"}], "^", "2"}]}]}], ")"}], "^", 
      "m_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"b", "^", "m"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"Tan", "[", "v", "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "m"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983363703739467`*^9, {3.4988870949248905`*^9, 
   3.4988871260116687`*^9}, {3.4988873078350687`*^9, 
   3.4988873773550453`*^9}, {3.4988875045363193`*^9, 
   3.4988875061614122`*^9}, {3.4988876000257807`*^9, 3.498887611762452*^9}, {
   3.498887747166197*^9, 3.498887757063763*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"Csc", "[", "v_", "]"}], "^", "2"}]}]}], ")"}], "^", 
      "m_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"b", "^", "m"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"Cot", "[", "v", "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "m"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983363703739467`*^9, {3.4988870949248905`*^9, 
   3.4988871260116687`*^9}, {3.4988873078350687`*^9, 
   3.4988873773550453`*^9}, {3.4988875045363193`*^9, 
   3.4988875061614122`*^9}, {3.4988876000257807`*^9, 3.498887611762452*^9}, {
   3.498887747166197*^9, 3.498887757063763*^9}, {3.4988878811128583`*^9, 
   3.498887897984823*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4983206021865325`*^9, 3.498336379671563*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", "b"}], "=", "0"}]]],
 ", then  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", "z", "]"}], "2"]}]}], "=", 
   RowBox[{"b", " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", "z", "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, {3.4983206471458116`*^9, 
   3.4983206654446435`*^9}, {3.4983363975959945`*^9, 3.4983364187184315`*^9}, 
   3.498336544688653*^9, {3.4988871530692167`*^9, 3.498887164755885*^9}, {
   3.498887228386524*^9, 3.4988872314487*^9}, {3.49888727673629*^9, 
   3.4988872791254263`*^9}}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", "b"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983365404610453`*^9, 3.498336572612702*^9}, {
   3.4988873903157864`*^9, 3.498887396069115*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sec", "[", "v", "]"}], "2"]}]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{"u", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Tan", "[", "v", "]"}], "2"]}], ")"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.4983205558700514`*^9, 3.4983205610648603`*^9}, 
   3.498336457110099*^9, {3.498336504112982*^9, 3.498336507076987*^9}, 
   3.4988870875554695`*^9, {3.498887425032772*^9, 3.4988874530183725`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"Sec", "[", "v_", "]"}], "^", "2"}]}]}], ")"}], "^", 
      "m_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Tan", "[", "v", "]"}], "^", "2"}]}], ")"}], "^", "m"}]}], 
     ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "m", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983363703739467`*^9, {3.4988870949248905`*^9, 
   3.4988871260116687`*^9}, {3.4988873078350687`*^9, 3.4988873773550453`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"Csc", "[", "v_", "]"}], "^", "2"}]}]}], ")"}], "^", 
      "m_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Cot", "[", "v", "]"}], "^", "2"}]}], ")"}], "^", "m"}]}], 
     ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "m", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983363703739467`*^9, {3.4988870949248905`*^9, 
   3.4988871260116687`*^9}, {3.4988873078350687`*^9, 
   3.4988873773550453`*^9}, {3.498887886060141*^9, 3.4988879021900635`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4983206021865325`*^9, 3.498336379671563*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", "z", "]"}], "n"]}]}], "=", 
   FractionBox[
    RowBox[{"b", "+", 
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "z", "]"}], "n"]}]}], 
    SuperscriptBox[
     RowBox[{"Cos", "[", "z", "]"}], "n"]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, {3.4983206471458116`*^9, 
   3.4983206654446435`*^9}, {3.4983363975959945`*^9, 3.4983364187184315`*^9}, 
   3.498336544688653*^9}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983365404610453`*^9, 3.498336572612702*^9}, {
   3.5002611047923765`*^9, 3.5002611047923765`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sec", "[", "v", "]"}], "n"]}]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"a", " ", 
            SuperscriptBox[
             RowBox[{"Cos", "[", "v", "]"}], "n"]}]}], ")"}], "m"], 
        SuperscriptBox[
         RowBox[{"Cos", "[", "v", "]"}], 
         RowBox[{"m", " ", "n"}]]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.4983205558700514`*^9, 3.4983205610648603`*^9}, 
   3.498336457110099*^9, {3.498336504112982*^9, 3.498336507076987*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"Sec", "[", "v_", "]"}], "^", "n_"}]}]}], ")"}], "^", "m_"}],
     ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"a", "*", 
          RowBox[{
           RowBox[{"Cos", "[", "v", "]"}], "^", "n"}]}]}], ")"}], "^", "m"}], 
      "/", 
      RowBox[{
       RowBox[{"Cos", "[", "v", "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", "0"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983363703739467`*^9, {3.500261086321944*^9, 
   3.500261091454353*^9}, 3.5171907440535884`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"Csc", "[", "v_", "]"}], "^", "n_"}]}]}], ")"}], "^", "m_"}],
     ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"a", "*", 
          RowBox[{
           RowBox[{"Sin", "[", "v", "]"}], "^", "n"}]}]}], ")"}], "^", "m"}], 
      "/", 
      RowBox[{
       RowBox[{"Sin", "[", "v", "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", "0"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983363703739467`*^9, 3.4983471356839647`*^9, 
   3.4983518122505116`*^9, {3.500261216925373*^9, 3.5002612239609857`*^9}, 
   3.5171907440535884`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4980704231233683`*^9, 
   3.498320797873276*^9, 3.4983366331564083`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", "z", "]"}], "n"]}]}], "=", 
   FractionBox[
    RowBox[{"b", "+", 
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "z", "]"}], "n"]}]}], 
    SuperscriptBox[
     RowBox[{"Cos", "[", "z", "]"}], "n"]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, {3.4983206471458116`*^9, 
   3.4983206654446435`*^9}, {3.4983363975959945`*^9, 3.4983364187184315`*^9}, 
   3.498336544688653*^9}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983365404610453`*^9, 3.498336572612702*^9}, {
   3.4983367380977926`*^9, 3.4983367383941927`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Cos", "[", "v", "]"}], "p"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sec", "[", "v", "]"}], "n"]}]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Cos", "[", "v", "]"}], 
        RowBox[{"p", "-", 
         RowBox[{"m", " ", "n"}]}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"a", " ", 
           SuperscriptBox[
            RowBox[{"Cos", "[", "v", "]"}], "n"]}]}], ")"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.4983366970385203`*^9, 3.4983367217021637`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "v_", "]"}], "^", "p_."}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{
           RowBox[{"Sec", "[", "v_", "]"}], "^", "n_."}]}]}], ")"}], "^", 
       "m_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", "v", "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"p", "-", 
          RowBox[{"m", "*", "n"}]}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"a", "*", 
           RowBox[{
            RowBox[{"Cos", "[", "v", "]"}], "^", "n"}]}]}], ")"}], "^", 
        "m"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"IntegersQ", "[", 
      RowBox[{"m", ",", "n", ",", "p"}], "]"}], " ", "&&", " ", 
     RowBox[{"m", "<", "0"}], " ", "&&", " ", 
     RowBox[{"n", ">", "0"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.49833636648954*^9, 3.498336675666483*^9, {
   3.501269990958734*^9, 3.50126999514874*^9}, 3.5171907749416428`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", "v_", "]"}], "^", "p_."}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{
           RowBox[{"Csc", "[", "v_", "]"}], "^", "n_."}]}]}], ")"}], "^", 
       "m_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", "v", "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"p", "-", 
          RowBox[{"m", "*", "n"}]}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"a", "*", 
           RowBox[{
            RowBox[{"Sin", "[", "v", "]"}], "^", "n"}]}]}], ")"}], "^", 
        "m"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"IntegersQ", "[", 
      RowBox[{"m", ",", "n", ",", "p"}], "]"}], " ", "&&", " ", 
     RowBox[{"m", "<", "0"}], " ", "&&", " ", 
     RowBox[{"n", ">", "0"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.49833636648954*^9, 3.498336675666483*^9, 
   3.4983471356939645`*^9, 3.498351824180528*^9, {3.5012700369687986`*^9, 
   3.501270041428805*^9}, 3.5171907749416428`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "m"], 
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, {3.498320501706756*^9, 3.4983205022215567`*^9}, 
   3.498333353478813*^9, {3.498336885814452*^9, 3.4983368925380635`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.526.49, CRC 329", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"b", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983369615369844`*^9, 
   3.4983369629877872`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Csc", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"Sec", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"Tan", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "]"}], "b"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.4983205558700514`*^9, 3.4983205610648603`*^9}, {
   3.498333159718542*^9, 3.498333187498581*^9}, 3.498333360198823*^9, 
   3.498333752109371*^9, {3.498336922833317*^9, 3.498336941147749*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Csc", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "*", 
     RowBox[{"Sec", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "]"}], "/", "b"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", "b", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983330613884044`*^9, 3.4983369096824937`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "n", "-", "2"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "-", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "m"], 
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Csc", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}], 
        RowBox[{"m", "-", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"Sec", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}], 
        RowBox[{"n", "-", "1"}]]}], 
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Csc", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "^", 
     RowBox[{"(", 
      RowBox[{"m", "-", "1"}], ")"}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n", "-", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", "n", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    FractionBox[
     RowBox[{"m", "+", "n"}], "2"], "\[Element]", 
    "\[DoubleStruckCapitalZ]"}]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"Csc", "[", "z", "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "z", "]"}], "n"]}], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"Tan", "[", "z", "]"}], "2"]}], ")"}], 
      RowBox[{
       FractionBox[
        RowBox[{"m", "+", "n"}], "2"], "-", "1"}]], 
     SuperscriptBox[
      RowBox[{"Tan", "[", "z", "]"}], "m"]], 
    RowBox[{
     SuperscriptBox["Tan", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, {
   3.4983373686977*^9, 3.4983374276190033`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"m", "+", "n"}], "2"], "\[Element]", 
     "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
    RowBox[{"0", "<", "m", "\[LessEqual]", "n"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983372385622716`*^9, 3.4983373395568485`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "m"], 
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox["x", "2"]}], ")"}], 
         RowBox[{
          FractionBox[
           RowBox[{"m", "+", "n"}], "2"], "-", "1"}]], 
        SuperscriptBox["x", "m"]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}, 3.4983372111530232`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"x", "^", "2"}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"m", "+", "n"}], ")"}], "/", "2"}], "-", "1"}], 
              ")"}]}], "/", 
            RowBox[{"x", "^", "m"}]}], ",", "x"}], "]"}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"Tan", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"EvenQ", "[", 
     RowBox[{"m", "+", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "m", "<=", "n"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.517190744069188*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.510.4", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, 
   3.4983375216247687`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983372385622716`*^9, 3.4983373395568485`*^9}, {3.4983375374431963`*^9, 
   3.4983375432152066`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", "1"}], 
    RowBox[{"n", "-", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}, 3.4983372111530232`*^9, 
   3.4983375695792527`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.510.6, CRC 334b, A&S 4.3.128a", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, 
   3.4983375216247687`*^9, 3.4983376263945527`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox[
     RowBox[{"m", "+", "n"}], "2"], "\[NotElement]", 
    "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["n", "2"], ",", 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{"m", "-", "1"}], "2"], "\[Element]", 
        "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
       RowBox[{"m", ">", "1"}]}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983372385622716`*^9, 3.4983373395568485`*^9}, {3.4983375374431963`*^9, 
   3.4983375432152066`*^9}, {3.4983376684990263`*^9, 3.498337818992491*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"m", "-", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", "n", "-", "2"}], 
    RowBox[{"n", "-", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}, 3.4983372111530232`*^9, 
   3.4983375695792527`*^9, 3.4983376573294067`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "-", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"EvenQ", "[", 
      RowBox[{"m", "+", "n"}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"EvenQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"OddQ", "[", "m", "]"}], " ", "&&", " ", 
      RowBox[{"m", ">", "1"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, 3.498337620138942*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.510.5, CRC 323a, A&S 4.3.127a", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, 
   3.4983375216247687`*^9, 3.4983376263945527`*^9, 3.4983379713015194`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "n"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983372385622716`*^9, 3.4983373395568485`*^9}, {3.4983375374431963`*^9, 
   3.4983375432152066`*^9}, {3.4983376684990263`*^9, 3.498337818992491*^9}, {
   3.498337947461486*^9, 3.4983379614815054`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], "]"}], 
          RowBox[{"m", "-", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], "]"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "+", "1"}], 
    RowBox[{"m", "+", "n"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}, 3.4983372111530232`*^9, 
   3.4983375695792527`*^9, 3.4983376573294067`*^9, 3.498337920391448*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, 3.498337620138942*^9, 3.498337898081417*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "m"], 
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, {3.498320501706756*^9, 3.4983205022215567`*^9}, 
   3.498333353478813*^9, {3.498336885814452*^9, 3.4983368925380635`*^9}, {
   3.4983471250539494`*^9, 3.4983471513439865`*^9}, {3.4983524542514105`*^9, 
   3.498352456361413*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.526.49', CRC 329'", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983520046307807`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{"b", ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983369615369844`*^9, 
   3.4983369629877872`*^9}, {3.498352556211553*^9, 3.49835256129156*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Csc", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"Sec", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"Cot", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
       "b"]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.4983205558700514`*^9, 3.4983205610648603`*^9}, {
   3.498333159718542*^9, 3.498333187498581*^9}, 3.498333360198823*^9, 
   3.498333752109371*^9, {3.498336922833317*^9, 3.498336941147749*^9}, {
   3.4983471250639496`*^9, 3.498347154983991*^9}, 3.498347213374073*^9, {
   3.4983525224415054`*^9, 3.4983525245315084`*^9}, 3.4983525968316097`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Csc", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "*", 
     RowBox[{"Sec", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      RowBox[{"Cot", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "]"}]}], "/", "b"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", "b", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983330613884044`*^9, 3.4983369096824937`*^9, {
   3.4983471250639496`*^9, 3.498347154983991*^9}, 3.4983472133840733`*^9, 
   3.498351995980769*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "n", "-", "2"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "-", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"m", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983525867815957`*^9, 3.4983525867815957`*^9}, {3.498352871701995*^9, 
   3.498352871701995*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "m"], 
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"m", "-", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}, {3.4983471250639496`*^9, 
   3.498347154993991*^9}, 3.498352473601437*^9, {3.4983526060616226`*^9, 
   3.4983526123916316`*^9}, 3.4983527736818576`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n", "-", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", "m", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, {3.4983471250739493`*^9, 
   3.498347155003991*^9}, 3.49835202558081*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    FractionBox[
     RowBox[{"m", "+", "n"}], "2"], "\[Element]", 
    "\[DoubleStruckCapitalZ]"}]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"Csc", "[", "z", "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "z", "]"}], "n"]}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SuperscriptBox[
          RowBox[{"Cot", "[", "z", "]"}], "2"]}], ")"}], 
       RowBox[{
        FractionBox[
         RowBox[{"m", "+", "n"}], "2"], "-", "1"}]], 
      SuperscriptBox[
       RowBox[{"Cot", "[", "z", "]"}], "n"]]}], 
    RowBox[{
     SuperscriptBox["Cot", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, {
   3.4983373686977*^9, 3.4983374276190033`*^9}, {3.4983471251039495`*^9, 
   3.498347155003991*^9}, {3.4983472133940735`*^9, 3.4983472133940735`*^9}, {
   3.4983520882908983`*^9, 3.49835211106093*^9}, {3.498352332221239*^9, 
   3.498352332221239*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"m", "+", "n"}], "2"], "\[Element]", 
     "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
    RowBox[{"0", "<", "n", "<", "m"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983372385622716`*^9, 3.4983373395568485`*^9}, {3.4983529125420523`*^9, 
   3.4983529272620726`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "m"], 
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", "b"]}]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox["x", "2"]}], ")"}], 
         RowBox[{
          FractionBox[
           RowBox[{"m", "+", "n"}], "2"], "-", "1"}]], 
        SuperscriptBox["x", "n"]], ",", "x"}], "]"}], ",", "x", ",", 
     RowBox[{"Cot", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}, 3.4983372111530232`*^9, {
   3.4983471251039495`*^9, 3.498347155003991*^9}, 3.498347213414073*^9, 
   3.498352478231444*^9, 3.498352623671647*^9, 3.4983527461618185`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"x", "^", "2"}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"m", "+", "n"}], ")"}], "/", "2"}], "-", "1"}], 
              ")"}]}], "/", 
            RowBox[{"x", "^", "n"}]}], ",", "x"}], "]"}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"Cot", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"EvenQ", "[", 
     RowBox[{"m", "+", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, {
   3.4983471251039495`*^9, 3.4983471550139914`*^9}, 3.498347213424073*^9, 
   3.4983520679508696`*^9, 3.517190744069188*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.510.1", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, 
   3.4983375216247687`*^9, 3.498352369801292*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983372385622716`*^9, 3.4983373395568485`*^9}, {3.4983375374431963`*^9, 
   3.4983375432152066`*^9}, {3.4983529459020987`*^9, 3.498352954752111*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], "]"}], 
          RowBox[{"m", "-", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], "]"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"m", "-", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "+", "1"}], 
    RowBox[{"m", "-", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}, 3.4983372111530232`*^9, 
   3.4983375695792527`*^9, {3.4983471251039495`*^9, 3.4983471550139914`*^9}, 
   3.4983524809614477`*^9, {3.498352640431671*^9, 3.498352702021757*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, {3.49834712511395*^9, 3.4983471550139914`*^9}, 
   3.4983523786413045`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.510.3, CRC 334a, A&S 4.3.128b", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, 
   3.4983375216247687`*^9, 3.4983376263945527`*^9, 3.498352394101326*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox[
     RowBox[{"m", "+", "n"}], "2"], "\[NotElement]", 
    "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["m", "2"], ",", 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{"n", "-", "1"}], "2"], "\[Element]", 
        "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
       RowBox[{"n", ">", "1"}]}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983372385622716`*^9, 3.4983373395568485`*^9}, {3.4983375374431963`*^9, 
   3.4983375432152066`*^9}, {3.4983376684990263`*^9, 3.498337818992491*^9}, {
   3.4983529656521263`*^9, 3.4983529810321474`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                     ", "\[IndentingNewLine]",
       "                                                     ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], "]"}], 
          RowBox[{"m", "-", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], "]"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"m", "-", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", "n", "-", "2"}], 
    RowBox[{"m", "-", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}, 3.4983372111530232`*^9, 
   3.4983375695792527`*^9, 3.4983376573294067`*^9, {3.49834712511395*^9, 
   3.498347155023991*^9}, 3.4983524838214517`*^9, 3.498352812081911*^9, {
   3.4983598877018175`*^9, 3.4983598980918317`*^9}, {3.4983601824822297`*^9, 
   3.49836020412226*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "-", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"EvenQ", "[", 
      RowBox[{"m", "+", "n"}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"EvenQ", "[", "m", "]"}], " ", "&&", " ", 
      RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"n", ">", "1"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, 3.498337620138942*^9, {3.4983471251239495`*^9, 
   3.498347155023991*^9}, 3.498352408331346*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.510.2, CRC 323b, A&S 4.3.127b", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, 
   3.4983375216247687`*^9, 3.4983376263945527`*^9, 3.4983379713015194`*^9, 
   3.498352421221364*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "n"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983372385622716`*^9, 3.4983373395568485`*^9}, {3.4983375374431963`*^9, 
   3.4983375432152066`*^9}, {3.4983376684990263`*^9, 3.498337818992491*^9}, {
   3.498337947461486*^9, 3.4983379614815054`*^9}, {3.498352993552165*^9, 
   3.498352993552165*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", "1"}], 
    RowBox[{"m", "+", "n"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}, 3.4983372111530232`*^9, 
   3.4983375695792527`*^9, 3.4983376573294067`*^9, 3.498337920391448*^9, {
   3.4983471251239495`*^9, 3.4983471550339913`*^9}, 3.498352486991456*^9, 
   3.4983528382219477`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, 3.498337620138942*^9, 3.498337898081417*^9, {
   3.4983471251339493`*^9, 3.4983471550339913`*^9}, 3.498352430691377*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"Tan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, {3.498320501706756*^9, 3.4983205022215567`*^9}, 
   3.498333353478813*^9, {3.498336885814452*^9, 3.4983368925380635`*^9}, 
   3.4983380609016447`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Power rule for integration", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.498338134581748*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983369615369844`*^9, 
   3.4983369629877872`*^9}, 3.4983381407817564`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
   RowBox[{"Tan", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "m"], 
      RowBox[{"b", " ", "m"}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.4983205558700514`*^9, 3.4983205610648603`*^9}, {
   3.498333159718542*^9, 3.498333187498581*^9}, 3.498333360198823*^9, 
   3.498333752109371*^9, {3.498336922833317*^9, 3.498336941147749*^9}, {
   3.4983381521417723`*^9, 3.498338167921795*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "/", 
    RowBox[{"(", 
     RowBox[{"b", "*", "m"}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"n", "===", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983330613884044`*^9, 3.4983369096824937`*^9, 
   3.4983381164717226`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"b", "*", "m"}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"n", "===", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983330613884044`*^9, 3.4983369096824937`*^9, 
   3.4983381164717226`*^9, {3.4983471357639647`*^9, 3.4983471357639647`*^9}, 
   3.498347213454073*^9, 3.4983530268822117`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.498338134581748*^9, 
   3.498338251231911*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox["m", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sec", "[", "z", "]"}], "m"], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "z", "]"}], "2"]}], ")"}], 
     FractionBox[
      RowBox[{"m", "-", "2"}], "2"]], " ", 
    RowBox[{
     SuperscriptBox["Tan", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, {
   3.4983373686977*^9, 3.4983374276190033`*^9}, {3.498338282951956*^9, 
   3.4983383006519804`*^9}, 3.498338384752098*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox["m", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{"m", ">", "2"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"n", "-", "1"}], "2"], "\[Element]", 
       "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
      RowBox[{"0", "<", "n", "<", 
       RowBox[{"m", "-", "1"}]}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983383977721167`*^9, 3.498338452392193*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"Tan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "n"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox["x", "2"]}], ")"}], 
         FractionBox[
          RowBox[{"m", "-", "2"}], "2"]]}], ",", "x"}], "]"}], ",", "x", ",", 
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}, {3.4983383410220366`*^9, 
   3.498338368822076*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", "n"}], "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"x", "^", "2"}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"m", "-", "2"}], ")"}], "/", "2"}], ")"}]}]}], ",", 
           "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"Tan", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"EvenQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "2"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"0", "<", "n", "<", 
       RowBox[{"m", "-", "1"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983380984516973`*^9, 
   3.498338217101864*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", "n"}], "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"x", "^", "2"}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"m", "-", "2"}], ")"}], "/", "2"}], ")"}]}]}], ",", 
           "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"Cot", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"EvenQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "2"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"0", "<", "n", "<", 
       RowBox[{"m", "-", "1"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983380984516973`*^9, 
   3.498338217101864*^9, 3.4983471357639647`*^9, {3.498347213494073*^9, 
   3.498347213494073*^9}, 3.4983530492722435`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sec", "[", "z", "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", "z", "]"}], "n"]}], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sec", "[", "z", "]"}], 
     RowBox[{"m", "-", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox[
        RowBox[{"Sec", "[", "z", "]"}], "2"]}], ")"}], 
     FractionBox[
      RowBox[{"n", "-", "1"}], "2"]], " ", 
    RowBox[{
     SuperscriptBox["Sec", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, {
   3.4983373686977*^9, 3.4983374276190033`*^9}, {3.4983388551927567`*^9, 
   3.498338875192785*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}],
    " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["m", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
      "\[And]", " ", 
      RowBox[{"0", "<", "m", "\[LessEqual]", 
       RowBox[{"n", "+", "1"}]}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983383977721167`*^9, 3.498338452392193*^9}, {3.498338759662623*^9, 
   3.498338815712702*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"Tan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "-", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["x", "2"]}], ")"}], 
        FractionBox[
         RowBox[{"n", "-", "1"}], "2"]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}, 3.4983372111530232`*^9, {
   3.498338715962562*^9, 3.498338725172575*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"m", "-", "1"}], ")"}]}], "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"x", "^", "2"}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}], "/", "2"}], ")"}]}]}], ",", 
           "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"EvenQ", "[", "m", "]"}], " ", "&&", " ", 
      RowBox[{"0", "<", "m", "<=", 
       RowBox[{"n", "+", "1"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.49833809347169*^9, 3.4983386893525248`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"m", "-", "1"}], ")"}]}], "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"x", "^", "2"}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"n", "-", "1"}], ")"}], "/", "2"}], ")"}]}]}], ",", 
           "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"EvenQ", "[", "m", "]"}], " ", "&&", " ", 
      RowBox[{"0", "<", "m", "<=", 
       RowBox[{"n", "+", "1"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.49833809347169*^9, 3.4983386893525248`*^9, {3.498347135783964*^9, 
   3.498347135783964*^9}, 3.498347213524073*^9, 3.4983531340623617`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.510.3, CRC 334a", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, 
   3.4983375216247687`*^9, 3.4983389363828707`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox["m", "2"], "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983372385622716`*^9, 3.4983373395568485`*^9}, {3.4983375374431963`*^9, 
   3.4983375432152066`*^9}, {3.49833900066296*^9, 3.498339016212982*^9}, {
   3.498353784963273*^9, 3.4983537931732845`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"m", "-", "2"}]], " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "2"}], 
    RowBox[{"n", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}, 3.4983372111530232`*^9, 
   3.4983375695792527`*^9, {3.498338959592903*^9, 3.4983389733929224`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "2"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Tan", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Tan", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"EvenQ", "[", "m", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, 3.4983380903016863`*^9, 3.4983389265128565`*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.510.6, CRC 334b", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, 
   3.4983375216247687`*^9, 3.4983389363828707`*^9, 3.4983531922324433`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "2"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cot", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Cot", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"EvenQ", "[", "m", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, 3.4983380903016863`*^9, 3.4983389265128565`*^9, {
   3.4983471357939644`*^9, 3.4983471357939644`*^9}, {3.4983472135540733`*^9, 
   3.4983472135540733`*^9}, 3.4983532043424606`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.510.2, CRC 323b", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, 
   3.4983375216247687`*^9, 3.4983376263945527`*^9, 3.498339145273163*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox["m", "2"], "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983372385622716`*^9, 3.4983373395568485`*^9}, {3.4983375374431963`*^9, 
   3.4983375432152066`*^9}, {3.4983376684990263`*^9, 3.498337818992491*^9}, {
   3.4983391687231956`*^9, 3.4983392121232567`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"b", " ", "m"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], "m"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}, 3.4983372111530232`*^9, 
   3.4983375695792527`*^9, 3.4983376573294067`*^9, 3.498338977212928*^9, 
   3.4983391316431437`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Tan", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "m"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "/", "m"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Tan", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"EvenQ", "[", "m", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, 3.498337620138942*^9, 3.4983380873916817`*^9, 
   3.498339110183114*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.510.5, CRC 323a", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, 
   3.4983375216247687`*^9, 3.4983376263945527`*^9, 3.498339145273163*^9, 
   3.4983532272724924`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cot", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "m"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "/", "m"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Cot", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"EvenQ", "[", "m", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, 3.498337620138942*^9, 3.4983380873916817`*^9, 
   3.498339110183114*^9, {3.4983471358039646`*^9, 3.4983471358039646`*^9}, {
   3.498347213584073*^9, 3.498347213584073*^9}, 3.498353221222484*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.510.5, CRC 323a", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, 
   3.4983375216247687`*^9, 3.4983376263945527`*^9, 3.4983379713015194`*^9, 
   3.498339263023328*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "n", "+", "1"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983372385622716`*^9, 3.4983373395568485`*^9}, {3.4983375374431963`*^9, 
   3.4983375432152066`*^9}, {3.4983376684990263`*^9, 3.498337818992491*^9}, {
   3.498337947461486*^9, 3.4983379614815054`*^9}, {3.4983392889933643`*^9, 
   3.498339296103374*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"Tan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"b", " ", "m"}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}, 3.4983372111530232`*^9, 
   3.4983375695792527`*^9, 3.4983376573294067`*^9, 3.498337920391448*^9, 
   3.4983389798029313`*^9, 3.4983393172734036`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "m"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, 3.498337620138942*^9, 3.498337898081417*^9, 
   3.498338084901678*^9, 3.4983392566633186`*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.510.2, CRC 323b", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, 
   3.4983375216247687`*^9, 3.4983376263945527`*^9, 3.4983379713015194`*^9, 
   3.498339263023328*^9, 3.4983532377625074`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Csc", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "m"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, 3.498337620138942*^9, 3.498337898081417*^9, 
   3.498338084901678*^9, 3.4983392566633186`*^9, {3.4983471358039646`*^9, 
   3.4983471358139644`*^9}, {3.4983472136140738`*^9, 3.4983472136140738`*^9}, 
   3.498353244852517*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox["m", "2"], "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983372385622716`*^9, 3.4983373395568485`*^9}, {3.4983375374431963`*^9, 
   3.4983375432152066`*^9}, {3.4983376684990263`*^9, 3.498337818992491*^9}, {
   3.4983391687231956`*^9, 3.4983392121232567`*^9}, {3.498339426053556*^9, 
   3.4983394273535576`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
         SuperscriptBox[
          RowBox[{"Tan", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], "]"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"b", " ", "m"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", "n", "+", "1"}], "m"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}, 3.4983372111530232`*^9, 
   3.4983375695792527`*^9, 3.4983376573294067`*^9, 3.498338977212928*^9, 
   3.4983391316431437`*^9, 3.4983394057535276`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Tan", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "m"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "1"}], ")"}], "/", "m"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Tan", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"EvenQ", "[", "m", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, 3.498337620138942*^9, 3.4983380873916817`*^9, 
   3.498339110183114*^9, 3.498339385583499*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cot", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "m"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "1"}], ")"}], "/", "m"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Cot", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"EvenQ", "[", "m", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, 3.498337620138942*^9, 3.4983380873916817`*^9, 
   3.498339110183114*^9, 3.498339385583499*^9, {3.4983471358139644`*^9, 
   3.498347135823964*^9}, {3.4983472136340733`*^9, 3.4983472136440735`*^9}, 
   3.4983532550425315`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.510.6, CRC 334b", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, 
   3.4983375216247687`*^9, 3.4983376263945527`*^9, 3.498339145273163*^9, 
   3.498339513953679*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "n", "-", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", 
   " ", 
   RowBox[{
    FractionBox["m", "2"], "\[NotElement]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "1"}], "2"], "\[NotElement]", 
    "\[DoubleStruckCapitalZ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983372385622716`*^9, 3.4983373395568485`*^9}, {3.4983375374431963`*^9, 
   3.4983375432152066`*^9}, {3.4983376684990263`*^9, 3.498337818992491*^9}, {
   3.4983391687231956`*^9, 3.4983392121232567`*^9}, {3.498339556903739*^9, 
   3.4983395949037924`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"m", "-", "2"}]], " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "-", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "2"}], 
    RowBox[{"m", "+", "n", "-", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}, 3.4983372111530232`*^9, 
   3.4983375695792527`*^9, 3.4983376573294067`*^9, 3.498338977212928*^9, 
   3.4983391316431437`*^9, 3.498339544603722*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "2"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Tan", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Tan", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"EvenQ", "[", "m", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"OddQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, 3.498337620138942*^9, 3.4983380873916817`*^9, 
   3.498339110183114*^9, 3.4983395090336723`*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.510.3, CRC 334a", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, 
   3.4983375216247687`*^9, 3.4983376263945527`*^9, 3.498339145273163*^9, 
   3.498339513953679*^9, 3.498353263572543*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "2"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cot", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Cot", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"EvenQ", "[", "m", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"OddQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, 3.498337620138942*^9, 3.4983380873916817`*^9, 
   3.498339110183114*^9, 3.4983395090336723`*^9, {3.498347135823964*^9, 
   3.4983471358339643`*^9}, {3.4983472136640735`*^9, 3.4983472136740737`*^9}, 
   3.498353269632552*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.510.1", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, 
   3.4983375216247687`*^9, 3.4983376263945527`*^9, 3.498339145273163*^9, 
   3.498339513953679*^9, 3.498339681783914*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "n", "-", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", 
   " ", 
   RowBox[{
    FractionBox["m", "2"], "\[NotElement]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "1"}], "2"], "\[NotElement]", 
    "\[DoubleStruckCapitalZ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983372385622716`*^9, 3.4983373395568485`*^9}, {3.4983375374431963`*^9, 
   3.4983375432152066`*^9}, {3.4983376684990263`*^9, 3.498337818992491*^9}, {
   3.4983391687231956`*^9, 3.4983392121232567`*^9}, {3.498339556903739*^9, 
   3.4983395949037924`*^9}, 3.4983396877339225`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "-", "1"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "-", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], 
    RowBox[{"m", "+", "n", "-", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}, 3.4983372111530232`*^9, 
   3.4983375695792527`*^9, 3.4983376573294067`*^9, 3.498338977212928*^9, 
   3.4983391316431437`*^9, 3.498339544603722*^9, 3.498339726923977*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Tan", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Tan", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"EvenQ", "[", "m", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"OddQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, 3.498337620138942*^9, 3.4983380873916817`*^9, 
   3.498339110183114*^9, 3.4983395090336723`*^9, 3.498339675413905*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.510.4", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, 
   3.4983375216247687`*^9, 3.4983376263945527`*^9, 3.498339145273163*^9, 
   3.498339513953679*^9, 3.498339681783914*^9, 3.4983532781525636`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cot", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Cot", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"EvenQ", "[", "m", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"OddQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, 3.498337620138942*^9, 3.4983380873916817`*^9, 
   3.498339110183114*^9, 3.4983395090336723`*^9, 3.498339675413905*^9, {
   3.4983471358339643`*^9, 3.4983471358439646`*^9}, {3.4983472136940737`*^9, 
   3.498347213704074*^9}, 3.498353289122579*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.510.4", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, 
   3.4983375216247687`*^9, 3.4983376263945527`*^9, 3.498339145273163*^9, 
   3.498339513953679*^9, 3.498339681783914*^9, 3.498339780464052*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox["m", "2"], "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983372385622716`*^9, 3.4983373395568485`*^9}, {3.4983375374431963`*^9, 
   3.4983375432152066`*^9}, {3.4983376684990263`*^9, 3.498337818992491*^9}, {
   3.4983391687231956`*^9, 3.4983392121232567`*^9}, {3.498339556903739*^9, 
   3.4983395949037924`*^9}, 3.4983396877339225`*^9, {3.498339785264059*^9, 
   3.4983397991740785`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", "n", "+", "1"}], 
    RowBox[{"n", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"Tan", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.498333777679407*^9, 3.4983337911994257`*^9}, {
   3.4983370155130796`*^9, 3.498337026589099*^9}, 3.4983372111530232`*^9, 
   3.4983375695792527`*^9, 3.4983376573294067`*^9, 3.498338977212928*^9, 
   3.4983391316431437`*^9, 3.498339544603722*^9, 3.498339726923977*^9, 
   3.498339829684121*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Tan", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Tan", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"EvenQ", "[", "m", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, 3.498337620138942*^9, 3.4983380873916817`*^9, 
   3.498339110183114*^9, 3.4983395090336723`*^9, 3.498339675413905*^9, 
   3.498339774614044*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.510.1", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.498336973673806*^9, 3.4983371802961693`*^9, 
   3.4983375216247687`*^9, 3.4983376263945527`*^9, 3.498339145273163*^9, 
   3.498339513953679*^9, 3.498339681783914*^9, 3.498339780464052*^9, 
   3.4983533006825953`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cot", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Cot", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"EvenQ", "[", "m", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.4983330647584095`*^9, 3.4983336779792676`*^9, 
   3.4983369061568875`*^9, 3.498337000240653*^9, 3.4983371712949533`*^9, 
   3.4983375157435584`*^9, 3.498337620138942*^9, 3.4983380873916817`*^9, 
   3.498339110183114*^9, 3.4983395090336723`*^9, 3.498339675413905*^9, 
   3.498339774614044*^9, {3.4983471358439646`*^9, 3.4983471358539643`*^9}, {
   3.4983472137240734`*^9, 3.4983472137340736`*^9}, 3.498353308812607*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], "p"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, {3.498320501706756*^9, 3.4983205022215567`*^9}, 
   3.4983399486942873`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.4983399737643228`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "-", "n"}], "\[GreaterEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"p", "-", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983383977721167`*^9, 3.498338452392193*^9}, {3.498340047164426*^9, 
   3.498340067994455*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "p"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], "]"}], 
         RowBox[{"p", "-", "1"}]]}], 
       RowBox[{"b", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "n", "+", "1"}], 
    RowBox[{"b", " ", "n", " ", 
     RowBox[{"(", 
      RowBox[{"p", "-", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.4983205558700514`*^9, 3.4983205610648603`*^9}, {
   3.4983399892343445`*^9, 3.4983400148843803`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n", "*", 
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "-", "n"}], ">=", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "-", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983399672443137`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n", "*", 
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "-", "n"}], ">=", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "-", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983399672443137`*^9, {3.498347135863964*^9, 
   3.4983471358739643`*^9}, 3.498347528344514*^9, 3.4983540269936123`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], "p"], " ", 
   RowBox[{"Tan", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, {3.498320501706756*^9, 3.4983205022215567`*^9}, 
   3.4983399486942873`*^9, 3.498340115734522*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.4983399737643228`*^9}],

Cell[TextData[{
 "Note: Dummy exponent ",
 Cell[BoxData[
  RowBox[{"q", "=", "1"}]]],
 " required in program code so InputForm of integrand is recognized."
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.4983399737643228`*^9, {3.515617440158862*^9, 
   3.5156174661803503`*^9}, {3.515617499147236*^9, 3.5156175165942335`*^9}, {
   3.515617583825079*^9, 3.515617584119096*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "-", "n"}], "\[GreaterEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983332564786777`*^9, 3.4983332736887016`*^9}, {
   3.498333370138837*^9, 3.4983334115588946`*^9}, {3.4983338041794443`*^9, 
   3.4983338086894503`*^9}, {3.498337052812745*^9, 3.4983370759943857`*^9}, {
   3.4983383977721167`*^9, 3.498338452392193*^9}, {3.498340047164426*^9, 
   3.498340067994455*^9}, {3.4983401877146225`*^9, 3.498340188494623*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "p"], " ", 
    RowBox[{"Tan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], "]"}], "p"]}], 
       RowBox[{"b", " ", "n", " ", "p"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "n", "+", "1"}], 
    RowBox[{"b", " ", "n", " ", "p"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.4983205558700514`*^9, 3.4983205610648603`*^9}, {
   3.4983399892343445`*^9, 3.4983400148843803`*^9}, 3.498340119924527*^9, 
   3.4983401699645977`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "q_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", "p"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n", "*", "p"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "-", "n"}], ">=", "0"}], " ", "&&", " ", 
    RowBox[{"q", "===", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983399672443137`*^9, 3.498340125934536*^9, 
   3.498345781803907*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "q_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", "p"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n", "*", "p"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "-", "n"}], ">=", "0"}], " ", "&&", " ", 
    RowBox[{"q", "===", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983399672443137`*^9, 3.498340125934536*^9, 
   3.498345781803907*^9, {3.498347135893965*^9, 3.498347135893965*^9}, 
   3.4983472137640734`*^9, {3.4983541345637627`*^9, 3.498354154763791*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, {3.498320501706756*^9, 3.4983205022215567`*^9}, 
   3.4983449058995676`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"p", "-", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "-", "2"}], ")"}], "2"]}], "+", "1"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983449263824034`*^9, 3.498344959891262*^9}, {
   3.4983564732270365`*^9, 3.4983565056870823`*^9}, {3.498358751290226*^9, 
   3.498358753010228*^9}, {3.4983588400203505`*^9, 3.498358842500354*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", "n", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}], "+", 
         RowBox[{"Tan", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}]}], ")"}], 
       SuperscriptBox[
        RowBox[{"Sec", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
        RowBox[{"p", "-", "2"}]]}], 
      RowBox[{"b", " ", "n", " ", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.4983205558700514`*^9, 3.4983205610648603`*^9}, {
   3.4983449990785313`*^9, 3.498345013789357*^9}, 3.498345167402827*^9, {
   3.498345812738761*^9, 3.4983458133939624`*^9}, {3.4983546963545494`*^9, 
   3.498354715734576*^9}, {3.498355821256124*^9, 3.4983558336261415`*^9}, {
   3.498356070156472*^9, 3.498356092706504*^9}, 3.4983564393369894`*^9, 
   3.4983574129783525`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sec", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"x", "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "-", "2"}], ")"}]}], "+", 
      RowBox[{"Tan", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}]}], ")"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "-", "2"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "2"}], ")"}], "^", "2"}]}], "+", "1"}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983448927175446`*^9, {3.498344963260868*^9, 
   3.498344966568074*^9}, {3.498354721044584*^9, 3.4983547244045887`*^9}, {
   3.4983558561061726`*^9, 3.4983559596963177`*^9}, {3.4983565288971148`*^9, 
   3.498356563587163*^9}, 3.498356801007496*^9, {3.498358756070233*^9, 
   3.4983587575402346`*^9}, {3.4983588479903617`*^9, 3.4983588563603735`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Csc", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"x", "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "-", "2"}], ")"}]}], "-", 
      RowBox[{"Cot", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}]}], ")"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "-", "2"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "2"}], ")"}], "^", "2"}]}], "+", "1"}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983448927175446`*^9, {3.498344963260868*^9, 
   3.498344966568074*^9}, {3.498354721044584*^9, 3.4983547244045887`*^9}, {
   3.4983558561061726`*^9, 3.4983559596963177`*^9}, {3.4983565288971148`*^9, 
   3.498356563587163*^9}, 3.498356801007496*^9, {3.498356945547698*^9, 
   3.498356964017724*^9}, {3.4983571414279723`*^9, 3.4983571419679728`*^9}, {
   3.49835871126017*^9, 3.4983587131601725`*^9}, {3.4983588134403133`*^9, 
   3.498358821840325*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"p", "\[NotEqual]", "2"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "-", "2"}], ")"}], "2"]}], "+", "1"}], "\[NotEqual]", 
    "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983449263824034`*^9, 3.498344959891262*^9}, {
   3.4983572931681848`*^9, 3.498357299008193*^9}, {3.4983585138398933`*^9, 
   3.4983585174698987`*^9}, {3.498358762140241*^9, 3.4983587637302437`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
         RowBox[{"p", "-", "2"}]]}], 
       RowBox[{"b", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                           ", "\[IndentingNewLine]", 
  "                                     ", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
     RowBox[{"p", "-", "2"}]]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"p", "-", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"p", "-", "2"}], ")"}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "-", "2"}], ")"}], "2"]}], "+", "1"}], 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "-", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"p", "-", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
      RowBox[{"p", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.4983205558700514`*^9, 3.4983205610648603`*^9}, {
   3.4983449990785313`*^9, 3.498345013789357*^9}, 3.498345167402827*^9, {
   3.498345812738761*^9, 3.4983458133939624`*^9}, {3.4983546963545494`*^9, 
   3.498354715734576*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sec", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "-", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "2"}], ")"}], "^", "2"}]}], "+", "1"}], ")"}], 
       "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "-", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", "2"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "2"}], ")"}], "^", "2"}]}], "+", "1"}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983448927175446`*^9, {3.498344963260868*^9, 
   3.498344966568074*^9}, {3.498354721044584*^9, 3.4983547244045887`*^9}, {
   3.4983563143768144`*^9, 3.4983563179768195`*^9}, {3.498358537509927*^9, 
   3.4983585399599304`*^9}, {3.4983587681302495`*^9, 3.498358769810252*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Csc", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "-", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "2"}], ")"}], "^", "2"}]}], "+", "1"}], ")"}], 
       "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "-", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Csc", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", "2"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "2"}], ")"}], "^", "2"}]}], "+", "1"}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983448927175446`*^9, {3.498344963260868*^9, 
   3.498344966568074*^9}, {3.4983471359139643`*^9, 3.4983471359239645`*^9}, 
   3.498347213784074*^9, {3.4983542195938816`*^9, 3.498354248293922*^9}, {
   3.4983544478742013`*^9, 3.4983544516742067`*^9}, 3.4983573970683303`*^9, {
   3.498358609060027*^9, 3.498358611940031*^9}, {3.4983587257101903`*^9, 
   3.4983587273301926`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox["p", "2"]}], "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983449263824034`*^9, 3.498344959891262*^9}, {
   3.498345043445009*^9, 3.498345044459011*^9}, {3.498345147902793*^9, 
   3.4983451509603977`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "n", " ", "p", " ", "x", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Log", "[", 
              RowBox[{"c", " ", 
               SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
          RowBox[{"p", "+", "1"}]]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["n", "2"], " ", 
          SuperscriptBox["p", "2"]}], "+", "1"}]]}]}]}]}]}], "+", "         ",
   "\[IndentingNewLine]", 
  "                                                      ", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"]}], 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     SuperscriptBox["p", "2"]}], "+", "1"}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", "p", " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox["p", "2"]}], "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
      RowBox[{"p", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.4983451103067265`*^9, 3.49834512936996*^9}, 
   3.4983451698364315`*^9, {3.498345825593184*^9, 3.498345842144813*^9}, {
   3.498345952633807*^9, 3.4983459602154207`*^9}, {3.498346079003229*^9, 
   3.4983460880356445`*^9}, {3.4983546536844893`*^9, 
   3.4983546907645416`*^9}, {3.4983550797450857`*^9, 3.498355083805092*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sec", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "n", "*", "p", "*", "x", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}], "+", "1"}], ")"}]}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}], "+", "1"}], ")"}]}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", "p", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"n", "^", "2"}], "*", 
           RowBox[{"p", "^", "2"}]}], "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}]}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.498344898598755*^9, {3.4983450658934484`*^9, 
   3.4983450807134743`*^9}, {3.498354734654603*^9, 3.498354744034616*^9}, {
   3.4983550898451*^9, 3.498355094565107*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Csc", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", "n", "*", "p", "*", "x", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}], "+", "1"}], ")"}]}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}], "+", "1"}], ")"}]}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", "p", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"n", "^", "2"}], "*", 
           RowBox[{"p", "^", "2"}]}], "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Csc", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}]}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.498344898598755*^9, {3.4983450658934484`*^9, 
   3.4983450807134743`*^9}, {3.4983471359339647`*^9, 3.4983471359439645`*^9}, 
   3.4983475283645144`*^9, {3.4983542323338995`*^9, 3.498354274893959*^9}, {
   3.4983545920544033`*^9, 3.498354593184405*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, {3.498320501706756*^9, 3.4983205022215567`*^9}, 
   3.4983449058995676`*^9, 3.498345197245679*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "-", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "-", "2"}], ")"}], "2"]}], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "2"]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983449263824034`*^9, 3.498344959891262*^9}, {
   3.498357803148899*^9, 3.4983578183689203`*^9}, {3.4983578914190226`*^9, 
   3.498357911989051*^9}, {3.4983584219297647`*^9, 3.498358430469777*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", "n", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], " ", 
          RowBox[{"Tan", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Log", "[", 
              RowBox[{"c", " ", 
               SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}]}]}], ")"}], 
       SuperscriptBox[
        RowBox[{"Sec", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
        RowBox[{"p", "-", "2"}]]}], 
      RowBox[{"b", " ", "n", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.4983205558700514`*^9, 3.4983205610648603`*^9}, {
   3.4983449990785313`*^9, 3.498345013789357*^9}, 3.498345167402827*^9, {
   3.498345262625394*^9, 3.4983452658077993`*^9}, {3.4983453473959427`*^9, 
   3.4983453672391777`*^9}, {3.4983459883266697`*^9, 
   3.4983459929910784`*^9}, {3.4983578547789707`*^9, 
   3.4983578718989944`*^9}, {3.498358020629203*^9, 3.4983580495792437`*^9}, 
   3.498358193539445*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "-", "2"}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "*", 
       RowBox[{"Tan", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}]}]}], ")"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "-", "2"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "2"}], ")"}], "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983448927175446`*^9, {3.498344963260868*^9, 
   3.498344966568074*^9}, 3.4983452172761145`*^9, {3.498345333574319*^9, 
   3.4983453360235233`*^9}, {3.4983577822088695`*^9, 
   3.4983577930088844`*^9}, {3.4983578428789544`*^9, 
   3.4983578448589573`*^9}, {3.498357937779087*^9, 3.4983579390090885`*^9}, {
   3.49835826125954*^9, 3.498358360469679*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "-", "2"}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "*", 
       RowBox[{"Cot", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}]}]}], ")"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "-", "2"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "2"}], ")"}], "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983448927175446`*^9, {3.498344963260868*^9, 
   3.498344966568074*^9}, 3.4983452172761145`*^9, {3.498345333574319*^9, 
   3.4983453360235233`*^9}, {3.4983577822088695`*^9, 
   3.4983577930088844`*^9}, {3.4983578428789544`*^9, 
   3.4983578448589573`*^9}, {3.498357937779087*^9, 3.4983579390090885`*^9}, {
   3.49835826125954*^9, 3.498358360469679*^9}, {3.4983589637305236`*^9, 
   3.4983589731805367`*^9}, 3.498359128530754*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"p", "\[NotEqual]", "2"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "-", "2"}], ")"}], "2"]}], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "2"]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983449263824034`*^9, 3.498344959891262*^9}, {
   3.498357803148899*^9, 3.4983578183689203`*^9}, {3.4983584474398007`*^9, 
   3.4983584499898043`*^9}, {3.4983590097605877`*^9, 3.4983590116205907`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Tan", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
         RowBox[{"p", "-", "2"}]]}], 
       RowBox[{"b", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                             ", "\[IndentingNewLine]", "               ", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"m", "+", "1"}], ")"}], " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
     RowBox[{"p", "-", "2"}]]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"p", "-", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"p", "-", "2"}], ")"}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "-", "2"}], ")"}], "2"]}], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "2"]}], 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"p", "-", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
      RowBox[{"p", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.4983205558700514`*^9, 3.4983205610648603`*^9}, {
   3.4983449990785313`*^9, 3.498345013789357*^9}, 3.498345167402827*^9, {
   3.498345262625394*^9, 3.4983452658077993`*^9}, {3.4983453473959427`*^9, 
   3.4983453672391777`*^9}, {3.4983459883266697`*^9, 3.4983459929910784`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Tan", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "-", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "2"}], ")"}], "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "-", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Log", "[", 
              RowBox[{"c", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", "2"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "2"}], ")"}], "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983448927175446`*^9, {3.498344963260868*^9, 
   3.498344966568074*^9}, 3.4983452172761145`*^9, {3.498345333574319*^9, 
   3.4983453360235233`*^9}, {3.4983577822088695`*^9, 
   3.4983577930088844`*^9}, {3.498358459969818*^9, 3.4983584627798223`*^9}, {
   3.49835900414058*^9, 3.498359006090583*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "-", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "-", "2"}], ")"}], "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "-", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Log", "[", 
              RowBox[{"c", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", "2"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "2"}], ")"}], "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.4983448927175446`*^9, {3.498344963260868*^9, 
   3.498344966568074*^9}, 3.4983452172761145`*^9, {3.498345333574319*^9, 
   3.4983453360235233`*^9}, {3.4983471359739647`*^9, 3.498347135983965*^9}, 
   3.4983472138140736`*^9, 3.498354779804666*^9, {3.4983548110247097`*^9, 
   3.4983548123747115`*^9}, {3.498357227078092*^9, 3.498357231728099*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox["p", "2"]}], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "2"]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4983449263824034`*^9, 3.498344959891262*^9}, {
   3.498345043445009*^9, 3.498345044459011*^9}, {3.498345147902793*^9, 
   3.4983451509603977`*^9}, 3.4983453122958813`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "n", " ", "p", " ", 
         SuperscriptBox["x", 
          RowBox[{"m", "+", "1"}]], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Log", "[", 
              RowBox[{"c", " ", 
               SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
          RowBox[{"p", "+", "1"}]]}], 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["n", "2"], " ", 
          SuperscriptBox["p", "2"]}], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "2"]}]]}]}]}]}]}], "+", 
  "             ", "\[IndentingNewLine]", "                         ", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"m", "+", "1"}], ")"}], " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"]}], 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     SuperscriptBox["p", "2"]}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "2"]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", "p", " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox["p", "2"]}], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
      RowBox[{"p", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 
   3.4983207265499506`*^9}, {3.4983451103067265`*^9, 3.49834512936996*^9}, 
   3.4983451698364315`*^9, {3.498345296742654*^9, 3.4983452999562597`*^9}, 
   3.4983453494863462`*^9, {3.4983459754878473`*^9, 3.498345978171052*^9}, {
   3.4983461130424886`*^9, 3.4983461199533005`*^9}, {3.4983551621952014`*^9, 
   3.4983551661352067`*^9}, {3.4983552128252726`*^9, 3.498355251825327*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "n", "*", "p", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", "p", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"n", "^", "2"}], "*", 
           RowBox[{"p", "^", "2"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Log", "[", 
              RowBox[{"c", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.498344898598755*^9, {3.4983450658934484`*^9, 
   3.4983450807134743`*^9}, 3.498345222892124*^9, {3.498355173895218*^9, 
   3.4983551780352235`*^9}, {3.498355262105341*^9, 3.4983552707953534`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", "n", "*", "p", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", "p", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"n", "^", "2"}], "*", 
           RowBox[{"p", "^", "2"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Log", "[", 
              RowBox[{"c", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.498344898598755*^9, {3.4983450658934484`*^9, 
   3.4983450807134743`*^9}, 3.498345222892124*^9, {3.498347136003965*^9, 
   3.4983471360139647`*^9}, 3.498347528374514*^9, 3.498354794034686*^9, {
   3.4983548370147457`*^9, 3.498354838924749*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}], "   ", "Sec", 
   RowBox[{"??", "?"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, 3.5000652014948616`*^9, 
   3.500071919760484*^9, 3.5000742351937256`*^9, {3.5000764530668306`*^9, 
   3.5000764698568544`*^9}, {3.500076537356949*^9, 3.5000765379769497`*^9}, {
   3.5156075369439754`*^9, 3.5156075397239795`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.4978080875027843`*^9, {
   3.500071601450039*^9, 3.500071603130041*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Csc", "[", 
    RowBox[{"2", " ", "z"}], "]"}], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Csc", "[", "z", "]"}], " ", 
    RowBox[{"Sec", "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.4978080875027843`*^9, {
   3.500071601450039*^9, 3.5000716499501066`*^9}, {3.500074274463781*^9, 
   3.5000742750737815`*^9}, 3.5000743642239065`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " and ",
 Cell[BoxData["u"]],
 " is a function of trig functions of ",
 Cell[BoxData[
  RowBox[{
   FractionBox["a", "2"], "+", 
   FractionBox[
    RowBox[{"b", " ", "x"}], "2"]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, 3.497639786159789*^9, {3.4976636687943316`*^9, 
   3.497663674238741*^9}, 3.500065336645051*^9, {3.5000653831351156`*^9, 
   3.5000653931651297`*^9}, {3.5000654310051827`*^9, 3.500065453315214*^9}, {
   3.500069687963237*^9, 3.5000696889460382`*^9}, 3.5000699834433556`*^9, {
   3.500073956083335*^9, 3.5000740306834393`*^9}, {3.500074095863531*^9, 
   3.5000741212435665`*^9}, {3.5000741522836094`*^9, 
   3.5000741751536417`*^9}, {3.500074221103706*^9, 3.500074221103706*^9}, 
   3.500074503914102*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["2", "n"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{
        FractionBox["a", "2"], "+", 
        FractionBox[
         RowBox[{"b", " ", "x"}], "2"]}], "]"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{
        FractionBox["a", "2"], "+", 
        FractionBox[
         RowBox[{"b", " ", "x"}], "2"]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, {
   3.4976637183712187`*^9, 3.4976637616924944`*^9}, {3.5000653173450236`*^9, 
   3.500065324625034*^9}, {3.5000653616850853`*^9, 3.500065367505094*^9}, 
   3.5000654791452503`*^9, {3.5000694620376396`*^9, 3.5000695288585577`*^9}, {
   3.500069754013753*^9, 3.500069772031784*^9}, {3.500069828737884*^9, 
   3.500069930574863*^9}, {3.5000700029901905`*^9, 3.500070007950999*^9}, {
   3.500070067407891*^9, 3.5000700989979353`*^9}, 3.5000701914680643`*^9, {
   3.500073895743251*^9, 3.5000739445333185`*^9}, {3.500074199563676*^9, 
   3.500074208003688*^9}, {3.5000744727540584`*^9, 3.500074501224098*^9}, {
   3.500074728884417*^9, 3.5000747432244368`*^9}, 3.500074928024696*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"2", "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"Csc", "[", 
          RowBox[{
           RowBox[{"a", "/", "2"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", "n"}], "*", 
        RowBox[{
         RowBox[{"Sec", "[", 
          RowBox[{
           RowBox[{"a", "/", "2"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", "n"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "/", "2"}], "+", 
      RowBox[{"b", "*", 
       RowBox[{"x", "/", "2"}]}], "-", 
      RowBox[{"FunctionOfTrig", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497663376917819*^9, 3.4976636476250944`*^9, 
   3.500065332175044*^9, 3.500065376815107*^9, 3.500065423255172*^9, {
   3.500069566860224*^9, 3.500069658276385*^9}, {3.5000697782405953`*^9, 
   3.5000697862434096`*^9}, {3.500069950168497*^9, 3.500069992132571*^9}, {
   3.5000701293779774`*^9, 3.5000701415479946`*^9}, 3.5000701855880566`*^9, {
   3.5000702333881235`*^9, 3.5000702407681336`*^9}, 3.500070898259054*^9, {
   3.5000740600034804`*^9, 3.5000740914935246`*^9}, {3.5000742130736947`*^9, 
   3.5000742163036995`*^9}, {3.500074399503956*^9, 3.500074433484003*^9}, {
   3.5000745170941205`*^9, 3.500074525404132*^9}, {3.500074568174192*^9, 
   3.500074670514335*^9}, {3.500074747584443*^9, 3.5000747513644485`*^9}, {
   3.5000749135346756`*^9, 3.5000749139146757`*^9}, {3.5000749672147503`*^9, 
   3.5000749677247515`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Algebraic simplification and piecewise constant extraction\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.4978080875027843`*^9, {
   3.500071601450039*^9, 3.500071603130041*^9}, {3.50008290223586*^9, 
   3.5000829156258783`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Csc", "[", 
    RowBox[{"2", " ", "z"}], "]"}], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Csc", "[", "z", "]"}], " ", 
    RowBox[{"Sec", "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.4978080875027843`*^9, {
   3.500071601450039*^9, 3.5000716499501066`*^9}, {3.500074274463781*^9, 
   3.5000742750737815`*^9}, 3.5000743642239065`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[Cell[TextData[Cell[BoxData[
   RowBox[{
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     FractionBox[
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Csc", "[", 
         RowBox[{
          FractionBox["a", "2"], "+", 
          FractionBox[
           RowBox[{"b", " ", "x"}], "2"]}], "]"}], "n"], " ", 
       SuperscriptBox[
        RowBox[{"Sec", "[", 
         RowBox[{
          FractionBox["a", "2"], "+", 
          FractionBox[
           RowBox[{"b", " ", "x"}], "2"]}], "]"}], "n"]}]]}], "=", "0"}]],
   CellDingbat->None,
   CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
     3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
     3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
     3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
     3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
     3.4796622450654173`*^9}, {3.479686720424531*^9, 
     3.4796867204345455`*^9}, {3.4796874646646957`*^9, 
     3.4796874745589232`*^9}, {3.492826573513727*^9, 3.492826578630536*^9}, {
     3.4928267070863624`*^9, 3.492826707460763*^9}, 3.4928267903497095`*^9, {
     3.492829799151373*^9, 3.4928299617216005`*^9}, {3.4940972077187414`*^9, 
     3.4940972347887793`*^9}, {3.496441851501421*^9, 3.496441872881451*^9}, {
     3.496528916553913*^9, 3.4965289272239285`*^9}, {3.497576165747217*^9, 
     3.4975761801372375`*^9}, {3.497577761382057*^9, 3.4975777938921027`*^9}, 
     3.49763959300025*^9, 3.497639634480723*^9, {3.4976637183712187`*^9, 
     3.4976637616924944`*^9}, {3.5000653173450236`*^9, 
     3.500065324625034*^9}, {3.5000653616850853`*^9, 3.500065367505094*^9}, 
     3.5000654791452503`*^9, {3.5000694620376396`*^9, 
     3.5000695288585577`*^9}, {3.500069754013753*^9, 3.500069772031784*^9}, {
     3.500069828737884*^9, 3.500069930574863*^9}, {3.5000700029901905`*^9, 
     3.500070007950999*^9}, {3.500070067407891*^9, 3.5000700989979353`*^9}, 
     3.5000701914680643`*^9, {3.500073895743251*^9, 3.5000739445333185`*^9}, {
     3.500074199563676*^9, 3.500074208003688*^9}, {3.5000744727540584`*^9, 
     3.500074501224098*^9}, 3.500082863385805*^9},
   TextAlignment->Center,
   FontSize->12,
   FontWeight->"Bold"]], "Subsubsection",
   CellChangeTimes->{
    3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
     3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
     3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
     3.497639710530856*^9, 3.497727769376384*^9, 3.4978080875027843`*^9, {
     3.500071601450039*^9, 3.5000716499501066`*^9}}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.4978080875027843`*^9, {
   3.500071601450039*^9, 3.5000716499501066`*^9}, {3.500083019276024*^9, 
   3.500083048196064*^9}, 3.500083262686364*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}]]],
 " and ",
 Cell[BoxData["u"]],
 " is a function of trig functions of ",
 Cell[BoxData[
  RowBox[{
   FractionBox["a", "2"], "+", 
   FractionBox[
    RowBox[{"b", " ", "x"}], "2"]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, 3.497639786159789*^9, {3.4976636687943316`*^9, 
   3.497663674238741*^9}, 3.500065336645051*^9, {3.5000653831351156`*^9, 
   3.5000653931651297`*^9}, {3.5000654310051827`*^9, 3.500065453315214*^9}, {
   3.500069687963237*^9, 3.5000696889460382`*^9}, 3.5000699834433556`*^9, {
   3.500073956083335*^9, 3.5000740306834393`*^9}, {3.500074095863531*^9, 
   3.5000741212435665`*^9}, {3.5000741522836094`*^9, 
   3.5000741751536417`*^9}, {3.500074221103706*^9, 3.500074221103706*^9}, 
   3.500074503914102*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Csc", "[", 
         RowBox[{
          FractionBox["a", "2"], "+", 
          FractionBox[
           RowBox[{"b", " ", "x"}], "2"]}], "]"}], "n"], " ", 
       SuperscriptBox[
        RowBox[{"Sec", "[", 
         RowBox[{
          FractionBox["a", "2"], "+", 
          FractionBox[
           RowBox[{"b", " ", "x"}], "2"]}], "]"}], "n"]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{
        FractionBox["a", "2"], "+", 
        FractionBox[
         RowBox[{"b", " ", "x"}], "2"]}], "]"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{
        FractionBox["a", "2"], "+", 
        FractionBox[
         RowBox[{"b", " ", "x"}], "2"]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, {
   3.4976637183712187`*^9, 3.4976637616924944`*^9}, {3.5000653173450236`*^9, 
   3.500065324625034*^9}, {3.5000653616850853`*^9, 3.500065367505094*^9}, 
   3.5000654791452503`*^9, {3.5000694620376396`*^9, 3.5000695288585577`*^9}, {
   3.500069754013753*^9, 3.500069772031784*^9}, {3.500069828737884*^9, 
   3.500069930574863*^9}, {3.5000700029901905`*^9, 3.500070007950999*^9}, {
   3.500070067407891*^9, 3.5000700989979353`*^9}, 3.5000701914680643`*^9, {
   3.500073895743251*^9, 3.5000739445333185`*^9}, {3.500074199563676*^9, 
   3.500074208003688*^9}, {3.5000744727540584`*^9, 3.500074501224098*^9}, 
   3.500082863385805*^9, {3.5000832167862997`*^9, 3.5000832494363456`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u_", "*", 
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", 
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Csc", "[", 
          RowBox[{
           RowBox[{"a", "/", "2"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", "n"}], "*", 
        RowBox[{
         RowBox[{"Sec", "[", 
          RowBox[{
           RowBox[{"a", "/", "2"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", "n"}]}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"Csc", "[", 
          RowBox[{
           RowBox[{"a", "/", "2"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", "n"}], "*", 
        RowBox[{
         RowBox[{"Sec", "[", 
          RowBox[{
           RowBox[{"a", "/", "2"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", "n"}]}], ",", "x"}], 
      "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{
       RowBox[{"a", "/", "2"}], "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "/", "2"}]}], "-", 
       RowBox[{"FunctionOfTrig", "[", 
        RowBox[{"u", ",", "x"}], "]"}]}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497663376917819*^9, 3.4976636476250944`*^9, 
   3.500065332175044*^9, 3.500065376815107*^9, 3.500065423255172*^9, {
   3.500069566860224*^9, 3.500069658276385*^9}, {3.5000697782405953`*^9, 
   3.5000697862434096`*^9}, {3.500069950168497*^9, 3.500069992132571*^9}, {
   3.5000701293779774`*^9, 3.5000701415479946`*^9}, 3.5000701855880566`*^9, {
   3.5000702333881235`*^9, 3.5000702407681336`*^9}, 3.500070898259054*^9, {
   3.5000740600034804`*^9, 3.5000740914935246`*^9}, {3.5000742130736947`*^9, 
   3.5000742163036995`*^9}, {3.500074399503956*^9, 3.500074433484003*^9}, {
   3.5000745170941205`*^9, 3.500074525404132*^9}, {3.500074568174192*^9, 
   3.500074670514335*^9}, {3.500082744745639*^9, 3.5000827461456413`*^9}, 
   3.5000831099761505`*^9, {3.500083310306431*^9, 3.5000833272164545`*^9}, {
   3.500083650556907*^9, 3.500083658266918*^9}, 3.500084394877949*^9, {
   3.5000888859357023`*^9, 3.5000888898557076`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Secant Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1272, 26, 118, "Title"],
Cell[1842, 50, 274, 4, 93, "Subsubsection"],
Cell[2119, 56, 1135, 20, 69, "Subsubsection"],
Cell[3257, 78, 1751, 44, 179, "Subsubtitle"],
Cell[5011, 124, 771, 11, 93, "Subsubsection"],
Cell[5785, 137, 1736, 51, 351, "Code"],
Cell[7524, 190, 1812, 52, 379, "Code"],
Cell[9339, 244, 89, 2, 93, "Subsubsection"],
Cell[9431, 248, 274, 4, 65, "Subsubsection"],
Cell[9708, 254, 1093, 19, 69, "Subsubsection"],
Cell[10804, 275, 1902, 44, 165, "Subsubtitle"],
Cell[12709, 321, 771, 11, 93, "Subsubsection"],
Cell[13483, 334, 1543, 44, 351, "Code"],
Cell[15029, 380, 298, 4, 93, "Subsubsection"],
Cell[15330, 386, 1669, 47, 351, "Code"],
Cell[17002, 435, 89, 2, 93, "Subsubsection"],
Cell[17094, 439, 443, 10, 69, "Subsubsection"],
Cell[17540, 451, 1114, 20, 69, "Subsubsection"],
Cell[18657, 473, 2541, 65, 181, "Subsubtitle"],
Cell[21201, 540, 771, 11, 93, "Subsubsection"],
Cell[21975, 553, 2513, 73, 419, "Code"],
Cell[24491, 628, 501, 12, 96, "Subsubsection"],
Cell[24995, 642, 2660, 76, 419, "Code"],
Cell[27658, 720, 89, 2, 93, "Subsubsection"],
Cell[27750, 724, 320, 5, 65, "Subsubsection"],
Cell[28073, 731, 1267, 23, 69, "Subsubsection"],
Cell[29343, 756, 3448, 93, 345, "Subsubtitle"],
Cell[32794, 851, 771, 11, 93, "Subsubsection"],
Cell[33568, 864, 3658, 109, 488, "Code"],
Cell[37229, 975, 344, 5, 93, "Subsubsection"],
Cell[37576, 982, 3808, 112, 488, "Code"],
Cell[41387, 1096, 89, 2, 93, "Subsubsection"],
Cell[41479, 1100, 468, 10, 69, "Subsubsection"],
Cell[41950, 1112, 1114, 20, 69, "Subsubsection"],
Cell[43067, 1134, 2356, 58, 174, "Subsubtitle"],
Cell[45426, 1194, 771, 11, 93, "Subsubsection"],
Cell[46200, 1207, 2235, 64, 419, "Code"],
Cell[48438, 1273, 518, 10, 96, "Subsubsection"],
Cell[48959, 1285, 2333, 66, 419, "Code"],
Cell[51295, 1353, 89, 2, 93, "Subsubsection"],
Cell[51387, 1357, 342, 5, 65, "Subsubsection"],
Cell[51732, 1364, 1278, 23, 69, "Subsubsection"],
Cell[53013, 1389, 3207, 84, 331, "Subsubtitle"],
Cell[56223, 1475, 771, 11, 93, "Subsubsection"],
Cell[56997, 1488, 3259, 96, 488, "Code"],
Cell[60259, 1586, 364, 5, 93, "Subsubsection"],
Cell[60626, 1593, 3361, 98, 488, "Code"],
Cell[63990, 1693, 44, 1, 8, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[64071, 1699, 1358, 29, 80, "Title"],
Cell[65432, 1730, 278, 4, 93, "Subsubsection"],
Cell[65713, 1736, 869, 23, 69, "Subsubsection"],
Cell[66585, 1761, 1062, 21, 69, "Subsubsection"],
Cell[67650, 1784, 1387, 32, 144, "Subsubtitle"],
Cell[69040, 1818, 771, 11, 93, "Subsubsection"],
Cell[69814, 1831, 1526, 41, 282, "Code"],
Cell[71343, 1874, 1578, 42, 310, "Code"],
Cell[72924, 1918, 89, 2, 93, "Subsubsection"],
Cell[73016, 1922, 278, 4, 65, "Subsubsection"],
Cell[73297, 1928, 869, 23, 69, "Subsubsection"],
Cell[74169, 1953, 1065, 21, 69, "Subsubsection"],
Cell[75237, 1976, 1330, 31, 144, "Subsubtitle"],
Cell[76570, 2009, 771, 11, 93, "Subsubsection"],
Cell[77344, 2022, 1341, 37, 282, "Code"],
Cell[78688, 2061, 1393, 38, 310, "Code"],
Cell[80084, 2101, 89, 2, 93, "Subsubsection"],
Cell[80176, 2105, 278, 4, 65, "Subsubsection"],
Cell[80457, 2111, 841, 24, 113, "Subsubsection"],
Cell[81301, 2137, 1120, 23, 69, "Subsubsection"],
Cell[82424, 2162, 1406, 35, 184, "Subsubtitle"],
Cell[83833, 2199, 771, 11, 93, "Subsubsection"],
Cell[84607, 2212, 1423, 41, 282, "Code"],
Cell[86033, 2255, 1477, 42, 310, "Code"],
Cell[87513, 2299, 89, 2, 93, "Subsubsection"],
Cell[87605, 2303, 280, 4, 65, "Subsubsection"],
Cell[87888, 2309, 841, 24, 113, "Subsubsection"],
Cell[88732, 2335, 1130, 23, 69, "Subsubsection"],
Cell[89865, 2360, 1925, 43, 144, "Subsubtitle"],
Cell[91793, 2405, 771, 11, 93, "Subsubsection"],
Cell[92567, 2418, 1707, 46, 282, "Code"],
Cell[94277, 2466, 1760, 47, 310, "Code"],
Cell[96040, 2515, 44, 1, 8, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[96121, 2521, 1400, 29, 80, "Title"],
Cell[97524, 2552, 415, 6, 67, "Subsubsection"],
Cell[97942, 2560, 994, 18, 50, "Subsubsection"],
Cell[98939, 2580, 1219, 28, 114, "Subsubtitle"],
Cell[100161, 2610, 771, 11, 67, "Subsubsection"],
Cell[100935, 2623, 1029, 28, 202, "Code"],
Cell[101967, 2653, 89, 2, 67, "Subsubsection"],
Cell[102059, 2657, 1226, 23, 50, "Subsubsection"],
Cell[103288, 2682, 1998, 46, 128, "Subsubtitle"],
Cell[105289, 2730, 771, 11, 67, "Subsubsection"],
Cell[106063, 2743, 1753, 50, 202, "Code"],
Cell[107819, 2795, 89, 2, 67, "Subsubsection"],
Cell[107911, 2799, 446, 6, 47, "Subsubsection"],
Cell[108360, 2807, 1275, 38, 106, "Subsubsection"],
Cell[109638, 2847, 1304, 25, 75, "Subsubsection"],
Cell[110945, 2874, 2124, 49, 153, "Subsubtitle"],
Cell[113072, 2925, 771, 11, 67, "Subsubsection"],
Cell[113846, 2938, 2070, 57, 202, "Code"],
Cell[115919, 2997, 89, 2, 67, "Subsubsection"],
Cell[116011, 3001, 457, 7, 47, "Subsubsection"],
Cell[116471, 3010, 1233, 23, 50, "Subsubsection"],
Cell[117707, 3035, 2574, 65, 128, "Subsubtitle"],
Cell[120284, 3102, 771, 11, 67, "Subsubsection"],
Cell[121058, 3115, 2522, 75, 251, "Code"],
Cell[123583, 3192, 89, 2, 67, "Subsubsection"],
Cell[123675, 3196, 505, 7, 47, "Subsubsection"],
Cell[124183, 3205, 1669, 35, 75, "Subsubsection"],
Cell[125855, 3242, 2581, 64, 128, "Subsubtitle"],
Cell[128439, 3308, 771, 11, 67, "Subsubsection"],
Cell[129213, 3321, 2711, 78, 251, "Code"],
Cell[131927, 3401, 89, 2, 67, "Subsubsection"],
Cell[132019, 3405, 529, 7, 47, "Subsubsection"],
Cell[132551, 3414, 1368, 25, 50, "Subsubsection"],
Cell[133922, 3441, 2630, 65, 128, "Subsubtitle"],
Cell[136555, 3508, 771, 11, 67, "Subsubsection"],
Cell[137329, 3521, 2531, 74, 251, "Code"],
Cell[139863, 3597, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[139944, 3603, 1506, 31, 80, "Title"],
Cell[141453, 3636, 441, 6, 67, "Subsubsection"],
Cell[141897, 3644, 1088, 20, 50, "Subsubsection"],
Cell[142988, 3666, 1405, 32, 114, "Subsubtitle"],
Cell[144396, 3700, 771, 11, 67, "Subsubsection"],
Cell[145170, 3713, 1159, 32, 202, "Code"],
Cell[146332, 3747, 89, 2, 67, "Subsubsection"],
Cell[146424, 3751, 1330, 25, 50, "Subsubsection"],
Cell[147757, 3778, 2186, 49, 128, "Subsubtitle"],
Cell[149946, 3829, 771, 11, 67, "Subsubsection"],
Cell[150720, 3842, 1852, 52, 202, "Code"],
Cell[152575, 3896, 89, 2, 67, "Subsubsection"],
Cell[152667, 3900, 446, 6, 47, "Subsubsection"],
Cell[153116, 3908, 1509, 42, 106, "Subsubsection"],
Cell[154628, 3952, 1347, 26, 75, "Subsubsection"],
Cell[155978, 3980, 2261, 51, 153, "Subsubtitle"],
Cell[158242, 4033, 771, 11, 67, "Subsubsection"],
Cell[159016, 4046, 2192, 59, 202, "Code"],
Cell[161211, 4107, 89, 2, 67, "Subsubsection"],
Cell[161303, 4111, 479, 7, 47, "Subsubsection"],
Cell[161785, 4120, 1281, 23, 50, "Subsubsection"],
Cell[163069, 4145, 2735, 67, 128, "Subsubtitle"],
Cell[165807, 4214, 771, 11, 67, "Subsubsection"],
Cell[166581, 4227, 2624, 77, 251, "Code"],
Cell[169208, 4306, 89, 2, 67, "Subsubsection"],
Cell[169300, 4310, 527, 7, 47, "Subsubsection"],
Cell[169830, 4319, 1723, 36, 75, "Subsubsection"],
Cell[171556, 4357, 3042, 72, 223, "Subsubtitle"],
Cell[174601, 4431, 771, 11, 67, "Subsubsection"],
Cell[175375, 4444, 2817, 80, 251, "Code"],
Cell[178195, 4526, 89, 2, 67, "Subsubsection"],
Cell[178287, 4530, 555, 8, 47, "Subsubsection"],
Cell[178845, 4540, 1418, 26, 50, "Subsubsection"],
Cell[180266, 4568, 2697, 66, 128, "Subsubtitle"],
Cell[182966, 4636, 771, 11, 67, "Subsubsection"],
Cell[183740, 4649, 2585, 74, 251, "Code"],
Cell[186328, 4725, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[186409, 4731, 1433, 30, 80, "Title"],
Cell[187845, 4763, 443, 6, 67, "Subsubsection"],
Cell[188291, 4771, 943, 13, 47, "Subsubsection"],
Cell[189237, 4786, 1325, 31, 120, "Subsubtitle"],
Cell[190565, 4819, 771, 11, 67, "Subsubsection"],
Cell[191339, 4832, 1174, 34, 202, "Code"],
Cell[192516, 4868, 1298, 36, 222, "Code"],
Cell[193817, 4906, 89, 2, 67, "Subsubsection"],
Cell[193909, 4910, 470, 7, 47, "Subsubsection"],
Cell[194382, 4919, 1082, 29, 86, "Subsubsection"],
Cell[195467, 4950, 1516, 32, 75, "Subsubsection"],
Cell[196986, 4984, 2096, 48, 114, "Subsubtitle"],
Cell[199085, 5034, 771, 11, 67, "Subsubsection"],
Cell[199859, 5047, 2105, 58, 202, "Code"],
Cell[201967, 5107, 2225, 60, 222, "Code"],
Cell[204195, 5169, 89, 2, 67, "Subsubsection"],
Cell[204287, 5173, 446, 6, 47, "Subsubsection"],
Cell[204736, 5181, 1289, 37, 86, "Subsubsection"],
Cell[206028, 5220, 1524, 32, 75, "Subsubsection"],
Cell[207555, 5254, 2179, 50, 114, "Subsubtitle"],
Cell[209737, 5306, 771, 11, 67, "Subsubsection"],
Cell[210511, 5319, 2184, 60, 202, "Code"],
Cell[212698, 5381, 2302, 62, 222, "Code"],
Cell[215003, 5445, 89, 2, 67, "Subsubsection"],
Cell[215095, 5449, 491, 7, 47, "Subsubsection"],
Cell[215589, 5458, 1436, 26, 75, "Subsubsection"],
Cell[217028, 5486, 2627, 65, 128, "Subsubtitle"],
Cell[219658, 5553, 771, 11, 67, "Subsubsection"],
Cell[220432, 5566, 2658, 77, 251, "Code"],
Cell[223093, 5645, 515, 7, 67, "Subsubsection"],
Cell[223611, 5654, 2817, 80, 251, "Code"],
Cell[226431, 5736, 89, 2, 67, "Subsubsection"],
Cell[226523, 5740, 513, 7, 47, "Subsubsection"],
Cell[227039, 5749, 1441, 26, 75, "Subsubsection"],
Cell[228483, 5777, 2539, 62, 124, "Subsubtitle"],
Cell[231025, 5841, 771, 11, 67, "Subsubsection"],
Cell[231799, 5854, 2511, 72, 251, "Code"],
Cell[234313, 5928, 541, 8, 67, "Subsubsection"],
Cell[234857, 5938, 2658, 74, 251, "Code"],
Cell[237518, 6014, 89, 2, 67, "Subsubsection"],
Cell[237610, 6018, 541, 8, 47, "Subsubsection"],
Cell[238154, 6028, 1336, 23, 50, "Subsubsection"],
Cell[239493, 6053, 2100, 46, 124, "Subsubtitle"],
Cell[241596, 6101, 771, 11, 67, "Subsubsection"],
Cell[242370, 6114, 1675, 46, 202, "Code"],
Cell[244048, 6162, 565, 8, 67, "Subsubsection"],
Cell[244616, 6172, 1782, 47, 202, "Code"],
Cell[246401, 6221, 89, 2, 67, "Subsubsection"],
Cell[246493, 6225, 1444, 26, 75, "Subsubsection"],
Cell[247940, 6253, 2580, 62, 124, "Subsubtitle"],
Cell[250523, 6317, 771, 11, 67, "Subsubsection"],
Cell[251297, 6330, 2425, 69, 251, "Code"],
Cell[253725, 6401, 2530, 70, 271, "Code"],
Cell[256258, 6473, 89, 2, 67, "Subsubsection"],
Cell[256350, 6477, 539, 8, 47, "Subsubsection"],
Cell[256892, 6487, 1663, 33, 75, "Subsubsection"],
Cell[258558, 6522, 2668, 65, 128, "Subsubtitle"],
Cell[261229, 6589, 771, 11, 67, "Subsubsection"],
Cell[262003, 6602, 2748, 78, 251, "Code"],
Cell[264754, 6682, 561, 8, 67, "Subsubsection"],
Cell[265318, 6692, 2903, 81, 251, "Code"],
Cell[268224, 6775, 89, 2, 67, "Subsubsection"],
Cell[268316, 6779, 551, 8, 47, "Subsubsection"],
Cell[268870, 6789, 1687, 33, 75, "Subsubsection"],
Cell[270560, 6824, 2660, 64, 128, "Subsubtitle"],
Cell[273223, 6890, 771, 11, 67, "Subsubsection"],
Cell[273997, 6903, 2712, 76, 251, "Code"],
Cell[276712, 6981, 575, 8, 67, "Subsubsection"],
Cell[277290, 6991, 2865, 79, 251, "Code"],
Cell[280158, 7072, 89, 2, 67, "Subsubsection"],
Cell[280250, 7076, 573, 8, 47, "Subsubsection"],
Cell[280826, 7086, 1520, 27, 75, "Subsubsection"],
Cell[282349, 7115, 2676, 65, 128, "Subsubtitle"],
Cell[285028, 7182, 771, 11, 67, "Subsubsection"],
Cell[285802, 7195, 2562, 73, 251, "Code"],
Cell[288367, 7270, 601, 9, 67, "Subsubsection"],
Cell[288971, 7281, 2714, 75, 251, "Code"],
Cell[291688, 7358, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[291769, 7364, 1423, 31, 80, "Title"],
Cell[293195, 7397, 345, 5, 67, "Subsubsection"],
Cell[293543, 7404, 1361, 25, 50, "Subsubsection"],
Cell[294907, 7431, 2040, 57, 134, "Subsubtitle"],
Cell[296950, 7490, 771, 11, 67, "Subsubsection"],
Cell[297724, 7503, 2443, 73, 251, "Code"],
Cell[300170, 7578, 2565, 75, 271, "Code"],
Cell[302738, 7655, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[302819, 7661, 1445, 31, 80, "Title"],
Cell[304267, 7694, 345, 5, 48, "Subsubsection"],
Cell[304615, 7701, 614, 12, 36, "Subsubsection"],
Cell[305232, 7715, 1325, 23, 36, "Subsubsection"],
Cell[306560, 7740, 1921, 52, 95, "Subsubtitle"],
Cell[308484, 7794, 771, 11, 48, "Subsubsection"],
Cell[309258, 7807, 2254, 66, 180, "Code"],
Cell[311515, 7875, 2400, 68, 194, "Code"],
Cell[313918, 7945, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[313999, 7951, 1334, 28, 80, "Title"],
Cell[315336, 7981, 1340, 28, 86, "Subsubsection"],
Cell[316679, 8011, 2069, 51, 134, "Subsubtitle"],
Cell[318751, 8064, 771, 11, 67, "Subsubsection"],
Cell[319525, 8077, 2321, 64, 202, "Code"],
Cell[321849, 8143, 2422, 66, 222, "Code"],
Cell[324274, 8211, 89, 2, 67, "Subsubsection"],
Cell[324366, 8215, 1379, 29, 67, "Subsubsection"],
Cell[325748, 8246, 3174, 91, 267, "Subsubtitle"],
Cell[328925, 8339, 771, 11, 67, "Subsubsection"],
Cell[329699, 8352, 3801, 111, 300, "Code"],
Cell[333503, 8465, 3926, 114, 320, "Code"],
Cell[337432, 8581, 89, 2, 67, "Subsubsection"],
Cell[337524, 8585, 1226, 26, 67, "Subsubsection"],
Cell[338753, 8613, 3733, 95, 270, "Subsubtitle"],
Cell[342489, 8710, 771, 11, 67, "Subsubsection"],
Cell[343263, 8723, 3489, 103, 300, "Code"],
Cell[346755, 8828, 3552, 103, 320, "Code"],
Cell[350310, 8933, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[350391, 8939, 1386, 29, 80, "Title"],
Cell[351780, 8970, 1508, 33, 86, "Subsubsection"],
Cell[353291, 9005, 2347, 60, 134, "Subsubtitle"],
Cell[355641, 9067, 771, 11, 67, "Subsubsection"],
Cell[356415, 9080, 2792, 79, 202, "Code"],
Cell[359210, 9161, 2868, 80, 222, "Code"],
Cell[362081, 9243, 89, 2, 67, "Subsubsection"],
Cell[362173, 9247, 1458, 31, 67, "Subsubsection"],
Cell[363634, 9280, 3521, 101, 267, "Subsubtitle"],
Cell[367158, 9383, 771, 11, 67, "Subsubsection"],
Cell[367932, 9396, 4355, 128, 300, "Code"],
Cell[372290, 9526, 4426, 129, 320, "Code"],
Cell[376719, 9657, 89, 2, 67, "Subsubsection"],
Cell[376811, 9661, 1332, 29, 67, "Subsubsection"],
Cell[378146, 9692, 4231, 111, 270, "Subsubtitle"],
Cell[382380, 9805, 771, 11, 67, "Subsubsection"],
Cell[383154, 9818, 4243, 127, 300, "Code"],
Cell[387400, 9947, 4270, 127, 320, "Code"],
Cell[391673, 10076, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[391754, 10082, 1684, 31, 80, "Title"],
Cell[393441, 10115, 430, 6, 67, "Subsubsection"],
Cell[393874, 10123, 715, 17, 71, "Subsubsection"],
Cell[394592, 10142, 1713, 33, 71, "Subsubsection"],
Cell[396308, 10177, 2523, 51, 114, "Subsubtitle"],
Cell[398834, 10230, 771, 11, 67, "Subsubsection"],
Cell[399608, 10243, 2525, 60, 202, "Code"],
Cell[402136, 10305, 89, 2, 67, "Subsubsection"],
Cell[402228, 10309, 523, 9, 47, "Subsubsection"],
Cell[402754, 10320, 715, 17, 71, "Subsubsection"],
Cell[403472, 10339, 3304, 64, 99, "Subsubsection"],
Cell[406779, 10405, 1713, 33, 71, "Subsubsection"],
Cell[408495, 10440, 3016, 67, 158, "Subsubtitle"],
Cell[411514, 10509, 771, 11, 67, "Subsubsection"],
Cell[412288, 10522, 3181, 78, 202, "Code"],
Cell[415472, 10602, 44, 1, 6, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}
]
*)

(* End of internal cache information *)
