(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    122741,       3349]
NotebookOptionsPosition[    117888,       3222]
NotebookOutlinePosition[    119029,       3262]
CellTagsIndexPosition[    118986,       3259]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox["f", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495333683275055*^9, 3.498508933670944*^9, 3.498509588381861*^9, 
   3.49850963055192*^9, {3.4985098202421856`*^9, 3.4985098240321913`*^9}, 
   3.498519909479803*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: CRC 533, A&S 4.3.136", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["d", "2"], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["p", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.4985099493323665`*^9, 3.498509964632388*^9}, {3.498519911258206*^9, 
   3.498519911258206*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"b", " ", "p", " ", 
        RowBox[{"Log", "[", "f", "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox["f", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}]], ")"}], "p"], 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], 
       RowBox[{
        SuperscriptBox["d", "2"], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["p", "2"], " ", 
         SuperscriptBox[
          RowBox[{"Log", "[", "f", "]"}], "2"]}]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"d", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]}], 
   RowBox[{
    SuperscriptBox["d", "2"], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["p", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, {
   3.4985105306831803`*^9, 3.4985105663032303`*^9}, {3.4985107615335035`*^9, 
   3.4985107704235163`*^9}, {3.4985199122878075`*^9, 3.4985199160474143`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}]}], " ", "-",
     " ", "\n", "  ", 
    RowBox[{"d", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"d", "^", "2"}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, {3.498519918122218*^9, 
   3.498519924643029*^9}},
 Background->GrayLevel[0.85]],

Cell["Reference: CRC 538, A&S 4.3.137", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.498511370354356*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}]}], " ", "+",
     " ", "\n", "  ", 
    RowBox[{"d", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"d", "^", "2"}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985113191942844`*^9, 3.498511356074336*^9}, {3.498511485634517*^9, 
   3.4985114879145203`*^9}, {3.4985115188945637`*^9, 
   3.4985115192845645`*^9}, {3.498519952816679*^9, 3.498519956373485*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 542, A&S 4.3.138", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.498510147452644*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["d", "2"], " ", 
      SuperscriptBox["n", "2"]}], "+", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["p", "2"], " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", "f", "]"}], "2"]}]}], "\[NotEqual]", "0"}], " ", 
   "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.4985099493323665`*^9, 3.498509964632388*^9}, {3.498510953243772*^9, 
   3.498510971053797*^9}, {3.4985199257506313`*^9, 3.4985199257506313`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"b", " ", "p", " ", 
        RowBox[{"Log", "[", "f", "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox["f", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}]], ")"}], "p"], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "n"]}], 
       RowBox[{
        RowBox[{
         SuperscriptBox["d", "2"], " ", 
         SuperscriptBox["n", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["p", "2"], " ", 
         SuperscriptBox[
          RowBox[{"Log", "[", "f", "]"}], "2"]}]}]]}]}]}]}], "-", 
  "\[IndentingNewLine]", 
  FractionBox[
   RowBox[{"d", " ", "n", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"n", "-", "1"}]]}], 
   RowBox[{
    RowBox[{
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox["n", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["p", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", 
     RowBox[{"(", 
      RowBox[{"n", "-", "1"}], ")"}], " ", 
     SuperscriptBox["d", "2"]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["d", "2"], " ", 
      SuperscriptBox["n", "2"]}], "+", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["p", "2"], " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", "f", "]"}], "2"]}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["f", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, 
   3.498510125202613*^9, {3.4985107226434493`*^9, 3.498510741933476*^9}, {
   3.4985108499436274`*^9, 3.4985108652736487`*^9}, {3.498519928293436*^9, 
   3.4985199332230444`*^9}, {3.515956403199978*^9, 3.5159564066007833`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"d", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}], "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}]}], " ", "-",
     " ", "\n", "  ", 
    RowBox[{"d", "*", "n", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"d", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}], "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}]}], " ", "+",
     " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "*", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}], "*", 
         RowBox[{"d", "^", "2"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"d", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"p", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"f", "^", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985100235024705`*^9, 3.4985100592425203`*^9}, {
   3.4985100907525644`*^9, 3.49851009459257*^9}, {3.4985108985836954`*^9, 
   3.4985109165837207`*^9}, {3.498511195214111*^9, 3.498511199044116*^9}, {
   3.498511452804471*^9, 3.498511464874488*^9}, {3.498519935282248*^9, 
   3.4985199425362606`*^9}},
 Background->GrayLevel[0.85]],

Cell["Reference: CRC 543, A&S 4.3.139", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.498510147452644*^9, 
   3.4985113788643675`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", "m"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"d", "^", "2"}], "*", 
         RowBox[{"m", "^", "2"}]}], "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}]}], " ", "+",
     " ", "\n", "  ", 
    RowBox[{"d", "*", "m", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"d", "^", "2"}], "*", 
         RowBox[{"m", "^", "2"}]}], "+", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}]}], " ", "+",
     " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "*", 
         RowBox[{"(", 
          RowBox[{"m", "-", "1"}], ")"}], "*", 
         RowBox[{"d", "^", "2"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"d", "^", "2"}], "*", 
          RowBox[{"m", "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"p", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"f", "^", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{"m", "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985100235024705`*^9, 3.4985100592425203`*^9}, {
   3.4985100907525644`*^9, 3.49851009459257*^9}, {3.4985108985836954`*^9, 
   3.4985109165837207`*^9}, {3.498511195214111*^9, 3.498511199044116*^9}, {
   3.498511322044288*^9, 3.498511356094336*^9}, {3.498511495384531*^9, 
   3.4985115261645737`*^9}, {3.498519963799098*^9, 3.498519968354306*^9}, {
   3.4985200269480095`*^9, 3.4985200437180386`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: CRC 551 when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"n", "+", "2"}], ")"}], "2"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], 
     SuperscriptBox["p", "2"], 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.4985123465257225`*^9, 
   3.498517253116337*^9, {3.498529076972989*^9, 3.4985290819961977`*^9}, {
   3.498530131014841*^9, 3.498530144056464*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"n", "+", "2"}], ")"}], "2"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], 
     SuperscriptBox["p", "2"], 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "+", "2"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.4985099493323665`*^9, 3.498509964632388*^9}, {3.4985127051562243`*^9, 
   3.498512749316286*^9}, {3.4985128464164224`*^9, 3.498512849936427*^9}, {
   3.498529097908226*^9, 3.498529112541052*^9}, {3.4985297959418526`*^9, 
   3.498529800497061*^9}, 3.4985298682791796`*^9, 3.49853002780506*^9, {
   3.498530068817532*^9, 3.4985300851195602`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "p", " ", 
         RowBox[{"Log", "[", "f", "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox["f", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"n", "+", "2"}]]}], 
        RowBox[{
         SuperscriptBox["d", "2"], 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"n", "+", "1"}]]}], 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, {
   3.4985105306831803`*^9, 3.4985105663032303`*^9}, {3.4985107615335035`*^9, 
   3.4985107704235163`*^9}, 3.4985121452454405`*^9, {3.4985125704460363`*^9, 
   3.498512583846055*^9}, 3.4985127801963296`*^9, {3.4985172169086733`*^9, 
   3.498517246423925*^9}, {3.4985285286424255`*^9, 3.4985285338372345`*^9}, 
   3.4985286012137527`*^9, {3.4985286793230896`*^9, 3.498528732129183*^9}, {
   3.498529809810277*^9, 3.4985298394971294`*^9}, {3.4985298729747877`*^9, 
   3.4985298797452*^9}, {3.498530028990662*^9, 3.4985300314866667`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "n", ",", "p"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, 3.4985119359051476`*^9, {
   3.498512231895562*^9, 3.4985122557455955`*^9}, {3.4985123585657396`*^9, 
   3.4985124093458104`*^9}, {3.498512731886262*^9, 3.4985127326962633`*^9}, {
   3.4985172189522767`*^9, 3.4985172320562997`*^9}, {3.498517333955679*^9, 
   3.498517334252079*^9}, {3.498528644706629*^9, 3.4985286531930437`*^9}, {
   3.4985289509403677`*^9, 3.498528961875987*^9}, {3.4985290024516582`*^9, 
   3.498529012186075*^9}, {3.4985298170174894`*^9, 3.4985298295443115`*^9}, {
   3.498529886827612*^9, 3.498529888606015*^9}, {3.498530033109069*^9, 
   3.4985300381478777`*^9}, {3.4985300929819746`*^9, 3.498530114400812*^9}, {
   3.4985301644456997`*^9, 3.4985301667857037`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: CRC 552 when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"n", "+", "2"}], ")"}], "2"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], 
     SuperscriptBox["p", "2"], 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.4985123465257225`*^9, 
   3.498517253116337*^9, {3.498529076972989*^9, 3.4985290819961977`*^9}, {
   3.498530131014841*^9, 3.498530144056464*^9}, {3.4985304948978806`*^9, 
   3.498530495178681*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "n", ",", "p"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, 3.4985119359051476`*^9, {
   3.498512231895562*^9, 3.4985122557455955`*^9}, {3.4985123585657396`*^9, 
   3.4985124093458104`*^9}, {3.498512731886262*^9, 3.4985127326962633`*^9}, {
   3.4985172189522767`*^9, 3.4985172320562997`*^9}, {3.498517333955679*^9, 
   3.498517334252079*^9}, {3.498528644706629*^9, 3.4985286531930437`*^9}, {
   3.4985289509403677`*^9, 3.498528961875987*^9}, {3.4985290024516582`*^9, 
   3.498529012186075*^9}, {3.4985298170174894`*^9, 3.4985298295443115`*^9}, {
   3.498529886827612*^9, 3.498529888606015*^9}, {3.498530033109069*^9, 
   3.4985300381478777`*^9}, {3.4985300929819746`*^9, 3.498530114400812*^9}, {
   3.4985301644456997`*^9, 3.4985301667857037`*^9}, 3.498530317185568*^9, {
   3.4985303486508236`*^9, 3.4985303656236534`*^9}, {3.4985305177519207`*^9, 
   3.4985305180327215`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 551, CRC 542 inverted", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.4985123465257225`*^9, 
   3.498517253116337*^9, {3.498529076972989*^9, 3.4985290819961977`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["d", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["b", "2"], 
      SuperscriptBox["p", "2"], 
      SuperscriptBox[
       RowBox[{"Log", "[", "f", "]"}], "2"]}]}], "\[NotEqual]", "0"}], " ", 
   "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    RowBox[{"-", "2"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.4985099493323665`*^9, 3.498509964632388*^9}, {3.4985127051562243`*^9, 
   3.498512749316286*^9}, {3.4985128464164224`*^9, 3.498512849936427*^9}, {
   3.498529097908226*^9, 3.498529112541052*^9}, {3.4985297959418526`*^9, 
   3.498529800497061*^9}, 3.49853003927108*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "p", " ", 
         RowBox[{"Log", "[", "f", "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox["f", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"n", "+", "2"}]]}], 
        RowBox[{
         SuperscriptBox["d", "2"], 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"n", "+", "1"}]]}], 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["d", "2"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["b", "2"], 
      SuperscriptBox["p", "2"], 
      SuperscriptBox[
       RowBox[{"Log", "[", "f", "]"}], "2"]}]}], 
    RowBox[{
     SuperscriptBox["d", "2"], 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["f", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, {
   3.4985105306831803`*^9, 3.4985105663032303`*^9}, {3.4985107615335035`*^9, 
   3.4985107704235163`*^9}, 3.4985121452454405`*^9, {3.4985125704460363`*^9, 
   3.498512583846055*^9}, 3.4985127801963296`*^9, {3.4985172169086733`*^9, 
   3.498517246423925*^9}, {3.4985285286424255`*^9, 3.4985285338372345`*^9}, 
   3.4985286012137527`*^9, {3.4985286793230896`*^9, 3.498528732129183*^9}, {
   3.498529809810277*^9, 3.4985298394971294`*^9}, {3.4985300405658827`*^9, 
   3.49853004482469*^9}, {3.515956432060028*^9, 3.5159564339164314`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"d", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"n", "+", "2"}], ")"}], "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"p", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"d", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"f", "^", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, 3.4985119359051476`*^9, {
   3.498512231895562*^9, 3.4985122557455955`*^9}, {3.4985123585657396`*^9, 
   3.4985124093458104`*^9}, {3.498512731886262*^9, 3.4985127326962633`*^9}, {
   3.4985172189522767`*^9, 3.4985172320562997`*^9}, {3.498517333955679*^9, 
   3.498517334252079*^9}, {3.498528644706629*^9, 3.4985286531930437`*^9}, {
   3.4985289509403677`*^9, 3.498528961875987*^9}, {3.4985290024516582`*^9, 
   3.498529012186075*^9}, {3.4985298170174894`*^9, 3.4985298295443115`*^9}, {
   3.498530046181892*^9, 3.4985300505655*^9}},
 Background->GrayLevel[0.85]],

Cell["Reference: CRC 552, CRC 543 inverted", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.4985123465257225`*^9, 
   3.498517253116337*^9, {3.498529076972989*^9, 3.4985290819961977`*^9}, {
   3.4985304726990414`*^9, 3.4985304833070602`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"d", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"n", "+", "2"}], ")"}], "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"p", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"d", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"f", "^", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, 3.4985119359051476`*^9, {
   3.498512231895562*^9, 3.4985122557455955`*^9}, {3.4985123585657396`*^9, 
   3.4985124093458104`*^9}, {3.498512731886262*^9, 3.4985127326962633`*^9}, {
   3.4985172189522767`*^9, 3.4985172320562997`*^9}, {3.498517333955679*^9, 
   3.498517334252079*^9}, {3.498528644706629*^9, 3.4985286531930437`*^9}, {
   3.4985289509403677`*^9, 3.498528961875987*^9}, {3.4985290024516582`*^9, 
   3.498529012186075*^9}, {3.4985298170174894`*^9, 3.4985298295443115`*^9}, {
   3.498530046181892*^9, 3.4985300505655*^9}, 3.4985303218811765`*^9, {
   3.4985303527068305`*^9, 3.498530367043256*^9}, {3.4985304448685923`*^9, 
   3.4985304452429934`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox["f", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"Sec", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495333683275055*^9, 3.498508933670944*^9, 3.498509588381861*^9, 
   3.49850963055192*^9, {3.4985098202421856`*^9, 3.4985098240321913`*^9}, {
   3.498511917245122*^9, 3.498511917745122*^9}, 3.498529946310517*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Reference: CRC 552 with  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["p", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}], "+", 
    RowBox[{
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"n", "-", "2"}], ")"}], "2"]}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.4985123465257225`*^9, {
   3.4985124381158504`*^9, 3.4985124580358787`*^9}, 3.4985128378264103`*^9, {
   3.4985299474181185`*^9, 3.4985299474181185`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], 
     SuperscriptBox["p", "2"], 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}], "+", 
    RowBox[{
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"n", "-", "2"}], ")"}], "2"]}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "-", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "-", "2"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.4985099493323665`*^9, 3.498509964632388*^9}, {3.4985127051562243`*^9, 
   3.498512749316286*^9}, {3.4985128464164224`*^9, 3.498512849936427*^9}, {
   3.4985128850264764`*^9, 3.498512909816511*^9}, {3.498512957606578*^9, 
   3.498512970856597*^9}, {3.49852994830732*^9, 3.49852994830732*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "p", " ", 
         RowBox[{"Log", "[", "f", "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox["f", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
         SuperscriptBox[
          RowBox[{"Sec", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"n", "-", "2"}]]}], 
        RowBox[{
         SuperscriptBox["d", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"n", "-", "1"}]], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]}], 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{"n", "-", "1"}], ")"}]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, {
   3.4985105306831803`*^9, 3.4985105663032303`*^9}, {3.4985107615335035`*^9, 
   3.4985107704235163`*^9}, 3.4985121452454405`*^9, 3.4985125664160304`*^9, 
   3.4985127828463335`*^9, {3.4985299493369217`*^9, 3.498529951786126*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p", ",", "n"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}], "^", "2"}]}]}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, 3.4985119359051476`*^9, {
   3.498512231895562*^9, 3.4985122557455955`*^9}, {3.4985123585657396`*^9, 
   3.4985124093458104`*^9}, {3.498512543315998*^9, 3.49851255915602*^9}, {
   3.4985128145563774`*^9, 3.498512814766378*^9}, {3.49851293019654*^9, 
   3.4985129449465604`*^9}, {3.498529954422531*^9, 3.4985299580261374`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: CRC 551 with  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["p", "2"], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", "f", "]"}], "2"]}], "+", 
    RowBox[{
     SuperscriptBox["d", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"n", "-", "2"}], ")"}], "2"]}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.4985123465257225`*^9, {
   3.4985124381158504`*^9, 3.4985124580358787`*^9}, 3.4985128378264103`*^9, {
   3.4985172552379403`*^9, 3.4985172559555416`*^9}, {3.4985299780097723`*^9, 
   3.4985299780097723`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p", ",", "n"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}], "^", "2"}]}]}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "-", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, 3.4985119359051476`*^9, {
   3.498512231895562*^9, 3.4985122557455955`*^9}, {3.4985123585657396`*^9, 
   3.4985124093458104`*^9}, {3.498512543315998*^9, 3.49851255915602*^9}, {
   3.4985128145563774`*^9, 3.498512814766378*^9}, {3.49851293019654*^9, 
   3.4985129449465604`*^9}, {3.49851721542667*^9, 3.4985172290766945`*^9}, {
   3.498529984592984*^9, 3.498529988368191*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 552", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.4985123465257225`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], 
      SuperscriptBox["p", "2"], 
      SuperscriptBox[
       RowBox[{"Log", "[", "f", "]"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["d", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}], "2"]}]}], "\[NotEqual]", "0"}], " ", 
   "\[And]", " ", 
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", "2"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.4985099493323665`*^9, 3.498509964632388*^9}, {3.4985127051562243`*^9, 
   3.498512749316286*^9}, {3.4985128464164224`*^9, 3.498512849936427*^9}, {
   3.49852995966414*^9, 3.49852995966414*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", "p", " ", 
         RowBox[{"Log", "[", "f", "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox["f", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
         SuperscriptBox[
          RowBox[{"Sec", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          RowBox[{"n", "-", "2"}]]}], 
        RowBox[{
         SuperscriptBox["d", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"n", "-", "1"}]], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]}], 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{"n", "-", "1"}], ")"}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], 
      SuperscriptBox["p", "2"], 
      SuperscriptBox[
       RowBox[{"Log", "[", "f", "]"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["d", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}], "2"]}]}], 
    RowBox[{
     SuperscriptBox["d", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"n", "-", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"n", "-", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["f", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, {
   3.4985105306831803`*^9, 3.4985105663032303`*^9}, {3.4985107615335035`*^9, 
   3.4985107704235163`*^9}, 3.4985121452454405`*^9, {3.4985125704460363`*^9, 
   3.498512583846055*^9}, 3.4985127801963296`*^9, {3.498529961208543*^9, 
   3.4985299659353514`*^9}, {3.51595645570967*^9, 3.5159564575036736`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"p", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"d", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"n", "-", "2"}], ")"}], "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"d", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"f", "^", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"Sec", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}], "^", "2"}]}]}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, 3.4985119359051476`*^9, {
   3.498512231895562*^9, 3.4985122557455955`*^9}, {3.4985123585657396`*^9, 
   3.4985124093458104`*^9}, {3.498512731886262*^9, 3.4985127326962633`*^9}, {
   3.4985299677293544`*^9, 3.4985299748741665`*^9}},
 Background->GrayLevel[0.85]],

Cell["Reference: CRC 551", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.4985123465257225`*^9, 
   3.498517253116337*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", "p", "*", 
     RowBox[{"Log", "[", "f", "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f", "^", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"p", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"d", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"n", "-", "2"}], ")"}], "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"d", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"f", "^", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"d", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "2"}], ")"}], "^", "2"}]}]}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, 3.4985119359051476`*^9, {
   3.498512231895562*^9, 3.4985122557455955`*^9}, {3.4985123585657396`*^9, 
   3.4985124093458104`*^9}, {3.498512731886262*^9, 3.4985127326962633`*^9}, {
   3.4985172189522767`*^9, 3.4985172320562997`*^9}, {3.498517333955679*^9, 
   3.498517334252079*^9}, {3.4985299952478027`*^9, 3.498530000146211*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox["f", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495333683275055*^9, 3.498508933670944*^9, 3.498509588381861*^9, 
   3.49850963055192*^9, {3.4985098202421856`*^9, 3.4985098240321913`*^9}, 
   3.498517502123974*^9, 3.498517558908074*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.498517997518444*^9}],

Cell[TextData[{
 "Note: Each term of the sum  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{"m", "-", "1"}]], " ", "u"}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
    3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
    3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
    3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
    3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, {
    3.4985105306831803`*^9, 3.4985105663032303`*^9}, {3.4985107615335035`*^9, 
    3.4985107704235163`*^9}, {3.498517644380624*^9, 3.498517680884688*^9}, 
    3.4985177881660767`*^9, {3.4985179631983843`*^9, 3.4985179714975986`*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 " will be similar in form to the original integrand, but the degree of the \
monomial will be smaller by one. "
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, {3.498517997518444*^9, 
   3.4985180058956585`*^9}, {3.498518086906601*^9, 3.49851810891824*^9}, {
   3.4985181635027356`*^9, 3.4985182415028725`*^9}, {3.498518295946968*^9, 
   3.498518443538828*^9}, 3.5157760541651664`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", let  ",
 Cell[BoxData[
  RowBox[{"u", "=", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["f", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.4985099493323665`*^9, 3.498509964632388*^9}, {3.49851785306219*^9, 
   3.49851794940796*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      SuperscriptBox["x", "m"]}]}], "u"}]}], "-", 
  RowBox[{"m", " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", "u", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, {
   3.4985105306831803`*^9, 3.4985105663032303`*^9}, {3.4985107615335035`*^9, 
   3.4985107704235163`*^9}, {3.498517644380624*^9, 3.498517680884688*^9}, 
   3.4985177881660767`*^9, {3.4985179631983843`*^9, 3.4985179714975986`*^9}, 
   3.51577604963516*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", "=", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ShowSteps", "=", "False"}], ",", 
           RowBox[{"StepCounter", "=", "Null"}]}], "}"}], ",", " ", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"f", "^", 
               RowBox[{"(", 
                RowBox[{"a", "+", 
                 RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
            RowBox[{
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
          "]"}]}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", "u"}], " ", "-", " ", 
      RowBox[{"Dist", "[", 
       RowBox[{"m", ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "-", "1"}], ")"}]}], "*", "u"}], ",", "x"}], 
         "]"}]}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, {3.498517526163616*^9, 
   3.498517584632519*^9}, {3.498517615395773*^9, 3.4985176162381744`*^9}, {
   3.4985178263393435`*^9, 3.498517828226947*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", "=", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ShowSteps", "=", "False"}], ",", 
           RowBox[{"StepCounter", "=", "Null"}]}], "}"}], ",", " ", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"f", "^", 
               RowBox[{"(", 
                RowBox[{"a", "+", 
                 RowBox[{"b", "*", "x"}]}], ")"}]}], ")"}], "^", "p"}], "*", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
          "]"}]}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", "u"}], " ", "-", " ", 
      RowBox[{"Dist", "[", 
       RowBox[{"m", ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "-", "1"}], ")"}]}], "*", "u"}], ",", "x"}], 
         "]"}]}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, {3.498517526163616*^9, 
   3.498517584632519*^9}, {3.498517615395773*^9, 3.4985176162381744`*^9}, {
   3.4985178263393435`*^9, 3.498517828226947*^9}, {3.498518520493763*^9, 
   3.4985185215701647`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["f", "v"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "w", "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495333683275055*^9, 3.498508933670944*^9, 3.498509588381861*^9, 
   3.49850963055192*^9, {3.4985098202421856`*^9, 3.4985098240321913`*^9}, 
   3.498517502123974*^9, 3.498517558908074*^9, 3.498518518294159*^9, 
   3.498705778387356*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.498517997518444*^9, 
   3.498705797434989*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sin", "[", "z", "]"}], "=", 
   RowBox[{
    FractionBox["\[ImaginaryI]", 
     RowBox[{"2", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]]}]], "-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]]}], "2"]}]}]]],
 " "
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, {3.498517997518444*^9, 
   3.4985180058956585`*^9}, {3.498518086906601*^9, 3.49851810891824*^9}, {
   3.4985181635027356`*^9, 3.4985182415028725`*^9}, {3.498518295946968*^9, 
   3.498518443538828*^9}, {3.498705805484603*^9, 3.4987058338610525`*^9}, {
   3.498705925573614*^9, 3.498705938864837*^9}, {3.498706631593254*^9, 
   3.498706644837678*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
  "v", " ", "and", " ", "w", " ", "are", " ", "quadratic", " ", "polynomials",
    " ", "in", " ", "x"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.4985099493323665`*^9, 3.498509964632388*^9}, {3.49851785306219*^9, 
   3.49851794940796*^9}, 3.49851851912096*^9, {3.4987059704860926`*^9, 
   3.4987059967097387`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["f", "v"], " ", 
    RowBox[{"Sin", "[", "w", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["\[ImaginaryI]", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       SuperscriptBox["f", "v"], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", " ", "w"}]]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["\[ImaginaryI]", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["f", "v"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "w"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, {
   3.4985105306831803`*^9, 3.4985105663032303`*^9}, {3.4985107615335035`*^9, 
   3.4985107704235163`*^9}, {3.498517644380624*^9, 3.498517680884688*^9}, 
   3.4985177881660767`*^9, {3.4985179631983843`*^9, 3.4985179714975986`*^9}, 
   3.498518519542161*^9, {3.498705884498742*^9, 3.4987058980707655`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f_", "^", "v_"}], "*", 
     RowBox[{"Sin", "[", "w_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "^", "v"}], "/", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{"I", "*", "w"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "^", "v"}], "*", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{"I", "*", "w"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"f", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"v", ",", "x"}], "]"}], "\[LessEqual]", "2"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"w", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"w", ",", "x"}], "]"}], "\[LessEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, {3.498517526163616*^9, 
   3.498517584632519*^9}, {3.498517615395773*^9, 3.4985176162381744`*^9}, {
   3.4985178263393435`*^9, 3.498517828226947*^9}, {3.498518520493763*^9, 
   3.4985185215701647`*^9}, 3.49870579216218*^9, {3.515771202950174*^9, 
   3.5157712119001865`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cos", "[", "z", "]"}], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "z"}]], "2"], "+", 
    FractionBox["1", 
     RowBox[{"2", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]]}]]}]}]]],
 " "
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, {3.498517997518444*^9, 
   3.4985180058956585`*^9}, {3.498518086906601*^9, 3.49851810891824*^9}, {
   3.4985181635027356`*^9, 3.4985182415028725`*^9}, {3.498518295946968*^9, 
   3.498518443538828*^9}, {3.498705805484603*^9, 3.4987058338610525`*^9}, {
   3.498705925573614*^9, 3.498705938864837*^9}, 3.4987063008946733`*^9, {
   3.498706342044346*^9, 3.498706347207955*^9}, {3.4987064659209633`*^9, 
   3.4987064983534203`*^9}, 3.515770643569391*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f_", "^", "v_"}], "*", 
     RowBox[{"Cos", "[", "w_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "^", "v"}], "*", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{"I", "*", "w"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "^", "v"}], "/", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{"I", "*", "w"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"f", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"v", ",", "x"}], "]"}], "\[LessEqual]", "2"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"w", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"w", ",", "x"}], "]"}], "\[LessEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, {3.498517526163616*^9, 
   3.498517584632519*^9}, {3.498517615395773*^9, 3.4985176162381744`*^9}, {
   3.4985178263393435`*^9, 3.498517828226947*^9}, {3.498518520493763*^9, 
   3.4985185215701647`*^9}, 3.49870579216218*^9, {3.498706302329876*^9, 
   3.4987063146350975`*^9}, {3.5157712058001776`*^9, 3.5157712088401823`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, 3.498517997518444*^9, 
   3.498705797434989*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sin", "[", "z", "]"}], "=", 
   RowBox[{
    FractionBox["\[ImaginaryI]", "2"], 
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", " ", "z"}]]], "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]]}], ")"}]}]}]]],
 " "
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, {3.498517997518444*^9, 
   3.4985180058956585`*^9}, {3.498518086906601*^9, 3.49851810891824*^9}, {
   3.4985181635027356`*^9, 3.4985182415028725`*^9}, {3.498518295946968*^9, 
   3.498518443538828*^9}, {3.498705805484603*^9, 3.4987058338610525`*^9}, {
   3.498705925573614*^9, 3.498705938864837*^9}, 3.4987061267203674`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
   "v", " ", "and", " ", "w", " ", "are", " ", "quadratic", " ", 
    "polynomials", " ", "in", " ", "x"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.4985099493323665`*^9, 3.498509964632388*^9}, {3.49851785306219*^9, 
   3.49851794940796*^9}, 3.49851851912096*^9, {3.4987059704860926`*^9, 
   3.4987059967097387`*^9}, {3.4987061790740595`*^9, 3.4987062076221094`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["f", "v"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "w", "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["\[ImaginaryI]", "2"], ")"}], "n"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["f", "v"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"\[ImaginaryI]", " ", "w"}]]], "-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[ImaginaryI]", " ", "w"}]]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.498509792342147*^9, 3.498509805332165*^9}, {
   3.4985105306831803`*^9, 3.4985105663032303`*^9}, {3.4985107615335035`*^9, 
   3.4985107704235163`*^9}, {3.498517644380624*^9, 3.498517680884688*^9}, 
   3.4985177881660767`*^9, {3.4985179631983843`*^9, 3.4985179714975986`*^9}, 
   3.498518519542161*^9, {3.498705884498742*^9, 3.4987058980707655`*^9}, 
   3.49870616241323*^9, 3.4987062656386113`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f_", "^", "v_"}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", "w_", "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"I", "/", "2"}], ")"}], "^", "n"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "^", "v"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"1", "/", 
            RowBox[{"E", "^", 
             RowBox[{"(", 
              RowBox[{"I", "*", "w"}], ")"}]}]}], "-", 
           RowBox[{"E", "^", 
            RowBox[{"(", 
             RowBox[{"I", "*", "w"}], ")"}]}]}], ")"}], "^", "n"}]}], ",", 
       "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"f", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"v", ",", "x"}], "]"}], "\[LessEqual]", "2"}], " ", "&&", " ", 
    "\n", "  ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"w", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"w", ",", "x"}], "]"}], "\[LessEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, {3.498517526163616*^9, 
   3.498517584632519*^9}, {3.498517615395773*^9, 3.4985176162381744`*^9}, {
   3.4985178263393435`*^9, 3.498517828226947*^9}, {3.498518520493763*^9, 
   3.4985185215701647`*^9}, 3.49870579216218*^9, 3.4987060814958878`*^9, {
   3.515771215920192*^9, 3.5157712185401955`*^9}, {3.5159564851913214`*^9, 
   3.5159564857997227`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cos", "[", "z", "]"}], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]], "+", 
      FractionBox["1", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", " ", "z"}]]]}], ")"}]}]}]]],
 " "
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4985097118120337`*^9, {3.498517997518444*^9, 
   3.4985180058956585`*^9}, {3.498518086906601*^9, 3.49851810891824*^9}, {
   3.4985181635027356`*^9, 3.4985182415028725`*^9}, {3.498518295946968*^9, 
   3.498518443538828*^9}, {3.498705805484603*^9, 3.4987058338610525`*^9}, {
   3.498705925573614*^9, 3.498705938864837*^9}, 3.4987061267203674`*^9, 
   3.498706303047477*^9, 3.498706334868333*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f_", "^", "v_"}], "*", 
     RowBox[{
      RowBox[{"Cos", "[", "w_", "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"2", "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "^", "v"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"E", "^", 
            RowBox[{"(", 
             RowBox[{"I", "*", "w"}], ")"}]}], "+", 
           RowBox[{"1", "/", 
            RowBox[{"E", "^", 
             RowBox[{"(", 
              RowBox[{"I", "*", "w"}], ")"}]}]}]}], ")"}], "^", "n"}]}], ",", 
       "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"f", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"v", ",", "x"}], "]"}], "\[LessEqual]", "2"}], " ", "&&", " ", 
    "\n", "  ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"w", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"w", ",", "x"}], "]"}], "\[LessEqual]", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9, {
   3.498509743462078*^9, 3.4985097607521024`*^9}, {3.498509900942299*^9, 
   3.498509942602357*^9}, {3.4985107807535305`*^9, 3.4985107993935566`*^9}, {
   3.4985114194044247`*^9, 3.4985114217844276`*^9}, {3.498517526163616*^9, 
   3.498517584632519*^9}, {3.498517615395773*^9, 3.4985176162381744`*^9}, {
   3.4985178263393435`*^9, 3.498517828226947*^9}, {3.498518520493763*^9, 
   3.4985185215701647`*^9}, 3.49870579216218*^9, 3.4987060814958878`*^9, {
   3.49870630473228*^9, 3.498706321062309*^9}, {3.5157712208401985`*^9, 
   3.515771223950203*^9}, {3.5159564886857276`*^9, 3.5159564893097286`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Products of Exponential and Trig Functions", None, 
   None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.600000023841858,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1218, 28, 136, "Title"],
Cell[1788, 52, 196, 3, 41, "Subsubsection"],
Cell[1987, 57, 1046, 23, 31, "Subsubsection"],
Cell[3036, 82, 2091, 59, 78, "Subsubtitle"],
Cell[5130, 143, 771, 11, 41, "Subsubsection"],
Cell[5904, 156, 2591, 78, 144, "Code"],
Cell[8498, 236, 218, 3, 41, "Subsubsection"],
Cell[8719, 241, 2691, 79, 144, "Code"],
Cell[11413, 322, 89, 2, 41, "Subsubsection"],
Cell[11505, 326, 218, 3, 29, "Subsubsection"],
Cell[11726, 331, 1225, 28, 31, "Subsubsection"],
Cell[12954, 361, 3332, 100, 153, "Subsubtitle"],
Cell[16289, 463, 771, 11, 41, "Subsubsection"],
Cell[17063, 476, 4361, 130, 172, "Code"],
Cell[21427, 608, 246, 4, 41, "Subsubsection"],
Cell[21676, 614, 4461, 131, 172, "Code"],
Cell[26140, 747, 89, 2, 41, "Subsubsection"],
Cell[26232, 751, 694, 20, 31, "Subsubsection"],
Cell[26929, 773, 1569, 35, 31, "Subsubsection"],
Cell[28501, 810, 2565, 68, 78, "Subsubtitle"],
Cell[31069, 880, 771, 11, 41, "Subsubsection"],
Cell[31843, 893, 3662, 100, 144, "Code"],
Cell[35508, 995, 746, 21, 43, "Subsubsection"],
Cell[36257, 1018, 3792, 102, 144, "Code"],
Cell[40052, 1122, 89, 2, 41, "Subsubsection"],
Cell[40144, 1126, 299, 4, 29, "Subsubsection"],
Cell[40446, 1132, 1494, 35, 31, "Subsubsection"],
Cell[41943, 1169, 3491, 101, 153, "Subsubtitle"],
Cell[45437, 1272, 771, 11, 41, "Subsubsection"],
Cell[46211, 1285, 4739, 137, 172, "Code"],
Cell[50953, 1424, 353, 5, 41, "Subsubsection"],
Cell[51309, 1431, 4869, 139, 172, "Code"],
Cell[56181, 1572, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[56262, 1578, 1264, 28, 92, "Title"],
Cell[57529, 1608, 713, 20, 43, "Subsubsection"],
Cell[58245, 1630, 1516, 34, 31, "Subsubsection"],
Cell[59764, 1666, 2276, 64, 78, "Subsubtitle"],
Cell[62043, 1732, 771, 11, 41, "Subsubsection"],
Cell[62817, 1745, 3302, 96, 144, "Code"],
Cell[66122, 1843, 767, 21, 43, "Subsubsection"],
Cell[66892, 1866, 3351, 97, 144, "Code"],
Cell[70246, 1965, 89, 2, 41, "Subsubsection"],
Cell[70338, 1969, 207, 3, 29, "Subsubsection"],
Cell[70548, 1974, 1379, 32, 31, "Subsubsection"],
Cell[71930, 2008, 3286, 98, 153, "Subsubtitle"],
Cell[75219, 2108, 771, 11, 41, "Subsubsection"],
Cell[75993, 2121, 4399, 132, 172, "Code"],
Cell[80395, 2255, 233, 4, 41, "Subsubsection"],
Cell[80631, 2261, 4497, 133, 172, "Code"],
Cell[85131, 2396, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[85212, 2402, 1270, 29, 92, "Title"],
Cell[86485, 2433, 219, 3, 104, "Subsubsection"],
Cell[86707, 2438, 1327, 26, 78, "Subsubsection"],
Cell[88037, 2466, 1358, 33, 86, "Subsubsection"],
Cell[89398, 2501, 1387, 35, 153, "Subsubtitle"],
Cell[90788, 2538, 771, 11, 104, "Subsubsection"],
Cell[91562, 2551, 2622, 71, 368, "Code"],
Cell[94187, 2624, 2674, 72, 398, "Code"],
Cell[96864, 2698, 44, 1, 12, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[96945, 2704, 1128, 23, 92, "Title"],
Cell[98076, 2729, 244, 4, 41, "Subsubsection"],
Cell[98323, 2735, 922, 23, 47, "Subsubsection"],
Cell[99248, 2760, 999, 19, 30, "Subsubsection"],
Cell[100250, 2781, 1529, 36, 69, "Subsubtitle"],
Cell[101782, 2819, 771, 11, 41, "Subsubsection"],
Cell[102556, 2832, 2053, 54, 144, "Code"],
Cell[104612, 2888, 970, 23, 59, "Subsubsection"],
Cell[105585, 2913, 2103, 54, 144, "Code"],
Cell[107691, 2969, 89, 2, 41, "Subsubsection"],
Cell[107783, 2973, 244, 4, 29, "Subsubsection"],
Cell[108030, 2979, 887, 22, 42, "Subsubsection"],
Cell[108920, 3003, 1194, 22, 30, "Subsubsection"],
Cell[110117, 3027, 1556, 36, 68, "Subsubtitle"],
Cell[111676, 3065, 771, 11, 41, "Subsubsection"],
Cell[112450, 3078, 2212, 56, 144, "Code"],
Cell[114665, 3136, 928, 23, 54, "Subsubsection"],
Cell[115596, 3161, 2229, 55, 144, "Code"],
Cell[117828, 3218, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}
]
*)

(* End of internal cache information *)
