#ifndef FXVIRTUALFILESYSTEM_H
#define FXVIRTUALFILESYSTEM_H

// FIXME: add umask on file creation (eg add an enum for create mode)

#include <fox/fx.h>
#include "ProgressDialog.h"

// File creation types
enum {
  CREATE_FILE      = 0,              /// Plain old file
  CREATE_TEXT_FILE = 0x00000001,     /// A text file (extenstion .txt)
  CREATE_FOLDER    = 0x00000002,     /// A folder/directory
  CREATE_PIPE      = 0x00000003,     /// A fifo/pipe
  };


class FXVirtualFilesystem : public FXId, public FXFile{
  FXDECLARE(FXVirtualFilesystem)

protected:
  FXFileDict      *associations;
  ProgressDialog  *progressBar;
  FXbool           confirmDelete;
  FXWindow        *owner;

public:
  enum {
    ID_CANCEL,
    ID_UPDATE,
    ID_NEW_FILE,
    ID_NEW_TEXT_FILE,
    ID_NEW_FOLDER,
    ID_NEW_PIPE,
    ID_NEW_LINK,
    ID_DELETE,
    ID_COPY,
    ID_MOVE,
    ID_RENAME,
    ID_LAST
    };

public:
  long onCmdCancel      ( FXObject*, FXSelector, void* );
  long onCmdUpdate      ( FXObject*, FXSelector, void* );
  long onCmdNewFile     ( FXObject*, FXSelector, void* );
  long onCmdNewTextFile ( FXObject*, FXSelector, void* );
  long onCmdNewFolder   ( FXObject*, FXSelector, void* );
  long onCmdNewPipe     ( FXObject*, FXSelector, void* );
  long onCmdLink        ( FXObject*, FXSelector, void* );
  long onCmdDelete      ( FXObject*, FXSelector, void* );
  long onCmdCopy        ( FXObject*, FXSelector, void* );
  long onCmdMove        ( FXObject*, FXSelector, void* );
  long onCmdRename      ( FXObject*, FXSelector, void* );

protected:
  FXVirtualFilesystem () {}
  void fileCreateError(const FXString& message);
  void fileDeleteError(const FXString& message);

public:
  /// create me one
  FXVirtualFilesystem(FXApp *a);

  /// create resources
  virtual void create ();

  /// Generates a uniquely named file, for a given path.
  /// The extension (if one exists) is not altered
  FXString getUniqueFilename(const FXString& file);

  /// A GUI response for getUniqueFilename()
  FXString getFilename(const FXString& name);

  /// copies a file
  FXbool copy (FXString source, FXString destination);

  /// Copies a file into the same directory
  FXbool copy (FXString source, FXString destination, FXString path);

  /// moves a file (can also rename)
  FXbool move (FXString source, FXString destination);

  /// renames a file (just implements move() )
  FXbool rename (FXString source, FXString destination, FXString path);

  /// creates a symbolic link
  FXbool link (FXString source, FXString destination);

  /// deletes a file/folder/pipe
  FXbool deleteFile (FXString source);

  /// creates a file/folder/pipe
  FXbool newFile (FXString destination, FXint type);

  /// get a unique stamp for a given file contents
  FXulong getUniqueStamp(FXString filename);

  /// Is used to indicate whether the file has changed
  FXbool hasChanged(FXString filename, FXulong previousStamp);

  /// dtor
  virtual ~FXVirtualFilesystem ();
};

#endif // FXVIRTUALFILESYSTEM_H

