
#include <sys/stat.h>
#include <stdio.h>
#include <unistd.h>
#include "FXVirtualFilesystem.h"

#define CONFIRM_DELETE_DEFAULT  FALSE

/*******************************************************************************/
// Map
FXDEFMAP (FXVirtualFilesystem) FXVirtualFilesystemMap[]={
 FXMAPFUNC(SEL_COMMAND,FXVirtualFilesystem::ID_NEW_TEXT_FILE,FXVirtualFilesystem::onCmdNewTextFile),
  FXMAPFUNC(SEL_COMMAND,FXVirtualFilesystem::ID_NEW_FILE,FXVirtualFilesystem::onCmdNewFile),
  FXMAPFUNC(SEL_COMMAND,FXVirtualFilesystem::ID_NEW_FOLDER,FXVirtualFilesystem::onCmdNewFolder),
  FXMAPFUNC(SEL_COMMAND,FXVirtualFilesystem::ID_NEW_PIPE,FXVirtualFilesystem::onCmdNewPipe),
  FXMAPFUNC(SEL_COMMAND,FXVirtualFilesystem::ID_NEW_LINK,FXVirtualFilesystem::onCmdLink),
  FXMAPFUNC(SEL_COMMAND,FXVirtualFilesystem::ID_DELETE,FXVirtualFilesystem::onCmdDelete),
  FXMAPFUNC(SEL_COMMAND,FXVirtualFilesystem::ID_COPY,FXVirtualFilesystem::onCmdCopy),
  FXMAPFUNC(SEL_COMMAND,FXVirtualFilesystem::ID_MOVE,FXVirtualFilesystem::onCmdMove),
  FXMAPFUNC(SEL_COMMAND,FXVirtualFilesystem::ID_RENAME,FXVirtualFilesystem::onCmdRename),
/*
  FXMAPFUNC(SEL_COMMAND,FXVirtualFilesystem::ID_CANCEL,FXVirtualFilesystem::onCmdCancel),
  FXMAPFUNC(SEL_COMMAND,FXVirtualFilesystem::ID_UPDATE,FXVirtualFilesystem::onCmdUpdate),
*/
};

// Object implementation
FXIMPLEMENT(FXVirtualFilesystem,FXId,FXVirtualFilesystemMap,ARRAYNUMBER(FXVirtualFilesystemMap))
/*******************************************************************************/

// Make some windows
FXVirtualFilesystem::FXVirtualFilesystem(FXApp* a) : FXId(a),FXFile(){
  progressBar = new ProgressDialog ( a );
  associations = new FXFileDict ( a );
  confirmDelete = CONFIRM_DELETE_DEFAULT;
  owner=a->getMainWindow();
  }

FXVirtualFilesystem::~FXVirtualFilesystem(){
  delete associations;
  delete progressBar;
  owner=(FXWindow*)-1;
  }

// create
void FXVirtualFilesystem::create(){
  FXRegistry regDefault ("Desktop", "Default");
  confirmDelete=regDefault.readUnsignedEntry("SETTINGS","confirm delete",CONFIRM_DELETE_DEFAULT);
  }

// A "file creation error" dialog
void FXVirtualFilesystem::fileCreateError(const FXString& message){
  FXMessageBox::error(owner,MBOX_OK,"File creation error",message.text() );
  }

// A "file deletion error" dialog
void FXVirtualFilesystem::fileDeleteError(const FXString& message){
  FXMessageBox::error ( owner, MBOX_OK, "File deleteion error", message.text() );
  }

// A GUI response for unique()
FXString FXVirtualFilesystem::getFilename(const FXString& name){
  FXString file = unique(name);
  if (file.empty()){
    fileCreateError( "Could not generate unique filename." );
    return FXString("");
    }
  return file;
  }

// make an empty file
long FXVirtualFilesystem::onCmdNewFile(FXObject*,FXSelector,void* ptr){
  FXString file = (FXchar*) ptr;
  if (file.empty()) file = "noname";
  newFile(file, CREATE_FILE);
  return 1;
  }

// make an empty text file
long FXVirtualFilesystem::onCmdNewTextFile(FXObject*,FXSelector,void* ptr){
  FXString file = (FXchar*) ptr;
  if (file.empty()) file = "noname";
  newFile(file, CREATE_TEXT_FILE);
  return 1;
  }

// make a folder
long FXVirtualFilesystem::onCmdNewFolder(FXObject*,FXSelector,void* ptr){
  FXString file = (FXchar*) ptr;
  if (file.empty()) file = "noname";
  newFile(file, CREATE_FOLDER);
  return 1;
  }

// make a fifo
long FXVirtualFilesystem::onCmdNewPipe(FXObject*,FXSelector,void* ptr){
  FXString file = (FXchar*) ptr;
  if (file.empty()) file = "noname";
  newFile(file, CREATE_PIPE);
  return 1;
  }

// make a link
long FXVirtualFilesystem::onCmdLink(FXObject*,FXSelector,void*){
/*
  FXString file = filelist->getCurrentFile();
  FXFileDialog* box = new FXFileDialog(this, "Enter path and file to new link:");
  box->setDirectory(file);
  box->setFilename(createFile(filelist->getDirectory() + "/noname"));
  FXString link = box->getFilename();
  FXString command = FXStringFormat("/bin/ln -s %s %s",file.text(),link.text());
fxmessage("command: %s\n",command.text());
//  system(command);
  delete box;
*/
  fxmessage("not yet implemented\n");
  return 1;
  }

// make a copy
long FXVirtualFilesystem::onCmdCopy(FXObject*,FXSelector,void*){
  fxmessage("not yet implemented\n");
  return 1;
  }

// make a delete
long FXVirtualFilesystem::onCmdDelete(FXObject*,FXSelector,void* ptr){
  FXString file = (FXchar*) ptr;
  deleteFile(file);
  return 1;
  }

// make a move
long FXVirtualFilesystem::onCmdMove(FXObject*,FXSelector,void*){
  fxmessage("not yet implemented\n");
  return 1;
  }

// make a rename
long FXVirtualFilesystem::onCmdRename(FXObject*,FXSelector,void*){
  fxmessage("not yet implemented\n");
  return 1;
  }

FXbool FXVirtualFilesystem::copy(FXString source, FXString destination){
  fxmessage("not yet implemented\n");
  return TRUE;
  }

FXbool FXVirtualFilesystem::copy(FXString source, FXString destination, FXString path){
  return copy( FXStringFormat("%s/%s",path.text(),source.text()), FXStringFormat("%s/%s",path.text(),destination.text()) );
  }

FXbool FXVirtualFilesystem::move(FXString source, FXString destination){
  if ( source == destination ){
    fileCreateError("Target is same name as source");
    return FALSE;
    }
  if ( exists(destination) ){
    fileCreateError("Destination already exists");
    return FALSE;
    }
  fxmessage("not yet implemented\n");
  return TRUE;
  }

FXbool FXVirtualFilesystem::link(FXString source, FXString destination){
  if (!exists(source)){
    fileCreateError("The source file does not exist");
    return FALSE;
    }
  if (exists(destination)){
    fileCreateError("Destination already exists");
    return FALSE;
    }
  if (symlink (source.text(), destination.text()) == 0) return TRUE;
  fileCreateError("Error creating link");
  return FALSE;
  }

FXbool FXVirtualFilesystem::rename(FXString source, FXString destination, FXString path){
  return move( FXStringFormat("%s/%s",path.text(),source.text()), FXStringFormat("%s/%s",path.text(),destination.text()) );
  }

FXbool FXVirtualFilesystem::deleteFile(FXString source){
  if (!exists(source)){
    fileDeleteError("File does not exist");
    return FALSE;
    }
  if (confirmDelete){
    if( MBOX_CLICKED_NO == FXMessageBox::question(owner,MBOX_YES_NO,"Are you sure?", "Delete this file:\n%s", source.text()) ) return FALSE;
    }
  // FIXME: use unistd... rmdir, unlink, etc
  FXString command = FXStringFormat ("/bin/rm -rf %s 1>/dev/null 2>&1",source.text());
  if (!exists(source)) return TRUE;
  fileDeleteError("An error occured during delete");
  return FALSE;
  }

FXbool FXVirtualFilesystem::newFile(FXString destination, FXint type){
  if (exists(destination)){
    fileCreateError("File already exists");
    return FALSE;
    }
  FXString file = getFilename(destination);
  switch ( type ){
    case CREATE_TEXT_FILE :
      file += ".txt";  // dont break here - need file create functionality
    case CREATE_FILE :
      FILE* fileObject;
      if ( (fileObject=fopen(file.text(),"a")) == NULL ){
        fileCreateError("Error creating file");
        return FALSE;
        }
      fclose (fileObject);
      break;
    case CREATE_FOLDER :
      if(mkdir(file.text(), 0777 ) == 0) break;
      fileCreateError("Error creating directory");
      return FALSE;
      break;
    case CREATE_PIPE :
      if(mkfifo(file.text(), 0777 ) == 0) break;
      fileCreateError("Error creating fifo/pipe");
      return FALSE;
      break;
    default:
      fxerror("Unknown file creation type: %i", type);
    }
    return TRUE;
  }

// get a unique stamp for a given file contents
// Note: this is a low level function - it does not check for the existance of the file
//       it is intended to be used with other checking mechanisms
FXulong FXVirtualFilesystem::getUniqueStamp(FXString filename){
  // There is probably a number of ways of generating a stamp for a given file
  // For example, you could generate a checksum of the file,
  // or (as in this case) use the last modified value
  struct stat s;
  stat(filename.text(),&s);
  return (FXulong) s.st_mtime;
  }

// Is used to indicate whether the file has changed
FXbool FXVirtualFilesystem::hasChanged(FXString filename, FXulong previousStamp){
  return ( previousStamp != getUniqueStamp(filename) ) ? TRUE : FALSE;
  }

