/* Free Foundation Classes for thread ver.0.1.5
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffcthread: ffcthread.cpp,v 1.33.0 2001/09/17 22:57:46 Toshihiro Inoue Exp $
 */

#include "ffcthread.h"

#ifdef WIN32
#include <process.h>
static unsigned int exec_thread(void* ti)
{
  FFCThreadInternal* ti2 = (FFCThreadInternal*)ti;
  ti2->owner->begin(ti2);
  ti2->owner->exec(ti2);
  ti2->owner->end(ti2);
  return 0;
}
typedef unsigned int(__stdcall* THREADFUNC)(void*);
#else
static void* exec_thread(void* ti)
{
  FFCThreadInternal* ti2 = (FFCThreadInternal*)ti;
  ti2->owner->begin(ti2);
  ti2->owner->exec(ti2);
  ti2->owner->end(ti2);
  return NULL;
}
#endif


void FFCThread::__init_class__()
{
  internal = 0;
}


FFCThread::FFCThread()
{
  __init_class__();
  
}


FFCThread::~FFCThread()
{
  if(internal) {
  #ifdef WIN32
    WaitForSingleObject(internal->thread, INFINITE);
  #else
    pthread_join(internal->thread, NULL);
  #endif
  }
}


void FFCThread::create()
{
  cancel();
  
  internal = new FFCThreadInternal;
  internal->owner = this;
  
  #ifdef WIN32
  unsigned int id;
  internal->thread
  = (THREAD_T)_beginthreadex(NULL, 0, (THREADFUNC)exec_thread, internal, 0, &id);
  #else
  pthread_create(&internal->thread, NULL, exec_thread, internal);
  #endif
}


bool FFCThread::cancel()
{
  FFCThreadInternal* ti = 0;
  bool ret = false;
  
  ti = internal;
  if(!ti) return false;
  
  ti->mutex.lock();
  if(ti == internal) {
    ret = true;
    internal = NULL;
  #ifndef WIN32
    pthread_detach(ti->thread);
  #endif
  }
  ti->mutex.unlock();
  return ret;
}


void FFCThread::exec(FFCThreadInternal* ti)
{
}


void FFCThread::begin(FFCThreadInternal* ti)
{
}


void FFCThread::end(FFCThreadInternal* ti)
{
  ti->mutex.lock();
  if(ti == internal) internal = NULL;
  #ifdef WIN32
  CloseHandle(ti->thread);
  #endif
  ti->mutex.unlock();
  delete ti;
}
