#include "fxex.h"

// Event Handler Object
class AppWindow : public FXMainWindow {
  FXDECLARE(AppWindow)

  private:
    FXLabel      *textTop;
    FXRotatableFont    *font;
    FXCanvas     *canvas; // Canvas to draw on
    FXImage      *saveImage;
    FXfloat      A, B, C, D, A1, B1, C1, D1;
    FXint        GphWid, GphHt;
    FXint        dirty; // Canvas has been painted?
    FXColor      ForeGround, BackGround;

    FXfloat      fontAngle;
    FXint        centerx;
    FXint        centery;

  protected:
    AppWindow(){}

  public: // regular methods
    void initializeApp(void);
  public: // event methods
    long onCmdClearCanvas(FXObject*, FXSelector, void*);
    long onUpdClear(FXObject*, FXSelector, void*);
    long onCmdRePaint(FXObject *sender, FXSelector, void *ptr);
    long onCmdGetFont(FXObject*, FXSelector, void*);
    long onCmdDrawRotatedText(FXObject*, FXSelector, void*);

  public:
    enum {
      ID_CANVAS=FXMainWindow::ID_LAST,
      ID_CLEAR,
      ID_FONT_DIALOG,
      ID_DRAW_ROTATED_TEXT,
      ID_TEXT,
      ID_LAST
      };

  public:
    AppWindow(FXApp* a);
    virtual ~AppWindow();
    virtual void create();
  };

// map
FXDEFMAP(AppWindow) AppWindowMap[] = {
  FXMAPFUNC(SEL_COMMAND, AppWindow::ID_CLEAR,             AppWindow::onCmdClearCanvas),
  FXMAPFUNC(SEL_UPDATE,  AppWindow::ID_CLEAR,             AppWindow::onUpdClear),
  FXMAPFUNC(SEL_PAINT,   AppWindow::ID_CANVAS,            AppWindow::onCmdRePaint),
  FXMAPFUNC(SEL_COMMAND, AppWindow::ID_FONT_DIALOG,       AppWindow::onCmdGetFont),
  FXMAPFUNC(SEL_COMMAND, AppWindow::ID_DRAW_ROTATED_TEXT, AppWindow::onCmdDrawRotatedText),
  };
FXIMPLEMENT(AppWindow, FXMainWindow, AppWindowMap, ARRAYNUMBER(AppWindowMap))

// Construct AppWindow
AppWindow::AppWindow(FXApp *a):FXMainWindow(a,"Rotatable Font") {
  GphWid = 600; GphHt = 400;
  fontAngle=0;
  FXint x=getRoot()->getDefaultWidth();
  FXint y=getRoot()->getDefaultHeight();
  centerx=x/2;
  centery=y/2;
  setX(x);
  setY(y);

  //Create a Main FXVerticalFrame Widget
  FXVerticalFrame *mainFrame=new FXVerticalFrame(this,FRAME_SUNKEN|LAYOUT_FILL);

  // Top horizontal frame will contain 2 vertical frames
  FXHorizontalFrame *topHorizFrame=new FXHorizontalFrame(mainFrame,LAYOUT_FILL_X);

  // LEFT vertical frame to contain the canvas
  FXVerticalFrame *canvasFrame=new FXVerticalFrame(topHorizFrame,FRAME_SUNKEN|LAYOUT_FILL);

  // Label above the canvas
  new FXLabel(canvasFrame,"Test X Font Properties",NULL,JUSTIFY_CENTER_X|LAYOUT_FILL_X);

  // Horizontal divider line
  new FXHorizontalSeparator(canvasFrame,SEPARATOR_GROOVE|LAYOUT_FILL_X);

  // Drawing canvas
  canvas=new FXCanvas(canvasFrame,this,ID_CANVAS,FRAME_SUNKEN|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT, 0,0,GphWid,GphHt);

  // RIGHT frame for the test group box & buttons
  FXVerticalFrame *inputFrame=new FXVerticalFrame(topHorizFrame,FRAME_SUNKEN|LAYOUT_FILL_Y);

  FXGroupBox *FontButtons=new FXGroupBox(inputFrame,"Font Tests",GROUPBOX_NORMAL|FRAME_RIDGE|LAYOUT_FILL_X, 0,0,0,0, 10,10,5,5);

  // Button to draw Circle text
  // Button to draw rotated text
  new FXButton(FontButtons,"Rotated",NULL,this,ID_DRAW_ROTATED_TEXT,FRAME_RAISED);
  // Button to draw Shear text
  // Button to draw Anamorphic text
  // Button to draw X Mirror text
  // Button to draw Y Mirror text
  // Button to draw Complex Matrix Multipled text

  FXGroupBox *SelectFont=new FXGroupBox(inputFrame,"Change Font",GROUPBOX_NORMAL|FRAME_RIDGE|LAYOUT_FILL_X, 0,0,0,0, 10,10,5,5);

  // Select Font Dialog Box
  new FXButton(SelectFont,"Select Font",NULL,this,ID_FONT_DIALOG,FRAME_RAISED);

  // Button to clear
  new FXButton(SelectFont,"&Clear",NULL,this,ID_CLEAR,FRAME_RAISED);

  // Exit button
  new FXButton(inputFrame,"&Exit",NULL,getApp(),FXApp::ID_QUIT,FRAME_RAISED|LAYOUT_BOTTOM);

  //Bottom vertical frame contains text output window
  FXVerticalFrame *bottomFrame=new FXVerticalFrame(mainFrame,FRAME_SUNKEN|LAYOUT_FILL_Y|LAYOUT_FIX_HEIGHT, 0,0,0,145);

  textTop=new FXLabel(bottomFrame,"X Font String",NULL,JUSTIFY_CENTER_X | LAYOUT_FILL_X);
  saveImage=new FXImage(getApp(),NULL,IMAGE_KEEP|IMAGE_OWNED,GphWid,GphHt);
  font=new FXRotatableFont(getApp(),"helvetica",16);
  }

// Clean up
AppWindow::~AppWindow() {
  delete saveImage;
  if (font) delete font;
  }

// Create and initialize
void AppWindow::create() {
  FXMainWindow::create();
  saveImage->create();
  font->create();
  initializeApp();
  show();
  }

// setup application
void AppWindow::initializeApp(void) {
  BackGround = FXRGB(255,255,255); //WHITE;
  ForeGround = FXRGB(255,0,0); //RED;
  FXDCWindow dc(saveImage);
  dc.setForeground(BackGround);
  dc.fillRectangle(0, 0, saveImage->getWidth(), saveImage->getHeight());
  textTop->setBackColor(BackGround);
  font->displayText(dc,"Initial font",centerx,centery);
  dirty = 0;
  }

// Handle the clear canvas message
long AppWindow::onCmdClearCanvas(FXObject*, FXSelector, void*) {
  FXDCWindow dc(saveImage);
  dc.setForeground(BackGround);
  dc.fillRectangle(0, 0, saveImage->getWidth(), saveImage->getHeight());
  FXDCWindow sdc(canvas);
  sdc.drawImage(saveImage, 0, 0);
  dirty = 0;
  return 1;
  }

// Update the clear button
long AppWindow::onUpdClear(FXObject* sender, FXSelector, void*) {
  if(dirty)
    sender->handle(this, MKUINT(FXWindow::ID_ENABLE, SEL_COMMAND), NULL);
  else
    sender->handle(this, MKUINT(FXWindow::ID_DISABLE, SEL_COMMAND), NULL);
  return 1;
  }

// Repaint the canvas
long AppWindow::onCmdRePaint(FXObject *sender,FXSelector,void *ptr) {
  FXCanvas *canvas=(FXCanvas*) sender;
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(canvas, ev);
  dc.setForeground(BackGround);
  dc.fillRectangle(ev->rect.x, ev->rect.y, ev->rect.w, ev->rect.h);
  if (dirty == 1) dc.drawImage(saveImage, 0, 0);
  return 1;
  }

// Change font using FXFont Dialog box
long AppWindow::onCmdGetFont(FXObject*, FXSelector, void*) { 
  FXFontDialog fontdlg(this, "Change Font", DECOR_BORDER | DECOR_TITLE);
  FXFontDesc fontdesc;
  if(fontdlg.execute()) { 
    fontdlg.getFontSelection(fontdesc);
    if (font) delete font;
    fontAngle=0;
    font=new FXRotatableFont(getApp(), fontdesc, fontAngle);
    font->create();
    FXDCWindow dc(saveImage);
    dc.setForeground(ForeGround);
    font->displayText(dc,"Initial font angle",centerx,centery);
    return 1;
    }
  return 0;
  }

// draw example rotated text
// modifiy this routine so as to do something interesting
long AppWindow::onCmdDrawRotatedText(FXObject*,FXSelector,void*) {
  FXDCWindow dc(saveImage);
  dc.setForeground(ForeGround);
  fontAngle+=15;
  if (fontAngle>=360) fontAngle=0;
  font->destroy();
  font->setAngle(fontAngle);
  font->create();
  font->displayText(dc,"Rotated text!",160,170);
  FXDCWindow sdc(canvas);
  sdc.drawImage(saveImage, 0, 0);
  dirty=1;
  return 1;
  }

// start the ball rolling
int main(int argc, char *argv[]) {
  FXApp app("RotatableFont","FoxExTest");
  app.init(argc, argv);
  new AppWindow(&app);
  app.create();
  return app.run();
  }

