#include "fxex.h"
#define PORT 20002

class Resolver : public FXMainWindow {
  FXDECLARE(Resolver)
protected:
  FXResolver  *resolver0;
  FXResolver  *resolver1;
  FXResolver  *resolver2;
  FXResolver  *resolver3;
  FXResolver  *resolver4;
  FXResolver  *resolver5;
  FXResolver  *resolver6;
  FXResolver  *resolver7;
  FXResolver  *resolver8;
  FXResolver  *resolver9;
  FXDataTarget dt0;
  FXDataTarget dt1;
  FXDataTarget dt2;
  FXDataTarget dt3;
  FXDataTarget dt4;
  FXDataTarget dt5;
  FXDataTarget dt6;
  FXDataTarget dt7;
  FXDataTarget dt8;
  FXDataTarget dt9;
  FXString hostname0;
  FXString hostname1;
  FXString hostname2;
  FXString hostname3;
  FXString hostname4;
  FXString hostname5;
  FXString hostname6;
  FXString hostname7;
  FXString hostname8;
  FXString hostname9;
  FXCheckButton *check0;
  FXCheckButton *check1;
  FXCheckButton *check2;
  FXCheckButton *check3;
  FXCheckButton *check4;
  FXCheckButton *check5;
  FXCheckButton *check6;
  FXCheckButton *check7;
  FXCheckButton *check8;
  FXCheckButton *check9;

protected:
  Resolver(){}

public:
  long onCmdQuit(FXObject*,FXSelector,void*);
  long onStart(FXObject*,FXSelector,void*);
  long onResolved(FXObject*,FXSelector,void*);
  long onUnResolved(FXObject*,FXSelector,void*);

public:
  enum{
    ID_MAINWINDOW=FXMainWindow::ID_LAST,
    ID_QUIT,
    ID_RESOLVE,
    ID_RESOLVE_0,
    ID_RESOLVE_1,
    ID_RESOLVE_2,
    ID_RESOLVE_3,
    ID_RESOLVE_4,
    ID_RESOLVE_5,
    ID_RESOLVE_6,
    ID_RESOLVE_7,
    ID_RESOLVE_8,
    ID_RESOLVE_9,
    ID_LAST
    };

public:
  Resolver(FXApp* a);
  virtual void create();
  virtual ~Resolver();
  };


// map...
FXDEFMAP(Resolver) ResolverMap[]={
  // close application
  FXMAPFUNC(SEL_CLOSE,0,Resolver::onCmdQuit),
  FXMAPFUNC(SEL_CLOSE,Resolver::ID_MAINWINDOW,Resolver::onCmdQuit),
  FXMAPFUNC(SEL_SIGNAL,Resolver::ID_QUIT,Resolver::onCmdQuit),
  FXMAPFUNC(SEL_COMMAND,Resolver::ID_QUIT,Resolver::onCmdQuit),
  // start resolution
  FXMAPFUNC(SEL_COMMAND,Resolver::ID_RESOLVE,Resolver::onStart),
  // handle hostname resolution event, from child thread
  FXMAPFUNCS(SEL_COMMAND,Resolver::ID_RESOLVE_0,Resolver::ID_RESOLVE_9,Resolver::onResolved),
  FXMAPFUNCS(SEL_ERROR,Resolver::ID_RESOLVE_0,Resolver::ID_RESOLVE_9,Resolver::onUnResolved),
  };
FXIMPLEMENT(Resolver,FXMainWindow,ResolverMap,ARRAYNUMBER(ResolverMap))


// ctor
Resolver::Resolver(FXApp* a) : FXMainWindow(a,"Resolver demo"){
  setTarget(this);
  setSelector(ID_MAINWINDOW);
  new FXToolTip(getApp());
  setX(400);
  setY(50);
  FXToolBar *toolbar=new FXToolBar(this,LAYOUT_FILL_X);
  new FXStatusBar(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);

  // buttons on toolbar
  new FXButton(toolbar,"&Quit",NULL,this,ID_QUIT,FRAME_RAISED);
  new FXButton(toolbar,"&Resolve",NULL,this,ID_RESOLVE,FRAME_RAISED);

  // set some defaults for hostnames...
  hostname0="localhost";
  hostname1="127.0.0.1";
  hostname2="fox-toolkit.org";
  hostname3="foxdesktop.sf.net";
  hostname4="google.com";
  hostname5="yahoo.com";
  hostname6="telstra.com";
  hostname7="slashdot.org";
  hostname8="freshmeat.net";
  hostname9="";

  // connect textfield to hostname variable
  dt0.connect(hostname0);
  dt1.connect(hostname1);
  dt2.connect(hostname2);
  dt3.connect(hostname3);
  dt4.connect(hostname4);
  dt5.connect(hostname5);
  dt6.connect(hostname6);
  dt7.connect(hostname7);
  dt8.connect(hostname8);
  dt9.connect(hostname9);

  // descriptions
  FXHorizontalFrame *frame=new FXHorizontalFrame(this,LAYOUT_FILL_X);
  new FXLabel(frame,"Enter the hostnames to lookup,\nfor multiple hosts");
  new FXLabel(frame,"The checkbox will become checked\nonce resolution has completed");

  // text fields
  FXHorizontalFrame *frame0=new FXHorizontalFrame(this,LAYOUT_FILL_X);
  FXHorizontalFrame *frame1=new FXHorizontalFrame(this,LAYOUT_FILL_X);
  FXHorizontalFrame *frame2=new FXHorizontalFrame(this,LAYOUT_FILL_X);
  FXHorizontalFrame *frame3=new FXHorizontalFrame(this,LAYOUT_FILL_X);
  FXHorizontalFrame *frame4=new FXHorizontalFrame(this,LAYOUT_FILL_X);
  FXHorizontalFrame *frame5=new FXHorizontalFrame(this,LAYOUT_FILL_X);
  FXHorizontalFrame *frame6=new FXHorizontalFrame(this,LAYOUT_FILL_X);
  FXHorizontalFrame *frame7=new FXHorizontalFrame(this,LAYOUT_FILL_X);
  FXHorizontalFrame *frame8=new FXHorizontalFrame(this,LAYOUT_FILL_X);
  FXHorizontalFrame *frame9=new FXHorizontalFrame(this,LAYOUT_FILL_X);
  new FXTextField(frame0,40,&dt0,FXDataTarget::ID_VALUE,TEXTFIELD_ENTER_ONLY|FRAME_NORMAL|LAYOUT_FILL_X);
  check0=new FXCheckButton(frame0,"");
  new FXTextField(frame1,40,&dt1,FXDataTarget::ID_VALUE,TEXTFIELD_ENTER_ONLY|FRAME_NORMAL|LAYOUT_FILL_X);
  check1=new FXCheckButton(frame1,"");
  new FXTextField(frame2,40,&dt2,FXDataTarget::ID_VALUE,TEXTFIELD_ENTER_ONLY|FRAME_NORMAL|LAYOUT_FILL_X);
  check2=new FXCheckButton(frame2,"");
  new FXTextField(frame3,40,&dt3,FXDataTarget::ID_VALUE,TEXTFIELD_ENTER_ONLY|FRAME_NORMAL|LAYOUT_FILL_X);
  check3=new FXCheckButton(frame3,"");
  new FXTextField(frame4,40,&dt4,FXDataTarget::ID_VALUE,TEXTFIELD_ENTER_ONLY|FRAME_NORMAL|LAYOUT_FILL_X);
  check4=new FXCheckButton(frame4,"");
  new FXTextField(frame5,40,&dt5,FXDataTarget::ID_VALUE,TEXTFIELD_ENTER_ONLY|FRAME_NORMAL|LAYOUT_FILL_X);
  check5=new FXCheckButton(frame5,"");
  new FXTextField(frame6,40,&dt6,FXDataTarget::ID_VALUE,TEXTFIELD_ENTER_ONLY|FRAME_NORMAL|LAYOUT_FILL_X);
  check6=new FXCheckButton(frame6,"");
  new FXTextField(frame7,40,&dt7,FXDataTarget::ID_VALUE,TEXTFIELD_ENTER_ONLY|FRAME_NORMAL|LAYOUT_FILL_X);
  check7=new FXCheckButton(frame7,"");
  new FXTextField(frame8,40,&dt8,FXDataTarget::ID_VALUE,TEXTFIELD_ENTER_ONLY|FRAME_NORMAL|LAYOUT_FILL_X);
  check8=new FXCheckButton(frame8,"");
  new FXTextField(frame9,40,&dt9,FXDataTarget::ID_VALUE,TEXTFIELD_ENTER_ONLY|FRAME_NORMAL|LAYOUT_FILL_X);
  check9=new FXCheckButton(frame9,"");

  resolver0=new FXResolver("",this,ID_RESOLVE_0);
  resolver1=new FXResolver("",this,ID_RESOLVE_1);
  resolver2=new FXResolver("",this,ID_RESOLVE_2);
  resolver3=new FXResolver("",this,ID_RESOLVE_3);
  resolver4=new FXResolver("",this,ID_RESOLVE_4);
  resolver5=new FXResolver("",this,ID_RESOLVE_5);
  resolver6=new FXResolver("",this,ID_RESOLVE_6);
  resolver7=new FXResolver("",this,ID_RESOLVE_7);
  resolver8=new FXResolver("",this,ID_RESOLVE_8);
  resolver9=new FXResolver("",this,ID_RESOLVE_9);
  }

Resolver::~Resolver(){
  delete resolver0;
  delete resolver1;
  delete resolver2;
  delete resolver3;
  delete resolver4;
  delete resolver5;
  delete resolver6;
  delete resolver7;
  delete resolver8;
  delete resolver9;
  }

void Resolver::create(){
  FXMainWindow::create();
  show();
  }

// handle quit event
long Resolver::onCmdQuit(FXObject*,FXSelector,void*){
  getApp()->exit();
  return 1;
  }

// start the resolve
long Resolver::onStart(FXObject*,FXSelector,void*){
  check0->handle(this,FXSEL(SEL_COMMAND,ID_UNCHECK),NULL);
  check1->handle(this,FXSEL(SEL_COMMAND,ID_UNCHECK),NULL);
  check2->handle(this,FXSEL(SEL_COMMAND,ID_UNCHECK),NULL);
  check3->handle(this,FXSEL(SEL_COMMAND,ID_UNCHECK),NULL);
  check4->handle(this,FXSEL(SEL_COMMAND,ID_UNCHECK),NULL);
  check5->handle(this,FXSEL(SEL_COMMAND,ID_UNCHECK),NULL);
  check6->handle(this,FXSEL(SEL_COMMAND,ID_UNCHECK),NULL);
  check7->handle(this,FXSEL(SEL_COMMAND,ID_UNCHECK),NULL);
  check8->handle(this,FXSEL(SEL_COMMAND,ID_UNCHECK),NULL);
  check9->handle(this,FXSEL(SEL_COMMAND,ID_UNCHECK),NULL);
  resolver0->host(hostname0);
  resolver1->host(hostname1);
  resolver2->host(hostname2);
  resolver3->host(hostname3);
  resolver4->host(hostname4);
  resolver5->host(hostname5);
  resolver6->host(hostname6);
  resolver7->host(hostname7);
  resolver8->host(hostname8);
  resolver9->host(hostname9);
  fxmessage("Starting resolve...");
  if (hostname0.length()) resolver0->resolve();
  if (hostname1.length()) resolver1->resolve();
  if (hostname2.length()) resolver2->resolve();
  if (hostname3.length()) resolver3->resolve();
  if (hostname4.length()) resolver4->resolve();
  if (hostname5.length()) resolver5->resolve();
  if (hostname6.length()) resolver6->resolve();
  if (hostname7.length()) resolver7->resolve();
  if (hostname8.length()) resolver8->resolve();
  if (hostname9.length()) resolver9->resolve();
  fxmessage("done\n");
  return 1;
  }

// message sent from worker thread
long Resolver::onUnResolved(FXObject *sender,FXSelector sel,void*){
  FXResolver *r=(FXResolver*)sender;
  fxmessage("Lookup failed: %s (%i)\n",r->host().text(),r->status());
  return 1;
  }

// message sent from worker thread
long Resolver::onResolved(FXObject *sender,FXSelector sel,void*){
  FXString hostname;
  sender->handle(this,FXSEL(SEL_COMMAND,ID_GETSTRINGVALUE),&hostname);
  switch (FXSELID(sel)) {
    case ID_RESOLVE_0: {
      hostname0=hostname;
      check0->handle(this,FXSEL(SEL_COMMAND,ID_CHECK),NULL);
      } break;
    case ID_RESOLVE_1: {
      hostname1=hostname;
      check1->handle(this,FXSEL(SEL_COMMAND,ID_CHECK),NULL);
      } break;
    case ID_RESOLVE_2: {
      hostname2=hostname;
      check2->handle(this,FXSEL(SEL_COMMAND,ID_CHECK),NULL);
      } break;
    case ID_RESOLVE_3: {
      hostname3=hostname;
      check3->handle(this,FXSEL(SEL_COMMAND,ID_CHECK),NULL);
      } break;
    case ID_RESOLVE_4: {
      hostname4=hostname;
      check4->handle(this,FXSEL(SEL_COMMAND,ID_CHECK),NULL);
      } break;
    case ID_RESOLVE_5: {
      hostname5=hostname;
      check5->handle(this,FXSEL(SEL_COMMAND,ID_CHECK),NULL);
      } break;
    case ID_RESOLVE_6: {
      hostname6=hostname;
      check6->handle(this,FXSEL(SEL_COMMAND,ID_CHECK),NULL);
      } break;
    case ID_RESOLVE_7: {
      hostname7=hostname;
      check7->handle(this,FXSEL(SEL_COMMAND,ID_CHECK),NULL);
      } break;
    case ID_RESOLVE_8: {
      hostname8=hostname;
      check8->handle(this,FXSEL(SEL_COMMAND,ID_CHECK),NULL);
      } break;
    case ID_RESOLVE_9: {
      hostname9=hostname;
      check9->handle(this,FXSEL(SEL_COMMAND,ID_CHECK),NULL);
      } break;
    default: fxerror("Unknown thread ID: %i\n",FXSELID(sel));
    }
  return 1;
  }

// start the ball rolling
int main(int argc,char *argv[]){
  FXApp app("Resolver Test","FoxExTest");
  app.init(argc,argv);
  new Resolver(&app);
  app.create();
  return app.run();
  }

