#ifndef __FOXAPP_H__
#define __FOXAPP_H__

class FoxApp : public FXApp {
   FXDECLARE(FoxApp)

 private:
   FXMainWindow      *mainwin;
   FXMenuBar         *menubar;
   FXHorizontalFrame *toolbar;
   FXStatusBar       *statusbar;
   FXHorizontalFrame *contents;
   FXbool             docDirty;

 protected:
   virtual void createMenu();
   virtual void createToolbar();
   virtual void createStatusbar();
   virtual void createContents();

 public:
   FoxApp();

   virtual void start( int& argc, char** argv);

   long onCmdAbout( FXObject *, FXSelector, void * );
   long onCmdOpen( FXObject *, FXSelector, void * );
   long onCmdSave( FXObject *, FXSelector, void * );
   long onCmdSaveAs( FXObject *, FXSelector, void * );
   long onCmdNew( FXObject *, FXSelector, void * );
   long onCmdPrint( FXObject *, FXSelector, void * );
   long onCmdQuit( FXObject *, FXSelector, void * );

 public:
   enum {
      ID_ABOUT = FXApp::ID_LAST,
      ID_OPEN,
      ID_SAVE,
      ID_SAVEAS,
      ID_NEW,
      ID_PRINT,
      ID_LAST
   };
};
   
#endif
