/********************************************************************************
*                                                                               *
*                  Histroy list object                                          *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "FXHistoryList.h"
using namespace FXEX;
namespace FXEX {


/* This HistoryList is a list that removes newer items than the current index(),
 * then the entry is appended to the front of the list.  The app can move up
 * and down the list.
 */

// Class implementation
FXIMPLEMENT(FXHistoryList,FXHistoryItems,NULL,0);


// Make a new History List group
FXHistoryList::FXHistoryList(FXApp *a,const FXString& gp,FXObject* tgt,FXSelector sel,FXint size):FXHistoryItems(a,gp,tgt,sel,size){}


// Add an item;all items newer than the current item pointed to (ie the index())
// those are removed, and the items is added to the top of the list
FXint FXHistoryList::add(const FXString& name,void* data){
  if ( currentItem != NULL && currentItem->name == name ) return key;
  removeNewer(key);
  return FXHistoryItems::add(name,data);
  }

}

