/********************************************************************************
*                                                                               *
*                   Scrolling text widget                                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Jereon van der Zijp.   All Rights Reserved.             *
* Copyright (C) 2003 by Mathew Robertson.      All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXTICKER
#define FXTICKER

#ifndef FXFRAME_H
#include <fox/FXFrame.h>
using namespace FX;
#endif
namespace FXEX {
 
/**
 * Ticker widget; animates a running text like a kind of stock-ticker.
 * The displayed text, its font, and animation speed can be fully configured.
 */
class FXAPI FXTicker : public FXFrame {
  FXDECLARE(FXTicker)

protected:
  FXString   label;       // The text to be displayed
  FXFont    *font;        // The font in which to display
  FXint      offset;      // The current scoll offset
  FXint      speed;       // Animation speed
  FXint      rate;        // Animation rate

protected:
  FXTicker(){}

public:
  long onTimer(FXObject*,FXSelector,void*);     // Handler for the timer message
  long onPaint(FXObject*,FXSelector,void*);     // Handler for the paint message

public:
  enum{
    ID_TIMER=FXFrame::ID_LAST,  // Message generated by the timer
    ID_LAST
    };

public:

  /// Ticker widget; draws a text that's running sideways
  FXTicker(FXComposite* p,const FXString& txt,FXuint opts=FRAME_SUNKEN|FRAME_THICK,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint  pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);

  /// Report desired width
  virtual FXint getDefaultWidth();

  /// Report desired height
  virtual FXint getDefaultHeight();

  /// Realize resources for the widget
  virtual void create();

  /// Detach resources for the widget
  virtual void detach();

  /// save resources
  virtual void save(FXStream& store) const;

  /// load resources
  virtual void load(FXStream& store);

  /// Change the text
  void setText(const FXString& txt);

  /// Return the current text
  FXString getText() const { return label; }

  /// Change drawing speed; speed of zero disables the animation
  void setSpeed(FXint s);

  /// Return current speed setting
  FXint getSpeed() const { return speed; }

  /// Change movement rate; -ve moves left; +ve moves right
  void setRate(FXint r);

  /// Get movement rate
  FXint getRate() const { return rate; }

  /// Set the text font
  void setFont(FXFont *fnt);

  /// Get the text font
  FXFont* getFont() const { return font; }

  /// Clean up
  virtual ~FXTicker();
  };

} // namespace FXEX
#endif // FXTICKER
