/********************************************************************************
* FXNetworkDialogEx.h                                                           *
* Copyright (C) 2001 by Dustin Graves. All Rights Reserved.                     *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifdef WIN32
#ifndef FXNETWORKDIALOGEX_H
#define FXNETWORKDIALOGEX_H

#ifndef FXDIALOGBOX_H
#include <fox/FXDialogBox.h>
using namespace FX;
#endif
namespace FXEX {
class FXNetworkSelectorEx;

/**
 * Browse network shares, using a dialog
 */
class FXAPI FXNetworkDialogEx : public FXDialogBox {
  FXDECLARE(FXNetworkDialogEx)

protected:
  FXNetworkSelectorEx *netbox;          // Network selection widget

protected:
  FXNetworkDialogEx(){}

private:
  FXNetworkDialogEx(const FXNetworkDialogEx&);
  FXNetworkDialogEx &operator=(const FXNetworkDialogEx&);

public:
  /// ctor
  FXNetworkDialogEx(FXWindow* owner,const FXString& name,FXuint opts=0,FXint x=0,FXint y=0,FXint w=300,FXint h=300);

  /// When called, will relist net neighborhood.  A wait cursor is optional.
  FXbool refreshNetworkList(FXbool waitCursor=FALSE);

  /// When called, option to relist net neighborhood.  A wait cursor is optional.
  void showNetworkShares(FXbool show,FXbool refresh=FALSE,FXbool waitCursor=FALSE);
  FXbool showNetworkShares() const;

  /// manipulate the current selection
  void setSelection(const FXString& name);
  FXString getSelection() const;

  // get the network names
  FXString getNetworkName(const FXString& name) const;
  FXString getSelectionNetworkName() const;

  /// manipulate the style for the net box
  void setNetBoxStyle(FXuint style);
  FXuint getNetBoxStyle() const;

  /// save to stream
  virtual void save(FXStream& store) const;

  /// load from stream
  virtual void load(FXStream& store);

  /// Specialized shows for loading net data
  void show(FXbool loadnet=FALSE);
  void show(FXuint placement,FXbool loadnet=FALSE);
  FXuint execute(FXuint placement=PLACEMENT_CURSOR,FXbool loadnet=FALSE);

  /// dtor
  virtual ~FXNetworkDialogEx();
  };

} // namespace FXEX
#endif // FXNETWORKDIALOGEX_H
#endif
