/**
 * Version 1.02, 10/11/2001
 * an example for the usage of FXExThread-classes by Daniel Gehringer.
 * created by me (Ingo Assenmacher) on request from Haizhou Ding(Roger).
 * I hope this helps you in your work.
 *
 * Code compiles and links using:
 * Linux (SuSe7.0, although that is not important)
 * KDevelop 1.2, there are configure and so on scripts as well, but I did not try those (created by KDevelop,
 * so I think they should work).
 * Tested: gcc 2.95.3
 * Take a look at the other classes from FXExThread, as Daniel provided some important classes for a more complex
 * synchronising of threads!
 * Contact me for any questions!
 * mailto: ingoassenmacher@yahoo.de
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <stdlib.h>

#if defined(__GNUC__)
#include <fox/fx.h>
#else
#include "fx.h"
#endif


#include "FXExThreadEvent.h"
#include "FXExThread.h"

// prototypes
class EvWin;


// globals
char text[2000];
EvWin *w = NULL;
void *worker_task(void *);



// classes
class EvWin : public FXMainWindow
{
	FXDECLARE(EvWin);
	private:
	protected:
	EvWin() {};
	public:
	EvWin(FXApp *a);
	~EvWin() {};
	
	enum
	{
		ID_THREAD_EVENT = FXMainWindow::ID_LAST,
		ID_START,
		ID_CQUIT,
		ID_LAST,
	};
	
	long onThreadEvent(FXObject *, FXSelector, void *);
	
	FXExThreadEvent *event;
	FXExThread *thread;
	FXLabel *textLabel;
	
	long onQuitButton(FXObject *,FXSelector, void *);
	
};

// NOTE:
// SEL_THREAD_EVENT is the proper mask for this!

FXDEFMAP(EvWin) EvMap[]={
  FXMAPFUNC(SEL_THREAD_EVENT, EvWin::ID_THREAD_EVENT,EvWin::onThreadEvent),
  FXMAPFUNC(SEL_COMMAND, EvWin::ID_CQUIT, EvWin::onQuitButton),
};


FXIMPLEMENT(EvWin,FXMainWindow,EvMap,ARRAYNUMBER(EvMap));

EvWin::EvWin(FXApp *a)
: FXMainWindow(a,"FXExThreadDemo 1.02", NULL,NULL,DECOR_ALL,0,20,400,150)
{
	// create event
	event = new FXExThreadEvent(this);
	event->setSelector(ID_THREAD_EVENT);
	
	// create thread representation
	thread = new FXExThread(worker_task);

  FXVerticalFrame *vframe = new FXVerticalFrame(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);
	textLabel = new FXLabel(vframe, "None right now.", NULL, (JUSTIFY_LEFT|ICON_BEFORE_TEXT|LAYOUT_FILL_X));
	
  new FXLabel(vframe, "V1.01, 10/11/01\ncontact: ingoassenmacher@yahoo.de\nSmall app to demonstrate the usage of FOX and Threads\nWatch the 'Count' above\nThanks to Daniel Gehringer and of course Jeroen\n", NULL, (ICON_BEFORE_TEXT|LAYOUT_FILL_X));
  new FXButton(vframe, "Quit", NULL, this, EvWin::ID_CQUIT, FRAME_THICK|FRAME_RAISED|LAYOUT_TOP|LAYOUT_FILL_X,0,0,0,0,10,10,5,5);


	// clear mem, just for the sake of it ;)
	memset(text,0,2000);
};

long EvWin::onThreadEvent(FXObject *o, FXSelector, void *)
{

	// simply update the text of the label with the content from the global variable
	textLabel->setText(text);	
	return 1;
};


FXExMutex mutex;
int bRunning = 1;

long EvWin::onQuitButton(FXObject *, FXSelector, void *)
{
	// we have been called to quit!
	mutex.lock();
	// thread stopped here!
	bRunning = 0;
	mutex.unlock();
	this->getApp()->exit();
	return 0;
};


void *worker_task(void *)
{
// worker task, now there better be no REAL reference to anything that belongs to FOX
// (besides the call to the event's signal method)
	// get a pointer to my own thread object!
	FXExThread *me = FXExThread::self();
	int i=0;
	do
	{
		mutex.lock();
		// text is READ-ONLY by main task, so this is safe! (and time is long enough to reflect changes in FXLabel!
		sprintf(text, "Count: %d", i++);		
		
		// signale the main-task to call onThreadEvent (see method-map)
		w->event->signal();
		
		// put myself to sleep for two seconds
		me->sleep(2);
		mutex.unlock();
	}
	while(bRunning); // triggered stop
	me->exit();
	return NULL;
};


int main(int argc, char *argv[])
{

	FXApp *application = new FXApp("FXExThread Demo 1.02", "FXExThread Demo 1.02");
	application->init(argc,argv);
	
	w = new EvWin(application);
	application->create();
	
	w->show();
	w->thread->start();
	application->run();
	return 0;
}
