// charmetrics.h                                Copyright (C) 2020 Codemist


/**************************************************************************
 * Copyright (C) 2020, Codemist.                         A C Norman       *
 *                                                                        *
 * Redistribution and use in source and binary forms, with or without     *
 * modification, are permitted provided that the following conditions are *
 * met:                                                                   *
 *                                                                        *
 *     * Redistributions of source code must retain the relevant          *
 *       copyright notice, this list of conditions and the following      *
 *       disclaimer.                                                      *
 *     * Redistributions in binary form must reproduce the above          *
 *       copyright notice, this list of conditions and the following      *
 *       disclaimer in the documentation and/or other materials provided  *
 *       with the distribution.                                           *
 *                                                                        *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS    *
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT      *
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS      *
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE         *
 * COPYRIGHT OWNERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,   *
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,   *
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS  *
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND *
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR  *
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF     *
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH   *
 * DAMAGE.                                                                *
 *************************************************************************/

// $Id: charmetrics.h 5432 2020-10-15 20:40:59Z arthurcnorman $


#ifndef __STDC_CONSTANT_MACROS
#define __STDC_CONSTANT_MACROS 1
#endif

#include <stdint.h>

// Character metric hash table created using the program charmetrics.cpp
// sourceforge.net/p/reduce-algebra/code/HEAD/tree/trunk/csl/cslbase/wxfontxs
// contains README files with full credits to the fonts this is used with


// The list of font codes here must be kept in step with the list
// of names in the table.

#define F_cmuntt                      0
#define F_odokai                      1
#define F_Regular                     2
#define F_Bold                        3
#define F_Italic                      4
#define F_BoldItalic                  5
#define F_Math                        6
#define F_end                         7

extern int c_width, c_llx, c_lly, c_urx, c_ury, c_kerninfo;
extern int lookupchar(int fontnum, int codepoint);
extern int32_t lookupkernandligature(int codepoint);
extern int32_t lookupkernadjustment(int codepoint);
extern int32_t lookupligature(int codepoint);
extern int accentposition(int codepoint);

extern const std::uint16_t chardepth_WIN32[31];
extern const std::uint16_t chardepth_X11[31];
extern const std::uint16_t chardepth_OSX[31];
extern const std::uint16_t *chardepth;
extern const char *fontnames[31];

const uint64_t charmetrics[10057][5] =
{   {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000888d), UINT64_C(0x1362f78f608745f1), UINT64_C(0x1362f78f608745f1),
        UINT64_C(0x0ffb1e0f6c6665f1), UINT64_C(0x156b028f6c89c5f1)
    },
    {   UINT64_C(0x00000000000188dc), UINT64_C(0x18d2fbcce09ae6d7), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000888e), UINT64_C(0x156afa13108e25e7), UINT64_C(0x156afa0f8c8e25e7),
        UINT64_C(0x156afa0f8c8e25e7), UINT64_C(0x156afa0f6c8e25f1)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000188df), UINT64_C(0x1b3afa8c30a50630), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008890), UINT64_C(0x08f2f6cef85da60b), UINT64_C(0x156afa11008e2590),
        UINT64_C(0x156afa107c8e25a5), UINT64_C(0x156afa107c8e25a5)
    },
    {   UINT64_C(0x0000000000080008), UINT64_C(0x106aee0fa03e83e8), UINT64_C(0x106b1fcfa0670656),
        UINT64_C(0x106b0e54c06fc655), UINT64_C(0x106af6cfa07ba64a)
    },
    {   UINT64_C(0x0000000000000009), UINT64_C(0x106afc8e5478c69e), UINT64_C(0x106af6ce547ba69e),
        UINT64_C(0x106af50f747bc656), UINT64_C(0x106b2454c064c655)
    },
    {   UINT64_C(0x000000000000000a), UINT64_C(0x106b194e5875269e), UINT64_C(0x106b040e586a869e),
        UINT64_C(0x106aff11087785f1), UINT64_C(0x106af750e47b45fa)
    },
    {   UINT64_C(0x000000000000000b), UINT64_C(0x106b1b0d7469c465), UINT64_C(0x106b03d2847504de),
        UINT64_C(0x106b1fcfa0670465), UINT64_C(0x106afc8e5478a69e)
    },
    {   UINT64_C(0x000000000000000c), UINT64_C(0x106afa8f7479c656), UINT64_C(0x106b084fa075c656),
        UINT64_C(0x106afb0fa0798656), UINT64_C(0x106af90f747a8656)
    },
    {   UINT64_C(0x000000000000000d), UINT64_C(0x106af54fa07c6657), UINT64_C(0x106afb0f7479864b),
        UINT64_C(0x106afb4f74796656), UINT64_C(0x106af90f747a865b)
    },
    {   UINT64_C(0x000000000000000e), UINT64_C(0x106af90f747a8656), UINT64_C(0x106afb4f74796656),
        UINT64_C(0x106b200fa0672597), UINT64_C(0x106b1b0d7469c596)
    },
    {   UINT64_C(0x000000000000000f), UINT64_C(0x106afc109079060f), UINT64_C(0x106af752bc7b4584),
        UINT64_C(0x106afc109079060f), UINT64_C(0x106afd8fa0784651)
    },
    {   UINT64_C(0x0000000000000010), UINT64_C(0x106af90f887a8651), UINT64_C(0x106af4cfa07ca657),
        UINT64_C(0x106af3cfa07ac64b), UINT64_C(0x106af80f747b0656)
    },
    {   UINT64_C(0x0000000000000011), UINT64_C(0x106af2cfa07b264b), UINT64_C(0x106af48fa07d464b),
        UINT64_C(0x106af50fa07bc64b), UINT64_C(0x106af78f747c8656)
    },
    {   UINT64_C(0x0000000680000012), UINT64_C(0x106af38fa07d464b), UINT64_C(0x106b01cfa076464b),
        UINT64_C(0x106affcf747a464b), UINT64_C(0x106af48fa07c664b)
    },
    {   UINT64_C(0x0000000000000013), UINT64_C(0x106af60fa07b864b), UINT64_C(0x106af24fa07de64b),
        UINT64_C(0x106af50fa07c864b), UINT64_C(0x106afc0f74790656)
    },
    {   UINT64_C(0x0000000000000014), UINT64_C(0x106af48fa07a864b), UINT64_C(0x106afc0d74790656),
        UINT64_C(0x106af38f747fc64b), UINT64_C(0x106afb0f74798656)
    },
    {   UINT64_C(0x0000000000000015), UINT64_C(0x106af48fa07cc64b), UINT64_C(0x106aef0f747f864b),
        UINT64_C(0x106af28f807dc64b), UINT64_C(0x106af0cf807ea64b)
    },
    {   UINT64_C(0x0000000000000016), UINT64_C(0x106af4cfa07c864b), UINT64_C(0x106af2cfa07da64b),
        UINT64_C(0x106afa0fa07aa64b), UINT64_C(0x106b254e547ae69e)
    },
    {   UINT64_C(0x0000000000000017), UINT64_C(0x106afc8e5478a69e), UINT64_C(0x106af80e5464469e),
        UINT64_C(0x106b01163876861d), UINT64_C(0x106afc0e247903cf)
    },
    {   UINT64_C(0x0000000000000018), UINT64_C(0x106b09178866a667), UINT64_C(0x106afbcf888005a0),
        UINT64_C(0x106af10f887b864b), UINT64_C(0x106b004f8878c5a0)
    },
    {   UINT64_C(0x0000360000000019), UINT64_C(0x106af70f887e864b), UINT64_C(0x106afbcf887885a0),
        UINT64_C(0x106af88fa0752651), UINT64_C(0x106af54c0c7e25a2)
    },
    {   UINT64_C(0x000000078000001a), UINT64_C(0x106af10fa07e864b), UINT64_C(0x106b018fa077664c),
        UINT64_C(0x106afa0c106c864c), UINT64_C(0x106af34fa07e064b)
    },
    {   UINT64_C(0x000000000000001b), UINT64_C(0x106afc8fa078e64b), UINT64_C(0x106aed0fa080859d),
        UINT64_C(0x106af10fa07e859d), UINT64_C(0x106afc4f8878e5a0)
    },
    {   UINT64_C(0x000000000000001c), UINT64_C(0x106af10c287b859d), UINT64_C(0x106af80c2881a59d),
        UINT64_C(0x106af60fa07b659d), UINT64_C(0x106b000f8877e5a0)
    },
    {   UINT64_C(0x000000000000001d), UINT64_C(0x106af44f8876a612), UINT64_C(0x106af10f887e8597),
        UINT64_C(0x106af40f907d0597), UINT64_C(0x106af20f907e0597)
    },
    {   UINT64_C(0x000000000000001e), UINT64_C(0x106af4cfa07c8597), UINT64_C(0x106af48c107d0597),
        UINT64_C(0x106af64fa079e597), UINT64_C(0x106afc0e5478e69e)
    },
    {   UINT64_C(0x000000000000001f), UINT64_C(0x106b26ce5463a69e), UINT64_C(0x106afc0e5478e69e),
        UINT64_C(0x106affd74c77064b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000619d), UINT64_C(0x1f42ff4fecb766cd), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd4e7cb7e6de)
    },
    {   UINT64_C(0x000000000000889d), UINT64_C(0x156afa0c108e26c3), UINT64_C(0x156afa0c0c8e26c2),
        UINT64_C(0x156afc0c708c26a9), UINT64_C(0x156afc0c708c26a9)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000889e), UINT64_C(0x156afa0bb88e26d6), UINT64_C(0x156afa0bb88e26d6),
        UINT64_C(0x156afe0f388c25fc), UINT64_C(0x156afe0f388c25fc)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000889f), UINT64_C(0x156afe0dc08c265c), UINT64_C(0x156afe0dc48c265d),
        UINT64_C(0x156afa0d108e2680), UINT64_C(0x156afa0d108e2680)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000088a0), UINT64_C(0x156afe0d308c267e), UINT64_C(0x156afe0d308c267e),
        UINT64_C(0x156afe0f3c8c25fb), UINT64_C(0x156afe0f3c8c25fb)
    },
    {   UINT64_C(0x0000000000000028), UINT64_C(0x106aee0fa03e83e8), UINT64_C(0x106b1fcbfc67056d),
        UINT64_C(0x106af8cde47c4608), UINT64_C(0x106af94f8c7d2653)
    },
    {   UINT64_C(0x0000000000000029), UINT64_C(0x106ae10f0886a637), UINT64_C(0x106af28fa07da64b),
        UINT64_C(0x106b26ce5863a69e), UINT64_C(0x106b028c1075c650)
    },
    {   UINT64_C(0x000000000000002a), UINT64_C(0x106b09979c72464b), UINT64_C(0x106adb4bfc8986a9),
        UINT64_C(0x106af693007e06a7), UINT64_C(0x106af8cfa0762597)
    },
    {   UINT64_C(0x000000000000002b), UINT64_C(0x106af8d0347aa550), UINT64_C(0x106b19d2846a24de),
        UINT64_C(0x106adb4bfc8986a9), UINT64_C(0x106b00185c76e656)
    },
    {   UINT64_C(0x000000000000002c), UINT64_C(0x106b0a147c71e64b), UINT64_C(0x106af751c47b4632),
        UINT64_C(0x106afcd46478a6a9), UINT64_C(0x106afa545079e6a9)
    },
    {   UINT64_C(0x000000000000002d), UINT64_C(0x106b209788726667), UINT64_C(0x106af0cc287ea596),
        UINT64_C(0x106af9cc287d064b), UINT64_C(0x106b2312446584f5)
    },
    {   UINT64_C(0x000000000000002e), UINT64_C(0x106b0e0c606fe421), UINT64_C(0x106b04546475c6a9),
        UINT64_C(0x106af693007ba6a6), UINT64_C(0x106b018fa07a8597)
    },
    {   UINT64_C(0x000000000000002f), UINT64_C(0x106aedcc288066a9), UINT64_C(0x106aedcc288066a9),
        UINT64_C(0x106aedcc288066a9), UINT64_C(0x106afd4c1078456c)
    },
    {   UINT64_C(0x0000000000000030), UINT64_C(0x106af4cfa07ca70f), UINT64_C(0x106af4cfa07ca70f),
        UINT64_C(0x106af4cfa07ca720), UINT64_C(0x106af4cfa07ca71b)
    },
    {   UINT64_C(0x0000000000000031), UINT64_C(0x106af4cfa07ca71b), UINT64_C(0x106af4cfa07c8723),
        UINT64_C(0x106af38fa07d064b), UINT64_C(0x106af80c607b2656)
    },
    {   UINT64_C(0x0000000000000032), UINT64_C(0x106af48fa07d470f), UINT64_C(0x106af48fa07d470f),
        UINT64_C(0x106af48fa07d4720), UINT64_C(0x106af48fa07d471b)
    },
    {   UINT64_C(0x0000000000000033), UINT64_C(0x106b01cfa076470f), UINT64_C(0x106b01cfa076470f),
        UINT64_C(0x106b01cfa0764720), UINT64_C(0x106b01cfa076471b)
    },
    {   UINT64_C(0x0000000000000034), UINT64_C(0x106af28fa07b264b), UINT64_C(0x106af50fa07c871b),
        UINT64_C(0x106afc0f7479070f), UINT64_C(0x106afc0f7479070f)
    },
    {   UINT64_C(0x0000000000000035), UINT64_C(0x106afc0f74790720), UINT64_C(0x106afc0f7479071b),
        UINT64_C(0x106afc0f7479071b), UINT64_C(0x106b0551c47465c2)
    },
    {   UINT64_C(0x0000000000000036), UINT64_C(0x106afc0e5079069f), UINT64_C(0x106aef0f747f870f),
        UINT64_C(0x106aef0f747f870f), UINT64_C(0x106aef0f747f8720)
    },
    {   UINT64_C(0x0000000000000037), UINT64_C(0x106aef0f747f871b), UINT64_C(0x106af2cfa07da70f),
        UINT64_C(0x106af58fa07a064b), UINT64_C(0x106af20f8c7ba650)
    },
    {   UINT64_C(0x0000000000000038), UINT64_C(0x106afbcf88800667), UINT64_C(0x106afbcf88800667),
        UINT64_C(0x106afbcf8880066c), UINT64_C(0x106afbcf88800671)
    },
    {   UINT64_C(0x0000000000000039), UINT64_C(0x106afbcf8880064b), UINT64_C(0x106afbcf8880066f),
        UINT64_C(0x106af60f8c7d859f), UINT64_C(0x106b000c6078a59f)
    },
    {   UINT64_C(0x000000000000003a), UINT64_C(0x106afbcf88788667), UINT64_C(0x106afbcf88788667),
        UINT64_C(0x106afbcf8878866c), UINT64_C(0x106afbcf8878864b)
    },
    {   UINT64_C(0x000000000000003b), UINT64_C(0x106b018fa0776667), UINT64_C(0x106b018fa0776667),
        UINT64_C(0x106b018fa077666c), UINT64_C(0x106b078fa074464b)
    },
    {   UINT64_C(0x000000000000003c), UINT64_C(0x106afc0f8c78e64b), UINT64_C(0x106af10fa07e8671),
        UINT64_C(0x106afc4f8878e667), UINT64_C(0x106afc4f8878e667)
    },
    {   UINT64_C(0x000000000000003d), UINT64_C(0x106afc4f8878e66c), UINT64_C(0x106afc4f8878e671),
        UINT64_C(0x106afc4f8878e64b), UINT64_C(0x106af750d47b45fe)
    },
    {   UINT64_C(0x000000000000003e), UINT64_C(0x106af88d707aa623), UINT64_C(0x106af10f887e8667),
        UINT64_C(0x106af10f887e8667), UINT64_C(0x106af10f887e866c)
    },
    {   UINT64_C(0x000000000000003f), UINT64_C(0x106af10f887e864b), UINT64_C(0x106af48c107d0667),
        UINT64_C(0x106af0cc287b864b), UINT64_C(0x106af48c107d064b)
    },
    {   UINT64_C(0x0000000000000040), UINT64_C(0x106af4cfa07ca6cf), UINT64_C(0x106afbcf88800639),
        UINT64_C(0x106af4cfa07ca71b), UINT64_C(0x106afbcf88800667)
    },
    {   UINT64_C(0x0000000000000041), UINT64_C(0x106af4cbfc7fc657), UINT64_C(0x106afbcbfc80059f),
        UINT64_C(0x106af80f747b070f), UINT64_C(0x106b004f8878c667)
    },
    {   UINT64_C(0x0000000000000042), UINT64_C(0x106af80f747b0724), UINT64_C(0x106b004f8878c66d),
        UINT64_C(0x106af80f747b06ec), UINT64_C(0x106b004f8878c635)
    },
    {   UINT64_C(0x0000000000000043), UINT64_C(0x106af80f747b070c), UINT64_C(0x106b004f8878c667),
        UINT64_C(0x106af2cfa07b270c), UINT64_C(0x106af48f8c7f466d)
    },
    {   UINT64_C(0x0000000000000044), UINT64_C(0x106af28fa07b264b), UINT64_C(0x106af6cf8c7e864b),
        UINT64_C(0x106af48fa07d46ce), UINT64_C(0x106afbcf88788638)
    },
    {   UINT64_C(0x0000000000000045), UINT64_C(0x106af48fa07d4715), UINT64_C(0x106afbcf8878865d),
        UINT64_C(0x106af48fa07d46ec), UINT64_C(0x106afbcf88788635)
    },
    {   UINT64_C(0x0000000000000046), UINT64_C(0x106af44bfc7d664b), UINT64_C(0x106afbcbfc78a59f),
        UINT64_C(0x106af48fa07d470c), UINT64_C(0x106afbcf88788667)
    },
    {   UINT64_C(0x0000000000000047), UINT64_C(0x106af78f747d4724), UINT64_C(0x106af54c0c7e2670),
        UINT64_C(0x106af74f747c871b), UINT64_C(0x106af54c0c7e2667)
    },
    {   UINT64_C(0x0000000000000048), UINT64_C(0x106af78f747c86ec), UINT64_C(0x106af54c0c7e2638),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000049), UINT64_C(0x106af38fa07d4724), UINT64_C(0x106af10fa07e8719),
        UINT64_C(0x0000000000000000), UINT64_C(0x106af1cfa07ee64b)
    },
    {   UINT64_C(0x000000000000004a), UINT64_C(0x106b01cfa0764729), UINT64_C(0x106b018fa0776674),
        UINT64_C(0x106b000fa076e6c7), UINT64_C(0x106b014fa0778638)
    },
    {   UINT64_C(0x000000000000004b), UINT64_C(0x106b01cfa0764715), UINT64_C(0x106b018fa077665d),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000004c), UINT64_C(0x106b01cfa0764706), UINT64_C(0x106b018fa0776597),
        UINT64_C(0x106af08f747c864b), UINT64_C(0x106af74c1478e64b)
    },
    {   UINT64_C(0x000000000000004d), UINT64_C(0x106affcf747e2724), UINT64_C(0x106afa0c1072066d),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000004e), UINT64_C(0x0000000000000000), UINT64_C(0x106af60fa07b870f),
        UINT64_C(0x106afc8fa078e70f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000004f), UINT64_C(0x0000000000000000), UINT64_C(0x106af60fa07b86ac),
        UINT64_C(0x106afc8fa07ea66d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000050), UINT64_C(0x0000000000000000), UINT64_C(0x106af58fa07b864b),
        UINT64_C(0x106afc4fa078e64b), UINT64_C(0x106af50fa07c870f)
    },
    {   UINT64_C(0x0000000000000051), UINT64_C(0x106af10fa07e8667), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x106af50fa07c870c)
    },
    {   UINT64_C(0x0000000000000052), UINT64_C(0x106af10fa07e8667), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af20f747b465d), UINT64_C(0x106af0cc1474059c)
    },
    {   UINT64_C(0x0000000000000053), UINT64_C(0x106afc0f747906ce), UINT64_C(0x106afc4f8878e638),
        UINT64_C(0x106afc0f74790715), UINT64_C(0x106afc4f8878e65d)
    },
    {   UINT64_C(0x0000000000000054), UINT64_C(0x106afc0f747ee70f), UINT64_C(0x106afc4f887fc667),
        UINT64_C(0x106af54f747d6656), UINT64_C(0x106af28f8c7da59f)
    },
    {   UINT64_C(0x0000000000000055), UINT64_C(0x106af38f747fc70f), UINT64_C(0x106af60fa07b6667),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000056), UINT64_C(0x106af38f747fc70c), UINT64_C(0x106af60fa07b6667),
        UINT64_C(0x106afb0f7479870f), UINT64_C(0x106b000f8c77e667)
    },
    {   UINT64_C(0x0000000000000057), UINT64_C(0x106afb0f74798724), UINT64_C(0x106b000f8877e66d),
        UINT64_C(0x106afb0c60798656), UINT64_C(0x106b000c6077e59f)
    },
    {   UINT64_C(0x0000000000000058), UINT64_C(0x106afb0f7479870c), UINT64_C(0x106b000f8c77e667),
        UINT64_C(0x106af48c607ce64b), UINT64_C(0x106af44c5c76c611)
    },
    {   UINT64_C(0x0000000000000059), UINT64_C(0x106af48fa07cc70c), UINT64_C(0x106af44f887a0672),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000005a), UINT64_C(0x106aef0f747f8729), UINT64_C(0x106af10f887e8674),
        UINT64_C(0x106aef0f747f86ce), UINT64_C(0x106af10f887e8638)
    },
    {   UINT64_C(0x000000000000005b), UINT64_C(0x106aef0f747f8715), UINT64_C(0x106af10f887e865d),
        UINT64_C(0x106aef0f747f8723), UINT64_C(0x106af10f887e866f)
    },
    {   UINT64_C(0x000000000000005c), UINT64_C(0x106aef0f7480270f), UINT64_C(0x106af10f887fe667),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000005d), UINT64_C(0x106af0cf807ea724), UINT64_C(0x106af20f907e066d),
        UINT64_C(0x106af2cfa07da724), UINT64_C(0x106af48c107d066d)
    },
    {   UINT64_C(0x000000000000005e), UINT64_C(0x106af2cfa07da71b), UINT64_C(0x106afa0fa07aa70f),
        UINT64_C(0x106af64fa079e667), UINT64_C(0x106afa0fa07aa707)
    },
    {   UINT64_C(0x01f000000000005f), UINT64_C(0x106af64fa079e64b), UINT64_C(0x106afa0fa07aa70c),
        UINT64_C(0x106af64fa079e667), UINT64_C(0x106af88fa0752651)
    },
    {   UINT64_C(0x0000000000000060), UINT64_C(0x106aee4f8c7b864b), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000061), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af80f747b0656), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000001000062), UINT64_C(0x106afd8f8c84e632), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000063), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af44fa07d664b), UINT64_C(0x106af0cf747d2656)
    },
    {   UINT64_C(0x0000000000000064), UINT64_C(0x106afa4f7480a656), UINT64_C(0x0000000000000000),
        UINT64_C(0x106aef4c1080c650), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000065), UINT64_C(0x0000000000000000), UINT64_C(0x106aedcf8c7ce64b),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000066), UINT64_C(0x0000000000000000), UINT64_C(0x106af30fa07e0651),
        UINT64_C(0x106b014fa076664b), UINT64_C(0x106aee8f8c79864b)
    },
    {   UINT64_C(0x0000000000000067), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af14c2881c59c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000068), UINT64_C(0x106afc0f747c66af), UINT64_C(0x106afc0f8c78e5fa),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000069), UINT64_C(0x0000000000000000), UINT64_C(0x106aea8c287b2651),
        UINT64_C(0x0000000000000000), UINT64_C(0x106afb0f74798656)
    },
    {   UINT64_C(0x000000000000006a), UINT64_C(0x106b000f8c77e59f), UINT64_C(0x0000000000000000),
        UINT64_C(0x106b020c1078a651), UINT64_C(0x106af3cc10730612)
    },
    {   UINT64_C(0x000000000000006b), UINT64_C(0x0000000000000000), UINT64_C(0x106af3cf8c774651),
        UINT64_C(0x0000000000000000), UINT64_C(0x106aeecf748026ae)
    },
    {   UINT64_C(0x000000000000006c), UINT64_C(0x106af0cf8c7ea5fa), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000006d), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x106af78f747b264b)
    },
    {   UINT64_C(0x000000000000006e), UINT64_C(0x0000000000000000), UINT64_C(0x106afa4c1479e596),
        UINT64_C(0x106afa0c147a6596), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000006f), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x106aee0b8c7a859a)
    },
    {   UINT64_C(0x0000000000000070), UINT64_C(0x106b268c2863c64b), UINT64_C(0x106b0c4c2870c64b),
        UINT64_C(0x106afb0c2879864b), UINT64_C(0x106b230fa0658656)
    },
    {   UINT64_C(0x0000000000000071), UINT64_C(0x106af04fa07d670c), UINT64_C(0x106af04fa07d0667),
        UINT64_C(0x106af28f8c7d0667), UINT64_C(0x106af1cf747d464b)
    },
    {   UINT64_C(0x0000000000000072), UINT64_C(0x106af1cc1076664b), UINT64_C(0x106af54c1076664b),
        UINT64_C(0x106af18f747d464b), UINT64_C(0x106af18c1076664b)
    },
    {   UINT64_C(0x0000000000000073), UINT64_C(0x106aef8c1076664b), UINT64_C(0x106af4cfa07ca724),
        UINT64_C(0x106afbcf8880066c), UINT64_C(0x106b01cfa0764723)
    },
    {   UINT64_C(0x0000000000000074), UINT64_C(0x106b018fa077666b), UINT64_C(0x106afc0f74790723),
        UINT64_C(0x106afc4f8878e66c), UINT64_C(0x106aef0f747f8723)
    },
    {   UINT64_C(0x0000000000000075), UINT64_C(0x106af10f887e866b), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000077), UINT64_C(0x0000000000000000), UINT64_C(0x106af94f8c77259f),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000078), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af38fa07f06ce), UINT64_C(0x106af60f8c7d8639)
    },
    {   UINT64_C(0x0000000000000079), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af78f747c8723), UINT64_C(0x106af54c0c7e266e)
    },
    {   UINT64_C(0x000000000000007a), UINT64_C(0x106af48fa07c6723), UINT64_C(0x106af34fa07e0718),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000581d), UINT64_C(0x0000000000000000), UINT64_C(0x1f4309ce88adc71a),
        UINT64_C(0x1f43144f94ac06f1), UINT64_C(0x1f43010edcb2070b)
    },
    {   UINT64_C(0x000000000000007c), UINT64_C(0x106afa0c106fa66b), UINT64_C(0x106af04fa07d664b),
        UINT64_C(0x106af04fa07d064b), UINT64_C(0x106af28f8c7d064b)
    },
    {   UINT64_C(0x000000000000007d), UINT64_C(0x106af78f747c8701), UINT64_C(0x106af54c0c7e2659),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000007e), UINT64_C(0x106af50fa07c8701), UINT64_C(0x106af10fa07e8656),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000007f), UINT64_C(0x106af38fa07d0701), UINT64_C(0x106af60f8c7d8656),
        UINT64_C(0x106afc0e5079074b), UINT64_C(0x106af88d707aa6da)
    },
    {   UINT64_C(0x0000000000000080), UINT64_C(0x106af4cfa07ca70e), UINT64_C(0x106afbcf88800655),
        UINT64_C(0x106af4cfa07ca72a), UINT64_C(0x106afbcf88800671)
    },
    {   UINT64_C(0x0000000000000081), UINT64_C(0x106af48fa07d470d), UINT64_C(0x106afbcf88788655),
        UINT64_C(0x106af48fa07d4729), UINT64_C(0x106afbcf88788671)
    },
    {   UINT64_C(0x0000000000000082), UINT64_C(0x106b01cfa076470d), UINT64_C(0x106b018fa0776655),
        UINT64_C(0x106b01cfa0764729), UINT64_C(0x106b018fa0776671)
    },
    {   UINT64_C(0x0000000000000083), UINT64_C(0x106afc0f7479070d), UINT64_C(0x106afc4f8878e655),
        UINT64_C(0x106afc0f74790729), UINT64_C(0x106afc4f8878e671)
    },
    {   UINT64_C(0x0000000000000084), UINT64_C(0x106af38f747fc70d), UINT64_C(0x106af60fa07b6655),
        UINT64_C(0x106af38f747fc729), UINT64_C(0x106af60fa07b6671)
    },
    {   UINT64_C(0x0000000000000085), UINT64_C(0x106aef0f747f870d), UINT64_C(0x106af10f887e8655),
        UINT64_C(0x106aef0f747f8729), UINT64_C(0x106af10f887e8671)
    },
    {   UINT64_C(0x0000000000000086), UINT64_C(0x106afb0bc8798656), UINT64_C(0x106b000be077e5a0),
        UINT64_C(0x106af48bf87cc64b), UINT64_C(0x106af44be076a612)
    },
    {   UINT64_C(0x0000000000000087), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af38fa07d4723), UINT64_C(0x106af10fa07e8718)
    },
    {   UINT64_C(0x0000000000000088), UINT64_C(0x0000000000000000), UINT64_C(0x106af54c947de64b),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000089), UINT64_C(0x0000000000000000), UINT64_C(0x106af54c60798596),
        UINT64_C(0x106af4cfa07ca6ed), UINT64_C(0x106afbcf88800635)
    },
    {   UINT64_C(0x0000000000018964), UINT64_C(0x25e3858ae4d60776), UINT64_C(0x2582ee0b98d48744),
        UINT64_C(0x2582ee0b5cd48752), UINT64_C(0x2582ee0b5cd48752)
    },
    {   UINT64_C(0x000000000000008b), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106afc0f747906ec), UINT64_C(0x106afc4f8878e635)
    },
    {   UINT64_C(0x000000000000008c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af2cfa07da6ce), UINT64_C(0x106af48c107d0610)
    },
    {   UINT64_C(0x000044000000008d), UINT64_C(0x0000000000000000), UINT64_C(0x106aefcc947de59c),
        UINT64_C(0x106ae54c9478e612), UINT64_C(0x106afa0c106c8597)
    },
    {   UINT64_C(0x000000000000008e), UINT64_C(0x106af30f8c7d664b), UINT64_C(0x106af30c287d659c),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000018969), UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x1c72f94d28aaa67e),
        UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x1c72f94d28aaa67e)
    },
    {   UINT64_C(0x000000000001896a), UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x1c72f94d28aaa67e),
        UINT64_C(0x0f22f610407705b4), UINT64_C(0x0f22f610407705b4)
    },
    {   UINT64_C(0x000000000001896b), UINT64_C(0x1fe2f78f74b945bd), UINT64_C(0x1fe2f78f74b945bd),
        UINT64_C(0x1182f80c307f86bc), UINT64_C(0x1182f80c307f86bc)
    },
    {   UINT64_C(0x000000000001896c), UINT64_C(0x23a2f50f74c985ea), UINT64_C(0x23a2f54f74c965ea),
        UINT64_C(0x23caf6cda4c94713), UINT64_C(0x23caf6cda4c94713)
    },
    {   UINT64_C(0x000000000001896d), UINT64_C(0x14a2f4d0108d8611), UINT64_C(0x14a2f4d0108d8611),
        UINT64_C(0x209aff8b2cbc86fe), UINT64_C(0x209aff8b30bc86ff)
    },
    {   UINT64_C(0x0000000000000094), UINT64_C(0x106aee0f8079459c), UINT64_C(0x106af6cf8c7e859c),
        UINT64_C(0x106af0cf8c7b859c), UINT64_C(0x106b00cf8c7b2651)
    },
    {   UINT64_C(0x02a0480000000095), UINT64_C(0x106afccf8076e59c), UINT64_C(0x106afc0d0877a59f),
        UINT64_C(0x106af6cc1486864b), UINT64_C(0x106af6cf8c89c651)
    },
    {   UINT64_C(0x0000000000000096), UINT64_C(0x106af94f8c77659f), UINT64_C(0x106af80f8078a59c),
        UINT64_C(0x106af64f8080059c), UINT64_C(0x106afe0f8c78c59f)
    },
    {   UINT64_C(0x0000000000000097), UINT64_C(0x106af98f747a45a2), UINT64_C(0x106af68f748465a2),
        UINT64_C(0x106af54f747a85a2), UINT64_C(0x106b00cc10778596)
    },
    {   UINT64_C(0x0000000001600098), UINT64_C(0x106af6cbf889c613), UINT64_C(0x106af7cbf876a59c),
        UINT64_C(0x106af8cf807bc59f), UINT64_C(0x106af40bfc7ce596)
    },
    {   UINT64_C(0x0000000000000099), UINT64_C(0x106af08f747ec5a2), UINT64_C(0x106af1cc287e8596),
        UINT64_C(0x106af0cfa07ea651), UINT64_C(0x106af14c1476a651)
    },
    {   UINT64_C(0x000000000000009a), UINT64_C(0x106b014fa079264b), UINT64_C(0x106b00cf8c70c597),
        UINT64_C(0x106b0c4fa070e596), UINT64_C(0x106b004fa076e64b)
    },
    {   UINT64_C(0x0000000b8000009b), UINT64_C(0x106af9cfa077664b), UINT64_C(0x106aff0c107b464b),
        UINT64_C(0x106af0cc147c064b), UINT64_C(0x106af38f8c808596)
    },
    {   UINT64_C(0x034000000000009c), UINT64_C(0x106af38c28808596), UINT64_C(0x106aed4c1479c59c),
        UINT64_C(0x106ae44c147ea59c), UINT64_C(0x106af0cc1486a59c)
    },
    {   UINT64_C(0x000000000000009d), UINT64_C(0x106afa4fa079c596), UINT64_C(0x106afc0f8c78e59f),
        UINT64_C(0x106af6cf807ca59f), UINT64_C(0x106af3cf8c7d05b8)
    },
    {   UINT64_C(0x03a000000000009e), UINT64_C(0x106af70c287b664b), UINT64_C(0x106af74f8c7c2596),
        UINT64_C(0x106af74f8c7c2675), UINT64_C(0x106af74c10896596)
    },
    {   UINT64_C(0x000000000000009f), UINT64_C(0x106af5cc287b659c), UINT64_C(0x106af5cc107f259c),
        UINT64_C(0x106af5cfa07b659c), UINT64_C(0x106b01cfa074e59c)
    },
    {   UINT64_C(0x04000000000000a0), UINT64_C(0x106af88f807ee596), UINT64_C(0x106af88fa07ee59f),
        UINT64_C(0x106b000c1477e59f), UINT64_C(0x106afc8c1478c651)
    },
    {   UINT64_C(0x00000000021000a1), UINT64_C(0x106af20c107e0613), UINT64_C(0x106af98c147a459c),
        UINT64_C(0x106afb4b9478c651), UINT64_C(0x106b00cdb47ce59c)
    },
    {   UINT64_C(0x00000000000000a2), UINT64_C(0x106af4cc10800612), UINT64_C(0x106af0cf8c7ea596),
        UINT64_C(0x106afb0f74796596), UINT64_C(0x106af20f8c7a259b)
    },
    {   UINT64_C(0x00000000000000a3), UINT64_C(0x106af3cfa07d059b), UINT64_C(0x106af1cfa07e259b),
        UINT64_C(0x106af3cfa07cc67a), UINT64_C(0x106af6cfa07b8596)
    },
    {   UINT64_C(0x00000000022000a4), UINT64_C(0x106af58c108b8596), UINT64_C(0x106af54d047d2596),
        UINT64_C(0x106afa0c107ac596), UINT64_C(0x106af68b94800596)
    },
    {   UINT64_C(0x00000000000000a5), UINT64_C(0x106afc8fa078c651), UINT64_C(0x106afc8fa078c651),
        UINT64_C(0x106afc8f8c78c64b), UINT64_C(0x106aff8c1078c654)
    },
    {   UINT64_C(0x04a00000000000a6), UINT64_C(0x106afc0f70790657), UINT64_C(0x106af98fa07a2596),
        UINT64_C(0x106af8cf747c65a2), UINT64_C(0x106af88f80880631)
    },
    {   UINT64_C(0x00000000000000a7), UINT64_C(0x106af88fa07a8596), UINT64_C(0x106b02cc1480664b),
        UINT64_C(0x106af24c287da597), UINT64_C(0x106afc0fa07ac596)
    },
    {   UINT64_C(0x00000000026000a8), UINT64_C(0x106af6cc2889c613), UINT64_C(0x106afc8fa078c651),
        UINT64_C(0x106afc8fa078c651), UINT64_C(0x106af30f8c7bc64b)
    },
    {   UINT64_C(0x04e00000000000a9), UINT64_C(0x106af40c147d264b), UINT64_C(0x106af30d047d864b),
        UINT64_C(0x106af18f8c7cc64f), UINT64_C(0x106af24c147d6651)
    },
    {   UINT64_C(0x00000000000000aa), UINT64_C(0x106af1cd087a2611), UINT64_C(0x106af44c14780650),
        UINT64_C(0x106af70f8c7aa64b), UINT64_C(0x106af70fa07c064b)
    },
    {   UINT64_C(0x00000000000000ab), UINT64_C(0x106af1cf987e25cc), UINT64_C(0x106b0b0f9c7185c6),
        UINT64_C(0x106aef8c287ea59c), UINT64_C(0x106aef8c1482a59c)
    },
    {   UINT64_C(0x00000000000000ac), UINT64_C(0x106aef953c5e8680), UINT64_C(0x106aef953c5e8683),
        UINT64_C(0x106af41374558680), UINT64_C(0x106af2153c5ce629)
    },
    {   UINT64_C(0x00000000000000ad), UINT64_C(0x106af2d5305d6626), UINT64_C(0x106af2d374640626),
        UINT64_C(0x106af3553c5ea62a), UINT64_C(0x106af1d5307e2625)
    },
    {   UINT64_C(0x05000000000000ae), UINT64_C(0x106af153745dc626), UINT64_C(0x106b1fd70467064b),
        UINT64_C(0x106b0a571c75064b), UINT64_C(0x106b1b9570698690)
    },
    {   UINT64_C(0x00000000000000af), UINT64_C(0x106b1b13f86ac64b), UINT64_C(0x106b1b945c69864b),
        UINT64_C(0x106b180fa06ae4fc), UINT64_C(0x106b180fa06ae4fc)
    },
    {   UINT64_C(0x00000000000000b0), UINT64_C(0x106afe550077e6a4), UINT64_C(0x106afe550077e6a4),
        UINT64_C(0x106b0696b473c66a), UINT64_C(0x106b0696b473a66a)
    },
    {   UINT64_C(0x00000000000000b1), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106b07174073a66c), UINT64_C(0x106b0b9730716667)
    },
    {   UINT64_C(0x00000000000000b2), UINT64_C(0x106b27958863264b), UINT64_C(0x106b0017a876e629),
        UINT64_C(0x106b1e971871664b), UINT64_C(0x106b0b171867a64b)
    },
    {   UINT64_C(0x00000000000000b3), UINT64_C(0x106b278c286323f3), UINT64_C(0x0000000000000000),
        UINT64_C(0x106b090c8c66a3a8), UINT64_C(0x106b208c8c7263a8)
    },
    {   UINT64_C(0x00000000000000b4), UINT64_C(0x106b138f8c6d459c), UINT64_C(0x106b1393d86d459c),
        UINT64_C(0x106b1811c86ae586), UINT64_C(0x106b1811c86ae586)
    },
    {   UINT64_C(0x00000000000000b5), UINT64_C(0x106b06d08073850e), UINT64_C(0x106b06d08473850f),
        UINT64_C(0x106b0acfa071a50e), UINT64_C(0x106afe118c77e51c)
    },
    {   UINT64_C(0x00000000000000b6), UINT64_C(0x106b035768754667), UINT64_C(0x106b29579c68a64b),
        UINT64_C(0x106b1917046a666f), UINT64_C(0x106b1bcca073c420)
    },
    {   UINT64_C(0x00000000000000b7), UINT64_C(0x106b04174c75064b), UINT64_C(0x106b03578880e667),
        UINT64_C(0x106ae5d29c6de59d), UINT64_C(0x106b0b16ec716640)
    },
    {   UINT64_C(0x00000000000000b8), UINT64_C(0x106af113685dc626), UINT64_C(0x106af5553c5ba680),
        UINT64_C(0x106af715305b262a), UINT64_C(0x106af1953c5d6626)
    },
    {   UINT64_C(0x00000000000000b9), UINT64_C(0x106af5553c5ba683), UINT64_C(0x106ae58f1884866e),
        UINT64_C(0x106ae58f1884866e), UINT64_C(0x106ae58f1884866e)
    },
    {   UINT64_C(0x00000000000000ba), UINT64_C(0x106ae58f1884866e), UINT64_C(0x106ae58f1484866e),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000583d), UINT64_C(0x1f43000f64ac070b), UINT64_C(0x1f43034f18ae870d),
        UINT64_C(0x1f43048f18b1c72b), UINT64_C(0x1f430ccf44b30721)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000088eb), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x09daee131065e506)
    },
    {   UINT64_C(0x00000000000000be), UINT64_C(0x0000000000000000), UINT64_C(0x106b07155c7d6640),
        UINT64_C(0x106af3555c738640), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000018999), UINT64_C(0x156af68e148fe649), UINT64_C(0x156af68dfc8fe643),
        UINT64_C(0x156af84dfc8ee649), UINT64_C(0x156af68e148fe643)
    },
    {   UINT64_C(0x00000000000000c0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x106aee17b8800675)
    },
    {   UINT64_C(0x00000000000088ed), UINT64_C(0x1cf2fbd898ab66e6), UINT64_C(0x1cf2fbce54ab6455),
        UINT64_C(0x1cf2fbcfccab65d7), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000000c2), UINT64_C(0x0000000000000000), UINT64_C(0x106b1617606c06bf),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000000c3), UINT64_C(0x0000000000000000), UINT64_C(0x106b26d72c63a65d),
        UINT64_C(0x106b13d72c6d065d), UINT64_C(0x106b03d71c71c64b)
    },
    {   UINT64_C(0x00000000000000c4), UINT64_C(0x0000000000000000), UINT64_C(0x106b03572c75466c),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001899f), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x2512ff8b64ca06ef), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000189a0), UINT64_C(0x2043188f44aa4685), UINT64_C(0x2043188f44aa4685),
        UINT64_C(0x2043188f44aa4685), UINT64_C(0x2043188f44aa4685)
    },
    {   UINT64_C(0x00000000000189a1), UINT64_C(0x2043188f44aa4685), UINT64_C(0x2043188f44aa4685),
        UINT64_C(0x2043140ef8aca697), UINT64_C(0x2043140ef8aca697)
    },
    {   UINT64_C(0x00000000000000c8), UINT64_C(0x0000000000000000), UINT64_C(0x106afa4c1063440a),
        UINT64_C(0x106b278c1079c40a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000000c9), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106b214bbc6683a7), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000000ca), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106b0b0a6c718369), UINT64_C(0x106affca4877036b)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000000cd), UINT64_C(0x0000000000000000), UINT64_C(0x106b04d2dc74a4f3),
        UINT64_C(0x0000000000000000), UINT64_C(0x106b04d15c74a568)
    },
    {   UINT64_C(0x00000000000000ce), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106b0b0a6c716368), UINT64_C(0x106b0ac9f4716369)
    },
    {   UINT64_C(0x00000000000000cf), UINT64_C(0x106af80afc7b236e), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000189aa), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x17d2fa8e6497862f), UINT64_C(0x17d2fa8e6497862f)
    },
    {   UINT64_C(0x00000000000189ab), UINT64_C(0x11aaf98fd87f65cf), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000189ac), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x12dafe4d8481c666), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000000d3), UINT64_C(0x0000000000000000), UINT64_C(0x106aef4a047f43e0),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000061f7), UINT64_C(0x1f42f70ee0b64704), UINT64_C(0x1f42f9ceccb826fe),
        UINT64_C(0x1f43144ef0af8703), UINT64_C(0x1f42f90ea8b80716)
    },
    {   UINT64_C(0x00000000000088f7), UINT64_C(0x1f42ee0e10bb844c), UINT64_C(0x1f42ee1870bb86e4),
        UINT64_C(0x1f42ee0dd8bb84be), UINT64_C(0x1f42ee1870bb8764)
    },
    {   UINT64_C(0x00000000000061f8), UINT64_C(0x1f42f84f10b4a711), UINT64_C(0x1f42fbcf00b5071c),
        UINT64_C(0x1f42f68e90b3e71e), UINT64_C(0x1f42f8ced0b2072f)
    },
    {   UINT64_C(0x00000000000088f8), UINT64_C(0x1f42ee0dd8bb844c), UINT64_C(0x1f42ee1870bb86f2),
        UINT64_C(0x23c2fb8eccc6c616), UINT64_C(0x1c73028cd8a60690)
    },
    {   UINT64_C(0x00000000000000d8), UINT64_C(0x0000000000000000), UINT64_C(0x106b26d68c94c667),
        UINT64_C(0x106af20a047e03e0), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000088f9), UINT64_C(0x2232f9d310c16506), UINT64_C(0x1fd2f3cf50bae5f7),
        UINT64_C(0x1cf2fbd0c0ab659a), UINT64_C(0x18f31e8e1c9a2646)
    },
    {   UINT64_C(0x00000000000061fa), UINT64_C(0x1f42fc4e74afe721), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fccf64b5871c), UINT64_C(0x1f42fe4e50b446fa)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000061fb), UINT64_C(0x1f42fbce9cb7e711), UINT64_C(0x1f42f70f38b3e6f1),
        UINT64_C(0x1f42fecf58b1c726), UINT64_C(0x1f42fcceecb86731)
    },
    {   UINT64_C(0x00000000000000dd), UINT64_C(0x106b16570462464c), UINT64_C(0x106b21cd746803e8),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000000de), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106b270cc06383b2), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000000df), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106b1b4d7867c596), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000061fd), UINT64_C(0x1f43020ea4b0e71f), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fcd048b246d6), UINT64_C(0x1f42facea4b1c711)
    },
    {   UINT64_C(0x00000000000000e1), UINT64_C(0x106b1fd70467064b), UINT64_C(0x106b1197046e064b),
        UINT64_C(0x106af40fa07f4673), UINT64_C(0x106b1fd464670596)
    },
    {   UINT64_C(0x00000000000000e2), UINT64_C(0x106ad90fa0800667), UINT64_C(0x106ad90fa0800667),
        UINT64_C(0x106aeb4fa07fe667), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000000e3), UINT64_C(0x106ae4cf707fa672), UINT64_C(0x0000000000000000),
        UINT64_C(0x106ade4fa07de672), UINT64_C(0x106ade4fa07ea672)
    },
    {   UINT64_C(0x00000000000000e4), UINT64_C(0x106b020f8c6b464c), UINT64_C(0x106af4cfa07ca673),
        UINT64_C(0x106af38fa07ac667), UINT64_C(0x106af58fa07ba667)
    },
    {   UINT64_C(0x00000000000000e5), UINT64_C(0x106af68fa07bc673), UINT64_C(0x106af44fa07d6667),
        UINT64_C(0x106af9cfa07aa667), UINT64_C(0x106af30fa07d6667)
    },
    {   UINT64_C(0x00000000000000e6), UINT64_C(0x106afc0f70792672), UINT64_C(0x106b018fa0762667),
        UINT64_C(0x106af44fa07c6667), UINT64_C(0x106af50fa07c6673)
    },
    {   UINT64_C(0x00000000000000e7), UINT64_C(0x106af24fa07de667), UINT64_C(0x106af4cfa07c8667),
        UINT64_C(0x106af5cfa07c0667), UINT64_C(0x106afc0f70792672)
    },
    {   UINT64_C(0x00000000000000e8), UINT64_C(0x106af30fa07d6667), UINT64_C(0x106af44fa07a8667),
        UINT64_C(0x0000000000000000), UINT64_C(0x106af80fa07b0667)
    },
    {   UINT64_C(0x00000000000000e9), UINT64_C(0x106af48fa07cc667), UINT64_C(0x106af74fa07b4672),
        UINT64_C(0x106af80fa07b0667), UINT64_C(0x106af44fa07ca667)
    },
    {   UINT64_C(0x00000000000000ea), UINT64_C(0x106af74fa07b6667), UINT64_C(0x106af5cfa07c0672),
        UINT64_C(0x106b018fa07626f6), UINT64_C(0x106af74fa07b46f6)
    },
    {   UINT64_C(0x00000000000000eb), UINT64_C(0x106af8cf8c80464c), UINT64_C(0x106af8cf747a864c),
        UINT64_C(0x106af2cbfc7ac64c), UINT64_C(0x106b13cf8c6b464c)
    },
    {   UINT64_C(0x00000000000000ec), UINT64_C(0x106af8cf8c7a8683), UINT64_C(0x106af8cf8c80459c),
        UINT64_C(0x106af8cbfc7a866c), UINT64_C(0x106af54cdc7a859c)
    },
    {   UINT64_C(0x00000000000000ed), UINT64_C(0x106af98f8c7a4662), UINT64_C(0x106af8cf747a85a2),
        UINT64_C(0x106af98d8c7a4672), UINT64_C(0x106af2cbfc7ac5a2)
    },
    {   UINT64_C(0x00000000000000ee), UINT64_C(0x106af98f8c7a466c), UINT64_C(0x106b178f8c6b459c),
        UINT64_C(0x106af90f687a65a4), UINT64_C(0x106af54f8c7c6669)
    },
    {   UINT64_C(0x00000000000000ef), UINT64_C(0x106af80c147f85a1), UINT64_C(0x106af5cf8c7a859f),
        UINT64_C(0x106af98d8c7a4672), UINT64_C(0x106af84f8c7ae59c)
    },
    {   UINT64_C(0x00000000000000f0), UINT64_C(0x106af50f8c7ba596), UINT64_C(0x106af88c287a859c),
        UINT64_C(0x106af8cde47a859c), UINT64_C(0x106af78f8c79259c)
    },
    {   UINT64_C(0x00000000000000f1), UINT64_C(0x106af5cf8c7a0596), UINT64_C(0x106af8cf8c7a85a1),
        UINT64_C(0x106af74bfc7b65a2), UINT64_C(0x106af7cc0c7b259d)
    },
    {   UINT64_C(0x00000000000000f2), UINT64_C(0x106af8cbfc7a8672), UINT64_C(0x106af60f8c7c05a1),
        UINT64_C(0x106aed4f8c70e667), UINT64_C(0x106af8cf8c7a8666)
    },
    {   UINT64_C(0x00000000000000f3), UINT64_C(0x106af84f8c7ae64c), UINT64_C(0x106af8cf8c7a864c),
        UINT64_C(0x106af60f8c7c064c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000000f4), UINT64_C(0x0000000000000000), UINT64_C(0x106af98f8c7a466c),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000189cf), UINT64_C(0x0000000000000000), UINT64_C(0x1552f6cdf08cc64c),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000000f6), UINT64_C(0x106af6cfa07bc66c), UINT64_C(0x106afc4ec478c647),
        UINT64_C(0x106afa8f347d0667), UINT64_C(0x106af9cf5c7ae5a2)
    },
    {   UINT64_C(0x00000000000000f7), UINT64_C(0x106af4cfa07bc667), UINT64_C(0x106afc4c2878c597),
        UINT64_C(0x0000000000000000), UINT64_C(0x106afc4e0c78e604)
    },
    {   UINT64_C(0x00000000000000f8), UINT64_C(0x106aea8fa07cc682), UINT64_C(0x106af8cf747a8667),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000585c), UINT64_C(0x1f43018f4cb10706), UINT64_C(0x1f43040ea0b06723),
        UINT64_C(0x1f43000efcae4718), UINT64_C(0x1f42fecf3cb78700)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000585d), UINT64_C(0x1f42fe0f18aee70b), UINT64_C(0x1f4302ceb8b26738),
        UINT64_C(0x1f42f98e78b04741), UINT64_C(0x1f42ffce9cb82735)
    },
    {   UINT64_C(0x000000000000620b), UINT64_C(0x1f42f90f20b44702), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f7ce78b3e70f), UINT64_C(0x1f42ff4e48af4736)
    },
    {   UINT64_C(0x00000000000000fd), UINT64_C(0x0000000000000000), UINT64_C(0x106afacf8c79c59c),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000620c), UINT64_C(0x1f42f9ce38b50738), UINT64_C(0x1f4310ced8afc72d),
        UINT64_C(0x1f42fa4edcb1e705), UINT64_C(0x1f42f74f00b4c706)
    },
    {   UINT64_C(0x000000000000585f), UINT64_C(0x1f430d0ee0ad472e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43010f40b16712), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000100), UINT64_C(0x106af48fa07d470f), UINT64_C(0x106af48fa07d471b),
        UINT64_C(0x106af38f747e264b), UINT64_C(0x106af94fa07aa70f)
    },
    {   UINT64_C(0x0000000000000101), UINT64_C(0x106af80f747b0656), UINT64_C(0x106afb0f74798656),
        UINT64_C(0x106b01cfa076464b), UINT64_C(0x106b01cfa076471b)
    },
    {   UINT64_C(0x0000000000000102), UINT64_C(0x106affcf747a464b), UINT64_C(0x106af14f747ca64b),
        UINT64_C(0x106af08fa07ca64b), UINT64_C(0x106af40fa07f064b)
    },
    {   UINT64_C(0x0000000000000103), UINT64_C(0x106af48fa07c670f), UINT64_C(0x106af28fa07da70f),
        UINT64_C(0x106af44f747d472d), UINT64_C(0x106af28d087da64b)
    },
    {   UINT64_C(0x0000000000000104), UINT64_C(0x106af4cfa07ca657), UINT64_C(0x106af38fa07ac64b),
        UINT64_C(0x106af3cfa07ac64b), UINT64_C(0x106af94fa07aa64b)
    },
    {   UINT64_C(0x0000000000000105), UINT64_C(0x106af10d087ea64b), UINT64_C(0x106af48fa07d464b),
        UINT64_C(0x106aee0fa080064b), UINT64_C(0x106afc0f747a6656)
    },
    {   UINT64_C(0x0000000000000106), UINT64_C(0x106af28fa07da64b), UINT64_C(0x106af28fa07da72d),
        UINT64_C(0x106af48fa07c664b), UINT64_C(0x106af2cf747da64b)
    },
    {   UINT64_C(0x0000000000000107), UINT64_C(0x106af24fa07de64b), UINT64_C(0x106af28fa07da64b),
        UINT64_C(0x106afc0f74790656), UINT64_C(0x106af28fa07da64b)
    },
    {   UINT64_C(0x0000000000000108), UINT64_C(0x106af48fa07a864b), UINT64_C(0x106af80f747b0656),
        UINT64_C(0x106af48fa07cc64b), UINT64_C(0x106af44f747d464b)
    },
    {   UINT64_C(0x0000000000000109), UINT64_C(0x106af2cfa07da64b), UINT64_C(0x106af4cfa07c864b),
        UINT64_C(0x106af28d087e864b), UINT64_C(0x106af28fa07da64b)
    },
    {   UINT64_C(0x000000000000010a), UINT64_C(0x106af08fa07ee64b), UINT64_C(0x106af08d087f664b),
        UINT64_C(0x106af30fa07be64b), UINT64_C(0x106af0cfa07e864b)
    },
    {   UINT64_C(0x000000000000010b), UINT64_C(0x106af94fa078a64b), UINT64_C(0x106af7cf747b0656),
        UINT64_C(0x106aee0f747f2656), UINT64_C(0x106af54fa07dc64b)
    },
    {   UINT64_C(0x000000000000010c), UINT64_C(0x106afbcf888005a0), UINT64_C(0x106afc0f8c78e64b),
        UINT64_C(0x106af14fa0786597), UINT64_C(0x106af94fa0790596)
    },
    {   UINT64_C(0x000000000000010d), UINT64_C(0x106af04d787ec596), UINT64_C(0x106afbcf887885a0),
        UINT64_C(0x106aee4fa07fc596), UINT64_C(0x106afb0f8c78059f)
    },
    {   UINT64_C(0x000000000000010e), UINT64_C(0x106af24fa07dc596), UINT64_C(0x106af24fa07dc678),
        UINT64_C(0x106af24fa07e0596), UINT64_C(0x106af28f807dc596)
    },
    {   UINT64_C(0x000000000000010f), UINT64_C(0x106af08fa07ec596), UINT64_C(0x106af24fa07dc596),
        UINT64_C(0x106afc4f8878e5a0), UINT64_C(0x106af24fa07dc596)
    },
    {   UINT64_C(0x0000000000000110), UINT64_C(0x106af10c287b859d), UINT64_C(0x106b004f8878c5a0),
        UINT64_C(0x106af48fa07cc596), UINT64_C(0x106af48c107d0597)
    },
    {   UINT64_C(0x0000000000000111), UINT64_C(0x106aef0c287f864b), UINT64_C(0x106af4cfa07c6596),
        UINT64_C(0x106af24d787ee596), UINT64_C(0x106af24fa07dc596)
    },
    {   UINT64_C(0x0000000000000112), UINT64_C(0x106aeecfa07fa596), UINT64_C(0x106aeecd78806596),
        UINT64_C(0x106af2cfa079c596), UINT64_C(0x106aefcfa07f2596)
    },
    {   UINT64_C(0x0000000000000113), UINT64_C(0x106af90fa078c596), UINT64_C(0x106afc8f8c76e59f),
        UINT64_C(0x106aee8f8c7fc59f), UINT64_C(0x106af20fa07e8596)
    },
    {   UINT64_C(0x0000000000000114), UINT64_C(0x106afbcf88788667), UINT64_C(0x106afbcf8878864a),
        UINT64_C(0x106aeb8c287ca64b), UINT64_C(0x106af9cfa07ac667)
    },
    {   UINT64_C(0x0000000000000115), UINT64_C(0x106b000f8c78c59f), UINT64_C(0x106b000f8877e5a0),
        UINT64_C(0x106b018fa077664c), UINT64_C(0x106b018fa077664b)
    },
    {   UINT64_C(0x0000000000000116), UINT64_C(0x106afa0c106c864c), UINT64_C(0x106af14f807d2596),
        UINT64_C(0x106aef4fa07d2596), UINT64_C(0x106aeb8fa07ec64b)
    },
    {   UINT64_C(0x0000000000000117), UINT64_C(0x106af24fa07e0667), UINT64_C(0x106af24fa07dc667),
        UINT64_C(0x106af48c107d0678), UINT64_C(0x106af24d787dc596)
    },
    {   UINT64_C(0x0000000000000118), UINT64_C(0x106af54f747c8656), UINT64_C(0x106aef0f8c7fa59f),
        UINT64_C(0x106af38fa07b869e), UINT64_C(0x106af28fa0786683)
    },
    {   UINT64_C(0x0000000000000119), UINT64_C(0x106aee0f747cc656), UINT64_C(0x106aee8f8c7ae59f),
        UINT64_C(0x106af44fa07ce657), UINT64_C(0x106af38fa07d259d)
    },
    {   UINT64_C(0x000000000000011a), UINT64_C(0x106aee0fa07de657), UINT64_C(0x106aec8fa07e259d),
        UINT64_C(0x106af00fa07ee64b), UINT64_C(0x106af08fa07ec596)
    },
    {   UINT64_C(0x000000000000011b), UINT64_C(0x106aee0fa07f264b), UINT64_C(0x106aeb4fa07f2596),
        UINT64_C(0x106af10c147b26e0), UINT64_C(0x106af84c1477861d)
    },
    {   UINT64_C(0x000000000000011c), UINT64_C(0x106af74fa07b464b), UINT64_C(0x106aec8c2881064b),
        UINT64_C(0x106afc0f70790656), UINT64_C(0x106af9cf747a25a2)
    },
    {   UINT64_C(0x000000000000011d), UINT64_C(0x106af20f807dc656), UINT64_C(0x106af34f807de59c),
        UINT64_C(0x106aeecf807dc70f), UINT64_C(0x106aed4f807e0667)
    },
    {   UINT64_C(0x000000000000011e), UINT64_C(0x106af30f747d864b), UINT64_C(0x106b034f74756650),
        UINT64_C(0x106af98ebc7a4684), UINT64_C(0x106af8ced87aa5cb)
    },
    {   UINT64_C(0x000000000000011f), UINT64_C(0x106aeb0f747ca726), UINT64_C(0x106aef0f8c7fa672),
        UINT64_C(0x106af54f747c871c), UINT64_C(0x106aef0f8c7fa667)
    },
    {   UINT64_C(0x0000000000000120), UINT64_C(0x106af80bfc7fa656), UINT64_C(0x106b000c147b45a4),
        UINT64_C(0x106afe4e047b64b6), UINT64_C(0x106af9972c7a4672)
    },
    {   UINT64_C(0x0000000000000121), UINT64_C(0x106af0968883a672), UINT64_C(0x106b11d72c6dc656),
        UINT64_C(0x106b12572c6e0656), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000122), UINT64_C(0x106ace4b289006de), UINT64_C(0x106aba89a899e73e),
        UINT64_C(0x106af28d087e872d), UINT64_C(0x106af24d787ee678)
    },
    {   UINT64_C(0x0000000000000123), UINT64_C(0x106af3cfa07b864b), UINT64_C(0x106aef8fa0786667),
        UINT64_C(0x106af44fa07a864b), UINT64_C(0x106af0cc2880659c)
    },
    {   UINT64_C(0x0000000000000124), UINT64_C(0x106af94fa07aa6f2), UINT64_C(0x106af94fa07925da),
        UINT64_C(0x106aec0fa07ae64b), UINT64_C(0x106af94fa0790596)
    },
    {   UINT64_C(0x0000000000000125), UINT64_C(0x106af38c107ac64b), UINT64_C(0x106af94c107c4596),
        UINT64_C(0x106aee0d0880464b), UINT64_C(0x106aee4d787fe596)
    },
    {   UINT64_C(0x0000000000000126), UINT64_C(0x106afc0bf07a6656), UINT64_C(0x106afb0bf078059f),
        UINT64_C(0x106af44d087c864b), UINT64_C(0x106af24d787e0596)
    },
    {   UINT64_C(0x0000000000000127), UINT64_C(0x106af30fa07cc64b), UINT64_C(0x106af10fa07e6596),
        UINT64_C(0x106aea4fa07c664b), UINT64_C(0x106af24fa07e064b)
    },
    {   UINT64_C(0x0000000000000128), UINT64_C(0x106af30fa07d264b), UINT64_C(0x106af2cfa07e6596),
        UINT64_C(0x106af28d087e864b), UINT64_C(0x106af24d787ee596)
    },
    {   UINT64_C(0x0000000000000129), UINT64_C(0x106af0cfa07da64b), UINT64_C(0x106af08fa07dc597),
        UINT64_C(0x106aed4c107fc64b), UINT64_C(0x106aee8c10814596)
    },
    {   UINT64_C(0x000000000000012a), UINT64_C(0x106afc0dfc7da656), UINT64_C(0x106afc0dfc79659f),
        UINT64_C(0x106af80bf07b2656), UINT64_C(0x106b000bf078a59f)
    },
    {   UINT64_C(0x000000000000012b), UINT64_C(0x106af48d087ce64b), UINT64_C(0x106af44d787cc596),
        UINT64_C(0x106af2cfa07da64b), UINT64_C(0x106af1cc287e2596)
    },
    {   UINT64_C(0x000000000000012c), UINT64_C(0x106af28fa07da64b), UINT64_C(0x106af1cc287e2596),
        UINT64_C(0x106af4cd087d464b), UINT64_C(0x106af4cd787d2596)
    },
    {   UINT64_C(0x000000000000012d), UINT64_C(0x106af2cd087f464b), UINT64_C(0x106aeecd787fc596),
        UINT64_C(0x106af28d087e864b), UINT64_C(0x106af24d787ee596)
    },
    {   UINT64_C(0x000000000000012e), UINT64_C(0x106af28fa07da64b), UINT64_C(0x106af24fa07dc596),
        UINT64_C(0x106af28fa07da64b), UINT64_C(0x106af10fa07e864b)
    },
    {   UINT64_C(0x000000000000012f), UINT64_C(0x106af24f747ee656), UINT64_C(0x106af3cf8c79e59f),
        UINT64_C(0x106af24c187ee656), UINT64_C(0x106af3cc0c79e59f)
    },
    {   UINT64_C(0x0000000000000130), UINT64_C(0x106b01cfa076464b), UINT64_C(0x106aee0fa080071b),
        UINT64_C(0x106aee4fa07fc667), UINT64_C(0x106af44c107b264b)
    },
    {   UINT64_C(0x0000000000000131), UINT64_C(0x106af24c147b6596), UINT64_C(0x106af2cd087da64b),
        UINT64_C(0x106af28d787ec596), UINT64_C(0x106af28c147da64b)
    },
    {   UINT64_C(0x0000000000000132), UINT64_C(0x106af24c147dc596), UINT64_C(0x106af28d087e664b),
        UINT64_C(0x106af24d787ec596), UINT64_C(0x106af28d087da64b)
    },
    {   UINT64_C(0x0000000000000133), UINT64_C(0x106af24d787dc596), UINT64_C(0x106af24d087e864b),
        UINT64_C(0x106af08d787fa596), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000134), UINT64_C(0x106af4cfa07ca71b), UINT64_C(0x106afbcf88800667),
        UINT64_C(0x106af4cfa07ca71b), UINT64_C(0x106afbcf8880064b)
    },
    {   UINT64_C(0x0000000000000135), UINT64_C(0x106af38fa07d064b), UINT64_C(0x106af60f8c7d859f),
        UINT64_C(0x106af48fa07d471b), UINT64_C(0x106afbcf88788667)
    },
    {   UINT64_C(0x0000000000000136), UINT64_C(0x106af0cf747d2656), UINT64_C(0x106af8cf8c77a59c),
        UINT64_C(0x106af08f747d671b), UINT64_C(0x106af8cf8c77a64b)
    },
    {   UINT64_C(0x0000000000000137), UINT64_C(0x106aee0fa080071b), UINT64_C(0x106aee4fa07fc64b),
        UINT64_C(0x106afc0f747a671b), UINT64_C(0x106afb0f8c78064a)
    },
    {   UINT64_C(0x0000000000000138), UINT64_C(0x106af78f747b264b), UINT64_C(0x106afa4c1079e596),
        UINT64_C(0x106af28fa07da71b), UINT64_C(0x106af24fa07dc656)
    },
    {   UINT64_C(0x0000000000000139), UINT64_C(0x106af28fa07da71b), UINT64_C(0x106af24fa07dc64a),
        UINT64_C(0x106afc0f7479071b), UINT64_C(0x106afc4f8878e64a)
    },
    {   UINT64_C(0x000000000000013a), UINT64_C(0x106afc0f70790656), UINT64_C(0x106afc0f8c78e59f),
        UINT64_C(0x106afc0f7079071b), UINT64_C(0x106afc0f8c78e64a)
    },
    {   UINT64_C(0x000000000000013b), UINT64_C(0x106af7cf747b071b), UINT64_C(0x106afc4f8c76e64a),
        UINT64_C(0x106af44f747d471b), UINT64_C(0x106af48c107d0656)
    },
    {   UINT64_C(0x000000000000013c), UINT64_C(0x106af44f747d471b), UINT64_C(0x106af48c107d064b),
        UINT64_C(0x106af44f747f670f), UINT64_C(0x106af48c107f4667)
    },
    {   UINT64_C(0x000000000000013d), UINT64_C(0x106af28fa07da71b), UINT64_C(0x106af24fa07dc64a),
        UINT64_C(0x106af94d087aa64b), UINT64_C(0x106af94d78790596)
    },
    {   UINT64_C(0x000000000000013e), UINT64_C(0x106af0cfa07e871b), UINT64_C(0x106aefcfa07f264b),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000013f), UINT64_C(0x106af4cc1478e64b), UINT64_C(0x106af4cc147aa596),
        UINT64_C(0x106af10fa07e864b), UINT64_C(0x106af4cfa07c6596)
    },
    {   UINT64_C(0x000000000000622d), UINT64_C(0x1f42f5cef0b7a718), UINT64_C(0x1f42fbcf54b4a70a),
        UINT64_C(0x1f42fa8e1cb6a721), UINT64_C(0x1f42f98f94b7a6ff)
    },
    {   UINT64_C(0x000000000000892d), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c)
    },
    {   UINT64_C(0x000000000000622e), UINT64_C(0x1f42f68eacb406ff), UINT64_C(0x1f42fa8f44afa6f6),
        UINT64_C(0x1f42f88f34ac270c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000892e), UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c),
        UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c)
    },
    {   UINT64_C(0x0000000000000144), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af2cc147da64b), UINT64_C(0x106af28c147dc596)
    },
    {   UINT64_C(0x000000000000892f), UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c),
        UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c)
    },
    {   UINT64_C(0x0000000000006230), UINT64_C(0x1f42ff8f6cae86fb), UINT64_C(0x1f42fd4e74b2a744),
        UINT64_C(0x1f430ece64b48725), UINT64_C(0x1f42f68ef0b76728)
    },
    {   UINT64_C(0x0000000000008930), UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c),
        UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c)
    },
    {   UINT64_C(0x0000000000006231), UINT64_C(0x1f42f58f18b7a70d), UINT64_C(0x1f43040f14b2670e),
        UINT64_C(0x1f42fb8fb4ad26ff), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008931), UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c),
        UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c)
    },
    {   UINT64_C(0x0000000000006232), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8ef8b346fa),
        UINT64_C(0x1f43014e38b1074c), UINT64_C(0x1f42fa8eb8b5c702)
    },
    {   UINT64_C(0x0000000000008932), UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c),
        UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c)
    },
    {   UINT64_C(0x0000000000006233), UINT64_C(0x1f42f88f64b1c6f6), UINT64_C(0x1f42f78f28b14706),
        UINT64_C(0x1f42fa8f94b1470e), UINT64_C(0x1f43068eb8b2c72d)
    },
    {   UINT64_C(0x0000000000008933), UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c),
        UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c)
    },
    {   UINT64_C(0x0000000000006234), UINT64_C(0x1f42f68e7ca78702), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff4e88b0272c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008934), UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c),
        UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c)
    },
    {   UINT64_C(0x0000000000006235), UINT64_C(0x1f43074e78b5c739), UINT64_C(0x1f42fc4f8cb90706),
        UINT64_C(0x1f42f58ec8b7a702), UINT64_C(0x1f42fa8f48b88715)
    },
    {   UINT64_C(0x0000000000008935), UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c),
        UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c)
    },
    {   UINT64_C(0x0000000000006236), UINT64_C(0x1f42fd8e88b82742), UINT64_C(0x1f42f68fb8b4c70e),
        UINT64_C(0x1f430d0e64b4e731), UINT64_C(0x1f430b4e54af8736)
    },
    {   UINT64_C(0x0000000000008936), UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c),
        UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008937), UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c),
        UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c)
    },
    {   UINT64_C(0x0000000000006238), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f78f58b626fb),
        UINT64_C(0x1f42fa8fe0b3470d), UINT64_C(0x1f42fd8f74b5c6ff)
    },
    {   UINT64_C(0x0000000000008938), UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c),
        UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c)
    },
    {   UINT64_C(0x0000000000006239), UINT64_C(0x1f42f68edcb3e717), UINT64_C(0x1f42f98eecacc6eb),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f78f78b34714)
    },
    {   UINT64_C(0x0000000000008939), UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c),
        UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c)
    },
    {   UINT64_C(0x000000000000623a), UINT64_C(0x1f42f3ce5cb7473e), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8ef8adc705)
    },
    {   UINT64_C(0x000000000000893a), UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c),
        UINT64_C(0x1562ee0f6894068c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000623b), UINT64_C(0x1f42fa8f74b4c716), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f78f64afc6ff), UINT64_C(0x1f42f98f68ae0702)
    },
    {   UINT64_C(0x000000000000588e), UINT64_C(0x1f43038ecca006f7), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f7500cb526ee), UINT64_C(0x1f42fc8f60b2c738)
    },
    {   UINT64_C(0x000000000000623c), UINT64_C(0x1f42f88fc4b1a706), UINT64_C(0x1f42f78ed8b7a730),
        UINT64_C(0x1f42ff8f94b2c706), UINT64_C(0x1f43048e88b46742)
    },
    {   UINT64_C(0x000000000000588f), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd8e7cae273a),
        UINT64_C(0x1f42fc8f60b2c738), UINT64_C(0x1f42f70e64b0e73d)
    },
    {   UINT64_C(0x000000000000623d), UINT64_C(0x1f43098e78b6e744), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f68eccb36706), UINT64_C(0x1f42f68ee4b7270c)
    },
    {   UINT64_C(0x0000000000005890), UINT64_C(0x1f43014e8cb28715), UINT64_C(0x1f42f20eb4a7e718),
        UINT64_C(0x1f43080ef09f4723), UINT64_C(0x1f43064ed4a5670f)
    },
    {   UINT64_C(0x000000000000623e), UINT64_C(0x1f42f98ef8b82719), UINT64_C(0x1f4303ce88b36735),
        UINT64_C(0x1f42f68f2cb6470e), UINT64_C(0x1f430eced4afa71d)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000623f), UINT64_C(0x1f42fb8ea4b3a70a), UINT64_C(0x1f43080e64b4872f),
        UINT64_C(0x1f42f88fc4b06712), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005892), UINT64_C(0x1f42f88eb8a9873e), UINT64_C(0x1f42fb8e50ab273c),
        UINT64_C(0x1f43070f5cabe735), UINT64_C(0x1f43068e88b10727)
    },
    {   UINT64_C(0x0000000000018a40), UINT64_C(0x1cf2fc1084ab65aa), UINT64_C(0x1cf2fbd084ab65aa),
        UINT64_C(0x1cf2fbceecab660f), UINT64_C(0x1cf2fbceecab660f)
    },
    {   UINT64_C(0x0000000000018a41), UINT64_C(0x1cf2f30eecafc60f), UINT64_C(0x1cf2fbd084ab65aa),
        UINT64_C(0x1cf2fbceecab660f), UINT64_C(0x1cf2fbceecab660f)
    },
    {   UINT64_C(0x0000000000018a42), UINT64_C(0x0ffafccd3077067e), UINT64_C(0x0ffafccd3077067e),
        UINT64_C(0x1cf2ffcd30a9467e), UINT64_C(0x1cf3000d30a9667e)
    },
    {   UINT64_C(0x0000000000018a43), UINT64_C(0x1cf2fbd084ab65a9), UINT64_C(0x1cf2fbd084ab65a9),
        UINT64_C(0x1cf2fbd084ab65a9), UINT64_C(0x1cf2fbd084ab65a9)
    },
    {   UINT64_C(0x0000000000018a44), UINT64_C(0x2c22fbd084e825a9), UINT64_C(0x1cf2fbd084aba5a9),
        UINT64_C(0x0ffafccd3077067e), UINT64_C(0x0ffafccd3077067e)
    },
    {   UINT64_C(0x0000000000008942), UINT64_C(0x1622eb53cc98653c), UINT64_C(0x0000000000000000),
        UINT64_C(0x16233d4ae46f4776), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000018a46), UINT64_C(0x1cf2fa9084ac05aa), UINT64_C(0x1cf2fbd084ab65a9),
        UINT64_C(0x1cf2fbd084ab65a9), UINT64_C(0x1cf2fbd084ab65a9)
    },
    {   UINT64_C(0x0000000000018a47), UINT64_C(0x1cf2fbd084ab65a9), UINT64_C(0x1cf2fbd084ab65a9),
        UINT64_C(0x1cf2fbd084ab65a9), UINT64_C(0x1cf2fbd084ab65aa)
    },
    {   UINT64_C(0x0000000000018a48), UINT64_C(0x1cf2fbd084ab65aa), UINT64_C(0x1cf2fbcd30ab667e),
        UINT64_C(0x1cf2fbcd30aba67c), UINT64_C(0x1cf2fbcd30ab667e)
    },
    {   UINT64_C(0x0000000000018a49), UINT64_C(0x1cf2fbcd30ab667e), UINT64_C(0x1cf2fbcd30ab667e),
        UINT64_C(0x1cf2fbcd30ab667e), UINT64_C(0x1cf2fbcd30aba67e)
    },
    {   UINT64_C(0x0000000000006245), UINT64_C(0x1f42fd8f44b1e6ee), UINT64_C(0x1f42f4ce8cb74716),
        UINT64_C(0x1f42fc4e80b886fd), UINT64_C(0x1f42f98ee0b506f3)
    },
    {   UINT64_C(0x0000000000008945), UINT64_C(0x16233d53cc988776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000018a4c), UINT64_C(0x1cf2fbcd38aba67e), UINT64_C(0x1cf2fb8d30ab467e),
        UINT64_C(0x1cf2fbcd30ab667e), UINT64_C(0x1cf2fbd084ab65a9)
    },
    {   UINT64_C(0x0000000000018a4d), UINT64_C(0x1cf3114fa0a2261a), UINT64_C(0x1cf3114fa0a2261a),
        UINT64_C(0x188303cd148fa5d5), UINT64_C(0x18830fcd1495a5d5)
    },
    {   UINT64_C(0x0000000000018a4e), UINT64_C(0x0ffaff8d3c726679), UINT64_C(0x0ffb060d3c75a679),
        UINT64_C(0x1cf2ff50d8aac58f), UINT64_C(0x1cf2fd10d8a9a58f)
    },
    {   UINT64_C(0x0000000000008947), UINT64_C(0x16233d4ae4986776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000018a50), UINT64_C(0x1cf3050dd0a6c6fc), UINT64_C(0x1cf3050dd0a6c6fc),
        UINT64_C(0x1cf2fbce30ab663e), UINT64_C(0x1cf2fbce30ab663e)
    },
    {   UINT64_C(0x0000000000018a51), UINT64_C(0x1cf2fbce30ab663e), UINT64_C(0x1cf2fbce8cab65a9),
        UINT64_C(0x1cf2fbce8cab65a9), UINT64_C(0x1cf2fbd084ab65a9)
    },
    {   UINT64_C(0x0000000000018a52), UINT64_C(0x1cf2f79084ad85a9), UINT64_C(0x0ffafd0d3876e67e),
        UINT64_C(0x1cf2f790acad859f), UINT64_C(0x1cf2f790acad859f)
    },
    {   UINT64_C(0x0000000000008949), UINT64_C(0x1622eb4ae46f4776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000018a54), UINT64_C(0x1cf2f790acad8506), UINT64_C(0x0ffaff4d3062867e),
        UINT64_C(0x1cf2fbd088ab65a8), UINT64_C(0x1cf2fbd088ab65a8)
    },
    {   UINT64_C(0x0000000000018a55), UINT64_C(0x0ffafd0d3076e67e), UINT64_C(0x0ffafd0d3076e67e),
        UINT64_C(0x1cf2fbd088ab65a8), UINT64_C(0x1cf2fbd088ab65a8)
    },
    {   UINT64_C(0x0000000000018a56), UINT64_C(0x0ffafd0d3076e67e), UINT64_C(0x0ffafd0d3076e67e),
        UINT64_C(0x1cf2fbd088ab65a8), UINT64_C(0x1cf2fbd088ab65a8)
    },
    {   UINT64_C(0x000000000000894b), UINT64_C(0x1622eb4ae498653c), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000018a58), UINT64_C(0x0ffafccd3076c67e), UINT64_C(0x0ffafccd3076c67e),
        UINT64_C(0x1cf2fbcf1cab6603), UINT64_C(0x156afc4d308d267e)
    },
    {   UINT64_C(0x0000000000018a59), UINT64_C(0x1cf2fbcf1cab6603), UINT64_C(0x156afc4d308d267e),
        UINT64_C(0x1cf2fbd180ab6603), UINT64_C(0x1cf2fbcf1cab656a)
    },
    {   UINT64_C(0x0000000000018a5a), UINT64_C(0x1cf2fbd180ab6603), UINT64_C(0x1cf2fbcf1cab656a),
        UINT64_C(0x1cf2fbd180ab6603), UINT64_C(0x1cf2fbcf1cab656a)
    },
    {   UINT64_C(0x000000000000894d), UINT64_C(0x1622eb53cc986776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000018a5c), UINT64_C(0x1cf2fbd180ab656a), UINT64_C(0x1cf2fbd084ab661d),
        UINT64_C(0x1cf2fbd084ab65e4), UINT64_C(0x1cf2fbcf98ab65a9)
    },
    {   UINT64_C(0x0000000000018a5d), UINT64_C(0x1cf2fbcf98ab65a9), UINT64_C(0x1cf2fbcd6cab65a9),
        UINT64_C(0x156afe0b348c2647), UINT64_C(0x1cf2f94f38ab65fc)
    },
    {   UINT64_C(0x0000000000018a5e), UINT64_C(0x156afe0b388c2648), UINT64_C(0x156afe0b888c265b),
        UINT64_C(0x1cf2f94f38ab65fc), UINT64_C(0x156afdcb888c065b)
    },
    {   UINT64_C(0x000000000000894f), UINT64_C(0x1622eb4ae4986776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006250), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f98fa4b1a6d7),
        UINT64_C(0x1f42f88efcb6e707), UINT64_C(0x1f42ffce34b2a730)
    },
    {   UINT64_C(0x0000000000018a61), UINT64_C(0x12a30bcc4c7b86b7), UINT64_C(0x0e7aff8c4c6fa6b7),
        UINT64_C(0x0e7aff8c4c6fa6b7), UINT64_C(0x0ffb0acc486c66b7)
    },
    {   UINT64_C(0x0000000000006251), UINT64_C(0x1f43034e68afe738), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f58ea8b1c710), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000018a63), UINT64_C(0x0eaaf38c4c61a6b7), UINT64_C(0x0eab1d0c4c7666b7),
        UINT64_C(0x0eaaf38c4c61a6b7), UINT64_C(0x0eab1d0c4c7666b7)
    },
    {   UINT64_C(0x0000000000006252), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f98e98b086ee),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f78eecb726ee)
    },
    {   UINT64_C(0x0000000000018a65), UINT64_C(0x156b058d648fe671), UINT64_C(0x156b038d648ee671),
        UINT64_C(0x156af88d64896671), UINT64_C(0x0f431d0c4c78c6b7)
    },
    {   UINT64_C(0x0000000000018a66), UINT64_C(0x0f42f38c4c6406b7), UINT64_C(0x069afa8d3452a67d),
        UINT64_C(0x0ffb1a4d3068467e), UINT64_C(0x156af88e8091460b)
    },
    {   UINT64_C(0x0000000000018a67), UINT64_C(0x156afa8fa08dc630), UINT64_C(0x156afa8fa08dc630),
        UINT64_C(0x156af0cfa092e60b), UINT64_C(0x156af40fa08ee574)
    },
    {   UINT64_C(0x0000000000018a68), UINT64_C(0x156afc4f6c9045ed), UINT64_C(0x156b014fd08a6649),
        UINT64_C(0x156af88fa091460b), UINT64_C(0x156af88fa091460b)
    },
    {   UINT64_C(0x0000000000018a69), UINT64_C(0x156af3cc808ee60b), UINT64_C(0x156af88c8091460b),
        UINT64_C(0x1c22f80fa0aa060b), UINT64_C(0x1c22f80fa0aa060b)
    },
    {   UINT64_C(0x0000000000018a6a), UINT64_C(0x156af54e808fa626), UINT64_C(0x156af70e80908626),
        UINT64_C(0x156af54e908fa62a), UINT64_C(0x156af70e9090862a)
    },
    {   UINT64_C(0x00000000000058a8), UINT64_C(0x1f42ff0f88b0c718), UINT64_C(0x1f42f94f38b6c711),
        UINT64_C(0x1f42f80f24b7a6f5), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000018a6c), UINT64_C(0x17d2fa8e6497862f), UINT64_C(0x17d2fa8e649786b5),
        UINT64_C(0x17d2fa8e6497871b), UINT64_C(0x17d2fa8e64978728)
    },
    {   UINT64_C(0x0000000000008956), UINT64_C(0x16233d5258988776), UINT64_C(0x16232653cc988776),
        UINT64_C(0x1623265258986776), UINT64_C(0x1622eb52586f4776)
    },
    {   UINT64_C(0x0000000000018a6e), UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x1a52fa8dc4a18657),
        UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x1a52fa8dc4a18657)
    },
    {   UINT64_C(0x0000000000008957), UINT64_C(0x1622eb53cc7ae776), UINT64_C(0x1622eb52587ae776),
        UINT64_C(0x16233d4ae4988776), UINT64_C(0x1623264ae4988776)
    },
    {   UINT64_C(0x0000000000018a70), UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x1a52fa8dc4a18657),
        UINT64_C(0x221afa8dc4c28657), UINT64_C(0x221afa8dc4c28657)
    },
    {   UINT64_C(0x0000000000018a71), UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x1c72f94d28aaa67e),
        UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x1c72f94d28aaa67e)
    },
    {   UINT64_C(0x0000000000018a72), UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x20b2fe0c64b946b0),
        UINT64_C(0x23caf6cda4c947d3), UINT64_C(0x23caf6cb94c94713)
    },
    {   UINT64_C(0x0000000000018a73), UINT64_C(0x23caf6cda4c94713), UINT64_C(0x246af1cda4ce4713),
        UINT64_C(0x1862ff8c9c9746a2), UINT64_C(0x1acafa0f3c9fa5fb)
    },
    {   UINT64_C(0x0000000000018a74), UINT64_C(0x1acb020f3ca3a5fb), UINT64_C(0x1953054e6098062e),
        UINT64_C(0x1953054e6098062e), UINT64_C(0x1953054e6098062e)
    },
    {   UINT64_C(0x0000000000018a75), UINT64_C(0x1953058e6098262e), UINT64_C(0x1953054e6098062e),
        UINT64_C(0x1953008e109a8642), UINT64_C(0x1953008e109a8642)
    },
    {   UINT64_C(0x0000000000018a76), UINT64_C(0x0ffb1a4dd0684654), UINT64_C(0x0ffb1a0dd0682654),
        UINT64_C(0x15831a4dd07e6654), UINT64_C(0x15831a4dd07e6654)
    },
    {   UINT64_C(0x0000000000018a77), UINT64_C(0x1cf2ff8fa0a94596), UINT64_C(0x1cf2ff8fa0a94675),
        UINT64_C(0x1cf2ff8caca9469f), UINT64_C(0x23cafa913cc7657b)
    },
    {   UINT64_C(0x0000000000018a78), UINT64_C(0x1c72f94d2caaa67e), UINT64_C(0x14daf40f808b25e8),
        UINT64_C(0x18b2fe0fa0994586), UINT64_C(0x156af9cd308e267e)
    },
    {   UINT64_C(0x0000000000018a79), UINT64_C(0x156af9cd308e2732), UINT64_C(0x156afa0d308e267e),
        UINT64_C(0x18f2fd0e689ac630), UINT64_C(0x13a2fa0cac87069f)
    },
    {   UINT64_C(0x0000000000018a7a), UINT64_C(0x23caf6cda4c94713), UINT64_C(0x23caf6cda4c94713),
        UINT64_C(0x17d2f60bdc99c6d0), UINT64_C(0x18b2f94b1c9ba703)
    },
    {   UINT64_C(0x0000000000018a7b), UINT64_C(0x17d2fa8bdc9786cf), UINT64_C(0x17d2fa8bdc9786cf),
        UINT64_C(0x17d3064bd491a6d3), UINT64_C(0x17d3064bd491a6d3)
    },
    {   UINT64_C(0x0000000000018a7c), UINT64_C(0x17d2f60bd499c6d3), UINT64_C(0x17d2f60bd499c6d3),
        UINT64_C(0x17d2fe4bd495a6d3), UINT64_C(0x17d2fe4bd495a6d3)
    },
    {   UINT64_C(0x0000000000018a7d), UINT64_C(0x1cf2fbcf6cab65f1), UINT64_C(0x105af98c287a46ae),
        UINT64_C(0x1043058e6073c6e5), UINT64_C(0x1043058e6073c67e)
    },
    {   UINT64_C(0x0000000000018a7e), UINT64_C(0x12d3034a8c7f269f), UINT64_C(0x12d3034a8c7f269f),
        UINT64_C(0x156afe0f3c8c25fc), UINT64_C(0x156afe0f3c8c25fc)
    },
    {   UINT64_C(0x0000000000018a7f), UINT64_C(0x0e5b014c4c6fc6b1), UINT64_C(0x0e5afe4c4c6e46b1),
        UINT64_C(0x17d3054f10922604), UINT64_C(0x17d3055298922524)
    },
    {   UINT64_C(0x0000000000018a80), UINT64_C(0x2332fb4b94c4a6e3), UINT64_C(0x2332fb4b94c4a6e3),
        UINT64_C(0x2332fb4b94c4a6e3), UINT64_C(0x1ce3058b80a646e8)
    },
    {   UINT64_C(0x0000000000018a81), UINT64_C(0x1ce3058b80a646e8), UINT64_C(0x1ce3058b94a646e3),
        UINT64_C(0x1ce3058b94a646e3), UINT64_C(0x24e302cb94c7a6e3)
    },
    {   UINT64_C(0x0000000000018a82), UINT64_C(0x24e302cb94c7a6e3), UINT64_C(0x1feafa8b94b7e6e3),
        UINT64_C(0x1c92fc8b94a986e3), UINT64_C(0x1592f64aa090e720)
    },
    {   UINT64_C(0x0000000000018a83), UINT64_C(0x2502f60aa0e90720), UINT64_C(0x0f9af60aa08e6720),
        UINT64_C(0x0f9af60aa08e6720), UINT64_C(0x0f9af60aa08e6720)
    },
    {   UINT64_C(0x0000000000018a84), UINT64_C(0x0f9af60aa08e6720), UINT64_C(0x0f9af60aa08e6720),
        UINT64_C(0x103af60aa08e6720), UINT64_C(0x0f9af60aa08e6720)
    },
    {   UINT64_C(0x0000000000008962), UINT64_C(0x25eaee0ae4d62776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000018a86), UINT64_C(0x10daf60aa08e6720), UINT64_C(0x117af60aa08e6720),
        UINT64_C(0x117af60aa08e6720), UINT64_C(0x0e5af60aa08e679b)
    },
    {   UINT64_C(0x0000000000018a87), UINT64_C(0x0e5af608b48e6720), UINT64_C(0x27b3054bb0d1a6ea),
        UINT64_C(0x1fd2f94b98b206e4), UINT64_C(0x0fbb098b1471c61e)
    },
    {   UINT64_C(0x0000000000018a88), UINT64_C(0x24cb068da4c56661), UINT64_C(0x111b23caf079870d),
        UINT64_C(0x156afa0efc8e071b), UINT64_C(0x156afa0efc8e06ab)
    },
    {   UINT64_C(0x0000000000008964), UINT64_C(0x25e3858ae4d60776), UINT64_C(0x2582ee0b98d48744),
        UINT64_C(0x2582ee0b5cd48752), UINT64_C(0x2582ee0b5cd48752)
    },
    {   UINT64_C(0x0000000000018a8a), UINT64_C(0x156afa0efc8e060b), UINT64_C(0x156afa13108e2614),
        UINT64_C(0x156afa0f8c8e2506), UINT64_C(0x156afa0f8c8e25e7)
    },
    {   UINT64_C(0x0000000000018a8b), UINT64_C(0x156afa0f8c8e25e7), UINT64_C(0x16a2fa8dc492c657),
        UINT64_C(0x16a2fa8dc492c657), UINT64_C(0x0f52fa908c7565a7)
    },
    {   UINT64_C(0x0000000000018a8c), UINT64_C(0x1402f8cf3c892696), UINT64_C(0x1402f8cd988925f9),
        UINT64_C(0x1402f8ceec8925f9), UINT64_C(0x156afc4f208ce602)
    },
    {   UINT64_C(0x0000000000018a8d), UINT64_C(0x1512fa8dc48c8657), UINT64_C(0x1512fa8dc48c8657),
        UINT64_C(0x1a52fa8dc4a18712), UINT64_C(0x2262fa8bc0c1c6d8)
    },
    {   UINT64_C(0x0000000000018a8e), UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x23caf6cda4c94713),
        UINT64_C(0x23caf6cda4c94713), UINT64_C(0x23caf6cda4c94713)
    },
    {   UINT64_C(0x0000000000018a8f), UINT64_C(0x12c2fa116c838571), UINT64_C(0x12c2fa116c838571),
        UINT64_C(0x0962fd0cf85b45d0), UINT64_C(0x15b2f58fa091867e)
    },
    {   UINT64_C(0x0000000000018a90), UINT64_C(0x1362fa0f24860600), UINT64_C(0x1362fa0f24860600),
        UINT64_C(0x1362fa0f24860684), UINT64_C(0x1362fa0f24860684)
    },
    {   UINT64_C(0x0000000000008968), UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x1c72f94d28aaa67e),
        UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x1c72f94d28aaa67e)
    },
    {   UINT64_C(0x0000000000018a92), UINT64_C(0x1362fa094886077a), UINT64_C(0x1362fa094886077a),
        UINT64_C(0x21b2fa0f04bf45f8), UINT64_C(0x21b2fa0f00bf45f7)
    },
    {   UINT64_C(0x0000000000008969), UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x1c72f94d28aaa67e),
        UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x1c72f94d28aaa67e)
    },
    {   UINT64_C(0x0000000000018a94), UINT64_C(0x1362f08f248ac642), UINT64_C(0x1362f5cf2c8826ae),
        UINT64_C(0x1362f5cf2c8826ae), UINT64_C(0x1362f5cf2c882600)
    },
    {   UINT64_C(0x0000000000018a95), UINT64_C(0x1362f5cf2c882600), UINT64_C(0x1862f60f2c9c0600),
        UINT64_C(0x1862f60f2c9c0600), UINT64_C(0x1613088f2c93e600)
    },
    {   UINT64_C(0x0000000000018a96), UINT64_C(0x1612f3cf2c898600), UINT64_C(0x1362f5ce6c882631),
        UINT64_C(0x1362f5cf2c882600), UINT64_C(0x1362f5cf2c882600)
    },
    {   UINT64_C(0x0000000000018a97), UINT64_C(0x1362f5cf2c882600), UINT64_C(0x1362f5cf2c882600),
        UINT64_C(0x1362f5cf2c882704), UINT64_C(0x1362f58d74884600)
    },
    {   UINT64_C(0x0000000000018a98), UINT64_C(0x1362f58b1c884600), UINT64_C(0x1362f94fa08665c7),
        UINT64_C(0x1362f58f2c88470e), UINT64_C(0x1362f58b1c884600)
    },
    {   UINT64_C(0x000000000000896c), UINT64_C(0x23a2f50f74c985ea), UINT64_C(0x23a2f54f74c965ea),
        UINT64_C(0x23caf6cda4c94713), UINT64_C(0x23caf6cda4c94713)
    },
    {   UINT64_C(0x0000000000018a9a), UINT64_C(0x156afa0cac8e269f), UINT64_C(0x156afa0d308e267e),
        UINT64_C(0x156afa11f08e25f1), UINT64_C(0x156afa0f6c8e25f1)
    },
    {   UINT64_C(0x0000000000018a9b), UINT64_C(0x156afa0f088e2607), UINT64_C(0x156afa0f348e26a7),
        UINT64_C(0x156afa11808e2737), UINT64_C(0x156afa10048e26ab)
    },
    {   UINT64_C(0x0000000000018a9c), UINT64_C(0x156afa0d588e2672), UINT64_C(0x156afa0d6c8e2670),
        UINT64_C(0x156afa0d6c8e2670), UINT64_C(0x156afa0f348e25fc)
    },
    {   UINT64_C(0x0000000000018a9d), UINT64_C(0x1fbafa1104b76589), UINT64_C(0x1f2afa1180b5256a),
        UINT64_C(0x2ce2fa1180ec056a), UINT64_C(0x156afa0df88e264b)
    },
    {   UINT64_C(0x0000000000018a9e), UINT64_C(0x156af790108f66a7), UINT64_C(0x156af90f388aa5fc),
        UINT64_C(0x156b010f388ea5fc), UINT64_C(0x156af90f388aa70e)
    },
    {   UINT64_C(0x000000000000896f), UINT64_C(0x23caf6cda4c94713), UINT64_C(0x23caf6cda4c94713),
        UINT64_C(0x14a2f4cee08d85c5), UINT64_C(0x14a2f4cee08d85c5)
    },
    {   UINT64_C(0x0000000000018aa0), UINT64_C(0x156afd0d7c8ca659), UINT64_C(0x156afd0d7c8ca659),
        UINT64_C(0x156afd0d7c8ca659), UINT64_C(0x156afd0d7c8ca6f1)
    },
    {   UINT64_C(0x0000000000008970), UINT64_C(0x209af6cb2cb826fe), UINT64_C(0x209aff8b30bc86ff),
        UINT64_C(0x14a2fbced8870613), UINT64_C(0x14a2fbced4870612)
    },
    {   UINT64_C(0x0000000000018aa2), UINT64_C(0x157afc0c408c265c), UINT64_C(0x156afa0acc8e26d2),
        UINT64_C(0x156afa0acc8e26d2), UINT64_C(0x156afc09008c278a)
    },
    {   UINT64_C(0x0000000000018aa3), UINT64_C(0x156afc09008c278a), UINT64_C(0x156afa0ce08e26d2),
        UINT64_C(0x156afa0ce08e26d2), UINT64_C(0x156afd09fc8fa74b)
    },
    {   UINT64_C(0x0000000000018aa4), UINT64_C(0x156afd09fc8fa74b), UINT64_C(0x156afbca588d4734),
        UINT64_C(0x156afbca588d4734), UINT64_C(0x156afd09fc8ca74a)
    },
    {   UINT64_C(0x0000000000008972), UINT64_C(0x2142f7cbd8bea6d0), UINT64_C(0x1a52fa8dc4a18657),
        UINT64_C(0x18b2f94b1c9ba703), UINT64_C(0x1a52fa8dc4a18657)
    },
    {   UINT64_C(0x0000000000018aa6), UINT64_C(0x156afc0db88c2668), UINT64_C(0x156afd0c548ca6b6),
        UINT64_C(0x156afd0c548ca6b6), UINT64_C(0x156afd0c308ca6be)
    },
    {   UINT64_C(0x0000000000008973), UINT64_C(0x1c72f54ce0aca690), UINT64_C(0x1c72f4cce0ad0690),
        UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x1a52fa8dc4a18657)
    },
    {   UINT64_C(0x0000000000018aa8), UINT64_C(0x156afa0b748e26ee), UINT64_C(0x156af90f388aa5fc),
        UINT64_C(0x156b010f388ea5fc), UINT64_C(0x1d2af44e04b00649)
    },
    {   UINT64_C(0x0000000000008974), UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x1a52fa8dc4a18657),
        UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x1a52fa8dc4a18657)
    },
    {   UINT64_C(0x0000000000006275), UINT64_C(0x1f43004fd8ad8713), UINT64_C(0x1f42fc8eb4a88723),
        UINT64_C(0x1f43004f24b4c704), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000018aab), UINT64_C(0x156afd0e048ca64d), UINT64_C(0x156afd0e048ca64d),
        UINT64_C(0x156afa10108e261b), UINT64_C(0x156afe0e048c2649)
    },
    {   UINT64_C(0x0000000000006276), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f68f2cb8271a),
        UINT64_C(0x1f42f68f54b7a708), UINT64_C(0x1f42ff4f3cb6a70f)
    },
    {   UINT64_C(0x0000000000018aad), UINT64_C(0x156afd0c548ca6b5), UINT64_C(0x156afe4b908c46d3),
        UINT64_C(0x156afe4b908c46d3), UINT64_C(0x156afa0b548e26d3)
    },
    {   UINT64_C(0x0000000000018aae), UINT64_C(0x156afa0b548e26d3), UINT64_C(0x156afa0acc8e26d3),
        UINT64_C(0x156afa0acc8e26d3), UINT64_C(0x1d2af44f38b005fc)
    },
    {   UINT64_C(0x0000000000018aaf), UINT64_C(0x1d2af44f38b005fc), UINT64_C(0x156afd0f388ca5fc),
        UINT64_C(0x156afd0f388ca5fc), UINT64_C(0x156afd0e048ca647)
    },
    {   UINT64_C(0x0000000000018ab0), UINT64_C(0x156afd0e048ca647), UINT64_C(0x156afd0e048ca647),
        UINT64_C(0x156afd0e048ca647), UINT64_C(0x156afd0e048ca6ad)
    },
    {   UINT64_C(0x0000000000008978), UINT64_C(0x1c72f4d38cad0690), UINT64_C(0x1c72f4cce0ad04e4),
        UINT64_C(0x1c7af94d28aaa67e), UINT64_C(0x1c7af94d28aaa67e)
    },
    {   UINT64_C(0x0000000000018ab2), UINT64_C(0x156afd0d108ca681), UINT64_C(0x156afd0b588ca6d2),
        UINT64_C(0x156afd0b588ca6d2), UINT64_C(0x156afd4aa48be6b5)
    },
    {   UINT64_C(0x00000000000058cc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43150e70aae702), UINT64_C(0x1f42f7cf40b0e703)
    },
    {   UINT64_C(0x0000000000018ab4), UINT64_C(0x156aff8f388de5fc), UINT64_C(0x156afd0e048cc649),
        UINT64_C(0x156afd0e048ca649), UINT64_C(0x156afd0c5c8ca6b3)
    },
    {   UINT64_C(0x0000000000018ab5), UINT64_C(0x156afd0c5c8ca6b3), UINT64_C(0x156afd0c5c8ca6b3),
        UINT64_C(0x156afd0c5c8ca6b3), UINT64_C(0x2712fd0f38d345fc)
    },
    {   UINT64_C(0x0000000000018ab6), UINT64_C(0x2712fd0f38d345fc), UINT64_C(0x1362fa0f24860600),
        UINT64_C(0x1362fa0da08606a1), UINT64_C(0x1362fa0e1c86069f)
    },
    {   UINT64_C(0x0000000000018ab7), UINT64_C(0x1362f0cf78860615), UINT64_C(0x1362fa0f78860615),
        UINT64_C(0x0f8afe0fa074a67e), UINT64_C(0x156afa0fa08e255b)
    },
    {   UINT64_C(0x0000000000018ab8), UINT64_C(0x156afa0fa08e255b), UINT64_C(0x156afa0fa08e267e),
        UINT64_C(0x156afd0fa08ca67e), UINT64_C(0x1ae2f98fa0a2e67e)
    },
    {   UINT64_C(0x0000000000018ab9), UINT64_C(0x156afd0fa08ca67e), UINT64_C(0x1ae2f98fa0a2e67e),
        UINT64_C(0x156afc4fa08cc67e), UINT64_C(0x156afa0fa08e2623)
    },
    {   UINT64_C(0x000000000000627d), UINT64_C(0x1f42fb4e50b46742), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd4eecb4e71a), UINT64_C(0x1f430a4eacaf871c)
    },
    {   UINT64_C(0x0000000000018abb), UINT64_C(0x12c2fa0fe88385d1), UINT64_C(0x12c2fa0fe88385d1),
        UINT64_C(0x0ca2f3ccac6e269a), UINT64_C(0x0fb3074d3870a67c)
    },
    {   UINT64_C(0x0000000000018abc), UINT64_C(0x0fb3074d3870a67c), UINT64_C(0x0fb3074cb470a69d),
        UINT64_C(0x105af08cac7ea69f), UINT64_C(0x156afa0cac8e269f)
    },
    {   UINT64_C(0x0000000000018abd), UINT64_C(0x156b0eccac83e69f), UINT64_C(0x156af10cac92c69f),
        UINT64_C(0x156b33ce08714648), UINT64_C(0x2492fc8d34c5867d)
    },
    {   UINT64_C(0x000000000000627f), UINT64_C(0x1f42fa4e70b4473a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f74f90b5c70a), UINT64_C(0x1f42fb0eccb1272b)
    },
    {   UINT64_C(0x0000000000018abf), UINT64_C(0x1473058b948486e3), UINT64_C(0x162af98c289166ae),
        UINT64_C(0x0cd3070cac65469a), UINT64_C(0x0ef3058b946e86e3)
    },
    {   UINT64_C(0x0000000000006280), UINT64_C(0x1f43068f4cae8720), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43014f9cb6471e), UINT64_C(0x1f42fe0eecb1271f)
    },
    {   UINT64_C(0x00000000000058d3), UINT64_C(0x1f42f64f14ad4727), UINT64_C(0x1f42f20e5cb54728),
        UINT64_C(0x1f42f94ef0abc70d), UINT64_C(0x1f42f74f64af6714)
    },
    {   UINT64_C(0x0000000000006281), UINT64_C(0x1f42fc8efcb426f6), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43138e6ca7471e)
    },
    {   UINT64_C(0x00000000000058d4), UINT64_C(0x1f42fecf2ca86727), UINT64_C(0x1f42f88f50b3c6f6),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000018ac4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1c72f94d2caaa67e), UINT64_C(0x1c72f94d2caaa67e)
    },
    {   UINT64_C(0x0000000000018ac5), UINT64_C(0x1c72f94d2caaa67e), UINT64_C(0x1c72f94d2caaa67e),
        UINT64_C(0x2142f7cbd8bea6d0), UINT64_C(0x2142f7cbd8bea6d0)
    },
    {   UINT64_C(0x0000000000018ac6), UINT64_C(0x2142f7cbd8bea6d0), UINT64_C(0x2142f7cbd8bea6d0),
        UINT64_C(0x1c72f94d2caaa67e), UINT64_C(0x2082f80cd0bb86f4)
    },
    {   UINT64_C(0x0000000000018ac7), UINT64_C(0x2082f80cd0bb86f4), UINT64_C(0x0782fa9250564534),
        UINT64_C(0x0782fa9250564534), UINT64_C(0x1c72f70dfcabc69a)
    },
    {   UINT64_C(0x0000000000018ac8), UINT64_C(0x1c72f70dfcabc69a), UINT64_C(0x1c73028cd8a60690),
        UINT64_C(0x1c73028cd8a60690), UINT64_C(0x1cf2f40da4af4661)
    },
    {   UINT64_C(0x0000000000018ac9), UINT64_C(0x25baff8b38cca6f9), UINT64_C(0x185af94e209a462d),
        UINT64_C(0x185af94e209a462d), UINT64_C(0x1102f80dfc7d8649)
    },
    {   UINT64_C(0x0000000000018aca), UINT64_C(0x1102f80dfc7d8649), UINT64_C(0x105af48fe07ca5d0),
        UINT64_C(0x0b2af48fe067e5d0), UINT64_C(0x0b2af48fe067e5d0)
    },
    {   UINT64_C(0x0000000000018acb), UINT64_C(0x1a52fa8fb0a185dc), UINT64_C(0x1a52fa8fb0a185dc),
        UINT64_C(0x12a2fa8dc482c657), UINT64_C(0x12a2fa8dc482c657)
    },
    {   UINT64_C(0x0000000000018acc), UINT64_C(0x1cf2ff9084a985a8), UINT64_C(0x1cf2fd0c00aac6cb),
        UINT64_C(0x2582fb0eaccde621), UINT64_C(0x3132fbd088fc65a9)
    },
    {   UINT64_C(0x0000000000018acd), UINT64_C(0x1cf2fc1084ab65aa), UINT64_C(0x1cf2fbd084ab65aa),
        UINT64_C(0x1cf2fbd084ab65aa), UINT64_C(0x2c22fbd084e825a9)
    },
    {   UINT64_C(0x0000000000018ace), UINT64_C(0x1cf2fbd084aba5a9), UINT64_C(0x1cf2fbd084ab65aa),
        UINT64_C(0x1cf2fbd084ab65aa), UINT64_C(0x1cf2fbd084ab65a9)
    },
    {   UINT64_C(0x0000000000018acf), UINT64_C(0x1cf2fbd084ab65aa), UINT64_C(0x1cf2fa9084ac05aa),
        UINT64_C(0x1cf2fbd084ab65a9), UINT64_C(0x1cf2fbd084ab65a9)
    },
    {   UINT64_C(0x0000000000018ad0), UINT64_C(0x1cf2fbd084ab661d), UINT64_C(0x1cf2fbd084ab65e4),
        UINT64_C(0x1cf2fbcd6cab65a9), UINT64_C(0x1cf2f94f38ab65fc)
    },
    {   UINT64_C(0x0000000000018ad1), UINT64_C(0x1cf2f94f38ab65fc), UINT64_C(0x1d02fbcc94aba6a5),
        UINT64_C(0x1d02fbcc94aba6a5), UINT64_C(0x1cf2fbd084ab65e4)
    },
    {   UINT64_C(0x0000000000018ad2), UINT64_C(0x1cf2fbcd6cab65a9), UINT64_C(0x1cf2fbd084ab65e4),
        UINT64_C(0x1cf2fbcd6cab65a9), UINT64_C(0x1cf2fbcf98ab65a9)
    },
    {   UINT64_C(0x0000000000018ad3), UINT64_C(0x1cf2fbcf98ab65a9), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000018ad4), UINT64_C(0x18d2fd0f289a4653), UINT64_C(0x18d2fd0f289a4653),
        UINT64_C(0x15e2f6cf6c91a63d), UINT64_C(0x1b0af94da8a786b0)
    },
    {   UINT64_C(0x0000000000018ad5), UINT64_C(0x1b0af94da4a786b0), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000628b), UINT64_C(0x1f42ffcf04b2a6ec), UINT64_C(0x1f42fa0fd4ba2707),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000058de), UINT64_C(0x1f42fe0ee0b346f9), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f54eb8b7a71d), UINT64_C(0x1f42f80f40b8a721)
    },
    {   UINT64_C(0x000000000000628c), UINT64_C(0x1f42facf90b146fa), UINT64_C(0x1f43024eacb7473c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f71048b6e72e)
    },
    {   UINT64_C(0x00000000000058df), UINT64_C(0x1f42fe4f1caee6ef), UINT64_C(0x1f42fece6cae8702),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000628d), UINT64_C(0x1f42fb4e6cb4072e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd4e7cb6c731), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000628e), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd8eccb08702),
        UINT64_C(0x1f42fb4e84bb2737), UINT64_C(0x1f42ff4ff8b3e6fb)
    },
    {   UINT64_C(0x000000000000898e), UINT64_C(0x0000000000000000), UINT64_C(0x23f3188e58b906c0),
        UINT64_C(0x23f3188e58b906c0), UINT64_C(0x23f3188e58b906c0)
    },
    {   UINT64_C(0x000000000000628f), UINT64_C(0x1f42fa9054b7470b), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4303ce50ac8736), UINT64_C(0x1f42f2cff8b7471a)
    },
    {   UINT64_C(0x000000000000898f), UINT64_C(0x1a2af98db8a16657), UINT64_C(0x140af80e5889a6c0),
        UINT64_C(0x140af80e5889a6c0), UINT64_C(0x12dafe4c8881c6a6)
    },
    {   UINT64_C(0x0000000000006290), UINT64_C(0x1f42fd8f9caec702), UINT64_C(0x1f42f84fd8b50702),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008990), UINT64_C(0x12dafe4d8481c666), UINT64_C(0x12dafe4d8481c666),
        UINT64_C(0x14a2fb8d948c0662), UINT64_C(0x1e52fe8ce0af86c4)
    },
    {   UINT64_C(0x0000000000006291), UINT64_C(0x1f42fa8f5cb5c6fb), UINT64_C(0x1f42fc8ebcb786f6),
        UINT64_C(0x1f42fb8ff0b5a712), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008991), UINT64_C(0x1e52fdcd70aac701), UINT64_C(0x0000000000000000),
        UINT64_C(0x1a42fd0de8a006e0), UINT64_C(0x13c3010de88686c2)
    },
    {   UINT64_C(0x0000000000006292), UINT64_C(0x1f43028e9cb2471d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb8ea8b36711), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008992), UINT64_C(0x1e22f44de8b3e6e0), UINT64_C(0x186af8cd749ac66c),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006293), UINT64_C(0x1f42fa8fa8b3e6fe), UINT64_C(0x1f42f98fc8b5670a),
        UINT64_C(0x1f42f99008b20706), UINT64_C(0x1f42f98f40b0c706)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006294), UINT64_C(0x1f42ff0ee8b18726), UINT64_C(0x1f42fd8fa4b146fd),
        UINT64_C(0x1f43014f9cae86f0), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000058e7), UINT64_C(0x1f42fdcf40b5c6dd), UINT64_C(0x1f42fa8f70ade708),
        UINT64_C(0x1f42f7cf34aee6fc), UINT64_C(0x1f42fb4fb8b206f4)
    },
    {   UINT64_C(0x0000000000006295), UINT64_C(0x1f42fb8ff8ac8726), UINT64_C(0x1f42fe4f18b6e703),
        UINT64_C(0x1f42fa8f44b68719), UINT64_C(0x1f42f88f10aea70d)
    },
    {   UINT64_C(0x00000000000058e8), UINT64_C(0x1f42f78ee0afc724), UINT64_C(0x1f42f70ef8b7a718),
        UINT64_C(0x1f42f90eecb6c720), UINT64_C(0x1f43078e18b1273c)
    },
    {   UINT64_C(0x0000000000006296), UINT64_C(0x1f42fa8fa8afe70a), UINT64_C(0x1f42f78fb8b58709),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa4fd4b7c70b)
    },
    {   UINT64_C(0x00000000000058e9), UINT64_C(0x1f42ffcf78ac26f0), UINT64_C(0x1f42f98f28b8271c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80eecb3c718)
    },
    {   UINT64_C(0x0000000000006297), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb8f58ae4735), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000058ea), UINT64_C(0x1f42fc8e9cb3c732), UINT64_C(0x1f42f78f2cb9272d),
        UINT64_C(0x1f42f64ee8b4e718), UINT64_C(0x1f42f88f38b5a6e4)
    },
    {   UINT64_C(0x0000000000006298), UINT64_C(0x1f42f68f0cb5c728), UINT64_C(0x1f42f9cff8afe719),
        UINT64_C(0x1f42f58f28b08730), UINT64_C(0x1f42fc8efcaf4704)
    },
    {   UINT64_C(0x0000000000008998), UINT64_C(0x156af68e148fe649), UINT64_C(0x156af68dfc8fe643),
        UINT64_C(0x156af84dfc8ee649), UINT64_C(0x156af68e148fe643)
    },
    {   UINT64_C(0x0000000000006299), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff4f40b8070d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008999), UINT64_C(0x156af68e148fe649), UINT64_C(0x156af68dfc8fe643),
        UINT64_C(0x156af84dfc8ee649), UINT64_C(0x156af68e148fe643)
    },
    {   UINT64_C(0x000000000000629a), UINT64_C(0x1f42fd8f6cb5c6ff), UINT64_C(0x1f42fe8e64b5e739),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc8ff8b5e715)
    },
    {   UINT64_C(0x000000000000899a), UINT64_C(0x0000000000000000), UINT64_C(0x0c32f94dac69a6b2),
        UINT64_C(0x1182fa8dac7e46b2), UINT64_C(0x1a42f80dac98a732)
    },
    {   UINT64_C(0x000000000000629b), UINT64_C(0x1f42fa8f94ade716), UINT64_C(0x1f42f98f84b50734),
        UINT64_C(0x1f42f64fb8b6070d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000058ee), UINT64_C(0x1f42fa0e8caf8706), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f74ec4b6671b), UINT64_C(0x1f42f70f24b70704)
    },
    {   UINT64_C(0x000000000000629c), UINT64_C(0x1f42fa4f98ad8719), UINT64_C(0x1f42fe8fc8b30711),
        UINT64_C(0x1f42fc8f70b1272a), UINT64_C(0x1f42f88e7cb56739)
    },
    {   UINT64_C(0x00000000000058ef), UINT64_C(0x1f42fa0f20b06709), UINT64_C(0x1f42f48ef4b146f8),
        UINT64_C(0x1f42f90eb4b7e702), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000629d), UINT64_C(0x1f42fd8f10ab2719), UINT64_C(0x1f42f98fbcb6c719),
        UINT64_C(0x1f42f98e9cad2719), UINT64_C(0x1f42f98ed4ae2719)
    },
    {   UINT64_C(0x00000000000058f0), UINT64_C(0x1f42f68edcb6c73d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f80f00aa270b), UINT64_C(0x1f42fb0e50b2e70b)
    },
    {   UINT64_C(0x000000000000629e), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff4e90ae0741),
        UINT64_C(0x1f42f98f0cac2719), UINT64_C(0x1f42fa8f4cb6e70d)
    },
    {   UINT64_C(0x00000000000058f1), UINT64_C(0x1f42f98efcb3a702), UINT64_C(0x1f43068e80ac8700),
        UINT64_C(0x1f42f78f80b80720), UINT64_C(0x1f42fc0f20ad070c)
    },
    {   UINT64_C(0x000000000000629f), UINT64_C(0x1f42fb8fe8b4c70a), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc8fe8b266f7)
    },
    {   UINT64_C(0x000000000000899f), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x2512ff8b64ca06ef), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062a0), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8f24b2870a),
        UINT64_C(0x1f42f79024b7c719), UINT64_C(0x1f42f98eecb0a719)
    },
    {   UINT64_C(0x00000000000089a0), UINT64_C(0x2043188f44aa4685), UINT64_C(0x2043188f44aa4685),
        UINT64_C(0x2043188f44aa4685), UINT64_C(0x2043188f44aa4685)
    },
    {   UINT64_C(0x00000000000062a1), UINT64_C(0x1f42fd8f18b6c71e), UINT64_C(0x1f42f54e7cb6c742),
        UINT64_C(0x1f42f98f44b02721), UINT64_C(0x1f42f84eb0b7272c)
    },
    {   UINT64_C(0x00000000000089a1), UINT64_C(0x2043188f44aa4685), UINT64_C(0x2043188f44aa4685),
        UINT64_C(0x2043140ef8aca697), UINT64_C(0x2043140ef8aca697)
    },
    {   UINT64_C(0x00000000000062a2), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe4f0cb8271d),
        UINT64_C(0x1f42ff0edcb80729), UINT64_C(0x1f42f64f64b5470b)
    },
    {   UINT64_C(0x00000000000089a2), UINT64_C(0x2043140ef8aca697), UINT64_C(0x2043140ef8aca697),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062a3), UINT64_C(0x1f42fb4f98b64733), UINT64_C(0x1f42f9900cb74711),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f94ed8b72713)
    },
    {   UINT64_C(0x00000000000058f6), UINT64_C(0x1f42fa4f14af46fc), UINT64_C(0x1f42f84f40ac06fb),
        UINT64_C(0x1f42fa0eccb34720), UINT64_C(0x1f42f90f34b6471e)
    },
    {   UINT64_C(0x00000000000062a4), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f48fd8b7c707),
        UINT64_C(0x1f42f94f7cb3c710), UINT64_C(0x1f42fe0e44b4a738)
    },
    {   UINT64_C(0x00000000000058f7), UINT64_C(0x1f42f90e4cb52720), UINT64_C(0x1f42f84ee4b586f6),
        UINT64_C(0x1f42fe8f3cb14706), UINT64_C(0x1f42fc0ee8b366ec)
    },
    {   UINT64_C(0x00000000000062a5), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fccfd0b66709),
        UINT64_C(0x1f42f64e5cb4071f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000058f8), UINT64_C(0x1f42fa0ef4b16703), UINT64_C(0x1f42f5cf88b5a720),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80f30aa6710)
    },
    {   UINT64_C(0x00000000000062a6), UINT64_C(0x1f42fb8e9cb2e717), UINT64_C(0x1f42f64fbcb266fe),
        UINT64_C(0x1f42fc8f28a8a712), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000058f9), UINT64_C(0x1f42f84e8cb366eb), UINT64_C(0x1f42fb0e2cb0a70f),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43170eacab071d)
    },
    {   UINT64_C(0x00000000000062a7), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42facfb8b8271a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000058fa), UINT64_C(0x1f42fe0e90b1670a), UINT64_C(0x1f42f30f0cb3a723),
        UINT64_C(0x1f42f70f50b7c6fc), UINT64_C(0x1f43104eb0ae6701)
    },
    {   UINT64_C(0x00000000000062a8), UINT64_C(0x1f42fbcf78b4a725), UINT64_C(0x1f42fb8f40b5c71d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8f88b54716)
    },
    {   UINT64_C(0x00000000000089a8), UINT64_C(0x2f32f44d34f827e7), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062a9), UINT64_C(0x1f42f54fa8b746f8), UINT64_C(0x1f42fb8f88b4a719),
        UINT64_C(0x1f42f78f40adc70e), UINT64_C(0x1f42f8cf2cb0672c)
    },
    {   UINT64_C(0x00000000000089a9), UINT64_C(0x0000000000000000), UINT64_C(0x14a2fb8b3c8c06f8),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062aa), UINT64_C(0x1f42f58ee8b92742), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f68f94b8270b), UINT64_C(0x1f42fb4f50b7870b)
    },
    {   UINT64_C(0x00000000000089aa), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x17d2fa8e6497862f), UINT64_C(0x17d2fa8e6497862f)
    },
    {   UINT64_C(0x00000000000062ab), UINT64_C(0x1f42f58f94b7a70b), UINT64_C(0x1f42f34fe0b8e737),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000089ab), UINT64_C(0x11aaf98fd87f65cf), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062ac), UINT64_C(0x1f42f84e70b5c725), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f54e98b9672c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000089ac), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x12dafe4d8481c666), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062ad), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb8e5cb16712), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005900), UINT64_C(0x1f42fa0f18b0e720), UINT64_C(0x1f42f90f64aca703),
        UINT64_C(0x1f42facef8b0e710), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062ae), UINT64_C(0x1f42f7cfb8b246f6), UINT64_C(0x1f42f68ef8b2e715),
        UINT64_C(0x1f42fa8e9cb72726), UINT64_C(0x1f42fc8ef4b7a6ff)
    },
    {   UINT64_C(0x0000000000005901), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb0f60b2c70c),
        UINT64_C(0x1f42f6ce80b5a74a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062af), UINT64_C(0x1f42fb8ff8b84725), UINT64_C(0x1f42f88f80b76703),
        UINT64_C(0x1f43100e7caa272c), UINT64_C(0x1f43018f0caf472c)
    },
    {   UINT64_C(0x0000000000005902), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f9cef4af871d),
        UINT64_C(0x1f42f94e6caee706), UINT64_C(0x1f42fb4f44b64703)
    },
    {   UINT64_C(0x00000000000062b0), UINT64_C(0x1f42f7cee8b6e71a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f8cfc0b346fe), UINT64_C(0x1f42f5cf08b7271a)
    },
    {   UINT64_C(0x0000000000005903), UINT64_C(0x1f42f64e98b74700), UINT64_C(0x1f42f80f18aa0727),
        UINT64_C(0x1f42f68ef0b2c6ef), UINT64_C(0x1f42f80e50b5c734)
    },
    {   UINT64_C(0x00000000000062b1), UINT64_C(0x1f42f4ce94b56740), UINT64_C(0x1f42f48e70b74745),
        UINT64_C(0x1f42fd8f30b4e72d), UINT64_C(0x1f43014facb7a715)
    },
    {   UINT64_C(0x0000000000019100), UINT64_C(0x1692f04fa094a69a), UINT64_C(0x14daf20fa08be68c),
        UINT64_C(0x1692fa4f5494669b), UINT64_C(0x1692f18fa094c68c)
    },
    {   UINT64_C(0x00000000000062b2), UINT64_C(0x1f42fd8f8cb846d8), UINT64_C(0x1f42f98f88b5a719),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe4e70b5072c)
    },
    {   UINT64_C(0x0000000000005905), UINT64_C(0x1f42f88f24b7e704), UINT64_C(0x1f42f50ed8b62712),
        UINT64_C(0x1f42f8cef4b0072b), UINT64_C(0x1f42f88ed4b2c739)
    },
    {   UINT64_C(0x00000000000062b3), UINT64_C(0x1f42f68e8cb72739), UINT64_C(0x1f42f88ec4b70730),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f4cf48b6a715)
    },
    {   UINT64_C(0x0000000000019102), UINT64_C(0x0c2af30fa06cc68c), UINT64_C(0x0fa2eece207a468c),
        UINT64_C(0x1852f58fa09ea68c), UINT64_C(0x14daf2cfa08e468c)
    },
    {   UINT64_C(0x00000000000062b4), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff4f3cb84726),
        UINT64_C(0x1f43018f20b4071e), UINT64_C(0x1f42fc4ea0b406fe)
    },
    {   UINT64_C(0x0000000000019103), UINT64_C(0x1d82f18fa0b1a68c), UINT64_C(0x1692f20f5896268c),
        UINT64_C(0x1852f6cf549b669b), UINT64_C(0x131af20fa089868c)
    },
    {   UINT64_C(0x00000000000062b5), UINT64_C(0x1f42f79038b886f6), UINT64_C(0x1f42f7cf6cb6872d),
        UINT64_C(0x1f42fb8f38b7a711), UINT64_C(0x1f42fa8f5cb94718)
    },
    {   UINT64_C(0x0000000000019104), UINT64_C(0x1852f6cce09b669b), UINT64_C(0x1692f48fa098068c),
        UINT64_C(0x1162f6cf547ea69c), UINT64_C(0x14daf5cfa08e068c)
    },
    {   UINT64_C(0x00000000000062b6), UINT64_C(0x1f43020ee8b60719), UINT64_C(0x1f42ff8ee0b64701),
        UINT64_C(0x1f42f48fb8b8470a), UINT64_C(0x1f42f78fb8b66709)
    },
    {   UINT64_C(0x0000000000019105), UINT64_C(0x1692f20f5496268c), UINT64_C(0x1692f20f5896268c),
        UINT64_C(0x1f42f2cf64b9268c), UINT64_C(0x1692f20fa095e68c)
    },
    {   UINT64_C(0x00000000000062b7), UINT64_C(0x1f42f78e9cb82731), UINT64_C(0x1f42fd8f5cb6270a),
        UINT64_C(0x1f42f78f8cae0717), UINT64_C(0x1f42f68fc8b6e6f6)
    },
    {   UINT64_C(0x0000000000019106), UINT64_C(0x1692f1cfa095e68c), UINT64_C(0x14daf50fa08dc68c),
        UINT64_C(0x0fa2f44f687b85c1), UINT64_C(0x1162f24f687fa68c)
    },
    {   UINT64_C(0x00000000000062b8), UINT64_C(0x1f42fd9028afc706), UINT64_C(0x1f42fa8fd0b68708),
        UINT64_C(0x1f42fcced8b466e5), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000089b8), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x15e3058e608a46ed), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062b9), UINT64_C(0x1f42fd8f38b0a707), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f68e6cb6e731), UINT64_C(0x1f42f88ef0b3c724)
    },
    {   UINT64_C(0x000000000000590c), UINT64_C(0x1f42f78e60b3e700), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f84efcae8712)
    },
    {   UINT64_C(0x00000000000062ba), UINT64_C(0x1f42fa8f30b1a6ec), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f88e8cb82739)
    },
    {   UINT64_C(0x0000000000019109), UINT64_C(0x1162f38fa082668c), UINT64_C(0x08b2f1cfa05e868c),
        UINT64_C(0x1a0af1cfa0a445c1), UINT64_C(0x1162f34fa081e5c1)
    },
    {   UINT64_C(0x00000000000062bb), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f7cea0b6c72b),
        UINT64_C(0x1f42fa8fa8b7c72f), UINT64_C(0x1f42f58edcb246f2)
    },
    {   UINT64_C(0x000000000000590e), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8f64b20700),
        UINT64_C(0x1f42fa0ed0abc718), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062bc), UINT64_C(0x1f42f78fc0b6a6ee), UINT64_C(0x1f42fd8e2cb5c742),
        UINT64_C(0x1f42fd8f78b346e0), UINT64_C(0x1f42fc8f2cb02721)
    },
    {   UINT64_C(0x000000000000590f), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f78e98b88722),
        UINT64_C(0x1f42f88e6cb1e717), UINT64_C(0x1f42f48ea0b806dc)
    },
    {   UINT64_C(0x00000000000062bd), UINT64_C(0x1f42f78ef0b6c70f), UINT64_C(0x1f42fc8f48b446f5),
        UINT64_C(0x1f42fc4f7cb4c72d), UINT64_C(0x1f42f78f28b7070e)
    },
    {   UINT64_C(0x000000000001910c), UINT64_C(0x1692f3cf6896e5b5), UINT64_C(0x0fa2f10fa07b05b5),
        UINT64_C(0x0fa2f20c6c7ac5b5), UINT64_C(0x0de2f34fa07305b5)
    },
    {   UINT64_C(0x00000000000062be), UINT64_C(0x1f43004f50b86725), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f9ce34abe738), UINT64_C(0x1f42f98f68b42705)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062bf), UINT64_C(0x1f42fa4f6cb7e712), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43014fe8b0e72c), UINT64_C(0x1f42fe4e5cb766eb)
    },
    {   UINT64_C(0x000000000001910e), UINT64_C(0x1652f78fa09a4675), UINT64_C(0x1352f78fa098e675),
        UINT64_C(0x16f2fa8f709a4684), UINT64_C(0x1b4af78fa0b1e675)
    },
    {   UINT64_C(0x00000000000062c0), UINT64_C(0x1f42f78edcb8a738), UINT64_C(0x1f42f7ced0b00714),
        UINT64_C(0x1f42ff4eecafa70e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000089c0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1e0af6d0e8afa64c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062c1), UINT64_C(0x1f42f54ef0b7e73d), UINT64_C(0x1f43028eb4ae0700),
        UINT64_C(0x1f42f98f58ab473a), UINT64_C(0x1f4302ce84b7e743)
    },
    {   UINT64_C(0x0000000000005914), UINT64_C(0x1f42f94f0cb726f7), UINT64_C(0x1f42fa4f24ad2718),
        UINT64_C(0x1f42f5cf08b3e720), UINT64_C(0x1f42f3cf14b80705)
    },
    {   UINT64_C(0x000000001f88fec0), UINT64_C(0x1312f1cfa091c69b), UINT64_C(0x1162f18fa081869b),
        UINT64_C(0x1162f1cfa081669b), UINT64_C(0x1a0af1cfa0a4269b)
    },
    {   UINT64_C(0x00000000000089c2), UINT64_C(0x0000000000000000), UINT64_C(0x1592f691c88e4613),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062c3), UINT64_C(0x1f42f74eb0b6e70e), UINT64_C(0x1f430a0e90af6726),
        UINT64_C(0x1f42f64ff8b5670c), UINT64_C(0x1f42f94f90b58721)
    },
    {   UINT64_C(0x0000000000019112), UINT64_C(0x160afe4f6c9f6675), UINT64_C(0x11fafd0f609d8675),
        UINT64_C(0x1ca2fd0f60c82675), UINT64_C(0x18b2f44fa0a3c675)
    },
    {   UINT64_C(0x00000000000062c4), UINT64_C(0x1f42fad030b0c702), UINT64_C(0x1f43008f54b3c709),
        UINT64_C(0x1f42fd8f1cb866fd), UINT64_C(0x1f43028eecb246e6)
    },
    {   UINT64_C(0x00000000000089c4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x179af68f709686ab)
    },
    {   UINT64_C(0x00000000000062c5), UINT64_C(0x1f42f88e78b7a72f), UINT64_C(0x1f42fd8f10b72700),
        UINT64_C(0x1f42f7cfc0b6c70e), UINT64_C(0x1f42f54e9cb4c740)
    },
    {   UINT64_C(0x0000000000005918), UINT64_C(0x1f42f9cee8b30713), UINT64_C(0x1f42f78f98b786f0),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x1ff3f87dc0008018), UINT64_C(0x0a6af2978c5cc68e), UINT64_C(0x0de2f74f7875c5b4),
        UINT64_C(0x0fa2eecf78790693), UINT64_C(0x0de2f44f787205b4)
    },
    {   UINT64_C(0x0000000000005919), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f64ec8b06724),
        UINT64_C(0x1f42f58f3cb826e8), UINT64_C(0x1f42facf08b14732)
    },
    {   UINT64_C(0x00000000000062c7), UINT64_C(0x1f42fbceacb02706), UINT64_C(0x1f42f88f44b22724),
        UINT64_C(0x1f43008f68b04700), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000591a), UINT64_C(0x1f42f8ceacb14708), UINT64_C(0x1f42f88e34ae673d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f64f2cb646f6)
    },
    {   UINT64_C(0x00000000000062c8), UINT64_C(0x1f42f58fb4b2073c), UINT64_C(0x1f42fb4fb8b5070a),
        UINT64_C(0x1f42facef8b5c6fd), UINT64_C(0x1f42f6ce50b726ef)
    },
    {   UINT64_C(0x000000000000591b), UINT64_C(0x1f42f64ef4b4272d), UINT64_C(0x1f42f70ef4b02703),
        UINT64_C(0x1f4310ce60ace723), UINT64_C(0x1f43094e34b1a745)
    },
    {   UINT64_C(0x00000000000062c9), UINT64_C(0x1f42f78e94b0e70f), UINT64_C(0x1f42fccf34b4e71c),
        UINT64_C(0x1f42f88e70b3672d), UINT64_C(0x1f42f7cf40b22722)
    },
    {   UINT64_C(0x000000000000591c), UINT64_C(0x1f4312ce5cb1271e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f50ed8b52707), UINT64_C(0x1f42f90f04acc70c)
    },
    {   UINT64_C(0x00000000000062ca), UINT64_C(0x1f42f68f50b6471d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa8e28b08716), UINT64_C(0x1f42f58f00b1e725)
    },
    {   UINT64_C(0x00000000000089ca), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x18aaf6cdf89a264d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062cb), UINT64_C(0x1f42f58e50b8a725), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42face70b4e734), UINT64_C(0x1f42fd8ee4b2a716)
    },
    {   UINT64_C(0x00000000000029c6), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x106aff931077669e)
    },
    {   UINT64_C(0x00000000000029c7), UINT64_C(0x106aff931077669e), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000591f), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe0ed8ad86e5),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f98e74b3c703)
    },
    {   UINT64_C(0x00000000000062cd), UINT64_C(0x0000000000000000), UINT64_C(0x1f42facec0b386f1),
        UINT64_C(0x1f42f78f54b4e711), UINT64_C(0x1f43014e40afc734)
    },
    {   UINT64_C(0x0000000000005920), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f90efcb48707), UINT64_C(0x1f43028e60b14722)
    },
    {   UINT64_C(0x00000000000062ce), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f68f44b52735),
        UINT64_C(0x1f43070e60afe732), UINT64_C(0x1f42fa8f10b526f9)
    },
    {   UINT64_C(0x0000000000005921), UINT64_C(0x1f42facee4b2a6f5), UINT64_C(0x1f42f5cf34b98718),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f44f98b726eb)
    },
    {   UINT64_C(0x00000000000062cf), UINT64_C(0x1f42fcce94b28722), UINT64_C(0x1f43098e70ace722),
        UINT64_C(0x1f42f58ee4b8670c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000089cf), UINT64_C(0x0000000000000000), UINT64_C(0x1552f6cdf08cc64c),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062d0), UINT64_C(0x1f42f84ef8b726de), UINT64_C(0x1f42f8ce6cb14738),
        UINT64_C(0x1f42fa4e30aee6f6), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001911f), UINT64_C(0x16eb000f78a3c685), UINT64_C(0x128afe8f64a22685),
        UINT64_C(0x1ceafe8f5ccba685), UINT64_C(0x1942f50fa0a64685)
    },
    {   UINT64_C(0x00000000000062d1), UINT64_C(0x0000000000000000), UINT64_C(0x1f43014fccb4e716),
        UINT64_C(0x1f42f9cee0b34738), UINT64_C(0x1f42f9ce94b7471b)
    },
    {   UINT64_C(0x0000000000005924), UINT64_C(0x1f42f8ced8b1c716), UINT64_C(0x1f42f8ceccb0071a),
        UINT64_C(0x1f42f64f6cb7470b), UINT64_C(0x1f42f7cef4b68731)
    },
    {   UINT64_C(0x00000000000062d2), UINT64_C(0x1f42f68e80b78705), UINT64_C(0x1f42f5cf60b7c6fe),
        UINT64_C(0x1f42f54edcb50721), UINT64_C(0x1f42fe4edcb0c6e6)
    },
    {   UINT64_C(0x0000000000019121), UINT64_C(0x0eeaf90f787805b6), UINT64_C(0x129af90f68882695),
        UINT64_C(0x0f92f90f7877e5b6), UINT64_C(0x11e2f90c688d8695)
    },
    {   UINT64_C(0x00000000000062d3), UINT64_C(0x1f42f70eb4b7071e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa8eacb0871c), UINT64_C(0x1f42f94e98b4473c)
    },
    {   UINT64_C(0x0000000000005926), UINT64_C(0x1f42f84efcb8e6f9), UINT64_C(0x1f42f94e50b06744),
        UINT64_C(0x1f42f58f90b346fc), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062d4), UINT64_C(0x1f42fd8e94b14733), UINT64_C(0x1f42f98ef0b6870e),
        UINT64_C(0x1f42f78ed4b62704), UINT64_C(0x1f42f54f58b58724)
    },
    {   UINT64_C(0x0000000000019123), UINT64_C(0x1222fbcf7484e696), UINT64_C(0x0ad2fa8f7c654695),
        UINT64_C(0x17c2f64f7c9965bb), UINT64_C(0x117af64f788045bb)
    },
    {   UINT64_C(0x00000000000062d5), UINT64_C(0x1f42f98fb0b06709), UINT64_C(0x1f42f54f98b726f6),
        UINT64_C(0x1f42f6cef4b5c711), UINT64_C(0x1f42fccf2cb8a6e8)
    },
    {   UINT64_C(0x0000000000019124), UINT64_C(0x118af90f7881e5b6), UINT64_C(0x11dae5cc6c83c5bd),
        UINT64_C(0x1072f90c6c8105b6), UINT64_C(0x0dcaf64fa07385bb)
    },
    {   UINT64_C(0x00000000000062d6), UINT64_C(0x1f42f78e58b8a719), UINT64_C(0x1f42f9cfa4b0e707),
        UINT64_C(0x1f42f88e5cb36733), UINT64_C(0x1f42f58f54b7a741)
    },
    {   UINT64_C(0x0000000000019125), UINT64_C(0x0ed2fbcf7472e5b6), UINT64_C(0x0afaf90f78664638),
        UINT64_C(0x10baf64f787d45b7), UINT64_C(0x1152fb0f6881e5c1)
    },
    {   UINT64_C(0x00000000000062d7), UINT64_C(0x1f42fc8f50b3c72d), UINT64_C(0x1f42f7cf3cb82702),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f98ef8b6a704)
    },
    {   UINT64_C(0x000000000000592a), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f28e98b5c70c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80f94b5c725)
    },
    {   UINT64_C(0x00000000000062d8), UINT64_C(0x1f42fd8ec8b42721), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd8f78b86729)
    },
    {   UINT64_C(0x0000000000019127), UINT64_C(0x1abaf5cf64a8468a), UINT64_C(0x0000000000000000),
        UINT64_C(0x18eaf74f64a02697), UINT64_C(0x1baaf70f64a4c697)
    },
    {   UINT64_C(0x00000000000062d9), UINT64_C(0x0000000000000000), UINT64_C(0x1f43118e54ae272d),
        UINT64_C(0x1f43058e70b14732), UINT64_C(0x1f42fb8eecb5c71d)
    },
    {   UINT64_C(0x0000000000019128), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x182b02cf649b0697), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062da), UINT64_C(0x1f42fbce58b76749), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd8e3cb0872d), UINT64_C(0x1f42f5cee0b2e72c)
    },
    {   UINT64_C(0x0000000000019129), UINT64_C(0x0000000000000000), UINT64_C(0x1912f04cdca1868a),
        UINT64_C(0x1f8af80f64bc0697), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001912a), UINT64_C(0x0000000000000000), UINT64_C(0x1e52f78f64b60697),
        UINT64_C(0x15a3028f64916690), UINT64_C(0x1c72f78f64ad4697)
    },
    {   UINT64_C(0x00000000000062dc), UINT64_C(0x1f42f98e48b48733), UINT64_C(0x1f4304cdc8b0074f),
        UINT64_C(0x1f42fb4e64b4e743), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001912b), UINT64_C(0x15a3028f08916690), UINT64_C(0x0000000000000000),
        UINT64_C(0x173afecf64962690), UINT64_C(0x1c82f8cf64afe697)
    },
    {   UINT64_C(0x00000000000062dd), UINT64_C(0x1f42f98ef4b6c702), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f88ed0b7a73e)
    },
    {   UINT64_C(0x000000000001912c), UINT64_C(0x1a52f70f64a32697), UINT64_C(0x1d22f6cf64b1c697),
        UINT64_C(0x21b2f6cf64c44697), UINT64_C(0x1bdaf70f64aba697)
    },
    {   UINT64_C(0x00000000000062de), UINT64_C(0x1f42fbce58b44745), UINT64_C(0x1f42f9ceb4b24727),
        UINT64_C(0x1f42fb9094b82715), UINT64_C(0x1f430f4e40ab0731)
    },
    {   UINT64_C(0x000000000001912d), UINT64_C(0x1cf304cc18b10697), UINT64_C(0x1d22fccf64b08697),
        UINT64_C(0x199af58f749d45a1), UINT64_C(0x1222f9cf70846697)
    },
    {   UINT64_C(0x00000000000062df), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f98e60b74735),
        UINT64_C(0x1f42f98eaca94739), UINT64_C(0x1f43024f68b48716)
    },
    {   UINT64_C(0x0000000000005932), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f58e98b0e6fc),
        UINT64_C(0x1f43030e60b48734), UINT64_C(0x1f42f94ec4b006f7)
    },
    {   UINT64_C(0x00000000000062e0), UINT64_C(0x1f42fc8e90ae0732), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42face84aea737), UINT64_C(0x1f42ff4eb0b2e733)
    },
    {   UINT64_C(0x000000000001912f), UINT64_C(0x0000000000000000), UINT64_C(0x178af78f7494c697),
        UINT64_C(0x0f8302cf747b0675), UINT64_C(0x16d2f04c34984675)
    },
    {   UINT64_C(0x00000000000062e1), UINT64_C(0x1f42fa8fc0b7870e), UINT64_C(0x1f42f78f30b4a729),
        UINT64_C(0x1f43058e90ae872f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000019130), UINT64_C(0x16b2f80f7491c697), UINT64_C(0x121afa0f7485e697),
        UINT64_C(0x2072fa4f74b8c5a1), UINT64_C(0x17cafa4f749625a1)
    },
    {   UINT64_C(0x00000000000062e2), UINT64_C(0x1f42facf6cb54712), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430e4e8cb0671c), UINT64_C(0x1f430c0e24ace748)
    },
    {   UINT64_C(0x00000000000089e2), UINT64_C(0x18a2f6cf689a26a9), UINT64_C(0x18a2f6cf689a26a9),
        UINT64_C(0x18a2f6cf689a26a9), UINT64_C(0x18a2f6cf689a26a9)
    },
    {   UINT64_C(0x00000000000062e3), UINT64_C(0x1f42fd8fc4b16713), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f90f54b8670e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000019132), UINT64_C(0x101afd8f747205fb), UINT64_C(0x113af58f7481067a),
        UINT64_C(0x178af58f74952590), UINT64_C(0x1352f58f748745a1)
    },
    {   UINT64_C(0x00000000000062e4), UINT64_C(0x1f43070e24af0737), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f58e58b6e73a), UINT64_C(0x1f42fa8e64b48743)
    },
    {   UINT64_C(0x00000000000089e4), UINT64_C(0x18a2f6cf689a26a9), UINT64_C(0x18a2f6cf689a26a9),
        UINT64_C(0x18a2f6cf689a26a9), UINT64_C(0x18a2f6cf689a26a9)
    },
    {   UINT64_C(0x00000000000062e5), UINT64_C(0x1f42f8cf68b4a715), UINT64_C(0x1f42f78ed0b06717),
        UINT64_C(0x1f42f7ce98b68737), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000019134), UINT64_C(0x1ec2fa8f4cb5e6a3), UINT64_C(0x2122fbcf4cb9a6a3),
        UINT64_C(0x1c82fd0f4cac26a3), UINT64_C(0x1efafd0f4cafc6a3)
    },
    {   UINT64_C(0x00000000000062e6), UINT64_C(0x1f42f7ce6cb5472c), UINT64_C(0x1f42f6ce3cb0c72c),
        UINT64_C(0x1f42f98e94b4c741), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000089e6), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1cb2f6d0b8aa2599)
    },
    {   UINT64_C(0x00000000000062e7), UINT64_C(0x1f42f7cebcb34745), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f7cf6cb8270e), UINT64_C(0x1f42f48f14b52739)
    },
    {   UINT64_C(0x000000000000593a), UINT64_C(0x1f42f58fa8b3e6df), UINT64_C(0x1f42fa0f38b0a700),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f60f88b446f3)
    },
    {   UINT64_C(0x00000000000062e8), UINT64_C(0x1f42f910487786e7), UINT64_C(0x1f42fc4f34b3e70b),
        UINT64_C(0x1f43040f80b24709), UINT64_C(0x1f42f90eecb1271f)
    },
    {   UINT64_C(0x0000000000019137), UINT64_C(0x28a2fd0f4cda26a3), UINT64_C(0x223afd0f4cc546a3),
        UINT64_C(0x194b000f4c9c26a3), UINT64_C(0x200afbcf4cbac6a3)
    },
    {   UINT64_C(0x00000000000062e9), UINT64_C(0x1f42f4cfb0b646eb), UINT64_C(0x1f42fb9044b4670e),
        UINT64_C(0x1f42fa4f18b266eb), UINT64_C(0x1f42fa106cb4a6eb)
    },
    {   UINT64_C(0x0000000000019138), UINT64_C(0x194b000ed09c26a3), UINT64_C(0x20c2fbcf4cb826a3),
        UINT64_C(0x1983024f4ca026a3), UINT64_C(0x2032fe4f4cbea6a3)
    },
    {   UINT64_C(0x00000000000062ea), UINT64_C(0x1f42fc4ee4b20705), UINT64_C(0x1f42f85010b066eb),
        UINT64_C(0x1f42fb5090aee6ea), UINT64_C(0x1f42fa4fd4b2a723)
    },
    {   UINT64_C(0x0000000000019139), UINT64_C(0x1e22fd0f4caf86a3), UINT64_C(0x2082fd0f4cbe86a3),
        UINT64_C(0x2942fd0f4ce1c6a3), UINT64_C(0x204afe0f4cbcc6a3)
    },
    {   UINT64_C(0x00000000000062eb), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f70ef8ace705),
        UINT64_C(0x1f42fd500cb526e0), UINT64_C(0x1f42f70f68b3a70a)
    },
    {   UINT64_C(0x000000000001913a), UINT64_C(0x1eeafd0c20b6e6a3), UINT64_C(0x1f22fa8f4cb886a3),
        UINT64_C(0x1d72f6cf68aaa5b6), UINT64_C(0x1432fd0f688c86a3)
    },
    {   UINT64_C(0x00000000000062ec), UINT64_C(0x1f42fe9028b506ff), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd8ef8b28722), UINT64_C(0x1f42ff0f08afc720)
    },
    {   UINT64_C(0x000000000000593f), UINT64_C(0x1f42f9ce48b0271d), UINT64_C(0x1f42fb4edcb56708),
        UINT64_C(0x1f42f70ea8b4072c), UINT64_C(0x1f42f4cf10b6e70e)
    },
    {   UINT64_C(0x00000000000062ed), UINT64_C(0x1f42fb8ff8b0a6ee), UINT64_C(0x1f42fc504cb1e6ee),
        UINT64_C(0x1f42f84efcaf670b), UINT64_C(0x1f42f84f68ac46f9)
    },
    {   UINT64_C(0x000000000001913c), UINT64_C(0x199af4cc209ee5b6), UINT64_C(0x1a32fbcf689d46a3),
        UINT64_C(0x1172f80f688146a2), UINT64_C(0x1a42f84c24a566a2)
    },
    {   UINT64_C(0x00000000000062ee), UINT64_C(0x1f42fd0eacb3e712), UINT64_C(0x1f42fd9078b366e9),
        UINT64_C(0x1f42fc8fa8b646ef), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001913d), UINT64_C(0x1952fbcf6899c6a3), UINT64_C(0x1452f8cf688d86a3),
        UINT64_C(0x238af94f68c2a5b6), UINT64_C(0x1a9af94f689ee5b6)
    },
    {   UINT64_C(0x00000000000062ef), UINT64_C(0x1f42f99068b626eb), UINT64_C(0x1f42fb4fe4b5c6ff),
        UINT64_C(0x1f42f70fbcb546ee), UINT64_C(0x1f42fe4fb0afc6f7)
    },
    {   UINT64_C(0x000000000001913e), UINT64_C(0x1a82f6cf68a005b6), UINT64_C(0x1baaf44c6c9ec5b6),
        UINT64_C(0x1c8af6cc6ca6a5b6), UINT64_C(0x152af80fa08f85b6)
    },
    {   UINT64_C(0x00000000000062f0), UINT64_C(0x1f42f78fc0b5c6e3), UINT64_C(0x1f42fa9080b0e70b),
        UINT64_C(0x1f42fb5018b006f4), UINT64_C(0x1f42fd4f5cb3e6f2)
    },
    {   UINT64_C(0x000000000001913f), UINT64_C(0x1192facf6876a615), UINT64_C(0x1352f9cf688b0685),
        UINT64_C(0x1a52f5cf689dc5aa), UINT64_C(0x16e2f80f689245b2)
    },
    {   UINT64_C(0x00000000000062f1), UINT64_C(0x1f42fb8f08b2c6ff), UINT64_C(0x1f42fc9094b2e6fe),
        UINT64_C(0x1f42fc503cad66ff), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005944), UINT64_C(0x1f42f7cefcb5c727), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f80ef0b1a712), UINT64_C(0x1f42fa4e84b58734)
    },
    {   UINT64_C(0x00000000000062f2), UINT64_C(0x1f42fb4ef4af8717), UINT64_C(0x1f42fb8ee8ae0716),
        UINT64_C(0x1f42f78e84b7a71c), UINT64_C(0x1f42fa501cb546f7)
    },
    {   UINT64_C(0x00000000000089f2), UINT64_C(0x1e32fd0f3cafc5fd), UINT64_C(0x1e32fd0f3cafc5fd),
        UINT64_C(0x0000000000000000), UINT64_C(0x1c32ee0d30aa667e)
    },
    {   UINT64_C(0x0000000000008045), UINT64_C(0x131af10fa0892754), UINT64_C(0x0de2f44f78738680),
        UINT64_C(0x131af10fa089272a), UINT64_C(0x0de2f44f78738656)
    },
    {   UINT64_C(0x00000000000089f3), UINT64_C(0x0a2af30c4c67270e), UINT64_C(0x1c32ee0d30aa667e),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062f4), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f54e9cb6c6e7),
        UINT64_C(0x1f42fb0fe8ac26f0), UINT64_C(0x1f42fa1010afa6f6)
    },
    {   UINT64_C(0x00000000000089f4), UINT64_C(0x2142f7cbd8bea6d0), UINT64_C(0x1362f5cf2c882600),
        UINT64_C(0x1362fa0f24860600), UINT64_C(0x156afa8fa08dc630)
    },
    {   UINT64_C(0x00000000000062f5), UINT64_C(0x1f42fa0eecb6471e), UINT64_C(0x1f42fd8f50b4a708),
        UINT64_C(0x1f42fd5028b0c706), UINT64_C(0x1f42f84ef8b1072a)
    },
    {   UINT64_C(0x00000000000089f5), UINT64_C(0x156afa8fa08dc630), UINT64_C(0x1fdaf80e60b7262e),
        UINT64_C(0x1fdafb8e60b8e62e), UINT64_C(0x2662f80e60d3062e)
    },
    {   UINT64_C(0x00000000000062f6), UINT64_C(0x1f42fa4f7cab0711), UINT64_C(0x1f42f98ff4b5470d),
        UINT64_C(0x1f42fb8f68b3a719), UINT64_C(0x1f42f54e7cb6471a)
    },
    {   UINT64_C(0x000000000000c740), UINT64_C(0x101af04fa07d65c3), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c741), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x109af30fa07e65b5)
    },
    {   UINT64_C(0x00000000000089f7), UINT64_C(0x1a8afa913ca2657b), UINT64_C(0x3132fbd084fc65aa),
        UINT64_C(0x3132fbd084fc65aa), UINT64_C(0x0fb3074cb470a69d)
    },
    {   UINT64_C(0x00000000000062f8), UINT64_C(0x1f42f70ff8b5c706), UINT64_C(0x1f42fd0fa0b4272d),
        UINT64_C(0x1f42fd8ef4ae6727), UINT64_C(0x1f42fa4f00ad4703)
    },
    {   UINT64_C(0x00000000000089f8), UINT64_C(0x18b2f94b1c9ba703), UINT64_C(0x17e2f94e44986635),
        UINT64_C(0x191af94e449d4635), UINT64_C(0x191af94e449d4635)
    },
    {   UINT64_C(0x00000000000062f9), UINT64_C(0x1f42fb4eb0b44728), UINT64_C(0x1f42fccf70ae4711),
        UINT64_C(0x1f42fc4e8cb2672f), UINT64_C(0x1f42fa8ff4b14715)
    },
    {   UINT64_C(0x00000000000089f9), UINT64_C(0x24f2f94d28cca67e), UINT64_C(0x24f2f94d28cca67e),
        UINT64_C(0x0fc31d0c4c7ac6b5), UINT64_C(0x0fc2f38c4c6606b5)
    },
    {   UINT64_C(0x000000000000c747), UINT64_C(0x12c2f20f548785b5), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000019149), UINT64_C(0x0f9afacc5c7825bc), UINT64_C(0x1082fa0c5c7a069f),
        UINT64_C(0x0c02f88f5868c69e), UINT64_C(0x0acaf90c5c65669f)
    },
    {   UINT64_C(0x00000000000062fb), UINT64_C(0x1f42fd10bcb4c6f7), UINT64_C(0x1f42f6cf98b1e6e7),
        UINT64_C(0x1f42fb4f38ab2712), UINT64_C(0x1f42f9502cb346f2)
    },
    {   UINT64_C(0x0000000000003bfc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x106b1256086dc66f)
    },
    {   UINT64_C(0x00000000000062fc), UINT64_C(0x1f42fa4f98b40715), UINT64_C(0x1f42f90ef8b14704),
        UINT64_C(0x1f42f84f28b5a72d), UINT64_C(0x1f42f94fb4b6a6df)
    },
    {   UINT64_C(0x0000000000003bfd), UINT64_C(0x0000000000000000), UINT64_C(0x106afc979878a667),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062fd), UINT64_C(0x1f42facfe0b60722), UINT64_C(0x1f42fd8f80ac66fb),
        UINT64_C(0x1f42fa8facb3c717), UINT64_C(0x1f42f48eccb1e71d)
    },
    {   UINT64_C(0x000000000001914c), UINT64_C(0x1032fa4f40792657), UINT64_C(0x0bb2f78f5868a678),
        UINT64_C(0x143afd0f5888a5c6), UINT64_C(0x101af9cf58788632)
    },
    {   UINT64_C(0x00000000000062fe), UINT64_C(0x1f42fa8f5caf270e), UINT64_C(0x1f42f7cf50b6a6d7),
        UINT64_C(0x1f42f78fecb0c710), UINT64_C(0x1f42fc8fa4ad8706)
    },
    {   UINT64_C(0x00000000000089fe), UINT64_C(0x3132fbceecfc660f), UINT64_C(0x3132fbceecfc660f),
        UINT64_C(0x3132fbcf78fc65ed), UINT64_C(0x3132fbd084fc65aa)
    },
    {   UINT64_C(0x00000000000062ff), UINT64_C(0x1f42f88f7cb7a6ea), UINT64_C(0x1f42f78ef8b34715),
        UINT64_C(0x1f42fb8f04b546e2), UINT64_C(0x1f42f6cf74aec701)
    },
    {   UINT64_C(0x00000000000089ff), UINT64_C(0x3132fbd084fc65aa), UINT64_C(0x3132fbceecfc660f),
        UINT64_C(0x3132fbceecfc660f), UINT64_C(0x3132fbd088fc65a9)
    },
    {   UINT64_C(0x0000000000006300), UINT64_C(0x1f42fb8fd8afe6f2), UINT64_C(0x1f42f78f28afa71b),
        UINT64_C(0x1f42f94f5cb44704), UINT64_C(0x1f42f90f3cac870a)
    },
    {   UINT64_C(0x0000000000005953), UINT64_C(0x1f42fc903cb42700), UINT64_C(0x1f42f58f4cb7c71c),
        UINT64_C(0x1f42f90fc4b62730), UINT64_C(0x1f42fc4f50b6a70f)
    },
    {   UINT64_C(0x0000000000006301), UINT64_C(0x1f42ff5000ae46ff), UINT64_C(0x1f42f78f28afe70f),
        UINT64_C(0x1f42f6cef4b0c72f), UINT64_C(0x1f42fa8e8caf070a)
    },
    {   UINT64_C(0x0000000000005954), UINT64_C(0x0000000000000000), UINT64_C(0x1f42facf34b786fc),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43029008b5e6fe)
    },
    {   UINT64_C(0x0000000000006302), UINT64_C(0x1f42fb8fc0b54710), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f7500cb0670a), UINT64_C(0x1f42f7cebcb4c72d)
    },
    {   UINT64_C(0x0000000000005955), UINT64_C(0x1f42fa0f78b6a700), UINT64_C(0x1f42fa8f28b8872e),
        UINT64_C(0x1f42ff8f54b7270e), UINT64_C(0x1f42f3cfbcb6a70f)
    },
    {   UINT64_C(0x0000000000006303), UINT64_C(0x1f42fa8fccaf0722), UINT64_C(0x1f42fecf08b4c728),
        UINT64_C(0x1f42fc4fa4b58711), UINT64_C(0x1f42f98eccb3472e)
    },
    {   UINT64_C(0x0000000000005956), UINT64_C(0x1f42f7cf4cb3a6f6), UINT64_C(0x1f42faceecb78736),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbd02cb1c705)
    },
    {   UINT64_C(0x0000000000006304), UINT64_C(0x1f42fa0ef0b3a71a), UINT64_C(0x1f42f78f64ad4716),
        UINT64_C(0x1f42fb4f28ae66f4), UINT64_C(0x1f42fa4ee8ac6702)
    },
    {   UINT64_C(0x0000000000019153), UINT64_C(0x15d2fe4f688da67e), UINT64_C(0x11c2f10fa090267e),
        UINT64_C(0x1cc2f10fa0b5267e), UINT64_C(0x1802f6cfa09a267e)
    },
    {   UINT64_C(0x0000000000006305), UINT64_C(0x1f42fbcef8af66f6), UINT64_C(0x1f42fc8ea0b4e70e),
        UINT64_C(0x1f42fa8f4cb1a712), UINT64_C(0x1f42f88ed8b26715)
    },
    {   UINT64_C(0x0000000000005958), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fe8f38b5a728), UINT64_C(0x1f42face9cb70720)
    },
    {   UINT64_C(0x0000000000006306), UINT64_C(0x1f42fdcfa8b3a71c), UINT64_C(0x1f42fe8f3caf870b),
        UINT64_C(0x1f42f54ec0ae0739), UINT64_C(0x1f42fb8e8cb0e722)
    },
    {   UINT64_C(0x0000000000019155), UINT64_C(0x1042f94f7879e5b4), UINT64_C(0x11f2f94f787f6693),
        UINT64_C(0x105af94f787a45b4), UINT64_C(0x0b82f44fa0746693)
    },
    {   UINT64_C(0x0000000000006307), UINT64_C(0x1f42f40ff8b10708), UINT64_C(0x1f42fd8ff8acc712),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f98f8cb2c71f)
    },
    {   UINT64_C(0x000000000000595a), UINT64_C(0x1f42fa0fa8b7271e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f80ff4b806ea), UINT64_C(0x1f42ff8f4cb426fd)
    },
    {   UINT64_C(0x0000000000006308), UINT64_C(0x1f42f94f90b6a70e), UINT64_C(0x1f42fa8fa4b366dc),
        UINT64_C(0x1f42f98f14b30719), UINT64_C(0x1f42f94fa4b10700)
    },
    {   UINT64_C(0x000000000000595b), UINT64_C(0x1f43018f88b5c712), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43110f10b88701)
    },
    {   UINT64_C(0x0000000000006309), UINT64_C(0x1f42fc8ef8b24729), UINT64_C(0x1f42fccffcadc6fd),
        UINT64_C(0x1f42f78eb4b54724), UINT64_C(0x1f42fb9020b0c6d7)
    },
    {   UINT64_C(0x000000000000595c), UINT64_C(0x1f43034f70b6c709), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fecfa8b62715), UINT64_C(0x1f43028fa4b88728)
    },
    {   UINT64_C(0x000000000000630a), UINT64_C(0x1f42f7cf6caf472d), UINT64_C(0x1f42fa8ef8b326fc),
        UINT64_C(0x1f42fa8f04ab8716), UINT64_C(0x1f42f84f4ca98710)
    },
    {   UINT64_C(0x000000000000595d), UINT64_C(0x1f4308cef8b2c727), UINT64_C(0x1f43098f64b68706),
        UINT64_C(0x1f43034f1cb88703), UINT64_C(0x1f42f9cec8b8a719)
    },
    {   UINT64_C(0x000000000000630b), UINT64_C(0x1f42f5ce50b82712), UINT64_C(0x1f42fa8e7cb3c72a),
        UINT64_C(0x1f42f58f50b14702), UINT64_C(0x1f42fb8fb4b08707)
    },
    {   UINT64_C(0x000000000001915a), UINT64_C(0x1522f30fa09565aa), UINT64_C(0x1182f58fa080c5aa),
        UINT64_C(0x0ea2f30c387e45aa), UINT64_C(0x103af8cfa07a05aa)
    },
    {   UINT64_C(0x000000000000630c), UINT64_C(0x1f42fbcf4caca6fa), UINT64_C(0x1f42f70f30b4c72d),
        UINT64_C(0x1f42f8cf18a80712), UINT64_C(0x1f42f60f60b7a6f2)
    },
    {   UINT64_C(0x000000000001915b), UINT64_C(0x1ac2fa8f3ca326a5), UINT64_C(0x1a8afa8f54a1c6a5),
        UINT64_C(0x182afb8f5499e6a5), UINT64_C(0x1bdafb8f54a706a5)
    },
    {   UINT64_C(0x000000000000630d), UINT64_C(0x1f42f70f40b3c70d), UINT64_C(0x1f42f88eecad6729),
        UINT64_C(0x1f42f80ef4b1270e), UINT64_C(0x1f42f94fc8b8a6e9)
    },
    {   UINT64_C(0x000000000001915c), UINT64_C(0x18a2fb8f5499e6a5), UINT64_C(0x191afb8c6c9c06a5),
        UINT64_C(0x1a0afb8f54a026a5), UINT64_C(0x1a5af88c6ca1e6a5)
    },
    {   UINT64_C(0x000000000000630e), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb0f78afc712),
        UINT64_C(0x1f42f8cef4b626d6), UINT64_C(0x1f42f64f98b7c6d7)
    },
    {   UINT64_C(0x0000000000005961), UINT64_C(0x1f430a4eacac671c), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430f4fc8b1c71a)
    },
    {   UINT64_C(0x000000000000630f), UINT64_C(0x1f42f70f5cb386f1), UINT64_C(0x1f42f90f0cb7a6f2),
        UINT64_C(0x1f42fd4fd8b26702), UINT64_C(0x1f42fccf2cb9c720)
    },
    {   UINT64_C(0x000000000001915e), UINT64_C(0x236afa8f3cc5a6a5), UINT64_C(0x1af2fa8f3ca3c6a5),
        UINT64_C(0x1c6afb8f54a946a5), UINT64_C(0x1a92fa8c6ca1e6a5)
    },
    {   UINT64_C(0x0000000000006310), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f7cfe8b76712),
        UINT64_C(0x1f42f70e50b5c709), UINT64_C(0x1f42f68ef8b626d2)
    },
    {   UINT64_C(0x000000000001915f), UINT64_C(0x1d12fb8eb4af46a5), UINT64_C(0x1ba2fa8f3ca7a6a5),
        UINT64_C(0x1aa2fb8f54a2c6a5), UINT64_C(0x18cafb8f3c9b06a5)
    },
    {   UINT64_C(0x0000000000006311), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f5cf20b44702),
        UINT64_C(0x1f43085008b4e6f8), UINT64_C(0x1f430450c0b166d1)
    },
    {   UINT64_C(0x0000000000019160), UINT64_C(0x1ae2fb8f3ca3a6a5), UINT64_C(0x1abafa8f54a286a5),
        UINT64_C(0x230afa8f54c3c6a5), UINT64_C(0x199afa8f3c9f66a5)
    },
    {   UINT64_C(0x0000000000006312), UINT64_C(0x1f43088f10b1471b), UINT64_C(0x1f42fc8f9cb78706),
        UINT64_C(0x1f43170f30a88728), UINT64_C(0x1f43020f74b4c6f7)
    },
    {   UINT64_C(0x0000000000005965), UINT64_C(0x1f430a4fa4b6a6fd), UINT64_C(0x1f4301ceacad2701),
        UINT64_C(0x1f430e0ee4af2735), UINT64_C(0x1f43000e5cb30730)
    },
    {   UINT64_C(0x0000000000006313), UINT64_C(0x1f42fa4fc8b7c70a), UINT64_C(0x1f4301ce9cb48724),
        UINT64_C(0x1f43144ef4b1e701), UINT64_C(0x1f42fd8eacb58718)
    },
    {   UINT64_C(0x0000000000005966), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fcce7cb64730),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc4e4cb6e718)
    },
    {   UINT64_C(0x0000000000006314), UINT64_C(0x1f43108e98a9c744), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005967), UINT64_C(0x1f42f9ceb8b6c724), UINT64_C(0x1f430d4e5caf471b),
        UINT64_C(0x1f42fece7cb36715), UINT64_C(0x1f42f90e5cb66732)
    },
    {   UINT64_C(0x0000000000006315), UINT64_C(0x1f42fe4f48b6a716), UINT64_C(0x1f430f0f24b726fd),
        UINT64_C(0x1f43084eb0b786ec), UINT64_C(0x1f42f98f98b7a6b5)
    },
    {   UINT64_C(0x0000000000005968), UINT64_C(0x1f42f98e98b60720), UINT64_C(0x1f42fb8e7cb92731),
        UINT64_C(0x1f42face6cb7070c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006316), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f64f20b7a6da), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005969), UINT64_C(0x1f43084e1cabc728), UINT64_C(0x1f43054e8ca9a72e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43054e6cb3a724)
    },
    {   UINT64_C(0x0000000000006317), UINT64_C(0x1f42fdcf48b4e6d5), UINT64_C(0x1f42fdcfacb306d9),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fecf0cb40715)
    },
    {   UINT64_C(0x000000000000596a), UINT64_C(0x1f43048ec8b0c6e0), UINT64_C(0x1f43010eb8b3271e),
        UINT64_C(0x1f43020eacb3c6f8), UINT64_C(0x1f42f4ceacb12733)
    },
    {   UINT64_C(0x0000000000006318), UINT64_C(0x0000000000000000), UINT64_C(0x1f43160e88b44727),
        UINT64_C(0x1f42ffce5cb92748), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000596b), UINT64_C(0x1f42fc8e4cb38726), UINT64_C(0x1f43080ef8b38708),
        UINT64_C(0x1f42fece9cb3a70d), UINT64_C(0x1f42f7ced8b2a71d)
    },
    {   UINT64_C(0x0000000000006319), UINT64_C(0x1f43004f58b546c7), UINT64_C(0x1f43004f70ab26f3),
        UINT64_C(0x1f43044e94b14723), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000019168), UINT64_C(0x14d2f5cfa08de68a), UINT64_C(0x12e3008fa082e67e),
        UINT64_C(0x14faf4cf688e268c), UINT64_C(0x15a3008fa090867e)
    },
    {   UINT64_C(0x000000000000631a), UINT64_C(0x1f42fe8e7cab271c), UINT64_C(0x1f42fe8f8cb8a6ec),
        UINT64_C(0x1f43100e48b80736), UINT64_C(0x1f42fa4e80b58732)
    },
    {   UINT64_C(0x000000000000596d), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fe4ea4b2e6dc), UINT64_C(0x1f43024e5cb6671b)
    },
    {   UINT64_C(0x000000000000631b), UINT64_C(0x1f42facf30b2270d), UINT64_C(0x1f42f78f4cb786d1),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43038f24b00702)
    },
    {   UINT64_C(0x000000000001916a), UINT64_C(0x0c8af94fa06b067e), UINT64_C(0x0c72f10f6864a67e),
        UINT64_C(0x13d3008fa08d467e), UINT64_C(0x117b008fa082c67e)
    },
    {   UINT64_C(0x000000000000631c), UINT64_C(0x1f43060f10b666fb), UINT64_C(0x1f42fd8f40b526c5),
        UINT64_C(0x1f43038f58b2a6c1), UINT64_C(0x1f43004fa4b146e4)
    },
    {   UINT64_C(0x000000000000596f), UINT64_C(0x1f42f68f50b92707), UINT64_C(0x1f42fb0ff0b6c70c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f78eacb506fb)
    },
    {   UINT64_C(0x000000000000631d), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f5cf48b6a6dd),
        UINT64_C(0x1f43054ec4b08710), UINT64_C(0x1f43038f50b2270e)
    },
    {   UINT64_C(0x000000000001916c), UINT64_C(0x1662f58ce494e68c), UINT64_C(0x126b008fa087267e),
        UINT64_C(0x10eaf60f687aa68c), UINT64_C(0x1302f1cfa088a67e)
    },
    {   UINT64_C(0x000000000000631e), UINT64_C(0x1f43190e949e8736), UINT64_C(0x1f43094f40ade71d),
        UINT64_C(0x1f42fe8ed4afa715), UINT64_C(0x1f4300cee8b126fc)
    },
    {   UINT64_C(0x000000000001916d), UINT64_C(0x14aaff4f6888867e), UINT64_C(0x1472f5cf748c667e),
        UINT64_C(0x1ccaf54f74ae067e), UINT64_C(0x15e2f5cfa092267e)
    },
    {   UINT64_C(0x000000000000631f), UINT64_C(0x1f42fe4f6cb346dd), UINT64_C(0x1f4302cf64ae26fc),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005972), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42facf88b5070b)
    },
    {   UINT64_C(0x0000000000006320), UINT64_C(0x1f43024f38ae6709), UINT64_C(0x1f42fd8f58b446ff),
        UINT64_C(0x1f42fccf2caa26f5), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001916f), UINT64_C(0x0e42f3cf787485b7), UINT64_C(0x0f72f50f74752694),
        UINT64_C(0x0de2f3cf787405b7), UINT64_C(0x0a82f30fa06ca693)
    },
    {   UINT64_C(0x0000000000006321), UINT64_C(0x1f4300cef4b16701), UINT64_C(0x1f42ff8f70b8a703),
        UINT64_C(0x1f4300cf04b1e6e3), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000019170), UINT64_C(0x0f82f34c4078e5b7), UINT64_C(0x0f3afdcfa0738694),
        UINT64_C(0x06e2fe0fa052068f), UINT64_C(0x07f2db8c4055a68f)
    },
    {   UINT64_C(0x0000000000006322), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0f24b4e711),
        UINT64_C(0x1f42fb8f34ae8710), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000019171), UINT64_C(0x0e2afdcfa0770694), UINT64_C(0x066afd4fa0508694),
        UINT64_C(0x17a2fe4fa094e5b8), UINT64_C(0x0f3afdcfa07385b8)
    },
    {   UINT64_C(0x0000000000006323), UINT64_C(0x1f43000f6cb72705), UINT64_C(0x1f42fe0f3cb2e6fa),
        UINT64_C(0x1f42f94f74b5e6f9), UINT64_C(0x1f43058ec8b7e720)
    },
    {   UINT64_C(0x0000000000019172), UINT64_C(0x0f9af50f787965b7), UINT64_C(0x0f92fecc407945b8),
        UINT64_C(0x0f92f50c4074e5b8), UINT64_C(0x0a82fdcfa06785b8)
    },
    {   UINT64_C(0x0000000000006324), UINT64_C(0x1f42fe8ec0b866f3), UINT64_C(0x1f43008f6cb626dd),
        UINT64_C(0x1f42fbced4b166ee), UINT64_C(0x1f42fd8f1cb166fb)
    },
    {   UINT64_C(0x0000000000005977), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f58e74b486fb),
        UINT64_C(0x1f42f58e98b406f0), UINT64_C(0x1f42f60ed0b78733)
    },
    {   UINT64_C(0x0000000000006325), UINT64_C(0x1f43010f80b74706), UINT64_C(0x1f4303cf50b1670c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fecea8b5c720)
    },
    {   UINT64_C(0x0000000000019174), UINT64_C(0x15f2f50f6892e5ad), UINT64_C(0x0f12f58fa07705ad),
        UINT64_C(0x0f22f50c407725ad), UINT64_C(0x0dfaf44fa072a5ad)
    },
    {   UINT64_C(0x0000000000018c0c), UINT64_C(0x2c22f95114e96589), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c7a0), UINT64_C(0x1f42f2cf64b92783), UINT64_C(0x1692f3cf6896e6b1),
        UINT64_C(0x1f42f2cf64b92783), UINT64_C(0x1692f3cf6896e6b1)
    },
    {   UINT64_C(0x000000000000c7a1), UINT64_C(0x1f42f2cf64b92754), UINT64_C(0x1692f3cf6896e682),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000019176), UINT64_C(0x13db020fa089268c), UINT64_C(0x1233020fa085c68c),
        UINT64_C(0x1752f74f5492669b), UINT64_C(0x165b020fa08de68c)
    },
    {   UINT64_C(0x0000000000006328), UINT64_C(0x1f4317ce7c9d0741), UINT64_C(0x1f42ff8f1cb20718),
        UINT64_C(0x1f430b4ee0b20722), UINT64_C(0x1f431cce7cad071e)
    },
    {   UINT64_C(0x0000000000019177), UINT64_C(0x0dc2fe4fa06d668c), UINT64_C(0x0f0af1ce2071468c),
        UINT64_C(0x1643020fa096e68c), UINT64_C(0x12db020fa087e68c)
    },
    {   UINT64_C(0x0000000000006329), UINT64_C(0x1f42f88fdcaec6e6), UINT64_C(0x1f42fc8f98b50702),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43144ed0b4673c)
    },
    {   UINT64_C(0x0000000000019178), UINT64_C(0x1c8b020fa0a6a68c), UINT64_C(0x16a3020f588f068c),
        UINT64_C(0x1852f6cf589b669c), UINT64_C(0x122b020fa085a68c)
    },
    {   UINT64_C(0x000000000000632a), UINT64_C(0x1f43034e90b32739), UINT64_C(0x1f42f68f90b766d0),
        UINT64_C(0x1f4309ce7cb6a747), UINT64_C(0x1f43028e70b3c728)
    },
    {   UINT64_C(0x0000000000019179), UINT64_C(0x185af6cce09cc69b), UINT64_C(0x14f3020fa090a68c),
        UINT64_C(0x1152f6cf547e669b), UINT64_C(0x140af18fa08ce68c)
    },
    {   UINT64_C(0x000000000000632b), UINT64_C(0x1f430e4e60b4e735), UINT64_C(0x1f43040e54b0871d),
        UINT64_C(0x1f43040e90b08729), UINT64_C(0x1f42f4cf04b7c728)
    },
    {   UINT64_C(0x000000000001917a), UINT64_C(0x15db00cf548c868c), UINT64_C(0x1592f44f5891a68c),
        UINT64_C(0x1f2af58f64b7668c), UINT64_C(0x1722f80fa096068c)
    },
    {   UINT64_C(0x000000000000632c), UINT64_C(0x1f43058e40b06749), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430a4e84af073d), UINT64_C(0x1f43058e40b5e74e)
    },
    {   UINT64_C(0x000000000001917b), UINT64_C(0x15b2f30fa092c68c), UINT64_C(0x146af44fa08c668c),
        UINT64_C(0x0f4af3cf687405c1), UINT64_C(0x1002fbcf6c7b668c)
    },
    {   UINT64_C(0x000000000000632d), UINT64_C(0x1f43028e40b4e73b), UINT64_C(0x1f42ffcee0b56733),
        UINT64_C(0x1f42f3106cb76702), UINT64_C(0x1f431bcecca7a730)
    },
    {   UINT64_C(0x000000000001917c), UINT64_C(0x0e72f44f6875c5c1), UINT64_C(0x1032f44f6878668c),
        UINT64_C(0x0e22f44f6c74a5c1), UINT64_C(0x0aa2f18fa06d469b)
    },
    {   UINT64_C(0x000000000000632e), UINT64_C(0x1f43050e4cb4e741), UINT64_C(0x1f42f7cf80b34700),
        UINT64_C(0x1f42f78fa0b6c6c2), UINT64_C(0x1f431bce4cb1c74f)
    },
    {   UINT64_C(0x000000000001917d), UINT64_C(0x0fc2f50c687bc5c0), UINT64_C(0x0ff2fbcfa077668c),
        UINT64_C(0x07aafa8fa056e698), UINT64_C(0x0a22dfcc74602698)
    },
    {   UINT64_C(0x000000000000632f), UINT64_C(0x1f42fc8fccae4706), UINT64_C(0x1f42fc900cb0a709),
        UINT64_C(0x1f43024fe0b106c6), UINT64_C(0x1f43174e9cab6738)
    },
    {   UINT64_C(0x0000000000005982), UINT64_C(0x1f4309cf38ac4703), UINT64_C(0x1f43070f1cadc6db),
        UINT64_C(0x1f430a4e98b3c70c), UINT64_C(0x1f43058ec0b6e712)
    },
    {   UINT64_C(0x0000000000006330), UINT64_C(0x1f43050e4cad8741), UINT64_C(0x1f42ff8e70b46749),
        UINT64_C(0x1f42f68f6cb76719), UINT64_C(0x1f43018e4cb0874a)
    },
    {   UINT64_C(0x000000000001917f), UINT64_C(0x0faaf44f687a05c1), UINT64_C(0x1002fbcc6c7b65c1),
        UINT64_C(0x1002f44c6c77a5c1), UINT64_C(0x0cdafbcfa07145c1)
    },
    {   UINT64_C(0x0000000000006331), UINT64_C(0x1f42f5cf0cb18731), UINT64_C(0x1f43014f54b0070a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43140ebcb84735)
    },
    {   UINT64_C(0x0000000000019180), UINT64_C(0x0c0af44f6c6b25c1), UINT64_C(0x0c12efcf706ce65e),
        UINT64_C(0x1032fbcf647865b5), UINT64_C(0x0e72f1cf687665b5)
    },
    {   UINT64_C(0x0000000000006332), UINT64_C(0x1f43198e80a58732), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f98f1cb76714), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000019181), UINT64_C(0x15eaf24f689405b5), UINT64_C(0x0fd2f30fa07b45b5),
        UINT64_C(0x0ec2f28c6c7765b5), UINT64_C(0x0dcaf34fa072a5b5)
    },
    {   UINT64_C(0x0000000000006333), UINT64_C(0x1f43184ea8a3a72a), UINT64_C(0x1f42f8cfa0b62715),
        UINT64_C(0x1f42f90e9cb60737), UINT64_C(0x1f43014fa8aba6e1)
    },
    {   UINT64_C(0x0000000000019182), UINT64_C(0x14d2f5cfa08de68a), UINT64_C(0x12e3008fa08ea67e),
        UINT64_C(0x14fb060f689ce68c), UINT64_C(0x15a3008fa09c667e)
    },
    {   UINT64_C(0x0000000000006334), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f6ced8b746d1),
        UINT64_C(0x1f42f4cef0ba4722), UINT64_C(0x1f42f8ce80abc739)
    },
    {   UINT64_C(0x000000000000c7bc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1692f1cfa095e783), UINT64_C(0x0fa2f20c6c7ac6b1)
    },
    {   UINT64_C(0x0000000000006335), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f78ed8ab4708),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f68e88af8725)
    },
    {   UINT64_C(0x0000000000019184), UINT64_C(0x0c8afccfa07e867e), UINT64_C(0x0c72f38f6879467e),
        UINT64_C(0x13d3008fa099a67e), UINT64_C(0x117b008fa085067e)
    },
    {   UINT64_C(0x0000000000006336), UINT64_C(0x0000000000000000), UINT64_C(0x1f43024f70a9a6e6),
        UINT64_C(0x1f43038e68b6c72c), UINT64_C(0x1f42fe0e48b3874e)
    },
    {   UINT64_C(0x0000000000019185), UINT64_C(0x1a5b00cfa0b3267e), UINT64_C(0x151b008f689e467e),
        UINT64_C(0x165306cf689fe68c), UINT64_C(0x106b008fa08e467e)
    },
    {   UINT64_C(0x0000000000006337), UINT64_C(0x1f42f68f00b4a71e), UINT64_C(0x1f42f8ceecb446ba),
        UINT64_C(0x1f43100e80b16749), UINT64_C(0x1f42fe8fc0b6271b)
    },
    {   UINT64_C(0x0000000000019186), UINT64_C(0x166306cce49fe68c), UINT64_C(0x126b008fa08e667e),
        UINT64_C(0x10eafd8f6889268c), UINT64_C(0x1303164fa09c067e)
    },
    {   UINT64_C(0x0000000000006338), UINT64_C(0x1f42f4cfb8b5e715), UINT64_C(0x1f42f68e90b34733),
        UINT64_C(0x1f4318ce6cb3671d), UINT64_C(0x1f43160e70aaa745)
    },
    {   UINT64_C(0x0000000000019187), UINT64_C(0x14ab0b4f689d267e), UINT64_C(0x14731f0f74a1067e),
        UINT64_C(0x1ccb1e8f74c2a67e), UINT64_C(0x15e2f5cfa0a3467e)
    },
    {   UINT64_C(0x0000000000006339), UINT64_C(0x1f42fc8ee0b5c70e), UINT64_C(0x1f42f98e5cb0e716),
        UINT64_C(0x1f42f9cf0cb6a720), UINT64_C(0x1f42f88f30b6c6f3)
    },
    {   UINT64_C(0x0000000000019188), UINT64_C(0x13b31c8fa09f467e), UINT64_C(0x13eaf50fa09de67e),
        UINT64_C(0x0e02fbcf7878e5b7), UINT64_C(0x0f83008f78816694)
    },
    {   UINT64_C(0x000000000000633a), UINT64_C(0x1f431a0e6ca8c73a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430b0e6cace742), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000598d), UINT64_C(0x1f43148e7ca2c700), UINT64_C(0x1f43069018b206c8),
        UINT64_C(0x1f42f70f60b02710), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000633b), UINT64_C(0x1f42f6cf84b786f2), UINT64_C(0x1f42fa8f50b86725),
        UINT64_C(0x1f430f0e30b16726), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001918a), UINT64_C(0x0f82ec4c408665b7), UINT64_C(0x0f3afdcfa07e4694),
        UINT64_C(0x06e2ff4fa067268f), UINT64_C(0x07f2d08c406ac68f)
    },
    {   UINT64_C(0x000000000000633c), UINT64_C(0x1f42fc8f40b7a711), UINT64_C(0x1f42f88e7cb466e1),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cf14b186f0)
    },
    {   UINT64_C(0x000000000001918b), UINT64_C(0x0e2afdcfa0840694), UINT64_C(0x066afd4fa065a694),
        UINT64_C(0x17a2fe4fa09f65b8), UINT64_C(0x0f3afdcfa07e45b8)
    },
    {   UINT64_C(0x000000000000633d), UINT64_C(0x1f42fecf4cada70e), UINT64_C(0x1f42fa8ee0a986ca),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001918c), UINT64_C(0x0f9b010f788185b7), UINT64_C(0x0f92f18c4081c5b8),
        UINT64_C(0x0f93000c408325b8), UINT64_C(0x0a82fdcfa07565b8)
    },
    {   UINT64_C(0x000000000000633e), UINT64_C(0x1f42f74eb0b84742), UINT64_C(0x1f43000f88b606de),
        UINT64_C(0x1f42facebcb54742), UINT64_C(0x1f42f98e70b3871d)
    },
    {   UINT64_C(0x000000000001918d), UINT64_C(0x0c2afd4f787485b7), UINT64_C(0x091b060f786d862c),
        UINT64_C(0x0f5b044f748185ad), UINT64_C(0x0ed311cf6883e5ad)
    },
    {   UINT64_C(0x000000000000633f), UINT64_C(0x1f42fa8ec0b5472b), UINT64_C(0x1f43078e50b7a744),
        UINT64_C(0x1f43044ec0b1e71a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000003c40), UINT64_C(0x106af8cfa076259f), UINT64_C(0x106b018fa07a859f),
        UINT64_C(0x106b19ce546a449f), UINT64_C(0x106af68f747bc656)
    },
    {   UINT64_C(0x0000000000006340), UINT64_C(0x1f43164e3cb44733), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f5ce44b66731), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008a40), UINT64_C(0x1cf2fc1084ab65aa), UINT64_C(0x1cf2fbd084ab65aa),
        UINT64_C(0x1cf2fbceecab660f), UINT64_C(0x1cf2fbceecab660f)
    },
    {   UINT64_C(0x0000000000006341), UINT64_C(0x1f43048e30b3e73d), UINT64_C(0x1f42ff8e40afa742),
        UINT64_C(0x1f42f5cfccade6fd), UINT64_C(0x1f430b8eb0ac2731)
    },
    {   UINT64_C(0x0000000000008a41), UINT64_C(0x1cf2f30eecafc60f), UINT64_C(0x1cf2fbd084ab65aa),
        UINT64_C(0x1cf2fbceecab660f), UINT64_C(0x1cf2fbceecab660f)
    },
    {   UINT64_C(0x0000000000006342), UINT64_C(0x1f42fc8f3cb16737), UINT64_C(0x1f42f4ce9cb1c711),
        UINT64_C(0x1f4302ce98afe73d), UINT64_C(0x1f43098e48ada72a)
    },
    {   UINT64_C(0x0000000000003c43), UINT64_C(0x106b015710768650), UINT64_C(0x106b0a571c75064b),
        UINT64_C(0x106b03d71c71c64a), UINT64_C(0x106ae90fa07ac64b)
    },
    {   UINT64_C(0x0000000000006343), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cf00b16736),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8ed4b4c72e)
    },
    {   UINT64_C(0x0000000000008a43), UINT64_C(0x1cf2fbd084ab65a9), UINT64_C(0x1cf2fbd084ab65a9),
        UINT64_C(0x1cf2fbd084ab65a9), UINT64_C(0x1cf2fbd084ab65a9)
    },
    {   UINT64_C(0x0000000000006344), UINT64_C(0x1f42facf24b64720), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cf7cb4470f)
    },
    {   UINT64_C(0x0000000000008a44), UINT64_C(0x2c22fbd084e825a9), UINT64_C(0x1cf2fbd084aba5a9),
        UINT64_C(0x0ffafccd3077067e), UINT64_C(0x0ffafccd3077067e)
    },
    {   UINT64_C(0x0000000000006345), UINT64_C(0x1f43084eb0a5a743), UINT64_C(0x1f42f98e80af2739),
        UINT64_C(0x1f42fb8e60af8736), UINT64_C(0x1f42fc4eb0a98737)
    },
    {   UINT64_C(0x0000000000003c46), UINT64_C(0x106af78f68798676), UINT64_C(0x106afc0f8077c66c),
        UINT64_C(0x106ae94c147dc64b), UINT64_C(0x106aebcc147de596)
    },
    {   UINT64_C(0x0000000000006346), UINT64_C(0x0000000000000000), UINT64_C(0x1f430bce40b0a72d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbce70b5e73d)
    },
    {   UINT64_C(0x0000000000003c47), UINT64_C(0x106af2cd087dc64b), UINT64_C(0x106af24d087ea64b),
        UINT64_C(0x106af44d087a864b), UINT64_C(0x106afc0d74790656)
    },
    {   UINT64_C(0x0000000000006347), UINT64_C(0x0000000000000000), UINT64_C(0x1f431e0f24a166f4),
        UINT64_C(0x1f43240ee09ee734), UINT64_C(0x1f43210f049cc72e)
    },
    {   UINT64_C(0x0000000000003c48), UINT64_C(0x106af0cf807ea64b), UINT64_C(0x106af28d787ee596),
        UINT64_C(0x106af08d787fc596), UINT64_C(0x106af0ca147b859c)
    },
    {   UINT64_C(0x0000000000006348), UINT64_C(0x0000000000000000), UINT64_C(0x1f43098ee0af8712),
        UINT64_C(0x1f43084f0caea708), UINT64_C(0x1f430a8e90af6721)
    },
    {   UINT64_C(0x0000000000003c49), UINT64_C(0x106af80c2881a59d), UINT64_C(0x106af20f907e0597),
        UINT64_C(0x106aec0d087ae64b), UINT64_C(0x106af14f747b0656)
    },
    {   UINT64_C(0x0000000000006349), UINT64_C(0x1f43220f24b06704), UINT64_C(0x1f43064fe8b44703),
        UINT64_C(0x1f43028f3cb6a6d6), UINT64_C(0x1f43054ec0ae472a)
    },
    {   UINT64_C(0x0000000000003c4a), UINT64_C(0x106af38d787e6596), UINT64_C(0x106af68f8c78a59f),
        UINT64_C(0x106af24c147de64b), UINT64_C(0x106af44c147a864b)
    },
    {   UINT64_C(0x000000000000634a), UINT64_C(0x1f43064edc9fa714), UINT64_C(0x1f43009020b6e6e1),
        UINT64_C(0x1f43060ee4b50737), UINT64_C(0x1f43144edcb4672d)
    },
    {   UINT64_C(0x000000000000520d), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa4f00b54720)
    },
    {   UINT64_C(0x000000000000634b), UINT64_C(0x1f42ff903cb546e1), UINT64_C(0x1f43084f60ace716),
        UINT64_C(0x1f4305502cb126db), UINT64_C(0x1f430c4edcaee707)
    },
    {   UINT64_C(0x0000000000003c4c), UINT64_C(0x106af4ccfc7ca673), UINT64_C(0x106af30cfc7d6667),
        UINT64_C(0x106af5ccfc7c0672), UINT64_C(0x106af4cfa07ca673)
    },
    {   UINT64_C(0x000000000000634c), UINT64_C(0x1f43084eacaf2727), UINT64_C(0x1f43044ea4b30723),
        UINT64_C(0x1f430f4e98b0072a), UINT64_C(0x1f43100ea8aa8723)
    },
    {   UINT64_C(0x0000000000003c4d), UINT64_C(0x106ade4fa06ec6f6), UINT64_C(0x106af8cf8c80459c),
        UINT64_C(0x106ae34f8c6fc666), UINT64_C(0x106aedcab88043e7)
    },
    {   UINT64_C(0x000000000000634d), UINT64_C(0x1f43054fd8ae4706), UINT64_C(0x1f43058e88b2872c),
        UINT64_C(0x1f43029024b7c6b3), UINT64_C(0x1f43054e6cac072d)
    },
    {   UINT64_C(0x0000000000008a4d), UINT64_C(0x1cf3114fa0a2261a), UINT64_C(0x1cf3114fa0a2261a),
        UINT64_C(0x188303cd148fa5d5), UINT64_C(0x18830fcd1495a5d5)
    },
    {   UINT64_C(0x000000000000634e), UINT64_C(0x1f431dcf04a8c728), UINT64_C(0x1f43164e88a9a72c),
        UINT64_C(0x1f430dced4a80727), UINT64_C(0x1f43055028ada6eb)
    },
    {   UINT64_C(0x0000000000008a4e), UINT64_C(0x0ffaff8d3c726679), UINT64_C(0x0ffb060d3c75a679),
        UINT64_C(0x1cf2ff50d8aac58f), UINT64_C(0x1cf2fd10d8a9a58f)
    },
    {   UINT64_C(0x000000000000634f), UINT64_C(0x1f43028f28b56703), UINT64_C(0x1f430e8e88ab671d),
        UINT64_C(0x1f431b8ec8a5671a), UINT64_C(0x1f43028f50b02724)
    },
    {   UINT64_C(0x0000000000003c50), UINT64_C(0x106af80c147f85a1), UINT64_C(0x106b1e971471664a),
        UINT64_C(0x106b0b171467a64a), UINT64_C(0x106b06cfa06b850e)
    },
    {   UINT64_C(0x0000000000006350), UINT64_C(0x1f43120eb8ac6717), UINT64_C(0x1f43064edcaba71b),
        UINT64_C(0x1f43038f6cb7c70a), UINT64_C(0x1f43038fa0b16703)
    },
    {   UINT64_C(0x00000000000059a3), UINT64_C(0x1f42ff4f7cbb2719), UINT64_C(0x1f4302ceacac4700),
        UINT64_C(0x1f42fa0f80b58716), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006351), UINT64_C(0x1f43204ef8b12724), UINT64_C(0x1f43044f54ae870a),
        UINT64_C(0x1f4302902cb726cf), UINT64_C(0x1f43018fc0b4470c)
    },
    {   UINT64_C(0x0000000000008a51), UINT64_C(0x1cf2fbce30ab663e), UINT64_C(0x1cf2fbce8cab65a9),
        UINT64_C(0x1cf2fbce8cab65a9), UINT64_C(0x1cf2fbd084ab65a9)
    },
    {   UINT64_C(0x0000000000006352), UINT64_C(0x1f42ff905cb686eb), UINT64_C(0x1f4305cee8b7c723),
        UINT64_C(0x1f42facf48b80706), UINT64_C(0x1f43038f0cb6a720)
    },
    {   UINT64_C(0x0000000000008a52), UINT64_C(0x1cf2f79084ad85a9), UINT64_C(0x0ffafd0d3876e67e),
        UINT64_C(0x1cf2f790acad859f), UINT64_C(0x1cf2f790acad859f)
    },
    {   UINT64_C(0x0000000000006353), UINT64_C(0x1f43018f5cb10702), UINT64_C(0x1f430e0edcb28726),
        UINT64_C(0x1f43034f8cae6712), UINT64_C(0x1f43140ea0ab0739)
    },
    {   UINT64_C(0x0000000000008a53), UINT64_C(0x0ffaff4d3075a67e), UINT64_C(0x0ffaff4d3075a67e),
        UINT64_C(0x1cf2f79310ad859f), UINT64_C(0x0ffb258d3075a67e)
    },
    {   UINT64_C(0x0000000000006354), UINT64_C(0x1f43028f34afe702), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f68eb8b4c733)
    },
    {   UINT64_C(0x000000000000038f), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x106af38e547ac69e)
    },
    {   UINT64_C(0x00000000000080a7), UINT64_C(0x11e2f34fa08485b8), UINT64_C(0x0c1ae84bfc720693),
        UINT64_C(0x103aee4bfc7ce5aa), UINT64_C(0x0eb2f34fa075a5b8)
    },
    {   UINT64_C(0x0000000000008a55), UINT64_C(0x0ffafd0d3076e67e), UINT64_C(0x0ffafd0d3076e67e),
        UINT64_C(0x1cf2fbd088ab65a8), UINT64_C(0x1cf2fbd088ab65a8)
    },
    {   UINT64_C(0x0000000000006356), UINT64_C(0x1f4308ce9cb36729), UINT64_C(0x1f43064eb4b16725),
        UINT64_C(0x1f43018f30b3c73d), UINT64_C(0x1f43074eb0b7a73e)
    },
    {   UINT64_C(0x0000000000008a56), UINT64_C(0x0ffafd0d3076e67e), UINT64_C(0x0ffafd0d3076e67e),
        UINT64_C(0x1cf2fbd088ab65a8), UINT64_C(0x1cf2fbd088ab65a8)
    },
    {   UINT64_C(0x0000000000006357), UINT64_C(0x1f43070f1cae071a), UINT64_C(0x1f42fb8e98a42716),
        UINT64_C(0x1f430e8f1cad872d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008a57), UINT64_C(0x0ffafd0d3076e67e), UINT64_C(0x0ffafd0d3076e67e),
        UINT64_C(0x1cf2fbd088ab65a8), UINT64_C(0x1cf2fbd088ab65a8)
    },
    {   UINT64_C(0x0000000000006358), UINT64_C(0x1f43064f50b02723), UINT64_C(0x1f43018f1cae6736),
        UINT64_C(0x1f42fa8ef4b5072e), UINT64_C(0x1f4302cee0b38727)
    },
    {   UINT64_C(0x000000000000c804), UINT64_C(0x0a6af9124c626507), UINT64_C(0x0a6af9124c626507),
        UINT64_C(0x0fa2ee124c7d0507), UINT64_C(0x0fa2ee12747d04f7)
    },
    {   UINT64_C(0x0000000000006359), UINT64_C(0x1f43084ea8b28739), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fccfacb78720), UINT64_C(0x1f42facfe4b88711)
    },
    {   UINT64_C(0x000000ee9d78c806), UINT64_C(0x0a6aff95305e469b), UINT64_C(0x0a6b01d5305f669b),
        UINT64_C(0x0a6b01ccd05f6483), UINT64_C(0x0a6b01d5305f669b)
    },
    {   UINT64_C(0x000000000000635a), UINT64_C(0x1f42ffcf6caf86f6), UINT64_C(0x1f42ffcf6cb466f6),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc8ef8b32734)
    },
    {   UINT64_C(0x0000000000003c5b), UINT64_C(0x106b084c10786597), UINT64_C(0x106b074c10732406),
        UINT64_C(0x106b278c1079c460), UINT64_C(0x106afa4c10634460)
    },
    {   UINT64_C(0x000000000000635b), UINT64_C(0x1f43064ee0af26eb), UINT64_C(0x1f42ff8f7cb02712),
        UINT64_C(0x1f42f6cfc8b84712), UINT64_C(0x1f42ffcf1cb366fc)
    },
    {   UINT64_C(0x0000000000003c5c), UINT64_C(0x106afe8c10676460), UINT64_C(0x106b0e96586fe646),
        UINT64_C(0x106af656c47bc70f), UINT64_C(0x106afccfa078a64b)
    },
    {   UINT64_C(0x000000000000635c), UINT64_C(0x1f43040ee8b66729), UINT64_C(0x1f42fb0e1cb52729),
        UINT64_C(0x1f42f74f1cb10711), UINT64_C(0x1f42f54f14b4e6f9)
    },
    {   UINT64_C(0x000000000000c80c), UINT64_C(0x22b2fd4f2cc1a6aa), UINT64_C(0x2e02fd4f2ceee6aa),
        UINT64_C(0x09b300d6785be6b1), UINT64_C(0x0e9b00d6786f86b1)
    },
    {   UINT64_C(0x000000000000635d), UINT64_C(0x1f42f9cf60b4e71a), UINT64_C(0x1f42f80ee8ae8715),
        UINT64_C(0x1f43000f28b1070a), UINT64_C(0x1f42f94f64b6671d)
    },
    {   UINT64_C(0x0007d0000000c80e), UINT64_C(0x124304ccf87ca45d), UINT64_C(0x0a6afad03064a587),
        UINT64_C(0x0a6af5103061c587), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000635e), UINT64_C(0x1f43000f44b1870a), UINT64_C(0x1f42f94f08b30709),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb0f1cafe715)
    },
    {   UINT64_C(0x0000000000003c5f), UINT64_C(0x106aec8f8c7fa64b), UINT64_C(0x106aec0bfc79859c),
        UINT64_C(0x106aec0c1079859c), UINT64_C(0x106aec0c1479a59c)
    },
    {   UINT64_C(0x000000000000c811), UINT64_C(0x05bac40f7069a698), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1d9afc4f6cae0699)
    },
    {   UINT64_C(0x0000000000003c60), UINT64_C(0x106af0cc1486a651), UINT64_C(0x106af14c1476a64b),
        UINT64_C(0x106b0bcc1476264b), UINT64_C(0x106af8cc107a8613)
    },
    {   UINT64_C(0x0000000000006360), UINT64_C(0x1f4300cf04ae470a), UINT64_C(0x1f42f7cf20b76711),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c814), UINT64_C(0x0000000000000000), UINT64_C(0x0fa2fc0c807686aa),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c815), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x187b00d6789706b1)
    },
    {   UINT64_C(0x0000000000003c62), UINT64_C(0x106af3cf307d059c), UINT64_C(0x106aeb0c147c259c),
        UINT64_C(0x106af48f8c798612), UINT64_C(0x106afd8b8878459c)
    },
    {   UINT64_C(0x0000000000006362), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90ef0ae06f2),
        UINT64_C(0x1f42f94f20b8e716), UINT64_C(0x1f42f74eecaf871a)
    },
    {   UINT64_C(0x0000000000008a62), UINT64_C(0x0ffb120c487006b7), UINT64_C(0x0ffb070c4c6a86b7),
        UINT64_C(0x0ffb15cc4c71e6b7), UINT64_C(0x0eab1d0c4c7666b7)
    },
    {   UINT64_C(0x0000000000006363), UINT64_C(0x1f42f94e94b646fe), UINT64_C(0x1f42fa4e94b6c6fe),
        UINT64_C(0x1f42fc0ea0b72702), UINT64_C(0x1f42fb8ee0b186fa)
    },
    {   UINT64_C(0x0000000000008a63), UINT64_C(0x0eaaf38c4c61a6b7), UINT64_C(0x0eab1d0c4c7666b7),
        UINT64_C(0x0eaaf38c4c61a6b7), UINT64_C(0x0eab1d0c4c7666b7)
    },
    {   UINT64_C(0x0000000000006364), UINT64_C(0x1f42fa0f00ada6f2), UINT64_C(0x1f42fcce78b6c706),
        UINT64_C(0x1f42fd0f00b446f6), UINT64_C(0x1f42fe4ed8b446f3)
    },
    {   UINT64_C(0x0000000000003c65), UINT64_C(0x106af0cb8c7b864b), UINT64_C(0x106af0cc287b864b),
        UINT64_C(0x106ae44c147ba64b), UINT64_C(0x106afc8fa078c651)
    },
    {   UINT64_C(0x0000000000006365), UINT64_C(0x1f42fc0eecb106f6), UINT64_C(0x1f42fb4f48b4671d),
        UINT64_C(0x1f42f74ef4af86ee), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000003c66), UINT64_C(0x106afc8fa078c651), UINT64_C(0x106b0ecfa077e651),
        UINT64_C(0x106af74f7c7b2596), UINT64_C(0x106af64f807ba59f)
    },
    {   UINT64_C(0x0000000000006366), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0f64b66724),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f94ee4b64711)
    },
    {   UINT64_C(0x0000000000008a66), UINT64_C(0x0f42f38c4c6406b7), UINT64_C(0x069afa8d3452a67d),
        UINT64_C(0x0ffb1a4d3068467e), UINT64_C(0x156af88e8091460b)
    },
    {   UINT64_C(0x0000000000006367), UINT64_C(0x1f42f7cef4b66711), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f7ceecb28701)
    },
    {   UINT64_C(0x0000000000008a67), UINT64_C(0x156afa8fa08dc630), UINT64_C(0x156afa8fa08dc630),
        UINT64_C(0x156af0cfa092e60b), UINT64_C(0x156af40fa08ee574)
    },
    {   UINT64_C(0x0000000000006368), UINT64_C(0x1f42f94f0cb34706), UINT64_C(0x1f42f94eecb56711),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f74f34b10719)
    },
    {   UINT64_C(0x0000000000008a68), UINT64_C(0x156afc4f6c9045ed), UINT64_C(0x156b014fd08a6649),
        UINT64_C(0x156af88fa091460b), UINT64_C(0x156af88fa091460b)
    },
    {   UINT64_C(0x0000000000006369), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa4ec8b40712),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f94ef8b2a70d)
    },
    {   UINT64_C(0x0000000000008a69), UINT64_C(0x156af3cc808ee60b), UINT64_C(0x156af88c8091460b),
        UINT64_C(0x1c22f80fa0aa060b), UINT64_C(0x1c22f80fa0aa060b)
    },
    {   UINT64_C(0x000000000000636a), UINT64_C(0x1f42f34f60b38715), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f84f30afe713), UINT64_C(0x1f42fd0ed4b6c704)
    },
    {   UINT64_C(0x0000000000008a6a), UINT64_C(0x156af54e808fa626), UINT64_C(0x156af70e80908626),
        UINT64_C(0x156af54e908fa62a), UINT64_C(0x156af70e9090862a)
    },
    {   UINT64_C(0x000000000000636b), UINT64_C(0x1f42f64f18b28715), UINT64_C(0x1f42fa0ef4b166fe),
        UINT64_C(0x1f42fd0edcb5c709), UINT64_C(0x1f42f84ed0b4e706)
    },
    {   UINT64_C(0x0000000000008a6b), UINT64_C(0x1612f68eb893861a), UINT64_C(0x1612f48eb892861a),
        UINT64_C(0x1612f68eb893861a), UINT64_C(0x1622f48eb892861a)
    },
    {   UINT64_C(0x000000000000c82b), UINT64_C(0x0fa2f54f707a4688), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000003c6d), UINT64_C(0x106ace4b289006de), UINT64_C(0x106aba89a899e73e),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000636d), UINT64_C(0x1f42f65084b7a6b6), UINT64_C(0x1f43014ed8ab06f8),
        UINT64_C(0x1f43000ebcb186b4), UINT64_C(0x1f42ffcf84b66726)
    },
    {   UINT64_C(0x0000000000008a6d), UINT64_C(0x17d2fa8e64978728), UINT64_C(0x1c72f40dc4ad4657),
        UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x1a52fa8dc4a18657)
    },
    {   UINT64_C(0x000000000000636e), UINT64_C(0x1f43118ec0af2703), UINT64_C(0x1f4300cf84b3c6e1),
        UINT64_C(0x1f42f8cfc8b44713), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008a6e), UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x1a52fa8dc4a18657),
        UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x1a52fa8dc4a18657)
    },
    {   UINT64_C(0x000000000000636f), UINT64_C(0x1f4301cf38b066b8), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd50a4b5c6f8), UINT64_C(0x1f42fe0fecb806bb)
    },
    {   UINT64_C(0x0000000000008a6f), UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x1a52fa8cd4a1875a),
        UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x1a52fa8dc4a18657)
    },
    {   UINT64_C(0x0000000000006370), UINT64_C(0x0000000000000000), UINT64_C(0x1f43001030b5a6ba),
        UINT64_C(0x1f43014f9cb6870d), UINT64_C(0x1f43029088b726d8)
    },
    {   UINT64_C(0x000000000000c834), UINT64_C(0x0002789994404736), UINT64_C(0x0002789994404736),
        UINT64_C(0x0002a38d3022a67e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006371), UINT64_C(0x1f4300cfa0b3c6f0), UINT64_C(0x1f42fc0eacb086f3),
        UINT64_C(0x1f42ff1038ad86fa), UINT64_C(0x1f42fe1028b566ca)
    },
    {   UINT64_C(0x000000000000c836), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x00026e1804432682)
    },
    {   UINT64_C(0x000000000000c837), UINT64_C(0x00025158044f0682), UINT64_C(0x000231cba85e86e0),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c838), UINT64_C(0x0000000000000000), UINT64_C(0x00026d5790486736),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006373), UINT64_C(0x1f42f9cfd8b7a700), UINT64_C(0x1f42ff4fb8b36701),
        UINT64_C(0x1f42fecfc4ae46fa), UINT64_C(0x1f42fc4f70b32705)
    },
    {   UINT64_C(0x0000000000008a73), UINT64_C(0x23caf6cda4c94713), UINT64_C(0x246af1cda4ce4713),
        UINT64_C(0x1862ff8c9c9746a2), UINT64_C(0x1acafa0f3c9fa5fb)
    },
    {   UINT64_C(0x000000000000c83b), UINT64_C(0x00027889c4404342), UINT64_C(0x00027889c4404342),
        UINT64_C(0x00027389cc3dc3c5), UINT64_C(0x00027889cc4043c5)
    },
    {   UINT64_C(0x000000000000c83c), UINT64_C(0x00028dd81c302735), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006375), UINT64_C(0x0000000000000000), UINT64_C(0x1f43034f2cab46fd),
        UINT64_C(0x1f43019020ae06be), UINT64_C(0x1f42ff0f04b406f6)
    },
    {   UINT64_C(0x00000000000191c4), UINT64_C(0x0e62f58f7476259f), UINT64_C(0x14d2fa8cc48d65a1),
        UINT64_C(0x129af58c788f25a1), UINT64_C(0x14aaf58cc49765a1)
    },
    {   UINT64_C(0x0000000000006376), UINT64_C(0x1f43020f34ae8701), UINT64_C(0x1f43021090b3c6b1),
        UINT64_C(0x1f42f78f80b6c6bc), UINT64_C(0x1f42fa8f74b80715)
    },
    {   UINT64_C(0x000000000000c840), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x16baf94f5492869b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c841), UINT64_C(0x0000000000000000), UINT64_C(0x1b4af78f70a6e698),
        UINT64_C(0x0000000000000000), UINT64_C(0x15dafe4f5491469b)
    },
    {   UINT64_C(0x0000000000008a77), UINT64_C(0x1cf2ff8fa0a94596), UINT64_C(0x1cf2ff8fa0a94675),
        UINT64_C(0x1cf2ff8caca9469f), UINT64_C(0x23cafa913cc7657b)
    },
    {   UINT64_C(0x0000000000006378), UINT64_C(0x1f42fdcf2cb24704), UINT64_C(0x1f42fc4fa0b406fe),
        UINT64_C(0x1f42ffcf40a9a707), UINT64_C(0x1f42f6cf8cb7470e)
    },
    {   UINT64_C(0x000000000000c844), UINT64_C(0x0000000000000000), UINT64_C(0x18b2fb8f3c9a66a5),
        UINT64_C(0x0000000000000000), UINT64_C(0x0fa2f8cf688d86a3)
    },
    {   UINT64_C(0x0000000000006379), UINT64_C(0x1f42fecf04b746f8), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fece7cb72733), UINT64_C(0x1f42fbcf70b826d6)
    },
    {   UINT64_C(0x000000000000c846), UINT64_C(0x1a92fbcc34a54605), UINT64_C(0x15e300cfa092468c),
        UINT64_C(0x18eaf94ea09be69b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c847), UINT64_C(0x1ba2fa8f3ca7a6a5), UINT64_C(0x187b00cfa09d468c),
        UINT64_C(0x1692f48e0c99468c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c848), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f413dcb8a68c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c849), UINT64_C(0x184afb0fa099669b), UINT64_C(0x0e02f34c6c73868c),
        UINT64_C(0x17b2f6cfa098e69c), UINT64_C(0x17b2f6cf5898e68a)
    },
    {   UINT64_C(0x000000000000c84a), UINT64_C(0x179af90c949666a5), UINT64_C(0x09c2f04fa05d05c3),
        UINT64_C(0x0000000000000000), UINT64_C(0x1692f04fa094a780)
    },
    {   UINT64_C(0x000000000000c84b), UINT64_C(0x0000000000000000), UINT64_C(0x182afb8f5499e6a5),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c84c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1342fa0fa082c68c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c84d), UINT64_C(0x0000000000000000), UINT64_C(0x17f3010f1894c69e),
        UINT64_C(0x15fafd0f1890e69e), UINT64_C(0x1192ffcf187c269e)
    },
    {   UINT64_C(0x000000000000c84e), UINT64_C(0x12baf80f1884669e), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c84f), UINT64_C(0x1922fbcf749d65b5), UINT64_C(0x1432f3cc748c85ce),
        UINT64_C(0x0f8b00cfa08ee68c), UINT64_C(0x180300cfa095268c)
    },
    {   UINT64_C(0x000000000000c850), UINT64_C(0x1e82f70b6cb586ed), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000637f), UINT64_C(0x1f42f60f4cad26f7), UINT64_C(0x1f42fb8fb0b286d3),
        UINT64_C(0x1f43094e98afc717), UINT64_C(0x1f42fa8f94b2c70e)
    },
    {   UINT64_C(0x000000000000c852), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1a0afd4f5ca1069a)
    },
    {   UINT64_C(0x0000000000006380), UINT64_C(0x1f42fbcfc0b386de), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f8cf38b666c7), UINT64_C(0x1f43000e7cae2706)
    },
    {   UINT64_C(0x000000000000c854), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1772ec4f709de698)
    },
    {   UINT64_C(0x000000000000c855), UINT64_C(0x1772f50f709de698), UINT64_C(0x1772ec4f709f6698),
        UINT64_C(0x1772f50f709f6698), UINT64_C(0x1772f3cf709f6698)
    },
    {   UINT64_C(0x000000000000c856), UINT64_C(0x1772f38f709f6698), UINT64_C(0x1772ec4f709d4698),
        UINT64_C(0x1772fa4f709d4698), UINT64_C(0x1772ec4f709f6698)
    },
    {   UINT64_C(0x0000000000006382), UINT64_C(0x1f42facee8b54703), UINT64_C(0x1f42facf14b7a732),
        UINT64_C(0x1f43000f58ab26e9), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008a82), UINT64_C(0x24e302cb94c7a6e3), UINT64_C(0x1feafa8b94b7e6e3),
        UINT64_C(0x1c92fc8b94a986e3), UINT64_C(0x1592f64aa090e720)
    },
    {   UINT64_C(0x0000000000006383), UINT64_C(0x1f43048ea8aee715), UINT64_C(0x1f42f90e64b08716),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ffcf10b86711)
    },
    {   UINT64_C(0x0000000000008a83), UINT64_C(0x2502f60aa0e90720), UINT64_C(0x0f9af60aa08e6720),
        UINT64_C(0x0f9af60aa08e6720), UINT64_C(0x0f9af60aa08e6720)
    },
    {   UINT64_C(0x0000000000006384), UINT64_C(0x1f42fb4eecb3873d), UINT64_C(0x1f42f70f50b46729),
        UINT64_C(0x1f42fe4f4cb166e9), UINT64_C(0x1f43000f68b086ef)
    },
    {   UINT64_C(0x0000000000008a84), UINT64_C(0x0f9af60aa08e6720), UINT64_C(0x0f9af60aa08e6720),
        UINT64_C(0x103af60aa08e6720), UINT64_C(0x0f9af60aa08e6720)
    },
    {   UINT64_C(0x0000000000006385), UINT64_C(0x1f42f9ce6cb4a722), UINT64_C(0x1f42fc0f08b56713),
        UINT64_C(0x1f42f9cf00b22704), UINT64_C(0x1f42ff0f3cb6a6fa)
    },
    {   UINT64_C(0x0000000000008a85), UINT64_C(0x13a2f60aa0948720), UINT64_C(0x0f9af60aa08e6720),
        UINT64_C(0x108af60aa08e6720), UINT64_C(0x1712f60aa0a4c720)
    },
    {   UINT64_C(0x0000000000006386), UINT64_C(0x1f43010f08ad670d), UINT64_C(0x1f42fc8f18b7a6b8),
        UINT64_C(0x1f4301cf7cb7a6ef), UINT64_C(0x1f42fccfacafc6fa)
    },
    {   UINT64_C(0x0000000000008a86), UINT64_C(0x10daf60aa08e6720), UINT64_C(0x117af60aa08e6720),
        UINT64_C(0x117af60aa08e6720), UINT64_C(0x0e5af60aa08e679b)
    },
    {   UINT64_C(0x0000000000006387), UINT64_C(0x1f43010f7cb6c71e), UINT64_C(0x1f42f50f14b726f7),
        UINT64_C(0x1f42f74fe0b366eb), UINT64_C(0x1f42f60fe0b2c6d6)
    },
    {   UINT64_C(0x0000000000008a87), UINT64_C(0x0e5af608b48e6720), UINT64_C(0x27b3054bb0d1a6ea),
        UINT64_C(0x1fd2f94b98b206e4), UINT64_C(0x0fbb098b1471c61e)
    },
    {   UINT64_C(0x0000000000006388), UINT64_C(0x1f42f88fd0b56702), UINT64_C(0x1f42face50b6a717),
        UINT64_C(0x1f42f8cea8af8706), UINT64_C(0x1f42fccf3cb08709)
    },
    {   UINT64_C(0x000000000000c864), UINT64_C(0x1e8aff107cb025ab), UINT64_C(0x1243058cf87bc68c),
        UINT64_C(0x1e8aff107cb025ab), UINT64_C(0x1243058cf87bc68c)
    },
    {   UINT64_C(0x000000000000c865), UINT64_C(0x1e8af5907cb505ab), UINT64_C(0x1243058c087bc6c8),
        UINT64_C(0x1e8aff0cf8b0668c), UINT64_C(0x1e8aff0cf8b0668c)
    },
    {   UINT64_C(0x0000000000008a89), UINT64_C(0x156afa0efc8e06a8), UINT64_C(0x156afa0bf48e060b),
        UINT64_C(0x156afa0c888e060b), UINT64_C(0x156af84c5892a60b)
    },
    {   UINT64_C(0x000000000000638a), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0ebcb8270f),
        UINT64_C(0x1f42ff0f34ad46fa), UINT64_C(0x1f42fc9044b3471a)
    },
    {   UINT64_C(0x0000000000008a8a), UINT64_C(0x156afa0efc8e060b), UINT64_C(0x156afa13108e2614),
        UINT64_C(0x156afa0f8c8e2506), UINT64_C(0x156afa0f8c8e25e7)
    },
    {   UINT64_C(0x000000000000638b), UINT64_C(0x1f4301cf8ca9c6fd), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc4fa8aca702), UINT64_C(0x1f43000ec8b386e4)
    },
    {   UINT64_C(0x00000000000059de), UINT64_C(0x1f42fb8eecb5e704), UINT64_C(0x1f42fb8f18b42700),
        UINT64_C(0x1f42f98ef8b72704), UINT64_C(0x1f42fb8f08b18704)
    },
    {   UINT64_C(0x000000000000638c), UINT64_C(0x1f42fa4f00b8e72a), UINT64_C(0x1f42f40f6cb76731),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbcee0b8071b)
    },
    {   UINT64_C(0x000000000000c86c), UINT64_C(0x1242f94cf87d6696), UINT64_C(0x1243024cf881e696),
        UINT64_C(0x1242f94cf87d6696), UINT64_C(0x1243024cf881e696)
    },
    {   UINT64_C(0x000000000000638d), UINT64_C(0x1f42fcce94ab2733), UINT64_C(0x1f42fccfccb10710),
        UINT64_C(0x1f42fa4f84b566d8), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008a8d), UINT64_C(0x1512fa8dc48c8657), UINT64_C(0x1512fa8dc48c8657),
        UINT64_C(0x1a52fa8dc4a18712), UINT64_C(0x2262fa8bc0c1c6d8)
    },
    {   UINT64_C(0x000000000000638e), UINT64_C(0x1f42fc4f4cb6470a), UINT64_C(0x1f42f60ea8b3271f),
        UINT64_C(0x1f43014ff4b5270d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c870), UINT64_C(0x1e8afe92e4b045dd), UINT64_C(0x1e8afe8fb4b04511),
        UINT64_C(0x114329cd187aa69e), UINT64_C(0x1142ffcd1865a69e)
    },
    {   UINT64_C(0x000000000000c871), UINT64_C(0x1e8aff0dd8b02652), UINT64_C(0x1b02fe8d0ca2468c),
        UINT64_C(0x1e8aff0dd8b02652), UINT64_C(0x1e8aff0dd8b02652)
    },
    {   UINT64_C(0x000000000000c872), UINT64_C(0x1b02fe8d0ca2468c), UINT64_C(0x1e8aff0dd8b02652),
        UINT64_C(0x1b02fe8d0ca2468c), UINT64_C(0x1e8afe8f4cb04623)
    },
    {   UINT64_C(0x0000000000006390), UINT64_C(0x1f42fa4f28b82716), UINT64_C(0x1f42fa0fe0b1670e),
        UINT64_C(0x1f42fa8e8cb88715), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c874), UINT64_C(0x1e8aff0ea0b02622), UINT64_C(0x1652f80cf892c68c),
        UINT64_C(0x1e8aff0ea0b02622), UINT64_C(0x1652f80cf892c68c)
    },
    {   UINT64_C(0x0000000000006391), UINT64_C(0x1f42fb8e8cb5072c), UINT64_C(0x1f42ff4f50b5e710),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43064e80b6873e)
    },
    {   UINT64_C(0x000000000000c876), UINT64_C(0x1cf2fb8d30ab867e), UINT64_C(0x1cf2fb8d30ab867e),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006392), UINT64_C(0x1f42ff0fbcb0e6eb), UINT64_C(0x1f42f74fd0b2e725),
        UINT64_C(0x1f42f78f80b0671b), UINT64_C(0x1f42f7ced0ab4702)
    },
    {   UINT64_C(0x00000000000059e5), UINT64_C(0x1f42f88f38b5c70c), UINT64_C(0x1f42f98f48b7671e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbcf18b7a723)
    },
    {   UINT64_C(0x0000000000006393), UINT64_C(0x1f42f9cefcb74721), UINT64_C(0x1f42fd4ec4b586ce),
        UINT64_C(0x1f42fecef8ae8700), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c87a), UINT64_C(0x1cf2fd0eecaac60f), UINT64_C(0x156af94d308ea67e),
        UINT64_C(0x156af94c7c8ea6a9), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006394), UINT64_C(0x1f4300ce98b946ef), UINT64_C(0x1f42ff4fbcb7e6ef),
        UINT64_C(0x1f43014f6caf470f), UINT64_C(0x1f4301cf40afc6d9)
    },
    {   UINT64_C(0x0000000000008a94), UINT64_C(0x1362f08f248ac642), UINT64_C(0x1362f5cf2c8826ae),
        UINT64_C(0x1362f5cf2c8826ae), UINT64_C(0x1362f5cf2c882600)
    },
    {   UINT64_C(0x000000000000c87d), UINT64_C(0x0000000000000000), UINT64_C(0x1b02fe8d0ca2468c),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008a95), UINT64_C(0x1362f5cf2c882600), UINT64_C(0x1862f60f2c9c0600),
        UINT64_C(0x1862f60f2c9c0600), UINT64_C(0x1613088f2c93e600)
    },
    {   UINT64_C(0x0000000000006396), UINT64_C(0x0000000000000000), UINT64_C(0x1f43080e38ada734),
        UINT64_C(0x1f43018f70b486fa), UINT64_C(0x1f43000e6cb1c6fd)
    },
    {   UINT64_C(0x000000000000c880), UINT64_C(0x12baef4fa088c68c), UINT64_C(0x10dafdcf2c7a06f9),
        UINT64_C(0x117af90f78846696), UINT64_C(0x12bb010fa07fe68c)
    },
    {   UINT64_C(0x000000000000c881), UINT64_C(0x12bb010da47fe70b), UINT64_C(0x189afa8e389aa63a),
        UINT64_C(0x154af3cfa090c68c), UINT64_C(0x154af3cfa090c68c)
    },
    {   UINT64_C(0x000000000000c882), UINT64_C(0x1773028f6c92060b), UINT64_C(0x1773028d58920690),
        UINT64_C(0x0fa2fd102c7585db), UINT64_C(0x1773028f6c92060b)
    },
    {   UINT64_C(0x0000000000006398), UINT64_C(0x1f42f78f80b3270e), UINT64_C(0x1f42fbcf58b006e7),
        UINT64_C(0x1f42f90ee8ae4715), UINT64_C(0x1f42f64f14aec705)
    },
    {   UINT64_C(0x000000000000c884), UINT64_C(0x1eb2f50b94b5c6e3), UINT64_C(0x1c92f80b94aba6e3),
        UINT64_C(0x1772fe92e4942511), UINT64_C(0x1812fe4f70942679)
    },
    {   UINT64_C(0x000000000000c885), UINT64_C(0x1772fe4ebc942701), UINT64_C(0x1243018c9c7dc6c4),
        UINT64_C(0x0e22f4511473e583), UINT64_C(0x124b0290287d65de)
    },
    {   UINT64_C(0x000000000000c886), UINT64_C(0x0c52f8111c6ac581), UINT64_C(0x0f6b03510c718586),
        UINT64_C(0x1e2b0e8b94bd879a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c887), UINT64_C(0x0000000000000000), UINT64_C(0x1823020fa09505aa),
        UINT64_C(0x1e23020fa0ad05aa), UINT64_C(0x156afa8fa08dc630)
    },
    {   UINT64_C(0x000000000000c888), UINT64_C(0x18c2fa8fa0970621), UINT64_C(0x18c2fa8e78970621),
        UINT64_C(0x15baf4cf3891e5fe), UINT64_C(0x0903070cac56069a)
    },
    {   UINT64_C(0x000000000000c889), UINT64_C(0x0cdaf3ccac6f069a), UINT64_C(0x0f3b070cac6ee69a),
        UINT64_C(0x134af3ccac88c69a), UINT64_C(0x1402fb0f30880600)
    },
    {   UINT64_C(0x000000000000c88a), UINT64_C(0x1402fb0f30880600), UINT64_C(0x1452fe8f1c878605),
        UINT64_C(0x1452fe8f1c878605), UINT64_C(0x114af60aa09a2720)
    },
    {   UINT64_C(0x000000000000c88b), UINT64_C(0x1afaf60aa0c0e720), UINT64_C(0x24b2f60aa0e7c720),
        UINT64_C(0x127af58aa099e720), UINT64_C(0x1c3af60aa0c0e720)
    },
    {   UINT64_C(0x000000000000c88c), UINT64_C(0x25f2f60aa0e7c720), UINT64_C(0x128af60aa09a2720),
        UINT64_C(0x128af60aa09a2720), UINT64_C(0x128af60aa09a2720)
    },
    {   UINT64_C(0x000000000000c88d), UINT64_C(0x1772fe8efc942627), UINT64_C(0x1772fe8efc942627),
        UINT64_C(0x11531d8efc6c0627), UINT64_C(0x1772ff0efc93e627)
    },
    {   UINT64_C(0x000000000000c88e), UINT64_C(0x1772fe92e4942607), UINT64_C(0x1772fe8f0c944607),
        UINT64_C(0x1772fe8efc942627), UINT64_C(0x1772feceb493c61d)
    },
    {   UINT64_C(0x000000000000639e), UINT64_C(0x1f42f90e2cb6073f), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa0ef4b7e739), UINT64_C(0x1f42ff4ef0b7670d)
    },
    {   UINT64_C(0x0000000000008a9e), UINT64_C(0x156af790108f66a7), UINT64_C(0x156af90f388aa5fc),
        UINT64_C(0x156b010f388ea5fc), UINT64_C(0x156af90f388aa70e)
    },
    {   UINT64_C(0x000000000000639f), UINT64_C(0x1f43028f60b3e730), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4303ce9cacc711)
    },
    {   UINT64_C(0x000000000000c892), UINT64_C(0x1772ff100893e5e4), UINT64_C(0x1772ff0ee093e62f),
        UINT64_C(0x1772ff0e7493e620), UINT64_C(0x1772ff0dec93e64d)
    },
    {   UINT64_C(0x00000000000063a0), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f64edcb64708),
        UINT64_C(0x1f42fe4f04b48719), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c894), UINT64_C(0x1772ff114c93c683), UINT64_C(0x1772ff0d1c93c683),
        UINT64_C(0x1772ff0d1c93c683), UINT64_C(0x1772ff0d1c93c683)
    },
    {   UINT64_C(0x00000000000063a1), UINT64_C(0x1f43054e14b10740), UINT64_C(0x1f42fcced0b006f4),
        UINT64_C(0x1f42f74e54b9073c), UINT64_C(0x1f42fd0ee0af0718)
    },
    {   UINT64_C(0x000000000000c896), UINT64_C(0x1772ff114c93c6e1), UINT64_C(0x1772ff114c93c72c),
        UINT64_C(0x1772ff114c93c72c), UINT64_C(0x1772ff114c93c731)
    },
    {   UINT64_C(0x00000000000063a2), UINT64_C(0x1f42fe0f64b6a6fc), UINT64_C(0x1f43080e58aa8741),
        UINT64_C(0x1f42fe0e8cb0872a), UINT64_C(0x1f42ff0e68b6473a)
    },
    {   UINT64_C(0x000000000000c898), UINT64_C(0x1772ff0d3093c67e), UINT64_C(0x1772ff100c93c5e3),
        UINT64_C(0x1772ff0d3093c698), UINT64_C(0x1772ff0ebc93c638)
    },
    {   UINT64_C(0x00000000000063a3), UINT64_C(0x1f4301cec8b12720), UINT64_C(0x1f42fd0e8cb14708),
        UINT64_C(0x1f42ff0f78b126f6), UINT64_C(0x1f43014f20ac671f)
    },
    {   UINT64_C(0x000000000000c89a), UINT64_C(0x1773020b089246c1), UINT64_C(0x1773020b089246c1),
        UINT64_C(0x1f42f78f40b6a5fe), UINT64_C(0x1f42f78f40b6a5fe)
    },
    {   UINT64_C(0x000000000000c89b), UINT64_C(0x0d0af98c9c6ce6c4), UINT64_C(0x1772ff0e4493e637),
        UINT64_C(0x1773020dd4924659), UINT64_C(0x1773020dd4924659)
    },
    {   UINT64_C(0x000000000000c89c), UINT64_C(0x1773020bf49246b5), UINT64_C(0x1773020bf49246b5),
        UINT64_C(0x1772feccc893c69a), UINT64_C(0x1772feccc893c69a)
    },
    {   UINT64_C(0x00000000000063a5), UINT64_C(0x1f42f94f6cb1c730), UINT64_C(0x1f42f94eecb7e71d),
        UINT64_C(0x1f42fc0e9cb06705), UINT64_C(0x1f43094e64b1871b)
    },
    {   UINT64_C(0x000000000000c89e), UINT64_C(0x1773020ab0924720), UINT64_C(0x1773020ab0924720),
        UINT64_C(0x1773020f449245fb), UINT64_C(0x1773020f449245fb)
    },
    {   UINT64_C(0x00000000000063a6), UINT64_C(0x1f42f60f20b44702), UINT64_C(0x1f43024f4cb1470c),
        UINT64_C(0x1f42f58f10b846f7), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000003ca7), UINT64_C(0x106b16550c6be650), UINT64_C(0x106b09572c72666c),
        UINT64_C(0x106b12173067c671), UINT64_C(0x106b039730750671)
    },
    {   UINT64_C(0x000000000000c8a1), UINT64_C(0x1773028d58920690), UINT64_C(0x1773028d58920690),
        UINT64_C(0x1773028e0c92066f), UINT64_C(0x1773028e0c92066f)
    },
    {   UINT64_C(0x0000000000003ca8), UINT64_C(0x106b039730792671), UINT64_C(0x106af58f747c064b),
        UINT64_C(0x106aee0f747ea64b), UINT64_C(0x106ae00fa079064b)
    },
    {   UINT64_C(0x000000000000c8a3), UINT64_C(0x1452fe8f1c878605), UINT64_C(0x1452fe8f1c878605),
        UINT64_C(0x1452fe8f1c878605), UINT64_C(0x177303cf349165fc)
    },
    {   UINT64_C(0x0000000000008aa8), UINT64_C(0x156afa0b748e26ee), UINT64_C(0x156af90f388aa5fc),
        UINT64_C(0x156b010f388ea5fc), UINT64_C(0x1d2af44e04b00649)
    },
    {   UINT64_C(0x000000000000c8a5), UINT64_C(0x1452fe8f1c878605), UINT64_C(0x1b02fa8d98a44662),
        UINT64_C(0x1b02fa8d98a44662), UINT64_C(0x1b02fa8d98a44662)
    },
    {   UINT64_C(0x0000000000003caa), UINT64_C(0x106af08d087ec64b), UINT64_C(0x106afb0f8c7d2597),
        UINT64_C(0x106aefcf8c7f2596), UINT64_C(0x106aeb8fa079664b)
    },
    {   UINT64_C(0x00000000000063aa), UINT64_C(0x1f42f78ea0b4272d), UINT64_C(0x1f42f78e6cb7e72c),
        UINT64_C(0x1f42fe0e58af673a), UINT64_C(0x1f430e0e6cab6737)
    },
    {   UINT64_C(0x000000000000c8a8), UINT64_C(0x1c72f94d28aaa67d), UINT64_C(0x1c72f94d28aaa67d),
        UINT64_C(0x177304cfa090e68c), UINT64_C(0x177304cfa090e68c)
    },
    {   UINT64_C(0x000000000000c8a9), UINT64_C(0x177304cfa090e68c), UINT64_C(0x177304cfa090e68c),
        UINT64_C(0x115b04cfa078868c), UINT64_C(0x115b04cfa078868c)
    },
    {   UINT64_C(0x000000000000c8aa), UINT64_C(0x177304cfa090e68c), UINT64_C(0x1e6304cfa0acc68c),
        UINT64_C(0x1d8304cfa0a9868c), UINT64_C(0x1d8304cfa0a9868c)
    },
    {   UINT64_C(0x000000000000c8ab), UINT64_C(0x1c8af34fa0a5468c), UINT64_C(0x1c82f34fa0a5468c),
        UINT64_C(0x2242f34fa0be868c), UINT64_C(0x2282f34fa0bd868c)
    },
    {   UINT64_C(0x000000000000c8ac), UINT64_C(0x1773068f08900607), UINT64_C(0x1773068f08900607),
        UINT64_C(0x1773024f409225fe), UINT64_C(0x1773024f409225fe)
    },
    {   UINT64_C(0x000000000000c8ad), UINT64_C(0x1773024ddc922655), UINT64_C(0x1773024ddc922655),
        UINT64_C(0x2602fa9120d0459c), UINT64_C(0x2602fa9120d0459c)
    },
    {   UINT64_C(0x000000000000c8ae), UINT64_C(0x1ba2fa9120a6c59c), UINT64_C(0x1772fe4ebc94261b),
        UINT64_C(0x0f93008c407385b5), UINT64_C(0x1402fb0cac880600)
    },
    {   UINT64_C(0x000000000000c8af), UINT64_C(0x1402fb0f308806a1), UINT64_C(0x1402fb0f308806a1),
        UINT64_C(0x1772fd0fa094c65e), UINT64_C(0x1c72f94d28aaa67e)
    },
    {   UINT64_C(0x000000000000c8b0), UINT64_C(0x1e8afb8b94b1e6e3), UINT64_C(0x1e8afb8b94b1e6e3),
        UINT64_C(0x1e0b058b80aae6e8), UINT64_C(0x1e0b058b80aae6e8)
    },
    {   UINT64_C(0x000000000000c8b1), UINT64_C(0x1242f8cfe48225eb), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1772fe8ea494263b)
    },
    {   UINT64_C(0x0000000000008aaf), UINT64_C(0x1d2af44f38b005fc), UINT64_C(0x156afd0f388ca5fc),
        UINT64_C(0x156afd0f388ca5fc), UINT64_C(0x156afd0e048ca647)
    },
    {   UINT64_C(0x00000000000063b0), UINT64_C(0x1f42facf04b6070d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa8f2cb14719), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c8b4), UINT64_C(0x1772fdce94946640), UINT64_C(0x1772fdce94946640),
        UINT64_C(0x1772fe4f1c942605), UINT64_C(0x1772fe4f1c942605)
    },
    {   UINT64_C(0x000000000000c8b5), UINT64_C(0x1452fe8f1c87866b), UINT64_C(0x156afa0cac8e269a),
        UINT64_C(0x1773020f409245fe), UINT64_C(0x1773020f409245fe)
    },
    {   UINT64_C(0x0000000000005a04), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f9cee4b04707),
        UINT64_C(0x1f42fdcea4af0708), UINT64_C(0x1f42fb8eccb8a70c)
    },
    {   UINT64_C(0x00000000000063b2), UINT64_C(0x1f42f78e88b6e72b), UINT64_C(0x1f42face70b2e735),
        UINT64_C(0x1f43084e7cb06744), UINT64_C(0x1f42f78f38b6071e)
    },
    {   UINT64_C(0x0000000000008ab2), UINT64_C(0x156afd0d108ca681), UINT64_C(0x156afd0b588ca6d2),
        UINT64_C(0x156afd0b588ca6d2), UINT64_C(0x156afd4aa48be6b5)
    },
    {   UINT64_C(0x000000000000c8b9), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1772fecc8093c69a), UINT64_C(0x1772fecc8093c69a)
    },
    {   UINT64_C(0x0000000000008ab3), UINT64_C(0x156afe8aa48c86b5), UINT64_C(0x2a42fe0eccdf8616),
        UINT64_C(0x2a42fe0eccdf8616), UINT64_C(0x156afa8f388b65fc)
    },
    {   UINT64_C(0x00000000000063b4), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff8ebcb4c71a),
        UINT64_C(0x1f42f8ce2cb6672a), UINT64_C(0x1f42fd8ebcb7471a)
    },
    {   UINT64_C(0x0000000000008ab4), UINT64_C(0x156aff8f388de5fc), UINT64_C(0x156afd0e048cc649),
        UINT64_C(0x156afd0e048ca649), UINT64_C(0x156afd0c5c8ca6b3)
    },
    {   UINT64_C(0x000000000000c8bd), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1773028f6c9206c7), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008ab5), UINT64_C(0x156afd0c5c8ca6b3), UINT64_C(0x156afd0c5c8ca6b3),
        UINT64_C(0x156afd0c5c8ca6b3), UINT64_C(0x2712fd0f38d345fc)
    },
    {   UINT64_C(0x00000000000063b6), UINT64_C(0x1f42fdceacb3e716), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8ce5cb72707)
    },
    {   UINT64_C(0x0000000000008ab6), UINT64_C(0x2712fd0f38d345fc), UINT64_C(0x1362fa0f24860600),
        UINT64_C(0x1362fa0da08606a1), UINT64_C(0x1362fa0e1c86069f)
    },
    {   UINT64_C(0x00000000000063b7), UINT64_C(0x1f42fcceccae2722), UINT64_C(0x1f42fd8ebcb3671e),
        UINT64_C(0x1f42fbcef8b2a716), UINT64_C(0x1f42fb8eccb72726)
    },
    {   UINT64_C(0x000000000000c8c2), UINT64_C(0x0eab170c9c77e6c3), UINT64_C(0x0eaaf08c9c64a6c3),
        UINT64_C(0x0eab170c9c77e6c4), UINT64_C(0x0eaaf08c9c64a6c4)
    },
    {   UINT64_C(0x00000000000063b8), UINT64_C(0x1f42f68ebcb34716), UINT64_C(0x1f42fbcedcb7e712),
        UINT64_C(0x1f42f80ec8b6a71a), UINT64_C(0x1f430acec8ad4715)
    },
    {   UINT64_C(0x000000000000c8c4), UINT64_C(0x1772fe5150942577), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000810b), UINT64_C(0x1322f2cfa086c67e), UINT64_C(0x145af58f688b268c),
        UINT64_C(0x1c32f2cf68aa668c), UINT64_C(0x13eaeecfa08bc67e)
    },
    {   UINT64_C(0x0000000000008ab9), UINT64_C(0x156afd0fa08ca67e), UINT64_C(0x1ae2f98fa0a2e67e),
        UINT64_C(0x156afc4fa08cc67e), UINT64_C(0x156afa0fa08e2623)
    },
    {   UINT64_C(0x00000000000063ba), UINT64_C(0x1f42f98eacb88715), UINT64_C(0x1f42fccedcab8703),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb8f50b5471a)
    },
    {   UINT64_C(0x000000000000c8c8), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x2012f751a4ba4562), UINT64_C(0x2012f751a4ba4562)
    },
    {   UINT64_C(0x000000000000810d), UINT64_C(0x0e72f18d7c7565aa), UINT64_C(0x0e92f78f787525b4),
        UINT64_C(0x168af18fa096e5b0), UINT64_C(0x0c32f18f786b25b4)
    },
    {   UINT64_C(0x0000000000008abb), UINT64_C(0x12c2fa0fe88385d1), UINT64_C(0x12c2fa0fe88385d1),
        UINT64_C(0x0ca2f3ccac6e269a), UINT64_C(0x0fb3074d3870a67c)
    },
    {   UINT64_C(0x00000000000063bc), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f78f28b6272a),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008abc), UINT64_C(0x0fb3074d3870a67c), UINT64_C(0x0fb3074cb470a69d),
        UINT64_C(0x105af08cac7ea69f), UINT64_C(0x156afa0cac8e269f)
    },
    {   UINT64_C(0x000000000000c8cd), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1cf3034d30a7a6d7), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008abd), UINT64_C(0x156b0eccac83e69f), UINT64_C(0x156af10cac92c69f),
        UINT64_C(0x156b33ce08714648), UINT64_C(0x2492fc8d34c5867d)
    },
    {   UINT64_C(0x00000000000063be), UINT64_C(0x1f42fd8f28b54732), UINT64_C(0x1f42f7cef8afc712),
        UINT64_C(0x1f42fe8ebcaae70b), UINT64_C(0x1f42fa8e78b70707)
    },
    {   UINT64_C(0x0000000000008abe), UINT64_C(0x2493048d34c9867d), UINT64_C(0x156afd0c308ca6be),
        UINT64_C(0x156afd0c308ca6be), UINT64_C(0x1bf2f98c28a886ae)
    },
    {   UINT64_C(0x00000000000063bf), UINT64_C(0x1f42f94edcb7a713), UINT64_C(0x1f42f60f24b76725),
        UINT64_C(0x1f42f54f28b4e712), UINT64_C(0x1f42facf18af8703)
    },
    {   UINT64_C(0x0000000000008abf), UINT64_C(0x1473058b948486e3), UINT64_C(0x162af98c289166ae),
        UINT64_C(0x0cd3070cac65469a), UINT64_C(0x0ef3058b946e86e3)
    },
    {   UINT64_C(0x00000000000063c0), UINT64_C(0x1f42fa8eccb2470e), UINT64_C(0x1f42fa8f1caf26f7),
        UINT64_C(0x1f43080eacb5c722), UINT64_C(0x1f42f94f18b6c71e)
    },
    {   UINT64_C(0x0000000000005a13), UINT64_C(0x1f430c8e40b34738), UINT64_C(0x1f42f70e94b8c729),
        UINT64_C(0x1f42fccf78b42727), UINT64_C(0x1f42fdce7cb22707)
    },
    {   UINT64_C(0x00000000000063c1), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f98f28b8270e),
        UINT64_C(0x1f42fa8f48ab6707), UINT64_C(0x1f42faceccb6471a)
    },
    {   UINT64_C(0x0000000000005a14), UINT64_C(0x1f42f8cf08af471f), UINT64_C(0x1f43094e58b48738),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f98eecb2c733)
    },
    {   UINT64_C(0x00000000000063c2), UINT64_C(0x1f42fbced0b3670b), UINT64_C(0x1f43080eb0b22717),
        UINT64_C(0x1f42f68f18b1c723), UINT64_C(0x1f4305cea8b5472c)
    },
    {   UINT64_C(0x0000000000005a15), UINT64_C(0x1f42f7cf68ae2726), UINT64_C(0x1f42f98f68b1c710),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063c3), UINT64_C(0x1f42f74e80b6c721), UINT64_C(0x1f42f88f08b7a71e),
        UINT64_C(0x1f42fc8eecaa671a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005a16), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f64e9cb76727),
        UINT64_C(0x1f42fa4eb0b56726), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063c4), UINT64_C(0x1f42f58f08b74722), UINT64_C(0x1f42f8cf08b58722),
        UINT64_C(0x1f42f94f08b86726), UINT64_C(0x1f42f4ceccb8e72d)
    },
    {   UINT64_C(0x0000000000008ac4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1c72f94d2caaa67e), UINT64_C(0x1c72f94d2caaa67e)
    },
    {   UINT64_C(0x00000000000063c5), UINT64_C(0x1f42f84edcafe730), UINT64_C(0x1f42f58eccb5c722),
        UINT64_C(0x1f42fd8f2cae070b), UINT64_C(0x1f42fbcf68b7671e)
    },
    {   UINT64_C(0x0000000000008ac5), UINT64_C(0x1c72f94d2caaa67e), UINT64_C(0x1c72f94d2caaa67e),
        UINT64_C(0x2142f7cbd8bea6d0), UINT64_C(0x2142f7cbd8bea6d0)
    },
    {   UINT64_C(0x00000000000063c6), UINT64_C(0x1f42fd8f38b4a70b), UINT64_C(0x1f42f5cf2cb7a72f),
        UINT64_C(0x1f42fe4f38b18712), UINT64_C(0x1f42f78f08b4272e)
    },
    {   UINT64_C(0x0000000000008ac6), UINT64_C(0x2142f7cbd8bea6d0), UINT64_C(0x2142f7cbd8bea6d0),
        UINT64_C(0x1c72f94d2caaa67e), UINT64_C(0x2082f80cd0bb86f4)
    },
    {   UINT64_C(0x00000000000063c7), UINT64_C(0x1f42f6ceacb2871e), UINT64_C(0x1f42f6ceacb52702),
        UINT64_C(0x1f42f1ce70b24726), UINT64_C(0x1f42f7ceccb92707)
    },
    {   UINT64_C(0x0000000000008ac7), UINT64_C(0x2082f80cd0bb86f4), UINT64_C(0x0782fa9250564534),
        UINT64_C(0x0782fa9250564534), UINT64_C(0x1c72f70dfcabc69a)
    },
    {   UINT64_C(0x00000000000063c8), UINT64_C(0x1f42fbceecb5c716), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fccf38b0470e)
    },
    {   UINT64_C(0x0000000000008ac8), UINT64_C(0x1c72f70dfcabc69a), UINT64_C(0x1c73028cd8a60690),
        UINT64_C(0x1c73028cd8a60690), UINT64_C(0x1cf2f40da4af4661)
    },
    {   UINT64_C(0x000000001f413ec0), UINT64_C(0x107ac94c6492a68e), UINT64_C(0x0fa2cacc647aa691),
        UINT64_C(0x0fa2cacc707f4692), UINT64_C(0x1742c94c64992691)
    },
    {   UINT64_C(0x0000000000013ec1), UINT64_C(0x174ac94c649de692), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063ca), UINT64_C(0x0000000000000000), UINT64_C(0x1f43088e3cb16727),
        UINT64_C(0x1f42f7ceecb9a726), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008aca), UINT64_C(0x1102f80dfc7d8649), UINT64_C(0x105af48fe07ca5d0),
        UINT64_C(0x0b2af48fe067e5d0), UINT64_C(0x0b2af48fe067e5d0)
    },
    {   UINT64_C(0x00000000000063cb), UINT64_C(0x1f42fa8ef8b1e70b), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f8cebcb9c70e), UINT64_C(0x1f42fb8e4cb6e736)
    },
    {   UINT64_C(0x0000000000008acb), UINT64_C(0x1a52fa8fb0a185dc), UINT64_C(0x1a52fa8fb0a185dc),
        UINT64_C(0x12a2fa8dc482c657), UINT64_C(0x12a2fa8dc482c657)
    },
    {   UINT64_C(0x000000000000c8eb), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x09daee12e465e511)
    },
    {   UINT64_C(0x0000000000008acc), UINT64_C(0x1cf2ff9084a985a8), UINT64_C(0x1cf2fd0c00aac6cb),
        UINT64_C(0x2582fb0eaccde621), UINT64_C(0x3132fbd088fc65a9)
    },
    {   UINT64_C(0x00000000000063cd), UINT64_C(0x1f42fb8ebcb3a71a), UINT64_C(0x1f42f88ea4b1670f),
        UINT64_C(0x1f42f58f08b10713), UINT64_C(0x1f42f8cee8b3e70f)
    },
    {   UINT64_C(0x0000000000008acd), UINT64_C(0x1cf2fc1084ab65aa), UINT64_C(0x1cf2fbd084ab65aa),
        UINT64_C(0x1cf2fbd084ab65aa), UINT64_C(0x2c22fbd084e825a9)
    },
    {   UINT64_C(0x00000000000063ce), UINT64_C(0x1f42f6ceacb84739), UINT64_C(0x1f42f94f08b6e719),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f48f08b2472e)
    },
    {   UINT64_C(0x0000000000008ace), UINT64_C(0x1cf2fbd084aba5a9), UINT64_C(0x1cf2fbd084ab65aa),
        UINT64_C(0x1cf2fbd084ab65aa), UINT64_C(0x1cf2fbd084ab65a9)
    },
    {   UINT64_C(0x00000000000063cf), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f4cf04b80735), UINT64_C(0x1f42fececcb44738)
    },
    {   UINT64_C(0x0000000000008acf), UINT64_C(0x1cf2fbd084ab65aa), UINT64_C(0x1cf2fa9084ac05aa),
        UINT64_C(0x1cf2fbd084ab65a9), UINT64_C(0x1cf2fbd084ab65a9)
    },
    {   UINT64_C(0x00000000000063d0), UINT64_C(0x1f42f88eacb4a702), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd0e6cb76741), UINT64_C(0x1f42fb8e8cb88715)
    },
    {   UINT64_C(0x0000000000005a23), UINT64_C(0x1f42fa8f18b4c713), UINT64_C(0x1f42fb0f64b50728),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe8f3cafe6f6)
    },
    {   UINT64_C(0x00000000000063d1), UINT64_C(0x1f42f6cef8b6e72e), UINT64_C(0x1f42f88e84b80732),
        UINT64_C(0x1f42f8cf78b7e71a), UINT64_C(0x1f42face90b7a713)
    },
    {   UINT64_C(0x0000000000008ad1), UINT64_C(0x1cf2f94f38ab65fc), UINT64_C(0x1d02fbcc94aba6a5),
        UINT64_C(0x1d02fbcc94aba6a5), UINT64_C(0x1cf2fbd084ab65e4)
    },
    {   UINT64_C(0x00000000000063d2), UINT64_C(0x1f42f5ce8cb82727), UINT64_C(0x1f42fdce44b7a738),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f7ceccb9670b)
    },
    {   UINT64_C(0x0000000000008ad2), UINT64_C(0x1cf2fbcd6cab65a9), UINT64_C(0x1cf2fbd084ab65e4),
        UINT64_C(0x1cf2fbcd6cab65a9), UINT64_C(0x1cf2fbcf98ab65a9)
    },
    {   UINT64_C(0x00000000000063d3), UINT64_C(0x1f42f50e84b82732), UINT64_C(0x1f42f70f48b56712),
        UINT64_C(0x1f42f6cefcb7e70b), UINT64_C(0x1f42fb8ed0b5671a)
    },
    {   UINT64_C(0x0000000000008ad3), UINT64_C(0x1cf2fbcf98ab65a9), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063d4), UINT64_C(0x1f42fb8f5cb24728), UINT64_C(0x1f42f8cedcb6a70e),
        UINT64_C(0x1f42fd0f10b16729), UINT64_C(0x1f42f78ed4b5670e)
    },
    {   UINT64_C(0x0000000000008ad4), UINT64_C(0x18d2fd0f289a4653), UINT64_C(0x18d2fd0f289a4653),
        UINT64_C(0x15e2f6cf6c91a63d), UINT64_C(0x1b0af94da8a786b0)
    },
    {   UINT64_C(0x00000000000063d5), UINT64_C(0x1f42f4ce8cb5c733), UINT64_C(0x1f42f7ce3cae872d),
        UINT64_C(0x1f42fa8e84b0e728), UINT64_C(0x1f42f7cedcb4a715)
    },
    {   UINT64_C(0x0000000000008ad5), UINT64_C(0x1b0af94da4a786b0), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063d6), UINT64_C(0x1f42f78e74b7671e), UINT64_C(0x1f42f98e8cb2e725),
        UINT64_C(0x1f43030e7cb1a73c), UINT64_C(0x1f42fcced0b5070e)
    },
    {   UINT64_C(0x0000000000005a29), UINT64_C(0x1f42fc8f18b8c708), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430f8eb0b0672c), UINT64_C(0x1f42f88f38b34717)
    },
    {   UINT64_C(0x00000000000063d7), UINT64_C(0x1f42f68ec8b7471a), UINT64_C(0x1f43030e30b6e71b),
        UINT64_C(0x1f42fd8eccb2a71e), UINT64_C(0x1f42fece8cb3c73d)
    },
    {   UINT64_C(0x0000000000005a2a), UINT64_C(0x1f430c0eecb4c738), UINT64_C(0x1f42fbcf58ad46ec),
        UINT64_C(0x1f42fe8f48ad66e4), UINT64_C(0x1f42fa8f18b326e4)
    },
    {   UINT64_C(0x00000000000063d8), UINT64_C(0x1f42facf38b4070b), UINT64_C(0x1f43084ef0ad4702),
        UINT64_C(0x1f42f6cebcb6a728), UINT64_C(0x1f42f6cf1cb6a71a)
    },
    {   UINT64_C(0x0000000000005a2b), UINT64_C(0x1f42ff8ea4ade711), UINT64_C(0x1f42f7cef4b54708),
        UINT64_C(0x1f43028ed4afc6f8), UINT64_C(0x1f42f7cedcb02731)
    },
    {   UINT64_C(0x00000000000063d9), UINT64_C(0x1f42fb4f28b42711), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43064eacaec71e), UINT64_C(0x1f4300cf54b42716)
    },
    {   UINT64_C(0x0000000000005a2c), UINT64_C(0x1f42f9ceb4b74738), UINT64_C(0x1f42fbcf18adc708),
        UINT64_C(0x1f42fccf48b266fc), UINT64_C(0x1f42f7ceecb6a714)
    },
    {   UINT64_C(0x00000000000063da), UINT64_C(0x1f43030f48b3a712), UINT64_C(0x1f43004eacb50716),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43018f34ae0716)
    },
    {   UINT64_C(0x000000000000c908), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0fa2f80dc0780407)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005a2e), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f40f08b8a72f),
        UINT64_C(0x1f430a8e54ad6719), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063dc), UINT64_C(0x1f43104ee4ae8723), UINT64_C(0x1f42ff4f38b28710),
        UINT64_C(0x1f42ff4f30b30724), UINT64_C(0x1f43014f04a9c70e)
    },
    {   UINT64_C(0x0000000000005a2f), UINT64_C(0x1f42fb4e94b4e737), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063dd), UINT64_C(0x1f43020f94b1871d), UINT64_C(0x1f43010f64abc710),
        UINT64_C(0x1f43024f54b4470f), UINT64_C(0x1f43014f20b26702)
    },
    {   UINT64_C(0x0000000000005a30), UINT64_C(0x1f42fc8eacb5c704), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb8f68b34708), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063de), UINT64_C(0x1f42fe4f44b7270a), UINT64_C(0x1f43034f80af0718),
        UINT64_C(0x1f43030f44aae711), UINT64_C(0x1f42ff4f88afc715)
    },
    {   UINT64_C(0x0000000000005a31), UINT64_C(0x1f43064e50b48735), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc8f68b4a70c), UINT64_C(0x1f42fb8eecb326f3)
    },
    {   UINT64_C(0x00000000000063df), UINT64_C(0x1f42ff8f44b4e701), UINT64_C(0x1f430d0f28ace710),
        UINT64_C(0x1f43034f88b24721), UINT64_C(0x1f43014f38b5c71c)
    },
    {   UINT64_C(0x0000000000005a32), UINT64_C(0x1f42f88e44b1e71d), UINT64_C(0x1f42f9ce6cabc741),
        UINT64_C(0x1f42face68b52739), UINT64_C(0x1f42f7cf04b4e730)
    },
    {   UINT64_C(0x00000000000063e0), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd8f74b54712),
        UINT64_C(0x1f43040f44b82701), UINT64_C(0x1f42fe4f48b5c714)
    },
    {   UINT64_C(0x0000000000005a33), UINT64_C(0x1f42f6ce9cb5c6ff), UINT64_C(0x1f42f6cedcb72714),
        UINT64_C(0x1f42fc8ef8b3470b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063e1), UINT64_C(0x1f42fa0f58b66704), UINT64_C(0x1f43040f3cabc716),
        UINT64_C(0x1f42fdcf08af0711), UINT64_C(0x1f430e8e7cb36727)
    },
    {   UINT64_C(0x0000000000005a34), UINT64_C(0x1f430d4e40b46728), UINT64_C(0x1f42fb4ed8b006ff),
        UINT64_C(0x1f42f6ce4cb92739), UINT64_C(0x1f42f88eacb3671e)
    },
    {   UINT64_C(0x00000000000063e2), UINT64_C(0x1f430f4e6cade720), UINT64_C(0x1f42fe8f08b1e706),
        UINT64_C(0x1f42fe4f48b3a706), UINT64_C(0x1f42fc4fa8ad4730)
    },
    {   UINT64_C(0x000000000000c918), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x00000000000063e3), UINT64_C(0x0000000000000000), UINT64_C(0x1f43024f78b5470d),
        UINT64_C(0x1f43020f48b00705), UINT64_C(0x1f43014f08b6c717)
    },
    {   UINT64_C(0x000000000000c91a), UINT64_C(0x15baee0f5495669a), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063e4), UINT64_C(0x1f43010f60af4724), UINT64_C(0x1f42ff8eacb3e720),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd0efcb5a707)
    },
    {   UINT64_C(0x0000000000005a37), UINT64_C(0x1f42f88f58b72714), UINT64_C(0x1f42fd8eeca8a6f4),
        UINT64_C(0x1f42f98f28a846fb), UINT64_C(0x1f42f88e6cb8473a)
    },
    {   UINT64_C(0x00000000000063e5), UINT64_C(0x1f430f0f58ada713), UINT64_C(0x1f43028ec0b6671e),
        UINT64_C(0x1f42ff4f18ace714), UINT64_C(0x1f42fc0f98b4a714)
    },
    {   UINT64_C(0x0000000000005a38), UINT64_C(0x1f43124e5cb4e730), UINT64_C(0x1f42f78eccad0704),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f6ce98b54742)
    },
    {   UINT64_C(0x00000000000063e6), UINT64_C(0x1f42fb4f58b36716), UINT64_C(0x1f42fc8f70b3e701),
        UINT64_C(0x1f42fe0e8cafe71f), UINT64_C(0x1f43038e6cb46741)
    },
    {   UINT64_C(0x0000000000005a39), UINT64_C(0x1f42fc8ec0b2e728), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f88eccb5070b), UINT64_C(0x1f42f9ce90b5a724)
    },
    {   UINT64_C(0x00000000000063e7), UINT64_C(0x1f43068e5cad873c), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd8ed8aac711), UINT64_C(0x1f42f58e3cb28726)
    },
    {   UINT64_C(0x0000000000005a3a), UINT64_C(0x1f4309ce5cb06712), UINT64_C(0x1f42f88e7cac46ff),
        UINT64_C(0x1f42fb8f08b2471f), UINT64_C(0x1f42fb8f08b6c709)
    },
    {   UINT64_C(0x00000000000063e8), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f70ebcb72735)
    },
    {   UINT64_C(0x0000000000005a3b), UINT64_C(0x1f42f8ceacb72713), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd8eacb7a73b), UINT64_C(0x1f42f6cedcb5a707)
    },
    {   UINT64_C(0x00000000000063e9), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42facec8b5873b), UINT64_C(0x1f42fa8ec8b5673b)
    },
    {   UINT64_C(0x0000000000005a3c), UINT64_C(0x1f42f6cf38b00717), UINT64_C(0x1f42f6cebcb3e72d),
        UINT64_C(0x1f42f7ceecb72741), UINT64_C(0x1f42f6ceccb866ff)
    },
    {   UINT64_C(0x00000000000063ea), UINT64_C(0x1f42fd0e6cb2e72d), UINT64_C(0x1f4301ce9cb5072c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4303cedcb20715)
    },
    {   UINT64_C(0x0000000000005a3d), UINT64_C(0x1f42f8d014b686f0), UINT64_C(0x1f42f8cee8b6470b),
        UINT64_C(0x1f42f78e6cb6c70e), UINT64_C(0x1f42f78f58b5a713)
    },
    {   UINT64_C(0x00000000000063eb), UINT64_C(0x0000000000000000), UINT64_C(0x1f43040eb8b2071e),
        UINT64_C(0x1f42ffcedcb20715), UINT64_C(0x1f42f9ce9cb5072c)
    },
    {   UINT64_C(0x0000000000005a3e), UINT64_C(0x1f43094e4cb5c705), UINT64_C(0x1f42f6ce6cb1e735),
        UINT64_C(0x1f42facf68b26727), UINT64_C(0x1f430e8e9cb2673e)
    },
    {   UINT64_C(0x00000000000063ec), UINT64_C(0x1f42f98efcb62702), UINT64_C(0x1f42fc8e34b2a713),
        UINT64_C(0x1f43094e68b40740), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005a3f), UINT64_C(0x1f43044ee8b4e714), UINT64_C(0x1f43054ea8b3271f),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c92d), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x000000000000c92e), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x00000000000063ee), UINT64_C(0x0000000000000000), UINT64_C(0x1f4302cf50b0c6f5),
        UINT64_C(0x1f42fe4f60b366ee), UINT64_C(0x1f42fdcf60b3871e)
    },
    {   UINT64_C(0x000000000000c930), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x000000000000c931), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x000000000000c932), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x00000000000063f0), UINT64_C(0x0000000000000000), UINT64_C(0x1f4305cf40b0a6ed),
        UINT64_C(0x1f4305cfd4b5e6e7), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c934), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x000000000000c935), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x000000000000c936), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x000000000000c937), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x000000000000c938), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x000000000000c939), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x000000000000c93a), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063f4), UINT64_C(0x1f43080fa0b2c6f6), UINT64_C(0x1f43020f04b386f3),
        UINT64_C(0x1f43014f00b3c70c), UINT64_C(0x1f42fbcf64b42709)
    },
    {   UINT64_C(0x0000000000005a47), UINT64_C(0x1f42f4cf28b8271f), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f88f28ac070c)
    },
    {   UINT64_C(0x00000000000063f5), UINT64_C(0x1f42fd0f1cb4c6df), UINT64_C(0x1f43044f58b106e5),
        UINT64_C(0x1f4306cf34aee6d5), UINT64_C(0x1f4301cf08b186d4)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063f6), UINT64_C(0x1f43034f60b1a6e7), UINT64_C(0x1f43064fb0b22703),
        UINT64_C(0x1f43008f50b26708), UINT64_C(0x1f43010f68b186fa)
    },
    {   UINT64_C(0x000000000000c940), UINT64_C(0x1622eb53cc98653c), UINT64_C(0x0000000000000000),
        UINT64_C(0x15c33c0ae46ea776), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063f7), UINT64_C(0x1f43068f74b2e6ef), UINT64_C(0x1f4303cf38ae071c),
        UINT64_C(0x1f43020f34af0720), UINT64_C(0x1f43038f74b346ea)
    },
    {   UINT64_C(0x0000000000005a4a), UINT64_C(0x1f42f64ec0b76717), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f7cf28b4271f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c943), UINT64_C(0x16233d8ae498853c), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c944), UINT64_C(0x1622eb4ae46f453c), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c945), UINT64_C(0x16233d93cc988776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c946), UINT64_C(0x1622eb53cc6f4776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c947), UINT64_C(0x16233d8ae4988776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005a4d), UINT64_C(0x1f42f6cef8b6c70b), UINT64_C(0x1f42f6ce8cb786fc),
        UINT64_C(0x1f42f84f0cb66718), UINT64_C(0x1f42f60eccb6c70f)
    },
    {   UINT64_C(0x000000000000c949), UINT64_C(0x1622eb4ae46f4776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005a4e), UINT64_C(0x1f42f78f28b5a6ff), UINT64_C(0x1f42fc8f58b0272d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f70e9cb506ff)
    },
    {   UINT64_C(0x000000000000c94b), UINT64_C(0x1622eb4ae498653c), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005371), UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721),
        UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721)
    },
    {   UINT64_C(0x0000000000005372), UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721),
        UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721)
    },
    {   UINT64_C(0x0000000000005373), UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721),
        UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721)
    },
    {   UINT64_C(0x0000000000005374), UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721),
        UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721)
    },
    {   UINT64_C(0x0000000000005375), UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721),
        UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721)
    },
    {   UINT64_C(0x0000000000005376), UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721),
        UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721)
    },
    {   UINT64_C(0x0000000000005377), UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721),
        UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721)
    },
    {   UINT64_C(0x0000000000005378), UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721),
        UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721)
    },
    {   UINT64_C(0x000000000000c954), UINT64_C(0x1622eb5258986599), UINT64_C(0x1623264ae47b0776),
        UINT64_C(0x16233d8ae4988599), UINT64_C(0x1623264ae498853c)
    },
    {   UINT64_C(0x000000000000c955), UINT64_C(0x1623264ae4986599), UINT64_C(0x1622eb4ae46f4599),
        UINT64_C(0x1622eb4ae47ae53c), UINT64_C(0x1622eb4ae47ae599)
    },
    {   UINT64_C(0x000000000000c956), UINT64_C(0x16233d9258988776), UINT64_C(0x16232653cc988776),
        UINT64_C(0x1623265258986776), UINT64_C(0x1622eb52586f4776)
    },
    {   UINT64_C(0x000000000000c957), UINT64_C(0x1622eb53cc7ae776), UINT64_C(0x1622eb52587ae776),
        UINT64_C(0x16233d8ae4988776), UINT64_C(0x1623264ae4988776)
    },
    {   UINT64_C(0x000000000000537d), UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721),
        UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721)
    },
    {   UINT64_C(0x000000000000537e), UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721),
        UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721)
    },
    {   UINT64_C(0x000000000000537f), UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721),
        UINT64_C(0x1f42f4cdb8b82721), UINT64_C(0x1f42f4cdb8b82721)
    },
    {   UINT64_C(0x0000000000005380), UINT64_C(0x1f430554a8b2a5c1), UINT64_C(0x1f430f4fe0af86d1),
        UINT64_C(0x1f4307cfd0aec6f6), UINT64_C(0x1f430350a0ac06e3)
    },
    {   UINT64_C(0x0000000000005381), UINT64_C(0x1f42fbd038b4870b), UINT64_C(0x1f42fe8f50b346fd),
        UINT64_C(0x1f430bd23cacc6e0), UINT64_C(0x1f4309cfccb186e3)
    },
    {   UINT64_C(0x0000000000005382), UINT64_C(0x1f430f4f08b76711), UINT64_C(0x1f42ff1120b2e6c0),
        UINT64_C(0x1f43019034b4c6f9), UINT64_C(0x1f43030f54b306eb)
    },
    {   UINT64_C(0x0000000000005383), UINT64_C(0x1f430b8f14b086c1), UINT64_C(0x1f430acf68aca6ce),
        UINT64_C(0x1f43040e64a9a6f1), UINT64_C(0x1f431b4e80a42707)
    },
    {   UINT64_C(0x0000000000005384), UINT64_C(0x1f43120e9ca846ff), UINT64_C(0x1f430790b8b3e6ca),
        UINT64_C(0x1f43070fc8af06d8), UINT64_C(0x1f430aceecac6718)
    },
    {   UINT64_C(0x0000000000005385), UINT64_C(0x1f43009038b526e5), UINT64_C(0x1f4307d090ab66da),
        UINT64_C(0x1f42f69004b746f3), UINT64_C(0x1f42ff9044b2c6f0)
    },
    {   UINT64_C(0x0000000000006407), UINT64_C(0x1f43010f08b3c6f5), UINT64_C(0x1f42fb8ef4b246e9),
        UINT64_C(0x1f43038f50b286f9), UINT64_C(0x1f42fe0eecb1c71e)
    },
    {   UINT64_C(0x0000000000005387), UINT64_C(0x1f43190ee0a82727), UINT64_C(0x1f43105038ac86dd),
        UINT64_C(0x1f43040f90b446f6), UINT64_C(0x1f43008f98b486e4)
    },
    {   UINT64_C(0x0000000000005388), UINT64_C(0x1f43014f0cb1c70e), UINT64_C(0x1f43100f7caa86c1),
        UINT64_C(0x1f43088f98b186fd), UINT64_C(0x1f43094e74ade747)
    },
    {   UINT64_C(0x0000000000005389), UINT64_C(0x1f4316cf84a946cb), UINT64_C(0x1f43008f6ca286fb),
        UINT64_C(0x1f43068fc8b2471e), UINT64_C(0x1f430b4f74b2e715)
    },
    {   UINT64_C(0x000000000000538a), UINT64_C(0x1f43568f3880e703), UINT64_C(0x1f433b4f3094c713),
        UINT64_C(0x1f43078f48b6a701), UINT64_C(0x1f43274f28a20705)
    },
    {   UINT64_C(0x000000000000538b), UINT64_C(0x1f43328f388aa6f8), UINT64_C(0x1f43188e88a7472d),
        UINT64_C(0x1f4301cea8b1e6e0), UINT64_C(0x1f4320cf34a50715)
    },
    {   UINT64_C(0x000000000000538c), UINT64_C(0x1f430d4e7caf2734), UINT64_C(0x1f430f0e7cab4720),
        UINT64_C(0x1f43224e98a46734), UINT64_C(0x1f431b4e40a74736)
    },
    {   UINT64_C(0x000000000000538d), UINT64_C(0x1f430bcf48ab6704), UINT64_C(0x1f43058eb0afc74a),
        UINT64_C(0x1f434a565c8946a5), UINT64_C(0x1f4336d61097263f)
    },
    {   UINT64_C(0x000000000000538e), UINT64_C(0x1f430bcfacb786fc), UINT64_C(0x1f4303ce88b3e6e4),
        UINT64_C(0x1f4306cf6ca54721), UINT64_C(0x1f43074fccb4c70e)
    },
    {   UINT64_C(0x000000000000538f), UINT64_C(0x1f43048e6cb2e72c), UINT64_C(0x1f43138f58aa06c8),
        UINT64_C(0x1f42fe4e8cb80707), UINT64_C(0x1f42f7d01c6566d8)
    },
    {   UINT64_C(0x0000000000005390), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4308d0c8b466e5), UINT64_C(0x1f43020f78a8a6ec)
    },
    {   UINT64_C(0x0000000000005391), UINT64_C(0x0000000000000000), UINT64_C(0x1f430acf98b426f4),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe4fb0b546f4)
    },
    {   UINT64_C(0x0000000000005392), UINT64_C(0x1f43175074a5c6ec), UINT64_C(0x1f430e4fbcb3268a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa4fe8b686fc)
    },
    {   UINT64_C(0x0000000000005393), UINT64_C(0x1f43094ec8a7c72d), UINT64_C(0x1f430acec8a5a730),
        UINT64_C(0x1f43058e50b4c72e), UINT64_C(0x1f4305cfb0b56709)
    },
    {   UINT64_C(0x000000000000c96f), UINT64_C(0x0000000000000000), UINT64_C(0x23caf6cda4c94713),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000c970), UINT64_C(0x0000000000000000), UINT64_C(0x209af6cb30b826ff),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005396), UINT64_C(0x1f430a4e6cb74734), UINT64_C(0x1f4319d018ad26c7),
        UINT64_C(0x1f430d9048abc6cd), UINT64_C(0x1f430d58bcabe6e6)
    },
    {   UINT64_C(0x000000000000c972), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x18b2f94b1c9ba703), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005398), UINT64_C(0x1f431e900c9e46e3), UINT64_C(0x1f432e8f2896a708),
        UINT64_C(0x1f42f98fd8b1c6d1), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005399), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4313cec8ab6706), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000539a), UINT64_C(0x0000000000000000), UINT64_C(0x1f43054fd8b1c6db),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000539c), UINT64_C(0x1f43170f88a7a6ca), UINT64_C(0x1f42fd5018b5c704),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd0ef8b46718)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x07b0b40002690011), UINT64_C(0x1692ec0fa0960675), UINT64_C(0x131aedcfa08dc675),
        UINT64_C(0x131af00fa08f2675), UINT64_C(0x1692fb0f5898c682)
    },
    {   UINT64_C(0x000000000000539f), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc8ef8b50721), UINT64_C(0x1f4309cf0caf0710)
    },
    {   UINT64_C(0x000000000000c97b), UINT64_C(0x23caf6cda4c94713), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000053a1), UINT64_C(0x1f43010f44b28716), UINT64_C(0x1f43534f0c88e6f4),
        UINT64_C(0x1f43224f78a026f2), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000053a2), UINT64_C(0x1f4301ce9cb2271b), UINT64_C(0x1f43058eb8b34736),
        UINT64_C(0x1f430c0e48b06733), UINT64_C(0x1f430c4e44afc733)
    },
    {   UINT64_C(0x00000000000053a3), UINT64_C(0x1f42fe9204b4a672), UINT64_C(0x1f430a4e84af26e9),
        UINT64_C(0x1f43038f10b286fd), UINT64_C(0x1f43078f4caf06c2)
    },
    {   UINT64_C(0x00000000000053a4), UINT64_C(0x0000000000000000), UINT64_C(0x1f430b5074b206c5),
        UINT64_C(0x1f43019034b146eb), UINT64_C(0x1f430b4ee8b386d2)
    },
    {   UINT64_C(0x00000000000053a5), UINT64_C(0x1f42f9d050b606d3), UINT64_C(0x1f43078e8cb0e734),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000053a6), UINT64_C(0x1f4306505caf66ee), UINT64_C(0x1f43099060b2c6e9),
        UINT64_C(0x1f430b100caf66c1), UINT64_C(0x1f4308cf84b1471a)
    },
    {   UINT64_C(0x00000000000053a7), UINT64_C(0x1f43098fc8adc6ff), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4303cfd0b32707), UINT64_C(0x1f43088fd0b246e0)
    },
    {   UINT64_C(0x00000000000053a8), UINT64_C(0x1f43115460aba630), UINT64_C(0x1f430790b0b406fb),
        UINT64_C(0x1f43084f68b04721), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000053a9), UINT64_C(0x1f430b4f80b12718), UINT64_C(0x1f430dcf34afa71b),
        UINT64_C(0x1f4314cf2cae4721), UINT64_C(0x1f43040f54a1271b)
    },
    {   UINT64_C(0x00000000000053aa), UINT64_C(0x1f43104e48af673e), UINT64_C(0x1f43068f8caf8715),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430b8e78b2673b)
    },
    {   UINT64_C(0x00000000000053ab), UINT64_C(0x1f430a4ee0b08731), UINT64_C(0x1f430d4e98b2873b),
        UINT64_C(0x1f43150ea0b26722), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000053ac), UINT64_C(0x1f43074f00aee731), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430e4ef0a92716), UINT64_C(0x1f430c8ea0ac073a)
    },
    {   UINT64_C(0x00000000000053ad), UINT64_C(0x0000000000000000), UINT64_C(0x1f43070e98b32722),
        UINT64_C(0x1f43110eb8b08728), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000053ae), UINT64_C(0x0000000000000000), UINT64_C(0x1f43098ebcb06725),
        UINT64_C(0x1f42fa50a4b786cd), UINT64_C(0x1f43440f8890a6fd)
    },
    {   UINT64_C(0x00000000000053af), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43050f80b006fa)
    },
    {   UINT64_C(0x00000000000053b0), UINT64_C(0x1f43070ea8af0720), UINT64_C(0x1f43080facae8707),
        UINT64_C(0x1f430c4f8cac4725), UINT64_C(0x1f43088ee8ae4702)
    },
    {   UINT64_C(0x00000000000053b1), UINT64_C(0x1f42fa9010b3c6d2), UINT64_C(0x1f43008f90b22700),
        UINT64_C(0x1f430a4edcad671f), UINT64_C(0x1f42fd8fe8b3c715)
    },
    {   UINT64_C(0x00000000000053b2), UINT64_C(0x1f42f5cfacb78706), UINT64_C(0x1f42f60f78b7a6fc),
        UINT64_C(0x1f42fa0eccb7c728), UINT64_C(0x1f4300ce50b8c711)
    },
    {   UINT64_C(0x00000000000053b3), UINT64_C(0x0000000000000000), UINT64_C(0x1f43028fa4b14704),
        UINT64_C(0x1f42f90fd8b826e0), UINT64_C(0x1f4303cfe4b0a713)
    },
    {   UINT64_C(0x00000000000053b4), UINT64_C(0x0000000000000000), UINT64_C(0x1f4301cf40b78713),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4301cf48b68715)
    },
    {   UINT64_C(0x00000000000053b5), UINT64_C(0x1f42f9cf2cb5a702), UINT64_C(0x1f4300cf9cb22702),
        UINT64_C(0x1f42fa0fd4b58710), UINT64_C(0x1f42facfacb52711)
    },
    {   UINT64_C(0x2ad526a49419001d), UINT64_C(0x08b2f78f7463860a), UINT64_C(0x0fa2f88f7479e5a1),
        UINT64_C(0x0de2f30f5873c5a1), UINT64_C(0x14daf1cf588f85a1)
    },
    {   UINT64_C(0x0000000000005a72), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f70f0cb9a700),
        UINT64_C(0x1f43104eecb02714), UINT64_C(0x1f42f7ce60b6473d)
    },
    {   UINT64_C(0x000000b2d631001e), UINT64_C(0x0de2e74f747665a1), UINT64_C(0x0de2e80c6873c5a1),
        UINT64_C(0x0c2aed8e5c6e0594), UINT64_C(0x0c82faccdc716697)
    },
    {   UINT64_C(0x00000000000053b9), UINT64_C(0x1f4301cf0cb7c72e), UINT64_C(0x1f4315d118ad26c3),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000053ba), UINT64_C(0x1f42f78f68b6c6f6), UINT64_C(0x1f42fc0f74b4a6f8),
        UINT64_C(0x1f42fbcfb8b4c709), UINT64_C(0x1f43070fb8af0709)
    },
    {   UINT64_C(0x00000000000053bb), UINT64_C(0x1f4306cf38af2711), UINT64_C(0x1f42f58fc0b7c70c),
        UINT64_C(0x1f42f40fc8b8870f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000053bc), UINT64_C(0x1f42ffce8cb2a714), UINT64_C(0x1f42fa8f18b546e2),
        UINT64_C(0x1f4303ce98b0c720), UINT64_C(0x1f42f90f9cb60702)
    },
    {   UINT64_C(0x00000000000053bd), UINT64_C(0x1f430e8f40ab4709), UINT64_C(0x1f42fa4eacb56710),
        UINT64_C(0x1f42fe8ec8b34719), UINT64_C(0x1f42fb0f24b50710)
    },
    {   UINT64_C(0x00000000000053be), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbcfd4b4a710)
    },
    {   UINT64_C(0x00000000000053bf), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f38f2cb8c714),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43004f90b24710)
    },
    {   UINT64_C(0x000000000000c99b), UINT64_C(0x0000000000000000), UINT64_C(0x0dab038f8c6f26cc),
        UINT64_C(0x0f53064c586fa71a), UINT64_C(0x0f52fb0c5875471a)
    },
    {   UINT64_C(0x00000000000053c1), UINT64_C(0x1f43018ee8b1c6fd), UINT64_C(0x1f42fe0f60b386f3),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000053c2), UINT64_C(0x1f42facf78b146f8), UINT64_C(0x1f42f8cfa0b60712),
        UINT64_C(0x1f42f70f90b6e700), UINT64_C(0x1f430b0f80b7a6fa)
    },
    {   UINT64_C(0x00000000000053c3), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fad004b5c6fa),
        UINT64_C(0x1f42f80f6cb5a71e), UINT64_C(0x1f42f94f78b806fb)
    },
    {   UINT64_C(0x00000000000053c4), UINT64_C(0x1f42f90ea0b28708), UINT64_C(0x1f42fa0eccb64727),
        UINT64_C(0x1f42fece5cb026ed), UINT64_C(0x1f42fdcf88ada6e4)
    },
    {   UINT64_C(0x00000000000053c5), UINT64_C(0x1f42fa0f48b5e6ea), UINT64_C(0x1f42f80f88b5c70f),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4305cfe0b5c6fc)
    },
    {   UINT64_C(0x00000000000053c6), UINT64_C(0x1f42fa0f48b2c6f0), UINT64_C(0x1f42fdcf58b6a6f7),
        UINT64_C(0x1f4302cf44b84709), UINT64_C(0x1f42f90f88ae4712)
    },
    {   UINT64_C(0x00000000000053c7), UINT64_C(0x1f42fdcf70b3a724), UINT64_C(0x1f42fdcf78afa6e9),
        UINT64_C(0x1f4306ce7cb7270d), UINT64_C(0x1f42fe0f08af0718)
    },
    {   UINT64_C(0x00000000000053c8), UINT64_C(0x1f42fd8f1cb00716), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fccea4ae86dd), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000053c9), UINT64_C(0x1f42facf40a546fd), UINT64_C(0x1f42fccf58b4a6eb),
        UINT64_C(0x1f42fdcf98b6c6f7), UINT64_C(0x1f42fbcf88b546f6)
    },
    {   UINT64_C(0x00000000000053ca), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fecf88abe70c), UINT64_C(0x1f42fbcfa4ad4704)
    },
    {   UINT64_C(0x00000000000053cb), UINT64_C(0x1f42facf38b8a6f3), UINT64_C(0x1f42f8cf48af0706),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fccfc0a98701)
    },
    {   UINT64_C(0x00000000000053cc), UINT64_C(0x1f42fecf88b426ef), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fccff4b0c702), UINT64_C(0x1f42f8cf78b466f2)
    },
    {   UINT64_C(0x00000000000053cd), UINT64_C(0x1f42fbce7cb2e725), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f90ee8b7a722), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000053ce), UINT64_C(0x1f42fdce88ae4720), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f80ed8a706fd), UINT64_C(0x1f42feced8b28706)
    },
    {   UINT64_C(0x00000000000053cf), UINT64_C(0x1f42f8cf48b3c702), UINT64_C(0x1f42f7cf78b24704),
        UINT64_C(0x1f42fbcf88afe706), UINT64_C(0x1f42f90f88adc6f9)
    },
    {   UINT64_C(0x00000000000053d0), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fccf48a906ec),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f20f98ae870c)
    },
    {   UINT64_C(0x00000000000053d1), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa0ff4b7a715), UINT64_C(0x1f42f90eb8b4872d)
    },
    {   UINT64_C(0x000000000000642d), UINT64_C(0x1f43010e9caf26ce), UINT64_C(0x1f4300ce7cae06ff),
        UINT64_C(0x1f42fb0eacb2c724), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000053d3), UINT64_C(0x1f43038f98b5c6de), UINT64_C(0x1f42fad014b366fb),
        UINT64_C(0x1f42fbcf58b56706), UINT64_C(0x1f42ffcf68b2c6f5)
    },
    {   UINT64_C(0x00000000000053d4), UINT64_C(0x1f42f90f0cb1c6fd), UINT64_C(0x1f42f9cfb8b386f2),
        UINT64_C(0x1f42facf88b306fd), UINT64_C(0x1f42fbceecb7271e)
    },
    {   UINT64_C(0x00000000000053d5), UINT64_C(0x1f42facf58aa66f9), UINT64_C(0x1f42f50eb0b4e719),
        UINT64_C(0x1f4301cf48b446e2), UINT64_C(0x1f42fe8f90af4709)
    },
    {   UINT64_C(0x00000000000053d6), UINT64_C(0x1f4302cef8b4e72d), UINT64_C(0x1f4304ceb0b88736),
        UINT64_C(0x1f42f90f78b92717), UINT64_C(0x1f42f90e78b38744)
    },
    {   UINT64_C(0x00000000000053d7), UINT64_C(0x1f42face78aea736), UINT64_C(0x1f42fcceb4aac722),
        UINT64_C(0x1f42fbcef4b4e6ea), UINT64_C(0x1f42f9cf08b6e71d)
    },
    {   UINT64_C(0x00000000000053d8), UINT64_C(0x1f42fbcef4ad6729), UINT64_C(0x1f42facf74b646f3),
        UINT64_C(0x1f42fbcf78b12702), UINT64_C(0x1f42facf60aa6710)
    },
    {   UINT64_C(0x00000000000053d9), UINT64_C(0x1f42facf8cb466ff), UINT64_C(0x1f4303cfbcb66703),
        UINT64_C(0x1f42fbd004ae2711), UINT64_C(0x1f42face88b08707)
    },
    {   UINT64_C(0x00000000000053da), UINT64_C(0x1f42fc8f78b46728), UINT64_C(0x1f42f40ef8b6c715),
        UINT64_C(0x1f42fccfb8ae66ff), UINT64_C(0x1f42fdcf2cb766eb)
    },
    {   UINT64_C(0x00000000000053db), UINT64_C(0x1f42f80fb4b38706), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fbcf58b726e4), UINT64_C(0x1f42fa0ec8b4c739)
    },
    {   UINT64_C(0x00000000000053dc), UINT64_C(0x1f42f5cfb8afa703), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fecf48b1670d)
    },
    {   UINT64_C(0x00000000000053dd), UINT64_C(0x1f42f90e7cb2270c), UINT64_C(0x1f42fd8ea8b20730),
        UINT64_C(0x1f42f70fa8aa270a), UINT64_C(0x1f42f80eccb726f5)
    },
    {   UINT64_C(0x00000000000053de), UINT64_C(0x1f42facf98ae46fe), UINT64_C(0x1f42fb0f3cb0870f),
        UINT64_C(0x1f4303cf0cb7a707), UINT64_C(0x1f42f5cfb8b6870e)
    },
    {   UINT64_C(0x00000000000053df), UINT64_C(0x1f42fa0fc4b266f5), UINT64_C(0x1f42fccf88b246f8),
        UINT64_C(0x1f42f80eccb8670d), UINT64_C(0x1f42fa0f3cb5071a)
    },
    {   UINT64_C(0x00000000000053e0), UINT64_C(0x1f42fdcefcab46eb), UINT64_C(0x1f42f70f20b5e704),
        UINT64_C(0x1f42fccfd4b2a6fb), UINT64_C(0x1f42facfa8b746ff)
    },
    {   UINT64_C(0x00000000000053e1), UINT64_C(0x1f42f80f98ad0708), UINT64_C(0x1f42f90f50a946f2),
        UINT64_C(0x1f43038e9cb5c736), UINT64_C(0x1f42fccf48af6713)
    },
    {   UINT64_C(0x00000000000053e2), UINT64_C(0x1f42fbcf18aa673d), UINT64_C(0x1f42faced4b4c70d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f9cef4aa4708)
    },
    {   UINT64_C(0x00000000000053e3), UINT64_C(0x0000000000000000), UINT64_C(0x1f4301ce84b5e725),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f70eacba6739)
    },
    {   UINT64_C(0x00000000000053e4), UINT64_C(0x1f42f90f88b6a714), UINT64_C(0x1f42fecef4af871b),
        UINT64_C(0x1f42facf14ad06e6), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000053e5), UINT64_C(0x1f42fb0e6caf270e), UINT64_C(0x1f42fbcfb4ac06e7),
        UINT64_C(0x1f42ffceecb6a70a), UINT64_C(0x1f42f80f0ca7a6fe)
    },
    {   UINT64_C(0x00000000000053e6), UINT64_C(0x1f42fecf9cb28706), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ffcec8ab26fb), UINT64_C(0x1f42f9cfa8b3e719)
    },
    {   UINT64_C(0x00000000000053e7), UINT64_C(0x1f42f70ed8b08717), UINT64_C(0x1f42fecf44b7e70d),
        UINT64_C(0x1f42f80f38b5a6e0), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000053e8), UINT64_C(0x1f42fbcf98b24708), UINT64_C(0x1f42fe4fd0b366fc),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42facfd4a886fc)
    },
    {   UINT64_C(0x00000000000053e9), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0fb8b10717),
        UINT64_C(0x1f42fdcee0a98719), UINT64_C(0x1f42f7cf40ab070c)
    },
    {   UINT64_C(0x00000000000053ea), UINT64_C(0x1f42f94f08b7a6f6), UINT64_C(0x1f42fbcf88b4c706),
        UINT64_C(0x1f42fb0ef8b5e707), UINT64_C(0x1f42fe8f68b32708)
    },
    {   UINT64_C(0x00000000000053eb), UINT64_C(0x1f42fccf24b70712), UINT64_C(0x1f42facff4b52710),
        UINT64_C(0x1f42facee8b5a713), UINT64_C(0x1f42fbcf80b64702)
    },
    {   UINT64_C(0x00000000000053ec), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42facfb0b586f4), UINT64_C(0x1f42f90f78afe6e6)
    },
    {   UINT64_C(0x00000000000053ed), UINT64_C(0x0000000000000000), UINT64_C(0x1f42facf20b6e6f2),
        UINT64_C(0x1f42facfa4ab270c), UINT64_C(0x1f42fdcf64ad870e)
    },
    {   UINT64_C(0x00000000000053ee), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fecf64b32700),
        UINT64_C(0x1f42fbcf1cb7a70b), UINT64_C(0x1f42fccf68b686f5)
    },
    {   UINT64_C(0x00000000000053ef), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f70f7cb88700)
    },
    {   UINT64_C(0x00000000000053f0), UINT64_C(0x1f42f70ee0b646f3), UINT64_C(0x1f42f60f9cb346db),
        UINT64_C(0x1f42ffcf3cb0671a), UINT64_C(0x1f42facfe4b7e708)
    },
    {   UINT64_C(0x00000000000053f1), UINT64_C(0x1f42fbce78b34721), UINT64_C(0x1f42f80ea8b7a700),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f70f90b466dd)
    },
    {   UINT64_C(0x00000000000053f2), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90f0cb306ea),
        UINT64_C(0x1f42fccf2cb7a71a), UINT64_C(0x1f42fd8f88af26e7)
    },
    {   UINT64_C(0x00000000000053f3), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80f1cb4c706),
        UINT64_C(0x1f42fb1008b8c6d4), UINT64_C(0x1f42fdcefcaca70e)
    },
    {   UINT64_C(0x39d734000001003c), UINT64_C(0x0fa2f4cf747ac693), UINT64_C(0x0fa2f18f7c7b8658),
        UINT64_C(0x0fa2f4cf74790680), UINT64_C(0x0fa2f4cf74790680)
    },
    {   UINT64_C(0x00000000000053f5), UINT64_C(0x1f42f40f68b4c700), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f90f2cad86e4), UINT64_C(0x1f42fccf48bb06fd)
    },
    {   UINT64_C(0x00000000000053f6), UINT64_C(0x1f42f10ed4b26734), UINT64_C(0x1f42f90e1caf871e),
        UINT64_C(0x1f42f70fc4b2c702), UINT64_C(0x1f42f90fa0b30710)
    },
    {   UINT64_C(0x0600bc0002b83d40), UINT64_C(0x106af6cfa07ba5f5), UINT64_C(0x106af40fa07c05e8),
        UINT64_C(0x106af94fa07a85f5), UINT64_C(0x106aee8fa07a85e8)
    },
    {   UINT64_C(0x00000000000053f8), UINT64_C(0x1f42fdcf78b7a70f), UINT64_C(0x1f42facf98b3071a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f70f90b0e701)
    },
    {   UINT64_C(0x00000000000053f9), UINT64_C(0x1f430f4edcb58727), UINT64_C(0x1f43078f10b98714),
        UINT64_C(0x1f42f80ee4ace720), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000053fa), UINT64_C(0x1f42f80f14a886fc), UINT64_C(0x1f42fdcf98ad86f9),
        UINT64_C(0x1f42fbcfd4a8270a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000053fb), UINT64_C(0x1f42f9cf74b206e3), UINT64_C(0x1f42fdcf88b5c6fe),
        UINT64_C(0x1f42fcce80b7473a), UINT64_C(0x1f42f70ebcb4070e)
    },
    {   UINT64_C(0x00000000000053fc), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fdcf48b7a6fb),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80f48b2c716)
    },
    {   UINT64_C(0x00000000000053fd), UINT64_C(0x1f42f60e58b1c707), UINT64_C(0x1f42f20ea8b8a740),
        UINT64_C(0x1f42f40f68b9870c), UINT64_C(0x1f42f60f40b7c6d1)
    },
    {   UINT64_C(0x00000000000053fe), UINT64_C(0x1f42fbce5cb88741), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f90f24bac728), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000053ff), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ffce8cb7a732), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005400), UINT64_C(0x1f42fccfa4b7e71e), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005401), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbceb8b16732),
        UINT64_C(0x1f42f8cf7cae870e), UINT64_C(0x1f42fccf58b4e703)
    },
    {   UINT64_C(0x0000000000005402), UINT64_C(0x0000000000000000), UINT64_C(0x1f430b8f0cb6a734),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fdcfd8ac2727)
    },
    {   UINT64_C(0x0000000000005403), UINT64_C(0x1f42f30f28b0872a), UINT64_C(0x1f42fa0f8cb5c706),
        UINT64_C(0x1f42f60f4cb16700), UINT64_C(0x1f42f30f74b7a71f)
    },
    {   UINT64_C(0x0000000000005404), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f70f14ace716),
        UINT64_C(0x1f42facf10ac6705), UINT64_C(0x1f42fa0f34aee700)
    },
    {   UINT64_C(0x0000000000003d47), UINT64_C(0x106af20df47ec5e8), UINT64_C(0x106af30df47e65f3),
        UINT64_C(0x106b208df466e453), UINT64_C(0x106af78fa07b25e8)
    },
    {   UINT64_C(0x0000000000005406), UINT64_C(0x1f42facefcaee700), UINT64_C(0x1f42fbcfd4b446fc),
        UINT64_C(0x1f42fa0e80b5c741), UINT64_C(0x1f42f60ed4b4e726)
    },
    {   UINT64_C(0x0000000000005407), UINT64_C(0x1f42f60f34aa6729), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f90ef0ad670e), UINT64_C(0x1f42f70f1cb4672a)
    },
    {   UINT64_C(0x0000000000006448), UINT64_C(0x1f4304ceb8b40714), UINT64_C(0x1f42fdceacb2c731),
        UINT64_C(0x1f42ff8ec8aec709), UINT64_C(0x1f4304ce5caf0713)
    },
    {   UINT64_C(0x0000000000005409), UINT64_C(0x1f42fecf38b7070e), UINT64_C(0x1f42f7cfb4b1070a),
        UINT64_C(0x1f42facf0cb86719), UINT64_C(0x1f42f40e64b2870b)
    },
    {   UINT64_C(0x0000000000006449), UINT64_C(0x1f43070e8cb266fb), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43040e7cb1871f), UINT64_C(0x1f42f90e9cb44716)
    },
    {   UINT64_C(0x000000000000540b), UINT64_C(0x1f42f80e9cb26721), UINT64_C(0x1f42f90f68b2c71b),
        UINT64_C(0x1f42f9cee4b5c6fb), UINT64_C(0x1f42f8cf1cb88706)
    },
    {   UINT64_C(0x000000000000644a), UINT64_C(0x1f43128e98b2672d), UINT64_C(0x1f430a8eb8afa6f9),
        UINT64_C(0x1f43094ed8b0e70e), UINT64_C(0x1f43068e8cb0e727)
    },
    {   UINT64_C(0x000000000000540d), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90ed0b46725),
        UINT64_C(0x1f42f80f68b02700), UINT64_C(0x1f42f50e2cb7a710)
    },
    {   UINT64_C(0x000000000000540e), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f78ef0b6c728),
        UINT64_C(0x1f42f94f08b0e731), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000540f), UINT64_C(0x1f42fb0f38b4e6f7), UINT64_C(0x1f42f80f24b6a722),
        UINT64_C(0x1f42f80f7cab0715), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005410), UINT64_C(0x1f42fd0f94afe701), UINT64_C(0x1f42fd0eacb16705),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f30f88b3a71a)
    },
    {   UINT64_C(0x0000000000005411), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe0f48af46fd),
        UINT64_C(0x1f42fdcef4b6a6f2), UINT64_C(0x1f42f9cf98b9070c)
    },
    {   UINT64_C(0x0000000000005412), UINT64_C(0x1f4300ceb4ace6fc), UINT64_C(0x1f42fece7cb32743),
        UINT64_C(0x1f43000edcaaa6ed), UINT64_C(0x1f42fd0eccae06d5)
    },
    {   UINT64_C(0x0000000000005413), UINT64_C(0x1f42f90f8cb3e737), UINT64_C(0x1f42fbcf60b406f8),
        UINT64_C(0x1f42f8cfa0b6e70c), UINT64_C(0x1f42f70ed8ae66f8)
    },
    {   UINT64_C(0x000000000001004c), UINT64_C(0x0a6aec0fa06e871a), UINT64_C(0x08b2f9cf745be5a1),
        UINT64_C(0x1772ec0f58a06675), UINT64_C(0x0fa2fa4c647d0676)
    },
    {   UINT64_C(0x0000000000005415), UINT64_C(0x0000000000000000), UINT64_C(0x1f42facf00b4e73b),
        UINT64_C(0x1f42f88f50b62725), UINT64_C(0x1f4300cee0aaa6df)
    },
    {   UINT64_C(0x0000000000005416), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f9cfc4b806f9), UINT64_C(0x1f42fe0f80aca6e7)
    },
    {   UINT64_C(0x0000000000005417), UINT64_C(0x1f42facea4b5e737), UINT64_C(0x1f42ffce90ab26f7),
        UINT64_C(0x1f42fe0eecae86f2), UINT64_C(0x1f4301cf84af471d)
    },
    {   UINT64_C(0x0000000000005418), UINT64_C(0x1f43000f2cb1c6ee), UINT64_C(0x1f42fecf34af86ff),
        UINT64_C(0x1f42fa0fe8b5c6d8), UINT64_C(0x1f42fd0ee0b0e709)
    },
    {   UINT64_C(0x0000000000005419), UINT64_C(0x1f4301cf8cac0712), UINT64_C(0x1f42fa0ebcb68721),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000541a), UINT64_C(0x1f4300ceecb066f5), UINT64_C(0x1f42fd0ee0a6c720),
        UINT64_C(0x1f42fbcf40ad66f1), UINT64_C(0x1f42fdcebcb06701)
    },
    {   UINT64_C(0x0000000000005aa4), UINT64_C(0x1f42f88e90ae872f), UINT64_C(0x1f42fa8f20b266fb),
        UINT64_C(0x1f430ece78afe71d), UINT64_C(0x1f42f20f28b906ec)
    },
    {   UINT64_C(0x000000000000541c), UINT64_C(0x1f43010f60af670d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fecfecb08702), UINT64_C(0x1f43000f48ac670f)
    },
    {   UINT64_C(0x000000000000541d), UINT64_C(0x1f42f7cf40ab070c), UINT64_C(0x1f42fecee0a9872c),
        UINT64_C(0x1f42fbcf5cb0c702), UINT64_C(0x1f42fcce8cb86739)
    },
    {   UINT64_C(0x0000000000006453), UINT64_C(0x1f4308cf64af6705), UINT64_C(0x1f430c0ffcb506cc),
        UINT64_C(0x1f4307cf2cae26e9), UINT64_C(0x1f4302d098b3e6eb)
    },
    {   UINT64_C(0x000000000000541f), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0ef0b58729),
        UINT64_C(0x1f42fa0f18ae8723), UINT64_C(0x1f42fe0f90ae8719)
    },
    {   UINT64_C(0x0000000000005420), UINT64_C(0x1f42f90f68b82716), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd0eecb3c708), UINT64_C(0x1f42ff0ed0b0671a)
    },
    {   UINT64_C(0x0000000000005421), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0e8cb6c738),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0e2cb4a729)
    },
    {   UINT64_C(0x0000000000010053), UINT64_C(0x1692fd0f5895e6dd), UINT64_C(0x0fa2f4cf747e6607),
        UINT64_C(0x1692fd0f5897274a), UINT64_C(0x0fa2f4cf74812672)
    },
    {   UINT64_C(0x0000000000005423), UINT64_C(0x1f42fb0f28ad46ef), UINT64_C(0x1f42fbce84b48727),
        UINT64_C(0x1f42ff0f00b0e701), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005424), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fccee8ab8702),
        UINT64_C(0x1f42fa0f14b1272b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005425), UINT64_C(0x1f42f94f58b3c736), UINT64_C(0x1f42fc0f78ad6711),
        UINT64_C(0x1f42facf3cb82729), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005426), UINT64_C(0x1f43050e6cb7872d), UINT64_C(0x1f42fdcee0b26719),
        UINT64_C(0x1f42f6cfd4b62703), UINT64_C(0x1f42fa0f5cb34719)
    },
    {   UINT64_C(0x0000000000005427), UINT64_C(0x1f42facf78b0c73a), UINT64_C(0x1f43030eacace6e2),
        UINT64_C(0x1f42f70f68abc714), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000010056), UINT64_C(0x131aeacfa0880753), UINT64_C(0x0c2af94fa073c67f),
        UINT64_C(0x0fa2f24f587e0754), UINT64_C(0x0c2af20f6c70e680)
    },
    {   UINT64_C(0x0000000000005429), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80f74b4e71a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cfa8ae06fe)
    },
    {   UINT64_C(0x000000000000542a), UINT64_C(0x1f42fd0f20aea6f3), UINT64_C(0x1f42fa0f84af8709),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000542b), UINT64_C(0x1f42f90e98b1471e), UINT64_C(0x1f42f80e4cb2c72c),
        UINT64_C(0x1f43020e84ae8732), UINT64_C(0x1f42fbcf58b56731)
    },
    {   UINT64_C(0x000000000000542c), UINT64_C(0x1f4301ceb0aee702), UINT64_C(0x1f42fdcf48b6e6ef),
        UINT64_C(0x1f42fb0fa4b88702), UINT64_C(0x1f42fdce2cb46740)
    },
    {   UINT64_C(0x000000000000542d), UINT64_C(0x1f42fc0fa4b126f5), UINT64_C(0x1f42f90e70b38734),
        UINT64_C(0x1f42facf04b76706), UINT64_C(0x1f42fbce60b1872e)
    },
    {   UINT64_C(0x000000000000542e), UINT64_C(0x1f42fbcf38b7a70f), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd0eb8b886ee), UINT64_C(0x1f42facea0b38724)
    },
    {   UINT64_C(0x000000000000542f), UINT64_C(0x0000000000000000), UINT64_C(0x1f43010e00b2c72d),
        UINT64_C(0x1f42f80f6cafa721), UINT64_C(0x1f42ff0e98af66f2)
    },
    {   UINT64_C(0x0000000000005430), UINT64_C(0x0000000000000000), UINT64_C(0x1f4301cf48b30707),
        UINT64_C(0x1f42f8cea4b16730), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005431), UINT64_C(0x1f42fece90af66ff), UINT64_C(0x1f42ff8f1cb2c730),
        UINT64_C(0x1f42fecf10b706f6), UINT64_C(0x1f42f7cea0b5c71e)
    },
    {   UINT64_C(0x0000000000005432), UINT64_C(0x1f42fa0f08b766ff), UINT64_C(0x1f4308cf2cb5c721),
        UINT64_C(0x1f42fb0f20b5e6fb), UINT64_C(0x1f42fece50b5e724)
    },
    {   UINT64_C(0x0000000000005433), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0f68b4a6e9),
        UINT64_C(0x1f42f9cf20b36705), UINT64_C(0x1f42fece94b8672a)
    },
    {   UINT64_C(0x0000000000005434), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90f18b7c72c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fcce60b1c70e)
    },
    {   UINT64_C(0x0000000000005435), UINT64_C(0x1f42fa0e34b36735), UINT64_C(0x1f42fbcf60b72733),
        UINT64_C(0x1f42fbcebcb1c72d), UINT64_C(0x1f42f7ce64b4a6f8)
    },
    {   UINT64_C(0x0000000000005436), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa0e98b6c731), UINT64_C(0x1f42f60f30b8a6e8)
    },
    {   UINT64_C(0x0000000000005437), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f60e64b5c703),
        UINT64_C(0x1f42fd0e54b3e70b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005438), UINT64_C(0x1f42fa0eb4b70711), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80f20b5472d)
    },
    {   UINT64_C(0x0000000000005439), UINT64_C(0x1f42f70e7cb2e70b), UINT64_C(0x1f42f80ed4b50740),
        UINT64_C(0x1f42f50fc4b8670e), UINT64_C(0x1f42faced4b06726)
    },
    {   UINT64_C(0x0000000000006461), UINT64_C(0x1f4306cec0b086f5), UINT64_C(0x1f43041024b2070e),
        UINT64_C(0x1f4305cf18b16702), UINT64_C(0x1f4305ce88b26731)
    },
    {   UINT64_C(0x000000000000543b), UINT64_C(0x1f42facf58b286f2), UINT64_C(0x1f42facefcb6e6fd),
        UINT64_C(0x1f42f9cf90b00738), UINT64_C(0x1f42f80e5cb42711)
    },
    {   UINT64_C(0x000000000000543c), UINT64_C(0x1f43040e70b14739), UINT64_C(0x1f42fcced8ae8729),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0ebcb5e6f9)
    },
    {   UINT64_C(0x000000000000543d), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90f1cafc709),
        UINT64_C(0x1f42f80f88b14702), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000543e), UINT64_C(0x1f42f50eb8b4c715), UINT64_C(0x1f42f9cf18ac470b),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42face8cb32721)
    },
    {   UINT64_C(0x000000000000543f), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80f30b3c6e8),
        UINT64_C(0x1f42f80eccb1c714), UINT64_C(0x1f42f90f74b5c719)
    },
    {   UINT64_C(0x0000000000005440), UINT64_C(0x1f42ffceacb1e74c), UINT64_C(0x1f43000e74b2872c),
        UINT64_C(0x1f42fe8e64b6a73c), UINT64_C(0x1f42f70f60b1271d)
    },
    {   UINT64_C(0x0000000000005441), UINT64_C(0x1f42ff8f98b06738), UINT64_C(0x1f42f8cea4b28715),
        UINT64_C(0x1f42f51008b786eb), UINT64_C(0x1f42f60f00b32702)
    },
    {   UINT64_C(0x0000000000005442), UINT64_C(0x1f42f60ec4b8a732), UINT64_C(0x1f42f24f88b86718),
        UINT64_C(0x1f42f8cebcb3e701), UINT64_C(0x1f42facf0cad0749)
    },
    {   UINT64_C(0x0000000000005443), UINT64_C(0x1f42f9cf44b626eb), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005444), UINT64_C(0x1f42f60ee0afa734), UINT64_C(0x1f42fccf1cab46d8),
        UINT64_C(0x1f42facf18b02726), UINT64_C(0x1f42f80f50ad8731)
    },
    {   UINT64_C(0x0000000000005445), UINT64_C(0x1f42face50b24735), UINT64_C(0x1f42fbce38b54725),
        UINT64_C(0x1f42fdcfa4b3a6ef), UINT64_C(0x1f42f41004b806fa)
    },
    {   UINT64_C(0x0000000000005446), UINT64_C(0x1f42fccf0cb5672c), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f60eacb1c745), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005447), UINT64_C(0x1f42fbce7cb1c722), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90eb4b1e73d)
    },
    {   UINT64_C(0x0000000000005448), UINT64_C(0x1f42fa0e9cb62724), UINT64_C(0x1f42f9cf88b22703),
        UINT64_C(0x1f42fbcef0b20710), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005449), UINT64_C(0x1f42fb0e90b7a6f9), UINT64_C(0x1f42ffcea4acc729),
        UINT64_C(0x1f42fbcf18b14722), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000544a), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f70ea0b4c6d4),
        UINT64_C(0x1f42fdcea0b3e72a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000544b), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f40f18b7c6f3),
        UINT64_C(0x1f42f40f28b7a6ef), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000544c), UINT64_C(0x1f42fd0f1caf871e), UINT64_C(0x1f42f40f10b5e6f6),
        UINT64_C(0x1f42f70eecadc722), UINT64_C(0x1f42fbce5cb3073e)
    },
    {   UINT64_C(0x000000000000544d), UINT64_C(0x1f42f30ea0b38721), UINT64_C(0x1f42f90eacb2672c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0efcb4670e)
    },
    {   UINT64_C(0x0000000000010069), UINT64_C(0x0000000000000000), UINT64_C(0x0fc2db4c6c798685),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000544f), UINT64_C(0x1f42f50ebcb68711), UINT64_C(0x1f42fc0ea8ad8725),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43058fbcb646cb)
    },
    {   UINT64_C(0x000000000001006a), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0aa2f5cbfc666695), UINT64_C(0x08b2e08c3863860a)
    },
    {   UINT64_C(0x0000000000005451), UINT64_C(0x1f430a5024b4c6da), UINT64_C(0x1f43088f74b56726),
        UINT64_C(0x1f430d4f9cb4a701), UINT64_C(0x1f4306cf40b56720)
    },
    {   UINT64_C(0x000000000001006b), UINT64_C(0x0000000000000000), UINT64_C(0x09b2f78f74770693),
        UINT64_C(0x0000000000000000), UINT64_C(0x1793078f58aca6e5)
    },
    {   UINT64_C(0x0000000000005453), UINT64_C(0x1f43044f7cb4872d), UINT64_C(0x1f4308cf18b4e72e),
        UINT64_C(0x1f43058ee4afc726), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005454), UINT64_C(0x1f430d0fb0ac06e8), UINT64_C(0x1f43088f88b2070f),
        UINT64_C(0x1f430c4f20b1e716), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005455), UINT64_C(0x1f430d8ec4b30734), UINT64_C(0x1f42ff8f80b4e6e9),
        UINT64_C(0x1f43180fb4b0c726), UINT64_C(0x1f430a8e84b7c73b)
    },
    {   UINT64_C(0x0000000000005456), UINT64_C(0x0000000000000000), UINT64_C(0x1f42facf54b04705),
        UINT64_C(0x1f43110e64b20727), UINT64_C(0x1f42fd8f3cb20719)
    },
    {   UINT64_C(0x0000000000005457), UINT64_C(0x1f4307cf10b48728), UINT64_C(0x1f42fd8f3cb6a71a),
        UINT64_C(0x1f42fd8f40b5671a), UINT64_C(0x1f42fb8f78b706f2)
    },
    {   UINT64_C(0x0000000000005458), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbcf3cb2071a),
        UINT64_C(0x1f42f7cf94b56725), UINT64_C(0x1f42fd8f40b3a717)
    },
    {   UINT64_C(0x0000000000005459), UINT64_C(0x0000000000000000), UINT64_C(0x1f43085094b3c684),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f431d4ee8a3471f)
    },
    {   UINT64_C(0x000000000000545a), UINT64_C(0x1f43028f74b7270c), UINT64_C(0x1f430c0f58ac86de),
        UINT64_C(0x1f42fb4f44b4e72c), UINT64_C(0x1f42fd11c4b926b4)
    },
    {   UINT64_C(0x000000000000545b), UINT64_C(0x1f42f71034b74705), UINT64_C(0x1f430990d0b066d9),
        UINT64_C(0x1f42fd0edcb9a734), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x09412023c0014012), UINT64_C(0x1852e80fa0a26685), UINT64_C(0x0c2ae60fa0714685),
        UINT64_C(0x0fa2e28e14800685), UINT64_C(0x14dae8cfa0964685)
    },
    {   UINT64_C(0x000000000000545d), UINT64_C(0x1f43021000b266d3), UINT64_C(0x1f4304cfb0afe711),
        UINT64_C(0x1f43038f30b28744), UINT64_C(0x1f43070f54b3a700)
    },
    {   UINT64_C(0x1171f40007214014), UINT64_C(0x131ae70fa08b2685), UINT64_C(0x1692f4cc6094e695),
        UINT64_C(0x14dae70fa08c6685), UINT64_C(0x1162ee8f58804695)
    },
    {   UINT64_C(0x000000000000545f), UINT64_C(0x1f4307ce9cb70743), UINT64_C(0x1f43060f20b1a73e),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005460), UINT64_C(0x1f43104ebcaf472c), UINT64_C(0x1f43018fccb806dc),
        UINT64_C(0x1f4316cf94a466e0), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005461), UINT64_C(0x0000000000000000), UINT64_C(0x1f431d8ef8a2871c),
        UINT64_C(0x1f43238f54a0c6e4), UINT64_C(0x1f4303ce44ac872d)
    },
    {   UINT64_C(0x1ff3f87dc0014018), UINT64_C(0x0a6b0357b063a6a1), UINT64_C(0x0fa2e8cf687785b6),
        UINT64_C(0x0fa2ea8f6c7606a3), UINT64_C(0x0de2eccf6c6f85b6)
    },
    {   UINT64_C(0x22240e8040014019), UINT64_C(0x0fa2e8cf6c7f26a3), UINT64_C(0x0de2ef4f6c7045b6),
        UINT64_C(0x0a6ac3cc6c7646a2), UINT64_C(0x0fa2e10c747a25b6)
    },
    {   UINT64_C(0x2330008c5179401a), UINT64_C(0x1162eacf7c7cc6a3), UINT64_C(0x08b2ee8f7c5f4694),
        UINT64_C(0x08b2becc64616695), UINT64_C(0x0fa2e84f807ae6a3)
    },
    {   UINT64_C(0x24e490911211401b), UINT64_C(0x08b2ee8f7c62c6a3), UINT64_C(0x1852ea8f7c98e5b6),
        UINT64_C(0x1162ec8f7c7c45b6), UINT64_C(0x0fa2ed4f6c75a5b6)
    },
    {   UINT64_C(0x2874b295d2a9401c), UINT64_C(0x0fa2d00c6c7645b6), UINT64_C(0x0fa2ee4c6c7965b6),
        UINT64_C(0x0c2ae8cfa06f25b6), UINT64_C(0x0c2ae94f6c6825b6)
    },
    {   UINT64_C(0x2af52ea59449401d), UINT64_C(0x08b2eb4f7c61a63a), UINT64_C(0x1162f1cf7c7c25b6),
        UINT64_C(0x0de2f1cf6c70a5b6), UINT64_C(0x14daf1cf6c8b45b6)
    },
    {   UINT64_C(0x000000b3d649401e), UINT64_C(0x0fa2e2cf6c7925b6), UINT64_C(0x0de2d68c6c6f85b6),
        UINT64_C(0x0c2ae34e686c85a9), UINT64_C(0x0ae2ef0cb4750696)
    },
    {   UINT64_C(0x0000000000005469), UINT64_C(0x1f430c0f10b306fc), UINT64_C(0x1f430f0f6caf06fe),
        UINT64_C(0x1f42ff8f74b2a6f6), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000546a), UINT64_C(0x1f430f0f48ab0703), UINT64_C(0x1f4312cee0a9070c),
        UINT64_C(0x1f43050e5cb36729), UINT64_C(0x1f434d509887c694)
    },
    {   UINT64_C(0x000000000000546b), UINT64_C(0x1f43020ec4b7c735), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430a4f18aa26d4)
    },
    {   UINT64_C(0x000000000000546c), UINT64_C(0x1f43004f04b72721), UINT64_C(0x1f4308cfdcb4e6c6),
        UINT64_C(0x1f43084ee8ace70d), UINT64_C(0x1f430b0f98b2c700)
    },
    {   UINT64_C(0x000000000000546d), UINT64_C(0x1f430b0ec4b3c701), UINT64_C(0x1f4308d048b566cd),
        UINT64_C(0x1f430c0f88a96704), UINT64_C(0x1f4300ceccb8871d)
    },
    {   UINT64_C(0x000000000000546e), UINT64_C(0x0000000000000000), UINT64_C(0x1f430b0fbcb426ec),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43084f24acc716)
    },
    {   UINT64_C(0x000000000000546f), UINT64_C(0x1f42fdcf54b5871a), UINT64_C(0x1f4307ced8a90701),
        UINT64_C(0x1f42fc4f1cb70701), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005470), UINT64_C(0x1f43038f00b1c726), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005471), UINT64_C(0x1f42fd8ea0b54745), UINT64_C(0x1f43024f8cad46da),
        UINT64_C(0x1f430a8f48b34732), UINT64_C(0x1f42ff4f48b5a6ff)
    },
    {   UINT64_C(0x0000000000005472), UINT64_C(0x1f43014eb4b28744), UINT64_C(0x1f430acf00aca70f),
        UINT64_C(0x1f43034ebcb0872d), UINT64_C(0x1f43050f80a5c6f1)
    },
    {   UINT64_C(0x0000000000014029), UINT64_C(0x0fa2e78f78804606), UINT64_C(0x0fa2f64fa08d0685),
        UINT64_C(0x06e2fe8f5851c695), UINT64_C(0x0fa2f70d6477e695)
    },
    {   UINT64_C(0x000000000001007c), UINT64_C(0x08b2cf0c6470267d), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001402b), UINT64_C(0x12f2fad15083e577), UINT64_C(0x0a6aee9238606502),
        UINT64_C(0x175af58f58984695), UINT64_C(0x0a6afad8446fa657)
    },
    {   UINT64_C(0x000000000001402c), UINT64_C(0x0c8302d5e86ca698), UINT64_C(0x11d2f64fa081a620),
        UINT64_C(0x0962ee93e865a693), UINT64_C(0x0962f253c466a693)
    },
    {   UINT64_C(0x0000000000005477), UINT64_C(0x1f4302ce7cb52737), UINT64_C(0x1f43064f98b946dd),
        UINT64_C(0x1f430b0f94ad06b0), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x2e9000000001402e), UINT64_C(0x0a6ada0c385203ed), UINT64_C(0x0962f593e8642693),
        UINT64_C(0x0962fc15e069e695), UINT64_C(0x0fa2f11020790587)
    },
    {   UINT64_C(0x000000000001402f), UINT64_C(0x1772efcf6898a693), UINT64_C(0x1772ebcf6898e693),
        UINT64_C(0x1772efcf68994693), UINT64_C(0x0fa2f58c6c7325d4)
    },
    {   UINT64_C(0x325634bf57914030), UINT64_C(0x14dadd0fa088a79b), UINT64_C(0x14dadd0fa088a79b),
        UINT64_C(0x14dadd0fa088a794), UINT64_C(0x14dadd0fa08b0771)
    },
    {   UINT64_C(0x000000000000547b), UINT64_C(0x0000000000000000), UINT64_C(0x1f43060f44b2071c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430d8fb0b5a6fc)
    },
    {   UINT64_C(0x0000000000014032), UINT64_C(0x14dae74fa090279b), UINT64_C(0x14dae74fa090279b),
        UINT64_C(0x14dae74fa0902794), UINT64_C(0x14dae74fa0902771)
    },
    {   UINT64_C(0x000000000000547d), UINT64_C(0x0000000000000000), UINT64_C(0x1f43139098aca657),
        UINT64_C(0x1f4312d018af46c6), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x36d6d40000014034), UINT64_C(0x1692e64fa0960685), UINT64_C(0x1692e74f649c0771),
        UINT64_C(0x1692f4cf5894e79b), UINT64_C(0x1692f4cf5894e79b)
    },
    {   UINT64_C(0x000000000000547f), UINT64_C(0x1f43124ff4ab46c3), UINT64_C(0x1f43140f8cb146ef),
        UINT64_C(0x1f430b4f8cace6f2), UINT64_C(0x1f43130fa8aa8716)
    },
    {   UINT64_C(0x0000000000005480), UINT64_C(0x1f4308d078a646a6), UINT64_C(0x1f43158feca3c6d9),
        UINT64_C(0x1f43478f0c8d46f4), UINT64_C(0x1f4311d084a666b7)
    },
    {   UINT64_C(0x000000001c714037), UINT64_C(0x1692fecf589b8771), UINT64_C(0x131affcfa090e79b),
        UINT64_C(0x131ae74fa0862685), UINT64_C(0x0fa2bc0c8079a6a9)
    },
    {   UINT64_C(0x000000e65cb14038), UINT64_C(0x0fa2e8cf687786a1), UINT64_C(0x0fa2e8cf687786a1),
        UINT64_C(0x0fa2e8cf6879e69a), UINT64_C(0x0fa2e8cf687ca677)
    },
    {   UINT64_C(0x000744e7dce14039), UINT64_C(0x0fa2e8cf687b2677), UINT64_C(0x0fa2e8cf687786dc),
        UINT64_C(0x1692eccf6c92a5b6), UINT64_C(0x0de2e80c386f85b6)
    },
    {   UINT64_C(0x000750e94001403a), UINT64_C(0x0de2ef4f6c7046a1), UINT64_C(0x0de2ef4f6c72e6a1),
        UINT64_C(0x0de2ef4f6c78469a), UINT64_C(0x0de2ef4f6c794677)
    },
    {   UINT64_C(0x000000000001403b), UINT64_C(0x08b2ee8f7c6346a1), UINT64_C(0x08b2ee8f7c6546a1),
        UINT64_C(0x08b2ee8f7c6aa69a), UINT64_C(0x08b2ee8f7c6bc677)
    },
    {   UINT64_C(0x0000000000005486), UINT64_C(0x1f43010f20a6670a), UINT64_C(0x1f430c4f2ca7a6f0),
        UINT64_C(0x1f43104ec4a8a6e9), UINT64_C(0x1f42fd0ef0a72704)
    },
    {   UINT64_C(0x000764001d89403d), UINT64_C(0x0fa2ed4f6c78469a), UINT64_C(0x0fa2ed4f6c7b2677),
        UINT64_C(0x0fa2ed4f6c794677), UINT64_C(0x11d2f64f2c81a5ff)
    },
    {   UINT64_C(0x000000000001403e), UINT64_C(0x0fa2ed4dc475a618), UINT64_C(0x1162f1cf7c7c26a1),
        UINT64_C(0x1162f1cf7c7c26a1), UINT64_C(0x1162f1cf7c7c269a)
    },
    {   UINT64_C(0x000000000001403f), UINT64_C(0x1162f1cf7c7c2677), UINT64_C(0x0de2d68c6c70a6a1),
        UINT64_C(0x0fa2d00c6c7646a3), UINT64_C(0x0de2d68c6c780677)
    },
    {   UINT64_C(0x0000000000014040), UINT64_C(0x14dadd0fa088a701), UINT64_C(0x0fa2e8cf687b4632),
        UINT64_C(0x14dadd0fa088a75d), UINT64_C(0x0fa2e8cf687ae68e)
    },
    {   UINT64_C(0x0000000000014041), UINT64_C(0x14dadd0cec8e8693), UINT64_C(0x0fa2e8ccec7de5b6),
        UINT64_C(0x14daf60f58932770), UINT64_C(0x0de2eccf6c6f86a1)
    },
    {   UINT64_C(0x0000000000014042), UINT64_C(0x14daf60f58932769), UINT64_C(0x0de2eccf6c72669a),
        UINT64_C(0x14daf60f58932746), UINT64_C(0x0de2eccf6c6f8677)
    },
    {   UINT64_C(0x0000000000014043), UINT64_C(0x14daf60f58932769), UINT64_C(0x0de2eccf6c75269a),
        UINT64_C(0x1692e28fa0942769), UINT64_C(0x1492e8cf6c9946ae)
    },
    {   UINT64_C(0x0000000000014044), UINT64_C(0x1692e64fa0960685), UINT64_C(0x0fa2e8cf6c8226a3),
        UINT64_C(0x14dae74fa0902701), UINT64_C(0x0de2ef4f6c746632)
    },
    {   UINT64_C(0x0000000000014045), UINT64_C(0x14dae74fa090275d), UINT64_C(0x0de2ef4f6c7a468e),
        UINT64_C(0x14dae74fa0902746), UINT64_C(0x0de2ef4f6c704677)
    },
    {   UINT64_C(0x0000000000014046), UINT64_C(0x14dae74cc8902685), UINT64_C(0x0de2ef4cc87045b6),
        UINT64_C(0x14dae74fa0902769), UINT64_C(0x0de2ef4f6c7b469a)
    },
    {   UINT64_C(0x0000000000014047), UINT64_C(0x1692f34f5896a769), UINT64_C(0x0fa2e10c747a269a),
        UINT64_C(0x1692f34f5896a75d), UINT64_C(0x0fa2e10c747a268e)
    },
    {   UINT64_C(0x0000000000014048), UINT64_C(0x1692f34f5896a746), UINT64_C(0x0fa2e10c747a2677),
        UINT64_C(0x1692f34a0496a695), UINT64_C(0x0fa2e10c747a2728)
    },
    {   UINT64_C(0x0000000000014049), UINT64_C(0x1852e80fa0a26769), UINT64_C(0x1162eacf7c7cc769),
        UINT64_C(0x1852e80fa0a28685), UINT64_C(0x1162eacf7c7cc6a3)
    },
    {   UINT64_C(0x000000000001404a), UINT64_C(0x0c2ae60fa0794746), UINT64_C(0x08b2ebcf7c6a4677),
        UINT64_C(0x0c2ae60fa076e701), UINT64_C(0x08b2eb4f7c67e632)
    },
    {   UINT64_C(0x000000000001404b), UINT64_C(0x0c2ae60fa077c75d), UINT64_C(0x08b2ee8f7c67868e),
        UINT64_C(0x0c2ae60cec714685), UINT64_C(0x08b2ee8cec5f4694)
    },
    {   UINT64_C(0x000000000000ca71), UINT64_C(0x1c72f94d28aaa67d), UINT64_C(0x1c72f94d28aaa67d),
        UINT64_C(0x1c72f94d28aaa67d), UINT64_C(0x1c72f94d28aaa67d)
    },
    {   UINT64_C(0x000000000001404d), UINT64_C(0x0fa2e28e1483c769), UINT64_C(0x08b2becc6465c69a),
        UINT64_C(0x14dae8ca04964685), UINT64_C(0x0fa2e84a047ae6a3)
    },
    {   UINT64_C(0x000000000001404e), UINT64_C(0x12c2ef8fa094a5be), UINT64_C(0x131ae88fa0884770),
        UINT64_C(0x08b2ee8f7c698770), UINT64_C(0x131ae88a04884685)
    },
    {   UINT64_C(0x000000000001404f), UINT64_C(0x08b2de8a0462c6a3), UINT64_C(0x131ae88fa091e695),
        UINT64_C(0x0e1aee8f7c7ce6ae), UINT64_C(0x131ae88fa0884685)
    },
    {   UINT64_C(0x0000000000014050), UINT64_C(0x0bbaee8f7c6e46a3), UINT64_C(0x131ae88fa0884685),
        UINT64_C(0x08b2eacf7c6426a3), UINT64_C(0x1692e74f649c0770)
    },
    {   UINT64_C(0x0000000000014051), UINT64_C(0x1162ec8f7c7c46a1), UINT64_C(0x1692e74a049c0685),
        UINT64_C(0x1162ec8a047c45b6), UINT64_C(0x1692e74f649c0769)
    },
    {   UINT64_C(0x0000000000014052), UINT64_C(0x1162ec8f7c7dc69a), UINT64_C(0x15e2f88f7c90a6ae),
        UINT64_C(0x1692e28c74942685), UINT64_C(0x10faec8c6479c5b6)
    },
    {   UINT64_C(0x0000000000014053), UINT64_C(0x1692f4cf5894e701), UINT64_C(0x0fa2ed4f6c782632),
        UINT64_C(0x1692f4cf5894e75d), UINT64_C(0x0fa2ed4f6c7b868e)
    },
    {   UINT64_C(0x0000000000006493), UINT64_C(0x1f42fb0f08b726f1), UINT64_C(0x1f42f91018b5e6ef),
        UINT64_C(0x1f42ffd01cb2c6f4), UINT64_C(0x1f42ffd05cb2c70e)
    },
    {   UINT64_C(0x000000000000549f), UINT64_C(0x1f42fd8eacad0721), UINT64_C(0x1f4301cee0ab070c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43000eaca98724)
    },
    {   UINT64_C(0x0000000000014056), UINT64_C(0x14dae70fa08c6769), UINT64_C(0x0c2ae8cfa071e69a),
        UINT64_C(0x1162ee8f58804770), UINT64_C(0x0c2ae94f6c6de6a1)
    },
    {   UINT64_C(0x0000000000014057), UINT64_C(0x1162ee8f58804769), UINT64_C(0x0c2ae94f6c6c669a),
        UINT64_C(0x1162ee8c38804695), UINT64_C(0x0c2ae94c386825b6)
    },
    {   UINT64_C(0x0000000000014058), UINT64_C(0x1162ee8f58804769), UINT64_C(0x0c2ae94f6c71e69a),
        UINT64_C(0x131afa4c388fc685), UINT64_C(0x08b2db4c3862a63a)
    },
    {   UINT64_C(0x0000000000014059), UINT64_C(0x131afa4fa08fc769), UINT64_C(0x0cdaeb4f7c7ce6ae),
        UINT64_C(0x131afa4fa08fc685), UINT64_C(0x08b2e68f7c61a63a)
    },
    {   UINT64_C(0x000000000001405a), UINT64_C(0x1692fecf589b8731), UINT64_C(0x1162f1cf7c7c2677),
        UINT64_C(0x1692fecf589b8701), UINT64_C(0x1162f1cf7c7c2632)
    },
    {   UINT64_C(0x000000000001405b), UINT64_C(0x1692fecf589b875d), UINT64_C(0x1162f1cf7c7c268e),
        UINT64_C(0x1692fecf589b8781), UINT64_C(0x1162f1cf7c7c26c1)
    },
    {   UINT64_C(0x000000000001405c), UINT64_C(0x1692fecf589b8761), UINT64_C(0x1162f1cf7c8066a1),
        UINT64_C(0x1692feccec9b8685), UINT64_C(0x1162f1ccec80e5b6)
    },
    {   UINT64_C(0x000000000001405d), UINT64_C(0x1bcafe0f58b40769), UINT64_C(0x14daf1cf6c8b469a),
        UINT64_C(0x131affcfa090e769), UINT64_C(0x0de2d68c6c6fa69a)
    },
    {   UINT64_C(0x000000000001405e), UINT64_C(0x131affcfa090e746), UINT64_C(0x131aeb0fa0882770),
        UINT64_C(0x0c2ae34e686de6a1), UINT64_C(0x131aeb0fa0882746)
    },
    {   UINT64_C(0x000000000001405f), UINT64_C(0x0c2ae34e686c8677), UINT64_C(0x131aeb0fa0882769),
        UINT64_C(0x0c2ae34e6871e69a), UINT64_C(0x0a6af18fa081869b)
    },
    {   UINT64_C(0x0000000000014060), UINT64_C(0x0fa2ea8f6c7606a3), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000054ab), UINT64_C(0x1f43034facad8704), UINT64_C(0x1f4300cf10b226f6),
        UINT64_C(0x1f43004ed8b066f0), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000010098), UINT64_C(0x1652f00c50a26693), UINT64_C(0x129af00c5086e5ca),
        UINT64_C(0x1192fb0f7484c5a1), UINT64_C(0x0de2f1cbf873c5a1)
    },
    {   UINT64_C(0x000000000000ca88), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1772fe4ebc942766), UINT64_C(0x1772fe4ebc9426c8)
    },
    {   UINT64_C(0x000000000000ca89), UINT64_C(0x1772fe4ebc9426d2), UINT64_C(0x1772fe4b2494261b),
        UINT64_C(0x1772fe4be094261b), UINT64_C(0x1862fe4bc49fc61b)
    },
    {   UINT64_C(0x000000000000ca8a), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1772fe8f0c942511), UINT64_C(0x1772fe8f0c942607)
    },
    {   UINT64_C(0x000000000000ca8b), UINT64_C(0x1772fe8f0c942607), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000ca8c), UINT64_C(0x15f2fe8f1c8e06d1), UINT64_C(0x15f2fe8ca48e0602),
        UINT64_C(0x15f2fe8eb48e0602), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000014068), UINT64_C(0x1692f4cf58a346b4), UINT64_C(0x10caf40f6c88e5e3),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000014069), UINT64_C(0x0000000000000000), UINT64_C(0x1042d50c6c78c689),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001009c), UINT64_C(0x1692f10bfc9685a1), UINT64_C(0x1592f10bfc9285a1),
        UINT64_C(0x12f2d28bfc8705a1), UINT64_C(0x0f92f18bfc7b65a1)
    },
    {   UINT64_C(0x000000000001406b), UINT64_C(0x0000000000000000), UINT64_C(0x0b42ed4f7c76c69b),
        UINT64_C(0x0000000000000000), UINT64_C(0x183afecf58ae270b)
    },
    {   UINT64_C(0x000000000001406c), UINT64_C(0x1162f1cf7c90862f), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005af2), UINT64_C(0x1f42fa9020b766d3), UINT64_C(0x1f431a4eb0ad0700),
        UINT64_C(0x1f4300ce08b72741), UINT64_C(0x1f42fccf10b5c6e6)
    },
    {   UINT64_C(0x000000000001009e), UINT64_C(0x14a2f58bfc8d4693), UINT64_C(0x0c92e2cfa066c5a1),
        UINT64_C(0x0bfae2cfa06e8693), UINT64_C(0x0b0ae2cbfc6945a1)
    },
    {   UINT64_C(0x000000000001406f), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0fa2f74f78786605), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000014070), UINT64_C(0x0682f18fa06146cc), UINT64_C(0x0acaf18fa07266cc),
        UINT64_C(0x0b82f18fa07546cc), UINT64_C(0x0962f94f6c6ae694)
    },
    {   UINT64_C(0x00000000000054bb), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43078f54b10719)
    },
    {   UINT64_C(0x000000000000ca97), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1402fb0f3088075f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000ca98), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1402fb09b4880600)
    },
    {   UINT64_C(0x000000000000ca99), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1772ff0d1c93c577), UINT64_C(0x1772ff100c93c6ef)
    },
    {   UINT64_C(0x000000000000ca9a), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1772fed1b093c61d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000054c0), UINT64_C(0x1f431f4f2ca2871b), UINT64_C(0x1f43020f6caf6728),
        UINT64_C(0x1f431a0f5ca56707), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000054c1), UINT64_C(0x0000000000000000), UINT64_C(0x1f43270f00b28734),
        UINT64_C(0x1f43198f24aae72b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000100a3), UINT64_C(0x0de2f30f5873c5a1), UINT64_C(0x14daf1cf588f85a1),
        UINT64_C(0x0de2f08fa078066f), UINT64_C(0x13cafd8fa089e5b8)
    },
    {   UINT64_C(0x00000000000054c3), UINT64_C(0x0000000000000000), UINT64_C(0x1f430b4e70a7e743),
        UINT64_C(0x1f430b8e5caac735), UINT64_C(0x1f42fb0ee0b60722)
    },
    {   UINT64_C(0x000000000000ca9f), UINT64_C(0x0000000000000000), UINT64_C(0x1773020d70924670),
        UINT64_C(0x1773020d70924670), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000054c5), UINT64_C(0x0000000000000000), UINT64_C(0x1f4318903cae26c9),
        UINT64_C(0x1f42fbd004b206f6), UINT64_C(0x1f43079028b1a6f5)
    },
    {   UINT64_C(0x000000000000caa1), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1773020c4c92466e)
    },
    {   UINT64_C(0x00000000000054c7), UINT64_C(0x1f4314cf34aac6f9), UINT64_C(0x1f43150fc4abe6ff),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43140ee4ab46e6)
    },
    {   UINT64_C(0x00000000000100a6), UINT64_C(0x169af38f5c96868f), UINT64_C(0x0e62f2cfa07da5b8),
        UINT64_C(0x0efaf30f687945c3), UINT64_C(0x11d2f54f748fc5eb)
    },
    {   UINT64_C(0x00000000000054c9), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43160f54ab26df), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000054ca), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43180f88ada704), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000054cb), UINT64_C(0x0000000000000000), UINT64_C(0x1f43110f20b0c706),
        UINT64_C(0x1f43188f0caaa6fe), UINT64_C(0x1f430f4f54aec711)
    },
    {   UINT64_C(0x000000000000caa7), UINT64_C(0x0000000000000000), UINT64_C(0x1772feccc493c699),
        UINT64_C(0x1772feccc493c699), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000054cd), UINT64_C(0x1f430e0ef0aac70c), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43160eb4aa4705)
    },
    {   UINT64_C(0x00000000000054ce), UINT64_C(0x1f430d907cabe69c), UINT64_C(0x1f431450a0ac46db),
        UINT64_C(0x1f431a8f58a7c6da), UINT64_C(0x1f43154f78a7e6ee)
    },
    {   UINT64_C(0x00000000000054cf), UINT64_C(0x1f43190ee4ade6e3), UINT64_C(0x1f43178f5cae06f8),
        UINT64_C(0x1f43128f64b0070f), UINT64_C(0x1f43180f58ab26fb)
    },
    {   UINT64_C(0x00000000000054d0), UINT64_C(0x1f43148f3cac6708), UINT64_C(0x1f4303cef8b1872d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe4f18b5472a)
    },
    {   UINT64_C(0x00000000000054d1), UINT64_C(0x1f430d8f38af46dc), UINT64_C(0x1f43010f08b5471b),
        UINT64_C(0x1f4308cf20ae270f), UINT64_C(0x1f42ff8e98b4072c)
    },
    {   UINT64_C(0x00000000000054d2), UINT64_C(0x1f4306cee8b36717), UINT64_C(0x1f42ff8e2cb64734),
        UINT64_C(0x1f4303ce7cb2673c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000054d3), UINT64_C(0x1f42ff4eacb506fb), UINT64_C(0x1f43120fccab46d9),
        UINT64_C(0x1f430d8ec8ac670b), UINT64_C(0x1f43000f88b026fb)
    },
    {   UINT64_C(0x00000000000054d4), UINT64_C(0x0000000000000000), UINT64_C(0x1f43018e1cb36748),
        UINT64_C(0x1f4301ce5cb36734), UINT64_C(0x1f43038e4cb46733)
    },
    {   UINT64_C(0x0000000000003daf), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106afa0c106c8597), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000054d6), UINT64_C(0x1f43064e8cae8727), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fe0e34b4e73c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000054d7), UINT64_C(0x1f434f0e7ca5e72e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4305cee8b22722), UINT64_C(0x1f430c4edcada70e)
    },
    {   UINT64_C(0x00000000000054d8), UINT64_C(0x1f4321cecca42718), UINT64_C(0x1f43018e78b26737),
        UINT64_C(0x1f43078f689c870e), UINT64_C(0x1f43210ed0a06729)
    },
    {   UINT64_C(0x00000000000054d9), UINT64_C(0x1f43284f2ca0e711), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43028f08b22730), UINT64_C(0x1f430dce8cb06716)
    },
    {   UINT64_C(0x00000000000054da), UINT64_C(0x0000000000000000), UINT64_C(0x1f43468f0894a6ae),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430f906cabe69f)
    },
    {   UINT64_C(0x00000000000054db), UINT64_C(0x1f43138e5caae6f1), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f80f14ac4708), UINT64_C(0x1f43100eacaa271d)
    },
    {   UINT64_C(0x00000000000054dc), UINT64_C(0x1f4310ce6cad271e), UINT64_C(0x1f42f98f1cb0a73d),
        UINT64_C(0x1f42fe8ed8ad06fa), UINT64_C(0x1f430f0e8cad86e6)
    },
    {   UINT64_C(0x00000000000054dd), UINT64_C(0x1f43094e8cad0719), UINT64_C(0x1f43130e9cada727),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43054ec4b80739)
    },
    {   UINT64_C(0x00000000000100b1), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0a6b04d7506ea67d), UINT64_C(0x0a6b0c575073c67d)
    },
    {   UINT64_C(0x0000000000003db4), UINT64_C(0x106afc181479064b), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000054e0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc8f44a8a6e0), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000054e1), UINT64_C(0x1f42ff4fb4b246e4), UINT64_C(0x1f42fc4f98a766ec),
        UINT64_C(0x1f42fecf98a5e6de), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000054e2), UINT64_C(0x0000000000000000), UINT64_C(0x1f43070fb8af26e9),
        UINT64_C(0x1f42ff4f0ca806de), UINT64_C(0x1f42fd5020ab06e1)
    },
    {   UINT64_C(0x00000000000054e3), UINT64_C(0x1f42fc8fd4b2c6e4), UINT64_C(0x1f42fb8f08ac8706),
        UINT64_C(0x1f42fe4fb8afe6f0), UINT64_C(0x1f42f88ea8a146f5)
    },
    {   UINT64_C(0x00000000000054e4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43074facaec6d9), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b09), UINT64_C(0x1f4318cef8b78734), UINT64_C(0x1f43124e8cafc71a),
        UINT64_C(0x1f430c8ec0b6a72a), UINT64_C(0x1f43064e4cb26738)
    },
    {   UINT64_C(0x00000000000054e6), UINT64_C(0x1f42fc8f98aec701), UINT64_C(0x1f42f88e4caf8726),
        UINT64_C(0x1f42fbceb0b4a722), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001409d), UINT64_C(0x1262e74f708b45b6), UINT64_C(0x0fa2ed4f6c75a5b6),
        UINT64_C(0x176af3cf8c9c65b6), UINT64_C(0x156aed4f988cc5c5)
    },
    {   UINT64_C(0x000000000001409e), UINT64_C(0x159aed4c048d8695), UINT64_C(0x0d5aee0fa071c5b6),
        UINT64_C(0x0f6aee0fa07a06a3), UINT64_C(0x0da2ee0bfc72a5b6)
    },
    {   UINT64_C(0x000000000001409f), UINT64_C(0x0c2ad84bfc6f25b6), UINT64_C(0x0c2ae24bfc6f25b6),
        UINT64_C(0x0b42e8cfa072a5cc), UINT64_C(0x0a92f08fa06305cc)
    },
    {   UINT64_C(0x00000000000140a0), UINT64_C(0x0f92f00fa07ee5b8), UINT64_C(0x0f92f00fa08925b8),
        UINT64_C(0x0c2ae60c386825b6), UINT64_C(0x0d42d40bfc878693)
    },
    {   UINT64_C(0x00000000000054eb), UINT64_C(0x1f42f98efcb5870c), UINT64_C(0x1f42f84f5cb6c704),
        UINT64_C(0x1f42f98ef8aec6f3), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000140a2), UINT64_C(0x09badf0bfc61a63a), UINT64_C(0x1162ea0f7c7ec5b6),
        UINT64_C(0x0fa2f1cf808385ac), UINT64_C(0x10b2f28f787c05b6)
    },
    {   UINT64_C(0x00000000000140a3), UINT64_C(0x0de2f1cf6c70a5b6), UINT64_C(0x14daf1cf6c8b45b6),
        UINT64_C(0x0de2f20fa07d4683), UINT64_C(0x13cafe4fa08a45b8)
    },
    {   UINT64_C(0x00000000000140a4), UINT64_C(0x0dc2e80c387125a9), UINT64_C(0x0cdae80e1c6d85a9),
        UINT64_C(0x0f9aeb8bf08445aa), UINT64_C(0x0f9aeb8ad48085aa)
    },
    {   UINT64_C(0x00000000000140a5), UINT64_C(0x1092f44fa07f8695), UINT64_C(0x1092fe4fa07e2695),
        UINT64_C(0x0f3af44f68772685), UINT64_C(0x0efaf30bec8285b6)
    },
    {   UINT64_C(0x00000000000140a6), UINT64_C(0x169af14f5c9a4690), UINT64_C(0x0f6aeb8fa07b45b8),
        UINT64_C(0x0e8af20f687d85c3), UINT64_C(0x1222f54f7494c602)
    },
    {   UINT64_C(0x00000000000140a7), UINT64_C(0x1232f34fa09305b8), UINT64_C(0x0edae18bfc786695),
        UINT64_C(0x0fa2f38bb88085b1), UINT64_C(0x0f2af08fa07905b8)
    },
    {   UINT64_C(0x00000000000054f2), UINT64_C(0x1f43039010b826cc), UINT64_C(0x1f4313d034b586a5),
        UINT64_C(0x1f4301d090b7c6e9), UINT64_C(0x1f42fecf38b5a723)
    },
    {   UINT64_C(0x00000000000140a9), UINT64_C(0x19a2e8cbf0a426a3), UINT64_C(0x198ae8ce1c9b66a3),
        UINT64_C(0x1182ed4f6c80063a), UINT64_C(0x0e2ae68bfc924693)
    },
    {   UINT64_C(0x00000000000140aa), UINT64_C(0x12c2ed4f588bc63a), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000054f5), UINT64_C(0x1f42f88f78b6a705), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc8ef4b826ef), UINT64_C(0x1f430d4ef4b1272e)
    },
    {   UINT64_C(0x00000000000140ac), UINT64_C(0x0be2efd4c06c273c), UINT64_C(0x0be2efd4c46c2731),
        UINT64_C(0x0af2f412606e8746), UINT64_C(0x0c2af355006e869a)
    },
    {   UINT64_C(0x00000000000140ad), UINT64_C(0x0c2aee95006c269a), UINT64_C(0x0c2aee924c6ce69a),
        UINT64_C(0x0c32ef550478c694), UINT64_C(0x0e12f1d4cc78e69a)
    },
    {   UINT64_C(0x00000000000140ae), UINT64_C(0x0af2f0d2606ec69a), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0a6b0e1564680695)
    },
    {   UINT64_C(0x00000000000054f9), UINT64_C(0x1f43098fb8b1671a), UINT64_C(0x1f431b4ed0a9072a),
        UINT64_C(0x1f4314cf5ca2e6ff), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000140b0), UINT64_C(0x0abaed536066e69a), UINT64_C(0x0a32f313606c069a),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000140b1), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0a6af817b06c669a), UINT64_C(0x0a6b01d7b071e69a)
    },
    {   UINT64_C(0x00000000000064c2), UINT64_C(0x1f42f90f28b7a718), UINT64_C(0x1f42f90f00b306fe),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90f78b186fe)
    },
    {   UINT64_C(0x00000000000054fd), UINT64_C(0x0000000000000000), UINT64_C(0x1f43178fbca786d6),
        UINT64_C(0x1f4304ce7cb22715), UINT64_C(0x1f43088f3cad06fb)
    },
    {   UINT64_C(0x00000000000054fe), UINT64_C(0x1f43204f18a5e714), UINT64_C(0x1f43011058b7868a),
        UINT64_C(0x1f42ff1094b30684), UINT64_C(0x1f4300cf64acc6f0)
    },
    {   UINT64_C(0x00000000000054ff), UINT64_C(0x1f4308cfacb0469f), UINT64_C(0x1f43044fdcb766e7),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000140b6), UINT64_C(0x0a6affd7b06ee68e), UINT64_C(0x0a6b16d7d4632677),
        UINT64_C(0x0a6b0dd8146906da), UINT64_C(0x0a6ae40cec562414)
    },
    {   UINT64_C(0x0000000000005501), UINT64_C(0x1f43000f2cb76724), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4300d010ae26ec), UINT64_C(0x1f4304ceecb386c7)
    },
    {   UINT64_C(0x0000000000005502), UINT64_C(0x1f42fdcf28b84718), UINT64_C(0x1f43144edcad0730),
        UINT64_C(0x1f43204e9ca4e71d), UINT64_C(0x1f43008e7cb38712)
    },
    {   UINT64_C(0x0000000000005503), UINT64_C(0x1f431c4f24a46707), UINT64_C(0x1f42f18f98a6471f),
        UINT64_C(0x1f42fc0fa8aac707), UINT64_C(0x1f43134eb0b4a736)
    },
    {   UINT64_C(0x0000000000005504), UINT64_C(0x1f430210c4b626e1), UINT64_C(0x1f43130f0caea711),
        UINT64_C(0x1f4303cfdcb646e5), UINT64_C(0x1f43034f7cafe6d0)
    },
    {   UINT64_C(0x0000000000005505), UINT64_C(0x0000000000000000), UINT64_C(0x1f43250fd8a226c4),
        UINT64_C(0x1f43084f48a766df), UINT64_C(0x1f43084ef4aca6f4)
    },
    {   UINT64_C(0x0000000000005506), UINT64_C(0x1f43000e6cb50707), UINT64_C(0x1f42ff0fb8b806f8),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43024f68b2e6de)
    },
    {   UINT64_C(0x0000000000005507), UINT64_C(0x1f42fe1050b8469b), UINT64_C(0x1f4306cefcb76739),
        UINT64_C(0x1f42f60efcb506d6), UINT64_C(0x1f42f80e90b7a70c)
    },
    {   UINT64_C(0x00000000000064c8), UINT64_C(0x1f42f84ffcb9c70e), UINT64_C(0x1f42f90ee0b4671d),
        UINT64_C(0x1f42fbce94b48719), UINT64_C(0x1f42f75020b846ec)
    },
    {   UINT64_C(0x0000000000005509), UINT64_C(0x1f43000eb8b726f4), UINT64_C(0x1f43014f08b0469c),
        UINT64_C(0x1f43088f28aec6f2), UINT64_C(0x1f42ff106cb926a1)
    },
    {   UINT64_C(0x000000000000550a), UINT64_C(0x1f42fc0f58b6470a), UINT64_C(0x1f42fd0f74b926fd),
        UINT64_C(0x1f42fe0f64b4e6b7), UINT64_C(0x1f4300ceecb82725)
    },
    {   UINT64_C(0x000000000000550b), UINT64_C(0x1f43014e7cae86ea), UINT64_C(0x1f42f58f84b4c705),
        UINT64_C(0x1f42fd8f68b72710), UINT64_C(0x1f43124fa8a96722)
    },
    {   UINT64_C(0x000000000000550c), UINT64_C(0x1f4302cff8ad070b), UINT64_C(0x1f4305cf48b5a72c),
        UINT64_C(0x1f4303cef8a6e6df), UINT64_C(0x1f43048f70b30704)
    },
    {   UINT64_C(0x000000000000550d), UINT64_C(0x1f43124f70b006fe), UINT64_C(0x1f4300ce88b4c71b),
        UINT64_C(0x1f42fa8eb4a8e6cd), UINT64_C(0x1f42fd0fc0b546f1)
    },
    {   UINT64_C(0x000000000000550e), UINT64_C(0x1f4301d004b766ef), UINT64_C(0x1f4304cf84b74717),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43034f34b0e717)
    },
    {   UINT64_C(0x000000000000550f), UINT64_C(0x1f42f98ff4b7a6e5), UINT64_C(0x1f42ff0ee8b3271d),
        UINT64_C(0x1f43068efcb3e6fa), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005510), UINT64_C(0x1f430a8ec4b3c701), UINT64_C(0x1f42ff0f50ac4709),
        UINT64_C(0x1f43280fc8a5c6e3), UINT64_C(0x1f42fd0fc0b646f0)
    },
    {   UINT64_C(0x0000000000005511), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd1010b5e6f7),
        UINT64_C(0x1f430e4ef4b6c701), UINT64_C(0x1f430e8ebcad86e3)
    },
    {   UINT64_C(0x0000000000005512), UINT64_C(0x1f43118fa4b0c6ee), UINT64_C(0x1f4301cf74b1a704),
        UINT64_C(0x1f43008f58b36721), UINT64_C(0x1f43035040b7a70c)
    },
    {   UINT64_C(0x0000000000003dce), UINT64_C(0x106af90f747a8656), UINT64_C(0x106afb0bfc7985a2),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005514), UINT64_C(0x1f43004f14aac700), UINT64_C(0x1f43024f00b7a70f),
        UINT64_C(0x1f4305503cb5a6d3), UINT64_C(0x1f4302cfa8b5e707)
    },
    {   UINT64_C(0x0000000000005515), UINT64_C(0x1f42fcd020b646ed), UINT64_C(0x1f43000f54adc6d7),
        UINT64_C(0x1f4304cfb8a746be), UINT64_C(0x1f4308cf88ab26db)
    },
    {   UINT64_C(0x0000000000005516), UINT64_C(0x1f4325ce989ca711), UINT64_C(0x1f431fcf50a506f5),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43000f78b6a6fd)
    },
    {   UINT64_C(0x0000000000005517), UINT64_C(0x1f4304cf10ac2731), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4300106cb1c713)
    },
    {   UINT64_C(0x0000000000005518), UINT64_C(0x1f42fe0ed8b626f7), UINT64_C(0x1f42fe0f3cb3a6c6),
        UINT64_C(0x1f43064f9cb466df), UINT64_C(0x1f43000f04b546c7)
    },
    {   UINT64_C(0x0000000000005519), UINT64_C(0x1f42ff0f54b6a6e6), UINT64_C(0x1f4302cf48b4e6fe),
        UINT64_C(0x1f42fc8fccaf26e4), UINT64_C(0x1f42ff0fc0b246e9)
    },
    {   UINT64_C(0x000000000000551a), UINT64_C(0x1f4307cf3ca4a70c), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa1068b566d3), UINT64_C(0x1f4302cf1ca5e6f2)
    },
    {   UINT64_C(0x000000000000551b), UINT64_C(0x1f4302118cb5c653), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43010eacb486dd)
    },
    {   UINT64_C(0x000000000000551c), UINT64_C(0x1f4308cf38af06ee), UINT64_C(0x1f42fc1034b92708),
        UINT64_C(0x1f42f91050b826c8), UINT64_C(0x1f42fc0e9cbaa727)
    },
    {   UINT64_C(0x000000000000551d), UINT64_C(0x1f4302ceecadc6fb), UINT64_C(0x1f42fe0f8cb3e6ca),
        UINT64_C(0x1f42fb9058b726f4), UINT64_C(0x1f42ff8e3caf86dc)
    },
    {   UINT64_C(0x000000000000551e), UINT64_C(0x1f42fc8fa4b066bd), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43000f18afa6e1), UINT64_C(0x1f43064ec8ae6738)
    },
    {   UINT64_C(0x000000000000551f), UINT64_C(0x1f4302cf64b5671c), UINT64_C(0x1f42f80e5cb7a747),
        UINT64_C(0x1f4302d0acb166a1), UINT64_C(0x1f4303cfe8af4706)
    },
    {   UINT64_C(0x0000000000005520), UINT64_C(0x1f430250d8b6a6db), UINT64_C(0x1f43010fa8b1a6fc),
        UINT64_C(0x1f43054f10af66c8), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005521), UINT64_C(0x1f43024fa4ab26fd), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fe8f3cb52739), UINT64_C(0x1f4303cfccb3a6d3)
    },
    {   UINT64_C(0x0000000000005522), UINT64_C(0x1f4302cf18af6709), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb8e68aba728)
    },
    {   UINT64_C(0x0000000000005523), UINT64_C(0x1f42fccef8afc712), UINT64_C(0x1f4302cf7cabe6e8),
        UINT64_C(0x1f43000f1cb84715), UINT64_C(0x1f42fd0f2cb72712)
    },
    {   UINT64_C(0x0000000000005524), UINT64_C(0x1f42f90ea4b186fd), UINT64_C(0x1f42fb0efcb526e9),
        UINT64_C(0x1f43098f8cb4a6f0), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005525), UINT64_C(0x1f43054f04b0a70d), UINT64_C(0x1f43024f98b2e713),
        UINT64_C(0x1f42fb8fc0b1a6f0), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005526), UINT64_C(0x1f42fe0e9ca8871a), UINT64_C(0x1f43000fb4b40711),
        UINT64_C(0x1f42fd8ee4b8a738), UINT64_C(0x1f4305ced4b04703)
    },
    {   UINT64_C(0x0000000000005527), UINT64_C(0x0000000000000000), UINT64_C(0x1f4300d090ae26e6),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005528), UINT64_C(0x1f430b4e2cb08720), UINT64_C(0x1f42fb0e2cb4e6f8),
        UINT64_C(0x1f430b4eb0ada72f), UINT64_C(0x1f42fb9028b5a6ff)
    },
    {   UINT64_C(0x0000000000005529), UINT64_C(0x1f43034fecb2a70b), UINT64_C(0x1f4303d018ad06c7),
        UINT64_C(0x1f42fd0ed8b6472f), UINT64_C(0x1f42fd8ee4aac6f6)
    },
    {   UINT64_C(0x000000000000552a), UINT64_C(0x1f430c4f00b06721), UINT64_C(0x1f43008e3cb5e736),
        UINT64_C(0x1f42fe8ebcba273a), UINT64_C(0x1f42f9d004b386d7)
    },
    {   UINT64_C(0x00000000000140e1), UINT64_C(0x09631117b0666690), UINT64_C(0x0be2f4d7b0758690),
        UINT64_C(0x14dadd0fa088a69d), UINT64_C(0x0a6b0b147c5f85b3)
    },
    {   UINT64_C(0x000000000000552c), UINT64_C(0x1f43034ec8aba703), UINT64_C(0x1f4301cf6ca7470f),
        UINT64_C(0x1f43004f9cb2670b), UINT64_C(0x1f43054f48afc703)
    },
    {   UINT64_C(0x00000000000140e3), UINT64_C(0x1692f0cf5894e69d), UINT64_C(0x0000000000000000),
        UINT64_C(0x15e2f00fa0a9669d), UINT64_C(0x1942f44fa09f469d)
    },
    {   UINT64_C(0x00000000000140e4), UINT64_C(0x08b2ef8f7c72e690), UINT64_C(0x14dadd0fa088a693),
        UINT64_C(0x14dae7cfa08c8685), UINT64_C(0x124aeacfa0924685)
    },
    {   UINT64_C(0x000000000000552f), UINT64_C(0x1f43104e7cac66f6), UINT64_C(0x1f43000f8cad26d1),
        UINT64_C(0x1f42fc0f44b2a712), UINT64_C(0x1f42fa8e8cb4e702)
    },
    {   UINT64_C(0x0000000000005530), UINT64_C(0x1f42f98eb8b72734), UINT64_C(0x1f4309d024af86e6),
        UINT64_C(0x1f42fc901cb286c0), UINT64_C(0x1f43000f50b006cc)
    },
    {   UINT64_C(0x0000000000005531), UINT64_C(0x1f4301cfbcb4c70f), UINT64_C(0x1f43020ee4b3c722),
        UINT64_C(0x1f42fe0e9caaa732), UINT64_C(0x1f4300cf94b1c711)
    },
    {   UINT64_C(0x00000000000140e8), UINT64_C(0x1852e80fa0a26685), UINT64_C(0x131ae70fa08b2685),
        UINT64_C(0x0000000000000000), UINT64_C(0x13caeb4fa08be685)
    },
    {   UINT64_C(0x0000000000005533), UINT64_C(0x1f4301cf90b626f7), UINT64_C(0x1f43010f7cab46f1),
        UINT64_C(0x1f43024fa8b4470b), UINT64_C(0x1f43010f74b3c6ce)
    },
    {   UINT64_C(0x0000000000005534), UINT64_C(0x1f43024fbcb026d0), UINT64_C(0x1f42fe904cb246bd),
        UINT64_C(0x1f42fb8f94b3c6ed), UINT64_C(0x1f43018f48b32721)
    },
    {   UINT64_C(0x0000000000005535), UINT64_C(0x1f43004ee8b0471a), UINT64_C(0x1f43064f20a6e70b),
        UINT64_C(0x1f43000e9cb6071b), UINT64_C(0x1f43044ec8b16713)
    },
    {   UINT64_C(0x0000000000005536), UINT64_C(0x1f42fa4f3cb54710), UINT64_C(0x1f42ff8ff4b726f9),
        UINT64_C(0x1f43004f38b4c6f1), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005537), UINT64_C(0x1f43014ef8b50712), UINT64_C(0x1f43014f44b6270f),
        UINT64_C(0x1f4301ce5cb2872e), UINT64_C(0x1f42f90f68b046f0)
    },
    {   UINT64_C(0x0000000000005538), UINT64_C(0x1f43000eecb5e70d), UINT64_C(0x1f43228e9ca06738),
        UINT64_C(0x1f42fe0e40b18700), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000140ef), UINT64_C(0x105ad98c6c7ae5a9), UINT64_C(0x0eaae84f6c75a5b6),
        UINT64_C(0x0cfaeccc6c73c6a2), UINT64_C(0x0fa2ed4f6c75a5b6)
    },
    {   UINT64_C(0x000000000000553a), UINT64_C(0x1f4307cee4ae0725), UINT64_C(0x1f4300907cb626c7),
        UINT64_C(0x1f42fb8ee8b346e8), UINT64_C(0x1f4303cf1cb706e9)
    },
    {   UINT64_C(0x000000000000553b), UINT64_C(0x0000000000000000), UINT64_C(0x1f43068fa4b1e6f3),
        UINT64_C(0x1f4300ce78b2e739), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000553c), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe0e80b3072f),
        UINT64_C(0x1f43030efcb0670e), UINT64_C(0x1f42fd0ee8b4a6f5)
    },
    {   UINT64_C(0x00000000000140f3), UINT64_C(0x0fa2ed4f6c75a690), UINT64_C(0x10c2ec4f6c7a2690),
        UINT64_C(0x16faed4f6c930690), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000553e), UINT64_C(0x1f43000eb4b7470c), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f90eb4aea71d), UINT64_C(0x1f43020e9cb08702)
    },
    {   UINT64_C(0x000000000000553f), UINT64_C(0x1f42ff0e6caba72e), UINT64_C(0x1f42fb8f48b426ee),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430a8e3cac073a)
    },
    {   UINT64_C(0x0000000000005540), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb0f48b0671c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43010e6cac2731)
    },
    {   UINT64_C(0x0000000000005541), UINT64_C(0x1f4305cf58abe6f2), UINT64_C(0x1f42f70e70b7071c),
        UINT64_C(0x1f4302cee4b76724), UINT64_C(0x1f42fccefcb80719)
    },
    {   UINT64_C(0x00000000000064e5), UINT64_C(0x1f42fa0fd8b6c711), UINT64_C(0x1f42f94f4cafe71d),
        UINT64_C(0x1f42fecef0a98716), UINT64_C(0x1f42f64f30b8c70a)
    },
    {   UINT64_C(0x0000000000005543), UINT64_C(0x1f42fc8f9cb766d5), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f90eacad0708), UINT64_C(0x1f42fd8e6cad273f)
    },
    {   UINT64_C(0x0000000000005544), UINT64_C(0x1f43014eccb0c72f), UINT64_C(0x1f43010f94b2c6f6),
        UINT64_C(0x1f43010f3cae06d1), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005545), UINT64_C(0x1f42ff0fa8b626f7), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc8ff0b446d2), UINT64_C(0x1f43010f30b68725)
    },
    {   UINT64_C(0x0000000000005546), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fbced0b6e6fe), UINT64_C(0x1f43034f20b28706)
    },
    {   UINT64_C(0x00000000000140fd), UINT64_C(0x1692f4cf5894e695), UINT64_C(0x0e92ed4f6c7425b7),
        UINT64_C(0x0f32eccf6073e5b4), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005548), UINT64_C(0x1f43054fbcb00713), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4304cf34a7871e), UINT64_C(0x1f4305cfacb1e714)
    },
    {   UINT64_C(0x0000000000005549), UINT64_C(0x1f43000fa8b1c717), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd0eccb746fa), UINT64_C(0x1f42fc0e9cb2a6c2)
    },
    {   UINT64_C(0x0000000000014100), UINT64_C(0x0000000000000000), UINT64_C(0x14dae54fa08f2771),
        UINT64_C(0x18ab020c6c9aa685), UINT64_C(0x12e2e60fa090c79b)
    },
    {   UINT64_C(0x000000000000554b), UINT64_C(0x1f4305cf20b76729), UINT64_C(0x1f43084f04b0670a),
        UINT64_C(0x1f4306ceaca72735), UINT64_C(0x1f43020edcb56731)
    },
    {   UINT64_C(0x00000000000064ea), UINT64_C(0x1f42fd0e3cb4c6ff), UINT64_C(0x1f42fd0fa4b4e6e0),
        UINT64_C(0x1f42fa0f10b646fa), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000554d), UINT64_C(0x1f4301cf5cb32726), UINT64_C(0x1f42fc8f0cb5471b),
        UINT64_C(0x1f43044eb0b00714), UINT64_C(0x1f42fe0e98af0729)
    },
    {   UINT64_C(0x000000000000554e), UINT64_C(0x1f42f90f9cb6c723), UINT64_C(0x1f42f78facb6c6e5),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43034e9cb4c717)
    },
    {   UINT64_C(0x0000000000014105), UINT64_C(0x15c2d14cc0984685), UINT64_C(0x14dae54fa08f2685),
        UINT64_C(0x1cfade4fa0b7a68e), UINT64_C(0x118aeb8f58832696)
    },
    {   UINT64_C(0x0000000000005550), UINT64_C(0x1f43054f54b1c6d8), UINT64_C(0x1f42fecec8a98702),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4305ce44b48718)
    },
    {   UINT64_C(0x0000000000014107), UINT64_C(0x1bd2e58f70b08685), UINT64_C(0x180ae60fa0a16685),
        UINT64_C(0x1692fb4f58982695), UINT64_C(0x17fae54fa0a12685)
    },
    {   UINT64_C(0x0000000000014108), UINT64_C(0x1272e68fa08ae685), UINT64_C(0x14dafe4f58974695),
        UINT64_C(0x131b020fa093a685), UINT64_C(0x14d306cf58978685)
    },
    {   UINT64_C(0x0000000000014109), UINT64_C(0x1a0b000fa0a48685), UINT64_C(0x12fadecfa090a685),
        UINT64_C(0x1812e60cc0a18685), UINT64_C(0x17b30c0fa0a00685)
    },
    {   UINT64_C(0x0000000000005554), UINT64_C(0x1f43000e6caf6716), UINT64_C(0x1f43000eecb5e70c),
        UINT64_C(0x1f43000fc8ad86d5), UINT64_C(0x1f43014f28b8e72a)
    },
    {   UINT64_C(0x0000000000005555), UINT64_C(0x0000000000000000), UINT64_C(0x1f4305cee8af273a),
        UINT64_C(0x1f43054fa8b44710), UINT64_C(0x1f42fd0ef4af070a)
    },
    {   UINT64_C(0x00000000000100ed), UINT64_C(0x0e62f40f74780684), UINT64_C(0x0de2f58f7473a5a1),
        UINT64_C(0x0e32f58cbc79e693), UINT64_C(0x0ed2f18c6c75c5a1)
    },
    {   UINT64_C(0x000000000001410d), UINT64_C(0x0f82f38f6c78c69f), UINT64_C(0x0d7af38f6c7265b6),
        UINT64_C(0x1c12ed0f6cadc5b6), UINT64_C(0x0c82eb4f6c6dc5b6)
    },
    {   UINT64_C(0x0000000000005558), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc8eccb1471a),
        UINT64_C(0x1f42ff0ff4aca6cc), UINT64_C(0x1f43000eb8b34710)
    },
    {   UINT64_C(0x0000000000005559), UINT64_C(0x1f43000e6cb5a739), UINT64_C(0x1f43014f1cb726f9),
        UINT64_C(0x1f42fd8f48b4e709), UINT64_C(0x1f4306ce98b24729)
    },
    {   UINT64_C(0x000000000000555a), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4303cf40ab66fc), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000014111), UINT64_C(0x1772f50c6c9826a3), UINT64_C(0x0e42e48f6c7e65b6),
        UINT64_C(0x10f2f68cd47e85b6), UINT64_C(0x109afa0f7c7d25b6)
    },
    {   UINT64_C(0x0000000000014112), UINT64_C(0x1902f70f7c9ec5b6), UINT64_C(0x1902f70cd49ec5b6),
        UINT64_C(0x1292f54f6c8405b6), UINT64_C(0x1792f8cf6c9905b6)
    },
    {   UINT64_C(0x0000000000014113), UINT64_C(0x0f5af8cf6c7725b6), UINT64_C(0x0de2eb0f6c7125b6),
        UINT64_C(0x1722f10f6c9745b6), UINT64_C(0x10d2ee8f747e05a9)
    },
    {   UINT64_C(0x0000000000014114), UINT64_C(0x0000000000000000), UINT64_C(0x0d92f38f6c7b6677),
        UINT64_C(0x105af10c6c7bc6a3), UINT64_C(0x0b82ec0f687786a1)
    },
    {   UINT64_C(0x0000000000014115), UINT64_C(0x0cfaf38f6c76c5b6), UINT64_C(0x0c2aee0f6c6a85b6),
        UINT64_C(0x08b2f30f7c618694), UINT64_C(0x08b2f38f7c6e4677)
    },
    {   UINT64_C(0x0000000000014116), UINT64_C(0x08b2c5cc6464e695), UINT64_C(0x15b2e20f6c9085b6),
        UINT64_C(0x16eaf10f6c9565b6), UINT64_C(0x1162f10f7c7ee6a3)
    },
    {   UINT64_C(0x0000000000005561), UINT64_C(0x1f42fd4ebcb70743), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff8fb8b2c71e), UINT64_C(0x1f42fd0ef8aa870f)
    },
    {   UINT64_C(0x0000000000005562), UINT64_C(0x1f42fd0ec0b22709), UINT64_C(0x1f42fdd000b446fd),
        UINT64_C(0x1f42fc0e70b4e727), UINT64_C(0x1f42fe8e6cb6871d)
    },
    {   UINT64_C(0x0000000000005563), UINT64_C(0x1f430e8e4ca7a71a), UINT64_C(0x1f42fe0e6cb92706),
        UINT64_C(0x1f4301cf40af66c1), UINT64_C(0x1f43000f3cb0e719)
    },
    {   UINT64_C(0x0000000000005564), UINT64_C(0x0000000000000000), UINT64_C(0x1f4300cea0b2671d),
        UINT64_C(0x1f42fe8ee0b5e70b), UINT64_C(0x1f4305cefcb646ff)
    },
    {   UINT64_C(0x0000000000005565), UINT64_C(0x1f42fe0f40b3c6e2), UINT64_C(0x1f42ff102cb366db),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005566), UINT64_C(0x1f4300cef0afe713), UINT64_C(0x1f43000eb4b8e73e),
        UINT64_C(0x1f4301cf94b62729), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005567), UINT64_C(0x1f43004e50b50740), UINT64_C(0x1f4303cef4af6709),
        UINT64_C(0x1f42fe0e9cb3a6f6), UINT64_C(0x1f43000ea4aa6715)
    },
    {   UINT64_C(0x00000000000064f8), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f84f24b56721),
        UINT64_C(0x1f42fecefcb28703), UINT64_C(0x1f42fb0ff4b2470e)
    },
    {   UINT64_C(0x0000000000005569), UINT64_C(0x1f43010f80b22726), UINT64_C(0x1f42fd0ee0b3671a),
        UINT64_C(0x1f430e0f4caca709), UINT64_C(0x1f4300cfb4b2c713)
    },
    {   UINT64_C(0x000000000000556a), UINT64_C(0x1f43000f3cb3871a), UINT64_C(0x1f42f90f80b60739),
        UINT64_C(0x1f43150e4cb6e738), UINT64_C(0x1f42fd8f5cb3c6f6)
    },
    {   UINT64_C(0x000000000000556b), UINT64_C(0x1f430bce8cb9672f), UINT64_C(0x1f43000e9ca9271d),
        UINT64_C(0x1f43038e5cb1e73a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000556c), UINT64_C(0x1f42f88e8cb6471d), UINT64_C(0x1f42fd0fc0b346d9),
        UINT64_C(0x1f42ff8ee0b3070e), UINT64_C(0x1f42fd8f6cb36700)
    },
    {   UINT64_C(0x000000000000556d), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd0f40b2470e),
        UINT64_C(0x1f43104f58aa66fc), UINT64_C(0x1f43020ed0af8731)
    },
    {   UINT64_C(0x0000000000014124), UINT64_C(0x10dae60fa08ea72a), UINT64_C(0x0b42f5cf7c77a636),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000556f), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff0efcafc714),
        UINT64_C(0x1f43148edcabc6fd), UINT64_C(0x1f43140ef8b14718)
    },
    {   UINT64_C(0x0000000000005570), UINT64_C(0x1f43024f44b646ff), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43010ef0b2e725), UINT64_C(0x1f42fb0e98abe721)
    },
    {   UINT64_C(0x0000000000005571), UINT64_C(0x1f43014f0cb3670c), UINT64_C(0x1f4301cec8b44724),
        UINT64_C(0x1f42fb8ec0b8871e), UINT64_C(0x1f43018e54b2073b)
    },
    {   UINT64_C(0x0000000000005572), UINT64_C(0x1f43010ebcb4c726), UINT64_C(0x1f42fd8e20b1e728),
        UINT64_C(0x1f42fe0ebcb166f1), UINT64_C(0x1f43054ed4ad8725)
    },
    {   UINT64_C(0x0000000000005573), UINT64_C(0x1f42fd0f54b5a70b), UINT64_C(0x1f42ff8efcb0e6f3),
        UINT64_C(0x1f4304cec0b28724), UINT64_C(0x1f42ff8e90b7271c)
    },
    {   UINT64_C(0x00000000000064fe), UINT64_C(0x1f42fb0f98b5e72f), UINT64_C(0x1f42fdcfe4b16703),
        UINT64_C(0x1f42fc0eecb68706), UINT64_C(0x1f42fb0ebcb6e710)
    },
    {   UINT64_C(0x0000000000005575), UINT64_C(0x1f4300cefcafe72a), UINT64_C(0x1f42fb0ee4b12709),
        UINT64_C(0x1f43004e6cb56719), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000064ff), UINT64_C(0x1f42fc0eccb4c711), UINT64_C(0x1f42f90eb4b0e725),
        UINT64_C(0x1f42fc0fe8b5a711), UINT64_C(0x1f42fb0ebcb46725)
    },
    {   UINT64_C(0x0000000000005577), UINT64_C(0x1f4303ce74b4673d), UINT64_C(0x1f43000fb0b0e6f0),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4302cfbcb44739)
    },
    {   UINT64_C(0x0000000000005578), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd0e64b6c721),
        UINT64_C(0x1f42fe1094b4a706), UINT64_C(0x1f43030f08acc6ee)
    },
    {   UINT64_C(0x0000000000005579), UINT64_C(0x1f42ff0efcb4070e), UINT64_C(0x1f43034e5cb7473b),
        UINT64_C(0x1f42fd8e60b1c723), UINT64_C(0x1f43054ec8b52715)
    },
    {   UINT64_C(0x000000000000557a), UINT64_C(0x1f42f98f04b5c70d), UINT64_C(0x1f4304cf2ca7a722),
        UINT64_C(0x1f42fe0eecb5e725), UINT64_C(0x1f4302cfd8b346f6)
    },
    {   UINT64_C(0x0000000000005b54), UINT64_C(0x0000000000000000), UINT64_C(0x1f430b0f08b346fb),
        UINT64_C(0x1f43078eb8b36702), UINT64_C(0x1f43088f24b2271a)
    },
    {   UINT64_C(0x0000000000010100), UINT64_C(0x0000000000000000), UINT64_C(0x131aee4fa08d6740),
        UINT64_C(0x169aff8c60916675), UINT64_C(0x11cae50fa089e77a)
    },
    {   UINT64_C(0x000000000000557d), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb8f98b346f1),
        UINT64_C(0x1f42f88e6cb5a71b), UINT64_C(0x1f42fc8f74b7870e)
    },
    {   UINT64_C(0x000000000000557e), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f94f18b5a705),
        UINT64_C(0x1f43020eb8b0672f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000557f), UINT64_C(0x1f43024f9cb2e723), UINT64_C(0x1f42f64f48b5c6e8),
        UINT64_C(0x1f42fb8ff0b5c6f9), UINT64_C(0x1f42fc0e60b82747)
    },
    {   UINT64_C(0x0000000000005580), UINT64_C(0x1f430b8eb8aca715), UINT64_C(0x1f43014f3cb426fa),
        UINT64_C(0x1f4307cf28afa70e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005581), UINT64_C(0x1f42ff0e6cb3c731), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4300cf10b5673d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005582), UINT64_C(0x1f42fa0ec4ac473e), UINT64_C(0x1f43058e9cb1c748),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005583), UINT64_C(0x1f42fe8ef0aca6ff), UINT64_C(0x1f42ff8ea8b6c733),
        UINT64_C(0x1f43014e58ad871f), UINT64_C(0x1f42fe5050b606e2)
    },
    {   UINT64_C(0x0000000000005584), UINT64_C(0x1f42ff0ea0b6a731), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43014f8cb3e709), UINT64_C(0x1f42fc8f78ae46be)
    },
    {   UINT64_C(0x0000000000005585), UINT64_C(0x1f43034f70b486e3), UINT64_C(0x1f43024eecae66f3),
        UINT64_C(0x1f4303ce34b38738), UINT64_C(0x1f43134e60b14736)
    },
    {   UINT64_C(0x0000000000005586), UINT64_C(0x1f42fe8f54aa6722), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc8f0cb68726)
    },
    {   UINT64_C(0x0000000000005587), UINT64_C(0x1f42fb0e4cb6c729), UINT64_C(0x1f42fb0e9cb906ef),
        UINT64_C(0x1f42f88f88b18722), UINT64_C(0x1f42f84e9cb1e6e7)
    },
    {   UINT64_C(0x0000000000005588), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff8f0cab271b)
    },
    {   UINT64_C(0x0000000000005589), UINT64_C(0x1f42fe0f48b44709), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc8f78aca70a)
    },
    {   UINT64_C(0x0000000000010107), UINT64_C(0x1972e5cfa0a96675), UINT64_C(0x1622e78fa09c2675),
        UINT64_C(0x1642fd0f5895e683), UINT64_C(0x1602e6cfa09ba675)
    },
    {   UINT64_C(0x000000000000558b), UINT64_C(0x1f43014f08b666f5), UINT64_C(0x1f42fc8f30ae670e),
        UINT64_C(0x1f42fece8cb7e708), UINT64_C(0x1f4301ceccb3a734)
    },
    {   UINT64_C(0x0000000000010108), UINT64_C(0x11c2e80fa086c675), UINT64_C(0x14dafecf5894c682),
        UINT64_C(0x1162ff8fa08f0675), UINT64_C(0x1483098f68980675)
    },
    {   UINT64_C(0x000000000000558d), UINT64_C(0x1f42ff8e70b54726), UINT64_C(0x1f42fe0f00b3e741),
        UINT64_C(0x1f42f54e6cb3a723), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000010109), UINT64_C(0x1823004fa09d4675), UINT64_C(0x11fadd4fa08ba675),
        UINT64_C(0x1612e7ccd49be675), UINT64_C(0x1372fb8fa0916675)
    },
    {   UINT64_C(0x000000000000558f), UINT64_C(0x0000000000000000), UINT64_C(0x1f43024e5cb0670e),
        UINT64_C(0x1f43024e8cb0671a), UINT64_C(0x1f42fa8f6cb04701)
    },
    {   UINT64_C(0x000000000001010a), UINT64_C(0x1d42ea8fa0b8a675), UINT64_C(0x1d42ea8cd4b8a675),
        UINT64_C(0x15bafdcfa0900675), UINT64_C(0x1aa2e70fa0ae2675)
    },
    {   UINT64_C(0x0000000000008c0c), UINT64_C(0x2c22f95114e96589), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000650d), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f70e58b6473b),
        UINT64_C(0x1f42f80f1cb56705), UINT64_C(0x1f42fa0eccb3c727)
    },
    {   UINT64_C(0x0000000000005593), UINT64_C(0x1f42ff0f2cad2732), UINT64_C(0x1f42ff0fb8b0670c),
        UINT64_C(0x1f42fb0f1cb08739), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001010c), UINT64_C(0x1012f3cf747ac5a1), UINT64_C(0x0f92f70f74816693),
        UINT64_C(0x0dd2f5cf747365a1), UINT64_C(0x0c32ee4f746e85a1)
    },
    {   UINT64_C(0x0000000000005595), UINT64_C(0x1f42fc0fa4b506f4), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43004eccb0e73f)
    },
    {   UINT64_C(0x0000000000005596), UINT64_C(0x1f42fa4fccb826c1), UINT64_C(0x1f42fd8eb4b92724),
        UINT64_C(0x1f43040eb0b0670d), UINT64_C(0x1f42ff0f88b0670e)
    },
    {   UINT64_C(0x0000000000005597), UINT64_C(0x1f42fc0ef0b10741), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd0fccb72718), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005598), UINT64_C(0x1f42f84f40b3e71a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43014fa0b2c734), UINT64_C(0x1f43004ed8ace6e8)
    },
    {   UINT64_C(0x0000000000005599), UINT64_C(0x1f42fd0e78b6c730), UINT64_C(0x1f43010eb4b6073b),
        UINT64_C(0x1f43004edcb20706), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000559a), UINT64_C(0x1f4314cf78aaa715), UINT64_C(0x1f43028fa4b16712),
        UINT64_C(0x1f42fd8eccb78715), UINT64_C(0x1f42fe8ee4b4e73a)
    },
    {   UINT64_C(0x000000000000559b), UINT64_C(0x1f42fd8fd4b4a71a), UINT64_C(0x1f42f88f28b42702),
        UINT64_C(0x1f42fe0e68b6c70c), UINT64_C(0x1f42fa8e70b16724)
    },
    {   UINT64_C(0x000000000000559c), UINT64_C(0x1f42f98f18b6a72d), UINT64_C(0x1f42f98e68b5c730),
        UINT64_C(0x1f42fa8ee4b5a730), UINT64_C(0x1f43004f14b04724)
    },
    {   UINT64_C(0x000000000000559d), UINT64_C(0x1f43000ea0b26748), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4302ce88b0273f), UINT64_C(0x1f42fe8fecb5c703)
    },
    {   UINT64_C(0x000000000000559e), UINT64_C(0x1f42fa8f70b3e70b), UINT64_C(0x1f42fd8ed4b3c72c),
        UINT64_C(0x1f42fd0ea0b40708), UINT64_C(0x1f42fe0f8cb5c70c)
    },
    {   UINT64_C(0x000000000000559f), UINT64_C(0x1f42fc0ed8b1670e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb8ea4b0a725), UINT64_C(0x1f42fe8e8cb64715)
    },
    {   UINT64_C(0x00000000000055a0), UINT64_C(0x1f42fd8e48afe736), UINT64_C(0x1f42fb8e98ab6701),
        UINT64_C(0x1f42fb8f8cb246dd), UINT64_C(0x1f42f3cf60b646bd)
    },
    {   UINT64_C(0x00000000000055a1), UINT64_C(0x1f42fb8ea4b3072b), UINT64_C(0x1f42f98e84aee6f9),
        UINT64_C(0x1f42fb0ea0ae8739), UINT64_C(0x1f42f84e88b62725)
    },
    {   UINT64_C(0x00000000000055a2), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb4e8cb4e743), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000055a3), UINT64_C(0x1f42ff8eacb76721), UINT64_C(0x1f42ff8f44b3e72a),
        UINT64_C(0x1f42fa4e60b3e738), UINT64_C(0x1f42f98e70b4a722)
    },
    {   UINT64_C(0x00000000000055a4), UINT64_C(0x1f42fb8e34b36745), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc8ee0b50731)
    },
    {   UINT64_C(0x00000000000055a5), UINT64_C(0x1f42f98e80b22722), UINT64_C(0x1f42fa8e60abc741),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0edcb9071b)
    },
    {   UINT64_C(0x0000000000010115), UINT64_C(0x0d62f48f7475a5a1), UINT64_C(0x0c2aebcf6c6925a2),
        UINT64_C(0x08b2f8cf745ec676), UINT64_C(0x08b2f8cf746b2646)
    },
    {   UINT64_C(0x00000000000055a7), UINT64_C(0x1f42fd0ee8b306f5), UINT64_C(0x1f42fe8e70af6735),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000010116), UINT64_C(0x08b2c30c645b6674), UINT64_C(0x153ae30f708d65a1),
        UINT64_C(0x15caf34f748fa5a1), UINT64_C(0x0ffaf30f7c7a6693)
    },
    {   UINT64_C(0x00000000000055a9), UINT64_C(0x0000000000000000), UINT64_C(0x1f43040fa8b1c720),
        UINT64_C(0x1f43014f70b566d2), UINT64_C(0x1f43000f1cb1072c)
    },
    {   UINT64_C(0x00000000000055aa), UINT64_C(0x1f42fa4f20b3e71d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff0f00ae66fa), UINT64_C(0x1f42f60f9cb76706)
    },
    {   UINT64_C(0x00000000000055ab), UINT64_C(0x1f42fc0fdcae870c), UINT64_C(0x1f42f50f5cb0a722),
        UINT64_C(0x1f4313ce48ac072e), UINT64_C(0x1f42fe0ec8ada703)
    },
    {   UINT64_C(0x0000000000010118), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x154af2cfa08c2675), UINT64_C(0x10f2f14f747d8693)
    },
    {   UINT64_C(0x00000000000055ad), UINT64_C(0x1f42f4ce8cb6e732), UINT64_C(0x1f42ff8e8cb1a733),
        UINT64_C(0x1f42ff0f48b4471f), UINT64_C(0x1f42fe0e38b4672b)
    },
    {   UINT64_C(0x000000000000651b), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cedcb426f2),
        UINT64_C(0x1f42f80e90b5472b), UINT64_C(0x1f42f80e5cb7a704)
    },
    {   UINT64_C(0x00000000000055af), UINT64_C(0x1f4304cf0cb2e73b), UINT64_C(0x1f43010e80b5873d),
        UINT64_C(0x1f43034ea8ad6735), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000055b0), UINT64_C(0x1f42f88ebcb7e72c), UINT64_C(0x1f42fe0e5cb4e72a),
        UINT64_C(0x1f43058ec0ae272e), UINT64_C(0x1f42fb0ee8b6c6fe)
    },
    {   UINT64_C(0x00000000000055b1), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb0f28b78702),
        UINT64_C(0x1f43010e78b1274f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000055b2), UINT64_C(0x1f42fd0ec8b66740), UINT64_C(0x1f42fd0ef8b46710),
        UINT64_C(0x1f43064e34b38744), UINT64_C(0x1f43020e50b50731)
    },
    {   UINT64_C(0x00000000000055b3), UINT64_C(0x1f42f84ebcb7c736), UINT64_C(0x1f43000ee0b60721),
        UINT64_C(0x1f42f98f2cb5c733), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000055b4), UINT64_C(0x0000000000000000), UINT64_C(0x1f43010e80aca730),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff0eb8af8738)
    },
    {   UINT64_C(0x00000000000055b5), UINT64_C(0x1f42ff8e70b1a731), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43188f58a8e6ed)
    },
    {   UINT64_C(0x00000000000055b6), UINT64_C(0x1f43174f24a6e708), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f431bcfe8a5a6f5), UINT64_C(0x1f430b5164ad6677)
    },
    {   UINT64_C(0x00000000000055b7), UINT64_C(0x0000000000000000), UINT64_C(0x1f43178f8ca5e703),
        UINT64_C(0x1f430e50b8af66b2), UINT64_C(0x1f43244ec0a9c72a)
    },
    {   UINT64_C(0x00000000000055b8), UINT64_C(0x1f431acf7ca686f9), UINT64_C(0x1f43180f88a6e6f9),
        UINT64_C(0x1f431acf38a606e7), UINT64_C(0x1f431acf38a606e7)
    },
    {   UINT64_C(0x00000000000055b9), UINT64_C(0x1f43190f68a606ff), UINT64_C(0x1f431b4edca8c6e3),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f431a4f18a766f7)
    },
    {   UINT64_C(0x00000000000055ba), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4323cec0a6272d), UINT64_C(0x1f43178eaca686e7)
    },
    {   UINT64_C(0x00000000000055bb), UINT64_C(0x0000000000000000), UINT64_C(0x1f431a4f38a546e7),
        UINT64_C(0x1f43174f48a5e6fe), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000055bc), UINT64_C(0x1f43178f98a56701), UINT64_C(0x1f4325cf2ca1c711),
        UINT64_C(0x1f43178f88a6a6f9), UINT64_C(0x1f43178f88a6a6f9)
    },
    {   UINT64_C(0x00000000000055bd), UINT64_C(0x1f431a0f68a786f0), UINT64_C(0x1f43190f38a606e7),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43174f68a6c6fc)
    },
    {   UINT64_C(0x00000000000055be), UINT64_C(0x0000000000000000), UINT64_C(0x1f43194f68a766fd),
        UINT64_C(0x1f431acf38a6e6f2), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000055bf), UINT64_C(0x0000000000000000), UINT64_C(0x1f431a8f58a806e7),
        UINT64_C(0x1f431a4f38a506ea), UINT64_C(0x1f43170f28a8e708)
    },
    {   UINT64_C(0x00000000000055c0), UINT64_C(0x1f43180f18a686f8), UINT64_C(0x1f43198f28a706ed),
        UINT64_C(0x1f43194f28a766ee), UINT64_C(0x1f43188f48a766ff)
    },
    {   UINT64_C(0x00000000000055c1), UINT64_C(0x1f43184fa4a4a711), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43194f18a6e6fc), UINT64_C(0x1f43134ebca7e710)
    },
    {   UINT64_C(0x00000000000055c2), UINT64_C(0x1f43188f28a8a706), UINT64_C(0x1f43160f58a74718),
        UINT64_C(0x1f43150eeca7471b), UINT64_C(0x1f43190f38a8c714)
    },
    {   UINT64_C(0x00000000000055c3), UINT64_C(0x1f43170f18a5a700), UINT64_C(0x1f43128ecca5870e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43160f28a76706)
    },
    {   UINT64_C(0x00000000000055c4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43174f08a9270c), UINT64_C(0x1f43120ecca6870a)
    },
    {   UINT64_C(0x00000000000055c5), UINT64_C(0x1f43174f18a8e6f7), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43160eeca74711), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000055c6), UINT64_C(0x1f4315cecca6e721), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f431a8f38a70706), UINT64_C(0x1f43190efca64707)
    },
    {   UINT64_C(0x00000000000055c7), UINT64_C(0x1f43190f1ca6c703), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43148ebcaac71e), UINT64_C(0x1f430a506cb366e9)
    },
    {   UINT64_C(0x00000000000055c8), UINT64_C(0x1f42fb4fa0b326f3), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb0ee0b466ee), UINT64_C(0x1f43154f90b2c6f5)
    },
    {   UINT64_C(0x00000000000055c9), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f250c0b966e2), UINT64_C(0x1f43058fa0afc6dc)
    },
    {   UINT64_C(0x0000000000006529), UINT64_C(0x1f42fb0f7cb626ff), UINT64_C(0x1f42ff0f44a6e70e),
        UINT64_C(0x1f42fa5000b4c704), UINT64_C(0x1f42fa0f18ad8717)
    },
    {   UINT64_C(0x00000000000055cb), UINT64_C(0x1f42fcced4b20709), UINT64_C(0x1f43114f70ace715),
        UINT64_C(0x1f42ff8facb4c6e6), UINT64_C(0x1f42fad0acb586cb)
    },
    {   UINT64_C(0x00000000000055cc), UINT64_C(0x1f4300cffcb9e725), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f9ceeca86722)
    },
    {   UINT64_C(0x00000000000055cd), UINT64_C(0x1f4303cf90ad4710), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43004f7cb266ee)
    },
    {   UINT64_C(0x00000000000055ce), UINT64_C(0x1f4302111cb1a6dd), UINT64_C(0x1f42fe8f94aca70b),
        UINT64_C(0x1f4304cf78b0e6de), UINT64_C(0x1f42fa8e7cb1e705)
    },
    {   UINT64_C(0x00000000000055cf), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f88fbcb746de), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000055d0), UINT64_C(0x1f42fe9090b526e1), UINT64_C(0x1f42fc4f50b6e6e5),
        UINT64_C(0x1f42fe9050b606e2), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000055d1), UINT64_C(0x0000000000000000), UINT64_C(0x1f43010f5cb806ed),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43028ef4ad472a)
    },
    {   UINT64_C(0x0000000000000740), UINT64_C(0x106af74fa07b259f), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000055d3), UINT64_C(0x1f4310cf70b486ff), UINT64_C(0x1f42f98f1cb74711),
        UINT64_C(0x1f43004f64b4a71a), UINT64_C(0x1f42fc4f4cb0c6f6)
    },
    {   UINT64_C(0x00000000000055d4), UINT64_C(0x1f43108fb0b04701), UINT64_C(0x1f42fecfccb5e713),
        UINT64_C(0x1f431a0fa0adc704), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000743), UINT64_C(0x0000000000000000), UINT64_C(0x106af70fa07b8596),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000055d6), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430f4fc0b446df), UINT64_C(0x1f42fe509cb086fe)
    },
    {   UINT64_C(0x00000000000055d7), UINT64_C(0x1f42fd8fc0ab66d5), UINT64_C(0x1f42fecf78a906fe),
        UINT64_C(0x1f42fdcefcaea72e), UINT64_C(0x1f43019028b326f3)
    },
    {   UINT64_C(0x0000000000000746), UINT64_C(0x106afa4fa079e597), UINT64_C(0x106af00f807aa596),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000747), UINT64_C(0x106af50f807c8596), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000055da), UINT64_C(0x1f42fd0fc8b146eb), UINT64_C(0x1f42fecf6cb226e9),
        UINT64_C(0x1f42ff4eacb56729), UINT64_C(0x1f42fe4f2ca6e6e1)
    },
    {   UINT64_C(0x00000000000055db), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff1000b386d2),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f95020ace6db)
    },
    {   UINT64_C(0x00000000000055dc), UINT64_C(0x1f42ff8f54af46d2), UINT64_C(0x1f43020fb4b4c6e8),
        UINT64_C(0x1f42ff0f18af66f2), UINT64_C(0x1f42ff0f70afe6d9)
    },
    {   UINT64_C(0x00000000000055dd), UINT64_C(0x1f43134f94aca70a), UINT64_C(0x1f42fdd064af06c6),
        UINT64_C(0x1f42fd4f44b5e6ce), UINT64_C(0x1f42f64f34b50701)
    },
    {   UINT64_C(0x00000000000055de), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa4f94b2a6e0)
    },
    {   UINT64_C(0x00000000000055df), UINT64_C(0x1f42fcce9cb0a710), UINT64_C(0x1f42f84f44b8a716),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f74ef0b6e6e5)
    },
    {   UINT64_C(0x00000000000055e0), UINT64_C(0x1f42fd8f00b206e2), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4300cf88b4c6ff), UINT64_C(0x1f42fd103cb1c6e3)
    },
    {   UINT64_C(0x00000000000055e1), UINT64_C(0x1f43114fb4afc70d), UINT64_C(0x1f42fe8ff4b18701),
        UINT64_C(0x1f43024ef8a8a70a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000055e2), UINT64_C(0x1f43028ee0b1470a), UINT64_C(0x1f43000f74b2870a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43030f70ab071f)
    },
    {   UINT64_C(0x00000000000055e3), UINT64_C(0x1f42fd0f18ab66d7), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fcce88b46725)
    },
    {   UINT64_C(0x00000000000055e4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430b8f94af4732), UINT64_C(0x1f42fb0f50adc6f9)
    },
    {   UINT64_C(0x00000000000055e5), UINT64_C(0x1f430d8f50aee6fc), UINT64_C(0x1f4310ceecade72e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f4cfd8b886e0)
    },
    {   UINT64_C(0x00000000000055e6), UINT64_C(0x1f42f44fc4b906de), UINT64_C(0x1f42f7cf14b466fc),
        UINT64_C(0x1f43020efcb06732), UINT64_C(0x1f42facf18b6c6ff)
    },
    {   UINT64_C(0x00000000000055e7), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0f7cb4471b),
        UINT64_C(0x1f42fd0f44b2c6ef), UINT64_C(0x1f4300ce3cb70733)
    },
    {   UINT64_C(0x00000000000055e8), UINT64_C(0x1f42fd0f34b726ed), UINT64_C(0x1f43040f68aa66f6),
        UINT64_C(0x1f42fb0fa8ad26f3), UINT64_C(0x1f42fa5064b5e6ee)
    },
    {   UINT64_C(0x00000000000055e9), UINT64_C(0x1f42f5cfa0b3e6d6), UINT64_C(0x1f42f74f2cb8e6f1),
        UINT64_C(0x1f43134f9cad4706), UINT64_C(0x1f42fccfdcaa26e3)
    },
    {   UINT64_C(0x00000000000055ea), UINT64_C(0x0000000000000000), UINT64_C(0x1f4311cf9cab26f0),
        UINT64_C(0x1f42fa0eacb5671b), UINT64_C(0x1f430f4f90aec71b)
    },
    {   UINT64_C(0x00000000000055eb), UINT64_C(0x0000000000000000), UINT64_C(0x1f4304d0ccb346e2),
        UINT64_C(0x1f42f90e98b90739), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000055ec), UINT64_C(0x1f42fd0e9cb40705), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43020f88b0870f), UINT64_C(0x1f42f70eccb70715)
    },
    {   UINT64_C(0x00000000000055ed), UINT64_C(0x1f42fe10a0ad86e0), UINT64_C(0x1f43000f4caf86f2),
        UINT64_C(0x1f42fa4e5cb1872d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000055ee), UINT64_C(0x1f42f78f68b3e6ef), UINT64_C(0x1f42fecf08b186de),
        UINT64_C(0x1f42fd8ec4b0070c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000055ef), UINT64_C(0x1f430c4f30aac6f2), UINT64_C(0x1f43154f30ae2724),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f98ef4b2a721)
    },
    {   UINT64_C(0x00000000000055f0), UINT64_C(0x1f43054e3cafe72b), UINT64_C(0x1f4301cf2cb7471a),
        UINT64_C(0x1f42f9cf10b5e6d9), UINT64_C(0x1f42fd4f78b5c72e)
    },
    {   UINT64_C(0x00000000000055f1), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff8edca94727), UINT64_C(0x1f42f68ed8aaa712)
    },
    {   UINT64_C(0x00000000000055f2), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc9070b6a6ee)
    },
    {   UINT64_C(0x00000000000055f3), UINT64_C(0x1f42fa4eb8b7270e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f84f2cb4273f), UINT64_C(0x1f42ffcfd0b746dc)
    },
    {   UINT64_C(0x00000000000055f4), UINT64_C(0x1f42f80f10b3c704), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f78edcb46739), UINT64_C(0x1f42fa8eccb56724)
    },
    {   UINT64_C(0x00000000000055f5), UINT64_C(0x1f42fa8f00ac0719), UINT64_C(0x1f42ff9028b066e4),
        UINT64_C(0x1f42fa4fb4b54702), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000764), UINT64_C(0x106af94c148b259f), UINT64_C(0x106af48c147e8651),
        UINT64_C(0x106afbcc148c859f), UINT64_C(0x106af84c148725a2)
    },
    {   UINT64_C(0x0000000000000765), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x106afc8c1476e59c)
    },
    {   UINT64_C(0x00000000000055f8), UINT64_C(0x1f43018e4cb4c751), UINT64_C(0x1f42fe8fc8b146d7),
        UINT64_C(0x1f42fa4f14b5a707), UINT64_C(0x1f43040e6caee71d)
    },
    {   UINT64_C(0x00000000000055f9), UINT64_C(0x1f42fd8eb8b3e741), UINT64_C(0x1f43030e58ae8721),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43034f50aee6ee)
    },
    {   UINT64_C(0x0000000000006541), UINT64_C(0x1f42fa0f8cb1270d), UINT64_C(0x1f42f90fe4af0706),
        UINT64_C(0x1f42fa0fc8b26706), UINT64_C(0x1f42fa0f60af2705)
    },
    {   UINT64_C(0x00000000000055fb), UINT64_C(0x1f43020e8cb54735), UINT64_C(0x1f42ff4f00b2c70d),
        UINT64_C(0x1f43030ef8b1c6f8), UINT64_C(0x1f43014f94b72704)
    },
    {   UINT64_C(0x00000000000055fc), UINT64_C(0x1f42fd4f48b4c726), UINT64_C(0x1f42fb5020b326f6),
        UINT64_C(0x1f43008e4cb58726), UINT64_C(0x1f4304cfc0ae470b)
    },
    {   UINT64_C(0x00000000000055fd), UINT64_C(0x1f43028f48b02707), UINT64_C(0x1f42f68f84b44709),
        UINT64_C(0x1f43078efcb3a71a), UINT64_C(0x1f42fd8edcb4e72d)
    },
    {   UINT64_C(0x00000000000055fe), UINT64_C(0x1f43014f54a9a6eb), UINT64_C(0x1f42fbcf6cb6471d),
        UINT64_C(0x1f42fd4f3cb8e745), UINT64_C(0x1f43008e6cb26729)
    },
    {   UINT64_C(0x00000000000055ff), UINT64_C(0x1f42fd4e74b1c71e), UINT64_C(0x1f42fece7cb2a6f9),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005600), UINT64_C(0x1f43004f74aa06cc), UINT64_C(0x1f4301cec8b4c6ca),
        UINT64_C(0x1f430e0f6cb48731), UINT64_C(0x1f43078f58aec71d)
    },
    {   UINT64_C(0x0000000000005601), UINT64_C(0x1f43034fccb10700), UINT64_C(0x1f4312cf84b78703),
        UINT64_C(0x1f42f9cefcb3e72d), UINT64_C(0x1f43180f24ac4734)
    },
    {   UINT64_C(0x0000000000005602), UINT64_C(0x1f42fd8f58aa06d6), UINT64_C(0x1f42fe8e2cb1e716),
        UINT64_C(0x1f43114f08ab870e), UINT64_C(0x1f43008f74ae06f2)
    },
    {   UINT64_C(0x0000000000005603), UINT64_C(0x1f42fdcf5cac66e1), UINT64_C(0x1f43008f88b02721),
        UINT64_C(0x1f42fe8ed8b5a71e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005604), UINT64_C(0x1f42fd0fd0afc6e6), UINT64_C(0x1f4308cf6caae715),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005605), UINT64_C(0x1f42fe8f18b346d8), UINT64_C(0x1f431acf50a7671b),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005606), UINT64_C(0x0000000000000000), UINT64_C(0x1f4307d008ae66e8),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd0f50aee6e2)
    },
    {   UINT64_C(0x0000000000005607), UINT64_C(0x1f42fb4e4cb7a739), UINT64_C(0x1f42facf6cb106e2),
        UINT64_C(0x1f4300cebcb54721), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005608), UINT64_C(0x1f42f74fa4b646fb), UINT64_C(0x1f4303cf58b2e718),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ffcf94ae8709)
    },
    {   UINT64_C(0x0000000000005b9b), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43104ff4b146f6), UINT64_C(0x1f43120e90b4e71e)
    },
    {   UINT64_C(0x000000000000560a), UINT64_C(0x1f42ff0eb0ade6fc), UINT64_C(0x1f42fa4edcb826ef),
        UINT64_C(0x1f42fc4f34b46725), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b9c), UINT64_C(0x0000000000000000), UINT64_C(0x1f43098f2cab870b),
        UINT64_C(0x1f43078ee4b38721), UINT64_C(0x1f4304cf08aa0723)
    },
    {   UINT64_C(0x000000000000560c), UINT64_C(0x1f42f88f2cb146f5), UINT64_C(0x1f42f94f58b6e72a),
        UINT64_C(0x1f431bcf7caa86d4), UINT64_C(0x1f4304cf24ac66f2)
    },
    {   UINT64_C(0x0000000000005b9d), UINT64_C(0x1f4309cf94aee6f5), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43040f0cb0670b), UINT64_C(0x1f43034e94b64717)
    },
    {   UINT64_C(0x000000000000654b), UINT64_C(0x1f42fa0f80b34712), UINT64_C(0x1f42fb1010b68712),
        UINT64_C(0x1f42f70fa4b6e711), UINT64_C(0x1f42f80fa8b1470f)
    },
    {   UINT64_C(0x000000000000560f), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fdcf7cb266f4),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43004f68b086fa)
    },
    {   UINT64_C(0x000000000000654c), UINT64_C(0x1f42fa102cb426fa), UINT64_C(0x1f42fa0fbcaea706),
        UINT64_C(0x1f42fa0ff4b2c706), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b9f), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430c4e68ab8729), UINT64_C(0x1f430ad020ae46db)
    },
    {   UINT64_C(0x0000000000000780), UINT64_C(0x106af4cb247ca657), UINT64_C(0x106afbcc0c8005a0),
        UINT64_C(0x106af3cfa07ac6ec), UINT64_C(0x106af10f887b86e1)
    },
    {   UINT64_C(0x0000000000000781), UINT64_C(0x106af3cd487ac64b), UINT64_C(0x106af10d347b864b),
        UINT64_C(0x106af3cdc07ac64b), UINT64_C(0x106af10dc87b864b)
    },
    {   UINT64_C(0x0000000000000782), UINT64_C(0x106af80c607b2701), UINT64_C(0x106b000c6078a656),
        UINT64_C(0x106af2cfa07b26ec), UINT64_C(0x106af70f887e86e1)
    },
    {   UINT64_C(0x0000000000000783), UINT64_C(0x106af2cd487b264b), UINT64_C(0x106af70d347e864b),
        UINT64_C(0x106af2cdc07b264b), UINT64_C(0x106af70dc47e864b)
    },
    {   UINT64_C(0x0000000000000784), UINT64_C(0x106af2cba07b264b), UINT64_C(0x106af70b8c7e864b),
        UINT64_C(0x106af2cc687b264b), UINT64_C(0x106af70c547e864b)
    },
    {   UINT64_C(0x0000000000005ba2), UINT64_C(0x1f43044ef0b06729), UINT64_C(0x1f43028ff0b5e6c7),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000786), UINT64_C(0x106af48c687d464b), UINT64_C(0x106afbcc5479c5a0),
        UINT64_C(0x106af48cd47d464b), UINT64_C(0x106afbcce47b25a0)
    },
    {   UINT64_C(0x0000000000000787), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af50fa07bc6ec), UINT64_C(0x106af88fa07526e6)
    },
    {   UINT64_C(0x0000000000000788), UINT64_C(0x106af78f747c86ce), UINT64_C(0x106af54c0c7e2613),
        UINT64_C(0x106af38fa07d46ec), UINT64_C(0x106af10fa07e86e1)
    },
    {   UINT64_C(0x0000000000000789), UINT64_C(0x106af38d487d464b), UINT64_C(0x106af10d487e864b),
        UINT64_C(0x106af38fa07d46ec), UINT64_C(0x106af10fa07e86e1)
    },
    {   UINT64_C(0x000000000000078a), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af38ca47d464b), UINT64_C(0x106af10ca47e864b)
    },
    {   UINT64_C(0x000000000000078b), UINT64_C(0x106afc8cd478a64b), UINT64_C(0x106b018cf877664c),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000078c), UINT64_C(0x106af48fa07c6701), UINT64_C(0x106af34fa07e0702),
        UINT64_C(0x106af48d487c664b), UINT64_C(0x106af34d487e064b)
    },
    {   UINT64_C(0x000000000000078d), UINT64_C(0x106af48dc07c664b), UINT64_C(0x106af34ddc7e064b),
        UINT64_C(0x106af60d487b864b), UINT64_C(0x106afc8d4878e64b)
    },
    {   UINT64_C(0x000000000000078e), UINT64_C(0x106af60d487b86ce), UINT64_C(0x106aeb0d4878e6bd),
        UINT64_C(0x106af60dc07b864b), UINT64_C(0x106afc8ddc78e64b)
    },
    {   UINT64_C(0x000000000000078f), UINT64_C(0x106af60c687b864b), UINT64_C(0x106afc8c6878e64b),
        UINT64_C(0x106af24fa07de701), UINT64_C(0x106aed0fa0808656)
    },
    {   UINT64_C(0x0000000000000790), UINT64_C(0x106af24fa07de6ec), UINT64_C(0x106aed0fa0808634),
        UINT64_C(0x106af24d487de64b), UINT64_C(0x106aed0d4880859d)
    },
    {   UINT64_C(0x0000000000000791), UINT64_C(0x106af50fa07c86ec), UINT64_C(0x106af10fa07e8634),
        UINT64_C(0x106af50d487c864b), UINT64_C(0x106af10d487e859d)
    },
    {   UINT64_C(0x0000000000000792), UINT64_C(0x106af50dc07c864b), UINT64_C(0x106af10ddc7e859d),
        UINT64_C(0x106af50c687c864b), UINT64_C(0x106af10c687e859d)
    },
    {   UINT64_C(0x0000000000005625), UINT64_C(0x1f4301ce98b1670f), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc8e80afc72c)
    },
    {   UINT64_C(0x0000000000006557), UINT64_C(0x1f42f84f20b5a725), UINT64_C(0x1f42fa0ebcad4716),
        UINT64_C(0x1f42f70ffcb5c702), UINT64_C(0x1f42f90fb8b646fe)
    },
    {   UINT64_C(0x0000000000000795), UINT64_C(0x106af48fa07a8701), UINT64_C(0x106af10c287b8656),
        UINT64_C(0x106af48fa07a86ec), UINT64_C(0x106af10c287b8634)
    },
    {   UINT64_C(0x0000000000005628), UINT64_C(0x1f4303cea8aee703), UINT64_C(0x1f42f94edcb38732),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fdcf2cb20716)
    },
    {   UINT64_C(0x0000000000005629), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f94f18b3c72a),
        UINT64_C(0x1f42fecef0b3270e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000562a), UINT64_C(0x1f4307cf04aea715), UINT64_C(0x1f42fe0eecb8870e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbcec0b3673a)
    },
    {   UINT64_C(0x000000000000562b), UINT64_C(0x1f431ccf44b24729), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43108ea4aa6739), UINT64_C(0x1f430c8f44a68722)
    },
    {   UINT64_C(0x000000000000079a), UINT64_C(0x106afb0d1c7986ec), UINT64_C(0x106b000d3477e635),
        UINT64_C(0x106af48fa07cc6ec), UINT64_C(0x106af44f8876a6a7)
    },
    {   UINT64_C(0x000000000000079b), UINT64_C(0x106af48d487cc64b), UINT64_C(0x106af44d3476a612),
        UINT64_C(0x106af48dc07cc64b), UINT64_C(0x106af44dc4774612)
    },
    {   UINT64_C(0x000000000000562e), UINT64_C(0x1f43004eecb2670b), UINT64_C(0x1f43030ebcb0e6fc),
        UINT64_C(0x1f42ff4f60b2e70d), UINT64_C(0x1f43018f20b00729)
    },
    {   UINT64_C(0x000000000000562f), UINT64_C(0x1f430e8f20b3c70d), UINT64_C(0x1f42f68f24b726ff),
        UINT64_C(0x1f430a8f00b4e727), UINT64_C(0x1f43010ec8a90707)
    },
    {   UINT64_C(0x0000000000005630), UINT64_C(0x0000000000000000), UINT64_C(0x1f43064f10ad0725),
        UINT64_C(0x1f430a0f54b3e6ed), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005631), UINT64_C(0x0000000000000000), UINT64_C(0x1f43164ee0ae4739),
        UINT64_C(0x1f430ccf60b006ea), UINT64_C(0x1f42f84f38af472e)
    },
    {   UINT64_C(0x0000000000005632), UINT64_C(0x1f4301cebcb3272e), UINT64_C(0x1f42fc8eacb5c711),
        UINT64_C(0x1f42f70f34b6272f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005633), UINT64_C(0x1f42f74e94b6c72b), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fccedcb2e720), UINT64_C(0x1f42fa4f88b526ee)
    },
    {   UINT64_C(0x0000000000005634), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f68ed4b78733),
        UINT64_C(0x1f42f98f3cb4272f), UINT64_C(0x1f42f94eacb4471d)
    },
    {   UINT64_C(0x0000000000005635), UINT64_C(0x1f42ff4e48b5074c), UINT64_C(0x1f42fc0e64b86739),
        UINT64_C(0x1f42fbcf24b4c6f1), UINT64_C(0x1f42fbcf4cb4a72d)
    },
    {   UINT64_C(0x00000000000007a4), UINT64_C(0x106afa0fa07aa724), UINT64_C(0x106af64fa079e66d),
        UINT64_C(0x106afa0d487aa64b), UINT64_C(0x106af64d4879e597)
    },
    {   UINT64_C(0x0000000000005637), UINT64_C(0x1f42f94e9cb5e71d), UINT64_C(0x1f42fd4f14b6070c),
        UINT64_C(0x1f42f70eb4b7073e), UINT64_C(0x1f4305ceb0b2072b)
    },
    {   UINT64_C(0x00000000000007a6), UINT64_C(0x106af20f907e067e), UINT64_C(0x106af48c107d067e),
        UINT64_C(0x0000000000000000), UINT64_C(0x106af88fa07526e7)
    },
    {   UINT64_C(0x0000000000005639), UINT64_C(0x1f42fc4e38b5e72b), UINT64_C(0x1f42f88f90b6473a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8e10b72712)
    },
    {   UINT64_C(0x00000000000007a8), UINT64_C(0x106af4cd3c7c8657), UINT64_C(0x106afbcd3c80059f),
        UINT64_C(0x106af4cfa07ca773), UINT64_C(0x106afbcf888006bf)
    },
    {   UINT64_C(0x00000000000007a9), UINT64_C(0x106af4cfa07ca7c4), UINT64_C(0x106afbcf8880070f),
        UINT64_C(0x106af4cfa07ca7c4), UINT64_C(0x106afbcf8880070f)
    },
    {   UINT64_C(0x00000000000007aa), UINT64_C(0x106af4cfa07ca806), UINT64_C(0x106afbcf88800751),
        UINT64_C(0x106af4cfa07ca7aa), UINT64_C(0x106afbcf888006f5)
    },
    {   UINT64_C(0x000000000000563d), UINT64_C(0x1f43134ed8afc72f), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43114f80ac0716), UINT64_C(0x1f43068f1caf2728)
    },
    {   UINT64_C(0x000000000000563e), UINT64_C(0x0000000000000000), UINT64_C(0x1f430c4eb0b2473c),
        UINT64_C(0x1f430d4ed8b26728), UINT64_C(0x1f42f5ce60b7a704)
    },
    {   UINT64_C(0x000000000000563f), UINT64_C(0x1f430d4eb8ae272e), UINT64_C(0x1f43024e68b28739),
        UINT64_C(0x1f430b8fa8af470f), UINT64_C(0x1f42fe8e90b26739)
    },
    {   UINT64_C(0x0000000000005640), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f431094a4afe726), UINT64_C(0x1f42ffcebcae26f2)
    },
    {   UINT64_C(0x00000000000007af), UINT64_C(0x106af48fa07d4709), UINT64_C(0x106afbcf88788671),
        UINT64_C(0x106af48fa07d47c4), UINT64_C(0x106afbcf8878870f)
    },
    {   UINT64_C(0x00000000000007b0), UINT64_C(0x106af48fa07d47c4), UINT64_C(0x106afbcf8878870f),
        UINT64_C(0x106af48fa07d4806), UINT64_C(0x106afbcf88788751)
    },
    {   UINT64_C(0x00000000000007b1), UINT64_C(0x106af48fa07d47aa), UINT64_C(0x106afbcf887886f5),
        UINT64_C(0x106af48d3c7d470b), UINT64_C(0x106afbcd4078a657)
    },
    {   UINT64_C(0x00000000000007b2), UINT64_C(0x106b01cfa0764773), UINT64_C(0x106b018fa07766bf),
        UINT64_C(0x106b01cd3c76464b), UINT64_C(0x106b018d3c77664b)
    },
    {   UINT64_C(0x00000000000007b3), UINT64_C(0x106afc0d3c790656), UINT64_C(0x106afc4d4078e5a0),
        UINT64_C(0x106afc0f74790773), UINT64_C(0x106afc4f8878e6bf)
    },
    {   UINT64_C(0x00000000000007b4), UINT64_C(0x106afc0f747907c4), UINT64_C(0x106afc4f8878e70f),
        UINT64_C(0x106afc0f747907c4), UINT64_C(0x106afc4f8878e70f)
    },
    {   UINT64_C(0x00000000000007b5), UINT64_C(0x106afc0f74790806), UINT64_C(0x106afc4f8878e751),
        UINT64_C(0x106afc0f747907aa), UINT64_C(0x106afc4f8878e6f5)
    },
    {   UINT64_C(0x00000000000007b6), UINT64_C(0x106afc0d3c79070b), UINT64_C(0x106afc4d4078e657),
        UINT64_C(0x106afc0f747c6732), UINT64_C(0x106afc0f8c78e67d)
    },
    {   UINT64_C(0x0000000000005649), UINT64_C(0x1f43094e60b02751), UINT64_C(0x1f42fd0ea0afa71f),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430d4ff4b3a711)
    },
    {   UINT64_C(0x00000000000007b8), UINT64_C(0x106afc0f747c6729), UINT64_C(0x106afc0f8c78e674),
        UINT64_C(0x106afc0d407c66af), UINT64_C(0x106afc0d3c78e5fa)
    },
    {   UINT64_C(0x000000000000564b), UINT64_C(0x1f430e0fa0ad670c), UINT64_C(0x1f430a0fdcb4a6f2),
        UINT64_C(0x1f430c4f90b146f4), UINT64_C(0x1f43050e9cb64733)
    },
    {   UINT64_C(0x000000000000564c), UINT64_C(0x0000000000000000), UINT64_C(0x1f43110facb6c72e),
        UINT64_C(0x1f42fd0e94b40739), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000564d), UINT64_C(0x1f43094fa4ae06e9), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43104e94b3e733)
    },
    {   UINT64_C(0x000000000000564e), UINT64_C(0x1f42fe4e3cb6472d), UINT64_C(0x1f430a8f70aee70c),
        UINT64_C(0x1f43030ef0b6e739), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000007bd), UINT64_C(0x106af28d3c7da64b), UINT64_C(0x106af48c107d0597),
        UINT64_C(0x106af2cfa07da773), UINT64_C(0x106af48c107d06bf)
    },
    {   UINT64_C(0x0000000000005650), UINT64_C(0x1f431a0f68ab86df), UINT64_C(0x1f43048f10b7271a),
        UINT64_C(0x1f430b8f60afe720), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005651), UINT64_C(0x1f42fc4ed8b44737), UINT64_C(0x1f43074e6cb4c727),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43074e3cb3e73c)
    },
    {   UINT64_C(0x00000000000007c0), UINT64_C(0x106af8cf8c804667), UINT64_C(0x106af8cf8c804667),
        UINT64_C(0x106af8cf8c804667), UINT64_C(0x106af8cf8c804667)
    },
    {   UINT64_C(0x0000000000005653), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43060f10b8e72a), UINT64_C(0x1f42ff8e88b6e737)
    },
    {   UINT64_C(0x0000000000005654), UINT64_C(0x1f430d4f1cb1472e), UINT64_C(0x1f43124f40b4e728),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43008e48b8273b)
    },
    {   UINT64_C(0x0000000000005655), UINT64_C(0x1f430c4e64b8273e), UINT64_C(0x1f43104ef0b1e72d),
        UINT64_C(0x1f43134f84afe714), UINT64_C(0x1f430a0ed0b7a740)
    },
    {   UINT64_C(0x0000000000005656), UINT64_C(0x1f430f8ec4b0e720), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43098f0caf072a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005657), UINT64_C(0x1f43138f10a586fe), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006570), UINT64_C(0x1f43178ec4a76708), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4311ce90a62702)
    },
    {   UINT64_C(0x0000000000005659), UINT64_C(0x0000000000000000), UINT64_C(0x1f43024ec8b30729),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43024ec8b30744)
    },
    {   UINT64_C(0x00000000000007c8), UINT64_C(0x106af2cbfc7ac667), UINT64_C(0x106af2cbfc7ac667),
        UINT64_C(0x106af2cbfc7ac667), UINT64_C(0x106af2cbfc7ac667)
    },
    {   UINT64_C(0x00000000000007c9), UINT64_C(0x106af2cbfc7ac667), UINT64_C(0x106af2cbfc7ac667),
        UINT64_C(0x106af2cbfc7ac69e), UINT64_C(0x106af2cbfc7ac69e)
    },
    {   UINT64_C(0x000000000000565c), UINT64_C(0x1f43138f30aa070e), UINT64_C(0x1f43110ee4abe737),
        UINT64_C(0x1f42f90e9cb24711), UINT64_C(0x1f42fb4f78b7c710)
    },
    {   UINT64_C(0x000000000000565d), UINT64_C(0x1f42fe5078b4c70d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f80f94af8700), UINT64_C(0x1f42f64ee8b386ed)
    },
    {   UINT64_C(0x00000000000007cc), UINT64_C(0x106b0f0f8c6b2667), UINT64_C(0x106b13cf8c6b4667),
        UINT64_C(0x106b034f8c6b4667), UINT64_C(0x106b010f8c6b4667)
    },
    {   UINT64_C(0x00000000000007cd), UINT64_C(0x106afdcf8c6b4667), UINT64_C(0x106afd4f8c6b4667),
        UINT64_C(0x106af40f8c6d469e), UINT64_C(0x106af40f8c6d469e)
    },
    {   UINT64_C(0x0000000000005660), UINT64_C(0x1f43120fd4b3e6dc), UINT64_C(0x1f42f84ef4aee71d),
        UINT64_C(0x1f42fa5088afc700), UINT64_C(0x1f42f950a0b586fd)
    },
    {   UINT64_C(0x0000000000005661), UINT64_C(0x1f43024f04b4872c), UINT64_C(0x1f42f44fecb3e6f5),
        UINT64_C(0x1f42ff0fb8ad66e0), UINT64_C(0x1f42f91018ac870e)
    },
    {   UINT64_C(0x0000000000005662), UINT64_C(0x1f42f94f4cad06f1), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f3901cb066f5), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005663), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f48ed8b1e71a),
        UINT64_C(0x1f42f78e6cb706e9), UINT64_C(0x1f42f85014b466eb)
    },
    {   UINT64_C(0x0000000000007dad), UINT64_C(0x1f42f84e48b66729), UINT64_C(0x1f42f84e48b66729),
        UINT64_C(0x1f42f84e48b66729), UINT64_C(0x1f42f84e48b66729)
    },
    {   UINT64_C(0x0000000000007dae), UINT64_C(0x1f42f84e48b66729), UINT64_C(0x1f42f84e48b66729),
        UINT64_C(0x1f42f84e48b66729), UINT64_C(0x1f42f48e50b80724)
    },
    {   UINT64_C(0x00000000000007d4), UINT64_C(0x106af8cf8c7a8667), UINT64_C(0x106af8cf8c7a8667),
        UINT64_C(0x106af8cf8c7a8667), UINT64_C(0x106af8cf8c7a8667)
    },
    {   UINT64_C(0x0000000000005667), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbcfe4b346f3),
        UINT64_C(0x1f42f650a4b3c705), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005668), UINT64_C(0x1f42f78f78af46ef), UINT64_C(0x1f42f98e6cb026ed),
        UINT64_C(0x1f42fc0f68b626dc), UINT64_C(0x1f42f50ff8b606f3)
    },
    {   UINT64_C(0x0000000000005669), UINT64_C(0x1f42f68e7cb42715), UINT64_C(0x1f42fccf1cb1a712),
        UINT64_C(0x1f42f80ed4af2721), UINT64_C(0x1f42f64fe8b446f5)
    },
    {   UINT64_C(0x0000000000007db3), UINT64_C(0x1f42f54f7cb7e6ca), UINT64_C(0x1f4306cfd8af26ca),
        UINT64_C(0x1f4324cfd8a025d4), UINT64_C(0x1f434a565c8946a5)
    },
    {   UINT64_C(0x00000000000007d9), UINT64_C(0x106af60f8c7c0667), UINT64_C(0x106af60f8c7c0667),
        UINT64_C(0x106af60f8c7c069e), UINT64_C(0x106af60f8c7c069e)
    },
    {   UINT64_C(0x0000000000007db5), UINT64_C(0x1f4313d744aa66c1), UINT64_C(0x1f434d509887c694),
        UINT64_C(0x1f431a4f5ca58707), UINT64_C(0x1f430d907cabe69c)
    },
    {   UINT64_C(0x000000000000566d), UINT64_C(0x1f43098e6cafe6e4), UINT64_C(0x1f42f70fe0b4c6ee),
        UINT64_C(0x1f42f9100cb186f4), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000007dc), UINT64_C(0x106af8cf8c80464c), UINT64_C(0x106af8cf8c80464c),
        UINT64_C(0x106af8cf747a864c), UINT64_C(0x106af8cf747a864c)
    },
    {   UINT64_C(0x00000000000007dd), UINT64_C(0x106af2cbfc7ac64c), UINT64_C(0x106af2cbfc7ac64c),
        UINT64_C(0x106b0c8f8c6b464c), UINT64_C(0x106b13cf8c6b464c)
    },
    {   UINT64_C(0x00000000000007de), UINT64_C(0x106af84f8c7ae64c), UINT64_C(0x106af84f8c7ae64c),
        UINT64_C(0x106af8cf8c7a864c), UINT64_C(0x106af8cf8c7a864c)
    },
    {   UINT64_C(0x00000000000007df), UINT64_C(0x106af60f8c7c064c), UINT64_C(0x106af60f8c7c064c),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000007e0), UINT64_C(0x106af8ccc0804667), UINT64_C(0x106af8ccc0804667),
        UINT64_C(0x106af8ccc0804667), UINT64_C(0x106af8ccc0804667)
    },
    {   UINT64_C(0x00000000000007e1), UINT64_C(0x106af8ccc0804667), UINT64_C(0x106af8ccc0804667),
        UINT64_C(0x106af8ccc080469e), UINT64_C(0x106af8ccc080469e)
    },
    {   UINT64_C(0x0000000000007dbd), UINT64_C(0x1f43820e2ca4c73c), UINT64_C(0x1f431b8e2c71c73c),
        UINT64_C(0x1f432dd1189bc696), UINT64_C(0x1f43218e509ea665)
    },
    {   UINT64_C(0x0000000000007dbe), UINT64_C(0x1f43118e58a80716), UINT64_C(0x1f431fd178a1465e),
        UINT64_C(0x1f430a5118a8c6b5), UINT64_C(0x1f43308ee893e647)
    },
    {   UINT64_C(0x00000000000007e4), UINT64_C(0x106af2cbfc7ac667), UINT64_C(0x106af2cbfc7ac667),
        UINT64_C(0x106af2cbfc7ac667), UINT64_C(0x106af2cbfc7ac667)
    },
    {   UINT64_C(0x0000000000005677), UINT64_C(0x1f42ffce6cb2c749), UINT64_C(0x1f42f74eacb5c716),
        UINT64_C(0x1f42f74f4cad06f2), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000007dc1), UINT64_C(0x1f43141038a68708), UINT64_C(0x1f43294f008ee703),
        UINT64_C(0x1f431c0f00a34703), UINT64_C(0x1f43150e90a466d6)
    },
    {   UINT64_C(0x0000000000005679), UINT64_C(0x1f42fb4fc4adc6f9), UINT64_C(0x1f42f60f70b186fb),
        UINT64_C(0x1f42ff4edcb2c73c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000007e8), UINT64_C(0x106af60cc07c0667), UINT64_C(0x106af60cc07c0667),
        UINT64_C(0x106af60cc07c0667), UINT64_C(0x106af60cc07c0667)
    },
    {   UINT64_C(0x000000000000567b), UINT64_C(0x1f42f70ffcb306d8), UINT64_C(0x1f43078e80aee721),
        UINT64_C(0x1f42fb9000b546f7), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006582), UINT64_C(0x1f43144ee0a646f5), UINT64_C(0x1f43130f08a846eb),
        UINT64_C(0x1f43144ef4a686f1), UINT64_C(0x1f43130ee0a666eb)
    },
    {   UINT64_C(0x000000000000567d), UINT64_C(0x1f430e8f20b0c717), UINT64_C(0x1f42f78f58b746ee),
        UINT64_C(0x1f42f54f3cb906f3), UINT64_C(0x1f42f68ec4b0671a)
    },
    {   UINT64_C(0x00000000000007ec), UINT64_C(0x106af38f8c82c670), UINT64_C(0x106af38f8c82c60f),
        UINT64_C(0x106af8ccc080464c), UINT64_C(0x106af8ccc080459c)
    },
    {   UINT64_C(0x000000000000567f), UINT64_C(0x1f42feced4ae4736), UINT64_C(0x1f42f64fc0b2871f),
        UINT64_C(0x1f42f60f70b5c6d6), UINT64_C(0x1f42fcce8cb54730)
    },
    {   UINT64_C(0x0000000000005680), UINT64_C(0x1f42f80eb0b50700), UINT64_C(0x1f43044e60b4872a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0fd8b1c6fe)
    },
    {   UINT64_C(0x0000000000005681), UINT64_C(0x1f430a8eb4ae671c), UINT64_C(0x1f42f650a8af86f6),
        UINT64_C(0x1f42f94fa0b44705), UINT64_C(0x1f42f70f38b5c6fc)
    },
    {   UINT64_C(0x0000000000005682), UINT64_C(0x1f430a4ee8b0070f), UINT64_C(0x1f42f74e70b4c73c),
        UINT64_C(0x1f42fa4f28b826e7), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005683), UINT64_C(0x1f42f61010b366f9), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f78f00b8c705)
    },
    {   UINT64_C(0x0000000000005684), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb0e54b42719),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f54f38b76706)
    },
    {   UINT64_C(0x00000014400007f3), UINT64_C(0x106af0cd847f0667), UINT64_C(0x106b13170470c667),
        UINT64_C(0x106b0d97046ce667), UINT64_C(0x106b03d70875069e)
    },
    {   UINT64_C(0x0000000000005686), UINT64_C(0x1f42f5ce88b76730), UINT64_C(0x1f42fccf6cb7c6f9),
        UINT64_C(0x1f43024f3cb166e2), UINT64_C(0x1f42fa0f94b6c6f3)
    },
    {   UINT64_C(0x00000000000007f5), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af40f8c6d4667), UINT64_C(0x106af40f8c6d469e)
    },
    {   UINT64_C(0x00000000000007f6), UINT64_C(0x106aedcfa07fe728), UINT64_C(0x106aedcfa07fe6c7),
        UINT64_C(0x0000000000000000), UINT64_C(0x106aeb4fa07fe667)
    },
    {   UINT64_C(0x00000015000007f7), UINT64_C(0x0000000000000000), UINT64_C(0x106b10d70470a667),
        UINT64_C(0x106b0d17046d0667), UINT64_C(0x106b03d70875069e)
    },
    {   UINT64_C(0x00000000000007f8), UINT64_C(0x106aedcf8c7fe673), UINT64_C(0x106aedcf8c7fe612),
        UINT64_C(0x106af8cf8c7a8683), UINT64_C(0x106af8cf8c7a8683)
    },
    {   UINT64_C(0x000000000000568b), UINT64_C(0x0000000000000000), UINT64_C(0x1f42facef4b6470e),
        UINT64_C(0x1f42fccf2cb506fb), UINT64_C(0x1f42f8cf94b626f3)
    },
    {   UINT64_C(0x000000000000568c), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f64fdcb4c6ee),
        UINT64_C(0x1f42f48f40ac86fa), UINT64_C(0x1f42f54f28aec6e3)
    },
    {   UINT64_C(0x000000000000568d), UINT64_C(0x1f42f80fa0ad4703), UINT64_C(0x1f42fa4f48b5a6e4),
        UINT64_C(0x1f42fa0f0cb7471a), UINT64_C(0x1f42f58fd0b4c6eb)
    },
    {   UINT64_C(0x00000000000007fc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af60cc07c064c), UINT64_C(0x106af60cc07c05a1)
    },
    {   UINT64_C(0x000000000000568f), UINT64_C(0x1f42f58fccafe6fe), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb8fa0b2c6f4), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000007fe), UINT64_C(0x0000000000000000), UINT64_C(0x106ae4cf707fa672),
        UINT64_C(0x0000000000000000), UINT64_C(0x106ade4fa07ea672)
    },
    {   UINT64_C(0x00000000000007ff), UINT64_C(0x106af34d847de672), UINT64_C(0x106b1fd70467064b),
        UINT64_C(0x106b1c573463e667), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000800), UINT64_C(0x0000000000000000), UINT64_C(0x106aee0fa03e83e8),
        UINT64_C(0x0000000000000000), UINT64_C(0x106aee0fa03e83e8)
    },
    {   UINT64_C(0x0000000000000801), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x106aee0fa03e83e8)
    },
    {   UINT64_C(0x0000000000000802), UINT64_C(0x106aee0fa03e83e8), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000007dde), UINT64_C(0x1f430751acace647), UINT64_C(0x1f430751acb0e6fb),
        UINT64_C(0x1f42fd11acaf86ed), UINT64_C(0x1f432a5090986692)
    },
    {   UINT64_C(0x0000000000000804), UINT64_C(0x106b03d2847504de), UINT64_C(0x106b03d2847504de),
        UINT64_C(0x106b03d2847504de), UINT64_C(0x106b03d2847504de)
    },
    {   UINT64_C(0x0000000000000805), UINT64_C(0x106b03d2847504de), UINT64_C(0x0000000000000000),
        UINT64_C(0x106b150e546c869e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000806), UINT64_C(0x106b18950c698690), UINT64_C(0x106b1b13f86ac64b),
        UINT64_C(0x106b1b0d7469c465), UINT64_C(0x106b1b13f86ac64b)
    },
    {   UINT64_C(0x0000000000000807), UINT64_C(0x106af0950c7d664a), UINT64_C(0x106af3550c7ec64b),
        UINT64_C(0x106af34d787ec465), UINT64_C(0x106af3550c7ec64b)
    },
    {   UINT64_C(0x0000000000000808), UINT64_C(0x106afe4bfc77c650), UINT64_C(0x106afe4c1477c650),
        UINT64_C(0x106afc913878c5e6), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000809), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106afa4fa079c465), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000080a), UINT64_C(0x0000000000000000), UINT64_C(0x106afd4c287c264b),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000007de6), UINT64_C(0x1f431f10109e0673), UINT64_C(0x1f43108f84a7c6e2),
        UINT64_C(0x1f431051b0a7e685), UINT64_C(0x1f4327902c9d2675)
    },
    {   UINT64_C(0x000000000000080c), UINT64_C(0x106af44e547d069e), UINT64_C(0x106af2ce547d869e),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000007de8), UINT64_C(0x1f432b50c89d0698), UINT64_C(0x1f432b90c894268e),
        UINT64_C(0x1f432c90c49c468e), UINT64_C(0x1f432c90c89c468e)
    },
    {   UINT64_C(0x000000000000080e), UINT64_C(0x0000000000000000), UINT64_C(0x106afe4fa06f859f),
        UINT64_C(0x106b0ecfa077c59f), UINT64_C(0x106af60fa07c05d2)
    },
    {   UINT64_C(0x000000000000080f), UINT64_C(0x0000000000000000), UINT64_C(0x106afd4fa0784656),
        UINT64_C(0x0000000000000000), UINT64_C(0x106aee0bfc8043be)
    },
    {   UINT64_C(0x0000000000000810), UINT64_C(0x106b04968c74c667), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000811), UINT64_C(0x106afc8e5478c69e), UINT64_C(0x106b134e4070a69e),
        UINT64_C(0x106b0cce546d669e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000007ded), UINT64_C(0x1f432c90a09c468e), UINT64_C(0x1f432c90c89c468e),
        UINT64_C(0x1f432c50c89d668e), UINT64_C(0x1f43270f689e468e)
    },
    {   UINT64_C(0x0000000000007dee), UINT64_C(0x1f4328d0c897c68e), UINT64_C(0x1f431490c4a2e68e),
        UINT64_C(0x1f43144f64a5468e), UINT64_C(0x1f431d50c4a0868e)
    },
    {   UINT64_C(0x0000000000000814), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106afc8fa078c69e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000815), UINT64_C(0x106aee4bf88043bd), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000056a8), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f98ee0b0e6e8), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000007df2), UINT64_C(0x1f433450b09905d3), UINT64_C(0x1f433cd09c8e25cc),
        UINT64_C(0x1f432f90c89445cc), UINT64_C(0x1f432f90c894462f)
    },
    {   UINT64_C(0x0000000000007df3), UINT64_C(0x1f4330d0b09145d3), UINT64_C(0x1f432f90ac9545cc),
        UINT64_C(0x1f432d10c89ca5cc), UINT64_C(0x1f433750c896e5cc)
    },
    {   UINT64_C(0x0000000000007df4), UINT64_C(0x1f4337d09c96c5cc), UINT64_C(0x1f4333d0c89825cc),
        UINT64_C(0x1f432c8eb09c45cc), UINT64_C(0x1f4337d0a096a5ca)
    },
    {   UINT64_C(0x0000000000007df5), UINT64_C(0x1f4337d0c896a5cc), UINT64_C(0x1f432f8eb09ac5cc),
        UINT64_C(0x1f432cceb09d268e), UINT64_C(0x1f433910c896e5cc)
    },
    {   UINT64_C(0x0000000000007df6), UINT64_C(0x1f432f4fdc93e5cc), UINT64_C(0x1f433510c892c5cc),
        UINT64_C(0x1f432790c49aa5cc), UINT64_C(0x1f43274fd89c45cc)
    },
    {   UINT64_C(0x00000000000056ae), UINT64_C(0x1f42f60f20b70712), UINT64_C(0x1f42f64f30ada6d1),
        UINT64_C(0x1f42f50fa0b8a6e8), UINT64_C(0x1f430b4eecafc72f)
    },
    {   UINT64_C(0x0000000000007df8), UINT64_C(0x1f4324d0b09985d3), UINT64_C(0x1f4335d0b09405cc),
        UINT64_C(0x1f432c90589c4698), UINT64_C(0x1f430210f4b186c3)
    },
    {   UINT64_C(0x0000000000007df9), UINT64_C(0x1f43028fa4b14719), UINT64_C(0x1f432290c0b026a6),
        UINT64_C(0x1f43388f4ca306e1), UINT64_C(0x1f43408fa0a1c6dd)
    },
    {   UINT64_C(0x0000000000007dfa), UINT64_C(0x1f4323cfe89a86f5), UINT64_C(0x1f43478f0c8d46f4),
        UINT64_C(0x1f430f16f0aec725), UINT64_C(0x1f43090f20b325ca)
    },
    {   UINT64_C(0x0000000000000820), UINT64_C(0x106b19ce546a449f), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000007dfc), UINT64_C(0x1f431c50b4a126a7), UINT64_C(0x1f431bcf4899c700),
        UINT64_C(0x1f431bd0b4ad86b1), UINT64_C(0x1f431bcf449846f3)
    },
    {   UINT64_C(0x000000000000659e), UINT64_C(0x1f430c4f74b1e724), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc8efcb44705), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000007dfe), UINT64_C(0x1f432010b8ad86a7), UINT64_C(0x1f432050b4ad86b1),
        UINT64_C(0x1f432210b4ad86b1), UINT64_C(0x1f43200ef899a6f3)
    },
    {   UINT64_C(0x0000000000007dff), UINT64_C(0x1f431d4f1099a6f3), UINT64_C(0x1f43220f149846f3),
        UINT64_C(0x1f432310b49cc6b1), UINT64_C(0x1f431f0f149846f3)
    },
    {   UINT64_C(0x00000000000056b7), UINT64_C(0x1f42f80e4cb36725), UINT64_C(0x1f42f40f08b54721),
        UINT64_C(0x1f42f34ee4b58729), UINT64_C(0x1f42f68f54b5a704)
    },
    {   UINT64_C(0x00000000000056b8), UINT64_C(0x1f43018eb0ae271e), UINT64_C(0x1f42f50ee8a98725),
        UINT64_C(0x1f430c4f08acc704), UINT64_C(0x1f42f70ee4b126fd)
    },
    {   UINT64_C(0x0000000000019101), UINT64_C(0x14daf20fa08ea68c), UINT64_C(0x131af20fa087668c),
        UINT64_C(0x1852f74f549ce69b), UINT64_C(0x1852f34fa09d668c)
    },
    {   UINT64_C(0x0000000000000828), UINT64_C(0x0000000000000000), UINT64_C(0x106af80e547b069e),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000829), UINT64_C(0x106af94f8c7d2653), UINT64_C(0x0000000000000000),
        UINT64_C(0x106ae8cfa082c64b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000082a), UINT64_C(0x0000000000000000), UINT64_C(0x106af04f807ec64b),
        UINT64_C(0x0000000000000000), UINT64_C(0x106af6ce887f469e)
    },
    {   UINT64_C(0x000000000000082b), UINT64_C(0x106aee0fa07ca650), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000082c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af74e547c869e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000056bf), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f60e80b72738),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f84f5cafe709)
    },
    {   UINT64_C(0x00000000000056c0), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f60fb0b6870c),
        UINT64_C(0x1f42f44f28b46721), UINT64_C(0x1f430f8ef8af4716)
    },
    {   UINT64_C(0x00000000000056c1), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f50e6cb24732),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f94ec4b4e72c)
    },
    {   UINT64_C(0x000000000001910a), UINT64_C(0x0fa2f44f687a05c1), UINT64_C(0x1162f2cc6c8005c1),
        UINT64_C(0x1162f68c6c8185c1), UINT64_C(0x0de2f50fa074c5c1)
    },
    {   UINT64_C(0x000000000001910b), UINT64_C(0x0c2af44f686ba5c1), UINT64_C(0x0a6af2cf7068065e),
        UINT64_C(0x1162f20f6881c5b5), UINT64_C(0x0fa2f34f687b25b5)
    },
    {   UINT64_C(0x00000000000056c4), UINT64_C(0x1f42f94fd4b5c704), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f70f74b5a700)
    },
    {   UINT64_C(0x000000000001910d), UINT64_C(0x166af6cfa0942683), UINT64_C(0x15c2f78fa0944675),
        UINT64_C(0x14fafa8f7097667b), UINT64_C(0x18b2f78fa09e2675)
    },
    {   UINT64_C(0x00000000000065a7), UINT64_C(0x1f430d8e3cb2e73f), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43050f48b906ec), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001910f), UINT64_C(0x0f02f78fa080c675), UINT64_C(0x10e2fd0f708c0675),
        UINT64_C(0x17d2f78fa0a2c675), UINT64_C(0x1622f78fa0920675)
    },
    {   UINT64_C(0x0000000000019110), UINT64_C(0x1f6af78fa0c26675), UINT64_C(0x1a9af78fa0af2675),
        UINT64_C(0x16e2fa8f74978685), UINT64_C(0x1292f78fa0968675)
    },
    {   UINT64_C(0x0000000000005bfb), UINT64_C(0x1f43058e54b6c722), UINT64_C(0x1f43048f4cb04732),
        UINT64_C(0x1f42ffcf38b26711), UINT64_C(0x1f430b4e98b4471d)
    },
    {   UINT64_C(0x00000000000056ca), UINT64_C(0x1f42f80f2caf6719), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f60e60b2a735), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005bfc), UINT64_C(0x1f43018e8cb626e1), UINT64_C(0x1f43058e5cae6742),
        UINT64_C(0x1f43048fe8b6a6fb), UINT64_C(0x1f43048ec0afe71f)
    },
    {   UINT64_C(0x0000000000019114), UINT64_C(0x0cfaf80f747085a1), UINT64_C(0x10a2f80f70806684),
        UINT64_C(0x0deaf80f7471c5a1), UINT64_C(0x115af80cb48b6684)
    },
    {   UINT64_C(0x0000000000019115), UINT64_C(0x0f62f30cb47c05a1), UINT64_C(0x0000000000000000),
        UINT64_C(0x09bafa8f745ea650), UINT64_C(0x0c2aea0cb46d0650)
    },
    {   UINT64_C(0x0000000000019116), UINT64_C(0x10f2f94f74806684), UINT64_C(0x09f2f94f78614684),
        UINT64_C(0x1632f58f809385a1), UINT64_C(0x0f8af58f8078e5a1)
    },
    {   UINT64_C(0x0000000000005bfe), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4300cf64b0e706), UINT64_C(0x1f42fb0f20b446f6)
    },
    {   UINT64_C(0x0000000000019118), UINT64_C(0x0dc2fa8f746f45a1), UINT64_C(0x09caf80f7c61e61f),
        UINT64_C(0x0ed2f58f7c7605a1), UINT64_C(0x0fd3000f7c7a65b2)
    },
    {   UINT64_C(0x00000000000056d1), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f88ec4b4e712),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc4ee8b72722)
    },
    {   UINT64_C(0x0000000000000840), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x106aee0f747c6656)
    },
    {   UINT64_C(0x00000000000056d3), UINT64_C(0x1f4302ce78b1a738), UINT64_C(0x1f42f90e10b72712),
        UINT64_C(0x1f42fe0ea4b1e716), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000065ae), UINT64_C(0x1f42fdce80b6a709), UINT64_C(0x1f42f8cefcad6729),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430fce70b3e729)
    },
    {   UINT64_C(0x00000000000056d5), UINT64_C(0x1f42fd4fd0b466d2), UINT64_C(0x1f4301ce88b06720),
        UINT64_C(0x1f42f90f34b406d7), UINT64_C(0x1f430a4edcb0e732)
    },
    {   UINT64_C(0x000000000001911e), UINT64_C(0x1952fbcd389d0695), UINT64_C(0x190af88fa0a08685),
        UINT64_C(0x14fafbcf78968695), UINT64_C(0x11c2f50fa0960685)
    },
    {   UINT64_C(0x0000000000000845), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106ae34f8c802650), UINT64_C(0x106adb4bfc8986a9)
    },
    {   UINT64_C(0x00000000000056d8), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb0f74b1270a), UINT64_C(0x1f43068e90b0873d)
    },
    {   UINT64_C(0x0000000000000847), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af30f7480664b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000848), UINT64_C(0x106af014e07f06a9), UINT64_C(0x0000000000000000),
        UINT64_C(0x106aee14e07f26a9), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000849), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af5cfa07c0656), UINT64_C(0x106af5cf747c264b)
    },
    {   UINT64_C(0x00000000000056dc), UINT64_C(0x1f42ff8f24b58715), UINT64_C(0x1f42f7ce74b2c737),
        UINT64_C(0x1f43038facb206b4), UINT64_C(0x1f43074e60ae873e)
    },
    {   UINT64_C(0x000000000000084b), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af58f8c7ae653), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000019126), UINT64_C(0x1972fb0f68a265c1), UINT64_C(0x125af64f808265b6),
        UINT64_C(0x103af6cc6c7fc5b6), UINT64_C(0x109af6cf547ce5b5)
    },
    {   UINT64_C(0x00000000000056df), UINT64_C(0x0000000000000000), UINT64_C(0x1f43078e4cb24747),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430d4e58b2673c)
    },
    {   UINT64_C(0x00000000000065b4), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb0f80b52718),
        UINT64_C(0x1f42fd4f74b14710), UINT64_C(0x1f42facf28b26706)
    },
    {   UINT64_C(0x00000000000056e1), UINT64_C(0x1f430d4f68b48726), UINT64_C(0x1f4311cf38b1a735),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43138e9cb0e729)
    },
    {   UINT64_C(0x00000000000065b5), UINT64_C(0x1f42fecf78b266ff), UINT64_C(0x1f42f74f88b44719),
        UINT64_C(0x1f42fd0f18b5c712), UINT64_C(0x1f42ff4ed8b44707)
    },
    {   UINT64_C(0x0000000000005c08), UINT64_C(0x1f43058edca9a708), UINT64_C(0x1f42feceecb086eb),
        UINT64_C(0x1f43044ee8b0c709), UINT64_C(0x1f43048f60b18711)
    },
    {   UINT64_C(0x00000000000065b6), UINT64_C(0x1f42fb4f00b4c735), UINT64_C(0x1f43030f0cb12737),
        UINT64_C(0x1f43088e98a86735), UINT64_C(0x1f4309cf48b6c722)
    },
    {   UINT64_C(0x00000000000056e5), UINT64_C(0x0000000000000000), UINT64_C(0x1f4304cf48afe722),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43174ec0afa71a)
    },
    {   UINT64_C(0x000000000001912e), UINT64_C(0x14b2f58f748825a1), UINT64_C(0x1a6af58f74a5e697),
        UINT64_C(0x0000000000000000), UINT64_C(0x156af4cc5c92a697)
    },
    {   UINT64_C(0x00000000000056e7), UINT64_C(0x1f43144f4cb0c72d), UINT64_C(0x1f4313cfa0ad6713),
        UINT64_C(0x1f43160f24a9a71d), UINT64_C(0x1f43060f78af8731)
    },
    {   UINT64_C(0x00000000000065b8), UINT64_C(0x1f42fa4f88b16703), UINT64_C(0x1f42fe8ea0b14702),
        UINT64_C(0x1f430a0efcb64719), UINT64_C(0x1f42fb8f14b7a725)
    },
    {   UINT64_C(0x0000000000019131), UINT64_C(0x0000000000000000), UINT64_C(0x182af3cc5c9545a1),
        UINT64_C(0x1862f58c5c9b65a1), UINT64_C(0x1222fa0fa08605a4)
    },
    {   UINT64_C(0x00000000000056ea), UINT64_C(0x1f4311cf7cafe716), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43128f24ae471a), UINT64_C(0x1f4314cfa8aac726)
    },
    {   UINT64_C(0x0000000000019133), UINT64_C(0x1bc2f58f74a905a1), UINT64_C(0x1782fe4f7492e5a1),
        UINT64_C(0x1492f58c348ba590), UINT64_C(0x159afb0f748ba5c6)
    },
    {   UINT64_C(0x00000000000065ba), UINT64_C(0x1f43124f8caea6db), UINT64_C(0x1f430d4e60af472c),
        UINT64_C(0x1f430e8f64b2c6fd), UINT64_C(0x1f43058e20afa71f)
    },
    {   UINT64_C(0x0000000000019135), UINT64_C(0x19d305cf4ca166a3), UINT64_C(0x2092fe4f4cbea6a3),
        UINT64_C(0x1a13028f4ca266a3), UINT64_C(0x249afe4f4ccec6a3)
    },
    {   UINT64_C(0x0000000000019136), UINT64_C(0x1f2af9cf4cb8a6a3), UINT64_C(0x1c52f2cc20ad46a3),
        UINT64_C(0x2412f94f4ccbc6a3), UINT64_C(0x2062f80f4cbd66a3)
    },
    {   UINT64_C(0x00000000000056ef), UINT64_C(0x0000000000000000), UINT64_C(0x1f43148eecad272d),
        UINT64_C(0x1f43124f14ac6714), UINT64_C(0x1f43010f08ace725)
    },
    {   UINT64_C(0x00000000000056f0), UINT64_C(0x1f43170e7cad671e), UINT64_C(0x1f4309ceb0ac271e),
        UINT64_C(0x1f42fecefcb84721), UINT64_C(0x1f43040ef8b0a721)
    },
    {   UINT64_C(0x00000000000056f1), UINT64_C(0x1f43048e20b14745), UINT64_C(0x1f43150ec0aec731),
        UINT64_C(0x1f430ccea8ab0735), UINT64_C(0x1f4302cf38b46733)
    },
    {   UINT64_C(0x00000000000056f2), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd4e64b40745),
        UINT64_C(0x1f43180ed0a7271e), UINT64_C(0x1f43064e80b6c735)
    },
    {   UINT64_C(0x000000000001913b), UINT64_C(0x17e2f6cf6893e5b6), UINT64_C(0x1daaf50f68b086a3),
        UINT64_C(0x16b2f6cf688f85b6), UINT64_C(0x1802f44c6c9c26a3)
    },
    {   UINT64_C(0x00000000000065be), UINT64_C(0x1f43104e50ae6721), UINT64_C(0x1f430a8eccacc72c),
        UINT64_C(0x1f4314ce54ace72f), UINT64_C(0x1f43128f4cb22722)
    },
    {   UINT64_C(0x00000000000056f5), UINT64_C(0x1f43148eb4ab2719), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43124ed8b2a736), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000864), UINT64_C(0x106af551ac7c65c8), UINT64_C(0x106afccfa078a64a),
        UINT64_C(0x106af551ac7c65c8), UINT64_C(0x106afccfa078a64a)
    },
    {   UINT64_C(0x0000000000000865), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x106af74fa0848653)
    },
    {   UINT64_C(0x0000000000000866), UINT64_C(0x106af74f8084864b), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000056f9), UINT64_C(0x1f43024f1cad6735), UINT64_C(0x1f430e4e60b8c748),
        UINT64_C(0x1f43038e50b2a741), UINT64_C(0x1f43098e38afc736)
    },
    {   UINT64_C(0x00000000000056fa), UINT64_C(0x1f4304ce68b62739), UINT64_C(0x1f43048e44b78739),
        UINT64_C(0x1f43134eaca70723), UINT64_C(0x1f43140e28a9a73e)
    },
    {   UINT64_C(0x00000000000056fb), UINT64_C(0x1f430f8e74b5e73c), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43028e38b54735), UINT64_C(0x1f431bced0a7871f)
    },
    {   UINT64_C(0x0000000000019144), UINT64_C(0x21dafa8f48bf669f), UINT64_C(0x19dafa8f489f669f),
        UINT64_C(0x1a2af74f40a0c69f), UINT64_C(0x19baf80c709f269f)
    },
    {   UINT64_C(0x0000000000019145), UINT64_C(0x1b0af74ea0a4469f), UINT64_C(0x0000000000000000),
        UINT64_C(0x1ac2fbcf40a2a69f), UINT64_C(0x17f2f9cf4098c69f)
    },
    {   UINT64_C(0x0000000000019146), UINT64_C(0x189afa8f489b86a0), UINT64_C(0x19fafa0f40a0269f),
        UINT64_C(0x219afa0f40bea69f), UINT64_C(0x17daf98f249a669f)
    },
    {   UINT64_C(0x0000000000019147), UINT64_C(0x17f2f9cc7097c69f), UINT64_C(0x0000000000000000),
        UINT64_C(0x1092facf587a65bc), UINT64_C(0x100af98f5878469f)
    },
    {   UINT64_C(0x0000000000019148), UINT64_C(0x0c0afc4f586985bc), UINT64_C(0x0fd2f94f5877669f),
        UINT64_C(0x0d22f9cf586de5bc), UINT64_C(0x0a3af4cc5c66069e)
    },
    {   UINT64_C(0x0000000000005701), UINT64_C(0x1f42f94eb4b2071e), UINT64_C(0x1f42f94f4cb5c729),
        UINT64_C(0x1f42fd4eccb0071a), UINT64_C(0x1f42fc0eccb3e724)
    },
    {   UINT64_C(0x000000000001914a), UINT64_C(0x0d22fa0f586c869f), UINT64_C(0x0c72f98f586a469f),
        UINT64_C(0x1c72fccf3ca985bc), UINT64_C(0x13e2fd0f3c8745bc)
    },
    {   UINT64_C(0x0000000000005703), UINT64_C(0x1f43078e48afa70a), UINT64_C(0x1f42fe8e74b5271c),
        UINT64_C(0x1f4313ce38aec745), UINT64_C(0x1f43110f7cada6ea)
    },
    {   UINT64_C(0x0000000000005704), UINT64_C(0x1f43180ec4b486fb), UINT64_C(0x1f43170f0cb0e711),
        UINT64_C(0x1f4302cea4b74703), UINT64_C(0x1f4317cf30a6a727)
    },
    {   UINT64_C(0x000000000001914d), UINT64_C(0x17baf84f3c970632), UINT64_C(0x0e42f94cac7145bc),
        UINT64_C(0x1022fa0c5c788632), UINT64_C(0x0e4af8cc5c7165bc)
    },
    {   UINT64_C(0x0000000000005706), UINT64_C(0x1f43144f98ab66f8), UINT64_C(0x1f4312cf04ad2721),
        UINT64_C(0x1f4312cf04ad2721), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005707), UINT64_C(0x1f4303cedcb6c71f), UINT64_C(0x1f43114f70ada716),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fdcec8b36705)
    },
    {   UINT64_C(0x0000000000005708), UINT64_C(0x1f42f68eb4b7472a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa4f98b446fd), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000019151), UINT64_C(0x1abaff8fa0a0a67e), UINT64_C(0x0000000000000000),
        UINT64_C(0x17c2f94f6897e68c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000570a), UINT64_C(0x1f42fc4f38b086f6), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f9cfe4b2a726), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000570b), UINT64_C(0x1f42f78f9cb7a723), UINT64_C(0x1f43040eacb0871d),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000570c), UINT64_C(0x1f42f68f18b4270e), UINT64_C(0x1f42ffcfe8b56709),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8f0cb48701)
    },
    {   UINT64_C(0x000000000000570d), UINT64_C(0x1f42f78f80b3a711), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f78f6cb50717)
    },
    {   UINT64_C(0x000000000000570e), UINT64_C(0x1f43008fc4a326ef), UINT64_C(0x1f42fe4f0cb326e2),
        UINT64_C(0x1f4304d018b866d3), UINT64_C(0x1f42f88fc8b2a6ee)
    },
    {   UINT64_C(0x000000000000570f), UINT64_C(0x1f42f40fd0b006ff), UINT64_C(0x1f42fccf90b786e2),
        UINT64_C(0x1f42fa8f58b4870d), UINT64_C(0x1f42f7cf08b82727)
    },
    {   UINT64_C(0x0000000000005710), UINT64_C(0x1f42fa8f20ae4712), UINT64_C(0x1f42fa8fa0b3a6fc),
        UINT64_C(0x1f42ff8fa0a7a6e7), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005711), UINT64_C(0x1f42ff4ec4b566fd), UINT64_C(0x1f42fb8f38b08710),
        UINT64_C(0x1f42f98f90ab4703), UINT64_C(0x1f42fe4f90a5c6eb)
    },
    {   UINT64_C(0x0000000000005712), UINT64_C(0x1f42fc8f50a92707), UINT64_C(0x1f42fe8fccb186f6),
        UINT64_C(0x1f42f98f80a5c708), UINT64_C(0x1f42fa8f7cb1a70e)
    },
    {   UINT64_C(0x0000000000000881), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af68fa07bc673), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005714), UINT64_C(0x1f42f6cf64b76723), UINT64_C(0x1f42fa8ed0a36728),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43120eb4a986fc)
    },
    {   UINT64_C(0x000000000001915d), UINT64_C(0x18b2fb8f3c9a66a5), UINT64_C(0x191afb8c6c9c06a5),
        UINT64_C(0x1b02f88f3ca446a5), UINT64_C(0x15dafacf3c8f26a5)
    },
    {   UINT64_C(0x0000000000000884), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af753ec7b4539), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000885), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x106aff11087785f1)
    },
    {   UINT64_C(0x0000000000000886), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106aed0f8488a690), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000019161), UINT64_C(0x1a2afa8c6ca046a5), UINT64_C(0x179af90c949666a5),
        UINT64_C(0x12c2fbcf4082a5c3), UINT64_C(0x117af94f407d869f)
    },
    {   UINT64_C(0x0000000000019162), UINT64_C(0x0e82fbcf407205c3), UINT64_C(0x116afa0f3c7d469e),
        UINT64_C(0x0ee2fbcf4073e5c3), UINT64_C(0x0b92f64c486a86a4)
    },
    {   UINT64_C(0x0000000000019163), UINT64_C(0x11b2fbcc347dc5c3), UINT64_C(0x1202f94c347f069f),
        UINT64_C(0x0d6af6cf406de6a1), UINT64_C(0x0c2af80c3468a6a1)
    },
    {   UINT64_C(0x0000000000019164), UINT64_C(0x0e42fa0f4070c69f), UINT64_C(0x0d8af94f406de69f),
        UINT64_C(0x1ec2f80f40b305c3), UINT64_C(0x15c2f80f408f05c3)
    },
    {   UINT64_C(0x0000000000019165), UINT64_C(0x1152f94f407ce5c3), UINT64_C(0x1402f70c3487a639),
        UINT64_C(0x11f2fbcc347fc5c3), UINT64_C(0x106af80f407c25c3)
    },
    {   UINT64_C(0x0000000000019166), UINT64_C(0x116afb0f247da66b), UINT64_C(0x0db2f94f446dc678),
        UINT64_C(0x154af6cf408d25c3), UINT64_C(0x11eafbcf40804639)
    },
    {   UINT64_C(0x0000000000019167), UINT64_C(0x1a92fbcf40a1e639), UINT64_C(0x104afa8c5c7ba5c3),
        UINT64_C(0x12a2fbcc34818639), UINT64_C(0x0f22f70c347525c3)
    },
    {   UINT64_C(0x00000000000065d4), UINT64_C(0x0000000000000000), UINT64_C(0x1f43054ee4afc730),
        UINT64_C(0x1f430a0e90b22730), UINT64_C(0x1f42fccef8b78709)
    },
    {   UINT64_C(0x0000000000019169), UINT64_C(0x123b008fa082067e), UINT64_C(0x10bb008fa07fe67e),
        UINT64_C(0x15baf4cf688ce68c), UINT64_C(0x1493008fa087867e)
    },
    {   UINT64_C(0x0000000000005722), UINT64_C(0x1f42ff4f08b026f3), UINT64_C(0x1f42fccf6cb086ec),
        UINT64_C(0x1f43240ee0a74706), UINT64_C(0x1f42fe902cb4a6f7)
    },
    {   UINT64_C(0x000000000001916b), UINT64_C(0x1a5b00cfa09e867e), UINT64_C(0x151b008f6889a67e),
        UINT64_C(0x1652f58f6894068c), UINT64_C(0x106b008fa07e867e)
    },
    {   UINT64_C(0x0000000000005724), UINT64_C(0x1f42ffcf84b56716), UINT64_C(0x1f42fe8edcb9a731),
        UINT64_C(0x1f42f88f5cb4a6f5), UINT64_C(0x1f42fd8e9caec6e3)
    },
    {   UINT64_C(0x0000000000005725), UINT64_C(0x1f43050e9cb72706), UINT64_C(0x1f43040ed8b4072e),
        UINT64_C(0x1f42fcd004b1a6cc), UINT64_C(0x1f4326ceb0a2272b)
    },
    {   UINT64_C(0x0000000000005726), UINT64_C(0x1f42fd8fc0b726f9), UINT64_C(0x1f43064f88b62714),
        UINT64_C(0x1f4308cec4af2726), UINT64_C(0x1f431f4ea4a9c727)
    },
    {   UINT64_C(0x0000000000005727), UINT64_C(0x1f432a4f98aca727), UINT64_C(0x1f43168ef49ec72a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4301cfbcb6a6e5)
    },
    {   UINT64_C(0x0000000000005728), UINT64_C(0x1f42f9cf4caf66ca), UINT64_C(0x1f43180f48a426f7),
        UINT64_C(0x1f43120eacaf2717), UINT64_C(0x1f42fccf34abe6fa)
    },
    {   UINT64_C(0x0000000000005729), UINT64_C(0x1f42f5502cb726f2), UINT64_C(0x1f43004f7cb7870d),
        UINT64_C(0x1f430ccfc0ad4707), UINT64_C(0x1f43144e909fa71b)
    },
    {   UINT64_C(0x00000000000065d9), UINT64_C(0x1f42f85024b686f6), UINT64_C(0x1f42f78e74ae86f8),
        UINT64_C(0x1f42ff0f60b6e6eb), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000019173), UINT64_C(0x0c2afa4f786a45b7), UINT64_C(0x091aee4f7862662c),
        UINT64_C(0x0f5afdcf747445ad), UINT64_C(0x0ed2f5cf6875e5ad)
    },
    {   UINT64_C(0x000000000000572c), UINT64_C(0x1f42f8cfdcb046ef), UINT64_C(0x1f42fd4ef8b4a70e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43008ea8b3e724)
    },
    {   UINT64_C(0x0000000000019175), UINT64_C(0x1592f44fa091a69a), UINT64_C(0x13e3020fa088c68c),
        UINT64_C(0x169afa4f5494869b), UINT64_C(0x162b020fa092c68c)
    },
    {   UINT64_C(0x00000000000065db), UINT64_C(0x1f42fd0e9cb2e729), UINT64_C(0x1f43024ee4b1473d),
        UINT64_C(0x1f42fd8f28adc727), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000572f), UINT64_C(0x1f42f90eacb606fe), UINT64_C(0x1f4318cef8a4471b),
        UINT64_C(0x1f43074fc8aee6fa), UINT64_C(0x1f43208eccaa271b)
    },
    {   UINT64_C(0x00000000000065dc), UINT64_C(0x1f42fd8f18b72727), UINT64_C(0x1f42f6cee4b7473d),
        UINT64_C(0x1f42f8cf08b6a732), UINT64_C(0x1f42fc8e8cb12726)
    },
    {   UINT64_C(0x0000000000005731), UINT64_C(0x1f42fdcef8b70706), UINT64_C(0x1f42fa0ed0b58714),
        UINT64_C(0x1f42fa8f4cb726e7), UINT64_C(0x1f43030eb0b5471b)
    },
    {   UINT64_C(0x0000000000005732), UINT64_C(0x1f42f80f2cb7a6eb), UINT64_C(0x1f43118ee0b26717),
        UINT64_C(0x1f431c4eb0a1273c), UINT64_C(0x1f43004ef8ae070e)
    },
    {   UINT64_C(0x0000000000005733), UINT64_C(0x1f42fad038b2e6df), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43270eb4b1073b), UINT64_C(0x1f42fcd00cb466bb)
    },
    {   UINT64_C(0x0000000000005734), UINT64_C(0x1f42fecfa0abc70b), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43028f28a986eb), UINT64_C(0x1f42fd8f18b1c70f)
    },
    {   UINT64_C(0x0000000000005735), UINT64_C(0x1f42fb8f78aec6f7), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb8f88b166df), UINT64_C(0x1f42ff4fb0b5271c)
    },
    {   UINT64_C(0x000000000001917e), UINT64_C(0x103afbcfa07dc68c), UINT64_C(0x075afbcfa055068c),
        UINT64_C(0x1842fbcfa098a5c1), UINT64_C(0x0ff2fbcfa07765c1)
    },
    {   UINT64_C(0x0000000000005737), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430c0f40a66713), UINT64_C(0x1f430a4e40a6e734)
    },
    {   UINT64_C(0x00000000000065e0), UINT64_C(0x1f42fbceccae2722), UINT64_C(0x1f42fbcedcb90712),
        UINT64_C(0x1f42f88f04b6a70b), UINT64_C(0x1f42fa8eecb4a716)
    },
    {   UINT64_C(0x0000000000005739), UINT64_C(0x1f42f78f08b7a70f), UINT64_C(0x1f42fdcef4b3471d),
        UINT64_C(0x1f4316cf50a96716), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000065e1), UINT64_C(0x1f42f9cf08b5671c), UINT64_C(0x1f42fbcf18b6c718),
        UINT64_C(0x1f42f9ceb4b5a729), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000573b), UINT64_C(0x1f42fecf2ca94701), UINT64_C(0x1f43048ed4aac702),
        UINT64_C(0x1f42ffcf68b506bf), UINT64_C(0x1f43070e78af072b)
    },
    {   UINT64_C(0x000000000000573c), UINT64_C(0x1f42f8ce0cba2744), UINT64_C(0x1f42ff0f54aea6ca),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000573d), UINT64_C(0x1f42fd8fb8b726f2), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f431f0e58ad8745), UINT64_C(0x1f43120eb8a8c723)
    },
    {   UINT64_C(0x000000000000573e), UINT64_C(0x1f42fccf50b1c6ef), UINT64_C(0x1f430ccf10b2a70f),
        UINT64_C(0x1f42f6cf10b726d9), UINT64_C(0x1f42fc8f60b76731)
    },
    {   UINT64_C(0x000000000000573f), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90f60b9a716),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fdcf0cb166e9)
    },
    {   UINT64_C(0x0000000000005740), UINT64_C(0x1f432d0ed8b0a720), UINT64_C(0x1f430a4f58b4472a),
        UINT64_C(0x1f42fd0f98b0a717), UINT64_C(0x1f42fecef8b6471a)
    },
    {   UINT64_C(0x0000000000005741), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd8fb4b0c6ff), UINT64_C(0x1f43128e74b1c73b)
    },
    {   UINT64_C(0x0000000000005742), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43058e3cb24729)
    },
    {   UINT64_C(0x00000000000008b1), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106aee50847fc613), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005744), UINT64_C(0x0000000000000000), UINT64_C(0x1f431e4ec8b0e741),
        UINT64_C(0x1f430c8e3cb1472f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005745), UINT64_C(0x1f42f84e6cac6726), UINT64_C(0x1f42ffcfd0b2a6e3),
        UINT64_C(0x1f42f30ee4ab4727), UINT64_C(0x1f431dce24a54739)
    },
    {   UINT64_C(0x0000000000005746), UINT64_C(0x1f43010f90b72711), UINT64_C(0x1f43060eb8b70718),
        UINT64_C(0x1f43010f70b3e728), UINT64_C(0x1f42fd8f04ac26ec)
    },
    {   UINT64_C(0x0000000000005747), UINT64_C(0x0000000000000000), UINT64_C(0x1f4308ce94aee731),
        UINT64_C(0x1f43030e9cb06720), UINT64_C(0x1f43080f40b2a710)
    },
    {   UINT64_C(0x0000000000019190), UINT64_C(0x13db020fa099868c), UINT64_C(0x1233020fa099268c),
        UINT64_C(0x175308cf54a0a69b), UINT64_C(0x165b020fa0a2e68c)
    },
    {   UINT64_C(0x0000000000005749), UINT64_C(0x1f42ff8e5cb36722), UINT64_C(0x1f43050e4cb0e71d),
        UINT64_C(0x1f42fccf18b1a710), UINT64_C(0x1f42fecec0b6071b)
    },
    {   UINT64_C(0x000000000000574a), UINT64_C(0x1f43010fa8b5e723), UINT64_C(0x1f43020e98a6c727),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000574b), UINT64_C(0x0000000000000000), UINT64_C(0x1f43018e7caea73b),
        UINT64_C(0x1f43254e80a14727), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000019194), UINT64_C(0x15db0ccf54a1868c), UINT64_C(0x15931e4f58a6a68c),
        UINT64_C(0x1f2b1f8f64cc668c), UINT64_C(0x1722f80fa0a9268c)
    },
    {   UINT64_C(0x0000000000019195), UINT64_C(0x15b31d0fa0a7c68c), UINT64_C(0x146af44fa09ea68c),
        UINT64_C(0x0f4afa0f687de5c1), UINT64_C(0x1002facf6c84468c)
    },
    {   UINT64_C(0x0000000000019196), UINT64_C(0x0e72ffcf688005c1), UINT64_C(0x1032ff4f688ca68c),
        UINT64_C(0x0e22ffcf6c7c05c1), UINT64_C(0x0aa3000fa081269c)
    },
    {   UINT64_C(0x0000000000019197), UINT64_C(0x0fc2ee8c688965c0), UINT64_C(0x0ff2fbcfa082468c),
        UINT64_C(0x07aafccfa06c4698), UINT64_C(0x0a22d78c78758698)
    },
    {   UINT64_C(0x0000000000019198), UINT64_C(0x103afbcfa089668c), UINT64_C(0x075afbcfa06a068c),
        UINT64_C(0x1842fbcfa0a3a5c1), UINT64_C(0x0ff2fbcfa08245c1)
    },
    {   UINT64_C(0x0000000000019199), UINT64_C(0x0fab000f688245c1), UINT64_C(0x1002eecc6c8465c1),
        UINT64_C(0x1002ff4c6c8645c1), UINT64_C(0x0cdafbcfa07f65c1)
    },
    {   UINT64_C(0x000000000001919a), UINT64_C(0x0c0af74f6c75c5c1), UINT64_C(0x0c13068f7076665f),
        UINT64_C(0x1033024f6485a5b6), UINT64_C(0x0e730e4f6884a5b6)
    },
    {   UINT64_C(0x000000000001919b), UINT64_C(0x15eb0ecf68a245b6), UINT64_C(0x0fd2f30fa08745b6),
        UINT64_C(0x0ec2e74c7085a5b6), UINT64_C(0x0dcaf34fa080c5b6)
    },
    {   UINT64_C(0x000000000001919c), UINT64_C(0x106af48fa07c8689), UINT64_C(0x106af54fa07a867e),
        UINT64_C(0x106af80f747ac688), UINT64_C(0x106af44fa07ae67e)
    },
    {   UINT64_C(0x000000000001919d), UINT64_C(0x106af5cfa07d067e), UINT64_C(0x106af68fa07b867e),
        UINT64_C(0x106af74f747c6688), UINT64_C(0x106af48fa07c867e)
    },
    {   UINT64_C(0x0000000000005756), UINT64_C(0x1f42f90f48b5c719), UINT64_C(0x1f42f70e3cb10731),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff4ec0b7a722)
    },
    {   UINT64_C(0x000000000001919f), UINT64_C(0x106af34fa07d267e), UINT64_C(0x106af5cfa07be67e),
        UINT64_C(0x106afc0f7478c688), UINT64_C(0x106af5cfa07a667e)
    },
    {   UINT64_C(0x00000000000191a0), UINT64_C(0x106afc0d7478c688), UINT64_C(0x106af48f747f867e),
        UINT64_C(0x106afb0f74794688), UINT64_C(0x106af48fa07c867e)
    },
    {   UINT64_C(0x00000000000191a1), UINT64_C(0x106af04f747ec67e), UINT64_C(0x106af24f807dc67e),
        UINT64_C(0x106af0cf807e867e), UINT64_C(0x106af40fa07ca67e)
    },
    {   UINT64_C(0x00000000000008c8), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af752ac7b4586), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000575b), UINT64_C(0x1f430e8edcb1e71c), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43040fa8b3c72b)
    },
    {   UINT64_C(0x00000000000008ca), UINT64_C(0x0000000000000000), UINT64_C(0x106b134e5876a69e),
        UINT64_C(0x106b00ce586d669e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000191a5), UINT64_C(0x106af40fa07da649), UINT64_C(0x106afdcfa077e649),
        UINT64_C(0x106aee8fa07f85b0), UINT64_C(0x106af24fa07da5b0)
    },
    {   UINT64_C(0x00000000000191a6), UINT64_C(0x106afd8f887805b3), UINT64_C(0x106af24c2c7aa5b0),
        UINT64_C(0x106af94c2c80c5b0), UINT64_C(0x106af74fa07b25b0)
    },
    {   UINT64_C(0x000000000000575f), UINT64_C(0x1f42f80f64b3471b), UINT64_C(0x1f42fbcec8af2704),
        UINT64_C(0x1f43084ebcb1873a), UINT64_C(0x1f430b0ea0a5c72a)
    },
    {   UINT64_C(0x0000000000005760), UINT64_C(0x1f42fdce94aee70b), UINT64_C(0x1f42f50ea8b2c725),
        UINT64_C(0x1f42fbce9cb0e738), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005761), UINT64_C(0x1f42f8ce3cb3c748), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa0e64b1c72f), UINT64_C(0x1f42fa8f7cb3c6ef)
    },
    {   UINT64_C(0x0000000000005762), UINT64_C(0x1f430a4ef0afa72a), UINT64_C(0x1f430c8e5cb16728),
        UINT64_C(0x1f43008e5caf673f), UINT64_C(0x1f42fe4ef0b3672a)
    },
    {   UINT64_C(0x00000000000191ab), UINT64_C(0x153af20fa08ea68c), UINT64_C(0x15aaf50fa08dc68c),
        UINT64_C(0x1952f34fa09d668c), UINT64_C(0x1852f6cf589b669c)
    },
    {   UINT64_C(0x0000000000005764), UINT64_C(0x1f430bcf04acc73f), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fdcf1caf6723), UINT64_C(0x1f42f80ea4b70710)
    },
    {   UINT64_C(0x00000000000191ad), UINT64_C(0x1692f20f5896268c), UINT64_C(0x137af50fa088e68c),
        UINT64_C(0x1852f6cf549b669b), UINT64_C(0x1862f34fa09d668c)
    },
    {   UINT64_C(0x00000000000191ae), UINT64_C(0x131af20fa089868c), UINT64_C(0x1852f6cf589b669c),
        UINT64_C(0x14caf18fa08ce68c), UINT64_C(0x14daf5cfa08e068c)
    },
    {   UINT64_C(0x0000000000005767), UINT64_C(0x1f430e8e74b04739), UINT64_C(0x1f42f54f64b786f7),
        UINT64_C(0x1f431e0f0ca4e71b), UINT64_C(0x1f42fc0e90b26739)
    },
    {   UINT64_C(0x0000000000005768), UINT64_C(0x1f42f54ea8b6e719), UINT64_C(0x1f42fd8f58aee733),
        UINT64_C(0x1f42fd0ef8b50712), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000191b1), UINT64_C(0x1032f10c6c7d25c1), UINT64_C(0x0fb2f48f687a269c),
        UINT64_C(0x0de2f50f687425c1), UINT64_C(0x0e5af3cc6c75269c)
    },
    {   UINT64_C(0x00000000000191b2), UINT64_C(0x1222f10c6c82a5c1), UINT64_C(0x0faaf44f687a069c),
        UINT64_C(0x0a32f1cf686485b5), UINT64_C(0x122af34fa08465c1)
    },
    {   UINT64_C(0x00000000000191b3), UINT64_C(0x1112f2cf5880669c), UINT64_C(0x1312f94c6c8805b5),
        UINT64_C(0x1032f1cf687c65c1), UINT64_C(0x0e8af3cc6c75669c)
    },
    {   UINT64_C(0x00000000000191b4), UINT64_C(0x0fa2f44f687a05c1), UINT64_C(0x13baf30f588aa5b5),
        UINT64_C(0x111af94c6c7ee5c1), UINT64_C(0x0e82f3cc747605c1)
    },
    {   UINT64_C(0x00000000000191b5), UINT64_C(0x11c2f44f6880a5b5), UINT64_C(0x0f62f28f6877a5b5),
        UINT64_C(0x1202f10f688365c1), UINT64_C(0x146af40c6c8d25c1)
    },
    {   UINT64_C(0x00000000000191b6), UINT64_C(0x1322f34c6c87c5c1), UINT64_C(0x17daf10c6c9c65c1),
        UINT64_C(0x16f2f48f689705c1), UINT64_C(0x101af44f687be6ab)
    },
    {   UINT64_C(0x00000000000191b7), UINT64_C(0x0de2f44f687445c1), UINT64_C(0x143af10f688c069c),
        UINT64_C(0x119af10f5482c5c1), UINT64_C(0x146af40c6c8d268c)
    },
    {   UINT64_C(0x0000000000005770), UINT64_C(0x1f42f90e48ae8727), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43170efca9073b), UINT64_C(0x1f43020f1cb2e724)
    },
    {   UINT64_C(0x0000000000005771), UINT64_C(0x0000000000000000), UINT64_C(0x1f430aceecac6740),
        UINT64_C(0x1f42fa8f1cb326fc), UINT64_C(0x1f42fa8eccb5c71a)
    },
    {   UINT64_C(0x00000000000191ba), UINT64_C(0x1b4af78fa0b1e675), UINT64_C(0x170afa8f74978685),
        UINT64_C(0x0f02f78fa080c675), UINT64_C(0x17d2f78fa0a2c675)
    },
    {   UINT64_C(0x0000000000005c50), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd8f50afa71e),
        UINT64_C(0x1f42fa8e3cb5a72a), UINT64_C(0x1f42fd8f70b5c6f7)
    },
    {   UINT64_C(0x00000000000191bc), UINT64_C(0x16e2fa8f74978685), UINT64_C(0x1b4af78fa0b1e675),
        UINT64_C(0x1292f78fa0968675), UINT64_C(0x170afa8f74978685)
    },
    {   UINT64_C(0x0000000000005775), UINT64_C(0x1f430a0ee4ad8740), UINT64_C(0x1f42fdce5cae072e),
        UINT64_C(0x1f43054e8cb1872a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000191be), UINT64_C(0x18b2f44fa0a3c675), UINT64_C(0x14f2f50fa09b6683),
        UINT64_C(0x1902f60fa09fa682), UINT64_C(0x139af88f64898675)
    },
    {   UINT64_C(0x00000000000191bf), UINT64_C(0x1062f80f7880a5a1), UINT64_C(0x0f6af44cc47f4684),
        UINT64_C(0x0d62f6ccb477c5a1), UINT64_C(0x0e7af80f7476e684)
    },
    {   UINT64_C(0x00000000000191c0), UINT64_C(0x0f22f44f747605a1), UINT64_C(0x0d9af80cc47a8684),
        UINT64_C(0x0e62f58cc47765a1), UINT64_C(0x0f22f80f7479c684)
    },
    {   UINT64_C(0x0000000000005779), UINT64_C(0x0000000000000000), UINT64_C(0x1f43021158b4c6a1),
        UINT64_C(0x1f42fdcfc0ad6729), UINT64_C(0x1f43018fa0b166db)
    },
    {   UINT64_C(0x000000000000d152), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x15f2f94f5490a69c), UINT64_C(0x1162f44fa08f268c)
    },
    {   UINT64_C(0x000000000000577b), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43014fc4acc73e), UINT64_C(0x1f42fc8f84b486fb)
    },
    {   UINT64_C(0x000000000000577c), UINT64_C(0x1f43044f78b826f3), UINT64_C(0x1f431e9040ada6e8),
        UINT64_C(0x1f43219054b086ed), UINT64_C(0x1f4328909cb166ec)
    },
    {   UINT64_C(0x000000000000577d), UINT64_C(0x1f431e5038b126cc), UINT64_C(0x1f43014ee0b1c707),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbcef4b92738)
    },
    {   UINT64_C(0x000000000000577e), UINT64_C(0x0000000000000000), UINT64_C(0x1f43138ee8af070b),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd4eb0b3e739)
    },
    {   UINT64_C(0x0000000000019452), UINT64_C(0x0ffafccd3076e67e), UINT64_C(0x1cf2fb9084ab85a9),
        UINT64_C(0x1cf2fb9084ab85a9), UINT64_C(0x1cf2fb8d34ab867e)
    },
    {   UINT64_C(0x00000000000191c8), UINT64_C(0x16e2f88fa09cc685), UINT64_C(0x18eafe8fa0a64685),
        UINT64_C(0x1bdaf88fa0b4c685), UINT64_C(0x187afbcf609ce695)
    },
    {   UINT64_C(0x00000000000191c9), UINT64_C(0x0fb2f88fa0842685), UINT64_C(0x18daf88fa0a76685),
        UINT64_C(0x17baf7cfa0990695), UINT64_C(0x1fc2f88fa0c46685)
    },
    {   UINT64_C(0x0000000000005782), UINT64_C(0x1f43104ee8a9a6c3), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43038eccb4e70b), UINT64_C(0x1f43124e74a96732)
    },
    {   UINT64_C(0x00000000000191cb), UINT64_C(0x1322f88fa09a2685), UINT64_C(0x187afbcf609ce695),
        UINT64_C(0x17bafe0fa0a0e685), UINT64_C(0x11c2f50fa0960685)
    },
    {   UINT64_C(0x00000000000191cc), UINT64_C(0x140af5cfa0a08695), UINT64_C(0x19daf50fa0a26685),
        UINT64_C(0x1942f50fa0a64685), UINT64_C(0x15b2f58fa0a02695)
    },
    {   UINT64_C(0x00000000000191cd), UINT64_C(0x19d2fc4fa0a46695), UINT64_C(0x13c2f8cf60898685),
        UINT64_C(0x1382f90f708d45b5), UINT64_C(0x115af50c6c876695)
    },
    {   UINT64_C(0x00000000000191ce), UINT64_C(0x0f52f90c787d65b6), UINT64_C(0x10d2f90f8081c695),
        UINT64_C(0x0f7af50f7876e5b6), UINT64_C(0x0ec2f90c747fc695)
    },
    {   UINT64_C(0x0000000000005787), UINT64_C(0x1f43098f68ab6712), UINT64_C(0x1f430e0e5cb28736),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f431c0e4ca5c72e)
    },
    {   UINT64_C(0x0000000000005788), UINT64_C(0x1f432ace9ca1070b), UINT64_C(0x1f43068ebcb30719),
        UINT64_C(0x1f4300cf08b7870e), UINT64_C(0x1f43098e7cb6e725)
    },
    {   UINT64_C(0x00000000000191d1), UINT64_C(0x118af90f7881e5b6), UINT64_C(0x121af7cf6c8845aa),
        UINT64_C(0x129af64c6c84c5b6), UINT64_C(0x0f02f7cc747e05b6)
    },
    {   UINT64_C(0x00000000000191d2), UINT64_C(0x1282f90f7889e5aa), UINT64_C(0x0eaaf64f847d45aa),
        UINT64_C(0x1142f64f788165b6), UINT64_C(0x1612fbcc6c91e5b6)
    },
    {   UINT64_C(0x000000000000578b), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8e4cae0745),
        UINT64_C(0x1f430b4e7ca36723), UINT64_C(0x1f430c0e0cb14730)
    },
    {   UINT64_C(0x00000000000191d4), UINT64_C(0x0f0af90f787aa5b5), UINT64_C(0x12faf64f6c8786a2),
        UINT64_C(0x12faeb0f648d45b6), UINT64_C(0x155af90c6c906695)
    },
    {   UINT64_C(0x000000000000578d), UINT64_C(0x1f430a4f5cb04703), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430c0e0cb14728), UINT64_C(0x1f43008f68b7472d)
    },
    {   UINT64_C(0x00000000000191d6), UINT64_C(0x127b020fa085a68c), UINT64_C(0x1682f80fa093869a),
        UINT64_C(0x13db020fa089268c), UINT64_C(0x146af44fa08c668c)
    },
    {   UINT64_C(0x00000000000191d7), UINT64_C(0x165b020fa08de68c), UINT64_C(0x1852f6cf549b669b),
        UINT64_C(0x0dc2fe4fa06d668c), UINT64_C(0x1643020fa096e68c)
    },
    {   UINT64_C(0x00000000000191d8), UINT64_C(0x1612f80fa091c69a), UINT64_C(0x1c8b020fa0a6a68c),
        UINT64_C(0x16a3020f588f068c), UINT64_C(0x1402f6cfa08a268c)
    },
    {   UINT64_C(0x0000000000005791), UINT64_C(0x1f43050f98b046ff), UINT64_C(0x1f4309cf78b246ff),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43084e5cae6730)
    },
    {   UINT64_C(0x00000000000191da), UINT64_C(0x1512f50fa08d868c), UINT64_C(0x140af18fa08ce68c),
        UINT64_C(0x1762f30fa099869b), UINT64_C(0x1902f44fa09f668c)
    },
    {   UINT64_C(0x00000000000191db), UINT64_C(0x1722f80fa096068c), UINT64_C(0x1932f1cfa0a1669b),
        UINT64_C(0x1782f60fa098869b), UINT64_C(0x16faf94f28942680)
    },
    {   UINT64_C(0x00000000000191dc), UINT64_C(0x14b2f80f688d25c1), UINT64_C(0x1002f7cc6c7b669c),
        UINT64_C(0x0fb2f08c6c7a25c1), UINT64_C(0x0fb2f44f687a269c)
    },
    {   UINT64_C(0x0000000000005795), UINT64_C(0x1f43020f1cb6c706), UINT64_C(0x1f4302ce6cb4c73a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4302cf58b0e71f)
    },
    {   UINT64_C(0x00000000000191de), UINT64_C(0x09fafb4f686385b5), UINT64_C(0x107afbcfa07e85c1),
        UINT64_C(0x1152f28f687f869c), UINT64_C(0x1132f7cc6c7f25b5)
    },
    {   UINT64_C(0x0000000000005797), UINT64_C(0x1f43054ed0ad870b), UINT64_C(0x1f43054e5cae070b),
        UINT64_C(0x1f4303cf70b2e71c), UINT64_C(0x1f43088ea8b4671b)
    },
    {   UINT64_C(0x0000000000005798), UINT64_C(0x1f43018eecae870b), UINT64_C(0x1f4300cec4b7c703),
        UINT64_C(0x1f43044f70b4e729), UINT64_C(0x1f43138e5cb4c72e)
    },
    {   UINT64_C(0x0000000000005799), UINT64_C(0x1f43078e5caea72e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430f0eaca3271a), UINT64_C(0x1f4304cedcb3c707)
    },
    {   UINT64_C(0x0000000000000908), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af0cf8c7b8665), UINT64_C(0x106af8cd8c7a84d9)
    },
    {   UINT64_C(0x00000000000191e3), UINT64_C(0x11d2f18f6883c5c1), UINT64_C(0x13d2f44c6c8aa69c),
        UINT64_C(0x0f72f44c6c7925c1), UINT64_C(0x1a82ef8f68a765b5)
    },
    {   UINT64_C(0x00000000000191e4), UINT64_C(0x1592f44fa091a69a), UINT64_C(0x1612fd0fa092668c),
        UINT64_C(0x12d2fd0fa096a68c), UINT64_C(0x1682f80fa093869a)
    },
    {   UINT64_C(0x00000000000191e5), UINT64_C(0x155afd0fa097068c), UINT64_C(0x161af44fa09ea68c),
        UINT64_C(0x1762fd0fa0a0668c), UINT64_C(0x1a7b048f54a5469b)
    },
    {   UINT64_C(0x00000000000191e6), UINT64_C(0x0d9afa8fa07da68c), UINT64_C(0x1642fd0fa0a2068c),
        UINT64_C(0x1572f30fa08f469a), UINT64_C(0x1d2afd0fa0b9268c)
    },
    {   UINT64_C(0x000000000000579f), UINT64_C(0x1f430d0f90af66ea), UINT64_C(0x1f430acfa4b0a6f1),
        UINT64_C(0x1f430a4e64ada731), UINT64_C(0x1f43070f54a1a704)
    },
    {   UINT64_C(0x0000000000006614), UINT64_C(0x1f42facf10b086e0), UINT64_C(0x1f42f68ec0b5c6f4),
        UINT64_C(0x1f43068f40af26d6), UINT64_C(0x1f43078f8cae4706)
    },
    {   UINT64_C(0x00000000000057a1), UINT64_C(0x1f43064f64ae871a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43004fd0b4672e), UINT64_C(0x1f42f98f24b5e729)
    },
    {   UINT64_C(0x0000000000006615), UINT64_C(0x1f43014eb4b2072d), UINT64_C(0x1f43058f10afe6d6),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43048f2cafe704)
    },
    {   UINT64_C(0x00000000000057a3), UINT64_C(0x1f43034ebca98721), UINT64_C(0x1f42ff4e7ca4071a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f88e84b0e740)
    },
    {   UINT64_C(0x0000000000006616), UINT64_C(0x1f42f88fdcb286ee), UINT64_C(0x1f42fa0f18b2e703),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43024ef0b2070b)
    },
    {   UINT64_C(0x00000000000191ed), UINT64_C(0x11f2f28f6882069c), UINT64_C(0x1292eb0c6c85a5b6),
        UINT64_C(0x106af84f688525c1), UINT64_C(0x0f0af8cc6c80269c)
    },
    {   UINT64_C(0x00000000000191ee), UINT64_C(0x10faf94f687ee5c1), UINT64_C(0x13c2f94f689085b6),
        UINT64_C(0x1182e5cc6c8185c1), UINT64_C(0x102afb0c6c83c5c1)
    },
    {   UINT64_C(0x0000000000019466), UINT64_C(0x0df2f34f7873a693), UINT64_C(0x0872fc4f786025b8),
        UINT64_C(0x0ec3028fa07985b8), UINT64_C(0x0f4af00f747a4693)
    },
    {   UINT64_C(0x00000000000191f0), UINT64_C(0x11fada0c6c8cc5c1), UINT64_C(0x15fb00cc6c9c65c1),
        UINT64_C(0x17a2fe0f689a05b5), UINT64_C(0x1122f94f6881e69b)
    },
    {   UINT64_C(0x0000000000019467), UINT64_C(0x0f3af90c447ac5ad), UINT64_C(0x0e62f58f6873e5b8),
        UINT64_C(0x0d12f64c4471c693), UINT64_C(0x0f9af50f787965b7)
    },
    {   UINT64_C(0x00000000000191f2), UINT64_C(0x1102f78c6c7f85c1), UINT64_C(0x1bcaf80f68b085b6),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000057ab), UINT64_C(0x1f42fe4f3cb10712), UINT64_C(0x1f42f88f14b56727),
        UINT64_C(0x1f43034f2ca6e71e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000661a), UINT64_C(0x0000000000000000), UINT64_C(0x1f43020ec4aea6ff),
        UINT64_C(0x1f42f74ec4b10719), UINT64_C(0x1f43058f20ada726)
    },
    {   UINT64_C(0x00000000000057ad), UINT64_C(0x1f42f98e60a9072e), UINT64_C(0x1f42fa8e9cb7a736),
        UINT64_C(0x1f42f78f34adc737), UINT64_C(0x1f42fd4e94b30739)
    },
    {   UINT64_C(0x000000000000661b), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4306cf10ade709)
    },
    {   UINT64_C(0x00000000000057af), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f68f40b70736), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000661c), UINT64_C(0x1f43058e50ae872b), UINT64_C(0x1f42f48ec0b0473b),
        UINT64_C(0x1f42fd4efcaf8700), UINT64_C(0x1f42fa0f78b0c714)
    },
    {   UINT64_C(0x00000000000191f9), UINT64_C(0x0fa2f6cfa079268c), UINT64_C(0x0fa2f5cf6875a68c),
        UINT64_C(0x0fa2f0cfa07ba68c), UINT64_C(0x0fa2f70f6877c68c)
    },
    {   UINT64_C(0x00000000000191fa), UINT64_C(0x0fa2f60f68794694), UINT64_C(0x0fa2f78f8076e67e),
        UINT64_C(0x0fa2fa4f6876668c), UINT64_C(0x0fa2f50f4c78c68c)
    },
    {   UINT64_C(0x00000000000191fb), UINT64_C(0x0fa2f40f6c7a0698), UINT64_C(0x0fa3028fa0684698),
        UINT64_C(0x0fa2f30fa079c698), UINT64_C(0x0fa2f28f6c7a6698)
    },
    {   UINT64_C(0x00000000000057b4), UINT64_C(0x1f42fb0f60b3472e), UINT64_C(0x1f42fb8e84b1a73d),
        UINT64_C(0x1f42f78ed0b80738), UINT64_C(0x1f42f28e4cac673b)
    },
    {   UINT64_C(0x00000000000057b5), UINT64_C(0x1f42f58e54ae6738), UINT64_C(0x1f42fb8f68ade72b),
        UINT64_C(0x1f42fb8e60b5c73c), UINT64_C(0x1f42fa8e6caa6739)
    },
    {   UINT64_C(0x000000000000661f), UINT64_C(0x1f43030f58ab86fe), UINT64_C(0x1f42fa4f5caae708),
        UINT64_C(0x1f42f48f5caac6e6), UINT64_C(0x1f43064f48ab2719)
    },
    {   UINT64_C(0x00000000000191ff), UINT64_C(0x106afc8f74788691), UINT64_C(0x106af8cf747a6696),
        UINT64_C(0x106af8cf747a6691), UINT64_C(0x106afc8f74788691)
    },
    {   UINT64_C(0x00000000000057b8), UINT64_C(0x1f42f78f54b5c739), UINT64_C(0x1f42fc4f58a9a730),
        UINT64_C(0x1f42f68ec4b7c740), UINT64_C(0x1f42f68e84ae073d)
    },
    {   UINT64_C(0x00000000000057b9), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff4e64b30724),
        UINT64_C(0x1f42fa8eccaac72e), UINT64_C(0x1f42fe4e84ae672f)
    },
    {   UINT64_C(0x0000000000006621), UINT64_C(0x1f42fd4fa8ac86fb), UINT64_C(0x1f42f84f4cac26ef),
        UINT64_C(0x1f42f58f68ada718), UINT64_C(0x1f42fb4f7caa0721)
    },
    {   UINT64_C(0x00000000000057bb), UINT64_C(0x1f42f98e94b0a73d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc4e44af4739), UINT64_C(0x1f42f78eacb2272e)
    },
    {   UINT64_C(0x0000000000006622), UINT64_C(0x1f43060fc4a926d8), UINT64_C(0x1f4302cec0ab2703),
        UINT64_C(0x1f42fd8f8caac6e5), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c75), UINT64_C(0x1f42f88f48b38712), UINT64_C(0x1f430b0f28b04731),
        UINT64_C(0x1f42fc8ee8b20701), UINT64_C(0x1f42ff0f90b326ed)
    },
    {   UINT64_C(0x00000000000057be), UINT64_C(0x1f42fdcf68b3a701), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff8e98b5a739), UINT64_C(0x1f42fdcf68b3a6c8)
    },
    {   UINT64_C(0x00000000000057bf), UINT64_C(0x1f42fdcf68b3a6cf), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43004f24b366fa), UINT64_C(0x1f42fd1094b486eb)
    },
    {   UINT64_C(0x0000000000006624), UINT64_C(0x1f43084f6caa86fc), UINT64_C(0x1f42ff8f5cae6719),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fecf20ab870a)
    },
    {   UINT64_C(0x00000000000057c1), UINT64_C(0x1f42fecec8b62719), UINT64_C(0x1f430e4eecb6470c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4308ce5cb6a736)
    },
    {   UINT64_C(0x000000000000d176), UINT64_C(0x13db020fa089268c), UINT64_C(0x1233020fa085c68c),
        UINT64_C(0x1752f74f5492669b), UINT64_C(0x165b020fa08de68c)
    },
    {   UINT64_C(0x00000000000057c3), UINT64_C(0x1f430b8e80b28736), UINT64_C(0x1f430d4e80b28736),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430d4e80b28736)
    },
    {   UINT64_C(0x00000000000057c4), UINT64_C(0x1f42ff8e80b2c736), UINT64_C(0x1f42ff8f64b4a711),
        UINT64_C(0x1f43008f64b4a711), UINT64_C(0x1f432d4edca0a70e)
    },
    {   UINT64_C(0x00000000000057c5), UINT64_C(0x1f431c8e98ad4715), UINT64_C(0x1f43140f08a0a71f),
        UINT64_C(0x1f43028ec8b1470c), UINT64_C(0x1f43140e6caec734)
    },
    {   UINT64_C(0x00000000000057c6), UINT64_C(0x1f430c8f2caf66f0), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430ace6cb62717), UINT64_C(0x1f43074facb38716)
    },
    {   UINT64_C(0x00000000000057c7), UINT64_C(0x0000000000000000), UINT64_C(0x1f430c0facb306bb),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430c8e68ade732)
    },
    {   UINT64_C(0x00000000000057c8), UINT64_C(0x1f430e8f5cb3a6de), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4305cf88b3671a), UINT64_C(0x1f430a0f38b2c704)
    },
    {   UINT64_C(0x00000000000057c9), UINT64_C(0x1f43028f50b0c6da), UINT64_C(0x1f430b4f14afa70a),
        UINT64_C(0x1f43094f90b0e706), UINT64_C(0x1f43008f90b9070e)
    },
    {   UINT64_C(0x00000000000057ca), UINT64_C(0x1f43098f4ca7e6b6), UINT64_C(0x1f43028e70b64735),
        UINT64_C(0x1f4307cf84ad66d0), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000057cb), UINT64_C(0x0000000000000000), UINT64_C(0x1f4306ce7cb5c70b),
        UINT64_C(0x1f43088e60b6c71d), UINT64_C(0x1f4319ce64a7a72e)
    },
    {   UINT64_C(0x00000000000057cc), UINT64_C(0x1f430c0ed4ab26e7), UINT64_C(0x1f43034f44a6a702),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430b0f60b0e6ce)
    },
    {   UINT64_C(0x00000000000057cd), UINT64_C(0x0000000000000000), UINT64_C(0x1f430c0f18b88717),
        UINT64_C(0x1f430c8f28af0703), UINT64_C(0x1f430d0f30aae6ff)
    },
    {   UINT64_C(0x000000000000d17c), UINT64_C(0x0e72f44f6875c5c1), UINT64_C(0x1032f44f6878668c),
        UINT64_C(0x0e22f44f6c74a5c1), UINT64_C(0x0aa2f18fa06d469b)
    },
    {   UINT64_C(0x00000000000057cf), UINT64_C(0x1f43060fc0aa46f0), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4306ce6caee703), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000057d0), UINT64_C(0x1f43078f14b3a71e), UINT64_C(0x1f42fe8f14b346dc),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4306ced8b00709)
    },
    {   UINT64_C(0x00000000000057d1), UINT64_C(0x1f4306cf64b326cd), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4315ce38b28733), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000940), UINT64_C(0x106aee136080251e), UINT64_C(0x0000000000000000),
        UINT64_C(0x106b26ca1463a72d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000057d3), UINT64_C(0x1f43074ef4ab0711), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430dce44acc738), UINT64_C(0x1f43040e54b5871f)
    },
    {   UINT64_C(0x00000000000057d4), UINT64_C(0x1f432750e0a4c677), UINT64_C(0x1f43021030b1a6be),
        UINT64_C(0x1f431b8f18ae86d6), UINT64_C(0x1f4326904ca326f7)
    },
    {   UINT64_C(0x0000000000000943), UINT64_C(0x106b26ca1480251e), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000944), UINT64_C(0x106aee0a1463a51e), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000945), UINT64_C(0x106b26d36080272d), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000946), UINT64_C(0x106aee136063a72d), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000947), UINT64_C(0x106b26ca1480272d), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000057da), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8ced4ab871a),
        UINT64_C(0x1f42fa4ef4b5072b), UINT64_C(0x1f42fa4eb4b00709)
    },
    {   UINT64_C(0x0000000000000949), UINT64_C(0x106aee0a1463a72d), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000057dc), UINT64_C(0x1f42ffce6cac8729), UINT64_C(0x1f42fc0e48ac0715),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43254e7c8e672b)
    },
    {   UINT64_C(0x000000000000094b), UINT64_C(0x106aee0a1480251e), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006633), UINT64_C(0x1f42f0cf44b8e733), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430ccf48b366c6), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000094d), UINT64_C(0x106aee136080272d), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000057e0), UINT64_C(0x1f42f88fb4b2c714), UINT64_C(0x1f42f74f78b5e715),
        UINT64_C(0x1f42f98fa4b5c714), UINT64_C(0x1f42facfb4b5271c)
    },
    {   UINT64_C(0x000000000000094f), UINT64_C(0x106aee0a1480272d), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000057e2), UINT64_C(0x1f42f84f2cb8670e), UINT64_C(0x1f42f54e7cb54741),
        UINT64_C(0x1f42f28fd4b0c6fd), UINT64_C(0x1f42fe4e88b62738)
    },
    {   UINT64_C(0x00000000000057e3), UINT64_C(0x1f42fb4f58b34732), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000057e4), UINT64_C(0x1f42f88eccb8a71d), UINT64_C(0x1f42f74fa4b4a6f3),
        UINT64_C(0x1f42f84f28b7870d), UINT64_C(0x1f42f70f28b706fc)
    },
    {   UINT64_C(0x00000000000057e5), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb4eccb5c70e),
        UINT64_C(0x1f43008ef8ab46ee), UINT64_C(0x1f42f68e64b6472f)
    },
    {   UINT64_C(0x0000000000000954), UINT64_C(0x106aee122080256e), UINT64_C(0x106b12ca146da72d),
        UINT64_C(0x106b26ca1480256e), UINT64_C(0x106b12ca1480251e)
    },
    {   UINT64_C(0x0000000000000955), UINT64_C(0x106b12ca1480256e), UINT64_C(0x106aee0a1463a56e),
        UINT64_C(0x106aee0a146da51e), UINT64_C(0x106aee0a146da56e)
    },
    {   UINT64_C(0x0000000000000956), UINT64_C(0x106b26d22080272d), UINT64_C(0x106b12d36080272d),
        UINT64_C(0x106b12d22080272d), UINT64_C(0x106aee122063a72d)
    },
    {   UINT64_C(0x0000000000000957), UINT64_C(0x106aee13606da72d), UINT64_C(0x106aee12206da72d),
        UINT64_C(0x106b26ca1480272d), UINT64_C(0x106b12ca1480272d)
    },
    {   UINT64_C(0x0000000000000958), UINT64_C(0x106b12ca1480272d), UINT64_C(0x106aee0a1463a72d),
        UINT64_C(0x106aee0a146da72d), UINT64_C(0x106aee0a146da72d)
    },
    {   UINT64_C(0x0000000000000959), UINT64_C(0x106aee0a1480256e), UINT64_C(0x106aee0a1480251e),
        UINT64_C(0x106aee0a1480256e), UINT64_C(0x106aee122080272d)
    },
    {   UINT64_C(0x000000000000095a), UINT64_C(0x106aee136080272d), UINT64_C(0x106aee122080272d),
        UINT64_C(0x106aee0a1480272d), UINT64_C(0x106aee0a1480272d)
    },
    {   UINT64_C(0x00000000000057ed), UINT64_C(0x1f42f6cf84b7070a), UINT64_C(0x1f42f74f84b7470a),
        UINT64_C(0x1f42f78f84b726e9), UINT64_C(0x1f42f58f44b56741)
    },
    {   UINT64_C(0x00000000000057ee), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa4f74b82705),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa4e84b6c729)
    },
    {   UINT64_C(0x00000000000057ef), UINT64_C(0x1f42f94f50b3a6f7), UINT64_C(0x1f42f94f40b72708),
        UINT64_C(0x1f42fc4f18b626ee), UINT64_C(0x1f42f88fd0b166ed)
    },
    {   UINT64_C(0x00000000000057f0), UINT64_C(0x1f42fc8e80b3a72a), UINT64_C(0x1f42f94eacb6a70f),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43071188b1666c)
    },
    {   UINT64_C(0x00000000000057f1), UINT64_C(0x1f433bcef88f66f8), UINT64_C(0x1f430a5050b406de),
        UINT64_C(0x1f4300cf08b5a704), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000057f2), UINT64_C(0x0000000000000000), UINT64_C(0x1f43034ef8ac46f8),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000057f3), UINT64_C(0x1f430f0f54b36705), UINT64_C(0x1f430bcf08b526f7),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43004ed8b1a6f3)
    },
    {   UINT64_C(0x00000000000057f4), UINT64_C(0x1f430e4f20ad270c), UINT64_C(0x1f4310cf7cae26f6),
        UINT64_C(0x1f42ffce88b42725), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000057f5), UINT64_C(0x1f4300cedcb2e710), UINT64_C(0x1f43020eccb54700),
        UINT64_C(0x1f43010ed8af8707), UINT64_C(0x1f43094f60b16728)
    },
    {   UINT64_C(0x000000000000663f), UINT64_C(0x1f42f90f0cacc736), UINT64_C(0x1f42f90f84b50729),
        UINT64_C(0x1f42fece3cae0728), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000057f7), UINT64_C(0x1f42fe8f64b34732), UINT64_C(0x1f43034e8cb46723),
        UINT64_C(0x1f43120f34b04736), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000057f8), UINT64_C(0x1f430d8f3cb36729), UINT64_C(0x1f42ffcea8ac0715),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fccef8b646f8)
    },
    {   UINT64_C(0x00000000000057f9), UINT64_C(0x1f42ffced8b2270c), UINT64_C(0x1f4306cec0b9c736),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4300cef8b6e708)
    },
    {   UINT64_C(0x00000000000057fa), UINT64_C(0x1f43020f28b4e6f0), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc0f08b7c6ff), UINT64_C(0x1f43070f18b4c6fc)
    },
    {   UINT64_C(0x00000000000057fb), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff0f44ae4717),
        UINT64_C(0x1f42fbcf48b6271b), UINT64_C(0x1f42f88ef8b1e6f8)
    },
    {   UINT64_C(0x00000000000057fc), UINT64_C(0x1f42fecf58b32724), UINT64_C(0x1f42fe8ef8b5270c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff8f48b3a6f3)
    },
    {   UINT64_C(0x00000000000057fd), UINT64_C(0x1f42fc8f38b6c6f7), UINT64_C(0x1f4302cefcb92732),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd8f78b1a700)
    },
    {   UINT64_C(0x00000000000057fe), UINT64_C(0x1f43004f38b3e714), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa8f08b246fc), UINT64_C(0x1f42ffcf18aee714)
    },
    {   UINT64_C(0x00000000000057ff), UINT64_C(0x0000000000000000), UINT64_C(0x1f430e8f00b12724),
        UINT64_C(0x1f43018ef8b6e6f8), UINT64_C(0x1f42fe0ef4b3070b)
    },
    {   UINT64_C(0x0000000000005800), UINT64_C(0x1f43014efcb126f3), UINT64_C(0x1f43120f70ac0711),
        UINT64_C(0x1f43108f78b2c6e7), UINT64_C(0x1f43038f38b40708)
    },
    {   UINT64_C(0x0000000000005801), UINT64_C(0x1f4301cf78af4704), UINT64_C(0x1f43038ef8b526f8),
        UINT64_C(0x1f43038ef8b5c6f8), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005802), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff8f28af66ff),
        UINT64_C(0x1f43048f58a866ff), UINT64_C(0x1f42ff0ef8b406f8)
    },
    {   UINT64_C(0x0000000000005803), UINT64_C(0x1f4301cf58aba707), UINT64_C(0x1f42fdcef4a9a6ef),
        UINT64_C(0x1f430d4f18b2473a), UINT64_C(0x1f42fb0f28b2c713)
    },
    {   UINT64_C(0x0000000000000972), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x106adb4bfc8986a9)
    },
    {   UINT64_C(0x0000000000005805), UINT64_C(0x1f42fecf18b28704), UINT64_C(0x1f43068f48aae70e),
        UINT64_C(0x1f43028e5cae0733), UINT64_C(0x1f42ff0f88a706ff)
    },
    {   UINT64_C(0x0000000000005806), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe8f48b1a71a),
        UINT64_C(0x1f4300cf38b4c6f7), UINT64_C(0x1f42facf58b066ff)
    },
    {   UINT64_C(0x0000000000005807), UINT64_C(0x1f42fc8f58b546f8), UINT64_C(0x1f430ccfe8b446f6),
        UINT64_C(0x1f42fe0f58af46ff), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005808), UINT64_C(0x1f430f4efcb2c73b), UINT64_C(0x1f43014f58ad0707),
        UINT64_C(0x1f42fb0ef8b64700), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005809), UINT64_C(0x1f43084ef4ae8711), UINT64_C(0x1f43040ee4aee740),
        UINT64_C(0x1f42f7ce7cb48712), UINT64_C(0x1f42fa0fa4b3e71c)
    },
    {   UINT64_C(0x000000000000580a), UINT64_C(0x1f43108f20afe710), UINT64_C(0x1f42f90f28b326ff),
        UINT64_C(0x1f43040f58b76710), UINT64_C(0x1f42ff8e4cb32747)
    },
    {   UINT64_C(0x0000000000000979), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106afc913878c5e6), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000580c), UINT64_C(0x0000000000000000), UINT64_C(0x1f43058f00afc724),
        UINT64_C(0x1f42fd8edcb346f8), UINT64_C(0x1f43008f74b506ff)
    },
    {   UINT64_C(0x000000000000580d), UINT64_C(0x1f43030f74b046eb), UINT64_C(0x1f42fe8eacb4272a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43160facab070a)
    },
    {   UINT64_C(0x000000000000580e), UINT64_C(0x0000000000000000), UINT64_C(0x1f430dcf40ab06fb),
        UINT64_C(0x1f42f9cf0cb5a728), UINT64_C(0x1f430f0f88af6720)
    },
    {   UINT64_C(0x000000000000580f), UINT64_C(0x1f43148f98b1070a), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43024e9cb566fb)
    },
    {   UINT64_C(0x0000000000005810), UINT64_C(0x1f42ffcec8ac4727), UINT64_C(0x1f43024f4cb0e721),
        UINT64_C(0x1f42fc0ef8ae071b), UINT64_C(0x1f43028eb8b66740)
    },
    {   UINT64_C(0x0000000000005811), UINT64_C(0x1f42fdcf38a98711), UINT64_C(0x1f42fb0f38aba6f6),
        UINT64_C(0x1f42fc8f94b6870c), UINT64_C(0x1f43008f58aec6fb)
    },
    {   UINT64_C(0x0000000000005812), UINT64_C(0x0000000000000000), UINT64_C(0x1f43058f08aba6f3),
        UINT64_C(0x1f42fe8f94b32726), UINT64_C(0x1f430f0f70ae8723)
    },
    {   UINT64_C(0x0000000000005813), UINT64_C(0x1f42f7cedcb726f8), UINT64_C(0x1f42fd8fd4b7070e),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005814), UINT64_C(0x1f430e4fc0b26706), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43008f68af66f3), UINT64_C(0x1f42fe0f18b14703)
    },
    {   UINT64_C(0x0000000000005815), UINT64_C(0x1f43020f58b2a6e4), UINT64_C(0x1f43014f48b42743),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005816), UINT64_C(0x1f42f88f48b526f7), UINT64_C(0x1f43064f48af0748),
        UINT64_C(0x1f43130f28ad670a), UINT64_C(0x1f42f8cf18b3e707)
    },
    {   UINT64_C(0x0000000000005817), UINT64_C(0x0000000000000000), UINT64_C(0x1f43178f84ae66f5),
        UINT64_C(0x1f42fc8f48afe70f), UINT64_C(0x1f43014ee8b0e718)
    },
    {   UINT64_C(0x0000000000005818), UINT64_C(0x1f42fa0eb0b5871f), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43044f88b7a71d), UINT64_C(0x1f4314cf50b2673c)
    },
    {   UINT64_C(0x0000000000005819), UINT64_C(0x1f43004f28b6c708), UINT64_C(0x1f42fe8f68b7e6da),
        UINT64_C(0x1f42fd8f74ada6ff), UINT64_C(0x1f43140fb4ae06e6)
    },
    {   UINT64_C(0x000000000000581a), UINT64_C(0x1f42ffcedcb66716), UINT64_C(0x1f430b0f74b3c723),
        UINT64_C(0x1f4301cfa4b92715), UINT64_C(0x1f42ff0f40aae70c)
    },
    {   UINT64_C(0x000000000000581b), UINT64_C(0x1f43048f88b38717), UINT64_C(0x1f42fccec0b70741),
        UINT64_C(0x1f43004f68b926e8), UINT64_C(0x1f43108f34b2e74a)
    },
    {   UINT64_C(0x000000000000581c), UINT64_C(0x1f4301cf68b9a704), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd4f08ae4704), UINT64_C(0x1f43114f6cac66fd)
    },
    {   UINT64_C(0x000000000000098b), UINT64_C(0x0000000000000000), UINT64_C(0x106af28f9c7c8639),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000581e), UINT64_C(0x1f42ff8f38afa6f3), UINT64_C(0x1f43020f28b4c6f4),
        UINT64_C(0x1f43030f08ae46ff), UINT64_C(0x1f43020f48aaa6fb)
    },
    {   UINT64_C(0x000000000000581f), UINT64_C(0x1f43030f38ac0722), UINT64_C(0x1f42ff8e9caf06f4),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430a4ee0b12726)
    },
    {   UINT64_C(0x0000000000005820), UINT64_C(0x1f42fd0e98ab0704), UINT64_C(0x1f43028efca5070c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb0f68ace71b)
    },
    {   UINT64_C(0x0000000000005821), UINT64_C(0x1f43030ef0a9e715), UINT64_C(0x1f4302cfa4b726f7),
        UINT64_C(0x1f4309ceb0b28728), UINT64_C(0x1f42f90ea4b8a704)
    },
    {   UINT64_C(0x0000000000000990), UINT64_C(0x106aff0bfc7785a2), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005823), UINT64_C(0x1f43020ebcb3273a), UINT64_C(0x1f42fcce5cb5472a),
        UINT64_C(0x1f42fbceacb5e706), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005824), UINT64_C(0x1f43094f50aa86f2), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42facf38b56710), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005825), UINT64_C(0x1f43044f08b8a732), UINT64_C(0x1f42fe4e2cae072e),
        UINT64_C(0x1f43004eb8b1873e), UINT64_C(0x1f42fb4f0cb3e6fb)
    },
    {   UINT64_C(0x0000000000005826), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43004eccb9a745), UINT64_C(0x1f42fc0f68b6a731)
    },
    {   UINT64_C(0x0000000000005827), UINT64_C(0x1f42fe0f18b1c704), UINT64_C(0x1f42fd8f68b0670b),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43028f94b6270c)
    },
    {   UINT64_C(0x0000000000005828), UINT64_C(0x1f4305cf4cb0c723), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa8ee8b82708), UINT64_C(0x1f43130ef8b0e740)
    },
    {   UINT64_C(0x0000000000005829), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4305cf68b6e729), UINT64_C(0x1f43030f04b1070a)
    },
    {   UINT64_C(0x000000000000582a), UINT64_C(0x1f4305cf30af8726), UINT64_C(0x1f43080f38aea722),
        UINT64_C(0x1f43090ee8ae072d), UINT64_C(0x1f43130f20aa2722)
    },
    {   UINT64_C(0x000000000000582b), UINT64_C(0x1f430f4f28ae8707), UINT64_C(0x1f43020f94b706f3),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff8f2caae703)
    },
    {   UINT64_C(0x000000000000099a), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106af60f007b664a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000194a9), UINT64_C(0x21a30a07a8c94ded), UINT64_C(0x21a30a07a8c94ded),
        UINT64_C(0x21a30a07a8c94ded), UINT64_C(0x11ab264978834bfa)
    },
    {   UINT64_C(0x000000000000d1ac), UINT64_C(0x0d2af30fa06cc68c), UINT64_C(0x19a2f58fa09ea68c),
        UINT64_C(0x161af04fa092c69a), UINT64_C(0x1e62f18fa0b1a68c)
    },
    {   UINT64_C(0x000000000000582f), UINT64_C(0x1f4303ce6cb72738), UINT64_C(0x1f43020f40b64730),
        UINT64_C(0x1f4300cf68ad66ec), UINT64_C(0x1f42fe4f14b506f0)
    },
    {   UINT64_C(0x000000000000665c), UINT64_C(0x1f42fece8ca96720), UINT64_C(0x1f42fe8f88b50725),
        UINT64_C(0x1f42fb0f60ac8718), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000194ab), UINT64_C(0x431b018e55412473), UINT64_C(0x3af2ee0d1d2a442e),
        UINT64_C(0x3af2ee18912a470b), UINT64_C(0x3af2ee0e492a4485)
    },
    {   UINT64_C(0x000000000000d1ae), UINT64_C(0x131af20fa089868c), UINT64_C(0x1852f6cf589b669c),
        UINT64_C(0x14caf18fa08ce68c), UINT64_C(0x14daf5cfa08e068c)
    },
    {   UINT64_C(0x0000000000005833), UINT64_C(0x1f430d0f04af272e), UINT64_C(0x1f42ff4f28b6a6e0),
        UINT64_C(0x1f430e0f24afa733), UINT64_C(0x1f42fa4f08b5a6f3)
    },
    {   UINT64_C(0x000000000000665e), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb8fd0b3c70f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000194ad), UINT64_C(0x1a52fb097c86abfa), UINT64_C(0x143b264978892bfa),
        UINT64_C(0x143afa8978734bfa), UINT64_C(0x17eb060978924bfa)
    },
    {   UINT64_C(0x000000000000665f), UINT64_C(0x1f42face9cb20715), UINT64_C(0x1f42fb8f14b2671b),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f9cef0b3071c)
    },
    {   UINT64_C(0x00000000000194ae), UINT64_C(0x17eb05c978922bfa), UINT64_C(0x221b080978b5ebfb),
        UINT64_C(0x221b100978b9ebfb), UINT64_C(0x203b11c978aaebfa)
    },
    {   UINT64_C(0x0000000000005838), UINT64_C(0x1f4316cf1cb46744), UINT64_C(0x1f430c4f64afa724),
        UINT64_C(0x1f42fdcfd4b686e6), UINT64_C(0x1f42ff4ed8b2e71e)
    },
    {   UINT64_C(0x00000000000194af), UINT64_C(0x203b170978ad8bfa), UINT64_C(0x202b1b097cb0cbfa),
        UINT64_C(0x202b0ac97ca8abfa), UINT64_C(0x19430d07ac9a0dee)
    },
    {   UINT64_C(0x000000000000583a), UINT64_C(0x1f4303cebcb6a71a), UINT64_C(0x1f430b4f80ac06fa),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43128f10b18726)
    },
    {   UINT64_C(0x000000000000583b), UINT64_C(0x1f43014f08abc6fc), UINT64_C(0x1f42fcceacafa6fe),
        UINT64_C(0x1f43038e8caf8708), UINT64_C(0x1f43090f2cb0c70b)
    },
    {   UINT64_C(0x0000000000006662), UINT64_C(0x1f42f8cf0cb2471d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f9cf50b5870c), UINT64_C(0x1f42f5ced8b26715)
    },
    {   UINT64_C(0x00000000000009ab), UINT64_C(0x0000000000000000), UINT64_C(0x106ad751088b85f1),
        UINT64_C(0x106aba4e989a268d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000009ac), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106aff0bfc7785a2), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000583f), UINT64_C(0x1f4300cf68ae8703), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43018ef8b62722), UINT64_C(0x1f43024f08b406fb)
    },
    {   UINT64_C(0x0000000000006664), UINT64_C(0x1f42f8cff8af471f), UINT64_C(0x1f42f9cf58b0a71c),
        UINT64_C(0x1f42fd0ef8b88713), UINT64_C(0x1f42f5cfa4b7c6f1)
    },
    {   UINT64_C(0x0000000000005841), UINT64_C(0x1f43008f08b2e6f7), UINT64_C(0x1f43028e7cb16733),
        UINT64_C(0x1f43014f08afa711), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006665), UINT64_C(0x1f42f9cf70b0c6f1), UINT64_C(0x1f42f8ceb0b4e73b),
        UINT64_C(0x1f43078f2cb1c726), UINT64_C(0x1f42f88f7cb54714)
    },
    {   UINT64_C(0x0000000000005843), UINT64_C(0x0000000000000000), UINT64_C(0x1f43104f30ade733),
        UINT64_C(0x1f42fd4f04b5c732), UINT64_C(0x1f43094eccb18731)
    },
    {   UINT64_C(0x000000000000d1b7), UINT64_C(0x0de2f44f687445c1), UINT64_C(0x143af10f688c069c),
        UINT64_C(0x119af10f5482c5c1), UINT64_C(0x146af40c6c8d268c)
    },
    {   UINT64_C(0x0000000000005845), UINT64_C(0x1f43044f00ac6703), UINT64_C(0x1f42fe4ec0b0670f),
        UINT64_C(0x1f42fe8edcae0719), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006667), UINT64_C(0x1f42fa0f84b626f6), UINT64_C(0x1f42facfc8b426f4),
        UINT64_C(0x1f4303cf08b3c704), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005847), UINT64_C(0x1f43054f5cad8704), UINT64_C(0x1f43008ef4b186fb),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43004eacb1a741)
    },
    {   UINT64_C(0x0000000000006668), UINT64_C(0x0000000000000000), UINT64_C(0x1f4301cf58b3c6ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4301cf78b6a6f4)
    },
    {   UINT64_C(0x0000000000005849), UINT64_C(0x1f43064eecac0727), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43014eacb1672c), UINT64_C(0x1f4302cf08b94712)
    },
    {   UINT64_C(0x0000000000006669), UINT64_C(0x0000000000000000), UINT64_C(0x1f43000f30b66725),
        UINT64_C(0x1f42f80e5cb4c71d), UINT64_C(0x1f42fc100cb32703)
    },
    {   UINT64_C(0x000000000000584b), UINT64_C(0x1f430f0f08b44734), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd8ebcac0700), UINT64_C(0x1f42ff8e80b4e709)
    },
    {   UINT64_C(0x000000000000584c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43008ec8b446ff), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000584d), UINT64_C(0x1f42fe8ed0b5070b), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc8e68b4071f), UINT64_C(0x1f4300cfa4b3c716)
    },
    {   UINT64_C(0x000000000000584e), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43098f1caf6730)
    },
    {   UINT64_C(0x000000000000584f), UINT64_C(0x1f42ffce74b2a72f), UINT64_C(0x1f42fc8e50b44734),
        UINT64_C(0x1f43024ed8b64727), UINT64_C(0x1f42fe4f58abc725)
    },
    {   UINT64_C(0x0000000000005850), UINT64_C(0x1f43018eacaee705), UINT64_C(0x1f430c4f08b1272a),
        UINT64_C(0x1f43068ee0af4743), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005851), UINT64_C(0x1f43018eecb9471d), UINT64_C(0x1f42fd8ebcb8e6fb),
        UINT64_C(0x1f43014f18aca6ff), UINT64_C(0x1f43050f40aee72a)
    },
    {   UINT64_C(0x0000000000005852), UINT64_C(0x1f43110e88b0073c), UINT64_C(0x1f43010eccab871a),
        UINT64_C(0x1f42ff0eccb2a72e), UINT64_C(0x1f4312cf08ae2724)
    },
    {   UINT64_C(0x0000000000005853), UINT64_C(0x1f42fdcf44b58729), UINT64_C(0x1f42fd0f28b2c6f7),
        UINT64_C(0x1f43010e74b20718), UINT64_C(0x1f42ffceccb34704)
    },
    {   UINT64_C(0x0000000000005854), UINT64_C(0x0000000000000000), UINT64_C(0x1f43038f94b7670b),
        UINT64_C(0x1f43004ea4adc73a), UINT64_C(0x1f42fd0ee8a9270e)
    },
    {   UINT64_C(0x0000000000005855), UINT64_C(0x1f42fd0eecb2472a), UINT64_C(0x1f42fe0e74b74747),
        UINT64_C(0x1f42fd4edcada6f8), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005856), UINT64_C(0x1f4300ce38b8874c), UINT64_C(0x1f42ff4ebcb2e725),
        UINT64_C(0x1f42fece8cb5c71a), UINT64_C(0x1f4300ceb8afe72f)
    },
    {   UINT64_C(0x0000000000005857), UINT64_C(0x0000000000000000), UINT64_C(0x1f4310cf30b00717),
        UINT64_C(0x1f43060e1cae0734), UINT64_C(0x1f42fd8f58b1c6f3)
    },
    {   UINT64_C(0x0000000000005858), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0ef8b3a70f),
        UINT64_C(0x1f43004ee0b2e70d), UINT64_C(0x1f43090e70b3471d)
    },
    {   UINT64_C(0x00000000000009c7), UINT64_C(0x0000000000000000), UINT64_C(0x106af58f587c660c),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006671), UINT64_C(0x1f42f3cfb8b8a6ea), UINT64_C(0x1f42f84fb8b666de),
        UINT64_C(0x1f42f50f58b206de), UINT64_C(0x1f42f98fa8b246f0)
    },
    {   UINT64_C(0x000000000000585b), UINT64_C(0x1f42fd0eecaee738), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd4ea4b26741), UINT64_C(0x1f43024ed4b1471e)
    },
    {   UINT64_C(0x0000000000006672), UINT64_C(0x1f42fa0fb8b586e9), UINT64_C(0x1f42fa0f64b1e6cb),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0f58ae46cb)
    },
    {   UINT64_C(0x000000000000f8c3), UINT64_C(0x0000000000000000), UINT64_C(0x0c2ae50bf47506ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x1852f58bf49ea6ef)
    },
    {   UINT64_C(0x000000000000585e), UINT64_C(0x0000000000000000), UINT64_C(0x1f430a8f6cac670b),
        UINT64_C(0x1f42fc0ec4b14734), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000f8c4), UINT64_C(0x0000000000000000), UINT64_C(0x161af04c6492c6ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x1d82f18bf4b1a6ef)
    },
    {   UINT64_C(0x0000000000005860), UINT64_C(0x1f42fa4eb0b2a722), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430e8e44b3e738), UINT64_C(0x1f430ccf1cb06730)
    },
    {   UINT64_C(0x0000000000005861), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43008f10b2471a)
    },
    {   UINT64_C(0x0000000000005862), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe0ef4ad4700),
        UINT64_C(0x1f43000f00b44738), UINT64_C(0x1f430fcf5caf0703)
    },
    {   UINT64_C(0x0000000000005863), UINT64_C(0x1f43070f34abe723), UINT64_C(0x1f42ff4f0cb6872d),
        UINT64_C(0x1f43020f0cb00733), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005864), UINT64_C(0x1f43028e1cb4e73b), UINT64_C(0x1f430ece80b2671c),
        UINT64_C(0x1f42fbcee8b08731), UINT64_C(0x1f42ffcf08b58728)
    },
    {   UINT64_C(0x0000000000005865), UINT64_C(0x1f42ff4f78b32708), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43088f3cae671d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005866), UINT64_C(0x0000000000000000), UINT64_C(0x1f43018e94b1c729),
        UINT64_C(0x1f43078e3cb3671d), UINT64_C(0x1f42ffce6cb26713)
    },
    {   UINT64_C(0x0000000000005867), UINT64_C(0x0000000000000000), UINT64_C(0x1f43144f2cb1c706),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff8eecb64711)
    },
    {   UINT64_C(0x0000000000005868), UINT64_C(0x0000000000000000), UINT64_C(0x1f43014eacaee70a),
        UINT64_C(0x1f4301cedcb3073a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005869), UINT64_C(0x1f43048ea0b36743), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc4f18af8719)
    },
    {   UINT64_C(0x000000000000586a), UINT64_C(0x1f430e4f6cabc709), UINT64_C(0x1f4306cf10b26728),
        UINT64_C(0x1f42fd4ef4ac6703), UINT64_C(0x1f42fd4ef0ace6ff)
    },
    {   UINT64_C(0x000000000000586b), UINT64_C(0x1f42fbcec8b00715), UINT64_C(0x1f42f8ce90b7c73e),
        UINT64_C(0x1f43008f58b5c707), UINT64_C(0x1f42f90f08b48704)
    },
    {   UINT64_C(0x000000000000586c), UINT64_C(0x1f43000e90aa6704), UINT64_C(0x1f42f94f68b446eb),
        UINT64_C(0x1f43168e98b10736), UINT64_C(0x1f43058e78b5070f)
    },
    {   UINT64_C(0x000000000000586d), UINT64_C(0x1f42fecef8b4a70b), UINT64_C(0x1f430a0f38ad070a),
        UINT64_C(0x1f42fe0f00b66736), UINT64_C(0x1f43030f28b40719)
    },
    {   UINT64_C(0x000000000000586e), UINT64_C(0x1f42fecf38b84703), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43038edcad672a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000586f), UINT64_C(0x1f430ecf38af671e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4303cf48afa714), UINT64_C(0x1f42fb8f18b806f7)
    },
    {   UINT64_C(0x0000000000005870), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fecee4b446ff),
        UINT64_C(0x1f43044ef8af873d), UINT64_C(0x1f43148eb0b44742)
    },
    {   UINT64_C(0x0000000000005871), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe0eacb72716),
        UINT64_C(0x1f42ff4eecb2c6fb), UINT64_C(0x1f4309cebcb24712)
    },
    {   UINT64_C(0x0000000000005872), UINT64_C(0x1f42fcced8b3e722), UINT64_C(0x1f42fa8ef8b10732),
        UINT64_C(0x1f43014f58b6472d), UINT64_C(0x1f43020f28b1e6f2)
    },
    {   UINT64_C(0x0000000000005873), UINT64_C(0x1f43004e8cac0720), UINT64_C(0x1f42fb4e7cb72735),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005874), UINT64_C(0x1f42f98f00b5c73a), UINT64_C(0x1f43114f40b0871b),
        UINT64_C(0x1f43000fa0ab6714), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005875), UINT64_C(0x1f4304cef4ad871a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43080f2cab8718), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000667f), UINT64_C(0x1f42f84f44b6a6f6), UINT64_C(0x1f42fc0f14a8e6ec),
        UINT64_C(0x1f42f88ff0b6a6fb), UINT64_C(0x1f42fa0facb3a71f)
    },
    {   UINT64_C(0x0000000000005877), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43014e54b9c73b), UINT64_C(0x1f430a4f48b24742)
    },
    {   UINT64_C(0x0000000000006680), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8ce84b36734),
        UINT64_C(0x1f42f88e8cb0e71d), UINT64_C(0x1f42fa4facb3c6ea)
    },
    {   UINT64_C(0x0000000000005879), UINT64_C(0x1f42ff0e80ae0729), UINT64_C(0x1f42f6cee0ac0733),
        UINT64_C(0x1f42fe4eacaf66f8), UINT64_C(0x1f43000e90b14721)
    },
    {   UINT64_C(0x000000000000587a), UINT64_C(0x1f42fc0f58af06f0), UINT64_C(0x1f42fe4e60b8874f),
        UINT64_C(0x1f42f80e80b8e709), UINT64_C(0x1f42fe4e7cafe700)
    },
    {   UINT64_C(0x000000000000587b), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8e84b0672c),
        UINT64_C(0x1f42ff8e90b3670d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000587c), UINT64_C(0x1f42fe0f10ac2703), UINT64_C(0x1f42fe8e98b2a726),
        UINT64_C(0x1f42f8cf5cb1272d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000587d), UINT64_C(0x1f42fd0ed4b40716), UINT64_C(0x1f42fe0ec4b24736),
        UINT64_C(0x1f42fc0f8caf671b), UINT64_C(0x1f42fe0f00b8073a)
    },
    {   UINT64_C(0x000000000000587e), UINT64_C(0x1f43110f14b08721), UINT64_C(0x1f43008ea0b1871f),
        UINT64_C(0x1f42fcced4b3e716), UINT64_C(0x1f42ff0f10ac4708)
    },
    {   UINT64_C(0x000000000000587f), UINT64_C(0x1f43020e6cb2c729), UINT64_C(0x1f43010e7cb2e73d),
        UINT64_C(0x1f43010e7cb5c72c), UINT64_C(0x1f42ffcf74b12722)
    },
    {   UINT64_C(0x0000000000005880), UINT64_C(0x1f430d4f7cacc735), UINT64_C(0x1f43050eb0b0e726),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4300cebcb34745)
    },
    {   UINT64_C(0x0000000000005881), UINT64_C(0x1f4300ce68b4071f), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430c0f14b1e72e), UINT64_C(0x1f43050ea0b06722)
    },
    {   UINT64_C(0x0000000000005882), UINT64_C(0x1f43178eacad66fb), UINT64_C(0x1f43178e30aec71b),
        UINT64_C(0x1f4304ce88b2a730), UINT64_C(0x1f4311ceecabe700)
    },
    {   UINT64_C(0x0000000000005883), UINT64_C(0x1f4300ce84b00731), UINT64_C(0x1f4304ce70b2271d),
        UINT64_C(0x1f43018ebcb08734), UINT64_C(0x1f43008ef4b1e71a)
    },
    {   UINT64_C(0x0000000000005884), UINT64_C(0x1f43038eccb4c72b), UINT64_C(0x1f43028e88b2a72b),
        UINT64_C(0x1f4302ceb4b52731), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005885), UINT64_C(0x1f43224e98b18732), UINT64_C(0x1f42fd8efcb08715),
        UINT64_C(0x1f43040ea8b1872d), UINT64_C(0x1f42fccf58b32708)
    },
    {   UINT64_C(0x0000000000005886), UINT64_C(0x1f43094f1cb266fc), UINT64_C(0x1f42fe8eb4b3271a),
        UINT64_C(0x1f42f90eb0b50729), UINT64_C(0x1f431a8e1caf672a)
    },
    {   UINT64_C(0x0000000000005887), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f94f58b5e708),
        UINT64_C(0x1f4305ce1caf8738), UINT64_C(0x1f42fa8f28b18725)
    },
    {   UINT64_C(0x0000000000005888), UINT64_C(0x1f43014ed8afa713), UINT64_C(0x1f42f80e94b5e711),
        UINT64_C(0x1f43028eacb0a734), UINT64_C(0x1f4306cef4af06ea)
    },
    {   UINT64_C(0x0000000000005889), UINT64_C(0x1f43048f14afc6f3), UINT64_C(0x1f4308ceb4b46715),
        UINT64_C(0x1f42fe4ed0b36716), UINT64_C(0x1f42f7ce50b3070c)
    },
    {   UINT64_C(0x000000000000588a), UINT64_C(0x0000000000000000), UINT64_C(0x1f43010ea8b56716),
        UINT64_C(0x1f42fc0ef0b0272a), UINT64_C(0x1f42f7cf50b3e701)
    },
    {   UINT64_C(0x000000000000588b), UINT64_C(0x1f4303ced4b20706), UINT64_C(0x1f43034f18ae26fe),
        UINT64_C(0x1f42f98f04b2e719), UINT64_C(0x1f42fbce68b4a705)
    },
    {   UINT64_C(0x000000000000588c), UINT64_C(0x1f42fb8ed0b22716), UINT64_C(0x1f42fa8e78b5470c),
        UINT64_C(0x1f42f74e78b4272c), UINT64_C(0x1f42f88ee8b50723)
    },
    {   UINT64_C(0x000000000000588d), UINT64_C(0x1f43090ea4b18719), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4312cf00a926e7), UINT64_C(0x1f43038ecca0071f)
    },
    {   UINT64_C(0x000000000000668b), UINT64_C(0x1f42facefcb4c704), UINT64_C(0x1f43178e64a6e72c),
        UINT64_C(0x1f42facfacaf26d9), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000f8dc), UINT64_C(0x0000000000000000), UINT64_C(0x16f2f4cbf49746ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000668c), UINT64_C(0x1f42f68e68b6e722), UINT64_C(0x1f42facf8caee718),
        UINT64_C(0x1f42face5cb3471d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005891), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fe4ea8b64739), UINT64_C(0x1f42fd8ea0a3872d)
    },
    {   UINT64_C(0x000000000000668d), UINT64_C(0x1f42fc4f88b166ed), UINT64_C(0x1f42fb0fb8b026d9),
        UINT64_C(0x1f42fa8efcabc70c), UINT64_C(0x1f42f74f64b7e6f3)
    },
    {   UINT64_C(0x0000000000005893), UINT64_C(0x1f43314f648e0700), UINT64_C(0x1f430b0e9cab2726),
        UINT64_C(0x1f42f78f00b266fa), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005894), UINT64_C(0x1f42fe8f0cada6f5), UINT64_C(0x1f42fa0eacb04700),
        UINT64_C(0x1f42f54ee0b8e6e9), UINT64_C(0x1f42f90ec4b0270c)
    },
    {   UINT64_C(0x0000000000005895), UINT64_C(0x1f42f3cf38aca710), UINT64_C(0x1f42fd0f38b2c710),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005896), UINT64_C(0x1f42facf1cb6e709), UINT64_C(0x1f42facf00b5c6ed),
        UINT64_C(0x1f42ff0e98aea6e9), UINT64_C(0x1f42f90ed0b36718)
    },
    {   UINT64_C(0x0000000000005897), UINT64_C(0x1f42f98ec8b28704), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff0e9cb44700), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005898), UINT64_C(0x1f42f94f20b686e8), UINT64_C(0x1f42fb4f00b6c6e9),
        UINT64_C(0x1f42faceecb2e6fc), UINT64_C(0x1f42f94ee0ac471c)
    },
    {   UINT64_C(0x0000000000005899), UINT64_C(0x1f42f5cf10b846f5), UINT64_C(0x1f42fd0f00b326e4),
        UINT64_C(0x1f42fa4eacb4a6f0), UINT64_C(0x1f42fc8f40b34703)
    },
    {   UINT64_C(0x000000000000589a), UINT64_C(0x1f42f6cf20b72710), UINT64_C(0x1f42facf44ad26f5),
        UINT64_C(0x1f42fb4f48b02708), UINT64_C(0x1f42f94f40a8e6fc)
    },
    {   UINT64_C(0x000000000000589b), UINT64_C(0x1f42f90f40b10710), UINT64_C(0x1f42f90f04b2e711),
        UINT64_C(0x1f42f80f38b92708), UINT64_C(0x1f42f70f2cb56710)
    },
    {   UINT64_C(0x000000000000589c), UINT64_C(0x1f42f8cf30b486d9), UINT64_C(0x1f42fa0f84b166f9),
        UINT64_C(0x1f42fd4f1cb6c6e5), UINT64_C(0x1f42f70ed0b62701)
    },
    {   UINT64_C(0x000000000000589d), UINT64_C(0x1f42fe4e5cb886f0), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f9cf48b72718), UINT64_C(0x1f42fa4f04b2c6e9)
    },
    {   UINT64_C(0x000000000000589e), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cf14b6e701),
        UINT64_C(0x1f42fc4f24b006e1), UINT64_C(0x1f42fc4ef8aee6f1)
    },
    {   UINT64_C(0x000000000000589f), UINT64_C(0x1f42f4cf14b52710), UINT64_C(0x1f42fa0f04b686e5),
        UINT64_C(0x1f42fe4f28b3071b), UINT64_C(0x1f42ff0ee4b72704)
    },
    {   UINT64_C(0x00000000000058a0), UINT64_C(0x1f42f94ee8b7871f), UINT64_C(0x1f42fb0f24b7e6e5),
        UINT64_C(0x1f42f80ee8b74714), UINT64_C(0x1f43000f24aec6fc)
    },
    {   UINT64_C(0x00000000000058a1), UINT64_C(0x1f42f74eccb62727), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f9cf88b54708), UINT64_C(0x1f42fd4f04ac46e9)
    },
    {   UINT64_C(0x00000000000058a2), UINT64_C(0x1f42fd0eeca446f1), UINT64_C(0x1f42f54f04b5a710),
        UINT64_C(0x1f42f88f3cb66711), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000058a3), UINT64_C(0x1f42fc0f30b3e6e8), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fe4f04af66f0), UINT64_C(0x1f42fccf04b5e6f1)
    },
    {   UINT64_C(0x00000000000058a4), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0e5caee724),
        UINT64_C(0x1f42f58e78b4272b), UINT64_C(0x1f42f38f38ba0705)
    },
    {   UINT64_C(0x00000000000058a5), UINT64_C(0x1f42fc0f18aca6f5), UINT64_C(0x1f42f88f34b7c705),
        UINT64_C(0x1f42f6ce4cb6071d), UINT64_C(0x1f42f68f44b6e714)
    },
    {   UINT64_C(0x00000000000058a6), UINT64_C(0x1f42f8ce6cb44720), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42facf44b0c6f5), UINT64_C(0x1f42f88ef4b3e700)
    },
    {   UINT64_C(0x00000000000058a7), UINT64_C(0x1f42f3cf58b8a725), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f28f84b946f8), UINT64_C(0x1f42fccea0b1271a)
    },
    {   UINT64_C(0x0000000000006698), UINT64_C(0x1f42f80fa4b446fe), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f8cf90b52729), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000058a9), UINT64_C(0x1f42f80fb0a96720), UINT64_C(0x1f4300cf44b5671c),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000058aa), UINT64_C(0x1f42f50e7cb4e718), UINT64_C(0x1f42f54eb4b686f9),
        UINT64_C(0x1f42f74e8ca886ed), UINT64_C(0x1f42fa4f48b92719)
    },
    {   UINT64_C(0x00000000000058ab), UINT64_C(0x1f42f80f4cafe700), UINT64_C(0x1f42f74f44b6c6f9),
        UINT64_C(0x1f42f54ee0b6a6f9), UINT64_C(0x1f42f7cf44b4e6fc)
    },
    {   UINT64_C(0x00000000000058ac), UINT64_C(0x1f42f54f44b346f9), UINT64_C(0x1f42f7cf14b40728),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cf54b566fc)
    },
    {   UINT64_C(0x00000000000058ad), UINT64_C(0x1f42f54f44b586f9), UINT64_C(0x1f42f58f98b7a724),
        UINT64_C(0x1f42f90f24b826f9), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000058ae), UINT64_C(0x1f42f54f44b546f9), UINT64_C(0x1f42f64f08b5c722),
        UINT64_C(0x1f42f2ce80b92723), UINT64_C(0x1f42f7cea8ad46fd)
    },
    {   UINT64_C(0x00000000000058af), UINT64_C(0x1f42f80e7caee72b), UINT64_C(0x1f42f94f34b0c708),
        UINT64_C(0x1f42f80f34ae46f9), UINT64_C(0x1f42fa0f50b24700)
    },
    {   UINT64_C(0x00000000000058b0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f5ce6cb2a73f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000058b1), UINT64_C(0x1f42efcf4cb32711), UINT64_C(0x1f42f84f24b006f9),
        UINT64_C(0x1f42f84e7cafc718), UINT64_C(0x1f42f7cf30b44708)
    },
    {   UINT64_C(0x00000000000058b2), UINT64_C(0x1f42f5cf2caac714), UINT64_C(0x1f42f5cf18b74720),
        UINT64_C(0x1f42f78ef8b146f1), UINT64_C(0x1f42f84f20b3a700)
    },
    {   UINT64_C(0x00000000000058b3), UINT64_C(0x1f42f44e4cb3071c), UINT64_C(0x1f42f9cf5cac0718),
        UINT64_C(0x1f42fb4f20b54700), UINT64_C(0x1f43078ea0b12729)
    },
    {   UINT64_C(0x000000000000669e), UINT64_C(0x1f42f68f34b466d5), UINT64_C(0x1f42fc0f44b0471b),
        UINT64_C(0x1f42f68f9cac26e4), UINT64_C(0x1f42f84f94b166ea)
    },
    {   UINT64_C(0x00000000000058b5), UINT64_C(0x1f42f74f14b6a714), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa0f14b6e714), UINT64_C(0x1f42f20f20af26fc)
    },
    {   UINT64_C(0x000000000000669f), UINT64_C(0x1f42f9cfa4b1c6fa), UINT64_C(0x1f43094e84b1072d),
        UINT64_C(0x1f4312cee8a4c71f), UINT64_C(0x1f42f60ee8b786f3)
    },
    {   UINT64_C(0x00000000000058b7), UINT64_C(0x1f42fc8eb8b6670c), UINT64_C(0x1f42f90eb8b60718),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90f00b0c70c)
    },
    {   UINT64_C(0x00000000000058b8), UINT64_C(0x1f42f7cf20b6c701), UINT64_C(0x1f4301cf80b1c708),
        UINT64_C(0x1f42fc0f78b48701), UINT64_C(0x1f42fa0efcadc723)
    },
    {   UINT64_C(0x00000000000058b9), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc4f2cac0700),
        UINT64_C(0x1f42f5cf14b06711), UINT64_C(0x1f42fa8f18ae870a)
    },
    {   UINT64_C(0x00000000000058ba), UINT64_C(0x1f42fa0f24b4470b), UINT64_C(0x1f42fb0eb8b5e6f5),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f94ef4b4c6f1)
    },
    {   UINT64_C(0x00000000000058bb), UINT64_C(0x1f42f7cef4b5e710), UINT64_C(0x1f42f50fb0b56713),
        UINT64_C(0x1f42f98efcae0729), UINT64_C(0x1f42f7cf04b8a710)
    },
    {   UINT64_C(0x00000000000058bc), UINT64_C(0x1f42f6cf08b3a6f5), UINT64_C(0x1f42f74f38b28704),
        UINT64_C(0x1f42fc0e3cb9873c), UINT64_C(0x1f42f80e70b7272d)
    },
    {   UINT64_C(0x00000000000058bd), UINT64_C(0x1f42f88edcb726f9), UINT64_C(0x1f42fd8eecb286f5),
        UINT64_C(0x1f42f9cec4a746ff), UINT64_C(0x1f42fa8ea4b3a729)
    },
    {   UINT64_C(0x00000000000058be), UINT64_C(0x1f42fa0e8cad46fc), UINT64_C(0x1f42fa4f04b2a6e9),
        UINT64_C(0x1f42fe8eccb5c706), UINT64_C(0x1f42fb0f34b34700)
    },
    {   UINT64_C(0x00000000000058bf), UINT64_C(0x1f42f24e9cb3670a), UINT64_C(0x1f42f60e24b1e728),
        UINT64_C(0x1f42f80f84ba2718), UINT64_C(0x1f43094e14b90741)
    },
    {   UINT64_C(0x00000000000058c0), UINT64_C(0x1f42f70f24b606f5), UINT64_C(0x1f42f80e34b5072f),
        UINT64_C(0x1f42f80ebcaf8715), UINT64_C(0x1f42f98f04b106f5)
    },
    {   UINT64_C(0x00000000000058c1), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0f2cae8714)
    },
    {   UINT64_C(0x00000000000058c2), UINT64_C(0x1f4308ce58aac739), UINT64_C(0x1f42f80f44b5270c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0f04ae46ed)
    },
    {   UINT64_C(0x000000000000800c), UINT64_C(0x0fa2f40f687a068c), UINT64_C(0x0fa309cfa06fc68c),
        UINT64_C(0x0fa2f54fa079c68c), UINT64_C(0x0fa2f84f6874668c)
    },
    {   UINT64_C(0x000000000000800d), UINT64_C(0x0fa2f10fa079a68c), UINT64_C(0x0fa2f5cf68754698),
        UINT64_C(0x0fa2f68f68790694), UINT64_C(0x0fa2f30f8076a67e)
    },
    {   UINT64_C(0x000000000000800e), UINT64_C(0x0fa2fc0f6876268c), UINT64_C(0x0fa2f58f4877e68c),
        UINT64_C(0x08b3024f745685b3), UINT64_C(0x08b3020d6c59e5b3)
    },
    {   UINT64_C(0x000000000000800f), UINT64_C(0x156afc0f408c25fe), UINT64_C(0x156afa11808e256a),
        UINT64_C(0x156afc0f408c25fe), UINT64_C(0x0de2ff0f8072468c)
    },
    {   UINT64_C(0x00000000000058c7), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f88f3cb3a6f4),
        UINT64_C(0x1f42fa4f90b46717), UINT64_C(0x1f42fa8f40b246f9)
    },
    {   UINT64_C(0x00000000000058c8), UINT64_C(0x1f42f84f40b5e704), UINT64_C(0x1f42f90f64a9a6f9),
        UINT64_C(0x1f42fc0f08b5c700), UINT64_C(0x1f42f7ceccb3e714)
    },
    {   UINT64_C(0x09211c2340008012), UINT64_C(0x1692f28fa096667e), UINT64_C(0x0a6af28fa065e67e),
        UINT64_C(0x0baaec8f686ac67e), UINT64_C(0x1692f64fa098e67e)
    },
    {   UINT64_C(0x00000000000058ca), UINT64_C(0x1f42f94f94b80720), UINT64_C(0x1f42f4ceccb9c6f5),
        UINT64_C(0x1f42f44e5cb22737), UINT64_C(0x1f42fe8f34b44718)
    },
    {   UINT64_C(0x00000000000058cb), UINT64_C(0x1f42f80e54b3a72a), UINT64_C(0x1f42fa4ef0b686ec),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f98f28b70718)
    },
    {   UINT64_C(0x1952c855c9088015), UINT64_C(0x131af24fa088a67e), UINT64_C(0x1692f18f6896a67e),
        UINT64_C(0x1692f20f7495a67e), UINT64_C(0x1d82ef4f74b3067e)
    },
    {   UINT64_C(0x0003e8740e308016), UINT64_C(0x1692f08fa096867e), UINT64_C(0x1692f38fa096667e),
        UINT64_C(0x1322f08fa089467e), UINT64_C(0x0a6b040d3063e67e)
    },
    {   UINT64_C(0x0000000000008017), UINT64_C(0x08b2ebcf6862668c), UINT64_C(0x0a6af68d305d267e),
        UINT64_C(0x0eaaf4144476467e), UINT64_C(0x0fa2ee0dac7d039d)
    },
    {   UINT64_C(0x00000000000058cf), UINT64_C(0x1f42f7cf20b46703), UINT64_C(0x1f42f90f54b7e713),
        UINT64_C(0x1f42f6cf34b7a70b), UINT64_C(0x1f42fa0eccb20720)
    },
    {   UINT64_C(0x22240e8040008019), UINT64_C(0x0fa2f4cf787be693), UINT64_C(0x0de2f44f787385b4),
        UINT64_C(0x0a6af30fa06e6693), UINT64_C(0x0fa2f50c387945b4)
    },
    {   UINT64_C(0x00000000000058d1), UINT64_C(0x1f42f80e98b6a70c), UINT64_C(0x1f42f80e98ab46eb),
        UINT64_C(0x1f42f60f34ac0720), UINT64_C(0x1f42f80ec0b32712)
    },
    {   UINT64_C(0x00000000000058d2), UINT64_C(0x1f42f7cee4b82705), UINT64_C(0x1f42f88f18b84720),
        UINT64_C(0x1f42f7ce84b5670e), UINT64_C(0x1f42f7ce6cb38712)
    },
    {   UINT64_C(0x28b4ba96d2c8801c), UINT64_C(0x0fa2ef4c3c7945b4), UINT64_C(0x0fa2f40c3c7b85b4),
        UINT64_C(0x0a6aef4fa06865b4), UINT64_C(0x0c2afacf786a05b3)
    },
    {   UINT64_C(0x2b5536a69468801d), UINT64_C(0x08b2f14f7861662b), UINT64_C(0x0fa2f04f787a85aa),
        UINT64_C(0x0fa2f2cf687a25aa), UINT64_C(0x1692f34f689545aa)
    },
    {   UINT64_C(0x000000b55678801e), UINT64_C(0x0fa2f24fa07a65aa), UINT64_C(0x0fa2f18c3879e5aa),
        UINT64_C(0x0de2f4cfa072c5aa), UINT64_C(0x0f03070ccc6a4690)
    },
    {   UINT64_C(0x00000000000058d6), UINT64_C(0x1f42f7ced8b5e712), UINT64_C(0x1f42f7ce6cb4c725),
        UINT64_C(0x1f42f80f00b0c6e9), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000058d7), UINT64_C(0x1f42f84f50b6672d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f9cf34aec708), UINT64_C(0x1f42fa4f1caa0704)
    },
    {   UINT64_C(0x00000000000058d8), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f84f14b5c714),
        UINT64_C(0x1f42f8cf54b1c6fc), UINT64_C(0x1f42f8cef0b0c71d)
    },
    {   UINT64_C(0x00000000000058d9), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f84f3cb346f0),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f58e3cb7a73e)
    },
    {   UINT64_C(0x00000000000058da), UINT64_C(0x1f42f78f64b94720), UINT64_C(0x1f42f90f30b5c712),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f84ed4aea70e)
    },
    {   UINT64_C(0x00000000000058db), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0e8cac8701),
        UINT64_C(0x1f42f88f90ae86f8), UINT64_C(0x1f42fa0eecab46ff)
    },
    {   UINT64_C(0x00000000000058dc), UINT64_C(0x1f42ffceacb5c6d5), UINT64_C(0x1f42f60f34b3c714),
        UINT64_C(0x1f42f6ced4b7e722), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000058dd), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f7cfacb0c6e8),
        UINT64_C(0x1f42f28f14b3c714), UINT64_C(0x1f42f7ced0b56729)
    },
    {   UINT64_C(0x00000000000066b3), UINT64_C(0x1f42fbcf34b346f9), UINT64_C(0x1f42f90f00b84703),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42faced0b32720)
    },
    {   UINT64_C(0x0000000000008028), UINT64_C(0x07d2ee0fa03e83e8), UINT64_C(0x0a53060c3857c5bc),
        UINT64_C(0x0fa2fb4d7876862b), UINT64_C(0x0fa2f10f807bc68c)
    },
    {   UINT64_C(0x00000000000058e0), UINT64_C(0x1f42f50ef4b5c6f9), UINT64_C(0x1f42facf14b486f8),
        UINT64_C(0x1f42fd0f80a946f3), UINT64_C(0x1f42f8ce5cb5c733)
    },
    {   UINT64_C(0x000000000000802a), UINT64_C(0x0a6af297cc660656), UINT64_C(0x17c2f78f6898c68c),
        UINT64_C(0x08a2ef15c860468c), UINT64_C(0x0fa2f89024778588)
    },
    {   UINT64_C(0x00000000000066b5), UINT64_C(0x1f42fe8f18ac4710), UINT64_C(0x1f42fa4ee4b50725),
        UINT64_C(0x1f42f68e7cb62725), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000802c), UINT64_C(0x0c82fc55b869668c), UINT64_C(0x156afa0e448e25de),
        UINT64_C(0x0962ee53d863868c), UINT64_C(0x0962f153b862e68c)
    },
    {   UINT64_C(0x000000000000802d), UINT64_C(0x0a6b05578c66268e), UINT64_C(0x0fa2f70c387e85aa),
        UINT64_C(0x1282fd0d3881067e), UINT64_C(0x07d2ff92bc55251e)
    },
    {   UINT64_C(0x2ef000000000802e), UINT64_C(0x0a6afb0c445f23e8), UINT64_C(0x0962fc53d85d868c),
        UINT64_C(0x09b2ef95c864868c), UINT64_C(0x0fa2f8d02477c588)
    },
    {   UINT64_C(0x000000000000802f), UINT64_C(0x1772f88f6897a68c), UINT64_C(0x1772f70f689b268c),
        UINT64_C(0x1772f14f6898468c), UINT64_C(0x0de2f58c386d85bb)
    },
    {   UINT64_C(0x32b640c0d7c08030), UINT64_C(0x1692f1cfa096e788), UINT64_C(0x1692f1cfa096e788),
        UINT64_C(0x1692f1cfa096e784), UINT64_C(0x1692f1cfa096e760)
    },
    {   UINT64_C(0x36f000d499b08031), UINT64_C(0x1692f1cfa096e750), UINT64_C(0x1692f1cfa096e7a9),
        UINT64_C(0x1bcaee0fa0aa667e), UINT64_C(0x14daf50c448da68c)
    },
    {   UINT64_C(0x0000000000008032), UINT64_C(0x131af10fa0892788), UINT64_C(0x131af10fa0892788),
        UINT64_C(0x131af10fa0892784), UINT64_C(0x131af10fa0892750)
    },
    {   UINT64_C(0x0000000000008033), UINT64_C(0x0a6af28fa065e788), UINT64_C(0x0a6af28fa065e788),
        UINT64_C(0x0a6af08fa066a784), UINT64_C(0x0a6af24fa065e750)
    },
    {   UINT64_C(0x3736e00000008034), UINT64_C(0x1692f20fa094267e), UINT64_C(0x1692f10f7496e760),
        UINT64_C(0x1692f68f68948788), UINT64_C(0x1692f68f68948788)
    },
    {   UINT64_C(0x0006fcdedbc08035), UINT64_C(0x1692f68f68948784), UINT64_C(0x1692f68f68948760),
        UINT64_C(0x1692f68f68948750), UINT64_C(0x1402f8cf3c8925f9)
    },
    {   UINT64_C(0x393718e15c208036), UINT64_C(0x1692f68e609486c6), UINT64_C(0x1692f18f6896a788),
        UINT64_C(0x1692f18f6896a788), UINT64_C(0x1692f18f6896a784)
    },
    {   UINT64_C(0x000000001ca08037), UINT64_C(0x1692f18f6896a750), UINT64_C(0x1692f38fa0966788),
        UINT64_C(0x1162f20fa082467e), UINT64_C(0x0fa2f10f7c790693)
    },
    {   UINT64_C(0x000000e7dce08038), UINT64_C(0x0de2f74f7875c68e), UINT64_C(0x0de2f74f7875c68e),
        UINT64_C(0x0de2f74f7875c68a), UINT64_C(0x0de2f74f7875c666)
    },
    {   UINT64_C(0x000750e95d108039), UINT64_C(0x0de2f74f7875c656), UINT64_C(0x0de2f74f7875c6b1),
        UINT64_C(0x14daf78f848d85b4), UINT64_C(0x0de2f44c447205b4)
    },
    {   UINT64_C(0x00075ceac000803a), UINT64_C(0x0de2f44f7873868e), UINT64_C(0x0de2f44f7873868e),
        UINT64_C(0x0de2f44f7873868a), UINT64_C(0x0de2f44f78738656)
    },
    {   UINT64_C(0x000000000000803b), UINT64_C(0x08b2ef8fa05ce68e), UINT64_C(0x08b2f20fa060a68e),
        UINT64_C(0x08b2e9cfa063468a), UINT64_C(0x08b2eb8fa0628656)
    },
    {   UINT64_C(0x3b4762000000803c), UINT64_C(0x0fa2f54f78796696), UINT64_C(0x0fa2f20fa07b2666),
        UINT64_C(0x0fa2f54f7879468e), UINT64_C(0x0fa2f54f7879468e)
    },
    {   UINT64_C(0x00000000000058f4), UINT64_C(0x1f42f7cf14b66728), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa0f44b1e720), UINT64_C(0x1f42fbcf6cb346f5)
    },
    {   UINT64_C(0x000000000000803e), UINT64_C(0x0fa2f54de079460f), UINT64_C(0x0fa2f04f787a868e),
        UINT64_C(0x0fa2f04f787a868e), UINT64_C(0x0fa2f04f787a868a)
    },
    {   UINT64_C(0x00000000000066bf), UINT64_C(0x1f430ace8cb466ff), UINT64_C(0x1f430b8f38aa46ef),
        UINT64_C(0x1f43088e7ca4c70b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008040), UINT64_C(0x1692f1cfa096e6ed), UINT64_C(0x0de2f74f7875c619),
        UINT64_C(0x1692f1cfa096e754), UINT64_C(0x0de2f74f7875c680)
    },
    {   UINT64_C(0x00000000000066c0), UINT64_C(0x0000000000000000), UINT64_C(0x1f430b8ee0a5c707),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430cce7cae6730)
    },
    {   UINT64_C(0x0000000000008042), UINT64_C(0x14daf50f688da75e), UINT64_C(0x0de2f44f7872068a),
        UINT64_C(0x14daf50f688da72a), UINT64_C(0x0de2f44f78720656)
    },
    {   UINT64_C(0x00000000000066c1), UINT64_C(0x1f430ece68a5e721), UINT64_C(0x1f4300ce70a98727),
        UINT64_C(0x1f4301cec0b4a728), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008044), UINT64_C(0x1692f20fa094267e), UINT64_C(0x0fa2f4cf787de693),
        UINT64_C(0x131af10fa08926ed), UINT64_C(0x0de2f44f78738619)
    },
    {   UINT64_C(0x00000000000058fc), UINT64_C(0x1f42fd0ea4aee6e8), UINT64_C(0x1f43114e60ae0717),
        UINT64_C(0x1f42fa0f28ae870d), UINT64_C(0x1f42f78f3cb0e70e)
    },
    {   UINT64_C(0x00000000000058fd), UINT64_C(0x1f42f78edcb78711), UINT64_C(0x1f42fa0f4cb226f0),
        UINT64_C(0x1f42f98e9cb0471b), UINT64_C(0x1f42fa0ea0b1e720)
    },
    {   UINT64_C(0x00000000000058fe), UINT64_C(0x1f42fc8f58b42710), UINT64_C(0x1f42f80eb0b36715),
        UINT64_C(0x1f43008f14b246fc), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000058ff), UINT64_C(0x0000000000000000), UINT64_C(0x1f42facf60b2c70e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f64f5cb5c6fb)
    },
    {   UINT64_C(0x0000000000008049), UINT64_C(0x1692f28fa096675e), UINT64_C(0x0fa2f04fa07b675e),
        UINT64_C(0x169af24fa096467e), UINT64_C(0x0fa2f00fa07b6693)
    },
    {   UINT64_C(0x000000000000804a), UINT64_C(0x0a6aee4fa067e73a), UINT64_C(0x08b2e7cfa064a666),
        UINT64_C(0x0a6af0cfa066c6ed), UINT64_C(0x08b2e8cfa062c619)
    },
    {   UINT64_C(0x00000000000066c5), UINT64_C(0x0000000000000000), UINT64_C(0x1f43070e64a9673d),
        UINT64_C(0x1f43040e0cb5473d), UINT64_C(0x1f430b0ebca78731)
    },
    {   UINT64_C(0x000000000000804c), UINT64_C(0x0a6af28fa065e72a), UINT64_C(0x08b2f20fa05e25b4),
        UINT64_C(0x175af28f6899867e), UINT64_C(0x10d2f20c38774693)
    },
    {   UINT64_C(0x0000000000005904), UINT64_C(0x1f42f80ee4a9270e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa4ed4b3e70a), UINT64_C(0x1f42f7cf00b2c72a)
    },
    {   UINT64_C(0x000000000000804e), UINT64_C(0x10f2ef4fa08105b3), UINT64_C(0x131af10fa0894762),
        UINT64_C(0x08b2f2cfa05ea762), UINT64_C(0x131af10b4089467e)
    },
    {   UINT64_C(0x0000000000005906), UINT64_C(0x1f42fb0e50b3470a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb0e50b4e72b), UINT64_C(0x1f42fb0e9cb54735)
    },
    {   UINT64_C(0x0000000000008050), UINT64_C(0x0b92f2cfa06ac693), UINT64_C(0x131af08fa089267e),
        UINT64_C(0x08b2f2cfa05ee693), UINT64_C(0x1692f10f7496e762)
    },
    {   UINT64_C(0x0000000000005908), UINT64_C(0x1f42f8cf44ae46f7), UINT64_C(0x1f42f70e9cb7a70c),
        UINT64_C(0x1f42facf14b30704), UINT64_C(0x1f42f60e84b72702)
    },
    {   UINT64_C(0x0000000000005909), UINT64_C(0x1f42f80ef4b2a711), UINT64_C(0x1f42f5cf28b806f8),
        UINT64_C(0x1f42f38ed8abc703), UINT64_C(0x1f42f84e80af6729)
    },
    {   UINT64_C(0x000000000000590a), UINT64_C(0x1f42fb4ebcac06f8), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f5cf0cb5c715), UINT64_C(0x1f43080eb8ae8720)
    },
    {   UINT64_C(0x000000000000590b), UINT64_C(0x1f42f70f7cb786fc), UINT64_C(0x1f42fa8ef4b7e70d),
        UINT64_C(0x1f42f64e7cb7c6fc), UINT64_C(0x1f42f74f38af46f8)
    },
    {   UINT64_C(0x0000000000008055), UINT64_C(0x14daf24fa0910762), UINT64_C(0x0a6aef4fa068668e),
        UINT64_C(0x14daf24b4091067e), UINT64_C(0x0a6aef4b406865b4)
    },
    {   UINT64_C(0x000000000000590d), UINT64_C(0x1f42ff4e84b60730), UINT64_C(0x1f42f80f20b52708),
        UINT64_C(0x1f42f98eecb92727), UINT64_C(0x1f42fa4eccb5672f)
    },
    {   UINT64_C(0x0000000000008057), UINT64_C(0x1162f8cf687be75e), UINT64_C(0x0c2af80f786a668a),
        UINT64_C(0x1162f8cc447be68c), UINT64_C(0x0c2afacc446a05b3)
    },
    {   UINT64_C(0x0000000000008058), UINT64_C(0x1162f8cf687be784), UINT64_C(0x0c2af78f786a268a),
        UINT64_C(0x131af24c4488a67e), UINT64_C(0x08b2f14c4461662b)
    },
    {   UINT64_C(0x0000000000008059), UINT64_C(0x131af24fa088a75e), UINT64_C(0x09daf14f786826a5),
        UINT64_C(0x132af24fa088a67e), UINT64_C(0x08baf0cf8c618630)
    },
    {   UINT64_C(0x000000000000805a), UINT64_C(0x1692f18f6896a739), UINT64_C(0x0fa2f04f787a8666),
        UINT64_C(0x1692f18f6896a6ed), UINT64_C(0x0fa2f04f787a8619)
    },
    {   UINT64_C(0x0000000000005912), UINT64_C(0x1f42f78f94af470c), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f68f98b046fc), UINT64_C(0x1f42f38f14b4a6ff)
    },
    {   UINT64_C(0x0000000000005913), UINT64_C(0x0000000000000000), UINT64_C(0x1f42facf20a8e6e7),
        UINT64_C(0x1f42f90ebcb82705), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000805d), UINT64_C(0x1d82ef4f74b3075e), UINT64_C(0x1692f34f6895468a),
        UINT64_C(0x1692f38fa096675e), UINT64_C(0x0fa2f18c3879e68a)
    },
    {   UINT64_C(0x0000000000005915), UINT64_C(0x1f42f6ce6cb3672d), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005916), UINT64_C(0x1f42f58eeca9a727), UINT64_C(0x1f42f84f04b006fa),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0ee8b1a725)
    },
    {   UINT64_C(0x0000000000005917), UINT64_C(0x1f42f54edcaee708), UINT64_C(0x1f42f74eecb66702),
        UINT64_C(0x1f42f74ec8ac26fc), UINT64_C(0x1f42fa8ee8b24728)
    },
    {   UINT64_C(0x00000000000066d0), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc8f78b7071b),
        UINT64_C(0x1f42fb4f78ba2713), UINT64_C(0x1f42facfccb4e712)
    },
    {   UINT64_C(0x0000000000008062), UINT64_C(0x0fa2f44f787e6617), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000066d1), UINT64_C(0x1f430c4f84b94721), UINT64_C(0x1f42f98f04b36727),
        UINT64_C(0x1f42f98f70b546fe), UINT64_C(0x1f42f78ee8b16703)
    },
    {   UINT64_C(0x0000000000008064), UINT64_C(0x1222f64f8884c694), UINT64_C(0x0000000000000000),
        UINT64_C(0x0d92ef8d2473c6aa), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008065), UINT64_C(0x0000000000000000), UINT64_C(0x16faf04f78974693),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000591d), UINT64_C(0x1f42f74e84b44718), UINT64_C(0x1f42f8cf0cb52702),
        UINT64_C(0x1f42f90eb0b26719), UINT64_C(0x1f42f88e6cb8e72b)
    },
    {   UINT64_C(0x000000000000591e), UINT64_C(0x1f42fc4f64b5472c), UINT64_C(0x1f42fece88b56743),
        UINT64_C(0x1f42f6cf3cb14718), UINT64_C(0x1f42f74e70b50743)
    },
    {   UINT64_C(0x0000000000008068), UINT64_C(0x1692f68f689486da), UINT64_C(0x110af54f7880e5c2),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008069), UINT64_C(0x0000000000000000), UINT64_C(0x0fa2ef4c3c794685),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000806a), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0d82f30bfc720694), UINT64_C(0x0912f14c3861662b)
    },
    {   UINT64_C(0x0000000000005922), UINT64_C(0x1f42f60ef0b40710), UINT64_C(0x1f4311ce44b28733),
        UINT64_C(0x1f42f8cee4aec6f7), UINT64_C(0x1f42f8cef4ae66f7)
    },
    {   UINT64_C(0x000000000000806c), UINT64_C(0x0fa2f04f7881e619), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000066d6), UINT64_C(0x1f42f58e5cb0071e), UINT64_C(0x1f43148e24ae2734),
        UINT64_C(0x1f43088f4cb02739), UINT64_C(0x1f42f88f90b12700)
    },
    {   UINT64_C(0x000000000000806e), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0beaef0bf86b85aa), UINT64_C(0x0fa2f38fa07ac68c)
    },
    {   UINT64_C(0x000000000000806f), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0fa3004f7073e603), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008070), UINT64_C(0x0502fb8fa04ba6c8), UINT64_C(0x08c2fb8fa05aa6c8),
        UINT64_C(0x0d9af68fa07086c8), UINT64_C(0x0a6b0e8f7c5c068c)
    },
    {   UINT64_C(0x00000000000066d8), UINT64_C(0x1f4300cfa8b5e703), UINT64_C(0x1f43060f54b0e6fb),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005929), UINT64_C(0x1f42f90f20b9270c), UINT64_C(0x1f42f7cf28b7870f),
        UINT64_C(0x1f42f90ed0b4e6fc), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000066d9), UINT64_C(0x1f43008fc4b7a70e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43010ec8b426f2), UINT64_C(0x1f42ff4f40b6c6fa)
    },
    {   UINT64_C(0x000000000000592b), UINT64_C(0x1f42f4cf50b5c717), UINT64_C(0x1f42f6cee4ba0720),
        UINT64_C(0x1f42f4cef8b46710), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000066da), UINT64_C(0x1f4301cfb8b726ed), UINT64_C(0x1f42fccef8b426e8),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000592d), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f74eccb2c717),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f9cf8cae870b)
    },
    {   UINT64_C(0x00000000000066db), UINT64_C(0x1f42fe0f9cb806e1), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43100e48ab4744)
    },
    {   UINT64_C(0x000000000000592f), UINT64_C(0x1f42f5cf54aca70c), UINT64_C(0x1f42f60f2cb5a6dc),
        UINT64_C(0x1f42fa8f50b5a6ec), UINT64_C(0x1f42f74f20b6a710)
    },
    {   UINT64_C(0x00000000000066dc), UINT64_C(0x1f43030facb566ed), UINT64_C(0x1f4301cfccb3e6f5),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d2f), UINT64_C(0x0000000000000000), UINT64_C(0x1f430e8f38afa72e),
        UINT64_C(0x1f42f84e5cb8072a), UINT64_C(0x1f42fd4ec4b86729)
    },
    {   UINT64_C(0x00000000000066dd), UINT64_C(0x1f43035004b3072f), UINT64_C(0x1f43020f04b88707),
        UINT64_C(0x1f43010fa0b166fb), UINT64_C(0x1f42ffd008b70708)
    },
    {   UINT64_C(0x000000000000807c), UINT64_C(0x08b2dc8c3863468a), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005934), UINT64_C(0x1f42f4ceb0b7e717), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f98eb0b70721), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005935), UINT64_C(0x1f42f98f1cb0673e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f7ce28abc732), UINT64_C(0x1f42f4ce8cb506fc)
    },
    {   UINT64_C(0x0000000000005936), UINT64_C(0x1f42ff0e64ab8740), UINT64_C(0x1f42f58f04b60720),
        UINT64_C(0x1f42f64e88b7c734), UINT64_C(0x1f42f90e9cb4a724)
    },
    {   UINT64_C(0x0000000000005937), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f78f88b666ed), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005938), UINT64_C(0x1f42f4ce6cb80729), UINT64_C(0x1f42fecf20b3473c),
        UINT64_C(0x1f42f94e98b3470c), UINT64_C(0x1f42f68e44b18735)
    },
    {   UINT64_C(0x0000000000005939), UINT64_C(0x1f42f98ebcb1273c), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f78ed4b46735), UINT64_C(0x1f42f80e6cb66744)
    },
    {   UINT64_C(0x00000000000066e1), UINT64_C(0x0000000000000000), UINT64_C(0x1f42facffcb54719),
        UINT64_C(0x1f43118ebca84706), UINT64_C(0x1f42facf38b82719)
    },
    {   UINT64_C(0x000000000000593b), UINT64_C(0x1f42f34fa8b9470e), UINT64_C(0x1f42f8ce5cb54738),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90ed4b04731)
    },
    {   UINT64_C(0x000000000000593c), UINT64_C(0x1f42f5ce84b1c725), UINT64_C(0x1f42f58f0cafe703),
        UINT64_C(0x1f42f6ce6cb3e741), UINT64_C(0x1f42f6ce7cb28708)
    },
    {   UINT64_C(0x000000000000593d), UINT64_C(0x1f42f7cf40b34738), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb8e84b4c708), UINT64_C(0x1f42f9cf8cb2670a)
    },
    {   UINT64_C(0x000000000000593e), UINT64_C(0x1f42fc0f00b6a723), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f48f40b5a71b), UINT64_C(0x1f42f64f98b72703)
    },
    {   UINT64_C(0x0000000000008088), UINT64_C(0x0000000000000000), UINT64_C(0x14faf4cd48900693),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005940), UINT64_C(0x1f43010e6cb58730), UINT64_C(0x1f42f70e64b86738),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f98ef0b60720)
    },
    {   UINT64_C(0x0000000000005941), UINT64_C(0x1f42f54f50b14715), UINT64_C(0x1f4306cf10af2717),
        UINT64_C(0x1f42f80e60b04717), UINT64_C(0x1f42fa8f20b4a70b)
    },
    {   UINT64_C(0x0000000000005942), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f54e78afa6e0),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005943), UINT64_C(0x1f42f78ec0ad66df), UINT64_C(0x1f42f6cf10b80716),
        UINT64_C(0x1f42f7cee4b50724), UINT64_C(0x1f42f94f48b4e70c)
    },
    {   UINT64_C(0x000000000000808d), UINT64_C(0x0d6af2cd4871c693), UINT64_C(0x1502f20d489025b4),
        UINT64_C(0x0c8af14d486e462c), UINT64_C(0x08b2dc8c3856a5b4)
    },
    {   UINT64_C(0x0000000000005945), UINT64_C(0x1f42f58ea4ace6f4), UINT64_C(0x1f42f8cec4b4e712),
        UINT64_C(0x1f42f9cee4b5a6f5), UINT64_C(0x1f42fbcee8b0e721)
    },
    {   UINT64_C(0x00000000000066e7), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fecffcb22719), UINT64_C(0x1f42f9cfdcb58720)
    },
    {   UINT64_C(0x0000000000005947), UINT64_C(0x1f42fb0ea8aa6720), UINT64_C(0x1f42f84e8cb46723),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005948), UINT64_C(0x1f42f8ce88b5472e), UINT64_C(0x1f42f84f58b66703),
        UINT64_C(0x1f42f58eb4b1c719), UINT64_C(0x1f43058e50ada735)
    },
    {   UINT64_C(0x0000000000005949), UINT64_C(0x1f42f74e8cb6c712), UINT64_C(0x1f42f90e98b4c726),
        UINT64_C(0x1f42f78ec0b3070b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000066e9), UINT64_C(0x1f43190eb8a76703), UINT64_C(0x1f42fecf0cb7e6e5),
        UINT64_C(0x1f42fecf24b1a6f1), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008094), UINT64_C(0x0de2f00f787225b4), UINT64_C(0x0fa2f4cf787be5b4),
        UINT64_C(0x0fa2f4cf787be5b4), UINT64_C(0x0fa2ff4f78790693)
    },
    {   UINT64_C(0x0000000000008095), UINT64_C(0x0de2f08f747025b3), UINT64_C(0x0de2f44d2072a5b4),
        UINT64_C(0x114af4cbfc896693), UINT64_C(0x125af4cf7889c693)
    },
    {   UINT64_C(0x0000000000008096), UINT64_C(0x0de2f30f7872e5b4), UINT64_C(0x0de2f18f787225b4),
        UINT64_C(0x148af70f6c8fe5b4), UINT64_C(0x0db2f30f686f25c3)
    },
    {   UINT64_C(0x0000000000008097), UINT64_C(0x0db2f30f686f25c3), UINT64_C(0x137af30f6889e5c3),
        UINT64_C(0x0efaf30f687445c3), UINT64_C(0x09dae1cc386385b4)
    },
    {   UINT64_C(0x000000000000594f), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbd000b5a6dd),
        UINT64_C(0x1f42fc4fc8b7e718), UINT64_C(0x1f42fbcfe0b8a71e)
    },
    {   UINT64_C(0x0000000000008099), UINT64_C(0x0fa2f14f787b45aa), UINT64_C(0x0fa2f14bfc7be5aa),
        UINT64_C(0x0fa2f04fa07b6693), UINT64_C(0x0f0af04bfc73e693)
    },
    {   UINT64_C(0x000000000000809a), UINT64_C(0x08b2f20fa05e2693), UINT64_C(0x0a6af24f786565ae),
        UINT64_C(0x0812f34fa05b65aa), UINT64_C(0x0af2f08fa0690693)
    },
    {   UINT64_C(0x0000000000005952), UINT64_C(0x1f43058fecb786fd), UINT64_C(0x1f42fa0edcb7870c),
        UINT64_C(0x1f42f74f3cb6e71c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000809c), UINT64_C(0x191af0cbfca0a5aa), UINT64_C(0x1852f20bfc96c5b4),
        UINT64_C(0x108adc8bfc7ec5b4), UINT64_C(0x10aaf20bfc89e5b4)
    },
    {   UINT64_C(0x000000000000809d), UINT64_C(0x12d2f54f8084a5aa), UINT64_C(0x0fa2f54f787945b4),
        UINT64_C(0x1682f3cf8895a5aa), UINT64_C(0x14daf74f908d25c3)
    },
    {   UINT64_C(0x000000000000809e), UINT64_C(0x14daf80bfc8cc693), UINT64_C(0x0b92f58f786b85aa),
        UINT64_C(0x0b92f58f786c0693), UINT64_C(0x0d12f58bfc7905aa)
    },
    {   UINT64_C(0x000000000000809f), UINT64_C(0x0a6aef4bfc6865b4), UINT64_C(0x0b92efcbfc68e5b4),
        UINT64_C(0x09daf08fa068a5be), UINT64_C(0x0af2ef4fa06805be)
    },
    {   UINT64_C(0x00000000000080a0), UINT64_C(0x0edaf34fa07945b8), UINT64_C(0x0edaf34fa07945b8),
        UINT64_C(0x0c2afa8c386a05b2), UINT64_C(0x0a12dc8bfc6d0693)
    },
    {   UINT64_C(0x00000000000080a1), UINT64_C(0x0982dc8c386d0693), UINT64_C(0x0c82f1cbfc77a5be),
        UINT64_C(0x0daae84bd4734693), UINT64_C(0x08b2f20d9c61c5b4)
    },
    {   UINT64_C(0x0000000000005959), UINT64_C(0x1f42f9cf5cb746f6), UINT64_C(0x1f43030fa0b4a6f6),
        UINT64_C(0x1f43024f1cb8872a), UINT64_C(0x1f42facf54b4a703)
    },
    {   UINT64_C(0x00000000000080a3), UINT64_C(0x0fa2ed0fa07745b8), UINT64_C(0x1692f34fa09545b8),
        UINT64_C(0x0de2ed8fa077e684), UINT64_C(0x125af3cfa08505b8)
    },
    {   UINT64_C(0x00000000000080a4), UINT64_C(0x1082f4cc3885a5aa), UINT64_C(0x0fdaf4cd487b65aa),
        UINT64_C(0x0ceaf10bfc6f85aa), UINT64_C(0x0d7af10adc71c5aa)
    },
    {   UINT64_C(0x00000000000066f2), UINT64_C(0x1f42f90ed8b66729), UINT64_C(0x1f43070ffcb5270e),
        UINT64_C(0x1f4317ce7ca90727), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000080a6), UINT64_C(0x169af64f5c94c68f), UINT64_C(0x0e62f1cfa07605b8),
        UINT64_C(0x0efaf30f687445c3), UINT64_C(0x12c2f54f748765f3)
    },
    {   UINT64_C(0x000000000000595e), UINT64_C(0x1f42ff8efcb6a72c), UINT64_C(0x1f42ff0f38b72722),
        UINT64_C(0x1f43068fc8b526f2), UINT64_C(0x1f43110e78acc745)
    },
    {   UINT64_C(0x00000000000080a8), UINT64_C(0x12c2f40c3c88462e), UINT64_C(0x0e12fa0fa070a693),
        UINT64_C(0x0e12fa0fa070a693), UINT64_C(0x1912f4cf789f6693)
    },
    {   UINT64_C(0x0000000000005960), UINT64_C(0x1f4304ced4b6a6da), UINT64_C(0x1f42fc4ef8b4a6fc),
        UINT64_C(0x1f4302cfb0b8071b), UINT64_C(0x1f43170ec0b42713)
    },
    {   UINT64_C(0x00000000000080aa), UINT64_C(0x1452f14f788ea62b), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005962), UINT64_C(0x1f430a0e8cad872d), UINT64_C(0x1f430acef8ad272d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4315cf14b2a735)
    },
    {   UINT64_C(0x00000000000080ac), UINT64_C(0x0bd2efd4e06c2738), UINT64_C(0x0bd2efd4e06c2738),
        UINT64_C(0x0962f912445d073c), UINT64_C(0x07e2ef54e05e0691)
    },
    {   UINT64_C(0x0000000000005964), UINT64_C(0x1f43160e7cb10735), UINT64_C(0x1f430250c0b646eb),
        UINT64_C(0x1f4301cf24b3e729), UINT64_C(0x1f43024f78ab06e2)
    },
    {   UINT64_C(0x00000000000080ae), UINT64_C(0x0b92f192606ba690), UINT64_C(0x06830496345ea694),
        UINT64_C(0x098af2d634670694), UINT64_C(0x0a6b01d68c59c696)
    },
    {   UINT64_C(0x00000000000080af), UINT64_C(0x0a6b01d68c59c696), UINT64_C(0x0a6b01d68c59c696),
        UINT64_C(0x0632f6d73452e690), UINT64_C(0x0632f6d73452e690)
    },
    {   UINT64_C(0x00000000000080b0), UINT64_C(0x0a32f3d43c64669a), UINT64_C(0x0a32f3d43c64669a),
        UINT64_C(0x09eaf6562c6226db), UINT64_C(0x09eaf6562c6226db)
    },
    {   UINT64_C(0x00000000000080b1), UINT64_C(0x09eaebd6d46766b1), UINT64_C(0x09eaebd6d46766b1),
        UINT64_C(0x0a6af0d78c66c68a), UINT64_C(0x0a6af0d78c66c68a)
    },
    {   UINT64_C(0x00000000000080b2), UINT64_C(0x08b30bd6a05266b1), UINT64_C(0x0a72f0d82c66c641),
        UINT64_C(0x0a6b05579466868f), UINT64_C(0x0a6af397945da68f)
    },
    {   UINT64_C(0x00000000000080b3), UINT64_C(0x08b30bcc9452642e), UINT64_C(0x0a72f0cd2466e380),
        UINT64_C(0x0a6af44ca05da3d3), UINT64_C(0x0a6b030ca06503d3)
    },
    {   UINT64_C(0x00000000000080b4), UINT64_C(0x0a6b044fec5d05b4), UINT64_C(0x0a6b04544c5d05b4),
        UINT64_C(0x0a6b0010cc5f4555), UINT64_C(0x0a6affd0cc5f2555)
    },
    {   UINT64_C(0x00000000000080b5), UINT64_C(0x0a6afacfe861a4b5), UINT64_C(0x0a6afacfe861a4b5),
        UINT64_C(0x0a6affd0085f64c2), UINT64_C(0x0a6affd1305f6478)
    },
    {   UINT64_C(0x00000000000080b6), UINT64_C(0x0a7af4d78c650680), UINT64_C(0x0a6b0b97cc59a656),
        UINT64_C(0x0a6afed7a05fc6af), UINT64_C(0x0a6afe0d0c5da3e8)
    },
    {   UINT64_C(0x00000000000080b7), UINT64_C(0x0a6aee57f067e666), UINT64_C(0x0a6aed578c6d868e),
        UINT64_C(0x0952ee12885f65a3), UINT64_C(0x0a6afa164462067e)
    },
    {   UINT64_C(0x00000000000080b8), UINT64_C(0x0bd2f4130c686694), UINT64_C(0x06baf2d4e0572738),
        UINT64_C(0x091af714cc5f2691), UINT64_C(0x0be2ef54e06d0690)
    },
    {   UINT64_C(0x00000000000080b9), UINT64_C(0x0aaaf954e066673a), UINT64_C(0x0ceafa0fa06d267e),
        UINT64_C(0x0caaf80fa06c267e), UINT64_C(0x0caaf80fa06c267e)
    },
    {   UINT64_C(0x00000000000080ba), UINT64_C(0x0caaf80fa06c267e), UINT64_C(0x0caaf80fa06c267e),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000080bb), UINT64_C(0x0a6af34d5465642e), UINT64_C(0x0caaf0978c6fe681),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005973), UINT64_C(0x1f42f60fa4b64717), UINT64_C(0x1f43008ea4b4e707),
        UINT64_C(0x1f42f70ee4b3071d), UINT64_C(0x1f42facf80b6470b)
    },
    {   UINT64_C(0x00000000000080bd), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0a6aee4c3467e377)
    },
    {   UINT64_C(0x0000000000005975), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f80e68b3670d), UINT64_C(0x1f42f98f10b2c71d)
    },
    {   UINT64_C(0x00000000000066ff), UINT64_C(0x0000000000000000), UINT64_C(0x1f43014eacb4071c),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000080c0), UINT64_C(0x000291578c2c268e), UINT64_C(0x000291578c2c268e),
        UINT64_C(0x00028d978c35268a), UINT64_C(0x00028b57f0366666)
    },
    {   UINT64_C(0x0000000000005978), UINT64_C(0x1f430dcfa0b006c5), UINT64_C(0x1f430e4fb4b466e7),
        UINT64_C(0x1f430f8fd0b7a6d2), UINT64_C(0x1f43010f9cb226f7)
    },
    {   UINT64_C(0x00000000000080c2), UINT64_C(0x00028f57cc346656), UINT64_C(0x0002a157502fc6d7),
        UINT64_C(0x00029bd7a02e46af), UINT64_C(0x000289d78c3bc68e)
    },
    {   UINT64_C(0x00000000000080c3), UINT64_C(0x00028dd78c35468a), UINT64_C(0x0002af97702626a4),
        UINT64_C(0x00029c97702de6a4), UINT64_C(0x000289d78c3bc68e)
    },
    {   UINT64_C(0x00000000000080c4), UINT64_C(0x000290d78c3306e7), UINT64_C(0x000290d78c330680),
        UINT64_C(0x0002a357782a86d1), UINT64_C(0x0002a357782a86d1)
    },
    {   UINT64_C(0x00000000000080c5), UINT64_C(0x0002a357782a86d1), UINT64_C(0x0002d8d7784546d1),
        UINT64_C(0x0002964c202ea3b3), UINT64_C(0x0002914c202c23b3)
    },
    {   UINT64_C(0x00000000000080c6), UINT64_C(0x00028acb342443b3), UINT64_C(0x0002ab4b343483b3),
        UINT64_C(0x00028f17ec3486c7), UINT64_C(0x0002e3150444e5c2)
    },
    {   UINT64_C(0x000000000000597e), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430fd078b246aa), UINT64_C(0x1f43180f0cac66ed)
    },
    {   UINT64_C(0x00000000000080c8), UINT64_C(0x00029c8d002dc36c), UINT64_C(0x0002b34b243ea433),
        UINT64_C(0x0002e08b24554433), UINT64_C(0x0002a80c3c27e372)
    },
    {   UINT64_C(0x00000000000080c9), UINT64_C(0x00028f4c38346371), UINT64_C(0x00029bcb702e43a3),
        UINT64_C(0x0002a34a1c2a837a), UINT64_C(0x00029a8c442ee3e8)
    },
    {   UINT64_C(0x00000000000080ca), UINT64_C(0x00029d8d0c2d63e8), UINT64_C(0x0002af8bf8244382),
        UINT64_C(0x00028dcbf4356386), UINT64_C(0x00028f0c1435237a)
    },
    {   UINT64_C(0x00000000000080cb), UINT64_C(0x00028dcbe035439f), UINT64_C(0x00028dcbe035439f),
        UINT64_C(0x0002918c1c3363a4), UINT64_C(0x0002918c403363ad)
    },
    {   UINT64_C(0x00000000000080cc), UINT64_C(0x00028b4c34366377), UINT64_C(0x00028dcc9435435b),
        UINT64_C(0x0002760ca441035b), UINT64_C(0x0002760af041035b)
    },
    {   UINT64_C(0x00000000000080cd), UINT64_C(0x000289d2f835a528), UINT64_C(0x00028e133834c4fa),
        UINT64_C(0x00027613384104fa), UINT64_C(0x00028f0e7839662c)
    },
    {   UINT64_C(0x00000000000080ce), UINT64_C(0x00028f0d3042667e), UINT64_C(0x0002a80b782b83a1),
        UINT64_C(0x00028dcca83563b3), UINT64_C(0x00029fcc142c23b3)
    },
    {   UINT64_C(0x00000000000080cf), UINT64_C(0x00028f0cac34a3a7), UINT64_C(0x00029c97d42da6b3),
        UINT64_C(0x0002a7576c286725), UINT64_C(0x0002761ba8410788)
    },
    {   UINT64_C(0x0000000000005987), UINT64_C(0x1f43140ec0ab26ef), UINT64_C(0x1f430e4e64b226f8),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43074f24b226fb)
    },
    {   UINT64_C(0x00000000000080d1), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0002969808360691), UINT64_C(0x000af0cb1066e35c)
    },
    {   UINT64_C(0x0000000000005989), UINT64_C(0x1f43078ed0b726fd), UINT64_C(0x1f42ff8ed0b5c72e),
        UINT64_C(0x1f430c8ef8b7a6f7), UINT64_C(0x1f4309ce8cb84726)
    },
    {   UINT64_C(0x00000000000080d3), UINT64_C(0x00028d97f03786f1), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000598b), UINT64_C(0x0000000000000000), UINT64_C(0x1f430ed024ab46ca),
        UINT64_C(0x1f430acf34a8e706), UINT64_C(0x1f4303cf50b56725)
    },
    {   UINT64_C(0x000000000000670a), UINT64_C(0x1f43014f34aa46ff), UINT64_C(0x1f43008fa0af8726),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe8f2cb7a72c)
    },
    {   UINT64_C(0x00000000000080d6), UINT64_C(0x0000000000000000), UINT64_C(0x000294c9e433a3a7),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000080d7), UINT64_C(0x000290cbfc63639c), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000080d8), UINT64_C(0x00028b57b46c2661), UINT64_C(0x000290d78c636680),
        UINT64_C(0x00028b4b686ae3a7), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005990), UINT64_C(0x0000000000000000), UINT64_C(0x1f43090ef0b2c70e),
        UINT64_C(0x1f430e4ec0b4873d), UINT64_C(0x1f4300cf18b4a700)
    },
    {   UINT64_C(0x0000000000005991), UINT64_C(0x1f43041008b0a6fe), UINT64_C(0x1f430ad030afe6b9),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fdce68b7c730)
    },
    {   UINT64_C(0x0000000000005992), UINT64_C(0x0000000000000000), UINT64_C(0x1f43038efcb16724),
        UINT64_C(0x1f4305cfb4b2e6db), UINT64_C(0x1f43038efcb16708)
    },
    {   UINT64_C(0x000000000000400e), UINT64_C(0x0fa2f810a0780698), UINT64_C(0x0fa2f8d0a0770698),
        UINT64_C(0x0fa31e11ac684608), UINT64_C(0x0fa3179038686608)
    },
    {   UINT64_C(0x000000000000670e), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff5000b8072c),
        UINT64_C(0x1f42f5ce90b7871e), UINT64_C(0x1f42ffcf20b7e70c)
    },
    {   UINT64_C(0x0000000000005995), UINT64_C(0x1f430c8f08ae06ef), UINT64_C(0x1f43154e5caa871b),
        UINT64_C(0x1f430c8f48ae06f1), UINT64_C(0x1f430bcf58b82702)
    },
    {   UINT64_C(0x0000000000005996), UINT64_C(0x0000000000000000), UINT64_C(0x1f43084ef0b40714),
        UINT64_C(0x1f43074f44b7672c), UINT64_C(0x1f430fcf74b0a6df)
    },
    {   UINT64_C(0x0000000000005997), UINT64_C(0x1f43154e6ca9e725), UINT64_C(0x1f430e4f00b0c734),
        UINT64_C(0x1f43010e2cb16731), UINT64_C(0x1f42fe4ea8ae0737)
    },
    {   UINT64_C(0x0000000000006710), UINT64_C(0x1f431c8eccac0701), UINT64_C(0x1f42fecf78b72706),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005999), UINT64_C(0x1f43084fa8b4c6f6), UINT64_C(0x1f430bcfc0b1870a),
        UINT64_C(0x1f430bcf08b8872a), UINT64_C(0x1f42fc8eecb4470d)
    },
    {   UINT64_C(0x00000000000080e3), UINT64_C(0x1692f00f68948693), UINT64_C(0x0000000000000000),
        UINT64_C(0x1a42f00fa0a4c693), UINT64_C(0x1742f00fa097e693)
    },
    {   UINT64_C(0x000000000000599b), UINT64_C(0x1f430a4e7cade711), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fcce34b4e745), UINT64_C(0x1f43078e88b0e71e)
    },
    {   UINT64_C(0x000000000000599c), UINT64_C(0x1f43030e6cb48733), UINT64_C(0x1f43084f10b16723),
        UINT64_C(0x1f43064fb8b7c718), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000599d), UINT64_C(0x1f43074e6cb46738), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430f0f54aa6718), UINT64_C(0x1f42fe0e80b7e71f)
    },
    {   UINT64_C(0x000000000000599e), UINT64_C(0x1f43070eb0b666f9), UINT64_C(0x1f430a4ef8ace6eb),
        UINT64_C(0x1f42fd8ea0aca734), UINT64_C(0x1f43074f2cb3c720)
    },
    {   UINT64_C(0x00000000000080e8), UINT64_C(0x1692f28fa096667e), UINT64_C(0x116af20fa082467e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1382f58fa089867e)
    },
    {   UINT64_C(0x00000000000059a0), UINT64_C(0x1f43074fe0b066e1), UINT64_C(0x1f42fccf2cb42708),
        UINT64_C(0x1f430b8ed0aca72c), UINT64_C(0x1f4313ce8ca8a70e)
    },
    {   UINT64_C(0x00000000000080ea), UINT64_C(0x1752f38fa099069a), UINT64_C(0x1742f54fa097e68c),
        UINT64_C(0x0a6af28fa0660751), UINT64_C(0x1692f54fa0966751)
    },
    {   UINT64_C(0x00000000000080eb), UINT64_C(0x10faf54f7880a67e), UINT64_C(0x0dbaf44f7871667e),
        UINT64_C(0x1002f08c3c77067e), UINT64_C(0x089af30f785fe67e)
    },
    {   UINT64_C(0x00000000000080ec), UINT64_C(0x1062f20f787c467e), UINT64_C(0x10faf54f7880a5b4),
        UINT64_C(0x0f82fbcc3c78c693), UINT64_C(0x0ed2f08c387605b1)
    },
    {   UINT64_C(0x00000000000059a4), UINT64_C(0x1f43090ed8ad8725), UINT64_C(0x1f43024e80b40726),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000059a5), UINT64_C(0x1f43014f00b306fa), UINT64_C(0x1f43020e5cb8271e),
        UINT64_C(0x1f430a4f28b66726), UINT64_C(0x1f4308cee0b54725)
    },
    {   UINT64_C(0x00000000000059a6), UINT64_C(0x1f43064e78b1a6e5), UINT64_C(0x1f43030f40b72719),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000080f0), UINT64_C(0x0faaf04f687ac5aa), UINT64_C(0x0f82fbcc3c78c5b4),
        UINT64_C(0x0dcaf6cc387485b4), UINT64_C(0x1122f54f787f45aa)
    },
    {   UINT64_C(0x00000000000059a8), UINT64_C(0x1f431f0e8ca88725), UINT64_C(0x1f4303cec0b46738),
        UINT64_C(0x1f43020f60b4671e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000059a9), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff0e50b30715), UINT64_C(0x1f43064ef8b44717)
    },
    {   UINT64_C(0x00000000000059aa), UINT64_C(0x1f43194f0cb5070b), UINT64_C(0x1f4302ced0b846ea),
        UINT64_C(0x1f43004f18af871f), UINT64_C(0x1f42fcce84b1e745)
    },
    {   UINT64_C(0x00000000000080f4), UINT64_C(0x0e12fb8f7871e69d), UINT64_C(0x1152ee0f78828693),
        UINT64_C(0x1692f54fa095c68c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000059ac), UINT64_C(0x1f43014f84b806dd), UINT64_C(0x1f43060f08b146f5),
        UINT64_C(0x1f4304ce20ae8735), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000080f6), UINT64_C(0x1692f68c3c94868c), UINT64_C(0x0fa2f54c3c7945b4),
        UINT64_C(0x14daf50c388c468c), UINT64_C(0x0e6af6cc387505d2)
    },
    {   UINT64_C(0x0000000000000b1c), UINT64_C(0x106af54c107c6658), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000080f8), UINT64_C(0x190af0cc389e668c), UINT64_C(0x1082ec8c407b6625),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000059b0), UINT64_C(0x1f42ff0edcb2271e), UINT64_C(0x1f4306cf0caf4730),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000059b1), UINT64_C(0x1f43010e2cb06729), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f78e50b24715), UINT64_C(0x1f4311ce84ac2717)
    },
    {   UINT64_C(0x000000000001511a), UINT64_C(0x17baf7cfa0990695), UINT64_C(0x16b2f88fa097e685),
        UINT64_C(0x15eafbcf709ba695), UINT64_C(0x1992f88fa0a14685)
    },
    {   UINT64_C(0x000000000000401e), UINT64_C(0x0fa2f510c87985cc), UINT64_C(0x0fa2f90ebc7785cc),
        UINT64_C(0x0fa300d0c873a5cc), UINT64_C(0x0fa305ce94710721)
    },
    {   UINT64_C(0x000000000001511b), UINT64_C(0x16e2f88fa09cc685), UINT64_C(0x13daf90fa09c4685),
        UINT64_C(0x1802fbcf709e8695), UINT64_C(0x1bdaf88fa0b4c685)
    },
    {   UINT64_C(0x00000000000059b5), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff4ee4b2e714), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000671f), UINT64_C(0x1f43028fe4af8732), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43059020b62700)
    },
    {   UINT64_C(0x00000000000059b7), UINT64_C(0x1f43084ec8b0c720), UINT64_C(0x1f4301ce64b7c731),
        UINT64_C(0x1f43008ec8ae26e3), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008101), UINT64_C(0x145af78f688c268c), UINT64_C(0x1162fd8f687e468c),
        UINT64_C(0x0a6af28fa065e67e), UINT64_C(0x0a6af44fa066e750)
    },
    {   UINT64_C(0x0000000000008102), UINT64_C(0x0baaec8f686ac67e), UINT64_C(0x1ee2f08f68b5c67e),
        UINT64_C(0x1fcaf2cfa0b9667e), UINT64_C(0x191af28fa0a0c67e)
    },
    {   UINT64_C(0x0000000000019402), UINT64_C(0x1b4af8d010a6261d), UINT64_C(0x0aa2f9501063861d),
        UINT64_C(0x12eaf9101084a61d), UINT64_C(0x1b4af8d010a6261d)
    },
    {   UINT64_C(0x0000000000019403), UINT64_C(0x239af8d010c7861d), UINT64_C(0x121af9cf7882e693),
        UINT64_C(0x1672fa8fa092067e), UINT64_C(0x0cfafbd0847265a9)
    },
    {   UINT64_C(0x0000000000006722), UINT64_C(0x1f43030f34ab6717), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43048f94b3271b)
    },
    {   UINT64_C(0x0000000000008106), UINT64_C(0x169af2cfa096867e), UINT64_C(0x169af2cfa096877b),
        UINT64_C(0x1592f2cfa094468c), UINT64_C(0x155af04f6891867e)
    },
    {   UINT64_C(0x0000000000008107), UINT64_C(0x1beaf2cfa0ab667e), UINT64_C(0x16b2f2cfa096867e),
        UINT64_C(0x16caf70f6894c68c), UINT64_C(0x16a2f2cfa096a67e)
    },
    {   UINT64_C(0x0000000000008108), UINT64_C(0x11daf2cfa081667e), UINT64_C(0x152af70f688ea68c),
        UINT64_C(0x1352f58fa088867e), UINT64_C(0x163af1cf6495467e)
    },
    {   UINT64_C(0x0000000000006724), UINT64_C(0x1f43048fd8ad071b), UINT64_C(0x1f43075018b2671b),
        UINT64_C(0x1f43074fd8ae871b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000810a), UINT64_C(0x1f12f54fa0b7267e), UINT64_C(0x1f12f54d3cb7267e),
        UINT64_C(0x170af14fa096667e), UINT64_C(0x1ba2f2cfa0aaa67e)
    },
    {   UINT64_C(0x000000000001940a), UINT64_C(0x1362f08f248ac642), UINT64_C(0x1362f08f248ac642),
        UINT64_C(0x156afa11f08e2552), UINT64_C(0x21f2fbd1a8bf6540)
    },
    {   UINT64_C(0x000000000001940b), UINT64_C(0x1042ee104c87c5b5), UINT64_C(0x156afa10608e25b6),
        UINT64_C(0x156afa0f148e25f9), UINT64_C(0x156afa0dcc8e2646)
    },
    {   UINT64_C(0x000000000001940c), UINT64_C(0x156afa10048e25c3), UINT64_C(0x156afa0edc8e260d),
        UINT64_C(0x156afa0e588e2632), UINT64_C(0x156afa0d308e267e)
    },
    {   UINT64_C(0x000000000001940d), UINT64_C(0x156afa0d308e267e), UINT64_C(0x156afc0b548c26b6),
        UINT64_C(0x156afc0b548c26b6), UINT64_C(0x156afa0e988e2624)
    },
    {   UINT64_C(0x000000000001940e), UINT64_C(0x156af9cd308b067e), UINT64_C(0x156b004d308e467e),
        UINT64_C(0x156afc0cac8c269f), UINT64_C(0x156afe0cac8d269f)
    },
    {   UINT64_C(0x000000000001940f), UINT64_C(0x156af08e048d8689), UINT64_C(0x156afc8d608c8689),
        UINT64_C(0x156afa0c148e26c2), UINT64_C(0x156afa0c148fc6c2)
    },
    {   UINT64_C(0x00000000000059c8), UINT64_C(0x1f42fa0f28b82715), UINT64_C(0x1f42f94f00b3e702),
        UINT64_C(0x1f43144f0caee704), UINT64_C(0x1f42f80efcb6c715)
    },
    {   UINT64_C(0x00000000000059c9), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f80ed0b6c748), UINT64_C(0x1f42f90f58b86715)
    },
    {   UINT64_C(0x0000000000019412), UINT64_C(0x156afacc0c8b8647), UINT64_C(0x156aff4c0c8dc647),
        UINT64_C(0x1362f08f248ac600), UINT64_C(0x1362f08f248ac600)
    },
    {   UINT64_C(0x000000000000402a), UINT64_C(0x0fa309572c6f6630), UINT64_C(0x0fa2f093587bc6b7),
        UINT64_C(0x0fa30653a470e671), UINT64_C(0x0fa2f190787b45de)
    },
    {   UINT64_C(0x0000000000019414), UINT64_C(0x156afd0b888ca6e8), UINT64_C(0x156afd0c508ca70b),
        UINT64_C(0x156afd0c508ca70b), UINT64_C(0x156afb8cac8ae69f)
    },
    {   UINT64_C(0x0000000000019415), UINT64_C(0x156b008cac8d669f), UINT64_C(0x156afa11808e256a),
        UINT64_C(0x156afa11808e256a), UINT64_C(0x0fa2fa0dc47723fe)
    },
    {   UINT64_C(0x0000000000019416), UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x0e7afacd9c71e661),
        UINT64_C(0x0e7afacd9c71e661), UINT64_C(0x156afa4d088ce66f)
    },
    {   UINT64_C(0x00000000000059cf), UINT64_C(0x1f42ffcedcb44708), UINT64_C(0x1f42f8cf2caca723),
        UINT64_C(0x1f42fd8eb4b32710), UINT64_C(0x1f43074ef8b5a72e)
    },
    {   UINT64_C(0x0000000000019418), UINT64_C(0x156b008a9c8e66b6), UINT64_C(0x0ca2f3cf546e25ab),
        UINT64_C(0x2503bd4f3cae664a), UINT64_C(0x2503bd5044d5e683)
    },
    {   UINT64_C(0x00000000000059d1), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8ee4b1a6fb),
        UINT64_C(0x1f42fe8e7cb32716), UINT64_C(0x1f42fd8ee8b0c712)
    },
    {   UINT64_C(0x00000000000059d2), UINT64_C(0x1f42f7cf08b50714), UINT64_C(0x1f42fcce84aac72b),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbcef8b9e710)
    },
    {   UINT64_C(0x00000000000059d3), UINT64_C(0x1f42f50f38b7871f), UINT64_C(0x1f42fdcf0cb4e700),
        UINT64_C(0x1f43048e54b3a728), UINT64_C(0x1f43054efcb6471f)
    },
    {   UINT64_C(0x000000000001941c), UINT64_C(0x156afa0de88e4647), UINT64_C(0x156afa0cac8e269f),
        UINT64_C(0x156afa0bf08e26bc), UINT64_C(0x156af9cd308b067e)
    },
    {   UINT64_C(0x00000000000059d5), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f9cf08b4c714),
        UINT64_C(0x1f42f60f38b4470c), UINT64_C(0x1f430c8e58b18727)
    },
    {   UINT64_C(0x000000000001941e), UINT64_C(0x26c2fc0d30d4267e), UINT64_C(0x156af3cd3091467e),
        UINT64_C(0x0f32fe0e18734642), UINT64_C(0x156afa0d308e267e)
    },
    {   UINT64_C(0x00000000000059d7), UINT64_C(0x1f42f98f18b4c724), UINT64_C(0x1f42f70f18b6e71b),
        UINT64_C(0x1f42facf38b3c72f), UINT64_C(0x1f43078e8cb6a72b)
    },
    {   UINT64_C(0x0000000000019420), UINT64_C(0x156afd0d308ca67e), UINT64_C(0x0f32fe0e18734642),
        UINT64_C(0x156afa11108e2587), UINT64_C(0x0f02fe1664704777)
    },
    {   UINT64_C(0x0000000000019421), UINT64_C(0x0dcafc56446ee6db), UINT64_C(0x156afd0ac48ca71a),
        UINT64_C(0x156afd0ac48ca71a), UINT64_C(0x156afd0ac48ca71a)
    },
    {   UINT64_C(0x0000000000019422), UINT64_C(0x156afd0ac48ca71a), UINT64_C(0x156afd0bd88ca6d1),
        UINT64_C(0x156afd0a4c8ca735), UINT64_C(0x156afa0f548e25fe)
    },
    {   UINT64_C(0x00000000000059db), UINT64_C(0x1f42f98f38b666f8), UINT64_C(0x1f42f88f38b62733),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42facf58b20723)
    },
    {   UINT64_C(0x00000000000059dc), UINT64_C(0x1f430a4f48b12722), UINT64_C(0x1f4308ce5cb5473e),
        UINT64_C(0x1f430f4ef4b426f5), UINT64_C(0x1f430b4ea4b4c736)
    },
    {   UINT64_C(0x0000000000019425), UINT64_C(0x13c2f08f748c85b3), UINT64_C(0x1382f54f7088e5b3),
        UINT64_C(0x156afa0c208e26c2), UINT64_C(0x156afa0c208e26c2)
    },
    {   UINT64_C(0x0000000000019426), UINT64_C(0x156afa10188e2619), UINT64_C(0x156afa0f548e25fe),
        UINT64_C(0x0e22f20f787505b3), UINT64_C(0x000305d82c7146a2)
    },
    {   UINT64_C(0x0000000000019427), UINT64_C(0x000af0cb1066e35c), UINT64_C(0x0002f0c98866c35b),
        UINT64_C(0x0002f0c80866c35b), UINT64_C(0x00030597907b26c6)
    },
    {   UINT64_C(0x0000000000019428), UINT64_C(0x000305d82c73a6f1), UINT64_C(0x0002ee49d467e35b),
        UINT64_C(0x000307582c7206ea), UINT64_C(0x0002ee49d467e35b)
    },
    {   UINT64_C(0x0000000000004035), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f431a907ca5a6b2)
    },
    {   UINT64_C(0x00000000000059e2), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f98f68b3c71f),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cf78b2271a)
    },
    {   UINT64_C(0x000000000001942b), UINT64_C(0x156afa0dc48e265a), UINT64_C(0x156afa0bf08e26bd),
        UINT64_C(0x156afa0bb08e26de), UINT64_C(0x156afa0bb08e26de)
    },
    {   UINT64_C(0x000000000001942c), UINT64_C(0x156afc0c148c26c4), UINT64_C(0x156afc0c148c26c4),
        UINT64_C(0x156afc4ac48c471a), UINT64_C(0x156afc4ac48c471a)
    },
    {   UINT64_C(0x000000000001942d), UINT64_C(0x156afc0c0c8c26c2), UINT64_C(0x156afc0c0c8c26c2),
        UINT64_C(0x156afc0c7c8c26ad), UINT64_C(0x156afc0c7c8c26ad)
    },
    {   UINT64_C(0x000000000001942e), UINT64_C(0x156afc0ac48c271a), UINT64_C(0x156afbcac48c271a),
        UINT64_C(0x156afc0ac48c271a), UINT64_C(0x156afbcac48c071a)
    },
    {   UINT64_C(0x000000000001942f), UINT64_C(0x156afd8b008ce6b7), UINT64_C(0x156afd4b008cc6b7),
        UINT64_C(0x156afd8be08ce6b7), UINT64_C(0x156afd4be08cc6b7)
    },
    {   UINT64_C(0x0000000000019430), UINT64_C(0x156afbcac48c071a), UINT64_C(0x156afe4ac48d471a),
        UINT64_C(0x156af3ccac91469a), UINT64_C(0x1322f44cc487e61f)
    },
    {   UINT64_C(0x0000000000019431), UINT64_C(0x1622f28c4c94c6b7), UINT64_C(0x1622f28c4c94c6b7),
        UINT64_C(0x1c32ee0d30aa667e), UINT64_C(0x1c32ee0d30aa667e)
    },
    {   UINT64_C(0x0000000000015136), UINT64_C(0x1f2af9cf4cb8a6a3), UINT64_C(0x1c52f2cc20ad46a3),
        UINT64_C(0x2412f94f4ccbc6a3), UINT64_C(0x2062f80f4cbd66a3)
    },
    {   UINT64_C(0x0000000000019433), UINT64_C(0x0de2f78d607424c0), UINT64_C(0x0bc2f5978869c6a6),
        UINT64_C(0x0f830a8d306ce67e), UINT64_C(0x143afa523c8be5d9)
    },
    {   UINT64_C(0x00000000000059ec), UINT64_C(0x1f42fa8e4cb40710), UINT64_C(0x1f43000f28b28710),
        UINT64_C(0x1f430e4e5cb56737), UINT64_C(0x1f42ff4ef8b1a710)
    },
    {   UINT64_C(0x0000000000019435), UINT64_C(0x0d3afbcfa069a67e), UINT64_C(0x0d3afbcfa069a67e),
        UINT64_C(0x00030717ec7086c7), UINT64_C(0x0002ee0ba86403b6)
    },
    {   UINT64_C(0x0000000000019436), UINT64_C(0x0002ee0ba86403b6), UINT64_C(0x10eaf60c3877a693),
        UINT64_C(0x09cafbd3105ec614), UINT64_C(0x09cafbd3105ec614)
    },
    {   UINT64_C(0x0000000000019437), UINT64_C(0x0002f590844e05a9), UINT64_C(0x08caff927c58e52c),
        UINT64_C(0x2a02fecf74e14797), UINT64_C(0x2a02fecf74e14797)
    },
    {   UINT64_C(0x0000000000019438), UINT64_C(0x156afa0e0c8e2656), UINT64_C(0x156af9cefc8de60b),
        UINT64_C(0x1632f1cc3891067e), UINT64_C(0x2272f1cc38c4a6dd)
    },
    {   UINT64_C(0x00000000000059f1), UINT64_C(0x1f42f7cf38ae2723), UINT64_C(0x1f42f78f08b5e70c),
        UINT64_C(0x1f42fd4ebcb186fc), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001513a), UINT64_C(0x1eeafd0c20b6e6a3), UINT64_C(0x1f22fa8f4cb886a3),
        UINT64_C(0x1d72f6cf68aaa5b6), UINT64_C(0x1432fd0f688c86a3)
    },
    {   UINT64_C(0x00000000000059f3), UINT64_C(0x1f42fc4e9cab670c), UINT64_C(0x1f42f78edcb9c708),
        UINT64_C(0x1f42f78eb4b5a700), UINT64_C(0x1f42f88f58a98717)
    },
    {   UINT64_C(0x000000000001943c), UINT64_C(0x1772fa918096056a), UINT64_C(0x1772fa90109605c6),
        UINT64_C(0x1772fa8f08960608), UINT64_C(0x13e2fa8bf087c72c)
    },
    {   UINT64_C(0x00000000000059f5), UINT64_C(0x1f43104e68b0e724), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001943e), UINT64_C(0x1cf2f40da4af4661), UINT64_C(0x1cf2f40da4af4661),
        UINT64_C(0x1f42fa9310b54506), UINT64_C(0x1772fa918096056a)
    },
    {   UINT64_C(0x00000000000059f7), UINT64_C(0x1f42fa8eecb3a708), UINT64_C(0x1f42fa8e9cb0a71b),
        UINT64_C(0x1f42f5cec8ac0726), UINT64_C(0x1f42f78e84b8e708)
    },
    {   UINT64_C(0x00000000000059f8), UINT64_C(0x1f42f88ee8b0e716), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb8f3cafe6e9), UINT64_C(0x1f42fa4eecb54708)
    },
    {   UINT64_C(0x00000000000059f9), UINT64_C(0x1f42fa4eccb7a704), UINT64_C(0x1f430a8f20b4c72f),
        UINT64_C(0x1f42fb4eecb7a70c), UINT64_C(0x1f42f68eecb9070c)
    },
    {   UINT64_C(0x00000000000059fa), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb8f58b0a710),
        UINT64_C(0x1f42f78eccb6a700), UINT64_C(0x1f42f78e4cb5671d)
    },
    {   UINT64_C(0x00000000000059fb), UINT64_C(0x1f430c4e6cb54733), UINT64_C(0x1f42f98eecb4e704),
        UINT64_C(0x1f42f78f28ace71b), UINT64_C(0x1f42f98ea4b5072b)
    },
    {   UINT64_C(0x00000000000059fc), UINT64_C(0x1f430e4e38ac4714), UINT64_C(0x1f42fd8f38b4e724),
        UINT64_C(0x1f42fa8f08b44704), UINT64_C(0x1f42f7ce7cafa736)
    },
    {   UINT64_C(0x00000000000059fd), UINT64_C(0x1f4309ce7cb78743), UINT64_C(0x1f42fa8ef4b6c716),
        UINT64_C(0x1f42fb4eecb54708), UINT64_C(0x1f42f68ec0b9470c)
    },
    {   UINT64_C(0x00000000000059fe), UINT64_C(0x1f42fb4f08b20710), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb4e98afa70c), UINT64_C(0x1f43024e78b1672f)
    },
    {   UINT64_C(0x00000000000059ff), UINT64_C(0x1f42f6ceecb7270c), UINT64_C(0x1f42fa8f68b5671b),
        UINT64_C(0x1f42fa4f08b56710), UINT64_C(0x1f42f6ce7cad271e)
    },
    {   UINT64_C(0x0000000000005a00), UINT64_C(0x1f42fd8f68b24714), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f64f2cb76721), UINT64_C(0x1f43020f38b18714)
    },
    {   UINT64_C(0x0000000000005a01), UINT64_C(0x1f4307ce98aea6fc), UINT64_C(0x1f42fa8f6cb5a713),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb8f78ad470c)
    },
    {   UINT64_C(0x0000000000005a02), UINT64_C(0x1f42fa4f28b0c703), UINT64_C(0x1f42fb8e9cac070d),
        UINT64_C(0x1f42f88f68b56718), UINT64_C(0x1f42ff8f00af0720)
    },
    {   UINT64_C(0x000000000001944b), UINT64_C(0x32cb040fa0fea690), UINT64_C(0x0a3af08b446246f5),
        UINT64_C(0x07d2f84b4454c6f5), UINT64_C(0x0c82ff518867c568)
    },
    {   UINT64_C(0x000000000001944c), UINT64_C(0x0c82ff518867c568), UINT64_C(0x15732291347a057d),
        UINT64_C(0x09daee118065e56a), UINT64_C(0x14630d1010808598)
    },
    {   UINT64_C(0x000000000001944d), UINT64_C(0x14630d1010808598), UINT64_C(0x1cf2fbcd30ab867e),
        UINT64_C(0x1cf2fbcd30ab867e), UINT64_C(0x1cf2fb8d30ab667e)
    },
    {   UINT64_C(0x000000000001944e), UINT64_C(0x1cf2fb8d30ab667e), UINT64_C(0x0ffb25d14c62a4be),
        UINT64_C(0x072afd5310538506), UINT64_C(0x08aaff91b85864f7)
    },
    {   UINT64_C(0x000000000001944f), UINT64_C(0x08aaff91b85864f7), UINT64_C(0x0ffafccd3076e67e),
        UINT64_C(0x0ffafccd3076e67e), UINT64_C(0x1cf2fb8d30ab867e)
    },
    {   UINT64_C(0x0000000000005a08), UINT64_C(0x1f43064e30b34724), UINT64_C(0x1f42fa8f58b7e717),
        UINT64_C(0x1f42fa4f58b54717), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000019451), UINT64_C(0x09baed530465c50a), UINT64_C(0x0b7afb918c65a566),
        UINT64_C(0x0b7afb919065a567), UINT64_C(0x0ffafccd3076e67e)
    },
    {   UINT64_C(0x0000000000005a0a), UINT64_C(0x1f42fccef8b82708), UINT64_C(0x1f42fdcf94aa671c),
        UINT64_C(0x1f42f7ceacb8a73e), UINT64_C(0x1f42f9ceccb6e723)
    },
    {   UINT64_C(0x0000000000005a0b), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f9ceecb72708),
        UINT64_C(0x1f42fdce6cb7670c), UINT64_C(0x1f42facea4b40709)
    },
    {   UINT64_C(0x0000000000019454), UINT64_C(0x0ffb25113063257b), UINT64_C(0x0b9af1930466250a),
        UINT64_C(0x0b9afb93046b250a), UINT64_C(0x0bdaff91b865255d)
    },
    {   UINT64_C(0x0000000000019455), UINT64_C(0x0bdaff91b865255d), UINT64_C(0x0bdaff91b865255d),
        UINT64_C(0x0bdaff91b865255d), UINT64_C(0x09daee0ff065e5ce)
    },
    {   UINT64_C(0x0000000000019456), UINT64_C(0x1cf327913495857d), UINT64_C(0x09daee0f1465e605),
        UINT64_C(0x204b275134a3257d), UINT64_C(0x0f02eb98c07bc662)
    },
    {   UINT64_C(0x0000000000005a0f), UINT64_C(0x1f42f88f68b8c727), UINT64_C(0x1f43008e8cb38724),
        UINT64_C(0x1f43160edcaec71f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005a10), UINT64_C(0x1f430b4eb8b40733), UINT64_C(0x1f42f7ce80b3a723),
        UINT64_C(0x1f42fdcedcb4c723), UINT64_C(0x1f42f9cedcb6c72b)
    },
    {   UINT64_C(0x0000000000005a11), UINT64_C(0x1f42f9ce94b86710), UINT64_C(0x1f42f88f38b20725),
        UINT64_C(0x1f42f60f18b12708), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005a12), UINT64_C(0x1f430e4ebcb02735), UINT64_C(0x1f42f9cef0b5470c),
        UINT64_C(0x1f43094ed8b7671b), UINT64_C(0x1f42fdcef8b6471b)
    },
    {   UINT64_C(0x000000000001945b), UINT64_C(0x38e2eb8b8d252474), UINT64_C(0x13caeddc708dc7a3),
        UINT64_C(0x13caedcb8c8dc36a), UINT64_C(0x1acafa0d289fa67c)
    },
    {   UINT64_C(0x000000000001945c), UINT64_C(0x1acb020d28a3a67c), UINT64_C(0x156af90d2c8aa67d),
        UINT64_C(0x156b010d2c8ea67d), UINT64_C(0x16fae7cad09bc46f)
    },
    {   UINT64_C(0x000000000001945d), UINT64_C(0x16faeb4ad09d846f), UINT64_C(0x16fae7cfa09bc5a4),
        UINT64_C(0x16faeb4fa09d85a4), UINT64_C(0x0f9af50f78796693)
    },
    {   UINT64_C(0x000000000001945e), UINT64_C(0x14d2f5cfa08de68a), UINT64_C(0x12e3008fa082e67e),
        UINT64_C(0x10bb008fa07fe67e), UINT64_C(0x14d2f5cfa08de68a)
    },
    {   UINT64_C(0x000000000001945f), UINT64_C(0x123b008fa082067e), UINT64_C(0x13eaf50fa089e67e),
        UINT64_C(0x1493008fa087867e), UINT64_C(0x1652f58f6894068c)
    },
    {   UINT64_C(0x0000000000000b86), UINT64_C(0x106afd4bfc78456c), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000019461), UINT64_C(0x151b008f6889a67e), UINT64_C(0x141af50fa08b667e),
        UINT64_C(0x1652f58f6894068c), UINT64_C(0x1493008fa087867e)
    },
    {   UINT64_C(0x0000000000019462), UINT64_C(0x106b008fa07e867e), UINT64_C(0x1652f58f6894068c),
        UINT64_C(0x1382f48fa088c67e), UINT64_C(0x1302f1cfa088a67e)
    },
    {   UINT64_C(0x0000000000019463), UINT64_C(0x1592f40fa091c68c), UINT64_C(0x1662f3cfa095267e),
        UINT64_C(0x15e2f5cfa092267e), UINT64_C(0x16a2f10fa0978691)
    },
    {   UINT64_C(0x0000000000019464), UINT64_C(0x1742f54fa097e68c), UINT64_C(0x10caf50f788105b7),
        UINT64_C(0x0f92f84c44796693), UINT64_C(0x0ed2f4cc407765b7)
    },
    {   UINT64_C(0x0000000000019465), UINT64_C(0x0f9af50f78796693), UINT64_C(0x0db2f38f7872e5b7),
        UINT64_C(0x0d02f64c4c718693), UINT64_C(0x0f72f84c4475e5b7)
    },
    {   UINT64_C(0x0000000000005a1e), UINT64_C(0x1f42fecec8abe711), UINT64_C(0x1f42facf48b3a6f0),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cec8b4671a)
    },
    {   UINT64_C(0x0000000000005a1f), UINT64_C(0x1f43084f0cb1a704), UINT64_C(0x1f43164f10ae0705),
        UINT64_C(0x1f42fa8f98b246ed), UINT64_C(0x1f42f88e6cb64732)
    },
    {   UINT64_C(0x0000000000019468), UINT64_C(0x0fdaefcf787b65ad), UINT64_C(0x0f92fa0c407945b6),
        UINT64_C(0x0d02f64c507245b7), UINT64_C(0x1072f50f788245ad)
    },
    {   UINT64_C(0x0000000000005a21), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f60f2cb7a72c),
        UINT64_C(0x1f42f30e7caf2726), UINT64_C(0x1f42fbce9cb2e6ec)
    },
    {   UINT64_C(0x000000000001946a), UINT64_C(0x1472f10c408ec5b5), UINT64_C(0x1382f54f7888e5ae),
        UINT64_C(0x0e42f3cf787485b7), UINT64_C(0x0f4af88f707be693)
    },
    {   UINT64_C(0x000000000001946b), UINT64_C(0x1372f50c4088c694), UINT64_C(0x0f5af50c407865b7),
        UINT64_C(0x17d2efcf789ae5ad), UINT64_C(0x105af84f787aa58e)
    },
    {   UINT64_C(0x000000000001946c), UINT64_C(0x105b0dcfa071258d), UINT64_C(0x105aff0fa077658d),
        UINT64_C(0x105af9cc88786590), UINT64_C(0x105afc8c887a858c)
    },
    {   UINT64_C(0x000000000001946d), UINT64_C(0x105afe8c8877a58d), UINT64_C(0x105af74f807b464c),
        UINT64_C(0x105af44c887bc58d), UINT64_C(0x105af9cf707a2646)
    },
    {   UINT64_C(0x000000000001946e), UINT64_C(0x105af84c807ae58d), UINT64_C(0x0002fb532c7025c2),
        UINT64_C(0x00030597307806c6), UINT64_C(0x156afa0e0c8e2656)
    },
    {   UINT64_C(0x000000000001946f), UINT64_C(0x0a2aedcfa067446f), UINT64_C(0x13caedcfa08dc46f),
        UINT64_C(0x0a2aeddc706747a3), UINT64_C(0x2b62f78fa0e7467e)
    },
    {   UINT64_C(0x0000000000019470), UINT64_C(0x382afc8b9117e6e3), UINT64_C(0x1692f1cc3896e6dc),
        UINT64_C(0x14daf24c3c88a6dc), UINT64_C(0x125af0cc3c86a6dc)
    },
    {   UINT64_C(0x0000000000019471), UINT64_C(0x1692fa0c3892e6dc), UINT64_C(0x131af10c3c8926dc),
        UINT64_C(0x1322f08c3c8946dc), UINT64_C(0x1692f28c3c9666dc)
    },
    {   UINT64_C(0x0000000000019472), UINT64_C(0x1692f68c389486dc), UINT64_C(0x0a6ae80c387546dc),
        UINT64_C(0x16daf64c3c98e6dc), UINT64_C(0x15f2f1cc389466dc)
    },
    {   UINT64_C(0x0000000000019473), UINT64_C(0x1bcaf10c3caa86dc), UINT64_C(0x1692f10c3896e6dc),
        UINT64_C(0x141af54c3c8b46dc), UINT64_C(0x1692f68c389486dc)
    },
    {   UINT64_C(0x0000000000019474), UINT64_C(0x1692f28c3c9666dc), UINT64_C(0x116af20c388526dc),
        UINT64_C(0x1382f58c3c8986dc), UINT64_C(0x131af24c3888a6dc)
    },
    {   UINT64_C(0x0000000000019475), UINT64_C(0x1692f54c389666dc), UINT64_C(0x17daf6cc3c9986dc),
        UINT64_C(0x1692f08c3c9686dc), UINT64_C(0x173af38c3c9906dc)
    },
    {   UINT64_C(0x0000000000019476), UINT64_C(0x1742f54c3c97e6dc), UINT64_C(0x150afbcbe091a6dc),
        UINT64_C(0x116af00c388f26dc), UINT64_C(0x142adc0c3892e6ed)
    },
    {   UINT64_C(0x0000000000019477), UINT64_C(0x1622efcc389206dc), UINT64_C(0x156afa0d308e267e),
        UINT64_C(0x156afa0d848e265b), UINT64_C(0x156afa0d848e265b)
    },
    {   UINT64_C(0x0000000000019478), UINT64_C(0x1c32ee0d30aa667e), UINT64_C(0x1c32ee0d30aa667e),
        UINT64_C(0x0ea310cd106e4812), UINT64_C(0x0ea3038d1067a812)
    },
    {   UINT64_C(0x0000000000019479), UINT64_C(0x121af44d10838812), UINT64_C(0x0bfb1b0d106be812),
        UINT64_C(0x0bfaf30d1057e812), UINT64_C(0x1f42ee0cdcbb8369)
    },
    {   UINT64_C(0x000000000001947a), UINT64_C(0x11fb0a8d1078c812), UINT64_C(0x11fb094d10782812),
        UINT64_C(0x121af4cd10838812), UINT64_C(0x1182ee18488486e7)
    },
    {   UINT64_C(0x000000000001947b), UINT64_C(0x1172ed98f88446d6), UINT64_C(0x1f42ee1ba8bb871c),
        UINT64_C(0x1182ee18488486e7), UINT64_C(0x1172ed8b6c844373)
    },
    {   UINT64_C(0x000000000001947c), UINT64_C(0x1182ee18488486e7), UINT64_C(0x1182ee18f88486d6),
        UINT64_C(0x1f42ee1ba8bb871c), UINT64_C(0x1182ee18488486e7)
    },
    {   UINT64_C(0x000000000001947d), UINT64_C(0x1182ee0b6c848373), UINT64_C(0x1f42ee0cdcbb8369),
        UINT64_C(0x00023a0f4c2ae5fc), UINT64_C(0x1b32ee18c0ab66d5)
    },
    {   UINT64_C(0x000000000001947e), UINT64_C(0x1b3aee18c0ab66d5), UINT64_C(0x1b3aee1728ab86c7),
        UINT64_C(0x1b3aee1728ab86c8), UINT64_C(0x1b3aee0b20ab636d)
    },
    {   UINT64_C(0x000000000001947f), UINT64_C(0x1b3aee0b20ab636d), UINT64_C(0x1b3aee0b44ab83ce),
        UINT64_C(0x1b3aee0b44ab83cf), UINT64_C(0x275afbd068d509c4)
    },
    {   UINT64_C(0x0000000000019480), UINT64_C(0x2a5afa9064e1a9c4), UINT64_C(0x2a5afa9064e1a9c4),
        UINT64_C(0x2863049064d4c9c3), UINT64_C(0x210b0a0b04c6a9f8)
    },
    {   UINT64_C(0x0000000000019481), UINT64_C(0x210b0a0b04c6a9f8), UINT64_C(0x210b0a0b04c6a9f8),
        UINT64_C(0x278afd1064d529c4), UINT64_C(0x278afd1064d529c4)
    },
    {   UINT64_C(0x0000000000019482), UINT64_C(0x278b0b9064cde9ce), UINT64_C(0x278b0b903ccde9c4),
        UINT64_C(0x0e2b1b0d1073c812), UINT64_C(0x0e2af44d1060a812)
    },
    {   UINT64_C(0x0000000000019483), UINT64_C(0x0e2b1b0d10740812), UINT64_C(0x0e2af4cd1060a812),
        UINT64_C(0x1583378e64864812), UINT64_C(0x15830aceb46fc826)
    },
    {   UINT64_C(0x0000000000019484), UINT64_C(0x0e12fa8adc7086a4), UINT64_C(0x0e12fa8adc5446a9),
        UINT64_C(0x0e12fa8af07086a9), UINT64_C(0x0e12fa8adc7086a4)
    },
    {   UINT64_C(0x0000000000019485), UINT64_C(0x0e13330adc7086a9), UINT64_C(0x0e12fa8af07086a9),
        UINT64_C(0x0e12fa8a94726692), UINT64_C(0x0e12fa8a94514697)
    },
    {   UINT64_C(0x0000000000019486), UINT64_C(0x0e12fa8aa8726697), UINT64_C(0x0e12f6ca94708692),
        UINT64_C(0x0e13390a94708697), UINT64_C(0x0e12f6caa8708697)
    },
    {   UINT64_C(0x0000000000019487), UINT64_C(0x14032f0adc8986a4), UINT64_C(0x1402f80adc6e06a9),
        UINT64_C(0x14032f0af08986a9), UINT64_C(0x14032f0adc6e06a9)
    },
    {   UINT64_C(0x0000000000019488), UINT64_C(0x1402f80adc6e06a4), UINT64_C(0x14032f0adc8986a9),
        UINT64_C(0x1402f80af06e06a9), UINT64_C(0x1583378f3c6fc64a)
    },
    {   UINT64_C(0x0000000000005a41), UINT64_C(0x1f42fa8f0cb34717), UINT64_C(0x1f42f7ce68b4e727),
        UINT64_C(0x1f42fa8eeca8c6fb), UINT64_C(0x1f42fb8eacb36700)
    },
    {   UINT64_C(0x000000000001948a), UINT64_C(0x213aff5820bac6e6), UINT64_C(0x213aff0e54baa473),
        UINT64_C(0x25030a0a3cae69ce), UINT64_C(0x168aee0b1c46ca06)
    },
    {   UINT64_C(0x000000000001948b), UINT64_C(0x168b91cb1c98aa06), UINT64_C(0x1cf2ee0d3cb24424),
        UINT64_C(0x1cf2ee1870b246f1), UINT64_C(0x1cf2ee0e3cb22470)
    },
    {   UINT64_C(0x000000000001948c), UINT64_C(0x1cf2ee1870b226fd), UINT64_C(0x2da2ee0c50f5042a),
        UINT64_C(0x2da2ee1870f50732), UINT64_C(0x11b3214d1081e812)
    },
    {   UINT64_C(0x000000000001948d), UINT64_C(0x11b2f4cd106ba812), UINT64_C(0x101b1b0d107b4812),
        UINT64_C(0x101af54d10686812), UINT64_C(0x12130b0d10784812)
    },
    {   UINT64_C(0x0000000000005a46), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fccf38b42717),
        UINT64_C(0x1f42fc8f1cb4470b), UINT64_C(0x1f42fccfb4b4271b)
    },
    {   UINT64_C(0x000000000001948f), UINT64_C(0x16430a8d1087e812), UINT64_C(0x13c30fcd1082c812),
        UINT64_C(0x13c3038d107ca812), UINT64_C(0x1932f44b44a02a06)
    },
    {   UINT64_C(0x0000000000019490), UINT64_C(0x1932f44b44a02a06), UINT64_C(0x309afb1064fa69c4),
        UINT64_C(0x309afb1064fa69c4), UINT64_C(0x309afb1064fa69c4)
    },
    {   UINT64_C(0x0000000000019491), UINT64_C(0x278b0b903ccde9c4), UINT64_C(0x278b0b903ccde9c4),
        UINT64_C(0x240b029064c469c4), UINT64_C(0x240b029064c469c4)
    },
    {   UINT64_C(0x0000000000019492), UINT64_C(0x2fd2fd1064f649c4), UINT64_C(0x2fd2fd1064f649c4),
        UINT64_C(0x2e52fd1064f049c4), UINT64_C(0x2863049068d4c9c4)
    },
    {   UINT64_C(0x0000000000019493), UINT64_C(0x15930f49f484274b), UINT64_C(0x0cd30709f465474b),
        UINT64_C(0x126b10cb447d6a06), UINT64_C(0x13030a8b447a4a06)
    },
    {   UINT64_C(0x0000000000019494), UINT64_C(0x1932f44b44a02a06), UINT64_C(0x0e5b1d8b44734a06),
        UINT64_C(0x0e5af74b44602a06), UINT64_C(0x2ee2ee0cdcfa0369)
    },
    {   UINT64_C(0x0000000000019495), UINT64_C(0x166b0d0b4480ea06), UINT64_C(0x166b1c8b4488aa06),
        UINT64_C(0x1932f44b44a02a06), UINT64_C(0x1e9aee1870b8e6f1)
    },
    {   UINT64_C(0x000000000000676b), UINT64_C(0x1f42fa0e88b44734), UINT64_C(0x1f4315ce20a7473e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4312ce28ae273b)
    },
    {   UINT64_C(0x0000000000005a4f), UINT64_C(0x1f42f4cef8b6c6f8), UINT64_C(0x1f42f7cec0b9e717),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f70ef4b9a734)
    },
    {   UINT64_C(0x000000000000676c), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe4dfcb4a745),
        UINT64_C(0x1f42fb8eb8b3c72d), UINT64_C(0x1f42fc0ee8b1671b)
    },
    {   UINT64_C(0x0000000000005a51), UINT64_C(0x1f42fd8f18b1c704), UINT64_C(0x1f42f7ceacb166f8),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001949a), UINT64_C(0x28e2ee0b20e2036d), UINT64_C(0x28e2ee0b44e203ce),
        UINT64_C(0x28e2ee0b44e203ce), UINT64_C(0x2323098950cf2bf0)
    },
    {   UINT64_C(0x0000000000005a53), UINT64_C(0x1f42f8ce80ab0726), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc8ea8ae06fb), UINT64_C(0x1f42f98f58b8271f)
    },
    {   UINT64_C(0x0000000000005a54), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f6cf38b72717),
        UINT64_C(0x1f42fc8f78b26717), UINT64_C(0x1f42fb8f94b6e716)
    },
    {   UINT64_C(0x000000000001949d), UINT64_C(0x2da2ee0d54f5042a), UINT64_C(0x2da2ee1890f506f9),
        UINT64_C(0x2da2ee0e5cf50477), UINT64_C(0x2da2ee1894f50705)
    },
    {   UINT64_C(0x0000000000005a56), UINT64_C(0x1f43088e30b4e728), UINT64_C(0x1f42f60f48b9270e),
        UINT64_C(0x1f4308ced8b24738), UINT64_C(0x1f42fccef8b10704)
    },
    {   UINT64_C(0x000000000001949f), UINT64_C(0x115b1d8b447f2a06), UINT64_C(0x115af78b446c2a06),
        UINT64_C(0x137305cb4480ea06), UINT64_C(0x137304cb44806a06)
    },
    {   UINT64_C(0x0000000000005a58), UINT64_C(0x1f42f6cf38ada71b), UINT64_C(0x1f42f5cf60b7a718),
        UINT64_C(0x1f42f30f38b08717), UINT64_C(0x1f42f7cf98a9a71f)
    },
    {   UINT64_C(0x0000000000005a59), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f98f48b3071b),
        UINT64_C(0x1f42fb8f08afa6f4), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005a5a), UINT64_C(0x1f42f98f30a9272d), UINT64_C(0x1f42f98eacb7e6fd),
        UINT64_C(0x1f42f2ce6cb7a725), UINT64_C(0x1f42f9ce4cb1871a)
    },
    {   UINT64_C(0x0000000000005a5b), UINT64_C(0x1f42f70e98b1c70c), UINT64_C(0x1f430d4eb8b16736),
        UINT64_C(0x1f42fccf1cb08728), UINT64_C(0x1f42f7cf10ac4704)
    },
    {   UINT64_C(0x0000000000005a5c), UINT64_C(0x1f42fb8f38b44717), UINT64_C(0x1f42f7cef8b86711),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f94eacb60729)
    },
    {   UINT64_C(0x0000000000005a5d), UINT64_C(0x1f42fc8eb8b1e722), UINT64_C(0x1f42fb8f48af4714),
        UINT64_C(0x1f43124e8cb00721), UINT64_C(0x1f42f6cee4b36723)
    },
    {   UINT64_C(0x0000000000005a5e), UINT64_C(0x1f42f4cedcb946ff), UINT64_C(0x1f42f6cf38b1a70f),
        UINT64_C(0x1f42f98eacb9a70c), UINT64_C(0x1f42f60edcb34704)
    },
    {   UINT64_C(0x0000000000005a5f), UINT64_C(0x1f42fe8f18b0e71c), UINT64_C(0x1f42ff4e5cb2e72a),
        UINT64_C(0x1f42facedcb5270b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005a60), UINT64_C(0x1f42fc8f58b2c71f), UINT64_C(0x1f42f84f38b6671b),
        UINT64_C(0x1f42f6cf58b7671b), UINT64_C(0x1f43108ed4afc70d)
    },
    {   UINT64_C(0x0000000000005a61), UINT64_C(0x1f42f88f38b3a70c), UINT64_C(0x1f42f60f78b7a72b),
        UINT64_C(0x1f42f6ceccb84718), UINT64_C(0x1f42fd8ef8ae6712)
    },
    {   UINT64_C(0x0000000000005a62), UINT64_C(0x1f42fdcfa8aba70f), UINT64_C(0x1f42f88e7cb7870c),
        UINT64_C(0x1f42fb4e70b4c729), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000004076), UINT64_C(0x1f433190a099e71b), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f433190a099e6e6), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005a64), UINT64_C(0x1f42f88efcb22708), UINT64_C(0x1f42f9cea0b2a734),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f88edcb14703)
    },
    {   UINT64_C(0x0000000000004077), UINT64_C(0x1f433190a099e713), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005a66), UINT64_C(0x1f43114eacb0270e), UINT64_C(0x1f42fb8edcb8a70e),
        UINT64_C(0x1f42f6cf58ab470d), UINT64_C(0x1f42f6ceacb74723)
    },
    {   UINT64_C(0x0000000000005a67), UINT64_C(0x1f42f9cef4b2c723), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f88f04af86f8), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006778), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ffceb0b2c723),
        UINT64_C(0x1f43024de8b06736), UINT64_C(0x1f43018ed8b2c72d)
    },
    {   UINT64_C(0x00000000000194b1), UINT64_C(0x4e22ee0cdd770369), UINT64_C(0x21a31947acaccdee),
        UINT64_C(0x21a31e87acaf6dee), UINT64_C(0x28eaf207ace02dee)
    },
    {   UINT64_C(0x0000000000005a6a), UINT64_C(0x1f42fc8e9cb3272e), UINT64_C(0x1f42f88ed0afa709),
        UINT64_C(0x1f42f88ea4af870f), UINT64_C(0x1f42f1ce3cb5472b)
    },
    {   UINT64_C(0x00000000000194b3), UINT64_C(0x3af2ee0b412a4373), UINT64_C(0x3af2ee18952a4704),
        UINT64_C(0x3af2ee19212a46eb), UINT64_C(0x4e22ee1ba977071c)
    },
    {   UINT64_C(0x00000000000194b4), UINT64_C(0x3af2ee18952a4704), UINT64_C(0x3af2ee0b412a4373),
        UINT64_C(0x4e22ee0cdd770369), UINT64_C(0x0002738c102966c3)
    },
    {   UINT64_C(0x00000000000194b5), UINT64_C(0x4422ee18c14f06d5), UINT64_C(0x4422ee18c14f06d5),
        UINT64_C(0x4422ee17294f06c7), UINT64_C(0x4422ee17294f06c7)
    },
    {   UINT64_C(0x0000000000005a6e), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f98f18b726ff),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80f58a98727)
    },
    {   UINT64_C(0x00000000000194b7), UINT64_C(0x25030a0fa0ae6b27), UINT64_C(0x25030a0fa0ae6c44),
        UINT64_C(0x25030a0fa0ae6c3f), UINT64_C(0x155337c7ac906dee)
    },
    {   UINT64_C(0x0000000000005a70), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f78f68aba70e),
        UINT64_C(0x1f42fccf04b006fc), UINT64_C(0x1f43094e9cb68740)
    },
    {   UINT64_C(0x00000000000194b9), UINT64_C(0x5423030e55848473), UINT64_C(0x48c2ee0d01618434),
        UINT64_C(0x48c2ee1895618719), UINT64_C(0x48c2ee0e39618497)
    },
    {   UINT64_C(0x00000000000194ba), UINT64_C(0x48c2ee189161872d), UINT64_C(0x5592ee0c5194c42a),
        UINT64_C(0x5592ee187194c732), UINT64_C(0x203b3e07acb66dee)
    },
    {   UINT64_C(0x00000000000194bb), UINT64_C(0x203b0007ac976dee), UINT64_C(0x185337c7ac970dee),
        UINT64_C(0x1852ff87ac7aedee), UINT64_C(0x1c630a47aca20dee)
    },
    {   UINT64_C(0x00000000000194bc), UINT64_C(0x1c630a07aca1edee), UINT64_C(0x27cb0d87accc2dee),
        UINT64_C(0x27cb1107accdedee), UINT64_C(0x264b1b87acc20dee)
    },
    {   UINT64_C(0x00000000000194bd), UINT64_C(0x264b1947acc0edee), UINT64_C(0x24bb1ec7acc1cdee),
        UINT64_C(0x24bb1e87acc1adee), UINT64_C(0x5dc2ee0cddb58369)
    },
    {   UINT64_C(0x0000000000005a76), UINT64_C(0x1f42fdcec0b3a740), UINT64_C(0x1f42fb0ed0b5071a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8f28b2270b)
    },
    {   UINT64_C(0x00000000000194bf), UINT64_C(0x48c2ee0b41618373), UINT64_C(0x48c2ee1891618718),
        UINT64_C(0x48c2ee19456186f4), UINT64_C(0x5dc2ee1ba9b5871c)
    },
    {   UINT64_C(0x0000000000005a78), UINT64_C(0x1f42fdcf80b12713), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f98ef0b1e70b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000194c1), UINT64_C(0x5dc2ee18c1b586d5), UINT64_C(0x5dc2ee18c1b586d5),
        UINT64_C(0x5dc2ee1729b586c7), UINT64_C(0x5dc2ee1729b586c7)
    },
    {   UINT64_C(0x0000000000006781), UINT64_C(0x1f430d4e0cb3073c), UINT64_C(0x1f42fe0eb0b1c72b),
        UINT64_C(0x1f42f84ea8b40721), UINT64_C(0x1f43030ed4b32735)
    },
    {   UINT64_C(0x000000000001787e), UINT64_C(0x0fa2f30fa0872698), UINT64_C(0x0fa2f60f6c87c698),
        UINT64_C(0x0fa2fbcfa0876698), UINT64_C(0x0fa2f4cf6c8fe68c)
    },
    {   UINT64_C(0x0000000000005a7c), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8ef8b18704),
        UINT64_C(0x1f42f7ce6cb8871b), UINT64_C(0x1f430d8e6caee73c)
    },
    {   UINT64_C(0x000000000001787f), UINT64_C(0x0fa3020f6c8e4698), UINT64_C(0x0fa30c0fa08e668c),
        UINT64_C(0x0fa2fdcf6c88c698), UINT64_C(0x0fa2f50f6c880698)
    },
    {   UINT64_C(0x0000000000006783), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc8ebcb5271c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbcebcb52723)
    },
    {   UINT64_C(0x00000000000194c7), UINT64_C(0x13dafc0b6cbfebb8), UINT64_C(0x1c92fc0b6cbfebb8),
        UINT64_C(0x2f5afc0b6d342bb8), UINT64_C(0x13dafc0b6cbfebb8)
    },
    {   UINT64_C(0x0000000000005a80), UINT64_C(0x1f42fd8eb0ae8712), UINT64_C(0x1f42f88f04b64706),
        UINT64_C(0x1f43068e5cb42731), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000194c9), UINT64_C(0x16fafc0b6cbfebb8), UINT64_C(0x13dafc0b6cbfebb8),
        UINT64_C(0x1a62fc0b6cc24bb8), UINT64_C(0x13dafc0b6cbfebb8)
    },
    {   UINT64_C(0x0000000000005a82), UINT64_C(0x1f42f2cec0b26714), UINT64_C(0x1f42f2cf08b64710),
        UINT64_C(0x1f430a8f14b1c72c), UINT64_C(0x1f42f24f58b96703)
    },
    {   UINT64_C(0x0000000000017882), UINT64_C(0x17f2f28fa09e4685), UINT64_C(0x132af28fa0858685),
        UINT64_C(0x1c82f48fa0b46685), UINT64_C(0x176af6cf689a4695)
    },
    {   UINT64_C(0x0000000000005a84), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f6ceecb8c723),
        UINT64_C(0x1f42facf50b52721), UINT64_C(0x1f42f60ec8b44740)
    },
    {   UINT64_C(0x00000000000194cd), UINT64_C(0x1fe2f84cacbd069a), UINT64_C(0x1182f84cac83869a),
        UINT64_C(0x1182f84cac83869a), UINT64_C(0x1182f84cac83869a)
    },
    {   UINT64_C(0x0000000000006787), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8efcb4e71a),
        UINT64_C(0x1f4318ce90a74735), UINT64_C(0x1f43074edcac073d)
    },
    {   UINT64_C(0x00000000000194cf), UINT64_C(0x1182f84ca883869e), UINT64_C(0x0f82f84ca883869e),
        UINT64_C(0x1182f84cac83869f), UINT64_C(0x100af84ca483869e)
    },
    {   UINT64_C(0x00000000000194d0), UINT64_C(0x1002f84ca883869e), UINT64_C(0x13daf84ca889269e),
        UINT64_C(0x1002f8cca883869e), UINT64_C(0x1002f84cac83869f)
    },
    {   UINT64_C(0x00000000000194d1), UINT64_C(0x132af14ca887c69e), UINT64_C(0x1002f84cac83869f),
        UINT64_C(0x1002f80ca883669e), UINT64_C(0x1002f80ca883669e)
    },
    {   UINT64_C(0x0000000000005a8a), UINT64_C(0x1f42f98e3cb54717), UINT64_C(0x1f42ff8f1cb2e725),
        UINT64_C(0x1f42fbcee8b2670f), UINT64_C(0x1f42f30f88b90717)
    },
    {   UINT64_C(0x00000000000194d3), UINT64_C(0x19d2fccaa0ab0720), UINT64_C(0x0c6af6caa07b4720),
        UINT64_C(0x1122f6caa08e2720), UINT64_C(0x1b62fb8aa0b80720)
    },
    {   UINT64_C(0x00000000000194d4), UINT64_C(0x0ef2fb8aa082e720), UINT64_C(0x0dcaf6caa080c720),
        UINT64_C(0x0edaf6caa0850720), UINT64_C(0x1612f8ca70912714)
    },
    {   UINT64_C(0x00000000000194d5), UINT64_C(0x222afcca70cc6714), UINT64_C(0x0e9afcca707e2714),
        UINT64_C(0x0e9afcca707e2714), UINT64_C(0x108afcca7085e714)
    },
    {   UINT64_C(0x0000000000005a8e), UINT64_C(0x1f42facf58b2472b), UINT64_C(0x1f42f7ce5cb80730),
        UINT64_C(0x1f42f6ce6cb3673d), UINT64_C(0x1f42fa8e80b38716)
    },
    {   UINT64_C(0x00000000000194d7), UINT64_C(0x0feafb8a7086c714), UINT64_C(0x0c62f6ca707b2714),
        UINT64_C(0x0ce2f5ca707aa714), UINT64_C(0x181af94a70a66714)
    },
    {   UINT64_C(0x000000000000678c), UINT64_C(0x0000000000000000), UINT64_C(0x1f43048f48ad2712),
        UINT64_C(0x1f4307cf10ac8711), UINT64_C(0x1f43154eb0ab2710)
    },
    {   UINT64_C(0x00000000000194d9), UINT64_C(0x0bc2fcc8847e2714), UINT64_C(0x0e9afc8b6c7e8bb8),
        UINT64_C(0x189afc8b6ca68bb8), UINT64_C(0x229afc8b6cce8bb8)
    },
    {   UINT64_C(0x000000000000678d), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f78f90b1c72c),
        UINT64_C(0x1f430e8ea8a72731), UINT64_C(0x1f43124ea8a6c713)
    },
    {   UINT64_C(0x000000000001788a), UINT64_C(0x0eeaf60fa08145a9), UINT64_C(0x16eafbcfa09de5a9),
        UINT64_C(0x1192eb0fa08825a9), UINT64_C(0x1242ebcc6c8ee5a9)
    },
    {   UINT64_C(0x000000000000678e), UINT64_C(0x1f42fb4f24ad2711), UINT64_C(0x1f42fb0f28ae270a),
        UINT64_C(0x1f42f50f3caca711), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001788b), UINT64_C(0x135af6cfa088c5a9), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000678f), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80f14b14723),
        UINT64_C(0x1f43168ee8a5472e), UINT64_C(0x1f4309cf24aea71e)
    },
    {   UINT64_C(0x00000000000194df), UINT64_C(0x16fafe4b6ca2abb8), UINT64_C(0x16fafe4b6ca2abb8),
        UINT64_C(0x15eaee0b6c9b2c55), UINT64_C(0x0e9afc88f8a26bb8)
    },
    {   UINT64_C(0x0000000000005a98), UINT64_C(0x1f42fdce94b4a719), UINT64_C(0x1f42f80edcb8273f),
        UINT64_C(0x1f42f6ce8cae8717), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000194e1), UINT64_C(0x1552fb0cac8ec69a), UINT64_C(0x1c6afb0cacab269a),
        UINT64_C(0x0f02fb0cac76669a), UINT64_C(0x0f02fb0cac76869a)
    },
    {   UINT64_C(0x0000000000005a9a), UINT64_C(0x1f42fc8e8cb3a727), UINT64_C(0x1f42fb8f1cb206f0),
        UINT64_C(0x1f42f88edcb6a6fb), UINT64_C(0x1f42f5cee8b46738)
    },
    {   UINT64_C(0x00000000000194e3), UINT64_C(0x0d22ff0ca86f669e), UINT64_C(0x1042f7cca87ac69e),
        UINT64_C(0x0a22f84ca86e069e), UINT64_C(0x0f02fb0ca876669e)
    },
    {   UINT64_C(0x00000000000194e4), UINT64_C(0x0e12ff0ca871c69e), UINT64_C(0x0e12ff0cac72069a),
        UINT64_C(0x1132ff0cac7e869a), UINT64_C(0x0e12fa8cac71c69a)
    },
    {   UINT64_C(0x00000000000194e5), UINT64_C(0x0e12fa8ca471c69e), UINT64_C(0x131af10ca887a69e),
        UINT64_C(0x0e12fa0ca872069e), UINT64_C(0x0e12fccca870e69e)
    },
    {   UINT64_C(0x0000000000005a9e), UINT64_C(0x1f42fd0f18b4070e), UINT64_C(0x1f42fb8ee4b3c72f),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005a9f), UINT64_C(0x1f42f8cf4cb8270c), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f98eacb86713), UINT64_C(0x1f42f88f48ae670e)
    },
    {   UINT64_C(0x0000000000005aa0), UINT64_C(0x1f42f8cf28afc721), UINT64_C(0x1f42f4cebcb7c72d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43150f18ac671d)
    },
    {   UINT64_C(0x0000000000005aa1), UINT64_C(0x1f42f7cf80b786fb), UINT64_C(0x1f42f60e5cb5e71d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f60ec0af870e)
    },
    {   UINT64_C(0x0000000000005aa2), UINT64_C(0x0000000000000000), UINT64_C(0x1f42facf58b3671e),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005aa3), UINT64_C(0x1f42f70ebcb166eb), UINT64_C(0x1f42f60ef8b32711),
        UINT64_C(0x1f42f40e60b7c722), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000015193), UINT64_C(0x185b084ce0a7669b), UINT64_C(0x14f3020fa095c68c),
        UINT64_C(0x1152fe8f548e269b), UINT64_C(0x140b154fa0a0a68c)
    },
    {   UINT64_C(0x0000000000017893), UINT64_C(0x142af68fa09ac6a0), UINT64_C(0x133af8cd608b66a8),
        UINT64_C(0x1a8af38f40a9c6a0), UINT64_C(0x136af70fa08c66a0)
    },
    {   UINT64_C(0x0000000000015194), UINT64_C(0x15db0ccf54a1868c), UINT64_C(0x15931e4f58a6a68c),
        UINT64_C(0x1f2b1f8f64cc668c), UINT64_C(0x1722f80fa0a9268c)
    },
    {   UINT64_C(0x0000000000005aa7), UINT64_C(0x1f42f6ce54b80727), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f50f38b20723), UINT64_C(0x1f42fa8eb0b006f2)
    },
    {   UINT64_C(0x0000000000015195), UINT64_C(0x15b31d0fa0a7c68c), UINT64_C(0x146af44fa09ea68c),
        UINT64_C(0x0f4afa0f687de5c1), UINT64_C(0x1002facf6c84468c)
    },
    {   UINT64_C(0x0000000000005aa9), UINT64_C(0x1f42f60f18b9c709), UINT64_C(0x1f42fb8ea4b76740),
        UINT64_C(0x1f42f7ceccab46ef), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005aaa), UINT64_C(0x1f42fc8f28aaa720), UINT64_C(0x1f42fb8ec4abe719),
        UINT64_C(0x1f42f6cedcb72721), UINT64_C(0x1f42f98ef8b62721)
    },
    {   UINT64_C(0x0000000000005aab), UINT64_C(0x1f42f6cea0b6a738), UINT64_C(0x1f42f8cf58b706ed),
        UINT64_C(0x1f42f9cef0b1873d), UINT64_C(0x1f42f8cf20b0c73c)
    },
    {   UINT64_C(0x000000000000679a), UINT64_C(0x1f43028f5cb4e706), UINT64_C(0x1f42ffcf30b106fd),
        UINT64_C(0x1f42fe0f1cb0e709), UINT64_C(0x1f43110eaca8c720)
    },
    {   UINT64_C(0x0000000000017897), UINT64_C(0x1462f70f2496c6af), UINT64_C(0x1de2f70f18bcc6af),
        UINT64_C(0x1682f70f68a026ae), UINT64_C(0x1682f70d609f26af)
    },
    {   UINT64_C(0x000000000000679b), UINT64_C(0x1f43020f3cb1e6fd), UINT64_C(0x1f43164eb4ada720),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000017898), UINT64_C(0x1852f70e189b86a6), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000679c), UINT64_C(0x1f42f98ea4a88739), UINT64_C(0x1f42f6cf34b2a72f),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc4ee0b22714)
    },
    {   UINT64_C(0x0000000000017899), UINT64_C(0x12c2f9cf7883c5c1), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001519a), UINT64_C(0x0c0af74f6c75c5c1), UINT64_C(0x0c13068f7076665f),
        UINT64_C(0x1033024f6485a5b6), UINT64_C(0x0e730e4f6884a5b6)
    },
    {   UINT64_C(0x000000000001789a), UINT64_C(0x12c305cfa076c5c1), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ab4), UINT64_C(0x1f43140eecafc704), UINT64_C(0x1f42f5cf58b6671f),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f6ced4aea742)
    },
    {   UINT64_C(0x000000000001789b), UINT64_C(0x12c2fb8fa080e5c1), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000679f), UINT64_C(0x1f4305cf90b80704), UINT64_C(0x1f430c4f24ae4729),
        UINT64_C(0x1f43054f4cb22726), UINT64_C(0x1f42fc4f10b5872a)
    },
    {   UINT64_C(0x000000000001789c), UINT64_C(0x12c2f5cc3c82e5b7), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000067a0), UINT64_C(0x1f42fa8ed4ace738), UINT64_C(0x1f42fb0e70b5072d),
        UINT64_C(0x1f42fb8e70b00725), UINT64_C(0x1f42fa8f38ad0736)
    },
    {   UINT64_C(0x000000000001789d), UINT64_C(0x12c2f58c3c8505aa), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000067a1), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd4f48a96739), UINT64_C(0x1f42fd4ebcabc739)
    },
    {   UINT64_C(0x000000000001789e), UINT64_C(0x12c2f44c3884a5aa), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005abc), UINT64_C(0x1f42f8ced8b46726), UINT64_C(0x1f430c8edcb06721),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cf28b4a71b)
    },
    {   UINT64_C(0x000000000001789f), UINT64_C(0x12c2fbcf7882a686), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005abe), UINT64_C(0x1f42f6ce50b56724), UINT64_C(0x1f42fcceecae672a),
        UINT64_C(0x1f42f78f28b0c708), UINT64_C(0x1f42fb8f2cb2c714)
    },
    {   UINT64_C(0x00000000000178a0), UINT64_C(0x12c2f40c3c8745aa), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000067a4), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f58e78b0872d),
        UINT64_C(0x1f42f38f6cb5c70a), UINT64_C(0x1f43034ed0afc738)
    },
    {   UINT64_C(0x00000000000178a1), UINT64_C(0x12c2f84f78848686), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ac2), UINT64_C(0x1f42f94e44af2735), UINT64_C(0x1f42f88e20b68738),
        UINT64_C(0x1f42f88e98af673a), UINT64_C(0x1f42f78e6cb22707)
    },
    {   UINT64_C(0x00000000000178a2), UINT64_C(0x12c2fa4c3c81e5b7), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000067a6), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc4e94afc736),
        UINT64_C(0x1f42fa8e50afa742), UINT64_C(0x1f42fa8e30ae4742)
    },
    {   UINT64_C(0x0000000000005ac5), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f9ce90b60728), UINT64_C(0x1f42f88e8cafe73c)
    },
    {   UINT64_C(0x0000000000005ac6), UINT64_C(0x1f42f3ce54b10710), UINT64_C(0x1f42fa8eacaf8725),
        UINT64_C(0x1f42f78eecb22727), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ac7), UINT64_C(0x0000000000000000), UINT64_C(0x1f430b4e44ace739),
        UINT64_C(0x1f42f2cedcb0e716), UINT64_C(0x1f42f58ee8b7e721)
    },
    {   UINT64_C(0x0000000000005ac8), UINT64_C(0x1f43138f70ac4709), UINT64_C(0x1f43080fecb1c70b),
        UINT64_C(0x1f42ff8ffcb326f9), UINT64_C(0x1f43020fd4b4c700)
    },
    {   UINT64_C(0x00000000000178a5), UINT64_C(0x0000000000000000), UINT64_C(0x1842f80bf49ae6ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x17d2f90bf49be6ef)
    },
    {   UINT64_C(0x0000000000005aca), UINT64_C(0x1f43048f70b546f1), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000178a6), UINT64_C(0x0000000000000000), UINT64_C(0x163afc4bf49ca6ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x1b32f90bf4a786ef)
    },
    {   UINT64_C(0x0000000000005acc), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80f4cb7c701),
        UINT64_C(0x1f42f69020b646f6), UINT64_C(0x1f43039028b1c6fa)
    },
    {   UINT64_C(0x00000000000178a7), UINT64_C(0x0000000000000000), UINT64_C(0x17baf90bf49fe6ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x1492f90bf49ee6ef)
    },
    {   UINT64_C(0x0000000000005ace), UINT64_C(0x1f4302d024afe70b), UINT64_C(0x1f42fdcf24b16717),
        UINT64_C(0x1f42fdcf90b546fb), UINT64_C(0x1f43028f20b1c704)
    },
    {   UINT64_C(0x00000000000178a8), UINT64_C(0x0000000000000000), UINT64_C(0x18aafc4bf4a0e6ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x1c9af90bf4b406ef)
    },
    {   UINT64_C(0x00000000000067ac), UINT64_C(0x1f42fa4ef0b62738), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000178a9), UINT64_C(0x0000000000000000), UINT64_C(0x0fb2f98bf48026ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x1442ff0bf49486ef)
    },
    {   UINT64_C(0x0000000000005ad2), UINT64_C(0x1f42facec0b7a700), UINT64_C(0x1f42f94ebcb7c715),
        UINT64_C(0x1f43068fa0b4c712), UINT64_C(0x1f42f94fb8b5c70f)
    },
    {   UINT64_C(0x0000000000005ad3), UINT64_C(0x1f42fa0ec4b7a709), UINT64_C(0x1f42fe8f70b2c716),
        UINT64_C(0x1f43008eb8b7272a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000067ae), UINT64_C(0x1f43038f34b5c6fe), UINT64_C(0x1f42fdcf1cb3c708),
        UINT64_C(0x1f42f8cf34b626fe), UINT64_C(0x1f42f98eccb6e73b)
    },
    {   UINT64_C(0x0000000000005ad5), UINT64_C(0x1f42fb4f3cb826fc), UINT64_C(0x1f42ffcefcb64716),
        UINT64_C(0x1f42f74eb0b8a71a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ad6), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90f28b24722),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f9cfa8b8a6fb)
    },
    {   UINT64_C(0x00000000000178ac), UINT64_C(0x0000000000000000), UINT64_C(0x1912fc4bf49fa6ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x1392f2cc64a146ef)
    },
    {   UINT64_C(0x00000000000067b0), UINT64_C(0x1f42f78e6cb66742), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f88e64ab6738), UINT64_C(0x1f42fd8e9cb2673f)
    },
    {   UINT64_C(0x00000000000040b1), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4334531894e651)
    },
    {   UINT64_C(0x00000000000067b1), UINT64_C(0x1f43058eb8afe719), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005adb), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f70e90b5e734),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430e0f4cab6702)
    },
    {   UINT64_C(0x000000000000f800), UINT64_C(0x2503b80f3cb0864a), UINT64_C(0x2573b810ccd786a8),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005add), UINT64_C(0x1f43008f78b246fc), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43160ea0ac871e), UINT64_C(0x1f42fc4f78b646fc)
    },
    {   UINT64_C(0x0000000000005ade), UINT64_C(0x1f42fdce6cb30737), UINT64_C(0x1f43178f0caa26ee),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4303d034b3e6d2)
    },
    {   UINT64_C(0x000000000000f803), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1773020a5492471b), UINT64_C(0x1773020bf49246ce)
    },
    {   UINT64_C(0x0000000000005ae0), UINT64_C(0x1f43031094b426e7), UINT64_C(0x1f43010facb4c6db),
        UINT64_C(0x1f42fad064b786cb), UINT64_C(0x1f43009000b5c704)
    },
    {   UINT64_C(0x0000000000014804), UINT64_C(0x0a6aed123860a502), UINT64_C(0x0a6aed123860a502),
        UINT64_C(0x0fa2e412387a2502), UINT64_C(0x0fa2e412687a24f5)
    },
    {   UINT64_C(0x0000000000005ae2), UINT64_C(0x1f43008fecba0694), UINT64_C(0x1f43028eccaaa717),
        UINT64_C(0x1f42fbce6cb7272e), UINT64_C(0x1f43040e98aee70b)
    },
    {   UINT64_C(0x0000000000005ae3), UINT64_C(0x1f43029020aec6dc), UINT64_C(0x1f4300ced4b14718),
        UINT64_C(0x1f42ff8fd0b24708), UINT64_C(0x1f42fcced8b546f8)
    },
    {   UINT64_C(0x000000000000f808), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1772ff0bf493e6ce)
    },
    {   UINT64_C(0x0000000000005ae5), UINT64_C(0x1f42faced8b4c715), UINT64_C(0x1f4300cf4cb00701),
        UINT64_C(0x1f43048fa8b60729), UINT64_C(0x1f42faceecb62718)
    },
    {   UINT64_C(0x000000000000f80a), UINT64_C(0x1f42f78d08b6a688), UINT64_C(0x1f42f78d08b6a688),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000178b4), UINT64_C(0x0000000000000000), UINT64_C(0x1002f90bf47f06ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x1472e6cbf49dc6ef)
    },
    {   UINT64_C(0x0000000000005ae8), UINT64_C(0x1f42fe0f24b06712), UINT64_C(0x1f4301cf90b0c703),
        UINT64_C(0x1f4302ceb8b20724), UINT64_C(0x1f42fd8f3cb2c722)
    },
    {   UINT64_C(0x000000000000f80d), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1772fecd0893c688)
    },
    {   UINT64_C(0x0000000000005aea), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fe8f8cb0a72b), UINT64_C(0x1f42fbce9cb1e715)
    },
    {   UINT64_C(0x00000000000178b6), UINT64_C(0x0000000000000000), UINT64_C(0x0baaf68c647b86ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x12c2e6cbf49de6ef)
    },
    {   UINT64_C(0x0000000000005aec), UINT64_C(0x1f43038ec4ae8739), UINT64_C(0x1f42f74ebcb6e726),
        UINT64_C(0x1f42f8cebcb7a726), UINT64_C(0x1f4317cf34af271d)
    },
    {   UINT64_C(0x00000000000178b7), UINT64_C(0x0000000000000000), UINT64_C(0x1372f6cbf49106ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x0beaf58c647b06ef)
    },
    {   UINT64_C(0x0000000000005aee), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43018fccb68706), UINT64_C(0x1f42fd4f48b40726)
    },
    {   UINT64_C(0x00000000000178b8), UINT64_C(0x0000000000000000), UINT64_C(0x1b4af6cbf4a746ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x131af6cbf48726ef)
    },
    {   UINT64_C(0x000000000000f814), UINT64_C(0x177303cd08916688), UINT64_C(0x177303cd08916688),
        UINT64_C(0x1772ff0e8c93e626), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000178b9), UINT64_C(0x0000000000000000), UINT64_C(0x11daf98bf48306ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x13e2e7cbf48fa6ef)
    },
    {   UINT64_C(0x000000000000f816), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1772ff0fe093e626)
    },
    {   UINT64_C(0x0000000000005af3), UINT64_C(0x1f42ff10c8b446d5), UINT64_C(0x1f42fccee4b6a6ed),
        UINT64_C(0x1f42f7ce6cb6c748), UINT64_C(0x1f42fe8e7cb6c74a)
    },
    {   UINT64_C(0x0000000000005af4), UINT64_C(0x1f43038eb8b2c729), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fbce7cb5a741), UINT64_C(0x1f42f88fc0b98715)
    },
    {   UINT64_C(0x0000000000005af5), UINT64_C(0x1f4315107cb5e6f2), UINT64_C(0x1f4308ceb8ae8713),
        UINT64_C(0x1f43060e3cace718), UINT64_C(0x1f42f99014b586f2)
    },
    {   UINT64_C(0x0000000000005af6), UINT64_C(0x1f431e0f68b18711), UINT64_C(0x1f43140f18b0471e),
        UINT64_C(0x1f43140e50b2673f), UINT64_C(0x1f43008ff0b7c711)
    },
    {   UINT64_C(0x0000000000005af7), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4311cebcace6fe), UINT64_C(0x1f430b0e64ad272e)
    },
    {   UINT64_C(0x0000000000005af8), UINT64_C(0x1f430f4e80b00719), UINT64_C(0x1f42f74fa8b5e6ee),
        UINT64_C(0x1f42f70f38b6a6ef), UINT64_C(0x1f430cce90af0721)
    },
    {   UINT64_C(0x0000000000005af9), UINT64_C(0x1f42f8cf18b8e6d8), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f88f08b766c3), UINT64_C(0x1f42fc0f3cb346cd)
    },
    {   UINT64_C(0x0000000000005afa), UINT64_C(0x1f42fc0f40b586d6), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb4f98b226fd), UINT64_C(0x1f430ecebcade736)
    },
    {   UINT64_C(0x0000000000005afb), UINT64_C(0x1f42f68f54b30710), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f54f74b5a70c)
    },
    {   UINT64_C(0x000000000000f820), UINT64_C(0x1773020a5c92471b), UINT64_C(0x177304ca4893a71c),
        UINT64_C(0x1773020bf49246ce), UINT64_C(0x1773020bf89246ce)
    },
    {   UINT64_C(0x0000000000005e15), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f7cf7caac706),
        UINT64_C(0x1f42f61030b64708), UINT64_C(0x1f42f5cf98b44719)
    },
    {   UINT64_C(0x0000000000005afe), UINT64_C(0x1f42f44f28b6e6d5), UINT64_C(0x1f42fd1020b50713),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbced8b7c70d)
    },
    {   UINT64_C(0x0000000000005aff), UINT64_C(0x1f42ff4f20b846e5), UINT64_C(0x1f42f58ebcb4a702),
        UINT64_C(0x1f42f70f88b866f1), UINT64_C(0x1f42f70e60b5672a)
    },
    {   UINT64_C(0x0000000000005b00), UINT64_C(0x1f43008f1cb5e70d), UINT64_C(0x1f42f50f6cb5a70a),
        UINT64_C(0x1f43084f08ae8722), UINT64_C(0x1f42fd8f50b74711)
    },
    {   UINT64_C(0x0000000000005b01), UINT64_C(0x1f43080f64b7e709), UINT64_C(0x1f430e0e88b0a72a),
        UINT64_C(0x1f42f80f4cb4e705), UINT64_C(0x1f42fa0f60b1070b)
    },
    {   UINT64_C(0x0000000000005b02), UINT64_C(0x1f4300cf78b9472e), UINT64_C(0x1f4301cf68b526e7),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43020ed4b7c732)
    },
    {   UINT64_C(0x0000000000005b03), UINT64_C(0x1f42fa4edcb226e1), UINT64_C(0x1f42f58ef8b7a6dd),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430e0e9cb2a717)
    },
    {   UINT64_C(0x0000000000005b04), UINT64_C(0x1f4318d00cb54731), UINT64_C(0x1f43148f0cb52703),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd0f74b6e6da)
    },
    {   UINT64_C(0x0000000000005b05), UINT64_C(0x1f430a8f1cb4871b), UINT64_C(0x1f43098e7cb6870d),
        UINT64_C(0x1f42fe8eecb7072e), UINT64_C(0x1f43004f08b28738)
    },
    {   UINT64_C(0x0000000000005b06), UINT64_C(0x1f430fce78b5c729), UINT64_C(0x1f43158eb4b5c71b),
        UINT64_C(0x1f43120eecb64738), UINT64_C(0x1f430b0ee0b42742)
    },
    {   UINT64_C(0x0000000000005b07), UINT64_C(0x0000000000000000), UINT64_C(0x1f43158ed8b4c729),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43104e54b28741)
    },
    {   UINT64_C(0x000000000000f82c), UINT64_C(0x00030717ec72a6d8), UINT64_C(0x0003070b6472a3b6),
        UINT64_C(0x000306cb647283b6), UINT64_C(0x1162f18c747b669b)
    },
    {   UINT64_C(0x000000000000f82d), UINT64_C(0x08d2f892e45c6613), UINT64_C(0x08d2f8d2e45c8613),
        UINT64_C(0x0002f1d0805045c6), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b0a), UINT64_C(0x1f42fe0e98b3e732), UINT64_C(0x1f430a4f58b38721),
        UINT64_C(0x1f43174f20b54721), UINT64_C(0x1f430d8ed8b94731)
    },
    {   UINT64_C(0x0000000000005e1c), UINT64_C(0x1f4308cf2ca8a6fe), UINT64_C(0x1f42f50fe8ad46c8),
        UINT64_C(0x1f42f4cf8cb806c3), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b0c), UINT64_C(0x1f4303ce70b46743), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430d4e70b4871d), UINT64_C(0x1f430d4e38b5c736)
    },
    {   UINT64_C(0x0000000000005b0d), UINT64_C(0x1f43088ee8baa716), UINT64_C(0x1f43384fb48806d7),
        UINT64_C(0x1f42ff0eccb726eb), UINT64_C(0x1f42fb4ee8b48716)
    },
    {   UINT64_C(0x0000000000005b0e), UINT64_C(0x1f43000efcb5272a), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430bcf24ad6700)
    },
    {   UINT64_C(0x0000000000005b0f), UINT64_C(0x0000000000000000), UINT64_C(0x1f4307cef4b606fc),
        UINT64_C(0x1f43088ffcb1a6c3), UINT64_C(0x1f43028fc8b606e3)
    },
    {   UINT64_C(0x0000000000005b10), UINT64_C(0x1f430b4f4cb086e2), UINT64_C(0x1f430c4ef4afa71c),
        UINT64_C(0x1f430d4e6cb82735), UINT64_C(0x1f43000ff4b5a6ce)
    },
    {   UINT64_C(0x0000000000005b11), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43118e98aea6eb), UINT64_C(0x1f430f1034ae86db)
    },
    {   UINT64_C(0x000000000000f836), UINT64_C(0x0c82fc4f6c696698), UINT64_C(0x09d2fb8fa05f067f),
        UINT64_C(0x0d4afb8fa06ce67f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000f837), UINT64_C(0x0000000000000000), UINT64_C(0x114b010fa07ae78a),
        UINT64_C(0x112afecfa07ac786), UINT64_C(0x182afecfa096c6e5)
    },
    {   UINT64_C(0x0000000000005b14), UINT64_C(0x1f430b0ee0a98710), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43054fc4afe6c8), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b15), UINT64_C(0x1f43080f58b2670b), UINT64_C(0x1f430a5000b166e6),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430c4f28b2a6f7)
    },
    {   UINT64_C(0x0000000000005b16), UINT64_C(0x0000000000000000), UINT64_C(0x1f430acec0b286e2),
        UINT64_C(0x1f43044ed0b046de), UINT64_C(0x1f430b4f8cb5e6cf)
    },
    {   UINT64_C(0x0000000000005e22), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f40f58ab86f4),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b18), UINT64_C(0x1f430a4fc4b80709), UINT64_C(0x1f430d8ed4b226de),
        UINT64_C(0x1f43030fe4b0e6e1), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000178cd), UINT64_C(0x0000000000000000), UINT64_C(0x0fe2f90c647ee6ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x0fcae08c648d26ef)
    },
    {   UINT64_C(0x00000000000151ce), UINT64_C(0x0f52f90c747d65b6), UINT64_C(0x10d2f90f8081c695),
        UINT64_C(0x0f7af50f7876e5b6), UINT64_C(0x0ec2f90c747fc695)
    },
    {   UINT64_C(0x0000000000005b1b), UINT64_C(0x0000000000000000), UINT64_C(0x1f43098f04aca6e5),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43078fa4ab06f8)
    },
    {   UINT64_C(0x0000000000005b1c), UINT64_C(0x1f43058ef0b7a702), UINT64_C(0x1f4308cfccb6a6e9),
        UINT64_C(0x1f43048fe8b606d7), UINT64_C(0x1f43098f98b706de)
    },
    {   UINT64_C(0x0000000000005b1d), UINT64_C(0x1f43058f24b186fb), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43028f70b3e6f1), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b1e), UINT64_C(0x1f430a4ee8b526e0), UINT64_C(0x1f430b5000ad26e7),
        UINT64_C(0x1f430e8f70b4270e), UINT64_C(0x1f43058eb8b26707)
    },
    {   UINT64_C(0x0000000000005b1f), UINT64_C(0x0000000000000000), UINT64_C(0x1f430d8f18b9073a),
        UINT64_C(0x1f42ff8f20b646de), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b20), UINT64_C(0x1f42f50e80b786e5), UINT64_C(0x1f43089028b266cf),
        UINT64_C(0x1f43064e7caf26f9), UINT64_C(0x1f430a4ff0b5e6db)
    },
    {   UINT64_C(0x0000000000005b21), UINT64_C(0x1f43024fd4b326de), UINT64_C(0x1f43009010b666c2),
        UINT64_C(0x1f43078f1cb5c6f7), UINT64_C(0x1f43068f94b5c70b)
    },
    {   UINT64_C(0x0000000000005b22), UINT64_C(0x1f43094fb0b52706), UINT64_C(0x1f43044f0cb746bf),
        UINT64_C(0x1f42f88ef4b5a6f9), UINT64_C(0x1f4307cf34b4a6eb)
    },
    {   UINT64_C(0x0000000000005b23), UINT64_C(0x1f42fbcf60b2a70c), UINT64_C(0x1f43089000b126db),
        UINT64_C(0x1f43054f9cb666e2), UINT64_C(0x1f430a8fb4b3c6e1)
    },
    {   UINT64_C(0x0000000000005b24), UINT64_C(0x1f43044e9cb8672f), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430e4fa4b5c70e), UINT64_C(0x1f430d8e94b0271f)
    },
    {   UINT64_C(0x000000000000d100), UINT64_C(0x1692f04fa094a69a), UINT64_C(0x14daf20fa08be68c),
        UINT64_C(0x1692fa4f5494669b), UINT64_C(0x1692f18fa094c68c)
    },
    {   UINT64_C(0x0000000000005b26), UINT64_C(0x1f430d5038b3e6da), UINT64_C(0x1f430c4e54b48723),
        UINT64_C(0x1f43094f9cb346cf), UINT64_C(0x1f430f4e6cb2871a)
    },
    {   UINT64_C(0x000000000000d102), UINT64_C(0x0c2af30fa06cc68c), UINT64_C(0x0fa2eece207a468c),
        UINT64_C(0x1852f58fa09ea68c), UINT64_C(0x14daf2cfa08e468c)
    },
    {   UINT64_C(0x0000000000005b28), UINT64_C(0x0000000000000000), UINT64_C(0x1f430e4fa4b5c6eb),
        UINT64_C(0x1f43004fe4b286de), UINT64_C(0x1f43088ed8ae871d)
    },
    {   UINT64_C(0x000000000000d104), UINT64_C(0x1852f6cce09b669b), UINT64_C(0x1692f48fa098068c),
        UINT64_C(0x1162f6cf547ea69c), UINT64_C(0x14daf5cfa08e068c)
    },
    {   UINT64_C(0x0000000000005b2a), UINT64_C(0x0000000000000000), UINT64_C(0x1f43088f98a90701),
        UINT64_C(0x1f430b8fe4a78703), UINT64_C(0x1f43064e7cb7871b)
    },
    {   UINT64_C(0x000000000000d106), UINT64_C(0x1692f1cfa095e68c), UINT64_C(0x14daf50fa08dc68c),
        UINT64_C(0x0fa2f44f687b85c1), UINT64_C(0x1162f24f687fa68c)
    },
    {   UINT64_C(0x0000000000005b2c), UINT64_C(0x1f430ccfc4ad26cf), UINT64_C(0x1f43078fb4abc705),
        UINT64_C(0x1f43068fc4b24705), UINT64_C(0x1f430f4eecb466e3)
    },
    {   UINT64_C(0x0000000000005b2d), UINT64_C(0x1f4303ce74b78715), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43078f94aae6bf), UINT64_C(0x1f430b8f6cb0e700)
    },
    {   UINT64_C(0x0000000000005b2e), UINT64_C(0x1f43078e8cb00733), UINT64_C(0x1f430a4f8cae6702),
        UINT64_C(0x1f43038fc0ad66d3), UINT64_C(0x1f430a4f98ac06fd)
    },
    {   UINT64_C(0x000000000000d10a), UINT64_C(0x0fa2f44f687a05c1), UINT64_C(0x1162f2cc6c8005c1),
        UINT64_C(0x1162f68c6c8185c1), UINT64_C(0x0de2f50fa074c5c1)
    },
    {   UINT64_C(0x000000000000d10b), UINT64_C(0x0c2af44f686ba5c1), UINT64_C(0x0a6af2cf7068065e),
        UINT64_C(0x1162f20f6881c5b5), UINT64_C(0x0fa2f34f687b25b5)
    },
    {   UINT64_C(0x000000000000d10c), UINT64_C(0x1692f3cf6896e5b5), UINT64_C(0x0fa2f10fa07b05b5),
        UINT64_C(0x0fa2f20c6c7ac5b5), UINT64_C(0x0de2f34fa07305b5)
    },
    {   UINT64_C(0x0000000000005b32), UINT64_C(0x0000000000000000), UINT64_C(0x1f4307ce7cb64737),
        UINT64_C(0x1f430f502ca98700), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b33), UINT64_C(0x1f430b9038b3c6d1), UINT64_C(0x1f43044e7cb88703),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430b4fa0a8a6e9)
    },
    {   UINT64_C(0x0000000000005b34), UINT64_C(0x1f43010ff0adc6d0), UINT64_C(0x1f43058f90ae66d8),
        UINT64_C(0x1f43084fe0b626dc), UINT64_C(0x1f43038ee8ae66cc)
    },
    {   UINT64_C(0x0000000000005b35), UINT64_C(0x1f43044f38af26f9), UINT64_C(0x1f430e0ff0b40725),
        UINT64_C(0x1f43048e4cada6f0), UINT64_C(0x1f43059018aec6d4)
    },
    {   UINT64_C(0x0000000000005b36), UINT64_C(0x0000000000000000), UINT64_C(0x1f430b4eb8b1e6e6),
        UINT64_C(0x1f43058fdcb466c0), UINT64_C(0x1f4307900cb646f8)
    },
    {   UINT64_C(0x0000000000005b37), UINT64_C(0x1f430d4fc0b1a6df), UINT64_C(0x1f43060e6caf4709),
        UINT64_C(0x1f430a4f1cb48706), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b38), UINT64_C(0x1f43038ed8b7a6f7), UINT64_C(0x1f43094f6cb32716),
        UINT64_C(0x1f4309cf2cb68719), UINT64_C(0x1f430c4fb0b2c6db)
    },
    {   UINT64_C(0x00000000000178dd), UINT64_C(0x0000000000000000), UINT64_C(0x11cae18bf48886ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x11daf98c6482e6ef)
    },
    {   UINT64_C(0x00000000000067e1), UINT64_C(0x1f42fcceecb646fe), UINT64_C(0x1f42fcd000b466f6),
        UINT64_C(0x1f42fe9014ad06ee), UINT64_C(0x1f42fa8ff4b646d2)
    },
    {   UINT64_C(0x0000000000005b3b), UINT64_C(0x1f43048fd8b4c6ea), UINT64_C(0x1f43098ee8b0a6e5),
        UINT64_C(0x1f43068e98aca6fd), UINT64_C(0x1f43034f44b546d9)
    },
    {   UINT64_C(0x0000000000005b3c), UINT64_C(0x1f42ff8e58b7e749), UINT64_C(0x1f43038f8cb24704),
        UINT64_C(0x1f430b4eccace6f7), UINT64_C(0x1f43040ef4b9271e)
    },
    {   UINT64_C(0x00000000000178df), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x18c2e40bf49fa6ef), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b3e), UINT64_C(0x1f430a4f88a6a71e), UINT64_C(0x1f430a4fc0b6a6ce),
        UINT64_C(0x1f43094f48ae26d7), UINT64_C(0x1f43088f58aca6da)
    },
    {   UINT64_C(0x0000000000005e36), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f6cf34b7471f),
        UINT64_C(0x1f42f40e5cb2c733), UINT64_C(0x1f430b8e60ad472c)
    },
    {   UINT64_C(0x0000000000005b40), UINT64_C(0x1f43050ef0b066ef), UINT64_C(0x1f43078f58aa8706),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4305cf84b066ee)
    },
    {   UINT64_C(0x0000000000005b41), UINT64_C(0x1f43040ffcad06d4), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43058f98a786c5)
    },
    {   UINT64_C(0x0000000000005b42), UINT64_C(0x1f43060f90acc703), UINT64_C(0x1f4302d014aa66ed),
        UINT64_C(0x1f43070ef8b0e6f4), UINT64_C(0x1f43114e4cb2c72e)
    },
    {   UINT64_C(0x0000000000005b43), UINT64_C(0x1f43038ef4a8e6f1), UINT64_C(0x1f430a4f90abe6d6),
        UINT64_C(0x1f43078fb8a2a704), UINT64_C(0x1f43078fb8af46c4)
    },
    {   UINT64_C(0x0000000000005b44), UINT64_C(0x1f43040f20b226d5), UINT64_C(0x1f43008fc8b826df),
        UINT64_C(0x1f43065000ae06e7), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000040e7), UINT64_C(0x1f42fad080b266f1), UINT64_C(0x1f430ed080ace6f1),
        UINT64_C(0x1f430b5088a966ed), UINT64_C(0x1f43151050a6a6f1)
    },
    {   UINT64_C(0x0000000000005b46), UINT64_C(0x1f43078ed8a9e6fe), UINT64_C(0x1f43004e7cb6a724),
        UINT64_C(0x1f4305ce3cb84712), UINT64_C(0x1f43090f68b7a71c)
    },
    {   UINT64_C(0x00000000000040e8), UINT64_C(0x1f4316d080a4c6f1), UINT64_C(0x1f431a5080a2e6f1),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430a5080ab06f1)
    },
    {   UINT64_C(0x0000000000005b48), UINT64_C(0x1f43068e4caf2704), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43058f64b6e6cb), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000040e9), UINT64_C(0x1f430e5080abc6f1), UINT64_C(0x1f43141080a886f1),
        UINT64_C(0x1f43139080a8c6f1), UINT64_C(0x1f430bd080ac66f1)
    },
    {   UINT64_C(0x0000000000005b4a), UINT64_C(0x1f43058fa0b7c703), UINT64_C(0x1f43104e50b1c710),
        UINT64_C(0x1f430ccf9cb44702), UINT64_C(0x1f43019000b626df)
    },
    {   UINT64_C(0x00000000000040ea), UINT64_C(0x1f42f85080b666f1), UINT64_C(0x1f430f1080a906f1),
        UINT64_C(0x1f43474ffc8ee6ee), UINT64_C(0x1f43198fcca5c70b)
    },
    {   UINT64_C(0x0000000000005b4c), UINT64_C(0x1f430c0fa4b0c6c7), UINT64_C(0x1f4308ce5cb3e6c1),
        UINT64_C(0x1f43094f28aa06ff), UINT64_C(0x1f43040fccafe6eb)
    },
    {   UINT64_C(0x00000000000040eb), UINT64_C(0x1f43230fa0a106b7), UINT64_C(0x1f433e4fa093669c),
        UINT64_C(0x1f432d0da49c06d3), UINT64_C(0x1f4349cfa08da6cf)
    },
    {   UINT64_C(0x0000000000005b4e), UINT64_C(0x1f43038f58b58703), UINT64_C(0x1f430b0fccb146b8),
        UINT64_C(0x1f43074f3ca7c710), UINT64_C(0x1f430d5050b3e70f)
    },
    {   UINT64_C(0x00000000000040ec), UINT64_C(0x1f432c0fa09c8748), UINT64_C(0x1f431a5050a7c5f4),
        UINT64_C(0x1f43104e5ca5e6e6), UINT64_C(0x1f43360e2c9dc5fa)
    },
    {   UINT64_C(0x00000000000151e9), UINT64_C(0x14fb04cfa0a2669b), UINT64_C(0x1a1b000fa0a6e68c),
        UINT64_C(0x1722f30fa0a6a68c), UINT64_C(0x18bb0d4fa0af269b)
    },
    {   UINT64_C(0x00000000000040ed), UINT64_C(0x1f432390509f26e6), UINT64_C(0x1f4339105097c5f1),
        UINT64_C(0x1f432a8e449bc721), UINT64_C(0x1f4322ce449ce5f5)
    },
    {   UINT64_C(0x000000000000a9e4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x16f2f28f6896068c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000040ee), UINT64_C(0x1f432c90509b26e6), UINT64_C(0x1f4346d05090461c),
        UINT64_C(0x1f4324d044a125f9), UINT64_C(0x1f4324d0509b86e5)
    },
    {   UINT64_C(0x00000000000151eb), UINT64_C(0x106b030c7085e5c1), UINT64_C(0x0fdaf58f6882e69c),
        UINT64_C(0x0fc2f94f687e05c1), UINT64_C(0x0f02fa4c6c81e69c)
    },
    {   UINT64_C(0x0000000000005b55), UINT64_C(0x1f4307cf0cad86e3), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b56), UINT64_C(0x1f43074f88b066d7), UINT64_C(0x1f4308ce7cb6c73b),
        UINT64_C(0x1f430b4ef8b6e71a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b57), UINT64_C(0x1f43058fb4b36703), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430a4f7cb206c3), UINT64_C(0x1f43068fdcb1c6cf)
    },
    {   UINT64_C(0x0000000000005b58), UINT64_C(0x1f43088e4caa470b), UINT64_C(0x1f43060e88b1e72e),
        UINT64_C(0x1f430c4f9cae86d7), UINT64_C(0x1f43094f7cb2071a)
    },
    {   UINT64_C(0x0000000000014840), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x164af6cf68968695), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b5a), UINT64_C(0x1f43068f1cb346eb), UINT64_C(0x1f430a4f58b5870a),
        UINT64_C(0x1f430a8ed8b6e736), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000014841), UINT64_C(0x0000000000000000), UINT64_C(0x1a7afb0f68a1e693),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b5c), UINT64_C(0x1f43038e68ad46e5), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000014842), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x199af4cc209ee5b6), UINT64_C(0x249afe4f4ccec6a3)
    },
    {   UINT64_C(0x0000000000005b5e), UINT64_C(0x1f43098f24b52711), UINT64_C(0x1f430c4f94b72713),
        UINT64_C(0x1f4302ced4b1a6e6), UINT64_C(0x1f4307cf50a9e6bc)
    },
    {   UINT64_C(0x0000000000005b5f), UINT64_C(0x1f43068f30b30718), UINT64_C(0x1f430b0f20b4c711),
        UINT64_C(0x1f43098f1cabe6fa), UINT64_C(0x1f430c4f58a606d4)
    },
    {   UINT64_C(0x00000000000151f1), UINT64_C(0x0ea2f94f687945c1), UINT64_C(0x121afb8f6886e69c),
        UINT64_C(0x1432eb8f7891a5c1), UINT64_C(0x1532fa0c6c90469c)
    },
    {   UINT64_C(0x0000000000005b61), UINT64_C(0x1f430a4e30b3e728), UINT64_C(0x1f430b4f5cb166cc),
        UINT64_C(0x1f43038eacb526cd), UINT64_C(0x1f430d0f84b146d8)
    },
    {   UINT64_C(0x0000000000005b62), UINT64_C(0x1f430e4ee0a86712), UINT64_C(0x1f430f4e60ae8724),
        UINT64_C(0x1f4307cfd0b166d4), UINT64_C(0x1f43088fecae66ef)
    },
    {   UINT64_C(0x0000000000005b63), UINT64_C(0x1f43074eb0a586f6), UINT64_C(0x1f43094edcae26fb),
        UINT64_C(0x1f43059008b746f5), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b64), UINT64_C(0x1f43028f1cabe6eb), UINT64_C(0x1f43094eacb82716),
        UINT64_C(0x1f43088f5cb266df), UINT64_C(0x1f430d4f0ca4e6fc)
    },
    {   UINT64_C(0x0000000000005b65), UINT64_C(0x1f42fbce80b6072e), UINT64_C(0x1f43094e88b0473e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4304cf80b026ff)
    },
    {   UINT64_C(0x0000000000005b66), UINT64_C(0x1f43068fa4ac06ec), UINT64_C(0x1f4303cfc0b0c6f6),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43040ec4aea720)
    },
    {   UINT64_C(0x0000000000005b67), UINT64_C(0x1f43070fe0af0737), UINT64_C(0x1f430a4f38af871e),
        UINT64_C(0x1f43068ef8b44712), UINT64_C(0x1f43018f74b24708)
    },
    {   UINT64_C(0x0000000000005b68), UINT64_C(0x1f43064f3cab86d7), UINT64_C(0x1f430d4fccaaa6f4),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430c4fe0b2a70a)
    },
    {   UINT64_C(0x0000000000005b69), UINT64_C(0x1f43098edcb36719), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43078f2ca9e6d0), UINT64_C(0x1f43084f4ca8e6d3)
    },
    {   UINT64_C(0x0000000000005b6a), UINT64_C(0x1f43038ff0b626ea), UINT64_C(0x1f43084fc4ade6d7),
        UINT64_C(0x1f43044f88b06712), UINT64_C(0x1f43124edcb006ee)
    },
    {   UINT64_C(0x0000000000005b6b), UINT64_C(0x1f430f4eb8ae672a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43060edcab86fc), UINT64_C(0x1f430b0f24b2c6f8)
    },
    {   UINT64_C(0x0000000000005b6c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430b4f74b8670b), UINT64_C(0x1f430a4fa4ade6fe)
    },
    {   UINT64_C(0x0000000000005b6d), UINT64_C(0x1f430d0fa0aea6f2), UINT64_C(0x1f4306cfe8ae06d6),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43068ef8b2470e)
    },
    {   UINT64_C(0x0000000000005b6e), UINT64_C(0x1f430b4fe8aae6da), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43098fe0aa26d8), UINT64_C(0x1f43088f28b4e70f)
    },
    {   UINT64_C(0x000000000001484b), UINT64_C(0x2122fbcf4cb9a6a3), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x16b2f6cf688f85b6)
    },
    {   UINT64_C(0x0000000000005b70), UINT64_C(0x1f430b4f60b2070d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430e0f14b166f7), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001484c), UINT64_C(0x19d305cf4ca166a3), UINT64_C(0x2092fe4f4cbea6a3),
        UINT64_C(0x0000000000000000), UINT64_C(0x28a2fd0f4cda26a3)
    },
    {   UINT64_C(0x0000000000005b72), UINT64_C(0x1f43038fccade6e2), UINT64_C(0x1f43094f68b166e0),
        UINT64_C(0x1f43124ff4aae70a), UINT64_C(0x1f42ff8ef8b8a711)
    },
    {   UINT64_C(0x000000000000d14e), UINT64_C(0x189afa8fa09aa68c), UINT64_C(0x16cb00cfa092268c),
        UINT64_C(0x0000000000000000), UINT64_C(0x176300cfa096668c)
    },
    {   UINT64_C(0x000000000000f898), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x105af48f787c858e)
    },
    {   UINT64_C(0x000000000000f899), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x105b09cfa0730591)
    },
    {   UINT64_C(0x000000000000d151), UINT64_C(0x1c9300cfa0a7668c), UINT64_C(0x0000000000000000),
        UINT64_C(0x189af94f549b469b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000f89b), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x105af5cc887a4590)
    },
    {   UINT64_C(0x000000000000d153), UINT64_C(0x1712ff8f5492068c), UINT64_C(0x139af24fa096868c),
        UINT64_C(0x1f22f24fa0bd668c), UINT64_C(0x18d2f30fa09ea68c)
    },
    {   UINT64_C(0x000000000000f89d), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x105afa4c8879c58d)
    },
    {   UINT64_C(0x000000000000f89e), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x105af34f807d464e)
    },
    {   UINT64_C(0x000000000000f89f), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x105af00c887de58d)
    },
    {   UINT64_C(0x000000000000f8a0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x105af5cf707c2646)
    },
    {   UINT64_C(0x000000000000f8a1), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x105af44c787ce58d)
    },
    {   UINT64_C(0x0000000000005b7e), UINT64_C(0x0000000000000000), UINT64_C(0x1f430a4eb8b7a73c),
        UINT64_C(0x1f430c4ee8b2072a), UINT64_C(0x1f43058f6cba8715)
    },
    {   UINT64_C(0x000000000000f8a3), UINT64_C(0x0000000000000000), UINT64_C(0x00030517307cc6c6),
        UINT64_C(0x0000000000000000), UINT64_C(0x0a2aedcfa0674497)
    },
    {   UINT64_C(0x000000000000d15b), UINT64_C(0x1ac2fa8f3ca326a5), UINT64_C(0x1a8afa8f54a1c6a5),
        UINT64_C(0x182afb8f5499e6a5), UINT64_C(0x1bdafb8f54a706a5)
    },
    {   UINT64_C(0x0000000000005b81), UINT64_C(0x0000000000000000), UINT64_C(0x1f430b4e70b54748),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43088ed8ae471e)
    },
    {   UINT64_C(0x000000000000d15d), UINT64_C(0x18b2fb8f3c9a66a5), UINT64_C(0x191afb8c6c9c06a5),
        UINT64_C(0x1b02f88f3ca446a5), UINT64_C(0x15dafacf3c8f26a5)
    },
    {   UINT64_C(0x000000000000d15e), UINT64_C(0x236afa8f3cc5a6a5), UINT64_C(0x1af2fa8f3ca3c6a5),
        UINT64_C(0x1c6afb8f54a946a5), UINT64_C(0x1a92fa8c6ca1e6a5)
    },
    {   UINT64_C(0x0000000000005b84), UINT64_C(0x1f4308ced8b12709), UINT64_C(0x1f43078f84b066e4),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4304cf88b0272a)
    },
    {   UINT64_C(0x000000000000d160), UINT64_C(0x1ae2fb8f3ca3a6a5), UINT64_C(0x1abafa8f54a286a5),
        UINT64_C(0x230afa8f54c3c6a5), UINT64_C(0x199afa8f3c9f66a5)
    },
    {   UINT64_C(0x000000000000d161), UINT64_C(0x1a2afa8c6ca046a5), UINT64_C(0x179af90c949666a5),
        UINT64_C(0x12c2fbcf4082a5c3), UINT64_C(0x117af94f407d869f)
    },
    {   UINT64_C(0x000000000000d162), UINT64_C(0x0e82fbcf407205c3), UINT64_C(0x116afa0f3c7d469e),
        UINT64_C(0x0ee2fbcf4073e5c3), UINT64_C(0x0b92f64c486a86a4)
    },
    {   UINT64_C(0x000000000000d163), UINT64_C(0x11b2fbcc347dc5c3), UINT64_C(0x1202f94c347f069f),
        UINT64_C(0x0d6af6cf406de6a1), UINT64_C(0x0c2af80c3468a6a1)
    },
    {   UINT64_C(0x0000000000004109), UINT64_C(0x1f432c90c89c468e), UINT64_C(0x1f432c50c89d668e),
        UINT64_C(0x1f43270f689e468e), UINT64_C(0x1f4328d0c897c68e)
    },
    {   UINT64_C(0x000000000000d165), UINT64_C(0x1152f94f407ce5c3), UINT64_C(0x1402f70c3487a639),
        UINT64_C(0x11f2fbcc347fc5c3), UINT64_C(0x106af80f407c25c3)
    },
    {   UINT64_C(0x000000000000d166), UINT64_C(0x116afb0f247da66b), UINT64_C(0x0db2f94f446dc678),
        UINT64_C(0x154af6cf408d25c3), UINT64_C(0x11eafbcf40804639)
    },
    {   UINT64_C(0x000000000000d167), UINT64_C(0x1a92fbcf40a1e639), UINT64_C(0x104afa8c5c7ba5c3),
        UINT64_C(0x12a2fbcc34818639), UINT64_C(0x0f22f70c347525c3)
    },
    {   UINT64_C(0x000000000000410b), UINT64_C(0x1f432c90c499068e), UINT64_C(0x1f4330109c94e698),
        UINT64_C(0x1f4311109ca18698), UINT64_C(0x1f432690a09a868e)
    },
    {   UINT64_C(0x0000000000005b8e), UINT64_C(0x1f4306cf10b4c71f), UINT64_C(0x1f430b8f14ad671c),
        UINT64_C(0x1f43048efcb7c711), UINT64_C(0x1f43058eb0ad6706)
    },
    {   UINT64_C(0x000000000000410c), UINT64_C(0x1f4337d09c96a5cc), UINT64_C(0x1f4337d09c96c68e),
        UINT64_C(0x1f433810c49685cc), UINT64_C(0x1f433810c89685cd)
    },
    {   UINT64_C(0x0000000000005b90), UINT64_C(0x1f43060f64b786f6), UINT64_C(0x1f42fd0f2cb446ff),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbce8cb406ec)
    },
    {   UINT64_C(0x0000000000005b91), UINT64_C(0x1f43030f5ca38702), UINT64_C(0x1f43070e6cb4c725),
        UINT64_C(0x1f430c8ea0b0071a), UINT64_C(0x1f430c8e44afe717)
    },
    {   UINT64_C(0x0000000000005b92), UINT64_C(0x0000000000000000), UINT64_C(0x1f43058efcafa6f3),
        UINT64_C(0x1f43078f08b8e738), UINT64_C(0x1f430b4e2cb1a738)
    },
    {   UINT64_C(0x0000000000005b93), UINT64_C(0x0000000000000000), UINT64_C(0x1f43084eb8ace70b),
        UINT64_C(0x1f43008ffcace6c2), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b94), UINT64_C(0x0000000000000000), UINT64_C(0x1f4306ceb4b16710),
        UINT64_C(0x1f43098e1cb36728), UINT64_C(0x1f43068fb8b7a70d)
    },
    {   UINT64_C(0x0000000000005b95), UINT64_C(0x1f430c4ea4b00703), UINT64_C(0x1f43064f24af8702),
        UINT64_C(0x1f43084f30af072f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005b96), UINT64_C(0x1f43028f0cac6708), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fecf48b746fe), UINT64_C(0x1f430d4f10b4673d)
    },
    {   UINT64_C(0x0000000000005b97), UINT64_C(0x1f43094f70b306ec), UINT64_C(0x1f43094ef4ab471d),
        UINT64_C(0x1f430c8f10a3670e), UINT64_C(0x1f43094f44b2a71c)
    },
    {   UINT64_C(0x0000000000005b98), UINT64_C(0x1f430a4fa4b24711), UINT64_C(0x1f43098f98aca6d7),
        UINT64_C(0x1f430f0f50af46e4), UINT64_C(0x1f43058ee0af66f1)
    },
    {   UINT64_C(0x0000000000005b99), UINT64_C(0x1f43029028b0c6f4), UINT64_C(0x1f430acfb8ade715),
        UINT64_C(0x1f43078fa4ae66f3), UINT64_C(0x1f430c4e4caaa735)
    },
    {   UINT64_C(0x0000000000005b9a), UINT64_C(0x1f430b4fa0ae46ef), UINT64_C(0x1f430d0f90ab8704),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43034fa8b6c6dd)
    },
    {   UINT64_C(0x000000000000f8bf), UINT64_C(0x0000000000000000), UINT64_C(0x1692f04bf494a6ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x14daf20bf48be6ef)
    },
    {   UINT64_C(0x000000000000d177), UINT64_C(0x0dc2fe4fa06d668c), UINT64_C(0x0f0af1ce2071468c),
        UINT64_C(0x1643020fa096e68c), UINT64_C(0x12db020fa087e68c)
    },
    {   UINT64_C(0x000000000000f8c1), UINT64_C(0x0000000000000000), UINT64_C(0x14daf20bf48ea6ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x14daf50bf48dc6ef)
    },
    {   UINT64_C(0x0000000000005b9e), UINT64_C(0x1f43084f70b2a722), UINT64_C(0x1f43088f38b0c6d7),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000d17a), UINT64_C(0x15db00cf548c868c), UINT64_C(0x1592f44f5891a68c),
        UINT64_C(0x1f2af58f64b7668c), UINT64_C(0x1722f80fa096068c)
    },
    {   UINT64_C(0x0000000000005ba0), UINT64_C(0x1f4303cef0b0a715), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43094ef8ade70f), UINT64_C(0x1f43098eccb00724)
    },
    {   UINT64_C(0x000000000000f8c5), UINT64_C(0x0000000000000000), UINT64_C(0x1692f20bf49626ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x143af80c648a66ef)
    },
    {   UINT64_C(0x000000000000f8c6), UINT64_C(0x0000000000000000), UINT64_C(0x1852f6cbf49b66ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x1852f34c649d66ef)
    },
    {   UINT64_C(0x0000000000005ba3), UINT64_C(0x1f42fb4f04b4e71d), UINT64_C(0x1f43080ed0ae06e9),
        UINT64_C(0x1f42ffcf68b2e6e3), UINT64_C(0x1f4303cefcb1e719)
    },
    {   UINT64_C(0x0000000000005ba4), UINT64_C(0x1f43098f0caee6f3), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43058ee0b48712), UINT64_C(0x1f43094e7cb6872e)
    },
    {   UINT64_C(0x000000000000d180), UINT64_C(0x0c0af44f6c6b25c1), UINT64_C(0x0c12efcf706ce65e),
        UINT64_C(0x1032fbcf647865b5), UINT64_C(0x0e72f1cf687665b5)
    },
    {   UINT64_C(0x0000000000005ba6), UINT64_C(0x1f43098f3cb0471e), UINT64_C(0x1f43048e98b6870a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43068f04b62706)
    },
    {   UINT64_C(0x0000000000005ba7), UINT64_C(0x1f43048f40abe708), UINT64_C(0x1f43084ea0b5a747),
        UINT64_C(0x1f43088f44b6e6e5), UINT64_C(0x1f43024f04ae86ef)
    },
    {   UINT64_C(0x0000000000005ba8), UINT64_C(0x1f43078f1cb2c71d), UINT64_C(0x1f43068ee4b106f9),
        UINT64_C(0x1f43079044ae6702), UINT64_C(0x1f4303cf7cb786d4)
    },
    {   UINT64_C(0x0000000000005ba9), UINT64_C(0x1f43098f04aea6e8), UINT64_C(0x1f430a4e80b38734),
        UINT64_C(0x1f4302cf88b6c6fb), UINT64_C(0x1f43034f24b5e716)
    },
    {   UINT64_C(0x0000000000005baa), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43080f64b36734), UINT64_C(0x1f43059044b226e6)
    },
    {   UINT64_C(0x0000000000005bab), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43078ec8adc6f3), UINT64_C(0x1f43048f40aca709)
    },
    {   UINT64_C(0x0000000000005bac), UINT64_C(0x1f43098f4cac6700), UINT64_C(0x1f43020eccb34730),
        UINT64_C(0x1f43028edcb66729), UINT64_C(0x1f430c8f2ca4c6f9)
    },
    {   UINT64_C(0x0000000000005bad), UINT64_C(0x1f43088ee8b66739), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43078f1cb8c719), UINT64_C(0x1f43008f0ca866d8)
    },
    {   UINT64_C(0x0000000000005bae), UINT64_C(0x0000000000000000), UINT64_C(0x1f43098e60b1c723),
        UINT64_C(0x1f43090f58aba6f5), UINT64_C(0x1f43088f68a6c707)
    },
    {   UINT64_C(0x0000000000005baf), UINT64_C(0x1f430a4f80af4701), UINT64_C(0x1f43028ee0aee708),
        UINT64_C(0x1f43078f20b5a70d), UINT64_C(0x1f4302cea8b306fe)
    },
    {   UINT64_C(0x0000000000005bb0), UINT64_C(0x1f43084ee4aaa712), UINT64_C(0x1f43058ef4b546c6),
        UINT64_C(0x1f43028e94afc738), UINT64_C(0x1f43078e94b1e705)
    },
    {   UINT64_C(0x0000000000005bb1), UINT64_C(0x1f43044ea0b7a732), UINT64_C(0x1f430a4f08b6c728),
        UINT64_C(0x1f43078f54ada6df), UINT64_C(0x1f4305ceb4afc725)
    },
    {   UINT64_C(0x0000000000005bb2), UINT64_C(0x1f43028f3caa270b), UINT64_C(0x1f4307cf10b506fc),
        UINT64_C(0x1f43054e74b26712), UINT64_C(0x1f43071020a9a6ff)
    },
    {   UINT64_C(0x0000000000005bb3), UINT64_C(0x1f43038f20b7c71b), UINT64_C(0x1f43088f64ad26fa),
        UINT64_C(0x1f43064e70ad6701), UINT64_C(0x1f43058f38b306dd)
    },
    {   UINT64_C(0x0000000000005bb4), UINT64_C(0x1f43074ee0ab06e9), UINT64_C(0x1f430a4e9cb44725),
        UINT64_C(0x1f43078f14afe6dc), UINT64_C(0x1f43084e5caf0735)
    },
    {   UINT64_C(0x0000000000005bb5), UINT64_C(0x1f43064fa0ad2719), UINT64_C(0x1f42f64e90b82731),
        UINT64_C(0x1f43054ef4b1a71a), UINT64_C(0x1f430b4fe0b2070f)
    },
    {   UINT64_C(0x000000000000f8da), UINT64_C(0x0000000000000000), UINT64_C(0x14daeacbf49246ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005bb7), UINT64_C(0x1f43084ebcb6471c), UINT64_C(0x1f43094eb4ade713),
        UINT64_C(0x1f43038eacae470f), UINT64_C(0x1f4306cf48b4a6f3)
    },
    {   UINT64_C(0x0000000000005bb8), UINT64_C(0x1f43068ff0b566f8), UINT64_C(0x1f43098f24ad0703),
        UINT64_C(0x1f430a4fe0ac8713), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005bb9), UINT64_C(0x1f430b4fe0b08702), UINT64_C(0x1f43079018aec6fb),
        UINT64_C(0x1f430a4f08b24713), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005bba), UINT64_C(0x1f43048fa0ade71c), UINT64_C(0x1f4307cf74b206f8),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fcce68b6e710)
    },
    {   UINT64_C(0x0000000000005bbb), UINT64_C(0x1f43090e8cb6872a), UINT64_C(0x1f43058ed8af66f0),
        UINT64_C(0x1f43010f88b3e706), UINT64_C(0x1f43018e9cb3073c)
    },
    {   UINT64_C(0x0000000000005bbc), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff8f4cb20706),
        UINT64_C(0x1f430bce90b7074e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005bbd), UINT64_C(0x1f430c0eeca7e722), UINT64_C(0x1f43058f2cac06fb),
        UINT64_C(0x1f42fb4f48b8070c), UINT64_C(0x1f43058e90a86709)
    },
    {   UINT64_C(0x0000000000005bbe), UINT64_C(0x1f4301ce6cb86715), UINT64_C(0x1f4305cee8ab0725),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43040f60ac6715)
    },
    {   UINT64_C(0x0000000000005bbf), UINT64_C(0x1f43014f04b3872c), UINT64_C(0x1f42ffced4ae273d),
        UINT64_C(0x1f430a8f34b7e739), UINT64_C(0x1f43038ea8ade72a)
    },
    {   UINT64_C(0x0000000000005bc0), UINT64_C(0x1f4301ce5cae8712), UINT64_C(0x1f430b8f68b34725),
        UINT64_C(0x1f430b0ed0ae8723), UINT64_C(0x1f43014f48b5270a)
    },
    {   UINT64_C(0x0000000000005bc1), UINT64_C(0x0000000000000000), UINT64_C(0x1f43038e6cb36728),
        UINT64_C(0x1f43030e80b84724), UINT64_C(0x1f42fccf34b5c6f5)
    },
    {   UINT64_C(0x0000000000005bc2), UINT64_C(0x1f43008f24b58700), UINT64_C(0x1f43018f54b1e71b),
        UINT64_C(0x1f43050ee4b1c711), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005bc3), UINT64_C(0x0000000000000000), UINT64_C(0x1f43048fc4a9c6d0),
        UINT64_C(0x1f42ff8f64b546e6), UINT64_C(0x1f430bcf6cb04700)
    },
    {   UINT64_C(0x0000000000005bc4), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f74ff0b706e1),
        UINT64_C(0x1f42ff8f7cae46ec), UINT64_C(0x1f43068e68aa4729)
    },
    {   UINT64_C(0x0000000000005bc5), UINT64_C(0x1f430d4f40b26731), UINT64_C(0x1f43078eb0ab473e),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005bc6), UINT64_C(0x1f4301cec0b3670b), UINT64_C(0x1f43070ee4b2c728),
        UINT64_C(0x1f43030efcabe6cc), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005bc7), UINT64_C(0x1f43000f44b5e723), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43068f28b34724), UINT64_C(0x1f43058fa8ad870b)
    },
    {   UINT64_C(0x0000000000005bc8), UINT64_C(0x1f43088f48b1c734), UINT64_C(0x1f43048ed4aac71e),
        UINT64_C(0x1f43088f88b2e736), UINT64_C(0x1f43048ee8b70715)
    },
    {   UINT64_C(0x000000000000f8ed), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x106af80f747ac691)
    },
    {   UINT64_C(0x0000000000005bca), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb8f48b64703),
        UINT64_C(0x1f43020e9cb2c72b), UINT64_C(0x1f43094f08b6c721)
    },
    {   UINT64_C(0x000000000000f8ef), UINT64_C(0x106afb0f74794686), UINT64_C(0x106af8cf747a6691),
        UINT64_C(0x106af8cf747a6696), UINT64_C(0x106af8cf747a6691)
    },
    {   UINT64_C(0x000000000000f8f0), UINT64_C(0x106af8cf747a6691), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1772ff0bd493e6d3)
    },
    {   UINT64_C(0x000000000000f8f1), UINT64_C(0x1772ff0bd493e6d3), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005bce), UINT64_C(0x1f43068e7cb74739), UINT64_C(0x1f43030ea4aba70c),
        UINT64_C(0x1f43040f28b44717), UINT64_C(0x1f43014eb0b6270a)
    },
    {   UINT64_C(0x0000000000005bcf), UINT64_C(0x1f43048eb8ad6723), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43060e8cb70739), UINT64_C(0x1f430e8e5cb2c740)
    },
    {   UINT64_C(0x0000000000005bd0), UINT64_C(0x1f43048efcab26f6), UINT64_C(0x1f42fd0fb4af6700),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42faceccb3a714)
    },
    {   UINT64_C(0x0000000000005bd1), UINT64_C(0x0000000000000000), UINT64_C(0x1f430c8f60ac4719),
        UINT64_C(0x1f43074ee0ac6716), UINT64_C(0x1f43048e7cad6721)
    },
    {   UINT64_C(0x0000000000005bd2), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4305901cb6a6e6)
    },
    {   UINT64_C(0x0000000000005bd3), UINT64_C(0x0000000000000000), UINT64_C(0x1f43030e9cb366ed),
        UINT64_C(0x1f42ff8fb8b726df), UINT64_C(0x1f43088ea8a9a713)
    },
    {   UINT64_C(0x000000000000d1af), UINT64_C(0x1692eecfa095e69c), UINT64_C(0x1a22f28fa0a4c68c),
        UINT64_C(0x175af20fa095e68c), UINT64_C(0x1902eecfa0a0a69c)
    },
    {   UINT64_C(0x000000000000d1b0), UINT64_C(0x1852f6cfa098e69c), UINT64_C(0x159af20f6890868c),
        UINT64_C(0x1422f44f688bc5c1), UINT64_C(0x1162f94c6c80069c)
    },
    {   UINT64_C(0x000000000000d1b1), UINT64_C(0x1032f10c6c7d25c1), UINT64_C(0x0fb2f48f687a269c),
        UINT64_C(0x0de2f50f687425c1), UINT64_C(0x0e5af3cc6c75269c)
    },
    {   UINT64_C(0x000000000000d1b2), UINT64_C(0x1222f10c6c82a5c1), UINT64_C(0x0faaf44f687a069c),
        UINT64_C(0x0a32f1cf686485b5), UINT64_C(0x122af34fa08465c1)
    },
    {   UINT64_C(0x000000000000d1b3), UINT64_C(0x1112f2cf5880669c), UINT64_C(0x1312f94c6c8805b5),
        UINT64_C(0x1032f1cf687c65c1), UINT64_C(0x0e8af3cc6c75669c)
    },
    {   UINT64_C(0x0000000000005bd9), UINT64_C(0x1f43078f4caa66f5), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430b4e70b8e73f), UINT64_C(0x1f43088ed4ad672d)
    },
    {   UINT64_C(0x000000000000d1b5), UINT64_C(0x11c2f44f6880a5b5), UINT64_C(0x0f62f28f6877a5b5),
        UINT64_C(0x1202f10f688365c1), UINT64_C(0x146af40c6c8d25c1)
    },
    {   UINT64_C(0x0000000000005bdb), UINT64_C(0x1f43034e6cb2e728), UINT64_C(0x1f430c0e4cb2c72e),
        UINT64_C(0x1f43038f04acc708), UINT64_C(0x1f43094e28b2e723)
    },
    {   UINT64_C(0x0000000000005bdc), UINT64_C(0x1f430a8e74b3673c), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ffcf6cb206ee), UINT64_C(0x1f43038ea4b02702)
    },
    {   UINT64_C(0x000000000000d1b8), UINT64_C(0x0ffaf44c6c7b45c1), UINT64_C(0x1b02f04f68a8e5b5),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005bde), UINT64_C(0x1f43088e70b06718), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43014ea4b3c717), UINT64_C(0x1f43018edcb6c70e)
    },
    {   UINT64_C(0x0000000000005bdf), UINT64_C(0x1f42fe8f54af0729), UINT64_C(0x1f4303cec4ae072b),
        UINT64_C(0x1f430a4edcaf8715), UINT64_C(0x1f43048f5cac86f6)
    },
    {   UINT64_C(0x0000000000005be0), UINT64_C(0x1f43038f50b246ce), UINT64_C(0x1f43020f50b186eb),
        UINT64_C(0x1f4300cfb0b5e6f3), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005be1), UINT64_C(0x1f43044fc4b7c712), UINT64_C(0x1f43068f3cb0c72d),
        UINT64_C(0x1f4300ce88b40731), UINT64_C(0x1f42fe4ebcb0c740)
    },
    {   UINT64_C(0x0000000000005be2), UINT64_C(0x1f43040f80b78710), UINT64_C(0x1f43038f58b786ec),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4306cee4a9c6fb)
    },
    {   UINT64_C(0x0000000000005be3), UINT64_C(0x1f42fbce6cb20713), UINT64_C(0x1f4300cf04b02719),
        UINT64_C(0x1f430a4e48aea73c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005be4), UINT64_C(0x1f42ffcf4caac6e9), UINT64_C(0x1f43094f3cade6d3),
        UINT64_C(0x1f43058f6cabe6d3), UINT64_C(0x1f42ff0f3cb5a70c)
    },
    {   UINT64_C(0x0000000000005be5), UINT64_C(0x1f43008f5cb286fa), UINT64_C(0x1f43048ed8ad671e),
        UINT64_C(0x1f43044ee0aca6f7), UINT64_C(0x1f43054edca926f5)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005be7), UINT64_C(0x1f430a4f40ac26ca), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4303cf08ab671e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005be8), UINT64_C(0x1f4306cf50b146d3), UINT64_C(0x1f43040e4cb486f6),
        UINT64_C(0x1f43094f00ad2715), UINT64_C(0x1f42fcce6cb7a720)
    },
    {   UINT64_C(0x0000000000005be9), UINT64_C(0x1f43060e5cafe71a), UINT64_C(0x1f4301ceb8b46700),
        UINT64_C(0x1f43084f70ad86df), UINT64_C(0x1f43078f78ab4717)
    },
    {   UINT64_C(0x00000000000147a0), UINT64_C(0x1bcafe0f58b40770), UINT64_C(0x14daf1cf6c8b46a1),
        UINT64_C(0x1bcafe0f58b40770), UINT64_C(0x14daf1cf6c8b46a1)
    },
    {   UINT64_C(0x00000000000147a1), UINT64_C(0x1bcafe0f58b40746), UINT64_C(0x14daf1cf6c8b4677),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005bec), UINT64_C(0x1f430a4fc0b5c706), UINT64_C(0x1f42fc8f90b5a6d9),
        UINT64_C(0x1f43084f08b26721), UINT64_C(0x1f43098fa0b2e734)
    },
    {   UINT64_C(0x0000000000005bed), UINT64_C(0x1f43088ef0b286fd), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430b4f18afe72d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005bee), UINT64_C(0x1f43050f40afe708), UINT64_C(0x1f4307ceb0ab0732),
        UINT64_C(0x1f43058eecb02719), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005bef), UINT64_C(0x1f43048f08b3c70d), UINT64_C(0x1f43064e7cb6e713),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43064ed4b74705)
    },
    {   UINT64_C(0x0000000000005bf0), UINT64_C(0x1f4302cf78b62707), UINT64_C(0x1f430b0eecaa270b),
        UINT64_C(0x1f42fdce40b72732), UINT64_C(0x1f43068f40b3a74b)
    },
    {   UINT64_C(0x0000000000005bf1), UINT64_C(0x1f43050f60b7c6c9), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43024e78b1673a), UINT64_C(0x1f43068ea4b16712)
    },
    {   UINT64_C(0x0000000000005bf2), UINT64_C(0x1f43038f38b3a6ea), UINT64_C(0x1f43060f68b266ea),
        UINT64_C(0x1f43068edcb1070e), UINT64_C(0x1f43044ee8b56713)
    },
    {   UINT64_C(0x0000000000005bf3), UINT64_C(0x1f43048f30b6a6e2), UINT64_C(0x1f43078f68b2471d),
        UINT64_C(0x1f4303cf50ab2707), UINT64_C(0x1f43048f0cafc6e0)
    },
    {   UINT64_C(0x0000000000005bf4), UINT64_C(0x0000000000000000), UINT64_C(0x1f43048f98ad46ff),
        UINT64_C(0x1f43060f84af8709), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005bf5), UINT64_C(0x1f43074ef8ad26e3), UINT64_C(0x1f43048f68af26f7),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005bf6), UINT64_C(0x1f430b0e34b14735), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430a8e58b7473a)
    },
    {   UINT64_C(0x0000000000005bf7), UINT64_C(0x1f4305cf84b1271d), UINT64_C(0x1f43044ea4b4c73b),
        UINT64_C(0x1f430a4ebcb3c73c), UINT64_C(0x1f43008e6cb4a740)
    },
    {   UINT64_C(0x0000000000005bf8), UINT64_C(0x1f43038e54b52739), UINT64_C(0x1f43028ea0a9a6f3),
        UINT64_C(0x1f43070e60b1c709), UINT64_C(0x1f43028f28b9070a)
    },
    {   UINT64_C(0x0000000000005bf9), UINT64_C(0x1f430d0e70b26739), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43028f44ade712), UINT64_C(0x1f43008f30b22700)
    },
    {   UINT64_C(0x0000000000005bfa), UINT64_C(0x1f43038f48aea732), UINT64_C(0x1f43088e58b4c730),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43068ffcb3c712)
    },
    {   UINT64_C(0x000000000000d1d6), UINT64_C(0x127b020fa085a68c), UINT64_C(0x1682f80fa093869a),
        UINT64_C(0x13db020fa089268c), UINT64_C(0x146af44fa08c668c)
    },
    {   UINT64_C(0x000000000000d1d7), UINT64_C(0x165b020fa08de68c), UINT64_C(0x1852f6cf549b669b),
        UINT64_C(0x0dc2fe4fa06d668c), UINT64_C(0x1643020fa096e68c)
    },
    {   UINT64_C(0x000000000000d1d8), UINT64_C(0x1612f80fa091c69a), UINT64_C(0x1c8b020fa0a6a68c),
        UINT64_C(0x16a3020f588f068c), UINT64_C(0x1402f6cfa08a268c)
    },
    {   UINT64_C(0x000000000000d1d9), UINT64_C(0x1852f6cf589b669c), UINT64_C(0x165b020fa08de68c),
        UINT64_C(0x122b020fa085a68c), UINT64_C(0x1852f6cf549b669b)
    },
    {   UINT64_C(0x0000000000005bff), UINT64_C(0x1f43040e8cb56703), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43068ef8b0a731), UINT64_C(0x1f43018eb0af86f3)
    },
    {   UINT64_C(0x0000000000005c00), UINT64_C(0x1f43004e80b0870b), UINT64_C(0x1f43014e88b7a73f),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000d1dc), UINT64_C(0x14b2f80f688d25c1), UINT64_C(0x1002f7cc6c7b669c),
        UINT64_C(0x0fb2f08c6c7a25c1), UINT64_C(0x0fb2f44f687a269c)
    },
    {   UINT64_C(0x0000000000005c02), UINT64_C(0x0000000000000000), UINT64_C(0x1f4309cec8aea739),
        UINT64_C(0x1f43068ee8b3c6fb), UINT64_C(0x1f43048eb4b4e731)
    },
    {   UINT64_C(0x000000000000d1de), UINT64_C(0x09fafb4f686385b5), UINT64_C(0x107afbcfa07e85c1),
        UINT64_C(0x1152f28f687f869c), UINT64_C(0x1132f7cc6c7f25b5)
    },
    {   UINT64_C(0x000000000000d1df), UINT64_C(0x0f62fbcf687985c1), UINT64_C(0x0faaf50c6c7ba69c),
        UINT64_C(0x0faaf44f687a05c1), UINT64_C(0x1292f08f688605b5)
    },
    {   UINT64_C(0x000000000000d1e0), UINT64_C(0x0ffaf78c6c7b45c1), UINT64_C(0x0f92f48c6c7b45c1),
        UINT64_C(0x1042f44f688385b5), UINT64_C(0x0efaef8f687985b5)
    },
    {   UINT64_C(0x00000000000147bc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x131affcfa090e770), UINT64_C(0x0de2d68c6c6f86a1)
    },
    {   UINT64_C(0x0000000000005c07), UINT64_C(0x1f42f9cfc0b406d6), UINT64_C(0x1f43058f54b706d3),
        UINT64_C(0x1f42f40f0cb8a71f), UINT64_C(0x1f43058e48b40745)
    },
    {   UINT64_C(0x000000000000d1e3), UINT64_C(0x11d2f18f6883c5c1), UINT64_C(0x13d2f44c6c8aa69c),
        UINT64_C(0x0f72f44c6c7925c1), UINT64_C(0x1a82ef8f68a765b5)
    },
    {   UINT64_C(0x0000000000005c09), UINT64_C(0x1f430a4e84b4472d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43004f70ae66ea), UINT64_C(0x1f43008f4cb22704)
    },
    {   UINT64_C(0x0000000000005c0a), UINT64_C(0x1f42fecf48aea6ff), UINT64_C(0x1f43058f80aec6bb),
        UINT64_C(0x1f43070ee4ad2726), UINT64_C(0x1f4300cf10b6870b)
    },
    {   UINT64_C(0x0000000000005c0b), UINT64_C(0x1f43024f44b146ff), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4304cef0afe711)
    },
    {   UINT64_C(0x0000000000005c0c), UINT64_C(0x1f43044ec8b106c0), UINT64_C(0x1f430a4f44a9c6fd),
        UINT64_C(0x1f4303cfe0b72700), UINT64_C(0x1f43068efcadc723)
    },
    {   UINT64_C(0x0000000000005c0d), UINT64_C(0x1f430a4eb8b126fe), UINT64_C(0x1f43038ed0af6724),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43068f00acc705)
    },
    {   UINT64_C(0x0000000000005c0e), UINT64_C(0x1f43090ec4b3e712), UINT64_C(0x1f43048edcb5e6f7),
        UINT64_C(0x1f43058e8cb1a733), UINT64_C(0x1f43038ef4b406ea)
    },
    {   UINT64_C(0x0000000000005c0f), UINT64_C(0x1f4307cec0b1a731), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43088f18ada6f5), UINT64_C(0x1f43038ee8b3e70b)
    },
    {   UINT64_C(0x0000000000005c10), UINT64_C(0x1f43054ec4b126f5), UINT64_C(0x1f42ffceb4ace6f7),
        UINT64_C(0x1f43094f24b1e72a), UINT64_C(0x1f430c4ec0b0472c)
    },
    {   UINT64_C(0x0000000000005c11), UINT64_C(0x1f43038e40b26718), UINT64_C(0x1f430b4f48afc717),
        UINT64_C(0x1f43094eecb1a72c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c12), UINT64_C(0x1f4308ce5cb1c729), UINT64_C(0x1f4302cebcb48709),
        UINT64_C(0x1f43028f44af8709), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c13), UINT64_C(0x1f43090e6cac872e), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43034f8cad86cd)
    },
    {   UINT64_C(0x0000000000005c14), UINT64_C(0x0000000000000000), UINT64_C(0x1f43034ed4b30728),
        UINT64_C(0x1f430c8e80b3072d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c15), UINT64_C(0x0000000000000000), UINT64_C(0x1f43044f84b66701),
        UINT64_C(0x1f4304ce8cb34738), UINT64_C(0x1f43010f08b4a719)
    },
    {   UINT64_C(0x0000000000005c16), UINT64_C(0x1f4300cf98b5671b), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43038e84b40728), UINT64_C(0x1f42fe8e54ae66fb)
    },
    {   UINT64_C(0x0000000000005c17), UINT64_C(0x0000000000000000), UINT64_C(0x1f43034f70ac46df),
        UINT64_C(0x1f43068eb8ac870e), UINT64_C(0x1f43038e88ada71f)
    },
    {   UINT64_C(0x000000000000d1f3), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0fa2f40f6c7a0698), UINT64_C(0x0fa2fe4fa075a698)
    },
    {   UINT64_C(0x000000000000d1f4), UINT64_C(0x0fa2f24fa07a4698), UINT64_C(0x0fa2f20f68790698),
        UINT64_C(0x0fa2f2cfa07a0698), UINT64_C(0x0fa2f38f8079468c)
    },
    {   UINT64_C(0x0000000000005c1a), UINT64_C(0x1f43018ec4b4472e), UINT64_C(0x1f42fc8f38b62709),
        UINT64_C(0x1f43008e84b68739), UINT64_C(0x1f43124fdcb64717)
    },
    {   UINT64_C(0x0000000000005c1b), UINT64_C(0x1f43121380aac5ab), UINT64_C(0x1f43154fb0af66b8),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43064f98b226f7)
    },
    {   UINT64_C(0x0000000000005c1c), UINT64_C(0x1f42f70f6cae6713), UINT64_C(0x1f43018f6cad26f7),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c1d), UINT64_C(0x1f42ff4ff8b626eb), UINT64_C(0x1f43114f4cafe6ef),
        UINT64_C(0x1f42fa8f8cb086dd), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c1e), UINT64_C(0x1f430e4edcb22732), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa4f94b666e7), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c1f), UINT64_C(0x1f43018f5cab071a), UINT64_C(0x1f43160f38b4a71d),
        UINT64_C(0x1f43120f68af6717), UINT64_C(0x1f42fe8fc8ae66e0)
    },
    {   UINT64_C(0x0000000000005c20), UINT64_C(0x1f43074f00b086e4), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb9040b5c6e7), UINT64_C(0x1f4311ce74b486fa)
    },
    {   UINT64_C(0x000000000000d1fc), UINT64_C(0x0fa2f2cfa07b0698), UINT64_C(0x0fa2f14f6c7ae68c),
        UINT64_C(0x0fa2f48f6c79e698), UINT64_C(0x0fa2f6cfa079668c)
    },
    {   UINT64_C(0x0000000000005c22), UINT64_C(0x0000000000000000), UINT64_C(0x1f43034ff4aaa6ef),
        UINT64_C(0x1f43034fecb44709), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c23), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430c4ec8b42727), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c24), UINT64_C(0x0000000000000000), UINT64_C(0x1f43008ebcb5c70b),
        UINT64_C(0x1f42fb8e90b3e713), UINT64_C(0x1f43034ea8b32709)
    },
    {   UINT64_C(0x0000000000005c25), UINT64_C(0x1f42fa8fc0b2c6e1), UINT64_C(0x1f42f6cf5cb4070a),
        UINT64_C(0x1f42fa8f78b606fd), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c26), UINT64_C(0x1f43054eacaea6f2), UINT64_C(0x1f430d8ef8b3872b),
        UINT64_C(0x1f4304cfe0b246be), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c27), UINT64_C(0x1f43004ed8b06710), UINT64_C(0x1f43044fccb6a6ea),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43018fc8b3c6e0)
    },
    {   UINT64_C(0x0000000000005c28), UINT64_C(0x0000000000000000), UINT64_C(0x1f43018fe8b186cc),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c29), UINT64_C(0x1f43070f68ada6f0), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c2a), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8f28b646f0),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc4f60ae46e3)
    },
    {   UINT64_C(0x0000000000005c2b), UINT64_C(0x1f43040fe4b226ff), UINT64_C(0x1f42fc8f24b5e72f),
        UINT64_C(0x1f43054f7cb40715), UINT64_C(0x1f42fc8f54aac6f7)
    },
    {   UINT64_C(0x0000000000005c2c), UINT64_C(0x1f43158f68a72710), UINT64_C(0x1f431d8f10ae0722),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe4f38ae4714)
    },
    {   UINT64_C(0x0000000000005c2d), UINT64_C(0x1f42fc8fa0b1c6d8), UINT64_C(0x1f42fa8f7cb5e6ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd8fe8ae86e4)
    },
    {   UINT64_C(0x0000000000005c2e), UINT64_C(0x1f43028ec8af2739), UINT64_C(0x1f43150fd4abe70d),
        UINT64_C(0x1f43058ef8afc727), UINT64_C(0x1f42fe9034a966d4)
    },
    {   UINT64_C(0x0000000000005c2f), UINT64_C(0x1f42fe8ef8af6707), UINT64_C(0x1f42fe8fc8ac86e0),
        UINT64_C(0x1f42fe8f74b766dc), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c30), UINT64_C(0x1f43018f2cb206e6), UINT64_C(0x1f42fc8f40ac66e0),
        UINT64_C(0x1f42ff9038ad86f3), UINT64_C(0x1f43008ff8afc6f3)
    },
    {   UINT64_C(0x0000000000005c31), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f88fc8b286e0),
        UINT64_C(0x1f42fb8ea0b406db), UINT64_C(0x1f42fd8f78b4c6ee)
    },
    {   UINT64_C(0x0000000000005c32), UINT64_C(0x1f43048f98b3c733), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f98e1cae871d), UINT64_C(0x1f4307cf18b166f0)
    },
    {   UINT64_C(0x0000000000005c33), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8f54b626ef),
        UINT64_C(0x1f4313cf14ada6fa), UINT64_C(0x1f430c0ec0ac0746)
    },
    {   UINT64_C(0x0000000000005c34), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f98f84b786f7),
        UINT64_C(0x1f42fd8ebcb446fd), UINT64_C(0x1f42f98f8cb2c6fe)
    },
    {   UINT64_C(0x0000000000005c35), UINT64_C(0x1f42fd8f48ac26dc), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc8f48ae470a)
    },
    {   UINT64_C(0x0000000000005c36), UINT64_C(0x1f42f94f9cb18700), UINT64_C(0x1f42fc8f4cb8a708),
        UINT64_C(0x1f42f98f0cb8e6f1), UINT64_C(0x1f430190a0aa8705)
    },
    {   UINT64_C(0x0000000000005c37), UINT64_C(0x1f42f98ff8b2e6ee), UINT64_C(0x1f43120f88afa6e5),
        UINT64_C(0x1f42fb8e9cb686eb), UINT64_C(0x1f42fa8fa8ac66e7)
    },
    {   UINT64_C(0x0000000000005c38), UINT64_C(0x1f42fd8e98b10717), UINT64_C(0x1f43180eb0af06f2),
        UINT64_C(0x1f42fb8f64af66f3), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c39), UINT64_C(0x1f42f78e70b28722), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff8f2cad0703), UINT64_C(0x1f43008f98b5e708)
    },
    {   UINT64_C(0x0000000000005c3a), UINT64_C(0x1f43018f18aec6e8), UINT64_C(0x1f42ff9000b6a6f9),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f431bcf30aea708)
    },
    {   UINT64_C(0x0000000000005c3b), UINT64_C(0x1f42f88f4cb886f0), UINT64_C(0x1f430d0fc4afa707),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb4e5cac073f)
    },
    {   UINT64_C(0x0000000000005c3c), UINT64_C(0x1f42ff8f08b2e702), UINT64_C(0x1f42fecf50b326af),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff8ee4ad26fa)
    },
    {   UINT64_C(0x0000000000005c3d), UINT64_C(0x1f42fc9008afc6db), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc8fecaec6e8), UINT64_C(0x1f42fd8fb8ae26fa)
    },
    {   UINT64_C(0x0000000000005c3e), UINT64_C(0x1f43034f30b346ff), UINT64_C(0x1f43130f18ac472a),
        UINT64_C(0x1f43008f38b5a70e), UINT64_C(0x1f43034fe0b346dc)
    },
    {   UINT64_C(0x0000000000005c3f), UINT64_C(0x1f42fd8ef0b7a6d3), UINT64_C(0x1f42fb4e7cb6a733),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f98f10ae66eb)
    },
    {   UINT64_C(0x0000000000005c40), UINT64_C(0x1f43018f8cb446cc), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43074ef8abe707), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c41), UINT64_C(0x1f43090f78aa86d5), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43074efca426e3), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c42), UINT64_C(0x0000000000000000), UINT64_C(0x1f430a4eb4a8672c),
        UINT64_C(0x1f43024e7cb2e6f9), UINT64_C(0x1f43110f14a78706)
    },
    {   UINT64_C(0x0000000000005c43), UINT64_C(0x1f42fd8f7cb2c6ff), UINT64_C(0x1f43054edcadc71a),
        UINT64_C(0x1f43094f8ca9a70a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c44), UINT64_C(0x1f43008fd8b1c6e7), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43008f4cb3c6df)
    },
    {   UINT64_C(0x0000000000005c45), UINT64_C(0x1f43020f98b1a6f1), UINT64_C(0x1f43018fbcb1670f),
        UINT64_C(0x1f42fa8f4caa46dc), UINT64_C(0x1f43008f40ad66e8)
    },
    {   UINT64_C(0x0000000000005c46), UINT64_C(0x1f43194f0ca9a717), UINT64_C(0x1f42fa4f8cb2670a),
        UINT64_C(0x1f430a4ee0b42743), UINT64_C(0x1f43134e88a76709)
    },
    {   UINT64_C(0x0000000000005c47), UINT64_C(0x1f43070ffcb8e6da), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fe8ec0af8729), UINT64_C(0x1f43018ea0b06705)
    },
    {   UINT64_C(0x0000000000005c48), UINT64_C(0x1f43008eacad8722), UINT64_C(0x1f43058f48b52734),
        UINT64_C(0x1f42fe8fdcad66eb), UINT64_C(0x1f430a4f98b106c9)
    },
    {   UINT64_C(0x0000000000005c49), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd8f8cb4e702),
        UINT64_C(0x1f430ccf1cafc725), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c4a), UINT64_C(0x1f43018edca766f7), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c4b), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff9004b246eb), UINT64_C(0x1f42ff8eacb06712)
    },
    {   UINT64_C(0x0000000000005c4c), UINT64_C(0x1f43004f90af06f1), UINT64_C(0x1f43104f68b0e6fb),
        UINT64_C(0x1f42fb8f74b5870e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c4d), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43094f58b06711), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c4e), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff8e6cb0e6ef), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000014805), UINT64_C(0x1f42e41268b8a4f5), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000f05db14806), UINT64_C(0x0a6b0e1564680695), UINT64_C(0x0a6b069564644695),
        UINT64_C(0x0a6aecccc857646e), UINT64_C(0x0a6b0e1564644695)
    },
    {   UINT64_C(0x0007c4f65e914807), UINT64_C(0x0fa2fb55647ea695), UINT64_C(0x0fa2fb55647ea695),
        UINT64_C(0x0fa2dfccc870e46e), UINT64_C(0x0fa30515647ea695)
    },
    {   UINT64_C(0x0000000000014808), UINT64_C(0x0fa304cd5c7c4695), UINT64_C(0x0fa2f08d747c2695),
        UINT64_C(0x1182ff90487bc5b6), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000014809), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f80f6ca9046f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c54), UINT64_C(0x1f42fe8ff0b166fd), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc8e60ac071a), UINT64_C(0x1f42fa8ed4afe704)
    },
    {   UINT64_C(0x0000000000005c55), UINT64_C(0x1f42fccf64aea70a), UINT64_C(0x1f430a8f90ad0703),
        UINT64_C(0x1f43004ea8b64719), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c56), UINT64_C(0x1f42fb8f34b086fc), UINT64_C(0x1f42ff4fa0b226fe),
        UINT64_C(0x1f43144e78af4717), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c57), UINT64_C(0x1f42fb4facb146ee), UINT64_C(0x1f42fa8f6caa86e8),
        UINT64_C(0x1f430acf68b3270b), UINT64_C(0x1f42fe8ea0ade700)
    },
    {   UINT64_C(0x0007da000001480e), UINT64_C(0x0000000000000000), UINT64_C(0x0a6af61020646587),
        UINT64_C(0x0a6af0902061a587), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c59), UINT64_C(0x1f42fa4eacb54729), UINT64_C(0x1f43018fb0b7c710),
        UINT64_C(0x1f430dcfa8b0872c), UINT64_C(0x1f43094fd4afc700)
    },
    {   UINT64_C(0x0000000000005c5a), UINT64_C(0x1f42f84ef8b70712), UINT64_C(0x1f42ff8f0cae870a),
        UINT64_C(0x1f42fc4f1cb40704), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000014811), UINT64_C(0x05bac40f7069a698), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c5c), UINT64_C(0x1f42f98fd8b2e6eb), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4307ce74b06716), UINT64_C(0x1f43008fcca9e704)
    },
    {   UINT64_C(0x0000000000005c5d), UINT64_C(0x1f42fe0fd8b3a6d8), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c5e), UINT64_C(0x1f43008f64af270e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43008ff8b3a6eb), UINT64_C(0x1f42fa4efcb5c726)
    },
    {   UINT64_C(0x0000000000005c5f), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe4f18a90735),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c60), UINT64_C(0x1f42fa4f60b5e6fb), UINT64_C(0x1f43030e84b2071e),
        UINT64_C(0x1f42f48ed8b6a709), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c61), UINT64_C(0x1f42fc8f20b7471e), UINT64_C(0x1f42fa9024b626f3),
        UINT64_C(0x1f42fd8f4cae6706), UINT64_C(0x1f42fc8f84ab670b)
    },
    {   UINT64_C(0x0000000000005c62), UINT64_C(0x1f43038f90ad06c3), UINT64_C(0x1f43014ec0a8e701),
        UINT64_C(0x1f430f0eccae4728), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c63), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43098e50ac873a)
    },
    {   UINT64_C(0x0000000000005c64), UINT64_C(0x1f42ff4fa0ac86ec), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43074f14af071c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c65), UINT64_C(0x1f42f78f0cb5a711), UINT64_C(0x1f43040f00b086f7),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f94ec0b9870a)
    },
    {   UINT64_C(0x0000000000005c66), UINT64_C(0x1f42fd8f80aae6e8), UINT64_C(0x1f430bcf88ae06f1),
        UINT64_C(0x1f42fd8ed8b066fd), UINT64_C(0x1f42fc8ef4af06fb)
    },
    {   UINT64_C(0x0000000000005c67), UINT64_C(0x1f42ff8f7cb02705), UINT64_C(0x1f42fe8ef4b4e70b),
        UINT64_C(0x1f42ff8fe4b4a6d3), UINT64_C(0x1f4309cf28b58735)
    },
    {   UINT64_C(0x0000000000005c68), UINT64_C(0x1f43050f2cb006e3), UINT64_C(0x1f42ff8f04b0c711),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c69), UINT64_C(0x1f42fc8ff8af46d8), UINT64_C(0x1f42fb8f58b466df),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43114f3caf8721)
    },
    {   UINT64_C(0x0000000000005c6a), UINT64_C(0x1f42fc8e60b16717), UINT64_C(0x1f43008f48afe71e),
        UINT64_C(0x1f42fe8f50b1a6f5), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c6b), UINT64_C(0x1f430b8f88ad271e), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd8f40b0e722)
    },
    {   UINT64_C(0x0000000000005c6c), UINT64_C(0x1f42fc8f8cb126db), UINT64_C(0x1f43018f08b60735),
        UINT64_C(0x1f4307cf5caaa6e7), UINT64_C(0x1f42fd8f30b4470c)
    },
    {   UINT64_C(0x0000000000005c6d), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe8f20ab4712),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c6e), UINT64_C(0x1f42fb8ee4b466c6), UINT64_C(0x1f42fe0e8cb02736),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c6f), UINT64_C(0x1f42fd8f38aee6d3), UINT64_C(0x1f42f88f1caf6711),
        UINT64_C(0x1f42f88f08b5470a), UINT64_C(0x1f43034edcb0670c)
    },
    {   UINT64_C(0x0000000000005c70), UINT64_C(0x1f42fc8eb8b2e6fe), UINT64_C(0x1f42fe8e9cafe72c),
        UINT64_C(0x1f42fb8e8cb00709), UINT64_C(0x1f42ff4fa4b6270b)
    },
    {   UINT64_C(0x0000000000005c71), UINT64_C(0x1f43010f44b646f0), UINT64_C(0x1f43074fc8b34706),
        UINT64_C(0x1f42fa8e9cb9470f), UINT64_C(0x1f42f98ed0b1e72f)
    },
    {   UINT64_C(0x0000000000014828), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x14e2eacfa0912685)
    },
    {   UINT64_C(0x0000000000014829), UINT64_C(0x0fa2e60f707e4693), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x266ae70f6cd12685)
    },
    {   UINT64_C(0x0000000000005c74), UINT64_C(0x1f42fa8e2cb3a727), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f98e84b7072d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001482b), UINT64_C(0x1192f68f5c82c691), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c76), UINT64_C(0x1f42f98edcade6cf), UINT64_C(0x1f430d8e64ae672e),
        UINT64_C(0x1f430d4f34b346f9), UINT64_C(0x1f4311cf44ac26f8)
    },
    {   UINT64_C(0x0000000000005c77), UINT64_C(0x1f42fa8ed4af06db), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430b0ebcb0a727)
    },
    {   UINT64_C(0x0000000000005c78), UINT64_C(0x1f42fc4f64b3671d), UINT64_C(0x1f42fa8e4cad0700),
        UINT64_C(0x1f43090f20b0a6fa), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c79), UINT64_C(0x1f42fb8f00ac671d), UINT64_C(0x1f42fb4eacb86713),
        UINT64_C(0x1f42ff8e8cb7a72c), UINT64_C(0x1f42fc8ee4b22719)
    },
    {   UINT64_C(0x0000000000005c7a), UINT64_C(0x1f42f98edcaf8723), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c7b), UINT64_C(0x1f42fe8ffcb826c8), UINT64_C(0x1f43008f04ade70e),
        UINT64_C(0x1f430c4e80b30736), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c7c), UINT64_C(0x1f42fe8ef4b24700), UINT64_C(0x1f42fe8f38b10708),
        UINT64_C(0x1f43028e7cada721), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c7d), UINT64_C(0x1f42fa8e48b82735), UINT64_C(0x1f42fb8ee8b4c715),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c7e), UINT64_C(0x1f42fe8ef8b146fe), UINT64_C(0x1f430d8f24ae672d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb8eccb0071b)
    },
    {   UINT64_C(0x0000000000005c7f), UINT64_C(0x1f42fa8f4cb3672d), UINT64_C(0x1f42fc8e94b5c73d),
        UINT64_C(0x1f430b4e8caca739), UINT64_C(0x1f43030e98b006f7)
    },
    {   UINT64_C(0x0000000000005c80), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb8ff8b2c6ee),
        UINT64_C(0x1f4309cf14afa6df), UINT64_C(0x1f42f88eacb4c70c)
    },
    {   UINT64_C(0x0000000000014837), UINT64_C(0x0000000000000000), UINT64_C(0x000231cba85e86e0),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c82), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa8f58b1672c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c83), UINT64_C(0x1f42f98f0cb2472d), UINT64_C(0x1f42f88e6cb6c72c),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c84), UINT64_C(0x1f42fe8f00b42718), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f88edcafe6f1)
    },
    {   UINT64_C(0x0000000000005c85), UINT64_C(0x1f42ff4ee0ae2746), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c86), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff8e70b5c71e),
        UINT64_C(0x1f42fd8edcb9271a), UINT64_C(0x1f42fc8f0cac8706)
    },
    {   UINT64_C(0x0000000000005c87), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb8e3cb4e729),
        UINT64_C(0x1f42f88f74b3e730), UINT64_C(0x1f42f98e5cb18724)
    },
    {   UINT64_C(0x0000000000005c88), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43080ebcabc729), UINT64_C(0x1f42fa8e7cb50735)
    },
    {   UINT64_C(0x0000000000005c89), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f88e9cb56727), UINT64_C(0x1f42fe8f60b12716)
    },
    {   UINT64_C(0x0000000000005c8a), UINT64_C(0x1f4309ceccaf0708), UINT64_C(0x1f42fb8e94b8873d),
        UINT64_C(0x1f43010ee8b6a6f3), UINT64_C(0x1f431a9830a5471c)
    },
    {   UINT64_C(0x0000000000005c8b), UINT64_C(0x1f42facf88b2a6f6), UINT64_C(0x1f43028e58b4e733),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c8c), UINT64_C(0x1f430c8e70b6874a), UINT64_C(0x1f430ecf20ace722),
        UINT64_C(0x1f43068e28af4731), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c8d), UINT64_C(0x0000000000000000), UINT64_C(0x1f43138e30b00740),
        UINT64_C(0x1f43098facb2e6e7), UINT64_C(0x1f43080e6cb5070c)
    },
    {   UINT64_C(0x0000000000005c8e), UINT64_C(0x1f42f98ed0b7870a), UINT64_C(0x1f42fe8e84b6c733),
        UINT64_C(0x1f42ff4e4cb76738), UINT64_C(0x1f4307cf18b4a71b)
    },
    {   UINT64_C(0x0000000000014845), UINT64_C(0x0000000000000000), UINT64_C(0x17c2f4cfa0a06685),
        UINT64_C(0x20faf40f64bf668b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c90), UINT64_C(0x1f42f60ee0b78715), UINT64_C(0x1f43028f18b106e0),
        UINT64_C(0x1f43014ed8afc71a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000014847), UINT64_C(0x0000000000000000), UINT64_C(0x16baf28fa0984685),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c92), UINT64_C(0x1f42f84facb706fd), UINT64_C(0x1f42fb0ef8b186fe),
        UINT64_C(0x1f42fc4f4cab06eb), UINT64_C(0x1f42fc0ec0afc6fd)
    },
    {   UINT64_C(0x0000000000005c93), UINT64_C(0x1f43000e7cb5c739), UINT64_C(0x1f43004f48ae2706),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0ed0b7670f)
    },
    {   UINT64_C(0x0000000000005c94), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc0eecb68724), UINT64_C(0x1f42fb4f24b14734)
    },
    {   UINT64_C(0x0000000000005c95), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f94f30adc732), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c96), UINT64_C(0x1f42fb0e70b00742), UINT64_C(0x1f43144ef8af6704),
        UINT64_C(0x1f43188eb0ac871e), UINT64_C(0x1f43098e6cb20730)
    },
    {   UINT64_C(0x0000000000005c97), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe0eecb326fb),
        UINT64_C(0x1f42ff0eccad86fb), UINT64_C(0x1f43068e5cb08738)
    },
    {   UINT64_C(0x0000000000005c98), UINT64_C(0x1f42f98f94b1a708), UINT64_C(0x1f43004f68b48712),
        UINT64_C(0x1f43104e6cae8739), UINT64_C(0x1f43000eacb266fc)
    },
    {   UINT64_C(0x0000000000005c99), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb4f38b5070e), UINT64_C(0x1f42facf38b786fe)
    },
    {   UINT64_C(0x0000000000005c9a), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe4f58b1271f),
        UINT64_C(0x1f43048ef8b126f3), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005c9b), UINT64_C(0x1f43014ee8b06702), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430b4e7ca986fe), UINT64_C(0x1f42f70f58b1870f)
    },
    {   UINT64_C(0x0000000000005c9c), UINT64_C(0x1f42fe0f28b426f7), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc4f08b4470c), UINT64_C(0x1f42fecf38b246f0)
    },
    {   UINT64_C(0x0000000000005c9d), UINT64_C(0x1f43010f68b7270f), UINT64_C(0x1f43124e7ca9a71f),
        UINT64_C(0x1f4304ce6cb88735), UINT64_C(0x1f42f90f38b826ff)
    },
    {   UINT64_C(0x0000000000005c9e), UINT64_C(0x1f42ff0ed4b086f6), UINT64_C(0x1f42ff8e70b40734),
        UINT64_C(0x1f42ff8f28b22713), UINT64_C(0x1f42fdcf8cb306f3)
    },
    {   UINT64_C(0x0000000000005c9f), UINT64_C(0x1f43008f18af46f7), UINT64_C(0x1f43120e8caf273e),
        UINT64_C(0x1f43020f5cb066f7), UINT64_C(0x1f43030f0cb0070a)
    },
    {   UINT64_C(0x0000000000005ca0), UINT64_C(0x1f42f98e5cac6725), UINT64_C(0x1f430d8e7cab8721),
        UINT64_C(0x1f430d8e7cab8721), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ca1), UINT64_C(0x1f42f90e94b20732), UINT64_C(0x1f42fb4f00ac06ec),
        UINT64_C(0x1f43000f38af4700), UINT64_C(0x1f42fd0eacb42715)
    },
    {   UINT64_C(0x0000000000005ca2), UINT64_C(0x1f42f9cf1cb4c6e1), UINT64_C(0x1f42fd0ed8aea715),
        UINT64_C(0x1f42ff8f38ade70b), UINT64_C(0x1f4303cf20b066d8)
    },
    {   UINT64_C(0x0000000000005ca3), UINT64_C(0x1f42fb0edcb806f7), UINT64_C(0x1f42fdcefcb64702),
        UINT64_C(0x1f43114e8cab8726), UINT64_C(0x1f42fd4f58ad4708)
    },
    {   UINT64_C(0x0000000000005ca4), UINT64_C(0x1f42fc0ea8b8e700), UINT64_C(0x1f42fe0edcb726fc),
        UINT64_C(0x1f42fb8f5cace717), UINT64_C(0x1f42fb4ea8aaa717)
    },
    {   UINT64_C(0x0000000000005ca5), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f94e68af871d),
        UINT64_C(0x1f430b4e6cafa747), UINT64_C(0x1f42fa4eccb1e70e)
    },
    {   UINT64_C(0x0000000000005ca6), UINT64_C(0x1f42fb8e9cae672f), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430d0e7caaa72e), UINT64_C(0x1f43048e8cb1c72f)
    },
    {   UINT64_C(0x0000000000005ca7), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe8f28b00702),
        UINT64_C(0x1f42fd0ec8b5470b), UINT64_C(0x1f4317ceb8ab071a)
    },
    {   UINT64_C(0x0000000000005ca8), UINT64_C(0x1f42fa4e48b58733), UINT64_C(0x1f42fccf24af66fb),
        UINT64_C(0x1f43000e54ae2732), UINT64_C(0x1f42fc8ef8b76716)
    },
    {   UINT64_C(0x0000000000005ca9), UINT64_C(0x1f42f8cf88b3a6f8), UINT64_C(0x1f42fc8f58b10719),
        UINT64_C(0x1f42f9cec0b64700), UINT64_C(0x1f42f84edcb0c740)
    },
    {   UINT64_C(0x0000000000005caa), UINT64_C(0x1f43034e6cab871d), UINT64_C(0x1f43028e7cb06744),
        UINT64_C(0x1f42f68ea0b4272d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005cab), UINT64_C(0x1f430e8fa8b5a70a), UINT64_C(0x1f432fcf6489e6e6),
        UINT64_C(0x1f43068f1cb1e70f), UINT64_C(0x1f42fd8fbcb6e6e6)
    },
    {   UINT64_C(0x0000000000005cac), UINT64_C(0x1f42f90f50b6a6ea), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4300ced4b20715), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005cad), UINT64_C(0x1f42fc0ee8b2a6fd), UINT64_C(0x1f42fdcf20b266fc),
        UINT64_C(0x1f42ff0f88b64700), UINT64_C(0x1f42fccf4cac26f4)
    },
    {   UINT64_C(0x0000000000005cae), UINT64_C(0x1f42fccf10ada6e4), UINT64_C(0x1f42fccf60b6c6df),
        UINT64_C(0x1f42fcced8b666d8), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005caf), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ffce74b3e6e1),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0e88b186e5)
    },
    {   UINT64_C(0x0000000000005cb0), UINT64_C(0x1f42f9cf3cb64718), UINT64_C(0x1f42f64f1cb746e8),
        UINT64_C(0x1f42f98fc0b3670d), UINT64_C(0x1f42fa0f80b0e6ed)
    },
    {   UINT64_C(0x0000000000005cb1), UINT64_C(0x1f42fa8f60b5c6fb), UINT64_C(0x1f42fa4f54afe6db),
        UINT64_C(0x1f4300cec8ae2718), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005cb2), UINT64_C(0x1f42fc4f8ca8a6fb), UINT64_C(0x1f42fdcf30ae86cf),
        UINT64_C(0x1f43124f2caba70b), UINT64_C(0x1f42fc0f78ad46c8)
    },
    {   UINT64_C(0x0000000000005cb3), UINT64_C(0x1f42fb4f38b6c6e9), UINT64_C(0x1f42fccf3cafe71c),
        UINT64_C(0x1f42fe4e5caf070b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005cb4), UINT64_C(0x1f42f48fa0b986ef), UINT64_C(0x1f42fb4f34b7a703),
        UINT64_C(0x1f42fecf28af46ff), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005cb5), UINT64_C(0x1f42fc0f34b766dd), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fdcf50b6a6e2), UINT64_C(0x1f42fb8f50ad2709)
    },
    {   UINT64_C(0x0000000000005cb6), UINT64_C(0x1f42fa0f48b2c6e1), UINT64_C(0x1f42fa8f30b5a701),
        UINT64_C(0x1f42fa0f34b7a6d9), UINT64_C(0x1f43050f34b026d9)
    },
    {   UINT64_C(0x0000000000005cb7), UINT64_C(0x1f42fa0f1cb226ea), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb0ee8afe712), UINT64_C(0x1f42fccf60b1e6df)
    },
    {   UINT64_C(0x0000000000005cb8), UINT64_C(0x1f42f90f48b866ff), UINT64_C(0x1f42f9cf64b826f2),
        UINT64_C(0x1f42f98ee8b5c6f5), UINT64_C(0x1f42f64f80b4e6d3)
    },
    {   UINT64_C(0x0000000000005ef3), UINT64_C(0x1f43040ef8ae6715), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43174e88ae0733), UINT64_C(0x1f42ff8e84b2a714)
    },
    {   UINT64_C(0x0000000000005cba), UINT64_C(0x1f42fa4f04b0c6d7), UINT64_C(0x1f42f90ea4b1e72d),
        UINT64_C(0x1f42fccf14abe6d0), UINT64_C(0x1f42fccf70b026ea)
    },
    {   UINT64_C(0x0000000000005cbb), UINT64_C(0x1f42fecf68a966e1), UINT64_C(0x1f42fccf4cb3c6fb),
        UINT64_C(0x1f42faced8adc701), UINT64_C(0x1f42fccf58b806e4)
    },
    {   UINT64_C(0x0000000000005cbc), UINT64_C(0x1f42ff8ef0b36718), UINT64_C(0x1f42fccf84b886d8),
        UINT64_C(0x1f42fa0f44b4a6e8), UINT64_C(0x1f42f84ea0b7270a)
    },
    {   UINT64_C(0x0000000000005cbd), UINT64_C(0x1f42f34fa0ada6f7), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f64df0b4672a), UINT64_C(0x1f42f98f30a4e701)
    },
    {   UINT64_C(0x0000000000005cbe), UINT64_C(0x1f42f98fc8b34700), UINT64_C(0x1f42fccf54b72707),
        UINT64_C(0x1f42f64f8cad4703), UINT64_C(0x1f42f84f00b7271b)
    },
    {   UINT64_C(0x0000000000005cbf), UINT64_C(0x1f43008f14b86722), UINT64_C(0x1f42fc4f5cab86fb),
        UINT64_C(0x1f42fccea8b106ca), UINT64_C(0x1f42fd1004b0e6dd)
    },
    {   UINT64_C(0x0000000000005cc0), UINT64_C(0x1f42fdcee8b4e6e6), UINT64_C(0x1f42fb4ee8adc6f8),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fccf54b5c6ef)
    },
    {   UINT64_C(0x0000000000005cc1), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0f44b3c712)
    },
    {   UINT64_C(0x0000000000005cc2), UINT64_C(0x1f42ff0eacafc72c), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f48f6cb6a6e4), UINT64_C(0x1f43064fa8b06709)
    },
    {   UINT64_C(0x0000000000005cc3), UINT64_C(0x1f43010f18b4c6f7), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fccf94ae0715), UINT64_C(0x1f42fd0ee8a4a70e)
    },
    {   UINT64_C(0x0000000000005cc4), UINT64_C(0x0000000000000000), UINT64_C(0x1f43004f10b3a6c7),
        UINT64_C(0x1f430fcfacb446df), UINT64_C(0x1f42fc0ee8b4c6ea)
    },
    {   UINT64_C(0x0000000000005cc5), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0f50b1a6e2),
        UINT64_C(0x1f42fccfdcae06de), UINT64_C(0x1f43000e98ae86f9)
    },
    {   UINT64_C(0x0000000000005cc6), UINT64_C(0x1f42fe0ec8aae6fc), UINT64_C(0x1f42fcceb0b6a733),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fccfb8b0a6ef)
    },
    {   UINT64_C(0x0000000000005cc7), UINT64_C(0x1f42fa0ea0b1e738), UINT64_C(0x1f42fd4e9cb2c729),
        UINT64_C(0x1f42fccf98b446f0), UINT64_C(0x1f42fa4edcb566f7)
    },
    {   UINT64_C(0x0000000000005cc8), UINT64_C(0x0000000000000000), UINT64_C(0x1f43000ef0ade6e3),
        UINT64_C(0x1f42fd0f4caba6f9), UINT64_C(0x1f42ff0f10b28704)
    },
    {   UINT64_C(0x0000000000005cc9), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80ef8b686fe),
        UINT64_C(0x1f42f98f1cb3e6c1), UINT64_C(0x1f42fdcf40af66df)
    },
    {   UINT64_C(0x0000000000005cca), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80f9caf46ed),
        UINT64_C(0x1f42fccf3cae46f6), UINT64_C(0x1f42fccf78b086ff)
    },
    {   UINT64_C(0x0000000000005ccb), UINT64_C(0x1f42fd0ec0a966ee), UINT64_C(0x1f42fb4edcb6a705),
        UINT64_C(0x1f43065000b4c6ea), UINT64_C(0x1f42fc4ebcb4871d)
    },
    {   UINT64_C(0x0000000000005ccc), UINT64_C(0x1f4300cf4cafe6ce), UINT64_C(0x1f42fd0f18b246f4),
        UINT64_C(0x1f43010eacace6f7), UINT64_C(0x1f42fa0fe0b5c6d1)
    },
    {   UINT64_C(0x0000000000005ccd), UINT64_C(0x1f42fb4fd4b7a6fd), UINT64_C(0x1f42ffcf9cade70b),
        UINT64_C(0x1f42fd8f44b2e71d), UINT64_C(0x1f43030fecb5c712)
    },
    {   UINT64_C(0x0000000000005cce), UINT64_C(0x1f42fccf7ca8c6db), UINT64_C(0x1f42f90f54b38704),
        UINT64_C(0x1f42fc8fbcafa721), UINT64_C(0x1f42f90f40b146e8)
    },
    {   UINT64_C(0x0000000000005ccf), UINT64_C(0x1f42fc8e54b3671d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f70eb0b5670f), UINT64_C(0x1f42f9ced8b74729)
    },
    {   UINT64_C(0x0000000000005cd0), UINT64_C(0x1f43010ed8b68705), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc8ec0b3c6e4), UINT64_C(0x1f42f8cf68b8270c)
    },
    {   UINT64_C(0x0000000000005cd1), UINT64_C(0x1f42f5cfd0b826ff), UINT64_C(0x1f42f9ce9cb2271d),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005cd2), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f9ce6cb9a723),
        UINT64_C(0x1f43000eb0b9471d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005cd3), UINT64_C(0x1f42fa0f24b4e703), UINT64_C(0x1f42f60f14ad872d),
        UINT64_C(0x1f43118ea4b18733), UINT64_C(0x1f42fccf44b4270b)
    },
    {   UINT64_C(0x0000000000005cd4), UINT64_C(0x1f42f8ce5cad6732), UINT64_C(0x1f42f70e4cb52713),
        UINT64_C(0x1f430c8efcb1c712), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005cd5), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f5cfd8b826e5)
    },
    {   UINT64_C(0x0000000000005cd6), UINT64_C(0x1f4315cf00b5072e), UINT64_C(0x1f42f9cf7cb886cb),
        UINT64_C(0x1f42ffcf18b06718), UINT64_C(0x1f42ffcf48afe705)
    },
    {   UINT64_C(0x0000000000005cd7), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fdceb8ac4704),
        UINT64_C(0x1f42fd8f28b0c702), UINT64_C(0x1f42ffcf4cb4e722)
    },
    {   UINT64_C(0x0000000000005cd8), UINT64_C(0x1f42ffcf14b7870d), UINT64_C(0x1f42ffceccaf06f0),
        UINT64_C(0x1f42fa8f10b8e70d), UINT64_C(0x1f42f8cf88b626f9)
    },
    {   UINT64_C(0x0000000000005cd9), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0ee8b886eb),
        UINT64_C(0x1f42f90ebcab672c), UINT64_C(0x1f42fbcf10b6070d)
    },
    {   UINT64_C(0x0000000000005cda), UINT64_C(0x1f42fc0f58ac071a), UINT64_C(0x1f43008ef4b16705),
        UINT64_C(0x1f42f3cea4b74718), UINT64_C(0x1f42fa8f68b80706)
    },
    {   UINT64_C(0x0000000000005cdb), UINT64_C(0x1f42f7cf18b50703), UINT64_C(0x1f42fb0f80aec6f6),
        UINT64_C(0x1f42fe8ec4ab26f2), UINT64_C(0x1f42fd0f0cadc703)
    },
    {   UINT64_C(0x0000000000005cdc), UINT64_C(0x1f42f6ce60b14735), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fcceecb66740), UINT64_C(0x1f42feced0b306f6)
    },
    {   UINT64_C(0x0000000000005cdd), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0f70b74733),
        UINT64_C(0x1f42f3ceccb1c719), UINT64_C(0x1f42f90f1cb00735)
    },
    {   UINT64_C(0x0000000000005cde), UINT64_C(0x1f42f90f88b646f9), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f80f80aec6ef), UINT64_C(0x1f42f68f3cb6a71a)
    },
    {   UINT64_C(0x0000000000005cdf), UINT64_C(0x1f42f9cf28adc6d1), UINT64_C(0x1f42fb0ea0b50735),
        UINT64_C(0x1f42fe4eb8b06739), UINT64_C(0x1f42fb4ee4b326fc)
    },
    {   UINT64_C(0x0000000000005ce0), UINT64_C(0x1f42f80e8cb366f0), UINT64_C(0x1f42f9ceccb60701),
        UINT64_C(0x1f42f9ced8afe717), UINT64_C(0x1f42f44e50b5072f)
    },
    {   UINT64_C(0x0000000000005ce1), UINT64_C(0x1f430a4fd0b186fe), UINT64_C(0x1f4306ceacb226ef),
        UINT64_C(0x1f43079000aac6ee), UINT64_C(0x1f430b8e7cb3c73c)
    },
    {   UINT64_C(0x0000000000005ce2), UINT64_C(0x1f43080fc4b32700), UINT64_C(0x1f43081098b2e6b8),
        UINT64_C(0x1f4307d004b2c6a6), UINT64_C(0x1f43085084b1e6b8)
    },
    {   UINT64_C(0x0000000000005ce3), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4302cf28b4269b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ce4), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe5014b566ce),
        UINT64_C(0x1f43021110b74685), UINT64_C(0x1f43020f14af46da)
    },
    {   UINT64_C(0x0000000000005ce5), UINT64_C(0x1f42fe4eaca94707), UINT64_C(0x1f43008f54b0e6fb),
        UINT64_C(0x1f42fbcf7cb6a6e8), UINT64_C(0x1f43018eecb486c2)
    },
    {   UINT64_C(0x0000000000005ce6), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43054f60ada6ec)
    },
    {   UINT64_C(0x0000000000005ce7), UINT64_C(0x0000000000000000), UINT64_C(0x1f4303cec8b326fa),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cfc4b706fb)
    },
    {   UINT64_C(0x0000000000005ce8), UINT64_C(0x1f42f88eacb7a706), UINT64_C(0x1f43028ed4b3a6cf),
        UINT64_C(0x1f42fc4f08b826da), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ce9), UINT64_C(0x1f42fe0e98b4a724), UINT64_C(0x1f43018eb0a526df),
        UINT64_C(0x1f4303d000b5c700), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005cea), UINT64_C(0x1f42fe10fcb4c6d2), UINT64_C(0x1f43031074b926dd),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb1000b54711)
    },
    {   UINT64_C(0x0000000000005ceb), UINT64_C(0x1f43024f04b666b7), UINT64_C(0x1f42fe4ffcb8e6b7),
        UINT64_C(0x1f43058eb8aec711), UINT64_C(0x1f42fdcf58b4a6d9)
    },
    {   UINT64_C(0x0000000000005cec), UINT64_C(0x1f42fc4f78b546ec), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4301cee8b9a71d), UINT64_C(0x1f42fa4f10b1872c)
    },
    {   UINT64_C(0x0000000000005ced), UINT64_C(0x1f43014fe4b3a6aa), UINT64_C(0x1f43014fc8b406ec),
        UINT64_C(0x1f42fdceb8b566d6), UINT64_C(0x1f42fe4fc8ac6701)
    },
    {   UINT64_C(0x0000000000005cee), UINT64_C(0x1f43020f68b186f1), UINT64_C(0x1f43031010ade6eb),
        UINT64_C(0x1f43194f70ab6709), UINT64_C(0x1f42fe0f9cb8c71d)
    },
    {   UINT64_C(0x0000000000005cef), UINT64_C(0x1f42f6507cb7a6cb), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fece6cae66af), UINT64_C(0x1f4302cf4cab06ad)
    },
    {   UINT64_C(0x0000000000005cf0), UINT64_C(0x1f42ff50d8a906fe), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43000facb566d9), UINT64_C(0x1f4301ceecb6e6fd)
    },
    {   UINT64_C(0x0000000000005cf1), UINT64_C(0x0000000000000000), UINT64_C(0x1f43010e6caf8715),
        UINT64_C(0x1f43004f68aea6e2), UINT64_C(0x1f43029030b6a6a9)
    },
    {   UINT64_C(0x0000000000005cf2), UINT64_C(0x1f42fb909cb406ea), UINT64_C(0x1f42ff9044b306e2),
        UINT64_C(0x1f42fc500cb8a6b1), UINT64_C(0x1f42fe4f18b026ce)
    },
    {   UINT64_C(0x0000000000005cf3), UINT64_C(0x1f4301d058b2a6b6), UINT64_C(0x1f42fc4ea0baa72f),
        UINT64_C(0x1f42fd0f4cb4070e), UINT64_C(0x1f430150fcb366c5)
    },
    {   UINT64_C(0x0000000000005cf4), UINT64_C(0x1f4301100cb00703), UINT64_C(0x1f43045010b506f5),
        UINT64_C(0x1f42fe8e68b58731), UINT64_C(0x1f42f98f54b6a70b)
    },
    {   UINT64_C(0x0000000000005cf5), UINT64_C(0x1f42fd0ea0b586fd), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f9cfa8b7a705), UINT64_C(0x1f42ff0f64b746fe)
    },
    {   UINT64_C(0x0000000000005cf6), UINT64_C(0x1f42f90ee0b44719), UINT64_C(0x1f42fdcff8b08711),
        UINT64_C(0x1f42fe8f9cafa6ce), UINT64_C(0x1f42fccee8af4718)
    },
    {   UINT64_C(0x0000000000005cf7), UINT64_C(0x1f42fb4e9cb2a731), UINT64_C(0x1f42fe4ef0aae69d),
        UINT64_C(0x1f42fc0f8cb90706), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005cf8), UINT64_C(0x1f42fece6cb72736), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe8ee4b0a737)
    },
    {   UINT64_C(0x0000000000005cf9), UINT64_C(0x0000000000000000), UINT64_C(0x1f43010e8cb806ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd4fd4b586d4)
    },
    {   UINT64_C(0x0000000000005cfa), UINT64_C(0x1f42fd0efcb966f1), UINT64_C(0x1f42f84f3cb42710),
        UINT64_C(0x1f42fe9038b14719), UINT64_C(0x1f42ffcf50b72706)
    },
    {   UINT64_C(0x0000000000005cfb), UINT64_C(0x0000000000000000), UINT64_C(0x1f43074fa4b4c6f6),
        UINT64_C(0x1f42f9cfb8b7c706), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005cfc), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fccef0b426df),
        UINT64_C(0x1f4300cf04af86db), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005cfd), UINT64_C(0x1f43004f50b0a6fc), UINT64_C(0x1f43048fe0b126d3),
        UINT64_C(0x1f43024f08ae471c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005cfe), UINT64_C(0x1f4303cf7cb266d7), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4301cfd8af86b6), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005cff), UINT64_C(0x1f43044faca926dd), UINT64_C(0x1f42ff1020aee6bd),
        UINT64_C(0x1f42fb8f70b4c6e5), UINT64_C(0x1f4302d040b4e6e0)
    },
    {   UINT64_C(0x0000000000005d00), UINT64_C(0x1f43020f3cb6a6fd), UINT64_C(0x1f42fc4f78b5871e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb4ebcb74720)
    },
    {   UINT64_C(0x0000000000005d01), UINT64_C(0x1f43008ec8a5a6ed), UINT64_C(0x1f42fc4ec8b6473d),
        UINT64_C(0x1f42ff9080b3c6dc), UINT64_C(0x1f42fe4f18b44705)
    },
    {   UINT64_C(0x0000000000005d02), UINT64_C(0x1f43034ef8b02706), UINT64_C(0x1f4301cfe8b8071a),
        UINT64_C(0x1f42f84ed8af66f2), UINT64_C(0x1f43030ee8ada71d)
    },
    {   UINT64_C(0x0000000000005d03), UINT64_C(0x1f43010f2cb6e716), UINT64_C(0x1f4300cf04aec6e5),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fecf9cb1c706)
    },
    {   UINT64_C(0x0000000000005d04), UINT64_C(0x1f4301ceccaa8728), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d05), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43040ee0adc6fa), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d06), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff0fd8afe6f6), UINT64_C(0x1f42f80f84b64705)
    },
    {   UINT64_C(0x0000000000005d07), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fccf80b52703),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d08), UINT64_C(0x1f42ff8f50b6471d), UINT64_C(0x1f42fc8fbcb806ee),
        UINT64_C(0x1f42fa0fc8b9a6f9), UINT64_C(0x1f43008f7cb26715)
    },
    {   UINT64_C(0x0000000000005d09), UINT64_C(0x1f42fe8ea0b4e71a), UINT64_C(0x1f43000f34b5e728),
        UINT64_C(0x1f42fb4e8cb5c73e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d0a), UINT64_C(0x1f42fa9030b486e1), UINT64_C(0x1f42fe0f40afa6da),
        UINT64_C(0x1f42fbcf30b6472e), UINT64_C(0x1f42fd8e7cb64713)
    },
    {   UINT64_C(0x0000000000005d0b), UINT64_C(0x1f42fd1010b4e715), UINT64_C(0x1f42fa8e9cb3c724),
        UINT64_C(0x1f42fc8eecaa26eb), UINT64_C(0x1f42fb4f18b0272c)
    },
    {   UINT64_C(0x0000000000005d0c), UINT64_C(0x1f42fe8f74b0e6fa), UINT64_C(0x1f43004f1cac26d4),
        UINT64_C(0x1f43000f18b36729), UINT64_C(0x1f42f94f08b9271a)
    },
    {   UINT64_C(0x0000000000005d0d), UINT64_C(0x1f42fe8ebcb7e72e), UINT64_C(0x1f43128f48b18716),
        UINT64_C(0x1f43038eecb02723), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d0e), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ffd040b56721), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d0f), UINT64_C(0x1f42fe8f24ace716), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90ec8b26719)
    },
    {   UINT64_C(0x0000000000005d10), UINT64_C(0x1f42fe8f5cb1e6fe), UINT64_C(0x1f42fb8f6cacc6fa),
        UINT64_C(0x1f42fd4f2cabc6e3), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d11), UINT64_C(0x1f42fc0f78b5470e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc4facb3e6e6), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d12), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc0f1cb54713), UINT64_C(0x1f4302ce6cb0074a)
    },
    {   UINT64_C(0x0000000000005d13), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe8f5cb64700),
        UINT64_C(0x1f42fc4ea4b46708), UINT64_C(0x1f42fc4e9cb2a721)
    },
    {   UINT64_C(0x0000000000005d14), UINT64_C(0x1f42fc0ea0ae4720), UINT64_C(0x1f42ff8e94b98718),
        UINT64_C(0x1f43008f04b3870a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d15), UINT64_C(0x1f42fccf0cb2a70b), UINT64_C(0x1f42ff8f98b806db),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe4f68b64737)
    },
    {   UINT64_C(0x0000000000005d16), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff0f54ae6700),
        UINT64_C(0x1f42fb8f44aec716), UINT64_C(0x1f42facf80b70716)
    },
    {   UINT64_C(0x0000000000005d17), UINT64_C(0x1f42fc4eb0baa730), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff8ec4b1a71f), UINT64_C(0x1f43118f30b0e710)
    },
    {   UINT64_C(0x0000000000005d18), UINT64_C(0x1f42fd0ee4b426dd), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f90ee0bb270e), UINT64_C(0x1f42ffcea4acc72e)
    },
    {   UINT64_C(0x0000000000005d19), UINT64_C(0x1f42fd0f14af870e), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f58ebcb5c727)
    },
    {   UINT64_C(0x0000000000005d1a), UINT64_C(0x0000000000000000), UINT64_C(0x1f430e4f2cb08737),
        UINT64_C(0x1f43010f08b26713), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d1b), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fecf3cb5c71a),
        UINT64_C(0x1f42f6ce9cb4c6fc), UINT64_C(0x1f42f98e9cb48735)
    },
    {   UINT64_C(0x0000000000005d1c), UINT64_C(0x1f42fb4fb8b8072d), UINT64_C(0x1f42f98e8cb5c719),
        UINT64_C(0x1f42facf78b72724), UINT64_C(0x1f4300cfd8b34738)
    },
    {   UINT64_C(0x0000000000005d1d), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f9cf30b6e6f5),
        UINT64_C(0x1f42fd0f64af86fc), UINT64_C(0x1f42fe8f54b4271c)
    },
    {   UINT64_C(0x0000000000005d1e), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fdcf3cb74719),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d1f), UINT64_C(0x1f43020e84b38732), UINT64_C(0x1f43054fc4b666de),
        UINT64_C(0x1f42ff0fb4b3472d), UINT64_C(0x1f43144f28aea70a)
    },
    {   UINT64_C(0x0000000000005d20), UINT64_C(0x1f42fc8e7cb0c732), UINT64_C(0x1f42fb0f44b4472e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43008f1caf4725)
    },
    {   UINT64_C(0x0000000000005d21), UINT64_C(0x0000000000000000), UINT64_C(0x1f4302ceccb92722),
        UINT64_C(0x1f42fe8ed0b7470a), UINT64_C(0x1f42fad010b64719)
    },
    {   UINT64_C(0x0000000000005d22), UINT64_C(0x1f42fa0f58b5a6ee), UINT64_C(0x1f42f74f54b40721),
        UINT64_C(0x1f42ffcf30b10719), UINT64_C(0x1f42face6caf8740)
    },
    {   UINT64_C(0x0000000000005d23), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff0f0cb1c6f4), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d24), UINT64_C(0x1f42fccfe8b706ec), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff4f6cb626e4), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d25), UINT64_C(0x1f43018eb0ae8726), UINT64_C(0x1f42fe4ed8b1e70d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43158f34a586fc)
    },
    {   UINT64_C(0x0000000000005d26), UINT64_C(0x1f42fdce50b4472f), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4300ceccac2708), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d27), UINT64_C(0x1f42fe4ec4b2e736), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa4ef0b2c733), UINT64_C(0x1f42fe8ea4ac2723)
    },
    {   UINT64_C(0x0000000000005d28), UINT64_C(0x1f43030f60b6a70c), UINT64_C(0x1f42fd8f6cb1e6de),
        UINT64_C(0x1f43004f38b286df), UINT64_C(0x1f42fe0e80b36722)
    },
    {   UINT64_C(0x0000000000005d29), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f94f98b726f7),
        UINT64_C(0x1f42fccf50b7672c), UINT64_C(0x1f43028f24ab8739)
    },
    {   UINT64_C(0x0000000000005d2a), UINT64_C(0x1f42f84e9cb60734), UINT64_C(0x1f42fc0ec4b72735),
        UINT64_C(0x1f42fd0f08b2c6f8), UINT64_C(0x1f43000f00b12706)
    },
    {   UINT64_C(0x0000000000005d2b), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc8f44b466ce),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8ec4b6a727)
    },
    {   UINT64_C(0x0000000000005d2c), UINT64_C(0x1f42f84e78b68720), UINT64_C(0x1f42fd8ef8b466c7),
        UINT64_C(0x1f42fd0f5cb54705), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d2d), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa4f48b54706),
        UINT64_C(0x1f42f98f54b2c71d), UINT64_C(0x1f42faceecb5a6f8)
    },
    {   UINT64_C(0x0000000000005d2e), UINT64_C(0x1f42ff4ed0af071a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43078f4cb226f3), UINT64_C(0x1f42fd4e6cb1e711)
    },
    {   UINT64_C(0x000000001ff9bec0), UINT64_C(0x12eaf30fa0906693), UINT64_C(0x1172f60fa07fe693),
        UINT64_C(0x1162f5cfa07fc693), UINT64_C(0x1a02f30fa0a22693)
    },
    {   UINT64_C(0x0000000000005d30), UINT64_C(0x1f42fc8ea8af26eb), UINT64_C(0x1f42fb4e54b28738),
        UINT64_C(0x1f42fb8ef4b1c72d), UINT64_C(0x1f430210e0b306d5)
    },
    {   UINT64_C(0x0000000000005d31), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff0eecb6a71e),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d32), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fe0e74b1a737), UINT64_C(0x1f43028f30b3c6fd)
    },
    {   UINT64_C(0x0000000000005d33), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4300cf28b24702)
    },
    {   UINT64_C(0x0000000000005d34), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb4eecaf2719), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d35), UINT64_C(0x1f42fb0f3caf6708), UINT64_C(0x1f43128e88ac6730),
        UINT64_C(0x1f42fc0eb0b64738), UINT64_C(0x1f42fece24ada735)
    },
    {   UINT64_C(0x0000000000005d36), UINT64_C(0x1f42fcce7caf8728), UINT64_C(0x1f42fbce98b20745),
        UINT64_C(0x1f42fc0e54b2e731), UINT64_C(0x1f42f8cf1cb84728)
    },
    {   UINT64_C(0x0000000000005d37), UINT64_C(0x1f42fbcf34b5a6ff), UINT64_C(0x1f42facf78b5a6e3),
        UINT64_C(0x1f42f54ff0b4271a), UINT64_C(0x1f42fa4f78b606ed)
    },
    {   UINT64_C(0x0000000000005d38), UINT64_C(0x1f42f74f38b6a72e), UINT64_C(0x1f42faceccb98715),
        UINT64_C(0x1f42f70f54b886ee), UINT64_C(0x1f4301cf38b0071c)
    },
    {   UINT64_C(0x0000000000005d39), UINT64_C(0x1f42f90efcb62736), UINT64_C(0x1f43054e78b86712),
        UINT64_C(0x1f431d8f8cb4a6f9), UINT64_C(0x1f42ff0f50b30700)
    },
    {   UINT64_C(0x0000000000005d3a), UINT64_C(0x1f42fb4f48b6c6ae), UINT64_C(0x1f43028f50b4a6c0),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d3b), UINT64_C(0x1f42f50f40b5e6d4), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4312cf38adc6f4), UINT64_C(0x1f43038ffcb726cf)
    },
    {   UINT64_C(0x0000000000005d3c), UINT64_C(0x1f42f98f50b5a700), UINT64_C(0x1f43028f50b4a6e2),
        UINT64_C(0x1f42ff0f50b30708), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d3d), UINT64_C(0x1f42f9cf40ba26fe), UINT64_C(0x1f42fa4f3cb826da),
        UINT64_C(0x1f42f74fc0b6c70e), UINT64_C(0x1f430c4ec8b20724)
    },
    {   UINT64_C(0x0000000000005d3e), UINT64_C(0x1f42ff0f50b306c2), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f6ce9cb70717)
    },
    {   UINT64_C(0x0000000000005d3f), UINT64_C(0x0000000000000000), UINT64_C(0x1f43148e60af872f),
        UINT64_C(0x1f42fa0f34b7c6f6), UINT64_C(0x1f42f7cf38b6e6ea)
    },
    {   UINT64_C(0x0000000000005d40), UINT64_C(0x1f42fdcf64b486ea), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f4cf30b7670f), UINT64_C(0x1f430d0ec4afe71e)
    },
    {   UINT64_C(0x0000000000005d41), UINT64_C(0x1f43020ff8b526e9), UINT64_C(0x1f42ff0f50b306ec),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430c0ea4abc725)
    },
    {   UINT64_C(0x0000000000005d42), UINT64_C(0x1f42fc0f18b8070c), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4300cf20b80706)
    },
    {   UINT64_C(0x0000000000005d43), UINT64_C(0x1f43049048b846b6), UINT64_C(0x1f43110ebcb46741),
        UINT64_C(0x1f42f80ebcb66731), UINT64_C(0x1f4317ceccad2717)
    },
    {   UINT64_C(0x0000000000005d44), UINT64_C(0x1f42f9cf38b486fe), UINT64_C(0x1f43018f60b4870d),
        UINT64_C(0x1f42fe0f68b666df), UINT64_C(0x1f43064ed0b10734)
    },
    {   UINT64_C(0x0000000000005d45), UINT64_C(0x1f42f58ea4b62718), UINT64_C(0x1f43138e5cb36742),
        UINT64_C(0x1f4312ceb0b0c711), UINT64_C(0x1f42f84f64b7a71d)
    },
    {   UINT64_C(0x0000000000005d46), UINT64_C(0x1f42fecf88b20706), UINT64_C(0x1f4302ce9cb14725),
        UINT64_C(0x1f430b4f1cb46739), UINT64_C(0x1f42f80fb8b6a6da)
    },
    {   UINT64_C(0x0000000000005d47), UINT64_C(0x1f42f94fd8b6c6e5), UINT64_C(0x1f42f74e9cb2a709),
        UINT64_C(0x1f42f9ce30b5870e), UINT64_C(0x1f430d8f98b0e71c)
    },
    {   UINT64_C(0x0000000000005d48), UINT64_C(0x0000000000000000), UINT64_C(0x1f4302cfe0b7c704),
        UINT64_C(0x1f42fa8ee4afc72f), UINT64_C(0x1f43000ee4b2872f)
    },
    {   UINT64_C(0x0000000000005d49), UINT64_C(0x0000000000000000), UINT64_C(0x1f43038f3cad6709),
        UINT64_C(0x1f42ffcf58b6472c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d4a), UINT64_C(0x1f430ccf68a346f9), UINT64_C(0x1f430e8f9cb526de),
        UINT64_C(0x1f43078e54a2a72e), UINT64_C(0x1f430a8e58b0072c)
    },
    {   UINT64_C(0x0000000000005d4b), UINT64_C(0x1f4320cef89ea722), UINT64_C(0x1f43134e94a5471f),
        UINT64_C(0x1f43288ec4a0e70f), UINT64_C(0x1f43154edca9a724)
    },
    {   UINT64_C(0x0000000000005d4c), UINT64_C(0x1f431310d8ac06a1), UINT64_C(0x1f43158fcca9a708),
        UINT64_C(0x1f431b8ed8a6c6f3), UINT64_C(0x1f431cce78a4272c)
    },
    {   UINT64_C(0x0000000000005d4d), UINT64_C(0x0000000000000000), UINT64_C(0x1f431e0f70b1e6f9),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430ecee8a446fb)
    },
    {   UINT64_C(0x0000000000005d4e), UINT64_C(0x1f4310ce90a62738), UINT64_C(0x1f43114ec0ab8719),
        UINT64_C(0x1f4300500cb406bc), UINT64_C(0x1f4310cfdcaa26d3)
    },
    {   UINT64_C(0x0000000000005d4f), UINT64_C(0x1f430b8e6caf070f), UINT64_C(0x1f43084eeca7470e),
        UINT64_C(0x1f4321ce74a306fc), UINT64_C(0x1f42fd1094ae06c8)
    },
    {   UINT64_C(0x0000000000005d50), UINT64_C(0x1f43094e98ae06ee), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d51), UINT64_C(0x1f43100fa4a906fe), UINT64_C(0x1f43020f74b14712),
        UINT64_C(0x1f42ffd0a4b2c6d8), UINT64_C(0x1f42ff0f04ad26f6)
    },
    {   UINT64_C(0x0000000000014908), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0fa2f80dc0780407)
    },
    {   UINT64_C(0x0000000000005d53), UINT64_C(0x1f42fc4e88b7c71e), UINT64_C(0x1f42f50e84b80708),
        UINT64_C(0x1f42fb0fd4b5c6f8), UINT64_C(0x1f4304cf28b50712)
    },
    {   UINT64_C(0x0000000000005d54), UINT64_C(0x0000000000000000), UINT64_C(0x1f43004fd8b266d8),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d55), UINT64_C(0x1f42fb0ec8b7c73b), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d56), UINT64_C(0x0000000000000000), UINT64_C(0x1f43188f20aa4724),
        UINT64_C(0x1f43028e94b62731), UINT64_C(0x1f42fb0eb4b9a72e)
    },
    {   UINT64_C(0x0000000000005d57), UINT64_C(0x1f4304cec4b0e737), UINT64_C(0x1f42fc1020b6c6ff),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43204e7cb3a70d)
    },
    {   UINT64_C(0x0000000000005d58), UINT64_C(0x1f43244f20a04736), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43038e6cb16724), UINT64_C(0x1f4308ce94b52714)
    },
    {   UINT64_C(0x0000000000005d59), UINT64_C(0x1f42fb4ec0b1470a), UINT64_C(0x1f42fe0f28b9a71c),
        UINT64_C(0x1f43010f94b64719), UINT64_C(0x1f4306ce88af6725)
    },
    {   UINT64_C(0x0000000000005d5a), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f64f48b7470e),
        UINT64_C(0x1f4302ce84b7873c), UINT64_C(0x1f430b4ee0af6748)
    },
    {   UINT64_C(0x0000000000005d5b), UINT64_C(0x1f4307cf2cb3872e), UINT64_C(0x1f42f40f08b8872c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f84f70b7872b)
    },
    {   UINT64_C(0x0000000000005d5c), UINT64_C(0x1f43044f14b1671c), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43060ec4b44737), UINT64_C(0x1f430b0ea4ad0713)
    },
    {   UINT64_C(0x0000000000005d5d), UINT64_C(0x1f42ff0e9caf0729), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430e4e74afc730), UINT64_C(0x1f42f8d000b706df)
    },
    {   UINT64_C(0x0000000000005d5e), UINT64_C(0x1f42fa0e80b66737), UINT64_C(0x1f42f84f9cb56719),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d5f), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f5cf64b6a70e),
        UINT64_C(0x1f4307cfb8af2709), UINT64_C(0x1f43068e28b1273e)
    },
    {   UINT64_C(0x0000000000005d60), UINT64_C(0x1f42ff4eecb4e6f8), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43070eb8af0718), UINT64_C(0x1f42f90f6cb06725)
    },
    {   UINT64_C(0x0000000000005d61), UINT64_C(0x1f42feceacb4670c), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43018f90b14708), UINT64_C(0x1f43018e64b56748)
    },
    {   UINT64_C(0x0000000000005d62), UINT64_C(0x0000000000000000), UINT64_C(0x1f4307ceb8aea72d),
        UINT64_C(0x1f430dce78b0072d), UINT64_C(0x1f4302d034b726ea)
    },
    {   UINT64_C(0x0000000000014919), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x000000000001491a), UINT64_C(0x15baee0f5495669a), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d65), UINT64_C(0x1f42f84f00a96726), UINT64_C(0x1f42fb8f0cb1872a),
        UINT64_C(0x1f42f84f28a70726), UINT64_C(0x1f42fe0ed8a3c71e)
    },
    {   UINT64_C(0x0000000000005d66), UINT64_C(0x1f42f60f64ad870a), UINT64_C(0x1f42f90ed0b06716),
        UINT64_C(0x1f42ff0f80b5c722), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d67), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f94f24a78726),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc8f34ab072a)
    },
    {   UINT64_C(0x0000000000005d68), UINT64_C(0x1f42fb0f3ca56726), UINT64_C(0x1f42f84f28aac726),
        UINT64_C(0x1f42fc8f88afe729), UINT64_C(0x1f42fa4f90af471a)
    },
    {   UINT64_C(0x0000000000005d69), UINT64_C(0x1f42f90f74b1871e), UINT64_C(0x1f42f6ce8cb4472e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb8f90ac6716)
    },
    {   UINT64_C(0x0000000000005d6a), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb0fd4b3a722), UINT64_C(0x1f43050f24b8071e)
    },
    {   UINT64_C(0x0000000000005d6b), UINT64_C(0x1f42fc0f88a52716), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f84f78b3471a), UINT64_C(0x1f42fb4f1cb0e726)
    },
    {   UINT64_C(0x0000000000005d6c), UINT64_C(0x1f42fa8ea8b26703), UINT64_C(0x1f42fa4f80ae071e),
        UINT64_C(0x1f42fb0f4cb20726), UINT64_C(0x1f42facf54b0c72e)
    },
    {   UINT64_C(0x0000000000005d6d), UINT64_C(0x1f42f94ef4a9c71e), UINT64_C(0x1f42f6cf38b38723),
        UINT64_C(0x1f42f88f24b0272e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d6e), UINT64_C(0x1f42f74ef4aee71e), UINT64_C(0x1f42f84e60b58737),
        UINT64_C(0x1f42f94f00b1a726), UINT64_C(0x1f42fe8ee8adc723)
    },
    {   UINT64_C(0x0000000000005d6f), UINT64_C(0x1f42f84ea4b84739), UINT64_C(0x1f42fb0fb0b0e722),
        UINT64_C(0x1f42fb0f84b4471e), UINT64_C(0x1f42fd8e4cb1872e)
    },
    {   UINT64_C(0x0000000000005d70), UINT64_C(0x1f42fa8ee0aa071b), UINT64_C(0x1f42ff8eaca6c713),
        UINT64_C(0x1f42f80f64aec71e), UINT64_C(0x1f42fa0f74a60713)
    },
    {   UINT64_C(0x0000000000005d71), UINT64_C(0x1f42face78a6271d), UINT64_C(0x1f42fb0f94aac71f),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb0f94b0e722)
    },
    {   UINT64_C(0x0000000000005d72), UINT64_C(0x1f42fb0f4ca44721), UINT64_C(0x1f42fa0fb4abe722),
        UINT64_C(0x1f42f80fa0b52727), UINT64_C(0x1f42fbcf24a9271e)
    },
    {   UINT64_C(0x0000000000005d73), UINT64_C(0x1f42fc8e9caba715), UINT64_C(0x1f42fbceb4b5073c),
        UINT64_C(0x1f42facf44a74716), UINT64_C(0x1f42fbcef8a1e721)
    },
    {   UINT64_C(0x0000000000005d74), UINT64_C(0x1f42f90f08b02726), UINT64_C(0x1f42fd0e90ab6722),
        UINT64_C(0x1f42f84e6caa8726), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d75), UINT64_C(0x1f42f74e5cb14748), UINT64_C(0x1f42facec0b7a743),
        UINT64_C(0x1f42f9cf94ade70e), UINT64_C(0x1f42f8ce68b0c72d)
    },
    {   UINT64_C(0x0000000000005d76), UINT64_C(0x1f42fa8f34ade72a), UINT64_C(0x1f42fe0f88b2471b),
        UINT64_C(0x1f42f78ebcaa0731), UINT64_C(0x1f42fd8f18a62731)
    },
    {   UINT64_C(0x0000000000005d77), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f84eb0b22731),
        UINT64_C(0x1f42f98f3cad2725), UINT64_C(0x1f43034e34a88726)
    },
    {   UINT64_C(0x0000000000005d78), UINT64_C(0x1f42f70e88b0e729), UINT64_C(0x1f42fa8e80b02721),
        UINT64_C(0x1f42f84eeca68731), UINT64_C(0x1f42f5cf54b04739)
    },
    {   UINT64_C(0x0000000000005d79), UINT64_C(0x1f42fa4eb8afe72a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f68e90af4723), UINT64_C(0x1f42fccf38ad2733)
    },
    {   UINT64_C(0x0000000000014930), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x0000000000014931), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x0000000000014932), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x0000000000014933), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x0000000000014934), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x0000000000014935), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x0000000000005d80), UINT64_C(0x1f42f8cf60b4c729), UINT64_C(0x1f42f80e6cb06735),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f60e68b9c72a)
    },
    {   UINT64_C(0x0000000000014937), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x0000000000014938), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x0000000000014939), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x000000000001493a), UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d85), UINT64_C(0x1f42f6ce7cac2725), UINT64_C(0x1f42f84f28b60729),
        UINT64_C(0x1f42fc8e94af0735), UINT64_C(0x1f42fa0f6cb2a715)
    },
    {   UINT64_C(0x0000000000005d86), UINT64_C(0x1f42f80ef4aa672d), UINT64_C(0x1f42f68ef4b48732),
        UINT64_C(0x1f42f6cf04b4272d), UINT64_C(0x1f42f74f04ae2739)
    },
    {   UINT64_C(0x0000000000005d87), UINT64_C(0x1f42fc4ef8b2c738), UINT64_C(0x1f42f98f00aaa72e),
        UINT64_C(0x1f42f84f70af873e), UINT64_C(0x1f43000e8cb42726)
    },
    {   UINT64_C(0x0000000000005d88), UINT64_C(0x1f42f54e50b5e73d), UINT64_C(0x1f42f98ee0b5873d),
        UINT64_C(0x1f42f44f60b56732), UINT64_C(0x1f42f68f38b1e731)
    },
    {   UINT64_C(0x0000000000005d89), UINT64_C(0x1f42f80eb4a86739), UINT64_C(0x1f42fbcf14ab671d),
        UINT64_C(0x1f42f90e98b26741), UINT64_C(0x1f42f84f00aee741)
    },
    {   UINT64_C(0x0000000000005d8a), UINT64_C(0x1f43000e8cb2c725), UINT64_C(0x1f42f54e90b58740),
        UINT64_C(0x1f42f8cf04b3e71e), UINT64_C(0x1f42f84f94ae8741)
    },
    {   UINT64_C(0x0000000000005d8b), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8e9cab071a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe4f84b44712)
    },
    {   UINT64_C(0x0000000000005d8c), UINT64_C(0x1f42fb0ebca7a723), UINT64_C(0x1f42f9cf04b08720),
        UINT64_C(0x1f42f90f14b6872e), UINT64_C(0x1f42fa4ebcb4e735)
    },
    {   UINT64_C(0x0000000000014943), UINT64_C(0x16233d8ae498853c), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000014944), UINT64_C(0x1622eb4ae46f453c), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000014945), UINT64_C(0x16233d93cc988776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000014946), UINT64_C(0x1622eb53cc6f4776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000014947), UINT64_C(0x16233d8ae4988776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d92), UINT64_C(0x1f42f8cef0b60735), UINT64_C(0x1f42fa4eccafc73d),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000014949), UINT64_C(0x1622eb4ae46f4776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d94), UINT64_C(0x1f42f9ce84b2a721), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f84ec0b24729), UINT64_C(0x1f42fd4f60b6a715)
    },
    {   UINT64_C(0x000000000001494b), UINT64_C(0x1622eb4ae498653c), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d96), UINT64_C(0x1f42f98e30aee740), UINT64_C(0x1f42fb0e6cb68726),
        UINT64_C(0x1f42f98ed0a68732), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001494d), UINT64_C(0x1622eb53cc986776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d98), UINT64_C(0x1f42f70e9cb4a732), UINT64_C(0x1f42f84f44b6a72d),
        UINT64_C(0x1f42fa4e60b7273a), UINT64_C(0x1f42f8ce7cb1c71f)
    },
    {   UINT64_C(0x000000000001494f), UINT64_C(0x1622eb4ae4986776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000003651), UINT64_C(0x106af6cfa07bc667), UINT64_C(0x106af6cfa07bc667),
        UINT64_C(0x106af6cfa07bc667), UINT64_C(0x106af6cfa07bc667)
    },
    {   UINT64_C(0x0000000000005d9b), UINT64_C(0x1f42f8ce6cb4671f), UINT64_C(0x1f42fa4e64b0c72a),
        UINT64_C(0x1f42f5ce90b1a73a), UINT64_C(0x1f42f54f04a5e72e)
    },
    {   UINT64_C(0x0000000000005d9c), UINT64_C(0x1f42f44ea0b46739), UINT64_C(0x1f42f7cf4cb3e731),
        UINT64_C(0x1f42f74ed4ad4731), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d9d), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f50e8cac2742),
        UINT64_C(0x1f42fcd390b4072e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005d9e), UINT64_C(0x1f43030fc0b7072e), UINT64_C(0x1f4302cee0b3a715),
        UINT64_C(0x1f42fc4f40b4472e), UINT64_C(0x1f42ff0f84b78737)
    },
    {   UINT64_C(0x0000000000014955), UINT64_C(0x1623264ae4986599), UINT64_C(0x1622eb4ae46f4599),
        UINT64_C(0x1622eb4ae47ae53c), UINT64_C(0x1622eb4ae47ae599)
    },
    {   UINT64_C(0x0000000000005da0), UINT64_C(0x1f43188edca64732), UINT64_C(0x1f43114e2cb16715),
        UINT64_C(0x1f430cceccac4732), UINT64_C(0x1f43018f24b1c715)
    },
    {   UINT64_C(0x0000000000014957), UINT64_C(0x1622eb53cc7ae776), UINT64_C(0x1622eb52587ae776),
        UINT64_C(0x16233d8ae4988776), UINT64_C(0x1623264ae4988776)
    },
    {   UINT64_C(0x0000000000014958), UINT64_C(0x1623264ae4988776), UINT64_C(0x1622eb4ae46f4776),
        UINT64_C(0x1622eb4ae47ae776), UINT64_C(0x1622eb4ae47ae776)
    },
    {   UINT64_C(0x0000000000014959), UINT64_C(0x1622eb4ae4986599), UINT64_C(0x1622eb4ae498653c),
        UINT64_C(0x1622eb4ae4986599), UINT64_C(0x1622eb5258986776)
    },
    {   UINT64_C(0x000000000001495a), UINT64_C(0x1622eb53cc986776), UINT64_C(0x1622eb5258986776),
        UINT64_C(0x1622eb4ae4986776), UINT64_C(0x1622eb4ae4986776)
    },
    {   UINT64_C(0x000000000001495b), UINT64_C(0x1622eb4ae4986776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005da6), UINT64_C(0x0000000000000000), UINT64_C(0x1f430a8ed4abc706),
        UINT64_C(0x1f43094f7cb3c726), UINT64_C(0x1f43108f00b04718)
    },
    {   UINT64_C(0x0000000000005da7), UINT64_C(0x1f43028ee0ade726), UINT64_C(0x1f43058f28b5a6ee),
        UINT64_C(0x1f43084eacb78724), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005da9), UINT64_C(0x1f42fe8ed4b4470f), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43020f10b526f3), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005daa), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43034e6cb4471b), UINT64_C(0x1f43074f38b0e729)
    },
    {   UINT64_C(0x0000000000005dab), UINT64_C(0x0000000000000000), UINT64_C(0x1f43024e84b3872f),
        UINT64_C(0x1f43028f18b68719), UINT64_C(0x1f42f84e5cb68701)
    },
    {   UINT64_C(0x0000000000005dac), UINT64_C(0x1f42fb4f84b7270f), UINT64_C(0x1f4309cf80b5270a),
        UINT64_C(0x1f42ff8fa4b4a6fa), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005dad), UINT64_C(0x1f43018fb4b68710), UINT64_C(0x1f42ff8f70b6270e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f84f54b6870a)
    },
    {   UINT64_C(0x0000000000005dae), UINT64_C(0x1f42fc8ef8b5270a), UINT64_C(0x1f42fa8f24b526fb),
        UINT64_C(0x1f43024f9cb5472e), UINT64_C(0x1f42f58f50b526f5)
    },
    {   UINT64_C(0x0000000000005daf), UINT64_C(0x0000000000000000), UINT64_C(0x1f4309cf2cb72706),
        UINT64_C(0x1f43094ee4b6270e), UINT64_C(0x1f42fc91ccb4c63e)
    },
    {   UINT64_C(0x0000000000005db0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43008ff0b2870e), UINT64_C(0x1f43048f74b2c705)
    },
    {   UINT64_C(0x0000000000005db1), UINT64_C(0x1f43078f8cafc6f4), UINT64_C(0x1f42fecf54b3c715),
        UINT64_C(0x1f43038f48b86709), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005db2), UINT64_C(0x1f43068f78b2c6fc), UINT64_C(0x1f43138f50b1a712),
        UINT64_C(0x1f43000fd4b3a72b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005db3), UINT64_C(0x0000000000000000), UINT64_C(0x1f43064ef4b2872d),
        UINT64_C(0x1f42ffcef8b12720), UINT64_C(0x1f430e8f7cab6714)
    },
    {   UINT64_C(0x0000000000005db4), UINT64_C(0x1f430f8f60acc718), UINT64_C(0x1f4304cfccb046f4),
        UINT64_C(0x1f4302cf40b8e728), UINT64_C(0x1f430f8f54acc6e4)
    },
    {   UINT64_C(0x0000000000005db5), UINT64_C(0x1f43068f44b1a724), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430a8facb04733), UINT64_C(0x1f430f8f6cacc71c)
    },
    {   UINT64_C(0x0000000000005db6), UINT64_C(0x1f4311501cab672e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430e4ee0ace717), UINT64_C(0x1f43088f04afc72c)
    },
    {   UINT64_C(0x0000000000005db7), UINT64_C(0x1f4301cf5cb1471b), UINT64_C(0x1f43154f10ac472d),
        UINT64_C(0x1f430bcf30b1a727), UINT64_C(0x1f43058f8cb12707)
    },
    {   UINT64_C(0x0000000000005db8), UINT64_C(0x0000000000000000), UINT64_C(0x1f43100f10b0e734),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430e8fecb2271a)
    },
    {   UINT64_C(0x0000000000005db9), UINT64_C(0x1f42fc8f58b76743), UINT64_C(0x1f4306cfb4b48721),
        UINT64_C(0x1f43030ef8b42721), UINT64_C(0x1f42fa0f08aec72f)
    },
    {   UINT64_C(0x0000000000005dba), UINT64_C(0x0000000000000000), UINT64_C(0x1f430e8f74b4670e),
        UINT64_C(0x1f43124f38adc6ff), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005dbb), UINT64_C(0x1f430d4f28ac46fb), UINT64_C(0x1f4311cf38b2872d),
        UINT64_C(0x1f432f10089966e2), UINT64_C(0x1f43098f3cb5e6a1)
    },
    {   UINT64_C(0x0000000000005dbc), UINT64_C(0x1f43000f38b226d9), UINT64_C(0x1f43020f4cb226d9),
        UINT64_C(0x1f43058e80af0736), UINT64_C(0x1f43049068b586c7)
    },
    {   UINT64_C(0x0000000000005dbd), UINT64_C(0x1f43058f18af8712), UINT64_C(0x1f43034f18b1a70b),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430a0f48ac6714)
    },
    {   UINT64_C(0x0000000000005dbe), UINT64_C(0x1f42fbcf28a86724), UINT64_C(0x1f43034f8cb226f8),
        UINT64_C(0x1f430a0e6caf26d7), UINT64_C(0x1f43060f0cb726ed)
    },
    {   UINT64_C(0x0000000000005dbf), UINT64_C(0x1f43050f38b7a6fe), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43044eb0af871d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005dc0), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cea0a9472b),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43074ffcadc683)
    },
    {   UINT64_C(0x0000000000005dc1), UINT64_C(0x1f430a0efcaa66d1), UINT64_C(0x1f430a8f68b4e695),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43080e80b2070e)
    },
    {   UINT64_C(0x0000000000005dc2), UINT64_C(0x1f43074ffcb626e3), UINT64_C(0x1f42fc8f0ca10719),
        UINT64_C(0x1f43059030b0e6e1), UINT64_C(0x1f42ff0ea0ada72a)
    },
    {   UINT64_C(0x0000000000005dc3), UINT64_C(0x1f43140e50a88733), UINT64_C(0x1f430b0ffcb0c6cc),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005dc4), UINT64_C(0x1f43065004b64694), UINT64_C(0x1f4307cf84b3c6d9),
        UINT64_C(0x1f43084e5cad0715), UINT64_C(0x1f4307cf10b3a6e4)
    },
    {   UINT64_C(0x0000000000005dc5), UINT64_C(0x0000000000000000), UINT64_C(0x1f43064e74b9a720),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005dc6), UINT64_C(0x0000000000000000), UINT64_C(0x1f43064f78ade6ff),
        UINT64_C(0x1f430f4e80b00737), UINT64_C(0x1f43064ebcb6c702)
    },
    {   UINT64_C(0x0000000000005dc7), UINT64_C(0x0000000000000000), UINT64_C(0x1f43074eacb6470a),
        UINT64_C(0x1f430d4e8cac0738), UINT64_C(0x1f43050ee8b00729)
    },
    {   UINT64_C(0x0000000000005dc8), UINT64_C(0x1f43085014b206f2), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43048ea0ad872c), UINT64_C(0x1f43054f60b8c6f9)
    },
    {   UINT64_C(0x0000000000005dc9), UINT64_C(0x1f42fa4f94b566e2), UINT64_C(0x1f43090e70aae71d),
        UINT64_C(0x1f4309d0a0b3c6e9), UINT64_C(0x1f430b8fe8a706d4)
    },
    {   UINT64_C(0x0000000000005dca), UINT64_C(0x1f43010fa0b806fb), UINT64_C(0x1f430a106caf4713),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005dcb), UINT64_C(0x0000000000000000), UINT64_C(0x1f43091024afc715),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4304cf38b546ff)
    },
    {   UINT64_C(0x0000000000005dcc), UINT64_C(0x0000000000000000), UINT64_C(0x1f430bcf10b2c70f),
        UINT64_C(0x1f430c0e8cb2e6f8), UINT64_C(0x1f430b0fc8ab2709)
    },
    {   UINT64_C(0x0000000000005dcd), UINT64_C(0x1f430bcf1cab271e), UINT64_C(0x1f430fcef4ab472c),
        UINT64_C(0x1f43084f80b266da), UINT64_C(0x1f42fd8e94b72731)
    },
    {   UINT64_C(0x0000000000005dce), UINT64_C(0x1f43080e9cb46727), UINT64_C(0x1f43075044b3c71e),
        UINT64_C(0x1f43055028b40707), UINT64_C(0x1f430c4e7cb2c72f)
    },
    {   UINT64_C(0x0000000000005dcf), UINT64_C(0x1f430b4f54b82701), UINT64_C(0x1f43090f10b5c710),
        UINT64_C(0x1f43060f78a7a701), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005dd0), UINT64_C(0x1f43004ed0aa8735), UINT64_C(0x1f43090eb4b1472e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430a0f9cb4a71f)
    },
    {   UINT64_C(0x0000000000005dd1), UINT64_C(0x1f430f4ef0ace724), UINT64_C(0x1f43064e9cade703),
        UINT64_C(0x1f43028fc8b18712), UINT64_C(0x1f43064e68b16730)
    },
    {   UINT64_C(0x0000000000005dd2), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430f4e70a766e9), UINT64_C(0x1f43028f4cae471f)
    },
    {   UINT64_C(0x0000000000005dd3), UINT64_C(0x1f43038ea8af872b), UINT64_C(0x1f43058f0cb42703),
        UINT64_C(0x1f43088e2caee722), UINT64_C(0x1f430fcff8aca694)
    },
    {   UINT64_C(0x0000000000005dd4), UINT64_C(0x1f43090ee8b5c712), UINT64_C(0x1f43070ffcb246e0),
        UINT64_C(0x1f43040eecb5c70d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005dd5), UINT64_C(0x1f43050eecb8e6fe), UINT64_C(0x1f43034f8cb4e6f2),
        UINT64_C(0x1f43034efcb7671e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005dd6), UINT64_C(0x0000000000000000), UINT64_C(0x1f43050f2cb8a715),
        UINT64_C(0x1f43028ff8b2e6d8), UINT64_C(0x1f430c4e80b5673c)
    },
    {   UINT64_C(0x0000000000005dd7), UINT64_C(0x1f43090eb4b4673a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43048eacb7c726), UINT64_C(0x1f4302ce6cb36726)
    },
    {   UINT64_C(0x0000000000005dd8), UINT64_C(0x1f42ff8f04b94718), UINT64_C(0x1f4308cff4b246ff),
        UINT64_C(0x1f43094efcb20738), UINT64_C(0x1f4300ce50b6472c)
    },
    {   UINT64_C(0x0000000000005dd9), UINT64_C(0x0000000000000000), UINT64_C(0x1f43080e6cb4c731),
        UINT64_C(0x1f430e4f70afa702), UINT64_C(0x1f43058ed0b326fa)
    },
    {   UINT64_C(0x0000000000005dda), UINT64_C(0x1f43048f48b766f9), UINT64_C(0x1f43028ebcb6471b),
        UINT64_C(0x1f43094eacad6724), UINT64_C(0x1f430a4f18b76736)
    },
    {   UINT64_C(0x0000000000005ddb), UINT64_C(0x1f43084ef8b6a716), UINT64_C(0x1f43058f08aec6e1),
        UINT64_C(0x1f43020e7cb8670c), UINT64_C(0x1f43114e84b3e727)
    },
    {   UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f85), UINT64_C(0x1f43030edcb50702), UINT64_C(0x1f4306d04cb2c6ee),
        UINT64_C(0x1f43098f4cad6707), UINT64_C(0x1f43094f5cb60724)
    },
    {   UINT64_C(0x0000000000005dde), UINT64_C(0x0000000000000000), UINT64_C(0x1f430bced0b38722),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ddf), UINT64_C(0x1f43030f10b7e6dd), UINT64_C(0x1f43044f78b786ff),
        UINT64_C(0x1f43170e4caa0732), UINT64_C(0x1f43038e48b7a729)
    },
    {   UINT64_C(0x0000000000005de0), UINT64_C(0x1f4309ce80b36726), UINT64_C(0x1f43040f1cb0e6f3),
        UINT64_C(0x1f42f68f80b4a6f3), UINT64_C(0x1f4306cf00acc702)
    },
    {   UINT64_C(0x0000000000005de1), UINT64_C(0x1f43050f80ad06f5), UINT64_C(0x1f42fb4f6cb8a6d8),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43050f98b386e8)
    },
    {   UINT64_C(0x0000000000005de2), UINT64_C(0x1f4305cef0b5072c), UINT64_C(0x1f43000f50b6071a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430bcf00b3072f)
    },
    {   UINT64_C(0x0000000000005de3), UINT64_C(0x1f43064f58b60721), UINT64_C(0x1f430bcf84b42715),
        UINT64_C(0x1f43094f38b24725), UINT64_C(0x1f4312ceb0b0070b)
    },
    {   UINT64_C(0x0000000000005de4), UINT64_C(0x0000000000000000), UINT64_C(0x1f43044facade6f0),
        UINT64_C(0x1f43098ed0ae4702), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005de5), UINT64_C(0x0000000000000000), UINT64_C(0x1f43070e9cac8735),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43074ea0ade71d)
    },
    {   UINT64_C(0x0000000000005de6), UINT64_C(0x0000000000000000), UINT64_C(0x1f43080f44b0e70b),
        UINT64_C(0x1f43090efcb0e70a), UINT64_C(0x1f43038fb4b826e4)
    },
    {   UINT64_C(0x0000000000005de7), UINT64_C(0x1f4306cef4afc728), UINT64_C(0x1f4307cef0ae6715),
        UINT64_C(0x1f43020f68ae071f), UINT64_C(0x1f43054ec0aee6fa)
    },
    {   UINT64_C(0x0000000000005de8), UINT64_C(0x1f4305cfacb08716), UINT64_C(0x1f43014f74b866d3),
        UINT64_C(0x1f43084e70aea737), UINT64_C(0x1f43080f98b006f9)
    },
    {   UINT64_C(0x0000000000005de9), UINT64_C(0x0000000000000000), UINT64_C(0x1f4310ce80b46737),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43040f88b1470a)
    },
    {   UINT64_C(0x0000000000005dea), UINT64_C(0x1f43060f1cb1a735), UINT64_C(0x1f43064f24ad06e2),
        UINT64_C(0x1f43028f88b6a718), UINT64_C(0x1f43040e9caf670e)
    },
    {   UINT64_C(0x0000000000005deb), UINT64_C(0x1f43054ef8b0271f), UINT64_C(0x1f42fe8e68b86742),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005dec), UINT64_C(0x1f43000f58b72728), UINT64_C(0x1f43068eb8af8733),
        UINT64_C(0x1f43080ea0acc6f6), UINT64_C(0x1f4305cf20b0072e)
    },
    {   UINT64_C(0x0000000000005ded), UINT64_C(0x1f43080fc4ac86ef), UINT64_C(0x1f43060edcafc705),
        UINT64_C(0x1f43054ee0b06715), UINT64_C(0x1f43054f54aaa6e4)
    },
    {   UINT64_C(0x0000000000005dee), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd8ee4b3a714),
        UINT64_C(0x1f43028e94b6c723), UINT64_C(0x1f43098f04b2673a)
    },
    {   UINT64_C(0x0000000000005def), UINT64_C(0x1f43010f58b64718), UINT64_C(0x1f43048e44b36741),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa4e7caa073b)
    },
    {   UINT64_C(0x0000000000005df0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43048eecb2c6f7), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005df1), UINT64_C(0x1f4308cf38adc70e), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43028ee0b6e742)
    },
    {   UINT64_C(0x0000000000005df2), UINT64_C(0x0000000000000000), UINT64_C(0x1f430a4ed0b42731),
        UINT64_C(0x1f4303cef8ac0717), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005df3), UINT64_C(0x1f43060efcb0e731), UINT64_C(0x1f43008e14afa72b),
        UINT64_C(0x1f4307ce64b5c74c), UINT64_C(0x1f4305cedcada737)
    },
    {   UINT64_C(0x0000000000005df4), UINT64_C(0x1f4305ce6caee6f2), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43030fa0b62705)
    },
    {   UINT64_C(0x0000000000005df5), UINT64_C(0x1f43010e6cb08742), UINT64_C(0x1f430e0e50aac73e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43040e7cb2273f)
    },
    {   UINT64_C(0x0000000000005df6), UINT64_C(0x1f4306cebcb26739), UINT64_C(0x1f4301cea8b18700),
        UINT64_C(0x1f4303ce5cb10737), UINT64_C(0x1f4311cee0b16711)
    },
    {   UINT64_C(0x0000000000005df7), UINT64_C(0x1f42f44f0cb9a707), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43128e7ca8671a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005df8), UINT64_C(0x1f42f68ec4b50722), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43140fa8b4e713), UINT64_C(0x1f430d4ed8b36731)
    },
    {   UINT64_C(0x0000000000005df9), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb900cb10705),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe4fa4a886eb)
    },
    {   UINT64_C(0x0000000000005dfa), UINT64_C(0x1f43061034b546e6), UINT64_C(0x1f42fbd00cb206e9),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc8f28b5c6f6)
    },
    {   UINT64_C(0x0000000000005dfb), UINT64_C(0x1f4301cff8b246d6), UINT64_C(0x1f42f9905cb5c6eb),
        UINT64_C(0x1f42fb8f84b2c6f4), UINT64_C(0x1f42f6cebcba4725)
    },
    {   UINT64_C(0x0000000000005dfc), UINT64_C(0x1f42fe4ed4b50727), UINT64_C(0x1f42ff8ed4b6c735),
        UINT64_C(0x1f42fbcf90b426fc), UINT64_C(0x1f42fe5024a526c3)
    },
    {   UINT64_C(0x0000000000005dfd), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f9d0fcb5a6a2), UINT64_C(0x1f42f8cf28b486b2)
    },
    {   UINT64_C(0x0000000000005dfe), UINT64_C(0x1f42f6ceacb526c1), UINT64_C(0x1f42f8d03cb7667e),
        UINT64_C(0x1f42f2cfc4b946cc), UINT64_C(0x1f42f6cfbcb4a717)
    },
    {   UINT64_C(0x0000000000005dff), UINT64_C(0x1f42f5118cb4669d), UINT64_C(0x1f42f30f4cad8708),
        UINT64_C(0x1f42f9cf6cb70699), UINT64_C(0x1f42f4cf88ad270b)
    },
    {   UINT64_C(0x0000000000005e00), UINT64_C(0x1f42f8cf5cb026c3), UINT64_C(0x1f42f4cf1caba6e0),
        UINT64_C(0x1f42fb0f1cb826fe), UINT64_C(0x1f42f8cf2cb486c8)
    },
    {   UINT64_C(0x0000000000005e01), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cf8cb786dd),
        UINT64_C(0x1f42f5cfd0b5c6e1), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e02), UINT64_C(0x0000000000000000), UINT64_C(0x1f430acf3ca14700),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e03), UINT64_C(0x1f42f8cf40b4e719), UINT64_C(0x1f42f7d050b5c702),
        UINT64_C(0x1f42f5cf18b806f3), UINT64_C(0x1f42fa8f94b7c6de)
    },
    {   UINT64_C(0x0000000000005e04), UINT64_C(0x1f42f5cff0b366ad), UINT64_C(0x1f42f8cf08b006cd),
        UINT64_C(0x1f42f7d0bcb7e6df), UINT64_C(0x1f42f6cfa8b506db)
    },
    {   UINT64_C(0x0000000000005e05), UINT64_C(0x1f42f4ce9cb4e6b5), UINT64_C(0x1f42f54f70b7e724),
        UINT64_C(0x1f42f40f1caf0709), UINT64_C(0x1f42f90ebcb4671d)
    },
    {   UINT64_C(0x0000000000005e06), UINT64_C(0x1f42f7cfd4b62714), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f5cfa4b5c6db), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e07), UINT64_C(0x1f42f4cf5cb846d9), UINT64_C(0x1f42f2cf90b6e6f9),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43008ed8ab0714)
    },
    {   UINT64_C(0x0000000000005e08), UINT64_C(0x1f42f4cfd4b5a6a7), UINT64_C(0x1f42fb90a8af8699),
        UINT64_C(0x1f42f9cf28b186ba), UINT64_C(0x1f42fbcfe4b1a6fa)
    },
    {   UINT64_C(0x0000000000005e09), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f5cff0b726ee),
        UINT64_C(0x1f43040e90af872f), UINT64_C(0x1f42f5cfe8ace705)
    },
    {   UINT64_C(0x00000000000149c0), UINT64_C(0x0000000000000000), UINT64_C(0x1e72f6d0c0b3e655),
        UINT64_C(0x1e0af6d0e4b2664b), UINT64_C(0x1e72f6d0c0b3e655)
    },
    {   UINT64_C(0x0000000000005e0b), UINT64_C(0x1f42fad088b166f3), UINT64_C(0x1f42f20fe4b6a6e7),
        UINT64_C(0x1f430a0f1cb44731), UINT64_C(0x1f42f7cefcb6c6ed)
    },
    {   UINT64_C(0x0000000000005e0c), UINT64_C(0x1f42f4ce8cb3e6c3), UINT64_C(0x1f42f6cea8b54703),
        UINT64_C(0x1f42f8cf88b58719), UINT64_C(0x1f42f91018ad0674)
    },
    {   UINT64_C(0x00000000000149c3), UINT64_C(0x112af54f747f06a9), UINT64_C(0x1abaf6908ca50660),
        UINT64_C(0x1c7af6d068ac066a), UINT64_C(0x1d2af6d1ccaee60e)
    },
    {   UINT64_C(0x00000000000149c4), UINT64_C(0x1c7af6d068ac066a), UINT64_C(0x1d8af6d1ccb02611),
        UINT64_C(0x1e72f6d140b3c633), UINT64_C(0x179af68f6c98a6a9)
    },
    {   UINT64_C(0x00000000000149c5), UINT64_C(0x1a72f70f68a3e6a9), UINT64_C(0x17d2f6cfa099669c),
        UINT64_C(0x17caf6cfa099669c), UINT64_C(0x11daedce9085e67d)
    },
    {   UINT64_C(0x00000000000149c6), UINT64_C(0x152af70f6c8ec6a9), UINT64_C(0x17daf6cfa099869c),
        UINT64_C(0x17c2f6cfa099469c), UINT64_C(0x17baf6cfa099269c)
    },
    {   UINT64_C(0x00000000000149c7), UINT64_C(0x1792f6cfa098869c), UINT64_C(0x0f72f6cfa078069c),
        UINT64_C(0x1142f6cfa07f269c), UINT64_C(0x10caf6cfa07d669c)
    },
    {   UINT64_C(0x00000000000149c8), UINT64_C(0x120af6d12082463c), UINT64_C(0x15a2f6cf6890a6a9),
        UINT64_C(0x1892f6cf689c66a9), UINT64_C(0x18a2f6cf689c86a9)
    },
    {   UINT64_C(0x00000000000149c9), UINT64_C(0x18a2f6cf689ca6a9), UINT64_C(0x18b2f6cf689d06a9),
        UINT64_C(0x18caf6cf6c9d66a9), UINT64_C(0x18d2f6cf6c9d66a9)
    },
    {   UINT64_C(0x00000000000149ca), UINT64_C(0x0000000000000000), UINT64_C(0x19baf6cf68a0e6a9),
        UINT64_C(0x18aaf6cf689cc6a9), UINT64_C(0x1a4af6cf68a366a9)
    },
    {   UINT64_C(0x00000000000149cb), UINT64_C(0x19baf6cf68a126a9), UINT64_C(0x1a0af6cf68a246a9),
        UINT64_C(0x1982f6cf6ca046a9), UINT64_C(0x19faf6cf68a206a9)
    },
    {   UINT64_C(0x00000000000149cc), UINT64_C(0x1cdaf6cf68ad86a9), UINT64_C(0x1742f6cfa097469c),
        UINT64_C(0x169af6cfa094869c), UINT64_C(0x176af6cfa097c69c)
    },
    {   UINT64_C(0x00000000000149cd), UINT64_C(0x18b2f68f689d06a9), UINT64_C(0x18c2f6cf689d46a9),
        UINT64_C(0x15baf6cf689126aa), UINT64_C(0x1842f6cf889b26a3)
    },
    {   UINT64_C(0x0000000000005e18), UINT64_C(0x1f42f8cec8b78717), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f6cee8b70727), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000149cf), UINT64_C(0x1622f6cf689286a9), UINT64_C(0x1552f6cf688f66a9),
        UINT64_C(0x15eaf6cf6891c6a9), UINT64_C(0x19d2f6cf68a166a9)
    },
    {   UINT64_C(0x00000000000149d0), UINT64_C(0x197af6cf68a006a9), UINT64_C(0x18aaf6cf689cc6a9),
        UINT64_C(0x18aaf6cf689cc6a9), UINT64_C(0x161af68f6892a6a9)
    },
    {   UINT64_C(0x0000000000005e1b), UINT64_C(0x1f42f7cfc4b726f8), UINT64_C(0x1f42f5d064aee708),
        UINT64_C(0x1f42f9ce70aea72c), UINT64_C(0x1f42f0100cb7e6df)
    },
    {   UINT64_C(0x00000000000149d2), UINT64_C(0x189af6cf689c86a9), UINT64_C(0x164af6cf689346a9),
        UINT64_C(0x18baf6cf689d06a9), UINT64_C(0x188af70f689c66a9)
    },
    {   UINT64_C(0x00000000000149d3), UINT64_C(0x0000000000000000), UINT64_C(0x1b4af6cf68a746a9),
        UINT64_C(0x0000000000000000), UINT64_C(0x17d2f6cfa099669c)
    },
    {   UINT64_C(0x0000000000005e1e), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f50f0cb826ff),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4310cebcb006e9)
    },
    {   UINT64_C(0x00000000000149d5), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1882f6cf689c26a9), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000149d6), UINT64_C(0x0452f6cfa04b869c), UINT64_C(0x08aaf6cfa05cc69c),
        UINT64_C(0x0cfaf6cfa06e069c), UINT64_C(0x0c42f6d3bc6b26a9)
    },
    {   UINT64_C(0x00000000000149d7), UINT64_C(0x0c42f693bc6b26a9), UINT64_C(0x14e2f6d3bc8da6a9),
        UINT64_C(0x14e2f713bc8dc6a9), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000149d8), UINT64_C(0x0000000000000000), UINT64_C(0x16e2f6cd6495a70e),
        UINT64_C(0x1102fc0f687b86aa), UINT64_C(0x1102f68f687e06a9)
    },
    {   UINT64_C(0x00000000000149d9), UINT64_C(0x1c72f6d040abe673), UINT64_C(0x14daf6cf688da6a9),
        UINT64_C(0x17c2f6cf689946a9), UINT64_C(0x17c2ee11849d4621)
    },
    {   UINT64_C(0x0000000000005e24), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f2ce3cb6472f),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f4ceecb36727)
    },
    {   UINT64_C(0x000000000000d400), UINT64_C(0x07d2ee0fa03e83e8), UINT64_C(0x1162f18c747b669b),
        UINT64_C(0x0aa30d8cac59469b), UINT64_C(0x10c2fd0fa0804682)
    },
    {   UINT64_C(0x000000000000d401), UINT64_C(0x0c52f90fd06a4632), UINT64_C(0x164af90fd0922632),
        UINT64_C(0x2042f90fd0ba0632), UINT64_C(0x0c52f90fd06a4632)
    },
    {   UINT64_C(0x00000000000149dd), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x18a2f6cf689cc6a9), UINT64_C(0x18a2f6cf689cc6a9)
    },
    {   UINT64_C(0x00000000000149de), UINT64_C(0x18a2f6cf689cc6a9), UINT64_C(0x18a2f6cf689cc6a9),
        UINT64_C(0x18a2f6cf689cc6a9), UINT64_C(0x18a2f6cf689cc6a9)
    },
    {   UINT64_C(0x00000000000149df), UINT64_C(0x18a2f6cf689cc6a9), UINT64_C(0x18a2f6cf689cc6a9),
        UINT64_C(0x18a2f6cf689cc6a9), UINT64_C(0x18a2f6cf689cc6a9)
    },
    {   UINT64_C(0x00000000000149e0), UINT64_C(0x18a2f6cf689cc6a9), UINT64_C(0x18a2f6cf689cc6a9),
        UINT64_C(0x18a2f6cf689cc6a9), UINT64_C(0x18a2f6cf689cc6a9)
    },
    {   UINT64_C(0x00000000000149e1), UINT64_C(0x18a2f6cf689cc6a9), UINT64_C(0x18a2f6cf689cc6a9),
        UINT64_C(0x18a2f6cf689cc6a9), UINT64_C(0x18a2f6cf689cc6a9)
    },
    {   UINT64_C(0x00000000000149e2), UINT64_C(0x18a2f6cf689cc6a9), UINT64_C(0x18a2f6cf689cc6a9),
        UINT64_C(0x18a2f6cf689cc6a9), UINT64_C(0x18a2f6cf689cc6a9)
    },
    {   UINT64_C(0x000000000000d408), UINT64_C(0x1773020b0c9246c0), UINT64_C(0x1773020d08924688),
        UINT64_C(0x1773020d08924688), UINT64_C(0x1773020bf09246ce)
    },
    {   UINT64_C(0x000000000000d409), UINT64_C(0x1773020bf09246ce), UINT64_C(0x0d4afccaa078e720),
        UINT64_C(0x165afccaa09d2720), UINT64_C(0x1f6afccaa0c16720)
    },
    {   UINT64_C(0x000000000000d40a), UINT64_C(0x0c52f6cac87ae72a), UINT64_C(0x1452f6caa09ae720),
        UINT64_C(0x1dbafb8aa0c16720), UINT64_C(0x0f22fb8aa083a720)
    },
    {   UINT64_C(0x000000000000d40b), UINT64_C(0x0deaf6caa0814720), UINT64_C(0x0e42f6caa082a720),
        UINT64_C(0x287afccaa0e5a720), UINT64_C(0x0ffafccaa083a720)
    },
    {   UINT64_C(0x000000000000d40c), UINT64_C(0x0ffafccaa083a720), UINT64_C(0x1282fccaa08dc720),
        UINT64_C(0x0c0af6caa079c720), UINT64_C(0x0f22fb8aa083a720)
    },
    {   UINT64_C(0x000000000000d40d), UINT64_C(0x0d0af6caa07b4720), UINT64_C(0x0d42fb8aa07c2720),
        UINT64_C(0x10bafb8aa08a0720), UINT64_C(0x0d02f6caa07da720)
    },
    {   UINT64_C(0x000000000000d40e), UINT64_C(0x0e5af6caa0808720), UINT64_C(0x19c2f94aa0ad0720),
        UINT64_C(0x107af94aa087e720), UINT64_C(0x11baf94aa08d8720)
    },
    {   UINT64_C(0x000000000000d40f), UINT64_C(0x11baf94aa08d8720), UINT64_C(0x0efaf94aa07fa7a7),
        UINT64_C(0x0cdaf6c8847e6720), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000149eb), UINT64_C(0x1b1af6d134a68637), UINT64_C(0x15c2f6d050912670),
        UINT64_C(0x15c2f6d050912670), UINT64_C(0x1b52f6d0d4a78653)
    },
    {   UINT64_C(0x00000000000149ec), UINT64_C(0x0000000000000000), UINT64_C(0x1b52f6d0c4a7864f),
        UINT64_C(0x17c2f6cfa099269c), UINT64_C(0x1d92f6d220b065fd)
    },
    {   UINT64_C(0x00000000000149ed), UINT64_C(0x181af690349a8677), UINT64_C(0x1b0af6d2dca645c9),
        UINT64_C(0x181af690349a8677), UINT64_C(0x1bc2f68f54a926b0)
    },
    {   UINT64_C(0x0000000000005e38), UINT64_C(0x1f42f50f5cace70a), UINT64_C(0x1f42f6cfccb4c6f7),
        UINT64_C(0x1f42f6cf58b0e70b), UINT64_C(0x1f42fc0e70b7271e)
    },
    {   UINT64_C(0x00000000000149ef), UINT64_C(0x1cfaf6d1f8ade606), UINT64_C(0x1e52f6d0d0b2e650),
        UINT64_C(0x1cb2f6912cad0639), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e3a), UINT64_C(0x1f42fe4ef0aee73e), UINT64_C(0x1f42f18eecb726f2),
        UINT64_C(0x1f42fbcee8b64746), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e3b), UINT64_C(0x1f42f9cee0b36716), UINT64_C(0x1f42f4ce98b6c713),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f6ce50b0a725)
    },
    {   UINT64_C(0x0000000000005e3c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f50edcb6e707), UINT64_C(0x1f42f74ea0b3a72e)
    },
    {   UINT64_C(0x0000000000005fb5), UINT64_C(0x1f43070eb8b54721), UINT64_C(0x1f4304cf88b5a719),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43038fb0b3a6eb)
    },
    {   UINT64_C(0x0000000000005e3e), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f50e9cb3e725),
        UINT64_C(0x1f42f5ceccb5472e), UINT64_C(0x1f42f60f5cba0717)
    },
    {   UINT64_C(0x0000000000005e3f), UINT64_C(0x1f42f70e8cb8271d), UINT64_C(0x1f42f5cf4cb7e749),
        UINT64_C(0x1f42f60e6cb4c709), UINT64_C(0x1f42fb8f3cac66ff)
    },
    {   UINT64_C(0x0000000000005e40), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f7cf78b4c705),
        UINT64_C(0x1f42f60edcb0e72b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e41), UINT64_C(0x1f42f5cf24b7c70b), UINT64_C(0x1f42f4cef0b72712),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f70f84b6e72d)
    },
    {   UINT64_C(0x0000000000005e42), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f40f58b6a6fd),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e43), UINT64_C(0x1f42f40f40b346f0), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f5cfd0b6e734), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e44), UINT64_C(0x1f430c8eecb2c6f3), UINT64_C(0x1f42f40f40b1a71a),
        UINT64_C(0x1f42f30ef4b2c727), UINT64_C(0x1f42f30f60b0c6ea)
    },
    {   UINT64_C(0x0000000000005e45), UINT64_C(0x1f42f30ee8b006d3), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f9cea4b3a721)
    },
    {   UINT64_C(0x0000000000005e46), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f4d06cb866ed),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f5cfc0b506cb)
    },
    {   UINT64_C(0x0000000000005e47), UINT64_C(0x1f43024f6cb60730), UINT64_C(0x1f42f6ced0aee6de),
        UINT64_C(0x1f42f6cea8b7c72b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e48), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb0ee8b5072b),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f7cf28b20720)
    },
    {   UINT64_C(0x0000000000005e49), UINT64_C(0x1f42f40eb0b68710), UINT64_C(0x1f42f5cec4b606e7),
        UINT64_C(0x1f42fa0ec0b1c72d), UINT64_C(0x1f42fb1084b7c6e0)
    },
    {   UINT64_C(0x0000000000005e4a), UINT64_C(0x1f430ecea0a8070a), UINT64_C(0x1f42f5cea0af6715),
        UINT64_C(0x1f42f90f10b306ff), UINT64_C(0x1f42f74e7cb7c72c)
    },
    {   UINT64_C(0x0000000000005e4b), UINT64_C(0x1f43050f0cb24714), UINT64_C(0x1f42f8cee8af8702),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f7ce50b6071e)
    },
    {   UINT64_C(0x0000000000005e4c), UINT64_C(0x0000000000000000), UINT64_C(0x1f4308ceb0b24743),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e4d), UINT64_C(0x1f42f30e80b06713), UINT64_C(0x1f42f6cec0b58701),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e4e), UINT64_C(0x1f42f7ce50b50731), UINT64_C(0x1f42f8cf38b6a716),
        UINT64_C(0x1f430d4f68ae86ce), UINT64_C(0x1f43284ef890e706)
    },
    {   UINT64_C(0x0000000000005e4f), UINT64_C(0x1f43034f64b566ef), UINT64_C(0x1f42f78f70af6702),
        UINT64_C(0x1f42f98ef8b746fa), UINT64_C(0x1f42ff4f04ab66ef)
    },
    {   UINT64_C(0x0000000000005e50), UINT64_C(0x1f42fa8ef8b58706), UINT64_C(0x1f42fd4ec8ac8721),
        UINT64_C(0x1f42fa8f74b566f7), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e51), UINT64_C(0x1f42f98f28b786e6), UINT64_C(0x1f42fc8f94b0e6e7),
        UINT64_C(0x1f42fd4f44b3c6e7), UINT64_C(0x1f42f58fc4b62712)
    },
    {   UINT64_C(0x0000000000005e52), UINT64_C(0x1f43004e8cb64716), UINT64_C(0x1f42fb8f54b3e6fb),
        UINT64_C(0x1f42ff4f84ace6eb), UINT64_C(0x1f42fc8f54b406df)
    },
    {   UINT64_C(0x0000000000005e53), UINT64_C(0x1f42ff4f24aca6f2), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd8f84aae6ff)
    },
    {   UINT64_C(0x0000000000005e54), UINT64_C(0x1f42fb8fb4ade700), UINT64_C(0x1f42ff4f84b4c6f6),
        UINT64_C(0x1f42fd8f6cad06f2), UINT64_C(0x1f42fc8f94b5a6f7)
    },
    {   UINT64_C(0x0000000000005e55), UINT64_C(0x1f42fb8ee0b38702), UINT64_C(0x1f42f98f54b346f9),
        UINT64_C(0x1f42fb8f64b7270a), UINT64_C(0x1f42f88f94b7270a)
    },
    {   UINT64_C(0x0000000000005e56), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa8ea8b0e72a), UINT64_C(0x1f42fd9000b3670a)
    },
    {   UINT64_C(0x0000000000005e57), UINT64_C(0x1f42ff4fa4af26fb), UINT64_C(0x1f42fe4fc4b8270e),
        UINT64_C(0x1f42f98e7cb1c72c), UINT64_C(0x1f43014e44b08731)
    },
    {   UINT64_C(0x0000000000005e58), UINT64_C(0x1f42f68eecab470f), UINT64_C(0x1f43124e80a8e71a),
        UINT64_C(0x1f42f78f48ac8719), UINT64_C(0x1f42fd8f30b5070f)
    },
    {   UINT64_C(0x0000000000005e59), UINT64_C(0x1f42fd8f1caa86f6), UINT64_C(0x1f42fd8e5cb56737),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8fa4b386f7)
    },
    {   UINT64_C(0x0000000000005e5a), UINT64_C(0x1f4304cef0b2c72c), UINT64_C(0x1f42f98ef8b7270d),
        UINT64_C(0x1f42fd8f88b5871e), UINT64_C(0x1f43004f64b2c6f1)
    },
    {   UINT64_C(0x0000000000005e5b), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fcceccb86734),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f68f34ace721)
    },
    {   UINT64_C(0x0000000000005e5c), UINT64_C(0x1f42fb8f34b0670a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f98f74b4a6fe), UINT64_C(0x1f42fa8fc0b606ff)
    },
    {   UINT64_C(0x0000000000005e5d), UINT64_C(0x1f42fb8ec0b286fe), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc4e9cade723)
    },
    {   UINT64_C(0x0000000000005e5e), UINT64_C(0x1f42f68fd4ac470e), UINT64_C(0x1f42fb8ee8b34706),
        UINT64_C(0x1f42fd8f7cb5c734), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e5f), UINT64_C(0x1f42f78e88b6470b), UINT64_C(0x1f42f98e9cb2e71d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f38efcb5c72f)
    },
    {   UINT64_C(0x0000000000005e60), UINT64_C(0x1f430e8ee4ab0732), UINT64_C(0x1f430b8e54b4473f),
        UINT64_C(0x1f42f78f08af46fb), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e61), UINT64_C(0x1f42f88efcb5c6fb), UINT64_C(0x1f42f38ed8aee710),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e62), UINT64_C(0x1f42fa8e2cb4470e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f68f78b6470a), UINT64_C(0x1f42f68f64b44715)
    },
    {   UINT64_C(0x0000000000005e63), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff4fe0b2670a),
        UINT64_C(0x1f42fd8f48ace725), UINT64_C(0x1f42fa8f9cb08700)
    },
    {   UINT64_C(0x0000000000005e64), UINT64_C(0x1f42fa8f0cb3c71a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa8e8cb72704), UINT64_C(0x1f42fa8f34b66715)
    },
    {   UINT64_C(0x0000000000005e65), UINT64_C(0x1f42fc8f54b66719), UINT64_C(0x1f42f98e1cb08717),
        UINT64_C(0x1f42f98e9cb64726), UINT64_C(0x1f42f88f44b5c6fe)
    },
    {   UINT64_C(0x0000000000005e66), UINT64_C(0x1f42fa8e4cb4c71d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc8f58b0c6f7), UINT64_C(0x1f42f58e80b7e731)
    },
    {   UINT64_C(0x0000000000005e67), UINT64_C(0x1f430ece80b1c723), UINT64_C(0x1f42f5cf04b7a710),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e68), UINT64_C(0x1f42fb8fbcb44701), UINT64_C(0x1f42fc8ef0b2a706),
        UINT64_C(0x1f42fa8f10ade6e3), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e69), UINT64_C(0x1f42f88eb4af26e2), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430f4e78ab8736), UINT64_C(0x1f42f98eb0b6472a)
    },
    {   UINT64_C(0x0000000000005e6a), UINT64_C(0x1f42f88e84b2a717), UINT64_C(0x1f42fb0f38b5071e),
        UINT64_C(0x1f42f2ce6cb62721), UINT64_C(0x1f42f98e9cb3e71e)
    },
    {   UINT64_C(0x0000000000005e6b), UINT64_C(0x1f42f9ce48b8a72f), UINT64_C(0x1f42f88f48b52703),
        UINT64_C(0x1f42f88f64b22734), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e6c), UINT64_C(0x1f42fa8eecb2870b), UINT64_C(0x1f42f88e40b38745),
        UINT64_C(0x1f42f88ef0b086f3), UINT64_C(0x1f42f58e50b64738)
    },
    {   UINT64_C(0x0000000000005e6d), UINT64_C(0x1f42fe4eccb4e72b), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f98e50b50731), UINT64_C(0x1f42f98f50b0e6fe)
    },
    {   UINT64_C(0x000000000001bfff), UINT64_C(0x0000000000000000), UINT64_C(0x1b42fbcc3ca4a67e),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e6f), UINT64_C(0x0000000000000000), UINT64_C(0x1f43010e28b6a746),
        UINT64_C(0x1f430b0f18b7472a), UINT64_C(0x1f430e8efcb1872e)
    },
    {   UINT64_C(0x0000000000005e70), UINT64_C(0x1f4307ce8cb1a733), UINT64_C(0x1f42f90f78aec6fb),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430c8f28b1471a)
    },
    {   UINT64_C(0x0000000000005e71), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd8f24b666d9),
        UINT64_C(0x1f4300cf38b106f9), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e72), UINT64_C(0x1f42f98f64b286df), UINT64_C(0x1f430b8e88b72742),
        UINT64_C(0x1f430a4e90ad6732), UINT64_C(0x1f42fc4f74b6a6fd)
    },
    {   UINT64_C(0x0000000000005e73), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc8ee8b066de),
        UINT64_C(0x1f42fb8f44b886e0), UINT64_C(0x1f42f88f54b4c6d7)
    },
    {   UINT64_C(0x0000000000005e74), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90ec8b7e72c),
        UINT64_C(0x1f42fbcf0cb5870e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e75), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb8fa0b6a6e7),
        UINT64_C(0x1f42fc8f64b286cf), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e76), UINT64_C(0x1f42f9cfc0b746f5), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e77), UINT64_C(0x1f42f8cfc0b346df), UINT64_C(0x1f42ff8ee8b4c6d3),
        UINT64_C(0x1f42ff8f24b226d4), UINT64_C(0x1f42fe8f88b806f7)
    },
    {   UINT64_C(0x0000000000005e78), UINT64_C(0x1f42fccf44aac6dc), UINT64_C(0x1f42f84f94b66707),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cef8b7a726)
    },
    {   UINT64_C(0x0000000000005e79), UINT64_C(0x1f42faceb8b62700), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd8e7cb9473d), UINT64_C(0x1f42f58f74b646f3)
    },
    {   UINT64_C(0x0000000000005e7a), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f88f64b7a71b),
        UINT64_C(0x1f42fe8f74b446fa), UINT64_C(0x1f42fbce8cb2a700)
    },
    {   UINT64_C(0x0000000000005e7b), UINT64_C(0x1f43018f94b026ef), UINT64_C(0x1f42f98eccb0072a),
        UINT64_C(0x1f42fccf54ab26ed), UINT64_C(0x1f42f98fb4ae66f0)
    },
    {   UINT64_C(0x0000000000005e7c), UINT64_C(0x1f42fe8f68ae66e3), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e7d), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43108e7cab071f), UINT64_C(0x1f42fecf88b2c6de)
    },
    {   UINT64_C(0x0000000000005e7e), UINT64_C(0x1f4300cf88aea6fa), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42facf78b106f5), UINT64_C(0x1f42fb8ed0af2737)
    },
    {   UINT64_C(0x0000000000005e7f), UINT64_C(0x0000000000000000), UINT64_C(0x1f43018ec4ab2714),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e80), UINT64_C(0x1f42fcce9cb1e731), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fbcea8b6071e), UINT64_C(0x1f42f8cf14b2e71a)
    },
    {   UINT64_C(0x0000000000005e81), UINT64_C(0x1f42f6cf44b4c710), UINT64_C(0x1f42f64f94b746f0),
        UINT64_C(0x1f4300cf58b066f4), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e82), UINT64_C(0x1f42f9ce6cb44702), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4300cedcae271c), UINT64_C(0x1f42fd8fc0b5c6f1)
    },
    {   UINT64_C(0x0000000000005e83), UINT64_C(0x1f42f8ceb8b786fb), UINT64_C(0x1f42fecf10aec707),
        UINT64_C(0x1f42fdcfb4b5a705), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e84), UINT64_C(0x1f42f78ec4b766ec), UINT64_C(0x1f42fb0f24b1c70a),
        UINT64_C(0x1f42f70ef0b126df), UINT64_C(0x1f42f70eb4b48723)
    },
    {   UINT64_C(0x0000000000005e85), UINT64_C(0x1f42f70f84ba471d), UINT64_C(0x1f42f50e9cb4871d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f78e9cb64736)
    },
    {   UINT64_C(0x0000000000005e86), UINT64_C(0x1f42ff8f04b1e71a), UINT64_C(0x1f42f8cf04b4c718),
        UINT64_C(0x1f42f8cf38b54715), UINT64_C(0x1f42f70f04b506df)
    },
    {   UINT64_C(0x0000000000005e87), UINT64_C(0x1f42f90f34b68731), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f70ed8b6a6ed), UINT64_C(0x1f43134e4cb1c743)
    },
    {   UINT64_C(0x0000000000005e88), UINT64_C(0x1f42fa8f70abc6e8), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f9cee4b566fb), UINT64_C(0x1f43024f14b6a71b)
    },
    {   UINT64_C(0x0000000000005e89), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42face9cad870a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e8a), UINT64_C(0x1f42fdcfacaee6ff), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80f04b0c6dc)
    },
    {   UINT64_C(0x0000000000005e8b), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f8cf74b24708), UINT64_C(0x1f42facf14b0a6ff)
    },
    {   UINT64_C(0x0000000000005e8c), UINT64_C(0x1f42fa8eb0b686e0), UINT64_C(0x1f42f70ef4b84716),
        UINT64_C(0x1f42ff0fc8b3070d), UINT64_C(0x1f42fccfb4af2714)
    },
    {   UINT64_C(0x0000000000005e8d), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f7cfb0b5c6ee)
    },
    {   UINT64_C(0x0000000000005e8e), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbcec0ad8708),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f60fdcb0a70d)
    },
    {   UINT64_C(0x0000000000005e8f), UINT64_C(0x1f42facea0b72715), UINT64_C(0x1f42fa8ee4b08736),
        UINT64_C(0x1f43080e70ae8713), UINT64_C(0x1f42f9cf9caf6722)
    },
    {   UINT64_C(0x0000000000005e90), UINT64_C(0x1f4301cedcb5c737), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa4f44b566f7), UINT64_C(0x1f42f4cee8b84716)
    },
    {   UINT64_C(0x0000000000005e91), UINT64_C(0x1f42f50efcb88701), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f5ce80b1873c), UINT64_C(0x1f42face34b6a736)
    },
    {   UINT64_C(0x0000000000005e92), UINT64_C(0x1f42ff4e9cb1e732), UINT64_C(0x1f42f50e3cb80708),
        UINT64_C(0x1f42f6cf78b686cf), UINT64_C(0x1f42f78e60b78712)
    },
    {   UINT64_C(0x0000000000005e93), UINT64_C(0x1f42f84f08b7a70b), UINT64_C(0x1f42facea0b56730),
        UINT64_C(0x1f42f88f7ca88714), UINT64_C(0x1f42fa8f24b56711)
    },
    {   UINT64_C(0x0000000000005e94), UINT64_C(0x1f42f80f28b68730), UINT64_C(0x1f42fbcf20b1671d),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e95), UINT64_C(0x1f42f8ced0b2e717), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f8ceacb42700), UINT64_C(0x1f42f60f44b34719)
    },
    {   UINT64_C(0x0000000000005e96), UINT64_C(0x1f42f7ceccb7671e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fbcf04b6a70b), UINT64_C(0x1f42f80f54b466cf)
    },
    {   UINT64_C(0x0000000000005e97), UINT64_C(0x1f42f9cf30b0e71f), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f6cf48b52703)
    },
    {   UINT64_C(0x0000000000005e98), UINT64_C(0x1f42f90e64b5873e), UINT64_C(0x1f42f88f10b46728),
        UINT64_C(0x1f42f90f70b42728), UINT64_C(0x1f42f78ea0b6c738)
    },
    {   UINT64_C(0x0000000000005e99), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f88eacb4a724)
    },
    {   UINT64_C(0x0000000000005e9a), UINT64_C(0x1f43058ec4b34709), UINT64_C(0x1f42f50f24b28719),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f9cf20b2a722)
    },
    {   UINT64_C(0x0000000000005e9b), UINT64_C(0x1f42f7cefcb0e722), UINT64_C(0x1f42face48aec73a),
        UINT64_C(0x1f42f8ceccb3470e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e9c), UINT64_C(0x1f42f6cea0b66738), UINT64_C(0x1f42fd8e88b5e72d),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005e9d), UINT64_C(0x1f43108fd4b786f1), UINT64_C(0x1f43104e9cab471a),
        UINT64_C(0x1f430f8f08b40735), UINT64_C(0x1f43158f4caa071e)
    },
    {   UINT64_C(0x0000000000005e9e), UINT64_C(0x1f4319cf4caae735), UINT64_C(0x1f43130e78b04737),
        UINT64_C(0x1f43160fbcaee721), UINT64_C(0x1f43130ec8a92729)
    },
    {   UINT64_C(0x0000000000005e9f), UINT64_C(0x0000000000000000), UINT64_C(0x1f4309cea4ada742),
        UINT64_C(0x1f43140f5ca9470e), UINT64_C(0x1f43164e70ade741)
    },
    {   UINT64_C(0x0000000000005ea0), UINT64_C(0x1f4314cf98aba716), UINT64_C(0x1f43160f20b3c72d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430b0f68a8472b)
    },
    {   UINT64_C(0x0000000000005ea1), UINT64_C(0x1f4313ce40ad2740), UINT64_C(0x1f4319cec0ab0721),
        UINT64_C(0x1f43114ed8b2872d), UINT64_C(0x1f43180eccabe731)
    },
    {   UINT64_C(0x0000000000005ea2), UINT64_C(0x1f43130ec8b08722), UINT64_C(0x1f431d4ec8ab471d),
        UINT64_C(0x1f4311ceccb5271b), UINT64_C(0x1f431a8ef8ab071a)
    },
    {   UINT64_C(0x0000000000005ea3), UINT64_C(0x1f43180e1cabe735), UINT64_C(0x1f4310cf20a8472a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4312ce74ab6729)
    },
    {   UINT64_C(0x0000000000005ea4), UINT64_C(0x1f43134ef4abc72e), UINT64_C(0x1f43130f2caa0727),
        UINT64_C(0x1f4318cedcaf0723), UINT64_C(0x1f4301ceb4b1a72c)
    },
    {   UINT64_C(0x0000000000005ea5), UINT64_C(0x1f4313ce80aac731), UINT64_C(0x1f430f0f14b36728),
        UINT64_C(0x1f43098efcb3c735), UINT64_C(0x1f43130eb0ae272e)
    },
    {   UINT64_C(0x0000000000005ea6), UINT64_C(0x1f430b0ec0b14735), UINT64_C(0x1f4305ce68abe73c),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ea7), UINT64_C(0x1f4319ce5ca7e71e), UINT64_C(0x1f43164e90a9671f),
        UINT64_C(0x1f43198e84a9270b), UINT64_C(0x1f43004e64af6739)
    },
    {   UINT64_C(0x0000000000005ea8), UINT64_C(0x1f430d8e8cb0e739), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f431a8e90a866f3), UINT64_C(0x1f43104e6cace70e)
    },
    {   UINT64_C(0x0000000000005ea9), UINT64_C(0x0000000000000000), UINT64_C(0x1f43034f28b0a71f),
        UINT64_C(0x1f43174ea8ab671b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005eaa), UINT64_C(0x1f43170e64aa870e), UINT64_C(0x1f43160e88ac2738),
        UINT64_C(0x1f4312ce8cb0672d), UINT64_C(0x1f43190f14a7c716)
    },
    {   UINT64_C(0x0000000000005eab), UINT64_C(0x1f43050ec0b2c70f), UINT64_C(0x1f43114e78ab672e),
        UINT64_C(0x1f43078e6cb02749), UINT64_C(0x1f430bcea0af6739)
    },
    {   UINT64_C(0x0000000000005eac), UINT64_C(0x1f4314cea4a82726), UINT64_C(0x1f43090edcad472e),
        UINT64_C(0x1f430d4eb8ad2731), UINT64_C(0x1f42fe8f54b7871d)
    },
    {   UINT64_C(0x0000000000005ead), UINT64_C(0x1f4319cecca92736), UINT64_C(0x1f4316ce7ca84735),
        UINT64_C(0x1f43068e6cb42737), UINT64_C(0x1f430b0edcaa2736)
    },
    {   UINT64_C(0x0000000000005eae), UINT64_C(0x1f43198f34a9a726), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff8e98b4271f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005eaf), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43098f10ade736), UINT64_C(0x1f43180f04b2e739)
    },
    {   UINT64_C(0x0000000000005eb0), UINT64_C(0x1f43048f00b46739), UINT64_C(0x1f430acf08b1a73a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43094e28ade738)
    },
    {   UINT64_C(0x0000000000005eb1), UINT64_C(0x1f43168e48b38738), UINT64_C(0x1f43020e78b50736),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f431b4e5ca7273f)
    },
    {   UINT64_C(0x0000000000005eb2), UINT64_C(0x1f430f0e30ab0734), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd0e90ae2740), UINT64_C(0x1f4306501cb166e9)
    },
    {   UINT64_C(0x0000000000005eb3), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc8ef8b44719),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f88e9cb626fc)
    },
    {   UINT64_C(0x0000000000005eb4), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fed01cad06fe),
        UINT64_C(0x1f43024e3cb1670f), UINT64_C(0x1f42fe8fc4b346d9)
    },
    {   UINT64_C(0x0000000000005eb5), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd0f68b406cf),
        UINT64_C(0x1f43194f70b24713), UINT64_C(0x1f42fd8f0cb3c70e)
    },
    {   UINT64_C(0x0000000000005eb6), UINT64_C(0x1f43014ee8ac070e), UINT64_C(0x1f43000ff8aca6f2),
        UINT64_C(0x1f42fa0eccb5870a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005eb7), UINT64_C(0x1f43048ed4b04726), UINT64_C(0x1f42f590fcb7e702),
        UINT64_C(0x1f430c4eb8b1a730), UINT64_C(0x1f430c4e8cb20738)
    },
    {   UINT64_C(0x0000000000005eb8), UINT64_C(0x1f43064e60b0673e), UINT64_C(0x1f42fb9070b4e6da),
        UINT64_C(0x1f42f28f48b94723), UINT64_C(0x1f42f90fa4b94718)
    },
    {   UINT64_C(0x0000000000005eb9), UINT64_C(0x1f42fb0f54b1e706), UINT64_C(0x1f43058ee4b2872e),
        UINT64_C(0x1f42fd0e9cb72732), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005eba), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430b0f2cad0701), UINT64_C(0x1f42f70e70b6a724)
    },
    {   UINT64_C(0x0000000000005ebb), UINT64_C(0x0000000000000000), UINT64_C(0x1f43028f04b10702),
        UINT64_C(0x1f42ff0f08b0e6ed), UINT64_C(0x1f42ff0efcad66fa)
    },
    {   UINT64_C(0x0000000000005ebc), UINT64_C(0x1f42f5cfc0b7a6e3), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ebd), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f9cf28b56725), UINT64_C(0x1f42fecec8b34716)
    },
    {   UINT64_C(0x0000000000005ebe), UINT64_C(0x1f42fa0e90b58725), UINT64_C(0x1f42f8cf04b006fc),
        UINT64_C(0x1f430b90a0ad6715), UINT64_C(0x1f43184ee8a8470a)
    },
    {   UINT64_C(0x0000000000005ebf), UINT64_C(0x0000000000000000), UINT64_C(0x1f43098e5cab873b),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43068e9cada73b)
    },
    {   UINT64_C(0x0000000000005ec0), UINT64_C(0x1f430a4ec0b0070a), UINT64_C(0x1f430c8f94af4700),
        UINT64_C(0x1f43024ec0b16713), UINT64_C(0x1f430b4eaca3a720)
    },
    {   UINT64_C(0x0000000000005ec1), UINT64_C(0x1f430d4e7caa0710), UINT64_C(0x1f43194eacb00711),
        UINT64_C(0x1f43088ebcaea71d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ec2), UINT64_C(0x1f43074efcb24733), UINT64_C(0x1f43178e6ca3c71b),
        UINT64_C(0x1f43024ebcae4717), UINT64_C(0x1f430e4f04b14728)
    },
    {   UINT64_C(0x0000000000005ec3), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f431a4f2cada713), UINT64_C(0x1f4311cec0a52721)
    },
    {   UINT64_C(0x0000000000005ec4), UINT64_C(0x1f431bcea8afa723), UINT64_C(0x1f430e0f7cb4a720),
        UINT64_C(0x1f4308ceecb3a703), UINT64_C(0x1f431b4f6cae8716)
    },
    {   UINT64_C(0x0000000000005ec5), UINT64_C(0x1f43120f78b1872a), UINT64_C(0x1f43168f04b16728),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ec6), UINT64_C(0x1f43194eeca7870e), UINT64_C(0x1f430e4fdcaee729),
        UINT64_C(0x1f43164e6ca12719), UINT64_C(0x1f4312cf00aaa715)
    },
    {   UINT64_C(0x0000000000005ec7), UINT64_C(0x0000000000000000), UINT64_C(0x1f431c4e70a44723),
        UINT64_C(0x1f430e8eacac072c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ec8), UINT64_C(0x1f43044f54b1871a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f431c4e44aba720), UINT64_C(0x1f43118f2ca4871f)
    },
    {   UINT64_C(0x0000000000005ec9), UINT64_C(0x1f43188ea0a62715), UINT64_C(0x1f43168e28a52735),
        UINT64_C(0x1f42ff4e88b1673d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005eca), UINT64_C(0x1f43084e70b8a73a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43118f44aea6f9), UINT64_C(0x1f43120ec8a7672c)
    },
    {   UINT64_C(0x0000000000005ecb), UINT64_C(0x1f430d4e78aa8749), UINT64_C(0x1f43074eb4b3871b),
        UINT64_C(0x1f43118e4ca72724), UINT64_C(0x1f42fdcf88b6270c)
    },
    {   UINT64_C(0x0000000000005ecc), UINT64_C(0x1f4319ce48ab8726), UINT64_C(0x1f43194e48a6a728),
        UINT64_C(0x1f430e4e6cab8701), UINT64_C(0x1f43050f74aa870a)
    },
    {   UINT64_C(0x0000000000005ecd), UINT64_C(0x1f43174e50a4a722), UINT64_C(0x1f430f4ec4adc71a),
        UINT64_C(0x1f43090f04ae071a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ece), UINT64_C(0x1f43164eaca5a72c), UINT64_C(0x1f43068eccaf4726),
        UINT64_C(0x1f43160ee0ace72c), UINT64_C(0x1f430bce5ca60727)
    },
    {   UINT64_C(0x0000000000005ecf), UINT64_C(0x1f4314cf84b36728), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43060f00acc726), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ed0), UINT64_C(0x1f43180f94a80715), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ed1), UINT64_C(0x1f43180ec0b0670e), UINT64_C(0x1f43144ed4adc728),
        UINT64_C(0x1f43094e2cb54745), UINT64_C(0x1f43080eaca8a722)
    },
    {   UINT64_C(0x0000000000005ed2), UINT64_C(0x1f43078f00aa2722), UINT64_C(0x1f43078e8cb06745),
        UINT64_C(0x1f4318ce54b2e722), UINT64_C(0x1f43060f40a8a728)
    },
    {   UINT64_C(0x0000000000005ed3), UINT64_C(0x1f43050ee4b56711), UINT64_C(0x1f431a8e30a86741),
        UINT64_C(0x1f43018f8cac470e), UINT64_C(0x1f42f98ef0b3a732)
    },
    {   UINT64_C(0x0000000000005ed4), UINT64_C(0x1f4313cee0ab0733), UINT64_C(0x1f43048f14b2e712),
        UINT64_C(0x1f430dce90ad072f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ed5), UINT64_C(0x1f42fb8eecb5e728), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430e4e8cb6a748), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ed6), UINT64_C(0x1f43058edca7270a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430ece8cad4728), UINT64_C(0x1f43178e6ca42724)
    },
    {   UINT64_C(0x0000000000005ed7), UINT64_C(0x0000000000000000), UINT64_C(0x1f430c8ea4b0e737),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ed8), UINT64_C(0x1f42ff8ea8a68734), UINT64_C(0x1f43064e68b82737),
        UINT64_C(0x1f43040f28b06717), UINT64_C(0x1f43058e1ca90736)
    },
    {   UINT64_C(0x0000000000005ed9), UINT64_C(0x1f43158e20b3c73a), UINT64_C(0x1f4313ceeca7a73b),
        UINT64_C(0x1f431c4f08af871f), UINT64_C(0x1f430ece70b5073c)
    },
    {   UINT64_C(0x0000000000005eda), UINT64_C(0x0000000000000000), UINT64_C(0x1f431b8eb0a62744),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005edb), UINT64_C(0x1f43014ea4b1e744), UINT64_C(0x1f43068eecafc72b),
        UINT64_C(0x1f43064f24b04717), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005edc), UINT64_C(0x1f43034e8ca9a731), UINT64_C(0x1f42fb4f08b6a735),
        UINT64_C(0x1f430dce24a4273b), UINT64_C(0x1f43058e94b20736)
    },
    {   UINT64_C(0x0000000000005edd), UINT64_C(0x1f430c8eecb34735), UINT64_C(0x1f43018eecb1c749),
        UINT64_C(0x1f430f4e60ad273a), UINT64_C(0x1f43068e70af6722)
    },
    {   UINT64_C(0x0000000000005ede), UINT64_C(0x1f430d8e3cad873a), UINT64_C(0x1f43058ec4a52726),
        UINT64_C(0x1f43118ee0a9e733), UINT64_C(0x1f43154ea0abe726)
    },
    {   UINT64_C(0x0000000000005edf), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43030f94b36718), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ee0), UINT64_C(0x1f43178eb8a5c728), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43158ea8aee719), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ee1), UINT64_C(0x1f430e8e5caee731), UINT64_C(0x1f43098e30afe734),
        UINT64_C(0x1f43104e80aa672e), UINT64_C(0x1f430ece60a62738)
    },
    {   UINT64_C(0x0000000000005ee2), UINT64_C(0x1f4312cf34a62717), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4306cf30b56710), UINT64_C(0x1f43178e88adc73d)
    },
    {   UINT64_C(0x0000000000005ee3), UINT64_C(0x1f43144e60a42711), UINT64_C(0x1f43004ee8ac071b),
        UINT64_C(0x1f43050e50ad272d), UINT64_C(0x1f43048e2cb8674b)
    },
    {   UINT64_C(0x0000000000005ee4), UINT64_C(0x1f43104e8caae71c), UINT64_C(0x1f430d4e6cabc738),
        UINT64_C(0x1f43080e5cae8738), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ee5), UINT64_C(0x1f43148f44a82735), UINT64_C(0x1f43058eccb26748),
        UINT64_C(0x1f42ff8eccb5471b), UINT64_C(0x1f4301ce68b2c744)
    },
    {   UINT64_C(0x0000000000005ee6), UINT64_C(0x1f43158e8ca8072b), UINT64_C(0x1f43090ef8b46727),
        UINT64_C(0x1f430fceb0aaa736), UINT64_C(0x1f43044ef0b42723)
    },
    {   UINT64_C(0x0000000000005ee7), UINT64_C(0x1f431b0f4ca86713), UINT64_C(0x1f42fd0ea4b2e73d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430e8ec0ab4727)
    },
    {   UINT64_C(0x0000000000005ee8), UINT64_C(0x1f43068eb8b24722), UINT64_C(0x1f430e8e6cb0474d),
        UINT64_C(0x1f43150f18abc70c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ee9), UINT64_C(0x1f430a8e7cac6734), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430b4e68ab872f), UINT64_C(0x1f43138ebca70728)
    },
    {   UINT64_C(0x0000000000005eea), UINT64_C(0x1f4304ce9cb30724), UINT64_C(0x1f43148ea0a5272a),
        UINT64_C(0x1f43124eacade723), UINT64_C(0x1f430f0eacab073b)
    },
    {   UINT64_C(0x0000000000005eeb), UINT64_C(0x1f43130f0ca8a726), UINT64_C(0x1f43058eacae8738),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430b0ee4b32739)
    },
    {   UINT64_C(0x0000000000005eec), UINT64_C(0x0000000000000000), UINT64_C(0x1f43038f0ca6e738),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005eed), UINT64_C(0x1f42ff0ea8b16731), UINT64_C(0x1f430c8e74a6073b),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430c8f70b36726)
    },
    {   UINT64_C(0x0000000000005eee), UINT64_C(0x1f43048ea0b2074d), UINT64_C(0x1f4315ceeca9e733),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005eef), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43168eb0a7073d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ef0), UINT64_C(0x1f43118e7ca9a73e), UINT64_C(0x1f43088f00abe740),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ef1), UINT64_C(0x1f42fe4e60b72741), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430d4e68b3e734), UINT64_C(0x1f42facee0a5a732)
    },
    {   UINT64_C(0x0000000000005ef2), UINT64_C(0x0000000000000000), UINT64_C(0x1f430a4e3cb0a72e),
        UINT64_C(0x1f43130ee4afe731), UINT64_C(0x1f43168f40a9273e)
    },
    {   UINT64_C(0x0000000000006010), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43048fa8b30708), UINT64_C(0x1f42fc4f6cb44714)
    },
    {   UINT64_C(0x0000000000005ef4), UINT64_C(0x0000000000000000), UINT64_C(0x1f43088e78af4731),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430d4e70aa672f)
    },
    {   UINT64_C(0x0000000000005ef5), UINT64_C(0x1f431a4e54a6e733), UINT64_C(0x1f430e4e8cb14724),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ef6), UINT64_C(0x1f43198e50a42734), UINT64_C(0x1f43144e4ca80742),
        UINT64_C(0x1f43168ee4aa271c), UINT64_C(0x1f430e0e60a5e726)
    },
    {   UINT64_C(0x0000000000005ef7), UINT64_C(0x1f430e0e90b36741), UINT64_C(0x1f43058e20b00746),
        UINT64_C(0x1f430ccec8b0c736), UINT64_C(0x1f43018e38b36737)
    },
    {   UINT64_C(0x0000000000005ef8), UINT64_C(0x1f42fb4ea0b7c738), UINT64_C(0x1f43094ed8b18733),
        UINT64_C(0x1f430c4eccac0735), UINT64_C(0x1f43134e14afa73b)
    },
    {   UINT64_C(0x0000000000005ef9), UINT64_C(0x1f43150e7caca744), UINT64_C(0x1f4306ce4cb32739),
        UINT64_C(0x1f43198e80af072e), UINT64_C(0x1f4306ce6cad2730)
    },
    {   UINT64_C(0x0000000000005efa), UINT64_C(0x1f43148e98b84731), UINT64_C(0x1f43180e6ca70735),
        UINT64_C(0x1f43034e74adc740), UINT64_C(0x1f43144e34ad873e)
    },
    {   UINT64_C(0x0000000000005efb), UINT64_C(0x0000000000000000), UINT64_C(0x1f4302ceecb1273a),
        UINT64_C(0x1f43114f44adc711), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005efc), UINT64_C(0x1f43098e5caa472d), UINT64_C(0x1f43198eb8a5e738),
        UINT64_C(0x1f43108eb0b1e72e), UINT64_C(0x1f43064e7cb24733)
    },
    {   UINT64_C(0x0000000000005efd), UINT64_C(0x1f43014e68b28739), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430dce20aba71c), UINT64_C(0x1f43020e88b10730)
    },
    {   UINT64_C(0x0000000000005efe), UINT64_C(0x1f430e4e70b3a72a), UINT64_C(0x1f43050e50b8873d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43198e3ca9873c)
    },
    {   UINT64_C(0x0000000000005eff), UINT64_C(0x1f43130f00ad6725), UINT64_C(0x1f43038e9cafe73b),
        UINT64_C(0x1f4302ce7cb00735), UINT64_C(0x1f430f4e50ad8734)
    },
    {   UINT64_C(0x0000000000005f00), UINT64_C(0x1f430e0e6cab8734), UINT64_C(0x1f43028eb8b84736),
        UINT64_C(0x1f43138ebca88732), UINT64_C(0x1f430a8efcab6733)
    },
    {   UINT64_C(0x0000000000005f01), UINT64_C(0x0000000000000000), UINT64_C(0x1f43048ec4a90730),
        UINT64_C(0x1f430c8ec0b1a72d), UINT64_C(0x1f42ffcf30b1671b)
    },
    {   UINT64_C(0x0000000000005f02), UINT64_C(0x0000000000000000), UINT64_C(0x1f43008ef8aea731),
        UINT64_C(0x1f430e0ea0b0072a), UINT64_C(0x1f43108ed0b0c731)
    },
    {   UINT64_C(0x0000000000005f03), UINT64_C(0x1f42fcce60b16743), UINT64_C(0x1f4301cec4b14742),
        UINT64_C(0x1f430a0eb4afc737), UINT64_C(0x1f42fa8ec4b2272d)
    },
    {   UINT64_C(0x0000000000005f04), UINT64_C(0x1f430c8eacb2c736), UINT64_C(0x1f430e4ea4ae072f),
        UINT64_C(0x1f43058e6cafc733), UINT64_C(0x1f4306ce94af2731)
    },
    {   UINT64_C(0x0000000000005f05), UINT64_C(0x1f430bce4cacc72f), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430e8e7cb08728), UINT64_C(0x1f4307ce9caea72f)
    },
    {   UINT64_C(0x0000000000005f06), UINT64_C(0x0000000000000000), UINT64_C(0x1f43054e60abe72a),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f07), UINT64_C(0x1f43114f10abe731), UINT64_C(0x1f43078e58b70745),
        UINT64_C(0x1f43098e6caf6744), UINT64_C(0x1f430ace5caf2720)
    },
    {   UINT64_C(0x0000000000005f08), UINT64_C(0x1f430e8ef4ad2719), UINT64_C(0x1f43188eb0a4471d),
        UINT64_C(0x1f431e4e94a6c720), UINT64_C(0x1f43088e2cb14747)
    },
    {   UINT64_C(0x0000000000005f09), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ffce84b76730),
        UINT64_C(0x1f43098e70b68721), UINT64_C(0x1f43088e98b5c74a)
    },
    {   UINT64_C(0x0000000000005f0a), UINT64_C(0x1f43104ec8acc727), UINT64_C(0x1f43100ed0ae2723),
        UINT64_C(0x1f43140e64b12734), UINT64_C(0x1f430c0e8cae073b)
    },
    {   UINT64_C(0x0000000000005f0b), UINT64_C(0x1f43074f78b8472d), UINT64_C(0x1f43090efcb4c726),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f0c), UINT64_C(0x1f43090e7cb14728), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43070ebcb70731)
    },
    {   UINT64_C(0x0000000000005f0d), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff4e70a5872f)
    },
    {   UINT64_C(0x0000000000005f0e), UINT64_C(0x1f42fecf14b3e72a), UINT64_C(0x1f43100e48af273a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43048e38b36738)
    },
    {   UINT64_C(0x0000000000005f0f), UINT64_C(0x1f43020e90b3a733), UINT64_C(0x1f43028efcb6271e),
        UINT64_C(0x1f43008e9cb4c730), UINT64_C(0x1f430d4e54b14730)
    },
    {   UINT64_C(0x0000000000005f10), UINT64_C(0x1f43018e84a8872a), UINT64_C(0x1f4309cea0a6672b),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430b8eb8b0a724)
    },
    {   UINT64_C(0x0000000000005f11), UINT64_C(0x0000000000000000), UINT64_C(0x1f43088eb0b0272e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430d4e00ad4736)
    },
    {   UINT64_C(0x0000000000005f12), UINT64_C(0x1f4308ced8b3272a), UINT64_C(0x1f430b0e64afc736),
        UINT64_C(0x1f43078e7ca40730), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f13), UINT64_C(0x1f43058e4cafe73a), UINT64_C(0x1f42fecea4ade730),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe4ef8b3672f)
    },
    {   UINT64_C(0x0000000000005f14), UINT64_C(0x1f42fe4ea0b6272b), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430d4e94b3e727)
    },
    {   UINT64_C(0x0000000000005f15), UINT64_C(0x1f43030ec0b7872b), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4304ce98b0073c), UINT64_C(0x1f43024e3caba73c)
    },
    {   UINT64_C(0x0000000000005f16), UINT64_C(0x1f42fb8ef0b4c72b), UINT64_C(0x1f42f80e84b7872d),
        UINT64_C(0x1f43034e60ac473c), UINT64_C(0x1f4303ce54b2c740)
    },
    {   UINT64_C(0x0000000000005f17), UINT64_C(0x1f43048e50abe730), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4306ceb4a5a737)
    },
    {   UINT64_C(0x0000000000005f18), UINT64_C(0x1f43000e88b38738), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f431b0e50a7c738)
    },
    {   UINT64_C(0x0000000000005f19), UINT64_C(0x1f430dce98b4a73c), UINT64_C(0x1f42ff8e7cb5072d),
        UINT64_C(0x1f42f90edcaf0738), UINT64_C(0x1f4303ce28b32738)
    },
    {   UINT64_C(0x0000000000005f1a), UINT64_C(0x0000000000000000), UINT64_C(0x1f43040e4cb04734),
        UINT64_C(0x1f43084e70b08734), UINT64_C(0x1f4308ce24b0e736)
    },
    {   UINT64_C(0x0000000000005f1b), UINT64_C(0x1f430e4e5cb2c731), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43124ebcade72f), UINT64_C(0x1f430fce84b1c738)
    },
    {   UINT64_C(0x0000000000005f1c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb8ed4acc731), UINT64_C(0x1f43094eacb70723)
    },
    {   UINT64_C(0x0000000000005f1d), UINT64_C(0x1f430bcef8b62710), UINT64_C(0x1f42ff8ee8b12714),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f1e), UINT64_C(0x1f42fcceacb566f4), UINT64_C(0x1f42ff0e9cb1c6ed),
        UINT64_C(0x1f42f9ce9cb84700), UINT64_C(0x1f430d4f54b0c718)
    },
    {   UINT64_C(0x0000000000005f1f), UINT64_C(0x1f42fa0edcae270c), UINT64_C(0x1f42f6cf04b30708),
        UINT64_C(0x1f42ff4f28b2e708), UINT64_C(0x1f42fd8e74b346fc)
    },
    {   UINT64_C(0x0000000000005f20), UINT64_C(0x1f42f7ce9cb546fc), UINT64_C(0x1f42f9ce9cb3e710),
        UINT64_C(0x1f43058e64afc701), UINT64_C(0x1f42f58f8cb7e6f5)
    },
    {   UINT64_C(0x0000000000005f21), UINT64_C(0x1f42facf18b606e8), UINT64_C(0x1f42fdceecafa6ef),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f22), UINT64_C(0x1f42feceecb246e9), UINT64_C(0x1f42f7cf18b7270e),
        UINT64_C(0x1f43154e7ca886f7), UINT64_C(0x1f42f6ceb8b72712)
    },
    {   UINT64_C(0x0000000000005f23), UINT64_C(0x1f42fe8f18a9a6eb), UINT64_C(0x1f42fbcef8b5e6fb),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f24), UINT64_C(0x1f42fe8f10b34703), UINT64_C(0x1f42fe8efcb126fc),
        UINT64_C(0x1f42fdcf38b4c717), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f25), UINT64_C(0x1f42fd8f38ae0707), UINT64_C(0x1f42f9cf68a84722),
        UINT64_C(0x1f42fa8ebcb2c707), UINT64_C(0x1f42fd0ef8b7271b)
    },
    {   UINT64_C(0x0000000000005f26), UINT64_C(0x1f42fbcf68a8c6f4), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4303ce84b0a726)
    },
    {   UINT64_C(0x0000000000005f27), UINT64_C(0x1f43114ebcade71d), UINT64_C(0x1f42fa0fa4b00710),
        UINT64_C(0x1f42fb8f78b4c70b), UINT64_C(0x1f430b8f08b5c735)
    },
    {   UINT64_C(0x0000000000005f28), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8f0cacc6ff),
        UINT64_C(0x1f430e8e40af6729), UINT64_C(0x1f42f60ef4b646fb)
    },
    {   UINT64_C(0x0000000000005f29), UINT64_C(0x1f4305ce78b08737), UINT64_C(0x1f4307cf78aca712),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42feceecaf66e9)
    },
    {   UINT64_C(0x0000000000005f2a), UINT64_C(0x1f42fa8f3cac870b), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43068f14b04720), UINT64_C(0x1f43028f3cb1670b)
    },
    {   UINT64_C(0x0000000000005f2b), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f64f3cb7670b),
        UINT64_C(0x1f42fbcf38b68727), UINT64_C(0x1f42f7cef8b8c6f7)
    },
    {   UINT64_C(0x0000000000005f2c), UINT64_C(0x0000000000000000), UINT64_C(0x1f43078edcb1271d),
        UINT64_C(0x1f430f4e9cafe732), UINT64_C(0x1f42fa0f28b646f3)
    },
    {   UINT64_C(0x0000000000005f2d), UINT64_C(0x1f42f8cef8b346fb), UINT64_C(0x1f42ff8e40b3e73b),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f2e), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f7ce8cb64722),
        UINT64_C(0x1f42face4cb4e718), UINT64_C(0x1f42fbceecb68700)
    },
    {   UINT64_C(0x0000000000005f2f), UINT64_C(0x1f43008f48af4715), UINT64_C(0x1f42f68f20b0e71a),
        UINT64_C(0x1f42f98ea0b58734), UINT64_C(0x1f42f9cf18b726f3)
    },
    {   UINT64_C(0x0000000000005f30), UINT64_C(0x1f42f80fa8b68707), UINT64_C(0x1f42f9cef0b7a717),
        UINT64_C(0x1f42f84f80b6672a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f31), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0ee8b5a704),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90f88b446ec)
    },
    {   UINT64_C(0x0000000000005f32), UINT64_C(0x1f42facec8b4e716), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fbcf3caec70f), UINT64_C(0x1f43028ef8aa46f7)
    },
    {   UINT64_C(0x0000000000005f33), UINT64_C(0x1f42f70f24b706ec), UINT64_C(0x1f42f8cf78aec6ec),
        UINT64_C(0x1f42ffcf88aec708), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f34), UINT64_C(0x1f42f70e3cb30721), UINT64_C(0x1f42f7cf10b026f7),
        UINT64_C(0x1f42facf48b0272d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f35), UINT64_C(0x1f42f9cedcb506f7), UINT64_C(0x1f42f8cf48b1e714),
        UINT64_C(0x1f42fbcf38b3471e), UINT64_C(0x1f42f60f88b5a723)
    },
    {   UINT64_C(0x0000000000005f36), UINT64_C(0x1f42f60ef8b78738), UINT64_C(0x1f42f7cf18b4070e),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f37), UINT64_C(0x1f42f98e5cb12740), UINT64_C(0x1f42f9ce90b78732),
        UINT64_C(0x1f43098e6caf4734), UINT64_C(0x1f42f9ce64aec727)
    },
    {   UINT64_C(0x0000000000005f38), UINT64_C(0x1f42f9cec0b64729), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fbcf6cb3472c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f39), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cf38b5c727)
    },
    {   UINT64_C(0x0000000000005f3a), UINT64_C(0x1f42fdcf38b0a6d8), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43094e9cb02731), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f3b), UINT64_C(0x1f42fc0e84b566dc), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f60efcb2a701), UINT64_C(0x1f42faceb0b5e71a)
    },
    {   UINT64_C(0x0000000000005f3c), UINT64_C(0x1f42fa0f1cae06f8), UINT64_C(0x1f43134edcaf4727),
        UINT64_C(0x1f42fc8f30af8707), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f3d), UINT64_C(0x1f42feced8af06ef), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc0edcb5c721), UINT64_C(0x1f42f7ce7caee73c)
    },
    {   UINT64_C(0x0000000000005f3e), UINT64_C(0x1f431a4e60a88735), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43058fc8afc6e9), UINT64_C(0x1f431ecf0ca76732)
    },
    {   UINT64_C(0x0000000000005f3f), UINT64_C(0x0000000000000000), UINT64_C(0x1f430b0ef4b1c6e9),
        UINT64_C(0x1f430a4e78a36733), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f40), UINT64_C(0x1f430bcff4b5870d), UINT64_C(0x1f43050f60b926e4),
        UINT64_C(0x1f430c8ee4b3071a), UINT64_C(0x1f43050e6cade6ec)
    },
    {   UINT64_C(0x0000000000005f41), UINT64_C(0x1f43108f68b06704), UINT64_C(0x1f4305cfe4b74705),
        UINT64_C(0x1f430a8f3cb38726), UINT64_C(0x1f430b8fbcb22714)
    },
    {   UINT64_C(0x0000000000005f42), UINT64_C(0x1f43030fd0b62706), UINT64_C(0x1f430d8f88aea713),
        UINT64_C(0x1f430a4e9cb26738), UINT64_C(0x1f43070ff0b7a6fb)
    },
    {   UINT64_C(0x0000000000005f43), UINT64_C(0x1f43090f60b246fd), UINT64_C(0x1f43038fb4af26f4),
        UINT64_C(0x1f4309cfd0b2c6e8), UINT64_C(0x1f430bceb8b026f2)
    },
    {   UINT64_C(0x0000000000005f44), UINT64_C(0x1f43091040b5c708), UINT64_C(0x1f4305cf58ae26ea),
        UINT64_C(0x1f43074ef8b4e6ec), UINT64_C(0x1f430bcefcb34707)
    },
    {   UINT64_C(0x0000000000005f45), UINT64_C(0x1f4302cf8cb58705), UINT64_C(0x1f4308cff4b726ff),
        UINT64_C(0x1f430c0eeca966ef), UINT64_C(0x1f430aceecb42726)
    },
    {   UINT64_C(0x0000000000005f46), UINT64_C(0x1f430c0fbcaba716), UINT64_C(0x1f430a0fc8b4c6f9),
        UINT64_C(0x1f43030fdcb5e704), UINT64_C(0x1f43014f84ba4715)
    },
    {   UINT64_C(0x0000000000005f47), UINT64_C(0x1f43028fe8b2e6e9), UINT64_C(0x1f430e100cb186e5),
        UINT64_C(0x1f43064f3cb5c6fa), UINT64_C(0x1f4308cfb8b666e5)
    },
    {   UINT64_C(0x0000000000005f48), UINT64_C(0x1f43094e3cb3c740), UINT64_C(0x1f430c0f48b2670b),
        UINT64_C(0x1f43168e74b12740), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f49), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43210ea4b086f8)
    },
    {   UINT64_C(0x0000000000005f4a), UINT64_C(0x1f43068f34b38709), UINT64_C(0x1f43094fb8b346ec),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430dce58b2073b)
    },
    {   UINT64_C(0x0000000000005f4b), UINT64_C(0x1f430a8fa4aec6d9), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4305ce68af8725), UINT64_C(0x1f43200ef0a6a71e)
    },
    {   UINT64_C(0x0000000000005f4c), UINT64_C(0x1f4308cfccb166f6), UINT64_C(0x1f43004fc4b526f6),
        UINT64_C(0x1f4303cfacb5e6e6), UINT64_C(0x1f4307ce6cb0e725)
    },
    {   UINT64_C(0x0000000000005f4d), UINT64_C(0x0000000000000000), UINT64_C(0x1f430c8eccb2270a),
        UINT64_C(0x1f430c9030ac06fe), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f4e), UINT64_C(0x1f430b9050afe702), UINT64_C(0x1f430a0fc8ad2717),
        UINT64_C(0x1f43091034af66f5), UINT64_C(0x1f430a8fc4b546fb)
    },
    {   UINT64_C(0x0000000000005f4f), UINT64_C(0x1f4303cec8b0e72c), UINT64_C(0x1f430d4facafe707),
        UINT64_C(0x1f43088f1cb806f3), UINT64_C(0x1f430f4fe0abc6eb)
    },
    {   UINT64_C(0x0000000000005f50), UINT64_C(0x1f43094f94af66f9), UINT64_C(0x1f4307cf98b0c716),
        UINT64_C(0x1f43098f54b7c71a), UINT64_C(0x1f430c501cb12700)
    },
    {   UINT64_C(0x0000000000005f51), UINT64_C(0x1f430c8fb4b72711), UINT64_C(0x1f430e8fb4a9a703),
        UINT64_C(0x1f43008ec8b16721), UINT64_C(0x1f430f0ee8ab070c)
    },
    {   UINT64_C(0x0000000000005f52), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43098eacb5c70b), UINT64_C(0x1f4305cf94afc705)
    },
    {   UINT64_C(0x0000000000005f53), UINT64_C(0x1f42facfbcb506ed), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4300cf1cb5e6ed), UINT64_C(0x1f43064e50b0c709)
    },
    {   UINT64_C(0x0000000000005f54), UINT64_C(0x1f43070fb8b0071e), UINT64_C(0x1f43060ed8b6c71e),
        UINT64_C(0x1f43060eccac66fa), UINT64_C(0x1f43094fe8af66f2)
    },
    {   UINT64_C(0x0000000000005f55), UINT64_C(0x1f43080f7cb066de), UINT64_C(0x1f43031024b546ff),
        UINT64_C(0x1f43015018b4271d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f56), UINT64_C(0x1f4306cf68b646f4), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f30eb8b7c732)
    },
    {   UINT64_C(0x0000000000005f57), UINT64_C(0x1f430e4e64a9a720), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430bd028b926f8), UINT64_C(0x1f43070fd0b5a703)
    },
    {   UINT64_C(0x0000000000005f58), UINT64_C(0x0000000000000000), UINT64_C(0x1f4307cff8b66720),
        UINT64_C(0x1f430acf28b08730), UINT64_C(0x1f42ff8e78b0e71f)
    },
    {   UINT64_C(0x0000000000005f59), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43025044baa701), UINT64_C(0x1f43080f9cad2705)
    },
    {   UINT64_C(0x0000000000005f5a), UINT64_C(0x1f43018f34b70719), UINT64_C(0x1f4305cfecb52701),
        UINT64_C(0x1f430a0f7caea6fe), UINT64_C(0x1f4316ce70a78742)
    },
    {   UINT64_C(0x0000000000005f5b), UINT64_C(0x0000000000000000), UINT64_C(0x1f4302cdf4b72737),
        UINT64_C(0x1f42fd8e7cab673f), UINT64_C(0x1f43058f4caf26f6)
    },
    {   UINT64_C(0x0000000000005f5c), UINT64_C(0x1f4304d044b066f6), UINT64_C(0x1f43000f8cb6070a),
        UINT64_C(0x1f43054f1cac8705), UINT64_C(0x1f4305ce4cba6733)
    },
    {   UINT64_C(0x0000000000005f5d), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8507cb666fd),
        UINT64_C(0x1f42fe108cb386fd), UINT64_C(0x1f430ecec8ac871e)
    },
    {   UINT64_C(0x0000000000005f5e), UINT64_C(0x0000000000000000), UINT64_C(0x1f43060ed4a7070b),
        UINT64_C(0x1f4303ceacad271c), UINT64_C(0x1f43070f38b2e6f6)
    },
    {   UINT64_C(0x0000000000005f5f), UINT64_C(0x1f430a4f48a826f5), UINT64_C(0x1f430ccfd8b026ee),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe8f04b7a71c)
    },
    {   UINT64_C(0x0000000000005f60), UINT64_C(0x1f43080e7cb7e722), UINT64_C(0x1f43028e8cb206fe),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430a4edcad470a)
    },
    {   UINT64_C(0x0000000000005f61), UINT64_C(0x1f43068fe0b56711), UINT64_C(0x1f4308cf0cb326f2),
        UINT64_C(0x1f43080f38b66705), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f62), UINT64_C(0x1f43060ef4ada72c), UINT64_C(0x1f42feceb0b3271c),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f63), UINT64_C(0x1f4305cfe8b6a6f2), UINT64_C(0x1f43050ef4aea732),
        UINT64_C(0x1f43044fc8b626e0), UINT64_C(0x1f43030f70b5c708)
    },
    {   UINT64_C(0x0000000000005f64), UINT64_C(0x0000000000000000), UINT64_C(0x1f43058f80ae46ef),
        UINT64_C(0x1f43080ee4b2e70d), UINT64_C(0x1f43014fbcb426ed)
    },
    {   UINT64_C(0x0000000000005f65), UINT64_C(0x1f43038ed4b186fa), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43020fc8b366e3), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f66), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd4ff4b3e70d),
        UINT64_C(0x1f42fecf18b34732), UINT64_C(0x1f42fdcf9cb3c6f5)
    },
    {   UINT64_C(0x0000000000005f67), UINT64_C(0x1f43018f20b1a711), UINT64_C(0x1f42fe4ed8b7a70e),
        UINT64_C(0x1f42ff4f98b446ea), UINT64_C(0x1f43021050b06701)
    },
    {   UINT64_C(0x0000000000005f68), UINT64_C(0x1f42f9cf14b68725), UINT64_C(0x1f43074f64ad86ff),
        UINT64_C(0x1f43034fa4aa0700), UINT64_C(0x1f43040f70b6e706)
    },
    {   UINT64_C(0x0000000000005f69), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff4ef8b3473b), UINT64_C(0x1f42ff4e6cb2e71d)
    },
    {   UINT64_C(0x0000000000005f6a), UINT64_C(0x0000000000000000), UINT64_C(0x1f43054f9cb526ee),
        UINT64_C(0x1f43044eb8afc721), UINT64_C(0x1f42fe4e8cb3672c)
    },
    {   UINT64_C(0x0000000000005f6b), UINT64_C(0x1f42ff4f68b52702), UINT64_C(0x1f43080f28b4671c),
        UINT64_C(0x1f43014ec0b50713), UINT64_C(0x1f43070f04ae2700)
    },
    {   UINT64_C(0x0000000000005f6c), UINT64_C(0x1f4303cf28b0e711), UINT64_C(0x1f43060fa4af2702),
        UINT64_C(0x1f430a8f60af470d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f6d), UINT64_C(0x1f4306d038b6a716), UINT64_C(0x1f43018edcb7a720),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff4e40b38712)
    },
    {   UINT64_C(0x0000000000005f6e), UINT64_C(0x1f430b0f90b72711), UINT64_C(0x1f43044f8cb5e6f7),
        UINT64_C(0x1f4308ce90b6472f), UINT64_C(0x1f4305d038b8671d)
    },
    {   UINT64_C(0x0000000000005f6f), UINT64_C(0x1f43004e3cb1670b), UINT64_C(0x1f43024e6cb4472c),
        UINT64_C(0x1f4302cf00b4e726), UINT64_C(0x1f43008e6cad6735)
    },
    {   UINT64_C(0x0000000000005f70), UINT64_C(0x1f43060f00af8715), UINT64_C(0x1f43014ed0b7471b),
        UINT64_C(0x1f43004f10b16705), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f71), UINT64_C(0x1f43040fe4b5e6d8), UINT64_C(0x1f42f80edcb6a6e6),
        UINT64_C(0x1f43090f24ae66ff), UINT64_C(0x1f43080facab06f7)
    },
    {   UINT64_C(0x0000000000005f72), UINT64_C(0x0000000000000000), UINT64_C(0x1f4301cf94afc6e1),
        UINT64_C(0x1f431b8e88b28711), UINT64_C(0x1f43080f48b266ff)
    },
    {   UINT64_C(0x0000000000005f73), UINT64_C(0x1f43050f5cb0e70e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43050f2caf6713), UINT64_C(0x1f42ff0f6cb30700)
    },
    {   UINT64_C(0x0000000000005f74), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f84f28b666e6),
        UINT64_C(0x1f43070f50b40726), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f75), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f84eb8b6671e),
        UINT64_C(0x1f43020f50b18726), UINT64_C(0x1f43068f88afc6f3)
    },
    {   UINT64_C(0x0000000000005f76), UINT64_C(0x1f4306cf40b7c725), UINT64_C(0x1f43088e6cb2c73e),
        UINT64_C(0x1f43030ee8b7271e), UINT64_C(0x1f430a4f84afe6e6)
    },
    {   UINT64_C(0x0000000000005f77), UINT64_C(0x1f42fd4f0cb3e736), UINT64_C(0x1f4304ce00b246f2),
        UINT64_C(0x1f4304cf84b706f8), UINT64_C(0x1f4306cf5cb286f8)
    },
    {   UINT64_C(0x0000000000005f78), UINT64_C(0x1f4308ce2cb5472d), UINT64_C(0x1f43094fa4b1c704),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4303cea4b8272b)
    },
    {   UINT64_C(0x0000000000005f79), UINT64_C(0x1f42f98eecb5c72d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43080f5cb526c3), UINT64_C(0x1f430a0fa8b02712)
    },
    {   UINT64_C(0x0000000000005f7a), UINT64_C(0x1f4302cf04ae4708), UINT64_C(0x1f43094ee0b4471b),
        UINT64_C(0x1f43050f98b646e8), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f7b), UINT64_C(0x1f43028fccb0c6fb), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43050eecb5071b), UINT64_C(0x1f4308ce6cb2473f)
    },
    {   UINT64_C(0x0000000000005f7c), UINT64_C(0x1f4301cea0b786fd), UINT64_C(0x1f42fdcfa4b726d2),
        UINT64_C(0x1f43050edcb506f5), UINT64_C(0x1f42fc4ea8a50735)
    },
    {   UINT64_C(0x0000000000005f7d), UINT64_C(0x1f42fb4e6cb9873a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43038fe0b766f7), UINT64_C(0x1f4307ced8b4a6e6)
    },
    {   UINT64_C(0x0000000000005f7e), UINT64_C(0x0000000000000000), UINT64_C(0x1f4305cfc4b58712),
        UINT64_C(0x1f4306cfe4b066fe), UINT64_C(0x1f43049054b7a70c)
    },
    {   UINT64_C(0x0000000000009103), UINT64_C(0x1d82f18fa0b1a68c), UINT64_C(0x1692f20f5896268c),
        UINT64_C(0x1852f6cf549b669b), UINT64_C(0x131af20fa089868c)
    },
    {   UINT64_C(0x0000000000005f80), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc4ea4b466ee),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43054ec0b6c6fb)
    },
    {   UINT64_C(0x0000000000005f81), UINT64_C(0x1f43014f9cb1e6ee), UINT64_C(0x1f42f9cf28b5a718),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f82), UINT64_C(0x1f43130e78b26734), UINT64_C(0x1f42ffcefcb28709),
        UINT64_C(0x1f43089054b4270c), UINT64_C(0x1f43060fa8b546ff)
    },
    {   UINT64_C(0x0000000000005f83), UINT64_C(0x1f43024f58b8c6ee), UINT64_C(0x1f43040ebcb6c712),
        UINT64_C(0x1f43024f54b38702), UINT64_C(0x1f43034e7cb08736)
    },
    {   UINT64_C(0x0000000000005f84), UINT64_C(0x1f43080edcad0736), UINT64_C(0x1f430a4edcb5c72e),
        UINT64_C(0x1f43040f8cb3471e), UINT64_C(0x1f43004f04b026e6)
    },
    {   UINT64_C(0x0000000000009106), UINT64_C(0x1692f1cfa095e68c), UINT64_C(0x14daf50fa08dc68c),
        UINT64_C(0x0fa2f44f687b85c1), UINT64_C(0x1162f24f687fa68c)
    },
    {   UINT64_C(0x0000000000005f86), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4306cf90b2a6d9), UINT64_C(0x1f43004e58b42738)
    },
    {   UINT64_C(0x0000000000005f87), UINT64_C(0x1f430a0efcaaa6fb), UINT64_C(0x1f43008efcb3e727),
        UINT64_C(0x1f430a0f40ae871b), UINT64_C(0x1f4301cec8b54726)
    },
    {   UINT64_C(0x0000000000005f88), UINT64_C(0x1f43070eecb5471e), UINT64_C(0x1f4308ce9caf8725),
        UINT64_C(0x1f42fa0ed4b86720), UINT64_C(0x1f43084f04afc709)
    },
    {   UINT64_C(0x0000000000005f89), UINT64_C(0x1f43060e8cb0871a), UINT64_C(0x1f42fc4eacb92724),
        UINT64_C(0x1f43020f98b526c8), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f8a), UINT64_C(0x0000000000000000), UINT64_C(0x1f4307cef4b706f4),
        UINT64_C(0x1f43058eacb14706), UINT64_C(0x1f43050f58b8a707)
    },
    {   UINT64_C(0x0000000000005f8b), UINT64_C(0x0000000000000000), UINT64_C(0x1f43048f28b30713),
        UINT64_C(0x1f43064f84b4670e), UINT64_C(0x1f43070f0cb5a716)
    },
    {   UINT64_C(0x0000000000005f8c), UINT64_C(0x1f43020fd0b726e6), UINT64_C(0x1f42fdcfa4b7e6e1),
        UINT64_C(0x1f4304ce98ae2709), UINT64_C(0x1f43054e90ac871d)
    },
    {   UINT64_C(0x0000000000005f8d), UINT64_C(0x1f43014e2cafa735), UINT64_C(0x1f43050f20b5670f),
        UINT64_C(0x1f4306cea0b02736), UINT64_C(0x1f4304cf40b5a730)
    },
    {   UINT64_C(0x0000000000005f8e), UINT64_C(0x1f43054fa0b64725), UINT64_C(0x1f43060f48b06714),
        UINT64_C(0x1f43030f5cb566d7), UINT64_C(0x1f42fa8e70aae740)
    },
    {   UINT64_C(0x0000000000005f8f), UINT64_C(0x1f43008ff8b946da), UINT64_C(0x1f42ff4f5cb4e720),
        UINT64_C(0x1f4308ce90b3e738), UINT64_C(0x1f42fc8e50b88744)
    },
    {   UINT64_C(0x0000000000005f90), UINT64_C(0x1f43054ef8afe700), UINT64_C(0x1f43024e5cb0871d),
        UINT64_C(0x1f43068e8caf0715), UINT64_C(0x1f42fe0eb8ab6733)
    },
    {   UINT64_C(0x0000000000005f91), UINT64_C(0x1f431f4e90ae671b), UINT64_C(0x1f43088e8cb6473b),
        UINT64_C(0x1f43070e44b72721), UINT64_C(0x1f42fc8f64b1a716)
    },
    {   UINT64_C(0x0000000000005f92), UINT64_C(0x1f43010f70b18705), UINT64_C(0x1f43054f4cb40709),
        UINT64_C(0x1f42fa8e78b5272d), UINT64_C(0x1f43008e80b22728)
    },
    {   UINT64_C(0x0000000000005f93), UINT64_C(0x1f43024ed8b0a723), UINT64_C(0x1f42feceecb34730),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f94), UINT64_C(0x1f43044f80b4a718), UINT64_C(0x1f43048f50b7670e),
        UINT64_C(0x1f42fe4eb0b2e72d), UINT64_C(0x1f430ccf28b686ed)
    },
    {   UINT64_C(0x0000000000005f95), UINT64_C(0x1f43048f28b54721), UINT64_C(0x1f43070f58b5673b),
        UINT64_C(0x1f43038f68b806fe), UINT64_C(0x1f43090ea8b30720)
    },
    {   UINT64_C(0x0000000000005f96), UINT64_C(0x1f43030ec0ae870c), UINT64_C(0x1f43014f20b8671c),
        UINT64_C(0x1f42fb0e90b4e737), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005f97), UINT64_C(0x1f4304ce68b4c73f), UINT64_C(0x1f42ff8eecb2c6f5),
        UINT64_C(0x1f43030efcb5e725), UINT64_C(0x1f43050e9cb0e70d)
    },
    {   UINT64_C(0x0000000000005f98), UINT64_C(0x1f430c4e50a9e701), UINT64_C(0x1f4303ceecb5c730),
        UINT64_C(0x1f43044f1cb06728), UINT64_C(0x1f43044f1cb4c711)
    },
    {   UINT64_C(0x0000000000005f99), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fe4f44b346ff), UINT64_C(0x1f42f94f34b5e6e9)
    },
    {   UINT64_C(0x0000000000005f9a), UINT64_C(0x1f43060ef8b3c719), UINT64_C(0x1f43030fc0b1a6f4),
        UINT64_C(0x1f43004ea4b60738), UINT64_C(0x1f43040e80b1a734)
    },
    {   UINT64_C(0x0000000000005f9b), UINT64_C(0x0000000000000000), UINT64_C(0x1f4316ce64a6c730),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43008ee0b7471a)
    },
    {   UINT64_C(0x0000000000005f9c), UINT64_C(0x1f4302ceccb5471c), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff0f58b306fe), UINT64_C(0x1f43034fb4b7270c)
    },
    {   UINT64_C(0x0000000000005f9d), UINT64_C(0x1f430b4e70a4c725), UINT64_C(0x1f43040f2cae4719),
        UINT64_C(0x1f43040f94b2871e), UINT64_C(0x1f43038e84b3a73e)
    },
    {   UINT64_C(0x0000000000005f9e), UINT64_C(0x1f43020f2cb766f5), UINT64_C(0x1f43020e80b0c716),
        UINT64_C(0x1f43094ff4adc6e9), UINT64_C(0x1f43020eb8b34713)
    },
    {   UINT64_C(0x0000000000005f9f), UINT64_C(0x1f42ff4ff0b3670f), UINT64_C(0x1f43074e80b0a729),
        UINT64_C(0x1f42fecf2cb68721), UINT64_C(0x1f42ff9000b2e6ff)
    },
    {   UINT64_C(0x0000000000005fa0), UINT64_C(0x1f43028f50b64717), UINT64_C(0x1f43010edcaf2718),
        UINT64_C(0x1f4308ce54b2e728), UINT64_C(0x1f42f34e98b8e73d)
    },
    {   UINT64_C(0x0000000000005fa1), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43044f34b2c6f8), UINT64_C(0x1f4309cec4b10719)
    },
    {   UINT64_C(0x0000000000005fa2), UINT64_C(0x1f42ffcee4af071a), UINT64_C(0x1f43020eb0b02733),
        UINT64_C(0x1f4300ce80b0872d), UINT64_C(0x1f43064e50b62720)
    },
    {   UINT64_C(0x0000000000005fa3), UINT64_C(0x1f4300ce28ab273d), UINT64_C(0x1f43170e50a9872f),
        UINT64_C(0x1f42fa8e78b5272d), UINT64_C(0x1f4303cf14b12739)
    },
    {   UINT64_C(0x0000000000005fa4), UINT64_C(0x1f43038ee4b0e6f2), UINT64_C(0x1f4309cf3cb42711),
        UINT64_C(0x1f42fe4f90b3673a), UINT64_C(0x1f4307cf24b4c714)
    },
    {   UINT64_C(0x0000000000005fa5), UINT64_C(0x1f43024e68b6e73d), UINT64_C(0x1f43030e28b50731),
        UINT64_C(0x1f42fb4e78b5872d), UINT64_C(0x1f43078e34af2735)
    },
    {   UINT64_C(0x0000000000005fa6), UINT64_C(0x1f43020eb0b42740), UINT64_C(0x1f42ff8eccb4c6f2),
        UINT64_C(0x1f4306cea0b72711), UINT64_C(0x1f430b4e28b3c749)
    },
    {   UINT64_C(0x0000000000005fa7), UINT64_C(0x1f43024e70b60741), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4333cfe48de6df)
    },
    {   UINT64_C(0x0000000000005fa8), UINT64_C(0x1f43098f64a46719), UINT64_C(0x1f430a8f0cb3e6f4),
        UINT64_C(0x1f43099024b546ee), UINT64_C(0x1f430a8f20b2670d)
    },
    {   UINT64_C(0x0000000000005fa9), UINT64_C(0x1f43040ee8b10707), UINT64_C(0x1f430c4fd4b4270e),
        UINT64_C(0x1f430b0f64aae706), UINT64_C(0x1f4304cfdcb5e6f8)
    },
    {   UINT64_C(0x0000000000005faa), UINT64_C(0x1f43040ff8b3c70f), UINT64_C(0x1f43074f74ac2705),
        UINT64_C(0x1f430e9068b36706), UINT64_C(0x1f43091038ad6700)
    },
    {   UINT64_C(0x0000000000005fab), UINT64_C(0x1f4304cee8af870c), UINT64_C(0x1f4309d06cb166f0),
        UINT64_C(0x1f43094fbcade716), UINT64_C(0x1f43048fd4b58705)
    },
    {   UINT64_C(0x0000000000005fac), UINT64_C(0x1f43011040b3a6e0), UINT64_C(0x1f43064f48b346f7),
        UINT64_C(0x1f4306cf70abe6fc), UINT64_C(0x1f4305cfa4ac06ff)
    },
    {   UINT64_C(0x000000000000911a), UINT64_C(0x17baf7cfa0990695), UINT64_C(0x16b2f88fa097e685),
        UINT64_C(0x15eafbcf709ba695), UINT64_C(0x1992f88fa0a14685)
    },
    {   UINT64_C(0x0000000000005fae), UINT64_C(0x1f43061018b366f0), UINT64_C(0x1f430ad054b466f0),
        UINT64_C(0x1f43060f8cae0701), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005faf), UINT64_C(0x0000000000000000), UINT64_C(0x1f4307d0d0b34700),
        UINT64_C(0x1f43078edcb3c70a), UINT64_C(0x1f43094ed8b0c703)
    },
    {   UINT64_C(0x0000000000005fb0), UINT64_C(0x1f430b0f5cb366f2), UINT64_C(0x1f4307105cb2e6e4),
        UINT64_C(0x1f4304cfdcb566ff), UINT64_C(0x1f43038f0cb0270b)
    },
    {   UINT64_C(0x0000000000005fb1), UINT64_C(0x1f430a104cb526ed), UINT64_C(0x1f4308ce68aec725),
        UINT64_C(0x1f430910d8b126ef), UINT64_C(0x1f43021018ae06ec)
    },
    {   UINT64_C(0x0000000000005fb2), UINT64_C(0x1f43058f60b74717), UINT64_C(0x1f430a1054ac86e5),
        UINT64_C(0x1f43088ee8b06728), UINT64_C(0x1f430a0f28afe709)
    },
    {   UINT64_C(0x0000000000005fb3), UINT64_C(0x1f43050fecab86f5), UINT64_C(0x1f430b0fe8aa06f3),
        UINT64_C(0x1f43024eacb4a6fc), UINT64_C(0x1f4309901cb3a6f6)
    },
    {   UINT64_C(0x0000000000005fb4), UINT64_C(0x1f430ad014ad66ee), UINT64_C(0x1f4303ce8cb246fe),
        UINT64_C(0x1f4308cf24b42718), UINT64_C(0x1f430a8fc8ae8711)
    },
    {   UINT64_C(0x000000000000911e), UINT64_C(0x1952fbcd389d0695), UINT64_C(0x190af88fa0a08685),
        UINT64_C(0x14fafbcf78968695), UINT64_C(0x11c2f50fa0960685)
    },
    {   UINT64_C(0x0000000000005fb6), UINT64_C(0x1f4305d000b446fe), UINT64_C(0x1f43044fc8b926fb),
        UINT64_C(0x1f43080f34ae872e), UINT64_C(0x1f43034eacb8272e)
    },
    {   UINT64_C(0x0000000000005fb7), UINT64_C(0x1f43058fb8b7e720), UINT64_C(0x1f4303900cb00709),
        UINT64_C(0x1f430a9028b446fa), UINT64_C(0x1f43044f8cb5e706)
    },
    {   UINT64_C(0x0000000000005fb8), UINT64_C(0x1f43080f50b566d7), UINT64_C(0x1f43074eecab670e),
        UINT64_C(0x1f430b4ef0a6c6e9), UINT64_C(0x1f43098f1cb6e70c)
    },
    {   UINT64_C(0x0000000000005fb9), UINT64_C(0x0000000000000000), UINT64_C(0x1f4305cf3cb246fe),
        UINT64_C(0x1f4302cee8b7471b), UINT64_C(0x1f4303cfa0b126f8)
    },
    {   UINT64_C(0x0000000000005fba), UINT64_C(0x1f43030ef4b0a725), UINT64_C(0x1f43074eecb06738),
        UINT64_C(0x1f43058efcb20719), UINT64_C(0x1f43044f24b4c71e)
    },
    {   UINT64_C(0x0000000000005fbb), UINT64_C(0x0000000000000000), UINT64_C(0x1f43074f68b0c72e),
        UINT64_C(0x1f43044e84b2e726), UINT64_C(0x1f43040f38b266fa)
    },
    {   UINT64_C(0x0000000000005fbc), UINT64_C(0x1f43064e6cb2c72c), UINT64_C(0x1f4303cf98ade6fe),
        UINT64_C(0x1f4308cff4b506e0), UINT64_C(0x1f43034f9cb3e701)
    },
    {   UINT64_C(0x0000000000005fbd), UINT64_C(0x1f43068f28b4671c), UINT64_C(0x1f43058eb8a98735),
        UINT64_C(0x1f43068f68b526fd), UINT64_C(0x1f43010f98acc6ee)
    },
    {   UINT64_C(0x0000000000005fbe), UINT64_C(0x1f43010f6ca8a6fe), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4303cfa8b566ea), UINT64_C(0x1f43048f60b5c71c)
    },
    {   UINT64_C(0x0000000000005fbf), UINT64_C(0x1f4304cf60ad86fe), UINT64_C(0x1f43064ff8b4671d),
        UINT64_C(0x1f43040f18aec70a), UINT64_C(0x1f43044f28b726f7)
    },
    {   UINT64_C(0x0000000000005fc0), UINT64_C(0x1f4303d008b6c6f2), UINT64_C(0x1f4305cfacac26ed),
        UINT64_C(0x1f43060ee8afe72a), UINT64_C(0x1f43068f68aec6da)
    },
    {   UINT64_C(0x0000000000005fc1), UINT64_C(0x1f43040f2cb44721), UINT64_C(0x1f43044fccb306f7),
        UINT64_C(0x1f43064f84b2a71e), UINT64_C(0x1f43064f90b4e6f7)
    },
    {   UINT64_C(0x0000000000005fc2), UINT64_C(0x1f43020fc4b486f0), UINT64_C(0x1f43080e8cb26703),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430b0f08b1c719)
    },
    {   UINT64_C(0x0000000000005fc3), UINT64_C(0x1f43075020b1e6d3), UINT64_C(0x1f430a8fd4b466f2),
        UINT64_C(0x1f43070f84b786f0), UINT64_C(0x1f43038fdcb6e6e0)
    },
    {   UINT64_C(0x0000000000005fc4), UINT64_C(0x0000000000000000), UINT64_C(0x1f4303d020b726e0),
        UINT64_C(0x1f42ff4f78b446e6), UINT64_C(0x1f4305cefcb4471b)
    },
    {   UINT64_C(0x0000000000005fc5), UINT64_C(0x1f43094e6cb3472a), UINT64_C(0x1f4302cf44afc705),
        UINT64_C(0x1f43098f9cabe703), UINT64_C(0x1f43050f30af46e6)
    },
    {   UINT64_C(0x0000000000005fc6), UINT64_C(0x1f42ff8ec8b7a725), UINT64_C(0x1f43050f0cb146e6),
        UINT64_C(0x1f43048ee8b1e739), UINT64_C(0x1f42fe8ec8b0a70d)
    },
    {   UINT64_C(0x0000000000005fc7), UINT64_C(0x1f43038efcb3471c), UINT64_C(0x1f43064f58b52708),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43068f60ade70e)
    },
    {   UINT64_C(0x0000000000005fc8), UINT64_C(0x1f4302cfb0b1c725), UINT64_C(0x1f43080f3caf0707),
        UINT64_C(0x1f43041058b2a700), UINT64_C(0x1f4304ced4b2c72e)
    },
    {   UINT64_C(0x0000000000009128), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x182b02cf649b0697), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005fca), UINT64_C(0x1f43020f68ade6fc), UINT64_C(0x1f4306cf44ad26ff),
        UINT64_C(0x1f43054ea0b7c713), UINT64_C(0x1f43090edcb54737)
    },
    {   UINT64_C(0x0000000000005fcb), UINT64_C(0x1f42ffcf60ad070d), UINT64_C(0x1f43014edcb68714),
        UINT64_C(0x1f4300cf5cb3a729), UINT64_C(0x1f4306ceb0b0072d)
    },
    {   UINT64_C(0x000000000000b829), UINT64_C(0x0bd2f08bfc6b45be), UINT64_C(0x0c6b00d64868c685),
        UINT64_C(0x0de2f78d607424c0), UINT64_C(0x0bc2f5978869c6a6)
    },
    {   UINT64_C(0x0000000000005fcd), UINT64_C(0x1f4303cfb4b72705), UINT64_C(0x1f43064f18b3071a),
        UINT64_C(0x1f43068f78af8717), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005fce), UINT64_C(0x1f42f8d07cb6c6f3), UINT64_C(0x1f43140ef8ac271b),
        UINT64_C(0x1f42fccfb4b546f0), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005fcf), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f7cebcb8272a),
        UINT64_C(0x1f42face7cb4e705), UINT64_C(0x1f43034f84ae26ea)
    },
    {   UINT64_C(0x0000000000005fd0), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43098ec4ae0714), UINT64_C(0x1f430f4ee0aee72a)
    },
    {   UINT64_C(0x0000000000005fd1), UINT64_C(0x1f42f9cec4b38726), UINT64_C(0x1f42fbce6cb0872d),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005fd2), UINT64_C(0x1f42f6ce7cb36726), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43040e94b1a72c), UINT64_C(0x1f43178e88ab6725)
    },
    {   UINT64_C(0x0000000000005fd3), UINT64_C(0x1f43074e70ad8720), UINT64_C(0x1f430c4eb8aee737),
        UINT64_C(0x1f42f64f24b7473f), UINT64_C(0x1f42f9cf04b78739)
    },
    {   UINT64_C(0x0000000000005fd4), UINT64_C(0x1f42fb8e98b3672e), UINT64_C(0x1f4315cf48a4c6e0),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005fd5), UINT64_C(0x1f43128f4ca56718), UINT64_C(0x1f430d4e8cb0e6ff),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43220f4ca506ee)
    },
    {   UINT64_C(0x0000000000005fd6), UINT64_C(0x1f4315cedca646e7), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43004ea8a4a70c), UINT64_C(0x1f43040e5cb78701)
    },
    {   UINT64_C(0x0000000000005fd7), UINT64_C(0x1f430e4f2cae270b), UINT64_C(0x1f430f8f20b126fd),
        UINT64_C(0x1f430d4e64a8e720), UINT64_C(0x1f42fd0f1cb266f5)
    },
    {   UINT64_C(0x0000000000005fd8), UINT64_C(0x1f431d0e74acc71c), UINT64_C(0x1f43054fb0adc70a),
        UINT64_C(0x1f430a8f38aee6f5), UINT64_C(0x1f43134f08abe708)
    },
    {   UINT64_C(0x0000000000005fd9), UINT64_C(0x0000000000000000), UINT64_C(0x1f4321ce2ca66717),
        UINT64_C(0x1f43150e9cab06fb), UINT64_C(0x1f43068e9cb4c700)
    },
    {   UINT64_C(0x0000000000005fda), UINT64_C(0x1f4302cf48b2c705), UINT64_C(0x1f43014e5cb28730),
        UINT64_C(0x1f430c4e98af2703), UINT64_C(0x1f430b4ebcac4707)
    },
    {   UINT64_C(0x0000000000005fdb), UINT64_C(0x1f43104f3cac26fe), UINT64_C(0x1f43160ecca926f3),
        UINT64_C(0x1f4313ced0b04704), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005fdc), UINT64_C(0x1f43018eb8a44724), UINT64_C(0x1f431bce8ca566f3),
        UINT64_C(0x1f43018e44b36719), UINT64_C(0x1f43124f40aec701)
    },
    {   UINT64_C(0x0000000000005fdd), UINT64_C(0x1f43124f58a886fe), UINT64_C(0x1f430f4e70a70725),
        UINT64_C(0x1f431fce84a8a71e), UINT64_C(0x1f43120e90b6871f)
    },
    {   UINT64_C(0x0000000000005fde), UINT64_C(0x1f43010f44b20724), UINT64_C(0x1f43098e9cb4271f),
        UINT64_C(0x1f43124edca9071d), UINT64_C(0x1f43074edcb10707)
    },
    {   UINT64_C(0x0000000000005fdf), UINT64_C(0x1f43038eb8af671e), UINT64_C(0x1f42fb8e90a32720),
        UINT64_C(0x1f43204e54a74719), UINT64_C(0x1f43160eb8ad670a)
    },
    {   UINT64_C(0x0000000000005fe0), UINT64_C(0x0000000000000000), UINT64_C(0x1f430c8f18afc706),
        UINT64_C(0x1f43100e44aa8723), UINT64_C(0x1f43080e70b5c72a)
    },
    {   UINT64_C(0x0000000000005fe1), UINT64_C(0x0000000000000000), UINT64_C(0x1f43178ebcb14723),
        UINT64_C(0x1f43098ed0aae728), UINT64_C(0x1f43028e94b18717)
    },
    {   UINT64_C(0x0000000000005fe2), UINT64_C(0x1f43068ed0ac2715), UINT64_C(0x1f430e0ef4ada6f7),
        UINT64_C(0x1f4303ce9cb36744), UINT64_C(0x1f430c8eacb0671c)
    },
    {   UINT64_C(0x0000000000005fe3), UINT64_C(0x1f4304ce94b38727), UINT64_C(0x1f430d0e7cb2c71a),
        UINT64_C(0x1f430c8ef4b2473e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005fe4), UINT64_C(0x0000000000000000), UINT64_C(0x1f431a0ef0a9072d),
        UINT64_C(0x1f43008f38b98705), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005fe5), UINT64_C(0x1f43044f3cb1272d), UINT64_C(0x1f43138e54ad672c),
        UINT64_C(0x1f43008f48b78709), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005fe6), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff8f2cb4e6fe), UINT64_C(0x1f431d0e4ca76736)
    },
    {   UINT64_C(0x0000000000005fe7), UINT64_C(0x1f42fc8eccb1e70b), UINT64_C(0x1f43010f34b32703),
        UINT64_C(0x1f42fc0f60aec73b), UINT64_C(0x1f42ff8f34b06703)
    },
    {   UINT64_C(0x0000000000005fe8), UINT64_C(0x1f43000f18aee6fd), UINT64_C(0x1f43184e50ae6733),
        UINT64_C(0x1f43034e9cae270c), UINT64_C(0x1f4306ce48af2745)
    },
    {   UINT64_C(0x0000000000005fe9), UINT64_C(0x1f42f80eb8b46732), UINT64_C(0x1f42fc8fc8af6700),
        UINT64_C(0x1f42facf60b66707), UINT64_C(0x1f42fd4fb4b2c710)
    },
    {   UINT64_C(0x0000000000005fea), UINT64_C(0x1f43124eacaa073a), UINT64_C(0x1f43010e64aee74e),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005feb), UINT64_C(0x1f43054f5cb086e2), UINT64_C(0x1f42fa0e88b906fe),
        UINT64_C(0x1f43150ec4a80727), UINT64_C(0x1f42fb8eb8af671e)
    },
    {   UINT64_C(0x0000000000005fec), UINT64_C(0x1f42facef4b1c70b), UINT64_C(0x1f43034f50b12709),
        UINT64_C(0x1f4306ce4cb0c73f), UINT64_C(0x1f42f90f2cb3e6f8)
    },
    {   UINT64_C(0x0000000000005fed), UINT64_C(0x0000000000000000), UINT64_C(0x1f4302cf00b1e71c),
        UINT64_C(0x1f42fc8f3cb0e72d), UINT64_C(0x1f42fe0f6cb78713)
    },
    {   UINT64_C(0x0000000000005fee), UINT64_C(0x1f42fa8ec8b7c738), UINT64_C(0x1f43134eb0a7073d),
        UINT64_C(0x1f43018f08b3a711), UINT64_C(0x1f42f94e58b7a727)
    },
    {   UINT64_C(0x0000000000005fef), UINT64_C(0x1f42f98e80b2472f), UINT64_C(0x1f42ffcfa0a3a6e5),
        UINT64_C(0x1f42f40f3cb846a9), UINT64_C(0x1f43028e9cb2e70f)
    },
    {   UINT64_C(0x0000000000005ff0), UINT64_C(0x1f42ff4ed8b326ea), UINT64_C(0x1f430a4ee4b5e72e),
        UINT64_C(0x1f42fb4f50b7a6c3), UINT64_C(0x1f43018f20aa26e4)
    },
    {   UINT64_C(0x0000000000005ff1), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ffcf1cb4871e),
        UINT64_C(0x1f42ff8e3cb2c736), UINT64_C(0x1f43088f20aba6f2)
    },
    {   UINT64_C(0x0000000000005ff2), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fccf28aee703),
        UINT64_C(0x1f4304cf98abe70a), UINT64_C(0x1f42fe8fccb266e9)
    },
    {   UINT64_C(0x0000000000005ff3), UINT64_C(0x1f430a0fbcb24713), UINT64_C(0x1f42fd8f14b78705),
        UINT64_C(0x1f42f9cf70abc6f9), UINT64_C(0x1f43068ec4b4e702)
    },
    {   UINT64_C(0x0000000000005ff4), UINT64_C(0x1f42fe0fa8b546ec), UINT64_C(0x1f42fd8efcab8702),
        UINT64_C(0x1f43108ed0a7e729), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ff5), UINT64_C(0x1f42fd8fa0af2711), UINT64_C(0x1f4304ce00b80745),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43058ee0ab46de)
    },
    {   UINT64_C(0x0000000000005ff6), UINT64_C(0x1f43034f88b1a70e), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42faced4af0716)
    },
    {   UINT64_C(0x0000000000008740), UINT64_C(0x0ff2f1cfa07c65bc), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008741), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0fc2f34fa07aa5b8)
    },
    {   UINT64_C(0x0000000000005ff9), UINT64_C(0x0000000000000000), UINT64_C(0x1f4304cea4ab0716),
        UINT64_C(0x1f430c4e58ab8733), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ffa), UINT64_C(0x1f430f8e50ad8727), UINT64_C(0x1f42f6cf9cb0471d),
        UINT64_C(0x1f42fb0f48b48700), UINT64_C(0x1f4300cfecb706cd)
    },
    {   UINT64_C(0x0000000000005ffb), UINT64_C(0x1f43140e40aa8739), UINT64_C(0x1f42f78f74b726d5),
        UINT64_C(0x1f43038f54ae26d2), UINT64_C(0x1f431fced4a6c712)
    },
    {   UINT64_C(0x0000000000005ffc), UINT64_C(0x1f42f94eb0b80724), UINT64_C(0x1f42fbcef8aec73a),
        UINT64_C(0x1f42fdcf74b386e8), UINT64_C(0x1f430e8e88b58730)
    },
    {   UINT64_C(0x0000000000009142), UINT64_C(0x16cafa8f4093469f), UINT64_C(0x17fafa8c7098069f),
        UINT64_C(0x1932fa8f409ce69f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000005ffe), UINT64_C(0x1f4302cf40aec70c), UINT64_C(0x1f42fd0ef4b68726),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fecf3caea713)
    },
    {   UINT64_C(0x0000000000005fff), UINT64_C(0x1f43088ea8b0c731), UINT64_C(0x1f42f98f20b1a701),
        UINT64_C(0x1f42fc4f2cafc6f1), UINT64_C(0x1f43000ebcb1a726)
    },
    {   UINT64_C(0x0000000000006000), UINT64_C(0x1f42fc8f34b34707), UINT64_C(0x1f42fd8f78b22735),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43028e44b3273d)
    },
    {   UINT64_C(0x0000000000006001), UINT64_C(0x1f43068eb4ad8736), UINT64_C(0x1f4300cee0b4473c),
        UINT64_C(0x1f42fdce54b1e735), UINT64_C(0x1f4308cef4a7670e)
    },
    {   UINT64_C(0x0000000000006002), UINT64_C(0x1f43068e80af4736), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4304ce84ae8736)
    },
    {   UINT64_C(0x0000000000006003), UINT64_C(0x1f430e8fecad66cc), UINT64_C(0x1f42f7cf0cb3c70a),
        UINT64_C(0x1f43124f2caa26ee), UINT64_C(0x1f43078ed4abe6d3)
    },
    {   UINT64_C(0x0000000000006004), UINT64_C(0x1f4300ceb4b666f9), UINT64_C(0x1f43108e98aa270f),
        UINT64_C(0x1f43084e6cb44727), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006005), UINT64_C(0x1f42f6cea4b74712), UINT64_C(0x1f42f9cedcb5e72e),
        UINT64_C(0x1f4301cf08b2870e), UINT64_C(0x1f42f90eccb9e717)
    },
    {   UINT64_C(0x0000000000006006), UINT64_C(0x1f42f58ef8b02726), UINT64_C(0x1f42f68ebcb40723),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ffcedca926ff)
    },
    {   UINT64_C(0x0000000000006007), UINT64_C(0x1f42f9cef8aa472b), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f9cf58b2c70b), UINT64_C(0x1f42fc8ef8b2272a)
    },
    {   UINT64_C(0x0000000000006008), UINT64_C(0x1f42fc8eecb72727), UINT64_C(0x1f42f68f38b4a71f),
        UINT64_C(0x1f43004f08af8716), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006009), UINT64_C(0x1f42f4ce94b48710), UINT64_C(0x1f43008f38ade71b),
        UINT64_C(0x1f42f90f28b1e726), UINT64_C(0x1f43018ef8b3e71c)
    },
    {   UINT64_C(0x000000000000600a), UINT64_C(0x1f42f84e5cb5672a), UINT64_C(0x1f42fa8e48b54715),
        UINT64_C(0x1f42ff0eacb30714), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000600b), UINT64_C(0x1f42f78eacb5a70e), UINT64_C(0x1f42f58e88b7c72f),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000600c), UINT64_C(0x1f42fb8e50b5e720), UINT64_C(0x1f42f7cf78b2c71b),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe8e5cb36718)
    },
    {   UINT64_C(0x000000000000600d), UINT64_C(0x1f42fb0eecb3e6ce), UINT64_C(0x1f42fa4eecb446b3),
        UINT64_C(0x1f42fecf18abc6f4), UINT64_C(0x1f43100e8cb2271b)
    },
    {   UINT64_C(0x000000000000600e), UINT64_C(0x1f430e8e4cb2c707), UINT64_C(0x1f42fc4f64b6c6eb),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43010f40b3e6ce)
    },
    {   UINT64_C(0x000000000000600f), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0f24b426ff),
        UINT64_C(0x1f43008ed8ad670c), UINT64_C(0x1f42f7cf74b746f8)
    },
    {   UINT64_C(0x000000000000b84b), UINT64_C(0x0ffb25113463257c), UINT64_C(0x0ffb25113063257b),
        UINT64_C(0x0b9af1930466250a), UINT64_C(0x0b9afb93046b250a)
    },
    {   UINT64_C(0x0000000000006011), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f64eb4b9c72c), UINT64_C(0x1f43038f58b346c0)
    },
    {   UINT64_C(0x0000000000006012), UINT64_C(0x1f42fc0f18b0e6ee), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fccee8b3a715), UINT64_C(0x1f43114e4caa872b)
    },
    {   UINT64_C(0x0000000000006013), UINT64_C(0x1f42fe8f50ae46d0), UINT64_C(0x1f42fc4f60af06f6),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff4f94ada6c8)
    },
    {   UINT64_C(0x000000000000b84d), UINT64_C(0x09daee0ff065e5ce), UINT64_C(0x1cf327913495857d),
        UINT64_C(0x09daee0f1465e605), UINT64_C(0x204b275134a3257d)
    },
    {   UINT64_C(0x0000000000006015), UINT64_C(0x1f42fd0f70b166e7), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430f0f20afc70a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000b84e), UINT64_C(0x0f02eb98c07bc662), UINT64_C(0x0f02eb8cdc7bc369),
        UINT64_C(0x16fafecf74e14797), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008760), UINT64_C(0x0000000000000000), UINT64_C(0x1082f4cb247be693),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006018), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f5cf68b7c6f5),
        UINT64_C(0x1f42fbcf04b4c6ec), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006019), UINT64_C(0x1f42fb0ec0b6c72d), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90ff4b806f2)
    },
    {   UINT64_C(0x000000000000601a), UINT64_C(0x1f42f6ceb8b7472c), UINT64_C(0x1f42fb0f08b06728),
        UINT64_C(0x1f42fdcf70b306f6), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000601b), UINT64_C(0x1f42f8ced4b4e71d), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8ceacae072c)
    },
    {   UINT64_C(0x000000000000601c), UINT64_C(0x1f42f84eacb38737), UINT64_C(0x1f4309ce4cb0673e),
        UINT64_C(0x1f42fece1cb18736), UINT64_C(0x1f43028e6cb5a73b)
    },
    {   UINT64_C(0x000000000000601d), UINT64_C(0x1f43018f34b1e714), UINT64_C(0x1f42f80f1cb06728),
        UINT64_C(0x1f4300ce3cb3473b), UINT64_C(0x1f42ffcedcb2e700)
    },
    {   UINT64_C(0x000000000000601e), UINT64_C(0x1f42fb4f4cade735), UINT64_C(0x1f42f9ce14b68724),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000601f), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fdcf78b02727),
        UINT64_C(0x1f430cce3cb0073b), UINT64_C(0x1f43048e98b46738)
    },
    {   UINT64_C(0x000000000000b853), UINT64_C(0x1acafa0d289fa67c), UINT64_C(0x1acb020d28a3a67c),
        UINT64_C(0x156af90d2c8aa67d), UINT64_C(0x156b010d2c8ea67d)
    },
    {   UINT64_C(0x0000000000009154), UINT64_C(0x119af10fa094267e), UINT64_C(0x0000000000000000),
        UINT64_C(0x118af94f787dc5b4), UINT64_C(0x11aafa8f78800693)
    },
    {   UINT64_C(0x0000000000006022), UINT64_C(0x0000000000000000), UINT64_C(0x1f431bcf08a38723),
        UINT64_C(0x1f42f90f90b166c6), UINT64_C(0x1f42f84fd8ad26f9)
    },
    {   UINT64_C(0x0000000000006023), UINT64_C(0x1f42fa4fe8b7c6b6), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43060e00b9a71a)
    },
    {   UINT64_C(0x0000000000006024), UINT64_C(0x1f42f90f50b566f5), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f80f74b946e4), UINT64_C(0x1f43084e58aa4732)
    },
    {   UINT64_C(0x0000000000006025), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb0fb8afa6be),
        UINT64_C(0x1f43224f089ea712), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006026), UINT64_C(0x1f42fa0ee4b16718), UINT64_C(0x1f43354eb89de6fd),
        UINT64_C(0x1f42fd1000b446f6), UINT64_C(0x1f42f81028b366dc)
    },
    {   UINT64_C(0x0000000000009157), UINT64_C(0x113afa8fa081e693), UINT64_C(0x0812fbcfa057e693),
        UINT64_C(0x19f2fbcfa09f65b4), UINT64_C(0x1102fbcfa07ba5b4)
    },
    {   UINT64_C(0x0000000000006028), UINT64_C(0x1f42fa4f40b106bd), UINT64_C(0x1f42ff0fa4b526ed),
        UINT64_C(0x1f42f84f54b52716), UINT64_C(0x1f42f64ef8b726ef)
    },
    {   UINT64_C(0x0000000000006029), UINT64_C(0x1f43004fe4b4c6e9), UINT64_C(0x1f42fe1028b566da),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000602a), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8e489d4732),
        UINT64_C(0x1f42fa0f9cb026eb), UINT64_C(0x1f42f80ff8b18713)
    },
    {   UINT64_C(0x000000000000602b), UINT64_C(0x1f42f8cf1cb60708), UINT64_C(0x1f42f80ff0ac86f8),
        UINT64_C(0x1f42f64f80b866e0), UINT64_C(0x1f43018e7cb1e738)
    },
    {   UINT64_C(0x000000000000602c), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0f94ad870c),
        UINT64_C(0x1f43098e50afe732), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000602d), UINT64_C(0x1f43044e8cab0730), UINT64_C(0x1f42fa4ee8b026cf),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43011004b546fc)
    },
    {   UINT64_C(0x000000000000602e), UINT64_C(0x1f42f80e9cb5470e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd0e6cb20718), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000602f), UINT64_C(0x1f42fd0f18b3e716), UINT64_C(0x1f43001034b446e1),
        UINT64_C(0x1f4320ced0b28703), UINT64_C(0x1f42fa4f14afa6fe)
    },
    {   UINT64_C(0x0000000000006030), UINT64_C(0x1f42fe4f74b4a6e6), UINT64_C(0x1f42f74fd8b006e3),
        UINT64_C(0x1f42f90eb8ae870d), UINT64_C(0x1f43238edca44727)
    },
    {   UINT64_C(0x0000000000006031), UINT64_C(0x1f43274ed4a1c734), UINT64_C(0x1f42f64f98b546e9),
        UINT64_C(0x1f42fa4fa4b266bd), UINT64_C(0x1f42fb0eb8aee6f6)
    },
    {   UINT64_C(0x0000000000006032), UINT64_C(0x1f42f84f88b3e6e9), UINT64_C(0x1f42fb0fa0a8c6d8),
        UINT64_C(0x1f42fc0ef4af8701), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000915d), UINT64_C(0x18b2fb8f3c9a66a5), UINT64_C(0x191afb8c6c9c06a5),
        UINT64_C(0x1b02f88f3ca446a5), UINT64_C(0x15dafacf3c8f26a5)
    },
    {   UINT64_C(0x0000000000006034), UINT64_C(0x1f42fe0fb0ab86c2), UINT64_C(0x1f42ff0f70b486c0),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006035), UINT64_C(0x1f430b4e14ae4732), UINT64_C(0x1f42f34ec8b5a6e4),
        UINT64_C(0x1f42fb0ea8b44730), UINT64_C(0x1f42f80e94b6a704)
    },
    {   UINT64_C(0x0000000000006036), UINT64_C(0x1f42fb0f64b486f2), UINT64_C(0x1f42fd0e98aba6f0),
        UINT64_C(0x1f42ff1010afc6c3), UINT64_C(0x1f42f80ed8ae06e8)
    },
    {   UINT64_C(0x000000000000915f), UINT64_C(0x1d12fb8eb4af46a5), UINT64_C(0x1ba2fa8f3ca7a6a5),
        UINT64_C(0x1aa2fb8f54a2c6a5), UINT64_C(0x18cafb8f3c9b06a5)
    },
    {   UINT64_C(0x0000000000006038), UINT64_C(0x1f42fd0fbcadc6ea), UINT64_C(0x1f430b0f14a92734),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f34f78b126fe)
    },
    {   UINT64_C(0x0000000000006039), UINT64_C(0x1f42f60f18b64722), UINT64_C(0x1f4304ce50b7a732),
        UINT64_C(0x1f42fa0fa8b3c6dc), UINT64_C(0x1f42fe1004b56702)
    },
    {   UINT64_C(0x000000000000603a), UINT64_C(0x1f43000f84b2a714), UINT64_C(0x1f43000ef4ae8715),
        UINT64_C(0x1f43010f84ab0712), UINT64_C(0x1f42fe0fc8b046c9)
    },
    {   UINT64_C(0x000000000000603b), UINT64_C(0x1f430a0e94b10732), UINT64_C(0x1f42f74fc8a926ca),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f44eacb8073e)
    },
    {   UINT64_C(0x000000000000603c), UINT64_C(0x1f42f54f68b2c727), UINT64_C(0x1f42f55008b386fe),
        UINT64_C(0x1f42fa0f94a966ef), UINT64_C(0x1f42f54f5cb6e722)
    },
    {   UINT64_C(0x000000000000603d), UINT64_C(0x1f42f74fb8ac26cd), UINT64_C(0x1f42f75014b246c6),
        UINT64_C(0x1f42fd5010b366fe), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000603e), UINT64_C(0x1f42f80f28ad2721), UINT64_C(0x1f42fb0fa4ad86bf),
        UINT64_C(0x1f42fa0f14af06d7), UINT64_C(0x1f42f74eecb286f8)
    },
    {   UINT64_C(0x000000000000603f), UINT64_C(0x1f42f64ee8b2c722), UINT64_C(0x1f430e0f30b4271e),
        UINT64_C(0x1f43054ec0b02714), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006040), UINT64_C(0x1f43174e74ad66fd), UINT64_C(0x1f42f90f9cb206df),
        UINT64_C(0x1f43000f6cae86f7), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006041), UINT64_C(0x0000000000000000), UINT64_C(0x1f43094e64a5c736),
        UINT64_C(0x1f42f80f78b4871b), UINT64_C(0x1f42f78f94b6c726)
    },
    {   UINT64_C(0x0000000000006042), UINT64_C(0x1f42f74f2cb9a728), UINT64_C(0x1f42f90f78b7270a),
        UINT64_C(0x1f43008e60b8a737), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006043), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb1010b5c6e2),
        UINT64_C(0x1f42fc4fa0ade6f5), UINT64_C(0x1f42f94fe0b166fe)
    },
    {   UINT64_C(0x000000000000b865), UINT64_C(0x16a2f10fa0978691), UINT64_C(0x1742f54fa097e68c),
        UINT64_C(0x10caf50f788105b7), UINT64_C(0x0f92f84c44796693)
    },
    {   UINT64_C(0x0000000000006045), UINT64_C(0x1f43170eb4a6072a), UINT64_C(0x1f42f80f34b286fa),
        UINT64_C(0x1f42f74e98b0672e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006046), UINT64_C(0x1f43004f5cb446f2), UINT64_C(0x1f42f74eb8b686e8),
        UINT64_C(0x1f42fc0eb8b066f3), UINT64_C(0x1f42fe4f70b146c9)
    },
    {   UINT64_C(0x0000000000006047), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe0ed8af8712),
        UINT64_C(0x1f42fe4f88af46da), UINT64_C(0x1f42fe4ea8b146f4)
    },
    {   UINT64_C(0x0000000000006048), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f84fb0b4e6af),
        UINT64_C(0x1f42f68f30b3a71f), UINT64_C(0x1f4303ce78ac0717)
    },
    {   UINT64_C(0x0000000000006049), UINT64_C(0x1f42fa0f24b7e6e3), UINT64_C(0x1f42ff0f6cb2c6fe),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f68f1cb4a708)
    },
    {   UINT64_C(0x000000000000604a), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90efcb72735),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0f78b76715)
    },
    {   UINT64_C(0x000000000000604b), UINT64_C(0x1f42fd4f08b266fd), UINT64_C(0x1f42fb0f78b2a6d7),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f54f70af2709)
    },
    {   UINT64_C(0x000000000000604c), UINT64_C(0x1f42fc0fd0b366c3), UINT64_C(0x1f42fa4f84b7071d),
        UINT64_C(0x1f42fd0f38b546d2), UINT64_C(0x1f42fd5018b3e6f0)
    },
    {   UINT64_C(0x000000000000604d), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb0fa4adc6c6), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000604e), UINT64_C(0x1f42f58ffcb726e4), UINT64_C(0x1f42fb0f18b9071c),
        UINT64_C(0x1f42fa0e7cafa72d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000604f), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd0f88b24709),
        UINT64_C(0x1f42fb0e5cb4c739), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006050), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80edcb7c702)
    },
    {   UINT64_C(0x0000000000006051), UINT64_C(0x1f42ff0f7cb0e6de), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f90fc4b42717), UINT64_C(0x1f42fa0f0cb186ff)
    },
    {   UINT64_C(0x0000000000006052), UINT64_C(0x1f42fd0ed4b00724), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f94f20b00716), UINT64_C(0x1f42f90f84b7871d)
    },
    {   UINT64_C(0x0000000000006053), UINT64_C(0x1f42fc0f3cb5c70f), UINT64_C(0x1f42f64f8cb3a708),
        UINT64_C(0x1f4315cea4b7e72b), UINT64_C(0x1f42fa104cb5a6dd)
    },
    {   UINT64_C(0x0000000000006054), UINT64_C(0x1f42fd4ec4ade73c), UINT64_C(0x1f42fc0f28b50721),
        UINT64_C(0x1f42fb4f5cb006d9), UINT64_C(0x1f42fa0ee8b36719)
    },
    {   UINT64_C(0x0000000000006055), UINT64_C(0x1f42f90fd0b246f9), UINT64_C(0x1f42f75014b76715),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006056), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb0f34ac26f7),
        UINT64_C(0x1f42fa4fe4b68706), UINT64_C(0x1f42f94fb4af66cf)
    },
    {   UINT64_C(0x0000000000006057), UINT64_C(0x1f42f90e8cb4c71d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f94ed4b7a6fc), UINT64_C(0x1f42fd0f80b42706)
    },
    {   UINT64_C(0x00000000000087a1), UINT64_C(0x1d82ef4f74b3072a), UINT64_C(0x1692f34f68954656),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006059), UINT64_C(0x1f42f94f1cae0702), UINT64_C(0x1f42fd0fc8b1c6db),
        UINT64_C(0x1f42f80ee0adc713), UINT64_C(0x1f42f54ed4b8670e)
    },
    {   UINT64_C(0x000000000000605a), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90ef0b0a6fc),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f74fb4afc72c)
    },
    {   UINT64_C(0x000000000000605b), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0f04ac26f0),
        UINT64_C(0x1f42f74fc8b366da), UINT64_C(0x1f42f74f50b0a717)
    },
    {   UINT64_C(0x000000000000605c), UINT64_C(0x1f42f80fc8b606fd), UINT64_C(0x1f42f74f5cb48715),
        UINT64_C(0x1f42f80f60b2a6d0), UINT64_C(0x1f42f90ec8b2c6c3)
    },
    {   UINT64_C(0x000000000000605d), UINT64_C(0x1f42f74fa8b6c70a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f54f48b7c6d8), UINT64_C(0x1f42f58f30ae46da)
    },
    {   UINT64_C(0x000000000000605e), UINT64_C(0x1f42fa0f1cb24706), UINT64_C(0x1f42fb0f78b64729),
        UINT64_C(0x1f42f44ef4b7272c), UINT64_C(0x1f42f74f80b2e6fd)
    },
    {   UINT64_C(0x000000000000605f), UINT64_C(0x1f42fb1004aee6cd), UINT64_C(0x1f42f81030b1c6e5),
        UINT64_C(0x1f42f74ef4b6e71f), UINT64_C(0x1f42f74fb8b7a6e7)
    },
    {   UINT64_C(0x0000000000006060), UINT64_C(0x1f42fb0e68b56721), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ffce54b2c742), UINT64_C(0x1f42f81018b5a6eb)
    },
    {   UINT64_C(0x0000000000006061), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f90ed8ae8728), UINT64_C(0x1f42f80f88b306e8)
    },
    {   UINT64_C(0x0000000000006062), UINT64_C(0x1f42f74f90ac26f9), UINT64_C(0x1f42f74f68b2c6fa),
        UINT64_C(0x1f42fa0f18b1e734), UINT64_C(0x1f43094e44b30728)
    },
    {   UINT64_C(0x0000000000006063), UINT64_C(0x1f42f84ef4b9e704), UINT64_C(0x1f42f90f20b3e709),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43100e58b1273a)
    },
    {   UINT64_C(0x0000000000006064), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa4f70ae06fb),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0e70b48733)
    },
    {   UINT64_C(0x0000000000006065), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f75020ab66e0),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff0f08af66ed)
    },
    {   UINT64_C(0x0000000000006066), UINT64_C(0x1f42f80e6cae8701), UINT64_C(0x1f42f80f70b1a6ce),
        UINT64_C(0x1f42fd4e5cad6747), UINT64_C(0x1f42f90f80b30722)
    },
    {   UINT64_C(0x0000000000006067), UINT64_C(0x1f42fa0f84b5472d), UINT64_C(0x1f42f44eb8b86743),
        UINT64_C(0x1f43010ec0b3e711), UINT64_C(0x1f42f80e9cb5c70e)
    },
    {   UINT64_C(0x0000000000006068), UINT64_C(0x1f42f64e80b6672e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb0f04aee711), UINT64_C(0x1f42f74fa4b14706)
    },
    {   UINT64_C(0x0000000000006069), UINT64_C(0x1f42fe8fb8b3471b), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa0e7cb20718), UINT64_C(0x1f42fb0f0cb4c712)
    },
    {   UINT64_C(0x000000000000606a), UINT64_C(0x1f42f54e54af4728), UINT64_C(0x1f42f94ee8b34731),
        UINT64_C(0x1f42f94f6cade716), UINT64_C(0x1f42f64ea8b9c71b)
    },
    {   UINT64_C(0x000000000000606b), UINT64_C(0x1f42f74f60b62720), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa0ec8b76716), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000606c), UINT64_C(0x1f42fc0f30b6c708), UINT64_C(0x1f42fb0e90b36722),
        UINT64_C(0x1f42fa0f74b186d3), UINT64_C(0x1f42fc0f28b7a732)
    },
    {   UINT64_C(0x000000000000917a), UINT64_C(0x15db00cf548c868c), UINT64_C(0x1592f44f5891a68c),
        UINT64_C(0x1f2af58f64b7668c), UINT64_C(0x1722f80fa096068c)
    },
    {   UINT64_C(0x000000000000606e), UINT64_C(0x1f42f3cf70b8c73b), UINT64_C(0x1f42fa0eb4af2726),
        UINT64_C(0x1f42fa8e24ac073e), UINT64_C(0x1f42f54f9cab6721)
    },
    {   UINT64_C(0x000000000000606f), UINT64_C(0x1f42f80f64b726b2), UINT64_C(0x1f42fd0f38b24742),
        UINT64_C(0x1f42f34eb4b4c733), UINT64_C(0x1f42f68ee0b5073b)
    },
    {   UINT64_C(0x0000000000006070), UINT64_C(0x1f42fc8e54b4872c), UINT64_C(0x1f42f80ed4b5c711),
        UINT64_C(0x1f42f9ce64a9273c), UINT64_C(0x1f42f74ea8b46715)
    },
    {   UINT64_C(0x000000000000917c), UINT64_C(0x0e72f44f6875c5c1), UINT64_C(0x1032f44f6878668c),
        UINT64_C(0x0e22f44f6c74a5c1), UINT64_C(0x0aa2f18fa06d469b)
    },
    {   UINT64_C(0x0000000000006072), UINT64_C(0x1f42fdce3cb3c72d), UINT64_C(0x1f42f74f88b8a70f),
        UINT64_C(0x1f42f34f48b2c704), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000087bc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1692f38fa0966762), UINT64_C(0x0fa2f18c3879e68e)
    },
    {   UINT64_C(0x0000000000006074), UINT64_C(0x1f42f90eccb22703), UINT64_C(0x1f42f64ed0b006e4),
        UINT64_C(0x1f42f74ea4b2a72b), UINT64_C(0x1f42f78ee8b6a735)
    },
    {   UINT64_C(0x0000000000006075), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa4f58b3e715),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0ef4b1e712)
    },
    {   UINT64_C(0x0000000000006076), UINT64_C(0x1f42f90f20b64732), UINT64_C(0x1f42f91020b1a70b),
        UINT64_C(0x1f42f90f30b4872c), UINT64_C(0x1f42fb4e88b0a6fa)
    },
    {   UINT64_C(0x0000000000006077), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff4eb0b70738),
        UINT64_C(0x1f42fb0eb8af6705), UINT64_C(0x1f42f74ee8b3a721)
    },
    {   UINT64_C(0x0000000000006078), UINT64_C(0x1f430fce2cadc737), UINT64_C(0x1f430a0e28abe734),
        UINT64_C(0x1f42f74e50b54729), UINT64_C(0x1f43204fc8acc6f2)
    },
    {   UINT64_C(0x0000000000009180), UINT64_C(0x0c0af44f6c6b25c1), UINT64_C(0x0c12efcf706ce65e),
        UINT64_C(0x1032fbcf647865b5), UINT64_C(0x0e72f1cf687665b5)
    },
    {   UINT64_C(0x000000000000607a), UINT64_C(0x1f430e5054b28726), UINT64_C(0x1f430ace7cb2a71a),
        UINT64_C(0x1f432c0f2c99e72e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000607b), UINT64_C(0x1f43078e5cb1c73e), UINT64_C(0x1f430c8eb0b2473d),
        UINT64_C(0x1f43090ebcb2c723), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000607c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fbcf38b44701), UINT64_C(0x1f430a9028b146f6)
    },
    {   UINT64_C(0x000000000000607d), UINT64_C(0x1f43061020b7a718), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430d0eb8aea6ed)
    },
    {   UINT64_C(0x000000000000607e), UINT64_C(0x1f43061038b166b3), UINT64_C(0x1f43038f90afc6f2),
        UINT64_C(0x1f430d0ea4b1c731), UINT64_C(0x1f42f9ce8cb6473e)
    },
    {   UINT64_C(0x000000000000607f), UINT64_C(0x1f4312cfb0ace6e8), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43088ec8b66727), UINT64_C(0x1f43068ee8b0270a)
    },
    {   UINT64_C(0x0000000000006080), UINT64_C(0x1f43160f14a58725), UINT64_C(0x1f43048e98b0e72f),
        UINT64_C(0x1f42f9ce9cb8072e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006081), UINT64_C(0x1f431c8f2ca586f7), UINT64_C(0x1f430e4e5ca2673b),
        UINT64_C(0x1f43048ef8b2c700), UINT64_C(0x1f4301cef0b44738)
    },
    {   UINT64_C(0x0000000000006082), UINT64_C(0x1f42fe8f9cb446ea), UINT64_C(0x1f42fc4e6cb88744),
        UINT64_C(0x1f430a0e68a98748), UINT64_C(0x1f43064f20b186f3)
    },
    {   UINT64_C(0x0000000000009185), UINT64_C(0x1a5b00cfa0b3267e), UINT64_C(0x151b008f689e467e),
        UINT64_C(0x165306cf689fe68c), UINT64_C(0x106b008fa08e467e)
    },
    {   UINT64_C(0x0000000000006084), UINT64_C(0x1f42f6cfd0b586f2), UINT64_C(0x1f42ff8ee8b466fd),
        UINT64_C(0x1f42f70ebcb8872b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000009186), UINT64_C(0x166306cce49fe68c), UINT64_C(0x126b008fa08e667e),
        UINT64_C(0x10eafd8f6889268c), UINT64_C(0x1303164fa09c067e)
    },
    {   UINT64_C(0x0000000000006086), UINT64_C(0x1f42faceb8b54718), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ffcec8b04725)
    },
    {   UINT64_C(0x0000000000006087), UINT64_C(0x1f430e4e4caf674f), UINT64_C(0x1f430a0e20b3073f),
        UINT64_C(0x1f43068e9cb1c733), UINT64_C(0x1f42fcce48b5c737)
    },
    {   UINT64_C(0x0000000000006088), UINT64_C(0x1f42fc0f80ad6712), UINT64_C(0x1f42f6cf5cb5471d),
        UINT64_C(0x1f42f84f94ae671a), UINT64_C(0x1f42f84f98b62716)
    },
    {   UINT64_C(0x0000000000006089), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fccf44b5e711),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000608a), UINT64_C(0x1f42f8502cb52731), UINT64_C(0x1f42f3504cb8e73a),
        UINT64_C(0x1f42f64f6cb886fd), UINT64_C(0x1f42f38f44b20718)
    },
    {   UINT64_C(0x000000000000608b), UINT64_C(0x1f42f88f7cb7e729), UINT64_C(0x1f42f84f88b80718),
        UINT64_C(0x1f42fe8f8cb3472d), UINT64_C(0x1f42fe8f08aea709)
    },
    {   UINT64_C(0x000000000000608c), UINT64_C(0x1f42fbcfbcb7471d), UINT64_C(0x1f42f94f24b44718),
        UINT64_C(0x1f42fa4f3cb5c703), UINT64_C(0x1f42fb4f2cb0a713)
    },
    {   UINT64_C(0x000000000000608d), UINT64_C(0x1f42ff4e98ad870d), UINT64_C(0x1f42f74f58b38711),
        UINT64_C(0x1f42fa4f0caf6714), UINT64_C(0x1f42fa0eecb38702)
    },
    {   UINT64_C(0x000000000000608e), UINT64_C(0x1f42fa8e58b1671b), UINT64_C(0x1f42fa4f04b52701),
        UINT64_C(0x1f42fc8e9cb0a71e), UINT64_C(0x1f42f84fb0aae722)
    },
    {   UINT64_C(0x000000000000608f), UINT64_C(0x1f42f98f70b4e71e), UINT64_C(0x1f42f64e7cb6c715),
        UINT64_C(0x1f42f84f94b3071a), UINT64_C(0x1f42f90ed4b72715)
    },
    {   UINT64_C(0x0000000000006090), UINT64_C(0x1f42f84ef4b1e713), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f2ce8cb70716), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006091), UINT64_C(0x1f42fc8e50b1c6ff), UINT64_C(0x1f42f48e80b8a6fe),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f64f64b5c715)
    },
    {   UINT64_C(0x0000000000006092), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0fc4b60724),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f54f7cb1a719)
    },
    {   UINT64_C(0x0000000000006093), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fdcf84af66fa), UINT64_C(0x1f42ff0f88ada70b)
    },
    {   UINT64_C(0x0000000000006094), UINT64_C(0x1f42fa4f00b50704), UINT64_C(0x1f43000fecb16707),
        UINT64_C(0x1f42fc4ef0ab870d), UINT64_C(0x1f42f94e8cb3c6ff)
    },
    {   UINT64_C(0x0000000000006095), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0ed0b8e712),
        UINT64_C(0x1f42f84f3cb2c710), UINT64_C(0x1f42fd0f3cb5a6f6)
    },
    {   UINT64_C(0x0000000000006096), UINT64_C(0x1f42f68f20b9a723), UINT64_C(0x1f42f68f1cb82723),
        UINT64_C(0x1f42fc0f60b28725), UINT64_C(0x1f42fb0ec4b0e705)
    },
    {   UINT64_C(0x0000000000006097), UINT64_C(0x1f42fa4e4cb2c717), UINT64_C(0x1f42f54f9cb7e730),
        UINT64_C(0x1f42f54ef0b7a6f6), UINT64_C(0x1f42ef4f44b54723)
    },
    {   UINT64_C(0x0000000000006098), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f70ef4b5c706),
        UINT64_C(0x1f42f94e7cb5e73d), UINT64_C(0x1f42f84f00b6a731)
    },
    {   UINT64_C(0x0000000000006099), UINT64_C(0x1f42fa4ef8b36734), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f88f9cb4271c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000609a), UINT64_C(0x1f42f88ef8b6c71d), UINT64_C(0x1f42f68e00b72731),
        UINT64_C(0x1f42f98e28b5a732), UINT64_C(0x1f42ff0f14b78739)
    },
    {   UINT64_C(0x000000000000609b), UINT64_C(0x1f42f68e8cb60733), UINT64_C(0x1f42f78f04b6e71d),
        UINT64_C(0x1f43270ee0b5e703), UINT64_C(0x1f432b8eb0b7272f)
    },
    {   UINT64_C(0x000000000000609c), UINT64_C(0x1f42fd8f50b806ca), UINT64_C(0x1f42fa0ec8b8a737),
        UINT64_C(0x1f43210f40b1c739), UINT64_C(0x1f42fd0f28b2270b)
    },
    {   UINT64_C(0x000000000000609d), UINT64_C(0x1f43048f6cb1e703), UINT64_C(0x1f42ff4f18b466fa),
        UINT64_C(0x1f42fb8f04b4c733), UINT64_C(0x1f42ff8f04b8871d)
    },
    {   UINT64_C(0x000000000000609e), UINT64_C(0x1f430b4ea8b00711), UINT64_C(0x1f43165410a74626),
        UINT64_C(0x1f43118f44ad671c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000609f), UINT64_C(0x1f43110e68ae2730), UINT64_C(0x1f430f4f2cb4e72e),
        UINT64_C(0x1f430f4f68b5e730), UINT64_C(0x1f4313cec0a8e732)
    },
    {   UINT64_C(0x00000000000060a0), UINT64_C(0x1f4318cef0ab872a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430d4ed8aa2720), UINT64_C(0x1f4311cf70b46749)
    },
    {   UINT64_C(0x00000000000060a1), UINT64_C(0x1f430f4f78b4e72e), UINT64_C(0x1f430d0e3cb8673b),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000060a2), UINT64_C(0x1f43134ed8aa8714), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4307cdf8aea745), UINT64_C(0x1f43068e50b14733)
    },
    {   UINT64_C(0x00000000000060a3), UINT64_C(0x0000000000000000), UINT64_C(0x1f430b4e48ac6746),
        UINT64_C(0x1f4318ce80a72736), UINT64_C(0x1f430e4f58b0c72a)
    },
    {   UINT64_C(0x00000000000060a4), UINT64_C(0x1f430e8e2cad872f), UINT64_C(0x1f430d0e98ae2733),
        UINT64_C(0x1f43084ee8b0871a), UINT64_C(0x1f43124e28af6746)
    },
    {   UINT64_C(0x00000000000060a5), UINT64_C(0x1f430aced8aca70a), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43188ee4a5a721)
    },
    {   UINT64_C(0x00000000000060a6), UINT64_C(0x1f430ecf98b0672e), UINT64_C(0x1f43140ef4b3c730),
        UINT64_C(0x1f430e0f38b10730), UINT64_C(0x1f43104f50b06729)
    },
    {   UINT64_C(0x00000000000060a7), UINT64_C(0x1f43100f18ada722), UINT64_C(0x1f43010eb4b80739),
        UINT64_C(0x1f430f0e58b42728), UINT64_C(0x1f43128e64b1473b)
    },
    {   UINT64_C(0x00000000000060a8), UINT64_C(0x1f4312cf2cad6722), UINT64_C(0x1f4315cf98a9872a),
        UINT64_C(0x1f42ff4e8caf0734), UINT64_C(0x1f43158ef4a7871a)
    },
    {   UINT64_C(0x00000000000060a9), UINT64_C(0x1f430a0f28b1a725), UINT64_C(0x1f42fe4e30b7a73f),
        UINT64_C(0x1f430bcf78a8071c), UINT64_C(0x1f43130e9caaa73e)
    },
    {   UINT64_C(0x00000000000060aa), UINT64_C(0x1f4309cf40adc72e), UINT64_C(0x1f43030f38b6c726),
        UINT64_C(0x1f431c4eb4abc72a), UINT64_C(0x1f4313cf40aea72a)
    },
    {   UINT64_C(0x00000000000060ab), UINT64_C(0x1f430acf0cb8673e), UINT64_C(0x1f43128ed0af4730),
        UINT64_C(0x1f43100e98a7272d), UINT64_C(0x1f430c0fc0ae6718)
    },
    {   UINT64_C(0x00000000000060ac), UINT64_C(0x1f430f0e7cb4072e), UINT64_C(0x1f42fe4f68b3673d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43084e8cb26739)
    },
    {   UINT64_C(0x00000000000060ad), UINT64_C(0x1f4315cee0a7e72d), UINT64_C(0x1f4310cf00aee734),
        UINT64_C(0x1f4313cedca6a725), UINT64_C(0x1f430b8fd8ae6729)
    },
    {   UINT64_C(0x00000000000060ae), UINT64_C(0x1f43074f34ac272e), UINT64_C(0x1f430bce6caae73e),
        UINT64_C(0x1f430d8f3cae872f), UINT64_C(0x1f43290e50a6a73d)
    },
    {   UINT64_C(0x00000000000060af), UINT64_C(0x1f430f0f34b0c735), UINT64_C(0x1f43114e40aa6735),
        UINT64_C(0x1f43064e4cb18735), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000060b0), UINT64_C(0x1f430e0f10b28720), UINT64_C(0x1f430a4facb34708),
        UINT64_C(0x1f43120fd4ab0717), UINT64_C(0x1f430c0f6cade72f)
    },
    {   UINT64_C(0x00000000000060b1), UINT64_C(0x1f430c8edcaea72a), UINT64_C(0x1f43108edcaa472d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43150ed8a7e73a)
    },
    {   UINT64_C(0x00000000000060b2), UINT64_C(0x1f42fd4f04a6a715), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43084ed4ad672a), UINT64_C(0x1f43168f1cad272f)
    },
    {   UINT64_C(0x00000000000060b3), UINT64_C(0x1f43120f04af0729), UINT64_C(0x1f4309cf48b5871a),
        UINT64_C(0x1f43190fd4aa0715), UINT64_C(0x1f4313cf08ace719)
    },
    {   UINT64_C(0x000000000000b89d), UINT64_C(0x0000000000000000), UINT64_C(0x105afe8c8877a58d),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000060b5), UINT64_C(0x1f430c4eccad472a), UINT64_C(0x1f430fce30a7873c),
        UINT64_C(0x1f43108ed4a88712), UINT64_C(0x1f430f0f30af471b)
    },
    {   UINT64_C(0x00000000000060b6), UINT64_C(0x1f43138f08a7872a), UINT64_C(0x1f43094f94b3a71c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4303ce64b06736)
    },
    {   UINT64_C(0x00000000000060b7), UINT64_C(0x1f430fcef0aae72a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43100eb4b3673d), UINT64_C(0x1f431aceb0a9e73f)
    },
    {   UINT64_C(0x00000000000060b8), UINT64_C(0x1f43130e1cae873c), UINT64_C(0x1f43094f50ad4724),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430e4f24ac473b)
    },
    {   UINT64_C(0x00000000000060b9), UINT64_C(0x1f4313ceacaa673c), UINT64_C(0x1f4300cf78ae671f),
        UINT64_C(0x1f43038f68b54738), UINT64_C(0x1f430a4e40ad073e)
    },
    {   UINT64_C(0x00000000000060ba), UINT64_C(0x1f430ccf2ca9672a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43168e84a9e732), UINT64_C(0x1f4312cecca7873d)
    },
    {   UINT64_C(0x00000000000060bb), UINT64_C(0x1f4314cef8a92726), UINT64_C(0x1f4313cea4ac673c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43028ea8b5472a)
    },
    {   UINT64_C(0x00000000000060bc), UINT64_C(0x1f4317cedcaac73c), UINT64_C(0x1f43058f4cb36741),
        UINT64_C(0x1f4315cf04a5a726), UINT64_C(0x1f430bcf18b4873a)
    },
    {   UINT64_C(0x00000000000060bd), UINT64_C(0x1f43068f2cb04736), UINT64_C(0x1f4314ce5cb1673a),
        UINT64_C(0x1f43060e50b7c744), UINT64_C(0x1f43068f00afe72a)
    },
    {   UINT64_C(0x00000000000060be), UINT64_C(0x0000000000000000), UINT64_C(0x1f430f4e4cb0e73b),
        UINT64_C(0x1f4301ce58b5273c), UINT64_C(0x1f42ff0eacb08740)
    },
    {   UINT64_C(0x00000000000060bf), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430ccf54a9e73c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000060c0), UINT64_C(0x1f4317cef8a72735), UINT64_C(0x1f43104f2cadc739),
        UINT64_C(0x1f430c0e70b3a73d), UINT64_C(0x1f43170f4cb5c735)
    },
    {   UINT64_C(0x00000000000060c1), UINT64_C(0x1f4300cf0cad0723), UINT64_C(0x1f430f4e48b18749),
        UINT64_C(0x1f43178e3ca8673d), UINT64_C(0x1f43034ea8b24736)
    },
    {   UINT64_C(0x00000000000060c2), UINT64_C(0x1f430a0facb22730), UINT64_C(0x1f43088ec8b3474e),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000060c3), UINT64_C(0x1f42fc4e2cae8737), UINT64_C(0x1f4316ceb0a98739),
        UINT64_C(0x1f43148f5ca8871a), UINT64_C(0x1f4313cf34b0472a)
    },
    {   UINT64_C(0x00000000000060c4), UINT64_C(0x0000000000000000), UINT64_C(0x1f43180ea8a68728),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000060c5), UINT64_C(0x1f43149028ab6716), UINT64_C(0x1f4313cf10ab6726),
        UINT64_C(0x1f4306cef0b38735), UINT64_C(0x1f42f88efca96733)
    },
    {   UINT64_C(0x00000000000060c6), UINT64_C(0x1f430a0f18ada745), UINT64_C(0x1f430f0ee4a72726),
        UINT64_C(0x1f43198eaca80717), UINT64_C(0x1f43198e1cb4472e)
    },
    {   UINT64_C(0x00000000000060c7), UINT64_C(0x1f43150f60a5e71a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430dce38a42731), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000060c8), UINT64_C(0x1f43024ef8b34736), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4310cee0a6871b), UINT64_C(0x1f430a0f1cad8745)
    },
    {   UINT64_C(0x00000000000060c9), UINT64_C(0x1f4307ce60a7273f), UINT64_C(0x1f43144f88abc726),
        UINT64_C(0x1f43104e88ae6729), UINT64_C(0x1f43160ee0a8871e)
    },
    {   UINT64_C(0x00000000000060ca), UINT64_C(0x1f430e4e84b3072a), UINT64_C(0x1f42fa4f14a4a72d),
        UINT64_C(0x1f43114f2caec72a), UINT64_C(0x1f43188f64ade72d)
    },
    {   UINT64_C(0x0000000000008814), UINT64_C(0x18b2fbcf009a669b), UINT64_C(0x0faaff0cf474a68c),
        UINT64_C(0x0ebafb8c8072a6aa), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008815), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x163300d5e48de68e)
    },
    {   UINT64_C(0x00000000000060cd), UINT64_C(0x1f430e0f00a96733), UINT64_C(0x1f43060e34aae730),
        UINT64_C(0x1f43054e9cbac74b), UINT64_C(0x1f43028e74b12731)
    },
    {   UINT64_C(0x0000000000008817), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ee0fa03e83e8)
    },
    {   UINT64_C(0x00000000000060cf), UINT64_C(0x1f4315ce38a7072d), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4306cf7cb60721)
    },
    {   UINT64_C(0x00000000000060d0), UINT64_C(0x1f43140e14ab674d), UINT64_C(0x1f430d4f6cad671c),
        UINT64_C(0x1f4308ceb4b38733), UINT64_C(0x1f42fd4f58b6a728)
    },
    {   UINT64_C(0x00000000000060d1), UINT64_C(0x1f43168ed8a5c726), UINT64_C(0x1f43014ee0b44735),
        UINT64_C(0x1f4303ce74a9c717), UINT64_C(0x1f43044e44ab272a)
    },
    {   UINT64_C(0x00000000000060d2), UINT64_C(0x1f43078e5cad6726), UINT64_C(0x1f43038e1cb2c73e),
        UINT64_C(0x1f43088f04a72719), UINT64_C(0x1f43178f0ca70724)
    },
    {   UINT64_C(0x00000000000060d3), UINT64_C(0x1f43150eacaee735), UINT64_C(0x1f430b8f28b10721),
        UINT64_C(0x1f43144ec0ac4726), UINT64_C(0x1f42fe4f18af8738)
    },
    {   UINT64_C(0x00000000000060d4), UINT64_C(0x1f42fece38b22741), UINT64_C(0x1f4311cef4ad6733),
        UINT64_C(0x1f43098ee4b52731), UINT64_C(0x1f43150e9cae0729)
    },
    {   UINT64_C(0x00000000000060d5), UINT64_C(0x1f43050f1ca8c732), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43068f08b2e732), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000060d6), UINT64_C(0x1f43008ef4b2273c), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430e8f50ab072f), UINT64_C(0x1f43148f14ae871e)
    },
    {   UINT64_C(0x00000000000060d7), UINT64_C(0x1f430b8eacaec735), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430b8e6cb3e731), UINT64_C(0x1f43050f50b5e715)
    },
    {   UINT64_C(0x00000000000060d8), UINT64_C(0x1f4310cee8b5472a), UINT64_C(0x1f4311cf18a78722),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43134f18acc715)
    },
    {   UINT64_C(0x00000000000060d9), UINT64_C(0x1f430f8e8caae724), UINT64_C(0x1f43108eacb1c719),
        UINT64_C(0x1f43128ef8ada72a), UINT64_C(0x1f43148f44ab072a)
    },
    {   UINT64_C(0x00000000000060da), UINT64_C(0x1f43114e98ac673b), UINT64_C(0x1f43088f44b30721),
        UINT64_C(0x1f4302cf24ac8712), UINT64_C(0x1f43148ee8a80725)
    },
    {   UINT64_C(0x00000000000060db), UINT64_C(0x1f430b8ef0ac6719), UINT64_C(0x1f43148f7cae670b),
        UINT64_C(0x1f430f4eccae8719), UINT64_C(0x1f43168eeca90726)
    },
    {   UINT64_C(0x00000000000060dc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43134f7ca7e72a)
    },
    {   UINT64_C(0x00000000000060dd), UINT64_C(0x1f43028f08af671e), UINT64_C(0x1f430fcefcaa0726),
        UINT64_C(0x1f42fe8f0cb80711), UINT64_C(0x1f42fa0e54b16737)
    },
    {   UINT64_C(0x00000000000060de), UINT64_C(0x1f43120e44aaa746), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430b4ef4aa0727), UINT64_C(0x1f42fc8ebcb5c725)
    },
    {   UINT64_C(0x0000000000008828), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1162f0cfa082c67e)
    },
    {   UINT64_C(0x0000000000008829), UINT64_C(0x0fa2f10f807bc68c), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x24f2f20f78cd267e)
    },
    {   UINT64_C(0x00000000000060e1), UINT64_C(0x0000000000000000), UINT64_C(0x1f43090f54aae713),
        UINT64_C(0x1f43024e70b54746), UINT64_C(0x1f43038f7ca78726)
    },
    {   UINT64_C(0x00000000000060e2), UINT64_C(0x1f430d4ea8b1272f), UINT64_C(0x1f42fd0e44a8073e),
        UINT64_C(0x1f43064eacafa73c), UINT64_C(0x1f43014e6ca8072b)
    },
    {   UINT64_C(0x00000000000060e3), UINT64_C(0x1f431c0e84b04720), UINT64_C(0x1f43198e64b2472b),
        UINT64_C(0x1f43180e6cafa73a), UINT64_C(0x1f4302cf14ac2731)
    },
    {   UINT64_C(0x00000000000060e4), UINT64_C(0x1f430f4f20ac2721), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430d0f0caae735), UINT64_C(0x1f42f9ce6cb7a73f)
    },
    {   UINT64_C(0x00000000000060e5), UINT64_C(0x1f43188e80a30724), UINT64_C(0x1f4306ce44b1e716),
        UINT64_C(0x1f43064ef0b00729), UINT64_C(0x1f43114eaca9e732)
    },
    {   UINT64_C(0x00000000000060e6), UINT64_C(0x1f43074e6cb2e73a), UINT64_C(0x1f43088eecb24734),
        UINT64_C(0x1f43088f28aae72e), UINT64_C(0x1f43074f00ae6738)
    },
    {   UINT64_C(0x00000000000060e7), UINT64_C(0x1f43080f64b1071e), UINT64_C(0x1f43170f70a6871e),
        UINT64_C(0x1f43144ee8b2a738), UINT64_C(0x1f42f90e28b6072d)
    },
    {   UINT64_C(0x00000000000060e8), UINT64_C(0x1f43094ec8b2a73c), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43124ee4af6735), UINT64_C(0x1f43144f34ade728)
    },
    {   UINT64_C(0x00000000000060e9), UINT64_C(0x1f43150e80a30724), UINT64_C(0x1f42ff8ed0b1e726),
        UINT64_C(0x1f43150e70a2c72e), UINT64_C(0x1f430f8e6cb58749)
    },
    {   UINT64_C(0x00000000000060ea), UINT64_C(0x1f43130f00ace732), UINT64_C(0x1f43078e80aec73b),
        UINT64_C(0x1f430a8e6cac672d), UINT64_C(0x1f43038ea4afe734)
    },
    {   UINT64_C(0x0000000000008834), UINT64_C(0x00027cd96c3c66e0), UINT64_C(0x00027cd96c3c66e0),
        UINT64_C(0x0002b18d3026867e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000060ec), UINT64_C(0x1f43074f38aee722), UINT64_C(0x1f430e8ea4ac072f),
        UINT64_C(0x1f43038f18abe726), UINT64_C(0x1f431d4f04ace715)
    },
    {   UINT64_C(0x00000000000060ed), UINT64_C(0x1f43188eb4a4c72a), UINT64_C(0x1f43090ea0ae0735),
        UINT64_C(0x1f4305cf74b7070e), UINT64_C(0x1f430d4ef4b4472c)
    },
    {   UINT64_C(0x00000000000060ee), UINT64_C(0x1f42fd8ef8b18719), UINT64_C(0x1f43158f70ac072a),
        UINT64_C(0x1f43118e78aa272a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000060ef), UINT64_C(0x1f43094f48b4271b), UINT64_C(0x1f42fdce50b8073f),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd4e4ca9e73e)
    },
    {   UINT64_C(0x00000000000060f0), UINT64_C(0x1f430f4f30ae472c), UINT64_C(0x1f4302ce94afe739),
        UINT64_C(0x1f43110ec8a8671d), UINT64_C(0x1f43100f10a7a726)
    },
    {   UINT64_C(0x000000000000883a), UINT64_C(0x00027a8c3842e371), UINT64_C(0x0002761808452691),
        UINT64_C(0x00024990fc4d458b), UINT64_C(0x00027e0c3c56a6dc)
    },
    {   UINT64_C(0x00000000000060f2), UINT64_C(0x1f43030f08aee729), UINT64_C(0x1f4316cef4ae6726),
        UINT64_C(0x1f43088e48aa6743), UINT64_C(0x1f4308cef8b0e739)
    },
    {   UINT64_C(0x000000000000883c), UINT64_C(0x000294d7b433a71b), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000060f4), UINT64_C(0x0000000000000000), UINT64_C(0x1f43144e74a90732),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43060ef8af8740)
    },
    {   UINT64_C(0x00000000000060f5), UINT64_C(0x1f43080eb0b5e738), UINT64_C(0x1f43044eacb68727),
        UINT64_C(0x1f430fcea4a5072c), UINT64_C(0x1f43080e8cab671b)
    },
    {   UINT64_C(0x00000000000060f6), UINT64_C(0x1f42fcceacb56727), UINT64_C(0x1f43098ea0b3672d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43130e40a7872a)
    },
    {   UINT64_C(0x0000000000008840), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x160af94f6891668c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000060f8), UINT64_C(0x1f430b0f10b3e741), UINT64_C(0x1f430e0eb8a7a728),
        UINT64_C(0x1f43060e9caf8717), UINT64_C(0x1f4311cf7cb5c721)
    },
    {   UINT64_C(0x00000000000060f9), UINT64_C(0x1f4306cedcb2e72b), UINT64_C(0x1f43028ee8a86729),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43070f3ca8072e)
    },
    {   UINT64_C(0x0000000000008843), UINT64_C(0x19c2f8cc709f269f), UINT64_C(0x1672ff8fa08f867e),
        UINT64_C(0x120af9cf7882a693), UINT64_C(0x121af9cf7882e693)
    },
    {   UINT64_C(0x00000000000060fb), UINT64_C(0x1f4312cf0ca4a71e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43054e50aa873e), UINT64_C(0x1f42fdce6cb3c74c)
    },
    {   UINT64_C(0x00000000000060fc), UINT64_C(0x1f42fe0ef0b78732), UINT64_C(0x1f430dce50b54744),
        UINT64_C(0x1f43084e9caf8740), UINT64_C(0x1f43080f5cb2a712)
    },
    {   UINT64_C(0x0000000000008846), UINT64_C(0x19d2fb0c3ca2660b), UINT64_C(0x1532ff8fa08d067e),
        UINT64_C(0x17eaf94e9c97e68c), UINT64_C(0x1d82f68f64ac0697)
    },
    {   UINT64_C(0x0000000000008847), UINT64_C(0x1b52fa8f48a626a8), UINT64_C(0x175aff8fa097867e),
        UINT64_C(0x1862ff4e0c9de683), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008848), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1ea2f593a0b6267e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008849), UINT64_C(0x16bafa8fa093267e), UINT64_C(0x0d42f6cc386f667e),
        UINT64_C(0x1742f54fa097e68c), UINT64_C(0x1742f54f6897e67e)
    },
    {   UINT64_C(0x000000000000884a), UINT64_C(0x16b2fa8c7093069f), UINT64_C(0x0b42f60fa06105b7),
        UINT64_C(0x0000000000000000), UINT64_C(0x1692f1cfa096e74f)
    },
    {   UINT64_C(0x0000000000006102), UINT64_C(0x0000000000000000), UINT64_C(0x1f43090f40b2c724),
        UINT64_C(0x1f4311ce8cb34741), UINT64_C(0x1f42fcce70b4a747)
    },
    {   UINT64_C(0x000000000000884c), UINT64_C(0x1773070f649a4697), UINT64_C(0x1cbaf8cfa0afe690),
        UINT64_C(0x10baf14fa078467e), UINT64_C(0x2182f78f64c2868a)
    },
    {   UINT64_C(0x0000000000006104), UINT64_C(0x1f4310ce98aaa72d), UINT64_C(0x1f43070e7ca98728),
        UINT64_C(0x1f43188e74b0e73a), UINT64_C(0x1f43100ea4ad6726)
    },
    {   UINT64_C(0x000000000000884e), UINT64_C(0x12bafb0f547c668d), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000884f), UINT64_C(0x150af44f708f25aa), UINT64_C(0x10e2ee0c388045b4),
        UINT64_C(0x0eaaff8fa085667e), UINT64_C(0x1672ff8fa08f867e)
    },
    {   UINT64_C(0x0000000000006107), UINT64_C(0x1f43130ecca82721), UINT64_C(0x1f430fcea0ad4725),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008851), UINT64_C(0x13b2f34fa08aa67e), UINT64_C(0x164af24fa0966675),
        UINT64_C(0x122af80f748dc693), UINT64_C(0x101af80f747b25a1)
    },
    {   UINT64_C(0x0000000000008852), UINT64_C(0x092af4cfa069c675), UINT64_C(0x0aaad40c3c6fc675),
        UINT64_C(0x14c2f94fa089c69c), UINT64_C(0x1852f50f6c9a868c)
    },
    {   UINT64_C(0x000000000000610a), UINT64_C(0x1f4315cef4ac672a), UINT64_C(0x1f43018f08b44734),
        UINT64_C(0x1f42fd0e3cb4072d), UINT64_C(0x1f430e8e38b48738)
    },
    {   UINT64_C(0x0000000000008854), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1772f70f6899268c)
    },
    {   UINT64_C(0x0000000000008855), UINT64_C(0x1772f18f6899e68c), UINT64_C(0x1772f74f6897e68c),
        UINT64_C(0x1772f18f6898868c), UINT64_C(0x1772f14f6898868c)
    },
    {   UINT64_C(0x0000000000008856), UINT64_C(0x1772f18f6898868c), UINT64_C(0x1772f74f6898268c),
        UINT64_C(0x1772f54f6498c68c), UINT64_C(0x1772f74f6898c68c)
    },
    {   UINT64_C(0x0000000000008857), UINT64_C(0x1772f14f6899668c), UINT64_C(0x1772f54f6899668c),
        UINT64_C(0x1772f50f6899668c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000610f), UINT64_C(0x1f4300ce30b0e746), UINT64_C(0x1f430bcee0b4a731),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430ecebcafe732)
    },
    {   UINT64_C(0x0000000000006110), UINT64_C(0x1f4301ced0b06733), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43050e14b3e734), UINT64_C(0x1f43108e5cabc737)
    },
    {   UINT64_C(0x0000000000006111), UINT64_C(0x1f43070ebcabe733), UINT64_C(0x1f43000ee8b52733),
        UINT64_C(0x1f42fb0e5cb4c74e), UINT64_C(0x1f43140e40ad872c)
    },
    {   UINT64_C(0x0000000000006112), UINT64_C(0x0000000000000000), UINT64_C(0x1f43064e6cb2e743),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430c0eecade733)
    },
    {   UINT64_C(0x0000000000006113), UINT64_C(0x1f43004e48b2472d), UINT64_C(0x1f4312ce94a5a736),
        UINT64_C(0x1f43014e4cafe745), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006114), UINT64_C(0x1f4319cf08afe72b), UINT64_C(0x1f4305ce5cb26743),
        UINT64_C(0x1f430a4e7cb44735), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006115), UINT64_C(0x1f43060efcb06732), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4317cf64a8c72d), UINT64_C(0x1f4300cea0b3c741)
    },
    {   UINT64_C(0x0000000000006116), UINT64_C(0x0000000000000000), UINT64_C(0x1f430b0e9caaa72b),
        UINT64_C(0x1f43144e74aee734), UINT64_C(0x1f4317ce94a9073c)
    },
    {   UINT64_C(0x0000000000006117), UINT64_C(0x1f430f8f00ae6722), UINT64_C(0x1f430f8f08ac0731),
        UINT64_C(0x1f430cce3cb5673c), UINT64_C(0x1f43120e70b0c734)
    },
    {   UINT64_C(0x0000000000006118), UINT64_C(0x1f4303cf04afc735), UINT64_C(0x1f430fce4ca88749),
        UINT64_C(0x1f42fece50b32737), UINT64_C(0x1f43070ea0b0a74e)
    },
    {   UINT64_C(0x0000000000006119), UINT64_C(0x0000000000000000), UINT64_C(0x1f43110e34ad0731),
        UINT64_C(0x1f43088e5cb24741), UINT64_C(0x1f43148e94af872c)
    },
    {   UINT64_C(0x000000000000611a), UINT64_C(0x1f430d4e3cb1e72d), UINT64_C(0x1f430e8ef8b5c71d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43104e68aa8735)
    },
    {   UINT64_C(0x0000000000008864), UINT64_C(0x1cf2ffd088a9a5a9), UINT64_C(0x0ffafd0d3076e67e),
        UINT64_C(0x1cf2ff9084a985a8), UINT64_C(0x0ffafd0d3076e67e)
    },
    {   UINT64_C(0x0000000000008865), UINT64_C(0x1cf2f79084ad85a9), UINT64_C(0x0ffafd0c2076e6c2),
        UINT64_C(0x1cf2ff8d30a9867e), UINT64_C(0x1cf2ff8d30a9867e)
    },
    {   UINT64_C(0x0000000000008866), UINT64_C(0x1cf2ff8d30a9867e), UINT64_C(0x1cf2ff8d30a9867e),
        UINT64_C(0x1cf2fd1088aac5aa), UINT64_C(0x1cf2fd1088aac5aa)
    },
    {   UINT64_C(0x0000000000008867), UINT64_C(0x1cf2ff9138a98583), UINT64_C(0x1cf2ff9138a98583),
        UINT64_C(0x1cf2ff9088a985a9), UINT64_C(0x0ffafd0d3876e67e)
    },
    {   UINT64_C(0x0000000000008868), UINT64_C(0x1cf2ff9088a985a9), UINT64_C(0x0ffafd0d3876e67e),
        UINT64_C(0x1cf2ff9088a985a9), UINT64_C(0x1cf2ff9088a985a9)
    },
    {   UINT64_C(0x0000000000008869), UINT64_C(0x1cf2ff9084a9a5aa), UINT64_C(0x0ffafd0d3876e67e),
        UINT64_C(0x1cf2ff9084a9a5aa), UINT64_C(0x0ffafccd3876e67e)
    },
    {   UINT64_C(0x000000000000886a), UINT64_C(0x0ffafccd3876e67e), UINT64_C(0x1cf2ff9084a98611),
        UINT64_C(0x1cf2ff9084a98611), UINT64_C(0x1cf2ff8fa0a98611)
    },
    {   UINT64_C(0x000000000000886b), UINT64_C(0x1cf2ff8fa0a98611), UINT64_C(0x2582fa5088ce65a9),
        UINT64_C(0x1cf2f79088ad85aa), UINT64_C(0x0ffafd0d3876e67e)
    },
    {   UINT64_C(0x000000000000886c), UINT64_C(0x0e7af58d3073867e), UINT64_C(0x0e7af7cd3074a67e),
        UINT64_C(0x0e7af44d3872e67e), UINT64_C(0x0e7af7cd3874a67e)
    },
    {   UINT64_C(0x0000000000006124), UINT64_C(0x1f430fce40b40741), UINT64_C(0x1f43030ec8b0273c),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000886e), UINT64_C(0x1cf2fbcd30ab86c4), UINT64_C(0x1cf2fd0e30aac63e),
        UINT64_C(0x1e730b0dd0a9c696), UINT64_C(0x1e730b0dd0a9c696)
    },
    {   UINT64_C(0x0000000000006126), UINT64_C(0x1f430c8e20afe747), UINT64_C(0x1f43138e68b4c73a),
        UINT64_C(0x1f43120e28a9e73c), UINT64_C(0x1f42fecf34b3c738)
    },
    {   UINT64_C(0x0000000000006127), UINT64_C(0x1f42fecf10ae672f), UINT64_C(0x1f43044ecca6472b),
        UINT64_C(0x1f430a8eccb1473f), UINT64_C(0x1f43054f04a9673a)
    },
    {   UINT64_C(0x0000000000006128), UINT64_C(0x1f43110f14ac073f), UINT64_C(0x1f43100e10ae473b),
        UINT64_C(0x1f43138edcb6a739), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008872), UINT64_C(0x182af84d309a067e), UINT64_C(0x1cf2ff8e30a9863f),
        UINT64_C(0x182af84d309a067e), UINT64_C(0x1cf2ff8f1ca98603)
    },
    {   UINT64_C(0x0000000000008873), UINT64_C(0x1cf2ff8f1ca98603), UINT64_C(0x1cf2fd0eecaac60f),
        UINT64_C(0x1cf2f30f78afc5ed), UINT64_C(0x1cf2fd0eecaac60f)
    },
    {   UINT64_C(0x0000000000008874), UINT64_C(0x1cf2fd0eecaac60f), UINT64_C(0x156af94d308ea67e),
        UINT64_C(0x1cf2fd0eecaac60f), UINT64_C(0x156af94d308ea67e)
    },
    {   UINT64_C(0x0000000000008875), UINT64_C(0x1cf2f30f78afc5ed), UINT64_C(0x156af94c208ea6c2),
        UINT64_C(0x1cf2fbcd30abc67e), UINT64_C(0x1cf2fbcd30abc67e)
    },
    {   UINT64_C(0x0000000000008876), UINT64_C(0x1cf2fbcd30abc67e), UINT64_C(0x1cf2fbcd30abc67e),
        UINT64_C(0x1cf2f98d74a9066c), UINT64_C(0x1cf3008d78ac866d)
    },
    {   UINT64_C(0x0000000000008877), UINT64_C(0x1cf2fd1088aac5a9), UINT64_C(0x1cf2fd1088aac5a9),
        UINT64_C(0x0ffafd0d3076e67e), UINT64_C(0x0ffafd0d3076e67e)
    },
    {   UINT64_C(0x0000000000008878), UINT64_C(0x1cf2fd1088aac5a9), UINT64_C(0x0ffafd0d3076e67e),
        UINT64_C(0x1cf2fd1088aac5a9), UINT64_C(0x0ffafd0d3076e67e)
    },
    {   UINT64_C(0x0000000000006130), UINT64_C(0x1f42ff0eb8ad873f), UINT64_C(0x1f43070e4cb6c747),
        UINT64_C(0x1f43144eb4ad673a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000887a), UINT64_C(0x1cf2fd0eecaac60f), UINT64_C(0x156af94d308ea67e),
        UINT64_C(0x156af94cc08ea69a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006132), UINT64_C(0x0000000000000000), UINT64_C(0x1f43054e50b6a745),
        UINT64_C(0x1f4307ce3cb7673f), UINT64_C(0x1f43048edcb2472d)
    },
    {   UINT64_C(0x0000000000006133), UINT64_C(0x1f4312ce44af2738), UINT64_C(0x1f4304cdf8b0674b),
        UINT64_C(0x1f43018e60ad072d), UINT64_C(0x1f42ff4f50b9073b)
    },
    {   UINT64_C(0x000000000000887d), UINT64_C(0x1cf2ff9084a985a8), UINT64_C(0x182af5cd309b467e),
        UINT64_C(0x1cf2fd0c00aac6cb), UINT64_C(0x1cf2fd1088aac5aa)
    },
    {   UINT64_C(0x000000000000887e), UINT64_C(0x1cf2fbd088aa25aa), UINT64_C(0x1cf2fa1088ac45aa),
        UINT64_C(0x1cf2fd1088aac5aa), UINT64_C(0x1cf2fd1088aac5aa)
    },
    {   UINT64_C(0x000000000000887f), UINT64_C(0x1cf2f79088ad85aa), UINT64_C(0x1cf2fd1084aac5a9),
        UINT64_C(0x1cf2fd1084aac5a9), UINT64_C(0x1cf2f31084afc5a9)
    },
    {   UINT64_C(0x0000000000008880), UINT64_C(0x1182ee8fa084467e), UINT64_C(0x0e7afccf647106e0),
        UINT64_C(0x0ebaf80f74796684), UINT64_C(0x1183004fa07b667e)
    },
    {   UINT64_C(0x0000000000008881), UINT64_C(0x1182ffcdb87b66ef), UINT64_C(0x17d2fa8e6497862f),
        UINT64_C(0x16dafdcfa091a68a), UINT64_C(0x16dafdcf7091e67e)
    },
    {   UINT64_C(0x0000000000008882), UINT64_C(0x156afd0f348ca5fb), UINT64_C(0x156afd0d2c8ca67e),
        UINT64_C(0x0f32fe10547345b3), UINT64_C(0x156afd0f348ca5fb)
    },
    {   UINT64_C(0x0000000000008883), UINT64_C(0x156afd0d2c8ca67e), UINT64_C(0x0f32fe10547345b3),
        UINT64_C(0x110afd0fa07b2668), UINT64_C(0x1f42fb0b94b506e3)
    },
    {   UINT64_C(0x0000000000008884), UINT64_C(0x1f42fb0b94b506e3), UINT64_C(0x1c92fc8b94a986e3),
        UINT64_C(0x156afe13108c2506), UINT64_C(0x156afa0e448e25de)
    },
    {   UINT64_C(0x0000000000008885), UINT64_C(0x156afa0efc8e06cd), UINT64_C(0x105af98c287a46ae),
        UINT64_C(0x0d62f4511470e583), UINT64_C(0x105afed02477a5bf)
    },
    {   UINT64_C(0x0000000000008886), UINT64_C(0x0af2f8117465456b), UINT64_C(0x0af2f8117465456b),
        UINT64_C(0x1d030a0b94b6e7b5), UINT64_C(0x1d030a0b94b6e7b5)
    },
    {   UINT64_C(0x0000000000008887), UINT64_C(0x1d030a0b94b6e7b5), UINT64_C(0x156af84fa08ee596),
        UINT64_C(0x1cf2ff8fa0a94596), UINT64_C(0x156afa8fa08dc630)
    },
    {   UINT64_C(0x0000000000008888), UINT64_C(0x156af3cfa08ee60b), UINT64_C(0x156af38e808ec60b),
        UINT64_C(0x156afc0f749025ef), UINT64_C(0x0853070cac53469a)
    },
    {   UINT64_C(0x0000000000006140), UINT64_C(0x1f43078eb8ab8734), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43160ea8a6a71e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000888a), UINT64_C(0x1362f5cf2c882600), UINT64_C(0x1362fa0f24860600),
        UINT64_C(0x1362fa0f24860600), UINT64_C(0x0e5af60aa08e6720)
    },
    {   UINT64_C(0x000000000000888b), UINT64_C(0x15eaf60aa0aca720), UINT64_C(0x1d7af60aa0cae720),
        UINT64_C(0x0f9af60aa08e6720), UINT64_C(0x172af60aa0aca720)
    },
    {   UINT64_C(0x000000000000888c), UINT64_C(0x1eb2f60aa0cac720), UINT64_C(0x0f9af60aa08e6720),
        UINT64_C(0x0f9af60aa08e6720), UINT64_C(0x0f9af60aa08e6720)
    },
    {   UINT64_C(0x0000000000006144), UINT64_C(0x0000000000000000), UINT64_C(0x1f4303cea4ab4737),
        UINT64_C(0x1f43154f18ac6722), UINT64_C(0x1f4316ce5cabe72d)
    },
    {   UINT64_C(0x0000000000006145), UINT64_C(0x1f43158e78a7873a), UINT64_C(0x1f43108e6caaa73f),
        UINT64_C(0x1f43090efca8e729), UINT64_C(0x1f43034f1caf273c)
    },
    {   UINT64_C(0x000000000000888f), UINT64_C(0x156afa11f08e2552), UINT64_C(0x156afa11f08e2552),
        UINT64_C(0x156afa11088e2585), UINT64_C(0x156afa503c8e25bb)
    },
    {   UINT64_C(0x0000000000006147), UINT64_C(0x1f430ccec4b6a727), UINT64_C(0x1f4314ce7cb4472b),
        UINT64_C(0x1f430acefcb10734), UINT64_C(0x1f43094f50ad672f)
    },
    {   UINT64_C(0x0000000000008891), UINT64_C(0x156afa0f148e25ef), UINT64_C(0x156afa0f348e25fc),
        UINT64_C(0x156af9cdf48e2644), UINT64_C(0x156afa0c788e266f)
    },
    {   UINT64_C(0x0000000000008892), UINT64_C(0x156afa10048e25c3), UINT64_C(0x156afa0edc8e260d),
        UINT64_C(0x156afa0eec8e2610), UINT64_C(0x156afa0f388e45fc)
    },
    {   UINT64_C(0x0000000000008893), UINT64_C(0x156afa0f348e25fc), UINT64_C(0x156afa0fc08e25da),
        UINT64_C(0x156afa102c8e25bf), UINT64_C(0x156afa11808e25bf)
    },
    {   UINT64_C(0x0000000000008894), UINT64_C(0x156afa11808e264b), UINT64_C(0x156afa0df88e264b),
        UINT64_C(0x156afa0dfc8e264b), UINT64_C(0x156afa0df88e264b)
    },
    {   UINT64_C(0x0000000000008895), UINT64_C(0x19c2fa11049f8589), UINT64_C(0x19c2fa11049f8589),
        UINT64_C(0x156afa11088e2588), UINT64_C(0x156afa11808e26d8)
    },
    {   UINT64_C(0x0000000000008896), UINT64_C(0x156afa11808e26c1), UINT64_C(0x156afa11808e273d),
        UINT64_C(0x156afa11808e273d), UINT64_C(0x156afa11808e26dc)
    },
    {   UINT64_C(0x0000000000008897), UINT64_C(0x156afa11808e273d), UINT64_C(0x156aefd18093471f),
        UINT64_C(0x156afa11808e26a7), UINT64_C(0x156afa11808e2747)
    },
    {   UINT64_C(0x0000000000008898), UINT64_C(0x156afa0d308e267e), UINT64_C(0x156afa10108e25c6),
        UINT64_C(0x156afa0d308e267e), UINT64_C(0x156afa0f088e2608)
    },
    {   UINT64_C(0x0000000000008899), UINT64_C(0x156afe0e048d2649), UINT64_C(0x156afe0e048d2649),
        UINT64_C(0x156afc4c548c46b6), UINT64_C(0x156afc4c548c46b6)
    },
    {   UINT64_C(0x000000000000889a), UINT64_C(0x156afc0b908c26d2), UINT64_C(0x156afc0b908c26d2),
        UINT64_C(0x1d2af44f38b005fc), UINT64_C(0x1d2af44f38b005fc)
    },
    {   UINT64_C(0x000000000000889b), UINT64_C(0x0e93034c206e26c2), UINT64_C(0x156afa0e988e2624),
        UINT64_C(0x156afc0d308c267e), UINT64_C(0x156afc0d308c267e)
    },
    {   UINT64_C(0x000000000000889c), UINT64_C(0x156afc0c0c8c26c2), UINT64_C(0x156afc0c0c8c46c2),
        UINT64_C(0x156afa0d108e2680), UINT64_C(0x156afa0d108e2680)
    },
    {   UINT64_C(0x0000000000006154), UINT64_C(0x0000000000000000), UINT64_C(0x1f43180eb4a6273f),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4317cf10a7c73c)
    },
    {   UINT64_C(0x0000000000006155), UINT64_C(0x1f43064f08b7a730), UINT64_C(0x1f43018f00a82730),
        UINT64_C(0x1f430e4e4cb0874a), UINT64_C(0x1f43038f1cb5e724)
    },
    {   UINT64_C(0x0000000000006156), UINT64_C(0x1f430a0e90b3a745), UINT64_C(0x1f430e0ec8b1e748),
        UINT64_C(0x1f42ff8de4b2c74a), UINT64_C(0x1f4301ceacaec730)
    },
    {   UINT64_C(0x0000000000006157), UINT64_C(0x0000000000000000), UINT64_C(0x1f43120ef4b1c730),
        UINT64_C(0x1f430ccebcaec73a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000088a1), UINT64_C(0x156afe4d308c667e), UINT64_C(0x156afe4d308c667e),
        UINT64_C(0x156afe0e048c2647), UINT64_C(0x156afe0e048c2647)
    },
    {   UINT64_C(0x00000000000088a2), UINT64_C(0x156afe0c0c8c26c2), UINT64_C(0x156afe0c0c8c26c2),
        UINT64_C(0x156afe0c408c265b), UINT64_C(0x156afe0c408c265b)
    },
    {   UINT64_C(0x00000000000088a3), UINT64_C(0x1362fa0f24860600), UINT64_C(0x1362fa0f24860600),
        UINT64_C(0x1362fa0f24860600), UINT64_C(0x156afe0f3c8c25fb)
    },
    {   UINT64_C(0x00000000000088a4), UINT64_C(0x156afe0f3c8c25fb), UINT64_C(0x156afe0e048c2647),
        UINT64_C(0x156afe0e048c2647), UINT64_C(0x1362fa0f24860600)
    },
    {   UINT64_C(0x00000000000088a5), UINT64_C(0x1362fa0f24860600), UINT64_C(0x1a52fa8dc4a18657),
        UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x1a52fa8dc4a18657)
    },
    {   UINT64_C(0x00000000000088a6), UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x17d2fa8e6497862f),
        UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x1a52fa8dc4a18657)
    },
    {   UINT64_C(0x00000000000088a7), UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x1a52fa8dc4a18657),
        UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x1c72f94d28aaa67e)
    },
    {   UINT64_C(0x00000000000088a8), UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x1c72f94d2caaa67e),
        UINT64_C(0x156afe0fa08c267e), UINT64_C(0x156afe0fa08c267e)
    },
    {   UINT64_C(0x0000000000006160), UINT64_C(0x1f43114f54b3272d), UINT64_C(0x1f430b8ef4af272c),
        UINT64_C(0x1f43098ef4b3c73f), UINT64_C(0x1f430e8f1ca8872d)
    },
    {   UINT64_C(0x00000000000088aa), UINT64_C(0x156afe0fa08c267e), UINT64_C(0x1ae2fc4fa0a4467e),
        UINT64_C(0x1ae2f94fa0a4667e), UINT64_C(0x1ae2fc4fa0a4467e)
    },
    {   UINT64_C(0x00000000000088ab), UINT64_C(0x1892f04fa098e67e), UINT64_C(0x1892f04fa098e67e),
        UINT64_C(0x1e42f04fa0b1c67e), UINT64_C(0x1e42f04fa0b1c67e)
    },
    {   UINT64_C(0x00000000000088ac), UINT64_C(0x156afe0eec8c260f), UINT64_C(0x156afe0eec8c260f),
        UINT64_C(0x156af40f3c8d65fb), UINT64_C(0x156afb8f3c9125fb)
    },
    {   UINT64_C(0x00000000000088ad), UINT64_C(0x156af40e048d6647), UINT64_C(0x156afb8e04912647),
        UINT64_C(0x23cafa913cc7657b), UINT64_C(0x23cafa913cc7657b)
    },
    {   UINT64_C(0x00000000000088ae), UINT64_C(0x1a8afa913ca2657b), UINT64_C(0x156afa0efc8e060b),
        UINT64_C(0x0f03008c507145aa), UINT64_C(0x1362f60d74884600)
    },
    {   UINT64_C(0x00000000000088af), UINT64_C(0x1362f60f2c88466e), UINT64_C(0x1362f60f2c88466e),
        UINT64_C(0x156afa8fa08dc630), UINT64_C(0x1c7af94d28aaa67e)
    },
    {   UINT64_C(0x00000000000088b0), UINT64_C(0x1ce2fb8b94ab46e3), UINT64_C(0x1ce2fb8b94ab46e3),
        UINT64_C(0x1ce3058ba8a646f2), UINT64_C(0x1ce3058b80a646e8)
    },
    {   UINT64_C(0x00000000000088b1), UINT64_C(0x105af48fe07ca5d0), UINT64_C(0x08f302d2a457e521),
        UINT64_C(0x15e2f6cf6c91a63d), UINT64_C(0x156afacf088dc609)
    },
    {   UINT64_C(0x00000000000088b2), UINT64_C(0x1952fb8e609d062e), UINT64_C(0x1953054e6098062e),
        UINT64_C(0x1953054e6098062e), UINT64_C(0x1953008e609a862e)
    },
    {   UINT64_C(0x00000000000088b3), UINT64_C(0x1953008e609a862e), UINT64_C(0x156afa107c8e25a5),
        UINT64_C(0x1222f5cf3c8325fc), UINT64_C(0x1222f5cf3c8325fc)
    },
    {   UINT64_C(0x00000000000088b4), UINT64_C(0x156afe0f3c8c25fb), UINT64_C(0x156afe0f3c8c25fb),
        UINT64_C(0x1362fa0f24860600), UINT64_C(0x1362fa0f24860600)
    },
    {   UINT64_C(0x00000000000088b5), UINT64_C(0x1362fa0f2486065f), UINT64_C(0x156afa0cac8e269a),
        UINT64_C(0x156afc0f408c25fe), UINT64_C(0x156afc0f408c25fe)
    },
    {   UINT64_C(0x00000000000088b6), UINT64_C(0x27d2f94f40d825fe), UINT64_C(0x27d2f94f40d825fe),
        UINT64_C(0x156afc0a908c2726), UINT64_C(0x156afc0a908c2726)
    },
    {   UINT64_C(0x00000000000088b7), UINT64_C(0x156afe0e048c2647), UINT64_C(0x156afe0e048c2647),
        UINT64_C(0x156afe0dbc8c265b), UINT64_C(0x156afe0dbc8c265b)
    },
    {   UINT64_C(0x00000000000088b8), UINT64_C(0x156afe0c0c8c26c2), UINT64_C(0x156afe0c0c8c26c2),
        UINT64_C(0x156afe4c0c8c46c2), UINT64_C(0x156afe4c0c8c46c2)
    },
    {   UINT64_C(0x00000000000088b9), UINT64_C(0x156afe0c408c265b), UINT64_C(0x156afe0c408c265b),
        UINT64_C(0x156afa0b448e2685), UINT64_C(0x156afa0b448e2685)
    },
    {   UINT64_C(0x00000000000088ba), UINT64_C(0x156afa0b448e2686), UINT64_C(0x156afa0b448e2686),
        UINT64_C(0x13daf40d3087267e), UINT64_C(0x13dafb8d308ae67e)
    },
    {   UINT64_C(0x00000000000088bb), UINT64_C(0x13daf40c0c8726c2), UINT64_C(0x13dafb8c0c8ae6c2),
        UINT64_C(0x0ffb1e0e00666646), UINT64_C(0x1cf3091294a4c524)
    },
    {   UINT64_C(0x00000000000088bc), UINT64_C(0x1cf31e8f589a05f0), UINT64_C(0x1cf31e8f589a05f0),
        UINT64_C(0x19bafbcf349de5fb), UINT64_C(0x156afd0f348ca5fb)
    },
    {   UINT64_C(0x00000000000088bd), UINT64_C(0x0f32fd90547305b3), UINT64_C(0x156afd0f348ca6b4),
        UINT64_C(0x156afd0f348ca695), UINT64_C(0x0f32fd905473064d)
    },
    {   UINT64_C(0x00000000000088be), UINT64_C(0x156afd0cd08ca5fc), UINT64_C(0x156afd4f348ca5fb),
        UINT64_C(0x19bafbcf349de5fb), UINT64_C(0x156afccf348c85fb)
    },
    {   UINT64_C(0x00000000000088bf), UINT64_C(0x0f32fd90547305b3), UINT64_C(0x156afd4f348cc695),
        UINT64_C(0x0f32fed05473a64d), UINT64_C(0x1c72f94d28aaa67e)
    },
    {   UINT64_C(0x00000000000088c0), UINT64_C(0x12f2f44fd88725cf), UINT64_C(0x0000000000000000),
        UINT64_C(0x1cf2fbcfa0ab66ee), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000088c1), UINT64_C(0x0000000000000000), UINT64_C(0x1362fa0fa0860629),
        UINT64_C(0x1362fa0fa08606c0), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000088c2), UINT64_C(0x0eab1d0c4c7666b1), UINT64_C(0x0eaaf4cc4c6246b1),
        UINT64_C(0x0eab1d0c4c7666b1), UINT64_C(0x0eaaf4cc4c6246b1)
    },
    {   UINT64_C(0x00000000000088c3), UINT64_C(0x0e7afb0c4472048e), UINT64_C(0x0e7afb0c4472048e),
        UINT64_C(0x0e7afb175c720754), UINT64_C(0x0e7afb175c720754)
    },
    {   UINT64_C(0x00000000000088c4), UINT64_C(0x12c2fa116c838571), UINT64_C(0x105b00d0a476a59f),
        UINT64_C(0x17d2fa8fa0978533), UINT64_C(0x17d2fa8fa0978533)
    },
    {   UINT64_C(0x00000000000088c5), UINT64_C(0x0000000000000000), UINT64_C(0x1a7af48caca2062e),
        UINT64_C(0x2262fb4bc8c166d4), UINT64_C(0x2262fb4bccc166d5)
    },
    {   UINT64_C(0x00000000000088c6), UINT64_C(0x1cf2fbcd30ab667e), UINT64_C(0x12c2fa116c838571),
        UINT64_C(0x156afe0e8c8c4687), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000088c7), UINT64_C(0x0e7afad40471e67e), UINT64_C(0x0e7afad40471e67e),
        UINT64_C(0x0e7afacc3c71e48c), UINT64_C(0x0e7afb0c3c72048c)
    },
    {   UINT64_C(0x00000000000088c8), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1fdafb91ecb72550), UINT64_C(0x1fdafb91ecb72550)
    },
    {   UINT64_C(0x0000000000006180), UINT64_C(0x1f43038df0ab4740), UINT64_C(0x1f430e4e2caec737),
        UINT64_C(0x1f43034d94b0e739), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000088ca), UINT64_C(0x0000000000000000), UINT64_C(0x0c83014c4c6866b1),
        UINT64_C(0x0c82fe4c4c66e6b1), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000088cb), UINT64_C(0x1cf302ccb8a7e69c), UINT64_C(0x1ed2fbce40b2e638),
        UINT64_C(0x1382e98d708645aa), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000088cc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1bcb020ec0a3a61a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000088cd), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1cf3034d30a7a6d7), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006185), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43170eecac472b), UINT64_C(0x1f43120e6cb2273a)
    },
    {   UINT64_C(0x00000000000088cf), UINT64_C(0x0000000000000000), UINT64_C(0x1c73030cd4a5c693),
        UINT64_C(0x0000000000000000), UINT64_C(0x155afd0ce08c66a7)
    },
    {   UINT64_C(0x00000000000088d0), UINT64_C(0x155afd0ce08c66a7), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006188), UINT64_C(0x1f430b0e98ad4737), UINT64_C(0x1f430d4e90af472f),
        UINT64_C(0x1f42ff0e5cb4073f), UINT64_C(0x1f43050e74afc72d)
    },
    {   UINT64_C(0x0000000000006189), UINT64_C(0x1f430ace58afc72f), UINT64_C(0x1f43050eccb6c724),
        UINT64_C(0x1f431a8f00aa8722), UINT64_C(0x1f4301ceb4ada73b)
    },
    {   UINT64_C(0x000000000000618a), UINT64_C(0x0000000000000000), UINT64_C(0x1f43044e24b08745),
        UINT64_C(0x1f43090e40a90741), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000088d4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x18d2fbcce09ae6d7)
    },
    {   UINT64_C(0x000000000000618c), UINT64_C(0x1f43028f28b12735), UINT64_C(0x1f4307ce84ab0735),
        UINT64_C(0x1f431a8eb8aa473d), UINT64_C(0x1f42fc4e64b2a73a)
    },
    {   UINT64_C(0x000000000000618d), UINT64_C(0x1f43198e74a9e748), UINT64_C(0x1f42fa8e60b2a732),
        UINT64_C(0x1f430c4f28b5e73c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000618e), UINT64_C(0x1f4312ceacaae739), UINT64_C(0x1f43070e34b8873b),
        UINT64_C(0x1f43078ea8b2473d), UINT64_C(0x1f43080e40b20748)
    },
    {   UINT64_C(0x000000000000618f), UINT64_C(0x1f42ff4e5cacc738), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43040e34b8873b), UINT64_C(0x1f430d4e7caee734)
    },
    {   UINT64_C(0x0000000000006190), UINT64_C(0x1f43058e6cb3073f), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430b8e70afc73f)
    },
    {   UINT64_C(0x0000000000006191), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430dcebca2c741), UINT64_C(0x1f43100e88af473f)
    },
    {   UINT64_C(0x0000000000006192), UINT64_C(0x1f430b4ec4aec731), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430d0e90b2c740)
    },
    {   UINT64_C(0x0000000000006193), UINT64_C(0x1f431a0e88af872d), UINT64_C(0x1f430c0ec8afa701),
        UINT64_C(0x1f42fb0ee8b36731), UINT64_C(0x1f43014eeca5e722)
    },
    {   UINT64_C(0x0000000000006194), UINT64_C(0x1f42fb8eb8ace72b), UINT64_C(0x1f43014f94aca716),
        UINT64_C(0x1f42fa8ed0af471c), UINT64_C(0x1f43014f84b7270e)
    },
    {   UINT64_C(0x0000000000006195), UINT64_C(0x1f43004e50b30737), UINT64_C(0x1f42fb8e78b5c740),
        UINT64_C(0x1f43024e94aa0739), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006196), UINT64_C(0x0000000000000000), UINT64_C(0x1f43050f20a9a729),
        UINT64_C(0x1f43004f44a90731), UINT64_C(0x1f42ff4eb8ac672e)
    },
    {   UINT64_C(0x0000000000006197), UINT64_C(0x1f42ff4e58b24739), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb8e48ae0744), UINT64_C(0x1f42fc4f70b66731)
    },
    {   UINT64_C(0x0000000000006198), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff4ebca8673a),
        UINT64_C(0x1f42fe0f30b8470a), UINT64_C(0x1f42fe4f3cb646e7)
    },
    {   UINT64_C(0x0000000000006199), UINT64_C(0x1f42f84f40b646f9), UINT64_C(0x1f42fa4f30af26fb),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f94ee4b4a731)
    },
    {   UINT64_C(0x000000000000619a), UINT64_C(0x1f42fa8f4cafa712), UINT64_C(0x1f43048f58b6a6fa),
        UINT64_C(0x1f42f74f1cb7e710), UINT64_C(0x1f4314cf8ca466f9)
    },
    {   UINT64_C(0x00000000000088e4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1c8b035180a7a56a)
    },
    {   UINT64_C(0x000000000000619c), UINT64_C(0x1f42fd4f5cb506d2), UINT64_C(0x1f430d8f44b666e5),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd4ea8b046ff)
    },
    {   UINT64_C(0x000000000000fec1), UINT64_C(0x1a0af1cfa0a4069b), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000619e), UINT64_C(0x0000000000000000), UINT64_C(0x1f4304902cb546de),
        UINT64_C(0x1f42f4cf8cb3c719), UINT64_C(0x1f42fd9054b2a6f6)
    },
    {   UINT64_C(0x000000000000619f), UINT64_C(0x1f42fd4f5cb706fe), UINT64_C(0x1f431c0f34a7a6f7),
        UINT64_C(0x1f42fe4f60ac66de), UINT64_C(0x1f43134f24a986ef)
    },
    {   UINT64_C(0x00000000000061a0), UINT64_C(0x1f42fd9020b0e704), UINT64_C(0x1f42fc50dcb786e2),
        UINT64_C(0x1f42fd4f5cae06e1), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000061a1), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f94fccb66701),
        UINT64_C(0x1f42fd5010b6e6d5), UINT64_C(0x1f42fc4fc0b2a6e1)
    },
    {   UINT64_C(0x00000000000061a2), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fe502cb8c6eb), UINT64_C(0x1f42fd4fb0aac6f8)
    },
    {   UINT64_C(0x00000000000061a3), UINT64_C(0x1f42fa0e3cb56734), UINT64_C(0x1f42fb1068b246c2),
        UINT64_C(0x1f43081084ab66ed), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000061a4), UINT64_C(0x1f42fc0ee0ab0706), UINT64_C(0x1f42fd0f9cb48724),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f7ceccaba726)
    },
    {   UINT64_C(0x00000000000061a5), UINT64_C(0x1f43004f70b526e5), UINT64_C(0x1f42fb8ef8b4e702),
        UINT64_C(0x1f42fe4fdcb506d6), UINT64_C(0x1f42ff4f78b246d0)
    },
    {   UINT64_C(0x00000000000061a6), UINT64_C(0x1f4301cf80b026ef), UINT64_C(0x1f42fe4f54b5c711),
        UINT64_C(0x1f42f98e8cae66f9), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000061a7), UINT64_C(0x1f42fe4ed0b6e6f1), UINT64_C(0x1f43005078b1c6c7),
        UINT64_C(0x1f42ff0ef8b64700), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000061a8), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0f40b766e1),
        UINT64_C(0x1f42fb8f48b5c6e0), UINT64_C(0x1f42fbd05cb906f1)
    },
    {   UINT64_C(0x00000000000061a9), UINT64_C(0x1f4309cef4b7e718), UINT64_C(0x1f43030ffcb5a6d3),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc4e60b72712)
    },
    {   UINT64_C(0x00000000000061aa), UINT64_C(0x1f42fe4f90b446f3), UINT64_C(0x1f43078ea4afe70a),
        UINT64_C(0x1f42fd0e5cb5872c), UINT64_C(0x1f42f88f8cb62736)
    },
    {   UINT64_C(0x00000000000061ab), UINT64_C(0x1f42ffcf88b566f9), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa1074b6a6f2)
    },
    {   UINT64_C(0x00000000000061ac), UINT64_C(0x1f42fdcfdcaf26d9), UINT64_C(0x1f42f64e58af072c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe0fbcb1e6e2)
    },
    {   UINT64_C(0x00000000000061ad), UINT64_C(0x1f42fd0eb8b14706), UINT64_C(0x1f42fa4e78b58701),
        UINT64_C(0x1f42fecf68b386e9), UINT64_C(0x1f4301508cb186d9)
    },
    {   UINT64_C(0x00000000000061ae), UINT64_C(0x1f42f9ce5caf46ee), UINT64_C(0x1f42fd4f14b186ec),
        UINT64_C(0x1f42fe0f38b3c709), UINT64_C(0x1f4307ce98af8710)
    },
    {   UINT64_C(0x00000000000061af), UINT64_C(0x1f43050f0cac6703), UINT64_C(0x1f42ff0ff8af86d1),
        UINT64_C(0x1f43004f44b5c724), UINT64_C(0x1f42fe5050ab26f2)
    },
    {   UINT64_C(0x00000000000061b0), UINT64_C(0x1f42fccfd8b4e6eb), UINT64_C(0x1f43020fe8aca6d2),
        UINT64_C(0x1f42fd0fc4b4a702), UINT64_C(0x1f42fc102cabc6f6)
    },
    {   UINT64_C(0x00000000000061b1), UINT64_C(0x1f42f8cf8cb486f4), UINT64_C(0x1f42fd0fb8ad66fd),
        UINT64_C(0x1f42fd108cb646e2), UINT64_C(0x1f42ff0f84b40704)
    },
    {   UINT64_C(0x00000000000061b2), UINT64_C(0x1f43004ff0b34704), UINT64_C(0x1f42f68ec0b72723),
        UINT64_C(0x1f430e4fa4abc705), UINT64_C(0x1f4305cec4b7a71a)
    },
    {   UINT64_C(0x00000000000061b3), UINT64_C(0x1f42fb4f84b426e5), UINT64_C(0x1f43088ef8ae471a),
        UINT64_C(0x1f42fb4fb0ab26f1), UINT64_C(0x1f42fb9030b4c6d1)
    },
    {   UINT64_C(0x00000000000061b4), UINT64_C(0x1f43011078b186e4), UINT64_C(0x1f43030ec8b0e718),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43044e64b00728)
    },
    {   UINT64_C(0x00000000000061b5), UINT64_C(0x1f42fa1038afa6cb), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f9cf60b5a6ef), UINT64_C(0x1f431c0f14a3c740)
    },
    {   UINT64_C(0x00000000000061b6), UINT64_C(0x1f42fb0e7cb24734), UINT64_C(0x1f42fbcff4b5470a),
        UINT64_C(0x1f42fe0f1cad0708), UINT64_C(0x1f42f80e9cb5c722)
    },
    {   UINT64_C(0x00000000000061b7), UINT64_C(0x1f42f94f24b72709), UINT64_C(0x1f42ff4f58b6a6da),
        UINT64_C(0x1f42f50facb426e5), UINT64_C(0x1f42fccfacb54700)
    },
    {   UINT64_C(0x00000000000061b8), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff0ee8b2c710), UINT64_C(0x1f42f94f8cad270d)
    },
    {   UINT64_C(0x00000000000061b9), UINT64_C(0x1f42f70f8cb686e0), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fe4f20b3470c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000061ba), UINT64_C(0x1f42ff5008b106c3), UINT64_C(0x1f43080ec8b3e713),
        UINT64_C(0x1f43050e88a6070d), UINT64_C(0x1f42f98f80b3271f)
    },
    {   UINT64_C(0x00000000000061bb), UINT64_C(0x1f42f74e68b5273c), UINT64_C(0x1f42f95044b266d6),
        UINT64_C(0x1f430f4eb4ad6715), UINT64_C(0x1f42fa100cb56711)
    },
    {   UINT64_C(0x00000000000061bc), UINT64_C(0x1f43080ed4aea72a), UINT64_C(0x1f42fd5038b5c703),
        UINT64_C(0x1f42fb4fd8b64704), UINT64_C(0x1f43004fa4af66f2)
    },
    {   UINT64_C(0x00000000000061bd), UINT64_C(0x1f42fb4ef8b566fb), UINT64_C(0x1f42f9cf78b3c6cb),
        UINT64_C(0x1f42fb0edcb186fe), UINT64_C(0x1f42f8cee4b72703)
    },
    {   UINT64_C(0x00000000000061be), UINT64_C(0x1f43000eecae670e), UINT64_C(0x1f42f94f54aa66ed),
        UINT64_C(0x1f42fed010b7a70f), UINT64_C(0x1f42f8cf98b86701)
    },
    {   UINT64_C(0x00000000000061bf), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f98ef4b6c731), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000061c0), UINT64_C(0x1f430f8eb8a90733), UINT64_C(0x1f42fa0f24b686f8),
        UINT64_C(0x1f42f80e4cb90736), UINT64_C(0x1f42fb8ef0b7672a)
    },
    {   UINT64_C(0x00000000000061c1), UINT64_C(0x1f42f74ee8b7e6d3), UINT64_C(0x1f42f94f34af26fe),
        UINT64_C(0x1f42fb0f78b74700), UINT64_C(0x1f43028ea0ab8716)
    },
    {   UINT64_C(0x00000000000061c2), UINT64_C(0x1f43001024b5e6da), UINT64_C(0x1f42fa0ea0b36722),
        UINT64_C(0x1f42facef8ab8700), UINT64_C(0x1f42f74ee8b64725)
    },
    {   UINT64_C(0x00000000000061c3), UINT64_C(0x1f42f8cf60b3c6e8), UINT64_C(0x1f42f64f10b86703),
        UINT64_C(0x1f42fd0ef4a986df), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000061c4), UINT64_C(0x0000000000000000), UINT64_C(0x1f43088f08b4073f),
        UINT64_C(0x1f42f64fe8b706de), UINT64_C(0x1f42f9501cb686da)
    },
    {   UINT64_C(0x00000000000061c5), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cf88b6e705),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff4fccace6de)
    },
    {   UINT64_C(0x00000000000061c6), UINT64_C(0x1f42f88fe0b286d6), UINT64_C(0x1f42f80f0cb9c6f3),
        UINT64_C(0x1f430d8ed0aae73c), UINT64_C(0x1f42f7cf68b106e5)
    },
    {   UINT64_C(0x00000000000061c7), UINT64_C(0x1f43174eb8ac4736), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f6ceecb86713), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000061c8), UINT64_C(0x1f42f94fe8af66de), UINT64_C(0x1f42fb0ef4b4873b),
        UINT64_C(0x1f42fd4fb8b446d9), UINT64_C(0x1f42f8cf14b6c71f)
    },
    {   UINT64_C(0x00000000000061c9), UINT64_C(0x1f43030ec4ada70f), UINT64_C(0x1f42f90e8cb2a70f),
        UINT64_C(0x1f42f68f70b766fc), UINT64_C(0x1f42f80f98b6470e)
    },
    {   UINT64_C(0x00000000000061ca), UINT64_C(0x1f42facf40b7e72a), UINT64_C(0x1f42f58f2cab26fa),
        UINT64_C(0x1f42fe0f24b00717), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000061cb), UINT64_C(0x1f42fad058b3c6ba), UINT64_C(0x1f42fb0f50b346e6),
        UINT64_C(0x1f42fb4f00b4e713), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000061cc), UINT64_C(0x1f430d0eb0a9a71d), UINT64_C(0x1f42f74ea8b1e723),
        UINT64_C(0x1f42f80f4cb7270c), UINT64_C(0x1f42f74ebcb4e731)
    },
    {   UINT64_C(0x00000000000061cd), UINT64_C(0x1f42fa8ef4afc704), UINT64_C(0x1f42f74ef8b12706),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f74efcb84728)
    },
    {   UINT64_C(0x00000000000061ce), UINT64_C(0x1f430e4ec4b286f6), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f50f70b766e9), UINT64_C(0x1f42f88e60b48738)
    },
    {   UINT64_C(0x0000000000008918), UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c),
        UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c)
    },
    {   UINT64_C(0x00000000000061d0), UINT64_C(0x1f42fcce8cb6472a), UINT64_C(0x1f43134ef0ace71f),
        UINT64_C(0x1f42f55010baa6e2), UINT64_C(0x1f42fbcfdcb706e5)
    },
    {   UINT64_C(0x00000000000061d1), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff4ee8af070c), UINT64_C(0x1f42fd0fc4b466e6)
    },
    {   UINT64_C(0x00000000000061d2), UINT64_C(0x1f42fa8fe8aee6fd), UINT64_C(0x1f42fa0eacb46722),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90f60b60718)
    },
    {   UINT64_C(0x00000000000061d3), UINT64_C(0x1f42f70e6cb58720), UINT64_C(0x1f42f84efcb1e6e2),
        UINT64_C(0x1f42f90ef0aec709), UINT64_C(0x1f42f84e7cb7a731)
    },
    {   UINT64_C(0x00000000000061d4), UINT64_C(0x1f42fecee0b0e6bf), UINT64_C(0x1f42fb8e94b686f0),
        UINT64_C(0x1f42fa1058b5e701), UINT64_C(0x1f42f40ea4b84717)
    },
    {   UINT64_C(0x00000000000061d5), UINT64_C(0x1f42fd0f10b566f9), UINT64_C(0x1f42f80facb0e6fb),
        UINT64_C(0x1f42f74f8cb406f3), UINT64_C(0x1f42f70f88b24719)
    },
    {   UINT64_C(0x00000000000061d6), UINT64_C(0x1f42fd0f70b506de), UINT64_C(0x1f42f8cf08af670e),
        UINT64_C(0x1f43010f18b526f8), UINT64_C(0x1f42fa4f28b56718)
    },
    {   UINT64_C(0x00000000000061d7), UINT64_C(0x1f43014eb0ada71b), UINT64_C(0x1f43014ef8b82708),
        UINT64_C(0x1f43004f0caf46cf), UINT64_C(0x1f43020f0cb086ee)
    },
    {   UINT64_C(0x00000000000061d8), UINT64_C(0x1f42f80f80b026da), UINT64_C(0x1f42fd0f08b506ee),
        UINT64_C(0x1f4304cf1caaa6e5), UINT64_C(0x1f42f74f50b40720)
    },
    {   UINT64_C(0x00000000000061d9), UINT64_C(0x1f42fb0f7cb2e70c), UINT64_C(0x1f430f8eb0b1c70e),
        UINT64_C(0x1f42fa0fa8b786d4), UINT64_C(0x1f42fa0fe0b8a706)
    },
    {   UINT64_C(0x00000000000061da), UINT64_C(0x1f43064f34b2e711), UINT64_C(0x1f42f8cfc0b566fd),
        UINT64_C(0x1f42ff0f04b46710), UINT64_C(0x1f42f74ee4b30702)
    },
    {   UINT64_C(0x00000000000061db), UINT64_C(0x1f42f8cf08b70716), UINT64_C(0x1f42ff0f98b5c6db),
        UINT64_C(0x1f42f70ed8b4471f), UINT64_C(0x1f42fc4efcb5c706)
    },
    {   UINT64_C(0x00000000000061dc), UINT64_C(0x1f42fd8f9cb6a710), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f9ce68b8871f)
    },
    {   UINT64_C(0x00000000000061dd), UINT64_C(0x1f42f80f0cab2700), UINT64_C(0x1f43078ea8b166ef),
        UINT64_C(0x1f42f7cebcb7a721), UINT64_C(0x1f42fc0f04b1a719)
    },
    {   UINT64_C(0x00000000000061de), UINT64_C(0x1f42fb4f54b126c6), UINT64_C(0x1f43008fe0b8a6ca),
        UINT64_C(0x1f42f8cf3cb50700), UINT64_C(0x1f42f8cf28b48707)
    },
    {   UINT64_C(0x00000000000061df), UINT64_C(0x1f42fb4f3cb2070c), UINT64_C(0x1f42fa4ef0b8a714),
        UINT64_C(0x1f42fa4eecb44717), UINT64_C(0x1f42fa0f3cb5a6f1)
    },
    {   UINT64_C(0x00000000000061e0), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff8f74b5a6b7),
        UINT64_C(0x1f42f80e4cb00726), UINT64_C(0x1f42f74e74b6870e)
    },
    {   UINT64_C(0x00000000000061e1), UINT64_C(0x1f42fdced8af66e8), UINT64_C(0x1f4303cf78b4e712),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43018f78ae671a)
    },
    {   UINT64_C(0x00000000000061e2), UINT64_C(0x1f43004f54b086bf), UINT64_C(0x1f42fc4eccb26709),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43000f4cb6672d)
    },
    {   UINT64_C(0x00000000000061e3), UINT64_C(0x0000000000000000), UINT64_C(0x1f43074ff8b266e1),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43004f70b726d4)
    },
    {   UINT64_C(0x00000000000061e4), UINT64_C(0x1f43010e5cb3c714), UINT64_C(0x1f43020f5cb16729),
        UINT64_C(0x1f42fa8f18b7a70c), UINT64_C(0x1f42fe0eccb646ff)
    },
    {   UINT64_C(0x00000000000061e5), UINT64_C(0x1f43010f84b7c702), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43004eb4b8c6e1), UINT64_C(0x1f42fe0f0cb4c6f7)
    },
    {   UINT64_C(0x00000000000061e6), UINT64_C(0x1f43010fb8b06712), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f431a4eb4a9c730), UINT64_C(0x1f4302cefcb0a6fa)
    },
    {   UINT64_C(0x00000000000061e7), UINT64_C(0x1f43090eb4b6a70b), UINT64_C(0x1f43010f7cb7470d),
        UINT64_C(0x1f42fecf44b1c700), UINT64_C(0x1f42f9cf50b3c6e5)
    },
    {   UINT64_C(0x00000000000061e8), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430c8e84afc72c), UINT64_C(0x1f42fd0ef8b8a6eb)
    },
    {   UINT64_C(0x00000000000061e9), UINT64_C(0x1f43058fbcb5c702), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000061ea), UINT64_C(0x1f42fb4f6caf470f), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43014f08ab26ff), UINT64_C(0x1f42fc0ec4b6a739)
    },
    {   UINT64_C(0x00000000000061eb), UINT64_C(0x1f43004f10b0871f), UINT64_C(0x1f42fc8efcb066fe),
        UINT64_C(0x1f43020eacb32709), UINT64_C(0x1f430dcf30b1a71e)
    },
    {   UINT64_C(0x00000000000061ec), UINT64_C(0x1f42fa4f20b5c6f7), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb8f60ace6f6), UINT64_C(0x1f42f94fb4b42716)
    },
    {   UINT64_C(0x00000000000061ed), UINT64_C(0x1f431acf18ac6735), UINT64_C(0x1f42ff8edcb0e6e6),
        UINT64_C(0x1f43104f30ab0712), UINT64_C(0x1f42fb8ed4ace735)
    },
    {   UINT64_C(0x00000000000061ee), UINT64_C(0x1f43060f18abe716), UINT64_C(0x1f42fa0efcb4a6f7),
        UINT64_C(0x1f42fd4ef4ae2712), UINT64_C(0x1f42f94ef0b54730)
    },
    {   UINT64_C(0x00000000000061ef), UINT64_C(0x1f43008f5cb1a704), UINT64_C(0x1f430f4f24b1472a),
        UINT64_C(0x1f42fc8f2cb0e70d), UINT64_C(0x1f43144f18aa8718)
    },
    {   UINT64_C(0x00000000000061f0), UINT64_C(0x1f42fdce7cb1e732), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff8ef8b0471d), UINT64_C(0x1f42fb8f28b466f0)
    },
    {   UINT64_C(0x00000000000061f1), UINT64_C(0x1f430b8f20b18720), UINT64_C(0x1f42fc8f24b246f3),
        UINT64_C(0x1f42fbcfc0b3471c), UINT64_C(0x1f42ff4e58b2e73a)
    },
    {   UINT64_C(0x00000000000061f2), UINT64_C(0x1f42f9cf5cb166d5), UINT64_C(0x1f42fa8ed0b746ed),
        UINT64_C(0x1f43104f30ab070d), UINT64_C(0x1f42fecfe8b3e709)
    },
    {   UINT64_C(0x00000000000061f3), UINT64_C(0x1f42fe4f54b66711), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb4f14b50705), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000061f4), UINT64_C(0x1f42fa8df8b56746), UINT64_C(0x1f42f90e3cb2473c),
        UINT64_C(0x1f42f70ebcb4c73e), UINT64_C(0x1f42f74e80b82738)
    },
    {   UINT64_C(0x00000000000061f5), UINT64_C(0x1f42fc0f1cb446da), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430f0e58ace738)
    },
    {   UINT64_C(0x00000000000061f6), UINT64_C(0x1f42f58e80b1670f), UINT64_C(0x1f42fc4ea8b20707),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fdce74b1c705)
    },
    {   UINT64_C(0x0000000000008940), UINT64_C(0x1622eb53cc98653c), UINT64_C(0x0000000000000000),
        UINT64_C(0x16233d4ae46f4776), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008941), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x16233d4ae46f4776), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000061f9), UINT64_C(0x1f42f60ed4b266f4), UINT64_C(0x1f42fe4ee0b2e736),
        UINT64_C(0x1f43014ec4af271e), UINT64_C(0x1f42face74b746e0)
    },
    {   UINT64_C(0x0000000000008943), UINT64_C(0x16233d4ae498853c), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008944), UINT64_C(0x1622eb4ae46f453c), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000061fc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fe0f24ae2724), UINT64_C(0x1f42fa4ea4b32721)
    },
    {   UINT64_C(0x0000000000008946), UINT64_C(0x1622eb53cc6f4776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000061fe), UINT64_C(0x0000000000000000), UINT64_C(0x1f4311ceb8af6740),
        UINT64_C(0x1f42fc0ee0b1a711), UINT64_C(0x1f42fdceb0b1c739)
    },
    {   UINT64_C(0x00000000000061ff), UINT64_C(0x1f430d0f28b2c731), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa0eecb26730), UINT64_C(0x1f4307ceb4b4a72c)
    },
    {   UINT64_C(0x0000000000006200), UINT64_C(0x1f42fa4efcade6ff), UINT64_C(0x1f430d0eb4abe71e),
        UINT64_C(0x1f42fb8ebcb2c72f), UINT64_C(0x1f43004eb4b7472a)
    },
    {   UINT64_C(0x0000000000006201), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cfbcb326f1),
        UINT64_C(0x1f4319ce60aa074b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006202), UINT64_C(0x1f4302ce90aea726), UINT64_C(0x1f42facec0b566f9),
        UINT64_C(0x1f42f90e6cb6c721), UINT64_C(0x1f42f98efcae0706)
    },
    {   UINT64_C(0x0000000000006203), UINT64_C(0x1f43014e7cad66fe), UINT64_C(0x1f42f60fb0b6c6ea),
        UINT64_C(0x1f42f94ec8b60725), UINT64_C(0x1f42f68f00b7470d)
    },
    {   UINT64_C(0x0000000000006204), UINT64_C(0x1f42fa4e5cb72731), UINT64_C(0x1f42fbceacb5470c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa4ebcb8272e)
    },
    {   UINT64_C(0x0000000000006205), UINT64_C(0x1f42f90e88b7a731), UINT64_C(0x1f42fa0ee0afa6f5),
        UINT64_C(0x1f42fa0e88b7671e), UINT64_C(0x1f43004ea8b14703)
    },
    {   UINT64_C(0x0000000000006206), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd4f0cb26740),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4302cf30b1272f)
    },
    {   UINT64_C(0x0000000000006207), UINT64_C(0x1f43070ea8b7070a), UINT64_C(0x1f42fdd058b7a6e1),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb4ed4b88732)
    },
    {   UINT64_C(0x0000000000006208), UINT64_C(0x1f43128f10abe702), UINT64_C(0x1f43004e74b12741),
        UINT64_C(0x1f43058ea0b56739), UINT64_C(0x1f42f40ee0b38702)
    },
    {   UINT64_C(0x0000000000006209), UINT64_C(0x1f430a4eecaba740), UINT64_C(0x1f4316ce84a72737),
        UINT64_C(0x1f42fd4ef4b32736), UINT64_C(0x1f4307ce58ae871a)
    },
    {   UINT64_C(0x000000000000620a), UINT64_C(0x1f42fe4edcaf6726), UINT64_C(0x1f43000f50b086f7),
        UINT64_C(0x1f4309ce84ae4735), UINT64_C(0x1f430f4ec4aae719)
    },
    {   UINT64_C(0x0000000000008954), UINT64_C(0x1622eb5258986599), UINT64_C(0x1623264ae47ae776),
        UINT64_C(0x16233d4ae4988599), UINT64_C(0x1623264ae498853c)
    },
    {   UINT64_C(0x0000000000008955), UINT64_C(0x1623264ae4986599), UINT64_C(0x1622eb4ae46f4599),
        UINT64_C(0x1622eb4ae47ae53c), UINT64_C(0x1622eb4ae47ae599)
    },
    {   UINT64_C(0x000000000000620d), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f94e54ad4735),
        UINT64_C(0x1f4307ceb4b1471f), UINT64_C(0x1f42fb0e7caf6705)
    },
    {   UINT64_C(0x000000000000620e), UINT64_C(0x1f42fb4e3cb0c72c), UINT64_C(0x1f43080e58aea734),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430eceb4a9e734)
    },
    {   UINT64_C(0x000000000000620f), UINT64_C(0x1f42f9ce6cb7e72f), UINT64_C(0x1f43000ed8afa71c),
        UINT64_C(0x1f42fbce48b3a714), UINT64_C(0x1f43128e5cade741)
    },
    {   UINT64_C(0x0000000000008959), UINT64_C(0x1622eb4ae4986599), UINT64_C(0x1622eb4ae498653c),
        UINT64_C(0x1622eb4ae4986599), UINT64_C(0x1622eb5258986776)
    },
    {   UINT64_C(0x0000000000006211), UINT64_C(0x1f42f6d0e0b5a6ef), UINT64_C(0x1f42f90ebcb2870d),
        UINT64_C(0x1f4305ce88afa721), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006212), UINT64_C(0x1f42f9ce8cb64704), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fccf50b2c71f), UINT64_C(0x1f43150eb8ae6731)
    },
    {   UINT64_C(0x000000000000895c), UINT64_C(0x0000000000000000), UINT64_C(0x1622ea4ae498e776),
        UINT64_C(0x1622ea4ae498e776), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006214), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f88ec0b7e6ff), UINT64_C(0x1f42f78ef8b52703)
    },
    {   UINT64_C(0x0000000000006215), UINT64_C(0x1f42fa4f04b28711), UINT64_C(0x1f42f54f1cb2a71b),
        UINT64_C(0x1f42f74f74b48709), UINT64_C(0x1f42f88ee4b9872c)
    },
    {   UINT64_C(0x0000000000006216), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f64f18b7071e),
        UINT64_C(0x1f42f48f2cb4a70f), UINT64_C(0x1f42fc4f28b8672a)
    },
    {   UINT64_C(0x0000000000008960), UINT64_C(0x25eaee1460d62776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008961), UINT64_C(0x25eaee0ae4d62517), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006219), UINT64_C(0x1f432c4f74918703), UINT64_C(0x1f43054f08aec6ff),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f78e50b7a6f7)
    },
    {   UINT64_C(0x0000000000008963), UINT64_C(0x25e2ee0ae48a4776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000621b), UINT64_C(0x1f42fc4f4cb1e6f7), UINT64_C(0x1f42fc8f34b5c70a),
        UINT64_C(0x1f43050ed8b2c719), UINT64_C(0x1f42fa8f38b5670a)
    },
    {   UINT64_C(0x000000000000621c), UINT64_C(0x1f430acf44b3872b), UINT64_C(0x1f42ff4f64b52705),
        UINT64_C(0x1f42f78f54ab4709), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000621d), UINT64_C(0x1f42fb8f64b206ef), UINT64_C(0x1f42fb8f94ab4715),
        UINT64_C(0x1f42fd8e98b08702), UINT64_C(0x1f43000e68b5c735)
    },
    {   UINT64_C(0x000000000000621e), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f78f28b4e706),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000621f), UINT64_C(0x1f42ff4f7cb48706), UINT64_C(0x1f42fa8f84b26719),
        UINT64_C(0x1f4302ce58b4a733), UINT64_C(0x1f42f78f08b76704)
    },
    {   UINT64_C(0x0000000000006220), UINT64_C(0x1f42ff4ec8af670d), UINT64_C(0x1f43030e68b4c734),
        UINT64_C(0x1f42fc8f34b64708), UINT64_C(0x1f43080e58abe71c)
    },
    {   UINT64_C(0x0000000000006221), UINT64_C(0x1f42fc4f54b44703), UINT64_C(0x1f4313cec4aca730),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000896b), UINT64_C(0x1fe2f78f74b945bd), UINT64_C(0x1fe2f78f74b945bd),
        UINT64_C(0x1182f80c307f86bc), UINT64_C(0x1182f80c307f86bc)
    },
    {   UINT64_C(0x0000000000006223), UINT64_C(0x1f430b0f14b0a723), UINT64_C(0x1f42f58f90b50716),
        UINT64_C(0x1f42fa8f30aea706), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006224), UINT64_C(0x0000000000000000), UINT64_C(0x1f43004f88ade6fb),
        UINT64_C(0x1f42f98f54b5c70b), UINT64_C(0x1f42fd8f28b52709)
    },
    {   UINT64_C(0x000000000000896e), UINT64_C(0x14a3020edc8a2614), UINT64_C(0x14a3020ed88a2613),
        UINT64_C(0x1d12fe4ed8ad2613), UINT64_C(0x1d12fe4ed8ad2613)
    },
    {   UINT64_C(0x0000000000006226), UINT64_C(0x1f42fd8f44b26706), UINT64_C(0x1f43024f54aa86fe),
        UINT64_C(0x1f42f88fe0b6670c), UINT64_C(0x1f42f98fe0b2a702)
    },
    {   UINT64_C(0x0000000000006227), UINT64_C(0x1f42f68f08b6c70e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43050ea8b48735), UINT64_C(0x1f42fe4fa4b82706)
    },
    {   UINT64_C(0x0000000000008971), UINT64_C(0x1d12f94ed8aaa613), UINT64_C(0x1d12f94ed8aaa613),
        UINT64_C(0x2142f7cbd8bea6d0), UINT64_C(0x2142f7cbd8bea6d0)
    },
    {   UINT64_C(0x0000000000006229), UINT64_C(0x1f42fc4e5cb3c735), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43004ef4ad06f6)
    },
    {   UINT64_C(0x000000000000622a), UINT64_C(0x1f42fa8ff0b10706), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc8fa4b0e711), UINT64_C(0x1f42f78fc4b7072e)
    },
    {   UINT64_C(0x000000000000622b), UINT64_C(0x1f42fd8eb8b30731), UINT64_C(0x1f43084eb4b2872a),
        UINT64_C(0x1f42ffcf38b2a709), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008975), UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x1a52fa8dc4a18657),
        UINT64_C(0x1222fe8ce07c4690), UINT64_C(0x1223038ce07ec690)
    },
    {   UINT64_C(0x0000000000008976), UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x1c72f94d28aaa67e),
        UINT64_C(0x1c72f95390aaa67e), UINT64_C(0x1c72f94d28aaa4e4)
    },
    {   UINT64_C(0x0000000000008977), UINT64_C(0x1c72f4d390776690), UINT64_C(0x1c735fd390ad0690),
        UINT64_C(0x1c735fcce0ad04e4), UINT64_C(0x1c72f48ce07764e4)
    },
    {   UINT64_C(0x000000000000622f), UINT64_C(0x1f42fb4f3cb6e713), UINT64_C(0x1f42f78fd0b306fa),
        UINT64_C(0x1f42fb8eecb5c71e), UINT64_C(0x1f42f70f54b7271c)
    },
    {   UINT64_C(0x0000000000008979), UINT64_C(0x1c7af94d28aaa67e), UINT64_C(0x1c7af94d28aaa67e),
        UINT64_C(0x105aff908c7765a4), UINT64_C(0x1c72f94d2caaa67e)
    },
    {   UINT64_C(0x000000000000897a), UINT64_C(0x1c72f94d2caaa67e), UINT64_C(0x1c72f94d2caaa67e),
        UINT64_C(0x1c72f94d2caaa67e), UINT64_C(0x1c72f94d2caaa67e)
    },
    {   UINT64_C(0x000000000000897b), UINT64_C(0x23caf6cda4c94713), UINT64_C(0x23caf6cda4c94713),
        UINT64_C(0x23caf6cda4c94713), UINT64_C(0x25baff8b38cca6f9)
    },
    {   UINT64_C(0x000000000000897c), UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x1c72f94d28aaa67e),
        UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x1c72f94d28aaa67e)
    },
    {   UINT64_C(0x000000000000897d), UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x1a52fa8dc4a18657),
        UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x1a52fa8dc4a18657)
    },
    {   UINT64_C(0x000000000000897e), UINT64_C(0x1c7af94d28aaa67e), UINT64_C(0x1c7af94d28aaa67e),
        UINT64_C(0x1c7af94d28aaa67e), UINT64_C(0x1752f94e7096262c)
    },
    {   UINT64_C(0x000000000000897f), UINT64_C(0x1752f94e7096262c), UINT64_C(0x12caf78f7084e5e9),
        UINT64_C(0x12caf78f7484e5ea), UINT64_C(0x1c7af94d28aaa67e)
    },
    {   UINT64_C(0x0000000000006237), UINT64_C(0x1f42ff4f1cb0c711), UINT64_C(0x1f42fe4e3cb64725),
        UINT64_C(0x1f42fd8f50b66700), UINT64_C(0x1f430bce50b9a72c)
    },
    {   UINT64_C(0x0000000000008981), UINT64_C(0x0000000000000000), UINT64_C(0x1b32fd0e98a3c677),
        UINT64_C(0x1b32fd0e98a3c677), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008982), UINT64_C(0x0000000000000000), UINT64_C(0x17d2fa8e6497862f),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008983), UINT64_C(0x122afb8d9483a662), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f60fa0b7668c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008984), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001492d), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x15baee0f5495669a), UINT64_C(0x15baee0f5495669a)
    },
    {   UINT64_C(0x00000000000087a0), UINT64_C(0x1d82ef4f74b30762), UINT64_C(0x1692f34f6895468e),
        UINT64_C(0x1d82ef4f74b30762), UINT64_C(0x1692f34f6895468e)
    },
    {   UINT64_C(0x00000000000060eb), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4313ce68a5272a), UINT64_C(0x1f43108eacb5c735)
    },
    {   UINT64_C(0x0000000000008988), UINT64_C(0x0000000000000000), UINT64_C(0x135aff8f1483265e),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006240), UINT64_C(0x0000000000000000), UINT64_C(0x1f430f0f14b2671f),
        UINT64_C(0x1f42f68ef8b5e711), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006241), UINT64_C(0x1f42f84efcb64729), UINT64_C(0x1f43004e8cb70715),
        UINT64_C(0x1f42fc4f38b686e7), UINT64_C(0x1f42ff4ee0b7c722)
    },
    {   UINT64_C(0x0000000000006242), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa8f28b546f2),
        UINT64_C(0x1f42f58fa0adc729), UINT64_C(0x1f42fd4eacb78709)
    },
    {   UINT64_C(0x0000000000011111), UINT64_C(0x186afa8d4099e683), UINT64_C(0x1722f78fa0992675),
        UINT64_C(0x1452fa8f78938684), UINT64_C(0x1132f44fa0924675)
    },
    {   UINT64_C(0x0000000000006244), UINT64_C(0x1f42f98f18afc721), UINT64_C(0x1f42fa8ef8b50709),
        UINT64_C(0x1f42fc8e84aea72e), UINT64_C(0x1f42f98fe0b826ff)
    },
    {   UINT64_C(0x0000000000011112), UINT64_C(0x160afe4f6c9f6675), UINT64_C(0x11fafd0f609d8675),
        UINT64_C(0x1ca2fd0f60c82675), UINT64_C(0x18b2f44fa0a3c675)
    },
    {   UINT64_C(0x0000000000006246), UINT64_C(0x1f42fc8e8caf0741), UINT64_C(0x1f42fb8e7cb2e6f7),
        UINT64_C(0x1f42f78eb0b40715), UINT64_C(0x1f42f98efcb0e713)
    },
    {   UINT64_C(0x0000000000006247), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f74e9cb6c70b),
        UINT64_C(0x1f42f98fa4b426f3), UINT64_C(0x1f42f58eeca94706)
    },
    {   UINT64_C(0x0000000000006248), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f78ef8b78703),
        UINT64_C(0x1f43074e84ab471e), UINT64_C(0x1f42fb8f0cb7c6fe)
    },
    {   UINT64_C(0x0000000000006249), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f68e68b5c723),
        UINT64_C(0x1f42fb8f54b666e7), UINT64_C(0x1f430d0e74af86fe)
    },
    {   UINT64_C(0x000000000000624a), UINT64_C(0x0000000000000000), UINT64_C(0x1f430e0ea8af272a),
        UINT64_C(0x1f42fb8f34b38711), UINT64_C(0x1f42f4cfa4b80704)
    },
    {   UINT64_C(0x000000000000624b), UINT64_C(0x1f42f88edcb526e7), UINT64_C(0x1f430a4ec0ada735),
        UINT64_C(0x1f43110eb4b0670f), UINT64_C(0x1f42f68eb8aa6721)
    },
    {   UINT64_C(0x000000000000624c), UINT64_C(0x1f430b4eb4b20736), UINT64_C(0x1f430c0ed8ad272d),
        UINT64_C(0x1f42f88e6cb3c730), UINT64_C(0x1f42fa8ef4b306f2)
    },
    {   UINT64_C(0x000000000000624d), UINT64_C(0x1f42f78fe0b2a6fd), UINT64_C(0x1f42f78f4cac671d),
        UINT64_C(0x1f42f68f90b006f3), UINT64_C(0x1f42f98ff0b5c6f2)
    },
    {   UINT64_C(0x000000000000624e), UINT64_C(0x1f42f98ef0b5a727), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43094e88b3a73c)
    },
    {   UINT64_C(0x000000000000624f), UINT64_C(0x1f42f98f48b826f6), UINT64_C(0x1f43074e88b4a71d),
        UINT64_C(0x1f42f98efcae06fa), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000060fd), UINT64_C(0x1f42fbceecb4a746), UINT64_C(0x1f43120e74a60734),
        UINT64_C(0x1f430c0e7cb0c735), UINT64_C(0x1f43080e5cae8735)
    },
    {   UINT64_C(0x00000000000060fe), UINT64_C(0x1f42fe8f2cb6a730), UINT64_C(0x1f43134f64b2471c),
        UINT64_C(0x1f43034e1ca4a740), UINT64_C(0x1f43058e50b6471e)
    },
    {   UINT64_C(0x000000000000899b), UINT64_C(0x0000000000000000), UINT64_C(0x0d52fc4f7869c6e8),
        UINT64_C(0x0d5300cccc6a46e8), UINT64_C(0x0d52f84ccc6ec6e8)
    },
    {   UINT64_C(0x0000000000006253), UINT64_C(0x1f42f78e7cb2e6f3), UINT64_C(0x1f42f68e68b72739),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f68f18b786ee)
    },
    {   UINT64_C(0x0000000000006254), UINT64_C(0x1f42fc8ef0b76731), UINT64_C(0x1f42f98e28b66727),
        UINT64_C(0x1f42f48fb4b7a6e1), UINT64_C(0x1f42f68ed8b94712)
    },
    {   UINT64_C(0x0000000000006255), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42ff8f60b68721), UINT64_C(0x1f42f58e4cb44715)
    },
    {   UINT64_C(0x0000000000006256), UINT64_C(0x1f42f98e54ba670f), UINT64_C(0x1f42f98e8cb8a707),
        UINT64_C(0x1f42fb8f04b6e713), UINT64_C(0x1f42f58e84b48746)
    },
    {   UINT64_C(0x0000000000006257), UINT64_C(0x1f42f98f14b1e730), UINT64_C(0x1f42f98f40b78703),
        UINT64_C(0x1f43054ea4b62733), UINT64_C(0x1f42facec8b80728)
    },
    {   UINT64_C(0x0000000000006258), UINT64_C(0x1f42fa8f30b2c729), UINT64_C(0x1f42f58e90b086ee),
        UINT64_C(0x1f42f98ea8b1a718), UINT64_C(0x1f42fb8edcb42744)
    },
    {   UINT64_C(0x0000000000006259), UINT64_C(0x1f42f7cf74b346f6), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc8efcb426fa), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000625a), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff4e94afa735),
        UINT64_C(0x1f42f98e54b46711), UINT64_C(0x1f42fd8fa8b3c70b)
    },
    {   UINT64_C(0x000000000000625b), UINT64_C(0x1f42f98f94b3a704), UINT64_C(0x1f42f98f28aec72e),
        UINT64_C(0x1f42fe8eccb7a6fa), UINT64_C(0x1f42f4cf7cb76702)
    },
    {   UINT64_C(0x000000000000625c), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f88f58b446fe),
        UINT64_C(0x1f4309ce84af8730), UINT64_C(0x1f42f48ebcb56710)
    },
    {   UINT64_C(0x000000000000625d), UINT64_C(0x1f42f8ce98af0709), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f68ea4b326fb), UINT64_C(0x1f42f68ec8b74724)
    },
    {   UINT64_C(0x000000000000625e), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f58ea0b72711),
        UINT64_C(0x1f42fa8ee0ad6714), UINT64_C(0x1f42f88e70b4c70d)
    },
    {   UINT64_C(0x000000000000625f), UINT64_C(0x1f42f78ea8afc719), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430e8f88b066e5), UINT64_C(0x1f430d4fccaec6f3)
    },
    {   UINT64_C(0x0000000000006260), UINT64_C(0x0000000000000000), UINT64_C(0x1f42facf0cb6c71a),
        UINT64_C(0x1f43070ed4b3871c), UINT64_C(0x1f43088e5cae672e)
    },
    {   UINT64_C(0x0000000000006261), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd0f14b446df),
        UINT64_C(0x1f42fe8ea8b40736), UINT64_C(0x1f43120eb4a96708)
    },
    {   UINT64_C(0x0000000000006262), UINT64_C(0x1f430c0eb4b22722), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4309ce44ada737), UINT64_C(0x1f43114f74b4e720)
    },
    {   UINT64_C(0x0000000000006263), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd4f3cb6e6fb)
    },
    {   UINT64_C(0x0000000000006264), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43108e70b58733)
    },
    {   UINT64_C(0x0000000000006265), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80f40b5e6d9),
        UINT64_C(0x1f42fd8f84b906ff), UINT64_C(0x1f42ff0f6cb7c6f1)
    },
    {   UINT64_C(0x0000000000006266), UINT64_C(0x1f4306cf90b6a70d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43108e6cada715), UINT64_C(0x1f42f74f2cb846e0)
    },
    {   UINT64_C(0x0000000000006267), UINT64_C(0x1f42f78ef4b666d3), UINT64_C(0x1f4300cf58b586e2),
        UINT64_C(0x1f42fdcf64b766e2), UINT64_C(0x1f42f9cf64b806e5)
    },
    {   UINT64_C(0x0000000000006268), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f94f48b5e6f9),
        UINT64_C(0x1f430a8f0cb646f9), UINT64_C(0x1f42fa4f84b926ed)
    },
    {   UINT64_C(0x0000000000006269), UINT64_C(0x1f42f94f3cb706f1), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc0f6cb7a728), UINT64_C(0x1f4309ce44ada738)
    },
    {   UINT64_C(0x000000000000626a), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f24e74b94722),
        UINT64_C(0x1f43088f00b9672a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000626b), UINT64_C(0x1f4301cf78b7e726), UINT64_C(0x1f43030f08b786b1),
        UINT64_C(0x1f4312cedcad8734), UINT64_C(0x1f42fbcf54b7272f)
    },
    {   UINT64_C(0x000000000000626c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43008f00b8473f), UINT64_C(0x1f42f84f90b66712)
    },
    {   UINT64_C(0x000000000000626d), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43070f6cb78717), UINT64_C(0x1f42f58f24b8a72c)
    },
    {   UINT64_C(0x000000000000626e), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f98f98b6a6d0),
        UINT64_C(0x1f4309ce6cb1c721), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000626f), UINT64_C(0x0000000000000000), UINT64_C(0x1f43148e44b30732),
        UINT64_C(0x1f42ff0f2cb7a712), UINT64_C(0x1f43020eb4b72736)
    },
    {   UINT64_C(0x0000000000006270), UINT64_C(0x1f42f78ed8b82739), UINT64_C(0x1f43114f58b566ed),
        UINT64_C(0x1f43028fbcb646e5), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006271), UINT64_C(0x1f42ff0fdcb666f7), UINT64_C(0x1f43154f18b1c736),
        UINT64_C(0x1f42fa8f84b6e6f2), UINT64_C(0x1f4304cfacb6270a)
    },
    {   UINT64_C(0x0000000000006272), UINT64_C(0x1f4322cf34aa2726), UINT64_C(0x1f43108f34adc715),
        UINT64_C(0x1f430e0f2cb6c6fc), UINT64_C(0x1f42fd4f90b5e6ed)
    },
    {   UINT64_C(0x0000000000006273), UINT64_C(0x1f43008fbcb5c6fe), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc4f94b8271f), UINT64_C(0x1f42fb0f80b6270d)
    },
    {   UINT64_C(0x0000000000006274), UINT64_C(0x1f4303cf84b6e70f), UINT64_C(0x1f42f94f94b6c71d),
        UINT64_C(0x1f430d8e94a1873b), UINT64_C(0x1f43030e7cabc70b)
    },
    {   UINT64_C(0x0000000000006122), UINT64_C(0x1f43168eb4ab672e), UINT64_C(0x1f430b4edcace733),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4302cef4afe73b)
    },
    {   UINT64_C(0x0000000000006123), UINT64_C(0x1f430c8e98ace71a), UINT64_C(0x1f430f4e80aba73d),
        UINT64_C(0x1f430b4e48b2c737), UINT64_C(0x1f4310ceccb02734)
    },
    {   UINT64_C(0x0000000000006277), UINT64_C(0x1f43110e68aa471f), UINT64_C(0x1f42fb4f88b52708),
        UINT64_C(0x1f43020f50ada70f), UINT64_C(0x1f42f94f00b3e6f2)
    },
    {   UINT64_C(0x0000000000006278), UINT64_C(0x1f430a0e44b64735), UINT64_C(0x1f42fe4f3cb82704),
        UINT64_C(0x1f430e4e78a8871f), UINT64_C(0x1f43030e7cb5673d)
    },
    {   UINT64_C(0x0000000000006279), UINT64_C(0x1f42f74ef8b38707), UINT64_C(0x1f42ff4facb6c713),
        UINT64_C(0x1f42fc4f8cb04719), UINT64_C(0x1f42f8ce5cb6273b)
    },
    {   UINT64_C(0x000000000000627a), UINT64_C(0x1f42fd4f2cb6c704), UINT64_C(0x1f42fc4ee4b16704),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa4eccb7a72e)
    },
    {   UINT64_C(0x000000000000627b), UINT64_C(0x1f42ff0f54b90705), UINT64_C(0x1f42fc4e90b6e705),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff4f08b06710)
    },
    {   UINT64_C(0x000000000000627c), UINT64_C(0x1f42fa4f20b5270d), UINT64_C(0x1f43070ea4ac4728),
        UINT64_C(0x1f42ff4e7caf6717), UINT64_C(0x1f43004f54b74716)
    },
    {   UINT64_C(0x000000000000612a), UINT64_C(0x1f42fb4e48b3c745), UINT64_C(0x1f4305ce9cb2c738),
        UINT64_C(0x1f430c8e18b36741), UINT64_C(0x1f4312ceb4ac4739)
    },
    {   UINT64_C(0x000000000000627e), UINT64_C(0x1f42fb4e9cb1670d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43118e6caec711), UINT64_C(0x1f42f84ef8b54722)
    },
    {   UINT64_C(0x00000000000089c8), UINT64_C(0x17fafb4e4497c638), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000612d), UINT64_C(0x1f43118eb8a7c734), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430a4ee8b90732), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000011130), UINT64_C(0x16b2f80f7491c697), UINT64_C(0x121afa0f7485e697),
        UINT64_C(0x2072fa4f74b8c5a1), UINT64_C(0x17cafa4f749625a1)
    },
    {   UINT64_C(0x000000000000612f), UINT64_C(0x1f43024e90b6e741), UINT64_C(0x1f43148f3cae071e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4313ce58aa0742)
    },
    {   UINT64_C(0x0000000000011131), UINT64_C(0x0000000000000000), UINT64_C(0x182af3cc5c9545a1),
        UINT64_C(0x1862f58c5c9b65a1), UINT64_C(0x1222fa0fa08605a4)
    },
    {   UINT64_C(0x00000000000089cd), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x15baf6cdf08ec650), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006285), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cfe8b326f8),
        UINT64_C(0x1f42fd4ff8b44728), UINT64_C(0x1f42fa9018b9e6fb)
    },
    {   UINT64_C(0x0000000000006286), UINT64_C(0x1f43039008b7e6fe), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f88fb4b8c70d)
    },
    {   UINT64_C(0x0000000000006134), UINT64_C(0x1f42fc8e64ad6740), UINT64_C(0x1f43074e98ae073b),
        UINT64_C(0x1f4302ce4cb2673c), UINT64_C(0x1f42f74ee8b3673d)
    },
    {   UINT64_C(0x0000000000006288), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fdcee8b106f7), UINT64_C(0x1f42f88f8cb6c717)
    },
    {   UINT64_C(0x0000000000006289), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f98f20adc706),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4300cf20b2e6f5)
    },
    {   UINT64_C(0x000000000000628a), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fe4f64b4270e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006138), UINT64_C(0x1f431c4eaca72723), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43050f28a84726)
    },
    {   UINT64_C(0x0000000000006139), UINT64_C(0x0000000000000000), UINT64_C(0x1f43060f58b46720),
        UINT64_C(0x1f42ff0e80b2c728), UINT64_C(0x1f43030f0caf071e)
    },
    {   UINT64_C(0x000000000000613a), UINT64_C(0x1f43030eb4b2a71e), UINT64_C(0x1f430a4eecb50738),
        UINT64_C(0x1f42ff8eecb30729), UINT64_C(0x1f43020e54b18731)
    },
    {   UINT64_C(0x000000000000613b), UINT64_C(0x1f43020ee4b1c741), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd8e58b24737), UINT64_C(0x1f43044f18ae2724)
    },
    {   UINT64_C(0x000000000000613c), UINT64_C(0x1f43054ef8b30728), UINT64_C(0x1f430f8e7cae872f),
        UINT64_C(0x1f43160e6ca92728), UINT64_C(0x1f43130e84ab6737)
    },
    {   UINT64_C(0x000000000000613d), UINT64_C(0x1f43120ef0ab0735), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43094ed8ae6720), UINT64_C(0x1f43038f08ab6721)
    },
    {   UINT64_C(0x000000000000613e), UINT64_C(0x0000000000000000), UINT64_C(0x1f43008eacad8712),
        UINT64_C(0x1f43038f44af672b), UINT64_C(0x1f43078eacb3071a)
    },
    {   UINT64_C(0x000000000000613f), UINT64_C(0x1f43024e60b82746), UINT64_C(0x1f430d4e50b0e73c),
        UINT64_C(0x1f4317ced0a78732), UINT64_C(0x1f4305ce84a68738)
    },
    {   UINT64_C(0x00000000000089dc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0f431d0c4c78c6b7), UINT64_C(0x0f42f38c4c6406b7)
    },
    {   UINT64_C(0x0000000000006141), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430e0e78b56732), UINT64_C(0x1f430b0eccb5c738)
    },
    {   UINT64_C(0x0000000000006142), UINT64_C(0x1f43140e70a88736), UINT64_C(0x1f4315ceb0b0272b),
        UINT64_C(0x1f43068e5cb0c726), UINT64_C(0x1f43098f20b4e72b)
    },
    {   UINT64_C(0x0000000000006143), UINT64_C(0x1f4303ceecb2c728), UINT64_C(0x1f43080ee4ad071b),
        UINT64_C(0x1f4306cf0cb3671f), UINT64_C(0x1f431c8e6caa0739)
    },
    {   UINT64_C(0x00000000000089e0), UINT64_C(0x18a2f6cf689a26a9), UINT64_C(0x18a2f6cf689a26a9),
        UINT64_C(0x18a2f6cf689a26a9), UINT64_C(0x18a2f6cf689a26a9)
    },
    {   UINT64_C(0x00000000000089e1), UINT64_C(0x18a2f6cf689a26a9), UINT64_C(0x18a2f6cf689a26a9),
        UINT64_C(0x18a2f6cf689a26a9), UINT64_C(0x18a2f6cf689a26a9)
    },
    {   UINT64_C(0x0000000000006146), UINT64_C(0x1f430b4e50b36736), UINT64_C(0x1f43054ee8b1a722),
        UINT64_C(0x1f42f98e60b3674a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000089e3), UINT64_C(0x18a2f6cf689a26a9), UINT64_C(0x18a2f6cf689a26a9),
        UINT64_C(0x18a2f6cf689a26a9), UINT64_C(0x18a2f6cf689a26a9)
    },
    {   UINT64_C(0x0000000000006148), UINT64_C(0x1f4310cf58b5072a), UINT64_C(0x1f42fbce40b6273a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43028e40b3e740)
    },
    {   UINT64_C(0x0000000000006149), UINT64_C(0x1f4312ce8ca98728), UINT64_C(0x1f4315cef0abc734),
        UINT64_C(0x1f4318cecca92732), UINT64_C(0x1f430f4f30b0e728)
    },
    {   UINT64_C(0x000000000000614a), UINT64_C(0x1f43160ebca40725), UINT64_C(0x1f4312ced8aa673d),
        UINT64_C(0x1f43038eb8b18728), UINT64_C(0x1f43150e50a8a731)
    },
    {   UINT64_C(0x000000000000614b), UINT64_C(0x1f42ff4ef0b5a728), UINT64_C(0x1f430cce5cb6e741),
        UINT64_C(0x1f43150e8ca60720), UINT64_C(0x1f43158eccb0e71c)
    },
    {   UINT64_C(0x000000000000614c), UINT64_C(0x1f42fd0ecca92726), UINT64_C(0x1f4305cf50b1c732),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000614d), UINT64_C(0x1f42facec4b5273a), UINT64_C(0x1f430b4eb8ace739),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430b8e94ae6724)
    },
    {   UINT64_C(0x0000000000008804), UINT64_C(0x0a6af7d2a46224eb), UINT64_C(0x0a6af7d2a86224e9),
        UINT64_C(0x0fa2ee12a47d04eb), UINT64_C(0x0fa2ee12c47d04e2)
    },
    {   UINT64_C(0x0000000000008805), UINT64_C(0x1f42ee12c4bb84e2), UINT64_C(0x3e82ee12c53884e2),
        UINT64_C(0x105b0e4cac6fc69a), UINT64_C(0x0fa2ee0af07d035b)
    },
    {   UINT64_C(0x000000f21de88806), UINT64_C(0x0a6b0ad6645e468c), UINT64_C(0x0a6b01d66459c68c),
        UINT64_C(0x0a6b01cd6c59c44e), UINT64_C(0x0a6b01d66459c68c)
    },
    {   UINT64_C(0x0007d6f89ec88807), UINT64_C(0x0de2f8d66472468c), UINT64_C(0x0de2f5966470a68c),
        UINT64_C(0x0de2f94d6c72844e), UINT64_C(0x0de2f5966470a68c)
    },
    {   UINT64_C(0x0000000000006152), UINT64_C(0x1f43058e7cafc735), UINT64_C(0x1f43100eacafc742),
        UINT64_C(0x1f43018f58b4e731), UINT64_C(0x1f43020e00b18736)
    },
    {   UINT64_C(0x0000000000006153), UINT64_C(0x0000000000000000), UINT64_C(0x1f430cce40b44725),
        UINT64_C(0x1f4308cec4b3273b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000089f0), UINT64_C(0x156afa8fa08dc630), UINT64_C(0x23caf6cda4c94713),
        UINT64_C(0x15aafb0fa08ea67e), UINT64_C(0x156afd0f348ca5f9)
    },
    {   UINT64_C(0x00000000000089f1), UINT64_C(0x156afd4f348cc5f9), UINT64_C(0x0e3afbcc887086a6),
        UINT64_C(0x0e3afbcc887086a6), UINT64_C(0x1362f5cf2c882600)
    },
    {   UINT64_C(0x000000000000880c), UINT64_C(0x22aafd4f54c186aa), UINT64_C(0x2dfafd4f54eec6aa),
        UINT64_C(0x090b00d5e859468e), UINT64_C(0x0d5300d5e46a668e)
    },
    {   UINT64_C(0x000000000000880d), UINT64_C(0x119b00d5e47b868e), UINT64_C(0x090b00d5e859468e),
        UINT64_C(0x0d5300d5e46a668e), UINT64_C(0x119b00d5e47b868e)
    },
    {   UINT64_C(0x0000000000006158), UINT64_C(0x1f43104e6ca4c730), UINT64_C(0x1f43100e40ae8743),
        UINT64_C(0x1f430c4eccae873f), UINT64_C(0x1f43150e8cabe73e)
    },
    {   UINT64_C(0x0000000000006159), UINT64_C(0x1f43084efcaec721), UINT64_C(0x1f43054ef8afe730),
        UINT64_C(0x1f430d8ec0a5a730), UINT64_C(0x1f43034edcb0e730)
    },
    {   UINT64_C(0x000000000000615a), UINT64_C(0x1f42fa8ed4b4c732), UINT64_C(0x1f43138e34b1273f),
        UINT64_C(0x1f43068ed8b1c73c), UINT64_C(0x1f430d4e5cad072d)
    },
    {   UINT64_C(0x000000000000615b), UINT64_C(0x1f430fcf14aca729), UINT64_C(0x1f430dce9caee73f),
        UINT64_C(0x1f431c8eb8a8a730), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000615c), UINT64_C(0x0000000000000000), UINT64_C(0x1f43088ed0a72728),
        UINT64_C(0x1f43018eb8aac70c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000615d), UINT64_C(0x1f43070facacc720), UINT64_C(0x1f43038ec8b74727),
        UINT64_C(0x1f43124e68b1873d), UINT64_C(0x1f430acee4a88735)
    },
    {   UINT64_C(0x00000000000089fa), UINT64_C(0x0c83014c4c6866b1), UINT64_C(0x0c82fe4c4c66e6b1),
        UINT64_C(0x1313004c4c82a6b7), UINT64_C(0x1312fe4c4c81a6b7)
    },
    {   UINT64_C(0x00000000000089fb), UINT64_C(0x0f431a8c4c78c6b7), UINT64_C(0x0f42f38c4c6546b7),
        UINT64_C(0x074afc0cdc58e68c), UINT64_C(0x074af38cdc54a68c)
    },
    {   UINT64_C(0x00000000000089fc), UINT64_C(0x204aff4d30b7267e), UINT64_C(0x204aff4d30b7267e),
        UINT64_C(0x1e72fb8dd0acc65a), UINT64_C(0x1e73050dd0b1865a)
    },
    {   UINT64_C(0x0000000000006161), UINT64_C(0x1f43100ea0aec739), UINT64_C(0x1f42fd4eb4b20735),
        UINT64_C(0x1f430fceb8aa2737), UINT64_C(0x1f42fc4f08b8873b)
    },
    {   UINT64_C(0x0000000000006162), UINT64_C(0x1f43050e94b7673a), UINT64_C(0x1f43074ec0acc72e),
        UINT64_C(0x1f4308ce60acc742), UINT64_C(0x1f43108e84a72742)
    },
    {   UINT64_C(0x0000000000006163), UINT64_C(0x1f4308cea8b08730), UINT64_C(0x1f43168eb4b1c730),
        UINT64_C(0x1f430d0ebcad8735), UINT64_C(0x1f43124ed0ab873d)
    },
    {   UINT64_C(0x0000000000006164), UINT64_C(0x1f4300cf10b2a730), UINT64_C(0x1f43000ea8b2673d),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006165), UINT64_C(0x1f42fdce54b2c739), UINT64_C(0x1f42ff4e34b26735),
        UINT64_C(0x1f43008ea4afa72e), UINT64_C(0x1f43178eb4a6c739)
    },
    {   UINT64_C(0x0000000000006166), UINT64_C(0x1f43074ea8ad2736), UINT64_C(0x1f43004ef8ae073f),
        UINT64_C(0x1f430a8ec0ae672c), UINT64_C(0x1f43120e2cb14739)
    },
    {   UINT64_C(0x0000000000006167), UINT64_C(0x1f42ff8e2cafe72a), UINT64_C(0x1f42fc4e84a2c736),
        UINT64_C(0x1f430f4ed0b6a72c), UINT64_C(0x1f43090f2cb60736)
    },
    {   UINT64_C(0x0000000000006168), UINT64_C(0x1f43078ee0a62730), UINT64_C(0x1f43150f18a60734),
        UINT64_C(0x1f430b0ed8afe737), UINT64_C(0x1f430ccf00b5a724)
    },
    {   UINT64_C(0x0000000000006169), UINT64_C(0x1f43068f40b2c735), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc8e5cada73e), UINT64_C(0x1f4310cee0ae073a)
    },
    {   UINT64_C(0x000000000000616a), UINT64_C(0x1f430b0e5cb16736), UINT64_C(0x1f4311cef8ae473e),
        UINT64_C(0x1f4305ce9cb10749), UINT64_C(0x1f43100e70aa8736)
    },
    {   UINT64_C(0x000000000000616b), UINT64_C(0x1f43034e5cb0e740), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f430a8f08b3672b), UINT64_C(0x1f43018e50b2072f)
    },
    {   UINT64_C(0x000000000000616c), UINT64_C(0x1f43120e70ab6736), UINT64_C(0x1f4303ceb4b3e729),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43000e44b50741)
    },
    {   UINT64_C(0x000000000000616d), UINT64_C(0x1f43144e2ca96735), UINT64_C(0x1f43048e88b4c745),
        UINT64_C(0x1f430c8ea8b4a726), UINT64_C(0x1f43170e40ad6743)
    },
    {   UINT64_C(0x000000000000616e), UINT64_C(0x1f430bcdecad4738), UINT64_C(0x1f43108eb8ac2739),
        UINT64_C(0x1f430a8e4caee736), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000062c2), UINT64_C(0x1f43034ec0b5a719), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd8f9cb5a71c), UINT64_C(0x1f42ff8f44afe6fe)
    },
    {   UINT64_C(0x0000000000006170), UINT64_C(0x1f430d4eb8ac272b), UINT64_C(0x1f43154eccaac733),
        UINT64_C(0x1f43118edcad4737), UINT64_C(0x1f430d4f48b2c73d)
    },
    {   UINT64_C(0x0000000000006171), UINT64_C(0x1f43064e50b5e744), UINT64_C(0x1f430b8e68a7673c),
        UINT64_C(0x1f430b0e7cb2e738), UINT64_C(0x1f43078edcb0472a)
    },
    {   UINT64_C(0x0000000000006172), UINT64_C(0x1f430c8f2cb0872a), UINT64_C(0x1f43048f20af673c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff4e78a6a736)
    },
    {   UINT64_C(0x00000000000062c6), UINT64_C(0x1f42fe8e7cad86f3), UINT64_C(0x1f42f88ebcb72748),
        UINT64_C(0x1f43000fe8b346fe), UINT64_C(0x1f42fe4eb0b7e742)
    },
    {   UINT64_C(0x0000000000006174), UINT64_C(0x1f4303cedcb6a748), UINT64_C(0x1f4318ce4ca4a736),
        UINT64_C(0x1f4302ce98af2724), UINT64_C(0x1f43094e8cafe735)
    },
    {   UINT64_C(0x0000000000006175), UINT64_C(0x0000000000000000), UINT64_C(0x1f43028f34aa8738),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd8e64b2a729)
    },
    {   UINT64_C(0x0000000000006176), UINT64_C(0x1f43038e84acc736), UINT64_C(0x1f43098eacb30731),
        UINT64_C(0x1f431e0e60a4072d), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006177), UINT64_C(0x1f43034e50b9474c), UINT64_C(0x1f4302ce64b1e742),
        UINT64_C(0x1f43070eecad674c), UINT64_C(0x1f43108eb4b14733)
    },
    {   UINT64_C(0x0000000000006178), UINT64_C(0x0000000000000000), UINT64_C(0x1f43054eecad2721),
        UINT64_C(0x1f43044f14b72737), UINT64_C(0x1f430f0e50a9a73e)
    },
    {   UINT64_C(0x00000000000062cc), UINT64_C(0x1f42faced0b946ea), UINT64_C(0x1f42f54e60b6a71e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f59024b68712)
    },
    {   UINT64_C(0x000000000000617a), UINT64_C(0x1f43060e8caa0736), UINT64_C(0x1f43070e84b2e73a),
        UINT64_C(0x1f42fc4e74b94734), UINT64_C(0x1f430b0e70aae738)
    },
    {   UINT64_C(0x000000000000617b), UINT64_C(0x1f43174e70afc737), UINT64_C(0x1f4312ce4caee73b),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f430e0ee8aba739)
    },
    {   UINT64_C(0x000000000000617c), UINT64_C(0x1f43084ec4a46739), UINT64_C(0x1f42fbceccb08739),
        UINT64_C(0x1f4301cef0ae074c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000013857), UINT64_C(0x1302f28fa0800675), UINT64_C(0x1ad2f44fa0ae0675),
        UINT64_C(0x169af6cf5897a682), UINT64_C(0x1382f40f58922682)
    },
    {   UINT64_C(0x000000000000617e), UINT64_C(0x1f43088ef0b1e72e), UINT64_C(0x1f42fbce7cab0737),
        UINT64_C(0x1f43160e7ca5c739), UINT64_C(0x1f43098e4cb72739)
    },
    {   UINT64_C(0x0000000000008835), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x00027cd8303c66e0), UINT64_C(0x00027cd8303c66e0)
    },
    {   UINT64_C(0x0000000000008836), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x00027a97cc42e656)
    },
    {   UINT64_C(0x0000000000006181), UINT64_C(0x1f43008e6caea739), UINT64_C(0x1f42f9ce4cb6673d),
        UINT64_C(0x1f43044eacaa4735), UINT64_C(0x1f43028eacb5c736)
    },
    {   UINT64_C(0x0000000000006182), UINT64_C(0x0000000000000000), UINT64_C(0x1f43094e38ad0744),
        UINT64_C(0x1f430c8f3cb2c721), UINT64_C(0x1f43010ea4a8271e)
    },
    {   UINT64_C(0x0000000000006183), UINT64_C(0x1f430a8de4ade741), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006184), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff4ed0aa272b),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43000f18b28727)
    },
    {   UINT64_C(0x000000000000883b), UINT64_C(0x00027ccbb03c6371), UINT64_C(0x00027ccbb03c6371),
        UINT64_C(0x00027ccbb03c63c0), UINT64_C(0x00027ccbb03c63c0)
    },
    {   UINT64_C(0x0000000000006186), UINT64_C(0x1f430b0e20ae2741), UINT64_C(0x1f4318ce40ad2740),
        UINT64_C(0x1f43048e4cae6741), UINT64_C(0x1f4308ceb8ac0737)
    },
    {   UINT64_C(0x000000000001385c), UINT64_C(0x10b2f80f747c45a1), UINT64_C(0x13a2ef4c388805a1),
        UINT64_C(0x12e2f80c388645a1), UINT64_C(0x0a62f4cfa078e5a2)
    },
    {   UINT64_C(0x00000000000062db), UINT64_C(0x1f430ace70ac0725), UINT64_C(0x1f42f5cf1cb786e6),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbce4cb0e719)
    },
    {   UINT64_C(0x000000000001385d), UINT64_C(0x0fb2f68f747905a1), UINT64_C(0x0a1af30f78678661),
        UINT64_C(0x1262f80f6c840594), UINT64_C(0x0c5af94fa0784594)
    },
    {   UINT64_C(0x00000000000149ce), UINT64_C(0x1802f6cf849a46a3), UINT64_C(0x18c2f6cf689d26a9),
        UINT64_C(0x17baf6cfa099269c), UINT64_C(0x161af6cf6c9286a8)
    },
    {   UINT64_C(0x0000000000008841), UINT64_C(0x0000000000000000), UINT64_C(0x1a2afa0f68a1e68c),
        UINT64_C(0x0000000000000000), UINT64_C(0x12b2f50f6884a68c)
    },
    {   UINT64_C(0x0000000000008842), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1712f58c349345a1), UINT64_C(0x1f2afb4f64ba6697)
    },
    {   UINT64_C(0x00000000000149d1), UINT64_C(0x157af70fa08fe69c), UINT64_C(0x15c2f6cfa091269b),
        UINT64_C(0x158af6cfa090669c), UINT64_C(0x1892f68f689c66a9)
    },
    {   UINT64_C(0x0000000000008844), UINT64_C(0x1c0af48f64ad868b), UINT64_C(0x17d2f94f1897669f),
        UINT64_C(0x1d92f64f64b2e697), UINT64_C(0x121afa0f7485e697)
    },
    {   UINT64_C(0x0000000000008845), UINT64_C(0x0000000000000000), UINT64_C(0x15d2ff8fa08d067e),
        UINT64_C(0x1fa2efcf68b7468c), UINT64_C(0x17c2f78f6898c68c)
    },
    {   UINT64_C(0x00000000000149d4), UINT64_C(0x17d2f6cfa099669c), UINT64_C(0x17baf6cfa099269c),
        UINT64_C(0x17baf6cfa099269c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000010008), UINT64_C(0x07d2ee0fa03e83e8), UINT64_C(0x0a6af7cf74648683),
        UINT64_C(0x0d23121634748682), UINT64_C(0x0faaee8fa082068c)
    },
    {   UINT64_C(0x0000000000010009), UINT64_C(0x0fa2f60e3c7ca6c3), UINT64_C(0x179b020f5496a6aa),
        UINT64_C(0x1853010f5898e682), UINT64_C(0x06b30f16345ca682)
    },
    {   UINT64_C(0x000000000001000a), UINT64_C(0x0a6af88ccc65e685), UINT64_C(0x0a6af20cd062a685),
        UINT64_C(0x0fa30e139c7c0682), UINT64_C(0x151b038fa08845e2)
    },
    {   UINT64_C(0x00001a010009000b), UINT64_C(0x07d2eccd9c4f644d), UINT64_C(0x0a6afa52a061c4e7),
        UINT64_C(0x07d2f4cf744fc44c), UINT64_C(0x08b2ddcf586ec682)
    },
    {   UINT64_C(0x000000000000884b), UINT64_C(0x1db2f68f64af4697), UINT64_C(0x166af9cf4092e69f),
        UINT64_C(0x1a5af6cf5ca3868c), UINT64_C(0x139af58f7483c5a1)
    },
    {   UINT64_C(0x000000000001000d), UINT64_C(0x0fa2ee4fa07a668c), UINT64_C(0x0fa2f1cf847be682),
        UINT64_C(0x0fa2f58f847fa696), UINT64_C(0x0fa300cf8081a682)
    },
    {   UINT64_C(0x000000000001000e), UINT64_C(0x0fa2f58f847c268c), UINT64_C(0x0fa2f3cf5c7c068c),
        UINT64_C(0x0a6afa8f745f25a1), UINT64_C(0x0a6af48d9c5f25a1)
    },
    {   UINT64_C(0x000000000001000f), UINT64_C(0x151b030f788885ec), UINT64_C(0x151b03918088456a),
        UINT64_C(0x151b030f788885ec), UINT64_C(0x0fa30f0f70798680)
    },
    {   UINT64_C(0x04106c03c0010010), UINT64_C(0x1cc30b8f58a34682), UINT64_C(0x131ae14fa0850684),
        UINT64_C(0x131aec0fa0880675), UINT64_C(0x14dafe8f5894a682)
    },
    {   UINT64_C(0x0000000000008850), UINT64_C(0x1cdafd4b94acc6e3), UINT64_C(0x15baff0f6892068c),
        UINT64_C(0x117af14fa07b267e), UINT64_C(0x117af14fa07b267e)
    },
    {   UINT64_C(0x000000000000619b), UINT64_C(0x1f43021078b586ff), UINT64_C(0x1f42ff5030af46ed),
        UINT64_C(0x1f4301cff4b766d2), UINT64_C(0x1f42fe4e98a5e705)
    },
    {   UINT64_C(0x0d51760005010013), UINT64_C(0x1162ec0fa0846675), UINT64_C(0x1a0ae98fa0ab8675),
        UINT64_C(0x14dae90f64996675), UINT64_C(0x1692fd0f5895e683)
    },
    {   UINT64_C(0x1121ea0006f90014), UINT64_C(0x131aee0fa08a2675), UINT64_C(0x1692fcccc895e682),
        UINT64_C(0x131aeacfa0880675), UINT64_C(0x0fa2f24f587e0683)
    },
    {   UINT64_C(0x18f2bc5448d90015), UINT64_C(0x1162fccfa08da675), UINT64_C(0x1693078f589e2675),
        UINT64_C(0x131b010f58948675), UINT64_C(0x1a0affcf58afc675)
    },
    {   UINT64_C(0x0003dc728e010016), UINT64_C(0x131ae6cfa0906675), UINT64_C(0x1163018fa08da675),
        UINT64_C(0x1162ec8fa08a4675), UINT64_C(0x0c2af34d3c6f667f)
    },
    {   UINT64_C(0x0000000000010017), UINT64_C(0x08b2e3cf58666682), UINT64_C(0x0c2af10d3c6e467f),
        UINT64_C(0x0d32ee1454734682), UINT64_C(0x0fa2ee0dac7d039d)
    },
    {   UINT64_C(0x1f73e87c00010018), UINT64_C(0x0a6b0c1750656680), UINT64_C(0x0faaf24f747a05a1),
        UINT64_C(0x0fa2f3cf7479a693), UINT64_C(0x0de2f58f7473a5a1)
    },
    {   UINT64_C(0x2193fc7e40010019), UINT64_C(0x0fa2f1cf6c806693), UINT64_C(0x0de2f5cf747205a1),
        UINT64_C(0x08b2c94c6473868e), UINT64_C(0x0fa2f00c687965a1)
    },
    {   UINT64_C(0x22b0008a1131001a), UINT64_C(0x0fa2f2cf7c7a4693), UINT64_C(0x08b2fa4f745f8676),
        UINT64_C(0x08b2cf0c64616674), UINT64_C(0x0de2f18f74782693)
    },
    {   UINT64_C(0x00000000000062f7), UINT64_C(0x1f42fa8fccb4470e), UINT64_C(0x1f42fd5008b106f6),
        UINT64_C(0x1f43008fccb6e6e6), UINT64_C(0x1f42fe0f78ada6eb)
    },
    {   UINT64_C(0x2814a6945279001c), UINT64_C(0x0fc2db4c6c7985a1), UINT64_C(0x0fa2f44c5c7b05a1),
        UINT64_C(0x0c2af94fa07205a1), UINT64_C(0x0c2af20f6c6c45a2)
    },
    {   UINT64_C(0x0000000000008a42), UINT64_C(0x0ffafccd3077067e), UINT64_C(0x0ffafccd3077067e),
        UINT64_C(0x1cf2ffcd30a9467e), UINT64_C(0x1cf3000d30a9667e)
    },
    {   UINT64_C(0x00000000000062fa), UINT64_C(0x1f42fb0ed8b266df), UINT64_C(0x1f42fd4fb0ab66fe),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb8f30b44719)
    },
    {   UINT64_C(0x000000000001001f), UINT64_C(0x089b084f5853e682), UINT64_C(0x0c82ec4cdc6a2697),
        UINT64_C(0x10eaf8127c7d452b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008a45), UINT64_C(0x1cf2fbd084ab65aa), UINT64_C(0x1cf2fbd084ab65aa),
        UINT64_C(0x1cf2fbd084ab65a9), UINT64_C(0x1cf2fbd084ab65aa)
    },
    {   UINT64_C(0x0000000000008a46), UINT64_C(0x1cf2fa9084ac05aa), UINT64_C(0x1cf2fbd084ab65a9),
        UINT64_C(0x1cf2fbd084ab65a9), UINT64_C(0x1cf2fbd084ab65a9)
    },
    {   UINT64_C(0x0000000000008a47), UINT64_C(0x1cf2fbd084ab65a9), UINT64_C(0x1cf2fbd084ab65a9),
        UINT64_C(0x1cf2fbd084ab65a9), UINT64_C(0x1cf2fbd084ab65aa)
    },
    {   UINT64_C(0x0000000000008a48), UINT64_C(0x1cf2fbd084ab65aa), UINT64_C(0x1cf2fbcd30ab667e),
        UINT64_C(0x1cf2fbcd30aba67c), UINT64_C(0x1cf2fbcd30ab667e)
    },
    {   UINT64_C(0x0000000000008a49), UINT64_C(0x1cf2fbcd30ab667e), UINT64_C(0x1cf2fbcd30ab667e),
        UINT64_C(0x1cf2fbcd30ab667e), UINT64_C(0x1cf2fbcd30aba67e)
    },
    {   UINT64_C(0x0000000000008a4a), UINT64_C(0x1cf2fb4d30ab667e), UINT64_C(0x1cf2fb4d30ab667e),
        UINT64_C(0x1cf2fbcd30aba67e), UINT64_C(0x1cf2fbcd30ab667e)
    },
    {   UINT64_C(0x0000000000008a4b), UINT64_C(0x1cf2fbcd30ab667e), UINT64_C(0x1cf2fbcd30ab667e),
        UINT64_C(0x1cf2fbcd30ab667e), UINT64_C(0x1cf2fbcd30ab667e)
    },
    {   UINT64_C(0x0000000000008a4c), UINT64_C(0x1cf2fbcd38aba67e), UINT64_C(0x1cf2fb8d30ab467e),
        UINT64_C(0x1cf2fbcd30ab667e), UINT64_C(0x1cf2fbd084ab65a9)
    },
    {   UINT64_C(0x0000000000010028), UINT64_C(0x07d2ee0fa03e83e8), UINT64_C(0x0c2afccc6c66a5c2),
        UINT64_C(0x0fa3014d64798618), UINT64_C(0x0fa2f08f807f2686)
    },
    {   UINT64_C(0x0000000000010029), UINT64_C(0x0fa2e88f787fc5fe), UINT64_C(0x0fa2f50fa08a2675),
        UINT64_C(0x089b084f5853e682), UINT64_C(0x0fa2fb4d18782682)
    },
    {   UINT64_C(0x0000000000008a4f), UINT64_C(0x1cf2fcd0a0a9858f), UINT64_C(0x1cf2ff4f2caac58f),
        UINT64_C(0x1cf2ff4dd0a9861b), UINT64_C(0x1cf2ff4dd0a9861b)
    },
    {   UINT64_C(0x0000000000008a50), UINT64_C(0x1cf3050dd0a6c6fc), UINT64_C(0x1cf3050dd0a6c6fc),
        UINT64_C(0x1cf2fbce30ab663e), UINT64_C(0x1cf2fbce30ab663e)
    },
    {   UINT64_C(0x000000000001002c), UINT64_C(0x0c830755b86ee68c), UINT64_C(0x151b038fa0884620),
        UINT64_C(0x0962f653dc67068c), UINT64_C(0x0962f8d3d068e68c)
    },
    {   UINT64_C(0x000000000001002d), UINT64_C(0x0a6b1b175870e680), UINT64_C(0x0fa2e68c5c7ca594),
        UINT64_C(0x117afd0db48c2675), UINT64_C(0x07d2ff92bc55251e)
    },
    {   UINT64_C(0x2e5000000001002e), UINT64_C(0x0a6ae68c3c5543e8), UINT64_C(0x0962f8d3dc62068c),
        UINT64_C(0x09b2fed5f86bc68c), UINT64_C(0x0fa2fbd03476657b)
    },
    {   UINT64_C(0x0000000000008a54), UINT64_C(0x1cf2f790acad8506), UINT64_C(0x0ffaff4d3062867e),
        UINT64_C(0x1cf2fbd088ab65a8), UINT64_C(0x1cf2fbd088ab65a8)
    },
    {   UINT64_C(0x000000000000886f), UINT64_C(0x1ddafb9310af25d6), UINT64_C(0x1ddafb8fd0af2506),
        UINT64_C(0x0ffb258d3075a67e), UINT64_C(0x0ffaff4d3062867e)
    },
    {   UINT64_C(0x0000000000008870), UINT64_C(0x1ddafb9310af25d6), UINT64_C(0x1ddafb8fd0af2506),
        UINT64_C(0x0ffb258d3075a67e), UINT64_C(0x0ffaff4d3062867e)
    },
    {   UINT64_C(0x0000000000008871), UINT64_C(0x1cf2ffce30a9863e), UINT64_C(0x182af5cd309b467e),
        UINT64_C(0x1cf2ffce30a9863e), UINT64_C(0x1cf2ff8e30a9863f)
    },
    {   UINT64_C(0x0000000000008a58), UINT64_C(0x0ffafccd3076c67e), UINT64_C(0x0ffafccd3076c67e),
        UINT64_C(0x1cf2fbcf1cab6603), UINT64_C(0x156afc4d308d267e)
    },
    {   UINT64_C(0x0000000000008a59), UINT64_C(0x1cf2fbcf1cab6603), UINT64_C(0x156afc4d308d267e),
        UINT64_C(0x1cf2fbd180ab6603), UINT64_C(0x1cf2fbcf1cab656a)
    },
    {   UINT64_C(0x0000000000008a5a), UINT64_C(0x1cf2fbd180ab6603), UINT64_C(0x1cf2fbcf1cab656a),
        UINT64_C(0x1cf2fbd180ab6603), UINT64_C(0x1cf2fbcf1cab656a)
    },
    {   UINT64_C(0x0000000000013878), UINT64_C(0x0942fc0f786005b8), UINT64_C(0x0ec2f78fa07f25b8),
        UINT64_C(0x10c2f28f747d4693), UINT64_C(0x118aebcc448185ad)
    },
    {   UINT64_C(0x0000000000008a5c), UINT64_C(0x1cf2fbd180ab656a), UINT64_C(0x1cf2fbd084ab661d),
        UINT64_C(0x1cf2fbd084ab65e4), UINT64_C(0x1cf2fbcf98ab65a9)
    },
    {   UINT64_C(0x0000000000008a5d), UINT64_C(0x1cf2fbcf98ab65a9), UINT64_C(0x1cf2fbcd6cab65a9),
        UINT64_C(0x156afe0b348c2647), UINT64_C(0x1cf2f94f38ab65fc)
    },
    {   UINT64_C(0x0000000000008a5e), UINT64_C(0x156afe0b388c2648), UINT64_C(0x156afe0b888c265b),
        UINT64_C(0x1cf2f94f38ab65fc), UINT64_C(0x156afdcb888c065b)
    },
    {   UINT64_C(0x0000000000008a5f), UINT64_C(0x1cf30fcf8ca165e7), UINT64_C(0x1cf30fcf8ca165e7),
        UINT64_C(0x156b030e7489862d), UINT64_C(0x156b030e7489862d)
    },
    {   UINT64_C(0x0000000000008a60), UINT64_C(0x1293034cac7e269f), UINT64_C(0x11aaf98fd87f65cf),
        UINT64_C(0x0fbb098eb46fa61e), UINT64_C(0x12a3090c4c7a26b7)
    },
    {   UINT64_C(0x0000000000008a61), UINT64_C(0x12a30bcc4c7b86b7), UINT64_C(0x0e7aff8c4c6fa6b7),
        UINT64_C(0x0e7aff8c4c6fa6b7), UINT64_C(0x0ffb0acc486c66b7)
    },
    {   UINT64_C(0x000742001d01003d), UINT64_C(0x0fa2f4cf7479067d), UINT64_C(0x0fa2f4cf747c4658),
        UINT64_C(0x0fa2f4cf7479c646), UINT64_C(0x151b038f748845ed)
    },
    {   UINT64_C(0x000000000001003e), UINT64_C(0x0fa2f50d84792612), UINT64_C(0x0fa2f88f7479e680),
        UINT64_C(0x0fa2f88f7479e680), UINT64_C(0x0fa2f88f7479e67d)
    },
    {   UINT64_C(0x0000000000008a64), UINT64_C(0x0eaaf38c4c61a6b7), UINT64_C(0x0c83004c4c6b26b7),
        UINT64_C(0x0c83004c4c6b26b7), UINT64_C(0x156af68d64886671)
    },
    {   UINT64_C(0x0000000000008a65), UINT64_C(0x156b058d648fe671), UINT64_C(0x156b038d648ee671),
        UINT64_C(0x156af88d64896671), UINT64_C(0x0f431d0c4c78c6b7)
    },
    {   UINT64_C(0x0000000000010041), UINT64_C(0x131ae14cfc8cc684), UINT64_C(0x0faaf24cfc80a5a1),
        UINT64_C(0x14dafe8f5894a754), UINT64_C(0x0de2f58f74746680)
    },
    {   UINT64_C(0x0000000000010042), UINT64_C(0x14dafe8f5894a753), UINT64_C(0x0de2f58f7473e67d),
        UINT64_C(0x14dafe8f5894a71a), UINT64_C(0x0de2f58f7473a646)
    },
    {   UINT64_C(0x0000000000010043), UINT64_C(0x14dafe8f5894a753), UINT64_C(0x0de2f58f7479a67d),
        UINT64_C(0x1692ec0fa0960753), UINT64_C(0x130af1cf6c95a69b)
    },
    {   UINT64_C(0x0000000000010044), UINT64_C(0x1692ec0fa0960675), UINT64_C(0x0fa2f1cf6c870693),
        UINT64_C(0x131aedcfa08dc6dd), UINT64_C(0x0de2f5cf7478c606)
    },
    {   UINT64_C(0x0000000000010045), UINT64_C(0x131aedcfa08dc74a), UINT64_C(0x0de2f5cf74796672),
        UINT64_C(0x131aedcfa08dc71a), UINT64_C(0x0de2f5cf74720646)
    },
    {   UINT64_C(0x00000000000061cf), UINT64_C(0x1f42f94f38b3e714), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc0f04b6c6ee), UINT64_C(0x1f42f64facb7e70a)
    },
    {   UINT64_C(0x0000000000010047), UINT64_C(0x1692fb0f5898c755), UINT64_C(0x0fa2f00c6879667d),
        UINT64_C(0x1692fb0f5898c74a), UINT64_C(0x0fa2f00c687a0672)
    },
    {   UINT64_C(0x0000000000010048), UINT64_C(0x1692fb0f5898c71a), UINT64_C(0x0fa2f00c68796646),
        UINT64_C(0x1692fb0b7498c682), UINT64_C(0x0fa2f00c687966bc)
    },
    {   UINT64_C(0x0000000000010049), UINT64_C(0x1692ec0fa09ea753), UINT64_C(0x0fa2f2cf7c7a4753),
        UINT64_C(0x1692ec0fa09ea675), UINT64_C(0x0fa2f2cf7c7a4693)
    },
    {   UINT64_C(0x0000000000006326), UINT64_C(0x1f42f84f74b36721), UINT64_C(0x1f42fd8f08b1a6f1),
        UINT64_C(0x1f43010e9cb1c6f8), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006327), UINT64_C(0x1f43000e6cb7e730), UINT64_C(0x1f4315cee8a30707),
        UINT64_C(0x1f431acea0a00738), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008a71), UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x1c72f94d28aaa67e),
        UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x1c72f94d28aaa67e)
    },
    {   UINT64_C(0x000000000001004d), UINT64_C(0x0de2ec8f58818755), UINT64_C(0x08b2cf0c646aa67d),
        UINT64_C(0x14daefcb7498c675), UINT64_C(0x0de2f18b74782693)
    },
    {   UINT64_C(0x000000000001004e), UINT64_C(0x10f2ef4fa089a5b3), UINT64_C(0x1162ec0fa0846754),
        UINT64_C(0x08b2f84f746a0754), UINT64_C(0x1162ec0b74846675)
    },
    {   UINT64_C(0x0000000000008a74), UINT64_C(0x1acb020f3ca3a5fb), UINT64_C(0x1953054e6098062e),
        UINT64_C(0x1953054e6098062e), UINT64_C(0x1953054e6098062e)
    },
    {   UINT64_C(0x0000000000008a75), UINT64_C(0x1953058e6098262e), UINT64_C(0x1953054e6098062e),
        UINT64_C(0x1953008e109a8642), UINT64_C(0x1953008e109a8642)
    },
    {   UINT64_C(0x0000000000008a76), UINT64_C(0x0ffb1a4dd0684654), UINT64_C(0x0ffb1a0dd0682654),
        UINT64_C(0x15831a4dd07e6654), UINT64_C(0x15831a4dd07e6654)
    },
    {   UINT64_C(0x0000000000010052), UINT64_C(0x0fa2f18f7c79e67d), UINT64_C(0x120afc8f7c82069b),
        UINT64_C(0x1692ec0f58960682), UINT64_C(0x0fa2f18c6075c5a1)
    },
    {   UINT64_C(0x0000000000008a78), UINT64_C(0x1c72f94d2caaa67e), UINT64_C(0x14daf40f808b25e8),
        UINT64_C(0x18b2fe0fa0994586), UINT64_C(0x156af9cd308e267e)
    },
    {   UINT64_C(0x0000000000008a79), UINT64_C(0x156af9cd308e2732), UINT64_C(0x156afa0d308e267e),
        UINT64_C(0x18f2fd0e689ac630), UINT64_C(0x13a2fa0cac87069f)
    },
    {   UINT64_C(0x0000000000008a7a), UINT64_C(0x23caf6cda4c94713), UINT64_C(0x23caf6cda4c94713),
        UINT64_C(0x17d2f60bdc99c6d0), UINT64_C(0x18b2f94b1c9ba703)
    },
    {   UINT64_C(0x0000000000008a7b), UINT64_C(0x17d2fa8bdc9786cf), UINT64_C(0x17d2fa8bdc9786cf),
        UINT64_C(0x17d3064bd491a6d3), UINT64_C(0x17d3064bd491a6d3)
    },
    {   UINT64_C(0x0000000000008a7c), UINT64_C(0x17d2f60bd499c6d3), UINT64_C(0x17d2f60bd499c6d3),
        UINT64_C(0x17d2fe4bd495a6d3), UINT64_C(0x17d2fe4bd495a6d3)
    },
    {   UINT64_C(0x0000000000008a7d), UINT64_C(0x1cf2fbcf6cab65f1), UINT64_C(0x105af98c287a46ae),
        UINT64_C(0x1043058e6073c6e5), UINT64_C(0x1043058e6073c67e)
    },
    {   UINT64_C(0x0000000000010059), UINT64_C(0x1162fccfa08da753), UINT64_C(0x08b2f78f7477269d),
        UINT64_C(0x1162fccfa08da675), UINT64_C(0x08b2f50f7463860a)
    },
    {   UINT64_C(0x0000000000008a7f), UINT64_C(0x0e5b014c4c6fc6b1), UINT64_C(0x0e5afe4c4c6e46b1),
        UINT64_C(0x17d3054f10922604), UINT64_C(0x17d3055298922524)
    },
    {   UINT64_C(0x0000000000008a80), UINT64_C(0x2332fb4b94c4a6e3), UINT64_C(0x2332fb4b94c4a6e3),
        UINT64_C(0x2332fb4b94c4a6e3), UINT64_C(0x1ce3058b80a646e8)
    },
    {   UINT64_C(0x000000000001005c), UINT64_C(0x1693078f589e2754), UINT64_C(0x0fa2f88f747e6680),
        UINT64_C(0x1693078cfc9e2675), UINT64_C(0x0fa2f88cfc81c5a1)
    },
    {   UINT64_C(0x000000000001005d), UINT64_C(0x1a0affcf58afc755), UINT64_C(0x14daf1cf588f867d),
        UINT64_C(0x1163018fa08da755), UINT64_C(0x0de2e80c6873c67d)
    },
    {   UINT64_C(0x000000000001005e), UINT64_C(0x1163018fa08da71a), UINT64_C(0x1162ec8fa08a4754),
        UINT64_C(0x0c2aed8e5c6f4680), UINT64_C(0x1162ec8fa08a471a)
    },
    {   UINT64_C(0x000000000001005f), UINT64_C(0x0c2aed8e5c6e0646), UINT64_C(0x1162ec8fa08a4753),
        UINT64_C(0x0c2aed8e5c73c67f), UINT64_C(0x0bfaf14fa07ea693)
    },
    {   UINT64_C(0x0000000000010060), UINT64_C(0x0fa2f3cf7479a693), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001118e), UINT64_C(0x15f3110f68a0e5ad), UINT64_C(0x0f12f58fa08285ad),
        UINT64_C(0x0f22e94c408525ad), UINT64_C(0x0dfaf44fa07f25ad)
    },
    {   UINT64_C(0x0000000000010062), UINT64_C(0x0fa2f58f7486a60c), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008a88), UINT64_C(0x24cb068da4c56661), UINT64_C(0x111b23caf079870d),
        UINT64_C(0x156afa0efc8e071b), UINT64_C(0x156afa0efc8e06ab)
    },
    {   UINT64_C(0x0000000000010064), UINT64_C(0x14dafe8f88926694), UINT64_C(0x0000000000000000),
        UINT64_C(0x0ec2de8d247c46aa), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000010065), UINT64_C(0x0000000000000000), UINT64_C(0x1502f2cf78904693),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008a8b), UINT64_C(0x156afa0f8c8e25e7), UINT64_C(0x16a2fa8dc492c657),
        UINT64_C(0x16a2fa8dc492c657), UINT64_C(0x0f52fa908c7565a7)
    },
    {   UINT64_C(0x0000000000010067), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0fa2f18bfc75c5a1), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000010068), UINT64_C(0x1692fd0f58a0669b), UINT64_C(0x10b2f4cf748765bb),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008a8e), UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x23caf6cda4c94713),
        UINT64_C(0x23caf6cda4c94713), UINT64_C(0x23caf6cda4c94713)
    },
    {   UINT64_C(0x00000000000088a9), UINT64_C(0x156afa0fa08e267e), UINT64_C(0x156afa0fa08e267e),
        UINT64_C(0x0f8afe0fa074a67e), UINT64_C(0x0f92fe0fa074c67e)
    },
    {   UINT64_C(0x0000000000008a90), UINT64_C(0x1362fa0f24860600), UINT64_C(0x1362fa0f24860600),
        UINT64_C(0x1362fa0f24860684), UINT64_C(0x1362fa0f24860684)
    },
    {   UINT64_C(0x0000000000008a91), UINT64_C(0x1362fa0f24860600), UINT64_C(0x1362fa0f24860600),
        UINT64_C(0x1362fa094886077a), UINT64_C(0x1362fa094886077a)
    },
    {   UINT64_C(0x0000000000008a92), UINT64_C(0x1362fa094886077a), UINT64_C(0x1362fa094886077a),
        UINT64_C(0x21b2fa0f04bf45f8), UINT64_C(0x21b2fa0f00bf45f7)
    },
    {   UINT64_C(0x0000000000008a93), UINT64_C(0x1362f08f248ac642), UINT64_C(0x1362f08e1c8ac600),
        UINT64_C(0x1362fa0f24860600), UINT64_C(0x1362fa0f24860600)
    },
    {   UINT64_C(0x000000000001006f), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0fa2f9cf70772603), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000010070), UINT64_C(0x0552f1cfa05ec6c8), UINT64_C(0x0912f1cfa06de6c8),
        UINT64_C(0x0aa2f1cfa07426c8), UINT64_C(0x0a6af7cf74648683)
    },
    {   UINT64_C(0x0000000000008a96), UINT64_C(0x1612f3cf2c898600), UINT64_C(0x1362f5ce6c882631),
        UINT64_C(0x1362f5cf2c882600), UINT64_C(0x1362f5cf2c882600)
    },
    {   UINT64_C(0x0000000000008a97), UINT64_C(0x1362f5cf2c882600), UINT64_C(0x1362f5cf2c882600),
        UINT64_C(0x1362f5cf2c882704), UINT64_C(0x1362f58d74884600)
    },
    {   UINT64_C(0x0000000000008a98), UINT64_C(0x1362f58b1c884600), UINT64_C(0x1362f94fa08665c7),
        UINT64_C(0x1362f58f2c88470e), UINT64_C(0x1362f58b1c884600)
    },
    {   UINT64_C(0x0000000000008a99), UINT64_C(0x209aff8b30bc86ff), UINT64_C(0x209aff8b30bc86ff),
        UINT64_C(0x156afa0dfc8e256a), UINT64_C(0x156afa10108e26a7)
    },
    {   UINT64_C(0x0000000000008a9a), UINT64_C(0x156afa0cac8e269f), UINT64_C(0x156afa0d308e267e),
        UINT64_C(0x156afa11f08e25f1), UINT64_C(0x156afa0f6c8e25f1)
    },
    {   UINT64_C(0x0000000000008a9b), UINT64_C(0x156afa0f088e2607), UINT64_C(0x156afa0f348e26a7),
        UINT64_C(0x156afa11808e2737), UINT64_C(0x156afa10048e26ab)
    },
    {   UINT64_C(0x0000000000008a9c), UINT64_C(0x156afa0d588e2672), UINT64_C(0x156afa0d6c8e2670),
        UINT64_C(0x156afa0d6c8e2670), UINT64_C(0x156afa0f348e25fc)
    },
    {   UINT64_C(0x0000000000008a9d), UINT64_C(0x1fbafa1104b76589), UINT64_C(0x1f2afa1180b5256a),
        UINT64_C(0x2ce2fa1180ec056a), UINT64_C(0x156afa0df88e264b)
    },
    {   UINT64_C(0x0000000000006355), UINT64_C(0x1f42fe8fd8b3e707), UINT64_C(0x1f430a4f30b6c6f3),
        UINT64_C(0x1f43030f48aaa71b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008a9f), UINT64_C(0x156b010f388ea70e), UINT64_C(0x156afc0d7c8c2659),
        UINT64_C(0x156afc0d7c8c2659), UINT64_C(0x156afd0d7c8ca659)
    },
    {   UINT64_C(0x0000000000008aa0), UINT64_C(0x156afd0d7c8ca659), UINT64_C(0x156afd0d7c8ca659),
        UINT64_C(0x156afd0d7c8ca659), UINT64_C(0x156afd0d7c8ca6f1)
    },
    {   UINT64_C(0x0000000000008aa1), UINT64_C(0x156afd0d7c8ca6f1), UINT64_C(0x156afa0b548e26d2),
        UINT64_C(0x156afa0b548e26d2), UINT64_C(0x156afd0c408ca65c)
    },
    {   UINT64_C(0x0000000000008aa2), UINT64_C(0x157afc0c408c265c), UINT64_C(0x156afa0acc8e26d2),
        UINT64_C(0x156afa0acc8e26d2), UINT64_C(0x156afc09008c278a)
    },
    {   UINT64_C(0x0000000000008aa3), UINT64_C(0x156afc09008c278a), UINT64_C(0x156afa0ce08e26d2),
        UINT64_C(0x156afa0ce08e26d2), UINT64_C(0x156afd09fc8fa74b)
    },
    {   UINT64_C(0x000000000001007f), UINT64_C(0x1bcae74fa0b06754), UINT64_C(0x14daf3cf748e8680),
        UINT64_C(0x1692fd0dfc95e754), UINT64_C(0x0fa2f50d84792680)
    },
    {   UINT64_C(0x0000000000008aa5), UINT64_C(0x156afd09fc8ca74a), UINT64_C(0x156afc0db88c2668),
        UINT64_C(0x156afc0db88c2668), UINT64_C(0x156afc0db88c2668)
    },
    {   UINT64_C(0x0000000000008aa6), UINT64_C(0x156afc0db88c2668), UINT64_C(0x156afd0c548ca6b6),
        UINT64_C(0x156afd0c548ca6b6), UINT64_C(0x156afd0c308ca6be)
    },
    {   UINT64_C(0x0000000000008aa7), UINT64_C(0x156afd0c308ca6be), UINT64_C(0x156afb4d108ec680),
        UINT64_C(0x156af8cd108d8680), UINT64_C(0x156afa0b748e26ee)
    },
    {   UINT64_C(0x000000000000635f), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb0f78b3e725),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008aa9), UINT64_C(0x1872fd0f3898c5fc), UINT64_C(0x1abafd0f38a1e5fc),
        UINT64_C(0x156af6cf388ca5fc), UINT64_C(0x156afd0f388fc5fc)
    },
    {   UINT64_C(0x0000000000006361), UINT64_C(0x1f42fbcf10af4706), UINT64_C(0x1f42f74f1cb7e721),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008aab), UINT64_C(0x156afd0e048ca64d), UINT64_C(0x156afd0e048ca64d),
        UINT64_C(0x156afa10108e261b), UINT64_C(0x156afe0e048c2649)
    },
    {   UINT64_C(0x0000000000006210), UINT64_C(0x1f42fdd068b606d0), UINT64_C(0x1f430f8ec8b12716),
        UINT64_C(0x1f42fcd058b446e0), UINT64_C(0x1f42f90f18b126da)
    },
    {   UINT64_C(0x0000000000008aad), UINT64_C(0x156afd0c548ca6b5), UINT64_C(0x156afe4b908c46d3),
        UINT64_C(0x156afe4b908c46d3), UINT64_C(0x156afa0b548e26d3)
    },
    {   UINT64_C(0x0000000000008aae), UINT64_C(0x156afa0b548e26d3), UINT64_C(0x156afa0acc8e26d3),
        UINT64_C(0x156afa0acc8e26d3), UINT64_C(0x1d2af44f38b005fc)
    },
    {   UINT64_C(0x0000000000006213), UINT64_C(0x1f42fe4eccb68714), UINT64_C(0x1f42f38efcb70708),
        UINT64_C(0x1f42f68e6cb6a6f2), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008ab0), UINT64_C(0x156afd0e048ca647), UINT64_C(0x156afd0e048ca647),
        UINT64_C(0x156afd0e048ca647), UINT64_C(0x156afd0e048ca6ad)
    },
    {   UINT64_C(0x0000000000008ab1), UINT64_C(0x156afd0e048ca6ad), UINT64_C(0x156afe0c548c46b5),
        UINT64_C(0x156afe4c548c66b5), UINT64_C(0x156afd0d108ca681)
    },
    {   UINT64_C(0x000000000001008d), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x08b2cf0c645d45a1)
    },
    {   UINT64_C(0x0000000000006217), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f68ed8b7071a),
        UINT64_C(0x1f42f88f2cb6672a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006218), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f84efcb6c719),
        UINT64_C(0x1f42f88eccb76727), UINT64_C(0x1f42fb8edcb5272a)
    },
    {   UINT64_C(0x000000000000636c), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f84ea8b1e70d),
        UINT64_C(0x1f42f7cea8b5a715), UINT64_C(0x1f4302101cb76703)
    },
    {   UINT64_C(0x000000000000621a), UINT64_C(0x1f43008e9cb6e734), UINT64_C(0x1f42f98ee8b906ef),
        UINT64_C(0x1f42f58ef8b846f3), UINT64_C(0x1f42fb8ec4aaa70f)
    },
    {   UINT64_C(0x0000000000008ab7), UINT64_C(0x1362f0cf78860615), UINT64_C(0x1362fa0f78860615),
        UINT64_C(0x0f8afe0fa074a67e), UINT64_C(0x156afa0fa08e255b)
    },
    {   UINT64_C(0x0000000000008ab8), UINT64_C(0x156afa0fa08e255b), UINT64_C(0x156afa0fa08e267e),
        UINT64_C(0x156afd0fa08ca67e), UINT64_C(0x1ae2f98fa0a2e67e)
    },
    {   UINT64_C(0x0000000000010094), UINT64_C(0x0de2f2cf787325b4), UINT64_C(0x0ffaf24f787b65b4),
        UINT64_C(0x0ffaf24f787b65b4), UINT64_C(0x0fa2f3cf747b8693)
    },
    {   UINT64_C(0x0000000000010095), UINT64_C(0x0de2f58f7473a5a1), UINT64_C(0x0de2ed4d2073a5a1),
        UINT64_C(0x0fa2f1cbfc806693), UINT64_C(0x0fa2f1cf6c9c0693)
    },
    {   UINT64_C(0x0000000000006372), UINT64_C(0x1f42fc8ec4b70715), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f91038b7070c)
    },
    {   UINT64_C(0x0000000000010097), UINT64_C(0x0f02f5cf687665c3), UINT64_C(0x14d2f5cf6891c5c3),
        UINT64_C(0x0f52f58f6877c5c3), UINT64_C(0x0b2ad50c646905a1)
    },
    {   UINT64_C(0x0000000000006374), UINT64_C(0x1f42f61010b806d3), UINT64_C(0x1f4300cf90b38722),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f990a0b3470d)
    },
    {   UINT64_C(0x0000000000006222), UINT64_C(0x1f43070ebcb6c738), UINT64_C(0x1f42fe4f74b22706),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4309ce68b7a725)
    },
    {   UINT64_C(0x000000000001009a), UINT64_C(0x08b2f20f745f8676), UINT64_C(0x0a6afacf785fc5ae),
        UINT64_C(0x07baec0fa063c5a1), UINT64_C(0x08b2ef0f7467e693)
    },
    {   UINT64_C(0x0000000000006377), UINT64_C(0x1f42fe0fd0b306ec), UINT64_C(0x1f42ffd044b306ca),
        UINT64_C(0x1f43044fbcaf06f2), UINT64_C(0x1f42fc0f50b826f6)
    },
    {   UINT64_C(0x0000000000006225), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc8fb4b5c6fd),
        UINT64_C(0x1f42fb4f54b0e6f3), UINT64_C(0x1f42f68ea0b5c716)
    },
    {   UINT64_C(0x00000000000088dc), UINT64_C(0x18d2fbcce09ae6d7), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000637a), UINT64_C(0x1f42f98ea4b9a73f), UINT64_C(0x1f42fbce80b1a715),
        UINT64_C(0x1f42fecf24b46721), UINT64_C(0x1f4301cebcb1c713)
    },
    {   UINT64_C(0x0000000000006228), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb8f34b54709),
        UINT64_C(0x1f42fb8ea8b26721), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000088df), UINT64_C(0x1b3afa8c30a50630), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000100a1), UINT64_C(0x0e2ad28bfc88e693), UINT64_C(0x0a9b01cbfc6ae5be),
        UINT64_C(0x0dbade8bd489c693), UINT64_C(0x0a52f78e1c6385b4)
    },
    {   UINT64_C(0x00000000000138ae), UINT64_C(0x116afb0c388686dc), UINT64_C(0x0000000000000000),
        UINT64_C(0x10a2f2cc388f66dc), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000622c), UINT64_C(0x1f42f50e94b80734), UINT64_C(0x1f42f98f44b6a6f2),
        UINT64_C(0x1f430d0e80af0725), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008ac9), UINT64_C(0x25baff8b38cca6f9), UINT64_C(0x185af94e209a462d),
        UINT64_C(0x185af94e209a462d), UINT64_C(0x1102f80dfc7d8649)
    },
    {   UINT64_C(0x00000000000100a5), UINT64_C(0x0fa2fbcfa07e2693), UINT64_C(0x0fa2fbcfa07c6693),
        UINT64_C(0x0c4ae7cf6872267e), UINT64_C(0x0e12f40be877e5a1)
    },
    {   UINT64_C(0x00000000000088e5), UINT64_C(0x1cf2f40da4af4661), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000100a7), UINT64_C(0x11e2f44fa09265b8), UINT64_C(0x0c9ada0bfc6fc674),
        UINT64_C(0x0e7af48ba479a59f), UINT64_C(0x0eb2f44fa079a5b8)
    },
    {   UINT64_C(0x00000000000100a8), UINT64_C(0x0f02f44c5c91c62e), UINT64_C(0x0fa2fbcfa07e2693),
        UINT64_C(0x0fa2fbcfa07c6693), UINT64_C(0x173af1cf6c9b2693)
    },
    {   UINT64_C(0x00000000000100a9), UINT64_C(0x173af1cbfca00693), UINT64_C(0x1792f1cee49b2693),
        UINT64_C(0x0fa2f78f747fe60a), UINT64_C(0x102ae60bfc906693)
    },
    {   UINT64_C(0x00000000000100aa), UINT64_C(0x13c2f78f608b060a), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008ad0), UINT64_C(0x1cf2fbd084ab661d), UINT64_C(0x1cf2fbd084ab65e4),
        UINT64_C(0x1cf2fbcd6cab65a9), UINT64_C(0x1cf2f94f38ab65fc)
    },
    {   UINT64_C(0x00000000000100ac), UINT64_C(0x0bd2efd4b86f672e), UINT64_C(0x0bd2efd4b872472e),
        UINT64_C(0x0962f912bc6a473b), UINT64_C(0x0a02ee950466869a)
    },
    {   UINT64_C(0x0000000000006389), UINT64_C(0x1f42fa8e8cb5e726), UINT64_C(0x1f42ff0ef0b4c706),
        UINT64_C(0x1f42fdcebcb5470c), UINT64_C(0x1f42f70fb4b806de)
    },
    {   UINT64_C(0x0000000000003c41), UINT64_C(0x106aee134c800511), UINT64_C(0x106b26d72892e637),
        UINT64_C(0x106b0e97286f8637), UINT64_C(0x106b0b171867a64a)
    },
    {   UINT64_C(0x0000000000003c42), UINT64_C(0x106ae60f48844661), UINT64_C(0x106affcfa0770463),
        UINT64_C(0x106b03d2bc750584), UINT64_C(0x106afe176877e64b)
    },
    {   UINT64_C(0x00000000000100b0), UINT64_C(0x0a32f5943c64e69a), UINT64_C(0x0a32f3d43c69669a),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000003c44), UINT64_C(0x0000000000000000), UINT64_C(0x106adb4bfc8986a9),
        UINT64_C(0x106b1e971871664b), UINT64_C(0x106b03d2847504de)
    },
    {   UINT64_C(0x0000000000003c45), UINT64_C(0x106b19d2846a24de), UINT64_C(0x106af8cfa0762597),
        UINT64_C(0x106b018fa07a8597), UINT64_C(0x106b04d15c74a568)
    },
    {   UINT64_C(0x000000000000638f), UINT64_C(0x1f42fa4ee4b28709), UINT64_C(0x1f42fa4fa4aec6fa),
        UINT64_C(0x1f42fa4f90b386de), UINT64_C(0x1f42fa0f7cb7c6c0)
    },
    {   UINT64_C(0x00000000000088f3), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1cf2fa8c1ca986c3), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000088f4), UINT64_C(0x0ffb25913462857d), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000100b6), UINT64_C(0x0a6b0b575072c672), UINT64_C(0x0a6b21d79064a646),
        UINT64_C(0x0a6b14d7906ae6ab), UINT64_C(0x0a6ae90cfc578410)
    },
    {   UINT64_C(0x00000000000100b7), UINT64_C(0x0a6b0717b473e658), UINT64_C(0x0a6b0557587b4680),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000100b8), UINT64_C(0x09daf3d308686694), UINT64_C(0x06e2f854d459472d),
        UINT64_C(0x0962f214dc62c69b), UINT64_C(0x0be2ef14d46de69b)
    },
    {   UINT64_C(0x0000000000006395), UINT64_C(0x1f43000e40b00729), UINT64_C(0x1f42fbce7cb2470a),
        UINT64_C(0x1f42f78ef4b8a72b), UINT64_C(0x1f42fb4f3cb7e70a)
    },
    {   UINT64_C(0x0000000000006243), UINT64_C(0x1f42f98e8cb5a704), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43044e58b60739), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000003c4e), UINT64_C(0x106aee0c1c8043e8), UINT64_C(0x106aee1720800667),
        UINT64_C(0x106aee17fc80063e), UINT64_C(0x106afc8f7478a5a2)
    },
    {   UINT64_C(0x0000000000003c4f), UINT64_C(0x106afc8f7478a5a2), UINT64_C(0x106aee5720800667),
        UINT64_C(0x106af68fa07bc673), UINT64_C(0x106af5cfa07c0672)
    },
    {   UINT64_C(0x0000000000006399), UINT64_C(0x1f42f78fa4b88706), UINT64_C(0x1f42f78f48b406fe),
        UINT64_C(0x1f42f64e90ada71a), UINT64_C(0x1f42fece48ad6717)
    },
    {   UINT64_C(0x000000000000639a), UINT64_C(0x0000000000000000), UINT64_C(0x1f43060e58b40733),
        UINT64_C(0x1f43000e9cb3c71a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000003c52), UINT64_C(0x106af14c1476a59c), UINT64_C(0x106afd0f8c788651),
        UINT64_C(0x106aec4c1481059c), UINT64_C(0x106ae58f1484840b)
    },
    {   UINT64_C(0x0000000000003c53), UINT64_C(0x106ae58f188484a3), UINT64_C(0x106ae58f1884853c),
        UINT64_C(0x106ae58f188485d5), UINT64_C(0x106ae58f1884866e)
    },
    {   UINT64_C(0x0000000000003c54), UINT64_C(0x106ae58f188484a3), UINT64_C(0x106ae58f1884853c),
        UINT64_C(0x106ae58f188485d5), UINT64_C(0x106ae58f1884866e)
    },
    {   UINT64_C(0x0000000000003c55), UINT64_C(0x106ae58f1484840b), UINT64_C(0x106ae58f188484a3),
        UINT64_C(0x106ae58f1884853c), UINT64_C(0x106ae58f188485d5)
    },
    {   UINT64_C(0x0000000000003c56), UINT64_C(0x106ae58f1884866e), UINT64_C(0x106ae58f188484a3),
        UINT64_C(0x106ae58f1884853c), UINT64_C(0x106ae58f188485d5)
    },
    {   UINT64_C(0x0000000000003c57), UINT64_C(0x106ae58f1884866e), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x106b05969075264b)
    },
    {   UINT64_C(0x0000000000003c58), UINT64_C(0x106b03d69074464b), UINT64_C(0x106af6d7147ba64b),
        UINT64_C(0x106af6d7147ba64b), UINT64_C(0x106b03d71872a64b)
    },
    {   UINT64_C(0x0000000000003c59), UINT64_C(0x106b08d71875264b), UINT64_C(0x106af58c287ac59c),
        UINT64_C(0x106aee8f8c79864b), UINT64_C(0x106af14c107ae64b)
    },
    {   UINT64_C(0x0000000000003c5a), UINT64_C(0x106af30f807da59f), UINT64_C(0x106af3cf8c7d05b2),
        UINT64_C(0x106af74fa07b459f), UINT64_C(0x106b26cf1863a66e)
    },
    {   UINT64_C(0x00000000000063a4), UINT64_C(0x1f42f68ee8b88739), UINT64_C(0x1f42fc0e8cb5c71b),
        UINT64_C(0x1f42fc0ebcb6a726), UINT64_C(0x1f42fd0ed4b36718)
    },
    {   UINT64_C(0x0000000000008908), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0fa2f80dc07803f8)
    },
    {   UINT64_C(0x0000000000003c5d), UINT64_C(0x106afccfa078a64b), UINT64_C(0x106af6cf8c7e859c),
        UINT64_C(0x106af60f8c7d859f), UINT64_C(0x106af68f747ba596)
    },
    {   UINT64_C(0x00000000000063a7), UINT64_C(0x1f42fc0ee4b1c71a), UINT64_C(0x1f42fb4ed0b06710),
        UINT64_C(0x1f42fe0e88b52715), UINT64_C(0x1f42fb0ea0b66738)
    },
    {   UINT64_C(0x00000000000063a8), UINT64_C(0x1f4310ce3cad273f), UINT64_C(0x1f42f84e6cb0e700),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fdce3cb1c704)
    },
    {   UINT64_C(0x00000000000063a9), UINT64_C(0x1f42f7cec0b46728), UINT64_C(0x1f42f9ce9cb52730),
        UINT64_C(0x1f42f80e58b4c70e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000003c61), UINT64_C(0x106aed0fa080a64b), UINT64_C(0x106af34fa07fa59c),
        UINT64_C(0x0000000000000000), UINT64_C(0x106aee0f74802656)
    },
    {   UINT64_C(0x00000000000063ab), UINT64_C(0x1f42fdced8aae720), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fecf40b2070d)
    },
    {   UINT64_C(0x0000000000003c63), UINT64_C(0x106afb0ca0796596), UINT64_C(0x106af8cca07a85a2),
        UINT64_C(0x106afc8e9c78c64b), UINT64_C(0x106afc8f8c78c64b)
    },
    {   UINT64_C(0x0000000000003c64), UINT64_C(0x106b0c8f7470c657), UINT64_C(0x106afb0f74798656),
        UINT64_C(0x106af5cfa07b664b), UINT64_C(0x106b060c287b864b)
    },
    {   UINT64_C(0x00000000000063ae), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f90f58b2e725), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063af), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f88eb4b3e707),
        UINT64_C(0x1f42f4cf58b80725), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000003c67), UINT64_C(0x106af88fa07aa59f), UINT64_C(0x106afb4fa07b2596),
        UINT64_C(0x106af70fa07b6596), UINT64_C(0x106af84fa078e596)
    },
    {   UINT64_C(0x00000000000063b1), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f88eb8b6470f),
        UINT64_C(0x1f4303cf04b0a710), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000003c69), UINT64_C(0x106b13d72c6d065d), UINT64_C(0x106b03d71c71c64b),
        UINT64_C(0x106b03572c75466c), UINT64_C(0x106afa4c1063440a)
    },
    {   UINT64_C(0x0000000000003c6a), UINT64_C(0x106b278c1079c40a), UINT64_C(0x106b0b0a6c718369),
        UINT64_C(0x106affca4877036b), UINT64_C(0x106b04d2dc74a4f3)
    },
    {   UINT64_C(0x0000000000003c6b), UINT64_C(0x106b04d15c74a568), UINT64_C(0x106b0b0a6c716368),
        UINT64_C(0x106b0ac9f4716369), UINT64_C(0x106af80afc7b236e)
    },
    {   UINT64_C(0x0000000000003c6c), UINT64_C(0x106aef4a047f43e0), UINT64_C(0x106af0968883a672),
        UINT64_C(0x106b11d72c6dc656), UINT64_C(0x106b12572c6e0656)
    },
    {   UINT64_C(0x0000000000008919), UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c),
        UINT64_C(0x1562ee0f6894068c), UINT64_C(0x1562ee0f6894068c)
    },
    {   UINT64_C(0x000000000000891a), UINT64_C(0x1562ee0f6894068c), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000138cb), UINT64_C(0x132af88c388b06dc), UINT64_C(0x0000000000000000),
        UINT64_C(0x129ae24c388f06dc), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063b9), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80eb0ad070b),
        UINT64_C(0x1f42f7cebcb7a70b), UINT64_C(0x1f42facebcb3070b)
    },
    {   UINT64_C(0x000000000000e9e4), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x180af4cf549a469b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063bb), UINT64_C(0x1f430d8e5cb1871d), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f6cebcb6c722), UINT64_C(0x1f42fe8e9cb2e70b)
    },
    {   UINT64_C(0x00000000000138cd), UINT64_C(0x0ef2f54c387be6dc), UINT64_C(0x0000000000000000),
        UINT64_C(0x0dc2f0cc387ac6dc), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063bd), UINT64_C(0x1f42fcce9cb0e70e), UINT64_C(0x1f42f5ceccb3870b),
        UINT64_C(0x1f42f9cf64b4670b), UINT64_C(0x1f42f8cebcb5a70b)
    },
    {   UINT64_C(0x00000000000100e2), UINT64_C(0x13b2efcfa093668e), UINT64_C(0x1722ef0fa0a5268e),
        UINT64_C(0x0af2eecfa074268e), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000100e3), UINT64_C(0x1692fc8f5895e68e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1222f00fa099268e), UINT64_C(0x17d2ec8fa09ae68e)
    },
    {   UINT64_C(0x00000000000100e4), UINT64_C(0x08b2fa4f746ee671), UINT64_C(0x131ae14fa0850684),
        UINT64_C(0x131aec0fa0880675), UINT64_C(0x131af00fa08f2675)
    },
    {   UINT64_C(0x00000000000100e5), UINT64_C(0x131ae60fa0804684), UINT64_C(0x131aedcfa08dc675),
        UINT64_C(0x1162ec8fa08a4675), UINT64_C(0x1692ec0fa09ea675)
    },
    {   UINT64_C(0x00000000000100e6), UINT64_C(0x1692fd0f5895e683), UINT64_C(0x0a6aec0fa06e8675),
        UINT64_C(0x14daefcfa098c675), UINT64_C(0x131ae14fa0850684)
    },
    {   UINT64_C(0x00000000000100e7), UINT64_C(0x1a0ae98fa0ab8675), UINT64_C(0x14dae90f64996675),
        UINT64_C(0x145aec8fa0938675), UINT64_C(0x1692fd0f5895e683)
    },
    {   UINT64_C(0x00000000000100e8), UINT64_C(0x1692ec0fa09ea675), UINT64_C(0x131aee0fa08a2675),
        UINT64_C(0x0000000000000000), UINT64_C(0x1362ec8fa090e675)
    },
    {   UINT64_C(0x00000000000100e9), UINT64_C(0x1162fccfa08da675), UINT64_C(0x1163018fa08f8684),
        UINT64_C(0x172afa8fa099e675), UINT64_C(0x131ae6cfa0906675)
    },
    {   UINT64_C(0x00000000000100ea), UINT64_C(0x151b014fa09fc683), UINT64_C(0x17d2ec8fa09ae682),
        UINT64_C(0x0a6aec0fa0780740), UINT64_C(0x1163018fa08f8740)
    },
    {   UINT64_C(0x00000000000100eb), UINT64_C(0x1142f4cf74832671), UINT64_C(0x0de2f58f7473a671),
        UINT64_C(0x0ed2f18c6c75c671), UINT64_C(0x08b2fa4f74628671)
    },
    {   UINT64_C(0x00000000000100ec), UINT64_C(0x0ef2f2cf78764671), UINT64_C(0x1142f4cf748325a1),
        UINT64_C(0x0fd2e40c6c7ec68e), UINT64_C(0x0cd2f2cc6875459b)
    },
    {   UINT64_C(0x00000000000063c9), UINT64_C(0x1f42fe8ed0af270b), UINT64_C(0x1f42f9ce9cb5a70b),
        UINT64_C(0x1f43068e6cb2a735), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000100ee), UINT64_C(0x0f02f4cf747c468e), UINT64_C(0x08b2fa4f745be5a1),
        UINT64_C(0x0de2f18f6c78a5a1), UINT64_C(0x0e52eb0f6074668e)
    },
    {   UINT64_C(0x00000000000100ef), UINT64_C(0x1072e5cc6c7ae594), UINT64_C(0x0eb2f30f5877e5a1),
        UINT64_C(0x0e32f58cbc764693), UINT64_C(0x0fa2f4cf747905a1)
    },
    {   UINT64_C(0x00000000000063cc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f78eacb52707), UINT64_C(0x1f42f6ceecb8a71a)
    },
    {   UINT64_C(0x00000000000100f1), UINT64_C(0x0cd2f10f7473c594), UINT64_C(0x0ef2f2cf787645a1),
        UINT64_C(0x1372f4cc6c8845a1), UINT64_C(0x0e4ad30c647cc5a1)
    },
    {   UINT64_C(0x00000000000100f2), UINT64_C(0x1242f1cc6c9205a1), UINT64_C(0x1572f4cf7490459f),
        UINT64_C(0x08b2fa4f746b6646), UINT64_C(0x0ef2f2cf78764646)
    },
    {   UINT64_C(0x00000000000100f3), UINT64_C(0x0fa2f4cf74790671), UINT64_C(0x0ef2f2cf78764671),
        UINT64_C(0x1572f4cf74904671), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000100f4), UINT64_C(0x0e42f94f7875069e), UINT64_C(0x1162f2cf7880468e),
        UINT64_C(0x12a3018fa0952684), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000100f5), UINT64_C(0x0000000000000000), UINT64_C(0x139af4cc6c88e693),
        UINT64_C(0x18c2f24f74a68594), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000100f6), UINT64_C(0x1692fd0c6c95e683), UINT64_C(0x0fa2f4cc6c7905a1),
        UINT64_C(0x150afbcc6491a682), UINT64_C(0x0de2f58cbc7ac5b2)
    },
    {   UINT64_C(0x00000000000100f7), UINT64_C(0x116af00fa08f2675), UINT64_C(0x0f3af60ca8798599),
        UINT64_C(0x142af2cf5892e6ed), UINT64_C(0x0e4af5cfa0762693)
    },
    {   UINT64_C(0x00000000000100f8), UINT64_C(0x1622efcc64920682), UINT64_C(0x1083054c58768610),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006282), UINT64_C(0x1f43028ef8b56725), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa5000b3a70b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006283), UINT64_C(0x1f42f7cfe4b3e70e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43014ec8b68720), UINT64_C(0x1f43024f60b026eb)
    },
    {   UINT64_C(0x0000000000006284), UINT64_C(0x1f42faceb8b2a71e), UINT64_C(0x1f42f88ff8b6c702),
        UINT64_C(0x1f42fe5018adc717), UINT64_C(0x1f42fe8eacad871a)
    },
    {   UINT64_C(0x00000000000100fc), UINT64_C(0x10aaea0f6c8465a1), UINT64_C(0x1022f4cc6c7b05a1),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000100fd), UINT64_C(0x1692fd0f5895e683), UINT64_C(0x0de2f58f747305a1),
        UINT64_C(0x0de2f40f747245a1), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006287), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd4ef4b5071a),
        UINT64_C(0x1f4300cf7cb546d0), UINT64_C(0x1f42fa8f98b986f6)
    },
    {   UINT64_C(0x00000000000063db), UINT64_C(0x1f42ff0f00af2709), UINT64_C(0x1f42fe4fc0b2c722),
        UINT64_C(0x1f43010f48b4c711), UINT64_C(0x1f42ff4f68b34709)
    },
    {   UINT64_C(0x0000000000003c93), UINT64_C(0x106af04fa07b664b), UINT64_C(0x106b09980c724667),
        UINT64_C(0x106b09979c72464b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000010101), UINT64_C(0x148afecf58938682), UINT64_C(0x0fa2efcf587cc683),
        UINT64_C(0x0a6aec4fa06e4675), UINT64_C(0x0a6ae64fa074a740)
    },
    {   UINT64_C(0x0000000000010102), UINT64_C(0x0de2e58f58786675), UINT64_C(0x1e0ae54f60af2675),
        UINT64_C(0x1e32e70fa0afc675), UINT64_C(0x1892ff8fa0962675)
    },
    {   UINT64_C(0x0000000000010103), UINT64_C(0x136ae70fa090a77a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1483098f6898075f), UINT64_C(0x1692e7ccd49be675)
    },
    {   UINT64_C(0x0000000000003c97), UINT64_C(0x106af0cfa07b264b), UINT64_C(0x106af6cf8c7e8658),
        UINT64_C(0x106af4cfa07ca732), UINT64_C(0x106af4cfa07ca732)
    },
    {   UINT64_C(0x0000000000010105), UINT64_C(0x147ad44cd4958675), UINT64_C(0x131aee4fa08d6675),
        UINT64_C(0x1de2e04fa0b8067d), UINT64_C(0x11a2f04f60830684)
    },
    {   UINT64_C(0x0000000000003c99), UINT64_C(0x106af48fa07d4732), UINT64_C(0x106af48fa07d470b),
        UINT64_C(0x106b01cfa0764732), UINT64_C(0x106b01cfa0764732)
    },
    {   UINT64_C(0x0000000000003c9a), UINT64_C(0x106afbcf8880067d), UINT64_C(0x106afbcf8880067d),
        UINT64_C(0x106afbcf88800674), UINT64_C(0x106afbcf88800657)
    },
    {   UINT64_C(0x0000000000003c9b), UINT64_C(0x106afbcf88800656), UINT64_C(0x106afbcf8878867d),
        UINT64_C(0x106afbcf8878867d), UINT64_C(0x106afbcf88788657)
    },
    {   UINT64_C(0x0000000000003c9c), UINT64_C(0x106b018fa077667d), UINT64_C(0x106b018fa077667d),
        UINT64_C(0x106afc0f74790732), UINT64_C(0x106afc0f74790732)
    },
    {   UINT64_C(0x0000000000003c9d), UINT64_C(0x106afc0f74790729), UINT64_C(0x106afc0f7479070b),
        UINT64_C(0x106aef0f747f8732), UINT64_C(0x106aef0f747f8732)
    },
    {   UINT64_C(0x0000000000003c9e), UINT64_C(0x106af2cfa07da732), UINT64_C(0x106af2cfa07da732),
        UINT64_C(0x106afc4f8878e67d), UINT64_C(0x106afc4f8878e67d)
    },
    {   UINT64_C(0x0000000000003c9f), UINT64_C(0x106afc4f8878e674), UINT64_C(0x106afc4f8878e657),
        UINT64_C(0x106af10f887e867d), UINT64_C(0x106af10f887e867d)
    },
    {   UINT64_C(0x0000000000003ca0), UINT64_C(0x106af48c107d067d), UINT64_C(0x106af48c107d067d),
        UINT64_C(0x106b244fa064a440), UINT64_C(0x106b1617606c06bf)
    },
    {   UINT64_C(0x000000000001010e), UINT64_C(0x107af54f747c65a1), UINT64_C(0x107af54f747c6683),
        UINT64_C(0x0f5af28f747b25a1), UINT64_C(0x0ed2e30f7075c5a1)
    },
    {   UINT64_C(0x000000000001010f), UINT64_C(0x13cae2cf7089a598), UINT64_C(0x0fc2f30f7c7985a1),
        UINT64_C(0x0f4af54f747945a1), UINT64_C(0x0ffaf2cf7c7a65a1)
    },
    {   UINT64_C(0x0000000000010110), UINT64_C(0x0f1adacc6c7885a1), UINT64_C(0x0dcaf4cf747345a1),
        UINT64_C(0x172af24f7c9725a1), UINT64_C(0x0d2adecc686f25a1)
    },
    {   UINT64_C(0x00000000000063ed), UINT64_C(0x1f42fccf78b586e7), UINT64_C(0x1f43084e8cae8725),
        UINT64_C(0x1f43024fa4b146eb), UINT64_C(0x1f43028f48b146e7)
    },
    {   UINT64_C(0x0000000000010112), UINT64_C(0x188af5cf749ca5a1), UINT64_C(0x188af5ccc89ca5a1),
        UINT64_C(0x11baf10f748085a1), UINT64_C(0x158afa8f7490a5a1)
    },
    {   UINT64_C(0x00000000000063ef), UINT64_C(0x1f4300cf4cb246e9), UINT64_C(0x1f43050f50b026e7),
        UINT64_C(0x1f43040f54b326f7), UINT64_C(0x1f4301cf8cb0a6ee)
    },
    {   UINT64_C(0x0000000000010114), UINT64_C(0x0000000000000000), UINT64_C(0x0dc2f68f7479e646),
        UINT64_C(0x0efaf30c60768693), UINT64_C(0x0c32ee4f74776680)
    },
    {   UINT64_C(0x00000000000063f1), UINT64_C(0x1f43028eecb2a71d), UINT64_C(0x1f4305cf08b3c6db),
        UINT64_C(0x1f4303cf00b3e70d), UINT64_C(0x1f43080f7cb1a6f8)
    },
    {   UINT64_C(0x0000000000003ca9), UINT64_C(0x106af28fa07da64b), UINT64_C(0x106af9cddc7ac64b),
        UINT64_C(0x106b018fa076264b), UINT64_C(0x106af28fa07da64b)
    },
    {   UINT64_C(0x00000000000063f3), UINT64_C(0x1f43024fa4b146ed), UINT64_C(0x1f43000f1caea6fa),
        UINT64_C(0x1f42fe0f10b3a70c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000003cab), UINT64_C(0x106af24fa07dc596), UINT64_C(0x106af60e6479e596),
        UINT64_C(0x106af24fa07dc596), UINT64_C(0x106aef0d787f6596)
    },
    {   UINT64_C(0x0000000000008958), UINT64_C(0x1623264ae4988776), UINT64_C(0x1622eb4ae46f4776),
        UINT64_C(0x1622eb4ae47ae776), UINT64_C(0x1622eb4ae47ae776)
    },
    {   UINT64_C(0x000000000001011a), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1dcae04fa0ae2675), UINT64_C(0x172aee0f74944598)
    },
    {   UINT64_C(0x000000000000895a), UINT64_C(0x1622eb53cc986776), UINT64_C(0x1622eb5258986776),
        UINT64_C(0x1622eb4ae4986776), UINT64_C(0x1622eb4ae4986776)
    },
    {   UINT64_C(0x000000000000895b), UINT64_C(0x1622eb4ae4986776), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063f9), UINT64_C(0x1f43014f2cb6e723), UINT64_C(0x1f42fe8f1cb566f6),
        UINT64_C(0x1f42fc8fc4b4e6ee), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063fa), UINT64_C(0x1f42ff0f28b3471b), UINT64_C(0x1f4300cf70ad86eb),
        UINT64_C(0x1f42fd0f2cb6e708), UINT64_C(0x1f43018f20b6e705)
    },
    {   UINT64_C(0x00000000000063fb), UINT64_C(0x0000000000000000), UINT64_C(0x1f43014f30b6e6ff),
        UINT64_C(0x1f43058f3caec6ed), UINT64_C(0x1f42f94ed0b60725)
    },
    {   UINT64_C(0x00000000000063fc), UINT64_C(0x1f43048f04b38706), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43038f78af06f3)
    },
    {   UINT64_C(0x00000000000063fd), UINT64_C(0x1f43008fb8b666d5), UINT64_C(0x1f4300cf28b566e5),
        UINT64_C(0x1f42ffcf48b12719), UINT64_C(0x1f43014f2cb6e6f0)
    },
    {   UINT64_C(0x00000000000063fe), UINT64_C(0x1f43010f2cb6e723), UINT64_C(0x1f43004f28b24703),
        UINT64_C(0x1f43034f78b7e6ea), UINT64_C(0x1f43070f84b20720)
    },
    {   UINT64_C(0x00000000000063ff), UINT64_C(0x1f43020f44b2a71d), UINT64_C(0x1f43024f10b76718),
        UINT64_C(0x1f43010f28b54708), UINT64_C(0x1f43034f40b18722)
    },
    {   UINT64_C(0x0000000000006400), UINT64_C(0x1f43030f30b726f6), UINT64_C(0x1f43014f2cb6e6ff),
        UINT64_C(0x1f43020fa8b24706), UINT64_C(0x1f43014f2cb6e711)
    },
    {   UINT64_C(0x0000000000006401), UINT64_C(0x1f43030f1cb38700), UINT64_C(0x1f43014f1cb4471e),
        UINT64_C(0x1f43014ed0b4670f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006402), UINT64_C(0x0000000000000000), UINT64_C(0x1f43048f3cb22702),
        UINT64_C(0x1f42ff0f48b226df), UINT64_C(0x1f43014f08b44725)
    },
    {   UINT64_C(0x0000000000006403), UINT64_C(0x1f43010f08b3c730), UINT64_C(0x1f4300cef8b36722),
        UINT64_C(0x1f42fc4f78b446ea), UINT64_C(0x1f42fe0ea8b3a717)
    },
    {   UINT64_C(0x0000000000006404), UINT64_C(0x1f42fe4f34b2c6db), UINT64_C(0x1f42fc0ee8b50703),
        UINT64_C(0x1f43014f40afe71f), UINT64_C(0x1f43024f5cb2e73f)
    },
    {   UINT64_C(0x0000000000006405), UINT64_C(0x1f42fecf0cb5a716), UINT64_C(0x1f43024f5cb2e703),
        UINT64_C(0x1f42fc8f5cb126d8), UINT64_C(0x1f4301cf44b5a6f8)
    },
    {   UINT64_C(0x0000000000006406), UINT64_C(0x0000000000000000), UINT64_C(0x1f43014f54b7271e),
        UINT64_C(0x1f43014f0cb58716), UINT64_C(0x1f43010f20b586e5)
    },
    {   UINT64_C(0x000000000000896a), UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x1c72f94d28aaa67e),
        UINT64_C(0x0f22f610407705b4), UINT64_C(0x0f22f610407705b4)
    },
    {   UINT64_C(0x0000000000006408), UINT64_C(0x1f43014f2cb6e731), UINT64_C(0x1f43020eacb44720),
        UINT64_C(0x1f42ff8ebcb6c721), UINT64_C(0x1f43024f28b1c709)
    },
    {   UINT64_C(0x0000000000006409), UINT64_C(0x1f43018f10ace6cb), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43054f70b1a6dc), UINT64_C(0x1f43008f70b22732)
    },
    {   UINT64_C(0x000000000000896d), UINT64_C(0x14a2f4d0108d8611), UINT64_C(0x14a2f4d0108d8611),
        UINT64_C(0x209aff8b2cbc86fe), UINT64_C(0x209aff8b30bc86ff)
    },
    {   UINT64_C(0x000000000000640b), UINT64_C(0x0000000000000000), UINT64_C(0x1f4302cf10b0c70e),
        UINT64_C(0x1f42fd8ea0b5072e), UINT64_C(0x1f4305cf08ae6702)
    },
    {   UINT64_C(0x000000000000640c), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc8f28b5a6ed),
        UINT64_C(0x1f43048f2cb68719), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000640d), UINT64_C(0x1f4301cf00aee712), UINT64_C(0x1f42fd0ebcb5e721),
        UINT64_C(0x1f43004ee4b2c723), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000640e), UINT64_C(0x1f43000ec0b4a726), UINT64_C(0x1f42fecefcb34736),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43024f60b026ee)
    },
    {   UINT64_C(0x000000000000640f), UINT64_C(0x1f43014f14b706fd), UINT64_C(0x1f4302cf4cafa72c),
        UINT64_C(0x1f4301cedcb7672d), UINT64_C(0x1f43010ec4aec6fc)
    },
    {   UINT64_C(0x0000000000006410), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fdced8b7a725),
        UINT64_C(0x1f43030f14b62723), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006411), UINT64_C(0x1f4301cf60b4c71a), UINT64_C(0x1f42f90efcb5e71a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43010f40b806f8)
    },
    {   UINT64_C(0x0000000000006412), UINT64_C(0x0000000000000000), UINT64_C(0x1f4301cf60b4c73d),
        UINT64_C(0x1f42fe4f6cb7c713), UINT64_C(0x1f42fb8e9cb2e6f1)
    },
    {   UINT64_C(0x0000000000006413), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff0ed4b68713),
        UINT64_C(0x1f43034f24b386fd), UINT64_C(0x1f43044f2cb4e703)
    },
    {   UINT64_C(0x0000000000006414), UINT64_C(0x1f42f74f4cb666f2), UINT64_C(0x1f42fe4ec0b7c73a),
        UINT64_C(0x1f43018f3cb1672e), UINT64_C(0x1f4302cf40b7c727)
    },
    {   UINT64_C(0x0000000000006415), UINT64_C(0x1f43018efcb4c736), UINT64_C(0x1f42fecf0cb8a748),
        UINT64_C(0x1f42fecf0cb8a716), UINT64_C(0x1f4302cefcb10734)
    },
    {   UINT64_C(0x0000000000006416), UINT64_C(0x1f42fa8eb4b4a74e), UINT64_C(0x1f42fbcea0b42728),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff8f08b3a726)
    },
    {   UINT64_C(0x0000000000006417), UINT64_C(0x1f42fa8ee0b5a720), UINT64_C(0x1f43004f48b526f0),
        UINT64_C(0x1f42fdcf24b78733), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006418), UINT64_C(0x1f4302ced4b80748), UINT64_C(0x1f42f9cec0b58720),
        UINT64_C(0x1f42fd8ea4b66705), UINT64_C(0x1f42fe4ea4b72730)
    },
    {   UINT64_C(0x0000000000006419), UINT64_C(0x0000000000000000), UINT64_C(0x1f43000f0cafe71e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43018f0cafe713)
    },
    {   UINT64_C(0x000000000000641a), UINT64_C(0x1f43024f10b38706), UINT64_C(0x1f43014ed8b2c729),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43008f00b4a709)
    },
    {   UINT64_C(0x000000000000641b), UINT64_C(0x0000000000000000), UINT64_C(0x1f4303cf04b2e73e),
        UINT64_C(0x1f42fd4f24b2e71e), UINT64_C(0x1f42fccf60b106db)
    },
    {   UINT64_C(0x000000000000641c), UINT64_C(0x1f42ff0ed4b16720), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb4f1cb40707), UINT64_C(0x1f42fececcb46722)
    },
    {   UINT64_C(0x000000000000641d), UINT64_C(0x1f43020ee4b4a72f), UINT64_C(0x1f43058ee0b24731),
        UINT64_C(0x1f42fd4ee0b6a736), UINT64_C(0x1f43008eb0b6c724)
    },
    {   UINT64_C(0x000000000000641e), UINT64_C(0x1f4300cf14b5271a), UINT64_C(0x1f42fd4ee0b6a71a),
        UINT64_C(0x1f42fe4e98b38730), UINT64_C(0x1f42fd4ee0b6a6f7)
    },
    {   UINT64_C(0x000000000000641f), UINT64_C(0x1f42fecec0b5c731), UINT64_C(0x1f42fb4ea0b4273f),
        UINT64_C(0x1f42fd4ebcb50717), UINT64_C(0x1f42f8cef0b586fe)
    },
    {   UINT64_C(0x0000000000006420), UINT64_C(0x1f42fd8f64b76724), UINT64_C(0x1f43000ef4b18735),
        UINT64_C(0x1f42fe4f4cb7c725), UINT64_C(0x1f42fb0eb4b3672d)
    },
    {   UINT64_C(0x0000000000006421), UINT64_C(0x1f43030ec8b4471b), UINT64_C(0x1f42fc0ec0b28738),
        UINT64_C(0x1f42facec0b226fc), UINT64_C(0x1f43004f18b46713)
    },
    {   UINT64_C(0x0000000000006422), UINT64_C(0x1f42fa0f00b726f3), UINT64_C(0x1f42ff8e70b2a738),
        UINT64_C(0x1f43008e70b32738), UINT64_C(0x1f42fa0e7cb2673a)
    },
    {   UINT64_C(0x0000000000006423), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa4e44b3472d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe4f18b2e6f5)
    },
    {   UINT64_C(0x0000000000006424), UINT64_C(0x1f42ffcebcb34725), UINT64_C(0x1f43220f84b20713),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43060f38aba6d0)
    },
    {   UINT64_C(0x0000000000006425), UINT64_C(0x1f43178eacaf26e2), UINT64_C(0x1f43270ec8b0c74c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fe4e8cace6d6)
    },
    {   UINT64_C(0x0000000000006426), UINT64_C(0x1f42fb8e4cae86de), UINT64_C(0x1f43004e6cacc71d),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43068eacab66aa)
    },
    {   UINT64_C(0x0000000000006427), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb8ed8ae46fe),
        UINT64_C(0x1f43018e9cafe727), UINT64_C(0x1f43050e5cad871d)
    },
    {   UINT64_C(0x0000000000006428), UINT64_C(0x1f42fe8e7cb186e2), UINT64_C(0x1f42ffce6cb026fb),
        UINT64_C(0x1f42facef8acc702), UINT64_C(0x1f4301cec8ae6700)
    },
    {   UINT64_C(0x0000000000006429), UINT64_C(0x0000000000000000), UINT64_C(0x1f43018e6cafe709),
        UINT64_C(0x1f43020e4cadc736), UINT64_C(0x1f43000e8caec6c5)
    },
    {   UINT64_C(0x000000000000642a), UINT64_C(0x1f430c0e6cac871a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43018ed8af86e9), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000642b), UINT64_C(0x1f42fe4ec8ac8718), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43030ed8af0700), UINT64_C(0x1f42f6ced8ad0713)
    },
    {   UINT64_C(0x000000000000642c), UINT64_C(0x1f43000e6caba721), UINT64_C(0x1f42fd8e0caf4707),
        UINT64_C(0x1f42f8ce6cb026e8), UINT64_C(0x1f42fb0ec8ae26fa)
    },
    {   UINT64_C(0x000000000001110d), UINT64_C(0x166af6cfa0942683), UINT64_C(0x15c2f78fa0944675),
        UINT64_C(0x14fafa8f7097667b), UINT64_C(0x18b2f78fa09e2675)
    },
    {   UINT64_C(0x000000000000642e), UINT64_C(0x1f430bce5cb3a72c), UINT64_C(0x1f43100eacad2710),
        UINT64_C(0x1f4306cf48af070b), UINT64_C(0x1f42fece9cae2719)
    },
    {   UINT64_C(0x000000000000642f), UINT64_C(0x0000000000000000), UINT64_C(0x1f4301ceaca96734),
        UINT64_C(0x1f43004e7cae4714), UINT64_C(0x1f42fd8eb8af4726)
    },
    {   UINT64_C(0x0000000000006430), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f6ce9caf0724),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fcce9caf6734)
    },
    {   UINT64_C(0x0000000000006431), UINT64_C(0x1f43018ee8ac071a), UINT64_C(0x1f42fd0ec8a7e6f6),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ffce9ca7e727)
    },
    {   UINT64_C(0x0000000000006432), UINT64_C(0x1f42f94e8caec6e7), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43084e9cad272d), UINT64_C(0x1f4310ce6caf272c)
    },
    {   UINT64_C(0x0000000000006433), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43120e6cac2737), UINT64_C(0x1f43018ed8adc704)
    },
    {   UINT64_C(0x0000000000006434), UINT64_C(0x1f42fd0ee8ac8725), UINT64_C(0x1f43068ee8ae0719),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4308cf18ac46f5)
    },
    {   UINT64_C(0x0000000000006435), UINT64_C(0x1f43034e8cb146ea), UINT64_C(0x1f42f94e8cb10717),
        UINT64_C(0x1f43040e7cafc6d6), UINT64_C(0x1f42ff8e7cae272b)
    },
    {   UINT64_C(0x0000000000006436), UINT64_C(0x1f43084f18aae6f6), UINT64_C(0x1f43064e4caf2701),
        UINT64_C(0x1f4301ce7cafc6ee), UINT64_C(0x1f430a8eb8ada721)
    },
    {   UINT64_C(0x0000000000006437), UINT64_C(0x1f43028e7cafc716), UINT64_C(0x1f42f90e6caec725),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43020e7cafc708)
    },
    {   UINT64_C(0x0000000000006438), UINT64_C(0x1f4302ce7cafc6eb), UINT64_C(0x1f42ff8eb8b0a6fc),
        UINT64_C(0x1f430b0e8caf2704), UINT64_C(0x1f43060e7cafc727)
    },
    {   UINT64_C(0x0000000000006439), UINT64_C(0x1f42f88e4caac6fc), UINT64_C(0x1f42ff8e4cae26e9),
        UINT64_C(0x1f430b4f28ac26f8), UINT64_C(0x1f430b8ee8acc6ff)
    },
    {   UINT64_C(0x000000000000643a), UINT64_C(0x1f42f90e6cacc725), UINT64_C(0x1f43000e8cb10720),
        UINT64_C(0x1f42ff0eacaf871a), UINT64_C(0x1f42ffce4caec723)
    },
    {   UINT64_C(0x000000000000643b), UINT64_C(0x1f4300ce5cb1072d), UINT64_C(0x1f43064e4cae2727),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff8ec8ad271f)
    },
    {   UINT64_C(0x000000000000643c), UINT64_C(0x1f42f3ce5cb186d6), UINT64_C(0x1f43038e8cb2072f),
        UINT64_C(0x1f42fc8ee8af872f), UINT64_C(0x1f43080e2cb16719)
    },
    {   UINT64_C(0x000000000000643d), UINT64_C(0x1f42f9ceacaf6722), UINT64_C(0x1f42fcce5cb0872a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43028ea0b14701)
    },
    {   UINT64_C(0x000000000000643e), UINT64_C(0x1f42fd8ed8afe6f9), UINT64_C(0x1f430b4eb8aee6e7),
        UINT64_C(0x1f42ffcef4b7070d), UINT64_C(0x1f430bce6cade6f4)
    },
    {   UINT64_C(0x000000000000643f), UINT64_C(0x1f430bceb8ae66fd), UINT64_C(0x1f42f8ce6caf673c),
        UINT64_C(0x1f43014e9caea705), UINT64_C(0x1f42fb8eacb066ee)
    },
    {   UINT64_C(0x0000000000006440), UINT64_C(0x1f42ffce9caea6fb), UINT64_C(0x1f43044ed8b006eb),
        UINT64_C(0x1f42fd8eacb0a728), UINT64_C(0x1f42fe0ee8af0710)
    },
    {   UINT64_C(0x0000000000006441), UINT64_C(0x1f43084ee8ad66eb), UINT64_C(0x1f43094ec8afc6ff),
        UINT64_C(0x1f43078ed8ae06ea), UINT64_C(0x1f42fc0eacaf46e5)
    },
    {   UINT64_C(0x0000000000006442), UINT64_C(0x1f42ff8eb8aea6c3), UINT64_C(0x1f43060e9cb2871c),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f43088e8caf2715)
    },
    {   UINT64_C(0x0000000000006443), UINT64_C(0x0000000000000000), UINT64_C(0x1f4302ce6caca6e1),
        UINT64_C(0x1f42fd4e5caee735), UINT64_C(0x1f42f98eb8af4700)
    },
    {   UINT64_C(0x0000000000006444), UINT64_C(0x1f4309ce9cae0711), UINT64_C(0x1f43030eb8ad86ff),
        UINT64_C(0x1f43068eb8b0272b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006445), UINT64_C(0x1f42ff0e9caf2731), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43074ee8ad46fc), UINT64_C(0x1f43074e7cb0a72d)
    },
    {   UINT64_C(0x00000000000062f3), UINT64_C(0x1f42f850a8a8670a), UINT64_C(0x1f42ff0f4caea70b),
        UINT64_C(0x1f42fb500cad86fd), UINT64_C(0x1f42fb4ff8aba6f2)
    },
    {   UINT64_C(0x0000000000006447), UINT64_C(0x1f42f74e7cb48731), UINT64_C(0x1f43058ed8b2c6ec),
        UINT64_C(0x1f42fd8e2cac6748), UINT64_C(0x1f4302ce4cb0a72c)
    },
    {   UINT64_C(0x0000000000011128), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x182b02cf649b0697), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000011129), UINT64_C(0x0000000000000000), UINT64_C(0x1912f04cdca1868a),
        UINT64_C(0x1f8af80f64bc0697), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001112a), UINT64_C(0x0000000000000000), UINT64_C(0x1e52f78f64b60697),
        UINT64_C(0x15a3028f64916690), UINT64_C(0x1c72f78f64ad4697)
    },
    {   UINT64_C(0x000000000001112b), UINT64_C(0x15a3028f08916690), UINT64_C(0x0000000000000000),
        UINT64_C(0x173afecf64962690), UINT64_C(0x1c82f8cf64afe697)
    },
    {   UINT64_C(0x000000000001112c), UINT64_C(0x1a52f70f64a32697), UINT64_C(0x1d22f6cf64b1c697),
        UINT64_C(0x21b2f6cf64c44697), UINT64_C(0x1bdaf70f64aba697)
    },
    {   UINT64_C(0x000000000000644d), UINT64_C(0x1f4302ce5cae0727), UINT64_C(0x1f42fece7cb20701),
        UINT64_C(0x1f42f88e9cb38736), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000644e), UINT64_C(0x1f43030e8cb4a72c), UINT64_C(0x1f43030e6caea6dd),
        UINT64_C(0x1f42f58ee8b00732), UINT64_C(0x1f4304ce9cb0c70d)
    },
    {   UINT64_C(0x000000000000644f), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43000e9cb1a712), UINT64_C(0x1f4303ce7cb1272f)
    },
    {   UINT64_C(0x0000000000006450), UINT64_C(0x1f42f9ce9cafe710), UINT64_C(0x1f43064eb8b2273a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8ceb8b066db)
    },
    {   UINT64_C(0x0000000000006451), UINT64_C(0x1f42f84ec8b16730), UINT64_C(0x1f43074e8cb0e738),
        UINT64_C(0x1f4301ce7cb16731), UINT64_C(0x1f42fece9cb14734)
    },
    {   UINT64_C(0x0000000000006452), UINT64_C(0x1f42f6ceb8b1c720), UINT64_C(0x1f43160f7caa06fb),
        UINT64_C(0x1f43040f9cb266e5), UINT64_C(0x1f43054f4cb06739)
    },
    {   UINT64_C(0x0000000000011133), UINT64_C(0x1bc2f58f74a905a1), UINT64_C(0x1782fe4f7492e5a1),
        UINT64_C(0x1492f58c348ba590), UINT64_C(0x159afb0f748ba5c6)
    },
    {   UINT64_C(0x0000000000003c4b), UINT64_C(0x106af08c147ec596), UINT64_C(0x106af0c9fc7b859c),
        UINT64_C(0x106af24f747da656), UINT64_C(0x106af48d70798643)
    },
    {   UINT64_C(0x0000000000006455), UINT64_C(0x1f42fd8f94b3c705), UINT64_C(0x1f43041008b146d9),
        UINT64_C(0x1f4308cfc4b446ea), UINT64_C(0x1f43001088b1c6c4)
    },
    {   UINT64_C(0x0000000000006456), UINT64_C(0x1f4308cfe8b4a6db), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4302d02cb7c6fd), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006457), UINT64_C(0x0000000000000000), UINT64_C(0x1f430650e8ae46d5),
        UINT64_C(0x1f42ff9074b6c6eb), UINT64_C(0x1f430acf3cad4701)
    },
    {   UINT64_C(0x0000000000006458), UINT64_C(0x1f4307cee0b386c2), UINT64_C(0x1f43000fb0b0a6f2),
        UINT64_C(0x1f4305cf08ae6723), UINT64_C(0x1f4305cfe0b646dc)
    },
    {   UINT64_C(0x0000000000006459), UINT64_C(0x1f4308d01cb3070c), UINT64_C(0x1f43054f98b72700),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000003c51), UINT64_C(0x106b174fa073a50e), UINT64_C(0x106b06952873a64b),
        UINT64_C(0x106b27953879c632), UINT64_C(0x106aec8c287a2651)
    },
    {   UINT64_C(0x000000000000645b), UINT64_C(0x1f4307ceecae66fb), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43068fc8adc6cf), UINT64_C(0x1f43090fccaa46fd)
    },
    {   UINT64_C(0x000000000000645c), UINT64_C(0x1f43008fc4b566f6), UINT64_C(0x1f430a8e70af4714),
        UINT64_C(0x1f430610c4b0e6d6), UINT64_C(0x1f430a4ee8a8870e)
    },
    {   UINT64_C(0x000000000000645d), UINT64_C(0x1f42fc0f04b726fa), UINT64_C(0x1f4300ced8b38738),
        UINT64_C(0x1f43080f50b4270b), UINT64_C(0x1f43035008b2e701)
    },
    {   UINT64_C(0x000000000000645e), UINT64_C(0x1f4305503cb84737), UINT64_C(0x1f4307cf8cb0670d),
        UINT64_C(0x1f4308cfdcab8714), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000645f), UINT64_C(0x0000000000000000), UINT64_C(0x1f43020f80a986d9),
        UINT64_C(0x1f4305106cad66d8), UINT64_C(0x1f4303cf28b78717)
    },
    {   UINT64_C(0x0000000000006460), UINT64_C(0x1f4304cf78b366f2), UINT64_C(0x1f4300cef0b546fd),
        UINT64_C(0x1f42fd0eacb926f3), UINT64_C(0x1f42fc0f8cb7e711)
    },
    {   UINT64_C(0x0000000000003d18), UINT64_C(0x106af4cfa07ca70f), UINT64_C(0x106af48fa07d4701),
        UINT64_C(0x106af28fa07da701), UINT64_C(0x106afc0f7479070f)
    },
    {   UINT64_C(0x0000000000003d19), UINT64_C(0x106af44f747d4701), UINT64_C(0x106af0cfa07e8701),
        UINT64_C(0x106af7cf747b0701), UINT64_C(0x106aee0f747f2701)
    },
    {   UINT64_C(0x0000000000003d1a), UINT64_C(0x106af54fa07dc701), UINT64_C(0x0000000000000000),
        UINT64_C(0x106afbcf88800667), UINT64_C(0x106afbcf88788667)
    },
    {   UINT64_C(0x0000000000003d1b), UINT64_C(0x106af24fa07dc655), UINT64_C(0x106afc4f8878e667),
        UINT64_C(0x106af48c107d0655), UINT64_C(0x106aefcfa07f2655)
    },
    {   UINT64_C(0x0000000000003d1c), UINT64_C(0x106afc8f8c76e656), UINT64_C(0x106aee8f8c7fc656),
        UINT64_C(0x106af20fa07e8655), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006466), UINT64_C(0x0000000000000000), UINT64_C(0x1f4303cf40b706f7),
        UINT64_C(0x1f42fb0f84b706be), UINT64_C(0x1f42ffd080b7470c)
    },
    {   UINT64_C(0x0000000000003c5e), UINT64_C(0x106b000c1078a59f), UINT64_C(0x106aee0c0c78c654),
        UINT64_C(0x106afb0c0c77259f), UINT64_C(0x106af30f8c80264b)
    },
    {   UINT64_C(0x0000000000006468), UINT64_C(0x1f43040facb226f0), UINT64_C(0x1f43054eacb24719),
        UINT64_C(0x1f42ff1084b3a713), UINT64_C(0x1f4300cf8cb3e70a)
    },
    {   UINT64_C(0x0000000000006469), UINT64_C(0x1f43038df0b0c746), UINT64_C(0x1f4302cf68ac86ee),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ffcf20b406a4)
    },
    {   UINT64_C(0x000000000000646a), UINT64_C(0x1f42ffcf4cb02721), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4300cec0b7a701), UINT64_C(0x1f43068e90b0c72b)
    },
    {   UINT64_C(0x000000000000646b), UINT64_C(0x1f43098e34b1473e), UINT64_C(0x1f4302cf54b24728),
        UINT64_C(0x1f43024fa4b1a704), UINT64_C(0x1f4301cfd8b36718)
    },
    {   UINT64_C(0x000000000000646c), UINT64_C(0x1f43024e8cb14701), UINT64_C(0x1f42fe8facb50725),
        UINT64_C(0x1f43040e64b7e73a), UINT64_C(0x1f43078e9cae66f9)
    },
    {   UINT64_C(0x000000000000646d), UINT64_C(0x1f42ff0f84b0a71f), UINT64_C(0x1f42fe0e5cb90733),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f4301cf7cb42727)
    },
    {   UINT64_C(0x000000000000646e), UINT64_C(0x1f42f7ce70b6873f), UINT64_C(0x1f43044f04b3a6f9),
        UINT64_C(0x1f42fc8f28b3e728), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000646f), UINT64_C(0x1f43004f90b3e6f7), UINT64_C(0x1f42ff1094b586ee),
        UINT64_C(0x1f43004eccb54739), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006470), UINT64_C(0x1f42fe0e70b6a73f), UINT64_C(0x1f430d0eb0b4e720),
        UINT64_C(0x1f4300ce94b6c72c), UINT64_C(0x1f42ffcea0b72711)
    },
    {   UINT64_C(0x0000000000003c68), UINT64_C(0x106afd4e4078659f), UINT64_C(0x106af84fa07c859f),
        UINT64_C(0x106aee17b8800675), UINT64_C(0x106b26d72c63a65d)
    },
    {   UINT64_C(0x0000000000006472), UINT64_C(0x1f42f3cf2cb886fd), UINT64_C(0x1f42f9cf2cafa6fd),
        UINT64_C(0x1f42facef8b66703), UINT64_C(0x1f43000eacb16718)
    },
    {   UINT64_C(0x0000000000006473), UINT64_C(0x1f43079004b366e3), UINT64_C(0x1f430b8f48b1e728),
        UINT64_C(0x1f42fe8f0cb3a6fc), UINT64_C(0x1f43058f14b1e724)
    },
    {   UINT64_C(0x0000000000006474), UINT64_C(0x1f42fdced4ac472b), UINT64_C(0x1f42fa0f44b5c71e),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbcf8cb2270b)
    },
    {   UINT64_C(0x0000000000006475), UINT64_C(0x1f42fa0fa4b80708), UINT64_C(0x1f4300ceecaa0703),
        UINT64_C(0x1f4301904cb1a703), UINT64_C(0x1f42fdcec4a6072f)
    },
    {   UINT64_C(0x0000000000006476), UINT64_C(0x1f42ff0ec8b54714), UINT64_C(0x1f42f50eecaee713),
        UINT64_C(0x1f42fecf44b2e703), UINT64_C(0x1f43038f70b0e713)
    },
    {   UINT64_C(0x0000000000006477), UINT64_C(0x1f43030fa0b6c70d), UINT64_C(0x1f4300cef8b5e724),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f45074b866f1)
    },
    {   UINT64_C(0x0000000000006478), UINT64_C(0x0000000000000000), UINT64_C(0x1f4300cfa0b2470d),
        UINT64_C(0x1f42fecf54aca708), UINT64_C(0x1f42f90f04ae6732)
    },
    {   UINT64_C(0x0000000000006479), UINT64_C(0x1f4302cf4ca8a712), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd0f84af26f6), UINT64_C(0x1f42f90eccaca716)
    },
    {   UINT64_C(0x000000000000647a), UINT64_C(0x1f42fd0eccb7c6ef), UINT64_C(0x1f42f90f7cb58709),
        UINT64_C(0x1f42fc0f24b3e708), UINT64_C(0x1f42fdcf0cadc70b)
    },
    {   UINT64_C(0x000000000000647b), UINT64_C(0x1f42fc0e7cb4c708), UINT64_C(0x1f42fccfecb4470e),
        UINT64_C(0x1f42ff0ec0b1670c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000647c), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb0ff0b92718),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80f98b446fa)
    },
    {   UINT64_C(0x000000000000647d), UINT64_C(0x1f42fc0f40b08703), UINT64_C(0x1f42f9cfe8b886f6),
        UINT64_C(0x1f42f0cffcba2720), UINT64_C(0x1f42fb104cb62718)
    },
    {   UINT64_C(0x000000000000647e), UINT64_C(0x1f42fecf7cb0a70d), UINT64_C(0x1f42fd0fa8afe700),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000647f), UINT64_C(0x1f42f44ff0b846ed), UINT64_C(0x1f42f90eccb7a6ec),
        UINT64_C(0x1f43000f08b286f8), UINT64_C(0x1f42fb0e5cb186f8)
    },
    {   UINT64_C(0x0000000000006480), UINT64_C(0x1f42fb0fc4b446e4), UINT64_C(0x1f42fb0f60ad2710),
        UINT64_C(0x1f42fd0f68b5a6fb), UINT64_C(0x1f42f94f54b3c6fc)
    },
    {   UINT64_C(0x0000000000006481), UINT64_C(0x1f42fd0e7cb286fa), UINT64_C(0x1f42fb0f18a6a700),
        UINT64_C(0x1f42fc0fd4b806f3), UINT64_C(0x1f42fa0f84b0c6ff)
    },
    {   UINT64_C(0x0000000000006482), UINT64_C(0x0000000000000000), UINT64_C(0x1f42facf48abc712),
        UINT64_C(0x1f42fb0fdcb546ef), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006483), UINT64_C(0x1f42fa0fb8b446e3), UINT64_C(0x1f4300cf9cb4c714),
        UINT64_C(0x1f42fd0f60b3e729), UINT64_C(0x1f4301cee8ab66f7)
    },
    {   UINT64_C(0x0000000000006484), UINT64_C(0x1f42f80f8cb90710), UINT64_C(0x1f42f60fa4b5670e),
        UINT64_C(0x1f42f84fb4b6a6f8), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006485), UINT64_C(0x1f42fc4e7cb46720), UINT64_C(0x1f42fcd024b3a710),
        UINT64_C(0x1f42fb0f48b726ec), UINT64_C(0x1f42fd0f94b6a6e8)
    },
    {   UINT64_C(0x0000000000006486), UINT64_C(0x0000000000000000), UINT64_C(0x1f4300cf9cb6a6f6),
        UINT64_C(0x1f42fd0fccb686f2), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006487), UINT64_C(0x1f42fd0fe0ac86f8), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f90f08af2724), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006488), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90ebcaf8707)
    },
    {   UINT64_C(0x0000000000006489), UINT64_C(0x1f42fd1004a866ec), UINT64_C(0x1f42fd0fd8b2c6f7),
        UINT64_C(0x1f42fc102cb266fc), UINT64_C(0x1f42fdcfb4b706e8)
    },
    {   UINT64_C(0x000000000000648a), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff0e84b30712),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000ca1900003d42), UINT64_C(0x106b0e4fa06fc5e8), UINT64_C(0x106af40fa07aa5e8),
        UINT64_C(0x106af6cfa07b85f5), UINT64_C(0x106af40fa07d05e8)
    },
    {   UINT64_C(0x000000000000648c), UINT64_C(0x1f42fdce4cb306fe), UINT64_C(0x1f42fb0fb8b7c6ea),
        UINT64_C(0x1f42fdd02cb886f8), UINT64_C(0x1f42fb0ec4b2a6fb)
    },
    {   UINT64_C(0x000000000000648d), UINT64_C(0x1f42f50f8cb7270a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f4304d004ae46f5), UINT64_C(0x1f42fdcfd8b406ef)
    },
    {   UINT64_C(0x0710001c03683d45), UINT64_C(0x106af54fa07c65f3), UINT64_C(0x106af54fa07c65e8),
        UINT64_C(0x106af58fa07c05e8), UINT64_C(0x106af54fa07c65e8)
    },
    {   UINT64_C(0x0000e40000003d46), UINT64_C(0x106af4cfa07c85f3), UINT64_C(0x106afd0fa078869e),
        UINT64_C(0x106af54fa07c669e), UINT64_C(0x106af30df47c45f5)
    },
    {   UINT64_C(0x0000000000006490), UINT64_C(0x1f42f90eb8b526e4), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006491), UINT64_C(0x1f42f95034b5e6fe), UINT64_C(0x1f42fdd01cb22717),
        UINT64_C(0x1f42ffd018adc701), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006492), UINT64_C(0x1f42fc0fd8af0705), UINT64_C(0x1f42f7cfa0af070a),
        UINT64_C(0x1f42ffcfe8ac6701), UINT64_C(0x1f42facfd8b76711)
    },
    {   UINT64_C(0x00000000000089f6), UINT64_C(0x1b12fa8c4ca486b6), UINT64_C(0x1b12fa8c4ca486b6),
        UINT64_C(0x2b02fe0fa0e2867e), UINT64_C(0x2b02fe0fa0e2867e)
    },
    {   UINT64_C(0x0000000000006494), UINT64_C(0x1f42fc0ff8adc706), UINT64_C(0x1f42fa1070a84716),
        UINT64_C(0x1f42fd0fccb266ee), UINT64_C(0x1f42fc0e8ca866f7)
    },
    {   UINT64_C(0x0000000000006495), UINT64_C(0x1f42fb0f74afa703), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fb0f4cb76700), UINT64_C(0x1f42f80fe4b5e706)
    },
    {   UINT64_C(0x0000000000006496), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa0e9cb00710), UINT64_C(0x1f42f80f8cb4e6f1)
    },
    {   UINT64_C(0x0000000000006497), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fd0f44b3070f), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006498), UINT64_C(0x1f42fd1014b646fe), UINT64_C(0x1f42fdcea8b4e703),
        UINT64_C(0x1f42f5ce54b7871f), UINT64_C(0x1f42fc1028af06fe)
    },
    {   UINT64_C(0x0000000000006499), UINT64_C(0x1f42fcced8b0c712), UINT64_C(0x1f42ffce8cb786f3),
        UINT64_C(0x1f42ffcfd4b2e6fd), UINT64_C(0x1f42fa0f38b746f1)
    },
    {   UINT64_C(0x00000000000089fd), UINT64_C(0x2582fb0eaccde621), UINT64_C(0x3132fbd088fc65a9),
        UINT64_C(0x3132fbd084fc65a9), UINT64_C(0x3132fbd084fc65a9)
    },
    {   UINT64_C(0x000000000000649b), UINT64_C(0x1f42fcd008a946fd), UINT64_C(0x1f42ffd054b04701),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fdcfacb4e6e9)
    },
    {   UINT64_C(0x000000000000649c), UINT64_C(0x1f42fecef8ad470a), UINT64_C(0x1f42f88f8cb646fc),
        UINT64_C(0x1f4301cebcb066f6), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000649d), UINT64_C(0x1f43040f54b5872e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa0f50adc700), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000649e), UINT64_C(0x1f42fd0facb6270c), UINT64_C(0x1f42fb0e84af2704),
        UINT64_C(0x1f42fc0e6cb2671b), UINT64_C(0x1f42f70f5cb78708)
    },
    {   UINT64_C(0x000000000000649f), UINT64_C(0x1f42fa8e5cb74701), UINT64_C(0x1f42f80f44b2a706),
        UINT64_C(0x1f42fc0ec8b0070d), UINT64_C(0x1f42f80f6cb72706)
    },
    {   UINT64_C(0x00000000000064a0), UINT64_C(0x1f42fa0f30b4e71e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f80f08aec706), UINT64_C(0x1f42ffcf8cb64719)
    },
    {   UINT64_C(0x0000000000003c98), UINT64_C(0x106af4cfa07ca729), UINT64_C(0x106af4cfa07ca70b),
        UINT64_C(0x106af4cfa07ca70b), UINT64_C(0x106af48fa07d4732)
    },
    {   UINT64_C(0x00000000000064a2), UINT64_C(0x1f42f8103cb4c706), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f70f00b6a702), UINT64_C(0x1f42f71010afa6f1)
    },
    {   UINT64_C(0x00000000000064a3), UINT64_C(0x1f42fb0f58b48700), UINT64_C(0x1f42f90fccb446f7),
        UINT64_C(0x1f430a4ef0b56712), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000064a4), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f70f8cb78705),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fbd04cb7070b)
    },
    {   UINT64_C(0x00000000000064a5), UINT64_C(0x1f42ff0edcb266fc), UINT64_C(0x1f42f70facb2471f),
        UINT64_C(0x1f42f90eacb6a72a), UINT64_C(0x1f42f80fa4aee706)
    },
    {   UINT64_C(0x00000000000064a6), UINT64_C(0x1f42f9cf88aea724), UINT64_C(0x1f42fc0ef4b5c705),
        UINT64_C(0x1f42fdd02cb9670c), UINT64_C(0x1f42fa0fa8b4070f)
    },
    {   UINT64_C(0x0000000000011187), UINT64_C(0x14ab0b4f689d267e), UINT64_C(0x14731f0f74a1067e),
        UINT64_C(0x1ccb1e8f74c2a67e), UINT64_C(0x15e2f5cfa0a3467e)
    },
    {   UINT64_C(0x00000000000064a8), UINT64_C(0x1f42ff0f7cb1471b), UINT64_C(0x1f42fccf78b04705),
        UINT64_C(0x1f42f80f94b7a706), UINT64_C(0x1f42f61088b366f5)
    },
    {   UINT64_C(0x00000000000064a9), UINT64_C(0x1f42fd0f28b72709), UINT64_C(0x1f42fa0f70b68706),
        UINT64_C(0x1f42fb0fa8b1470a), UINT64_C(0x1f42f80f7cb50706)
    },
    {   UINT64_C(0x000000000001118a), UINT64_C(0x0f82ec4c408665b7), UINT64_C(0x0f3afdcfa07e4694),
        UINT64_C(0x06e2ff4fa067268f), UINT64_C(0x07f2d08c406ac68f)
    },
    {   UINT64_C(0x00000000000064ab), UINT64_C(0x1f42f80e80b5872e), UINT64_C(0x1f42fe4f30b36704),
        UINT64_C(0x1f43054f10b30724), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000064ac), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f60e3cb5472f), UINT64_C(0x1f42f8cfb4b60717)
    },
    {   UINT64_C(0x00000000000064ad), UINT64_C(0x1f430e0efcb2e721), UINT64_C(0x1f42faceb4b1a711),
        UINT64_C(0x1f42fb0ef4b646e3), UINT64_C(0x1f42facf1cb1272c)
    },
    {   UINT64_C(0x00000000000064ae), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd0f38b566f3),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f80e7cb46734)
    },
    {   UINT64_C(0x00000000000064af), UINT64_C(0x1f42f8100cb346ed), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000064b0), UINT64_C(0x1f42fed000b1e700), UINT64_C(0x1f42fb1058ae270f),
        UINT64_C(0x1f42fa0f20b2a70d), UINT64_C(0x1f42ffcedcb6a706)
    },
    {   UINT64_C(0x00000000000064b1), UINT64_C(0x1f42fecf48b266f7), UINT64_C(0x1f42f90e4cb2e719),
        UINT64_C(0x1f43074f2cb5a71f), UINT64_C(0x1f42f9cf3cb026f6)
    },
    {   UINT64_C(0x00000000000064b2), UINT64_C(0x1f43080f3cb3e70f), UINT64_C(0x1f42fd0e7cb64706),
        UINT64_C(0x1f42fb0f4cb726fb), UINT64_C(0x1f42f80f58b846fe)
    },
    {   UINT64_C(0x00000000000064b3), UINT64_C(0x1f42f90fc0b466fa), UINT64_C(0x1f42fb0ec0b16709),
        UINT64_C(0x1f42fc0f88b5e6fb), UINT64_C(0x1f42fd0fecb2c6f8)
    },
    {   UINT64_C(0x00000000000064b4), UINT64_C(0x1f42fecf9cafc6f7), UINT64_C(0x1f42fd0f9cb40701),
        UINT64_C(0x1f42face5cbac734), UINT64_C(0x1f42fdcf50ac26f6)
    },
    {   UINT64_C(0x00000000000064b5), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fecfbcafc702),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0ef4a7e6fe)
    },
    {   UINT64_C(0x00000000000064b6), UINT64_C(0x1f42fdd028b166f6), UINT64_C(0x1f42fecf6cb2e6ff),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000064b7), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb0f0cb26702),
        UINT64_C(0x1f42fc0fb8afc705), UINT64_C(0x1f42fc0f40b066f7)
    },
    {   UINT64_C(0x00000000000064b8), UINT64_C(0x1f42fc0fa4b786fe), UINT64_C(0x1f42f90f78b98711),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000064b9), UINT64_C(0x1f42f70fdcb2a715), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f90ee4af46fe), UINT64_C(0x1f42ffcf44b726fe)
    },
    {   UINT64_C(0x00000000000064ba), UINT64_C(0x1f42fc0f80b0a702), UINT64_C(0x1f42f90f9caf06fa),
        UINT64_C(0x1f42f70f40af870a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000064bb), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f8cfb4b60717),
        UINT64_C(0x1f42fc0f28b3a706), UINT64_C(0x1f42fecfb8b28700)
    },
    {   UINT64_C(0x00000000000064bc), UINT64_C(0x1f42f91088b3c6fd), UINT64_C(0x1f42f90f7cb126fe),
        UINT64_C(0x1f42fa0f7cb58708), UINT64_C(0x1f42f54e8cb7e703)
    },
    {   UINT64_C(0x00000000000064bd), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fb0edcb826e1)
    },
    {   UINT64_C(0x00000000000064be), UINT64_C(0x1f42f80f34b16706), UINT64_C(0x1f42f54f18b766f0),
        UINT64_C(0x1f42f90fccb626fa), UINT64_C(0x1f43080ee8b366ea)
    },
    {   UINT64_C(0x00000000000064bf), UINT64_C(0x1f42f84f50b0c726), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fa0ee4adc702), UINT64_C(0x1f42fb1008b226f1)
    },
    {   UINT64_C(0x00000000000064c0), UINT64_C(0x1f42fd0fccb7a702), UINT64_C(0x1f42f70e68b82716),
        UINT64_C(0x1f42f64facb54719), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000064c1), UINT64_C(0x1f42f50ed8b6a734), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f70ee0b3a729), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000013858), UINT64_C(0x0e7af58fa093c675), UINT64_C(0x1442f64f68980675),
        UINT64_C(0x0f6300cfa0934675), UINT64_C(0x1953070fa0b6e675)
    },
    {   UINT64_C(0x0000000000013859), UINT64_C(0x1452e80fa09ec675), UINT64_C(0x0e52f88fa090c675),
        UINT64_C(0x11b2f80f747fa5a1), UINT64_C(0x12b2f4cf74844693)
    },
    {   UINT64_C(0x00000000000064c4), UINT64_C(0x1f42f9cf28b3e715), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f60f00b986e0), UINT64_C(0x1f42f64efcb7070b)
    },
    {   UINT64_C(0x00000000000064c5), UINT64_C(0x1f42f90ee4b786f9), UINT64_C(0x1f42f9101cb7e71c),
        UINT64_C(0x1f430e8eb8b5871c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000064c6), UINT64_C(0x1f42fa1004b6270c), UINT64_C(0x1f42f74fbcae8707),
        UINT64_C(0x1f42fa0e94b4c729), UINT64_C(0x1f42fecf18b726ff)
    },
    {   UINT64_C(0x00000000000064c7), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f64ef4b2a6fc),
        UINT64_C(0x1f42f90eb8b4672c), UINT64_C(0x1f42f94f34b546fd)
    },
    {   UINT64_C(0x000000000001385e), UINT64_C(0x13fafc0fa094c594), UINT64_C(0x116af18fa083c594),
        UINT64_C(0x0ebaef4c3881c594), UINT64_C(0x10e2f34fa080c594)
    },
    {   UINT64_C(0x00000000000064c9), UINT64_C(0x1f42f64f30b026fc), UINT64_C(0x1f42f64ed0aba6fc),
        UINT64_C(0x1f42fbce7cad472d), UINT64_C(0x1f42f84edcb5e6ee)
    },
    {   UINT64_C(0x00000000000064ca), UINT64_C(0x1f42f4cf90b16702), UINT64_C(0x1f42f60f90afa70c),
        UINT64_C(0x1f42f80f80b44718), UINT64_C(0x1f42fb0ef8b0e6f6)
    },
    {   UINT64_C(0x00000000000064cb), UINT64_C(0x1f42f84ef8b6672e), UINT64_C(0x1f42f94f60aee703),
        UINT64_C(0x1f42f81028ae6711), UINT64_C(0x1f42fd0f70b4672a)
    },
    {   UINT64_C(0x00000000000064cc), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f14f28ba06f2), UINT64_C(0x1f42f7502cb426fb)
    },
    {   UINT64_C(0x00000000000064cd), UINT64_C(0x1f42f94fecb00703), UINT64_C(0x1f42f64fb4b7e702),
        UINT64_C(0x1f42f90f34b7c738), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000637b), UINT64_C(0x1f42fc8fdcb446f6), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f70fdcb3e6ba), UINT64_C(0x1f42f98f3cb86718)
    },
    {   UINT64_C(0x000000000000637c), UINT64_C(0x1f42fecf28ae26fc), UINT64_C(0x1f42f70e8cb50725),
        UINT64_C(0x1f42facf1cb9a6d2), UINT64_C(0x1f42fed068b6c6f7)
    },
    {   UINT64_C(0x000000000000637d), UINT64_C(0x1f42fb4fecb626b8), UINT64_C(0x1f4301cefcb20717),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff8fd4b56706)
    },
    {   UINT64_C(0x000000000000637e), UINT64_C(0x1f4304ceb8b2a6ff), UINT64_C(0x1f42ff4fb8b546cf),
        UINT64_C(0x1f42fececcb726e7), UINT64_C(0x1f43018ef8b566fb)
    },
    {   UINT64_C(0x00000000000064d2), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0f78b406f3),
        UINT64_C(0x1f42f90ef8b6a72e), UINT64_C(0x1f42fd0efcb206f9)
    },
    {   UINT64_C(0x00000000000064d3), UINT64_C(0x1f430f4ec0b00726), UINT64_C(0x1f42f90f54b58722),
        UINT64_C(0x1f42fd0f10b106db), UINT64_C(0x1f42fd0e2cb26710)
    },
    {   UINT64_C(0x0000000000006381), UINT64_C(0x1f42f54e70af6718), UINT64_C(0x1f430dcea0a6a70d),
        UINT64_C(0x1f42fc0f1cb8071a), UINT64_C(0x1f42fbcf00b4671f)
    },
    {   UINT64_C(0x00000000000064d5), UINT64_C(0x1f42feceecb42707), UINT64_C(0x1f42fa0e3cb486df),
        UINT64_C(0x1f42f70f14b4e6fb), UINT64_C(0x1f42fd0e40b64706)
    },
    {   UINT64_C(0x00000000000064d6), UINT64_C(0x1f42fa0f8cac66fa), UINT64_C(0x1f43114ea0b2873a),
        UINT64_C(0x1f42f70ea4b26706), UINT64_C(0x1f42f50f48b9c721)
    },
    {   UINT64_C(0x00000000000064d7), UINT64_C(0x1f42f70f64b86702), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f84f10a946fe), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000064d8), UINT64_C(0x1f42fa0fa4b2c704), UINT64_C(0x1f42fd0f64b606db),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f94f28b3471e)
    },
    {   UINT64_C(0x00000000000064d9), UINT64_C(0x1f42fa0fd0b366f5), UINT64_C(0x1f42fb0f78b346fc),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0ed0afe6f9)
    },
    {   UINT64_C(0x0000000000013870), UINT64_C(0x14b2fd0fa08ce67e), UINT64_C(0x1192fd0fa091a67e),
        UINT64_C(0x14a2f50fa08d868a), UINT64_C(0x13fafd0fa091867e)
    },
    {   UINT64_C(0x00000000000064db), UINT64_C(0x1f42f50efcb646f7), UINT64_C(0x1f42f60f84b4c6e1),
        UINT64_C(0x1f42f40ea0b8a72b), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000064dc), UINT64_C(0x1f42fb0f48b66717), UINT64_C(0x1f42fd0eacb7670a),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000064dd), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f7cfa4b6e711),
        UINT64_C(0x1f42fd0f84b506db), UINT64_C(0x1f42fd0f9cb92703)
    },
    {   UINT64_C(0x00000000000064de), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd0f80b4e6df),
        UINT64_C(0x1f42f90f1cadc6fe), UINT64_C(0x1f42fd0ea8b166e1)
    },
    {   UINT64_C(0x00000000000064df), UINT64_C(0x1f42f80f20b6271f), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fc1010b36705), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000013876), UINT64_C(0x1252f9cf788b85b7), UINT64_C(0x10baeb0c44846693),
        UINT64_C(0x0fbb030c408065b7), UINT64_C(0x0f8af58f7881a693)
    },
    {   UINT64_C(0x0000000000013877), UINT64_C(0x0f72f6cf787b05b7), UINT64_C(0x0d6af60c4c774693),
        UINT64_C(0x0f6af78c447b45b7), UINT64_C(0x1032fe4f787e6693)
    },
    {   UINT64_C(0x00000000000064e2), UINT64_C(0x1f42fa0f94b1c711), UINT64_C(0x1f42f94ec8adc6fa),
        UINT64_C(0x1f42fb0f00b36725), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000064e3), UINT64_C(0x1f42f80f48b92739), UINT64_C(0x1f42f94f1cb2271d),
        UINT64_C(0x1f42f90f8cb68726), UINT64_C(0x1f43034ed8b66731)
    },
    {   UINT64_C(0x00000000000064e4), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd0fc0b446ff),
        UINT64_C(0x1f42f90ed0b0a704), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000001387b), UINT64_C(0x1012fd4f787bc5b7), UINT64_C(0x14cafbcc408ea5b8),
        UINT64_C(0x1012dc0c448385b7), UINT64_C(0x147300cc4096a5b5)
    },
    {   UINT64_C(0x00000000000064e6), UINT64_C(0x1f42fb1028aec702), UINT64_C(0x1f42f70eb8b1e6ee),
        UINT64_C(0x1f42fa0f98b386fe), UINT64_C(0x1f42fa0ed8b3072b)
    },
    {   UINT64_C(0x00000000000064e7), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90f78b82708),
        UINT64_C(0x1f42fc0f54b5c714), UINT64_C(0x1f42f90eccb64700)
    },
    {   UINT64_C(0x00000000000064e8), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0fe4b1c6ea),
        UINT64_C(0x1f42fecf3cb00722), UINT64_C(0x1f430b4f10b14722)
    },
    {   UINT64_C(0x00000000000064e9), UINT64_C(0x1f42fd0f28b566ff), UINT64_C(0x1f43098eccb42713),
        UINT64_C(0x1f42f90f00ae26f9), UINT64_C(0x1f42fc0fa0b0470e)
    },
    {   UINT64_C(0x0000000000006397), UINT64_C(0x1f42ffcf10ada6ee), UINT64_C(0x1f42facf74b6a6e6),
        UINT64_C(0x1f42fecf40b166e4), UINT64_C(0x1f42fdce80b40735)
    },
    {   UINT64_C(0x00000000000064eb), UINT64_C(0x1f42fb0f30af8721), UINT64_C(0x1f42fb0eecb3a71b),
        UINT64_C(0x1f42f68f20b74731), UINT64_C(0x1f42fa0ed8b60702)
    },
    {   UINT64_C(0x00000000000064ec), UINT64_C(0x1f42fd1000b2a702), UINT64_C(0x1f42fd0ec0b90702),
        UINT64_C(0x1f42fd0f84b72703), UINT64_C(0x1f42fdcf08b2c72d)
    },
    {   UINT64_C(0x00000000000064ed), UINT64_C(0x1f42fd0fb8b2c715), UINT64_C(0x1f42f90f00b8a700),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fa0f24aec709)
    },
    {   UINT64_C(0x000000000000639b), UINT64_C(0x1f42f58fdcb8470a), UINT64_C(0x1f42f8cea4b1471a),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f64ea4b86717)
    },
    {   UINT64_C(0x000000000000639c), UINT64_C(0x1f42fc4f5cb4e6df), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42fbce94b46740), UINT64_C(0x1f42fb0f28b4e6f6)
    },
    {   UINT64_C(0x000000000000639d), UINT64_C(0x1f42f44f94b466ee), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f7cfb0b7a6ec), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000064f1), UINT64_C(0x1f42f70e90b2e71d), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0fd8b5c6f6)
    },
    {   UINT64_C(0x00000000000064f2), UINT64_C(0x1f42f70f68b6c721), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43084f30b5072a), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000064f3), UINT64_C(0x1f42fb0f9cb44703), UINT64_C(0x1f4300cf1cb0c6fa),
        UINT64_C(0x1f42fc0ec8b346e9), UINT64_C(0x1f42f90fe8b4a70c)
    },
    {   UINT64_C(0x00000000000064f4), UINT64_C(0x1f42f84ec0b6c710), UINT64_C(0x1f42f90eb0ab4716),
        UINT64_C(0x1f42fc0eccb88720), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000064f5), UINT64_C(0x1f42f90f40b3a711), UINT64_C(0x1f42fb0fe8b4e719),
        UINT64_C(0x1f42fa8eacb5e73d), UINT64_C(0x1f42fc1020b8e71d)
    },
    {   UINT64_C(0x00000000000064f6), UINT64_C(0x1f42fb0fc8b466f8), UINT64_C(0x1f42fb0f18b06713),
        UINT64_C(0x1f42fdcfb0b1c703), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000064f7), UINT64_C(0x1f42fb0fa4b486fe), UINT64_C(0x1f42fb0f4cb4a6fe),
        UINT64_C(0x1f42f80ec4b1672e), UINT64_C(0x1f42fb0f94b22715)
    },
    {   UINT64_C(0x0000000000008a5b), UINT64_C(0x1cf2fbd180ab6603), UINT64_C(0x1cf2fbcf1cab656a),
        UINT64_C(0x156afc4d308d267e), UINT64_C(0x156afc4d308d267e)
    },
    {   UINT64_C(0x00000000000064f9), UINT64_C(0x1f42fb0efcb4c72f), UINT64_C(0x1f42f88f84b6670e),
        UINT64_C(0x1f42fe0ff0b2a6ce), UINT64_C(0x1f43028f0cb2e716)
    },
    {   UINT64_C(0x00000000000064fa), UINT64_C(0x1f430d4ee8b4e721), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000003db2), UINT64_C(0x0000000000000000), UINT64_C(0x106b1d578871265b),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000003db3), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106b0bd78868665b), UINT64_C(0x106b0017887fa65b)
    },
    {   UINT64_C(0x00000000000064fd), UINT64_C(0x0000000000000000), UINT64_C(0x1f42fc0eb8b24733),
        UINT64_C(0x1f42fc0e6cb6a725), UINT64_C(0x1f42fc0f60b0e71c)
    },
    {   UINT64_C(0x0000000000003db5), UINT64_C(0x106b099754724678), UINT64_C(0x106aee0fa03e83e8),
        UINT64_C(0x106aec5788756667), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063ac), UINT64_C(0x1f42f38ef0b8c72e), UINT64_C(0x1f42f88e9cb64715),
        UINT64_C(0x1f42f88e9cb64715), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000003db7), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x106aee134c800511), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006501), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f43074edcb52728), UINT64_C(0x1f4300cf5cb646ee)
    },
    {   UINT64_C(0x0000000000006502), UINT64_C(0x0000000000000000), UINT64_C(0x1f42ff0f50b24705),
        UINT64_C(0x1f4300ceecb6e709), UINT64_C(0x1f42f90ef8b0e6f1)
    },
    {   UINT64_C(0x0000000000006503), UINT64_C(0x1f42f84ef4b7272e), UINT64_C(0x1f42fc0e68b22719),
        UINT64_C(0x1f42fecf48b48704), UINT64_C(0x1f42fa0eb0b2273a)
    },
    {   UINT64_C(0x0000000000006504), UINT64_C(0x1f42fa0ea0b5c737), UINT64_C(0x1f42f91018af26fc),
        UINT64_C(0x1f42fb0f00b44705), UINT64_C(0x1f42f90f30b62703)
    },
    {   UINT64_C(0x0000000000006505), UINT64_C(0x1f42fb0ebcaf871d), UINT64_C(0x1f42fc0ec4b386fa),
        UINT64_C(0x1f42f80ed4b42720), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063b3), UINT64_C(0x1f42fa8f68b8c71e), UINT64_C(0x1f430a8e8cb2672c),
        UINT64_C(0x1f430d8f0cac6721), UINT64_C(0x1f42fb8efcb40712)
    },
    {   UINT64_C(0x000000000001389d), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x11d2f3cc388185aa), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x00000000000063b5), UINT64_C(0x1f42f8ceecb0072a), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fdceacb4a71e)
    },
    {   UINT64_C(0x0000000000008a6c), UINT64_C(0x17d2fa8e6497862f), UINT64_C(0x17d2fa8e649786b5),
        UINT64_C(0x17d2fa8e6497871b), UINT64_C(0x17d2fa8e64978728)
    },
    {   UINT64_C(0x000000000000650a), UINT64_C(0x1f42f94f0cb04725), UINT64_C(0x1f42f80f1cb5470e),
        UINT64_C(0x1f42fb0eb4b1472c), UINT64_C(0x1f42fa0ef0b2c72d)
    },
    {   UINT64_C(0x000000000000650b), UINT64_C(0x1f42f90f3cb2271e), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f70e8cb76732), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000650c), UINT64_C(0x1f42fa0eecb4c6fa), UINT64_C(0x1f42fc0fa0b4c706),
        UINT64_C(0x1f42fb0ee0b1c702), UINT64_C(0x1f42f70f50b586fa)
    },
    {   UINT64_C(0x0000000000008a70), UINT64_C(0x1a52fa8dc4a18657), UINT64_C(0x1a52fa8dc4a18657),
        UINT64_C(0x221afa8dc4c28657), UINT64_C(0x221afa8dc4c28657)
    },
    {   UINT64_C(0x000000000000650e), UINT64_C(0x1f42f90e70b2e735), UINT64_C(0x1f42fccfbcb646ec),
        UINT64_C(0x1f42fa0f00b2a719), UINT64_C(0x1f42fa0eb0b6a739)
    },
    {   UINT64_C(0x0000000000008a72), UINT64_C(0x1c72f94d28aaa67e), UINT64_C(0x20b2fe0c64b946b0),
        UINT64_C(0x23caf6cda4c947d3), UINT64_C(0x23caf6cb94c94713)
    },
    {   UINT64_C(0x0000000000006510), UINT64_C(0x1f42fb0f6cb4a725), UINT64_C(0x1f42f44ee0b866ea),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006511), UINT64_C(0x1f42f90edcaf872e), UINT64_C(0x1f42f8ce9cb54731),
        UINT64_C(0x1f42faced8b50700), UINT64_C(0x1f42f90eccb78716)
    },
    {   UINT64_C(0x0000000000003dc9), UINT64_C(0x106af9ce547a269e), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006513), UINT64_C(0x1f42fecee0b3e735), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90e68b14715)
    },
    {   UINT64_C(0x00000000000138aa), UINT64_C(0x17f2f88c38a306dc), UINT64_C(0x0000000000000000),
        UINT64_C(0x15c2f88c389046dc), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000003dcc), UINT64_C(0x106afa4f7479c5a2), UINT64_C(0x106b080fa075c59f),
        UINT64_C(0x106af98fa07985a2), UINT64_C(0x106af8cbfc7a85a2)
    },
    {   UINT64_C(0x0000000000003dcd), UINT64_C(0x106af54c287c65a3), UINT64_C(0x106afb0bfc798596),
        UINT64_C(0x106afb4f74796656), UINT64_C(0x106af8cbfc7a85a6)
    },
    {   UINT64_C(0x0000000000006517), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90ef8b6a71f),
        UINT64_C(0x1f42fdce70b7672c), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006518), UINT64_C(0x1f42fa0edcb7471a), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f90f1cb58728), UINT64_C(0x1f42f84f9cb1671e)
    },
    {   UINT64_C(0x0000000000006519), UINT64_C(0x1f42f80ef8b7c716), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x000000000000651a), UINT64_C(0x1f42facf6cb4c702), UINT64_C(0x1f4301cf70b3c6df),
        UINT64_C(0x1f42f60f90b32728), UINT64_C(0x1f42face94b92752)
    },
    {   UINT64_C(0x0000000000008a7e), UINT64_C(0x12d3034a8c7f269f), UINT64_C(0x12d3034a8c7f269f),
        UINT64_C(0x156afe0f3c8c25fc), UINT64_C(0x156afe0f3c8c25fc)
    },
    {   UINT64_C(0x000000000000651c), UINT64_C(0x1f42f70edcb9271a), UINT64_C(0x1f42f80e4cb6272a),
        UINT64_C(0x1f42fb0e80b60738), UINT64_C(0x1f42f34e8cb74734)
    },
    {   UINT64_C(0x000000000000651d), UINT64_C(0x1f42f80eb0afc736), UINT64_C(0x1f42f60e3cb0c72c),
        UINT64_C(0x1f42f60f2cb6a726), UINT64_C(0x1f42f70e8cb54727)
    },
    {   UINT64_C(0x0000000000008a81), UINT64_C(0x1ce3058b80a646e8), UINT64_C(0x1ce3058b94a646e3),
        UINT64_C(0x1ce3058b94a646e3), UINT64_C(0x24e302cb94c7a6e3)
    },
    {   UINT64_C(0x00000000000138b5), UINT64_C(0x101af38be07ea6dc), UINT64_C(0x0000000000000000),
        UINT64_C(0x120af9cbe082a6dc), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006520), UINT64_C(0x1f42f60f6cb74701), UINT64_C(0x1f42fbce6cb7e72d),
        UINT64_C(0x1f42f60e6cb6c726), UINT64_C(0x1f42fdce54b2e708)
    },
    {   UINT64_C(0x0000000000006521), UINT64_C(0x0000000000000000), UINT64_C(0x1f43250f649046dc),
        UINT64_C(0x1f42fa0ff4b38708), UINT64_C(0x1f42f95008b4270f)
    },
    {   UINT64_C(0x0000000000006522), UINT64_C(0x1f42ff0ed8b20723), UINT64_C(0x1f42ff0f24b54714),
        UINT64_C(0x1f42fd0ec4a60720), UINT64_C(0x1f43000eecaee713)
    },
    {   UINT64_C(0x0000000000006523), UINT64_C(0x1f4301cf78ac6719), UINT64_C(0x1f42f85058b5270f),
        UINT64_C(0x1f42fa0f08b28707), UINT64_C(0x1f42fd0f08ab4705)
    },
    {   UINT64_C(0x0000000000006524), UINT64_C(0x1f42fd0f30a9e70b), UINT64_C(0x0000000000000000),
        UINT64_C(0x1f42f90f78b5e709), UINT64_C(0x1f42f90f04ae6732)
    },
    {   UINT64_C(0x0000000000006525), UINT64_C(0x1f42fd0fb0ae0705), UINT64_C(0x1f42fc0fb0b1c6f3),
        UINT64_C(0x0000000000000000), UINT64_C(0x1f42fd1010b5a705)
    },
    {   UINT64_C(0x0000000000006526), UINT64_C(0x0000000000000000), UINT64_C(0x1f42f90ebcb04707),
        UINT64_C(0x1f42fd0f98b02715), UINT64_C(0x1f42fd102cb4c706)
    },
    {   UINT64_C(0x0000000000006527), UINT64_C(0x1f42fd101cb22711), UINT64_C(0x1f42fe8f94b64708),
        UINT64_C(0x1f42f94edcb3071e), UINT64_C(0x1f42f94f34b0a713)
    },
    {   UINT64_C(0x0000000000017827), UINT64_C(0x1842f80bf49e26ef), UINT64_C(0x17baf90bf49fe6ef),
        UINT64_C(0x1492f90bf49ee6ef), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000008a8c), UINT64_C(0x1402f8cf3c892696), UINT64_C(0x1402f8cd988925f9),
        UINT64_C(0x1402f8ceec8925f9), UINT64_C(0x156afc4f208ce602)
    },
    {   UINT64_C(0x000000000000652a), UINT64_C(0x1f42f84efcb20727), UINT64_C(0x1f42fb0f68ada715),
        UINT64_C(0x1f42fd0fdcb6a711), UINT64_C(0x1f42fa0fe4af2707)
    },
    {   UINT64_C(0x000000000000652b), UINT64_C(0x1f42fd1010b3c703), UINT64_C(0x1f42fd0ec8b10711),
        UINT64_C(0x1f42fa1004b54718), UINT64_C(0x1f42fd1018b4270a)
    },
    {   UINT64_C(0x0000000000008a8f), UINT64_C(0x12c2fa116c838571), UINT64_C(0x12c2fa116c838571),
        UINT64_C(0x0962fd0cf85b45d0), UINT64_C(0x15b2f58fa091867e)
    },
    {   UINT64_C(0x000000000001782c), UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
        UINT64_C(0x0000000000000000), UINT64_C(0x1162bf0c6c7f26a7)
    },
    {   UINT64_C(0x000000000000652e), UINT64_C(0x1f42fb0e6cada705), UINT64_C(0x1f42fb0f88b546f5),
        UINT64_C(0x1f42fd0f44b3070f), UINT64_C(0x1f42fc1008ab4707)
    },
    {   UINT64_C(0x000000000000652f), UINT64_C(0x1f42fd1030aae721), UINT64_C(0x1f4300d02cb4a71a),
        UINT64_C(0x1f42facec8b2c70b), UINT64_C(0x1f42fd104cb18705)
    },
    {   UINT64_C(0x0000000000006530), UINT64_C(0x1f42fb102cb1871e), UINT64_C(0x1f42f81010b4c707),
        UINT64_C(0x1f42fa0fbcad270e), UINT64_C(0x1f42f9cef0b64704)
    },
    {   UINT64_C(0x0000000000006531), UINT64_C(0x1f42fb0fdcae0707), UINT64_C(0x1f42fc0fa8b2c703),
        UINT64_C(0x1f42f70e9cb00702), UINT64_C(0x0000000000000000)
    },
    {   UINT64_C(0x0000000000006532), UINT64_C(0x1f42ffce6cb18707), UINT64_C(0x1f42fd1030ae0705),
        UINT64_C(0x1f42fd0fd8aee705), UINT64_C(0x1f42fd1040b62705)
    },
    {   UINT64_C(0x0000000000006533), U