(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    583746,      14464]
NotebookOptionsPosition[    559203,      13908]
NotebookOutlinePosition[    560325,      13947]
CellTagsIndexPosition[    560282,      13944]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099929872552*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.822.2, CRC 444, A&S 4.4.63", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, {
   3.4940999508525815`*^9, 3.4940999513525825`*^9}}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", " ", "x"}], "]"}]}]}], "+", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["a", "2"], 
      SuperscriptBox["x", "2"]}]}], "]"}], 
   RowBox[{"2", "a"}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, {3.494099930412553*^9, 
   3.4940999308025537`*^9}, {3.4940999623425975`*^9, 3.494099963212599*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcCot", "[", 
     RowBox[{"a_.", "*", "x_"}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", "*", "x"}], "]"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "a"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"a", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
  3.4940972668388243`*^9, 3.4940972723188314`*^9}, {3.494099931842555*^9, 
  3.4940999323025556`*^9}, {3.494099966702604*^9, 3.494099967192604*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}]}], "+", 
  RowBox[{"a", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"x", " ", 
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]]}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.4940999330125566`*^9, 
   3.4940999338225574`*^9}, {3.494099970452609*^9, 3.4940999708926096`*^9}, {
   3.4941000423327093`*^9, 3.49410004268271*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCot", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcCot", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
  3.494099934422559*^9, 3.49409993530256*^9}, {3.4940999738426137`*^9, 
  3.4940999743326144`*^9}, {3.4941000585627327`*^9, 3.4941000590927334`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, 3.494000871198538*^9, 
   3.494043967241784*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Iterated integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4940052861338797`*^9, 3.4940052928402634`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.494005203823172*^9, 
   3.494005223116276*^9}, {3.4940055732323008`*^9, 3.4940055743073626`*^9}, 
   3.4940057909347525`*^9, 3.494006120923627*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"], 
       RowBox[{"2", 
        SuperscriptBox["a", "2"]}]]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "2"], 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], "2"], "+", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"2", "a"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.4940050446890697`*^9, 
   3.4940051357132764`*^9}, {3.494005409976963*^9, 3.494005469155348*^9}, {
   3.4940101517571774`*^9, 3.494010179840784*^9}, {3.494010370766704*^9, 
   3.4940103752849627`*^9}, {3.4940162937814813`*^9, 
   3.4940162949895506`*^9}, {3.4940163653905773`*^9, 
   3.4940163811714797`*^9}, {3.494043967248784*^9, 3.494043967259785*^9}, {
   3.4940450122855573`*^9, 3.494045012763584*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4940053078671227`*^9, 3.494005310026246*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", 
       RowBox[{"a", "^", "2"}]}], ")"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", "2"}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "a"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", "*", "x"}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.494004039303565*^9, 3.4940040800098934`*^9}, {3.4940049144956236`*^9, 
   3.4940049151486607`*^9}, {3.4940049727389545`*^9, 
   3.4940049792463264`*^9}, {3.4940054842162094`*^9, 3.494005590086265*^9}, 
   3.494005794311946*^9, {3.494006124318821*^9, 3.494006126234931*^9}, 
   3.4940095020830183`*^9, {3.494010209237465*^9, 3.494010224615345*^9}, {
   3.4940103892347603`*^9, 3.4940104095319214`*^9}, {3.494016295469578*^9, 
   3.4940162965656404`*^9}, 3.4940163483986053`*^9, {3.4940163845786743`*^9, 
   3.4940163849816976`*^9}, {3.4940439672657857`*^9, 3.494043967269786*^9}, {
   3.4940450284124794`*^9, 3.4940450287664995`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Iterated integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4940052861338797`*^9, 3.4940052928402634`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.494005203823172*^9, 
   3.494005223116276*^9}, {3.494005912167687*^9, 3.494005912167687*^9}, {
   3.494005996704522*^9, 3.494006005111003*^9}, {3.4940120035220923`*^9, 
   3.4940120062372475`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
   RowBox[{"m", "+", "1"}]], "+", 
  "                                                ", "\[IndentingNewLine]", 
  "                                                ", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "1"}], 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.4940050446890697`*^9, 
   3.4940051357132764`*^9}, {3.494010254898077*^9, 3.4940102990006*^9}, {
   3.494010355515832*^9, 3.4940103650133753`*^9}, {3.4940156306725535`*^9, 
   3.494015641501173*^9}, {3.494015829505926*^9, 3.494015853240284*^9}, {
   3.4940162969736643`*^9, 3.494016298606757*^9}, {3.4940165403365836`*^9, 
   3.494016550208148*^9}, {3.494043967272786*^9, 3.494043967276786*^9}, {
   3.494045073227043*^9, 3.494045075381166*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4940053078671227`*^9, 3.494005310026246*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.494004039303565*^9, 3.4940040800098934`*^9}, {3.4940049144956236`*^9, 
   3.4940049151486607`*^9}, {3.4940049727389545`*^9, 3.4940049792463264`*^9}, 
   3.4940059089755044`*^9, {3.494006032487569*^9, 3.4940060554328814`*^9}, 
   3.4940094923844633`*^9, {3.4940103280942636`*^9, 3.4940103492304726`*^9}, {
   3.4940104554925504`*^9, 3.4940104824550924`*^9}, {3.4940119781816435`*^9, 
   3.494011987537178*^9}, {3.4940162991437883`*^9, 3.494016304527096*^9}, 
   3.4940164856854577`*^9, {3.4940165324881344`*^9, 3.4940165351962895`*^9}, {
   3.494043967279786*^9, 3.4940439672877865`*^9}, {3.494045105019861*^9, 
   3.494045105559892*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "2"}]}], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
    RowBox[{"ArcCoth", "[", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{"2", "I"}], 
       RowBox[{"I", "-", 
        RowBox[{"a", " ", "x"}]}]]}], "]"}]}]}], "+", 
  RowBox[{"2", "a", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"ArcCoth", "[", 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"2", "I"}], 
          RowBox[{"I", "-", 
           RowBox[{"a", " ", "x"}]}]]}], "]"}]}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 PageWidth->Infinity,
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.494000871274542*^9, 
   3.4940008712805424`*^9}, {3.4940172663621097`*^9, 3.494017296684844*^9}, {
   3.494017348959834*^9, 3.494017350127901*^9}, {3.49401774681359*^9, 
   3.4940177739541426`*^9}, {3.494043967300788*^9, 3.4940439673047876`*^9}, {
   3.4940463568784637`*^9, 3.4940463572084827`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", "x_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{"ArcCoth", "[", 
      RowBox[{"1", "-", 
       RowBox[{"2", "*", 
        RowBox[{"I", "/", 
         RowBox[{"(", 
          RowBox[{"I", "-", 
           RowBox[{"a", "*", "x"}]}], ")"}]}]}]}], "]"}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "a", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCoth", "[", 
           RowBox[{"1", "-", 
            RowBox[{"2", "*", 
             RowBox[{"I", "/", 
              RowBox[{"(", 
               RowBox[{"I", "-", 
                RowBox[{"a", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
  3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
  3.4930995793864517`*^9}, {3.494000871289543*^9, 3.494000871296543*^9}, {
  3.4940178019527435`*^9, 3.4940178274122*^9}, {3.494043967307788*^9, 
  3.4940439673137884`*^9}, {3.4940463693191752`*^9, 3.494046369618192*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.4940131571360755`*^9, 
   3.494013161549328*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     SuperscriptBox["x", "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], "x"]}]}]}]}]}], "-", 
  RowBox[{"a", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["x", "2"]}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.494013179298343*^9, 3.4940132717176294`*^9}, {
   3.4940167360667787`*^9, 3.494016736987831*^9}, {3.494016997482731*^9, 
   3.4940169979477572`*^9}, {3.4940439673167887`*^9, 3.4940439673187885`*^9}, 
   3.4940452711873655`*^9, {3.4940463899073524`*^9, 3.4940464109045534`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"x_", "^", "2"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], "/", "x"}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"x", "*", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              RowBox[{"a", "^", "2"}], "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.4940040426067543`*^9, 3.494004046872998*^9}, {3.494009552628909*^9, 
   3.494009555663083*^9}, {3.4940116323648634`*^9, 3.4940116363310905`*^9}, {
   3.494013128108415*^9, 3.494013131212593*^9}, {3.4940133353222675`*^9, 
   3.494013406482337*^9}, {3.4940167378098783`*^9, 3.49401673854792*^9}, {
   3.4940170167108307`*^9, 3.4940170178968983`*^9}, {3.4940439673207884`*^9, 
   3.4940439673237886`*^9}, {3.4940452806869087`*^9, 3.4940452810289288`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Inverted iterated integration by parts special case\
\>", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4940052861338797`*^9, 3.4940052928402634`*^9}, {3.494011690737202*^9, 
  3.494011693788377*^9}, {3.4940168132141914`*^9, 3.494016815887344*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.494005203823172*^9, 
   3.494005223116276*^9}, {3.494005912167687*^9, 3.494005912167687*^9}, {
   3.494005996704522*^9, 3.494006005111003*^9}, {3.4940117189798174`*^9, 
   3.494011721274949*^9}, {3.494011926169668*^9, 3.4940119289428267`*^9}, {
   3.4940120348468843`*^9, 3.494012036980006*^9}, {3.494012573744707*^9, 
   3.4940125763308554`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     SuperscriptBox["x", "3"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["a", "2"], 
         SuperscriptBox[
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"]}], "2"]}]}]}]}]}], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"2", 
    SuperscriptBox["x", "2"]}]], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "1"}]], 
      SuperscriptBox["x", "2"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.4940050446890697`*^9, 
   3.4940051357132764`*^9}, {3.494010254898077*^9, 3.4940102990006*^9}, {
   3.494010355515832*^9, 3.4940103650133753`*^9}, 3.4940116760473623`*^9, {
   3.4940120899150343`*^9, 3.494012256009534*^9}, 3.494012321413275*^9, 
   3.494012355001196*^9, 3.4940166927783027`*^9, {3.494016739009947*^9, 
   3.4940167402410173`*^9}, {3.4940439673257885`*^9, 3.494043967329789*^9}, {
   3.494045153694645*^9, 3.494045154000663*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4940053078671227`*^9, 3.494005310026246*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"x_", "^", "3"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"a", "^", "2"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", "2"}]}], " ", "-", 
    " ", 
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", 
       RowBox[{"x", "^", "2"}]}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "/", 
         RowBox[{"x", "^", "2"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.494004039303565*^9, 3.4940040800098934`*^9}, {3.4940049144956236`*^9, 
   3.4940049151486607`*^9}, {3.4940049727389545`*^9, 3.4940049792463264`*^9}, 
   3.4940059089755044`*^9, {3.494006032487569*^9, 3.4940060554328814`*^9}, 
   3.4940094923844633`*^9, {3.4940103280942636`*^9, 3.4940103492304726`*^9}, {
   3.4940104554925504`*^9, 3.4940104824550924`*^9}, {3.4940117336926594`*^9, 
   3.494011876094804*^9}, {3.4940120191709876`*^9, 3.4940120264064016`*^9}, {
   3.494012388532114*^9, 3.4940124429682274`*^9}, {3.4940125561557016`*^9, 
   3.4940125689854355`*^9}, {3.4940167439892316`*^9, 3.4940167473774257`*^9}, 
   3.4940167855246077`*^9, {3.494043967331789*^9, 3.4940439673357897`*^9}, {
   3.4940451574428596`*^9, 3.4940451577748785`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Inverted iterated integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4940052861338797`*^9, 3.4940052928402634`*^9}, {3.494011690737202*^9, 
  3.494011693788377*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", "<", 
    RowBox[{"-", "3"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.493098879405472*^9, 3.493098884745479*^9}, {3.493099207935931*^9, 
   3.4930992149659414`*^9}, 3.4930996737265835`*^9, 3.493099827186798*^9, {
   3.4932434943005557`*^9, 3.493243522320595*^9}, {3.494005203823172*^9, 
   3.494005223116276*^9}, {3.494005912167687*^9, 3.494005912167687*^9}, {
   3.494005996704522*^9, 3.494006005111003*^9}, {3.4940117189798174`*^9, 
   3.494011721274949*^9}, {3.494011926169668*^9, 3.4940119289428267`*^9}, {
   3.4940120348468843`*^9, 3.494012036980006*^9}, {3.494013442081373*^9, 
   3.494013450779871*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "3"}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
   RowBox[{"m", "+", "1"}]], "+", 
  "                                                ", "\[IndentingNewLine]", 
  "                                                ", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], 
     RowBox[{"(", 
      RowBox[{"m", "+", "3"}], ")"}]}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493098332554706*^9, 3.4930984922049294`*^9}, {
   3.4930985835950575`*^9, 3.4930986777351894`*^9}, {3.4930988533254347`*^9, 
   3.4930988578754416`*^9}, {3.493099207935931*^9, 3.4930992149659414`*^9}, {
   3.4930993574561405`*^9, 3.493099400886202*^9}, {3.493099526816378*^9, 
   3.49309953534639*^9}, 3.4931705981281786`*^9, {3.493170768098417*^9, 
   3.4931708122284784`*^9}, {3.4940050446890697`*^9, 
   3.4940051357132764`*^9}, {3.494010254898077*^9, 3.4940102990006*^9}, {
   3.494010355515832*^9, 3.4940103650133753`*^9}, 3.4940116760473623`*^9, {
   3.4940156538678803`*^9, 3.494015661870338*^9}, {3.494015862381807*^9, 
   3.4940158673580914`*^9}, {3.4940167491765285`*^9, 3.494016750724617*^9}, {
   3.4940168803370304`*^9, 3.4940168889155207`*^9}, {3.49404396733879*^9, 
   3.4940439673427896`*^9}, {3.494045214578128*^9, 3.494045215044154*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4940053078671227`*^9, 3.494005310026246*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"a", "^", "2"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "3"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "3"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "3"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928302625720215`*^9, 3.4928303000920744`*^9}, {
   3.4928305645624447`*^9, 3.4928305746224585`*^9}, {3.4930994731463027`*^9, 
   3.4930995793864517`*^9}, {3.4931708257484975`*^9, 3.493170933088648*^9}, {
   3.493170964658692*^9, 3.4931709750387063`*^9}, {3.493171201919024*^9, 
   3.493171205079028*^9}, {3.493171366199254*^9, 3.4931713665792546`*^9}, {
   3.4931715056494493`*^9, 3.49317150626945*^9}, {3.4932434733805265`*^9, 
   3.4932434776305323`*^9}, 3.4932442598016276`*^9, 3.4932444119118404`*^9, {
   3.494004039303565*^9, 3.4940040800098934`*^9}, {3.4940049144956236`*^9, 
   3.4940049151486607`*^9}, {3.4940049727389545`*^9, 3.4940049792463264`*^9}, 
   3.4940059089755044`*^9, {3.494006032487569*^9, 3.4940060554328814`*^9}, 
   3.4940094923844633`*^9, {3.4940103280942636`*^9, 3.4940103492304726`*^9}, {
   3.4940104554925504`*^9, 3.4940104824550924`*^9}, {3.4940117336926594`*^9, 
   3.494011876094804*^9}, {3.4940120191709876`*^9, 3.4940120264064016`*^9}, {
   3.4940134559001637`*^9, 3.4940134576452637`*^9}, {3.494016751700673*^9, 
   3.4940167559439154`*^9}, {3.49401691075677*^9, 3.4940169159970703`*^9}, {
   3.4940439673467903`*^9, 3.4940439673537903`*^9}, {3.494045218080328*^9, 
   3.494045218450349*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, 3.492913326383937*^9, {3.4931451285332985`*^9, 
   3.4931451299433002`*^9}, 3.4940008713405457`*^9, 3.4940439673557906`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4931456018039613`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    SuperscriptBox["d", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.493581126911767*^9, 3.493581143581791*^9}, {
   3.4940337767420216`*^9, 3.494033781042267*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
         RowBox[{"Log", "[", 
          FractionBox[
           RowBox[{"2", " ", "c"}], 
           RowBox[{"c", " ", "+", 
            RowBox[{"d", " ", "x"}]}]], "]"}]}], "d"]}]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], "d"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"Log", "[", 
        FractionBox[
         RowBox[{"2", " ", "c"}], 
         RowBox[{"c", " ", "+", 
          RowBox[{"d", " ", "x"}]}]], "]"}]}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.4931446954326925`*^9, 3.493144762932787*^9}, 3.4931448959029727`*^9, {
   3.493144975223084*^9, 3.4931449799230905`*^9}, {3.4931453401435947`*^9, 
   3.4931453627536263`*^9}, 3.4931456018039613`*^9, {3.4931469777458878`*^9, 
   3.4931469799558907`*^9}, {3.4940008713645473`*^9, 
   3.4940008713685474`*^9}, {3.4940233075696473`*^9, 3.494023307900666*^9}, {
   3.4940340310215654`*^9, 3.4940340485815697`*^9}, {3.494034864796254*^9, 
   3.4940348686954775`*^9}, {3.4940376218759503`*^9, 
   3.4940376263072042`*^9}, {3.494043967357791*^9, 3.494043967359791*^9}, {
   3.494046518078684*^9, 3.494046518606714*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"2", "*", 
        RowBox[{"c", "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], ")"}]}]}], "]"}], "/", "d"}]}], " ", 
    "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", "d"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"2", "*", 
            RowBox[{"c", "/", 
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], ")"}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "+", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4930740306333447`*^9, 3.4930740321133466`*^9}, {3.493144462352366*^9, 
   3.493144468172374*^9}, {3.493144540822476*^9, 3.4931445433324795`*^9}, {
   3.4931445892825437`*^9, 3.4931445898425446`*^9}, {3.493145449723748*^9, 
   3.493145475833785*^9}, {3.49358106455168*^9, 3.493581066611683*^9}, {
   3.493748575803213*^9, 3.4937486011688576`*^9}, {3.4940008713785477`*^9, 
   3.4940008713835483`*^9}, {3.49402332003436*^9, 3.4940233203603783`*^9}, {
   3.4940349261607647`*^9, 3.494034948444039*^9}, {3.494037644559248*^9, 
   3.494037647619423*^9}, {3.494043967362791*^9, 3.4940439673667912`*^9}, {
   3.4940465310984287`*^9, 3.494046533169547*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, 3.492913326383937*^9, {3.4929975742692375`*^9, 
   3.492997579510846*^9}, {3.4931465961853533`*^9, 3.493146597295355*^9}, 
   3.4940008713975487`*^9, 3.494043967367791*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4931456018039613`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    SuperscriptBox["d", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4935811541318054`*^9, 
   3.4935811541318054`*^9}, {3.493581238921924*^9, 3.493581239361925*^9}, {
   3.4940350410063334`*^9, 3.4940350410063334`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"2", "-", 
          FractionBox[
           RowBox[{"2", " ", "c"}], 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}]]}], "]"}]}], "c"]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"2", "-", 
         FractionBox[
          RowBox[{"2", " ", "c"}], 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}]]}], "]"}]}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.4931446954326925`*^9, 3.493144762932787*^9}, 3.4931448959029727`*^9, {
   3.493144975223084*^9, 3.4931449799230905`*^9}, {3.4931453401435947`*^9, 
   3.4931453627536263`*^9}, 3.4931456018039613`*^9, {3.4931466620154457`*^9, 
   3.493146720405527*^9}, {3.493146762375586*^9, 3.4931467629255867`*^9}, {
   3.4931574816798153`*^9, 3.4931574860698223`*^9}, {3.4940008714095497`*^9, 
   3.49400087141255*^9}, {3.4940233469749007`*^9, 3.4940233473049197`*^9}, {
   3.4940351028428698`*^9, 3.49403510668709*^9}, {3.4940351860366287`*^9, 
   3.494035189296815*^9}, {3.4940382334609313`*^9, 3.4940382496008544`*^9}, {
   3.4940439673707914`*^9, 3.4940439673727913`*^9}, 3.494046590261812*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", "x_"}]}], ")"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"2", "-", 
        RowBox[{"2", "*", 
         RowBox[{"c", "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", "c"}]}], " ", 
    "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", "c"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"2", "-", 
            RowBox[{"2", "*", 
             RowBox[{"c", "/", 
              RowBox[{"(", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "+", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4930740306333447`*^9, 3.4930740321133466`*^9}, {3.493144462352366*^9, 
   3.493144468172374*^9}, {3.493144540822476*^9, 3.4931445433324795`*^9}, {
   3.4931445892825437`*^9, 3.4931445898425446`*^9}, {3.493145449723748*^9, 
   3.493145475833785*^9}, {3.493146638085412*^9, 3.4931466465254235`*^9}, {
   3.4931467543555746`*^9, 3.4931467820656137`*^9}, {3.493146817405663*^9, 
   3.493146854555715*^9}, {3.493147492576608*^9, 3.493147492956609*^9}, {
   3.4931575219698725`*^9, 3.4931575367198925`*^9}, 3.4931584323211465`*^9, {
   3.4935810314016333`*^9, 3.493581033811637*^9}, {3.49400087142255*^9, 
   3.494000871427551*^9}, {3.494023351261146*^9, 3.494023351590165*^9}, 
   3.4940350772864084`*^9, {3.494035234439397*^9, 3.494035246645095*^9}, {
   3.494038279684575*^9, 3.4940382928623285`*^9}, {3.4940439673757915`*^9, 
   3.494043967378792*^9}, {3.4940466483561354`*^9, 3.4940466487061553`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{3.4931456018039613`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    SuperscriptBox["d", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.493581162211817*^9, 3.493581162211817*^9}, {
   3.493581231631914*^9, 3.4935812320219145`*^9}, {3.494035044948559*^9, 
   3.494035044948559*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{
      RowBox[{"c", " ", "x"}], "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"2", "-", 
          FractionBox[
           RowBox[{"2", " ", "c"}], 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}]]}], "]"}]}], "c"]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"2", "-", 
         FractionBox[
          RowBox[{"2", " ", "c"}], 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}]]}], "]"}]}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.4931446954326925`*^9, 3.493144762932787*^9}, 3.4931448959029727`*^9, {
   3.493144975223084*^9, 3.4931449799230905`*^9}, {3.4931453401435947`*^9, 
   3.4931453627536263`*^9}, 3.4931456018039613`*^9, {3.4931466620154457`*^9, 
   3.493146720405527*^9}, {3.493146762375586*^9, 3.4931467629255867`*^9}, {
   3.4931574816798153`*^9, 3.4931574860698223`*^9}, {3.493158351951034*^9, 
   3.4931583622410483`*^9}, {3.4940008714415517`*^9, 
   3.4940008714445515`*^9}, {3.4940233564294415`*^9, 3.494023356785462*^9}, {
   3.494035300428171*^9, 3.494035302343281*^9}, 3.4940383033989315`*^9, {
   3.494043967381792*^9, 3.494043967383792*^9}, {3.4940466704473987`*^9, 
   3.494046670753416*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c_.", "*", "x_"}], "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"2", "-", 
        RowBox[{"2", "*", 
         RowBox[{"c", "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", "c"}]}], " ", 
    "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", "c"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"2", "-", 
            RowBox[{"2", "*", 
             RowBox[{"c", "/", 
              RowBox[{"(", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "+", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4930740306333447`*^9, 3.4930740321133466`*^9}, {3.493144462352366*^9, 
   3.493144468172374*^9}, {3.493144540822476*^9, 3.4931445433324795`*^9}, {
   3.4931445892825437`*^9, 3.4931445898425446`*^9}, {3.493145449723748*^9, 
   3.493145475833785*^9}, {3.493146638085412*^9, 3.4931466465254235`*^9}, {
   3.4931467543555746`*^9, 3.4931467820656137`*^9}, {3.493146817405663*^9, 
   3.493146854555715*^9}, {3.493147492576608*^9, 3.493147492956609*^9}, {
   3.4931575219698725`*^9, 3.4931575367198925`*^9}, {3.493158449661171*^9, 
   3.4931584772112093`*^9}, {3.4935810370816417`*^9, 
   3.4935810386816435`*^9}, {3.4940008714545527`*^9, 
   3.4940008714585524`*^9}, {3.494023359340608*^9, 3.494023359702629*^9}, 
   3.4940350808336115`*^9, 3.4940353133719115`*^9, 3.4940383116564035`*^9, {
   3.494043967386792*^9, 3.4940439673897924`*^9}, {3.494046690435542*^9, 
   3.49404669075056*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["x", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], "\[Equal]", 
   RowBox[{
    FractionBox["1", "d"], "-", 
    FractionBox["c", 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664443126074*^9, 3.479664484795992*^9, {3.479686720494632*^9, 
   3.479686740223*^9}, {3.4929978496877213`*^9, 3.4929978567233334`*^9}, {
   3.4929979016982126`*^9, 3.492997933194668*^9}, 3.4929979741135397`*^9, {
   3.4932342226975756`*^9, 3.4932342226975756`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    SuperscriptBox["d", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4932344140978436`*^9, 3.493234436457875*^9}, 
   3.4932344713679237`*^9, 3.493234764358334*^9, {3.493581169571827*^9, 
   3.4935812149118905`*^9}, {3.494035048904785*^9, 3.494035048904785*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "d"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "-", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["c", "d"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "-", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.49299802556243*^9, 3.492998081316928*^9}, {3.4932341813675175`*^9, 
   3.4932341825075192`*^9}, {3.4932342504576144`*^9, 3.493234254887621*^9}, {
   3.4932342987776823`*^9, 3.493234348687752*^9}, {3.4940008714755535`*^9, 
   3.494000871478554*^9}, {3.4940439673927927`*^9, 3.4940439673947926`*^9}, {
   3.494046711588752*^9, 3.4940467119107704`*^9}, {3.4940467493119097`*^9, 
   3.4940467496159267`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcCot", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "+", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4929976285885324`*^9, 3.492997657401783*^9}, {3.4929982343063965`*^9, 
   3.492998284850485*^9}, {3.4929983307925663`*^9, 3.4929983346145725`*^9}, {
   3.4929983685134325`*^9, 3.492998380915454*^9}, {3.4929985595281687`*^9, 
   3.492998559886969*^9}, {3.4929986169674697`*^9, 3.4929986552187366`*^9}, {
   3.493145648214026*^9, 3.493145651704031*^9}, {3.493174757504002*^9, 
   3.4931747608840065`*^9}, {3.4932344939779553`*^9, 3.493234517877989*^9}, {
   3.4932345822880793`*^9, 3.4932345974581003`*^9}, {3.493234635668154*^9, 
   3.4932346995382433`*^9}, {3.4935810433816504`*^9, 3.493581045391653*^9}, {
   3.494000871488554*^9, 3.4940008714925547`*^9}, 3.4940350820826826`*^9, {
   3.494043967397793*^9, 3.4940439674017935`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], "\[Equal]", 
   RowBox[{
    FractionBox["1", "c"], "-", 
    FractionBox[
     RowBox[{"d", " ", "x"}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664443126074*^9, 3.479664484795992*^9, {3.479686720494632*^9, 
   3.479686740223*^9}, {3.4929978496877213`*^9, 3.4929978567233334`*^9}, {
   3.4929979016982126`*^9, 3.492997933194668*^9}, 3.4929979741135397`*^9, {
   3.4932342226975756`*^9, 3.4932342226975756`*^9}, {3.4932349492985926`*^9, 
   3.493234969438621*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["c", "2"]}], "+", 
    SuperscriptBox["d", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4932344140978436`*^9, 3.493234436457875*^9}, 
   3.4932344713679237`*^9, 3.493234764358334*^9, {3.493234813308402*^9, 
   3.4932348147484045`*^9}, {3.4932350526787376`*^9, 3.493235052938738*^9}, {
   3.493581174131833*^9, 3.493581183231846*^9}, {3.494035052924015*^9, 
   3.494035052924015*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "c"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["d", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.49299802556243*^9, 3.492998081316928*^9}, {3.4932341813675175`*^9, 
   3.4932341825075192`*^9}, {3.4932342504576144`*^9, 3.493234254887621*^9}, {
   3.4932342987776823`*^9, 3.493234348687752*^9}, {3.4932348327784295`*^9, 
   3.4932348796784954`*^9}, 3.4932349106485386`*^9, {3.4940008715085554`*^9, 
   3.4940008715115557`*^9}, {3.4940439674047937`*^9, 3.4940439674067936`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"d", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcCot", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{"c", "^", "2"}]}], "+", 
      RowBox[{"d", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928386496573954`*^9, 3.4928386538382025`*^9}, {
   3.4928387393419533`*^9, 3.4928388738453894`*^9}, {3.4928392099891806`*^9, 
   3.4928392282724123`*^9}, {3.4928392656204743`*^9, 3.492839265890475*^9}, {
   3.4928393374405746`*^9, 3.492839337970576*^9}, 3.4928413413933806`*^9, {
   3.4929976285885324`*^9, 3.492997657401783*^9}, {3.4929982343063965`*^9, 
   3.492998284850485*^9}, {3.4929983307925663`*^9, 3.4929983346145725`*^9}, {
   3.4929983685134325`*^9, 3.492998380915454*^9}, {3.4929985595281687`*^9, 
   3.492998559886969*^9}, {3.4929986169674697`*^9, 3.4929986552187366`*^9}, {
   3.493145648214026*^9, 3.493145651704031*^9}, {3.493174757504002*^9, 
   3.4931747608840065`*^9}, {3.4932344939779553`*^9, 3.493234517877989*^9}, {
   3.4932345822880793`*^9, 3.4932345974581003`*^9}, {3.493234635668154*^9, 
   3.4932346995382433`*^9}, {3.4932349951286573`*^9, 3.493235049278733*^9}, {
   3.4935810501216593`*^9, 3.4935810521316624`*^9}, {3.494000871521556*^9, 
   3.4940008715255566`*^9}, 3.494035083106741*^9, {3.4940439674087934`*^9, 
   3.494043967412794*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616001935333*^9, 3.4796867203444157`*^9, {3.479687071148848*^9, 
   3.479687071399208*^9}, 3.4928222618129525`*^9, 3.4928258304168224`*^9, {
   3.4929226804037867`*^9, 3.4929226942254105`*^9}, {3.492979990624321*^9, 
   3.4929799910143223`*^9}, {3.493060035696517*^9, 3.4930600483865347`*^9}, 
   3.493253406025427*^9, 3.493274216811039*^9, 3.4940008715395575`*^9, 
   3.494043967413794*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Reciprocal rule for integration", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.49652737814176*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", "c"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.493251623431094*^9, 3.493251640965525*^9}, {
   3.4932516789671917`*^9, 3.4932517129752517`*^9}, {3.4932533772433767`*^9, 
   3.4932533782729783`*^9}, {3.4940219715662317`*^9, 3.494021976495514*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "]"}], 
       RowBox[{"a", " ", "c"}]]}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.49299802556243*^9, 3.492998081316928*^9}, {3.4932341813675175`*^9, 
   3.4932341825075192`*^9}, {3.4932342504576144`*^9, 3.493234254887621*^9}, {
   3.4932342987776823`*^9, 3.493234348687752*^9}, {3.4932348327784295`*^9, 
   3.4932348796784954`*^9}, 3.4932349106485386`*^9, 3.4933189471337347`*^9, {
   3.4940008715485573`*^9, 3.4940008715495577`*^9}, {3.494043967415794*^9, 
   3.494043967416794*^9}, 3.494046878580303*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "*", 
       RowBox[{"ArcCot", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "]"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "*", "c"}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.492985420001458*^9, 3.492985475178755*^9}, {
   3.493059939356382*^9, 3.493059968846423*^9}, {3.4930601293866477`*^9, 
   3.493060137446659*^9}, 3.4930603905470133`*^9, {3.4930623946218204`*^9, 
   3.49306243701188*^9}, {3.4940008715585585`*^9, 3.4940008715605583`*^9}, 
   3.4940219156060314`*^9, {3.494043967418794*^9, 3.4940439674207945`*^9}, 
   3.4940469120922203`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Power rule for integration", "Subsubsection",
 CellChangeTimes->{3.4937489112350025`*^9}],

Cell[TextData[{
 "Rule:",
 " If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, 3.4929244021788106`*^9, {
   3.493060093566598*^9, 3.4930601027066107`*^9}, {3.4932563547390933`*^9, 
   3.493256358729099*^9}, {3.4932563891491413`*^9, 3.4932563891491413`*^9}, {
   3.493581280781983*^9, 3.4935812915719976`*^9}, {3.494021983568918*^9, 
   3.494021986848106*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "+", "1"}]], 
       RowBox[{"a", " ", "c", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927459475946445`*^9, 3.49274596552767*^9}, {
   3.4927470791633663`*^9, 3.492747100502587*^9}, {3.492838456185856*^9, 
   3.492838468151077*^9}, {3.4928389429535108`*^9, 3.492838996648805*^9}, {
   3.492839156730687*^9, 3.4928391643123*^9}, 3.4928403497119923`*^9, {
   3.492908275826866*^9, 3.4929083226469316`*^9}, 3.492910391739828*^9, {
   3.49299802556243*^9, 3.492998081316928*^9}, {3.4932341813675175`*^9, 
   3.4932341825075192`*^9}, {3.4932342504576144`*^9, 3.493234254887621*^9}, {
   3.4932342987776823`*^9, 3.493234348687752*^9}, {3.4932348327784295`*^9, 
   3.4932348796784954`*^9}, 3.4932349106485386`*^9, {3.4933189471337347`*^9, 
   3.4933189614337544`*^9}, {3.494000871574559*^9, 3.494000871575559*^9}, {
   3.4940439674227943`*^9, 3.4940439674237947`*^9}, 3.494046934145481*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}]}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "*", "c", "*", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.492985420001458*^9, 3.492985475178755*^9}, {
   3.493059939356382*^9, 3.493059968846423*^9}, {3.4930601293866477`*^9, 
   3.493060137446659*^9}, 3.4930603905470133`*^9, {3.4935810024215927`*^9, 
   3.4935810041415954`*^9}, {3.4940008715845594`*^9, 3.49400087158656*^9}, 
   3.4940219205923166`*^9, {3.4940439674257946`*^9, 3.494043967426795*^9}, 
   3.4940469381147084`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, 3.4929133195939274`*^9, 3.4931664671723957`*^9, 
   3.493251887352358*^9, 3.4940008716005607`*^9, 3.494043967428795*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["x", 
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["I", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["x", "2"]}]}], ")"}]}]]}], "-", 
    FractionBox["1", 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"I", "-", 
        RowBox[{"a", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.493790149041623*^9, 3.493790149041623*^9}, {
   3.4940237466747627`*^9, 3.494023752087072*^9}, {3.4940238629374123`*^9, 
   3.4940238730189886`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.493251623431094*^9, 3.493251640965525*^9}, {
   3.4932516789671917`*^9, 3.4932517129752517`*^9}, {3.4935813034320145`*^9, 
   3.4935813034320145`*^9}, {3.493581363142098*^9, 3.493581363142098*^9}, {
   3.4940219944315395`*^9, 3.494021997654724*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"I", " ", 
        SuperscriptBox[
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"I", "-", 
       RowBox[{"a", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927426625007477`*^9, 3.492742662695759*^9}, {
   3.4927427022060184`*^9, 3.4927427689718375`*^9}, {3.49274284243804*^9, 
   3.492742899943329*^9}, {3.4927429432068033`*^9, 3.49274296955731*^9}, 
   3.4927430042452946`*^9, {3.4927431140225735`*^9, 3.4927431953072224`*^9}, {
   3.492743302802371*^9, 3.492743321909464*^9}, {3.49274365403046*^9, 
   3.492743699403055*^9}, {3.4927438451893935`*^9, 3.4927438547469406`*^9}, {
   3.492743907312947*^9, 3.4927439763068933`*^9}, {3.4927441805245733`*^9, 
   3.4927442303734245`*^9}, {3.492744267490548*^9, 3.4927442920949554`*^9}, {
   3.492744353045441*^9, 3.492744384969267*^9}, {3.492744450696027*^9, 
   3.4927444509000387`*^9}, {3.492744509440387*^9, 3.4927445278794413`*^9}, {
   3.4927446880156*^9, 3.492744707778731*^9}, {3.492745634407731*^9, 
   3.492745768275388*^9}, 3.492746696296468*^9, {3.4927468384145966`*^9, 
   3.492746872356538*^9}, {3.492839388040646*^9, 3.4928394598207464`*^9}, 
   3.4928397046810894`*^9, {3.492908081426594*^9, 3.4929081433866806`*^9}, 
   3.492910389019825*^9, {3.493251753613323*^9, 3.493251782301773*^9}, {
   3.4932518158262324`*^9, 3.493251846137086*^9}, {3.493412510259725*^9, 
   3.4934125193197374`*^9}, {3.4940008716155615`*^9, 
   3.4940008716185617`*^9}, {3.494023891486045*^9, 3.494023893895183*^9}, {
   3.4940239293812127`*^9, 3.4940239473162384`*^9}, {3.494043967431795*^9, 
   3.494043967433795*^9}, 3.4940471293606467`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"I", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
         RowBox[{"(", 
          RowBox[{"I", "-", 
           RowBox[{"a", "*", "x"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928394899907885`*^9, 3.492839600870944*^9}, {
   3.492839660371027*^9, 3.492839670511041*^9}, {3.492839872431324*^9, 
   3.492839876241329*^9}, 3.4928399970514984`*^9, 3.49284133392337*^9, {
   3.492841789364008*^9, 3.492841792164012*^9}, {3.4934125901798368`*^9, 
   3.4934125945498433`*^9}, {3.493580989441575*^9, 3.493580991871578*^9}, {
   3.4940008716275625`*^9, 3.494000871631562*^9}, 3.4940219210953455`*^9, {
   3.494023971873643*^9, 3.494023986116458*^9}, {3.4940439674357953`*^9, 
   3.4940439674397955`*^9}, 3.494047142734412*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"a", " ", "I"}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]]}], "+", 
    FractionBox["I", 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"I", "+", 
        RowBox[{"a", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, {
   3.4937901559116325`*^9, 3.4937901559116325`*^9}, {3.494024158969344*^9, 
   3.4940241742382174`*^9}, {3.4940242255331516`*^9, 3.4940242255331516`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4931675717539415`*^9, 3.493167580513954*^9}, {
   3.493251958004882*^9, 3.493251958004882*^9}, {3.493581307982021*^9, 
   3.493581307982021*^9}, {3.493581358752092*^9, 3.493581358752092*^9}, {
   3.4937489859591336`*^9, 3.493748987300736*^9}, {3.494022002343992*^9, 
   3.4940220045351176`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"I", " ", 
        SuperscriptBox[
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["I", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"I", "+", 
         RowBox[{"a", " ", "x"}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927426625007477`*^9, 3.492742662695759*^9}, {
   3.4927427022060184`*^9, 3.4927427689718375`*^9}, {3.49274284243804*^9, 
   3.492742899943329*^9}, {3.4927429432068033`*^9, 3.49274296955731*^9}, 
   3.4927430042452946`*^9, {3.4927431140225735`*^9, 3.4927431953072224`*^9}, {
   3.492743302802371*^9, 3.492743321909464*^9}, {3.49274365403046*^9, 
   3.492743699403055*^9}, {3.4927438451893935`*^9, 3.4927438547469406`*^9}, {
   3.492743907312947*^9, 3.4927439763068933`*^9}, {3.4927441805245733`*^9, 
   3.4927442303734245`*^9}, {3.492744267490548*^9, 3.4927442920949554`*^9}, {
   3.492744353045441*^9, 3.492744384969267*^9}, {3.492744450696027*^9, 
   3.4927444509000387`*^9}, {3.492744509440387*^9, 3.4927445278794413`*^9}, {
   3.4927446880156*^9, 3.492744707778731*^9}, {3.492745634407731*^9, 
   3.492745768275388*^9}, 3.492746696296468*^9, {3.4927468384145966`*^9, 
   3.492746872356538*^9}, {3.492839388040646*^9, 3.4928394598207464`*^9}, 
   3.4928397046810894`*^9, {3.492908081426594*^9, 3.4929081433866806`*^9}, 
   3.492910389019825*^9, {3.4931674144637213`*^9, 3.493167425813738*^9}, {
   3.493167688434105*^9, 3.4931676930941114`*^9}, {3.4932519872549334`*^9, 
   3.4932520116689763`*^9}, {3.4940008716485634`*^9, 
   3.4940008716515636`*^9}, {3.4940242549068317`*^9, 
   3.4940242739639215`*^9}, {3.4940439674417953`*^9, 3.4940439674447956`*^9}, 
   3.4940471796655245`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"I", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
         RowBox[{"(", 
          RowBox[{"x", "*", 
           RowBox[{"(", 
            RowBox[{"I", "+", 
             RowBox[{"a", "*", "x"}]}], ")"}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928394899907885`*^9, 3.492839600870944*^9}, {
   3.492839660371027*^9, 3.492839670511041*^9}, {3.492839872431324*^9, 
   3.492839876241329*^9}, 3.4928399970514984`*^9, 3.49284133392337*^9, {
   3.492841789364008*^9, 3.492841792164012*^9}, {3.4931675895939665`*^9, 
   3.49316759898398*^9}, 3.4931676669740753`*^9, {3.4931677271841593`*^9, 
   3.493167763914211*^9}, {3.493580981641564*^9, 3.493580983581567*^9}, {
   3.494000871660564*^9, 3.494000871664564*^9}, 3.494021921125347*^9, {
   3.4940242996993933`*^9, 3.4940243140632153`*^9}, {3.4940439674467955`*^9, 
   3.4940439674497957`*^9}, 3.494047199241644*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"a", " ", "I"}], 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]]}], "+", 
    FractionBox["I", 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"I", "+", 
        RowBox[{"a", " ", "x"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, {
   3.4937901612916403`*^9, 3.4937901612916403`*^9}, {3.4940243596738243`*^9, 
   3.4940243596738243`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.492907662576008*^9, 3.4929076635660095`*^9}, {3.4930735907627287`*^9, 
   3.4930736091827545`*^9}, {3.4931451699433565`*^9, 3.493145207453409*^9}, {
   3.4931452956835327`*^9, 3.4931453218235693`*^9}, {3.4931453713536386`*^9, 
   3.4931453747436433`*^9}, 3.4931456018039613`*^9, {3.493146996085913*^9, 
   3.4931470125759363`*^9}, {3.4931675717539415`*^9, 3.493167580513954*^9}, {
   3.493251958004882*^9, 3.493251958004882*^9}, {3.493581312932028*^9, 
   3.493581312932028*^9}, {3.4935813544820857`*^9, 3.4935813544820857`*^9}, {
   3.4937490542092533`*^9, 3.4937490549580545`*^9}, {3.494022007704299*^9, 
   3.494022010672469*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{
      RowBox[{"c", " ", "x"}], "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "3"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"I", " ", 
        SuperscriptBox[
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["I", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"I", "+", 
         RowBox[{"a", " ", "x"}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.4927426625007477`*^9, 3.492742662695759*^9}, {
   3.4927427022060184`*^9, 3.4927427689718375`*^9}, {3.49274284243804*^9, 
   3.492742899943329*^9}, {3.4927429432068033`*^9, 3.49274296955731*^9}, 
   3.4927430042452946`*^9, {3.4927431140225735`*^9, 3.4927431953072224`*^9}, {
   3.492743302802371*^9, 3.492743321909464*^9}, {3.49274365403046*^9, 
   3.492743699403055*^9}, {3.4927438451893935`*^9, 3.4927438547469406`*^9}, {
   3.492743907312947*^9, 3.4927439763068933`*^9}, {3.4927441805245733`*^9, 
   3.4927442303734245`*^9}, {3.492744267490548*^9, 3.4927442920949554`*^9}, {
   3.492744353045441*^9, 3.492744384969267*^9}, {3.492744450696027*^9, 
   3.4927444509000387`*^9}, {3.492744509440387*^9, 3.4927445278794413`*^9}, {
   3.4927446880156*^9, 3.492744707778731*^9}, {3.492745634407731*^9, 
   3.492745768275388*^9}, 3.492746696296468*^9, {3.4927468384145966`*^9, 
   3.492746872356538*^9}, {3.492839388040646*^9, 3.4928394598207464`*^9}, 
   3.4928397046810894`*^9, {3.492908081426594*^9, 3.4929081433866806`*^9}, 
   3.492910389019825*^9, {3.4931674144637213`*^9, 3.493167425813738*^9}, {
   3.493167688434105*^9, 3.4931676930941114`*^9}, {3.4932519872549334`*^9, 
   3.4932520116689763`*^9}, 3.493252152092824*^9, {3.4940008716815653`*^9, 
   3.4940008716845655`*^9}, 3.4940243519153805`*^9, {3.494043967452796*^9, 
   3.4940439674547963`*^9}, 3.494047219901826*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c_.", "*", "x_"}], "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "3"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"I", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
         RowBox[{"(", 
          RowBox[{"x", "*", 
           RowBox[{"(", 
            RowBox[{"I", "+", 
             RowBox[{"a", "*", "x"}]}], ")"}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.4928394899907885`*^9, 3.492839600870944*^9}, {
   3.492839660371027*^9, 3.492839670511041*^9}, {3.492839872431324*^9, 
   3.492839876241329*^9}, 3.4928399970514984`*^9, 3.49284133392337*^9, {
   3.492841789364008*^9, 3.492841792164012*^9}, {3.4931675895939665`*^9, 
   3.49316759898398*^9}, 3.4931676669740753`*^9, {3.4931677271841593`*^9, 
   3.493167763914211*^9}, {3.4931684204151297`*^9, 3.4931684392651567`*^9}, {
   3.4935809755915556`*^9, 3.4935809770915575`*^9}, {3.493789934431322*^9, 
   3.493789945661338*^9}, {3.4940008716935663`*^9, 3.494000871697566*^9}, 
   3.494021921155349*^9, 3.4940243686493373`*^9, {3.494043967457796*^9, 
   3.4940439674607964`*^9}, 3.494047223772047*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "d"], "-", 
    FractionBox["c", 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, 
   3.493790063331503*^9, 3.4937901678516493`*^9, {3.4937902960118284`*^9, 
   3.4937902973518305`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0", " "}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, 
   3.4929827292027316`*^9, {3.493165973371704*^9, 3.493166003201746*^9}, {
   3.4931661009618826`*^9, 3.493166101641884*^9}, {3.4932522145709333`*^9, 
   3.4932522145709333`*^9}, {3.493581315932032*^9, 3.493581315932032*^9}, {
   3.493581349432079*^9, 3.493581349432079*^9}, {3.494022013786647*^9, 
   3.49402201593677*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], 
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "d"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "-", "2"}]], 
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["c", "d"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "-", "2"}]], 
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493166154681958*^9, 3.4931662030820255`*^9}, 
   3.4931666207326107`*^9, {3.4932522463481894`*^9, 3.49325228099585*^9}, {
   3.4933158052693357`*^9, 3.4933158328693743`*^9}, {3.4933190308138514`*^9, 
   3.493319134053996*^9}, {3.4933192438441496`*^9, 3.4933192445541506`*^9}, {
   3.4933193363142796`*^9, 3.4933193414042864`*^9}, {3.493412534339759*^9, 
   3.493412536469762*^9}, {3.493789994101406*^9, 3.493790017041438*^9}, {
   3.4937903432618947`*^9, 3.4937903499119043`*^9}, {3.493791019842842*^9, 
   3.4937910517128863`*^9}, 3.493791106992964*^9, 3.49379132604327*^9, {
   3.494000871714567*^9, 3.4940008717175674`*^9}, {3.4940439674637966`*^9, 
   3.4940439674657965`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcCot", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929236652023163`*^9, 3.49292366743312*^9}, 
   3.4929802336571484`*^9, {3.492982933672291*^9, 3.4929829505983205`*^9}, {
   3.4929832472016416`*^9, 3.4929833842790823`*^9}, {3.4929834529036026`*^9, 
   3.4929834542764053`*^9}, {3.493166117311906*^9, 3.493166138981936*^9}, {
   3.4931662751621265`*^9, 3.4931663186221876`*^9}, {3.4934126182898765`*^9, 
   3.493412622519882*^9}, {3.4935809700815477`*^9, 3.4935809719615507`*^9}, {
   3.493791136533005*^9, 3.4937911896730795`*^9}, 3.4937912549331713`*^9, {
   3.4938402453864017`*^9, 3.4938402484908075`*^9}, {3.4940008717265677`*^9, 
   3.4940008717315683`*^9}, 3.4940032500454226`*^9, 3.4940219211853504`*^9, {
   3.494043967468797*^9, 3.494043967471797*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "c"], "-", 
    FractionBox[
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, 
   3.493790063331503*^9, 3.4937901678516493`*^9, {3.4937902960118284`*^9, 
   3.4937902973518305`*^9}, {3.493857825015731*^9, 3.4938578494057655`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.4929828355013185`*^9, 3.492982837903723*^9}, {
   3.493165951941674*^9, 3.493165958321683*^9}, 3.4931660117517576`*^9, {
   3.493252219687742*^9, 3.493252219687742*^9}, {3.4935813186420355`*^9, 
   3.493581344402072*^9}, {3.4940220183729095`*^9, 3.4940220212800756`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], 
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "c"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "m"], 
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["d", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "2"}]], 
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493166154681958*^9, 3.4931662030820255`*^9}, 
   3.4931666207326107`*^9, {3.4932522463481894`*^9, 3.49325228099585*^9}, {
   3.4933158052693357`*^9, 3.4933158328693743`*^9}, {3.4933190308138514`*^9, 
   3.493319134053996*^9}, {3.4933192438441496`*^9, 3.4933192445541506`*^9}, {
   3.4933193363142796`*^9, 3.4933193414042864`*^9}, {3.493412534339759*^9, 
   3.493412536469762*^9}, {3.493789994101406*^9, 3.493790017041438*^9}, {
   3.4937903432618947`*^9, 3.4937903499119043`*^9}, {3.493791019842842*^9, 
   3.4937910517128863`*^9}, 3.493791106992964*^9, 3.49379132604327*^9, {
   3.4937915274235525`*^9, 3.493791535933564*^9}, {3.4937916827437696`*^9, 
   3.4937916869037757`*^9}, {3.494000871747569*^9, 3.4940008717505693`*^9}, {
   3.4940439674747972`*^9, 3.4940439674767976`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"d", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcCot", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929236652023163`*^9, 3.49292366743312*^9}, 
   3.4929802336571484`*^9, {3.492982933672291*^9, 3.4929829505983205`*^9}, {
   3.4929832472016416`*^9, 3.4929833842790823`*^9}, {3.4929834529036026`*^9, 
   3.4929834542764053`*^9}, {3.493166117311906*^9, 3.493166138981936*^9}, {
   3.4931662751621265`*^9, 3.4931663186221876`*^9}, {3.4934126182898765`*^9, 
   3.493412622519882*^9}, {3.4935809700815477`*^9, 3.4935809719615507`*^9}, {
   3.493791136533005*^9, 3.4937911896730795`*^9}, 3.4937912549331713`*^9, {
   3.4938403406557693`*^9, 3.4938403671446157`*^9}, {3.4940008717605696`*^9, 
   3.49400087176457*^9}, 3.4940219212193527`*^9, {3.4940439674797974`*^9, 
   3.494043967482798*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " or ",
 Cell[BoxData[
  RowBox[{"a", ">", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"Cot", "[", 
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "]"}], "m"], " ", 
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"], " "}], 
      SuperscriptBox["a", 
       RowBox[{"m", "+", "1"}]]]}], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]], "Input",
  CellChangeTimes->{{3.4935757447002296`*^9, 3.493575793020297*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.493575564069977*^9, 3.4935756424400864`*^9}, {
   3.4935756959401617`*^9, 3.49357570903018*^9}, {3.4935758049403143`*^9, 
   3.493575809750321*^9}, {3.493575842110366*^9, 3.4935758494003763`*^9}, {
   3.494000871803572*^9, 3.494000871814573*^9}, {3.494024500651888*^9, 
   3.494024500984906*^9}, {3.494043967499799*^9, 3.4940439675037994`*^9}, {
   3.494047314000208*^9, 3.494047314000208*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
      " ", 
      RowBox[{"a", ">", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, {
   3.493484196390273*^9, 3.493484198590276*^9}, {3.4934849126412754`*^9, 
   3.493484912921276*^9}, {3.4934858273225565`*^9, 3.4934858277825565`*^9}, {
   3.4934858606226025`*^9, 3.493485878442628*^9}, {3.493485980752771*^9, 
   3.493486013532817*^9}, 3.4934861613430243`*^9, {3.4935745424185467`*^9, 
   3.4935745428285475`*^9}, {3.4935745924186163`*^9, 3.493574622528659*^9}, {
   3.4935750227192187`*^9, 3.4935750542492633`*^9}, {3.493576012220604*^9, 
   3.493576016990611*^9}, {3.4935813225620413`*^9, 3.4935813359920597`*^9}, {
   3.493584208106081*^9, 3.4935842115060854`*^9}, {3.4940220237122145`*^9, 
   3.494022026042348*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{
        SuperscriptBox["a", 
         RowBox[{"m", "+", "1"}]], "c"}]]}]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], 
       SuperscriptBox[
        RowBox[{"Cot", "[", "x", "]"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493484110810153*^9, {3.4934842003402786`*^9, 
   3.4934842033302827`*^9}, {3.4934849452513213`*^9, 3.493484979331369*^9}, {
   3.493574446028412*^9, 3.493574506118496*^9}, {3.4935746795187387`*^9, 
   3.493574682028742*^9}, {3.4940008718335743`*^9, 3.494000871837574*^9}, {
   3.4940439675087996`*^9, 3.4940439675107994`*^9}, 3.49404735669265*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", "c"}], ")"}]}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Cot", "[", "x", "]"}], "^", "m"}]}], ",", "x"}], "]"}], 
        ",", "x", ",", 
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "a", "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
   3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
   3.4930674148588486`*^9}, {3.4930676846992264`*^9, 
   3.4930676962292423`*^9}, {3.493484206670287*^9, 3.4934842155203*^9}, 
   3.4934861347329865`*^9, {3.49348619445307*^9, 3.493486231663122*^9}, {
   3.4934862761831846`*^9, 3.4934862874732003`*^9}, {3.4935748506089783`*^9, 
   3.4935750140392065`*^9}, {3.4935759916505756`*^9, 3.493575995420581*^9}, 
   3.4935766556615047`*^9, 3.493576706471576*^9, {3.493580958311531*^9, 
   3.493580960351534*^9}, {3.4935842485261374`*^9, 3.4935842501161394`*^9}, {
   3.4940008718475747`*^9, 3.494000871851575*^9}, 3.494021921249354*^9, {
   3.4940439675127993`*^9, 3.4940439675168*^9}, 3.494047381893091*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "a"]}], 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"Cot", "[", 
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "]"}], "a"], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]], "Input",
  CellChangeTimes->{{3.4935757447002296`*^9, 3.493575793020297*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.493575564069977*^9, 3.4935756424400864`*^9}, {
   3.4935756959401617`*^9, 3.49357570903018*^9}, {3.4935758049403143`*^9, 
   3.493575809750321*^9}, {3.493575842110366*^9, 3.4935758494003763`*^9}, {
   3.4935761209707565`*^9, 3.493576167880822*^9}, {3.493576511191303*^9, 
   3.493576539971343*^9}, {3.494000871873576*^9, 3.494000871884577*^9}, {
   3.494024607733012*^9, 3.4940246082850437`*^9}, {3.4940439675208*^9, 
   3.4940439675248003`*^9}, {3.494047394157792*^9, 3.494047394157792*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
       " ", 
       RowBox[{"a", ">", "0"}]}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, {
   3.493484196390273*^9, 3.493484198590276*^9}, {3.4934849126412754`*^9, 
   3.493484912921276*^9}, {3.4934858273225565`*^9, 3.4934858277825565`*^9}, {
   3.4934858606226025`*^9, 3.493485878442628*^9}, {3.493485980752771*^9, 
   3.493486013532817*^9}, 3.4934861613430243`*^9, {3.4935745424185467`*^9, 
   3.4935745428285475`*^9}, {3.4935745924186163`*^9, 3.493574622528659*^9}, {
   3.4935750227192187`*^9, 3.4935750542492633`*^9}, {3.493576012220604*^9, 
   3.493576016990611*^9}, 3.493576288350991*^9, {3.493581325842046*^9, 
   3.4935813317720537`*^9}, {3.4935842190960965`*^9, 
   3.4935842227961016`*^9}, {3.4940220284994884`*^9, 3.49402203184468*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"a", " ", "c"}]]}]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"Cot", "[", "x", "]"}], "a"], ")"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493484110810153*^9, {3.4934842003402786`*^9, 
   3.4934842033302827`*^9}, {3.4934849452513213`*^9, 3.493484979331369*^9}, {
   3.493574446028412*^9, 3.493574506118496*^9}, {3.4935746795187387`*^9, 
   3.493574682028742*^9}, {3.4935764123011646`*^9, 3.493576431451191*^9}, {
   3.4935764737712507`*^9, 3.493576478761257*^9}, {3.494000871906578*^9, 
   3.4940008719105787`*^9}, {3.4940439675288005`*^9, 3.494043967530801*^9}, 
   3.4940474115927896`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Cot", "[", "x", "]"}], "/", "a"}], ")"}], "^", "m"}]}],
           ",", "x"}], "]"}], ",", "x", ",", 
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "a", "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
   3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
   3.4930674148588486`*^9}, {3.4930676846992264`*^9, 
   3.4930676962292423`*^9}, {3.493484206670287*^9, 3.4934842155203*^9}, 
   3.4934861304629803`*^9, 3.4934861903430643`*^9, {3.4934862534031525`*^9, 
   3.493486262273165*^9}, {3.4934862996232176`*^9, 3.4934863089332304`*^9}, {
   3.493575978670557*^9, 3.4935759803305597`*^9}, {3.4935766168214507`*^9, 
   3.4935766805915403`*^9}, 3.493576722851599*^9, {3.493580952391523*^9, 
   3.493580954621526*^9}, {3.493584242456129*^9, 3.493584244676132*^9}, {
   3.494000871920579*^9, 3.494000871924579*^9}, 3.494021921279356*^9, {
   3.494043967533801*^9, 3.4940439675368013`*^9}, 3.494047414693967*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
     RowBox[{"ArcCoth", "[", "u", "]"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, {3.492913336613951*^9, 3.492913339753956*^9}, {
   3.4931386203491883`*^9, 3.493138625887198*^9}, {3.4931387252593727`*^9, 
   3.493138727848977*^9}, 3.493143725971335*^9, 3.493252609984828*^9, {
   3.49400087193858*^9, 3.49400087193958*^9}, {3.494025017019422*^9, 
   3.494025020512622*^9}, {3.494029404352363*^9, 3.494029407256529*^9}, {
   3.494043967538801*^9, 3.494043967539801*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcCoth", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       FractionBox["1", "z"]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       FractionBox["1", "z"]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, {
   3.493766716975833*^9, 3.493766716975833*^9}, {3.493767547466996*^9, 
   3.493767553017004*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["u", "2"], "=", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           FractionBox[
            RowBox[{"2", "I"}], 
            RowBox[{"I", "+", 
             RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"], " ", "\[Or]", "  ", 
        SuperscriptBox["u", "2"]}], "=", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox[
           RowBox[{"2", "I"}], 
           RowBox[{"I", "-", 
            RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4930962548817973`*^9, 
   3.493096255481798*^9}, {3.493139493669922*^9, 3.493139531063188*^9}, {
   3.493252668562931*^9, 3.493252668562931*^9}, {3.4935814042921553`*^9, 
   3.493581413882169*^9}, {3.494022034263818*^9, 3.49402203622193*^9}, {
   3.4940294570023746`*^9, 3.494029477803564*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"ArcCoth", "[", "u", "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"1", "+", 
          FractionBox["1", "u"]}], "]"}]}], 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", 
         FractionBox["1", "u"]}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, {3.494000871977582*^9, 3.494000871982582*^9}, {
   3.494024788598357*^9, 3.494024837206137*^9}, 3.494029492169386*^9, {
   3.4940295938662024`*^9, 3.494029611453209*^9}, {3.4940439675478015`*^9, 
   3.4940439675508018`*^9}, {3.4940475853167257`*^9, 3.4940475897399793`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"ArcCoth", "[", "u_", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"Regularize", "[", 
            RowBox[{
             RowBox[{"1", "+", 
              RowBox[{"1", "/", "u"}]}], ",", "x"}], "]"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"Regularize", "[", 
            RowBox[{
             RowBox[{"1", "-", 
              RowBox[{"1", "/", "u"}]}], ",", "x"}], "]"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"u", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "*", 
            RowBox[{"I", "/", 
             RowBox[{"(", 
              RowBox[{"I", "+", 
               RowBox[{"a", "*", "x"}]}], ")"}]}]}]}], ")"}], "^", "2"}]}], 
       "]"}], " ", "||", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"u", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "*", 
            RowBox[{"I", "/", 
             RowBox[{"(", 
              RowBox[{"I", "-", 
               RowBox[{"a", "*", "x"}]}], ")"}]}]}]}], ")"}], "^", "2"}]}], 
       "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.4928381673513484`*^9, 
   3.4928381717973566`*^9}, {3.492838221982644*^9, 3.492838250608695*^9}, {
   3.492840280811896*^9, 3.492840287331905*^9}, 3.4928413614234085`*^9, {
   3.493138538807845*^9, 3.4931385448294554`*^9}, {3.493139257267107*^9, 
   3.4931393087783976`*^9}, 3.4931393776681185`*^9, {3.493139438976226*^9, 
   3.4931394493814445`*^9}, {3.4935814251121845`*^9, 3.493581427492188*^9}, {
   3.494000871994583*^9, 3.4940008720015836`*^9}, 3.4940219213103576`*^9, {
   3.4940248230103254`*^9, 3.494024843757512*^9}, {3.494024928333349*^9, 
   3.494024931642539*^9}, 3.4940295845926723`*^9, {3.4940296573848352`*^9, 
   3.4940296697735443`*^9}, {3.4940297053725805`*^9, 
   3.4940297260467625`*^9}, {3.494043967554802*^9, 3.4940439675608025`*^9}, {
   3.4940476584579096`*^9, 3.4940476867295265`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
     RowBox[{"Log", "[", "u", "]"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, {3.492913336613951*^9, 3.492913339753956*^9}, 
   3.4931436949112916`*^9, 3.493252774143916*^9, 3.4940008720145845`*^9, 
   3.4940439675618024`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "u"}], ")"}], "2"]}], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{"2", "I"}], 
        RowBox[{"I", "+", 
         RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4930962548817973`*^9, 
   3.493096255481798*^9}, {3.4930966874724026`*^9, 3.493096711762437*^9}, {
   3.4930967471324863`*^9, 3.493096747642487*^9}, {3.4932527496362734`*^9, 
   3.4932527496362734`*^9}, {3.493581449742219*^9, 3.493581458802232*^9}, {
   3.493581496762285*^9, 3.4935815094423027`*^9}, {3.494022037951029*^9, 
   3.4940220399331427`*^9}, {3.4940298224392767`*^9, 3.4940298294536777`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"Log", "[", "u", "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{" ", 
        RowBox[{"I", " ", 
         SuperscriptBox[
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
         RowBox[{"PolyLog", "[", 
          RowBox[{"2", ",", 
           RowBox[{"1", "-", "u"}]}], "]"}]}]}], 
       RowBox[{"2", "a", " ", "c"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", "I"}], "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{"2", ",", 
         RowBox[{"1", "-", "u"}]}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 PageWidth->Infinity,
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, 3.4933160671297026`*^9, {3.494000872027585*^9, 
   3.4940008720305853`*^9}, {3.494029933733642*^9, 3.4940299402480145`*^9}, {
   3.4940439675648026`*^9, 3.494043967566803*^9}, {3.49404776686011*^9, 
   3.4940477678011637`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"Log", "[", "u_", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"I", "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{"1", "-", "u"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"I", "/", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{"2", ",", 
            RowBox[{"1", "-", "u"}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "u"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "*", 
          RowBox[{"I", "/", 
           RowBox[{"(", 
            RowBox[{"I", "+", 
             RowBox[{"a", "*", "x"}]}], ")"}]}]}]}], ")"}], "^", "2"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.4928381673513484`*^9, 
   3.4928381717973566`*^9}, {3.492838221982644*^9, 3.492838250608695*^9}, {
   3.492840280811896*^9, 3.492840287331905*^9}, 3.4928413614234085`*^9, {
   3.493138538807845*^9, 3.4931385448294554`*^9}, {3.4935814687422457`*^9, 
   3.4935814707822485`*^9}, {3.4940008720405855`*^9, 3.494000872044586*^9}, 
   3.49402192134536*^9, {3.494030114164962*^9, 3.494030137468295*^9}, {
   3.4940439675698028`*^9, 3.494043967573803*^9}, {3.4940478174760046`*^9, 
   3.494047817793023*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "u"}], ")"}], "2"]}], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{"2", "I"}], 
        RowBox[{"I", "-", 
         RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4930962548817973`*^9, 
   3.493096255481798*^9}, {3.4930966874724026`*^9, 3.493096711762437*^9}, {
   3.4932527647214994`*^9, 3.4932527647214994`*^9}, {3.493581521182319*^9, 
   3.493581538282343*^9}, {3.4940220416442404`*^9, 3.494022043545349*^9}, {
   3.4940301995118437`*^9, 3.4940302035320735`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"Log", "[", "u", "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"I", " ", 
         SuperscriptBox[
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
         RowBox[{"PolyLog", "[", 
          RowBox[{"2", ",", 
           RowBox[{"1", "-", "u"}]}], "]"}]}], 
        RowBox[{"2", "a", " ", "c"}]]}]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", "I"}], "2"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{"2", ",", 
         RowBox[{"1", "-", "u"}]}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 PageWidth->Infinity,
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, 3.4933160764997153`*^9, {3.494000872058587*^9, 
   3.4940008720615873`*^9}, {3.494030195205597*^9, 3.494030196178653*^9}, {
   3.4940302302145996`*^9, 3.4940302305686197`*^9}, {3.4940439675758033`*^9, 
   3.494043967578803*^9}, {3.4940478309377747`*^9, 3.4940478312487926`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"Log", "[", "u_", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "I"}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{"1", "-", "u"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"I", "/", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{"2", ",", 
            RowBox[{"1", "-", "u"}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "u"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "*", 
          RowBox[{"I", "/", 
           RowBox[{"(", 
            RowBox[{"I", "-", 
             RowBox[{"a", "*", "x"}]}], ")"}]}]}]}], ")"}], "^", "2"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.4928379334601374`*^9, 
   3.492837939216548*^9}, {3.4928380301959076`*^9, 3.4928380706935787`*^9}, {
   3.4928381256836753`*^9, 3.492838126026876*^9}, {3.492838194448596*^9, 
   3.492838214806632*^9}, {3.492840292461912*^9, 3.492840299431922*^9}, 
   3.4928413656434145`*^9, {3.4930965007921414`*^9, 3.4930965332721868`*^9}, {
   3.4935814756022553`*^9, 3.4935814775622582`*^9}, {3.4940008720715876`*^9, 
   3.4940008720765877`*^9}, 3.4940219213753614`*^9, {3.4940302923321524`*^9, 
   3.494030309884156*^9}, {3.494030515261904*^9, 3.494030519732159*^9}, {
   3.494043967580804*^9, 3.4940439675848036`*^9}, {3.494093909134123*^9, 
   3.494093909514124*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"p", ",", "u"}], "]"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, {
   3.492830644352556*^9, 3.492830644712557*^9}, {3.4928404670121565`*^9, 
   3.492840467502157*^9}, 3.492913349043969*^9, 3.4931388908692636`*^9, 
   3.493143703721304*^9, 3.4932529661958537`*^9, 3.4940008720905886`*^9, 
   3.494043967587804*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     SuperscriptBox["u", "2"]}], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{"2", "I"}], 
        RowBox[{"I", "+", 
         RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4930962548817973`*^9, 
   3.493096255481798*^9}, {3.4932531421173625`*^9, 3.4932531421173625`*^9}, {
   3.4935817370726213`*^9, 3.493581749462639*^9}, {3.494022045101438*^9, 
   3.4940220526068673`*^9}, {3.4940303588919597`*^9, 3.4940303624561634`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"PolyLog", "[", 
       RowBox[{"p", ",", "u"}], "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                           ", 
      "\[IndentingNewLine]", "                                             ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"I", " ", 
         SuperscriptBox[
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
         RowBox[{"PolyLog", "[", 
          RowBox[{
           RowBox[{"p", "+", "1"}], ",", "u"}], "]"}]}], 
        RowBox[{"2", "a", " ", "c"}]]}]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", "I"}], "2"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{
         RowBox[{"p", "+", "1"}], ",", "u"}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, 3.4933161350697975`*^9, {3.493320303475633*^9, 
   3.493320336085679*^9}, {3.49332038699575*^9, 3.493320391165756*^9}, {
   3.4933205094659214`*^9, 3.4933205100859222`*^9}, {3.494000872102589*^9, 
   3.4940008721065893`*^9}, {3.49403037306177*^9, 3.494030377681034*^9}, {
   3.494043967590804*^9, 3.494043967592804*^9}, {3.494047875466322*^9, 
   3.4940478763733735`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"p_", ",", "u_"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "I"}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{
        RowBox[{"p", "+", "1"}], ",", "u"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"I", "/", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{
            RowBox[{"p", "+", "1"}], ",", "u"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"u", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "*", 
          RowBox[{"I", "/", 
           RowBox[{"(", 
            RowBox[{"I", "+", 
             RowBox[{"a", "*", "x"}]}], ")"}]}]}]}], ")"}], "^", "2"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997359719353`*^9, 3.492799760261178*^9}, {
   3.4928403040619287`*^9, 3.492840308581935*^9}, 3.492841369963421*^9, {
   3.4928426836352596`*^9, 3.492842700155283*^9}, {3.493096333451907*^9, 
   3.4930963718219604`*^9}, {3.4935817628926573`*^9, 
   3.4935817654026613`*^9}, {3.49400087211659*^9, 3.49400087212059*^9}, 
   3.494021921405363*^9, {3.4940304483700776`*^9, 3.4940304651570377`*^9}, {
   3.494043967595804*^9, 3.4940439675988045`*^9}, {3.4940478789625216`*^9, 
   3.4940478793205423`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     SuperscriptBox["u", "2"]}], "=", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{"2", "I"}], 
        RowBox[{"I", "-", 
         RowBox[{"a", " ", "x"}]}]]}], ")"}], "2"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4930957381510735`*^9, 3.493095777731129*^9}, {3.4932531464697704`*^9, 
   3.4932531464697704`*^9}, {3.4935817416826277`*^9, 3.493581754482646*^9}, {
   3.4940220557920494`*^9, 3.494022058517205*^9}, {3.4940305794955773`*^9, 
   3.4940305825537524`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
      RowBox[{"PolyLog", "[", 
       RowBox[{"p", ",", "u"}], "]"}]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                          ", 
      "\[IndentingNewLine]", 
      "                                                ", 
      FractionBox[
       RowBox[{"I", " ", 
        SuperscriptBox[
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"], " ", 
        RowBox[{"PolyLog", "[", 
         RowBox[{
          RowBox[{"p", "+", "1"}], ",", "u"}], "]"}]}], 
       RowBox[{"2", "a", " ", "c"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", "I"}], "2"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{
         RowBox[{"p", "+", "1"}], ",", "u"}], "]"}]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.492982817124486*^9, 3.4929828178576875`*^9}, 
   3.4931655191410685`*^9, 3.493166624072615*^9, {3.493252259202612*^9, 
   3.4932522639918203`*^9}, {3.493252361117591*^9, 3.493252364440397*^9}, 
   3.4933156800291605`*^9, 3.4933161430898085`*^9, {3.493320319155655*^9, 
   3.493320327755667*^9}, {3.4933203993557673`*^9, 3.493320454915845*^9}, {
   3.4933205128259263`*^9, 3.493320513405927*^9}, {3.494000872134591*^9, 
   3.4940008721385913`*^9}, {3.494030570257049*^9, 3.4940305742852793`*^9}, {
   3.4940439676018047`*^9, 3.4940439676038046`*^9}, {3.4940479246611357`*^9, 
   3.4940479250591583`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"p_", ",", "u_"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"I", "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{
        RowBox[{"p", "+", "1"}], ",", "u"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"I", "/", "2"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"PolyLog", "[", 
           RowBox[{
            RowBox[{"p", "+", "1"}], ",", "u"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"u", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", "*", 
          RowBox[{"I", "/", 
           RowBox[{"(", 
            RowBox[{"I", "-", 
             RowBox[{"a", "*", "x"}]}], ")"}]}]}]}], ")"}], "^", "2"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4927475229037466`*^9, 3.4927477533449273`*^9}, {
   3.4927478131093454`*^9, 3.492747834183551*^9}, {3.4927478811922398`*^9, 
   3.4927479273238783`*^9}, {3.492747994901744*^9, 3.4927480520830145`*^9}, {
   3.492748126383264*^9, 3.492748126897293*^9}, {3.492799196725788*^9, 
   3.4927992401718645`*^9}, {3.4927992767227287`*^9, 
   3.4927993156759973`*^9}, {3.4927994994131203`*^9, 3.492799508102335*^9}, {
   3.492799544387999*^9, 3.4927995657444363`*^9}, {3.4927996261789427`*^9, 
   3.492799660327403*^9}, {3.4927997257383175`*^9, 3.4927997433351483`*^9}, {
   3.4927998179656796`*^9, 3.4927998331289062`*^9}, {3.49284031232194*^9, 
   3.4928403176719475`*^9}, {3.4928413736734257`*^9, 
   3.4928413764134293`*^9}, {3.4928427124753*^9, 3.4928427180953083`*^9}, {
   3.4930958623412476`*^9, 3.493095867661255*^9}, {3.493096011861457*^9, 
   3.4930960123514576`*^9}, {3.493581770142668*^9, 3.4935817729726715`*^9}, {
   3.494000872148592*^9, 3.494000872152592*^9}, 3.4940219214353647`*^9, {
   3.4940305873440266`*^9, 3.494030601114814*^9}, {3.494043967606805*^9, 
   3.4940439676108055`*^9}, {3.494047928109333*^9, 3.4940479284663534`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616025649432*^9, {3.4796162596058445`*^9, 3.479616276069518*^9}, {
   3.4796867203644447`*^9, 3.4796867380098176`*^9}, {3.4796961372252254`*^9, 
   3.4796961375256577`*^9}, 3.492822267896963*^9, 3.4928258267508163`*^9, {
   3.4932577931811075`*^9, 3.4932577998811164`*^9}, 3.493258386041937*^9, 
   3.493258450902028*^9, 3.494000872166593*^9, 3.4940009309599557`*^9, 
   3.494043925490396*^9, 3.4940439676128054`*^9, 3.494044707549127*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.49325840970197*^9, 3.493258411811973*^9}, {
   3.4932584532120314`*^9, 3.4932584537520323`*^9}, {3.4935818687928057`*^9, 
   3.4935818687928057`*^9}, {3.494021686811945*^9, 3.494021686811945*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"ArcTan", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                        ", 
      "\[IndentingNewLine]", 
      "                                               ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"ArcTan", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"a", " ", "c", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"m", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "-", "1"}]]}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731727376`*^9, 3.4796580024348145`*^9}, {
   3.4796585662054768`*^9, 3.4796585704015102`*^9}, {3.4796611938738785`*^9, 
   3.479661220251808*^9}, 3.4796613924594307`*^9, {3.479661432957664*^9, 
   3.479661435531365*^9}, {3.4796615599302416`*^9, 3.4796615651577587`*^9}, {
   3.4796617677991424`*^9, 3.4796617978824*^9}, 3.4796618436281796`*^9, {
   3.479662183256541*^9, 3.4796621957945695`*^9}, {3.4796867203944883`*^9, 
   3.4796867402029715`*^9}, {3.4796872323406305`*^9, 3.479687270064875*^9}, {
   3.492826073390849*^9, 3.4928261527013884`*^9}, {3.492826334973708*^9, 
   3.4928263351453085`*^9}, {3.492826679349514*^9, 3.4928266798955145`*^9}, 
   3.4928267967457204`*^9, {3.4932578278611555`*^9, 3.493257905011264*^9}, {
   3.493257942631316*^9, 3.493257944461319*^9}, {3.4932580838015137`*^9, 
   3.4932580841315145`*^9}, {3.4932584146419773`*^9, 
   3.4932584213319864`*^9}, {3.4932584544720325`*^9, 3.493258456582036*^9}, {
   3.493320843336389*^9, 3.4933208585764103`*^9}, {3.4933209087264805`*^9, 
   3.4933209157664905`*^9}, {3.4940008722065954`*^9, 
   3.4940008722105956`*^9}, {3.494000930985957*^9, 3.4940009309889574`*^9}, {
   3.494021744336235*^9, 3.4940217506485963`*^9}, {3.4940439320667725`*^9, 
   3.4940439320697727`*^9}, {3.4940439676268063`*^9, 3.494043967628806*^9}, {
   3.494044710659305*^9, 3.494044711357345*^9}, {3.494044799276374*^9, 
   3.4940448034966154`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcTan", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcCot", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4932581278315754`*^9, 3.4932581781516457`*^9}, {
   3.493258211041692*^9, 3.4932582126516943`*^9}, {3.493258319821844*^9, 
   3.4932583217718472`*^9}, {3.493258425361992*^9, 3.4932584627520447`*^9}, 
   3.4935818049827166`*^9, {3.4940008722205963`*^9, 3.4940008722245965`*^9}, {
   3.4940009309919577`*^9, 3.494000930996958*^9}, {3.4940217925259914`*^9, 
   3.494021796929243*^9}, 3.494021921500368*^9, {3.4940439320727725`*^9, 
   3.4940439320767727`*^9}, {3.4940439676318064`*^9, 
   3.4940439676348066`*^9}, {3.4940447116213603`*^9, 3.4940447121573906`*^9}, 
   3.494044853320465*^9, {3.494044886841382*^9, 3.494044887486419*^9}, 
   3.5171884922844334`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616001935333*^9, 3.4796867203444157`*^9, {3.479687071148848*^9, 
   3.479687071399208*^9}, 3.4928222618129525`*^9, 3.4928258304168224`*^9, {
   3.4929226804037867`*^9, 3.4929226942254105`*^9}, {3.492979990624321*^9, 
   3.4929799910143223`*^9}, {3.493060035696517*^9, 3.4930600483865347`*^9}, 
   3.493253406025427*^9, 3.494000872238597*^9, 3.494043967637807*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"c", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930771831577578`*^9, 
   3.4930771985577793`*^9}, {3.493256297489013*^9, 3.493256308149028*^9}, {
   3.4932563410290737`*^9, 3.4932563441690784`*^9}, {3.494022060840338*^9, 
   3.494022062863454*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", "I", " ", 
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"ArcTan", "[", 
          FractionBox[
           SqrtBox[
            RowBox[{"1", "+", 
             RowBox[{"I", " ", "a", " ", "x"}]}]], 
           SqrtBox[
            RowBox[{"1", "-", 
             RowBox[{"I", " ", "a", " ", "x"}]}]]], "]"}]}], 
        RowBox[{"a", 
         SqrtBox["c"]}]]}]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{"I", " ", "a", " ", "x"}]}]]}], 
        SqrtBox[
         RowBox[{"1", "-", 
          RowBox[{"I", " ", "a", " ", "x"}]}]]]}]}], "]"}]}], 
   RowBox[{"a", 
    SqrtBox["c"]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox[
         RowBox[{"1", "+", 
          RowBox[{"I", " ", "a", " ", "x"}]}]]}], 
       SqrtBox[
        RowBox[{"1", "-", 
         RowBox[{"I", " ", "a", " ", "x"}]}]]]}], "]"}]}], 
   RowBox[{"a", 
    SqrtBox["c"]}]]}]], "Subsubtitle",
 PageWidth->Infinity,
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.4933211646668386`*^9, {3.494000872251598*^9, 
   3.494000872253598*^9}, {3.4940251960636625`*^9, 3.494025196753702*^9}, {
   3.4940252312186737`*^9, 3.4940252356359262`*^9}, {3.494025387160593*^9, 
   3.494025409001842*^9}, {3.4940254453259196`*^9, 3.4940254740545626`*^9}, {
   3.4940255093365808`*^9, 3.494025509863611*^9}, {3.494043967640807*^9, 
   3.494043967642807*^9}, 3.494089470477909*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCot", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", "I", "*", 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", "*", "x"}], "]"}], "*", 
     RowBox[{
      RowBox[{"ArcTan", "[", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"1", "+", 
          RowBox[{"I", "*", "a", "*", "x"}]}], "]"}], "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"1", "-", 
          RowBox[{"I", "*", "a", "*", "x"}]}], "]"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"Sqrt", "[", "c", "]"}]}], ")"}]}]}], " ", "-", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"I", "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{
         RowBox[{"-", "I"}], "*", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "+", 
            RowBox[{"I", "*", "a", "*", "x"}]}], "]"}], "/", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "-", 
            RowBox[{"I", "*", "a", "*", "x"}]}], "]"}]}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"Sqrt", "[", "c", "]"}]}], ")"}]}]}], " ", "+", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"I", "*", 
     RowBox[{
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{"I", "*", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "+", 
            RowBox[{"I", "*", "a", "*", "x"}]}], "]"}], "/", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "-", 
            RowBox[{"I", "*", "a", "*", "x"}]}], "]"}]}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"Sqrt", "[", "c", "]"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "c", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.493076725417117*^9, 3.493076780277194*^9}, {
   3.4930770153775234`*^9, 3.4930770237775345`*^9}, {3.4930770970076375`*^9, 
   3.4930771129476595`*^9}, {3.4940008722635984`*^9, 3.4940008722665987`*^9}, 
   3.4940219215303698`*^9, {3.4940252446504416`*^9, 3.4940252521838727`*^9}, {
   3.494025522765349*^9, 3.494025579877616*^9}, {3.4940439676458073`*^9, 
   3.4940439676498075`*^9}, {3.494089496817946*^9, 3.494089539638006*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]], 
     SqrtBox[
      RowBox[{"c", " ", "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.493078825992059*^9, 3.493078849422092*^9}, 
   3.4930790976224394`*^9, {3.4932536079989815`*^9, 3.4932536186070004`*^9}, {
   3.494025618559828*^9, 3.4940256224620514`*^9}, {3.4940256642174397`*^9, 
   3.4940256642174397`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{"c", ">", "0"}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930771831577578`*^9, 
   3.4930771985577793`*^9}, {3.493256297489013*^9, 3.493256308149028*^9}, {
   3.494022065313594*^9, 3.4940220678847413`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]], 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.4933211695768456`*^9, {3.4940008722805996`*^9, 
   3.4940008722815995`*^9}, {3.4940256785832615`*^9, 
   3.4940256899229097`*^9}, {3.494043967651808*^9, 3.4940439676528077`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCot", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", "c", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.493076725417117*^9, 3.493076780277194*^9}, {
   3.493077825308657*^9, 3.493077828358661*^9}, {3.4930778668687153`*^9, 
   3.493077913738781*^9}, {3.493077978808872*^9, 3.493077978948872*^9}, {
   3.493079137962496*^9, 3.4930791537525177`*^9}, {3.4930802573560643`*^9, 
   3.4930802674060783`*^9}, {3.4940008722906*^9, 3.4940008722926*^9}, 
   3.4940219215633717`*^9, {3.494025757953801*^9, 3.494025763072094*^9}, {
   3.4940439676548076`*^9, 3.494043967656808*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", "c"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930771831577578`*^9, 
   3.4930771985577793`*^9}, {3.493256297489013*^9, 3.493256308149028*^9}, {
   3.4932565037393017`*^9, 3.4932565054493046`*^9}, {3.494022071569952*^9, 
   3.494022073954088*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"a", " ", "c", " ", 
         SqrtBox[
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}]]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", " ", "x"}], "]"}]}], 
   RowBox[{"c", 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.493321175446854*^9, {3.494000872303601*^9, 
   3.494000872305601*^9}, 3.4940259253943777`*^9, {3.4940439676588078`*^9, 
   3.494043967659808*^9}, 3.4940896594481735`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCot", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "c", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.492924584761531*^9, 
   3.4929246531208515`*^9}, {3.4929246982205305`*^9, 3.4929247046789417`*^9}, 
   3.492924739529403*^9, {3.494000872314602*^9, 3.4940008723166018`*^9}, 
   3.4940219215873737`*^9, 3.4940259535489883`*^9, {3.4940439676628084`*^9, 
   3.494043967663808*^9}, 3.4940896758181963`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.493057857853468*^9, 3.4930578807234993`*^9}, {3.4930589528050003`*^9, 
   3.4930589841650443`*^9}, {3.493256250928948*^9, 3.493256250928948*^9}, {
   3.493493532773344*^9, 3.493493535913348*^9}, {3.493494121514168*^9, 
   3.493494130844181*^9}, {3.4935821227231617`*^9, 3.4935821407331867`*^9}, {
   3.494022075719189*^9, 3.49402207782931*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"n", " ", 
         SuperscriptBox[
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", " ", "x"}], "]"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"a", " ", "c", 
         SqrtBox[
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}]]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
   RowBox[{"c", 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]}]], "-", 
  RowBox[{"n", 
   RowBox[{"(", 
    RowBox[{"n", "-", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "2"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493058932894973*^9, 3.4930589343449745`*^9}, {
   3.4930590036150713`*^9, 3.493059030475109*^9}, {3.493059071585167*^9, 
   3.4930590795551777`*^9}, {3.4930628403524446`*^9, 3.49306285140246*^9}, {
   3.4932501056192265`*^9, 3.4932501067580285`*^9}, {3.493250146257298*^9, 
   3.493250186942169*^9}, {3.493256078498707*^9, 3.4932560906487236`*^9}, {
   3.4932568685898128`*^9, 3.4932568826798325`*^9}, {3.4933216732775507`*^9, 
   3.4933216957475824`*^9}, {3.4933217278376274`*^9, 3.493321760587673*^9}, 
   3.493321813507747*^9, 3.4933218644878187`*^9, {3.493321906837878*^9, 
   3.493321919617896*^9}, {3.4933220427280684`*^9, 3.493322042928068*^9}, {
   3.4934927094121914`*^9, 3.4934927441222396`*^9}, 3.493492777272286*^9, 
   3.493493493413289*^9, 3.4934935635433865`*^9, 3.493494110054152*^9, {
   3.4940008723276024`*^9, 3.4940008723326025`*^9}, {3.494026757555975*^9, 
   3.4940267773411064`*^9}, {3.4940439676658087`*^9, 3.4940439676698084`*^9}, 
   3.4940897093182435`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "n"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}]}], " ", "-", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.493058294184078*^9, 3.493058321094116*^9}, {
   3.493058376614194*^9, 3.4930583929842167`*^9}, {3.4930584278042655`*^9, 
   3.4930584671043205`*^9}, {3.493058560144451*^9, 3.493058565344458*^9}, {
   3.493058608014518*^9, 3.493058608604519*^9}, {3.4930607207894773`*^9, 
   3.4930607253094835`*^9}, {3.49306140171043*^9, 3.4930614057704363`*^9}, {
   3.4930627552623253`*^9, 3.4930629395125833`*^9}, {3.493063111452824*^9, 
   3.4930631116128244`*^9}, {3.4930631532528825`*^9, 
   3.4930631552828856`*^9}, {3.4930631929229383`*^9, 
   3.4930631974729443`*^9}, {3.4934926396120934`*^9, 
   3.4934926491221066`*^9}, {3.4934935949134307`*^9, 
   3.4934937034035826`*^9}, {3.4934941442142*^9, 3.4934941989742765`*^9}, {
   3.493494240614335*^9, 3.493494240974335*^9}, {3.493580930901493*^9, 
   3.493580933131496*^9}, {3.494000872342603*^9, 3.4940008723496037`*^9}, 
   3.4940219216243753`*^9, {3.4940267912139*^9, 3.494026794236073*^9}, {
   3.4940439676728086`*^9, 3.494043967678809*^9}, 3.4940897308782735`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.493057857853468*^9, 3.4930578807234993`*^9}, {3.4930589528050003`*^9, 
   3.4930589841650443`*^9}, {3.493256250928948*^9, 3.493256250928948*^9}, {
   3.493493532773344*^9, 3.493493535913348*^9}, {3.493582160473214*^9, 
   3.493582160473214*^9}, {3.493582259573353*^9, 3.493582259573353*^9}, {
   3.494022079667415*^9, 3.494022081728533*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                                              \
  ", "\[IndentingNewLine]", "                        ", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], 
         RowBox[{"n", "+", "1"}]], 
        RowBox[{"a", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         SqrtBox[
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}]]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"n", "+", "2"}]]}], 
   RowBox[{"c", " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "2"}], ")"}], " ", 
    SqrtBox[
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}]]}]], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "+", "2"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493058932894973*^9, 3.4930589343449745`*^9}, {
   3.4930590036150713`*^9, 3.493059030475109*^9}, {3.493059071585167*^9, 
   3.4930590795551777`*^9}, {3.4930628403524446`*^9, 3.49306285140246*^9}, {
   3.4932501056192265`*^9, 3.4932501067580285`*^9}, {3.493250146257298*^9, 
   3.493250186942169*^9}, {3.493256078498707*^9, 3.4932560906487236`*^9}, {
   3.4932568685898128`*^9, 3.4932568826798325`*^9}, {3.4933216732775507`*^9, 
   3.4933216957475824`*^9}, {3.4933217278376274`*^9, 3.493321760587673*^9}, 
   3.493321813507747*^9, 3.4933218644878187`*^9, {3.493321906837878*^9, 
   3.493321919617896*^9}, {3.4933220427280684`*^9, 3.493322042928068*^9}, {
   3.4934927094121914`*^9, 3.4934927441222396`*^9}, 3.493492777272286*^9, 
   3.493493493413289*^9, 3.4934935635433865`*^9, {3.4935896515237017`*^9, 
   3.4935897029137735`*^9}, {3.4935902147344904`*^9, 
   3.4935902271545076`*^9}, {3.4940008723616037`*^9, 
   3.4940008723656044`*^9}, {3.494026900415146*^9, 3.494026904582384*^9}, {
   3.494043967680809*^9, 3.4940439676848097`*^9}, 3.49408977836834*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "c", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}]}], " ", "-", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "2"}], ")"}]}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.493058294184078*^9, 3.493058321094116*^9}, {
   3.493058376614194*^9, 3.4930583929842167`*^9}, {3.4930584278042655`*^9, 
   3.4930584671043205`*^9}, {3.493058560144451*^9, 3.493058565344458*^9}, {
   3.493058608014518*^9, 3.493058608604519*^9}, {3.4930607207894773`*^9, 
   3.4930607253094835`*^9}, {3.49306140171043*^9, 3.4930614057704363`*^9}, {
   3.4930627552623253`*^9, 3.4930629395125833`*^9}, {3.493063111452824*^9, 
   3.4930631116128244`*^9}, {3.4930631532528825`*^9, 
   3.4930631552828856`*^9}, {3.4930631929229383`*^9, 
   3.4930631974729443`*^9}, {3.4934926396120934`*^9, 
   3.4934926491221066`*^9}, {3.4934935949134307`*^9, 
   3.4934937034035826`*^9}, {3.493580924681484*^9, 3.493580926611487*^9}, {
   3.494000872376605*^9, 3.4940008723846054`*^9}, 3.4940219216553774`*^9, {
   3.4940269176121297`*^9, 3.4940269206853056`*^9}, {3.49404396768781*^9, 
   3.49404396769381*^9}, 3.494089803128375*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"m", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.493256289109001*^9, 3.493256289109001*^9}, {3.4935821637032185`*^9, 
   3.4935821637032185`*^9}, {3.4935822523333426`*^9, 
   3.4935822523333426`*^9}, {3.494022083496634*^9, 3.4940220854777474`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                             ", 
      "\[IndentingNewLine]", "                                       ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "m"], 
       RowBox[{"2", " ", "a", " ", "m", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "m"}], "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", " ", "x"}], "]"}]}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "m"}], "+", "1"}], ")"}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "c", " ", "m"}], 
    RowBox[{
     RowBox[{"2", " ", "m"}], "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"m", "-", "1"}]], " ", 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.4933211866068697`*^9, {3.4933213613371143`*^9, 
   3.493321413107187*^9}, {3.493590253834545*^9, 3.4935902541945457`*^9}, {
   3.494000872396606*^9, 3.4940008723996067`*^9}, 3.4940269937464848`*^9, {
   3.49404396769681*^9, 3.49404396769881*^9}, {3.4940898703684688`*^9, 
   3.4940898743684745`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "a", "*", "m", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "m"}], "+", "1"}], ")"}]}], ")"}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "*", "m"}], "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", 
       RowBox[{"m", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "m"}], "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", "*", "x"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929236652023163`*^9, 3.49292366743312*^9}, 
   3.4929802336571484`*^9, {3.4935809181814747`*^9, 3.4935809199314775`*^9}, {
   3.494000872409607*^9, 3.494000872414607*^9}, 3.4940219216843786`*^9, 
   3.4940270107094545`*^9, {3.4940439677018104`*^9, 3.4940439677048106`*^9}, 
   3.4940898793584814`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{"-", 
      FractionBox["3", "2"]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.493582169323227*^9, 
   3.493582169323227*^9}, {3.4935822423333287`*^9, 3.4935822423333287`*^9}, {
   3.4940220872288475`*^9, 3.494022089098954*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", " ", "x"}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                            ", 
      "\[IndentingNewLine]", "                            ", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], 
        RowBox[{"4", " ", "a", " ", "c", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "2"]}]]}]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], 
     RowBox[{"m", "+", "1"}]], " ", 
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", " ", "x"}], "]"}]}], 
   RowBox[{"2", "c", 
    RowBox[{"(", 
     RowBox[{"m", "+", "1"}], ")"}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", "m"}], "+", "3"}], 
    RowBox[{"2", " ", "c", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"m", "+", "1"}]], " ", 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.4935902637145586`*^9, 3.493590263914559*^9}, {
   3.4940008724256077`*^9, 3.494000872428608*^9}, 3.4940270694718156`*^9, {
   3.494043967707811*^9, 3.4940439677098107`*^9}, {3.494089913398529*^9, 
   3.4940899188385367`*^9}, {3.4940900878687735`*^9, 3.4940900881687737`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a_.", "*", "x_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "/", 
     RowBox[{"(", 
      RowBox[{"4", "*", "a", "*", "c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "*", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "m"}], "+", "3"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", "*", "x"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.493580912351467*^9, 3.4935809141414695`*^9}, {
   3.4940008724396086`*^9, 3.4940008724446087`*^9}, 3.4940219217143807`*^9, 
   3.4940270857437468`*^9, {3.494043967712811*^9, 3.494043967716811*^9}, 
   3.494090148608858*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{"-", 
      FractionBox["3", "2"]}]}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.493057857853468*^9, 3.4930578807234993`*^9}, {3.4932562444189386`*^9, 
   3.4932562444189386`*^9}, {3.4935821752432346`*^9, 
   3.4935821752432346`*^9}, {3.493582235473319*^9, 3.493582235473319*^9}, {
   3.4940220905450373`*^9, 3.494022092415144*^9}}],

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", 
      RowBox[{
      "x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", "\t", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"n", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", 
              SuperscriptBox["x", "2"]}]}], ")"}], 
           RowBox[{"m", "+", "1"}]], " ", 
          SuperscriptBox[
           RowBox[{"ArcCot", "[", 
            RowBox[{"a", " ", "x"}], "]"}], 
           RowBox[{"n", "-", "1"}]]}], 
         RowBox[{"4", " ", "a", " ", "c", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "2"]}]]}]}]}]}]}], "-", 
   FractionBox[
    RowBox[{"x", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
    RowBox[{"2", " ", "c", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], "+", "\[IndentingNewLine]", "\t\t", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "m"}], "+", "3"}], 
     RowBox[{"2", " ", "c", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"m", "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
   RowBox[{
    FractionBox[
     RowBox[{"n", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}], 
     RowBox[{"4", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "2"]}]], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], 
       RowBox[{"n", "-", "2"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493057986293648*^9, 3.4930579935736575`*^9}, {
   3.493058073023769*^9, 3.4930581370938587`*^9}, {3.493058203013951*^9, 
   3.4930582589840293`*^9}, {3.4930583663841796`*^9, 
   3.4930583693341837`*^9}, {3.493058675794613*^9, 3.4930586798646183`*^9}, {
   3.4932494353148484`*^9, 3.4932495464338436`*^9}, {3.493256213058895*^9, 
   3.493256222448908*^9}, {3.4932569792699676`*^9, 3.4932569886099806`*^9}, {
   3.493322039288063*^9, 3.493322069838106*^9}, {3.4933221617682347`*^9, 
   3.49332216517824*^9}, {3.4940008724566097`*^9, 3.4940008724626102`*^9}, {
   3.494027345933628*^9, 3.4940273517789626`*^9}, {3.4940439677198114`*^9, 
   3.4940439677238116`*^9}, 3.4940902300789723`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "n"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"4", "*", "a", "*", "c", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "m"}], "+", "3"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"m", "\[NotEqual]", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.493058294184078*^9, 3.493058321094116*^9}, {
   3.493058376614194*^9, 3.4930583929842167`*^9}, {3.4930584278042655`*^9, 
   3.4930584671043205`*^9}, {3.493058560144451*^9, 3.493058565344458*^9}, {
   3.493058608014518*^9, 3.493058608604519*^9}, {3.4930607207894773`*^9, 
   3.4930607253094835`*^9}, {3.49306140171043*^9, 3.4930614057704363`*^9}, {
   3.4935809070514593`*^9, 3.493580908721462*^9}, {3.4940008724746103`*^9, 
   3.494000872485611*^9}, 3.494021921751383*^9, {3.4940273675488644`*^9, 
   3.494027380461603*^9}, {3.494043967727812*^9, 3.4940439677378125`*^9}, 
   3.494090266899024*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
     RowBox[{"m", "<", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"n", "<", 
      RowBox[{"-", "1"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.493057857853468*^9, 3.4930578807234993`*^9}, {3.4930589528050003`*^9, 
   3.4930589841650443`*^9}, {3.493256250928948*^9, 3.493256250928948*^9}, {
   3.493493532773344*^9, 3.493493535913348*^9}, {3.493498461430244*^9, 
   3.493498462750246*^9}, {3.4934986627805257`*^9, 3.4934986654705296`*^9}, {
   3.493500262062765*^9, 3.493500278262788*^9}, {3.4935009224036894`*^9, 
   3.4935009269736958`*^9}, {3.4935024446458206`*^9, 
   3.4935024539658337`*^9}, {3.4935821786732397`*^9, 
   3.4935821786732397`*^9}, {3.4935822229233017`*^9, 
   3.4935822229233017`*^9}, {3.493749489450018*^9, 3.4937494905732203`*^9}, {
   3.494022094284251*^9, 3.4940220963833714`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                           ", 
      "\[IndentingNewLine]", "                                  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", 
             SuperscriptBox["x", "2"]}]}], ")"}], 
          RowBox[{"m", "+", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", " ", "x"}], "]"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"a", " ", "c", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "a", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], 
    RowBox[{"n", "+", "1"}]], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{"x", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493058932894973*^9, 3.4930589343449745`*^9}, {
   3.4930590036150713`*^9, 3.493059030475109*^9}, {3.493059071585167*^9, 
   3.4930590795551777`*^9}, {3.4930628403524446`*^9, 3.49306285140246*^9}, {
   3.4932501056192265`*^9, 3.4932501067580285`*^9}, {3.493250146257298*^9, 
   3.493250186942169*^9}, {3.493256078498707*^9, 3.4932560906487236`*^9}, {
   3.4932568685898128`*^9, 3.4932568826798325`*^9}, {3.4933216732775507`*^9, 
   3.4933216957475824`*^9}, {3.4933217278376274`*^9, 3.493321760587673*^9}, 
   3.493321813507747*^9, 3.4933218644878187`*^9, {3.493321906837878*^9, 
   3.493321919617896*^9}, {3.4933220427280684`*^9, 3.493322042928068*^9}, {
   3.4934927094121914`*^9, 3.4934927441222396`*^9}, 3.493492777272286*^9, 
   3.493493493413289*^9, 3.4934935635433865`*^9, {3.4934984296601996`*^9, 
   3.4934984470202236`*^9}, {3.4934985399803543`*^9, 3.493498542300357*^9}, {
   3.4935897542938457`*^9, 3.4935897803338823`*^9}, {3.493590315164631*^9, 
   3.4935903239546432`*^9}, {3.494000872499612*^9, 3.4940008725036125`*^9}, {
   3.494027453089757*^9, 3.4940274536517897`*^9}, {3.494043967739813*^9, 
   3.494043967742813*^9}, {3.494090348259138*^9, 3.4940903520491433`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.493058294184078*^9, 3.493058321094116*^9}, {
   3.493058376614194*^9, 3.4930583929842167`*^9}, {3.4930584278042655`*^9, 
   3.4930584671043205`*^9}, {3.493058560144451*^9, 3.493058565344458*^9}, {
   3.493058608014518*^9, 3.493058608604519*^9}, {3.4930607207894773`*^9, 
   3.4930607253094835`*^9}, {3.49306140171043*^9, 3.4930614057704363`*^9}, {
   3.4930627552623253`*^9, 3.4930629395125833`*^9}, {3.493063111452824*^9, 
   3.4930631116128244`*^9}, {3.4930631532528825`*^9, 
   3.4930631552828856`*^9}, {3.4930631929229383`*^9, 
   3.4930631974729443`*^9}, {3.4934926396120934`*^9, 
   3.4934926491221066`*^9}, {3.4934935949134307`*^9, 
   3.4934937034035826`*^9}, {3.4934984698502555`*^9, 3.493498508170309*^9}, 
   3.4934985697303953`*^9, {3.4934986248104725`*^9, 3.493498645260501*^9}, {
   3.4934987095205913`*^9, 3.4934987697006755`*^9}, {3.4935001781326475`*^9, 
   3.493500210632693*^9}, {3.493500590983225*^9, 3.4935005923432274`*^9}, {
   3.4935009097536716`*^9, 3.4935009104136724`*^9}, {3.4935015174045224`*^9, 
   3.4935015211545277`*^9}, {3.4935022843455963`*^9, 3.493502302285621*^9}, {
   3.493502998526596*^9, 3.493502999946598*^9}, {3.493515736345019*^9, 
   3.4935157392850227`*^9}, {3.4935809012014513`*^9, 
   3.4935809031414537`*^9}, {3.4940008725136127`*^9, 3.4940008725176134`*^9}, 
   3.494021921778384*^9, {3.494027462266282*^9, 3.4940274625572987`*^9}, {
   3.494043967744813*^9, 3.494043967748813*^9}, {3.4940903621991577`*^9, 
   3.494090364759161*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "a"]}], " ", 
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "]"}], 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.4940008725436144`*^9, 
   3.4940008725506153`*^9}, {3.4940009604166403`*^9, 
   3.4940009604166403`*^9}, {3.4940275109330654`*^9, 
   3.4940275114480953`*^9}, {3.4940439677568135`*^9, 
   3.4940439677598133`*^9}, {3.49409054973942*^9, 3.4940905851994696`*^9}, {
   3.494090880409883*^9, 3.494090880409883*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, 
   3.4935791292589703`*^9, 3.4935800548602667`*^9, {3.4935803350706587`*^9, 
   3.4935803371806617`*^9}, {3.493580465490841*^9, 3.4935804699908476`*^9}, {
   3.493580624611064*^9, 3.4935806402710857`*^9}, 3.493582183493246*^9, 
   3.49358221460329*^9, {3.493582721734*^9, 3.4935827257140055`*^9}, {
   3.4940220978504553`*^9, 3.4940220998345685`*^9}, {3.494091015520072*^9, 
   3.494091027590089*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["c", "m"], "a"]}]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], 
       SuperscriptBox[
        RowBox[{"Csc", "[", "x", "]"}], 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493579009488803*^9, {3.4935790490588584`*^9, 
   3.4935790516388617`*^9}, {3.4935801113403454`*^9, 3.49358011445035*^9}, {
   3.4940008725696163`*^9, 3.494000872570616*^9}, 3.4940009614627004`*^9, {
   3.494043967763814*^9, 3.494043967764814*^9}, {3.4940910992501893`*^9, 
   3.494091116830214*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"c", "^", "m"}], "/", "a"}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Csc", "[", "x", "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", "x"}], "]"}],
         ",", "x", ",", 
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
   3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
   3.4930674148588486`*^9}, {3.4930676846992264`*^9, 
   3.4930676962292423`*^9}, {3.4935801866504507`*^9, 3.493580239560525*^9}, {
   3.493580375290715*^9, 3.4935803824807253`*^9}, {3.493580473120852*^9, 
   3.4935804871108713`*^9}, {3.493580711731186*^9, 3.493580717491194*^9}, {
   3.4935808945314417`*^9, 3.4935808963414445`*^9}, {3.493582837424162*^9, 
   3.4935828401941657`*^9}, {3.494000872581617*^9, 3.4940008725836167`*^9}, 
   3.4940009627607746`*^9, 3.494021921807386*^9, {3.494043967767814*^9, 
   3.4940439677698145`*^9}, {3.494091061100136*^9, 3.4940910713301506`*^9}, {
   3.4940911476202574`*^9, 3.494091153330265*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", "c"}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["c", 
        RowBox[{"m", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]], ",", "x"}], "]"}], "=", "0"}]],
  CellChangeTimes->{{3.4937498379858303`*^9, 3.4937499017587423`*^9}, {
   3.4937499674816575`*^9, 3.493750029569767*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.4937499298855915`*^9, 
   3.4937499486524243`*^9}, {3.4937500390389833`*^9, 
   3.4937500431885905`*^9}, {3.494022102011693*^9, 3.4940221040618105`*^9}, {
   3.494027568786375*^9, 3.494027569121394*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{"c", ">", "0"}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930801578959255`*^9, 
   3.4930801961259785`*^9}, {3.493256255798955*^9, 3.4932562676389713`*^9}, {
   3.493582187523252*^9, 3.493582201173271*^9}, {3.4935826492138987`*^9, 
   3.4935826803839417`*^9}, {3.4935827341640177`*^9, 
   3.4935827808740826`*^9}, {3.4935831190745564`*^9, 3.49358317149463*^9}, {
   3.4940221136913614`*^9, 3.4940221203557425`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "m"], 
   SuperscriptBox[
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["c", 
        RowBox[{"m", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.493077421798092*^9, 
   3.4930774294181027`*^9}, {3.49307964724521*^9, 3.493079659035227*^9}, {
   3.4930797467153497`*^9, 3.493079763295373*^9}, {3.493079973595667*^9, 
   3.4930800012057056`*^9}, {3.4932537598652487`*^9, 3.4932537660740595`*^9}, 
   3.493256110328751*^9, {3.4935825897438154`*^9, 3.4935826029438334`*^9}, {
   3.4940008725976176`*^9, 3.494000872599618*^9}, {3.494027611105795*^9, 
   3.494027622568451*^9}, {3.4940439677728148`*^9, 3.494043967773814*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "m_"}], "*", 
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", 
        RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"a", "^", "2"}], "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], "*", 
        RowBox[{
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
    " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
      " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{"d", "-", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"RationalQ", "[", 
      RowBox[{"{", 
       RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
     RowBox[{"m", "<", 
      RowBox[{"-", "1"}]}], " ", "&&", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"n", "<", "0"}], " ", "||", " ", 
       RowBox[{"Not", "[", 
        RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"m", "-", 
       RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"Not", "[", 
      RowBox[{"PositiveQ", "[", "c", "]"}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067423888861*^9, 3.4930674284788675`*^9}, 
   3.493068077149776*^9, {3.493080071975805*^9, 3.493080131335888*^9}, {
   3.4930802396760397`*^9, 3.4930802468960495`*^9}, {3.4932538772710547`*^9, 
   3.4932538805314603`*^9}, {3.4935808882514334`*^9, 3.493580890111436*^9}, {
   3.493582859644193*^9, 3.493582867944205*^9}, {3.4935830452044525`*^9, 
   3.4935830783744993`*^9}, {3.4935832217946997`*^9, 3.493583225184705*^9}, {
   3.494000872609618*^9, 3.4940008726116185`*^9}, 3.4940219218383875`*^9, {
   3.4940276302598906`*^9, 3.49402763374209*^9}, {3.4940439677768145`*^9, 
   3.494043967777815*^9}, {3.4940911928703203`*^9, 3.494091197620327*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616001935333*^9, 3.4796867203444157`*^9, {3.479687071148848*^9, 
   3.479687071399208*^9}, 3.4928222618129525`*^9, 3.4928258304168224`*^9, {
   3.4929226804037867`*^9, 3.4929226942254105`*^9}, {3.492979990624321*^9, 
   3.4929799910143223`*^9}, {3.493060035696517*^9, 3.4930600483865347`*^9}, 
   3.493253406025427*^9, {3.493354142567293*^9, 3.493354158680215*^9}, 
   3.494000872625619*^9, 3.4940439677798147`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}, {
  3.4935738213175373`*^9, 3.493573838477561*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493415722490226*^9, 
   3.493415730810238*^9}, {3.4935738213175373`*^9, 3.493573838477561*^9}, {
   3.4935823105834246`*^9, 3.4935823105834246`*^9}, {3.4935823762035165`*^9, 
   3.4935823762035165`*^9}, {3.49402212346492*^9, 3.4940221262390785`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"2", " ", "d", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["n", 
    RowBox[{"2", " ", "a", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933563805813007`*^9, 3.493356384480523*^9}, {
   3.4935738213175373`*^9, 3.493573838477561*^9}, {3.49400087263862*^9, 
   3.49400087264162*^9}, {3.4940277807875004`*^9, 3.494027781184523*^9}, {
   3.494043967781815*^9, 3.4940439677838154`*^9}, {3.4940912798004417`*^9, 
   3.4940912801504426`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "a", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, 3.493356145801872*^9, 
   3.4933562876739864`*^9, {3.493356396607217*^9, 3.493356401341488*^9}, {
   3.493415708300206*^9, 3.493415712490212*^9}, {3.493580788181293*^9, 
   3.493580790631296*^9}, {3.494000872651621*^9, 3.494000872655621*^9}, 
   3.4940219218733897`*^9, {3.494027787020857*^9, 3.494027787336875*^9}, {
   3.494043967786815*^9, 3.4940439677908154`*^9}, {3.4940912830404468`*^9, 
   3.494091283370447*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalQ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493415722490226*^9, 
   3.493415730810238*^9}, {3.4935159619553347`*^9, 3.49351600154539*^9}, {
   3.493582316753433*^9, 3.493582316753433*^9}, {3.493582369383507*^9, 
   3.493582369383507*^9}, {3.4949679439187803`*^9, 3.494967944658781*^9}, {
   3.4949694620709057`*^9, 3.4949694620709057`*^9}, 3.4951596747596626`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], "p"]}], 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"a", " ", "c", " ", 
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "3"}], ")"}], " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "p"]}], 
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933563805813007`*^9, 3.493356384480523*^9}, {
   3.4935159055452557`*^9, 3.4935159469853134`*^9}, {3.4935898317039537`*^9, 
   3.493589853353984*^9}, {3.4935903822847247`*^9, 3.4935904229047813`*^9}, {
   3.493590752655243*^9, 3.493590763525258*^9}, {3.4935908715154095`*^9, 
   3.4935908771554174`*^9}, {3.4935909258054857`*^9, 3.493590926785487*^9}, {
   3.493591021125619*^9, 3.493591039645645*^9}, {3.493591125495765*^9, 
   3.493591126025766*^9}, {3.4935912357559195`*^9, 3.49359123615592*^9}, {
   3.494967953858794*^9, 3.4949680122488756`*^9}, {3.4949693812107925`*^9, 
   3.494969427310857*^9}, {3.4951573292531414`*^9, 3.495157330329543*^9}, {
   3.4951596939944963`*^9, 3.4951597150545335`*^9}, {3.49515975839141*^9, 
   3.495159762431817*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "/", 
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "2"}]}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", "*", "x"}], "]"}]}], ")"}]}]}], " ", "-", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "p"}], "+", "3"}], ")"}], "*", 
            RowBox[{"a", "^", "2"}], "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "/", 
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, 3.493356145801872*^9, 
   3.4933562876739864`*^9, {3.493356396607217*^9, 3.493356401341488*^9}, {
   3.493415708300206*^9, 3.493415712490212*^9}, {3.4935159552553253`*^9, 
   3.493515974425352*^9}, {3.493516011355404*^9, 3.4935160426754475`*^9}, {
   3.493516152975602*^9, 3.4935161582156096`*^9}, {3.4935807957313037`*^9, 
   3.4935807976813064`*^9}, {3.494969533241005*^9, 3.4949695405110154`*^9}, {
   3.494969605621106*^9, 3.494969728921279*^9}, 3.4949697639513283`*^9, {
   3.495157330766344*^9, 3.4951573325603476`*^9}, {3.495159681514475*^9, 
   3.495159696334501*^9}, {3.4951597861750584`*^9, 3.4951597927114697`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493415722490226*^9, 
   3.493415730810238*^9}, {3.4935159619553347`*^9, 3.49351600154539*^9}, {
   3.493582316753433*^9, 3.493582316753433*^9}, {3.493582369383507*^9, 
   3.493582369383507*^9}, {3.494022136427662*^9, 3.49402213937683*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                                              \
     ", "\[IndentingNewLine]", "              ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"x", " ", 
         SuperscriptBox[
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", " ", "x"}], "]"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"a", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]}]}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], 
     RowBox[{"n", "+", "2"}]]}], 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}]}]], "-", 
  RowBox[{
   FractionBox["4", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"n", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"x", " ", 
       SuperscriptBox[
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], 
        RowBox[{"n", "+", "2"}]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], "2"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933563805813007`*^9, 3.493356384480523*^9}, {
   3.4935159055452557`*^9, 3.4935159469853134`*^9}, {3.4935898317039537`*^9, 
   3.493589853353984*^9}, {3.4935903822847247`*^9, 3.4935904229047813`*^9}, {
   3.493590752655243*^9, 3.493590763525258*^9}, {3.4935908715154095`*^9, 
   3.4935908771554174`*^9}, {3.4935909258054857`*^9, 3.493590926785487*^9}, {
   3.493591021125619*^9, 3.493591039645645*^9}, {3.493591125495765*^9, 
   3.493591126025766*^9}, {3.4935912357559195`*^9, 3.49359123615592*^9}, {
   3.4940008727176247`*^9, 3.494000872722625*^9}, {3.4940282162174053`*^9, 
   3.494028224476878*^9}, {3.4940439678088164`*^9, 3.4940439678128166`*^9}, {
   3.494091450250681*^9, 3.4940914560006886`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "2"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}]}]}], " ", "-", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", 
        RowBox[{"x", "^", "2"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}]}], ")"}]}]}], " ", "-", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"4", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{
           RowBox[{"ArcCot", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "+", "2"}], ")"}]}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "2"}]}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, 3.493356145801872*^9, 
   3.4933562876739864`*^9, {3.493356396607217*^9, 3.493356401341488*^9}, {
   3.493415708300206*^9, 3.493415712490212*^9}, {3.4935159552553253`*^9, 
   3.493515974425352*^9}, {3.493516011355404*^9, 3.4935160426754475`*^9}, {
   3.493516152975602*^9, 3.4935161582156096`*^9}, {3.4935807957313037`*^9, 
   3.4935807976813064`*^9}, {3.4940008727336254`*^9, 3.494000872740626*^9}, 
   3.494021921964395*^9, {3.494028236381559*^9, 3.494028244686034*^9}, {
   3.4940439678168173`*^9, 3.494043967822817*^9}, 3.494091468990707*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
     "\[And]", " ", 
     RowBox[{"m", "<", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     RowBox[{"m", "+", 
      RowBox[{"2", "p"}], "+", "3"}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493395008824994*^9, 3.493395011601799*^9}, {3.4933950592130823`*^9, 
   3.4933950626138887`*^9}, {3.4933958282120333`*^9, 
   3.4933958335004425`*^9}, {3.4933958648876977`*^9, 3.493395891672944*^9}, {
   3.493406394401163*^9, 3.4934063956011643`*^9}, {3.493414300772232*^9, 
   3.4934143075622416`*^9}, {3.4935055200960126`*^9, 
   3.4935055200960126`*^9}, {3.4935057649384427`*^9, 
   3.4935057649384427`*^9}, {3.493505853515398*^9, 3.493505853515398*^9}, {
   3.493582326893447*^9, 3.4935823540334854`*^9}, {3.4940221411059294`*^9, 
   3.4940221431790476`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                             ", 
      "\[IndentingNewLine]", "                                      ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, {
   3.493394874820759*^9, 3.4933949021052065`*^9}, {3.493395751163498*^9, 
   3.4933957978543797`*^9}, {3.493406138010804*^9, 3.4934061641108403`*^9}, {
   3.4934062369309425`*^9, 3.4934062462209554`*^9}, {3.49340655671139*^9, 
   3.4934065590813932`*^9}, {3.4934141473620167`*^9, 
   3.4934141575120316`*^9}, {3.493589928364089*^9, 3.4935899505341206`*^9}, {
   3.4940008727556267`*^9, 3.494000872758627*^9}, {3.4940439678248177`*^9, 
   3.494043967827818*^9}, {3.4940915429508104`*^9, 3.4940915432808113`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "p"}], "+", "3"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, {3.4933951036263604`*^9, 
   3.4933952261489754`*^9}, {3.4933952605626364`*^9, 3.493395282199874*^9}, {
   3.4933959219993978`*^9, 3.493396038968403*^9}, 3.4933965390584817`*^9, {
   3.4934062197609186`*^9, 3.49340622120092*^9}, {3.4934064692212677`*^9, 
   3.49340657783142*^9}, {3.49341417825206*^9, 3.4934141863320713`*^9}, {
   3.4934142170121145`*^9, 3.4934142188021173`*^9}, {3.493505515821605*^9, 
   3.493505516788807*^9}, 3.493505760539235*^9, {3.4935058497401915`*^9, 
   3.4935058506137934`*^9}, {3.493580815391331*^9, 3.4935808179213347`*^9}, {
   3.4940008727696276`*^9, 3.4940008727736273`*^9}, 3.494021921998397*^9, {
   3.4940439678308177`*^9, 3.494043967834818*^9}, {3.4940915592808332`*^9, 
   3.4940915596208344`*^9}, 3.517188528414097*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
     "\[And]", " ", 
     RowBox[{"n", "<", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"m", "+", 
      RowBox[{"2", "p"}], "+", "2"}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493395008824994*^9, 3.493395011601799*^9}, {3.4933950592130823`*^9, 
   3.4933950626138887`*^9}, {3.493444320208996*^9, 3.493444321758998*^9}, {
   3.4934444078191185`*^9, 3.4934444112891235`*^9}, {3.493444627119426*^9, 
   3.493444628299427*^9}, {3.4935055051355867`*^9, 3.4935055051355867`*^9}, {
   3.4935057857020793`*^9, 3.4935057857020793`*^9}, {3.493505835918567*^9, 
   3.493505835918567*^9}, {3.493582332753455*^9, 3.4935823464234743`*^9}, {
   3.4940221447601385`*^9, 3.4940221466862483`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", " ", "\[LongRightArrow]", 
      "                                                                       \
                                                              ", 
      "\[IndentingNewLine]", "                                   ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["x", "m"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", 
             SuperscriptBox["x", "2"]}]}], ")"}], 
          RowBox[{"p", "+", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", " ", "x"}], "]"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"a", " ", "c", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["m", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, {
   3.493394874820759*^9, 3.4933949021052065`*^9}, {3.493444143068748*^9, 
   3.493444163808777*^9}, {3.4934446369894395`*^9, 3.493444646849453*^9}, {
   3.49358997156415*^9, 3.493589988114173*^9}, {3.493590469004846*^9, 
   3.493590474204853*^9}, {3.4940008727886286`*^9, 3.494000872791629*^9}, {
   3.4940439678368177`*^9, 3.4940439678388186`*^9}, {3.4940916366309414`*^9, 
   3.494091639860946*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", "m"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "p"}], "+", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, {3.4933951036263604`*^9, 
   3.4933952261489754`*^9}, {3.4933952605626364`*^9, 3.493395282199874*^9}, 
   3.4933965801177535`*^9, {3.4933967072423773`*^9, 3.4933967295972166`*^9}, {
   3.4933967622168736`*^9, 3.493396766506881*^9}, {3.4934444505191784`*^9, 
   3.4934444533991823`*^9}, {3.4934444856092277`*^9, 3.493444554759324*^9}, {
   3.493444656619467*^9, 3.493444664049477*^9}, {3.493505499691177*^9, 
   3.493505500330778*^9}, 3.4935057823168736`*^9, {3.4935058303025575`*^9, 
   3.4935058307705584`*^9}, {3.493580826771347*^9, 3.49358082920135*^9}, {
   3.494000872801629*^9, 3.4940008728066297`*^9}, 3.4940219220283985`*^9, {
   3.4940439678428183`*^9, 3.494043967846819*^9}, {3.494091655310968*^9, 
   3.494091658670973*^9}, 3.5171885286168976`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "d"], "-", 
    FractionBox["c", 
     RowBox[{"d", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, 
   3.493790063331503*^9, 3.4937901678516493`*^9, {3.4937902960118284`*^9, 
   3.4937902973518305`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493582323023442*^9, 3.493582323023442*^9}, {3.4935823597934933`*^9, 
   3.4935823597934933`*^9}, {3.493857373585099*^9, 3.493857373585099*^9}, {
   3.4938623384460526`*^9, 3.4938623392360535`*^9}, {3.49386578680088*^9, 
   3.49386578680088*^9}, {3.493866462471826*^9, 3.493866466731832*^9}, {
   3.4940221484583497`*^9, 3.494022150644475*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "d"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "-", "2"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"p", "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["c", "d"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, 
   3.49385258804259*^9, {3.493852620612636*^9, 3.4938526898507333`*^9}, {
   3.4940008728236303`*^9, 3.4940008728266306`*^9}, {3.494043967848819*^9, 
   3.4940439678508186`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "/", "d"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, 3.493396573690542*^9, {3.4935808076513205`*^9, 
   3.493580810011324*^9}, {3.4938563531736703`*^9, 3.493856396943732*^9}, 
   3.4938565202739043`*^9, {3.493857377865105*^9, 3.4938573787451067`*^9}, {
   3.493862320526027*^9, 3.493862321776029*^9}, {3.493865803070903*^9, 
   3.4938658047609053`*^9}, {3.493866443151799*^9, 3.4938664464618034`*^9}, {
   3.4940008728366313`*^9, 3.494000872841632*^9}, 3.4940219220574007`*^9, {
   3.494043967853819*^9, 3.4940439678578196`*^9}, 3.5171885288196974`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["1", "c"], "-", 
    FractionBox[
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, 
   3.49290371904314*^9, {3.49316782040429*^9, 3.4931678273342996`*^9}, {
   3.4931678584343433`*^9, 3.4931678962243958`*^9}, {3.4931679645244913`*^9, 
   3.493167967024495*^9}, {3.4931679986345396`*^9, 3.4931680026345453`*^9}, 
   3.493790063331503*^9, 3.4937901678516493`*^9, {3.4937902960118284`*^9, 
   3.4937902973518305`*^9}, {3.493857825015731*^9, 3.4938578494057655`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"m", "<", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493582323023442*^9, 3.493582323023442*^9}, {3.4935823597934933`*^9, 
   3.4935823597934933`*^9}, {3.493857373585099*^9, 3.493857373585099*^9}, {
   3.4938574226851683`*^9, 3.4938574248351707`*^9}, {3.493861363812687*^9, 
   3.493861363812687*^9}, {3.493861896375434*^9, 3.4938618973254347`*^9}, {
   3.493862147205785*^9, 3.493862147205785*^9}, {3.493862334036046*^9, 
   3.4938623346860476`*^9}, {3.4938657907508855`*^9, 
   3.4938657907508855`*^9}, {3.493866473221841*^9, 3.493866473221841*^9}, {
   3.4940221525615845`*^9, 3.494022154445692*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "c"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}], ")"}], 
       RowBox[{"p", "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", " ", "x"}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["d", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellChangeTimes->{{3.493166154681958*^9, 3.4931662030820255`*^9}, 
   3.4931666207326107`*^9, {3.4932522463481894`*^9, 3.49325228099585*^9}, {
   3.4933158052693357`*^9, 3.4933158328693743`*^9}, {3.4933190308138514`*^9, 
   3.493319134053996*^9}, {3.4933192438441496`*^9, 3.4933192445541506`*^9}, {
   3.4933193363142796`*^9, 3.4933193414042864`*^9}, {3.493412534339759*^9, 
   3.493412536469762*^9}, {3.493789994101406*^9, 3.493790017041438*^9}, {
   3.4937903432618947`*^9, 3.4937903499119043`*^9}, {3.493791019842842*^9, 
   3.4937910517128863`*^9}, 3.493791106992964*^9, 3.49379132604327*^9, {
   3.4937915274235525`*^9, 3.493791535933564*^9}, {3.4937916827437696`*^9, 
   3.4937916869037757`*^9}, {3.4938571031547203`*^9, 3.493857152184789*^9}, {
   3.4940008728586326`*^9, 3.494000872861633*^9}, {3.4940439678598194`*^9, 
   3.4940439678618193`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"d", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", "0"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929236652023163`*^9, 3.49292366743312*^9}, 
   3.4929802336571484`*^9, {3.492982933672291*^9, 3.4929829505983205`*^9}, {
   3.4929832472016416`*^9, 3.4929833842790823`*^9}, {3.4929834529036026`*^9, 
   3.4929834542764053`*^9}, {3.493166117311906*^9, 3.493166138981936*^9}, {
   3.4931662751621265`*^9, 3.4931663186221876`*^9}, {3.4934126182898765`*^9, 
   3.493412622519882*^9}, {3.4935809700815477`*^9, 3.4935809719615507`*^9}, {
   3.493791136533005*^9, 3.4937911896730795`*^9}, 3.4937912549331713`*^9, {
   3.4938403406557693`*^9, 3.4938403671446157`*^9}, {3.4938574572652164`*^9, 
   3.493857469385233*^9}, {3.493857542505336*^9, 3.493857549915346*^9}, {
   3.493857663025504*^9, 3.4938576691055126`*^9}, 3.4938621399657745`*^9, {
   3.4938623256060343`*^9, 3.4938623265160356`*^9}, {3.49386579402089*^9, 
   3.493865798890897*^9}, 3.4938664556718163`*^9, {3.4940008728716335`*^9, 
   3.4940008728756337`*^9}, 3.4940219220874023`*^9, {3.4940439678648195`*^9, 
   3.49404396786882*^9}, 3.517188529022498*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"2", "p"}], "+", "3"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493395008824994*^9, 3.493395011601799*^9}, {3.4933950592130823`*^9, 
   3.4933950626138887`*^9}, {3.4933958282120333`*^9, 
   3.4933958335004425`*^9}, {3.4933958648876977`*^9, 3.493395891672944*^9}, {
   3.493406394401163*^9, 3.4934063956011643`*^9}, {3.4934443505890384`*^9, 
   3.493444358119049*^9}, {3.4935053801481667`*^9, 3.4935053801481667`*^9}, {
   3.4935057769504633`*^9, 3.4935057769504633`*^9}, {3.493505844997783*^9, 
   3.493505844997783*^9}, {3.493582329573451*^9, 3.4935823505034804`*^9}, {
   3.4940221595009813`*^9, 3.494022161594101*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "n"]}], 
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  "                                                                ", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "n"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", "p"}], "+", "3"}], ")"}]}], 
    RowBox[{" ", 
     RowBox[{"m", "+", "1"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, {
   3.493394874820759*^9, 3.4933949021052065`*^9}, {3.493395751163498*^9, 
   3.4933957978543797`*^9}, {3.493406138010804*^9, 3.4934061641108403`*^9}, {
   3.4934062369309425`*^9, 3.4934062462209554`*^9}, {3.49340655671139*^9, 
   3.4934065590813932`*^9}, {3.4940008728906345`*^9, 
   3.4940008728956347`*^9}, {3.4940285760279856`*^9, 3.494028576547015*^9}, {
   3.49404396787182*^9, 3.4940439678748207`*^9}, 3.494091832841216*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "p"}], "+", "3"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "p"}], "+", "3"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, {3.4933951036263604`*^9, 
   3.4933952261489754`*^9}, {3.4933952605626364`*^9, 3.493395282199874*^9}, {
   3.4933959219993978`*^9, 3.493396038968403*^9}, 3.4933965390584817`*^9, {
   3.4934062197609186`*^9, 3.49340622120092*^9}, {3.4934064692212677`*^9, 
   3.49340657783142*^9}, {3.4934442542789035`*^9, 3.493444261298914*^9}, {
   3.4935053828469715`*^9, 3.4935053837985735`*^9}, 3.493505773830458*^9, {
   3.4935058411913767`*^9, 3.493505841986978*^9}, {3.493580821131339*^9, 
   3.493580823141342*^9}, {3.4938648637095876`*^9, 3.493864868009594*^9}, {
   3.4938653914803267`*^9, 3.493865394630331*^9}, {3.4940008729066353`*^9, 
   3.4940008729146357`*^9}, 3.4940219221254044`*^9, {3.4940285863885784`*^9, 
   3.4940285866645937`*^9}, {3.4940439678788204`*^9, 3.494043967884821*^9}, {
   3.494091893891302*^9, 3.4940918943413024`*^9}, 3.5171885292252984`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.493099207935931*^9, 3.4930992149659414`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   "n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"2", "p"}], "+", "2"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703363181205*^9, 
   3.480703382168507*^9}, 3.480703460921749*^9, {3.480705327535808*^9, 
   3.480705327856269*^9}, {3.492923482510395*^9, 3.4929235301528788`*^9}, {
   3.492923560276532*^9, 3.4929235623513355`*^9}, {3.4929245188358154`*^9, 
   3.4929245675391006`*^9}, {3.492982857559757*^9, 3.492982857559757*^9}, {
   3.4932562829889927`*^9, 3.4932562829889927`*^9}, {3.4933543405726185`*^9, 
   3.493354354743429*^9}, {3.493354669307421*^9, 3.493354670200472*^9}, {
   3.4933549046238804`*^9, 3.493354922498903*^9}, {3.493356182221955*^9, 
   3.4933562049342537`*^9}, {3.4933938872666245`*^9, 
   3.4933939122734685`*^9}, {3.493394021941661*^9, 3.493394030412476*^9}, {
   3.493395008824994*^9, 3.493395011601799*^9}, {3.4933950592130823`*^9, 
   3.4933950626138887`*^9}, {3.493444320208996*^9, 3.493444321758998*^9}, {
   3.4934444078191185`*^9, 3.4934444112891235`*^9}, {3.4935053527545185`*^9, 
   3.4935053527545185`*^9}, {3.4935057932368927`*^9, 
   3.4935057932368927`*^9}, {3.4935058259189496`*^9, 
   3.4935058259189496`*^9}, {3.493582335173459*^9, 3.493582342413469*^9}, {
   3.4940221631801915`*^9, 3.4940221650502987`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", " ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["x", "m"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", 
             SuperscriptBox["x", "2"]}]}], ")"}], 
          RowBox[{"p", "+", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", " ", "x"}], "]"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"a", " ", "c", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  "                                                                       ", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["m", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", "p"}], "+", "2"}], ")"}]}], 
    RowBox[{"n", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579731627235`*^9, 3.4796580024248*^9}, 
   3.479661193863864*^9, {3.4796867203744593`*^9, 3.479686740172928*^9}, {
   3.479687170041048*^9, 3.479687187285845*^9}, {3.4932572591203594`*^9, 
   3.493257265540368*^9}, {3.4932573960105515`*^9, 3.4932574249505916`*^9}, 
   3.493321120456777*^9, 3.49332119396688*^9, {3.4933214175471926`*^9, 
   3.4933214366372194`*^9}, {3.4933214780072775`*^9, 
   3.4933214840172863`*^9}, {3.493354278495068*^9, 3.493354294476982*^9}, {
   3.4933546277870464`*^9, 3.4933546449460278`*^9}, {3.493354790721366*^9, 
   3.4933547931895065`*^9}, {3.4933560394157867`*^9, 
   3.4933561011583185`*^9}, {3.4933561738414755`*^9, 
   3.4933561751395497`*^9}, {3.4933562501758413`*^9, 
   3.4933562530870085`*^9}, {3.493356410270999*^9, 3.4933564233687477`*^9}, {
   3.493394874820759*^9, 3.4933949021052065`*^9}, {3.493444143068748*^9, 
   3.493444163808777*^9}, {3.494000872929637*^9, 3.494000872934637*^9}, {
   3.4940286415867357`*^9, 3.4940286418847523`*^9}, {3.494043967887821*^9, 
   3.4940439678908215`*^9}, {3.4940919951514435`*^9, 3.4940920019114532`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_."}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", "m"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a", "*", "x"}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "p"}], "+", "2"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
         RowBox[{
          RowBox[{"ArcCot", "[", 
           RowBox[{"a", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", 
      RowBox[{"2", "*", "p"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "p"}], "+", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4929226712309704`*^9, 3.4929226741793756`*^9}, {
   3.4929227061594315`*^9, 3.4929229312990274`*^9}, {3.492922998410345*^9, 
   3.492923016443977*^9}, {3.49292307539648*^9, 3.4929230998417234`*^9}, {
   3.492923399487049*^9, 3.49292339992385*^9}, {3.4929234702175736`*^9, 
   3.4929234715435762`*^9}, {3.4929235863597775`*^9, 
   3.4929237005051785`*^9}, {3.4929237523440695`*^9, 3.49292375875568*^9}, {
   3.492923919591963*^9, 3.4929239241159706`*^9}, {3.4929244782757444`*^9, 
   3.4929244935793715`*^9}, {3.4933546901676145`*^9, 3.493354852357891*^9}, {
   3.493354994220005*^9, 3.4933549944920206`*^9}, {3.4933561282218666`*^9, 
   3.493356154267356*^9}, {3.4933562088824797`*^9, 3.493356243066435*^9}, {
   3.4933562812016163`*^9, 3.4933563433891735`*^9}, {3.4933564509923277`*^9, 
   3.4933564967799463`*^9}, {3.4933565518720975`*^9, 3.493356556926387*^9}, {
   3.493356683297615*^9, 3.493356683651635*^9}, {3.493393781030438*^9, 
   3.4933937826528406`*^9}, {3.49339383350893*^9, 3.4933938341173315`*^9}, {
   3.4933938692017927`*^9, 3.4933938715417967`*^9}, {3.4933939716159725`*^9, 
   3.4933939737687764`*^9}, {3.4933951036263604`*^9, 
   3.4933952261489754`*^9}, {3.4933952605626364`*^9, 3.493395282199874*^9}, 
   3.4933965801177535`*^9, {3.4933967072423773`*^9, 3.4933967295972166`*^9}, {
   3.4933967622168736`*^9, 3.493396766506881*^9}, {3.4934444505191784`*^9, 
   3.4934444533991823`*^9}, {3.4934444856092277`*^9, 3.493444554759324*^9}, 
   3.4934449081898193`*^9, {3.4935053477937098`*^9, 3.4935053483397107`*^9}, 
   3.493505790023287*^9, {3.4935058218473425`*^9, 3.4935058223465433`*^9}, {
   3.4935808341413574`*^9, 3.4935808367413607`*^9}, {3.493864871779599*^9, 
   3.493864875919605*^9}, {3.4938653985703363`*^9, 3.4938654013003407`*^9}, {
   3.4940008729456377`*^9, 3.494000872953638*^9}, 3.4940219221544056`*^9, {
   3.49402863660445*^9, 3.494028636917468*^9}, {3.494043967894821*^9, 
   3.494043967901822*^9}, {3.494092014861471*^9, 3.4940920202314787`*^9}, 
   3.5171885294280987`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis:",
 " If ",
 Cell[BoxData[
  RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " and (",
 Cell[BoxData[
  RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " or ",
 Cell[BoxData[
  RowBox[{"a", ">", "0"}]]],
 "),",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"e", "+", 
      RowBox[{"f", " ", 
       SuperscriptBox["x", "m"]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      SuperscriptBox["a", 
       RowBox[{"m", "+", "1"}]]]}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"e", " ", 
       SuperscriptBox["a", "m"]}], "+", 
      RowBox[{"f", " ", 
       SuperscriptBox[
        RowBox[{"Cot", "[", 
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", " ", "x"}], "]"}], "]"}], "m"]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "]"}], 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.4935837156853914`*^9, 
   3.4935837306154127`*^9}, {3.493583770785469*^9, 3.4935837932255*^9}, 
   3.493583845935574*^9, {3.49497090133292*^9, 3.4949709217329493`*^9}, {
   3.4949709668630123`*^9, 3.4949710356931086`*^9}, {3.494971138883253*^9, 
   3.494971138883253*^9}, {3.4951576509725065`*^9, 3.49515765306291*^9}, {
   3.4951577021093965`*^9, 3.4951577073822055`*^9}, 3.495157784558342*^9, {
   3.49515782876882*^9, 3.495157831873225*^9}, {3.49515987818402*^9, 
   3.495159878542821*^9}, {3.4951599154992857`*^9, 3.495159931692114*^9}, 
   3.495160083979582*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
      " ", 
      RowBox[{"a", ">", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, {
   3.493484196390273*^9, 3.493484198590276*^9}, {3.4934849126412754`*^9, 
   3.493484912921276*^9}, {3.4934858273225565`*^9, 3.4934858277825565`*^9}, {
   3.4934858606226025`*^9, 3.493485878442628*^9}, {3.493485980752771*^9, 
   3.493486013532817*^9}, 3.4934861613430243`*^9, {3.493582299533409*^9, 
   3.493582299533409*^9}, {3.49358240752356*^9, 3.49358240752356*^9}, {
   3.493584403266354*^9, 3.4935844505964203`*^9}, {3.493584685416749*^9, 
   3.4935846881867533`*^9}, {3.4935847277768087`*^9, 
   3.4935847301168118`*^9}, {3.4935855704579883`*^9, 
   3.4935855725279913`*^9}, {3.4951580589940243`*^9, 3.495158090225279*^9}, 
   3.4951598940180483`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"e", "+", 
     RowBox[{"f", " ", 
      SuperscriptBox["x", "m"]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["c", "p"], 
       SuperscriptBox["a", 
        RowBox[{"m", "+", "1"}]]]}]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"e", " ", 
          SuperscriptBox["a", "m"]}], "+", 
         RowBox[{"f", " ", 
          SuperscriptBox[
           RowBox[{"Cot", "[", "x", "]"}], "m"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Csc", "[", "x", "]"}], 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493484110810153*^9, {3.4934842003402786`*^9, 
   3.4934842033302827`*^9}, {3.4934849452513213`*^9, 3.493484979331369*^9}, {
   3.493583483165066*^9, 3.4935834997850895`*^9}, {3.4935840350458384`*^9, 
   3.493584038155843*^9}, {3.4949712212333684`*^9, 3.494971230293381*^9}, {
   3.4949712621134253`*^9, 3.4949712970934744`*^9}, {3.49515766434173*^9, 
   3.4951576691309385`*^9}, {3.4951579443182225`*^9, 3.495157973178273*^9}, {
   3.4951599182916903`*^9, 3.495159934515719*^9}, 3.4951601461812916`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"e_.", "+", 
       RowBox[{"f_.", "*", 
        RowBox[{"x_", "^", "m_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"c", "^", "p"}], "/", 
       RowBox[{"a", "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Expand", "[", 
           RowBox[{
            RowBox[{"x", "^", "n"}], "*", 
            RowBox[{"TrigReduce", "[", 
             RowBox[{"Regularize", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"e", "*", 
                   RowBox[{"a", "^", "m"}]}], "+", 
                  RowBox[{"f", "*", 
                   RowBox[{
                    RowBox[{"Cot", "[", "x", "]"}], "^", "m"}]}]}], ")"}], 
                "*", 
                RowBox[{
                 RowBox[{"Csc", "[", "x", "]"}], "^", 
                 RowBox[{"(", 
                  RowBox[{"2", "*", 
                   RowBox[{"(", 
                    RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], ",", "x"}], 
              "]"}], "]"}]}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "a", "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
   3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
   3.4930674148588486`*^9}, {3.4930676846992264`*^9, 
   3.4930676962292423`*^9}, {3.493484206670287*^9, 3.4934842155203*^9}, 
   3.4934861347329865`*^9, {3.49348619445307*^9, 3.493486231663122*^9}, {
   3.4934862761831846`*^9, 3.4934862874732003`*^9}, {3.493580741261227*^9, 
   3.4935807428812294`*^9}, {3.4935808762114162`*^9, 3.493580878411419*^9}, {
   3.4935841108559446`*^9, 3.4935841493659987`*^9}, {3.493584751096841*^9, 
   3.4935847734468727`*^9}, 3.4935848245769444`*^9, {3.493584859686993*^9, 
   3.493584861126995*^9}, 3.493585344727672*^9, 3.4935853768577175`*^9, {
   3.4935856376880827`*^9, 3.4935856399880857`*^9}, {3.4949713407035356`*^9, 
   3.494971373883582*^9}, {3.494971426013655*^9, 3.4949714378836718`*^9}, {
   3.494972220994768*^9, 3.49497223640479*^9}, {3.4949725116251745`*^9, 
   3.494972523895192*^9}, {3.495157673108946*^9, 3.495157676260151*^9}, {
   3.495158126417342*^9, 3.495158147196579*^9}, {3.495158213387495*^9, 
   3.495158219892707*^9}, {3.495159921333696*^9, 3.495159946886541*^9}, 
   3.4951601513293004`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"]}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "a"]}], 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"Cot", "[", 
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", " ", "x"}], "]"}], "]"}], "a"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"Csc", "[", 
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "]"}], 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"p", "+", "1"}], ")"}]}]], " ", 
    SuperscriptBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}], "n"], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.4935837156853914`*^9, 
   3.4935837306154127`*^9}, {3.493583770785469*^9, 3.4935837932255*^9}, 
   3.493583845935574*^9, {3.493585128467369*^9, 3.493585152037402*^9}, {
   3.4940008730496435`*^9, 3.4940008730636444`*^9}, {3.4940009671060233`*^9, 
   3.4940009671060233`*^9}, {3.494028684350181*^9, 3.4940286847392035`*^9}, {
   3.4940439679288235`*^9, 3.4940439679338236`*^9}, {3.4940925784422603`*^9, 
   3.4940926121423073`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
       " ", 
       RowBox[{"a", ">", "0"}]}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930669874082503`*^9, 
   3.4930669888982525`*^9}, {3.4932562746689816`*^9, 
   3.4932562746689816`*^9}, {3.493256683249553*^9, 3.4932567141395965`*^9}, {
   3.493484196390273*^9, 3.493484198590276*^9}, {3.4934849126412754`*^9, 
   3.493484912921276*^9}, {3.4934858273225565`*^9, 3.4934858277825565`*^9}, {
   3.4934858606226025`*^9, 3.493485878442628*^9}, {3.493485980752771*^9, 
   3.493486013532817*^9}, 3.4934860446528606`*^9, 3.493486166643031*^9, {
   3.493582304453416*^9, 3.493582304453416*^9}, {3.4935823991735487`*^9, 
   3.4935823991735487`*^9}, {3.49358546440784*^9, 3.4935854739178534`*^9}, 
   3.4935855059178977`*^9, {3.4937503523187337`*^9, 3.4937503527399344`*^9}, {
   3.4940221756839066`*^9, 3.4940221776450195`*^9}, {3.4940927046324368`*^9, 
   3.4940927181624556`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["c", "p"], "a"]}]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "n"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Cot", "[", "x", "]"}], "/", "a"}], ")"}], "m"], " ", 
       SuperscriptBox[
        RowBox[{"Csc", "[", "x", "]"}], 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.4930663212373176`*^9, 
   3.493066363577377*^9}, {3.493066963568217*^9, 3.493066975738234*^9}, 
   3.4932537469796257`*^9, 3.493256113988756*^9, {3.4932567461396413`*^9, 
   3.4932567491696453`*^9}, 3.493484110810153*^9, {3.4934842003402786`*^9, 
   3.4934842033302827`*^9}, {3.4934849452513213`*^9, 3.493484979331369*^9}, {
   3.493486071912899*^9, 3.493486082822914*^9}, {3.4935835296251307`*^9, 
   3.4935835407851467`*^9}, {3.493585265387561*^9, 3.4935852691475663`*^9}, {
   3.4940008730846453`*^9, 3.4940008730876455`*^9}, 3.4940009681030803`*^9, {
   3.4940439679378242`*^9, 3.494043967939824*^9}, {3.49409261389231*^9, 
   3.494092627352329*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"c", "^", "p"}], "/", "a"}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Cot", "[", "x", "]"}], "/", "a"}], ")"}], "^", "m"}], 
           "*", 
           RowBox[{
            RowBox[{"Csc", "[", "x", "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"2", "*", 
              RowBox[{"(", 
               RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], ",", "x"}], "]"}],
         ",", "x", ",", 
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", "*", "x"}], "]"}]}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"PositiveQ", "[", "a", "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067047288334*^9, 3.493067049548337*^9}, {
   3.4930670867783895`*^9, 3.493067112388425*^9}, {3.4930674070088377`*^9, 
   3.4930674148588486`*^9}, {3.4930676846992264`*^9, 
   3.4930676962292423`*^9}, {3.493484206670287*^9, 3.4934842155203*^9}, 
   3.4934861304629803`*^9, 3.4934861903430643`*^9, {3.4934862534031525`*^9, 
   3.493486262273165*^9}, {3.4934862996232176`*^9, 3.4934863089332304`*^9}, {
   3.4935808677814045`*^9, 3.493580870141408*^9}, {3.4935853052876167`*^9, 
   3.493585373757713*^9}, {3.4935856061680384`*^9, 3.493585615798052*^9}, 
   3.493585663598119*^9, {3.494000873097646*^9, 3.4940008731026464`*^9}, 
   3.4940009687371163`*^9, 3.494021922212409*^9, {3.4940439679428244`*^9, 
   3.494043967946824*^9}, {3.4940926168223143`*^9, 3.4940926222223215`*^9}, {
   3.494092724202464*^9, 3.4940927359224806`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"d", "=", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", "c"}]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["c", 
        RowBox[{"p", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]], ",", "x"}], "]"}], "=", "0"}]],
  CellChangeTimes->{{3.4937498379858303`*^9, 3.4937499017587423`*^9}, {
   3.4937499674816575`*^9, 3.493750029569767*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664448654022*^9, 3.479664485386842*^9, {3.4796905699999485`*^9, 
   3.4796905930330687`*^9}, {3.493066205237155*^9, 3.493066233807195*^9}, {
   3.493067002288271*^9, 3.493067007218278*^9}, {3.4930671665685015`*^9, 
   3.4930671719285088`*^9}, {3.49357941453937*^9, 3.4935794178593745`*^9}, {
   3.4935794530694237`*^9, 3.4935794623694367`*^9}, {3.493579591189617*^9, 
   3.4935795950296226`*^9}, {3.4935796369196815`*^9, 3.493579680229742*^9}, {
   3.4935798057299175`*^9, 3.493579823249942*^9}, {3.493580013000208*^9, 
   3.4935800183302155`*^9}, {3.4937499298855915`*^9, 
   3.4937499486524243`*^9}, {3.4937500390389833`*^9, 3.4937500431885905`*^9}, 
   3.4937501538707848`*^9, {3.494022180342173*^9, 3.4940221826333046`*^9}, {
   3.494028827004341*^9, 3.494028827554372*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"d", "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "c"}], " ", "\[And]", " ", "m"}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "<", "0"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{"c", ">", "0"}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055117607107`*^9, {3.4930655124161854`*^9, 3.4930655280062075`*^9}, {
   3.493066033556915*^9, 3.49306607975698*^9}, {3.4930680892297926`*^9, 
   3.4930681267098455`*^9}, {3.4930801578959255`*^9, 
   3.4930801961259785`*^9}, {3.493256255798955*^9, 3.4932562676389713`*^9}, {
   3.4934842169503016`*^9, 3.4934842179803033`*^9}, {3.4934855092121105`*^9, 
   3.4934855137621174`*^9}, {3.49358230776342*^9, 3.49358230776342*^9}, {
   3.4935823874135323`*^9, 3.4935823874135323`*^9}, {3.493586084528708*^9, 
   3.4935861150187507`*^9}, {3.493750356390341*^9, 3.493750356561941*^9}, {
   3.4940221861375046`*^9, 3.4940221880396137`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "p"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["c", 
        RowBox[{"p", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "2"]}]}]]}], 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "p"], 
     SuperscriptBox[
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579733429823`*^9, 3.4796580025249443`*^9}, {
   3.4796580760106115`*^9, 3.479658076961979*^9}, {3.479658170546547*^9, 
   3.47965817467248*^9}, {3.4796583692823153`*^9, 3.4796583839634256`*^9}, {
   3.4796584934408464`*^9, 3.479658497486664*^9}, {3.479661194084181*^9, 
   3.47966122030188*^9}, 3.479661392649704*^9, {3.4796614543984947`*^9, 
   3.4796614565015182`*^9}, {3.4796616029320755`*^9, 3.47966160861024*^9}, 
   3.479661772305622*^9, 3.47966185512471*^9, {3.4796624643307056`*^9, 
   3.4796624837586412`*^9}, {3.4796684805015345`*^9, 3.479668482213997*^9}, {
   3.47968672053469*^9, 3.479686720544704*^9}, {3.4796906638949633`*^9, 
   3.479690664315568*^9}, {3.479690714507741*^9, 3.4796907460130434`*^9}, 
   3.480705514654872*^9, {3.4930650337755156`*^9, 3.493065049545537*^9}, {
   3.4930657623365355`*^9, 3.4930657881965714`*^9}, {3.493077421798092*^9, 
   3.4930774294181027`*^9}, {3.49307964724521*^9, 3.493079659035227*^9}, {
   3.4930797467153497`*^9, 3.493079763295373*^9}, {3.493079973595667*^9, 
   3.4930800012057056`*^9}, {3.4932537598652487`*^9, 3.4932537660740595`*^9}, 
   3.493256110328751*^9, 3.4934841140101576`*^9, {3.4934842214303083`*^9, 
   3.49348422304031*^9}, 3.493485244821741*^9, 3.4934853226618495`*^9, {
   3.49358577884828*^9, 3.493585797488306*^9}, {3.4940008731186476`*^9, 
   3.4940008731196475`*^9}, {3.4940288304975405`*^9, 
   3.4940288342037525`*^9}, {3.4940439679498243`*^9, 3.4940439679508247`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x_", "^", "m_."}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "p_"}], "*", 
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a_.", "*", "x_"}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "^", 
      RowBox[{"(", 
       RowBox[{"p", "-", 
        RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"a", "^", "2"}], "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}], "*", 
        RowBox[{
         RowBox[{"ArcCot", "[", 
          RowBox[{"a", "*", "x"}], "]"}], "^", "n"}]}], ",", "x"}], "]"}]}], 
    " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
      " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{"d", "-", 
       RowBox[{
        RowBox[{"a", "^", "2"}], "*", "c"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"RationalQ", "[", 
      RowBox[{"{", 
       RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
     RowBox[{"p", "<", 
      RowBox[{"-", "1"}]}], " ", "&&", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"n", "<", "0"}], " ", "||", " ", 
       RowBox[{"Not", "[", 
        RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}], ")"}], " ", "&&", " ", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"p", "-", 
       RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"Not", "[", 
      RowBox[{"PositiveQ", "[", "c", "]"}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.493065103075612*^9, 3.493065290765875*^9}, {
   3.493065714046468*^9, 3.493065729586489*^9}, {3.4930658063465967`*^9, 
   3.4930658068865976`*^9}, {3.493067423888861*^9, 3.4930674284788675`*^9}, 
   3.493068077149776*^9, {3.493080071975805*^9, 3.493080131335888*^9}, {
   3.4930802396760397`*^9, 3.4930802468960495`*^9}, {3.4932538772710547`*^9, 
   3.4932538805314603`*^9}, {3.493484225600314*^9, 3.493484231900323*^9}, {
   3.4934853924419475`*^9, 3.4934853982519555`*^9}, {3.493485439292013*^9, 
   3.4934854647520485`*^9}, {3.493580855471387*^9, 3.4935808593213925`*^9}, {
   3.4935858177883344`*^9, 3.4935858468983755`*^9}, 3.493585879718421*^9, 
   3.493586196118864*^9, {3.4935862626189575`*^9, 3.493586266048962*^9}, {
   3.494000873129648*^9, 3.4940008731326485`*^9}, 3.4940219222474113`*^9, {
   3.4940288374769397`*^9, 3.494028840943138*^9}, {3.494043967953825*^9, 
   3.4940439679548244`*^9}, {3.4940927673925247`*^9, 3.494092772072531*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcCot", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, {
   3.4796161531027007`*^9, 3.4796161533330317`*^9}, 3.4796867035102096`*^9, {
   3.4928216890767465`*^9, 3.4928216998095655`*^9}, {3.4928217819749093`*^9, 
   3.492821789587723*^9}, {3.4928219276815653`*^9, 3.492821955418414*^9}, {
   3.492821987970072*^9, 3.4928219896860743`*^9}, {3.4928221957624364`*^9, 
   3.4928222365253077`*^9}, {3.492825657442519*^9, 3.4928256592053223`*^9}, 
   3.4940008732746563`*^9, 3.494043967987827*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.822.2, CRC 444, A&S 4.4.63", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, {
   3.4940999508525815`*^9, 3.4940999513525825`*^9}}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070527384861*^9, 3.494109939029312*^9, 3.494112226023958*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], "b"]}]}]}]}], "+", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "2"]}], "]"}], 
   RowBox[{"2", " ", "b"}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579729524207`*^9, 3.479658002354699*^9}, {
   3.479658032958706*^9, 3.479658033819944*^9}, {3.479658266604672*^9, 
   3.479658270990979*^9}, 3.4796611918409553`*^9, {3.4796613913478317`*^9, 
   3.47966140315481*^9}, {3.479661508025606*^9, 3.47966151197128*^9}, {
   3.4796618227781982`*^9, 3.4796618235292788`*^9}, 3.479666675846568*^9, {
   3.4796867202542863`*^9, 3.479686720274315*^9}, {3.4796868616776433`*^9, 
   3.479686861938018*^9}, 3.480705278835781*^9, 3.4941093719059157`*^9, {
   3.494111977016321*^9, 3.4941119773283215`*^9}, {3.494112096481331*^9, 
   3.494112145325017*^9}, {3.4941123915090494`*^9, 3.49411239191465*^9}, {
   3.4941136987965527`*^9, 3.4941137252073994`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcCot", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", "x_"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "b"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494109908110058*^9, 3.4941099093268595`*^9}, 
   3.49411043303938*^9, 3.494110873053753*^9, {3.4941120188555946`*^9, 
   3.494112019183195*^9}, {3.4941122005335135`*^9, 3.494112205135522*^9}, {
   3.4941123936150527`*^9, 3.4941123947382545`*^9}, {3.4941137004501557`*^9, 
   3.4941137013861575`*^9}, {3.4941137388574233`*^9, 3.494113739153824*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.822.2, CRC 444, A&S 4.4.63", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, {
   3.4940999508525815`*^9, 3.4940999513525825`*^9}}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070527384861*^9, 3.494113965120221*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}]}]}], "+", 
  RowBox[{"b", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", "n"], 
      RowBox[{"1", "+", 
       SuperscriptBox["a", "2"], "+", 
       RowBox[{"2", " ", "a", " ", "b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579729524207`*^9, 3.479658002354699*^9}, {
   3.479658032958706*^9, 3.479658033819944*^9}, {3.479658266604672*^9, 
   3.479658270990979*^9}, 3.4796611918409553`*^9, {3.4796613913478317`*^9, 
   3.47966140315481*^9}, {3.479661508025606*^9, 3.47966151197128*^9}, {
   3.4796618227781982`*^9, 3.4796618235292788`*^9}, 3.479666675846568*^9, {
   3.4796867202542863`*^9, 3.479686720274315*^9}, {3.4796868616776433`*^9, 
   3.479686861938018*^9}, 3.480705278835781*^9, {3.494000873285657*^9, 
   3.4940008732866573`*^9}, {3.4940020470996175`*^9, 
   3.4940020476156473`*^9}, {3.494043967989827*^9, 3.4940439679908266`*^9}, {
   3.4940442753044043`*^9, 3.4940442757304287`*^9}, 3.4941139304101596`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcCot", "[", 
     RowBox[{"a_", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "n_"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "n"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"2", "*", "a", "*", "b", "*", 
            RowBox[{"x", "^", "n"}]}], "+", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "*", 
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4940008732956576`*^9, 3.4940008732976575`*^9}, 
   3.4940020232142515`*^9, {3.494043967993827*^9, 3.4940439679948273`*^9}, {
   3.494044278867608*^9, 3.4940442792266283`*^9}, {3.4941139713602314`*^9, 
   3.4941139764302406`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"ArcCot", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796867203043585`*^9, {3.4928222468993263`*^9, 3.492822253420138*^9}, {
   3.4928256632301292`*^9, 3.4928256645561314`*^9}, 3.494000873304658*^9, 
   3.4940439679978275`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcCot", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       FractionBox["\[ImaginaryI]", "z"]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       FractionBox["\[ImaginaryI]", "z"]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664431619528*^9, 3.4796644842351856`*^9, {3.4796867203243876`*^9, 
   3.4796867203243876`*^9}, {3.479686900964134*^9, 3.479686904699506*^9}, {
   3.494000873321659*^9, 3.494000873321659*^9}, {3.4940016544041567`*^9, 
   3.4940016544041567`*^9}, {3.494043968000828*^9, 3.494043968000828*^9}, {
   3.494044367665687*^9, 3.494044367665687*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050798897104`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["I", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", 
         FractionBox["\[ImaginaryI]", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}]]}], "]"}], "x"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["I", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        FractionBox["\[ImaginaryI]", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}]]}], "]"}], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579730125074`*^9, 3.479658002374728*^9}, 
   3.479658039448037*^9, 3.479661193793763*^9, {3.4796615158368387`*^9, 
   3.479661531599504*^9}, 3.4796867203243876`*^9, {3.4796869232261457`*^9, 
   3.4796869451176243`*^9}, 3.49400087334066*^9, {3.494001703554968*^9, 
   3.4940017521417475`*^9}, 3.4940439680048275`*^9, {3.4940444048098116`*^9, 
   3.494044421133745*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCot", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}], "/", "x_"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{"I", "/", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], "]"}], "/", "x"}], ",",
         "x"}], "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{"I", "/", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], "]"}], "/", "x"}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{3.494000873350661*^9, 3.4940016721911745`*^9, 
  3.4940439680078278`*^9, 3.4940444471312323`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.852, CRC 458, A&S 4.4.71", "Subsubsection",
 CellChangeTimes->{3.479686957936056*^9, 3.4940019256886735`*^9, 
  3.4940441342643375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "n"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.480705286316538*^9, {3.4941088512110004`*^9, 3.494108875297443*^9}, {
   3.4941089257323313`*^9, 3.494108953812381*^9}, {3.494109011158081*^9, 
   3.4941090265241084`*^9}, {3.4941099489353294`*^9, 3.494109954473339*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"ArcCot", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"m", "+", "n"}]], 
      RowBox[{"1", "+", 
       SuperscriptBox["a", "2"], "+", 
       RowBox[{"2", " ", "a", " ", "b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.47965797304255*^9, 3.4796580023847427`*^9}, {
   3.479658043163379*^9, 3.47965804398456*^9}, 3.479658468995696*^9, {
   3.479658610368981*^9, 3.479658625961402*^9}, {3.479661193843835*^9, 
   3.4796612201817074`*^9}, {3.47966139238933*^9, 3.479661423644272*^9}, {
   3.479661536146042*^9, 3.4796615416739902`*^9}, 3.4796617640337276`*^9, 
   3.4796618325222096`*^9, 3.4796668662303267`*^9, {3.4796867203344016`*^9, 
   3.4796867203344016`*^9}, {3.4796869701135664`*^9, 3.4796869707144303`*^9}, 
   3.480705289451045*^9, {3.4940008733676615`*^9, 3.494000873369662*^9}, {
   3.4940018654752293`*^9, 3.494001865993259*^9}, {3.494043968010828*^9, 
   3.494043968011828*^9}, {3.4940445594016533`*^9, 3.4940445598346786`*^9}, 
   3.4941139404565773`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"2", "*", "a", "*", "b", "*", 
            RowBox[{"x", "^", "n"}]}], "+", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "*", 
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "n"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494000873378662*^9, 3.4940008733806624`*^9}, 
   3.4940018465581474`*^9, {3.4940439680148287`*^9, 3.4940439680168285`*^9}, 
   3.494044553100293*^9, {3.494114149281345*^9, 3.4941141661293745`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, 
   3.494000868172364*^9, 3.4940439671797805`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.49283103988311*^9, 3.492831064713145*^9}, {3.4928318015941763`*^9, 
   3.492831805684182*^9}, {3.494096886328291*^9, 3.4940968902482967`*^9}, {
   3.494105805039649*^9, 3.4941058091112556`*^9}, {3.4941142026022387`*^9, 
   3.4941142026022387`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"ArcCot", "[", "x", "]"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928308514228463`*^9, 3.4928309174229383`*^9}, {
   3.4928311838033113`*^9, 3.4928311994833336`*^9}, 3.492831236813386*^9, {
   3.494096850808242*^9, 3.4940968754382763`*^9}, {3.494100136922842*^9, 
   3.494100137502843*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCot", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ArcCot", "[", "x", "]"}], "^", "n"}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928312031533384`*^9, 3.4928312054633417`*^9}, {
   3.4940968956183043`*^9, 3.494096916128333*^9}, {3.494100138262844*^9, 
   3.4941001388128448`*^9}, {3.494105814118865*^9, 3.4941058206084757`*^9}, 
   3.4941142043494415`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.492802747642827*^9, 
   3.492802751137233*^9}, 3.4928222777249804`*^9, 3.492825819138003*^9, 
   3.4940008731396484`*^9, 3.4940439679568253`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.49283103988311*^9, 3.492831064713145*^9}, {3.4928318015941763`*^9, 
   3.492831805684182*^9}, {3.4941058347889013`*^9, 3.4941058399993105`*^9}, {
   3.49411422615828*^9, 3.49411422615828*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["b", 
       RowBox[{"m", "+", "1"}]]]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "a"}], ")"}], "m"], " ", 
       SuperscriptBox[
        RowBox[{"ArcCot", "[", "x", "]"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928308514228463`*^9, 3.4928309174229383`*^9}, {
   3.4928311838033113`*^9, 3.4928311994833336`*^9}, 3.492831236813386*^9, {
   3.494000873149649*^9, 3.4940008731516495`*^9}, {3.494043967958825*^9, 
   3.4940439679598255`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"b", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"x", "-", "a"}], ")"}], "^", "m"}], "*", 
          RowBox[{
           RowBox[{"ArcCot", "[", "x", "]"}], "^", "n"}]}], ",", "x"}], "]"}],
        ",", "x", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.4928312031533384`*^9, 3.4928312054633417`*^9}, {
   3.49400087316065*^9, 3.49400087316265*^9}, {3.4940439679618254`*^9, 
   3.494043967963825*^9}, {3.49410585137173*^9, 3.494105864397753*^9}, {
   3.4941142279366827`*^9, 3.4941142434275103`*^9}, 3.517188492986435*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "n"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, 3.4802882652733135`*^9, 3.480288373839424*^9, {
   3.480299236238787*^9, 3.480299238211624*^9}, {3.4803010920372944`*^9, 
   3.480301103143264*^9}, {3.4928037993654737`*^9, 3.49280383115833*^9}, 
   3.4928257757543263`*^9, 3.49400087316965*^9, 3.4940439679648256`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcCot", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       FractionBox["\[ImaginaryI]", "z"]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       FractionBox["\[ImaginaryI]", "z"]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.48030057193943*^9, 3.4803006163232512`*^9, {3.494000873188651*^9, 
   3.494000873188651*^9}, {3.4940227517628565`*^9, 3.4940227517628565`*^9}, {
   3.4940439679688253`*^9, 3.4940439679688253`*^9}, {3.4940456719092855`*^9, 
   3.4940456719092855`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"n", "=", 
      RowBox[{
       RowBox[{"2", "\[And]", "d"}], "=", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", "c"}]}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055445578704`*^9, 3.49282853967961*^9, {3.4928286506197653`*^9, 
   3.4928286988398323`*^9}, {3.493751094490037*^9, 3.4937510948176374`*^9}, {
   3.49402290217846*^9, 3.494022907042738*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"b", " ", "x"}], "]"}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["I", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", 
         FractionBox["\[ImaginaryI]", 
          RowBox[{"b", " ", "x"}]]}], "]"}], 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["I", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        FractionBox["\[ImaginaryI]", 
         RowBox[{"b", " ", "x"}]]}], "]"}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928288741700783`*^9, 3.4928289166801376`*^9}, {
   3.492828963480203*^9, 3.4928290377203074`*^9}, 3.492829172840496*^9, 
   3.4940008732066526`*^9, {3.494022797217457*^9, 3.4940228313764105`*^9}, 
   3.494043967972826*^9, {3.494045700936946*^9, 3.494045715155759*^9}, {
   3.494045758955264*^9, 3.494045759309284*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCot", "[", 
      RowBox[{"b_.", "*", "x_"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{"I", "/", 
            RowBox[{"(", 
             RowBox[{"b", "*", "x"}], ")"}]}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{"I", "/", 
            RowBox[{"(", 
             RowBox[{"b", "*", "x"}], ")"}]}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"n", "==", "2"}], " ", "&&", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{"d", "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", "c"}]}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.4940008732176533`*^9, 3.4940227865048437`*^9, {3.494022913232092*^9, 
   3.494022916547282*^9}, 3.4940439679758263`*^9, 3.4940457990425572`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcCot", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       FractionBox["\[ImaginaryI]", "z"]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       FractionBox["\[ImaginaryI]", "z"]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.48030057193943*^9, 3.4803006163232512`*^9, {3.494000873237654*^9, 
   3.494000873237654*^9}, {3.494022960157776*^9, 3.494022960157776*^9}, {
   3.4940439679798265`*^9, 3.4940439679798265`*^9}, {3.494045674540436*^9, 
   3.494045674540436*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"n", "=", 
      RowBox[{
       RowBox[{"1", "\[And]", 
        RowBox[{
         RowBox[{"a", " ", "d"}], "-", 
         RowBox[{"b", " ", "c"}]}]}], "=", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055445578704`*^9, 3.49282853967961*^9, {3.4928286506197653`*^9, 
   3.4928286988398323`*^9}, {3.492828783319951*^9, 3.492828794439966*^9}, {
   3.4937511084520617`*^9, 3.4937511087484617`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["I", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", 
         FractionBox["\[ImaginaryI]", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}]]}], "]"}], 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["I", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        FractionBox["\[ImaginaryI]", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}]]}], "]"}], 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928288741700783`*^9, 3.4928289166801376`*^9}, {
   3.492828963480203*^9, 3.4928290377203074`*^9}, {3.4928290833603706`*^9, 
   3.4928291010103955`*^9}, 3.492829178180504*^9, 3.494000873256655*^9, {
   3.4940229747036085`*^9, 3.4940230032782426`*^9}, {3.4940230591534386`*^9, 
   3.494023069729043*^9}, 3.4940439679838266`*^9, {3.494045722982207*^9, 
   3.494045762537469*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ArcCot", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{"I", "/", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{"I", "/", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}]}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"n", "==", "1"}], " ", "&&", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"a", "*", "d"}], "-", 
        RowBox[{"b", "*", "c"}]}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{3.4940008732676563`*^9, 3.494023022748356*^9, 
  3.494043967986827*^9, 3.494045805443923*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"ArcCot", "[", 
     FractionBox["c", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616049603877*^9, {3.479616359880032*^9, 3.479616363935864*^9}, 
   3.47968672044456*^9, 3.4928223678463387`*^9, 3.4928258146763945`*^9, 
   3.494000873388663*^9, 3.494043968019829*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcCot", "[", "z", "]"}], "=", 
   RowBox[{"ArcTan", "[", 
    FractionBox["1", "z"], "]"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479664443126074*^9, 3.479664484795992*^9, {3.479686720494632*^9, 
   3.479686740223*^9}, {3.4940008734086637`*^9, 3.4940008734086637`*^9}, {
   3.4940009310099583`*^9, 3.4940009310099583`*^9}, {3.494043932644805*^9, 
   3.494043932644805*^9}, {3.494043968022829*^9, 3.494043968022829*^9}, {
   3.494044714314514*^9, 3.494044714314514*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807051268772755`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"ArcCot", "[", 
     FractionBox["c", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{"u", " ", 
       SuperscriptBox[
        RowBox[{"ArcTan", "[", 
         RowBox[{
          FractionBox["a", "c"], "+", 
          FractionBox[
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "c"]}], "]"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4928308514228463`*^9, 3.4928309174229383`*^9}, {
   3.4928311838033113`*^9, 3.4928311994833336`*^9}, 3.492831236813386*^9, {
   3.493250536928784*^9, 3.4932505561012177`*^9}, 3.4940008734266653`*^9, 
   3.4940009310229597`*^9, 3.4940439326528053`*^9, 3.494043968025829*^9, 
   3.4940447152675686`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", 
       RowBox[{"c_.", "/", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], "]"}], "^", "m_."}]}], 
    ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{
         RowBox[{"a", "/", "c"}], "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"x", "^", "n"}], "/", "c"}]}]}], "]"}], "^", "m"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "m"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{3.4940008734366655`*^9, 3.49400093103496*^9, 
  3.494043932660806*^9, 3.494043968028829*^9, 3.4940447168436584`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"f", "[", 
     RowBox[{"x", ",", 
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}], 
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.479616049603877*^9, {3.479616359880032*^9, 3.479616363935864*^9}, 
   3.47968672044456*^9, 3.4796940040278387`*^9, 3.492822371293945*^9, 
   3.492825811400389*^9, 3.494000873443666*^9, 3.494043968031829*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"f", "[", "z", "]"}], 
    RowBox[{"1", "+", 
     SuperscriptBox["z", "2"]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"f", "[", 
      RowBox[{"Cot", "[", 
       RowBox[{"ArcCot", "[", "z", "]"}], "]"}], "]"}]}], " ", 
    RowBox[{
     SuperscriptBox["ArcCot", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796941282865133`*^9, {3.4799455651493073`*^9, 3.4799455651493073`*^9}, {
   3.4940008734626675`*^9, 3.4940008734686675`*^9}, {3.494042612778313*^9, 
   3.494042613308344*^9}, {3.4940439680358295`*^9, 3.49404396803683*^9}, {
   3.494045957422616*^9, 3.494045957422616*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"r", "+", 
    RowBox[{"s", " ", "x"}], "+", 
    RowBox[{"t", " ", 
     SuperscriptBox["x", "2"]}]}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["s", "2"], "-", 
       RowBox[{"4", " ", "r", " ", "t"}]}], 
      RowBox[{"4", " ", "t"}]]}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"s", "+", 
          RowBox[{"2", " ", "t", " ", "x"}]}], ")"}], "2"], 
       RowBox[{
        SuperscriptBox["s", "2"], "-", 
        RowBox[{"4", " ", "r", " ", "t"}]}]]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796941282865133`*^9, {3.4799455651493073`*^9, 3.4799455651493073`*^9}, {
   3.492803054651366*^9, 3.492803093277034*^9}, 3.4928031261930914`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "+", 
    SuperscriptBox[
     RowBox[{"Cot", "[", "z", "]"}], "2"]}], "=", 
   SuperscriptBox[
    RowBox[{"Csc", "[", "z", "]"}], "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4796941282865133`*^9, {3.4799455651493073`*^9, 3.4799455651493073`*^9}, {
   3.492803054651366*^9, 3.492803093277034*^9}, {3.4928031381427126`*^9, 
   3.4928031451783247`*^9}, {3.4940008734866686`*^9, 
   3.4940008734866686`*^9}, {3.494000970399212*^9, 3.494000970399212*^9}, {
   3.4940426210097837`*^9, 3.494042621302801*^9}, {3.4940439680408297`*^9, 
   3.4940439680408297`*^9}, {3.4940459829720774`*^9, 3.494045983487107*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.480705133626981*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"f", "[", 
     RowBox[{"x", ",", 
      RowBox[{"ArcCot", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}], 
    RowBox[{"1", "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", "b"]}]}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           FractionBox["a", "b"]}], "+", 
          FractionBox[
           RowBox[{"Cot", "[", "x", "]"}], "b"]}], ",", "x"}], "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732428384`*^9, 3.479658002484886*^9}, {
   3.4796580646743107`*^9, 3.479658065695779*^9}, 3.4796611938939075`*^9, {
   3.4796867205046463`*^9, 3.479686740233014*^9}, 3.479694163016453*^9, 
   3.479694241058672*^9, {3.4940008735056696`*^9, 3.49400087350967*^9}, {
   3.4940427804809055`*^9, 3.4940427808229246`*^9}, {3.49404396804383*^9, 
   3.49404396804583*^9}, 3.4940460976356354`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"v_", "^", "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tmp", "=", 
         RowBox[{"InverseFunctionOfLinear", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[x,ArcCot[a+b*x]]/(1+(a+b*x)^2),x]\>\"", 
          ",", "\n", "\t\t   ", 
          "\"\<-Subst[Int[f[-a/b+Cot[x]/b,x],x],x,ArcCot[a+b*x]]/b\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"Discriminant", "[", 
                    RowBox[{"v", ",", "x"}], "]"}]}], "/", 
                  RowBox[{"(", 
                   RowBox[{"4", "*", 
                    RowBox[{"Coefficient", "[", 
                    RowBox[{"v", ",", "x", ",", "2"}], "]"}]}], ")"}]}], 
                 ")"}], "^", "n"}]}], "/", 
              RowBox[{"Coefficient", "[", 
               RowBox[{
                RowBox[{"tmp", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "1"}], 
               "]"}]}], ",", "\n", "\t", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"Regularize", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"SubstForInverseFunction", "[", 
                    RowBox[{"u", ",", "tmp", ",", "x"}], "]"}], "*", 
                    RowBox[{
                    RowBox[{"Csc", "[", "x", "]"}], "^", 
                    RowBox[{"(", 
                    RowBox[{"2", "*", 
                    RowBox[{"(", 
                    RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], ",", "x"}], 
                  "]"}], ",", "x"}], "]"}], ",", " ", "x", ",", " ", "tmp"}], 
              "]"}]}], "]"}], "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "tmp", "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"Head", "[", "tmp", "]"}], "===", "ArcCot"}], " ", "&&", 
         " ", 
         RowBox[{"ZeroQ", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Discriminant", "[", 
             RowBox[{"v", ",", "x"}], "]"}], "*", 
            RowBox[{
             RowBox[{"tmp", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"v", ",", "x"}], "]"}], "^", "2"}]}], "]"}]}]}]}], "]"}],
      " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"QuadraticQ", "[", 
       RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"n", "<", "0"}], " ", "&&", " ", 
      RowBox[{"NegQ", "[", 
       RowBox[{"Discriminant", "[", 
        RowBox[{"v", ",", "x"}], "]"}], "]"}], " ", "&&", " ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{"r_.", "*", 
          RowBox[{"f_", "^", "w_"}]}], " ", "/;", " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"f", ",", "x"}], "]"}]}]}], "]"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"v_", "^", "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tmp", "=", 
         RowBox[{"InverseFunctionOfLinear", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"Dist", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"Discriminant", "[", 
                 RowBox[{"v", ",", "x"}], "]"}]}], "/", 
               RowBox[{"(", 
                RowBox[{"4", "*", 
                 RowBox[{"Coefficient", "[", 
                  RowBox[{"v", ",", "x", ",", "2"}], "]"}]}], ")"}]}], ")"}], 
             "^", "n"}]}], "/", 
           RowBox[{"Coefficient", "[", 
            RowBox[{
             RowBox[{"tmp", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "1"}], "]"}]}], 
          ",", "\n", "\t", 
          RowBox[{"Subst", "[", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"Regularize", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"SubstForInverseFunction", "[", 
                  RowBox[{"u", ",", "tmp", ",", "x"}], "]"}], "*", 
                 RowBox[{
                  RowBox[{"Csc", "[", "x", "]"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"2", "*", 
                    RowBox[{"(", 
                    RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], ",", "x"}], 
               "]"}], ",", "x"}], "]"}], ",", " ", "x", ",", " ", "tmp"}], 
           "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "tmp", "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"Head", "[", "tmp", "]"}], "===", "ArcCot"}], " ", "&&", 
         " ", 
         RowBox[{"ZeroQ", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Discriminant", "[", 
             RowBox[{"v", ",", "x"}], "]"}], "*", 
            RowBox[{
             RowBox[{"tmp", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"v", ",", "x"}], "]"}], "^", "2"}]}], "]"}]}]}]}], "]"}],
      " ", "/;", "\n", 
     RowBox[{
      RowBox[{"QuadraticQ", "[", 
       RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"n", "<", "0"}], " ", "&&", " ", 
      RowBox[{"NegQ", "[", 
       RowBox[{"Discriminant", "[", 
        RowBox[{"v", ",", "x"}], "]"}], "]"}], " ", "&&", " ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{"r_.", "*", 
          RowBox[{"f_", "^", "w_"}]}], " ", "/;", " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"f", ",", "x"}], "]"}]}]}], "]"}]}]}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.4929838760355463`*^9, 3.492983880777954*^9}, {
   3.4929851720078225`*^9, 3.4929851812586384`*^9}, {3.4933231933196793`*^9, 
   3.4933231981696854`*^9}, {3.4933585331104183`*^9, 3.493358537618676*^9}, {
   3.4935714241857576`*^9, 3.493571428319765*^9}, {3.493588410361964*^9, 
   3.4935884965820847`*^9}, {3.4935885685121856`*^9, 
   3.4935886868223515`*^9}, {3.493588810472524*^9, 3.4935888483625774`*^9}, {
   3.494000873525671*^9, 3.4940008735436716`*^9}, {3.49400097247033*^9, 
   3.494000973146369*^9}, 3.4940427661900883`*^9, {3.4940439680508304`*^9, 
   3.4940439680648313`*^9}, {3.4940460578183584`*^9, 3.49404606397371*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"ArcCot", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["f", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, 3.4802882652733135`*^9, 3.480288373839424*^9, {
   3.480299236238787*^9, 3.480299238211624*^9}, {3.4803010920372944`*^9, 
   3.480301103143264*^9}, 3.492825791291954*^9, 3.4933227311790323`*^9, 
   3.494000874095703*^9, 3.494043968067831*^9, {3.4943699442153835`*^9, 
   3.4943699448053846`*^9}, {3.4953897384188356`*^9, 3.4953897386188354`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcCot", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       FractionBox["\[ImaginaryI]", "z"]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       FractionBox["\[ImaginaryI]", "z"]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.480300575514571*^9, 3.4803006163032227`*^9, {3.494000874114704*^9, 
   3.494000874114704*^9}, {3.494043137312315*^9, 3.494043137312315*^9}, {
   3.4940439680728316`*^9, 3.4940439680728316`*^9}, {3.4940931190130167`*^9, 
   3.4940931190130167`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070519364328*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["f", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["I", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", 
        FractionBox["\[ImaginaryI]", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["f", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}]]}]}]]}], "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["I", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       FractionBox["\[ImaginaryI]", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["f", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}]]}]}]]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.48029928226497*^9, 3.4802993300937443`*^9}, 
   3.4802995783907776`*^9, {3.480299703450605*^9, 3.480299715728259*^9}, 
   3.4940008741337056`*^9, {3.4940431424186068`*^9, 3.4940431752074823`*^9}, 
   3.494043968075832*^9, {3.494093225563166*^9, 3.494093247533197*^9}, 
   3.4940932865932517`*^9, {3.494369952845396*^9, 3.4943699610054073`*^9}, {
   3.4943700280355015`*^9, 3.494370028625502*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcCot", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}]}], "]"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"1", "-", 
          RowBox[{"I", "/", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"f", "^", 
               RowBox[{"(", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], ")"}]}]}], "]"}], 
        ",", "x"}], "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"1", "+", 
          RowBox[{"I", "/", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"f", "^", 
               RowBox[{"(", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], ")"}]}]}], "]"}], 
        ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", 
     "x"}], "]"}], " "}]}]], "Code",
 CellChangeTimes->{
  3.494000874144706*^9, {3.494043192703483*^9, 3.4940432117585726`*^9}, 
   3.494043968077832*^9, {3.494093251113202*^9, 3.4940932689632273`*^9}, {
   3.494369974275426*^9, 3.494369988735446*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"ArcCot", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["f", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, 3.4802882652733135`*^9, 3.480288373839424*^9, {
   3.480299236238787*^9, 3.480299238211624*^9}, {3.4803010920372944`*^9, 
   3.480301103143264*^9}, 3.492825791291954*^9, 3.4933227311790323`*^9, 
   3.494000874095703*^9, 3.494043968067831*^9, {3.4943699442153835`*^9, 
   3.4943699448053846`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ArcCot", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", 
       FractionBox["\[ImaginaryI]", "z"]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       FractionBox["\[ImaginaryI]", "z"]}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.480300575514571*^9, 3.4803006163032227`*^9, {3.494000874114704*^9, 
   3.494000874114704*^9}, {3.494043137312315*^9, 3.494043137312315*^9}, {
   3.494043968081832*^9, 3.494043968081832*^9}, {3.4940931220130215`*^9, 
   3.4940931220130215`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807055445578704`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ArcCot", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["f", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["I", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", 
        FractionBox["\[ImaginaryI]", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["f", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}]]}]}]]}], "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["I", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       FractionBox["\[ImaginaryI]", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["f", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}]]}]}]]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.480299282274984*^9, 3.4802993007415376`*^9}, {
   3.480299332717517*^9, 3.4802993335386972`*^9}, {3.48029943364264*^9, 
   3.480299444237875*^9}, 3.480299578400792*^9, 3.480299657564624*^9, {
   3.480299717951456*^9, 3.480299731180478*^9}, 3.4803000540747776`*^9, {
   3.480300090066531*^9, 3.480300092169555*^9}, 3.480300126899494*^9, 
   3.480705548133011*^9, 3.494000874183708*^9, {3.494043260041334*^9, 
   3.4940432729970756`*^9}, 3.4940439680858326`*^9, {3.494093283933248*^9, 
   3.4940932887032547`*^9}, {3.4943700809055753`*^9, 3.4943700939755936`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcCot", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"f_", "^", 
         RowBox[{"(", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}]}], "]"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{"I", "/", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"f", "^", 
                RowBox[{"(", 
                 RowBox[{"c", "+", 
                  RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], ")"}]}]}], "]"}]}], 
        ",", "x"}], "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"I", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{"I", "/", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"f", "^", 
                RowBox[{"(", 
                 RowBox[{"c", "+", 
                  RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], ")"}]}]}], "]"}]}], 
        ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{
  3.494000874193709*^9, {3.494043287958931*^9, 3.4940433030517945`*^9}, 
   3.4940439680888324`*^9, {3.4940932949832635`*^9, 3.494093309113283*^9}, {
   3.494370107745613*^9, 3.4943701274556403`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"v", " ", 
   RowBox[{"ArcCot", "[", "u", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160783652334`*^9, 3.4796867206047907`*^9, 3.492825781557537*^9, 
   3.4940008742017097`*^9, 3.494043968091833*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell["Rule: If u is free of inverse functions, then", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703531363038*^9, 
   3.4807035352686543`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"ArcCot", "[", "u", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"ArcCot", "[", "u", "]"}]}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"x", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "u"}]}], 
     RowBox[{"1", "+", 
      SuperscriptBox["u", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579734230976`*^9, 3.4796580026851745`*^9}, {
   3.479658101347043*^9, 3.479658102348483*^9}, {3.4796582237129965`*^9, 
   3.4796582279090304`*^9}, {3.4796611944647284`*^9, 3.4796612203719807`*^9}, 
   3.4796613933206687`*^9, {3.4796614761798143`*^9, 3.4796614777420607`*^9}, 
   3.4796618658000607`*^9, {3.4796619856624146`*^9, 3.4796619866938972`*^9}, {
   3.4796645712002354`*^9, 3.4796645805536847`*^9}, 3.4796646283424015`*^9, {
   3.4796867206148047`*^9, 3.4796867206148047`*^9}, {3.479687667676613*^9, 
   3.479687667926973*^9}, 3.480705232098576*^9, {3.49400087421271*^9, 
   3.49400087421371*^9}, {3.494022456770984*^9, 3.4940224580430565`*^9}, {
   3.494043968094833*^9, 3.494043968095833*^9}, {3.4940454892448378`*^9, 
   3.4940454897078643`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"ArcCot", "[", "u_", "]"}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"ArcCot", "[", "u", "]"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"Regularize", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{"u", ",", "x"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"u", "^", "2"}]}], ")"}]}]}], ",", "x"}], "]"}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"InverseFunctionFreeQ", "[", 
    RowBox[{"u", ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.49400087422171*^9, 3.4940008742237105`*^9}, {
  3.494022461285242*^9, 3.4940224616042604`*^9}, {3.494043968096833*^9, 
  3.494043968097833*^9}, {3.494045485577628*^9, 3.494045485943649*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], "\[And]"}]]],
 " u is free of inverse functions, then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.4807035587524223`*^9, 
   3.4807036202508526`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"ArcCot", "[", "u", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"ArcCot", "[", "u", "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], "u"}]}], 
      RowBox[{"1", "+", 
       SuperscriptBox["u", "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.479657973433112*^9, 3.4796580026951885`*^9}, {
   3.479658110380032*^9, 3.479658111381472*^9}, {3.47965823109361*^9, 
   3.4796582349191103`*^9}, {3.479658630027248*^9, 3.4796586331817837`*^9}, {
   3.4796611944747424`*^9, 3.479661220542226*^9}, 3.479661393330683*^9, {
   3.4796614834602833`*^9, 3.4796614855532928`*^9}, {3.4796616350883136`*^9, 
   3.4796616397950816`*^9}, 3.4796618737314653`*^9, 3.479662021574053*^9, 
   3.4796645886853776`*^9, {3.4796867206248193`*^9, 3.4796867206248193`*^9}, {
   3.479687711189181*^9, 3.479687711749987*^9}, 3.480705245037181*^9, {
   3.4940008742367115`*^9, 3.4940008742387114`*^9}, {3.49402252295177*^9, 
   3.494022523868822*^9}, {3.494043968100833*^9, 3.4940439681018333`*^9}, {
   3.494045527027999*^9, 3.49404552740102*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"ArcCot", "[", "u_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"ArcCot", "[", "u", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Regularize", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}]}], "*", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{"u", ",", "x"}], "]"}], "/", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"u", "^", "2"}]}], ")"}]}]}], ",", "x"}], "]"}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"m", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"InverseFunctionFreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", "\n", "\t", 
    RowBox[{"Not", "[", 
     RowBox[{"FunctionOfQ", "[", 
      RowBox[{
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ",", "u", ",", "x"}], "]"}], "]"}],
     " ", "&&", " ", "\n", "\t", 
    RowBox[{"FalseQ", "[", 
     RowBox[{"PowerVariableExpn", "[", 
      RowBox[{"u", ",", 
       RowBox[{"m", "+", "1"}], ",", "x"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494000874248712*^9, 3.4940008742507124`*^9}, {
  3.4940225275160303`*^9, 3.4940225278660507`*^9}, {3.494043968103833*^9, 
  3.4940439681058335`*^9}, {3.494045541979854*^9, 3.494045553957539*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection"],

Cell[TextData[{
 "Rule: If u is free of inverse functions, let  ",
 Cell[BoxData[
  RowBox[{"w", "=", 
   RowBox[{"\[Integral]", 
    RowBox[{"v", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]]],
 ", if w is free of inverse functions, then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, {
   3.4807032170510798`*^9, 3.480703219724925*^9}, {3.480703639939163*^9, 
   3.4807036911227617`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"v", " ", 
    RowBox[{"ArcCot", "[", "u", "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "w"}]}], " ", 
    RowBox[{"ArcCot", "[", "u", "]"}]}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"w", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], "u"}]}], 
     RowBox[{"1", "+", 
      SuperscriptBox["u", "2"]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579734531407`*^9, 3.479658002705203*^9}, {
   3.479658122026779*^9, 3.479658123318637*^9}, {3.4796582402567854`*^9, 
   3.479658243621624*^9}, {3.479658719025221*^9, 3.479658746965397*^9}, {
   3.4796611944747424`*^9, 3.4796612207224846`*^9}, 3.4796613933406973`*^9, {
   3.4796614896692114`*^9, 3.479661491792264*^9}, {3.479661879599904*^9, 
   3.479661922882141*^9}, 3.4796620342622976`*^9, {3.4796645916195965`*^9, 
   3.4796646241063104`*^9}, {3.4796867206348333`*^9, 
   3.4796867206348333`*^9}, {3.4796877839337826`*^9, 3.479687784174128*^9}, 
   3.480705260379242*^9, {3.494000874263713*^9, 3.4940008742657127`*^9}, {
   3.4940225319442835`*^9, 3.4940225328513355`*^9}, {3.4940439681088333`*^9, 
   3.4940439681098337`*^9}, {3.4940455750737467`*^9, 3.494045575531773*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"v_", "*", 
     RowBox[{"ArcCot", "[", "u_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"w", "=", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ShowSteps", "=", "False"}], ",", 
           RowBox[{"StepCounter", "=", "Null"}]}], "}"}], ",", " ", 
         RowBox[{"Int", "[", 
          RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}], "}"}], ",", "  ", "\n", 
     "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"w", "*", 
        RowBox[{"ArcCot", "[", "u", "]"}]}], " ", "+", "\n", "  ", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"w", "*", 
            RowBox[{
             RowBox[{"D", "[", 
              RowBox[{"u", ",", "x"}], "]"}], "/", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"u", "^", "2"}]}], ")"}]}]}], ",", "x"}], "]"}], ",", 
         "x"}], "]"}]}], " ", "/;", "\n", " ", 
      RowBox[{"InverseFunctionFreeQ", "[", 
       RowBox[{"w", ",", "x"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"InverseFunctionFreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", "\n", "\t", 
    RowBox[{"Not", "[", 
     RowBox[{"MatchQ", "[", 
      RowBox[{"v", ",", " ", 
       RowBox[{
        RowBox[{"x", "^", "m_."}], " ", "/;", " ", 
        RowBox[{"FreeQ", "[", 
         RowBox[{"m", ",", "x"}], "]"}]}]}], "]"}], "]"}], " ", "&&", "\n", 
    "\t", 
    RowBox[{"FalseQ", "[", 
     RowBox[{"FunctionOfLinear", "[", 
      RowBox[{
       RowBox[{"v", "*", 
        RowBox[{"ArcCot", "[", "u", "]"}]}], ",", "x"}], "]"}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494000874275714*^9, 3.4940008742797136`*^9}, {
   3.49402253624553*^9, 3.4940225365725484`*^9}, 3.494022633611099*^9, {
   3.494043968111834*^9, 3.494043968114834*^9}, 3.494045571698554*^9},
 Background->GrayLevel[0.85]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Inverse Cotangent Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 879, 19, 118, "Title"],
Cell[1449, 43, 212, 3, 495, "Subsubsection"],
Cell[1664, 48, 57, 0, 340, "Subsubsection"],
Cell[1724, 50, 613, 9, 340, "Subsubsection"],
Cell[2340, 61, 942, 25, 956, "Subsubtitle"],
Cell[3285, 88, 771, 11, 495, "Subsubsection"],
Cell[4059, 101, 881, 25, 1510, "Code"],
Cell[4943, 128, 89, 2, 495, "Subsubsection"],
Cell[5035, 132, 57, 0, 340, "Subsubsection"],
Cell[5095, 134, 827, 16, 365, "Subsubsection"],
Cell[5925, 152, 1738, 41, 929, "Subsubtitle"],
Cell[7666, 195, 771, 11, 495, "Subsubsection"],
Cell[8440, 208, 1388, 40, 1882, "Code"],
Cell[9831, 250, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[9912, 256, 938, 21, 80, "Title"],
Cell[10853, 279, 187, 2, 495, "Subsubsection"],
Cell[11043, 283, 1104, 20, 365, "Subsubsection"],
Cell[12150, 305, 1766, 45, 929, "Subsubtitle"],
Cell[13919, 352, 819, 11, 495, "Subsubsection"],
Cell[14741, 365, 2469, 59, 1882, "Code"],
Cell[17213, 426, 89, 2, 495, "Subsubsection"],
Cell[17305, 430, 187, 2, 340, "Subsubsection"],
Cell[17495, 434, 1203, 22, 365, "Subsubsection"],
Cell[18701, 458, 2706, 74, 1847, "Subsubtitle"],
Cell[21410, 534, 819, 11, 495, "Subsubsection"],
Cell[22232, 547, 3682, 97, 2246, "Code"],
Cell[25917, 646, 89, 2, 495, "Subsubsection"],
Cell[26009, 650, 125, 1, 340, "Subsubsection"],
Cell[26137, 653, 902, 17, 365, "Subsubsection"],
Cell[27042, 672, 1888, 50, 1187, "Subsubtitle"],
Cell[28933, 724, 771, 11, 495, "Subsubsection"],
Cell[29707, 737, 2054, 58, 1882, "Code"],
Cell[31764, 797, 89, 2, 495, "Subsubsection"],
Cell[31856, 801, 125, 1, 340, "Subsubsection"],
Cell[31984, 804, 1006, 19, 365, "Subsubsection"],
Cell[32993, 825, 1656, 42, 1031, "Subsubtitle"],
Cell[34652, 869, 771, 11, 1896, "Subsubsection"],
Cell[35426, 882, 2276, 55, 7225, "Code"],
Cell[37705, 939, 89, 2, 1896, "Subsubsection"],
Cell[37797, 943, 314, 5, 1300, "Subsubsection"],
Cell[38114, 950, 1304, 23, 1397, "Subsubsection"],
Cell[39421, 975, 1936, 50, 3564, "Subsubtitle"],
Cell[41360, 1027, 819, 11, 495, "Subsubsection"],
Cell[42182, 1040, 2663, 63, 1882, "Code"],
Cell[44848, 1105, 89, 2, 495, "Subsubsection"],
Cell[44940, 1109, 245, 3, 340, "Subsubsection"],
Cell[45188, 1114, 1371, 25, 365, "Subsubsection"],
Cell[46562, 1141, 2659, 71, 1814, "Subsubtitle"],
Cell[49224, 1214, 819, 11, 495, "Subsubsection"],
Cell[50046, 1227, 3668, 95, 2246, "Code"],
Cell[53717, 1324, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[53798, 1330, 1107, 24, 88, "Title"],
Cell[54908, 1356, 154, 2, 3715, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[55065, 1360, 1428, 29, 3830, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[56496, 1391, 2398, 61, 8926, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[58897, 1454, 771, 11, 3715, "Subsubsection"],
Cell[59671, 1467, 3793, 90, 14159, "Code"],
Cell[63467, 1559, 44, 1, 270, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[63548, 1565, 1210, 27, 88, "Title"],
Cell[64761, 1594, 154, 2, 3715, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[64918, 1598, 1484, 30, 3830, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[66405, 1630, 2547, 64, 8926, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[68955, 1696, 771, 11, 3715, "Subsubsection"],
Cell[69729, 1709, 4151, 96, 14159, "Code"],
Cell[73883, 1807, 89, 2, 3715, "Subsubsection"],
Cell[73975, 1811, 154, 2, 2546, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[74132, 1815, 1478, 30, 3830, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[75613, 1847, 2551, 65, 8926, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[78167, 1914, 771, 11, 3715, "Subsubsection"],
Cell[78941, 1927, 4133, 97, 14159, "Code"],
Cell[83077, 2026, 89, 2, 3715, "Subsubsection"],
Cell[83169, 2030, 61, 0, 2546, "Subsubsection"],
Cell[83233, 2032, 645, 19, 4141, "Subsubsection"],
Cell[83881, 2053, 1576, 31, 2736, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[85460, 2086, 1916, 50, 6964, "Subsubtitle"],
Cell[87379, 2138, 771, 11, 3715, "Subsubsection"],
Cell[88153, 2151, 3796, 87, 14159, "Code"],
Cell[91952, 2240, 89, 2, 3715, "Subsubsection"],
Cell[92044, 2244, 61, 0, 2546, "Subsubsection"],
Cell[92108, 2246, 723, 21, 4141, "Subsubsection"],
Cell[92834, 2269, 1699, 34, 2736, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[94536, 2305, 1862, 48, 6964, "Subsubtitle"],
Cell[96401, 2355, 771, 11, 3715, "Subsubsection"],
Cell[97175, 2368, 3805, 87, 14159, "Code"],
Cell[100983, 2457, 44, 1, 270, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[101064, 2463, 1161, 26, 91, "Title"],
Cell[102228, 2491, 188, 3, 93, "Subsubsection"],
Cell[102419, 2496, 1303, 23, 69, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[103725, 2521, 1413, 32, 181, "Subsubtitle"],
Cell[105141, 2555, 771, 11, 93, "Subsubsection"],
Cell[105915, 2568, 1921, 46, 282, "Code"],
Cell[107839, 2616, 89, 2, 93, "Subsubsection"],
Cell[107931, 2620, 107, 1, 65, "Subsubsection"],
Cell[108041, 2623, 1366, 27, 93, "Subsubsection"],
Cell[109410, 2652, 1500, 34, 179, "Subsubtitle"],
Cell[110913, 2688, 771, 11, 93, "Subsubsection"],
Cell[111687, 2701, 2092, 51, 282, "Code"],
Cell[113782, 2754, 44, 1, 8, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[113863, 2760, 1186, 27, 91, "Title"],
Cell[115052, 2789, 56, 0, 3715, "Subsubsection"],
Cell[115111, 2791, 945, 29, 4643, "Subsubsection"],
Cell[116059, 2822, 1419, 26, 3715, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[117481, 2850, 2516, 57, 7191, "Subsubtitle"],
Cell[120000, 2909, 771, 11, 3715, "Subsubsection"],
Cell[120774, 2922, 3025, 73, 14159, "Code"],
Cell[123802, 2997, 89, 2, 3715, "Subsubsection"],
Cell[123894, 3001, 56, 0, 2546, "Subsubsection"],
Cell[123953, 3003, 1165, 32, 4643, "Subsubsection"],
Cell[125121, 3037, 1465, 27, 3715, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[126589, 3066, 2532, 59, 7754, "Subsubtitle"],
Cell[129124, 3127, 771, 11, 3715, "Subsubsection"],
Cell[129898, 3140, 3139, 75, 14159, "Code"],
Cell[133040, 3217, 89, 2, 3715, "Subsubsection"],
Cell[133132, 3221, 56, 0, 2546, "Subsubsection"],
Cell[133191, 3223, 1117, 32, 4643, "Subsubsection"],
Cell[134311, 3257, 1469, 27, 3715, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[135783, 3286, 2493, 57, 7191, "Subsubtitle"],
Cell[138279, 3345, 771, 11, 3715, "Subsubsection"],
Cell[139053, 3358, 3184, 75, 14159, "Code"],
Cell[142240, 3435, 89, 2, 3715, "Subsubsection"],
Cell[142332, 3439, 56, 0, 2546, "Subsubsection"],
Cell[142391, 3441, 930, 25, 5200, "Subsubsection"],
Cell[143324, 3468, 1378, 26, 3715, "Subsubsection"],
Cell[144705, 3496, 1890, 51, 6984, "Subsubtitle"],
Cell[146598, 3549, 771, 11, 3715, "Subsubsection"],
Cell[147372, 3562, 2976, 77, 14159, "Code"],
Cell[150351, 3641, 89, 2, 3715, "Subsubsection"],
Cell[150443, 3645, 56, 0, 2546, "Subsubsection"],
Cell[150502, 3647, 1006, 26, 5200, "Subsubsection"],
Cell[151511, 3675, 1449, 27, 3715, "Subsubsection"],
Cell[152963, 3704, 1964, 51, 6984, "Subsubtitle"],
Cell[154930, 3757, 771, 11, 3715, "Subsubsection"],
Cell[155704, 3770, 2909, 76, 14159, "Code"],
Cell[158616, 3848, 89, 2, 3715, "Subsubsection"],
Cell[158708, 3852, 64, 0, 2546, "Subsubsection"],
Cell[158775, 3854, 1751, 48, 4393, "Subsubsection"],
Cell[160529, 3904, 2139, 43, 3715, "Subsubsection"],
Cell[162671, 3949, 2372, 51, 6887, "Subsubtitle"],
Cell[165046, 4002, 771, 11, 3715, "Subsubsection"],
Cell[165820, 4015, 2782, 71, 11360, "Code"],
Cell[168605, 4088, 89, 2, 3715, "Subsubsection"],
Cell[168697, 4092, 64, 0, 2546, "Subsubsection"],
Cell[168764, 4094, 1679, 42, 4393, "Subsubsection"],
Cell[170446, 4138, 2190, 44, 3715, "Subsubsection"],
Cell[172639, 4184, 2486, 53, 6887, "Subsubtitle"],
Cell[175128, 4239, 771, 11, 3715, "Subsubsection"],
Cell[175902, 4252, 2766, 70, 11360, "Code"],
Cell[178671, 4324, 44, 1, 270, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[178752, 4330, 1464, 31, 91, "Title"],
Cell[180219, 4363, 61, 0, 3715, "Subsubsection"],
Cell[180283, 4365, 689, 21, 4141, "Subsubsection"],
Cell[180975, 4388, 2128, 47, 4393, "Subsubsection"],
Cell[183106, 4437, 1949, 55, 8887, "Subsubtitle"],
Cell[185058, 4494, 771, 11, 3715, "Subsubsection"],
Cell[185832, 4507, 4598, 117, 14159, "Code"],
Cell[190433, 4626, 44, 1, 270, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[190514, 4632, 1220, 28, 91, "Title"],
Cell[191737, 4662, 57, 0, 1355, "Subsubsection"],
Cell[191797, 4664, 1931, 39, 1602, "Subsubsection"],
Cell[193731, 4705, 1819, 52, 2546, "Subsubtitle"],
Cell[195553, 4759, 771, 11, 1355, "Subsubsection"],
Cell[196327, 4772, 3585, 92, 5161, "Code"],
Cell[199915, 4866, 89, 2, 1355, "Subsubsection"],
Cell[200007, 4870, 57, 0, 929, "Subsubsection"],
Cell[200067, 4872, 1831, 38, 1602, "Subsubsection"],
Cell[201901, 4912, 1876, 52, 2546, "Subsubtitle"],
Cell[203780, 4966, 771, 11, 1355, "Subsubsection"],
Cell[204554, 4979, 3609, 93, 5161, "Code"],
Cell[208166, 5074, 44, 1, 99, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[208247, 5080, 1249, 29, 91, "Title"],
Cell[209499, 5111, 57, 0, 3715, "Subsubsection"],
Cell[209559, 5113, 1726, 35, 4393, "Subsubsection"],
Cell[211288, 5150, 2226, 59, 13687, "Subsubtitle"],
Cell[213517, 5211, 771, 11, 3715, "Subsubsection"],
Cell[214291, 5224, 3337, 89, 14159, "Code"],
Cell[217631, 5315, 89, 2, 3715, "Subsubsection"],
Cell[217723, 5319, 57, 0, 2546, "Subsubsection"],
Cell[217783, 5321, 1678, 35, 4393, "Subsubsection"],
Cell[219464, 5358, 2214, 59, 13687, "Subsubtitle"],
Cell[221681, 5419, 771, 11, 3715, "Subsubsection"],
Cell[222455, 5432, 3443, 89, 14159, "Code"],
Cell[225901, 5523, 44, 1, 270, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[225982, 5529, 1329, 30, 91, "Title"],
Cell[227314, 5561, 57, 0, 35, "Subsubsection"],
Cell[227374, 5563, 1148, 24, 35, "Subsubsection"],
Cell[228525, 5589, 3163, 76, 126, "Subsubtitle"],
Cell[231691, 5667, 771, 11, 35, "Subsubsection"],
Cell[232465, 5680, 2857, 80, 129, "Code"],
Cell[235325, 5762, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[235406, 5768, 1171, 26, 118, "Title"],
Cell[236580, 5796, 89, 2, 253, "Subsubsection"],
Cell[236672, 5800, 1161, 23, 253, "Subsubsection"],
Cell[237836, 5825, 2468, 70, 720, "Subsubtitle"],
Cell[240307, 5897, 771, 11, 253, "Subsubsection"],
Cell[241081, 5910, 3441, 88, 1147, "Code"],
Cell[244525, 6000, 89, 2, 253, "Subsubsection"],
Cell[244617, 6004, 943, 25, 442, "Subsubsection"],
Cell[245563, 6031, 1162, 24, 253, "Subsubsection"],
Cell[246728, 6057, 1499, 43, 662, "Subsubtitle"],
Cell[248230, 6102, 771, 11, 253, "Subsubsection"],
Cell[249004, 6115, 2480, 62, 771, "Code"],
Cell[251487, 6179, 89, 2, 253, "Subsubsection"],
Cell[251579, 6183, 1095, 21, 187, "Subsubsection"],
Cell[252677, 6206, 1440, 41, 590, "Subsubtitle"],
Cell[254120, 6249, 771, 11, 253, "Subsubsection"],
Cell[254894, 6262, 2123, 56, 961, "Code"],
Cell[257020, 6320, 89, 2, 2654, "Subsubsection"],
Cell[257112, 6324, 1501, 27, 2654, "Subsubsection"],
Cell[258616, 6353, 2642, 71, 6199, "Subsubtitle"],
Cell[261261, 6426, 771, 11, 2654, "Subsubsection"],
Cell[262035, 6439, 3896, 100, 12074, "Code"],
Cell[265934, 6541, 89, 2, 2654, "Subsubsection"],
Cell[266026, 6545, 1600, 30, 2654, "Subsubsection"],
Cell[267629, 6577, 3224, 86, 11932, "Subsubtitle"],
Cell[270856, 6665, 771, 11, 2654, "Subsubsection"],
Cell[271630, 6678, 4245, 112, 12074, "Code"],
Cell[275878, 6792, 89, 2, 2654, "Subsubsection"],
Cell[275970, 6796, 1204, 23, 2654, "Subsubsection"],
Cell[277177, 6821, 2408, 67, 9249, "Subsubtitle"],
Cell[279588, 6890, 771, 11, 2654, "Subsubsection"],
Cell[280362, 6903, 2797, 80, 12074, "Code"],
Cell[283162, 6985, 89, 2, 2654, "Subsubsection"],
Cell[283254, 6989, 1483, 29, 2958, "Subsubsection"],
Cell[284740, 7020, 2648, 73, 9400, "Subsubtitle"],
Cell[287391, 7095, 771, 11, 2654, "Subsubsection"],
Cell[288165, 7108, 3314, 95, 12074, "Code"],
Cell[291482, 7205, 89, 2, 2654, "Subsubsection"],
Cell[291574, 7209, 1585, 31, 2958, "Subsubsection"],
Cell[293162, 7242, 3402, 98, 14159, "Subsubtitle"],
Cell[296567, 7342, 771, 11, 2654, "Subsubsection"],
Cell[297341, 7355, 4842, 137, 14093, "Code"],
Cell[302186, 7494, 89, 2, 2654, "Subsubsection"],
Cell[302278, 7498, 57, 0, 1819, "Subsubsection"],
Cell[302338, 7500, 1936, 36, 253, "Subsubsection"],
Cell[304277, 7538, 2930, 70, 887, "Subsubtitle"],
Cell[307210, 7610, 771, 11, 253, "Subsubsection"],
Cell[307984, 7623, 4268, 103, 961, "Code"],
Cell[312255, 7728, 89, 2, 253, "Subsubsection"],
Cell[312347, 7732, 64, 0, 174, "Subsubsection"],
Cell[312414, 7734, 1835, 48, 270, "Subsubsection"],
Cell[314252, 7784, 1832, 36, 253, "Subsubsection"],
Cell[316087, 7822, 2338, 51, 449, "Subsubtitle"],
Cell[318428, 7875, 771, 11, 253, "Subsubsection"],
Cell[319202, 7888, 2663, 67, 771, "Code"],
Cell[321868, 7957, 89, 2, 253, "Subsubsection"],
Cell[321960, 7961, 1529, 39, 473, "Subsubsection"],
Cell[323492, 8002, 1889, 42, 282, "Subsubsection"],
Cell[325384, 8046, 2551, 60, 662, "Subsubtitle"],
Cell[327938, 8108, 771, 11, 253, "Subsubsection"],
Cell[328712, 8121, 3031, 80, 771, "Code"],
Cell[331746, 8203, 44, 1, 20, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[331827, 8209, 1253, 28, 80, "Title"],
Cell[333083, 8239, 229, 3, 253, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[333315, 8244, 1827, 33, 326, "Subsubsection",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[335145, 8279, 2383, 62, 510, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[337531, 8343, 771, 11, 253, "Subsubsection"],
Cell[338305, 8356, 3180, 84, 129, "Code"],
Cell[341488, 8442, 89, 2, 35, "Subsubsection"],
Cell[341580, 8446, 1708, 29, 35, "Subsubsection"],
Cell[343291, 8477, 2908, 71, 70, "Subsubtitle"],
Cell[346202, 8550, 771, 11, 35, "Subsubsection"],
Cell[346976, 8563, 3262, 82, 129, "Code"],
Cell[350241, 8647, 89, 2, 35, "Subsubsection"],
Cell[350333, 8651, 1698, 31, 35, "Subsubsection"],
Cell[352034, 8684, 3659, 96, 144, "Subsubtitle"],
Cell[355696, 8782, 771, 11, 35, "Subsubsection"],
Cell[356470, 8795, 4133, 112, 154, "Code"],
Cell[360606, 8909, 89, 2, 35, "Subsubsection"],
Cell[360698, 8913, 125, 1, 25, "Subsubsection"],
Cell[360826, 8916, 2423, 47, 35, "Subsubsection"],
Cell[363252, 8965, 3085, 75, 119, "Subsubtitle"],
Cell[366340, 9042, 771, 11, 35, "Subsubsection"],
Cell[367114, 9055, 4320, 104, 129, "Code"],
Cell[371437, 9161, 89, 2, 35, "Subsubsection"],
Cell[371529, 9165, 125, 1, 25, "Subsubsection"],
Cell[371657, 9168, 2312, 44, 35, "Subsubsection"],
Cell[373972, 9214, 3048, 76, 119, "Subsubtitle"],
Cell[377023, 9292, 771, 11, 35, "Subsubsection"],
Cell[377797, 9305, 4339, 105, 129, "Code"],
Cell[382139, 9412, 89, 2, 35, "Subsubsection"],
Cell[382231, 9416, 56, 0, 25, "Subsubsection"],
Cell[382290, 9418, 930, 25, 48, "Subsubsection"],
Cell[383223, 9445, 2170, 42, 35, "Subsubsection"],
Cell[385396, 9489, 2428, 63, 59, "Subsubtitle"],
Cell[387827, 9554, 771, 11, 35, "Subsubsection"],
Cell[388601, 9567, 3938, 95, 129, "Code"],
Cell[392542, 9664, 89, 2, 35, "Subsubsection"],
Cell[392634, 9668, 56, 0, 25, "Subsubsection"],
Cell[392693, 9670, 1006, 26, 48, "Subsubsection"],
Cell[393702, 9698, 2376, 45, 35, "Subsubsection"],
Cell[396081, 9745, 2250, 58, 59, "Subsubtitle"],
Cell[398334, 9805, 771, 11, 35, "Subsubsection"],
Cell[399108, 9818, 3570, 89, 129, "Code"],
Cell[402681, 9909, 89, 2, 35, "Subsubsection"],
Cell[402773, 9913, 125, 1, 25, "Subsubsection"],
Cell[402901, 9916, 2421, 46, 35, "Subsubsection"],
Cell[405325, 9964, 3511, 94, 130, "Subsubtitle"],
Cell[408839, 10060, 771, 11, 35, "Subsubsection"],
Cell[409613, 10073, 5218, 130, 154, "Code"],
Cell[414834, 10205, 89, 2, 35, "Subsubsection"],
Cell[414926, 10209, 125, 1, 25, "Subsubsection"],
Cell[415054, 10212, 2273, 44, 35, "Subsubsection"],
Cell[417330, 10258, 3439, 93, 127, "Subsubtitle"],
Cell[420772, 10353, 771, 11, 35, "Subsubsection"],
Cell[421546, 10366, 5302, 133, 154, "Code"],
Cell[426851, 10501, 89, 2, 35, "Subsubsection"],
Cell[426943, 10505, 64, 0, 25, "Subsubsection"],
Cell[427010, 10507, 2680, 74, 38, "Subsubsection"],
Cell[429693, 10583, 2318, 48, 35, "Subsubsection"],
Cell[432014, 10633, 2938, 66, 62, "Subsubtitle"],
Cell[434955, 10701, 771, 11, 35, "Subsubsection"],
Cell[435729, 10714, 4075, 99, 104, "Code"],
Cell[439807, 10815, 89, 2, 35, "Subsubsection"],
Cell[439899, 10819, 64, 0, 25, "Subsubsection"],
Cell[439966, 10821, 2168, 56, 39, "Subsubsection"],
Cell[442137, 10879, 2325, 48, 35, "Subsubsection"],
Cell[444465, 10929, 2663, 58, 61, "Subsubtitle"],
Cell[447131, 10989, 771, 11, 35, "Subsubsection"],
Cell[447905, 11002, 3161, 80, 104, "Code"],
Cell[451069, 11084, 89, 2, 35, "Subsubsection"],
Cell[451161, 11088, 1553, 39, 64, "Subsubsection"],
Cell[452717, 11129, 1988, 43, 39, "Subsubsection"],
Cell[454708, 11174, 2751, 64, 89, "Subsubtitle"],
Cell[457462, 11240, 771, 11, 35, "Subsubsection"],
Cell[458236, 11253, 3271, 84, 771, "Code"],
Cell[461510, 11339, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[461591, 11345, 1120, 23, 80, "Title"],
Cell[462714, 11370, 212, 3, 495, "Subsubsection"],
Cell[462929, 11375, 57, 0, 340, "Subsubsection"],
Cell[462989, 11377, 654, 9, 340, "Subsubsection"],
Cell[463646, 11388, 1531, 38, 956, "Subsubtitle"],
Cell[465180, 11428, 771, 11, 495, "Subsubsection"],
Cell[465954, 11441, 1285, 36, 1510, "Code"],
Cell[467242, 11479, 89, 2, 495, "Subsubsection"],
Cell[467334, 11483, 212, 3, 340, "Subsubsection"],
Cell[467549, 11488, 57, 0, 340, "Subsubsection"],
Cell[467609, 11490, 738, 14, 365, "Subsubsection"],
Cell[468350, 11506, 1674, 41, 916, "Subsubtitle"],
Cell[470027, 11549, 771, 11, 495, "Subsubsection"],
Cell[470801, 11562, 1522, 44, 1882, "Code"],
Cell[472326, 11608, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[472407, 11614, 899, 21, 80, "Title"],
Cell[473309, 11637, 56, 0, 495, "Subsubsection"],
Cell[473368, 11639, 856, 22, 551, "Subsubsection"],
Cell[474227, 11663, 613, 9, 340, "Subsubsection"],
Cell[474843, 11674, 1498, 43, 1187, "Subsubtitle"],
Cell[476344, 11719, 771, 11, 495, "Subsubsection"],
Cell[477118, 11732, 1476, 46, 1882, "Code"],
Cell[478597, 11780, 89, 2, 495, "Subsubsection"],
Cell[478689, 11784, 159, 2, 340, "Subsubsection"],
Cell[478851, 11788, 57, 0, 340, "Subsubsection"],
Cell[478911, 11790, 1133, 23, 365, "Subsubsection"],
Cell[480047, 11815, 1996, 52, 968, "Subsubtitle"],
Cell[482046, 11869, 771, 11, 495, "Subsubsection"],
Cell[482820, 11882, 2082, 62, 1882, "Code"],
Cell[484905, 11946, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[484986, 11952, 882, 20, 80, "Title"],
Cell[485871, 11974, 64, 0, 495, "Subsubsection"],
Cell[485938, 11976, 1082, 20, 365, "Subsubsection"],
Cell[487023, 11998, 1144, 29, 848, "Subsubtitle"],
Cell[488170, 12029, 771, 11, 495, "Subsubsection"],
Cell[488944, 12042, 1156, 33, 1510, "Code"],
Cell[490103, 12077, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[490184, 12083, 919, 21, 80, "Title"],
Cell[491106, 12106, 64, 0, 495, "Subsubsection"],
Cell[491173, 12108, 1107, 22, 365, "Subsubsection"],
Cell[492283, 12132, 1335, 35, 865, "Subsubtitle"],
Cell[493621, 12169, 771, 11, 495, "Subsubsection"],
Cell[494395, 12182, 1539, 44, 1510, "Code"],
Cell[495937, 12228, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[496018, 12234, 904, 22, 86, "Title"],
Cell[496925, 12258, 61, 0, 1896, "Subsubsection"],
Cell[496989, 12260, 763, 21, 2113, "Subsubsection"],
Cell[497755, 12283, 1123, 24, 1896, "Subsubsection"],
Cell[498881, 12309, 1736, 48, 4555, "Subsubtitle"],
Cell[500620, 12359, 771, 11, 1896, "Subsubsection"],
Cell[501394, 12372, 2006, 63, 7225, "Code"],
Cell[503403, 12437, 89, 2, 1896, "Subsubsection"],
Cell[503495, 12441, 61, 0, 1300, "Subsubsection"],
Cell[503559, 12443, 755, 21, 2113, "Subsubsection"],
Cell[504317, 12466, 1157, 25, 1397, "Subsubsection"],
Cell[505477, 12493, 1885, 52, 4555, "Subsubtitle"],
Cell[507365, 12547, 771, 11, 1896, "Subsubsection"],
Cell[508139, 12560, 2058, 65, 7225, "Code"],
Cell[510200, 12627, 44, 1, 138, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[510281, 12633, 943, 22, 83, "Title"],
Cell[511227, 12657, 61, 0, 1896, "Subsubsection"],
Cell[511291, 12659, 546, 13, 2113, "Subsubsection"],
Cell[511840, 12674, 613, 9, 1300, "Subsubsection"],
Cell[512456, 12685, 1295, 32, 3427, "Subsubtitle"],
Cell[513754, 12719, 771, 11, 1896, "Subsubsection"],
Cell[514528, 12732, 1036, 32, 5797, "Code"],
Cell[515567, 12766, 44, 1, 138, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[515648, 12772, 1092, 27, 93, "Title"],
Cell[516743, 12801, 64, 0, 3715, "Subsubsection"],
Cell[516810, 12803, 740, 21, 3957, "Subsubsection"],
Cell[517553, 12826, 864, 28, 4643, "Subsubsection"],
Cell[518420, 12856, 686, 16, 2736, "Subsubsection"],
Cell[519109, 12874, 611, 9, 2546, "Subsubsection"],
Cell[519723, 12885, 1492, 42, 6887, "Subsubtitle"],
Cell[521218, 12929, 771, 11, 3715, "Subsubsection"],
Cell[521992, 12942, 7365, 184, 50279, "Code"],
Cell[529360, 13128, 44, 1, 270, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[529441, 13134, 963, 22, 80, "Title"],
Cell[530407, 13158, 61, 0, 181, "Subsubsection"],
Cell[530471, 13160, 760, 21, 202, "Subsubsection"],
Cell[531234, 13183, 610, 9, 125, "Subsubsection"],
Cell[531847, 13194, 1625, 46, 326, "Subsubtitle"],
Cell[533475, 13242, 771, 11, 181, "Subsubsection"],
Cell[534249, 13255, 1820, 55, 687, "Code"],
Cell[536072, 13312, 44, 1, 15, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[536153, 13318, 948, 23, 80, "Title"],
Cell[537104, 13343, 61, 0, 181, "Subsubsection"],
Cell[537168, 13345, 756, 21, 202, "Subsubsection"],
Cell[537927, 13368, 782, 16, 134, "Subsubsection"],
Cell[538712, 13386, 1899, 51, 418, "Subtitle"],
Cell[540614, 13439, 771, 11, 181, "Subsubsection"],
Cell[541388, 13452, 2142, 64, 687, "Code"],
Cell[543533, 13518, 44, 1, 15, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[543614, 13524, 739, 16, 80, "Title"],
Cell[544356, 13542, 57, 0, 354, "Subsubsection"],
Cell[544416, 13544, 729, 10, 243, "Subsubsection"],
Cell[545148, 13556, 1379, 31, 628, "Subsubtitle"],
Cell[546530, 13589, 771, 11, 354, "Subsubsection"],
Cell[547304, 13602, 976, 27, 1345, "Code"],
Cell[548283, 13631, 89, 2, 354, "Subsubsection"],
Cell[548375, 13635, 57, 0, 243, "Subsubsection"],
Cell[548435, 13637, 856, 17, 261, "Subsubsection"],
Cell[549294, 13656, 1693, 42, 664, "Subsubtitle"],
Cell[550990, 13700, 771, 11, 354, "Subsubsection"],
Cell[551764, 13713, 2061, 59, 1873, "Code"],
Cell[553828, 13774, 89, 2, 354, "Subsubsection"],
Cell[553920, 13778, 57, 0, 243, "Subsubsection"],
Cell[553980, 13780, 920, 18, 299, "Subsubsection"],
Cell[554903, 13800, 1411, 31, 628, "Subsubtitle"],
Cell[556317, 13833, 771, 11, 354, "Subsubsection"],
Cell[557091, 13846, 2096, 59, 2396, "Code"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
