/********************************************************************************
*                                                                               *
*               Thread Barrier                                                  *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXBARRIER_H
#define FXBARRIER_H

#ifndef FXLOCKABLE_H
#include "FXLockable.h"
#endif
#ifndef FXTHREADEDOBJECT_H
#include "FXThreadedObject.h"
#endif
namespace FXEX {
class FXCondition;

/**
 * FXBarrier is object which can be used to synchronise the execution of
 * multiple threads, (say if it was a global variable).
 */
class FXAPI FXBarrier : public FXLockable, public FXThreadedObject {
  FXDECLARE(FXBarrier)

private:
  FXCondition *condition;   // the point of the barrier
  FXuint       reset;       // reset to origonal threshold value

private:
  // dummy copy constructor and operator= to prevent copying
  FXBarrier(const FXBarrier&);
  FXBarrier& operator=(const FXBarrier&);

public:
  /// create me a barrier :-)
  FXBarrier(FXuint threshold=0,FXbool resets=TRUE,FXObject *tgt=NULL,FXSelector sel=0);

  /**
   * A thread attempting to invoke the lock(), a Barrier will
   * be blocked until enough threads have invoked the lock(), at
   * which point the threshold is met, and the barrier is released.
   */
  void lock();

  /**
   * trylock()ing a barrier will test if the barrier is at its threshold
   * if you were to lock() then all barriers are released
   */
  FXbool trylock(FXuint ms);

  /// unlock all existing barriers
  void unlock();

  /**
   * set to new threshold - automatically unlocks any held locks
   * note: you _really should_ unlock all existing barriers, yourself first
   */
  void setThreshold(FXuint threshold,FXbool resets=TRUE,FXbool unlockAll=TRUE);

  // dtor
  ~FXBarrier();
  };

} // namespace FXEX
#endif // FXBARRIER_H
