AC_DEFUN(AC_FIND_FILE,
	[
		$3="NO"
		for i in $2; do
			for j in $1; do
				if test -r "$i/$j"; then
					$3=$i
					break 2
				else
					echo "tried $i" >&AC_FD_CC
				fi
			done
		done
	])

AC_DEFUN(AC_CHECK_IF_EXIST,
	[
		for j in $2; do
			if test "$j" = "$1"; then
				:
				$3
				break 1
			fi
		done
	])

AC_DEFUN(AC_FIND_WILDFILE,
	[
		$3="NO"
		for i in $2; do
			for j in $1; do
				if test -z "`ls -1 $i/$j 2> /dev/null`"; then
					echo "tried $i" >&AC_FD_CC
				else
					$3=$i
					break 2
				fi
			done
		done
	])

AC_DEFUN(PRINT_FOX_PROGRAM, [
cat > conftest.$ac_ext <<EOF
#include "confdefs.h"
#include "fx.h"
#include "fx3d.h"
int main() {
  FXApp app("Hello","Hello");
  return 0;
  }
EOF
])

AC_DEFUN(AC_CHECK_COMPILER_FLAG,
	[
		AC_REQUIRE([AC_CHECK_COMPILER_OPTIONS])
		AC_MSG_CHECKING(whether $CXX supports -$1)
		ac_flag_cache=`echo $1 | sed 'y%.=/+-%___p_%'`
		AC_CACHE_VAL(ac_cv_prog_cxx_$ac_flag_cache,
			[
				echo 'void f(){}' >conftest.cpp
				if test -z "`$CXX -$1 -c conftest.cpp 2>&1`"; then
					eval "ac_cv_prog_cxx_$ac_flag_cache=yes"
				else
					eval "ac_cv_prog_cxx_$ac_flag_cache=no"
				fi
				rm -f conftest*
			])
		if eval "test \"`echo '$ac_cv_prog_cxx_'$ac_flag_cache`\" = yes"; then
			AC_MSG_RESULT(yes)
			:
			$2
		else
			AC_MSG_RESULT(no)
			:
			$3
		fi
	])

AC_DEFUN(AC_CHECK_COMPILER_OPTIONS,
	[
		AC_REQUIRE([AC_PROG_CXX])
		AC_ARG_ENABLE(debug,
			[  --enable-debug          creates debugging code [default=no]],
			[
				if test $enableval = "no"; then
					ac_use_debug_code="no"
				else
					ac_use_debug_code="yes"
				fi
			],
			[
				ac_use_debug_code="no"
			])
		AC_ARG_ENABLE(strict,
			[  --enable-strict         compiles with strict compiler options (may not work!)],
			[
				if test $enableval = "no"; then
					ac_use_strict_options="no"
				else
					ac_use_strict_options="yes"
				fi
			],
			[
				ac_use_strict_options="no"
			])

		if test -z "$CXXFLAGS" || test "$CXXFLAGS" = "-g -O2"; then
			if test "$ac_use_debug_code" = "yes"; then
				if test $ac_cv_prog_cxx_g = yes; then
					CXXFLAGS="-g -DDEBUG"
				fi
			else
				if test "$GXX" = "yes"; then
					CXXFLAGS="-O2"
				else
					CXXFLAGS=""
				fi
			fi

			#AC_CHECK_COMPILER_FLAG(fno-exceptions,[CXXFLAGS="$CXXFLAGS -fno-exceptions"])
			AC_CHECK_COMPILER_FLAG(fno-rtti,[CXXFLAGS="$CXXFLAGS -fno-rtti"])
			#AC_CHECK_COMPILER_FLAG(fno-check-new,[CXXFLAGS="$CXXFLAGS -fno-check-new"])

			if test "$GXX" = "yes"; then

				CXXFLAGS="$CXXFLAGS"

				if test "$ac_use_debug_code" = "yes"; then
					CXXFLAGS="$CXXFLAGS -Wall -pedantic -W -Wpointer-arith -Wmissing-prototypes -Wwrite-strings"
					AC_CHECK_COMPILER_FLAG(Wno-long-long,[CXXFLAGS="$CXXFLAGS -Wno-long-long"])
					AC_CHECK_COMPILER_FLAG(fno-builtin,[CXXFLAGS="$CXXFLAGS -fno-builtin"])
				fi

				if test "$ac_use_strinct_options" = "yes"; then
					CXXFLAGS="$CXXFLAGS -Wcast-qual -Wbad-function-cast -Wshadow -Wcast-align -Woverloaded-virtual"
				fi

			fi
		fi

		AC_CHECK_COMPILER_FLAG(fexceptions,[USE_EXCEPTIONS="-fexceptions"],USE_EXCEPTIONS=)
		AC_SUBST(USE_EXCEPTIONS)
		AC_CHECK_COMPILER_FLAG(frtti,[USE_RTTI="-frtti"],USE_RTTI=)
		AC_SUBST(USE_RTTI)

		ifdef(AM_DEPENDENCIES, AC_REQIURE([AC_ADD_DEPENDENCIES]), [])
		])


AC_DEFUN(AC_ADD_DEPENDENCIES,
	[
		[A]M_DEPENDENCIES(CC)
		[A]M_DEPENDENCIES(CXX)
	])


AC_DEFUN(AC_FIND_XWIN, [
	AC_MSG_CHECKING(for X)
	AC_CACHE_VAL(ac_cv_have_x,
		[# One or both of the vars are not set, and there is no cached value.
			ac_x_includes=NO ac_x_libraries=NO
			AC_PATH_X_DIRECT
			AC_PATH_X_XMKMF
			if test "$ac_x_includes" = NO || test "$ac_x_libraries" = NO; then
				AC_MSG_ERROR([Can't find X includes. Please check your installation and add the correct paths!])
			else
				dnl Record where we found X for the cache.
				ac_cv_have_x="have_x=yes ac_x_includes=$ac_x_includes ac_x_libraries=$ac_x_libraries"
			fi
		])dnl

	eval "$ac_cv_have_x"

	if test "$have_x" != yes; then
		AC_MSG_RESULT($have_x)
		no_x=yes
	else
		dnl If each of the values was on the command line, it overrides each guess.
		test "x$x_includes" = xNONE && x_includes=$ac_x_includes
		test "x$x_libraries" = xNONE && x_libraries=$ac_x_libraries
		dnl Update the cache value to reflect the command line values.
		ac_cv_have_x="have_x=yes ac_x_includes=$x_includes ac_x_libraries=$x_libraries"
		AC_MSG_RESULT([libraries $x_libraries, headers $x_includes])
		X_LIBS="-lX11 -lXext"
	fi

	if test -z "$x_includes" || test "x$x_includes" = xNONE; then
		X_INCLUDES=""
		x_includes="."; dnl better than nothing :-
	else
		X_INCLUDES="-I$x_includes"
	fi

	if test -z "$x_libraries" || test "x$x_libraries" = xNONE; then
		X_LDFLAGS=""
		x_libraries="/usr/lib"; dnl better than nothing :-
	else
		X_LDFLAGS="-L$x_libraries"
	fi
	all_includes="$all_includes $X_INCLUDES"
	all_libraries="$all_libraries $X_LDFLAGS $X_LIBS"

	AC_SUBST(X_INCLUDES)
	AC_SUBST(X_LDFLAGS)
	AC_SUBST(X_LIBS)
	AC_SUBST(x_libraries)
	AC_SUBST(x_includes)
])


AC_DEFUN(AC_HAVE_OPENGL,
	[
		AC_REQUIRE_CPP()dnl
		AC_REQUIRE([AC_FIND_XWIN])

		test -z "$GL_INCLUDES" && GL_INCLUDES=
		test -z "$GL_LDFLAGS" && GL_LDFLAGS=
		test -z "$GL_LIBS"     && GL_LIBS=

		AC_ARG_WITH(opengl,[  --without-opengl        enable OpenGL ],opengl_test="no",opengl_test="yes")

		if test "x$opengl_test" = xno; then
			ac_cv_have_opengl=no
		else
			AC_MSG_CHECKING(for OpenGL)
			AC_CACHE_VAL(ac_cv_have_opengl,
				[
					dnl Find header files

					gl_incdirs="/usr/X11R6/include /usr/include /usr/X11R6/include/X11 /usr/local/include $x_includes"
					AC_FIND_FILE(GL/gl.h, $gl_incdirs, gl_incdir)

					dnl is our OpenGL Mesa3D ?

					if test "$gl_incdir" != "NO"; then
						gl_version="OpenGL `eval \"grep GL_VERSION_ $gl_incdir/GL/gl.h | tail -n 1 | sed -e s/#define\ *GL_VERSION_//\;y/_/./\;s/\ *1$//g\"`"
						if test -x "$gl_incdir/GL/osmesa.h" && test -x "$gl_incdir/GL/xmesa.h"; then
							gl_version="$gl_version (Mesa3D)"
						elif test "`eval \"grep glResizeBuffersMESA $gl_incdir/GL/gl.h 2> /dev/null\"`"; then
							gl_version="$gl_version (Mesa3D-XFree86)"
						fi

						gl_include="$gl_incdir"

						gl_libdirs="/usr/X11R6/lib /usr/lib /usr/local/lib $x_libraries"
						gl_libdir=""

						for dir in $gl_libdirs; do
							if test -z "`ls -1 $dir/libGL.* 2> /dev/null`"; then
								echo "tried $dir" >&AC_FD_CC
							else
								gl_libdir="$dir"
								break
							fi
						done

						if test -z "$gl_libdir"; then
							for dir in $gl_libdirs; do
								if test -z "`ls -1 $dir/libMesaGL.* 2> /dev/null`"; then
									echo "tried $dir" >&AC_FD_CC
								else
									gl_libdir="$dir"
									break
								fi
							done
							if test "$gl_libdir"; then
								gl_libs="-lMesaGL"
								gl_ldflags="$gl_libdir"
							fi
						else
							gl_libs="-lGL"
							gl_ldflags="$gl_libdir"
						fi

						if test "$gl_libs"; then
							AC_LANG_CPLUSPLUS
							c_save_ldflags="$LDFLAGS"
							c_save_cxxflags="$CXXFLAGS"

							CXXFLAGS="$CXXFLAGS $X_INCLUDES $GL_INCLUDES -I$gl_include"
							LDFLAGS="$LDFLAGS $X_LDFLAGS $all_libraries $GL_LDFLAGS $GL_LIBS -L$gl_ldflags $gl_libs"
							AC_TRY_LINK([],[],
								ac_cv_have_opengl="have_opengl=yes ac_gl_version=\"$gl_version\" ac_gl_include=$gl_include ac_gl_ldflags=$gl_ldflags ac_gl_libs=$gl_libs",
								ac_cv_have_opengl="have_opengl=no"
								)
							LDFLAGS="$ac_save_ldflags"
							CXXFLAGS="$ac_save_cxxflags"
						else
							ac_cv_have_opengl="have_opengl=no"
					fi
					else
						ac_cv_have_opengl="have_opengl=no"
				fi
				])
			eval "$ac_cv_have_opengl"
			if test "$have_opengl" = "no"; then
				AC_MSG_RESULT(no)
				GL_LDFLAGS=""
				GL_INCLUDES=""
				GL_LIBS=""
				gl_result="no"
				$2
			else
				AC_DEFINE(HAVE_OPENGL, 1, [Defines if you have OpenGL])
				if test "`echo \"$ac_gl_version\" | grep \\(Mesa3D\\)`"; then
					AC_DEFINE(HAVE_MESA, 1, [Defines if you have Mesa implementatnion of OpenGL api])
				fi
				GL_INCLUDES="$GL_INCLUDES -I$ac_gl_include"
				GL_LDFLAGS="$GL_LDFLAGS -L$ac_gl_ldflags"
				GL_LIBS="$GL_LIBS $ac_gl_libs"
				AC_MSG_RESULT($ac_gl_version)
				$1
			fi
		fi
		AC_SUBST(GL_INCLUDES)
		AC_SUBST(GL_LDFLAGS)
		AC_SUBST(GL_LIBS)
	])


AC_DEFUN(AC_HAVE_OPENGLU,
	[
		AC_REQUIRE([AC_HAVE_OPENGL])

		eval "$ac_cv_have_opengl"

		if test "$have_opengl" = "yes"; then

			AC_MSG_CHECKING(for OpenGL GLU)
			AC_CACHE_VAL(ac_cv_have_openglu,
				[
					dnl Find header files

					glu_incdirs="/usr/X11R6/include /usr/include /usr/X11R6/include/X11 /usr/local/include $x_includes"

					AC_FIND_FILE(GL/glu.h, $glu_incdirs, glu_incdir)

					dnl Test OpenGLU version

					if test "$glu_incdir"; then
						glu_version="OpenGLU `eval \"grep GLU_VERSION_ $glu_incdir/GL/glu.h | tail -n 1 | sed -e s/#define\ *GLU_VERSION_//\;y/_/./\;s/\ *1$//g\"`"

						glu_include="$glu_incdir"

						glu_libdirs="/usr/X11R6/lib /usr/lib /usr/local/lib $gl_libs $x_libraries"
						glu_libdir=""

						for dir in $glu_libdirs; do
							if test -z "`ls -1 $dir/libGLU.* 2> /dev/null`"; then
								echo "tried $dir" >&AC_FD_CC
							else
								glu_libdir="$dir"
								break
							fi
						done

						if test -z "$glu_libdir"; then

							for dir in $glu_libdirs; do
								if test -z "`ls -1 $dir/libMesaGLU.* 2> /dev/null`"; then
									echo "tried $dir" >&AC_FD_CC
								else
									glu_libdir="$dir"
									break
								fi
							done

							if test "$glu_libdir"; then
								glu_libs="-lMesaGLU"
								glu_ldflags="$glu_libdir"
							fi
						else
							glu_libs="-lGLU"
							glu_ldflags="$glu_libdir"
						fi

						if test "$glu_libs"; then
							AC_LANG_CPLUSPLUS
							ac_save_ldflags="$LDFLAGS"
							ac_save_cxxflags="$CXXFLAGS"

							CXXFLAGS="$CXXFLAGS $X_INCLUDES $GL_INCLUDES -I$glu_include"
							LDFLAGS="$LDFLAGS $X_LDFLAGS $all_libraries $GL_LDFLAGS $GL_LIBS -L$glu_ldflags $glu_libs"

							AC_TRY_LINK([],[],
								ac_cv_have_openglu="have_openglu=yes ac_glu_version=\"$glu_version\" ac_glu_include=$glu_include ac_glu_ldflags=$glu_ldflags ac_glu_libs=$glu_libs",
								ac_cv_have_openglu="have_openglu=no"
								)

							LDFLAGS="$ac_save_ldflags"
							CXXFLAGS="$ac_save_cxxflags"
						else
							ac_cv_have_openglu="have_openglu=no"
						fi
					else
						ac_cv_have_openglu="have_openglu=no"
					fi
				])

			eval "$ac_cv_have_openglu"

			if test "$have_openglu" = "no"; then
				AC_MSG_RESULT(no)
				glu_result="no"
				$2
			else
				AC_DEFINE(HAVE_OPENGLU, 1, [Defines if you have OpenGL GLU])
				if test "ac_glu_include" != "ac_gl_include"; then
					GL_INCLUDES="$GL_INCLUDES -I$ac_glu_include"
				fi
				GL_LDFLAGS="$GL_LDFLAGS -L$ac_glu_ldflags"
				GL_LIBS="$GL_LIBS $ac_glu_libs"
				AC_MSG_RESULT([$ac_glu_version])
				$1
			fi
		fi
	])


AC_DEFUN(AC_FIND_FOX,
	[
		AC_REQUIRE([AC_PROG_CXX])
		AC_REQUIRE([AC_FIND_XWIN])

		AC_MSG_CHECKING([for FOX lib])

		ac_fox_includes=""
		ac_fox_library=""

		fox_libraries=""
		fox_includes=""

		AC_ARG_WITH(fox,
			[  --with-fox=DIR          where the FOX library is installed. ],
			[
				ac_fox_includes="$withval/include/fox"
				ac_fox_library="$withval/lib"
			])

		AC_CACHE_VAL(ac_cv_have_fox,
			[
				dnl Try to guess FOX locations

				if test -z "$ac_fox_includes"; then
					fox_incdirs="/usr/X11R6/include/fox /usr/X11R6/include/X11/fox /usr/include/fox /usr/local/include/fox $x_includes"
				else
					fox_incdirs="$ac_fox_includes"
				fi

				AC_FIND_FILE(fx.h, $fox_incdirs, fox_incdir)

				if test "$fox_incdir" != "NO"; then
					if test -z "$ac_fox_library"; then
						fox_libdirs="/usr/X11R6/lib /usr/lib /usr/local/lib $x_libraries"
					else
						fox_libdirs="$ac_fox_library"
					fi

					fox_libdir=
					fox_libs=
					fox_gl_libs=

					for dir in $fox_libdirs; do
						if test -z "`ls -1 $dir/libFOX.* 2> /dev/null`"; then
							echo "tried $dir" >&AC_FD_CC;
						else
							fox_libdir="$dir"
							fox_libs="-lFOX"
							break
						fi
					done

					fox_compiled_with=

					if test "`grep XShmQueryVersion $dir/libFOX.*`"; then
						fox_compiled_with="SHM"
					fi

					fox_img_libs=""
					fox_png="no"
					fox_jpg="no"
					fox_gl="no"
					fox_opengl_libs=""
					fox_opengl_incs=""

					if test "`grep png_read_info $dir/libFOX.*`"; then
						if test "$fox_compiled_with"; then
							fox_compiled_with="$fox_compiled_with, PNG"
						else
							fox_compiled_with="PNG"
						fi
						AC_REQUIRE([AC_FIND_PNG])
						fox_img_libs="$PNGLIB"
						fox_png="yes"
					fi

					if test "`grep jpeg_read_header $dir/libFOX.*`"; then
						if test "$fox_compiled_with"; then
							fox_compiled_with="$fox_compiled_with, JPEG"
						else
							fox_compiled_with="JPEG"
						fi
						AC_REQUIRE([AC_FIND_JPEG])
						fox_img_libs="$fox_img_libs $JPEG_LIBS"
						fox_jpg="yes"
					fi


					if test "`grep glVertex $dir/libFOX*`"; then
						dnl We needed OpenGL libraries
						AC_REQUIRE([AC_HAVE_OPENGL])
						AC_REQUIRE([AC_HAVE_OPENGLU])

						eval "$ac_cv_have_opengl"
						if test "$have_opengl" = "no"; then
							AC_MSG_ERROR([FOX needs MesaGL or GL libraries. Please check your installation! ]);
						fi

						eval "$ac_cv_have_openglu"
						if test "$have_openglu" = "no"; then
							AC_MSG_ERROR([FOX needs MesaGLU or GLU libraries. Please check your installation! ]);
						fi

						fox_opengl_libs="$GL_LDFLAGS $GL_LIBS -DHAVE_OPENGL"
						fox_opengl_incs="$GL_INCLUDES"
						if test "$fox_compiled_with"; then
							fox_compiled_with="$fox_compiled_with and OpenGL"
						else
							fox_compiled_with="OpenGL"
						fi
						fox_gl="yes"
					fi

					AC_LANG_SAVE
					AC_LANG_CPLUSPLUS

					ac_cxxflags_safe="$CXXFLAGS"
					ac_ldflags_safe="$LDFLAGS"
					ac_libs_safe="$LIBS"

					CXXFLAGS="$CXXFLAGS -I$fox_incdir $fox_opengl_incs $X_INCLUDES"
					LDFLAGS="-L$fox_libdir $X_LDFLAGS $fox_img_libs $fox_opengl_libs"
					LIBS="$LIBS $X_LIBS $fox_libs"

					PRINT_FOX_PROGRAM

					if AC_TRY_EVAL(ac_link) && test -s conftest; then
						rm -f conftest*
						fox_version="FOX `eval \"ls -1 $fox_libdir/libFOX-*so* | head -n 1 | sed -e 's/.*libFOX-//;s/so\.//'\"`"
						if test "$fox_compiled_with"; then
							fox_version="$fox_version compiled with $fox_compiled_with support"
						fi
						ac_cv_have_fox="have_fox=yes ac_fox_version=\"$fox_version\""
						ac_cv_have_fox="$ac_cv_have_fox ac_fox_include=$fox_incdir ac_fox_ldflags=$fox_libdir ac_fox_lib=$fox_lib"
						ac_cv_have_fox="$ac_cv_have_fox ac_fox_gl=$fox_gl ac_fox_png=$fox_png ac_fox_jpg=$fox_jpg"
					else
						echo "configure: failed program was:" >&AC_FD_CC;
						cat conftest.$ac_ext >&AC_FD_CC
						rm -f conftest*
						ac_cv_have_fox="have_fox=no"
					fi

					AC_LANG_RESTORE

					CXXFLAGS="$ac_cxxflags_safe"
					LDFLAGS="$ac_ldflags_safe"
					LIBS="$ac_libs_safe"
				else
					ac_cv_have_fox="have_fox=no"
				fi
			])

		eval "$ac_cv_have_fox"

		if test "$have_fox" = "no"; then
			AC_MSG_RESULT(no)
			AC_MSG_ERROR([Please install FOX GUI library])
		else
			AC_MSG_RESULT([$ac_fox_version])
			FOX_INCLUDES="$FOX_INCLUDES -I$ac_fox_include"
			FOX_LIBS="-lFOX"
			FOX_LDFLAGS="$FOX_LDFLAGS -L$ac_fox_ldflags"

			if test "$ac_fox_png" = "yes"; then
				all_libraries="$all_libraries $PNGLIB"
			fi

			if test "$ac_fox_jpg" = "yes"; then
				all_libraries="$all_libraries $JPEGLIB"
			fi

			if test "$ac_fox_gl" = "yes"; then
				all_includes="$all_includes $GL_INCLUDES"
				all_libraries="$all_libraries $GL_LDFLAGS $GL_LIBS"
			fi

			all_includes="$all_includes $FOX_INCLUDES"
			all_libraries="$all_libraries $FOX_LDFLAGS $FOX_LIBS"
		fi

		AC_SUBST(FOX_INCLUDES)
		AC_SUBST(FOX_LDFLAGS)
		AC_SUBST(FOX_LIBS)
		CXXFLAGS="$CXXFLAGS $INCLUDES $all_includes"
		LDFLAGS="$LDFLAGS $all_libraries"
	])

AC_DEFUN(AC_FIND_JPEG,
	[
		AC_MSG_CHECKING([for JPEG lib])

		ac_jpeg_includes=""
		ac_jpeg_library=""

		jpeg_libraries=""
		jpeg_includes=""

		AC_ARG_WITH(jpeg,
			[  --with-jpeg=DIR         where the JPEG library is installed. ],
			[
				ac_jpeg_includes="$withval/include"
				ac_jpeg_library="$withval/lib"
			])

		AC_CACHE_VAL(ac_cv_have_jpeg,
			[
				dnl Try to guess JPEG locations

				if test -z "$ac_jpeg_includes"; then
					jpeg_incdirs="/usr/include /usr/local/include /opt/include"
				else
					jpeg_incdirs="$ac_jpeg_includes"
				fi

				AC_FIND_FILE(jpeglib.h, $jpeg_incdirs, jpeg_incdir)

				ac_cv_have_jpeg="have_jpeg=no"

				if test "$jpeg_incdir" != "NO"; then
					if test -z "$ac_jpeg_library"; then
						jpeg_libdirs="/usr/lib /usr/local/lib /opt/lib"
					else
						jpeg_libdirs="$ac_jpeg_library"
					fi

					jpeg_libdir=

					AC_FIND_WILDFILE("libjpeg.*", $jpeg_libdirs, jpeg_libdir)

					if test "$jpeg_libdir" != "NO"; then
						ac_save_LIBS="$LIBS"
						ac_save_CXXFLAGS="$CXXFLAGS"

						AC_LANG_CPLUSPLUS

						LIBS="$all_libraries -L$jpeg_libdir -ljpeg"
						CXXFLAGS="$CFLAGS $all_includes -I$jpeg_libdir"

						AC_TRY_LINK(
							[
	/* Override any gcc2 internal prototype to avoid an error.  */
	struct jpeg_decompress_struct;
	typedef struct jpeg_decompress_struct * j_decompress_ptr;
	typedef int size_t;
#ifdef __cplusplus
	extern "C" {
#endif
	void jpeg_CreateDecompress(j_decompress_ptr cinfo, int version, size_t structsize);
#ifdef __cplusplus
	}
#endif
	/* We use char because int might match the return type of a gcc2
		builtin and then its argument prototype would still apply.  */
							],
							[
	jpeg_CreateDecompress(0L, 0, 0);
							],
							ac_cv_have_jpeg="have_jpeg=yes ac_jpeg_include=$jpeg_incdir ac_jpeg_ldflags=$jpeg_libdir",
							ac_cv_have_jpeg="have_jpeg=no"
						)

						AC_LANG_RESTORE

						LIBS="$ac_save_LIBS"
						CXXFLAGS="$ac_save_CXXFLAGS"
					fi
				fi
			])dnl

		eval "$ac_cv_have_jpeg"

		if test "$have_jpeg" != "no"; then
			AC_DEFINE_UNQUOTED(HAVE_JPEGLIB, 1, [Defines if you have JPEG library])
			JPEG_INCLUDES="-I$ac_jpeg_include"
			JPEG_LIBS="-ljpeg"
			JPEG_LDFLAGS="-L$ac_jpeg_ldflags"
			have_jpeg="-ljpeg"
		fi
		AC_SUBST(JPEG_INCLUDES)
		AC_SUBST(JPEG_LIBS)
		AC_SUBST(JPEG_LDFLAGS)

		AC_MSG_RESULT($have_jpeg)
	])


AC_DEFUN(AC_FIND_ZLIB,
	[
		AC_MSG_CHECKING([for Z lib])

		ac_zlib_includes=""
		ac_zlib_library=""

		zlib_libraries=""
		zlib_includes=""

		AC_ARG_WITH(zlib,
			[  --with-zlib=DIR         where the ZLIB library is installed. ],
			[
				ac_zlib_includes="$withval/include"
				ac_zlib_library="$withval/lib"
			])

		AC_CACHE_VAL(ac_cv_have_zlib,
			[
				dnl Try to guess ZLIB locations

				if test -z "$ac_zlib_includes"; then
					zlib_incdirs="/usr/include /usr/local/include /opt/include"
				else
					zlib_incdirs="$ac_zlib_includes"
				fi

				AC_FIND_FILE(zlib.h, $zlib_incdirs, zlib_incdir)

				ac_cv_have_zlib="have_zlib=no"
				if test "$zlib_incdir" != "NO"; then
					if test -z "$ac_zlib_library"; then
						zlib_libdirs="/usr/lib /usr/local/lib /opt/lib"
					else
						zlib_libdirs="$ac_zlib_library"
					fi

					zlib_libdir=

					AC_FIND_WILDFILE("libz.*", $zlib_libdirs, zlib_libdir)

					if test "$zlib_libdir" != "NO"; then
						ac_save_LIBS="$LIBS"
						ac_save_CXXFLAGS="$CXXFLAGS"

						AC_LANG_CPLUSPLUS

						LIBS="$all_libraries -L$zlib_libdir -lz"
						CXXFLAGS="$CXXFLAGS $all_includes -I$zlib_libdir"

						AC_TRY_LINK(dnl
							[
#include<zlib.h>
							],
							[
	return (zlibVersion() == ZLIB_VERSION);
							],
							ac_cv_have_zlib="have_zlib=yes ac_zlib_include=$zlib_incdir ac_zlib_ldflags=$zlib_libdir",
							ac_cv_have_zlib="have_zlib=no"
						)

						AC_LANG_RESTORE

						LIBS="$ac_save_LIBS"
						CXXFLAGS="$ac_save_CXXFLAGS"
					fi
				fi
			])dnl

		eval "$ac_cv_have_zlib"

		if test "$have_zlib" != "no"; then
			AC_DEFINE_UNQUOTED(HAVE_LIBZ, 1, [Define if you have libz])
			ZLIB_INCLUDES="-I$ac_zlib_include"
			ZLIB_LIBS="-lz"
			ZLIB_LDFLAGS="-L$ac_zlib_ldflags"
			have_zlib="-lz"
		fi
		AC_SUBST(ZLIB_INCLUDES)
		AC_SUBST(ZLIB_LIBS)
		AC_SUBST(ZLIB_LDFLAGS)

		AC_MSG_RESULT($have_zlib)
	])


AC_DEFUN(AC_FIND_PNG,
	[
		AC_REQUIRE([AC_FIND_ZLIB])

		AC_MSG_CHECKING([for PNG lib])

		ac_png_includes=""
		ac_png_library=""

		png_libraries=""
		png_includes=""

		AC_ARG_WITH(png,
			[  --with-png=DIR          where the PNG library is installed. ],
			[
				ac_png_includes="$withval/include"
				ac_png_library="$withval/lib"
			])

		AC_CACHE_VAL(ac_cv_have_png,
			[
				dnl Try to guess PNG locations

				if test -z "$ac_png_includes"; then
					png_incdirs="/usr/X11R6/include /usr/X11R6/include/X11 /usr/include /usr/local/include $x_includes"
				else
					png_incdirs="$ac_png_includes"
				fi

				AC_FIND_FILE(png.h, $png_incdirs, png_incdir)

				ac_cv_have_png="have_png=no"

				if test "$png_incdir" != "NO"; then
					if test -z "$ac_png_library"; then
						png_libdirs="/usr/X11R6/lib /usr/lib /usr/local/lib $x_libraries"
					else
						png_libdirs="$ac_png_library"
					fi

					png_libdir=
					png_lib=

					AC_FIND_WILDFILE("libpng.*",$png_libdirs, png_libdir)

					if test "$png_libdir" != "NO"; then
						ac_save_LIBS="$LIBS"
						ac_save_CXXFLAGS="$CXXFLAGS"

						LIBS="$LIBS $all_libraries -L$png_libdir -lpng $ZLIB_LDFLAGS $ZLIB_LIBS -lm"
						CXXFLAGS="$CXXFLAGS $all_includes -I$png_incdir"

						AC_LANG_SAVE
						AC_LANG_CPLUSPLUS

						AC_TRY_LINK(dnl
							[
#include <png.h>
							],
							[
	png_structp png_ptr = png_create_read_struct(/* image ptr */PNG_LIBPNG_VER_STRING, 0, 0, 0 );
	return( png_ptr != 0 );
							],
							ac_cv_have_png="have_png=yes ac_png_include=$png_incdir ac_png_ldflags=$png_libdir"
							ac_cv_have_png="$ac_cv_have_png ac_png_lib=$png_lib",
							ac_cv_have_png="have_png=no"
							)
						AC_LANG_RESTORE

						LIBS="$ac_save_LIBS"
						CXXFLAGS="$ac_save_CXXFLAGS"
					fi
				fi
			])dnl

		eval "$ac_cv_have_png"

		if test "$have_png" != "no"; then
			AC_DEFINE_UNQUOTED(HAVE_LIBPNG, 1, [Define if you have libpng])
			PNG_INCLUDES="-I$ac_png_include"
			PNG_LIBS="-lpng -lm"
			PNG_LDFLAGS="-L$ac_png_ldflags"
			have_png="$PNG_LIBS"
   	fi
		AC_SUBST(PNG_INCLUDES)
		AC_SUBST(PNG_LDFLAGS)
		AC_SUBST(PNG_LIBS)

		AC_MSG_RESULT($have_png)
	])


AC_DEFUN(AC_FIND_TIFF,
	[
		AC_REQUIRE([AC_FIND_ZLIB])
		AC_REQUIRE([AC_FIND_JPEG])

		AC_MSG_CHECKING([for TIFF lib])

		ac_tiff_includes=""
		ac_tiff_library=""

		tiff_libraries=""
		tiff_includes=""

		AC_ARG_WITH(tiff,
			[  --with-tiff=DIR         where the TIFF library is installed. ],
			[
				ac_tiff_includes="$withval/include"
				ac_tiff_library="$withval/lib"
			])

		AC_CACHE_VAL(ac_cv_have_tiff,
			[
				dnl Try to guess TIFF locations

				if test -z "$ac_tiff_includes"; then
					tiff_incdirs="/usr/include /usr/local/include /opt/include"
				else
					tiff_incdirs="$ac_tiff_includes"
				fi

				AC_FIND_FILE(tiff.h, $tiff_incdirs, tiff_incdir)

				ac_cv_have_tiff="have_tiff=no"

				if test "$tiff_incdir" != "NO"; then
					if test -z "$ac_tiff_library"; then
						tiff_libdirs="/usr/lib /usr/local/lib /opt/lib"
					else
						tiff_libdirs="$ac_png_library"
					fi

					tiff_libdir=

					AC_FIND_WILDFILE("libtiff.*",$tiff_libdirs, tiff_libdir)

					if test "$tiff_libdir" != "NO"; then

						tiff_compiled_with=

						if test "`grep deflateInit $tiff_libdir/libtiff.*`"; then
							tiff_compiled_with="ZLIB"
							AC_REQUIRE([AC_FIND_ZLIB])
							tiff_img_libs="$ZLIB_LDFLAGS $ZLIB_LIBS"
							tiff_zlib="yes"
						fi

						if test "`grep jpeg_read_header $tiff_libdir/libtiff.*`"; then
							if test "$tiff_compiled_with"; then
								tiff_compiled_with="$tiff_compiled_with and JPEG"
							else
								tiff_compiled_with="JPEG"
							fi
							AC_REQUIRE([AC_FIND_JPEG])
							tiff_img_libs="$tiff_img_libs $JPEG_LDFLAGS $JPEG_LIBS"
							tiff_jpg="yes"
						fi

						if test "$tiff_compiled_with"; then
							tiff_compiled_with="compiled with $tiff_compiled_with support"
						fi
						AC_LANG_SAVE
						AC_LANG_CPLUSPLUS

						ac_cxxflags_safe="$CXXFLAGS"
						ac_libs_safe="$LIBS"

						CXXFLAGS="$CXXFLAGS -I$tiff_incdir"
						LIBS="$LIBS -L$tiff_libdir $tiff_img_libs -ltiff"


						AC_TRY_LINK(dnl
							[
#include <tiffio.h>
							],
							[
	return (TIFFOpen("", "r") == 0);
							],
							ac_cv_have_tiff="have_tiff=yes ac_tiff_include=$tiff_incdir ac_tiff_ldflags=$tiff_libdir ac_tiff_with=\"$tiff_compiled_with\"",
							ac_cv_have_tiff="have_tiff=no"
						)

						LIBS="$ac_libs_save"
						CXXFLAGS="$ac_cxxflags_save"
						AC_LANG_RESTORE
					fi
				fi
			])

		eval "$ac_cv_have_tiff"

		if test "$have_tiff" != "no"; then
			AC_DEFINE_UNQUOTED(HAVE_TIFFLIB, 1, [Defines if you have TIFF library])
			TIFF_INCLUDES="-I$ac_tiff_include"
			TIFF_LIBS="-ltiff"
			TIFF_LDFLAGS="-L$ac_tiff_ldflags"
			have_tiff="-ltiff $ac_tiff_with"
		fi
		AC_SUBST(TIFF_INCLUDES)
		AC_SUBST(TIFF_LIBS)
		AC_SUBST(TIFF_LDFLAGS)

		AC_MSG_RESULT([$have_tiff])
	])


AC_DEFUN(AC_CHECK_STL_SGI,
	[
		AC_MSG_CHECKING([if STL implementation is SGI like])
		AC_CACHE_VAL(ac_cv_stl_type_sgi,
			[
				AC_TRY_COMPILE(
					[
#include <string>
	using namespace std;
					],
					[
	string astring="Hallo Welt.";
	astring.erase(0, 6); // now astring is "Welt"
	return 0;
					],
						ac_cv_stl_type_sgi=yes,
						ac_cv_stl_type_sgi=no
					)
			])

		AC_MSG_RESULT($ac_cv_stl_type_sgi)

		if test "$ac_cv_stl_type_sgi" = "yes"; then
			AC_DEFINE_UNQUOTED(HAVE_SGI_STL, 1, [Define if you have a STL implementation by SGI])
		fi
	])


AC_DEFUN(AC_CHECK_STL_HP,
	[
		AC_MSG_CHECKING([if STL implementation is HP like])
		AC_CACHE_VAL(kde_cv_stl_type_hp,
			[
				AC_TRY_COMPILE(
					[
#include <string>
	using namespace std;
					],
					[
	string astring="Hello World";
	astring.remove(0, 6); // now astring is "World"
	return 0;
					],
						ac_cv_stl_type_hp=yes,
						ac_cv_stl_type_hp=no
					)
			])
		AC_MSG_RESULT($ac_cv_stl_type_hp)

		if test "$ac_cv_stl_type_hp" = "yes"; then
			AC_DEFINE_UNQUOTED(HAVE_HP_STL, 1, [Define if you have a STL implementation by SGI])
		fi
	])



AC_DEFUN(AC_CHECK_STL,
	[
		AC_LANG_SAVE
		AC_LANG_CPLUSPLUS
		AC_CHECK_STL_SGI

		if test "$ac_cv_stl_type_sgi" = "no"; then
			AC_CHECK_STL_HP

			if test "$ac_cv_stl_type_hp" = "no"; then
				AC_MSG_ERROR("no known STL type found")
			fi
		fi

		AC_LANG_RESTORE
	])


AC_DEFUN(AC_CHECK_FREETYPE2,
	[
		AC_REQUIRE([AC_PROG_CC])

		AC_MSG_CHECKING([for FreeType 2])

		ac_ft_config="freetype-config"

		ft_libraries=""
		ft_includes=""
		ft_version=""

		AC_ARG_WITH(ft2,
			[  --with-ft2=DIR          where the FreeType 2 library is installed. ],
			[
				ac_ft_config="$withval/bin/freetype-config"
			])

		AC_CACHE_VAL(ac_cv_have_ft,
			[
				ft_includes=`$ac_ft_config --cflags`
				ft_libraries=`$ac_ft_config --libs`
				ft_version=`$ac_ft_config --version | sed -e 's/://g'`

				if test -z "$ft_includes" -o -z "$ft_libraries"; then
					ac_cv_have_ft="have_ft=no"
				else
					if test $ft_version -lt 610; then
						ac_cv_have_ft="have_ft=no"
					else
						ac_cv_have_ft="have_ft=yes ac_ft_includes=$ft_includes ac_ft_libraries=\"$ft_libraries\""
					fi
				fi


			])

		eval "$ac_cv_have_ft"

		if test "$have_fox" = "no"; then
			AC_MSG_RESULT(no)
			AC_MSG_ERROR([Please install FreeType 2 library])
		else
			AC_MSG_RESULT(yes)
			FT_INCLUDES="$ac_ft_includes"
			FT_LIBS="$ac_ft_libraries"
			all_includes="$all_includes $FT_INCLUDES"
			all_libraries="$all_libraries $FT_LIBS"

		fi

		AC_SUBST(FT_INCLUDES)
		AC_SUBST(FT_LIBS)

		CXXFLAGS="$CXXFLAGS $INCLUDES $all_includes"
		LDFLAGS="$LDFLAGS $all_libraries"
	])

