//:Header-----------------------------*- mode: c++; tab-width: 2 -*-
//
// $Id: FXExThreadEvent.h,v 1.5 2001/03/02 11:41:11 dgehrige Exp $
//
// Copyright (C) 2000 by Daniel Gehriger.  All Rights Reserved
//
// This library is free software; you can redistribute it and/or 
// modify it under the terms of the GNU Library General Public   
// License as published by the Free Software Foundation; either  
// version 2 of the License, or (at your option) any later version.
//                                                                 
// This library is distributed in the hope that it will be useful, 
// but WITHOUT ANY WARRANTY; without even the implied warranty of  
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.                 
//                                                                  
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free       
// Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
// 
// $Id: FXExThreadEvent.h,v 1.5 2001/03/02 11:41:11 dgehrige Exp $
//
//------------------------------------------------------------------
//:Description
//
//  Interthread communication object
//
//------------------------------------------------------------------
//
// Usage: 
//
//  GUI_thread.h:
//  ============
//  
//  class MyGUI::FXWhatEver
//  {
//    // constructor
//    MyGUI(...);
//  
//    // message IDs
//    enum { 
//  	ID_THREAD_EVENT = FXWhatEver::ID_LAST,
//  	ID_LAST };
//  
//    // message handler
//    long onThreadEvent(FXObject*, FXSelector, void*);
//  
//    // thread event object
//   FXExThreadEvent m_threadEvent;
//  };
//  
//  GUI_thread.cpp:
//  ==============
//  
//  // message map
//  FXDEFMAP(MyGUI, FXWhatEver) = {
//    FXMAPFUNC(SEL_THREAD_EVENT, MyGUI::ID_THREAD_EVENT, MyGUI::onThreadEvent) 
//  };
//
//  // constructor 
//  MyGUI::MyGUI(...) 
//  { 
//    m_threadEvent.setTarget(this), 
//    m_threadEvent.setSelector(ID_THREAD_EVENT);  
//  }
//  
//  // message handler
//  long onThreadEvent(FXObject*, FXSelector, void*)
//  {
//    do something with the GUI
//  }
//  
//  Worker_thread.cpp:
//  =================
//  
//  int threadFunction(...)
//  {
//    FXExThreadEvent* pThreadEvent = (FXExThreadEvent*)(ptr);
//  
//    while (not_finished) {
//      // work hard
//      ...
//  
//      // wake up GUI
//      if (something_happened_and_the_GUI_needs_to_know_it) {
//        pThreadEvent.signal(); 
//      }
//    }
//  
//    ...
//  }
//  
//------------------------------------------------------------------

#if !defined(FXEXTHREADEVENT_INCLUDED)
#define FXEXTHREADEVENT_INCLUDED
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// define a convenient alias for the event selector
#define SEL_THREAD_EVENT  SEL_IO_READ

class FXExThreadEvent : public FXObject
{
  FXDECLARE(FXExThreadEvent);
public:
  // constructor
  FXExThreadEvent(FXObject* tgt = NULL, // notification target
                  FXSelector sel = 0,   // event selector
                  void* ptr = NULL      // user data passed to event handler
                  );

  // destructor
  ~FXExThreadEvent();

  // set the message target object
  void setTarget(FXObject *t) { m_pTarget = t; }

  // get the message target object
  FXObject* getTarget() const { return m_pTarget; }

  // set the message identifier
  void setSelector(FXSelector sel) { m_nSelector = sel; }

  // get the message identifier
  FXSelector getSelector() const { return m_nSelector; }

  // set user data
  void setData(void* ptr) { m_ptr = ptr; }

  // get user data
  void* getData() const { return m_ptr; }

  // signal the event
  void signal();

  enum 
  {
    ID_IO_READ = 0,
    ID_LAST
  };  
  
  // event handler
  long onIORead(FXObject*,  FXSelector, void*);

protected:
  FXExThreadEvent(const FXExThreadEvent&);
  FXExThreadEvent& operator=(const FXExThreadEvent&);

private:

  FXObject*       m_pTarget;
  FXSelector      m_nSelector;
  void*           m_ptr;
  
#ifndef WIN32
  FXInputHandle   m_fd[2];
#else
  FXInputHandle   m_hndlEvent;
#endif
};

#endif // FXEXTHREADEVENT_INCLUDE


