%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% File:         GENINSTR
% Description:  armv6 Generate instruction set
% Author:       Rainer Schpf
% Created:
% Modified:
% Mode:         Lisp
% Package:
% Status:       Open Source: BSD License
%
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are met:
%
%    * Redistributions of source code must retain the relevant copyright
%      notice, this list of conditions and the following disclaimer.
%    * Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
% AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNERS OR
% CONTRIBUTORS
% BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
% CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
% SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
% INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
% CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
% ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
% POSSIBILITY OF SUCH DAMAGE.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Revisions:
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
% Note form of DefOpcode, similar to DefAnyreg or DefCmacro
%      A trailing OpFailure will be appended unless (T is used)
%      Currently TESTs require arguments and explicit AND
 
% (DefOpCode OP (ARGS)
%   ( (tests) (actions))
%   ( (tests) (actions))
% ....
% )
 
(fluid '(lengthfunctions))
(setq lengthfunctions
    '((OP-reg-effa . lth-reg-effa)
      (OP-reg-effa-2 . lth-reg-effa-2)
      (OP-xmmreg-effa . lth-xmmreg-effa)
      (Op-imm      . lth-imm)
      (Op-imm-reg  . lth-imm-reg)
      (OP-reg-imm8 . lth-reg-imm8 )
      (OP-regn-imm8 . lth-regn-imm8 )
      (OP-regd-imm8 . lth-regd-imm8 )
      (OP-reg-shifter . lth-reg-shifter )
      (OP-regn-shifter . lth-regn-shifter )
      (OP-regd-shifter . lth-regd-shifter )
      (OP-mul3 . lth-mul3)
      (OP-mul4 . lth-mul4)
      (OP-ld-st . lth-ld-st)
      (OP-ld-st-misc . lth-ld-st-misc)
      (OP-ldm-stm . lth-ldm-stm)
      (OP-streg . lth-streg)
      (OP-clz . lth-clz)
      (OP-branch-imm . lth-branch-imm)
      (OP-branch-reg . lth-branch-reg)
      (Op-imm-effa . lth-imm-effa)
      (Op-imm8-effa. lth-imm8-effa)
      (Op-byte     . lth-byte)
      (OP-effa     . lth-effa)
      (OP2-effa    . lth2-effa)
      (Op-mul      . lth-mul)
      (Op-imul     . lth-imul)
      (Op-shift    . lth-shift)
      (Op-shiftimm . lth-shiftimm)
      (Op-dshift   . lth-dshift)
      (Op-dshiftimm. lth-dshiftimm)
      (Op-jump     . lth-jump)
      (Op-jump-effa .lth-jump-effa)
      (Op-jump-short.lth-jump-short) 
      (OP-jump     . lth-jump-long) 
      (Op-ret-n    . lth-ret-n)
      (Op-enter    . lth-enter)
      ))
 
(load strings compiler)
(DE SORT (LST FN)
   (PROG (TREE)
      (COND ((OR (NULL LST) (NULL (CDR LST))) (RETURN LST)))
      (SETQ TREE (LIST (CAR LST) NIL))
      (WHILE (PAIRP (SETQ LST (CDR LST))) (TREEADD (CAR LST) TREE FN))
      (RETURN (TREE2LIST TREE NIL))))
(DE TREE2LIST (TREE LST)
   (COND
      ((NULL TREE) LST)
      (T (TREE2LIST
	    (CADR TREE)
	    (CONS (CAR TREE) (TREE2LIST (CDDR TREE) LST)))) ))
(DE TREEADD (ITEM NODE FN)
   (COND
      ((APPLY FN (list ITEM (CAR NODE)))
	 (COND
	    ((CADR NODE) (TREEADD ITEM (CADR NODE) FN))
	    (T (RPLACA (CDR NODE) (LIST ITEM NIL)))) )
      ((CDDR NODE) (TREEADD ITEM (CDDR NODE) FN))
      (T (RPLACD (CDR NODE) (LIST ITEM NIL)))) )
 
% instructions are generated by a patterns:
%
% each instruction ID has a slot INSTRCASES where the different
% possible cases are collected. When all instructions are complete,
% the final defOpCode calls are generated from these slots
 
(fluid '(allInstrs!* allInstrPatterns!* formalParameters!* instr* instrlist!*))
(fluid '(Op-k Op-j-k Op-i-j-k Op-load Op-store Op-immediate-000-k
	 Op-immediate-001-k Op-branch-short Op-branch-long))
 
(setq formalParameters!* '(par1 par2 par3 par4))
 
(ds newInstruction (i) (when (not (memq i allInstrs!*)) (push i allInstrs!*)))

%
% Conditions bits 31:28 in ARMv6 opcodes
%

(deflist '((EQ 2#0000) (NE 2#0001) (CS 2#0010) (HS 2#0010) (CC 2#0011) (LO 2#0011)
	   (MI 2#0100) (PL 2#0101) (VS 2#0110) (VC 2#0111)
	   (HI 2#1000) (LS 2#1001) (GE 2#1010) (LT 2#1011)
	   (GT 2#1100) (LE 2#1101) (AL 2#1110))
  'condition-bits)

(fluid '(!*condition-codes))
(setq !*condition-codes!* '(EQ NE CS HS CC LO MI PL VS VC HI LS GE LT GT LE AL))

%
% To make live easier with variants of instructions, e.g. ADD{<cond>}{S}
% such an instruction name is coded as a list (ADD *cond* *set*) and all variants are
% generated automatically.
% mk-instr-name builds the instruction name out of this list and the actual condition/set bit.

(de mk-instr-name (pat conditioncode set!?)
    (prog (l)
	  (setq l (subla (list (cons '*cond* conditioncode)
			       (cons '*set* (if set!? "S" "")))
			 pat))
	  (setq l (foreach x on l join (explodec (car x))))
	  (return (intern (compress l)))))
    
(df instr (l)
     (prog (name namepattern operands format namelist)
       (setq instr* l)
       (setq l (subla '((/0 . 0)(/1 . 8#10) (/2 . 8#20)
			(/3 . 8#30) (/4 . 8#40) (/5 . 8#50)
			(/6 . 8#60) (/7 . 8#70)) l))
       (setq name (pop l))
       (setq namepattern (pop l))
       (setq operands (pop l))
       (setq format (pop l))
       (when (null (assoc format lengthfunctions))
	 (prin2t "unknown format : ") (print format))
       (if (or (idp namepattern) (null (cdr namepattern))) % simple name
	   (return (instr1 l name  operands format)))

       (if (memq '*set* namepattern)
	   (setq l2
		 `(
		   (,(subst "" '*set* namepattern) . ,(subst 0 '*setbit* l))
		   (,(subst 'S '*set* namepattern) . ,(subst 1 '*setbit* l))
		   )
		 )
	 (setq l2 (list (cons namepattern l))) )
		 
       (if (memq '*cond* namepattern)
	   (setq l2
		 (foreach cc in (cons "" !*condition-codes!*) conc
			  (sublis `((*cond* . ,cc) (*condbits* . ,(or (get cc 'condition-bits) (get 'AL 'condition-bits)))) l2))) )

       (foreach pp in l2 do
		(setq name
		      (intern (compress (foreach s in (car pp) join (explodec s)))))
		(instr1 (cdr pp) name operands format))
       
       )
       )

(de instr1 (l name operands format)
    (prog (gname code n pat)
    % instruction list
       (push (list l name operands format) instrlist*)
       (put name 'argno (length operands))
    % simple instruction
       (newInstruction name)
       (setq code (partial-mkquote l))
       (setq pat (mktest format code operands NIL))
       (push pat (get name 'INSTRCASES))
       (push (subla lengthfunctions pat) (get name 'LENGTHCASES))
       (setq gname name)
       (setq code (cdr l))
       (push (list name (car l) format operands) allInstrPatterns!*)
    %  (set format (cons (mkdisass code name operands) (eval format)))
       (return nil)
))

(de partial-mkquote (l)
    (if (not (or (memq '*condbits* l) (memq '*setbit* l)))
	(mkquote l)
      (cons 'list
	    (foreach x in l collect
		     (if (or (numberp x) (memq x '(*condbits* *setbit*)))
			 x
		       (mkquote x))))))

(de mktest(format code operands rev)
   (prog (params lhs rhs type val)
      (setq params formalParameters!*)
  loop (when (null operands) (go ready))
      (setq type (operandtype (pop operands)))
      (if   (not (eqcar type 'UNQUOTE))
	    (push (append type (list (car params))) lhs)
	    (progn
	       (setq params (cons(cadr type) (cdr params))) % artific. param
	       (setq type '(QUOTE))))
      (if   (not (eqcar type 'EQUAL))
	    (setq rhs(append rhs (list (pop params))))
	    (pop params))
      (go loop)
  ready
     (if (null lhs)(setq lhs '(T)))
     (when rev (setq rhs (reverse  rhs)))
     (return (if (cdr lhs)
		`((and .,(reversip lhs))(,format ,code ., rhs))
		`(,(car lhs)(,format ,code ., rhs))))
    ))
 
(de operandtype (op)
    (cond ((eqcar op 'QUOTE) (list 'EQUAL op))
	  ((eqcar op 'UNQUOTE) op)
	  ((eq op 'reg)'(REGP))
	  ((eq op 'evenreg)'(evenREGP)) 
	  ((eq op 'streg)'(STREGP))
	  ((eq op 'xmmreg)'(xmmregp))
	  ((eq op 'EAX) '(EAXP))
	  ((eq op 'imm) '(STDIMMEDIATEP))
	  ((eq op 'imm8-rotated) '(imm8-rotatedp))
	  ((eq op 'reg-shifter) '(reg-shifter-p))
	  ((eq op 'reg-offset8) '(reg-offset8-p))
	  ((eq op 'reg-offset12) '(reg-offset12-p))
	  ((eq op 'reglist) '(reglistp))
	  ((eq op 'offset26) '(offset26-p))
	  ((eq op 'writeback?) '(writeback-p))
	  ((eq op 'pm-reg-shifter) '(pm-reg-shifter-p))
	  ((eq op 'idloc) '(idlocp))
	  ((eq op '!n) '(SMALLIMMEDIATEP))
	  ((eq op 'effa) '(EFFAP))
	  ((eq op 'mem) '(MEMORYP))
	  ((eq op 'shortlabel) '(SHORTLABELP))
	  ((eq op 'adr) '(adrp))
	  ((eq op 'indadr) '(indirectadrp))
	  (t (prin2t "unknown operand type during instruction generation:")
	     (prin2t op)
	     (prin2t instr*)
	     (error  nil))))
 
 
(de parameterlist (n) (parameterlist1 n formalParameters!*))
 
(de parameterlist1(n l)
   (if (eqn n 0) nil (cons (car l)(parameterlist1(difference n 1)(cdr l)))))
 
% clear all instructions
(de clearInstructions ()
    (setq allInstrPatterns!* nil)
    (mapc allInstrs!* (function(lambda(u)(remprop u 'INSTRCASES))))
    (setq allInstrs!* nil))
 
% make a disassemble-record
(de mkdisass(code gname operands)
    `(,code (NAME . ,gname) (PAT . ,(dissasemblepat operands))))
 
(de dissasemblepat(o)  % special handling for quotes
   (cond ((atom o) o)
	 ((eqcar (car o) 'QUOTE) (cons (cadr (car o)) (cdr o)))
	 ((eqcar (car o) 'UNQUOTE) (cdr o))
	 (T (cons (car o) (dissasemblepat (cdr o))))))
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 1st application: generation of defOpcode file
%
 
(de collectInstructions (file)
   (when file (setq file (open file 'OUTPUT)) (wrs file))
   (setq allInstrs!* (sort allInstrs!* (function string-lessp)))
   (mapc allInstrs!* (function makeOneInstruction))
   (when file (wrs nil) (close file)))
nil)
 
(de makeOneInstruction (u)
  (prog(v vv)
  (setq v
   `(DefOpcode ,u %,(get u 'OpcodeVariants)
                  ,(parameterlist (get u 'ARGNO))
		 .,(reverse (get u 'INSTRCASES))))
  (eval (list 'pp v))
  
  (setq v
   `(DefOpLength ,u %,(get u 'OpcodeVariants)
                    ,(parameterlist (get u 'ARGNO))
		 .,(reverse (get u 'LENGTHCASES))))
  (eval (list 'pp v))
 (terpri)))
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 2nd  application: generation of conversion hexcode -> opcode
%

(de displayInstructions(f)
    (prog (u v)
       (setq u (sort instrlist* (function instrcmp)))
       (when f (setq v (wrs (open f 'OUTPUT))))
       (prin2t "   SUN 386 instructions sorted by opcode")
       (prin2t "   =====================================")
       (terpri)
       (mapc u (function printinstr))
       (terpri)(terpri)
       (prin2t "   SUN 386 instructions sorted by name")
       (prin2t "   ===================================")
       (setq u (sort instrlist* (function instrcmpalpha)))
       (mapc u (function printinstr))
       (terpri)

       (when f (wrs v))))
 
(de instrcmp (u v) 
     (or (lessp (caar u)(caar v))
	 (and (equal (caar u)(caar v)) (cdar u)(cdar v)
	      (lessp (cadar u)(cadar v)))))
 
(de instrcmpalpha(u v)
     (or (string-lessp (cadr u) (cadr v))
	 (and (equal (cadr u) (cadr v))
	      (instrcmp u v))))

(de printinstr (l)
	    (prininstrhex (caar l))
    (tab 3) (when (cdar l) (prininstrhex (cadar l))
			   (prin2 " /") (prin2 (land (lsh (cadar l)-3) 7)))
    (tab 10) (prin2 (cadr l))
    (tab 18) (when (caddr l) (prin2l (caddr l)))
    (tab 40) (print (cdddr l)))
 
(de prininstrhex (n)
   (if (eq n 'rex) (prin2 'rex)
      (prininstrhex1 (land 15 (lshift n -4))) (prininstrhex1 (land n 15))))
 
(de prininstrhex1 (n) (prin2 (getv [0 1 2 3 4 5 6 7 8 9 a b c d e f] n)))
 
	      


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%% the instructions in the sequence defined by the 
%% Programmer's Reference Manual
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
(clearInstructions)

(instr AND (AND *cond* *set*)  (reg reg reg-shifter)     OP-reg-shifter  *condbits* 2#0000000 *setbit*)
(instr AND (AND *cond* *set*)  (reg reg imm8-rotated)    OP-reg-imm8     *condbits* 2#0010000 *setbit*)
(instr EOR (EOR *cond* *set*)  (reg reg reg-shifter)     OP-reg-shifter  *condbits* 2#0000001 *setbit*)
(instr EOR (EOR *cond* *set*)  (reg reg imm8-rotated)    OP-reg-imm8     *condbits* 2#0010001 *setbit*)
(instr SUB (SUB *cond* *set*)  (reg reg reg-shifter)     OP-reg-shifter  *condbits* 2#0000010 *setbit*)
(instr SUB (SUB *cond* *set*)  (reg reg imm8-rotated)    OP-reg-imm8     *condbits* 2#0010010 *setbit*)
(instr RSB (RSB *cond* *set*)  (reg reg reg-shifter)     OP-reg-shifter  *condbits* 2#0000011 *setbit*)
(instr RSB (RSB *cond* *set*)  (reg reg imm8-rotated)    OP-reg-imm8     *condbits* 2#0010011 *setbit*)
(instr ADD (ADD *cond* *set*)  (reg reg reg-shifter)     OP-reg-shifter  *condbits* 2#0000100 *setbit*)
(instr ADD (ADD *cond* *set*)  (reg reg imm8-rotated)    OP-reg-imm8     *condbits* 2#0010100 *setbit*)
(instr ADC (ADC *cond* *set*)  (reg reg reg-shifter)     OP-reg-shifter  *condbits* 2#0000101 *setbit*)
(instr ADC (ADC *cond* *set*)  (reg reg imm8-rotated)    OP-reg-imm8     *condbits* 2#0010101 *setbit*)
(instr SBC (SBC *cond* *set*)  (reg reg reg-shifter)     OP-reg-shifter  *condbits* 2#0000110 *setbit*)
(instr SBC (SBC *cond* *set*)  (reg reg imm8-rotated)    OP-reg-imm8     *condbits* 2#0010110 *setbit*)
(instr RSC (RSC *cond* *set*)  (reg reg reg-shifter)     OP-reg-shifter  *condbits* 2#0000111 *setbit*)
(instr RSC (RSC *cond* *set*)  (reg reg imm8-rotated)    OP-reg-imm8     *condbits* 2#0010111 *setbit*)
(instr TST (TST *cond*)  (reg reg-shifter)         OP-regn-shifter *condbits* 2#0001000 1)
(instr TST (TST *cond*)  (reg imm8-rotated)        OP-regn-imm8    *condbits* 2#0011000 1)
(instr TEQ (TEQ *cond*)  (reg reg-shifter)         OP-regn-shifter *condbits* 2#0001001 1)
(instr TEQ (TEQ *cond*)  (reg imm8-rotated)        OP-regn-imm8    *condbits* 2#0011001 1)
(instr CMP (CMP *cond*)  (reg reg-shifter)         OP-regn-shifter *condbits* 2#0001010 1)
(instr CMP (CMP *cond*)  (reg imm8-rotated)        OP-regn-imm8    *condbits* 2#0011010 1)
(instr CMN (CMN *cond*)  (reg reg-shifter)         OP-regn-shifter *condbits* 2#0001011 1)
(instr CMN (CMN *cond*)  (reg imm8-rotated)        OP-regn-imm8    *condbits* 2#0011011 1)
(instr ORR (ORR *cond* *set*)  (reg reg reg-shifter)     OP-reg-shifter  *condbits* 2#0001100 *setbit*)
(instr ORR (ORR *cond* *set*)  (reg reg imm8-rotated)    OP-reg-imm8     *condbits* 2#0011100 *setbit*)
(instr MOV (MOV *cond* *set*)  (reg reg-shifter)         OP-regd-shifter *condbits* 2#0001101 *setbit*)
(instr MOV (MOV *cond* *set*)  (reg imm8-rotated)        OP-regd-imm8    *condbits* 2#0011101 *setbit*)
(instr BIC (BIC *cond* *set*)  (reg reg reg-shifter)     OP-reg-shifter  *condbits* 2#0001110 *setbit*)
(instr BIC (BIC *cond* *set*)  (reg reg imm8-rotated)    OP-reg-imm8     *condbits* 2#0011110 *setbit*)
(instr MVN (MVN *cond* *set*)  (reg reg-shifter)         OP-regd-shifter *condbits* 2#0001111 *setbit*)
(instr MVN (MVN *cond* *set*)  (reg imm8-rotated)        OP-regd-imm8    *condbits* 2#0011111 *setbit*)

(commentoutcode
(instr SDIV (SDIV *cond*)  (reg reg reg)             OP-mul3      *condbits* 2#0111000 1 2#0001 2#1111)
(instr UDIV (UDIV *cond*)  (reg reg reg)         OP-mul3      *condbits* 2#0111001 1 2#1001 2#1111)
)

(instr MUL (MUL *cond* *set*)  (reg reg reg)             OP-mul3      *condbits* 2#0000000 *setbit* 2#1001 2#0000)
(instr MLA (MLA *cond* *set*)  (reg reg reg reg)         OP-mul4      *condbits* 2#0000001 *setbit* 2#1001)
(instr UMULL (UMULL *cond* *set*)(reg reg reg reg)       OP-mul4      *condbits* 2#0000100 *setbit* 2#1001)
(instr UMLAL (UMLAL *cond* *set*)(reg reg reg reg)       OP-mul4      *condbits* 2#0000101 *setbit* 2#1001)
(instr SMULL (SMULL *cond* *set*)(reg reg reg reg)       OP-mul4      *condbits* 2#0000110 *setbit* 2#1001)
(instr SMLAL (SMLAL *cond* *set*)(reg reg reg reg)       OP-mul4      *condbits* 2#0000111 *setbit* 2#1001)
(instr UMAAL (UMAAL *cond*)(reg reg reg reg)             OP-mul4      *condbits* 2#0000010 0 2#1001)

(instr SMULTT (SMULTT *cond*) (reg reg reg)              OP-mul3      *condbits* 2#0001011 0 2#1110 2#0000)
(instr SMULTB (SMULTB *cond*) (reg reg reg)              OP-mul3      *condbits* 2#0001011 0 2#1010 2#0000)
(instr SMULBT (SMULBT *cond*) (reg reg reg)           OP-mul3      *condbits*   2#0001011 0 2#1100 2#0000)
(instr SMULBB (SMULBB *cond*) (reg reg reg)           OP-mul3      *condbits*   2#0001011 0 2#1000 2#0000)
(instr SMLATT (SMLATT *cond*) (reg reg reg reg)       OP-mul4      *condbits*   2#0001000 0 2#1110)
(instr SMLATB (SMLATB *cond*) (reg reg reg reg)       OP-mul4      *condbits*   2#0001000 0 2#1010)
(instr SMLABT (SMLABT *cond*) (reg reg reg reg)       OP-mul4      *condbits*   2#0001000 0 2#1100)
(instr SMLABB (SMLABB *cond*) (reg reg reg reg)       OP-mul4      *condbits*   2#0001000 0 2#1000)
(instr SMLALTT (SMLALTT *cond*) (reg reg reg reg)       OP-mul4     *condbits*   2#0001010 0 2#1110)
(instr SMLALTB (SMLALTB *cond*) (reg reg reg reg)       OP-mul4     *condbits*   2#0001010 0 2#1010)
(instr SMLALBT (SMLALBT *cond*) (reg reg reg reg)       OP-mul4     *condbits*   2#0001010 0 2#1100)
(instr SMLALBB (SMLALBB *cond*) (reg reg reg reg)       OP-mul4     *condbits*   2#0001010 0 2#1000)

(instr SMULWT (SMULWT *cond*) (reg reg reg reg)        OP-mul4     *condbits*   2#0001001 0 2#1110)
(instr SMULWB (SMULWB *cond*) (reg reg reg reg)        OP-mul4     *condbits*   2#0001001 0 2#1110)
(instr SMLAWT (SMLAWT *cond*) (reg reg reg reg)        OP-mul4     *condbits*   2#0001001 0 2#1100)
(instr SMLAWB (SMLAWB *cond*) (reg reg reg reg)        OP-mul4     *condbits*   2#0001001 0 2#1000)

(instr SMMUL (SMMUL *cond*) (reg reg reg)            OP-mul3      *condbits*   2#0111010 1 2#0001 2#1111)
(instr SMMULR (SMMULR *cond*) (reg reg reg)            OP-mul3     *condbits*   2#0111010 1 2#0011 2#1111)
(instr SMMLA (SMMLA *cond*) (reg reg reg reg)       OP-mul4       *condbits*   2#0111010 1 2#0001)
(instr SMMLAR (SMMLAR *cond*) (reg reg reg reg)       OP-mul4      *condbits*   2#0111010 1 2#0011)
(instr SMMLS (SMMLS *cond*) (reg reg reg reg)       OP-mul4       *condbits*   2#0111010 1 2#1101)
(instr SMMLSR (SMMLSR *cond*) (reg reg reg reg)       OP-mul4      *condbits*   2#0111010 1 2#1101)

(instr SMUAD (SMUAD *cond*) (reg reg reg)            OP-mul3      *condbits*   2#0111000 0 2#0001 2#1111)
(instr SMUADX (SMUADX *cond*) (reg reg reg)            OP-mul3     *condbits*   2#0111000 0 2#0011 2#1111)
(instr SMUSD (SMUSD *cond*) (reg reg reg)            OP-mul3      *condbits*   2#0111000 0 2#0101 2#1111)
(instr SMUSDX (SMUSDX *cond*)  (reg reg reg)            OP-mul3    *condbits*   2#0111000 0 2#0111 2#1111)
(instr SMLAD (SMLAD *cond*) (reg reg reg reg)        OP-mul4      *condbits*   2#0111000 0 2#0001)
(instr SMLADX (SMLADX *cond*) (reg reg reg reg)        OP-mul4     *condbits*   2#0111000 0 2#0011)
(instr SMLSD (SMLSD *cond*) (reg reg reg reg)        OP-mul4      *condbits*   2#0111000 0 2#0101)
(instr SMLSDX (SMLSDX *cond*) (reg reg reg reg)        OP-mul4     *condbits*   2#0111000 0 2#0111)
(instr SMLALD (SMLALD *cond*) (reg reg reg reg)        OP-mul4     *condbits*   2#0111010 0 2#0001)
(instr SMLALDX (SMLALDX *cond*) (reg reg reg reg)        OP-mul4    *condbits*   2#0111010 0 2#0011)
(instr SMLSLD (SMLSLD *cond*) (reg reg reg reg)        OP-mul4     *condbits*   2#0111010 0 2#0101)
(instr SMLSLDX (SMLSLDX *cond*)  (reg reg reg reg)        OP-mul4   *condbits*   2#0111010 0 2#0111)

%ADD16
%ADDSUBX
%SUBADDX
%SUB16
%ADD8
%SUB8

%SXTAB16
%SXTAB
%SXTAH
%SXTB16
%SXTB
%SXTH
%UXTAB16
%UXTAB
%UXTAH
%UXTB16
%UXTB
%UXTH

(instr CLZ (CLZ *cond*) (reg reg)     OP-clz *condbits* 2#0001011 0 2#0001)

%USAD8
%USADA8

%(instr (MRS *cond*) (reg streg)   OP-streg *condbits* 2#0001000 0 2#0000)
%(instr (MSR *cond*) (streg imm8-rotated) OP-MSR *condbits* 2#0011001 0  ... ) 
%(instr (MSR *cond*) (streg reg)      OP-MSR *condbits* 2#0001001 0 2#0000)

% LDR Rd,[Rn,+/-#imm12]
(instr LDR (LDR *cond*) (reg reg-offset12)   OP-ld-st *condbits* 2#0100000 1)
(instr STR (STR *cond*) (reg reg-offset12)   OP-ld-st *condbits* 2#0100000 0)
% LDR Rd,[Rn,+/-Rm]
% LDR Rd,[Rn,+/-Rm, LSL #nnn]
(instr LDR (LDR *cond*) (reg pm-reg-shifter) OP-ld-st *condbits* 2#0110000 1)
(instr STR (STR *cond*) (reg pm-reg-shifter) OP-ld-st *condbits* 2#0110000 0)

% special case for loading a lisp id into a register: (LDR Rn (idloc x))
% a variant of pm-reg-shifter wher ethe argument is handled in a special way
%(instr LDR (LDR *cond*) (reg idloc) OP-ldr-id *condbits* 2#0110000 1)

(instr LDRB (LDR *cond* B) (reg reg-offset12)  OP-ld-st *condbits* 2#0100010 1)
(instr STRB (STR *cond* B) (reg reg-offset12)  OP-ld-st *condbits* 2#0100010 0)
(instr LDRB (LDR *cond* B) (reg pm-reg-shifter)  OP-ld-st *condbits* 2#0110010 1)
(instr STRB (STR *cond* B) (reg pm-reg-shifter)  OP-ld-st *condbits* 2#0110010 0)

(instr LDRH (LDR *cond* H) (reg reg-offset8)  OP-ld-st-misc *condbits* 2#0000010 1 2#1011)
(instr STRH (STR *cond* H) (reg reg-offset8)  OP-ld-st-misc *condbits* 2#0000010 0 2#1011)
(instr LDRH (LDR *cond* H) (reg pm-reg-shifter)  OP-ld-st-misc *condbits* 2#0000000 1 2#1011)
(instr STRH (STR *cond* H) (reg pm-reg-shifter)  OP-ld-st-misc *condbits* 2#0000000 0 2#1011)

(instr LDRSB (LDR *cond* SB) (reg reg-offset8)  OP-ld-st-misc *condbits* 2#0000010 1 2#1101)
(instr LDRSB (LDR *cond* SB) (reg pm-reg-shifter)  OP-ld-st-misc *condbits* 2#0000000 1 2#1101)
(instr LDRSH (LDR *cond* SH) (reg reg-offset8)  OP-ld-st-misc *condbits* 2#0000010 1 2#1111)
(instr LDRSH (LDR *cond* SH) (reg pm-reg-shifter)  OP-ld-st-misc *condbits* 2#0000000 1 2#1111)


% omit LDR(B)T / STR(B)T -- only priviledged mode

(instr LDRD (LDR *cond* D)   (evenreg reg-offset8)  OP-ld-st-misc *condbits* 2#0000010 0 2#1101)
(instr STRD (STR *cond* D)   (evenreg reg-offset8)  OP-ld-st-misc *condbits* 2#0000010 0 2#1111)
(instr LDRD (LDR *cond* D)   (evenreg pm-reg-shifter)  OP-ld-st-misc *condbits* 2#0000000 0 2#1101)
(instr STRD (STR *cond* D)   (evenreg pm-reg-shifter)  OP-ld-st-misc *condbits* 2#0000000 0 2#1111)


(instr LDM (LDM *cond*)     (reg reglist writeback?)       OP-ldm-stm *condbits* 2#1000100 1)
(instr STM (STM *cond*)     (reg reglist writeback?)       OP-ldm-stm *condbits* 2#1000100 0)
(instr LDM (LDM *cond* IA)  (reg reglist writeback?)                  OP-ldm-stm *condbits* 2#1000100 1)
(instr STM (STM *cond* IA)  (reg reglist writeback?)                  OP-ldm-stm *condbits* 2#1000100 0)
(instr LDM (LDM *cond* IB)  (reg reglist writeback?)                  OP-ldm-stm *condbits* 2#1001100 1)
(instr STM (STM *cond* IB)  (reg reglist writeback?)                  OP-ldm-stm *condbits* 2#1001100 0)       
(instr LDM (LDM *cond* DA)  (reg reglist writeback?)                  OP-ldm-stm *condbits* 2#1000000 1)
(instr STM (STM *cond* DA)  (reg reglist writeback?)                  OP-ldm-stm *condbits* 2#1000000 0)       
(instr LDM (LDM *cond* DB)  (reg reglist writeback?)                  OP-ldm-stm *condbits* 2#1001000 1)
(instr STM (STM *cond* DB)  (reg reglist writeback?)                  OP-ldm-stm *condbits* 2#1001000 0)       

% alternative names
(instr LDM (LDM *cond* FD)  (reg reglist writeback?)                  OP-ldm-stm *condbits* 2#1000100 1)
(instr STM (STM *cond* EA)  (reg reglist writeback?)                  OP-ldm-stm *condbits* 2#1000100 0)
(instr LDM (LDM *cond* ED)  (reg reglist writeback?)                  OP-ldm-stm *condbits* 2#1001100 1)
(instr STM (STM *cond* FA)  (reg reglist writeback?)                  OP-ldm-stm *condbits* 2#1001100 0)       
(instr LDM (LDM *cond* FA)  (reg reglist writeback?)                  OP-ldm-stm *condbits* 2#1000000 1)
(instr STM (STM *cond* ED)  (reg reglist writeback?)                  OP-ldm-stm *condbits* 2#1000000 0)       
(instr LDM (LDM *cond* EA)  (reg reglist writeback?)                  OP-ldm-stm *condbits* 2#1001000 1)
(instr STM (STM *cond* FD)  (reg reglist writeback?)                  OP-ldm-stm *condbits* 2#1001000 0)       


(instr B (B *cond*) (offset26)         OP-branch-imm *condbits* 2#1010)
(instr BL (BL *cond*) (offset26)         OP-branch-imm *condbits* 2#1011)

(instr BLX (BLX) (offset26)            OP-branch-imm 2#1111 2#1010)
(instr BLX (BLX *cond*) (reg)            OP-branch-reg *condbits* 2#0001001 0 2#0011)
(instr BX (BX *cond*) (reg)            OP-branch-reg *condbits* 2#0001001 0 2#0001)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% now we generate the CXINSTR dataset
(off usermode) (de linelength (x) 1000)
(reload chars)
(pp nil)
(collectInstructions "armv6-inst.dat")
% (disassembletables "disasstb")
% (displayInstructions "386instrlist")

(exitlisp)
