(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    124647,       3259]
NotebookOptionsPosition[    114261,       2986]
NotebookOutlinePosition[    115321,       3024]
CellTagsIndexPosition[    115278,       3021]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Exponential Function Integration Problem 1", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881630453854`*^9, 
   3.482189194338312*^9, {3.482190100391152*^9, 3.482190115593011*^9}, 
   3.482190579900653*^9, 3.482196044167701*^9, 3.490294493002966*^9, 
   3.490295255984706*^9, 3.4903831894034233`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " is able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "3"]]}],
   FontSize->18,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for integer ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"m", "\[GreaterEqual]", "0"}],
   FontSize->18,
   FontWeight->"Bold"]]],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.4833941445066338`*^9, 
   3.483394148342149*^9}, 3.4900576623019085`*^9, {3.4902948562028036`*^9, 
   3.4902948857180557`*^9}, {3.4902950246987*^9, 3.490295043621533*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.444322277628317*^9}, {3.446678358556907*^9, 3.42317159478125*^9}, 
   3.42317471896875*^9, {3.4231750054375*^9, 3.423175007203125*^9}, 
   3.423175773046875*^9, {3.423332247375*^9, 3.42333227528125*^9}, 
   3.42333396240625*^9, {3.423334076234375*^9, 3.423334082734375*^9}, {
   3.423335282375*^9, 3.423335284609375*^9}, {3.423338110296875*^9, 
   3.423338157875*^9}, 3.423341119734375*^9, {3.42335733853125*^9, 
   3.42335737365625*^9}, {3.4902945252638226`*^9, 3.490294596680748*^9}, {
   3.490294641203226*^9, 3.490294686380905*^9}, 3.490294846249986*^9, {
   3.4902949050464897`*^9, 3.4902949325337377`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["1", "3"], ",", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "3"]}]}], "]"}]}], 
   RowBox[{"3", " ", "b", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "3"]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]]}]], "Output",
 CellChangeTimes->{3.4902949330173388`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "3"]]}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.444322277628317*^9}, {3.446678358556907*^9, 3.42317159478125*^9}, 
   3.42317471896875*^9, {3.4231750054375*^9, 3.423175007203125*^9}, 
   3.423175773046875*^9, {3.423332247375*^9, 3.42333227528125*^9}, 
   3.42333396240625*^9, {3.423334076234375*^9, 3.423334082734375*^9}, {
   3.423335282375*^9, 3.423335284609375*^9}, {3.423338110296875*^9, 
   3.423338157875*^9}, 3.423341119734375*^9, {3.42335733853125*^9, 
   3.42335737365625*^9}, {3.4902945252638226`*^9, 3.490294596680748*^9}, {
   3.490294641203226*^9, 3.490294686380905*^9}, 3.490294846249986*^9, {
   3.4902949050464897`*^9, 3.4902949262001266`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["1", "3"], ",", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "3"]}]}], "]"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "3"]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["2", "3"], ",", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "3"]}]}], "]"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "3"]}], ")"}], 
     RowBox[{"2", "/", "3"}]]}]]}]], "Output",
 CellChangeTimes->{3.4902949268397274`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "3"]]}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.444322277628317*^9}, {3.446678358556907*^9, 3.42317159478125*^9}, 
   3.42317471896875*^9, {3.4231750054375*^9, 3.423175007203125*^9}, 
   3.423175773046875*^9, {3.423332247375*^9, 3.42333227528125*^9}, 
   3.42333396240625*^9, {3.423334076234375*^9, 3.423334082734375*^9}, {
   3.423335282375*^9, 3.423335284609375*^9}, {3.423338110296875*^9, 
   3.423338157875*^9}, 3.423341119734375*^9, {3.42335733853125*^9, 
   3.42335737365625*^9}, {3.4902945252638226`*^9, 3.490294596680748*^9}, {
   3.490294641203226*^9, 3.490294686380905*^9}, 3.490294846249986*^9, {
   3.4902949050464897`*^9, 3.4902949165905094`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "3"]}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["1", "3"], ",", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "3"]}]}], "]"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "3"]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["2", "3"], ",", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "3"]}]}], "]"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox["b", "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "3"]}], ")"}], 
     RowBox[{"2", "/", "3"}]]}]]}]], "Output",
 CellChangeTimes->{{3.4233381250625*^9, 3.423338151*^9}, 
   3.42334114340625*^9, {3.423357355375*^9, 3.42335737490625*^9}, {
   3.490294526683425*^9, 3.490294597055148*^9}, {3.490294641718027*^9, 
   3.4902946870517063`*^9}, {3.490294907043293*^9, 3.4902949128621035`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is only able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "3"]]}],
   FontSize->18,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"m", "=", "0"}],
   FontSize->18,
   FontWeight->"Bold"]]],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.4833941445066338`*^9, 
   3.483394148342149*^9}, 3.4900576623019085`*^9, {3.4902948562028036`*^9, 
   3.4902948857180557`*^9}, {3.4902950246987*^9, 3.490295043621533*^9}, {
   3.4902951391561003`*^9, 3.4902951497017193`*^9}, {3.4902957971496563`*^9, 
   3.4902958131396847`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.42317159478125*^9}, 3.4231748894375*^9, {3.423175010234375*^9, 
   3.42317501209375*^9}, {3.423332130828125*^9, 3.423332133125*^9}, {
   3.423332213890625*^9, 3.4233322145625*^9}, 3.42333402840625*^9, 
   3.423334110109375*^9, {3.423335295421875*^9, 3.423335298*^9}, {
   3.423338207796875*^9, 3.42333822128125*^9}, 3.4233411713125*^9, 
   3.423357416453125*^9, 3.4902951707929564`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["1", "3"], ",", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "3"]}]}], "]"}]}], 
   RowBox[{"3", " ", "b", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "3"]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]]}]], "Output",
 CellChangeTimes->{
  3.423332218703125*^9, 3.4233340295*^9, 3.423334111078125*^9, {
   3.4233382089375*^9, 3.423338214234375*^9}, 3.423341184140625*^9, 
   3.42335741915625*^9, 3.490295172540159*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.42317159478125*^9}, 3.4231748894375*^9, {3.423175010234375*^9, 
   3.42317501209375*^9}, {3.423332130828125*^9, 3.423332133125*^9}, {
   3.423332213890625*^9, 3.4233322145625*^9}, 3.42333402840625*^9, 
   3.423334110109375*^9, {3.423335295421875*^9, 3.423335298*^9}, {
   3.423338207796875*^9, 3.42333822128125*^9}, 3.4233411713125*^9, 
   3.423357416453125*^9, {3.4902951707929564`*^9, 3.4902951858937826`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "3"]], " ", "x"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellChangeTimes->{3.490295186548984*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.42317159478125*^9}, 3.4231748894375*^9, {3.423175010234375*^9, 
   3.42317501209375*^9}, {3.423332130828125*^9, 3.423332133125*^9}, {
   3.423332213890625*^9, 3.4233322145625*^9}, 3.42333402840625*^9, 
   3.423334110109375*^9, {3.423335295421875*^9, 3.423335298*^9}, {
   3.423338207796875*^9, 3.42333822128125*^9}, 3.4233411713125*^9, 
   3.423357416453125*^9, {3.4902951707929564`*^9, 3.490295209496624*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "3"]], " ", 
    SuperscriptBox["x", "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellChangeTimes->{3.4902952103858256`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is unable to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "3"]]}],
   FontSize->18,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for any integer ",
 Cell[BoxData[
  StyleBox["m",
   FontSize->18,
   FontWeight->"Bold"]]],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.4833941445066338`*^9, 
   3.483394148342149*^9}, 3.4900576623019085`*^9, {3.4902948562028036`*^9, 
   3.4902948857180557`*^9}, {3.4902950246987*^9, 3.490295043621533*^9}, {
   3.4902951391561003`*^9, 3.4902951497017193`*^9}, {3.4902955102963524`*^9, 
   3.490295519796769*^9}, {3.4902957420815597`*^9, 3.4902957426743608`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"exp", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "3"}], ")"}]}], ",", " ", 
     "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4443226390179696`*^9, {3.4443227656600723`*^9, 3.42317159478125*^9}, {
   3.42317501975*^9, 3.4231750424375*^9}, {3.423332442*^9, 
   3.423332460203125*^9}, {3.423335418203125*^9, 3.423335440078125*^9}, {
   3.4233388183125*^9, 3.423338825359375*^9}, {3.423341561578125*^9, 
   3.423341581140625*^9}, {3.4233575345625*^9, 3.42335754190625*^9}, {
   3.4902952934091716`*^9, 3.4902953058735933`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "*", "exp", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "3"}], ")"}]}], ",", " ", 
     "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4443226390179696`*^9, {3.4443227656600723`*^9, 3.42317159478125*^9}, {
   3.42317501975*^9, 3.4231750424375*^9}, {3.423332442*^9, 
   3.423332460203125*^9}, {3.423335418203125*^9, 3.423335440078125*^9}, {
   3.4233388183125*^9, 3.423338825359375*^9}, {3.423341561578125*^9, 
   3.423341581140625*^9}, {3.4233575345625*^9, 3.42335754190625*^9}, {
   3.4902952934091716`*^9, 3.490295318962016*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "*", "exp", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "3"}], ")"}]}], ",", " ", 
     "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4443226390179696`*^9, {3.4443227656600723`*^9, 3.42317159478125*^9}, {
   3.42317501975*^9, 3.4231750424375*^9}, {3.423332442*^9, 
   3.423332460203125*^9}, {3.423335418203125*^9, 3.423335440078125*^9}, {
   3.4233388183125*^9, 3.423338825359375*^9}, {3.423341561578125*^9, 
   3.423341581140625*^9}, {3.4233575345625*^9, 3.42335754190625*^9}, {
   3.4902952934091716`*^9, 3.4902953240944257`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output"]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exponential Function Integration Problem 2", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, 
   3.4902999063440742`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881630453854`*^9, 
   3.482189194338312*^9, {3.482190100391152*^9, 3.482190115593011*^9}, 
   3.482190579900653*^9, 3.482196044167701*^9, 3.490294493002966*^9, 
   3.490295255984706*^9, 3.4902996216435738`*^9, 3.4903831925134277`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " is able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"]]}],
   FontSize->18,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for integer ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"m", "\[GreaterEqual]", "0"}],
   FontSize->18,
   FontWeight->"Bold"]]],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.4833941445066338`*^9, 
   3.483394148342149*^9}, 3.4900576623019085`*^9, {3.4902948562028036`*^9, 
   3.4902948857180557`*^9}, {3.4902950246987*^9, 3.490295043621533*^9}, 
   3.4902996270255833`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.444322277628317*^9}, {3.446678358556907*^9, 3.42317159478125*^9}, 
   3.42317471896875*^9, {3.4231750054375*^9, 3.423175007203125*^9}, 
   3.423175773046875*^9, {3.423332247375*^9, 3.42333227528125*^9}, 
   3.42333396240625*^9, {3.423334076234375*^9, 3.423334082734375*^9}, {
   3.423335282375*^9, 3.423335284609375*^9}, {3.423338110296875*^9, 
   3.423338157875*^9}, 3.423341119734375*^9, {3.42335733853125*^9, 
   3.42335737365625*^9}, {3.4902945252638226`*^9, 3.490294596680748*^9}, {
   3.490294641203226*^9, 3.490294686380905*^9}, 3.490294846249986*^9, {
   3.4902949050464897`*^9, 3.4902949325337377`*^9}, 3.4902996526564283`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], ")"}], 
     RowBox[{
      RowBox[{"-", "1"}], "/", "n"}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["1", "n"], ",", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]}], "]"}]}], 
   RowBox[{"b", " ", "n"}]]}]], "Output",
 CellChangeTimes->{3.4902949330173388`*^9, 3.4902996536080303`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"]]}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.444322277628317*^9}, {3.446678358556907*^9, 3.42317159478125*^9}, 
   3.42317471896875*^9, {3.4231750054375*^9, 3.423175007203125*^9}, 
   3.423175773046875*^9, {3.423332247375*^9, 3.42333227528125*^9}, 
   3.42333396240625*^9, {3.423334076234375*^9, 3.423334082734375*^9}, {
   3.423335282375*^9, 3.423335284609375*^9}, {3.423338110296875*^9, 
   3.423338157875*^9}, 3.423341119734375*^9, {3.42335733853125*^9, 
   3.42335737365625*^9}, {3.4902945252638226`*^9, 3.490294596680748*^9}, {
   3.490294641203226*^9, 3.490294686380905*^9}, 3.490294846249986*^9, {
   3.4902949050464897`*^9, 3.4902949262001266`*^9}, {3.4902996586156387`*^9, 
   3.4902996698320584`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], ")"}], 
     RowBox[{
      RowBox[{"-", "1"}], "/", "n"}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["1", "n"], ",", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]}], "]"}]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", "n"}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], ")"}], 
     RowBox[{
      RowBox[{"-", "2"}], "/", "n"}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["2", "n"], ",", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]}], "]"}]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", "n"}]]}]], "Output",
 CellChangeTimes->{
  3.4902949268397274`*^9, {3.49029965944244*^9, 3.4902996657604513`*^9}, 
   3.4902999634557743`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"]]}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.444322277628317*^9}, {3.446678358556907*^9, 3.42317159478125*^9}, 
   3.42317471896875*^9, {3.4231750054375*^9, 3.423175007203125*^9}, 
   3.423175773046875*^9, {3.423332247375*^9, 3.42333227528125*^9}, 
   3.42333396240625*^9, {3.423334076234375*^9, 3.423334082734375*^9}, {
   3.423335282375*^9, 3.423335284609375*^9}, {3.423338110296875*^9, 
   3.423338157875*^9}, 3.423341119734375*^9, {3.42335733853125*^9, 
   3.42335737365625*^9}, {3.4902945252638226`*^9, 3.490294596680748*^9}, {
   3.490294641203226*^9, 3.490294686380905*^9}, 3.490294846249986*^9, {
   3.4902949050464897`*^9, 3.4902949165905094`*^9}, {3.490299675292068*^9, 
   3.490299688162091*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], ")"}], 
      RowBox[{
       RowBox[{"-", "1"}], "/", "n"}]], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       FractionBox["1", "n"], ",", 
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]}], "]"}]}], 
    RowBox[{
     SuperscriptBox["b", "3"], " ", "n"}]]}], "+", 
  FractionBox[
   RowBox[{"2", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], ")"}], 
     RowBox[{
      RowBox[{"-", "2"}], "/", "n"}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["2", "n"], ",", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]}], "]"}]}], 
   RowBox[{
    SuperscriptBox["b", "3"], " ", "n"}]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], ")"}], 
     RowBox[{
      RowBox[{"-", "3"}], "/", "n"}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["3", "n"], ",", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]}], "]"}]}], 
   RowBox[{
    SuperscriptBox["b", "3"], " ", "n"}]]}]], "Output",
 CellChangeTimes->{{3.4233381250625*^9, 3.423338151*^9}, 
   3.42334114340625*^9, {3.423357355375*^9, 3.42335737490625*^9}, {
   3.490294526683425*^9, 3.490294597055148*^9}, {3.490294641718027*^9, 
   3.4902946870517063`*^9}, {3.490294907043293*^9, 3.4902949128621035`*^9}, {
   3.49029967664927*^9, 3.4902996815788794`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is only able to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"]]}],
   FontSize->18,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"m", "=", "0"}],
   FontSize->18,
   FontWeight->"Bold"]]],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.4833941445066338`*^9, 
   3.483394148342149*^9}, 3.4900576623019085`*^9, {3.4902948562028036`*^9, 
   3.4902948857180557`*^9}, {3.4902950246987*^9, 3.490295043621533*^9}, {
   3.4902951391561003`*^9, 3.4902951497017193`*^9}, {3.4902957971496563`*^9, 
   3.4902958131396847`*^9}, 3.490299731015366*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.42317159478125*^9}, 3.4231748894375*^9, {3.423175010234375*^9, 
   3.42317501209375*^9}, {3.423332130828125*^9, 3.423332133125*^9}, {
   3.423332213890625*^9, 3.4233322145625*^9}, 3.42333402840625*^9, 
   3.423334110109375*^9, {3.423335295421875*^9, 3.423335298*^9}, {
   3.423338207796875*^9, 3.42333822128125*^9}, 3.4233411713125*^9, 
   3.423357416453125*^9, 3.4902951707929564`*^9, 3.4902997015937147`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], ")"}], 
     RowBox[{
      RowBox[{"-", "1"}], "/", "n"}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["1", "n"], ",", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]}], "]"}]}], 
   RowBox[{"b", " ", "n"}]]}]], "Output",
 CellChangeTimes->{
  3.423332218703125*^9, 3.4233340295*^9, 3.423334111078125*^9, {
   3.4233382089375*^9, 3.423338214234375*^9}, 3.423341184140625*^9, 
   3.42335741915625*^9, 3.490295172540159*^9, 3.4902997023581157`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.42317159478125*^9}, 3.4231748894375*^9, {3.423175010234375*^9, 
   3.42317501209375*^9}, {3.423332130828125*^9, 3.423332133125*^9}, {
   3.423332213890625*^9, 3.4233322145625*^9}, 3.42333402840625*^9, 
   3.423334110109375*^9, {3.423335295421875*^9, 3.423335298*^9}, {
   3.423338207796875*^9, 3.42333822128125*^9}, 3.4233411713125*^9, 
   3.423357416453125*^9, {3.4902951707929564`*^9, 3.4902951858937826`*^9}, 
   3.4902997116245317`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"]], " ", "x"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellChangeTimes->{3.490295186548984*^9, 3.4902997124357333`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.42317159478125*^9}, 3.4231748894375*^9, {3.423175010234375*^9, 
   3.42317501209375*^9}, {3.423332130828125*^9, 3.423332133125*^9}, {
   3.423332213890625*^9, 3.4233322145625*^9}, 3.42333402840625*^9, 
   3.423334110109375*^9, {3.423335295421875*^9, 3.423335298*^9}, {
   3.423338207796875*^9, 3.42333822128125*^9}, 3.4233411713125*^9, 
   3.423357416453125*^9, {3.4902951707929564`*^9, 3.490295209496624*^9}, 
   3.490299716772541*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"]], " ", 
    SuperscriptBox["x", "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellChangeTimes->{3.4902952103858256`*^9, 3.490299717412142*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is unable to integrate  ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"]]}],
   FontSize->18,
   FontWeight->"Bold"]],
  CellDingbat->None,
  CellChangeTimes->{
   3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
    3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
    3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
    3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
    3.482197249951533*^9, 3.482198265491808*^9, 3.482198311638163*^9, {
    3.4821989115307665`*^9, 3.4821989119012995`*^9}, 3.482199478365835*^9, {
    3.4827167285874496`*^9, 3.48271673125128*^9}, {3.482718509007568*^9, 
    3.4827185116513696`*^9}, 3.4832032731012464`*^9},
  TextAlignment->Center,
  FontFamily->"Courier New",
  FontSize->20],
 " for any integer ",
 Cell[BoxData[
  StyleBox["m",
   FontSize->18,
   FontWeight->"Bold"]]],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.4833941445066338`*^9, 
   3.483394148342149*^9}, 3.4900576623019085`*^9, {3.4902948562028036`*^9, 
   3.4902948857180557`*^9}, {3.4902950246987*^9, 3.490295043621533*^9}, {
   3.4902951391561003`*^9, 3.4902951497017193`*^9}, {3.4902955102963524`*^9, 
   3.490295519796769*^9}, {3.4902957420815597`*^9, 3.4902957426743608`*^9}, {
   3.4902997386905794`*^9, 3.490299751560602*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"exp", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], ")"}]}], ",", " ", 
     "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4443226390179696`*^9, {3.4443227656600723`*^9, 3.42317159478125*^9}, {
   3.42317501975*^9, 3.4231750424375*^9}, {3.423332442*^9, 
   3.423332460203125*^9}, {3.423335418203125*^9, 3.423335440078125*^9}, {
   3.4233388183125*^9, 3.423338825359375*^9}, {3.423341561578125*^9, 
   3.423341581140625*^9}, {3.4233575345625*^9, 3.42335754190625*^9}, {
   3.4902952934091716`*^9, 3.4902953058735933`*^9}, 3.4902997596414165`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.4902998294203386`*^9, 3.490299829435939*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "*", "exp", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], ")"}]}], ",", " ", 
     "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4443226390179696`*^9, {3.4443227656600723`*^9, 3.42317159478125*^9}, {
   3.42317501975*^9, 3.4231750424375*^9}, {3.423332442*^9, 
   3.423332460203125*^9}, {3.423335418203125*^9, 3.423335440078125*^9}, {
   3.4233388183125*^9, 3.423338825359375*^9}, {3.423341561578125*^9, 
   3.423341581140625*^9}, {3.4233575345625*^9, 3.42335754190625*^9}, {
   3.4902952934091716`*^9, 3.490295318962016*^9}, 3.4902997624806213`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.490299831323542*^9, 3.490299831323542*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "*", "exp", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], ")"}]}], ",", " ", 
     "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4443226390179696`*^9, {3.4443227656600723`*^9, 3.42317159478125*^9}, {
   3.42317501975*^9, 3.4231750424375*^9}, {3.423332442*^9, 
   3.423332460203125*^9}, {3.423335418203125*^9, 3.423335440078125*^9}, {
   3.4233388183125*^9, 3.423338825359375*^9}, {3.423341561578125*^9, 
   3.423341581140625*^9}, {3.4233575345625*^9, 3.42335754190625*^9}, {
   3.4902952934091716`*^9, 3.4902953240944257`*^9}, 3.4902997641966243`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellChangeTimes->{{3.4902998332891455`*^9, 3.4902998332891455`*^9}}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exponential Function Integration Problem 3", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, 
   3.490294476747737*^9, 3.4903000695203605`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881630453854`*^9, 
   3.482189194338312*^9, {3.482190100391152*^9, 3.482190115593011*^9}, 
   3.482190579900653*^9, 3.482196044167701*^9, 3.4903831956034317`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " is able to integrate the generalized expression using the trivial \
substitution ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"u", "=", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}]}],
   FontWeight->"Bold"]]],
 ":"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, {3.423338772921875*^9, 
   3.423338774734375*^9}, 3.423341072796875*^9, {3.423341460375*^9, 
   3.4233414605625*^9}, {3.42335786965625*^9, 3.423357883921875*^9}, {
   3.455347583937736*^9, 3.455347624856574*^9}, 3.482196265115408*^9, 
   3.4821963907059984`*^9, {3.490296235775627*^9, 3.4902963039165463`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox["x", "n"]]}], ",", " ", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.444322277628317*^9}, {3.446678358556907*^9, 3.42317159478125*^9}, 
   3.42317471896875*^9, {3.4231750054375*^9, 3.423175007203125*^9}, 
   3.423175773046875*^9, {3.423332247375*^9, 3.42333227528125*^9}, 
   3.42333396240625*^9, {3.423334076234375*^9, 3.423334082734375*^9}, {
   3.423335282375*^9, 3.423335284609375*^9}, {3.423338110296875*^9, 
   3.423338157875*^9}, 3.423341119734375*^9, {3.42335733853125*^9, 
   3.42335737365625*^9}, 3.490296065594928*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"1", "+", "m"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       SuperscriptBox["x", "n"]}], ")"}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"1", "+", "m"}], "n"]}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", "m"}], "n"], ",", 
      RowBox[{"-", 
       SuperscriptBox["x", "n"]}]}], "]"}]}], "n"]}]], "Output",
 CellChangeTimes->{{3.4233381250625*^9, 3.423338151*^9}, 
   3.42334114340625*^9, {3.423357355375*^9, 3.42335737490625*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"]]}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.444322277628317*^9}, {3.446678358556907*^9, 3.42317159478125*^9}, 
   3.42317471896875*^9, {3.4231750054375*^9, 3.423175007203125*^9}, 
   3.423175773046875*^9, {3.423332247375*^9, 3.42333227528125*^9}, 
   3.42333396240625*^9, {3.423334076234375*^9, 3.423334082734375*^9}, {
   3.423335282375*^9, 3.423335284609375*^9}, {3.423338110296875*^9, 
   3.423338157875*^9}, 3.423341119734375*^9, {3.42335733853125*^9, 
   3.423357359265625*^9}, 3.423357826359375*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"1", "+", "m"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], ")"}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"1", "+", "m"}], "n"]}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", "m"}], "n"], ",", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]}], "]"}]}], 
   RowBox[{"b", " ", "n"}]]}]], "Output",
 CellChangeTimes->{3.423357361125*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is unable to integrate the generalized expression:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322586131923*^9}, {
   3.4466780286625423`*^9, 3.446678029423637*^9}, {3.4466948967576723`*^9, 
   3.42317159478125*^9}, 3.423174910453125*^9, {3.423332331546875*^9, 
   3.423332347125*^9}, {3.423332380203125*^9, 3.42333240928125*^9}, {
   3.42333868671875*^9, 3.423338688046875*^9}, 3.423341072828125*^9, {
   3.423341192828125*^9, 3.42334120171875*^9}, {3.42334151903125*^9, 
   3.423341526171875*^9}, 3.423357905140625*^9, {3.455347612178344*^9, 
   3.455347616093974*^9}, 3.455347646828168*^9, 3.4821962853344817`*^9, 
   3.482196410905043*^9, {3.49029615790029*^9, 3.4902962109715834`*^9}, {
   3.490296316880169*^9, 3.4902963307641935`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox["x", "n"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.42317159478125*^9}, 3.4231748894375*^9, {3.423175010234375*^9, 
   3.42317501209375*^9}, {3.423332130828125*^9, 3.423332133125*^9}, {
   3.423332213890625*^9, 3.4233322145625*^9}, 3.42333402840625*^9, 
   3.423334110109375*^9, {3.423335295421875*^9, 3.423335298*^9}, {
   3.423338207796875*^9, 3.42333822128125*^9}, 3.4233411713125*^9, 
   3.423357416453125*^9, 3.4902960703997364`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"1", "+", "m"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       SuperscriptBox["x", "n"]}], ")"}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"1", "+", "m"}], "n"]}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", "m"}], "n"], ",", 
      RowBox[{"-", 
       SuperscriptBox["x", "n"]}]}], "]"}]}], "n"]}]], "Output",
 CellChangeTimes->{
  3.423332218703125*^9, 3.4233340295*^9, 3.423334111078125*^9, {
   3.4233382089375*^9, 3.423338214234375*^9}, 3.423341184140625*^9, 
   3.42335741915625*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"]]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.42317159478125*^9}, 3.4231748894375*^9, {3.423175010234375*^9, 
   3.42317501209375*^9}, {3.423332130828125*^9, 3.423332133125*^9}, {
   3.423332213890625*^9, 3.4233322145625*^9}, 3.42333402840625*^9, 
   3.423334110109375*^9, {3.423335295421875*^9, 3.423335298*^9}, {
   3.423338207796875*^9, 3.42333822128125*^9}, 3.4233411713125*^9, {
   3.423341493703125*^9, 3.42334150478125*^9}, 3.423357433125*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", " ", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "m"], 
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.444322309023461*^9, {3.4466780179571486`*^9, 3.42317159478125*^9}, 
   3.423174922546875*^9, 3.423175081671875*^9, 3.42333222453125*^9, 
   3.4233353974375*^9, {3.423338232890625*^9, 3.42333824859375*^9}, 
   3.4233382883125*^9, {3.423341495359375*^9, 3.423341501171875*^9}, 
   3.423357434421875*^9, {3.423357467171875*^9, 3.42335746965625*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is unable to integrate either expression:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322612239464*^9}, {
   3.444322789243984*^9, 3.444322790265453*^9}, {3.4443228380341406`*^9, 
   3.444322843231614*^9}, {3.444322931999256*^9, 3.444322937186715*^9}, {
   3.4466780338700304`*^9, 3.4466780349716144`*^9}, 3.446679270337984*^9, {
   3.4466793247562337`*^9, 3.4466793254271984`*^9}, {3.446694901734829*^9, 
   3.423010829046875*^9}, 3.42317159478125*^9, 3.42317494815625*^9, {
   3.42333242146875*^9, 3.42333243090625*^9}, {3.42333560515625*^9, 
   3.42333561684375*^9}, {3.4233388060625*^9, 3.423338809515625*^9}, 
   3.42334107284375*^9, {3.423358025796875*^9, 3.423358036421875*^9}, 
   3.482196321466437*^9, {3.4902961189314213`*^9, 3.490296134500249*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "m"}], "*", "exp", 
      RowBox[{"(", 
       RowBox[{"x", "^", "n"}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4443226390179696`*^9, {3.4443227656600723`*^9, 3.42317159478125*^9}, {
   3.42317501975*^9, 3.4231750424375*^9}, {3.423332442*^9, 
   3.423332460203125*^9}, {3.423335418203125*^9, 3.423335440078125*^9}, {
   3.4233388183125*^9, 3.423338825359375*^9}, {3.423341561578125*^9, 
   3.423341581140625*^9}, {3.4233575345625*^9, 3.42335754190625*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox["x", "n"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}], "*", "exp", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], ")"}]}], ",", " ", 
     "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4443226390179696`*^9, {3.4443227656600723`*^9, 3.42317159478125*^9}, {
   3.42317501975*^9, 3.4231750424375*^9}, {3.423332442*^9, 
   3.423332460203125*^9}, {3.423335418203125*^9, 3.423335440078125*^9}, {
   3.4233388183125*^9, 3.423338825359375*^9}, {3.423341561578125*^9, 
   3.4233415969375*^9}, {3.423357561875*^9, 3.42335757240625*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", " ", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "m"], 
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.444322309023461*^9, {3.4466780179571486`*^9, 3.42317159478125*^9}, 
   3.423174922546875*^9, 3.423175081671875*^9, 3.42333222453125*^9, 
   3.4233353974375*^9, {3.423338232890625*^9, 3.42333824859375*^9}, 
   3.4233382883125*^9, {3.423341495359375*^9, 3.423341501171875*^9}, 
   3.423357434421875*^9, {3.423357467171875*^9, 3.42335746965625*^9}}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exponential Function Integration Problem 4", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, 3.4902944860297537`*^9, 3.4903131181591473`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["8", "x"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["4", "x"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881630453854`*^9, 
   3.482189194338312*^9, {3.482190100391152*^9, 3.482190115593011*^9}, 
   3.482190579900653*^9, 3.482196137111347*^9, 3.482196175055909*^9, 
   3.482196217166461*^9, {3.490311931417486*^9, 3.49031193467749*^9}, 
   3.4903120589576645`*^9, {3.4903123425380616`*^9, 3.4903123639480915`*^9}, 
   3.4903832017934403`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " result involves only elementary functions:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4468607643012114`*^9, 
   3.446860790759256*^9}, {3.446864256883298*^9, 3.4468642799464607`*^9}, {
   3.446865060869373*^9, 3.423010751125*^9}, 3.423171708640625*^9, 
   3.482196561281274*^9, {3.4826466161503153`*^9, 3.482646619394981*^9}, {
   3.4903121958478565`*^9, 3.4903122174578867`*^9}, {3.4903125495183516`*^9, 
   3.4903125558783603`*^9}, {3.4903128545987787`*^9, 3.4903128610287876`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["8", "x"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["4", "x"]}]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, 3.4443499933215265`*^9, {3.446860796848011*^9, 
   3.4468608131514544`*^9}, {3.4468641179535265`*^9, 3.423013053546875*^9}, 
   3.423171708640625*^9, {3.4903121146277423`*^9, 3.4903121344577703`*^9}, 
   3.4903123826181173`*^9, {3.490312414778163*^9, 3.4903124851182613`*^9}, 
   3.4903125261383185`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["2", "x"], 
   RowBox[{"b", " ", 
    RowBox[{"Log", "[", "2", "]"}]}]], "-", 
  FractionBox[
   RowBox[{
    SqrtBox["a"], " ", 
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{
       SuperscriptBox["2", "x"], " ", 
       SqrtBox["b"]}], 
      SqrtBox["a"]], "]"}]}], 
   RowBox[{
    SuperscriptBox["b", 
     RowBox[{"3", "/", "2"}]], " ", 
    RowBox[{"Log", "[", "2", "]"}]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443499554871235`*^9, 3.4443499625572896`*^9}, 
   3.446683635064152*^9, 3.4468609512800736`*^9, {3.4468641495489583`*^9, 
   3.423171708640625*^9}, 3.490311684707141*^9, {3.490312115177743*^9, 
   3.4903121349677706`*^9}, 3.490312383458119*^9, {3.490312425598178*^9, 
   3.4903124859982624`*^9}, 3.4903125268183193`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " result involves nonelementary functions:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, 
   3.4466950388319645`*^9, {3.446861017365099*^9, 3.446861028501112*^9}, {
   3.446864283100997*^9, 3.4468642901811776`*^9}, {3.4468651279458237`*^9, 
   3.423171708640625*^9}, 3.482196288569133*^9, {3.482646585255891*^9, 
   3.4826466084492416`*^9}, {3.4903122229578943`*^9, 
   3.4903122422679214`*^9}, {3.49031256252837*^9, 3.4903125658983746`*^9}, {
   3.490312871948803*^9, 3.490312906588851*^9}, {3.4903129621989293`*^9, 
   3.490312965158933*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["8", "x"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["4", "x"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, 3.4443499933215265`*^9, {3.446860796848011*^9, 
   3.4468608131514544`*^9}, {3.4468641179535265`*^9, 
   3.4468641325344925`*^9}, {3.4468641656721425`*^9, 3.423013062890625*^9}, 
   3.423171708640625*^9, {3.49031196963754*^9, 3.4903119792375526`*^9}, 
   3.4903120924277115`*^9, {3.4903121503077927`*^9, 3.4903121511677933`*^9}, 
   3.4903125374783344`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["8", "x"], " ", 
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{"1", ",", 
     FractionBox[
      RowBox[{"Log", "[", "8", "]"}], 
      RowBox[{"Log", "[", "4", "]"}]], ",", 
     FractionBox[
      RowBox[{"Log", "[", "32", "]"}], 
      RowBox[{"Log", "[", "4", "]"}]], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["4", "x"], " ", "b"}], "a"]}]}], "]"}]}], 
  RowBox[{"a", " ", 
   RowBox[{"Log", "[", "8", "]"}]}]]], "Output",
 CellChangeTimes->{3.4903121516577945`*^9, 3.4903125382983356`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " result involves only elementary functions, but is more complicated:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 3.4466839896239843`*^9}, 
   3.4466950433384447`*^9, {3.4468610515943184`*^9, 3.4468610732254224`*^9}, {
   3.446864302579005*^9, 3.4468643212258177`*^9}, {3.4468651517300243`*^9, 
   3.4230108319375*^9}, 3.423171708640625*^9, 3.482196326273349*^9, {
   3.4826466301804895`*^9, 3.4826466349874015`*^9}, {3.490312643638483*^9, 
   3.4903126575085025`*^9}, {3.4903129205688705`*^9, 3.4903129333188887`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"8", "^", "x"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"4", "^", "x"}]}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.4468611193417344`*^9, 3.4468611288053427`*^9}, {
   3.446863899930024*^9, 3.423171708640625*^9}, {3.4903125877784047`*^9, 
   3.490312597468418*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["2", "x"], 
   RowBox[{"b", " ", 
    RowBox[{"Log", "[", "2", "]"}]}]], "+", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{
      RowBox[{"-", "a"}], " ", "b"}]], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["2", "x"], "-", 
      FractionBox[
       SqrtBox[
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}]], "b"]}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"Log", "[", "2", "]"}]}]], "-", 
  FractionBox[
   RowBox[{
    SqrtBox[
     RowBox[{
      RowBox[{"-", "a"}], " ", "b"}]], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox["2", "x"], "+", 
      FractionBox[
       SqrtBox[
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}]], "b"]}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"Log", "[", "2", "]"}]}]]}]], "Output",
 CellChangeTimes->{{3.4903127955486956`*^9, 3.4903128042887077`*^9}}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exponential Function Integration Problem 5", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821961835881777`*^9}, 3.490294482862948*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["4", "x"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["2", "x"]}]}], ")"}], "m"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881630453854`*^9, 
   3.482189194338312*^9, {3.482190100391152*^9, 3.482190115593011*^9}, 
   3.482190579900653*^9, 3.482196137111347*^9, 3.482196175055909*^9, {
   3.4903102740451655`*^9, 3.4903102798351736`*^9}, {3.490310377925311*^9, 
   3.490310398045339*^9}, 3.490383206243447*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "Both ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " results are correct:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4468607643012114`*^9, 
   3.446860790759256*^9}, {3.446864256883298*^9, 3.42301075065625*^9}, 
   3.4231716983125*^9, 3.482196558236896*^9, 3.4826461555980735`*^9, {
   3.490310413715361*^9, 3.4903104183953676`*^9}, {3.4903115253869176`*^9, 
   3.4903115259069185`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["4", "x"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["2", "x"]}]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, 3.4443499933215265`*^9, {3.446860796848011*^9, 
   3.4468608131514544`*^9}, {3.4468641179535265`*^9, 
   3.4468641325344925`*^9}, {3.4468645708447523`*^9, 3.423013042578125*^9}, 
   3.4231716983125*^9, {3.490310315105223*^9, 3.490310345035265*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["2", "x"], 
   RowBox[{"b", " ", 
    RowBox[{"Log", "[", "2", "]"}]}]], "-", 
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{
       SuperscriptBox["2", "x"], " ", "b"}]}], "]"}]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"Log", "[", "2", "]"}]}]]}]], "Output",
 CellChangeTimes->{3.4903109396160975`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["4", "x"], 
    RowBox[{"Sqrt", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["2", "x"]}]}], "]"}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, 3.4443499933215265`*^9, {3.446860796848011*^9, 
   3.4468608131514544`*^9}, {3.4468641179535265`*^9, 
   3.4468641325344925`*^9}, {3.4468645708447523`*^9, 3.423013042578125*^9}, 
   3.4231716983125*^9, {3.490310315105223*^9, 3.4903103518352747`*^9}, {
   3.4903104304553843`*^9, 3.4903104354353914`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"4", " ", "a", " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{
        SuperscriptBox["2", "x"], " ", "b"}]}]]}], 
    RowBox[{"3", " ", 
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"Log", "[", "2", "]"}]}]]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"1", "+", "x"}]], " ", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{
       SuperscriptBox["2", "x"], " ", "b"}]}]]}], 
   RowBox[{"3", " ", "b", " ", 
    RowBox[{"Log", "[", "2", "]"}]}]]}]], "Output",
 CellChangeTimes->{3.4903114105867567`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Both ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " results",
 StyleBox[" ",
  FontSlant->"Italic"],
 "are incorrect:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, 
   3.4466950388319645`*^9, {3.446861017365099*^9, 3.446861028501112*^9}, {
   3.446864283100997*^9, 3.4231716983125*^9}, 3.4821962878280673`*^9, 
   3.4826462074125795`*^9, {3.4903104618554287`*^9, 3.490310464365432*^9}, {
   3.490311428266782*^9, 3.490311429196783*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["4", "x"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["2", "x"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, 3.4443499933215265`*^9, {3.446860796848011*^9, 
   3.4468608131514544`*^9}, {3.4468641179535265`*^9, 
   3.4468641325344925`*^9}, {3.4468641656721425`*^9, 3.446864172952611*^9}, {
   3.446864590953667*^9, 3.4230130723125*^9}, 3.4231716983125*^9, {
   3.490310447235408*^9, 3.4903104527854156`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"-", "a"}], "-", 
    RowBox[{
     SuperscriptBox["2", "x"], " ", "b"}]}], "]"}], 
  RowBox[{"b", " ", 
   RowBox[{"Log", "[", "4", "]"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.444349997838021*^9, 3.446683614354373*^9, 3.4468609710585136`*^9, 
   3.446864175305995*^9, {3.446864603421595*^9, 3.4231716983125*^9}, 
   3.4903104555454197`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["4", "x"], 
    RowBox[{"Sqrt", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["2", "x"]}]}], "]"}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, 3.4443499933215265`*^9, {3.446860796848011*^9, 
   3.4468608131514544`*^9}, {3.4468641179535265`*^9, 
   3.4468641325344925`*^9}, {3.4468641656721425`*^9, 3.446864172952611*^9}, {
   3.446864590953667*^9, 3.4230130723125*^9}, 3.4231716983125*^9, {
   3.490310447235408*^9, 3.4903104840454597`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{
      SuperscriptBox["2", "x"], " ", "b"}]}]]}], 
  RowBox[{"b", " ", 
   RowBox[{"Log", "[", "4", "]"}]}]]], "Output",
 CellChangeTimes->{3.4903105217455125`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The second ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " result is incorrect:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 3.4466839896239843`*^9}, 
   3.4466950433384447`*^9, {3.4468610515943184`*^9, 3.4468610732254224`*^9}, {
   3.446864302579005*^9, 3.423010831546875*^9}, 3.4231716983125*^9, 
   3.482196325772629*^9, 3.4826462394186015`*^9, {3.4903114320867867`*^9, 
   3.490311456476821*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"4", "^", "x"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"2", "^", "x"}]}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, 3.4443499933215265`*^9, {3.446860796848011*^9, 
   3.4468608131514544`*^9}, {3.4468641179535265`*^9, 
   3.4468641325344925`*^9}, {3.4468641656721425`*^9, 3.446864172952611*^9}, {
   3.446864590953667*^9, 3.4230130723125*^9}, 3.4231716983125*^9, {
   3.490310447235408*^9, 3.4903104840454597`*^9}, {3.49031068462574*^9, 
   3.490310703635767*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["2", "x"], " ", "b"}], "-", 
   RowBox[{"a", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"a", "+", 
      RowBox[{
       SuperscriptBox["2", "x"], " ", "b"}]}], "]"}]}]}], 
  RowBox[{
   SuperscriptBox["b", "2"], " ", 
   RowBox[{"Log", "[", "2", "]"}]}]]], "Output",
 CellChangeTimes->{3.49031090559605*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"4", "^", "x"}], "/", "sqrt"}], 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"2", "^", "x"}]}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, 3.4443499933215265`*^9, {3.446860796848011*^9, 
   3.4468608131514544`*^9}, {3.4468641179535265`*^9, 
   3.4468641325344925`*^9}, {3.4468641656721425`*^9, 3.446864172952611*^9}, {
   3.446864590953667*^9, 3.4230130723125*^9}, 3.4231716983125*^9, {
   3.490310447235408*^9, 3.4903104840454597`*^9}, {3.49031068462574*^9, 
   3.4903107256857977`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "a"}], "-", 
      RowBox[{"b", " ", 
       SuperscriptBox["2", "x"]}]}], ")"}], " ", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["2", "x"]}]}]]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "+", 
      SuperscriptBox["b", "2"]}], ")"}], " ", 
    RowBox[{"Log", "[", "2", "]"}]}]]}]], "Output"]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exponential Function Integration Problem 6", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, 3.4902944803513436`*^9, 
   3.4903131211691513`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}]], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "n"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881630453854`*^9, 
   3.482189194338312*^9, {3.482190100391152*^9, 3.482190115593011*^9}, 
   3.482190579900653*^9, 3.482196137111347*^9, 3.4903832075034485`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " is able to integrate the expression for numeric and symbolic n:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, 3.423341072609375*^9, 
   3.4561670576690483`*^9, 3.4791559290778675`*^9, 3.482175999467106*^9, {
   3.482176939178344*^9, 3.482176943534608*^9}, 3.4821770265840273`*^9, {
   3.4898048224003077`*^9, 3.4898048266603136`*^9}, {3.4898052234408693`*^9, 
   3.489805239230891*^9}, {3.4898052800709486`*^9, 3.4898052802509484`*^9}, {
   3.489807179413607*^9, 3.489807180423609*^9}, 3.4898795383741636`*^9, 
   3.4902977643131113`*^9, {3.4902982420707507`*^9, 3.490298277701213*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "n"]}]}]]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.444322277628317*^9}, {3.446678358556907*^9, 3.42317159478125*^9}, 
   3.42317471896875*^9, {3.4231750054375*^9, 3.423175007203125*^9}, 
   3.423175773046875*^9, {3.423332247375*^9, 3.42333227528125*^9}, 
   3.42333396240625*^9, {3.423334076234375*^9, 3.423334082734375*^9}, {
   3.423335282375*^9, 3.423335284609375*^9}, {3.423338110296875*^9, 
   3.423338157875*^9}, 3.423341119734375*^9, {3.4233414446875*^9, 
   3.42334144546875*^9}, 3.423342014140625*^9, {3.42334326309375*^9, 
   3.4233432665*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", "c"}]], " ", "x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"b", "+", "d"}], ")"}]}], " ", 
       SuperscriptBox["x", "n"]}], ")"}], 
     RowBox[{
      RowBox[{"-", "1"}], "/", "n"}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["1", "n"], ",", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"b", "+", "d"}], ")"}]}], " ", 
       SuperscriptBox["x", "n"]}]}], "]"}]}], "n"]}]], "Output",
 CellChangeTimes->{
  3.4233322564375*^9, 3.423334002734375*^9, 3.423334090890625*^9, 
   3.42333524703125*^9, {3.42333817665625*^9, 3.423338182015625*^9}, 
   3.42334145478125*^9, 3.423342021390625*^9, 3.423343267078125*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "5"]}]}]], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "5"]}]}]]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.444322277628317*^9}, {3.446678358556907*^9, 3.42317159478125*^9}, 
   3.42317471896875*^9, {3.4231750054375*^9, 3.423175007203125*^9}, 
   3.423175773046875*^9, {3.423332247375*^9, 3.42333227528125*^9}, 
   3.42333396240625*^9, {3.423334076234375*^9, 3.423334082734375*^9}, {
   3.423335282375*^9, 3.423335284609375*^9}, {3.423338110296875*^9, 
   3.423338157875*^9}, 3.423341119734375*^9, {3.4233414446875*^9, 
   3.42334144546875*^9}, 3.423342014140625*^9, {3.42334326309375*^9, 
   3.4233432665*^9}, {3.423343314921875*^9, 3.42334332071875*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", "c"}]], " ", "x", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["1", "5"], ",", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"b", "+", "d"}], ")"}]}], " ", 
       SuperscriptBox["x", "5"]}]}], "]"}]}], 
   RowBox[{"5", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"b", "+", "d"}], ")"}]}], " ", 
       SuperscriptBox["x", "5"]}], ")"}], 
     RowBox[{"1", "/", "5"}]]}]]}]], "Output",
 CellChangeTimes->{3.4233433225*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "/", "3"}]]}]}]], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "/", "3"}]]}]}]]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.444322277628317*^9}, {3.446678358556907*^9, 3.42317159478125*^9}, 
   3.42317471896875*^9, {3.4231750054375*^9, 3.423175007203125*^9}, 
   3.423175773046875*^9, {3.423332247375*^9, 3.42333227528125*^9}, 
   3.42333396240625*^9, {3.423334076234375*^9, 3.423334082734375*^9}, {
   3.423335282375*^9, 3.423335284609375*^9}, {3.423338110296875*^9, 
   3.423338157875*^9}, 3.423341119734375*^9, {3.4233414446875*^9, 
   3.42334144546875*^9}, 3.423342014140625*^9, {3.42334326309375*^9, 
   3.4233432665*^9}, {3.423343314921875*^9, 3.42334332071875*^9}, {
   3.4902980540748205`*^9, 3.4902980628420362`*^9}, {3.49029816191781*^9, 
   3.4902982049114857`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", "c", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", "d"}], ")"}], " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "/", "3"}]]}]}]], " ", 
    SuperscriptBox["x", 
     RowBox[{"1", "/", "3"}]]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "d"}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", "c"}]], " ", 
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Erfi", "[", 
     RowBox[{
      SqrtBox[
       RowBox[{"b", "+", "d"}]], " ", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "3"}]]}], "]"}]}], 
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", "d"}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]]}]], "Output",
 CellChangeTimes->{
  3.490298063325637*^9, {3.490298164257814*^9, 3.4902982053950863`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is unable to integrate the expression unless n is numeric:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322586131923*^9}, {
   3.4466780286625423`*^9, 3.446678029423637*^9}, {3.4466948967576723`*^9, 
   3.42317159478125*^9}, 3.423174910453125*^9, {3.423332331546875*^9, 
   3.423332347125*^9}, {3.423332380203125*^9, 3.42333240928125*^9}, {
   3.42333868671875*^9, 3.423338688046875*^9}, 3.423341072828125*^9, {
   3.423341192828125*^9, 3.42334120171875*^9}, {3.42334151903125*^9, 
   3.423341526171875*^9}, {3.423343196484375*^9, 3.423343210078125*^9}, 
   3.482196286235778*^9, {3.490297946786632*^9, 3.4902979705766735`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "n"]}]}]]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.42317159478125*^9}, 3.4231748894375*^9, {3.423175010234375*^9, 
   3.42317501209375*^9}, {3.423332130828125*^9, 3.423332133125*^9}, {
   3.423332213890625*^9, 3.4233322145625*^9}, 3.42333402840625*^9, 
   3.423334110109375*^9, {3.423335295421875*^9, 3.423335298*^9}, {
   3.423338207796875*^9, 3.42333822128125*^9}, 3.4233411713125*^9, {
   3.423341493703125*^9, 3.42334150478125*^9}, 3.423342099703125*^9, 
   3.42334264096875*^9, {3.423343133015625*^9, 3.42334313728125*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"a", "+", "c", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "n"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.42317159478125*^9}, 3.4231748894375*^9, {3.423175010234375*^9, 
   3.42317501209375*^9}, {3.423332130828125*^9, 3.423332133125*^9}, {
   3.423332213890625*^9, 3.4233322145625*^9}, 3.42333402840625*^9, 
   3.423334110109375*^9, {3.423335295421875*^9, 3.423335298*^9}, {
   3.423338207796875*^9, 3.42333822128125*^9}, 3.4233411713125*^9, {
   3.423341493703125*^9, 3.42334150478125*^9}, 3.423342099703125*^9, 
   3.42334264096875*^9, {3.423343133015625*^9, 3.42334313728125*^9}, 
   3.4902976346612835`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "5"]}]}]], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "5"]}]}]]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.42317159478125*^9}, 3.4231748894375*^9, {3.423175010234375*^9, 
   3.42317501209375*^9}, {3.423332130828125*^9, 3.423332133125*^9}, {
   3.423332213890625*^9, 3.4233322145625*^9}, 3.42333402840625*^9, 
   3.423334110109375*^9, {3.423335295421875*^9, 3.423335298*^9}, {
   3.423338207796875*^9, 3.42333822128125*^9}, 3.4233411713125*^9, {
   3.423341493703125*^9, 3.42334150478125*^9}, 3.423342099703125*^9, 
   3.42334264096875*^9, {3.423343133015625*^9, 3.423343164421875*^9}, {
   3.42334322003125*^9, 3.42334322409375*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", "c"}]], " ", "x", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["1", "5"], ",", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"b", "+", "d"}], ")"}]}], " ", 
       SuperscriptBox["x", "5"]}]}], "]"}]}], 
   RowBox[{"5", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"b", "+", "d"}], ")"}]}], " ", 
       SuperscriptBox["x", "5"]}], ")"}], 
     RowBox[{"1", "/", "5"}]]}]]}]], "Output",
 CellChangeTimes->{3.42334316496875*^9, 3.423343224921875*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "/", "3"}]]}]}]], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "/", "3"}]]}]}]]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.42317159478125*^9}, 3.4231748894375*^9, {3.423175010234375*^9, 
   3.42317501209375*^9}, {3.423332130828125*^9, 3.423332133125*^9}, {
   3.423332213890625*^9, 3.4233322145625*^9}, 3.42333402840625*^9, 
   3.423334110109375*^9, {3.423335295421875*^9, 3.423335298*^9}, {
   3.423338207796875*^9, 3.42333822128125*^9}, 3.4233411713125*^9, {
   3.423341493703125*^9, 3.42334150478125*^9}, 3.423342099703125*^9, 
   3.42334264096875*^9, {3.423343133015625*^9, 3.423343164421875*^9}, {
   3.42334322003125*^9, 3.42334322409375*^9}, {3.4902980694252477`*^9, 
   3.4902981224029408`*^9}, {3.490298213787901*^9, 3.4902982236003184`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", "c", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", "d"}], ")"}], " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "/", "3"}]]}]}]], " ", 
    SuperscriptBox["x", 
     RowBox[{"1", "/", "3"}]]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "d"}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", "c"}]], " ", 
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Erfi", "[", 
     RowBox[{
      SqrtBox[
       RowBox[{"b", "+", "d"}]], " ", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "3"}]]}], "]"}]}], 
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", "d"}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]]}]], "Output",
 CellChangeTimes->{{3.4902980769288607`*^9, 3.4902981228553414`*^9}, {
  3.49029821884231*^9, 3.490298224037119*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is unable to integrate the expression unless n is numeric:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.444322558662424*^9, 3.444322586131923*^9}, {
   3.4466780286625423`*^9, 3.446678029423637*^9}, {3.4466948967576723`*^9, 
   3.42317159478125*^9}, 3.423174910453125*^9, {3.423332331546875*^9, 
   3.423332347125*^9}, {3.423332380203125*^9, 3.42333240928125*^9}, {
   3.42333868671875*^9, 3.423338688046875*^9}, 3.423341072828125*^9, {
   3.423341192828125*^9, 3.42334120171875*^9}, {3.42334151903125*^9, 
   3.423341526171875*^9}, {3.423343196484375*^9, 3.423343210078125*^9}, 
   3.482196286235778*^9, {3.490297946786632*^9, 3.4902979705766735`*^9}, {
   3.490298500220004*^9, 3.4902985011092052`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"exp", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], ")"}], "*", "exp", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4443226390179696`*^9, {3.4443227656600723`*^9, 3.42317159478125*^9}, {
   3.42317501975*^9, 3.4231750424375*^9}, {3.423332442*^9, 
   3.423332460203125*^9}, {3.423335418203125*^9, 3.423335440078125*^9}, {
   3.4233388183125*^9, 3.423338825359375*^9}, {3.423341561578125*^9, 
   3.4233415969375*^9}, {3.4233421585*^9, 3.42334216565625*^9}, {
   3.423343503578125*^9, 3.42334350896875*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "n"]}]}]]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444322151807395*^9, 3.444322155682968*^9}, {
   3.444322192215499*^9, 3.444322246964224*^9}, {3.4443222773278847`*^9, 
   3.42317159478125*^9}, 3.4231748894375*^9, {3.423175010234375*^9, 
   3.42317501209375*^9}, {3.423332130828125*^9, 3.423332133125*^9}, {
   3.423332213890625*^9, 3.4233322145625*^9}, 3.42333402840625*^9, 
   3.423334110109375*^9, {3.423335295421875*^9, 3.423335298*^9}, {
   3.423338207796875*^9, 3.42333822128125*^9}, 3.4233411713125*^9, {
   3.423341493703125*^9, 3.42334150478125*^9}, 3.423342099703125*^9, 
   3.42334264096875*^9, {3.423343133015625*^9, 3.42334313728125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"exp", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "5"}]}]}], ")"}], "*", "exp", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "5"}]}]}], ")"}]}], ",", " ", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4443226390179696`*^9, {3.4443227656600723`*^9, 3.42317159478125*^9}, {
   3.42317501975*^9, 3.4231750424375*^9}, {3.423332442*^9, 
   3.423332460203125*^9}, {3.423335418203125*^9, 3.423335440078125*^9}, {
   3.4233388183125*^9, 3.423338825359375*^9}, {3.423341561578125*^9, 
   3.4233415969375*^9}, {3.4233421585*^9, 3.42334216565625*^9}, {
   3.42334348728125*^9, 3.42334349384375*^9}, {3.423343544875*^9, 
   3.42334354946875*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"a", "+", "c"}], "]"}], " ", "x", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Gamma", "[", 
        RowBox[{
         FractionBox["1", "5"], ",", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"b", "+", "d"}], ")"}]}], " ", 
          SuperscriptBox["x", "5"]}]}], "]"}]}], " ", 
      RowBox[{"Gamma", "[", 
       FractionBox["4", "5"], "]"}], " ", 
      RowBox[{"Sin", "[", 
       FractionBox["\[Pi]", "5"], "]"}]}], "+", "\[Pi]"}], ")"}]}], 
  RowBox[{"5", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Sin", "[", 
      FractionBox["\[Pi]", "5"], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"b", "+", "d"}], ")"}]}], " ", 
        SuperscriptBox["x", "5"]}], ")"}], 
      RowBox[{"1", "/", "5"}]], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["4", "5"], "]"}]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.423344271890625*^9, 3.423344367546875*^9}, {
  3.42334440184375*^9, 3.423344444546875*^9}, {3.423344497375*^9, 
  3.423344508296875*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"exp", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"2", "/", "3"}], ")"}]}]}]}], ")"}], "*", "exp", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"2", "/", "3"}], ")"}]}]}]}], ")"}]}], ",", " ", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4443226390179696`*^9, {3.4443227656600723`*^9, 3.42317159478125*^9}, {
   3.42317501975*^9, 3.4231750424375*^9}, {3.423332442*^9, 
   3.423332460203125*^9}, {3.423335418203125*^9, 3.423335440078125*^9}, {
   3.4233388183125*^9, 3.423338825359375*^9}, {3.423341561578125*^9, 
   3.4233415969375*^9}, {3.4233421585*^9, 3.42334216565625*^9}, {
   3.42334348728125*^9, 3.42334349384375*^9}, {3.423343544875*^9, 
   3.42334354946875*^9}, {3.4902983311157074`*^9, 3.4902983423321266`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", "c", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", "d"}], ")"}], " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "/", "3"}]]}]}]], " ", 
    SuperscriptBox["x", 
     RowBox[{"1", "/", "3"}]]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "d"}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "+", "c"}]], " ", 
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Erfi", "[", 
     RowBox[{
      SqrtBox[
       RowBox[{"b", "+", "d"}]], " ", 
      SuperscriptBox["x", 
       RowBox[{"1", "/", "3"}]]}], "]"}]}], 
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", "d"}], ")"}], 
     RowBox[{"3", "/", "2"}]]}]]}]], "Output",
 CellChangeTimes->{{3.4902980769288607`*^9, 3.4902981228553414`*^9}, {
  3.49029821884231*^9, 3.490298224037119*^9}}]
}, Closed]]
}, Open  ]]
},
AutoGeneratedPackage->None,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  None, None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{28.8, 28.8}, {14.4, 14.4}}},
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 488, 8, 69, "Title"],
Cell[1058, 32, 908, 22, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[1991, 58, 2801, 57, 34, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[4795, 117, 1075, 21, 66, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[5873, 140, 691, 24, 66, "Output"],
Cell[6567, 166, 1104, 22, 66, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[7674, 190, 1389, 49, 66, "Output"],
Cell[9066, 241, 1130, 23, 66, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[10199, 266, 1893, 61, 66, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[12129, 332, 2899, 59, 34, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[15031, 393, 868, 18, 73, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[15902, 413, 848, 27, 66, "Output"],
Cell[16753, 442, 904, 18, 73, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[17660, 462, 324, 10, 53, "Output"],
Cell[17987, 474, 927, 19, 73, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[18917, 495, 352, 11, 53, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[19306, 511, 2926, 58, 34, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[22235, 571, 798, 20, 55, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[23036, 593, 253, 8, 53, "Output"],
Cell[23292, 603, 806, 20, 55, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[24101, 625, 263, 8, 53, "Output"],
Cell[24367, 635, 835, 21, 55, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[25205, 658, 288, 9, 53, "Output"]
}, Closed]],
Cell[25508, 670, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[25589, 676, 516, 9, 69, "Title"],
Cell[26108, 687, 932, 22, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[27065, 713, 2829, 58, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[29897, 773, 1099, 21, 61, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[30999, 796, 737, 25, 62, "Output"],
Cell[31739, 823, 1158, 23, 61, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[32900, 848, 1511, 53, 63, "Output"],
Cell[34414, 903, 1180, 24, 61, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[35597, 929, 2493, 82, 63, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[38127, 1016, 2921, 59, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[41051, 1077, 892, 18, 73, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[41946, 1097, 894, 28, 62, "Output"],
Cell[42843, 1127, 932, 19, 73, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[43778, 1148, 348, 10, 53, "Output"],
Cell[44129, 1160, 953, 20, 73, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[45085, 1182, 374, 11, 53, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[45496, 1198, 2978, 59, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[48477, 1259, 822, 20, 55, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[49302, 1281, 320, 9, 53, "Input"],
Cell[49625, 1292, 830, 20, 55, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[50458, 1314, 328, 9, 53, "Input"],
Cell[50789, 1325, 859, 21, 55, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[51651, 1348, 357, 10, 53, "Input"]
}, Closed]],
Cell[52023, 1361, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[52104, 1367, 538, 9, 69, "Title"],
Cell[52645, 1378, 938, 24, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[53608, 1406, 1487, 29, 31, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[55098, 1437, 891, 17, 49, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[55992, 1456, 618, 20, 55, "Output"],
Cell[56613, 1478, 1060, 24, 49, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[57676, 1504, 817, 29, 55, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[58530, 1538, 1381, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[59914, 1562, 822, 16, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[60739, 1580, 672, 22, 55, "Output"],
Cell[61414, 1604, 1022, 23, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[62439, 1629, 790, 19, 43, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[63266, 1653, 1392, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[64661, 1677, 688, 17, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[65352, 1696, 207, 6, 43, "Output"],
Cell[65562, 1704, 865, 23, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[66430, 1729, 790, 19, 43, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[67235, 1751, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[67316, 1757, 640, 10, 69, "Title"],
Cell[67959, 1769, 981, 23, 73, "Subtitle"],
Cell[CellGroupData[{
Cell[68965, 1796, 1203, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[70171, 1818, 764, 16, 60, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[70938, 1836, 864, 24, 58, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[71839, 1865, 1200, 21, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[73042, 1888, 844, 18, 60, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[73889, 1908, 597, 18, 55, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[74523, 1931, 1302, 21, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[75828, 1954, 563, 17, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[76394, 1973, 994, 36, 56, "Output"]
}, Closed]],
Cell[77403, 2012, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[77484, 2018, 614, 10, 69, "Title"],
Cell[78101, 2030, 988, 24, 76, "Subtitle"],
Cell[CellGroupData[{
Cell[79114, 2058, 1054, 19, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[80171, 2079, 708, 15, 60, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[80882, 2096, 437, 15, 46, "Output"],
Cell[81322, 2113, 800, 17, 62, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[82125, 2132, 623, 22, 51, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[82785, 2159, 1043, 21, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[83831, 2182, 785, 17, 60, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[84619, 2201, 470, 13, 46, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[85092, 2216, 821, 18, 62, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[85916, 2236, 261, 9, 49, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[86214, 2250, 1132, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[87349, 2272, 884, 21, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[88236, 2295, 379, 13, 46, "Output"],
Cell[88618, 2310, 912, 22, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[89533, 2334, 465, 17, 51, "Output"]
}, Closed]],
Cell[90013, 2354, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[90094, 2360, 590, 10, 69, "Title"],
Cell[90687, 2372, 925, 23, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[91637, 2399, 1497, 23, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[93137, 2424, 1080, 23, 65, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[94220, 2449, 863, 26, 62, "Output"],
Cell[95086, 2477, 1125, 23, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[96214, 2502, 666, 23, 69, "Output"],
Cell[96883, 2527, 1288, 27, 67, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[98174, 2556, 980, 33, 63, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[99191, 2594, 1266, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[100460, 2616, 1081, 23, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[101544, 2641, 1004, 20, 52, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[102551, 2663, 1130, 24, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[103684, 2689, 692, 23, 69, "Output"],
Cell[104379, 2714, 1290, 27, 72, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[105672, 2743, 1005, 33, 63, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[106714, 2781, 1312, 21, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[108029, 2804, 885, 23, 56, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[108917, 2829, 1052, 22, 52, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[109972, 2853, 930, 24, 56, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[110905, 2879, 1209, 38, 72, "Output"],
Cell[112117, 2919, 1108, 28, 56, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[113228, 2949, 1005, 33, 63, "Output"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
