(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    361969,       8560]
NotebookOptionsPosition[    347686,       8232]
NotebookOutlinePosition[    348808,       8271]
CellTagsIndexPosition[    348765,       8268]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.494439343783562*^9, 3.494441172446122*^9, 
   3.4944629636440496`*^9, 3.4944649657213383`*^9, {3.4947195191682806`*^9, 
   3.494719523278286*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{"p", "<", 
   RowBox[{"-", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9, {3.494464984351364*^9, 3.4944650253214216`*^9}, 
   3.494465653082301*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                        ", "\[IndentingNewLine]", 
      "             ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", " ", 
           RowBox[{"ProductLog", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "p"]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["p", 
    RowBox[{"c", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", " ", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], 
       RowBox[{"p", "+", "1"}]], 
      RowBox[{"1", "+", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4944393492135696`*^9, 3.494439366993595*^9}, 
   3.4944395044737873`*^9, {3.4944412966462965`*^9, 3.4944413255163364`*^9}, 
   3.4944631289419403`*^9, 3.4944639664899397`*^9, 3.4944651248415613`*^9, 
   3.4944651836716433`*^9, {3.494719580528366*^9, 3.4947195891583786`*^9}, {
   3.4948858444942675`*^9, 3.494885881731533*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c_.", "*", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"p", "/", 
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "*", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"ProductLog", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494439298133498*^9, 
   3.4944411032260256`*^9, 3.494462988260893*^9, 3.494464917621271*^9, 
   3.49471956848835*^9, {3.4947196205384226`*^9, 3.4947196434484544`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9, {3.494464984351364*^9, 3.4944650253214216`*^9}, 
   3.494465653082301*^9, {3.4947239320044584`*^9, 3.494723936214464*^9}}],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                        ", "\[IndentingNewLine]", 
      "                            ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", " ", 
           RowBox[{"ProductLog", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "p"]}], "b"]}]}]}]}], 
  "-", 
  RowBox[{"p", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", " ", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "p"], 
      RowBox[{"1", "+", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, {3.4944393463335657`*^9, 
   3.4944393633235893`*^9}, 3.4944394680437365`*^9, {3.4944412518762336`*^9, 
   3.494441273186263*^9}, {3.494463807599717*^9, 3.4944638371197586`*^9}, 
   3.4944651158515487`*^9, 3.4944651583516083`*^9, {3.4947195300082955`*^9, 
   3.4947195356783037`*^9}, {3.4948859403252363`*^9, 3.4948859515104556`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c_.", "*", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "p_."}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", "p"}], "/", 
      "b"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"p", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "*", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", "p"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"ProductLog", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
      RowBox[{"p", "<", 
       RowBox[{"-", "1"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.494439288643485*^9, 3.4944410948660135`*^9, 3.494462978308076*^9, 
   3.49446490938126*^9, {3.4947195506483245`*^9, 3.4947195555383315`*^9}, {
   3.494719606678403*^9, 3.494719632258439*^9}, {3.494723822344305*^9, 
   3.4947238246143084`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.494439343783562*^9, 3.494441172446122*^9, 
   3.4944629636440496`*^9, 3.4944649657213383`*^9, 3.494465352051879*^9, 
   3.4945306855300684`*^9, {3.494714155460313*^9, 3.4947141577503166`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9, {3.494464984351364*^9, 3.4944650001413865`*^9}, 
   3.494465642722286*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], 
      RowBox[{"b", " ", "d", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, {3.4944393463335657`*^9, 
   3.4944393633235893`*^9}, 3.4944394680437365`*^9, {3.4944412518762336`*^9, 
   3.494441273186263*^9}, {3.494463807599717*^9, 3.4944638371197586`*^9}, 
   3.4944651158515487`*^9, 3.4944651583516083`*^9, {3.4944656758323326`*^9, 
   3.4944656994823656`*^9}, {3.4947141610903215`*^9, 3.494714166130328*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", "*", "x"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"b", "*", "d", "*", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "d"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.494439288643485*^9, 3.4944410948660135`*^9, 3.494462978308076*^9, 
   3.49446490938126*^9, 3.494465373361909*^9, {3.4947141713703356`*^9, 
   3.494714192190365*^9}, 3.494720478569624*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "p"], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.494439343783562*^9, 3.494441172446122*^9, 
   3.4944629636440496`*^9, 3.4944649657213383`*^9, 3.494465352051879*^9, {
   3.4947214166309366`*^9, 3.4947214184709396`*^9}, 3.4947229680231085`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9, 3.494465499612086*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["z", 
    RowBox[{"1", "+", "z"}]], "=", 
   RowBox[{"1", "-", 
    FractionBox["1", 
     RowBox[{"1", "+", "z"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9, {3.494465499612086*^9, 
   3.4944655112721024`*^9}, 3.494465544312148*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9, {3.494464984351364*^9, 3.4944650253214216`*^9}, 
   3.4944657164023895`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"d", "+", 
      RowBox[{"d", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "d"}]}], " ", "x"}]}], "-", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"d", "+", 
      RowBox[{"d", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4944393492135696`*^9, 3.494439366993595*^9}, 
   3.4944395044737873`*^9, {3.4944412966462965`*^9, 3.4944413255163364`*^9}, 
   3.4944631289419403`*^9, 3.4944639664899397`*^9, 3.4944651248415613`*^9, 
   3.4944651836716433`*^9, {3.494465728242406*^9, 3.4944657589424486`*^9}, {
   3.4947215645811443`*^9, 3.4947215672511477`*^9}, {3.4947216922813225`*^9, 
   3.4947216926613235`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ProductLog", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "*", "x"}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"d", "*", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "d"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494439298133498*^9, 
   3.4944411032260256`*^9, 3.494462988260893*^9, 3.494464917621271*^9, 
   3.4944653825319223`*^9, {3.494721699481333*^9, 3.4947217256913695`*^9}, {
   3.4947217720914345`*^9, 3.494721774201438*^9}, {3.4947219490416822`*^9, 
   3.4947219493316827`*^9}, 3.494725629546835*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 3.4944650748714914`*^9}, 
   3.4944660828729024`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"d", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}]}], ")"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"ExpIntegralEi", "[", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
      RowBox[{"b", " ", "d"}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, {3.494465794572499*^9, 3.4944658409125633`*^9}, {
   3.494721573011156*^9, 3.4947215765811605`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ProductLog", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{"d_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a_.", "+", 
            RowBox[{"b_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"b", "*", "d"}], ")"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "d"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, 3.4944653931619368`*^9, 3.4947217311113772`*^9, {
   3.4947218008814745`*^9, 3.494721803741479*^9}, {3.494721953991689*^9, 
   3.49472195421169*^9}, {3.4947219857917337`*^9, 3.4947219914217415`*^9}, 
   3.494725651076865*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"c", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.4944659269926844`*^9, 3.4944659287626867`*^9}, 
   3.494722502642457*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}], 
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"d", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}]}], ")"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{"\[Pi]", " ", "c"}]], " "}], 
      RowBox[{"b", " ", "c", " ", "d"}]]}]}], 
   RowBox[{"Erfi", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}]], 
     SqrtBox["c"]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, {3.494465878752617*^9, 3.494465907002656*^9}, {
   3.4947215808911667`*^9, 3.4947215841011715`*^9}, {3.494722193552025*^9, 
   3.494722198872032*^9}, {3.4947222334520807`*^9, 3.494722234172082*^9}, {
   3.4947224177923384`*^9, 3.494722422302345*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", "x_"}]}], "]"}]}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{"d_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a_.", "+", 
            RowBox[{"b_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{"Pi", "*", "c"}], ",", "2"}], "]"}], "*", 
    RowBox[{
     RowBox[{"Erfi", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}]}], "]"}], "/", 
       RowBox[{"Rt", "[", 
        RowBox[{"c", ",", "2"}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "c", "*", "d"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"PosQ", "[", "c", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, 3.4944653931619368`*^9, 3.4944654303019886`*^9, 
   3.494721738141387*^9, {3.494721812461491*^9, 3.494721815101495*^9}, {
   3.4947219634217024`*^9, 3.4947219645217037`*^9}, {3.4947222899321594`*^9, 
   3.4947223358022237`*^9}, {3.494722413892333*^9, 3.4947224143323336`*^9}, {
   3.494722514142473*^9, 3.494722517652478*^9}, 3.494725656796873*^9, {
   3.494727484049431*^9, 3.494727503829459*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"c", "<", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.4944659269926844`*^9, 
   3.4944659287626867`*^9}, {3.494722502642457*^9, 3.4947225301624956`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}], 
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"d", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}]}], ")"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{"-", "\[Pi]"}], " ", "c"}]], " "}], 
      RowBox[{"b", " ", "c", " ", "d"}]]}]}], 
   RowBox[{"Erf", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}]], 
     SqrtBox[
      RowBox[{"-", "c"}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, {3.494465878752617*^9, 3.494465907002656*^9}, {
   3.4947215808911667`*^9, 3.4947215841011715`*^9}, {3.494722193552025*^9, 
   3.494722198872032*^9}, {3.4947222334520807`*^9, 3.494722234172082*^9}, {
   3.4947224177923384`*^9, 3.494722422302345*^9}, {3.494722537242506*^9, 
   3.4947225454925175`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", "x_"}]}], "]"}]}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{"d_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a_.", "+", 
            RowBox[{"b_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "Pi"}], "*", "c"}], ",", "2"}], "]"}], "*", 
    RowBox[{
     RowBox[{"Erf", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}]}], "]"}], "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", "2"}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "c", "*", "d"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NegQ", "[", "c", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, 3.4944653931619368`*^9, 3.4944654303019886`*^9, 
   3.494721738141387*^9, {3.494721812461491*^9, 3.494721815101495*^9}, {
   3.4947219634217024`*^9, 3.4947219645217037`*^9}, {3.4947222899321594`*^9, 
   3.4947223358022237`*^9}, {3.494722413892333*^9, 3.4947224143323336`*^9}, {
   3.494722514142473*^9, 3.4947225339725013`*^9}, {3.49472256908255*^9, 
   3.494722574662558*^9}, 3.494725671176893*^9, {3.4947275073094635`*^9, 
   3.494727515509475*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"p", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.4944659269926844`*^9, 3.4944659287626867`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "p"], 
     RowBox[{"d", "+", 
      RowBox[{"d", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                                        ", 
      "\[IndentingNewLine]", 
      "                                                  ", 
      FractionBox[
       RowBox[{"c", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", " ", 
           RowBox[{"ProductLog", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], 
         RowBox[{"p", "-", "1"}]]}], 
       RowBox[{"b", " ", "d"}]]}]}]}]}], "-", 
  RowBox[{"c", " ", "p", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", " ", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], 
       RowBox[{"p", "-", "1"}]], 
      RowBox[{"d", "+", 
       RowBox[{"d", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, 3.494465951712719*^9, 3.49446604563285*^9, {
   3.4947215884411774`*^9, 3.4947215928811836`*^9}, {3.494722660752679*^9, 
   3.49472268295271*^9}, {3.494886000400942*^9, 3.4948860278257895`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "p_"}], "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"c", "*", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "*", "p"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "*", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"d", "*", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, 3.4944653931619368`*^9, 3.4944654392420015`*^9, 
   3.4947217434313946`*^9, 3.4947217834214506`*^9, {3.494721826471511*^9, 
   3.494721828751514*^9}, 3.494721970171712*^9, {3.494722738752788*^9, 
   3.494722744462796*^9}, {3.494722778252843*^9, 3.494722806792883*^9}, 
   3.4947256874769163`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"p", "<", 
   RowBox[{"-", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.4944659643427362`*^9, 3.494465966342739*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "p"], 
     RowBox[{"d", "+", 
      RowBox[{"d", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                                        ", 
      "\[IndentingNewLine]", "                                         ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", " ", 
           RowBox[{"ProductLog", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "p"]}], 
       RowBox[{"b", "  ", "d", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"c", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", " ", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], 
       RowBox[{"p", "+", "1"}]], 
      RowBox[{"d", "+", 
       RowBox[{"d", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, 3.4944659951327796`*^9, 3.4944660479228535`*^9, {
   3.494721599041192*^9, 3.4947216069612036`*^9}, {3.4947227027827377`*^9, 
   3.494722713162752*^9}, {3.4948860352982025`*^9, 3.4948860479030247`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "p_"}], "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "*", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"d", "*", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, 3.4944653931619368`*^9, 3.494465447372013*^9, 
   3.494466026152823*^9, 3.494721748321401*^9, 3.4947217871814556`*^9, {
   3.4947218329115195`*^9, 3.49472183311152*^9}, 3.494722751662806*^9, {
   3.494722808712886*^9, 3.4947228246729083`*^9}, {3.4947228723029747`*^9, 
   3.49472287583298*^9}, 3.49472569770693*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466410603361*^9, 3.4944664524334197`*^9}, 
   3.4944682621759534`*^9, 3.494707601491044*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "p"], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       RowBox[{"Gamma", "[", 
        RowBox[{
         RowBox[{"p", "+", "1"}], ",", 
         RowBox[{"-", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], "]"}]}]}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "p"]}], 
      RowBox[{"b", " ", "d", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], 
        "p"]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, 3.494466612693644*^9, 3.4944667280538054`*^9, {
   3.4944670878643093`*^9, 3.4944670907543135`*^9}, 3.4944672123744836`*^9, 
   3.4944674596448298`*^9, 3.4944676503050966`*^9, {3.4947066344796906`*^9, 
   3.494706639089697*^9}, {3.4947074014107637`*^9, 3.4947074299908037`*^9}, {
   3.49470760584105*^9, 3.494707640021098*^9}, {3.4947077152512035`*^9, 
   3.4947077159612045`*^9}, {3.494720050689025*^9, 3.4947200515490255`*^9}, {
   3.494724353355048*^9, 3.494724386565095*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "p_."}], "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Gamma", "[", 
     RowBox[{
      RowBox[{"p", "+", "1"}], ",", 
      RowBox[{"-", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}]}], "]"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", "p"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "d", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}]}], ")"}], "^", "p"}]}], 
      ")"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "p"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, {3.494466197663063*^9, 3.4944662173730907`*^9}, 
   3.494466972604148*^9, 3.4944673758047123`*^9, 3.4944674170647707`*^9, {
   3.4944682702259645`*^9, 3.494468284195984*^9}, {3.494706652639716*^9, 
   3.494706666339735*^9}, {3.494707466120855*^9, 3.4947075018509045`*^9}, {
   3.4947076545511184`*^9, 3.494707711211198*^9}, {3.4947200547690306`*^9, 
   3.494720059389037*^9}, 3.494721513471072*^9, {3.4947244247751484`*^9, 
   3.4947244593451967`*^9}, {3.494724503115258*^9, 3.494724503485258*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.494439343783562*^9, 3.494441172446122*^9, 
   3.4944629636440496`*^9, 3.4944649657213383`*^9, 3.494466149562996*^9, 
   3.4947143054905233`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.4944413869064226`*^9, 3.4944413884864244`*^9}, 
   3.4944630322217703`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466410603361*^9, 3.4944664524334197`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["a", "b"]}], "+", 
          FractionBox["x", "b"]}], ")"}], "m"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          RowBox[{"ProductLog", "[", "x", "]"}]}], ")"}], "p"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, 3.494466612693644*^9, 3.4944667280538054`*^9, {
   3.4947143113905315`*^9, 3.494714320890545*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "p_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Dist", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"c", "*", 
              RowBox[{"ProductLog", "[", "x", "]"}]}], ")"}], "^", "p"}], ",", 
           RowBox[{"Expand", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "a"}], "/", "b"}], "+", 
               RowBox[{"x", "/", "b"}]}], ")"}], "^", "m"}], "]"}]}], "]"}], 
         ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, {3.494466197663063*^9, 3.4944662173730907`*^9}, {
   3.494714349020584*^9, 3.494714379260627*^9}, {3.494782897059314*^9, 
   3.494782907526932*^9}, {3.4947833063104324`*^9, 3.4947833272768693`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.494439343783562*^9, 3.494441172446122*^9, 
   3.4944629636440496`*^9, 3.4944649657213383`*^9, 3.494466149562996*^9, 
   3.4944669300040884`*^9, {3.4947139732200584`*^9, 3.4947139750200605`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.4944413869064226`*^9, 3.4944413884864244`*^9}, 
   3.4944630322217703`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466410603361*^9, 3.4944664524334197`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            FractionBox["a", "b"]}], "+", 
           FractionBox["x", "b"]}], ")"}], "m"], 
        RowBox[{"d", "+", 
         RowBox[{"d", " ", 
          RowBox[{"ProductLog", "[", "x", "]"}]}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, 3.494466612693644*^9, 3.4944667280538054`*^9, {
   3.4944670878643093`*^9, 3.4944670907543135`*^9}, 3.4944672123744836`*^9, {
   3.4947139825500712`*^9, 3.49471398898008*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Dist", "[", 
          RowBox[{
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"d", "*", 
               RowBox[{"ProductLog", "[", "x", "]"}]}]}], ")"}]}], ",", 
           RowBox[{"Expand", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "a"}], "/", "b"}], "+", 
               RowBox[{"x", "/", "b"}]}], ")"}], "^", "m"}], "]"}]}], "]"}], 
         ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, {3.494466197663063*^9, 3.4944662173730907`*^9}, 
   3.494466972604148*^9, {3.4947140140801153`*^9, 3.494714028270135*^9}, {
   3.4947829285245686`*^9, 3.494782933610178*^9}, {3.4947833550137177`*^9, 
   3.494783379583761*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "p"]}], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.494439343783562*^9, 3.494441172446122*^9, 
   3.4944629636440496`*^9, 3.4944649657213383`*^9, 3.494466149562996*^9, 
   3.4944669300040884`*^9, {3.4947139732200584`*^9, 3.4947139750200605`*^9}, 
   3.494719243197894*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.4944413869064226`*^9, 3.4944413884864244`*^9}, 
   3.4944630322217703`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466410603361*^9, 3.4944664524334197`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], "p"]}], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             FractionBox["a", "b"]}], "+", 
            FractionBox["x", "b"]}], ")"}], "m"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", " ", 
            RowBox[{"ProductLog", "[", "x", "]"}]}], ")"}], "p"]}], 
        RowBox[{"d", "+", 
         RowBox[{"d", " ", 
          RowBox[{"ProductLog", "[", "x", "]"}]}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, 3.494466612693644*^9, 3.4944667280538054`*^9, {
   3.4944670878643093`*^9, 3.4944670907543135`*^9}, 3.4944672123744836`*^9, {
   3.4947139825500712`*^9, 3.49471398898008*^9}, {3.4947192505479045`*^9, 
   3.4947192725379353`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_", "+", 
           RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ")"}], "^", "p_."}], "/", 
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_", "+", 
           RowBox[{"b_.", "*", "x_"}]}], "]"}]}]}], ")"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Dist", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"c", "*", 
               RowBox[{"ProductLog", "[", "x", "]"}]}], ")"}], "^", "p"}], 
            "/", 
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"d", "*", 
               RowBox[{"ProductLog", "[", "x", "]"}]}]}], ")"}]}], ",", 
           RowBox[{"Expand", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "a"}], "/", "b"}], "+", 
               RowBox[{"x", "/", "b"}]}], ")"}], "^", "m"}], "]"}]}], "]"}], 
         ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, {3.494466197663063*^9, 3.4944662173730907`*^9}, 
   3.494466972604148*^9, {3.4947140140801153`*^9, 3.494714028270135*^9}, {
   3.4947193005379744`*^9, 3.494719358598056*^9}, {3.4947829435941954`*^9, 
   3.4947829487578044`*^9}, {3.4947834071178093`*^9, 3.494783418209429*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.494439343783562*^9, 3.494441172446122*^9, 
   3.4944629636440496`*^9, 3.4944649657213383`*^9, 3.494466149562996*^9, 
   3.4944684037161517`*^9, {3.494640277756195*^9, 3.494640283201506*^9}, 
   3.494707980781575*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"n", 
     RowBox[{"(", 
      RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], "=", 
   RowBox[{"0", " ", "\[Or]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"p", "-", 
         FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
       " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"n", 
         RowBox[{"(", 
          RowBox[{"p", "-", 
           FractionBox["1", "2"]}], ")"}]}], "+", "1"}]}], "=", "0"}], 
     ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9, {3.494464984351364*^9, 3.4944650001413865`*^9}, 
   3.4944656497622957`*^9, 3.4944665539935617`*^9, {3.494466786573888*^9, 
   3.494466789013891*^9}, {3.494468882130024*^9, 3.494468984350167*^9}, 
   3.494469094270321*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"]}]}], "-", 
  RowBox[{"n", " ", "p", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", " ", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"], 
      RowBox[{"1", "+", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, {3.4944393463335657`*^9, 
   3.4944393633235893`*^9}, 3.4944394680437365`*^9, {3.4944412518762336`*^9, 
   3.494441273186263*^9}, {3.494463807599717*^9, 3.4944638371197586`*^9}, 
   3.4944651158515487`*^9, 3.4944651583516083`*^9, {3.494466570013584*^9, 
   3.494466572673588*^9}, 3.494466647603693*^9, 3.494468418586172*^9, 
   3.4944687111765823`*^9, {3.4946406276882095`*^9, 3.4946406431100917`*^9}, {
   3.494707982811578*^9, 3.494707989121587*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c_.", "*", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a_.", "*", 
         RowBox[{"x_", "^", "n_"}]}], "]"}]}], ")"}], "^", "p_."}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", "p"}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", "p"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "*", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", "p"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"ProductLog", "[", 
            RowBox[{"a", "*", 
             RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "n", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"n", "*", 
         RowBox[{"(", 
          RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"IntegerQ", "[", 
        RowBox[{"p", "-", 
         RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
       RowBox[{"ZeroQ", "[", 
        RowBox[{
         RowBox[{"n", "*", 
          RowBox[{"(", 
           RowBox[{"p", "-", 
            RowBox[{"1", "/", "2"}]}], ")"}]}], "+", "1"}], "]"}]}]}], 
     ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.494439288643485*^9, 3.4944410948660135`*^9, 3.494462978308076*^9, 
   3.49446490938126*^9, 3.494466161643013*^9, 3.494468436046197*^9, {
   3.4946406594020233`*^9, 3.4946406952030716`*^9}, {3.4947079924115915`*^9, 
   3.4947079989716005`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
      " ", 
      RowBox[{
       RowBox[{"n", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}]}], "=", "0"}], ")"}], 
   " ", "\[Or]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"p", "-", 
        FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
      " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"n", 
        RowBox[{"(", 
         RowBox[{"p", "+", 
          FractionBox["1", "2"]}], ")"}]}], "+", "1"}]}], "=", "0"}], 
    ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9, {3.494464984351364*^9, 3.4944650253214216`*^9}, 
   3.494465653082301*^9, {3.4944664950434794`*^9, 3.494466513563505*^9}, {
   3.494469011690205*^9, 3.4944690889003134`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", " ", 
           RowBox[{"ProductLog", "[", 
            RowBox[{"a", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"]}], 
       RowBox[{
        RowBox[{"n", " ", "p"}], "+", "1"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", "p"}], 
    RowBox[{"c", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"n", " ", "p"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", " ", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}], ")"}], 
       RowBox[{"p", "+", "1"}]], 
      RowBox[{"1", "+", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4944393492135696`*^9, 3.494439366993595*^9}, 
   3.4944395044737873`*^9, {3.4944412966462965`*^9, 3.4944413255163364`*^9}, 
   3.4944631289419403`*^9, 3.4944639664899397`*^9, 3.4944651248415613`*^9, 
   3.4944651836716433`*^9, {3.4944665849436054`*^9, 3.494466587053608*^9}, 
   3.4944666721637273`*^9, 3.4944684214061766`*^9, 3.4944687471966324`*^9, {
   3.494640734219303*^9, 3.4946407441038685`*^9}, {3.4946407840501533`*^9, 
   3.4946407871143284`*^9}, {3.494708000621603*^9, 3.494708004841609*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c_.", "*", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a_.", "*", 
         RowBox[{"x_", "^", "n_"}]}], "]"}]}], ")"}], "^", "p_."}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"n", "*", "p"}], "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", "*", "p"}], "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "*", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"ProductLog", "[", 
            RowBox[{"a", "*", 
             RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"IntegerQ", "[", "p", "]"}], " ", "&&", " ", 
       RowBox[{"ZeroQ", "[", 
        RowBox[{
         RowBox[{"n", "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "]"}]}], " ", "||", 
      " ", 
      RowBox[{
       RowBox[{"IntegerQ", "[", 
        RowBox[{"p", "-", 
         RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
       RowBox[{"ZeroQ", "[", 
        RowBox[{
         RowBox[{"n", "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"1", "/", "2"}]}], ")"}]}], "+", "1"}], "]"}]}]}], 
     ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494439298133498*^9, 
   3.4944411032260256`*^9, 3.494462988260893*^9, 3.494464917621271*^9, 
   3.494466188753051*^9, 3.4944684435862074`*^9, {3.4946408092795963`*^9, 
   3.49464083679817*^9}, {3.494708007611613*^9, 3.4947080144716225`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9, 3.494465499612086*^9, 
   3.4944684694762435`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
   RowBox[{"-", 
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"\[Integral]", 
       RowBox[{
        FractionBox[
         RowBox[{"f", "[", 
          FractionBox["1", "x"], "]"}], 
         SuperscriptBox["x", "2"]], 
        RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
      FractionBox["1", "x"]}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9, {3.494465499612086*^9, 
   3.4944655112721024`*^9}, 3.494465544312148*^9, 3.4944663200732346`*^9, {
   3.4944686423964853`*^9, 3.4944686449964895`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466465553438*^9, 3.4944664752134514`*^9}, {
   3.494468673256529*^9, 3.4944686817265406`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"\[Integral]", 
         RowBox[{
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"c", " ", 
              RowBox[{"ProductLog", "[", 
               RowBox[{"a", " ", 
                SuperscriptBox["x", 
                 RowBox[{"-", "n"}]]}], "]"}]}], ")"}], "p"], 
           SuperscriptBox["x", "2"]], 
          RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
        FractionBox["1", "x"]}], "]"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, {3.4944665968236217`*^9, 3.4944665991136255`*^9}, 
   3.4944667003037667`*^9, 3.4944684249561815`*^9, 3.4944687851066856`*^9, {
   3.494640885694967*^9, 3.494640898892722*^9}, {3.4947080253016376`*^9, 
   3.49470802698164*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c_.", "*", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a_.", "*", 
         RowBox[{"x_", "^", "n_"}]}], "]"}]}], ")"}], "^", "p_."}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "*", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"-", "n"}], ")"}]}]}], "]"}]}], ")"}], "^", "p"}], 
         "/", 
         RowBox[{"x", "^", "2"}]}], ",", "x"}], "]"}], ",", "x", ",", 
      RowBox[{"1", "/", "x"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, 3.494466197663063*^9, 3.4944684515462184`*^9, {
   3.4946409130535316`*^9, 3.49464092596527*^9}, {3.494708029411643*^9, 
   3.494708032121647*^9}, {3.494872260361537*^9, 3.494872260860738*^9}, {
   3.4948723899071417`*^9, 3.494872393927148*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.494439343783562*^9, 3.494441172446122*^9, 
   3.4944629636440496`*^9, 3.4944649657213383`*^9, 3.494466149562996*^9, 
   3.4944669300040884`*^9, 3.494467288914591*^9, 3.494469215750491*^9, 
   3.4944751340388145`*^9, {3.4947081603918266`*^9, 3.4947081632718306`*^9}, 
   3.4947083249020567`*^9, 3.4947119955372896`*^9, {3.4947199592788963`*^9, 
   3.494719959718897*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9, 3.494465499612086*^9, 
   3.4944684694762435`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
   RowBox[{"-", 
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"\[Integral]", 
       RowBox[{
        FractionBox[
         RowBox[{"f", "[", 
          FractionBox["1", "x"], "]"}], 
         SuperscriptBox["x", "2"]], 
        RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
      FractionBox["1", "x"]}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9, {3.494465499612086*^9, 
   3.4944655112721024`*^9}, 3.494465544312148*^9, 3.4944663200732346`*^9, {
   3.4944686423964853`*^9, 3.4944686449964895`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466410603361*^9, 3.4944664524334197`*^9}, {
   3.4944682111458817`*^9, 3.4944682224058976`*^9}, {3.4944697034911737`*^9, 
   3.494469716641192*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"\[Integral]", 
         RowBox[{
          FractionBox["1", 
           RowBox[{
            SuperscriptBox["x", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"d", " ", 
               RowBox[{"ProductLog", "[", 
                RowBox[{"a", " ", 
                 SuperscriptBox["x", 
                  RowBox[{"-", "n"}]]}], "]"}]}]}], ")"}]}]], 
          RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
        FractionBox["1", "x"]}], "]"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, 3.494466612693644*^9, 3.4944667280538054`*^9, {
   3.4944670878643093`*^9, 3.4944670907543135`*^9}, 3.4944672123744836`*^9, 
   3.494467455604824*^9, 3.4944675970350223`*^9, 3.494469332370654*^9, 
   3.4944695079909*^9, {3.494475252638981*^9, 3.494475254758984*^9}, 
   3.494475454849264*^9, {3.4947082231619143`*^9, 3.494708231421926*^9}, {
   3.4947199633289022`*^9, 3.4947199655289054`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"x", "^", "2"}], "*", 
           RowBox[{"(", 
            RowBox[{"d", "+", 
             RowBox[{"d", "*", 
              RowBox[{"ProductLog", "[", 
               RowBox[{"a", "*", 
                RowBox[{"x", "^", 
                 RowBox[{"(", 
                  RowBox[{"-", "n"}], ")"}]}]}], "]"}]}]}], ")"}]}], ")"}]}], 
        ",", "x"}], "]"}], ",", "x", ",", 
      RowBox[{"1", "/", "x"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, {3.494466197663063*^9, 3.4944662173730907`*^9}, 
   3.494466972604148*^9, {3.4944673758047123`*^9, 3.4944674018947487`*^9}, 
   3.494469268060564*^9, 3.4944751973489037`*^9, {3.494708467902257*^9, 
   3.4947084850122814`*^9}, {3.494719966528907*^9, 3.4947199715189137`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.494439343783562*^9, 3.494441172446122*^9, 
   3.4944629636440496`*^9, 3.4944649657213383`*^9, 3.494466149562996*^9, 
   3.4944669300040884`*^9, 3.494467288914591*^9, 3.494469215750491*^9, {
   3.4945594883861685`*^9, 3.4945594934861755`*^9}, {3.494698202757886*^9, 
   3.4946982073378925`*^9}, {3.494719972968916*^9, 3.494719973308916*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"n", 
     RowBox[{"(", 
      RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9, {3.494464984351364*^9, 3.4944650001413865`*^9}, 
   3.4944656497622957`*^9, 3.4944665539935617`*^9, {3.494466786573888*^9, 
   3.494466789013891*^9}, {3.4944670185442123`*^9, 3.4944670190942135`*^9}, {
   3.4944676791451373`*^9, 3.4944676822551413`*^9}, {3.4944678801354184`*^9, 
   3.4944678822154217`*^9}, {3.4944679322254915`*^9, 3.494467942265506*^9}, {
   3.494469569200986*^9, 3.494469581531003*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"c", " ", "x", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", " ", 
            SuperscriptBox["x", "n"]}], "]"}]}], ")"}], 
        RowBox[{"p", "-", "1"}]]}], "d"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, {3.4944393463335657`*^9, 
   3.4944393633235893`*^9}, 3.4944394680437365`*^9, {3.4944412518762336`*^9, 
   3.494441273186263*^9}, {3.494463807599717*^9, 3.4944638371197586`*^9}, 
   3.4944651158515487`*^9, 3.4944651583516083`*^9, {3.494466570013584*^9, 
   3.494466572673588*^9}, 3.494466647603693*^9, {3.494467057404267*^9, 
   3.4944670607942715`*^9}, 3.49446712395436*^9, 3.4944674468548117`*^9, 
   3.49446751686491*^9, 3.494469319790636*^9, 3.4944693650506997`*^9, {
   3.494561007588295*^9, 3.494561023948318*^9}, {3.494698218687908*^9, 
   3.4946982483379498`*^9}, {3.494719974438918*^9, 3.4947199754089193`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}], ")"}], "^", "p_."}], "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"c", "*", "x", "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "-", "1"}], ")"}]}], "/", "d"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.494439288643485*^9, 3.4944410948660135`*^9, 3.494462978308076*^9, 
   3.49446490938126*^9, 3.494466161643013*^9, 3.494466944194108*^9, 
   3.494467346814672*^9, {3.494467887745429*^9, 3.4944678903654327`*^9}, 
   3.494469230760512*^9, {3.4945610855884047`*^9, 3.4945611179684496`*^9}, {
   3.494698315958044*^9, 3.4946983520880947`*^9}, {3.494719976728921*^9, 
   3.494719980308926*^9}, 3.4947208318401184`*^9, 3.494721502061056*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", "n"}], "=", 
   RowBox[{"-", 
    FractionBox["1", "p"]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9, {3.494464984351364*^9, 3.4944650253214216`*^9}, 
   3.494465653082301*^9, {3.4944664950434794`*^9, 3.494466513563505*^9}, {
   3.49446702434422*^9, 3.494467025484222*^9}, 3.494467708295178*^9, {
   3.494468003285591*^9, 3.4944680151156073`*^9}, {3.494469594271021*^9, 
   3.49446962252106*^9}, {3.494560592517714*^9, 3.4945606193377514`*^9}, {
   3.4946984764682693`*^9, 3.49469849124829*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "]"}], "p"], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "p"], 
       RowBox[{"ExpIntegralEi", "[", 
        RowBox[{
         RowBox[{"-", "p"}], " ", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}], "]"}]}], 
      RowBox[{"d", " ", "n"}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4944393492135696`*^9, 3.494439366993595*^9}, 
   3.4944395044737873`*^9, {3.4944412966462965`*^9, 3.4944413255163364`*^9}, 
   3.4944631289419403`*^9, 3.4944639664899397`*^9, 3.4944651248415613`*^9, 
   3.4944651836716433`*^9, {3.4944665849436054`*^9, 3.494466587053608*^9}, 
   3.4944666721637273`*^9, 3.4944670728742886`*^9, 3.4944671438243876`*^9, 
   3.494467449194815*^9, 3.4944675322149315`*^9, 3.494469323040641*^9, 
   3.494469378910719*^9, {3.4945607101878786`*^9, 3.4945607151978855`*^9}, {
   3.494698400658163*^9, 3.494698410268176*^9}, {3.49470091954169*^9, 
   3.4947009224916935`*^9}, {3.494719982368929*^9, 3.4947199833889303`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ProductLog", "[", 
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "n_."}]}], "]"}], "^", "p_."}], "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "p"}], "*", 
    RowBox[{
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{
       RowBox[{"-", "p"}], "*", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "*", 
         RowBox[{"x", "^", "n"}]}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", "n"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"1", "/", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "+", 
      RowBox[{"1", "/", "n"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494439298133498*^9, 
   3.4944411032260256`*^9, 3.494462988260893*^9, 3.494464917621271*^9, 
   3.494466188753051*^9, 3.494466954574123*^9, 3.494467355464684*^9, 
   3.494469240840526*^9, {3.494560743877926*^9, 3.4945608189880314`*^9}, {
   3.494698429348203*^9, 3.4946984444782248`*^9}, {3.4946985631283903`*^9, 
   3.494698563558391*^9}, {3.494701047951869*^9, 3.4947010547818785`*^9}, {
   3.4947199850289326`*^9, 3.4947199886689377`*^9}, {3.494720706849943*^9, 
   3.4947207106299486`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "n"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", "p"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], "-", 
     FractionBox["1", "n"]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"c", " ", "n"}], ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466410603361*^9, 3.4944664524334197`*^9}, {
   3.494468168375822*^9, 3.4944681761758327`*^9}, {3.494469673921132*^9, 
   3.4944696837911463`*^9}, {3.4945343507051992`*^9, 3.4945344365753193`*^9}, 
   3.4945353373465805`*^9, {3.494559845356668*^9, 3.494559857546685*^9}, {
   3.4945599768468523`*^9, 3.4945599768468523`*^9}, {3.4945601670971184`*^9, 
   3.4945601837271414`*^9}, {3.494560357377385*^9, 3.49456037542741*^9}, {
   3.494698664298532*^9, 3.494698664298532*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{"\[Pi]", " ", "c", " ", "n"}]], " "}], 
      RowBox[{"d", " ", "n", " ", 
       SuperscriptBox["a", 
        RowBox[{"1", "/", "n"}]], 
       SuperscriptBox["c", 
        RowBox[{"1", "/", "n"}]]}]]}]}], 
   RowBox[{"Erfi", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]], 
     SqrtBox[
      RowBox[{"c", " ", "n"}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, 3.494466612693644*^9, 3.4944667280538054`*^9, {
   3.4944670878643093`*^9, 3.4944670907543135`*^9}, 3.4944672123744836`*^9, 
   3.494467453604821*^9, 3.4944675685649824`*^9, 3.49446932933065*^9, 
   3.4944694648508396`*^9, {3.4945340191047354`*^9, 3.494534104824855*^9}, {
   3.4945349574460487`*^9, 3.4945349651660595`*^9}, 3.4945603978674417`*^9, 
   3.4945604618675313`*^9, {3.494698638328496*^9, 3.494698670468541*^9}, {
   3.494720000918955*^9, 3.4947200019589567`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}], ")"}], "^", "p_"}], "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{"Pi", "*", "c", "*", "n"}], ",", "2"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", "n", "*", 
       RowBox[{"a", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "n"}], ")"}]}], "*", 
       RowBox[{"c", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "n"}], ")"}]}]}], ")"}]}], "*", 
    RowBox[{"Erfi", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"c", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}], "]"}], "/", 
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{"c", "*", "n"}], ",", "2"}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"1", "/", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}], "+", 
      RowBox[{"1", "/", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"c", "*", "n"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, {3.494466197663063*^9, 3.4944662173730907`*^9}, 
   3.494466972604148*^9, 3.4944673758047123`*^9, {3.4944681837358437`*^9, 
   3.494468190735853*^9}, 3.494469259830552*^9, {3.4945349787060785`*^9, 
   3.4945350404561653`*^9}, {3.4945351016662507`*^9, 3.494535128216288*^9}, {
   3.494536668208444*^9, 3.494536671948449*^9}, 3.494537222029219*^9, {
   3.4945602630072527`*^9, 3.4945602813172784`*^9}, 3.4945603358773546`*^9, {
   3.4945604144074645`*^9, 3.494560424607479*^9}, {3.4945612492586336`*^9, 
   3.4945612528086386`*^9}, {3.49469859114843*^9, 3.494698621068472*^9}, {
   3.4946986753185472`*^9, 3.4946986807185555`*^9}, {3.4946987710186815`*^9, 
   3.494698771348682*^9}, {3.49472000463896*^9, 3.494720010288968*^9}, 
   3.494720699939934*^9, 3.4947215090510664`*^9, {3.494727527969493*^9, 
   3.494727539519509*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "n"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", "p"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], "-", 
     FractionBox["1", "n"]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"c", " ", "n"}], "<", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466410603361*^9, 3.4944664524334197`*^9}, {
   3.494468168375822*^9, 3.4944681761758327`*^9}, {3.494469673921132*^9, 
   3.4944696837911463`*^9}, {3.4945343507051992`*^9, 3.4945344365753193`*^9}, 
   3.4945353373465805`*^9, {3.494559845356668*^9, 3.494559857546685*^9}, {
   3.4945599768468523`*^9, 3.4945599768468523`*^9}, {3.4945601670971184`*^9, 
   3.4945601837271414`*^9}, {3.494560357377385*^9, 3.4945603613573904`*^9}, {
   3.4946986815985565`*^9, 3.4946986815985565`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{
        RowBox[{"-", "\[Pi]"}], " ", "c", " ", "n"}]], 
      RowBox[{"d", " ", "n", " ", 
       SuperscriptBox["a", 
        RowBox[{"1", "/", "n"}]], 
       SuperscriptBox["c", 
        RowBox[{"1", "/", "n"}]]}]]}]}], " ", 
   RowBox[{"Erf", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]], 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "c"}], " ", "n"}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, {3.4944665968236217`*^9, 3.4944665991136255`*^9}, 
   3.4944667003037667`*^9, 3.4944670813343*^9, 3.4944671751844316`*^9, 
   3.4944674514048185`*^9, 3.4944675493049555`*^9, 3.4944693262006454`*^9, 
   3.4944694254107847`*^9, {3.4945351856863685`*^9, 3.49453523693644*^9}, 
   3.49453527240649*^9, {3.4945597294365053`*^9, 3.4945597893665895`*^9}, 
   3.494559965966837*^9, {3.494698642418502*^9, 3.494698650578513*^9}, {
   3.49469868407856*^9, 3.494698687058564*^9}, {3.4947200164489765`*^9, 
   3.4947200176789784`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}], ")"}], "^", "p_"}], "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "Pi"}], "*", "c", "*", "n"}], ",", "2"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", "n", "*", 
       RowBox[{"a", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "n"}], ")"}]}], "*", 
       RowBox[{"c", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "n"}], ")"}]}]}], ")"}]}], "*", 
    RowBox[{"Erf", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"c", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}], "]"}], "/", 
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "c"}], "*", "n"}], ",", "2"}], "]"}]}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"1", "/", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}], "+", 
      RowBox[{"1", "/", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"c", "*", "n"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, 3.494466197663063*^9, 3.4944669651441374`*^9, 
   3.494467366114699*^9, {3.494468147565793*^9, 3.4944681521757994`*^9}, 
   3.4944692514505405`*^9, {3.494535459496752*^9, 3.4945354950168014`*^9}, 
   3.494537219449216*^9, {3.494559905896753*^9, 3.494559915536766*^9}, {
   3.494559999016883*^9, 3.494560052676958*^9}, {3.494560129177065*^9, 
   3.4945601328170705`*^9}, {3.4945601976071615`*^9, 3.494560212697182*^9}, {
   3.494560306397313*^9, 3.494560328287344*^9}, 3.4945612587886467`*^9, {
   3.494698593668433*^9, 3.4946986232184744`*^9}, {3.4946986923985715`*^9, 
   3.49469869815858*^9}, {3.4946987738986855`*^9, 3.4946987745986867`*^9}, {
   3.494720020308982*^9, 3.4947200257489896`*^9}, 3.4947207028999376`*^9, 
   3.494721509871067*^9, {3.494727549399523*^9, 3.494727557389534*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"n", 
      RowBox[{"(", 
       RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466410603361*^9, 3.4944664524334197`*^9}, {
   3.4944682111458817`*^9, 3.4944682224058976`*^9}, {3.4944765229707594`*^9, 
   3.4944765415807858`*^9}, {3.4947062960092163`*^9, 3.49470629883922*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"], 
     RowBox[{"d", "+", 
      RowBox[{"d", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"c", " ", "x", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", " ", 
           RowBox[{"ProductLog", "[", 
            RowBox[{"a", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}], ")"}], 
         RowBox[{"p", "-", "1"}]]}], "d"]}]}]}]}], "-", 
  RowBox[{"c", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"n", " ", 
      RowBox[{"(", 
       RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", " ", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}], ")"}], 
       RowBox[{"p", "-", "1"}]], 
      RowBox[{"d", "+", 
       RowBox[{"d", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, 3.494466612693644*^9, 3.4944667280538054`*^9, {
   3.4944670878643093`*^9, 3.4944670907543135`*^9}, 3.4944672123744836`*^9, 
   3.494467455604824*^9, 3.4944675970350223`*^9, 3.4944758250797825`*^9, 
   3.4944760177000523`*^9, 3.494705544278164*^9, {3.4947055813982162`*^9, 
   3.494705647748309*^9}, {3.494706215719104*^9, 3.494706288399206*^9}, {
   3.4947200294489946`*^9, 3.4947200319089985`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}], ")"}], "^", "p_."}], "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"c", "*", "x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", "d"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", "*", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "*", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"d", "*", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], ">", 
     "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, {3.494466197663063*^9, 3.4944662173730907`*^9}, 
   3.494466972604148*^9, {3.4944673758047123`*^9, 3.4944674018947487`*^9}, 
   3.4944757296496487`*^9, {3.4945277366659393`*^9, 3.494527737405941*^9}, {
   3.4947057501284523`*^9, 3.494705783548499*^9}, {3.494705822838554*^9, 
   3.494705883198639*^9}, 3.4947059280687017`*^9, {3.4947063257692585`*^9, 
   3.4947063988993607`*^9}, {3.494720033819001*^9, 3.4947200388090076`*^9}, 
   3.49472151173107*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"n", " ", "p"}], "+", "1"}], "<", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466410603361*^9, 3.4944664524334197`*^9}, {
   3.4944682361159167`*^9, 3.4944682448559294`*^9}, {3.4944683221760373`*^9, 
   3.4944683247460413`*^9}, {3.4944765695508246`*^9, 3.494476578900838*^9}, {
   3.4947063066292315`*^9, 3.4947063083892336`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"], 
     RowBox[{"d", "+", 
      RowBox[{"d", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", " ", 
           RowBox[{"ProductLog", "[", 
            RowBox[{"a", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"n", " ", "p"}], "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"c", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"n", " ", "p"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", " ", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}], ")"}], 
       RowBox[{"p", "+", "1"}]], 
      RowBox[{"d", "+", 
       RowBox[{"d", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, 3.494466612693644*^9, 3.4944667280538054`*^9, {
   3.4944670878643093`*^9, 3.4944670907543135`*^9}, 3.4944672123744836`*^9, 
   3.4944674575048265`*^9, {3.4944676243450603`*^9, 3.494467626815064*^9}, 
   3.4944758282197866`*^9, 3.494476062020114*^9, 3.4947055473581686`*^9, {
   3.4947056711483417`*^9, 3.4947057067883916`*^9}, {3.49470621977911*^9, 
   3.4947062827791977`*^9}, {3.4947200398990097`*^9, 3.4947200419090123`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}], ")"}], "^", "p_."}], "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"n", "*", "p"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"n", "*", "p"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "*", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"d", "*", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"n", "*", "p"}], "+", "1"}], "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, {3.494466197663063*^9, 3.4944662173730907`*^9}, 
   3.494466972604148*^9, 3.4944673758047123`*^9, 3.4944674100447607`*^9, {
   3.494468313176025*^9, 3.4944683166760297`*^9}, 3.494475739139662*^9, {
   3.4945277406359453`*^9, 3.494527741905947*^9}, {3.494705754038458*^9, 
   3.494705788458506*^9}, {3.4947058330985684`*^9, 3.494705890938649*^9}, 
   3.494705930838705*^9, {3.494706329149263*^9, 3.4947063937993536`*^9}, {
   3.4947200433690147`*^9, 3.4947200492190228`*^9}, 3.4947215126010714`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9, 3.494465499612086*^9, 
   3.4944684694762435`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
   RowBox[{"-", 
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"\[Integral]", 
       RowBox[{
        FractionBox[
         RowBox[{"f", "[", 
          FractionBox["1", "x"], "]"}], 
         SuperscriptBox["x", "2"]], 
        RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
      FractionBox["1", "x"]}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9, {3.494465499612086*^9, 
   3.4944655112721024`*^9}, 3.494465544312148*^9, 3.4944663200732346`*^9, {
   3.4944686423964853`*^9, 3.4944686449964895`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466410603361*^9, 3.4944664524334197`*^9}, {
   3.4944682111458817`*^9, 3.4944682224058976`*^9}, {3.4944697034911737`*^9, 
   3.494469716641192*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"\[Integral]", 
         RowBox[{
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"c", " ", 
              RowBox[{"ProductLog", "[", 
               RowBox[{"a", " ", 
                SuperscriptBox["x", 
                 RowBox[{"-", "n"}]]}], "]"}]}], ")"}], "p"], 
           RowBox[{
            SuperscriptBox["x", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"d", " ", 
               RowBox[{"ProductLog", "[", 
                RowBox[{"a", " ", 
                 SuperscriptBox["x", 
                  RowBox[{"-", "n"}]]}], "]"}]}]}], ")"}]}]], 
          RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
        FractionBox["1", "x"]}], "]"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, 3.494466612693644*^9, 3.4944667280538054`*^9, {
   3.4944670878643093`*^9, 3.4944670907543135`*^9}, 3.4944672123744836`*^9, 
   3.494467455604824*^9, 3.4944675970350223`*^9, 3.494469332370654*^9, 
   3.4944695079909*^9, {3.494562299970104*^9, 3.4945623350401535`*^9}, {
   3.494699202639286*^9, 3.494699204689289*^9}, {3.4946996581499233`*^9, 
   3.4946996674099364`*^9}, {3.4947200643690434`*^9, 3.4947200665490465`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_"}]}], "]"}]}], ")"}], "^", "p_."}], "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "*", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"-", "n"}], ")"}]}]}], "]"}]}], ")"}], "^", "p"}], 
         "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"x", "^", "2"}], "*", 
           RowBox[{"(", 
            RowBox[{"d", "+", 
             RowBox[{"d", "*", 
              RowBox[{"ProductLog", "[", 
               RowBox[{"a", "*", 
                RowBox[{"x", "^", 
                 RowBox[{"(", 
                  RowBox[{"-", "n"}], ")"}]}]}], "]"}]}]}], ")"}]}], ")"}]}], 
        ",", "x"}], "]"}], ",", "x", ",", 
      RowBox[{"1", "/", "x"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, {3.494466197663063*^9, 3.4944662173730907`*^9}, 
   3.494466972604148*^9, {3.4944673758047123`*^9, 3.4944674018947487`*^9}, 
   3.494469268060564*^9, {3.494562362220192*^9, 3.494562398080242*^9}, {
   3.4946992073892927`*^9, 3.494699212009299*^9}, {3.4946996872299643`*^9, 
   3.4946997176700068`*^9}, {3.4947200682590494`*^9, 3.494720072489055*^9}, 
   3.4947215143710737`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.494439343783562*^9, 3.494441172446122*^9, 
   3.4944629636440496`*^9, 3.4944649657213383`*^9, 3.494466149562996*^9, 
   3.4944742750627985`*^9, 3.4947086809425554`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"p", "-", 
        FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
      " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{"p", "+", 
          FractionBox[
           RowBox[{"m", "+", "1"}], "n"]}], ")"}]}], "\[Element]", 
       "\[DoubleStruckCapitalZ]"}], " ", "\[And]", "  ", 
      RowBox[{
       RowBox[{"p", "+", 
        FractionBox[
         RowBox[{"m", "+", "1"}], "n"]}], ">", "0"}]}], ")"}]}], " ", "\[Or]",
    " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"\[Not]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"p", "-", 
         FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
       ")"}]}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"p", "+", 
       FractionBox[
        RowBox[{"m", "+", "1"}], "n"]}], "\[Element]", 
      "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"p", "+", 
       FractionBox[
        RowBox[{"m", "+", "1"}], "n"]}], "\[GreaterEqual]", "0"}]}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9, {3.494464984351364*^9, 3.4944650001413865`*^9}, 
   3.4944656497622957`*^9, 3.4944665539935617`*^9, {3.494466786573888*^9, 
   3.494466789013891*^9}, {3.4944744897735*^9, 3.4944745169735384`*^9}, {
   3.4944745507735853`*^9, 3.494474551753587*^9}, {3.4944745820936294`*^9, 
   3.4944746799337664`*^9}, {3.494474760593879*^9, 3.4944747747938995`*^9}, {
   3.494726748048401*^9, 3.4947267578984146`*^9}, {3.4947269684287095`*^9, 
   3.4947269717587137`*^9}, {3.4948762815525904`*^9, 
   3.4948763315026608`*^9}, {3.4948763704227147`*^9, 3.4948764029527607`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                   ", "\[IndentingNewLine]", 
      "                                         ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", " ", 
           RowBox[{"ProductLog", "[", 
            RowBox[{"a", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", "p"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", " ", 
            SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"]}], 
      RowBox[{"1", "+", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, {3.4944393463335657`*^9, 
   3.4944393633235893`*^9}, 3.4944394680437365`*^9, {3.4944412518762336`*^9, 
   3.494441273186263*^9}, {3.494463807599717*^9, 3.4944638371197586`*^9}, 
   3.4944651158515487`*^9, 3.4944651583516083`*^9, {3.494466570013584*^9, 
   3.494466572673588*^9}, 3.494466647603693*^9, 3.494474423449406*^9, 
   3.494474714763815*^9, {3.4947086980825796`*^9, 3.4947087255826178`*^9}, {
   3.4948861304895697`*^9, 3.4948861763224506`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}], ")"}], "^", "p_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "*", 
             RowBox[{"ProductLog", "[", 
              RowBox[{"a", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", "p"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}]}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "m", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"IntegerQ", "[", 
        RowBox[{"p", "-", 
         RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
       RowBox[{"IntegerQ", "[", 
        RowBox[{"2", "*", 
         RowBox[{"Simplify", "[", 
          RowBox[{"p", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], "]"}]}], "]"}], 
       " ", "&&", " ", 
       RowBox[{
        RowBox[{"Simplify", "[", 
         RowBox[{"p", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], "]"}], ">", "0"}]}],
       " ", "||", "\n", " ", 
      RowBox[{
       RowBox[{"Not", "[", 
        RowBox[{"IntegerQ", "[", 
         RowBox[{"p", "-", 
          RowBox[{"1", "/", "2"}]}], "]"}], "]"}], " ", "&&", " ", 
       RowBox[{"IntegerQ", "[", 
        RowBox[{"Simplify", "[", 
         RowBox[{"p", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], "]"}], "]"}], " ", "&&",
        " ", 
       RowBox[{
        RowBox[{"Simplify", "[", 
         RowBox[{"p", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], "]"}], ">=", 
        "0"}]}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.494439288643485*^9, 3.4944410948660135`*^9, 3.494462978308076*^9, 
   3.49446490938126*^9, 3.494466161643013*^9, 3.4944743291228743`*^9, {
   3.494711695605233*^9, 3.4947117526545334`*^9}, {3.4947267881384573`*^9, 
   3.49472679023846*^9}, {3.4947268243585076`*^9, 3.4947268412485313`*^9}, {
   3.494726872558575*^9, 3.4947268849185925`*^9}, {3.4948002359978046`*^9, 
   3.494800247337821*^9}, {3.4948008323486395`*^9, 3.494800845278658*^9}, {
   3.494801198879153*^9, 3.4948012172591786`*^9}, {3.4948012595492377`*^9, 
   3.494801265479246*^9}, {3.4948014193994617`*^9, 3.494801463089523*^9}, {
   3.4948017215598845`*^9, 3.494801726739892*^9}, {3.494802188460538*^9, 
   3.4948021912105417`*^9}, {3.4948038768629017`*^9, 
   3.4948038944329267`*^9}, {3.494804371743595*^9, 3.494804379243605*^9}, {
   3.494804524593809*^9, 3.4948045285538144`*^9}, {3.494804612603932*^9, 
   3.494804629613956*^9}, {3.494868710137703*^9, 3.494868718046917*^9}, 
   3.4948688395711308`*^9, {3.4948691318064437`*^9, 3.494869136782852*^9}, {
   3.4948706876907763`*^9, 3.49487068968758*^9}, {3.4948727100675907`*^9, 
   3.494872740167632*^9}, {3.4948728077477274`*^9, 3.494872857027796*^9}, {
   3.4948750490308647`*^9, 3.4948750543308725`*^9}, 3.494875115180958*^9, {
   3.4948751887710605`*^9, 3.494875194141068*^9}, {3.4948754441914177`*^9, 
   3.494875451681429*^9}, 3.494875646941702*^9, {3.494875708111788*^9, 
   3.494875710591791*^9}, {3.494875786671898*^9, 3.494875815541938*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "1"}], "=", 
   RowBox[{"0", " ", "\[Or]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"p", "-", 
        FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
      " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"p", "+", 
        FractionBox[
         RowBox[{"m", "+", "1"}], "n"], "-", 
        FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
      " ", "\[And]", "  ", 
      RowBox[{
       RowBox[{"p", "+", 
        FractionBox[
         RowBox[{"m", "+", "1"}], "n"]}], "<", "0"}]}], ")"}], " ", "\[Or]", 
    " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Not]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"p", "-", 
          FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
        ")"}]}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"p", "+", 
        FractionBox[
         RowBox[{"m", "+", "1"}], "n"]}], "\[Element]", 
       "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"p", "+", 
        FractionBox[
         RowBox[{"m", "+", "1"}], "n"]}], "<", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9, {3.494464984351364*^9, 3.4944650253214216`*^9}, 
   3.494465653082301*^9, {3.4944664950434794`*^9, 3.494466513563505*^9}, {
   3.494474798883933*^9, 3.494474874384039*^9}, {3.4947269872587357`*^9, 
   3.4947269913287416`*^9}, {3.4948174108384027`*^9, 
   3.4948174108384027`*^9}, {3.494817463668477*^9, 3.4948174756884937`*^9}, {
   3.494875917682081*^9, 3.4948761166323595`*^9}, {3.4948761529524107`*^9, 
   3.4948761981624737`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                ", "\[IndentingNewLine]", "                 ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", " ", 
           RowBox[{"ProductLog", "[", 
            RowBox[{"a", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"]}], 
       RowBox[{"m", "+", 
        RowBox[{"n", " ", "p"}], "+", "1"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", "p"}], 
    RowBox[{"c", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"n", " ", "p"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", " ", 
            SuperscriptBox["x", "n"]}], "]"}]}], ")"}], 
        RowBox[{"p", "+", "1"}]]}], 
      RowBox[{"1", "+", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4944393492135696`*^9, 3.494439366993595*^9}, 
   3.4944395044737873`*^9, {3.4944412966462965`*^9, 3.4944413255163364`*^9}, 
   3.4944631289419403`*^9, 3.4944639664899397`*^9, 3.4944651248415613`*^9, 
   3.4944651836716433`*^9, {3.4944665849436054`*^9, 3.494466587053608*^9}, 
   3.4944666721637273`*^9, 3.49447442575821*^9, 3.494474913704094*^9, {
   3.494711555220626*^9, 3.4947115700406466`*^9}, {3.4948861849180655`*^9, 
   3.494886206508504*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}], ")"}], "^", "p_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"n", "*", "p"}], "+", "1"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"n", "*", "p"}], "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "*", 
             RowBox[{"ProductLog", "[", 
              RowBox[{"a", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}]}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "m", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"m", "+", "1"}], "]"}], " ", "||", "\n", " ", 
      RowBox[{
       RowBox[{"IntegerQ", "[", 
        RowBox[{"p", "-", 
         RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
       RowBox[{"IntegerQ", "[", 
        RowBox[{
         RowBox[{"Simplify", "[", 
          RowBox[{"p", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], "]"}], "-", 
         RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"Simplify", "[", 
         RowBox[{"p", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], "]"}], "<", "0"}]}],
       " ", "||", "\n", " ", 
      RowBox[{
       RowBox[{"Not", "[", 
        RowBox[{"IntegerQ", "[", 
         RowBox[{"p", "-", 
          RowBox[{"1", "/", "2"}]}], "]"}], "]"}], " ", "&&", " ", 
       RowBox[{"IntegerQ", "[", 
        RowBox[{"Simplify", "[", 
         RowBox[{"p", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], "]"}], "]"}], " ", "&&",
        " ", 
       RowBox[{
        RowBox[{"Simplify", "[", 
         RowBox[{"p", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], "]"}], "<", 
        "0"}]}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494439298133498*^9, 
   3.4944411032260256`*^9, 3.494462988260893*^9, 3.494464917621271*^9, 
   3.494466188753051*^9, 3.4944743383728867`*^9, {3.494711707071254*^9, 
   3.4947117264620876`*^9}, {3.494711760828948*^9, 3.494711762466951*^9}, {
   3.494711826587053*^9, 3.494711830757059*^9}, {3.494727018218779*^9, 
   3.4947270599688377`*^9}, 3.4947282304904766`*^9, {3.494814255693986*^9, 
   3.4948142604839926`*^9}, {3.49481450849434*^9, 3.494814525124363*^9}, {
   3.494814646884534*^9, 3.4948146584745493`*^9}, {3.494868477978095*^9, 
   3.4948685463218155`*^9}, {3.4948691425548625`*^9, 3.49486914689167*^9}, {
   3.4948706689707437`*^9, 3.494870678611561*^9}, {3.4948708834711204`*^9, 
   3.494870884282322*^9}, {3.4948728922478456`*^9, 3.494872897097852*^9}, {
   3.4948750633108845`*^9, 3.494875066450889*^9}, 3.4948751187309628`*^9, {
   3.4948751638910255`*^9, 3.494875164571027*^9}, {3.4948758302119584`*^9, 
   3.4948758512219877`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9, 3.494465499612086*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{"1", "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "+", "z"}]], "+", 
    FractionBox["z", 
     RowBox[{"1", "+", "z"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9, {3.494465499612086*^9, 
   3.4944655112721024`*^9}, 3.494465544312148*^9, 3.4944663200732346`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9, {3.494464984351364*^9, 3.4944650253214216`*^9}, 
   3.494465653082301*^9, {3.4944664950434794`*^9, 3.494466513563505*^9}, {
   3.494474798883933*^9, 3.494474874384039*^9}, {3.4947269872587357`*^9, 
   3.4947269913287416`*^9}, {3.494792403312418*^9, 3.494792429458064*^9}, {
   3.494817555948606*^9, 3.4948175723286295`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", "x"}], "]"}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"\[Integral]", 
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["x", "m"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"c", " ", 
             RowBox[{"ProductLog", "[", 
              RowBox[{"a", " ", "x"}], "]"}]}], ")"}], "p"]}], 
         RowBox[{"1", "+", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", " ", "x"}], "]"}]}]], 
        RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", " ", "x"}], "]"}]}], ")"}], 
        RowBox[{"p", "+", "1"}]]}], 
      RowBox[{"1", "+", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", "x"}], "]"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, {3.4944665968236217`*^9, 3.4944665991136255`*^9}, 
   3.4944667003037667`*^9, {3.494791401200657*^9, 3.4947914257395*^9}, {
   3.4947923504311247`*^9, 3.494792357014336*^9}, {3.4948175775986366`*^9, 
   3.4948175890086527`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", "x_"}], "]"}]}], ")"}], "^", "p_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "*", 
           RowBox[{"ProductLog", "[", 
            RowBox[{"a", "*", "x"}], "]"}]}], ")"}], "^", "p"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", "*", "x"}], "]"}]}], ")"}]}]}], ",", "x"}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "*", 
             RowBox[{"ProductLog", "[", 
              RowBox[{"a", "*", "x"}], "]"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "*", "x"}], "]"}]}], ")"}]}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "c", ",", "m"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, 3.494466197663063*^9, {3.4947154463121204`*^9, 
   3.494715449662125*^9}, {3.494726457487994*^9, 3.4947264607079983`*^9}, {
   3.494789889712801*^9, 3.4947898905396023`*^9}, {3.494791438812323*^9, 
   3.4947914798871956`*^9}, {3.4947924554165096`*^9, 
   3.4947924698309345`*^9}, {3.4947925200786233`*^9, 
   3.4947925615122957`*^9}, {3.494792621400801*^9, 3.494792644254841*^9}, {
   3.4948175976886644`*^9, 3.4948176205686965`*^9}, {3.4948176804287806`*^9, 
   3.494817685298787*^9}, {3.494817966339181*^9, 3.4948179711991873`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.4944413869064226`*^9, 3.4944413884864244`*^9}, 
   3.4944630322217703`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
   RowBox[{"-", 
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"\[Integral]", 
       RowBox[{
        FractionBox[
         RowBox[{"f", "[", 
          FractionBox["1", "x"], "]"}], 
         SuperscriptBox["x", "2"]], 
        RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
      FractionBox["1", "x"]}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9, {3.494465499612086*^9, 
   3.4944655112721024`*^9}, 3.494465544312148*^9, 3.4944663200732346`*^9, {
   3.4944686423964853`*^9, 3.4944686449964895`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "<", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466410603361*^9, 3.4944664524334197`*^9}, {
   3.4944682111458817`*^9, 3.4944682224058976`*^9}, {3.4944697034911737`*^9, 
   3.494469716641192*^9}, {3.4944753559991255`*^9, 3.494475376309154*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"\[Integral]", 
         RowBox[{
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"c", " ", 
              RowBox[{"ProductLog", "[", 
               RowBox[{"a", " ", 
                SuperscriptBox["x", 
                 RowBox[{"-", "n"}]]}], "]"}]}], ")"}], "p"], 
           SuperscriptBox["x", 
            RowBox[{"m", "+", "2"}]]], 
          RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
        FractionBox["1", "x"]}], "]"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, 3.494466612693644*^9, 3.4944667280538054`*^9, {
   3.4944744384634285`*^9, 3.494474443403435*^9}, 3.494474957574155*^9, {
   3.4947115967066855`*^9, 3.494711617406715*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_"}]}], "]"}]}], ")"}], "^", "p_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "*", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"-", "n"}], ")"}]}]}], "]"}]}], ")"}], "^", "p"}], 
         "/", 
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}], ",", "x", 
      ",", 
      RowBox[{"1", "/", "x"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, {3.494466197663063*^9, 3.4944662173730907`*^9}, 
   3.494474345822897*^9, {3.494711711252061*^9, 3.4947117299408937`*^9}, {
   3.494711768816162*^9, 3.4947117728097687`*^9}, 3.5171913781291027`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.494439343783562*^9, 3.494441172446122*^9, 
   3.4944629636440496`*^9, 3.4944649657213383`*^9, 3.494466149562996*^9, 
   3.4944669300040884`*^9, 3.494467288914591*^9, 3.494469215750491*^9, 
   3.4944751340388145`*^9, {3.4947081603918266`*^9, 3.4947081632718306`*^9}, 
   3.4947083249020567`*^9, {3.494720095389087*^9, 3.4947200957890873`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9, {3.494464984351364*^9, 3.4944650001413865`*^9}, 
   3.4944656497622957`*^9, 3.4944665539935617`*^9, {3.494466786573888*^9, 
   3.494466789013891*^9}, {3.4944670185442123`*^9, 3.4944670190942135`*^9}, {
   3.4944676791451373`*^9, 3.4944676822551413`*^9}, {3.4944678801354184`*^9, 
   3.4944678822154217`*^9}, {3.4944679322254915`*^9, 3.494467942265506*^9}, {
   3.494469569200986*^9, 3.494469581531003*^9}, {3.494475282479023*^9, 
   3.494475314779068*^9}, 3.4947905547035694`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"d", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], ")"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}], "]"}], 
      RowBox[{"d", " ", "n"}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, {3.4944393463335657`*^9, 
   3.4944393633235893`*^9}, 3.4944394680437365`*^9, {3.4944412518762336`*^9, 
   3.494441273186263*^9}, {3.494463807599717*^9, 3.4944638371197586`*^9}, 
   3.4944651158515487`*^9, 3.4944651583516083`*^9, {3.494466570013584*^9, 
   3.494466572673588*^9}, 3.494466647603693*^9, {3.494467057404267*^9, 
   3.4944670607942715`*^9}, 3.49446712395436*^9, 3.4944674468548117`*^9, 
   3.49446751686491*^9, 3.494469319790636*^9, 3.4944693650506997`*^9, 
   3.494475242028966*^9, 3.4944754087991996`*^9, {3.4947081671618357`*^9, 
   3.4947081920918713`*^9}, 3.4947083772421303`*^9, {3.4947200969290895`*^9, 
   3.4947200993490925`*^9}, {3.4947904855330477`*^9, 3.494790509713091*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"(", 
        RowBox[{"d_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a_.", "*", 
            RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"ProductLog", "[", 
      RowBox[{"a", "*", 
       RowBox[{"x", "^", "n"}]}], "]"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"d", "*", "n"}], ")"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "d", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.494439288643485*^9, 3.4944410948660135`*^9, 3.494462978308076*^9, 
   3.49446490938126*^9, 3.494466161643013*^9, 3.494466944194108*^9, 
   3.494467346814672*^9, {3.494467887745429*^9, 3.4944678903654327`*^9}, 
   3.494469230760512*^9, 3.4944751512588387`*^9, {3.494708331982067*^9, 
   3.494708366662115*^9}, {3.494720100919095*^9, 3.4947201056591015`*^9}, {
   3.4947905158439016`*^9, 3.494790567526792*^9}, 3.494790597931246*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{"m", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9, {3.494464984351364*^9, 3.4944650001413865`*^9}, 
   3.4944656497622957`*^9, 3.4944665539935617`*^9, {3.494466786573888*^9, 
   3.494466789013891*^9}, {3.4944670185442123`*^9, 3.4944670190942135`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "m"], 
     RowBox[{"d", "+", 
      RowBox[{"d", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", "x"}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                        ", "\[IndentingNewLine]", "       ", 
      FractionBox[
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", " ", "x"}], "]"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["m", 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", "m"], 
      RowBox[{
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", "x"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"d", " ", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", " ", "x"}], "]"}]}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, {3.4944393463335657`*^9, 
   3.4944393633235893`*^9}, 3.4944394680437365`*^9, {3.4944412518762336`*^9, 
   3.494441273186263*^9}, {3.494463807599717*^9, 3.4944638371197586`*^9}, 
   3.4944651158515487`*^9, 3.4944651583516083`*^9, {3.494466570013584*^9, 
   3.494466572673588*^9}, 3.494466647603693*^9, {3.494467057404267*^9, 
   3.4944670607942715`*^9}, 3.49446712395436*^9, {3.49471503175154*^9, 
   3.4947150551315727`*^9}, {3.494886245383772*^9, 3.494886281965836*^9}, {
   3.4948863391243362`*^9, 3.4948863394987373`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", "x_"}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "*", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "*", "x"}], "]"}]}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ProductLog", "[", 
            RowBox[{"a", "*", "x"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{"d", "+", 
             RowBox[{"d", "*", 
              RowBox[{"ProductLog", "[", 
               RowBox[{"a", "*", "x"}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.494439288643485*^9, 3.4944410948660135`*^9, 3.494462978308076*^9, 
   3.49446490938126*^9, 3.494466161643013*^9, 3.494466944194108*^9, {
   3.4947150612715816`*^9, 3.494715083201612*^9}, {3.494715120081664*^9, 
   3.494715134601684*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{"m", "<", 
   RowBox[{"-", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9, {3.494464984351364*^9, 3.4944650253214216`*^9}, 
   3.494465653082301*^9, {3.4944664950434794`*^9, 3.494466513563505*^9}, {
   3.49446702434422*^9, 3.494467025484222*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "m"], 
     RowBox[{"d", "+", 
      RowBox[{"d", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", "x"}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", "x"}], "]"}]}], 
     RowBox[{"d", "+", 
      RowBox[{"d", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", "x"}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4944393492135696`*^9, 3.494439366993595*^9}, 
   3.4944395044737873`*^9, {3.4944412966462965`*^9, 3.4944413255163364`*^9}, 
   3.4944631289419403`*^9, 3.4944639664899397`*^9, 3.4944651248415613`*^9, 
   3.4944651836716433`*^9, {3.4944665849436054`*^9, 3.494466587053608*^9}, 
   3.4944666721637273`*^9, 3.4944670728742886`*^9, 3.4944671438243876`*^9, 
   3.494715034071543*^9, {3.494715151641708*^9, 3.49471516010172*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", "x_"}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", 
       RowBox[{
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", "*", "x"}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"d", "*", 
           RowBox[{"ProductLog", "[", 
            RowBox[{"a", "*", "x"}], "]"}]}]}], ")"}]}]}], ",", "x"}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494439298133498*^9, 
   3.4944411032260256`*^9, 3.494462988260893*^9, 3.494464917621271*^9, 
   3.494466188753051*^9, 3.494466954574123*^9, {3.4947150754616013`*^9, 
   3.4947150891316204`*^9}, 3.494715148291703*^9, {3.494715205281783*^9, 
   3.4947152105417905`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466465553438*^9, 3.4944664752134514`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", "x"}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{
         RowBox[{"m", "+", "1"}], ",", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}]}], " ", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", " ", "x"}], "]"}]}]}], "]"}]}], 
      RowBox[{"a", " ", "d", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"m", " ", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", " ", "x"}], "]"}]}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}]}], " ", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", " ", "x"}], "]"}]}], ")"}], 
        "m"]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, {3.4944665968236217`*^9, 3.4944665991136255`*^9}, 
   3.4944667003037667`*^9, 3.4944670813343*^9, 3.4944671751844316`*^9, 
   3.4947150368315473`*^9, 3.494715095251629*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", "x_"}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "m"}], "*", 
    RowBox[{
     RowBox[{"Gamma", "[", 
      RowBox[{
       RowBox[{"m", "+", "1"}], ",", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", "*", "x"}], "]"}]}]}], "]"}], "/", "\n", "\t", 
     RowBox[{"(", 
      RowBox[{"a", "*", "d", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "*", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"m", "*", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", "*", "x"}], "]"}]}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}]}], "*", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", "*", "x"}], "]"}]}], ")"}], "^", "m"}]}], ")"}]}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, 3.494466197663063*^9, 3.4944669651441374`*^9, {
   3.4947150777216043`*^9, 3.494715091551624*^9}, {3.4947152619618626`*^9, 
   3.4947152622918625`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9, 3.494465499612086*^9, 
   3.4944684694762435`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
   RowBox[{"-", 
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"\[Integral]", 
       RowBox[{
        FractionBox[
         RowBox[{"f", "[", 
          FractionBox["1", "x"], "]"}], 
         SuperscriptBox["x", "2"]], 
        RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
      FractionBox["1", "x"]}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9, {3.494465499612086*^9, 
   3.4944655112721024`*^9}, 3.494465544312148*^9, 3.4944663200732346`*^9, {
   3.4944686423964853`*^9, 3.4944686449964895`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "<", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466410603361*^9, 3.4944664524334197`*^9}, {
   3.4944682111458817`*^9, 3.4944682224058976`*^9}, {3.4944697034911737`*^9, 
   3.494469716641192*^9}, {3.4944753559991255`*^9, 3.494475376309154*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"\[Integral]", 
         RowBox[{
          FractionBox["1", 
           RowBox[{
            SuperscriptBox["x", 
             RowBox[{"m", "+", "2"}]], " ", 
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"d", " ", 
               RowBox[{"ProductLog", "[", 
                RowBox[{"a", " ", 
                 SuperscriptBox["x", 
                  RowBox[{"-", "n"}]]}], "]"}]}]}], ")"}]}]], 
          RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
        FractionBox["1", "x"]}], "]"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, 3.494466612693644*^9, 3.4944667280538054`*^9, {
   3.4944670878643093`*^9, 3.4944670907543135`*^9}, 3.4944672123744836`*^9, 
   3.494467455604824*^9, 3.4944675970350223`*^9, 3.494469332370654*^9, 
   3.4944695079909*^9, 3.4944752592989902`*^9, 3.494475481139301*^9, {
   3.49470827703199*^9, 3.4947082831919985`*^9}, {3.4947201178591185`*^9, 
   3.4947201199191217`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "+", "2"}], ")"}]}], "*", 
           RowBox[{"(", 
            RowBox[{"d", "+", 
             RowBox[{"d", "*", 
              RowBox[{"ProductLog", "[", 
               RowBox[{"a", "*", 
                RowBox[{"x", "^", 
                 RowBox[{"(", 
                  RowBox[{"-", "n"}], ")"}]}]}], "]"}]}]}], ")"}]}], ")"}]}], 
        ",", "x"}], "]"}], ",", "x", ",", 
      RowBox[{"1", "/", "x"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, {3.494466197663063*^9, 3.4944662173730907`*^9}, 
   3.494466972604148*^9, {3.4944673758047123`*^9, 3.4944674018947487`*^9}, 
   3.494469268060564*^9, 3.49447520926892*^9, {3.4947085029423065`*^9, 
   3.494708516392325*^9}, {3.494720120949123*^9, 3.4947201258291297`*^9}, 
   3.5171913782227025`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"]}], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.494439343783562*^9, 3.494441172446122*^9, 
   3.4944629636440496`*^9, 3.4944649657213383`*^9, 3.494466149562996*^9, 
   3.4944669300040884`*^9, 3.494467288914591*^9, 3.494475633269514*^9, {
   3.494700261430768*^9, 3.4947002700307803`*^9}, {3.494720127069132*^9, 
   3.494720127409132*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9, {3.494464984351364*^9, 3.4944650001413865`*^9}, 
   3.4944656497622957`*^9, 3.4944665539935617`*^9, {3.494466786573888*^9, 
   3.494466789013891*^9}, {3.4944670185442123`*^9, 3.4944670190942135`*^9}, {
   3.4944676791451373`*^9, 3.4944676822551413`*^9}, {3.4944678801354184`*^9, 
   3.4944678822154217`*^9}, {3.4944679322254915`*^9, 3.494467942265506*^9}, {
   3.4944764156606092`*^9, 3.494476435170636*^9}, 3.4947894169071703`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"], 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"d", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], ")"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", " ", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"], 
      RowBox[{"d", " ", "n", " ", "p"}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, {3.4944393463335657`*^9, 
   3.4944393633235893`*^9}, 3.4944394680437365`*^9, {3.4944412518762336`*^9, 
   3.494441273186263*^9}, {3.494463807599717*^9, 3.4944638371197586`*^9}, 
   3.4944651158515487`*^9, 3.4944651583516083`*^9, {3.494466570013584*^9, 
   3.494466572673588*^9}, 3.494466647603693*^9, {3.494467057404267*^9, 
   3.4944670607942715`*^9}, 3.49446712395436*^9, 3.4944674468548117`*^9, 
   3.49446751686491*^9, 3.494475807839758*^9, 3.494475861869834*^9, {
   3.494700331460866*^9, 3.494700347800889*^9}, {3.494720128369133*^9, 
   3.4947201298691354`*^9}, {3.494789300390566*^9, 3.49478936544268*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}], ")"}], "^", "p_."}], "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"(", 
        RowBox[{"d_", "+", 
         RowBox[{"d_.", "*", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a_.", "*", 
            RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c", "*", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "*", 
         RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", "p"}], "/", 
    RowBox[{"(", 
     RowBox[{"d", "*", "n", "*", "p"}], ")"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "c", ",", "d", ",", "n", ",", "p"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.494439288643485*^9, 3.4944410948660135`*^9, 3.494462978308076*^9, 
   3.49446490938126*^9, 3.494466161643013*^9, 3.494466944194108*^9, 
   3.494467346814672*^9, {3.494467887745429*^9, 3.4944678903654327`*^9}, 
   3.4944756818095818`*^9, {3.4945277270559263`*^9, 3.4945277306059313`*^9}, {
   3.4947004261309986`*^9, 3.4947004798710737`*^9}, {3.494700525101137*^9, 
   3.49470052672114*^9}, {3.494720131499138*^9, 3.494720135459143*^9}, 
   3.4947215155710754`*^9, 3.494723381783688*^9, {3.4947894220551796`*^9, 
   3.494789477060876*^9}, 3.4974589360859118`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", 
    RowBox[{"n", 
     RowBox[{"(", 
      RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9, {3.494464984351364*^9, 3.4944650001413865`*^9}, 
   3.4944656497622957`*^9, 3.4944665539935617`*^9, {3.494466786573888*^9, 
   3.494466789013891*^9}, {3.4944670185442123`*^9, 3.4944670190942135`*^9}, {
   3.4944676791451373`*^9, 3.4944676822551413`*^9}, {3.4944678801354184`*^9, 
   3.4944678822154217`*^9}, {3.4944679322254915`*^9, 3.494467942265506*^9}, {
   3.4944764156606092`*^9, 3.494476435170636*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"]}], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", " ", 
            SuperscriptBox["x", "n"]}], "]"}]}], ")"}], 
        RowBox[{"p", "-", "1"}]]}], 
      RowBox[{"d", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, {3.4944393463335657`*^9, 
   3.4944393633235893`*^9}, 3.4944394680437365`*^9, {3.4944412518762336`*^9, 
   3.494441273186263*^9}, {3.494463807599717*^9, 3.4944638371197586`*^9}, 
   3.4944651158515487`*^9, 3.4944651583516083`*^9, {3.494466570013584*^9, 
   3.494466572673588*^9}, 3.494466647603693*^9, {3.494467057404267*^9, 
   3.4944670607942715`*^9}, 3.49446712395436*^9, 3.4944674468548117`*^9, 
   3.49446751686491*^9, 3.494475807839758*^9, 3.494475861869834*^9, {
   3.494700331460866*^9, 3.494700347800889*^9}, {3.494720128369133*^9, 
   3.4947201298691354`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}], ")"}], "^", "p_."}], "/", 
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"c", "*", 
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "-", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "m", ",", "n", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.494439288643485*^9, 3.4944410948660135`*^9, 3.494462978308076*^9, 
   3.49446490938126*^9, 3.494466161643013*^9, 3.494466944194108*^9, 
   3.494467346814672*^9, {3.494467887745429*^9, 3.4944678903654327`*^9}, 
   3.4944756818095818`*^9, {3.4945277270559263`*^9, 3.4945277306059313`*^9}, {
   3.4947004261309986`*^9, 3.4947004798710737`*^9}, {3.494700525101137*^9, 
   3.49470052672114*^9}, {3.494720131499138*^9, 3.494720135459143*^9}, 
   3.4947215155710754`*^9, 3.494723381783688*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "+", 
     RowBox[{"n", " ", "p"}], "+", "1"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9, {3.494464984351364*^9, 3.4944650253214216`*^9}, 
   3.494465653082301*^9, {3.4944664950434794`*^9, 3.494466513563505*^9}, {
   3.49446702434422*^9, 3.494467025484222*^9}, 3.494467708295178*^9, {
   3.494468003285591*^9, 3.4944680151156073`*^9}, {3.4944764402606435`*^9, 
   3.4944764407606444`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}], "p"]}], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", "p"], 
       RowBox[{"ExpIntegralEi", "[", 
        RowBox[{
         RowBox[{"-", "p"}], " ", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}], "]"}]}], 
      RowBox[{"d", " ", "n"}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4944393492135696`*^9, 3.494439366993595*^9}, 
   3.4944395044737873`*^9, {3.4944412966462965`*^9, 3.4944413255163364`*^9}, 
   3.4944631289419403`*^9, 3.4944639664899397`*^9, 3.4944651248415613`*^9, 
   3.4944651836716433`*^9, {3.4944665849436054`*^9, 3.494466587053608*^9}, 
   3.4944666721637273`*^9, 3.4944670728742886`*^9, 3.4944671438243876`*^9, 
   3.494467449194815*^9, 3.4944675322149315`*^9, 3.494475814649768*^9, 
   3.494475892499877*^9, {3.494700560461187*^9, 3.4947005625911894`*^9}, {
   3.494700614051262*^9, 3.494700618441268*^9}, {3.4947009067016716`*^9, 
   3.494700910271676*^9}, {3.494720136849145*^9, 3.4947201376291466`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"ProductLog", "[", 
        RowBox[{"a_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "]"}], "^", "p_."}], "/", 
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "p"}], "*", 
    RowBox[{
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{
       RowBox[{"-", "p"}], "*", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "*", 
         RowBox[{"x", "^", "n"}]}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", "n"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "d", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"n", "*", "p"}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494439298133498*^9, 
   3.4944411032260256`*^9, 3.494462988260893*^9, 3.494464917621271*^9, 
   3.494466188753051*^9, 3.494466954574123*^9, 3.494467355464684*^9, 
   3.494475692979597*^9, {3.4945277313359327`*^9, 3.4945277320459332`*^9}, {
   3.4947012160221043`*^9, 3.4947012473621483`*^9}, {3.4947201407591505`*^9, 
   3.494720145459157*^9}, 3.4947234162137365`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"m", "+", 
     RowBox[{"n", 
      RowBox[{"(", 
       RowBox[{"p", "-", 
        FractionBox["1", "2"]}], ")"}]}], "+", "1"}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     FractionBox["c", 
      RowBox[{"p", "-", 
       FractionBox["1", "2"]}]], ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466465553438*^9, 3.4944664752134514`*^9}, {
   3.4944680948457193`*^9, 3.494468136735778*^9}, {3.494476455100664*^9, 
   3.4944764632206755`*^9}, {3.4947052709777813`*^9, 3.494705275567788*^9}, {
   3.4947054167679853`*^9, 3.494705419177989*^9}, {3.494788851374977*^9, 
   3.494788851374977*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"]}], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{"p", "-", 
         FractionBox["1", "2"]}]], 
       SuperscriptBox["c", 
        RowBox[{"p", "-", 
         FractionBox["1", "2"]}]], " "}], 
      RowBox[{"d", " ", "n", " "}]]}]}], 
   SqrtBox[
    FractionBox[
     RowBox[{"\[Pi]", " ", "c"}], 
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}]]], 
   RowBox[{"Erf", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]], 
     SqrtBox[
      FractionBox["c", 
       RowBox[{"p", "-", 
        FractionBox["1", "2"]}]]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, {3.4944665968236217`*^9, 3.4944665991136255`*^9}, 
   3.4944667003037667`*^9, 3.4944670813343*^9, 3.4944671751844316`*^9, 
   3.4944674514048185`*^9, 3.4944675493049555`*^9, 3.494475818239773*^9, 
   3.4944759378099403`*^9, {3.494705104027548*^9, 3.4947051302275844`*^9}, 
   3.494705214797703*^9, {3.4947201468991594`*^9, 3.4947201480391607`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}], ")"}], "^", "p_"}], "/", 
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", 
     RowBox[{"(", 
      RowBox[{"p", "-", 
       RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
    RowBox[{"c", "^", 
     RowBox[{"(", 
      RowBox[{"p", "-", 
       RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{"Pi", "*", 
       RowBox[{"c", "/", 
        RowBox[{"(", 
         RowBox[{"p", "-", 
          RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", "2"}], "]"}], "*", 
    RowBox[{
     RowBox[{"Erf", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}], "]"}], "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"c", "/", 
          RowBox[{"(", 
           RowBox[{"p", "-", 
            RowBox[{"1", "/", "2"}]}], ")"}]}], ",", "2"}], "]"}]}], "]"}], 
     "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", "n"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "\[NotEqual]", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "+", "1"}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"c", "/", 
      RowBox[{"(", 
       RowBox[{"p", "-", 
        RowBox[{"1", "/", "2"}]}], ")"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, 3.494466197663063*^9, 3.4944669651441374`*^9, 
   3.494467366114699*^9, {3.494468147565793*^9, 3.4944681521757994`*^9}, 
   3.4944757046196136`*^9, {3.4945277335759354`*^9, 3.4945277343059363`*^9}, {
   3.494705046367467*^9, 3.4947050877675247`*^9}, {3.494705344137884*^9, 
   3.494705373337925*^9}, {3.4947201505791645`*^9, 3.4947201550791707`*^9}, 
   3.4947215162810764`*^9, {3.4947275757795596`*^9, 3.4947275863895745`*^9}, {
   3.4947886708886595`*^9, 3.494788707127523*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "-", 
      FractionBox["1", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"m", "+", 
     RowBox[{"n", 
      RowBox[{"(", 
       RowBox[{"p", "-", 
        FractionBox["1", "2"]}], ")"}]}], "+", "1"}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     FractionBox["c", 
      RowBox[{"p", "-", 
       FractionBox["1", "2"]}]], "<", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466410603361*^9, 3.4944664524334197`*^9}, {
   3.494468168375822*^9, 3.4944681761758327`*^9}, {3.494476476230694*^9, 
   3.494476482930703*^9}, {3.494704738327036*^9, 3.494704742387041*^9}, {
   3.4947047732470846`*^9, 3.4947047732470846`*^9}, {3.4947888151205134`*^9, 
   3.4947888323117437`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"]}], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["a", 
        RowBox[{"p", "-", 
         FractionBox["1", "2"]}]], 
       SuperscriptBox["c", 
        RowBox[{"p", "-", 
         FractionBox["1", "2"]}]], " "}], 
      RowBox[{"d", " ", "n", " "}]]}]}], 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[Pi]", " ", "c"}], 
      RowBox[{"p", "-", 
       FractionBox["1", "2"]}]]}]], 
   RowBox[{"Erfi", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"c", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]], 
     SqrtBox[
      RowBox[{"-", 
       FractionBox["c", 
        RowBox[{"p", "-", 
         FractionBox["1", "2"]}]]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, 3.494466612693644*^9, 3.4944667280538054`*^9, {
   3.4944670878643093`*^9, 3.4944670907543135`*^9}, 3.4944672123744836`*^9, 
   3.494467453604821*^9, 3.4944675685649824`*^9, 3.4944758215597773`*^9, 
   3.49447598761001*^9, {3.4947046882869654`*^9, 3.494704717197006*^9}, {
   3.494720157289174*^9, 3.494720158289175*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}], ")"}], "^", "p_"}], "/", 
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", 
     RowBox[{"(", 
      RowBox[{"p", "-", 
       RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
    RowBox[{"c", "^", 
     RowBox[{"(", 
      RowBox[{"p", "-", 
       RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "Pi"}], "*", 
       RowBox[{"c", "/", 
        RowBox[{"(", 
         RowBox[{"p", "-", 
          RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", "2"}], "]"}], "*", 
    RowBox[{
     RowBox[{"Erfi", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}], "]"}], "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "c"}], "/", 
          RowBox[{"(", 
           RowBox[{"p", "-", 
            RowBox[{"1", "/", "2"}]}], ")"}]}], ",", "2"}], "]"}]}], "]"}], 
     "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", "n"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"p", "-", 
      RowBox[{"1", "/", "2"}]}], "\[NotEqual]", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "+", "1"}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"c", "/", 
      RowBox[{"(", 
       RowBox[{"p", "-", 
        RowBox[{"1", "/", "2"}]}], ")"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, {3.494466197663063*^9, 3.4944662173730907`*^9}, 
   3.494466972604148*^9, 3.4944673758047123`*^9, {3.4944681837358437`*^9, 
   3.494468190735853*^9}, 3.494475717889632*^9, {3.494527735055938*^9, 
   3.494527735855939*^9}, {3.4947047870371037`*^9, 3.494704788727106*^9}, {
   3.494704832717168*^9, 3.494704988447386*^9}, {3.4947201624791813`*^9, 
   3.4947201669191875`*^9}, 3.494721516941077*^9, {3.4947275929695835`*^9, 
   3.494727602559597*^9}, {3.494788685646285*^9, 3.4947887146155357`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"p", "+", 
     FractionBox[
      RowBox[{"m", "+", "1"}], "n"]}], ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466410603361*^9, 3.4944664524334197`*^9}, {
   3.4944682111458817`*^9, 3.4944682224058976`*^9}, {3.4944765229707594`*^9, 
   3.4944765415807858`*^9}, {3.4948217163144307`*^9, 3.494821738874462*^9}, {
   3.4948217952945414`*^9, 3.494821797304544*^9}, {3.4948218483746157`*^9, 
   3.4948218648046384`*^9}, {3.4948227119658246`*^9, 3.4948227131858263`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", " ", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"]}], 
     RowBox[{"d", "+", 
      RowBox[{"d", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                              ", 
      "\[IndentingNewLine]", "                  ", 
      FractionBox[
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", " ", 
           RowBox[{"ProductLog", "[", 
            RowBox[{"a", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}], ")"}], 
         RowBox[{"p", "-", "1"}]]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"c", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], ")"}]}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", " ", 
            SuperscriptBox["x", "n"]}], "]"}]}], ")"}], 
        RowBox[{"p", "-", "1"}]]}], 
      RowBox[{"d", "+", 
       RowBox[{"d", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, 3.494466612693644*^9, 3.4944667280538054`*^9, {
   3.4944670878643093`*^9, 3.4944670907543135`*^9}, 3.4944672123744836`*^9, 
   3.494467455604824*^9, 3.4944675970350223`*^9, 3.4944758250797825`*^9, 
   3.4944760177000523`*^9, 3.494705544278164*^9, {3.4947055813982162`*^9, 
   3.494705647748309*^9}, {3.494720169579191*^9, 3.4947201714291935`*^9}, {
   3.4948864396509132`*^9, 3.4948865147790456`*^9}, {3.4948866991249695`*^9, 
   3.4948867488110566`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}], ")"}], "^", "p_."}], "/", 
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"c", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"n", "*", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "*", 
             RowBox[{"ProductLog", "[", 
              RowBox[{"a", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"p", "-", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"d", "*", 
             RowBox[{"ProductLog", "[", 
              RowBox[{"a", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}]}], ")"}]}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "m", ",", "n", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"Simplify", "[", 
      RowBox[{"p", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], "]"}], "]"}], " ", "&&",
     " ", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{"p", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], "]"}], ">", 
     "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, {3.494466197663063*^9, 3.4944662173730907`*^9}, 
   3.494466972604148*^9, {3.4944673758047123`*^9, 3.4944674018947487`*^9}, 
   3.4944757296496487`*^9, {3.4945277366659393`*^9, 3.494527737405941*^9}, {
   3.4947057501284523`*^9, 3.494705783548499*^9}, {3.494705822838554*^9, 
   3.494705883198639*^9}, 3.4947059280687017`*^9, {3.494720173169196*^9, 
   3.494720179549205*^9}, 3.494721517561078*^9, {3.494820534252776*^9, 
   3.4948205382727814`*^9}, {3.494820579672839*^9, 3.4948206060628767`*^9}, {
   3.494821384413966*^9, 3.4948213864839687`*^9}, {3.4948214424140472`*^9, 
   3.4948214598840714`*^9}, {3.494821517974153*^9, 3.49482164434433*^9}, {
   3.4948218041445537`*^9, 3.4948218125345654`*^9}, {3.494822682705784*^9, 
   3.4948226846757865`*^9}, {3.4948251000631704`*^9, 3.494825105693178*^9}, {
   3.4948253064134593`*^9, 3.4948253080334616`*^9}, 3.4948253736535535`*^9, 
   3.494825450293661*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"p", "+", 
     FractionBox[
      RowBox[{"m", "+", "1"}], "n"]}], "<", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466410603361*^9, 3.4944664524334197`*^9}, {
   3.4944682361159167`*^9, 3.4944682448559294`*^9}, {3.4944683221760373`*^9, 
   3.4944683247460413`*^9}, {3.4944765695508246`*^9, 3.494476578900838*^9}, {
   3.4948218917346764`*^9, 3.4948219073346977`*^9}, {3.494821968474784*^9, 
   3.494821968474784*^9}, {3.494822107804979*^9, 3.494822107804979*^9}, {
   3.494822703145812*^9, 3.4948227046858144`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", " ", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"]}], 
     RowBox[{"d", "+", 
      RowBox[{"d", " ", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                               ", 
      "\[IndentingNewLine]", "                                        ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", " ", 
           RowBox[{"ProductLog", "[", 
            RowBox[{"a", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"n", " ", "p"}], "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", "1"}], 
    RowBox[{"c", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"n", " ", "p"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", " ", 
            SuperscriptBox["x", "n"]}], "]"}]}], ")"}], 
        RowBox[{"p", "+", "1"}]]}], 
      RowBox[{"d", "+", 
       RowBox[{"d", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, 3.494466612693644*^9, 3.4944667280538054`*^9, {
   3.4944670878643093`*^9, 3.4944670907543135`*^9}, 3.4944672123744836`*^9, 
   3.4944674575048265`*^9, {3.4944676243450603`*^9, 3.494467626815064*^9}, 
   3.4944758282197866`*^9, 3.494476062020114*^9, 3.4947055473581686`*^9, {
   3.4947056711483417`*^9, 3.4947057067883916`*^9}, {3.4947201812092075`*^9, 
   3.49472018320921*^9}, {3.4948864868393965`*^9, 3.4948865009262214`*^9}, {
   3.4948867314014263`*^9, 3.4948867431794467`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}], ")"}], "^", "p_."}], "/", 
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"n", "*", "p"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", 
           RowBox[{"n", "*", "p"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "*", 
             RowBox[{"ProductLog", "[", 
              RowBox[{"a", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"p", "+", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"d", "*", 
             RowBox[{"ProductLog", "[", 
              RowBox[{"a", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}]}], ")"}]}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "m", ",", "n", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"Simplify", "[", 
      RowBox[{"p", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], "]"}], "]"}], " ", "&&",
     " ", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{"p", "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], "]"}], "<", 
     "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, {3.494466197663063*^9, 3.4944662173730907`*^9}, 
   3.494466972604148*^9, 3.4944673758047123`*^9, 3.4944674100447607`*^9, {
   3.494468313176025*^9, 3.4944683166760297`*^9}, 3.494475739139662*^9, {
   3.4945277406359453`*^9, 3.494527741905947*^9}, {3.494705754038458*^9, 
   3.494705788458506*^9}, {3.4947058330985684`*^9, 3.494705890938649*^9}, 
   3.494705930838705*^9, {3.4947201849292126`*^9, 3.4947201913692217`*^9}, 
   3.4947215182010794`*^9, {3.4948220118348446`*^9, 3.4948220514149*^9}, {
   3.494822089334953*^9, 3.4948220899149537`*^9}, 3.4948226930457983`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466410603361*^9, 3.4944664524334197`*^9}, 
   3.4944682621759534`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", " ", "x"}], "]"}]}], ")"}], "p"]}], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", "x"}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{
         RowBox[{"m", "+", "p", "+", "1"}], ",", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}]}], " ", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", " ", "x"}], "]"}]}]}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", " ", "x"}], "]"}]}], ")"}], "p"]}], 
      RowBox[{"a", " ", "d", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"m", " ", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a", " ", "x"}], "]"}]}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}]}], " ", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", " ", "x"}], "]"}]}], ")"}], 
        RowBox[{"m", "+", "p"}]]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, 3.494466612693644*^9, 3.4944667280538054`*^9, {
   3.4944670878643093`*^9, 3.4944670907543135`*^9}, 3.4944672123744836`*^9, 
   3.4944674596448298`*^9, 3.4944676503050966`*^9, {3.4947066344796906`*^9, 
   3.494706639089697*^9}, {3.4947074014107637`*^9, 3.4947074299908037`*^9}, {
   3.4947201928192234`*^9, 3.4947201935792246`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_.", "*", "x_"}], "]"}]}], ")"}], "^", "p_."}], "/", 
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_.", "*", "x_"}], "]"}]}]}], ")"}]}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "m"}], "*", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      RowBox[{"m", "+", "p", "+", "1"}], ",", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], "*", 
       RowBox[{"ProductLog", "[", 
        RowBox[{"a", "*", "x"}], "]"}]}]}], "]"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", "*", "x"}], "]"}]}], ")"}], "^", "p"}], "/", "\n", "\t", 
     RowBox[{"(", 
      RowBox[{"a", "*", "d", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "*", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"m", "*", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", "*", "x"}], "]"}]}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}]}], "*", 
          RowBox[{"ProductLog", "[", 
           RowBox[{"a", "*", "x"}], "]"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "p"}], ")"}]}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "m", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, {3.494466197663063*^9, 3.4944662173730907`*^9}, 
   3.494466972604148*^9, 3.4944673758047123`*^9, 3.4944674170647707`*^9, {
   3.4944682702259645`*^9, 3.494468284195984*^9}, {3.494706652639716*^9, 
   3.494706666339735*^9}, {3.494707466120855*^9, 3.4947075018509045`*^9}, {
   3.494720195399227*^9, 3.4947201980892305`*^9}, 3.4947215189910803`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9, 3.494465499612086*^9, 
   3.4944684694762435`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
   RowBox[{"-", 
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"\[Integral]", 
       RowBox[{
        FractionBox[
         RowBox[{"f", "[", 
          FractionBox["1", "x"], "]"}], 
         SuperscriptBox["x", "2"]], 
        RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
      FractionBox["1", "x"]}], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9, {3.494465499612086*^9, 
   3.4944655112721024`*^9}, 3.494465544312148*^9, 3.4944663200732346`*^9, {
   3.4944686423964853`*^9, 3.4944686449964895`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "<", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.49444016365471*^9, 3.494440185694741*^9}, {
   3.494440950745812*^9, 3.4944409704958396`*^9}, {3.494441001285883*^9, 
   3.4944410095858946`*^9}, {3.4944413528063745`*^9, 3.4944413704964*^9}, {
   3.4944414508265123`*^9, 3.4944414523765144`*^9}, {3.4944640040799923`*^9, 
   3.4944640158600087`*^9}, {3.4944650706114855`*^9, 
   3.4944650748714914`*^9}, {3.494466410603361*^9, 3.4944664524334197`*^9}, {
   3.4944682111458817`*^9, 3.4944682224058976`*^9}, {3.4944697034911737`*^9, 
   3.494469716641192*^9}, {3.4944753559991255`*^9, 3.494475376309154*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        RowBox[{"ProductLog", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}], ")"}], "p"]}], 
    RowBox[{"d", "+", 
     RowBox[{"d", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"\[Integral]", 
         RowBox[{
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"c", " ", 
              RowBox[{"ProductLog", "[", 
               RowBox[{"a", " ", 
                SuperscriptBox["x", 
                 RowBox[{"-", "n"}]]}], "]"}]}], ")"}], "p"], 
           RowBox[{
            SuperscriptBox["x", 
             RowBox[{"m", "+", "2"}]], 
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"d", " ", 
               RowBox[{"ProductLog", "[", 
                RowBox[{"a", " ", 
                 SuperscriptBox["x", 
                  RowBox[{"-", "n"}]]}], "]"}]}]}], ")"}]}]], 
          RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
        FractionBox["1", "x"]}], "]"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944393519535737`*^9, {3.4944398753843064`*^9, 
   3.494439898614339*^9}, 3.494441298476299*^9, 3.494441429966483*^9, 
   3.4944631327015467`*^9, 3.494464044490049*^9, 3.4944651331615725`*^9, 
   3.4944652243017006`*^9, 3.494466612693644*^9, 3.4944667280538054`*^9, {
   3.4944670878643093`*^9, 3.4944670907543135`*^9}, 3.4944672123744836`*^9, 
   3.4944674596448298`*^9, 3.4944676503050966`*^9, 3.494475832209792*^9, 
   3.494476360790532*^9, {3.4947067465798473`*^9, 3.4947067530798564`*^9}, {
   3.4947067955499163`*^9, 3.494706804269928*^9}, {3.494706845139985*^9, 
   3.4947068513499937`*^9}, {3.494706956260141*^9, 3.494706963400151*^9}, {
   3.494720200989235*^9, 3.4947202027692375`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}], ")"}], "^", "p_."}], "/", 
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"ProductLog", "[", 
          RowBox[{"a_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], ")"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "*", 
            RowBox[{"ProductLog", "[", 
             RowBox[{"a", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"-", "n"}], ")"}]}]}], "]"}]}], ")"}], "^", "p"}], 
         "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "+", "2"}], ")"}]}], "*", 
           RowBox[{"(", 
            RowBox[{"d", "+", 
             RowBox[{"d", "*", 
              RowBox[{"ProductLog", "[", 
               RowBox[{"a", "*", 
                RowBox[{"x", "^", 
                 RowBox[{"(", 
                  RowBox[{"-", "n"}], ")"}]}]}], "]"}]}]}], ")"}]}], ")"}]}], 
        ",", "x"}], "]"}], ",", "x", ",", 
      RowBox[{"1", "/", "x"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, {3.494439298133498*^9, 
   3.4944393224735327`*^9}, 3.494441111366037*^9, 3.494462995967307*^9, 
   3.49446492397128*^9, {3.494466197663063*^9, 3.4944662173730907`*^9}, 
   3.494466972604148*^9, 3.4944673758047123`*^9, 3.4944674170647707`*^9, {
   3.4944682702259645`*^9, 3.494468284195984*^9}, 3.4944757477296743`*^9, {
   3.4947067718698826`*^9, 3.494706775629888*^9}, {3.4947068747100267`*^9, 
   3.4947069303401046`*^9}, {3.4947069796501737`*^9, 3.494707003330207*^9}, {
   3.4947202042692394`*^9, 3.4947202091792464`*^9}, 3.494721519611081*^9, 
   3.517191378363103*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.494099661002176*^9, 
   3.4944391510732927`*^9, 3.494439343783562*^9, 3.494441172446122*^9, 
   3.4944629636440496`*^9, 3.4944649657213383`*^9, 3.494476772451109*^9, 
   3.4944770591515102`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Author: Rob Corless 2009-07-10", "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9, 3.4944768311811905`*^9, 
   3.494477088501551*^9, 3.494477238611761*^9}],

Cell["Derivation:  Legendre substitution for inverse functions", \
"Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9, 3.4944768311811905`*^9, 
   3.494477088501551*^9, 3.49447725925179*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"ProductLog", "[", "x", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ProductLog", "[", "z", "]"}], "+", "1"}], ")"}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"ProductLog", "[", "z", "]"}]], " ", 
    RowBox[{"f", "[", 
     RowBox[{"ProductLog", "[", "x", "]"}], "]"}], " ", 
    RowBox[{
     SuperscriptBox["ProductLog", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4941724567488375`*^9, {3.494441191516149*^9, 3.4944411920661497`*^9}, 
   3.494463053547008*^9, 3.4944649466413116`*^9, {3.4944768311811905`*^9, 
   3.494476844311209*^9}, 3.494476889791273*^9, 3.494477157791648*^9, 
   3.4944772857618275`*^9, {3.494477947852754*^9, 3.4944779517727594`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, {3.4944394162836637`*^9, 
   3.4944394240236745`*^9}, {3.4944412114461765`*^9, 3.49444121338618*^9}, 
   3.494463864019796*^9, {3.494464984351364*^9, 3.4944650253214216`*^9}, 
   3.494465653082301*^9, 3.4944769126313047`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"ProductLog", "[", "x", "]"}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"\[Integral]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "+", "1"}], ")"}], " ", 
         SuperscriptBox["\[ExponentialE]", "x"], " ", 
         RowBox[{"f", "[", "x", "]"}], 
         RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
       RowBox[{"ProductLog", "[", "x", "]"}]}], "]"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, {3.4944393492135696`*^9, 3.494439366993595*^9}, 
   3.4944395044737873`*^9, {3.4944412966462965`*^9, 3.4944413255163364`*^9}, 
   3.4944631289419403`*^9, 3.4944639664899397`*^9, 3.4944651248415613`*^9, 
   3.4944651836716433`*^9, 3.4944769394113426`*^9, 3.494477003101432*^9, {
   3.4944775148221483`*^9, 3.494477547652194*^9}, {3.494477611782284*^9, 
   3.4944776693823643`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"Regularize", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "+", "1"}], ")"}], "*", 
          RowBox[{"E", "^", "x"}], "*", 
          RowBox[{"SubstFor", "[", 
           RowBox[{
            RowBox[{"ProductLog", "[", "x", "]"}], ",", "u", ",", "x"}], 
           "]"}]}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
     RowBox[{"ProductLog", "[", "x", "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{"FunctionOfQ", "[", 
    RowBox[{
     RowBox[{"ProductLog", "[", "x", "]"}], ",", "u", ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.494439298133498*^9, 
   3.4944411032260256`*^9, 3.494462988260893*^9, 3.494464917621271*^9, 
   3.4944768117611637`*^9, {3.494477196771703*^9, 3.494477210021721*^9}, {
   3.4947920191177425`*^9, 3.494792022768149*^9}, {3.4947930069554787`*^9, 
   3.4947930097790833`*^9}},
 Background->GrayLevel[0.85]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Product Logarithm Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1143, 25, 118, "Title"],
Cell[1713, 49, 1010, 20, 365, "Subsubsection"],
Cell[2726, 71, 2806, 69, 1194, "Subsubtitle"],
Cell[5535, 142, 795, 11, 354, "Subsubsection"],
Cell[6333, 155, 2242, 66, 1345, "Code"],
Cell[8578, 223, 113, 2, 354, "Subsubsection"],
Cell[8694, 227, 202, 3, 243, "Subsubsection"],
Cell[8899, 232, 1109, 22, 261, "Subsubsection"],
Cell[10011, 256, 113, 2, 243, "Subsubsection"],
Cell[10127, 260, 2642, 62, 1167, "Subsubtitle"],
Cell[12772, 324, 795, 11, 354, "Subsubsection"],
Cell[13570, 337, 2086, 60, 1345, "Code"],
Cell[15659, 399, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[15740, 405, 1186, 25, 89, "Title"],
Cell[16929, 432, 911, 13, 345183372, "Subsubsection"],
Cell[17843, 447, 1839, 37, 624109465, "Subsubtitle"],
Cell[19685, 486, 795, 11, 345183372, "Subsubsection"],
Cell[20483, 499, 1207, 32, 1056008744, "Code"],
Cell[21693, 533, 44, 1, 24918085, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[21774, 539, 1368, 31, 92, "Title"],
Cell[23145, 572, 228, 3, 354, "Subsubsection"],
Cell[23376, 577, 430, 13, 377, "Subsubsection"],
Cell[23809, 592, 913, 13, 243, "Subsubsection"],
Cell[24725, 607, 2048, 44, 638, "Subsubtitle"],
Cell[26776, 653, 795, 11, 354, "Subsubsection"],
Cell[27574, 666, 1486, 39, 1345, "Code"],
Cell[29063, 707, 113, 2, 354, "Subsubsection"],
Cell[29179, 711, 1145, 16, 243, "Subsubsection"],
Cell[30327, 729, 1935, 41, 638, "Subsubtitle"],
Cell[32265, 772, 795, 11, 354, "Subsubsection"],
Cell[33063, 785, 1459, 37, 1079, "Code"],
Cell[34525, 824, 113, 2, 354, "Subsubsection"],
Cell[34641, 828, 1272, 22, 261, "Subsubsection"],
Cell[35916, 852, 2307, 52, 769, "Subsubtitle"],
Cell[38226, 906, 795, 11, 354, "Subsubsection"],
Cell[39024, 919, 2073, 53, 1079, "Code"],
Cell[41100, 974, 113, 2, 354, "Subsubsection"],
Cell[41216, 978, 1298, 22, 261, "Subsubsection"],
Cell[42517, 1002, 2405, 55, 769, "Subsubtitle"],
Cell[44925, 1059, 795, 11, 354, "Subsubsection"],
Cell[45723, 1072, 2173, 56, 1079, "Code"],
Cell[47899, 1130, 113, 2, 354, "Subsubsection"],
Cell[48015, 1134, 1246, 21, 261, "Subsubsection"],
Cell[49264, 1157, 3073, 73, 1318, "Subsubtitle"],
Cell[52340, 1232, 795, 11, 354, "Subsubsection"],
Cell[53138, 1245, 2629, 73, 1345, "Code"],
Cell[55770, 1320, 113, 2, 354, "Subsubsection"],
Cell[55886, 1324, 1263, 22, 261, "Subsubsection"],
Cell[57152, 1348, 3180, 77, 1318, "Subsubtitle"],
Cell[60335, 1427, 795, 11, 354, "Subsubsection"],
Cell[61133, 1440, 2789, 78, 1345, "Code"],
Cell[63925, 1520, 113, 2, 354, "Subsubsection"],
Cell[64041, 1524, 1219, 17, 243, "Subsubsection"],
Cell[65263, 1543, 2866, 64, 662, "Subsubtitle"],
Cell[68132, 1609, 795, 11, 354, "Subsubsection"],
Cell[68930, 1622, 2274, 59, 1079, "Code"],
Cell[71207, 1683, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[71288, 1689, 1176, 26, 80, "Title"],
Cell[72467, 1717, 189, 3, 8523964, "Subsubsection"],
Cell[72659, 1722, 1338, 23, 6278033, "Subsubsection"],
Cell[74000, 1747, 2181, 49, 14635844, "Subsubtitle"],
Cell[76184, 1798, 795, 11, 8523964, "Subsubsection"],
Cell[76982, 1811, 1966, 52, 26077096, "Code"],
Cell[78951, 1865, 44, 1, 615329, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[79032, 1871, 1214, 26, 92, "Title"],
Cell[80249, 1899, 189, 3, 246559556, "Subsubsection"],
Cell[80441, 1904, 1338, 23, 181594971, "Subsubsection"],
Cell[81782, 1929, 2239, 50, 590070473, "Subsubtitle"],
Cell[84024, 1981, 795, 11, 246559556, "Subsubsection"],
Cell[84822, 1994, 2018, 54, 754291973, "Code"],
Cell[86843, 2050, 44, 1, 17798633, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[86924, 2056, 1447, 34, 92, "Title"],
Cell[88374, 2092, 189, 3, 246559556, "Subsubsection"],
Cell[88566, 2097, 1338, 23, 181594971, "Subsubsection"],
Cell[89907, 2122, 2671, 63, 590070473, "Subsubtitle"],
Cell[92581, 2187, 795, 11, 246559556, "Subsubsection"],
Cell[93379, 2200, 2487, 66, 754291973, "Code"],
Cell[95869, 2268, 44, 1, 17798633, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[95950, 2274, 1214, 26, 80, "Title"],
Cell[97167, 2302, 202, 3, 130, "Subsubsection"],
Cell[97372, 2307, 1640, 39, 145, "Subsubsection"],
Cell[99015, 2348, 2428, 54, 277, "Subsubtitle"],
Cell[101446, 2404, 795, 11, 130, "Subsubsection"],
Cell[102244, 2417, 2399, 70, 491, "Code"],
Cell[104646, 2489, 113, 2, 130, "Subsubsection"],
Cell[104762, 2493, 1726, 43, 145, "Subsubsection"],
Cell[106491, 2538, 2753, 65, 281, "Subsubtitle"],
Cell[109247, 2605, 795, 11, 130, "Subsubsection"],
Cell[110045, 2618, 2806, 83, 491, "Code"],
Cell[112854, 2703, 113, 2, 130, "Subsubsection"],
Cell[112970, 2707, 259, 4, 90, "Subsubsection"],
Cell[113232, 2713, 834, 24, 194, "Subsubsection"],
Cell[114069, 2739, 1390, 24, 96, "Subsubsection"],
Cell[115462, 2765, 2259, 48, 250, "Subsubtitle"],
Cell[117724, 2815, 795, 11, 130, "Subsubsection"],
Cell[118522, 2828, 1716, 45, 394, "Code"],
Cell[120241, 2875, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[120322, 2881, 1365, 28, 89, "Title"],
Cell[121690, 2911, 259, 4, 8523964, "Subsubsection"],
Cell[121952, 2917, 834, 24, 12787316, "Subsubsection"],
Cell[122789, 2943, 1444, 25, 6278033, "Subsubsection"],
Cell[124236, 2970, 2462, 51, 16706968, "Subsubtitle"],
Cell[126701, 3023, 795, 11, 8523964, "Subsubsection"],
Cell[127499, 3036, 1837, 47, 26077096, "Code"],
Cell[129339, 3085, 44, 1, 615329, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[129420, 3091, 1516, 33, 93, "Title"],
Cell[130939, 3126, 1420, 27, 8789246, "Subsubsection"],
Cell[132362, 3155, 2381, 49, 18584459, "Subsubtitle"],
Cell[134746, 3206, 795, 11, 8523964, "Subsubsection"],
Cell[135544, 3219, 1895, 49, 26077096, "Code"],
Cell[137442, 3270, 113, 2, 8523964, "Subsubsection"],
Cell[137558, 3274, 1452, 28, 9503316, "Subsubsection"],
Cell[139013, 3304, 2349, 48, 18281241, "Subsubtitle"],
Cell[141365, 3354, 795, 11, 8523964, "Subsubsection"],
Cell[142163, 3367, 1877, 48, 26077096, "Code"],
Cell[144043, 3417, 113, 2, 8523964, "Subsubsection"],
Cell[144159, 3421, 1962, 37, 9503316, "Subsubsection"],
Cell[146124, 3460, 2655, 59, 20399693, "Subsubtitle"],
Cell[148782, 3521, 795, 11, 8523964, "Subsubsection"],
Cell[149580, 3534, 2915, 73, 26077096, "Code"],
Cell[152498, 3609, 113, 2, 8523964, "Subsubsection"],
Cell[152614, 3613, 1969, 37, 9503316, "Subsubsection"],
Cell[154586, 3652, 2730, 61, 20399693, "Subsubtitle"],
Cell[157319, 3715, 795, 11, 8523964, "Subsubsection"],
Cell[158117, 3728, 2930, 74, 26077096, "Code"],
Cell[161050, 3804, 113, 2, 8523964, "Subsubsection"],
Cell[161166, 3808, 1563, 29, 6278033, "Subsubsection"],
Cell[162732, 3839, 3049, 72, 18584459, "Subsubtitle"],
Cell[165784, 3913, 795, 11, 8523964, "Subsubsection"],
Cell[166582, 3926, 3006, 83, 32503196, "Code"],
Cell[169591, 4011, 113, 2, 8523964, "Subsubsection"],
Cell[169707, 4015, 1568, 28, 6278033, "Subsubsection"],
Cell[171278, 4045, 3139, 75, 18584459, "Subsubtitle"],
Cell[174420, 4122, 795, 11, 8523964, "Subsubsection"],
Cell[175218, 4135, 3071, 84, 32503196, "Code"],
Cell[178292, 4221, 113, 2, 8523964, "Subsubsection"],
Cell[178408, 4225, 259, 4, 5841915, "Subsubsection"],
Cell[178670, 4231, 834, 24, 12787316, "Subsubsection"],
Cell[179507, 4257, 1444, 25, 6278033, "Subsubsection"],
Cell[180954, 4284, 2927, 64, 18281241, "Subsubtitle"],
Cell[183884, 4350, 795, 11, 8523964, "Subsubsection"],
Cell[184682, 4363, 2446, 65, 26077096, "Code"],
Cell[187131, 4430, 44, 1, 615329, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[187212, 4436, 1201, 26, 80, "Title"],
Cell[188416, 4464, 795, 11, 354, "Subsubsection"],
Cell[189214, 4477, 202, 3, 243, "Subsubsection"],
Cell[189419, 4482, 2662, 63, 394, "Subsubsection"],
Cell[192084, 4547, 2939, 69, 1282, "Subsubtitle"],
Cell[195026, 4618, 795, 11, 354, "Subsubsection"],
Cell[195824, 4631, 4850, 122, 1873, "Code"],
Cell[200677, 4755, 113, 2, 354, "Subsubsection"],
Cell[200793, 4759, 2490, 60, 394, "Subsubsection"],
Cell[203286, 4821, 3034, 73, 1300, "Subsubtitle"],
Cell[206323, 4896, 795, 11, 354, "Subsubsection"],
Cell[207121, 4909, 4537, 121, 2134, "Code"],
Cell[211661, 5032, 113, 2, 354, "Subsubsection"],
Cell[211777, 5036, 228, 3, 243, "Subsubsection"],
Cell[212008, 5041, 456, 13, 377, "Subsubsection"],
Cell[212467, 5056, 1161, 16, 243, "Subsubsection"],
Cell[213631, 5074, 2724, 64, 683, "Subsubtitle"],
Cell[216358, 5140, 795, 11, 354, "Subsubsection"],
Cell[217156, 5153, 2505, 65, 1345, "Code"],
Cell[219664, 5220, 113, 2, 354, "Subsubsection"],
Cell[219780, 5224, 189, 3, 243, "Subsubsection"],
Cell[219972, 5229, 834, 24, 530, "Subsubsection"],
Cell[220809, 5255, 1609, 29, 261, "Subsubsection"],
Cell[222421, 5286, 2272, 49, 683, "Subsubtitle"],
Cell[224696, 5337, 795, 11, 354, "Subsubsection"],
Cell[225494, 5350, 1910, 52, 1079, "Code"],
Cell[227407, 5404, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[227488, 5410, 1363, 28, 92, "Title"],
Cell[228854, 5440, 1317, 18, 93, "Subsubsection"],
Cell[230174, 5460, 2234, 43, 198, "Subsubtitle"],
Cell[232411, 5505, 795, 11, 93, "Subsubsection"],
Cell[233209, 5518, 1459, 35, 282, "Code"],
Cell[234671, 5555, 113, 2, 93, "Subsubsection"],
Cell[234787, 5559, 1117, 20, 69, "Subsubsection"],
Cell[235907, 5581, 2715, 61, 344, "Subsubtitle"],
Cell[238625, 5644, 795, 11, 93, "Subsubsection"],
Cell[239423, 5657, 2040, 57, 351, "Code"],
Cell[241466, 5716, 113, 2, 93, "Subsubsection"],
Cell[241582, 5720, 1107, 21, 69, "Subsubsection"],
Cell[242692, 5743, 2237, 50, 179, "Subsubtitle"],
Cell[244932, 5795, 795, 11, 93, "Subsubsection"],
Cell[245730, 5808, 1775, 50, 351, "Code"],
Cell[247508, 5860, 113, 2, 93, "Subsubsection"],
Cell[247624, 5864, 1278, 22, 69, "Subsubsection"],
Cell[248905, 5888, 2552, 59, 174, "Subsubtitle"],
Cell[251460, 5949, 795, 11, 93, "Subsubsection"],
Cell[252258, 5962, 2015, 57, 351, "Code"],
Cell[254276, 6021, 113, 2, 93, "Subsubsection"],
Cell[254392, 6025, 259, 4, 65, "Subsubsection"],
Cell[254654, 6031, 834, 24, 139, "Subsubsection"],
Cell[255491, 6057, 1609, 29, 69, "Subsubsection"],
Cell[257103, 6088, 2499, 53, 187, "Subsubtitle"],
Cell[259605, 6143, 795, 11, 93, "Subsubsection"],
Cell[260403, 6156, 2069, 54, 282, "Code"],
Cell[262475, 6212, 44, 1, 8, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[262556, 6218, 1524, 35, 93, "Title"],
Cell[264083, 6255, 1269, 17, 67, "Subsubsection"],
Cell[265355, 6274, 2397, 50, 142, "Subsubtitle"],
Cell[267755, 6326, 795, 11, 67, "Subsubsection"],
Cell[268553, 6339, 1872, 46, 202, "Code"],
Cell[270428, 6387, 113, 2, 67, "Subsubsection"],
Cell[270544, 6391, 1532, 30, 50, "Subsubsection"],
Cell[272079, 6423, 2531, 56, 144, "Subsubtitle"],
Cell[274613, 6481, 795, 11, 67, "Subsubsection"],
Cell[275411, 6494, 2308, 61, 202, "Code"],
Cell[277722, 6557, 113, 2, 67, "Subsubsection"],
Cell[277838, 6561, 1377, 27, 50, "Subsubsection"],
Cell[279218, 6590, 2404, 50, 142, "Subsubtitle"],
Cell[281625, 6642, 795, 11, 67, "Subsubsection"],
Cell[282423, 6655, 1826, 48, 202, "Code"],
Cell[284252, 6705, 113, 2, 67, "Subsubsection"],
Cell[284368, 6709, 2039, 43, 93, "Subsubsection"],
Cell[286410, 6754, 2751, 66, 214, "Subsubtitle"],
Cell[289164, 6822, 795, 11, 67, "Subsubsection"],
Cell[289962, 6835, 3194, 89, 202, "Code"],
Cell[293159, 6926, 113, 2, 67, "Subsubsection"],
Cell[293275, 6930, 2041, 43, 93, "Subsubsection"],
Cell[295319, 6975, 2774, 68, 214, "Subsubtitle"],
Cell[298096, 7045, 795, 11, 67, "Subsubsection"],
Cell[298894, 7058, 3260, 91, 202, "Code"],
Cell[302157, 7151, 113, 2, 67, "Subsubsection"],
Cell[302273, 7155, 1730, 31, 75, "Subsubsection"],
Cell[304006, 7188, 3650, 89, 1094, "Subsubtitle"],
Cell[307659, 7279, 795, 11, 253, "Subsubsection"],
Cell[308457, 7292, 4115, 109, 961, "Code"],
Cell[312575, 7403, 113, 2, 253, "Subsubsection"],
Cell[312691, 7407, 1776, 32, 282, "Subsubsection"],
Cell[314470, 7441, 3642, 87, 1094, "Subsubtitle"],
Cell[318115, 7530, 795, 11, 253, "Subsubsection"],
Cell[318913, 7543, 3724, 103, 961, "Code"],
Cell[322640, 7648, 113, 2, 253, "Subsubsection"],
Cell[322756, 7652, 1306, 23, 187, "Subsubsection"],
Cell[324065, 7677, 3098, 72, 475, "Subsubtitle"],
Cell[327166, 7751, 795, 11, 253, "Subsubsection"],
Cell[327964, 7764, 2665, 72, 961, "Code"],
Cell[330632, 7838, 113, 2, 253, "Subsubsection"],
Cell[330748, 7842, 259, 4, 174, "Subsubsection"],
Cell[331010, 7848, 834, 24, 379, "Subsubsection"],
Cell[331847, 7874, 1609, 29, 187, "Subsubsection"],
Cell[333459, 7905, 3068, 68, 541, "Subsubtitle"],
Cell[336530, 7975, 795, 11, 253, "Subsubsection"],
Cell[337328, 7988, 2770, 73, 771, "Code"],
Cell[340101, 8063, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[340182, 8069, 1088, 23, 80, "Title"],
Cell[341273, 8094, 272, 4, 8523964, "Subsubsection"],
Cell[341548, 8100, 299, 5, 5841915, "Subsubsection"],
Cell[341850, 8107, 866, 22, 6278033, "Subsubsection"],
Cell[342719, 8131, 935, 13, 5841915, "Subsubsection"],
Cell[343657, 8146, 1915, 37, 13274614, "Subsubtitle"],
Cell[345575, 8185, 795, 11, 8523964, "Subsubsection"],
Cell[346373, 8198, 1297, 31, 26077096, "Code"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
