(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    574413,      14801]
NotebookOptionsPosition[    553195,      14319]
NotebookOutlinePosition[    554315,      14358]
CellTagsIndexPosition[    554272,      14355]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976622401126223`*^9, 3.4990190901257534`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497662072225127*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Sinh", "[", "z", "]"}]}]}], "=", 
   RowBox[{"2", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"Cosh", "[", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[Pi]", " ", "a"}], 
         RowBox[{"4", " ", "b"}]]}], "+", 
       FractionBox["z", "2"]}], "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4982405233131886`*^9, 3.498240529443197*^9}, {
   3.4990190901357536`*^9, 3.4990190901357536`*^9}, {3.499019132695813*^9, 
   3.499019132695813*^9}, {3.499019899106886*^9, 3.4990198997068872`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "<", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.4976627174890604`*^9, 3.4976627219194684`*^9}, {3.498240539593211*^9, 
   3.498240539593211*^9}, {3.499019966826981*^9, 3.4990199736969905`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", " ", "a"}], ")"}], "n"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Cosh", "[", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[Pi]", " ", "a"}], 
          RowBox[{"4", " ", "b"}]]}], "+", 
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}], 
      RowBox[{"2", " ", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.497662217242982*^9, 3.497662244168629*^9}, 
   3.4990190901357536`*^9, 3.499019132695813*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "*", "a"}], ")"}], "^", "n"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "Pi"}], "*", 
            RowBox[{"a", "/", 
             RowBox[{"(", 
              RowBox[{"4", "*", "b"}], ")"}]}]}], "+", 
           RowBox[{"c", "/", "2"}], "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976620538794947`*^9, 
   3.4990190901357536`*^9, 3.4990191327058134`*^9, 3.499019960306972*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Algebraic simplification and piecewise constant extraction\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497662620893691*^9, 3.497662652733347*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Sinh", "[", "z", "]"}]}]}], "=", 
   RowBox[{"2", " ", "a", " ", 
    SuperscriptBox[
     RowBox[{"Cosh", "[", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[Pi]", " ", "a"}], 
         RowBox[{"4", " ", "b"}]]}], "+", 
       FractionBox["z", "2"]}], "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.4976625130975018`*^9, {3.497662579023217*^9, 3.4976625841556263`*^9}, {
   3.498240554503232*^9, 3.498240554503232*^9}, {3.499019090145754*^9, 
   3.499019090145754*^9}, {3.4990191327058134`*^9, 3.4990191327058134`*^9}, {
   3.4990201091771803`*^9, 3.4990201091771803`*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sinh", "[", "z", "]"}]}]}]], 
     RowBox[{"Cosh", "[", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[Pi]", " ", "a"}], 
         RowBox[{"4", " ", "b"}]]}], "+", 
       FractionBox["z", "2"]}], "]"}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, {
   3.4976625130975018`*^9, 3.4976625346879396`*^9}, 3.497662595840047*^9, {
   3.498240558183237*^9, 3.498240558183237*^9}, {3.4990190901557536`*^9, 
   3.4990190901557536`*^9}, {3.4990191327058134`*^9, 
   3.4990191327058134`*^9}, {3.49902011614719*^9, 3.49902011614719*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"n", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.49766243823297*^9, 3.4976624525849953`*^9}, {3.4982405631832438`*^9, 
   3.4982405631832438`*^9}, {3.4990201223571987`*^9, 3.4990201223571987`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", " ", "a"}], ")"}], 
        RowBox[{"n", "-", 
         FractionBox["1", "2"]}]], " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sinh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
      RowBox[{"Cosh", "[", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[Pi]", " ", "a"}], 
          RowBox[{"4", " ", "b"}]]}], "+", 
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Cosh", "[", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[Pi]", " ", "a"}], 
          RowBox[{"4", " ", "b"}]]}], "+", 
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}], 
      RowBox[{"2", " ", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, {
   3.4976623833052735`*^9, 3.4976624037569094`*^9}, {3.4990190901557536`*^9, 
   3.4990190901557536`*^9}, {3.499019132715813*^9, 3.499019132715813*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "*", "a"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sinh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
       RowBox[{"Cosh", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "Pi"}], "*", 
          RowBox[{"a", "/", 
           RowBox[{"(", 
            RowBox[{"4", "*", "b"}], ")"}]}]}], "+", 
         RowBox[{"c", "/", "2"}], "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "/", "2"}]}]}], "]"}]}]}], ",", "\n", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "Pi"}], "*", 
            RowBox[{"a", "/", 
             RowBox[{"(", 
              RowBox[{"4", "*", "b"}], ")"}]}]}], "+", 
           RowBox[{"c", "/", "2"}], "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976620452370796`*^9, 3.497662356878827*^9, {
   3.497662464394216*^9, 3.497662468965024*^9}, {3.497844840747451*^9, 
   3.4978448419874525`*^9}, {3.4990190901557536`*^9, 
   3.4990190901557536`*^9}, {3.499019132715813*^9, 3.499019132715813*^9}, 
   3.499020090937155*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497662620893691*^9, 3.497662652733347*^9}, 
   3.497662905609791*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], ")"}], "2"]], "=", 
   RowBox[{
    FractionBox["a", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}]}]], "+", 
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", 
        RowBox[{"a", " ", "z"}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "z"}]}], ")"}], "2"]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.4976625130975018`*^9, {3.497662579023217*^9, 3.4976625841556263`*^9}, {
   3.497662923331422*^9, 3.497662936139045*^9}, {3.499020231637352*^9, 
   3.499020231637352*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "+", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.49766243823297*^9, 3.4976624525849953`*^9}, {3.4976629473554645`*^9, 
   3.49766295624748*^9}, {3.4982405753732615`*^9, 3.4982405793132668`*^9}, {
   3.499020266797401*^9, 3.499020267357402*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["a", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"]}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["x", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["b", 
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{"b", "-", 
         RowBox[{"a", " ", 
          RowBox[{"Sinh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sinh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, {
   3.4976623833052735`*^9, 3.4976624037569094`*^9}, {3.497663070736081*^9, 
   3.4976631028721375`*^9}, {3.4990190901657534`*^9, 
   3.4990190901657534`*^9}, {3.499020281147421*^9, 3.499020315247469*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Sinh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "-", 
            RowBox[{"a", "*", 
             RowBox[{"Sinh", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"Sinh", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "2"}]}]}], 
        ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976620452370796`*^9, 3.497662356878827*^9, {
   3.497662464394216*^9, 3.497662468965024*^9}, 3.497662899853381*^9, {
   3.4990190901657534`*^9, 3.4990190901757536`*^9}, 3.499020260597392*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497662620893691*^9, 3.497662652733347*^9}, 
   3.497662905609791*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Sinh", "[", "z", "]"}]}]}], "=", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "b"}], "+", 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["\[ExponentialE]", "z"]}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "z"}]]}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", "z"]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.4976625130975018`*^9, {3.497662579023217*^9, 3.4976625841556263`*^9}, {
   3.497662923331422*^9, 3.497662936139045*^9}, 3.497663013827181*^9, {
   3.4990190901757536`*^9, 3.4990190901757536`*^9}, {3.4990203600475316`*^9, 
   3.4990203600475316`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.49766243823297*^9, 3.4976624525849953`*^9}, {3.4976629473554645`*^9, 
   3.49766295624748*^9}, {3.497663154773429*^9, 3.497663222165547*^9}, {
   3.498240592533285*^9, 3.498240592533285*^9}, {3.499020403627592*^9, 
   3.499020403627592*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["2", "n"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "b"}], "+", 
          RowBox[{"2", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}]]}], "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], ")"}]}]]}]}], ")"}], "n"]}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"n", " ", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, {
   3.4976623833052735`*^9, 3.4976624037569094`*^9}, 3.4976631413262053`*^9, 
   3.499019090185754*^9, 3.4990204362376385`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"2", "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "b"}], "+", 
            RowBox[{"2", "*", "a", "*", 
             RowBox[{"E", "^", 
              RowBox[{"(", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], ")"}]}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"E", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", 
                RowBox[{"(", 
                 RowBox[{"c", "+", 
                  RowBox[{"d", "*", "x"}]}], ")"}]}], ")"}]}]}]}], ")"}], "^",
           "n"}], "/", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{"n", "*", 
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}]}], ")"}]}]}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "+", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976620452370796`*^9, 3.497662356878827*^9, {
   3.497662464394216*^9, 3.497662468965024*^9}, 3.497662899853381*^9, 
   3.497662998897955*^9, {3.4976631971431026`*^9, 3.4976631991087065`*^9}, 
   3.499019090185754*^9, 3.499020395177581*^9, {3.499020469447685*^9, 
   3.499020476127694*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976622401126223`*^9, 3.4979216299710093`*^9, 
   3.499114132731891*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497662072225127*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"Cosh", "[", "z", "]"}]}], "=", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"Cosh", "[", 
      FractionBox["z", "2"], "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4979216146361823`*^9, 3.4979216448534355`*^9}, {
   3.4979279638121567`*^9, 3.497927983762184*^9}, {3.4979281528008766`*^9, 
   3.4979281663573003`*^9}, {3.499114132751891*^9, 3.499114132751891*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "-", "b"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "<", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.4976627174890604`*^9, 3.4976627219194684`*^9}, {3.4979281972297544`*^9, 
   3.4979281999909596`*^9}, {3.4979283710608597`*^9, 3.497928375538068*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", " ", "a"}], ")"}], "n"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Cosh", "[", 
       RowBox[{
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}], 
      RowBox[{"2", " ", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.497662217242982*^9, 3.497662244168629*^9}, {
   3.4979216146361823`*^9, 3.4979216448534355`*^9}, 3.4979280562211075`*^9, 
   3.497928234825821*^9, {3.499114132751891*^9, 3.499114132751891*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "*", "a"}], ")"}], "^", "n"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{
           RowBox[{"c", "/", "2"}], "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "-", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976620538794947`*^9, {
   3.4979216146361823`*^9, 3.4979216448534355`*^9}, 3.497927925752103*^9, 
   3.497928134611245*^9, {3.499114132751891*^9, 3.4991141327618914`*^9}, 
   3.4991147765127926`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497662072225127*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"Cosh", "[", "z", "]"}]}], "=", 
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      FractionBox["z", "2"], "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4979216146361823`*^9, 3.4979216448534355`*^9}, {
   3.4979279638121567`*^9, 3.497927983762184*^9}, {3.4979281528008766`*^9, 
   3.4979281663573003`*^9}, {3.4979283066171465`*^9, 
   3.4979283096903524`*^9}, {3.4991141171318693`*^9, 
   3.4991141327618914`*^9}, {3.4991148195128527`*^9, 3.4991148195128527`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", "b"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "<", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.4976627174890604`*^9, 3.4976627219194684`*^9}, {3.4979281972297544`*^9, 
   3.4979281999909596`*^9}, 3.4979282874291134`*^9, {3.497928355351632*^9, 
   3.4979283602812414`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "a"}], ")"}], "n"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}], 
      RowBox[{"2", " ", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.497662217242982*^9, 3.497662244168629*^9}, {
   3.4979216146361823`*^9, 3.4979216448534355`*^9}, 3.4979280562211075`*^9, 
   3.497928234825821*^9, 3.4979283422632093`*^9, {3.4991141171418695`*^9, 
   3.4991141327618914`*^9}, 3.4991148275128636`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "*", "a"}], ")"}], "^", "n"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"Sinh", "[", 
          RowBox[{
           RowBox[{"c", "/", "2"}], "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976620538794947`*^9, {
   3.4979216146361823`*^9, 3.4979216448534355`*^9}, 3.497927925752103*^9, 
   3.497928134611245*^9, 3.4979282680382795`*^9, {3.4991141171418695`*^9, 
   3.4991141327618914`*^9}, 3.4991148139928446`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497662072225127*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"Cosh", "[", "z", "]"}]}], "=", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"Cosh", "[", 
      FractionBox["z", "2"], "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4979216146361823`*^9, 3.4979216448534355`*^9}, {
   3.4979279638121567`*^9, 3.497927983762184*^9}, {3.4979281528008766`*^9, 
   3.4979281663573003`*^9}, {3.499114132791891*^9, 3.499114132791891*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"a", " ", 
        RowBox[{"Cosh", "[", "z", "]"}]}]}]], 
     RowBox[{"Cosh", "[", 
      FractionBox["z", "2"], "]"}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4979216146361823`*^9, 3.4979216448534355`*^9}, {
   3.4979279638121567`*^9, 3.497927983762184*^9}, {3.4979281528008766`*^9, 
   3.4979281663573003`*^9}, 3.4979286748245935`*^9, {3.4991141328018913`*^9, 
   3.4991141328018913`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "-", "b"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"n", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.4976627174890604`*^9, 3.4976627219194684`*^9}, {3.4979281972297544`*^9, 
   3.4979281999909596`*^9}, {3.4979283710608597`*^9, 3.497928375538068*^9}, {
   3.497928704776646*^9, 3.4979287078810515`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"2", " ", "a"}], ")"}], 
        RowBox[{"n", "-", 
         FractionBox["1", "2"]}]], " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cosh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
      RowBox[{"Cosh", "[", 
       RowBox[{
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Cosh", "[", 
       RowBox[{
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}], 
      RowBox[{"2", " ", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.497662217242982*^9, 3.497662244168629*^9}, {
   3.4979216146361823`*^9, 3.4979216448534355`*^9}, 3.4979280562211075`*^9, 
   3.497928234825821*^9, 3.497928825302458*^9, {3.4991141328018913`*^9, 
   3.4991141328118916`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "*", "a"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
       RowBox[{"Cosh", "[", 
        RowBox[{
         RowBox[{"c", "/", "2"}], "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "/", "2"}]}]}], "]"}]}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{
           RowBox[{"c", "/", "2"}], "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "-", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976620538794947`*^9, {
   3.4979216146361823`*^9, 3.4979216448534355`*^9}, 3.497927925752103*^9, 
   3.497928134611245*^9, 3.497928643749339*^9, 3.4982416290347366`*^9, {
   3.4991141328118916`*^9, 3.4991141328118916`*^9}, 3.499115072593207*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497662072225127*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"Cosh", "[", "z", "]"}]}], "=", 
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      FractionBox["z", "2"], "]"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4979216146361823`*^9, 3.4979216448534355`*^9}, {
   3.4979279638121567`*^9, 3.497927983762184*^9}, {3.4979281528008766`*^9, 
   3.4979281663573003`*^9}, 3.4979288984821863`*^9, {3.4991141171418695`*^9, 
   3.4991141328218913`*^9}, {3.49911510333325*^9, 3.49911510333325*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "-", 
       RowBox[{"a", " ", 
        RowBox[{"Cosh", "[", "z", "]"}]}]}]], 
     RowBox[{"Sinh", "[", 
      FractionBox["z", "2"], "]"}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4979216146361823`*^9, 3.4979216448534355`*^9}, {
   3.4979279638121567`*^9, 3.497927983762184*^9}, {3.4979281528008766`*^9, 
   3.4979281663573003`*^9}, 3.4979286748245935`*^9, 3.4979289148466153`*^9, {
   3.4991141171518693`*^9, 3.4991141328218913`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", "b"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"n", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.4976627174890604`*^9, 3.4976627219194684`*^9}, {3.4979281972297544`*^9, 
   3.4979281999909596`*^9}, {3.4979283710608597`*^9, 3.497928375538068*^9}, {
   3.497928704776646*^9, 3.4979287078810515`*^9}, {3.4979289196514235`*^9, 
   3.4979289199478245`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], " ", "a"}], ")"}], 
        RowBox[{"n", "-", 
         FractionBox["1", "2"]}]], " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cosh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
      RowBox[{"Sinh", "[", 
       RowBox[{
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}], 
      RowBox[{"2", " ", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.497662217242982*^9, 3.497662244168629*^9}, {
   3.4979216146361823`*^9, 3.4979216448534355`*^9}, 3.4979280562211075`*^9, 
   3.497928234825821*^9, 3.497928825302458*^9, 3.4979289563270884`*^9, {
   3.4991141171518693`*^9, 3.4991141328218913`*^9}, 3.499115107523256*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "*", "a"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Cosh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
       RowBox[{"Sinh", "[", 
        RowBox[{
         RowBox[{"c", "/", "2"}], "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "/", "2"}]}]}], "]"}]}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"Sinh", "[", 
          RowBox[{
           RowBox[{"c", "/", "2"}], "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "n"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976620538794947`*^9, {
   3.4979216146361823`*^9, 3.4979216448534355`*^9}, 3.497927925752103*^9, 
   3.497928134611245*^9, 3.497928643749339*^9, 3.497928879652953*^9, 
   3.498241633184742*^9, {3.499114117161869*^9, 3.499114132831891*^9}, 
   3.499115141573303*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497662620893691*^9, 3.497662652733347*^9}, 
   3.497662905609791*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], ")"}], "2"]], "=", 
   RowBox[{
    FractionBox["a", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}]}]], "-", 
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"a", " ", "z"}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "z"}]}], ")"}], "2"]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.4976625130975018`*^9, {3.497662579023217*^9, 3.4976625841556263`*^9}, {
   3.497662923331422*^9, 3.497662936139045*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.49766243823297*^9, 3.4976624525849953`*^9}, {3.4976629473554645`*^9, 
   3.49766295624748*^9}, {3.4982416592347784`*^9, 3.4982416592347784`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["x", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["a", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["x", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["b", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          RowBox[{"Cosh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cosh", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "2"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, {
   3.4976623833052735`*^9, 3.4976624037569094`*^9}, {3.497663070736081*^9, 
   3.4976631028721375`*^9}, {3.4979216300022097`*^9, 
   3.4979216300022097`*^9}, {3.499114132831891*^9, 3.499114132831891*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"a", "*", 
             RowBox[{"Cosh", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"Cosh", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "2"}]}]}], 
        ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976620452370796`*^9, 3.497662356878827*^9, {
   3.497662464394216*^9, 3.497662468965024*^9}, 3.497662899853381*^9, {
   3.4979216300022097`*^9, 3.4979216300022097`*^9}, 3.4979289906939487`*^9, {
   3.4991141328418913`*^9, 3.4991141328418913`*^9}, 3.499115193883377*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, {3.497662620893691*^9, 3.497662652733347*^9}, 
   3.497662905609791*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     RowBox[{"Cosh", "[", "z", "]"}]}]}], "=", 
   FractionBox[
    RowBox[{"b", "+", 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["\[ExponentialE]", "z"]}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "z"}]]}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", "z"]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.4976625130975018`*^9, {3.497662579023217*^9, 3.4976625841556263`*^9}, {
   3.497662923331422*^9, 3.497662936139045*^9}, 3.497663013827181*^9, {
   3.49792163001781*^9, 3.49792163001781*^9}, {3.4979291056193504`*^9, 
   3.4979291056193504`*^9}, {3.4991141328518915`*^9, 
   3.4991141328518915`*^9}, {3.499115234873434*^9, 3.499115234873434*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497662273761881*^9, 3.497662314743153*^9}, {
   3.49766243823297*^9, 3.4976624525849953`*^9}, {3.4976629473554645`*^9, 
   3.49766295624748*^9}, {3.497663154773429*^9, 3.497663222165547*^9}, {
   3.4979292038059225`*^9, 3.4979292475639997`*^9}, {3.4982416701947937`*^9, 
   3.4982416701947937`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["2", "n"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"2", " ", "a", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}]]}], "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], ")"}]}]]}]}], ")"}], "n"]}], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"n", " ", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, {
   3.4976623833052735`*^9, 3.4976624037569094`*^9}, 3.4976631413262053`*^9, 
   3.49792163001781*^9, 3.4979291310317945`*^9, 3.4991141328518915`*^9, 
   3.499115329633567*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"2", "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"2", "*", "a", "*", 
             RowBox[{"E", "^", 
              RowBox[{"(", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], ")"}]}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"E", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", 
                RowBox[{"(", 
                 RowBox[{"c", "+", 
                  RowBox[{"d", "*", "x"}]}], ")"}]}], ")"}]}]}]}], ")"}], "^",
           "n"}], "/", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{"n", "*", 
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}]}], ")"}]}]}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976620452370796`*^9, 3.497662356878827*^9, {
   3.497662464394216*^9, 3.497662468965024*^9}, 3.497662899853381*^9, 
   3.497662998897955*^9, {3.4976631971431026`*^9, 3.4976631991087065`*^9}, 
   3.49792163001781*^9, 3.4979290679920845`*^9, {3.497929153324234*^9, 
   3.497929156023039*^9}, 3.4991141328518915`*^9, 3.499115283393502*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sinh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978201697549086`*^9, 3.4978201707449093`*^9}, 
   3.4980702555322742`*^9, 3.498070723969897*^9, 3.4980719389556313`*^9, 
   3.4980726319200497`*^9, {3.4988884107361507`*^9, 3.498888431017311*^9}, 
   3.4988895614289665`*^9, 3.499019090185754*^9, 3.5157124055082197`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.497676524239994*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sinh", "[", "z", "]"}], "2"], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"Cosh", "[", 
       RowBox[{"2", " ", "z"}], "]"}]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, 3.497676213204204*^9, {3.499019090205754*^9, 
   3.499019090205754*^9}, {3.499019132735813*^9, 3.499019132735813*^9}, {
   3.499020801198149*^9, 3.4990208058281555`*^9}}],

Cell["\<\
Note: This rule should be replaced with rules that directly reduce the \
integrand rather than transforming it using hyperbolic power expansion!\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.497676524239994*^9, {
   3.5157017406219645`*^9, 3.515702053622402*^9}, {3.51571254759807*^9, 
   3.515712549080073*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", "-", "b"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotEqual]", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976762514733925`*^9, 3.497676285304328*^9}, {
   3.4976766874213276`*^9, 3.497676700561079*^9}, {3.498889824763029*^9, 
   3.4988898331305075`*^9}, {3.4990208312681913`*^9, 
   3.4990208312681913`*^9}, {3.5157124402542815`*^9, 3.5157124421262846`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sinh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["2", "n"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "-", "b", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{
           RowBox[{"2", " ", "c"}], "+", 
           RowBox[{"2", " ", "d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.4976765781900797`*^9, 3.4976765810842457`*^9}, {
   3.497676622091591*^9, 3.497676634969328*^9}, 3.499019090205754*^9, 
   3.499019132735813*^9, {3.49902088783827*^9, 3.4990208936882787`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"Sinh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "^", 
     "n_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"2", "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "a"}], "-", "b", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Cosh", "[", 
            RowBox[{
             RowBox[{"2", "*", "c"}], "+", 
             RowBox[{"2", "*", "d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
        "n"}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"a", "-", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497676050505898*^9, 
   3.4976765187576804`*^9, {3.497676670817378*^9, 3.4976766725164747`*^9}, {
   3.498241733094882*^9, 3.4982417375148883`*^9}, {3.4988898120363007`*^9, 
   3.4988898148264604`*^9}, 3.4990190902157536`*^9, 3.499019132735813*^9, 
   3.4990208334681945`*^9, 3.4990208742282515`*^9, 3.5157124661191273`*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Cosh", "[", "z", "]"}], "2"], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Cosh", "[", 
       RowBox[{"2", " ", "z"}], "]"}]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, 3.497676213204204*^9, {3.4979216146673827`*^9, 
   3.4979216448690357`*^9}, {3.4979823683710165`*^9, 
   3.4979823683710165`*^9}, {3.499114132871891*^9, 3.499114132871891*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "^", 
     "n_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"2", "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "a"}], "+", "b", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Cosh", "[", 
            RowBox[{
             RowBox[{"2", "*", "c"}], "+", 
             RowBox[{"2", "*", "d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
        "n"}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "\[NotEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497676050505898*^9, 
   3.4976765187576804`*^9, {3.497676670817378*^9, 3.4976766725164747`*^9}, {
   3.4979216146829824`*^9, 3.4979216448690357`*^9}, 3.4979823318357525`*^9, {
   3.497982405249481*^9, 3.4979824071682844`*^9}, {3.4982417232448683`*^9, 
   3.4982417291148767`*^9}, {3.4991141328818913`*^9, 3.4991141328818913`*^9}, 
   3.499115507563816*^9, 3.51571246774153*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497676151127653*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sinh", "[", "z", "]"}], "2"], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"Cosh", "[", 
       RowBox[{"2", " ", "z"}], "]"}]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, 3.497676213204204*^9, {3.4990190902157536`*^9, 
   3.4990190902157536`*^9}, {3.499019132735813*^9, 3.499019132735813*^9}, {
   3.499021034408476*^9, 3.499021037008479*^9}}],

Cell["\<\
Note: This rule should be replaced with rules that directly reduce the \
integrand rather than transforming it using hyperbolic power expansion!\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.497676524239994*^9, {
   3.5157017406219645`*^9, 3.515702053622402*^9}, {3.51571254759807*^9, 
   3.515712549080073*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "-", "b"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", "m"}],
    ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976762514733925`*^9, 3.497676285304328*^9}, {
   3.4990210881785507`*^9, 3.4990210881785507`*^9}, {3.515609831977188*^9, 
   3.5156098425172033`*^9}, {3.515712734143198*^9, 3.5157127343927984`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sinh", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["2", "n"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "-", "b", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cosh", "[", 
          RowBox[{
           RowBox[{"2", " ", "c"}], "+", 
           RowBox[{"2", " ", "d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.4976765781900797`*^9, 3.4976765810842457`*^9}, {
   3.497676622091591*^9, 3.497676634969328*^9}, 3.499019090205754*^9, 
   3.499019132735813*^9, {3.49902088783827*^9, 3.4990208936882787`*^9}, {
   3.5157125313584414`*^9, 3.5157125327780437`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"2", "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "a"}], "-", "b", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{
              RowBox[{"2", "*", "c"}], "+", 
              RowBox[{"2", "*", "d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         "n"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"a", "-", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"m", ">", "0"}], " ", "&&", " ", 
       RowBox[{"n", "\[Equal]", 
        RowBox[{"-", "1"}]}]}], " ", "||", " ", 
      RowBox[{
       RowBox[{"m", "\[Equal]", "1"}], " ", "&&", " ", 
       RowBox[{"n", "\[Equal]", 
        RowBox[{"-", "2"}]}]}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976760612205105`*^9, 
   3.499019090225754*^9, 3.4990191327458134`*^9, 3.4990210251184626`*^9, {
   3.515609802557147*^9, 3.51560980444715*^9}, {3.515712589842944*^9, 
   3.515712635083024*^9}, 3.5171888894143314`*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Cosh", "[", "z", "]"}], "2"], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Cosh", "[", 
       RowBox[{"2", " ", "z"}], "]"}]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, 3.497676213204204*^9, {3.4979216146673827`*^9, 
   3.4979216448690357`*^9}, {3.4979823501345844`*^9, 
   3.4979823501345844`*^9}, {3.4991141328918915`*^9, 3.4991141328918915`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"2", "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "a"}], "+", "b", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cosh", "[", 
             RowBox[{
              RowBox[{"2", "*", "c"}], "+", 
              RowBox[{"2", "*", "d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
         "n"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"m", ">", "0"}], " ", "&&", " ", 
       RowBox[{"n", "\[Equal]", 
        RowBox[{"-", "1"}]}]}], " ", "||", " ", 
      RowBox[{
       RowBox[{"m", "\[Equal]", "1"}], " ", "&&", " ", 
       RowBox[{"n", "\[Equal]", 
        RowBox[{"-", "2"}]}]}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976760612205105`*^9, {
   3.4979216146673827`*^9, 3.4979216448690357`*^9}, 3.497982323006137*^9, {
   3.497982386981849*^9, 3.497982393877061*^9}, {3.499114132901891*^9, 
   3.499114132901891*^9}, {3.4991159866744866`*^9, 3.499116011734522*^9}, 
   3.5157125926509495`*^9, {3.5157126450046415`*^9, 3.515712664301875*^9}, 
   3.5171888894143314`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sinh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.499019090225754*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["FresnelS", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    RowBox[{"Sinh", "[", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "\[Pi]", " ", 
       SuperscriptBox["z", "2"]}], "2"], "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.499019090235754*^9, 3.499019090235754*^9}, {
   3.4990212470387735`*^9, 3.4990212470387735`*^9}, {3.4990357949257126`*^9, 
   3.4990357949257126`*^9}}],

Cell[TextData[{
 "Note: This rule is commented out since it introduces the imaginary unit ",
 Cell[BoxData["\[ImaginaryI]"]],
 "; whereas, converting the hyperbolic sine to exponential form does not."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.499035876607456*^9, 
   3.4990359441399746`*^9}, {3.4990359832180433`*^9, 
   3.4990359995668716`*^9}, {3.499036039955343*^9, 3.4990360886742287`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sinh", "[", 
    RowBox[{"b", " ", 
     SuperscriptBox["x", "2"]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox[
         FractionBox["\[Pi]", "2"]]}], 
       SqrtBox[
        RowBox[{"\[ImaginaryI]", " ", "b"}]]]}]}]}], 
   RowBox[{"FresnelS", "[", 
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{"\[ImaginaryI]", " ", "b"}]], " ", "x"}], 
     SqrtBox[
      FractionBox["\[Pi]", "2"]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.499019090235754*^9, 3.4990356612178774`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "2"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
    "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "I"}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Pi", "/", "2"}], "]"}], "*", 
     RowBox[{
      RowBox[{"FresnelS", "[", 
       RowBox[{
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{"I", "*", "b"}], ",", "2"}], "]"}], "*", 
        RowBox[{"x", "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"Pi", "/", "2"}], "]"}]}]}], "]"}], "/", 
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{"I", "*", "b"}], ",", "2"}], "]"}]}]}], " ", "/;", "\n", 
    RowBox[{"FreeQ", "[", 
     RowBox[{"b", ",", "x"}], "]"}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.499019090235754*^9, 3.499035517916026*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["FresnelC", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}], "=", 
   RowBox[{"Cosh", "[", 
    FractionBox[
     RowBox[{"I", " ", "\[Pi]", " ", 
      SuperscriptBox["z", "2"]}], "2"], "]"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.4979216300646095`*^9, 3.4979216300646095`*^9}, {
   3.497982539565717*^9, 3.4979825416093206`*^9}, {3.499114132911891*^9, 
   3.499114132911891*^9}, {3.499116690835472*^9, 3.499116691375473*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "2"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
    "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"Pi", "/", "2"}], "]"}], "*", 
     RowBox[{
      RowBox[{"FresnelC", "[", 
       RowBox[{
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{"I", "*", "b"}], ",", "2"}], "]"}], "*", 
        RowBox[{"x", "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"Pi", "/", "2"}], "]"}]}]}], "]"}], "/", 
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{"I", "*", "b"}], ",", "2"}], "]"}]}]}], " ", "/;", "\n", 
    RowBox[{"FreeQ", "[", 
     RowBox[{"b", ",", "x"}], "]"}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.4979216300646095`*^9, 3.497982495152439*^9, 3.499114132921891*^9, 
   3.499116559715289*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sinh", "[", "z", "]"}], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox["\[ExponentialE]", "z"], "2"], "-", 
    FractionBox[
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "z"}]], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9, 3.497810195205735*^9, {
   3.4990190902557535`*^9, 3.4990190902557535`*^9}, {3.49903643118843*^9, 
   3.49903643118843*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[Or]", 
     " ", 
     RowBox[{"n", "<", "0"}]}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "a"}], "-", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}, 
   3.4990190902657537`*^9, {3.499036450454464*^9, 3.4990364530596685`*^9}, {
   3.4990364913265357`*^9, 3.499036501123353*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sinh", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "n_"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"Not", "[", 
     RowBox[{"FractionOrNegativeQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.4990190902657537`*^9, 3.499036409675992*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Cosh", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "n_"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"Not", "[", 
     RowBox[{"FractionOrNegativeQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.49792163009581*^9, 3.4979825117976685`*^9, 3.499114132941891*^9, 
   3.499116339904981*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9}],

Cell["\<\
Note: Although resulting integrand looks more complicated than the original, \
rules for improper binomials rectify it.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9, 3.497810195205735*^9, {
   3.497810459466105*^9, 3.497810511846178*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", " ", 
   RowBox[{"n", "<", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}, {3.4978105556962395`*^9, 
   3.4978105670162554`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}]}]}], "-", 
  RowBox[{"b", " ", "n", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "n"], " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}, 
   3.497810535736212*^9, {3.4990190902657537`*^9, 3.4990190902657537`*^9}, 
   3.499019132755813*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sinh", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "n_"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "n"}], "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, {3.4990190902657537`*^9, 3.499019090275754*^9}, 
   3.499019132755813*^9, 3.4990365574238515`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Cosh", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "n_"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "n"}], "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, {3.4979216146985826`*^9, 3.497921644884636*^9}, 
   3.4979825181780796`*^9, {3.4991141171918693`*^9, 3.499114132941891*^9}, 
   3.499116294924918*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"Sinh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.49781110611701*^9, 3.499019090275754*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["SinhIntegral", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}], "=", 
   FractionBox[
    RowBox[{"Sinh", "[", "z", "]"}], "z"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.497811178197111*^9, {3.499019090285754*^9, 
   3.499019090285754*^9}, {3.4990367454413824`*^9, 3.4990367454413824`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}], "]"}], "x"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"SinhIntegral", "[", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "]"}], "n"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, {3.497811202387145*^9, 3.497811226367179*^9}, {
   3.4978114144974422`*^9, 3.4978114162574444`*^9}, 3.499019090285754*^9, 
   3.499036728094152*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "n_."}]}], "]"}], "/", "x_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"SinhIntegral", "[", 
     RowBox[{"b", "*", 
      RowBox[{"x", "^", "n"}]}], "]"}], "/", "n"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497811159337085*^9, {3.4978114183274474`*^9, 3.4978114203574505`*^9}, 
   3.499019090285754*^9, 3.499036717969734*^9, {3.499117101896048*^9, 
   3.4991171065760546`*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["CoshIntegral", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}], "=", 
   FractionBox[
    RowBox[{"Cosh", "[", "z", "]"}], "z"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.497811178197111*^9, {3.4979216301114097`*^9, 
   3.4979216301114097`*^9}, {3.499114132961891*^9, 3.499114132961891*^9}, {
   3.4991170273759437`*^9, 3.4991170273759437`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"b_.", "*", 
       RowBox[{"x_", "^", "n_."}]}], "]"}], "/", "x_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"CoshIntegral", "[", 
     RowBox[{"b", "*", 
      RowBox[{"x", "^", "n"}]}], "]"}], "/", "n"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497811159337085*^9, {3.4978114183274474`*^9, 3.4978114203574505`*^9}, {
   3.4979216301270094`*^9, 3.4979216301270094`*^9}, 3.4979829847748995`*^9, {
   3.497983175906435*^9, 3.497983177825238*^9}, 3.499114132961891*^9, 
   3.4991170285559454`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sinh", "[", 
    RowBox[{"w", "+", "z"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", "w", "]"}], " ", 
     RowBox[{"Cosh", "[", "z", "]"}]}], "+", 
    RowBox[{
     RowBox[{"Cosh", "[", "w", "]"}], " ", 
     RowBox[{"Sinh", "[", "z", "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9, {3.499019090285754*^9, 
   3.499019090295754*^9}, {3.499019132765813*^9, 3.499019132765813*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"Sinh", "[", "a", "]"}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"Cosh", "[", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "]"}], "x"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   RowBox[{"Cosh", "[", "a", "]"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "]"}], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497811321977312*^9, {3.4978113726473837`*^9, 
   3.4978113760773883`*^9}, {3.499019090295754*^9, 3.499019090295754*^9}, {
   3.499019132765813*^9, 3.499019132765813*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}], "/", "x_"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"Sinh", "[", "a", "]"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}], "/", "x"}], ",", "x"}], "]"}]}], 
     "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"Cosh", "[", "a", "]"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sinh", "[", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}], "/", "x"}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978111332070484`*^9, 
   3.4978112789772525`*^9, {3.499019090295754*^9, 3.4990190903057537`*^9}, {
   3.499019132765813*^9, 3.499019132765813*^9}, 3.4990368227239184`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}], "/", "x_"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"Cosh", "[", "a", "]"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}], "/", "x"}], ",", "x"}], "]"}]}], 
     "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"Sinh", "[", "a", "]"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sinh", "[", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}], "/", "x"}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978111332070484`*^9, 
   3.4978112789772525`*^9, {3.4979216146985826`*^9, 3.4979216449002357`*^9}, 
   3.497982995180117*^9, {3.499114117201869*^9, 3.4991141329818916`*^9}, {
   3.499117200566186*^9, 3.499117214836206*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 392h, A&S 4.5.83", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497811532897608*^9, 3.4990368593371825`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}]}], "=", 
   FractionBox[
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "n", "+", "1"}]], " ", 
     RowBox[{
      SubscriptBox["\[PartialD]", "x"], 
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}]}]}], 
    RowBox[{"b", " ", "n"}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9, 3.497810195205735*^9, 
   3.497811560037646*^9, 3.497811810187996*^9, {3.4990190903057537`*^9, 
   3.4990190903057537`*^9}, {3.499019132775813*^9, 3.499019132775813*^9}, {
   3.4990368746876097`*^9, 3.4990368746876097`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}, {3.4978119614426117`*^9, 
   3.4978119879026484`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "n", "+", "1"}]], " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], "]"}]}], 
       RowBox[{"b", " ", "n"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "n", "+", "1"}], 
    RowBox[{"b", " ", "n"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "n"}]], " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}, {
   3.4978114755275273`*^9, 3.4978114885575457`*^9}, 3.4990190903057537`*^9, {
   3.499019132775813*^9, 3.499019132775813*^9}, 3.4990368811304207`*^9, {
   3.499036964762168*^9, 3.499036965074168*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<=", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497811129647043*^9, 3.497811455437499*^9, 3.499019090315754*^9, {
   3.499019132775813*^9, 3.499019132775813*^9}, 3.4990369184612865`*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: CRC 396h, A&S 4.5.84", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497811532897608*^9, 3.4979832743894076`*^9, 3.4991172602562695`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<=", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497811129647043*^9, 3.497811455437499*^9, {3.497921614714183*^9, 
   3.4979216449158354`*^9}, 3.49798300226253*^9, {3.4991141172118692`*^9, 
   3.4991141329818916`*^9}, 3.499117234156233*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 405h", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.4990370274898777`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9, 3.497810195205735*^9, {
   3.497810459466105*^9, 3.497810511846178*^9}, 3.4978120506627364`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "+", "n", "+", "1"}], "=", 
   RowBox[{"0", " ", "\[Or]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
      " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
          RowBox[{"m", "<", 
           RowBox[{"-", "1"}]}]}], ")"}], " ", "\[Or]", " ", 
        RowBox[{"0", "<", 
         RowBox[{"-", "n"}], "<", 
         RowBox[{"m", "+", "1"}]}]}], ")"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}, {3.4978105556962395`*^9, 
   3.4978105670162554`*^9}, {3.4978121595028887`*^9, 
   3.4978121713129053`*^9}, {3.497812202812949*^9, 3.497812241873004*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], "]"}]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n"}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "n"}]], " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}, 
   3.497810535736212*^9, {3.497812078252775*^9, 3.497812093972797*^9}, {
   3.499019090315754*^9, 3.499019090315754*^9}, 3.4990191327858133`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"m", "+", "n", "+", "1"}], "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
       RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"n", ">", "0"}], " ", "&&", " ", 
          RowBox[{"m", "<", 
           RowBox[{"-", "1"}]}]}], " ", "||", " ", 
         RowBox[{"0", "<", 
          RowBox[{"-", "n"}], "<", 
          RowBox[{"m", "+", "1"}]}]}], ")"}]}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, {
   3.499019090315754*^9, 3.499019090315754*^9}, 3.4990191327858133`*^9, 
   3.4990370101114473`*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: CRC 406h", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.497983283827424*^9, 
   3.499117332896371*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{"n", "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"m", "+", "n", "+", "1"}], "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
       RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"n", ">", "0"}], " ", "&&", " ", 
          RowBox[{"m", "<", 
           RowBox[{"-", "1"}]}]}], " ", "||", " ", 
         RowBox[{"0", "<", 
          RowBox[{"-", "n"}], "<", 
          RowBox[{"m", "+", "1"}]}]}], ")"}]}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, {
   3.497921614714183*^9, 3.4979216449158354`*^9}, 3.497983126719548*^9, {
   3.4991141172218695`*^9, 3.4991141329918914`*^9}, 3.4991173219263563`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.497812291653074*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sinh", "[", "z", "]"}], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox["\[ExponentialE]", "z"], "2"], "-", 
    FractionBox[
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "z"}]], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9, 3.497810195205735*^9, 
   3.497811560037646*^9, 3.497811810187996*^9, 3.4978123204031143`*^9, {
   3.499019090325754*^9, 3.499019090325754*^9}, {3.499037121916844*^9, 
   3.499037121916844*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "-", "n", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", 
   " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[Or]", 
      " ", 
      RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[Or]", 
      " ", 
      RowBox[{"n", "<", "0"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}, {3.4978105556962395`*^9, 
   3.4978105670162554`*^9}, {3.4978121595028887`*^9, 
   3.4978121713129053`*^9}, {3.497812202812949*^9, 3.497812241873004*^9}, {
   3.4978123720231867`*^9, 3.4978124858333454`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "a"}], "-", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}, 
   3.497810535736212*^9, {3.497812078252775*^9, 3.497812093972797*^9}, 
   3.4978123593031683`*^9, 3.499019090325754*^9, 3.499037205876191*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "-", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}], " ", "&&", "\n", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"FractionQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"FractionOrNegativeQ", "[", "n", "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, 
   3.4978123314331293`*^9, 3.4978449628776217`*^9, 3.499019090325754*^9, 
   3.499037163116516*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "a"}], "-", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}], " ", "&&", " ", "\n", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"FractionQ", "[", "m", "]"}], " ", "||", " ", 
      RowBox[{"FractionOrNegativeQ", "[", "n", "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, 
   3.4978123314331293`*^9, 3.4978449628776217`*^9, 3.49792163015821*^9, 
   3.497983137748768*^9, 3.497983659538484*^9, 3.499114133001891*^9, 
   3.499117422326496*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.49781110611701*^9, 3.497812987564048*^9, 3.499019090335754*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4978130316141095`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "-", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4978130900441914`*^9, 3.4978131572642856`*^9}, {
   3.497813348754554*^9, 3.49781336751458*^9}, {3.497814099895605*^9, 
   3.497814106035614*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
     SuperscriptBox["x", "n"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}], 
         SuperscriptBox["x", 
          RowBox[{"n", "-", "1"}]]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n", " ", "p"}], 
    RowBox[{"n", "-", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], 
      RowBox[{"p", "-", "1"}]], " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, {3.497811202387145*^9, 3.497811226367179*^9}, {
   3.4978114144974422`*^9, 3.4978114162574444`*^9}, {3.497813065384157*^9, 
   3.4978130749041705`*^9}, {3.4978133280245247`*^9, 
   3.4978133437345467`*^9}, {3.497813396744621*^9, 3.4978134492246943`*^9}, {
   3.499019090335754*^9, 3.4990190903457537`*^9}, 3.4990191327858133`*^9, 
   3.4990373921093187`*^9, 3.499121644308999*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}]}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "*", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}], "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497811159337085*^9, {3.4978114183274474`*^9, 3.4978114203574505`*^9}, 
   3.4978130235240984`*^9, {3.4978134985547633`*^9, 3.497813609294918*^9}, {
   3.4990190903457537`*^9, 3.4990190903457537`*^9}, 3.4990191327858133`*^9, 
   3.4990373494744434`*^9, {3.4990380408632584`*^9, 3.4990380430784616`*^9}, {
   3.499121511718813*^9, 3.4991215470088625`*^9}, 3.499121682419052*^9, 
   3.5171889289604006`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}]}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "*", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"p", "/", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}], "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497811159337085*^9, {3.4978114183274474`*^9, 3.4978114203574505`*^9}, 
   3.4978130235240984`*^9, {3.4978134985547633`*^9, 3.497813609294918*^9}, {
   3.497921614729783*^9, 3.4979216449314356`*^9}, 3.497984037433548*^9, {
   3.4991141172218695`*^9, 3.4991141330218916`*^9}, 3.4991214402387133`*^9, 
   3.5171889289604006`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: ",
 "G&R 2.471.1b'",
 " special case when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "-", 
    RowBox[{"2", "n"}], "+", "1"}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, {
   3.497813680335018*^9, 3.497813696825041*^9}, 3.497814297695882*^9, {
   3.4978143293659267`*^9, 3.4978143308159285`*^9}, 3.498239516771779*^9, 
   3.4990377466199408`*^9, {3.499038574606995*^9, 3.4990385806130056`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"p", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{"m", "-", 
     RowBox[{"2", "n"}], "+", "1"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4978130900441914`*^9, 3.4978131572642856`*^9}, {
   3.497813348754554*^9, 3.49781336751458*^9}, {3.4978140642655554`*^9, 
   3.4978140956655993`*^9}, {3.4978144116260414`*^9, 
   3.4978144242060595`*^9}, {3.499038591330225*^9, 3.499038591330225*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"n", " ", 
         SuperscriptBox[
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", "n"]}]}], "]"}], "p"]}], 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["n", "2"], " ", 
         SuperscriptBox["p", "2"]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", "n"], " ", 
    RowBox[{"Cosh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"p", "-", "1"}]]}], 
   RowBox[{"b", " ", "n", " ", "p"}]], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"p", "-", "1"}], "p"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], 
      RowBox[{"p", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497811321977312*^9, {3.4978113726473837`*^9, 
   3.4978113760773883`*^9}, 3.497813732595091*^9, {3.4978138007251863`*^9, 
   3.4978138363652363`*^9}, {3.4978143913860135`*^9, 
   3.4978144039060307`*^9}, {3.499019090355754*^9, 3.499019090355754*^9}, 
   3.4990191327958136`*^9, {3.499037762719169*^9, 3.499037785417209*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "n"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"p", "^", "2"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{
     RowBox[{"x", "^", "n"}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", "p"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "/", "p"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"2", "*", "n"}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978111332070484`*^9, 
   3.4978112789772525`*^9, 3.497812999004064*^9, 3.4978136658049974`*^9, {
   3.4978138617452717`*^9, 3.4978138643252754`*^9}, {3.499019090355754*^9, 
   3.499019090365754*^9}, 3.4990191327958136`*^9, 3.499037707994273*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.471.1a' special case with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "-", 
    RowBox[{"2", "n"}], "+", "1"}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, {
   3.497813680335018*^9, 3.497813696825041*^9}, 3.497814297695882*^9, {
   3.4978143293659267`*^9, 3.4978143308159285`*^9}, {3.4979841931998215`*^9, 
   3.4979841936366224`*^9}, {3.4990389647480803`*^9, 
   3.4990389647480803`*^9}, {3.4991218005292177`*^9, 3.499121822309248*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "n"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"p", "^", "2"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{
     RowBox[{"x", "^", "n"}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", "p"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "/", "p"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"2", "*", "n"}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978111332070484`*^9, 
   3.4978112789772525`*^9, 3.497812999004064*^9, 3.4978136658049974`*^9, {
   3.4978138617452717`*^9, 3.4978138643252754`*^9}, {3.497921614745383*^9, 
   3.497921644947036*^9}, 3.497984114263683*^9, {3.4991141172318697`*^9, 
   3.499114133031892*^9}, 3.4991217871991987`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.471.1b'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497811532897608*^9, 3.49781393901538*^9, 3.499037948979097*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "n"}], "<", 
     RowBox[{"m", "+", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}, {3.4978119614426117`*^9, 
   3.4978119879026484`*^9}, {3.4978142081057568`*^9, 
   3.4978142300257874`*^9}, {3.4978148508166566`*^9, 3.49781485307666*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "-", "n", "+", "1"}], ")"}], " ", 
         SuperscriptBox["x", 
          RowBox[{"m", "-", 
           RowBox[{"2", " ", "n"}], "+", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", "n"]}]}], "]"}], "p"]}], 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["n", "2"], " ", 
         SuperscriptBox["p", "2"]}]]}]}]}]}]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"m", "-", "n", "+", "1"}]], " ", 
    RowBox[{"Cosh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"p", "-", "1"}]]}], 
   RowBox[{"b", " ", "n", " ", "p"}]], "-", "     ", "\[IndentingNewLine]", 
  "                                           ", 
  RowBox[{
   FractionBox[
    RowBox[{"p", "-", "1"}], "p"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], 
      RowBox[{"p", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "-", "n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", 
       RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}], 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     SuperscriptBox["p", "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", 
       RowBox[{"2", " ", "n"}]}]], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}, {
   3.4978114755275273`*^9, 3.4978114885575457`*^9}, {3.4978139885554495`*^9, 
   3.49781400341547*^9}, 3.4978141842457237`*^9, {3.4978450113076897`*^9, 
   3.497845040857731*^9}, {3.499019090365754*^9, 3.4990190903757544`*^9}, 
   3.4990191327958136`*^9, {3.499037971786337*^9, 3.4990379868403635`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", 
        RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"p", "^", "2"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", "p"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "/", "p"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", 
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{"p", "^", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "*", "n"}], "<", 
     RowBox[{"m", "+", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497811129647043*^9, 3.497811455437499*^9, 3.4978130018340683`*^9, 
   3.4978139290053663`*^9, {3.4990190903757544`*^9, 3.499019090385754*^9}, 
   3.4990191327958136`*^9, 3.4990379377314773`*^9, 3.5171888894143314`*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.631.3'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497811532897608*^9, 3.49781393901538*^9, {3.49798426068554*^9, 
   3.497984261184741*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", 
        RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"p", "^", "2"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", "p"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}], "/", "p"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", 
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{"p", "^", "2"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "*", "n"}], "<", 
     RowBox[{"m", "+", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497811129647043*^9, 3.497811455437499*^9, 3.4978130018340683`*^9, 
   3.4978139290053663`*^9, {3.4979216147765827`*^9, 3.497921644962636*^9}, 
   3.4979841249029016`*^9, {3.4991141172318697`*^9, 3.4991141330518913`*^9}, 
   3.499121869369314*^9, 3.517188889429931*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Reference: ",
 "G&R 2.477.1",
 " special case when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "-", 
    RowBox[{"2", "n"}], "+", "1"}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.497814519586193*^9, 
   3.4978151296270466`*^9, {3.4978151984471436`*^9, 3.497815198947144*^9}, {
   3.497815245177209*^9, 3.4978152639572353`*^9}, 3.498239518301781*^9, {
   3.4990381274434104`*^9, 3.4990381299550147`*^9}, {3.4990382211103745`*^9, 
   3.499038254993634*^9}, {3.4990386164774685`*^9, 3.4990386164774685`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "\[And]", " ", 
    RowBox[{"m", "-", 
     RowBox[{"2", "n"}], "+", "1"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}, {3.4978119614426117`*^9, 
   3.4978119879026484`*^9}, {3.4978142081057568`*^9, 
   3.4978142300257874`*^9}, {3.497814551106237*^9, 3.4978145682762613`*^9}, {
   3.4978146024663086`*^9, 3.4978146072663155`*^9}, {3.499038628021489*^9, 
   3.499038628021489*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                    ", "\[IndentingNewLine]", 
      "                           ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", "n"], " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], "]"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"b", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"n", " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"p", "+", "2"}]]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "2"}], ")"}]}]], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"p", "+", "2"}], 
    RowBox[{"p", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], 
      RowBox[{"p", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}, 
   3.497810535736212*^9, {3.497812078252775*^9, 3.497812093972797*^9}, 
   3.497814621316335*^9, 3.497814652296379*^9, {3.4978450924378033`*^9, 
   3.4978451139778337`*^9}, {3.499019090395754*^9, 3.499019090395754*^9}, 
   3.4990191327958136`*^9, 3.4990382950701046`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "n"}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{"n", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"2", "*", "n"}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, 
   3.497813004784072*^9, 3.4978145150861864`*^9, {3.499019090395754*^9, 
   3.499019090405754*^9}, 3.4990191328058133`*^9, {3.4990382725124645`*^9, 
   3.499038277426473*^9}},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Reference: G&R 2.",
 "477.2",
 "' special case with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "-", 
    RowBox[{"2", "n"}], "+", "1"}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.497814519586193*^9, 
   3.4978151296270466`*^9, {3.4978151984471436`*^9, 3.497815198947144*^9}, {
   3.497815245177209*^9, 3.4978152639572353`*^9}, {3.4979843469224916`*^9, 
   3.4979843472656918`*^9}, {3.4990389749348984`*^9, 3.4990389749348984`*^9}, 
   3.4991219039993625`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", "n"}]}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"n", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"2", "*", "n"}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, 
   3.497813004784072*^9, 3.4978145150861864`*^9, {3.497921614792183*^9, 
   3.4979216449782357`*^9}, 3.497984133248916*^9, {3.499038912690789*^9, 
   3.4990389136735907`*^9}, {3.4991141172418694`*^9, 3.499114133071892*^9}, 
   3.499121989149482*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.477.1", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.497814519586193*^9, 
   3.4978147490865145`*^9, 3.497815269747243*^9, 3.4990384014310913`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "\[And]", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "n"}], "<", 
     RowBox[{"m", "+", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}, {3.4978119614426117`*^9, 
   3.4978119879026484`*^9}, {3.4978142081057568`*^9, 
   3.4978142300257874`*^9}, {3.497814551106237*^9, 3.4978145682762613`*^9}, {
   3.4978146024663086`*^9, 3.4978146072663155`*^9}, {3.497814842496645*^9, 
   3.4978148883467093`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "n", "+", "1"}]], " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], "]"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"b", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"m", "-", "n", "+", "1"}], ")"}], " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "-", 
      RowBox[{"2", " ", "n"}], "+", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"p", "+", "2"}]]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "2"}], ")"}]}]], "-", "  ", "\[IndentingNewLine]", 
  "                                      ", 
  RowBox[{
   FractionBox[
    RowBox[{"p", "+", "2"}], 
    RowBox[{"p", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], 
      RowBox[{"p", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "-", "n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", 
       RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}], 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", 
       RowBox[{"2", " ", "n"}]}]], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], 
      RowBox[{"p", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}, 
   3.497810535736212*^9, {3.497812078252775*^9, 3.497812093972797*^9}, 
   3.497814621316335*^9, 3.497814652296379*^9, {3.4978148058565936`*^9, 
   3.4978148214266157`*^9}, {3.499019090405754*^9, 3.4990190904157543`*^9}, 
   3.4990191328058133`*^9, 3.4990383857062635`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "-", "n", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", 
        RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", 
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "*", "n"}], "<", 
     RowBox[{"m", "+", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, 
   3.497813004784072*^9, 3.4978145150861864`*^9, 3.497814742666505*^9, {
   3.4990190904157543`*^9, 3.499019090435754*^9}, 3.4990191328058133`*^9, {
   3.4990383529618063`*^9, 3.499038360403019*^9}, 3.517188889429931*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.477.2", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.497814519586193*^9, 
   3.4978147490865145`*^9, 3.497815269747243*^9, {3.4979844049389935`*^9, 
   3.4979844059685955`*^9}, 3.499121904569363*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "-", "n", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", 
        RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", 
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "*", "n"}], "<", 
     RowBox[{"m", "+", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, 
   3.497813004784072*^9, 3.4978145150861864`*^9, 3.497814742666505*^9, {
   3.497921614823383*^9, 3.4979216450094357`*^9}, 3.4979841440597353`*^9, {
   3.4990389176671977`*^9, 3.4990389197420015`*^9}, {3.499114117251869*^9, 
   3.4991141330918913`*^9}, 3.499122053419572*^9, 3.517188889429931*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.475.1'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.497814519586193*^9, 
   3.4978147490865145`*^9, 3.497815269747243*^9, 3.4978154214374557`*^9, 
   3.499038481350032*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "n"}], "<", 
     RowBox[{"1", "-", "m"}]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", "n", "+", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.4978102518358145`*^9, 3.4978103941360135`*^9}, {3.4978119614426117`*^9, 
   3.4978119879026484`*^9}, {3.4978142081057568`*^9, 
   3.4978142300257874`*^9}, {3.497814551106237*^9, 3.4978145682762613`*^9}, {
   3.4978146024663086`*^9, 3.4978146072663155`*^9}, {3.497814842496645*^9, 
   3.4978148883467093`*^9}, {3.4978154312274694`*^9, 3.4978154608075104`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], "]"}], "p"]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"b", " ", "n", " ", "p", " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "n", "+", "1"}]], " ", 
    RowBox[{"Cosh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], "]"}], 
     RowBox[{"p", "-", "1"}]]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"m", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]], "+", "          ", 
  "\[IndentingNewLine]", "          ", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     SuperscriptBox["p", "2"]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", 
       RowBox[{"2", " ", "n"}]}]], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", "p", " ", 
     RowBox[{"(", 
      RowBox[{"p", "-", "1"}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", 
       RowBox[{"2", " ", "n"}]}]], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], "]"}], 
      RowBox[{"p", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, {3.497810228295781*^9, 3.497810232715788*^9}, 
   3.497810535736212*^9, {3.497812078252775*^9, 3.497812093972797*^9}, 
   3.497814621316335*^9, 3.497814652296379*^9, {3.4978148058565936`*^9, 
   3.4978148214266157`*^9}, {3.497815400257426*^9, 3.4978154119374423`*^9}, {
   3.497845142277873*^9, 3.4978451542978897`*^9}, {3.499019090435754*^9, 
   3.499019090445754*^9}, 3.4990191328058133`*^9, 3.499038493081252*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"b", "*", "n", "*", "p", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ",
     "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"p", "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", "p", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "*", "n"}], "<", 
     RowBox[{
      RowBox[{"-", "m"}], "+", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, 
   3.497813004784072*^9, 3.4978145150861864`*^9, 3.497814742666505*^9, 
   3.4978153515773573`*^9, {3.499019090445754*^9, 3.4990190904557543`*^9}, 
   3.499019132815813*^9, 3.499038471834015*^9, 3.517188889445531*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.475.2'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9, 
   3.497810452426095*^9, 3.4978120457827296`*^9, 3.497814519586193*^9, 
   3.4978147490865145`*^9, 3.497815269747243*^9, 3.4978154214374557`*^9, {
   3.4979844118186054`*^9, 3.497984412083806*^9}, {3.499122122379668*^9, 
   3.499122124199671*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], "]"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"b", "*", "n", "*", "p", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ",
     "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"p", "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", "p", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "*", "n"}], "<", 
     RowBox[{
      RowBox[{"-", "m"}], "+", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978101813857155`*^9, 
   3.497810442686082*^9, 3.49781112699704*^9, 3.497812038232719*^9, 
   3.497813004784072*^9, 3.4978145150861864`*^9, 3.497814742666505*^9, 
   3.4978153515773573`*^9, {3.4979216148389826`*^9, 3.497921645025036*^9}, 
   3.4979841554789553`*^9, {3.499114117251869*^9, 3.4991141331218915`*^9}, 
   3.4991221091496496`*^9, 3.517188889445531*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}], "n"]}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.49781110611701*^9, 3.497812987564048*^9, 3.4978161062384143`*^9, 
   3.499019090465754*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by linear substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4978130316141095`*^9, 
   3.497816126028442*^9, {3.497816232328591*^9, 3.4978162335785923`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalQ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4978130900441914`*^9, 3.4978131572642856`*^9}, {
   3.497813348754554*^9, 3.49781336751458*^9}, {3.497814099895605*^9, 
   3.497814106035614*^9}, {3.497816281168659*^9, 3.49781629615868*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}], "n"]}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "d"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["c", "d"]}], "+", 
          FractionBox["x", "d"]}], ")"}], "m"], " ", 
       SuperscriptBox[
        RowBox[{"Sinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], "]"}], "p"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, {3.497811202387145*^9, 3.497811226367179*^9}, {
   3.4978114144974422`*^9, 3.4978114162574444`*^9}, {3.497813065384157*^9, 
   3.4978130749041705`*^9}, {3.4978133280245247`*^9, 
   3.4978133437345467`*^9}, {3.497813396744621*^9, 3.4978134492246943`*^9}, {
   3.4978162571586256`*^9, 3.497816269458643*^9}, {3.499019090475754*^9, 
   3.499019090475754*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c_", "+", 
            RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}]}], "]"}], "^", 
      "p_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "d"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "c"}], "/", "d"}], "+", 
             RowBox[{"x", "/", "d"}]}], ")"}], "^", "m"}], "*", 
          RowBox[{
           RowBox[{"Sinh", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}]}], ",", "x"}], 
        "]"}], ",", "x", ",", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497811159337085*^9, {3.4978114183274474`*^9, 3.4978114203574505`*^9}, 
   3.4978130235240984`*^9, {3.4978134985547633`*^9, 3.497813609294918*^9}, 
   3.497816116228428*^9, {3.499019090475754*^9, 3.499019090485754*^9}, 
   3.4990391061229286`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c_", "+", 
            RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}]}], "]"}], "^", 
      "p_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "d"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "c"}], "/", "d"}], "+", 
             RowBox[{"x", "/", "d"}]}], ")"}], "^", "m"}], "*", 
          RowBox[{
           RowBox[{"Cosh", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "n"}]}]}], "]"}], "^", "p"}]}], ",", "x"}], 
        "]"}], ",", "x", ",", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497811159337085*^9, {3.4978114183274474`*^9, 3.4978114203574505`*^9}, 
   3.4978130235240984`*^9, {3.4978134985547633`*^9, 3.497813609294918*^9}, 
   3.497816116228428*^9, {3.4979216304390106`*^9, 3.4979216304390106`*^9}, 
   3.4979845428120356`*^9, {3.4991141331318913`*^9, 3.4991141331418915`*^9}, 
   3.499122942210816*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sinh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.499019090485754*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}}],

Cell[TextData[{
 "Basis: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["x", "2"]}]}], "=", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"2", " ", "c", " ", "x"}]}], ")"}], "2"], 
    RowBox[{"4", " ", "c"}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sinh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"Sinh", "[", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"2", " ", "c", " ", "x"}]}], ")"}], "2"], 
         RowBox[{"4", " ", "c"}]], "]"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.4990190904957542`*^9, 3.4990190904957542`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sinh", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}], "+", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "^", "2"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", "*", "c"}], ")"}]}], "]"}], ",", "x"}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, {3.4990190904957542`*^9, 3.4990190904957542`*^9}, 
   3.4990392087711086`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Cosh", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}], "+", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "^", "2"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", "*", "c"}], ")"}]}], "]"}], ",", "x"}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, {3.49792163047021*^9, 3.49792163047021*^9}, 
   3.497984621592174*^9, {3.4991141331518917`*^9, 3.4991141331518917`*^9}, 
   3.4991230224209285`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.497810067935557*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sinh", "[", "z", "]"}], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox["\[ExponentialE]", "z"], "2"], "-", 
    FractionBox[
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "z"}]], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, 3.4978100933655925`*^9, {3.497817065230562*^9, 
   3.4978170909905977`*^9}, {3.4990392938536587`*^9, 3.4990392938536587`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817041950529*^9, 3.4978170441505327`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "a"}], "-", 
       RowBox[{"b", " ", "x"}], "-", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.4990190905057545`*^9, 3.499019090515754*^9}, {3.499019132815813*^9, 
   3.4990191328258133`*^9}, 3.4990393338833284`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sinh", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}], "+", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", 
           RowBox[{"b", "*", "x"}], "-", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, {
   3.499019090515754*^9, 3.499019090515754*^9}, {3.4990191328258133`*^9, 
   3.4990191328258133`*^9}, 3.4990392670996113`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Cosh", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}], "+", 
      RowBox[{"c_.", "*", 
       RowBox[{"x_", "^", "2"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", 
           RowBox[{"b", "*", "x"}], "-", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, {
   3.497921614870183*^9, 3.4979216450562363`*^9}, 3.4979846288461866`*^9, {
   3.4991141172618694`*^9, 3.4991141331718917`*^9}, 3.4991230359709473`*^9, {
   3.499123205791185*^9, 3.499123212941195*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}], ")"}], "m"], " ", 
   RowBox[{"Sinh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978172180407763`*^9, 3.499019090525754*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "e"}], "-", 
    RowBox[{"2", "c", " ", "d"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.4978172319407954`*^9, 3.4978172425808105`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"d", "+", 
     RowBox[{"e", " ", "x"}]}], ")"}], 
   RowBox[{"Sinh", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"e", " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"]}]}], "]"}]}], 
      RowBox[{"2", " ", "c"}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.4978172634508395`*^9, 3.4978172755208564`*^9}, 3.499019090535754*^9, 
   3.4990191328258133`*^9, 3.4990394019930487`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"e", "*", 
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817209510764*^9, 3.499019090535754*^9, 
   3.4990191328258133`*^9, 3.4990393993566437`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"e", "*", 
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817209510764*^9, {3.497921614885783*^9, 
   3.497921645071836*^9}, 3.4979847657676272`*^9, {3.4991141172718697`*^9, 
   3.4991141331918917`*^9}, 3.4991232702712755`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "e"}], "-", 
    RowBox[{"2", "c", " ", "d"}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817041950529*^9, 3.4978170441505327`*^9}, {3.497817345560954*^9, 
   3.497817350040961*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}], ")"}], 
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"e", " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], "]"}]}], 
       RowBox[{"2", " ", "c"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", " ", "c", " ", "d"}]}], 
    RowBox[{"2", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.49781732084092*^9, 3.4978173345809393`*^9}, {3.499019090535754*^9, 
   3.499019090535754*^9}, 3.4990191328358135`*^9, 3.4990394282010946`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "e"}], "-", 
         RowBox[{"2", "*", "c", "*", "d"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Sinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, {3.4990190905457544`*^9, 
   3.4990190905457544`*^9}, 3.4990191328358135`*^9, 3.499039424706688*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "e"}], "-", 
         RowBox[{"2", "*", "c", "*", "d"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Cosh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, {3.497921614901383*^9, 
   3.4979216450874357`*^9}, 3.497984772569239*^9, {3.4991141172718697`*^9, 
   3.4991141331918917`*^9}, 3.499123287061299*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", "c", " ", "d"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817041950529*^9, 3.4978170441505327`*^9}, {3.497817345560954*^9, 
   3.497817350040961*^9}, 3.497817472421132*^9, {3.497817508601183*^9, 
   3.497817518021196*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"], 
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                          ", "\[IndentingNewLine]", 
      "                        ", 
      FractionBox[
       RowBox[{"e", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}], 
         RowBox[{"m", "-", "1"}]], " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], "]"}]}], 
       RowBox[{"2", " ", "c"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["e", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", "1"}], ")"}]}], 
    RowBox[{"2", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "-", "2"}]], " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.49781732084092*^9, 3.4978173345809393`*^9}, {3.4978174657811227`*^9, 
   3.4978174870611525`*^9}, {3.4978452139579735`*^9, 3.497845227327992*^9}, 
   3.4990190905457544`*^9, {3.4990191328358135`*^9, 3.4990191328358135`*^9}, {
   3.4990394572795453`*^9, 3.4990394634883566`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"e", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, 3.497817445141094*^9, 
   3.4990190905457544`*^9, {3.4990191328358135`*^9, 3.4990191328458138`*^9}, {
   3.4990394488867307`*^9, 3.499039453753939*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"e", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, 3.497817445141094*^9, {
   3.497921614932583*^9, 3.497921645118636*^9}, 3.497984780150852*^9, {
   3.4991141172818694`*^9, 3.499114133201892*^9}, 3.4991233185413427`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", "c", " ", "d"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817041950529*^9, 3.4978170441505327`*^9}, {3.497817345560954*^9, 
   3.497817350040961*^9}, 3.497817472421132*^9, {3.497817508601183*^9, 
   3.497817518021196*^9}, {3.497817607271321*^9, 3.4978176097513247`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"], 
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"e", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}], 
         RowBox[{"m", "-", "1"}]], " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], "]"}]}], 
       RowBox[{"2", " ", "c"}]]}]}]}]}], "-", 
  "                                                ", "\[IndentingNewLine]", 
  "                ", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", " ", "c", " ", "d"}]}], 
    RowBox[{"2", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "-", "1"}]], " ", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["e", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", "1"}], ")"}]}], 
    RowBox[{"2", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "-", "2"}]], " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.49781732084092*^9, 3.4978173345809393`*^9}, {3.4978174657811227`*^9, 
   3.4978174870611525`*^9}, {3.497817584611289*^9, 3.497817597891308*^9}, {
   3.4990190905457544`*^9, 3.499019090555754*^9}, {3.4990191328458138`*^9, 
   3.4990191328458138`*^9}, {3.499039512722043*^9, 3.4990395200696554`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "e"}], "-", 
         RowBox[{"2", "*", "c", "*", "d"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"e", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, 3.497817445141094*^9, 
   3.497817548651239*^9, {3.499019090555754*^9, 3.499019090555754*^9}, {
   3.4990191328458138`*^9, 3.4990191328558135`*^9}, 3.4990395018956237`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "e"}], "-", 
         RowBox[{"2", "*", "c", "*", "d"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"e", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, 3.497817445141094*^9, 
   3.497817548651239*^9, {3.497921614948183*^9, 3.4979216451342363`*^9}, 
   3.49798479001007*^9, {3.499114117291869*^9, 3.4991141332118917`*^9}, 
   3.499123341571375*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", "c", " ", "d"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817041950529*^9, 3.4978170441505327`*^9}, {3.497817345560954*^9, 
   3.497817350040961*^9}, 3.497817472421132*^9, {3.497817508601183*^9, 
   3.497817518021196*^9}, {3.4978176606313953`*^9, 3.497817661711397*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"], 
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                         ", "\[IndentingNewLine]", 
      "                               ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], "]"}]}], 
       RowBox[{"e", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "c"}], 
    RowBox[{
     SuperscriptBox["e", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "+", "2"}]], " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.49781732084092*^9, 3.4978173345809393`*^9}, {3.4978174657811227`*^9, 
   3.4978174870611525`*^9}, 3.497817687031432*^9, {3.4978452447580166`*^9, 
   3.497845253888029*^9}, {3.497845336788145*^9, 3.497845345858158*^9}, {
   3.499019090555754*^9, 3.4990190905657544`*^9}, 3.4990191328558135`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"c", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"e", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, 3.497817445141094*^9, 
   3.497817656111389*^9, {3.4990190905657544`*^9, 3.4990190905657544`*^9}, 
   3.4990191328558135`*^9, 3.499039550614509*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"c", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"e", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, 3.497817445141094*^9, 
   3.497817656111389*^9, {3.4979216149793835`*^9, 3.497921645149836*^9}, 
   3.497984798652485*^9, {3.4991141173018694`*^9, 3.4991141332118917`*^9}, 
   3.499123368061412*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", "c", " ", "d"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817041950529*^9, 3.4978170441505327`*^9}, {3.497817345560954*^9, 
   3.497817350040961*^9}, 3.497817472421132*^9, {3.497817508601183*^9, 
   3.497817518021196*^9}, {3.497817607271321*^9, 3.4978176097513247`*^9}, {
   3.497817752511524*^9, 3.497817753781526*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"], 
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], "]"}]}], 
       RowBox[{"e", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                ", "\[IndentingNewLine]", 
  "           ", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", " ", "c", " ", "d"}]}], 
    RowBox[{
     SuperscriptBox["e", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "+", "1"}]], " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "c"}], 
    RowBox[{
     SuperscriptBox["e", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "+", "2"}]], " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.49781732084092*^9, 3.4978173345809393`*^9}, {3.4978174657811227`*^9, 
   3.4978174870611525`*^9}, {3.497817584611289*^9, 3.497817597891308*^9}, {
   3.497817735711501*^9, 3.4978177468615165`*^9}, {3.4978453784582033`*^9, 
   3.497845389358219*^9}, {3.4990190905657544`*^9, 3.4990190905657544`*^9}, {
   3.4990191328558135`*^9, 3.4990191328558135`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "e"}], "-", 
         RowBox[{"2", "*", "c", "*", "d"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"e", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"c", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"e", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, 3.497817445141094*^9, 
   3.497817548651239*^9, 3.497817648381378*^9, 3.497817703281455*^9, {
   3.499019090575754*^9, 3.499019090575754*^9}, {3.4990191328658133`*^9, 
   3.4990191328658133`*^9}, 3.4990395795837603`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "e"}], "-", 
         RowBox[{"2", "*", "c", "*", "d"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"e", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"c", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"e", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978172025607543`*^9, 3.4978172990008893`*^9, 3.497817445141094*^9, 
   3.497817548651239*^9, 3.497817648381378*^9, 3.497817703281455*^9, {
   3.497921614994983*^9, 3.497921645181036*^9}, 3.4979848055788975`*^9, {
   3.4991141173118696`*^9, 3.4991141332218914`*^9}, 3.4991234226914883`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978178569916706`*^9, 3.4990190905857544`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4990396795175357`*^9, 
   3.4990396795175357`*^9}, 3.5153673173187337`*^9, 3.5157961107537346`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sinh", "[", 
    RowBox[{"b", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "n"]}], "]"}]}], "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}], ")"}], "b"]}], "-", 
    FractionBox["1", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], ")"}], "b"]}]]}]}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4990396795175357`*^9, 
   3.4990396795175357`*^9}, 3.5153673173187337`*^9, {3.515796116681745*^9, 
   3.5157961265565624`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4990396795175357`*^9, 
   3.4990396795175357`*^9}, 3.5153673173187337`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"b", " ", 
      RowBox[{"Log", "[", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}], "]"}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], ")"}], "b"], "2"], "-", 
          FractionBox["1", 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"c", " ", 
               SuperscriptBox["x", "n"]}], ")"}], "b"]}]]}], ")"}], "p"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4990190905957546`*^9, 
   3.4990190905957546`*^9}, 3.4990191328658133`*^9, {3.499039688861952*^9, 
   3.4990396910459557`*^9}, {3.515367236838621*^9, 3.5153672491286383`*^9}, {
   3.515367281998684*^9, 3.5153673362987604`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"b_.", "*", 
       RowBox[{"Log", "[", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "]"}]}], "]"}], "^", "p_."}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], ")"}], "^", "b"}], "/", "2"}], " ", 
        "-", " ", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "n"}]}], ")"}], "^", "b"}]}], ")"}]}]}], 
       ")"}], "^", "p"}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"c", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"b", ",", "n", ",", "p"}], "}"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, {3.4990190905957546`*^9, 
   3.4990190905957546`*^9}, 3.4990191328658133`*^9, 3.499039673480325*^9, 
   3.515367226228606*^9},
 Background->GrayLevel[0.85]],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Cosh", "[", 
    RowBox[{"b", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "n"]}], "]"}]}], "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}], ")"}], "b"]}], "+", 
    FractionBox["1", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], ")"}], "b"]}]]}]}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4990396795175357`*^9, 
   3.4990396795175357`*^9}, 3.5153673173187337`*^9, {3.515796116681745*^9, 
   3.5157961265565624`*^9}, 3.5157964207550793`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"b_.", "*", 
       RowBox[{"Log", "[", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "]"}]}], "]"}], "^", "p_."}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], ")"}], "^", "b"}], "/", "2"}], " ", 
        "+", " ", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "n"}]}], ")"}], "^", "b"}]}], ")"}]}]}], 
       ")"}], "^", "p"}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"c", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"b", ",", "n", ",", "p"}], "}"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, {3.4990190905957546`*^9, 
   3.4990190905957546`*^9}, 3.4990191328658133`*^9, 3.499039673480325*^9, 
   3.515367226228606*^9, {3.51536777182937*^9, 3.5153677723393707`*^9}, 
   3.51536784316947*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"]}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4990396795175357`*^9, 
   3.4990396795175357`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}]}], 
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["n", "2"]}]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"b", " ", "n", " ", "x", " ", 
    RowBox[{"Cosh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}]}], 
   RowBox[{"1", "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"]}]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4990190905957546`*^9, 
   3.4990190905957546`*^9}, 3.4990191328658133`*^9, {3.499039688861952*^9, 
   3.4990396910459557`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sinh", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"Log", "[", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"b", "*", "n", "*", "x", "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, {3.4990190905957546`*^9, 
   3.4990190905957546`*^9}, 3.4990191328658133`*^9, 3.499039673480325*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Cosh", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"Log", "[", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"b", "*", "n", "*", "x", "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, {3.497921615010583*^9, 
   3.497921645196636*^9}, 3.497985161961523*^9, {3.4991141173118696`*^9, 
   3.499114133241892*^9}, 3.49912351619162*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4990396795175357`*^9, 
   3.4990396795175357`*^9}, {3.515367522629021*^9, 3.515367527319028*^9}, {
   3.51536760742914*^9, 3.515367618659156*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "n"}], "-", "2"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4990396795175357`*^9, 
   3.4990396795175357`*^9}, {3.515367522629021*^9, 3.515367527319028*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"x", " ", 
       SqrtBox[
        RowBox[{"Sinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}]]}], 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "a"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", "n"]}], ")"}], 
          RowBox[{"4", "/", "n"}]]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "a"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", "n"]}], ")"}], 
          RowBox[{"4", "/", "n"}]]}]}]], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4990190905957546`*^9, 
   3.4990190905957546`*^9}, 3.4990191328658133`*^9, {3.499039688861952*^9, 
   3.4990396910459557`*^9}, {3.515367382318825*^9, 3.51536739327884*^9}, 
   3.5153674851489687`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "]"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"x", "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "a"}], ")"}]}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"4", "/", "n"}], ")"}]}]}]}], "]"}]}], "*", "\n", "    ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"E", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", "a"}], ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "n"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"4", "/", "n"}], ")"}]}]}]}], "]"}], "/", "x"}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "n"}], "-", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, {3.4990190905957546`*^9, 
   3.4990190905957546`*^9}, 3.4990191328658133`*^9, 3.499039673480325*^9, 
   3.5153674120188665`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "]"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"x", "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "a"}], ")"}]}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"4", "/", "n"}], ")"}]}]}]}], "]"}]}], "*", "\n", "    ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"E", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", "a"}], ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "n"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"4", "/", "n"}], ")"}]}]}]}], "]"}], "/", "x"}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "n"}], "-", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, {3.4990190905957546`*^9, 
   3.4990190905957546`*^9}, 3.4990191328658133`*^9, 3.499039673480325*^9, 
   3.5153674120188665`*^9, {3.5153677831493855`*^9, 3.5153677873793917`*^9}, 
   3.515367859509493*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox["p", "2"]}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978180135518894`*^9, 
   3.4978180349019194`*^9}, {3.499039783834919*^9, 3.499039783834919*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", " ", 
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"]}], 
       RowBox[{"1", "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["n", "2"], " ", 
         SuperscriptBox["p", "2"]}]}]]}]}]}]}], "-", 
  "                                                                           \
     ", "\[IndentingNewLine]", "   ", 
  FractionBox[
   RowBox[{"b", " ", "n", " ", "p", " ", "x", " ", 
    RowBox[{"Cosh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
     RowBox[{"p", "-", "1"}]]}], 
   RowBox[{"1", "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     SuperscriptBox["p", "2"]}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", "p", " ", 
     RowBox[{"(", 
      RowBox[{"p", "-", "1"}], ")"}]}], 
    RowBox[{"1", "-", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox["p", "2"]}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
      RowBox[{"p", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.497817967231825*^9, 3.4978179825118465`*^9}, {3.4978454312782774`*^9, 
   3.497845444918297*^9}, {3.49784591148895*^9, 3.4978459126289515`*^9}, {
   3.497846040609131*^9, 3.497846045799138*^9}, {3.4990190906057544`*^9, 
   3.4990190906057544`*^9}, 3.4990191328758135`*^9, {3.4990397772673073`*^9, 
   3.4990397815885153`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"b", "*", "n", "*", "p", "*", "x", "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", "p", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"n", "^", "2"}], "*", 
           RowBox[{"p", "^", "2"}]}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, {3.4990190906057544`*^9, 
   3.499019090615754*^9}, 3.4990191328758135`*^9, 3.4990397642880845`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"b", "*", "n", "*", "p", "*", "x", "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", "p", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"n", "^", "2"}], "*", 
           RowBox[{"p", "^", "2"}]}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, {3.4979216150417833`*^9, 
   3.4979216452122364`*^9}, 3.4979851724603415`*^9, {3.49911411732187*^9, 
   3.499114133261892*^9}, {3.499123547961664*^9, 3.499123555031674*^9}, 
   3.4991236466418023`*^9, {3.499123682131852*^9, 3.4991236881818604`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "\[And]", " ", 
    RowBox[{"1", "-", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}], "2"]}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978180135518894`*^9, 
   3.4978180349019194`*^9}, {3.4978181090720234`*^9, 3.497818144362073*^9}, {
   3.4990401848960238`*^9, 3.4990402044428577`*^9}, {3.499041274704338*^9, 
   3.499041299742382*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", " ", 
        RowBox[{"Coth", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
         RowBox[{"p", "+", "2"}]]}], 
       RowBox[{"b", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
     RowBox[{"p", "+", "2"}]]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "2"}], ")"}]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.497817967231825*^9, 3.4978179825118465`*^9}, {3.4978180869619923`*^9, 
   3.497818100362011*^9}, {3.497845459618317*^9, 3.4978454619083204`*^9}, {
   3.499019090615754*^9, 3.4990190906257544`*^9}, 3.499019177685876*^9, 
   3.499040122573914*^9, {3.499041257528708*^9, 3.499041265703122*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"Coth", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "+", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.4978180612919564`*^9, {
   3.4990190906257544`*^9, 3.4990190906357546`*^9}, 3.499019177685876*^9, 
   3.4990400254949436`*^9, {3.499040065945814*^9, 3.4990400962722673`*^9}, 
   3.499041242615082*^9, {3.515610963980446*^9, 3.5156109677196593`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], "*", 
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n", ",", "p"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "+", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.4978180612919564`*^9, {
   3.497921630751011*^9, 3.497921630751011*^9}, 3.4979851806035557`*^9, {
   3.4990389242348094`*^9, 3.4990389253268113`*^9}, 3.4990410904992146`*^9, {
   3.499041644064588*^9, 3.4990416507101994`*^9}, {3.4991141332718916`*^9, 
   3.4991141445719075`*^9}, 3.4991235614716825`*^9, 3.499123804552023*^9, {
   3.4991240193423243`*^9, 3.499124024622331*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"p", "\[NotEqual]", 
    RowBox[{"-", "2"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}], "2"]}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978180135518894`*^9, 
   3.4978180349019194`*^9}, {3.4978181090720234`*^9, 3.497818144362073*^9}, {
   3.4990401848960238`*^9, 3.4990402044428577`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"x", " ", 
        RowBox[{"Coth", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
         RowBox[{"p", "+", "2"}]]}], 
       RowBox[{"b", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "-", "                  ",
   "\[IndentingNewLine]", "                      ", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
     RowBox[{"p", "+", "2"}]]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "2"}], ")"}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "-", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}], "2"]}]}], 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
      RowBox[{"p", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.497817967231825*^9, 3.4978179825118465`*^9}, {3.4978180869619923`*^9, 
   3.497818100362011*^9}, {3.497845459618317*^9, 3.4978454619083204`*^9}, {
   3.499019090615754*^9, 3.4990190906257544`*^9}, 3.499019177685876*^9, 
   3.499040122573914*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"Coth", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "!=", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.4978180612919564`*^9, {
   3.4990190906257544`*^9, 3.4990190906357546`*^9}, 3.499019177685876*^9, 
   3.4990400254949436`*^9, {3.499040065945814*^9, 3.4990400962722673`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], "*", 
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"x", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Log", "[", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"p", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.4978180612919564`*^9, {
   3.497921630751011*^9, 3.497921630751011*^9}, 3.4979851806035557`*^9, {
   3.4990389242348094`*^9, 3.4990389253268113`*^9}, 3.4990410904992146`*^9, {
   3.499114133281892*^9, 3.4991141445819073`*^9}, 3.4991235654516883`*^9, {
   3.499123957322237*^9, 3.499124007452307*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978178569916706`*^9, 3.4978181977321477`*^9, 
   3.4990190906457543`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "2"], "-", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"]}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978182572522306`*^9, 
   3.497818281002264*^9}, {3.4990422720280905`*^9, 3.4990422720280905`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Sinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["n", "2"]}]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"b", " ", "n", " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], " ", 
    RowBox[{"Cosh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "2"], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"]}]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, 3.497818243732212*^9, 
   3.497818386462412*^9, {3.499019090655754*^9, 3.499019090655754*^9}, 
   3.4990191328758135`*^9, {3.4990422668488817`*^9, 3.499042269173286*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"b", "*", "n", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497818221872181*^9, {
   3.4990190906657543`*^9, 3.4990190906657543`*^9}, 3.4990191328858137`*^9, 
   3.4990421983491616`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"b", "*", "n", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}]}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497818221872181*^9, {
   3.4979216150573835`*^9, 3.4979216452434363`*^9}, 3.4979853429218407`*^9, {
   3.4991141173318696`*^9, 3.499114133321892*^9}, 3.499124718063302*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "2"], "-", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox["p", "2"]}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"p", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978182572522306`*^9, 
   3.497818281002264*^9}, {3.4978183492423596`*^9, 3.4978183713523903`*^9}, {
   3.4990423657530556`*^9, 3.4990423657530556`*^9}, {3.4991263595856004`*^9, 
   3.499126362765605*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["n", "2"], " ", 
         SuperscriptBox["p", "2"]}]}]]}]}]}]}], "-", 
  "                                                                     ", 
  "\[IndentingNewLine]", " ", 
  FractionBox[
   RowBox[{"b", " ", "n", " ", "p", " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], " ", 
    RowBox[{"Cosh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
     RowBox[{"p", "-", "1"}]]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "2"], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     SuperscriptBox["p", "2"]}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", "p", " ", 
     RowBox[{"(", 
      RowBox[{"p", "-", "1"}], ")"}]}], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "2"], "-", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox["p", "2"]}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
      RowBox[{"p", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.497817967231825*^9, 3.4978179825118465`*^9}, {3.4978183229423227`*^9, 
   3.4978183297523327`*^9}, 3.4978183882424145`*^9, {3.4978454955383673`*^9, 
   3.497845510118388*^9}, {3.4978459385889883`*^9, 3.4978459422389927`*^9}, {
   3.497846083829191*^9, 3.4978460897591996`*^9}, {3.4990190906757545`*^9, 
   3.4990190906757545`*^9}, 3.499019132895814*^9, {3.4990423567830396`*^9, 
   3.49904236255505*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"b", "*", "n", "*", "p", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", "p", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"n", "^", "2"}], "*", 
           RowBox[{"p", "^", "2"}]}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Log", "[", 
              RowBox[{"c", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.497818214522171*^9, 
   3.4978182978122873`*^9, {3.4990190906857543`*^9, 3.499019090695754*^9}, 
   3.4990191329058137`*^9, 3.4990423320725965`*^9, {3.4991263469555826`*^9, 
   3.499126349375586*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", "p"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"b", "*", "n", "*", "p", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"p", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"p", "^", "2"}]}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", "p", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "*", 
           RowBox[{"n", "^", "2"}], "*", 
           RowBox[{"p", "^", "2"}]}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Log", "[", 
              RowBox[{"c", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{"p", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.497818214522171*^9, 
   3.4978182978122873`*^9, {3.4979216150729833`*^9, 3.497921645259036*^9}, 
   3.4979853494270525`*^9, {3.4979854617472496`*^9, 3.49798546776886*^9}, {
   3.4991141173518696`*^9, 3.499114133351892*^9}, 3.4991248596435003`*^9, {
   3.4991255788545074`*^9, 3.4991255811645107`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "2"], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"p", "+", "2"}], ")"}], "2"]}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978180135518894`*^9, 
   3.4978180349019194`*^9}, {3.4978181090720234`*^9, 3.497818144362073*^9}, {
   3.4978184547825074`*^9, 3.497818462092518*^9}, {3.499042515950119*^9, 
   3.4990425250917354`*^9}, {3.4990426435271435`*^9, 
   3.4990426525283594`*^9}, {3.499042696629637*^9, 3.4990427046792507`*^9}, {
   3.4991264074656672`*^9, 3.4991264168756804`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Coth", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
         RowBox[{"p", "+", "2"}]]}], 
       RowBox[{"b", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"m", "+", "1"}], ")"}], " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
     RowBox[{"p", "+", "2"}]]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "2"}], ")"}]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.497817967231825*^9, 3.4978179825118465`*^9}, {3.4978180869619923`*^9, 
   3.497818100362011*^9}, 3.497818391632419*^9, {3.4978184390724854`*^9, 
   3.4978184412724886`*^9}, {3.497845520178402*^9, 3.4978455282384133`*^9}, {
   3.497846105079221*^9, 3.497846105589222*^9}, {3.4990190907057543`*^9, 
   3.4990190907157545`*^9}, 3.499019177685876*^9, 3.4990424892116723`*^9, {
   3.499042677379203*^9, 3.499042687862421*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Coth", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}]}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "+", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.4978180612919564`*^9, 
   3.497818211422167*^9, 3.4978184091424437`*^9, {3.4990190907257547`*^9, 
   3.4990190907357545`*^9}, 3.499019177695876*^9, {3.499042426998763*^9, 
   3.4990424279815645`*^9}, 3.4990424660456314`*^9, 3.499042615010293*^9, {
   3.499126390805644*^9, 3.4991263929156466`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}]}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"p", "+", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.4978180612919564`*^9, 
   3.497818211422167*^9, 3.4978184091424437`*^9, {3.497921630844611*^9, 
   3.497921630860211*^9}, 3.497985357897867*^9, {3.499038934889628*^9, 
   3.49903893579443*^9}, {3.499114133381892*^9, 3.4991141445919075`*^9}, 
   3.499124912863575*^9, {3.4991249854236765`*^9, 3.499124986633678*^9}, {
   3.4991250510437684`*^9, 3.4991251010838385`*^9}, {3.499125653714612*^9, 
   3.4991256565246162`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "2"], "-", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}], "2"]}]}], "\[NotEqual]", "0"}], " ", 
   "\[And]", " ", 
   RowBox[{"p", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"p", "\[NotEqual]", 
    RowBox[{"-", "2"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978180135518894`*^9, 
   3.4978180349019194`*^9}, {3.4978181090720234`*^9, 3.497818144362073*^9}, {
   3.4978184547825074`*^9, 3.497818462092518*^9}, {3.499042515950119*^9, 
   3.4990425250917354`*^9}, {3.4991264456957207`*^9, 3.4991264577557373`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"Coth", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"c", " ", 
              SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
         RowBox[{"p", "+", "2"}]]}], 
       RowBox[{"b", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                           ", "\[IndentingNewLine]", "        ", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"m", "+", "1"}], ")"}], " ", 
    SuperscriptBox["x", 
     RowBox[{"m", "+", "1"}]], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
     RowBox[{"p", "+", "2"}]]}], 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["n", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"p", "+", "2"}], ")"}]}]], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "2"], "-", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}], "2"]}]}], 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["n", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"p", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "n"]}], "]"}]}]}], "]"}], 
      RowBox[{"p", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.497817967231825*^9, 3.4978179825118465`*^9}, {3.4978180869619923`*^9, 
   3.497818100362011*^9}, 3.497818391632419*^9, {3.4978184390724854`*^9, 
   3.4978184412724886`*^9}, {3.497845520178402*^9, 3.4978455282384133`*^9}, {
   3.497846105079221*^9, 3.497846105589222*^9}, {3.4990190907057543`*^9, 
   3.4990190907157545`*^9}, 3.499019177685876*^9, 3.4990424892116723`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Coth", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Log", "[", 
              RowBox[{"c", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}]}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "!=", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.4978180612919564`*^9, 
   3.497818211422167*^9, 3.4978184091424437`*^9, {3.4990190907257547`*^9, 
   3.4990190907357545`*^9}, 3.499019177695876*^9, {3.499042426998763*^9, 
   3.4990424279815645`*^9}, 3.4990424660456314`*^9, {3.4991264361557074`*^9, 
   3.499126438565711*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Log", "[", 
          RowBox[{"c_.", "*", 
           RowBox[{"x_", "^", "n_."}]}], "]"}]}]}], "]"}], "^", "p_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{"Tanh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Log", "[", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", 
        RowBox[{"n", "^", "2"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", 
          RowBox[{"n", "^", "2"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"n", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"Cosh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Log", "[", 
              RowBox[{"c", "*", 
               RowBox[{"x", "^", "n"}]}], "]"}]}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "^", "2"}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{"n", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p", "+", "2"}], ")"}], "^", "2"}]}]}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"p", "\[NotEqual]", 
     RowBox[{"-", "2"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.4978180612919564`*^9, 
   3.497818211422167*^9, 3.4978184091424437`*^9, {3.497921630844611*^9, 
   3.497921630860211*^9}, 3.497985357897867*^9, {3.499038934889628*^9, 
   3.49903893579443*^9}, {3.499114133381892*^9, 3.4991141445919075`*^9}, 
   3.499124912863575*^9, {3.499125667324631*^9, 3.4991256696146345`*^9}, {
   3.4991258335348635`*^9, 3.4991258347848654`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sinh", "[", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "n"], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978178569916706`*^9, 3.4978181977321477`*^9, {
   3.497818713152869*^9, 3.4978187170428743`*^9}, 3.4990190907457542`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"p", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978182572522306`*^9, 
   3.497818281002264*^9}, {3.4978188033329954`*^9, 3.497818805922999*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sinh", "[", 
     RowBox[{"a", " ", "x", " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"Cosh", "[", 
        RowBox[{"a", " ", "x", " ", 
         SuperscriptBox[
          RowBox[{"Log", "[", 
           RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], "a"]}]}]}]}], "-", 
  RowBox[{"p", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"a", " ", "x", " ", 
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"b", " ", "x"}], "]"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, 3.497818243732212*^9, 
   3.497818386462412*^9, {3.497818766582944*^9, 3.4978187902229767`*^9}, {
   3.4990190907557545`*^9, 3.4990190907557545`*^9}, 3.4990191329158134`*^9, 
   3.499043048722255*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "*", "x_", "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "*", "x", "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "/", "a"}], " ",
     "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"p", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "*", "x", "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"b", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497818221872181*^9, 
   3.4978187399329066`*^9, {3.4990190907657547`*^9, 3.4990190907657547`*^9}, 
   3.4990191329258137`*^9, 3.4990429937009583`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "*", "x_", "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "*", "x", "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "/", "a"}], " ",
     "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"p", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "*", "x", "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"b", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497818221872181*^9, 
   3.4978187399329066`*^9, {3.497921615088583*^9, 3.4979216452746363`*^9}, 
   3.497985551837408*^9, {3.4991141173718696`*^9, 3.499114133421892*^9}, 
   3.4991268200462446`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"p", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978182572522306`*^9, 
   3.497818281002264*^9}, {3.4978183492423596`*^9, 3.4978183713523903`*^9}, {
   3.497818911663147*^9, 3.497818912483148*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"Sinh", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"], " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"Cosh", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"], " ", 
         SuperscriptBox[
          RowBox[{"Log", "[", 
           RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], 
       RowBox[{"a", " ", "n", " ", 
        SuperscriptBox["x", 
         RowBox[{"n", "-", "1"}]]}]]}]}]}]}], "-", 
  "                              ", "\[IndentingNewLine]", 
  "                       ", 
  RowBox[{
   FractionBox["p", "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"], " ", 
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"b", " ", "x"}], "]"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], 
    RowBox[{"a", " ", "n"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Cosh", "[", 
       RowBox[{"a", " ", 
        SuperscriptBox["x", "n"], " ", 
        SuperscriptBox[
         RowBox[{"Log", "[", 
          RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], 
      SuperscriptBox["x", "n"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4978101340656495`*^9, 
   3.4978101470356674`*^9}, 3.497816875700297*^9, 3.497816927160369*^9, {
   3.497817967231825*^9, 3.4978179825118465`*^9}, {3.4978183229423227`*^9, 
   3.4978183297523327`*^9}, 3.4978183882424145`*^9, 3.497818842933051*^9, {
   3.4978188819031053`*^9, 3.497818893043121*^9}, {3.4978455965785093`*^9, 
   3.497845617398538*^9}, {3.499019090775755*^9, 3.499019090775755*^9}, {
   3.499019132935814*^9, 3.499019132935814*^9}, {3.499043061685878*^9, 
   3.4990430689242907`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "*", 
       RowBox[{"x_", "^", "n_"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "*", 
       RowBox[{"x", "^", "n"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "n", "*", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"p", "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"b", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "n"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "/", 
         RowBox[{"x", "^", "n"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.497818214522171*^9, 
   3.4978182978122873`*^9, 3.497818743032911*^9, 3.4978188281930304`*^9, {
   3.4990190907857547`*^9, 3.4990190907857547`*^9}, {3.4990191329458137`*^9, 
   3.4990191329458137`*^9}, 3.499043009363386*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "*", 
       RowBox[{"x_", "^", "n_"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "*", 
       RowBox[{"x", "^", "n"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "n", "*", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}]}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"p", "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"b", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "n"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "/", 
         RowBox[{"x", "^", "n"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.497818214522171*^9, 
   3.4978182978122873`*^9, 3.497818743032911*^9, 3.4978188281930304`*^9, {
   3.497921615104183*^9, 3.4979216453058367`*^9}, 3.49798557554945*^9, {
   3.4991141173918695`*^9, 3.4991141334418917`*^9}, 3.499126877996326*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   RowBox[{"Sinh", "[", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "n"], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"b", " ", "x"}], "]"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978178569916706`*^9, 3.4978181977321477`*^9, {
   3.497818713152869*^9, 3.4978187170428743`*^9}, 3.4978189740632343`*^9, 
   3.4990190907857547`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"p", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"m", "-", "n", "+", "1"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978182572522306`*^9, 
   3.497818281002264*^9}, {3.4978188033329954`*^9, 3.497818805922999*^9}, {
   3.497819708564263*^9, 3.497819716594274*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"Sinh", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"], " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"Cosh", "[", 
        RowBox[{"a", " ", 
         SuperscriptBox["x", "n"], " ", 
         SuperscriptBox[
          RowBox[{"Log", "[", 
           RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], 
       RowBox[{"a", " ", "n"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["p", "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"], " ", 
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"b", " ", "x"}], "]"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, 3.497818243732212*^9, 
   3.497818386462412*^9, {3.497818766582944*^9, 3.4978187902229767`*^9}, 
   3.497819037943324*^9, {3.497819072503372*^9, 3.4978190856033907`*^9}, 
   3.497819761524337*^9, {3.4990190907957544`*^9, 3.4990190908057547`*^9}, 
   3.4990191329558134`*^9, 3.4990432898674784`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "*", 
       RowBox[{"x_", "^", "n_."}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "*", 
       RowBox[{"x", "^", "n"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "n"}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"p", "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"b", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.497818214522171*^9, 
   3.4978182978122873`*^9, 3.497818743032911*^9, 3.4978188281930304`*^9, 
   3.497845658198595*^9, {3.4990190908057547`*^9, 3.499019090815755*^9}, 
   3.4990191329658136`*^9, 3.499043230758975*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "*", 
       RowBox[{"x_", "^", "n_."}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "*", 
       RowBox[{"x", "^", "n"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "n"}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"p", "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"b", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.497818214522171*^9, 
   3.4978182978122873`*^9, 3.497818743032911*^9, 3.4978188281930304`*^9, 
   3.497845658198595*^9, {3.4979216151197834`*^9, 3.4979216453214364`*^9}, 
   3.497985809830661*^9, {3.4991141174118695`*^9, 3.4991141334718924`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "-", "n", "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978182572522306`*^9, 
   3.497818281002264*^9}, {3.4978188033329954`*^9, 3.497818805922999*^9}, {
   3.497819648964179*^9, 3.4978196804042234`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"Sinh", "[", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"], " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"b", " ", "x"}], "]"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "n", "+", "1"}]], " ", 
        RowBox[{"Cosh", "[", 
         RowBox[{"a", " ", 
          SuperscriptBox["x", "n"], " ", 
          SuperscriptBox[
           RowBox[{"Log", "[", 
            RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}]}], 
       RowBox[{"a", " ", "n"}]]}]}]}]}], "-", 
  "                                ", "\[IndentingNewLine]", "           ", 
  RowBox[{
   FractionBox["p", "n"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"], " ", 
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"b", " ", "x"}], "]"}], 
      RowBox[{"p", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "n", "+", "1"}], 
    RowBox[{"a", " ", "n"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "n"}]], " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"], " ", 
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"b", " ", "x"}], "]"}], "p"]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, 3.497818243732212*^9, 
   3.497818386462412*^9, {3.497818766582944*^9, 3.4978187902229767`*^9}, 
   3.497819037943324*^9, {3.497819072503372*^9, 3.4978190856033907`*^9}, {
   3.4978457040786595`*^9, 3.497845706958664*^9}, {3.497846135109263*^9, 
   3.497846147789281*^9}, {3.4990190908257546`*^9, 3.4990190908257546`*^9}, {
   3.499019132975814*^9, 3.499019132975814*^9}, {3.4990431731636734`*^9, 
   3.4990431805580864`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"a_.", "*", 
       RowBox[{"x_", "^", "n_."}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"a", "*", 
        RowBox[{"x", "^", "n"}], "*", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "n"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"p", "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"b", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "n"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.497818214522171*^9, 
   3.4978182978122873`*^9, 3.497818743032911*^9, 3.4978188281930304`*^9, {
   3.497845658198595*^9, 3.497845675068619*^9}, {3.4990190908357544`*^9, 
   3.4990190908357544`*^9}, {3.4990191329858136`*^9, 3.4990191329858136`*^9}, 
   3.499043151167635*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "*", 
       RowBox[{"x_", "^", "n_."}], "*", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"b_.", "*", "x_"}], "]"}], "^", "p_."}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "*", 
        RowBox[{"x", "^", "n"}], "*", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "n"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"p", "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"b", "*", "x"}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "n"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "*", 
           RowBox[{"x", "^", "n"}], "*", 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{"b", "*", "x"}], "]"}], "^", "p"}]}], "]"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4978099270853596`*^9, 3.497810062495549*^9, 3.4978168901103168`*^9, 
   3.4978178331616373`*^9, 3.497817943721792*^9, 3.497818214522171*^9, 
   3.4978182978122873`*^9, 3.497818743032911*^9, 3.4978188281930304`*^9, {
   3.497845658198595*^9, 3.497845675068619*^9}, {3.4979216151509833`*^9, 
   3.497921645337036*^9}, {3.497985717369299*^9, 3.4979857479453526`*^9}, {
   3.4991141174318695`*^9, 3.499114133491892*^9}, 3.4991269332764034`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, 3.5000652014948616`*^9, 
   3.500071919760484*^9, 3.5000742351937256`*^9, {3.5000764530668306`*^9, 
   3.5000764698568544`*^9}, {3.5156061721620646`*^9, 3.515606175192069*^9}, {
   3.515784590296414*^9, 3.5157845913564153`*^9}, 3.5157846672765217`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sinh", "[", "z", "]"}], "2"], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"2", " ", "z"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.515784683226544*^9, 
   3.5157847079265785`*^9}, {3.515784786006688*^9, 3.515784790686694*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], "2"], "\[NotElement]", 
   "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, 3.497639786159789*^9, {3.4976636687943316`*^9, 
   3.497663674238741*^9}, 3.500065336645051*^9, {3.5000653831351156`*^9, 
   3.5000653931651297`*^9}, {3.5000654310051827`*^9, 3.500065453315214*^9}, {
   3.500069687963237*^9, 3.5000696889460382`*^9}, 3.5000699834433556`*^9, {
   3.500073956083335*^9, 3.5000740306834393`*^9}, {3.500074095863531*^9, 
   3.5000741212435665`*^9}, {3.5000741522836094`*^9, 
   3.5000741751536417`*^9}, {3.500074221103706*^9, 3.500074221103706*^9}, 
   3.500074503914102*^9, {3.500089709186855*^9, 3.5000897361468925`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{
       FractionBox["a", "2"], "+", 
       FractionBox[
        RowBox[{"b", " ", "x"}], "2"]}], "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.500079530261139*^9, 3.500079575451202*^9}, {
   3.5000796205012655`*^9, 3.500079671061336*^9}, {3.515784684116545*^9, 
   3.5157847086465797`*^9}, {3.515784807066717*^9, 3.515784817756732*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], ",", "x"}], "]"}]}],
       "]"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{"a", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{"b", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"OddQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, {
   3.500077639438492*^9, 3.5000776443384986`*^9}, {3.500079737691429*^9, 
   3.500079771871477*^9}, {3.500079835841567*^9, 3.5000799106916714`*^9}, {
   3.5000799437417173`*^9, 3.500079972731758*^9}, {3.5000800254818325`*^9, 
   3.5000800531018705`*^9}, {3.500080550942568*^9, 3.500080551872569*^9}, {
   3.5000896569567814`*^9, 3.50008966290679*^9}, {3.5157846867465487`*^9, 
   3.515784709676581*^9}, {3.515784844086769*^9, 3.5157848473867736`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Cosh", "[", "z", "]"}], "2"], "=", 
   RowBox[{
    FractionBox["1", "2"], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"2", " ", "z"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.5000813814137306`*^9, 
   3.5000813899437428`*^9}, {3.5157847099665813`*^9, 
   3.5157847106765823`*^9}, {3.5157848700568056`*^9, 3.515784892426837*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], "2"], "\[NotElement]", 
   "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, 3.497639786159789*^9, {3.4976636687943316`*^9, 
   3.497663674238741*^9}, 3.500065336645051*^9, {3.5000653831351156`*^9, 
   3.5000653931651297`*^9}, {3.5000654310051827`*^9, 3.500065453315214*^9}, {
   3.500069687963237*^9, 3.5000696889460382`*^9}, 3.5000699834433556`*^9, {
   3.500073956083335*^9, 3.5000740306834393`*^9}, {3.500074095863531*^9, 
   3.5000741212435665`*^9}, {3.5000741522836094`*^9, 
   3.5000741751536417`*^9}, {3.500074221103706*^9, 3.500074221103706*^9}, 
   3.500074503914102*^9, {3.500089709186855*^9, 3.5000897361468925`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cosh", "[", 
      RowBox[{
       FractionBox["a", "2"], "+", 
       FractionBox[
        RowBox[{"b", " ", "x"}], "2"]}], "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sinh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Cosh", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, {3.500079530261139*^9, 3.500079575451202*^9}, {
   3.5000796205012655`*^9, 3.500079671061336*^9}, {3.5000813766037235`*^9, 
   3.500081376903724*^9}, 3.5000814134937754`*^9, {3.5157846894365525`*^9, 
   3.515784711796584*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}], "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sinh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}], ",", "x"}], "]"}]}], 
     "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"Sinh", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"c", "-", 
      RowBox[{"a", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"d", "-", 
      RowBox[{"b", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"OddQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, {
   3.500077639438492*^9, 3.5000776443384986`*^9}, {3.500079737691429*^9, 
   3.500079771871477*^9}, {3.500079835841567*^9, 3.5000799106916714`*^9}, {
   3.5000799437417173`*^9, 3.500079972731758*^9}, {3.5000800254818325`*^9, 
   3.5000800531018705`*^9}, {3.500080550942568*^9, 3.500080551872569*^9}, {
   3.500081409033769*^9, 3.500081449713826*^9}, {3.5000816225140676`*^9, 
   3.50008162382407*^9}, 3.5000896736668053`*^9, {3.5157846901765537`*^9, 
   3.515784712736585*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.4978080875027843`*^9, {
   3.500071601450039*^9, 3.500071603130041*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Sinh", "[", 
    RowBox[{"2", " ", "z"}], "]"}], "=", 
   RowBox[{"2", " ", 
    RowBox[{"Sinh", "[", "z", "]"}], " ", 
    RowBox[{"Cosh", "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497727769376384*^9, 3.4978080875027843`*^9, {
   3.500071601450039*^9, 3.5000716499501066`*^9}, {3.5157846908865547`*^9, 
   3.5157847129665856`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 " and ",
 Cell[BoxData["u"]],
 " is a function of trig functions of ",
 Cell[BoxData[
  RowBox[{
   FractionBox["a", "2"], "+", 
   FractionBox[
    RowBox[{"b", " ", "x"}], "2"]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, 3.497639786159789*^9, {3.4976636687943316`*^9, 
   3.497663674238741*^9}, 3.500065336645051*^9, {3.5000653831351156`*^9, 
   3.5000653931651297`*^9}, {3.5000654310051827`*^9, 3.500065453315214*^9}, {
   3.500069687963237*^9, 3.5000696889460382`*^9}, 3.5000699834433556`*^9, {
   3.500073956083335*^9, 3.5000740306834393`*^9}, {3.500074095863531*^9, 
   3.5000741212435665`*^9}, {3.5000741522836094`*^9, 
   3.5000741751536417`*^9}, {3.500074221103706*^9, 3.500074221103706*^9}, 
   3.500074503914102*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"Sinh", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox["2", "n"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox[
      RowBox[{"Cosh", "[", 
       RowBox[{
        FractionBox["a", "2"], "+", 
        FractionBox[
         RowBox[{"b", " ", "x"}], "2"]}], "]"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", 
       RowBox[{
        FractionBox["a", "2"], "+", 
        FractionBox[
         RowBox[{"b", " ", "x"}], "2"]}], "]"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, {
   3.4976637183712187`*^9, 3.4976637616924944`*^9}, {3.5000653173450236`*^9, 
   3.500065324625034*^9}, {3.5000653616850853`*^9, 3.500065367505094*^9}, 
   3.5000654791452503`*^9, {3.5000694620376396`*^9, 3.5000695288585577`*^9}, {
   3.500069754013753*^9, 3.500069772031784*^9}, {3.500069828737884*^9, 
   3.500069930574863*^9}, {3.5000700029901905`*^9, 3.500070007950999*^9}, {
   3.500070067407891*^9, 3.5000700989979353`*^9}, 3.5000701914680643`*^9, {
   3.500073895743251*^9, 3.5000739445333185`*^9}, {3.500074199563676*^9, 
   3.500074208003688*^9}, {3.5000744727540584`*^9, 3.500074501224098*^9}, {
   3.5157846914565554`*^9, 3.515784713416586*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"2", "^", "n"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"Cosh", "[", 
          RowBox[{
           RowBox[{"a", "/", "2"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", "n"}], "*", 
        RowBox[{
         RowBox[{"Sinh", "[", 
          RowBox[{
           RowBox[{"a", "/", "2"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "^", "n"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "/", "2"}], "+", 
      RowBox[{"b", "*", 
       RowBox[{"x", "/", "2"}]}], "-", 
      RowBox[{"FunctionOfHyperbolic", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497663376917819*^9, 3.4976636476250944`*^9, 
   3.500065332175044*^9, 3.500065376815107*^9, 3.500065423255172*^9, {
   3.500069566860224*^9, 3.500069658276385*^9}, {3.5000697782405953`*^9, 
   3.5000697862434096`*^9}, {3.500069950168497*^9, 3.500069992132571*^9}, {
   3.5000701293779774`*^9, 3.5000701415479946`*^9}, 3.5000701855880566`*^9, {
   3.5000702333881235`*^9, 3.5000702407681336`*^9}, 3.500070898259054*^9, {
   3.5000740600034804`*^9, 3.5000740914935246`*^9}, {3.5000742130736947`*^9, 
   3.5000742163036995`*^9}, {3.500074399503956*^9, 3.500074433484003*^9}, {
   3.5000745170941205`*^9, 3.500074525404132*^9}, {3.500074568174192*^9, 
   3.500074670514335*^9}, {3.515784691946556*^9, 3.5157847144065876`*^9}, {
   3.515785142527187*^9, 3.515785150067198*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"Sinh", "[", "v", "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.4978099162653446`*^9, 3.49780992018535*^9}, 
   3.497816868100286*^9, 3.4978178569916706`*^9, 3.497819935984581*^9, 
   3.4990190908357544`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, {3.4978169434003916`*^9, 
   3.497816948440398*^9}, 3.497820003054675*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sinh", "[", "z", "]"}], "2"], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"2", " ", "z"}], "]"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, 
   3.497809962345409*^9, {3.497816982770447*^9, 3.4978170004804716`*^9}, {
   3.4978200170946946`*^9, 3.497820027074709*^9}, {3.4990190908457546`*^9, 
   3.4990190908457546`*^9}, {3.4990191329958134`*^9, 
   3.4990191329958134`*^9}, {3.499043379583236*^9, 3.4990433829528418`*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData["u"]],
 " is a function of hyperbolic functions of ",
 Cell[BoxData[
  RowBox[{"2", " ", "v"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.49781695654041*^9, 3.497816973120433*^9}, {
   3.497817913331749*^9, 3.4978179162117534`*^9}, {3.4978200878947935`*^9, 
   3.497820134594859*^9}, {3.499043363125207*^9, 3.4990433648724103`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"u", " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", "v", "]"}], "2"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{"u", 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     RowBox[{"Cosh", "[", 
      RowBox[{"2", " ", "v"}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.497810010085476*^9, 
   3.497810026705499*^9}, 3.4978168734802933`*^9, 3.497816906020339*^9, {
   3.49781786362168*^9, 3.4978178842317085`*^9}, {3.4978200683047667`*^9, 
   3.4978200791447816`*^9}, 3.499019090855755*^9, 3.4990191330058136`*^9, {
   3.4990434188329053`*^9, 3.4990434232945127`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"Sinh", "[", "v_", "]"}], "^", "2"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"2", "*", "v"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{"FunctionOfHyperbolicQ", "[", 
    RowBox[{"u", ",", 
     RowBox[{"2", "*", "v"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, 
   3.499019090865755*^9, 3.499019133015814*^9, 3.499043357711998*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"Cosh", "[", "v_", "]"}], "^", "2"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{"Cosh", "[", 
          RowBox[{"2", "*", "v"}], "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{"FunctionOfHyperbolicQ", "[", 
    RowBox[{"u", ",", 
     RowBox[{"2", "*", "v"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.49780993428537*^9, 
   3.497816883330307*^9, 3.497817840791648*^9, 3.497819954544607*^9, {
   3.4979216151821833`*^9, 3.4979216453682365`*^9}, 3.4979859877957735`*^9, {
   3.4991141335318923`*^9, 3.4991141335318923`*^9}, 3.499127084476615*^9, {
   3.5156112137877336`*^9, 3.5156112196740704`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Hyperbolic Sine Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1401, 29, 118, "Title"],
Cell[1971, 53, 349, 5, 354, "Subsubsection"],
Cell[2323, 60, 1109, 30, 418, "Subsubsection"],
Cell[3435, 92, 1426, 28, 261, "Subsubsection"],
Cell[4864, 122, 1649, 43, 628, "Subsubtitle"],
Cell[6516, 167, 771, 11, 354, "Subsubsection"],
Cell[7290, 180, 1978, 56, 1079, "Code"],
Cell[9271, 238, 89, 2, 354, "Subsubsection"],
Cell[9363, 242, 422, 7, 243, "Subsubsection"],
Cell[9788, 251, 1163, 31, 418, "Subsubsection"],
Cell[10954, 284, 1201, 33, 550, "Subsubsection"],
Cell[12158, 319, 1425, 28, 394, "Subsubsection"],
Cell[13586, 349, 2709, 68, 926, "Subsubtitle"],
Cell[16298, 419, 771, 11, 354, "Subsubsection"],
Cell[17072, 432, 2877, 82, 1345, "Code"],
Cell[19952, 516, 89, 2, 354, "Subsubsection"],
Cell[20044, 520, 401, 6, 243, "Subsubsection"],
Cell[20448, 528, 1369, 41, 432, "Subsubsection"],
Cell[21820, 571, 1250, 23, 261, "Subsubsection"],
Cell[23073, 596, 2736, 69, 655, "Subsubtitle"],
Cell[25812, 667, 771, 11, 354, "Subsubsection"],
Cell[26586, 680, 2572, 74, 1345, "Code"],
Cell[29161, 756, 89, 2, 354, "Subsubsection"],
Cell[29253, 760, 401, 6, 243, "Subsubsection"],
Cell[29657, 768, 1060, 26, 442, "Subsubsection"],
Cell[30720, 796, 1491, 28, 354, "Subsubsection"],
Cell[32214, 826, 2453, 58, 683, "Subsubtitle"],
Cell[34670, 886, 771, 11, 354, "Subsubsection"],
Cell[35444, 899, 2611, 71, 1079, "Code"],
Cell[38058, 972, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[38139, 978, 1427, 30, 80, "Title"],
Cell[39569, 1010, 349, 5, 354, "Subsubsection"],
Cell[39921, 1017, 797, 18, 404, "Subsubsection"],
Cell[40721, 1037, 1378, 26, 261, "Subsubsection"],
Cell[42102, 1065, 1621, 40, 618, "Subsubtitle"],
Cell[43726, 1107, 771, 11, 354, "Subsubsection"],
Cell[44500, 1120, 1855, 51, 1079, "Code"],
Cell[46358, 1173, 89, 2, 354, "Subsubsection"],
Cell[46450, 1177, 349, 5, 243, "Subsubsection"],
Cell[46802, 1184, 929, 21, 404, "Subsubsection"],
Cell[47734, 1207, 1406, 27, 261, "Subsubsection"],
Cell[49143, 1236, 1701, 42, 618, "Subsubtitle"],
Cell[50847, 1280, 771, 11, 354, "Subsubsection"],
Cell[51621, 1293, 1905, 52, 1079, "Code"],
Cell[53529, 1347, 89, 2, 354, "Subsubsection"],
Cell[53621, 1351, 349, 5, 243, "Subsubsection"],
Cell[53973, 1358, 797, 18, 404, "Subsubsection"],
Cell[54773, 1378, 905, 22, 510, "Subsubsection"],
Cell[55681, 1402, 1426, 27, 565, "Subsubsection"],
Cell[57110, 1431, 2092, 56, 1296, "Subsubtitle"],
Cell[59205, 1489, 771, 11, 510, "Subsubsection"],
Cell[59979, 1502, 2406, 68, 1525, "Code"],
Cell[62388, 1572, 89, 2, 510, "Subsubsection"],
Cell[62480, 1576, 349, 5, 365, "Subsubsection"],
Cell[62832, 1583, 893, 20, 585, "Subsubsection"],
Cell[63728, 1605, 929, 22, 737, "Subsubsection"],
Cell[64660, 1629, 1480, 28, 565, "Subsubsection"],
Cell[66143, 1659, 2164, 57, 1296, "Subsubtitle"],
Cell[68310, 1718, 771, 11, 510, "Subsubsection"],
Cell[69084, 1731, 2451, 70, 1525, "Code"],
Cell[71538, 1803, 89, 2, 510, "Subsubsection"],
Cell[71630, 1807, 401, 6, 365, "Subsubsection"],
Cell[72034, 1815, 1319, 40, 606, "Subsubsection"],
Cell[73356, 1857, 1200, 22, 377, "Subsubsection"],
Cell[74559, 1881, 2736, 69, 926, "Subsubtitle"],
Cell[77298, 1952, 771, 11, 354, "Subsubsection"],
Cell[78072, 1965, 2650, 75, 1345, "Code"],
Cell[80725, 2042, 89, 2, 354, "Subsubsection"],
Cell[80817, 2046, 401, 6, 243, "Subsubsection"],
Cell[81221, 2054, 1133, 26, 442, "Subsubsection"],
Cell[82357, 2082, 1499, 28, 354, "Subsubsection"],
Cell[83859, 2112, 2476, 58, 683, "Subsubtitle"],
Cell[86338, 2172, 771, 11, 354, "Subsubsection"],
Cell[87112, 2185, 2630, 70, 1079, "Code"],
Cell[89745, 2257, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[89826, 2263, 1484, 30, 80, "Title"],
Cell[91313, 2295, 380, 5, 130, "Subsubsection"],
Cell[91696, 2302, 771, 20, 138, "Subsubsection"],
Cell[92470, 2324, 597, 10, 90, "Subsubsection"],
Cell[93070, 2336, 1300, 24, 96, "Subsubsection"],
Cell[94373, 2362, 2103, 46, 222, "Subsubtitle"],
Cell[96479, 2410, 771, 11, 130, "Subsubsection"],
Cell[97253, 2423, 1966, 50, 394, "Code"],
Cell[99222, 2475, 755, 19, 174, "Subsubsection"],
Cell[99980, 2496, 2019, 51, 394, "Code"],
Cell[102002, 2549, 89, 2, 130, "Subsubsection"],
Cell[102094, 2553, 349, 5, 90, "Subsubsection"],
Cell[102446, 2560, 773, 20, 138, "Subsubsection"],
Cell[103222, 2582, 597, 10, 90, "Subsubsection"],
Cell[103822, 2594, 1347, 27, 96, "Subsubsection"],
Cell[105172, 2623, 2219, 49, 222, "Subsubtitle"],
Cell[107394, 2674, 771, 11, 130, "Subsubsection"],
Cell[108168, 2687, 2215, 61, 394, "Code"],
Cell[110386, 2750, 759, 19, 174, "Subsubsection"],
Cell[111148, 2771, 2346, 63, 394, "Code"],
Cell[113497, 2836, 44, 1, 11, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[113578, 2842, 1159, 24, 80, "Title"],
Cell[114740, 2868, 194, 3, 354, "Subsubsection"],
Cell[114937, 2873, 734, 19, 432, "Subsubsection"],
Cell[115674, 2894, 518, 9, 261, "Subsubsection"],
Cell[116195, 2905, 763, 11, 243, "Subsubsection"],
Cell[116961, 2918, 1218, 32, 1373, "Subsubtitle"],
Cell[118182, 2952, 771, 11, 354, "Subsubsection"],
Cell[118956, 2965, 1149, 32, 1079, "Code"],
Cell[120108, 2999, 706, 17, 530, "Subsubsection"],
Cell[120817, 3018, 1168, 32, 1079, "Code"],
Cell[121988, 3052, 89, 2, 354, "Subsubsection"],
Cell[122080, 3056, 223, 3, 243, "Subsubsection"],
Cell[122306, 3061, 640, 17, 404, "Subsubsection"],
Cell[122949, 3080, 1096, 22, 261, "Subsubsection"],
Cell[124048, 3104, 2011, 46, 606, "Subsubtitle"],
Cell[126062, 3152, 771, 11, 354, "Subsubsection"],
Cell[126836, 3165, 1583, 47, 1345, "Code"],
Cell[128422, 3214, 1630, 48, 1451, "Code"],
Cell[130055, 3264, 89, 2, 354, "Subsubsection"],
Cell[130147, 3268, 250, 4, 243, "Subsubsection"],
Cell[130400, 3274, 443, 8, 243, "Subsubsection"],
Cell[130846, 3284, 1091, 20, 261, "Subsubsection"],
Cell[131940, 3306, 1857, 41, 550, "Subsubtitle"],
Cell[133800, 3349, 771, 11, 354, "Subsubsection"],
Cell[134574, 3362, 1490, 41, 1345, "Code"],
Cell[136067, 3405, 1542, 42, 1451, "Code"],
Cell[137612, 3449, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[137693, 3455, 1215, 25, 80, "Title"],
Cell[138911, 3482, 194, 3, 354, "Subsubsection"],
Cell[139108, 3487, 566, 14, 377, "Subsubsection"],
Cell[139677, 3503, 763, 11, 243, "Subsubsection"],
Cell[140443, 3516, 1086, 25, 664, "Subsubtitle"],
Cell[141532, 3543, 771, 11, 354, "Subsubsection"],
Cell[142306, 3556, 940, 24, 1079, "Code"],
Cell[143249, 3582, 620, 15, 475, "Subsubsection"],
Cell[143872, 3599, 1018, 25, 1079, "Code"],
Cell[144893, 3626, 89, 2, 354, "Subsubsection"],
Cell[144985, 3630, 223, 3, 243, "Subsubsection"],
Cell[145211, 3635, 673, 18, 261, "Subsubsection"],
Cell[145887, 3655, 815, 11, 243, "Subsubsection"],
Cell[146705, 3668, 2015, 46, 664, "Subsubtitle"],
Cell[148723, 3716, 771, 11, 354, "Subsubsection"],
Cell[149497, 3729, 1529, 42, 1345, "Code"],
Cell[151029, 3773, 1581, 43, 1451, "Code"],
Cell[152613, 3818, 89, 2, 354, "Subsubsection"],
Cell[152705, 3822, 273, 4, 243, "Subsubsection"],
Cell[152981, 3828, 250, 4, 243, "Subsubsection"],
Cell[153234, 3834, 1015, 28, 473, "Subsubsection"],
Cell[154252, 3864, 1113, 20, 261, "Subsubsection"],
Cell[155368, 3886, 2244, 52, 683, "Subsubtitle"],
Cell[157615, 3940, 771, 11, 354, "Subsubsection"],
Cell[158389, 3953, 1997, 56, 1345, "Code"],
Cell[160389, 4011, 297, 4, 354, "Subsubsection"],
Cell[160689, 4017, 2050, 57, 1345, "Code"],
Cell[162742, 4076, 89, 2, 354, "Subsubsection"],
Cell[162834, 4080, 285, 4, 243, "Subsubsection"],
Cell[163122, 4086, 372, 5, 243, "Subsubsection"],
Cell[163497, 4093, 1622, 35, 261, "Subsubsection"],
Cell[165122, 4130, 2168, 51, 683, "Subsubtitle"],
Cell[167293, 4183, 771, 11, 354, "Subsubsection"],
Cell[168067, 4196, 2420, 70, 1345, "Code"],
Cell[170490, 4268, 309, 5, 354, "Subsubsection"],
Cell[170802, 4275, 2470, 70, 1345, "Code"],
Cell[173275, 4347, 89, 2, 354, "Subsubsection"],
Cell[173367, 4351, 295, 4, 243, "Subsubsection"],
Cell[173665, 4357, 710, 18, 404, "Subsubsection"],
Cell[174378, 4377, 1594, 33, 261, "Subsubsection"],
Cell[175975, 4412, 2133, 49, 606, "Subsubtitle"],
Cell[178111, 4463, 771, 11, 354, "Subsubsection"],
Cell[178885, 4476, 2158, 61, 1605, "Code"],
Cell[181046, 4539, 2232, 62, 1712, "Code"],
Cell[183281, 4603, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[183362, 4609, 1266, 26, 80, "Title"],
Cell[184631, 4637, 224, 3, 354, "Subsubsection"],
Cell[184858, 4642, 1198, 24, 261, "Subsubsection"],
Cell[186059, 4668, 2161, 57, 713, "Subsubtitle"],
Cell[188223, 4727, 771, 11, 354, "Subsubsection"],
Cell[188997, 4740, 2543, 70, 1345, "Code"],
Cell[191543, 4812, 2465, 69, 1451, "Code"],
Cell[194011, 4883, 89, 2, 354, "Subsubsection"],
Cell[194103, 4887, 582, 14, 261, "Subsubsection"],
Cell[194688, 4903, 1211, 23, 261, "Subsubsection"],
Cell[195902, 4928, 2851, 71, 720, "Subsubtitle"],
Cell[198756, 5001, 771, 11, 354, "Subsubsection"],
Cell[199530, 5014, 2714, 78, 1605, "Code"],
Cell[202247, 5094, 630, 13, 365, "Subsubsection"],
Cell[202880, 5109, 2766, 79, 1605, "Code"],
Cell[205649, 5190, 89, 2, 354, "Subsubsection"],
Cell[205741, 5194, 285, 4, 243, "Subsubsection"],
Cell[206029, 5200, 1331, 26, 261, "Subsubsection"],
Cell[207363, 5228, 3856, 101, 1355, "Subsubtitle"],
Cell[211222, 5331, 771, 11, 354, "Subsubsection"],
Cell[211996, 5344, 3888, 114, 1873, "Code"],
Cell[215887, 5460, 311, 5, 354, "Subsubsection"],
Cell[216201, 5467, 3938, 115, 1873, "Code"],
Cell[220142, 5584, 89, 2, 354, "Subsubsection"],
Cell[220234, 5588, 734, 16, 261, "Subsubsection"],
Cell[220971, 5606, 1426, 28, 261, "Subsubsection"],
Cell[222400, 5636, 3220, 81, 1250, "Subsubtitle"],
Cell[225623, 5719, 771, 11, 354, "Subsubsection"],
Cell[226397, 5732, 3104, 92, 1605, "Code"],
Cell[229504, 5826, 689, 16, 365, "Subsubsection"],
Cell[230196, 5844, 3200, 94, 1605, "Code"],
Cell[233399, 5940, 89, 2, 354, "Subsubsection"],
Cell[233491, 5944, 360, 5, 243, "Subsubsection"],
Cell[233854, 5951, 1540, 31, 261, "Subsubsection"],
Cell[235397, 5984, 4087, 111, 1355, "Subsubtitle"],
Cell[239487, 6097, 771, 11, 354, "Subsubsection"],
Cell[240261, 6110, 4466, 131, 1873, "Code"],
Cell[244730, 6243, 412, 6, 354, "Subsubsection"],
Cell[245145, 6251, 4566, 133, 1873, "Code"],
Cell[249714, 6386, 89, 2, 354, "Subsubsection"],
Cell[249806, 6390, 387, 6, 243, "Subsubsection"],
Cell[250196, 6398, 1584, 30, 261, "Subsubsection"],
Cell[251783, 6430, 4052, 109, 1374, "Subsubtitle"],
Cell[255838, 6541, 771, 11, 354, "Subsubsection"],
Cell[256612, 6554, 4360, 127, 1873, "Code"],
Cell[260975, 6683, 463, 7, 354, "Subsubsection"],
Cell[261441, 6692, 4416, 128, 1873, "Code"],
Cell[265860, 6822, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[265941, 6828, 1384, 30, 80, "Title"],
Cell[267328, 6860, 312, 4, 354, "Subsubsection"],
Cell[267643, 6866, 1206, 21, 261, "Subsubsection"],
Cell[268852, 6889, 1909, 48, 606, "Subsubtitle"],
Cell[270764, 6939, 771, 11, 354, "Subsubsection"],
Cell[271538, 6952, 1990, 54, 1079, "Code"],
Cell[273531, 7008, 2070, 55, 1187, "Code"],
Cell[275604, 7065, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[275685, 7071, 1217, 25, 80, "Title"],
Cell[276905, 7098, 256, 4, 354, "Subsubsection"],
Cell[277164, 7104, 759, 25, 442, "Subsubsection"],
Cell[277926, 7131, 968, 19, 261, "Subsubsection"],
Cell[278897, 7152, 1272, 31, 662, "Subsubtitle"],
Cell[280172, 7185, 771, 11, 354, "Subsubsection"],
Cell[280946, 7198, 1272, 37, 1079, "Code"],
Cell[282221, 7237, 1342, 38, 1187, "Code"],
Cell[283566, 7277, 89, 2, 354, "Subsubsection"],
Cell[283658, 7281, 223, 3, 243, "Subsubsection"],
Cell[283884, 7286, 618, 16, 404, "Subsubsection"],
Cell[284505, 7304, 1030, 20, 261, "Subsubsection"],
Cell[285538, 7326, 2123, 49, 606, "Subsubtitle"],
Cell[287664, 7377, 771, 11, 354, "Subsubsection"],
Cell[288438, 7390, 1830, 53, 1345, "Code"],
Cell[290271, 7445, 1906, 54, 1451, "Code"],
Cell[292180, 7501, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[292261, 7507, 1354, 29, 80, "Title"],
Cell[293618, 7538, 1016, 20, 365, "Subsubsection"],
Cell[294637, 7560, 1350, 33, 683, "Subsubtitle"],
Cell[295990, 7595, 771, 11, 354, "Subsubsection"],
Cell[296764, 7608, 1380, 39, 1079, "Code"],
Cell[298147, 7649, 1458, 40, 1187, "Code"],
Cell[299608, 7691, 89, 2, 354, "Subsubsection"],
Cell[299700, 7695, 1074, 21, 261, "Subsubsection"],
Cell[300777, 7718, 2275, 54, 683, "Subsubtitle"],
Cell[303055, 7774, 771, 11, 354, "Subsubsection"],
Cell[303829, 7787, 2033, 58, 1345, "Code"],
Cell[305865, 7847, 2088, 59, 1451, "Code"],
Cell[307956, 7908, 89, 2, 354, "Subsubsection"],
Cell[308048, 7912, 1203, 24, 261, "Subsubsection"],
Cell[309254, 7938, 2937, 72, 1210, "Subsubtitle"],
Cell[312194, 8012, 771, 11, 354, "Subsubsection"],
Cell[312968, 8025, 2607, 75, 1345, "Code"],
Cell[315578, 8102, 2630, 75, 1451, "Code"],
Cell[318211, 8179, 89, 2, 354, "Subsubsection"],
Cell[318303, 8183, 1260, 24, 261, "Subsubsection"],
Cell[319566, 8209, 3442, 89, 1318, "Subsubtitle"],
Cell[323011, 8300, 771, 11, 354, "Subsubsection"],
Cell[323785, 8313, 3388, 99, 1605, "Code"],
Cell[327176, 8414, 3421, 100, 1712, "Code"],
Cell[330600, 8516, 89, 2, 354, "Subsubsection"],
Cell[330692, 8520, 1272, 25, 261, "Subsubsection"],
Cell[331967, 8547, 3024, 74, 1241, "Subsubtitle"],
Cell[334994, 8623, 771, 11, 354, "Subsubsection"],
Cell[335768, 8636, 2680, 78, 1345, "Code"],
Cell[338451, 8716, 2740, 80, 1451, "Code"],
Cell[341194, 8798, 89, 2, 354, "Subsubsection"],
Cell[341286, 8802, 1330, 26, 261, "Subsubsection"],
Cell[342619, 8830, 3620, 95, 1320, "Subsubtitle"],
Cell[346242, 8927, 771, 11, 354, "Subsubsection"],
Cell[347016, 8940, 3604, 106, 1605, "Code"],
Cell[350623, 9048, 3638, 107, 1712, "Code"],
Cell[354264, 9157, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[354345, 9163, 1302, 27, 80, "Title"],
Cell[355650, 9192, 993, 13, 67, "Subsubsection"],
Cell[356646, 9207, 1547, 36, 81, "Subsubsection"],
Cell[358196, 9245, 938, 13, 47, "Subsubsection"],
Cell[359137, 9260, 1752, 42, 145, "Subsubtitle"],
Cell[360892, 9304, 771, 11, 67, "Subsubsection"],
Cell[361666, 9317, 1518, 43, 202, "Code"],
Cell[363187, 9362, 1571, 36, 100, "Subsubsection"],
Cell[364761, 9400, 1590, 44, 202, "Code"],
Cell[366354, 9446, 89, 2, 67, "Subsubsection"],
Cell[366446, 9450, 1102, 22, 50, "Subsubsection"],
Cell[367551, 9474, 1864, 49, 130, "Subsubtitle"],
Cell[369418, 9525, 771, 11, 67, "Subsubsection"],
Cell[370192, 9538, 1908, 55, 251, "Code"],
Cell[372103, 9595, 1953, 56, 271, "Code"],
Cell[374059, 9653, 89, 2, 67, "Subsubsection"],
Cell[374151, 9657, 1045, 14, 47, "Subsubsection"],
Cell[375199, 9673, 1084, 20, 50, "Subsubsection"],
Cell[376286, 9695, 2249, 61, 173, "Subsubtitle"],
Cell[378538, 9758, 771, 11, 67, "Subsubsection"],
Cell[379312, 9771, 2269, 67, 251, "Code"],
Cell[381584, 9840, 2297, 66, 271, "Code"],
Cell[383884, 9908, 89, 2, 67, "Subsubsection"],
Cell[383976, 9912, 1253, 25, 67, "Subsubsection"],
Cell[385232, 9939, 3687, 94, 270, "Subsubtitle"],
Cell[388922, 10035, 771, 11, 67, "Subsubsection"],
Cell[389696, 10048, 3396, 98, 300, "Code"],
Cell[393095, 10148, 3545, 100, 320, "Code"],
Cell[396643, 10250, 89, 2, 67, "Subsubsection"],
Cell[396735, 10254, 1519, 32, 67, "Subsubsection"],
Cell[398257, 10288, 2873, 69, 135, "Subsubtitle"],
Cell[401133, 10359, 771, 11, 67, "Subsubsection"],
Cell[401907, 10372, 2873, 80, 251, "Code"],
Cell[404783, 10454, 3024, 83, 271, "Code"],
Cell[407810, 10539, 89, 2, 67, "Subsubsection"],
Cell[407902, 10543, 1465, 31, 67, "Subsubsection"],
Cell[409370, 10576, 3690, 97, 267, "Subsubtitle"],
Cell[413063, 10675, 771, 11, 67, "Subsubsection"],
Cell[413837, 10688, 3809, 111, 300, "Code"],
Cell[417649, 10801, 3965, 114, 320, "Code"],
Cell[421617, 10917, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[421698, 10923, 1360, 29, 80, "Title"],
Cell[423061, 10954, 1334, 28, 86, "Subsubsection"],
Cell[424398, 10984, 2286, 62, 134, "Subsubtitle"],
Cell[426687, 11048, 771, 11, 67, "Subsubsection"],
Cell[427461, 11061, 2581, 77, 251, "Code"],
Cell[430045, 11140, 2627, 77, 271, "Code"],
Cell[432675, 11219, 89, 2, 67, "Subsubsection"],
Cell[432767, 11223, 1527, 32, 67, "Subsubsection"],
Cell[434297, 11257, 4254, 112, 270, "Subsubtitle"],
Cell[438554, 11371, 771, 11, 67, "Subsubsection"],
Cell[439328, 11384, 4308, 126, 300, "Code"],
Cell[443639, 11512, 4406, 127, 320, "Code"],
Cell[448048, 11641, 89, 2, 67, "Subsubsection"],
Cell[448140, 11645, 1747, 37, 50, "Subsubsection"],
Cell[449890, 11684, 3207, 78, 135, "Subsubtitle"],
Cell[453100, 11764, 771, 11, 67, "Subsubsection"],
Cell[453874, 11777, 3308, 95, 251, "Code"],
Cell[457185, 11874, 3455, 98, 271, "Code"],
Cell[460643, 11974, 89, 2, 67, "Subsubsection"],
Cell[460735, 11978, 1735, 38, 67, "Subsubsection"],
Cell[462473, 12018, 4134, 109, 267, "Subsubtitle"],
Cell[466610, 12129, 771, 11, 67, "Subsubsection"],
Cell[467384, 12142, 4543, 134, 300, "Code"],
Cell[471930, 12278, 4669, 136, 320, "Code"],
Cell[476602, 12416, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[476683, 12422, 1448, 30, 80, "Title"],
Cell[478134, 12454, 1035, 18, 365, "Subsubsection"],
Cell[479172, 12474, 1880, 47, 664, "Subsubtitle"],
Cell[481055, 12523, 771, 11, 354, "Subsubsection"],
Cell[481829, 12536, 1878, 52, 1345, "Code"],
Cell[483710, 12590, 1926, 53, 1451, "Code"],
Cell[485639, 12645, 89, 2, 354, "Subsubsection"],
Cell[485731, 12649, 1087, 19, 261, "Subsubsection"],
Cell[486821, 12670, 3237, 79, 1373, "Subsubtitle"],
Cell[490061, 12751, 771, 11, 354, "Subsubsection"],
Cell[490835, 12764, 2901, 82, 1605, "Code"],
Cell[493739, 12848, 2920, 82, 1712, "Code"],
Cell[496662, 12932, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[496743, 12938, 1506, 32, 80, "Title"],
Cell[498252, 12972, 1184, 22, 365, "Subsubsection"],
Cell[499439, 12996, 2184, 55, 683, "Subsubtitle"],
Cell[501626, 13053, 771, 11, 354, "Subsubsection"],
Cell[502400, 13066, 2409, 65, 1345, "Code"],
Cell[504812, 13133, 2437, 65, 1451, "Code"],
Cell[507252, 13200, 89, 2, 354, "Subsubsection"],
Cell[507344, 13204, 1195, 22, 261, "Subsubsection"],
Cell[508542, 13228, 2947, 76, 1269, "Subsubtitle"],
Cell[511492, 13306, 771, 11, 354, "Subsubsection"],
Cell[512266, 13319, 3240, 90, 1605, "Code"],
Cell[515509, 13411, 3286, 90, 1712, "Code"],
Cell[518798, 13503, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[518879, 13509, 1668, 30, 80, "Title"],
Cell[520550, 13541, 273, 4, 93, "Subsubsection"],
Cell[520826, 13547, 720, 19, 99, "Subsubsection"],
Cell[521549, 13568, 1630, 28, 99, "Subsubsection"],
Cell[523182, 13598, 1972, 51, 162, "Subsubtitle"],
Cell[525157, 13651, 771, 11, 93, "Subsubsection"],
Cell[525931, 13664, 2449, 65, 351, "Code"],
Cell[528383, 13731, 89, 2, 93, "Subsubsection"],
Cell[528475, 13735, 273, 4, 65, "Subsubsection"],
Cell[528751, 13741, 757, 19, 99, "Subsubsection"],
Cell[529511, 13762, 1630, 28, 99, "Subsubsection"],
Cell[531144, 13792, 1979, 51, 162, "Subsubtitle"],
Cell[533126, 13845, 771, 11, 93, "Subsubsection"],
Cell[533900, 13858, 2445, 65, 351, "Code"],
Cell[536348, 13925, 89, 2, 93, "Subsubsection"],
Cell[536440, 13929, 430, 6, 65, "Subsubsection"],
Cell[536873, 13937, 673, 16, 69, "Subsubsection"],
Cell[537549, 13955, 1713, 33, 99, "Subsubsection"],
Cell[539265, 13990, 2479, 50, 159, "Subsubtitle"],
Cell[541747, 14042, 771, 11, 93, "Subsubsection"],
Cell[542521, 14055, 2449, 58, 282, "Code"],
Cell[544973, 14115, 44, 1, 8, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[545054, 14121, 1190, 23, 80, "Title"],
Cell[546247, 14146, 273, 4, 354, "Subsubsection"],
Cell[546523, 14152, 778, 20, 377, "Subsubsection"],
Cell[547304, 14174, 1102, 20, 261, "Subsubsection"],
Cell[548409, 14196, 1388, 33, 606, "Subsubtitle"],
Cell[549800, 14231, 771, 11, 354, "Subsubsection"],
Cell[550574, 14244, 1220, 33, 1345, "Code"],
Cell[551797, 14279, 1335, 34, 1451, "Code"],
Cell[553135, 14315, 44, 1, 27, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}
]
*)

(* End of internal cache information *)
