// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package translate

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opText = "TranslateText"

// TextRequest generates a "aws/request.Request" representing the
// client's request for the Text operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Text for more information on using the Text
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TextRequest method.
//    req, resp := client.TextRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/Text
func (c *Translate) TextRequest(input *TextInput) (req *request.Request, output *TextOutput) {
	op := &request.Operation{
		Name:       opText,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TextInput{}
	}

	output = &TextOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Text API operation for Amazon Translate.
//
// Translates input text from the source language to the target language. You
// can translate between English (en) and one of the following languages, or
// between one of the following languages and English.
//
//    * Arabic (ar)
//
//    * Chinese (Simplified) (zh)
//
//    * French (fr)
//
//    * German (de)
//
//    * Portuguese (pt)
//
//    * Spanish (es)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Translate's
// API operation Text for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//   The request is invalid.
//
//   * ErrCodeTextSizeLimitExceededException "TextSizeLimitExceededException"
//   The size of the input text exceeds the length constraint for the Text field.
//   Try again with a shorter text.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ErrCodeUnsupportedLanguagePairException "UnsupportedLanguagePairException"
//   Amazon Translate cannot translate input text in the source language into
//   this target language. For more information, see how-to-error-msg.
//
//   * ErrCodeInternalServerException "InternalServerException"
//   An internal server error occurred. Retry your request.
//
//   * ErrCodeServiceUnavailableException "ServiceUnavailableException"
//   Amazon Translate is unavailable. Retry your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/Text
func (c *Translate) Text(input *TextInput) (*TextOutput, error) {
	req, out := c.TextRequest(input)
	return out, req.Send()
}

// TextWithContext is the same as Text with the addition of
// the ability to pass a context and additional request options.
//
// See Text for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Translate) TextWithContext(ctx aws.Context, input *TextInput, opts ...request.Option) (*TextOutput, error) {
	req, out := c.TextRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type TextInput struct {
	_ struct{} `type:"structure"`

	// One of the supported language codes for the source text. If the TargetLanguageCode
	// is not "en", the SourceLanguageCode must be "en".
	//
	// SourceLanguageCode is a required field
	SourceLanguageCode *string `min:"2" type:"string" required:"true"`

	// One of the supported language codes for the target text. If the SourceLanguageCode
	// is not "en", the TargetLanguageCode must be "en".
	//
	// TargetLanguageCode is a required field
	TargetLanguageCode *string `min:"2" type:"string" required:"true"`

	// The text to translate.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TextInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TextInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TextInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TextInput"}
	if s.SourceLanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceLanguageCode"))
	}
	if s.SourceLanguageCode != nil && len(*s.SourceLanguageCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SourceLanguageCode", 2))
	}
	if s.TargetLanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetLanguageCode"))
	}
	if s.TargetLanguageCode != nil && len(*s.TargetLanguageCode) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("TargetLanguageCode", 2))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceLanguageCode sets the SourceLanguageCode field's value.
func (s *TextInput) SetSourceLanguageCode(v string) *TextInput {
	s.SourceLanguageCode = &v
	return s
}

// SetTargetLanguageCode sets the TargetLanguageCode field's value.
func (s *TextInput) SetTargetLanguageCode(v string) *TextInput {
	s.TargetLanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *TextInput) SetText(v string) *TextInput {
	s.Text = &v
	return s
}

type TextOutput struct {
	_ struct{} `type:"structure"`

	// The language code for the language of the input text.
	//
	// SourceLanguageCode is a required field
	SourceLanguageCode *string `min:"2" type:"string" required:"true"`

	// The language code for the language of the translated text.
	//
	// TargetLanguageCode is a required field
	TargetLanguageCode *string `min:"2" type:"string" required:"true"`

	// The text translated into the target language.
	//
	// TranslatedText is a required field
	TranslatedText *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TextOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TextOutput) GoString() string {
	return s.String()
}

// SetSourceLanguageCode sets the SourceLanguageCode field's value.
func (s *TextOutput) SetSourceLanguageCode(v string) *TextOutput {
	s.SourceLanguageCode = &v
	return s
}

// SetTargetLanguageCode sets the TargetLanguageCode field's value.
func (s *TextOutput) SetTargetLanguageCode(v string) *TextOutput {
	s.TargetLanguageCode = &v
	return s
}

// SetTranslatedText sets the TranslatedText field's value.
func (s *TextOutput) SetTranslatedText(v string) *TextOutput {
	s.TranslatedText = &v
	return s
}
