// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateApp = "CreateApp"

// CreateAppRequest generates a "aws/request.Request" representing the
// client's request for the CreateApp operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApp for more information on using the CreateApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAppRequest method.
//    req, resp := client.CreateAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateApp
func (c *Pinpoint) CreateAppRequest(input *CreateAppInput) (req *request.Request, output *CreateAppOutput) {
	op := &request.Operation{
		Name:       opCreateApp,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps",
	}

	if input == nil {
		input = &CreateAppInput{}
	}

	output = &CreateAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApp API operation for Amazon Pinpoint.
//
// Creates or updates an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateApp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateApp
func (c *Pinpoint) CreateApp(input *CreateAppInput) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	return out, req.Send()
}

// CreateAppWithContext is the same as CreateApp with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateAppWithContext(ctx aws.Context, input *CreateAppInput, opts ...request.Option) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCampaign = "CreateCampaign"

// CreateCampaignRequest generates a "aws/request.Request" representing the
// client's request for the CreateCampaign operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCampaign for more information on using the CreateCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCampaignRequest method.
//    req, resp := client.CreateCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateCampaign
func (c *Pinpoint) CreateCampaignRequest(input *CreateCampaignInput) (req *request.Request, output *CreateCampaignOutput) {
	op := &request.Operation{
		Name:       opCreateCampaign,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/campaigns",
	}

	if input == nil {
		input = &CreateCampaignInput{}
	}

	output = &CreateCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCampaign API operation for Amazon Pinpoint.
//
// Creates or updates a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateCampaign for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateCampaign
func (c *Pinpoint) CreateCampaign(input *CreateCampaignInput) (*CreateCampaignOutput, error) {
	req, out := c.CreateCampaignRequest(input)
	return out, req.Send()
}

// CreateCampaignWithContext is the same as CreateCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateCampaignWithContext(ctx aws.Context, input *CreateCampaignInput, opts ...request.Option) (*CreateCampaignOutput, error) {
	req, out := c.CreateCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateExportJob = "CreateExportJob"

// CreateExportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateExportJob operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateExportJob for more information on using the CreateExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateExportJobRequest method.
//    req, resp := client.CreateExportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateExportJob
func (c *Pinpoint) CreateExportJobRequest(input *CreateExportJobInput) (req *request.Request, output *CreateExportJobOutput) {
	op := &request.Operation{
		Name:       opCreateExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/jobs/export",
	}

	if input == nil {
		input = &CreateExportJobInput{}
	}

	output = &CreateExportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateExportJob API operation for Amazon Pinpoint.
//
// Creates an export job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateExportJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateExportJob
func (c *Pinpoint) CreateExportJob(input *CreateExportJobInput) (*CreateExportJobOutput, error) {
	req, out := c.CreateExportJobRequest(input)
	return out, req.Send()
}

// CreateExportJobWithContext is the same as CreateExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateExportJobWithContext(ctx aws.Context, input *CreateExportJobInput, opts ...request.Option) (*CreateExportJobOutput, error) {
	req, out := c.CreateExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateImportJob = "CreateImportJob"

// CreateImportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateImportJob operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateImportJob for more information on using the CreateImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateImportJobRequest method.
//    req, resp := client.CreateImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateImportJob
func (c *Pinpoint) CreateImportJobRequest(input *CreateImportJobInput) (req *request.Request, output *CreateImportJobOutput) {
	op := &request.Operation{
		Name:       opCreateImportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/jobs/import",
	}

	if input == nil {
		input = &CreateImportJobInput{}
	}

	output = &CreateImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateImportJob API operation for Amazon Pinpoint.
//
// Creates or updates an import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateImportJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateImportJob
func (c *Pinpoint) CreateImportJob(input *CreateImportJobInput) (*CreateImportJobOutput, error) {
	req, out := c.CreateImportJobRequest(input)
	return out, req.Send()
}

// CreateImportJobWithContext is the same as CreateImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateImportJobWithContext(ctx aws.Context, input *CreateImportJobInput, opts ...request.Option) (*CreateImportJobOutput, error) {
	req, out := c.CreateImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSegment = "CreateSegment"

// CreateSegmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateSegment operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSegment for more information on using the CreateSegment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSegmentRequest method.
//    req, resp := client.CreateSegmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSegment
func (c *Pinpoint) CreateSegmentRequest(input *CreateSegmentInput) (req *request.Request, output *CreateSegmentOutput) {
	op := &request.Operation{
		Name:       opCreateSegment,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/segments",
	}

	if input == nil {
		input = &CreateSegmentInput{}
	}

	output = &CreateSegmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSegment API operation for Amazon Pinpoint.
//
// Used to create or update a segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation CreateSegment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSegment
func (c *Pinpoint) CreateSegment(input *CreateSegmentInput) (*CreateSegmentOutput, error) {
	req, out := c.CreateSegmentRequest(input)
	return out, req.Send()
}

// CreateSegmentWithContext is the same as CreateSegment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSegment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) CreateSegmentWithContext(ctx aws.Context, input *CreateSegmentInput, opts ...request.Option) (*CreateSegmentOutput, error) {
	req, out := c.CreateSegmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAdmChannel = "DeleteAdmChannel"

// DeleteAdmChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAdmChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAdmChannel for more information on using the DeleteAdmChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAdmChannelRequest method.
//    req, resp := client.DeleteAdmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteAdmChannel
func (c *Pinpoint) DeleteAdmChannelRequest(input *DeleteAdmChannelInput) (req *request.Request, output *DeleteAdmChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteAdmChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/adm",
	}

	if input == nil {
		input = &DeleteAdmChannelInput{}
	}

	output = &DeleteAdmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAdmChannel API operation for Amazon Pinpoint.
//
// Delete an ADM channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteAdmChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteAdmChannel
func (c *Pinpoint) DeleteAdmChannel(input *DeleteAdmChannelInput) (*DeleteAdmChannelOutput, error) {
	req, out := c.DeleteAdmChannelRequest(input)
	return out, req.Send()
}

// DeleteAdmChannelWithContext is the same as DeleteAdmChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAdmChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteAdmChannelWithContext(ctx aws.Context, input *DeleteAdmChannelInput, opts ...request.Option) (*DeleteAdmChannelOutput, error) {
	req, out := c.DeleteAdmChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApnsChannel = "DeleteApnsChannel"

// DeleteApnsChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApnsChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApnsChannel for more information on using the DeleteApnsChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApnsChannelRequest method.
//    req, resp := client.DeleteApnsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsChannel
func (c *Pinpoint) DeleteApnsChannelRequest(input *DeleteApnsChannelInput) (req *request.Request, output *DeleteApnsChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteApnsChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns",
	}

	if input == nil {
		input = &DeleteApnsChannelInput{}
	}

	output = &DeleteApnsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApnsChannel API operation for Amazon Pinpoint.
//
// Deletes the APNs channel for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteApnsChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsChannel
func (c *Pinpoint) DeleteApnsChannel(input *DeleteApnsChannelInput) (*DeleteApnsChannelOutput, error) {
	req, out := c.DeleteApnsChannelRequest(input)
	return out, req.Send()
}

// DeleteApnsChannelWithContext is the same as DeleteApnsChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApnsChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteApnsChannelWithContext(ctx aws.Context, input *DeleteApnsChannelInput, opts ...request.Option) (*DeleteApnsChannelOutput, error) {
	req, out := c.DeleteApnsChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApnsSandboxChannel = "DeleteApnsSandboxChannel"

// DeleteApnsSandboxChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApnsSandboxChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApnsSandboxChannel for more information on using the DeleteApnsSandboxChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApnsSandboxChannelRequest method.
//    req, resp := client.DeleteApnsSandboxChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsSandboxChannel
func (c *Pinpoint) DeleteApnsSandboxChannelRequest(input *DeleteApnsSandboxChannelInput) (req *request.Request, output *DeleteApnsSandboxChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteApnsSandboxChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_sandbox",
	}

	if input == nil {
		input = &DeleteApnsSandboxChannelInput{}
	}

	output = &DeleteApnsSandboxChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApnsSandboxChannel API operation for Amazon Pinpoint.
//
// Delete an APNS sandbox channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteApnsSandboxChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsSandboxChannel
func (c *Pinpoint) DeleteApnsSandboxChannel(input *DeleteApnsSandboxChannelInput) (*DeleteApnsSandboxChannelOutput, error) {
	req, out := c.DeleteApnsSandboxChannelRequest(input)
	return out, req.Send()
}

// DeleteApnsSandboxChannelWithContext is the same as DeleteApnsSandboxChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApnsSandboxChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteApnsSandboxChannelWithContext(ctx aws.Context, input *DeleteApnsSandboxChannelInput, opts ...request.Option) (*DeleteApnsSandboxChannelOutput, error) {
	req, out := c.DeleteApnsSandboxChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApnsVoipChannel = "DeleteApnsVoipChannel"

// DeleteApnsVoipChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApnsVoipChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApnsVoipChannel for more information on using the DeleteApnsVoipChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApnsVoipChannelRequest method.
//    req, resp := client.DeleteApnsVoipChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipChannel
func (c *Pinpoint) DeleteApnsVoipChannelRequest(input *DeleteApnsVoipChannelInput) (req *request.Request, output *DeleteApnsVoipChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteApnsVoipChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip",
	}

	if input == nil {
		input = &DeleteApnsVoipChannelInput{}
	}

	output = &DeleteApnsVoipChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApnsVoipChannel API operation for Amazon Pinpoint.
//
// Delete an APNS VoIP channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteApnsVoipChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipChannel
func (c *Pinpoint) DeleteApnsVoipChannel(input *DeleteApnsVoipChannelInput) (*DeleteApnsVoipChannelOutput, error) {
	req, out := c.DeleteApnsVoipChannelRequest(input)
	return out, req.Send()
}

// DeleteApnsVoipChannelWithContext is the same as DeleteApnsVoipChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApnsVoipChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteApnsVoipChannelWithContext(ctx aws.Context, input *DeleteApnsVoipChannelInput, opts ...request.Option) (*DeleteApnsVoipChannelOutput, error) {
	req, out := c.DeleteApnsVoipChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApnsVoipSandboxChannel = "DeleteApnsVoipSandboxChannel"

// DeleteApnsVoipSandboxChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApnsVoipSandboxChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApnsVoipSandboxChannel for more information on using the DeleteApnsVoipSandboxChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApnsVoipSandboxChannelRequest method.
//    req, resp := client.DeleteApnsVoipSandboxChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipSandboxChannel
func (c *Pinpoint) DeleteApnsVoipSandboxChannelRequest(input *DeleteApnsVoipSandboxChannelInput) (req *request.Request, output *DeleteApnsVoipSandboxChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteApnsVoipSandboxChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip_sandbox",
	}

	if input == nil {
		input = &DeleteApnsVoipSandboxChannelInput{}
	}

	output = &DeleteApnsVoipSandboxChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApnsVoipSandboxChannel API operation for Amazon Pinpoint.
//
// Delete an APNS VoIP sandbox channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteApnsVoipSandboxChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipSandboxChannel
func (c *Pinpoint) DeleteApnsVoipSandboxChannel(input *DeleteApnsVoipSandboxChannelInput) (*DeleteApnsVoipSandboxChannelOutput, error) {
	req, out := c.DeleteApnsVoipSandboxChannelRequest(input)
	return out, req.Send()
}

// DeleteApnsVoipSandboxChannelWithContext is the same as DeleteApnsVoipSandboxChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApnsVoipSandboxChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteApnsVoipSandboxChannelWithContext(ctx aws.Context, input *DeleteApnsVoipSandboxChannelInput, opts ...request.Option) (*DeleteApnsVoipSandboxChannelOutput, error) {
	req, out := c.DeleteApnsVoipSandboxChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApp = "DeleteApp"

// DeleteAppRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApp operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApp for more information on using the DeleteApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAppRequest method.
//    req, resp := client.DeleteAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApp
func (c *Pinpoint) DeleteAppRequest(input *DeleteAppInput) (req *request.Request, output *DeleteAppOutput) {
	op := &request.Operation{
		Name:       opDeleteApp,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}",
	}

	if input == nil {
		input = &DeleteAppInput{}
	}

	output = &DeleteAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApp API operation for Amazon Pinpoint.
//
// Deletes an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteApp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApp
func (c *Pinpoint) DeleteApp(input *DeleteAppInput) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	return out, req.Send()
}

// DeleteAppWithContext is the same as DeleteApp with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteAppWithContext(ctx aws.Context, input *DeleteAppInput, opts ...request.Option) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBaiduChannel = "DeleteBaiduChannel"

// DeleteBaiduChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBaiduChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBaiduChannel for more information on using the DeleteBaiduChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBaiduChannelRequest method.
//    req, resp := client.DeleteBaiduChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteBaiduChannel
func (c *Pinpoint) DeleteBaiduChannelRequest(input *DeleteBaiduChannelInput) (req *request.Request, output *DeleteBaiduChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteBaiduChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/baidu",
	}

	if input == nil {
		input = &DeleteBaiduChannelInput{}
	}

	output = &DeleteBaiduChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBaiduChannel API operation for Amazon Pinpoint.
//
// Delete a BAIDU GCM channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteBaiduChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteBaiduChannel
func (c *Pinpoint) DeleteBaiduChannel(input *DeleteBaiduChannelInput) (*DeleteBaiduChannelOutput, error) {
	req, out := c.DeleteBaiduChannelRequest(input)
	return out, req.Send()
}

// DeleteBaiduChannelWithContext is the same as DeleteBaiduChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBaiduChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteBaiduChannelWithContext(ctx aws.Context, input *DeleteBaiduChannelInput, opts ...request.Option) (*DeleteBaiduChannelOutput, error) {
	req, out := c.DeleteBaiduChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCampaign = "DeleteCampaign"

// DeleteCampaignRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCampaign operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCampaign for more information on using the DeleteCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCampaignRequest method.
//    req, resp := client.DeleteCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteCampaign
func (c *Pinpoint) DeleteCampaignRequest(input *DeleteCampaignInput) (req *request.Request, output *DeleteCampaignOutput) {
	op := &request.Operation{
		Name:       opDeleteCampaign,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}",
	}

	if input == nil {
		input = &DeleteCampaignInput{}
	}

	output = &DeleteCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCampaign API operation for Amazon Pinpoint.
//
// Deletes a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteCampaign for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteCampaign
func (c *Pinpoint) DeleteCampaign(input *DeleteCampaignInput) (*DeleteCampaignOutput, error) {
	req, out := c.DeleteCampaignRequest(input)
	return out, req.Send()
}

// DeleteCampaignWithContext is the same as DeleteCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteCampaignWithContext(ctx aws.Context, input *DeleteCampaignInput, opts ...request.Option) (*DeleteCampaignOutput, error) {
	req, out := c.DeleteCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEmailChannel = "DeleteEmailChannel"

// DeleteEmailChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEmailChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEmailChannel for more information on using the DeleteEmailChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEmailChannelRequest method.
//    req, resp := client.DeleteEmailChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailChannel
func (c *Pinpoint) DeleteEmailChannelRequest(input *DeleteEmailChannelInput) (req *request.Request, output *DeleteEmailChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteEmailChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/email",
	}

	if input == nil {
		input = &DeleteEmailChannelInput{}
	}

	output = &DeleteEmailChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEmailChannel API operation for Amazon Pinpoint.
//
// Delete an email channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteEmailChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailChannel
func (c *Pinpoint) DeleteEmailChannel(input *DeleteEmailChannelInput) (*DeleteEmailChannelOutput, error) {
	req, out := c.DeleteEmailChannelRequest(input)
	return out, req.Send()
}

// DeleteEmailChannelWithContext is the same as DeleteEmailChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEmailChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteEmailChannelWithContext(ctx aws.Context, input *DeleteEmailChannelInput, opts ...request.Option) (*DeleteEmailChannelOutput, error) {
	req, out := c.DeleteEmailChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpoint = "DeleteEndpoint"

// DeleteEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpoint operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpoint for more information on using the DeleteEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEndpointRequest method.
//    req, resp := client.DeleteEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEndpoint
func (c *Pinpoint) DeleteEndpointRequest(input *DeleteEndpointInput) (req *request.Request, output *DeleteEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpoint,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/endpoints/{endpoint-id}",
	}

	if input == nil {
		input = &DeleteEndpointInput{}
	}

	output = &DeleteEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEndpoint API operation for Amazon Pinpoint.
//
// Deletes an endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEndpoint
func (c *Pinpoint) DeleteEndpoint(input *DeleteEndpointInput) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	return out, req.Send()
}

// DeleteEndpointWithContext is the same as DeleteEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteEndpointWithContext(ctx aws.Context, input *DeleteEndpointInput, opts ...request.Option) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventStream = "DeleteEventStream"

// DeleteEventStreamRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventStream operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventStream for more information on using the DeleteEventStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEventStreamRequest method.
//    req, resp := client.DeleteEventStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEventStream
func (c *Pinpoint) DeleteEventStreamRequest(input *DeleteEventStreamInput) (req *request.Request, output *DeleteEventStreamOutput) {
	op := &request.Operation{
		Name:       opDeleteEventStream,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/eventstream",
	}

	if input == nil {
		input = &DeleteEventStreamInput{}
	}

	output = &DeleteEventStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEventStream API operation for Amazon Pinpoint.
//
// Deletes the event stream for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteEventStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEventStream
func (c *Pinpoint) DeleteEventStream(input *DeleteEventStreamInput) (*DeleteEventStreamOutput, error) {
	req, out := c.DeleteEventStreamRequest(input)
	return out, req.Send()
}

// DeleteEventStreamWithContext is the same as DeleteEventStream with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteEventStreamWithContext(ctx aws.Context, input *DeleteEventStreamInput, opts ...request.Option) (*DeleteEventStreamOutput, error) {
	req, out := c.DeleteEventStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGcmChannel = "DeleteGcmChannel"

// DeleteGcmChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGcmChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGcmChannel for more information on using the DeleteGcmChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGcmChannelRequest method.
//    req, resp := client.DeleteGcmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteGcmChannel
func (c *Pinpoint) DeleteGcmChannelRequest(input *DeleteGcmChannelInput) (req *request.Request, output *DeleteGcmChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteGcmChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/gcm",
	}

	if input == nil {
		input = &DeleteGcmChannelInput{}
	}

	output = &DeleteGcmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGcmChannel API operation for Amazon Pinpoint.
//
// Deletes the GCM channel for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteGcmChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteGcmChannel
func (c *Pinpoint) DeleteGcmChannel(input *DeleteGcmChannelInput) (*DeleteGcmChannelOutput, error) {
	req, out := c.DeleteGcmChannelRequest(input)
	return out, req.Send()
}

// DeleteGcmChannelWithContext is the same as DeleteGcmChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGcmChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteGcmChannelWithContext(ctx aws.Context, input *DeleteGcmChannelInput, opts ...request.Option) (*DeleteGcmChannelOutput, error) {
	req, out := c.DeleteGcmChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSegment = "DeleteSegment"

// DeleteSegmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSegment operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSegment for more information on using the DeleteSegment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSegmentRequest method.
//    req, resp := client.DeleteSegmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSegment
func (c *Pinpoint) DeleteSegmentRequest(input *DeleteSegmentInput) (req *request.Request, output *DeleteSegmentOutput) {
	op := &request.Operation{
		Name:       opDeleteSegment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}",
	}

	if input == nil {
		input = &DeleteSegmentInput{}
	}

	output = &DeleteSegmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSegment API operation for Amazon Pinpoint.
//
// Deletes a segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteSegment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSegment
func (c *Pinpoint) DeleteSegment(input *DeleteSegmentInput) (*DeleteSegmentOutput, error) {
	req, out := c.DeleteSegmentRequest(input)
	return out, req.Send()
}

// DeleteSegmentWithContext is the same as DeleteSegment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSegment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteSegmentWithContext(ctx aws.Context, input *DeleteSegmentInput, opts ...request.Option) (*DeleteSegmentOutput, error) {
	req, out := c.DeleteSegmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSmsChannel = "DeleteSmsChannel"

// DeleteSmsChannelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSmsChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSmsChannel for more information on using the DeleteSmsChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSmsChannelRequest method.
//    req, resp := client.DeleteSmsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsChannel
func (c *Pinpoint) DeleteSmsChannelRequest(input *DeleteSmsChannelInput) (req *request.Request, output *DeleteSmsChannelOutput) {
	op := &request.Operation{
		Name:       opDeleteSmsChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apps/{application-id}/channels/sms",
	}

	if input == nil {
		input = &DeleteSmsChannelInput{}
	}

	output = &DeleteSmsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSmsChannel API operation for Amazon Pinpoint.
//
// Delete an SMS channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation DeleteSmsChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsChannel
func (c *Pinpoint) DeleteSmsChannel(input *DeleteSmsChannelInput) (*DeleteSmsChannelOutput, error) {
	req, out := c.DeleteSmsChannelRequest(input)
	return out, req.Send()
}

// DeleteSmsChannelWithContext is the same as DeleteSmsChannel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSmsChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) DeleteSmsChannelWithContext(ctx aws.Context, input *DeleteSmsChannelInput, opts ...request.Option) (*DeleteSmsChannelOutput, error) {
	req, out := c.DeleteSmsChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAdmChannel = "GetAdmChannel"

// GetAdmChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetAdmChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAdmChannel for more information on using the GetAdmChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAdmChannelRequest method.
//    req, resp := client.GetAdmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetAdmChannel
func (c *Pinpoint) GetAdmChannelRequest(input *GetAdmChannelInput) (req *request.Request, output *GetAdmChannelOutput) {
	op := &request.Operation{
		Name:       opGetAdmChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/adm",
	}

	if input == nil {
		input = &GetAdmChannelInput{}
	}

	output = &GetAdmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAdmChannel API operation for Amazon Pinpoint.
//
// Get an ADM channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetAdmChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetAdmChannel
func (c *Pinpoint) GetAdmChannel(input *GetAdmChannelInput) (*GetAdmChannelOutput, error) {
	req, out := c.GetAdmChannelRequest(input)
	return out, req.Send()
}

// GetAdmChannelWithContext is the same as GetAdmChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetAdmChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetAdmChannelWithContext(ctx aws.Context, input *GetAdmChannelInput, opts ...request.Option) (*GetAdmChannelOutput, error) {
	req, out := c.GetAdmChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApnsChannel = "GetApnsChannel"

// GetApnsChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetApnsChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApnsChannel for more information on using the GetApnsChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApnsChannelRequest method.
//    req, resp := client.GetApnsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsChannel
func (c *Pinpoint) GetApnsChannelRequest(input *GetApnsChannelInput) (req *request.Request, output *GetApnsChannelOutput) {
	op := &request.Operation{
		Name:       opGetApnsChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns",
	}

	if input == nil {
		input = &GetApnsChannelInput{}
	}

	output = &GetApnsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApnsChannel API operation for Amazon Pinpoint.
//
// Returns information about the APNs channel for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApnsChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsChannel
func (c *Pinpoint) GetApnsChannel(input *GetApnsChannelInput) (*GetApnsChannelOutput, error) {
	req, out := c.GetApnsChannelRequest(input)
	return out, req.Send()
}

// GetApnsChannelWithContext is the same as GetApnsChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetApnsChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetApnsChannelWithContext(ctx aws.Context, input *GetApnsChannelInput, opts ...request.Option) (*GetApnsChannelOutput, error) {
	req, out := c.GetApnsChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApnsSandboxChannel = "GetApnsSandboxChannel"

// GetApnsSandboxChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetApnsSandboxChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApnsSandboxChannel for more information on using the GetApnsSandboxChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApnsSandboxChannelRequest method.
//    req, resp := client.GetApnsSandboxChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsSandboxChannel
func (c *Pinpoint) GetApnsSandboxChannelRequest(input *GetApnsSandboxChannelInput) (req *request.Request, output *GetApnsSandboxChannelOutput) {
	op := &request.Operation{
		Name:       opGetApnsSandboxChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_sandbox",
	}

	if input == nil {
		input = &GetApnsSandboxChannelInput{}
	}

	output = &GetApnsSandboxChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApnsSandboxChannel API operation for Amazon Pinpoint.
//
// Get an APNS sandbox channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApnsSandboxChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsSandboxChannel
func (c *Pinpoint) GetApnsSandboxChannel(input *GetApnsSandboxChannelInput) (*GetApnsSandboxChannelOutput, error) {
	req, out := c.GetApnsSandboxChannelRequest(input)
	return out, req.Send()
}

// GetApnsSandboxChannelWithContext is the same as GetApnsSandboxChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetApnsSandboxChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetApnsSandboxChannelWithContext(ctx aws.Context, input *GetApnsSandboxChannelInput, opts ...request.Option) (*GetApnsSandboxChannelOutput, error) {
	req, out := c.GetApnsSandboxChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApnsVoipChannel = "GetApnsVoipChannel"

// GetApnsVoipChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetApnsVoipChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApnsVoipChannel for more information on using the GetApnsVoipChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApnsVoipChannelRequest method.
//    req, resp := client.GetApnsVoipChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipChannel
func (c *Pinpoint) GetApnsVoipChannelRequest(input *GetApnsVoipChannelInput) (req *request.Request, output *GetApnsVoipChannelOutput) {
	op := &request.Operation{
		Name:       opGetApnsVoipChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip",
	}

	if input == nil {
		input = &GetApnsVoipChannelInput{}
	}

	output = &GetApnsVoipChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApnsVoipChannel API operation for Amazon Pinpoint.
//
// Get an APNS VoIP channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApnsVoipChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipChannel
func (c *Pinpoint) GetApnsVoipChannel(input *GetApnsVoipChannelInput) (*GetApnsVoipChannelOutput, error) {
	req, out := c.GetApnsVoipChannelRequest(input)
	return out, req.Send()
}

// GetApnsVoipChannelWithContext is the same as GetApnsVoipChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetApnsVoipChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetApnsVoipChannelWithContext(ctx aws.Context, input *GetApnsVoipChannelInput, opts ...request.Option) (*GetApnsVoipChannelOutput, error) {
	req, out := c.GetApnsVoipChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApnsVoipSandboxChannel = "GetApnsVoipSandboxChannel"

// GetApnsVoipSandboxChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetApnsVoipSandboxChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApnsVoipSandboxChannel for more information on using the GetApnsVoipSandboxChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApnsVoipSandboxChannelRequest method.
//    req, resp := client.GetApnsVoipSandboxChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipSandboxChannel
func (c *Pinpoint) GetApnsVoipSandboxChannelRequest(input *GetApnsVoipSandboxChannelInput) (req *request.Request, output *GetApnsVoipSandboxChannelOutput) {
	op := &request.Operation{
		Name:       opGetApnsVoipSandboxChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip_sandbox",
	}

	if input == nil {
		input = &GetApnsVoipSandboxChannelInput{}
	}

	output = &GetApnsVoipSandboxChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApnsVoipSandboxChannel API operation for Amazon Pinpoint.
//
// Get an APNS VoIPSandbox channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApnsVoipSandboxChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipSandboxChannel
func (c *Pinpoint) GetApnsVoipSandboxChannel(input *GetApnsVoipSandboxChannelInput) (*GetApnsVoipSandboxChannelOutput, error) {
	req, out := c.GetApnsVoipSandboxChannelRequest(input)
	return out, req.Send()
}

// GetApnsVoipSandboxChannelWithContext is the same as GetApnsVoipSandboxChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetApnsVoipSandboxChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetApnsVoipSandboxChannelWithContext(ctx aws.Context, input *GetApnsVoipSandboxChannelInput, opts ...request.Option) (*GetApnsVoipSandboxChannelOutput, error) {
	req, out := c.GetApnsVoipSandboxChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApp = "GetApp"

// GetAppRequest generates a "aws/request.Request" representing the
// client's request for the GetApp operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApp for more information on using the GetApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAppRequest method.
//    req, resp := client.GetAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApp
func (c *Pinpoint) GetAppRequest(input *GetAppInput) (req *request.Request, output *GetAppOutput) {
	op := &request.Operation{
		Name:       opGetApp,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}",
	}

	if input == nil {
		input = &GetAppInput{}
	}

	output = &GetAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApp API operation for Amazon Pinpoint.
//
// Returns information about an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApp
func (c *Pinpoint) GetApp(input *GetAppInput) (*GetAppOutput, error) {
	req, out := c.GetAppRequest(input)
	return out, req.Send()
}

// GetAppWithContext is the same as GetApp with the addition of
// the ability to pass a context and additional request options.
//
// See GetApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetAppWithContext(ctx aws.Context, input *GetAppInput, opts ...request.Option) (*GetAppOutput, error) {
	req, out := c.GetAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplicationSettings = "GetApplicationSettings"

// GetApplicationSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetApplicationSettings operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplicationSettings for more information on using the GetApplicationSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApplicationSettingsRequest method.
//    req, resp := client.GetApplicationSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationSettings
func (c *Pinpoint) GetApplicationSettingsRequest(input *GetApplicationSettingsInput) (req *request.Request, output *GetApplicationSettingsOutput) {
	op := &request.Operation{
		Name:       opGetApplicationSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/settings",
	}

	if input == nil {
		input = &GetApplicationSettingsInput{}
	}

	output = &GetApplicationSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplicationSettings API operation for Amazon Pinpoint.
//
// Used to request the settings for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApplicationSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationSettings
func (c *Pinpoint) GetApplicationSettings(input *GetApplicationSettingsInput) (*GetApplicationSettingsOutput, error) {
	req, out := c.GetApplicationSettingsRequest(input)
	return out, req.Send()
}

// GetApplicationSettingsWithContext is the same as GetApplicationSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplicationSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetApplicationSettingsWithContext(ctx aws.Context, input *GetApplicationSettingsInput, opts ...request.Option) (*GetApplicationSettingsOutput, error) {
	req, out := c.GetApplicationSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApps = "GetApps"

// GetAppsRequest generates a "aws/request.Request" representing the
// client's request for the GetApps operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApps for more information on using the GetApps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAppsRequest method.
//    req, resp := client.GetAppsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApps
func (c *Pinpoint) GetAppsRequest(input *GetAppsInput) (req *request.Request, output *GetAppsOutput) {
	op := &request.Operation{
		Name:       opGetApps,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps",
	}

	if input == nil {
		input = &GetAppsInput{}
	}

	output = &GetAppsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApps API operation for Amazon Pinpoint.
//
// Returns information about your apps.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetApps for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApps
func (c *Pinpoint) GetApps(input *GetAppsInput) (*GetAppsOutput, error) {
	req, out := c.GetAppsRequest(input)
	return out, req.Send()
}

// GetAppsWithContext is the same as GetApps with the addition of
// the ability to pass a context and additional request options.
//
// See GetApps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetAppsWithContext(ctx aws.Context, input *GetAppsInput, opts ...request.Option) (*GetAppsOutput, error) {
	req, out := c.GetAppsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBaiduChannel = "GetBaiduChannel"

// GetBaiduChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetBaiduChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBaiduChannel for more information on using the GetBaiduChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBaiduChannelRequest method.
//    req, resp := client.GetBaiduChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetBaiduChannel
func (c *Pinpoint) GetBaiduChannelRequest(input *GetBaiduChannelInput) (req *request.Request, output *GetBaiduChannelOutput) {
	op := &request.Operation{
		Name:       opGetBaiduChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/baidu",
	}

	if input == nil {
		input = &GetBaiduChannelInput{}
	}

	output = &GetBaiduChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBaiduChannel API operation for Amazon Pinpoint.
//
// Get a BAIDU GCM channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetBaiduChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetBaiduChannel
func (c *Pinpoint) GetBaiduChannel(input *GetBaiduChannelInput) (*GetBaiduChannelOutput, error) {
	req, out := c.GetBaiduChannelRequest(input)
	return out, req.Send()
}

// GetBaiduChannelWithContext is the same as GetBaiduChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetBaiduChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetBaiduChannelWithContext(ctx aws.Context, input *GetBaiduChannelInput, opts ...request.Option) (*GetBaiduChannelOutput, error) {
	req, out := c.GetBaiduChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaign = "GetCampaign"

// GetCampaignRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaign operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaign for more information on using the GetCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCampaignRequest method.
//    req, resp := client.GetCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaign
func (c *Pinpoint) GetCampaignRequest(input *GetCampaignInput) (req *request.Request, output *GetCampaignOutput) {
	op := &request.Operation{
		Name:       opGetCampaign,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}",
	}

	if input == nil {
		input = &GetCampaignInput{}
	}

	output = &GetCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaign API operation for Amazon Pinpoint.
//
// Returns information about a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaign for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaign
func (c *Pinpoint) GetCampaign(input *GetCampaignInput) (*GetCampaignOutput, error) {
	req, out := c.GetCampaignRequest(input)
	return out, req.Send()
}

// GetCampaignWithContext is the same as GetCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetCampaignWithContext(ctx aws.Context, input *GetCampaignInput, opts ...request.Option) (*GetCampaignOutput, error) {
	req, out := c.GetCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaignActivities = "GetCampaignActivities"

// GetCampaignActivitiesRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaignActivities operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaignActivities for more information on using the GetCampaignActivities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCampaignActivitiesRequest method.
//    req, resp := client.GetCampaignActivitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignActivities
func (c *Pinpoint) GetCampaignActivitiesRequest(input *GetCampaignActivitiesInput) (req *request.Request, output *GetCampaignActivitiesOutput) {
	op := &request.Operation{
		Name:       opGetCampaignActivities,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}/activities",
	}

	if input == nil {
		input = &GetCampaignActivitiesInput{}
	}

	output = &GetCampaignActivitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaignActivities API operation for Amazon Pinpoint.
//
// Returns information about the activity performed by a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaignActivities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignActivities
func (c *Pinpoint) GetCampaignActivities(input *GetCampaignActivitiesInput) (*GetCampaignActivitiesOutput, error) {
	req, out := c.GetCampaignActivitiesRequest(input)
	return out, req.Send()
}

// GetCampaignActivitiesWithContext is the same as GetCampaignActivities with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaignActivities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetCampaignActivitiesWithContext(ctx aws.Context, input *GetCampaignActivitiesInput, opts ...request.Option) (*GetCampaignActivitiesOutput, error) {
	req, out := c.GetCampaignActivitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaignVersion = "GetCampaignVersion"

// GetCampaignVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaignVersion operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaignVersion for more information on using the GetCampaignVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCampaignVersionRequest method.
//    req, resp := client.GetCampaignVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersion
func (c *Pinpoint) GetCampaignVersionRequest(input *GetCampaignVersionInput) (req *request.Request, output *GetCampaignVersionOutput) {
	op := &request.Operation{
		Name:       opGetCampaignVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}/versions/{version}",
	}

	if input == nil {
		input = &GetCampaignVersionInput{}
	}

	output = &GetCampaignVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaignVersion API operation for Amazon Pinpoint.
//
// Returns information about a specific version of a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaignVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersion
func (c *Pinpoint) GetCampaignVersion(input *GetCampaignVersionInput) (*GetCampaignVersionOutput, error) {
	req, out := c.GetCampaignVersionRequest(input)
	return out, req.Send()
}

// GetCampaignVersionWithContext is the same as GetCampaignVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaignVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetCampaignVersionWithContext(ctx aws.Context, input *GetCampaignVersionInput, opts ...request.Option) (*GetCampaignVersionOutput, error) {
	req, out := c.GetCampaignVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaignVersions = "GetCampaignVersions"

// GetCampaignVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaignVersions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaignVersions for more information on using the GetCampaignVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCampaignVersionsRequest method.
//    req, resp := client.GetCampaignVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersions
func (c *Pinpoint) GetCampaignVersionsRequest(input *GetCampaignVersionsInput) (req *request.Request, output *GetCampaignVersionsOutput) {
	op := &request.Operation{
		Name:       opGetCampaignVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}/versions",
	}

	if input == nil {
		input = &GetCampaignVersionsInput{}
	}

	output = &GetCampaignVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaignVersions API operation for Amazon Pinpoint.
//
// Returns information about your campaign versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaignVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersions
func (c *Pinpoint) GetCampaignVersions(input *GetCampaignVersionsInput) (*GetCampaignVersionsOutput, error) {
	req, out := c.GetCampaignVersionsRequest(input)
	return out, req.Send()
}

// GetCampaignVersionsWithContext is the same as GetCampaignVersions with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaignVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetCampaignVersionsWithContext(ctx aws.Context, input *GetCampaignVersionsInput, opts ...request.Option) (*GetCampaignVersionsOutput, error) {
	req, out := c.GetCampaignVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCampaigns = "GetCampaigns"

// GetCampaignsRequest generates a "aws/request.Request" representing the
// client's request for the GetCampaigns operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCampaigns for more information on using the GetCampaigns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCampaignsRequest method.
//    req, resp := client.GetCampaignsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaigns
func (c *Pinpoint) GetCampaignsRequest(input *GetCampaignsInput) (req *request.Request, output *GetCampaignsOutput) {
	op := &request.Operation{
		Name:       opGetCampaigns,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/campaigns",
	}

	if input == nil {
		input = &GetCampaignsInput{}
	}

	output = &GetCampaignsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCampaigns API operation for Amazon Pinpoint.
//
// Returns information about your campaigns.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetCampaigns for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaigns
func (c *Pinpoint) GetCampaigns(input *GetCampaignsInput) (*GetCampaignsOutput, error) {
	req, out := c.GetCampaignsRequest(input)
	return out, req.Send()
}

// GetCampaignsWithContext is the same as GetCampaigns with the addition of
// the ability to pass a context and additional request options.
//
// See GetCampaigns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetCampaignsWithContext(ctx aws.Context, input *GetCampaignsInput, opts ...request.Option) (*GetCampaignsOutput, error) {
	req, out := c.GetCampaignsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEmailChannel = "GetEmailChannel"

// GetEmailChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetEmailChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEmailChannel for more information on using the GetEmailChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEmailChannelRequest method.
//    req, resp := client.GetEmailChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailChannel
func (c *Pinpoint) GetEmailChannelRequest(input *GetEmailChannelInput) (req *request.Request, output *GetEmailChannelOutput) {
	op := &request.Operation{
		Name:       opGetEmailChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/email",
	}

	if input == nil {
		input = &GetEmailChannelInput{}
	}

	output = &GetEmailChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEmailChannel API operation for Amazon Pinpoint.
//
// Get an email channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetEmailChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailChannel
func (c *Pinpoint) GetEmailChannel(input *GetEmailChannelInput) (*GetEmailChannelOutput, error) {
	req, out := c.GetEmailChannelRequest(input)
	return out, req.Send()
}

// GetEmailChannelWithContext is the same as GetEmailChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetEmailChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetEmailChannelWithContext(ctx aws.Context, input *GetEmailChannelInput, opts ...request.Option) (*GetEmailChannelOutput, error) {
	req, out := c.GetEmailChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEndpoint = "GetEndpoint"

// GetEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetEndpoint operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEndpoint for more information on using the GetEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEndpointRequest method.
//    req, resp := client.GetEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEndpoint
func (c *Pinpoint) GetEndpointRequest(input *GetEndpointInput) (req *request.Request, output *GetEndpointOutput) {
	op := &request.Operation{
		Name:       opGetEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/endpoints/{endpoint-id}",
	}

	if input == nil {
		input = &GetEndpointInput{}
	}

	output = &GetEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEndpoint API operation for Amazon Pinpoint.
//
// Returns information about an endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEndpoint
func (c *Pinpoint) GetEndpoint(input *GetEndpointInput) (*GetEndpointOutput, error) {
	req, out := c.GetEndpointRequest(input)
	return out, req.Send()
}

// GetEndpointWithContext is the same as GetEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetEndpointWithContext(ctx aws.Context, input *GetEndpointInput, opts ...request.Option) (*GetEndpointOutput, error) {
	req, out := c.GetEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventStream = "GetEventStream"

// GetEventStreamRequest generates a "aws/request.Request" representing the
// client's request for the GetEventStream operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventStream for more information on using the GetEventStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEventStreamRequest method.
//    req, resp := client.GetEventStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEventStream
func (c *Pinpoint) GetEventStreamRequest(input *GetEventStreamInput) (req *request.Request, output *GetEventStreamOutput) {
	op := &request.Operation{
		Name:       opGetEventStream,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/eventstream",
	}

	if input == nil {
		input = &GetEventStreamInput{}
	}

	output = &GetEventStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventStream API operation for Amazon Pinpoint.
//
// Returns the event stream for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetEventStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEventStream
func (c *Pinpoint) GetEventStream(input *GetEventStreamInput) (*GetEventStreamOutput, error) {
	req, out := c.GetEventStreamRequest(input)
	return out, req.Send()
}

// GetEventStreamWithContext is the same as GetEventStream with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetEventStreamWithContext(ctx aws.Context, input *GetEventStreamInput, opts ...request.Option) (*GetEventStreamOutput, error) {
	req, out := c.GetEventStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExportJob = "GetExportJob"

// GetExportJobRequest generates a "aws/request.Request" representing the
// client's request for the GetExportJob operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExportJob for more information on using the GetExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetExportJobRequest method.
//    req, resp := client.GetExportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJob
func (c *Pinpoint) GetExportJobRequest(input *GetExportJobInput) (req *request.Request, output *GetExportJobOutput) {
	op := &request.Operation{
		Name:       opGetExportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/jobs/export/{job-id}",
	}

	if input == nil {
		input = &GetExportJobInput{}
	}

	output = &GetExportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExportJob API operation for Amazon Pinpoint.
//
// Returns information about an export job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetExportJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJob
func (c *Pinpoint) GetExportJob(input *GetExportJobInput) (*GetExportJobOutput, error) {
	req, out := c.GetExportJobRequest(input)
	return out, req.Send()
}

// GetExportJobWithContext is the same as GetExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetExportJobWithContext(ctx aws.Context, input *GetExportJobInput, opts ...request.Option) (*GetExportJobOutput, error) {
	req, out := c.GetExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExportJobs = "GetExportJobs"

// GetExportJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetExportJobs operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExportJobs for more information on using the GetExportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetExportJobsRequest method.
//    req, resp := client.GetExportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJobs
func (c *Pinpoint) GetExportJobsRequest(input *GetExportJobsInput) (req *request.Request, output *GetExportJobsOutput) {
	op := &request.Operation{
		Name:       opGetExportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/jobs/export",
	}

	if input == nil {
		input = &GetExportJobsInput{}
	}

	output = &GetExportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExportJobs API operation for Amazon Pinpoint.
//
// Returns information about your export jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetExportJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJobs
func (c *Pinpoint) GetExportJobs(input *GetExportJobsInput) (*GetExportJobsOutput, error) {
	req, out := c.GetExportJobsRequest(input)
	return out, req.Send()
}

// GetExportJobsWithContext is the same as GetExportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See GetExportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetExportJobsWithContext(ctx aws.Context, input *GetExportJobsInput, opts ...request.Option) (*GetExportJobsOutput, error) {
	req, out := c.GetExportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGcmChannel = "GetGcmChannel"

// GetGcmChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetGcmChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGcmChannel for more information on using the GetGcmChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGcmChannelRequest method.
//    req, resp := client.GetGcmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetGcmChannel
func (c *Pinpoint) GetGcmChannelRequest(input *GetGcmChannelInput) (req *request.Request, output *GetGcmChannelOutput) {
	op := &request.Operation{
		Name:       opGetGcmChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/gcm",
	}

	if input == nil {
		input = &GetGcmChannelInput{}
	}

	output = &GetGcmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGcmChannel API operation for Amazon Pinpoint.
//
// Returns information about the GCM channel for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetGcmChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetGcmChannel
func (c *Pinpoint) GetGcmChannel(input *GetGcmChannelInput) (*GetGcmChannelOutput, error) {
	req, out := c.GetGcmChannelRequest(input)
	return out, req.Send()
}

// GetGcmChannelWithContext is the same as GetGcmChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetGcmChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetGcmChannelWithContext(ctx aws.Context, input *GetGcmChannelInput, opts ...request.Option) (*GetGcmChannelOutput, error) {
	req, out := c.GetGcmChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetImportJob = "GetImportJob"

// GetImportJobRequest generates a "aws/request.Request" representing the
// client's request for the GetImportJob operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetImportJob for more information on using the GetImportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetImportJobRequest method.
//    req, resp := client.GetImportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJob
func (c *Pinpoint) GetImportJobRequest(input *GetImportJobInput) (req *request.Request, output *GetImportJobOutput) {
	op := &request.Operation{
		Name:       opGetImportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/jobs/import/{job-id}",
	}

	if input == nil {
		input = &GetImportJobInput{}
	}

	output = &GetImportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetImportJob API operation for Amazon Pinpoint.
//
// Returns information about an import job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetImportJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJob
func (c *Pinpoint) GetImportJob(input *GetImportJobInput) (*GetImportJobOutput, error) {
	req, out := c.GetImportJobRequest(input)
	return out, req.Send()
}

// GetImportJobWithContext is the same as GetImportJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetImportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetImportJobWithContext(ctx aws.Context, input *GetImportJobInput, opts ...request.Option) (*GetImportJobOutput, error) {
	req, out := c.GetImportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetImportJobs = "GetImportJobs"

// GetImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetImportJobs operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetImportJobs for more information on using the GetImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetImportJobsRequest method.
//    req, resp := client.GetImportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJobs
func (c *Pinpoint) GetImportJobsRequest(input *GetImportJobsInput) (req *request.Request, output *GetImportJobsOutput) {
	op := &request.Operation{
		Name:       opGetImportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/jobs/import",
	}

	if input == nil {
		input = &GetImportJobsInput{}
	}

	output = &GetImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetImportJobs API operation for Amazon Pinpoint.
//
// Returns information about your import jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetImportJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJobs
func (c *Pinpoint) GetImportJobs(input *GetImportJobsInput) (*GetImportJobsOutput, error) {
	req, out := c.GetImportJobsRequest(input)
	return out, req.Send()
}

// GetImportJobsWithContext is the same as GetImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See GetImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetImportJobsWithContext(ctx aws.Context, input *GetImportJobsInput, opts ...request.Option) (*GetImportJobsOutput, error) {
	req, out := c.GetImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegment = "GetSegment"

// GetSegmentRequest generates a "aws/request.Request" representing the
// client's request for the GetSegment operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegment for more information on using the GetSegment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentRequest method.
//    req, resp := client.GetSegmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegment
func (c *Pinpoint) GetSegmentRequest(input *GetSegmentInput) (req *request.Request, output *GetSegmentOutput) {
	op := &request.Operation{
		Name:       opGetSegment,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}",
	}

	if input == nil {
		input = &GetSegmentInput{}
	}

	output = &GetSegmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegment API operation for Amazon Pinpoint.
//
// Returns information about a segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegment
func (c *Pinpoint) GetSegment(input *GetSegmentInput) (*GetSegmentOutput, error) {
	req, out := c.GetSegmentRequest(input)
	return out, req.Send()
}

// GetSegmentWithContext is the same as GetSegment with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSegmentWithContext(ctx aws.Context, input *GetSegmentInput, opts ...request.Option) (*GetSegmentOutput, error) {
	req, out := c.GetSegmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegmentExportJobs = "GetSegmentExportJobs"

// GetSegmentExportJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetSegmentExportJobs operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegmentExportJobs for more information on using the GetSegmentExportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentExportJobsRequest method.
//    req, resp := client.GetSegmentExportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentExportJobs
func (c *Pinpoint) GetSegmentExportJobsRequest(input *GetSegmentExportJobsInput) (req *request.Request, output *GetSegmentExportJobsOutput) {
	op := &request.Operation{
		Name:       opGetSegmentExportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}/jobs/export",
	}

	if input == nil {
		input = &GetSegmentExportJobsInput{}
	}

	output = &GetSegmentExportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegmentExportJobs API operation for Amazon Pinpoint.
//
// Returns a list of export jobs for a specific segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegmentExportJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentExportJobs
func (c *Pinpoint) GetSegmentExportJobs(input *GetSegmentExportJobsInput) (*GetSegmentExportJobsOutput, error) {
	req, out := c.GetSegmentExportJobsRequest(input)
	return out, req.Send()
}

// GetSegmentExportJobsWithContext is the same as GetSegmentExportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegmentExportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSegmentExportJobsWithContext(ctx aws.Context, input *GetSegmentExportJobsInput, opts ...request.Option) (*GetSegmentExportJobsOutput, error) {
	req, out := c.GetSegmentExportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegmentImportJobs = "GetSegmentImportJobs"

// GetSegmentImportJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetSegmentImportJobs operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegmentImportJobs for more information on using the GetSegmentImportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentImportJobsRequest method.
//    req, resp := client.GetSegmentImportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentImportJobs
func (c *Pinpoint) GetSegmentImportJobsRequest(input *GetSegmentImportJobsInput) (req *request.Request, output *GetSegmentImportJobsOutput) {
	op := &request.Operation{
		Name:       opGetSegmentImportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}/jobs/import",
	}

	if input == nil {
		input = &GetSegmentImportJobsInput{}
	}

	output = &GetSegmentImportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegmentImportJobs API operation for Amazon Pinpoint.
//
// Returns a list of import jobs for a specific segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegmentImportJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentImportJobs
func (c *Pinpoint) GetSegmentImportJobs(input *GetSegmentImportJobsInput) (*GetSegmentImportJobsOutput, error) {
	req, out := c.GetSegmentImportJobsRequest(input)
	return out, req.Send()
}

// GetSegmentImportJobsWithContext is the same as GetSegmentImportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegmentImportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSegmentImportJobsWithContext(ctx aws.Context, input *GetSegmentImportJobsInput, opts ...request.Option) (*GetSegmentImportJobsOutput, error) {
	req, out := c.GetSegmentImportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegmentVersion = "GetSegmentVersion"

// GetSegmentVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetSegmentVersion operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegmentVersion for more information on using the GetSegmentVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentVersionRequest method.
//    req, resp := client.GetSegmentVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersion
func (c *Pinpoint) GetSegmentVersionRequest(input *GetSegmentVersionInput) (req *request.Request, output *GetSegmentVersionOutput) {
	op := &request.Operation{
		Name:       opGetSegmentVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}/versions/{version}",
	}

	if input == nil {
		input = &GetSegmentVersionInput{}
	}

	output = &GetSegmentVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegmentVersion API operation for Amazon Pinpoint.
//
// Returns information about a segment version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegmentVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersion
func (c *Pinpoint) GetSegmentVersion(input *GetSegmentVersionInput) (*GetSegmentVersionOutput, error) {
	req, out := c.GetSegmentVersionRequest(input)
	return out, req.Send()
}

// GetSegmentVersionWithContext is the same as GetSegmentVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegmentVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSegmentVersionWithContext(ctx aws.Context, input *GetSegmentVersionInput, opts ...request.Option) (*GetSegmentVersionOutput, error) {
	req, out := c.GetSegmentVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegmentVersions = "GetSegmentVersions"

// GetSegmentVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetSegmentVersions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegmentVersions for more information on using the GetSegmentVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentVersionsRequest method.
//    req, resp := client.GetSegmentVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersions
func (c *Pinpoint) GetSegmentVersionsRequest(input *GetSegmentVersionsInput) (req *request.Request, output *GetSegmentVersionsOutput) {
	op := &request.Operation{
		Name:       opGetSegmentVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}/versions",
	}

	if input == nil {
		input = &GetSegmentVersionsInput{}
	}

	output = &GetSegmentVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegmentVersions API operation for Amazon Pinpoint.
//
// Returns information about your segment versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegmentVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersions
func (c *Pinpoint) GetSegmentVersions(input *GetSegmentVersionsInput) (*GetSegmentVersionsOutput, error) {
	req, out := c.GetSegmentVersionsRequest(input)
	return out, req.Send()
}

// GetSegmentVersionsWithContext is the same as GetSegmentVersions with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegmentVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSegmentVersionsWithContext(ctx aws.Context, input *GetSegmentVersionsInput, opts ...request.Option) (*GetSegmentVersionsOutput, error) {
	req, out := c.GetSegmentVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSegments = "GetSegments"

// GetSegmentsRequest generates a "aws/request.Request" representing the
// client's request for the GetSegments operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegments for more information on using the GetSegments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentsRequest method.
//    req, resp := client.GetSegmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegments
func (c *Pinpoint) GetSegmentsRequest(input *GetSegmentsInput) (req *request.Request, output *GetSegmentsOutput) {
	op := &request.Operation{
		Name:       opGetSegments,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/segments",
	}

	if input == nil {
		input = &GetSegmentsInput{}
	}

	output = &GetSegmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegments API operation for Amazon Pinpoint.
//
// Used to get information about your segments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSegments for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegments
func (c *Pinpoint) GetSegments(input *GetSegmentsInput) (*GetSegmentsOutput, error) {
	req, out := c.GetSegmentsRequest(input)
	return out, req.Send()
}

// GetSegmentsWithContext is the same as GetSegments with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSegmentsWithContext(ctx aws.Context, input *GetSegmentsInput, opts ...request.Option) (*GetSegmentsOutput, error) {
	req, out := c.GetSegmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSmsChannel = "GetSmsChannel"

// GetSmsChannelRequest generates a "aws/request.Request" representing the
// client's request for the GetSmsChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSmsChannel for more information on using the GetSmsChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSmsChannelRequest method.
//    req, resp := client.GetSmsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsChannel
func (c *Pinpoint) GetSmsChannelRequest(input *GetSmsChannelInput) (req *request.Request, output *GetSmsChannelOutput) {
	op := &request.Operation{
		Name:       opGetSmsChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/sms",
	}

	if input == nil {
		input = &GetSmsChannelInput{}
	}

	output = &GetSmsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSmsChannel API operation for Amazon Pinpoint.
//
// Get an SMS channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation GetSmsChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsChannel
func (c *Pinpoint) GetSmsChannel(input *GetSmsChannelInput) (*GetSmsChannelOutput, error) {
	req, out := c.GetSmsChannelRequest(input)
	return out, req.Send()
}

// GetSmsChannelWithContext is the same as GetSmsChannel with the addition of
// the ability to pass a context and additional request options.
//
// See GetSmsChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) GetSmsChannelWithContext(ctx aws.Context, input *GetSmsChannelInput, opts ...request.Option) (*GetSmsChannelOutput, error) {
	req, out := c.GetSmsChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEventStream = "PutEventStream"

// PutEventStreamRequest generates a "aws/request.Request" representing the
// client's request for the PutEventStream operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEventStream for more information on using the PutEventStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEventStreamRequest method.
//    req, resp := client.PutEventStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEventStream
func (c *Pinpoint) PutEventStreamRequest(input *PutEventStreamInput) (req *request.Request, output *PutEventStreamOutput) {
	op := &request.Operation{
		Name:       opPutEventStream,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/eventstream",
	}

	if input == nil {
		input = &PutEventStreamInput{}
	}

	output = &PutEventStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEventStream API operation for Amazon Pinpoint.
//
// Use to create or update the event stream for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation PutEventStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEventStream
func (c *Pinpoint) PutEventStream(input *PutEventStreamInput) (*PutEventStreamOutput, error) {
	req, out := c.PutEventStreamRequest(input)
	return out, req.Send()
}

// PutEventStreamWithContext is the same as PutEventStream with the addition of
// the ability to pass a context and additional request options.
//
// See PutEventStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) PutEventStreamWithContext(ctx aws.Context, input *PutEventStreamInput, opts ...request.Option) (*PutEventStreamOutput, error) {
	req, out := c.PutEventStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendMessages = "SendMessages"

// SendMessagesRequest generates a "aws/request.Request" representing the
// client's request for the SendMessages operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendMessages for more information on using the SendMessages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendMessagesRequest method.
//    req, resp := client.SendMessagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendMessages
func (c *Pinpoint) SendMessagesRequest(input *SendMessagesInput) (req *request.Request, output *SendMessagesOutput) {
	op := &request.Operation{
		Name:       opSendMessages,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/messages",
	}

	if input == nil {
		input = &SendMessagesInput{}
	}

	output = &SendMessagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendMessages API operation for Amazon Pinpoint.
//
// Send a batch of messages
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation SendMessages for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendMessages
func (c *Pinpoint) SendMessages(input *SendMessagesInput) (*SendMessagesOutput, error) {
	req, out := c.SendMessagesRequest(input)
	return out, req.Send()
}

// SendMessagesWithContext is the same as SendMessages with the addition of
// the ability to pass a context and additional request options.
//
// See SendMessages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) SendMessagesWithContext(ctx aws.Context, input *SendMessagesInput, opts ...request.Option) (*SendMessagesOutput, error) {
	req, out := c.SendMessagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendUsersMessages = "SendUsersMessages"

// SendUsersMessagesRequest generates a "aws/request.Request" representing the
// client's request for the SendUsersMessages operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendUsersMessages for more information on using the SendUsersMessages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendUsersMessagesRequest method.
//    req, resp := client.SendUsersMessagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendUsersMessages
func (c *Pinpoint) SendUsersMessagesRequest(input *SendUsersMessagesInput) (req *request.Request, output *SendUsersMessagesOutput) {
	op := &request.Operation{
		Name:       opSendUsersMessages,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/users-messages",
	}

	if input == nil {
		input = &SendUsersMessagesInput{}
	}

	output = &SendUsersMessagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendUsersMessages API operation for Amazon Pinpoint.
//
// Send a batch of messages to users
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation SendUsersMessages for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendUsersMessages
func (c *Pinpoint) SendUsersMessages(input *SendUsersMessagesInput) (*SendUsersMessagesOutput, error) {
	req, out := c.SendUsersMessagesRequest(input)
	return out, req.Send()
}

// SendUsersMessagesWithContext is the same as SendUsersMessages with the addition of
// the ability to pass a context and additional request options.
//
// See SendUsersMessages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) SendUsersMessagesWithContext(ctx aws.Context, input *SendUsersMessagesInput, opts ...request.Option) (*SendUsersMessagesOutput, error) {
	req, out := c.SendUsersMessagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAdmChannel = "UpdateAdmChannel"

// UpdateAdmChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAdmChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAdmChannel for more information on using the UpdateAdmChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAdmChannelRequest method.
//    req, resp := client.UpdateAdmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateAdmChannel
func (c *Pinpoint) UpdateAdmChannelRequest(input *UpdateAdmChannelInput) (req *request.Request, output *UpdateAdmChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateAdmChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/adm",
	}

	if input == nil {
		input = &UpdateAdmChannelInput{}
	}

	output = &UpdateAdmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAdmChannel API operation for Amazon Pinpoint.
//
// Update an ADM channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateAdmChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateAdmChannel
func (c *Pinpoint) UpdateAdmChannel(input *UpdateAdmChannelInput) (*UpdateAdmChannelOutput, error) {
	req, out := c.UpdateAdmChannelRequest(input)
	return out, req.Send()
}

// UpdateAdmChannelWithContext is the same as UpdateAdmChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAdmChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateAdmChannelWithContext(ctx aws.Context, input *UpdateAdmChannelInput, opts ...request.Option) (*UpdateAdmChannelOutput, error) {
	req, out := c.UpdateAdmChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApnsChannel = "UpdateApnsChannel"

// UpdateApnsChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApnsChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApnsChannel for more information on using the UpdateApnsChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApnsChannelRequest method.
//    req, resp := client.UpdateApnsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsChannel
func (c *Pinpoint) UpdateApnsChannelRequest(input *UpdateApnsChannelInput) (req *request.Request, output *UpdateApnsChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateApnsChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns",
	}

	if input == nil {
		input = &UpdateApnsChannelInput{}
	}

	output = &UpdateApnsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApnsChannel API operation for Amazon Pinpoint.
//
// Use to update the APNs channel for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateApnsChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsChannel
func (c *Pinpoint) UpdateApnsChannel(input *UpdateApnsChannelInput) (*UpdateApnsChannelOutput, error) {
	req, out := c.UpdateApnsChannelRequest(input)
	return out, req.Send()
}

// UpdateApnsChannelWithContext is the same as UpdateApnsChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApnsChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateApnsChannelWithContext(ctx aws.Context, input *UpdateApnsChannelInput, opts ...request.Option) (*UpdateApnsChannelOutput, error) {
	req, out := c.UpdateApnsChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApnsSandboxChannel = "UpdateApnsSandboxChannel"

// UpdateApnsSandboxChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApnsSandboxChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApnsSandboxChannel for more information on using the UpdateApnsSandboxChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApnsSandboxChannelRequest method.
//    req, resp := client.UpdateApnsSandboxChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsSandboxChannel
func (c *Pinpoint) UpdateApnsSandboxChannelRequest(input *UpdateApnsSandboxChannelInput) (req *request.Request, output *UpdateApnsSandboxChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateApnsSandboxChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_sandbox",
	}

	if input == nil {
		input = &UpdateApnsSandboxChannelInput{}
	}

	output = &UpdateApnsSandboxChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApnsSandboxChannel API operation for Amazon Pinpoint.
//
// Update an APNS sandbox channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateApnsSandboxChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsSandboxChannel
func (c *Pinpoint) UpdateApnsSandboxChannel(input *UpdateApnsSandboxChannelInput) (*UpdateApnsSandboxChannelOutput, error) {
	req, out := c.UpdateApnsSandboxChannelRequest(input)
	return out, req.Send()
}

// UpdateApnsSandboxChannelWithContext is the same as UpdateApnsSandboxChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApnsSandboxChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateApnsSandboxChannelWithContext(ctx aws.Context, input *UpdateApnsSandboxChannelInput, opts ...request.Option) (*UpdateApnsSandboxChannelOutput, error) {
	req, out := c.UpdateApnsSandboxChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApnsVoipChannel = "UpdateApnsVoipChannel"

// UpdateApnsVoipChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApnsVoipChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApnsVoipChannel for more information on using the UpdateApnsVoipChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApnsVoipChannelRequest method.
//    req, resp := client.UpdateApnsVoipChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipChannel
func (c *Pinpoint) UpdateApnsVoipChannelRequest(input *UpdateApnsVoipChannelInput) (req *request.Request, output *UpdateApnsVoipChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateApnsVoipChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip",
	}

	if input == nil {
		input = &UpdateApnsVoipChannelInput{}
	}

	output = &UpdateApnsVoipChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApnsVoipChannel API operation for Amazon Pinpoint.
//
// Update an APNS VoIP channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateApnsVoipChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipChannel
func (c *Pinpoint) UpdateApnsVoipChannel(input *UpdateApnsVoipChannelInput) (*UpdateApnsVoipChannelOutput, error) {
	req, out := c.UpdateApnsVoipChannelRequest(input)
	return out, req.Send()
}

// UpdateApnsVoipChannelWithContext is the same as UpdateApnsVoipChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApnsVoipChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateApnsVoipChannelWithContext(ctx aws.Context, input *UpdateApnsVoipChannelInput, opts ...request.Option) (*UpdateApnsVoipChannelOutput, error) {
	req, out := c.UpdateApnsVoipChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApnsVoipSandboxChannel = "UpdateApnsVoipSandboxChannel"

// UpdateApnsVoipSandboxChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApnsVoipSandboxChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApnsVoipSandboxChannel for more information on using the UpdateApnsVoipSandboxChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApnsVoipSandboxChannelRequest method.
//    req, resp := client.UpdateApnsVoipSandboxChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipSandboxChannel
func (c *Pinpoint) UpdateApnsVoipSandboxChannelRequest(input *UpdateApnsVoipSandboxChannelInput) (req *request.Request, output *UpdateApnsVoipSandboxChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateApnsVoipSandboxChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/apns_voip_sandbox",
	}

	if input == nil {
		input = &UpdateApnsVoipSandboxChannelInput{}
	}

	output = &UpdateApnsVoipSandboxChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApnsVoipSandboxChannel API operation for Amazon Pinpoint.
//
// Update an APNS VoIP sandbox channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateApnsVoipSandboxChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipSandboxChannel
func (c *Pinpoint) UpdateApnsVoipSandboxChannel(input *UpdateApnsVoipSandboxChannelInput) (*UpdateApnsVoipSandboxChannelOutput, error) {
	req, out := c.UpdateApnsVoipSandboxChannelRequest(input)
	return out, req.Send()
}

// UpdateApnsVoipSandboxChannelWithContext is the same as UpdateApnsVoipSandboxChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApnsVoipSandboxChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateApnsVoipSandboxChannelWithContext(ctx aws.Context, input *UpdateApnsVoipSandboxChannelInput, opts ...request.Option) (*UpdateApnsVoipSandboxChannelOutput, error) {
	req, out := c.UpdateApnsVoipSandboxChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplicationSettings = "UpdateApplicationSettings"

// UpdateApplicationSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplicationSettings operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplicationSettings for more information on using the UpdateApplicationSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApplicationSettingsRequest method.
//    req, resp := client.UpdateApplicationSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApplicationSettings
func (c *Pinpoint) UpdateApplicationSettingsRequest(input *UpdateApplicationSettingsInput) (req *request.Request, output *UpdateApplicationSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateApplicationSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/settings",
	}

	if input == nil {
		input = &UpdateApplicationSettingsInput{}
	}

	output = &UpdateApplicationSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApplicationSettings API operation for Amazon Pinpoint.
//
// Used to update the settings for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateApplicationSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApplicationSettings
func (c *Pinpoint) UpdateApplicationSettings(input *UpdateApplicationSettingsInput) (*UpdateApplicationSettingsOutput, error) {
	req, out := c.UpdateApplicationSettingsRequest(input)
	return out, req.Send()
}

// UpdateApplicationSettingsWithContext is the same as UpdateApplicationSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplicationSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateApplicationSettingsWithContext(ctx aws.Context, input *UpdateApplicationSettingsInput, opts ...request.Option) (*UpdateApplicationSettingsOutput, error) {
	req, out := c.UpdateApplicationSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBaiduChannel = "UpdateBaiduChannel"

// UpdateBaiduChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBaiduChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBaiduChannel for more information on using the UpdateBaiduChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBaiduChannelRequest method.
//    req, resp := client.UpdateBaiduChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateBaiduChannel
func (c *Pinpoint) UpdateBaiduChannelRequest(input *UpdateBaiduChannelInput) (req *request.Request, output *UpdateBaiduChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateBaiduChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/baidu",
	}

	if input == nil {
		input = &UpdateBaiduChannelInput{}
	}

	output = &UpdateBaiduChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBaiduChannel API operation for Amazon Pinpoint.
//
// Update a BAIDU GCM channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateBaiduChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateBaiduChannel
func (c *Pinpoint) UpdateBaiduChannel(input *UpdateBaiduChannelInput) (*UpdateBaiduChannelOutput, error) {
	req, out := c.UpdateBaiduChannelRequest(input)
	return out, req.Send()
}

// UpdateBaiduChannelWithContext is the same as UpdateBaiduChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBaiduChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateBaiduChannelWithContext(ctx aws.Context, input *UpdateBaiduChannelInput, opts ...request.Option) (*UpdateBaiduChannelOutput, error) {
	req, out := c.UpdateBaiduChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCampaign = "UpdateCampaign"

// UpdateCampaignRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCampaign operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCampaign for more information on using the UpdateCampaign
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCampaignRequest method.
//    req, resp := client.UpdateCampaignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateCampaign
func (c *Pinpoint) UpdateCampaignRequest(input *UpdateCampaignInput) (req *request.Request, output *UpdateCampaignOutput) {
	op := &request.Operation{
		Name:       opUpdateCampaign,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/campaigns/{campaign-id}",
	}

	if input == nil {
		input = &UpdateCampaignInput{}
	}

	output = &UpdateCampaignOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCampaign API operation for Amazon Pinpoint.
//
// Use to update a campaign.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateCampaign for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateCampaign
func (c *Pinpoint) UpdateCampaign(input *UpdateCampaignInput) (*UpdateCampaignOutput, error) {
	req, out := c.UpdateCampaignRequest(input)
	return out, req.Send()
}

// UpdateCampaignWithContext is the same as UpdateCampaign with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCampaign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateCampaignWithContext(ctx aws.Context, input *UpdateCampaignInput, opts ...request.Option) (*UpdateCampaignOutput, error) {
	req, out := c.UpdateCampaignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEmailChannel = "UpdateEmailChannel"

// UpdateEmailChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEmailChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEmailChannel for more information on using the UpdateEmailChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEmailChannelRequest method.
//    req, resp := client.UpdateEmailChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailChannel
func (c *Pinpoint) UpdateEmailChannelRequest(input *UpdateEmailChannelInput) (req *request.Request, output *UpdateEmailChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateEmailChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/email",
	}

	if input == nil {
		input = &UpdateEmailChannelInput{}
	}

	output = &UpdateEmailChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEmailChannel API operation for Amazon Pinpoint.
//
// Update an email channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateEmailChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailChannel
func (c *Pinpoint) UpdateEmailChannel(input *UpdateEmailChannelInput) (*UpdateEmailChannelOutput, error) {
	req, out := c.UpdateEmailChannelRequest(input)
	return out, req.Send()
}

// UpdateEmailChannelWithContext is the same as UpdateEmailChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEmailChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateEmailChannelWithContext(ctx aws.Context, input *UpdateEmailChannelInput, opts ...request.Option) (*UpdateEmailChannelOutput, error) {
	req, out := c.UpdateEmailChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEndpoint = "UpdateEndpoint"

// UpdateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpoint operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEndpoint for more information on using the UpdateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEndpointRequest method.
//    req, resp := client.UpdateEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpoint
func (c *Pinpoint) UpdateEndpointRequest(input *UpdateEndpointInput) (req *request.Request, output *UpdateEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpoint,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/endpoints/{endpoint-id}",
	}

	if input == nil {
		input = &UpdateEndpointInput{}
	}

	output = &UpdateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpoint API operation for Amazon Pinpoint.
//
// Use to update an endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpoint
func (c *Pinpoint) UpdateEndpoint(input *UpdateEndpointInput) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	return out, req.Send()
}

// UpdateEndpointWithContext is the same as UpdateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateEndpointWithContext(ctx aws.Context, input *UpdateEndpointInput, opts ...request.Option) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEndpointsBatch = "UpdateEndpointsBatch"

// UpdateEndpointsBatchRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpointsBatch operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEndpointsBatch for more information on using the UpdateEndpointsBatch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEndpointsBatchRequest method.
//    req, resp := client.UpdateEndpointsBatchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpointsBatch
func (c *Pinpoint) UpdateEndpointsBatchRequest(input *UpdateEndpointsBatchInput) (req *request.Request, output *UpdateEndpointsBatchOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpointsBatch,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/endpoints",
	}

	if input == nil {
		input = &UpdateEndpointsBatchInput{}
	}

	output = &UpdateEndpointsBatchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpointsBatch API operation for Amazon Pinpoint.
//
// Use to update a batch of endpoints.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateEndpointsBatch for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpointsBatch
func (c *Pinpoint) UpdateEndpointsBatch(input *UpdateEndpointsBatchInput) (*UpdateEndpointsBatchOutput, error) {
	req, out := c.UpdateEndpointsBatchRequest(input)
	return out, req.Send()
}

// UpdateEndpointsBatchWithContext is the same as UpdateEndpointsBatch with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEndpointsBatch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateEndpointsBatchWithContext(ctx aws.Context, input *UpdateEndpointsBatchInput, opts ...request.Option) (*UpdateEndpointsBatchOutput, error) {
	req, out := c.UpdateEndpointsBatchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGcmChannel = "UpdateGcmChannel"

// UpdateGcmChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGcmChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGcmChannel for more information on using the UpdateGcmChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGcmChannelRequest method.
//    req, resp := client.UpdateGcmChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateGcmChannel
func (c *Pinpoint) UpdateGcmChannelRequest(input *UpdateGcmChannelInput) (req *request.Request, output *UpdateGcmChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateGcmChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/gcm",
	}

	if input == nil {
		input = &UpdateGcmChannelInput{}
	}

	output = &UpdateGcmChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGcmChannel API operation for Amazon Pinpoint.
//
// Use to update the GCM channel for an app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateGcmChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateGcmChannel
func (c *Pinpoint) UpdateGcmChannel(input *UpdateGcmChannelInput) (*UpdateGcmChannelOutput, error) {
	req, out := c.UpdateGcmChannelRequest(input)
	return out, req.Send()
}

// UpdateGcmChannelWithContext is the same as UpdateGcmChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGcmChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateGcmChannelWithContext(ctx aws.Context, input *UpdateGcmChannelInput, opts ...request.Option) (*UpdateGcmChannelOutput, error) {
	req, out := c.UpdateGcmChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSegment = "UpdateSegment"

// UpdateSegmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSegment operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSegment for more information on using the UpdateSegment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSegmentRequest method.
//    req, resp := client.UpdateSegmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSegment
func (c *Pinpoint) UpdateSegmentRequest(input *UpdateSegmentInput) (req *request.Request, output *UpdateSegmentOutput) {
	op := &request.Operation{
		Name:       opUpdateSegment,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/segments/{segment-id}",
	}

	if input == nil {
		input = &UpdateSegmentInput{}
	}

	output = &UpdateSegmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSegment API operation for Amazon Pinpoint.
//
// Use to update a segment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateSegment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSegment
func (c *Pinpoint) UpdateSegment(input *UpdateSegmentInput) (*UpdateSegmentOutput, error) {
	req, out := c.UpdateSegmentRequest(input)
	return out, req.Send()
}

// UpdateSegmentWithContext is the same as UpdateSegment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSegment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateSegmentWithContext(ctx aws.Context, input *UpdateSegmentInput, opts ...request.Option) (*UpdateSegmentOutput, error) {
	req, out := c.UpdateSegmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSmsChannel = "UpdateSmsChannel"

// UpdateSmsChannelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSmsChannel operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSmsChannel for more information on using the UpdateSmsChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSmsChannelRequest method.
//    req, resp := client.UpdateSmsChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsChannel
func (c *Pinpoint) UpdateSmsChannelRequest(input *UpdateSmsChannelInput) (req *request.Request, output *UpdateSmsChannelOutput) {
	op := &request.Operation{
		Name:       opUpdateSmsChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/sms",
	}

	if input == nil {
		input = &UpdateSmsChannelInput{}
	}

	output = &UpdateSmsChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSmsChannel API operation for Amazon Pinpoint.
//
// Update an SMS channel
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Pinpoint's
// API operation UpdateSmsChannel for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//
//   * ErrCodeForbiddenException "ForbiddenException"
//
//   * ErrCodeNotFoundException "NotFoundException"
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsChannel
func (c *Pinpoint) UpdateSmsChannel(input *UpdateSmsChannelInput) (*UpdateSmsChannelOutput, error) {
	req, out := c.UpdateSmsChannelRequest(input)
	return out, req.Send()
}

// UpdateSmsChannelWithContext is the same as UpdateSmsChannel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSmsChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pinpoint) UpdateSmsChannelWithContext(ctx aws.Context, input *UpdateSmsChannelInput, opts ...request.Option) (*UpdateSmsChannelOutput, error) {
	req, out := c.UpdateSmsChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Amazon Device Messaging channel definition.
type ADMChannelRequest struct {
	_ struct{} `type:"structure"`

	// Client ID as gotten from Amazon
	ClientId *string `type:"string"`

	// Client secret as gotten from Amazon
	ClientSecret *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ADMChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ADMChannelRequest) GoString() string {
	return s.String()
}

// SetClientId sets the ClientId field's value.
func (s *ADMChannelRequest) SetClientId(v string) *ADMChannelRequest {
	s.ClientId = &v
	return s
}

// SetClientSecret sets the ClientSecret field's value.
func (s *ADMChannelRequest) SetClientSecret(v string) *ADMChannelRequest {
	s.ClientSecret = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *ADMChannelRequest) SetEnabled(v bool) *ADMChannelRequest {
	s.Enabled = &v
	return s
}

// Amazon Device Messaging channel definition.
type ADMChannelResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the application to which the channel applies.
	ApplicationId *string `type:"string"`

	// When was this segment created
	CreationDate *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// Indicates whether the channel is configured with ADM credentials. Amazon
	// Pinpoint uses your credentials to authenticate push notifications with ADM.
	// Provide your credentials by setting the ClientId and ClientSecret attributes.
	HasCredential *bool `type:"boolean"`

	// Channel ID. Not used, only for backwards compatibility.
	Id *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who last updated this entry
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// Platform type. Will be "ADM"
	Platform *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s ADMChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ADMChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ADMChannelResponse) SetApplicationId(v string) *ADMChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ADMChannelResponse) SetCreationDate(v string) *ADMChannelResponse {
	s.CreationDate = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *ADMChannelResponse) SetEnabled(v bool) *ADMChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *ADMChannelResponse) SetHasCredential(v bool) *ADMChannelResponse {
	s.HasCredential = &v
	return s
}

// SetId sets the Id field's value.
func (s *ADMChannelResponse) SetId(v string) *ADMChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *ADMChannelResponse) SetIsArchived(v bool) *ADMChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *ADMChannelResponse) SetLastModifiedBy(v string) *ADMChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *ADMChannelResponse) SetLastModifiedDate(v string) *ADMChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *ADMChannelResponse) SetPlatform(v string) *ADMChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ADMChannelResponse) SetVersion(v int64) *ADMChannelResponse {
	s.Version = &v
	return s
}

// ADM Message.
type ADMMessage struct {
	_ struct{} `type:"structure"`

	// The action that occurs if the user taps a push notification delivered by
	// the campaign: OPEN_APP - Your app launches, or it becomes the foreground
	// app if it has been sent to the background. This is the default action. DEEP_LINK
	// - Uses deep linking features in iOS and Android to open your app and display
	// a designated user interface within the app. URL - The default mobile browser
	// on the user's device launches and opens a web page at the URL you specify.
	// Possible values include: OPEN_APP | DEEP_LINK | URL
	Action *string `type:"string" enum:"Action"`

	// The message body of the notification, the email body or the text message.
	Body *string `type:"string"`

	// Optional. Arbitrary string used to indicate multiple messages are logically
	// the same and that ADM is allowed to drop previously enqueued messages in
	// favor of this one.
	ConsolidationKey *string `type:"string"`

	// The data payload used for a silent push. This payload is added to the notifications'
	// data.pinpoint.jsonBody' object
	Data map[string]*string `type:"map"`

	// Optional. Number of seconds ADM should retain the message if the device is
	// offline
	ExpiresAfter *string `type:"string"`

	// The icon image name of the asset saved in your application.
	IconReference *string `type:"string"`

	// The URL that points to an image used as the large icon to the notification
	// content view.
	ImageIconUrl *string `type:"string"`

	// The URL that points to an image used in the push notification.
	ImageUrl *string `type:"string"`

	// Optional. Base-64-encoded MD5 checksum of the data parameter. Used to verify
	// data integrity
	MD5 *string `type:"string"`

	// The Raw JSON formatted string to be used as the payload. This value overrides
	// the message.
	RawContent *string `type:"string"`

	// Indicates if the message should display on the users device. Silent pushes
	// can be used for Remote Configuration and Phone Home use cases.
	SilentPush *bool `type:"boolean"`

	// The URL that points to an image used as the small icon for the notification
	// which will be used to represent the notification in the status bar and content
	// view
	SmallImageIconUrl *string `type:"string"`

	// Indicates a sound to play when the device receives the notification. Supports
	// default, or the filename of a sound resource bundled in the app. Android
	// sound files must reside in /res/raw/
	Sound *string `type:"string"`

	Substitutions map[string][]*string `type:"map"`

	// The message title that displays above the message on the user's device.
	Title *string `type:"string"`

	// The URL to open in the user's mobile browser. Used if the value for Action
	// is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s ADMMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ADMMessage) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *ADMMessage) SetAction(v string) *ADMMessage {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *ADMMessage) SetBody(v string) *ADMMessage {
	s.Body = &v
	return s
}

// SetConsolidationKey sets the ConsolidationKey field's value.
func (s *ADMMessage) SetConsolidationKey(v string) *ADMMessage {
	s.ConsolidationKey = &v
	return s
}

// SetData sets the Data field's value.
func (s *ADMMessage) SetData(v map[string]*string) *ADMMessage {
	s.Data = v
	return s
}

// SetExpiresAfter sets the ExpiresAfter field's value.
func (s *ADMMessage) SetExpiresAfter(v string) *ADMMessage {
	s.ExpiresAfter = &v
	return s
}

// SetIconReference sets the IconReference field's value.
func (s *ADMMessage) SetIconReference(v string) *ADMMessage {
	s.IconReference = &v
	return s
}

// SetImageIconUrl sets the ImageIconUrl field's value.
func (s *ADMMessage) SetImageIconUrl(v string) *ADMMessage {
	s.ImageIconUrl = &v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *ADMMessage) SetImageUrl(v string) *ADMMessage {
	s.ImageUrl = &v
	return s
}

// SetMD5 sets the MD5 field's value.
func (s *ADMMessage) SetMD5(v string) *ADMMessage {
	s.MD5 = &v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *ADMMessage) SetRawContent(v string) *ADMMessage {
	s.RawContent = &v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *ADMMessage) SetSilentPush(v bool) *ADMMessage {
	s.SilentPush = &v
	return s
}

// SetSmallImageIconUrl sets the SmallImageIconUrl field's value.
func (s *ADMMessage) SetSmallImageIconUrl(v string) *ADMMessage {
	s.SmallImageIconUrl = &v
	return s
}

// SetSound sets the Sound field's value.
func (s *ADMMessage) SetSound(v string) *ADMMessage {
	s.Sound = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *ADMMessage) SetSubstitutions(v map[string][]*string) *ADMMessage {
	s.Substitutions = v
	return s
}

// SetTitle sets the Title field's value.
func (s *ADMMessage) SetTitle(v string) *ADMMessage {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *ADMMessage) SetUrl(v string) *ADMMessage {
	s.Url = &v
	return s
}

// Apple Push Notification Service channel definition.
type APNSChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle id used for APNs Tokens.
	BundleId *string `type:"string"`

	// The distribution certificate from Apple.
	Certificate *string `type:"string"`

	// The default authentication method used for APNs.
	DefaultAuthenticationMethod *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// The certificate private key.
	PrivateKey *string `type:"string"`

	// The team id used for APNs Tokens.
	TeamId *string `type:"string"`

	// The token key used for APNs Tokens.
	TokenKey *string `type:"string"`

	// The token key used for APNs Tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSChannelRequest) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *APNSChannelRequest) SetBundleId(v string) *APNSChannelRequest {
	s.BundleId = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *APNSChannelRequest) SetCertificate(v string) *APNSChannelRequest {
	s.Certificate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSChannelRequest) SetDefaultAuthenticationMethod(v string) *APNSChannelRequest {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSChannelRequest) SetEnabled(v bool) *APNSChannelRequest {
	s.Enabled = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *APNSChannelRequest) SetPrivateKey(v string) *APNSChannelRequest {
	s.PrivateKey = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *APNSChannelRequest) SetTeamId(v string) *APNSChannelRequest {
	s.TeamId = &v
	return s
}

// SetTokenKey sets the TokenKey field's value.
func (s *APNSChannelRequest) SetTokenKey(v string) *APNSChannelRequest {
	s.TokenKey = &v
	return s
}

// SetTokenKeyId sets the TokenKeyId field's value.
func (s *APNSChannelRequest) SetTokenKeyId(v string) *APNSChannelRequest {
	s.TokenKeyId = &v
	return s
}

// Apple Distribution Push Notification Service channel definition.
type APNSChannelResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the application to which the channel applies.
	ApplicationId *string `type:"string"`

	// When was this segment created
	CreationDate *string `type:"string"`

	// The default authentication method used for APNs.
	DefaultAuthenticationMethod *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// Indicates whether the channel is configured with APNs credentials. Amazon
	// Pinpoint uses your credentials to authenticate push notifications with APNs.
	// To use APNs token authentication, set the BundleId, TeamId, TokenKey, and
	// TokenKeyId attributes. To use certificate authentication, set the Certificate
	// and PrivateKey attributes.
	HasCredential *bool `type:"boolean"`

	// Indicates whether the channel is configured with a key for APNs token authentication.
	// Provide a token key by setting the TokenKey attribute.
	HasTokenKey *bool `type:"boolean"`

	// Channel ID. Not used. Present only for backwards compatibility.
	Id *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who last updated this entry
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// The platform type. Will be APNS.
	Platform *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *APNSChannelResponse) SetApplicationId(v string) *APNSChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *APNSChannelResponse) SetCreationDate(v string) *APNSChannelResponse {
	s.CreationDate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSChannelResponse) SetDefaultAuthenticationMethod(v string) *APNSChannelResponse {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSChannelResponse) SetEnabled(v bool) *APNSChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *APNSChannelResponse) SetHasCredential(v bool) *APNSChannelResponse {
	s.HasCredential = &v
	return s
}

// SetHasTokenKey sets the HasTokenKey field's value.
func (s *APNSChannelResponse) SetHasTokenKey(v bool) *APNSChannelResponse {
	s.HasTokenKey = &v
	return s
}

// SetId sets the Id field's value.
func (s *APNSChannelResponse) SetId(v string) *APNSChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *APNSChannelResponse) SetIsArchived(v bool) *APNSChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *APNSChannelResponse) SetLastModifiedBy(v string) *APNSChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *APNSChannelResponse) SetLastModifiedDate(v string) *APNSChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *APNSChannelResponse) SetPlatform(v string) *APNSChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *APNSChannelResponse) SetVersion(v int64) *APNSChannelResponse {
	s.Version = &v
	return s
}

// APNS Message.
type APNSMessage struct {
	_ struct{} `type:"structure"`

	// The action that occurs if the user taps a push notification delivered by
	// the campaign: OPEN_APP - Your app launches, or it becomes the foreground
	// app if it has been sent to the background. This is the default action. DEEP_LINK
	// - Uses deep linking features in iOS and Android to open your app and display
	// a designated user interface within the app. URL - The default mobile browser
	// on the user's device launches and opens a web page at the URL you specify.
	// Possible values include: OPEN_APP | DEEP_LINK | URL
	Action *string `type:"string" enum:"Action"`

	// Include this key when you want the system to modify the badge of your app
	// icon. If this key is not included in the dictionary, the badge is not changed.
	// To remove the badge, set the value of this key to 0.
	Badge *int64 `type:"integer"`

	// The message body of the notification, the email body or the text message.
	Body *string `type:"string"`

	// Provide this key with a string value that represents the notification's type.
	// This value corresponds to the value in the identifier property of one of
	// your app's registered categories.
	Category *string `type:"string"`

	// An ID that, if assigned to multiple messages, causes APNs to coalesce the
	// messages into a single push notification instead of delivering each message
	// individually. The value must not exceed 64 bytes. Amazon Pinpoint uses this
	// value to set the apns-collapse-id request header when it sends the message
	// to APNs.
	CollapseId *string `type:"string"`

	// The data payload used for a silent push. This payload is added to the notifications'
	// data.pinpoint.jsonBody' object
	Data map[string]*string `type:"map"`

	// The URL that points to a video used in the push notification.
	MediaUrl *string `type:"string"`

	// The preferred authentication method, either "CERTIFICATE" or "TOKEN"
	PreferredAuthenticationMethod *string `type:"string"`

	// The message priority. Amazon Pinpoint uses this value to set the apns-priority
	// request header when it sends the message to APNs. Accepts the following values:"5"
	// - Low priority. Messages might be delayed, delivered in groups, and throttled."10"
	// - High priority. Messages are sent immediately. High priority messages must
	// cause an alert, sound, or badge on the receiving device.The default value
	// is "10".The equivalent values for FCM or GCM messages are "normal" and "high".
	// Amazon Pinpoint accepts these values for APNs messages and converts them.For
	// more information about the apns-priority parameter, see Communicating with
	// APNs in the APNs Local and Remote Notification Programming Guide.
	Priority *string `type:"string"`

	// The Raw JSON formatted string to be used as the payload. This value overrides
	// the message.
	RawContent *string `type:"string"`

	// Indicates if the message should display on the users device. Silent pushes
	// can be used for Remote Configuration and Phone Home use cases.
	SilentPush *bool `type:"boolean"`

	// Include this key when you want the system to play a sound. The value of this
	// key is the name of a sound file in your app's main bundle or in the Library/Sounds
	// folder of your app's data container. If the sound file cannot be found, or
	// if you specify defaultfor the value, the system plays the default alert sound.
	Sound *string `type:"string"`

	Substitutions map[string][]*string `type:"map"`

	// Provide this key with a string value that represents the app-specific identifier
	// for grouping notifications. If you provide a Notification Content app extension,
	// you can use this value to group your notifications together.
	ThreadId *string `type:"string"`

	// The length of time (in seconds) that APNs stores and attempts to deliver
	// the message. If the value is 0, APNs does not store the message or attempt
	// to deliver it more than once. Amazon Pinpoint uses this value to set the
	// apns-expiration request header when it sends the message to APNs.
	TimeToLive *int64 `type:"integer"`

	// The message title that displays above the message on the user's device.
	Title *string `type:"string"`

	// The URL to open in the user's mobile browser. Used if the value for Action
	// is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s APNSMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSMessage) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *APNSMessage) SetAction(v string) *APNSMessage {
	s.Action = &v
	return s
}

// SetBadge sets the Badge field's value.
func (s *APNSMessage) SetBadge(v int64) *APNSMessage {
	s.Badge = &v
	return s
}

// SetBody sets the Body field's value.
func (s *APNSMessage) SetBody(v string) *APNSMessage {
	s.Body = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *APNSMessage) SetCategory(v string) *APNSMessage {
	s.Category = &v
	return s
}

// SetCollapseId sets the CollapseId field's value.
func (s *APNSMessage) SetCollapseId(v string) *APNSMessage {
	s.CollapseId = &v
	return s
}

// SetData sets the Data field's value.
func (s *APNSMessage) SetData(v map[string]*string) *APNSMessage {
	s.Data = v
	return s
}

// SetMediaUrl sets the MediaUrl field's value.
func (s *APNSMessage) SetMediaUrl(v string) *APNSMessage {
	s.MediaUrl = &v
	return s
}

// SetPreferredAuthenticationMethod sets the PreferredAuthenticationMethod field's value.
func (s *APNSMessage) SetPreferredAuthenticationMethod(v string) *APNSMessage {
	s.PreferredAuthenticationMethod = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *APNSMessage) SetPriority(v string) *APNSMessage {
	s.Priority = &v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *APNSMessage) SetRawContent(v string) *APNSMessage {
	s.RawContent = &v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *APNSMessage) SetSilentPush(v bool) *APNSMessage {
	s.SilentPush = &v
	return s
}

// SetSound sets the Sound field's value.
func (s *APNSMessage) SetSound(v string) *APNSMessage {
	s.Sound = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *APNSMessage) SetSubstitutions(v map[string][]*string) *APNSMessage {
	s.Substitutions = v
	return s
}

// SetThreadId sets the ThreadId field's value.
func (s *APNSMessage) SetThreadId(v string) *APNSMessage {
	s.ThreadId = &v
	return s
}

// SetTimeToLive sets the TimeToLive field's value.
func (s *APNSMessage) SetTimeToLive(v int64) *APNSMessage {
	s.TimeToLive = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *APNSMessage) SetTitle(v string) *APNSMessage {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *APNSMessage) SetUrl(v string) *APNSMessage {
	s.Url = &v
	return s
}

// Apple Development Push Notification Service channel definition.
type APNSSandboxChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle id used for APNs Tokens.
	BundleId *string `type:"string"`

	// The distribution certificate from Apple.
	Certificate *string `type:"string"`

	// The default authentication method used for APNs.
	DefaultAuthenticationMethod *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// The certificate private key.
	PrivateKey *string `type:"string"`

	// The team id used for APNs Tokens.
	TeamId *string `type:"string"`

	// The token key used for APNs Tokens.
	TokenKey *string `type:"string"`

	// The token key used for APNs Tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSSandboxChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSSandboxChannelRequest) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *APNSSandboxChannelRequest) SetBundleId(v string) *APNSSandboxChannelRequest {
	s.BundleId = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *APNSSandboxChannelRequest) SetCertificate(v string) *APNSSandboxChannelRequest {
	s.Certificate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSSandboxChannelRequest) SetDefaultAuthenticationMethod(v string) *APNSSandboxChannelRequest {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSSandboxChannelRequest) SetEnabled(v bool) *APNSSandboxChannelRequest {
	s.Enabled = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *APNSSandboxChannelRequest) SetPrivateKey(v string) *APNSSandboxChannelRequest {
	s.PrivateKey = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *APNSSandboxChannelRequest) SetTeamId(v string) *APNSSandboxChannelRequest {
	s.TeamId = &v
	return s
}

// SetTokenKey sets the TokenKey field's value.
func (s *APNSSandboxChannelRequest) SetTokenKey(v string) *APNSSandboxChannelRequest {
	s.TokenKey = &v
	return s
}

// SetTokenKeyId sets the TokenKeyId field's value.
func (s *APNSSandboxChannelRequest) SetTokenKeyId(v string) *APNSSandboxChannelRequest {
	s.TokenKeyId = &v
	return s
}

// Apple Development Push Notification Service channel definition.
type APNSSandboxChannelResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the application to which the channel applies.
	ApplicationId *string `type:"string"`

	// When was this segment created
	CreationDate *string `type:"string"`

	// The default authentication method used for APNs.
	DefaultAuthenticationMethod *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// Indicates whether the channel is configured with APNs credentials. Amazon
	// Pinpoint uses your credentials to authenticate push notifications with APNs.
	// To use APNs token authentication, set the BundleId, TeamId, TokenKey, and
	// TokenKeyId attributes. To use certificate authentication, set the Certificate
	// and PrivateKey attributes.
	HasCredential *bool `type:"boolean"`

	// Indicates whether the channel is configured with a key for APNs token authentication.
	// Provide a token key by setting the TokenKey attribute.
	HasTokenKey *bool `type:"boolean"`

	// Channel ID. Not used, only for backwards compatibility.
	Id *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who last updated this entry
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// The platform type. Will be APNS_SANDBOX.
	Platform *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSSandboxChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSSandboxChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *APNSSandboxChannelResponse) SetApplicationId(v string) *APNSSandboxChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *APNSSandboxChannelResponse) SetCreationDate(v string) *APNSSandboxChannelResponse {
	s.CreationDate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSSandboxChannelResponse) SetDefaultAuthenticationMethod(v string) *APNSSandboxChannelResponse {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSSandboxChannelResponse) SetEnabled(v bool) *APNSSandboxChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *APNSSandboxChannelResponse) SetHasCredential(v bool) *APNSSandboxChannelResponse {
	s.HasCredential = &v
	return s
}

// SetHasTokenKey sets the HasTokenKey field's value.
func (s *APNSSandboxChannelResponse) SetHasTokenKey(v bool) *APNSSandboxChannelResponse {
	s.HasTokenKey = &v
	return s
}

// SetId sets the Id field's value.
func (s *APNSSandboxChannelResponse) SetId(v string) *APNSSandboxChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *APNSSandboxChannelResponse) SetIsArchived(v bool) *APNSSandboxChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *APNSSandboxChannelResponse) SetLastModifiedBy(v string) *APNSSandboxChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *APNSSandboxChannelResponse) SetLastModifiedDate(v string) *APNSSandboxChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *APNSSandboxChannelResponse) SetPlatform(v string) *APNSSandboxChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *APNSSandboxChannelResponse) SetVersion(v int64) *APNSSandboxChannelResponse {
	s.Version = &v
	return s
}

// Apple VoIP Push Notification Service channel definition.
type APNSVoipChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle id used for APNs Tokens.
	BundleId *string `type:"string"`

	// The distribution certificate from Apple.
	Certificate *string `type:"string"`

	// The default authentication method used for APNs.
	DefaultAuthenticationMethod *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// The certificate private key.
	PrivateKey *string `type:"string"`

	// The team id used for APNs Tokens.
	TeamId *string `type:"string"`

	// The token key used for APNs Tokens.
	TokenKey *string `type:"string"`

	// The token key used for APNs Tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSVoipChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSVoipChannelRequest) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *APNSVoipChannelRequest) SetBundleId(v string) *APNSVoipChannelRequest {
	s.BundleId = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *APNSVoipChannelRequest) SetCertificate(v string) *APNSVoipChannelRequest {
	s.Certificate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSVoipChannelRequest) SetDefaultAuthenticationMethod(v string) *APNSVoipChannelRequest {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSVoipChannelRequest) SetEnabled(v bool) *APNSVoipChannelRequest {
	s.Enabled = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *APNSVoipChannelRequest) SetPrivateKey(v string) *APNSVoipChannelRequest {
	s.PrivateKey = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *APNSVoipChannelRequest) SetTeamId(v string) *APNSVoipChannelRequest {
	s.TeamId = &v
	return s
}

// SetTokenKey sets the TokenKey field's value.
func (s *APNSVoipChannelRequest) SetTokenKey(v string) *APNSVoipChannelRequest {
	s.TokenKey = &v
	return s
}

// SetTokenKeyId sets the TokenKeyId field's value.
func (s *APNSVoipChannelRequest) SetTokenKeyId(v string) *APNSVoipChannelRequest {
	s.TokenKeyId = &v
	return s
}

// Apple VoIP Push Notification Service channel definition.
type APNSVoipChannelResponse struct {
	_ struct{} `type:"structure"`

	// Application id
	ApplicationId *string `type:"string"`

	// When was this segment created
	CreationDate *string `type:"string"`

	// The default authentication method used for APNs.
	DefaultAuthenticationMethod *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// If the channel is registered with a credential for authentication.
	HasCredential *bool `type:"boolean"`

	// If the channel is registered with a token key for authentication.
	HasTokenKey *bool `type:"boolean"`

	// Channel ID. Not used, only for backwards compatibility.
	Id *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who made the last change
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// The platform type. Will be APNS.
	Platform *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSVoipChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSVoipChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *APNSVoipChannelResponse) SetApplicationId(v string) *APNSVoipChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *APNSVoipChannelResponse) SetCreationDate(v string) *APNSVoipChannelResponse {
	s.CreationDate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSVoipChannelResponse) SetDefaultAuthenticationMethod(v string) *APNSVoipChannelResponse {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSVoipChannelResponse) SetEnabled(v bool) *APNSVoipChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *APNSVoipChannelResponse) SetHasCredential(v bool) *APNSVoipChannelResponse {
	s.HasCredential = &v
	return s
}

// SetHasTokenKey sets the HasTokenKey field's value.
func (s *APNSVoipChannelResponse) SetHasTokenKey(v bool) *APNSVoipChannelResponse {
	s.HasTokenKey = &v
	return s
}

// SetId sets the Id field's value.
func (s *APNSVoipChannelResponse) SetId(v string) *APNSVoipChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *APNSVoipChannelResponse) SetIsArchived(v bool) *APNSVoipChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *APNSVoipChannelResponse) SetLastModifiedBy(v string) *APNSVoipChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *APNSVoipChannelResponse) SetLastModifiedDate(v string) *APNSVoipChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *APNSVoipChannelResponse) SetPlatform(v string) *APNSVoipChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *APNSVoipChannelResponse) SetVersion(v int64) *APNSVoipChannelResponse {
	s.Version = &v
	return s
}

// Apple VoIP Developer Push Notification Service channel definition.
type APNSVoipSandboxChannelRequest struct {
	_ struct{} `type:"structure"`

	// The bundle id used for APNs Tokens.
	BundleId *string `type:"string"`

	// The distribution certificate from Apple.
	Certificate *string `type:"string"`

	// The default authentication method used for APNs.
	DefaultAuthenticationMethod *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// The certificate private key.
	PrivateKey *string `type:"string"`

	// The team id used for APNs Tokens.
	TeamId *string `type:"string"`

	// The token key used for APNs Tokens.
	TokenKey *string `type:"string"`

	// The token key used for APNs Tokens.
	TokenKeyId *string `type:"string"`
}

// String returns the string representation
func (s APNSVoipSandboxChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSVoipSandboxChannelRequest) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *APNSVoipSandboxChannelRequest) SetBundleId(v string) *APNSVoipSandboxChannelRequest {
	s.BundleId = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *APNSVoipSandboxChannelRequest) SetCertificate(v string) *APNSVoipSandboxChannelRequest {
	s.Certificate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSVoipSandboxChannelRequest) SetDefaultAuthenticationMethod(v string) *APNSVoipSandboxChannelRequest {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSVoipSandboxChannelRequest) SetEnabled(v bool) *APNSVoipSandboxChannelRequest {
	s.Enabled = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *APNSVoipSandboxChannelRequest) SetPrivateKey(v string) *APNSVoipSandboxChannelRequest {
	s.PrivateKey = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *APNSVoipSandboxChannelRequest) SetTeamId(v string) *APNSVoipSandboxChannelRequest {
	s.TeamId = &v
	return s
}

// SetTokenKey sets the TokenKey field's value.
func (s *APNSVoipSandboxChannelRequest) SetTokenKey(v string) *APNSVoipSandboxChannelRequest {
	s.TokenKey = &v
	return s
}

// SetTokenKeyId sets the TokenKeyId field's value.
func (s *APNSVoipSandboxChannelRequest) SetTokenKeyId(v string) *APNSVoipSandboxChannelRequest {
	s.TokenKeyId = &v
	return s
}

// Apple VoIP Developer Push Notification Service channel definition.
type APNSVoipSandboxChannelResponse struct {
	_ struct{} `type:"structure"`

	// Application id
	ApplicationId *string `type:"string"`

	// When was this segment created
	CreationDate *string `type:"string"`

	// The default authentication method used for APNs.
	DefaultAuthenticationMethod *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// If the channel is registered with a credential for authentication.
	HasCredential *bool `type:"boolean"`

	// If the channel is registered with a token key for authentication.
	HasTokenKey *bool `type:"boolean"`

	// Channel ID. Not used, only for backwards compatibility.
	Id *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who made the last change
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// The platform type. Will be APNS.
	Platform *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s APNSVoipSandboxChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s APNSVoipSandboxChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *APNSVoipSandboxChannelResponse) SetApplicationId(v string) *APNSVoipSandboxChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *APNSVoipSandboxChannelResponse) SetCreationDate(v string) *APNSVoipSandboxChannelResponse {
	s.CreationDate = &v
	return s
}

// SetDefaultAuthenticationMethod sets the DefaultAuthenticationMethod field's value.
func (s *APNSVoipSandboxChannelResponse) SetDefaultAuthenticationMethod(v string) *APNSVoipSandboxChannelResponse {
	s.DefaultAuthenticationMethod = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *APNSVoipSandboxChannelResponse) SetEnabled(v bool) *APNSVoipSandboxChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *APNSVoipSandboxChannelResponse) SetHasCredential(v bool) *APNSVoipSandboxChannelResponse {
	s.HasCredential = &v
	return s
}

// SetHasTokenKey sets the HasTokenKey field's value.
func (s *APNSVoipSandboxChannelResponse) SetHasTokenKey(v bool) *APNSVoipSandboxChannelResponse {
	s.HasTokenKey = &v
	return s
}

// SetId sets the Id field's value.
func (s *APNSVoipSandboxChannelResponse) SetId(v string) *APNSVoipSandboxChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *APNSVoipSandboxChannelResponse) SetIsArchived(v bool) *APNSVoipSandboxChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *APNSVoipSandboxChannelResponse) SetLastModifiedBy(v string) *APNSVoipSandboxChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *APNSVoipSandboxChannelResponse) SetLastModifiedDate(v string) *APNSVoipSandboxChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *APNSVoipSandboxChannelResponse) SetPlatform(v string) *APNSVoipSandboxChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *APNSVoipSandboxChannelResponse) SetVersion(v int64) *APNSVoipSandboxChannelResponse {
	s.Version = &v
	return s
}

// Activities for campaign.
type ActivitiesResponse struct {
	_ struct{} `type:"structure"`

	// List of campaign activities
	Item []*ActivityResponse `type:"list"`
}

// String returns the string representation
func (s ActivitiesResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivitiesResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *ActivitiesResponse) SetItem(v []*ActivityResponse) *ActivitiesResponse {
	s.Item = v
	return s
}

// Activity definition
type ActivityResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the application to which the campaign applies.
	ApplicationId *string `type:"string"`

	// The ID of the campaign to which the activity applies.
	CampaignId *string `type:"string"`

	// The actual time the activity was marked CANCELLED or COMPLETED. Provided
	// in ISO 8601 format.
	End *string `type:"string"`

	// The unique activity ID.
	Id *string `type:"string"`

	// Indicates whether the activity succeeded.Valid values: SUCCESS, FAIL
	Result *string `type:"string"`

	// The scheduled start time for the activity in ISO 8601 format.
	ScheduledStart *string `type:"string"`

	// The actual start time of the activity in ISO 8601 format.
	Start *string `type:"string"`

	// The state of the activity.Valid values: PENDING, INITIALIZING, RUNNING, PAUSED,
	// CANCELLED, COMPLETED
	State *string `type:"string"`

	// The total number of endpoints to which the campaign successfully delivered
	// messages.
	SuccessfulEndpointCount *int64 `type:"integer"`

	// The total number of timezones completed.
	TimezonesCompletedCount *int64 `type:"integer"`

	// The total number of unique timezones present in the segment.
	TimezonesTotalCount *int64 `type:"integer"`

	// The total number of endpoints to which the campaign attempts to deliver messages.
	TotalEndpointCount *int64 `type:"integer"`

	// The ID of a variation of the campaign used for A/B testing.
	TreatmentId *string `type:"string"`
}

// String returns the string representation
func (s ActivityResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ActivityResponse) SetApplicationId(v string) *ActivityResponse {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *ActivityResponse) SetCampaignId(v string) *ActivityResponse {
	s.CampaignId = &v
	return s
}

// SetEnd sets the End field's value.
func (s *ActivityResponse) SetEnd(v string) *ActivityResponse {
	s.End = &v
	return s
}

// SetId sets the Id field's value.
func (s *ActivityResponse) SetId(v string) *ActivityResponse {
	s.Id = &v
	return s
}

// SetResult sets the Result field's value.
func (s *ActivityResponse) SetResult(v string) *ActivityResponse {
	s.Result = &v
	return s
}

// SetScheduledStart sets the ScheduledStart field's value.
func (s *ActivityResponse) SetScheduledStart(v string) *ActivityResponse {
	s.ScheduledStart = &v
	return s
}

// SetStart sets the Start field's value.
func (s *ActivityResponse) SetStart(v string) *ActivityResponse {
	s.Start = &v
	return s
}

// SetState sets the State field's value.
func (s *ActivityResponse) SetState(v string) *ActivityResponse {
	s.State = &v
	return s
}

// SetSuccessfulEndpointCount sets the SuccessfulEndpointCount field's value.
func (s *ActivityResponse) SetSuccessfulEndpointCount(v int64) *ActivityResponse {
	s.SuccessfulEndpointCount = &v
	return s
}

// SetTimezonesCompletedCount sets the TimezonesCompletedCount field's value.
func (s *ActivityResponse) SetTimezonesCompletedCount(v int64) *ActivityResponse {
	s.TimezonesCompletedCount = &v
	return s
}

// SetTimezonesTotalCount sets the TimezonesTotalCount field's value.
func (s *ActivityResponse) SetTimezonesTotalCount(v int64) *ActivityResponse {
	s.TimezonesTotalCount = &v
	return s
}

// SetTotalEndpointCount sets the TotalEndpointCount field's value.
func (s *ActivityResponse) SetTotalEndpointCount(v int64) *ActivityResponse {
	s.TotalEndpointCount = &v
	return s
}

// SetTreatmentId sets the TreatmentId field's value.
func (s *ActivityResponse) SetTreatmentId(v string) *ActivityResponse {
	s.TreatmentId = &v
	return s
}

// Address configuration.
type AddressConfiguration struct {
	_ struct{} `type:"structure"`

	// Body override. If specified will override default body.
	BodyOverride *string `type:"string"`

	// The channel type.Valid values: GCM | APNS | APNS_SANDBOX | APNS_VOIP | APNS_VOIP_SANDBOX
	// | ADM | SMS | EMAIL | BAIDU
	ChannelType *string `type:"string" enum:"ChannelType"`

	// A map of custom attributes to attributes to be attached to the message for
	// this address. This payload is added to the push notification's 'data.pinpoint'
	// object or added to the email/sms delivery receipt event attributes.
	Context map[string]*string `type:"map"`

	// The Raw JSON formatted string to be used as the payload. This value overrides
	// the message.
	RawContent *string `type:"string"`

	Substitutions map[string][]*string `type:"map"`

	// Title override. If specified will override default title if applicable.
	TitleOverride *string `type:"string"`
}

// String returns the string representation
func (s AddressConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddressConfiguration) GoString() string {
	return s.String()
}

// SetBodyOverride sets the BodyOverride field's value.
func (s *AddressConfiguration) SetBodyOverride(v string) *AddressConfiguration {
	s.BodyOverride = &v
	return s
}

// SetChannelType sets the ChannelType field's value.
func (s *AddressConfiguration) SetChannelType(v string) *AddressConfiguration {
	s.ChannelType = &v
	return s
}

// SetContext sets the Context field's value.
func (s *AddressConfiguration) SetContext(v map[string]*string) *AddressConfiguration {
	s.Context = v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *AddressConfiguration) SetRawContent(v string) *AddressConfiguration {
	s.RawContent = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *AddressConfiguration) SetSubstitutions(v map[string][]*string) *AddressConfiguration {
	s.Substitutions = v
	return s
}

// SetTitleOverride sets the TitleOverride field's value.
func (s *AddressConfiguration) SetTitleOverride(v string) *AddressConfiguration {
	s.TitleOverride = &v
	return s
}

// Application Response.
type ApplicationResponse struct {
	_ struct{} `type:"structure"`

	// The unique application ID.
	Id *string `type:"string"`

	// The display name of the application.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ApplicationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationResponse) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ApplicationResponse) SetId(v string) *ApplicationResponse {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ApplicationResponse) SetName(v string) *ApplicationResponse {
	s.Name = &v
	return s
}

// Application settings.
type ApplicationSettingsResource struct {
	_ struct{} `type:"structure"`

	// The unique ID for the application.
	ApplicationId *string `type:"string"`

	// Default campaign hook.
	CampaignHook *CampaignHook `type:"structure"`

	// The date that the settings were last updated in ISO 8601 format.
	LastModifiedDate *string `type:"string"`

	// The default campaign limits for the app. These limits apply to each campaign
	// for the app, unless the campaign overrides the default with limits of its
	// own.
	Limits *CampaignLimits `type:"structure"`

	// The default quiet time for the app. Each campaign for this app sends no messages
	// during this time unless the campaign overrides the default with a quiet time
	// of its own.
	QuietTime *QuietTime `type:"structure"`
}

// String returns the string representation
func (s ApplicationSettingsResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationSettingsResource) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ApplicationSettingsResource) SetApplicationId(v string) *ApplicationSettingsResource {
	s.ApplicationId = &v
	return s
}

// SetCampaignHook sets the CampaignHook field's value.
func (s *ApplicationSettingsResource) SetCampaignHook(v *CampaignHook) *ApplicationSettingsResource {
	s.CampaignHook = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *ApplicationSettingsResource) SetLastModifiedDate(v string) *ApplicationSettingsResource {
	s.LastModifiedDate = &v
	return s
}

// SetLimits sets the Limits field's value.
func (s *ApplicationSettingsResource) SetLimits(v *CampaignLimits) *ApplicationSettingsResource {
	s.Limits = v
	return s
}

// SetQuietTime sets the QuietTime field's value.
func (s *ApplicationSettingsResource) SetQuietTime(v *QuietTime) *ApplicationSettingsResource {
	s.QuietTime = v
	return s
}

// Get Applications Result.
type ApplicationsResponse struct {
	_ struct{} `type:"structure"`

	// List of applications returned in this page.
	Item []*ApplicationResponse `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ApplicationsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *ApplicationsResponse) SetItem(v []*ApplicationResponse) *ApplicationsResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ApplicationsResponse) SetNextToken(v string) *ApplicationsResponse {
	s.NextToken = &v
	return s
}

// Custom attibute dimension
type AttributeDimension struct {
	_ struct{} `type:"structure"`

	// The type of dimension:INCLUSIVE - Endpoints that match the criteria are included
	// in the segment.EXCLUSIVE - Endpoints that match the criteria are excluded
	// from the segment.
	AttributeType *string `type:"string" enum:"AttributeType"`

	Values []*string `type:"list"`
}

// String returns the string representation
func (s AttributeDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeDimension) GoString() string {
	return s.String()
}

// SetAttributeType sets the AttributeType field's value.
func (s *AttributeDimension) SetAttributeType(v string) *AttributeDimension {
	s.AttributeType = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AttributeDimension) SetValues(v []*string) *AttributeDimension {
	s.Values = v
	return s
}

// Baidu Cloud Push credentials
type BaiduChannelRequest struct {
	_ struct{} `type:"structure"`

	// Platform credential API key from Baidu.
	ApiKey *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// Platform credential Secret key from Baidu.
	SecretKey *string `type:"string"`
}

// String returns the string representation
func (s BaiduChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BaiduChannelRequest) GoString() string {
	return s.String()
}

// SetApiKey sets the ApiKey field's value.
func (s *BaiduChannelRequest) SetApiKey(v string) *BaiduChannelRequest {
	s.ApiKey = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *BaiduChannelRequest) SetEnabled(v bool) *BaiduChannelRequest {
	s.Enabled = &v
	return s
}

// SetSecretKey sets the SecretKey field's value.
func (s *BaiduChannelRequest) SetSecretKey(v string) *BaiduChannelRequest {
	s.SecretKey = &v
	return s
}

// Baidu Cloud Messaging channel definition
type BaiduChannelResponse struct {
	_ struct{} `type:"structure"`

	// Application id
	ApplicationId *string `type:"string"`

	// When was this segment created
	CreationDate *string `type:"string"`

	// The Baidu API key from Baidu.
	Credential *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// Indicates whether the channel is configured with Baidu Cloud Push credentials.
	// Amazon Pinpoint uses your credentials to authenticate push notifications
	// with Baidu Cloud Push. Provide your credentials by setting the ApiKey and
	// SecretKey attributes.
	HasCredential *bool `type:"boolean"`

	// Channel ID. Not used, only for backwards compatibility.
	Id *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who made the last change
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// The platform type. Will be BAIDU
	Platform *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s BaiduChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BaiduChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *BaiduChannelResponse) SetApplicationId(v string) *BaiduChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *BaiduChannelResponse) SetCreationDate(v string) *BaiduChannelResponse {
	s.CreationDate = &v
	return s
}

// SetCredential sets the Credential field's value.
func (s *BaiduChannelResponse) SetCredential(v string) *BaiduChannelResponse {
	s.Credential = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *BaiduChannelResponse) SetEnabled(v bool) *BaiduChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *BaiduChannelResponse) SetHasCredential(v bool) *BaiduChannelResponse {
	s.HasCredential = &v
	return s
}

// SetId sets the Id field's value.
func (s *BaiduChannelResponse) SetId(v string) *BaiduChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *BaiduChannelResponse) SetIsArchived(v bool) *BaiduChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *BaiduChannelResponse) SetLastModifiedBy(v string) *BaiduChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *BaiduChannelResponse) SetLastModifiedDate(v string) *BaiduChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *BaiduChannelResponse) SetPlatform(v string) *BaiduChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *BaiduChannelResponse) SetVersion(v int64) *BaiduChannelResponse {
	s.Version = &v
	return s
}

// Baidu Message.
type BaiduMessage struct {
	_ struct{} `type:"structure"`

	// The action that occurs if the user taps a push notification delivered by
	// the campaign: OPEN_APP - Your app launches, or it becomes the foreground
	// app if it has been sent to the background. This is the default action. DEEP_LINK
	// - Uses deep linking features in iOS and Android to open your app and display
	// a designated user interface within the app. URL - The default mobile browser
	// on the user's device launches and opens a web page at the URL you specify.
	// Possible values include: OPEN_APP | DEEP_LINK | URL
	Action *string `type:"string" enum:"Action"`

	// The message body of the notification, the email body or the text message.
	Body *string `type:"string"`

	// The data payload used for a silent push. This payload is added to the notifications'
	// data.pinpoint.jsonBody' object
	Data map[string]*string `type:"map"`

	// The icon image name of the asset saved in your application.
	IconReference *string `type:"string"`

	// The URL that points to an image used as the large icon to the notification
	// content view.
	ImageIconUrl *string `type:"string"`

	// The URL that points to an image used in the push notification.
	ImageUrl *string `type:"string"`

	// The Raw JSON formatted string to be used as the payload. This value overrides
	// the message.
	RawContent *string `type:"string"`

	// Indicates if the message should display on the users device. Silent pushes
	// can be used for Remote Configuration and Phone Home use cases.
	SilentPush *bool `type:"boolean"`

	// The URL that points to an image used as the small icon for the notification
	// which will be used to represent the notification in the status bar and content
	// view
	SmallImageIconUrl *string `type:"string"`

	// Indicates a sound to play when the device receives the notification. Supports
	// default, or the filename of a sound resource bundled in the app. Android
	// sound files must reside in /res/raw/
	Sound *string `type:"string"`

	Substitutions map[string][]*string `type:"map"`

	// The message title that displays above the message on the user's device.
	Title *string `type:"string"`

	// The URL to open in the user's mobile browser. Used if the value for Action
	// is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s BaiduMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BaiduMessage) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *BaiduMessage) SetAction(v string) *BaiduMessage {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *BaiduMessage) SetBody(v string) *BaiduMessage {
	s.Body = &v
	return s
}

// SetData sets the Data field's value.
func (s *BaiduMessage) SetData(v map[string]*string) *BaiduMessage {
	s.Data = v
	return s
}

// SetIconReference sets the IconReference field's value.
func (s *BaiduMessage) SetIconReference(v string) *BaiduMessage {
	s.IconReference = &v
	return s
}

// SetImageIconUrl sets the ImageIconUrl field's value.
func (s *BaiduMessage) SetImageIconUrl(v string) *BaiduMessage {
	s.ImageIconUrl = &v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *BaiduMessage) SetImageUrl(v string) *BaiduMessage {
	s.ImageUrl = &v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *BaiduMessage) SetRawContent(v string) *BaiduMessage {
	s.RawContent = &v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *BaiduMessage) SetSilentPush(v bool) *BaiduMessage {
	s.SilentPush = &v
	return s
}

// SetSmallImageIconUrl sets the SmallImageIconUrl field's value.
func (s *BaiduMessage) SetSmallImageIconUrl(v string) *BaiduMessage {
	s.SmallImageIconUrl = &v
	return s
}

// SetSound sets the Sound field's value.
func (s *BaiduMessage) SetSound(v string) *BaiduMessage {
	s.Sound = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *BaiduMessage) SetSubstitutions(v map[string][]*string) *BaiduMessage {
	s.Substitutions = v
	return s
}

// SetTitle sets the Title field's value.
func (s *BaiduMessage) SetTitle(v string) *BaiduMessage {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *BaiduMessage) SetUrl(v string) *BaiduMessage {
	s.Url = &v
	return s
}

// The email message configuration.
type CampaignEmailMessage struct {
	_ struct{} `type:"structure"`

	// The email text body.
	Body *string `type:"string"`

	// The email address used to send the email from. Defaults to use FromAddress
	// specified in the Email Channel.
	FromAddress *string `type:"string"`

	// The email html body.
	HtmlBody *string `type:"string"`

	// The email title (Or subject).
	Title *string `type:"string"`
}

// String returns the string representation
func (s CampaignEmailMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignEmailMessage) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *CampaignEmailMessage) SetBody(v string) *CampaignEmailMessage {
	s.Body = &v
	return s
}

// SetFromAddress sets the FromAddress field's value.
func (s *CampaignEmailMessage) SetFromAddress(v string) *CampaignEmailMessage {
	s.FromAddress = &v
	return s
}

// SetHtmlBody sets the HtmlBody field's value.
func (s *CampaignEmailMessage) SetHtmlBody(v string) *CampaignEmailMessage {
	s.HtmlBody = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *CampaignEmailMessage) SetTitle(v string) *CampaignEmailMessage {
	s.Title = &v
	return s
}

type CampaignHook struct {
	_ struct{} `type:"structure"`

	// Lambda function name or arn to be called for delivery
	LambdaFunctionName *string `type:"string"`

	// What mode Lambda should be invoked in.
	Mode *string `type:"string" enum:"Mode"`

	// Web URL to call for hook. If the URL has authentication specified it will
	// be added as authentication to the request
	WebUrl *string `type:"string"`
}

// String returns the string representation
func (s CampaignHook) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignHook) GoString() string {
	return s.String()
}

// SetLambdaFunctionName sets the LambdaFunctionName field's value.
func (s *CampaignHook) SetLambdaFunctionName(v string) *CampaignHook {
	s.LambdaFunctionName = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *CampaignHook) SetMode(v string) *CampaignHook {
	s.Mode = &v
	return s
}

// SetWebUrl sets the WebUrl field's value.
func (s *CampaignHook) SetWebUrl(v string) *CampaignHook {
	s.WebUrl = &v
	return s
}

// Campaign Limits are used to limit the number of messages that can be sent
// to a user.
type CampaignLimits struct {
	_ struct{} `type:"structure"`

	// The maximum number of messages that the campaign can send daily.
	Daily *int64 `type:"integer"`

	// The length of time (in seconds) that the campaign can run before it ends
	// and message deliveries stop. This duration begins at the scheduled start
	// time for the campaign. The minimum value is 60.
	MaximumDuration *int64 `type:"integer"`

	// The number of messages that the campaign can send per second. The minimum
	// value is 50, and the maximum is 20000.
	MessagesPerSecond *int64 `type:"integer"`

	// The maximum total number of messages that the campaign can send.
	Total *int64 `type:"integer"`
}

// String returns the string representation
func (s CampaignLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignLimits) GoString() string {
	return s.String()
}

// SetDaily sets the Daily field's value.
func (s *CampaignLimits) SetDaily(v int64) *CampaignLimits {
	s.Daily = &v
	return s
}

// SetMaximumDuration sets the MaximumDuration field's value.
func (s *CampaignLimits) SetMaximumDuration(v int64) *CampaignLimits {
	s.MaximumDuration = &v
	return s
}

// SetMessagesPerSecond sets the MessagesPerSecond field's value.
func (s *CampaignLimits) SetMessagesPerSecond(v int64) *CampaignLimits {
	s.MessagesPerSecond = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *CampaignLimits) SetTotal(v int64) *CampaignLimits {
	s.Total = &v
	return s
}

// Campaign definition
type CampaignResponse struct {
	_ struct{} `type:"structure"`

	// Treatments that are defined in addition to the default treatment.
	AdditionalTreatments []*TreatmentResource `type:"list"`

	// The ID of the application to which the campaign applies.
	ApplicationId *string `type:"string"`

	// The date the campaign was created in ISO 8601 format.
	CreationDate *string `type:"string"`

	// The status of the campaign's default treatment. Only present for A/B test
	// campaigns.
	DefaultState *CampaignState `type:"structure"`

	// A description of the campaign.
	Description *string `type:"string"`

	// The allocated percentage of end users who will not receive messages from
	// this campaign.
	HoldoutPercent *int64 `type:"integer"`

	// Campaign hook information.
	Hook *CampaignHook `type:"structure"`

	// The unique campaign ID.
	Id *string `type:"string"`

	// Indicates whether the campaign is paused. A paused campaign does not send
	// messages unless you resume it by setting IsPaused to false.
	IsPaused *bool `type:"boolean"`

	// The date the campaign was last updated in ISO 8601 format.
	LastModifiedDate *string `type:"string"`

	// The campaign limits settings.
	Limits *CampaignLimits `type:"structure"`

	// The message configuration settings.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The custom name of the campaign.
	Name *string `type:"string"`

	// The campaign schedule.
	Schedule *Schedule `type:"structure"`

	// The ID of the segment to which the campaign sends messages.
	SegmentId *string `type:"string"`

	// The version of the segment to which the campaign sends messages.
	SegmentVersion *int64 `type:"integer"`

	// The campaign status.An A/B test campaign will have a status of COMPLETED
	// only when all treatments have a status of COMPLETED.
	State *CampaignState `type:"structure"`

	// A custom description for the treatment.
	TreatmentDescription *string `type:"string"`

	// The custom name of a variation of the campaign used for A/B testing.
	TreatmentName *string `type:"string"`

	// The campaign version number.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s CampaignResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignResponse) GoString() string {
	return s.String()
}

// SetAdditionalTreatments sets the AdditionalTreatments field's value.
func (s *CampaignResponse) SetAdditionalTreatments(v []*TreatmentResource) *CampaignResponse {
	s.AdditionalTreatments = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CampaignResponse) SetApplicationId(v string) *CampaignResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CampaignResponse) SetCreationDate(v string) *CampaignResponse {
	s.CreationDate = &v
	return s
}

// SetDefaultState sets the DefaultState field's value.
func (s *CampaignResponse) SetDefaultState(v *CampaignState) *CampaignResponse {
	s.DefaultState = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CampaignResponse) SetDescription(v string) *CampaignResponse {
	s.Description = &v
	return s
}

// SetHoldoutPercent sets the HoldoutPercent field's value.
func (s *CampaignResponse) SetHoldoutPercent(v int64) *CampaignResponse {
	s.HoldoutPercent = &v
	return s
}

// SetHook sets the Hook field's value.
func (s *CampaignResponse) SetHook(v *CampaignHook) *CampaignResponse {
	s.Hook = v
	return s
}

// SetId sets the Id field's value.
func (s *CampaignResponse) SetId(v string) *CampaignResponse {
	s.Id = &v
	return s
}

// SetIsPaused sets the IsPaused field's value.
func (s *CampaignResponse) SetIsPaused(v bool) *CampaignResponse {
	s.IsPaused = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *CampaignResponse) SetLastModifiedDate(v string) *CampaignResponse {
	s.LastModifiedDate = &v
	return s
}

// SetLimits sets the Limits field's value.
func (s *CampaignResponse) SetLimits(v *CampaignLimits) *CampaignResponse {
	s.Limits = v
	return s
}

// SetMessageConfiguration sets the MessageConfiguration field's value.
func (s *CampaignResponse) SetMessageConfiguration(v *MessageConfiguration) *CampaignResponse {
	s.MessageConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CampaignResponse) SetName(v string) *CampaignResponse {
	s.Name = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CampaignResponse) SetSchedule(v *Schedule) *CampaignResponse {
	s.Schedule = v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *CampaignResponse) SetSegmentId(v string) *CampaignResponse {
	s.SegmentId = &v
	return s
}

// SetSegmentVersion sets the SegmentVersion field's value.
func (s *CampaignResponse) SetSegmentVersion(v int64) *CampaignResponse {
	s.SegmentVersion = &v
	return s
}

// SetState sets the State field's value.
func (s *CampaignResponse) SetState(v *CampaignState) *CampaignResponse {
	s.State = v
	return s
}

// SetTreatmentDescription sets the TreatmentDescription field's value.
func (s *CampaignResponse) SetTreatmentDescription(v string) *CampaignResponse {
	s.TreatmentDescription = &v
	return s
}

// SetTreatmentName sets the TreatmentName field's value.
func (s *CampaignResponse) SetTreatmentName(v string) *CampaignResponse {
	s.TreatmentName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CampaignResponse) SetVersion(v int64) *CampaignResponse {
	s.Version = &v
	return s
}

// SMS message configuration.
type CampaignSmsMessage struct {
	_ struct{} `type:"structure"`

	// The SMS text body.
	Body *string `type:"string"`

	// Is this is a transactional SMS message, otherwise a promotional message.
	MessageType *string `type:"string" enum:"MessageType"`

	// Sender ID of sent message.
	SenderId *string `type:"string"`
}

// String returns the string representation
func (s CampaignSmsMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignSmsMessage) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *CampaignSmsMessage) SetBody(v string) *CampaignSmsMessage {
	s.Body = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *CampaignSmsMessage) SetMessageType(v string) *CampaignSmsMessage {
	s.MessageType = &v
	return s
}

// SetSenderId sets the SenderId field's value.
func (s *CampaignSmsMessage) SetSenderId(v string) *CampaignSmsMessage {
	s.SenderId = &v
	return s
}

// State of the Campaign
type CampaignState struct {
	_ struct{} `type:"structure"`

	// The status of the campaign, or the status of a treatment that belongs to
	// an A/B test campaign.Valid values: SCHEDULED, EXECUTING, PENDING_NEXT_RUN,
	// COMPLETED, PAUSED
	CampaignStatus *string `type:"string" enum:"CampaignStatus"`
}

// String returns the string representation
func (s CampaignState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignState) GoString() string {
	return s.String()
}

// SetCampaignStatus sets the CampaignStatus field's value.
func (s *CampaignState) SetCampaignStatus(v string) *CampaignState {
	s.CampaignStatus = &v
	return s
}

// List of available campaigns.
type CampaignsResponse struct {
	_ struct{} `type:"structure"`

	// A list of campaigns.
	Item []*CampaignResponse `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s CampaignsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CampaignsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *CampaignsResponse) SetItem(v []*CampaignResponse) *CampaignsResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *CampaignsResponse) SetNextToken(v string) *CampaignsResponse {
	s.NextToken = &v
	return s
}

type CreateAppInput struct {
	_ struct{} `type:"structure" payload:"CreateApplicationRequest"`

	// Application Request.
	//
	// CreateApplicationRequest is a required field
	CreateApplicationRequest *CreateApplicationRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppInput"}
	if s.CreateApplicationRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("CreateApplicationRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateApplicationRequest sets the CreateApplicationRequest field's value.
func (s *CreateAppInput) SetCreateApplicationRequest(v *CreateApplicationRequest) *CreateAppInput {
	s.CreateApplicationRequest = v
	return s
}

type CreateAppOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationResponse"`

	// Application Response.
	//
	// ApplicationResponse is a required field
	ApplicationResponse *ApplicationResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAppOutput) GoString() string {
	return s.String()
}

// SetApplicationResponse sets the ApplicationResponse field's value.
func (s *CreateAppOutput) SetApplicationResponse(v *ApplicationResponse) *CreateAppOutput {
	s.ApplicationResponse = v
	return s
}

// Application Request.
type CreateApplicationRequest struct {
	_ struct{} `type:"structure"`

	// The display name of the application. Used in the Amazon Pinpoint console.
	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateApplicationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationRequest) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CreateApplicationRequest) SetName(v string) *CreateApplicationRequest {
	s.Name = &v
	return s
}

type CreateCampaignInput struct {
	_ struct{} `type:"structure" payload:"WriteCampaignRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Used to create a campaign.
	//
	// WriteCampaignRequest is a required field
	WriteCampaignRequest *WriteCampaignRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCampaignInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.WriteCampaignRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteCampaignRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateCampaignInput) SetApplicationId(v string) *CreateCampaignInput {
	s.ApplicationId = &v
	return s
}

// SetWriteCampaignRequest sets the WriteCampaignRequest field's value.
func (s *CreateCampaignInput) SetWriteCampaignRequest(v *WriteCampaignRequest) *CreateCampaignInput {
	s.WriteCampaignRequest = v
	return s
}

type CreateCampaignOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// Campaign definition
	//
	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *CreateCampaignOutput) SetCampaignResponse(v *CampaignResponse) *CreateCampaignOutput {
	s.CampaignResponse = v
	return s
}

type CreateExportJobInput struct {
	_ struct{} `type:"structure" payload:"ExportJobRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// ExportJobRequest is a required field
	ExportJobRequest *ExportJobRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateExportJobInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ExportJobRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportJobRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateExportJobInput) SetApplicationId(v string) *CreateExportJobInput {
	s.ApplicationId = &v
	return s
}

// SetExportJobRequest sets the ExportJobRequest field's value.
func (s *CreateExportJobInput) SetExportJobRequest(v *ExportJobRequest) *CreateExportJobInput {
	s.ExportJobRequest = v
	return s
}

type CreateExportJobOutput struct {
	_ struct{} `type:"structure" payload:"ExportJobResponse"`

	// ExportJobResponse is a required field
	ExportJobResponse *ExportJobResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateExportJobOutput) GoString() string {
	return s.String()
}

// SetExportJobResponse sets the ExportJobResponse field's value.
func (s *CreateExportJobOutput) SetExportJobResponse(v *ExportJobResponse) *CreateExportJobOutput {
	s.ExportJobResponse = v
	return s
}

type CreateImportJobInput struct {
	_ struct{} `type:"structure" payload:"ImportJobRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// ImportJobRequest is a required field
	ImportJobRequest *ImportJobRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateImportJobInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.ImportJobRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportJobRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateImportJobInput) SetApplicationId(v string) *CreateImportJobInput {
	s.ApplicationId = &v
	return s
}

// SetImportJobRequest sets the ImportJobRequest field's value.
func (s *CreateImportJobInput) SetImportJobRequest(v *ImportJobRequest) *CreateImportJobInput {
	s.ImportJobRequest = v
	return s
}

type CreateImportJobOutput struct {
	_ struct{} `type:"structure" payload:"ImportJobResponse"`

	// ImportJobResponse is a required field
	ImportJobResponse *ImportJobResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateImportJobOutput) GoString() string {
	return s.String()
}

// SetImportJobResponse sets the ImportJobResponse field's value.
func (s *CreateImportJobOutput) SetImportJobResponse(v *ImportJobResponse) *CreateImportJobOutput {
	s.ImportJobResponse = v
	return s
}

type CreateSegmentInput struct {
	_ struct{} `type:"structure" payload:"WriteSegmentRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Segment definition.
	//
	// WriteSegmentRequest is a required field
	WriteSegmentRequest *WriteSegmentRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSegmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSegmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSegmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.WriteSegmentRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteSegmentRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *CreateSegmentInput) SetApplicationId(v string) *CreateSegmentInput {
	s.ApplicationId = &v
	return s
}

// SetWriteSegmentRequest sets the WriteSegmentRequest field's value.
func (s *CreateSegmentInput) SetWriteSegmentRequest(v *WriteSegmentRequest) *CreateSegmentInput {
	s.WriteSegmentRequest = v
	return s
}

type CreateSegmentOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// Segment definition.
	//
	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSegmentOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *CreateSegmentOutput) SetSegmentResponse(v *SegmentResponse) *CreateSegmentOutput {
	s.SegmentResponse = v
	return s
}

// Default Message across push notification, email, and sms.
type DefaultMessage struct {
	_ struct{} `type:"structure"`

	// The message body of the notification, the email body or the text message.
	Body *string `type:"string"`

	Substitutions map[string][]*string `type:"map"`
}

// String returns the string representation
func (s DefaultMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultMessage) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *DefaultMessage) SetBody(v string) *DefaultMessage {
	s.Body = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *DefaultMessage) SetSubstitutions(v map[string][]*string) *DefaultMessage {
	s.Substitutions = v
	return s
}

// Default Push Notification Message.
type DefaultPushNotificationMessage struct {
	_ struct{} `type:"structure"`

	// The action that occurs if the user taps a push notification delivered by
	// the campaign: OPEN_APP - Your app launches, or it becomes the foreground
	// app if it has been sent to the background. This is the default action. DEEP_LINK
	// - Uses deep linking features in iOS and Android to open your app and display
	// a designated user interface within the app. URL - The default mobile browser
	// on the user's device launches and opens a web page at the URL you specify.
	// Possible values include: OPEN_APP | DEEP_LINK | URL
	Action *string `type:"string" enum:"Action"`

	// The message body of the notification, the email body or the text message.
	Body *string `type:"string"`

	// The data payload used for a silent push. This payload is added to the notifications'
	// data.pinpoint.jsonBody' object
	Data map[string]*string `type:"map"`

	// Indicates if the message should display on the users device. Silent pushes
	// can be used for Remote Configuration and Phone Home use cases.
	SilentPush *bool `type:"boolean"`

	Substitutions map[string][]*string `type:"map"`

	// The message title that displays above the message on the user's device.
	Title *string `type:"string"`

	// The URL to open in the user's mobile browser. Used if the value for Action
	// is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s DefaultPushNotificationMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultPushNotificationMessage) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *DefaultPushNotificationMessage) SetAction(v string) *DefaultPushNotificationMessage {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *DefaultPushNotificationMessage) SetBody(v string) *DefaultPushNotificationMessage {
	s.Body = &v
	return s
}

// SetData sets the Data field's value.
func (s *DefaultPushNotificationMessage) SetData(v map[string]*string) *DefaultPushNotificationMessage {
	s.Data = v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *DefaultPushNotificationMessage) SetSilentPush(v bool) *DefaultPushNotificationMessage {
	s.SilentPush = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *DefaultPushNotificationMessage) SetSubstitutions(v map[string][]*string) *DefaultPushNotificationMessage {
	s.Substitutions = v
	return s
}

// SetTitle sets the Title field's value.
func (s *DefaultPushNotificationMessage) SetTitle(v string) *DefaultPushNotificationMessage {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *DefaultPushNotificationMessage) SetUrl(v string) *DefaultPushNotificationMessage {
	s.Url = &v
	return s
}

type DeleteAdmChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAdmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAdmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAdmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAdmChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteAdmChannelInput) SetApplicationId(v string) *DeleteAdmChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteAdmChannelOutput struct {
	_ struct{} `type:"structure" payload:"ADMChannelResponse"`

	// Amazon Device Messaging channel definition.
	//
	// ADMChannelResponse is a required field
	ADMChannelResponse *ADMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteAdmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAdmChannelOutput) GoString() string {
	return s.String()
}

// SetADMChannelResponse sets the ADMChannelResponse field's value.
func (s *DeleteAdmChannelOutput) SetADMChannelResponse(v *ADMChannelResponse) *DeleteAdmChannelOutput {
	s.ADMChannelResponse = v
	return s
}

type DeleteApnsChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApnsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApnsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApnsChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApnsChannelInput) SetApplicationId(v string) *DeleteApnsChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteApnsChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSChannelResponse"`

	// Apple Distribution Push Notification Service channel definition.
	//
	// APNSChannelResponse is a required field
	APNSChannelResponse *APNSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteApnsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSChannelResponse sets the APNSChannelResponse field's value.
func (s *DeleteApnsChannelOutput) SetAPNSChannelResponse(v *APNSChannelResponse) *DeleteApnsChannelOutput {
	s.APNSChannelResponse = v
	return s
}

type DeleteApnsSandboxChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApnsSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsSandboxChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApnsSandboxChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApnsSandboxChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApnsSandboxChannelInput) SetApplicationId(v string) *DeleteApnsSandboxChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteApnsSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSSandboxChannelResponse"`

	// Apple Development Push Notification Service channel definition.
	//
	// APNSSandboxChannelResponse is a required field
	APNSSandboxChannelResponse *APNSSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteApnsSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsSandboxChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSSandboxChannelResponse sets the APNSSandboxChannelResponse field's value.
func (s *DeleteApnsSandboxChannelOutput) SetAPNSSandboxChannelResponse(v *APNSSandboxChannelResponse) *DeleteApnsSandboxChannelOutput {
	s.APNSSandboxChannelResponse = v
	return s
}

type DeleteApnsVoipChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApnsVoipChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsVoipChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApnsVoipChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApnsVoipChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApnsVoipChannelInput) SetApplicationId(v string) *DeleteApnsVoipChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteApnsVoipChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSVoipChannelResponse"`

	// Apple VoIP Push Notification Service channel definition.
	//
	// APNSVoipChannelResponse is a required field
	APNSVoipChannelResponse *APNSVoipChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteApnsVoipChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsVoipChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSVoipChannelResponse sets the APNSVoipChannelResponse field's value.
func (s *DeleteApnsVoipChannelOutput) SetAPNSVoipChannelResponse(v *APNSVoipChannelResponse) *DeleteApnsVoipChannelOutput {
	s.APNSVoipChannelResponse = v
	return s
}

type DeleteApnsVoipSandboxChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApnsVoipSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsVoipSandboxChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApnsVoipSandboxChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApnsVoipSandboxChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteApnsVoipSandboxChannelInput) SetApplicationId(v string) *DeleteApnsVoipSandboxChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteApnsVoipSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSVoipSandboxChannelResponse"`

	// Apple VoIP Developer Push Notification Service channel definition.
	//
	// APNSVoipSandboxChannelResponse is a required field
	APNSVoipSandboxChannelResponse *APNSVoipSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteApnsVoipSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApnsVoipSandboxChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSVoipSandboxChannelResponse sets the APNSVoipSandboxChannelResponse field's value.
func (s *DeleteApnsVoipSandboxChannelOutput) SetAPNSVoipSandboxChannelResponse(v *APNSVoipSandboxChannelResponse) *DeleteApnsVoipSandboxChannelOutput {
	s.APNSVoipSandboxChannelResponse = v
	return s
}

type DeleteAppInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteAppInput) SetApplicationId(v string) *DeleteAppInput {
	s.ApplicationId = &v
	return s
}

type DeleteAppOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationResponse"`

	// Application Response.
	//
	// ApplicationResponse is a required field
	ApplicationResponse *ApplicationResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppOutput) GoString() string {
	return s.String()
}

// SetApplicationResponse sets the ApplicationResponse field's value.
func (s *DeleteAppOutput) SetApplicationResponse(v *ApplicationResponse) *DeleteAppOutput {
	s.ApplicationResponse = v
	return s
}

type DeleteBaiduChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBaiduChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBaiduChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBaiduChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBaiduChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteBaiduChannelInput) SetApplicationId(v string) *DeleteBaiduChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteBaiduChannelOutput struct {
	_ struct{} `type:"structure" payload:"BaiduChannelResponse"`

	// Baidu Cloud Messaging channel definition
	//
	// BaiduChannelResponse is a required field
	BaiduChannelResponse *BaiduChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteBaiduChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBaiduChannelOutput) GoString() string {
	return s.String()
}

// SetBaiduChannelResponse sets the BaiduChannelResponse field's value.
func (s *DeleteBaiduChannelOutput) SetBaiduChannelResponse(v *BaiduChannelResponse) *DeleteBaiduChannelOutput {
	s.BaiduChannelResponse = v
	return s
}

type DeleteCampaignInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCampaignInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteCampaignInput) SetApplicationId(v string) *DeleteCampaignInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *DeleteCampaignInput) SetCampaignId(v string) *DeleteCampaignInput {
	s.CampaignId = &v
	return s
}

type DeleteCampaignOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// Campaign definition
	//
	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *DeleteCampaignOutput) SetCampaignResponse(v *CampaignResponse) *DeleteCampaignOutput {
	s.CampaignResponse = v
	return s
}

type DeleteEmailChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEmailChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEmailChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEmailChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEmailChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteEmailChannelInput) SetApplicationId(v string) *DeleteEmailChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteEmailChannelOutput struct {
	_ struct{} `type:"structure" payload:"EmailChannelResponse"`

	// Email Channel Response.
	//
	// EmailChannelResponse is a required field
	EmailChannelResponse *EmailChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteEmailChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEmailChannelOutput) GoString() string {
	return s.String()
}

// SetEmailChannelResponse sets the EmailChannelResponse field's value.
func (s *DeleteEmailChannelOutput) SetEmailChannelResponse(v *EmailChannelResponse) *DeleteEmailChannelOutput {
	s.EmailChannelResponse = v
	return s
}

type DeleteEndpointInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// EndpointId is a required field
	EndpointId *string `location:"uri" locationName:"endpoint-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteEndpointInput) SetApplicationId(v string) *DeleteEndpointInput {
	s.ApplicationId = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *DeleteEndpointInput) SetEndpointId(v string) *DeleteEndpointInput {
	s.EndpointId = &v
	return s
}

type DeleteEndpointOutput struct {
	_ struct{} `type:"structure" payload:"EndpointResponse"`

	// Endpoint response
	//
	// EndpointResponse is a required field
	EndpointResponse *EndpointResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointResponse sets the EndpointResponse field's value.
func (s *DeleteEndpointOutput) SetEndpointResponse(v *EndpointResponse) *DeleteEndpointOutput {
	s.EndpointResponse = v
	return s
}

type DeleteEventStreamInput struct {
	_ struct{} `type:"structure"`

	// Application Id.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventStreamInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteEventStreamInput) SetApplicationId(v string) *DeleteEventStreamInput {
	s.ApplicationId = &v
	return s
}

type DeleteEventStreamOutput struct {
	_ struct{} `type:"structure" payload:"EventStream"`

	// Model for an event publishing subscription export.
	//
	// EventStream is a required field
	EventStream *EventStream `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteEventStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventStreamOutput) GoString() string {
	return s.String()
}

// SetEventStream sets the EventStream field's value.
func (s *DeleteEventStreamOutput) SetEventStream(v *EventStream) *DeleteEventStreamOutput {
	s.EventStream = v
	return s
}

type DeleteGcmChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGcmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGcmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGcmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGcmChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteGcmChannelInput) SetApplicationId(v string) *DeleteGcmChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteGcmChannelOutput struct {
	_ struct{} `type:"structure" payload:"GCMChannelResponse"`

	// Google Cloud Messaging channel definition
	//
	// GCMChannelResponse is a required field
	GCMChannelResponse *GCMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteGcmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGcmChannelOutput) GoString() string {
	return s.String()
}

// SetGCMChannelResponse sets the GCMChannelResponse field's value.
func (s *DeleteGcmChannelOutput) SetGCMChannelResponse(v *GCMChannelResponse) *DeleteGcmChannelOutput {
	s.GCMChannelResponse = v
	return s
}

type DeleteSegmentInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSegmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSegmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSegmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteSegmentInput) SetApplicationId(v string) *DeleteSegmentInput {
	s.ApplicationId = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *DeleteSegmentInput) SetSegmentId(v string) *DeleteSegmentInput {
	s.SegmentId = &v
	return s
}

type DeleteSegmentOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// Segment definition.
	//
	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSegmentOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *DeleteSegmentOutput) SetSegmentResponse(v *SegmentResponse) *DeleteSegmentOutput {
	s.SegmentResponse = v
	return s
}

type DeleteSmsChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSmsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSmsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSmsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSmsChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *DeleteSmsChannelInput) SetApplicationId(v string) *DeleteSmsChannelInput {
	s.ApplicationId = &v
	return s
}

type DeleteSmsChannelOutput struct {
	_ struct{} `type:"structure" payload:"SMSChannelResponse"`

	// SMS Channel Response.
	//
	// SMSChannelResponse is a required field
	SMSChannelResponse *SMSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteSmsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSmsChannelOutput) GoString() string {
	return s.String()
}

// SetSMSChannelResponse sets the SMSChannelResponse field's value.
func (s *DeleteSmsChannelOutput) SetSMSChannelResponse(v *SMSChannelResponse) *DeleteSmsChannelOutput {
	s.SMSChannelResponse = v
	return s
}

// The message configuration.
type DirectMessageConfiguration struct {
	_ struct{} `type:"structure"`

	// The message to ADM channels. Overrides the default push notification message.
	ADMMessage *ADMMessage `type:"structure"`

	// The message to APNS channels. Overrides the default push notification message.
	APNSMessage *APNSMessage `type:"structure"`

	// The message to Baidu GCM channels. Overrides the default push notification
	// message.
	BaiduMessage *BaiduMessage `type:"structure"`

	// The default message for all channels.
	DefaultMessage *DefaultMessage `type:"structure"`

	// The default push notification message for all push channels.
	DefaultPushNotificationMessage *DefaultPushNotificationMessage `type:"structure"`

	// The message to GCM channels. Overrides the default push notification message.
	GCMMessage *GCMMessage `type:"structure"`

	// The message to SMS channels. Overrides the default message.
	SMSMessage *SMSMessage `type:"structure"`
}

// String returns the string representation
func (s DirectMessageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectMessageConfiguration) GoString() string {
	return s.String()
}

// SetADMMessage sets the ADMMessage field's value.
func (s *DirectMessageConfiguration) SetADMMessage(v *ADMMessage) *DirectMessageConfiguration {
	s.ADMMessage = v
	return s
}

// SetAPNSMessage sets the APNSMessage field's value.
func (s *DirectMessageConfiguration) SetAPNSMessage(v *APNSMessage) *DirectMessageConfiguration {
	s.APNSMessage = v
	return s
}

// SetBaiduMessage sets the BaiduMessage field's value.
func (s *DirectMessageConfiguration) SetBaiduMessage(v *BaiduMessage) *DirectMessageConfiguration {
	s.BaiduMessage = v
	return s
}

// SetDefaultMessage sets the DefaultMessage field's value.
func (s *DirectMessageConfiguration) SetDefaultMessage(v *DefaultMessage) *DirectMessageConfiguration {
	s.DefaultMessage = v
	return s
}

// SetDefaultPushNotificationMessage sets the DefaultPushNotificationMessage field's value.
func (s *DirectMessageConfiguration) SetDefaultPushNotificationMessage(v *DefaultPushNotificationMessage) *DirectMessageConfiguration {
	s.DefaultPushNotificationMessage = v
	return s
}

// SetGCMMessage sets the GCMMessage field's value.
func (s *DirectMessageConfiguration) SetGCMMessage(v *GCMMessage) *DirectMessageConfiguration {
	s.GCMMessage = v
	return s
}

// SetSMSMessage sets the SMSMessage field's value.
func (s *DirectMessageConfiguration) SetSMSMessage(v *SMSMessage) *DirectMessageConfiguration {
	s.SMSMessage = v
	return s
}

// Email Channel Request
type EmailChannelRequest struct {
	_ struct{} `type:"structure"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// The email address used to send emails from.
	FromAddress *string `type:"string"`

	// The ARN of an identity verified with SES.
	Identity *string `type:"string"`

	// The ARN of an IAM Role used to submit events to Mobile Analytics' event ingestion
	// service
	RoleArn *string `type:"string"`
}

// String returns the string representation
func (s EmailChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmailChannelRequest) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *EmailChannelRequest) SetEnabled(v bool) *EmailChannelRequest {
	s.Enabled = &v
	return s
}

// SetFromAddress sets the FromAddress field's value.
func (s *EmailChannelRequest) SetFromAddress(v string) *EmailChannelRequest {
	s.FromAddress = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *EmailChannelRequest) SetIdentity(v string) *EmailChannelRequest {
	s.Identity = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *EmailChannelRequest) SetRoleArn(v string) *EmailChannelRequest {
	s.RoleArn = &v
	return s
}

// Email Channel Response.
type EmailChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique ID of the application to which the email channel belongs.
	ApplicationId *string `type:"string"`

	// The date that the settings were last updated in ISO 8601 format.
	CreationDate *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// The email address used to send emails from.
	FromAddress *string `type:"string"`

	// If the channel is registered with a credential for authentication.
	HasCredential *bool `type:"boolean"`

	// Channel ID. Not used, only for backwards compatibility.
	Id *string `type:"string"`

	// The ARN of an identity verified with SES.
	Identity *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who last updated this entry
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// Platform type. Will be "EMAIL"
	Platform *string `type:"string"`

	// The ARN of an IAM Role used to submit events to Mobile Analytics' event ingestion
	// service
	RoleArn *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s EmailChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EmailChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *EmailChannelResponse) SetApplicationId(v string) *EmailChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *EmailChannelResponse) SetCreationDate(v string) *EmailChannelResponse {
	s.CreationDate = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EmailChannelResponse) SetEnabled(v bool) *EmailChannelResponse {
	s.Enabled = &v
	return s
}

// SetFromAddress sets the FromAddress field's value.
func (s *EmailChannelResponse) SetFromAddress(v string) *EmailChannelResponse {
	s.FromAddress = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *EmailChannelResponse) SetHasCredential(v bool) *EmailChannelResponse {
	s.HasCredential = &v
	return s
}

// SetId sets the Id field's value.
func (s *EmailChannelResponse) SetId(v string) *EmailChannelResponse {
	s.Id = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *EmailChannelResponse) SetIdentity(v string) *EmailChannelResponse {
	s.Identity = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *EmailChannelResponse) SetIsArchived(v bool) *EmailChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *EmailChannelResponse) SetLastModifiedBy(v string) *EmailChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *EmailChannelResponse) SetLastModifiedDate(v string) *EmailChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *EmailChannelResponse) SetPlatform(v string) *EmailChannelResponse {
	s.Platform = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *EmailChannelResponse) SetRoleArn(v string) *EmailChannelResponse {
	s.RoleArn = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *EmailChannelResponse) SetVersion(v int64) *EmailChannelResponse {
	s.Version = &v
	return s
}

// Endpoint update request
type EndpointBatchItem struct {
	_ struct{} `type:"structure"`

	// The address or token of the endpoint as provided by your push provider (e.g.
	// DeviceToken or RegistrationId).
	Address *string `type:"string"`

	Attributes map[string][]*string `type:"map"`

	// The channel type.Valid values: GCM | APNS | APNS_SANDBOX | APNS_VOIP | APNS_VOIP_SANDBOX
	// | ADM | SMS | EMAIL | BAIDU
	ChannelType *string `type:"string" enum:"ChannelType"`

	// The endpoint demographic attributes.
	Demographic *EndpointDemographic `type:"structure"`

	// The last time the endpoint was updated. Provided in ISO 8601 format.
	EffectiveDate *string `type:"string"`

	// The endpoint status. Can be either ACTIVE or INACTIVE. Will be set to INACTIVE
	// if a delivery fails. Will be set to ACTIVE if the address is updated.
	EndpointStatus *string `type:"string"`

	// The unique Id for the Endpoint in the batch.
	Id *string `type:"string"`

	// The endpoint location attributes.
	Location *EndpointLocation `type:"structure"`

	// Custom metrics that your app reports to Amazon Pinpoint.
	Metrics map[string]*float64 `type:"map"`

	// Indicates whether a user has opted out of receiving messages with one of
	// the following values:ALL - User has opted out of all messages.NONE - Users
	// has not opted out and receives all messages.
	OptOut *string `type:"string"`

	// The unique ID for the most recent request to update the endpoint.
	RequestId *string `type:"string"`

	// Custom user-specific attributes that your app reports to Amazon Pinpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s EndpointBatchItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointBatchItem) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *EndpointBatchItem) SetAddress(v string) *EndpointBatchItem {
	s.Address = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *EndpointBatchItem) SetAttributes(v map[string][]*string) *EndpointBatchItem {
	s.Attributes = v
	return s
}

// SetChannelType sets the ChannelType field's value.
func (s *EndpointBatchItem) SetChannelType(v string) *EndpointBatchItem {
	s.ChannelType = &v
	return s
}

// SetDemographic sets the Demographic field's value.
func (s *EndpointBatchItem) SetDemographic(v *EndpointDemographic) *EndpointBatchItem {
	s.Demographic = v
	return s
}

// SetEffectiveDate sets the EffectiveDate field's value.
func (s *EndpointBatchItem) SetEffectiveDate(v string) *EndpointBatchItem {
	s.EffectiveDate = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *EndpointBatchItem) SetEndpointStatus(v string) *EndpointBatchItem {
	s.EndpointStatus = &v
	return s
}

// SetId sets the Id field's value.
func (s *EndpointBatchItem) SetId(v string) *EndpointBatchItem {
	s.Id = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *EndpointBatchItem) SetLocation(v *EndpointLocation) *EndpointBatchItem {
	s.Location = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *EndpointBatchItem) SetMetrics(v map[string]*float64) *EndpointBatchItem {
	s.Metrics = v
	return s
}

// SetOptOut sets the OptOut field's value.
func (s *EndpointBatchItem) SetOptOut(v string) *EndpointBatchItem {
	s.OptOut = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *EndpointBatchItem) SetRequestId(v string) *EndpointBatchItem {
	s.RequestId = &v
	return s
}

// SetUser sets the User field's value.
func (s *EndpointBatchItem) SetUser(v *EndpointUser) *EndpointBatchItem {
	s.User = v
	return s
}

// Endpoint batch update request.
type EndpointBatchRequest struct {
	_ struct{} `type:"structure"`

	// List of items to update. Maximum 100 items
	Item []*EndpointBatchItem `type:"list"`
}

// String returns the string representation
func (s EndpointBatchRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointBatchRequest) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *EndpointBatchRequest) SetItem(v []*EndpointBatchItem) *EndpointBatchRequest {
	s.Item = v
	return s
}

// Endpoint demographic data
type EndpointDemographic struct {
	_ struct{} `type:"structure"`

	// The version of the application associated with the endpoint.
	AppVersion *string `type:"string"`

	// The endpoint locale in the following format: The ISO 639-1 alpha-2 code,
	// followed by an underscore, followed by an ISO 3166-1 alpha-2 value.
	Locale *string `type:"string"`

	// The endpoint make, such as such as Apple or Samsung.
	Make *string `type:"string"`

	// The endpoint model, such as iPhone.
	Model *string `type:"string"`

	// The endpoint model version.
	ModelVersion *string `type:"string"`

	// The endpoint platform, such as ios or android.
	Platform *string `type:"string"`

	// The endpoint platform version.
	PlatformVersion *string `type:"string"`

	// The timezone of the endpoint. Specified as a tz database value, such as Americas/Los_Angeles.
	Timezone *string `type:"string"`
}

// String returns the string representation
func (s EndpointDemographic) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointDemographic) GoString() string {
	return s.String()
}

// SetAppVersion sets the AppVersion field's value.
func (s *EndpointDemographic) SetAppVersion(v string) *EndpointDemographic {
	s.AppVersion = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *EndpointDemographic) SetLocale(v string) *EndpointDemographic {
	s.Locale = &v
	return s
}

// SetMake sets the Make field's value.
func (s *EndpointDemographic) SetMake(v string) *EndpointDemographic {
	s.Make = &v
	return s
}

// SetModel sets the Model field's value.
func (s *EndpointDemographic) SetModel(v string) *EndpointDemographic {
	s.Model = &v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *EndpointDemographic) SetModelVersion(v string) *EndpointDemographic {
	s.ModelVersion = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *EndpointDemographic) SetPlatform(v string) *EndpointDemographic {
	s.Platform = &v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *EndpointDemographic) SetPlatformVersion(v string) *EndpointDemographic {
	s.PlatformVersion = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *EndpointDemographic) SetTimezone(v string) *EndpointDemographic {
	s.Timezone = &v
	return s
}

// Endpoint location data
type EndpointLocation struct {
	_ struct{} `type:"structure"`

	// The city where the endpoint is located.
	City *string `type:"string"`

	// Country according to ISO 3166-1 Alpha-2 codes. For example, US.
	Country *string `type:"string"`

	// The latitude of the endpoint location. Rounded to one decimal (Roughly corresponding
	// to a mile).
	Latitude *float64 `type:"double"`

	// The longitude of the endpoint location. Rounded to one decimal (Roughly corresponding
	// to a mile).
	Longitude *float64 `type:"double"`

	// The postal code or zip code of the endpoint.
	PostalCode *string `type:"string"`

	// The region of the endpoint location. For example, corresponds to a state
	// in US.
	Region *string `type:"string"`
}

// String returns the string representation
func (s EndpointLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointLocation) GoString() string {
	return s.String()
}

// SetCity sets the City field's value.
func (s *EndpointLocation) SetCity(v string) *EndpointLocation {
	s.City = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *EndpointLocation) SetCountry(v string) *EndpointLocation {
	s.Country = &v
	return s
}

// SetLatitude sets the Latitude field's value.
func (s *EndpointLocation) SetLatitude(v float64) *EndpointLocation {
	s.Latitude = &v
	return s
}

// SetLongitude sets the Longitude field's value.
func (s *EndpointLocation) SetLongitude(v float64) *EndpointLocation {
	s.Longitude = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *EndpointLocation) SetPostalCode(v string) *EndpointLocation {
	s.PostalCode = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *EndpointLocation) SetRegion(v string) *EndpointLocation {
	s.Region = &v
	return s
}

// The result from sending a message to an endpoint.
type EndpointMessageResult struct {
	_ struct{} `type:"structure"`

	// Address that endpoint message was delivered to.
	Address *string `type:"string"`

	// Delivery status of message.
	DeliveryStatus *string `type:"string" enum:"DeliveryStatus"`

	// Downstream service status code.
	StatusCode *int64 `type:"integer"`

	// Status message for message delivery.
	StatusMessage *string `type:"string"`

	// If token was updated as part of delivery. (This is GCM Specific)
	UpdatedToken *string `type:"string"`
}

// String returns the string representation
func (s EndpointMessageResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointMessageResult) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *EndpointMessageResult) SetAddress(v string) *EndpointMessageResult {
	s.Address = &v
	return s
}

// SetDeliveryStatus sets the DeliveryStatus field's value.
func (s *EndpointMessageResult) SetDeliveryStatus(v string) *EndpointMessageResult {
	s.DeliveryStatus = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *EndpointMessageResult) SetStatusCode(v int64) *EndpointMessageResult {
	s.StatusCode = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *EndpointMessageResult) SetStatusMessage(v string) *EndpointMessageResult {
	s.StatusMessage = &v
	return s
}

// SetUpdatedToken sets the UpdatedToken field's value.
func (s *EndpointMessageResult) SetUpdatedToken(v string) *EndpointMessageResult {
	s.UpdatedToken = &v
	return s
}

// Endpoint update request
type EndpointRequest struct {
	_ struct{} `type:"structure"`

	// The address or token of the endpoint as provided by your push provider (e.g.
	// DeviceToken or RegistrationId).
	Address *string `type:"string"`

	Attributes map[string][]*string `type:"map"`

	// The channel type.Valid values: GCM | APNS | APNS_SANDBOX | APNS_VOIP | APNS_VOIP_SANDBOX
	// | ADM | SMS | EMAIL | BAIDU
	ChannelType *string `type:"string" enum:"ChannelType"`

	// The endpoint demographic attributes.
	Demographic *EndpointDemographic `type:"structure"`

	// The last time the endpoint was updated. Provided in ISO 8601 format.
	EffectiveDate *string `type:"string"`

	// The endpoint status. Can be either ACTIVE or INACTIVE. Will be set to INACTIVE
	// if a delivery fails. Will be set to ACTIVE if the address is updated.
	EndpointStatus *string `type:"string"`

	// The endpoint location attributes.
	Location *EndpointLocation `type:"structure"`

	// Custom metrics that your app reports to Amazon Pinpoint.
	Metrics map[string]*float64 `type:"map"`

	// Indicates whether a user has opted out of receiving messages with one of
	// the following values:ALL - User has opted out of all messages.NONE - Users
	// has not opted out and receives all messages.
	OptOut *string `type:"string"`

	// The unique ID for the most recent request to update the endpoint.
	RequestId *string `type:"string"`

	// Custom user-specific attributes that your app reports to Amazon Pinpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s EndpointRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointRequest) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *EndpointRequest) SetAddress(v string) *EndpointRequest {
	s.Address = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *EndpointRequest) SetAttributes(v map[string][]*string) *EndpointRequest {
	s.Attributes = v
	return s
}

// SetChannelType sets the ChannelType field's value.
func (s *EndpointRequest) SetChannelType(v string) *EndpointRequest {
	s.ChannelType = &v
	return s
}

// SetDemographic sets the Demographic field's value.
func (s *EndpointRequest) SetDemographic(v *EndpointDemographic) *EndpointRequest {
	s.Demographic = v
	return s
}

// SetEffectiveDate sets the EffectiveDate field's value.
func (s *EndpointRequest) SetEffectiveDate(v string) *EndpointRequest {
	s.EffectiveDate = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *EndpointRequest) SetEndpointStatus(v string) *EndpointRequest {
	s.EndpointStatus = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *EndpointRequest) SetLocation(v *EndpointLocation) *EndpointRequest {
	s.Location = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *EndpointRequest) SetMetrics(v map[string]*float64) *EndpointRequest {
	s.Metrics = v
	return s
}

// SetOptOut sets the OptOut field's value.
func (s *EndpointRequest) SetOptOut(v string) *EndpointRequest {
	s.OptOut = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *EndpointRequest) SetRequestId(v string) *EndpointRequest {
	s.RequestId = &v
	return s
}

// SetUser sets the User field's value.
func (s *EndpointRequest) SetUser(v *EndpointUser) *EndpointRequest {
	s.User = v
	return s
}

// Endpoint response
type EndpointResponse struct {
	_ struct{} `type:"structure"`

	// The address or token of the endpoint as provided by your push provider (e.g.
	// DeviceToken or RegistrationId).
	Address *string `type:"string"`

	// The ID of the application associated with the endpoint.
	ApplicationId *string `type:"string"`

	Attributes map[string][]*string `type:"map"`

	// The channel type.Valid values: GCM | APNS | APNS_SANDBOX | APNS_VOIP | APNS_VOIP_SANDBOX
	// | ADM | SMS | EMAIL | BAIDU
	ChannelType *string `type:"string" enum:"ChannelType"`

	// A number from 0 - 99 that represents the cohort the endpoint is assigned
	// to. Endpoints are grouped into cohorts randomly, and each cohort contains
	// approximately 1 percent of the endpoints for an app. Amazon Pinpoint assigns
	// cohorts to the holdout or treatment allocations for a campaign.
	CohortId *string `type:"string"`

	// The last time the endpoint was created. Provided in ISO 8601 format.
	CreationDate *string `type:"string"`

	// The endpoint demographic attributes.
	Demographic *EndpointDemographic `type:"structure"`

	// The last time the endpoint was updated. Provided in ISO 8601 format.
	EffectiveDate *string `type:"string"`

	// The endpoint status. Can be either ACTIVE or INACTIVE. Will be set to INACTIVE
	// if a delivery fails. Will be set to ACTIVE if the address is updated.
	EndpointStatus *string `type:"string"`

	// The unique ID that you assigned to the endpoint. The ID should be a globally
	// unique identifier (GUID) to ensure that it is unique compared to all other
	// endpoints for the application.
	Id *string `type:"string"`

	// The endpoint location attributes.
	Location *EndpointLocation `type:"structure"`

	// Custom metrics that your app reports to Amazon Pinpoint.
	Metrics map[string]*float64 `type:"map"`

	// Indicates whether a user has opted out of receiving messages with one of
	// the following values:ALL - User has opted out of all messages.NONE - Users
	// has not opted out and receives all messages.
	OptOut *string `type:"string"`

	// The unique ID for the most recent request to update the endpoint.
	RequestId *string `type:"string"`

	// Custom user-specific attributes that your app reports to Amazon Pinpoint.
	User *EndpointUser `type:"structure"`
}

// String returns the string representation
func (s EndpointResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointResponse) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *EndpointResponse) SetAddress(v string) *EndpointResponse {
	s.Address = &v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *EndpointResponse) SetApplicationId(v string) *EndpointResponse {
	s.ApplicationId = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *EndpointResponse) SetAttributes(v map[string][]*string) *EndpointResponse {
	s.Attributes = v
	return s
}

// SetChannelType sets the ChannelType field's value.
func (s *EndpointResponse) SetChannelType(v string) *EndpointResponse {
	s.ChannelType = &v
	return s
}

// SetCohortId sets the CohortId field's value.
func (s *EndpointResponse) SetCohortId(v string) *EndpointResponse {
	s.CohortId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *EndpointResponse) SetCreationDate(v string) *EndpointResponse {
	s.CreationDate = &v
	return s
}

// SetDemographic sets the Demographic field's value.
func (s *EndpointResponse) SetDemographic(v *EndpointDemographic) *EndpointResponse {
	s.Demographic = v
	return s
}

// SetEffectiveDate sets the EffectiveDate field's value.
func (s *EndpointResponse) SetEffectiveDate(v string) *EndpointResponse {
	s.EffectiveDate = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *EndpointResponse) SetEndpointStatus(v string) *EndpointResponse {
	s.EndpointStatus = &v
	return s
}

// SetId sets the Id field's value.
func (s *EndpointResponse) SetId(v string) *EndpointResponse {
	s.Id = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *EndpointResponse) SetLocation(v *EndpointLocation) *EndpointResponse {
	s.Location = v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *EndpointResponse) SetMetrics(v map[string]*float64) *EndpointResponse {
	s.Metrics = v
	return s
}

// SetOptOut sets the OptOut field's value.
func (s *EndpointResponse) SetOptOut(v string) *EndpointResponse {
	s.OptOut = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *EndpointResponse) SetRequestId(v string) *EndpointResponse {
	s.RequestId = &v
	return s
}

// SetUser sets the User field's value.
func (s *EndpointResponse) SetUser(v *EndpointUser) *EndpointResponse {
	s.User = v
	return s
}

// Endpoint send configuration.
type EndpointSendConfiguration struct {
	_ struct{} `type:"structure"`

	// Body override. If specified will override default body.
	BodyOverride *string `type:"string"`

	// A map of custom attributes to attributes to be attached to the message for
	// this address. This payload is added to the push notification's 'data.pinpoint'
	// object or added to the email/sms delivery receipt event attributes.
	Context map[string]*string `type:"map"`

	// The Raw JSON formatted string to be used as the payload. This value overrides
	// the message.
	RawContent *string `type:"string"`

	Substitutions map[string][]*string `type:"map"`

	// Title override. If specified will override default title if applicable.
	TitleOverride *string `type:"string"`
}

// String returns the string representation
func (s EndpointSendConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointSendConfiguration) GoString() string {
	return s.String()
}

// SetBodyOverride sets the BodyOverride field's value.
func (s *EndpointSendConfiguration) SetBodyOverride(v string) *EndpointSendConfiguration {
	s.BodyOverride = &v
	return s
}

// SetContext sets the Context field's value.
func (s *EndpointSendConfiguration) SetContext(v map[string]*string) *EndpointSendConfiguration {
	s.Context = v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *EndpointSendConfiguration) SetRawContent(v string) *EndpointSendConfiguration {
	s.RawContent = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *EndpointSendConfiguration) SetSubstitutions(v map[string][]*string) *EndpointSendConfiguration {
	s.Substitutions = v
	return s
}

// SetTitleOverride sets the TitleOverride field's value.
func (s *EndpointSendConfiguration) SetTitleOverride(v string) *EndpointSendConfiguration {
	s.TitleOverride = &v
	return s
}

// Endpoint user specific custom userAttributes
type EndpointUser struct {
	_ struct{} `type:"structure"`

	UserAttributes map[string][]*string `type:"map"`

	// The unique ID of the user.
	UserId *string `type:"string"`
}

// String returns the string representation
func (s EndpointUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointUser) GoString() string {
	return s.String()
}

// SetUserAttributes sets the UserAttributes field's value.
func (s *EndpointUser) SetUserAttributes(v map[string][]*string) *EndpointUser {
	s.UserAttributes = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *EndpointUser) SetUserId(v string) *EndpointUser {
	s.UserId = &v
	return s
}

// Model for an event publishing subscription export.
type EventStream struct {
	_ struct{} `type:"structure"`

	// The ID of the application from which events should be published.
	ApplicationId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis stream or Firehose delivery
	// stream to which you want to publish events. Firehose ARN: arn:aws:firehose:REGION:ACCOUNT_ID:deliverystream/STREAM_NAME
	// Kinesis ARN: arn:aws:kinesis:REGION:ACCOUNT_ID:stream/STREAM_NAME
	DestinationStreamArn *string `type:"string"`

	// DEPRECATED. Your AWS account ID, which you assigned to the ExternalID key
	// in an IAM trust policy. Used by Amazon Pinpoint to assume an IAM role. This
	// requirement is removed, and external IDs are not recommended for IAM roles
	// assumed by Amazon Pinpoint.
	ExternalId *string `type:"string"`

	// The date the event stream was last updated in ISO 8601 format.
	LastModifiedDate *string `type:"string"`

	// The IAM user who last modified the event stream.
	LastUpdatedBy *string `type:"string"`

	// The IAM role that authorizes Amazon Pinpoint to publish events to the stream
	// in your account.
	RoleArn *string `type:"string"`
}

// String returns the string representation
func (s EventStream) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventStream) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *EventStream) SetApplicationId(v string) *EventStream {
	s.ApplicationId = &v
	return s
}

// SetDestinationStreamArn sets the DestinationStreamArn field's value.
func (s *EventStream) SetDestinationStreamArn(v string) *EventStream {
	s.DestinationStreamArn = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *EventStream) SetExternalId(v string) *EventStream {
	s.ExternalId = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *EventStream) SetLastModifiedDate(v string) *EventStream {
	s.LastModifiedDate = &v
	return s
}

// SetLastUpdatedBy sets the LastUpdatedBy field's value.
func (s *EventStream) SetLastUpdatedBy(v string) *EventStream {
	s.LastUpdatedBy = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *EventStream) SetRoleArn(v string) *EventStream {
	s.RoleArn = &v
	return s
}

type ExportJobRequest struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint
	// access to the Amazon S3 location that endpoints will be exported to.
	RoleArn *string `type:"string"`

	// A URL that points to the location within an Amazon S3 bucket that will receive
	// the export. The location is typically a folder with multiple files.The URL
	// should follow this format: s3://bucket-name/folder-name/Amazon Pinpoint will
	// export endpoints to this location.
	S3UrlPrefix *string `type:"string"`

	// The ID of the segment to export endpoints from. If not present, all endpoints
	// will be exported.
	SegmentId *string `type:"string"`
}

// String returns the string representation
func (s ExportJobRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportJobRequest) GoString() string {
	return s.String()
}

// SetRoleArn sets the RoleArn field's value.
func (s *ExportJobRequest) SetRoleArn(v string) *ExportJobRequest {
	s.RoleArn = &v
	return s
}

// SetS3UrlPrefix sets the S3UrlPrefix field's value.
func (s *ExportJobRequest) SetS3UrlPrefix(v string) *ExportJobRequest {
	s.S3UrlPrefix = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *ExportJobRequest) SetSegmentId(v string) *ExportJobRequest {
	s.SegmentId = &v
	return s
}

type ExportJobResource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint
	// access to the Amazon S3 location that endpoints will be exported to.
	RoleArn *string `type:"string"`

	// A URL that points to the location within an Amazon S3 bucket that will receive
	// the export. The location is typically a folder with multiple files.The URL
	// should follow this format: s3://bucket-name/folder-name/Amazon Pinpoint will
	// export endpoints to this location.
	S3UrlPrefix *string `type:"string"`

	// The ID of the segment to export endpoints from. If not present all endpoints
	// will be exported.
	SegmentId *string `type:"string"`
}

// String returns the string representation
func (s ExportJobResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportJobResource) GoString() string {
	return s.String()
}

// SetRoleArn sets the RoleArn field's value.
func (s *ExportJobResource) SetRoleArn(v string) *ExportJobResource {
	s.RoleArn = &v
	return s
}

// SetS3UrlPrefix sets the S3UrlPrefix field's value.
func (s *ExportJobResource) SetS3UrlPrefix(v string) *ExportJobResource {
	s.S3UrlPrefix = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *ExportJobResource) SetSegmentId(v string) *ExportJobResource {
	s.SegmentId = &v
	return s
}

type ExportJobResponse struct {
	_ struct{} `type:"structure"`

	// The unique ID of the application to which the job applies.
	ApplicationId *string `type:"string"`

	// The number of pieces that have successfully completed as of the time of the
	// request.
	CompletedPieces *int64 `type:"integer"`

	// The date the job completed in ISO 8601 format.
	CompletionDate *string `type:"string"`

	// The date the job was created in ISO 8601 format.
	CreationDate *string `type:"string"`

	// The export job settings.
	Definition *ExportJobResource `type:"structure"`

	// The number of pieces that failed to be processed as of the time of the request.
	FailedPieces *int64 `type:"integer"`

	Failures []*string `type:"list"`

	// The unique ID of the job.
	Id *string `type:"string"`

	// The status of the export job.Valid values: CREATED, INITIALIZING, PROCESSING,
	// COMPLETING, COMPLETED, FAILING, FAILEDThe job status is FAILED if one or
	// more pieces failed.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// The number of endpoints that were not processed; for example, because of
	// syntax errors.
	TotalFailures *int64 `type:"integer"`

	// The total number of pieces that must be processed to finish the job. Each
	// piece is an approximately equal portion of the endpoints.
	TotalPieces *int64 `type:"integer"`

	// The number of endpoints that were processed by the job.
	TotalProcessed *int64 `type:"integer"`

	// The job type. Will be 'EXPORT'.
	Type *string `type:"string"`
}

// String returns the string representation
func (s ExportJobResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportJobResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ExportJobResponse) SetApplicationId(v string) *ExportJobResponse {
	s.ApplicationId = &v
	return s
}

// SetCompletedPieces sets the CompletedPieces field's value.
func (s *ExportJobResponse) SetCompletedPieces(v int64) *ExportJobResponse {
	s.CompletedPieces = &v
	return s
}

// SetCompletionDate sets the CompletionDate field's value.
func (s *ExportJobResponse) SetCompletionDate(v string) *ExportJobResponse {
	s.CompletionDate = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ExportJobResponse) SetCreationDate(v string) *ExportJobResponse {
	s.CreationDate = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *ExportJobResponse) SetDefinition(v *ExportJobResource) *ExportJobResponse {
	s.Definition = v
	return s
}

// SetFailedPieces sets the FailedPieces field's value.
func (s *ExportJobResponse) SetFailedPieces(v int64) *ExportJobResponse {
	s.FailedPieces = &v
	return s
}

// SetFailures sets the Failures field's value.
func (s *ExportJobResponse) SetFailures(v []*string) *ExportJobResponse {
	s.Failures = v
	return s
}

// SetId sets the Id field's value.
func (s *ExportJobResponse) SetId(v string) *ExportJobResponse {
	s.Id = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ExportJobResponse) SetJobStatus(v string) *ExportJobResponse {
	s.JobStatus = &v
	return s
}

// SetTotalFailures sets the TotalFailures field's value.
func (s *ExportJobResponse) SetTotalFailures(v int64) *ExportJobResponse {
	s.TotalFailures = &v
	return s
}

// SetTotalPieces sets the TotalPieces field's value.
func (s *ExportJobResponse) SetTotalPieces(v int64) *ExportJobResponse {
	s.TotalPieces = &v
	return s
}

// SetTotalProcessed sets the TotalProcessed field's value.
func (s *ExportJobResponse) SetTotalProcessed(v int64) *ExportJobResponse {
	s.TotalProcessed = &v
	return s
}

// SetType sets the Type field's value.
func (s *ExportJobResponse) SetType(v string) *ExportJobResponse {
	s.Type = &v
	return s
}

// Export job list.
type ExportJobsResponse struct {
	_ struct{} `type:"structure"`

	// A list of export jobs for the application.
	Item []*ExportJobResponse `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ExportJobsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportJobsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *ExportJobsResponse) SetItem(v []*ExportJobResponse) *ExportJobsResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ExportJobsResponse) SetNextToken(v string) *ExportJobsResponse {
	s.NextToken = &v
	return s
}

// Google Cloud Messaging credentials
type GCMChannelRequest struct {
	_ struct{} `type:"structure"`

	// Platform credential API key from Google.
	ApiKey *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s GCMChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GCMChannelRequest) GoString() string {
	return s.String()
}

// SetApiKey sets the ApiKey field's value.
func (s *GCMChannelRequest) SetApiKey(v string) *GCMChannelRequest {
	s.ApiKey = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *GCMChannelRequest) SetEnabled(v bool) *GCMChannelRequest {
	s.Enabled = &v
	return s
}

// Google Cloud Messaging channel definition
type GCMChannelResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the application to which the channel applies.
	ApplicationId *string `type:"string"`

	// When was this segment created
	CreationDate *string `type:"string"`

	// The GCM API key from Google.
	Credential *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// Indicates whether the channel is configured with FCM or GCM credentials.
	// Amazon Pinpoint uses your credentials to authenticate push notifications
	// with FCM or GCM. Provide your credentials by setting the ApiKey attribute.
	HasCredential *bool `type:"boolean"`

	// Channel ID. Not used. Present only for backwards compatibility.
	Id *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who last updated this entry
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// The platform type. Will be GCM
	Platform *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s GCMChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GCMChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GCMChannelResponse) SetApplicationId(v string) *GCMChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *GCMChannelResponse) SetCreationDate(v string) *GCMChannelResponse {
	s.CreationDate = &v
	return s
}

// SetCredential sets the Credential field's value.
func (s *GCMChannelResponse) SetCredential(v string) *GCMChannelResponse {
	s.Credential = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *GCMChannelResponse) SetEnabled(v bool) *GCMChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *GCMChannelResponse) SetHasCredential(v bool) *GCMChannelResponse {
	s.HasCredential = &v
	return s
}

// SetId sets the Id field's value.
func (s *GCMChannelResponse) SetId(v string) *GCMChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *GCMChannelResponse) SetIsArchived(v bool) *GCMChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *GCMChannelResponse) SetLastModifiedBy(v string) *GCMChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *GCMChannelResponse) SetLastModifiedDate(v string) *GCMChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *GCMChannelResponse) SetPlatform(v string) *GCMChannelResponse {
	s.Platform = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GCMChannelResponse) SetVersion(v int64) *GCMChannelResponse {
	s.Version = &v
	return s
}

// GCM Message.
type GCMMessage struct {
	_ struct{} `type:"structure"`

	// The action that occurs if the user taps a push notification delivered by
	// the campaign: OPEN_APP - Your app launches, or it becomes the foreground
	// app if it has been sent to the background. This is the default action. DEEP_LINK
	// - Uses deep linking features in iOS and Android to open your app and display
	// a designated user interface within the app. URL - The default mobile browser
	// on the user's device launches and opens a web page at the URL you specify.
	// Possible values include: OPEN_APP | DEEP_LINK | URL
	Action *string `type:"string" enum:"Action"`

	// The message body of the notification, the email body or the text message.
	Body *string `type:"string"`

	// This parameter identifies a group of messages (e.g., with collapse_key: "Updates
	// Available") that can be collapsed, so that only the last message gets sent
	// when delivery can be resumed. This is intended to avoid sending too many
	// of the same messages when the device comes back online or becomes active.
	CollapseKey *string `type:"string"`

	// The data payload used for a silent push. This payload is added to the notifications'
	// data.pinpoint.jsonBody' object
	Data map[string]*string `type:"map"`

	// The icon image name of the asset saved in your application.
	IconReference *string `type:"string"`

	// The URL that points to an image used as the large icon to the notification
	// content view.
	ImageIconUrl *string `type:"string"`

	// The URL that points to an image used in the push notification.
	ImageUrl *string `type:"string"`

	// The message priority. Amazon Pinpoint uses this value to set the FCM or GCM
	// priority parameter when it sends the message. Accepts the following values:"Normal"
	// - Messages might be delayed. Delivery is optimized for battery usage on the
	// receiving device. Use normal priority unless immediate delivery is required."High"
	// - Messages are sent immediately and might wake a sleeping device.The equivalent
	// values for APNs messages are "5" and "10". Amazon Pinpoint accepts these
	// values here and converts them.For more information, see About FCM Messages
	// in the Firebase documentation.
	Priority *string `type:"string"`

	// The Raw JSON formatted string to be used as the payload. This value overrides
	// the message.
	RawContent *string `type:"string"`

	// This parameter specifies the package name of the application where the registration
	// tokens must match in order to receive the message.
	RestrictedPackageName *string `type:"string"`

	// Indicates if the message should display on the users device. Silent pushes
	// can be used for Remote Configuration and Phone Home use cases.
	SilentPush *bool `type:"boolean"`

	// The URL that points to an image used as the small icon for the notification
	// which will be used to represent the notification in the status bar and content
	// view
	SmallImageIconUrl *string `type:"string"`

	// Indicates a sound to play when the device receives the notification. Supports
	// default, or the filename of a sound resource bundled in the app. Android
	// sound files must reside in /res/raw/
	Sound *string `type:"string"`

	Substitutions map[string][]*string `type:"map"`

	// The length of time (in seconds) that FCM or GCM stores and attempts to deliver
	// the message. If unspecified, the value defaults to the maximum, which is
	// 2,419,200 seconds (28 days). Amazon Pinpoint uses this value to set the FCM
	// or GCM time_to_live parameter.
	TimeToLive *int64 `type:"integer"`

	// The message title that displays above the message on the user's device.
	Title *string `type:"string"`

	// The URL to open in the user's mobile browser. Used if the value for Action
	// is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s GCMMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GCMMessage) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *GCMMessage) SetAction(v string) *GCMMessage {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *GCMMessage) SetBody(v string) *GCMMessage {
	s.Body = &v
	return s
}

// SetCollapseKey sets the CollapseKey field's value.
func (s *GCMMessage) SetCollapseKey(v string) *GCMMessage {
	s.CollapseKey = &v
	return s
}

// SetData sets the Data field's value.
func (s *GCMMessage) SetData(v map[string]*string) *GCMMessage {
	s.Data = v
	return s
}

// SetIconReference sets the IconReference field's value.
func (s *GCMMessage) SetIconReference(v string) *GCMMessage {
	s.IconReference = &v
	return s
}

// SetImageIconUrl sets the ImageIconUrl field's value.
func (s *GCMMessage) SetImageIconUrl(v string) *GCMMessage {
	s.ImageIconUrl = &v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *GCMMessage) SetImageUrl(v string) *GCMMessage {
	s.ImageUrl = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *GCMMessage) SetPriority(v string) *GCMMessage {
	s.Priority = &v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *GCMMessage) SetRawContent(v string) *GCMMessage {
	s.RawContent = &v
	return s
}

// SetRestrictedPackageName sets the RestrictedPackageName field's value.
func (s *GCMMessage) SetRestrictedPackageName(v string) *GCMMessage {
	s.RestrictedPackageName = &v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *GCMMessage) SetSilentPush(v bool) *GCMMessage {
	s.SilentPush = &v
	return s
}

// SetSmallImageIconUrl sets the SmallImageIconUrl field's value.
func (s *GCMMessage) SetSmallImageIconUrl(v string) *GCMMessage {
	s.SmallImageIconUrl = &v
	return s
}

// SetSound sets the Sound field's value.
func (s *GCMMessage) SetSound(v string) *GCMMessage {
	s.Sound = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *GCMMessage) SetSubstitutions(v map[string][]*string) *GCMMessage {
	s.Substitutions = v
	return s
}

// SetTimeToLive sets the TimeToLive field's value.
func (s *GCMMessage) SetTimeToLive(v int64) *GCMMessage {
	s.TimeToLive = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *GCMMessage) SetTitle(v string) *GCMMessage {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *GCMMessage) SetUrl(v string) *GCMMessage {
	s.Url = &v
	return s
}

type GetAdmChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAdmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAdmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAdmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAdmChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetAdmChannelInput) SetApplicationId(v string) *GetAdmChannelInput {
	s.ApplicationId = &v
	return s
}

type GetAdmChannelOutput struct {
	_ struct{} `type:"structure" payload:"ADMChannelResponse"`

	// Amazon Device Messaging channel definition.
	//
	// ADMChannelResponse is a required field
	ADMChannelResponse *ADMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetAdmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAdmChannelOutput) GoString() string {
	return s.String()
}

// SetADMChannelResponse sets the ADMChannelResponse field's value.
func (s *GetAdmChannelOutput) SetADMChannelResponse(v *ADMChannelResponse) *GetAdmChannelOutput {
	s.ADMChannelResponse = v
	return s
}

type GetApnsChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApnsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApnsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApnsChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApnsChannelInput) SetApplicationId(v string) *GetApnsChannelInput {
	s.ApplicationId = &v
	return s
}

type GetApnsChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSChannelResponse"`

	// Apple Distribution Push Notification Service channel definition.
	//
	// APNSChannelResponse is a required field
	APNSChannelResponse *APNSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApnsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSChannelResponse sets the APNSChannelResponse field's value.
func (s *GetApnsChannelOutput) SetAPNSChannelResponse(v *APNSChannelResponse) *GetApnsChannelOutput {
	s.APNSChannelResponse = v
	return s
}

type GetApnsSandboxChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApnsSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsSandboxChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApnsSandboxChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApnsSandboxChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApnsSandboxChannelInput) SetApplicationId(v string) *GetApnsSandboxChannelInput {
	s.ApplicationId = &v
	return s
}

type GetApnsSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSSandboxChannelResponse"`

	// Apple Development Push Notification Service channel definition.
	//
	// APNSSandboxChannelResponse is a required field
	APNSSandboxChannelResponse *APNSSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApnsSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsSandboxChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSSandboxChannelResponse sets the APNSSandboxChannelResponse field's value.
func (s *GetApnsSandboxChannelOutput) SetAPNSSandboxChannelResponse(v *APNSSandboxChannelResponse) *GetApnsSandboxChannelOutput {
	s.APNSSandboxChannelResponse = v
	return s
}

type GetApnsVoipChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApnsVoipChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsVoipChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApnsVoipChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApnsVoipChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApnsVoipChannelInput) SetApplicationId(v string) *GetApnsVoipChannelInput {
	s.ApplicationId = &v
	return s
}

type GetApnsVoipChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSVoipChannelResponse"`

	// Apple VoIP Push Notification Service channel definition.
	//
	// APNSVoipChannelResponse is a required field
	APNSVoipChannelResponse *APNSVoipChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApnsVoipChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsVoipChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSVoipChannelResponse sets the APNSVoipChannelResponse field's value.
func (s *GetApnsVoipChannelOutput) SetAPNSVoipChannelResponse(v *APNSVoipChannelResponse) *GetApnsVoipChannelOutput {
	s.APNSVoipChannelResponse = v
	return s
}

type GetApnsVoipSandboxChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApnsVoipSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsVoipSandboxChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApnsVoipSandboxChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApnsVoipSandboxChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApnsVoipSandboxChannelInput) SetApplicationId(v string) *GetApnsVoipSandboxChannelInput {
	s.ApplicationId = &v
	return s
}

type GetApnsVoipSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSVoipSandboxChannelResponse"`

	// Apple VoIP Developer Push Notification Service channel definition.
	//
	// APNSVoipSandboxChannelResponse is a required field
	APNSVoipSandboxChannelResponse *APNSVoipSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApnsVoipSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApnsVoipSandboxChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSVoipSandboxChannelResponse sets the APNSVoipSandboxChannelResponse field's value.
func (s *GetApnsVoipSandboxChannelOutput) SetAPNSVoipSandboxChannelResponse(v *APNSVoipSandboxChannelResponse) *GetApnsVoipSandboxChannelOutput {
	s.APNSVoipSandboxChannelResponse = v
	return s
}

type GetAppInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAppInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetAppInput) SetApplicationId(v string) *GetAppInput {
	s.ApplicationId = &v
	return s
}

type GetAppOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationResponse"`

	// Application Response.
	//
	// ApplicationResponse is a required field
	ApplicationResponse *ApplicationResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppOutput) GoString() string {
	return s.String()
}

// SetApplicationResponse sets the ApplicationResponse field's value.
func (s *GetAppOutput) SetApplicationResponse(v *ApplicationResponse) *GetAppOutput {
	s.ApplicationResponse = v
	return s
}

type GetApplicationSettingsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApplicationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationSettingsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetApplicationSettingsInput) SetApplicationId(v string) *GetApplicationSettingsInput {
	s.ApplicationId = &v
	return s
}

type GetApplicationSettingsOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationSettingsResource"`

	// Application settings.
	//
	// ApplicationSettingsResource is a required field
	ApplicationSettingsResource *ApplicationSettingsResource `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetApplicationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationSettingsOutput) GoString() string {
	return s.String()
}

// SetApplicationSettingsResource sets the ApplicationSettingsResource field's value.
func (s *GetApplicationSettingsOutput) SetApplicationSettingsResource(v *ApplicationSettingsResource) *GetApplicationSettingsOutput {
	s.ApplicationSettingsResource = v
	return s
}

type GetAppsInput struct {
	_ struct{} `type:"structure"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetAppsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppsInput) GoString() string {
	return s.String()
}

// SetPageSize sets the PageSize field's value.
func (s *GetAppsInput) SetPageSize(v string) *GetAppsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetAppsInput) SetToken(v string) *GetAppsInput {
	s.Token = &v
	return s
}

type GetAppsOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationsResponse"`

	// Get Applications Result.
	//
	// ApplicationsResponse is a required field
	ApplicationsResponse *ApplicationsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetAppsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAppsOutput) GoString() string {
	return s.String()
}

// SetApplicationsResponse sets the ApplicationsResponse field's value.
func (s *GetAppsOutput) SetApplicationsResponse(v *ApplicationsResponse) *GetAppsOutput {
	s.ApplicationsResponse = v
	return s
}

type GetBaiduChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBaiduChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBaiduChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBaiduChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBaiduChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetBaiduChannelInput) SetApplicationId(v string) *GetBaiduChannelInput {
	s.ApplicationId = &v
	return s
}

type GetBaiduChannelOutput struct {
	_ struct{} `type:"structure" payload:"BaiduChannelResponse"`

	// Baidu Cloud Messaging channel definition
	//
	// BaiduChannelResponse is a required field
	BaiduChannelResponse *BaiduChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetBaiduChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBaiduChannelOutput) GoString() string {
	return s.String()
}

// SetBaiduChannelResponse sets the BaiduChannelResponse field's value.
func (s *GetBaiduChannelOutput) SetBaiduChannelResponse(v *BaiduChannelResponse) *GetBaiduChannelOutput {
	s.BaiduChannelResponse = v
	return s
}

type GetCampaignActivitiesInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetCampaignActivitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignActivitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignActivitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignActivitiesInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignActivitiesInput) SetApplicationId(v string) *GetCampaignActivitiesInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetCampaignActivitiesInput) SetCampaignId(v string) *GetCampaignActivitiesInput {
	s.CampaignId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetCampaignActivitiesInput) SetPageSize(v string) *GetCampaignActivitiesInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetCampaignActivitiesInput) SetToken(v string) *GetCampaignActivitiesInput {
	s.Token = &v
	return s
}

type GetCampaignActivitiesOutput struct {
	_ struct{} `type:"structure" payload:"ActivitiesResponse"`

	// Activities for campaign.
	//
	// ActivitiesResponse is a required field
	ActivitiesResponse *ActivitiesResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignActivitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignActivitiesOutput) GoString() string {
	return s.String()
}

// SetActivitiesResponse sets the ActivitiesResponse field's value.
func (s *GetCampaignActivitiesOutput) SetActivitiesResponse(v *ActivitiesResponse) *GetCampaignActivitiesOutput {
	s.ActivitiesResponse = v
	return s
}

type GetCampaignInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignInput) SetApplicationId(v string) *GetCampaignInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetCampaignInput) SetCampaignId(v string) *GetCampaignInput {
	s.CampaignId = &v
	return s
}

type GetCampaignOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// Campaign definition
	//
	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *GetCampaignOutput) SetCampaignResponse(v *CampaignResponse) *GetCampaignOutput {
	s.CampaignResponse = v
	return s
}

type GetCampaignVersionInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`

	// Version is a required field
	Version *string `location:"uri" locationName:"version" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCampaignVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignVersionInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignVersionInput) SetApplicationId(v string) *GetCampaignVersionInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetCampaignVersionInput) SetCampaignId(v string) *GetCampaignVersionInput {
	s.CampaignId = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetCampaignVersionInput) SetVersion(v string) *GetCampaignVersionInput {
	s.Version = &v
	return s
}

type GetCampaignVersionOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// Campaign definition
	//
	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignVersionOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *GetCampaignVersionOutput) SetCampaignResponse(v *CampaignResponse) *GetCampaignVersionOutput {
	s.CampaignResponse = v
	return s
}

type GetCampaignVersionsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetCampaignVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignVersionsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignVersionsInput) SetApplicationId(v string) *GetCampaignVersionsInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *GetCampaignVersionsInput) SetCampaignId(v string) *GetCampaignVersionsInput {
	s.CampaignId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetCampaignVersionsInput) SetPageSize(v string) *GetCampaignVersionsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetCampaignVersionsInput) SetToken(v string) *GetCampaignVersionsInput {
	s.Token = &v
	return s
}

type GetCampaignVersionsOutput struct {
	_ struct{} `type:"structure" payload:"CampaignsResponse"`

	// List of available campaigns.
	//
	// CampaignsResponse is a required field
	CampaignsResponse *CampaignsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignVersionsOutput) GoString() string {
	return s.String()
}

// SetCampaignsResponse sets the CampaignsResponse field's value.
func (s *GetCampaignVersionsOutput) SetCampaignsResponse(v *CampaignsResponse) *GetCampaignVersionsOutput {
	s.CampaignsResponse = v
	return s
}

type GetCampaignsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetCampaignsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCampaignsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCampaignsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetCampaignsInput) SetApplicationId(v string) *GetCampaignsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetCampaignsInput) SetPageSize(v string) *GetCampaignsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetCampaignsInput) SetToken(v string) *GetCampaignsInput {
	s.Token = &v
	return s
}

type GetCampaignsOutput struct {
	_ struct{} `type:"structure" payload:"CampaignsResponse"`

	// List of available campaigns.
	//
	// CampaignsResponse is a required field
	CampaignsResponse *CampaignsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCampaignsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCampaignsOutput) GoString() string {
	return s.String()
}

// SetCampaignsResponse sets the CampaignsResponse field's value.
func (s *GetCampaignsOutput) SetCampaignsResponse(v *CampaignsResponse) *GetCampaignsOutput {
	s.CampaignsResponse = v
	return s
}

type GetEmailChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEmailChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEmailChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEmailChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEmailChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetEmailChannelInput) SetApplicationId(v string) *GetEmailChannelInput {
	s.ApplicationId = &v
	return s
}

type GetEmailChannelOutput struct {
	_ struct{} `type:"structure" payload:"EmailChannelResponse"`

	// Email Channel Response.
	//
	// EmailChannelResponse is a required field
	EmailChannelResponse *EmailChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetEmailChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEmailChannelOutput) GoString() string {
	return s.String()
}

// SetEmailChannelResponse sets the EmailChannelResponse field's value.
func (s *GetEmailChannelOutput) SetEmailChannelResponse(v *EmailChannelResponse) *GetEmailChannelOutput {
	s.EmailChannelResponse = v
	return s
}

type GetEndpointInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// EndpointId is a required field
	EndpointId *string `location:"uri" locationName:"endpoint-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEndpointInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetEndpointInput) SetApplicationId(v string) *GetEndpointInput {
	s.ApplicationId = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *GetEndpointInput) SetEndpointId(v string) *GetEndpointInput {
	s.EndpointId = &v
	return s
}

type GetEndpointOutput struct {
	_ struct{} `type:"structure" payload:"EndpointResponse"`

	// Endpoint response
	//
	// EndpointResponse is a required field
	EndpointResponse *EndpointResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointResponse sets the EndpointResponse field's value.
func (s *GetEndpointOutput) SetEndpointResponse(v *EndpointResponse) *GetEndpointOutput {
	s.EndpointResponse = v
	return s
}

type GetEventStreamInput struct {
	_ struct{} `type:"structure"`

	// Application Id.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEventStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventStreamInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetEventStreamInput) SetApplicationId(v string) *GetEventStreamInput {
	s.ApplicationId = &v
	return s
}

type GetEventStreamOutput struct {
	_ struct{} `type:"structure" payload:"EventStream"`

	// Model for an event publishing subscription export.
	//
	// EventStream is a required field
	EventStream *EventStream `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetEventStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventStreamOutput) GoString() string {
	return s.String()
}

// SetEventStream sets the EventStream field's value.
func (s *GetEventStreamOutput) SetEventStream(v *EventStream) *GetEventStreamOutput {
	s.EventStream = v
	return s
}

type GetExportJobInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// JobId is a required field
	JobId *string `location:"uri" locationName:"job-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExportJobInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetExportJobInput) SetApplicationId(v string) *GetExportJobInput {
	s.ApplicationId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetExportJobInput) SetJobId(v string) *GetExportJobInput {
	s.JobId = &v
	return s
}

type GetExportJobOutput struct {
	_ struct{} `type:"structure" payload:"ExportJobResponse"`

	// ExportJobResponse is a required field
	ExportJobResponse *ExportJobResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExportJobOutput) GoString() string {
	return s.String()
}

// SetExportJobResponse sets the ExportJobResponse field's value.
func (s *GetExportJobOutput) SetExportJobResponse(v *ExportJobResponse) *GetExportJobOutput {
	s.ExportJobResponse = v
	return s
}

type GetExportJobsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetExportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExportJobsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetExportJobsInput) SetApplicationId(v string) *GetExportJobsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetExportJobsInput) SetPageSize(v string) *GetExportJobsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetExportJobsInput) SetToken(v string) *GetExportJobsInput {
	s.Token = &v
	return s
}

type GetExportJobsOutput struct {
	_ struct{} `type:"structure" payload:"ExportJobsResponse"`

	// Export job list.
	//
	// ExportJobsResponse is a required field
	ExportJobsResponse *ExportJobsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetExportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExportJobsOutput) GoString() string {
	return s.String()
}

// SetExportJobsResponse sets the ExportJobsResponse field's value.
func (s *GetExportJobsOutput) SetExportJobsResponse(v *ExportJobsResponse) *GetExportJobsOutput {
	s.ExportJobsResponse = v
	return s
}

type GetGcmChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGcmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGcmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGcmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGcmChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetGcmChannelInput) SetApplicationId(v string) *GetGcmChannelInput {
	s.ApplicationId = &v
	return s
}

type GetGcmChannelOutput struct {
	_ struct{} `type:"structure" payload:"GCMChannelResponse"`

	// Google Cloud Messaging channel definition
	//
	// GCMChannelResponse is a required field
	GCMChannelResponse *GCMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetGcmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGcmChannelOutput) GoString() string {
	return s.String()
}

// SetGCMChannelResponse sets the GCMChannelResponse field's value.
func (s *GetGcmChannelOutput) SetGCMChannelResponse(v *GCMChannelResponse) *GetGcmChannelOutput {
	s.GCMChannelResponse = v
	return s
}

type GetImportJobInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// JobId is a required field
	JobId *string `location:"uri" locationName:"job-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetImportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImportJobInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetImportJobInput) SetApplicationId(v string) *GetImportJobInput {
	s.ApplicationId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetImportJobInput) SetJobId(v string) *GetImportJobInput {
	s.JobId = &v
	return s
}

type GetImportJobOutput struct {
	_ struct{} `type:"structure" payload:"ImportJobResponse"`

	// ImportJobResponse is a required field
	ImportJobResponse *ImportJobResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetImportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportJobOutput) GoString() string {
	return s.String()
}

// SetImportJobResponse sets the ImportJobResponse field's value.
func (s *GetImportJobOutput) SetImportJobResponse(v *ImportJobResponse) *GetImportJobOutput {
	s.ImportJobResponse = v
	return s
}

type GetImportJobsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetImportJobsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetImportJobsInput) SetApplicationId(v string) *GetImportJobsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetImportJobsInput) SetPageSize(v string) *GetImportJobsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetImportJobsInput) SetToken(v string) *GetImportJobsInput {
	s.Token = &v
	return s
}

type GetImportJobsOutput struct {
	_ struct{} `type:"structure" payload:"ImportJobsResponse"`

	// Import job list.
	//
	// ImportJobsResponse is a required field
	ImportJobsResponse *ImportJobsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetImportJobsOutput) GoString() string {
	return s.String()
}

// SetImportJobsResponse sets the ImportJobsResponse field's value.
func (s *GetImportJobsOutput) SetImportJobsResponse(v *ImportJobsResponse) *GetImportJobsOutput {
	s.ImportJobsResponse = v
	return s
}

type GetSegmentExportJobsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetSegmentExportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentExportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentExportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentExportJobsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentExportJobsInput) SetApplicationId(v string) *GetSegmentExportJobsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetSegmentExportJobsInput) SetPageSize(v string) *GetSegmentExportJobsInput {
	s.PageSize = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentExportJobsInput) SetSegmentId(v string) *GetSegmentExportJobsInput {
	s.SegmentId = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetSegmentExportJobsInput) SetToken(v string) *GetSegmentExportJobsInput {
	s.Token = &v
	return s
}

type GetSegmentExportJobsOutput struct {
	_ struct{} `type:"structure" payload:"ExportJobsResponse"`

	// Export job list.
	//
	// ExportJobsResponse is a required field
	ExportJobsResponse *ExportJobsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentExportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentExportJobsOutput) GoString() string {
	return s.String()
}

// SetExportJobsResponse sets the ExportJobsResponse field's value.
func (s *GetSegmentExportJobsOutput) SetExportJobsResponse(v *ExportJobsResponse) *GetSegmentExportJobsOutput {
	s.ExportJobsResponse = v
	return s
}

type GetSegmentImportJobsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetSegmentImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentImportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentImportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentImportJobsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentImportJobsInput) SetApplicationId(v string) *GetSegmentImportJobsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetSegmentImportJobsInput) SetPageSize(v string) *GetSegmentImportJobsInput {
	s.PageSize = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentImportJobsInput) SetSegmentId(v string) *GetSegmentImportJobsInput {
	s.SegmentId = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetSegmentImportJobsInput) SetToken(v string) *GetSegmentImportJobsInput {
	s.Token = &v
	return s
}

type GetSegmentImportJobsOutput struct {
	_ struct{} `type:"structure" payload:"ImportJobsResponse"`

	// Import job list.
	//
	// ImportJobsResponse is a required field
	ImportJobsResponse *ImportJobsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentImportJobsOutput) GoString() string {
	return s.String()
}

// SetImportJobsResponse sets the ImportJobsResponse field's value.
func (s *GetSegmentImportJobsOutput) SetImportJobsResponse(v *ImportJobsResponse) *GetSegmentImportJobsOutput {
	s.ImportJobsResponse = v
	return s
}

type GetSegmentInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentInput) SetApplicationId(v string) *GetSegmentInput {
	s.ApplicationId = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentInput) SetSegmentId(v string) *GetSegmentInput {
	s.SegmentId = &v
	return s
}

type GetSegmentOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// Segment definition.
	//
	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *GetSegmentOutput) SetSegmentResponse(v *SegmentResponse) *GetSegmentOutput {
	s.SegmentResponse = v
	return s
}

type GetSegmentVersionInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	// Version is a required field
	Version *string `location:"uri" locationName:"version" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSegmentVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentVersionInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentVersionInput) SetApplicationId(v string) *GetSegmentVersionInput {
	s.ApplicationId = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentVersionInput) SetSegmentId(v string) *GetSegmentVersionInput {
	s.SegmentId = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetSegmentVersionInput) SetVersion(v string) *GetSegmentVersionInput {
	s.Version = &v
	return s
}

type GetSegmentVersionOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// Segment definition.
	//
	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentVersionOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *GetSegmentVersionOutput) SetSegmentResponse(v *SegmentResponse) *GetSegmentVersionOutput {
	s.SegmentResponse = v
	return s
}

type GetSegmentVersionsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetSegmentVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentVersionsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentVersionsInput) SetApplicationId(v string) *GetSegmentVersionsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetSegmentVersionsInput) SetPageSize(v string) *GetSegmentVersionsInput {
	s.PageSize = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *GetSegmentVersionsInput) SetSegmentId(v string) *GetSegmentVersionsInput {
	s.SegmentId = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetSegmentVersionsInput) SetToken(v string) *GetSegmentVersionsInput {
	s.Token = &v
	return s
}

type GetSegmentVersionsOutput struct {
	_ struct{} `type:"structure" payload:"SegmentsResponse"`

	// Segments in your account.
	//
	// SegmentsResponse is a required field
	SegmentsResponse *SegmentsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentVersionsOutput) GoString() string {
	return s.String()
}

// SetSegmentsResponse sets the SegmentsResponse field's value.
func (s *GetSegmentVersionsOutput) SetSegmentsResponse(v *SegmentsResponse) *GetSegmentVersionsOutput {
	s.SegmentsResponse = v
	return s
}

type GetSegmentsInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	PageSize *string `location:"querystring" locationName:"page-size" type:"string"`

	Token *string `location:"querystring" locationName:"token" type:"string"`
}

// String returns the string representation
func (s GetSegmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSegmentsInput) SetApplicationId(v string) *GetSegmentsInput {
	s.ApplicationId = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetSegmentsInput) SetPageSize(v string) *GetSegmentsInput {
	s.PageSize = &v
	return s
}

// SetToken sets the Token field's value.
func (s *GetSegmentsInput) SetToken(v string) *GetSegmentsInput {
	s.Token = &v
	return s
}

type GetSegmentsOutput struct {
	_ struct{} `type:"structure" payload:"SegmentsResponse"`

	// Segments in your account.
	//
	// SegmentsResponse is a required field
	SegmentsResponse *SegmentsResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSegmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSegmentsOutput) GoString() string {
	return s.String()
}

// SetSegmentsResponse sets the SegmentsResponse field's value.
func (s *GetSegmentsOutput) SetSegmentsResponse(v *SegmentsResponse) *GetSegmentsOutput {
	s.SegmentsResponse = v
	return s
}

type GetSmsChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSmsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSmsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSmsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSmsChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *GetSmsChannelInput) SetApplicationId(v string) *GetSmsChannelInput {
	s.ApplicationId = &v
	return s
}

type GetSmsChannelOutput struct {
	_ struct{} `type:"structure" payload:"SMSChannelResponse"`

	// SMS Channel Response.
	//
	// SMSChannelResponse is a required field
	SMSChannelResponse *SMSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetSmsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSmsChannelOutput) GoString() string {
	return s.String()
}

// SetSMSChannelResponse sets the SMSChannelResponse field's value.
func (s *GetSmsChannelOutput) SetSMSChannelResponse(v *SMSChannelResponse) *GetSmsChannelOutput {
	s.SMSChannelResponse = v
	return s
}

type ImportJobRequest struct {
	_ struct{} `type:"structure"`

	// Sets whether the endpoints create a segment when they are imported.
	DefineSegment *bool `type:"boolean"`

	// DEPRECATED. Your AWS account ID, which you assigned to the ExternalID key
	// in an IAM trust policy. Used by Amazon Pinpoint to assume an IAM role. This
	// requirement is removed, and external IDs are not recommended for IAM roles
	// assumed by Amazon Pinpoint.
	ExternalId *string `type:"string"`

	// The format of the files that contain the endpoint definitions.Valid values:
	// CSV, JSON
	Format *string `type:"string" enum:"Format"`

	// Sets whether the endpoints are registered with Amazon Pinpoint when they
	// are imported.
	RegisterEndpoints *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint
	// access to the Amazon S3 location that contains the endpoints to import.
	RoleArn *string `type:"string"`

	// A URL that points to the location within an Amazon S3 bucket that contains
	// the endpoints to import. The location can be a folder or a single file.The
	// URL should follow this format: s3://bucket-name/folder-name/file-nameAmazon
	// Pinpoint will import endpoints from this location and any subfolders it contains.
	S3Url *string `type:"string"`

	// The ID of the segment to update if the import job is meant to update an existing
	// segment.
	SegmentId *string `type:"string"`

	// A custom name for the segment created by the import job. Use if DefineSegment
	// is true.
	SegmentName *string `type:"string"`
}

// String returns the string representation
func (s ImportJobRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportJobRequest) GoString() string {
	return s.String()
}

// SetDefineSegment sets the DefineSegment field's value.
func (s *ImportJobRequest) SetDefineSegment(v bool) *ImportJobRequest {
	s.DefineSegment = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *ImportJobRequest) SetExternalId(v string) *ImportJobRequest {
	s.ExternalId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ImportJobRequest) SetFormat(v string) *ImportJobRequest {
	s.Format = &v
	return s
}

// SetRegisterEndpoints sets the RegisterEndpoints field's value.
func (s *ImportJobRequest) SetRegisterEndpoints(v bool) *ImportJobRequest {
	s.RegisterEndpoints = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ImportJobRequest) SetRoleArn(v string) *ImportJobRequest {
	s.RoleArn = &v
	return s
}

// SetS3Url sets the S3Url field's value.
func (s *ImportJobRequest) SetS3Url(v string) *ImportJobRequest {
	s.S3Url = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *ImportJobRequest) SetSegmentId(v string) *ImportJobRequest {
	s.SegmentId = &v
	return s
}

// SetSegmentName sets the SegmentName field's value.
func (s *ImportJobRequest) SetSegmentName(v string) *ImportJobRequest {
	s.SegmentName = &v
	return s
}

type ImportJobResource struct {
	_ struct{} `type:"structure"`

	// Sets whether the endpoints create a segment when they are imported.
	DefineSegment *bool `type:"boolean"`

	// DEPRECATED. Your AWS account ID, which you assigned to the ExternalID key
	// in an IAM trust policy. Used by Amazon Pinpoint to assume an IAM role. This
	// requirement is removed, and external IDs are not recommended for IAM roles
	// assumed by Amazon Pinpoint.
	ExternalId *string `type:"string"`

	// The format of the files that contain the endpoint definitions.Valid values:
	// CSV, JSON
	Format *string `type:"string" enum:"Format"`

	// Sets whether the endpoints are registered with Amazon Pinpoint when they
	// are imported.
	RegisterEndpoints *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint
	// access to the Amazon S3 location that contains the endpoints to import.
	RoleArn *string `type:"string"`

	// A URL that points to the location within an Amazon S3 bucket that contains
	// the endpoints to import. The location can be a folder or a single file.The
	// URL should follow this format: s3://bucket-name/folder-name/file-nameAmazon
	// Pinpoint will import endpoints from this location and any subfolders it contains.
	S3Url *string `type:"string"`

	// The ID of the segment to update if the import job is meant to update an existing
	// segment.
	SegmentId *string `type:"string"`

	// A custom name for the segment created by the import job. Use if DefineSegment
	// is true.
	SegmentName *string `type:"string"`
}

// String returns the string representation
func (s ImportJobResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportJobResource) GoString() string {
	return s.String()
}

// SetDefineSegment sets the DefineSegment field's value.
func (s *ImportJobResource) SetDefineSegment(v bool) *ImportJobResource {
	s.DefineSegment = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *ImportJobResource) SetExternalId(v string) *ImportJobResource {
	s.ExternalId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ImportJobResource) SetFormat(v string) *ImportJobResource {
	s.Format = &v
	return s
}

// SetRegisterEndpoints sets the RegisterEndpoints field's value.
func (s *ImportJobResource) SetRegisterEndpoints(v bool) *ImportJobResource {
	s.RegisterEndpoints = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ImportJobResource) SetRoleArn(v string) *ImportJobResource {
	s.RoleArn = &v
	return s
}

// SetS3Url sets the S3Url field's value.
func (s *ImportJobResource) SetS3Url(v string) *ImportJobResource {
	s.S3Url = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *ImportJobResource) SetSegmentId(v string) *ImportJobResource {
	s.SegmentId = &v
	return s
}

// SetSegmentName sets the SegmentName field's value.
func (s *ImportJobResource) SetSegmentName(v string) *ImportJobResource {
	s.SegmentName = &v
	return s
}

type ImportJobResponse struct {
	_ struct{} `type:"structure"`

	// The unique ID of the application to which the import job applies.
	ApplicationId *string `type:"string"`

	// The number of pieces that have successfully imported as of the time of the
	// request.
	CompletedPieces *int64 `type:"integer"`

	// The date the import job completed in ISO 8601 format.
	CompletionDate *string `type:"string"`

	// The date the import job was created in ISO 8601 format.
	CreationDate *string `type:"string"`

	// The import job settings.
	Definition *ImportJobResource `type:"structure"`

	// The number of pieces that have failed to import as of the time of the request.
	FailedPieces *int64 `type:"integer"`

	Failures []*string `type:"list"`

	// The unique ID of the import job.
	Id *string `type:"string"`

	// The status of the import job.Valid values: CREATED, INITIALIZING, PROCESSING,
	// COMPLETING, COMPLETED, FAILING, FAILEDThe job status is FAILED if one or
	// more pieces failed to import.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// The number of endpoints that failed to import; for example, because of syntax
	// errors.
	TotalFailures *int64 `type:"integer"`

	// The total number of pieces that must be imported to finish the job. Each
	// piece is an approximately equal portion of the endpoints to import.
	TotalPieces *int64 `type:"integer"`

	// The number of endpoints that were processed by the import job.
	TotalProcessed *int64 `type:"integer"`

	// The job type. Will be Import.
	Type *string `type:"string"`
}

// String returns the string representation
func (s ImportJobResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportJobResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *ImportJobResponse) SetApplicationId(v string) *ImportJobResponse {
	s.ApplicationId = &v
	return s
}

// SetCompletedPieces sets the CompletedPieces field's value.
func (s *ImportJobResponse) SetCompletedPieces(v int64) *ImportJobResponse {
	s.CompletedPieces = &v
	return s
}

// SetCompletionDate sets the CompletionDate field's value.
func (s *ImportJobResponse) SetCompletionDate(v string) *ImportJobResponse {
	s.CompletionDate = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ImportJobResponse) SetCreationDate(v string) *ImportJobResponse {
	s.CreationDate = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *ImportJobResponse) SetDefinition(v *ImportJobResource) *ImportJobResponse {
	s.Definition = v
	return s
}

// SetFailedPieces sets the FailedPieces field's value.
func (s *ImportJobResponse) SetFailedPieces(v int64) *ImportJobResponse {
	s.FailedPieces = &v
	return s
}

// SetFailures sets the Failures field's value.
func (s *ImportJobResponse) SetFailures(v []*string) *ImportJobResponse {
	s.Failures = v
	return s
}

// SetId sets the Id field's value.
func (s *ImportJobResponse) SetId(v string) *ImportJobResponse {
	s.Id = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ImportJobResponse) SetJobStatus(v string) *ImportJobResponse {
	s.JobStatus = &v
	return s
}

// SetTotalFailures sets the TotalFailures field's value.
func (s *ImportJobResponse) SetTotalFailures(v int64) *ImportJobResponse {
	s.TotalFailures = &v
	return s
}

// SetTotalPieces sets the TotalPieces field's value.
func (s *ImportJobResponse) SetTotalPieces(v int64) *ImportJobResponse {
	s.TotalPieces = &v
	return s
}

// SetTotalProcessed sets the TotalProcessed field's value.
func (s *ImportJobResponse) SetTotalProcessed(v int64) *ImportJobResponse {
	s.TotalProcessed = &v
	return s
}

// SetType sets the Type field's value.
func (s *ImportJobResponse) SetType(v string) *ImportJobResponse {
	s.Type = &v
	return s
}

// Import job list.
type ImportJobsResponse struct {
	_ struct{} `type:"structure"`

	// A list of import jobs for the application.
	Item []*ImportJobResponse `type:"list"`

	// The string that you use in a subsequent request to get the next page of results
	// in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ImportJobsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportJobsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *ImportJobsResponse) SetItem(v []*ImportJobResponse) *ImportJobsResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ImportJobsResponse) SetNextToken(v string) *ImportJobsResponse {
	s.NextToken = &v
	return s
}

type Message struct {
	_ struct{} `type:"structure"`

	// The action that occurs if the user taps a push notification delivered by
	// the campaign:OPEN_APP - Your app launches, or it becomes the foreground app
	// if it has been sent to the background. This is the default action.DEEP_LINK
	// - Uses deep linking features in iOS and Android to open your app and display
	// a designated user interface within the app.URL - The default mobile browser
	// on the user's device launches and opens a web page at the URL you specify.
	Action *string `type:"string" enum:"Action"`

	// The message body. Can include up to 140 characters.
	Body *string `type:"string"`

	// The URL that points to the icon image for the push notification icon, for
	// example, the app icon.
	ImageIconUrl *string `type:"string"`

	// The URL that points to the small icon image for the push notification icon,
	// for example, the app icon.
	ImageSmallIconUrl *string `type:"string"`

	// The URL that points to an image used in the push notification.
	ImageUrl *string `type:"string"`

	// The JSON payload used for a silent push.
	JsonBody *string `type:"string"`

	// The URL that points to the media resource, for example a .mp4 or .gif file.
	MediaUrl *string `type:"string"`

	// The Raw JSON formatted string to be used as the payload. This value overrides
	// the message.
	RawContent *string `type:"string"`

	// Indicates if the message should display on the users device.Silent pushes
	// can be used for Remote Configuration and Phone Home use cases.
	SilentPush *bool `type:"boolean"`

	// The message title that displays above the message on the user's device.
	Title *string `type:"string"`

	// The URL to open in the user's mobile browser. Used if the value for Action
	// is URL.
	Url *string `type:"string"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Message) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *Message) SetAction(v string) *Message {
	s.Action = &v
	return s
}

// SetBody sets the Body field's value.
func (s *Message) SetBody(v string) *Message {
	s.Body = &v
	return s
}

// SetImageIconUrl sets the ImageIconUrl field's value.
func (s *Message) SetImageIconUrl(v string) *Message {
	s.ImageIconUrl = &v
	return s
}

// SetImageSmallIconUrl sets the ImageSmallIconUrl field's value.
func (s *Message) SetImageSmallIconUrl(v string) *Message {
	s.ImageSmallIconUrl = &v
	return s
}

// SetImageUrl sets the ImageUrl field's value.
func (s *Message) SetImageUrl(v string) *Message {
	s.ImageUrl = &v
	return s
}

// SetJsonBody sets the JsonBody field's value.
func (s *Message) SetJsonBody(v string) *Message {
	s.JsonBody = &v
	return s
}

// SetMediaUrl sets the MediaUrl field's value.
func (s *Message) SetMediaUrl(v string) *Message {
	s.MediaUrl = &v
	return s
}

// SetRawContent sets the RawContent field's value.
func (s *Message) SetRawContent(v string) *Message {
	s.RawContent = &v
	return s
}

// SetSilentPush sets the SilentPush field's value.
func (s *Message) SetSilentPush(v bool) *Message {
	s.SilentPush = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *Message) SetTitle(v string) *Message {
	s.Title = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Message) SetUrl(v string) *Message {
	s.Url = &v
	return s
}

// Simple message object.
type MessageBody struct {
	_ struct{} `type:"structure"`

	// The error message returned from the API.
	Message *string `type:"string"`

	// The unique message body ID.
	RequestID *string `type:"string"`
}

// String returns the string representation
func (s MessageBody) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageBody) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *MessageBody) SetMessage(v string) *MessageBody {
	s.Message = &v
	return s
}

// SetRequestID sets the RequestID field's value.
func (s *MessageBody) SetRequestID(v string) *MessageBody {
	s.RequestID = &v
	return s
}

// Message configuration for a campaign.
type MessageConfiguration struct {
	_ struct{} `type:"structure"`

	// The message that the campaign delivers to ADM channels. Overrides the default
	// message.
	ADMMessage *Message `type:"structure"`

	// The message that the campaign delivers to APNS channels. Overrides the default
	// message.
	APNSMessage *Message `type:"structure"`

	// The message that the campaign delivers to Baidu channels. Overrides the default
	// message.
	BaiduMessage *Message `type:"structure"`

	// The default message for all channels.
	DefaultMessage *Message `type:"structure"`

	// The email message configuration.
	EmailMessage *CampaignEmailMessage `type:"structure"`

	// The message that the campaign delivers to GCM channels. Overrides the default
	// message.
	GCMMessage *Message `type:"structure"`

	// The SMS message configuration.
	SMSMessage *CampaignSmsMessage `type:"structure"`
}

// String returns the string representation
func (s MessageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageConfiguration) GoString() string {
	return s.String()
}

// SetADMMessage sets the ADMMessage field's value.
func (s *MessageConfiguration) SetADMMessage(v *Message) *MessageConfiguration {
	s.ADMMessage = v
	return s
}

// SetAPNSMessage sets the APNSMessage field's value.
func (s *MessageConfiguration) SetAPNSMessage(v *Message) *MessageConfiguration {
	s.APNSMessage = v
	return s
}

// SetBaiduMessage sets the BaiduMessage field's value.
func (s *MessageConfiguration) SetBaiduMessage(v *Message) *MessageConfiguration {
	s.BaiduMessage = v
	return s
}

// SetDefaultMessage sets the DefaultMessage field's value.
func (s *MessageConfiguration) SetDefaultMessage(v *Message) *MessageConfiguration {
	s.DefaultMessage = v
	return s
}

// SetEmailMessage sets the EmailMessage field's value.
func (s *MessageConfiguration) SetEmailMessage(v *CampaignEmailMessage) *MessageConfiguration {
	s.EmailMessage = v
	return s
}

// SetGCMMessage sets the GCMMessage field's value.
func (s *MessageConfiguration) SetGCMMessage(v *Message) *MessageConfiguration {
	s.GCMMessage = v
	return s
}

// SetSMSMessage sets the SMSMessage field's value.
func (s *MessageConfiguration) SetSMSMessage(v *CampaignSmsMessage) *MessageConfiguration {
	s.SMSMessage = v
	return s
}

// Send message request.
type MessageRequest struct {
	_ struct{} `type:"structure"`

	// A map of destination addresses, with the address as the key(Email address,
	// phone number or push token) and the Address Configuration as the value.
	Addresses map[string]*AddressConfiguration `type:"map"`

	// A map of custom attributes to attributes to be attached to the message. This
	// payload is added to the push notification's 'data.pinpoint' object or added
	// to the email/sms delivery receipt event attributes.
	Context map[string]*string `type:"map"`

	// A map of destination addresses, with the address as the key(Email address,
	// phone number or push token) and the Address Configuration as the value.
	Endpoints map[string]*EndpointSendConfiguration `type:"map"`

	// Message configuration.
	MessageConfiguration *DirectMessageConfiguration `type:"structure"`
}

// String returns the string representation
func (s MessageRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageRequest) GoString() string {
	return s.String()
}

// SetAddresses sets the Addresses field's value.
func (s *MessageRequest) SetAddresses(v map[string]*AddressConfiguration) *MessageRequest {
	s.Addresses = v
	return s
}

// SetContext sets the Context field's value.
func (s *MessageRequest) SetContext(v map[string]*string) *MessageRequest {
	s.Context = v
	return s
}

// SetEndpoints sets the Endpoints field's value.
func (s *MessageRequest) SetEndpoints(v map[string]*EndpointSendConfiguration) *MessageRequest {
	s.Endpoints = v
	return s
}

// SetMessageConfiguration sets the MessageConfiguration field's value.
func (s *MessageRequest) SetMessageConfiguration(v *DirectMessageConfiguration) *MessageRequest {
	s.MessageConfiguration = v
	return s
}

// Send message response.
type MessageResponse struct {
	_ struct{} `type:"structure"`

	// Application id of the message.
	ApplicationId *string `type:"string"`

	// A map containing a multi part response for each address, with the endpointId
	// as the key and the result as the value.
	EndpointResult map[string]*EndpointMessageResult `type:"map"`

	// Original request Id for which this message was delivered.
	RequestId *string `type:"string"`

	// A map containing a multi part response for each address, with the address
	// as the key(Email address, phone number or push token) and the result as the
	// value.
	Result map[string]*MessageResult `type:"map"`
}

// String returns the string representation
func (s MessageResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *MessageResponse) SetApplicationId(v string) *MessageResponse {
	s.ApplicationId = &v
	return s
}

// SetEndpointResult sets the EndpointResult field's value.
func (s *MessageResponse) SetEndpointResult(v map[string]*EndpointMessageResult) *MessageResponse {
	s.EndpointResult = v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *MessageResponse) SetRequestId(v string) *MessageResponse {
	s.RequestId = &v
	return s
}

// SetResult sets the Result field's value.
func (s *MessageResponse) SetResult(v map[string]*MessageResult) *MessageResponse {
	s.Result = v
	return s
}

// The result from sending a message to an address.
type MessageResult struct {
	_ struct{} `type:"structure"`

	// Delivery status of message.
	DeliveryStatus *string `type:"string" enum:"DeliveryStatus"`

	// Downstream service status code.
	StatusCode *int64 `type:"integer"`

	// Status message for message delivery.
	StatusMessage *string `type:"string"`

	// If token was updated as part of delivery. (This is GCM Specific)
	UpdatedToken *string `type:"string"`
}

// String returns the string representation
func (s MessageResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageResult) GoString() string {
	return s.String()
}

// SetDeliveryStatus sets the DeliveryStatus field's value.
func (s *MessageResult) SetDeliveryStatus(v string) *MessageResult {
	s.DeliveryStatus = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *MessageResult) SetStatusCode(v int64) *MessageResult {
	s.StatusCode = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *MessageResult) SetStatusMessage(v string) *MessageResult {
	s.StatusMessage = &v
	return s
}

// SetUpdatedToken sets the UpdatedToken field's value.
func (s *MessageResult) SetUpdatedToken(v string) *MessageResult {
	s.UpdatedToken = &v
	return s
}

type PutEventStreamInput struct {
	_ struct{} `type:"structure" payload:"WriteEventStream"`

	// Application Id.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Write event stream wrapper.
	//
	// WriteEventStream is a required field
	WriteEventStream *WriteEventStream `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutEventStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEventStreamInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.WriteEventStream == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteEventStream"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *PutEventStreamInput) SetApplicationId(v string) *PutEventStreamInput {
	s.ApplicationId = &v
	return s
}

// SetWriteEventStream sets the WriteEventStream field's value.
func (s *PutEventStreamInput) SetWriteEventStream(v *WriteEventStream) *PutEventStreamInput {
	s.WriteEventStream = v
	return s
}

type PutEventStreamOutput struct {
	_ struct{} `type:"structure" payload:"EventStream"`

	// Model for an event publishing subscription export.
	//
	// EventStream is a required field
	EventStream *EventStream `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutEventStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventStreamOutput) GoString() string {
	return s.String()
}

// SetEventStream sets the EventStream field's value.
func (s *PutEventStreamOutput) SetEventStream(v *EventStream) *PutEventStreamOutput {
	s.EventStream = v
	return s
}

// Quiet Time
type QuietTime struct {
	_ struct{} `type:"structure"`

	// The default end time for quiet time in ISO 8601 format.
	End *string `type:"string"`

	// The default start time for quiet time in ISO 8601 format.
	Start *string `type:"string"`
}

// String returns the string representation
func (s QuietTime) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QuietTime) GoString() string {
	return s.String()
}

// SetEnd sets the End field's value.
func (s *QuietTime) SetEnd(v string) *QuietTime {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *QuietTime) SetStart(v string) *QuietTime {
	s.Start = &v
	return s
}

// Define how a segment based on recency of use.
type RecencyDimension struct {
	_ struct{} `type:"structure"`

	// The length of time during which users have been active or inactive with your
	// app.Valid values: HR_24, DAY_7, DAY_14, DAY_30
	Duration *string `type:"string" enum:"Duration"`

	// The recency dimension type:ACTIVE - Users who have used your app within the
	// specified duration are included in the segment.INACTIVE - Users who have
	// not used your app within the specified duration are included in the segment.
	RecencyType *string `type:"string" enum:"RecencyType"`
}

// String returns the string representation
func (s RecencyDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecencyDimension) GoString() string {
	return s.String()
}

// SetDuration sets the Duration field's value.
func (s *RecencyDimension) SetDuration(v string) *RecencyDimension {
	s.Duration = &v
	return s
}

// SetRecencyType sets the RecencyType field's value.
func (s *RecencyDimension) SetRecencyType(v string) *RecencyDimension {
	s.RecencyType = &v
	return s
}

// SMS Channel Request
type SMSChannelRequest struct {
	_ struct{} `type:"structure"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// Sender identifier of your messages.
	SenderId *string `type:"string"`

	// ShortCode registered with phone provider.
	ShortCode *string `type:"string"`
}

// String returns the string representation
func (s SMSChannelRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SMSChannelRequest) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *SMSChannelRequest) SetEnabled(v bool) *SMSChannelRequest {
	s.Enabled = &v
	return s
}

// SetSenderId sets the SenderId field's value.
func (s *SMSChannelRequest) SetSenderId(v string) *SMSChannelRequest {
	s.SenderId = &v
	return s
}

// SetShortCode sets the ShortCode field's value.
func (s *SMSChannelRequest) SetShortCode(v string) *SMSChannelRequest {
	s.ShortCode = &v
	return s
}

// SMS Channel Response.
type SMSChannelResponse struct {
	_ struct{} `type:"structure"`

	// The unique ID of the application to which the SMS channel belongs.
	ApplicationId *string `type:"string"`

	// The date that the settings were last updated in ISO 8601 format.
	CreationDate *string `type:"string"`

	// If the channel is enabled for sending messages.
	Enabled *bool `type:"boolean"`

	// If the channel is registered with a credential for authentication.
	HasCredential *bool `type:"boolean"`

	// Channel ID. Not used, only for backwards compatibility.
	Id *string `type:"string"`

	// Is this channel archived
	IsArchived *bool `type:"boolean"`

	// Who last updated this entry
	LastModifiedBy *string `type:"string"`

	// Last date this was updated
	LastModifiedDate *string `type:"string"`

	// Platform type. Will be "SMS"
	Platform *string `type:"string"`

	// Sender identifier of your messages.
	SenderId *string `type:"string"`

	// The short code registered with the phone provider.
	ShortCode *string `type:"string"`

	// Version of channel
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s SMSChannelResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SMSChannelResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *SMSChannelResponse) SetApplicationId(v string) *SMSChannelResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *SMSChannelResponse) SetCreationDate(v string) *SMSChannelResponse {
	s.CreationDate = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *SMSChannelResponse) SetEnabled(v bool) *SMSChannelResponse {
	s.Enabled = &v
	return s
}

// SetHasCredential sets the HasCredential field's value.
func (s *SMSChannelResponse) SetHasCredential(v bool) *SMSChannelResponse {
	s.HasCredential = &v
	return s
}

// SetId sets the Id field's value.
func (s *SMSChannelResponse) SetId(v string) *SMSChannelResponse {
	s.Id = &v
	return s
}

// SetIsArchived sets the IsArchived field's value.
func (s *SMSChannelResponse) SetIsArchived(v bool) *SMSChannelResponse {
	s.IsArchived = &v
	return s
}

// SetLastModifiedBy sets the LastModifiedBy field's value.
func (s *SMSChannelResponse) SetLastModifiedBy(v string) *SMSChannelResponse {
	s.LastModifiedBy = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *SMSChannelResponse) SetLastModifiedDate(v string) *SMSChannelResponse {
	s.LastModifiedDate = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *SMSChannelResponse) SetPlatform(v string) *SMSChannelResponse {
	s.Platform = &v
	return s
}

// SetSenderId sets the SenderId field's value.
func (s *SMSChannelResponse) SetSenderId(v string) *SMSChannelResponse {
	s.SenderId = &v
	return s
}

// SetShortCode sets the ShortCode field's value.
func (s *SMSChannelResponse) SetShortCode(v string) *SMSChannelResponse {
	s.ShortCode = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *SMSChannelResponse) SetVersion(v int64) *SMSChannelResponse {
	s.Version = &v
	return s
}

// SMS Message.
type SMSMessage struct {
	_ struct{} `type:"structure"`

	// The message body of the notification, the email body or the text message.
	Body *string `type:"string"`

	// Is this a transaction priority message or lower priority.
	MessageType *string `type:"string" enum:"MessageType"`

	// The phone number that the SMS message originates from. Specify one of the
	// dedicated long codes or short codes that you requested from AWS Support and
	// that is assigned to your account. If this attribute is not specified, Amazon
	// Pinpoint randomly assigns a long code.
	OriginationNumber *string `type:"string"`

	// The sender ID that is shown as the message sender on the recipient's device.
	// Support for sender IDs varies by country or region.
	SenderId *string `type:"string"`

	Substitutions map[string][]*string `type:"map"`
}

// String returns the string representation
func (s SMSMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SMSMessage) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *SMSMessage) SetBody(v string) *SMSMessage {
	s.Body = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *SMSMessage) SetMessageType(v string) *SMSMessage {
	s.MessageType = &v
	return s
}

// SetOriginationNumber sets the OriginationNumber field's value.
func (s *SMSMessage) SetOriginationNumber(v string) *SMSMessage {
	s.OriginationNumber = &v
	return s
}

// SetSenderId sets the SenderId field's value.
func (s *SMSMessage) SetSenderId(v string) *SMSMessage {
	s.SenderId = &v
	return s
}

// SetSubstitutions sets the Substitutions field's value.
func (s *SMSMessage) SetSubstitutions(v map[string][]*string) *SMSMessage {
	s.Substitutions = v
	return s
}

// Shcedule that defines when a campaign is run.
type Schedule struct {
	_ struct{} `type:"structure"`

	// The scheduled time that the campaign ends in ISO 8601 format.
	EndTime *string `type:"string"`

	// How often the campaign delivers messages.Valid values: ONCE, HOURLY, DAILY,
	// WEEKLY, MONTHLY
	Frequency *string `type:"string" enum:"Frequency"`

	// Indicates whether the campaign schedule takes effect according to each user's
	// local time.
	IsLocalTime *bool `type:"boolean"`

	// The time during which the campaign sends no messages.
	QuietTime *QuietTime `type:"structure"`

	// The scheduled time that the campaign begins in ISO 8601 format.
	StartTime *string `type:"string"`

	// The starting UTC offset for the schedule if the value for isLocalTime is
	// trueValid values: UTCUTC+01UTC+02UTC+03UTC+03:30UTC+04UTC+04:30UTC+05UTC+05:30UTC+05:45UTC+06UTC+06:30UTC+07UTC+08UTC+09UTC+09:30UTC+10UTC+10:30UTC+11UTC+12UTC+13UTC-02UTC-03UTC-04UTC-05UTC-06UTC-07UTC-08UTC-09UTC-10UTC-11
	Timezone *string `type:"string"`
}

// String returns the string representation
func (s Schedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Schedule) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *Schedule) SetEndTime(v string) *Schedule {
	s.EndTime = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *Schedule) SetFrequency(v string) *Schedule {
	s.Frequency = &v
	return s
}

// SetIsLocalTime sets the IsLocalTime field's value.
func (s *Schedule) SetIsLocalTime(v bool) *Schedule {
	s.IsLocalTime = &v
	return s
}

// SetQuietTime sets the QuietTime field's value.
func (s *Schedule) SetQuietTime(v *QuietTime) *Schedule {
	s.QuietTime = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Schedule) SetStartTime(v string) *Schedule {
	s.StartTime = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *Schedule) SetTimezone(v string) *Schedule {
	s.Timezone = &v
	return s
}

// Segment behavior dimensions
type SegmentBehaviors struct {
	_ struct{} `type:"structure"`

	// The recency of use.
	Recency *RecencyDimension `type:"structure"`
}

// String returns the string representation
func (s SegmentBehaviors) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentBehaviors) GoString() string {
	return s.String()
}

// SetRecency sets the Recency field's value.
func (s *SegmentBehaviors) SetRecency(v *RecencyDimension) *SegmentBehaviors {
	s.Recency = v
	return s
}

// Segment demographic dimensions
type SegmentDemographics struct {
	_ struct{} `type:"structure"`

	// The app version criteria for the segment.
	AppVersion *SetDimension `type:"structure"`

	// The channel criteria for the segment.
	Channel *SetDimension `type:"structure"`

	// The device type criteria for the segment.
	DeviceType *SetDimension `type:"structure"`

	// The device make criteria for the segment.
	Make *SetDimension `type:"structure"`

	// The device model criteria for the segment.
	Model *SetDimension `type:"structure"`

	// The device platform criteria for the segment.
	Platform *SetDimension `type:"structure"`
}

// String returns the string representation
func (s SegmentDemographics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentDemographics) GoString() string {
	return s.String()
}

// SetAppVersion sets the AppVersion field's value.
func (s *SegmentDemographics) SetAppVersion(v *SetDimension) *SegmentDemographics {
	s.AppVersion = v
	return s
}

// SetChannel sets the Channel field's value.
func (s *SegmentDemographics) SetChannel(v *SetDimension) *SegmentDemographics {
	s.Channel = v
	return s
}

// SetDeviceType sets the DeviceType field's value.
func (s *SegmentDemographics) SetDeviceType(v *SetDimension) *SegmentDemographics {
	s.DeviceType = v
	return s
}

// SetMake sets the Make field's value.
func (s *SegmentDemographics) SetMake(v *SetDimension) *SegmentDemographics {
	s.Make = v
	return s
}

// SetModel sets the Model field's value.
func (s *SegmentDemographics) SetModel(v *SetDimension) *SegmentDemographics {
	s.Model = v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *SegmentDemographics) SetPlatform(v *SetDimension) *SegmentDemographics {
	s.Platform = v
	return s
}

// Segment dimensions
type SegmentDimensions struct {
	_ struct{} `type:"structure"`

	// Custom segment attributes.
	Attributes map[string]*AttributeDimension `type:"map"`

	// The segment behaviors attributes.
	Behavior *SegmentBehaviors `type:"structure"`

	// The segment demographics attributes.
	Demographic *SegmentDemographics `type:"structure"`

	// The segment location attributes.
	Location *SegmentLocation `type:"structure"`

	// Custom segment user attributes.
	UserAttributes map[string]*AttributeDimension `type:"map"`
}

// String returns the string representation
func (s SegmentDimensions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentDimensions) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *SegmentDimensions) SetAttributes(v map[string]*AttributeDimension) *SegmentDimensions {
	s.Attributes = v
	return s
}

// SetBehavior sets the Behavior field's value.
func (s *SegmentDimensions) SetBehavior(v *SegmentBehaviors) *SegmentDimensions {
	s.Behavior = v
	return s
}

// SetDemographic sets the Demographic field's value.
func (s *SegmentDimensions) SetDemographic(v *SegmentDemographics) *SegmentDimensions {
	s.Demographic = v
	return s
}

// SetLocation sets the Location field's value.
func (s *SegmentDimensions) SetLocation(v *SegmentLocation) *SegmentDimensions {
	s.Location = v
	return s
}

// SetUserAttributes sets the UserAttributes field's value.
func (s *SegmentDimensions) SetUserAttributes(v map[string]*AttributeDimension) *SegmentDimensions {
	s.UserAttributes = v
	return s
}

// Segment import definition.
type SegmentImportResource struct {
	_ struct{} `type:"structure"`

	// Channel type counts
	ChannelCounts map[string]*int64 `type:"map"`

	// DEPRECATED. Your AWS account ID, which you assigned to the ExternalID key
	// in an IAM trust policy. Used by Amazon Pinpoint to assume an IAM role. This
	// requirement is removed, and external IDs are not recommended for IAM roles
	// assumed by Amazon Pinpoint.
	ExternalId *string `type:"string"`

	// The format of the endpoint files that were imported to create this segment.Valid
	// values: CSV, JSON
	Format *string `type:"string" enum:"Format"`

	// The Amazon Resource Name (ARN) of an IAM role that grants Amazon Pinpoint
	// access to the endpoints in Amazon S3.
	RoleArn *string `type:"string"`

	// A URL that points to the Amazon S3 location from which the endpoints for
	// this segment were imported.
	S3Url *string `type:"string"`

	// The number of endpoints that were successfully imported to create this segment.
	Size *int64 `type:"integer"`
}

// String returns the string representation
func (s SegmentImportResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentImportResource) GoString() string {
	return s.String()
}

// SetChannelCounts sets the ChannelCounts field's value.
func (s *SegmentImportResource) SetChannelCounts(v map[string]*int64) *SegmentImportResource {
	s.ChannelCounts = v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *SegmentImportResource) SetExternalId(v string) *SegmentImportResource {
	s.ExternalId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *SegmentImportResource) SetFormat(v string) *SegmentImportResource {
	s.Format = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *SegmentImportResource) SetRoleArn(v string) *SegmentImportResource {
	s.RoleArn = &v
	return s
}

// SetS3Url sets the S3Url field's value.
func (s *SegmentImportResource) SetS3Url(v string) *SegmentImportResource {
	s.S3Url = &v
	return s
}

// SetSize sets the Size field's value.
func (s *SegmentImportResource) SetSize(v int64) *SegmentImportResource {
	s.Size = &v
	return s
}

// Segment location dimensions
type SegmentLocation struct {
	_ struct{} `type:"structure"`

	// The country filter according to ISO 3166-1 Alpha-2 codes.
	Country *SetDimension `type:"structure"`
}

// String returns the string representation
func (s SegmentLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentLocation) GoString() string {
	return s.String()
}

// SetCountry sets the Country field's value.
func (s *SegmentLocation) SetCountry(v *SetDimension) *SegmentLocation {
	s.Country = v
	return s
}

// Segment definition.
type SegmentResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the application to which the segment applies.
	ApplicationId *string `type:"string"`

	// The date the segment was created in ISO 8601 format.
	CreationDate *string `type:"string"`

	// The segment dimensions attributes.
	Dimensions *SegmentDimensions `type:"structure"`

	// The unique segment ID.
	Id *string `type:"string"`

	// The import job settings.
	ImportDefinition *SegmentImportResource `type:"structure"`

	// The date the segment was last updated in ISO 8601 format.
	LastModifiedDate *string `type:"string"`

	// The name of segment
	Name *string `type:"string"`

	// The segment type:DIMENSIONAL - A dynamic segment built from selection criteria
	// based on endpoint data reported by your app. You create this type of segment
	// by using the segment builder in the Amazon Pinpoint console or by making
	// a POST request to the segments resource.IMPORT - A static segment built from
	// an imported set of endpoint definitions. You create this type of segment
	// by importing a segment in the Amazon Pinpoint console or by making a POST
	// request to the jobs/import resource.
	SegmentType *string `type:"string" enum:"SegmentType"`

	// The segment version number.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s SegmentResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *SegmentResponse) SetApplicationId(v string) *SegmentResponse {
	s.ApplicationId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *SegmentResponse) SetCreationDate(v string) *SegmentResponse {
	s.CreationDate = &v
	return s
}

// SetDimensions sets the Dimensions field's value.
func (s *SegmentResponse) SetDimensions(v *SegmentDimensions) *SegmentResponse {
	s.Dimensions = v
	return s
}

// SetId sets the Id field's value.
func (s *SegmentResponse) SetId(v string) *SegmentResponse {
	s.Id = &v
	return s
}

// SetImportDefinition sets the ImportDefinition field's value.
func (s *SegmentResponse) SetImportDefinition(v *SegmentImportResource) *SegmentResponse {
	s.ImportDefinition = v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *SegmentResponse) SetLastModifiedDate(v string) *SegmentResponse {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *SegmentResponse) SetName(v string) *SegmentResponse {
	s.Name = &v
	return s
}

// SetSegmentType sets the SegmentType field's value.
func (s *SegmentResponse) SetSegmentType(v string) *SegmentResponse {
	s.SegmentType = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *SegmentResponse) SetVersion(v int64) *SegmentResponse {
	s.Version = &v
	return s
}

// Segments in your account.
type SegmentsResponse struct {
	_ struct{} `type:"structure"`

	// The list of segments.
	Item []*SegmentResponse `type:"list"`

	// An identifier used to retrieve the next page of results. The token is null
	// if no additional pages exist.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s SegmentsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SegmentsResponse) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *SegmentsResponse) SetItem(v []*SegmentResponse) *SegmentsResponse {
	s.Item = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SegmentsResponse) SetNextToken(v string) *SegmentsResponse {
	s.NextToken = &v
	return s
}

type SendMessagesInput struct {
	_ struct{} `type:"structure" payload:"MessageRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Send message request.
	//
	// MessageRequest is a required field
	MessageRequest *MessageRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s SendMessagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendMessagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendMessagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendMessagesInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.MessageRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *SendMessagesInput) SetApplicationId(v string) *SendMessagesInput {
	s.ApplicationId = &v
	return s
}

// SetMessageRequest sets the MessageRequest field's value.
func (s *SendMessagesInput) SetMessageRequest(v *MessageRequest) *SendMessagesInput {
	s.MessageRequest = v
	return s
}

type SendMessagesOutput struct {
	_ struct{} `type:"structure" payload:"MessageResponse"`

	// Send message response.
	//
	// MessageResponse is a required field
	MessageResponse *MessageResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s SendMessagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendMessagesOutput) GoString() string {
	return s.String()
}

// SetMessageResponse sets the MessageResponse field's value.
func (s *SendMessagesOutput) SetMessageResponse(v *MessageResponse) *SendMessagesOutput {
	s.MessageResponse = v
	return s
}

// Send message request.
type SendUsersMessageRequest struct {
	_ struct{} `type:"structure"`

	// A map of custom attributes to attributes to be attached to the message. This
	// payload is added to the push notification's 'data.pinpoint' object or added
	// to the email/sms delivery receipt event attributes.
	Context map[string]*string `type:"map"`

	// Message configuration.
	MessageConfiguration *DirectMessageConfiguration `type:"structure"`

	// A map of destination endpoints, with the EndpointId as the key Endpoint Message
	// Configuration as the value.
	Users map[string]*EndpointSendConfiguration `type:"map"`
}

// String returns the string representation
func (s SendUsersMessageRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendUsersMessageRequest) GoString() string {
	return s.String()
}

// SetContext sets the Context field's value.
func (s *SendUsersMessageRequest) SetContext(v map[string]*string) *SendUsersMessageRequest {
	s.Context = v
	return s
}

// SetMessageConfiguration sets the MessageConfiguration field's value.
func (s *SendUsersMessageRequest) SetMessageConfiguration(v *DirectMessageConfiguration) *SendUsersMessageRequest {
	s.MessageConfiguration = v
	return s
}

// SetUsers sets the Users field's value.
func (s *SendUsersMessageRequest) SetUsers(v map[string]*EndpointSendConfiguration) *SendUsersMessageRequest {
	s.Users = v
	return s
}

// User send message response.
type SendUsersMessageResponse struct {
	_ struct{} `type:"structure"`

	// Application id of the message.
	ApplicationId *string `type:"string"`

	// Original request Id for which this message was delivered.
	RequestId *string `type:"string"`

	// A map containing of UserId to Map of EndpointId to Endpoint Message Result.
	Result map[string]map[string]*EndpointMessageResult `type:"map"`
}

// String returns the string representation
func (s SendUsersMessageResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendUsersMessageResponse) GoString() string {
	return s.String()
}

// SetApplicationId sets the ApplicationId field's value.
func (s *SendUsersMessageResponse) SetApplicationId(v string) *SendUsersMessageResponse {
	s.ApplicationId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *SendUsersMessageResponse) SetRequestId(v string) *SendUsersMessageResponse {
	s.RequestId = &v
	return s
}

// SetResult sets the Result field's value.
func (s *SendUsersMessageResponse) SetResult(v map[string]map[string]*EndpointMessageResult) *SendUsersMessageResponse {
	s.Result = v
	return s
}

type SendUsersMessagesInput struct {
	_ struct{} `type:"structure" payload:"SendUsersMessageRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Send message request.
	//
	// SendUsersMessageRequest is a required field
	SendUsersMessageRequest *SendUsersMessageRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s SendUsersMessagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendUsersMessagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendUsersMessagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendUsersMessagesInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.SendUsersMessageRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("SendUsersMessageRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *SendUsersMessagesInput) SetApplicationId(v string) *SendUsersMessagesInput {
	s.ApplicationId = &v
	return s
}

// SetSendUsersMessageRequest sets the SendUsersMessageRequest field's value.
func (s *SendUsersMessagesInput) SetSendUsersMessageRequest(v *SendUsersMessageRequest) *SendUsersMessagesInput {
	s.SendUsersMessageRequest = v
	return s
}

type SendUsersMessagesOutput struct {
	_ struct{} `type:"structure" payload:"SendUsersMessageResponse"`

	// User send message response.
	//
	// SendUsersMessageResponse is a required field
	SendUsersMessageResponse *SendUsersMessageResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s SendUsersMessagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendUsersMessagesOutput) GoString() string {
	return s.String()
}

// SetSendUsersMessageResponse sets the SendUsersMessageResponse field's value.
func (s *SendUsersMessagesOutput) SetSendUsersMessageResponse(v *SendUsersMessageResponse) *SendUsersMessagesOutput {
	s.SendUsersMessageResponse = v
	return s
}

// Dimension specification of a segment.
type SetDimension struct {
	_ struct{} `type:"structure"`

	// The type of dimension:INCLUSIVE - Endpoints that match the criteria are included
	// in the segment.EXCLUSIVE - Endpoints that match the criteria are excluded
	// from the segment.
	DimensionType *string `type:"string" enum:"DimensionType"`

	Values []*string `type:"list"`
}

// String returns the string representation
func (s SetDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDimension) GoString() string {
	return s.String()
}

// SetDimensionType sets the DimensionType field's value.
func (s *SetDimension) SetDimensionType(v string) *SetDimension {
	s.DimensionType = &v
	return s
}

// SetValues sets the Values field's value.
func (s *SetDimension) SetValues(v []*string) *SetDimension {
	s.Values = v
	return s
}

// Treatment resource
type TreatmentResource struct {
	_ struct{} `type:"structure"`

	// The unique treatment ID.
	Id *string `type:"string"`

	// The message configuration settings.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The campaign schedule.
	Schedule *Schedule `type:"structure"`

	// The allocated percentage of users for this treatment.
	SizePercent *int64 `type:"integer"`

	// The treatment status.
	State *CampaignState `type:"structure"`

	// A custom description for the treatment.
	TreatmentDescription *string `type:"string"`

	// The custom name of a variation of the campaign used for A/B testing.
	TreatmentName *string `type:"string"`
}

// String returns the string representation
func (s TreatmentResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TreatmentResource) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *TreatmentResource) SetId(v string) *TreatmentResource {
	s.Id = &v
	return s
}

// SetMessageConfiguration sets the MessageConfiguration field's value.
func (s *TreatmentResource) SetMessageConfiguration(v *MessageConfiguration) *TreatmentResource {
	s.MessageConfiguration = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *TreatmentResource) SetSchedule(v *Schedule) *TreatmentResource {
	s.Schedule = v
	return s
}

// SetSizePercent sets the SizePercent field's value.
func (s *TreatmentResource) SetSizePercent(v int64) *TreatmentResource {
	s.SizePercent = &v
	return s
}

// SetState sets the State field's value.
func (s *TreatmentResource) SetState(v *CampaignState) *TreatmentResource {
	s.State = v
	return s
}

// SetTreatmentDescription sets the TreatmentDescription field's value.
func (s *TreatmentResource) SetTreatmentDescription(v string) *TreatmentResource {
	s.TreatmentDescription = &v
	return s
}

// SetTreatmentName sets the TreatmentName field's value.
func (s *TreatmentResource) SetTreatmentName(v string) *TreatmentResource {
	s.TreatmentName = &v
	return s
}

type UpdateAdmChannelInput struct {
	_ struct{} `type:"structure" payload:"ADMChannelRequest"`

	// Amazon Device Messaging channel definition.
	//
	// ADMChannelRequest is a required field
	ADMChannelRequest *ADMChannelRequest `type:"structure" required:"true"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAdmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAdmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAdmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAdmChannelInput"}
	if s.ADMChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("ADMChannelRequest"))
	}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetADMChannelRequest sets the ADMChannelRequest field's value.
func (s *UpdateAdmChannelInput) SetADMChannelRequest(v *ADMChannelRequest) *UpdateAdmChannelInput {
	s.ADMChannelRequest = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateAdmChannelInput) SetApplicationId(v string) *UpdateAdmChannelInput {
	s.ApplicationId = &v
	return s
}

type UpdateAdmChannelOutput struct {
	_ struct{} `type:"structure" payload:"ADMChannelResponse"`

	// Amazon Device Messaging channel definition.
	//
	// ADMChannelResponse is a required field
	ADMChannelResponse *ADMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateAdmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAdmChannelOutput) GoString() string {
	return s.String()
}

// SetADMChannelResponse sets the ADMChannelResponse field's value.
func (s *UpdateAdmChannelOutput) SetADMChannelResponse(v *ADMChannelResponse) *UpdateAdmChannelOutput {
	s.ADMChannelResponse = v
	return s
}

type UpdateApnsChannelInput struct {
	_ struct{} `type:"structure" payload:"APNSChannelRequest"`

	// Apple Push Notification Service channel definition.
	//
	// APNSChannelRequest is a required field
	APNSChannelRequest *APNSChannelRequest `type:"structure" required:"true"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateApnsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApnsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApnsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApnsChannelInput"}
	if s.APNSChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("APNSChannelRequest"))
	}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAPNSChannelRequest sets the APNSChannelRequest field's value.
func (s *UpdateApnsChannelInput) SetAPNSChannelRequest(v *APNSChannelRequest) *UpdateApnsChannelInput {
	s.APNSChannelRequest = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApnsChannelInput) SetApplicationId(v string) *UpdateApnsChannelInput {
	s.ApplicationId = &v
	return s
}

type UpdateApnsChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSChannelResponse"`

	// Apple Distribution Push Notification Service channel definition.
	//
	// APNSChannelResponse is a required field
	APNSChannelResponse *APNSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApnsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApnsChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSChannelResponse sets the APNSChannelResponse field's value.
func (s *UpdateApnsChannelOutput) SetAPNSChannelResponse(v *APNSChannelResponse) *UpdateApnsChannelOutput {
	s.APNSChannelResponse = v
	return s
}

type UpdateApnsSandboxChannelInput struct {
	_ struct{} `type:"structure" payload:"APNSSandboxChannelRequest"`

	// Apple Development Push Notification Service channel definition.
	//
	// APNSSandboxChannelRequest is a required field
	APNSSandboxChannelRequest *APNSSandboxChannelRequest `type:"structure" required:"true"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateApnsSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApnsSandboxChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApnsSandboxChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApnsSandboxChannelInput"}
	if s.APNSSandboxChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("APNSSandboxChannelRequest"))
	}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAPNSSandboxChannelRequest sets the APNSSandboxChannelRequest field's value.
func (s *UpdateApnsSandboxChannelInput) SetAPNSSandboxChannelRequest(v *APNSSandboxChannelRequest) *UpdateApnsSandboxChannelInput {
	s.APNSSandboxChannelRequest = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApnsSandboxChannelInput) SetApplicationId(v string) *UpdateApnsSandboxChannelInput {
	s.ApplicationId = &v
	return s
}

type UpdateApnsSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSSandboxChannelResponse"`

	// Apple Development Push Notification Service channel definition.
	//
	// APNSSandboxChannelResponse is a required field
	APNSSandboxChannelResponse *APNSSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApnsSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApnsSandboxChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSSandboxChannelResponse sets the APNSSandboxChannelResponse field's value.
func (s *UpdateApnsSandboxChannelOutput) SetAPNSSandboxChannelResponse(v *APNSSandboxChannelResponse) *UpdateApnsSandboxChannelOutput {
	s.APNSSandboxChannelResponse = v
	return s
}

type UpdateApnsVoipChannelInput struct {
	_ struct{} `type:"structure" payload:"APNSVoipChannelRequest"`

	// Apple VoIP Push Notification Service channel definition.
	//
	// APNSVoipChannelRequest is a required field
	APNSVoipChannelRequest *APNSVoipChannelRequest `type:"structure" required:"true"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateApnsVoipChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApnsVoipChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApnsVoipChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApnsVoipChannelInput"}
	if s.APNSVoipChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("APNSVoipChannelRequest"))
	}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAPNSVoipChannelRequest sets the APNSVoipChannelRequest field's value.
func (s *UpdateApnsVoipChannelInput) SetAPNSVoipChannelRequest(v *APNSVoipChannelRequest) *UpdateApnsVoipChannelInput {
	s.APNSVoipChannelRequest = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApnsVoipChannelInput) SetApplicationId(v string) *UpdateApnsVoipChannelInput {
	s.ApplicationId = &v
	return s
}

type UpdateApnsVoipChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSVoipChannelResponse"`

	// Apple VoIP Push Notification Service channel definition.
	//
	// APNSVoipChannelResponse is a required field
	APNSVoipChannelResponse *APNSVoipChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApnsVoipChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApnsVoipChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSVoipChannelResponse sets the APNSVoipChannelResponse field's value.
func (s *UpdateApnsVoipChannelOutput) SetAPNSVoipChannelResponse(v *APNSVoipChannelResponse) *UpdateApnsVoipChannelOutput {
	s.APNSVoipChannelResponse = v
	return s
}

type UpdateApnsVoipSandboxChannelInput struct {
	_ struct{} `type:"structure" payload:"APNSVoipSandboxChannelRequest"`

	// Apple VoIP Developer Push Notification Service channel definition.
	//
	// APNSVoipSandboxChannelRequest is a required field
	APNSVoipSandboxChannelRequest *APNSVoipSandboxChannelRequest `type:"structure" required:"true"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateApnsVoipSandboxChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApnsVoipSandboxChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApnsVoipSandboxChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApnsVoipSandboxChannelInput"}
	if s.APNSVoipSandboxChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("APNSVoipSandboxChannelRequest"))
	}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAPNSVoipSandboxChannelRequest sets the APNSVoipSandboxChannelRequest field's value.
func (s *UpdateApnsVoipSandboxChannelInput) SetAPNSVoipSandboxChannelRequest(v *APNSVoipSandboxChannelRequest) *UpdateApnsVoipSandboxChannelInput {
	s.APNSVoipSandboxChannelRequest = v
	return s
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApnsVoipSandboxChannelInput) SetApplicationId(v string) *UpdateApnsVoipSandboxChannelInput {
	s.ApplicationId = &v
	return s
}

type UpdateApnsVoipSandboxChannelOutput struct {
	_ struct{} `type:"structure" payload:"APNSVoipSandboxChannelResponse"`

	// Apple VoIP Developer Push Notification Service channel definition.
	//
	// APNSVoipSandboxChannelResponse is a required field
	APNSVoipSandboxChannelResponse *APNSVoipSandboxChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApnsVoipSandboxChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApnsVoipSandboxChannelOutput) GoString() string {
	return s.String()
}

// SetAPNSVoipSandboxChannelResponse sets the APNSVoipSandboxChannelResponse field's value.
func (s *UpdateApnsVoipSandboxChannelOutput) SetAPNSVoipSandboxChannelResponse(v *APNSVoipSandboxChannelResponse) *UpdateApnsVoipSandboxChannelOutput {
	s.APNSVoipSandboxChannelResponse = v
	return s
}

type UpdateApplicationSettingsInput struct {
	_ struct{} `type:"structure" payload:"WriteApplicationSettingsRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Creating application setting request
	//
	// WriteApplicationSettingsRequest is a required field
	WriteApplicationSettingsRequest *WriteApplicationSettingsRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApplicationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationSettingsInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.WriteApplicationSettingsRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteApplicationSettingsRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateApplicationSettingsInput) SetApplicationId(v string) *UpdateApplicationSettingsInput {
	s.ApplicationId = &v
	return s
}

// SetWriteApplicationSettingsRequest sets the WriteApplicationSettingsRequest field's value.
func (s *UpdateApplicationSettingsInput) SetWriteApplicationSettingsRequest(v *WriteApplicationSettingsRequest) *UpdateApplicationSettingsInput {
	s.WriteApplicationSettingsRequest = v
	return s
}

type UpdateApplicationSettingsOutput struct {
	_ struct{} `type:"structure" payload:"ApplicationSettingsResource"`

	// Application settings.
	//
	// ApplicationSettingsResource is a required field
	ApplicationSettingsResource *ApplicationSettingsResource `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApplicationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationSettingsOutput) GoString() string {
	return s.String()
}

// SetApplicationSettingsResource sets the ApplicationSettingsResource field's value.
func (s *UpdateApplicationSettingsOutput) SetApplicationSettingsResource(v *ApplicationSettingsResource) *UpdateApplicationSettingsOutput {
	s.ApplicationSettingsResource = v
	return s
}

type UpdateBaiduChannelInput struct {
	_ struct{} `type:"structure" payload:"BaiduChannelRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Baidu Cloud Push credentials
	//
	// BaiduChannelRequest is a required field
	BaiduChannelRequest *BaiduChannelRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateBaiduChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBaiduChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBaiduChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBaiduChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.BaiduChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("BaiduChannelRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateBaiduChannelInput) SetApplicationId(v string) *UpdateBaiduChannelInput {
	s.ApplicationId = &v
	return s
}

// SetBaiduChannelRequest sets the BaiduChannelRequest field's value.
func (s *UpdateBaiduChannelInput) SetBaiduChannelRequest(v *BaiduChannelRequest) *UpdateBaiduChannelInput {
	s.BaiduChannelRequest = v
	return s
}

type UpdateBaiduChannelOutput struct {
	_ struct{} `type:"structure" payload:"BaiduChannelResponse"`

	// Baidu Cloud Messaging channel definition
	//
	// BaiduChannelResponse is a required field
	BaiduChannelResponse *BaiduChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateBaiduChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBaiduChannelOutput) GoString() string {
	return s.String()
}

// SetBaiduChannelResponse sets the BaiduChannelResponse field's value.
func (s *UpdateBaiduChannelOutput) SetBaiduChannelResponse(v *BaiduChannelResponse) *UpdateBaiduChannelOutput {
	s.BaiduChannelResponse = v
	return s
}

type UpdateCampaignInput struct {
	_ struct{} `type:"structure" payload:"WriteCampaignRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// CampaignId is a required field
	CampaignId *string `location:"uri" locationName:"campaign-id" type:"string" required:"true"`

	// Used to create a campaign.
	//
	// WriteCampaignRequest is a required field
	WriteCampaignRequest *WriteCampaignRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateCampaignInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCampaignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCampaignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCampaignInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.CampaignId == nil {
		invalidParams.Add(request.NewErrParamRequired("CampaignId"))
	}
	if s.WriteCampaignRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteCampaignRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateCampaignInput) SetApplicationId(v string) *UpdateCampaignInput {
	s.ApplicationId = &v
	return s
}

// SetCampaignId sets the CampaignId field's value.
func (s *UpdateCampaignInput) SetCampaignId(v string) *UpdateCampaignInput {
	s.CampaignId = &v
	return s
}

// SetWriteCampaignRequest sets the WriteCampaignRequest field's value.
func (s *UpdateCampaignInput) SetWriteCampaignRequest(v *WriteCampaignRequest) *UpdateCampaignInput {
	s.WriteCampaignRequest = v
	return s
}

type UpdateCampaignOutput struct {
	_ struct{} `type:"structure" payload:"CampaignResponse"`

	// Campaign definition
	//
	// CampaignResponse is a required field
	CampaignResponse *CampaignResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateCampaignOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCampaignOutput) GoString() string {
	return s.String()
}

// SetCampaignResponse sets the CampaignResponse field's value.
func (s *UpdateCampaignOutput) SetCampaignResponse(v *CampaignResponse) *UpdateCampaignOutput {
	s.CampaignResponse = v
	return s
}

type UpdateEmailChannelInput struct {
	_ struct{} `type:"structure" payload:"EmailChannelRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Email Channel Request
	//
	// EmailChannelRequest is a required field
	EmailChannelRequest *EmailChannelRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEmailChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEmailChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEmailChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEmailChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.EmailChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailChannelRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateEmailChannelInput) SetApplicationId(v string) *UpdateEmailChannelInput {
	s.ApplicationId = &v
	return s
}

// SetEmailChannelRequest sets the EmailChannelRequest field's value.
func (s *UpdateEmailChannelInput) SetEmailChannelRequest(v *EmailChannelRequest) *UpdateEmailChannelInput {
	s.EmailChannelRequest = v
	return s
}

type UpdateEmailChannelOutput struct {
	_ struct{} `type:"structure" payload:"EmailChannelResponse"`

	// Email Channel Response.
	//
	// EmailChannelResponse is a required field
	EmailChannelResponse *EmailChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEmailChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEmailChannelOutput) GoString() string {
	return s.String()
}

// SetEmailChannelResponse sets the EmailChannelResponse field's value.
func (s *UpdateEmailChannelOutput) SetEmailChannelResponse(v *EmailChannelResponse) *UpdateEmailChannelOutput {
	s.EmailChannelResponse = v
	return s
}

type UpdateEndpointInput struct {
	_ struct{} `type:"structure" payload:"EndpointRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// EndpointId is a required field
	EndpointId *string `location:"uri" locationName:"endpoint-id" type:"string" required:"true"`

	// Endpoint update request
	//
	// EndpointRequest is a required field
	EndpointRequest *EndpointRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEndpointInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.EndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointId"))
	}
	if s.EndpointRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateEndpointInput) SetApplicationId(v string) *UpdateEndpointInput {
	s.ApplicationId = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *UpdateEndpointInput) SetEndpointId(v string) *UpdateEndpointInput {
	s.EndpointId = &v
	return s
}

// SetEndpointRequest sets the EndpointRequest field's value.
func (s *UpdateEndpointInput) SetEndpointRequest(v *EndpointRequest) *UpdateEndpointInput {
	s.EndpointRequest = v
	return s
}

type UpdateEndpointOutput struct {
	_ struct{} `type:"structure" payload:"MessageBody"`

	// Simple message object.
	//
	// MessageBody is a required field
	MessageBody *MessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointOutput) GoString() string {
	return s.String()
}

// SetMessageBody sets the MessageBody field's value.
func (s *UpdateEndpointOutput) SetMessageBody(v *MessageBody) *UpdateEndpointOutput {
	s.MessageBody = v
	return s
}

type UpdateEndpointsBatchInput struct {
	_ struct{} `type:"structure" payload:"EndpointBatchRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Endpoint batch update request.
	//
	// EndpointBatchRequest is a required field
	EndpointBatchRequest *EndpointBatchRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointsBatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointsBatchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEndpointsBatchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEndpointsBatchInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.EndpointBatchRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointBatchRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateEndpointsBatchInput) SetApplicationId(v string) *UpdateEndpointsBatchInput {
	s.ApplicationId = &v
	return s
}

// SetEndpointBatchRequest sets the EndpointBatchRequest field's value.
func (s *UpdateEndpointsBatchInput) SetEndpointBatchRequest(v *EndpointBatchRequest) *UpdateEndpointsBatchInput {
	s.EndpointBatchRequest = v
	return s
}

type UpdateEndpointsBatchOutput struct {
	_ struct{} `type:"structure" payload:"MessageBody"`

	// Simple message object.
	//
	// MessageBody is a required field
	MessageBody *MessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointsBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointsBatchOutput) GoString() string {
	return s.String()
}

// SetMessageBody sets the MessageBody field's value.
func (s *UpdateEndpointsBatchOutput) SetMessageBody(v *MessageBody) *UpdateEndpointsBatchOutput {
	s.MessageBody = v
	return s
}

type UpdateGcmChannelInput struct {
	_ struct{} `type:"structure" payload:"GCMChannelRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Google Cloud Messaging credentials
	//
	// GCMChannelRequest is a required field
	GCMChannelRequest *GCMChannelRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateGcmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGcmChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGcmChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGcmChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.GCMChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("GCMChannelRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateGcmChannelInput) SetApplicationId(v string) *UpdateGcmChannelInput {
	s.ApplicationId = &v
	return s
}

// SetGCMChannelRequest sets the GCMChannelRequest field's value.
func (s *UpdateGcmChannelInput) SetGCMChannelRequest(v *GCMChannelRequest) *UpdateGcmChannelInput {
	s.GCMChannelRequest = v
	return s
}

type UpdateGcmChannelOutput struct {
	_ struct{} `type:"structure" payload:"GCMChannelResponse"`

	// Google Cloud Messaging channel definition
	//
	// GCMChannelResponse is a required field
	GCMChannelResponse *GCMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateGcmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGcmChannelOutput) GoString() string {
	return s.String()
}

// SetGCMChannelResponse sets the GCMChannelResponse field's value.
func (s *UpdateGcmChannelOutput) SetGCMChannelResponse(v *GCMChannelResponse) *UpdateGcmChannelOutput {
	s.GCMChannelResponse = v
	return s
}

type UpdateSegmentInput struct {
	_ struct{} `type:"structure" payload:"WriteSegmentRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SegmentId is a required field
	SegmentId *string `location:"uri" locationName:"segment-id" type:"string" required:"true"`

	// Segment definition.
	//
	// WriteSegmentRequest is a required field
	WriteSegmentRequest *WriteSegmentRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateSegmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSegmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSegmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSegmentInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.SegmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentId"))
	}
	if s.WriteSegmentRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteSegmentRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateSegmentInput) SetApplicationId(v string) *UpdateSegmentInput {
	s.ApplicationId = &v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *UpdateSegmentInput) SetSegmentId(v string) *UpdateSegmentInput {
	s.SegmentId = &v
	return s
}

// SetWriteSegmentRequest sets the WriteSegmentRequest field's value.
func (s *UpdateSegmentInput) SetWriteSegmentRequest(v *WriteSegmentRequest) *UpdateSegmentInput {
	s.WriteSegmentRequest = v
	return s
}

type UpdateSegmentOutput struct {
	_ struct{} `type:"structure" payload:"SegmentResponse"`

	// Segment definition.
	//
	// SegmentResponse is a required field
	SegmentResponse *SegmentResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateSegmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSegmentOutput) GoString() string {
	return s.String()
}

// SetSegmentResponse sets the SegmentResponse field's value.
func (s *UpdateSegmentOutput) SetSegmentResponse(v *SegmentResponse) *UpdateSegmentOutput {
	s.SegmentResponse = v
	return s
}

type UpdateSmsChannelInput struct {
	_ struct{} `type:"structure" payload:"SMSChannelRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// SMS Channel Request
	//
	// SMSChannelRequest is a required field
	SMSChannelRequest *SMSChannelRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateSmsChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSmsChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSmsChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSmsChannelInput"}
	if s.ApplicationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationId"))
	}
	if s.SMSChannelRequest == nil {
		invalidParams.Add(request.NewErrParamRequired("SMSChannelRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationId sets the ApplicationId field's value.
func (s *UpdateSmsChannelInput) SetApplicationId(v string) *UpdateSmsChannelInput {
	s.ApplicationId = &v
	return s
}

// SetSMSChannelRequest sets the SMSChannelRequest field's value.
func (s *UpdateSmsChannelInput) SetSMSChannelRequest(v *SMSChannelRequest) *UpdateSmsChannelInput {
	s.SMSChannelRequest = v
	return s
}

type UpdateSmsChannelOutput struct {
	_ struct{} `type:"structure" payload:"SMSChannelResponse"`

	// SMS Channel Response.
	//
	// SMSChannelResponse is a required field
	SMSChannelResponse *SMSChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateSmsChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSmsChannelOutput) GoString() string {
	return s.String()
}

// SetSMSChannelResponse sets the SMSChannelResponse field's value.
func (s *UpdateSmsChannelOutput) SetSMSChannelResponse(v *SMSChannelResponse) *UpdateSmsChannelOutput {
	s.SMSChannelResponse = v
	return s
}

// Creating application setting request
type WriteApplicationSettingsRequest struct {
	_ struct{} `type:"structure"`

	// Default campaign hook information.
	CampaignHook *CampaignHook `type:"structure"`

	// The default campaign limits for the app. These limits apply to each campaign
	// for the app, unless the campaign overrides the default with limits of its
	// own.
	Limits *CampaignLimits `type:"structure"`

	// The default quiet time for the app. Each campaign for this app sends no messages
	// during this time unless the campaign overrides the default with a quiet time
	// of its own.
	QuietTime *QuietTime `type:"structure"`
}

// String returns the string representation
func (s WriteApplicationSettingsRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WriteApplicationSettingsRequest) GoString() string {
	return s.String()
}

// SetCampaignHook sets the CampaignHook field's value.
func (s *WriteApplicationSettingsRequest) SetCampaignHook(v *CampaignHook) *WriteApplicationSettingsRequest {
	s.CampaignHook = v
	return s
}

// SetLimits sets the Limits field's value.
func (s *WriteApplicationSettingsRequest) SetLimits(v *CampaignLimits) *WriteApplicationSettingsRequest {
	s.Limits = v
	return s
}

// SetQuietTime sets the QuietTime field's value.
func (s *WriteApplicationSettingsRequest) SetQuietTime(v *QuietTime) *WriteApplicationSettingsRequest {
	s.QuietTime = v
	return s
}

// Used to create a campaign.
type WriteCampaignRequest struct {
	_ struct{} `type:"structure"`

	// Treatments that are defined in addition to the default treatment.
	AdditionalTreatments []*WriteTreatmentResource `type:"list"`

	// A description of the campaign.
	Description *string `type:"string"`

	// The allocated percentage of end users who will not receive messages from
	// this campaign.
	HoldoutPercent *int64 `type:"integer"`

	// Campaign hook information.
	Hook *CampaignHook `type:"structure"`

	// Indicates whether the campaign is paused. A paused campaign does not send
	// messages unless you resume it by setting IsPaused to false.
	IsPaused *bool `type:"boolean"`

	// The campaign limits settings.
	Limits *CampaignLimits `type:"structure"`

	// The message configuration settings.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The custom name of the campaign.
	Name *string `type:"string"`

	// The campaign schedule.
	Schedule *Schedule `type:"structure"`

	// The ID of the segment to which the campaign sends messages.
	SegmentId *string `type:"string"`

	// The version of the segment to which the campaign sends messages.
	SegmentVersion *int64 `type:"integer"`

	// A custom description for the treatment.
	TreatmentDescription *string `type:"string"`

	// The custom name of a variation of the campaign used for A/B testing.
	TreatmentName *string `type:"string"`
}

// String returns the string representation
func (s WriteCampaignRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WriteCampaignRequest) GoString() string {
	return s.String()
}

// SetAdditionalTreatments sets the AdditionalTreatments field's value.
func (s *WriteCampaignRequest) SetAdditionalTreatments(v []*WriteTreatmentResource) *WriteCampaignRequest {
	s.AdditionalTreatments = v
	return s
}

// SetDescription sets the Description field's value.
func (s *WriteCampaignRequest) SetDescription(v string) *WriteCampaignRequest {
	s.Description = &v
	return s
}

// SetHoldoutPercent sets the HoldoutPercent field's value.
func (s *WriteCampaignRequest) SetHoldoutPercent(v int64) *WriteCampaignRequest {
	s.HoldoutPercent = &v
	return s
}

// SetHook sets the Hook field's value.
func (s *WriteCampaignRequest) SetHook(v *CampaignHook) *WriteCampaignRequest {
	s.Hook = v
	return s
}

// SetIsPaused sets the IsPaused field's value.
func (s *WriteCampaignRequest) SetIsPaused(v bool) *WriteCampaignRequest {
	s.IsPaused = &v
	return s
}

// SetLimits sets the Limits field's value.
func (s *WriteCampaignRequest) SetLimits(v *CampaignLimits) *WriteCampaignRequest {
	s.Limits = v
	return s
}

// SetMessageConfiguration sets the MessageConfiguration field's value.
func (s *WriteCampaignRequest) SetMessageConfiguration(v *MessageConfiguration) *WriteCampaignRequest {
	s.MessageConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *WriteCampaignRequest) SetName(v string) *WriteCampaignRequest {
	s.Name = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *WriteCampaignRequest) SetSchedule(v *Schedule) *WriteCampaignRequest {
	s.Schedule = v
	return s
}

// SetSegmentId sets the SegmentId field's value.
func (s *WriteCampaignRequest) SetSegmentId(v string) *WriteCampaignRequest {
	s.SegmentId = &v
	return s
}

// SetSegmentVersion sets the SegmentVersion field's value.
func (s *WriteCampaignRequest) SetSegmentVersion(v int64) *WriteCampaignRequest {
	s.SegmentVersion = &v
	return s
}

// SetTreatmentDescription sets the TreatmentDescription field's value.
func (s *WriteCampaignRequest) SetTreatmentDescription(v string) *WriteCampaignRequest {
	s.TreatmentDescription = &v
	return s
}

// SetTreatmentName sets the TreatmentName field's value.
func (s *WriteCampaignRequest) SetTreatmentName(v string) *WriteCampaignRequest {
	s.TreatmentName = &v
	return s
}

// Request to save an EventStream.
type WriteEventStream struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis stream or Firehose delivery
	// stream to which you want to publish events. Firehose ARN: arn:aws:firehose:REGION:ACCOUNT_ID:deliverystream/STREAM_NAME
	// Kinesis ARN: arn:aws:kinesis:REGION:ACCOUNT_ID:stream/STREAM_NAME
	DestinationStreamArn *string `type:"string"`

	// The IAM role that authorizes Amazon Pinpoint to publish events to the stream
	// in your account.
	RoleArn *string `type:"string"`
}

// String returns the string representation
func (s WriteEventStream) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WriteEventStream) GoString() string {
	return s.String()
}

// SetDestinationStreamArn sets the DestinationStreamArn field's value.
func (s *WriteEventStream) SetDestinationStreamArn(v string) *WriteEventStream {
	s.DestinationStreamArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *WriteEventStream) SetRoleArn(v string) *WriteEventStream {
	s.RoleArn = &v
	return s
}

// Segment definition.
type WriteSegmentRequest struct {
	_ struct{} `type:"structure"`

	// The segment dimensions attributes.
	Dimensions *SegmentDimensions `type:"structure"`

	// The name of segment
	Name *string `type:"string"`
}

// String returns the string representation
func (s WriteSegmentRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WriteSegmentRequest) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *WriteSegmentRequest) SetDimensions(v *SegmentDimensions) *WriteSegmentRequest {
	s.Dimensions = v
	return s
}

// SetName sets the Name field's value.
func (s *WriteSegmentRequest) SetName(v string) *WriteSegmentRequest {
	s.Name = &v
	return s
}

// Used to create a campaign treatment.
type WriteTreatmentResource struct {
	_ struct{} `type:"structure"`

	// The message configuration settings.
	MessageConfiguration *MessageConfiguration `type:"structure"`

	// The campaign schedule.
	Schedule *Schedule `type:"structure"`

	// The allocated percentage of users for this treatment.
	SizePercent *int64 `type:"integer"`

	// A custom description for the treatment.
	TreatmentDescription *string `type:"string"`

	// The custom name of a variation of the campaign used for A/B testing.
	TreatmentName *string `type:"string"`
}

// String returns the string representation
func (s WriteTreatmentResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WriteTreatmentResource) GoString() string {
	return s.String()
}

// SetMessageConfiguration sets the MessageConfiguration field's value.
func (s *WriteTreatmentResource) SetMessageConfiguration(v *MessageConfiguration) *WriteTreatmentResource {
	s.MessageConfiguration = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *WriteTreatmentResource) SetSchedule(v *Schedule) *WriteTreatmentResource {
	s.Schedule = v
	return s
}

// SetSizePercent sets the SizePercent field's value.
func (s *WriteTreatmentResource) SetSizePercent(v int64) *WriteTreatmentResource {
	s.SizePercent = &v
	return s
}

// SetTreatmentDescription sets the TreatmentDescription field's value.
func (s *WriteTreatmentResource) SetTreatmentDescription(v string) *WriteTreatmentResource {
	s.TreatmentDescription = &v
	return s
}

// SetTreatmentName sets the TreatmentName field's value.
func (s *WriteTreatmentResource) SetTreatmentName(v string) *WriteTreatmentResource {
	s.TreatmentName = &v
	return s
}

const (
	// ActionOpenApp is a Action enum value
	ActionOpenApp = "OPEN_APP"

	// ActionDeepLink is a Action enum value
	ActionDeepLink = "DEEP_LINK"

	// ActionUrl is a Action enum value
	ActionUrl = "URL"
)

const (
	// AttributeTypeInclusive is a AttributeType enum value
	AttributeTypeInclusive = "INCLUSIVE"

	// AttributeTypeExclusive is a AttributeType enum value
	AttributeTypeExclusive = "EXCLUSIVE"
)

const (
	// CampaignStatusScheduled is a CampaignStatus enum value
	CampaignStatusScheduled = "SCHEDULED"

	// CampaignStatusExecuting is a CampaignStatus enum value
	CampaignStatusExecuting = "EXECUTING"

	// CampaignStatusPendingNextRun is a CampaignStatus enum value
	CampaignStatusPendingNextRun = "PENDING_NEXT_RUN"

	// CampaignStatusCompleted is a CampaignStatus enum value
	CampaignStatusCompleted = "COMPLETED"

	// CampaignStatusPaused is a CampaignStatus enum value
	CampaignStatusPaused = "PAUSED"
)

const (
	// ChannelTypeGcm is a ChannelType enum value
	ChannelTypeGcm = "GCM"

	// ChannelTypeApns is a ChannelType enum value
	ChannelTypeApns = "APNS"

	// ChannelTypeApnsSandbox is a ChannelType enum value
	ChannelTypeApnsSandbox = "APNS_SANDBOX"

	// ChannelTypeApnsVoip is a ChannelType enum value
	ChannelTypeApnsVoip = "APNS_VOIP"

	// ChannelTypeApnsVoipSandbox is a ChannelType enum value
	ChannelTypeApnsVoipSandbox = "APNS_VOIP_SANDBOX"

	// ChannelTypeAdm is a ChannelType enum value
	ChannelTypeAdm = "ADM"

	// ChannelTypeSms is a ChannelType enum value
	ChannelTypeSms = "SMS"

	// ChannelTypeEmail is a ChannelType enum value
	ChannelTypeEmail = "EMAIL"

	// ChannelTypeBaidu is a ChannelType enum value
	ChannelTypeBaidu = "BAIDU"

	// ChannelTypeCustom is a ChannelType enum value
	ChannelTypeCustom = "CUSTOM"
)

const (
	// DeliveryStatusSuccessful is a DeliveryStatus enum value
	DeliveryStatusSuccessful = "SUCCESSFUL"

	// DeliveryStatusThrottled is a DeliveryStatus enum value
	DeliveryStatusThrottled = "THROTTLED"

	// DeliveryStatusTemporaryFailure is a DeliveryStatus enum value
	DeliveryStatusTemporaryFailure = "TEMPORARY_FAILURE"

	// DeliveryStatusPermanentFailure is a DeliveryStatus enum value
	DeliveryStatusPermanentFailure = "PERMANENT_FAILURE"

	// DeliveryStatusUnknownFailure is a DeliveryStatus enum value
	DeliveryStatusUnknownFailure = "UNKNOWN_FAILURE"

	// DeliveryStatusOptOut is a DeliveryStatus enum value
	DeliveryStatusOptOut = "OPT_OUT"

	// DeliveryStatusDuplicate is a DeliveryStatus enum value
	DeliveryStatusDuplicate = "DUPLICATE"
)

const (
	// DimensionTypeInclusive is a DimensionType enum value
	DimensionTypeInclusive = "INCLUSIVE"

	// DimensionTypeExclusive is a DimensionType enum value
	DimensionTypeExclusive = "EXCLUSIVE"
)

const (
	// DurationHr24 is a Duration enum value
	DurationHr24 = "HR_24"

	// DurationDay7 is a Duration enum value
	DurationDay7 = "DAY_7"

	// DurationDay14 is a Duration enum value
	DurationDay14 = "DAY_14"

	// DurationDay30 is a Duration enum value
	DurationDay30 = "DAY_30"
)

const (
	// FormatCsv is a Format enum value
	FormatCsv = "CSV"

	// FormatJson is a Format enum value
	FormatJson = "JSON"
)

const (
	// FrequencyOnce is a Frequency enum value
	FrequencyOnce = "ONCE"

	// FrequencyHourly is a Frequency enum value
	FrequencyHourly = "HOURLY"

	// FrequencyDaily is a Frequency enum value
	FrequencyDaily = "DAILY"

	// FrequencyWeekly is a Frequency enum value
	FrequencyWeekly = "WEEKLY"

	// FrequencyMonthly is a Frequency enum value
	FrequencyMonthly = "MONTHLY"
)

const (
	// JobStatusCreated is a JobStatus enum value
	JobStatusCreated = "CREATED"

	// JobStatusInitializing is a JobStatus enum value
	JobStatusInitializing = "INITIALIZING"

	// JobStatusProcessing is a JobStatus enum value
	JobStatusProcessing = "PROCESSING"

	// JobStatusCompleting is a JobStatus enum value
	JobStatusCompleting = "COMPLETING"

	// JobStatusCompleted is a JobStatus enum value
	JobStatusCompleted = "COMPLETED"

	// JobStatusFailing is a JobStatus enum value
	JobStatusFailing = "FAILING"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"
)

const (
	// MessageTypeTransactional is a MessageType enum value
	MessageTypeTransactional = "TRANSACTIONAL"

	// MessageTypePromotional is a MessageType enum value
	MessageTypePromotional = "PROMOTIONAL"
)

const (
	// ModeDelivery is a Mode enum value
	ModeDelivery = "DELIVERY"

	// ModeFilter is a Mode enum value
	ModeFilter = "FILTER"
)

const (
	// RecencyTypeActive is a RecencyType enum value
	RecencyTypeActive = "ACTIVE"

	// RecencyTypeInactive is a RecencyType enum value
	RecencyTypeInactive = "INACTIVE"
)

const (
	// SegmentTypeDimensional is a SegmentType enum value
	SegmentTypeDimensional = "DIMENSIONAL"

	// SegmentTypeImport is a SegmentType enum value
	SegmentTypeImport = "IMPORT"
)
