package entitysearch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
)

// AnswerType enumerates the values for answer type.
type AnswerType string

const (
	// AnswerTypeEntities ...
	AnswerTypeEntities AnswerType = "Entities"
	// AnswerTypePlaces ...
	AnswerTypePlaces AnswerType = "Places"
)

// EntityQueryScenario enumerates the values for entity query scenario.
type EntityQueryScenario string

const (
	// Disambiguation ...
	Disambiguation EntityQueryScenario = "Disambiguation"
	// DominantEntity ...
	DominantEntity EntityQueryScenario = "DominantEntity"
	// DominantEntityWithDisambiguation ...
	DominantEntityWithDisambiguation EntityQueryScenario = "DominantEntityWithDisambiguation"
	// List ...
	List EntityQueryScenario = "List"
	// ListWithPivot ...
	ListWithPivot EntityQueryScenario = "ListWithPivot"
)

// EntityScenario enumerates the values for entity scenario.
type EntityScenario string

const (
	// EntityScenarioDisambiguationItem ...
	EntityScenarioDisambiguationItem EntityScenario = "DisambiguationItem"
	// EntityScenarioDominantEntity ...
	EntityScenarioDominantEntity EntityScenario = "DominantEntity"
	// EntityScenarioListItem ...
	EntityScenarioListItem EntityScenario = "ListItem"
)

// EntityType enumerates the values for entity type.
type EntityType string

const (
	// EntityTypeActor ...
	EntityTypeActor EntityType = "Actor"
	// EntityTypeAnimal ...
	EntityTypeAnimal EntityType = "Animal"
	// EntityTypeArtist ...
	EntityTypeArtist EntityType = "Artist"
	// EntityTypeAttorney ...
	EntityTypeAttorney EntityType = "Attorney"
	// EntityTypeAttraction ...
	EntityTypeAttraction EntityType = "Attraction"
	// EntityTypeBook ...
	EntityTypeBook EntityType = "Book"
	// EntityTypeCar ...
	EntityTypeCar EntityType = "Car"
	// EntityTypeCity ...
	EntityTypeCity EntityType = "City"
	// EntityTypeCollegeOrUniversity ...
	EntityTypeCollegeOrUniversity EntityType = "CollegeOrUniversity"
	// EntityTypeComposition ...
	EntityTypeComposition EntityType = "Composition"
	// EntityTypeContinent ...
	EntityTypeContinent EntityType = "Continent"
	// EntityTypeCountry ...
	EntityTypeCountry EntityType = "Country"
	// EntityTypeDrug ...
	EntityTypeDrug EntityType = "Drug"
	// EntityTypeEvent ...
	EntityTypeEvent EntityType = "Event"
	// EntityTypeFood ...
	EntityTypeFood EntityType = "Food"
	// EntityTypeGeneric ...
	EntityTypeGeneric EntityType = "Generic"
	// EntityTypeHotel ...
	EntityTypeHotel EntityType = "Hotel"
	// EntityTypeHouse ...
	EntityTypeHouse EntityType = "House"
	// EntityTypeLocalBusiness ...
	EntityTypeLocalBusiness EntityType = "LocalBusiness"
	// EntityTypeLocality ...
	EntityTypeLocality EntityType = "Locality"
	// EntityTypeMedia ...
	EntityTypeMedia EntityType = "Media"
	// EntityTypeMinorRegion ...
	EntityTypeMinorRegion EntityType = "MinorRegion"
	// EntityTypeMovie ...
	EntityTypeMovie EntityType = "Movie"
	// EntityTypeMusicAlbum ...
	EntityTypeMusicAlbum EntityType = "MusicAlbum"
	// EntityTypeMusicGroup ...
	EntityTypeMusicGroup EntityType = "MusicGroup"
	// EntityTypeMusicRecording ...
	EntityTypeMusicRecording EntityType = "MusicRecording"
	// EntityTypeNeighborhood ...
	EntityTypeNeighborhood EntityType = "Neighborhood"
	// EntityTypeOrganization ...
	EntityTypeOrganization EntityType = "Organization"
	// EntityTypeOther ...
	EntityTypeOther EntityType = "Other"
	// EntityTypePerson ...
	EntityTypePerson EntityType = "Person"
	// EntityTypePlace ...
	EntityTypePlace EntityType = "Place"
	// EntityTypePointOfInterest ...
	EntityTypePointOfInterest EntityType = "PointOfInterest"
	// EntityTypePostalCode ...
	EntityTypePostalCode EntityType = "PostalCode"
	// EntityTypeProduct ...
	EntityTypeProduct EntityType = "Product"
	// EntityTypeRadioStation ...
	EntityTypeRadioStation EntityType = "RadioStation"
	// EntityTypeRegion ...
	EntityTypeRegion EntityType = "Region"
	// EntityTypeRestaurant ...
	EntityTypeRestaurant EntityType = "Restaurant"
	// EntityTypeSchool ...
	EntityTypeSchool EntityType = "School"
	// EntityTypeSpeciality ...
	EntityTypeSpeciality EntityType = "Speciality"
	// EntityTypeSportsTeam ...
	EntityTypeSportsTeam EntityType = "SportsTeam"
	// EntityTypeState ...
	EntityTypeState EntityType = "State"
	// EntityTypeStreetAddress ...
	EntityTypeStreetAddress EntityType = "StreetAddress"
	// EntityTypeSubRegion ...
	EntityTypeSubRegion EntityType = "SubRegion"
	// EntityTypeTelevisionSeason ...
	EntityTypeTelevisionSeason EntityType = "TelevisionSeason"
	// EntityTypeTelevisionShow ...
	EntityTypeTelevisionShow EntityType = "TelevisionShow"
	// EntityTypeTheaterPlay ...
	EntityTypeTheaterPlay EntityType = "TheaterPlay"
	// EntityTypeTouristAttraction ...
	EntityTypeTouristAttraction EntityType = "TouristAttraction"
	// EntityTypeTravel ...
	EntityTypeTravel EntityType = "Travel"
	// EntityTypeVideoGame ...
	EntityTypeVideoGame EntityType = "VideoGame"
)

// ErrorCode enumerates the values for error code.
type ErrorCode string

const (
	// InsufficientAuthorization ...
	InsufficientAuthorization ErrorCode = "InsufficientAuthorization"
	// InvalidAuthorization ...
	InvalidAuthorization ErrorCode = "InvalidAuthorization"
	// InvalidRequest ...
	InvalidRequest ErrorCode = "InvalidRequest"
	// None ...
	None ErrorCode = "None"
	// RateLimitExceeded ...
	RateLimitExceeded ErrorCode = "RateLimitExceeded"
	// ServerError ...
	ServerError ErrorCode = "ServerError"
)

// ErrorSubCode enumerates the values for error sub code.
type ErrorSubCode string

const (
	// AuthorizationDisabled ...
	AuthorizationDisabled ErrorSubCode = "AuthorizationDisabled"
	// AuthorizationExpired ...
	AuthorizationExpired ErrorSubCode = "AuthorizationExpired"
	// AuthorizationMissing ...
	AuthorizationMissing ErrorSubCode = "AuthorizationMissing"
	// AuthorizationRedundancy ...
	AuthorizationRedundancy ErrorSubCode = "AuthorizationRedundancy"
	// Blocked ...
	Blocked ErrorSubCode = "Blocked"
	// HTTPNotAllowed ...
	HTTPNotAllowed ErrorSubCode = "HttpNotAllowed"
	// NotImplemented ...
	NotImplemented ErrorSubCode = "NotImplemented"
	// ParameterInvalidValue ...
	ParameterInvalidValue ErrorSubCode = "ParameterInvalidValue"
	// ParameterMissing ...
	ParameterMissing ErrorSubCode = "ParameterMissing"
	// ResourceError ...
	ResourceError ErrorSubCode = "ResourceError"
	// UnexpectedError ...
	UnexpectedError ErrorSubCode = "UnexpectedError"
)

// ResponseFormat enumerates the values for response format.
type ResponseFormat string

const (
	// JSON ...
	JSON ResponseFormat = "Json"
	// JSONLd ...
	JSONLd ResponseFormat = "JsonLd"
)

// SafeSearch enumerates the values for safe search.
type SafeSearch string

const (
	// Moderate ...
	Moderate SafeSearch = "Moderate"
	// Off ...
	Off SafeSearch = "Off"
	// Strict ...
	Strict SafeSearch = "Strict"
)

// Type enumerates the values for type.
type Type string

const (
	// TypeContractualRulesAttribution ...
	TypeContractualRulesAttribution Type = "ContractualRules/Attribution"
	// TypeContractualRulesContractualRule ...
	TypeContractualRulesContractualRule Type = "ContractualRules/ContractualRule"
	// TypeContractualRulesLicenseAttribution ...
	TypeContractualRulesLicenseAttribution Type = "ContractualRules/LicenseAttribution"
	// TypeContractualRulesLinkAttribution ...
	TypeContractualRulesLinkAttribution Type = "ContractualRules/LinkAttribution"
	// TypeContractualRulesMediaAttribution ...
	TypeContractualRulesMediaAttribution Type = "ContractualRules/MediaAttribution"
	// TypeContractualRulesTextAttribution ...
	TypeContractualRulesTextAttribution Type = "ContractualRules/TextAttribution"
)

// TypeBasicResponseBase enumerates the values for type basic response base.
type TypeBasicResponseBase string

const (
	// TypeAirport ...
	TypeAirport TypeBasicResponseBase = "Airport"
	// TypeAnswer ...
	TypeAnswer TypeBasicResponseBase = "Answer"
	// TypeCivicStructure ...
	TypeCivicStructure TypeBasicResponseBase = "CivicStructure"
	// TypeCreativeWork ...
	TypeCreativeWork TypeBasicResponseBase = "CreativeWork"
	// TypeEntertainmentBusiness ...
	TypeEntertainmentBusiness TypeBasicResponseBase = "EntertainmentBusiness"
	// TypeEntities ...
	TypeEntities TypeBasicResponseBase = "Entities"
	// TypeErrorResponse ...
	TypeErrorResponse TypeBasicResponseBase = "ErrorResponse"
	// TypeFoodEstablishment ...
	TypeFoodEstablishment TypeBasicResponseBase = "FoodEstablishment"
	// TypeHotel ...
	TypeHotel TypeBasicResponseBase = "Hotel"
	// TypeIdentifiable ...
	TypeIdentifiable TypeBasicResponseBase = "Identifiable"
	// TypeImageObject ...
	TypeImageObject TypeBasicResponseBase = "ImageObject"
	// TypeIntangible ...
	TypeIntangible TypeBasicResponseBase = "Intangible"
	// TypeLicense ...
	TypeLicense TypeBasicResponseBase = "License"
	// TypeLocalBusiness ...
	TypeLocalBusiness TypeBasicResponseBase = "LocalBusiness"
	// TypeLodgingBusiness ...
	TypeLodgingBusiness TypeBasicResponseBase = "LodgingBusiness"
	// TypeMediaObject ...
	TypeMediaObject TypeBasicResponseBase = "MediaObject"
	// TypeMovieTheater ...
	TypeMovieTheater TypeBasicResponseBase = "MovieTheater"
	// TypeOrganization ...
	TypeOrganization TypeBasicResponseBase = "Organization"
	// TypePlace ...
	TypePlace TypeBasicResponseBase = "Place"
	// TypePlaces ...
	TypePlaces TypeBasicResponseBase = "Places"
	// TypePostalAddress ...
	TypePostalAddress TypeBasicResponseBase = "PostalAddress"
	// TypeResponse ...
	TypeResponse TypeBasicResponseBase = "Response"
	// TypeResponseBase ...
	TypeResponseBase TypeBasicResponseBase = "ResponseBase"
	// TypeRestaurant ...
	TypeRestaurant TypeBasicResponseBase = "Restaurant"
	// TypeSearchResponse ...
	TypeSearchResponse TypeBasicResponseBase = "SearchResponse"
	// TypeSearchResultsAnswer ...
	TypeSearchResultsAnswer TypeBasicResponseBase = "SearchResultsAnswer"
	// TypeStructuredValue ...
	TypeStructuredValue TypeBasicResponseBase = "StructuredValue"
	// TypeThing ...
	TypeThing TypeBasicResponseBase = "Thing"
	// TypeTouristAttraction ...
	TypeTouristAttraction TypeBasicResponseBase = "TouristAttraction"
)

// Airport ...
type Airport struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// Address - The postal address of where the entity is located
	Address *PostalAddress `json:"address,omitempty"`
	// Telephone - The entity's telephone number
	Telephone *string `json:"telephone,omitempty"`
	IataCode  *string `json:"iataCode,omitempty"`
	IcaoCode  *string `json:"icaoCode,omitempty"`
}

// MarshalJSON is the custom marshaler for Airport.
func (a Airport) MarshalJSON() ([]byte, error) {
	a.Type = TypeAirport
	type Alias Airport
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(a),
	})
}

// AsImageObject is the BasicResponseBase implementation for Airport.
func (a Airport) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Airport.
func (a Airport) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Airport.
func (a Airport) AsBasicThing() (BasicThing, bool) {
	return &a, true
}

// AsEntities is the BasicResponseBase implementation for Airport.
func (a Airport) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Airport.
func (a Airport) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Airport.
func (a Airport) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Airport.
func (a Airport) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Airport.
func (a Airport) AsBasicResponse() (BasicResponse, bool) {
	return &a, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Airport.
func (a Airport) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Airport.
func (a Airport) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Airport.
func (a Airport) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Airport.
func (a Airport) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &a, true
}

// AsAnswer is the BasicResponseBase implementation for Airport.
func (a Airport) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Airport.
func (a Airport) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Airport.
func (a Airport) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Airport.
func (a Airport) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Airport.
func (a Airport) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for Airport.
func (a Airport) AsBasicPlace() (BasicPlace, bool) {
	return &a, true
}

// AsOrganization is the BasicResponseBase implementation for Airport.
func (a Airport) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Airport.
func (a Airport) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Airport.
func (a Airport) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Airport.
func (a Airport) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Airport.
func (a Airport) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for Airport.
func (a Airport) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Airport.
func (a Airport) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Airport.
func (a Airport) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for Airport.
func (a Airport) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for Airport.
func (a Airport) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return &a, true
}

// AsLocalBusiness is the BasicResponseBase implementation for Airport.
func (a Airport) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for Airport.
func (a Airport) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for Airport.
func (a Airport) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for Airport.
func (a Airport) AsAirport() (*Airport, bool) {
	return &a, true
}

// AsLicense is the BasicResponseBase implementation for Airport.
func (a Airport) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Airport.
func (a Airport) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Airport.
func (a Airport) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for Airport.
func (a Airport) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for Airport.
func (a Airport) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for Airport.
func (a Airport) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for Airport.
func (a Airport) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for Airport.
func (a Airport) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for Airport.
func (a Airport) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for Airport.
func (a Airport) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for Airport.
func (a Airport) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Airport.
func (a Airport) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Airport.
func (a Airport) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &a, true
}

// UnmarshalJSON is the custom unmarshaler for Airport struct.
func (a *Airport) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["iataCode"]
	if v != nil {
		var iataCode string
		err = json.Unmarshal(*m["iataCode"], &iataCode)
		if err != nil {
			return err
		}
		a.IataCode = &iataCode
	}

	v = m["icaoCode"]
	if v != nil {
		var icaoCode string
		err = json.Unmarshal(*m["icaoCode"], &icaoCode)
		if err != nil {
			return err
		}
		a.IcaoCode = &icaoCode
	}

	v = m["address"]
	if v != nil {
		var address PostalAddress
		err = json.Unmarshal(*m["address"], &address)
		if err != nil {
			return err
		}
		a.Address = &address
	}

	v = m["telephone"]
	if v != nil {
		var telephone string
		err = json.Unmarshal(*m["telephone"], &telephone)
		if err != nil {
			return err
		}
		a.Telephone = &telephone
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		a.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		a.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		a.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		a.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		a.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		a.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		a.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		a.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		a.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		a.Type = _type
	}

	return nil
}

// BasicAnswer
type BasicAnswer interface {
	AsEntities() (*Entities, bool)
	AsPlaces() (*Places, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
}

// Answer
type Answer struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
}

func unmarshalBasicAnswer(body []byte) (BasicAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeEntities):
		var e Entities
		err := json.Unmarshal(body, &e)
		return e, err
	case string(TypePlaces):
		var p Places
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	default:
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicAnswerArray(body []byte) ([]BasicAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Answer.
func (a Answer) MarshalJSON() ([]byte, error) {
	a.Type = TypeAnswer
	type Alias Answer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(a),
	})
}

// AsImageObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsEntities is the BasicResponseBase implementation for Answer.
func (a Answer) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Answer.
func (a Answer) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponse() (BasicResponse, bool) {
	return &a, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &a, true
}

// AsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsAnswer() (*Answer, bool) {
	return &a, true
}

// AsBasicAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicAnswer() (BasicAnswer, bool) {
	return &a, true
}

// AsErrorResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Answer.
func (a Answer) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Answer.
func (a Answer) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicPlace() (BasicPlace, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Answer.
func (a Answer) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Answer.
func (a Answer) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for Answer.
func (a Answer) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for Answer.
func (a Answer) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for Answer.
func (a Answer) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for Answer.
func (a Answer) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for Answer.
func (a Answer) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for Answer.
func (a Answer) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Answer.
func (a Answer) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for Answer.
func (a Answer) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for Answer.
func (a Answer) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for Answer.
func (a Answer) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for Answer.
func (a Answer) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for Answer.
func (a Answer) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &a, true
}

// UnmarshalJSON is the custom unmarshaler for Answer struct.
func (a *Answer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		a.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		a.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		a.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		a.Type = _type
	}

	return nil
}

// BasicCivicStructure
type BasicCivicStructure interface {
	AsAirport() (*Airport, bool)
	AsCivicStructure() (*CivicStructure, bool)
}

// CivicStructure
type CivicStructure struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// Address - The postal address of where the entity is located
	Address *PostalAddress `json:"address,omitempty"`
	// Telephone - The entity's telephone number
	Telephone *string `json:"telephone,omitempty"`
}

func unmarshalBasicCivicStructure(body []byte) (BasicCivicStructure, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeAirport):
		var a Airport
		err := json.Unmarshal(body, &a)
		return a, err
	default:
		var cs CivicStructure
		err := json.Unmarshal(body, &cs)
		return cs, err
	}
}
func unmarshalBasicCivicStructureArray(body []byte) ([]BasicCivicStructure, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	csArray := make([]BasicCivicStructure, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cs, err := unmarshalBasicCivicStructure(*rawMessage)
		if err != nil {
			return nil, err
		}
		csArray[index] = cs
	}
	return csArray, nil
}

// MarshalJSON is the custom marshaler for CivicStructure.
func (cs CivicStructure) MarshalJSON() ([]byte, error) {
	cs.Type = TypeCivicStructure
	type Alias CivicStructure
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cs),
	})
}

// AsImageObject is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsBasicThing() (BasicThing, bool) {
	return &cs, true
}

// AsEntities is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsBasicResponse() (BasicResponse, bool) {
	return &cs, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &cs, true
}

// AsAnswer is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsBasicPlace() (BasicPlace, bool) {
	return &cs, true
}

// AsOrganization is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsCivicStructure() (*CivicStructure, bool) {
	return &cs, true
}

// AsBasicCivicStructure is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return &cs, true
}

// AsLocalBusiness is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for CivicStructure.
func (cs CivicStructure) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &cs, true
}

// UnmarshalJSON is the custom unmarshaler for CivicStructure struct.
func (cs *CivicStructure) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["address"]
	if v != nil {
		var address PostalAddress
		err = json.Unmarshal(*m["address"], &address)
		if err != nil {
			return err
		}
		cs.Address = &address
	}

	v = m["telephone"]
	if v != nil {
		var telephone string
		err = json.Unmarshal(*m["telephone"], &telephone)
		if err != nil {
			return err
		}
		cs.Telephone = &telephone
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		cs.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		cs.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		cs.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		cs.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		cs.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		cs.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		cs.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		cs.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		cs.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		cs.Type = _type
	}

	return nil
}

// BasicContractualRulesAttribution
type BasicContractualRulesAttribution interface {
	AsContractualRulesLicenseAttribution() (*ContractualRulesLicenseAttribution, bool)
	AsContractualRulesLinkAttribution() (*ContractualRulesLinkAttribution, bool)
	AsContractualRulesMediaAttribution() (*ContractualRulesMediaAttribution, bool)
	AsContractualRulesTextAttribution() (*ContractualRulesTextAttribution, bool)
	AsContractualRulesAttribution() (*ContractualRulesAttribution, bool)
}

// ContractualRulesAttribution
type ContractualRulesAttribution struct {
	// TargetPropertyName - The name of the field that the rule applies to.
	TargetPropertyName *string `json:"targetPropertyName,omitempty"`
	// Type - Possible values include: 'TypeContractualRulesContractualRule', 'TypeContractualRulesAttribution', 'TypeContractualRulesLicenseAttribution', 'TypeContractualRulesLinkAttribution', 'TypeContractualRulesMediaAttribution', 'TypeContractualRulesTextAttribution'
	Type Type `json:"_type,omitempty"`
	// MustBeCloseToContent - A Boolean value that determines whether the contents of the rule must be placed in close proximity to the field that the rule applies to. If true, the contents must be placed in close proximity. If false, or this field does not exist, the contents may be placed at the caller's discretion.
	MustBeCloseToContent *bool `json:"mustBeCloseToContent,omitempty"`
}

func unmarshalBasicContractualRulesAttribution(body []byte) (BasicContractualRulesAttribution, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeContractualRulesLicenseAttribution):
		var crla ContractualRulesLicenseAttribution
		err := json.Unmarshal(body, &crla)
		return crla, err
	case string(TypeContractualRulesLinkAttribution):
		var crla ContractualRulesLinkAttribution
		err := json.Unmarshal(body, &crla)
		return crla, err
	case string(TypeContractualRulesMediaAttribution):
		var crma ContractualRulesMediaAttribution
		err := json.Unmarshal(body, &crma)
		return crma, err
	case string(TypeContractualRulesTextAttribution):
		var crta ContractualRulesTextAttribution
		err := json.Unmarshal(body, &crta)
		return crta, err
	default:
		var cra ContractualRulesAttribution
		err := json.Unmarshal(body, &cra)
		return cra, err
	}
}
func unmarshalBasicContractualRulesAttributionArray(body []byte) ([]BasicContractualRulesAttribution, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	craArray := make([]BasicContractualRulesAttribution, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cra, err := unmarshalBasicContractualRulesAttribution(*rawMessage)
		if err != nil {
			return nil, err
		}
		craArray[index] = cra
	}
	return craArray, nil
}

// MarshalJSON is the custom marshaler for ContractualRulesAttribution.
func (cra ContractualRulesAttribution) MarshalJSON() ([]byte, error) {
	cra.Type = TypeContractualRulesAttribution
	type Alias ContractualRulesAttribution
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cra),
	})
}

// AsContractualRulesAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesAttribution.
func (cra ContractualRulesAttribution) AsContractualRulesAttribution() (*ContractualRulesAttribution, bool) {
	return &cra, true
}

// AsBasicContractualRulesAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesAttribution.
func (cra ContractualRulesAttribution) AsBasicContractualRulesAttribution() (BasicContractualRulesAttribution, bool) {
	return &cra, true
}

// AsContractualRulesLicenseAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesAttribution.
func (cra ContractualRulesAttribution) AsContractualRulesLicenseAttribution() (*ContractualRulesLicenseAttribution, bool) {
	return nil, false
}

// AsContractualRulesLinkAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesAttribution.
func (cra ContractualRulesAttribution) AsContractualRulesLinkAttribution() (*ContractualRulesLinkAttribution, bool) {
	return nil, false
}

// AsContractualRulesMediaAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesAttribution.
func (cra ContractualRulesAttribution) AsContractualRulesMediaAttribution() (*ContractualRulesMediaAttribution, bool) {
	return nil, false
}

// AsContractualRulesTextAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesAttribution.
func (cra ContractualRulesAttribution) AsContractualRulesTextAttribution() (*ContractualRulesTextAttribution, bool) {
	return nil, false
}

// AsContractualRulesContractualRule is the BasicContractualRulesContractualRule implementation for ContractualRulesAttribution.
func (cra ContractualRulesAttribution) AsContractualRulesContractualRule() (*ContractualRulesContractualRule, bool) {
	return nil, false
}

// AsBasicContractualRulesContractualRule is the BasicContractualRulesContractualRule implementation for ContractualRulesAttribution.
func (cra ContractualRulesAttribution) AsBasicContractualRulesContractualRule() (BasicContractualRulesContractualRule, bool) {
	return &cra, true
}

// BasicContractualRulesContractualRule
type BasicContractualRulesContractualRule interface {
	AsContractualRulesAttribution() (*ContractualRulesAttribution, bool)
	AsBasicContractualRulesAttribution() (BasicContractualRulesAttribution, bool)
	AsContractualRulesLicenseAttribution() (*ContractualRulesLicenseAttribution, bool)
	AsContractualRulesLinkAttribution() (*ContractualRulesLinkAttribution, bool)
	AsContractualRulesMediaAttribution() (*ContractualRulesMediaAttribution, bool)
	AsContractualRulesTextAttribution() (*ContractualRulesTextAttribution, bool)
	AsContractualRulesContractualRule() (*ContractualRulesContractualRule, bool)
}

// ContractualRulesContractualRule
type ContractualRulesContractualRule struct {
	// TargetPropertyName - The name of the field that the rule applies to.
	TargetPropertyName *string `json:"targetPropertyName,omitempty"`
	// Type - Possible values include: 'TypeContractualRulesContractualRule', 'TypeContractualRulesAttribution', 'TypeContractualRulesLicenseAttribution', 'TypeContractualRulesLinkAttribution', 'TypeContractualRulesMediaAttribution', 'TypeContractualRulesTextAttribution'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicContractualRulesContractualRule(body []byte) (BasicContractualRulesContractualRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeContractualRulesAttribution):
		var cra ContractualRulesAttribution
		err := json.Unmarshal(body, &cra)
		return cra, err
	case string(TypeContractualRulesLicenseAttribution):
		var crla ContractualRulesLicenseAttribution
		err := json.Unmarshal(body, &crla)
		return crla, err
	case string(TypeContractualRulesLinkAttribution):
		var crla ContractualRulesLinkAttribution
		err := json.Unmarshal(body, &crla)
		return crla, err
	case string(TypeContractualRulesMediaAttribution):
		var crma ContractualRulesMediaAttribution
		err := json.Unmarshal(body, &crma)
		return crma, err
	case string(TypeContractualRulesTextAttribution):
		var crta ContractualRulesTextAttribution
		err := json.Unmarshal(body, &crta)
		return crta, err
	default:
		var crcr ContractualRulesContractualRule
		err := json.Unmarshal(body, &crcr)
		return crcr, err
	}
}
func unmarshalBasicContractualRulesContractualRuleArray(body []byte) ([]BasicContractualRulesContractualRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	crcrArray := make([]BasicContractualRulesContractualRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		crcr, err := unmarshalBasicContractualRulesContractualRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		crcrArray[index] = crcr
	}
	return crcrArray, nil
}

// MarshalJSON is the custom marshaler for ContractualRulesContractualRule.
func (crcr ContractualRulesContractualRule) MarshalJSON() ([]byte, error) {
	crcr.Type = TypeContractualRulesContractualRule
	type Alias ContractualRulesContractualRule
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(crcr),
	})
}

// AsContractualRulesAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesContractualRule.
func (crcr ContractualRulesContractualRule) AsContractualRulesAttribution() (*ContractualRulesAttribution, bool) {
	return nil, false
}

// AsBasicContractualRulesAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesContractualRule.
func (crcr ContractualRulesContractualRule) AsBasicContractualRulesAttribution() (BasicContractualRulesAttribution, bool) {
	return nil, false
}

// AsContractualRulesLicenseAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesContractualRule.
func (crcr ContractualRulesContractualRule) AsContractualRulesLicenseAttribution() (*ContractualRulesLicenseAttribution, bool) {
	return nil, false
}

// AsContractualRulesLinkAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesContractualRule.
func (crcr ContractualRulesContractualRule) AsContractualRulesLinkAttribution() (*ContractualRulesLinkAttribution, bool) {
	return nil, false
}

// AsContractualRulesMediaAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesContractualRule.
func (crcr ContractualRulesContractualRule) AsContractualRulesMediaAttribution() (*ContractualRulesMediaAttribution, bool) {
	return nil, false
}

// AsContractualRulesTextAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesContractualRule.
func (crcr ContractualRulesContractualRule) AsContractualRulesTextAttribution() (*ContractualRulesTextAttribution, bool) {
	return nil, false
}

// AsContractualRulesContractualRule is the BasicContractualRulesContractualRule implementation for ContractualRulesContractualRule.
func (crcr ContractualRulesContractualRule) AsContractualRulesContractualRule() (*ContractualRulesContractualRule, bool) {
	return &crcr, true
}

// AsBasicContractualRulesContractualRule is the BasicContractualRulesContractualRule implementation for ContractualRulesContractualRule.
func (crcr ContractualRulesContractualRule) AsBasicContractualRulesContractualRule() (BasicContractualRulesContractualRule, bool) {
	return &crcr, true
}

// ContractualRulesLicenseAttribution defines a contractual rule for license attribution.
type ContractualRulesLicenseAttribution struct {
	// TargetPropertyName - The name of the field that the rule applies to.
	TargetPropertyName *string `json:"targetPropertyName,omitempty"`
	// Type - Possible values include: 'TypeContractualRulesContractualRule', 'TypeContractualRulesAttribution', 'TypeContractualRulesLicenseAttribution', 'TypeContractualRulesLinkAttribution', 'TypeContractualRulesMediaAttribution', 'TypeContractualRulesTextAttribution'
	Type Type `json:"_type,omitempty"`
	// MustBeCloseToContent - A Boolean value that determines whether the contents of the rule must be placed in close proximity to the field that the rule applies to. If true, the contents must be placed in close proximity. If false, or this field does not exist, the contents may be placed at the caller's discretion.
	MustBeCloseToContent *bool `json:"mustBeCloseToContent,omitempty"`
	// License - The license under which the content may be used.
	License *License `json:"license,omitempty"`
	// LicenseNotice - The license to display next to the targeted field.
	LicenseNotice *string `json:"licenseNotice,omitempty"`
}

// MarshalJSON is the custom marshaler for ContractualRulesLicenseAttribution.
func (crla ContractualRulesLicenseAttribution) MarshalJSON() ([]byte, error) {
	crla.Type = TypeContractualRulesLicenseAttribution
	type Alias ContractualRulesLicenseAttribution
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(crla),
	})
}

// AsContractualRulesAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesLicenseAttribution.
func (crla ContractualRulesLicenseAttribution) AsContractualRulesAttribution() (*ContractualRulesAttribution, bool) {
	return nil, false
}

// AsBasicContractualRulesAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesLicenseAttribution.
func (crla ContractualRulesLicenseAttribution) AsBasicContractualRulesAttribution() (BasicContractualRulesAttribution, bool) {
	return &crla, true
}

// AsContractualRulesLicenseAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesLicenseAttribution.
func (crla ContractualRulesLicenseAttribution) AsContractualRulesLicenseAttribution() (*ContractualRulesLicenseAttribution, bool) {
	return &crla, true
}

// AsContractualRulesLinkAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesLicenseAttribution.
func (crla ContractualRulesLicenseAttribution) AsContractualRulesLinkAttribution() (*ContractualRulesLinkAttribution, bool) {
	return nil, false
}

// AsContractualRulesMediaAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesLicenseAttribution.
func (crla ContractualRulesLicenseAttribution) AsContractualRulesMediaAttribution() (*ContractualRulesMediaAttribution, bool) {
	return nil, false
}

// AsContractualRulesTextAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesLicenseAttribution.
func (crla ContractualRulesLicenseAttribution) AsContractualRulesTextAttribution() (*ContractualRulesTextAttribution, bool) {
	return nil, false
}

// AsContractualRulesContractualRule is the BasicContractualRulesContractualRule implementation for ContractualRulesLicenseAttribution.
func (crla ContractualRulesLicenseAttribution) AsContractualRulesContractualRule() (*ContractualRulesContractualRule, bool) {
	return nil, false
}

// AsBasicContractualRulesContractualRule is the BasicContractualRulesContractualRule implementation for ContractualRulesLicenseAttribution.
func (crla ContractualRulesLicenseAttribution) AsBasicContractualRulesContractualRule() (BasicContractualRulesContractualRule, bool) {
	return &crla, true
}

// ContractualRulesLinkAttribution defines a contractual rule for link attribution.
type ContractualRulesLinkAttribution struct {
	// TargetPropertyName - The name of the field that the rule applies to.
	TargetPropertyName *string `json:"targetPropertyName,omitempty"`
	// Type - Possible values include: 'TypeContractualRulesContractualRule', 'TypeContractualRulesAttribution', 'TypeContractualRulesLicenseAttribution', 'TypeContractualRulesLinkAttribution', 'TypeContractualRulesMediaAttribution', 'TypeContractualRulesTextAttribution'
	Type Type `json:"_type,omitempty"`
	// MustBeCloseToContent - A Boolean value that determines whether the contents of the rule must be placed in close proximity to the field that the rule applies to. If true, the contents must be placed in close proximity. If false, or this field does not exist, the contents may be placed at the caller's discretion.
	MustBeCloseToContent *bool `json:"mustBeCloseToContent,omitempty"`
	// Text - The attribution text.
	Text *string `json:"text,omitempty"`
	// URL - The URL to the provider's website. Use text and URL to create the hyperlink.
	URL *string `json:"url,omitempty"`
	// OptionalForListDisplay - Indicates whether this provider's attribution is optional.
	OptionalForListDisplay *bool `json:"optionalForListDisplay,omitempty"`
}

// MarshalJSON is the custom marshaler for ContractualRulesLinkAttribution.
func (crla ContractualRulesLinkAttribution) MarshalJSON() ([]byte, error) {
	crla.Type = TypeContractualRulesLinkAttribution
	type Alias ContractualRulesLinkAttribution
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(crla),
	})
}

// AsContractualRulesAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesLinkAttribution.
func (crla ContractualRulesLinkAttribution) AsContractualRulesAttribution() (*ContractualRulesAttribution, bool) {
	return nil, false
}

// AsBasicContractualRulesAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesLinkAttribution.
func (crla ContractualRulesLinkAttribution) AsBasicContractualRulesAttribution() (BasicContractualRulesAttribution, bool) {
	return &crla, true
}

// AsContractualRulesLicenseAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesLinkAttribution.
func (crla ContractualRulesLinkAttribution) AsContractualRulesLicenseAttribution() (*ContractualRulesLicenseAttribution, bool) {
	return nil, false
}

// AsContractualRulesLinkAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesLinkAttribution.
func (crla ContractualRulesLinkAttribution) AsContractualRulesLinkAttribution() (*ContractualRulesLinkAttribution, bool) {
	return &crla, true
}

// AsContractualRulesMediaAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesLinkAttribution.
func (crla ContractualRulesLinkAttribution) AsContractualRulesMediaAttribution() (*ContractualRulesMediaAttribution, bool) {
	return nil, false
}

// AsContractualRulesTextAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesLinkAttribution.
func (crla ContractualRulesLinkAttribution) AsContractualRulesTextAttribution() (*ContractualRulesTextAttribution, bool) {
	return nil, false
}

// AsContractualRulesContractualRule is the BasicContractualRulesContractualRule implementation for ContractualRulesLinkAttribution.
func (crla ContractualRulesLinkAttribution) AsContractualRulesContractualRule() (*ContractualRulesContractualRule, bool) {
	return nil, false
}

// AsBasicContractualRulesContractualRule is the BasicContractualRulesContractualRule implementation for ContractualRulesLinkAttribution.
func (crla ContractualRulesLinkAttribution) AsBasicContractualRulesContractualRule() (BasicContractualRulesContractualRule, bool) {
	return &crla, true
}

// ContractualRulesMediaAttribution defines a contractual rule for media attribution.
type ContractualRulesMediaAttribution struct {
	// TargetPropertyName - The name of the field that the rule applies to.
	TargetPropertyName *string `json:"targetPropertyName,omitempty"`
	// Type - Possible values include: 'TypeContractualRulesContractualRule', 'TypeContractualRulesAttribution', 'TypeContractualRulesLicenseAttribution', 'TypeContractualRulesLinkAttribution', 'TypeContractualRulesMediaAttribution', 'TypeContractualRulesTextAttribution'
	Type Type `json:"_type,omitempty"`
	// MustBeCloseToContent - A Boolean value that determines whether the contents of the rule must be placed in close proximity to the field that the rule applies to. If true, the contents must be placed in close proximity. If false, or this field does not exist, the contents may be placed at the caller's discretion.
	MustBeCloseToContent *bool `json:"mustBeCloseToContent,omitempty"`
	// URL - The URL that you use to create of hyperlink of the media content. For example, if the target is an image, you would use the URL to make the image clickable.
	URL *string `json:"url,omitempty"`
}

// MarshalJSON is the custom marshaler for ContractualRulesMediaAttribution.
func (crma ContractualRulesMediaAttribution) MarshalJSON() ([]byte, error) {
	crma.Type = TypeContractualRulesMediaAttribution
	type Alias ContractualRulesMediaAttribution
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(crma),
	})
}

// AsContractualRulesAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesMediaAttribution.
func (crma ContractualRulesMediaAttribution) AsContractualRulesAttribution() (*ContractualRulesAttribution, bool) {
	return nil, false
}

// AsBasicContractualRulesAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesMediaAttribution.
func (crma ContractualRulesMediaAttribution) AsBasicContractualRulesAttribution() (BasicContractualRulesAttribution, bool) {
	return &crma, true
}

// AsContractualRulesLicenseAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesMediaAttribution.
func (crma ContractualRulesMediaAttribution) AsContractualRulesLicenseAttribution() (*ContractualRulesLicenseAttribution, bool) {
	return nil, false
}

// AsContractualRulesLinkAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesMediaAttribution.
func (crma ContractualRulesMediaAttribution) AsContractualRulesLinkAttribution() (*ContractualRulesLinkAttribution, bool) {
	return nil, false
}

// AsContractualRulesMediaAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesMediaAttribution.
func (crma ContractualRulesMediaAttribution) AsContractualRulesMediaAttribution() (*ContractualRulesMediaAttribution, bool) {
	return &crma, true
}

// AsContractualRulesTextAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesMediaAttribution.
func (crma ContractualRulesMediaAttribution) AsContractualRulesTextAttribution() (*ContractualRulesTextAttribution, bool) {
	return nil, false
}

// AsContractualRulesContractualRule is the BasicContractualRulesContractualRule implementation for ContractualRulesMediaAttribution.
func (crma ContractualRulesMediaAttribution) AsContractualRulesContractualRule() (*ContractualRulesContractualRule, bool) {
	return nil, false
}

// AsBasicContractualRulesContractualRule is the BasicContractualRulesContractualRule implementation for ContractualRulesMediaAttribution.
func (crma ContractualRulesMediaAttribution) AsBasicContractualRulesContractualRule() (BasicContractualRulesContractualRule, bool) {
	return &crma, true
}

// ContractualRulesTextAttribution defines a contractual rule for text attribution.
type ContractualRulesTextAttribution struct {
	// TargetPropertyName - The name of the field that the rule applies to.
	TargetPropertyName *string `json:"targetPropertyName,omitempty"`
	// Type - Possible values include: 'TypeContractualRulesContractualRule', 'TypeContractualRulesAttribution', 'TypeContractualRulesLicenseAttribution', 'TypeContractualRulesLinkAttribution', 'TypeContractualRulesMediaAttribution', 'TypeContractualRulesTextAttribution'
	Type Type `json:"_type,omitempty"`
	// MustBeCloseToContent - A Boolean value that determines whether the contents of the rule must be placed in close proximity to the field that the rule applies to. If true, the contents must be placed in close proximity. If false, or this field does not exist, the contents may be placed at the caller's discretion.
	MustBeCloseToContent *bool `json:"mustBeCloseToContent,omitempty"`
	// Text - The attribution text. Text attribution applies to the entity as a whole and should be displayed immediately following the entity presentation. If there are multiple text or link attribution rules that do not specify a target, you should concatenate them and display them using a "Data from:" label.
	Text *string `json:"text,omitempty"`
	// OptionalForListDisplay - Indicates whether this provider's attribution is optional.
	OptionalForListDisplay *bool `json:"optionalForListDisplay,omitempty"`
}

// MarshalJSON is the custom marshaler for ContractualRulesTextAttribution.
func (crta ContractualRulesTextAttribution) MarshalJSON() ([]byte, error) {
	crta.Type = TypeContractualRulesTextAttribution
	type Alias ContractualRulesTextAttribution
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(crta),
	})
}

// AsContractualRulesAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesTextAttribution.
func (crta ContractualRulesTextAttribution) AsContractualRulesAttribution() (*ContractualRulesAttribution, bool) {
	return nil, false
}

// AsBasicContractualRulesAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesTextAttribution.
func (crta ContractualRulesTextAttribution) AsBasicContractualRulesAttribution() (BasicContractualRulesAttribution, bool) {
	return &crta, true
}

// AsContractualRulesLicenseAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesTextAttribution.
func (crta ContractualRulesTextAttribution) AsContractualRulesLicenseAttribution() (*ContractualRulesLicenseAttribution, bool) {
	return nil, false
}

// AsContractualRulesLinkAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesTextAttribution.
func (crta ContractualRulesTextAttribution) AsContractualRulesLinkAttribution() (*ContractualRulesLinkAttribution, bool) {
	return nil, false
}

// AsContractualRulesMediaAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesTextAttribution.
func (crta ContractualRulesTextAttribution) AsContractualRulesMediaAttribution() (*ContractualRulesMediaAttribution, bool) {
	return nil, false
}

// AsContractualRulesTextAttribution is the BasicContractualRulesContractualRule implementation for ContractualRulesTextAttribution.
func (crta ContractualRulesTextAttribution) AsContractualRulesTextAttribution() (*ContractualRulesTextAttribution, bool) {
	return &crta, true
}

// AsContractualRulesContractualRule is the BasicContractualRulesContractualRule implementation for ContractualRulesTextAttribution.
func (crta ContractualRulesTextAttribution) AsContractualRulesContractualRule() (*ContractualRulesContractualRule, bool) {
	return nil, false
}

// AsBasicContractualRulesContractualRule is the BasicContractualRulesContractualRule implementation for ContractualRulesTextAttribution.
func (crta ContractualRulesTextAttribution) AsBasicContractualRulesContractualRule() (BasicContractualRulesContractualRule, bool) {
	return &crta, true
}

// BasicCreativeWork
type BasicCreativeWork interface {
	AsImageObject() (*ImageObject, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsLicense() (*License, bool)
	AsCreativeWork() (*CreativeWork, bool)
}

// CreativeWork
type CreativeWork struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Text     *string       `json:"text,omitempty"`
}

func unmarshalBasicCreativeWork(body []byte) (BasicCreativeWork, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeLicense):
		var l License
		err := json.Unmarshal(body, &l)
		return l, err
	default:
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	}
}
func unmarshalBasicCreativeWorkArray(body []byte) ([]BasicCreativeWork, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cwArray := make([]BasicCreativeWork, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cw, err := unmarshalBasicCreativeWork(*rawMessage)
		if err != nil {
			return nil, err
		}
		cwArray[index] = cw
	}
	return cwArray, nil
}

// MarshalJSON is the custom marshaler for CreativeWork.
func (cw CreativeWork) MarshalJSON() ([]byte, error) {
	cw.Type = TypeCreativeWork
	type Alias CreativeWork
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cw),
	})
}

// AsImageObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicThing() (BasicThing, bool) {
	return &cw, true
}

// AsEntities is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponse() (BasicResponse, bool) {
	return &cw, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &cw, true
}

// AsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicPlace() (BasicPlace, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsCreativeWork() (*CreativeWork, bool) {
	return &cw, true
}

// AsBasicCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &cw, true
}

// AsIntangible is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &cw, true
}

// UnmarshalJSON is the custom unmarshaler for CreativeWork struct.
func (cw *CreativeWork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		cw.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		cw.Provider = &provider
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		cw.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		cw.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		cw.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		cw.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		cw.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		cw.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		cw.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		cw.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		cw.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		cw.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		cw.Type = _type
	}

	return nil
}

// BasicEntertainmentBusiness
type BasicEntertainmentBusiness interface {
	AsMovieTheater() (*MovieTheater, bool)
	AsEntertainmentBusiness() (*EntertainmentBusiness, bool)
}

// EntertainmentBusiness
type EntertainmentBusiness struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// Address - The postal address of where the entity is located
	Address *PostalAddress `json:"address,omitempty"`
	// Telephone - The entity's telephone number
	Telephone *string `json:"telephone,omitempty"`
	// PriceRange - $$.
	PriceRange          *string        `json:"priceRange,omitempty"`
	Panoramas           *[]ImageObject `json:"panoramas,omitempty"`
	IsPermanentlyClosed *bool          `json:"isPermanentlyClosed,omitempty"`
	TagLine             *string        `json:"tagLine,omitempty"`
}

func unmarshalBasicEntertainmentBusiness(body []byte) (BasicEntertainmentBusiness, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeMovieTheater):
		var mt MovieTheater
		err := json.Unmarshal(body, &mt)
		return mt, err
	default:
		var eb EntertainmentBusiness
		err := json.Unmarshal(body, &eb)
		return eb, err
	}
}
func unmarshalBasicEntertainmentBusinessArray(body []byte) ([]BasicEntertainmentBusiness, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ebArray := make([]BasicEntertainmentBusiness, len(rawMessages))

	for index, rawMessage := range rawMessages {
		eb, err := unmarshalBasicEntertainmentBusiness(*rawMessage)
		if err != nil {
			return nil, err
		}
		ebArray[index] = eb
	}
	return ebArray, nil
}

// MarshalJSON is the custom marshaler for EntertainmentBusiness.
func (eb EntertainmentBusiness) MarshalJSON() ([]byte, error) {
	eb.Type = TypeEntertainmentBusiness
	type Alias EntertainmentBusiness
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(eb),
	})
}

// AsImageObject is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsBasicThing() (BasicThing, bool) {
	return &eb, true
}

// AsEntities is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsBasicResponse() (BasicResponse, bool) {
	return &eb, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &eb, true
}

// AsAnswer is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsBasicPlace() (BasicPlace, bool) {
	return &eb, true
}

// AsOrganization is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return &eb, true
}

// AsTouristAttraction is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return &eb, true
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return &eb, true
}

// AsFoodEstablishment is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for EntertainmentBusiness.
func (eb EntertainmentBusiness) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &eb, true
}

// UnmarshalJSON is the custom unmarshaler for EntertainmentBusiness struct.
func (eb *EntertainmentBusiness) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["priceRange"]
	if v != nil {
		var priceRange string
		err = json.Unmarshal(*m["priceRange"], &priceRange)
		if err != nil {
			return err
		}
		eb.PriceRange = &priceRange
	}

	v = m["panoramas"]
	if v != nil {
		var panoramas []ImageObject
		err = json.Unmarshal(*m["panoramas"], &panoramas)
		if err != nil {
			return err
		}
		eb.Panoramas = &panoramas
	}

	v = m["isPermanentlyClosed"]
	if v != nil {
		var isPermanentlyClosed bool
		err = json.Unmarshal(*m["isPermanentlyClosed"], &isPermanentlyClosed)
		if err != nil {
			return err
		}
		eb.IsPermanentlyClosed = &isPermanentlyClosed
	}

	v = m["tagLine"]
	if v != nil {
		var tagLine string
		err = json.Unmarshal(*m["tagLine"], &tagLine)
		if err != nil {
			return err
		}
		eb.TagLine = &tagLine
	}

	v = m["address"]
	if v != nil {
		var address PostalAddress
		err = json.Unmarshal(*m["address"], &address)
		if err != nil {
			return err
		}
		eb.Address = &address
	}

	v = m["telephone"]
	if v != nil {
		var telephone string
		err = json.Unmarshal(*m["telephone"], &telephone)
		if err != nil {
			return err
		}
		eb.Telephone = &telephone
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		eb.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		eb.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		eb.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		eb.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		eb.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		eb.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		eb.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		eb.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		eb.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		eb.Type = _type
	}

	return nil
}

// Entities defines an entity answer.
type Entities struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string       `json:"webSearchUrl,omitempty"`
	QueryContext *QueryContext `json:"queryContext,omitempty"`
	// QueryScenario - The supported query scenario. This field is set to DominantEntity or DisambiguationItem. The field is set to DominantEntity if Bing determines that only a single entity satisfies the request. For example, a book, movie, person, or attraction. If multiple entities could satisfy the request, the field is set to DisambiguationItem. For example, if the request uses the generic title of a movie franchise, the entity's type would likely be DisambiguationItem. But, if the request specifies a specific title from the franchise, the entity's type would likely be DominantEntity. Possible values include: 'DominantEntity', 'DominantEntityWithDisambiguation', 'Disambiguation', 'List', 'ListWithPivot'
	QueryScenario EntityQueryScenario `json:"queryScenario,omitempty"`
	// Value - A list of entities.
	Value *[]BasicThing `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for Entities.
func (e Entities) MarshalJSON() ([]byte, error) {
	e.Type = TypeEntities
	type Alias Entities
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(e),
	})
}

// AsImageObject is the BasicResponseBase implementation for Entities.
func (e Entities) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Entities.
func (e Entities) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Entities.
func (e Entities) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsEntities is the BasicResponseBase implementation for Entities.
func (e Entities) AsEntities() (*Entities, bool) {
	return &e, true
}

// AsPlaces is the BasicResponseBase implementation for Entities.
func (e Entities) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Entities.
func (e Entities) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Entities.
func (e Entities) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Entities.
func (e Entities) AsBasicResponse() (BasicResponse, bool) {
	return &e, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Entities.
func (e Entities) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Entities.
func (e Entities) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &e, true
}

// AsIdentifiable is the BasicResponseBase implementation for Entities.
func (e Entities) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Entities.
func (e Entities) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &e, true
}

// AsAnswer is the BasicResponseBase implementation for Entities.
func (e Entities) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Entities.
func (e Entities) AsBasicAnswer() (BasicAnswer, bool) {
	return &e, true
}

// AsErrorResponse is the BasicResponseBase implementation for Entities.
func (e Entities) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Entities.
func (e Entities) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Entities.
func (e Entities) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for Entities.
func (e Entities) AsBasicPlace() (BasicPlace, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Entities.
func (e Entities) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Entities.
func (e Entities) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Entities.
func (e Entities) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Entities.
func (e Entities) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Entities.
func (e Entities) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for Entities.
func (e Entities) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Entities.
func (e Entities) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Entities.
func (e Entities) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for Entities.
func (e Entities) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for Entities.
func (e Entities) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for Entities.
func (e Entities) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for Entities.
func (e Entities) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for Entities.
func (e Entities) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for Entities.
func (e Entities) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for Entities.
func (e Entities) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Entities.
func (e Entities) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Entities.
func (e Entities) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for Entities.
func (e Entities) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for Entities.
func (e Entities) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for Entities.
func (e Entities) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for Entities.
func (e Entities) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for Entities.
func (e Entities) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for Entities.
func (e Entities) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for Entities.
func (e Entities) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for Entities.
func (e Entities) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Entities.
func (e Entities) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Entities.
func (e Entities) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &e, true
}

// UnmarshalJSON is the custom unmarshaler for Entities struct.
func (e *Entities) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["queryScenario"]
	if v != nil {
		var queryScenario EntityQueryScenario
		err = json.Unmarshal(*m["queryScenario"], &queryScenario)
		if err != nil {
			return err
		}
		e.QueryScenario = queryScenario
	}

	v = m["value"]
	if v != nil {
		value, err := unmarshalBasicThingArray(*m["value"])
		if err != nil {
			return err
		}
		e.Value = &value
	}

	v = m["queryContext"]
	if v != nil {
		var queryContext QueryContext
		err = json.Unmarshal(*m["queryContext"], &queryContext)
		if err != nil {
			return err
		}
		e.QueryContext = &queryContext
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		e.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		e.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		e.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		e.Type = _type
	}

	return nil
}

// EntitiesEntityPresentationInfo defines additional information about an entity such as type hints.
type EntitiesEntityPresentationInfo struct {
	// EntityScenario - The supported scenario. Possible values include: 'EntityScenarioDominantEntity', 'EntityScenarioDisambiguationItem', 'EntityScenarioListItem'
	EntityScenario EntityScenario `json:"entityScenario,omitempty"`
	// EntityTypeHints - A list of hints that indicate the entity's type. The list could contain a single hint such as Movie or a list of hints such as Place, LocalBusiness, Restaurant. Each successive hint in the array narrows the entity's type.
	EntityTypeHints *[]EntityType `json:"entityTypeHints,omitempty"`
	// EntityTypeDisplayHint - A display version of the entity hint. For example, if entityTypeHints is Artist, this field may be set to American Singer.
	EntityTypeDisplayHint *string `json:"entityTypeDisplayHint,omitempty"`
}

// Error defines the error that occurred.
type Error struct {
	// Code - The error code that identifies the category of error. Possible values include: 'None', 'ServerError', 'InvalidRequest', 'RateLimitExceeded', 'InvalidAuthorization', 'InsufficientAuthorization'
	Code ErrorCode `json:"code,omitempty"`
	// SubCode - The error code that further helps to identify the error. Possible values include: 'UnexpectedError', 'ResourceError', 'NotImplemented', 'ParameterMissing', 'ParameterInvalidValue', 'HTTPNotAllowed', 'Blocked', 'AuthorizationMissing', 'AuthorizationRedundancy', 'AuthorizationDisabled', 'AuthorizationExpired'
	SubCode ErrorSubCode `json:"subCode,omitempty"`
	// Message - A description of the error.
	Message *string `json:"message,omitempty"`
	// MoreDetails - A description that provides additional information about the error.
	MoreDetails *string `json:"moreDetails,omitempty"`
	// Parameter - The parameter in the request that caused the error.
	Parameter *string `json:"parameter,omitempty"`
	// Value - The parameter's value in the request that was not valid.
	Value *string `json:"value,omitempty"`
}

// ErrorResponse the top-level response that represents a failed request.
type ErrorResponse struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Errors - A list of errors that describe the reasons why the request failed.
	Errors *[]Error `json:"errors,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	er.Type = TypeErrorResponse
	type Alias ErrorResponse
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(er),
	})
}

// AsImageObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsEntities is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponse() (BasicResponse, bool) {
	return &er, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &er, true
}

// AsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsErrorResponse() (*ErrorResponse, bool) {
	return &er, true
}

// AsPostalAddress is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicPlace() (BasicPlace, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &er, true
}

// UnmarshalJSON is the custom unmarshaler for ErrorResponse struct.
func (er *ErrorResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["errors"]
	if v != nil {
		var errorsVar []Error
		err = json.Unmarshal(*m["errors"], &errorsVar)
		if err != nil {
			return err
		}
		er.Errors = &errorsVar
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		er.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		er.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		er.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		er.Type = _type
	}

	return nil
}

// BasicFoodEstablishment
type BasicFoodEstablishment interface {
	AsRestaurant() (*Restaurant, bool)
	AsFoodEstablishment() (*FoodEstablishment, bool)
}

// FoodEstablishment
type FoodEstablishment struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// Address - The postal address of where the entity is located
	Address *PostalAddress `json:"address,omitempty"`
	// Telephone - The entity's telephone number
	Telephone *string `json:"telephone,omitempty"`
	// PriceRange - $$.
	PriceRange          *string        `json:"priceRange,omitempty"`
	Panoramas           *[]ImageObject `json:"panoramas,omitempty"`
	IsPermanentlyClosed *bool          `json:"isPermanentlyClosed,omitempty"`
	TagLine             *string        `json:"tagLine,omitempty"`
}

func unmarshalBasicFoodEstablishment(body []byte) (BasicFoodEstablishment, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeRestaurant):
		var r Restaurant
		err := json.Unmarshal(body, &r)
		return r, err
	default:
		var fe FoodEstablishment
		err := json.Unmarshal(body, &fe)
		return fe, err
	}
}
func unmarshalBasicFoodEstablishmentArray(body []byte) ([]BasicFoodEstablishment, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	feArray := make([]BasicFoodEstablishment, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fe, err := unmarshalBasicFoodEstablishment(*rawMessage)
		if err != nil {
			return nil, err
		}
		feArray[index] = fe
	}
	return feArray, nil
}

// MarshalJSON is the custom marshaler for FoodEstablishment.
func (fe FoodEstablishment) MarshalJSON() ([]byte, error) {
	fe.Type = TypeFoodEstablishment
	type Alias FoodEstablishment
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(fe),
	})
}

// AsImageObject is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsBasicThing() (BasicThing, bool) {
	return &fe, true
}

// AsEntities is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsBasicResponse() (BasicResponse, bool) {
	return &fe, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &fe, true
}

// AsAnswer is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsBasicPlace() (BasicPlace, bool) {
	return &fe, true
}

// AsOrganization is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return &fe, true
}

// AsTouristAttraction is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return &fe, true
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return &fe, true
}

// AsLodgingBusiness is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for FoodEstablishment.
func (fe FoodEstablishment) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &fe, true
}

// UnmarshalJSON is the custom unmarshaler for FoodEstablishment struct.
func (fe *FoodEstablishment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["priceRange"]
	if v != nil {
		var priceRange string
		err = json.Unmarshal(*m["priceRange"], &priceRange)
		if err != nil {
			return err
		}
		fe.PriceRange = &priceRange
	}

	v = m["panoramas"]
	if v != nil {
		var panoramas []ImageObject
		err = json.Unmarshal(*m["panoramas"], &panoramas)
		if err != nil {
			return err
		}
		fe.Panoramas = &panoramas
	}

	v = m["isPermanentlyClosed"]
	if v != nil {
		var isPermanentlyClosed bool
		err = json.Unmarshal(*m["isPermanentlyClosed"], &isPermanentlyClosed)
		if err != nil {
			return err
		}
		fe.IsPermanentlyClosed = &isPermanentlyClosed
	}

	v = m["tagLine"]
	if v != nil {
		var tagLine string
		err = json.Unmarshal(*m["tagLine"], &tagLine)
		if err != nil {
			return err
		}
		fe.TagLine = &tagLine
	}

	v = m["address"]
	if v != nil {
		var address PostalAddress
		err = json.Unmarshal(*m["address"], &address)
		if err != nil {
			return err
		}
		fe.Address = &address
	}

	v = m["telephone"]
	if v != nil {
		var telephone string
		err = json.Unmarshal(*m["telephone"], &telephone)
		if err != nil {
			return err
		}
		fe.Telephone = &telephone
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		fe.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		fe.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		fe.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		fe.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		fe.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		fe.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		fe.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		fe.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		fe.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		fe.Type = _type
	}

	return nil
}

// Hotel ...
type Hotel struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// Address - The postal address of where the entity is located
	Address *PostalAddress `json:"address,omitempty"`
	// Telephone - The entity's telephone number
	Telephone *string `json:"telephone,omitempty"`
	// PriceRange - $$.
	PriceRange          *string        `json:"priceRange,omitempty"`
	Panoramas           *[]ImageObject `json:"panoramas,omitempty"`
	IsPermanentlyClosed *bool          `json:"isPermanentlyClosed,omitempty"`
	TagLine             *string        `json:"tagLine,omitempty"`
	HotelClass          *string        `json:"hotelClass,omitempty"`
	Amenities           *[]string      `json:"amenities,omitempty"`
}

// MarshalJSON is the custom marshaler for Hotel.
func (h Hotel) MarshalJSON() ([]byte, error) {
	h.Type = TypeHotel
	type Alias Hotel
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(h),
	})
}

// AsImageObject is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsBasicThing() (BasicThing, bool) {
	return &h, true
}

// AsEntities is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsBasicResponse() (BasicResponse, bool) {
	return &h, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &h, true
}

// AsAnswer is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsBasicPlace() (BasicPlace, bool) {
	return &h, true
}

// AsOrganization is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return &h, true
}

// AsTouristAttraction is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return &h, true
}

// AsRestaurant is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsHotel() (*Hotel, bool) {
	return &h, true
}

// AsResponseBase is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Hotel.
func (h Hotel) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &h, true
}

// UnmarshalJSON is the custom unmarshaler for Hotel struct.
func (h *Hotel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["hotelClass"]
	if v != nil {
		var hotelClass string
		err = json.Unmarshal(*m["hotelClass"], &hotelClass)
		if err != nil {
			return err
		}
		h.HotelClass = &hotelClass
	}

	v = m["amenities"]
	if v != nil {
		var amenities []string
		err = json.Unmarshal(*m["amenities"], &amenities)
		if err != nil {
			return err
		}
		h.Amenities = &amenities
	}

	v = m["priceRange"]
	if v != nil {
		var priceRange string
		err = json.Unmarshal(*m["priceRange"], &priceRange)
		if err != nil {
			return err
		}
		h.PriceRange = &priceRange
	}

	v = m["panoramas"]
	if v != nil {
		var panoramas []ImageObject
		err = json.Unmarshal(*m["panoramas"], &panoramas)
		if err != nil {
			return err
		}
		h.Panoramas = &panoramas
	}

	v = m["isPermanentlyClosed"]
	if v != nil {
		var isPermanentlyClosed bool
		err = json.Unmarshal(*m["isPermanentlyClosed"], &isPermanentlyClosed)
		if err != nil {
			return err
		}
		h.IsPermanentlyClosed = &isPermanentlyClosed
	}

	v = m["tagLine"]
	if v != nil {
		var tagLine string
		err = json.Unmarshal(*m["tagLine"], &tagLine)
		if err != nil {
			return err
		}
		h.TagLine = &tagLine
	}

	v = m["address"]
	if v != nil {
		var address PostalAddress
		err = json.Unmarshal(*m["address"], &address)
		if err != nil {
			return err
		}
		h.Address = &address
	}

	v = m["telephone"]
	if v != nil {
		var telephone string
		err = json.Unmarshal(*m["telephone"], &telephone)
		if err != nil {
			return err
		}
		h.Telephone = &telephone
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		h.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		h.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		h.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		h.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		h.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		h.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		h.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		h.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		h.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		h.Type = _type
	}

	return nil
}

// BasicIdentifiable defines the identity of a resource.
type BasicIdentifiable interface {
	AsImageObject() (*ImageObject, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsEntities() (*Entities, bool)
	AsPlaces() (*Places, bool)
	AsSearchResponse() (*SearchResponse, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsPostalAddress() (*PostalAddress, bool)
	AsPlace() (*Place, bool)
	AsBasicPlace() (BasicPlace, bool)
	AsOrganization() (*Organization, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsMovieTheater() (*MovieTheater, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsCivicStructure() (*CivicStructure, bool)
	AsBasicCivicStructure() (BasicCivicStructure, bool)
	AsLocalBusiness() (*LocalBusiness, bool)
	AsBasicLocalBusiness() (BasicLocalBusiness, bool)
	AsTouristAttraction() (*TouristAttraction, bool)
	AsAirport() (*Airport, bool)
	AsLicense() (*License, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsEntertainmentBusiness() (*EntertainmentBusiness, bool)
	AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool)
	AsFoodEstablishment() (*FoodEstablishment, bool)
	AsBasicFoodEstablishment() (BasicFoodEstablishment, bool)
	AsLodgingBusiness() (*LodgingBusiness, bool)
	AsBasicLodgingBusiness() (BasicLodgingBusiness, bool)
	AsRestaurant() (*Restaurant, bool)
	AsHotel() (*Hotel, bool)
	AsIdentifiable() (*Identifiable, bool)
}

// Identifiable defines the identity of a resource.
type Identifiable struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
}

func unmarshalBasicIdentifiable(body []byte) (BasicIdentifiable, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeEntities):
		var e Entities
		err := json.Unmarshal(body, &e)
		return e, err
	case string(TypePlaces):
		var p Places
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeSearchResponse):
		var sr SearchResponse
		err := json.Unmarshal(body, &sr)
		return sr, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypePostalAddress):
		var pa PostalAddress
		err := json.Unmarshal(body, &pa)
		return pa, err
	case string(TypePlace):
		var p Place
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeOrganization):
		var o Organization
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeMovieTheater):
		var mt MovieTheater
		err := json.Unmarshal(body, &mt)
		return mt, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeCivicStructure):
		var cs CivicStructure
		err := json.Unmarshal(body, &cs)
		return cs, err
	case string(TypeLocalBusiness):
		var lb LocalBusiness
		err := json.Unmarshal(body, &lb)
		return lb, err
	case string(TypeTouristAttraction):
		var ta TouristAttraction
		err := json.Unmarshal(body, &ta)
		return ta, err
	case string(TypeAirport):
		var a Airport
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeLicense):
		var l License
		err := json.Unmarshal(body, &l)
		return l, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	case string(TypeEntertainmentBusiness):
		var eb EntertainmentBusiness
		err := json.Unmarshal(body, &eb)
		return eb, err
	case string(TypeFoodEstablishment):
		var fe FoodEstablishment
		err := json.Unmarshal(body, &fe)
		return fe, err
	case string(TypeLodgingBusiness):
		var lb LodgingBusiness
		err := json.Unmarshal(body, &lb)
		return lb, err
	case string(TypeRestaurant):
		var r Restaurant
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeHotel):
		var h Hotel
		err := json.Unmarshal(body, &h)
		return h, err
	default:
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	}
}
func unmarshalBasicIdentifiableArray(body []byte) ([]BasicIdentifiable, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iArray := make([]BasicIdentifiable, len(rawMessages))

	for index, rawMessage := range rawMessages {
		i, err := unmarshalBasicIdentifiable(*rawMessage)
		if err != nil {
			return nil, err
		}
		iArray[index] = i
	}
	return iArray, nil
}

// MarshalJSON is the custom marshaler for Identifiable.
func (i Identifiable) MarshalJSON() ([]byte, error) {
	i.Type = TypeIdentifiable
	type Alias Identifiable
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(i),
	})
}

// AsImageObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsEntities is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsIdentifiable() (*Identifiable, bool) {
	return &i, true
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicPlace() (BasicPlace, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// ImageObject defines an image
type ImageObject struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Text     *string       `json:"text,omitempty"`
	// ContentURL - Original URL to retrieve the source (file) for the media object (e.g the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// HostPageURL - URL of the page that hosts the media object.
	HostPageURL *string `json:"hostPageUrl,omitempty"`
	// Width - The width of the source media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - The height of the source media object, in pixels.
	Height *int32 `json:"height,omitempty"`
	// Thumbnail - The URL to a thumbnail of the image
	Thumbnail *ImageObject `json:"thumbnail,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageObject.
func (ioVar ImageObject) MarshalJSON() ([]byte, error) {
	ioVar.Type = TypeImageObject
	type Alias ImageObject
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ioVar),
	})
}

// AsImageObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImageObject() (*ImageObject, bool) {
	return &ioVar, true
}

// AsThing is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicThing() (BasicThing, bool) {
	return &ioVar, true
}

// AsEntities is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicResponse() (BasicResponse, bool) {
	return &ioVar, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ioVar, true
}

// AsAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicPlace() (BasicPlace, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &ioVar, true
}

// AsIntangible is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &ioVar, true
}

// AsCivicStructure is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ioVar, true
}

// UnmarshalJSON is the custom unmarshaler for ImageObject struct.
func (ioVar *ImageObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["thumbnail"]
	if v != nil {
		var thumbnail ImageObject
		err = json.Unmarshal(*m["thumbnail"], &thumbnail)
		if err != nil {
			return err
		}
		ioVar.Thumbnail = &thumbnail
	}

	v = m["contentUrl"]
	if v != nil {
		var contentURL string
		err = json.Unmarshal(*m["contentUrl"], &contentURL)
		if err != nil {
			return err
		}
		ioVar.ContentURL = &contentURL
	}

	v = m["hostPageUrl"]
	if v != nil {
		var hostPageURL string
		err = json.Unmarshal(*m["hostPageUrl"], &hostPageURL)
		if err != nil {
			return err
		}
		ioVar.HostPageURL = &hostPageURL
	}

	v = m["width"]
	if v != nil {
		var width int32
		err = json.Unmarshal(*m["width"], &width)
		if err != nil {
			return err
		}
		ioVar.Width = &width
	}

	v = m["height"]
	if v != nil {
		var height int32
		err = json.Unmarshal(*m["height"], &height)
		if err != nil {
			return err
		}
		ioVar.Height = &height
	}

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		ioVar.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		ioVar.Provider = &provider
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		ioVar.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		ioVar.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		ioVar.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		ioVar.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		ioVar.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		ioVar.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		ioVar.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		ioVar.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		ioVar.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		ioVar.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		ioVar.Type = _type
	}

	return nil
}

// BasicIntangible
type BasicIntangible interface {
	AsPostalAddress() (*PostalAddress, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsIntangible() (*Intangible, bool)
}

// Intangible
type Intangible struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
}

func unmarshalBasicIntangible(body []byte) (BasicIntangible, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypePostalAddress):
		var pa PostalAddress
		err := json.Unmarshal(body, &pa)
		return pa, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	}
}
func unmarshalBasicIntangibleArray(body []byte) ([]BasicIntangible, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iArray := make([]BasicIntangible, len(rawMessages))

	for index, rawMessage := range rawMessages {
		i, err := unmarshalBasicIntangible(*rawMessage)
		if err != nil {
			return nil, err
		}
		iArray[index] = i
	}
	return iArray, nil
}

// MarshalJSON is the custom marshaler for Intangible.
func (i Intangible) MarshalJSON() ([]byte, error) {
	i.Type = TypeIntangible
	type Alias Intangible
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(i),
	})
}

// AsImageObject is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicThing() (BasicThing, bool) {
	return &i, true
}

// AsEntities is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicResponse() (BasicResponse, bool) {
	return &i, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsAnswer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicPlace() (BasicPlace, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsIntangible() (*Intangible, bool) {
	return &i, true
}

// AsBasicIntangible is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicIntangible() (BasicIntangible, bool) {
	return &i, true
}

// AsMovieTheater is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// UnmarshalJSON is the custom unmarshaler for Intangible struct.
func (i *Intangible) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		i.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		i.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		i.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		i.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		i.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		i.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		i.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		i.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		i.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		i.Type = _type
	}

	return nil
}

// License defines the license under which the text or photo may be used.
type License struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Text     *string       `json:"text,omitempty"`
}

// MarshalJSON is the custom marshaler for License.
func (l License) MarshalJSON() ([]byte, error) {
	l.Type = TypeLicense
	type Alias License
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(l),
	})
}

// AsImageObject is the BasicResponseBase implementation for License.
func (l License) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for License.
func (l License) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for License.
func (l License) AsBasicThing() (BasicThing, bool) {
	return &l, true
}

// AsEntities is the BasicResponseBase implementation for License.
func (l License) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for License.
func (l License) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for License.
func (l License) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for License.
func (l License) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for License.
func (l License) AsBasicResponse() (BasicResponse, bool) {
	return &l, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for License.
func (l License) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for License.
func (l License) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for License.
func (l License) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for License.
func (l License) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &l, true
}

// AsAnswer is the BasicResponseBase implementation for License.
func (l License) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for License.
func (l License) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for License.
func (l License) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for License.
func (l License) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for License.
func (l License) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for License.
func (l License) AsBasicPlace() (BasicPlace, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for License.
func (l License) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for License.
func (l License) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for License.
func (l License) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &l, true
}

// AsIntangible is the BasicResponseBase implementation for License.
func (l License) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for License.
func (l License) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for License.
func (l License) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for License.
func (l License) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for License.
func (l License) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for License.
func (l License) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for License.
func (l License) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for License.
func (l License) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for License.
func (l License) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for License.
func (l License) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for License.
func (l License) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for License.
func (l License) AsLicense() (*License, bool) {
	return &l, true
}

// AsStructuredValue is the BasicResponseBase implementation for License.
func (l License) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for License.
func (l License) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for License.
func (l License) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for License.
func (l License) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for License.
func (l License) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for License.
func (l License) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for License.
func (l License) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for License.
func (l License) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for License.
func (l License) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for License.
func (l License) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for License.
func (l License) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for License.
func (l License) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &l, true
}

// UnmarshalJSON is the custom unmarshaler for License struct.
func (l *License) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		l.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		l.Provider = &provider
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		l.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		l.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		l.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		l.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		l.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		l.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		l.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		l.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		l.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		l.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		l.Type = _type
	}

	return nil
}

// BasicLocalBusiness
type BasicLocalBusiness interface {
	AsMovieTheater() (*MovieTheater, bool)
	AsEntertainmentBusiness() (*EntertainmentBusiness, bool)
	AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool)
	AsFoodEstablishment() (*FoodEstablishment, bool)
	AsBasicFoodEstablishment() (BasicFoodEstablishment, bool)
	AsLodgingBusiness() (*LodgingBusiness, bool)
	AsBasicLodgingBusiness() (BasicLodgingBusiness, bool)
	AsRestaurant() (*Restaurant, bool)
	AsHotel() (*Hotel, bool)
	AsLocalBusiness() (*LocalBusiness, bool)
}

// LocalBusiness
type LocalBusiness struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// Address - The postal address of where the entity is located
	Address *PostalAddress `json:"address,omitempty"`
	// Telephone - The entity's telephone number
	Telephone *string `json:"telephone,omitempty"`
	// PriceRange - $$.
	PriceRange          *string        `json:"priceRange,omitempty"`
	Panoramas           *[]ImageObject `json:"panoramas,omitempty"`
	IsPermanentlyClosed *bool          `json:"isPermanentlyClosed,omitempty"`
	TagLine             *string        `json:"tagLine,omitempty"`
}

func unmarshalBasicLocalBusiness(body []byte) (BasicLocalBusiness, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeMovieTheater):
		var mt MovieTheater
		err := json.Unmarshal(body, &mt)
		return mt, err
	case string(TypeEntertainmentBusiness):
		var eb EntertainmentBusiness
		err := json.Unmarshal(body, &eb)
		return eb, err
	case string(TypeFoodEstablishment):
		var fe FoodEstablishment
		err := json.Unmarshal(body, &fe)
		return fe, err
	case string(TypeLodgingBusiness):
		var lb LodgingBusiness
		err := json.Unmarshal(body, &lb)
		return lb, err
	case string(TypeRestaurant):
		var r Restaurant
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeHotel):
		var h Hotel
		err := json.Unmarshal(body, &h)
		return h, err
	default:
		var lb LocalBusiness
		err := json.Unmarshal(body, &lb)
		return lb, err
	}
}
func unmarshalBasicLocalBusinessArray(body []byte) ([]BasicLocalBusiness, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	lbArray := make([]BasicLocalBusiness, len(rawMessages))

	for index, rawMessage := range rawMessages {
		lb, err := unmarshalBasicLocalBusiness(*rawMessage)
		if err != nil {
			return nil, err
		}
		lbArray[index] = lb
	}
	return lbArray, nil
}

// MarshalJSON is the custom marshaler for LocalBusiness.
func (lb LocalBusiness) MarshalJSON() ([]byte, error) {
	lb.Type = TypeLocalBusiness
	type Alias LocalBusiness
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(lb),
	})
}

// AsImageObject is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsBasicThing() (BasicThing, bool) {
	return &lb, true
}

// AsEntities is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsBasicResponse() (BasicResponse, bool) {
	return &lb, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &lb, true
}

// AsAnswer is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsBasicPlace() (BasicPlace, bool) {
	return &lb, true
}

// AsOrganization is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsLocalBusiness() (*LocalBusiness, bool) {
	return &lb, true
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return &lb, true
}

// AsTouristAttraction is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for LocalBusiness.
func (lb LocalBusiness) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &lb, true
}

// UnmarshalJSON is the custom unmarshaler for LocalBusiness struct.
func (lb *LocalBusiness) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["priceRange"]
	if v != nil {
		var priceRange string
		err = json.Unmarshal(*m["priceRange"], &priceRange)
		if err != nil {
			return err
		}
		lb.PriceRange = &priceRange
	}

	v = m["panoramas"]
	if v != nil {
		var panoramas []ImageObject
		err = json.Unmarshal(*m["panoramas"], &panoramas)
		if err != nil {
			return err
		}
		lb.Panoramas = &panoramas
	}

	v = m["isPermanentlyClosed"]
	if v != nil {
		var isPermanentlyClosed bool
		err = json.Unmarshal(*m["isPermanentlyClosed"], &isPermanentlyClosed)
		if err != nil {
			return err
		}
		lb.IsPermanentlyClosed = &isPermanentlyClosed
	}

	v = m["tagLine"]
	if v != nil {
		var tagLine string
		err = json.Unmarshal(*m["tagLine"], &tagLine)
		if err != nil {
			return err
		}
		lb.TagLine = &tagLine
	}

	v = m["address"]
	if v != nil {
		var address PostalAddress
		err = json.Unmarshal(*m["address"], &address)
		if err != nil {
			return err
		}
		lb.Address = &address
	}

	v = m["telephone"]
	if v != nil {
		var telephone string
		err = json.Unmarshal(*m["telephone"], &telephone)
		if err != nil {
			return err
		}
		lb.Telephone = &telephone
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		lb.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		lb.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		lb.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		lb.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		lb.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		lb.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		lb.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		lb.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		lb.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		lb.Type = _type
	}

	return nil
}

// BasicLodgingBusiness
type BasicLodgingBusiness interface {
	AsHotel() (*Hotel, bool)
	AsLodgingBusiness() (*LodgingBusiness, bool)
}

// LodgingBusiness
type LodgingBusiness struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// Address - The postal address of where the entity is located
	Address *PostalAddress `json:"address,omitempty"`
	// Telephone - The entity's telephone number
	Telephone *string `json:"telephone,omitempty"`
	// PriceRange - $$.
	PriceRange          *string        `json:"priceRange,omitempty"`
	Panoramas           *[]ImageObject `json:"panoramas,omitempty"`
	IsPermanentlyClosed *bool          `json:"isPermanentlyClosed,omitempty"`
	TagLine             *string        `json:"tagLine,omitempty"`
}

func unmarshalBasicLodgingBusiness(body []byte) (BasicLodgingBusiness, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeHotel):
		var h Hotel
		err := json.Unmarshal(body, &h)
		return h, err
	default:
		var lb LodgingBusiness
		err := json.Unmarshal(body, &lb)
		return lb, err
	}
}
func unmarshalBasicLodgingBusinessArray(body []byte) ([]BasicLodgingBusiness, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	lbArray := make([]BasicLodgingBusiness, len(rawMessages))

	for index, rawMessage := range rawMessages {
		lb, err := unmarshalBasicLodgingBusiness(*rawMessage)
		if err != nil {
			return nil, err
		}
		lbArray[index] = lb
	}
	return lbArray, nil
}

// MarshalJSON is the custom marshaler for LodgingBusiness.
func (lb LodgingBusiness) MarshalJSON() ([]byte, error) {
	lb.Type = TypeLodgingBusiness
	type Alias LodgingBusiness
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(lb),
	})
}

// AsImageObject is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsBasicThing() (BasicThing, bool) {
	return &lb, true
}

// AsEntities is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsBasicResponse() (BasicResponse, bool) {
	return &lb, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &lb, true
}

// AsAnswer is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsBasicPlace() (BasicPlace, bool) {
	return &lb, true
}

// AsOrganization is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return &lb, true
}

// AsTouristAttraction is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return &lb, true
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return &lb, true
}

// AsRestaurant is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for LodgingBusiness.
func (lb LodgingBusiness) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &lb, true
}

// UnmarshalJSON is the custom unmarshaler for LodgingBusiness struct.
func (lb *LodgingBusiness) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["priceRange"]
	if v != nil {
		var priceRange string
		err = json.Unmarshal(*m["priceRange"], &priceRange)
		if err != nil {
			return err
		}
		lb.PriceRange = &priceRange
	}

	v = m["panoramas"]
	if v != nil {
		var panoramas []ImageObject
		err = json.Unmarshal(*m["panoramas"], &panoramas)
		if err != nil {
			return err
		}
		lb.Panoramas = &panoramas
	}

	v = m["isPermanentlyClosed"]
	if v != nil {
		var isPermanentlyClosed bool
		err = json.Unmarshal(*m["isPermanentlyClosed"], &isPermanentlyClosed)
		if err != nil {
			return err
		}
		lb.IsPermanentlyClosed = &isPermanentlyClosed
	}

	v = m["tagLine"]
	if v != nil {
		var tagLine string
		err = json.Unmarshal(*m["tagLine"], &tagLine)
		if err != nil {
			return err
		}
		lb.TagLine = &tagLine
	}

	v = m["address"]
	if v != nil {
		var address PostalAddress
		err = json.Unmarshal(*m["address"], &address)
		if err != nil {
			return err
		}
		lb.Address = &address
	}

	v = m["telephone"]
	if v != nil {
		var telephone string
		err = json.Unmarshal(*m["telephone"], &telephone)
		if err != nil {
			return err
		}
		lb.Telephone = &telephone
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		lb.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		lb.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		lb.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		lb.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		lb.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		lb.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		lb.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		lb.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		lb.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		lb.Type = _type
	}

	return nil
}

// BasicMediaObject
type BasicMediaObject interface {
	AsImageObject() (*ImageObject, bool)
	AsMediaObject() (*MediaObject, bool)
}

// MediaObject
type MediaObject struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Text     *string       `json:"text,omitempty"`
	// ContentURL - Original URL to retrieve the source (file) for the media object (e.g the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// HostPageURL - URL of the page that hosts the media object.
	HostPageURL *string `json:"hostPageUrl,omitempty"`
	// Width - The width of the source media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - The height of the source media object, in pixels.
	Height *int32 `json:"height,omitempty"`
}

func unmarshalBasicMediaObject(body []byte) (BasicMediaObject, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	default:
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	}
}
func unmarshalBasicMediaObjectArray(body []byte) ([]BasicMediaObject, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	moArray := make([]BasicMediaObject, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mo, err := unmarshalBasicMediaObject(*rawMessage)
		if err != nil {
			return nil, err
		}
		moArray[index] = mo
	}
	return moArray, nil
}

// MarshalJSON is the custom marshaler for MediaObject.
func (mo MediaObject) MarshalJSON() ([]byte, error) {
	mo.Type = TypeMediaObject
	type Alias MediaObject
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(mo),
	})
}

// AsImageObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicThing() (BasicThing, bool) {
	return &mo, true
}

// AsEntities is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicResponse() (BasicResponse, bool) {
	return &mo, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &mo, true
}

// AsAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicPlace() (BasicPlace, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &mo, true
}

// AsIntangible is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsMediaObject() (*MediaObject, bool) {
	return &mo, true
}

// AsBasicMediaObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &mo, true
}

// AsCivicStructure is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &mo, true
}

// UnmarshalJSON is the custom unmarshaler for MediaObject struct.
func (mo *MediaObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["contentUrl"]
	if v != nil {
		var contentURL string
		err = json.Unmarshal(*m["contentUrl"], &contentURL)
		if err != nil {
			return err
		}
		mo.ContentURL = &contentURL
	}

	v = m["hostPageUrl"]
	if v != nil {
		var hostPageURL string
		err = json.Unmarshal(*m["hostPageUrl"], &hostPageURL)
		if err != nil {
			return err
		}
		mo.HostPageURL = &hostPageURL
	}

	v = m["width"]
	if v != nil {
		var width int32
		err = json.Unmarshal(*m["width"], &width)
		if err != nil {
			return err
		}
		mo.Width = &width
	}

	v = m["height"]
	if v != nil {
		var height int32
		err = json.Unmarshal(*m["height"], &height)
		if err != nil {
			return err
		}
		mo.Height = &height
	}

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		mo.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		mo.Provider = &provider
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		mo.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		mo.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		mo.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		mo.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		mo.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		mo.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		mo.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		mo.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		mo.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		mo.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		mo.Type = _type
	}

	return nil
}

// MovieTheater ...
type MovieTheater struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// Address - The postal address of where the entity is located
	Address *PostalAddress `json:"address,omitempty"`
	// Telephone - The entity's telephone number
	Telephone *string `json:"telephone,omitempty"`
	// PriceRange - $$.
	PriceRange          *string        `json:"priceRange,omitempty"`
	Panoramas           *[]ImageObject `json:"panoramas,omitempty"`
	IsPermanentlyClosed *bool          `json:"isPermanentlyClosed,omitempty"`
	TagLine             *string        `json:"tagLine,omitempty"`
	ScreenCount         *int32         `json:"screenCount,omitempty"`
}

// MarshalJSON is the custom marshaler for MovieTheater.
func (mt MovieTheater) MarshalJSON() ([]byte, error) {
	mt.Type = TypeMovieTheater
	type Alias MovieTheater
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(mt),
	})
}

// AsImageObject is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsBasicThing() (BasicThing, bool) {
	return &mt, true
}

// AsEntities is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsBasicResponse() (BasicResponse, bool) {
	return &mt, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &mt, true
}

// AsAnswer is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsBasicPlace() (BasicPlace, bool) {
	return &mt, true
}

// AsOrganization is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsMovieTheater() (*MovieTheater, bool) {
	return &mt, true
}

// AsMediaObject is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return &mt, true
}

// AsTouristAttraction is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return &mt, true
}

// AsFoodEstablishment is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for MovieTheater.
func (mt MovieTheater) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &mt, true
}

// UnmarshalJSON is the custom unmarshaler for MovieTheater struct.
func (mt *MovieTheater) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["screenCount"]
	if v != nil {
		var screenCount int32
		err = json.Unmarshal(*m["screenCount"], &screenCount)
		if err != nil {
			return err
		}
		mt.ScreenCount = &screenCount
	}

	v = m["priceRange"]
	if v != nil {
		var priceRange string
		err = json.Unmarshal(*m["priceRange"], &priceRange)
		if err != nil {
			return err
		}
		mt.PriceRange = &priceRange
	}

	v = m["panoramas"]
	if v != nil {
		var panoramas []ImageObject
		err = json.Unmarshal(*m["panoramas"], &panoramas)
		if err != nil {
			return err
		}
		mt.Panoramas = &panoramas
	}

	v = m["isPermanentlyClosed"]
	if v != nil {
		var isPermanentlyClosed bool
		err = json.Unmarshal(*m["isPermanentlyClosed"], &isPermanentlyClosed)
		if err != nil {
			return err
		}
		mt.IsPermanentlyClosed = &isPermanentlyClosed
	}

	v = m["tagLine"]
	if v != nil {
		var tagLine string
		err = json.Unmarshal(*m["tagLine"], &tagLine)
		if err != nil {
			return err
		}
		mt.TagLine = &tagLine
	}

	v = m["address"]
	if v != nil {
		var address PostalAddress
		err = json.Unmarshal(*m["address"], &address)
		if err != nil {
			return err
		}
		mt.Address = &address
	}

	v = m["telephone"]
	if v != nil {
		var telephone string
		err = json.Unmarshal(*m["telephone"], &telephone)
		if err != nil {
			return err
		}
		mt.Telephone = &telephone
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		mt.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		mt.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		mt.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		mt.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		mt.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		mt.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		mt.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		mt.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		mt.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		mt.Type = _type
	}

	return nil
}

// Organization defines an organization.
type Organization struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
}

// MarshalJSON is the custom marshaler for Organization.
func (o Organization) MarshalJSON() ([]byte, error) {
	o.Type = TypeOrganization
	type Alias Organization
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(o),
	})
}

// AsImageObject is the BasicResponseBase implementation for Organization.
func (o Organization) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Organization.
func (o Organization) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicThing() (BasicThing, bool) {
	return &o, true
}

// AsEntities is the BasicResponseBase implementation for Organization.
func (o Organization) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Organization.
func (o Organization) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Organization.
func (o Organization) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Organization.
func (o Organization) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicResponse() (BasicResponse, bool) {
	return &o, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Organization.
func (o Organization) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Organization.
func (o Organization) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &o, true
}

// AsAnswer is the BasicResponseBase implementation for Organization.
func (o Organization) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Organization.
func (o Organization) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Organization.
func (o Organization) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Organization.
func (o Organization) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicPlace() (BasicPlace, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Organization.
func (o Organization) AsOrganization() (*Organization, bool) {
	return &o, true
}

// AsCreativeWork is the BasicResponseBase implementation for Organization.
func (o Organization) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Organization.
func (o Organization) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for Organization.
func (o Organization) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Organization.
func (o Organization) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for Organization.
func (o Organization) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for Organization.
func (o Organization) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for Organization.
func (o Organization) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for Organization.
func (o Organization) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for Organization.
func (o Organization) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Organization.
func (o Organization) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for Organization.
func (o Organization) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for Organization.
func (o Organization) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for Organization.
func (o Organization) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for Organization.
func (o Organization) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for Organization.
func (o Organization) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Organization.
func (o Organization) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &o, true
}

// UnmarshalJSON is the custom unmarshaler for Organization struct.
func (o *Organization) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		o.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		o.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		o.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		o.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		o.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		o.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		o.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		o.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		o.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		o.Type = _type
	}

	return nil
}

// BasicPlace defines information about a local entity, such as a restaurant or hotel.
type BasicPlace interface {
	AsMovieTheater() (*MovieTheater, bool)
	AsCivicStructure() (*CivicStructure, bool)
	AsBasicCivicStructure() (BasicCivicStructure, bool)
	AsLocalBusiness() (*LocalBusiness, bool)
	AsBasicLocalBusiness() (BasicLocalBusiness, bool)
	AsTouristAttraction() (*TouristAttraction, bool)
	AsAirport() (*Airport, bool)
	AsEntertainmentBusiness() (*EntertainmentBusiness, bool)
	AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool)
	AsFoodEstablishment() (*FoodEstablishment, bool)
	AsBasicFoodEstablishment() (BasicFoodEstablishment, bool)
	AsLodgingBusiness() (*LodgingBusiness, bool)
	AsBasicLodgingBusiness() (BasicLodgingBusiness, bool)
	AsRestaurant() (*Restaurant, bool)
	AsHotel() (*Hotel, bool)
	AsPlace() (*Place, bool)
}

// Place defines information about a local entity, such as a restaurant or hotel.
type Place struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// Address - The postal address of where the entity is located
	Address *PostalAddress `json:"address,omitempty"`
	// Telephone - The entity's telephone number
	Telephone *string `json:"telephone,omitempty"`
}

func unmarshalBasicPlace(body []byte) (BasicPlace, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeMovieTheater):
		var mt MovieTheater
		err := json.Unmarshal(body, &mt)
		return mt, err
	case string(TypeCivicStructure):
		var cs CivicStructure
		err := json.Unmarshal(body, &cs)
		return cs, err
	case string(TypeLocalBusiness):
		var lb LocalBusiness
		err := json.Unmarshal(body, &lb)
		return lb, err
	case string(TypeTouristAttraction):
		var ta TouristAttraction
		err := json.Unmarshal(body, &ta)
		return ta, err
	case string(TypeAirport):
		var a Airport
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeEntertainmentBusiness):
		var eb EntertainmentBusiness
		err := json.Unmarshal(body, &eb)
		return eb, err
	case string(TypeFoodEstablishment):
		var fe FoodEstablishment
		err := json.Unmarshal(body, &fe)
		return fe, err
	case string(TypeLodgingBusiness):
		var lb LodgingBusiness
		err := json.Unmarshal(body, &lb)
		return lb, err
	case string(TypeRestaurant):
		var r Restaurant
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeHotel):
		var h Hotel
		err := json.Unmarshal(body, &h)
		return h, err
	default:
		var p Place
		err := json.Unmarshal(body, &p)
		return p, err
	}
}
func unmarshalBasicPlaceArray(body []byte) ([]BasicPlace, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	pArray := make([]BasicPlace, len(rawMessages))

	for index, rawMessage := range rawMessages {
		p, err := unmarshalBasicPlace(*rawMessage)
		if err != nil {
			return nil, err
		}
		pArray[index] = p
	}
	return pArray, nil
}

// MarshalJSON is the custom marshaler for Place.
func (p Place) MarshalJSON() ([]byte, error) {
	p.Type = TypePlace
	type Alias Place
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(p),
	})
}

// AsImageObject is the BasicResponseBase implementation for Place.
func (p Place) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Place.
func (p Place) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Place.
func (p Place) AsBasicThing() (BasicThing, bool) {
	return &p, true
}

// AsEntities is the BasicResponseBase implementation for Place.
func (p Place) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Place.
func (p Place) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Place.
func (p Place) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Place.
func (p Place) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Place.
func (p Place) AsBasicResponse() (BasicResponse, bool) {
	return &p, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Place.
func (p Place) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Place.
func (p Place) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Place.
func (p Place) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Place.
func (p Place) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &p, true
}

// AsAnswer is the BasicResponseBase implementation for Place.
func (p Place) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Place.
func (p Place) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Place.
func (p Place) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Place.
func (p Place) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Place.
func (p Place) AsPlace() (*Place, bool) {
	return &p, true
}

// AsBasicPlace is the BasicResponseBase implementation for Place.
func (p Place) AsBasicPlace() (BasicPlace, bool) {
	return &p, true
}

// AsOrganization is the BasicResponseBase implementation for Place.
func (p Place) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Place.
func (p Place) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Place.
func (p Place) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Place.
func (p Place) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Place.
func (p Place) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for Place.
func (p Place) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Place.
func (p Place) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Place.
func (p Place) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for Place.
func (p Place) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for Place.
func (p Place) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for Place.
func (p Place) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for Place.
func (p Place) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for Place.
func (p Place) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for Place.
func (p Place) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for Place.
func (p Place) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Place.
func (p Place) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Place.
func (p Place) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for Place.
func (p Place) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for Place.
func (p Place) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for Place.
func (p Place) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for Place.
func (p Place) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for Place.
func (p Place) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for Place.
func (p Place) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for Place.
func (p Place) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for Place.
func (p Place) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Place.
func (p Place) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Place.
func (p Place) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &p, true
}

// UnmarshalJSON is the custom unmarshaler for Place struct.
func (p *Place) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["address"]
	if v != nil {
		var address PostalAddress
		err = json.Unmarshal(*m["address"], &address)
		if err != nil {
			return err
		}
		p.Address = &address
	}

	v = m["telephone"]
	if v != nil {
		var telephone string
		err = json.Unmarshal(*m["telephone"], &telephone)
		if err != nil {
			return err
		}
		p.Telephone = &telephone
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		p.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		p.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		p.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		p.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		p.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		p.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		p.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		p.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		p.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		p.Type = _type
	}

	return nil
}

// Places defines a local entity answer.
type Places struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string       `json:"webSearchUrl,omitempty"`
	QueryContext *QueryContext `json:"queryContext,omitempty"`
	// Value - A list of local entities, such as restaurants or hotels.
	Value *[]BasicThing `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for Places.
func (p Places) MarshalJSON() ([]byte, error) {
	p.Type = TypePlaces
	type Alias Places
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(p),
	})
}

// AsImageObject is the BasicResponseBase implementation for Places.
func (p Places) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Places.
func (p Places) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Places.
func (p Places) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsEntities is the BasicResponseBase implementation for Places.
func (p Places) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Places.
func (p Places) AsPlaces() (*Places, bool) {
	return &p, true
}

// AsSearchResponse is the BasicResponseBase implementation for Places.
func (p Places) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Places.
func (p Places) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Places.
func (p Places) AsBasicResponse() (BasicResponse, bool) {
	return &p, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Places.
func (p Places) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Places.
func (p Places) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &p, true
}

// AsIdentifiable is the BasicResponseBase implementation for Places.
func (p Places) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Places.
func (p Places) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &p, true
}

// AsAnswer is the BasicResponseBase implementation for Places.
func (p Places) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Places.
func (p Places) AsBasicAnswer() (BasicAnswer, bool) {
	return &p, true
}

// AsErrorResponse is the BasicResponseBase implementation for Places.
func (p Places) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Places.
func (p Places) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Places.
func (p Places) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for Places.
func (p Places) AsBasicPlace() (BasicPlace, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Places.
func (p Places) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Places.
func (p Places) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Places.
func (p Places) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Places.
func (p Places) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Places.
func (p Places) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for Places.
func (p Places) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Places.
func (p Places) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Places.
func (p Places) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for Places.
func (p Places) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for Places.
func (p Places) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for Places.
func (p Places) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for Places.
func (p Places) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for Places.
func (p Places) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for Places.
func (p Places) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for Places.
func (p Places) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Places.
func (p Places) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Places.
func (p Places) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for Places.
func (p Places) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for Places.
func (p Places) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for Places.
func (p Places) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for Places.
func (p Places) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for Places.
func (p Places) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for Places.
func (p Places) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for Places.
func (p Places) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for Places.
func (p Places) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Places.
func (p Places) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Places.
func (p Places) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &p, true
}

// UnmarshalJSON is the custom unmarshaler for Places struct.
func (p *Places) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["value"]
	if v != nil {
		value, err := unmarshalBasicThingArray(*m["value"])
		if err != nil {
			return err
		}
		p.Value = &value
	}

	v = m["queryContext"]
	if v != nil {
		var queryContext QueryContext
		err = json.Unmarshal(*m["queryContext"], &queryContext)
		if err != nil {
			return err
		}
		p.QueryContext = &queryContext
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		p.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		p.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		p.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		p.Type = _type
	}

	return nil
}

// PostalAddress defines a postal address.
type PostalAddress struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID        *string `json:"bingId,omitempty"`
	StreetAddress *string `json:"streetAddress,omitempty"`
	// AddressLocality - The city where the street address is located. For example, Seattle.
	AddressLocality  *string `json:"addressLocality,omitempty"`
	AddressSubregion *string `json:"addressSubregion,omitempty"`
	// AddressRegion - The state or province code where the street address is located. This could be the two-letter code. For example, WA, or the full name , Washington.
	AddressRegion *string `json:"addressRegion,omitempty"`
	// PostalCode - The zip code or postal code where the street address is located. For example, 98052.
	PostalCode          *string `json:"postalCode,omitempty"`
	PostOfficeBoxNumber *string `json:"postOfficeBoxNumber,omitempty"`
	// AddressCountry - The country/region where the street address is located. This could be the two-letter ISO code. For example, US, or the full name, United States.
	AddressCountry *string `json:"addressCountry,omitempty"`
	// CountryIso - The two letter ISO code of this countr. For example, US.
	CountryIso *string `json:"countryIso,omitempty"`
	// Neighborhood - The neighborhood where the street address is located. For example, Westlake.
	Neighborhood *string `json:"neighborhood,omitempty"`
	// AddressRegionAbbreviation - Region Abbreviation. For example, WA.
	AddressRegionAbbreviation *string `json:"addressRegionAbbreviation,omitempty"`
	// Text - The complete address. For example, 2100 Westlake Ave N, Bellevue, WA 98052.
	Text *string `json:"text,omitempty"`
}

// MarshalJSON is the custom marshaler for PostalAddress.
func (pa PostalAddress) MarshalJSON() ([]byte, error) {
	pa.Type = TypePostalAddress
	type Alias PostalAddress
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(pa),
	})
}

// AsImageObject is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicThing() (BasicThing, bool) {
	return &pa, true
}

// AsEntities is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicResponse() (BasicResponse, bool) {
	return &pa, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &pa, true
}

// AsAnswer is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsPostalAddress() (*PostalAddress, bool) {
	return &pa, true
}

// AsPlace is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicPlace() (BasicPlace, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicIntangible() (BasicIntangible, bool) {
	return &pa, true
}

// AsMovieTheater is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return &pa, true
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for PostalAddress.
func (pa PostalAddress) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &pa, true
}

// UnmarshalJSON is the custom unmarshaler for PostalAddress struct.
func (pa *PostalAddress) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["streetAddress"]
	if v != nil {
		var streetAddress string
		err = json.Unmarshal(*m["streetAddress"], &streetAddress)
		if err != nil {
			return err
		}
		pa.StreetAddress = &streetAddress
	}

	v = m["addressLocality"]
	if v != nil {
		var addressLocality string
		err = json.Unmarshal(*m["addressLocality"], &addressLocality)
		if err != nil {
			return err
		}
		pa.AddressLocality = &addressLocality
	}

	v = m["addressSubregion"]
	if v != nil {
		var addressSubregion string
		err = json.Unmarshal(*m["addressSubregion"], &addressSubregion)
		if err != nil {
			return err
		}
		pa.AddressSubregion = &addressSubregion
	}

	v = m["addressRegion"]
	if v != nil {
		var addressRegion string
		err = json.Unmarshal(*m["addressRegion"], &addressRegion)
		if err != nil {
			return err
		}
		pa.AddressRegion = &addressRegion
	}

	v = m["postalCode"]
	if v != nil {
		var postalCode string
		err = json.Unmarshal(*m["postalCode"], &postalCode)
		if err != nil {
			return err
		}
		pa.PostalCode = &postalCode
	}

	v = m["postOfficeBoxNumber"]
	if v != nil {
		var postOfficeBoxNumber string
		err = json.Unmarshal(*m["postOfficeBoxNumber"], &postOfficeBoxNumber)
		if err != nil {
			return err
		}
		pa.PostOfficeBoxNumber = &postOfficeBoxNumber
	}

	v = m["addressCountry"]
	if v != nil {
		var addressCountry string
		err = json.Unmarshal(*m["addressCountry"], &addressCountry)
		if err != nil {
			return err
		}
		pa.AddressCountry = &addressCountry
	}

	v = m["countryIso"]
	if v != nil {
		var countryIso string
		err = json.Unmarshal(*m["countryIso"], &countryIso)
		if err != nil {
			return err
		}
		pa.CountryIso = &countryIso
	}

	v = m["neighborhood"]
	if v != nil {
		var neighborhood string
		err = json.Unmarshal(*m["neighborhood"], &neighborhood)
		if err != nil {
			return err
		}
		pa.Neighborhood = &neighborhood
	}

	v = m["addressRegionAbbreviation"]
	if v != nil {
		var addressRegionAbbreviation string
		err = json.Unmarshal(*m["addressRegionAbbreviation"], &addressRegionAbbreviation)
		if err != nil {
			return err
		}
		pa.AddressRegionAbbreviation = &addressRegionAbbreviation
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		pa.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		pa.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		pa.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		pa.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		pa.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		pa.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		pa.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		pa.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		pa.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		pa.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		pa.Type = _type
	}

	return nil
}

// QueryContext defines the query context that Bing used for the request.
type QueryContext struct {
	// OriginalQuery - The query string as specified in the request.
	OriginalQuery *string `json:"originalQuery,omitempty"`
	// AlteredQuery - The query string used by Bing to perform the query. Bing uses the altered query string if the original query string contained spelling mistakes. For example, if the query string is "saling downwind", the altered query string will be "sailing downwind". This field is included only if the original query string contains a spelling mistake.
	AlteredQuery *string `json:"alteredQuery,omitempty"`
	// AlterationOverrideQuery - The query string to use to force Bing to use the original string. For example, if the query string is "saling downwind", the override query string will be "+saling downwind". Remember to encode the query string which results in "%2Bsaling+downwind". This field is included only if the original query string contains a spelling mistake.
	AlterationOverrideQuery *string `json:"alterationOverrideQuery,omitempty"`
	// AdultIntent - A Boolean value that indicates whether the specified query has adult intent. The value is true if the query has adult intent; otherwise, false.
	AdultIntent *bool `json:"adultIntent,omitempty"`
	// AskUserForLocation - A Boolean value that indicates whether Bing requires the user's location to provide accurate results. If you specified the user's location by using the X-MSEdge-ClientIP and X-Search-Location headers, you can ignore this field. For location aware queries, such as "today's weather" or "restaurants near me" that need the user's location to provide accurate results, this field is set to true. For location aware queries that include the location (for example, "Seattle weather"), this field is set to false. This field is also set to false for queries that are not location aware, such as "best sellers".
	AskUserForLocation *bool `json:"askUserForLocation,omitempty"`
}

// BasicResponse defines a response. All schemas that could be returned at the root of a response should inherit from
// this
type BasicResponse interface {
	AsImageObject() (*ImageObject, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsEntities() (*Entities, bool)
	AsPlaces() (*Places, bool)
	AsSearchResponse() (*SearchResponse, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsPostalAddress() (*PostalAddress, bool)
	AsPlace() (*Place, bool)
	AsBasicPlace() (BasicPlace, bool)
	AsOrganization() (*Organization, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsMovieTheater() (*MovieTheater, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsCivicStructure() (*CivicStructure, bool)
	AsBasicCivicStructure() (BasicCivicStructure, bool)
	AsLocalBusiness() (*LocalBusiness, bool)
	AsBasicLocalBusiness() (BasicLocalBusiness, bool)
	AsTouristAttraction() (*TouristAttraction, bool)
	AsAirport() (*Airport, bool)
	AsLicense() (*License, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsEntertainmentBusiness() (*EntertainmentBusiness, bool)
	AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool)
	AsFoodEstablishment() (*FoodEstablishment, bool)
	AsBasicFoodEstablishment() (BasicFoodEstablishment, bool)
	AsLodgingBusiness() (*LodgingBusiness, bool)
	AsBasicLodgingBusiness() (BasicLodgingBusiness, bool)
	AsRestaurant() (*Restaurant, bool)
	AsHotel() (*Hotel, bool)
	AsResponse() (*Response, bool)
}

// Response defines a response. All schemas that could be returned at the root of a response should inherit from this
type Response struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
}

func unmarshalBasicResponse(body []byte) (BasicResponse, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeEntities):
		var e Entities
		err := json.Unmarshal(body, &e)
		return e, err
	case string(TypePlaces):
		var p Places
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeSearchResponse):
		var sr SearchResponse
		err := json.Unmarshal(body, &sr)
		return sr, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypePostalAddress):
		var pa PostalAddress
		err := json.Unmarshal(body, &pa)
		return pa, err
	case string(TypePlace):
		var p Place
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeOrganization):
		var o Organization
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeMovieTheater):
		var mt MovieTheater
		err := json.Unmarshal(body, &mt)
		return mt, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeCivicStructure):
		var cs CivicStructure
		err := json.Unmarshal(body, &cs)
		return cs, err
	case string(TypeLocalBusiness):
		var lb LocalBusiness
		err := json.Unmarshal(body, &lb)
		return lb, err
	case string(TypeTouristAttraction):
		var ta TouristAttraction
		err := json.Unmarshal(body, &ta)
		return ta, err
	case string(TypeAirport):
		var a Airport
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeLicense):
		var l License
		err := json.Unmarshal(body, &l)
		return l, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	case string(TypeEntertainmentBusiness):
		var eb EntertainmentBusiness
		err := json.Unmarshal(body, &eb)
		return eb, err
	case string(TypeFoodEstablishment):
		var fe FoodEstablishment
		err := json.Unmarshal(body, &fe)
		return fe, err
	case string(TypeLodgingBusiness):
		var lb LodgingBusiness
		err := json.Unmarshal(body, &lb)
		return lb, err
	case string(TypeRestaurant):
		var r Restaurant
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeHotel):
		var h Hotel
		err := json.Unmarshal(body, &h)
		return h, err
	default:
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicResponseArray(body []byte) ([]BasicResponse, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicResponse, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicResponse(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Response.
func (r Response) MarshalJSON() ([]byte, error) {
	r.Type = TypeResponse
	type Alias Response
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(r),
	})
}

// AsImageObject is the BasicResponseBase implementation for Response.
func (r Response) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Response.
func (r Response) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Response.
func (r Response) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsEntities is the BasicResponseBase implementation for Response.
func (r Response) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Response.
func (r Response) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Response.
func (r Response) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Response.
func (r Response) AsResponse() (*Response, bool) {
	return &r, true
}

// AsBasicResponse is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponse() (BasicResponse, bool) {
	return &r, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &r, true
}

// AsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Response.
func (r Response) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Response.
func (r Response) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Response.
func (r Response) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for Response.
func (r Response) AsBasicPlace() (BasicPlace, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Response.
func (r Response) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Response.
func (r Response) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Response.
func (r Response) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for Response.
func (r Response) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Response.
func (r Response) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Response.
func (r Response) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for Response.
func (r Response) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for Response.
func (r Response) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for Response.
func (r Response) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for Response.
func (r Response) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for Response.
func (r Response) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for Response.
func (r Response) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for Response.
func (r Response) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Response.
func (r Response) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Response.
func (r Response) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for Response.
func (r Response) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for Response.
func (r Response) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for Response.
func (r Response) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for Response.
func (r Response) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for Response.
func (r Response) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for Response.
func (r Response) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for Response.
func (r Response) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for Response.
func (r Response) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &r, true
}

// UnmarshalJSON is the custom unmarshaler for Response struct.
func (r *Response) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		r.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		r.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		r.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		r.Type = _type
	}

	return nil
}

// BasicResponseBase
type BasicResponseBase interface {
	AsImageObject() (*ImageObject, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsEntities() (*Entities, bool)
	AsPlaces() (*Places, bool)
	AsSearchResponse() (*SearchResponse, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsIdentifiable() (*Identifiable, bool)
	AsBasicIdentifiable() (BasicIdentifiable, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsPostalAddress() (*PostalAddress, bool)
	AsPlace() (*Place, bool)
	AsBasicPlace() (BasicPlace, bool)
	AsOrganization() (*Organization, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsMovieTheater() (*MovieTheater, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsCivicStructure() (*CivicStructure, bool)
	AsBasicCivicStructure() (BasicCivicStructure, bool)
	AsLocalBusiness() (*LocalBusiness, bool)
	AsBasicLocalBusiness() (BasicLocalBusiness, bool)
	AsTouristAttraction() (*TouristAttraction, bool)
	AsAirport() (*Airport, bool)
	AsLicense() (*License, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsEntertainmentBusiness() (*EntertainmentBusiness, bool)
	AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool)
	AsFoodEstablishment() (*FoodEstablishment, bool)
	AsBasicFoodEstablishment() (BasicFoodEstablishment, bool)
	AsLodgingBusiness() (*LodgingBusiness, bool)
	AsBasicLodgingBusiness() (BasicLodgingBusiness, bool)
	AsRestaurant() (*Restaurant, bool)
	AsHotel() (*Hotel, bool)
	AsResponseBase() (*ResponseBase, bool)
}

// ResponseBase
type ResponseBase struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
}

func unmarshalBasicResponseBase(body []byte) (BasicResponseBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeEntities):
		var e Entities
		err := json.Unmarshal(body, &e)
		return e, err
	case string(TypePlaces):
		var p Places
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeSearchResponse):
		var sr SearchResponse
		err := json.Unmarshal(body, &sr)
		return sr, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeIdentifiable):
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypePostalAddress):
		var pa PostalAddress
		err := json.Unmarshal(body, &pa)
		return pa, err
	case string(TypePlace):
		var p Place
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeOrganization):
		var o Organization
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeMovieTheater):
		var mt MovieTheater
		err := json.Unmarshal(body, &mt)
		return mt, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeCivicStructure):
		var cs CivicStructure
		err := json.Unmarshal(body, &cs)
		return cs, err
	case string(TypeLocalBusiness):
		var lb LocalBusiness
		err := json.Unmarshal(body, &lb)
		return lb, err
	case string(TypeTouristAttraction):
		var ta TouristAttraction
		err := json.Unmarshal(body, &ta)
		return ta, err
	case string(TypeAirport):
		var a Airport
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeLicense):
		var l License
		err := json.Unmarshal(body, &l)
		return l, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	case string(TypeEntertainmentBusiness):
		var eb EntertainmentBusiness
		err := json.Unmarshal(body, &eb)
		return eb, err
	case string(TypeFoodEstablishment):
		var fe FoodEstablishment
		err := json.Unmarshal(body, &fe)
		return fe, err
	case string(TypeLodgingBusiness):
		var lb LodgingBusiness
		err := json.Unmarshal(body, &lb)
		return lb, err
	case string(TypeRestaurant):
		var r Restaurant
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeHotel):
		var h Hotel
		err := json.Unmarshal(body, &h)
		return h, err
	default:
		var rb ResponseBase
		err := json.Unmarshal(body, &rb)
		return rb, err
	}
}
func unmarshalBasicResponseBaseArray(body []byte) ([]BasicResponseBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rbArray := make([]BasicResponseBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rb, err := unmarshalBasicResponseBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		rbArray[index] = rb
	}
	return rbArray, nil
}

// MarshalJSON is the custom marshaler for ResponseBase.
func (rb ResponseBase) MarshalJSON() ([]byte, error) {
	rb.Type = TypeResponseBase
	type Alias ResponseBase
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rb),
	})
}

// AsImageObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsEntities is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicPlace() (BasicPlace, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponseBase() (*ResponseBase, bool) {
	return &rb, true
}

// AsBasicResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &rb, true
}

// Restaurant ...
type Restaurant struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// Address - The postal address of where the entity is located
	Address *PostalAddress `json:"address,omitempty"`
	// Telephone - The entity's telephone number
	Telephone *string `json:"telephone,omitempty"`
	// PriceRange - $$.
	PriceRange          *string        `json:"priceRange,omitempty"`
	Panoramas           *[]ImageObject `json:"panoramas,omitempty"`
	IsPermanentlyClosed *bool          `json:"isPermanentlyClosed,omitempty"`
	TagLine             *string        `json:"tagLine,omitempty"`
	AcceptsReservations *bool          `json:"acceptsReservations,omitempty"`
	ReservationURL      *string        `json:"reservationUrl,omitempty"`
	ServesCuisine       *[]string      `json:"servesCuisine,omitempty"`
	MenuURL             *string        `json:"menuUrl,omitempty"`
}

// MarshalJSON is the custom marshaler for Restaurant.
func (r Restaurant) MarshalJSON() ([]byte, error) {
	r.Type = TypeRestaurant
	type Alias Restaurant
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(r),
	})
}

// AsImageObject is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsBasicThing() (BasicThing, bool) {
	return &r, true
}

// AsEntities is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsBasicResponse() (BasicResponse, bool) {
	return &r, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &r, true
}

// AsAnswer is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsBasicPlace() (BasicPlace, bool) {
	return &r, true
}

// AsOrganization is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return &r, true
}

// AsTouristAttraction is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return &r, true
}

// AsLodgingBusiness is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsRestaurant() (*Restaurant, bool) {
	return &r, true
}

// AsHotel is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Restaurant.
func (r Restaurant) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &r, true
}

// UnmarshalJSON is the custom unmarshaler for Restaurant struct.
func (r *Restaurant) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["acceptsReservations"]
	if v != nil {
		var acceptsReservations bool
		err = json.Unmarshal(*m["acceptsReservations"], &acceptsReservations)
		if err != nil {
			return err
		}
		r.AcceptsReservations = &acceptsReservations
	}

	v = m["reservationUrl"]
	if v != nil {
		var reservationURL string
		err = json.Unmarshal(*m["reservationUrl"], &reservationURL)
		if err != nil {
			return err
		}
		r.ReservationURL = &reservationURL
	}

	v = m["servesCuisine"]
	if v != nil {
		var servesCuisine []string
		err = json.Unmarshal(*m["servesCuisine"], &servesCuisine)
		if err != nil {
			return err
		}
		r.ServesCuisine = &servesCuisine
	}

	v = m["menuUrl"]
	if v != nil {
		var menuURL string
		err = json.Unmarshal(*m["menuUrl"], &menuURL)
		if err != nil {
			return err
		}
		r.MenuURL = &menuURL
	}

	v = m["priceRange"]
	if v != nil {
		var priceRange string
		err = json.Unmarshal(*m["priceRange"], &priceRange)
		if err != nil {
			return err
		}
		r.PriceRange = &priceRange
	}

	v = m["panoramas"]
	if v != nil {
		var panoramas []ImageObject
		err = json.Unmarshal(*m["panoramas"], &panoramas)
		if err != nil {
			return err
		}
		r.Panoramas = &panoramas
	}

	v = m["isPermanentlyClosed"]
	if v != nil {
		var isPermanentlyClosed bool
		err = json.Unmarshal(*m["isPermanentlyClosed"], &isPermanentlyClosed)
		if err != nil {
			return err
		}
		r.IsPermanentlyClosed = &isPermanentlyClosed
	}

	v = m["tagLine"]
	if v != nil {
		var tagLine string
		err = json.Unmarshal(*m["tagLine"], &tagLine)
		if err != nil {
			return err
		}
		r.TagLine = &tagLine
	}

	v = m["address"]
	if v != nil {
		var address PostalAddress
		err = json.Unmarshal(*m["address"], &address)
		if err != nil {
			return err
		}
		r.Address = &address
	}

	v = m["telephone"]
	if v != nil {
		var telephone string
		err = json.Unmarshal(*m["telephone"], &telephone)
		if err != nil {
			return err
		}
		r.Telephone = &telephone
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		r.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		r.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		r.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		r.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		r.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		r.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		r.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		r.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		r.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		r.Type = _type
	}

	return nil
}

// SearchResponse defines the top-level object that the response includes when the request succeeds.
type SearchResponse struct {
	autorest.Response `json:"-"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// QueryContext - An object that contains the query string that Bing used for the request. This object contains the query string as entered by the user. It may also contain an altered query string that Bing used for the query if the query string contained a spelling mistake.
	QueryContext *QueryContext `json:"queryContext,omitempty"`
	// Entities - A list of entities that are relevant to the search query.
	Entities *Entities `json:"entities,omitempty"`
	// Places - A list of local entities such as restaurants or hotels that are relevant to the query.
	Places *Places `json:"places,omitempty"`
}

// MarshalJSON is the custom marshaler for SearchResponse.
func (sr SearchResponse) MarshalJSON() ([]byte, error) {
	sr.Type = TypeSearchResponse
	type Alias SearchResponse
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sr),
	})
}

// AsImageObject is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsEntities is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsSearchResponse() (*SearchResponse, bool) {
	return &sr, true
}

// AsResponse is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicResponse() (BasicResponse, bool) {
	return &sr, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sr, true
}

// AsAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicPlace() (BasicPlace, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sr, true
}

// UnmarshalJSON is the custom unmarshaler for SearchResponse struct.
func (sr *SearchResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["queryContext"]
	if v != nil {
		var queryContext QueryContext
		err = json.Unmarshal(*m["queryContext"], &queryContext)
		if err != nil {
			return err
		}
		sr.QueryContext = &queryContext
	}

	v = m["entities"]
	if v != nil {
		var entities Entities
		err = json.Unmarshal(*m["entities"], &entities)
		if err != nil {
			return err
		}
		sr.Entities = &entities
	}

	v = m["places"]
	if v != nil {
		var places Places
		err = json.Unmarshal(*m["places"], &places)
		if err != nil {
			return err
		}
		sr.Places = &places
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		sr.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		sr.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		sr.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		sr.Type = _type
	}

	return nil
}

// BasicSearchResultsAnswer
type BasicSearchResultsAnswer interface {
	AsEntities() (*Entities, bool)
	AsPlaces() (*Places, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
}

// SearchResultsAnswer
type SearchResultsAnswer struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string       `json:"webSearchUrl,omitempty"`
	QueryContext *QueryContext `json:"queryContext,omitempty"`
}

func unmarshalBasicSearchResultsAnswer(body []byte) (BasicSearchResultsAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeEntities):
		var e Entities
		err := json.Unmarshal(body, &e)
		return e, err
	case string(TypePlaces):
		var p Places
		err := json.Unmarshal(body, &p)
		return p, err
	default:
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	}
}
func unmarshalBasicSearchResultsAnswerArray(body []byte) ([]BasicSearchResultsAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sraArray := make([]BasicSearchResultsAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sra, err := unmarshalBasicSearchResultsAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		sraArray[index] = sra
	}
	return sraArray, nil
}

// MarshalJSON is the custom marshaler for SearchResultsAnswer.
func (sra SearchResultsAnswer) MarshalJSON() ([]byte, error) {
	sra.Type = TypeSearchResultsAnswer
	type Alias SearchResultsAnswer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sra),
	})
}

// AsImageObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsEntities is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponse() (BasicResponse, bool) {
	return &sra, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return &sra, true
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &sra, true
}

// AsIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sra, true
}

// AsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicAnswer() (BasicAnswer, bool) {
	return &sra, true
}

// AsErrorResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicPlace() (BasicPlace, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sra, true
}

// UnmarshalJSON is the custom unmarshaler for SearchResultsAnswer struct.
func (sra *SearchResultsAnswer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["queryContext"]
	if v != nil {
		var queryContext QueryContext
		err = json.Unmarshal(*m["queryContext"], &queryContext)
		if err != nil {
			return err
		}
		sra.QueryContext = &queryContext
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		sra.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		sra.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		sra.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		sra.Type = _type
	}

	return nil
}

// BasicStructuredValue
type BasicStructuredValue interface {
	AsPostalAddress() (*PostalAddress, bool)
	AsStructuredValue() (*StructuredValue, bool)
}

// StructuredValue
type StructuredValue struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
}

func unmarshalBasicStructuredValue(body []byte) (BasicStructuredValue, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypePostalAddress):
		var pa PostalAddress
		err := json.Unmarshal(body, &pa)
		return pa, err
	default:
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	}
}
func unmarshalBasicStructuredValueArray(body []byte) ([]BasicStructuredValue, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	svArray := make([]BasicStructuredValue, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sv, err := unmarshalBasicStructuredValue(*rawMessage)
		if err != nil {
			return nil, err
		}
		svArray[index] = sv
	}
	return svArray, nil
}

// MarshalJSON is the custom marshaler for StructuredValue.
func (sv StructuredValue) MarshalJSON() ([]byte, error) {
	sv.Type = TypeStructuredValue
	type Alias StructuredValue
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sv),
	})
}

// AsImageObject is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicThing() (BasicThing, bool) {
	return &sv, true
}

// AsEntities is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicResponse() (BasicResponse, bool) {
	return &sv, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sv, true
}

// AsAnswer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicPlace() (BasicPlace, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicIntangible() (BasicIntangible, bool) {
	return &sv, true
}

// AsMovieTheater is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsStructuredValue() (*StructuredValue, bool) {
	return &sv, true
}

// AsBasicStructuredValue is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return &sv, true
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sv, true
}

// UnmarshalJSON is the custom unmarshaler for StructuredValue struct.
func (sv *StructuredValue) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		sv.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		sv.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		sv.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		sv.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		sv.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		sv.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		sv.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		sv.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		sv.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		sv.Type = _type
	}

	return nil
}

// BasicThing
type BasicThing interface {
	AsImageObject() (*ImageObject, bool)
	AsPostalAddress() (*PostalAddress, bool)
	AsPlace() (*Place, bool)
	AsBasicPlace() (BasicPlace, bool)
	AsOrganization() (*Organization, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsMovieTheater() (*MovieTheater, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsCivicStructure() (*CivicStructure, bool)
	AsBasicCivicStructure() (BasicCivicStructure, bool)
	AsLocalBusiness() (*LocalBusiness, bool)
	AsBasicLocalBusiness() (BasicLocalBusiness, bool)
	AsTouristAttraction() (*TouristAttraction, bool)
	AsAirport() (*Airport, bool)
	AsLicense() (*License, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsEntertainmentBusiness() (*EntertainmentBusiness, bool)
	AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool)
	AsFoodEstablishment() (*FoodEstablishment, bool)
	AsBasicFoodEstablishment() (BasicFoodEstablishment, bool)
	AsLodgingBusiness() (*LodgingBusiness, bool)
	AsBasicLodgingBusiness() (BasicLodgingBusiness, bool)
	AsRestaurant() (*Restaurant, bool)
	AsHotel() (*Hotel, bool)
	AsThing() (*Thing, bool)
}

// Thing
type Thing struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
}

func unmarshalBasicThing(body []byte) (BasicThing, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypePostalAddress):
		var pa PostalAddress
		err := json.Unmarshal(body, &pa)
		return pa, err
	case string(TypePlace):
		var p Place
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeOrganization):
		var o Organization
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeMovieTheater):
		var mt MovieTheater
		err := json.Unmarshal(body, &mt)
		return mt, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeCivicStructure):
		var cs CivicStructure
		err := json.Unmarshal(body, &cs)
		return cs, err
	case string(TypeLocalBusiness):
		var lb LocalBusiness
		err := json.Unmarshal(body, &lb)
		return lb, err
	case string(TypeTouristAttraction):
		var ta TouristAttraction
		err := json.Unmarshal(body, &ta)
		return ta, err
	case string(TypeAirport):
		var a Airport
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeLicense):
		var l License
		err := json.Unmarshal(body, &l)
		return l, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	case string(TypeEntertainmentBusiness):
		var eb EntertainmentBusiness
		err := json.Unmarshal(body, &eb)
		return eb, err
	case string(TypeFoodEstablishment):
		var fe FoodEstablishment
		err := json.Unmarshal(body, &fe)
		return fe, err
	case string(TypeLodgingBusiness):
		var lb LodgingBusiness
		err := json.Unmarshal(body, &lb)
		return lb, err
	case string(TypeRestaurant):
		var r Restaurant
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeHotel):
		var h Hotel
		err := json.Unmarshal(body, &h)
		return h, err
	default:
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	}
}
func unmarshalBasicThingArray(body []byte) ([]BasicThing, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tArray := make([]BasicThing, len(rawMessages))

	for index, rawMessage := range rawMessages {
		t, err := unmarshalBasicThing(*rawMessage)
		if err != nil {
			return nil, err
		}
		tArray[index] = t
	}
	return tArray, nil
}

// MarshalJSON is the custom marshaler for Thing.
func (t Thing) MarshalJSON() ([]byte, error) {
	t.Type = TypeThing
	type Alias Thing
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(t),
	})
}

// AsImageObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsThing() (*Thing, bool) {
	return &t, true
}

// AsBasicThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicThing() (BasicThing, bool) {
	return &t, true
}

// AsEntities is the BasicResponseBase implementation for Thing.
func (t Thing) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for Thing.
func (t Thing) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponse() (BasicResponse, bool) {
	return &t, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &t, true
}

// AsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for Thing.
func (t Thing) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for Thing.
func (t Thing) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicPlace() (BasicPlace, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Thing.
func (t Thing) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Thing.
func (t Thing) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for Thing.
func (t Thing) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for Thing.
func (t Thing) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for Thing.
func (t Thing) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for Thing.
func (t Thing) AsTouristAttraction() (*TouristAttraction, bool) {
	return nil, false
}

// AsAirport is the BasicResponseBase implementation for Thing.
func (t Thing) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for Thing.
func (t Thing) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Thing.
func (t Thing) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for Thing.
func (t Thing) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for Thing.
func (t Thing) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for Thing.
func (t Thing) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for Thing.
func (t Thing) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for Thing.
func (t Thing) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &t, true
}

// UnmarshalJSON is the custom unmarshaler for Thing struct.
func (t *Thing) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		t.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		t.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		t.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		t.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		t.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		t.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		t.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		t.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		t.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		t.Type = _type
	}

	return nil
}

// TouristAttraction ...
type TouristAttraction struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeImageObject', 'TypeThing', 'TypeEntities', 'TypePlaces', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeAnswer', 'TypeErrorResponse', 'TypePostalAddress', 'TypePlace', 'TypeOrganization', 'TypeCreativeWork', 'TypeIntangible', 'TypeMovieTheater', 'TypeMediaObject', 'TypeCivicStructure', 'TypeLocalBusiness', 'TypeTouristAttraction', 'TypeAirport', 'TypeLicense', 'TypeStructuredValue', 'TypeEntertainmentBusiness', 'TypeFoodEstablishment', 'TypeLodgingBusiness', 'TypeRestaurant', 'TypeHotel'
	Type TypeBasicResponseBase `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// ContractualRules - A list of rules that you must adhere to if you display the item.
	ContractualRules *[]BasicContractualRulesContractualRule `json:"contractualRules,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL   *string      `json:"url,omitempty"`
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// EntityPresentationInfo - Additional information about the entity such as hints that you can use to determine the entity's type. To determine the entity's type, use the entityScenario and entityTypeHint fields.
	EntityPresentationInfo *EntitiesEntityPresentationInfo `json:"entityPresentationInfo,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// Address - The postal address of where the entity is located
	Address *PostalAddress `json:"address,omitempty"`
	// Telephone - The entity's telephone number
	Telephone *string `json:"telephone,omitempty"`
}

// MarshalJSON is the custom marshaler for TouristAttraction.
func (ta TouristAttraction) MarshalJSON() ([]byte, error) {
	ta.Type = TypeTouristAttraction
	type Alias TouristAttraction
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ta),
	})
}

// AsImageObject is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsBasicThing() (BasicThing, bool) {
	return &ta, true
}

// AsEntities is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsEntities() (*Entities, bool) {
	return nil, false
}

// AsPlaces is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsPlaces() (*Places, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsBasicResponse() (BasicResponse, bool) {
	return &ta, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ta, true
}

// AsAnswer is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsPostalAddress is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsPostalAddress() (*PostalAddress, bool) {
	return nil, false
}

// AsPlace is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsPlace() (*Place, bool) {
	return nil, false
}

// AsBasicPlace is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsBasicPlace() (BasicPlace, bool) {
	return &ta, true
}

// AsOrganization is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsMovieTheater is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsMovieTheater() (*MovieTheater, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCivicStructure is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsCivicStructure() (*CivicStructure, bool) {
	return nil, false
}

// AsBasicCivicStructure is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsBasicCivicStructure() (BasicCivicStructure, bool) {
	return nil, false
}

// AsLocalBusiness is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsLocalBusiness() (*LocalBusiness, bool) {
	return nil, false
}

// AsBasicLocalBusiness is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsBasicLocalBusiness() (BasicLocalBusiness, bool) {
	return nil, false
}

// AsTouristAttraction is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsTouristAttraction() (*TouristAttraction, bool) {
	return &ta, true
}

// AsAirport is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsAirport() (*Airport, bool) {
	return nil, false
}

// AsLicense is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsLicense() (*License, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsEntertainmentBusiness is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsEntertainmentBusiness() (*EntertainmentBusiness, bool) {
	return nil, false
}

// AsBasicEntertainmentBusiness is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsBasicEntertainmentBusiness() (BasicEntertainmentBusiness, bool) {
	return nil, false
}

// AsFoodEstablishment is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsFoodEstablishment() (*FoodEstablishment, bool) {
	return nil, false
}

// AsBasicFoodEstablishment is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsBasicFoodEstablishment() (BasicFoodEstablishment, bool) {
	return nil, false
}

// AsLodgingBusiness is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsLodgingBusiness() (*LodgingBusiness, bool) {
	return nil, false
}

// AsBasicLodgingBusiness is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsBasicLodgingBusiness() (BasicLodgingBusiness, bool) {
	return nil, false
}

// AsRestaurant is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsRestaurant() (*Restaurant, bool) {
	return nil, false
}

// AsHotel is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsHotel() (*Hotel, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for TouristAttraction.
func (ta TouristAttraction) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ta, true
}

// UnmarshalJSON is the custom unmarshaler for TouristAttraction struct.
func (ta *TouristAttraction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["address"]
	if v != nil {
		var address PostalAddress
		err = json.Unmarshal(*m["address"], &address)
		if err != nil {
			return err
		}
		ta.Address = &address
	}

	v = m["telephone"]
	if v != nil {
		var telephone string
		err = json.Unmarshal(*m["telephone"], &telephone)
		if err != nil {
			return err
		}
		ta.Telephone = &telephone
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		ta.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		ta.URL = &URLVar
	}

	v = m["image"]
	if v != nil {
		var imageVar ImageObject
		err = json.Unmarshal(*m["image"], &imageVar)
		if err != nil {
			return err
		}
		ta.Image = &imageVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		ta.Description = &description
	}

	v = m["entityPresentationInfo"]
	if v != nil {
		var entityPresentationInfo EntitiesEntityPresentationInfo
		err = json.Unmarshal(*m["entityPresentationInfo"], &entityPresentationInfo)
		if err != nil {
			return err
		}
		ta.EntityPresentationInfo = &entityPresentationInfo
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		ta.BingID = &bingID
	}

	v = m["contractualRules"]
	if v != nil {
		contractualRules, err := unmarshalBasicContractualRulesContractualRuleArray(*m["contractualRules"])
		if err != nil {
			return err
		}
		ta.ContractualRules = &contractualRules
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		ta.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		ta.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type TypeBasicResponseBase
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		ta.Type = _type
	}

	return nil
}
