package commerce

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"net/http"
)

// UsageAggregatesClient is the client for the UsageAggregates methods of the Commerce service.
type UsageAggregatesClient struct {
	BaseClient
}

// NewUsageAggregatesClient creates an instance of the UsageAggregatesClient client.
func NewUsageAggregatesClient(subscriptionID string) UsageAggregatesClient {
	return NewUsageAggregatesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewUsageAggregatesClientWithBaseURI creates an instance of the UsageAggregatesClient client.
func NewUsageAggregatesClientWithBaseURI(baseURI string, subscriptionID string) UsageAggregatesClient {
	return UsageAggregatesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// List query aggregated Azure subscription consumption data for a date range.
//
// reportedStartTime is the start of the time range to retrieve data for. reportedEndTime is the end of the time range
// to retrieve data for. showDetails is `True` returns usage data in instance-level detail, `false` causes server-side
// aggregation with fewer details. For example, if you have 3 website instances, by default you will get 3 line items
// for website consumption. If you specify showDetails = false, the data will be aggregated as a single line item for
// website consumption within the time period (for the given subscriptionId, meterId, usageStartTime and usageEndTime).
// aggregationGranularity is `Daily` (default) returns the data in daily granularity, `Hourly` returns the data in
// hourly granularity. continuationToken is used when a continuation token string is provided in the response body of
// the previous call, enabling paging through a large result set. If not present, the data is retrieved from the
// beginning of the day/hour (based on the granularity) passed in.
func (client UsageAggregatesClient) List(ctx context.Context, reportedStartTime date.Time, reportedEndTime date.Time, showDetails *bool, aggregationGranularity AggregationGranularity, continuationToken string) (result UsageAggregationListResultPage, err error) {
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, reportedStartTime, reportedEndTime, showDetails, aggregationGranularity, continuationToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "commerce.UsageAggregatesClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.ualr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "commerce.UsageAggregatesClient", "List", resp, "Failure sending request")
		return
	}

	result.ualr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "commerce.UsageAggregatesClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client UsageAggregatesClient) ListPreparer(ctx context.Context, reportedStartTime date.Time, reportedEndTime date.Time, showDetails *bool, aggregationGranularity AggregationGranularity, continuationToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version":       APIVersion,
		"reportedEndTime":   autorest.Encode("query", reportedEndTime),
		"reportedStartTime": autorest.Encode("query", reportedStartTime),
	}
	if showDetails != nil {
		queryParameters["showDetails"] = autorest.Encode("query", *showDetails)
	}
	if len(string(aggregationGranularity)) > 0 {
		queryParameters["aggregationGranularity"] = autorest.Encode("query", aggregationGranularity)
	}
	if len(continuationToken) > 0 {
		queryParameters["continuationToken"] = autorest.Encode("query", continuationToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Commerce/UsageAggregates", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client UsageAggregatesClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client UsageAggregatesClient) ListResponder(resp *http.Response) (result UsageAggregationListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client UsageAggregatesClient) listNextResults(lastResults UsageAggregationListResult) (result UsageAggregationListResult, err error) {
	req, err := lastResults.usageAggregationListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "commerce.UsageAggregatesClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "commerce.UsageAggregatesClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "commerce.UsageAggregatesClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client UsageAggregatesClient) ListComplete(ctx context.Context, reportedStartTime date.Time, reportedEndTime date.Time, showDetails *bool, aggregationGranularity AggregationGranularity, continuationToken string) (result UsageAggregationListResultIterator, err error) {
	result.page, err = client.List(ctx, reportedStartTime, reportedEndTime, showDetails, aggregationGranularity, continuationToken)
	return
}
