package customsearch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
)

// ErrorCode enumerates the values for error code.
type ErrorCode string

const (
	// InsufficientAuthorization ...
	InsufficientAuthorization ErrorCode = "InsufficientAuthorization"
	// InvalidAuthorization ...
	InvalidAuthorization ErrorCode = "InvalidAuthorization"
	// InvalidRequest ...
	InvalidRequest ErrorCode = "InvalidRequest"
	// None ...
	None ErrorCode = "None"
	// RateLimitExceeded ...
	RateLimitExceeded ErrorCode = "RateLimitExceeded"
	// ServerError ...
	ServerError ErrorCode = "ServerError"
)

// ErrorSubCode enumerates the values for error sub code.
type ErrorSubCode string

const (
	// AuthorizationDisabled ...
	AuthorizationDisabled ErrorSubCode = "AuthorizationDisabled"
	// AuthorizationExpired ...
	AuthorizationExpired ErrorSubCode = "AuthorizationExpired"
	// AuthorizationMissing ...
	AuthorizationMissing ErrorSubCode = "AuthorizationMissing"
	// AuthorizationRedundancy ...
	AuthorizationRedundancy ErrorSubCode = "AuthorizationRedundancy"
	// Blocked ...
	Blocked ErrorSubCode = "Blocked"
	// HTTPNotAllowed ...
	HTTPNotAllowed ErrorSubCode = "HttpNotAllowed"
	// NotImplemented ...
	NotImplemented ErrorSubCode = "NotImplemented"
	// ParameterInvalidValue ...
	ParameterInvalidValue ErrorSubCode = "ParameterInvalidValue"
	// ParameterMissing ...
	ParameterMissing ErrorSubCode = "ParameterMissing"
	// ResourceError ...
	ResourceError ErrorSubCode = "ResourceError"
	// UnexpectedError ...
	UnexpectedError ErrorSubCode = "UnexpectedError"
)

// SafeSearch enumerates the values for safe search.
type SafeSearch string

const (
	// Moderate ...
	Moderate SafeSearch = "Moderate"
	// Off ...
	Off SafeSearch = "Off"
	// Strict ...
	Strict SafeSearch = "Strict"
)

// TextFormat enumerates the values for text format.
type TextFormat string

const (
	// HTML ...
	HTML TextFormat = "Html"
	// Raw ...
	Raw TextFormat = "Raw"
)

// Type enumerates the values for type.
type Type string

const (
	// TypeAnswer ...
	TypeAnswer Type = "Answer"
	// TypeCreativeWork ...
	TypeCreativeWork Type = "CreativeWork"
	// TypeErrorResponse ...
	TypeErrorResponse Type = "ErrorResponse"
	// TypeIdentifiable ...
	TypeIdentifiable Type = "Identifiable"
	// TypeResponse ...
	TypeResponse Type = "Response"
	// TypeResponseBase ...
	TypeResponseBase Type = "ResponseBase"
	// TypeSearchResponse ...
	TypeSearchResponse Type = "SearchResponse"
	// TypeSearchResultsAnswer ...
	TypeSearchResultsAnswer Type = "SearchResultsAnswer"
	// TypeThing ...
	TypeThing Type = "Thing"
	// TypeWebPage ...
	TypeWebPage Type = "WebPage"
	// TypeWebWebAnswer ...
	TypeWebWebAnswer Type = "Web/WebAnswer"
)

// BasicAnswer
type BasicAnswer interface {
	AsWebWebAnswer() (*WebWebAnswer, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsAnswer() (*Answer, bool)
}

// Answer
type Answer struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeAnswer', 'TypeThing', 'TypeCreativeWork'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL    *string  `json:"webSearchUrl,omitempty"`
	FollowUpQueries *[]Query `json:"followUpQueries,omitempty"`
}

func unmarshalBasicAnswer(body []byte) (BasicAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeWebWebAnswer):
		var wwa WebWebAnswer
		err := json.Unmarshal(body, &wwa)
		return wwa, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	default:
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicAnswerArray(body []byte) ([]BasicAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Answer.
func (a Answer) MarshalJSON() ([]byte, error) {
	a.Type = TypeAnswer
	type Alias Answer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(a),
	})
}

// AsWebPage is the BasicResponseBase implementation for Answer.
func (a Answer) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponse() (BasicResponse, bool) {
	return &a, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &a, true
}

// AsErrorResponse is the BasicResponseBase implementation for Answer.
func (a Answer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsAnswer() (*Answer, bool) {
	return &a, true
}

// AsBasicAnswer is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicAnswer() (BasicAnswer, bool) {
	return &a, true
}

// AsThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Answer.
func (a Answer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &a, true
}

// BasicCreativeWork
type BasicCreativeWork interface {
	AsWebPage() (*WebPage, bool)
	AsCreativeWork() (*CreativeWork, bool)
}

// CreativeWork
type CreativeWork struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeAnswer', 'TypeThing', 'TypeCreativeWork'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Text     *string       `json:"text,omitempty"`
}

func unmarshalBasicCreativeWork(body []byte) (BasicCreativeWork, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	default:
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	}
}
func unmarshalBasicCreativeWorkArray(body []byte) ([]BasicCreativeWork, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cwArray := make([]BasicCreativeWork, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cw, err := unmarshalBasicCreativeWork(*rawMessage)
		if err != nil {
			return nil, err
		}
		cwArray[index] = cw
	}
	return cwArray, nil
}

// MarshalJSON is the custom marshaler for CreativeWork.
func (cw CreativeWork) MarshalJSON() ([]byte, error) {
	cw.Type = TypeCreativeWork
	type Alias CreativeWork
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cw),
	})
}

// AsWebPage is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponse() (BasicResponse, bool) {
	return &cw, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &cw, true
}

// AsErrorResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicThing() (BasicThing, bool) {
	return &cw, true
}

// AsCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsCreativeWork() (*CreativeWork, bool) {
	return &cw, true
}

// AsBasicCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &cw, true
}

// AsResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &cw, true
}

// UnmarshalJSON is the custom unmarshaler for CreativeWork struct.
func (cw *CreativeWork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		cw.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		cw.Provider = &provider
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		cw.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		cw.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		cw.URL = &URLVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		cw.Description = &description
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		cw.BingID = &bingID
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		cw.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		cw.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type Type
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		cw.Type = _type
	}

	return nil
}

// Error defines the error that occurred.
type Error struct {
	// Code - The error code that identifies the category of error. Possible values include: 'None', 'ServerError', 'InvalidRequest', 'RateLimitExceeded', 'InvalidAuthorization', 'InsufficientAuthorization'
	Code ErrorCode `json:"code,omitempty"`
	// SubCode - The error code that further helps to identify the error. Possible values include: 'UnexpectedError', 'ResourceError', 'NotImplemented', 'ParameterMissing', 'ParameterInvalidValue', 'HTTPNotAllowed', 'Blocked', 'AuthorizationMissing', 'AuthorizationRedundancy', 'AuthorizationDisabled', 'AuthorizationExpired'
	SubCode ErrorSubCode `json:"subCode,omitempty"`
	// Message - A description of the error.
	Message *string `json:"message,omitempty"`
	// MoreDetails - A description that provides additional information about the error.
	MoreDetails *string `json:"moreDetails,omitempty"`
	// Parameter - The parameter in the request that caused the error.
	Parameter *string `json:"parameter,omitempty"`
	// Value - The parameter's value in the request that was not valid.
	Value *string `json:"value,omitempty"`
}

// ErrorResponse the top-level response that represents a failed request.
type ErrorResponse struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeAnswer', 'TypeThing', 'TypeCreativeWork'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Errors - A list of errors that describe the reasons why the request failed.
	Errors *[]Error `json:"errors,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	er.Type = TypeErrorResponse
	type Alias ErrorResponse
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(er),
	})
}

// AsWebPage is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponse() (BasicResponse, bool) {
	return &er, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &er, true
}

// AsErrorResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsErrorResponse() (*ErrorResponse, bool) {
	return &er, true
}

// AsAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &er, true
}

// BasicIdentifiable defines the identity of a resource.
type BasicIdentifiable interface {
	AsWebPage() (*WebPage, bool)
	AsWebWebAnswer() (*WebWebAnswer, bool)
	AsSearchResponse() (*SearchResponse, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsIdentifiable() (*Identifiable, bool)
}

// Identifiable defines the identity of a resource.
type Identifiable struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeAnswer', 'TypeThing', 'TypeCreativeWork'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
}

func unmarshalBasicIdentifiable(body []byte) (BasicIdentifiable, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	case string(TypeWebWebAnswer):
		var wwa WebWebAnswer
		err := json.Unmarshal(body, &wwa)
		return wwa, err
	case string(TypeSearchResponse):
		var sr SearchResponse
		err := json.Unmarshal(body, &sr)
		return sr, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	default:
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	}
}
func unmarshalBasicIdentifiableArray(body []byte) ([]BasicIdentifiable, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iArray := make([]BasicIdentifiable, len(rawMessages))

	for index, rawMessage := range rawMessages {
		i, err := unmarshalBasicIdentifiable(*rawMessage)
		if err != nil {
			return nil, err
		}
		iArray[index] = i
	}
	return iArray, nil
}

// MarshalJSON is the custom marshaler for Identifiable.
func (i Identifiable) MarshalJSON() ([]byte, error) {
	i.Type = TypeIdentifiable
	type Alias Identifiable
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(i),
	})
}

// AsWebPage is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsIdentifiable() (*Identifiable, bool) {
	return &i, true
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsErrorResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// Query defines a search query.
type Query struct {
	// Text - The query string. Use this string as the query term in a new search request.
	Text *string `json:"text,omitempty"`
	// DisplayText - The display version of the query term. This version of the query term may contain special characters that highlight the search term found in the query string. The string contains the highlighting characters only if the query enabled hit highlighting
	DisplayText *string `json:"displayText,omitempty"`
	// WebSearchURL - The URL that takes the user to the Bing search results page for the query.Only related search results include this field.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	SearchLink   *string `json:"searchLink,omitempty"`
}

// QueryContext defines the query context that Bing used for the request.
type QueryContext struct {
	// OriginalQuery - The query string as specified in the request.
	OriginalQuery *string `json:"originalQuery,omitempty"`
	// AlteredQuery - The query string used by Bing to perform the query. Bing uses the altered query string if the original query string contained spelling mistakes. For example, if the query string is "saling downwind", the altered query string will be "sailing downwind". This field is included only if the original query string contains a spelling mistake.
	AlteredQuery *string `json:"alteredQuery,omitempty"`
	// AlterationOverrideQuery - The query string to use to force Bing to use the original string. For example, if the query string is "saling downwind", the override query string will be "+saling downwind". Remember to encode the query string which results in "%2Bsaling+downwind". This field is included only if the original query string contains a spelling mistake.
	AlterationOverrideQuery *string `json:"alterationOverrideQuery,omitempty"`
	// AdultIntent - A Boolean value that indicates whether the specified query has adult intent. The value is true if the query has adult intent; otherwise, false.
	AdultIntent *bool `json:"adultIntent,omitempty"`
}

// BasicResponse defines a response. All schemas that could be returned at the root of a response should inherit from
// this
type BasicResponse interface {
	AsWebPage() (*WebPage, bool)
	AsWebWebAnswer() (*WebWebAnswer, bool)
	AsSearchResponse() (*SearchResponse, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsResponse() (*Response, bool)
}

// Response defines a response. All schemas that could be returned at the root of a response should inherit from this
type Response struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeAnswer', 'TypeThing', 'TypeCreativeWork'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
}

func unmarshalBasicResponse(body []byte) (BasicResponse, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	case string(TypeWebWebAnswer):
		var wwa WebWebAnswer
		err := json.Unmarshal(body, &wwa)
		return wwa, err
	case string(TypeSearchResponse):
		var sr SearchResponse
		err := json.Unmarshal(body, &sr)
		return sr, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	default:
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicResponseArray(body []byte) ([]BasicResponse, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicResponse, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicResponse(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Response.
func (r Response) MarshalJSON() ([]byte, error) {
	r.Type = TypeResponse
	type Alias Response
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(r),
	})
}

// AsWebPage is the BasicResponseBase implementation for Response.
func (r Response) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Response.
func (r Response) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Response.
func (r Response) AsResponse() (*Response, bool) {
	return &r, true
}

// AsBasicResponse is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponse() (BasicResponse, bool) {
	return &r, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &r, true
}

// AsErrorResponse is the BasicResponseBase implementation for Response.
func (r Response) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Response.
func (r Response) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Response.
func (r Response) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &r, true
}

// BasicResponseBase
type BasicResponseBase interface {
	AsWebPage() (*WebPage, bool)
	AsWebWebAnswer() (*WebWebAnswer, bool)
	AsSearchResponse() (*SearchResponse, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
	AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool)
	AsIdentifiable() (*Identifiable, bool)
	AsBasicIdentifiable() (BasicIdentifiable, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsAnswer() (*Answer, bool)
	AsBasicAnswer() (BasicAnswer, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsResponseBase() (*ResponseBase, bool)
}

// ResponseBase
type ResponseBase struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeAnswer', 'TypeThing', 'TypeCreativeWork'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicResponseBase(body []byte) (BasicResponseBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	case string(TypeWebWebAnswer):
		var wwa WebWebAnswer
		err := json.Unmarshal(body, &wwa)
		return wwa, err
	case string(TypeSearchResponse):
		var sr SearchResponse
		err := json.Unmarshal(body, &sr)
		return sr, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeSearchResultsAnswer):
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	case string(TypeIdentifiable):
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeAnswer):
		var a Answer
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	default:
		var rb ResponseBase
		err := json.Unmarshal(body, &rb)
		return rb, err
	}
}
func unmarshalBasicResponseBaseArray(body []byte) ([]BasicResponseBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rbArray := make([]BasicResponseBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rb, err := unmarshalBasicResponseBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		rbArray[index] = rb
	}
	return rbArray, nil
}

// MarshalJSON is the custom marshaler for ResponseBase.
func (rb ResponseBase) MarshalJSON() ([]byte, error) {
	rb.Type = TypeResponseBase
	type Alias ResponseBase
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rb),
	})
}

// AsWebPage is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponseBase() (*ResponseBase, bool) {
	return &rb, true
}

// AsBasicResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &rb, true
}

// SearchResponse defines the top-level object that the response includes when the request succeeds.
type SearchResponse struct {
	autorest.Response `json:"-"`
	// Type - Possible values include: 'TypeResponseBase', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeAnswer', 'TypeThing', 'TypeCreativeWork'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// QueryContext - An object that contains the query string that Bing used for the request. This object contains the query string as entered by the user. It may also contain an altered query string that Bing used for the query if the query string contained a spelling mistake.
	QueryContext *QueryContext `json:"queryContext,omitempty"`
	// WebPages - A list of webpages that are relevant to the search query.
	WebPages *WebWebAnswer `json:"webPages,omitempty"`
}

// MarshalJSON is the custom marshaler for SearchResponse.
func (sr SearchResponse) MarshalJSON() ([]byte, error) {
	sr.Type = TypeSearchResponse
	type Alias SearchResponse
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sr),
	})
}

// AsWebPage is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsSearchResponse() (*SearchResponse, bool) {
	return &sr, true
}

// AsResponse is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicResponse() (BasicResponse, bool) {
	return &sr, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sr, true
}

// AsErrorResponse is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for SearchResponse.
func (sr SearchResponse) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sr, true
}

// BasicSearchResultsAnswer
type BasicSearchResultsAnswer interface {
	AsWebWebAnswer() (*WebWebAnswer, bool)
	AsSearchResultsAnswer() (*SearchResultsAnswer, bool)
}

// SearchResultsAnswer
type SearchResultsAnswer struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeAnswer', 'TypeThing', 'TypeCreativeWork'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL    *string       `json:"webSearchUrl,omitempty"`
	FollowUpQueries *[]Query      `json:"followUpQueries,omitempty"`
	QueryContext    *QueryContext `json:"queryContext,omitempty"`
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	IsFamilyFriendly      *bool  `json:"isFamilyFriendly,omitempty"`
}

func unmarshalBasicSearchResultsAnswer(body []byte) (BasicSearchResultsAnswer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeWebWebAnswer):
		var wwa WebWebAnswer
		err := json.Unmarshal(body, &wwa)
		return wwa, err
	default:
		var sra SearchResultsAnswer
		err := json.Unmarshal(body, &sra)
		return sra, err
	}
}
func unmarshalBasicSearchResultsAnswerArray(body []byte) ([]BasicSearchResultsAnswer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sraArray := make([]BasicSearchResultsAnswer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sra, err := unmarshalBasicSearchResultsAnswer(*rawMessage)
		if err != nil {
			return nil, err
		}
		sraArray[index] = sra
	}
	return sraArray, nil
}

// MarshalJSON is the custom marshaler for SearchResultsAnswer.
func (sra SearchResultsAnswer) MarshalJSON() ([]byte, error) {
	sra.Type = TypeSearchResultsAnswer
	type Alias SearchResultsAnswer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sra),
	})
}

// AsWebPage is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponse() (BasicResponse, bool) {
	return &sra, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return &sra, true
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &sra, true
}

// AsIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sra, true
}

// AsErrorResponse is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicAnswer() (BasicAnswer, bool) {
	return &sra, true
}

// AsThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for SearchResultsAnswer.
func (sra SearchResultsAnswer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sra, true
}

// BasicThing
type BasicThing interface {
	AsWebPage() (*WebPage, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsThing() (*Thing, bool)
}

// Thing
type Thing struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeAnswer', 'TypeThing', 'TypeCreativeWork'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
}

func unmarshalBasicThing(body []byte) (BasicThing, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeWebPage):
		var wp WebPage
		err := json.Unmarshal(body, &wp)
		return wp, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	default:
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	}
}
func unmarshalBasicThingArray(body []byte) ([]BasicThing, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tArray := make([]BasicThing, len(rawMessages))

	for index, rawMessage := range rawMessages {
		t, err := unmarshalBasicThing(*rawMessage)
		if err != nil {
			return nil, err
		}
		tArray[index] = t
	}
	return tArray, nil
}

// MarshalJSON is the custom marshaler for Thing.
func (t Thing) MarshalJSON() ([]byte, error) {
	t.Type = TypeThing
	type Alias Thing
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(t),
	})
}

// AsWebPage is the BasicResponseBase implementation for Thing.
func (t Thing) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponse() (BasicResponse, bool) {
	return &t, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &t, true
}

// AsErrorResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsThing() (*Thing, bool) {
	return &t, true
}

// AsBasicThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicThing() (BasicThing, bool) {
	return &t, true
}

// AsCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &t, true
}

// WebMetaTag defines a webpage's metadata.
type WebMetaTag struct {
	// Name - The metadata.
	Name *string `json:"name,omitempty"`
	// Content - The name of the metadata.
	Content *string `json:"content,omitempty"`
}

// WebPage defines a webpage that is relevant to the query.
type WebPage struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeAnswer', 'TypeThing', 'TypeCreativeWork'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	Text     *string       `json:"text,omitempty"`
	// DisplayURL - The display URL of the webpage. The URL is meant for display purposes only and is not well formed.
	DisplayURL *string `json:"displayUrl,omitempty"`
	// Snippet - A snippet of text from the webpage that describes its contents.
	Snippet *string `json:"snippet,omitempty"`
	// DeepLinks - A list of links to related content that Bing found in the website that contains this webpage. The Webpage object in this context includes only the name, url, urlPingSuffix, and snippet fields.
	DeepLinks *[]WebPage `json:"deepLinks,omitempty"`
	// DateLastCrawled - The last time that Bing crawled the webpage. The date is in the form, YYYY-MM-DDTHH:MM:SS. For example, 2015-04-13T05:23:39.
	DateLastCrawled *string `json:"dateLastCrawled,omitempty"`
	// SearchTags - A list of search tags that the webpage owner specified on the webpage. The API returns only indexed search tags. The name field of the MetaTag object contains the indexed search tag. Search tags begin with search.* (for example, search.assetId). The content field contains the tag's value.
	SearchTags *[]WebMetaTag `json:"searchTags,omitempty"`
}

// MarshalJSON is the custom marshaler for WebPage.
func (wp WebPage) MarshalJSON() ([]byte, error) {
	wp.Type = TypeWebPage
	type Alias WebPage
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(wp),
	})
}

// AsWebPage is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsWebPage() (*WebPage, bool) {
	return &wp, true
}

// AsWebWebAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return nil, false
}

// AsSearchResponse is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicResponse() (BasicResponse, bool) {
	return &wp, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &wp, true
}

// AsErrorResponse is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicAnswer() (BasicAnswer, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicThing() (BasicThing, bool) {
	return &wp, true
}

// AsCreativeWork is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &wp, true
}

// AsResponseBase is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for WebPage.
func (wp WebPage) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &wp, true
}

// UnmarshalJSON is the custom unmarshaler for WebPage struct.
func (wp *WebPage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["displayUrl"]
	if v != nil {
		var displayURL string
		err = json.Unmarshal(*m["displayUrl"], &displayURL)
		if err != nil {
			return err
		}
		wp.DisplayURL = &displayURL
	}

	v = m["snippet"]
	if v != nil {
		var snippet string
		err = json.Unmarshal(*m["snippet"], &snippet)
		if err != nil {
			return err
		}
		wp.Snippet = &snippet
	}

	v = m["deepLinks"]
	if v != nil {
		var deepLinks []WebPage
		err = json.Unmarshal(*m["deepLinks"], &deepLinks)
		if err != nil {
			return err
		}
		wp.DeepLinks = &deepLinks
	}

	v = m["dateLastCrawled"]
	if v != nil {
		var dateLastCrawled string
		err = json.Unmarshal(*m["dateLastCrawled"], &dateLastCrawled)
		if err != nil {
			return err
		}
		wp.DateLastCrawled = &dateLastCrawled
	}

	v = m["searchTags"]
	if v != nil {
		var searchTags []WebMetaTag
		err = json.Unmarshal(*m["searchTags"], &searchTags)
		if err != nil {
			return err
		}
		wp.SearchTags = &searchTags
	}

	v = m["thumbnailUrl"]
	if v != nil {
		var thumbnailURL string
		err = json.Unmarshal(*m["thumbnailUrl"], &thumbnailURL)
		if err != nil {
			return err
		}
		wp.ThumbnailURL = &thumbnailURL
	}

	v = m["provider"]
	if v != nil {
		provider, err := unmarshalBasicThingArray(*m["provider"])
		if err != nil {
			return err
		}
		wp.Provider = &provider
	}

	v = m["text"]
	if v != nil {
		var textVar string
		err = json.Unmarshal(*m["text"], &textVar)
		if err != nil {
			return err
		}
		wp.Text = &textVar
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		wp.Name = &name
	}

	v = m["url"]
	if v != nil {
		var URLVar string
		err = json.Unmarshal(*m["url"], &URLVar)
		if err != nil {
			return err
		}
		wp.URL = &URLVar
	}

	v = m["description"]
	if v != nil {
		var description string
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		wp.Description = &description
	}

	v = m["bingId"]
	if v != nil {
		var bingID string
		err = json.Unmarshal(*m["bingId"], &bingID)
		if err != nil {
			return err
		}
		wp.BingID = &bingID
	}

	v = m["webSearchUrl"]
	if v != nil {
		var webSearchURL string
		err = json.Unmarshal(*m["webSearchUrl"], &webSearchURL)
		if err != nil {
			return err
		}
		wp.WebSearchURL = &webSearchURL
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		wp.ID = &ID
	}

	v = m["_type"]
	if v != nil {
		var _type Type
		err = json.Unmarshal(*m["_type"], &_type)
		if err != nil {
			return err
		}
		wp.Type = _type
	}

	return nil
}

// WebWebAnswer defines a list of relevant webpage links.
type WebWebAnswer struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypeWebPage', 'TypeWebWebAnswer', 'TypeSearchResponse', 'TypeResponse', 'TypeSearchResultsAnswer', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeAnswer', 'TypeThing', 'TypeCreativeWork'
	Type Type `json:"_type,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// WebSearchURL - The URL To Bing's search result for this item.
	WebSearchURL    *string       `json:"webSearchUrl,omitempty"`
	FollowUpQueries *[]Query      `json:"followUpQueries,omitempty"`
	QueryContext    *QueryContext `json:"queryContext,omitempty"`
	// TotalEstimatedMatches - The estimated number of webpages that are relevant to the query. Use this number along with the count and offset query parameters to page the results.
	TotalEstimatedMatches *int64 `json:"totalEstimatedMatches,omitempty"`
	IsFamilyFriendly      *bool  `json:"isFamilyFriendly,omitempty"`
	// Value - A list of webpages that are relevant to the query.
	Value *[]WebPage `json:"value,omitempty"`
	// SomeResultsRemoved - A Boolean value that indicates whether the response excluded some results from the answer. If Bing excluded some results, the value is true.
	SomeResultsRemoved *bool `json:"someResultsRemoved,omitempty"`
}

// MarshalJSON is the custom marshaler for WebWebAnswer.
func (wwa WebWebAnswer) MarshalJSON() ([]byte, error) {
	wwa.Type = TypeWebWebAnswer
	type Alias WebWebAnswer
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(wwa),
	})
}

// AsWebPage is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsWebPage() (*WebPage, bool) {
	return nil, false
}

// AsWebWebAnswer is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsWebWebAnswer() (*WebWebAnswer, bool) {
	return &wwa, true
}

// AsSearchResponse is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsSearchResponse() (*SearchResponse, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsBasicResponse() (BasicResponse, bool) {
	return &wwa, true
}

// AsSearchResultsAnswer is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsSearchResultsAnswer() (*SearchResultsAnswer, bool) {
	return nil, false
}

// AsBasicSearchResultsAnswer is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsBasicSearchResultsAnswer() (BasicSearchResultsAnswer, bool) {
	return &wwa, true
}

// AsIdentifiable is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &wwa, true
}

// AsErrorResponse is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsAnswer is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsAnswer() (*Answer, bool) {
	return nil, false
}

// AsBasicAnswer is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsBasicAnswer() (BasicAnswer, bool) {
	return &wwa, true
}

// AsThing is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for WebWebAnswer.
func (wwa WebWebAnswer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &wwa, true
}
