package runtime

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

// AzureRegions enumerates the values for azure regions.
type AzureRegions string

const (
	// Australiaeast ...
	Australiaeast AzureRegions = "australiaeast"
	// Brazilsouth ...
	Brazilsouth AzureRegions = "brazilsouth"
	// Eastasia ...
	Eastasia AzureRegions = "eastasia"
	// Eastus ...
	Eastus AzureRegions = "eastus"
	// Eastus2 ...
	Eastus2 AzureRegions = "eastus2"
	// Northeurope ...
	Northeurope AzureRegions = "northeurope"
	// Southcentralus ...
	Southcentralus AzureRegions = "southcentralus"
	// Southeastasia ...
	Southeastasia AzureRegions = "southeastasia"
	// Westcentralus ...
	Westcentralus AzureRegions = "westcentralus"
	// Westeurope ...
	Westeurope AzureRegions = "westeurope"
	// Westus ...
	Westus AzureRegions = "westus"
	// Westus2 ...
	Westus2 AzureRegions = "westus2"
)

// APIError error information returned by the API
type APIError struct {
	// StatusCode - HTTP Status code
	StatusCode *string `json:"statusCode,omitempty"`
	// Message - Cause of the error.
	Message *string `json:"message,omitempty"`
}

// CompositeChildModel child entity in a LUIS Composite Entity.
type CompositeChildModel struct {
	// Type - Type of child entity.
	Type *string `json:"type,omitempty"`
	// Value - Value extracted by LUIS.
	Value *string `json:"value,omitempty"`
}

// CompositeEntityModel LUIS Composite Entity.
type CompositeEntityModel struct {
	// ParentType - Type/name of parent entity.
	ParentType *string `json:"parentType,omitempty"`
	// Value - Value for composite entity extracted by LUIS.
	Value *string `json:"value,omitempty"`
	// Children - Child entities.
	Children *[]CompositeChildModel `json:"children,omitempty"`
}

// EntityModel an entity extracted from the utterance.
type EntityModel struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Entity - Name of the entity, as defined in LUIS.
	Entity *string `json:"entity,omitempty"`
	// Type - Type of the entity, as defined in LUIS.
	Type *string `json:"type,omitempty"`
	// StartIndex - The position of the first character of the matched entity within the utterance.
	StartIndex *float64 `json:"startIndex,omitempty"`
	// EndIndex - The position of the last character of the matched entity within the utterance.
	EndIndex *float64 `json:"endIndex,omitempty"`
}

// EntityWithResolution ...
type EntityWithResolution struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Entity - Name of the entity, as defined in LUIS.
	Entity *string `json:"entity,omitempty"`
	// Type - Type of the entity, as defined in LUIS.
	Type *string `json:"type,omitempty"`
	// StartIndex - The position of the first character of the matched entity within the utterance.
	StartIndex *float64 `json:"startIndex,omitempty"`
	// EndIndex - The position of the last character of the matched entity within the utterance.
	EndIndex *float64 `json:"endIndex,omitempty"`
	// Resolution - Resolution values for pre-built LUIS entities.
	Resolution *map[string]interface{} `json:"resolution,omitempty"`
}

// EntityWithScore ...
type EntityWithScore struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties *map[string]*map[string]interface{} `json:",omitempty"`
	// Entity - Name of the entity, as defined in LUIS.
	Entity *string `json:"entity,omitempty"`
	// Type - Type of the entity, as defined in LUIS.
	Type *string `json:"type,omitempty"`
	// StartIndex - The position of the first character of the matched entity within the utterance.
	StartIndex *float64 `json:"startIndex,omitempty"`
	// EndIndex - The position of the last character of the matched entity within the utterance.
	EndIndex *float64 `json:"endIndex,omitempty"`
	// Score - Associated prediction score for the intent (float).
	Score *float64 `json:"score,omitempty"`
}

// IntentModel an intent detected from the utterance.
type IntentModel struct {
	// Intent - Name of the intent, as defined in LUIS.
	Intent *string `json:"intent,omitempty"`
	// Score - Associated prediction score for the intent (float).
	Score *float64 `json:"score,omitempty"`
}

// LuisResult prediction, based on the input query, containing intent(s) and entities.
type LuisResult struct {
	autorest.Response `json:"-"`
	// Query - The input utterance that was analized.
	Query *string `json:"query,omitempty"`
	// AlteredQuery - The corrected utterance (when spell checking was enabled).
	AlteredQuery     *string      `json:"alteredQuery,omitempty"`
	TopScoringIntent *IntentModel `json:"topScoringIntent,omitempty"`
	// Intents - All the intents (and their score) that were detected from utterance.
	Intents *[]IntentModel `json:"intents,omitempty"`
	// Entities - The entities extracted from the utterance.
	Entities *[]EntityModel `json:"entities,omitempty"`
	// CompositeEntities - The composite entities extracted from the utterance.
	CompositeEntities *[]CompositeEntityModel `json:"compositeEntities,omitempty"`
}
