package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// AppServicePlansClient is the webSite Management Client
type AppServicePlansClient struct {
	ManagementClient
}

// NewAppServicePlansClient creates an instance of the AppServicePlansClient client.
func NewAppServicePlansClient(subscriptionID string) AppServicePlansClient {
	return NewAppServicePlansClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewAppServicePlansClientWithBaseURI creates an instance of the AppServicePlansClient client.
func NewAppServicePlansClientWithBaseURI(baseURI string, subscriptionID string) AppServicePlansClient {
	return AppServicePlansClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate creates or updates an App Service Plan. This method may poll for completion. Polling can be canceled
// by passing the cancel channel argument. The channel will be used to cancel polling and any outstanding HTTP
// requests.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
// appServicePlan is details of the App Service plan.
func (client AppServicePlansClient) CreateOrUpdate(resourceGroupName string, name string, appServicePlan AppServicePlan, cancel <-chan struct{}) (<-chan AppServicePlan, <-chan error) {
	resultChan := make(chan AppServicePlan, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "CreateOrUpdate")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result AppServicePlan
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateOrUpdatePreparer(resourceGroupName, name, appServicePlan, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "CreateOrUpdate", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateOrUpdateSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "CreateOrUpdate", resp, "Failure sending request")
			return
		}

		result, err = client.CreateOrUpdateResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "CreateOrUpdate", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client AppServicePlansClient) CreateOrUpdatePreparer(resourceGroupName string, name string, appServicePlan AppServicePlan, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}", pathParameters),
		autorest.WithJSON(appServicePlan),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) CreateOrUpdateResponder(resp *http.Response) (result AppServicePlan, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateVnetRoute create or update a Virtual Network route in an App Service plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
// vnetName is name of the Virtual Network. routeName is name of the Virtual Network route. route is definition of the
// Virtual Network route.
func (client AppServicePlansClient) CreateOrUpdateVnetRoute(resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute) (result VnetRoute, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "CreateOrUpdateVnetRoute")
	}

	req, err := client.CreateOrUpdateVnetRoutePreparer(resourceGroupName, name, vnetName, routeName, route)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "CreateOrUpdateVnetRoute", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateVnetRouteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "CreateOrUpdateVnetRoute", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateVnetRouteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "CreateOrUpdateVnetRoute", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateVnetRoutePreparer prepares the CreateOrUpdateVnetRoute request.
func (client AppServicePlansClient) CreateOrUpdateVnetRoutePreparer(resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"routeName":         autorest.Encode("path", routeName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}", pathParameters),
		autorest.WithJSON(route),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateOrUpdateVnetRouteSender sends the CreateOrUpdateVnetRoute request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) CreateOrUpdateVnetRouteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateVnetRouteResponder handles the response to the CreateOrUpdateVnetRoute request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) CreateOrUpdateVnetRouteResponder(resp *http.Response) (result VnetRoute, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusBadRequest, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete an App Service plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
func (client AppServicePlansClient) Delete(resourceGroupName string, name string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "Delete")
	}

	req, err := client.DeletePreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client AppServicePlansClient) DeletePreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteHybridConnection delete a Hybrid Connection in use in an App Service plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
// namespaceName is name of the Service Bus namespace. relayName is name of the Service Bus relay.
func (client AppServicePlansClient) DeleteHybridConnection(resourceGroupName string, name string, namespaceName string, relayName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "DeleteHybridConnection")
	}

	req, err := client.DeleteHybridConnectionPreparer(resourceGroupName, name, namespaceName, relayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "DeleteHybridConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHybridConnectionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "DeleteHybridConnection", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHybridConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "DeleteHybridConnection", resp, "Failure responding to request")
	}

	return
}

// DeleteHybridConnectionPreparer prepares the DeleteHybridConnection request.
func (client AppServicePlansClient) DeleteHybridConnectionPreparer(resourceGroupName string, name string, namespaceName string, relayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteHybridConnectionSender sends the DeleteHybridConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) DeleteHybridConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteHybridConnectionResponder handles the response to the DeleteHybridConnection request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) DeleteHybridConnectionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteVnetRoute delete a Virtual Network route in an App Service plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
// vnetName is name of the Virtual Network. routeName is name of the Virtual Network route.
func (client AppServicePlansClient) DeleteVnetRoute(resourceGroupName string, name string, vnetName string, routeName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "DeleteVnetRoute")
	}

	req, err := client.DeleteVnetRoutePreparer(resourceGroupName, name, vnetName, routeName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "DeleteVnetRoute", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteVnetRouteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "DeleteVnetRoute", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteVnetRouteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "DeleteVnetRoute", resp, "Failure responding to request")
	}

	return
}

// DeleteVnetRoutePreparer prepares the DeleteVnetRoute request.
func (client AppServicePlansClient) DeleteVnetRoutePreparer(resourceGroupName string, name string, vnetName string, routeName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"routeName":         autorest.Encode("path", routeName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteVnetRouteSender sends the DeleteVnetRoute request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) DeleteVnetRouteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteVnetRouteResponder handles the response to the DeleteVnetRoute request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) DeleteVnetRouteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get get an App Service plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
func (client AppServicePlansClient) Get(resourceGroupName string, name string) (result AppServicePlan, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "Get")
	}

	req, err := client.GetPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client AppServicePlansClient) GetPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) GetResponder(resp *http.Response) (result AppServicePlan, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHybridConnection retrieve a Hybrid Connection in use in an App Service plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
// namespaceName is name of the Service Bus namespace. relayName is name of the Service Bus relay.
func (client AppServicePlansClient) GetHybridConnection(resourceGroupName string, name string, namespaceName string, relayName string) (result HybridConnection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "GetHybridConnection")
	}

	req, err := client.GetHybridConnectionPreparer(resourceGroupName, name, namespaceName, relayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetHybridConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHybridConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetHybridConnection", resp, "Failure sending request")
		return
	}

	result, err = client.GetHybridConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetHybridConnection", resp, "Failure responding to request")
	}

	return
}

// GetHybridConnectionPreparer prepares the GetHybridConnection request.
func (client AppServicePlansClient) GetHybridConnectionPreparer(resourceGroupName string, name string, namespaceName string, relayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHybridConnectionSender sends the GetHybridConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) GetHybridConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetHybridConnectionResponder handles the response to the GetHybridConnection request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) GetHybridConnectionResponder(resp *http.Response) (result HybridConnection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHybridConnectionPlanLimit get the maximum number of Hybrid Connections allowed in an App Service plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
func (client AppServicePlansClient) GetHybridConnectionPlanLimit(resourceGroupName string, name string) (result HybridConnectionLimits, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "GetHybridConnectionPlanLimit")
	}

	req, err := client.GetHybridConnectionPlanLimitPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetHybridConnectionPlanLimit", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHybridConnectionPlanLimitSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetHybridConnectionPlanLimit", resp, "Failure sending request")
		return
	}

	result, err = client.GetHybridConnectionPlanLimitResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetHybridConnectionPlanLimit", resp, "Failure responding to request")
	}

	return
}

// GetHybridConnectionPlanLimitPreparer prepares the GetHybridConnectionPlanLimit request.
func (client AppServicePlansClient) GetHybridConnectionPlanLimitPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionPlanLimits/limit", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetHybridConnectionPlanLimitSender sends the GetHybridConnectionPlanLimit request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) GetHybridConnectionPlanLimitSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetHybridConnectionPlanLimitResponder handles the response to the GetHybridConnectionPlanLimit request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) GetHybridConnectionPlanLimitResponder(resp *http.Response) (result HybridConnectionLimits, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRouteForVnet get a Virtual Network route in an App Service plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
// vnetName is name of the Virtual Network. routeName is name of the Virtual Network route.
func (client AppServicePlansClient) GetRouteForVnet(resourceGroupName string, name string, vnetName string, routeName string) (result ListVnetRoute, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "GetRouteForVnet")
	}

	req, err := client.GetRouteForVnetPreparer(resourceGroupName, name, vnetName, routeName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetRouteForVnet", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRouteForVnetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetRouteForVnet", resp, "Failure sending request")
		return
	}

	result, err = client.GetRouteForVnetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetRouteForVnet", resp, "Failure responding to request")
	}

	return
}

// GetRouteForVnetPreparer prepares the GetRouteForVnet request.
func (client AppServicePlansClient) GetRouteForVnetPreparer(resourceGroupName string, name string, vnetName string, routeName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"routeName":         autorest.Encode("path", routeName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetRouteForVnetSender sends the GetRouteForVnet request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) GetRouteForVnetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetRouteForVnetResponder handles the response to the GetRouteForVnet request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) GetRouteForVnetResponder(resp *http.Response) (result ListVnetRoute, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetFromServerFarm get a Virtual Network associated with an App Service plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
// vnetName is name of the Virtual Network.
func (client AppServicePlansClient) GetVnetFromServerFarm(resourceGroupName string, name string, vnetName string) (result VnetInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "GetVnetFromServerFarm")
	}

	req, err := client.GetVnetFromServerFarmPreparer(resourceGroupName, name, vnetName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetVnetFromServerFarm", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVnetFromServerFarmSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetVnetFromServerFarm", resp, "Failure sending request")
		return
	}

	result, err = client.GetVnetFromServerFarmResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetVnetFromServerFarm", resp, "Failure responding to request")
	}

	return
}

// GetVnetFromServerFarmPreparer prepares the GetVnetFromServerFarm request.
func (client AppServicePlansClient) GetVnetFromServerFarmPreparer(resourceGroupName string, name string, vnetName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetVnetFromServerFarmSender sends the GetVnetFromServerFarm request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) GetVnetFromServerFarmSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetVnetFromServerFarmResponder handles the response to the GetVnetFromServerFarm request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) GetVnetFromServerFarmResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetVnetGateway get a Virtual Network gateway.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
// vnetName is name of the Virtual Network. gatewayName is name of the gateway. Only the 'primary' gateway is
// supported.
func (client AppServicePlansClient) GetVnetGateway(resourceGroupName string, name string, vnetName string, gatewayName string) (result VnetGateway, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "GetVnetGateway")
	}

	req, err := client.GetVnetGatewayPreparer(resourceGroupName, name, vnetName, gatewayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetVnetGateway", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetVnetGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetVnetGateway", resp, "Failure sending request")
		return
	}

	result, err = client.GetVnetGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "GetVnetGateway", resp, "Failure responding to request")
	}

	return
}

// GetVnetGatewayPreparer prepares the GetVnetGateway request.
func (client AppServicePlansClient) GetVnetGatewayPreparer(resourceGroupName string, name string, vnetName string, gatewayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetVnetGatewaySender sends the GetVnetGateway request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) GetVnetGatewaySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetVnetGatewayResponder handles the response to the GetVnetGateway request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) GetVnetGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List get all App Service plans for a subcription.
//
// detailed is specify <code>true</code> to return all App Service plan properties. The default is <code>false</code>,
// which returns a subset of the properties.
// Retrieval of all properties may increase the API latency.
func (client AppServicePlansClient) List(detailed *bool) (result AppServicePlanCollection, err error) {
	req, err := client.ListPreparer(detailed)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client AppServicePlansClient) ListPreparer(detailed *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if detailed != nil {
		queryParameters["detailed"] = autorest.Encode("query", *detailed)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/serverfarms", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListResponder(resp *http.Response) (result AppServicePlanCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListNextResults retrieves the next set of results, if any.
func (client AppServicePlansClient) ListNextResults(lastResults AppServicePlanCollection) (result AppServicePlanCollection, err error) {
	req, err := lastResults.AppServicePlanCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "List", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "List", resp, "Failure sending next results request")
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "List", resp, "Failure responding to next results request")
	}

	return
}

// ListComplete gets all elements from the list without paging.
func (client AppServicePlansClient) ListComplete(detailed *bool, cancel <-chan struct{}) (<-chan AppServicePlan, <-chan error) {
	resultChan := make(chan AppServicePlan)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.List(detailed)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListByResourceGroup get all App Service plans in a resource group.
//
// resourceGroupName is name of the resource group to which the resource belongs.
func (client AppServicePlansClient) ListByResourceGroup(resourceGroupName string) (result AppServicePlanCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "ListByResourceGroup")
	}

	req, err := client.ListByResourceGroupPreparer(resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client AppServicePlansClient) ListByResourceGroupPreparer(resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListByResourceGroupResponder(resp *http.Response) (result AppServicePlanCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroupNextResults retrieves the next set of results, if any.
func (client AppServicePlansClient) ListByResourceGroupNextResults(lastResults AppServicePlanCollection) (result AppServicePlanCollection, err error) {
	req, err := lastResults.AppServicePlanCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListByResourceGroup", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListByResourceGroup", resp, "Failure sending next results request")
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListByResourceGroup", resp, "Failure responding to next results request")
	}

	return
}

// ListByResourceGroupComplete gets all elements from the list without paging.
func (client AppServicePlansClient) ListByResourceGroupComplete(resourceGroupName string, cancel <-chan struct{}) (<-chan AppServicePlan, <-chan error) {
	resultChan := make(chan AppServicePlan)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListByResourceGroup(resourceGroupName)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListByResourceGroupNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListCapabilities list all capabilities of an App Service plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
func (client AppServicePlansClient) ListCapabilities(resourceGroupName string, name string) (result ListCapability, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "ListCapabilities")
	}

	req, err := client.ListCapabilitiesPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListCapabilities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCapabilitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListCapabilities", resp, "Failure sending request")
		return
	}

	result, err = client.ListCapabilitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListCapabilities", resp, "Failure responding to request")
	}

	return
}

// ListCapabilitiesPreparer prepares the ListCapabilities request.
func (client AppServicePlansClient) ListCapabilitiesPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/capabilities", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListCapabilitiesSender sends the ListCapabilities request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListCapabilitiesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListCapabilitiesResponder handles the response to the ListCapabilities request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListCapabilitiesResponder(resp *http.Response) (result ListCapability, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHybridConnectionKeys get the send key name and value of a Hybrid Connection.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
// namespaceName is the name of the Service Bus namespace. relayName is the name of the Service Bus relay.
func (client AppServicePlansClient) ListHybridConnectionKeys(resourceGroupName string, name string, namespaceName string, relayName string) (result HybridConnectionKey, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "ListHybridConnectionKeys")
	}

	req, err := client.ListHybridConnectionKeysPreparer(resourceGroupName, name, namespaceName, relayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListHybridConnectionKeys", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHybridConnectionKeysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListHybridConnectionKeys", resp, "Failure sending request")
		return
	}

	result, err = client.ListHybridConnectionKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListHybridConnectionKeys", resp, "Failure responding to request")
	}

	return
}

// ListHybridConnectionKeysPreparer prepares the ListHybridConnectionKeys request.
func (client AppServicePlansClient) ListHybridConnectionKeysPreparer(resourceGroupName string, name string, namespaceName string, relayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/listKeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListHybridConnectionKeysSender sends the ListHybridConnectionKeys request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListHybridConnectionKeysSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListHybridConnectionKeysResponder handles the response to the ListHybridConnectionKeys request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListHybridConnectionKeysResponder(resp *http.Response) (result HybridConnectionKey, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHybridConnections retrieve all Hybrid Connections in use in an App Service plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
func (client AppServicePlansClient) ListHybridConnections(resourceGroupName string, name string) (result HybridConnectionCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "ListHybridConnections")
	}

	req, err := client.ListHybridConnectionsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListHybridConnections", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHybridConnectionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListHybridConnections", resp, "Failure sending request")
		return
	}

	result, err = client.ListHybridConnectionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListHybridConnections", resp, "Failure responding to request")
	}

	return
}

// ListHybridConnectionsPreparer prepares the ListHybridConnections request.
func (client AppServicePlansClient) ListHybridConnectionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionRelays", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListHybridConnectionsSender sends the ListHybridConnections request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListHybridConnectionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListHybridConnectionsResponder handles the response to the ListHybridConnections request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListHybridConnectionsResponder(resp *http.Response) (result HybridConnectionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHybridConnectionsNextResults retrieves the next set of results, if any.
func (client AppServicePlansClient) ListHybridConnectionsNextResults(lastResults HybridConnectionCollection) (result HybridConnectionCollection, err error) {
	req, err := lastResults.HybridConnectionCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListHybridConnections", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListHybridConnectionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListHybridConnections", resp, "Failure sending next results request")
	}

	result, err = client.ListHybridConnectionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListHybridConnections", resp, "Failure responding to next results request")
	}

	return
}

// ListHybridConnectionsComplete gets all elements from the list without paging.
func (client AppServicePlansClient) ListHybridConnectionsComplete(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan HybridConnection, <-chan error) {
	resultChan := make(chan HybridConnection)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListHybridConnections(resourceGroupName, name)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListHybridConnectionsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListMetricDefintions get metrics that can be queried for an App Service plan, and their definitions.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
func (client AppServicePlansClient) ListMetricDefintions(resourceGroupName string, name string) (result ResourceMetricDefinitionCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "ListMetricDefintions")
	}

	req, err := client.ListMetricDefintionsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListMetricDefintions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricDefintionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListMetricDefintions", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetricDefintionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListMetricDefintions", resp, "Failure responding to request")
	}

	return
}

// ListMetricDefintionsPreparer prepares the ListMetricDefintions request.
func (client AppServicePlansClient) ListMetricDefintionsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMetricDefintionsSender sends the ListMetricDefintions request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListMetricDefintionsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListMetricDefintionsResponder handles the response to the ListMetricDefintions request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListMetricDefintionsResponder(resp *http.Response) (result ResourceMetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetricDefintionsNextResults retrieves the next set of results, if any.
func (client AppServicePlansClient) ListMetricDefintionsNextResults(lastResults ResourceMetricDefinitionCollection) (result ResourceMetricDefinitionCollection, err error) {
	req, err := lastResults.ResourceMetricDefinitionCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListMetricDefintions", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListMetricDefintionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListMetricDefintions", resp, "Failure sending next results request")
	}

	result, err = client.ListMetricDefintionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListMetricDefintions", resp, "Failure responding to next results request")
	}

	return
}

// ListMetricDefintionsComplete gets all elements from the list without paging.
func (client AppServicePlansClient) ListMetricDefintionsComplete(resourceGroupName string, name string, cancel <-chan struct{}) (<-chan ResourceMetricDefinition, <-chan error) {
	resultChan := make(chan ResourceMetricDefinition)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListMetricDefintions(resourceGroupName, name)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListMetricDefintionsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListMetrics get metrics for an App Serice plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
// details is specify <code>true</code> to include instance details. The default is <code>false</code>. filter is
// return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq
// 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z'
// and timeGrain eq duration'[Hour|Minute|Day]'.
func (client AppServicePlansClient) ListMetrics(resourceGroupName string, name string, details *bool, filter string) (result ResourceMetricCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "ListMetrics")
	}

	req, err := client.ListMetricsPreparer(resourceGroupName, name, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListMetrics", resp, "Failure sending request")
		return
	}

	result, err = client.ListMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListMetrics", resp, "Failure responding to request")
	}

	return
}

// ListMetricsPreparer prepares the ListMetrics request.
func (client AppServicePlansClient) ListMetricsPreparer(resourceGroupName string, name string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListMetricsSender sends the ListMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListMetricsResponder handles the response to the ListMetrics request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMetricsNextResults retrieves the next set of results, if any.
func (client AppServicePlansClient) ListMetricsNextResults(lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.ResourceMetricCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListMetrics", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListMetrics", resp, "Failure sending next results request")
	}

	result, err = client.ListMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListMetrics", resp, "Failure responding to next results request")
	}

	return
}

// ListMetricsComplete gets all elements from the list without paging.
func (client AppServicePlansClient) ListMetricsComplete(resourceGroupName string, name string, details *bool, filter string, cancel <-chan struct{}) (<-chan ResourceMetric, <-chan error) {
	resultChan := make(chan ResourceMetric)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListMetrics(resourceGroupName, name, details, filter)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListMetricsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListRoutesForVnet get all routes that are associated with a Virtual Network in an App Service plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
// vnetName is name of the Virtual Network.
func (client AppServicePlansClient) ListRoutesForVnet(resourceGroupName string, name string, vnetName string) (result ListVnetRoute, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "ListRoutesForVnet")
	}

	req, err := client.ListRoutesForVnetPreparer(resourceGroupName, name, vnetName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListRoutesForVnet", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRoutesForVnetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListRoutesForVnet", resp, "Failure sending request")
		return
	}

	result, err = client.ListRoutesForVnetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListRoutesForVnet", resp, "Failure responding to request")
	}

	return
}

// ListRoutesForVnetPreparer prepares the ListRoutesForVnet request.
func (client AppServicePlansClient) ListRoutesForVnetPreparer(resourceGroupName string, name string, vnetName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListRoutesForVnetSender sends the ListRoutesForVnet request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListRoutesForVnetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListRoutesForVnetResponder handles the response to the ListRoutesForVnet request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListRoutesForVnetResponder(resp *http.Response) (result ListVnetRoute, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListVnets get all Virtual Networks associated with an App Service plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
func (client AppServicePlansClient) ListVnets(resourceGroupName string, name string) (result ListVnetInfo, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "ListVnets")
	}

	req, err := client.ListVnetsPreparer(resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListVnets", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListVnetsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListVnets", resp, "Failure sending request")
		return
	}

	result, err = client.ListVnetsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListVnets", resp, "Failure responding to request")
	}

	return
}

// ListVnetsPreparer prepares the ListVnets request.
func (client AppServicePlansClient) ListVnetsPreparer(resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListVnetsSender sends the ListVnets request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListVnetsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListVnetsResponder handles the response to the ListVnets request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListVnetsResponder(resp *http.Response) (result ListVnetInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListWebApps get all apps associated with an App Service plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
// skipToken is skip to a web app in the list of webapps associated with app service plan. If specified, the resulting
// list will contain web apps starting from (including) the skipToken. Otherwise, the resulting list contains web apps
// from the start of the list filter is supported filter: $filter=state eq running. Returns only web apps that are
// currently running top is list page size. If specified, results are paged.
func (client AppServicePlansClient) ListWebApps(resourceGroupName string, name string, skipToken string, filter string, top string) (result AppCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "ListWebApps")
	}

	req, err := client.ListWebAppsPreparer(resourceGroupName, name, skipToken, filter, top)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListWebApps", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWebAppsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListWebApps", resp, "Failure sending request")
		return
	}

	result, err = client.ListWebAppsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListWebApps", resp, "Failure responding to request")
	}

	return
}

// ListWebAppsPreparer prepares the ListWebApps request.
func (client AppServicePlansClient) ListWebAppsPreparer(resourceGroupName string, name string, skipToken string, filter string, top string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}
	if len(top) > 0 {
		queryParameters["$top"] = autorest.Encode("query", top)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/sites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListWebAppsSender sends the ListWebApps request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListWebAppsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListWebAppsResponder handles the response to the ListWebApps request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListWebAppsResponder(resp *http.Response) (result AppCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListWebAppsNextResults retrieves the next set of results, if any.
func (client AppServicePlansClient) ListWebAppsNextResults(lastResults AppCollection) (result AppCollection, err error) {
	req, err := lastResults.AppCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListWebApps", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListWebAppsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListWebApps", resp, "Failure sending next results request")
	}

	result, err = client.ListWebAppsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListWebApps", resp, "Failure responding to next results request")
	}

	return
}

// ListWebAppsComplete gets all elements from the list without paging.
func (client AppServicePlansClient) ListWebAppsComplete(resourceGroupName string, name string, skipToken string, filter string, top string, cancel <-chan struct{}) (<-chan Site, <-chan error) {
	resultChan := make(chan Site)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListWebApps(resourceGroupName, name, skipToken, filter, top)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListWebAppsNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// ListWebAppsByHybridConnection get all apps that use a Hybrid Connection in an App Service Plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
// namespaceName is name of the Hybrid Connection namespace. relayName is name of the Hybrid Connection relay.
func (client AppServicePlansClient) ListWebAppsByHybridConnection(resourceGroupName string, name string, namespaceName string, relayName string) (result ResourceCollection, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "ListWebAppsByHybridConnection")
	}

	req, err := client.ListWebAppsByHybridConnectionPreparer(resourceGroupName, name, namespaceName, relayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListWebAppsByHybridConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListWebAppsByHybridConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListWebAppsByHybridConnection", resp, "Failure sending request")
		return
	}

	result, err = client.ListWebAppsByHybridConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListWebAppsByHybridConnection", resp, "Failure responding to request")
	}

	return
}

// ListWebAppsByHybridConnectionPreparer prepares the ListWebAppsByHybridConnection request.
func (client AppServicePlansClient) ListWebAppsByHybridConnectionPreparer(resourceGroupName string, name string, namespaceName string, relayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"namespaceName":     autorest.Encode("path", namespaceName),
		"relayName":         autorest.Encode("path", relayName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/sites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListWebAppsByHybridConnectionSender sends the ListWebAppsByHybridConnection request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) ListWebAppsByHybridConnectionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListWebAppsByHybridConnectionResponder handles the response to the ListWebAppsByHybridConnection request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) ListWebAppsByHybridConnectionResponder(resp *http.Response) (result ResourceCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListWebAppsByHybridConnectionNextResults retrieves the next set of results, if any.
func (client AppServicePlansClient) ListWebAppsByHybridConnectionNextResults(lastResults ResourceCollection) (result ResourceCollection, err error) {
	req, err := lastResults.ResourceCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListWebAppsByHybridConnection", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListWebAppsByHybridConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListWebAppsByHybridConnection", resp, "Failure sending next results request")
	}

	result, err = client.ListWebAppsByHybridConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "ListWebAppsByHybridConnection", resp, "Failure responding to next results request")
	}

	return
}

// ListWebAppsByHybridConnectionComplete gets all elements from the list without paging.
func (client AppServicePlansClient) ListWebAppsByHybridConnectionComplete(resourceGroupName string, name string, namespaceName string, relayName string, cancel <-chan struct{}) (<-chan string, <-chan error) {
	resultChan := make(chan string)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListWebAppsByHybridConnection(resourceGroupName, name, namespaceName, relayName)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListWebAppsByHybridConnectionNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}

// RebootWorker reboot a worker machine in an App Service plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
// workerName is name of worker machine, which typically starts with RD.
func (client AppServicePlansClient) RebootWorker(resourceGroupName string, name string, workerName string) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "RebootWorker")
	}

	req, err := client.RebootWorkerPreparer(resourceGroupName, name, workerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "RebootWorker", nil, "Failure preparing request")
		return
	}

	resp, err := client.RebootWorkerSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "RebootWorker", resp, "Failure sending request")
		return
	}

	result, err = client.RebootWorkerResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "RebootWorker", resp, "Failure responding to request")
	}

	return
}

// RebootWorkerPreparer prepares the RebootWorker request.
func (client AppServicePlansClient) RebootWorkerPreparer(resourceGroupName string, name string, workerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workerName":        autorest.Encode("path", workerName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/workers/{workerName}/reboot", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// RebootWorkerSender sends the RebootWorker request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) RebootWorkerSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// RebootWorkerResponder handles the response to the RebootWorker request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) RebootWorkerResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// RestartWebApps restart all apps in an App Service plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
// softRestart is specify <code>true</code> to performa a soft restart, applies the configuration settings and restarts
// the apps if necessary. The default is <code>false</code>, which always restarts and reprovisions the apps
func (client AppServicePlansClient) RestartWebApps(resourceGroupName string, name string, softRestart *bool) (result autorest.Response, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "RestartWebApps")
	}

	req, err := client.RestartWebAppsPreparer(resourceGroupName, name, softRestart)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "RestartWebApps", nil, "Failure preparing request")
		return
	}

	resp, err := client.RestartWebAppsSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "RestartWebApps", resp, "Failure sending request")
		return
	}

	result, err = client.RestartWebAppsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "RestartWebApps", resp, "Failure responding to request")
	}

	return
}

// RestartWebAppsPreparer prepares the RestartWebApps request.
func (client AppServicePlansClient) RestartWebAppsPreparer(resourceGroupName string, name string, softRestart *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if softRestart != nil {
		queryParameters["softRestart"] = autorest.Encode("query", *softRestart)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/restartSites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// RestartWebAppsSender sends the RestartWebApps request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) RestartWebAppsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// RestartWebAppsResponder handles the response to the RestartWebApps request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) RestartWebAppsResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdateVnetGateway update a Virtual Network gateway.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
// vnetName is name of the Virtual Network. gatewayName is name of the gateway. Only the 'primary' gateway is
// supported. connectionEnvelope is definition of the gateway.
func (client AppServicePlansClient) UpdateVnetGateway(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (result VnetGateway, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "UpdateVnetGateway")
	}

	req, err := client.UpdateVnetGatewayPreparer(resourceGroupName, name, vnetName, gatewayName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "UpdateVnetGateway", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateVnetGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "UpdateVnetGateway", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateVnetGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "UpdateVnetGateway", resp, "Failure responding to request")
	}

	return
}

// UpdateVnetGatewayPreparer prepares the UpdateVnetGateway request.
func (client AppServicePlansClient) UpdateVnetGatewayPreparer(resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateVnetGatewaySender sends the UpdateVnetGateway request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) UpdateVnetGatewaySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// UpdateVnetGatewayResponder handles the response to the UpdateVnetGateway request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) UpdateVnetGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateVnetRoute create or update a Virtual Network route in an App Service plan.
//
// resourceGroupName is name of the resource group to which the resource belongs. name is name of the App Service plan.
// vnetName is name of the Virtual Network. routeName is name of the Virtual Network route. route is definition of the
// Virtual Network route.
func (client AppServicePlansClient) UpdateVnetRoute(resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute) (result VnetRoute, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "web.AppServicePlansClient", "UpdateVnetRoute")
	}

	req, err := client.UpdateVnetRoutePreparer(resourceGroupName, name, vnetName, routeName, route)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "UpdateVnetRoute", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateVnetRouteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "UpdateVnetRoute", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateVnetRouteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.AppServicePlansClient", "UpdateVnetRoute", resp, "Failure responding to request")
	}

	return
}

// UpdateVnetRoutePreparer prepares the UpdateVnetRoute request.
func (client AppServicePlansClient) UpdateVnetRoutePreparer(resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"routeName":         autorest.Encode("path", routeName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2016-09-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}", pathParameters),
		autorest.WithJSON(route),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// UpdateVnetRouteSender sends the UpdateVnetRoute request. The method will close the
// http.Response Body if it receives an error.
func (client AppServicePlansClient) UpdateVnetRouteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// UpdateVnetRouteResponder handles the response to the UpdateVnetRoute request. The method always
// closes the http.Response Body.
func (client AppServicePlansClient) UpdateVnetRouteResponder(resp *http.Response) (result VnetRoute, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusBadRequest, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
