package servermanagement

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// CredentialDataFormat enumerates the values for credential data format.
type CredentialDataFormat string

const (
	// RsaEncrypted specifies the rsa encrypted state for credential data format.
	RsaEncrypted CredentialDataFormat = "RsaEncrypted"
)

// GatewayExpandOption enumerates the values for gateway expand option.
type GatewayExpandOption string

const (
	// Download specifies the download state for gateway expand option.
	Download GatewayExpandOption = "download"
	// Status specifies the status state for gateway expand option.
	Status GatewayExpandOption = "status"
)

// PowerShellExpandOption enumerates the values for power shell expand option.
type PowerShellExpandOption string

const (
	// Output specifies the output state for power shell expand option.
	Output PowerShellExpandOption = "output"
)

// PromptFieldType enumerates the values for prompt field type.
type PromptFieldType string

const (
	// Credential specifies the credential state for prompt field type.
	Credential PromptFieldType = "Credential"
	// SecureString specifies the secure string state for prompt field type.
	SecureString PromptFieldType = "SecureString"
	// String specifies the string state for prompt field type.
	String PromptFieldType = "String"
)

// RetentionPeriod enumerates the values for retention period.
type RetentionPeriod string

const (
	// Persistent specifies the persistent state for retention period.
	Persistent RetentionPeriod = "Persistent"
	// Session specifies the session state for retention period.
	Session RetentionPeriod = "Session"
)

// UpgradeMode enumerates the values for upgrade mode.
type UpgradeMode string

const (
	// Automatic specifies the automatic state for upgrade mode.
	Automatic UpgradeMode = "Automatic"
	// Manual specifies the manual state for upgrade mode.
	Manual UpgradeMode = "Manual"
)

// EncryptionJwkResource is the public key of the gateway.
type EncryptionJwkResource struct {
	Kty *string `json:"kty,omitempty"`
	Alg *string `json:"alg,omitempty"`
	E   *string `json:"e,omitempty"`
	N   *string `json:"n,omitempty"`
}

// Error is error message.
type Error struct {
	Code    *int32  `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
	Fields  *string `json:"fields,omitempty"`
}

// GatewayParameters is collection of parameters for operations on a gateway resource.
type GatewayParameters struct {
	Location                     *string                 `json:"location,omitempty"`
	Tags                         *map[string]interface{} `json:"tags,omitempty"`
	*GatewayParametersProperties `json:"properties,omitempty"`
}

// GatewayParametersProperties is collection of properties.
type GatewayParametersProperties struct {
	UpgradeMode UpgradeMode `json:"upgradeMode,omitempty"`
}

// GatewayProfile is JSON properties that the gateway service uses know how to communicate with the resource.
type GatewayProfile struct {
	autorest.Response           `json:"-"`
	DataPlaneServiceBaseAddress *string `json:"dataPlaneServiceBaseAddress,omitempty"`
	GatewayID                   *string `json:"gatewayId,omitempty"`
	Environment                 *string `json:"environment,omitempty"`
	UpgradeManifestURL          *string `json:"upgradeManifestUrl,omitempty"`
	MessagingNamespace          *string `json:"messagingNamespace,omitempty"`
	MessagingAccount            *string `json:"messagingAccount,omitempty"`
	MessagingKey                *string `json:"messagingKey,omitempty"`
	RequestQueue                *string `json:"requestQueue,omitempty"`
	ResponseTopic               *string `json:"responseTopic,omitempty"`
	StatusBlobSignature         *string `json:"statusBlobSignature,omitempty"`
}

// GatewayResource is data model for an arm gateway resource.
type GatewayResource struct {
	autorest.Response          `json:"-"`
	ID                         *string             `json:"id,omitempty"`
	Type                       *string             `json:"type,omitempty"`
	Name                       *string             `json:"name,omitempty"`
	Location                   *string             `json:"location,omitempty"`
	Tags                       *map[string]*string `json:"tags,omitempty"`
	Etag                       *string             `json:"etag,omitempty"`
	*GatewayResourceProperties `json:"properties,omitempty"`
}

// GatewayResourceProperties is collection of properties.
type GatewayResourceProperties struct {
	Created                   *date.Time       `json:"created,omitempty"`
	Updated                   *date.Time       `json:"updated,omitempty"`
	UpgradeMode               UpgradeMode      `json:"upgradeMode,omitempty"`
	DesiredVersion            *string          `json:"desiredVersion,omitempty"`
	Instances                 *[]GatewayStatus `json:"instances,omitempty"`
	ActiveMessageCount        *int32           `json:"activeMessageCount,omitempty"`
	LatestPublishedMsiVersion *string          `json:"latestPublishedMsiVersion,omitempty"`
	PublishedTimeUtc          *date.Time       `json:"publishedTimeUtc,omitempty"`
	InstallerDownload         *string          `json:"installerDownload,omitempty"`
	MinimumVersion            *string          `json:"minimumVersion,omitempty"`
}

// GatewayResources is collection of Gateway Resources.
type GatewayResources struct {
	autorest.Response `json:"-"`
	Value             *[]GatewayResource `json:"value,omitempty"`
	NextLink          *string            `json:"nextLink,omitempty"`
}

// GatewayResourcesPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client GatewayResources) GatewayResourcesPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// GatewayStatus is expanded gateway status information.
type GatewayStatus struct {
	AvailableMemoryMByte                     *float64               `json:"availableMemoryMByte,omitempty"`
	GatewayCPUUtilizationPercent             *float64               `json:"gatewayCpuUtilizationPercent,omitempty"`
	TotalCPUUtilizationPercent               *float64               `json:"totalCpuUtilizationPercent,omitempty"`
	GatewayVersion                           *string                `json:"gatewayVersion,omitempty"`
	FriendlyOsName                           *string                `json:"friendlyOsName,omitempty"`
	InstalledDate                            *date.Time             `json:"installedDate,omitempty"`
	LogicalProcessorCount                    *int32                 `json:"logicalProcessorCount,omitempty"`
	Name                                     *string                `json:"name,omitempty"`
	GatewayID                                *string                `json:"gatewayId,omitempty"`
	GatewayWorkingSetMByte                   *float64               `json:"gatewayWorkingSetMByte,omitempty"`
	StatusUpdated                            *date.Time             `json:"statusUpdated,omitempty"`
	GroupPolicyError                         *string                `json:"groupPolicyError,omitempty"`
	AllowGatewayGroupPolicyStatus            *bool                  `json:"allowGatewayGroupPolicyStatus,omitempty"`
	RequireMfaGroupPolicyStatus              *bool                  `json:"requireMfaGroupPolicyStatus,omitempty"`
	EncryptionCertificateThumbprint          *string                `json:"encryptionCertificateThumbprint,omitempty"`
	SecondaryEncryptionCertificateThumbprint *string                `json:"secondaryEncryptionCertificateThumbprint,omitempty"`
	EncryptionJwk                            *EncryptionJwkResource `json:"encryptionJwk,omitempty"`
	SecondaryEncryptionJwk                   *EncryptionJwkResource `json:"secondaryEncryptionJwk,omitempty"`
	ActiveMessageCount                       *int32                 `json:"activeMessageCount,omitempty"`
	LatestPublishedMsiVersion                *string                `json:"latestPublishedMsiVersion,omitempty"`
	PublishedTimeUtc                         *date.Time             `json:"publishedTimeUtc,omitempty"`
}

// NodeParameters is parameter collection for operations on arm node resource.
type NodeParameters struct {
	Location                  *string                 `json:"location,omitempty"`
	Tags                      *map[string]interface{} `json:"tags,omitempty"`
	*NodeParametersProperties `json:"properties,omitempty"`
}

// NodeParametersProperties is collection of properties.
type NodeParametersProperties struct {
	GatewayID      *string `json:"gatewayId,omitempty"`
	ConnectionName *string `json:"connectionName,omitempty"`
	UserName       *string `json:"userName,omitempty"`
	Password       *string `json:"password,omitempty"`
}

// NodeResource is a Node Resource.
type NodeResource struct {
	autorest.Response       `json:"-"`
	ID                      *string             `json:"id,omitempty"`
	Type                    *string             `json:"type,omitempty"`
	Name                    *string             `json:"name,omitempty"`
	Location                *string             `json:"location,omitempty"`
	Tags                    *map[string]*string `json:"tags,omitempty"`
	Etag                    *string             `json:"etag,omitempty"`
	*NodeResourceProperties `json:"properties,omitempty"`
}

// NodeResourceProperties is collection of properties.
type NodeResourceProperties struct {
	GatewayID      *string    `json:"gatewayId,omitempty"`
	ConnectionName *string    `json:"connectionName,omitempty"`
	Created        *date.Time `json:"created,omitempty"`
	Updated        *date.Time `json:"updated,omitempty"`
}

// NodeResources is a collection of node resource objects.
type NodeResources struct {
	autorest.Response `json:"-"`
	Value             *[]NodeResource `json:"value,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// NodeResourcesPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client NodeResources) NodeResourcesPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// PowerShellCommandParameters is the parameters to a PowerShell script execution command.
type PowerShellCommandParameters struct {
	*PowerShellCommandParametersProperties `json:"properties,omitempty"`
}

// PowerShellCommandParametersProperties is collection of properties.
type PowerShellCommandParametersProperties struct {
	Command *string `json:"command,omitempty"`
}

// PowerShellCommandResult is results from invoking a PowerShell command.
type PowerShellCommandResult struct {
	MessageType     *int32                    `json:"messageType,omitempty"`
	ForegroundColor *string                   `json:"foregroundColor,omitempty"`
	BackgroundColor *string                   `json:"backgroundColor,omitempty"`
	Value           *string                   `json:"value,omitempty"`
	Prompt          *string                   `json:"prompt,omitempty"`
	ExitCode        *int32                    `json:"exitCode,omitempty"`
	ID              *int32                    `json:"id,omitempty"`
	Caption         *string                   `json:"caption,omitempty"`
	Message         *string                   `json:"message,omitempty"`
	Descriptions    *[]PromptFieldDescription `json:"descriptions,omitempty"`
}

// PowerShellCommandResults is a collection of results from a PowerShell command.
type PowerShellCommandResults struct {
	autorest.Response `json:"-"`
	Results           *[]PowerShellCommandResult `json:"results,omitempty"`
	Pssession         *string                    `json:"pssession,omitempty"`
	Command           *string                    `json:"command,omitempty"`
	Completed         *bool                      `json:"completed,omitempty"`
}

// PowerShellCommandStatus is result status from invoking a PowerShell command.
type PowerShellCommandStatus struct {
	autorest.Response         `json:"-"`
	ID                        *string             `json:"id,omitempty"`
	Type                      *string             `json:"type,omitempty"`
	Name                      *string             `json:"name,omitempty"`
	Location                  *string             `json:"location,omitempty"`
	Tags                      *map[string]*string `json:"tags,omitempty"`
	Etag                      *string             `json:"etag,omitempty"`
	*PowerShellCommandResults `json:"properties,omitempty"`
}

// PowerShellSessionResource is a PowerShell session resource (practically equivalent to a runspace instance).
type PowerShellSessionResource struct {
	autorest.Response                    `json:"-"`
	ID                                   *string             `json:"id,omitempty"`
	Type                                 *string             `json:"type,omitempty"`
	Name                                 *string             `json:"name,omitempty"`
	Location                             *string             `json:"location,omitempty"`
	Tags                                 *map[string]*string `json:"tags,omitempty"`
	Etag                                 *string             `json:"etag,omitempty"`
	*PowerShellSessionResourceProperties `json:"properties,omitempty"`
}

// PowerShellSessionResourceProperties is collection of properties.
type PowerShellSessionResourceProperties struct {
	SessionID            *string                  `json:"sessionId,omitempty"`
	State                *string                  `json:"state,omitempty"`
	RunspaceAvailability *string                  `json:"runspaceAvailability,omitempty"`
	DisconnectedOn       *date.Time               `json:"disconnectedOn,omitempty"`
	ExpiresOn            *date.Time               `json:"expiresOn,omitempty"`
	Version              *VersionServermanagement `json:"version,omitempty"`
	Name                 *string                  `json:"name,omitempty"`
}

// PowerShellSessionResources is a collection of PowerShell session resources
type PowerShellSessionResources struct {
	autorest.Response `json:"-"`
	Value             *[]PowerShellSessionResource `json:"value,omitempty"`
	NextLink          *string                      `json:"nextLink,omitempty"`
}

// PowerShellTabCompletionParameters is collection of parameters for PowerShell tab completion.
type PowerShellTabCompletionParameters struct {
	Command *string `json:"command,omitempty"`
}

// PowerShellTabCompletionResults is an array of strings representing the different values that can be selected
// through.
type PowerShellTabCompletionResults struct {
	autorest.Response `json:"-"`
	Results           *[]string `json:"results,omitempty"`
}

// PromptFieldDescription is field description for the implementation of PSHostUserInterface.Prompt
type PromptFieldDescription struct {
	Name                  *string         `json:"name,omitempty"`
	Label                 *string         `json:"label,omitempty"`
	HelpMessage           *string         `json:"helpMessage,omitempty"`
	PromptFieldTypeIsList *bool           `json:"promptFieldTypeIsList,omitempty"`
	PromptFieldType       PromptFieldType `json:"promptFieldType,omitempty"`
}

// PromptMessageResponse is the response to a prompt message.
type PromptMessageResponse struct {
	Response *[]string `json:"response,omitempty"`
}

// Resource is resource Manager Resource Information.
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
	Etag     *string             `json:"etag,omitempty"`
}

// SessionParameters is parameter collection for creation and other operations on sessions.
type SessionParameters struct {
	*SessionParametersProperties `json:"properties,omitempty"`
}

// SessionParametersProperties is collection of properties
type SessionParametersProperties struct {
	UserName                        *string              `json:"userName,omitempty"`
	Password                        *string              `json:"password,omitempty"`
	RetentionPeriod                 RetentionPeriod      `json:"retentionPeriod,omitempty"`
	CredentialDataFormat            CredentialDataFormat `json:"credentialDataFormat,omitempty"`
	EncryptionCertificateThumbprint *string              `json:"EncryptionCertificateThumbprint,omitempty"`
}

// SessionResource is the session object.
type SessionResource struct {
	autorest.Response          `json:"-"`
	ID                         *string             `json:"id,omitempty"`
	Type                       *string             `json:"type,omitempty"`
	Name                       *string             `json:"name,omitempty"`
	Location                   *string             `json:"location,omitempty"`
	Tags                       *map[string]*string `json:"tags,omitempty"`
	Etag                       *string             `json:"etag,omitempty"`
	*SessionResourceProperties `json:"properties,omitempty"`
}

// SessionResourceProperties is collection of properties.
type SessionResourceProperties struct {
	UserName *string    `json:"userName,omitempty"`
	Created  *date.Time `json:"created,omitempty"`
	Updated  *date.Time `json:"updated,omitempty"`
}

// VersionServermanagement is a multipart-numeric version number.
type VersionServermanagement struct {
	Major         *int32 `json:"major,omitempty"`
	Minor         *int32 `json:"minor,omitempty"`
	Build         *int32 `json:"build,omitempty"`
	Revision      *int32 `json:"revision,omitempty"`
	MajorRevision *int32 `json:"majorRevision,omitempty"`
	MinorRevision *int32 `json:"minorRevision,omitempty"`
}
