package eventgrid

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"errors"
	"github.com/Azure/go-autorest/autorest"
)

// EndpointType enumerates the values for endpoint type.
type EndpointType string

const (
	// EndpointTypeEventHub specifies the endpoint type event hub state for endpoint type.
	EndpointTypeEventHub EndpointType = "EventHub"
	// EndpointTypeWebHook specifies the endpoint type web hook state for endpoint type.
	EndpointTypeWebHook EndpointType = "WebHook"
)

// EventSubscriptionProvisioningState enumerates the values for event subscription provisioning state.
type EventSubscriptionProvisioningState string

const (
	// Canceled specifies the canceled state for event subscription provisioning state.
	Canceled EventSubscriptionProvisioningState = "Canceled"
	// Creating specifies the creating state for event subscription provisioning state.
	Creating EventSubscriptionProvisioningState = "Creating"
	// Deleting specifies the deleting state for event subscription provisioning state.
	Deleting EventSubscriptionProvisioningState = "Deleting"
	// Failed specifies the failed state for event subscription provisioning state.
	Failed EventSubscriptionProvisioningState = "Failed"
	// Succeeded specifies the succeeded state for event subscription provisioning state.
	Succeeded EventSubscriptionProvisioningState = "Succeeded"
	// Updating specifies the updating state for event subscription provisioning state.
	Updating EventSubscriptionProvisioningState = "Updating"
)

// OperationOrigin enumerates the values for operation origin.
type OperationOrigin string

const (
	// System specifies the system state for operation origin.
	System OperationOrigin = "System"
	// User specifies the user state for operation origin.
	User OperationOrigin = "User"
	// UserAndSystem specifies the user and system state for operation origin.
	UserAndSystem OperationOrigin = "UserAndSystem"
)

// ResourceRegionType enumerates the values for resource region type.
type ResourceRegionType string

const (
	// GlobalResource specifies the global resource state for resource region type.
	GlobalResource ResourceRegionType = "GlobalResource"
	// RegionalResource specifies the regional resource state for resource region type.
	RegionalResource ResourceRegionType = "RegionalResource"
)

// TopicProvisioningState enumerates the values for topic provisioning state.
type TopicProvisioningState string

const (
	// TopicProvisioningStateCanceled specifies the topic provisioning state canceled state for topic provisioning state.
	TopicProvisioningStateCanceled TopicProvisioningState = "Canceled"
	// TopicProvisioningStateCreating specifies the topic provisioning state creating state for topic provisioning state.
	TopicProvisioningStateCreating TopicProvisioningState = "Creating"
	// TopicProvisioningStateDeleting specifies the topic provisioning state deleting state for topic provisioning state.
	TopicProvisioningStateDeleting TopicProvisioningState = "Deleting"
	// TopicProvisioningStateFailed specifies the topic provisioning state failed state for topic provisioning state.
	TopicProvisioningStateFailed TopicProvisioningState = "Failed"
	// TopicProvisioningStateSucceeded specifies the topic provisioning state succeeded state for topic provisioning state.
	TopicProvisioningStateSucceeded TopicProvisioningState = "Succeeded"
	// TopicProvisioningStateUpdating specifies the topic provisioning state updating state for topic provisioning state.
	TopicProvisioningStateUpdating TopicProvisioningState = "Updating"
)

// TopicTypeProvisioningState enumerates the values for topic type provisioning state.
type TopicTypeProvisioningState string

const (
	// TopicTypeProvisioningStateCanceled specifies the topic type provisioning state canceled state for topic type
	// provisioning state.
	TopicTypeProvisioningStateCanceled TopicTypeProvisioningState = "Canceled"
	// TopicTypeProvisioningStateCreating specifies the topic type provisioning state creating state for topic type
	// provisioning state.
	TopicTypeProvisioningStateCreating TopicTypeProvisioningState = "Creating"
	// TopicTypeProvisioningStateDeleting specifies the topic type provisioning state deleting state for topic type
	// provisioning state.
	TopicTypeProvisioningStateDeleting TopicTypeProvisioningState = "Deleting"
	// TopicTypeProvisioningStateFailed specifies the topic type provisioning state failed state for topic type
	// provisioning state.
	TopicTypeProvisioningStateFailed TopicTypeProvisioningState = "Failed"
	// TopicTypeProvisioningStateSucceeded specifies the topic type provisioning state succeeded state for topic type
	// provisioning state.
	TopicTypeProvisioningStateSucceeded TopicTypeProvisioningState = "Succeeded"
	// TopicTypeProvisioningStateUpdating specifies the topic type provisioning state updating state for topic type
	// provisioning state.
	TopicTypeProvisioningStateUpdating TopicTypeProvisioningState = "Updating"
)

// EventHubEventSubscriptionDestination is information about the event hub destination for an event subscription
type EventHubEventSubscriptionDestination struct {
	EndpointType                                    EndpointType `json:"endpointType,omitempty"`
	*EventHubEventSubscriptionDestinationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	ehesd.EndpointType = EndpointTypeEventHub
	type Alias EventHubEventSubscriptionDestination
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ehesd),
	})
}

// AsWebHookEventSubscriptionDestination is the EventSubscriptionDestination implementation for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) AsWebHookEventSubscriptionDestination() (*WebHookEventSubscriptionDestination, bool) {
	return nil, false
}

// AsEventHubEventSubscriptionDestination is the EventSubscriptionDestination implementation for EventHubEventSubscriptionDestination.
func (ehesd EventHubEventSubscriptionDestination) AsEventHubEventSubscriptionDestination() (*EventHubEventSubscriptionDestination, bool) {
	return &ehesd, true
}

// EventHubEventSubscriptionDestinationProperties is the properties for a event hub destination.
type EventHubEventSubscriptionDestinationProperties struct {
	ResourceID *string `json:"resourceId,omitempty"`
}

// EventSubscription is event Subscription
type EventSubscription struct {
	autorest.Response            `json:"-"`
	ID                           *string `json:"id,omitempty"`
	Name                         *string `json:"name,omitempty"`
	Type                         *string `json:"type,omitempty"`
	*EventSubscriptionProperties `json:"properties,omitempty"`
}

// EventSubscriptionDestination is information about the destination for an event subscription
type EventSubscriptionDestination interface {
	AsWebHookEventSubscriptionDestination() (*WebHookEventSubscriptionDestination, bool)
	AsEventHubEventSubscriptionDestination() (*EventHubEventSubscriptionDestination, bool)
}

func unmarshalEventSubscriptionDestination(body []byte) (EventSubscriptionDestination, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["endpointType"] {
	case string(EndpointTypeWebHook):
		var whesd WebHookEventSubscriptionDestination
		err := json.Unmarshal(body, &whesd)
		return whesd, err
	case string(EndpointTypeEventHub):
		var ehesd EventHubEventSubscriptionDestination
		err := json.Unmarshal(body, &ehesd)
		return ehesd, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalEventSubscriptionDestinationArray(body []byte) ([]EventSubscriptionDestination, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	esdArray := make([]EventSubscriptionDestination, len(rawMessages))

	for index, rawMessage := range rawMessages {
		esd, err := unmarshalEventSubscriptionDestination(*rawMessage)
		if err != nil {
			return nil, err
		}
		esdArray[index] = esd
	}
	return esdArray, nil
}

// EventSubscriptionFilter is filter for the Event Subscription
type EventSubscriptionFilter struct {
	SubjectBeginsWith      *string   `json:"subjectBeginsWith,omitempty"`
	SubjectEndsWith        *string   `json:"subjectEndsWith,omitempty"`
	IncludedEventTypes     *[]string `json:"includedEventTypes,omitempty"`
	IsSubjectCaseSensitive *bool     `json:"isSubjectCaseSensitive,omitempty"`
}

// EventSubscriptionFullURL is full endpoint url of an event subscription
type EventSubscriptionFullURL struct {
	autorest.Response `json:"-"`
	EndpointURL       *string `json:"endpointUrl,omitempty"`
}

// EventSubscriptionProperties is properties of the Event Subscription
type EventSubscriptionProperties struct {
	Topic             *string                            `json:"topic,omitempty"`
	ProvisioningState EventSubscriptionProvisioningState `json:"provisioningState,omitempty"`
	Destination       EventSubscriptionDestination       `json:"destination,omitempty"`
	Filter            *EventSubscriptionFilter           `json:"filter,omitempty"`
	Labels            *[]string                          `json:"labels,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EventSubscriptionProperties struct.
func (esp *EventSubscriptionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["topic"]
	if v != nil {
		var topic string
		err = json.Unmarshal(*m["topic"], &topic)
		if err != nil {
			return err
		}
		esp.Topic = &topic
	}

	v = m["provisioningState"]
	if v != nil {
		var provisioningState EventSubscriptionProvisioningState
		err = json.Unmarshal(*m["provisioningState"], &provisioningState)
		if err != nil {
			return err
		}
		esp.ProvisioningState = provisioningState
	}

	v = m["destination"]
	if v != nil {
		destination, err := unmarshalEventSubscriptionDestination(*m["destination"])
		if err != nil {
			return err
		}
		esp.Destination = destination
	}

	v = m["filter"]
	if v != nil {
		var filter EventSubscriptionFilter
		err = json.Unmarshal(*m["filter"], &filter)
		if err != nil {
			return err
		}
		esp.Filter = &filter
	}

	v = m["labels"]
	if v != nil {
		var labels []string
		err = json.Unmarshal(*m["labels"], &labels)
		if err != nil {
			return err
		}
		esp.Labels = &labels
	}

	return nil
}

// EventSubscriptionsListResult is result of the List EventSubscriptions operation
type EventSubscriptionsListResult struct {
	autorest.Response `json:"-"`
	Value             *[]EventSubscription `json:"value,omitempty"`
}

// EventSubscriptionUpdateParameters is properties of the Event Subscription update
type EventSubscriptionUpdateParameters struct {
	Destination EventSubscriptionDestination `json:"destination,omitempty"`
	Filter      *EventSubscriptionFilter     `json:"filter,omitempty"`
	Labels      *[]string                    `json:"labels,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for EventSubscriptionUpdateParameters struct.
func (esup *EventSubscriptionUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["destination"]
	if v != nil {
		destination, err := unmarshalEventSubscriptionDestination(*m["destination"])
		if err != nil {
			return err
		}
		esup.Destination = destination
	}

	v = m["filter"]
	if v != nil {
		var filter EventSubscriptionFilter
		err = json.Unmarshal(*m["filter"], &filter)
		if err != nil {
			return err
		}
		esup.Filter = &filter
	}

	v = m["labels"]
	if v != nil {
		var labels []string
		err = json.Unmarshal(*m["labels"], &labels)
		if err != nil {
			return err
		}
		esup.Labels = &labels
	}

	return nil
}

// EventType is event Type for a subject under a topic
type EventType struct {
	ID                   *string `json:"id,omitempty"`
	Name                 *string `json:"name,omitempty"`
	Type                 *string `json:"type,omitempty"`
	*EventTypeProperties `json:"properties,omitempty"`
}

// EventTypeProperties is properties of the event type
type EventTypeProperties struct {
	DisplayName *string `json:"displayName,omitempty"`
	Description *string `json:"description,omitempty"`
	SchemaURL   *string `json:"schemaUrl,omitempty"`
}

// EventTypesListResult is result of the List Event Types operation
type EventTypesListResult struct {
	autorest.Response `json:"-"`
	Value             *[]EventType `json:"value,omitempty"`
}

// Operation is represents an operation returned by the GetOperations request
type Operation struct {
	Name       *string                 `json:"name,omitempty"`
	Display    *OperationInfo          `json:"display,omitempty"`
	Origin     OperationOrigin         `json:"origin,omitempty"`
	Properties *map[string]interface{} `json:"properties,omitempty"`
}

// OperationInfo is information about an operation
type OperationInfo struct {
	Provider    *string `json:"provider,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Operation   *string `json:"operation,omitempty"`
	Description *string `json:"description,omitempty"`
}

// OperationsListResult is result of the List Operations operation
type OperationsListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
}

// Resource is definition of a Resource
type Resource struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// Topic is eventGrid Topic
type Topic struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	*TopicProperties  `json:"properties,omitempty"`
}

// TopicProperties is properties of the Topic
type TopicProperties struct {
	ProvisioningState TopicProvisioningState `json:"provisioningState,omitempty"`
	Endpoint          *string                `json:"endpoint,omitempty"`
}

// TopicRegenerateKeyRequest is topic regenerate share access key key request
type TopicRegenerateKeyRequest struct {
	KeyName *string `json:"keyName,omitempty"`
}

// TopicSharedAccessKeys is shared access keys of the Topic
type TopicSharedAccessKeys struct {
	autorest.Response `json:"-"`
	Key1              *string `json:"key1,omitempty"`
	Key2              *string `json:"key2,omitempty"`
}

// TopicsListResult is result of the List Topics operation
type TopicsListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Topic `json:"value,omitempty"`
}

// TopicTypeInfo is properties of a topic type info.
type TopicTypeInfo struct {
	autorest.Response    `json:"-"`
	ID                   *string `json:"id,omitempty"`
	Name                 *string `json:"name,omitempty"`
	Type                 *string `json:"type,omitempty"`
	*TopicTypeProperties `json:"properties,omitempty"`
}

// TopicTypeProperties is properties of a topic type.
type TopicTypeProperties struct {
	Provider           *string                    `json:"provider,omitempty"`
	DisplayName        *string                    `json:"displayName,omitempty"`
	Description        *string                    `json:"description,omitempty"`
	ResourceRegionType ResourceRegionType         `json:"resourceRegionType,omitempty"`
	ProvisioningState  TopicTypeProvisioningState `json:"provisioningState,omitempty"`
	SupportedLocations *[]string                  `json:"supportedLocations,omitempty"`
}

// TopicTypesListResult is result of the List Topic Types operation
type TopicTypesListResult struct {
	autorest.Response `json:"-"`
	Value             *[]TopicTypeInfo `json:"value,omitempty"`
}

// TrackedResource is definition of a Tracked Resource
type TrackedResource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// WebHookEventSubscriptionDestination is information about the webhook destination for an event subscription
type WebHookEventSubscriptionDestination struct {
	EndpointType                                   EndpointType `json:"endpointType,omitempty"`
	*WebHookEventSubscriptionDestinationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	whesd.EndpointType = EndpointTypeWebHook
	type Alias WebHookEventSubscriptionDestination
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(whesd),
	})
}

// AsWebHookEventSubscriptionDestination is the EventSubscriptionDestination implementation for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) AsWebHookEventSubscriptionDestination() (*WebHookEventSubscriptionDestination, bool) {
	return &whesd, true
}

// AsEventHubEventSubscriptionDestination is the EventSubscriptionDestination implementation for WebHookEventSubscriptionDestination.
func (whesd WebHookEventSubscriptionDestination) AsEventHubEventSubscriptionDestination() (*EventHubEventSubscriptionDestination, bool) {
	return nil, false
}

// WebHookEventSubscriptionDestinationProperties is information about the webhook destination properties for an event
// subscription
type WebHookEventSubscriptionDestinationProperties struct {
	EndpointURL     *string `json:"endpointUrl,omitempty"`
	EndpointBaseURL *string `json:"endpointBaseUrl,omitempty"`
}
