// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package simpledb provides the client and types for making API
// requests to Amazon SimpleDB.
//
// Amazon SimpleDB is a web service providing the core database functions of
// data indexing and querying in the cloud. By offloading the time and effort
// associated with building and operating a web-scale database, SimpleDB provides
// developers the freedom to focus on application development.  A traditional,
// clustered relational database requires a sizable upfront capital outlay,
// is complex to design, and often requires extensive and repetitive database
// administration. Amazon SimpleDB is dramatically simpler, requiring no schema,
// automatically indexing your data and providing a simple API for storage and
// access. This approach eliminates the administrative burden of data modeling,
// index maintenance, and performance tuning. Developers gain access to this
// functionality within Amazon's proven computing environment, are able to scale
// instantly, and pay only for what they use.
//
// Visit http://aws.amazon.com/simpledb/ (http://aws.amazon.com/simpledb/) for
// more information.
//
// See simpledb package documentation for more information.
// https://docs.aws.amazon.com/sdk-for-go/api/service/simpledb/
//
// Using the Client
//
// To use the client for Amazon SimpleDB you will first need
// to create a new instance of it.
//
// When creating a client for an AWS service you'll first need to have a Session
// already created. The Session provides configuration that can be shared
// between multiple service clients. Additional configuration can be applied to
// the Session and service's client when they are constructed. The aws package's
// Config type contains several fields such as Region for the AWS Region the
// client should make API requests too. The optional Config value can be provided
// as the variadic argument for Sessions and client creation.
//
// Once the service's client is created you can use it to make API requests the
// AWS service. These clients are safe to use concurrently.
//
//   // Create a session to share configuration, and load external configuration.
//   sess := session.Must(session.NewSession())
//
//   // Create the service's client with the session.
//   svc := simpledb.New(sess)
//
// See the SDK's documentation for more information on how to use service clients.
// https://docs.aws.amazon.com/sdk-for-go/api/
//
// See aws package's Config type for more information on configuration options.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/#Config
//
// See the Amazon SimpleDB client SimpleDB for more
// information on creating the service's client.
// https://docs.aws.amazon.com/sdk-for-go/api/service/simpledb/#New
//
// Once the client is created you can make an API request to the service.
// Each API method takes a input parameter, and returns the service response
// and an error.
//
// The API method will document which error codes the service can be returned
// by the operation if the service models the API operation's errors. These
// errors will also be available as const strings prefixed with "ErrCode".
//
//   result, err := svc.BatchDeleteAttributes(params)
//   if err != nil {
//       // Cast err to awserr.Error to handle specific error codes.
//       aerr, ok := err.(awserr.Error)
//       if ok && aerr.Code() == <error code to check for> {
//           // Specific error code handling
//       }
//       return err
//   }
//
//   fmt.Println("BatchDeleteAttributes result:")
//   fmt.Println(result)
//
// Using the Client with Context
//
// The service's client also provides methods to make API requests with a Context
// value. This allows you to control the timeout, and cancellation of pending
// requests. These methods also take request Option as variadic parameter to apply
// additional configuration to the API request.
//
//   ctx := context.Background()
//
//   result, err := svc.BatchDeleteAttributesWithContext(ctx, params)
//
// See the request package documentation for more information on using Context pattern
// with the SDK.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/request/
package simpledb
