/* rbpage.h
 *
 * Internal info for rbpage.c.
 */
/* This software is copyrighted as detailed in the LICENSE file. */

#ifndef RBPAGE_H
#define RBPAGE_H

#include <libxml/HTMLparser.h>

#define TT_ALIGN_NONE		0
#define TT_ALIGN_RIGHT		1
#define TT_ALIGN_JUSTIFY	2
#define TT_ALIGN_CENTER 	3
#define TT_ALIGN_LEFT		4

#define HKEY_INACTIVE		0
#define HKEY_FIND_1ST_BIG	1
#define HKEY_FIND_1ST_B 	2
#define HKEY_FIND_BIG_OR_SMALL	3
#define HKEY_FIND_B_AFTER_BIG	4
#define HKEY_FIND_CLOSING_BIG	5
#define HKEY_FIND_B_AFTER_SMALL	6
#define HKEY_FIND_CLOSING_SMALL	7

#define RBP_SPACE_OK_HERE	0x0001
#define RBP_CONVERT_NL2SP	0x0002

#define RBP_SAW_DOT1		0x0010
#define RBP_SAW_DOT2		0x0020
#define RBP_SAW_DQUOTE		0x0040
#define RBP_SAW_DASH		0x0080

#define RBP_ALL_SAW_BITS	0x00F0

extern char *alignStrs[];

struct TagTree {
    struct TagTree *parent, *child, *sibling, *nextOrd;
    int elnum, align;
    int ord;
};

typedef struct {
    TagTree *tagNode;
    int32 htmlOffset;
} NodeWithOffset;

struct HtmlPosition {
    int32 htmlOffset;
    short joinOrd;
    short flags;
};

typedef struct {
    HtmlPosition pos;
    char string[1];
} StringWithPosition;

typedef struct JoinGroup {
    struct JoinGroup *next;
    struct RbPage *pageList;
    int ord, todo, pageCount;
} JoinGroup;

struct RbPage {
    struct RbMake *rb;
    struct RbPage *next;
    MBuf *content;
    MArray *paras, *keys, *fontSize;
    HashTable *names;
    const char *url, *tocName;
    char *hkeyPrevWord;
    TagTree *tagTreeRoot, *tagTreePos, *bookParaPTag;
    JoinGroup *joinGroup;
    htmlParserCtxtPtr ctxt;
    int32 tocFlags, titlePos, hkeyParaPos, hkeyWordPos;
    int bookParaStartTagPos, bookParaEndTagPos, paraContentCnt, charEncoding;
    int type, depth, pre_ellipsis_len;
    short joinOrd, discardHtmlLevel, includeRawWhitespaceLevel, hkeyScanMode;
    short hkeySufPos[3];
    short parseFlags, dquote_level;
    bool discardPage, firstPage, parsePage, convertImage;
};

#endif
