/* hashtable.h
 *
 * Internal info for hashtable.c.
 */
/* This file is a heavily altered version of a set of hash routines by
 * Geoffrey Collyer.  See hash.c for his copyright.  See the LICENSE file
 * for my copyright.
 */

#ifndef HASHTABLE_H
#define HASHTABLE_H

typedef struct HashEnt {
    struct HashEnt *he_next;		/* in hash chain */
    const char *he_key;
    void *he_data;
    int he_keylen;		/* to help verify a match */
} HashEnt;

struct HashTable {
    HashEnt **ht_addr;		/* array of HashEnt pointers */
    unsigned ht_size;
    unsigned ht_count;
    char ht_magic;
    bool autoDupData, autoFreeData;
};

#endif
