#ifndef NIKONLENSID_H
#define NIKONLENSID_H

#include <string>
#include <stdint.h>

#ifdef WIN32
#include <winsock2.h> 
#else
#include <arpa/inet.h>
#endif

#define FMLVERSION "4.4.527.01"
#define FMLDATE "2017-02-27"
//------------------------------------------------------------------------------
//
//
// Created by Robert Rottmerhusen 2005 - 2017
// http://www.rottmerhusen.com (lens_id@rottmerhusen.com)
//
// For contributor info and more visit my online list:
// http://www.rottmerhusen.com/objektives/lensid/thirdparty.html
//
//
// Seven misidentified lenses due to double LensIDs:
//
// 2F 48 30 44 24 24 29 02.1: Nikon AF Zoom-Nikkor 20-35mm f/2.8D IF
// 2F 48 30 44 24 24 29 02.2: Tokina AT-X 235 AF PRO (AF 20-35mm f/2.8)
//
// 32 54 6A 6A 24 24 35 02.1: Nikon AF Micro-Nikkor 105mm f/2.8D
// 32 54 6A 6A 24 24 35 02.2: Sigma Macro 105mm F2.8 EX DG
//
// 7A 3C 1F 37 30 30 7E 06.1: Nikon AF-S DX Zoom-Nikkor 12-24mm f/4G IF-ED
// 7A 3C 1F 37 30 30 7E 06.2: Tokina AT-X 124 AF PRO DX II (AF 12-24mm f/4)
//
// 8B 40 2D 80 2C 3C FD 0E.1: Nikon AF-S DX VR Zoom-Nikkor 18-200mm f/3.5-5.6G IF-ED
// 8B 40 2D 80 2C 3C FD 0E.2: Nikon AF-S DX VR Zoom-Nikkor 18-200mm f/3.5-5.6G IF-ED II
//
// 32 53 64 64 24 24 35 02.1: Tamron SP AF 90mm F/2.8 Macro 1:1 (172E)
// 32 53 64 64 24 24 35 02.2: Tamron SP AF 90mm F/2.8 Di Macro 1:1 (272E)
//
// 2F 40 30 44 2C 34 29 02.1: Tokina AF 235 II (AF 20-35mm f/3.5-4.5)
// 2F 40 30 44 2C 34 29 02.2: Tokina AF 193 (AF 19-35mm f/3.5-4.5)
//
// 25 48 3C 5C 24 24 1B 02.1: Tokina AT-X 287 AF PRO SV (AF 28-70mm f/2.8)
// 25 48 3C 5C 24 24 1B 02.2: Tokina AT-X 270 AF PRO II (AF 28-70mm f/2.6-2.8)
//
//
// product number/order code not complete
//
// Free use in non-commercial, GPL or open source software only!
// Please contact me for adding lenses or use in commercial software.
//
//"data from TAG 0x98" "ltyp" " "TC" "MID" "maker" "PN" "lens name from manuf";
//
//------------------------------------------------------------------------------
// Nikkor lenses by their LensID
//------------------------------------------------------------------------------
//


struct lensstruct  {unsigned char lid,stps,focs,focl,aps,apl,lfw, ltype, tcinfo, dblid, mid; const char *manuf, *lnumber, *lensname;};
union lensunion {
	lensstruct lens;
	long long id;
};

//static const struct {unsigned char lid,stps,focs,focl,aps,apl,lfw, ltype, tcinfo, dblid, mid; const char *manuf, *lnumber, *lensname;}
lensunion fmountlens[] = {
//{0x8B,0x40,0x2D,0x80,0x2C,0x3C,0xFD,0x0E,0x00,0x00,0x00, "Nikon", "",         "AF-S DX VR Zoom-Nikkor 18-200mm f/3.5-5.6G IF-ED II"},
{0x01,0x58,0x50,0x50,0x14,0x14,0x02,0x00,0x00,0x00,0x00, "Nikon", "JAA00901", "AF Nikkor 50mm f/1.8"},
{0x01,0x58,0x50,0x50,0x14,0x14,0x05,0x00,0x00,0x00,0x00, "Nikon", "JAA00901", "AF Nikkor 50mm f/1.8"},
{0x02,0x42,0x44,0x5C,0x2A,0x34,0x02,0x00,0x00,0x00,0x00, "Nikon", "JAA72701", "AF Zoom-Nikkor 35-70mm f/3.3-4.5"},
{0x02,0x42,0x44,0x5C,0x2A,0x34,0x08,0x00,0x00,0x00,0x00, "Nikon", "JAA72701", "AF Zoom-Nikkor 35-70mm f/3.3-4.5"},
{0x03,0x48,0x5C,0x81,0x30,0x30,0x02,0x00,0x00,0x00,0x00, "Nikon", "JAA72801", "AF Zoom-Nikkor 70-210mm f/4"},
{0x04,0x48,0x3C,0x3C,0x24,0x24,0x03,0x00,0x00,0x00,0x00, "Nikon", "JAA12001", "AF Nikkor 28mm f/2.8"},
{0x05,0x54,0x50,0x50,0x0C,0x0C,0x04,0x00,0x00,0x00,0x00, "Nikon", "JAA01001", "AF Nikkor 50mm f/1.4"},
{0x06,0x54,0x53,0x53,0x24,0x24,0x06,0x00,0x40,0x00,0x00, "Nikon", "JAA62101", "AF Micro-Nikkor 55mm f/2.8"},
{0x07,0x40,0x3C,0x62,0x2C,0x34,0x03,0x00,0x00,0x00,0x00, "Nikon", "JAA72901", "AF Zoom-Nikkor 28-85mm f/3.5-4.5"},
{0x08,0x40,0x44,0x6A,0x2C,0x34,0x04,0x00,0x00,0x00,0x00, "Nikon", "JAA73001", "AF Zoom-Nikkor 35-105mm f/3.5-4.5"},
{0x09,0x48,0x37,0x37,0x24,0x24,0x04,0x00,0x00,0x00,0x00, "Nikon", "JAA12101", "AF Nikkor 24mm f/2.8"},
{0x0A,0x48,0x8E,0x8E,0x24,0x24,0x03,0x00,0x00,0x00,0x00, "Nikon", "JAA322AA", "AF Nikkor 300mm f/2.8 IF-ED"},
{0x0A,0x48,0x8E,0x8E,0x24,0x24,0x05,0x00,0x00,0x00,0x00, "Nikon", "JAA322AB", "AF Nikkor 300mm f/2.8 IF-ED"},
{0x0B,0x48,0x7C,0x7C,0x24,0x24,0x05,0x00,0x00,0x00,0x00, "Nikon", "JAA32101", "AF Nikkor 180mm f/2.8 IF-ED"},
//0C
{0x0D,0x40,0x44,0x72,0x2C,0x34,0x07,0x00,0x00,0x00,0x00, "Nikon", "JAA73101", "AF Zoom-Nikkor 35-135mm f/3.5-4.5"},
{0x0E,0x48,0x5C,0x81,0x30,0x30,0x05,0x00,0x00,0x00,0x00, "Nikon", "", "AF Zoom-Nikkor 70-210mm f/4"},
{0x0F,0x58,0x50,0x50,0x14,0x14,0x05,0x00,0x00,0x00,0x00, "Nikon", "JAA009AD", "AF Nikkor 50mm f/1.8 N"},
{0x10,0x48,0x8E,0x8E,0x30,0x30,0x08,0x00,0x00,0x00,0x00, "Nikon", "JAA32301", "AF Nikkor 300mm f/4 IF-ED"},
{0x11,0x48,0x44,0x5C,0x24,0x24,0x08,0x00,0x00,0x00,0x00, "Nikon", "JAA73301", "AF Zoom-Nikkor 35-70mm f/2.8"},
{0x12,0x48,0x5C,0x81,0x30,0x3C,0x09,0x00,0x00,0x00,0x00, "Nikon", "JAA73201", "AF Nikkor 70-210mm f/4-5.6"},
{0x13,0x42,0x37,0x50,0x2A,0x34,0x0B,0x00,0x00,0x00,0x00, "Nikon", "JAA73401", "AF Zoom-Nikkor 24-50mm f/3.3-4.5"},
{0x14,0x48,0x60,0x80,0x24,0x24,0x0B,0x00,0x00,0x00,0x00, "Nikon", "JAA73501", "AF Zoom-Nikkor 80-200mm f/2.8 ED"},
{0x15,0x4C,0x62,0x62,0x14,0x14,0x0C,0x00,0x00,0x00,0x00, "Nikon", "JAA32401", "AF Nikkor 85mm f/1.8"},
//16
{0x17,0x3C,0xA0,0xA0,0x30,0x30,0x0F,0x00,0x00,0x00,0x00, "Nikon", "JAA518AA", "Nikkor 500mm f/4 P ED IF"},
{0x17,0x3C,0xA0,0xA0,0x30,0x30,0x11,0x00,0x00,0x00,0x00, "Nikon", "JAA518AA", "Nikkor 500mm f/4 P ED IF"},
{0x18,0x40,0x44,0x72,0x2C,0x34,0x0E,0x00,0x00,0x00,0x00, "Nikon", "JAA736AA", "AF Zoom-Nikkor 35-135mm f/3.5-4.5 N"},
//19
{0x1A,0x54,0x44,0x44,0x18,0x18,0x11,0x00,0x00,0x00,0x00, "Nikon", "JAA12201", "AF Nikkor 35mm f/2"},
{0x1B,0x44,0x5E,0x8E,0x34,0x3C,0x10,0x00,0x00,0x00,0x00, "Nikon", "JAA738AA", "AF Zoom-Nikkor 75-300mm f/4.5-5.6"},
{0x1C,0x48,0x30,0x30,0x24,0x24,0x12,0x00,0x00,0x00,0x00, "Nikon", "JAA12301", "AF Nikkor 20mm f/2.8"},
{0x1D,0x42,0x44,0x5C,0x2A,0x34,0x12,0x00,0x00,0x00,0x00, "Nikon", "", "AF Zoom-Nikkor 35-70mm f/3.3-4.5 N"},
{0x1E,0x54,0x56,0x56,0x24,0x24,0x13,0x00,0x40,0x00,0x00, "Nikon", "JAA62201", "AF Micro-Nikkor 60mm f/2.8"},
{0x1F,0x54,0x6A,0x6A,0x24,0x24,0x14,0x00,0x40,0x00,0x00, "Nikon", "JAA62301", "AF Micro-Nikkor 105mm f/2.8"},
{0x20,0x48,0x60,0x80,0x24,0x24,0x15,0x00,0x00,0x00,0x00, "Nikon", "", "AF Zoom-Nikkor 80-200mm f/2.8 ED"},
{0x21,0x40,0x3C,0x5C,0x2C,0x34,0x16,0x00,0x00,0x00,0x00, "Nikon", "", "AF Zoom-Nikkor 28-70mm f/3.5-4.5"},
{0x22,0x48,0x72,0x72,0x18,0x18,0x16,0x00,0x00,0x00,0x00, "Nikon", "JAA32501", "AF DC-Nikkor 135mm f/2"},
{0x23,0x30,0xBE,0xCA,0x3C,0x48,0x17,0x00,0x00,0x00,0x00, "Nikon", "", "Zoom-Nikkor 1200-1700mm f/5.6-8 P ED IF"},
// - D - lenses from here
{0x24,0x48,0x60,0x80,0x24,0x24,0x1A,0x02,0x00,0x00,0x00, "Nikon", "JAA742DA", "AF Zoom-Nikkor 80-200mm f/2.8D ED"},
{0x25,0x48,0x44,0x5c,0x24,0x24,0x1B,0x02,0x00,0x00,0x00, "Nikon", "JAA743DA", "AF Zoom-Nikkor 35-70mm f/2.8D"},
{0x25,0x48,0x44,0x5C,0x24,0x24,0x3A,0x02,0x00,0x00,0x00, "Nikon", "JAA743DA", "AF Zoom-Nikkor 35-70mm f/2.8D"},
{0x25,0x48,0x44,0x5c,0x24,0x24,0x52,0x02,0x00,0x00,0x00, "Nikon", "JAA743DA", "AF Zoom-Nikkor 35-70mm f/2.8D"},
{0x26,0x40,0x3C,0x5C,0x2C,0x34,0x1C,0x02,0x00,0x00,0x00, "Nikon", "JAA744DA", "AF Zoom-Nikkor 28-70mm f/3.5-4.5D"},
// ^- not yet verified
{0x27,0x48,0x8E,0x8E,0x24,0x24,0x1D,0x02,0x07,0x00,0x00, "Nikon", "JAA326DA", "AF-I Nikkor 300mm f/2.8D IF-ED"},
{0x27,0x48,0x8E,0x8E,0x24,0x24,0xF1,0x02,0x0F,0x00,0x00, "Nikon", "JAA326DA", "AF-I Nikkor 300mm f/2.8D IF-ED + TC-14E"},
{0x27,0x48,0x8E,0x8E,0x24,0x24,0xE1,0x02,0x0F,0x00,0x00, "Nikon", "JAA326DA", "AF-I Nikkor 300mm f/2.8D IF-ED + TC-17E"},
{0x27,0x48,0x8E,0x8E,0x24,0x24,0xF2,0x02,0x0F,0x00,0x00, "Nikon", "JAA326DA", "AF-I Nikkor 300mm f/2.8D IF-ED + TC-20E"},
{0x28,0x3C,0xA6,0xA6,0x30,0x30,0x1D,0x02,0x07,0x00,0x00, "Nikon", "JAA519DA", "AF-I Nikkor 600mm f/4D IF-ED"},
{0x28,0x3C,0xA6,0xA6,0x30,0x30,0xF1,0x02,0x0F,0x00,0x00, "Nikon", "JAA519DA", "AF-I Nikkor 600mm f/4D IF-ED + TC-14E"},
{0x28,0x3C,0xA6,0xA6,0x30,0x30,0xE1,0x02,0x0F,0x00,0x00, "Nikon", "JAA519DA", "AF-I Nikkor 600mm f/4D IF-ED + TC-17E"},
{0x28,0x3C,0xA6,0xA6,0x30,0x30,0xF2,0x02,0x0F,0x00,0x00, "Nikon", "JAA519DA", "AF-I Nikkor 600mm f/4D IF-ED + TC-20E"},
//29
{0x2A,0x54,0x3C,0x3C,0x0C,0x0C,0x26,0x02,0x00,0x00,0x00, "Nikon", "JAA124DA", "AF Nikkor 28mm f/1.4D"},
{0x2B,0x3C,0x44,0x60,0x30,0x3C,0x1F,0x02,0x00,0x00,0x00, "Nikon", "", "AF Zoom-Nikkor 35-80mm f/4-5.6D"},
{0x2C,0x48,0x6A,0x6A,0x18,0x18,0x27,0x02,0x00,0x00,0x00, "Nikon", "JAA327DA", "AF DC-Nikkor 105mm f/2D"},
{0x2D,0x48,0x80,0x80,0x30,0x30,0x21,0x02,0x40,0x00,0x00, "Nikon", "JAA624DA", "AF Micro-Nikkor 200mm f/4D IF-ED"},
{0x2E,0x48,0x5C,0x82,0x30,0x3C,0x22,0x02,0x00,0x00,0x00, "Nikon", "JAA747DA", "AF Nikkor 70-210mm f/4-5.6D"},
{0x2E,0x48,0x5C,0x82,0x30,0x3C,0x28,0x02,0x00,0x00,0x00, "Nikon", "JAA747DA", "AF Nikkor 70-210mm f/4-5.6D"},
{0x2F,0x48,0x30,0x44,0x24,0x24,0x29,0x02,0x00,0x01,0x00, "Nikon", "JAA746DA", "AF Zoom-Nikkor 20-35mm f/2.8D IF"},
{0x30,0x48,0x98,0x98,0x24,0x24,0x24,0x02,0x07,0x00,0x00, "Nikon", "JAA520DA", "AF-I Nikkor 400mm f/2.8D IF-ED"},
{0x30,0x48,0x98,0x98,0x24,0x24,0xF1,0x02,0x0F,0x00,0x00, "Nikon", "JAA520DA", "AF-I Nikkor 400mm f/2.8D IF-ED + TC-14E"},
{0x30,0x48,0x98,0x98,0x24,0x24,0xE1,0x02,0x0F,0x00,0x00, "Nikon", "JAA520DA", "AF-I Nikkor 400mm f/2.8D IF-ED + TC-17E"},
{0x30,0x48,0x98,0x98,0x24,0x24,0xF2,0x02,0x0F,0x00,0x00, "Nikon", "JAA520DA", "AF-I Nikkor 400mm f/2.8D IF-ED + TC-20E"},
{0x31,0x54,0x56,0x56,0x24,0x24,0x25,0x02,0x40,0x00,0x00, "Nikon", "JAA625DA", "AF Micro-Nikkor 60mm f/2.8D"},
{0x32,0x54,0x6A,0x6A,0x24,0x24,0x35,0x02,0x40,0x01,0x00, "Nikon", "JAA627DA", "AF Micro-Nikkor 105mm f/2.8D"},
{0x33,0x48,0x2D,0x2D,0x24,0x24,0x31,0x02,0x00,0x00,0x00, "Nikon", "JAA126DA", "AF Nikkor 18mm f/2.8D"},
{0x34,0x48,0x29,0x29,0x24,0x24,0x32,0x02,0x00,0x00,0x00, "Nikon", "JAA626DA", "AF Fisheye Nikkor 16mm f/2.8D"},
{0x35,0x3C,0xA0,0xA0,0x30,0x30,0x33,0x02,0x07,0x00,0x00, "Nikon", "JAA521DA", "AF-I Nikkor 500mm f/4D IF-ED"},
{0x35,0x3C,0xA0,0xA0,0x30,0x30,0xF1,0x02,0x0F,0x00,0x00, "Nikon", "JAA521DA", "AF-I Nikkor 500mm f/4D IF-ED + TC-14E"},
{0x35,0x3C,0xA0,0xA0,0x30,0x30,0xE1,0x02,0x0F,0x00,0x00, "Nikon", "JAA521DA", "AF-I Nikkor 500mm f/4D IF-ED + TC-17E"},
{0x35,0x3C,0xA0,0xA0,0x30,0x30,0xF2,0x02,0x0F,0x00,0x00, "Nikon", "JAA521DA", "AF-I Nikkor 500mm f/4D IF-ED + TC-20E"},
{0x36,0x48,0x37,0x37,0x24,0x24,0x34,0x02,0x00,0x00,0x00, "Nikon", "JAA125DA", "AF Nikkor 24mm f/2.8D"},
{0x37,0x48,0x30,0x30,0x24,0x24,0x36,0x02,0x00,0x00,0x00, "Nikon", "JAA127DA", "AF Nikkor 20mm f/2.8D"},
{0x38,0x4C,0x62,0x62,0x14,0x14,0x37,0x02,0x00,0x00,0x00, "Nikon", "JAA328DA", "AF Nikkor 85mm f/1.8D"},
//39                38
{0x3A,0x40,0x3C,0x5C,0x2C,0x34,0x39,0x02,0x00,0x00,0x00, "Nikon", "JAA744DA", "AF Zoom-Nikkor 28-70mm f/3.5-4.5D"},
{0x3B,0x48,0x44,0x5C,0x24,0x24,0x3A,0x02,0x00,0x00,0x00, "Nikon", "JAA743DA", "AF Zoom-Nikkor 35-70mm f/2.8D N"},
{0x3C,0x48,0x60,0x80,0x24,0x24,0x3B,0x02,0x00,0x00,0x00, "Nikon", "", "AF Zoom-Nikkor 80-200mm f/2.8D ED"},
{0x3D,0x3C,0x44,0x60,0x30,0x3C,0x3E,0x02,0x00,0x00,0x00, "Nikon", "", "AF Zoom-Nikkor 35-80mm f/4-5.6D"},
{0x3E,0x48,0x3C,0x3C,0x24,0x24,0x3D,0x02,0x00,0x00,0x00, "Nikon", "JAA128DA", "AF Nikkor 28mm f/2.8D"},
{0x3F,0x40,0x44,0x6A,0x2C,0x34,0x45,0x02,0x00,0x00,0x00, "Nikon", "JAA748DA", "AF Zoom-Nikkor 35-105mm f/3.5-4.5D"},
//40
{0x41,0x48,0x7c,0x7c,0x24,0x24,0x43,0x02,0x00,0x00,0x00, "Nikon", "JAA330DA", "AF Nikkor 180mm f/2.8D IF-ED"},
{0x42,0x54,0x44,0x44,0x18,0x18,0x44,0x02,0x00,0x00,0x00, "Nikon", "JAA129DA", "AF Nikkor 35mm f/2D"},
{0x43,0x54,0x50,0x50,0x0C,0x0C,0x46,0x02,0x00,0x00,0x00, "Nikon", "JAA011DB", "AF Nikkor 50mm f/1.4D"},
{0x44,0x44,0x60,0x80,0x34,0x3C,0x47,0x02,0x00,0x00,0x00, "Nikon", "JAA753DB", "AF Zoom-Nikkor 80-200mm f/4.5-5.6D"},
{0x45,0x40,0x3C,0x60,0x2C,0x3C,0x48,0x02,0x00,0x00,0x00, "Nikon", "JAA752DA", "AF Zoom-Nikkor 28-80mm f/3.5-5.6D"},
{0x46,0x3C,0x44,0x60,0x30,0x3C,0x49,0x02,0x00,0x00,0x00, "Nikon", "JAA754DA", "AF Zoom-Nikkor 35-80mm f/4-5.6D N"},
{0x47,0x42,0x37,0x50,0x2A,0x34,0x4A,0x02,0x00,0x00,0x00, "Nikon", "JAA756DA", "AF Zoom-Nikkor 24-50mm f/3.3-4.5D"},
{0x48,0x48,0x8E,0x8E,0x24,0x24,0x4B,0x02,0x07,0x00,0x00, "Nikon", "JAA333DA", "AF-S Nikkor 300mm f/2.8D IF-ED"},
{0x48,0x48,0x8E,0x8E,0x24,0x24,0xF1,0x02,0x0F,0x00,0x00, "Nikon", "JAA333DA", "AF-S Nikkor 300mm f/2.8D IF-ED + TC-14E"},
{0x48,0x48,0x8E,0x8E,0x24,0x24,0xE1,0x02,0x0F,0x00,0x00, "Nikon", "JAA333DA", "AF-S Nikkor 300mm f/2.8D IF-ED + TC-17E"},
{0x48,0x48,0x8E,0x8E,0x24,0x24,0xF2,0x02,0x0F,0x00,0x00, "Nikon", "JAA333DA", "AF-S Nikkor 300mm f/2.8D IF-ED + TC-20E"},
{0x49,0x3C,0xA6,0xA6,0x30,0x30,0x4C,0x02,0x07,0x00,0x00, "Nikon", "JAA522DA", "AF-S Nikkor 600mm f/4D IF-ED"},
{0x49,0x3C,0xA6,0xA6,0x30,0x30,0xF1,0x02,0x0F,0x00,0x00, "Nikon", "JAA522DA", "AF-S Nikkor 600mm f/4D IF-ED + TC-14E"},
{0x49,0x3C,0xA6,0xA6,0x30,0x30,0xE1,0x02,0x0F,0x00,0x00, "Nikon", "JAA522DA", "AF-S Nikkor 600mm f/4D IF-ED + TC-17E"},
{0x49,0x3C,0xA6,0xA6,0x30,0x30,0xF2,0x02,0x0F,0x00,0x00, "Nikon", "JAA522DA", "AF-S Nikkor 600mm f/4D IF-ED + TC-20E"},
{0x4A,0x54,0x62,0x62,0x0C,0x0C,0x4D,0x02,0x00,0x00,0x00, "Nikon", "JAA332DA", "AF Nikkor 85mm f/1.4D IF"},
{0x4B,0x3C,0xA0,0xA0,0x30,0x30,0x4E,0x02,0x07,0x00,0x00, "Nikon", "JAA523DA", "AF-S Nikkor 500mm f/4D IF-ED"},
{0x4B,0x3C,0xA0,0xA0,0x30,0x30,0xF1,0x02,0x0F,0x00,0x00, "Nikon", "JAA523DA", "AF-S Nikkor 500mm f/4D IF-ED + TC-14E"},
{0x4B,0x3C,0xA0,0xA0,0x30,0x30,0xE1,0x02,0x0F,0x00,0x00, "Nikon", "JAA523DA", "AF-S Nikkor 500mm f/4D IF-ED + TC-17E"},
{0x4B,0x3C,0xA0,0xA0,0x30,0x30,0xF2,0x02,0x0F,0x00,0x00, "Nikon", "JAA523DA", "AF-S Nikkor 500mm f/4D IF-ED + TC-20E"},
{0x4C,0x40,0x37,0x6E,0x2C,0x3C,0x4F,0x02,0x00,0x00,0x00, "Nikon", "JAA757DA", "AF Zoom-Nikkor 24-120mm f/3.5-5.6D IF"},
{0x4D,0x40,0x3C,0x80,0x2C,0x3C,0x62,0x02,0x00,0x00,0x00, "Nikon", "JAA758DA", "AF Zoom-Nikkor 28-200mm f/3.5-5.6D IF"},
{0x4E,0x48,0x72,0x72,0x18,0x18,0x51,0x02,0x00,0x00,0x00, "Nikon", "JAA329DA", "AF DC-Nikkor 135mm f/2D"},
{0x4F,0x40,0x37,0x5C,0x2C,0x3C,0x53,0x06,0x00,0x00,0x00, "Nikon", "JBA701AA", "IX-Nikkor 24-70mm f/3.5-5.6"},
{0x50,0x48,0x56,0x7C,0x30,0x3C,0x54,0x06,0x00,0x00,0x00, "Nikon", "JBA702AA", "IX-Nikkor 60-180mm f/4-5.6"},
//                                                  "JBA703AC" "IX-Nikkor 20-60 mm f/3.5-5.6";
//51
//52
{0x53,0x48,0x60,0x80,0x24,0x24,0x57,0x02,0x00,0x00,0x00, "Nikon", "JAA762DA", "AF Zoom-Nikkor 80-200mm f/2.8D ED"},
{0x53,0x48,0x60,0x80,0x24,0x24,0x60,0x02,0x00,0x00,0x00, "Nikon", "JAA762DA", "AF Zoom-Nikkor 80-200mm f/2.8D ED"},
{0x54,0x44,0x5C,0x7C,0x34,0x3C,0x58,0x02,0x00,0x00,0x00, "Nikon", "JAA763DA", "AF Zoom-Micro Nikkor 70-180mm f/4.5-5.6D ED"},
{0x54,0x44,0x5C,0x7C,0x34,0x3C,0x61,0x02,0x00,0x00,0x00, "Nikon", "JAA763DA", "AF Zoom-Micro Nikkor 70-180mm f/4.5-5.6D ED"},
//55
{0x56,0x48,0x5C,0x8E,0x30,0x3C,0x5A,0x02,0x00,0x00,0x00, "Nikon", "JAA764DA", "AF Zoom-Nikkor 70-300mm f/4-5.6D ED"},
//57
//58
{0x59,0x48,0x98,0x98,0x24,0x24,0x5D,0x02,0x07,0x00,0x00, "Nikon", "JAA524DA", "AF-S Nikkor 400mm f/2.8D IF-ED"},
{0x59,0x48,0x98,0x98,0x24,0x24,0xF1,0x02,0x0F,0x00,0x00, "Nikon", "JAA524DA", "AF-S Nikkor 400mm f/2.8D IF-ED + TC-14E"},
{0x59,0x48,0x98,0x98,0x24,0x24,0xE1,0x02,0x0F,0x00,0x00, "Nikon", "JAA524DA", "AF-S Nikkor 400mm f/2.8D IF-ED + TC-17E"},
{0x59,0x48,0x98,0x98,0x24,0x24,0xF2,0x02,0x0F,0x00,0x00, "Nikon", "JAA524DA", "AF-S Nikkor 400mm f/2.8D IF-ED + TC-20E"},
{0x5A,0x3C,0x3E,0x56,0x30,0x3C,0x5E,0x06,0x00,0x00,0x00, "Nikon", "JBA704AA", "IX-Nikkor 30-60mm f/4-5.6"},
{0x5B,0x44,0x56,0x7C,0x34,0x3C,0x5F,0x06,0x00,0x00,0x00, "Nikon", "JBA705AA", "IX-Nikkor 60-180mm f/4.5-5.6"},
//                                                  "JBA706AC" "IX-Nikkor 20-60 mm f/3.5-5.6N";
//5C
{0x5D,0x48,0x3C,0x5C,0x24,0x24,0x63,0x02,0x01,0x00,0x00, "Nikon", "JAA767DA", "AF-S Zoom-Nikkor 28-70mm f/2.8D IF-ED"},
{0x5E,0x48,0x60,0x80,0x24,0x24,0x64,0x02,0x03,0x00,0x00, "Nikon", "JAA765DA", "AF-S Zoom-Nikkor 80-200mm f/2.8D IF-ED"},
{0x5F,0x40,0x3C,0x6A,0x2C,0x34,0x65,0x02,0x00,0x00,0x00, "Nikon", "JAA766DA", "AF Zoom-Nikkor 28-105mm f/3.5-4.5D IF"},
{0x60,0x40,0x3C,0x60,0x2C,0x3C,0x66,0x02,0x00,0x00,0x00, "Nikon", "JAA769DA", "AF Zoom-Nikkor 28-80mm f/3.5-5.6D"},
{0x61,0x44,0x5E,0x86,0x34,0x3C,0x67,0x02,0x00,0x00,0x00, "Nikon", "JAA768DA", "AF Zoom-Nikkor 75-240mm f/4.5-5.6D"},
//62                69
{0x63,0x48,0x2B,0x44,0x24,0x24,0x68,0x02,0x01,0x00,0x00, "Nikon", "JAA770DA", "AF-S Nikkor 17-35mm f/2.8D IF-ED"},
{0x64,0x00,0x62,0x62,0x24,0x24,0x6A,0x02,0x40,0x00,0x00, "Nikon", "JAA628DA", "PC Micro-Nikkor 85mm f/2.8D"},
{0x65,0x44,0x60,0x98,0x34,0x3C,0x6B,0x0A,0x00,0x00,0x00, "Nikon", "JAA771DA", "AF VR Zoom-Nikkor 80-400mm f/4.5-5.6D ED"},
{0x66,0x40,0x2D,0x44,0x2C,0x34,0x6C,0x02,0x00,0x00,0x00, "Nikon", "JAA772DA", "AF Zoom-Nikkor 18-35mm f/3.5-4.5D IF-ED"},
{0x67,0x48,0x37,0x62,0x24,0x30,0x6D,0x02,0x00,0x00,0x00, "Nikon", "JAA774DA", "AF Zoom-Nikkor 24-85mm f/2.8-4D IF"},
{0x68,0x42,0x3C,0x60,0x2A,0x3C,0x6E,0x06,0x00,0x00,0x00, "Nikon", "JAA777DA", "AF Zoom-Nikkor 28-80mm f/3.3-5.6G"},
{0x69,0x48,0x5C,0x8E,0x30,0x3C,0x6F,0x06,0x00,0x00,0x00, "Nikon", "JAA776DA", "AF Zoom-Nikkor 70-300mm f/4-5.6G"},
{0x6A,0x48,0x8E,0x8E,0x30,0x30,0x70,0x02,0x03,0x00,0x00, "Nikon", "JAA334DA", "AF-S Nikkor 300mm f/4D IF-ED"},
{0x6B,0x48,0x24,0x24,0x24,0x24,0x71,0x02,0x00,0x00,0x00, "Nikon", "JAA130DA", "AF Nikkor ED 14mm f/2.8D"},
//6C                72
{0x6D,0x48,0x8E,0x8E,0x24,0x24,0x73,0x02,0x03,0x00,0x00, "Nikon", "JAA335DA", "AF-S Nikkor 300mm f/2.8D IF-ED II"},
{0x6E,0x48,0x98,0x98,0x24,0x24,0x74,0x02,0x03,0x00,0x00, "Nikon", "JAA525DA", "AF-S Nikkor 400mm f/2.8D IF-ED II"},
{0x6F,0x3C,0xA0,0xA0,0x30,0x30,0x75,0x02,0x03,0x00,0x00, "Nikon", "JAA526DA", "AF-S Nikkor 500mm f/4D IF-ED II"},
{0x70,0x3C,0xA6,0xA6,0x30,0x30,0x76,0x02,0x03,0x00,0x00, "Nikon", "JAA527DA", "AF-S Nikkor 600mm f/4D IF-ED II"},
//71
{0x72,0x48,0x4C,0x4C,0x24,0x24,0x77,0x00,0x00,0x00,0x00, "Nikon", "JAA012AA", "Nikkor 45mm f/2.8 P"},
//73
{0x74,0x40,0x37,0x62,0x2C,0x34,0x78,0x06,0x01,0x00,0x00, "Nikon", "JAA780DA", "AF-S Zoom-Nikkor 24-85mm f/3.5-4.5G IF-ED"},
{0x75,0x40,0x3C,0x68,0x2C,0x3C,0x79,0x06,0x00,0x00,0x00, "Nikon", "JAA778DA", "AF Zoom-Nikkor 28-100mm f/3.5-5.6G"},
{0x76,0x58,0x50,0x50,0x14,0x14,0x7A,0x02,0x00,0x00,0x00, "Nikon", "JAA013DA", "AF Nikkor 50mm f/1.8D"},
{0x77,0x48,0x5C,0x80,0x24,0x24,0x7B,0x0E,0x03,0x00,0x00, "Nikon", "JAA781DA", "AF-S VR Zoom-Nikkor 70-200mm f/2.8G IF-ED"},
{0x78,0x40,0x37,0x6E,0x2C,0x3C,0x7C,0x0E,0x01,0x00,0x00, "Nikon", "JAA782DA", "AF-S VR Zoom-Nikkor 24-120mm f/3.5-5.6G IF-ED"},
{0x79,0x40,0x3C,0x80,0x2C,0x3C,0x7F,0x06,0x00,0x00,0x00, "Nikon", "JAA783DA", "AF Zoom-Nikkor 28-200mm f/3.5-5.6G IF-ED"},
{0x7A,0x3C,0x1F,0x37,0x30,0x30,0x7E,0x06,0x01,0x01,0x00, "Nikon", "JAA784DA", "AF-S DX Zoom-Nikkor 12-24mm f/4G IF-ED"},
{0x7B,0x48,0x80,0x98,0x30,0x30,0x80,0x0E,0x03,0x00,0x00, "Nikon", "JAA787DA", "AF-S VR Zoom-Nikkor 200-400mm f/4G IF-ED"},
//7C                81
{0x7D,0x48,0x2B,0x53,0x24,0x24,0x82,0x06,0x01,0x00,0x00, "Nikon", "JAA788DA", "AF-S DX Zoom-Nikkor 17-55mm f/2.8G IF-ED"},
//7E                83
{0x7F,0x40,0x2D,0x5C,0x2C,0x34,0x84,0x06,0x11,0x00,0x00, "Nikon", "JAA790DA", "AF-S DX Zoom-Nikkor 18-70mm f/3.5-4.5G IF-ED"},
{0x80,0x48,0x1A,0x1A,0x24,0x24,0x85,0x06,0x00,0x00,0x00, "Nikon", "JAA629DA", "AF DX Fisheye-Nikkor 10.5mm f/2.8G ED"},
{0x81,0x54,0x80,0x80,0x18,0x18,0x86,0x0E,0x03,0x00,0x00, "Nikon", "JAA336DA", "AF-S VR Nikkor 200mm f/2G IF-ED"},
{0x82,0x48,0x8E,0x8E,0x24,0x24,0x87,0x0E,0x13,0x00,0x00, "Nikon", "JAA337DA", "AF-S VR Nikkor 300mm f/2.8G IF-ED"},
{0x83,0x00,0xB0,0xB0,0x5A,0x5A,0x88,0x04,0x00,0x00,0x00, "Nikon", "", "FSA-L2, EDG 65, 800mm F13 G"},
//84
//85
//86
//87
//88
{0x89,0x3C,0x53,0x80,0x30,0x3C,0x8B,0x06,0x01,0x00,0x00, "Nikon", "JAA793DA", "AF-S DX Zoom-Nikkor 55-200mm f/4-5.6G ED"},
{0x8A,0x54,0x6A,0x6A,0x24,0x24,0x8C,0x0E,0x53,0x00,0x00, "Nikon", "JAA630DA", "AF-S VR Micro-Nikkor 105mm f/2.8G IF-ED"},
{0x8B,0x40,0x2D,0x80,0x2C,0x3C,0x8D,0x0E,0x01,0x00,0x00, "Nikon", "JAA794DA", "AF-S DX VR Zoom-Nikkor 18-200mm f/3.5-5.6G IF-ED"},
//{0x8B,0x40,0x2D,0x80,0x2C,0x3C,0xFD,0x0E,0x01,0x01,0x00, "Nikon", "JAA794DA", "AF-S DX VR Zoom-Nikkor 18-200mm f/3.5-5.6G IF-ED"}, // Fix bug #1026.
{0x8B,0x40,0x2D,0x80,0x2C,0x3C,0xFD,0x0E,0x01,0x02,0x00, "Nikon", "JAA813DA", "AF-S DX VR Zoom-Nikkor 18-200mm f/3.5-5.6G IF-ED II"},
{0x8C,0x40,0x2D,0x53,0x2C,0x3C,0x8E,0x06,0x01,0x00,0x00, "Nikon", "JAA792DA", "AF-S DX Zoom-Nikkor 18-55mm f/3.5-5.6G ED"},
{0x8D,0x44,0x5C,0x8E,0x34,0x3C,0x8F,0x0E,0x31,0x00,0x00, "Nikon", "JAA795DA", "AF-S VR Zoom-Nikkor 70-300mm f/4.5-5.6G IF-ED"},
//8E                90
{0x8F,0x40,0x2D,0x72,0x2C,0x3C,0x91,0x06,0x01,0x00,0x00, "Nikon", "JAA796DA", "AF-S DX Zoom-Nikkor 18-135mm f/3.5-5.6G IF-ED"},
{0x90,0x3B,0x53,0x80,0x30,0x3C,0x92,0x0E,0x01,0x00,0x00, "Nikon", "JAA798DA", "AF-S DX VR Zoom-Nikkor 55-200mm f/4-5.6G IF-ED"},
//91                93
{0x92,0x48,0x24,0x37,0x24,0x24,0x94,0x06,0x01,0x00,0x00, "Nikon", "JAA801DA", "AF-S Zoom-Nikkor 14-24mm f/2.8G ED"},
{0x93,0x48,0x37,0x5C,0x24,0x24,0x95,0x06,0x01,0x00,0x00, "Nikon", "JAA802DA", "AF-S Zoom-Nikkor 24-70mm f/2.8G ED"},
{0x94,0x40,0x2D,0x53,0x2C,0x3C,0x96,0x06,0x01,0x00,0x00, "Nikon", "JAA797DA", "AF-S DX Zoom-Nikkor 18-55mm f/3.5-5.6G ED II"},
{0x95,0x4C,0x37,0x37,0x2C,0x2C,0x97,0x02,0x00,0x00,0x00, "Nikon", "JAA631DA", "PC-E Nikkor 24mm f/3.5D ED"},
{0x95,0x00,0x37,0x37,0x2C,0x2C,0x97,0x06,0x00,0x00,0x00, "Nikon", "JAA631DA", "PC-E Nikkor 24mm f/3.5D ED"},
{0x96,0x48,0x98,0x98,0x24,0x24,0x98,0x0E,0x13,0x00,0x00, "Nikon", "JAA528DA", "AF-S VR Nikkor 400mm f/2.8G ED"},
{0x97,0x3C,0xA0,0xA0,0x30,0x30,0x99,0x0E,0x13,0x00,0x00, "Nikon", "JAA529DA", "AF-S VR Nikkor 500mm f/4G ED"},
{0x98,0x3C,0xA6,0xA6,0x30,0x30,0x9A,0x0E,0x13,0x00,0x00, "Nikon", "JAA530DA", "AF-S VR Nikkor 600mm f/4G ED"},
{0x99,0x40,0x29,0x62,0x2C,0x3C,0x9B,0x0E,0x01,0x00,0x00, "Nikon", "JAA800DA", "AF-S DX VR Zoom-Nikkor 16-85mm f/3.5-5.6G ED"},
{0x9A,0x40,0x2D,0x53,0x2C,0x3C,0x9C,0x0E,0x01,0x00,0x00, "Nikon", "JAA803DA", "AF-S DX VR Zoom-Nikkor 18-55mm f/3.5-5.6G"},
{0x9B,0x54,0x4C,0x4C,0x24,0x24,0x9D,0x02,0x00,0x00,0x00, "Nikon", "JAA633DA", "PC-E Micro Nikkor 45mm f/2.8D ED"},
{0x9B,0x00,0x4C,0x4C,0x24,0x24,0x9D,0x06,0x00,0x00,0x00, "Nikon", "JAA633DA", "PC-E Micro Nikkor 45mm f/2.8D ED"},
{0x9C,0x54,0x56,0x56,0x24,0x24,0x9E,0x06,0x41,0x00,0x00, "Nikon", "JAA632DA", "AF-S Micro Nikkor 60mm f/2.8G ED"},
{0x9D,0x54,0x62,0x62,0x24,0x24,0x9F,0x02,0x40,0x00,0x00, "Nikon", "JAA634DA", "PC-E Micro Nikkor 85mm f/2.8D"},
{0x9D,0x00,0x62,0x62,0x24,0x24,0x9F,0x06,0x40,0x00,0x00, "Nikon", "JAA634DA", "PC-E Micro Nikkor 85mm f/2.8D"},
{0x9E,0x40,0x2D,0x6A,0x2C,0x3C,0xA0,0x0E,0x01,0x00,0x00, "Nikon", "JAA805DA", "AF-S DX VR Zoom-Nikkor 18-105mm f/3.5-5.6G ED"},
{0x9F,0x58,0x44,0x44,0x14,0x14,0xA1,0x06,0x01,0x00,0x00, "Nikon", "JAA132DA", "AF-S DX Nikkor 35mm f/1.8G"},
{0xA0,0x54,0x50,0x50,0x0C,0x0C,0xA2,0x06,0x01,0x00,0x00, "Nikon", "JAA014DA", "AF-S Nikkor 50mm f/1.4G"},
{0xA1,0x40,0x18,0x37,0x2C,0x34,0xA3,0x06,0x01,0x00,0x00, "Nikon", "JAA804DA", "AF-S DX Nikkor 10-24mm f/3.5-4.5G ED"},
{0xA2,0x48,0x5C,0x80,0x24,0x24,0xA4,0x0E,0x13,0x00,0x00, "Nikon", "JAA807DA", "AF-S Nikkor 70-200mm f/2.8G ED VR II"},
{0xA3,0x3C,0x29,0x44,0x30,0x30,0xA5,0x0E,0x01,0x00,0x00, "Nikon", "JAA806DA", "AF-S Nikkor 16-35mm f/4G ED VR"},
{0xA4,0x54,0x37,0x37,0x0C,0x0C,0xA6,0x06,0x01,0x00,0x00, "Nikon", "JAA131DA", "AF-S Nikkor 24mm f/1.4G ED"},
{0xA5,0x40,0x3C,0x8E,0x2C,0x3C,0xA7,0x0E,0x01,0x00,0x00, "Nikon", "JAA808DA", "AF-S Nikkor 28-300mm f/3.5-5.6G ED VR"},
{0xA6,0x48,0x8E,0x8E,0x24,0x24,0xA8,0x0E,0x13,0x00,0x00, "Nikon", "JAA339DA", "AF-S Nikkor 300mm f/2.8G IF-ED VR II"},
{0xA7,0x4B,0x62,0x62,0x2C,0x2C,0xA9,0x0E,0x41,0x00,0x00, "Nikon", "JAA637DA", "AF-S DX Micro Nikkor 85mm f/3.5G ED VR"},
{0xA8,0x48,0x80,0x98,0x30,0x30,0xAA,0x0E,0x03,0x00,0x00, "Nikon", "JAA809DA", "AF-S Zoom-Nikkor 200-400mm f/4G IF-ED VR II"},
{0xA9,0x54,0x80,0x80,0x18,0x18,0xAB,0x0E,0x13,0x00,0x00, "Nikon", "JAA340DA", "AF-S Nikkor 200mm f/2G ED VR II"},
{0xAA,0x3C,0x37,0x6E,0x30,0x30,0xAC,0x0E,0x01,0x00,0x00, "Nikon", "JAA811DA", "AF-S Nikkor 24-120mm f/4G ED VR"},
//AB                AD                                          -- no lens --
{0xAC,0x38,0x53,0x8E,0x34,0x3C,0xAE,0x0E,0x01,0x00,0x00, "Nikon", "JAA814DA", "AF-S DX Nikkor 55-300mm f/4.5-5.6G ED VR"},
{0xAD,0x3C,0x2D,0x8E,0x2C,0x3C,0xAF,0x0E,0x01,0x00,0x00, "Nikon", "JAA812DA", "AF-S DX Nikkor 18-300mm f/3.5-5.6G ED VR"},
{0xAE,0x54,0x62,0x62,0x0C,0x0C,0xB0,0x06,0x01,0x00,0x00, "Nikon", "JAA338DA", "AF-S Nikkor 85mm f/1.4G"},
{0xAF,0x54,0x44,0x44,0x0C,0x0C,0xB1,0x06,0x01,0x00,0x00, "Nikon", "JAA134DA", "AF-S Nikkor 35mm f/1.4G"},
{0xB0,0x4C,0x50,0x50,0x14,0x14,0xB2,0x06,0x01,0x00,0x00, "Nikon", "JAA015DA", "AF-S Nikkor 50mm f/1.8G"},
{0xB1,0x48,0x48,0x48,0x24,0x24,0xB3,0x06,0x01,0x00,0x00, "Nikon", "JAA638DA", "AF-S DX Micro Nikkor 40mm f/2.8G"},
{0xB2,0x48,0x5C,0x80,0x30,0x30,0xB4,0x0E,0x01,0x00,0x00, "Nikon", "JAA815DA", "AF-S Nikkor 70-200mm f/4G ED VR"},
{0xB3,0x4C,0x62,0x62,0x14,0x14,0xB5,0x06,0x01,0x00,0x00, "Nikon", "JAA341DA", "AF-S Nikkor 85mm f/1.8G"},
{0xB4,0x40,0x37,0x62,0x2C,0x34,0xB6,0x0E,0x01,0x00,0x00, "Nikon", "JAA816DA", "AF-S Nikkor 24-85mm f/3.5-4.5G ED VR"},
{0xB5,0x4C,0x3C,0x3C,0x14,0x14,0xB7,0x06,0x01,0x00,0x00, "Nikon", "JAA135DA", "AF-S Nikkor 28mm f/1.8G"},
{0xB6,0x3C,0xB0,0xB0,0x3C,0x3C,0xB8,0x0E,0x01,0x00,0x00, "Nikon", "JAA531DA", "AF-S VR Nikkor 800mm f/5.6E FL ED"},
{0xB7,0x44,0x60,0x98,0x34,0x3C,0xB9,0x0E,0x01,0x00,0x00, "Nikon", "JAA817DA", "AF-S Nikkor 80-400mm f/4.5-5.6G ED VR"},
{0xB8,0x40,0x2D,0x44,0x2C,0x34,0xBA,0x06,0x01,0x00,0x00, "Nikon", "JAA818DA", "AF-S Nikkor 18-35mm f/3.5-4.5G ED"},
{0xA0,0x40,0x2D,0x74,0x2C,0x3C,0xBB,0x0E,0x01,0x00,0x01, "Nikon", "JAA819DA", "AF-S DX Nikkor 18-140mm f/3.5-5.6G ED VR"},
{0xA1,0x54,0x55,0x55,0x0C,0x0C,0xBC,0x06,0x01,0x00,0x01, "Nikon", "JAA136DA", "AF-S Nikkor 58mm f/1.4G"},
{0xA2,0x40,0x2D,0x53,0x2C,0x3C,0xBD,0x0E,0x01,0x00,0x01, "Nikon", "JAA820DA", "AF-S DX Nikkor 18-55mm f/3.5-5.6G VR II"},
{0xA4,0x40,0x2D,0x8E,0x2C,0x40,0xBF,0x0E,0x01,0x00,0x01, "Nikon", "JAA821DA", "AF-S DX Nikkor 18-300mm f/3.5-6.3G ED VR"},
{0xA5,0x4C,0x44,0x44,0x14,0x14,0xC0,0x06,0x01,0x00,0x01, "Nikon", "JAA137DA", "AF-S Nikkor 35mm f/1.8G ED"},
{0xA6,0x48,0x98,0x98,0x24,0x24,0xC1,0x0E,0x01,0x00,0x01, "Nikon", "JAA532DA", "AF-S Nikkor 400mm f/2.8E FL ED VR"},
{0xA7,0x3C,0x53,0x80,0x30,0x3C,0xC2,0x0E,0x01,0x00,0x01, "Nikon", "JAA823DA", "AF-S DX Nikkor 55-200mm f/4-5.6G ED VR II"},
{0xA8,0x48,0x8E,0x8E,0x30,0x30,0xC3,0x4E,0x01,0x00,0x01, "Nikon", "JAA342DA", "AF-S Nikkor 300mm f/4E PF ED VR"},
{0xA8,0x48,0x8E,0x8E,0x30,0x30,0xC3,0x0E,0x01,0x00,0x01, "Nikon", "JAA342DA", "AF-S Nikkor 300mm f/4E PF ED VR"},
{0xA9,0x4C,0x31,0x31,0x14,0x14,0xC4,0x06,0x01,0x00,0x01, "Nikon", "JAA138DA", "AF-S Nikkor 20mm f/1.8G ED"},
{0xAA,0x48,0x37,0x5C,0x24,0x24,0xC5,0x4E,0x01,0x00,0x02, "Nikon", "JAA824DA", "AF-S Nikkor 24-70mm f/2.8E ED VR"},
{0xAA,0x48,0x37,0x5C,0x24,0x24,0xC5,0x0E,0x01,0x00,0x02, "Nikon", "JAA824DA", "AF-S Nikkor 24-70mm f/2.8E ED VR"},
{0xAB,0x3C,0xA0,0xA0,0x30,0x30,0xC6,0x4E,0x01,0x00,0x02, "Nikon", "JAA533DA", "AF-S Nikkor 500mm f/4E FL ED VR"},
{0xAC,0x3C,0xA6,0xA6,0x30,0x30,0xC7,0x4E,0x01,0x00,0x02, "Nikon", "JAA534DA", "AF-S Nikkor 600mm f/4E FL ED VR"},
{0xAD,0x48,0x28,0x60,0x24,0x30,0xC8,0x4E,0x01,0x00,0x02, "Nikon", "JAA825DA", "AF-S DX Nikkor 16-80mm f/2.8-4E ED VR"},
{0xAD,0x48,0x28,0x60,0x24,0x30,0xC8,0x0E,0x01,0x00,0x02, "Nikon", "JAA825DA", "AF-S DX Nikkor 16-80mm f/2.8-4E ED VR"},
{0xAE,0x3C,0x80,0xA0,0x3C,0x3C,0xC9,0x4E,0x01,0x00,0x02, "Nikon", "JAA822DA", "AF-S Nikkor 200-500mm f/5.6E ED VR"},
{0xAE,0x3C,0x80,0xA0,0x3C,0x3C,0xC9,0x0E,0x01,0x00,0x02, "Nikon", "JAA822DA", "AF-S Nikkor 200-500mm f/5.6E ED VR"},
{0xA0,0x40,0x2D,0x53,0x2C,0x3C,0xCA,0x8E,0x01,0x00,0x03, "Nikon", "JAA826DA", "AF-P DX Nikkor 18-55mm f/3.5-5.6G VR"},
{0xA0,0x40,0x2D,0x53,0x2C,0x3C,0xCA,0x0E,0x01,0x00,0x03, "Nikon", "JAA827DA", "AF-P DX Nikkor 18-55mm f/3.5-5.6G"},
//                  CB
{0xAF,0x4C,0x37,0x37,0x14,0x14,0xCC,0x06,0x01,0x00,0x03, "Nikon", "JAA139DA", "AF-S Nikkor 24mm f/1.8G ED"},
{0xA3,0x38,0x5C,0x8E,0x34,0x40,0xCE,0x8E,0x01,0x00,0x03, "Nikon", "JAA829DA", "AF-P DX Nikkor 70-300mm f/4.5-6.3G ED VR"},
{0xA3,0x38,0x5C,0x8E,0x34,0x40,0xCE,0x0E,0x01,0x00,0x03, "Nikon", "JAA828DA", "AF-P DX Nikkor 70-300mm f/4.5-6.3G ED"},
//                  CE
//                  CF
{0xA4,0x48,0x5C,0x80,0x24,0x24,0xCF,0x4E,0x01,0x00,0x03, "Nikon", "JAA830DA", "AF-S Nikkor 70-200mm f/2.8E FL ED VR"},
{0xA4,0x48,0x5C,0x80,0x24,0x24,0xCF,0x0E,0x01,0x00,0x03, "Nikon", "JAA830DA", "AF-S Nikkor 70-200mm f/2.8E FL ED VR"},
{0xA5,0x54,0x6A,0x6A,0x0C,0x0C,0xD0,0x46,0x01,0x00,0x03, "Nikon", "JAA343DA", "AF-S Nikkor 105mm f/1.4E ED"},
{0xA5,0x54,0x6A,0x6A,0x0C,0x0C,0xD0,0x06,0x01,0x00,0x03, "Nikon", "JAA343DA", "AF-S Nikkor 105mm f/1.4E ED"},
//
//
//  "Nikon" "JAA831DA" "AF-S DX Nikkor 18-200mm f/3.5-5.6G ED VR II"
//
{0x01,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00, "Nikon", "JAA90701", "TC-16A"},
{0x01,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00, "Nikon", "JAA90701", "TC-16A"},
//
//------------------------------------------------------------------------------
// Sigma lenses by focal length, first fixed then zoom lenses
//------------------------------------------------------------------------------
//
{0xFE,0x47,0x00,0x00,0x24,0x24,0x4B,0x06,0x01,0x00,0x00, "Sigma", "486556", "4.5mm F2.8 EX DC HSM Circular Fisheye"},
{0x26,0x48,0x11,0x11,0x30,0x30,0x1C,0x02,0x00,0x00,0x00, "Sigma", "483", "8mm F4 EX Circular Fisheye"},
{0x79,0x40,0x11,0x11,0x2C,0x2C,0x1C,0x06,0x00,0x00,0x00, "Sigma", "485597", "8mm F3.5 EX Circular Fisheye"},
{0xDC,0x48,0x19,0x19,0x24,0x24,0x4B,0x06,0x01,0x00,0x00, "Sigma", "477554", "10mm F2.8 EX DC HSM Fisheye"},
{0x02,0x3F,0x24,0x24,0x2C,0x2C,0x02,0x00,0x00,0x00,0x00, "Sigma", "468", "14mm F3.5"},
{0x48,0x48,0x24,0x24,0x24,0x24,0x4B,0x02,0x01,0x00,0x00, "Sigma", "", "14mm F2.8 EX Aspherical HSM"},
{0x26,0x48,0x27,0x27,0x24,0x24,0x1C,0x02,0x00,0x00,0x00, "Sigma", "476441", "15mm F2.8 EX Diagonal Fisheye"},
{0xEA,0x48,0x27,0x27,0x24,0x24,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "15mm F2.8 EX Diagonal Fisheye"},
//M                                         "Sigma" "410"    "18mm F3.5";
{0x26,0x58,0x31,0x31,0x14,0x14,0x1C,0x02,0x00,0x00,0x00, "Sigma", "411442", "20mm F1.8 EX DG Aspherical RF"},
{0x79,0x54,0x31,0x31,0x0C,0x0C,0x4B,0x06,0x00,0x00,0x00, "Sigma", "", "20mm F1.4 DG HSM | A"},
{0x26,0x58,0x37,0x37,0x14,0x14,0x1C,0x02,0x00,0x00,0x00, "Sigma", "432447", "24mm F1.8 EX DG Aspherical Macro"},
{0xE1,0x58,0x37,0x37,0x14,0x14,0x1C,0x02,0x00,0x00,0x00, "Sigma", "432447", "24mm F1.8 EX DG Aspherical Macro"},
{0x02,0x46,0x37,0x37,0x25,0x25,0x02,0x00,0x00,0x00,0x00, "Sigma", "438", "24mm F2.8 Super Wide II Macro"},
{0x26,0x58,0x3C,0x3C,0x14,0x14,0x1C,0x02,0x00,0x00,0x00, "Sigma", "440442", "28mm F1.8 EX DG Aspherical Macro"},
{0x48,0x54,0x3E,0x3E,0x0C,0x0C,0x4B,0x06,0x01,0x00,0x00, "Sigma", "477554", "30mm F1.4 EX DC HSM"},
{0xF8,0x54,0x3E,0x3E,0x0C,0x0C,0x4B,0x06,0x01,0x00,0x00, "Sigma", "477554", "30mm F1.4 EX DC HSM"},
{0x91,0x54,0x44,0x44,0x0C,0x0C,0x4B,0x06,0x01,0x00,0x00, "Sigma", "", "35mm F1.4 DG HSM"},
{0xDE,0x54,0x50,0x50,0x0C,0x0C,0x4B,0x06,0x01,0x00,0x00, "Sigma", "310554", "50mm F1.4 EX DG HSM"},
{0x88,0x54,0x50,0x50,0x0C,0x0C,0x4B,0x06,0x00,0x00,0x00, "Sigma", "", "50mm F1.4 DG HSM | A"},
{0x02,0x48,0x50,0x50,0x24,0x24,0x02,0x00,0x00,0x00,0x00, "Sigma", "", "Macro 50mm F2.8"},
{0x32,0x54,0x50,0x50,0x24,0x24,0x35,0x02,0x00,0x00,0x00, "Sigma", "346447", "Macro 50mm F2.8 EX DG"},
{0xE3,0x54,0x50,0x50,0x24,0x24,0x35,0x02,0x00,0x00,0x00, "Sigma", "", "Macro 50mm F2.8 EX DG"},
{0x79,0x48,0x5C,0x5C,0x24,0x24,0x1C,0x06,0x00,0x00,0x00, "Sigma", "270599", "Macro 70mm F2.8 EX DG"},
{0x9B,0x54,0x62,0x62,0x0C,0x0C,0x4B,0x06,0x00,0x00,0x00, "Sigma", "", "85mm F1.4 EX DG HSM"},
{0x02,0x48,0x65,0x65,0x24,0x24,0x02,0x00,0x00,0x00,0x00, "Sigma", "", "Macro 90mm F2.8"},
{0x32,0x54,0x6A,0x6A,0x24,0x24,0x35,0x02,0x00,0x02,0x00, "Sigma", "256", "Macro 105mm F2.8 EX DG"},
{0xE5,0x54,0x6A,0x6A,0x24,0x24,0x35,0x02,0x40,0x00,0x00, "Sigma", "257446", "Macro 105mm F2.8 EX DG"},
{0x97,0x48,0x6A,0x6A,0x24,0x24,0x4B,0x0E,0x00,0x00,0x00, "Sigma", "", "Macro 105mm F2.8 EX DG OS HSM"},
{0x48,0x48,0x76,0x76,0x24,0x24,0x4B,0x06,0x43,0x00,0x00, "Sigma", "104559", "APO Macro 150mm F2.8 EX DG HSM"},
{0xF5,0x48,0x76,0x76,0x24,0x24,0x4B,0x06,0x43,0x00,0x00, "Sigma", "104559", "APO Macro 150mm F2.8 EX DG HSM"},
{0x99,0x48,0x76,0x76,0x24,0x24,0x4B,0x0E,0x43,0x00,0x00, "Sigma", "", "APO Macro 150mm F2.8 EX DG OS HSM"},
{0x48,0x4C,0x7C,0x7C,0x2C,0x2C,0x4B,0x02,0x43,0x00,0x00, "Sigma", "", "APO Macro 180mm F3.5 EX DG HSM"},
{0x48,0x4C,0x7D,0x7D,0x2C,0x2C,0x4B,0x02,0x43,0x00,0x00, "Sigma", "105556", "APO Macro 180mm F3.5 EX DG HSM"},
//M                                         "Sigma" ""       "APO 300mm F2.8";
{0x48,0x54,0x8E,0x8E,0x24,0x24,0x4B,0x02,0x03,0x00,0x00, "Sigma", "", "APO 300mm F2.8 EX DG HSM"},
{0xFB,0x54,0x8E,0x8E,0x24,0x24,0x4B,0x02,0x13,0x00,0x00, "Sigma", "195557", "APO 300mm F2.8 EX DG HSM"},
{0x26,0x48,0x8E,0x8E,0x30,0x30,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "APO Tele Macro 300mm F4"},
{0x02,0x2F,0x98,0x98,0x3D,0x3D,0x02,0x00,0x00,0x00,0x00, "Sigma", "", "APO 400mm F5.6"},
{0x26,0x3C,0x98,0x98,0x3C,0x3C,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "APO Tele Macro 400mm F5.6"},
{0x02,0x37,0xA0,0xA0,0x34,0x34,0x02,0x00,0x00,0x00,0x00, "Sigma", "", "APO 500mm F4.5"},
{0x48,0x44,0xA0,0xA0,0x34,0x34,0x4B,0x02,0x03,0x00,0x00, "Sigma", "", "APO 500mm F4.5 EX HSM"},
{0xF1,0x44,0xA0,0xA0,0x34,0x34,0x4B,0x02,0x03,0x00,0x00, "Sigma", "184551", "APO 500mm F4.5 EX DG HSM"},
{0x02,0x34,0xA0,0xA0,0x44,0x44,0x02,0x00,0x00,0x00,0x00, "Sigma", "", "APO 500mm F7.2"},
{0x02,0x3C,0xB0,0xB0,0x3C,0x3C,0x02,0x00,0x00,0x00,0x00, "Sigma", "", "APO 800mm F5.6"},
{0x48,0x3C,0xB0,0xB0,0x3C,0x3C,0x4B,0x02,0x03,0x00,0x00, "Sigma", "", "APO 800mm F5.6 EX HSM"},
//M                                         "Sigma" "152550" "APO 800mm F5.6 EX DG HSM";
//M2    B8 B8 49 49 02" "00" "00" "00" "00" "Sigma" ""       "APO 1000mm F8.0";
//
{0x9E,0x38,0x11,0x29,0x34,0x3C,0x4B,0x06,0x01,0x00,0x00, "Sigma", "", "8-16mm F4.5-5.6 DC HSM"},
{0xA1,0x41,0x19,0x31,0x2C,0x2C,0x4B,0x06,0x01,0x00,0x00, "Sigma", "", "10-20mm F3.5 EX DC HSM"},
{0x48,0x3C,0x19,0x31,0x30,0x3C,0x4B,0x06,0x01,0x00,0x00, "Sigma", "201555", "10-20mm F4-5.6 EX DC HSM"},
{0xF9,0x3C,0x19,0x31,0x30,0x3C,0x4B,0x06,0x01,0x00,0x00, "Sigma", "201555", "10-20mm F4-5.6 EX DC HSM"},
{0x48,0x38,0x1F,0x37,0x34,0x3C,0x4B,0x06,0x00,0x00,0x00, "Sigma", "200558", "12-24mm F4.5-5.6 EX DG Aspherical HSM"},
{0xF0,0x38,0x1F,0x37,0x34,0x3C,0x4B,0x06,0x00,0x00,0x00, "Sigma", "200558", "12-24mm F4.5-5.6 EX DG Aspherical HSM"},
{0x96,0x38,0x1F,0x37,0x34,0x3C,0x4B,0x06,0x00,0x00,0x00, "Sigma", "", "12-24mm F4.5-5.6 II DG HSM"},
{0x26,0x40,0x27,0x3F,0x2C,0x34,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "15-30mm F3.5-4.5 EX DG Aspherical DF"},
{0x48,0x48,0x2B,0x44,0x24,0x30,0x4B,0x06,0x00,0x00,0x00, "Sigma", "", "17-35mm F2.8-4 EX DG  Aspherical HSM"},
{0x26,0x54,0x2B,0x44,0x24,0x30,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "17-35mm F2.8-4 EX Aspherical"},
{0x9D,0x48,0x2B,0x50,0x24,0x24,0x4B,0x0E,0x00,0x00,0x00, "Sigma", "", "17-50mm F2.8 EX DC OS HSM"},
{0x8F,0x48,0x2B,0x50,0x24,0x24,0x4B,0x0E,0x00,0x00,0x00, "Sigma", "", "17-50mm F2.8 EX DC OS HSM"},
{0x7A,0x47,0x2B,0x5C,0x24,0x34,0x4B,0x06,0x00,0x00,0x00, "Sigma", "689599", "17-70mm F2.8-4.5 DC Macro Asp. IF HSM"},
{0x7A,0x48,0x2B,0x5C,0x24,0x34,0x4B,0x06,0x00,0x00,0x00, "Sigma", "689599", "17-70mm F2.8-4.5 DC Macro Asp. IF HSM"},
{0x7F,0x48,0x2B,0x5C,0x24,0x34,0x1C,0x06,0x00,0x00,0x00, "Sigma", "", "17-70mm F2.8-4.5 DC Macro Asp. IF"},
{0x8E,0x3C,0x2B,0x5C,0x24,0x30,0x4B,0x0E,0x00,0x00,0x00, "Sigma", "", "17-70mm F2.8-4 DC MACRO OS HSM | C"},
{0xA0,0x48,0x2A,0x5C,0x24,0x30,0x4B,0x0E,0x00,0x00,0xFE, "Sigma", "", "17-70mm F2.8-4 DC Macro OS HSM"},
{0x8B,0x4C,0x2D,0x44,0x14,0x14,0x4B,0x06,0x00,0x00,0x00, "Sigma", "", "18-35mm F1.8 DC HSM"},
{0x26,0x40,0x2D,0x44,0x2B,0x34,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "18-35mm F3.5-4.5 Aspherical"},
{0x26,0x48,0x2D,0x50,0x24,0x24,0x1C,0x06,0x00,0x00,0x00, "Sigma", "", "18-50mm F2.8 EX DC"},
{0x7F,0x48,0x2D,0x50,0x24,0x24,0x1C,0x06,0x00,0x00,0x00, "Sigma", "", "18-50mm F2.8 EX DC Macro"},
{0x7A,0x48,0x2D,0x50,0x24,0x24,0x4B,0x06,0x01,0x00,0x00, "Sigma", "582593", "18-50mm F2.8 EX DC Macro"},
{0xF6,0x48,0x2D,0x50,0x24,0x24,0x4B,0x06,0x01,0x00,0x00, "Sigma", "582593", "18-50mm F2.8 EX DC Macro"},
{0xA4,0x47,0x2D,0x50,0x24,0x34,0x4B,0x0E,0x01,0x00,0x00, "Sigma", "", "18-50mm F2.8-4.5 DC OS HSM"},
{0x26,0x40,0x2D,0x50,0x2C,0x3C,0x1C,0x06,0x00,0x00,0x00, "Sigma", "", "18-50mm F3.5-5.6 DC"},
{0x7A,0x40,0x2D,0x50,0x2C,0x3C,0x4B,0x06,0x01,0x00,0x00, "Sigma", "551551", "18-50mm F3.5-5.6 DC HSM"},
{0x26,0x40,0x2D,0x70,0x2B,0x3C,0x1C,0x06,0x00,0x00,0x00, "Sigma", "", "18-125mm F3.5-5.6 DC"},
{0xCD,0x3D,0x2D,0x70,0x2E,0x3C,0x4B,0x0E,0x01,0x00,0x00, "Sigma", "853556", "18-125mm F3.8-5.6 DC OS HSM"},
{0x26,0x40,0x2D,0x80,0x2C,0x40,0x1C,0x06,0x00,0x00,0x00, "Sigma", "777555", "18-200mm F3.5-6.3 DC"},
{0xFF,0x40,0x2D,0x80,0x2C,0x40,0x4B,0x06,0x00,0x00,0x00, "Sigma", "", "18-200mm F3.5-6.3 DC"},
{0x7A,0x40,0x2D,0x80,0x2C,0x40,0x4B,0x0E,0x01,0x00,0x00, "Sigma", "888558", "18-200mm F3.5-6.3 DC OS HSM"},
{0xED,0x40,0x2D,0x80,0x2C,0x40,0x4B,0x0E,0x01,0x00,0x00, "Sigma", "888558", "18-200mm F3.5-6.3 DC OS HSM"},
{0x90,0x40,0x2D,0x80,0x2C,0x40,0x4B,0x0E,0x01,0x00,0x00, "Sigma", "", "18-200mm F3.5-6.3 II DC OS HSM"},
{0xA5,0x40,0x2D,0x88,0x2C,0x40,0x4B,0x0E,0x01,0x00,0x00, "Sigma", "", "18-250mm F3.5-6.3 DC OS HSM"},
{0x92,0x39,0x2D,0x88,0x2C,0x40,0x4B,0x0E,0x01,0x00,0x00, "Sigma", "", "18-250mm F3.5-6.3 DC OS Macro HSM"},
{0x26,0x48,0x31,0x49,0x24,0x24,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "20-40mm F2.8"},
{0x02,0x3A,0x37,0x50,0x31,0x3D,0x02,0x00,0x00,0x00,0x00, "Sigma", "", "24-50mm F4-5.6 UC"},
{0x26,0x48,0x37,0x56,0x24,0x24,0x1C,0x02,0x00,0x00,0x00, "Sigma", "547448", "24-60mm F2.8 EX DG"},
{0xB6,0x48,0x37,0x56,0x24,0x24,0x1C,0x02,0x00,0x00,0x00, "Sigma", "547448", "24-60mm F2.8 EX DG"},
{0xA6,0x48,0x37,0x5C,0x24,0x24,0x4B,0x06,0x01,0x00,0x00, "Sigma", "571559", "24-70mm F2.8 IF EX DG HSM"},
{0x26,0x54,0x37,0x5C,0x24,0x24,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "24-70mm F2.8 EX DG Macro"},
{0x67,0x54,0x37,0x5C,0x24,0x24,0x1C,0x02,0x00,0x00,0x00, "Sigma", "548445", "24-70mm F2.8 EX DG Macro"},
{0xE9,0x54,0x37,0x5C,0x24,0x24,0x1C,0x02,0x00,0x00,0x00, "Sigma", "548445", "24-70mm F2.8 EX DG Macro"},
{0x26,0x40,0x37,0x5C,0x2C,0x3C,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "24-70mm F3.5-5.6 Aspherical HF"},
{0x8A,0x3C,0x37,0x6A,0x30,0x30,0x4B,0x0E,0x00,0x00,0x00, "Sigma", "", "24-105mm F4 DG OS HSM"},
{0x26,0x54,0x37,0x73,0x24,0x34,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "24-135mm F2.8-4.5"},
{0x02,0x46,0x3C,0x5C,0x25,0x25,0x02,0x00,0x00,0x00,0x00, "Sigma", "", "28-70mm F2.8"},
{0x26,0x54,0x3C,0x5C,0x24,0x24,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "28-70mm F2.8 EX"},
{0x26,0x48,0x3C,0x5C,0x24,0x24,0x1C,0x06,0x00,0x00,0x00, "Sigma", "549442", "28-70mm F2.8 EX DG"},
{0x79,0x48,0x3C,0x5C,0x24,0x24,0x1C,0x06,0x00,0x00,0x00, "Sigma", "", "28-70mm F2.8 EX DG"},
{0x26,0x48,0x3C,0x5C,0x24,0x30,0x1C,0x02,0x00,0x00,0x00, "Sigma", "634445", "28-70mm F2.8-4 DG"},
{0x02,0x3F,0x3C,0x5C,0x2D,0x35,0x02,0x00,0x00,0x00,0x00, "Sigma", "", "28-70mm F3.5-4.5 UC"},
{0x26,0x40,0x3C,0x60,0x2C,0x3C,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "28-80mm F3.5-5.6 Mini Zoom Macro II Aspherical"},
{0x26,0x40,0x3C,0x65,0x2C,0x3C,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "28-90mm F3.5-5.6 Macro"},
{0x26,0x48,0x3C,0x6A,0x24,0x30,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "28-105mm F2.8-4 Aspherical"},
{0x26,0x3E,0x3C,0x6A,0x2E,0x3C,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "28-105mm F3.8-5.6 UC-III Aspherical IF"},
{0x26,0x40,0x3C,0x80,0x2C,0x3C,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "28-200mm F3.5-5.6 Compact Aspherical Hyperzoom Macro"},
{0x26,0x40,0x3C,0x80,0x2B,0x3C,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "28-200mm F3.5-5.6 Compact Aspherical Hyperzoom Macro"},
{0x26,0x3D,0x3C,0x80,0x2F,0x3D,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "28-300mm F3.8-5.6 Aspherical"},
{0x26,0x41,0x3C,0x8E,0x2C,0x40,0x1C,0x02,0x00,0x00,0x00, "Sigma", "795443", "28-300mm F3.5-6.3 DG Macro"},
{0xE6,0x41,0x3C,0x8E,0x2C,0x40,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "28-300mm F3.5-6.3 DG Macro"},
{0x26,0x40,0x3C,0x8E,0x2C,0x40,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "28-300mm F3.5-6.3 Macro"},
{0x02,0x3B,0x44,0x61,0x30,0x3D,0x02,0x00,0x00,0x00,0x00, "Sigma", "", "35-80mm F4-5.6"},
{0x02,0x40,0x44,0x73,0x2B,0x36,0x02,0x00,0x00,0x00,0x00, "Sigma", "", "35-135mm F3.5-4.5 a"},
{0xCC,0x4C,0x50,0x68,0x14,0x14,0x4B,0x06,0x00,0x00,0x00, "Sigma", "", "50-100mm F1.8 DC HSM | A"},
{0x7A,0x47,0x50,0x76,0x24,0x24,0x4B,0x06,0x03,0x00,0x00, "Sigma", "", "50-150mm F2.8 EX APO DC HSM"},
{0xFD,0x47,0x50,0x76,0x24,0x24,0x4B,0x06,0x03,0x00,0x00, "Sigma", "691554", "50-150mm F2.8 EX APO DC HSM II"},
{0x98,0x48,0x50,0x76,0x24,0x24,0x4B,0x0E,0x00,0x00,0x00, "Sigma", "", "50-150 f/2.8 EX DC APO OS HSM"},
{0x48,0x3C,0x50,0xA0,0x30,0x40,0x4B,0x02,0x03,0x00,0x00, "Sigma", "736552", "APO 50-500mm F4-6.3 EX HSM"},
{0x9F,0x37,0x50,0xA0,0x34,0x40,0x4B,0x0E,0x03,0x00,0x00, "Sigma", "", "50-500mm F4.5-6.3 APO DG OS HSM"},
//M                                         "Sigma" "686550" "50-200mm F4-5.6 DC OS HSM";
{0x26,0x3C,0x54,0x80,0x30,0x3C,0x1C,0x06,0x00,0x00,0x00, "Sigma", "", "55-200mm F4-5.6 DC"},
{0x7A,0x3B,0x53,0x80,0x30,0x3C,0x4B,0x06,0x01,0x00,0x00, "Sigma", "", "55-200mm F4-5.6 DC HSM"},
{0x48,0x54,0x5C,0x80,0x24,0x24,0x4B,0x02,0x00,0x00,0x00, "Sigma", "", "70-200mm F2.8 EX APO IF HSM"},
{0x7A,0x48,0x5C,0x80,0x24,0x24,0x4B,0x06,0x03,0x00,0x00, "Sigma", "", "70-200mm F2.8 EX APO DG Macro HSM II"},
{0xEE,0x48,0x5C,0x80,0x24,0x24,0x4B,0x06,0x03,0x00,0x00, "Sigma", "579555", "70-200mm F2.8 EX APO DG Macro HSM II"},
{0x9C,0x48,0x5C,0x80,0x24,0x24,0x4B,0x0E,0x03,0x00,0x00, "Sigma", "", "70-200mm F2.8 EX DG OS HSM"},
{0x02,0x46,0x5C,0x82,0x25,0x25,0x02,0x00,0x00,0x00,0x00, "Sigma", "", "70-210mm F2.8 APO"},
{0x02,0x40,0x5C,0x82,0x2C,0x35,0x02,0x00,0x00,0x00,0x00, "Sigma", "", "APO 70-210mm F3.5-4.5"},
{0x26,0x3C,0x5C,0x82,0x30,0x3C,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "70-210mm F4-5.6 UC-II"},
{0x26,0x3C,0x5C,0x8E,0x30,0x3C,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "70-300mm F4-5.6 DG Macro"},
{0x56,0x3C,0x5C,0x8E,0x30,0x3C,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "70-300mm F4-5.6 APO Macro Super II"},
{0xE0,0x3C,0x5C,0x8E,0x30,0x3C,0x4B,0x06,0x00,0x00,0x00, "Sigma", "508555", "APO 70-300mm F4-5.6 DG Macro"},
{0xA3,0x3C,0x5C,0x8E,0x30,0x3C,0x4B,0x0E,0x00,0x00,0x00, "Sigma", "572556", "70-300mm F4-5.6 DG OS"},
{0x02,0x37,0x5E,0x8E,0x35,0x3D,0x02,0x00,0x00,0x00,0x00, "Sigma", "", "75-300mm F4.5-5.6 APO"},
{0x02,0x3A,0x5E,0x8E,0x32,0x3D,0x02,0x00,0x00,0x00,0x00, "Sigma", "", "75-300mm F4.0-5.6"},
{0x77,0x44,0x61,0x98,0x34,0x3C,0x7B,0x0E,0x03,0x00,0x00, "Sigma", "", "80-400mm f4.5-5.6 EX OS"},
{0x77,0x44,0x60,0x98,0x34,0x3C,0x7B,0x0E,0x03,0x00,0x00, "Sigma", "", "80-400mm f4.5-5.6 APO DG D OS"},
{0x48,0x48,0x68,0x8E,0x30,0x30,0x4B,0x02,0x03,0x00,0x00, "Sigma", "134556", "APO 100-300mm F4 EX IF HSM"},
{0xF3,0x48,0x68,0x8E,0x30,0x30,0x4B,0x02,0x13,0x00,0x00, "Sigma", "134556", "APO 100-300mm F4 EX IF HSM"},
{0x48,0x54,0x6F,0x8E,0x24,0x24,0x4B,0x02,0x03,0x00,0x00, "Sigma", "", "APO 120-300mm F2.8 EX DG HSM"},
{0x7A,0x54,0x6E,0x8E,0x24,0x24,0x4B,0x02,0x03,0x00,0x00, "Sigma", "135553", "APO 120-300mm F2.8 EX DG HSM"},
{0xFA,0x54,0x6E,0x8E,0x24,0x24,0x4B,0x02,0x03,0x00,0x00, "Sigma", "135553", "APO 120-300mm F2.8 EX DG HSM"},
{0xCF,0x38,0x6E,0x98,0x34,0x3C,0x4B,0x0E,0x03,0x00,0x00, "Sigma", "728557", "APO 120-400mm F4.5-5.6 DG OS HSM"},
{0x26,0x44,0x73,0x98,0x34,0x3C,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "135-400mm F4.5-5.6 APO Aspherical"},
{0xCE,0x34,0x76,0xA0,0x38,0x40,0x4B,0x0E,0x03,0x00,0x00, "Sigma", "737559", "APO 150-500mm F5-6.3 DG OS HSM"},
{0x81,0x34,0x76,0xA6,0x38,0x40,0x4B,0x0E,0x03,0x00,0x00, "Sigma", "", "150-600mm F5-6.3 DG OS HSM | S"},
{0x82,0x34,0x76,0xA6,0x38,0x40,0x4B,0x0E,0x03,0x00,0x00, "Sigma", "", "150-600mm F5-6.3 DG OS HSM | C"},
{0x26,0x40,0x7B,0xA0,0x34,0x40,0x1C,0x02,0x00,0x00,0x00, "Sigma", "", "APO 170-500mm F5-6.3 Aspherical RF"},
{0xA7,0x49,0x80,0xA0,0x24,0x24,0x4B,0x06,0x03,0x00,0x00, "Sigma", "", "APO 200-500mm F2.8 EX DG"},
{0x48,0x3C,0x8E,0xB0,0x3C,0x3C,0x4B,0x02,0x03,0x00,0x00, "Sigma", "595555", "APO 300-800mm F5.6 EX DG HSM"},
//
{0x00,0x00,0x00,0x00,0x00,0x00,0xF1,0x0C,0x00,0x00,0x00, "Sigma", "", "APO Tele Converter 1.4x EX DG"},
{0x00,0x00,0x00,0x00,0x00,0x00,0xF2,0x18,0x00,0x00,0x00, "Sigma", "", "APO Tele Converter 2x EX DG"},
//
//------------------------------------------------------------------------------
// Tamron lenses by focal length, first fixed then zoom lenses
//------------------------------------------------------------------------------
//
{0x00,0x47,0x25,0x25,0x24,0x24,0x00,0x02,0x00,0x00,0x00, "Tamron", "69E", "SP AF 14mm F/2.8 Aspherical (IF)"},
{0xE8,0x4C,0x44,0x44,0x14,0x14,0xDF,0x0E,0x00,0x00,0x00, "Tamron", "F012", "SP 35mm F/1.8 Di VC USD"},
{0xE7,0x4C,0x4C,0x4C,0x14,0x14,0xDF,0x0E,0x00,0x00,0x00, "Tamron", "F013", "SP 45mm F/1.8 Di VC USD"},
{0xF4,0x54,0x56,0x56,0x18,0x18,0x84,0x06,0x01,0x00,0x00, "Tamron", "G005", "SP AF 60mm F/2 Di II LD (IF) Macro 1:1"},
{0x1E,0x5D,0x64,0x64,0x20,0x20,0x13,0x00,0x40,0x00,0x00, "Tamron", "52E", "SP AF 90mm F/2.5"},
{0x20,0x5A,0x64,0x64,0x20,0x20,0x14,0x00,0x40,0x00,0x00, "Tamron", "152E", "SP AF 90mm F/2.5 Macro"},
{0x22,0x53,0x64,0x64,0x24,0x24,0xE0,0x02,0x40,0x00,0x00, "Tamron", "72E", "SP AF 90mm F/2.8 Macro 1:1"},
{0x32,0x53,0x64,0x64,0x24,0x24,0x35,0x02,0x40,0x01,0x00, "Tamron", "172E", "SP AF 90mm F/2.8 Macro 1:1"},
{0x32,0x53,0x64,0x64,0x24,0x24,0x35,0x02,0x40,0x02,0x00, "Tamron", "272E", "SP AF 90mm F/2.8 Di Macro 1:1"},
{0xF8,0x55,0x64,0x64,0x24,0x24,0x84,0x06,0x41,0x00,0x00, "Tamron", "272NII", "SP AF 90mm F/2.8 Di Macro 1:1"},
{0xF8,0x54,0x64,0x64,0x24,0x24,0xDF,0x06,0x41,0x00,0x00, "Tamron", "272NII", "SP AF 90mm F/2.8 Di Macro 1:1"},
{0xFE,0x54,0x64,0x64,0x24,0x24,0xDF,0x0E,0x00,0x00,0x00, "Tamron", "F004", "SP 90mm F/2.8 Di VC USD MACRO 1:1"},
{0xE4,0x54,0x64,0x64,0x24,0x24,0xDF,0x0E,0x00,0x00,0x00, "Tamron", "F017", "SP 90mm f/2.8 Di VC USD Macro 1:1"},
{0x00,0x4C,0x7C,0x7C,0x2C,0x2C,0x00,0x02,0x00,0x00,0x00, "Tamron", "B01", "SP AF 180mm F/3.5 Di Model"},
{0x21,0x56,0x8E,0x8E,0x24,0x24,0x14,0x00,0x00,0x00,0x00, "Tamron", "60E", "SP AF 300mm F/2.8 LD-IF"},
{0x27,0x54,0x8E,0x8E,0x24,0x24,0x1D,0x02,0x00,0x00,0x00, "Tamron", "360E", "SP AF 300mm F/2.8 LD-IF"},
//
{0xF6,0x3F,0x18,0x37,0x2C,0x34,0x84,0x06,0x01,0x00,0x00, "Tamron", "B001", "SP AF 10-24mm F/3.5-4.5 Di II LD Aspherical (IF)"},
{0xF6,0x3F,0x18,0x37,0x2C,0x34,0xDF,0x06,0x01,0x00,0x00, "Tamron", "B001", "SP AF 10-24mm F/3.5-4.5 Di II LD Aspherical (IF)"},
{0x00,0x36,0x1C,0x2D,0x34,0x3C,0x00,0x06,0x00,0x00,0x00, "Tamron", "A13", "SP AF 11-18mm F/4.5-5.6 Di II LD Aspherical (IF)"},
{0xE9,0x48,0x27,0x3E,0x24,0x24,0xDF,0x0E,0x00,0x00,0x00, "Tamron", "A012", "SP 15-30mm F/2.8 Di VC USD"},
{0xEA,0x40,0x29,0x8E,0x2C,0x40,0xDF,0x0E,0x00,0x00,0x00, "Tamron", "B016", "AF 16-300mm F/3.5-6.3 Di II VC PZD"},
{0x07,0x46,0x2B,0x44,0x24,0x30,0x03,0x02,0x00,0x00,0x00, "Tamron", "A05", "SP AF 17-35mm F/2.8-4 Di LD Aspherical (IF)"},
{0x00,0x53,0x2B,0x50,0x24,0x24,0x00,0x06,0x00,0x00,0x00, "Tamron", "A16", "SP AF 17-50mm F/2.8 XR Di II LD Aspherical (IF)"},
{0x00,0x54,0x2B,0x50,0x24,0x24,0x00,0x06,0x01,0x00,0x00, "Tamron", "A16NII", "SP AF 17-50mm F/2.8 XR Di II LD Aspherical (IF)"},
{0xFB,0x54,0x2B,0x50,0x24,0x24,0x84,0x06,0x01,0x00,0x00, "Tamron", "A16NII", "SP AF 17-50mm F/2.8 XR Di II LD Aspherical (IF)"},
{0xF3,0x54,0x2B,0x50,0x24,0x24,0x84,0x0E,0x01,0x00,0x00, "Tamron", "B005", "SP AF 17-50mm F/2.8 XR Di II VC LD Aspherical (IF)"},
{0x00,0x3F,0x2D,0x80,0x2B,0x40,0x00,0x06,0x00,0x00,0x00, "Tamron", "A14", "AF 18-200mm F/3.5-6.3 XR Di II LD Aspherical (IF)"},
{0x00,0x3F,0x2D,0x80,0x2C,0x40,0x00,0x06,0x00,0x00,0x00, "Tamron", "A14", "AF 18-200mm F/3.5-6.3 XR Di II LD Aspherical (IF) Macro"},
{0x00,0x40,0x2D,0x80,0x2C,0x40,0x00,0x06,0x01,0x00,0x00, "Tamron", "A14NII", "AF 18-200mm F/3.5-6.3 XR Di II LD Aspherical (IF) Macro"},
{0xFC,0x40,0x2D,0x80,0x2C,0x40,0xDF,0x06,0x01,0x00,0x00, "Tamron", "A14NII", "AF 18-200mm F/3.5-6.3 XR Di II LD Aspherical (IF) Macro"},
{0xE6,0x40,0x2D,0x80,0x2C,0x40,0xDF,0x0E,0x01,0x00,0x00, "Tamron", "B018", "AF 18-200mm f/3.5-6.3 Di II VC"},
{0x00,0x40,0x2D,0x88,0x2C,0x40,0x62,0x06,0x00,0x00,0x00, "Tamron", "A18", "AF 18-250mm F/3.5-6.3 Di II LD Aspherical (IF) Macro"},
{0x00,0x40,0x2D,0x88,0x2C,0x40,0x00,0x06,0x01,0x00,0x00, "Tamron", "A18NII", "AF 18-250mm F/3.5-6.3 Di II LD Aspherical (IF) Macro "},
{0xF5,0x40,0x2C,0x8A,0x2C,0x40,0x40,0x0E,0x01,0x00,0x00, "Tamron", "B003", "AF 18-270mm F/3.5-6.3 Di II VC LD Aspherical (IF) Macro"},
{0xF0,0x3F,0x2D,0x8A,0x2C,0x40,0xDF,0x0E,0x01,0x00,0x00, "Tamron", "B008", "AF 18-270mm F/3.5-6.3 Di II VC PZD"},
{0x07,0x40,0x2F,0x44,0x2C,0x34,0x03,0x02,0x00,0x00,0x00, "Tamron", "A10", "AF 19-35mm F/3.5-4.5"},
{0x07,0x40,0x30,0x45,0x2D,0x35,0x03,0x02,0x00,0x00,0x00, "Tamron", "A10", "AF 19-35mm F/3.5-4.5"},
{0x00,0x49,0x30,0x48,0x22,0x2B,0x00,0x02,0x00,0x00,0x00, "Tamron", "166D", "SP AF 20-40mm F/2.7-3.5"},
{0x0E,0x4A,0x31,0x48,0x23,0x2D,0x0E,0x02,0x00,0x00,0x00, "Tamron", "166D", "SP AF 20-40mm F/2.7-3.5"},
//M                                         "Tamron" "266D"   "SP AF 20-40mm F/2.7-3.5 Aspherical-IF";
{0xFE,0x48,0x37,0x5C,0x24,0x24,0xDF,0x0E,0x01,0x00,0x00, "Tamron", "A007", "SP 24-70mm F/2.8 Di VC USD"},
//M                                         "Tamron" "73D"    "AF 24-70mm F/3.3-5.6 Aspherical";
{0x45,0x41,0x37,0x72,0x2C,0x3C,0x48,0x02,0x00,0x00,0x00, "Tamron", "190D", "SP AF 24-135mm F/3.5-5.6 AD Aspherical (IF) Macro"},
//M                                         "Tamron" "159D"   "AF 28-70mm F/3.5-4.5";
//M                                         "Tamron" "259D"   "AF 28-70mm F/3.5-4.5";
{0x33,0x54,0x3C,0x5E,0x24,0x24,0x62,0x02,0x00,0x00,0x00, "Tamron", "A09", "SP AF 28-75mm F/2.8 XR Di LD Aspherical (IF) Macro"},
{0xFA,0x54,0x3C,0x5E,0x24,0x24,0x84,0x06,0x01,0x00,0x00, "Tamron", "A09NII", "SP AF 28-75mm F/2.8 XR Di LD Aspherical (IF) Macro"},
{0xFA,0x54,0x3C,0x5E,0x24,0x24,0xDF,0x06,0x01,0x00,0x00, "Tamron", "A09NII", "SP AF 28-75mm F/2.8 XR Di LD Aspherical (IF) Macro"},
{0x10,0x3D,0x3C,0x60,0x2C,0x3C,0xD2,0x02,0x00,0x00,0x00, "Tamron", "177D", "AF 28-80mm F/3.5-5.6 Aspherical"},
{0x45,0x3D,0x3C,0x60,0x2C,0x3C,0x48,0x02,0x00,0x00,0x00, "Tamron", "177D", "AF 28-80mm F/3.5-5.6 Aspherical"},
{0x00,0x48,0x3C,0x6A,0x24,0x24,0x00,0x02,0x00,0x00,0x00, "Tamron", "176D", "SP AF 28-105mm F/2.8 LD Aspherical IF"},
//M                                         "Tamron" "276D"   "SP AF 28-105mm F/2.8 LD Aspherical IF";
//M                                         "Tamron" "179D"   "AF 28-105mm F4.0-5.6 IF";
{0x4D,0x3E,0x3C,0x80,0x2E,0x3C,0x62,0x02,0x00,0x00,0x00, "Tamron", "A03N", "AF 28-200mm F/3.8-5.6 XR Aspherical (IF) Macro"},
//M                                         "Tamron" "471D"   "AF 28-200mm F/3.8-5.6 Aspherical IF Super2 Silver";
{0x0B,0x3E,0x3D,0x7F,0x2F,0x3D,0x0E,0x00,0x00,0x00,0x00, "Tamron", "71D", "AF 28-200mm F/3.8-5.6"},
{0x0B,0x3E,0x3D,0x7F,0x2F,0x3D,0x0E,0x02,0x00,0x00,0x00, "Tamron", "171D", "AF 28-200mm F/3.8-5.6D"},
{0x12,0x3D,0x3C,0x80,0x2E,0x3C,0xDF,0x02,0x00,0x00,0x00, "Tamron", "271D", "AF 28-200mm F/3.8-5.6 LD Aspherical (IF)"},
{0x4D,0x41,0x3C,0x8E,0x2B,0x40,0x62,0x02,0x00,0x00,0x00, "Tamron", "A061", "AF 28-300mm F/3.5-6.3 XR Di LD Aspherical (IF)"},
{0x4D,0x41,0x3C,0x8E,0x2C,0x40,0x62,0x02,0x00,0x00,0x00, "Tamron", "185D", "AF 28-300mm F/3.5-6.3 XR LD Aspherical (IF)"},
//M                                         "Tamron" "285D"   "AF 28-300mm F/3.8-6.3 LD Aspherical IF Silver";
{0xF9,0x40,0x3C,0x8E,0x2C,0x40,0x40,0x0E,0x01,0x00,0x00, "Tamron", "A20", "AF 28-300mm F/3.5-6.3 XR Di VC LD Aspherical (IF) Macro"},
//M                                         "Tamron" "63D"    "AF 35-90mm F/4-5.6";
//M                                         "Tamron" "65D"    "SP AF 35-105mm F/2.8 Aspherical";
//M                                         "Tamron" ""       "AF 35-135mm F/3.5-4.5";
{0x00,0x47,0x53,0x80,0x30,0x3C,0x00,0x06,0x00,0x00,0x00, "Tamron", "A15", "AF 55-200mm F/4-5.6 Di II LD"},
{0xF7,0x53,0x5C,0x80,0x24,0x24,0x84,0x06,0x01,0x00,0x00, "Tamron", "A001", "SP AF 70-200mm F/2.8 Di LD (IF) Macro"},
{0xFE,0x53,0x5C,0x80,0x24,0x24,0x84,0x06,0x01,0x00,0x00, "Tamron", "A001", "SP AF 70-200mm F/2.8 Di LD (IF) Macro"},
{0xF7,0x53,0x5C,0x80,0x24,0x24,0x40,0x06,0x01,0x00,0x00, "Tamron", "A001", "SP AF 70-200mm F/2.8 Di LD (IF) Macro"},
{0xFE,0x54,0x5C,0x80,0x24,0x24,0xDF,0x0E,0x01,0x00,0x00, "Tamron", "A009", "SP AF 70-200mm F/2.8 Di VC USD"},
//M                                         "Tamron" "67D"    "SP AF 70-210mm f/2.8 LD";
//M                                         "Tamron" ""       "AF 70-210mm F/3.5-4.5";
//M                                         "Tamron" "158D"   "AF 70-210mm F/4-5.6";
//M                                         "Tamron" "258D"   "AF 70-210mm F/4-5.6";
//M                                         "Tamron" "172D"   "AF 70-300mm F/4-5.6";
//M                                         "Tamron" "472D"   "AF 70-300mm F/4-5.6 LD";
{0x69,0x48,0x5C,0x8E,0x30,0x3C,0x6F,0x02,0x00,0x00,0x00, "Tamron", "572D/772D", "AF 70-300mm F/4-5.6 LD Macro 1:2"},
{0x69,0x47,0x5C,0x8E,0x30,0x3C,0x00,0x02,0x00,0x00,0x00, "Tamron", "A17N", "AF 70-300mm F/4-5.6 Di LD Macro 1:2"},
{0x00,0x48,0x5C,0x8E,0x30,0x3C,0x00,0x06,0x01,0x00,0x00, "Tamron", "A17NII", "AF 70-300mm F/4-5.6 Di LD Macro 1:2"},
{0xF1,0x47,0x5C,0x8E,0x30,0x3C,0xDF,0x0E,0x00,0x00,0x00, "Tamron", "A005", "SP 70-300mm F4-5.6 Di VC USD"},
//M                                         "Tamron" "872D"   "AF 75-300mm F/4-5.6 LD";
//M                                         "Tamron" "278D"   "AF 80-210mm F/4.5-5.6";
//M                                         "Tamron" "62D"    "AF 90-300mm F/4.5-5.6";
//M                                         "Tamron" "186D"   "AF 100-300mm F/5-6.3";
{0xEB,0x40,0x76,0xA6,0x38,0x40,0xDF,0x0E,0x00,0x00,0x00, "Tamron", "A011", "SP AF 150-600mm F/5-6.3 VC USD"},
{0x20,0x3C,0x80,0x98,0x3D,0x3D,0x1E,0x02,0x00,0x00,0x00, "Tamron", "75D", "AF 200-400mm F/5.6 LD IF"},
{0x00,0x3E,0x80,0xA0,0x38,0x3F,0x00,0x02,0x00,0x00,0x00, "Tamron", "A08", "SP AF 200-500mm F/5-6.3 Di LD (IF)"},
{0x00,0x3F,0x80,0xA0,0x38,0x3F,0x00,0x02,0x00,0x00,0x00, "Tamron", "A08", "SP AF 200-500mm F/5-6.3 Di"},
//
//------------------------------------------------------------------------------
// Tokina Lenses by focal length, first fixed then zoom lenses
//------------------------------------------------------------------------------
//
{0x00,0x40,0x2B,0x2B,0x2C,0x2C,0x00,0x02,0x00,0x00,0x00, "Tokina", "", "AT-X 17 AF PRO (17mm f/3.5)"},
{0x00,0x47,0x44,0x44,0x24,0x24,0x00,0x06,0x40,0x00,0x00, "Tokina", "T303503", "AT-X M35 PRO DX (35mm f/2.8 Macro)"},
{0x00,0x54,0x68,0x68,0x24,0x24,0x00,0x02,0x40,0x00,0x00, "Tokina", "T310003N", "AT-X M100 AF PRO D (100mm f/2.8 Macro)"},
{0x27,0x48,0x8E,0x8E,0x30,0x30,0x1D,0x02,0x00,0x00,0x00, "Tokina", "", "AT-X 304 AF (300mm f/4.0)"},
{0x00,0x54,0x8E,0x8E,0x24,0x24,0x00,0x02,0x00,0x00,0x00, "Tokina", "", "AT-X 300 AF PRO (300mm f/2.8)"},
{0x12,0x3B,0x98,0x98,0x3D,0x3D,0x09,0x00,0x00,0x00,0x00, "Tokina", "", "AT-X 400 AF SD (400mm f/5.6)"},
//
{0x00,0x40,0x18,0x2B,0x2C,0x34,0x00,0x06,0x00,0x00,0x00, "Tokina", "T4101703", "AT-X 107 AF DX Fisheye (10-17mm f/3.5-4.5)"},
{0x00,0x48,0x1C,0x29,0x24,0x24,0x00,0x06,0x00,0x00,0x00, "Tokina", "T4111603", "AT-X 116 PRO DX (11-16mm f/2.8)"},
{0x7A,0x48,0x1C,0x29,0x24,0x24,0x7E,0x06,0x00,0x00,0x00, "Tokina", "", "AT-X 116 PRO DX II (11-16mm f/2.8)"},
{0x7A,0x48,0x1C,0x30,0x24,0x24,0x7E,0x06,0x00,0x00,0x00, "Tokina", "", "AT-X 11-20 F2.8 PRO DX (11-20mm f/2.8)"},
{0x00,0x3C,0x1F,0x37,0x30,0x30,0x00,0x06,0x00,0x00,0x00, "Tokina", "T4122403", "AT-X 124 AF PRO DX (12-24mm f/4)"},
{0x7A,0x3C,0x1F,0x37,0x30,0x30,0x7E,0x06,0x01,0x02,0x00, "Tokina", "T4122423", "AT-X 124 AF PRO DX II (12-24mm f/4)"},
{0x7A,0x3C,0x1F,0x3C,0x30,0x30,0x7E,0x06,0x00,0x00,0x00, "Tokina", "", "AT-X 12-28 PRO DX (12-28mm F/4)"},
{0x00,0x48,0x29,0x3C,0x24,0x24,0x00,0x06,0x00,0x00,0x00, "Tokina", "", "AT-X 16-28 AF PRO FX (16-28mm f/2.8)"},
{0x00,0x48,0x29,0x50,0x24,0x24,0x00,0x06,0x00,0x00,0x00, "Tokina", "", "AT-X 165 PRO DX (16-50mm f/2.8)"},
{0x00,0x40,0x2A,0x72,0x2C,0x3C,0x00,0x06,0x00,0x00,0x00, "Tokina", "", "AT-X 16.5-135 DX (16.5-135mm F3.5-5.6)"},
{0x00,0x3C,0x2B,0x44,0x30,0x30,0x00,0x06,0x00,0x00,0x00, "Tokina", "", "AT-X 17-35 F4 PRO FX (17-35mm f/4)"},
{0x2F,0x40,0x30,0x44,0x2C,0x34,0x29,0x02,0x00,0x02,0x00, "Tokina", "", "AF 193 (19-35mm f/3.5-4.5)"},
{0x2F,0x48,0x30,0x44,0x24,0x24,0x29,0x02,0x00,0x02,0x00, "Tokina", "", "AT-X 235 AF PRO (20-35mm f/2.8)"},
//M                                         "Tokina" ""          "AF 235 (AF 20-35mm f/3.5-4.5)"
{0x2F,0x40,0x30,0x44,0x2C,0x34,0x29,0x02,0x00,0x01,0x00, "Tokina", "", "AF 235 II (20-35mm f/3.5-4.5)"},
//M                                         "Tokina" ""          "AT-X 240 AF (AF 24-40mm f/2.8)"
{0x00,0x48,0x37,0x5C,0x24,0x24,0x00,0x06,0x00,0x00,0x00, "Tokina", "", "AT-X 24-70MM F2.8 PRO FX (24-70mm f/2.8)"},
{0x00,0x40,0x37,0x80,0x2C,0x3C,0x00,0x02,0x00,0x00,0x00, "Tokina", "", "AT-X 242 AF (24-200mm f/3.5-5.6)"},
{0x25,0x48,0x3C,0x5C,0x24,0x24,0x1B,0x02,0x00,0x02,0x00, "Tokina", "", "AT-X 270 AF PRO II (28-70mm f/2.6-2.8)"},
{0x25,0x48,0x3C,0x5C,0x24,0x24,0x1B,0x02,0x00,0x01,0x00, "Tokina", "", "AT-X 287 AF PRO SV (28-70mm f/2.8)"},
{0x07,0x48,0x3C,0x5C,0x24,0x24,0x03,0x00,0x00,0x00,0x00, "Tokina", "", "AT-X 287 AF (28-70mm f/2.8)"},
{0x07,0x47,0x3C,0x5C,0x25,0x35,0x03,0x00,0x00,0x00,0x00, "Tokina", "", "AF 287 SD (28-70mm f/2.8-4.5)"},
{0x07,0x40,0x3C,0x5C,0x2C,0x35,0x03,0x00,0x00,0x00,0x00, "Tokina", "", "AF 270 II (28-70mm f/3.5-4.5)"},
{0x00,0x48,0x3C,0x60,0x24,0x24,0x00,0x02,0x00,0x00,0x00, "Tokina", "", "AT-X 280 AF PRO (28-80mm f/2.8)"},
//M                                         "Tokina" ""          "AF 280 II EMZ (AF 28-80mm f/3.5-5.6)"
//M                                         "Tokina" ""          "AF 205 (AF 28-105mm f/3.5-4.5)"
//M                                         "Tokina" ""          "AF 282 (AF 28-200mm 3.5-5.6)"
//M                                         "Tokina" ""          "AF 282 EMZ II (AF 28-210mm f/4.2-6.5)"
//M                                         "Tokina" ""          "AF 370 (AF 35-70mm f/3.5-4.6)"
//M                                         "Tokina" ""          "AF 370 II (AF 35-70mm f/3.5-4.6)"
{0x25,0x44,0x44,0x8E,0x34,0x42,0x1B,0x02,0x00,0x00,0x00, "Tokina", "", "AF 353 (35-300mm f/4.5-6.7)"},
{0x00,0x48,0x50,0x72,0x24,0x24,0x00,0x06,0x00,0x00,0x00, "Tokina", "", "AT-X 535 PRO DX (50-135mm f/2.8)"},
{0x00,0x3C,0x5C,0x80,0x30,0x30,0x00,0x0E,0x00,0x00,0x00, "Tokina", "", "AT-X 70-200MM F4 FX VCM-S (70-200mm f/4)"},
{0x00,0x48,0x5C,0x80,0x30,0x30,0x00,0x0E,0x00,0x00,0x00, "Tokina", "", "AT-X 70-200MM F4 FX VCM-S (70-200mm f/4)"},
//M                                         "Tokina" ""          "AF 745 (AF 70-210mm f/4.5)"
//M                                         "Tokina" ""          "AF 210 (AF 70-210mm f/4.0-5.6)"
//M                                         "Tokina" ""          "AF 210 II SD (AF 70-210mm f/4.0-5.6)"
{0x12,0x44,0x5E,0x8E,0x34,0x3C,0x09,0x00,0x00,0x00,0x00, "Tokina", "", "AF 730 (75-300mm F4.5-5.6)"},
//M                                         "Tokina" ""          "AF 730 II (AF 75-300mm f/4.5-5.6)"
{0x14,0x54,0x60,0x80,0x24,0x24,0x0B,0x00,0x00,0x00,0x00, "Tokina", "", "AT-X 828 AF (80-200mm f/2.8)"},
{0x24,0x54,0x60,0x80,0x24,0x24,0x1A,0x02,0x00,0x00,0x00, "Tokina", "", "AT-X 828 AF PRO (80-200mm f/2.8)"},
//M                                         "Tokina" ""          "AT-X 840 AF (AF 80-400mm f/4.5-5.6)"
{0x24,0x44,0x60,0x98,0x34,0x3C,0x1A,0x02,0x00,0x00,0x00, "Tokina", "", "AT-X 840 AF-II (80-400mm f/4.5-5.6)"},
{0x00,0x44,0x60,0x98,0x34,0x3C,0x00,0x02,0x00,0x00,0x00, "Tokina", "", "AT-X 840 D (80-400mm f/4.5-5.6)"},
{0x14,0x48,0x68,0x8E,0x30,0x30,0x0B,0x00,0x00,0x00,0x00, "Tokina", "", "AT-X 340 AF (100-300mm f/4)"},
//M                                         "Tokina" ""          "AT-X 340 AF-II (AF 100-300mm f/4)"
//M                                         "Tokina" ""          "AF 130 EMZ II (AF 100-300mm f/5.6-6.7)"
//M                                         "Tokina" ""          "AF 140 EMZ (AF 100-400mm f/4.5-6.3)"
//
{0x00,0x00,0x00,0x00,0x00,0x00,0xF1,0x0C,0x00,0x00,0x00, "Kenko", "", "Teleplus PRO 300 DG 1.4x"},
{0x00,0x00,0x00,0x00,0x00,0x00,0xF2,0x18,0x00,0x00,0x00, "Kenko", "", "Teleplus PRO 300 DG 2.0x"},
//
//------------------------------------------------------------------------------
// Lenses from various other brands
//------------------------------------------------------------------------------
//
{0x06,0x3F,0x68,0x68,0x2C,0x2C,0x06,0x00,0x00,0x00,0x00, "Cosina", "", "AF 100mm F3.5 Macro"},
{0x07,0x36,0x3D,0x5F,0x2C,0x3C,0x03,0x00,0x00,0x00,0x00, "Cosina", "", "AF Zoom 28-80mm F3.5-5.6 MC Macro"},
{0x07,0x46,0x3D,0x6A,0x25,0x2F,0x03,0x00,0x00,0x00,0x00, "Cosina", "", "AF Zoom 28-105mm F2.8-3.8 MC"},
//M                                         "Cosina" "" "AF Zoom 28-210mm F3.5-5.6";
//M                                         "Cosina" "" "AF Zoom 28-210mm F4.2-6.5 Aspherical IF";
//M                                         "Cosina" "" "AF Zoom 28-300mm F4.0-6.3";
//M                                         "Cosina" "" "AF Zoom 70-210mm F2.8-4.0";
{0x12,0x36,0x5C,0x81,0x35,0x3D,0x09,0x00,0x00,0x00,0x00, "Cosina", "", "AF Zoom 70-210mm F4.5-5.6 MC Macro"},
{0x12,0x39,0x5C,0x8E,0x34,0x3D,0x08,0x02,0x00,0x00,0x00, "Cosina", "", "AF Zoom 70-300mm F4.5-5.6 MC Macro"},
{0x12,0x3B,0x68,0x8D,0x3D,0x43,0x09,0x02,0x00,0x00,0x00, "Cosina", "", "AF Zoom 100-300mm F5.6-6.7 MC Macro"},
//M                                         "Cosina" "" "AF Zoom 100-400mm F5.6-6.7 MC";
//
{0x12,0x38,0x69,0x97,0x35,0x42,0x09,0x02,0x00,0x00,0x00, "Promaster", "", "Spectrum 7 100-400mm 1:4.5-6.7"},
//
{0x00,0x40,0x31,0x31,0x2C,0x2C,0x00,0x00,0x00,0x00,0x00, "Voigtlander", "BA295AN", "Color Skopar 20mm F3.5 SLII Aspherical"},
{0x00,0x48,0x3C,0x3C,0x24,0x24,0x00,0x00,0x00,0x00,0x00, "Voigtlander", "", "Color Skopar 28mm F2.8 SL II"},
{0x00,0x54,0x48,0x48,0x18,0x18,0x00,0x00,0x00,0x00,0x00, "Voigtlander", "BA229DN", "Ultron 40mm F2 SLII Aspherical"},
{0x00,0x54,0x55,0x55,0x0C,0x0C,0x00,0x00,0x00,0x00,0x00, "Voigtlander", "BA239BN", "Nokton 58mm F1.4 SLII"},
{0x00,0x40,0x64,0x64,0x2C,0x2C,0x00,0x00,0x00,0x00,0x00, "Voigtlander", "", "APO-Lanthar 90mm F3.5 SLII Close Focus"},
//
{0x00,0x40,0x2D,0x2D,0x2C,0x2C,0x00,0x00,0x00,0x00,0x00, "Carl Zeiss", "", "Distagon T* 3,5/18 ZF.2"},
{0x00,0x48,0x32,0x32,0x24,0x24,0x00,0x00,0x00,0x00,0x00, "Carl Zeiss", "", "Distagon T* 2,8/21 ZF.2"},
{0x00,0x54,0x38,0x38,0x18,0x18,0x00,0x00,0x00,0x00,0x00, "Carl Zeiss", "", "Distagon T* 2/25 ZF.2"},
{0x00,0x54,0x3C,0x3C,0x18,0x18,0x00,0x00,0x00,0x00,0x00, "Carl Zeiss", "", "Distagon T* 2/28 ZF.2"},
{0x00,0x54,0x44,0x44,0x0C,0x0C,0x00,0x00,0x00,0x00,0x00, "Carl Zeiss", "", "Distagon T* 1.4/35 ZF.2"},
{0x00,0x54,0x44,0x44,0x18,0x18,0x00,0x00,0x00,0x00,0x00, "Carl Zeiss", "", "Distagon T* 2/35 ZF.2"},
{0x00,0x54,0x50,0x50,0x0C,0x0C,0x00,0x00,0x00,0x00,0x00, "Carl Zeiss", "", "Planar T* 1,4/50 ZF.2"},
{0x00,0x54,0x50,0x50,0x18,0x18,0x00,0x00,0x00,0x00,0x00, "Carl Zeiss", "", "Makro-Planar T* 2/50 ZF.2"},
{0x00,0x54,0x62,0x62,0x0C,0x0C,0x00,0x00,0x00,0x00,0x00, "Carl Zeiss", "", "Planar T* 1,4/85 ZF.2"},
{0x00,0x54,0x68,0x68,0x18,0x18,0x00,0x00,0x00,0x00,0x00, "Carl Zeiss", "", "Makro-Planar T* 2/100 ZF.2"},
{0x00,0x54,0x72,0x72,0x18,0x18,0x00,0x00,0x00,0x00,0x00, "Carl Zeiss", "", "Apo Sonnar T* 2/135 ZF.2"},
{0x00,0x54,0x53,0x53,0x0C,0x0C,0x00,0x00,0x00,0x00,0x00, "Zeiss", "", "Otus 1.4/55"},
{0x01,0x54,0x62,0x62,0x0C,0x0C,0x00,0x00,0x00,0x00,0x00, "Zeiss", "", "Otus 1.4/85"},
//                    " "00" "00" "00" "00" "Zeiss" "" "Milvus 2.8/21"
{0x52,0x54,0x44,0x44,0x18,0x18,0x00,0x00,0x00,0x00,0x00, "Zeiss", "", "Milvus 2/35"},
{0x53,0x54,0x50,0x50,0x0C,0x0C,0x00,0x00,0x00,0x00,0x00, "Zeiss", "", "Milvus 1.4/50"},
{0x54,0x54,0x50,0x50,0x18,0x18,0x00,0x00,0x00,0x00,0x00, "Zeiss", "", "Milvus 2/50M"},
{0x55,0x54,0x62,0x62,0x0C,0x0C,0x00,0x00,0x00,0x00,0x00, "Zeiss", "", "Milvus 1.4/85"},
{0x56,0x54,0x68,0x68,0x18,0x18,0x00,0x00,0x00,0x00,0x00, "Zeiss", "", "Milvus 2/100M"},
//
{0x00,0x54,0x56,0x56,0x30,0x30,0x00,0x00,0x00,0x00,0x00, "Coastal Optical Systems", "", "60mm 1:4 UV-VIS-IR Macro Apo"},
//
{0x4A,0x40,0x11,0x11,0x2C,0x0C,0x4D,0x02,0x00,0x00,0x00, "Samyang", "", "8mm f/3.5 Fish-Eye CS"},
{0x4A,0x48,0x1E,0x1E,0x24,0x0C,0x4D,0x02,0x00,0x00,0x00, "Samyang", "", "12mm f/2.8 ED AS NCS Fish-eye"},
{0x4A,0x48,0x24,0x24,0x24,0x0C,0x4D,0x02,0x00,0x00,0x00, "Samyang", "", "AE 14mm f/2.8 ED AS IF UMC"},
{0x4A,0x54,0x29,0x29,0x18,0x0C,0x4D,0x02,0x00,0x00,0x00, "Samyang", "", "16mm F2.0 ED AS UMC CS"},
{0x4A,0x60,0x36,0x36,0x0C,0x0C,0x4D,0x02,0x00,0x00,0x00, "Samyang", "", "24mm f/1.4 ED AS UMC"},
{0x4A,0x60,0x44,0x44,0x0C,0x0C,0x4D,0x02,0x00,0x00,0x00, "Samyang", "", "35mm f/1.4 AS UMC"},
{0x4A,0x60,0x62,0x62,0x0C,0x0C,0x4D,0x02,0x00,0x00,0x00, "Samyang", "", "AE 85mm f/1.4 AS IF UMC"},
//
{0x02,0x40,0x44,0x5C,0x2C,0x34,0x02,0x00,0x00,0x00,0x00, "Exakta", "", "AF 35-70mm 1:3.5-4.5 MC"},
{0x07,0x3E,0x30,0x43,0x2D,0x35,0x03,0x00,0x00,0x00,0x00, "Soligor", "", "AF Zoom 19-35mm 1:3.5-4.5 MC"},
{0x03,0x43,0x5C,0x81,0x35,0x35,0x02,0x00,0x00,0x00,0x00, "Soligor", "", "AF C/D Zoom UMCS 70-210mm 1:4.5"},
{0x12,0x4A,0x5C,0x81,0x31,0x3D,0x09,0x00,0x00,0x00,0x00, "Soligor", "", "AF C/D Auto Zoom+Macro 70-210mm 1:4-5.6 UMCS"},
{0x12,0x36,0x69,0x97,0x35,0x42,0x09,0x00,0x00,0x00,0x00, "Soligor", "", "AF Zoom 100-400mm 1:4.5-6.7 MC"},
//
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00, "Manual Lens", "", "No CPU"},
{0x00,0x00,0x48,0x48,0x53,0x53,0x00,0x01,0x00,0x00,0x00, "Loreo", "", "40mm F11-22 3D Lens in a Cap 9005"},
//
//------------------------------------------------------------------------------
//
// Lenses, that were upgraded with custom CPU
//
{0x00,0x47,0x10,0x10,0x24,0x24,0x00,0x00,0x00,0x00,0x00, "Nikon", "JAA604AC", "Fisheye Nikkor 8mm f/2.8 AiS"},
{0x00,0x47,0x3C,0x3C,0x24,0x24,0x00,0x00,0x00,0x00,0x00, "Nikon", "", "Nikkor 28mm f/2.8 AiS"},
//"00 54 44 44 0C 0C 00" "00" "00" "00" "00" "Nikon"   "JAA115AD" "Nikkor 35mm f/1.4 AiS" double ID with Zeiss
{0x00,0x57,0x50,0x50,0x14,0x14,0x00,0x00,0x00,0x00,0x00, "Nikon", "", "Nikkor 50mm f/1.8 AI"},
{0x00,0x48,0x50,0x50,0x18,0x18,0x00,0x00,0x00,0x00,0x00, "Nikon", "", "Nikkor H 50mm f/2"},
{0x00,0x48,0x68,0x68,0x24,0x24,0x00,0x00,0x00,0x00,0x00, "Nikon", "JAA304AA", "Series E 100mm f/2.8"},
{0x00,0x4C,0x6A,0x6A,0x20,0x20,0x00,0x00,0x00,0x00,0x00, "Nikon", "JAA305AA", "Nikkor 105mm f/2.5 AiS"},
{0x00,0x48,0x80,0x80,0x30,0x30,0x00,0x00,0x00,0x00,0x00, "Nikon", "JAA313AA", "Nikkor 200mm f/4 AiS"},
{0x00,0x40,0x11,0x11,0x2C,0x2C,0x00,0x00,0x00,0x00,0x00, "Samyang", "", "8mm f/3.5 Fish-Eye"},
{0x00,0x58,0x64,0x64,0x20,0x20,0x00,0x00,0x00,0x00,0x00, "Soligor", "", "C/D Macro MC 90mm f/2.5"},
//
{0,0,0,0,0,0,0,0,0,0,0, NULL, NULL, NULL}
};


uint64_t my_htonll(uint64_t value)
{
    // The answer is 42
    static const int num = 42;

    // Check the endianness
    if (*reinterpret_cast<const char*>(&num) == num)
    {
        const uint32_t high_part = htonl(static_cast<uint32_t>(value >> 32));
        const uint32_t low_part = htonl(static_cast<uint32_t>(value & 0xFFFFFFFFLL));

        return (static_cast<uint64_t>(low_part) << 32) | high_part;
    } else
    {
        return value;
    }
}


std::string lens_lookup(unsigned long long id)
{
	std::string lensname = "not found";
	int i;


	for (i = 0; fmountlens[i].lens.lensname != NULL; ++i) {
		unsigned long long * lensid = (unsigned long long *) &fmountlens[i];
		if (my_htonll(*lensid) == id) return std::string(fmountlens[i].lens.lensname);

	}

	return "(not found)";
}

#endif

