# Tests encoding/decoding windows-1251 (Cyrillic) and windows-1252 (Latin)
use Test;
plan 4;
my @values_1252 = 67, 8226, 194, 32, 33, 123, 199, 75, 124, 166, 235, 105, 51, 174, 0, 25, 8222, 338, 9, 168, 56, 7, 28, 167, 233, 231, 94, 91, 182, 242, 11, 113, 177, 180, 202, 122, 99, 232, 253, 215, 189, 30, 83, 236, 238, 8250, 104, 195, 8211, 121, 240, 8224, 47, 164, 29, 24, 163, 44, 85, 176, 34, 23, 1, 58, 78, 186, 352, 15, 12, 178, 112, 90, 223, 248, 210, 204, 200, 196, 8220, 95, 216, 18, 69, 3, 732, 53, 209, 171, 8240, 46, 55, 246, 219, 217, 127, 115, 109, 160, 106, 26, 62, 79, 100, 61, 50, 252, 97, 27, 197, 245, 118, 249, 227, 36, 191, 208, 88, 64, 42, 21, 8216, 213, 218, 8221, 5, 49, 63, 65, 8217, 14, 13, 224, 254, 220, 207, 187, 8249, 8364, 59, 107, 119, 22, 31, 54, 84, 251, 192, 20, 86, 102, 247, 8218, 229, 205, 185, 339, 98, 110, 165, 37, 35, 226, 198, 193, 382, 8230, 19, 221, 244, 212, 381, 117, 60, 234, 183, 214, 57, 74, 82, 190, 170, 114, 103, 16, 111, 228, 8212, 41, 76, 92, 225, 230, 241, 710, 38, 48, 81, 188, 181, 175, 8225, 43, 125, 45, 10, 70, 71, 89, 222, 237, 255, 203, 172, 77, 201, 8, 73, 93, 108, 250, 66, 72, 184, 169, 402, 120, 6, 4, 162, 126, 376, 116, 39, 52, 206, 161, 8482, 68, 80, 96, 243, 211, 179, 353, 17, 239, 173, 40, 2, 87, 101;
my @keys_1252 = 67, 149, 194, 32, 33, 123, 199, 75, 124, 166, 235, 105, 51, 174, 0, 25, 132, 140, 9, 168, 56, 7, 28, 167, 233, 231, 94, 91, 182, 242, 11, 113, 177, 180, 202, 122, 99, 232, 253, 215, 189, 30, 83, 236, 238, 155, 104, 195, 150, 121, 240, 134, 47, 164, 29, 24, 163, 44, 85, 176, 34, 23, 1, 58, 78, 186, 138, 15, 12, 178, 112, 90, 223, 248, 210, 204, 200, 196, 147, 95, 216, 18, 69, 3, 152, 53, 209, 171, 137, 46, 55, 246, 219, 217, 127, 115, 109, 160, 106, 26, 62, 79, 100, 61, 50, 252, 97, 27, 197, 245, 118, 249, 227, 36, 191, 208, 88, 64, 42, 21, 145, 213, 218, 148, 5, 49, 63, 65, 146, 14, 13, 224, 254, 220, 207, 187, 139, 128, 59, 107, 119, 22, 31, 54, 84, 251, 192, 20, 86, 102, 247, 130, 229, 205, 185, 156, 98, 110, 165, 37, 35, 226, 198, 193, 158, 133, 19, 221, 244, 212, 142, 117, 60, 234, 183, 214, 57, 74, 82, 190, 170, 114, 103, 16, 111, 228, 151, 41, 76, 92, 225, 230, 241, 136, 38, 48, 81, 188, 181, 175, 135, 43, 125, 45, 10, 70, 71, 89, 222, 237, 255, 203, 172, 77, 201, 8, 73, 93, 108, 250, 66, 72, 184, 169, 131, 120, 6, 4, 162, 126, 159, 116, 39, 52, 206, 161, 153, 68, 80, 96, 243, 211, 179, 154, 17, 239, 173, 40, 2, 87, 101;
my @values_1251 = 67, 8226, 1042, 32, 33, 123, 1047, 75, 124, 166, 1083, 105, 51, 174, 0, 25, 8222, 1034, 9, 1025, 56, 7, 28, 1106, 167, 1081, 1079, 94, 91, 1116, 182, 1090, 11, 113, 177, 1169, 1050, 122, 99, 1080, 1101, 1063, 1029, 30, 83, 1084, 1086, 8250, 104, 1043, 8211, 121, 1088, 8224, 47, 164, 29, 24, 1032, 44, 85, 176, 34, 23, 1, 58, 78, 1108, 1033, 15, 12, 1030, 112, 90, 1071, 1096, 1058, 1052, 1048, 1044, 8220, 95, 1064, 18, 69, 3, 53, 1057, 171, 8240, 46, 55, 1094, 1067, 1065, 127, 115, 109, 160, 106, 26, 62, 79, 100, 61, 50, 1100, 97, 27, 1045, 1093, 118, 1097, 1075, 36, 1111, 1056, 88, 64, 42, 21, 8216, 1061, 1066, 8221, 5, 49, 63, 65, 8217, 14, 13, 1072, 1102, 1068, 1055, 187, 8249, 1026, 59, 107, 119, 22, 31, 54, 84, 1099, 1040, 20, 86, 102, 1095, 8218, 1077, 1053, 8470, 1114, 98, 110, 1168, 1027, 37, 35, 1074, 1046, 1041, 1115, 8230, 19, 1069, 1092, 1060, 1035, 117, 60, 1082, 183, 1062, 57, 74, 82, 1109, 1028, 114, 103, 16, 111, 1076, 8212, 41, 76, 92, 1073, 1078, 1089, 8364, 38, 48, 81, 1112, 181, 1031, 8225, 43, 125, 45, 10, 70, 71, 89, 1070, 1085, 1103, 1051, 172, 77, 1049, 8, 73, 93, 108, 1098, 1039, 66, 72, 1105, 169, 1107, 120, 6, 4, 1118, 126, 1119, 116, 39, 52, 1054, 1038, 8482, 1036, 68, 80, 96, 1091, 1059, 1110, 1113, 17, 1087, 173, 40, 2, 87, 101;
my @keys_1251 = 67, 149, 194, 32, 33, 123, 199, 75, 124, 166, 235, 105, 51, 174, 0, 25, 132, 140, 9, 168, 56, 7, 28, 144, 167, 233, 231, 94, 91, 157, 182, 242, 11, 113, 177, 180, 202, 122, 99, 232, 253, 215, 189, 30, 83, 236, 238, 155, 104, 195, 150, 121, 240, 134, 47, 164, 29, 24, 163, 44, 85, 176, 34, 23, 1, 58, 78, 186, 138, 15, 12, 178, 112, 90, 223, 248, 210, 204, 200, 196, 147, 95, 216, 18, 69, 3, 53, 209, 171, 137, 46, 55, 246, 219, 217, 127, 115, 109, 160, 106, 26, 62, 79, 100, 61, 50, 252, 97, 27, 197, 245, 118, 249, 227, 36, 191, 208, 88, 64, 42, 21, 145, 213, 218, 148, 5, 49, 63, 65, 146, 14, 13, 224, 254, 220, 207, 187, 139, 128, 59, 107, 119, 22, 31, 54, 84, 251, 192, 20, 86, 102, 247, 130, 229, 205, 185, 156, 98, 110, 165, 129, 37, 35, 226, 198, 193, 158, 133, 19, 221, 244, 212, 142, 117, 60, 234, 183, 214, 57, 74, 82, 190, 170, 114, 103, 16, 111, 228, 151, 41, 76, 92, 225, 230, 241, 136, 38, 48, 81, 188, 181, 175, 135, 43, 125, 45, 10, 70, 71, 89, 222, 237, 255, 203, 172, 77, 201, 8, 73, 93, 108, 250, 143, 66, 72, 184, 169, 131, 120, 6, 4, 162, 126, 159, 116, 39, 52, 206, 161, 153, 141, 68, 80, 96, 243, 211, 179, 154, 17, 239, 173, 40, 2, 87, 101;

run_test @values_1252, @keys_1252, 'windows-1252';
run_test @values_1251, @keys_1251, 'windows-1251';
sub test_encode (@values, @keys, $encoding) {
    my $chrs = @values.chrs;
    my $buf = $chrs.encode($encoding);
    is $buf.list, @keys.list, "Test encoding from Unicode to $encoding";
}
sub run_test (@values, @keys, $encoding) {
    test_encode @values, @keys, $encoding;
    is-deeply Buf.new(@keys).decode($encoding), @values.chrs, "Test decoding from $encoding to Unicode";
}
