use v6;
# Unicode normalization tests, generated from NormalizationTests.txt in the
# Unicode database by S15-normalization/test-gen.raku.
# Generated from Unicode version 13.0.0.

use Test;

plan 2000;

ok Uni.new(0x3297).NFKD.list ~~ (0x795D,), '3297 -> 795D';
ok Uni.new(0x3298).NFKD.list ~~ (0x52B4,), '3298 -> 52B4';
ok Uni.new(0x3299).NFKD.list ~~ (0x79D8,), '3299 -> 79D8';
ok Uni.new(0x329A).NFKD.list ~~ (0x7537,), '329A -> 7537';
ok Uni.new(0x329B).NFKD.list ~~ (0x5973,), '329B -> 5973';
ok Uni.new(0x329C).NFKD.list ~~ (0x9069,), '329C -> 9069';
ok Uni.new(0x329D).NFKD.list ~~ (0x512A,), '329D -> 512A';
ok Uni.new(0x329E).NFKD.list ~~ (0x5370,), '329E -> 5370';
ok Uni.new(0x329F).NFKD.list ~~ (0x6CE8,), '329F -> 6CE8';
ok Uni.new(0x32A0).NFKD.list ~~ (0x9805,), '32A0 -> 9805';
ok Uni.new(0x32A1).NFKD.list ~~ (0x4F11,), '32A1 -> 4F11';
ok Uni.new(0x32A2).NFKD.list ~~ (0x5199,), '32A2 -> 5199';
ok Uni.new(0x32A3).NFKD.list ~~ (0x6B63,), '32A3 -> 6B63';
ok Uni.new(0x32A4).NFKD.list ~~ (0x4E0A,), '32A4 -> 4E0A';
ok Uni.new(0x32A5).NFKD.list ~~ (0x4E2D,), '32A5 -> 4E2D';
ok Uni.new(0x32A6).NFKD.list ~~ (0x4E0B,), '32A6 -> 4E0B';
ok Uni.new(0x32A7).NFKD.list ~~ (0x5DE6,), '32A7 -> 5DE6';
ok Uni.new(0x32A8).NFKD.list ~~ (0x53F3,), '32A8 -> 53F3';
ok Uni.new(0x32A9).NFKD.list ~~ (0x533B,), '32A9 -> 533B';
ok Uni.new(0x32AA).NFKD.list ~~ (0x5B97,), '32AA -> 5B97';
ok Uni.new(0x32AB).NFKD.list ~~ (0x5B66,), '32AB -> 5B66';
ok Uni.new(0x32AC).NFKD.list ~~ (0x76E3,), '32AC -> 76E3';
ok Uni.new(0x32AD).NFKD.list ~~ (0x4F01,), '32AD -> 4F01';
ok Uni.new(0x32AE).NFKD.list ~~ (0x8CC7,), '32AE -> 8CC7';
ok Uni.new(0x32AF).NFKD.list ~~ (0x5354,), '32AF -> 5354';
ok Uni.new(0x32B0).NFKD.list ~~ (0x591C,), '32B0 -> 591C';
ok Uni.new(0x32B1).NFKD.list ~~ (0x0033, 0x0036,), '32B1 -> 0033 0036';
ok Uni.new(0x32B2).NFKD.list ~~ (0x0033, 0x0037,), '32B2 -> 0033 0037';
ok Uni.new(0x32B3).NFKD.list ~~ (0x0033, 0x0038,), '32B3 -> 0033 0038';
ok Uni.new(0x32B4).NFKD.list ~~ (0x0033, 0x0039,), '32B4 -> 0033 0039';
ok Uni.new(0x32B5).NFKD.list ~~ (0x0034, 0x0030,), '32B5 -> 0034 0030';
ok Uni.new(0x32B6).NFKD.list ~~ (0x0034, 0x0031,), '32B6 -> 0034 0031';
ok Uni.new(0x32B7).NFKD.list ~~ (0x0034, 0x0032,), '32B7 -> 0034 0032';
ok Uni.new(0x32B8).NFKD.list ~~ (0x0034, 0x0033,), '32B8 -> 0034 0033';
ok Uni.new(0x32B9).NFKD.list ~~ (0x0034, 0x0034,), '32B9 -> 0034 0034';
ok Uni.new(0x32BA).NFKD.list ~~ (0x0034, 0x0035,), '32BA -> 0034 0035';
ok Uni.new(0x32BB).NFKD.list ~~ (0x0034, 0x0036,), '32BB -> 0034 0036';
ok Uni.new(0x32BC).NFKD.list ~~ (0x0034, 0x0037,), '32BC -> 0034 0037';
ok Uni.new(0x32BD).NFKD.list ~~ (0x0034, 0x0038,), '32BD -> 0034 0038';
ok Uni.new(0x32BE).NFKD.list ~~ (0x0034, 0x0039,), '32BE -> 0034 0039';
ok Uni.new(0x32BF).NFKD.list ~~ (0x0035, 0x0030,), '32BF -> 0035 0030';
ok Uni.new(0x32C0).NFKD.list ~~ (0x0031, 0x6708,), '32C0 -> 0031 6708';
ok Uni.new(0x32C1).NFKD.list ~~ (0x0032, 0x6708,), '32C1 -> 0032 6708';
ok Uni.new(0x32C2).NFKD.list ~~ (0x0033, 0x6708,), '32C2 -> 0033 6708';
ok Uni.new(0x32C3).NFKD.list ~~ (0x0034, 0x6708,), '32C3 -> 0034 6708';
ok Uni.new(0x32C4).NFKD.list ~~ (0x0035, 0x6708,), '32C4 -> 0035 6708';
ok Uni.new(0x32C5).NFKD.list ~~ (0x0036, 0x6708,), '32C5 -> 0036 6708';
ok Uni.new(0x32C6).NFKD.list ~~ (0x0037, 0x6708,), '32C6 -> 0037 6708';
ok Uni.new(0x32C7).NFKD.list ~~ (0x0038, 0x6708,), '32C7 -> 0038 6708';
ok Uni.new(0x32C8).NFKD.list ~~ (0x0039, 0x6708,), '32C8 -> 0039 6708';
ok Uni.new(0x32C9).NFKD.list ~~ (0x0031, 0x0030, 0x6708,), '32C9 -> 0031 0030 6708';
ok Uni.new(0x32CA).NFKD.list ~~ (0x0031, 0x0031, 0x6708,), '32CA -> 0031 0031 6708';
ok Uni.new(0x32CB).NFKD.list ~~ (0x0031, 0x0032, 0x6708,), '32CB -> 0031 0032 6708';
ok Uni.new(0x32CC).NFKD.list ~~ (0x0048, 0x0067,), '32CC -> 0048 0067';
ok Uni.new(0x32CD).NFKD.list ~~ (0x0065, 0x0072, 0x0067,), '32CD -> 0065 0072 0067';
ok Uni.new(0x32CE).NFKD.list ~~ (0x0065, 0x0056,), '32CE -> 0065 0056';
ok Uni.new(0x32CF).NFKD.list ~~ (0x004C, 0x0054, 0x0044,), '32CF -> 004C 0054 0044';
ok Uni.new(0x32D0).NFKD.list ~~ (0x30A2,), '32D0 -> 30A2';
ok Uni.new(0x32D1).NFKD.list ~~ (0x30A4,), '32D1 -> 30A4';
ok Uni.new(0x32D2).NFKD.list ~~ (0x30A6,), '32D2 -> 30A6';
ok Uni.new(0x32D3).NFKD.list ~~ (0x30A8,), '32D3 -> 30A8';
ok Uni.new(0x32D4).NFKD.list ~~ (0x30AA,), '32D4 -> 30AA';
ok Uni.new(0x32D5).NFKD.list ~~ (0x30AB,), '32D5 -> 30AB';
ok Uni.new(0x32D6).NFKD.list ~~ (0x30AD,), '32D6 -> 30AD';
ok Uni.new(0x32D7).NFKD.list ~~ (0x30AF,), '32D7 -> 30AF';
ok Uni.new(0x32D8).NFKD.list ~~ (0x30B1,), '32D8 -> 30B1';
ok Uni.new(0x32D9).NFKD.list ~~ (0x30B3,), '32D9 -> 30B3';
ok Uni.new(0x32DA).NFKD.list ~~ (0x30B5,), '32DA -> 30B5';
ok Uni.new(0x32DB).NFKD.list ~~ (0x30B7,), '32DB -> 30B7';
ok Uni.new(0x32DC).NFKD.list ~~ (0x30B9,), '32DC -> 30B9';
ok Uni.new(0x32DD).NFKD.list ~~ (0x30BB,), '32DD -> 30BB';
ok Uni.new(0x32DE).NFKD.list ~~ (0x30BD,), '32DE -> 30BD';
ok Uni.new(0x32DF).NFKD.list ~~ (0x30BF,), '32DF -> 30BF';
ok Uni.new(0x32E0).NFKD.list ~~ (0x30C1,), '32E0 -> 30C1';
ok Uni.new(0x32E1).NFKD.list ~~ (0x30C4,), '32E1 -> 30C4';
ok Uni.new(0x32E2).NFKD.list ~~ (0x30C6,), '32E2 -> 30C6';
ok Uni.new(0x32E3).NFKD.list ~~ (0x30C8,), '32E3 -> 30C8';
ok Uni.new(0x32E4).NFKD.list ~~ (0x30CA,), '32E4 -> 30CA';
ok Uni.new(0x32E5).NFKD.list ~~ (0x30CB,), '32E5 -> 30CB';
ok Uni.new(0x32E6).NFKD.list ~~ (0x30CC,), '32E6 -> 30CC';
ok Uni.new(0x32E7).NFKD.list ~~ (0x30CD,), '32E7 -> 30CD';
ok Uni.new(0x32E8).NFKD.list ~~ (0x30CE,), '32E8 -> 30CE';
ok Uni.new(0x32E9).NFKD.list ~~ (0x30CF,), '32E9 -> 30CF';
ok Uni.new(0x32EA).NFKD.list ~~ (0x30D2,), '32EA -> 30D2';
ok Uni.new(0x32EB).NFKD.list ~~ (0x30D5,), '32EB -> 30D5';
ok Uni.new(0x32EC).NFKD.list ~~ (0x30D8,), '32EC -> 30D8';
ok Uni.new(0x32ED).NFKD.list ~~ (0x30DB,), '32ED -> 30DB';
ok Uni.new(0x32EE).NFKD.list ~~ (0x30DE,), '32EE -> 30DE';
ok Uni.new(0x32EF).NFKD.list ~~ (0x30DF,), '32EF -> 30DF';
ok Uni.new(0x32F0).NFKD.list ~~ (0x30E0,), '32F0 -> 30E0';
ok Uni.new(0x32F1).NFKD.list ~~ (0x30E1,), '32F1 -> 30E1';
ok Uni.new(0x32F2).NFKD.list ~~ (0x30E2,), '32F2 -> 30E2';
ok Uni.new(0x32F3).NFKD.list ~~ (0x30E4,), '32F3 -> 30E4';
ok Uni.new(0x32F4).NFKD.list ~~ (0x30E6,), '32F4 -> 30E6';
ok Uni.new(0x32F5).NFKD.list ~~ (0x30E8,), '32F5 -> 30E8';
ok Uni.new(0x32F6).NFKD.list ~~ (0x30E9,), '32F6 -> 30E9';
ok Uni.new(0x32F7).NFKD.list ~~ (0x30EA,), '32F7 -> 30EA';
ok Uni.new(0x32F8).NFKD.list ~~ (0x30EB,), '32F8 -> 30EB';
ok Uni.new(0x32F9).NFKD.list ~~ (0x30EC,), '32F9 -> 30EC';
ok Uni.new(0x32FA).NFKD.list ~~ (0x30ED,), '32FA -> 30ED';
ok Uni.new(0x32FB).NFKD.list ~~ (0x30EF,), '32FB -> 30EF';
ok Uni.new(0x32FC).NFKD.list ~~ (0x30F0,), '32FC -> 30F0';
ok Uni.new(0x32FD).NFKD.list ~~ (0x30F1,), '32FD -> 30F1';
ok Uni.new(0x32FE).NFKD.list ~~ (0x30F2,), '32FE -> 30F2';
ok Uni.new(0x32FF).NFKD.list ~~ (0x4EE4, 0x548C,), '32FF -> 4EE4 548C';
ok Uni.new(0x3300).NFKD.list ~~ (0x30A2, 0x30CF, 0x309A, 0x30FC, 0x30C8,), '3300 -> 30A2 30CF 309A 30FC 30C8';
ok Uni.new(0x3301).NFKD.list ~~ (0x30A2, 0x30EB, 0x30D5, 0x30A1,), '3301 -> 30A2 30EB 30D5 30A1';
ok Uni.new(0x3302).NFKD.list ~~ (0x30A2, 0x30F3, 0x30D8, 0x309A, 0x30A2,), '3302 -> 30A2 30F3 30D8 309A 30A2';
ok Uni.new(0x3303).NFKD.list ~~ (0x30A2, 0x30FC, 0x30EB,), '3303 -> 30A2 30FC 30EB';
ok Uni.new(0x3304).NFKD.list ~~ (0x30A4, 0x30CB, 0x30F3, 0x30AF, 0x3099,), '3304 -> 30A4 30CB 30F3 30AF 3099';
ok Uni.new(0x3305).NFKD.list ~~ (0x30A4, 0x30F3, 0x30C1,), '3305 -> 30A4 30F3 30C1';
ok Uni.new(0x3306).NFKD.list ~~ (0x30A6, 0x30A9, 0x30F3,), '3306 -> 30A6 30A9 30F3';
ok Uni.new(0x3307).NFKD.list ~~ (0x30A8, 0x30B9, 0x30AF, 0x30FC, 0x30C8, 0x3099,), '3307 -> 30A8 30B9 30AF 30FC 30C8 3099';
ok Uni.new(0x3308).NFKD.list ~~ (0x30A8, 0x30FC, 0x30AB, 0x30FC,), '3308 -> 30A8 30FC 30AB 30FC';
ok Uni.new(0x3309).NFKD.list ~~ (0x30AA, 0x30F3, 0x30B9,), '3309 -> 30AA 30F3 30B9';
ok Uni.new(0x330A).NFKD.list ~~ (0x30AA, 0x30FC, 0x30E0,), '330A -> 30AA 30FC 30E0';
ok Uni.new(0x330B).NFKD.list ~~ (0x30AB, 0x30A4, 0x30EA,), '330B -> 30AB 30A4 30EA';
ok Uni.new(0x330C).NFKD.list ~~ (0x30AB, 0x30E9, 0x30C3, 0x30C8,), '330C -> 30AB 30E9 30C3 30C8';
ok Uni.new(0x330D).NFKD.list ~~ (0x30AB, 0x30ED, 0x30EA, 0x30FC,), '330D -> 30AB 30ED 30EA 30FC';
ok Uni.new(0x330E).NFKD.list ~~ (0x30AB, 0x3099, 0x30ED, 0x30F3,), '330E -> 30AB 3099 30ED 30F3';
ok Uni.new(0x330F).NFKD.list ~~ (0x30AB, 0x3099, 0x30F3, 0x30DE,), '330F -> 30AB 3099 30F3 30DE';
ok Uni.new(0x3310).NFKD.list ~~ (0x30AD, 0x3099, 0x30AB, 0x3099,), '3310 -> 30AD 3099 30AB 3099';
ok Uni.new(0x3311).NFKD.list ~~ (0x30AD, 0x3099, 0x30CB, 0x30FC,), '3311 -> 30AD 3099 30CB 30FC';
ok Uni.new(0x3312).NFKD.list ~~ (0x30AD, 0x30E5, 0x30EA, 0x30FC,), '3312 -> 30AD 30E5 30EA 30FC';
ok Uni.new(0x3313).NFKD.list ~~ (0x30AD, 0x3099, 0x30EB, 0x30BF, 0x3099, 0x30FC,), '3313 -> 30AD 3099 30EB 30BF 3099 30FC';
ok Uni.new(0x3314).NFKD.list ~~ (0x30AD, 0x30ED,), '3314 -> 30AD 30ED';
ok Uni.new(0x3315).NFKD.list ~~ (0x30AD, 0x30ED, 0x30AF, 0x3099, 0x30E9, 0x30E0,), '3315 -> 30AD 30ED 30AF 3099 30E9 30E0';
ok Uni.new(0x3316).NFKD.list ~~ (0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8, 0x30EB,), '3316 -> 30AD 30ED 30E1 30FC 30C8 30EB';
ok Uni.new(0x3317).NFKD.list ~~ (0x30AD, 0x30ED, 0x30EF, 0x30C3, 0x30C8,), '3317 -> 30AD 30ED 30EF 30C3 30C8';
ok Uni.new(0x3318).NFKD.list ~~ (0x30AF, 0x3099, 0x30E9, 0x30E0,), '3318 -> 30AF 3099 30E9 30E0';
ok Uni.new(0x3319).NFKD.list ~~ (0x30AF, 0x3099, 0x30E9, 0x30E0, 0x30C8, 0x30F3,), '3319 -> 30AF 3099 30E9 30E0 30C8 30F3';
ok Uni.new(0x331A).NFKD.list ~~ (0x30AF, 0x30EB, 0x30BB, 0x3099, 0x30A4, 0x30ED,), '331A -> 30AF 30EB 30BB 3099 30A4 30ED';
ok Uni.new(0x331B).NFKD.list ~~ (0x30AF, 0x30ED, 0x30FC, 0x30CD,), '331B -> 30AF 30ED 30FC 30CD';
ok Uni.new(0x331C).NFKD.list ~~ (0x30B1, 0x30FC, 0x30B9,), '331C -> 30B1 30FC 30B9';
ok Uni.new(0x331D).NFKD.list ~~ (0x30B3, 0x30EB, 0x30CA,), '331D -> 30B3 30EB 30CA';
ok Uni.new(0x331E).NFKD.list ~~ (0x30B3, 0x30FC, 0x30DB, 0x309A,), '331E -> 30B3 30FC 30DB 309A';
ok Uni.new(0x331F).NFKD.list ~~ (0x30B5, 0x30A4, 0x30AF, 0x30EB,), '331F -> 30B5 30A4 30AF 30EB';
ok Uni.new(0x3320).NFKD.list ~~ (0x30B5, 0x30F3, 0x30C1, 0x30FC, 0x30E0,), '3320 -> 30B5 30F3 30C1 30FC 30E0';
ok Uni.new(0x3321).NFKD.list ~~ (0x30B7, 0x30EA, 0x30F3, 0x30AF, 0x3099,), '3321 -> 30B7 30EA 30F3 30AF 3099';
ok Uni.new(0x3322).NFKD.list ~~ (0x30BB, 0x30F3, 0x30C1,), '3322 -> 30BB 30F3 30C1';
ok Uni.new(0x3323).NFKD.list ~~ (0x30BB, 0x30F3, 0x30C8,), '3323 -> 30BB 30F3 30C8';
ok Uni.new(0x3324).NFKD.list ~~ (0x30BF, 0x3099, 0x30FC, 0x30B9,), '3324 -> 30BF 3099 30FC 30B9';
ok Uni.new(0x3325).NFKD.list ~~ (0x30C6, 0x3099, 0x30B7,), '3325 -> 30C6 3099 30B7';
ok Uni.new(0x3326).NFKD.list ~~ (0x30C8, 0x3099, 0x30EB,), '3326 -> 30C8 3099 30EB';
ok Uni.new(0x3327).NFKD.list ~~ (0x30C8, 0x30F3,), '3327 -> 30C8 30F3';
ok Uni.new(0x3328).NFKD.list ~~ (0x30CA, 0x30CE,), '3328 -> 30CA 30CE';
ok Uni.new(0x3329).NFKD.list ~~ (0x30CE, 0x30C3, 0x30C8,), '3329 -> 30CE 30C3 30C8';
ok Uni.new(0x332A).NFKD.list ~~ (0x30CF, 0x30A4, 0x30C4,), '332A -> 30CF 30A4 30C4';
ok Uni.new(0x332B).NFKD.list ~~ (0x30CF, 0x309A, 0x30FC, 0x30BB, 0x30F3, 0x30C8,), '332B -> 30CF 309A 30FC 30BB 30F3 30C8';
ok Uni.new(0x332C).NFKD.list ~~ (0x30CF, 0x309A, 0x30FC, 0x30C4,), '332C -> 30CF 309A 30FC 30C4';
ok Uni.new(0x332D).NFKD.list ~~ (0x30CF, 0x3099, 0x30FC, 0x30EC, 0x30EB,), '332D -> 30CF 3099 30FC 30EC 30EB';
ok Uni.new(0x332E).NFKD.list ~~ (0x30D2, 0x309A, 0x30A2, 0x30B9, 0x30C8, 0x30EB,), '332E -> 30D2 309A 30A2 30B9 30C8 30EB';
ok Uni.new(0x332F).NFKD.list ~~ (0x30D2, 0x309A, 0x30AF, 0x30EB,), '332F -> 30D2 309A 30AF 30EB';
ok Uni.new(0x3330).NFKD.list ~~ (0x30D2, 0x309A, 0x30B3,), '3330 -> 30D2 309A 30B3';
ok Uni.new(0x3331).NFKD.list ~~ (0x30D2, 0x3099, 0x30EB,), '3331 -> 30D2 3099 30EB';
ok Uni.new(0x3332).NFKD.list ~~ (0x30D5, 0x30A1, 0x30E9, 0x30C3, 0x30C8, 0x3099,), '3332 -> 30D5 30A1 30E9 30C3 30C8 3099';
ok Uni.new(0x3333).NFKD.list ~~ (0x30D5, 0x30A3, 0x30FC, 0x30C8,), '3333 -> 30D5 30A3 30FC 30C8';
ok Uni.new(0x3334).NFKD.list ~~ (0x30D5, 0x3099, 0x30C3, 0x30B7, 0x30A7, 0x30EB,), '3334 -> 30D5 3099 30C3 30B7 30A7 30EB';
ok Uni.new(0x3335).NFKD.list ~~ (0x30D5, 0x30E9, 0x30F3,), '3335 -> 30D5 30E9 30F3';
ok Uni.new(0x3336).NFKD.list ~~ (0x30D8, 0x30AF, 0x30BF, 0x30FC, 0x30EB,), '3336 -> 30D8 30AF 30BF 30FC 30EB';
ok Uni.new(0x3337).NFKD.list ~~ (0x30D8, 0x309A, 0x30BD,), '3337 -> 30D8 309A 30BD';
ok Uni.new(0x3338).NFKD.list ~~ (0x30D8, 0x309A, 0x30CB, 0x30D2,), '3338 -> 30D8 309A 30CB 30D2';
ok Uni.new(0x3339).NFKD.list ~~ (0x30D8, 0x30EB, 0x30C4,), '3339 -> 30D8 30EB 30C4';
ok Uni.new(0x333A).NFKD.list ~~ (0x30D8, 0x309A, 0x30F3, 0x30B9,), '333A -> 30D8 309A 30F3 30B9';
ok Uni.new(0x333B).NFKD.list ~~ (0x30D8, 0x309A, 0x30FC, 0x30B7, 0x3099,), '333B -> 30D8 309A 30FC 30B7 3099';
ok Uni.new(0x333C).NFKD.list ~~ (0x30D8, 0x3099, 0x30FC, 0x30BF,), '333C -> 30D8 3099 30FC 30BF';
ok Uni.new(0x333D).NFKD.list ~~ (0x30DB, 0x309A, 0x30A4, 0x30F3, 0x30C8,), '333D -> 30DB 309A 30A4 30F3 30C8';
ok Uni.new(0x333E).NFKD.list ~~ (0x30DB, 0x3099, 0x30EB, 0x30C8,), '333E -> 30DB 3099 30EB 30C8';
ok Uni.new(0x333F).NFKD.list ~~ (0x30DB, 0x30F3,), '333F -> 30DB 30F3';
ok Uni.new(0x3340).NFKD.list ~~ (0x30DB, 0x309A, 0x30F3, 0x30C8, 0x3099,), '3340 -> 30DB 309A 30F3 30C8 3099';
ok Uni.new(0x3341).NFKD.list ~~ (0x30DB, 0x30FC, 0x30EB,), '3341 -> 30DB 30FC 30EB';
ok Uni.new(0x3342).NFKD.list ~~ (0x30DB, 0x30FC, 0x30F3,), '3342 -> 30DB 30FC 30F3';
ok Uni.new(0x3343).NFKD.list ~~ (0x30DE, 0x30A4, 0x30AF, 0x30ED,), '3343 -> 30DE 30A4 30AF 30ED';
ok Uni.new(0x3344).NFKD.list ~~ (0x30DE, 0x30A4, 0x30EB,), '3344 -> 30DE 30A4 30EB';
ok Uni.new(0x3345).NFKD.list ~~ (0x30DE, 0x30C3, 0x30CF,), '3345 -> 30DE 30C3 30CF';
ok Uni.new(0x3346).NFKD.list ~~ (0x30DE, 0x30EB, 0x30AF,), '3346 -> 30DE 30EB 30AF';
ok Uni.new(0x3347).NFKD.list ~~ (0x30DE, 0x30F3, 0x30B7, 0x30E7, 0x30F3,), '3347 -> 30DE 30F3 30B7 30E7 30F3';
ok Uni.new(0x3348).NFKD.list ~~ (0x30DF, 0x30AF, 0x30ED, 0x30F3,), '3348 -> 30DF 30AF 30ED 30F3';
ok Uni.new(0x3349).NFKD.list ~~ (0x30DF, 0x30EA,), '3349 -> 30DF 30EA';
ok Uni.new(0x334A).NFKD.list ~~ (0x30DF, 0x30EA, 0x30CF, 0x3099, 0x30FC, 0x30EB,), '334A -> 30DF 30EA 30CF 3099 30FC 30EB';
ok Uni.new(0x334B).NFKD.list ~~ (0x30E1, 0x30AB, 0x3099,), '334B -> 30E1 30AB 3099';
ok Uni.new(0x334C).NFKD.list ~~ (0x30E1, 0x30AB, 0x3099, 0x30C8, 0x30F3,), '334C -> 30E1 30AB 3099 30C8 30F3';
ok Uni.new(0x334D).NFKD.list ~~ (0x30E1, 0x30FC, 0x30C8, 0x30EB,), '334D -> 30E1 30FC 30C8 30EB';
ok Uni.new(0x334E).NFKD.list ~~ (0x30E4, 0x30FC, 0x30C8, 0x3099,), '334E -> 30E4 30FC 30C8 3099';
ok Uni.new(0x334F).NFKD.list ~~ (0x30E4, 0x30FC, 0x30EB,), '334F -> 30E4 30FC 30EB';
ok Uni.new(0x3350).NFKD.list ~~ (0x30E6, 0x30A2, 0x30F3,), '3350 -> 30E6 30A2 30F3';
ok Uni.new(0x3351).NFKD.list ~~ (0x30EA, 0x30C3, 0x30C8, 0x30EB,), '3351 -> 30EA 30C3 30C8 30EB';
ok Uni.new(0x3352).NFKD.list ~~ (0x30EA, 0x30E9,), '3352 -> 30EA 30E9';
ok Uni.new(0x3353).NFKD.list ~~ (0x30EB, 0x30D2, 0x309A, 0x30FC,), '3353 -> 30EB 30D2 309A 30FC';
ok Uni.new(0x3354).NFKD.list ~~ (0x30EB, 0x30FC, 0x30D5, 0x3099, 0x30EB,), '3354 -> 30EB 30FC 30D5 3099 30EB';
ok Uni.new(0x3355).NFKD.list ~~ (0x30EC, 0x30E0,), '3355 -> 30EC 30E0';
ok Uni.new(0x3356).NFKD.list ~~ (0x30EC, 0x30F3, 0x30C8, 0x30B1, 0x3099, 0x30F3,), '3356 -> 30EC 30F3 30C8 30B1 3099 30F3';
ok Uni.new(0x3357).NFKD.list ~~ (0x30EF, 0x30C3, 0x30C8,), '3357 -> 30EF 30C3 30C8';
ok Uni.new(0x3358).NFKD.list ~~ (0x0030, 0x70B9,), '3358 -> 0030 70B9';
ok Uni.new(0x3359).NFKD.list ~~ (0x0031, 0x70B9,), '3359 -> 0031 70B9';
ok Uni.new(0x335A).NFKD.list ~~ (0x0032, 0x70B9,), '335A -> 0032 70B9';
ok Uni.new(0x335B).NFKD.list ~~ (0x0033, 0x70B9,), '335B -> 0033 70B9';
ok Uni.new(0x335C).NFKD.list ~~ (0x0034, 0x70B9,), '335C -> 0034 70B9';
ok Uni.new(0x335D).NFKD.list ~~ (0x0035, 0x70B9,), '335D -> 0035 70B9';
ok Uni.new(0x335E).NFKD.list ~~ (0x0036, 0x70B9,), '335E -> 0036 70B9';
ok Uni.new(0x335F).NFKD.list ~~ (0x0037, 0x70B9,), '335F -> 0037 70B9';
ok Uni.new(0x3360).NFKD.list ~~ (0x0038, 0x70B9,), '3360 -> 0038 70B9';
ok Uni.new(0x3361).NFKD.list ~~ (0x0039, 0x70B9,), '3361 -> 0039 70B9';
ok Uni.new(0x3362).NFKD.list ~~ (0x0031, 0x0030, 0x70B9,), '3362 -> 0031 0030 70B9';
ok Uni.new(0x3363).NFKD.list ~~ (0x0031, 0x0031, 0x70B9,), '3363 -> 0031 0031 70B9';
ok Uni.new(0x3364).NFKD.list ~~ (0x0031, 0x0032, 0x70B9,), '3364 -> 0031 0032 70B9';
ok Uni.new(0x3365).NFKD.list ~~ (0x0031, 0x0033, 0x70B9,), '3365 -> 0031 0033 70B9';
ok Uni.new(0x3366).NFKD.list ~~ (0x0031, 0x0034, 0x70B9,), '3366 -> 0031 0034 70B9';
ok Uni.new(0x3367).NFKD.list ~~ (0x0031, 0x0035, 0x70B9,), '3367 -> 0031 0035 70B9';
ok Uni.new(0x3368).NFKD.list ~~ (0x0031, 0x0036, 0x70B9,), '3368 -> 0031 0036 70B9';
ok Uni.new(0x3369).NFKD.list ~~ (0x0031, 0x0037, 0x70B9,), '3369 -> 0031 0037 70B9';
ok Uni.new(0x336A).NFKD.list ~~ (0x0031, 0x0038, 0x70B9,), '336A -> 0031 0038 70B9';
ok Uni.new(0x336B).NFKD.list ~~ (0x0031, 0x0039, 0x70B9,), '336B -> 0031 0039 70B9';
ok Uni.new(0x336C).NFKD.list ~~ (0x0032, 0x0030, 0x70B9,), '336C -> 0032 0030 70B9';
ok Uni.new(0x336D).NFKD.list ~~ (0x0032, 0x0031, 0x70B9,), '336D -> 0032 0031 70B9';
ok Uni.new(0x336E).NFKD.list ~~ (0x0032, 0x0032, 0x70B9,), '336E -> 0032 0032 70B9';
ok Uni.new(0x336F).NFKD.list ~~ (0x0032, 0x0033, 0x70B9,), '336F -> 0032 0033 70B9';
ok Uni.new(0x3370).NFKD.list ~~ (0x0032, 0x0034, 0x70B9,), '3370 -> 0032 0034 70B9';
ok Uni.new(0x3371).NFKD.list ~~ (0x0068, 0x0050, 0x0061,), '3371 -> 0068 0050 0061';
ok Uni.new(0x3372).NFKD.list ~~ (0x0064, 0x0061,), '3372 -> 0064 0061';
ok Uni.new(0x3373).NFKD.list ~~ (0x0041, 0x0055,), '3373 -> 0041 0055';
ok Uni.new(0x3374).NFKD.list ~~ (0x0062, 0x0061, 0x0072,), '3374 -> 0062 0061 0072';
ok Uni.new(0x3375).NFKD.list ~~ (0x006F, 0x0056,), '3375 -> 006F 0056';
ok Uni.new(0x3376).NFKD.list ~~ (0x0070, 0x0063,), '3376 -> 0070 0063';
ok Uni.new(0x3377).NFKD.list ~~ (0x0064, 0x006D,), '3377 -> 0064 006D';
ok Uni.new(0x3378).NFKD.list ~~ (0x0064, 0x006D, 0x0032,), '3378 -> 0064 006D 0032';
ok Uni.new(0x3379).NFKD.list ~~ (0x0064, 0x006D, 0x0033,), '3379 -> 0064 006D 0033';
ok Uni.new(0x337A).NFKD.list ~~ (0x0049, 0x0055,), '337A -> 0049 0055';
ok Uni.new(0x337B).NFKD.list ~~ (0x5E73, 0x6210,), '337B -> 5E73 6210';
ok Uni.new(0x337C).NFKD.list ~~ (0x662D, 0x548C,), '337C -> 662D 548C';
ok Uni.new(0x337D).NFKD.list ~~ (0x5927, 0x6B63,), '337D -> 5927 6B63';
ok Uni.new(0x337E).NFKD.list ~~ (0x660E, 0x6CBB,), '337E -> 660E 6CBB';
ok Uni.new(0x337F).NFKD.list ~~ (0x682A, 0x5F0F, 0x4F1A, 0x793E,), '337F -> 682A 5F0F 4F1A 793E';
ok Uni.new(0x3380).NFKD.list ~~ (0x0070, 0x0041,), '3380 -> 0070 0041';
ok Uni.new(0x3381).NFKD.list ~~ (0x006E, 0x0041,), '3381 -> 006E 0041';
ok Uni.new(0x3382).NFKD.list ~~ (0x03BC, 0x0041,), '3382 -> 03BC 0041';
ok Uni.new(0x3383).NFKD.list ~~ (0x006D, 0x0041,), '3383 -> 006D 0041';
ok Uni.new(0x3384).NFKD.list ~~ (0x006B, 0x0041,), '3384 -> 006B 0041';
ok Uni.new(0x3385).NFKD.list ~~ (0x004B, 0x0042,), '3385 -> 004B 0042';
ok Uni.new(0x3386).NFKD.list ~~ (0x004D, 0x0042,), '3386 -> 004D 0042';
ok Uni.new(0x3387).NFKD.list ~~ (0x0047, 0x0042,), '3387 -> 0047 0042';
ok Uni.new(0x3388).NFKD.list ~~ (0x0063, 0x0061, 0x006C,), '3388 -> 0063 0061 006C';
ok Uni.new(0x3389).NFKD.list ~~ (0x006B, 0x0063, 0x0061, 0x006C,), '3389 -> 006B 0063 0061 006C';
ok Uni.new(0x338A).NFKD.list ~~ (0x0070, 0x0046,), '338A -> 0070 0046';
ok Uni.new(0x338B).NFKD.list ~~ (0x006E, 0x0046,), '338B -> 006E 0046';
ok Uni.new(0x338C).NFKD.list ~~ (0x03BC, 0x0046,), '338C -> 03BC 0046';
ok Uni.new(0x338D).NFKD.list ~~ (0x03BC, 0x0067,), '338D -> 03BC 0067';
ok Uni.new(0x338E).NFKD.list ~~ (0x006D, 0x0067,), '338E -> 006D 0067';
ok Uni.new(0x338F).NFKD.list ~~ (0x006B, 0x0067,), '338F -> 006B 0067';
ok Uni.new(0x3390).NFKD.list ~~ (0x0048, 0x007A,), '3390 -> 0048 007A';
ok Uni.new(0x3391).NFKD.list ~~ (0x006B, 0x0048, 0x007A,), '3391 -> 006B 0048 007A';
ok Uni.new(0x3392).NFKD.list ~~ (0x004D, 0x0048, 0x007A,), '3392 -> 004D 0048 007A';
ok Uni.new(0x3393).NFKD.list ~~ (0x0047, 0x0048, 0x007A,), '3393 -> 0047 0048 007A';
ok Uni.new(0x3394).NFKD.list ~~ (0x0054, 0x0048, 0x007A,), '3394 -> 0054 0048 007A';
ok Uni.new(0x3395).NFKD.list ~~ (0x03BC, 0x006C,), '3395 -> 03BC 006C';
ok Uni.new(0x3396).NFKD.list ~~ (0x006D, 0x006C,), '3396 -> 006D 006C';
ok Uni.new(0x3397).NFKD.list ~~ (0x0064, 0x006C,), '3397 -> 0064 006C';
ok Uni.new(0x3398).NFKD.list ~~ (0x006B, 0x006C,), '3398 -> 006B 006C';
ok Uni.new(0x3399).NFKD.list ~~ (0x0066, 0x006D,), '3399 -> 0066 006D';
ok Uni.new(0x339A).NFKD.list ~~ (0x006E, 0x006D,), '339A -> 006E 006D';
ok Uni.new(0x339B).NFKD.list ~~ (0x03BC, 0x006D,), '339B -> 03BC 006D';
ok Uni.new(0x339C).NFKD.list ~~ (0x006D, 0x006D,), '339C -> 006D 006D';
ok Uni.new(0x339D).NFKD.list ~~ (0x0063, 0x006D,), '339D -> 0063 006D';
ok Uni.new(0x339E).NFKD.list ~~ (0x006B, 0x006D,), '339E -> 006B 006D';
ok Uni.new(0x339F).NFKD.list ~~ (0x006D, 0x006D, 0x0032,), '339F -> 006D 006D 0032';
ok Uni.new(0x33A0).NFKD.list ~~ (0x0063, 0x006D, 0x0032,), '33A0 -> 0063 006D 0032';
ok Uni.new(0x33A1).NFKD.list ~~ (0x006D, 0x0032,), '33A1 -> 006D 0032';
ok Uni.new(0x33A2).NFKD.list ~~ (0x006B, 0x006D, 0x0032,), '33A2 -> 006B 006D 0032';
ok Uni.new(0x33A3).NFKD.list ~~ (0x006D, 0x006D, 0x0033,), '33A3 -> 006D 006D 0033';
ok Uni.new(0x33A4).NFKD.list ~~ (0x0063, 0x006D, 0x0033,), '33A4 -> 0063 006D 0033';
ok Uni.new(0x33A5).NFKD.list ~~ (0x006D, 0x0033,), '33A5 -> 006D 0033';
ok Uni.new(0x33A6).NFKD.list ~~ (0x006B, 0x006D, 0x0033,), '33A6 -> 006B 006D 0033';
ok Uni.new(0x33A7).NFKD.list ~~ (0x006D, 0x2215, 0x0073,), '33A7 -> 006D 2215 0073';
ok Uni.new(0x33A8).NFKD.list ~~ (0x006D, 0x2215, 0x0073, 0x0032,), '33A8 -> 006D 2215 0073 0032';
ok Uni.new(0x33A9).NFKD.list ~~ (0x0050, 0x0061,), '33A9 -> 0050 0061';
ok Uni.new(0x33AA).NFKD.list ~~ (0x006B, 0x0050, 0x0061,), '33AA -> 006B 0050 0061';
ok Uni.new(0x33AB).NFKD.list ~~ (0x004D, 0x0050, 0x0061,), '33AB -> 004D 0050 0061';
ok Uni.new(0x33AC).NFKD.list ~~ (0x0047, 0x0050, 0x0061,), '33AC -> 0047 0050 0061';
ok Uni.new(0x33AD).NFKD.list ~~ (0x0072, 0x0061, 0x0064,), '33AD -> 0072 0061 0064';
ok Uni.new(0x33AE).NFKD.list ~~ (0x0072, 0x0061, 0x0064, 0x2215, 0x0073,), '33AE -> 0072 0061 0064 2215 0073';
ok Uni.new(0x33AF).NFKD.list ~~ (0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x0032,), '33AF -> 0072 0061 0064 2215 0073 0032';
ok Uni.new(0x33B0).NFKD.list ~~ (0x0070, 0x0073,), '33B0 -> 0070 0073';
ok Uni.new(0x33B1).NFKD.list ~~ (0x006E, 0x0073,), '33B1 -> 006E 0073';
ok Uni.new(0x33B2).NFKD.list ~~ (0x03BC, 0x0073,), '33B2 -> 03BC 0073';
ok Uni.new(0x33B3).NFKD.list ~~ (0x006D, 0x0073,), '33B3 -> 006D 0073';
ok Uni.new(0x33B4).NFKD.list ~~ (0x0070, 0x0056,), '33B4 -> 0070 0056';
ok Uni.new(0x33B5).NFKD.list ~~ (0x006E, 0x0056,), '33B5 -> 006E 0056';
ok Uni.new(0x33B6).NFKD.list ~~ (0x03BC, 0x0056,), '33B6 -> 03BC 0056';
ok Uni.new(0x33B7).NFKD.list ~~ (0x006D, 0x0056,), '33B7 -> 006D 0056';
ok Uni.new(0x33B8).NFKD.list ~~ (0x006B, 0x0056,), '33B8 -> 006B 0056';
ok Uni.new(0x33B9).NFKD.list ~~ (0x004D, 0x0056,), '33B9 -> 004D 0056';
ok Uni.new(0x33BA).NFKD.list ~~ (0x0070, 0x0057,), '33BA -> 0070 0057';
ok Uni.new(0x33BB).NFKD.list ~~ (0x006E, 0x0057,), '33BB -> 006E 0057';
ok Uni.new(0x33BC).NFKD.list ~~ (0x03BC, 0x0057,), '33BC -> 03BC 0057';
ok Uni.new(0x33BD).NFKD.list ~~ (0x006D, 0x0057,), '33BD -> 006D 0057';
ok Uni.new(0x33BE).NFKD.list ~~ (0x006B, 0x0057,), '33BE -> 006B 0057';
ok Uni.new(0x33BF).NFKD.list ~~ (0x004D, 0x0057,), '33BF -> 004D 0057';
ok Uni.new(0x33C0).NFKD.list ~~ (0x006B, 0x03A9,), '33C0 -> 006B 03A9';
ok Uni.new(0x33C1).NFKD.list ~~ (0x004D, 0x03A9,), '33C1 -> 004D 03A9';
ok Uni.new(0x33C2).NFKD.list ~~ (0x0061, 0x002E, 0x006D, 0x002E,), '33C2 -> 0061 002E 006D 002E';
ok Uni.new(0x33C3).NFKD.list ~~ (0x0042, 0x0071,), '33C3 -> 0042 0071';
ok Uni.new(0x33C4).NFKD.list ~~ (0x0063, 0x0063,), '33C4 -> 0063 0063';
ok Uni.new(0x33C5).NFKD.list ~~ (0x0063, 0x0064,), '33C5 -> 0063 0064';
ok Uni.new(0x33C6).NFKD.list ~~ (0x0043, 0x2215, 0x006B, 0x0067,), '33C6 -> 0043 2215 006B 0067';
ok Uni.new(0x33C7).NFKD.list ~~ (0x0043, 0x006F, 0x002E,), '33C7 -> 0043 006F 002E';
ok Uni.new(0x33C8).NFKD.list ~~ (0x0064, 0x0042,), '33C8 -> 0064 0042';
ok Uni.new(0x33C9).NFKD.list ~~ (0x0047, 0x0079,), '33C9 -> 0047 0079';
ok Uni.new(0x33CA).NFKD.list ~~ (0x0068, 0x0061,), '33CA -> 0068 0061';
ok Uni.new(0x33CB).NFKD.list ~~ (0x0048, 0x0050,), '33CB -> 0048 0050';
ok Uni.new(0x33CC).NFKD.list ~~ (0x0069, 0x006E,), '33CC -> 0069 006E';
ok Uni.new(0x33CD).NFKD.list ~~ (0x004B, 0x004B,), '33CD -> 004B 004B';
ok Uni.new(0x33CE).NFKD.list ~~ (0x004B, 0x004D,), '33CE -> 004B 004D';
ok Uni.new(0x33CF).NFKD.list ~~ (0x006B, 0x0074,), '33CF -> 006B 0074';
ok Uni.new(0x33D0).NFKD.list ~~ (0x006C, 0x006D,), '33D0 -> 006C 006D';
ok Uni.new(0x33D1).NFKD.list ~~ (0x006C, 0x006E,), '33D1 -> 006C 006E';
ok Uni.new(0x33D2).NFKD.list ~~ (0x006C, 0x006F, 0x0067,), '33D2 -> 006C 006F 0067';
ok Uni.new(0x33D3).NFKD.list ~~ (0x006C, 0x0078,), '33D3 -> 006C 0078';
ok Uni.new(0x33D4).NFKD.list ~~ (0x006D, 0x0062,), '33D4 -> 006D 0062';
ok Uni.new(0x33D5).NFKD.list ~~ (0x006D, 0x0069, 0x006C,), '33D5 -> 006D 0069 006C';
ok Uni.new(0x33D6).NFKD.list ~~ (0x006D, 0x006F, 0x006C,), '33D6 -> 006D 006F 006C';
ok Uni.new(0x33D7).NFKD.list ~~ (0x0050, 0x0048,), '33D7 -> 0050 0048';
ok Uni.new(0x33D8).NFKD.list ~~ (0x0070, 0x002E, 0x006D, 0x002E,), '33D8 -> 0070 002E 006D 002E';
ok Uni.new(0x33D9).NFKD.list ~~ (0x0050, 0x0050, 0x004D,), '33D9 -> 0050 0050 004D';
ok Uni.new(0x33DA).NFKD.list ~~ (0x0050, 0x0052,), '33DA -> 0050 0052';
ok Uni.new(0x33DB).NFKD.list ~~ (0x0073, 0x0072,), '33DB -> 0073 0072';
ok Uni.new(0x33DC).NFKD.list ~~ (0x0053, 0x0076,), '33DC -> 0053 0076';
ok Uni.new(0x33DD).NFKD.list ~~ (0x0057, 0x0062,), '33DD -> 0057 0062';
ok Uni.new(0x33DE).NFKD.list ~~ (0x0056, 0x2215, 0x006D,), '33DE -> 0056 2215 006D';
ok Uni.new(0x33DF).NFKD.list ~~ (0x0041, 0x2215, 0x006D,), '33DF -> 0041 2215 006D';
ok Uni.new(0x33E0).NFKD.list ~~ (0x0031, 0x65E5,), '33E0 -> 0031 65E5';
ok Uni.new(0x33E1).NFKD.list ~~ (0x0032, 0x65E5,), '33E1 -> 0032 65E5';
ok Uni.new(0x33E2).NFKD.list ~~ (0x0033, 0x65E5,), '33E2 -> 0033 65E5';
ok Uni.new(0x33E3).NFKD.list ~~ (0x0034, 0x65E5,), '33E3 -> 0034 65E5';
ok Uni.new(0x33E4).NFKD.list ~~ (0x0035, 0x65E5,), '33E4 -> 0035 65E5';
ok Uni.new(0x33E5).NFKD.list ~~ (0x0036, 0x65E5,), '33E5 -> 0036 65E5';
ok Uni.new(0x33E6).NFKD.list ~~ (0x0037, 0x65E5,), '33E6 -> 0037 65E5';
ok Uni.new(0x33E7).NFKD.list ~~ (0x0038, 0x65E5,), '33E7 -> 0038 65E5';
ok Uni.new(0x33E8).NFKD.list ~~ (0x0039, 0x65E5,), '33E8 -> 0039 65E5';
ok Uni.new(0x33E9).NFKD.list ~~ (0x0031, 0x0030, 0x65E5,), '33E9 -> 0031 0030 65E5';
ok Uni.new(0x33EA).NFKD.list ~~ (0x0031, 0x0031, 0x65E5,), '33EA -> 0031 0031 65E5';
ok Uni.new(0x33EB).NFKD.list ~~ (0x0031, 0x0032, 0x65E5,), '33EB -> 0031 0032 65E5';
ok Uni.new(0x33EC).NFKD.list ~~ (0x0031, 0x0033, 0x65E5,), '33EC -> 0031 0033 65E5';
ok Uni.new(0x33ED).NFKD.list ~~ (0x0031, 0x0034, 0x65E5,), '33ED -> 0031 0034 65E5';
ok Uni.new(0x33EE).NFKD.list ~~ (0x0031, 0x0035, 0x65E5,), '33EE -> 0031 0035 65E5';
ok Uni.new(0x33EF).NFKD.list ~~ (0x0031, 0x0036, 0x65E5,), '33EF -> 0031 0036 65E5';
ok Uni.new(0x33F0).NFKD.list ~~ (0x0031, 0x0037, 0x65E5,), '33F0 -> 0031 0037 65E5';
ok Uni.new(0x33F1).NFKD.list ~~ (0x0031, 0x0038, 0x65E5,), '33F1 -> 0031 0038 65E5';
ok Uni.new(0x33F2).NFKD.list ~~ (0x0031, 0x0039, 0x65E5,), '33F2 -> 0031 0039 65E5';
ok Uni.new(0x33F3).NFKD.list ~~ (0x0032, 0x0030, 0x65E5,), '33F3 -> 0032 0030 65E5';
ok Uni.new(0x33F4).NFKD.list ~~ (0x0032, 0x0031, 0x65E5,), '33F4 -> 0032 0031 65E5';
ok Uni.new(0x33F5).NFKD.list ~~ (0x0032, 0x0032, 0x65E5,), '33F5 -> 0032 0032 65E5';
ok Uni.new(0x33F6).NFKD.list ~~ (0x0032, 0x0033, 0x65E5,), '33F6 -> 0032 0033 65E5';
ok Uni.new(0x33F7).NFKD.list ~~ (0x0032, 0x0034, 0x65E5,), '33F7 -> 0032 0034 65E5';
ok Uni.new(0x33F8).NFKD.list ~~ (0x0032, 0x0035, 0x65E5,), '33F8 -> 0032 0035 65E5';
ok Uni.new(0x33F9).NFKD.list ~~ (0x0032, 0x0036, 0x65E5,), '33F9 -> 0032 0036 65E5';
ok Uni.new(0x33FA).NFKD.list ~~ (0x0032, 0x0037, 0x65E5,), '33FA -> 0032 0037 65E5';
ok Uni.new(0x33FB).NFKD.list ~~ (0x0032, 0x0038, 0x65E5,), '33FB -> 0032 0038 65E5';
ok Uni.new(0x33FC).NFKD.list ~~ (0x0032, 0x0039, 0x65E5,), '33FC -> 0032 0039 65E5';
ok Uni.new(0x33FD).NFKD.list ~~ (0x0033, 0x0030, 0x65E5,), '33FD -> 0033 0030 65E5';
ok Uni.new(0x33FE).NFKD.list ~~ (0x0033, 0x0031, 0x65E5,), '33FE -> 0033 0031 65E5';
ok Uni.new(0x33FF).NFKD.list ~~ (0x0067, 0x0061, 0x006C,), '33FF -> 0067 0061 006C';
ok Uni.new(0xA69C).NFKD.list ~~ (0x044A,), 'A69C -> 044A';
ok Uni.new(0xA69D).NFKD.list ~~ (0x044C,), 'A69D -> 044C';
ok Uni.new(0xA770).NFKD.list ~~ (0xA76F,), 'A770 -> A76F';
ok Uni.new(0xA7F8).NFKD.list ~~ (0x0126,), 'A7F8 -> 0126';
ok Uni.new(0xA7F9).NFKD.list ~~ (0x0153,), 'A7F9 -> 0153';
ok Uni.new(0xAB5C).NFKD.list ~~ (0xA727,), 'AB5C -> A727';
ok Uni.new(0xAB5D).NFKD.list ~~ (0xAB37,), 'AB5D -> AB37';
ok Uni.new(0xAB5E).NFKD.list ~~ (0x026B,), 'AB5E -> 026B';
ok Uni.new(0xAB5F).NFKD.list ~~ (0xAB52,), 'AB5F -> AB52';
ok Uni.new(0xAB69).NFKD.list ~~ (0x028D,), 'AB69 -> 028D';
ok Uni.new(0xAC00).NFKD.list ~~ (0x1100, 0x1161,), 'AC00 -> 1100 1161';
ok Uni.new(0xAC01).NFKD.list ~~ (0x1100, 0x1161, 0x11A8,), 'AC01 -> 1100 1161 11A8';
ok Uni.new(0xAC02).NFKD.list ~~ (0x1100, 0x1161, 0x11A9,), 'AC02 -> 1100 1161 11A9';
ok Uni.new(0xAC03).NFKD.list ~~ (0x1100, 0x1161, 0x11AA,), 'AC03 -> 1100 1161 11AA';
ok Uni.new(0xAC04).NFKD.list ~~ (0x1100, 0x1161, 0x11AB,), 'AC04 -> 1100 1161 11AB';
ok Uni.new(0xAC05).NFKD.list ~~ (0x1100, 0x1161, 0x11AC,), 'AC05 -> 1100 1161 11AC';
ok Uni.new(0xAC06).NFKD.list ~~ (0x1100, 0x1161, 0x11AD,), 'AC06 -> 1100 1161 11AD';
ok Uni.new(0xAC07).NFKD.list ~~ (0x1100, 0x1161, 0x11AE,), 'AC07 -> 1100 1161 11AE';
ok Uni.new(0xAC08).NFKD.list ~~ (0x1100, 0x1161, 0x11AF,), 'AC08 -> 1100 1161 11AF';
ok Uni.new(0xAC09).NFKD.list ~~ (0x1100, 0x1161, 0x11B0,), 'AC09 -> 1100 1161 11B0';
ok Uni.new(0xAC0A).NFKD.list ~~ (0x1100, 0x1161, 0x11B1,), 'AC0A -> 1100 1161 11B1';
ok Uni.new(0xAC0B).NFKD.list ~~ (0x1100, 0x1161, 0x11B2,), 'AC0B -> 1100 1161 11B2';
ok Uni.new(0xAC0C).NFKD.list ~~ (0x1100, 0x1161, 0x11B3,), 'AC0C -> 1100 1161 11B3';
ok Uni.new(0xAC0D).NFKD.list ~~ (0x1100, 0x1161, 0x11B4,), 'AC0D -> 1100 1161 11B4';
ok Uni.new(0xAC0E).NFKD.list ~~ (0x1100, 0x1161, 0x11B5,), 'AC0E -> 1100 1161 11B5';
ok Uni.new(0xAC0F).NFKD.list ~~ (0x1100, 0x1161, 0x11B6,), 'AC0F -> 1100 1161 11B6';
ok Uni.new(0xAC10).NFKD.list ~~ (0x1100, 0x1161, 0x11B7,), 'AC10 -> 1100 1161 11B7';
ok Uni.new(0xAC11).NFKD.list ~~ (0x1100, 0x1161, 0x11B8,), 'AC11 -> 1100 1161 11B8';
ok Uni.new(0xAC12).NFKD.list ~~ (0x1100, 0x1161, 0x11B9,), 'AC12 -> 1100 1161 11B9';
ok Uni.new(0xAC13).NFKD.list ~~ (0x1100, 0x1161, 0x11BA,), 'AC13 -> 1100 1161 11BA';
ok Uni.new(0xAC14).NFKD.list ~~ (0x1100, 0x1161, 0x11BB,), 'AC14 -> 1100 1161 11BB';
ok Uni.new(0xAC15).NFKD.list ~~ (0x1100, 0x1161, 0x11BC,), 'AC15 -> 1100 1161 11BC';
ok Uni.new(0xAC16).NFKD.list ~~ (0x1100, 0x1161, 0x11BD,), 'AC16 -> 1100 1161 11BD';
ok Uni.new(0xAC17).NFKD.list ~~ (0x1100, 0x1161, 0x11BE,), 'AC17 -> 1100 1161 11BE';
ok Uni.new(0xAC18).NFKD.list ~~ (0x1100, 0x1161, 0x11BF,), 'AC18 -> 1100 1161 11BF';
ok Uni.new(0xAC19).NFKD.list ~~ (0x1100, 0x1161, 0x11C0,), 'AC19 -> 1100 1161 11C0';
ok Uni.new(0xAC1A).NFKD.list ~~ (0x1100, 0x1161, 0x11C1,), 'AC1A -> 1100 1161 11C1';
ok Uni.new(0xAC1B).NFKD.list ~~ (0x1100, 0x1161, 0x11C2,), 'AC1B -> 1100 1161 11C2';
ok Uni.new(0xAC1C).NFKD.list ~~ (0x1100, 0x1162,), 'AC1C -> 1100 1162';
ok Uni.new(0xAC1D).NFKD.list ~~ (0x1100, 0x1162, 0x11A8,), 'AC1D -> 1100 1162 11A8';
ok Uni.new(0xAC1E).NFKD.list ~~ (0x1100, 0x1162, 0x11A9,), 'AC1E -> 1100 1162 11A9';
ok Uni.new(0xAC1F).NFKD.list ~~ (0x1100, 0x1162, 0x11AA,), 'AC1F -> 1100 1162 11AA';
ok Uni.new(0xAC20).NFKD.list ~~ (0x1100, 0x1162, 0x11AB,), 'AC20 -> 1100 1162 11AB';
ok Uni.new(0xAC21).NFKD.list ~~ (0x1100, 0x1162, 0x11AC,), 'AC21 -> 1100 1162 11AC';
ok Uni.new(0xAC22).NFKD.list ~~ (0x1100, 0x1162, 0x11AD,), 'AC22 -> 1100 1162 11AD';
ok Uni.new(0xAC23).NFKD.list ~~ (0x1100, 0x1162, 0x11AE,), 'AC23 -> 1100 1162 11AE';
ok Uni.new(0xAC24).NFKD.list ~~ (0x1100, 0x1162, 0x11AF,), 'AC24 -> 1100 1162 11AF';
ok Uni.new(0xAC25).NFKD.list ~~ (0x1100, 0x1162, 0x11B0,), 'AC25 -> 1100 1162 11B0';
ok Uni.new(0xAC26).NFKD.list ~~ (0x1100, 0x1162, 0x11B1,), 'AC26 -> 1100 1162 11B1';
ok Uni.new(0xAC27).NFKD.list ~~ (0x1100, 0x1162, 0x11B2,), 'AC27 -> 1100 1162 11B2';
ok Uni.new(0xAC28).NFKD.list ~~ (0x1100, 0x1162, 0x11B3,), 'AC28 -> 1100 1162 11B3';
ok Uni.new(0xAC29).NFKD.list ~~ (0x1100, 0x1162, 0x11B4,), 'AC29 -> 1100 1162 11B4';
ok Uni.new(0xAC2A).NFKD.list ~~ (0x1100, 0x1162, 0x11B5,), 'AC2A -> 1100 1162 11B5';
ok Uni.new(0xAC2B).NFKD.list ~~ (0x1100, 0x1162, 0x11B6,), 'AC2B -> 1100 1162 11B6';
ok Uni.new(0xAC2C).NFKD.list ~~ (0x1100, 0x1162, 0x11B7,), 'AC2C -> 1100 1162 11B7';
ok Uni.new(0xAC2D).NFKD.list ~~ (0x1100, 0x1162, 0x11B8,), 'AC2D -> 1100 1162 11B8';
ok Uni.new(0xAC2E).NFKD.list ~~ (0x1100, 0x1162, 0x11B9,), 'AC2E -> 1100 1162 11B9';
ok Uni.new(0xAC2F).NFKD.list ~~ (0x1100, 0x1162, 0x11BA,), 'AC2F -> 1100 1162 11BA';
ok Uni.new(0xAC30).NFKD.list ~~ (0x1100, 0x1162, 0x11BB,), 'AC30 -> 1100 1162 11BB';
ok Uni.new(0xAC31).NFKD.list ~~ (0x1100, 0x1162, 0x11BC,), 'AC31 -> 1100 1162 11BC';
ok Uni.new(0xAC32).NFKD.list ~~ (0x1100, 0x1162, 0x11BD,), 'AC32 -> 1100 1162 11BD';
ok Uni.new(0xAC33).NFKD.list ~~ (0x1100, 0x1162, 0x11BE,), 'AC33 -> 1100 1162 11BE';
ok Uni.new(0xAC34).NFKD.list ~~ (0x1100, 0x1162, 0x11BF,), 'AC34 -> 1100 1162 11BF';
ok Uni.new(0xAC35).NFKD.list ~~ (0x1100, 0x1162, 0x11C0,), 'AC35 -> 1100 1162 11C0';
ok Uni.new(0xAC36).NFKD.list ~~ (0x1100, 0x1162, 0x11C1,), 'AC36 -> 1100 1162 11C1';
ok Uni.new(0xAC37).NFKD.list ~~ (0x1100, 0x1162, 0x11C2,), 'AC37 -> 1100 1162 11C2';
ok Uni.new(0xAC38).NFKD.list ~~ (0x1100, 0x1163,), 'AC38 -> 1100 1163';
ok Uni.new(0xAC39).NFKD.list ~~ (0x1100, 0x1163, 0x11A8,), 'AC39 -> 1100 1163 11A8';
ok Uni.new(0xAC3A).NFKD.list ~~ (0x1100, 0x1163, 0x11A9,), 'AC3A -> 1100 1163 11A9';
ok Uni.new(0xAC3B).NFKD.list ~~ (0x1100, 0x1163, 0x11AA,), 'AC3B -> 1100 1163 11AA';
ok Uni.new(0xAC3C).NFKD.list ~~ (0x1100, 0x1163, 0x11AB,), 'AC3C -> 1100 1163 11AB';
ok Uni.new(0xAC3D).NFKD.list ~~ (0x1100, 0x1163, 0x11AC,), 'AC3D -> 1100 1163 11AC';
ok Uni.new(0xAC3E).NFKD.list ~~ (0x1100, 0x1163, 0x11AD,), 'AC3E -> 1100 1163 11AD';
ok Uni.new(0xAC3F).NFKD.list ~~ (0x1100, 0x1163, 0x11AE,), 'AC3F -> 1100 1163 11AE';
ok Uni.new(0xAC40).NFKD.list ~~ (0x1100, 0x1163, 0x11AF,), 'AC40 -> 1100 1163 11AF';
ok Uni.new(0xAC41).NFKD.list ~~ (0x1100, 0x1163, 0x11B0,), 'AC41 -> 1100 1163 11B0';
ok Uni.new(0xAC42).NFKD.list ~~ (0x1100, 0x1163, 0x11B1,), 'AC42 -> 1100 1163 11B1';
ok Uni.new(0xAC43).NFKD.list ~~ (0x1100, 0x1163, 0x11B2,), 'AC43 -> 1100 1163 11B2';
ok Uni.new(0xAC44).NFKD.list ~~ (0x1100, 0x1163, 0x11B3,), 'AC44 -> 1100 1163 11B3';
ok Uni.new(0xAC45).NFKD.list ~~ (0x1100, 0x1163, 0x11B4,), 'AC45 -> 1100 1163 11B4';
ok Uni.new(0xAC46).NFKD.list ~~ (0x1100, 0x1163, 0x11B5,), 'AC46 -> 1100 1163 11B5';
ok Uni.new(0xAC47).NFKD.list ~~ (0x1100, 0x1163, 0x11B6,), 'AC47 -> 1100 1163 11B6';
ok Uni.new(0xAC48).NFKD.list ~~ (0x1100, 0x1163, 0x11B7,), 'AC48 -> 1100 1163 11B7';
ok Uni.new(0xAC49).NFKD.list ~~ (0x1100, 0x1163, 0x11B8,), 'AC49 -> 1100 1163 11B8';
ok Uni.new(0xAC4A).NFKD.list ~~ (0x1100, 0x1163, 0x11B9,), 'AC4A -> 1100 1163 11B9';
ok Uni.new(0xAC4B).NFKD.list ~~ (0x1100, 0x1163, 0x11BA,), 'AC4B -> 1100 1163 11BA';
ok Uni.new(0xAC4C).NFKD.list ~~ (0x1100, 0x1163, 0x11BB,), 'AC4C -> 1100 1163 11BB';
ok Uni.new(0xAC4D).NFKD.list ~~ (0x1100, 0x1163, 0x11BC,), 'AC4D -> 1100 1163 11BC';
ok Uni.new(0xAC4E).NFKD.list ~~ (0x1100, 0x1163, 0x11BD,), 'AC4E -> 1100 1163 11BD';
ok Uni.new(0xAC4F).NFKD.list ~~ (0x1100, 0x1163, 0x11BE,), 'AC4F -> 1100 1163 11BE';
ok Uni.new(0xAC50).NFKD.list ~~ (0x1100, 0x1163, 0x11BF,), 'AC50 -> 1100 1163 11BF';
ok Uni.new(0xAC51).NFKD.list ~~ (0x1100, 0x1163, 0x11C0,), 'AC51 -> 1100 1163 11C0';
ok Uni.new(0xAC52).NFKD.list ~~ (0x1100, 0x1163, 0x11C1,), 'AC52 -> 1100 1163 11C1';
ok Uni.new(0xAC53).NFKD.list ~~ (0x1100, 0x1163, 0x11C2,), 'AC53 -> 1100 1163 11C2';
ok Uni.new(0xAC54).NFKD.list ~~ (0x1100, 0x1164,), 'AC54 -> 1100 1164';
ok Uni.new(0xAC55).NFKD.list ~~ (0x1100, 0x1164, 0x11A8,), 'AC55 -> 1100 1164 11A8';
ok Uni.new(0xAC56).NFKD.list ~~ (0x1100, 0x1164, 0x11A9,), 'AC56 -> 1100 1164 11A9';
ok Uni.new(0xAC57).NFKD.list ~~ (0x1100, 0x1164, 0x11AA,), 'AC57 -> 1100 1164 11AA';
ok Uni.new(0xAC58).NFKD.list ~~ (0x1100, 0x1164, 0x11AB,), 'AC58 -> 1100 1164 11AB';
ok Uni.new(0xAC59).NFKD.list ~~ (0x1100, 0x1164, 0x11AC,), 'AC59 -> 1100 1164 11AC';
ok Uni.new(0xAC5A).NFKD.list ~~ (0x1100, 0x1164, 0x11AD,), 'AC5A -> 1100 1164 11AD';
ok Uni.new(0xAC5B).NFKD.list ~~ (0x1100, 0x1164, 0x11AE,), 'AC5B -> 1100 1164 11AE';
ok Uni.new(0xAC5C).NFKD.list ~~ (0x1100, 0x1164, 0x11AF,), 'AC5C -> 1100 1164 11AF';
ok Uni.new(0xAC5D).NFKD.list ~~ (0x1100, 0x1164, 0x11B0,), 'AC5D -> 1100 1164 11B0';
ok Uni.new(0xAC5E).NFKD.list ~~ (0x1100, 0x1164, 0x11B1,), 'AC5E -> 1100 1164 11B1';
ok Uni.new(0xAC5F).NFKD.list ~~ (0x1100, 0x1164, 0x11B2,), 'AC5F -> 1100 1164 11B2';
ok Uni.new(0xAC60).NFKD.list ~~ (0x1100, 0x1164, 0x11B3,), 'AC60 -> 1100 1164 11B3';
ok Uni.new(0xAC61).NFKD.list ~~ (0x1100, 0x1164, 0x11B4,), 'AC61 -> 1100 1164 11B4';
ok Uni.new(0xAC62).NFKD.list ~~ (0x1100, 0x1164, 0x11B5,), 'AC62 -> 1100 1164 11B5';
ok Uni.new(0xAC63).NFKD.list ~~ (0x1100, 0x1164, 0x11B6,), 'AC63 -> 1100 1164 11B6';
ok Uni.new(0xAC64).NFKD.list ~~ (0x1100, 0x1164, 0x11B7,), 'AC64 -> 1100 1164 11B7';
ok Uni.new(0xAC65).NFKD.list ~~ (0x1100, 0x1164, 0x11B8,), 'AC65 -> 1100 1164 11B8';
ok Uni.new(0xAC66).NFKD.list ~~ (0x1100, 0x1164, 0x11B9,), 'AC66 -> 1100 1164 11B9';
ok Uni.new(0xAC67).NFKD.list ~~ (0x1100, 0x1164, 0x11BA,), 'AC67 -> 1100 1164 11BA';
ok Uni.new(0xAC68).NFKD.list ~~ (0x1100, 0x1164, 0x11BB,), 'AC68 -> 1100 1164 11BB';
ok Uni.new(0xAC69).NFKD.list ~~ (0x1100, 0x1164, 0x11BC,), 'AC69 -> 1100 1164 11BC';
ok Uni.new(0xAC6A).NFKD.list ~~ (0x1100, 0x1164, 0x11BD,), 'AC6A -> 1100 1164 11BD';
ok Uni.new(0xAC6B).NFKD.list ~~ (0x1100, 0x1164, 0x11BE,), 'AC6B -> 1100 1164 11BE';
ok Uni.new(0xAC6C).NFKD.list ~~ (0x1100, 0x1164, 0x11BF,), 'AC6C -> 1100 1164 11BF';
ok Uni.new(0xAC6D).NFKD.list ~~ (0x1100, 0x1164, 0x11C0,), 'AC6D -> 1100 1164 11C0';
ok Uni.new(0xAC6E).NFKD.list ~~ (0x1100, 0x1164, 0x11C1,), 'AC6E -> 1100 1164 11C1';
ok Uni.new(0xAC6F).NFKD.list ~~ (0x1100, 0x1164, 0x11C2,), 'AC6F -> 1100 1164 11C2';
ok Uni.new(0xAC70).NFKD.list ~~ (0x1100, 0x1165,), 'AC70 -> 1100 1165';
ok Uni.new(0xAC71).NFKD.list ~~ (0x1100, 0x1165, 0x11A8,), 'AC71 -> 1100 1165 11A8';
ok Uni.new(0xAC72).NFKD.list ~~ (0x1100, 0x1165, 0x11A9,), 'AC72 -> 1100 1165 11A9';
ok Uni.new(0xAC73).NFKD.list ~~ (0x1100, 0x1165, 0x11AA,), 'AC73 -> 1100 1165 11AA';
ok Uni.new(0xAC74).NFKD.list ~~ (0x1100, 0x1165, 0x11AB,), 'AC74 -> 1100 1165 11AB';
ok Uni.new(0xAC75).NFKD.list ~~ (0x1100, 0x1165, 0x11AC,), 'AC75 -> 1100 1165 11AC';
ok Uni.new(0xAC76).NFKD.list ~~ (0x1100, 0x1165, 0x11AD,), 'AC76 -> 1100 1165 11AD';
ok Uni.new(0xAC77).NFKD.list ~~ (0x1100, 0x1165, 0x11AE,), 'AC77 -> 1100 1165 11AE';
ok Uni.new(0xAC78).NFKD.list ~~ (0x1100, 0x1165, 0x11AF,), 'AC78 -> 1100 1165 11AF';
ok Uni.new(0xAC79).NFKD.list ~~ (0x1100, 0x1165, 0x11B0,), 'AC79 -> 1100 1165 11B0';
ok Uni.new(0xAC7A).NFKD.list ~~ (0x1100, 0x1165, 0x11B1,), 'AC7A -> 1100 1165 11B1';
ok Uni.new(0xAC7B).NFKD.list ~~ (0x1100, 0x1165, 0x11B2,), 'AC7B -> 1100 1165 11B2';
ok Uni.new(0xAC7C).NFKD.list ~~ (0x1100, 0x1165, 0x11B3,), 'AC7C -> 1100 1165 11B3';
ok Uni.new(0xAC7D).NFKD.list ~~ (0x1100, 0x1165, 0x11B4,), 'AC7D -> 1100 1165 11B4';
ok Uni.new(0xAC7E).NFKD.list ~~ (0x1100, 0x1165, 0x11B5,), 'AC7E -> 1100 1165 11B5';
ok Uni.new(0xAC7F).NFKD.list ~~ (0x1100, 0x1165, 0x11B6,), 'AC7F -> 1100 1165 11B6';
ok Uni.new(0xAC80).NFKD.list ~~ (0x1100, 0x1165, 0x11B7,), 'AC80 -> 1100 1165 11B7';
ok Uni.new(0xAC81).NFKD.list ~~ (0x1100, 0x1165, 0x11B8,), 'AC81 -> 1100 1165 11B8';
ok Uni.new(0xAC82).NFKD.list ~~ (0x1100, 0x1165, 0x11B9,), 'AC82 -> 1100 1165 11B9';
ok Uni.new(0xAC83).NFKD.list ~~ (0x1100, 0x1165, 0x11BA,), 'AC83 -> 1100 1165 11BA';
ok Uni.new(0xAC84).NFKD.list ~~ (0x1100, 0x1165, 0x11BB,), 'AC84 -> 1100 1165 11BB';
ok Uni.new(0xAC85).NFKD.list ~~ (0x1100, 0x1165, 0x11BC,), 'AC85 -> 1100 1165 11BC';
ok Uni.new(0xAC86).NFKD.list ~~ (0x1100, 0x1165, 0x11BD,), 'AC86 -> 1100 1165 11BD';
ok Uni.new(0xAC87).NFKD.list ~~ (0x1100, 0x1165, 0x11BE,), 'AC87 -> 1100 1165 11BE';
ok Uni.new(0xAC88).NFKD.list ~~ (0x1100, 0x1165, 0x11BF,), 'AC88 -> 1100 1165 11BF';
ok Uni.new(0xAC89).NFKD.list ~~ (0x1100, 0x1165, 0x11C0,), 'AC89 -> 1100 1165 11C0';
ok Uni.new(0xAC8A).NFKD.list ~~ (0x1100, 0x1165, 0x11C1,), 'AC8A -> 1100 1165 11C1';
ok Uni.new(0xAC8B).NFKD.list ~~ (0x1100, 0x1165, 0x11C2,), 'AC8B -> 1100 1165 11C2';
ok Uni.new(0xAC8C).NFKD.list ~~ (0x1100, 0x1166,), 'AC8C -> 1100 1166';
ok Uni.new(0xAC8D).NFKD.list ~~ (0x1100, 0x1166, 0x11A8,), 'AC8D -> 1100 1166 11A8';
ok Uni.new(0xAC8E).NFKD.list ~~ (0x1100, 0x1166, 0x11A9,), 'AC8E -> 1100 1166 11A9';
ok Uni.new(0xAC8F).NFKD.list ~~ (0x1100, 0x1166, 0x11AA,), 'AC8F -> 1100 1166 11AA';
ok Uni.new(0xAC90).NFKD.list ~~ (0x1100, 0x1166, 0x11AB,), 'AC90 -> 1100 1166 11AB';
ok Uni.new(0xAC91).NFKD.list ~~ (0x1100, 0x1166, 0x11AC,), 'AC91 -> 1100 1166 11AC';
ok Uni.new(0xAC92).NFKD.list ~~ (0x1100, 0x1166, 0x11AD,), 'AC92 -> 1100 1166 11AD';
ok Uni.new(0xAC93).NFKD.list ~~ (0x1100, 0x1166, 0x11AE,), 'AC93 -> 1100 1166 11AE';
ok Uni.new(0xAC94).NFKD.list ~~ (0x1100, 0x1166, 0x11AF,), 'AC94 -> 1100 1166 11AF';
ok Uni.new(0xAC95).NFKD.list ~~ (0x1100, 0x1166, 0x11B0,), 'AC95 -> 1100 1166 11B0';
ok Uni.new(0xAC96).NFKD.list ~~ (0x1100, 0x1166, 0x11B1,), 'AC96 -> 1100 1166 11B1';
ok Uni.new(0xAC97).NFKD.list ~~ (0x1100, 0x1166, 0x11B2,), 'AC97 -> 1100 1166 11B2';
ok Uni.new(0xAC98).NFKD.list ~~ (0x1100, 0x1166, 0x11B3,), 'AC98 -> 1100 1166 11B3';
ok Uni.new(0xAC99).NFKD.list ~~ (0x1100, 0x1166, 0x11B4,), 'AC99 -> 1100 1166 11B4';
ok Uni.new(0xAC9A).NFKD.list ~~ (0x1100, 0x1166, 0x11B5,), 'AC9A -> 1100 1166 11B5';
ok Uni.new(0xAC9B).NFKD.list ~~ (0x1100, 0x1166, 0x11B6,), 'AC9B -> 1100 1166 11B6';
ok Uni.new(0xAC9C).NFKD.list ~~ (0x1100, 0x1166, 0x11B7,), 'AC9C -> 1100 1166 11B7';
ok Uni.new(0xAC9D).NFKD.list ~~ (0x1100, 0x1166, 0x11B8,), 'AC9D -> 1100 1166 11B8';
ok Uni.new(0xAC9E).NFKD.list ~~ (0x1100, 0x1166, 0x11B9,), 'AC9E -> 1100 1166 11B9';
ok Uni.new(0xAC9F).NFKD.list ~~ (0x1100, 0x1166, 0x11BA,), 'AC9F -> 1100 1166 11BA';
ok Uni.new(0xACA0).NFKD.list ~~ (0x1100, 0x1166, 0x11BB,), 'ACA0 -> 1100 1166 11BB';
ok Uni.new(0xACA1).NFKD.list ~~ (0x1100, 0x1166, 0x11BC,), 'ACA1 -> 1100 1166 11BC';
ok Uni.new(0xACA2).NFKD.list ~~ (0x1100, 0x1166, 0x11BD,), 'ACA2 -> 1100 1166 11BD';
ok Uni.new(0xACA3).NFKD.list ~~ (0x1100, 0x1166, 0x11BE,), 'ACA3 -> 1100 1166 11BE';
ok Uni.new(0xACA4).NFKD.list ~~ (0x1100, 0x1166, 0x11BF,), 'ACA4 -> 1100 1166 11BF';
ok Uni.new(0xACA5).NFKD.list ~~ (0x1100, 0x1166, 0x11C0,), 'ACA5 -> 1100 1166 11C0';
ok Uni.new(0xACA6).NFKD.list ~~ (0x1100, 0x1166, 0x11C1,), 'ACA6 -> 1100 1166 11C1';
ok Uni.new(0xACA7).NFKD.list ~~ (0x1100, 0x1166, 0x11C2,), 'ACA7 -> 1100 1166 11C2';
ok Uni.new(0xACA8).NFKD.list ~~ (0x1100, 0x1167,), 'ACA8 -> 1100 1167';
ok Uni.new(0xACA9).NFKD.list ~~ (0x1100, 0x1167, 0x11A8,), 'ACA9 -> 1100 1167 11A8';
ok Uni.new(0xACAA).NFKD.list ~~ (0x1100, 0x1167, 0x11A9,), 'ACAA -> 1100 1167 11A9';
ok Uni.new(0xACAB).NFKD.list ~~ (0x1100, 0x1167, 0x11AA,), 'ACAB -> 1100 1167 11AA';
ok Uni.new(0xACAC).NFKD.list ~~ (0x1100, 0x1167, 0x11AB,), 'ACAC -> 1100 1167 11AB';
ok Uni.new(0xACAD).NFKD.list ~~ (0x1100, 0x1167, 0x11AC,), 'ACAD -> 1100 1167 11AC';
ok Uni.new(0xACAE).NFKD.list ~~ (0x1100, 0x1167, 0x11AD,), 'ACAE -> 1100 1167 11AD';
ok Uni.new(0xACAF).NFKD.list ~~ (0x1100, 0x1167, 0x11AE,), 'ACAF -> 1100 1167 11AE';
ok Uni.new(0xACB0).NFKD.list ~~ (0x1100, 0x1167, 0x11AF,), 'ACB0 -> 1100 1167 11AF';
ok Uni.new(0xACB1).NFKD.list ~~ (0x1100, 0x1167, 0x11B0,), 'ACB1 -> 1100 1167 11B0';
ok Uni.new(0xACB2).NFKD.list ~~ (0x1100, 0x1167, 0x11B1,), 'ACB2 -> 1100 1167 11B1';
ok Uni.new(0xACB3).NFKD.list ~~ (0x1100, 0x1167, 0x11B2,), 'ACB3 -> 1100 1167 11B2';
ok Uni.new(0xACB4).NFKD.list ~~ (0x1100, 0x1167, 0x11B3,), 'ACB4 -> 1100 1167 11B3';
ok Uni.new(0xACB5).NFKD.list ~~ (0x1100, 0x1167, 0x11B4,), 'ACB5 -> 1100 1167 11B4';
ok Uni.new(0xACB6).NFKD.list ~~ (0x1100, 0x1167, 0x11B5,), 'ACB6 -> 1100 1167 11B5';
ok Uni.new(0xACB7).NFKD.list ~~ (0x1100, 0x1167, 0x11B6,), 'ACB7 -> 1100 1167 11B6';
ok Uni.new(0xACB8).NFKD.list ~~ (0x1100, 0x1167, 0x11B7,), 'ACB8 -> 1100 1167 11B7';
ok Uni.new(0xACB9).NFKD.list ~~ (0x1100, 0x1167, 0x11B8,), 'ACB9 -> 1100 1167 11B8';
ok Uni.new(0xACBA).NFKD.list ~~ (0x1100, 0x1167, 0x11B9,), 'ACBA -> 1100 1167 11B9';
ok Uni.new(0xACBB).NFKD.list ~~ (0x1100, 0x1167, 0x11BA,), 'ACBB -> 1100 1167 11BA';
ok Uni.new(0xACBC).NFKD.list ~~ (0x1100, 0x1167, 0x11BB,), 'ACBC -> 1100 1167 11BB';
ok Uni.new(0xACBD).NFKD.list ~~ (0x1100, 0x1167, 0x11BC,), 'ACBD -> 1100 1167 11BC';
ok Uni.new(0xACBE).NFKD.list ~~ (0x1100, 0x1167, 0x11BD,), 'ACBE -> 1100 1167 11BD';
ok Uni.new(0xACBF).NFKD.list ~~ (0x1100, 0x1167, 0x11BE,), 'ACBF -> 1100 1167 11BE';
ok Uni.new(0xACC0).NFKD.list ~~ (0x1100, 0x1167, 0x11BF,), 'ACC0 -> 1100 1167 11BF';
ok Uni.new(0xACC1).NFKD.list ~~ (0x1100, 0x1167, 0x11C0,), 'ACC1 -> 1100 1167 11C0';
ok Uni.new(0xACC2).NFKD.list ~~ (0x1100, 0x1167, 0x11C1,), 'ACC2 -> 1100 1167 11C1';
ok Uni.new(0xACC3).NFKD.list ~~ (0x1100, 0x1167, 0x11C2,), 'ACC3 -> 1100 1167 11C2';
ok Uni.new(0xACC4).NFKD.list ~~ (0x1100, 0x1168,), 'ACC4 -> 1100 1168';
ok Uni.new(0xACC5).NFKD.list ~~ (0x1100, 0x1168, 0x11A8,), 'ACC5 -> 1100 1168 11A8';
ok Uni.new(0xACC6).NFKD.list ~~ (0x1100, 0x1168, 0x11A9,), 'ACC6 -> 1100 1168 11A9';
ok Uni.new(0xACC7).NFKD.list ~~ (0x1100, 0x1168, 0x11AA,), 'ACC7 -> 1100 1168 11AA';
ok Uni.new(0xACC8).NFKD.list ~~ (0x1100, 0x1168, 0x11AB,), 'ACC8 -> 1100 1168 11AB';
ok Uni.new(0xACC9).NFKD.list ~~ (0x1100, 0x1168, 0x11AC,), 'ACC9 -> 1100 1168 11AC';
ok Uni.new(0xACCA).NFKD.list ~~ (0x1100, 0x1168, 0x11AD,), 'ACCA -> 1100 1168 11AD';
ok Uni.new(0xACCB).NFKD.list ~~ (0x1100, 0x1168, 0x11AE,), 'ACCB -> 1100 1168 11AE';
ok Uni.new(0xACCC).NFKD.list ~~ (0x1100, 0x1168, 0x11AF,), 'ACCC -> 1100 1168 11AF';
ok Uni.new(0xACCD).NFKD.list ~~ (0x1100, 0x1168, 0x11B0,), 'ACCD -> 1100 1168 11B0';
ok Uni.new(0xACCE).NFKD.list ~~ (0x1100, 0x1168, 0x11B1,), 'ACCE -> 1100 1168 11B1';
ok Uni.new(0xACCF).NFKD.list ~~ (0x1100, 0x1168, 0x11B2,), 'ACCF -> 1100 1168 11B2';
ok Uni.new(0xACD0).NFKD.list ~~ (0x1100, 0x1168, 0x11B3,), 'ACD0 -> 1100 1168 11B3';
ok Uni.new(0xACD1).NFKD.list ~~ (0x1100, 0x1168, 0x11B4,), 'ACD1 -> 1100 1168 11B4';
ok Uni.new(0xACD2).NFKD.list ~~ (0x1100, 0x1168, 0x11B5,), 'ACD2 -> 1100 1168 11B5';
ok Uni.new(0xACD3).NFKD.list ~~ (0x1100, 0x1168, 0x11B6,), 'ACD3 -> 1100 1168 11B6';
ok Uni.new(0xACD4).NFKD.list ~~ (0x1100, 0x1168, 0x11B7,), 'ACD4 -> 1100 1168 11B7';
ok Uni.new(0xACD5).NFKD.list ~~ (0x1100, 0x1168, 0x11B8,), 'ACD5 -> 1100 1168 11B8';
ok Uni.new(0xACD6).NFKD.list ~~ (0x1100, 0x1168, 0x11B9,), 'ACD6 -> 1100 1168 11B9';
ok Uni.new(0xACD7).NFKD.list ~~ (0x1100, 0x1168, 0x11BA,), 'ACD7 -> 1100 1168 11BA';
ok Uni.new(0xACD8).NFKD.list ~~ (0x1100, 0x1168, 0x11BB,), 'ACD8 -> 1100 1168 11BB';
ok Uni.new(0xACD9).NFKD.list ~~ (0x1100, 0x1168, 0x11BC,), 'ACD9 -> 1100 1168 11BC';
ok Uni.new(0xACDA).NFKD.list ~~ (0x1100, 0x1168, 0x11BD,), 'ACDA -> 1100 1168 11BD';
ok Uni.new(0xACDB).NFKD.list ~~ (0x1100, 0x1168, 0x11BE,), 'ACDB -> 1100 1168 11BE';
ok Uni.new(0xACDC).NFKD.list ~~ (0x1100, 0x1168, 0x11BF,), 'ACDC -> 1100 1168 11BF';
ok Uni.new(0xACDD).NFKD.list ~~ (0x1100, 0x1168, 0x11C0,), 'ACDD -> 1100 1168 11C0';
ok Uni.new(0xACDE).NFKD.list ~~ (0x1100, 0x1168, 0x11C1,), 'ACDE -> 1100 1168 11C1';
ok Uni.new(0xACDF).NFKD.list ~~ (0x1100, 0x1168, 0x11C2,), 'ACDF -> 1100 1168 11C2';
ok Uni.new(0xACE0).NFKD.list ~~ (0x1100, 0x1169,), 'ACE0 -> 1100 1169';
ok Uni.new(0xACE1).NFKD.list ~~ (0x1100, 0x1169, 0x11A8,), 'ACE1 -> 1100 1169 11A8';
ok Uni.new(0xACE2).NFKD.list ~~ (0x1100, 0x1169, 0x11A9,), 'ACE2 -> 1100 1169 11A9';
ok Uni.new(0xACE3).NFKD.list ~~ (0x1100, 0x1169, 0x11AA,), 'ACE3 -> 1100 1169 11AA';
ok Uni.new(0xACE4).NFKD.list ~~ (0x1100, 0x1169, 0x11AB,), 'ACE4 -> 1100 1169 11AB';
ok Uni.new(0xACE5).NFKD.list ~~ (0x1100, 0x1169, 0x11AC,), 'ACE5 -> 1100 1169 11AC';
ok Uni.new(0xACE6).NFKD.list ~~ (0x1100, 0x1169, 0x11AD,), 'ACE6 -> 1100 1169 11AD';
ok Uni.new(0xACE7).NFKD.list ~~ (0x1100, 0x1169, 0x11AE,), 'ACE7 -> 1100 1169 11AE';
ok Uni.new(0xACE8).NFKD.list ~~ (0x1100, 0x1169, 0x11AF,), 'ACE8 -> 1100 1169 11AF';
ok Uni.new(0xACE9).NFKD.list ~~ (0x1100, 0x1169, 0x11B0,), 'ACE9 -> 1100 1169 11B0';
ok Uni.new(0xACEA).NFKD.list ~~ (0x1100, 0x1169, 0x11B1,), 'ACEA -> 1100 1169 11B1';
ok Uni.new(0xACEB).NFKD.list ~~ (0x1100, 0x1169, 0x11B2,), 'ACEB -> 1100 1169 11B2';
ok Uni.new(0xACEC).NFKD.list ~~ (0x1100, 0x1169, 0x11B3,), 'ACEC -> 1100 1169 11B3';
ok Uni.new(0xACED).NFKD.list ~~ (0x1100, 0x1169, 0x11B4,), 'ACED -> 1100 1169 11B4';
ok Uni.new(0xACEE).NFKD.list ~~ (0x1100, 0x1169, 0x11B5,), 'ACEE -> 1100 1169 11B5';
ok Uni.new(0xACEF).NFKD.list ~~ (0x1100, 0x1169, 0x11B6,), 'ACEF -> 1100 1169 11B6';
ok Uni.new(0xACF0).NFKD.list ~~ (0x1100, 0x1169, 0x11B7,), 'ACF0 -> 1100 1169 11B7';
ok Uni.new(0xACF1).NFKD.list ~~ (0x1100, 0x1169, 0x11B8,), 'ACF1 -> 1100 1169 11B8';
ok Uni.new(0xACF2).NFKD.list ~~ (0x1100, 0x1169, 0x11B9,), 'ACF2 -> 1100 1169 11B9';
ok Uni.new(0xACF3).NFKD.list ~~ (0x1100, 0x1169, 0x11BA,), 'ACF3 -> 1100 1169 11BA';
ok Uni.new(0xACF4).NFKD.list ~~ (0x1100, 0x1169, 0x11BB,), 'ACF4 -> 1100 1169 11BB';
ok Uni.new(0xACF5).NFKD.list ~~ (0x1100, 0x1169, 0x11BC,), 'ACF5 -> 1100 1169 11BC';
ok Uni.new(0xACF6).NFKD.list ~~ (0x1100, 0x1169, 0x11BD,), 'ACF6 -> 1100 1169 11BD';
ok Uni.new(0xACF7).NFKD.list ~~ (0x1100, 0x1169, 0x11BE,), 'ACF7 -> 1100 1169 11BE';
ok Uni.new(0xACF8).NFKD.list ~~ (0x1100, 0x1169, 0x11BF,), 'ACF8 -> 1100 1169 11BF';
ok Uni.new(0xACF9).NFKD.list ~~ (0x1100, 0x1169, 0x11C0,), 'ACF9 -> 1100 1169 11C0';
ok Uni.new(0xACFA).NFKD.list ~~ (0x1100, 0x1169, 0x11C1,), 'ACFA -> 1100 1169 11C1';
ok Uni.new(0xACFB).NFKD.list ~~ (0x1100, 0x1169, 0x11C2,), 'ACFB -> 1100 1169 11C2';
ok Uni.new(0xACFC).NFKD.list ~~ (0x1100, 0x116A,), 'ACFC -> 1100 116A';
ok Uni.new(0xACFD).NFKD.list ~~ (0x1100, 0x116A, 0x11A8,), 'ACFD -> 1100 116A 11A8';
ok Uni.new(0xACFE).NFKD.list ~~ (0x1100, 0x116A, 0x11A9,), 'ACFE -> 1100 116A 11A9';
ok Uni.new(0xACFF).NFKD.list ~~ (0x1100, 0x116A, 0x11AA,), 'ACFF -> 1100 116A 11AA';
ok Uni.new(0xAD00).NFKD.list ~~ (0x1100, 0x116A, 0x11AB,), 'AD00 -> 1100 116A 11AB';
ok Uni.new(0xAD01).NFKD.list ~~ (0x1100, 0x116A, 0x11AC,), 'AD01 -> 1100 116A 11AC';
ok Uni.new(0xAD02).NFKD.list ~~ (0x1100, 0x116A, 0x11AD,), 'AD02 -> 1100 116A 11AD';
ok Uni.new(0xAD03).NFKD.list ~~ (0x1100, 0x116A, 0x11AE,), 'AD03 -> 1100 116A 11AE';
ok Uni.new(0xAD04).NFKD.list ~~ (0x1100, 0x116A, 0x11AF,), 'AD04 -> 1100 116A 11AF';
ok Uni.new(0xAD05).NFKD.list ~~ (0x1100, 0x116A, 0x11B0,), 'AD05 -> 1100 116A 11B0';
ok Uni.new(0xAD06).NFKD.list ~~ (0x1100, 0x116A, 0x11B1,), 'AD06 -> 1100 116A 11B1';
ok Uni.new(0xAD07).NFKD.list ~~ (0x1100, 0x116A, 0x11B2,), 'AD07 -> 1100 116A 11B2';
ok Uni.new(0xAD08).NFKD.list ~~ (0x1100, 0x116A, 0x11B3,), 'AD08 -> 1100 116A 11B3';
ok Uni.new(0xAD09).NFKD.list ~~ (0x1100, 0x116A, 0x11B4,), 'AD09 -> 1100 116A 11B4';
ok Uni.new(0xAD0A).NFKD.list ~~ (0x1100, 0x116A, 0x11B5,), 'AD0A -> 1100 116A 11B5';
ok Uni.new(0xAD0B).NFKD.list ~~ (0x1100, 0x116A, 0x11B6,), 'AD0B -> 1100 116A 11B6';
ok Uni.new(0xAD0C).NFKD.list ~~ (0x1100, 0x116A, 0x11B7,), 'AD0C -> 1100 116A 11B7';
ok Uni.new(0xAD0D).NFKD.list ~~ (0x1100, 0x116A, 0x11B8,), 'AD0D -> 1100 116A 11B8';
ok Uni.new(0xAD0E).NFKD.list ~~ (0x1100, 0x116A, 0x11B9,), 'AD0E -> 1100 116A 11B9';
ok Uni.new(0xAD0F).NFKD.list ~~ (0x1100, 0x116A, 0x11BA,), 'AD0F -> 1100 116A 11BA';
ok Uni.new(0xAD10).NFKD.list ~~ (0x1100, 0x116A, 0x11BB,), 'AD10 -> 1100 116A 11BB';
ok Uni.new(0xAD11).NFKD.list ~~ (0x1100, 0x116A, 0x11BC,), 'AD11 -> 1100 116A 11BC';
ok Uni.new(0xAD12).NFKD.list ~~ (0x1100, 0x116A, 0x11BD,), 'AD12 -> 1100 116A 11BD';
ok Uni.new(0xAD13).NFKD.list ~~ (0x1100, 0x116A, 0x11BE,), 'AD13 -> 1100 116A 11BE';
ok Uni.new(0xAD14).NFKD.list ~~ (0x1100, 0x116A, 0x11BF,), 'AD14 -> 1100 116A 11BF';
ok Uni.new(0xAD15).NFKD.list ~~ (0x1100, 0x116A, 0x11C0,), 'AD15 -> 1100 116A 11C0';
ok Uni.new(0xAD16).NFKD.list ~~ (0x1100, 0x116A, 0x11C1,), 'AD16 -> 1100 116A 11C1';
ok Uni.new(0xAD17).NFKD.list ~~ (0x1100, 0x116A, 0x11C2,), 'AD17 -> 1100 116A 11C2';
ok Uni.new(0xAD18).NFKD.list ~~ (0x1100, 0x116B,), 'AD18 -> 1100 116B';
ok Uni.new(0xAD19).NFKD.list ~~ (0x1100, 0x116B, 0x11A8,), 'AD19 -> 1100 116B 11A8';
ok Uni.new(0xAD1A).NFKD.list ~~ (0x1100, 0x116B, 0x11A9,), 'AD1A -> 1100 116B 11A9';
ok Uni.new(0xAD1B).NFKD.list ~~ (0x1100, 0x116B, 0x11AA,), 'AD1B -> 1100 116B 11AA';
ok Uni.new(0xAD1C).NFKD.list ~~ (0x1100, 0x116B, 0x11AB,), 'AD1C -> 1100 116B 11AB';
ok Uni.new(0xAD1D).NFKD.list ~~ (0x1100, 0x116B, 0x11AC,), 'AD1D -> 1100 116B 11AC';
ok Uni.new(0xAD1E).NFKD.list ~~ (0x1100, 0x116B, 0x11AD,), 'AD1E -> 1100 116B 11AD';
ok Uni.new(0xAD1F).NFKD.list ~~ (0x1100, 0x116B, 0x11AE,), 'AD1F -> 1100 116B 11AE';
ok Uni.new(0xAD20).NFKD.list ~~ (0x1100, 0x116B, 0x11AF,), 'AD20 -> 1100 116B 11AF';
ok Uni.new(0xAD21).NFKD.list ~~ (0x1100, 0x116B, 0x11B0,), 'AD21 -> 1100 116B 11B0';
ok Uni.new(0xAD22).NFKD.list ~~ (0x1100, 0x116B, 0x11B1,), 'AD22 -> 1100 116B 11B1';
ok Uni.new(0xAD23).NFKD.list ~~ (0x1100, 0x116B, 0x11B2,), 'AD23 -> 1100 116B 11B2';
ok Uni.new(0xAD24).NFKD.list ~~ (0x1100, 0x116B, 0x11B3,), 'AD24 -> 1100 116B 11B3';
ok Uni.new(0xAD25).NFKD.list ~~ (0x1100, 0x116B, 0x11B4,), 'AD25 -> 1100 116B 11B4';
ok Uni.new(0xAD26).NFKD.list ~~ (0x1100, 0x116B, 0x11B5,), 'AD26 -> 1100 116B 11B5';
ok Uni.new(0xAD27).NFKD.list ~~ (0x1100, 0x116B, 0x11B6,), 'AD27 -> 1100 116B 11B6';
ok Uni.new(0xAD28).NFKD.list ~~ (0x1100, 0x116B, 0x11B7,), 'AD28 -> 1100 116B 11B7';
ok Uni.new(0xAD29).NFKD.list ~~ (0x1100, 0x116B, 0x11B8,), 'AD29 -> 1100 116B 11B8';
ok Uni.new(0xAD2A).NFKD.list ~~ (0x1100, 0x116B, 0x11B9,), 'AD2A -> 1100 116B 11B9';
ok Uni.new(0xAD2B).NFKD.list ~~ (0x1100, 0x116B, 0x11BA,), 'AD2B -> 1100 116B 11BA';
ok Uni.new(0xAD2C).NFKD.list ~~ (0x1100, 0x116B, 0x11BB,), 'AD2C -> 1100 116B 11BB';
ok Uni.new(0xAD2D).NFKD.list ~~ (0x1100, 0x116B, 0x11BC,), 'AD2D -> 1100 116B 11BC';
ok Uni.new(0xAD2E).NFKD.list ~~ (0x1100, 0x116B, 0x11BD,), 'AD2E -> 1100 116B 11BD';
ok Uni.new(0xAD2F).NFKD.list ~~ (0x1100, 0x116B, 0x11BE,), 'AD2F -> 1100 116B 11BE';
ok Uni.new(0xAD30).NFKD.list ~~ (0x1100, 0x116B, 0x11BF,), 'AD30 -> 1100 116B 11BF';
ok Uni.new(0xAD31).NFKD.list ~~ (0x1100, 0x116B, 0x11C0,), 'AD31 -> 1100 116B 11C0';
ok Uni.new(0xAD32).NFKD.list ~~ (0x1100, 0x116B, 0x11C1,), 'AD32 -> 1100 116B 11C1';
ok Uni.new(0xAD33).NFKD.list ~~ (0x1100, 0x116B, 0x11C2,), 'AD33 -> 1100 116B 11C2';
ok Uni.new(0xAD34).NFKD.list ~~ (0x1100, 0x116C,), 'AD34 -> 1100 116C';
ok Uni.new(0xAD35).NFKD.list ~~ (0x1100, 0x116C, 0x11A8,), 'AD35 -> 1100 116C 11A8';
ok Uni.new(0xAD36).NFKD.list ~~ (0x1100, 0x116C, 0x11A9,), 'AD36 -> 1100 116C 11A9';
ok Uni.new(0xAD37).NFKD.list ~~ (0x1100, 0x116C, 0x11AA,), 'AD37 -> 1100 116C 11AA';
ok Uni.new(0xAD38).NFKD.list ~~ (0x1100, 0x116C, 0x11AB,), 'AD38 -> 1100 116C 11AB';
ok Uni.new(0xAD39).NFKD.list ~~ (0x1100, 0x116C, 0x11AC,), 'AD39 -> 1100 116C 11AC';
ok Uni.new(0xAD3A).NFKD.list ~~ (0x1100, 0x116C, 0x11AD,), 'AD3A -> 1100 116C 11AD';
ok Uni.new(0xAD3B).NFKD.list ~~ (0x1100, 0x116C, 0x11AE,), 'AD3B -> 1100 116C 11AE';
ok Uni.new(0xAD3C).NFKD.list ~~ (0x1100, 0x116C, 0x11AF,), 'AD3C -> 1100 116C 11AF';
ok Uni.new(0xAD3D).NFKD.list ~~ (0x1100, 0x116C, 0x11B0,), 'AD3D -> 1100 116C 11B0';
ok Uni.new(0xAD3E).NFKD.list ~~ (0x1100, 0x116C, 0x11B1,), 'AD3E -> 1100 116C 11B1';
ok Uni.new(0xAD3F).NFKD.list ~~ (0x1100, 0x116C, 0x11B2,), 'AD3F -> 1100 116C 11B2';
ok Uni.new(0xAD40).NFKD.list ~~ (0x1100, 0x116C, 0x11B3,), 'AD40 -> 1100 116C 11B3';
ok Uni.new(0xAD41).NFKD.list ~~ (0x1100, 0x116C, 0x11B4,), 'AD41 -> 1100 116C 11B4';
ok Uni.new(0xAD42).NFKD.list ~~ (0x1100, 0x116C, 0x11B5,), 'AD42 -> 1100 116C 11B5';
ok Uni.new(0xAD43).NFKD.list ~~ (0x1100, 0x116C, 0x11B6,), 'AD43 -> 1100 116C 11B6';
ok Uni.new(0xAD44).NFKD.list ~~ (0x1100, 0x116C, 0x11B7,), 'AD44 -> 1100 116C 11B7';
ok Uni.new(0xAD45).NFKD.list ~~ (0x1100, 0x116C, 0x11B8,), 'AD45 -> 1100 116C 11B8';
ok Uni.new(0xAD46).NFKD.list ~~ (0x1100, 0x116C, 0x11B9,), 'AD46 -> 1100 116C 11B9';
ok Uni.new(0xAD47).NFKD.list ~~ (0x1100, 0x116C, 0x11BA,), 'AD47 -> 1100 116C 11BA';
ok Uni.new(0xAD48).NFKD.list ~~ (0x1100, 0x116C, 0x11BB,), 'AD48 -> 1100 116C 11BB';
ok Uni.new(0xAD49).NFKD.list ~~ (0x1100, 0x116C, 0x11BC,), 'AD49 -> 1100 116C 11BC';
ok Uni.new(0xAD4A).NFKD.list ~~ (0x1100, 0x116C, 0x11BD,), 'AD4A -> 1100 116C 11BD';
ok Uni.new(0xAD4B).NFKD.list ~~ (0x1100, 0x116C, 0x11BE,), 'AD4B -> 1100 116C 11BE';
ok Uni.new(0xAD4C).NFKD.list ~~ (0x1100, 0x116C, 0x11BF,), 'AD4C -> 1100 116C 11BF';
ok Uni.new(0xAD4D).NFKD.list ~~ (0x1100, 0x116C, 0x11C0,), 'AD4D -> 1100 116C 11C0';
ok Uni.new(0xAD4E).NFKD.list ~~ (0x1100, 0x116C, 0x11C1,), 'AD4E -> 1100 116C 11C1';
ok Uni.new(0xAD4F).NFKD.list ~~ (0x1100, 0x116C, 0x11C2,), 'AD4F -> 1100 116C 11C2';
ok Uni.new(0xAD50).NFKD.list ~~ (0x1100, 0x116D,), 'AD50 -> 1100 116D';
ok Uni.new(0xAD51).NFKD.list ~~ (0x1100, 0x116D, 0x11A8,), 'AD51 -> 1100 116D 11A8';
ok Uni.new(0xAD52).NFKD.list ~~ (0x1100, 0x116D, 0x11A9,), 'AD52 -> 1100 116D 11A9';
ok Uni.new(0xAD53).NFKD.list ~~ (0x1100, 0x116D, 0x11AA,), 'AD53 -> 1100 116D 11AA';
ok Uni.new(0xAD54).NFKD.list ~~ (0x1100, 0x116D, 0x11AB,), 'AD54 -> 1100 116D 11AB';
ok Uni.new(0xAD55).NFKD.list ~~ (0x1100, 0x116D, 0x11AC,), 'AD55 -> 1100 116D 11AC';
ok Uni.new(0xAD56).NFKD.list ~~ (0x1100, 0x116D, 0x11AD,), 'AD56 -> 1100 116D 11AD';
ok Uni.new(0xAD57).NFKD.list ~~ (0x1100, 0x116D, 0x11AE,), 'AD57 -> 1100 116D 11AE';
ok Uni.new(0xAD58).NFKD.list ~~ (0x1100, 0x116D, 0x11AF,), 'AD58 -> 1100 116D 11AF';
ok Uni.new(0xAD59).NFKD.list ~~ (0x1100, 0x116D, 0x11B0,), 'AD59 -> 1100 116D 11B0';
ok Uni.new(0xAD5A).NFKD.list ~~ (0x1100, 0x116D, 0x11B1,), 'AD5A -> 1100 116D 11B1';
ok Uni.new(0xAD5B).NFKD.list ~~ (0x1100, 0x116D, 0x11B2,), 'AD5B -> 1100 116D 11B2';
ok Uni.new(0xAD5C).NFKD.list ~~ (0x1100, 0x116D, 0x11B3,), 'AD5C -> 1100 116D 11B3';
ok Uni.new(0xAD5D).NFKD.list ~~ (0x1100, 0x116D, 0x11B4,), 'AD5D -> 1100 116D 11B4';
ok Uni.new(0xAD5E).NFKD.list ~~ (0x1100, 0x116D, 0x11B5,), 'AD5E -> 1100 116D 11B5';
ok Uni.new(0xAD5F).NFKD.list ~~ (0x1100, 0x116D, 0x11B6,), 'AD5F -> 1100 116D 11B6';
ok Uni.new(0xAD60).NFKD.list ~~ (0x1100, 0x116D, 0x11B7,), 'AD60 -> 1100 116D 11B7';
ok Uni.new(0xAD61).NFKD.list ~~ (0x1100, 0x116D, 0x11B8,), 'AD61 -> 1100 116D 11B8';
ok Uni.new(0xAD62).NFKD.list ~~ (0x1100, 0x116D, 0x11B9,), 'AD62 -> 1100 116D 11B9';
ok Uni.new(0xAD63).NFKD.list ~~ (0x1100, 0x116D, 0x11BA,), 'AD63 -> 1100 116D 11BA';
ok Uni.new(0xAD64).NFKD.list ~~ (0x1100, 0x116D, 0x11BB,), 'AD64 -> 1100 116D 11BB';
ok Uni.new(0xAD65).NFKD.list ~~ (0x1100, 0x116D, 0x11BC,), 'AD65 -> 1100 116D 11BC';
ok Uni.new(0xAD66).NFKD.list ~~ (0x1100, 0x116D, 0x11BD,), 'AD66 -> 1100 116D 11BD';
ok Uni.new(0xAD67).NFKD.list ~~ (0x1100, 0x116D, 0x11BE,), 'AD67 -> 1100 116D 11BE';
ok Uni.new(0xAD68).NFKD.list ~~ (0x1100, 0x116D, 0x11BF,), 'AD68 -> 1100 116D 11BF';
ok Uni.new(0xAD69).NFKD.list ~~ (0x1100, 0x116D, 0x11C0,), 'AD69 -> 1100 116D 11C0';
ok Uni.new(0xAD6A).NFKD.list ~~ (0x1100, 0x116D, 0x11C1,), 'AD6A -> 1100 116D 11C1';
ok Uni.new(0xAD6B).NFKD.list ~~ (0x1100, 0x116D, 0x11C2,), 'AD6B -> 1100 116D 11C2';
ok Uni.new(0xAD6C).NFKD.list ~~ (0x1100, 0x116E,), 'AD6C -> 1100 116E';
ok Uni.new(0xAD6D).NFKD.list ~~ (0x1100, 0x116E, 0x11A8,), 'AD6D -> 1100 116E 11A8';
ok Uni.new(0xAD6E).NFKD.list ~~ (0x1100, 0x116E, 0x11A9,), 'AD6E -> 1100 116E 11A9';
ok Uni.new(0xAD6F).NFKD.list ~~ (0x1100, 0x116E, 0x11AA,), 'AD6F -> 1100 116E 11AA';
ok Uni.new(0xAD70).NFKD.list ~~ (0x1100, 0x116E, 0x11AB,), 'AD70 -> 1100 116E 11AB';
ok Uni.new(0xAD71).NFKD.list ~~ (0x1100, 0x116E, 0x11AC,), 'AD71 -> 1100 116E 11AC';
ok Uni.new(0xAD72).NFKD.list ~~ (0x1100, 0x116E, 0x11AD,), 'AD72 -> 1100 116E 11AD';
ok Uni.new(0xAD73).NFKD.list ~~ (0x1100, 0x116E, 0x11AE,), 'AD73 -> 1100 116E 11AE';
ok Uni.new(0xAD74).NFKD.list ~~ (0x1100, 0x116E, 0x11AF,), 'AD74 -> 1100 116E 11AF';
ok Uni.new(0xAD75).NFKD.list ~~ (0x1100, 0x116E, 0x11B0,), 'AD75 -> 1100 116E 11B0';
ok Uni.new(0xAD76).NFKD.list ~~ (0x1100, 0x116E, 0x11B1,), 'AD76 -> 1100 116E 11B1';
ok Uni.new(0xAD77).NFKD.list ~~ (0x1100, 0x116E, 0x11B2,), 'AD77 -> 1100 116E 11B2';
ok Uni.new(0xAD78).NFKD.list ~~ (0x1100, 0x116E, 0x11B3,), 'AD78 -> 1100 116E 11B3';
ok Uni.new(0xAD79).NFKD.list ~~ (0x1100, 0x116E, 0x11B4,), 'AD79 -> 1100 116E 11B4';
ok Uni.new(0xAD7A).NFKD.list ~~ (0x1100, 0x116E, 0x11B5,), 'AD7A -> 1100 116E 11B5';
ok Uni.new(0xAD7B).NFKD.list ~~ (0x1100, 0x116E, 0x11B6,), 'AD7B -> 1100 116E 11B6';
ok Uni.new(0xAD7C).NFKD.list ~~ (0x1100, 0x116E, 0x11B7,), 'AD7C -> 1100 116E 11B7';
ok Uni.new(0xAD7D).NFKD.list ~~ (0x1100, 0x116E, 0x11B8,), 'AD7D -> 1100 116E 11B8';
ok Uni.new(0xAD7E).NFKD.list ~~ (0x1100, 0x116E, 0x11B9,), 'AD7E -> 1100 116E 11B9';
ok Uni.new(0xAD7F).NFKD.list ~~ (0x1100, 0x116E, 0x11BA,), 'AD7F -> 1100 116E 11BA';
ok Uni.new(0xAD80).NFKD.list ~~ (0x1100, 0x116E, 0x11BB,), 'AD80 -> 1100 116E 11BB';
ok Uni.new(0xAD81).NFKD.list ~~ (0x1100, 0x116E, 0x11BC,), 'AD81 -> 1100 116E 11BC';
ok Uni.new(0xAD82).NFKD.list ~~ (0x1100, 0x116E, 0x11BD,), 'AD82 -> 1100 116E 11BD';
ok Uni.new(0xAD83).NFKD.list ~~ (0x1100, 0x116E, 0x11BE,), 'AD83 -> 1100 116E 11BE';
ok Uni.new(0xAD84).NFKD.list ~~ (0x1100, 0x116E, 0x11BF,), 'AD84 -> 1100 116E 11BF';
ok Uni.new(0xAD85).NFKD.list ~~ (0x1100, 0x116E, 0x11C0,), 'AD85 -> 1100 116E 11C0';
ok Uni.new(0xAD86).NFKD.list ~~ (0x1100, 0x116E, 0x11C1,), 'AD86 -> 1100 116E 11C1';
ok Uni.new(0xAD87).NFKD.list ~~ (0x1100, 0x116E, 0x11C2,), 'AD87 -> 1100 116E 11C2';
ok Uni.new(0xAD88).NFKD.list ~~ (0x1100, 0x116F,), 'AD88 -> 1100 116F';
ok Uni.new(0xAD89).NFKD.list ~~ (0x1100, 0x116F, 0x11A8,), 'AD89 -> 1100 116F 11A8';
ok Uni.new(0xAD8A).NFKD.list ~~ (0x1100, 0x116F, 0x11A9,), 'AD8A -> 1100 116F 11A9';
ok Uni.new(0xAD8B).NFKD.list ~~ (0x1100, 0x116F, 0x11AA,), 'AD8B -> 1100 116F 11AA';
ok Uni.new(0xAD8C).NFKD.list ~~ (0x1100, 0x116F, 0x11AB,), 'AD8C -> 1100 116F 11AB';
ok Uni.new(0xAD8D).NFKD.list ~~ (0x1100, 0x116F, 0x11AC,), 'AD8D -> 1100 116F 11AC';
ok Uni.new(0xAD8E).NFKD.list ~~ (0x1100, 0x116F, 0x11AD,), 'AD8E -> 1100 116F 11AD';
ok Uni.new(0xAD8F).NFKD.list ~~ (0x1100, 0x116F, 0x11AE,), 'AD8F -> 1100 116F 11AE';
ok Uni.new(0xAD90).NFKD.list ~~ (0x1100, 0x116F, 0x11AF,), 'AD90 -> 1100 116F 11AF';
ok Uni.new(0xAD91).NFKD.list ~~ (0x1100, 0x116F, 0x11B0,), 'AD91 -> 1100 116F 11B0';
ok Uni.new(0xAD92).NFKD.list ~~ (0x1100, 0x116F, 0x11B1,), 'AD92 -> 1100 116F 11B1';
ok Uni.new(0xAD93).NFKD.list ~~ (0x1100, 0x116F, 0x11B2,), 'AD93 -> 1100 116F 11B2';
ok Uni.new(0xAD94).NFKD.list ~~ (0x1100, 0x116F, 0x11B3,), 'AD94 -> 1100 116F 11B3';
ok Uni.new(0xAD95).NFKD.list ~~ (0x1100, 0x116F, 0x11B4,), 'AD95 -> 1100 116F 11B4';
ok Uni.new(0xAD96).NFKD.list ~~ (0x1100, 0x116F, 0x11B5,), 'AD96 -> 1100 116F 11B5';
ok Uni.new(0xAD97).NFKD.list ~~ (0x1100, 0x116F, 0x11B6,), 'AD97 -> 1100 116F 11B6';
ok Uni.new(0xAD98).NFKD.list ~~ (0x1100, 0x116F, 0x11B7,), 'AD98 -> 1100 116F 11B7';
ok Uni.new(0xAD99).NFKD.list ~~ (0x1100, 0x116F, 0x11B8,), 'AD99 -> 1100 116F 11B8';
ok Uni.new(0xAD9A).NFKD.list ~~ (0x1100, 0x116F, 0x11B9,), 'AD9A -> 1100 116F 11B9';
ok Uni.new(0xAD9B).NFKD.list ~~ (0x1100, 0x116F, 0x11BA,), 'AD9B -> 1100 116F 11BA';
ok Uni.new(0xAD9C).NFKD.list ~~ (0x1100, 0x116F, 0x11BB,), 'AD9C -> 1100 116F 11BB';
ok Uni.new(0xAD9D).NFKD.list ~~ (0x1100, 0x116F, 0x11BC,), 'AD9D -> 1100 116F 11BC';
ok Uni.new(0xAD9E).NFKD.list ~~ (0x1100, 0x116F, 0x11BD,), 'AD9E -> 1100 116F 11BD';
ok Uni.new(0xAD9F).NFKD.list ~~ (0x1100, 0x116F, 0x11BE,), 'AD9F -> 1100 116F 11BE';
ok Uni.new(0xADA0).NFKD.list ~~ (0x1100, 0x116F, 0x11BF,), 'ADA0 -> 1100 116F 11BF';
ok Uni.new(0xADA1).NFKD.list ~~ (0x1100, 0x116F, 0x11C0,), 'ADA1 -> 1100 116F 11C0';
ok Uni.new(0xADA2).NFKD.list ~~ (0x1100, 0x116F, 0x11C1,), 'ADA2 -> 1100 116F 11C1';
ok Uni.new(0xADA3).NFKD.list ~~ (0x1100, 0x116F, 0x11C2,), 'ADA3 -> 1100 116F 11C2';
ok Uni.new(0xADA4).NFKD.list ~~ (0x1100, 0x1170,), 'ADA4 -> 1100 1170';
ok Uni.new(0xADA5).NFKD.list ~~ (0x1100, 0x1170, 0x11A8,), 'ADA5 -> 1100 1170 11A8';
ok Uni.new(0xADA6).NFKD.list ~~ (0x1100, 0x1170, 0x11A9,), 'ADA6 -> 1100 1170 11A9';
ok Uni.new(0xADA7).NFKD.list ~~ (0x1100, 0x1170, 0x11AA,), 'ADA7 -> 1100 1170 11AA';
ok Uni.new(0xADA8).NFKD.list ~~ (0x1100, 0x1170, 0x11AB,), 'ADA8 -> 1100 1170 11AB';
ok Uni.new(0xADA9).NFKD.list ~~ (0x1100, 0x1170, 0x11AC,), 'ADA9 -> 1100 1170 11AC';
ok Uni.new(0xADAA).NFKD.list ~~ (0x1100, 0x1170, 0x11AD,), 'ADAA -> 1100 1170 11AD';
ok Uni.new(0xADAB).NFKD.list ~~ (0x1100, 0x1170, 0x11AE,), 'ADAB -> 1100 1170 11AE';
ok Uni.new(0xADAC).NFKD.list ~~ (0x1100, 0x1170, 0x11AF,), 'ADAC -> 1100 1170 11AF';
ok Uni.new(0xADAD).NFKD.list ~~ (0x1100, 0x1170, 0x11B0,), 'ADAD -> 1100 1170 11B0';
ok Uni.new(0xADAE).NFKD.list ~~ (0x1100, 0x1170, 0x11B1,), 'ADAE -> 1100 1170 11B1';
ok Uni.new(0xADAF).NFKD.list ~~ (0x1100, 0x1170, 0x11B2,), 'ADAF -> 1100 1170 11B2';
ok Uni.new(0xADB0).NFKD.list ~~ (0x1100, 0x1170, 0x11B3,), 'ADB0 -> 1100 1170 11B3';
ok Uni.new(0xADB1).NFKD.list ~~ (0x1100, 0x1170, 0x11B4,), 'ADB1 -> 1100 1170 11B4';
ok Uni.new(0xADB2).NFKD.list ~~ (0x1100, 0x1170, 0x11B5,), 'ADB2 -> 1100 1170 11B5';
ok Uni.new(0xADB3).NFKD.list ~~ (0x1100, 0x1170, 0x11B6,), 'ADB3 -> 1100 1170 11B6';
ok Uni.new(0xADB4).NFKD.list ~~ (0x1100, 0x1170, 0x11B7,), 'ADB4 -> 1100 1170 11B7';
ok Uni.new(0xADB5).NFKD.list ~~ (0x1100, 0x1170, 0x11B8,), 'ADB5 -> 1100 1170 11B8';
ok Uni.new(0xADB6).NFKD.list ~~ (0x1100, 0x1170, 0x11B9,), 'ADB6 -> 1100 1170 11B9';
ok Uni.new(0xADB7).NFKD.list ~~ (0x1100, 0x1170, 0x11BA,), 'ADB7 -> 1100 1170 11BA';
ok Uni.new(0xADB8).NFKD.list ~~ (0x1100, 0x1170, 0x11BB,), 'ADB8 -> 1100 1170 11BB';
ok Uni.new(0xADB9).NFKD.list ~~ (0x1100, 0x1170, 0x11BC,), 'ADB9 -> 1100 1170 11BC';
ok Uni.new(0xADBA).NFKD.list ~~ (0x1100, 0x1170, 0x11BD,), 'ADBA -> 1100 1170 11BD';
ok Uni.new(0xADBB).NFKD.list ~~ (0x1100, 0x1170, 0x11BE,), 'ADBB -> 1100 1170 11BE';
ok Uni.new(0xADBC).NFKD.list ~~ (0x1100, 0x1170, 0x11BF,), 'ADBC -> 1100 1170 11BF';
ok Uni.new(0xADBD).NFKD.list ~~ (0x1100, 0x1170, 0x11C0,), 'ADBD -> 1100 1170 11C0';
ok Uni.new(0xADBE).NFKD.list ~~ (0x1100, 0x1170, 0x11C1,), 'ADBE -> 1100 1170 11C1';
ok Uni.new(0xADBF).NFKD.list ~~ (0x1100, 0x1170, 0x11C2,), 'ADBF -> 1100 1170 11C2';
ok Uni.new(0xADC0).NFKD.list ~~ (0x1100, 0x1171,), 'ADC0 -> 1100 1171';
ok Uni.new(0xADC1).NFKD.list ~~ (0x1100, 0x1171, 0x11A8,), 'ADC1 -> 1100 1171 11A8';
ok Uni.new(0xADC2).NFKD.list ~~ (0x1100, 0x1171, 0x11A9,), 'ADC2 -> 1100 1171 11A9';
ok Uni.new(0xADC3).NFKD.list ~~ (0x1100, 0x1171, 0x11AA,), 'ADC3 -> 1100 1171 11AA';
ok Uni.new(0xADC4).NFKD.list ~~ (0x1100, 0x1171, 0x11AB,), 'ADC4 -> 1100 1171 11AB';
ok Uni.new(0xADC5).NFKD.list ~~ (0x1100, 0x1171, 0x11AC,), 'ADC5 -> 1100 1171 11AC';
ok Uni.new(0xADC6).NFKD.list ~~ (0x1100, 0x1171, 0x11AD,), 'ADC6 -> 1100 1171 11AD';
ok Uni.new(0xADC7).NFKD.list ~~ (0x1100, 0x1171, 0x11AE,), 'ADC7 -> 1100 1171 11AE';
ok Uni.new(0xADC8).NFKD.list ~~ (0x1100, 0x1171, 0x11AF,), 'ADC8 -> 1100 1171 11AF';
ok Uni.new(0xADC9).NFKD.list ~~ (0x1100, 0x1171, 0x11B0,), 'ADC9 -> 1100 1171 11B0';
ok Uni.new(0xADCA).NFKD.list ~~ (0x1100, 0x1171, 0x11B1,), 'ADCA -> 1100 1171 11B1';
ok Uni.new(0xADCB).NFKD.list ~~ (0x1100, 0x1171, 0x11B2,), 'ADCB -> 1100 1171 11B2';
ok Uni.new(0xADCC).NFKD.list ~~ (0x1100, 0x1171, 0x11B3,), 'ADCC -> 1100 1171 11B3';
ok Uni.new(0xADCD).NFKD.list ~~ (0x1100, 0x1171, 0x11B4,), 'ADCD -> 1100 1171 11B4';
ok Uni.new(0xADCE).NFKD.list ~~ (0x1100, 0x1171, 0x11B5,), 'ADCE -> 1100 1171 11B5';
ok Uni.new(0xADCF).NFKD.list ~~ (0x1100, 0x1171, 0x11B6,), 'ADCF -> 1100 1171 11B6';
ok Uni.new(0xADD0).NFKD.list ~~ (0x1100, 0x1171, 0x11B7,), 'ADD0 -> 1100 1171 11B7';
ok Uni.new(0xADD1).NFKD.list ~~ (0x1100, 0x1171, 0x11B8,), 'ADD1 -> 1100 1171 11B8';
ok Uni.new(0xADD2).NFKD.list ~~ (0x1100, 0x1171, 0x11B9,), 'ADD2 -> 1100 1171 11B9';
ok Uni.new(0xADD3).NFKD.list ~~ (0x1100, 0x1171, 0x11BA,), 'ADD3 -> 1100 1171 11BA';
ok Uni.new(0xADD4).NFKD.list ~~ (0x1100, 0x1171, 0x11BB,), 'ADD4 -> 1100 1171 11BB';
ok Uni.new(0xADD5).NFKD.list ~~ (0x1100, 0x1171, 0x11BC,), 'ADD5 -> 1100 1171 11BC';
ok Uni.new(0xADD6).NFKD.list ~~ (0x1100, 0x1171, 0x11BD,), 'ADD6 -> 1100 1171 11BD';
ok Uni.new(0xADD7).NFKD.list ~~ (0x1100, 0x1171, 0x11BE,), 'ADD7 -> 1100 1171 11BE';
ok Uni.new(0xADD8).NFKD.list ~~ (0x1100, 0x1171, 0x11BF,), 'ADD8 -> 1100 1171 11BF';
ok Uni.new(0xADD9).NFKD.list ~~ (0x1100, 0x1171, 0x11C0,), 'ADD9 -> 1100 1171 11C0';
ok Uni.new(0xADDA).NFKD.list ~~ (0x1100, 0x1171, 0x11C1,), 'ADDA -> 1100 1171 11C1';
ok Uni.new(0xADDB).NFKD.list ~~ (0x1100, 0x1171, 0x11C2,), 'ADDB -> 1100 1171 11C2';
ok Uni.new(0xADDC).NFKD.list ~~ (0x1100, 0x1172,), 'ADDC -> 1100 1172';
ok Uni.new(0xADDD).NFKD.list ~~ (0x1100, 0x1172, 0x11A8,), 'ADDD -> 1100 1172 11A8';
ok Uni.new(0xADDE).NFKD.list ~~ (0x1100, 0x1172, 0x11A9,), 'ADDE -> 1100 1172 11A9';
ok Uni.new(0xADDF).NFKD.list ~~ (0x1100, 0x1172, 0x11AA,), 'ADDF -> 1100 1172 11AA';
ok Uni.new(0xADE0).NFKD.list ~~ (0x1100, 0x1172, 0x11AB,), 'ADE0 -> 1100 1172 11AB';
ok Uni.new(0xADE1).NFKD.list ~~ (0x1100, 0x1172, 0x11AC,), 'ADE1 -> 1100 1172 11AC';
ok Uni.new(0xADE2).NFKD.list ~~ (0x1100, 0x1172, 0x11AD,), 'ADE2 -> 1100 1172 11AD';
ok Uni.new(0xADE3).NFKD.list ~~ (0x1100, 0x1172, 0x11AE,), 'ADE3 -> 1100 1172 11AE';
ok Uni.new(0xADE4).NFKD.list ~~ (0x1100, 0x1172, 0x11AF,), 'ADE4 -> 1100 1172 11AF';
ok Uni.new(0xADE5).NFKD.list ~~ (0x1100, 0x1172, 0x11B0,), 'ADE5 -> 1100 1172 11B0';
ok Uni.new(0xADE6).NFKD.list ~~ (0x1100, 0x1172, 0x11B1,), 'ADE6 -> 1100 1172 11B1';
ok Uni.new(0xADE7).NFKD.list ~~ (0x1100, 0x1172, 0x11B2,), 'ADE7 -> 1100 1172 11B2';
ok Uni.new(0xADE8).NFKD.list ~~ (0x1100, 0x1172, 0x11B3,), 'ADE8 -> 1100 1172 11B3';
ok Uni.new(0xADE9).NFKD.list ~~ (0x1100, 0x1172, 0x11B4,), 'ADE9 -> 1100 1172 11B4';
ok Uni.new(0xADEA).NFKD.list ~~ (0x1100, 0x1172, 0x11B5,), 'ADEA -> 1100 1172 11B5';
ok Uni.new(0xADEB).NFKD.list ~~ (0x1100, 0x1172, 0x11B6,), 'ADEB -> 1100 1172 11B6';
ok Uni.new(0xADEC).NFKD.list ~~ (0x1100, 0x1172, 0x11B7,), 'ADEC -> 1100 1172 11B7';
ok Uni.new(0xADED).NFKD.list ~~ (0x1100, 0x1172, 0x11B8,), 'ADED -> 1100 1172 11B8';
ok Uni.new(0xADEE).NFKD.list ~~ (0x1100, 0x1172, 0x11B9,), 'ADEE -> 1100 1172 11B9';
ok Uni.new(0xADEF).NFKD.list ~~ (0x1100, 0x1172, 0x11BA,), 'ADEF -> 1100 1172 11BA';
ok Uni.new(0xADF0).NFKD.list ~~ (0x1100, 0x1172, 0x11BB,), 'ADF0 -> 1100 1172 11BB';
ok Uni.new(0xADF1).NFKD.list ~~ (0x1100, 0x1172, 0x11BC,), 'ADF1 -> 1100 1172 11BC';
ok Uni.new(0xADF2).NFKD.list ~~ (0x1100, 0x1172, 0x11BD,), 'ADF2 -> 1100 1172 11BD';
ok Uni.new(0xADF3).NFKD.list ~~ (0x1100, 0x1172, 0x11BE,), 'ADF3 -> 1100 1172 11BE';
ok Uni.new(0xADF4).NFKD.list ~~ (0x1100, 0x1172, 0x11BF,), 'ADF4 -> 1100 1172 11BF';
ok Uni.new(0xADF5).NFKD.list ~~ (0x1100, 0x1172, 0x11C0,), 'ADF5 -> 1100 1172 11C0';
ok Uni.new(0xADF6).NFKD.list ~~ (0x1100, 0x1172, 0x11C1,), 'ADF6 -> 1100 1172 11C1';
ok Uni.new(0xADF7).NFKD.list ~~ (0x1100, 0x1172, 0x11C2,), 'ADF7 -> 1100 1172 11C2';
ok Uni.new(0xADF8).NFKD.list ~~ (0x1100, 0x1173,), 'ADF8 -> 1100 1173';
ok Uni.new(0xADF9).NFKD.list ~~ (0x1100, 0x1173, 0x11A8,), 'ADF9 -> 1100 1173 11A8';
ok Uni.new(0xADFA).NFKD.list ~~ (0x1100, 0x1173, 0x11A9,), 'ADFA -> 1100 1173 11A9';
ok Uni.new(0xADFB).NFKD.list ~~ (0x1100, 0x1173, 0x11AA,), 'ADFB -> 1100 1173 11AA';
ok Uni.new(0xADFC).NFKD.list ~~ (0x1100, 0x1173, 0x11AB,), 'ADFC -> 1100 1173 11AB';
ok Uni.new(0xADFD).NFKD.list ~~ (0x1100, 0x1173, 0x11AC,), 'ADFD -> 1100 1173 11AC';
ok Uni.new(0xADFE).NFKD.list ~~ (0x1100, 0x1173, 0x11AD,), 'ADFE -> 1100 1173 11AD';
ok Uni.new(0xADFF).NFKD.list ~~ (0x1100, 0x1173, 0x11AE,), 'ADFF -> 1100 1173 11AE';
ok Uni.new(0xAE00).NFKD.list ~~ (0x1100, 0x1173, 0x11AF,), 'AE00 -> 1100 1173 11AF';
ok Uni.new(0xAE01).NFKD.list ~~ (0x1100, 0x1173, 0x11B0,), 'AE01 -> 1100 1173 11B0';
ok Uni.new(0xAE02).NFKD.list ~~ (0x1100, 0x1173, 0x11B1,), 'AE02 -> 1100 1173 11B1';
ok Uni.new(0xAE03).NFKD.list ~~ (0x1100, 0x1173, 0x11B2,), 'AE03 -> 1100 1173 11B2';
ok Uni.new(0xAE04).NFKD.list ~~ (0x1100, 0x1173, 0x11B3,), 'AE04 -> 1100 1173 11B3';
ok Uni.new(0xAE05).NFKD.list ~~ (0x1100, 0x1173, 0x11B4,), 'AE05 -> 1100 1173 11B4';
ok Uni.new(0xAE06).NFKD.list ~~ (0x1100, 0x1173, 0x11B5,), 'AE06 -> 1100 1173 11B5';
ok Uni.new(0xAE07).NFKD.list ~~ (0x1100, 0x1173, 0x11B6,), 'AE07 -> 1100 1173 11B6';
ok Uni.new(0xAE08).NFKD.list ~~ (0x1100, 0x1173, 0x11B7,), 'AE08 -> 1100 1173 11B7';
ok Uni.new(0xAE09).NFKD.list ~~ (0x1100, 0x1173, 0x11B8,), 'AE09 -> 1100 1173 11B8';
ok Uni.new(0xAE0A).NFKD.list ~~ (0x1100, 0x1173, 0x11B9,), 'AE0A -> 1100 1173 11B9';
ok Uni.new(0xAE0B).NFKD.list ~~ (0x1100, 0x1173, 0x11BA,), 'AE0B -> 1100 1173 11BA';
ok Uni.new(0xAE0C).NFKD.list ~~ (0x1100, 0x1173, 0x11BB,), 'AE0C -> 1100 1173 11BB';
ok Uni.new(0xAE0D).NFKD.list ~~ (0x1100, 0x1173, 0x11BC,), 'AE0D -> 1100 1173 11BC';
ok Uni.new(0xAE0E).NFKD.list ~~ (0x1100, 0x1173, 0x11BD,), 'AE0E -> 1100 1173 11BD';
ok Uni.new(0xAE0F).NFKD.list ~~ (0x1100, 0x1173, 0x11BE,), 'AE0F -> 1100 1173 11BE';
ok Uni.new(0xAE10).NFKD.list ~~ (0x1100, 0x1173, 0x11BF,), 'AE10 -> 1100 1173 11BF';
ok Uni.new(0xAE11).NFKD.list ~~ (0x1100, 0x1173, 0x11C0,), 'AE11 -> 1100 1173 11C0';
ok Uni.new(0xAE12).NFKD.list ~~ (0x1100, 0x1173, 0x11C1,), 'AE12 -> 1100 1173 11C1';
ok Uni.new(0xAE13).NFKD.list ~~ (0x1100, 0x1173, 0x11C2,), 'AE13 -> 1100 1173 11C2';
ok Uni.new(0xAE14).NFKD.list ~~ (0x1100, 0x1174,), 'AE14 -> 1100 1174';
ok Uni.new(0xAE15).NFKD.list ~~ (0x1100, 0x1174, 0x11A8,), 'AE15 -> 1100 1174 11A8';
ok Uni.new(0xAE16).NFKD.list ~~ (0x1100, 0x1174, 0x11A9,), 'AE16 -> 1100 1174 11A9';
ok Uni.new(0xAE17).NFKD.list ~~ (0x1100, 0x1174, 0x11AA,), 'AE17 -> 1100 1174 11AA';
ok Uni.new(0xAE18).NFKD.list ~~ (0x1100, 0x1174, 0x11AB,), 'AE18 -> 1100 1174 11AB';
ok Uni.new(0xAE19).NFKD.list ~~ (0x1100, 0x1174, 0x11AC,), 'AE19 -> 1100 1174 11AC';
ok Uni.new(0xAE1A).NFKD.list ~~ (0x1100, 0x1174, 0x11AD,), 'AE1A -> 1100 1174 11AD';
ok Uni.new(0xAE1B).NFKD.list ~~ (0x1100, 0x1174, 0x11AE,), 'AE1B -> 1100 1174 11AE';
ok Uni.new(0xAE1C).NFKD.list ~~ (0x1100, 0x1174, 0x11AF,), 'AE1C -> 1100 1174 11AF';
ok Uni.new(0xAE1D).NFKD.list ~~ (0x1100, 0x1174, 0x11B0,), 'AE1D -> 1100 1174 11B0';
ok Uni.new(0xAE1E).NFKD.list ~~ (0x1100, 0x1174, 0x11B1,), 'AE1E -> 1100 1174 11B1';
ok Uni.new(0xAE1F).NFKD.list ~~ (0x1100, 0x1174, 0x11B2,), 'AE1F -> 1100 1174 11B2';
ok Uni.new(0xAE20).NFKD.list ~~ (0x1100, 0x1174, 0x11B3,), 'AE20 -> 1100 1174 11B3';
ok Uni.new(0xAE21).NFKD.list ~~ (0x1100, 0x1174, 0x11B4,), 'AE21 -> 1100 1174 11B4';
ok Uni.new(0xAE22).NFKD.list ~~ (0x1100, 0x1174, 0x11B5,), 'AE22 -> 1100 1174 11B5';
ok Uni.new(0xAE23).NFKD.list ~~ (0x1100, 0x1174, 0x11B6,), 'AE23 -> 1100 1174 11B6';
ok Uni.new(0xAE24).NFKD.list ~~ (0x1100, 0x1174, 0x11B7,), 'AE24 -> 1100 1174 11B7';
ok Uni.new(0xAE25).NFKD.list ~~ (0x1100, 0x1174, 0x11B8,), 'AE25 -> 1100 1174 11B8';
ok Uni.new(0xAE26).NFKD.list ~~ (0x1100, 0x1174, 0x11B9,), 'AE26 -> 1100 1174 11B9';
ok Uni.new(0xAE27).NFKD.list ~~ (0x1100, 0x1174, 0x11BA,), 'AE27 -> 1100 1174 11BA';
ok Uni.new(0xAE28).NFKD.list ~~ (0x1100, 0x1174, 0x11BB,), 'AE28 -> 1100 1174 11BB';
ok Uni.new(0xAE29).NFKD.list ~~ (0x1100, 0x1174, 0x11BC,), 'AE29 -> 1100 1174 11BC';
ok Uni.new(0xAE2A).NFKD.list ~~ (0x1100, 0x1174, 0x11BD,), 'AE2A -> 1100 1174 11BD';
ok Uni.new(0xAE2B).NFKD.list ~~ (0x1100, 0x1174, 0x11BE,), 'AE2B -> 1100 1174 11BE';
ok Uni.new(0xAE2C).NFKD.list ~~ (0x1100, 0x1174, 0x11BF,), 'AE2C -> 1100 1174 11BF';
ok Uni.new(0xAE2D).NFKD.list ~~ (0x1100, 0x1174, 0x11C0,), 'AE2D -> 1100 1174 11C0';
ok Uni.new(0xAE2E).NFKD.list ~~ (0x1100, 0x1174, 0x11C1,), 'AE2E -> 1100 1174 11C1';
ok Uni.new(0xAE2F).NFKD.list ~~ (0x1100, 0x1174, 0x11C2,), 'AE2F -> 1100 1174 11C2';
ok Uni.new(0xAE30).NFKD.list ~~ (0x1100, 0x1175,), 'AE30 -> 1100 1175';
ok Uni.new(0xAE31).NFKD.list ~~ (0x1100, 0x1175, 0x11A8,), 'AE31 -> 1100 1175 11A8';
ok Uni.new(0xAE32).NFKD.list ~~ (0x1100, 0x1175, 0x11A9,), 'AE32 -> 1100 1175 11A9';
ok Uni.new(0xAE33).NFKD.list ~~ (0x1100, 0x1175, 0x11AA,), 'AE33 -> 1100 1175 11AA';
ok Uni.new(0xAE34).NFKD.list ~~ (0x1100, 0x1175, 0x11AB,), 'AE34 -> 1100 1175 11AB';
ok Uni.new(0xAE35).NFKD.list ~~ (0x1100, 0x1175, 0x11AC,), 'AE35 -> 1100 1175 11AC';
ok Uni.new(0xAE36).NFKD.list ~~ (0x1100, 0x1175, 0x11AD,), 'AE36 -> 1100 1175 11AD';
ok Uni.new(0xAE37).NFKD.list ~~ (0x1100, 0x1175, 0x11AE,), 'AE37 -> 1100 1175 11AE';
ok Uni.new(0xAE38).NFKD.list ~~ (0x1100, 0x1175, 0x11AF,), 'AE38 -> 1100 1175 11AF';
ok Uni.new(0xAE39).NFKD.list ~~ (0x1100, 0x1175, 0x11B0,), 'AE39 -> 1100 1175 11B0';
ok Uni.new(0xAE3A).NFKD.list ~~ (0x1100, 0x1175, 0x11B1,), 'AE3A -> 1100 1175 11B1';
ok Uni.new(0xAE3B).NFKD.list ~~ (0x1100, 0x1175, 0x11B2,), 'AE3B -> 1100 1175 11B2';
ok Uni.new(0xAE3C).NFKD.list ~~ (0x1100, 0x1175, 0x11B3,), 'AE3C -> 1100 1175 11B3';
ok Uni.new(0xAE3D).NFKD.list ~~ (0x1100, 0x1175, 0x11B4,), 'AE3D -> 1100 1175 11B4';
ok Uni.new(0xAE3E).NFKD.list ~~ (0x1100, 0x1175, 0x11B5,), 'AE3E -> 1100 1175 11B5';
ok Uni.new(0xAE3F).NFKD.list ~~ (0x1100, 0x1175, 0x11B6,), 'AE3F -> 1100 1175 11B6';
ok Uni.new(0xAE40).NFKD.list ~~ (0x1100, 0x1175, 0x11B7,), 'AE40 -> 1100 1175 11B7';
ok Uni.new(0xAE41).NFKD.list ~~ (0x1100, 0x1175, 0x11B8,), 'AE41 -> 1100 1175 11B8';
ok Uni.new(0xAE42).NFKD.list ~~ (0x1100, 0x1175, 0x11B9,), 'AE42 -> 1100 1175 11B9';
ok Uni.new(0xAE43).NFKD.list ~~ (0x1100, 0x1175, 0x11BA,), 'AE43 -> 1100 1175 11BA';
ok Uni.new(0xAE44).NFKD.list ~~ (0x1100, 0x1175, 0x11BB,), 'AE44 -> 1100 1175 11BB';
ok Uni.new(0xAE45).NFKD.list ~~ (0x1100, 0x1175, 0x11BC,), 'AE45 -> 1100 1175 11BC';
ok Uni.new(0xAE46).NFKD.list ~~ (0x1100, 0x1175, 0x11BD,), 'AE46 -> 1100 1175 11BD';
ok Uni.new(0xAE47).NFKD.list ~~ (0x1100, 0x1175, 0x11BE,), 'AE47 -> 1100 1175 11BE';
ok Uni.new(0xAE48).NFKD.list ~~ (0x1100, 0x1175, 0x11BF,), 'AE48 -> 1100 1175 11BF';
ok Uni.new(0xAE49).NFKD.list ~~ (0x1100, 0x1175, 0x11C0,), 'AE49 -> 1100 1175 11C0';
ok Uni.new(0xAE4A).NFKD.list ~~ (0x1100, 0x1175, 0x11C1,), 'AE4A -> 1100 1175 11C1';
ok Uni.new(0xAE4B).NFKD.list ~~ (0x1100, 0x1175, 0x11C2,), 'AE4B -> 1100 1175 11C2';
ok Uni.new(0xAE4C).NFKD.list ~~ (0x1101, 0x1161,), 'AE4C -> 1101 1161';
ok Uni.new(0xAE4D).NFKD.list ~~ (0x1101, 0x1161, 0x11A8,), 'AE4D -> 1101 1161 11A8';
ok Uni.new(0xAE4E).NFKD.list ~~ (0x1101, 0x1161, 0x11A9,), 'AE4E -> 1101 1161 11A9';
ok Uni.new(0xAE4F).NFKD.list ~~ (0x1101, 0x1161, 0x11AA,), 'AE4F -> 1101 1161 11AA';
ok Uni.new(0xAE50).NFKD.list ~~ (0x1101, 0x1161, 0x11AB,), 'AE50 -> 1101 1161 11AB';
ok Uni.new(0xAE51).NFKD.list ~~ (0x1101, 0x1161, 0x11AC,), 'AE51 -> 1101 1161 11AC';
ok Uni.new(0xAE52).NFKD.list ~~ (0x1101, 0x1161, 0x11AD,), 'AE52 -> 1101 1161 11AD';
ok Uni.new(0xAE53).NFKD.list ~~ (0x1101, 0x1161, 0x11AE,), 'AE53 -> 1101 1161 11AE';
ok Uni.new(0xAE54).NFKD.list ~~ (0x1101, 0x1161, 0x11AF,), 'AE54 -> 1101 1161 11AF';
ok Uni.new(0xAE55).NFKD.list ~~ (0x1101, 0x1161, 0x11B0,), 'AE55 -> 1101 1161 11B0';
ok Uni.new(0xAE56).NFKD.list ~~ (0x1101, 0x1161, 0x11B1,), 'AE56 -> 1101 1161 11B1';
ok Uni.new(0xAE57).NFKD.list ~~ (0x1101, 0x1161, 0x11B2,), 'AE57 -> 1101 1161 11B2';
ok Uni.new(0xAE58).NFKD.list ~~ (0x1101, 0x1161, 0x11B3,), 'AE58 -> 1101 1161 11B3';
ok Uni.new(0xAE59).NFKD.list ~~ (0x1101, 0x1161, 0x11B4,), 'AE59 -> 1101 1161 11B4';
ok Uni.new(0xAE5A).NFKD.list ~~ (0x1101, 0x1161, 0x11B5,), 'AE5A -> 1101 1161 11B5';
ok Uni.new(0xAE5B).NFKD.list ~~ (0x1101, 0x1161, 0x11B6,), 'AE5B -> 1101 1161 11B6';
ok Uni.new(0xAE5C).NFKD.list ~~ (0x1101, 0x1161, 0x11B7,), 'AE5C -> 1101 1161 11B7';
ok Uni.new(0xAE5D).NFKD.list ~~ (0x1101, 0x1161, 0x11B8,), 'AE5D -> 1101 1161 11B8';
ok Uni.new(0xAE5E).NFKD.list ~~ (0x1101, 0x1161, 0x11B9,), 'AE5E -> 1101 1161 11B9';
ok Uni.new(0xAE5F).NFKD.list ~~ (0x1101, 0x1161, 0x11BA,), 'AE5F -> 1101 1161 11BA';
ok Uni.new(0xAE60).NFKD.list ~~ (0x1101, 0x1161, 0x11BB,), 'AE60 -> 1101 1161 11BB';
ok Uni.new(0xAE61).NFKD.list ~~ (0x1101, 0x1161, 0x11BC,), 'AE61 -> 1101 1161 11BC';
ok Uni.new(0xAE62).NFKD.list ~~ (0x1101, 0x1161, 0x11BD,), 'AE62 -> 1101 1161 11BD';
ok Uni.new(0xAE63).NFKD.list ~~ (0x1101, 0x1161, 0x11BE,), 'AE63 -> 1101 1161 11BE';
ok Uni.new(0xAE64).NFKD.list ~~ (0x1101, 0x1161, 0x11BF,), 'AE64 -> 1101 1161 11BF';
ok Uni.new(0xAE65).NFKD.list ~~ (0x1101, 0x1161, 0x11C0,), 'AE65 -> 1101 1161 11C0';
ok Uni.new(0xAE66).NFKD.list ~~ (0x1101, 0x1161, 0x11C1,), 'AE66 -> 1101 1161 11C1';
ok Uni.new(0xAE67).NFKD.list ~~ (0x1101, 0x1161, 0x11C2,), 'AE67 -> 1101 1161 11C2';
ok Uni.new(0xAE68).NFKD.list ~~ (0x1101, 0x1162,), 'AE68 -> 1101 1162';
ok Uni.new(0xAE69).NFKD.list ~~ (0x1101, 0x1162, 0x11A8,), 'AE69 -> 1101 1162 11A8';
ok Uni.new(0xAE6A).NFKD.list ~~ (0x1101, 0x1162, 0x11A9,), 'AE6A -> 1101 1162 11A9';
ok Uni.new(0xAE6B).NFKD.list ~~ (0x1101, 0x1162, 0x11AA,), 'AE6B -> 1101 1162 11AA';
ok Uni.new(0xAE6C).NFKD.list ~~ (0x1101, 0x1162, 0x11AB,), 'AE6C -> 1101 1162 11AB';
ok Uni.new(0xAE6D).NFKD.list ~~ (0x1101, 0x1162, 0x11AC,), 'AE6D -> 1101 1162 11AC';
ok Uni.new(0xAE6E).NFKD.list ~~ (0x1101, 0x1162, 0x11AD,), 'AE6E -> 1101 1162 11AD';
ok Uni.new(0xAE6F).NFKD.list ~~ (0x1101, 0x1162, 0x11AE,), 'AE6F -> 1101 1162 11AE';
ok Uni.new(0xAE70).NFKD.list ~~ (0x1101, 0x1162, 0x11AF,), 'AE70 -> 1101 1162 11AF';
ok Uni.new(0xAE71).NFKD.list ~~ (0x1101, 0x1162, 0x11B0,), 'AE71 -> 1101 1162 11B0';
ok Uni.new(0xAE72).NFKD.list ~~ (0x1101, 0x1162, 0x11B1,), 'AE72 -> 1101 1162 11B1';
ok Uni.new(0xAE73).NFKD.list ~~ (0x1101, 0x1162, 0x11B2,), 'AE73 -> 1101 1162 11B2';
ok Uni.new(0xAE74).NFKD.list ~~ (0x1101, 0x1162, 0x11B3,), 'AE74 -> 1101 1162 11B3';
ok Uni.new(0xAE75).NFKD.list ~~ (0x1101, 0x1162, 0x11B4,), 'AE75 -> 1101 1162 11B4';
ok Uni.new(0xAE76).NFKD.list ~~ (0x1101, 0x1162, 0x11B5,), 'AE76 -> 1101 1162 11B5';
ok Uni.new(0xAE77).NFKD.list ~~ (0x1101, 0x1162, 0x11B6,), 'AE77 -> 1101 1162 11B6';
ok Uni.new(0xAE78).NFKD.list ~~ (0x1101, 0x1162, 0x11B7,), 'AE78 -> 1101 1162 11B7';
ok Uni.new(0xAE79).NFKD.list ~~ (0x1101, 0x1162, 0x11B8,), 'AE79 -> 1101 1162 11B8';
ok Uni.new(0xAE7A).NFKD.list ~~ (0x1101, 0x1162, 0x11B9,), 'AE7A -> 1101 1162 11B9';
ok Uni.new(0xAE7B).NFKD.list ~~ (0x1101, 0x1162, 0x11BA,), 'AE7B -> 1101 1162 11BA';
ok Uni.new(0xAE7C).NFKD.list ~~ (0x1101, 0x1162, 0x11BB,), 'AE7C -> 1101 1162 11BB';
ok Uni.new(0xAE7D).NFKD.list ~~ (0x1101, 0x1162, 0x11BC,), 'AE7D -> 1101 1162 11BC';
ok Uni.new(0xAE7E).NFKD.list ~~ (0x1101, 0x1162, 0x11BD,), 'AE7E -> 1101 1162 11BD';
ok Uni.new(0xAE7F).NFKD.list ~~ (0x1101, 0x1162, 0x11BE,), 'AE7F -> 1101 1162 11BE';
ok Uni.new(0xAE80).NFKD.list ~~ (0x1101, 0x1162, 0x11BF,), 'AE80 -> 1101 1162 11BF';
ok Uni.new(0xAE81).NFKD.list ~~ (0x1101, 0x1162, 0x11C0,), 'AE81 -> 1101 1162 11C0';
ok Uni.new(0xAE82).NFKD.list ~~ (0x1101, 0x1162, 0x11C1,), 'AE82 -> 1101 1162 11C1';
ok Uni.new(0xAE83).NFKD.list ~~ (0x1101, 0x1162, 0x11C2,), 'AE83 -> 1101 1162 11C2';
ok Uni.new(0xAE84).NFKD.list ~~ (0x1101, 0x1163,), 'AE84 -> 1101 1163';
ok Uni.new(0xAE85).NFKD.list ~~ (0x1101, 0x1163, 0x11A8,), 'AE85 -> 1101 1163 11A8';
ok Uni.new(0xAE86).NFKD.list ~~ (0x1101, 0x1163, 0x11A9,), 'AE86 -> 1101 1163 11A9';
ok Uni.new(0xAE87).NFKD.list ~~ (0x1101, 0x1163, 0x11AA,), 'AE87 -> 1101 1163 11AA';
ok Uni.new(0xAE88).NFKD.list ~~ (0x1101, 0x1163, 0x11AB,), 'AE88 -> 1101 1163 11AB';
ok Uni.new(0xAE89).NFKD.list ~~ (0x1101, 0x1163, 0x11AC,), 'AE89 -> 1101 1163 11AC';
ok Uni.new(0xAE8A).NFKD.list ~~ (0x1101, 0x1163, 0x11AD,), 'AE8A -> 1101 1163 11AD';
ok Uni.new(0xAE8B).NFKD.list ~~ (0x1101, 0x1163, 0x11AE,), 'AE8B -> 1101 1163 11AE';
ok Uni.new(0xAE8C).NFKD.list ~~ (0x1101, 0x1163, 0x11AF,), 'AE8C -> 1101 1163 11AF';
ok Uni.new(0xAE8D).NFKD.list ~~ (0x1101, 0x1163, 0x11B0,), 'AE8D -> 1101 1163 11B0';
ok Uni.new(0xAE8E).NFKD.list ~~ (0x1101, 0x1163, 0x11B1,), 'AE8E -> 1101 1163 11B1';
ok Uni.new(0xAE8F).NFKD.list ~~ (0x1101, 0x1163, 0x11B2,), 'AE8F -> 1101 1163 11B2';
ok Uni.new(0xAE90).NFKD.list ~~ (0x1101, 0x1163, 0x11B3,), 'AE90 -> 1101 1163 11B3';
ok Uni.new(0xAE91).NFKD.list ~~ (0x1101, 0x1163, 0x11B4,), 'AE91 -> 1101 1163 11B4';
ok Uni.new(0xAE92).NFKD.list ~~ (0x1101, 0x1163, 0x11B5,), 'AE92 -> 1101 1163 11B5';
ok Uni.new(0xAE93).NFKD.list ~~ (0x1101, 0x1163, 0x11B6,), 'AE93 -> 1101 1163 11B6';
ok Uni.new(0xAE94).NFKD.list ~~ (0x1101, 0x1163, 0x11B7,), 'AE94 -> 1101 1163 11B7';
ok Uni.new(0xAE95).NFKD.list ~~ (0x1101, 0x1163, 0x11B8,), 'AE95 -> 1101 1163 11B8';
ok Uni.new(0xAE96).NFKD.list ~~ (0x1101, 0x1163, 0x11B9,), 'AE96 -> 1101 1163 11B9';
ok Uni.new(0xAE97).NFKD.list ~~ (0x1101, 0x1163, 0x11BA,), 'AE97 -> 1101 1163 11BA';
ok Uni.new(0xAE98).NFKD.list ~~ (0x1101, 0x1163, 0x11BB,), 'AE98 -> 1101 1163 11BB';
ok Uni.new(0xAE99).NFKD.list ~~ (0x1101, 0x1163, 0x11BC,), 'AE99 -> 1101 1163 11BC';
ok Uni.new(0xAE9A).NFKD.list ~~ (0x1101, 0x1163, 0x11BD,), 'AE9A -> 1101 1163 11BD';
ok Uni.new(0xAE9B).NFKD.list ~~ (0x1101, 0x1163, 0x11BE,), 'AE9B -> 1101 1163 11BE';
ok Uni.new(0xAE9C).NFKD.list ~~ (0x1101, 0x1163, 0x11BF,), 'AE9C -> 1101 1163 11BF';
ok Uni.new(0xAE9D).NFKD.list ~~ (0x1101, 0x1163, 0x11C0,), 'AE9D -> 1101 1163 11C0';
ok Uni.new(0xAE9E).NFKD.list ~~ (0x1101, 0x1163, 0x11C1,), 'AE9E -> 1101 1163 11C1';
ok Uni.new(0xAE9F).NFKD.list ~~ (0x1101, 0x1163, 0x11C2,), 'AE9F -> 1101 1163 11C2';
ok Uni.new(0xAEA0).NFKD.list ~~ (0x1101, 0x1164,), 'AEA0 -> 1101 1164';
ok Uni.new(0xAEA1).NFKD.list ~~ (0x1101, 0x1164, 0x11A8,), 'AEA1 -> 1101 1164 11A8';
ok Uni.new(0xAEA2).NFKD.list ~~ (0x1101, 0x1164, 0x11A9,), 'AEA2 -> 1101 1164 11A9';
ok Uni.new(0xAEA3).NFKD.list ~~ (0x1101, 0x1164, 0x11AA,), 'AEA3 -> 1101 1164 11AA';
ok Uni.new(0xAEA4).NFKD.list ~~ (0x1101, 0x1164, 0x11AB,), 'AEA4 -> 1101 1164 11AB';
ok Uni.new(0xAEA5).NFKD.list ~~ (0x1101, 0x1164, 0x11AC,), 'AEA5 -> 1101 1164 11AC';
ok Uni.new(0xAEA6).NFKD.list ~~ (0x1101, 0x1164, 0x11AD,), 'AEA6 -> 1101 1164 11AD';
ok Uni.new(0xAEA7).NFKD.list ~~ (0x1101, 0x1164, 0x11AE,), 'AEA7 -> 1101 1164 11AE';
ok Uni.new(0xAEA8).NFKD.list ~~ (0x1101, 0x1164, 0x11AF,), 'AEA8 -> 1101 1164 11AF';
ok Uni.new(0xAEA9).NFKD.list ~~ (0x1101, 0x1164, 0x11B0,), 'AEA9 -> 1101 1164 11B0';
ok Uni.new(0xAEAA).NFKD.list ~~ (0x1101, 0x1164, 0x11B1,), 'AEAA -> 1101 1164 11B1';
ok Uni.new(0xAEAB).NFKD.list ~~ (0x1101, 0x1164, 0x11B2,), 'AEAB -> 1101 1164 11B2';
ok Uni.new(0xAEAC).NFKD.list ~~ (0x1101, 0x1164, 0x11B3,), 'AEAC -> 1101 1164 11B3';
ok Uni.new(0xAEAD).NFKD.list ~~ (0x1101, 0x1164, 0x11B4,), 'AEAD -> 1101 1164 11B4';
ok Uni.new(0xAEAE).NFKD.list ~~ (0x1101, 0x1164, 0x11B5,), 'AEAE -> 1101 1164 11B5';
ok Uni.new(0xAEAF).NFKD.list ~~ (0x1101, 0x1164, 0x11B6,), 'AEAF -> 1101 1164 11B6';
ok Uni.new(0xAEB0).NFKD.list ~~ (0x1101, 0x1164, 0x11B7,), 'AEB0 -> 1101 1164 11B7';
ok Uni.new(0xAEB1).NFKD.list ~~ (0x1101, 0x1164, 0x11B8,), 'AEB1 -> 1101 1164 11B8';
ok Uni.new(0xAEB2).NFKD.list ~~ (0x1101, 0x1164, 0x11B9,), 'AEB2 -> 1101 1164 11B9';
ok Uni.new(0xAEB3).NFKD.list ~~ (0x1101, 0x1164, 0x11BA,), 'AEB3 -> 1101 1164 11BA';
ok Uni.new(0xAEB4).NFKD.list ~~ (0x1101, 0x1164, 0x11BB,), 'AEB4 -> 1101 1164 11BB';
ok Uni.new(0xAEB5).NFKD.list ~~ (0x1101, 0x1164, 0x11BC,), 'AEB5 -> 1101 1164 11BC';
ok Uni.new(0xAEB6).NFKD.list ~~ (0x1101, 0x1164, 0x11BD,), 'AEB6 -> 1101 1164 11BD';
ok Uni.new(0xAEB7).NFKD.list ~~ (0x1101, 0x1164, 0x11BE,), 'AEB7 -> 1101 1164 11BE';
ok Uni.new(0xAEB8).NFKD.list ~~ (0x1101, 0x1164, 0x11BF,), 'AEB8 -> 1101 1164 11BF';
ok Uni.new(0xAEB9).NFKD.list ~~ (0x1101, 0x1164, 0x11C0,), 'AEB9 -> 1101 1164 11C0';
ok Uni.new(0xAEBA).NFKD.list ~~ (0x1101, 0x1164, 0x11C1,), 'AEBA -> 1101 1164 11C1';
ok Uni.new(0xAEBB).NFKD.list ~~ (0x1101, 0x1164, 0x11C2,), 'AEBB -> 1101 1164 11C2';
ok Uni.new(0xAEBC).NFKD.list ~~ (0x1101, 0x1165,), 'AEBC -> 1101 1165';
ok Uni.new(0xAEBD).NFKD.list ~~ (0x1101, 0x1165, 0x11A8,), 'AEBD -> 1101 1165 11A8';
ok Uni.new(0xAEBE).NFKD.list ~~ (0x1101, 0x1165, 0x11A9,), 'AEBE -> 1101 1165 11A9';
ok Uni.new(0xAEBF).NFKD.list ~~ (0x1101, 0x1165, 0x11AA,), 'AEBF -> 1101 1165 11AA';
ok Uni.new(0xAEC0).NFKD.list ~~ (0x1101, 0x1165, 0x11AB,), 'AEC0 -> 1101 1165 11AB';
ok Uni.new(0xAEC1).NFKD.list ~~ (0x1101, 0x1165, 0x11AC,), 'AEC1 -> 1101 1165 11AC';
ok Uni.new(0xAEC2).NFKD.list ~~ (0x1101, 0x1165, 0x11AD,), 'AEC2 -> 1101 1165 11AD';
ok Uni.new(0xAEC3).NFKD.list ~~ (0x1101, 0x1165, 0x11AE,), 'AEC3 -> 1101 1165 11AE';
ok Uni.new(0xAEC4).NFKD.list ~~ (0x1101, 0x1165, 0x11AF,), 'AEC4 -> 1101 1165 11AF';
ok Uni.new(0xAEC5).NFKD.list ~~ (0x1101, 0x1165, 0x11B0,), 'AEC5 -> 1101 1165 11B0';
ok Uni.new(0xAEC6).NFKD.list ~~ (0x1101, 0x1165, 0x11B1,), 'AEC6 -> 1101 1165 11B1';
ok Uni.new(0xAEC7).NFKD.list ~~ (0x1101, 0x1165, 0x11B2,), 'AEC7 -> 1101 1165 11B2';
ok Uni.new(0xAEC8).NFKD.list ~~ (0x1101, 0x1165, 0x11B3,), 'AEC8 -> 1101 1165 11B3';
ok Uni.new(0xAEC9).NFKD.list ~~ (0x1101, 0x1165, 0x11B4,), 'AEC9 -> 1101 1165 11B4';
ok Uni.new(0xAECA).NFKD.list ~~ (0x1101, 0x1165, 0x11B5,), 'AECA -> 1101 1165 11B5';
ok Uni.new(0xAECB).NFKD.list ~~ (0x1101, 0x1165, 0x11B6,), 'AECB -> 1101 1165 11B6';
ok Uni.new(0xAECC).NFKD.list ~~ (0x1101, 0x1165, 0x11B7,), 'AECC -> 1101 1165 11B7';
ok Uni.new(0xAECD).NFKD.list ~~ (0x1101, 0x1165, 0x11B8,), 'AECD -> 1101 1165 11B8';
ok Uni.new(0xAECE).NFKD.list ~~ (0x1101, 0x1165, 0x11B9,), 'AECE -> 1101 1165 11B9';
ok Uni.new(0xAECF).NFKD.list ~~ (0x1101, 0x1165, 0x11BA,), 'AECF -> 1101 1165 11BA';
ok Uni.new(0xAED0).NFKD.list ~~ (0x1101, 0x1165, 0x11BB,), 'AED0 -> 1101 1165 11BB';
ok Uni.new(0xAED1).NFKD.list ~~ (0x1101, 0x1165, 0x11BC,), 'AED1 -> 1101 1165 11BC';
ok Uni.new(0xAED2).NFKD.list ~~ (0x1101, 0x1165, 0x11BD,), 'AED2 -> 1101 1165 11BD';
ok Uni.new(0xAED3).NFKD.list ~~ (0x1101, 0x1165, 0x11BE,), 'AED3 -> 1101 1165 11BE';
ok Uni.new(0xAED4).NFKD.list ~~ (0x1101, 0x1165, 0x11BF,), 'AED4 -> 1101 1165 11BF';
ok Uni.new(0xAED5).NFKD.list ~~ (0x1101, 0x1165, 0x11C0,), 'AED5 -> 1101 1165 11C0';
ok Uni.new(0xAED6).NFKD.list ~~ (0x1101, 0x1165, 0x11C1,), 'AED6 -> 1101 1165 11C1';
ok Uni.new(0xAED7).NFKD.list ~~ (0x1101, 0x1165, 0x11C2,), 'AED7 -> 1101 1165 11C2';
ok Uni.new(0xAED8).NFKD.list ~~ (0x1101, 0x1166,), 'AED8 -> 1101 1166';
ok Uni.new(0xAED9).NFKD.list ~~ (0x1101, 0x1166, 0x11A8,), 'AED9 -> 1101 1166 11A8';
ok Uni.new(0xAEDA).NFKD.list ~~ (0x1101, 0x1166, 0x11A9,), 'AEDA -> 1101 1166 11A9';
ok Uni.new(0xAEDB).NFKD.list ~~ (0x1101, 0x1166, 0x11AA,), 'AEDB -> 1101 1166 11AA';
ok Uni.new(0xAEDC).NFKD.list ~~ (0x1101, 0x1166, 0x11AB,), 'AEDC -> 1101 1166 11AB';
ok Uni.new(0xAEDD).NFKD.list ~~ (0x1101, 0x1166, 0x11AC,), 'AEDD -> 1101 1166 11AC';
ok Uni.new(0xAEDE).NFKD.list ~~ (0x1101, 0x1166, 0x11AD,), 'AEDE -> 1101 1166 11AD';
ok Uni.new(0xAEDF).NFKD.list ~~ (0x1101, 0x1166, 0x11AE,), 'AEDF -> 1101 1166 11AE';
ok Uni.new(0xAEE0).NFKD.list ~~ (0x1101, 0x1166, 0x11AF,), 'AEE0 -> 1101 1166 11AF';
ok Uni.new(0xAEE1).NFKD.list ~~ (0x1101, 0x1166, 0x11B0,), 'AEE1 -> 1101 1166 11B0';
ok Uni.new(0xAEE2).NFKD.list ~~ (0x1101, 0x1166, 0x11B1,), 'AEE2 -> 1101 1166 11B1';
ok Uni.new(0xAEE3).NFKD.list ~~ (0x1101, 0x1166, 0x11B2,), 'AEE3 -> 1101 1166 11B2';
ok Uni.new(0xAEE4).NFKD.list ~~ (0x1101, 0x1166, 0x11B3,), 'AEE4 -> 1101 1166 11B3';
ok Uni.new(0xAEE5).NFKD.list ~~ (0x1101, 0x1166, 0x11B4,), 'AEE5 -> 1101 1166 11B4';
ok Uni.new(0xAEE6).NFKD.list ~~ (0x1101, 0x1166, 0x11B5,), 'AEE6 -> 1101 1166 11B5';
ok Uni.new(0xAEE7).NFKD.list ~~ (0x1101, 0x1166, 0x11B6,), 'AEE7 -> 1101 1166 11B6';
ok Uni.new(0xAEE8).NFKD.list ~~ (0x1101, 0x1166, 0x11B7,), 'AEE8 -> 1101 1166 11B7';
ok Uni.new(0xAEE9).NFKD.list ~~ (0x1101, 0x1166, 0x11B8,), 'AEE9 -> 1101 1166 11B8';
ok Uni.new(0xAEEA).NFKD.list ~~ (0x1101, 0x1166, 0x11B9,), 'AEEA -> 1101 1166 11B9';
ok Uni.new(0xAEEB).NFKD.list ~~ (0x1101, 0x1166, 0x11BA,), 'AEEB -> 1101 1166 11BA';
ok Uni.new(0xAEEC).NFKD.list ~~ (0x1101, 0x1166, 0x11BB,), 'AEEC -> 1101 1166 11BB';
ok Uni.new(0xAEED).NFKD.list ~~ (0x1101, 0x1166, 0x11BC,), 'AEED -> 1101 1166 11BC';
ok Uni.new(0xAEEE).NFKD.list ~~ (0x1101, 0x1166, 0x11BD,), 'AEEE -> 1101 1166 11BD';
ok Uni.new(0xAEEF).NFKD.list ~~ (0x1101, 0x1166, 0x11BE,), 'AEEF -> 1101 1166 11BE';
ok Uni.new(0xAEF0).NFKD.list ~~ (0x1101, 0x1166, 0x11BF,), 'AEF0 -> 1101 1166 11BF';
ok Uni.new(0xAEF1).NFKD.list ~~ (0x1101, 0x1166, 0x11C0,), 'AEF1 -> 1101 1166 11C0';
ok Uni.new(0xAEF2).NFKD.list ~~ (0x1101, 0x1166, 0x11C1,), 'AEF2 -> 1101 1166 11C1';
ok Uni.new(0xAEF3).NFKD.list ~~ (0x1101, 0x1166, 0x11C2,), 'AEF3 -> 1101 1166 11C2';
ok Uni.new(0xAEF4).NFKD.list ~~ (0x1101, 0x1167,), 'AEF4 -> 1101 1167';
ok Uni.new(0xAEF5).NFKD.list ~~ (0x1101, 0x1167, 0x11A8,), 'AEF5 -> 1101 1167 11A8';
ok Uni.new(0xAEF6).NFKD.list ~~ (0x1101, 0x1167, 0x11A9,), 'AEF6 -> 1101 1167 11A9';
ok Uni.new(0xAEF7).NFKD.list ~~ (0x1101, 0x1167, 0x11AA,), 'AEF7 -> 1101 1167 11AA';
ok Uni.new(0xAEF8).NFKD.list ~~ (0x1101, 0x1167, 0x11AB,), 'AEF8 -> 1101 1167 11AB';
ok Uni.new(0xAEF9).NFKD.list ~~ (0x1101, 0x1167, 0x11AC,), 'AEF9 -> 1101 1167 11AC';
ok Uni.new(0xAEFA).NFKD.list ~~ (0x1101, 0x1167, 0x11AD,), 'AEFA -> 1101 1167 11AD';
ok Uni.new(0xAEFB).NFKD.list ~~ (0x1101, 0x1167, 0x11AE,), 'AEFB -> 1101 1167 11AE';
ok Uni.new(0xAEFC).NFKD.list ~~ (0x1101, 0x1167, 0x11AF,), 'AEFC -> 1101 1167 11AF';
ok Uni.new(0xAEFD).NFKD.list ~~ (0x1101, 0x1167, 0x11B0,), 'AEFD -> 1101 1167 11B0';
ok Uni.new(0xAEFE).NFKD.list ~~ (0x1101, 0x1167, 0x11B1,), 'AEFE -> 1101 1167 11B1';
ok Uni.new(0xAEFF).NFKD.list ~~ (0x1101, 0x1167, 0x11B2,), 'AEFF -> 1101 1167 11B2';
ok Uni.new(0xAF00).NFKD.list ~~ (0x1101, 0x1167, 0x11B3,), 'AF00 -> 1101 1167 11B3';
ok Uni.new(0xAF01).NFKD.list ~~ (0x1101, 0x1167, 0x11B4,), 'AF01 -> 1101 1167 11B4';
ok Uni.new(0xAF02).NFKD.list ~~ (0x1101, 0x1167, 0x11B5,), 'AF02 -> 1101 1167 11B5';
ok Uni.new(0xAF03).NFKD.list ~~ (0x1101, 0x1167, 0x11B6,), 'AF03 -> 1101 1167 11B6';
ok Uni.new(0xAF04).NFKD.list ~~ (0x1101, 0x1167, 0x11B7,), 'AF04 -> 1101 1167 11B7';
ok Uni.new(0xAF05).NFKD.list ~~ (0x1101, 0x1167, 0x11B8,), 'AF05 -> 1101 1167 11B8';
ok Uni.new(0xAF06).NFKD.list ~~ (0x1101, 0x1167, 0x11B9,), 'AF06 -> 1101 1167 11B9';
ok Uni.new(0xAF07).NFKD.list ~~ (0x1101, 0x1167, 0x11BA,), 'AF07 -> 1101 1167 11BA';
ok Uni.new(0xAF08).NFKD.list ~~ (0x1101, 0x1167, 0x11BB,), 'AF08 -> 1101 1167 11BB';
ok Uni.new(0xAF09).NFKD.list ~~ (0x1101, 0x1167, 0x11BC,), 'AF09 -> 1101 1167 11BC';
ok Uni.new(0xAF0A).NFKD.list ~~ (0x1101, 0x1167, 0x11BD,), 'AF0A -> 1101 1167 11BD';
ok Uni.new(0xAF0B).NFKD.list ~~ (0x1101, 0x1167, 0x11BE,), 'AF0B -> 1101 1167 11BE';
ok Uni.new(0xAF0C).NFKD.list ~~ (0x1101, 0x1167, 0x11BF,), 'AF0C -> 1101 1167 11BF';
ok Uni.new(0xAF0D).NFKD.list ~~ (0x1101, 0x1167, 0x11C0,), 'AF0D -> 1101 1167 11C0';
ok Uni.new(0xAF0E).NFKD.list ~~ (0x1101, 0x1167, 0x11C1,), 'AF0E -> 1101 1167 11C1';
ok Uni.new(0xAF0F).NFKD.list ~~ (0x1101, 0x1167, 0x11C2,), 'AF0F -> 1101 1167 11C2';
ok Uni.new(0xAF10).NFKD.list ~~ (0x1101, 0x1168,), 'AF10 -> 1101 1168';
ok Uni.new(0xAF11).NFKD.list ~~ (0x1101, 0x1168, 0x11A8,), 'AF11 -> 1101 1168 11A8';
ok Uni.new(0xAF12).NFKD.list ~~ (0x1101, 0x1168, 0x11A9,), 'AF12 -> 1101 1168 11A9';
ok Uni.new(0xAF13).NFKD.list ~~ (0x1101, 0x1168, 0x11AA,), 'AF13 -> 1101 1168 11AA';
ok Uni.new(0xAF14).NFKD.list ~~ (0x1101, 0x1168, 0x11AB,), 'AF14 -> 1101 1168 11AB';
ok Uni.new(0xAF15).NFKD.list ~~ (0x1101, 0x1168, 0x11AC,), 'AF15 -> 1101 1168 11AC';
ok Uni.new(0xAF16).NFKD.list ~~ (0x1101, 0x1168, 0x11AD,), 'AF16 -> 1101 1168 11AD';
ok Uni.new(0xAF17).NFKD.list ~~ (0x1101, 0x1168, 0x11AE,), 'AF17 -> 1101 1168 11AE';
ok Uni.new(0xAF18).NFKD.list ~~ (0x1101, 0x1168, 0x11AF,), 'AF18 -> 1101 1168 11AF';
ok Uni.new(0xAF19).NFKD.list ~~ (0x1101, 0x1168, 0x11B0,), 'AF19 -> 1101 1168 11B0';
ok Uni.new(0xAF1A).NFKD.list ~~ (0x1101, 0x1168, 0x11B1,), 'AF1A -> 1101 1168 11B1';
ok Uni.new(0xAF1B).NFKD.list ~~ (0x1101, 0x1168, 0x11B2,), 'AF1B -> 1101 1168 11B2';
ok Uni.new(0xAF1C).NFKD.list ~~ (0x1101, 0x1168, 0x11B3,), 'AF1C -> 1101 1168 11B3';
ok Uni.new(0xAF1D).NFKD.list ~~ (0x1101, 0x1168, 0x11B4,), 'AF1D -> 1101 1168 11B4';
ok Uni.new(0xAF1E).NFKD.list ~~ (0x1101, 0x1168, 0x11B5,), 'AF1E -> 1101 1168 11B5';
ok Uni.new(0xAF1F).NFKD.list ~~ (0x1101, 0x1168, 0x11B6,), 'AF1F -> 1101 1168 11B6';
ok Uni.new(0xAF20).NFKD.list ~~ (0x1101, 0x1168, 0x11B7,), 'AF20 -> 1101 1168 11B7';
ok Uni.new(0xAF21).NFKD.list ~~ (0x1101, 0x1168, 0x11B8,), 'AF21 -> 1101 1168 11B8';
ok Uni.new(0xAF22).NFKD.list ~~ (0x1101, 0x1168, 0x11B9,), 'AF22 -> 1101 1168 11B9';
ok Uni.new(0xAF23).NFKD.list ~~ (0x1101, 0x1168, 0x11BA,), 'AF23 -> 1101 1168 11BA';
ok Uni.new(0xAF24).NFKD.list ~~ (0x1101, 0x1168, 0x11BB,), 'AF24 -> 1101 1168 11BB';
ok Uni.new(0xAF25).NFKD.list ~~ (0x1101, 0x1168, 0x11BC,), 'AF25 -> 1101 1168 11BC';
ok Uni.new(0xAF26).NFKD.list ~~ (0x1101, 0x1168, 0x11BD,), 'AF26 -> 1101 1168 11BD';
ok Uni.new(0xAF27).NFKD.list ~~ (0x1101, 0x1168, 0x11BE,), 'AF27 -> 1101 1168 11BE';
ok Uni.new(0xAF28).NFKD.list ~~ (0x1101, 0x1168, 0x11BF,), 'AF28 -> 1101 1168 11BF';
ok Uni.new(0xAF29).NFKD.list ~~ (0x1101, 0x1168, 0x11C0,), 'AF29 -> 1101 1168 11C0';
ok Uni.new(0xAF2A).NFKD.list ~~ (0x1101, 0x1168, 0x11C1,), 'AF2A -> 1101 1168 11C1';
ok Uni.new(0xAF2B).NFKD.list ~~ (0x1101, 0x1168, 0x11C2,), 'AF2B -> 1101 1168 11C2';
ok Uni.new(0xAF2C).NFKD.list ~~ (0x1101, 0x1169,), 'AF2C -> 1101 1169';
ok Uni.new(0xAF2D).NFKD.list ~~ (0x1101, 0x1169, 0x11A8,), 'AF2D -> 1101 1169 11A8';
ok Uni.new(0xAF2E).NFKD.list ~~ (0x1101, 0x1169, 0x11A9,), 'AF2E -> 1101 1169 11A9';
ok Uni.new(0xAF2F).NFKD.list ~~ (0x1101, 0x1169, 0x11AA,), 'AF2F -> 1101 1169 11AA';
ok Uni.new(0xAF30).NFKD.list ~~ (0x1101, 0x1169, 0x11AB,), 'AF30 -> 1101 1169 11AB';
ok Uni.new(0xAF31).NFKD.list ~~ (0x1101, 0x1169, 0x11AC,), 'AF31 -> 1101 1169 11AC';
ok Uni.new(0xAF32).NFKD.list ~~ (0x1101, 0x1169, 0x11AD,), 'AF32 -> 1101 1169 11AD';
ok Uni.new(0xAF33).NFKD.list ~~ (0x1101, 0x1169, 0x11AE,), 'AF33 -> 1101 1169 11AE';
ok Uni.new(0xAF34).NFKD.list ~~ (0x1101, 0x1169, 0x11AF,), 'AF34 -> 1101 1169 11AF';
ok Uni.new(0xAF35).NFKD.list ~~ (0x1101, 0x1169, 0x11B0,), 'AF35 -> 1101 1169 11B0';
ok Uni.new(0xAF36).NFKD.list ~~ (0x1101, 0x1169, 0x11B1,), 'AF36 -> 1101 1169 11B1';
ok Uni.new(0xAF37).NFKD.list ~~ (0x1101, 0x1169, 0x11B2,), 'AF37 -> 1101 1169 11B2';
ok Uni.new(0xAF38).NFKD.list ~~ (0x1101, 0x1169, 0x11B3,), 'AF38 -> 1101 1169 11B3';
ok Uni.new(0xAF39).NFKD.list ~~ (0x1101, 0x1169, 0x11B4,), 'AF39 -> 1101 1169 11B4';
ok Uni.new(0xAF3A).NFKD.list ~~ (0x1101, 0x1169, 0x11B5,), 'AF3A -> 1101 1169 11B5';
ok Uni.new(0xAF3B).NFKD.list ~~ (0x1101, 0x1169, 0x11B6,), 'AF3B -> 1101 1169 11B6';
ok Uni.new(0xAF3C).NFKD.list ~~ (0x1101, 0x1169, 0x11B7,), 'AF3C -> 1101 1169 11B7';
ok Uni.new(0xAF3D).NFKD.list ~~ (0x1101, 0x1169, 0x11B8,), 'AF3D -> 1101 1169 11B8';
ok Uni.new(0xAF3E).NFKD.list ~~ (0x1101, 0x1169, 0x11B9,), 'AF3E -> 1101 1169 11B9';
ok Uni.new(0xAF3F).NFKD.list ~~ (0x1101, 0x1169, 0x11BA,), 'AF3F -> 1101 1169 11BA';
ok Uni.new(0xAF40).NFKD.list ~~ (0x1101, 0x1169, 0x11BB,), 'AF40 -> 1101 1169 11BB';
ok Uni.new(0xAF41).NFKD.list ~~ (0x1101, 0x1169, 0x11BC,), 'AF41 -> 1101 1169 11BC';
ok Uni.new(0xAF42).NFKD.list ~~ (0x1101, 0x1169, 0x11BD,), 'AF42 -> 1101 1169 11BD';
ok Uni.new(0xAF43).NFKD.list ~~ (0x1101, 0x1169, 0x11BE,), 'AF43 -> 1101 1169 11BE';
ok Uni.new(0xAF44).NFKD.list ~~ (0x1101, 0x1169, 0x11BF,), 'AF44 -> 1101 1169 11BF';
ok Uni.new(0xAF45).NFKD.list ~~ (0x1101, 0x1169, 0x11C0,), 'AF45 -> 1101 1169 11C0';
ok Uni.new(0xAF46).NFKD.list ~~ (0x1101, 0x1169, 0x11C1,), 'AF46 -> 1101 1169 11C1';
ok Uni.new(0xAF47).NFKD.list ~~ (0x1101, 0x1169, 0x11C2,), 'AF47 -> 1101 1169 11C2';
ok Uni.new(0xAF48).NFKD.list ~~ (0x1101, 0x116A,), 'AF48 -> 1101 116A';
ok Uni.new(0xAF49).NFKD.list ~~ (0x1101, 0x116A, 0x11A8,), 'AF49 -> 1101 116A 11A8';
ok Uni.new(0xAF4A).NFKD.list ~~ (0x1101, 0x116A, 0x11A9,), 'AF4A -> 1101 116A 11A9';
ok Uni.new(0xAF4B).NFKD.list ~~ (0x1101, 0x116A, 0x11AA,), 'AF4B -> 1101 116A 11AA';
ok Uni.new(0xAF4C).NFKD.list ~~ (0x1101, 0x116A, 0x11AB,), 'AF4C -> 1101 116A 11AB';
ok Uni.new(0xAF4D).NFKD.list ~~ (0x1101, 0x116A, 0x11AC,), 'AF4D -> 1101 116A 11AC';
ok Uni.new(0xAF4E).NFKD.list ~~ (0x1101, 0x116A, 0x11AD,), 'AF4E -> 1101 116A 11AD';
ok Uni.new(0xAF4F).NFKD.list ~~ (0x1101, 0x116A, 0x11AE,), 'AF4F -> 1101 116A 11AE';
ok Uni.new(0xAF50).NFKD.list ~~ (0x1101, 0x116A, 0x11AF,), 'AF50 -> 1101 116A 11AF';
ok Uni.new(0xAF51).NFKD.list ~~ (0x1101, 0x116A, 0x11B0,), 'AF51 -> 1101 116A 11B0';
ok Uni.new(0xAF52).NFKD.list ~~ (0x1101, 0x116A, 0x11B1,), 'AF52 -> 1101 116A 11B1';
ok Uni.new(0xAF53).NFKD.list ~~ (0x1101, 0x116A, 0x11B2,), 'AF53 -> 1101 116A 11B2';
ok Uni.new(0xAF54).NFKD.list ~~ (0x1101, 0x116A, 0x11B3,), 'AF54 -> 1101 116A 11B3';
ok Uni.new(0xAF55).NFKD.list ~~ (0x1101, 0x116A, 0x11B4,), 'AF55 -> 1101 116A 11B4';
ok Uni.new(0xAF56).NFKD.list ~~ (0x1101, 0x116A, 0x11B5,), 'AF56 -> 1101 116A 11B5';
ok Uni.new(0xAF57).NFKD.list ~~ (0x1101, 0x116A, 0x11B6,), 'AF57 -> 1101 116A 11B6';
ok Uni.new(0xAF58).NFKD.list ~~ (0x1101, 0x116A, 0x11B7,), 'AF58 -> 1101 116A 11B7';
ok Uni.new(0xAF59).NFKD.list ~~ (0x1101, 0x116A, 0x11B8,), 'AF59 -> 1101 116A 11B8';
ok Uni.new(0xAF5A).NFKD.list ~~ (0x1101, 0x116A, 0x11B9,), 'AF5A -> 1101 116A 11B9';
ok Uni.new(0xAF5B).NFKD.list ~~ (0x1101, 0x116A, 0x11BA,), 'AF5B -> 1101 116A 11BA';
ok Uni.new(0xAF5C).NFKD.list ~~ (0x1101, 0x116A, 0x11BB,), 'AF5C -> 1101 116A 11BB';
ok Uni.new(0xAF5D).NFKD.list ~~ (0x1101, 0x116A, 0x11BC,), 'AF5D -> 1101 116A 11BC';
ok Uni.new(0xAF5E).NFKD.list ~~ (0x1101, 0x116A, 0x11BD,), 'AF5E -> 1101 116A 11BD';
ok Uni.new(0xAF5F).NFKD.list ~~ (0x1101, 0x116A, 0x11BE,), 'AF5F -> 1101 116A 11BE';
ok Uni.new(0xAF60).NFKD.list ~~ (0x1101, 0x116A, 0x11BF,), 'AF60 -> 1101 116A 11BF';
ok Uni.new(0xAF61).NFKD.list ~~ (0x1101, 0x116A, 0x11C0,), 'AF61 -> 1101 116A 11C0';
ok Uni.new(0xAF62).NFKD.list ~~ (0x1101, 0x116A, 0x11C1,), 'AF62 -> 1101 116A 11C1';
ok Uni.new(0xAF63).NFKD.list ~~ (0x1101, 0x116A, 0x11C2,), 'AF63 -> 1101 116A 11C2';
ok Uni.new(0xAF64).NFKD.list ~~ (0x1101, 0x116B,), 'AF64 -> 1101 116B';
ok Uni.new(0xAF65).NFKD.list ~~ (0x1101, 0x116B, 0x11A8,), 'AF65 -> 1101 116B 11A8';
ok Uni.new(0xAF66).NFKD.list ~~ (0x1101, 0x116B, 0x11A9,), 'AF66 -> 1101 116B 11A9';
ok Uni.new(0xAF67).NFKD.list ~~ (0x1101, 0x116B, 0x11AA,), 'AF67 -> 1101 116B 11AA';
ok Uni.new(0xAF68).NFKD.list ~~ (0x1101, 0x116B, 0x11AB,), 'AF68 -> 1101 116B 11AB';
ok Uni.new(0xAF69).NFKD.list ~~ (0x1101, 0x116B, 0x11AC,), 'AF69 -> 1101 116B 11AC';
ok Uni.new(0xAF6A).NFKD.list ~~ (0x1101, 0x116B, 0x11AD,), 'AF6A -> 1101 116B 11AD';
ok Uni.new(0xAF6B).NFKD.list ~~ (0x1101, 0x116B, 0x11AE,), 'AF6B -> 1101 116B 11AE';
ok Uni.new(0xAF6C).NFKD.list ~~ (0x1101, 0x116B, 0x11AF,), 'AF6C -> 1101 116B 11AF';
ok Uni.new(0xAF6D).NFKD.list ~~ (0x1101, 0x116B, 0x11B0,), 'AF6D -> 1101 116B 11B0';
ok Uni.new(0xAF6E).NFKD.list ~~ (0x1101, 0x116B, 0x11B1,), 'AF6E -> 1101 116B 11B1';
ok Uni.new(0xAF6F).NFKD.list ~~ (0x1101, 0x116B, 0x11B2,), 'AF6F -> 1101 116B 11B2';
ok Uni.new(0xAF70).NFKD.list ~~ (0x1101, 0x116B, 0x11B3,), 'AF70 -> 1101 116B 11B3';
ok Uni.new(0xAF71).NFKD.list ~~ (0x1101, 0x116B, 0x11B4,), 'AF71 -> 1101 116B 11B4';
ok Uni.new(0xAF72).NFKD.list ~~ (0x1101, 0x116B, 0x11B5,), 'AF72 -> 1101 116B 11B5';
ok Uni.new(0xAF73).NFKD.list ~~ (0x1101, 0x116B, 0x11B6,), 'AF73 -> 1101 116B 11B6';
ok Uni.new(0xAF74).NFKD.list ~~ (0x1101, 0x116B, 0x11B7,), 'AF74 -> 1101 116B 11B7';
ok Uni.new(0xAF75).NFKD.list ~~ (0x1101, 0x116B, 0x11B8,), 'AF75 -> 1101 116B 11B8';
ok Uni.new(0xAF76).NFKD.list ~~ (0x1101, 0x116B, 0x11B9,), 'AF76 -> 1101 116B 11B9';
ok Uni.new(0xAF77).NFKD.list ~~ (0x1101, 0x116B, 0x11BA,), 'AF77 -> 1101 116B 11BA';
ok Uni.new(0xAF78).NFKD.list ~~ (0x1101, 0x116B, 0x11BB,), 'AF78 -> 1101 116B 11BB';
ok Uni.new(0xAF79).NFKD.list ~~ (0x1101, 0x116B, 0x11BC,), 'AF79 -> 1101 116B 11BC';
ok Uni.new(0xAF7A).NFKD.list ~~ (0x1101, 0x116B, 0x11BD,), 'AF7A -> 1101 116B 11BD';
ok Uni.new(0xAF7B).NFKD.list ~~ (0x1101, 0x116B, 0x11BE,), 'AF7B -> 1101 116B 11BE';
ok Uni.new(0xAF7C).NFKD.list ~~ (0x1101, 0x116B, 0x11BF,), 'AF7C -> 1101 116B 11BF';
ok Uni.new(0xAF7D).NFKD.list ~~ (0x1101, 0x116B, 0x11C0,), 'AF7D -> 1101 116B 11C0';
ok Uni.new(0xAF7E).NFKD.list ~~ (0x1101, 0x116B, 0x11C1,), 'AF7E -> 1101 116B 11C1';
ok Uni.new(0xAF7F).NFKD.list ~~ (0x1101, 0x116B, 0x11C2,), 'AF7F -> 1101 116B 11C2';
ok Uni.new(0xAF80).NFKD.list ~~ (0x1101, 0x116C,), 'AF80 -> 1101 116C';
ok Uni.new(0xAF81).NFKD.list ~~ (0x1101, 0x116C, 0x11A8,), 'AF81 -> 1101 116C 11A8';
ok Uni.new(0xAF82).NFKD.list ~~ (0x1101, 0x116C, 0x11A9,), 'AF82 -> 1101 116C 11A9';
ok Uni.new(0xAF83).NFKD.list ~~ (0x1101, 0x116C, 0x11AA,), 'AF83 -> 1101 116C 11AA';
ok Uni.new(0xAF84).NFKD.list ~~ (0x1101, 0x116C, 0x11AB,), 'AF84 -> 1101 116C 11AB';
ok Uni.new(0xAF85).NFKD.list ~~ (0x1101, 0x116C, 0x11AC,), 'AF85 -> 1101 116C 11AC';
ok Uni.new(0xAF86).NFKD.list ~~ (0x1101, 0x116C, 0x11AD,), 'AF86 -> 1101 116C 11AD';
ok Uni.new(0xAF87).NFKD.list ~~ (0x1101, 0x116C, 0x11AE,), 'AF87 -> 1101 116C 11AE';
ok Uni.new(0xAF88).NFKD.list ~~ (0x1101, 0x116C, 0x11AF,), 'AF88 -> 1101 116C 11AF';
ok Uni.new(0xAF89).NFKD.list ~~ (0x1101, 0x116C, 0x11B0,), 'AF89 -> 1101 116C 11B0';
ok Uni.new(0xAF8A).NFKD.list ~~ (0x1101, 0x116C, 0x11B1,), 'AF8A -> 1101 116C 11B1';
ok Uni.new(0xAF8B).NFKD.list ~~ (0x1101, 0x116C, 0x11B2,), 'AF8B -> 1101 116C 11B2';
ok Uni.new(0xAF8C).NFKD.list ~~ (0x1101, 0x116C, 0x11B3,), 'AF8C -> 1101 116C 11B3';
ok Uni.new(0xAF8D).NFKD.list ~~ (0x1101, 0x116C, 0x11B4,), 'AF8D -> 1101 116C 11B4';
ok Uni.new(0xAF8E).NFKD.list ~~ (0x1101, 0x116C, 0x11B5,), 'AF8E -> 1101 116C 11B5';
ok Uni.new(0xAF8F).NFKD.list ~~ (0x1101, 0x116C, 0x11B6,), 'AF8F -> 1101 116C 11B6';
ok Uni.new(0xAF90).NFKD.list ~~ (0x1101, 0x116C, 0x11B7,), 'AF90 -> 1101 116C 11B7';
ok Uni.new(0xAF91).NFKD.list ~~ (0x1101, 0x116C, 0x11B8,), 'AF91 -> 1101 116C 11B8';
ok Uni.new(0xAF92).NFKD.list ~~ (0x1101, 0x116C, 0x11B9,), 'AF92 -> 1101 116C 11B9';
ok Uni.new(0xAF93).NFKD.list ~~ (0x1101, 0x116C, 0x11BA,), 'AF93 -> 1101 116C 11BA';
ok Uni.new(0xAF94).NFKD.list ~~ (0x1101, 0x116C, 0x11BB,), 'AF94 -> 1101 116C 11BB';
ok Uni.new(0xAF95).NFKD.list ~~ (0x1101, 0x116C, 0x11BC,), 'AF95 -> 1101 116C 11BC';
ok Uni.new(0xAF96).NFKD.list ~~ (0x1101, 0x116C, 0x11BD,), 'AF96 -> 1101 116C 11BD';
ok Uni.new(0xAF97).NFKD.list ~~ (0x1101, 0x116C, 0x11BE,), 'AF97 -> 1101 116C 11BE';
ok Uni.new(0xAF98).NFKD.list ~~ (0x1101, 0x116C, 0x11BF,), 'AF98 -> 1101 116C 11BF';
ok Uni.new(0xAF99).NFKD.list ~~ (0x1101, 0x116C, 0x11C0,), 'AF99 -> 1101 116C 11C0';
ok Uni.new(0xAF9A).NFKD.list ~~ (0x1101, 0x116C, 0x11C1,), 'AF9A -> 1101 116C 11C1';
ok Uni.new(0xAF9B).NFKD.list ~~ (0x1101, 0x116C, 0x11C2,), 'AF9B -> 1101 116C 11C2';
ok Uni.new(0xAF9C).NFKD.list ~~ (0x1101, 0x116D,), 'AF9C -> 1101 116D';
ok Uni.new(0xAF9D).NFKD.list ~~ (0x1101, 0x116D, 0x11A8,), 'AF9D -> 1101 116D 11A8';
ok Uni.new(0xAF9E).NFKD.list ~~ (0x1101, 0x116D, 0x11A9,), 'AF9E -> 1101 116D 11A9';
ok Uni.new(0xAF9F).NFKD.list ~~ (0x1101, 0x116D, 0x11AA,), 'AF9F -> 1101 116D 11AA';
ok Uni.new(0xAFA0).NFKD.list ~~ (0x1101, 0x116D, 0x11AB,), 'AFA0 -> 1101 116D 11AB';
ok Uni.new(0xAFA1).NFKD.list ~~ (0x1101, 0x116D, 0x11AC,), 'AFA1 -> 1101 116D 11AC';
ok Uni.new(0xAFA2).NFKD.list ~~ (0x1101, 0x116D, 0x11AD,), 'AFA2 -> 1101 116D 11AD';
ok Uni.new(0xAFA3).NFKD.list ~~ (0x1101, 0x116D, 0x11AE,), 'AFA3 -> 1101 116D 11AE';
ok Uni.new(0xAFA4).NFKD.list ~~ (0x1101, 0x116D, 0x11AF,), 'AFA4 -> 1101 116D 11AF';
ok Uni.new(0xAFA5).NFKD.list ~~ (0x1101, 0x116D, 0x11B0,), 'AFA5 -> 1101 116D 11B0';
ok Uni.new(0xAFA6).NFKD.list ~~ (0x1101, 0x116D, 0x11B1,), 'AFA6 -> 1101 116D 11B1';
ok Uni.new(0xAFA7).NFKD.list ~~ (0x1101, 0x116D, 0x11B2,), 'AFA7 -> 1101 116D 11B2';
ok Uni.new(0xAFA8).NFKD.list ~~ (0x1101, 0x116D, 0x11B3,), 'AFA8 -> 1101 116D 11B3';
ok Uni.new(0xAFA9).NFKD.list ~~ (0x1101, 0x116D, 0x11B4,), 'AFA9 -> 1101 116D 11B4';
ok Uni.new(0xAFAA).NFKD.list ~~ (0x1101, 0x116D, 0x11B5,), 'AFAA -> 1101 116D 11B5';
ok Uni.new(0xAFAB).NFKD.list ~~ (0x1101, 0x116D, 0x11B6,), 'AFAB -> 1101 116D 11B6';
ok Uni.new(0xAFAC).NFKD.list ~~ (0x1101, 0x116D, 0x11B7,), 'AFAC -> 1101 116D 11B7';
ok Uni.new(0xAFAD).NFKD.list ~~ (0x1101, 0x116D, 0x11B8,), 'AFAD -> 1101 116D 11B8';
ok Uni.new(0xAFAE).NFKD.list ~~ (0x1101, 0x116D, 0x11B9,), 'AFAE -> 1101 116D 11B9';
ok Uni.new(0xAFAF).NFKD.list ~~ (0x1101, 0x116D, 0x11BA,), 'AFAF -> 1101 116D 11BA';
ok Uni.new(0xAFB0).NFKD.list ~~ (0x1101, 0x116D, 0x11BB,), 'AFB0 -> 1101 116D 11BB';
ok Uni.new(0xAFB1).NFKD.list ~~ (0x1101, 0x116D, 0x11BC,), 'AFB1 -> 1101 116D 11BC';
ok Uni.new(0xAFB2).NFKD.list ~~ (0x1101, 0x116D, 0x11BD,), 'AFB2 -> 1101 116D 11BD';
ok Uni.new(0xAFB3).NFKD.list ~~ (0x1101, 0x116D, 0x11BE,), 'AFB3 -> 1101 116D 11BE';
ok Uni.new(0xAFB4).NFKD.list ~~ (0x1101, 0x116D, 0x11BF,), 'AFB4 -> 1101 116D 11BF';
ok Uni.new(0xAFB5).NFKD.list ~~ (0x1101, 0x116D, 0x11C0,), 'AFB5 -> 1101 116D 11C0';
ok Uni.new(0xAFB6).NFKD.list ~~ (0x1101, 0x116D, 0x11C1,), 'AFB6 -> 1101 116D 11C1';
ok Uni.new(0xAFB7).NFKD.list ~~ (0x1101, 0x116D, 0x11C2,), 'AFB7 -> 1101 116D 11C2';
ok Uni.new(0xAFB8).NFKD.list ~~ (0x1101, 0x116E,), 'AFB8 -> 1101 116E';
ok Uni.new(0xAFB9).NFKD.list ~~ (0x1101, 0x116E, 0x11A8,), 'AFB9 -> 1101 116E 11A8';
ok Uni.new(0xAFBA).NFKD.list ~~ (0x1101, 0x116E, 0x11A9,), 'AFBA -> 1101 116E 11A9';
ok Uni.new(0xAFBB).NFKD.list ~~ (0x1101, 0x116E, 0x11AA,), 'AFBB -> 1101 116E 11AA';
ok Uni.new(0xAFBC).NFKD.list ~~ (0x1101, 0x116E, 0x11AB,), 'AFBC -> 1101 116E 11AB';
ok Uni.new(0xAFBD).NFKD.list ~~ (0x1101, 0x116E, 0x11AC,), 'AFBD -> 1101 116E 11AC';
ok Uni.new(0xAFBE).NFKD.list ~~ (0x1101, 0x116E, 0x11AD,), 'AFBE -> 1101 116E 11AD';
ok Uni.new(0xAFBF).NFKD.list ~~ (0x1101, 0x116E, 0x11AE,), 'AFBF -> 1101 116E 11AE';
ok Uni.new(0xAFC0).NFKD.list ~~ (0x1101, 0x116E, 0x11AF,), 'AFC0 -> 1101 116E 11AF';
ok Uni.new(0xAFC1).NFKD.list ~~ (0x1101, 0x116E, 0x11B0,), 'AFC1 -> 1101 116E 11B0';
ok Uni.new(0xAFC2).NFKD.list ~~ (0x1101, 0x116E, 0x11B1,), 'AFC2 -> 1101 116E 11B1';
ok Uni.new(0xAFC3).NFKD.list ~~ (0x1101, 0x116E, 0x11B2,), 'AFC3 -> 1101 116E 11B2';
ok Uni.new(0xAFC4).NFKD.list ~~ (0x1101, 0x116E, 0x11B3,), 'AFC4 -> 1101 116E 11B3';
ok Uni.new(0xAFC5).NFKD.list ~~ (0x1101, 0x116E, 0x11B4,), 'AFC5 -> 1101 116E 11B4';
ok Uni.new(0xAFC6).NFKD.list ~~ (0x1101, 0x116E, 0x11B5,), 'AFC6 -> 1101 116E 11B5';
ok Uni.new(0xAFC7).NFKD.list ~~ (0x1101, 0x116E, 0x11B6,), 'AFC7 -> 1101 116E 11B6';
ok Uni.new(0xAFC8).NFKD.list ~~ (0x1101, 0x116E, 0x11B7,), 'AFC8 -> 1101 116E 11B7';
ok Uni.new(0xAFC9).NFKD.list ~~ (0x1101, 0x116E, 0x11B8,), 'AFC9 -> 1101 116E 11B8';
ok Uni.new(0xAFCA).NFKD.list ~~ (0x1101, 0x116E, 0x11B9,), 'AFCA -> 1101 116E 11B9';
ok Uni.new(0xAFCB).NFKD.list ~~ (0x1101, 0x116E, 0x11BA,), 'AFCB -> 1101 116E 11BA';
ok Uni.new(0xAFCC).NFKD.list ~~ (0x1101, 0x116E, 0x11BB,), 'AFCC -> 1101 116E 11BB';
ok Uni.new(0xAFCD).NFKD.list ~~ (0x1101, 0x116E, 0x11BC,), 'AFCD -> 1101 116E 11BC';
ok Uni.new(0xAFCE).NFKD.list ~~ (0x1101, 0x116E, 0x11BD,), 'AFCE -> 1101 116E 11BD';
ok Uni.new(0xAFCF).NFKD.list ~~ (0x1101, 0x116E, 0x11BE,), 'AFCF -> 1101 116E 11BE';
ok Uni.new(0xAFD0).NFKD.list ~~ (0x1101, 0x116E, 0x11BF,), 'AFD0 -> 1101 116E 11BF';
ok Uni.new(0xAFD1).NFKD.list ~~ (0x1101, 0x116E, 0x11C0,), 'AFD1 -> 1101 116E 11C0';
ok Uni.new(0xAFD2).NFKD.list ~~ (0x1101, 0x116E, 0x11C1,), 'AFD2 -> 1101 116E 11C1';
ok Uni.new(0xAFD3).NFKD.list ~~ (0x1101, 0x116E, 0x11C2,), 'AFD3 -> 1101 116E 11C2';
ok Uni.new(0xAFD4).NFKD.list ~~ (0x1101, 0x116F,), 'AFD4 -> 1101 116F';
ok Uni.new(0xAFD5).NFKD.list ~~ (0x1101, 0x116F, 0x11A8,), 'AFD5 -> 1101 116F 11A8';
ok Uni.new(0xAFD6).NFKD.list ~~ (0x1101, 0x116F, 0x11A9,), 'AFD6 -> 1101 116F 11A9';
ok Uni.new(0xAFD7).NFKD.list ~~ (0x1101, 0x116F, 0x11AA,), 'AFD7 -> 1101 116F 11AA';
ok Uni.new(0xAFD8).NFKD.list ~~ (0x1101, 0x116F, 0x11AB,), 'AFD8 -> 1101 116F 11AB';
ok Uni.new(0xAFD9).NFKD.list ~~ (0x1101, 0x116F, 0x11AC,), 'AFD9 -> 1101 116F 11AC';
ok Uni.new(0xAFDA).NFKD.list ~~ (0x1101, 0x116F, 0x11AD,), 'AFDA -> 1101 116F 11AD';
ok Uni.new(0xAFDB).NFKD.list ~~ (0x1101, 0x116F, 0x11AE,), 'AFDB -> 1101 116F 11AE';
ok Uni.new(0xAFDC).NFKD.list ~~ (0x1101, 0x116F, 0x11AF,), 'AFDC -> 1101 116F 11AF';
ok Uni.new(0xAFDD).NFKD.list ~~ (0x1101, 0x116F, 0x11B0,), 'AFDD -> 1101 116F 11B0';
ok Uni.new(0xAFDE).NFKD.list ~~ (0x1101, 0x116F, 0x11B1,), 'AFDE -> 1101 116F 11B1';
ok Uni.new(0xAFDF).NFKD.list ~~ (0x1101, 0x116F, 0x11B2,), 'AFDF -> 1101 116F 11B2';
ok Uni.new(0xAFE0).NFKD.list ~~ (0x1101, 0x116F, 0x11B3,), 'AFE0 -> 1101 116F 11B3';
ok Uni.new(0xAFE1).NFKD.list ~~ (0x1101, 0x116F, 0x11B4,), 'AFE1 -> 1101 116F 11B4';
ok Uni.new(0xAFE2).NFKD.list ~~ (0x1101, 0x116F, 0x11B5,), 'AFE2 -> 1101 116F 11B5';
ok Uni.new(0xAFE3).NFKD.list ~~ (0x1101, 0x116F, 0x11B6,), 'AFE3 -> 1101 116F 11B6';
ok Uni.new(0xAFE4).NFKD.list ~~ (0x1101, 0x116F, 0x11B7,), 'AFE4 -> 1101 116F 11B7';
ok Uni.new(0xAFE5).NFKD.list ~~ (0x1101, 0x116F, 0x11B8,), 'AFE5 -> 1101 116F 11B8';
ok Uni.new(0xAFE6).NFKD.list ~~ (0x1101, 0x116F, 0x11B9,), 'AFE6 -> 1101 116F 11B9';
ok Uni.new(0xAFE7).NFKD.list ~~ (0x1101, 0x116F, 0x11BA,), 'AFE7 -> 1101 116F 11BA';
ok Uni.new(0xAFE8).NFKD.list ~~ (0x1101, 0x116F, 0x11BB,), 'AFE8 -> 1101 116F 11BB';
ok Uni.new(0xAFE9).NFKD.list ~~ (0x1101, 0x116F, 0x11BC,), 'AFE9 -> 1101 116F 11BC';
ok Uni.new(0xAFEA).NFKD.list ~~ (0x1101, 0x116F, 0x11BD,), 'AFEA -> 1101 116F 11BD';
ok Uni.new(0xAFEB).NFKD.list ~~ (0x1101, 0x116F, 0x11BE,), 'AFEB -> 1101 116F 11BE';
ok Uni.new(0xAFEC).NFKD.list ~~ (0x1101, 0x116F, 0x11BF,), 'AFEC -> 1101 116F 11BF';
ok Uni.new(0xAFED).NFKD.list ~~ (0x1101, 0x116F, 0x11C0,), 'AFED -> 1101 116F 11C0';
ok Uni.new(0xAFEE).NFKD.list ~~ (0x1101, 0x116F, 0x11C1,), 'AFEE -> 1101 116F 11C1';
ok Uni.new(0xAFEF).NFKD.list ~~ (0x1101, 0x116F, 0x11C2,), 'AFEF -> 1101 116F 11C2';
ok Uni.new(0xAFF0).NFKD.list ~~ (0x1101, 0x1170,), 'AFF0 -> 1101 1170';
ok Uni.new(0xAFF1).NFKD.list ~~ (0x1101, 0x1170, 0x11A8,), 'AFF1 -> 1101 1170 11A8';
ok Uni.new(0xAFF2).NFKD.list ~~ (0x1101, 0x1170, 0x11A9,), 'AFF2 -> 1101 1170 11A9';
ok Uni.new(0xAFF3).NFKD.list ~~ (0x1101, 0x1170, 0x11AA,), 'AFF3 -> 1101 1170 11AA';
ok Uni.new(0xAFF4).NFKD.list ~~ (0x1101, 0x1170, 0x11AB,), 'AFF4 -> 1101 1170 11AB';
ok Uni.new(0xAFF5).NFKD.list ~~ (0x1101, 0x1170, 0x11AC,), 'AFF5 -> 1101 1170 11AC';
ok Uni.new(0xAFF6).NFKD.list ~~ (0x1101, 0x1170, 0x11AD,), 'AFF6 -> 1101 1170 11AD';
ok Uni.new(0xAFF7).NFKD.list ~~ (0x1101, 0x1170, 0x11AE,), 'AFF7 -> 1101 1170 11AE';
ok Uni.new(0xAFF8).NFKD.list ~~ (0x1101, 0x1170, 0x11AF,), 'AFF8 -> 1101 1170 11AF';
ok Uni.new(0xAFF9).NFKD.list ~~ (0x1101, 0x1170, 0x11B0,), 'AFF9 -> 1101 1170 11B0';
ok Uni.new(0xAFFA).NFKD.list ~~ (0x1101, 0x1170, 0x11B1,), 'AFFA -> 1101 1170 11B1';
ok Uni.new(0xAFFB).NFKD.list ~~ (0x1101, 0x1170, 0x11B2,), 'AFFB -> 1101 1170 11B2';
ok Uni.new(0xAFFC).NFKD.list ~~ (0x1101, 0x1170, 0x11B3,), 'AFFC -> 1101 1170 11B3';
ok Uni.new(0xAFFD).NFKD.list ~~ (0x1101, 0x1170, 0x11B4,), 'AFFD -> 1101 1170 11B4';
ok Uni.new(0xAFFE).NFKD.list ~~ (0x1101, 0x1170, 0x11B5,), 'AFFE -> 1101 1170 11B5';
ok Uni.new(0xAFFF).NFKD.list ~~ (0x1101, 0x1170, 0x11B6,), 'AFFF -> 1101 1170 11B6';
ok Uni.new(0xB000).NFKD.list ~~ (0x1101, 0x1170, 0x11B7,), 'B000 -> 1101 1170 11B7';
ok Uni.new(0xB001).NFKD.list ~~ (0x1101, 0x1170, 0x11B8,), 'B001 -> 1101 1170 11B8';
ok Uni.new(0xB002).NFKD.list ~~ (0x1101, 0x1170, 0x11B9,), 'B002 -> 1101 1170 11B9';
ok Uni.new(0xB003).NFKD.list ~~ (0x1101, 0x1170, 0x11BA,), 'B003 -> 1101 1170 11BA';
ok Uni.new(0xB004).NFKD.list ~~ (0x1101, 0x1170, 0x11BB,), 'B004 -> 1101 1170 11BB';
ok Uni.new(0xB005).NFKD.list ~~ (0x1101, 0x1170, 0x11BC,), 'B005 -> 1101 1170 11BC';
ok Uni.new(0xB006).NFKD.list ~~ (0x1101, 0x1170, 0x11BD,), 'B006 -> 1101 1170 11BD';
ok Uni.new(0xB007).NFKD.list ~~ (0x1101, 0x1170, 0x11BE,), 'B007 -> 1101 1170 11BE';
ok Uni.new(0xB008).NFKD.list ~~ (0x1101, 0x1170, 0x11BF,), 'B008 -> 1101 1170 11BF';
ok Uni.new(0xB009).NFKD.list ~~ (0x1101, 0x1170, 0x11C0,), 'B009 -> 1101 1170 11C0';
ok Uni.new(0xB00A).NFKD.list ~~ (0x1101, 0x1170, 0x11C1,), 'B00A -> 1101 1170 11C1';
ok Uni.new(0xB00B).NFKD.list ~~ (0x1101, 0x1170, 0x11C2,), 'B00B -> 1101 1170 11C2';
ok Uni.new(0xB00C).NFKD.list ~~ (0x1101, 0x1171,), 'B00C -> 1101 1171';
ok Uni.new(0xB00D).NFKD.list ~~ (0x1101, 0x1171, 0x11A8,), 'B00D -> 1101 1171 11A8';
ok Uni.new(0xB00E).NFKD.list ~~ (0x1101, 0x1171, 0x11A9,), 'B00E -> 1101 1171 11A9';
ok Uni.new(0xB00F).NFKD.list ~~ (0x1101, 0x1171, 0x11AA,), 'B00F -> 1101 1171 11AA';
ok Uni.new(0xB010).NFKD.list ~~ (0x1101, 0x1171, 0x11AB,), 'B010 -> 1101 1171 11AB';
ok Uni.new(0xB011).NFKD.list ~~ (0x1101, 0x1171, 0x11AC,), 'B011 -> 1101 1171 11AC';
ok Uni.new(0xB012).NFKD.list ~~ (0x1101, 0x1171, 0x11AD,), 'B012 -> 1101 1171 11AD';
ok Uni.new(0xB013).NFKD.list ~~ (0x1101, 0x1171, 0x11AE,), 'B013 -> 1101 1171 11AE';
ok Uni.new(0xB014).NFKD.list ~~ (0x1101, 0x1171, 0x11AF,), 'B014 -> 1101 1171 11AF';
ok Uni.new(0xB015).NFKD.list ~~ (0x1101, 0x1171, 0x11B0,), 'B015 -> 1101 1171 11B0';
ok Uni.new(0xB016).NFKD.list ~~ (0x1101, 0x1171, 0x11B1,), 'B016 -> 1101 1171 11B1';
ok Uni.new(0xB017).NFKD.list ~~ (0x1101, 0x1171, 0x11B2,), 'B017 -> 1101 1171 11B2';
ok Uni.new(0xB018).NFKD.list ~~ (0x1101, 0x1171, 0x11B3,), 'B018 -> 1101 1171 11B3';
ok Uni.new(0xB019).NFKD.list ~~ (0x1101, 0x1171, 0x11B4,), 'B019 -> 1101 1171 11B4';
ok Uni.new(0xB01A).NFKD.list ~~ (0x1101, 0x1171, 0x11B5,), 'B01A -> 1101 1171 11B5';
ok Uni.new(0xB01B).NFKD.list ~~ (0x1101, 0x1171, 0x11B6,), 'B01B -> 1101 1171 11B6';
ok Uni.new(0xB01C).NFKD.list ~~ (0x1101, 0x1171, 0x11B7,), 'B01C -> 1101 1171 11B7';
ok Uni.new(0xB01D).NFKD.list ~~ (0x1101, 0x1171, 0x11B8,), 'B01D -> 1101 1171 11B8';
ok Uni.new(0xB01E).NFKD.list ~~ (0x1101, 0x1171, 0x11B9,), 'B01E -> 1101 1171 11B9';
ok Uni.new(0xB01F).NFKD.list ~~ (0x1101, 0x1171, 0x11BA,), 'B01F -> 1101 1171 11BA';
ok Uni.new(0xB020).NFKD.list ~~ (0x1101, 0x1171, 0x11BB,), 'B020 -> 1101 1171 11BB';
ok Uni.new(0xB021).NFKD.list ~~ (0x1101, 0x1171, 0x11BC,), 'B021 -> 1101 1171 11BC';
ok Uni.new(0xB022).NFKD.list ~~ (0x1101, 0x1171, 0x11BD,), 'B022 -> 1101 1171 11BD';
ok Uni.new(0xB023).NFKD.list ~~ (0x1101, 0x1171, 0x11BE,), 'B023 -> 1101 1171 11BE';
ok Uni.new(0xB024).NFKD.list ~~ (0x1101, 0x1171, 0x11BF,), 'B024 -> 1101 1171 11BF';
ok Uni.new(0xB025).NFKD.list ~~ (0x1101, 0x1171, 0x11C0,), 'B025 -> 1101 1171 11C0';
ok Uni.new(0xB026).NFKD.list ~~ (0x1101, 0x1171, 0x11C1,), 'B026 -> 1101 1171 11C1';
ok Uni.new(0xB027).NFKD.list ~~ (0x1101, 0x1171, 0x11C2,), 'B027 -> 1101 1171 11C2';
ok Uni.new(0xB028).NFKD.list ~~ (0x1101, 0x1172,), 'B028 -> 1101 1172';
ok Uni.new(0xB029).NFKD.list ~~ (0x1101, 0x1172, 0x11A8,), 'B029 -> 1101 1172 11A8';
ok Uni.new(0xB02A).NFKD.list ~~ (0x1101, 0x1172, 0x11A9,), 'B02A -> 1101 1172 11A9';
ok Uni.new(0xB02B).NFKD.list ~~ (0x1101, 0x1172, 0x11AA,), 'B02B -> 1101 1172 11AA';
ok Uni.new(0xB02C).NFKD.list ~~ (0x1101, 0x1172, 0x11AB,), 'B02C -> 1101 1172 11AB';
ok Uni.new(0xB02D).NFKD.list ~~ (0x1101, 0x1172, 0x11AC,), 'B02D -> 1101 1172 11AC';
ok Uni.new(0xB02E).NFKD.list ~~ (0x1101, 0x1172, 0x11AD,), 'B02E -> 1101 1172 11AD';
ok Uni.new(0xB02F).NFKD.list ~~ (0x1101, 0x1172, 0x11AE,), 'B02F -> 1101 1172 11AE';
ok Uni.new(0xB030).NFKD.list ~~ (0x1101, 0x1172, 0x11AF,), 'B030 -> 1101 1172 11AF';
ok Uni.new(0xB031).NFKD.list ~~ (0x1101, 0x1172, 0x11B0,), 'B031 -> 1101 1172 11B0';
ok Uni.new(0xB032).NFKD.list ~~ (0x1101, 0x1172, 0x11B1,), 'B032 -> 1101 1172 11B1';
ok Uni.new(0xB033).NFKD.list ~~ (0x1101, 0x1172, 0x11B2,), 'B033 -> 1101 1172 11B2';
ok Uni.new(0xB034).NFKD.list ~~ (0x1101, 0x1172, 0x11B3,), 'B034 -> 1101 1172 11B3';
ok Uni.new(0xB035).NFKD.list ~~ (0x1101, 0x1172, 0x11B4,), 'B035 -> 1101 1172 11B4';
ok Uni.new(0xB036).NFKD.list ~~ (0x1101, 0x1172, 0x11B5,), 'B036 -> 1101 1172 11B5';
ok Uni.new(0xB037).NFKD.list ~~ (0x1101, 0x1172, 0x11B6,), 'B037 -> 1101 1172 11B6';
ok Uni.new(0xB038).NFKD.list ~~ (0x1101, 0x1172, 0x11B7,), 'B038 -> 1101 1172 11B7';
ok Uni.new(0xB039).NFKD.list ~~ (0x1101, 0x1172, 0x11B8,), 'B039 -> 1101 1172 11B8';
ok Uni.new(0xB03A).NFKD.list ~~ (0x1101, 0x1172, 0x11B9,), 'B03A -> 1101 1172 11B9';
ok Uni.new(0xB03B).NFKD.list ~~ (0x1101, 0x1172, 0x11BA,), 'B03B -> 1101 1172 11BA';
ok Uni.new(0xB03C).NFKD.list ~~ (0x1101, 0x1172, 0x11BB,), 'B03C -> 1101 1172 11BB';
ok Uni.new(0xB03D).NFKD.list ~~ (0x1101, 0x1172, 0x11BC,), 'B03D -> 1101 1172 11BC';
ok Uni.new(0xB03E).NFKD.list ~~ (0x1101, 0x1172, 0x11BD,), 'B03E -> 1101 1172 11BD';
ok Uni.new(0xB03F).NFKD.list ~~ (0x1101, 0x1172, 0x11BE,), 'B03F -> 1101 1172 11BE';
ok Uni.new(0xB040).NFKD.list ~~ (0x1101, 0x1172, 0x11BF,), 'B040 -> 1101 1172 11BF';
ok Uni.new(0xB041).NFKD.list ~~ (0x1101, 0x1172, 0x11C0,), 'B041 -> 1101 1172 11C0';
ok Uni.new(0xB042).NFKD.list ~~ (0x1101, 0x1172, 0x11C1,), 'B042 -> 1101 1172 11C1';
ok Uni.new(0xB043).NFKD.list ~~ (0x1101, 0x1172, 0x11C2,), 'B043 -> 1101 1172 11C2';
ok Uni.new(0xB044).NFKD.list ~~ (0x1101, 0x1173,), 'B044 -> 1101 1173';
ok Uni.new(0xB045).NFKD.list ~~ (0x1101, 0x1173, 0x11A8,), 'B045 -> 1101 1173 11A8';
ok Uni.new(0xB046).NFKD.list ~~ (0x1101, 0x1173, 0x11A9,), 'B046 -> 1101 1173 11A9';
ok Uni.new(0xB047).NFKD.list ~~ (0x1101, 0x1173, 0x11AA,), 'B047 -> 1101 1173 11AA';
ok Uni.new(0xB048).NFKD.list ~~ (0x1101, 0x1173, 0x11AB,), 'B048 -> 1101 1173 11AB';
ok Uni.new(0xB049).NFKD.list ~~ (0x1101, 0x1173, 0x11AC,), 'B049 -> 1101 1173 11AC';
ok Uni.new(0xB04A).NFKD.list ~~ (0x1101, 0x1173, 0x11AD,), 'B04A -> 1101 1173 11AD';
ok Uni.new(0xB04B).NFKD.list ~~ (0x1101, 0x1173, 0x11AE,), 'B04B -> 1101 1173 11AE';
ok Uni.new(0xB04C).NFKD.list ~~ (0x1101, 0x1173, 0x11AF,), 'B04C -> 1101 1173 11AF';
ok Uni.new(0xB04D).NFKD.list ~~ (0x1101, 0x1173, 0x11B0,), 'B04D -> 1101 1173 11B0';
ok Uni.new(0xB04E).NFKD.list ~~ (0x1101, 0x1173, 0x11B1,), 'B04E -> 1101 1173 11B1';
ok Uni.new(0xB04F).NFKD.list ~~ (0x1101, 0x1173, 0x11B2,), 'B04F -> 1101 1173 11B2';
ok Uni.new(0xB050).NFKD.list ~~ (0x1101, 0x1173, 0x11B3,), 'B050 -> 1101 1173 11B3';
ok Uni.new(0xB051).NFKD.list ~~ (0x1101, 0x1173, 0x11B4,), 'B051 -> 1101 1173 11B4';
ok Uni.new(0xB052).NFKD.list ~~ (0x1101, 0x1173, 0x11B5,), 'B052 -> 1101 1173 11B5';
ok Uni.new(0xB053).NFKD.list ~~ (0x1101, 0x1173, 0x11B6,), 'B053 -> 1101 1173 11B6';
ok Uni.new(0xB054).NFKD.list ~~ (0x1101, 0x1173, 0x11B7,), 'B054 -> 1101 1173 11B7';
ok Uni.new(0xB055).NFKD.list ~~ (0x1101, 0x1173, 0x11B8,), 'B055 -> 1101 1173 11B8';
ok Uni.new(0xB056).NFKD.list ~~ (0x1101, 0x1173, 0x11B9,), 'B056 -> 1101 1173 11B9';
ok Uni.new(0xB057).NFKD.list ~~ (0x1101, 0x1173, 0x11BA,), 'B057 -> 1101 1173 11BA';
ok Uni.new(0xB058).NFKD.list ~~ (0x1101, 0x1173, 0x11BB,), 'B058 -> 1101 1173 11BB';
ok Uni.new(0xB059).NFKD.list ~~ (0x1101, 0x1173, 0x11BC,), 'B059 -> 1101 1173 11BC';
ok Uni.new(0xB05A).NFKD.list ~~ (0x1101, 0x1173, 0x11BD,), 'B05A -> 1101 1173 11BD';
ok Uni.new(0xB05B).NFKD.list ~~ (0x1101, 0x1173, 0x11BE,), 'B05B -> 1101 1173 11BE';
ok Uni.new(0xB05C).NFKD.list ~~ (0x1101, 0x1173, 0x11BF,), 'B05C -> 1101 1173 11BF';
ok Uni.new(0xB05D).NFKD.list ~~ (0x1101, 0x1173, 0x11C0,), 'B05D -> 1101 1173 11C0';
ok Uni.new(0xB05E).NFKD.list ~~ (0x1101, 0x1173, 0x11C1,), 'B05E -> 1101 1173 11C1';
ok Uni.new(0xB05F).NFKD.list ~~ (0x1101, 0x1173, 0x11C2,), 'B05F -> 1101 1173 11C2';
ok Uni.new(0xB060).NFKD.list ~~ (0x1101, 0x1174,), 'B060 -> 1101 1174';
ok Uni.new(0xB061).NFKD.list ~~ (0x1101, 0x1174, 0x11A8,), 'B061 -> 1101 1174 11A8';
ok Uni.new(0xB062).NFKD.list ~~ (0x1101, 0x1174, 0x11A9,), 'B062 -> 1101 1174 11A9';
ok Uni.new(0xB063).NFKD.list ~~ (0x1101, 0x1174, 0x11AA,), 'B063 -> 1101 1174 11AA';
ok Uni.new(0xB064).NFKD.list ~~ (0x1101, 0x1174, 0x11AB,), 'B064 -> 1101 1174 11AB';
ok Uni.new(0xB065).NFKD.list ~~ (0x1101, 0x1174, 0x11AC,), 'B065 -> 1101 1174 11AC';
ok Uni.new(0xB066).NFKD.list ~~ (0x1101, 0x1174, 0x11AD,), 'B066 -> 1101 1174 11AD';
ok Uni.new(0xB067).NFKD.list ~~ (0x1101, 0x1174, 0x11AE,), 'B067 -> 1101 1174 11AE';
ok Uni.new(0xB068).NFKD.list ~~ (0x1101, 0x1174, 0x11AF,), 'B068 -> 1101 1174 11AF';
ok Uni.new(0xB069).NFKD.list ~~ (0x1101, 0x1174, 0x11B0,), 'B069 -> 1101 1174 11B0';
ok Uni.new(0xB06A).NFKD.list ~~ (0x1101, 0x1174, 0x11B1,), 'B06A -> 1101 1174 11B1';
ok Uni.new(0xB06B).NFKD.list ~~ (0x1101, 0x1174, 0x11B2,), 'B06B -> 1101 1174 11B2';
ok Uni.new(0xB06C).NFKD.list ~~ (0x1101, 0x1174, 0x11B3,), 'B06C -> 1101 1174 11B3';
ok Uni.new(0xB06D).NFKD.list ~~ (0x1101, 0x1174, 0x11B4,), 'B06D -> 1101 1174 11B4';
ok Uni.new(0xB06E).NFKD.list ~~ (0x1101, 0x1174, 0x11B5,), 'B06E -> 1101 1174 11B5';
ok Uni.new(0xB06F).NFKD.list ~~ (0x1101, 0x1174, 0x11B6,), 'B06F -> 1101 1174 11B6';
ok Uni.new(0xB070).NFKD.list ~~ (0x1101, 0x1174, 0x11B7,), 'B070 -> 1101 1174 11B7';
ok Uni.new(0xB071).NFKD.list ~~ (0x1101, 0x1174, 0x11B8,), 'B071 -> 1101 1174 11B8';
ok Uni.new(0xB072).NFKD.list ~~ (0x1101, 0x1174, 0x11B9,), 'B072 -> 1101 1174 11B9';
ok Uni.new(0xB073).NFKD.list ~~ (0x1101, 0x1174, 0x11BA,), 'B073 -> 1101 1174 11BA';
ok Uni.new(0xB074).NFKD.list ~~ (0x1101, 0x1174, 0x11BB,), 'B074 -> 1101 1174 11BB';
ok Uni.new(0xB075).NFKD.list ~~ (0x1101, 0x1174, 0x11BC,), 'B075 -> 1101 1174 11BC';
ok Uni.new(0xB076).NFKD.list ~~ (0x1101, 0x1174, 0x11BD,), 'B076 -> 1101 1174 11BD';
ok Uni.new(0xB077).NFKD.list ~~ (0x1101, 0x1174, 0x11BE,), 'B077 -> 1101 1174 11BE';
ok Uni.new(0xB078).NFKD.list ~~ (0x1101, 0x1174, 0x11BF,), 'B078 -> 1101 1174 11BF';
ok Uni.new(0xB079).NFKD.list ~~ (0x1101, 0x1174, 0x11C0,), 'B079 -> 1101 1174 11C0';
ok Uni.new(0xB07A).NFKD.list ~~ (0x1101, 0x1174, 0x11C1,), 'B07A -> 1101 1174 11C1';
ok Uni.new(0xB07B).NFKD.list ~~ (0x1101, 0x1174, 0x11C2,), 'B07B -> 1101 1174 11C2';
ok Uni.new(0xB07C).NFKD.list ~~ (0x1101, 0x1175,), 'B07C -> 1101 1175';
ok Uni.new(0xB07D).NFKD.list ~~ (0x1101, 0x1175, 0x11A8,), 'B07D -> 1101 1175 11A8';
ok Uni.new(0xB07E).NFKD.list ~~ (0x1101, 0x1175, 0x11A9,), 'B07E -> 1101 1175 11A9';
ok Uni.new(0xB07F).NFKD.list ~~ (0x1101, 0x1175, 0x11AA,), 'B07F -> 1101 1175 11AA';
ok Uni.new(0xB080).NFKD.list ~~ (0x1101, 0x1175, 0x11AB,), 'B080 -> 1101 1175 11AB';
ok Uni.new(0xB081).NFKD.list ~~ (0x1101, 0x1175, 0x11AC,), 'B081 -> 1101 1175 11AC';
ok Uni.new(0xB082).NFKD.list ~~ (0x1101, 0x1175, 0x11AD,), 'B082 -> 1101 1175 11AD';
ok Uni.new(0xB083).NFKD.list ~~ (0x1101, 0x1175, 0x11AE,), 'B083 -> 1101 1175 11AE';
ok Uni.new(0xB084).NFKD.list ~~ (0x1101, 0x1175, 0x11AF,), 'B084 -> 1101 1175 11AF';
ok Uni.new(0xB085).NFKD.list ~~ (0x1101, 0x1175, 0x11B0,), 'B085 -> 1101 1175 11B0';
ok Uni.new(0xB086).NFKD.list ~~ (0x1101, 0x1175, 0x11B1,), 'B086 -> 1101 1175 11B1';
ok Uni.new(0xB087).NFKD.list ~~ (0x1101, 0x1175, 0x11B2,), 'B087 -> 1101 1175 11B2';
ok Uni.new(0xB088).NFKD.list ~~ (0x1101, 0x1175, 0x11B3,), 'B088 -> 1101 1175 11B3';
ok Uni.new(0xB089).NFKD.list ~~ (0x1101, 0x1175, 0x11B4,), 'B089 -> 1101 1175 11B4';
ok Uni.new(0xB08A).NFKD.list ~~ (0x1101, 0x1175, 0x11B5,), 'B08A -> 1101 1175 11B5';
ok Uni.new(0xB08B).NFKD.list ~~ (0x1101, 0x1175, 0x11B6,), 'B08B -> 1101 1175 11B6';
ok Uni.new(0xB08C).NFKD.list ~~ (0x1101, 0x1175, 0x11B7,), 'B08C -> 1101 1175 11B7';
ok Uni.new(0xB08D).NFKD.list ~~ (0x1101, 0x1175, 0x11B8,), 'B08D -> 1101 1175 11B8';
ok Uni.new(0xB08E).NFKD.list ~~ (0x1101, 0x1175, 0x11B9,), 'B08E -> 1101 1175 11B9';
ok Uni.new(0xB08F).NFKD.list ~~ (0x1101, 0x1175, 0x11BA,), 'B08F -> 1101 1175 11BA';
ok Uni.new(0xB090).NFKD.list ~~ (0x1101, 0x1175, 0x11BB,), 'B090 -> 1101 1175 11BB';
ok Uni.new(0xB091).NFKD.list ~~ (0x1101, 0x1175, 0x11BC,), 'B091 -> 1101 1175 11BC';
ok Uni.new(0xB092).NFKD.list ~~ (0x1101, 0x1175, 0x11BD,), 'B092 -> 1101 1175 11BD';
ok Uni.new(0xB093).NFKD.list ~~ (0x1101, 0x1175, 0x11BE,), 'B093 -> 1101 1175 11BE';
ok Uni.new(0xB094).NFKD.list ~~ (0x1101, 0x1175, 0x11BF,), 'B094 -> 1101 1175 11BF';
ok Uni.new(0xB095).NFKD.list ~~ (0x1101, 0x1175, 0x11C0,), 'B095 -> 1101 1175 11C0';
ok Uni.new(0xB096).NFKD.list ~~ (0x1101, 0x1175, 0x11C1,), 'B096 -> 1101 1175 11C1';
ok Uni.new(0xB097).NFKD.list ~~ (0x1101, 0x1175, 0x11C2,), 'B097 -> 1101 1175 11C2';
ok Uni.new(0xB098).NFKD.list ~~ (0x1102, 0x1161,), 'B098 -> 1102 1161';
ok Uni.new(0xB099).NFKD.list ~~ (0x1102, 0x1161, 0x11A8,), 'B099 -> 1102 1161 11A8';
ok Uni.new(0xB09A).NFKD.list ~~ (0x1102, 0x1161, 0x11A9,), 'B09A -> 1102 1161 11A9';
ok Uni.new(0xB09B).NFKD.list ~~ (0x1102, 0x1161, 0x11AA,), 'B09B -> 1102 1161 11AA';
ok Uni.new(0xB09C).NFKD.list ~~ (0x1102, 0x1161, 0x11AB,), 'B09C -> 1102 1161 11AB';
ok Uni.new(0xB09D).NFKD.list ~~ (0x1102, 0x1161, 0x11AC,), 'B09D -> 1102 1161 11AC';
ok Uni.new(0xB09E).NFKD.list ~~ (0x1102, 0x1161, 0x11AD,), 'B09E -> 1102 1161 11AD';
ok Uni.new(0xB09F).NFKD.list ~~ (0x1102, 0x1161, 0x11AE,), 'B09F -> 1102 1161 11AE';
ok Uni.new(0xB0A0).NFKD.list ~~ (0x1102, 0x1161, 0x11AF,), 'B0A0 -> 1102 1161 11AF';
ok Uni.new(0xB0A1).NFKD.list ~~ (0x1102, 0x1161, 0x11B0,), 'B0A1 -> 1102 1161 11B0';
ok Uni.new(0xB0A2).NFKD.list ~~ (0x1102, 0x1161, 0x11B1,), 'B0A2 -> 1102 1161 11B1';
ok Uni.new(0xB0A3).NFKD.list ~~ (0x1102, 0x1161, 0x11B2,), 'B0A3 -> 1102 1161 11B2';
ok Uni.new(0xB0A4).NFKD.list ~~ (0x1102, 0x1161, 0x11B3,), 'B0A4 -> 1102 1161 11B3';
ok Uni.new(0xB0A5).NFKD.list ~~ (0x1102, 0x1161, 0x11B4,), 'B0A5 -> 1102 1161 11B4';
ok Uni.new(0xB0A6).NFKD.list ~~ (0x1102, 0x1161, 0x11B5,), 'B0A6 -> 1102 1161 11B5';
ok Uni.new(0xB0A7).NFKD.list ~~ (0x1102, 0x1161, 0x11B6,), 'B0A7 -> 1102 1161 11B6';
ok Uni.new(0xB0A8).NFKD.list ~~ (0x1102, 0x1161, 0x11B7,), 'B0A8 -> 1102 1161 11B7';
ok Uni.new(0xB0A9).NFKD.list ~~ (0x1102, 0x1161, 0x11B8,), 'B0A9 -> 1102 1161 11B8';
ok Uni.new(0xB0AA).NFKD.list ~~ (0x1102, 0x1161, 0x11B9,), 'B0AA -> 1102 1161 11B9';
ok Uni.new(0xB0AB).NFKD.list ~~ (0x1102, 0x1161, 0x11BA,), 'B0AB -> 1102 1161 11BA';
ok Uni.new(0xB0AC).NFKD.list ~~ (0x1102, 0x1161, 0x11BB,), 'B0AC -> 1102 1161 11BB';
ok Uni.new(0xB0AD).NFKD.list ~~ (0x1102, 0x1161, 0x11BC,), 'B0AD -> 1102 1161 11BC';
ok Uni.new(0xB0AE).NFKD.list ~~ (0x1102, 0x1161, 0x11BD,), 'B0AE -> 1102 1161 11BD';
ok Uni.new(0xB0AF).NFKD.list ~~ (0x1102, 0x1161, 0x11BE,), 'B0AF -> 1102 1161 11BE';
ok Uni.new(0xB0B0).NFKD.list ~~ (0x1102, 0x1161, 0x11BF,), 'B0B0 -> 1102 1161 11BF';
ok Uni.new(0xB0B1).NFKD.list ~~ (0x1102, 0x1161, 0x11C0,), 'B0B1 -> 1102 1161 11C0';
ok Uni.new(0xB0B2).NFKD.list ~~ (0x1102, 0x1161, 0x11C1,), 'B0B2 -> 1102 1161 11C1';
ok Uni.new(0xB0B3).NFKD.list ~~ (0x1102, 0x1161, 0x11C2,), 'B0B3 -> 1102 1161 11C2';
ok Uni.new(0xB0B4).NFKD.list ~~ (0x1102, 0x1162,), 'B0B4 -> 1102 1162';
ok Uni.new(0xB0B5).NFKD.list ~~ (0x1102, 0x1162, 0x11A8,), 'B0B5 -> 1102 1162 11A8';
ok Uni.new(0xB0B6).NFKD.list ~~ (0x1102, 0x1162, 0x11A9,), 'B0B6 -> 1102 1162 11A9';
ok Uni.new(0xB0B7).NFKD.list ~~ (0x1102, 0x1162, 0x11AA,), 'B0B7 -> 1102 1162 11AA';
ok Uni.new(0xB0B8).NFKD.list ~~ (0x1102, 0x1162, 0x11AB,), 'B0B8 -> 1102 1162 11AB';
ok Uni.new(0xB0B9).NFKD.list ~~ (0x1102, 0x1162, 0x11AC,), 'B0B9 -> 1102 1162 11AC';
ok Uni.new(0xB0BA).NFKD.list ~~ (0x1102, 0x1162, 0x11AD,), 'B0BA -> 1102 1162 11AD';
ok Uni.new(0xB0BB).NFKD.list ~~ (0x1102, 0x1162, 0x11AE,), 'B0BB -> 1102 1162 11AE';
ok Uni.new(0xB0BC).NFKD.list ~~ (0x1102, 0x1162, 0x11AF,), 'B0BC -> 1102 1162 11AF';
ok Uni.new(0xB0BD).NFKD.list ~~ (0x1102, 0x1162, 0x11B0,), 'B0BD -> 1102 1162 11B0';
ok Uni.new(0xB0BE).NFKD.list ~~ (0x1102, 0x1162, 0x11B1,), 'B0BE -> 1102 1162 11B1';
ok Uni.new(0xB0BF).NFKD.list ~~ (0x1102, 0x1162, 0x11B2,), 'B0BF -> 1102 1162 11B2';
ok Uni.new(0xB0C0).NFKD.list ~~ (0x1102, 0x1162, 0x11B3,), 'B0C0 -> 1102 1162 11B3';
ok Uni.new(0xB0C1).NFKD.list ~~ (0x1102, 0x1162, 0x11B4,), 'B0C1 -> 1102 1162 11B4';
ok Uni.new(0xB0C2).NFKD.list ~~ (0x1102, 0x1162, 0x11B5,), 'B0C2 -> 1102 1162 11B5';
ok Uni.new(0xB0C3).NFKD.list ~~ (0x1102, 0x1162, 0x11B6,), 'B0C3 -> 1102 1162 11B6';
ok Uni.new(0xB0C4).NFKD.list ~~ (0x1102, 0x1162, 0x11B7,), 'B0C4 -> 1102 1162 11B7';
ok Uni.new(0xB0C5).NFKD.list ~~ (0x1102, 0x1162, 0x11B8,), 'B0C5 -> 1102 1162 11B8';
ok Uni.new(0xB0C6).NFKD.list ~~ (0x1102, 0x1162, 0x11B9,), 'B0C6 -> 1102 1162 11B9';
ok Uni.new(0xB0C7).NFKD.list ~~ (0x1102, 0x1162, 0x11BA,), 'B0C7 -> 1102 1162 11BA';
ok Uni.new(0xB0C8).NFKD.list ~~ (0x1102, 0x1162, 0x11BB,), 'B0C8 -> 1102 1162 11BB';
ok Uni.new(0xB0C9).NFKD.list ~~ (0x1102, 0x1162, 0x11BC,), 'B0C9 -> 1102 1162 11BC';
ok Uni.new(0xB0CA).NFKD.list ~~ (0x1102, 0x1162, 0x11BD,), 'B0CA -> 1102 1162 11BD';
ok Uni.new(0xB0CB).NFKD.list ~~ (0x1102, 0x1162, 0x11BE,), 'B0CB -> 1102 1162 11BE';
ok Uni.new(0xB0CC).NFKD.list ~~ (0x1102, 0x1162, 0x11BF,), 'B0CC -> 1102 1162 11BF';
ok Uni.new(0xB0CD).NFKD.list ~~ (0x1102, 0x1162, 0x11C0,), 'B0CD -> 1102 1162 11C0';
ok Uni.new(0xB0CE).NFKD.list ~~ (0x1102, 0x1162, 0x11C1,), 'B0CE -> 1102 1162 11C1';
ok Uni.new(0xB0CF).NFKD.list ~~ (0x1102, 0x1162, 0x11C2,), 'B0CF -> 1102 1162 11C2';
ok Uni.new(0xB0D0).NFKD.list ~~ (0x1102, 0x1163,), 'B0D0 -> 1102 1163';
ok Uni.new(0xB0D1).NFKD.list ~~ (0x1102, 0x1163, 0x11A8,), 'B0D1 -> 1102 1163 11A8';
ok Uni.new(0xB0D2).NFKD.list ~~ (0x1102, 0x1163, 0x11A9,), 'B0D2 -> 1102 1163 11A9';
ok Uni.new(0xB0D3).NFKD.list ~~ (0x1102, 0x1163, 0x11AA,), 'B0D3 -> 1102 1163 11AA';
ok Uni.new(0xB0D4).NFKD.list ~~ (0x1102, 0x1163, 0x11AB,), 'B0D4 -> 1102 1163 11AB';
ok Uni.new(0xB0D5).NFKD.list ~~ (0x1102, 0x1163, 0x11AC,), 'B0D5 -> 1102 1163 11AC';
ok Uni.new(0xB0D6).NFKD.list ~~ (0x1102, 0x1163, 0x11AD,), 'B0D6 -> 1102 1163 11AD';
ok Uni.new(0xB0D7).NFKD.list ~~ (0x1102, 0x1163, 0x11AE,), 'B0D7 -> 1102 1163 11AE';
ok Uni.new(0xB0D8).NFKD.list ~~ (0x1102, 0x1163, 0x11AF,), 'B0D8 -> 1102 1163 11AF';
ok Uni.new(0xB0D9).NFKD.list ~~ (0x1102, 0x1163, 0x11B0,), 'B0D9 -> 1102 1163 11B0';
ok Uni.new(0xB0DA).NFKD.list ~~ (0x1102, 0x1163, 0x11B1,), 'B0DA -> 1102 1163 11B1';
ok Uni.new(0xB0DB).NFKD.list ~~ (0x1102, 0x1163, 0x11B2,), 'B0DB -> 1102 1163 11B2';
ok Uni.new(0xB0DC).NFKD.list ~~ (0x1102, 0x1163, 0x11B3,), 'B0DC -> 1102 1163 11B3';
ok Uni.new(0xB0DD).NFKD.list ~~ (0x1102, 0x1163, 0x11B4,), 'B0DD -> 1102 1163 11B4';
ok Uni.new(0xB0DE).NFKD.list ~~ (0x1102, 0x1163, 0x11B5,), 'B0DE -> 1102 1163 11B5';
ok Uni.new(0xB0DF).NFKD.list ~~ (0x1102, 0x1163, 0x11B6,), 'B0DF -> 1102 1163 11B6';
ok Uni.new(0xB0E0).NFKD.list ~~ (0x1102, 0x1163, 0x11B7,), 'B0E0 -> 1102 1163 11B7';
ok Uni.new(0xB0E1).NFKD.list ~~ (0x1102, 0x1163, 0x11B8,), 'B0E1 -> 1102 1163 11B8';
ok Uni.new(0xB0E2).NFKD.list ~~ (0x1102, 0x1163, 0x11B9,), 'B0E2 -> 1102 1163 11B9';
ok Uni.new(0xB0E3).NFKD.list ~~ (0x1102, 0x1163, 0x11BA,), 'B0E3 -> 1102 1163 11BA';
ok Uni.new(0xB0E4).NFKD.list ~~ (0x1102, 0x1163, 0x11BB,), 'B0E4 -> 1102 1163 11BB';
ok Uni.new(0xB0E5).NFKD.list ~~ (0x1102, 0x1163, 0x11BC,), 'B0E5 -> 1102 1163 11BC';
ok Uni.new(0xB0E6).NFKD.list ~~ (0x1102, 0x1163, 0x11BD,), 'B0E6 -> 1102 1163 11BD';
ok Uni.new(0xB0E7).NFKD.list ~~ (0x1102, 0x1163, 0x11BE,), 'B0E7 -> 1102 1163 11BE';
ok Uni.new(0xB0E8).NFKD.list ~~ (0x1102, 0x1163, 0x11BF,), 'B0E8 -> 1102 1163 11BF';
ok Uni.new(0xB0E9).NFKD.list ~~ (0x1102, 0x1163, 0x11C0,), 'B0E9 -> 1102 1163 11C0';
ok Uni.new(0xB0EA).NFKD.list ~~ (0x1102, 0x1163, 0x11C1,), 'B0EA -> 1102 1163 11C1';
ok Uni.new(0xB0EB).NFKD.list ~~ (0x1102, 0x1163, 0x11C2,), 'B0EB -> 1102 1163 11C2';
ok Uni.new(0xB0EC).NFKD.list ~~ (0x1102, 0x1164,), 'B0EC -> 1102 1164';
ok Uni.new(0xB0ED).NFKD.list ~~ (0x1102, 0x1164, 0x11A8,), 'B0ED -> 1102 1164 11A8';
ok Uni.new(0xB0EE).NFKD.list ~~ (0x1102, 0x1164, 0x11A9,), 'B0EE -> 1102 1164 11A9';
ok Uni.new(0xB0EF).NFKD.list ~~ (0x1102, 0x1164, 0x11AA,), 'B0EF -> 1102 1164 11AA';
ok Uni.new(0xB0F0).NFKD.list ~~ (0x1102, 0x1164, 0x11AB,), 'B0F0 -> 1102 1164 11AB';
ok Uni.new(0xB0F1).NFKD.list ~~ (0x1102, 0x1164, 0x11AC,), 'B0F1 -> 1102 1164 11AC';
ok Uni.new(0xB0F2).NFKD.list ~~ (0x1102, 0x1164, 0x11AD,), 'B0F2 -> 1102 1164 11AD';
ok Uni.new(0xB0F3).NFKD.list ~~ (0x1102, 0x1164, 0x11AE,), 'B0F3 -> 1102 1164 11AE';
ok Uni.new(0xB0F4).NFKD.list ~~ (0x1102, 0x1164, 0x11AF,), 'B0F4 -> 1102 1164 11AF';
ok Uni.new(0xB0F5).NFKD.list ~~ (0x1102, 0x1164, 0x11B0,), 'B0F5 -> 1102 1164 11B0';
ok Uni.new(0xB0F6).NFKD.list ~~ (0x1102, 0x1164, 0x11B1,), 'B0F6 -> 1102 1164 11B1';
ok Uni.new(0xB0F7).NFKD.list ~~ (0x1102, 0x1164, 0x11B2,), 'B0F7 -> 1102 1164 11B2';
ok Uni.new(0xB0F8).NFKD.list ~~ (0x1102, 0x1164, 0x11B3,), 'B0F8 -> 1102 1164 11B3';
ok Uni.new(0xB0F9).NFKD.list ~~ (0x1102, 0x1164, 0x11B4,), 'B0F9 -> 1102 1164 11B4';
ok Uni.new(0xB0FA).NFKD.list ~~ (0x1102, 0x1164, 0x11B5,), 'B0FA -> 1102 1164 11B5';
ok Uni.new(0xB0FB).NFKD.list ~~ (0x1102, 0x1164, 0x11B6,), 'B0FB -> 1102 1164 11B6';
ok Uni.new(0xB0FC).NFKD.list ~~ (0x1102, 0x1164, 0x11B7,), 'B0FC -> 1102 1164 11B7';
ok Uni.new(0xB0FD).NFKD.list ~~ (0x1102, 0x1164, 0x11B8,), 'B0FD -> 1102 1164 11B8';
ok Uni.new(0xB0FE).NFKD.list ~~ (0x1102, 0x1164, 0x11B9,), 'B0FE -> 1102 1164 11B9';
ok Uni.new(0xB0FF).NFKD.list ~~ (0x1102, 0x1164, 0x11BA,), 'B0FF -> 1102 1164 11BA';
ok Uni.new(0xB100).NFKD.list ~~ (0x1102, 0x1164, 0x11BB,), 'B100 -> 1102 1164 11BB';
ok Uni.new(0xB101).NFKD.list ~~ (0x1102, 0x1164, 0x11BC,), 'B101 -> 1102 1164 11BC';
ok Uni.new(0xB102).NFKD.list ~~ (0x1102, 0x1164, 0x11BD,), 'B102 -> 1102 1164 11BD';
ok Uni.new(0xB103).NFKD.list ~~ (0x1102, 0x1164, 0x11BE,), 'B103 -> 1102 1164 11BE';
ok Uni.new(0xB104).NFKD.list ~~ (0x1102, 0x1164, 0x11BF,), 'B104 -> 1102 1164 11BF';
ok Uni.new(0xB105).NFKD.list ~~ (0x1102, 0x1164, 0x11C0,), 'B105 -> 1102 1164 11C0';
ok Uni.new(0xB106).NFKD.list ~~ (0x1102, 0x1164, 0x11C1,), 'B106 -> 1102 1164 11C1';
ok Uni.new(0xB107).NFKD.list ~~ (0x1102, 0x1164, 0x11C2,), 'B107 -> 1102 1164 11C2';
ok Uni.new(0xB108).NFKD.list ~~ (0x1102, 0x1165,), 'B108 -> 1102 1165';
ok Uni.new(0xB109).NFKD.list ~~ (0x1102, 0x1165, 0x11A8,), 'B109 -> 1102 1165 11A8';
ok Uni.new(0xB10A).NFKD.list ~~ (0x1102, 0x1165, 0x11A9,), 'B10A -> 1102 1165 11A9';
ok Uni.new(0xB10B).NFKD.list ~~ (0x1102, 0x1165, 0x11AA,), 'B10B -> 1102 1165 11AA';
ok Uni.new(0xB10C).NFKD.list ~~ (0x1102, 0x1165, 0x11AB,), 'B10C -> 1102 1165 11AB';
ok Uni.new(0xB10D).NFKD.list ~~ (0x1102, 0x1165, 0x11AC,), 'B10D -> 1102 1165 11AC';
ok Uni.new(0xB10E).NFKD.list ~~ (0x1102, 0x1165, 0x11AD,), 'B10E -> 1102 1165 11AD';
ok Uni.new(0xB10F).NFKD.list ~~ (0x1102, 0x1165, 0x11AE,), 'B10F -> 1102 1165 11AE';
ok Uni.new(0xB110).NFKD.list ~~ (0x1102, 0x1165, 0x11AF,), 'B110 -> 1102 1165 11AF';
ok Uni.new(0xB111).NFKD.list ~~ (0x1102, 0x1165, 0x11B0,), 'B111 -> 1102 1165 11B0';
ok Uni.new(0xB112).NFKD.list ~~ (0x1102, 0x1165, 0x11B1,), 'B112 -> 1102 1165 11B1';
ok Uni.new(0xB113).NFKD.list ~~ (0x1102, 0x1165, 0x11B2,), 'B113 -> 1102 1165 11B2';
ok Uni.new(0xB114).NFKD.list ~~ (0x1102, 0x1165, 0x11B3,), 'B114 -> 1102 1165 11B3';
ok Uni.new(0xB115).NFKD.list ~~ (0x1102, 0x1165, 0x11B4,), 'B115 -> 1102 1165 11B4';
ok Uni.new(0xB116).NFKD.list ~~ (0x1102, 0x1165, 0x11B5,), 'B116 -> 1102 1165 11B5';
ok Uni.new(0xB117).NFKD.list ~~ (0x1102, 0x1165, 0x11B6,), 'B117 -> 1102 1165 11B6';
ok Uni.new(0xB118).NFKD.list ~~ (0x1102, 0x1165, 0x11B7,), 'B118 -> 1102 1165 11B7';
ok Uni.new(0xB119).NFKD.list ~~ (0x1102, 0x1165, 0x11B8,), 'B119 -> 1102 1165 11B8';
ok Uni.new(0xB11A).NFKD.list ~~ (0x1102, 0x1165, 0x11B9,), 'B11A -> 1102 1165 11B9';
ok Uni.new(0xB11B).NFKD.list ~~ (0x1102, 0x1165, 0x11BA,), 'B11B -> 1102 1165 11BA';
ok Uni.new(0xB11C).NFKD.list ~~ (0x1102, 0x1165, 0x11BB,), 'B11C -> 1102 1165 11BB';
ok Uni.new(0xB11D).NFKD.list ~~ (0x1102, 0x1165, 0x11BC,), 'B11D -> 1102 1165 11BC';
ok Uni.new(0xB11E).NFKD.list ~~ (0x1102, 0x1165, 0x11BD,), 'B11E -> 1102 1165 11BD';
ok Uni.new(0xB11F).NFKD.list ~~ (0x1102, 0x1165, 0x11BE,), 'B11F -> 1102 1165 11BE';
ok Uni.new(0xB120).NFKD.list ~~ (0x1102, 0x1165, 0x11BF,), 'B120 -> 1102 1165 11BF';
ok Uni.new(0xB121).NFKD.list ~~ (0x1102, 0x1165, 0x11C0,), 'B121 -> 1102 1165 11C0';
ok Uni.new(0xB122).NFKD.list ~~ (0x1102, 0x1165, 0x11C1,), 'B122 -> 1102 1165 11C1';
ok Uni.new(0xB123).NFKD.list ~~ (0x1102, 0x1165, 0x11C2,), 'B123 -> 1102 1165 11C2';
ok Uni.new(0xB124).NFKD.list ~~ (0x1102, 0x1166,), 'B124 -> 1102 1166';
ok Uni.new(0xB125).NFKD.list ~~ (0x1102, 0x1166, 0x11A8,), 'B125 -> 1102 1166 11A8';
ok Uni.new(0xB126).NFKD.list ~~ (0x1102, 0x1166, 0x11A9,), 'B126 -> 1102 1166 11A9';
ok Uni.new(0xB127).NFKD.list ~~ (0x1102, 0x1166, 0x11AA,), 'B127 -> 1102 1166 11AA';
ok Uni.new(0xB128).NFKD.list ~~ (0x1102, 0x1166, 0x11AB,), 'B128 -> 1102 1166 11AB';
ok Uni.new(0xB129).NFKD.list ~~ (0x1102, 0x1166, 0x11AC,), 'B129 -> 1102 1166 11AC';
ok Uni.new(0xB12A).NFKD.list ~~ (0x1102, 0x1166, 0x11AD,), 'B12A -> 1102 1166 11AD';
ok Uni.new(0xB12B).NFKD.list ~~ (0x1102, 0x1166, 0x11AE,), 'B12B -> 1102 1166 11AE';
ok Uni.new(0xB12C).NFKD.list ~~ (0x1102, 0x1166, 0x11AF,), 'B12C -> 1102 1166 11AF';
ok Uni.new(0xB12D).NFKD.list ~~ (0x1102, 0x1166, 0x11B0,), 'B12D -> 1102 1166 11B0';
ok Uni.new(0xB12E).NFKD.list ~~ (0x1102, 0x1166, 0x11B1,), 'B12E -> 1102 1166 11B1';
ok Uni.new(0xB12F).NFKD.list ~~ (0x1102, 0x1166, 0x11B2,), 'B12F -> 1102 1166 11B2';
ok Uni.new(0xB130).NFKD.list ~~ (0x1102, 0x1166, 0x11B3,), 'B130 -> 1102 1166 11B3';
ok Uni.new(0xB131).NFKD.list ~~ (0x1102, 0x1166, 0x11B4,), 'B131 -> 1102 1166 11B4';
ok Uni.new(0xB132).NFKD.list ~~ (0x1102, 0x1166, 0x11B5,), 'B132 -> 1102 1166 11B5';
ok Uni.new(0xB133).NFKD.list ~~ (0x1102, 0x1166, 0x11B6,), 'B133 -> 1102 1166 11B6';
ok Uni.new(0xB134).NFKD.list ~~ (0x1102, 0x1166, 0x11B7,), 'B134 -> 1102 1166 11B7';
ok Uni.new(0xB135).NFKD.list ~~ (0x1102, 0x1166, 0x11B8,), 'B135 -> 1102 1166 11B8';
ok Uni.new(0xB136).NFKD.list ~~ (0x1102, 0x1166, 0x11B9,), 'B136 -> 1102 1166 11B9';
ok Uni.new(0xB137).NFKD.list ~~ (0x1102, 0x1166, 0x11BA,), 'B137 -> 1102 1166 11BA';
ok Uni.new(0xB138).NFKD.list ~~ (0x1102, 0x1166, 0x11BB,), 'B138 -> 1102 1166 11BB';
ok Uni.new(0xB139).NFKD.list ~~ (0x1102, 0x1166, 0x11BC,), 'B139 -> 1102 1166 11BC';
ok Uni.new(0xB13A).NFKD.list ~~ (0x1102, 0x1166, 0x11BD,), 'B13A -> 1102 1166 11BD';
ok Uni.new(0xB13B).NFKD.list ~~ (0x1102, 0x1166, 0x11BE,), 'B13B -> 1102 1166 11BE';
ok Uni.new(0xB13C).NFKD.list ~~ (0x1102, 0x1166, 0x11BF,), 'B13C -> 1102 1166 11BF';
ok Uni.new(0xB13D).NFKD.list ~~ (0x1102, 0x1166, 0x11C0,), 'B13D -> 1102 1166 11C0';
ok Uni.new(0xB13E).NFKD.list ~~ (0x1102, 0x1166, 0x11C1,), 'B13E -> 1102 1166 11C1';
ok Uni.new(0xB13F).NFKD.list ~~ (0x1102, 0x1166, 0x11C2,), 'B13F -> 1102 1166 11C2';
ok Uni.new(0xB140).NFKD.list ~~ (0x1102, 0x1167,), 'B140 -> 1102 1167';
ok Uni.new(0xB141).NFKD.list ~~ (0x1102, 0x1167, 0x11A8,), 'B141 -> 1102 1167 11A8';
ok Uni.new(0xB142).NFKD.list ~~ (0x1102, 0x1167, 0x11A9,), 'B142 -> 1102 1167 11A9';
ok Uni.new(0xB143).NFKD.list ~~ (0x1102, 0x1167, 0x11AA,), 'B143 -> 1102 1167 11AA';
ok Uni.new(0xB144).NFKD.list ~~ (0x1102, 0x1167, 0x11AB,), 'B144 -> 1102 1167 11AB';
ok Uni.new(0xB145).NFKD.list ~~ (0x1102, 0x1167, 0x11AC,), 'B145 -> 1102 1167 11AC';
ok Uni.new(0xB146).NFKD.list ~~ (0x1102, 0x1167, 0x11AD,), 'B146 -> 1102 1167 11AD';
ok Uni.new(0xB147).NFKD.list ~~ (0x1102, 0x1167, 0x11AE,), 'B147 -> 1102 1167 11AE';
ok Uni.new(0xB148).NFKD.list ~~ (0x1102, 0x1167, 0x11AF,), 'B148 -> 1102 1167 11AF';
ok Uni.new(0xB149).NFKD.list ~~ (0x1102, 0x1167, 0x11B0,), 'B149 -> 1102 1167 11B0';
ok Uni.new(0xB14A).NFKD.list ~~ (0x1102, 0x1167, 0x11B1,), 'B14A -> 1102 1167 11B1';
ok Uni.new(0xB14B).NFKD.list ~~ (0x1102, 0x1167, 0x11B2,), 'B14B -> 1102 1167 11B2';
ok Uni.new(0xB14C).NFKD.list ~~ (0x1102, 0x1167, 0x11B3,), 'B14C -> 1102 1167 11B3';
ok Uni.new(0xB14D).NFKD.list ~~ (0x1102, 0x1167, 0x11B4,), 'B14D -> 1102 1167 11B4';
ok Uni.new(0xB14E).NFKD.list ~~ (0x1102, 0x1167, 0x11B5,), 'B14E -> 1102 1167 11B5';
ok Uni.new(0xB14F).NFKD.list ~~ (0x1102, 0x1167, 0x11B6,), 'B14F -> 1102 1167 11B6';
ok Uni.new(0xB150).NFKD.list ~~ (0x1102, 0x1167, 0x11B7,), 'B150 -> 1102 1167 11B7';
ok Uni.new(0xB151).NFKD.list ~~ (0x1102, 0x1167, 0x11B8,), 'B151 -> 1102 1167 11B8';
ok Uni.new(0xB152).NFKD.list ~~ (0x1102, 0x1167, 0x11B9,), 'B152 -> 1102 1167 11B9';
ok Uni.new(0xB153).NFKD.list ~~ (0x1102, 0x1167, 0x11BA,), 'B153 -> 1102 1167 11BA';
ok Uni.new(0xB154).NFKD.list ~~ (0x1102, 0x1167, 0x11BB,), 'B154 -> 1102 1167 11BB';
ok Uni.new(0xB155).NFKD.list ~~ (0x1102, 0x1167, 0x11BC,), 'B155 -> 1102 1167 11BC';
ok Uni.new(0xB156).NFKD.list ~~ (0x1102, 0x1167, 0x11BD,), 'B156 -> 1102 1167 11BD';
ok Uni.new(0xB157).NFKD.list ~~ (0x1102, 0x1167, 0x11BE,), 'B157 -> 1102 1167 11BE';
ok Uni.new(0xB158).NFKD.list ~~ (0x1102, 0x1167, 0x11BF,), 'B158 -> 1102 1167 11BF';
ok Uni.new(0xB159).NFKD.list ~~ (0x1102, 0x1167, 0x11C0,), 'B159 -> 1102 1167 11C0';
ok Uni.new(0xB15A).NFKD.list ~~ (0x1102, 0x1167, 0x11C1,), 'B15A -> 1102 1167 11C1';
ok Uni.new(0xB15B).NFKD.list ~~ (0x1102, 0x1167, 0x11C2,), 'B15B -> 1102 1167 11C2';
ok Uni.new(0xB15C).NFKD.list ~~ (0x1102, 0x1168,), 'B15C -> 1102 1168';
ok Uni.new(0xB15D).NFKD.list ~~ (0x1102, 0x1168, 0x11A8,), 'B15D -> 1102 1168 11A8';
ok Uni.new(0xB15E).NFKD.list ~~ (0x1102, 0x1168, 0x11A9,), 'B15E -> 1102 1168 11A9';
ok Uni.new(0xB15F).NFKD.list ~~ (0x1102, 0x1168, 0x11AA,), 'B15F -> 1102 1168 11AA';
ok Uni.new(0xB160).NFKD.list ~~ (0x1102, 0x1168, 0x11AB,), 'B160 -> 1102 1168 11AB';
ok Uni.new(0xB161).NFKD.list ~~ (0x1102, 0x1168, 0x11AC,), 'B161 -> 1102 1168 11AC';
ok Uni.new(0xB162).NFKD.list ~~ (0x1102, 0x1168, 0x11AD,), 'B162 -> 1102 1168 11AD';
ok Uni.new(0xB163).NFKD.list ~~ (0x1102, 0x1168, 0x11AE,), 'B163 -> 1102 1168 11AE';
ok Uni.new(0xB164).NFKD.list ~~ (0x1102, 0x1168, 0x11AF,), 'B164 -> 1102 1168 11AF';
ok Uni.new(0xB165).NFKD.list ~~ (0x1102, 0x1168, 0x11B0,), 'B165 -> 1102 1168 11B0';
ok Uni.new(0xB166).NFKD.list ~~ (0x1102, 0x1168, 0x11B1,), 'B166 -> 1102 1168 11B1';
ok Uni.new(0xB167).NFKD.list ~~ (0x1102, 0x1168, 0x11B2,), 'B167 -> 1102 1168 11B2';
ok Uni.new(0xB168).NFKD.list ~~ (0x1102, 0x1168, 0x11B3,), 'B168 -> 1102 1168 11B3';
ok Uni.new(0xB169).NFKD.list ~~ (0x1102, 0x1168, 0x11B4,), 'B169 -> 1102 1168 11B4';
ok Uni.new(0xB16A).NFKD.list ~~ (0x1102, 0x1168, 0x11B5,), 'B16A -> 1102 1168 11B5';
ok Uni.new(0xB16B).NFKD.list ~~ (0x1102, 0x1168, 0x11B6,), 'B16B -> 1102 1168 11B6';
ok Uni.new(0xB16C).NFKD.list ~~ (0x1102, 0x1168, 0x11B7,), 'B16C -> 1102 1168 11B7';
ok Uni.new(0xB16D).NFKD.list ~~ (0x1102, 0x1168, 0x11B8,), 'B16D -> 1102 1168 11B8';
ok Uni.new(0xB16E).NFKD.list ~~ (0x1102, 0x1168, 0x11B9,), 'B16E -> 1102 1168 11B9';
ok Uni.new(0xB16F).NFKD.list ~~ (0x1102, 0x1168, 0x11BA,), 'B16F -> 1102 1168 11BA';
ok Uni.new(0xB170).NFKD.list ~~ (0x1102, 0x1168, 0x11BB,), 'B170 -> 1102 1168 11BB';
ok Uni.new(0xB171).NFKD.list ~~ (0x1102, 0x1168, 0x11BC,), 'B171 -> 1102 1168 11BC';
ok Uni.new(0xB172).NFKD.list ~~ (0x1102, 0x1168, 0x11BD,), 'B172 -> 1102 1168 11BD';
ok Uni.new(0xB173).NFKD.list ~~ (0x1102, 0x1168, 0x11BE,), 'B173 -> 1102 1168 11BE';
ok Uni.new(0xB174).NFKD.list ~~ (0x1102, 0x1168, 0x11BF,), 'B174 -> 1102 1168 11BF';
ok Uni.new(0xB175).NFKD.list ~~ (0x1102, 0x1168, 0x11C0,), 'B175 -> 1102 1168 11C0';
ok Uni.new(0xB176).NFKD.list ~~ (0x1102, 0x1168, 0x11C1,), 'B176 -> 1102 1168 11C1';
ok Uni.new(0xB177).NFKD.list ~~ (0x1102, 0x1168, 0x11C2,), 'B177 -> 1102 1168 11C2';
ok Uni.new(0xB178).NFKD.list ~~ (0x1102, 0x1169,), 'B178 -> 1102 1169';
ok Uni.new(0xB179).NFKD.list ~~ (0x1102, 0x1169, 0x11A8,), 'B179 -> 1102 1169 11A8';
ok Uni.new(0xB17A).NFKD.list ~~ (0x1102, 0x1169, 0x11A9,), 'B17A -> 1102 1169 11A9';
ok Uni.new(0xB17B).NFKD.list ~~ (0x1102, 0x1169, 0x11AA,), 'B17B -> 1102 1169 11AA';
ok Uni.new(0xB17C).NFKD.list ~~ (0x1102, 0x1169, 0x11AB,), 'B17C -> 1102 1169 11AB';
ok Uni.new(0xB17D).NFKD.list ~~ (0x1102, 0x1169, 0x11AC,), 'B17D -> 1102 1169 11AC';
ok Uni.new(0xB17E).NFKD.list ~~ (0x1102, 0x1169, 0x11AD,), 'B17E -> 1102 1169 11AD';
ok Uni.new(0xB17F).NFKD.list ~~ (0x1102, 0x1169, 0x11AE,), 'B17F -> 1102 1169 11AE';
ok Uni.new(0xB180).NFKD.list ~~ (0x1102, 0x1169, 0x11AF,), 'B180 -> 1102 1169 11AF';
ok Uni.new(0xB181).NFKD.list ~~ (0x1102, 0x1169, 0x11B0,), 'B181 -> 1102 1169 11B0';
ok Uni.new(0xB182).NFKD.list ~~ (0x1102, 0x1169, 0x11B1,), 'B182 -> 1102 1169 11B1';
ok Uni.new(0xB183).NFKD.list ~~ (0x1102, 0x1169, 0x11B2,), 'B183 -> 1102 1169 11B2';
ok Uni.new(0xB184).NFKD.list ~~ (0x1102, 0x1169, 0x11B3,), 'B184 -> 1102 1169 11B3';
ok Uni.new(0xB185).NFKD.list ~~ (0x1102, 0x1169, 0x11B4,), 'B185 -> 1102 1169 11B4';
ok Uni.new(0xB186).NFKD.list ~~ (0x1102, 0x1169, 0x11B5,), 'B186 -> 1102 1169 11B5';
ok Uni.new(0xB187).NFKD.list ~~ (0x1102, 0x1169, 0x11B6,), 'B187 -> 1102 1169 11B6';
ok Uni.new(0xB188).NFKD.list ~~ (0x1102, 0x1169, 0x11B7,), 'B188 -> 1102 1169 11B7';
ok Uni.new(0xB189).NFKD.list ~~ (0x1102, 0x1169, 0x11B8,), 'B189 -> 1102 1169 11B8';
ok Uni.new(0xB18A).NFKD.list ~~ (0x1102, 0x1169, 0x11B9,), 'B18A -> 1102 1169 11B9';
ok Uni.new(0xB18B).NFKD.list ~~ (0x1102, 0x1169, 0x11BA,), 'B18B -> 1102 1169 11BA';
ok Uni.new(0xB18C).NFKD.list ~~ (0x1102, 0x1169, 0x11BB,), 'B18C -> 1102 1169 11BB';
ok Uni.new(0xB18D).NFKD.list ~~ (0x1102, 0x1169, 0x11BC,), 'B18D -> 1102 1169 11BC';
ok Uni.new(0xB18E).NFKD.list ~~ (0x1102, 0x1169, 0x11BD,), 'B18E -> 1102 1169 11BD';
ok Uni.new(0xB18F).NFKD.list ~~ (0x1102, 0x1169, 0x11BE,), 'B18F -> 1102 1169 11BE';
ok Uni.new(0xB190).NFKD.list ~~ (0x1102, 0x1169, 0x11BF,), 'B190 -> 1102 1169 11BF';
ok Uni.new(0xB191).NFKD.list ~~ (0x1102, 0x1169, 0x11C0,), 'B191 -> 1102 1169 11C0';
ok Uni.new(0xB192).NFKD.list ~~ (0x1102, 0x1169, 0x11C1,), 'B192 -> 1102 1169 11C1';
ok Uni.new(0xB193).NFKD.list ~~ (0x1102, 0x1169, 0x11C2,), 'B193 -> 1102 1169 11C2';
ok Uni.new(0xB194).NFKD.list ~~ (0x1102, 0x116A,), 'B194 -> 1102 116A';
ok Uni.new(0xB195).NFKD.list ~~ (0x1102, 0x116A, 0x11A8,), 'B195 -> 1102 116A 11A8';
ok Uni.new(0xB196).NFKD.list ~~ (0x1102, 0x116A, 0x11A9,), 'B196 -> 1102 116A 11A9';
ok Uni.new(0xB197).NFKD.list ~~ (0x1102, 0x116A, 0x11AA,), 'B197 -> 1102 116A 11AA';
ok Uni.new(0xB198).NFKD.list ~~ (0x1102, 0x116A, 0x11AB,), 'B198 -> 1102 116A 11AB';
ok Uni.new(0xB199).NFKD.list ~~ (0x1102, 0x116A, 0x11AC,), 'B199 -> 1102 116A 11AC';
ok Uni.new(0xB19A).NFKD.list ~~ (0x1102, 0x116A, 0x11AD,), 'B19A -> 1102 116A 11AD';
ok Uni.new(0xB19B).NFKD.list ~~ (0x1102, 0x116A, 0x11AE,), 'B19B -> 1102 116A 11AE';
ok Uni.new(0xB19C).NFKD.list ~~ (0x1102, 0x116A, 0x11AF,), 'B19C -> 1102 116A 11AF';
ok Uni.new(0xB19D).NFKD.list ~~ (0x1102, 0x116A, 0x11B0,), 'B19D -> 1102 116A 11B0';
ok Uni.new(0xB19E).NFKD.list ~~ (0x1102, 0x116A, 0x11B1,), 'B19E -> 1102 116A 11B1';
ok Uni.new(0xB19F).NFKD.list ~~ (0x1102, 0x116A, 0x11B2,), 'B19F -> 1102 116A 11B2';
ok Uni.new(0xB1A0).NFKD.list ~~ (0x1102, 0x116A, 0x11B3,), 'B1A0 -> 1102 116A 11B3';
ok Uni.new(0xB1A1).NFKD.list ~~ (0x1102, 0x116A, 0x11B4,), 'B1A1 -> 1102 116A 11B4';
ok Uni.new(0xB1A2).NFKD.list ~~ (0x1102, 0x116A, 0x11B5,), 'B1A2 -> 1102 116A 11B5';
ok Uni.new(0xB1A3).NFKD.list ~~ (0x1102, 0x116A, 0x11B6,), 'B1A3 -> 1102 116A 11B6';
ok Uni.new(0xB1A4).NFKD.list ~~ (0x1102, 0x116A, 0x11B7,), 'B1A4 -> 1102 116A 11B7';
ok Uni.new(0xB1A5).NFKD.list ~~ (0x1102, 0x116A, 0x11B8,), 'B1A5 -> 1102 116A 11B8';
ok Uni.new(0xB1A6).NFKD.list ~~ (0x1102, 0x116A, 0x11B9,), 'B1A6 -> 1102 116A 11B9';
ok Uni.new(0xB1A7).NFKD.list ~~ (0x1102, 0x116A, 0x11BA,), 'B1A7 -> 1102 116A 11BA';
ok Uni.new(0xB1A8).NFKD.list ~~ (0x1102, 0x116A, 0x11BB,), 'B1A8 -> 1102 116A 11BB';
ok Uni.new(0xB1A9).NFKD.list ~~ (0x1102, 0x116A, 0x11BC,), 'B1A9 -> 1102 116A 11BC';
ok Uni.new(0xB1AA).NFKD.list ~~ (0x1102, 0x116A, 0x11BD,), 'B1AA -> 1102 116A 11BD';
ok Uni.new(0xB1AB).NFKD.list ~~ (0x1102, 0x116A, 0x11BE,), 'B1AB -> 1102 116A 11BE';
ok Uni.new(0xB1AC).NFKD.list ~~ (0x1102, 0x116A, 0x11BF,), 'B1AC -> 1102 116A 11BF';
ok Uni.new(0xB1AD).NFKD.list ~~ (0x1102, 0x116A, 0x11C0,), 'B1AD -> 1102 116A 11C0';
ok Uni.new(0xB1AE).NFKD.list ~~ (0x1102, 0x116A, 0x11C1,), 'B1AE -> 1102 116A 11C1';
ok Uni.new(0xB1AF).NFKD.list ~~ (0x1102, 0x116A, 0x11C2,), 'B1AF -> 1102 116A 11C2';
ok Uni.new(0xB1B0).NFKD.list ~~ (0x1102, 0x116B,), 'B1B0 -> 1102 116B';
ok Uni.new(0xB1B1).NFKD.list ~~ (0x1102, 0x116B, 0x11A8,), 'B1B1 -> 1102 116B 11A8';
ok Uni.new(0xB1B2).NFKD.list ~~ (0x1102, 0x116B, 0x11A9,), 'B1B2 -> 1102 116B 11A9';
ok Uni.new(0xB1B3).NFKD.list ~~ (0x1102, 0x116B, 0x11AA,), 'B1B3 -> 1102 116B 11AA';
ok Uni.new(0xB1B4).NFKD.list ~~ (0x1102, 0x116B, 0x11AB,), 'B1B4 -> 1102 116B 11AB';
ok Uni.new(0xB1B5).NFKD.list ~~ (0x1102, 0x116B, 0x11AC,), 'B1B5 -> 1102 116B 11AC';
ok Uni.new(0xB1B6).NFKD.list ~~ (0x1102, 0x116B, 0x11AD,), 'B1B6 -> 1102 116B 11AD';
ok Uni.new(0xB1B7).NFKD.list ~~ (0x1102, 0x116B, 0x11AE,), 'B1B7 -> 1102 116B 11AE';
ok Uni.new(0xB1B8).NFKD.list ~~ (0x1102, 0x116B, 0x11AF,), 'B1B8 -> 1102 116B 11AF';
ok Uni.new(0xB1B9).NFKD.list ~~ (0x1102, 0x116B, 0x11B0,), 'B1B9 -> 1102 116B 11B0';
ok Uni.new(0xB1BA).NFKD.list ~~ (0x1102, 0x116B, 0x11B1,), 'B1BA -> 1102 116B 11B1';
ok Uni.new(0xB1BB).NFKD.list ~~ (0x1102, 0x116B, 0x11B2,), 'B1BB -> 1102 116B 11B2';
ok Uni.new(0xB1BC).NFKD.list ~~ (0x1102, 0x116B, 0x11B3,), 'B1BC -> 1102 116B 11B3';
ok Uni.new(0xB1BD).NFKD.list ~~ (0x1102, 0x116B, 0x11B4,), 'B1BD -> 1102 116B 11B4';
ok Uni.new(0xB1BE).NFKD.list ~~ (0x1102, 0x116B, 0x11B5,), 'B1BE -> 1102 116B 11B5';
ok Uni.new(0xB1BF).NFKD.list ~~ (0x1102, 0x116B, 0x11B6,), 'B1BF -> 1102 116B 11B6';
ok Uni.new(0xB1C0).NFKD.list ~~ (0x1102, 0x116B, 0x11B7,), 'B1C0 -> 1102 116B 11B7';
ok Uni.new(0xB1C1).NFKD.list ~~ (0x1102, 0x116B, 0x11B8,), 'B1C1 -> 1102 116B 11B8';
ok Uni.new(0xB1C2).NFKD.list ~~ (0x1102, 0x116B, 0x11B9,), 'B1C2 -> 1102 116B 11B9';
ok Uni.new(0xB1C3).NFKD.list ~~ (0x1102, 0x116B, 0x11BA,), 'B1C3 -> 1102 116B 11BA';
ok Uni.new(0xB1C4).NFKD.list ~~ (0x1102, 0x116B, 0x11BB,), 'B1C4 -> 1102 116B 11BB';
ok Uni.new(0xB1C5).NFKD.list ~~ (0x1102, 0x116B, 0x11BC,), 'B1C5 -> 1102 116B 11BC';
ok Uni.new(0xB1C6).NFKD.list ~~ (0x1102, 0x116B, 0x11BD,), 'B1C6 -> 1102 116B 11BD';
ok Uni.new(0xB1C7).NFKD.list ~~ (0x1102, 0x116B, 0x11BE,), 'B1C7 -> 1102 116B 11BE';
ok Uni.new(0xB1C8).NFKD.list ~~ (0x1102, 0x116B, 0x11BF,), 'B1C8 -> 1102 116B 11BF';
ok Uni.new(0xB1C9).NFKD.list ~~ (0x1102, 0x116B, 0x11C0,), 'B1C9 -> 1102 116B 11C0';
ok Uni.new(0xB1CA).NFKD.list ~~ (0x1102, 0x116B, 0x11C1,), 'B1CA -> 1102 116B 11C1';
ok Uni.new(0xB1CB).NFKD.list ~~ (0x1102, 0x116B, 0x11C2,), 'B1CB -> 1102 116B 11C2';
ok Uni.new(0xB1CC).NFKD.list ~~ (0x1102, 0x116C,), 'B1CC -> 1102 116C';
ok Uni.new(0xB1CD).NFKD.list ~~ (0x1102, 0x116C, 0x11A8,), 'B1CD -> 1102 116C 11A8';
ok Uni.new(0xB1CE).NFKD.list ~~ (0x1102, 0x116C, 0x11A9,), 'B1CE -> 1102 116C 11A9';
ok Uni.new(0xB1CF).NFKD.list ~~ (0x1102, 0x116C, 0x11AA,), 'B1CF -> 1102 116C 11AA';
ok Uni.new(0xB1D0).NFKD.list ~~ (0x1102, 0x116C, 0x11AB,), 'B1D0 -> 1102 116C 11AB';
ok Uni.new(0xB1D1).NFKD.list ~~ (0x1102, 0x116C, 0x11AC,), 'B1D1 -> 1102 116C 11AC';
ok Uni.new(0xB1D2).NFKD.list ~~ (0x1102, 0x116C, 0x11AD,), 'B1D2 -> 1102 116C 11AD';
ok Uni.new(0xB1D3).NFKD.list ~~ (0x1102, 0x116C, 0x11AE,), 'B1D3 -> 1102 116C 11AE';
ok Uni.new(0xB1D4).NFKD.list ~~ (0x1102, 0x116C, 0x11AF,), 'B1D4 -> 1102 116C 11AF';
ok Uni.new(0xB1D5).NFKD.list ~~ (0x1102, 0x116C, 0x11B0,), 'B1D5 -> 1102 116C 11B0';
ok Uni.new(0xB1D6).NFKD.list ~~ (0x1102, 0x116C, 0x11B1,), 'B1D6 -> 1102 116C 11B1';
ok Uni.new(0xB1D7).NFKD.list ~~ (0x1102, 0x116C, 0x11B2,), 'B1D7 -> 1102 116C 11B2';
ok Uni.new(0xB1D8).NFKD.list ~~ (0x1102, 0x116C, 0x11B3,), 'B1D8 -> 1102 116C 11B3';
ok Uni.new(0xB1D9).NFKD.list ~~ (0x1102, 0x116C, 0x11B4,), 'B1D9 -> 1102 116C 11B4';
ok Uni.new(0xB1DA).NFKD.list ~~ (0x1102, 0x116C, 0x11B5,), 'B1DA -> 1102 116C 11B5';
ok Uni.new(0xB1DB).NFKD.list ~~ (0x1102, 0x116C, 0x11B6,), 'B1DB -> 1102 116C 11B6';
ok Uni.new(0xB1DC).NFKD.list ~~ (0x1102, 0x116C, 0x11B7,), 'B1DC -> 1102 116C 11B7';
ok Uni.new(0xB1DD).NFKD.list ~~ (0x1102, 0x116C, 0x11B8,), 'B1DD -> 1102 116C 11B8';
ok Uni.new(0xB1DE).NFKD.list ~~ (0x1102, 0x116C, 0x11B9,), 'B1DE -> 1102 116C 11B9';
ok Uni.new(0xB1DF).NFKD.list ~~ (0x1102, 0x116C, 0x11BA,), 'B1DF -> 1102 116C 11BA';
ok Uni.new(0xB1E0).NFKD.list ~~ (0x1102, 0x116C, 0x11BB,), 'B1E0 -> 1102 116C 11BB';
ok Uni.new(0xB1E1).NFKD.list ~~ (0x1102, 0x116C, 0x11BC,), 'B1E1 -> 1102 116C 11BC';
ok Uni.new(0xB1E2).NFKD.list ~~ (0x1102, 0x116C, 0x11BD,), 'B1E2 -> 1102 116C 11BD';
ok Uni.new(0xB1E3).NFKD.list ~~ (0x1102, 0x116C, 0x11BE,), 'B1E3 -> 1102 116C 11BE';
ok Uni.new(0xB1E4).NFKD.list ~~ (0x1102, 0x116C, 0x11BF,), 'B1E4 -> 1102 116C 11BF';
ok Uni.new(0xB1E5).NFKD.list ~~ (0x1102, 0x116C, 0x11C0,), 'B1E5 -> 1102 116C 11C0';
ok Uni.new(0xB1E6).NFKD.list ~~ (0x1102, 0x116C, 0x11C1,), 'B1E6 -> 1102 116C 11C1';
ok Uni.new(0xB1E7).NFKD.list ~~ (0x1102, 0x116C, 0x11C2,), 'B1E7 -> 1102 116C 11C2';
ok Uni.new(0xB1E8).NFKD.list ~~ (0x1102, 0x116D,), 'B1E8 -> 1102 116D';
ok Uni.new(0xB1E9).NFKD.list ~~ (0x1102, 0x116D, 0x11A8,), 'B1E9 -> 1102 116D 11A8';
ok Uni.new(0xB1EA).NFKD.list ~~ (0x1102, 0x116D, 0x11A9,), 'B1EA -> 1102 116D 11A9';
ok Uni.new(0xB1EB).NFKD.list ~~ (0x1102, 0x116D, 0x11AA,), 'B1EB -> 1102 116D 11AA';
ok Uni.new(0xB1EC).NFKD.list ~~ (0x1102, 0x116D, 0x11AB,), 'B1EC -> 1102 116D 11AB';
ok Uni.new(0xB1ED).NFKD.list ~~ (0x1102, 0x116D, 0x11AC,), 'B1ED -> 1102 116D 11AC';
ok Uni.new(0xB1EE).NFKD.list ~~ (0x1102, 0x116D, 0x11AD,), 'B1EE -> 1102 116D 11AD';
ok Uni.new(0xB1EF).NFKD.list ~~ (0x1102, 0x116D, 0x11AE,), 'B1EF -> 1102 116D 11AE';
ok Uni.new(0xB1F0).NFKD.list ~~ (0x1102, 0x116D, 0x11AF,), 'B1F0 -> 1102 116D 11AF';
ok Uni.new(0xB1F1).NFKD.list ~~ (0x1102, 0x116D, 0x11B0,), 'B1F1 -> 1102 116D 11B0';
ok Uni.new(0xB1F2).NFKD.list ~~ (0x1102, 0x116D, 0x11B1,), 'B1F2 -> 1102 116D 11B1';
ok Uni.new(0xB1F3).NFKD.list ~~ (0x1102, 0x116D, 0x11B2,), 'B1F3 -> 1102 116D 11B2';
ok Uni.new(0xB1F4).NFKD.list ~~ (0x1102, 0x116D, 0x11B3,), 'B1F4 -> 1102 116D 11B3';
ok Uni.new(0xB1F5).NFKD.list ~~ (0x1102, 0x116D, 0x11B4,), 'B1F5 -> 1102 116D 11B4';
ok Uni.new(0xB1F6).NFKD.list ~~ (0x1102, 0x116D, 0x11B5,), 'B1F6 -> 1102 116D 11B5';
ok Uni.new(0xB1F7).NFKD.list ~~ (0x1102, 0x116D, 0x11B6,), 'B1F7 -> 1102 116D 11B6';
ok Uni.new(0xB1F8).NFKD.list ~~ (0x1102, 0x116D, 0x11B7,), 'B1F8 -> 1102 116D 11B7';
ok Uni.new(0xB1F9).NFKD.list ~~ (0x1102, 0x116D, 0x11B8,), 'B1F9 -> 1102 116D 11B8';
ok Uni.new(0xB1FA).NFKD.list ~~ (0x1102, 0x116D, 0x11B9,), 'B1FA -> 1102 116D 11B9';
ok Uni.new(0xB1FB).NFKD.list ~~ (0x1102, 0x116D, 0x11BA,), 'B1FB -> 1102 116D 11BA';
ok Uni.new(0xB1FC).NFKD.list ~~ (0x1102, 0x116D, 0x11BB,), 'B1FC -> 1102 116D 11BB';
ok Uni.new(0xB1FD).NFKD.list ~~ (0x1102, 0x116D, 0x11BC,), 'B1FD -> 1102 116D 11BC';
ok Uni.new(0xB1FE).NFKD.list ~~ (0x1102, 0x116D, 0x11BD,), 'B1FE -> 1102 116D 11BD';
ok Uni.new(0xB1FF).NFKD.list ~~ (0x1102, 0x116D, 0x11BE,), 'B1FF -> 1102 116D 11BE';
ok Uni.new(0xB200).NFKD.list ~~ (0x1102, 0x116D, 0x11BF,), 'B200 -> 1102 116D 11BF';
ok Uni.new(0xB201).NFKD.list ~~ (0x1102, 0x116D, 0x11C0,), 'B201 -> 1102 116D 11C0';
ok Uni.new(0xB202).NFKD.list ~~ (0x1102, 0x116D, 0x11C1,), 'B202 -> 1102 116D 11C1';
ok Uni.new(0xB203).NFKD.list ~~ (0x1102, 0x116D, 0x11C2,), 'B203 -> 1102 116D 11C2';
ok Uni.new(0xB204).NFKD.list ~~ (0x1102, 0x116E,), 'B204 -> 1102 116E';
ok Uni.new(0xB205).NFKD.list ~~ (0x1102, 0x116E, 0x11A8,), 'B205 -> 1102 116E 11A8';
ok Uni.new(0xB206).NFKD.list ~~ (0x1102, 0x116E, 0x11A9,), 'B206 -> 1102 116E 11A9';
ok Uni.new(0xB207).NFKD.list ~~ (0x1102, 0x116E, 0x11AA,), 'B207 -> 1102 116E 11AA';
ok Uni.new(0xB208).NFKD.list ~~ (0x1102, 0x116E, 0x11AB,), 'B208 -> 1102 116E 11AB';
ok Uni.new(0xB209).NFKD.list ~~ (0x1102, 0x116E, 0x11AC,), 'B209 -> 1102 116E 11AC';
ok Uni.new(0xB20A).NFKD.list ~~ (0x1102, 0x116E, 0x11AD,), 'B20A -> 1102 116E 11AD';
ok Uni.new(0xB20B).NFKD.list ~~ (0x1102, 0x116E, 0x11AE,), 'B20B -> 1102 116E 11AE';
ok Uni.new(0xB20C).NFKD.list ~~ (0x1102, 0x116E, 0x11AF,), 'B20C -> 1102 116E 11AF';
ok Uni.new(0xB20D).NFKD.list ~~ (0x1102, 0x116E, 0x11B0,), 'B20D -> 1102 116E 11B0';
ok Uni.new(0xB20E).NFKD.list ~~ (0x1102, 0x116E, 0x11B1,), 'B20E -> 1102 116E 11B1';
ok Uni.new(0xB20F).NFKD.list ~~ (0x1102, 0x116E, 0x11B2,), 'B20F -> 1102 116E 11B2';
ok Uni.new(0xB210).NFKD.list ~~ (0x1102, 0x116E, 0x11B3,), 'B210 -> 1102 116E 11B3';
ok Uni.new(0xB211).NFKD.list ~~ (0x1102, 0x116E, 0x11B4,), 'B211 -> 1102 116E 11B4';
ok Uni.new(0xB212).NFKD.list ~~ (0x1102, 0x116E, 0x11B5,), 'B212 -> 1102 116E 11B5';
ok Uni.new(0xB213).NFKD.list ~~ (0x1102, 0x116E, 0x11B6,), 'B213 -> 1102 116E 11B6';
ok Uni.new(0xB214).NFKD.list ~~ (0x1102, 0x116E, 0x11B7,), 'B214 -> 1102 116E 11B7';
ok Uni.new(0xB215).NFKD.list ~~ (0x1102, 0x116E, 0x11B8,), 'B215 -> 1102 116E 11B8';
ok Uni.new(0xB216).NFKD.list ~~ (0x1102, 0x116E, 0x11B9,), 'B216 -> 1102 116E 11B9';
ok Uni.new(0xB217).NFKD.list ~~ (0x1102, 0x116E, 0x11BA,), 'B217 -> 1102 116E 11BA';
ok Uni.new(0xB218).NFKD.list ~~ (0x1102, 0x116E, 0x11BB,), 'B218 -> 1102 116E 11BB';
ok Uni.new(0xB219).NFKD.list ~~ (0x1102, 0x116E, 0x11BC,), 'B219 -> 1102 116E 11BC';
ok Uni.new(0xB21A).NFKD.list ~~ (0x1102, 0x116E, 0x11BD,), 'B21A -> 1102 116E 11BD';
ok Uni.new(0xB21B).NFKD.list ~~ (0x1102, 0x116E, 0x11BE,), 'B21B -> 1102 116E 11BE';
ok Uni.new(0xB21C).NFKD.list ~~ (0x1102, 0x116E, 0x11BF,), 'B21C -> 1102 116E 11BF';
ok Uni.new(0xB21D).NFKD.list ~~ (0x1102, 0x116E, 0x11C0,), 'B21D -> 1102 116E 11C0';
ok Uni.new(0xB21E).NFKD.list ~~ (0x1102, 0x116E, 0x11C1,), 'B21E -> 1102 116E 11C1';
ok Uni.new(0xB21F).NFKD.list ~~ (0x1102, 0x116E, 0x11C2,), 'B21F -> 1102 116E 11C2';
ok Uni.new(0xB220).NFKD.list ~~ (0x1102, 0x116F,), 'B220 -> 1102 116F';
ok Uni.new(0xB221).NFKD.list ~~ (0x1102, 0x116F, 0x11A8,), 'B221 -> 1102 116F 11A8';
ok Uni.new(0xB222).NFKD.list ~~ (0x1102, 0x116F, 0x11A9,), 'B222 -> 1102 116F 11A9';
ok Uni.new(0xB223).NFKD.list ~~ (0x1102, 0x116F, 0x11AA,), 'B223 -> 1102 116F 11AA';
ok Uni.new(0xB224).NFKD.list ~~ (0x1102, 0x116F, 0x11AB,), 'B224 -> 1102 116F 11AB';
ok Uni.new(0xB225).NFKD.list ~~ (0x1102, 0x116F, 0x11AC,), 'B225 -> 1102 116F 11AC';
ok Uni.new(0xB226).NFKD.list ~~ (0x1102, 0x116F, 0x11AD,), 'B226 -> 1102 116F 11AD';
ok Uni.new(0xB227).NFKD.list ~~ (0x1102, 0x116F, 0x11AE,), 'B227 -> 1102 116F 11AE';
ok Uni.new(0xB228).NFKD.list ~~ (0x1102, 0x116F, 0x11AF,), 'B228 -> 1102 116F 11AF';
ok Uni.new(0xB229).NFKD.list ~~ (0x1102, 0x116F, 0x11B0,), 'B229 -> 1102 116F 11B0';
ok Uni.new(0xB22A).NFKD.list ~~ (0x1102, 0x116F, 0x11B1,), 'B22A -> 1102 116F 11B1';
ok Uni.new(0xB22B).NFKD.list ~~ (0x1102, 0x116F, 0x11B2,), 'B22B -> 1102 116F 11B2';
ok Uni.new(0xB22C).NFKD.list ~~ (0x1102, 0x116F, 0x11B3,), 'B22C -> 1102 116F 11B3';
ok Uni.new(0xB22D).NFKD.list ~~ (0x1102, 0x116F, 0x11B4,), 'B22D -> 1102 116F 11B4';
ok Uni.new(0xB22E).NFKD.list ~~ (0x1102, 0x116F, 0x11B5,), 'B22E -> 1102 116F 11B5';
ok Uni.new(0xB22F).NFKD.list ~~ (0x1102, 0x116F, 0x11B6,), 'B22F -> 1102 116F 11B6';
ok Uni.new(0xB230).NFKD.list ~~ (0x1102, 0x116F, 0x11B7,), 'B230 -> 1102 116F 11B7';
ok Uni.new(0xB231).NFKD.list ~~ (0x1102, 0x116F, 0x11B8,), 'B231 -> 1102 116F 11B8';
ok Uni.new(0xB232).NFKD.list ~~ (0x1102, 0x116F, 0x11B9,), 'B232 -> 1102 116F 11B9';
ok Uni.new(0xB233).NFKD.list ~~ (0x1102, 0x116F, 0x11BA,), 'B233 -> 1102 116F 11BA';
ok Uni.new(0xB234).NFKD.list ~~ (0x1102, 0x116F, 0x11BB,), 'B234 -> 1102 116F 11BB';
ok Uni.new(0xB235).NFKD.list ~~ (0x1102, 0x116F, 0x11BC,), 'B235 -> 1102 116F 11BC';
ok Uni.new(0xB236).NFKD.list ~~ (0x1102, 0x116F, 0x11BD,), 'B236 -> 1102 116F 11BD';
ok Uni.new(0xB237).NFKD.list ~~ (0x1102, 0x116F, 0x11BE,), 'B237 -> 1102 116F 11BE';
ok Uni.new(0xB238).NFKD.list ~~ (0x1102, 0x116F, 0x11BF,), 'B238 -> 1102 116F 11BF';
ok Uni.new(0xB239).NFKD.list ~~ (0x1102, 0x116F, 0x11C0,), 'B239 -> 1102 116F 11C0';
ok Uni.new(0xB23A).NFKD.list ~~ (0x1102, 0x116F, 0x11C1,), 'B23A -> 1102 116F 11C1';
ok Uni.new(0xB23B).NFKD.list ~~ (0x1102, 0x116F, 0x11C2,), 'B23B -> 1102 116F 11C2';
ok Uni.new(0xB23C).NFKD.list ~~ (0x1102, 0x1170,), 'B23C -> 1102 1170';
ok Uni.new(0xB23D).NFKD.list ~~ (0x1102, 0x1170, 0x11A8,), 'B23D -> 1102 1170 11A8';
ok Uni.new(0xB23E).NFKD.list ~~ (0x1102, 0x1170, 0x11A9,), 'B23E -> 1102 1170 11A9';
ok Uni.new(0xB23F).NFKD.list ~~ (0x1102, 0x1170, 0x11AA,), 'B23F -> 1102 1170 11AA';
ok Uni.new(0xB240).NFKD.list ~~ (0x1102, 0x1170, 0x11AB,), 'B240 -> 1102 1170 11AB';
ok Uni.new(0xB241).NFKD.list ~~ (0x1102, 0x1170, 0x11AC,), 'B241 -> 1102 1170 11AC';
ok Uni.new(0xB242).NFKD.list ~~ (0x1102, 0x1170, 0x11AD,), 'B242 -> 1102 1170 11AD';
ok Uni.new(0xB243).NFKD.list ~~ (0x1102, 0x1170, 0x11AE,), 'B243 -> 1102 1170 11AE';
ok Uni.new(0xB244).NFKD.list ~~ (0x1102, 0x1170, 0x11AF,), 'B244 -> 1102 1170 11AF';
ok Uni.new(0xB245).NFKD.list ~~ (0x1102, 0x1170, 0x11B0,), 'B245 -> 1102 1170 11B0';
ok Uni.new(0xB246).NFKD.list ~~ (0x1102, 0x1170, 0x11B1,), 'B246 -> 1102 1170 11B1';
ok Uni.new(0xB247).NFKD.list ~~ (0x1102, 0x1170, 0x11B2,), 'B247 -> 1102 1170 11B2';
ok Uni.new(0xB248).NFKD.list ~~ (0x1102, 0x1170, 0x11B3,), 'B248 -> 1102 1170 11B3';
ok Uni.new(0xB249).NFKD.list ~~ (0x1102, 0x1170, 0x11B4,), 'B249 -> 1102 1170 11B4';
ok Uni.new(0xB24A).NFKD.list ~~ (0x1102, 0x1170, 0x11B5,), 'B24A -> 1102 1170 11B5';
ok Uni.new(0xB24B).NFKD.list ~~ (0x1102, 0x1170, 0x11B6,), 'B24B -> 1102 1170 11B6';
ok Uni.new(0xB24C).NFKD.list ~~ (0x1102, 0x1170, 0x11B7,), 'B24C -> 1102 1170 11B7';
ok Uni.new(0xB24D).NFKD.list ~~ (0x1102, 0x1170, 0x11B8,), 'B24D -> 1102 1170 11B8';
ok Uni.new(0xB24E).NFKD.list ~~ (0x1102, 0x1170, 0x11B9,), 'B24E -> 1102 1170 11B9';
ok Uni.new(0xB24F).NFKD.list ~~ (0x1102, 0x1170, 0x11BA,), 'B24F -> 1102 1170 11BA';
ok Uni.new(0xB250).NFKD.list ~~ (0x1102, 0x1170, 0x11BB,), 'B250 -> 1102 1170 11BB';
ok Uni.new(0xB251).NFKD.list ~~ (0x1102, 0x1170, 0x11BC,), 'B251 -> 1102 1170 11BC';
ok Uni.new(0xB252).NFKD.list ~~ (0x1102, 0x1170, 0x11BD,), 'B252 -> 1102 1170 11BD';
ok Uni.new(0xB253).NFKD.list ~~ (0x1102, 0x1170, 0x11BE,), 'B253 -> 1102 1170 11BE';
ok Uni.new(0xB254).NFKD.list ~~ (0x1102, 0x1170, 0x11BF,), 'B254 -> 1102 1170 11BF';
ok Uni.new(0xB255).NFKD.list ~~ (0x1102, 0x1170, 0x11C0,), 'B255 -> 1102 1170 11C0';
ok Uni.new(0xB256).NFKD.list ~~ (0x1102, 0x1170, 0x11C1,), 'B256 -> 1102 1170 11C1';
ok Uni.new(0xB257).NFKD.list ~~ (0x1102, 0x1170, 0x11C2,), 'B257 -> 1102 1170 11C2';
ok Uni.new(0xB258).NFKD.list ~~ (0x1102, 0x1171,), 'B258 -> 1102 1171';
ok Uni.new(0xB259).NFKD.list ~~ (0x1102, 0x1171, 0x11A8,), 'B259 -> 1102 1171 11A8';
ok Uni.new(0xB25A).NFKD.list ~~ (0x1102, 0x1171, 0x11A9,), 'B25A -> 1102 1171 11A9';
ok Uni.new(0xB25B).NFKD.list ~~ (0x1102, 0x1171, 0x11AA,), 'B25B -> 1102 1171 11AA';
ok Uni.new(0xB25C).NFKD.list ~~ (0x1102, 0x1171, 0x11AB,), 'B25C -> 1102 1171 11AB';
