use v6;
# Unicode normalization tests, generated from NormalizationTests.txt in the
# Unicode database by S15-normalization/test-gen.raku.
# Generated from Unicode version 13.0.0.

use Test;

plan 2000;

ok Uni.new(0xD19D).NFD.list ~~ (0x1110, 0x1168, 0x11C0,), 'D19D -> 1110 1168 11C0';
ok Uni.new(0xD19E).NFD.list ~~ (0x1110, 0x1168, 0x11C1,), 'D19E -> 1110 1168 11C1';
ok Uni.new(0xD19F).NFD.list ~~ (0x1110, 0x1168, 0x11C2,), 'D19F -> 1110 1168 11C2';
ok Uni.new(0xD1A0).NFD.list ~~ (0x1110, 0x1169,), 'D1A0 -> 1110 1169';
ok Uni.new(0xD1A1).NFD.list ~~ (0x1110, 0x1169, 0x11A8,), 'D1A1 -> 1110 1169 11A8';
ok Uni.new(0xD1A2).NFD.list ~~ (0x1110, 0x1169, 0x11A9,), 'D1A2 -> 1110 1169 11A9';
ok Uni.new(0xD1A3).NFD.list ~~ (0x1110, 0x1169, 0x11AA,), 'D1A3 -> 1110 1169 11AA';
ok Uni.new(0xD1A4).NFD.list ~~ (0x1110, 0x1169, 0x11AB,), 'D1A4 -> 1110 1169 11AB';
ok Uni.new(0xD1A5).NFD.list ~~ (0x1110, 0x1169, 0x11AC,), 'D1A5 -> 1110 1169 11AC';
ok Uni.new(0xD1A6).NFD.list ~~ (0x1110, 0x1169, 0x11AD,), 'D1A6 -> 1110 1169 11AD';
ok Uni.new(0xD1A7).NFD.list ~~ (0x1110, 0x1169, 0x11AE,), 'D1A7 -> 1110 1169 11AE';
ok Uni.new(0xD1A8).NFD.list ~~ (0x1110, 0x1169, 0x11AF,), 'D1A8 -> 1110 1169 11AF';
ok Uni.new(0xD1A9).NFD.list ~~ (0x1110, 0x1169, 0x11B0,), 'D1A9 -> 1110 1169 11B0';
ok Uni.new(0xD1AA).NFD.list ~~ (0x1110, 0x1169, 0x11B1,), 'D1AA -> 1110 1169 11B1';
ok Uni.new(0xD1AB).NFD.list ~~ (0x1110, 0x1169, 0x11B2,), 'D1AB -> 1110 1169 11B2';
ok Uni.new(0xD1AC).NFD.list ~~ (0x1110, 0x1169, 0x11B3,), 'D1AC -> 1110 1169 11B3';
ok Uni.new(0xD1AD).NFD.list ~~ (0x1110, 0x1169, 0x11B4,), 'D1AD -> 1110 1169 11B4';
ok Uni.new(0xD1AE).NFD.list ~~ (0x1110, 0x1169, 0x11B5,), 'D1AE -> 1110 1169 11B5';
ok Uni.new(0xD1AF).NFD.list ~~ (0x1110, 0x1169, 0x11B6,), 'D1AF -> 1110 1169 11B6';
ok Uni.new(0xD1B0).NFD.list ~~ (0x1110, 0x1169, 0x11B7,), 'D1B0 -> 1110 1169 11B7';
ok Uni.new(0xD1B1).NFD.list ~~ (0x1110, 0x1169, 0x11B8,), 'D1B1 -> 1110 1169 11B8';
ok Uni.new(0xD1B2).NFD.list ~~ (0x1110, 0x1169, 0x11B9,), 'D1B2 -> 1110 1169 11B9';
ok Uni.new(0xD1B3).NFD.list ~~ (0x1110, 0x1169, 0x11BA,), 'D1B3 -> 1110 1169 11BA';
ok Uni.new(0xD1B4).NFD.list ~~ (0x1110, 0x1169, 0x11BB,), 'D1B4 -> 1110 1169 11BB';
ok Uni.new(0xD1B5).NFD.list ~~ (0x1110, 0x1169, 0x11BC,), 'D1B5 -> 1110 1169 11BC';
ok Uni.new(0xD1B6).NFD.list ~~ (0x1110, 0x1169, 0x11BD,), 'D1B6 -> 1110 1169 11BD';
ok Uni.new(0xD1B7).NFD.list ~~ (0x1110, 0x1169, 0x11BE,), 'D1B7 -> 1110 1169 11BE';
ok Uni.new(0xD1B8).NFD.list ~~ (0x1110, 0x1169, 0x11BF,), 'D1B8 -> 1110 1169 11BF';
ok Uni.new(0xD1B9).NFD.list ~~ (0x1110, 0x1169, 0x11C0,), 'D1B9 -> 1110 1169 11C0';
ok Uni.new(0xD1BA).NFD.list ~~ (0x1110, 0x1169, 0x11C1,), 'D1BA -> 1110 1169 11C1';
ok Uni.new(0xD1BB).NFD.list ~~ (0x1110, 0x1169, 0x11C2,), 'D1BB -> 1110 1169 11C2';
ok Uni.new(0xD1BC).NFD.list ~~ (0x1110, 0x116A,), 'D1BC -> 1110 116A';
ok Uni.new(0xD1BD).NFD.list ~~ (0x1110, 0x116A, 0x11A8,), 'D1BD -> 1110 116A 11A8';
ok Uni.new(0xD1BE).NFD.list ~~ (0x1110, 0x116A, 0x11A9,), 'D1BE -> 1110 116A 11A9';
ok Uni.new(0xD1BF).NFD.list ~~ (0x1110, 0x116A, 0x11AA,), 'D1BF -> 1110 116A 11AA';
ok Uni.new(0xD1C0).NFD.list ~~ (0x1110, 0x116A, 0x11AB,), 'D1C0 -> 1110 116A 11AB';
ok Uni.new(0xD1C1).NFD.list ~~ (0x1110, 0x116A, 0x11AC,), 'D1C1 -> 1110 116A 11AC';
ok Uni.new(0xD1C2).NFD.list ~~ (0x1110, 0x116A, 0x11AD,), 'D1C2 -> 1110 116A 11AD';
ok Uni.new(0xD1C3).NFD.list ~~ (0x1110, 0x116A, 0x11AE,), 'D1C3 -> 1110 116A 11AE';
ok Uni.new(0xD1C4).NFD.list ~~ (0x1110, 0x116A, 0x11AF,), 'D1C4 -> 1110 116A 11AF';
ok Uni.new(0xD1C5).NFD.list ~~ (0x1110, 0x116A, 0x11B0,), 'D1C5 -> 1110 116A 11B0';
ok Uni.new(0xD1C6).NFD.list ~~ (0x1110, 0x116A, 0x11B1,), 'D1C6 -> 1110 116A 11B1';
ok Uni.new(0xD1C7).NFD.list ~~ (0x1110, 0x116A, 0x11B2,), 'D1C7 -> 1110 116A 11B2';
ok Uni.new(0xD1C8).NFD.list ~~ (0x1110, 0x116A, 0x11B3,), 'D1C8 -> 1110 116A 11B3';
ok Uni.new(0xD1C9).NFD.list ~~ (0x1110, 0x116A, 0x11B4,), 'D1C9 -> 1110 116A 11B4';
ok Uni.new(0xD1CA).NFD.list ~~ (0x1110, 0x116A, 0x11B5,), 'D1CA -> 1110 116A 11B5';
ok Uni.new(0xD1CB).NFD.list ~~ (0x1110, 0x116A, 0x11B6,), 'D1CB -> 1110 116A 11B6';
ok Uni.new(0xD1CC).NFD.list ~~ (0x1110, 0x116A, 0x11B7,), 'D1CC -> 1110 116A 11B7';
ok Uni.new(0xD1CD).NFD.list ~~ (0x1110, 0x116A, 0x11B8,), 'D1CD -> 1110 116A 11B8';
ok Uni.new(0xD1CE).NFD.list ~~ (0x1110, 0x116A, 0x11B9,), 'D1CE -> 1110 116A 11B9';
ok Uni.new(0xD1CF).NFD.list ~~ (0x1110, 0x116A, 0x11BA,), 'D1CF -> 1110 116A 11BA';
ok Uni.new(0xD1D0).NFD.list ~~ (0x1110, 0x116A, 0x11BB,), 'D1D0 -> 1110 116A 11BB';
ok Uni.new(0xD1D1).NFD.list ~~ (0x1110, 0x116A, 0x11BC,), 'D1D1 -> 1110 116A 11BC';
ok Uni.new(0xD1D2).NFD.list ~~ (0x1110, 0x116A, 0x11BD,), 'D1D2 -> 1110 116A 11BD';
ok Uni.new(0xD1D3).NFD.list ~~ (0x1110, 0x116A, 0x11BE,), 'D1D3 -> 1110 116A 11BE';
ok Uni.new(0xD1D4).NFD.list ~~ (0x1110, 0x116A, 0x11BF,), 'D1D4 -> 1110 116A 11BF';
ok Uni.new(0xD1D5).NFD.list ~~ (0x1110, 0x116A, 0x11C0,), 'D1D5 -> 1110 116A 11C0';
ok Uni.new(0xD1D6).NFD.list ~~ (0x1110, 0x116A, 0x11C1,), 'D1D6 -> 1110 116A 11C1';
ok Uni.new(0xD1D7).NFD.list ~~ (0x1110, 0x116A, 0x11C2,), 'D1D7 -> 1110 116A 11C2';
ok Uni.new(0xD1D8).NFD.list ~~ (0x1110, 0x116B,), 'D1D8 -> 1110 116B';
ok Uni.new(0xD1D9).NFD.list ~~ (0x1110, 0x116B, 0x11A8,), 'D1D9 -> 1110 116B 11A8';
ok Uni.new(0xD1DA).NFD.list ~~ (0x1110, 0x116B, 0x11A9,), 'D1DA -> 1110 116B 11A9';
ok Uni.new(0xD1DB).NFD.list ~~ (0x1110, 0x116B, 0x11AA,), 'D1DB -> 1110 116B 11AA';
ok Uni.new(0xD1DC).NFD.list ~~ (0x1110, 0x116B, 0x11AB,), 'D1DC -> 1110 116B 11AB';
ok Uni.new(0xD1DD).NFD.list ~~ (0x1110, 0x116B, 0x11AC,), 'D1DD -> 1110 116B 11AC';
ok Uni.new(0xD1DE).NFD.list ~~ (0x1110, 0x116B, 0x11AD,), 'D1DE -> 1110 116B 11AD';
ok Uni.new(0xD1DF).NFD.list ~~ (0x1110, 0x116B, 0x11AE,), 'D1DF -> 1110 116B 11AE';
ok Uni.new(0xD1E0).NFD.list ~~ (0x1110, 0x116B, 0x11AF,), 'D1E0 -> 1110 116B 11AF';
ok Uni.new(0xD1E1).NFD.list ~~ (0x1110, 0x116B, 0x11B0,), 'D1E1 -> 1110 116B 11B0';
ok Uni.new(0xD1E2).NFD.list ~~ (0x1110, 0x116B, 0x11B1,), 'D1E2 -> 1110 116B 11B1';
ok Uni.new(0xD1E3).NFD.list ~~ (0x1110, 0x116B, 0x11B2,), 'D1E3 -> 1110 116B 11B2';
ok Uni.new(0xD1E4).NFD.list ~~ (0x1110, 0x116B, 0x11B3,), 'D1E4 -> 1110 116B 11B3';
ok Uni.new(0xD1E5).NFD.list ~~ (0x1110, 0x116B, 0x11B4,), 'D1E5 -> 1110 116B 11B4';
ok Uni.new(0xD1E6).NFD.list ~~ (0x1110, 0x116B, 0x11B5,), 'D1E6 -> 1110 116B 11B5';
ok Uni.new(0xD1E7).NFD.list ~~ (0x1110, 0x116B, 0x11B6,), 'D1E7 -> 1110 116B 11B6';
ok Uni.new(0xD1E8).NFD.list ~~ (0x1110, 0x116B, 0x11B7,), 'D1E8 -> 1110 116B 11B7';
ok Uni.new(0xD1E9).NFD.list ~~ (0x1110, 0x116B, 0x11B8,), 'D1E9 -> 1110 116B 11B8';
ok Uni.new(0xD1EA).NFD.list ~~ (0x1110, 0x116B, 0x11B9,), 'D1EA -> 1110 116B 11B9';
ok Uni.new(0xD1EB).NFD.list ~~ (0x1110, 0x116B, 0x11BA,), 'D1EB -> 1110 116B 11BA';
ok Uni.new(0xD1EC).NFD.list ~~ (0x1110, 0x116B, 0x11BB,), 'D1EC -> 1110 116B 11BB';
ok Uni.new(0xD1ED).NFD.list ~~ (0x1110, 0x116B, 0x11BC,), 'D1ED -> 1110 116B 11BC';
ok Uni.new(0xD1EE).NFD.list ~~ (0x1110, 0x116B, 0x11BD,), 'D1EE -> 1110 116B 11BD';
ok Uni.new(0xD1EF).NFD.list ~~ (0x1110, 0x116B, 0x11BE,), 'D1EF -> 1110 116B 11BE';
ok Uni.new(0xD1F0).NFD.list ~~ (0x1110, 0x116B, 0x11BF,), 'D1F0 -> 1110 116B 11BF';
ok Uni.new(0xD1F1).NFD.list ~~ (0x1110, 0x116B, 0x11C0,), 'D1F1 -> 1110 116B 11C0';
ok Uni.new(0xD1F2).NFD.list ~~ (0x1110, 0x116B, 0x11C1,), 'D1F2 -> 1110 116B 11C1';
ok Uni.new(0xD1F3).NFD.list ~~ (0x1110, 0x116B, 0x11C2,), 'D1F3 -> 1110 116B 11C2';
ok Uni.new(0xD1F4).NFD.list ~~ (0x1110, 0x116C,), 'D1F4 -> 1110 116C';
ok Uni.new(0xD1F5).NFD.list ~~ (0x1110, 0x116C, 0x11A8,), 'D1F5 -> 1110 116C 11A8';
ok Uni.new(0xD1F6).NFD.list ~~ (0x1110, 0x116C, 0x11A9,), 'D1F6 -> 1110 116C 11A9';
ok Uni.new(0xD1F7).NFD.list ~~ (0x1110, 0x116C, 0x11AA,), 'D1F7 -> 1110 116C 11AA';
ok Uni.new(0xD1F8).NFD.list ~~ (0x1110, 0x116C, 0x11AB,), 'D1F8 -> 1110 116C 11AB';
ok Uni.new(0xD1F9).NFD.list ~~ (0x1110, 0x116C, 0x11AC,), 'D1F9 -> 1110 116C 11AC';
ok Uni.new(0xD1FA).NFD.list ~~ (0x1110, 0x116C, 0x11AD,), 'D1FA -> 1110 116C 11AD';
ok Uni.new(0xD1FB).NFD.list ~~ (0x1110, 0x116C, 0x11AE,), 'D1FB -> 1110 116C 11AE';
ok Uni.new(0xD1FC).NFD.list ~~ (0x1110, 0x116C, 0x11AF,), 'D1FC -> 1110 116C 11AF';
ok Uni.new(0xD1FD).NFD.list ~~ (0x1110, 0x116C, 0x11B0,), 'D1FD -> 1110 116C 11B0';
ok Uni.new(0xD1FE).NFD.list ~~ (0x1110, 0x116C, 0x11B1,), 'D1FE -> 1110 116C 11B1';
ok Uni.new(0xD1FF).NFD.list ~~ (0x1110, 0x116C, 0x11B2,), 'D1FF -> 1110 116C 11B2';
ok Uni.new(0xD200).NFD.list ~~ (0x1110, 0x116C, 0x11B3,), 'D200 -> 1110 116C 11B3';
ok Uni.new(0xD201).NFD.list ~~ (0x1110, 0x116C, 0x11B4,), 'D201 -> 1110 116C 11B4';
ok Uni.new(0xD202).NFD.list ~~ (0x1110, 0x116C, 0x11B5,), 'D202 -> 1110 116C 11B5';
ok Uni.new(0xD203).NFD.list ~~ (0x1110, 0x116C, 0x11B6,), 'D203 -> 1110 116C 11B6';
ok Uni.new(0xD204).NFD.list ~~ (0x1110, 0x116C, 0x11B7,), 'D204 -> 1110 116C 11B7';
ok Uni.new(0xD205).NFD.list ~~ (0x1110, 0x116C, 0x11B8,), 'D205 -> 1110 116C 11B8';
ok Uni.new(0xD206).NFD.list ~~ (0x1110, 0x116C, 0x11B9,), 'D206 -> 1110 116C 11B9';
ok Uni.new(0xD207).NFD.list ~~ (0x1110, 0x116C, 0x11BA,), 'D207 -> 1110 116C 11BA';
ok Uni.new(0xD208).NFD.list ~~ (0x1110, 0x116C, 0x11BB,), 'D208 -> 1110 116C 11BB';
ok Uni.new(0xD209).NFD.list ~~ (0x1110, 0x116C, 0x11BC,), 'D209 -> 1110 116C 11BC';
ok Uni.new(0xD20A).NFD.list ~~ (0x1110, 0x116C, 0x11BD,), 'D20A -> 1110 116C 11BD';
ok Uni.new(0xD20B).NFD.list ~~ (0x1110, 0x116C, 0x11BE,), 'D20B -> 1110 116C 11BE';
ok Uni.new(0xD20C).NFD.list ~~ (0x1110, 0x116C, 0x11BF,), 'D20C -> 1110 116C 11BF';
ok Uni.new(0xD20D).NFD.list ~~ (0x1110, 0x116C, 0x11C0,), 'D20D -> 1110 116C 11C0';
ok Uni.new(0xD20E).NFD.list ~~ (0x1110, 0x116C, 0x11C1,), 'D20E -> 1110 116C 11C1';
ok Uni.new(0xD20F).NFD.list ~~ (0x1110, 0x116C, 0x11C2,), 'D20F -> 1110 116C 11C2';
ok Uni.new(0xD210).NFD.list ~~ (0x1110, 0x116D,), 'D210 -> 1110 116D';
ok Uni.new(0xD211).NFD.list ~~ (0x1110, 0x116D, 0x11A8,), 'D211 -> 1110 116D 11A8';
ok Uni.new(0xD212).NFD.list ~~ (0x1110, 0x116D, 0x11A9,), 'D212 -> 1110 116D 11A9';
ok Uni.new(0xD213).NFD.list ~~ (0x1110, 0x116D, 0x11AA,), 'D213 -> 1110 116D 11AA';
ok Uni.new(0xD214).NFD.list ~~ (0x1110, 0x116D, 0x11AB,), 'D214 -> 1110 116D 11AB';
ok Uni.new(0xD215).NFD.list ~~ (0x1110, 0x116D, 0x11AC,), 'D215 -> 1110 116D 11AC';
ok Uni.new(0xD216).NFD.list ~~ (0x1110, 0x116D, 0x11AD,), 'D216 -> 1110 116D 11AD';
ok Uni.new(0xD217).NFD.list ~~ (0x1110, 0x116D, 0x11AE,), 'D217 -> 1110 116D 11AE';
ok Uni.new(0xD218).NFD.list ~~ (0x1110, 0x116D, 0x11AF,), 'D218 -> 1110 116D 11AF';
ok Uni.new(0xD219).NFD.list ~~ (0x1110, 0x116D, 0x11B0,), 'D219 -> 1110 116D 11B0';
ok Uni.new(0xD21A).NFD.list ~~ (0x1110, 0x116D, 0x11B1,), 'D21A -> 1110 116D 11B1';
ok Uni.new(0xD21B).NFD.list ~~ (0x1110, 0x116D, 0x11B2,), 'D21B -> 1110 116D 11B2';
ok Uni.new(0xD21C).NFD.list ~~ (0x1110, 0x116D, 0x11B3,), 'D21C -> 1110 116D 11B3';
ok Uni.new(0xD21D).NFD.list ~~ (0x1110, 0x116D, 0x11B4,), 'D21D -> 1110 116D 11B4';
ok Uni.new(0xD21E).NFD.list ~~ (0x1110, 0x116D, 0x11B5,), 'D21E -> 1110 116D 11B5';
ok Uni.new(0xD21F).NFD.list ~~ (0x1110, 0x116D, 0x11B6,), 'D21F -> 1110 116D 11B6';
ok Uni.new(0xD220).NFD.list ~~ (0x1110, 0x116D, 0x11B7,), 'D220 -> 1110 116D 11B7';
ok Uni.new(0xD221).NFD.list ~~ (0x1110, 0x116D, 0x11B8,), 'D221 -> 1110 116D 11B8';
ok Uni.new(0xD222).NFD.list ~~ (0x1110, 0x116D, 0x11B9,), 'D222 -> 1110 116D 11B9';
ok Uni.new(0xD223).NFD.list ~~ (0x1110, 0x116D, 0x11BA,), 'D223 -> 1110 116D 11BA';
ok Uni.new(0xD224).NFD.list ~~ (0x1110, 0x116D, 0x11BB,), 'D224 -> 1110 116D 11BB';
ok Uni.new(0xD225).NFD.list ~~ (0x1110, 0x116D, 0x11BC,), 'D225 -> 1110 116D 11BC';
ok Uni.new(0xD226).NFD.list ~~ (0x1110, 0x116D, 0x11BD,), 'D226 -> 1110 116D 11BD';
ok Uni.new(0xD227).NFD.list ~~ (0x1110, 0x116D, 0x11BE,), 'D227 -> 1110 116D 11BE';
ok Uni.new(0xD228).NFD.list ~~ (0x1110, 0x116D, 0x11BF,), 'D228 -> 1110 116D 11BF';
ok Uni.new(0xD229).NFD.list ~~ (0x1110, 0x116D, 0x11C0,), 'D229 -> 1110 116D 11C0';
ok Uni.new(0xD22A).NFD.list ~~ (0x1110, 0x116D, 0x11C1,), 'D22A -> 1110 116D 11C1';
ok Uni.new(0xD22B).NFD.list ~~ (0x1110, 0x116D, 0x11C2,), 'D22B -> 1110 116D 11C2';
ok Uni.new(0xD22C).NFD.list ~~ (0x1110, 0x116E,), 'D22C -> 1110 116E';
ok Uni.new(0xD22D).NFD.list ~~ (0x1110, 0x116E, 0x11A8,), 'D22D -> 1110 116E 11A8';
ok Uni.new(0xD22E).NFD.list ~~ (0x1110, 0x116E, 0x11A9,), 'D22E -> 1110 116E 11A9';
ok Uni.new(0xD22F).NFD.list ~~ (0x1110, 0x116E, 0x11AA,), 'D22F -> 1110 116E 11AA';
ok Uni.new(0xD230).NFD.list ~~ (0x1110, 0x116E, 0x11AB,), 'D230 -> 1110 116E 11AB';
ok Uni.new(0xD231).NFD.list ~~ (0x1110, 0x116E, 0x11AC,), 'D231 -> 1110 116E 11AC';
ok Uni.new(0xD232).NFD.list ~~ (0x1110, 0x116E, 0x11AD,), 'D232 -> 1110 116E 11AD';
ok Uni.new(0xD233).NFD.list ~~ (0x1110, 0x116E, 0x11AE,), 'D233 -> 1110 116E 11AE';
ok Uni.new(0xD234).NFD.list ~~ (0x1110, 0x116E, 0x11AF,), 'D234 -> 1110 116E 11AF';
ok Uni.new(0xD235).NFD.list ~~ (0x1110, 0x116E, 0x11B0,), 'D235 -> 1110 116E 11B0';
ok Uni.new(0xD236).NFD.list ~~ (0x1110, 0x116E, 0x11B1,), 'D236 -> 1110 116E 11B1';
ok Uni.new(0xD237).NFD.list ~~ (0x1110, 0x116E, 0x11B2,), 'D237 -> 1110 116E 11B2';
ok Uni.new(0xD238).NFD.list ~~ (0x1110, 0x116E, 0x11B3,), 'D238 -> 1110 116E 11B3';
ok Uni.new(0xD239).NFD.list ~~ (0x1110, 0x116E, 0x11B4,), 'D239 -> 1110 116E 11B4';
ok Uni.new(0xD23A).NFD.list ~~ (0x1110, 0x116E, 0x11B5,), 'D23A -> 1110 116E 11B5';
ok Uni.new(0xD23B).NFD.list ~~ (0x1110, 0x116E, 0x11B6,), 'D23B -> 1110 116E 11B6';
ok Uni.new(0xD23C).NFD.list ~~ (0x1110, 0x116E, 0x11B7,), 'D23C -> 1110 116E 11B7';
ok Uni.new(0xD23D).NFD.list ~~ (0x1110, 0x116E, 0x11B8,), 'D23D -> 1110 116E 11B8';
ok Uni.new(0xD23E).NFD.list ~~ (0x1110, 0x116E, 0x11B9,), 'D23E -> 1110 116E 11B9';
ok Uni.new(0xD23F).NFD.list ~~ (0x1110, 0x116E, 0x11BA,), 'D23F -> 1110 116E 11BA';
ok Uni.new(0xD240).NFD.list ~~ (0x1110, 0x116E, 0x11BB,), 'D240 -> 1110 116E 11BB';
ok Uni.new(0xD241).NFD.list ~~ (0x1110, 0x116E, 0x11BC,), 'D241 -> 1110 116E 11BC';
ok Uni.new(0xD242).NFD.list ~~ (0x1110, 0x116E, 0x11BD,), 'D242 -> 1110 116E 11BD';
ok Uni.new(0xD243).NFD.list ~~ (0x1110, 0x116E, 0x11BE,), 'D243 -> 1110 116E 11BE';
ok Uni.new(0xD244).NFD.list ~~ (0x1110, 0x116E, 0x11BF,), 'D244 -> 1110 116E 11BF';
ok Uni.new(0xD245).NFD.list ~~ (0x1110, 0x116E, 0x11C0,), 'D245 -> 1110 116E 11C0';
ok Uni.new(0xD246).NFD.list ~~ (0x1110, 0x116E, 0x11C1,), 'D246 -> 1110 116E 11C1';
ok Uni.new(0xD247).NFD.list ~~ (0x1110, 0x116E, 0x11C2,), 'D247 -> 1110 116E 11C2';
ok Uni.new(0xD248).NFD.list ~~ (0x1110, 0x116F,), 'D248 -> 1110 116F';
ok Uni.new(0xD249).NFD.list ~~ (0x1110, 0x116F, 0x11A8,), 'D249 -> 1110 116F 11A8';
ok Uni.new(0xD24A).NFD.list ~~ (0x1110, 0x116F, 0x11A9,), 'D24A -> 1110 116F 11A9';
ok Uni.new(0xD24B).NFD.list ~~ (0x1110, 0x116F, 0x11AA,), 'D24B -> 1110 116F 11AA';
ok Uni.new(0xD24C).NFD.list ~~ (0x1110, 0x116F, 0x11AB,), 'D24C -> 1110 116F 11AB';
ok Uni.new(0xD24D).NFD.list ~~ (0x1110, 0x116F, 0x11AC,), 'D24D -> 1110 116F 11AC';
ok Uni.new(0xD24E).NFD.list ~~ (0x1110, 0x116F, 0x11AD,), 'D24E -> 1110 116F 11AD';
ok Uni.new(0xD24F).NFD.list ~~ (0x1110, 0x116F, 0x11AE,), 'D24F -> 1110 116F 11AE';
ok Uni.new(0xD250).NFD.list ~~ (0x1110, 0x116F, 0x11AF,), 'D250 -> 1110 116F 11AF';
ok Uni.new(0xD251).NFD.list ~~ (0x1110, 0x116F, 0x11B0,), 'D251 -> 1110 116F 11B0';
ok Uni.new(0xD252).NFD.list ~~ (0x1110, 0x116F, 0x11B1,), 'D252 -> 1110 116F 11B1';
ok Uni.new(0xD253).NFD.list ~~ (0x1110, 0x116F, 0x11B2,), 'D253 -> 1110 116F 11B2';
ok Uni.new(0xD254).NFD.list ~~ (0x1110, 0x116F, 0x11B3,), 'D254 -> 1110 116F 11B3';
ok Uni.new(0xD255).NFD.list ~~ (0x1110, 0x116F, 0x11B4,), 'D255 -> 1110 116F 11B4';
ok Uni.new(0xD256).NFD.list ~~ (0x1110, 0x116F, 0x11B5,), 'D256 -> 1110 116F 11B5';
ok Uni.new(0xD257).NFD.list ~~ (0x1110, 0x116F, 0x11B6,), 'D257 -> 1110 116F 11B6';
ok Uni.new(0xD258).NFD.list ~~ (0x1110, 0x116F, 0x11B7,), 'D258 -> 1110 116F 11B7';
ok Uni.new(0xD259).NFD.list ~~ (0x1110, 0x116F, 0x11B8,), 'D259 -> 1110 116F 11B8';
ok Uni.new(0xD25A).NFD.list ~~ (0x1110, 0x116F, 0x11B9,), 'D25A -> 1110 116F 11B9';
ok Uni.new(0xD25B).NFD.list ~~ (0x1110, 0x116F, 0x11BA,), 'D25B -> 1110 116F 11BA';
ok Uni.new(0xD25C).NFD.list ~~ (0x1110, 0x116F, 0x11BB,), 'D25C -> 1110 116F 11BB';
ok Uni.new(0xD25D).NFD.list ~~ (0x1110, 0x116F, 0x11BC,), 'D25D -> 1110 116F 11BC';
ok Uni.new(0xD25E).NFD.list ~~ (0x1110, 0x116F, 0x11BD,), 'D25E -> 1110 116F 11BD';
ok Uni.new(0xD25F).NFD.list ~~ (0x1110, 0x116F, 0x11BE,), 'D25F -> 1110 116F 11BE';
ok Uni.new(0xD260).NFD.list ~~ (0x1110, 0x116F, 0x11BF,), 'D260 -> 1110 116F 11BF';
ok Uni.new(0xD261).NFD.list ~~ (0x1110, 0x116F, 0x11C0,), 'D261 -> 1110 116F 11C0';
ok Uni.new(0xD262).NFD.list ~~ (0x1110, 0x116F, 0x11C1,), 'D262 -> 1110 116F 11C1';
ok Uni.new(0xD263).NFD.list ~~ (0x1110, 0x116F, 0x11C2,), 'D263 -> 1110 116F 11C2';
ok Uni.new(0xD264).NFD.list ~~ (0x1110, 0x1170,), 'D264 -> 1110 1170';
ok Uni.new(0xD265).NFD.list ~~ (0x1110, 0x1170, 0x11A8,), 'D265 -> 1110 1170 11A8';
ok Uni.new(0xD266).NFD.list ~~ (0x1110, 0x1170, 0x11A9,), 'D266 -> 1110 1170 11A9';
ok Uni.new(0xD267).NFD.list ~~ (0x1110, 0x1170, 0x11AA,), 'D267 -> 1110 1170 11AA';
ok Uni.new(0xD268).NFD.list ~~ (0x1110, 0x1170, 0x11AB,), 'D268 -> 1110 1170 11AB';
ok Uni.new(0xD269).NFD.list ~~ (0x1110, 0x1170, 0x11AC,), 'D269 -> 1110 1170 11AC';
ok Uni.new(0xD26A).NFD.list ~~ (0x1110, 0x1170, 0x11AD,), 'D26A -> 1110 1170 11AD';
ok Uni.new(0xD26B).NFD.list ~~ (0x1110, 0x1170, 0x11AE,), 'D26B -> 1110 1170 11AE';
ok Uni.new(0xD26C).NFD.list ~~ (0x1110, 0x1170, 0x11AF,), 'D26C -> 1110 1170 11AF';
ok Uni.new(0xD26D).NFD.list ~~ (0x1110, 0x1170, 0x11B0,), 'D26D -> 1110 1170 11B0';
ok Uni.new(0xD26E).NFD.list ~~ (0x1110, 0x1170, 0x11B1,), 'D26E -> 1110 1170 11B1';
ok Uni.new(0xD26F).NFD.list ~~ (0x1110, 0x1170, 0x11B2,), 'D26F -> 1110 1170 11B2';
ok Uni.new(0xD270).NFD.list ~~ (0x1110, 0x1170, 0x11B3,), 'D270 -> 1110 1170 11B3';
ok Uni.new(0xD271).NFD.list ~~ (0x1110, 0x1170, 0x11B4,), 'D271 -> 1110 1170 11B4';
ok Uni.new(0xD272).NFD.list ~~ (0x1110, 0x1170, 0x11B5,), 'D272 -> 1110 1170 11B5';
ok Uni.new(0xD273).NFD.list ~~ (0x1110, 0x1170, 0x11B6,), 'D273 -> 1110 1170 11B6';
ok Uni.new(0xD274).NFD.list ~~ (0x1110, 0x1170, 0x11B7,), 'D274 -> 1110 1170 11B7';
ok Uni.new(0xD275).NFD.list ~~ (0x1110, 0x1170, 0x11B8,), 'D275 -> 1110 1170 11B8';
ok Uni.new(0xD276).NFD.list ~~ (0x1110, 0x1170, 0x11B9,), 'D276 -> 1110 1170 11B9';
ok Uni.new(0xD277).NFD.list ~~ (0x1110, 0x1170, 0x11BA,), 'D277 -> 1110 1170 11BA';
ok Uni.new(0xD278).NFD.list ~~ (0x1110, 0x1170, 0x11BB,), 'D278 -> 1110 1170 11BB';
ok Uni.new(0xD279).NFD.list ~~ (0x1110, 0x1170, 0x11BC,), 'D279 -> 1110 1170 11BC';
ok Uni.new(0xD27A).NFD.list ~~ (0x1110, 0x1170, 0x11BD,), 'D27A -> 1110 1170 11BD';
ok Uni.new(0xD27B).NFD.list ~~ (0x1110, 0x1170, 0x11BE,), 'D27B -> 1110 1170 11BE';
ok Uni.new(0xD27C).NFD.list ~~ (0x1110, 0x1170, 0x11BF,), 'D27C -> 1110 1170 11BF';
ok Uni.new(0xD27D).NFD.list ~~ (0x1110, 0x1170, 0x11C0,), 'D27D -> 1110 1170 11C0';
ok Uni.new(0xD27E).NFD.list ~~ (0x1110, 0x1170, 0x11C1,), 'D27E -> 1110 1170 11C1';
ok Uni.new(0xD27F).NFD.list ~~ (0x1110, 0x1170, 0x11C2,), 'D27F -> 1110 1170 11C2';
ok Uni.new(0xD280).NFD.list ~~ (0x1110, 0x1171,), 'D280 -> 1110 1171';
ok Uni.new(0xD281).NFD.list ~~ (0x1110, 0x1171, 0x11A8,), 'D281 -> 1110 1171 11A8';
ok Uni.new(0xD282).NFD.list ~~ (0x1110, 0x1171, 0x11A9,), 'D282 -> 1110 1171 11A9';
ok Uni.new(0xD283).NFD.list ~~ (0x1110, 0x1171, 0x11AA,), 'D283 -> 1110 1171 11AA';
ok Uni.new(0xD284).NFD.list ~~ (0x1110, 0x1171, 0x11AB,), 'D284 -> 1110 1171 11AB';
ok Uni.new(0xD285).NFD.list ~~ (0x1110, 0x1171, 0x11AC,), 'D285 -> 1110 1171 11AC';
ok Uni.new(0xD286).NFD.list ~~ (0x1110, 0x1171, 0x11AD,), 'D286 -> 1110 1171 11AD';
ok Uni.new(0xD287).NFD.list ~~ (0x1110, 0x1171, 0x11AE,), 'D287 -> 1110 1171 11AE';
ok Uni.new(0xD288).NFD.list ~~ (0x1110, 0x1171, 0x11AF,), 'D288 -> 1110 1171 11AF';
ok Uni.new(0xD289).NFD.list ~~ (0x1110, 0x1171, 0x11B0,), 'D289 -> 1110 1171 11B0';
ok Uni.new(0xD28A).NFD.list ~~ (0x1110, 0x1171, 0x11B1,), 'D28A -> 1110 1171 11B1';
ok Uni.new(0xD28B).NFD.list ~~ (0x1110, 0x1171, 0x11B2,), 'D28B -> 1110 1171 11B2';
ok Uni.new(0xD28C).NFD.list ~~ (0x1110, 0x1171, 0x11B3,), 'D28C -> 1110 1171 11B3';
ok Uni.new(0xD28D).NFD.list ~~ (0x1110, 0x1171, 0x11B4,), 'D28D -> 1110 1171 11B4';
ok Uni.new(0xD28E).NFD.list ~~ (0x1110, 0x1171, 0x11B5,), 'D28E -> 1110 1171 11B5';
ok Uni.new(0xD28F).NFD.list ~~ (0x1110, 0x1171, 0x11B6,), 'D28F -> 1110 1171 11B6';
ok Uni.new(0xD290).NFD.list ~~ (0x1110, 0x1171, 0x11B7,), 'D290 -> 1110 1171 11B7';
ok Uni.new(0xD291).NFD.list ~~ (0x1110, 0x1171, 0x11B8,), 'D291 -> 1110 1171 11B8';
ok Uni.new(0xD292).NFD.list ~~ (0x1110, 0x1171, 0x11B9,), 'D292 -> 1110 1171 11B9';
ok Uni.new(0xD293).NFD.list ~~ (0x1110, 0x1171, 0x11BA,), 'D293 -> 1110 1171 11BA';
ok Uni.new(0xD294).NFD.list ~~ (0x1110, 0x1171, 0x11BB,), 'D294 -> 1110 1171 11BB';
ok Uni.new(0xD295).NFD.list ~~ (0x1110, 0x1171, 0x11BC,), 'D295 -> 1110 1171 11BC';
ok Uni.new(0xD296).NFD.list ~~ (0x1110, 0x1171, 0x11BD,), 'D296 -> 1110 1171 11BD';
ok Uni.new(0xD297).NFD.list ~~ (0x1110, 0x1171, 0x11BE,), 'D297 -> 1110 1171 11BE';
ok Uni.new(0xD298).NFD.list ~~ (0x1110, 0x1171, 0x11BF,), 'D298 -> 1110 1171 11BF';
ok Uni.new(0xD299).NFD.list ~~ (0x1110, 0x1171, 0x11C0,), 'D299 -> 1110 1171 11C0';
ok Uni.new(0xD29A).NFD.list ~~ (0x1110, 0x1171, 0x11C1,), 'D29A -> 1110 1171 11C1';
ok Uni.new(0xD29B).NFD.list ~~ (0x1110, 0x1171, 0x11C2,), 'D29B -> 1110 1171 11C2';
ok Uni.new(0xD29C).NFD.list ~~ (0x1110, 0x1172,), 'D29C -> 1110 1172';
ok Uni.new(0xD29D).NFD.list ~~ (0x1110, 0x1172, 0x11A8,), 'D29D -> 1110 1172 11A8';
ok Uni.new(0xD29E).NFD.list ~~ (0x1110, 0x1172, 0x11A9,), 'D29E -> 1110 1172 11A9';
ok Uni.new(0xD29F).NFD.list ~~ (0x1110, 0x1172, 0x11AA,), 'D29F -> 1110 1172 11AA';
ok Uni.new(0xD2A0).NFD.list ~~ (0x1110, 0x1172, 0x11AB,), 'D2A0 -> 1110 1172 11AB';
ok Uni.new(0xD2A1).NFD.list ~~ (0x1110, 0x1172, 0x11AC,), 'D2A1 -> 1110 1172 11AC';
ok Uni.new(0xD2A2).NFD.list ~~ (0x1110, 0x1172, 0x11AD,), 'D2A2 -> 1110 1172 11AD';
ok Uni.new(0xD2A3).NFD.list ~~ (0x1110, 0x1172, 0x11AE,), 'D2A3 -> 1110 1172 11AE';
ok Uni.new(0xD2A4).NFD.list ~~ (0x1110, 0x1172, 0x11AF,), 'D2A4 -> 1110 1172 11AF';
ok Uni.new(0xD2A5).NFD.list ~~ (0x1110, 0x1172, 0x11B0,), 'D2A5 -> 1110 1172 11B0';
ok Uni.new(0xD2A6).NFD.list ~~ (0x1110, 0x1172, 0x11B1,), 'D2A6 -> 1110 1172 11B1';
ok Uni.new(0xD2A7).NFD.list ~~ (0x1110, 0x1172, 0x11B2,), 'D2A7 -> 1110 1172 11B2';
ok Uni.new(0xD2A8).NFD.list ~~ (0x1110, 0x1172, 0x11B3,), 'D2A8 -> 1110 1172 11B3';
ok Uni.new(0xD2A9).NFD.list ~~ (0x1110, 0x1172, 0x11B4,), 'D2A9 -> 1110 1172 11B4';
ok Uni.new(0xD2AA).NFD.list ~~ (0x1110, 0x1172, 0x11B5,), 'D2AA -> 1110 1172 11B5';
ok Uni.new(0xD2AB).NFD.list ~~ (0x1110, 0x1172, 0x11B6,), 'D2AB -> 1110 1172 11B6';
ok Uni.new(0xD2AC).NFD.list ~~ (0x1110, 0x1172, 0x11B7,), 'D2AC -> 1110 1172 11B7';
ok Uni.new(0xD2AD).NFD.list ~~ (0x1110, 0x1172, 0x11B8,), 'D2AD -> 1110 1172 11B8';
ok Uni.new(0xD2AE).NFD.list ~~ (0x1110, 0x1172, 0x11B9,), 'D2AE -> 1110 1172 11B9';
ok Uni.new(0xD2AF).NFD.list ~~ (0x1110, 0x1172, 0x11BA,), 'D2AF -> 1110 1172 11BA';
ok Uni.new(0xD2B0).NFD.list ~~ (0x1110, 0x1172, 0x11BB,), 'D2B0 -> 1110 1172 11BB';
ok Uni.new(0xD2B1).NFD.list ~~ (0x1110, 0x1172, 0x11BC,), 'D2B1 -> 1110 1172 11BC';
ok Uni.new(0xD2B2).NFD.list ~~ (0x1110, 0x1172, 0x11BD,), 'D2B2 -> 1110 1172 11BD';
ok Uni.new(0xD2B3).NFD.list ~~ (0x1110, 0x1172, 0x11BE,), 'D2B3 -> 1110 1172 11BE';
ok Uni.new(0xD2B4).NFD.list ~~ (0x1110, 0x1172, 0x11BF,), 'D2B4 -> 1110 1172 11BF';
ok Uni.new(0xD2B5).NFD.list ~~ (0x1110, 0x1172, 0x11C0,), 'D2B5 -> 1110 1172 11C0';
ok Uni.new(0xD2B6).NFD.list ~~ (0x1110, 0x1172, 0x11C1,), 'D2B6 -> 1110 1172 11C1';
ok Uni.new(0xD2B7).NFD.list ~~ (0x1110, 0x1172, 0x11C2,), 'D2B7 -> 1110 1172 11C2';
ok Uni.new(0xD2B8).NFD.list ~~ (0x1110, 0x1173,), 'D2B8 -> 1110 1173';
ok Uni.new(0xD2B9).NFD.list ~~ (0x1110, 0x1173, 0x11A8,), 'D2B9 -> 1110 1173 11A8';
ok Uni.new(0xD2BA).NFD.list ~~ (0x1110, 0x1173, 0x11A9,), 'D2BA -> 1110 1173 11A9';
ok Uni.new(0xD2BB).NFD.list ~~ (0x1110, 0x1173, 0x11AA,), 'D2BB -> 1110 1173 11AA';
ok Uni.new(0xD2BC).NFD.list ~~ (0x1110, 0x1173, 0x11AB,), 'D2BC -> 1110 1173 11AB';
ok Uni.new(0xD2BD).NFD.list ~~ (0x1110, 0x1173, 0x11AC,), 'D2BD -> 1110 1173 11AC';
ok Uni.new(0xD2BE).NFD.list ~~ (0x1110, 0x1173, 0x11AD,), 'D2BE -> 1110 1173 11AD';
ok Uni.new(0xD2BF).NFD.list ~~ (0x1110, 0x1173, 0x11AE,), 'D2BF -> 1110 1173 11AE';
ok Uni.new(0xD2C0).NFD.list ~~ (0x1110, 0x1173, 0x11AF,), 'D2C0 -> 1110 1173 11AF';
ok Uni.new(0xD2C1).NFD.list ~~ (0x1110, 0x1173, 0x11B0,), 'D2C1 -> 1110 1173 11B0';
ok Uni.new(0xD2C2).NFD.list ~~ (0x1110, 0x1173, 0x11B1,), 'D2C2 -> 1110 1173 11B1';
ok Uni.new(0xD2C3).NFD.list ~~ (0x1110, 0x1173, 0x11B2,), 'D2C3 -> 1110 1173 11B2';
ok Uni.new(0xD2C4).NFD.list ~~ (0x1110, 0x1173, 0x11B3,), 'D2C4 -> 1110 1173 11B3';
ok Uni.new(0xD2C5).NFD.list ~~ (0x1110, 0x1173, 0x11B4,), 'D2C5 -> 1110 1173 11B4';
ok Uni.new(0xD2C6).NFD.list ~~ (0x1110, 0x1173, 0x11B5,), 'D2C6 -> 1110 1173 11B5';
ok Uni.new(0xD2C7).NFD.list ~~ (0x1110, 0x1173, 0x11B6,), 'D2C7 -> 1110 1173 11B6';
ok Uni.new(0xD2C8).NFD.list ~~ (0x1110, 0x1173, 0x11B7,), 'D2C8 -> 1110 1173 11B7';
ok Uni.new(0xD2C9).NFD.list ~~ (0x1110, 0x1173, 0x11B8,), 'D2C9 -> 1110 1173 11B8';
ok Uni.new(0xD2CA).NFD.list ~~ (0x1110, 0x1173, 0x11B9,), 'D2CA -> 1110 1173 11B9';
ok Uni.new(0xD2CB).NFD.list ~~ (0x1110, 0x1173, 0x11BA,), 'D2CB -> 1110 1173 11BA';
ok Uni.new(0xD2CC).NFD.list ~~ (0x1110, 0x1173, 0x11BB,), 'D2CC -> 1110 1173 11BB';
ok Uni.new(0xD2CD).NFD.list ~~ (0x1110, 0x1173, 0x11BC,), 'D2CD -> 1110 1173 11BC';
ok Uni.new(0xD2CE).NFD.list ~~ (0x1110, 0x1173, 0x11BD,), 'D2CE -> 1110 1173 11BD';
ok Uni.new(0xD2CF).NFD.list ~~ (0x1110, 0x1173, 0x11BE,), 'D2CF -> 1110 1173 11BE';
ok Uni.new(0xD2D0).NFD.list ~~ (0x1110, 0x1173, 0x11BF,), 'D2D0 -> 1110 1173 11BF';
ok Uni.new(0xD2D1).NFD.list ~~ (0x1110, 0x1173, 0x11C0,), 'D2D1 -> 1110 1173 11C0';
ok Uni.new(0xD2D2).NFD.list ~~ (0x1110, 0x1173, 0x11C1,), 'D2D2 -> 1110 1173 11C1';
ok Uni.new(0xD2D3).NFD.list ~~ (0x1110, 0x1173, 0x11C2,), 'D2D3 -> 1110 1173 11C2';
ok Uni.new(0xD2D4).NFD.list ~~ (0x1110, 0x1174,), 'D2D4 -> 1110 1174';
ok Uni.new(0xD2D5).NFD.list ~~ (0x1110, 0x1174, 0x11A8,), 'D2D5 -> 1110 1174 11A8';
ok Uni.new(0xD2D6).NFD.list ~~ (0x1110, 0x1174, 0x11A9,), 'D2D6 -> 1110 1174 11A9';
ok Uni.new(0xD2D7).NFD.list ~~ (0x1110, 0x1174, 0x11AA,), 'D2D7 -> 1110 1174 11AA';
ok Uni.new(0xD2D8).NFD.list ~~ (0x1110, 0x1174, 0x11AB,), 'D2D8 -> 1110 1174 11AB';
ok Uni.new(0xD2D9).NFD.list ~~ (0x1110, 0x1174, 0x11AC,), 'D2D9 -> 1110 1174 11AC';
ok Uni.new(0xD2DA).NFD.list ~~ (0x1110, 0x1174, 0x11AD,), 'D2DA -> 1110 1174 11AD';
ok Uni.new(0xD2DB).NFD.list ~~ (0x1110, 0x1174, 0x11AE,), 'D2DB -> 1110 1174 11AE';
ok Uni.new(0xD2DC).NFD.list ~~ (0x1110, 0x1174, 0x11AF,), 'D2DC -> 1110 1174 11AF';
ok Uni.new(0xD2DD).NFD.list ~~ (0x1110, 0x1174, 0x11B0,), 'D2DD -> 1110 1174 11B0';
ok Uni.new(0xD2DE).NFD.list ~~ (0x1110, 0x1174, 0x11B1,), 'D2DE -> 1110 1174 11B1';
ok Uni.new(0xD2DF).NFD.list ~~ (0x1110, 0x1174, 0x11B2,), 'D2DF -> 1110 1174 11B2';
ok Uni.new(0xD2E0).NFD.list ~~ (0x1110, 0x1174, 0x11B3,), 'D2E0 -> 1110 1174 11B3';
ok Uni.new(0xD2E1).NFD.list ~~ (0x1110, 0x1174, 0x11B4,), 'D2E1 -> 1110 1174 11B4';
ok Uni.new(0xD2E2).NFD.list ~~ (0x1110, 0x1174, 0x11B5,), 'D2E2 -> 1110 1174 11B5';
ok Uni.new(0xD2E3).NFD.list ~~ (0x1110, 0x1174, 0x11B6,), 'D2E3 -> 1110 1174 11B6';
ok Uni.new(0xD2E4).NFD.list ~~ (0x1110, 0x1174, 0x11B7,), 'D2E4 -> 1110 1174 11B7';
ok Uni.new(0xD2E5).NFD.list ~~ (0x1110, 0x1174, 0x11B8,), 'D2E5 -> 1110 1174 11B8';
ok Uni.new(0xD2E6).NFD.list ~~ (0x1110, 0x1174, 0x11B9,), 'D2E6 -> 1110 1174 11B9';
ok Uni.new(0xD2E7).NFD.list ~~ (0x1110, 0x1174, 0x11BA,), 'D2E7 -> 1110 1174 11BA';
ok Uni.new(0xD2E8).NFD.list ~~ (0x1110, 0x1174, 0x11BB,), 'D2E8 -> 1110 1174 11BB';
ok Uni.new(0xD2E9).NFD.list ~~ (0x1110, 0x1174, 0x11BC,), 'D2E9 -> 1110 1174 11BC';
ok Uni.new(0xD2EA).NFD.list ~~ (0x1110, 0x1174, 0x11BD,), 'D2EA -> 1110 1174 11BD';
ok Uni.new(0xD2EB).NFD.list ~~ (0x1110, 0x1174, 0x11BE,), 'D2EB -> 1110 1174 11BE';
ok Uni.new(0xD2EC).NFD.list ~~ (0x1110, 0x1174, 0x11BF,), 'D2EC -> 1110 1174 11BF';
ok Uni.new(0xD2ED).NFD.list ~~ (0x1110, 0x1174, 0x11C0,), 'D2ED -> 1110 1174 11C0';
ok Uni.new(0xD2EE).NFD.list ~~ (0x1110, 0x1174, 0x11C1,), 'D2EE -> 1110 1174 11C1';
ok Uni.new(0xD2EF).NFD.list ~~ (0x1110, 0x1174, 0x11C2,), 'D2EF -> 1110 1174 11C2';
ok Uni.new(0xD2F0).NFD.list ~~ (0x1110, 0x1175,), 'D2F0 -> 1110 1175';
ok Uni.new(0xD2F1).NFD.list ~~ (0x1110, 0x1175, 0x11A8,), 'D2F1 -> 1110 1175 11A8';
ok Uni.new(0xD2F2).NFD.list ~~ (0x1110, 0x1175, 0x11A9,), 'D2F2 -> 1110 1175 11A9';
ok Uni.new(0xD2F3).NFD.list ~~ (0x1110, 0x1175, 0x11AA,), 'D2F3 -> 1110 1175 11AA';
ok Uni.new(0xD2F4).NFD.list ~~ (0x1110, 0x1175, 0x11AB,), 'D2F4 -> 1110 1175 11AB';
ok Uni.new(0xD2F5).NFD.list ~~ (0x1110, 0x1175, 0x11AC,), 'D2F5 -> 1110 1175 11AC';
ok Uni.new(0xD2F6).NFD.list ~~ (0x1110, 0x1175, 0x11AD,), 'D2F6 -> 1110 1175 11AD';
ok Uni.new(0xD2F7).NFD.list ~~ (0x1110, 0x1175, 0x11AE,), 'D2F7 -> 1110 1175 11AE';
ok Uni.new(0xD2F8).NFD.list ~~ (0x1110, 0x1175, 0x11AF,), 'D2F8 -> 1110 1175 11AF';
ok Uni.new(0xD2F9).NFD.list ~~ (0x1110, 0x1175, 0x11B0,), 'D2F9 -> 1110 1175 11B0';
ok Uni.new(0xD2FA).NFD.list ~~ (0x1110, 0x1175, 0x11B1,), 'D2FA -> 1110 1175 11B1';
ok Uni.new(0xD2FB).NFD.list ~~ (0x1110, 0x1175, 0x11B2,), 'D2FB -> 1110 1175 11B2';
ok Uni.new(0xD2FC).NFD.list ~~ (0x1110, 0x1175, 0x11B3,), 'D2FC -> 1110 1175 11B3';
ok Uni.new(0xD2FD).NFD.list ~~ (0x1110, 0x1175, 0x11B4,), 'D2FD -> 1110 1175 11B4';
ok Uni.new(0xD2FE).NFD.list ~~ (0x1110, 0x1175, 0x11B5,), 'D2FE -> 1110 1175 11B5';
ok Uni.new(0xD2FF).NFD.list ~~ (0x1110, 0x1175, 0x11B6,), 'D2FF -> 1110 1175 11B6';
ok Uni.new(0xD300).NFD.list ~~ (0x1110, 0x1175, 0x11B7,), 'D300 -> 1110 1175 11B7';
ok Uni.new(0xD301).NFD.list ~~ (0x1110, 0x1175, 0x11B8,), 'D301 -> 1110 1175 11B8';
ok Uni.new(0xD302).NFD.list ~~ (0x1110, 0x1175, 0x11B9,), 'D302 -> 1110 1175 11B9';
ok Uni.new(0xD303).NFD.list ~~ (0x1110, 0x1175, 0x11BA,), 'D303 -> 1110 1175 11BA';
ok Uni.new(0xD304).NFD.list ~~ (0x1110, 0x1175, 0x11BB,), 'D304 -> 1110 1175 11BB';
ok Uni.new(0xD305).NFD.list ~~ (0x1110, 0x1175, 0x11BC,), 'D305 -> 1110 1175 11BC';
ok Uni.new(0xD306).NFD.list ~~ (0x1110, 0x1175, 0x11BD,), 'D306 -> 1110 1175 11BD';
ok Uni.new(0xD307).NFD.list ~~ (0x1110, 0x1175, 0x11BE,), 'D307 -> 1110 1175 11BE';
ok Uni.new(0xD308).NFD.list ~~ (0x1110, 0x1175, 0x11BF,), 'D308 -> 1110 1175 11BF';
ok Uni.new(0xD309).NFD.list ~~ (0x1110, 0x1175, 0x11C0,), 'D309 -> 1110 1175 11C0';
ok Uni.new(0xD30A).NFD.list ~~ (0x1110, 0x1175, 0x11C1,), 'D30A -> 1110 1175 11C1';
ok Uni.new(0xD30B).NFD.list ~~ (0x1110, 0x1175, 0x11C2,), 'D30B -> 1110 1175 11C2';
ok Uni.new(0xD30C).NFD.list ~~ (0x1111, 0x1161,), 'D30C -> 1111 1161';
ok Uni.new(0xD30D).NFD.list ~~ (0x1111, 0x1161, 0x11A8,), 'D30D -> 1111 1161 11A8';
ok Uni.new(0xD30E).NFD.list ~~ (0x1111, 0x1161, 0x11A9,), 'D30E -> 1111 1161 11A9';
ok Uni.new(0xD30F).NFD.list ~~ (0x1111, 0x1161, 0x11AA,), 'D30F -> 1111 1161 11AA';
ok Uni.new(0xD310).NFD.list ~~ (0x1111, 0x1161, 0x11AB,), 'D310 -> 1111 1161 11AB';
ok Uni.new(0xD311).NFD.list ~~ (0x1111, 0x1161, 0x11AC,), 'D311 -> 1111 1161 11AC';
ok Uni.new(0xD312).NFD.list ~~ (0x1111, 0x1161, 0x11AD,), 'D312 -> 1111 1161 11AD';
ok Uni.new(0xD313).NFD.list ~~ (0x1111, 0x1161, 0x11AE,), 'D313 -> 1111 1161 11AE';
ok Uni.new(0xD314).NFD.list ~~ (0x1111, 0x1161, 0x11AF,), 'D314 -> 1111 1161 11AF';
ok Uni.new(0xD315).NFD.list ~~ (0x1111, 0x1161, 0x11B0,), 'D315 -> 1111 1161 11B0';
ok Uni.new(0xD316).NFD.list ~~ (0x1111, 0x1161, 0x11B1,), 'D316 -> 1111 1161 11B1';
ok Uni.new(0xD317).NFD.list ~~ (0x1111, 0x1161, 0x11B2,), 'D317 -> 1111 1161 11B2';
ok Uni.new(0xD318).NFD.list ~~ (0x1111, 0x1161, 0x11B3,), 'D318 -> 1111 1161 11B3';
ok Uni.new(0xD319).NFD.list ~~ (0x1111, 0x1161, 0x11B4,), 'D319 -> 1111 1161 11B4';
ok Uni.new(0xD31A).NFD.list ~~ (0x1111, 0x1161, 0x11B5,), 'D31A -> 1111 1161 11B5';
ok Uni.new(0xD31B).NFD.list ~~ (0x1111, 0x1161, 0x11B6,), 'D31B -> 1111 1161 11B6';
ok Uni.new(0xD31C).NFD.list ~~ (0x1111, 0x1161, 0x11B7,), 'D31C -> 1111 1161 11B7';
ok Uni.new(0xD31D).NFD.list ~~ (0x1111, 0x1161, 0x11B8,), 'D31D -> 1111 1161 11B8';
ok Uni.new(0xD31E).NFD.list ~~ (0x1111, 0x1161, 0x11B9,), 'D31E -> 1111 1161 11B9';
ok Uni.new(0xD31F).NFD.list ~~ (0x1111, 0x1161, 0x11BA,), 'D31F -> 1111 1161 11BA';
ok Uni.new(0xD320).NFD.list ~~ (0x1111, 0x1161, 0x11BB,), 'D320 -> 1111 1161 11BB';
ok Uni.new(0xD321).NFD.list ~~ (0x1111, 0x1161, 0x11BC,), 'D321 -> 1111 1161 11BC';
ok Uni.new(0xD322).NFD.list ~~ (0x1111, 0x1161, 0x11BD,), 'D322 -> 1111 1161 11BD';
ok Uni.new(0xD323).NFD.list ~~ (0x1111, 0x1161, 0x11BE,), 'D323 -> 1111 1161 11BE';
ok Uni.new(0xD324).NFD.list ~~ (0x1111, 0x1161, 0x11BF,), 'D324 -> 1111 1161 11BF';
ok Uni.new(0xD325).NFD.list ~~ (0x1111, 0x1161, 0x11C0,), 'D325 -> 1111 1161 11C0';
ok Uni.new(0xD326).NFD.list ~~ (0x1111, 0x1161, 0x11C1,), 'D326 -> 1111 1161 11C1';
ok Uni.new(0xD327).NFD.list ~~ (0x1111, 0x1161, 0x11C2,), 'D327 -> 1111 1161 11C2';
ok Uni.new(0xD328).NFD.list ~~ (0x1111, 0x1162,), 'D328 -> 1111 1162';
ok Uni.new(0xD329).NFD.list ~~ (0x1111, 0x1162, 0x11A8,), 'D329 -> 1111 1162 11A8';
ok Uni.new(0xD32A).NFD.list ~~ (0x1111, 0x1162, 0x11A9,), 'D32A -> 1111 1162 11A9';
ok Uni.new(0xD32B).NFD.list ~~ (0x1111, 0x1162, 0x11AA,), 'D32B -> 1111 1162 11AA';
ok Uni.new(0xD32C).NFD.list ~~ (0x1111, 0x1162, 0x11AB,), 'D32C -> 1111 1162 11AB';
ok Uni.new(0xD32D).NFD.list ~~ (0x1111, 0x1162, 0x11AC,), 'D32D -> 1111 1162 11AC';
ok Uni.new(0xD32E).NFD.list ~~ (0x1111, 0x1162, 0x11AD,), 'D32E -> 1111 1162 11AD';
ok Uni.new(0xD32F).NFD.list ~~ (0x1111, 0x1162, 0x11AE,), 'D32F -> 1111 1162 11AE';
ok Uni.new(0xD330).NFD.list ~~ (0x1111, 0x1162, 0x11AF,), 'D330 -> 1111 1162 11AF';
ok Uni.new(0xD331).NFD.list ~~ (0x1111, 0x1162, 0x11B0,), 'D331 -> 1111 1162 11B0';
ok Uni.new(0xD332).NFD.list ~~ (0x1111, 0x1162, 0x11B1,), 'D332 -> 1111 1162 11B1';
ok Uni.new(0xD333).NFD.list ~~ (0x1111, 0x1162, 0x11B2,), 'D333 -> 1111 1162 11B2';
ok Uni.new(0xD334).NFD.list ~~ (0x1111, 0x1162, 0x11B3,), 'D334 -> 1111 1162 11B3';
ok Uni.new(0xD335).NFD.list ~~ (0x1111, 0x1162, 0x11B4,), 'D335 -> 1111 1162 11B4';
ok Uni.new(0xD336).NFD.list ~~ (0x1111, 0x1162, 0x11B5,), 'D336 -> 1111 1162 11B5';
ok Uni.new(0xD337).NFD.list ~~ (0x1111, 0x1162, 0x11B6,), 'D337 -> 1111 1162 11B6';
ok Uni.new(0xD338).NFD.list ~~ (0x1111, 0x1162, 0x11B7,), 'D338 -> 1111 1162 11B7';
ok Uni.new(0xD339).NFD.list ~~ (0x1111, 0x1162, 0x11B8,), 'D339 -> 1111 1162 11B8';
ok Uni.new(0xD33A).NFD.list ~~ (0x1111, 0x1162, 0x11B9,), 'D33A -> 1111 1162 11B9';
ok Uni.new(0xD33B).NFD.list ~~ (0x1111, 0x1162, 0x11BA,), 'D33B -> 1111 1162 11BA';
ok Uni.new(0xD33C).NFD.list ~~ (0x1111, 0x1162, 0x11BB,), 'D33C -> 1111 1162 11BB';
ok Uni.new(0xD33D).NFD.list ~~ (0x1111, 0x1162, 0x11BC,), 'D33D -> 1111 1162 11BC';
ok Uni.new(0xD33E).NFD.list ~~ (0x1111, 0x1162, 0x11BD,), 'D33E -> 1111 1162 11BD';
ok Uni.new(0xD33F).NFD.list ~~ (0x1111, 0x1162, 0x11BE,), 'D33F -> 1111 1162 11BE';
ok Uni.new(0xD340).NFD.list ~~ (0x1111, 0x1162, 0x11BF,), 'D340 -> 1111 1162 11BF';
ok Uni.new(0xD341).NFD.list ~~ (0x1111, 0x1162, 0x11C0,), 'D341 -> 1111 1162 11C0';
ok Uni.new(0xD342).NFD.list ~~ (0x1111, 0x1162, 0x11C1,), 'D342 -> 1111 1162 11C1';
ok Uni.new(0xD343).NFD.list ~~ (0x1111, 0x1162, 0x11C2,), 'D343 -> 1111 1162 11C2';
ok Uni.new(0xD344).NFD.list ~~ (0x1111, 0x1163,), 'D344 -> 1111 1163';
ok Uni.new(0xD345).NFD.list ~~ (0x1111, 0x1163, 0x11A8,), 'D345 -> 1111 1163 11A8';
ok Uni.new(0xD346).NFD.list ~~ (0x1111, 0x1163, 0x11A9,), 'D346 -> 1111 1163 11A9';
ok Uni.new(0xD347).NFD.list ~~ (0x1111, 0x1163, 0x11AA,), 'D347 -> 1111 1163 11AA';
ok Uni.new(0xD348).NFD.list ~~ (0x1111, 0x1163, 0x11AB,), 'D348 -> 1111 1163 11AB';
ok Uni.new(0xD349).NFD.list ~~ (0x1111, 0x1163, 0x11AC,), 'D349 -> 1111 1163 11AC';
ok Uni.new(0xD34A).NFD.list ~~ (0x1111, 0x1163, 0x11AD,), 'D34A -> 1111 1163 11AD';
ok Uni.new(0xD34B).NFD.list ~~ (0x1111, 0x1163, 0x11AE,), 'D34B -> 1111 1163 11AE';
ok Uni.new(0xD34C).NFD.list ~~ (0x1111, 0x1163, 0x11AF,), 'D34C -> 1111 1163 11AF';
ok Uni.new(0xD34D).NFD.list ~~ (0x1111, 0x1163, 0x11B0,), 'D34D -> 1111 1163 11B0';
ok Uni.new(0xD34E).NFD.list ~~ (0x1111, 0x1163, 0x11B1,), 'D34E -> 1111 1163 11B1';
ok Uni.new(0xD34F).NFD.list ~~ (0x1111, 0x1163, 0x11B2,), 'D34F -> 1111 1163 11B2';
ok Uni.new(0xD350).NFD.list ~~ (0x1111, 0x1163, 0x11B3,), 'D350 -> 1111 1163 11B3';
ok Uni.new(0xD351).NFD.list ~~ (0x1111, 0x1163, 0x11B4,), 'D351 -> 1111 1163 11B4';
ok Uni.new(0xD352).NFD.list ~~ (0x1111, 0x1163, 0x11B5,), 'D352 -> 1111 1163 11B5';
ok Uni.new(0xD353).NFD.list ~~ (0x1111, 0x1163, 0x11B6,), 'D353 -> 1111 1163 11B6';
ok Uni.new(0xD354).NFD.list ~~ (0x1111, 0x1163, 0x11B7,), 'D354 -> 1111 1163 11B7';
ok Uni.new(0xD355).NFD.list ~~ (0x1111, 0x1163, 0x11B8,), 'D355 -> 1111 1163 11B8';
ok Uni.new(0xD356).NFD.list ~~ (0x1111, 0x1163, 0x11B9,), 'D356 -> 1111 1163 11B9';
ok Uni.new(0xD357).NFD.list ~~ (0x1111, 0x1163, 0x11BA,), 'D357 -> 1111 1163 11BA';
ok Uni.new(0xD358).NFD.list ~~ (0x1111, 0x1163, 0x11BB,), 'D358 -> 1111 1163 11BB';
ok Uni.new(0xD359).NFD.list ~~ (0x1111, 0x1163, 0x11BC,), 'D359 -> 1111 1163 11BC';
ok Uni.new(0xD35A).NFD.list ~~ (0x1111, 0x1163, 0x11BD,), 'D35A -> 1111 1163 11BD';
ok Uni.new(0xD35B).NFD.list ~~ (0x1111, 0x1163, 0x11BE,), 'D35B -> 1111 1163 11BE';
ok Uni.new(0xD35C).NFD.list ~~ (0x1111, 0x1163, 0x11BF,), 'D35C -> 1111 1163 11BF';
ok Uni.new(0xD35D).NFD.list ~~ (0x1111, 0x1163, 0x11C0,), 'D35D -> 1111 1163 11C0';
ok Uni.new(0xD35E).NFD.list ~~ (0x1111, 0x1163, 0x11C1,), 'D35E -> 1111 1163 11C1';
ok Uni.new(0xD35F).NFD.list ~~ (0x1111, 0x1163, 0x11C2,), 'D35F -> 1111 1163 11C2';
ok Uni.new(0xD360).NFD.list ~~ (0x1111, 0x1164,), 'D360 -> 1111 1164';
ok Uni.new(0xD361).NFD.list ~~ (0x1111, 0x1164, 0x11A8,), 'D361 -> 1111 1164 11A8';
ok Uni.new(0xD362).NFD.list ~~ (0x1111, 0x1164, 0x11A9,), 'D362 -> 1111 1164 11A9';
ok Uni.new(0xD363).NFD.list ~~ (0x1111, 0x1164, 0x11AA,), 'D363 -> 1111 1164 11AA';
ok Uni.new(0xD364).NFD.list ~~ (0x1111, 0x1164, 0x11AB,), 'D364 -> 1111 1164 11AB';
ok Uni.new(0xD365).NFD.list ~~ (0x1111, 0x1164, 0x11AC,), 'D365 -> 1111 1164 11AC';
ok Uni.new(0xD366).NFD.list ~~ (0x1111, 0x1164, 0x11AD,), 'D366 -> 1111 1164 11AD';
ok Uni.new(0xD367).NFD.list ~~ (0x1111, 0x1164, 0x11AE,), 'D367 -> 1111 1164 11AE';
ok Uni.new(0xD368).NFD.list ~~ (0x1111, 0x1164, 0x11AF,), 'D368 -> 1111 1164 11AF';
ok Uni.new(0xD369).NFD.list ~~ (0x1111, 0x1164, 0x11B0,), 'D369 -> 1111 1164 11B0';
ok Uni.new(0xD36A).NFD.list ~~ (0x1111, 0x1164, 0x11B1,), 'D36A -> 1111 1164 11B1';
ok Uni.new(0xD36B).NFD.list ~~ (0x1111, 0x1164, 0x11B2,), 'D36B -> 1111 1164 11B2';
ok Uni.new(0xD36C).NFD.list ~~ (0x1111, 0x1164, 0x11B3,), 'D36C -> 1111 1164 11B3';
ok Uni.new(0xD36D).NFD.list ~~ (0x1111, 0x1164, 0x11B4,), 'D36D -> 1111 1164 11B4';
ok Uni.new(0xD36E).NFD.list ~~ (0x1111, 0x1164, 0x11B5,), 'D36E -> 1111 1164 11B5';
ok Uni.new(0xD36F).NFD.list ~~ (0x1111, 0x1164, 0x11B6,), 'D36F -> 1111 1164 11B6';
ok Uni.new(0xD370).NFD.list ~~ (0x1111, 0x1164, 0x11B7,), 'D370 -> 1111 1164 11B7';
ok Uni.new(0xD371).NFD.list ~~ (0x1111, 0x1164, 0x11B8,), 'D371 -> 1111 1164 11B8';
ok Uni.new(0xD372).NFD.list ~~ (0x1111, 0x1164, 0x11B9,), 'D372 -> 1111 1164 11B9';
ok Uni.new(0xD373).NFD.list ~~ (0x1111, 0x1164, 0x11BA,), 'D373 -> 1111 1164 11BA';
ok Uni.new(0xD374).NFD.list ~~ (0x1111, 0x1164, 0x11BB,), 'D374 -> 1111 1164 11BB';
ok Uni.new(0xD375).NFD.list ~~ (0x1111, 0x1164, 0x11BC,), 'D375 -> 1111 1164 11BC';
ok Uni.new(0xD376).NFD.list ~~ (0x1111, 0x1164, 0x11BD,), 'D376 -> 1111 1164 11BD';
ok Uni.new(0xD377).NFD.list ~~ (0x1111, 0x1164, 0x11BE,), 'D377 -> 1111 1164 11BE';
ok Uni.new(0xD378).NFD.list ~~ (0x1111, 0x1164, 0x11BF,), 'D378 -> 1111 1164 11BF';
ok Uni.new(0xD379).NFD.list ~~ (0x1111, 0x1164, 0x11C0,), 'D379 -> 1111 1164 11C0';
ok Uni.new(0xD37A).NFD.list ~~ (0x1111, 0x1164, 0x11C1,), 'D37A -> 1111 1164 11C1';
ok Uni.new(0xD37B).NFD.list ~~ (0x1111, 0x1164, 0x11C2,), 'D37B -> 1111 1164 11C2';
ok Uni.new(0xD37C).NFD.list ~~ (0x1111, 0x1165,), 'D37C -> 1111 1165';
ok Uni.new(0xD37D).NFD.list ~~ (0x1111, 0x1165, 0x11A8,), 'D37D -> 1111 1165 11A8';
ok Uni.new(0xD37E).NFD.list ~~ (0x1111, 0x1165, 0x11A9,), 'D37E -> 1111 1165 11A9';
ok Uni.new(0xD37F).NFD.list ~~ (0x1111, 0x1165, 0x11AA,), 'D37F -> 1111 1165 11AA';
ok Uni.new(0xD380).NFD.list ~~ (0x1111, 0x1165, 0x11AB,), 'D380 -> 1111 1165 11AB';
ok Uni.new(0xD381).NFD.list ~~ (0x1111, 0x1165, 0x11AC,), 'D381 -> 1111 1165 11AC';
ok Uni.new(0xD382).NFD.list ~~ (0x1111, 0x1165, 0x11AD,), 'D382 -> 1111 1165 11AD';
ok Uni.new(0xD383).NFD.list ~~ (0x1111, 0x1165, 0x11AE,), 'D383 -> 1111 1165 11AE';
ok Uni.new(0xD384).NFD.list ~~ (0x1111, 0x1165, 0x11AF,), 'D384 -> 1111 1165 11AF';
ok Uni.new(0xD385).NFD.list ~~ (0x1111, 0x1165, 0x11B0,), 'D385 -> 1111 1165 11B0';
ok Uni.new(0xD386).NFD.list ~~ (0x1111, 0x1165, 0x11B1,), 'D386 -> 1111 1165 11B1';
ok Uni.new(0xD387).NFD.list ~~ (0x1111, 0x1165, 0x11B2,), 'D387 -> 1111 1165 11B2';
ok Uni.new(0xD388).NFD.list ~~ (0x1111, 0x1165, 0x11B3,), 'D388 -> 1111 1165 11B3';
ok Uni.new(0xD389).NFD.list ~~ (0x1111, 0x1165, 0x11B4,), 'D389 -> 1111 1165 11B4';
ok Uni.new(0xD38A).NFD.list ~~ (0x1111, 0x1165, 0x11B5,), 'D38A -> 1111 1165 11B5';
ok Uni.new(0xD38B).NFD.list ~~ (0x1111, 0x1165, 0x11B6,), 'D38B -> 1111 1165 11B6';
ok Uni.new(0xD38C).NFD.list ~~ (0x1111, 0x1165, 0x11B7,), 'D38C -> 1111 1165 11B7';
ok Uni.new(0xD38D).NFD.list ~~ (0x1111, 0x1165, 0x11B8,), 'D38D -> 1111 1165 11B8';
ok Uni.new(0xD38E).NFD.list ~~ (0x1111, 0x1165, 0x11B9,), 'D38E -> 1111 1165 11B9';
ok Uni.new(0xD38F).NFD.list ~~ (0x1111, 0x1165, 0x11BA,), 'D38F -> 1111 1165 11BA';
ok Uni.new(0xD390).NFD.list ~~ (0x1111, 0x1165, 0x11BB,), 'D390 -> 1111 1165 11BB';
ok Uni.new(0xD391).NFD.list ~~ (0x1111, 0x1165, 0x11BC,), 'D391 -> 1111 1165 11BC';
ok Uni.new(0xD392).NFD.list ~~ (0x1111, 0x1165, 0x11BD,), 'D392 -> 1111 1165 11BD';
ok Uni.new(0xD393).NFD.list ~~ (0x1111, 0x1165, 0x11BE,), 'D393 -> 1111 1165 11BE';
ok Uni.new(0xD394).NFD.list ~~ (0x1111, 0x1165, 0x11BF,), 'D394 -> 1111 1165 11BF';
ok Uni.new(0xD395).NFD.list ~~ (0x1111, 0x1165, 0x11C0,), 'D395 -> 1111 1165 11C0';
ok Uni.new(0xD396).NFD.list ~~ (0x1111, 0x1165, 0x11C1,), 'D396 -> 1111 1165 11C1';
ok Uni.new(0xD397).NFD.list ~~ (0x1111, 0x1165, 0x11C2,), 'D397 -> 1111 1165 11C2';
ok Uni.new(0xD398).NFD.list ~~ (0x1111, 0x1166,), 'D398 -> 1111 1166';
ok Uni.new(0xD399).NFD.list ~~ (0x1111, 0x1166, 0x11A8,), 'D399 -> 1111 1166 11A8';
ok Uni.new(0xD39A).NFD.list ~~ (0x1111, 0x1166, 0x11A9,), 'D39A -> 1111 1166 11A9';
ok Uni.new(0xD39B).NFD.list ~~ (0x1111, 0x1166, 0x11AA,), 'D39B -> 1111 1166 11AA';
ok Uni.new(0xD39C).NFD.list ~~ (0x1111, 0x1166, 0x11AB,), 'D39C -> 1111 1166 11AB';
ok Uni.new(0xD39D).NFD.list ~~ (0x1111, 0x1166, 0x11AC,), 'D39D -> 1111 1166 11AC';
ok Uni.new(0xD39E).NFD.list ~~ (0x1111, 0x1166, 0x11AD,), 'D39E -> 1111 1166 11AD';
ok Uni.new(0xD39F).NFD.list ~~ (0x1111, 0x1166, 0x11AE,), 'D39F -> 1111 1166 11AE';
ok Uni.new(0xD3A0).NFD.list ~~ (0x1111, 0x1166, 0x11AF,), 'D3A0 -> 1111 1166 11AF';
ok Uni.new(0xD3A1).NFD.list ~~ (0x1111, 0x1166, 0x11B0,), 'D3A1 -> 1111 1166 11B0';
ok Uni.new(0xD3A2).NFD.list ~~ (0x1111, 0x1166, 0x11B1,), 'D3A2 -> 1111 1166 11B1';
ok Uni.new(0xD3A3).NFD.list ~~ (0x1111, 0x1166, 0x11B2,), 'D3A3 -> 1111 1166 11B2';
ok Uni.new(0xD3A4).NFD.list ~~ (0x1111, 0x1166, 0x11B3,), 'D3A4 -> 1111 1166 11B3';
ok Uni.new(0xD3A5).NFD.list ~~ (0x1111, 0x1166, 0x11B4,), 'D3A5 -> 1111 1166 11B4';
ok Uni.new(0xD3A6).NFD.list ~~ (0x1111, 0x1166, 0x11B5,), 'D3A6 -> 1111 1166 11B5';
ok Uni.new(0xD3A7).NFD.list ~~ (0x1111, 0x1166, 0x11B6,), 'D3A7 -> 1111 1166 11B6';
ok Uni.new(0xD3A8).NFD.list ~~ (0x1111, 0x1166, 0x11B7,), 'D3A8 -> 1111 1166 11B7';
ok Uni.new(0xD3A9).NFD.list ~~ (0x1111, 0x1166, 0x11B8,), 'D3A9 -> 1111 1166 11B8';
ok Uni.new(0xD3AA).NFD.list ~~ (0x1111, 0x1166, 0x11B9,), 'D3AA -> 1111 1166 11B9';
ok Uni.new(0xD3AB).NFD.list ~~ (0x1111, 0x1166, 0x11BA,), 'D3AB -> 1111 1166 11BA';
ok Uni.new(0xD3AC).NFD.list ~~ (0x1111, 0x1166, 0x11BB,), 'D3AC -> 1111 1166 11BB';
ok Uni.new(0xD3AD).NFD.list ~~ (0x1111, 0x1166, 0x11BC,), 'D3AD -> 1111 1166 11BC';
ok Uni.new(0xD3AE).NFD.list ~~ (0x1111, 0x1166, 0x11BD,), 'D3AE -> 1111 1166 11BD';
ok Uni.new(0xD3AF).NFD.list ~~ (0x1111, 0x1166, 0x11BE,), 'D3AF -> 1111 1166 11BE';
ok Uni.new(0xD3B0).NFD.list ~~ (0x1111, 0x1166, 0x11BF,), 'D3B0 -> 1111 1166 11BF';
ok Uni.new(0xD3B1).NFD.list ~~ (0x1111, 0x1166, 0x11C0,), 'D3B1 -> 1111 1166 11C0';
ok Uni.new(0xD3B2).NFD.list ~~ (0x1111, 0x1166, 0x11C1,), 'D3B2 -> 1111 1166 11C1';
ok Uni.new(0xD3B3).NFD.list ~~ (0x1111, 0x1166, 0x11C2,), 'D3B3 -> 1111 1166 11C2';
ok Uni.new(0xD3B4).NFD.list ~~ (0x1111, 0x1167,), 'D3B4 -> 1111 1167';
ok Uni.new(0xD3B5).NFD.list ~~ (0x1111, 0x1167, 0x11A8,), 'D3B5 -> 1111 1167 11A8';
ok Uni.new(0xD3B6).NFD.list ~~ (0x1111, 0x1167, 0x11A9,), 'D3B6 -> 1111 1167 11A9';
ok Uni.new(0xD3B7).NFD.list ~~ (0x1111, 0x1167, 0x11AA,), 'D3B7 -> 1111 1167 11AA';
ok Uni.new(0xD3B8).NFD.list ~~ (0x1111, 0x1167, 0x11AB,), 'D3B8 -> 1111 1167 11AB';
ok Uni.new(0xD3B9).NFD.list ~~ (0x1111, 0x1167, 0x11AC,), 'D3B9 -> 1111 1167 11AC';
ok Uni.new(0xD3BA).NFD.list ~~ (0x1111, 0x1167, 0x11AD,), 'D3BA -> 1111 1167 11AD';
ok Uni.new(0xD3BB).NFD.list ~~ (0x1111, 0x1167, 0x11AE,), 'D3BB -> 1111 1167 11AE';
ok Uni.new(0xD3BC).NFD.list ~~ (0x1111, 0x1167, 0x11AF,), 'D3BC -> 1111 1167 11AF';
ok Uni.new(0xD3BD).NFD.list ~~ (0x1111, 0x1167, 0x11B0,), 'D3BD -> 1111 1167 11B0';
ok Uni.new(0xD3BE).NFD.list ~~ (0x1111, 0x1167, 0x11B1,), 'D3BE -> 1111 1167 11B1';
ok Uni.new(0xD3BF).NFD.list ~~ (0x1111, 0x1167, 0x11B2,), 'D3BF -> 1111 1167 11B2';
ok Uni.new(0xD3C0).NFD.list ~~ (0x1111, 0x1167, 0x11B3,), 'D3C0 -> 1111 1167 11B3';
ok Uni.new(0xD3C1).NFD.list ~~ (0x1111, 0x1167, 0x11B4,), 'D3C1 -> 1111 1167 11B4';
ok Uni.new(0xD3C2).NFD.list ~~ (0x1111, 0x1167, 0x11B5,), 'D3C2 -> 1111 1167 11B5';
ok Uni.new(0xD3C3).NFD.list ~~ (0x1111, 0x1167, 0x11B6,), 'D3C3 -> 1111 1167 11B6';
ok Uni.new(0xD3C4).NFD.list ~~ (0x1111, 0x1167, 0x11B7,), 'D3C4 -> 1111 1167 11B7';
ok Uni.new(0xD3C5).NFD.list ~~ (0x1111, 0x1167, 0x11B8,), 'D3C5 -> 1111 1167 11B8';
ok Uni.new(0xD3C6).NFD.list ~~ (0x1111, 0x1167, 0x11B9,), 'D3C6 -> 1111 1167 11B9';
ok Uni.new(0xD3C7).NFD.list ~~ (0x1111, 0x1167, 0x11BA,), 'D3C7 -> 1111 1167 11BA';
ok Uni.new(0xD3C8).NFD.list ~~ (0x1111, 0x1167, 0x11BB,), 'D3C8 -> 1111 1167 11BB';
ok Uni.new(0xD3C9).NFD.list ~~ (0x1111, 0x1167, 0x11BC,), 'D3C9 -> 1111 1167 11BC';
ok Uni.new(0xD3CA).NFD.list ~~ (0x1111, 0x1167, 0x11BD,), 'D3CA -> 1111 1167 11BD';
ok Uni.new(0xD3CB).NFD.list ~~ (0x1111, 0x1167, 0x11BE,), 'D3CB -> 1111 1167 11BE';
ok Uni.new(0xD3CC).NFD.list ~~ (0x1111, 0x1167, 0x11BF,), 'D3CC -> 1111 1167 11BF';
ok Uni.new(0xD3CD).NFD.list ~~ (0x1111, 0x1167, 0x11C0,), 'D3CD -> 1111 1167 11C0';
ok Uni.new(0xD3CE).NFD.list ~~ (0x1111, 0x1167, 0x11C1,), 'D3CE -> 1111 1167 11C1';
ok Uni.new(0xD3CF).NFD.list ~~ (0x1111, 0x1167, 0x11C2,), 'D3CF -> 1111 1167 11C2';
ok Uni.new(0xD3D0).NFD.list ~~ (0x1111, 0x1168,), 'D3D0 -> 1111 1168';
ok Uni.new(0xD3D1).NFD.list ~~ (0x1111, 0x1168, 0x11A8,), 'D3D1 -> 1111 1168 11A8';
ok Uni.new(0xD3D2).NFD.list ~~ (0x1111, 0x1168, 0x11A9,), 'D3D2 -> 1111 1168 11A9';
ok Uni.new(0xD3D3).NFD.list ~~ (0x1111, 0x1168, 0x11AA,), 'D3D3 -> 1111 1168 11AA';
ok Uni.new(0xD3D4).NFD.list ~~ (0x1111, 0x1168, 0x11AB,), 'D3D4 -> 1111 1168 11AB';
ok Uni.new(0xD3D5).NFD.list ~~ (0x1111, 0x1168, 0x11AC,), 'D3D5 -> 1111 1168 11AC';
ok Uni.new(0xD3D6).NFD.list ~~ (0x1111, 0x1168, 0x11AD,), 'D3D6 -> 1111 1168 11AD';
ok Uni.new(0xD3D7).NFD.list ~~ (0x1111, 0x1168, 0x11AE,), 'D3D7 -> 1111 1168 11AE';
ok Uni.new(0xD3D8).NFD.list ~~ (0x1111, 0x1168, 0x11AF,), 'D3D8 -> 1111 1168 11AF';
ok Uni.new(0xD3D9).NFD.list ~~ (0x1111, 0x1168, 0x11B0,), 'D3D9 -> 1111 1168 11B0';
ok Uni.new(0xD3DA).NFD.list ~~ (0x1111, 0x1168, 0x11B1,), 'D3DA -> 1111 1168 11B1';
ok Uni.new(0xD3DB).NFD.list ~~ (0x1111, 0x1168, 0x11B2,), 'D3DB -> 1111 1168 11B2';
ok Uni.new(0xD3DC).NFD.list ~~ (0x1111, 0x1168, 0x11B3,), 'D3DC -> 1111 1168 11B3';
ok Uni.new(0xD3DD).NFD.list ~~ (0x1111, 0x1168, 0x11B4,), 'D3DD -> 1111 1168 11B4';
ok Uni.new(0xD3DE).NFD.list ~~ (0x1111, 0x1168, 0x11B5,), 'D3DE -> 1111 1168 11B5';
ok Uni.new(0xD3DF).NFD.list ~~ (0x1111, 0x1168, 0x11B6,), 'D3DF -> 1111 1168 11B6';
ok Uni.new(0xD3E0).NFD.list ~~ (0x1111, 0x1168, 0x11B7,), 'D3E0 -> 1111 1168 11B7';
ok Uni.new(0xD3E1).NFD.list ~~ (0x1111, 0x1168, 0x11B8,), 'D3E1 -> 1111 1168 11B8';
ok Uni.new(0xD3E2).NFD.list ~~ (0x1111, 0x1168, 0x11B9,), 'D3E2 -> 1111 1168 11B9';
ok Uni.new(0xD3E3).NFD.list ~~ (0x1111, 0x1168, 0x11BA,), 'D3E3 -> 1111 1168 11BA';
ok Uni.new(0xD3E4).NFD.list ~~ (0x1111, 0x1168, 0x11BB,), 'D3E4 -> 1111 1168 11BB';
ok Uni.new(0xD3E5).NFD.list ~~ (0x1111, 0x1168, 0x11BC,), 'D3E5 -> 1111 1168 11BC';
ok Uni.new(0xD3E6).NFD.list ~~ (0x1111, 0x1168, 0x11BD,), 'D3E6 -> 1111 1168 11BD';
ok Uni.new(0xD3E7).NFD.list ~~ (0x1111, 0x1168, 0x11BE,), 'D3E7 -> 1111 1168 11BE';
ok Uni.new(0xD3E8).NFD.list ~~ (0x1111, 0x1168, 0x11BF,), 'D3E8 -> 1111 1168 11BF';
ok Uni.new(0xD3E9).NFD.list ~~ (0x1111, 0x1168, 0x11C0,), 'D3E9 -> 1111 1168 11C0';
ok Uni.new(0xD3EA).NFD.list ~~ (0x1111, 0x1168, 0x11C1,), 'D3EA -> 1111 1168 11C1';
ok Uni.new(0xD3EB).NFD.list ~~ (0x1111, 0x1168, 0x11C2,), 'D3EB -> 1111 1168 11C2';
ok Uni.new(0xD3EC).NFD.list ~~ (0x1111, 0x1169,), 'D3EC -> 1111 1169';
ok Uni.new(0xD3ED).NFD.list ~~ (0x1111, 0x1169, 0x11A8,), 'D3ED -> 1111 1169 11A8';
ok Uni.new(0xD3EE).NFD.list ~~ (0x1111, 0x1169, 0x11A9,), 'D3EE -> 1111 1169 11A9';
ok Uni.new(0xD3EF).NFD.list ~~ (0x1111, 0x1169, 0x11AA,), 'D3EF -> 1111 1169 11AA';
ok Uni.new(0xD3F0).NFD.list ~~ (0x1111, 0x1169, 0x11AB,), 'D3F0 -> 1111 1169 11AB';
ok Uni.new(0xD3F1).NFD.list ~~ (0x1111, 0x1169, 0x11AC,), 'D3F1 -> 1111 1169 11AC';
ok Uni.new(0xD3F2).NFD.list ~~ (0x1111, 0x1169, 0x11AD,), 'D3F2 -> 1111 1169 11AD';
ok Uni.new(0xD3F3).NFD.list ~~ (0x1111, 0x1169, 0x11AE,), 'D3F3 -> 1111 1169 11AE';
ok Uni.new(0xD3F4).NFD.list ~~ (0x1111, 0x1169, 0x11AF,), 'D3F4 -> 1111 1169 11AF';
ok Uni.new(0xD3F5).NFD.list ~~ (0x1111, 0x1169, 0x11B0,), 'D3F5 -> 1111 1169 11B0';
ok Uni.new(0xD3F6).NFD.list ~~ (0x1111, 0x1169, 0x11B1,), 'D3F6 -> 1111 1169 11B1';
ok Uni.new(0xD3F7).NFD.list ~~ (0x1111, 0x1169, 0x11B2,), 'D3F7 -> 1111 1169 11B2';
ok Uni.new(0xD3F8).NFD.list ~~ (0x1111, 0x1169, 0x11B3,), 'D3F8 -> 1111 1169 11B3';
ok Uni.new(0xD3F9).NFD.list ~~ (0x1111, 0x1169, 0x11B4,), 'D3F9 -> 1111 1169 11B4';
ok Uni.new(0xD3FA).NFD.list ~~ (0x1111, 0x1169, 0x11B5,), 'D3FA -> 1111 1169 11B5';
ok Uni.new(0xD3FB).NFD.list ~~ (0x1111, 0x1169, 0x11B6,), 'D3FB -> 1111 1169 11B6';
ok Uni.new(0xD3FC).NFD.list ~~ (0x1111, 0x1169, 0x11B7,), 'D3FC -> 1111 1169 11B7';
ok Uni.new(0xD3FD).NFD.list ~~ (0x1111, 0x1169, 0x11B8,), 'D3FD -> 1111 1169 11B8';
ok Uni.new(0xD3FE).NFD.list ~~ (0x1111, 0x1169, 0x11B9,), 'D3FE -> 1111 1169 11B9';
ok Uni.new(0xD3FF).NFD.list ~~ (0x1111, 0x1169, 0x11BA,), 'D3FF -> 1111 1169 11BA';
ok Uni.new(0xD400).NFD.list ~~ (0x1111, 0x1169, 0x11BB,), 'D400 -> 1111 1169 11BB';
ok Uni.new(0xD401).NFD.list ~~ (0x1111, 0x1169, 0x11BC,), 'D401 -> 1111 1169 11BC';
ok Uni.new(0xD402).NFD.list ~~ (0x1111, 0x1169, 0x11BD,), 'D402 -> 1111 1169 11BD';
ok Uni.new(0xD403).NFD.list ~~ (0x1111, 0x1169, 0x11BE,), 'D403 -> 1111 1169 11BE';
ok Uni.new(0xD404).NFD.list ~~ (0x1111, 0x1169, 0x11BF,), 'D404 -> 1111 1169 11BF';
ok Uni.new(0xD405).NFD.list ~~ (0x1111, 0x1169, 0x11C0,), 'D405 -> 1111 1169 11C0';
ok Uni.new(0xD406).NFD.list ~~ (0x1111, 0x1169, 0x11C1,), 'D406 -> 1111 1169 11C1';
ok Uni.new(0xD407).NFD.list ~~ (0x1111, 0x1169, 0x11C2,), 'D407 -> 1111 1169 11C2';
ok Uni.new(0xD408).NFD.list ~~ (0x1111, 0x116A,), 'D408 -> 1111 116A';
ok Uni.new(0xD409).NFD.list ~~ (0x1111, 0x116A, 0x11A8,), 'D409 -> 1111 116A 11A8';
ok Uni.new(0xD40A).NFD.list ~~ (0x1111, 0x116A, 0x11A9,), 'D40A -> 1111 116A 11A9';
ok Uni.new(0xD40B).NFD.list ~~ (0x1111, 0x116A, 0x11AA,), 'D40B -> 1111 116A 11AA';
ok Uni.new(0xD40C).NFD.list ~~ (0x1111, 0x116A, 0x11AB,), 'D40C -> 1111 116A 11AB';
ok Uni.new(0xD40D).NFD.list ~~ (0x1111, 0x116A, 0x11AC,), 'D40D -> 1111 116A 11AC';
ok Uni.new(0xD40E).NFD.list ~~ (0x1111, 0x116A, 0x11AD,), 'D40E -> 1111 116A 11AD';
ok Uni.new(0xD40F).NFD.list ~~ (0x1111, 0x116A, 0x11AE,), 'D40F -> 1111 116A 11AE';
ok Uni.new(0xD410).NFD.list ~~ (0x1111, 0x116A, 0x11AF,), 'D410 -> 1111 116A 11AF';
ok Uni.new(0xD411).NFD.list ~~ (0x1111, 0x116A, 0x11B0,), 'D411 -> 1111 116A 11B0';
ok Uni.new(0xD412).NFD.list ~~ (0x1111, 0x116A, 0x11B1,), 'D412 -> 1111 116A 11B1';
ok Uni.new(0xD413).NFD.list ~~ (0x1111, 0x116A, 0x11B2,), 'D413 -> 1111 116A 11B2';
ok Uni.new(0xD414).NFD.list ~~ (0x1111, 0x116A, 0x11B3,), 'D414 -> 1111 116A 11B3';
ok Uni.new(0xD415).NFD.list ~~ (0x1111, 0x116A, 0x11B4,), 'D415 -> 1111 116A 11B4';
ok Uni.new(0xD416).NFD.list ~~ (0x1111, 0x116A, 0x11B5,), 'D416 -> 1111 116A 11B5';
ok Uni.new(0xD417).NFD.list ~~ (0x1111, 0x116A, 0x11B6,), 'D417 -> 1111 116A 11B6';
ok Uni.new(0xD418).NFD.list ~~ (0x1111, 0x116A, 0x11B7,), 'D418 -> 1111 116A 11B7';
ok Uni.new(0xD419).NFD.list ~~ (0x1111, 0x116A, 0x11B8,), 'D419 -> 1111 116A 11B8';
ok Uni.new(0xD41A).NFD.list ~~ (0x1111, 0x116A, 0x11B9,), 'D41A -> 1111 116A 11B9';
ok Uni.new(0xD41B).NFD.list ~~ (0x1111, 0x116A, 0x11BA,), 'D41B -> 1111 116A 11BA';
ok Uni.new(0xD41C).NFD.list ~~ (0x1111, 0x116A, 0x11BB,), 'D41C -> 1111 116A 11BB';
ok Uni.new(0xD41D).NFD.list ~~ (0x1111, 0x116A, 0x11BC,), 'D41D -> 1111 116A 11BC';
ok Uni.new(0xD41E).NFD.list ~~ (0x1111, 0x116A, 0x11BD,), 'D41E -> 1111 116A 11BD';
ok Uni.new(0xD41F).NFD.list ~~ (0x1111, 0x116A, 0x11BE,), 'D41F -> 1111 116A 11BE';
ok Uni.new(0xD420).NFD.list ~~ (0x1111, 0x116A, 0x11BF,), 'D420 -> 1111 116A 11BF';
ok Uni.new(0xD421).NFD.list ~~ (0x1111, 0x116A, 0x11C0,), 'D421 -> 1111 116A 11C0';
ok Uni.new(0xD422).NFD.list ~~ (0x1111, 0x116A, 0x11C1,), 'D422 -> 1111 116A 11C1';
ok Uni.new(0xD423).NFD.list ~~ (0x1111, 0x116A, 0x11C2,), 'D423 -> 1111 116A 11C2';
ok Uni.new(0xD424).NFD.list ~~ (0x1111, 0x116B,), 'D424 -> 1111 116B';
ok Uni.new(0xD425).NFD.list ~~ (0x1111, 0x116B, 0x11A8,), 'D425 -> 1111 116B 11A8';
ok Uni.new(0xD426).NFD.list ~~ (0x1111, 0x116B, 0x11A9,), 'D426 -> 1111 116B 11A9';
ok Uni.new(0xD427).NFD.list ~~ (0x1111, 0x116B, 0x11AA,), 'D427 -> 1111 116B 11AA';
ok Uni.new(0xD428).NFD.list ~~ (0x1111, 0x116B, 0x11AB,), 'D428 -> 1111 116B 11AB';
ok Uni.new(0xD429).NFD.list ~~ (0x1111, 0x116B, 0x11AC,), 'D429 -> 1111 116B 11AC';
ok Uni.new(0xD42A).NFD.list ~~ (0x1111, 0x116B, 0x11AD,), 'D42A -> 1111 116B 11AD';
ok Uni.new(0xD42B).NFD.list ~~ (0x1111, 0x116B, 0x11AE,), 'D42B -> 1111 116B 11AE';
ok Uni.new(0xD42C).NFD.list ~~ (0x1111, 0x116B, 0x11AF,), 'D42C -> 1111 116B 11AF';
ok Uni.new(0xD42D).NFD.list ~~ (0x1111, 0x116B, 0x11B0,), 'D42D -> 1111 116B 11B0';
ok Uni.new(0xD42E).NFD.list ~~ (0x1111, 0x116B, 0x11B1,), 'D42E -> 1111 116B 11B1';
ok Uni.new(0xD42F).NFD.list ~~ (0x1111, 0x116B, 0x11B2,), 'D42F -> 1111 116B 11B2';
ok Uni.new(0xD430).NFD.list ~~ (0x1111, 0x116B, 0x11B3,), 'D430 -> 1111 116B 11B3';
ok Uni.new(0xD431).NFD.list ~~ (0x1111, 0x116B, 0x11B4,), 'D431 -> 1111 116B 11B4';
ok Uni.new(0xD432).NFD.list ~~ (0x1111, 0x116B, 0x11B5,), 'D432 -> 1111 116B 11B5';
ok Uni.new(0xD433).NFD.list ~~ (0x1111, 0x116B, 0x11B6,), 'D433 -> 1111 116B 11B6';
ok Uni.new(0xD434).NFD.list ~~ (0x1111, 0x116B, 0x11B7,), 'D434 -> 1111 116B 11B7';
ok Uni.new(0xD435).NFD.list ~~ (0x1111, 0x116B, 0x11B8,), 'D435 -> 1111 116B 11B8';
ok Uni.new(0xD436).NFD.list ~~ (0x1111, 0x116B, 0x11B9,), 'D436 -> 1111 116B 11B9';
ok Uni.new(0xD437).NFD.list ~~ (0x1111, 0x116B, 0x11BA,), 'D437 -> 1111 116B 11BA';
ok Uni.new(0xD438).NFD.list ~~ (0x1111, 0x116B, 0x11BB,), 'D438 -> 1111 116B 11BB';
ok Uni.new(0xD439).NFD.list ~~ (0x1111, 0x116B, 0x11BC,), 'D439 -> 1111 116B 11BC';
ok Uni.new(0xD43A).NFD.list ~~ (0x1111, 0x116B, 0x11BD,), 'D43A -> 1111 116B 11BD';
ok Uni.new(0xD43B).NFD.list ~~ (0x1111, 0x116B, 0x11BE,), 'D43B -> 1111 116B 11BE';
ok Uni.new(0xD43C).NFD.list ~~ (0x1111, 0x116B, 0x11BF,), 'D43C -> 1111 116B 11BF';
ok Uni.new(0xD43D).NFD.list ~~ (0x1111, 0x116B, 0x11C0,), 'D43D -> 1111 116B 11C0';
ok Uni.new(0xD43E).NFD.list ~~ (0x1111, 0x116B, 0x11C1,), 'D43E -> 1111 116B 11C1';
ok Uni.new(0xD43F).NFD.list ~~ (0x1111, 0x116B, 0x11C2,), 'D43F -> 1111 116B 11C2';
ok Uni.new(0xD440).NFD.list ~~ (0x1111, 0x116C,), 'D440 -> 1111 116C';
ok Uni.new(0xD441).NFD.list ~~ (0x1111, 0x116C, 0x11A8,), 'D441 -> 1111 116C 11A8';
ok Uni.new(0xD442).NFD.list ~~ (0x1111, 0x116C, 0x11A9,), 'D442 -> 1111 116C 11A9';
ok Uni.new(0xD443).NFD.list ~~ (0x1111, 0x116C, 0x11AA,), 'D443 -> 1111 116C 11AA';
ok Uni.new(0xD444).NFD.list ~~ (0x1111, 0x116C, 0x11AB,), 'D444 -> 1111 116C 11AB';
ok Uni.new(0xD445).NFD.list ~~ (0x1111, 0x116C, 0x11AC,), 'D445 -> 1111 116C 11AC';
ok Uni.new(0xD446).NFD.list ~~ (0x1111, 0x116C, 0x11AD,), 'D446 -> 1111 116C 11AD';
ok Uni.new(0xD447).NFD.list ~~ (0x1111, 0x116C, 0x11AE,), 'D447 -> 1111 116C 11AE';
ok Uni.new(0xD448).NFD.list ~~ (0x1111, 0x116C, 0x11AF,), 'D448 -> 1111 116C 11AF';
ok Uni.new(0xD449).NFD.list ~~ (0x1111, 0x116C, 0x11B0,), 'D449 -> 1111 116C 11B0';
ok Uni.new(0xD44A).NFD.list ~~ (0x1111, 0x116C, 0x11B1,), 'D44A -> 1111 116C 11B1';
ok Uni.new(0xD44B).NFD.list ~~ (0x1111, 0x116C, 0x11B2,), 'D44B -> 1111 116C 11B2';
ok Uni.new(0xD44C).NFD.list ~~ (0x1111, 0x116C, 0x11B3,), 'D44C -> 1111 116C 11B3';
ok Uni.new(0xD44D).NFD.list ~~ (0x1111, 0x116C, 0x11B4,), 'D44D -> 1111 116C 11B4';
ok Uni.new(0xD44E).NFD.list ~~ (0x1111, 0x116C, 0x11B5,), 'D44E -> 1111 116C 11B5';
ok Uni.new(0xD44F).NFD.list ~~ (0x1111, 0x116C, 0x11B6,), 'D44F -> 1111 116C 11B6';
ok Uni.new(0xD450).NFD.list ~~ (0x1111, 0x116C, 0x11B7,), 'D450 -> 1111 116C 11B7';
ok Uni.new(0xD451).NFD.list ~~ (0x1111, 0x116C, 0x11B8,), 'D451 -> 1111 116C 11B8';
ok Uni.new(0xD452).NFD.list ~~ (0x1111, 0x116C, 0x11B9,), 'D452 -> 1111 116C 11B9';
ok Uni.new(0xD453).NFD.list ~~ (0x1111, 0x116C, 0x11BA,), 'D453 -> 1111 116C 11BA';
ok Uni.new(0xD454).NFD.list ~~ (0x1111, 0x116C, 0x11BB,), 'D454 -> 1111 116C 11BB';
ok Uni.new(0xD455).NFD.list ~~ (0x1111, 0x116C, 0x11BC,), 'D455 -> 1111 116C 11BC';
ok Uni.new(0xD456).NFD.list ~~ (0x1111, 0x116C, 0x11BD,), 'D456 -> 1111 116C 11BD';
ok Uni.new(0xD457).NFD.list ~~ (0x1111, 0x116C, 0x11BE,), 'D457 -> 1111 116C 11BE';
ok Uni.new(0xD458).NFD.list ~~ (0x1111, 0x116C, 0x11BF,), 'D458 -> 1111 116C 11BF';
ok Uni.new(0xD459).NFD.list ~~ (0x1111, 0x116C, 0x11C0,), 'D459 -> 1111 116C 11C0';
ok Uni.new(0xD45A).NFD.list ~~ (0x1111, 0x116C, 0x11C1,), 'D45A -> 1111 116C 11C1';
ok Uni.new(0xD45B).NFD.list ~~ (0x1111, 0x116C, 0x11C2,), 'D45B -> 1111 116C 11C2';
ok Uni.new(0xD45C).NFD.list ~~ (0x1111, 0x116D,), 'D45C -> 1111 116D';
ok Uni.new(0xD45D).NFD.list ~~ (0x1111, 0x116D, 0x11A8,), 'D45D -> 1111 116D 11A8';
ok Uni.new(0xD45E).NFD.list ~~ (0x1111, 0x116D, 0x11A9,), 'D45E -> 1111 116D 11A9';
ok Uni.new(0xD45F).NFD.list ~~ (0x1111, 0x116D, 0x11AA,), 'D45F -> 1111 116D 11AA';
ok Uni.new(0xD460).NFD.list ~~ (0x1111, 0x116D, 0x11AB,), 'D460 -> 1111 116D 11AB';
ok Uni.new(0xD461).NFD.list ~~ (0x1111, 0x116D, 0x11AC,), 'D461 -> 1111 116D 11AC';
ok Uni.new(0xD462).NFD.list ~~ (0x1111, 0x116D, 0x11AD,), 'D462 -> 1111 116D 11AD';
ok Uni.new(0xD463).NFD.list ~~ (0x1111, 0x116D, 0x11AE,), 'D463 -> 1111 116D 11AE';
ok Uni.new(0xD464).NFD.list ~~ (0x1111, 0x116D, 0x11AF,), 'D464 -> 1111 116D 11AF';
ok Uni.new(0xD465).NFD.list ~~ (0x1111, 0x116D, 0x11B0,), 'D465 -> 1111 116D 11B0';
ok Uni.new(0xD466).NFD.list ~~ (0x1111, 0x116D, 0x11B1,), 'D466 -> 1111 116D 11B1';
ok Uni.new(0xD467).NFD.list ~~ (0x1111, 0x116D, 0x11B2,), 'D467 -> 1111 116D 11B2';
ok Uni.new(0xD468).NFD.list ~~ (0x1111, 0x116D, 0x11B3,), 'D468 -> 1111 116D 11B3';
ok Uni.new(0xD469).NFD.list ~~ (0x1111, 0x116D, 0x11B4,), 'D469 -> 1111 116D 11B4';
ok Uni.new(0xD46A).NFD.list ~~ (0x1111, 0x116D, 0x11B5,), 'D46A -> 1111 116D 11B5';
ok Uni.new(0xD46B).NFD.list ~~ (0x1111, 0x116D, 0x11B6,), 'D46B -> 1111 116D 11B6';
ok Uni.new(0xD46C).NFD.list ~~ (0x1111, 0x116D, 0x11B7,), 'D46C -> 1111 116D 11B7';
ok Uni.new(0xD46D).NFD.list ~~ (0x1111, 0x116D, 0x11B8,), 'D46D -> 1111 116D 11B8';
ok Uni.new(0xD46E).NFD.list ~~ (0x1111, 0x116D, 0x11B9,), 'D46E -> 1111 116D 11B9';
ok Uni.new(0xD46F).NFD.list ~~ (0x1111, 0x116D, 0x11BA,), 'D46F -> 1111 116D 11BA';
ok Uni.new(0xD470).NFD.list ~~ (0x1111, 0x116D, 0x11BB,), 'D470 -> 1111 116D 11BB';
ok Uni.new(0xD471).NFD.list ~~ (0x1111, 0x116D, 0x11BC,), 'D471 -> 1111 116D 11BC';
ok Uni.new(0xD472).NFD.list ~~ (0x1111, 0x116D, 0x11BD,), 'D472 -> 1111 116D 11BD';
ok Uni.new(0xD473).NFD.list ~~ (0x1111, 0x116D, 0x11BE,), 'D473 -> 1111 116D 11BE';
ok Uni.new(0xD474).NFD.list ~~ (0x1111, 0x116D, 0x11BF,), 'D474 -> 1111 116D 11BF';
ok Uni.new(0xD475).NFD.list ~~ (0x1111, 0x116D, 0x11C0,), 'D475 -> 1111 116D 11C0';
ok Uni.new(0xD476).NFD.list ~~ (0x1111, 0x116D, 0x11C1,), 'D476 -> 1111 116D 11C1';
ok Uni.new(0xD477).NFD.list ~~ (0x1111, 0x116D, 0x11C2,), 'D477 -> 1111 116D 11C2';
ok Uni.new(0xD478).NFD.list ~~ (0x1111, 0x116E,), 'D478 -> 1111 116E';
ok Uni.new(0xD479).NFD.list ~~ (0x1111, 0x116E, 0x11A8,), 'D479 -> 1111 116E 11A8';
ok Uni.new(0xD47A).NFD.list ~~ (0x1111, 0x116E, 0x11A9,), 'D47A -> 1111 116E 11A9';
ok Uni.new(0xD47B).NFD.list ~~ (0x1111, 0x116E, 0x11AA,), 'D47B -> 1111 116E 11AA';
ok Uni.new(0xD47C).NFD.list ~~ (0x1111, 0x116E, 0x11AB,), 'D47C -> 1111 116E 11AB';
ok Uni.new(0xD47D).NFD.list ~~ (0x1111, 0x116E, 0x11AC,), 'D47D -> 1111 116E 11AC';
ok Uni.new(0xD47E).NFD.list ~~ (0x1111, 0x116E, 0x11AD,), 'D47E -> 1111 116E 11AD';
ok Uni.new(0xD47F).NFD.list ~~ (0x1111, 0x116E, 0x11AE,), 'D47F -> 1111 116E 11AE';
ok Uni.new(0xD480).NFD.list ~~ (0x1111, 0x116E, 0x11AF,), 'D480 -> 1111 116E 11AF';
ok Uni.new(0xD481).NFD.list ~~ (0x1111, 0x116E, 0x11B0,), 'D481 -> 1111 116E 11B0';
ok Uni.new(0xD482).NFD.list ~~ (0x1111, 0x116E, 0x11B1,), 'D482 -> 1111 116E 11B1';
ok Uni.new(0xD483).NFD.list ~~ (0x1111, 0x116E, 0x11B2,), 'D483 -> 1111 116E 11B2';
ok Uni.new(0xD484).NFD.list ~~ (0x1111, 0x116E, 0x11B3,), 'D484 -> 1111 116E 11B3';
ok Uni.new(0xD485).NFD.list ~~ (0x1111, 0x116E, 0x11B4,), 'D485 -> 1111 116E 11B4';
ok Uni.new(0xD486).NFD.list ~~ (0x1111, 0x116E, 0x11B5,), 'D486 -> 1111 116E 11B5';
ok Uni.new(0xD487).NFD.list ~~ (0x1111, 0x116E, 0x11B6,), 'D487 -> 1111 116E 11B6';
ok Uni.new(0xD488).NFD.list ~~ (0x1111, 0x116E, 0x11B7,), 'D488 -> 1111 116E 11B7';
ok Uni.new(0xD489).NFD.list ~~ (0x1111, 0x116E, 0x11B8,), 'D489 -> 1111 116E 11B8';
ok Uni.new(0xD48A).NFD.list ~~ (0x1111, 0x116E, 0x11B9,), 'D48A -> 1111 116E 11B9';
ok Uni.new(0xD48B).NFD.list ~~ (0x1111, 0x116E, 0x11BA,), 'D48B -> 1111 116E 11BA';
ok Uni.new(0xD48C).NFD.list ~~ (0x1111, 0x116E, 0x11BB,), 'D48C -> 1111 116E 11BB';
ok Uni.new(0xD48D).NFD.list ~~ (0x1111, 0x116E, 0x11BC,), 'D48D -> 1111 116E 11BC';
ok Uni.new(0xD48E).NFD.list ~~ (0x1111, 0x116E, 0x11BD,), 'D48E -> 1111 116E 11BD';
ok Uni.new(0xD48F).NFD.list ~~ (0x1111, 0x116E, 0x11BE,), 'D48F -> 1111 116E 11BE';
ok Uni.new(0xD490).NFD.list ~~ (0x1111, 0x116E, 0x11BF,), 'D490 -> 1111 116E 11BF';
ok Uni.new(0xD491).NFD.list ~~ (0x1111, 0x116E, 0x11C0,), 'D491 -> 1111 116E 11C0';
ok Uni.new(0xD492).NFD.list ~~ (0x1111, 0x116E, 0x11C1,), 'D492 -> 1111 116E 11C1';
ok Uni.new(0xD493).NFD.list ~~ (0x1111, 0x116E, 0x11C2,), 'D493 -> 1111 116E 11C2';
ok Uni.new(0xD494).NFD.list ~~ (0x1111, 0x116F,), 'D494 -> 1111 116F';
ok Uni.new(0xD495).NFD.list ~~ (0x1111, 0x116F, 0x11A8,), 'D495 -> 1111 116F 11A8';
ok Uni.new(0xD496).NFD.list ~~ (0x1111, 0x116F, 0x11A9,), 'D496 -> 1111 116F 11A9';
ok Uni.new(0xD497).NFD.list ~~ (0x1111, 0x116F, 0x11AA,), 'D497 -> 1111 116F 11AA';
ok Uni.new(0xD498).NFD.list ~~ (0x1111, 0x116F, 0x11AB,), 'D498 -> 1111 116F 11AB';
ok Uni.new(0xD499).NFD.list ~~ (0x1111, 0x116F, 0x11AC,), 'D499 -> 1111 116F 11AC';
ok Uni.new(0xD49A).NFD.list ~~ (0x1111, 0x116F, 0x11AD,), 'D49A -> 1111 116F 11AD';
ok Uni.new(0xD49B).NFD.list ~~ (0x1111, 0x116F, 0x11AE,), 'D49B -> 1111 116F 11AE';
ok Uni.new(0xD49C).NFD.list ~~ (0x1111, 0x116F, 0x11AF,), 'D49C -> 1111 116F 11AF';
ok Uni.new(0xD49D).NFD.list ~~ (0x1111, 0x116F, 0x11B0,), 'D49D -> 1111 116F 11B0';
ok Uni.new(0xD49E).NFD.list ~~ (0x1111, 0x116F, 0x11B1,), 'D49E -> 1111 116F 11B1';
ok Uni.new(0xD49F).NFD.list ~~ (0x1111, 0x116F, 0x11B2,), 'D49F -> 1111 116F 11B2';
ok Uni.new(0xD4A0).NFD.list ~~ (0x1111, 0x116F, 0x11B3,), 'D4A0 -> 1111 116F 11B3';
ok Uni.new(0xD4A1).NFD.list ~~ (0x1111, 0x116F, 0x11B4,), 'D4A1 -> 1111 116F 11B4';
ok Uni.new(0xD4A2).NFD.list ~~ (0x1111, 0x116F, 0x11B5,), 'D4A2 -> 1111 116F 11B5';
ok Uni.new(0xD4A3).NFD.list ~~ (0x1111, 0x116F, 0x11B6,), 'D4A3 -> 1111 116F 11B6';
ok Uni.new(0xD4A4).NFD.list ~~ (0x1111, 0x116F, 0x11B7,), 'D4A4 -> 1111 116F 11B7';
ok Uni.new(0xD4A5).NFD.list ~~ (0x1111, 0x116F, 0x11B8,), 'D4A5 -> 1111 116F 11B8';
ok Uni.new(0xD4A6).NFD.list ~~ (0x1111, 0x116F, 0x11B9,), 'D4A6 -> 1111 116F 11B9';
ok Uni.new(0xD4A7).NFD.list ~~ (0x1111, 0x116F, 0x11BA,), 'D4A7 -> 1111 116F 11BA';
ok Uni.new(0xD4A8).NFD.list ~~ (0x1111, 0x116F, 0x11BB,), 'D4A8 -> 1111 116F 11BB';
ok Uni.new(0xD4A9).NFD.list ~~ (0x1111, 0x116F, 0x11BC,), 'D4A9 -> 1111 116F 11BC';
ok Uni.new(0xD4AA).NFD.list ~~ (0x1111, 0x116F, 0x11BD,), 'D4AA -> 1111 116F 11BD';
ok Uni.new(0xD4AB).NFD.list ~~ (0x1111, 0x116F, 0x11BE,), 'D4AB -> 1111 116F 11BE';
ok Uni.new(0xD4AC).NFD.list ~~ (0x1111, 0x116F, 0x11BF,), 'D4AC -> 1111 116F 11BF';
ok Uni.new(0xD4AD).NFD.list ~~ (0x1111, 0x116F, 0x11C0,), 'D4AD -> 1111 116F 11C0';
ok Uni.new(0xD4AE).NFD.list ~~ (0x1111, 0x116F, 0x11C1,), 'D4AE -> 1111 116F 11C1';
ok Uni.new(0xD4AF).NFD.list ~~ (0x1111, 0x116F, 0x11C2,), 'D4AF -> 1111 116F 11C2';
ok Uni.new(0xD4B0).NFD.list ~~ (0x1111, 0x1170,), 'D4B0 -> 1111 1170';
ok Uni.new(0xD4B1).NFD.list ~~ (0x1111, 0x1170, 0x11A8,), 'D4B1 -> 1111 1170 11A8';
ok Uni.new(0xD4B2).NFD.list ~~ (0x1111, 0x1170, 0x11A9,), 'D4B2 -> 1111 1170 11A9';
ok Uni.new(0xD4B3).NFD.list ~~ (0x1111, 0x1170, 0x11AA,), 'D4B3 -> 1111 1170 11AA';
ok Uni.new(0xD4B4).NFD.list ~~ (0x1111, 0x1170, 0x11AB,), 'D4B4 -> 1111 1170 11AB';
ok Uni.new(0xD4B5).NFD.list ~~ (0x1111, 0x1170, 0x11AC,), 'D4B5 -> 1111 1170 11AC';
ok Uni.new(0xD4B6).NFD.list ~~ (0x1111, 0x1170, 0x11AD,), 'D4B6 -> 1111 1170 11AD';
ok Uni.new(0xD4B7).NFD.list ~~ (0x1111, 0x1170, 0x11AE,), 'D4B7 -> 1111 1170 11AE';
ok Uni.new(0xD4B8).NFD.list ~~ (0x1111, 0x1170, 0x11AF,), 'D4B8 -> 1111 1170 11AF';
ok Uni.new(0xD4B9).NFD.list ~~ (0x1111, 0x1170, 0x11B0,), 'D4B9 -> 1111 1170 11B0';
ok Uni.new(0xD4BA).NFD.list ~~ (0x1111, 0x1170, 0x11B1,), 'D4BA -> 1111 1170 11B1';
ok Uni.new(0xD4BB).NFD.list ~~ (0x1111, 0x1170, 0x11B2,), 'D4BB -> 1111 1170 11B2';
ok Uni.new(0xD4BC).NFD.list ~~ (0x1111, 0x1170, 0x11B3,), 'D4BC -> 1111 1170 11B3';
ok Uni.new(0xD4BD).NFD.list ~~ (0x1111, 0x1170, 0x11B4,), 'D4BD -> 1111 1170 11B4';
ok Uni.new(0xD4BE).NFD.list ~~ (0x1111, 0x1170, 0x11B5,), 'D4BE -> 1111 1170 11B5';
ok Uni.new(0xD4BF).NFD.list ~~ (0x1111, 0x1170, 0x11B6,), 'D4BF -> 1111 1170 11B6';
ok Uni.new(0xD4C0).NFD.list ~~ (0x1111, 0x1170, 0x11B7,), 'D4C0 -> 1111 1170 11B7';
ok Uni.new(0xD4C1).NFD.list ~~ (0x1111, 0x1170, 0x11B8,), 'D4C1 -> 1111 1170 11B8';
ok Uni.new(0xD4C2).NFD.list ~~ (0x1111, 0x1170, 0x11B9,), 'D4C2 -> 1111 1170 11B9';
ok Uni.new(0xD4C3).NFD.list ~~ (0x1111, 0x1170, 0x11BA,), 'D4C3 -> 1111 1170 11BA';
ok Uni.new(0xD4C4).NFD.list ~~ (0x1111, 0x1170, 0x11BB,), 'D4C4 -> 1111 1170 11BB';
ok Uni.new(0xD4C5).NFD.list ~~ (0x1111, 0x1170, 0x11BC,), 'D4C5 -> 1111 1170 11BC';
ok Uni.new(0xD4C6).NFD.list ~~ (0x1111, 0x1170, 0x11BD,), 'D4C6 -> 1111 1170 11BD';
ok Uni.new(0xD4C7).NFD.list ~~ (0x1111, 0x1170, 0x11BE,), 'D4C7 -> 1111 1170 11BE';
ok Uni.new(0xD4C8).NFD.list ~~ (0x1111, 0x1170, 0x11BF,), 'D4C8 -> 1111 1170 11BF';
ok Uni.new(0xD4C9).NFD.list ~~ (0x1111, 0x1170, 0x11C0,), 'D4C9 -> 1111 1170 11C0';
ok Uni.new(0xD4CA).NFD.list ~~ (0x1111, 0x1170, 0x11C1,), 'D4CA -> 1111 1170 11C1';
ok Uni.new(0xD4CB).NFD.list ~~ (0x1111, 0x1170, 0x11C2,), 'D4CB -> 1111 1170 11C2';
ok Uni.new(0xD4CC).NFD.list ~~ (0x1111, 0x1171,), 'D4CC -> 1111 1171';
ok Uni.new(0xD4CD).NFD.list ~~ (0x1111, 0x1171, 0x11A8,), 'D4CD -> 1111 1171 11A8';
ok Uni.new(0xD4CE).NFD.list ~~ (0x1111, 0x1171, 0x11A9,), 'D4CE -> 1111 1171 11A9';
ok Uni.new(0xD4CF).NFD.list ~~ (0x1111, 0x1171, 0x11AA,), 'D4CF -> 1111 1171 11AA';
ok Uni.new(0xD4D0).NFD.list ~~ (0x1111, 0x1171, 0x11AB,), 'D4D0 -> 1111 1171 11AB';
ok Uni.new(0xD4D1).NFD.list ~~ (0x1111, 0x1171, 0x11AC,), 'D4D1 -> 1111 1171 11AC';
ok Uni.new(0xD4D2).NFD.list ~~ (0x1111, 0x1171, 0x11AD,), 'D4D2 -> 1111 1171 11AD';
ok Uni.new(0xD4D3).NFD.list ~~ (0x1111, 0x1171, 0x11AE,), 'D4D3 -> 1111 1171 11AE';
ok Uni.new(0xD4D4).NFD.list ~~ (0x1111, 0x1171, 0x11AF,), 'D4D4 -> 1111 1171 11AF';
ok Uni.new(0xD4D5).NFD.list ~~ (0x1111, 0x1171, 0x11B0,), 'D4D5 -> 1111 1171 11B0';
ok Uni.new(0xD4D6).NFD.list ~~ (0x1111, 0x1171, 0x11B1,), 'D4D6 -> 1111 1171 11B1';
ok Uni.new(0xD4D7).NFD.list ~~ (0x1111, 0x1171, 0x11B2,), 'D4D7 -> 1111 1171 11B2';
ok Uni.new(0xD4D8).NFD.list ~~ (0x1111, 0x1171, 0x11B3,), 'D4D8 -> 1111 1171 11B3';
ok Uni.new(0xD4D9).NFD.list ~~ (0x1111, 0x1171, 0x11B4,), 'D4D9 -> 1111 1171 11B4';
ok Uni.new(0xD4DA).NFD.list ~~ (0x1111, 0x1171, 0x11B5,), 'D4DA -> 1111 1171 11B5';
ok Uni.new(0xD4DB).NFD.list ~~ (0x1111, 0x1171, 0x11B6,), 'D4DB -> 1111 1171 11B6';
ok Uni.new(0xD4DC).NFD.list ~~ (0x1111, 0x1171, 0x11B7,), 'D4DC -> 1111 1171 11B7';
ok Uni.new(0xD4DD).NFD.list ~~ (0x1111, 0x1171, 0x11B8,), 'D4DD -> 1111 1171 11B8';
ok Uni.new(0xD4DE).NFD.list ~~ (0x1111, 0x1171, 0x11B9,), 'D4DE -> 1111 1171 11B9';
ok Uni.new(0xD4DF).NFD.list ~~ (0x1111, 0x1171, 0x11BA,), 'D4DF -> 1111 1171 11BA';
ok Uni.new(0xD4E0).NFD.list ~~ (0x1111, 0x1171, 0x11BB,), 'D4E0 -> 1111 1171 11BB';
ok Uni.new(0xD4E1).NFD.list ~~ (0x1111, 0x1171, 0x11BC,), 'D4E1 -> 1111 1171 11BC';
ok Uni.new(0xD4E2).NFD.list ~~ (0x1111, 0x1171, 0x11BD,), 'D4E2 -> 1111 1171 11BD';
ok Uni.new(0xD4E3).NFD.list ~~ (0x1111, 0x1171, 0x11BE,), 'D4E3 -> 1111 1171 11BE';
ok Uni.new(0xD4E4).NFD.list ~~ (0x1111, 0x1171, 0x11BF,), 'D4E4 -> 1111 1171 11BF';
ok Uni.new(0xD4E5).NFD.list ~~ (0x1111, 0x1171, 0x11C0,), 'D4E5 -> 1111 1171 11C0';
ok Uni.new(0xD4E6).NFD.list ~~ (0x1111, 0x1171, 0x11C1,), 'D4E6 -> 1111 1171 11C1';
ok Uni.new(0xD4E7).NFD.list ~~ (0x1111, 0x1171, 0x11C2,), 'D4E7 -> 1111 1171 11C2';
ok Uni.new(0xD4E8).NFD.list ~~ (0x1111, 0x1172,), 'D4E8 -> 1111 1172';
ok Uni.new(0xD4E9).NFD.list ~~ (0x1111, 0x1172, 0x11A8,), 'D4E9 -> 1111 1172 11A8';
ok Uni.new(0xD4EA).NFD.list ~~ (0x1111, 0x1172, 0x11A9,), 'D4EA -> 1111 1172 11A9';
ok Uni.new(0xD4EB).NFD.list ~~ (0x1111, 0x1172, 0x11AA,), 'D4EB -> 1111 1172 11AA';
ok Uni.new(0xD4EC).NFD.list ~~ (0x1111, 0x1172, 0x11AB,), 'D4EC -> 1111 1172 11AB';
ok Uni.new(0xD4ED).NFD.list ~~ (0x1111, 0x1172, 0x11AC,), 'D4ED -> 1111 1172 11AC';
ok Uni.new(0xD4EE).NFD.list ~~ (0x1111, 0x1172, 0x11AD,), 'D4EE -> 1111 1172 11AD';
ok Uni.new(0xD4EF).NFD.list ~~ (0x1111, 0x1172, 0x11AE,), 'D4EF -> 1111 1172 11AE';
ok Uni.new(0xD4F0).NFD.list ~~ (0x1111, 0x1172, 0x11AF,), 'D4F0 -> 1111 1172 11AF';
ok Uni.new(0xD4F1).NFD.list ~~ (0x1111, 0x1172, 0x11B0,), 'D4F1 -> 1111 1172 11B0';
ok Uni.new(0xD4F2).NFD.list ~~ (0x1111, 0x1172, 0x11B1,), 'D4F2 -> 1111 1172 11B1';
ok Uni.new(0xD4F3).NFD.list ~~ (0x1111, 0x1172, 0x11B2,), 'D4F3 -> 1111 1172 11B2';
ok Uni.new(0xD4F4).NFD.list ~~ (0x1111, 0x1172, 0x11B3,), 'D4F4 -> 1111 1172 11B3';
ok Uni.new(0xD4F5).NFD.list ~~ (0x1111, 0x1172, 0x11B4,), 'D4F5 -> 1111 1172 11B4';
ok Uni.new(0xD4F6).NFD.list ~~ (0x1111, 0x1172, 0x11B5,), 'D4F6 -> 1111 1172 11B5';
ok Uni.new(0xD4F7).NFD.list ~~ (0x1111, 0x1172, 0x11B6,), 'D4F7 -> 1111 1172 11B6';
ok Uni.new(0xD4F8).NFD.list ~~ (0x1111, 0x1172, 0x11B7,), 'D4F8 -> 1111 1172 11B7';
ok Uni.new(0xD4F9).NFD.list ~~ (0x1111, 0x1172, 0x11B8,), 'D4F9 -> 1111 1172 11B8';
ok Uni.new(0xD4FA).NFD.list ~~ (0x1111, 0x1172, 0x11B9,), 'D4FA -> 1111 1172 11B9';
ok Uni.new(0xD4FB).NFD.list ~~ (0x1111, 0x1172, 0x11BA,), 'D4FB -> 1111 1172 11BA';
ok Uni.new(0xD4FC).NFD.list ~~ (0x1111, 0x1172, 0x11BB,), 'D4FC -> 1111 1172 11BB';
ok Uni.new(0xD4FD).NFD.list ~~ (0x1111, 0x1172, 0x11BC,), 'D4FD -> 1111 1172 11BC';
ok Uni.new(0xD4FE).NFD.list ~~ (0x1111, 0x1172, 0x11BD,), 'D4FE -> 1111 1172 11BD';
ok Uni.new(0xD4FF).NFD.list ~~ (0x1111, 0x1172, 0x11BE,), 'D4FF -> 1111 1172 11BE';
ok Uni.new(0xD500).NFD.list ~~ (0x1111, 0x1172, 0x11BF,), 'D500 -> 1111 1172 11BF';
ok Uni.new(0xD501).NFD.list ~~ (0x1111, 0x1172, 0x11C0,), 'D501 -> 1111 1172 11C0';
ok Uni.new(0xD502).NFD.list ~~ (0x1111, 0x1172, 0x11C1,), 'D502 -> 1111 1172 11C1';
ok Uni.new(0xD503).NFD.list ~~ (0x1111, 0x1172, 0x11C2,), 'D503 -> 1111 1172 11C2';
ok Uni.new(0xD504).NFD.list ~~ (0x1111, 0x1173,), 'D504 -> 1111 1173';
ok Uni.new(0xD505).NFD.list ~~ (0x1111, 0x1173, 0x11A8,), 'D505 -> 1111 1173 11A8';
ok Uni.new(0xD506).NFD.list ~~ (0x1111, 0x1173, 0x11A9,), 'D506 -> 1111 1173 11A9';
ok Uni.new(0xD507).NFD.list ~~ (0x1111, 0x1173, 0x11AA,), 'D507 -> 1111 1173 11AA';
ok Uni.new(0xD508).NFD.list ~~ (0x1111, 0x1173, 0x11AB,), 'D508 -> 1111 1173 11AB';
ok Uni.new(0xD509).NFD.list ~~ (0x1111, 0x1173, 0x11AC,), 'D509 -> 1111 1173 11AC';
ok Uni.new(0xD50A).NFD.list ~~ (0x1111, 0x1173, 0x11AD,), 'D50A -> 1111 1173 11AD';
ok Uni.new(0xD50B).NFD.list ~~ (0x1111, 0x1173, 0x11AE,), 'D50B -> 1111 1173 11AE';
ok Uni.new(0xD50C).NFD.list ~~ (0x1111, 0x1173, 0x11AF,), 'D50C -> 1111 1173 11AF';
ok Uni.new(0xD50D).NFD.list ~~ (0x1111, 0x1173, 0x11B0,), 'D50D -> 1111 1173 11B0';
ok Uni.new(0xD50E).NFD.list ~~ (0x1111, 0x1173, 0x11B1,), 'D50E -> 1111 1173 11B1';
ok Uni.new(0xD50F).NFD.list ~~ (0x1111, 0x1173, 0x11B2,), 'D50F -> 1111 1173 11B2';
ok Uni.new(0xD510).NFD.list ~~ (0x1111, 0x1173, 0x11B3,), 'D510 -> 1111 1173 11B3';
ok Uni.new(0xD511).NFD.list ~~ (0x1111, 0x1173, 0x11B4,), 'D511 -> 1111 1173 11B4';
ok Uni.new(0xD512).NFD.list ~~ (0x1111, 0x1173, 0x11B5,), 'D512 -> 1111 1173 11B5';
ok Uni.new(0xD513).NFD.list ~~ (0x1111, 0x1173, 0x11B6,), 'D513 -> 1111 1173 11B6';
ok Uni.new(0xD514).NFD.list ~~ (0x1111, 0x1173, 0x11B7,), 'D514 -> 1111 1173 11B7';
ok Uni.new(0xD515).NFD.list ~~ (0x1111, 0x1173, 0x11B8,), 'D515 -> 1111 1173 11B8';
ok Uni.new(0xD516).NFD.list ~~ (0x1111, 0x1173, 0x11B9,), 'D516 -> 1111 1173 11B9';
ok Uni.new(0xD517).NFD.list ~~ (0x1111, 0x1173, 0x11BA,), 'D517 -> 1111 1173 11BA';
ok Uni.new(0xD518).NFD.list ~~ (0x1111, 0x1173, 0x11BB,), 'D518 -> 1111 1173 11BB';
ok Uni.new(0xD519).NFD.list ~~ (0x1111, 0x1173, 0x11BC,), 'D519 -> 1111 1173 11BC';
ok Uni.new(0xD51A).NFD.list ~~ (0x1111, 0x1173, 0x11BD,), 'D51A -> 1111 1173 11BD';
ok Uni.new(0xD51B).NFD.list ~~ (0x1111, 0x1173, 0x11BE,), 'D51B -> 1111 1173 11BE';
ok Uni.new(0xD51C).NFD.list ~~ (0x1111, 0x1173, 0x11BF,), 'D51C -> 1111 1173 11BF';
ok Uni.new(0xD51D).NFD.list ~~ (0x1111, 0x1173, 0x11C0,), 'D51D -> 1111 1173 11C0';
ok Uni.new(0xD51E).NFD.list ~~ (0x1111, 0x1173, 0x11C1,), 'D51E -> 1111 1173 11C1';
ok Uni.new(0xD51F).NFD.list ~~ (0x1111, 0x1173, 0x11C2,), 'D51F -> 1111 1173 11C2';
ok Uni.new(0xD520).NFD.list ~~ (0x1111, 0x1174,), 'D520 -> 1111 1174';
ok Uni.new(0xD521).NFD.list ~~ (0x1111, 0x1174, 0x11A8,), 'D521 -> 1111 1174 11A8';
ok Uni.new(0xD522).NFD.list ~~ (0x1111, 0x1174, 0x11A9,), 'D522 -> 1111 1174 11A9';
ok Uni.new(0xD523).NFD.list ~~ (0x1111, 0x1174, 0x11AA,), 'D523 -> 1111 1174 11AA';
ok Uni.new(0xD524).NFD.list ~~ (0x1111, 0x1174, 0x11AB,), 'D524 -> 1111 1174 11AB';
ok Uni.new(0xD525).NFD.list ~~ (0x1111, 0x1174, 0x11AC,), 'D525 -> 1111 1174 11AC';
ok Uni.new(0xD526).NFD.list ~~ (0x1111, 0x1174, 0x11AD,), 'D526 -> 1111 1174 11AD';
ok Uni.new(0xD527).NFD.list ~~ (0x1111, 0x1174, 0x11AE,), 'D527 -> 1111 1174 11AE';
ok Uni.new(0xD528).NFD.list ~~ (0x1111, 0x1174, 0x11AF,), 'D528 -> 1111 1174 11AF';
ok Uni.new(0xD529).NFD.list ~~ (0x1111, 0x1174, 0x11B0,), 'D529 -> 1111 1174 11B0';
ok Uni.new(0xD52A).NFD.list ~~ (0x1111, 0x1174, 0x11B1,), 'D52A -> 1111 1174 11B1';
ok Uni.new(0xD52B).NFD.list ~~ (0x1111, 0x1174, 0x11B2,), 'D52B -> 1111 1174 11B2';
ok Uni.new(0xD52C).NFD.list ~~ (0x1111, 0x1174, 0x11B3,), 'D52C -> 1111 1174 11B3';
ok Uni.new(0xD52D).NFD.list ~~ (0x1111, 0x1174, 0x11B4,), 'D52D -> 1111 1174 11B4';
ok Uni.new(0xD52E).NFD.list ~~ (0x1111, 0x1174, 0x11B5,), 'D52E -> 1111 1174 11B5';
ok Uni.new(0xD52F).NFD.list ~~ (0x1111, 0x1174, 0x11B6,), 'D52F -> 1111 1174 11B6';
ok Uni.new(0xD530).NFD.list ~~ (0x1111, 0x1174, 0x11B7,), 'D530 -> 1111 1174 11B7';
ok Uni.new(0xD531).NFD.list ~~ (0x1111, 0x1174, 0x11B8,), 'D531 -> 1111 1174 11B8';
ok Uni.new(0xD532).NFD.list ~~ (0x1111, 0x1174, 0x11B9,), 'D532 -> 1111 1174 11B9';
ok Uni.new(0xD533).NFD.list ~~ (0x1111, 0x1174, 0x11BA,), 'D533 -> 1111 1174 11BA';
ok Uni.new(0xD534).NFD.list ~~ (0x1111, 0x1174, 0x11BB,), 'D534 -> 1111 1174 11BB';
ok Uni.new(0xD535).NFD.list ~~ (0x1111, 0x1174, 0x11BC,), 'D535 -> 1111 1174 11BC';
ok Uni.new(0xD536).NFD.list ~~ (0x1111, 0x1174, 0x11BD,), 'D536 -> 1111 1174 11BD';
ok Uni.new(0xD537).NFD.list ~~ (0x1111, 0x1174, 0x11BE,), 'D537 -> 1111 1174 11BE';
ok Uni.new(0xD538).NFD.list ~~ (0x1111, 0x1174, 0x11BF,), 'D538 -> 1111 1174 11BF';
ok Uni.new(0xD539).NFD.list ~~ (0x1111, 0x1174, 0x11C0,), 'D539 -> 1111 1174 11C0';
ok Uni.new(0xD53A).NFD.list ~~ (0x1111, 0x1174, 0x11C1,), 'D53A -> 1111 1174 11C1';
ok Uni.new(0xD53B).NFD.list ~~ (0x1111, 0x1174, 0x11C2,), 'D53B -> 1111 1174 11C2';
ok Uni.new(0xD53C).NFD.list ~~ (0x1111, 0x1175,), 'D53C -> 1111 1175';
ok Uni.new(0xD53D).NFD.list ~~ (0x1111, 0x1175, 0x11A8,), 'D53D -> 1111 1175 11A8';
ok Uni.new(0xD53E).NFD.list ~~ (0x1111, 0x1175, 0x11A9,), 'D53E -> 1111 1175 11A9';
ok Uni.new(0xD53F).NFD.list ~~ (0x1111, 0x1175, 0x11AA,), 'D53F -> 1111 1175 11AA';
ok Uni.new(0xD540).NFD.list ~~ (0x1111, 0x1175, 0x11AB,), 'D540 -> 1111 1175 11AB';
ok Uni.new(0xD541).NFD.list ~~ (0x1111, 0x1175, 0x11AC,), 'D541 -> 1111 1175 11AC';
ok Uni.new(0xD542).NFD.list ~~ (0x1111, 0x1175, 0x11AD,), 'D542 -> 1111 1175 11AD';
ok Uni.new(0xD543).NFD.list ~~ (0x1111, 0x1175, 0x11AE,), 'D543 -> 1111 1175 11AE';
ok Uni.new(0xD544).NFD.list ~~ (0x1111, 0x1175, 0x11AF,), 'D544 -> 1111 1175 11AF';
ok Uni.new(0xD545).NFD.list ~~ (0x1111, 0x1175, 0x11B0,), 'D545 -> 1111 1175 11B0';
ok Uni.new(0xD546).NFD.list ~~ (0x1111, 0x1175, 0x11B1,), 'D546 -> 1111 1175 11B1';
ok Uni.new(0xD547).NFD.list ~~ (0x1111, 0x1175, 0x11B2,), 'D547 -> 1111 1175 11B2';
ok Uni.new(0xD548).NFD.list ~~ (0x1111, 0x1175, 0x11B3,), 'D548 -> 1111 1175 11B3';
ok Uni.new(0xD549).NFD.list ~~ (0x1111, 0x1175, 0x11B4,), 'D549 -> 1111 1175 11B4';
ok Uni.new(0xD54A).NFD.list ~~ (0x1111, 0x1175, 0x11B5,), 'D54A -> 1111 1175 11B5';
ok Uni.new(0xD54B).NFD.list ~~ (0x1111, 0x1175, 0x11B6,), 'D54B -> 1111 1175 11B6';
ok Uni.new(0xD54C).NFD.list ~~ (0x1111, 0x1175, 0x11B7,), 'D54C -> 1111 1175 11B7';
ok Uni.new(0xD54D).NFD.list ~~ (0x1111, 0x1175, 0x11B8,), 'D54D -> 1111 1175 11B8';
ok Uni.new(0xD54E).NFD.list ~~ (0x1111, 0x1175, 0x11B9,), 'D54E -> 1111 1175 11B9';
ok Uni.new(0xD54F).NFD.list ~~ (0x1111, 0x1175, 0x11BA,), 'D54F -> 1111 1175 11BA';
ok Uni.new(0xD550).NFD.list ~~ (0x1111, 0x1175, 0x11BB,), 'D550 -> 1111 1175 11BB';
ok Uni.new(0xD551).NFD.list ~~ (0x1111, 0x1175, 0x11BC,), 'D551 -> 1111 1175 11BC';
ok Uni.new(0xD552).NFD.list ~~ (0x1111, 0x1175, 0x11BD,), 'D552 -> 1111 1175 11BD';
ok Uni.new(0xD553).NFD.list ~~ (0x1111, 0x1175, 0x11BE,), 'D553 -> 1111 1175 11BE';
ok Uni.new(0xD554).NFD.list ~~ (0x1111, 0x1175, 0x11BF,), 'D554 -> 1111 1175 11BF';
ok Uni.new(0xD555).NFD.list ~~ (0x1111, 0x1175, 0x11C0,), 'D555 -> 1111 1175 11C0';
ok Uni.new(0xD556).NFD.list ~~ (0x1111, 0x1175, 0x11C1,), 'D556 -> 1111 1175 11C1';
ok Uni.new(0xD557).NFD.list ~~ (0x1111, 0x1175, 0x11C2,), 'D557 -> 1111 1175 11C2';
ok Uni.new(0xD558).NFD.list ~~ (0x1112, 0x1161,), 'D558 -> 1112 1161';
ok Uni.new(0xD559).NFD.list ~~ (0x1112, 0x1161, 0x11A8,), 'D559 -> 1112 1161 11A8';
ok Uni.new(0xD55A).NFD.list ~~ (0x1112, 0x1161, 0x11A9,), 'D55A -> 1112 1161 11A9';
ok Uni.new(0xD55B).NFD.list ~~ (0x1112, 0x1161, 0x11AA,), 'D55B -> 1112 1161 11AA';
ok Uni.new(0xD55C).NFD.list ~~ (0x1112, 0x1161, 0x11AB,), 'D55C -> 1112 1161 11AB';
ok Uni.new(0xD55D).NFD.list ~~ (0x1112, 0x1161, 0x11AC,), 'D55D -> 1112 1161 11AC';
ok Uni.new(0xD55E).NFD.list ~~ (0x1112, 0x1161, 0x11AD,), 'D55E -> 1112 1161 11AD';
ok Uni.new(0xD55F).NFD.list ~~ (0x1112, 0x1161, 0x11AE,), 'D55F -> 1112 1161 11AE';
ok Uni.new(0xD560).NFD.list ~~ (0x1112, 0x1161, 0x11AF,), 'D560 -> 1112 1161 11AF';
ok Uni.new(0xD561).NFD.list ~~ (0x1112, 0x1161, 0x11B0,), 'D561 -> 1112 1161 11B0';
ok Uni.new(0xD562).NFD.list ~~ (0x1112, 0x1161, 0x11B1,), 'D562 -> 1112 1161 11B1';
ok Uni.new(0xD563).NFD.list ~~ (0x1112, 0x1161, 0x11B2,), 'D563 -> 1112 1161 11B2';
ok Uni.new(0xD564).NFD.list ~~ (0x1112, 0x1161, 0x11B3,), 'D564 -> 1112 1161 11B3';
ok Uni.new(0xD565).NFD.list ~~ (0x1112, 0x1161, 0x11B4,), 'D565 -> 1112 1161 11B4';
ok Uni.new(0xD566).NFD.list ~~ (0x1112, 0x1161, 0x11B5,), 'D566 -> 1112 1161 11B5';
ok Uni.new(0xD567).NFD.list ~~ (0x1112, 0x1161, 0x11B6,), 'D567 -> 1112 1161 11B6';
ok Uni.new(0xD568).NFD.list ~~ (0x1112, 0x1161, 0x11B7,), 'D568 -> 1112 1161 11B7';
ok Uni.new(0xD569).NFD.list ~~ (0x1112, 0x1161, 0x11B8,), 'D569 -> 1112 1161 11B8';
ok Uni.new(0xD56A).NFD.list ~~ (0x1112, 0x1161, 0x11B9,), 'D56A -> 1112 1161 11B9';
ok Uni.new(0xD56B).NFD.list ~~ (0x1112, 0x1161, 0x11BA,), 'D56B -> 1112 1161 11BA';
ok Uni.new(0xD56C).NFD.list ~~ (0x1112, 0x1161, 0x11BB,), 'D56C -> 1112 1161 11BB';
ok Uni.new(0xD56D).NFD.list ~~ (0x1112, 0x1161, 0x11BC,), 'D56D -> 1112 1161 11BC';
ok Uni.new(0xD56E).NFD.list ~~ (0x1112, 0x1161, 0x11BD,), 'D56E -> 1112 1161 11BD';
ok Uni.new(0xD56F).NFD.list ~~ (0x1112, 0x1161, 0x11BE,), 'D56F -> 1112 1161 11BE';
ok Uni.new(0xD570).NFD.list ~~ (0x1112, 0x1161, 0x11BF,), 'D570 -> 1112 1161 11BF';
ok Uni.new(0xD571).NFD.list ~~ (0x1112, 0x1161, 0x11C0,), 'D571 -> 1112 1161 11C0';
ok Uni.new(0xD572).NFD.list ~~ (0x1112, 0x1161, 0x11C1,), 'D572 -> 1112 1161 11C1';
ok Uni.new(0xD573).NFD.list ~~ (0x1112, 0x1161, 0x11C2,), 'D573 -> 1112 1161 11C2';
ok Uni.new(0xD574).NFD.list ~~ (0x1112, 0x1162,), 'D574 -> 1112 1162';
ok Uni.new(0xD575).NFD.list ~~ (0x1112, 0x1162, 0x11A8,), 'D575 -> 1112 1162 11A8';
ok Uni.new(0xD576).NFD.list ~~ (0x1112, 0x1162, 0x11A9,), 'D576 -> 1112 1162 11A9';
ok Uni.new(0xD577).NFD.list ~~ (0x1112, 0x1162, 0x11AA,), 'D577 -> 1112 1162 11AA';
ok Uni.new(0xD578).NFD.list ~~ (0x1112, 0x1162, 0x11AB,), 'D578 -> 1112 1162 11AB';
ok Uni.new(0xD579).NFD.list ~~ (0x1112, 0x1162, 0x11AC,), 'D579 -> 1112 1162 11AC';
ok Uni.new(0xD57A).NFD.list ~~ (0x1112, 0x1162, 0x11AD,), 'D57A -> 1112 1162 11AD';
ok Uni.new(0xD57B).NFD.list ~~ (0x1112, 0x1162, 0x11AE,), 'D57B -> 1112 1162 11AE';
ok Uni.new(0xD57C).NFD.list ~~ (0x1112, 0x1162, 0x11AF,), 'D57C -> 1112 1162 11AF';
ok Uni.new(0xD57D).NFD.list ~~ (0x1112, 0x1162, 0x11B0,), 'D57D -> 1112 1162 11B0';
ok Uni.new(0xD57E).NFD.list ~~ (0x1112, 0x1162, 0x11B1,), 'D57E -> 1112 1162 11B1';
ok Uni.new(0xD57F).NFD.list ~~ (0x1112, 0x1162, 0x11B2,), 'D57F -> 1112 1162 11B2';
ok Uni.new(0xD580).NFD.list ~~ (0x1112, 0x1162, 0x11B3,), 'D580 -> 1112 1162 11B3';
ok Uni.new(0xD581).NFD.list ~~ (0x1112, 0x1162, 0x11B4,), 'D581 -> 1112 1162 11B4';
ok Uni.new(0xD582).NFD.list ~~ (0x1112, 0x1162, 0x11B5,), 'D582 -> 1112 1162 11B5';
ok Uni.new(0xD583).NFD.list ~~ (0x1112, 0x1162, 0x11B6,), 'D583 -> 1112 1162 11B6';
ok Uni.new(0xD584).NFD.list ~~ (0x1112, 0x1162, 0x11B7,), 'D584 -> 1112 1162 11B7';
ok Uni.new(0xD585).NFD.list ~~ (0x1112, 0x1162, 0x11B8,), 'D585 -> 1112 1162 11B8';
ok Uni.new(0xD586).NFD.list ~~ (0x1112, 0x1162, 0x11B9,), 'D586 -> 1112 1162 11B9';
ok Uni.new(0xD587).NFD.list ~~ (0x1112, 0x1162, 0x11BA,), 'D587 -> 1112 1162 11BA';
ok Uni.new(0xD588).NFD.list ~~ (0x1112, 0x1162, 0x11BB,), 'D588 -> 1112 1162 11BB';
ok Uni.new(0xD589).NFD.list ~~ (0x1112, 0x1162, 0x11BC,), 'D589 -> 1112 1162 11BC';
ok Uni.new(0xD58A).NFD.list ~~ (0x1112, 0x1162, 0x11BD,), 'D58A -> 1112 1162 11BD';
ok Uni.new(0xD58B).NFD.list ~~ (0x1112, 0x1162, 0x11BE,), 'D58B -> 1112 1162 11BE';
ok Uni.new(0xD58C).NFD.list ~~ (0x1112, 0x1162, 0x11BF,), 'D58C -> 1112 1162 11BF';
ok Uni.new(0xD58D).NFD.list ~~ (0x1112, 0x1162, 0x11C0,), 'D58D -> 1112 1162 11C0';
ok Uni.new(0xD58E).NFD.list ~~ (0x1112, 0x1162, 0x11C1,), 'D58E -> 1112 1162 11C1';
ok Uni.new(0xD58F).NFD.list ~~ (0x1112, 0x1162, 0x11C2,), 'D58F -> 1112 1162 11C2';
ok Uni.new(0xD590).NFD.list ~~ (0x1112, 0x1163,), 'D590 -> 1112 1163';
ok Uni.new(0xD591).NFD.list ~~ (0x1112, 0x1163, 0x11A8,), 'D591 -> 1112 1163 11A8';
ok Uni.new(0xD592).NFD.list ~~ (0x1112, 0x1163, 0x11A9,), 'D592 -> 1112 1163 11A9';
ok Uni.new(0xD593).NFD.list ~~ (0x1112, 0x1163, 0x11AA,), 'D593 -> 1112 1163 11AA';
ok Uni.new(0xD594).NFD.list ~~ (0x1112, 0x1163, 0x11AB,), 'D594 -> 1112 1163 11AB';
ok Uni.new(0xD595).NFD.list ~~ (0x1112, 0x1163, 0x11AC,), 'D595 -> 1112 1163 11AC';
ok Uni.new(0xD596).NFD.list ~~ (0x1112, 0x1163, 0x11AD,), 'D596 -> 1112 1163 11AD';
ok Uni.new(0xD597).NFD.list ~~ (0x1112, 0x1163, 0x11AE,), 'D597 -> 1112 1163 11AE';
ok Uni.new(0xD598).NFD.list ~~ (0x1112, 0x1163, 0x11AF,), 'D598 -> 1112 1163 11AF';
ok Uni.new(0xD599).NFD.list ~~ (0x1112, 0x1163, 0x11B0,), 'D599 -> 1112 1163 11B0';
ok Uni.new(0xD59A).NFD.list ~~ (0x1112, 0x1163, 0x11B1,), 'D59A -> 1112 1163 11B1';
ok Uni.new(0xD59B).NFD.list ~~ (0x1112, 0x1163, 0x11B2,), 'D59B -> 1112 1163 11B2';
ok Uni.new(0xD59C).NFD.list ~~ (0x1112, 0x1163, 0x11B3,), 'D59C -> 1112 1163 11B3';
ok Uni.new(0xD59D).NFD.list ~~ (0x1112, 0x1163, 0x11B4,), 'D59D -> 1112 1163 11B4';
ok Uni.new(0xD59E).NFD.list ~~ (0x1112, 0x1163, 0x11B5,), 'D59E -> 1112 1163 11B5';
ok Uni.new(0xD59F).NFD.list ~~ (0x1112, 0x1163, 0x11B6,), 'D59F -> 1112 1163 11B6';
ok Uni.new(0xD5A0).NFD.list ~~ (0x1112, 0x1163, 0x11B7,), 'D5A0 -> 1112 1163 11B7';
ok Uni.new(0xD5A1).NFD.list ~~ (0x1112, 0x1163, 0x11B8,), 'D5A1 -> 1112 1163 11B8';
ok Uni.new(0xD5A2).NFD.list ~~ (0x1112, 0x1163, 0x11B9,), 'D5A2 -> 1112 1163 11B9';
ok Uni.new(0xD5A3).NFD.list ~~ (0x1112, 0x1163, 0x11BA,), 'D5A3 -> 1112 1163 11BA';
ok Uni.new(0xD5A4).NFD.list ~~ (0x1112, 0x1163, 0x11BB,), 'D5A4 -> 1112 1163 11BB';
ok Uni.new(0xD5A5).NFD.list ~~ (0x1112, 0x1163, 0x11BC,), 'D5A5 -> 1112 1163 11BC';
ok Uni.new(0xD5A6).NFD.list ~~ (0x1112, 0x1163, 0x11BD,), 'D5A6 -> 1112 1163 11BD';
ok Uni.new(0xD5A7).NFD.list ~~ (0x1112, 0x1163, 0x11BE,), 'D5A7 -> 1112 1163 11BE';
ok Uni.new(0xD5A8).NFD.list ~~ (0x1112, 0x1163, 0x11BF,), 'D5A8 -> 1112 1163 11BF';
ok Uni.new(0xD5A9).NFD.list ~~ (0x1112, 0x1163, 0x11C0,), 'D5A9 -> 1112 1163 11C0';
ok Uni.new(0xD5AA).NFD.list ~~ (0x1112, 0x1163, 0x11C1,), 'D5AA -> 1112 1163 11C1';
ok Uni.new(0xD5AB).NFD.list ~~ (0x1112, 0x1163, 0x11C2,), 'D5AB -> 1112 1163 11C2';
ok Uni.new(0xD5AC).NFD.list ~~ (0x1112, 0x1164,), 'D5AC -> 1112 1164';
ok Uni.new(0xD5AD).NFD.list ~~ (0x1112, 0x1164, 0x11A8,), 'D5AD -> 1112 1164 11A8';
ok Uni.new(0xD5AE).NFD.list ~~ (0x1112, 0x1164, 0x11A9,), 'D5AE -> 1112 1164 11A9';
ok Uni.new(0xD5AF).NFD.list ~~ (0x1112, 0x1164, 0x11AA,), 'D5AF -> 1112 1164 11AA';
ok Uni.new(0xD5B0).NFD.list ~~ (0x1112, 0x1164, 0x11AB,), 'D5B0 -> 1112 1164 11AB';
ok Uni.new(0xD5B1).NFD.list ~~ (0x1112, 0x1164, 0x11AC,), 'D5B1 -> 1112 1164 11AC';
ok Uni.new(0xD5B2).NFD.list ~~ (0x1112, 0x1164, 0x11AD,), 'D5B2 -> 1112 1164 11AD';
ok Uni.new(0xD5B3).NFD.list ~~ (0x1112, 0x1164, 0x11AE,), 'D5B3 -> 1112 1164 11AE';
ok Uni.new(0xD5B4).NFD.list ~~ (0x1112, 0x1164, 0x11AF,), 'D5B4 -> 1112 1164 11AF';
ok Uni.new(0xD5B5).NFD.list ~~ (0x1112, 0x1164, 0x11B0,), 'D5B5 -> 1112 1164 11B0';
ok Uni.new(0xD5B6).NFD.list ~~ (0x1112, 0x1164, 0x11B1,), 'D5B6 -> 1112 1164 11B1';
ok Uni.new(0xD5B7).NFD.list ~~ (0x1112, 0x1164, 0x11B2,), 'D5B7 -> 1112 1164 11B2';
ok Uni.new(0xD5B8).NFD.list ~~ (0x1112, 0x1164, 0x11B3,), 'D5B8 -> 1112 1164 11B3';
ok Uni.new(0xD5B9).NFD.list ~~ (0x1112, 0x1164, 0x11B4,), 'D5B9 -> 1112 1164 11B4';
ok Uni.new(0xD5BA).NFD.list ~~ (0x1112, 0x1164, 0x11B5,), 'D5BA -> 1112 1164 11B5';
ok Uni.new(0xD5BB).NFD.list ~~ (0x1112, 0x1164, 0x11B6,), 'D5BB -> 1112 1164 11B6';
ok Uni.new(0xD5BC).NFD.list ~~ (0x1112, 0x1164, 0x11B7,), 'D5BC -> 1112 1164 11B7';
ok Uni.new(0xD5BD).NFD.list ~~ (0x1112, 0x1164, 0x11B8,), 'D5BD -> 1112 1164 11B8';
ok Uni.new(0xD5BE).NFD.list ~~ (0x1112, 0x1164, 0x11B9,), 'D5BE -> 1112 1164 11B9';
ok Uni.new(0xD5BF).NFD.list ~~ (0x1112, 0x1164, 0x11BA,), 'D5BF -> 1112 1164 11BA';
ok Uni.new(0xD5C0).NFD.list ~~ (0x1112, 0x1164, 0x11BB,), 'D5C0 -> 1112 1164 11BB';
ok Uni.new(0xD5C1).NFD.list ~~ (0x1112, 0x1164, 0x11BC,), 'D5C1 -> 1112 1164 11BC';
ok Uni.new(0xD5C2).NFD.list ~~ (0x1112, 0x1164, 0x11BD,), 'D5C2 -> 1112 1164 11BD';
ok Uni.new(0xD5C3).NFD.list ~~ (0x1112, 0x1164, 0x11BE,), 'D5C3 -> 1112 1164 11BE';
ok Uni.new(0xD5C4).NFD.list ~~ (0x1112, 0x1164, 0x11BF,), 'D5C4 -> 1112 1164 11BF';
ok Uni.new(0xD5C5).NFD.list ~~ (0x1112, 0x1164, 0x11C0,), 'D5C5 -> 1112 1164 11C0';
ok Uni.new(0xD5C6).NFD.list ~~ (0x1112, 0x1164, 0x11C1,), 'D5C6 -> 1112 1164 11C1';
ok Uni.new(0xD5C7).NFD.list ~~ (0x1112, 0x1164, 0x11C2,), 'D5C7 -> 1112 1164 11C2';
ok Uni.new(0xD5C8).NFD.list ~~ (0x1112, 0x1165,), 'D5C8 -> 1112 1165';
ok Uni.new(0xD5C9).NFD.list ~~ (0x1112, 0x1165, 0x11A8,), 'D5C9 -> 1112 1165 11A8';
ok Uni.new(0xD5CA).NFD.list ~~ (0x1112, 0x1165, 0x11A9,), 'D5CA -> 1112 1165 11A9';
ok Uni.new(0xD5CB).NFD.list ~~ (0x1112, 0x1165, 0x11AA,), 'D5CB -> 1112 1165 11AA';
ok Uni.new(0xD5CC).NFD.list ~~ (0x1112, 0x1165, 0x11AB,), 'D5CC -> 1112 1165 11AB';
ok Uni.new(0xD5CD).NFD.list ~~ (0x1112, 0x1165, 0x11AC,), 'D5CD -> 1112 1165 11AC';
ok Uni.new(0xD5CE).NFD.list ~~ (0x1112, 0x1165, 0x11AD,), 'D5CE -> 1112 1165 11AD';
ok Uni.new(0xD5CF).NFD.list ~~ (0x1112, 0x1165, 0x11AE,), 'D5CF -> 1112 1165 11AE';
ok Uni.new(0xD5D0).NFD.list ~~ (0x1112, 0x1165, 0x11AF,), 'D5D0 -> 1112 1165 11AF';
ok Uni.new(0xD5D1).NFD.list ~~ (0x1112, 0x1165, 0x11B0,), 'D5D1 -> 1112 1165 11B0';
ok Uni.new(0xD5D2).NFD.list ~~ (0x1112, 0x1165, 0x11B1,), 'D5D2 -> 1112 1165 11B1';
ok Uni.new(0xD5D3).NFD.list ~~ (0x1112, 0x1165, 0x11B2,), 'D5D3 -> 1112 1165 11B2';
ok Uni.new(0xD5D4).NFD.list ~~ (0x1112, 0x1165, 0x11B3,), 'D5D4 -> 1112 1165 11B3';
ok Uni.new(0xD5D5).NFD.list ~~ (0x1112, 0x1165, 0x11B4,), 'D5D5 -> 1112 1165 11B4';
ok Uni.new(0xD5D6).NFD.list ~~ (0x1112, 0x1165, 0x11B5,), 'D5D6 -> 1112 1165 11B5';
ok Uni.new(0xD5D7).NFD.list ~~ (0x1112, 0x1165, 0x11B6,), 'D5D7 -> 1112 1165 11B6';
ok Uni.new(0xD5D8).NFD.list ~~ (0x1112, 0x1165, 0x11B7,), 'D5D8 -> 1112 1165 11B7';
ok Uni.new(0xD5D9).NFD.list ~~ (0x1112, 0x1165, 0x11B8,), 'D5D9 -> 1112 1165 11B8';
ok Uni.new(0xD5DA).NFD.list ~~ (0x1112, 0x1165, 0x11B9,), 'D5DA -> 1112 1165 11B9';
ok Uni.new(0xD5DB).NFD.list ~~ (0x1112, 0x1165, 0x11BA,), 'D5DB -> 1112 1165 11BA';
ok Uni.new(0xD5DC).NFD.list ~~ (0x1112, 0x1165, 0x11BB,), 'D5DC -> 1112 1165 11BB';
ok Uni.new(0xD5DD).NFD.list ~~ (0x1112, 0x1165, 0x11BC,), 'D5DD -> 1112 1165 11BC';
ok Uni.new(0xD5DE).NFD.list ~~ (0x1112, 0x1165, 0x11BD,), 'D5DE -> 1112 1165 11BD';
ok Uni.new(0xD5DF).NFD.list ~~ (0x1112, 0x1165, 0x11BE,), 'D5DF -> 1112 1165 11BE';
ok Uni.new(0xD5E0).NFD.list ~~ (0x1112, 0x1165, 0x11BF,), 'D5E0 -> 1112 1165 11BF';
ok Uni.new(0xD5E1).NFD.list ~~ (0x1112, 0x1165, 0x11C0,), 'D5E1 -> 1112 1165 11C0';
ok Uni.new(0xD5E2).NFD.list ~~ (0x1112, 0x1165, 0x11C1,), 'D5E2 -> 1112 1165 11C1';
ok Uni.new(0xD5E3).NFD.list ~~ (0x1112, 0x1165, 0x11C2,), 'D5E3 -> 1112 1165 11C2';
ok Uni.new(0xD5E4).NFD.list ~~ (0x1112, 0x1166,), 'D5E4 -> 1112 1166';
ok Uni.new(0xD5E5).NFD.list ~~ (0x1112, 0x1166, 0x11A8,), 'D5E5 -> 1112 1166 11A8';
ok Uni.new(0xD5E6).NFD.list ~~ (0x1112, 0x1166, 0x11A9,), 'D5E6 -> 1112 1166 11A9';
ok Uni.new(0xD5E7).NFD.list ~~ (0x1112, 0x1166, 0x11AA,), 'D5E7 -> 1112 1166 11AA';
ok Uni.new(0xD5E8).NFD.list ~~ (0x1112, 0x1166, 0x11AB,), 'D5E8 -> 1112 1166 11AB';
ok Uni.new(0xD5E9).NFD.list ~~ (0x1112, 0x1166, 0x11AC,), 'D5E9 -> 1112 1166 11AC';
ok Uni.new(0xD5EA).NFD.list ~~ (0x1112, 0x1166, 0x11AD,), 'D5EA -> 1112 1166 11AD';
ok Uni.new(0xD5EB).NFD.list ~~ (0x1112, 0x1166, 0x11AE,), 'D5EB -> 1112 1166 11AE';
ok Uni.new(0xD5EC).NFD.list ~~ (0x1112, 0x1166, 0x11AF,), 'D5EC -> 1112 1166 11AF';
ok Uni.new(0xD5ED).NFD.list ~~ (0x1112, 0x1166, 0x11B0,), 'D5ED -> 1112 1166 11B0';
ok Uni.new(0xD5EE).NFD.list ~~ (0x1112, 0x1166, 0x11B1,), 'D5EE -> 1112 1166 11B1';
ok Uni.new(0xD5EF).NFD.list ~~ (0x1112, 0x1166, 0x11B2,), 'D5EF -> 1112 1166 11B2';
ok Uni.new(0xD5F0).NFD.list ~~ (0x1112, 0x1166, 0x11B3,), 'D5F0 -> 1112 1166 11B3';
ok Uni.new(0xD5F1).NFD.list ~~ (0x1112, 0x1166, 0x11B4,), 'D5F1 -> 1112 1166 11B4';
ok Uni.new(0xD5F2).NFD.list ~~ (0x1112, 0x1166, 0x11B5,), 'D5F2 -> 1112 1166 11B5';
ok Uni.new(0xD5F3).NFD.list ~~ (0x1112, 0x1166, 0x11B6,), 'D5F3 -> 1112 1166 11B6';
ok Uni.new(0xD5F4).NFD.list ~~ (0x1112, 0x1166, 0x11B7,), 'D5F4 -> 1112 1166 11B7';
ok Uni.new(0xD5F5).NFD.list ~~ (0x1112, 0x1166, 0x11B8,), 'D5F5 -> 1112 1166 11B8';
ok Uni.new(0xD5F6).NFD.list ~~ (0x1112, 0x1166, 0x11B9,), 'D5F6 -> 1112 1166 11B9';
ok Uni.new(0xD5F7).NFD.list ~~ (0x1112, 0x1166, 0x11BA,), 'D5F7 -> 1112 1166 11BA';
ok Uni.new(0xD5F8).NFD.list ~~ (0x1112, 0x1166, 0x11BB,), 'D5F8 -> 1112 1166 11BB';
ok Uni.new(0xD5F9).NFD.list ~~ (0x1112, 0x1166, 0x11BC,), 'D5F9 -> 1112 1166 11BC';
ok Uni.new(0xD5FA).NFD.list ~~ (0x1112, 0x1166, 0x11BD,), 'D5FA -> 1112 1166 11BD';
ok Uni.new(0xD5FB).NFD.list ~~ (0x1112, 0x1166, 0x11BE,), 'D5FB -> 1112 1166 11BE';
ok Uni.new(0xD5FC).NFD.list ~~ (0x1112, 0x1166, 0x11BF,), 'D5FC -> 1112 1166 11BF';
ok Uni.new(0xD5FD).NFD.list ~~ (0x1112, 0x1166, 0x11C0,), 'D5FD -> 1112 1166 11C0';
ok Uni.new(0xD5FE).NFD.list ~~ (0x1112, 0x1166, 0x11C1,), 'D5FE -> 1112 1166 11C1';
ok Uni.new(0xD5FF).NFD.list ~~ (0x1112, 0x1166, 0x11C2,), 'D5FF -> 1112 1166 11C2';
ok Uni.new(0xD600).NFD.list ~~ (0x1112, 0x1167,), 'D600 -> 1112 1167';
ok Uni.new(0xD601).NFD.list ~~ (0x1112, 0x1167, 0x11A8,), 'D601 -> 1112 1167 11A8';
ok Uni.new(0xD602).NFD.list ~~ (0x1112, 0x1167, 0x11A9,), 'D602 -> 1112 1167 11A9';
ok Uni.new(0xD603).NFD.list ~~ (0x1112, 0x1167, 0x11AA,), 'D603 -> 1112 1167 11AA';
ok Uni.new(0xD604).NFD.list ~~ (0x1112, 0x1167, 0x11AB,), 'D604 -> 1112 1167 11AB';
ok Uni.new(0xD605).NFD.list ~~ (0x1112, 0x1167, 0x11AC,), 'D605 -> 1112 1167 11AC';
ok Uni.new(0xD606).NFD.list ~~ (0x1112, 0x1167, 0x11AD,), 'D606 -> 1112 1167 11AD';
ok Uni.new(0xD607).NFD.list ~~ (0x1112, 0x1167, 0x11AE,), 'D607 -> 1112 1167 11AE';
ok Uni.new(0xD608).NFD.list ~~ (0x1112, 0x1167, 0x11AF,), 'D608 -> 1112 1167 11AF';
ok Uni.new(0xD609).NFD.list ~~ (0x1112, 0x1167, 0x11B0,), 'D609 -> 1112 1167 11B0';
ok Uni.new(0xD60A).NFD.list ~~ (0x1112, 0x1167, 0x11B1,), 'D60A -> 1112 1167 11B1';
ok Uni.new(0xD60B).NFD.list ~~ (0x1112, 0x1167, 0x11B2,), 'D60B -> 1112 1167 11B2';
ok Uni.new(0xD60C).NFD.list ~~ (0x1112, 0x1167, 0x11B3,), 'D60C -> 1112 1167 11B3';
ok Uni.new(0xD60D).NFD.list ~~ (0x1112, 0x1167, 0x11B4,), 'D60D -> 1112 1167 11B4';
ok Uni.new(0xD60E).NFD.list ~~ (0x1112, 0x1167, 0x11B5,), 'D60E -> 1112 1167 11B5';
ok Uni.new(0xD60F).NFD.list ~~ (0x1112, 0x1167, 0x11B6,), 'D60F -> 1112 1167 11B6';
ok Uni.new(0xD610).NFD.list ~~ (0x1112, 0x1167, 0x11B7,), 'D610 -> 1112 1167 11B7';
ok Uni.new(0xD611).NFD.list ~~ (0x1112, 0x1167, 0x11B8,), 'D611 -> 1112 1167 11B8';
ok Uni.new(0xD612).NFD.list ~~ (0x1112, 0x1167, 0x11B9,), 'D612 -> 1112 1167 11B9';
ok Uni.new(0xD613).NFD.list ~~ (0x1112, 0x1167, 0x11BA,), 'D613 -> 1112 1167 11BA';
ok Uni.new(0xD614).NFD.list ~~ (0x1112, 0x1167, 0x11BB,), 'D614 -> 1112 1167 11BB';
ok Uni.new(0xD615).NFD.list ~~ (0x1112, 0x1167, 0x11BC,), 'D615 -> 1112 1167 11BC';
ok Uni.new(0xD616).NFD.list ~~ (0x1112, 0x1167, 0x11BD,), 'D616 -> 1112 1167 11BD';
ok Uni.new(0xD617).NFD.list ~~ (0x1112, 0x1167, 0x11BE,), 'D617 -> 1112 1167 11BE';
ok Uni.new(0xD618).NFD.list ~~ (0x1112, 0x1167, 0x11BF,), 'D618 -> 1112 1167 11BF';
ok Uni.new(0xD619).NFD.list ~~ (0x1112, 0x1167, 0x11C0,), 'D619 -> 1112 1167 11C0';
ok Uni.new(0xD61A).NFD.list ~~ (0x1112, 0x1167, 0x11C1,), 'D61A -> 1112 1167 11C1';
ok Uni.new(0xD61B).NFD.list ~~ (0x1112, 0x1167, 0x11C2,), 'D61B -> 1112 1167 11C2';
ok Uni.new(0xD61C).NFD.list ~~ (0x1112, 0x1168,), 'D61C -> 1112 1168';
ok Uni.new(0xD61D).NFD.list ~~ (0x1112, 0x1168, 0x11A8,), 'D61D -> 1112 1168 11A8';
ok Uni.new(0xD61E).NFD.list ~~ (0x1112, 0x1168, 0x11A9,), 'D61E -> 1112 1168 11A9';
ok Uni.new(0xD61F).NFD.list ~~ (0x1112, 0x1168, 0x11AA,), 'D61F -> 1112 1168 11AA';
ok Uni.new(0xD620).NFD.list ~~ (0x1112, 0x1168, 0x11AB,), 'D620 -> 1112 1168 11AB';
ok Uni.new(0xD621).NFD.list ~~ (0x1112, 0x1168, 0x11AC,), 'D621 -> 1112 1168 11AC';
ok Uni.new(0xD622).NFD.list ~~ (0x1112, 0x1168, 0x11AD,), 'D622 -> 1112 1168 11AD';
ok Uni.new(0xD623).NFD.list ~~ (0x1112, 0x1168, 0x11AE,), 'D623 -> 1112 1168 11AE';
ok Uni.new(0xD624).NFD.list ~~ (0x1112, 0x1168, 0x11AF,), 'D624 -> 1112 1168 11AF';
ok Uni.new(0xD625).NFD.list ~~ (0x1112, 0x1168, 0x11B0,), 'D625 -> 1112 1168 11B0';
ok Uni.new(0xD626).NFD.list ~~ (0x1112, 0x1168, 0x11B1,), 'D626 -> 1112 1168 11B1';
ok Uni.new(0xD627).NFD.list ~~ (0x1112, 0x1168, 0x11B2,), 'D627 -> 1112 1168 11B2';
ok Uni.new(0xD628).NFD.list ~~ (0x1112, 0x1168, 0x11B3,), 'D628 -> 1112 1168 11B3';
ok Uni.new(0xD629).NFD.list ~~ (0x1112, 0x1168, 0x11B4,), 'D629 -> 1112 1168 11B4';
ok Uni.new(0xD62A).NFD.list ~~ (0x1112, 0x1168, 0x11B5,), 'D62A -> 1112 1168 11B5';
ok Uni.new(0xD62B).NFD.list ~~ (0x1112, 0x1168, 0x11B6,), 'D62B -> 1112 1168 11B6';
ok Uni.new(0xD62C).NFD.list ~~ (0x1112, 0x1168, 0x11B7,), 'D62C -> 1112 1168 11B7';
ok Uni.new(0xD62D).NFD.list ~~ (0x1112, 0x1168, 0x11B8,), 'D62D -> 1112 1168 11B8';
ok Uni.new(0xD62E).NFD.list ~~ (0x1112, 0x1168, 0x11B9,), 'D62E -> 1112 1168 11B9';
ok Uni.new(0xD62F).NFD.list ~~ (0x1112, 0x1168, 0x11BA,), 'D62F -> 1112 1168 11BA';
ok Uni.new(0xD630).NFD.list ~~ (0x1112, 0x1168, 0x11BB,), 'D630 -> 1112 1168 11BB';
ok Uni.new(0xD631).NFD.list ~~ (0x1112, 0x1168, 0x11BC,), 'D631 -> 1112 1168 11BC';
ok Uni.new(0xD632).NFD.list ~~ (0x1112, 0x1168, 0x11BD,), 'D632 -> 1112 1168 11BD';
ok Uni.new(0xD633).NFD.list ~~ (0x1112, 0x1168, 0x11BE,), 'D633 -> 1112 1168 11BE';
ok Uni.new(0xD634).NFD.list ~~ (0x1112, 0x1168, 0x11BF,), 'D634 -> 1112 1168 11BF';
ok Uni.new(0xD635).NFD.list ~~ (0x1112, 0x1168, 0x11C0,), 'D635 -> 1112 1168 11C0';
ok Uni.new(0xD636).NFD.list ~~ (0x1112, 0x1168, 0x11C1,), 'D636 -> 1112 1168 11C1';
ok Uni.new(0xD637).NFD.list ~~ (0x1112, 0x1168, 0x11C2,), 'D637 -> 1112 1168 11C2';
ok Uni.new(0xD638).NFD.list ~~ (0x1112, 0x1169,), 'D638 -> 1112 1169';
ok Uni.new(0xD639).NFD.list ~~ (0x1112, 0x1169, 0x11A8,), 'D639 -> 1112 1169 11A8';
ok Uni.new(0xD63A).NFD.list ~~ (0x1112, 0x1169, 0x11A9,), 'D63A -> 1112 1169 11A9';
ok Uni.new(0xD63B).NFD.list ~~ (0x1112, 0x1169, 0x11AA,), 'D63B -> 1112 1169 11AA';
ok Uni.new(0xD63C).NFD.list ~~ (0x1112, 0x1169, 0x11AB,), 'D63C -> 1112 1169 11AB';
ok Uni.new(0xD63D).NFD.list ~~ (0x1112, 0x1169, 0x11AC,), 'D63D -> 1112 1169 11AC';
ok Uni.new(0xD63E).NFD.list ~~ (0x1112, 0x1169, 0x11AD,), 'D63E -> 1112 1169 11AD';
ok Uni.new(0xD63F).NFD.list ~~ (0x1112, 0x1169, 0x11AE,), 'D63F -> 1112 1169 11AE';
ok Uni.new(0xD640).NFD.list ~~ (0x1112, 0x1169, 0x11AF,), 'D640 -> 1112 1169 11AF';
ok Uni.new(0xD641).NFD.list ~~ (0x1112, 0x1169, 0x11B0,), 'D641 -> 1112 1169 11B0';
ok Uni.new(0xD642).NFD.list ~~ (0x1112, 0x1169, 0x11B1,), 'D642 -> 1112 1169 11B1';
ok Uni.new(0xD643).NFD.list ~~ (0x1112, 0x1169, 0x11B2,), 'D643 -> 1112 1169 11B2';
ok Uni.new(0xD644).NFD.list ~~ (0x1112, 0x1169, 0x11B3,), 'D644 -> 1112 1169 11B3';
ok Uni.new(0xD645).NFD.list ~~ (0x1112, 0x1169, 0x11B4,), 'D645 -> 1112 1169 11B4';
ok Uni.new(0xD646).NFD.list ~~ (0x1112, 0x1169, 0x11B5,), 'D646 -> 1112 1169 11B5';
ok Uni.new(0xD647).NFD.list ~~ (0x1112, 0x1169, 0x11B6,), 'D647 -> 1112 1169 11B6';
ok Uni.new(0xD648).NFD.list ~~ (0x1112, 0x1169, 0x11B7,), 'D648 -> 1112 1169 11B7';
ok Uni.new(0xD649).NFD.list ~~ (0x1112, 0x1169, 0x11B8,), 'D649 -> 1112 1169 11B8';
ok Uni.new(0xD64A).NFD.list ~~ (0x1112, 0x1169, 0x11B9,), 'D64A -> 1112 1169 11B9';
ok Uni.new(0xD64B).NFD.list ~~ (0x1112, 0x1169, 0x11BA,), 'D64B -> 1112 1169 11BA';
ok Uni.new(0xD64C).NFD.list ~~ (0x1112, 0x1169, 0x11BB,), 'D64C -> 1112 1169 11BB';
ok Uni.new(0xD64D).NFD.list ~~ (0x1112, 0x1169, 0x11BC,), 'D64D -> 1112 1169 11BC';
ok Uni.new(0xD64E).NFD.list ~~ (0x1112, 0x1169, 0x11BD,), 'D64E -> 1112 1169 11BD';
ok Uni.new(0xD64F).NFD.list ~~ (0x1112, 0x1169, 0x11BE,), 'D64F -> 1112 1169 11BE';
ok Uni.new(0xD650).NFD.list ~~ (0x1112, 0x1169, 0x11BF,), 'D650 -> 1112 1169 11BF';
ok Uni.new(0xD651).NFD.list ~~ (0x1112, 0x1169, 0x11C0,), 'D651 -> 1112 1169 11C0';
ok Uni.new(0xD652).NFD.list ~~ (0x1112, 0x1169, 0x11C1,), 'D652 -> 1112 1169 11C1';
ok Uni.new(0xD653).NFD.list ~~ (0x1112, 0x1169, 0x11C2,), 'D653 -> 1112 1169 11C2';
ok Uni.new(0xD654).NFD.list ~~ (0x1112, 0x116A,), 'D654 -> 1112 116A';
ok Uni.new(0xD655).NFD.list ~~ (0x1112, 0x116A, 0x11A8,), 'D655 -> 1112 116A 11A8';
ok Uni.new(0xD656).NFD.list ~~ (0x1112, 0x116A, 0x11A9,), 'D656 -> 1112 116A 11A9';
ok Uni.new(0xD657).NFD.list ~~ (0x1112, 0x116A, 0x11AA,), 'D657 -> 1112 116A 11AA';
ok Uni.new(0xD658).NFD.list ~~ (0x1112, 0x116A, 0x11AB,), 'D658 -> 1112 116A 11AB';
ok Uni.new(0xD659).NFD.list ~~ (0x1112, 0x116A, 0x11AC,), 'D659 -> 1112 116A 11AC';
ok Uni.new(0xD65A).NFD.list ~~ (0x1112, 0x116A, 0x11AD,), 'D65A -> 1112 116A 11AD';
ok Uni.new(0xD65B).NFD.list ~~ (0x1112, 0x116A, 0x11AE,), 'D65B -> 1112 116A 11AE';
ok Uni.new(0xD65C).NFD.list ~~ (0x1112, 0x116A, 0x11AF,), 'D65C -> 1112 116A 11AF';
ok Uni.new(0xD65D).NFD.list ~~ (0x1112, 0x116A, 0x11B0,), 'D65D -> 1112 116A 11B0';
ok Uni.new(0xD65E).NFD.list ~~ (0x1112, 0x116A, 0x11B1,), 'D65E -> 1112 116A 11B1';
ok Uni.new(0xD65F).NFD.list ~~ (0x1112, 0x116A, 0x11B2,), 'D65F -> 1112 116A 11B2';
ok Uni.new(0xD660).NFD.list ~~ (0x1112, 0x116A, 0x11B3,), 'D660 -> 1112 116A 11B3';
ok Uni.new(0xD661).NFD.list ~~ (0x1112, 0x116A, 0x11B4,), 'D661 -> 1112 116A 11B4';
ok Uni.new(0xD662).NFD.list ~~ (0x1112, 0x116A, 0x11B5,), 'D662 -> 1112 116A 11B5';
ok Uni.new(0xD663).NFD.list ~~ (0x1112, 0x116A, 0x11B6,), 'D663 -> 1112 116A 11B6';
ok Uni.new(0xD664).NFD.list ~~ (0x1112, 0x116A, 0x11B7,), 'D664 -> 1112 116A 11B7';
ok Uni.new(0xD665).NFD.list ~~ (0x1112, 0x116A, 0x11B8,), 'D665 -> 1112 116A 11B8';
ok Uni.new(0xD666).NFD.list ~~ (0x1112, 0x116A, 0x11B9,), 'D666 -> 1112 116A 11B9';
ok Uni.new(0xD667).NFD.list ~~ (0x1112, 0x116A, 0x11BA,), 'D667 -> 1112 116A 11BA';
ok Uni.new(0xD668).NFD.list ~~ (0x1112, 0x116A, 0x11BB,), 'D668 -> 1112 116A 11BB';
ok Uni.new(0xD669).NFD.list ~~ (0x1112, 0x116A, 0x11BC,), 'D669 -> 1112 116A 11BC';
ok Uni.new(0xD66A).NFD.list ~~ (0x1112, 0x116A, 0x11BD,), 'D66A -> 1112 116A 11BD';
ok Uni.new(0xD66B).NFD.list ~~ (0x1112, 0x116A, 0x11BE,), 'D66B -> 1112 116A 11BE';
ok Uni.new(0xD66C).NFD.list ~~ (0x1112, 0x116A, 0x11BF,), 'D66C -> 1112 116A 11BF';
ok Uni.new(0xD66D).NFD.list ~~ (0x1112, 0x116A, 0x11C0,), 'D66D -> 1112 116A 11C0';
ok Uni.new(0xD66E).NFD.list ~~ (0x1112, 0x116A, 0x11C1,), 'D66E -> 1112 116A 11C1';
ok Uni.new(0xD66F).NFD.list ~~ (0x1112, 0x116A, 0x11C2,), 'D66F -> 1112 116A 11C2';
ok Uni.new(0xD670).NFD.list ~~ (0x1112, 0x116B,), 'D670 -> 1112 116B';
ok Uni.new(0xD671).NFD.list ~~ (0x1112, 0x116B, 0x11A8,), 'D671 -> 1112 116B 11A8';
ok Uni.new(0xD672).NFD.list ~~ (0x1112, 0x116B, 0x11A9,), 'D672 -> 1112 116B 11A9';
ok Uni.new(0xD673).NFD.list ~~ (0x1112, 0x116B, 0x11AA,), 'D673 -> 1112 116B 11AA';
ok Uni.new(0xD674).NFD.list ~~ (0x1112, 0x116B, 0x11AB,), 'D674 -> 1112 116B 11AB';
ok Uni.new(0xD675).NFD.list ~~ (0x1112, 0x116B, 0x11AC,), 'D675 -> 1112 116B 11AC';
ok Uni.new(0xD676).NFD.list ~~ (0x1112, 0x116B, 0x11AD,), 'D676 -> 1112 116B 11AD';
ok Uni.new(0xD677).NFD.list ~~ (0x1112, 0x116B, 0x11AE,), 'D677 -> 1112 116B 11AE';
ok Uni.new(0xD678).NFD.list ~~ (0x1112, 0x116B, 0x11AF,), 'D678 -> 1112 116B 11AF';
ok Uni.new(0xD679).NFD.list ~~ (0x1112, 0x116B, 0x11B0,), 'D679 -> 1112 116B 11B0';
ok Uni.new(0xD67A).NFD.list ~~ (0x1112, 0x116B, 0x11B1,), 'D67A -> 1112 116B 11B1';
ok Uni.new(0xD67B).NFD.list ~~ (0x1112, 0x116B, 0x11B2,), 'D67B -> 1112 116B 11B2';
ok Uni.new(0xD67C).NFD.list ~~ (0x1112, 0x116B, 0x11B3,), 'D67C -> 1112 116B 11B3';
ok Uni.new(0xD67D).NFD.list ~~ (0x1112, 0x116B, 0x11B4,), 'D67D -> 1112 116B 11B4';
ok Uni.new(0xD67E).NFD.list ~~ (0x1112, 0x116B, 0x11B5,), 'D67E -> 1112 116B 11B5';
ok Uni.new(0xD67F).NFD.list ~~ (0x1112, 0x116B, 0x11B6,), 'D67F -> 1112 116B 11B6';
ok Uni.new(0xD680).NFD.list ~~ (0x1112, 0x116B, 0x11B7,), 'D680 -> 1112 116B 11B7';
ok Uni.new(0xD681).NFD.list ~~ (0x1112, 0x116B, 0x11B8,), 'D681 -> 1112 116B 11B8';
ok Uni.new(0xD682).NFD.list ~~ (0x1112, 0x116B, 0x11B9,), 'D682 -> 1112 116B 11B9';
ok Uni.new(0xD683).NFD.list ~~ (0x1112, 0x116B, 0x11BA,), 'D683 -> 1112 116B 11BA';
ok Uni.new(0xD684).NFD.list ~~ (0x1112, 0x116B, 0x11BB,), 'D684 -> 1112 116B 11BB';
ok Uni.new(0xD685).NFD.list ~~ (0x1112, 0x116B, 0x11BC,), 'D685 -> 1112 116B 11BC';
ok Uni.new(0xD686).NFD.list ~~ (0x1112, 0x116B, 0x11BD,), 'D686 -> 1112 116B 11BD';
ok Uni.new(0xD687).NFD.list ~~ (0x1112, 0x116B, 0x11BE,), 'D687 -> 1112 116B 11BE';
ok Uni.new(0xD688).NFD.list ~~ (0x1112, 0x116B, 0x11BF,), 'D688 -> 1112 116B 11BF';
ok Uni.new(0xD689).NFD.list ~~ (0x1112, 0x116B, 0x11C0,), 'D689 -> 1112 116B 11C0';
ok Uni.new(0xD68A).NFD.list ~~ (0x1112, 0x116B, 0x11C1,), 'D68A -> 1112 116B 11C1';
ok Uni.new(0xD68B).NFD.list ~~ (0x1112, 0x116B, 0x11C2,), 'D68B -> 1112 116B 11C2';
ok Uni.new(0xD68C).NFD.list ~~ (0x1112, 0x116C,), 'D68C -> 1112 116C';
ok Uni.new(0xD68D).NFD.list ~~ (0x1112, 0x116C, 0x11A8,), 'D68D -> 1112 116C 11A8';
ok Uni.new(0xD68E).NFD.list ~~ (0x1112, 0x116C, 0x11A9,), 'D68E -> 1112 116C 11A9';
ok Uni.new(0xD68F).NFD.list ~~ (0x1112, 0x116C, 0x11AA,), 'D68F -> 1112 116C 11AA';
ok Uni.new(0xD690).NFD.list ~~ (0x1112, 0x116C, 0x11AB,), 'D690 -> 1112 116C 11AB';
ok Uni.new(0xD691).NFD.list ~~ (0x1112, 0x116C, 0x11AC,), 'D691 -> 1112 116C 11AC';
ok Uni.new(0xD692).NFD.list ~~ (0x1112, 0x116C, 0x11AD,), 'D692 -> 1112 116C 11AD';
ok Uni.new(0xD693).NFD.list ~~ (0x1112, 0x116C, 0x11AE,), 'D693 -> 1112 116C 11AE';
ok Uni.new(0xD694).NFD.list ~~ (0x1112, 0x116C, 0x11AF,), 'D694 -> 1112 116C 11AF';
ok Uni.new(0xD695).NFD.list ~~ (0x1112, 0x116C, 0x11B0,), 'D695 -> 1112 116C 11B0';
ok Uni.new(0xD696).NFD.list ~~ (0x1112, 0x116C, 0x11B1,), 'D696 -> 1112 116C 11B1';
ok Uni.new(0xD697).NFD.list ~~ (0x1112, 0x116C, 0x11B2,), 'D697 -> 1112 116C 11B2';
ok Uni.new(0xD698).NFD.list ~~ (0x1112, 0x116C, 0x11B3,), 'D698 -> 1112 116C 11B3';
ok Uni.new(0xD699).NFD.list ~~ (0x1112, 0x116C, 0x11B4,), 'D699 -> 1112 116C 11B4';
ok Uni.new(0xD69A).NFD.list ~~ (0x1112, 0x116C, 0x11B5,), 'D69A -> 1112 116C 11B5';
ok Uni.new(0xD69B).NFD.list ~~ (0x1112, 0x116C, 0x11B6,), 'D69B -> 1112 116C 11B6';
ok Uni.new(0xD69C).NFD.list ~~ (0x1112, 0x116C, 0x11B7,), 'D69C -> 1112 116C 11B7';
ok Uni.new(0xD69D).NFD.list ~~ (0x1112, 0x116C, 0x11B8,), 'D69D -> 1112 116C 11B8';
ok Uni.new(0xD69E).NFD.list ~~ (0x1112, 0x116C, 0x11B9,), 'D69E -> 1112 116C 11B9';
ok Uni.new(0xD69F).NFD.list ~~ (0x1112, 0x116C, 0x11BA,), 'D69F -> 1112 116C 11BA';
ok Uni.new(0xD6A0).NFD.list ~~ (0x1112, 0x116C, 0x11BB,), 'D6A0 -> 1112 116C 11BB';
ok Uni.new(0xD6A1).NFD.list ~~ (0x1112, 0x116C, 0x11BC,), 'D6A1 -> 1112 116C 11BC';
ok Uni.new(0xD6A2).NFD.list ~~ (0x1112, 0x116C, 0x11BD,), 'D6A2 -> 1112 116C 11BD';
ok Uni.new(0xD6A3).NFD.list ~~ (0x1112, 0x116C, 0x11BE,), 'D6A3 -> 1112 116C 11BE';
ok Uni.new(0xD6A4).NFD.list ~~ (0x1112, 0x116C, 0x11BF,), 'D6A4 -> 1112 116C 11BF';
ok Uni.new(0xD6A5).NFD.list ~~ (0x1112, 0x116C, 0x11C0,), 'D6A5 -> 1112 116C 11C0';
ok Uni.new(0xD6A6).NFD.list ~~ (0x1112, 0x116C, 0x11C1,), 'D6A6 -> 1112 116C 11C1';
ok Uni.new(0xD6A7).NFD.list ~~ (0x1112, 0x116C, 0x11C2,), 'D6A7 -> 1112 116C 11C2';
ok Uni.new(0xD6A8).NFD.list ~~ (0x1112, 0x116D,), 'D6A8 -> 1112 116D';
ok Uni.new(0xD6A9).NFD.list ~~ (0x1112, 0x116D, 0x11A8,), 'D6A9 -> 1112 116D 11A8';
ok Uni.new(0xD6AA).NFD.list ~~ (0x1112, 0x116D, 0x11A9,), 'D6AA -> 1112 116D 11A9';
ok Uni.new(0xD6AB).NFD.list ~~ (0x1112, 0x116D, 0x11AA,), 'D6AB -> 1112 116D 11AA';
ok Uni.new(0xD6AC).NFD.list ~~ (0x1112, 0x116D, 0x11AB,), 'D6AC -> 1112 116D 11AB';
ok Uni.new(0xD6AD).NFD.list ~~ (0x1112, 0x116D, 0x11AC,), 'D6AD -> 1112 116D 11AC';
ok Uni.new(0xD6AE).NFD.list ~~ (0x1112, 0x116D, 0x11AD,), 'D6AE -> 1112 116D 11AD';
ok Uni.new(0xD6AF).NFD.list ~~ (0x1112, 0x116D, 0x11AE,), 'D6AF -> 1112 116D 11AE';
ok Uni.new(0xD6B0).NFD.list ~~ (0x1112, 0x116D, 0x11AF,), 'D6B0 -> 1112 116D 11AF';
ok Uni.new(0xD6B1).NFD.list ~~ (0x1112, 0x116D, 0x11B0,), 'D6B1 -> 1112 116D 11B0';
ok Uni.new(0xD6B2).NFD.list ~~ (0x1112, 0x116D, 0x11B1,), 'D6B2 -> 1112 116D 11B1';
ok Uni.new(0xD6B3).NFD.list ~~ (0x1112, 0x116D, 0x11B2,), 'D6B3 -> 1112 116D 11B2';
ok Uni.new(0xD6B4).NFD.list ~~ (0x1112, 0x116D, 0x11B3,), 'D6B4 -> 1112 116D 11B3';
ok Uni.new(0xD6B5).NFD.list ~~ (0x1112, 0x116D, 0x11B4,), 'D6B5 -> 1112 116D 11B4';
ok Uni.new(0xD6B6).NFD.list ~~ (0x1112, 0x116D, 0x11B5,), 'D6B6 -> 1112 116D 11B5';
ok Uni.new(0xD6B7).NFD.list ~~ (0x1112, 0x116D, 0x11B6,), 'D6B7 -> 1112 116D 11B6';
ok Uni.new(0xD6B8).NFD.list ~~ (0x1112, 0x116D, 0x11B7,), 'D6B8 -> 1112 116D 11B7';
ok Uni.new(0xD6B9).NFD.list ~~ (0x1112, 0x116D, 0x11B8,), 'D6B9 -> 1112 116D 11B8';
ok Uni.new(0xD6BA).NFD.list ~~ (0x1112, 0x116D, 0x11B9,), 'D6BA -> 1112 116D 11B9';
ok Uni.new(0xD6BB).NFD.list ~~ (0x1112, 0x116D, 0x11BA,), 'D6BB -> 1112 116D 11BA';
ok Uni.new(0xD6BC).NFD.list ~~ (0x1112, 0x116D, 0x11BB,), 'D6BC -> 1112 116D 11BB';
ok Uni.new(0xD6BD).NFD.list ~~ (0x1112, 0x116D, 0x11BC,), 'D6BD -> 1112 116D 11BC';
ok Uni.new(0xD6BE).NFD.list ~~ (0x1112, 0x116D, 0x11BD,), 'D6BE -> 1112 116D 11BD';
ok Uni.new(0xD6BF).NFD.list ~~ (0x1112, 0x116D, 0x11BE,), 'D6BF -> 1112 116D 11BE';
ok Uni.new(0xD6C0).NFD.list ~~ (0x1112, 0x116D, 0x11BF,), 'D6C0 -> 1112 116D 11BF';
ok Uni.new(0xD6C1).NFD.list ~~ (0x1112, 0x116D, 0x11C0,), 'D6C1 -> 1112 116D 11C0';
ok Uni.new(0xD6C2).NFD.list ~~ (0x1112, 0x116D, 0x11C1,), 'D6C2 -> 1112 116D 11C1';
ok Uni.new(0xD6C3).NFD.list ~~ (0x1112, 0x116D, 0x11C2,), 'D6C3 -> 1112 116D 11C2';
ok Uni.new(0xD6C4).NFD.list ~~ (0x1112, 0x116E,), 'D6C4 -> 1112 116E';
ok Uni.new(0xD6C5).NFD.list ~~ (0x1112, 0x116E, 0x11A8,), 'D6C5 -> 1112 116E 11A8';
ok Uni.new(0xD6C6).NFD.list ~~ (0x1112, 0x116E, 0x11A9,), 'D6C6 -> 1112 116E 11A9';
ok Uni.new(0xD6C7).NFD.list ~~ (0x1112, 0x116E, 0x11AA,), 'D6C7 -> 1112 116E 11AA';
ok Uni.new(0xD6C8).NFD.list ~~ (0x1112, 0x116E, 0x11AB,), 'D6C8 -> 1112 116E 11AB';
ok Uni.new(0xD6C9).NFD.list ~~ (0x1112, 0x116E, 0x11AC,), 'D6C9 -> 1112 116E 11AC';
ok Uni.new(0xD6CA).NFD.list ~~ (0x1112, 0x116E, 0x11AD,), 'D6CA -> 1112 116E 11AD';
ok Uni.new(0xD6CB).NFD.list ~~ (0x1112, 0x116E, 0x11AE,), 'D6CB -> 1112 116E 11AE';
ok Uni.new(0xD6CC).NFD.list ~~ (0x1112, 0x116E, 0x11AF,), 'D6CC -> 1112 116E 11AF';
ok Uni.new(0xD6CD).NFD.list ~~ (0x1112, 0x116E, 0x11B0,), 'D6CD -> 1112 116E 11B0';
ok Uni.new(0xD6CE).NFD.list ~~ (0x1112, 0x116E, 0x11B1,), 'D6CE -> 1112 116E 11B1';
ok Uni.new(0xD6CF).NFD.list ~~ (0x1112, 0x116E, 0x11B2,), 'D6CF -> 1112 116E 11B2';
ok Uni.new(0xD6D0).NFD.list ~~ (0x1112, 0x116E, 0x11B3,), 'D6D0 -> 1112 116E 11B3';
ok Uni.new(0xD6D1).NFD.list ~~ (0x1112, 0x116E, 0x11B4,), 'D6D1 -> 1112 116E 11B4';
ok Uni.new(0xD6D2).NFD.list ~~ (0x1112, 0x116E, 0x11B5,), 'D6D2 -> 1112 116E 11B5';
ok Uni.new(0xD6D3).NFD.list ~~ (0x1112, 0x116E, 0x11B6,), 'D6D3 -> 1112 116E 11B6';
ok Uni.new(0xD6D4).NFD.list ~~ (0x1112, 0x116E, 0x11B7,), 'D6D4 -> 1112 116E 11B7';
ok Uni.new(0xD6D5).NFD.list ~~ (0x1112, 0x116E, 0x11B8,), 'D6D5 -> 1112 116E 11B8';
ok Uni.new(0xD6D6).NFD.list ~~ (0x1112, 0x116E, 0x11B9,), 'D6D6 -> 1112 116E 11B9';
ok Uni.new(0xD6D7).NFD.list ~~ (0x1112, 0x116E, 0x11BA,), 'D6D7 -> 1112 116E 11BA';
ok Uni.new(0xD6D8).NFD.list ~~ (0x1112, 0x116E, 0x11BB,), 'D6D8 -> 1112 116E 11BB';
ok Uni.new(0xD6D9).NFD.list ~~ (0x1112, 0x116E, 0x11BC,), 'D6D9 -> 1112 116E 11BC';
ok Uni.new(0xD6DA).NFD.list ~~ (0x1112, 0x116E, 0x11BD,), 'D6DA -> 1112 116E 11BD';
ok Uni.new(0xD6DB).NFD.list ~~ (0x1112, 0x116E, 0x11BE,), 'D6DB -> 1112 116E 11BE';
ok Uni.new(0xD6DC).NFD.list ~~ (0x1112, 0x116E, 0x11BF,), 'D6DC -> 1112 116E 11BF';
ok Uni.new(0xD6DD).NFD.list ~~ (0x1112, 0x116E, 0x11C0,), 'D6DD -> 1112 116E 11C0';
ok Uni.new(0xD6DE).NFD.list ~~ (0x1112, 0x116E, 0x11C1,), 'D6DE -> 1112 116E 11C1';
ok Uni.new(0xD6DF).NFD.list ~~ (0x1112, 0x116E, 0x11C2,), 'D6DF -> 1112 116E 11C2';
ok Uni.new(0xD6E0).NFD.list ~~ (0x1112, 0x116F,), 'D6E0 -> 1112 116F';
ok Uni.new(0xD6E1).NFD.list ~~ (0x1112, 0x116F, 0x11A8,), 'D6E1 -> 1112 116F 11A8';
ok Uni.new(0xD6E2).NFD.list ~~ (0x1112, 0x116F, 0x11A9,), 'D6E2 -> 1112 116F 11A9';
ok Uni.new(0xD6E3).NFD.list ~~ (0x1112, 0x116F, 0x11AA,), 'D6E3 -> 1112 116F 11AA';
ok Uni.new(0xD6E4).NFD.list ~~ (0x1112, 0x116F, 0x11AB,), 'D6E4 -> 1112 116F 11AB';
ok Uni.new(0xD6E5).NFD.list ~~ (0x1112, 0x116F, 0x11AC,), 'D6E5 -> 1112 116F 11AC';
ok Uni.new(0xD6E6).NFD.list ~~ (0x1112, 0x116F, 0x11AD,), 'D6E6 -> 1112 116F 11AD';
ok Uni.new(0xD6E7).NFD.list ~~ (0x1112, 0x116F, 0x11AE,), 'D6E7 -> 1112 116F 11AE';
ok Uni.new(0xD6E8).NFD.list ~~ (0x1112, 0x116F, 0x11AF,), 'D6E8 -> 1112 116F 11AF';
ok Uni.new(0xD6E9).NFD.list ~~ (0x1112, 0x116F, 0x11B0,), 'D6E9 -> 1112 116F 11B0';
ok Uni.new(0xD6EA).NFD.list ~~ (0x1112, 0x116F, 0x11B1,), 'D6EA -> 1112 116F 11B1';
ok Uni.new(0xD6EB).NFD.list ~~ (0x1112, 0x116F, 0x11B2,), 'D6EB -> 1112 116F 11B2';
ok Uni.new(0xD6EC).NFD.list ~~ (0x1112, 0x116F, 0x11B3,), 'D6EC -> 1112 116F 11B3';
ok Uni.new(0xD6ED).NFD.list ~~ (0x1112, 0x116F, 0x11B4,), 'D6ED -> 1112 116F 11B4';
ok Uni.new(0xD6EE).NFD.list ~~ (0x1112, 0x116F, 0x11B5,), 'D6EE -> 1112 116F 11B5';
ok Uni.new(0xD6EF).NFD.list ~~ (0x1112, 0x116F, 0x11B6,), 'D6EF -> 1112 116F 11B6';
ok Uni.new(0xD6F0).NFD.list ~~ (0x1112, 0x116F, 0x11B7,), 'D6F0 -> 1112 116F 11B7';
ok Uni.new(0xD6F1).NFD.list ~~ (0x1112, 0x116F, 0x11B8,), 'D6F1 -> 1112 116F 11B8';
ok Uni.new(0xD6F2).NFD.list ~~ (0x1112, 0x116F, 0x11B9,), 'D6F2 -> 1112 116F 11B9';
ok Uni.new(0xD6F3).NFD.list ~~ (0x1112, 0x116F, 0x11BA,), 'D6F3 -> 1112 116F 11BA';
ok Uni.new(0xD6F4).NFD.list ~~ (0x1112, 0x116F, 0x11BB,), 'D6F4 -> 1112 116F 11BB';
ok Uni.new(0xD6F5).NFD.list ~~ (0x1112, 0x116F, 0x11BC,), 'D6F5 -> 1112 116F 11BC';
ok Uni.new(0xD6F6).NFD.list ~~ (0x1112, 0x116F, 0x11BD,), 'D6F6 -> 1112 116F 11BD';
ok Uni.new(0xD6F7).NFD.list ~~ (0x1112, 0x116F, 0x11BE,), 'D6F7 -> 1112 116F 11BE';
ok Uni.new(0xD6F8).NFD.list ~~ (0x1112, 0x116F, 0x11BF,), 'D6F8 -> 1112 116F 11BF';
ok Uni.new(0xD6F9).NFD.list ~~ (0x1112, 0x116F, 0x11C0,), 'D6F9 -> 1112 116F 11C0';
ok Uni.new(0xD6FA).NFD.list ~~ (0x1112, 0x116F, 0x11C1,), 'D6FA -> 1112 116F 11C1';
ok Uni.new(0xD6FB).NFD.list ~~ (0x1112, 0x116F, 0x11C2,), 'D6FB -> 1112 116F 11C2';
ok Uni.new(0xD6FC).NFD.list ~~ (0x1112, 0x1170,), 'D6FC -> 1112 1170';
ok Uni.new(0xD6FD).NFD.list ~~ (0x1112, 0x1170, 0x11A8,), 'D6FD -> 1112 1170 11A8';
ok Uni.new(0xD6FE).NFD.list ~~ (0x1112, 0x1170, 0x11A9,), 'D6FE -> 1112 1170 11A9';
ok Uni.new(0xD6FF).NFD.list ~~ (0x1112, 0x1170, 0x11AA,), 'D6FF -> 1112 1170 11AA';
ok Uni.new(0xD700).NFD.list ~~ (0x1112, 0x1170, 0x11AB,), 'D700 -> 1112 1170 11AB';
ok Uni.new(0xD701).NFD.list ~~ (0x1112, 0x1170, 0x11AC,), 'D701 -> 1112 1170 11AC';
ok Uni.new(0xD702).NFD.list ~~ (0x1112, 0x1170, 0x11AD,), 'D702 -> 1112 1170 11AD';
ok Uni.new(0xD703).NFD.list ~~ (0x1112, 0x1170, 0x11AE,), 'D703 -> 1112 1170 11AE';
ok Uni.new(0xD704).NFD.list ~~ (0x1112, 0x1170, 0x11AF,), 'D704 -> 1112 1170 11AF';
ok Uni.new(0xD705).NFD.list ~~ (0x1112, 0x1170, 0x11B0,), 'D705 -> 1112 1170 11B0';
ok Uni.new(0xD706).NFD.list ~~ (0x1112, 0x1170, 0x11B1,), 'D706 -> 1112 1170 11B1';
ok Uni.new(0xD707).NFD.list ~~ (0x1112, 0x1170, 0x11B2,), 'D707 -> 1112 1170 11B2';
ok Uni.new(0xD708).NFD.list ~~ (0x1112, 0x1170, 0x11B3,), 'D708 -> 1112 1170 11B3';
ok Uni.new(0xD709).NFD.list ~~ (0x1112, 0x1170, 0x11B4,), 'D709 -> 1112 1170 11B4';
ok Uni.new(0xD70A).NFD.list ~~ (0x1112, 0x1170, 0x11B5,), 'D70A -> 1112 1170 11B5';
ok Uni.new(0xD70B).NFD.list ~~ (0x1112, 0x1170, 0x11B6,), 'D70B -> 1112 1170 11B6';
ok Uni.new(0xD70C).NFD.list ~~ (0x1112, 0x1170, 0x11B7,), 'D70C -> 1112 1170 11B7';
ok Uni.new(0xD70D).NFD.list ~~ (0x1112, 0x1170, 0x11B8,), 'D70D -> 1112 1170 11B8';
ok Uni.new(0xD70E).NFD.list ~~ (0x1112, 0x1170, 0x11B9,), 'D70E -> 1112 1170 11B9';
ok Uni.new(0xD70F).NFD.list ~~ (0x1112, 0x1170, 0x11BA,), 'D70F -> 1112 1170 11BA';
ok Uni.new(0xD710).NFD.list ~~ (0x1112, 0x1170, 0x11BB,), 'D710 -> 1112 1170 11BB';
ok Uni.new(0xD711).NFD.list ~~ (0x1112, 0x1170, 0x11BC,), 'D711 -> 1112 1170 11BC';
ok Uni.new(0xD712).NFD.list ~~ (0x1112, 0x1170, 0x11BD,), 'D712 -> 1112 1170 11BD';
ok Uni.new(0xD713).NFD.list ~~ (0x1112, 0x1170, 0x11BE,), 'D713 -> 1112 1170 11BE';
ok Uni.new(0xD714).NFD.list ~~ (0x1112, 0x1170, 0x11BF,), 'D714 -> 1112 1170 11BF';
ok Uni.new(0xD715).NFD.list ~~ (0x1112, 0x1170, 0x11C0,), 'D715 -> 1112 1170 11C0';
ok Uni.new(0xD716).NFD.list ~~ (0x1112, 0x1170, 0x11C1,), 'D716 -> 1112 1170 11C1';
ok Uni.new(0xD717).NFD.list ~~ (0x1112, 0x1170, 0x11C2,), 'D717 -> 1112 1170 11C2';
ok Uni.new(0xD718).NFD.list ~~ (0x1112, 0x1171,), 'D718 -> 1112 1171';
ok Uni.new(0xD719).NFD.list ~~ (0x1112, 0x1171, 0x11A8,), 'D719 -> 1112 1171 11A8';
ok Uni.new(0xD71A).NFD.list ~~ (0x1112, 0x1171, 0x11A9,), 'D71A -> 1112 1171 11A9';
ok Uni.new(0xD71B).NFD.list ~~ (0x1112, 0x1171, 0x11AA,), 'D71B -> 1112 1171 11AA';
ok Uni.new(0xD71C).NFD.list ~~ (0x1112, 0x1171, 0x11AB,), 'D71C -> 1112 1171 11AB';
ok Uni.new(0xD71D).NFD.list ~~ (0x1112, 0x1171, 0x11AC,), 'D71D -> 1112 1171 11AC';
ok Uni.new(0xD71E).NFD.list ~~ (0x1112, 0x1171, 0x11AD,), 'D71E -> 1112 1171 11AD';
ok Uni.new(0xD71F).NFD.list ~~ (0x1112, 0x1171, 0x11AE,), 'D71F -> 1112 1171 11AE';
ok Uni.new(0xD720).NFD.list ~~ (0x1112, 0x1171, 0x11AF,), 'D720 -> 1112 1171 11AF';
ok Uni.new(0xD721).NFD.list ~~ (0x1112, 0x1171, 0x11B0,), 'D721 -> 1112 1171 11B0';
ok Uni.new(0xD722).NFD.list ~~ (0x1112, 0x1171, 0x11B1,), 'D722 -> 1112 1171 11B1';
ok Uni.new(0xD723).NFD.list ~~ (0x1112, 0x1171, 0x11B2,), 'D723 -> 1112 1171 11B2';
ok Uni.new(0xD724).NFD.list ~~ (0x1112, 0x1171, 0x11B3,), 'D724 -> 1112 1171 11B3';
ok Uni.new(0xD725).NFD.list ~~ (0x1112, 0x1171, 0x11B4,), 'D725 -> 1112 1171 11B4';
ok Uni.new(0xD726).NFD.list ~~ (0x1112, 0x1171, 0x11B5,), 'D726 -> 1112 1171 11B5';
ok Uni.new(0xD727).NFD.list ~~ (0x1112, 0x1171, 0x11B6,), 'D727 -> 1112 1171 11B6';
ok Uni.new(0xD728).NFD.list ~~ (0x1112, 0x1171, 0x11B7,), 'D728 -> 1112 1171 11B7';
ok Uni.new(0xD729).NFD.list ~~ (0x1112, 0x1171, 0x11B8,), 'D729 -> 1112 1171 11B8';
ok Uni.new(0xD72A).NFD.list ~~ (0x1112, 0x1171, 0x11B9,), 'D72A -> 1112 1171 11B9';
ok Uni.new(0xD72B).NFD.list ~~ (0x1112, 0x1171, 0x11BA,), 'D72B -> 1112 1171 11BA';
ok Uni.new(0xD72C).NFD.list ~~ (0x1112, 0x1171, 0x11BB,), 'D72C -> 1112 1171 11BB';
ok Uni.new(0xD72D).NFD.list ~~ (0x1112, 0x1171, 0x11BC,), 'D72D -> 1112 1171 11BC';
ok Uni.new(0xD72E).NFD.list ~~ (0x1112, 0x1171, 0x11BD,), 'D72E -> 1112 1171 11BD';
ok Uni.new(0xD72F).NFD.list ~~ (0x1112, 0x1171, 0x11BE,), 'D72F -> 1112 1171 11BE';
ok Uni.new(0xD730).NFD.list ~~ (0x1112, 0x1171, 0x11BF,), 'D730 -> 1112 1171 11BF';
ok Uni.new(0xD731).NFD.list ~~ (0x1112, 0x1171, 0x11C0,), 'D731 -> 1112 1171 11C0';
ok Uni.new(0xD732).NFD.list ~~ (0x1112, 0x1171, 0x11C1,), 'D732 -> 1112 1171 11C1';
ok Uni.new(0xD733).NFD.list ~~ (0x1112, 0x1171, 0x11C2,), 'D733 -> 1112 1171 11C2';
ok Uni.new(0xD734).NFD.list ~~ (0x1112, 0x1172,), 'D734 -> 1112 1172';
ok Uni.new(0xD735).NFD.list ~~ (0x1112, 0x1172, 0x11A8,), 'D735 -> 1112 1172 11A8';
ok Uni.new(0xD736).NFD.list ~~ (0x1112, 0x1172, 0x11A9,), 'D736 -> 1112 1172 11A9';
ok Uni.new(0xD737).NFD.list ~~ (0x1112, 0x1172, 0x11AA,), 'D737 -> 1112 1172 11AA';
ok Uni.new(0xD738).NFD.list ~~ (0x1112, 0x1172, 0x11AB,), 'D738 -> 1112 1172 11AB';
ok Uni.new(0xD739).NFD.list ~~ (0x1112, 0x1172, 0x11AC,), 'D739 -> 1112 1172 11AC';
ok Uni.new(0xD73A).NFD.list ~~ (0x1112, 0x1172, 0x11AD,), 'D73A -> 1112 1172 11AD';
ok Uni.new(0xD73B).NFD.list ~~ (0x1112, 0x1172, 0x11AE,), 'D73B -> 1112 1172 11AE';
ok Uni.new(0xD73C).NFD.list ~~ (0x1112, 0x1172, 0x11AF,), 'D73C -> 1112 1172 11AF';
ok Uni.new(0xD73D).NFD.list ~~ (0x1112, 0x1172, 0x11B0,), 'D73D -> 1112 1172 11B0';
ok Uni.new(0xD73E).NFD.list ~~ (0x1112, 0x1172, 0x11B1,), 'D73E -> 1112 1172 11B1';
ok Uni.new(0xD73F).NFD.list ~~ (0x1112, 0x1172, 0x11B2,), 'D73F -> 1112 1172 11B2';
ok Uni.new(0xD740).NFD.list ~~ (0x1112, 0x1172, 0x11B3,), 'D740 -> 1112 1172 11B3';
ok Uni.new(0xD741).NFD.list ~~ (0x1112, 0x1172, 0x11B4,), 'D741 -> 1112 1172 11B4';
ok Uni.new(0xD742).NFD.list ~~ (0x1112, 0x1172, 0x11B5,), 'D742 -> 1112 1172 11B5';
ok Uni.new(0xD743).NFD.list ~~ (0x1112, 0x1172, 0x11B6,), 'D743 -> 1112 1172 11B6';
ok Uni.new(0xD744).NFD.list ~~ (0x1112, 0x1172, 0x11B7,), 'D744 -> 1112 1172 11B7';
ok Uni.new(0xD745).NFD.list ~~ (0x1112, 0x1172, 0x11B8,), 'D745 -> 1112 1172 11B8';
ok Uni.new(0xD746).NFD.list ~~ (0x1112, 0x1172, 0x11B9,), 'D746 -> 1112 1172 11B9';
ok Uni.new(0xD747).NFD.list ~~ (0x1112, 0x1172, 0x11BA,), 'D747 -> 1112 1172 11BA';
ok Uni.new(0xD748).NFD.list ~~ (0x1112, 0x1172, 0x11BB,), 'D748 -> 1112 1172 11BB';
ok Uni.new(0xD749).NFD.list ~~ (0x1112, 0x1172, 0x11BC,), 'D749 -> 1112 1172 11BC';
ok Uni.new(0xD74A).NFD.list ~~ (0x1112, 0x1172, 0x11BD,), 'D74A -> 1112 1172 11BD';
ok Uni.new(0xD74B).NFD.list ~~ (0x1112, 0x1172, 0x11BE,), 'D74B -> 1112 1172 11BE';
ok Uni.new(0xD74C).NFD.list ~~ (0x1112, 0x1172, 0x11BF,), 'D74C -> 1112 1172 11BF';
ok Uni.new(0xD74D).NFD.list ~~ (0x1112, 0x1172, 0x11C0,), 'D74D -> 1112 1172 11C0';
ok Uni.new(0xD74E).NFD.list ~~ (0x1112, 0x1172, 0x11C1,), 'D74E -> 1112 1172 11C1';
ok Uni.new(0xD74F).NFD.list ~~ (0x1112, 0x1172, 0x11C2,), 'D74F -> 1112 1172 11C2';
ok Uni.new(0xD750).NFD.list ~~ (0x1112, 0x1173,), 'D750 -> 1112 1173';
ok Uni.new(0xD751).NFD.list ~~ (0x1112, 0x1173, 0x11A8,), 'D751 -> 1112 1173 11A8';
ok Uni.new(0xD752).NFD.list ~~ (0x1112, 0x1173, 0x11A9,), 'D752 -> 1112 1173 11A9';
ok Uni.new(0xD753).NFD.list ~~ (0x1112, 0x1173, 0x11AA,), 'D753 -> 1112 1173 11AA';
ok Uni.new(0xD754).NFD.list ~~ (0x1112, 0x1173, 0x11AB,), 'D754 -> 1112 1173 11AB';
ok Uni.new(0xD755).NFD.list ~~ (0x1112, 0x1173, 0x11AC,), 'D755 -> 1112 1173 11AC';
ok Uni.new(0xD756).NFD.list ~~ (0x1112, 0x1173, 0x11AD,), 'D756 -> 1112 1173 11AD';
ok Uni.new(0xD757).NFD.list ~~ (0x1112, 0x1173, 0x11AE,), 'D757 -> 1112 1173 11AE';
ok Uni.new(0xD758).NFD.list ~~ (0x1112, 0x1173, 0x11AF,), 'D758 -> 1112 1173 11AF';
ok Uni.new(0xD759).NFD.list ~~ (0x1112, 0x1173, 0x11B0,), 'D759 -> 1112 1173 11B0';
ok Uni.new(0xD75A).NFD.list ~~ (0x1112, 0x1173, 0x11B1,), 'D75A -> 1112 1173 11B1';
ok Uni.new(0xD75B).NFD.list ~~ (0x1112, 0x1173, 0x11B2,), 'D75B -> 1112 1173 11B2';
ok Uni.new(0xD75C).NFD.list ~~ (0x1112, 0x1173, 0x11B3,), 'D75C -> 1112 1173 11B3';
ok Uni.new(0xD75D).NFD.list ~~ (0x1112, 0x1173, 0x11B4,), 'D75D -> 1112 1173 11B4';
ok Uni.new(0xD75E).NFD.list ~~ (0x1112, 0x1173, 0x11B5,), 'D75E -> 1112 1173 11B5';
ok Uni.new(0xD75F).NFD.list ~~ (0x1112, 0x1173, 0x11B6,), 'D75F -> 1112 1173 11B6';
ok Uni.new(0xD760).NFD.list ~~ (0x1112, 0x1173, 0x11B7,), 'D760 -> 1112 1173 11B7';
ok Uni.new(0xD761).NFD.list ~~ (0x1112, 0x1173, 0x11B8,), 'D761 -> 1112 1173 11B8';
ok Uni.new(0xD762).NFD.list ~~ (0x1112, 0x1173, 0x11B9,), 'D762 -> 1112 1173 11B9';
ok Uni.new(0xD763).NFD.list ~~ (0x1112, 0x1173, 0x11BA,), 'D763 -> 1112 1173 11BA';
ok Uni.new(0xD764).NFD.list ~~ (0x1112, 0x1173, 0x11BB,), 'D764 -> 1112 1173 11BB';
ok Uni.new(0xD765).NFD.list ~~ (0x1112, 0x1173, 0x11BC,), 'D765 -> 1112 1173 11BC';
ok Uni.new(0xD766).NFD.list ~~ (0x1112, 0x1173, 0x11BD,), 'D766 -> 1112 1173 11BD';
ok Uni.new(0xD767).NFD.list ~~ (0x1112, 0x1173, 0x11BE,), 'D767 -> 1112 1173 11BE';
ok Uni.new(0xD768).NFD.list ~~ (0x1112, 0x1173, 0x11BF,), 'D768 -> 1112 1173 11BF';
ok Uni.new(0xD769).NFD.list ~~ (0x1112, 0x1173, 0x11C0,), 'D769 -> 1112 1173 11C0';
ok Uni.new(0xD76A).NFD.list ~~ (0x1112, 0x1173, 0x11C1,), 'D76A -> 1112 1173 11C1';
ok Uni.new(0xD76B).NFD.list ~~ (0x1112, 0x1173, 0x11C2,), 'D76B -> 1112 1173 11C2';
ok Uni.new(0xD76C).NFD.list ~~ (0x1112, 0x1174,), 'D76C -> 1112 1174';
ok Uni.new(0xD76D).NFD.list ~~ (0x1112, 0x1174, 0x11A8,), 'D76D -> 1112 1174 11A8';
ok Uni.new(0xD76E).NFD.list ~~ (0x1112, 0x1174, 0x11A9,), 'D76E -> 1112 1174 11A9';
ok Uni.new(0xD76F).NFD.list ~~ (0x1112, 0x1174, 0x11AA,), 'D76F -> 1112 1174 11AA';
ok Uni.new(0xD770).NFD.list ~~ (0x1112, 0x1174, 0x11AB,), 'D770 -> 1112 1174 11AB';
ok Uni.new(0xD771).NFD.list ~~ (0x1112, 0x1174, 0x11AC,), 'D771 -> 1112 1174 11AC';
ok Uni.new(0xD772).NFD.list ~~ (0x1112, 0x1174, 0x11AD,), 'D772 -> 1112 1174 11AD';
ok Uni.new(0xD773).NFD.list ~~ (0x1112, 0x1174, 0x11AE,), 'D773 -> 1112 1174 11AE';
ok Uni.new(0xD774).NFD.list ~~ (0x1112, 0x1174, 0x11AF,), 'D774 -> 1112 1174 11AF';
ok Uni.new(0xD775).NFD.list ~~ (0x1112, 0x1174, 0x11B0,), 'D775 -> 1112 1174 11B0';
ok Uni.new(0xD776).NFD.list ~~ (0x1112, 0x1174, 0x11B1,), 'D776 -> 1112 1174 11B1';
ok Uni.new(0xD777).NFD.list ~~ (0x1112, 0x1174, 0x11B2,), 'D777 -> 1112 1174 11B2';
ok Uni.new(0xD778).NFD.list ~~ (0x1112, 0x1174, 0x11B3,), 'D778 -> 1112 1174 11B3';
ok Uni.new(0xD779).NFD.list ~~ (0x1112, 0x1174, 0x11B4,), 'D779 -> 1112 1174 11B4';
ok Uni.new(0xD77A).NFD.list ~~ (0x1112, 0x1174, 0x11B5,), 'D77A -> 1112 1174 11B5';
ok Uni.new(0xD77B).NFD.list ~~ (0x1112, 0x1174, 0x11B6,), 'D77B -> 1112 1174 11B6';
ok Uni.new(0xD77C).NFD.list ~~ (0x1112, 0x1174, 0x11B7,), 'D77C -> 1112 1174 11B7';
ok Uni.new(0xD77D).NFD.list ~~ (0x1112, 0x1174, 0x11B8,), 'D77D -> 1112 1174 11B8';
ok Uni.new(0xD77E).NFD.list ~~ (0x1112, 0x1174, 0x11B9,), 'D77E -> 1112 1174 11B9';
ok Uni.new(0xD77F).NFD.list ~~ (0x1112, 0x1174, 0x11BA,), 'D77F -> 1112 1174 11BA';
ok Uni.new(0xD780).NFD.list ~~ (0x1112, 0x1174, 0x11BB,), 'D780 -> 1112 1174 11BB';
ok Uni.new(0xD781).NFD.list ~~ (0x1112, 0x1174, 0x11BC,), 'D781 -> 1112 1174 11BC';
ok Uni.new(0xD782).NFD.list ~~ (0x1112, 0x1174, 0x11BD,), 'D782 -> 1112 1174 11BD';
ok Uni.new(0xD783).NFD.list ~~ (0x1112, 0x1174, 0x11BE,), 'D783 -> 1112 1174 11BE';
ok Uni.new(0xD784).NFD.list ~~ (0x1112, 0x1174, 0x11BF,), 'D784 -> 1112 1174 11BF';
ok Uni.new(0xD785).NFD.list ~~ (0x1112, 0x1174, 0x11C0,), 'D785 -> 1112 1174 11C0';
ok Uni.new(0xD786).NFD.list ~~ (0x1112, 0x1174, 0x11C1,), 'D786 -> 1112 1174 11C1';
ok Uni.new(0xD787).NFD.list ~~ (0x1112, 0x1174, 0x11C2,), 'D787 -> 1112 1174 11C2';
ok Uni.new(0xD788).NFD.list ~~ (0x1112, 0x1175,), 'D788 -> 1112 1175';
ok Uni.new(0xD789).NFD.list ~~ (0x1112, 0x1175, 0x11A8,), 'D789 -> 1112 1175 11A8';
ok Uni.new(0xD78A).NFD.list ~~ (0x1112, 0x1175, 0x11A9,), 'D78A -> 1112 1175 11A9';
ok Uni.new(0xD78B).NFD.list ~~ (0x1112, 0x1175, 0x11AA,), 'D78B -> 1112 1175 11AA';
ok Uni.new(0xD78C).NFD.list ~~ (0x1112, 0x1175, 0x11AB,), 'D78C -> 1112 1175 11AB';
ok Uni.new(0xD78D).NFD.list ~~ (0x1112, 0x1175, 0x11AC,), 'D78D -> 1112 1175 11AC';
ok Uni.new(0xD78E).NFD.list ~~ (0x1112, 0x1175, 0x11AD,), 'D78E -> 1112 1175 11AD';
ok Uni.new(0xD78F).NFD.list ~~ (0x1112, 0x1175, 0x11AE,), 'D78F -> 1112 1175 11AE';
ok Uni.new(0xD790).NFD.list ~~ (0x1112, 0x1175, 0x11AF,), 'D790 -> 1112 1175 11AF';
ok Uni.new(0xD791).NFD.list ~~ (0x1112, 0x1175, 0x11B0,), 'D791 -> 1112 1175 11B0';
ok Uni.new(0xD792).NFD.list ~~ (0x1112, 0x1175, 0x11B1,), 'D792 -> 1112 1175 11B1';
ok Uni.new(0xD793).NFD.list ~~ (0x1112, 0x1175, 0x11B2,), 'D793 -> 1112 1175 11B2';
ok Uni.new(0xD794).NFD.list ~~ (0x1112, 0x1175, 0x11B3,), 'D794 -> 1112 1175 11B3';
ok Uni.new(0xD795).NFD.list ~~ (0x1112, 0x1175, 0x11B4,), 'D795 -> 1112 1175 11B4';
ok Uni.new(0xD796).NFD.list ~~ (0x1112, 0x1175, 0x11B5,), 'D796 -> 1112 1175 11B5';
ok Uni.new(0xD797).NFD.list ~~ (0x1112, 0x1175, 0x11B6,), 'D797 -> 1112 1175 11B6';
ok Uni.new(0xD798).NFD.list ~~ (0x1112, 0x1175, 0x11B7,), 'D798 -> 1112 1175 11B7';
ok Uni.new(0xD799).NFD.list ~~ (0x1112, 0x1175, 0x11B8,), 'D799 -> 1112 1175 11B8';
ok Uni.new(0xD79A).NFD.list ~~ (0x1112, 0x1175, 0x11B9,), 'D79A -> 1112 1175 11B9';
ok Uni.new(0xD79B).NFD.list ~~ (0x1112, 0x1175, 0x11BA,), 'D79B -> 1112 1175 11BA';
ok Uni.new(0xD79C).NFD.list ~~ (0x1112, 0x1175, 0x11BB,), 'D79C -> 1112 1175 11BB';
ok Uni.new(0xD79D).NFD.list ~~ (0x1112, 0x1175, 0x11BC,), 'D79D -> 1112 1175 11BC';
ok Uni.new(0xD79E).NFD.list ~~ (0x1112, 0x1175, 0x11BD,), 'D79E -> 1112 1175 11BD';
ok Uni.new(0xD79F).NFD.list ~~ (0x1112, 0x1175, 0x11BE,), 'D79F -> 1112 1175 11BE';
ok Uni.new(0xD7A0).NFD.list ~~ (0x1112, 0x1175, 0x11BF,), 'D7A0 -> 1112 1175 11BF';
ok Uni.new(0xD7A1).NFD.list ~~ (0x1112, 0x1175, 0x11C0,), 'D7A1 -> 1112 1175 11C0';
ok Uni.new(0xD7A2).NFD.list ~~ (0x1112, 0x1175, 0x11C1,), 'D7A2 -> 1112 1175 11C1';
ok Uni.new(0xD7A3).NFD.list ~~ (0x1112, 0x1175, 0x11C2,), 'D7A3 -> 1112 1175 11C2';
ok Uni.new(0xF900).NFD.list ~~ (0x8C48,), 'F900 -> 8C48';
ok Uni.new(0xF901).NFD.list ~~ (0x66F4,), 'F901 -> 66F4';
ok Uni.new(0xF902).NFD.list ~~ (0x8ECA,), 'F902 -> 8ECA';
ok Uni.new(0xF903).NFD.list ~~ (0x8CC8,), 'F903 -> 8CC8';
ok Uni.new(0xF904).NFD.list ~~ (0x6ED1,), 'F904 -> 6ED1';
ok Uni.new(0xF905).NFD.list ~~ (0x4E32,), 'F905 -> 4E32';
ok Uni.new(0xF906).NFD.list ~~ (0x53E5,), 'F906 -> 53E5';
ok Uni.new(0xF907).NFD.list ~~ (0x9F9C,), 'F907 -> 9F9C';
ok Uni.new(0xF908).NFD.list ~~ (0x9F9C,), 'F908 -> 9F9C';
ok Uni.new(0xF909).NFD.list ~~ (0x5951,), 'F909 -> 5951';
ok Uni.new(0xF90A).NFD.list ~~ (0x91D1,), 'F90A -> 91D1';
ok Uni.new(0xF90B).NFD.list ~~ (0x5587,), 'F90B -> 5587';
ok Uni.new(0xF90C).NFD.list ~~ (0x5948,), 'F90C -> 5948';
ok Uni.new(0xF90D).NFD.list ~~ (0x61F6,), 'F90D -> 61F6';
ok Uni.new(0xF90E).NFD.list ~~ (0x7669,), 'F90E -> 7669';
ok Uni.new(0xF90F).NFD.list ~~ (0x7F85,), 'F90F -> 7F85';
ok Uni.new(0xF910).NFD.list ~~ (0x863F,), 'F910 -> 863F';
ok Uni.new(0xF911).NFD.list ~~ (0x87BA,), 'F911 -> 87BA';
ok Uni.new(0xF912).NFD.list ~~ (0x88F8,), 'F912 -> 88F8';
ok Uni.new(0xF913).NFD.list ~~ (0x908F,), 'F913 -> 908F';
ok Uni.new(0xF914).NFD.list ~~ (0x6A02,), 'F914 -> 6A02';
ok Uni.new(0xF915).NFD.list ~~ (0x6D1B,), 'F915 -> 6D1B';
ok Uni.new(0xF916).NFD.list ~~ (0x70D9,), 'F916 -> 70D9';
ok Uni.new(0xF917).NFD.list ~~ (0x73DE,), 'F917 -> 73DE';
ok Uni.new(0xF918).NFD.list ~~ (0x843D,), 'F918 -> 843D';
ok Uni.new(0xF919).NFD.list ~~ (0x916A,), 'F919 -> 916A';
ok Uni.new(0xF91A).NFD.list ~~ (0x99F1,), 'F91A -> 99F1';
ok Uni.new(0xF91B).NFD.list ~~ (0x4E82,), 'F91B -> 4E82';
ok Uni.new(0xF91C).NFD.list ~~ (0x5375,), 'F91C -> 5375';
ok Uni.new(0xF91D).NFD.list ~~ (0x6B04,), 'F91D -> 6B04';
ok Uni.new(0xF91E).NFD.list ~~ (0x721B,), 'F91E -> 721B';
ok Uni.new(0xF91F).NFD.list ~~ (0x862D,), 'F91F -> 862D';
ok Uni.new(0xF920).NFD.list ~~ (0x9E1E,), 'F920 -> 9E1E';
ok Uni.new(0xF921).NFD.list ~~ (0x5D50,), 'F921 -> 5D50';
ok Uni.new(0xF922).NFD.list ~~ (0x6FEB,), 'F922 -> 6FEB';
ok Uni.new(0xF923).NFD.list ~~ (0x85CD,), 'F923 -> 85CD';
ok Uni.new(0xF924).NFD.list ~~ (0x8964,), 'F924 -> 8964';
ok Uni.new(0xF925).NFD.list ~~ (0x62C9,), 'F925 -> 62C9';
ok Uni.new(0xF926).NFD.list ~~ (0x81D8,), 'F926 -> 81D8';
ok Uni.new(0xF927).NFD.list ~~ (0x881F,), 'F927 -> 881F';
ok Uni.new(0xF928).NFD.list ~~ (0x5ECA,), 'F928 -> 5ECA';
ok Uni.new(0xF929).NFD.list ~~ (0x6717,), 'F929 -> 6717';
ok Uni.new(0xF92A).NFD.list ~~ (0x6D6A,), 'F92A -> 6D6A';
ok Uni.new(0xF92B).NFD.list ~~ (0x72FC,), 'F92B -> 72FC';
ok Uni.new(0xF92C).NFD.list ~~ (0x90CE,), 'F92C -> 90CE';
ok Uni.new(0xF92D).NFD.list ~~ (0x4F86,), 'F92D -> 4F86';
ok Uni.new(0xF92E).NFD.list ~~ (0x51B7,), 'F92E -> 51B7';
ok Uni.new(0xF92F).NFD.list ~~ (0x52DE,), 'F92F -> 52DE';
ok Uni.new(0xF930).NFD.list ~~ (0x64C4,), 'F930 -> 64C4';
ok Uni.new(0xF931).NFD.list ~~ (0x6AD3,), 'F931 -> 6AD3';
ok Uni.new(0xF932).NFD.list ~~ (0x7210,), 'F932 -> 7210';
ok Uni.new(0xF933).NFD.list ~~ (0x76E7,), 'F933 -> 76E7';
ok Uni.new(0xF934).NFD.list ~~ (0x8001,), 'F934 -> 8001';
ok Uni.new(0xF935).NFD.list ~~ (0x8606,), 'F935 -> 8606';
ok Uni.new(0xF936).NFD.list ~~ (0x865C,), 'F936 -> 865C';
ok Uni.new(0xF937).NFD.list ~~ (0x8DEF,), 'F937 -> 8DEF';
ok Uni.new(0xF938).NFD.list ~~ (0x9732,), 'F938 -> 9732';
ok Uni.new(0xF939).NFD.list ~~ (0x9B6F,), 'F939 -> 9B6F';
ok Uni.new(0xF93A).NFD.list ~~ (0x9DFA,), 'F93A -> 9DFA';
ok Uni.new(0xF93B).NFD.list ~~ (0x788C,), 'F93B -> 788C';
ok Uni.new(0xF93C).NFD.list ~~ (0x797F,), 'F93C -> 797F';
ok Uni.new(0xF93D).NFD.list ~~ (0x7DA0,), 'F93D -> 7DA0';
ok Uni.new(0xF93E).NFD.list ~~ (0x83C9,), 'F93E -> 83C9';
ok Uni.new(0xF93F).NFD.list ~~ (0x9304,), 'F93F -> 9304';
ok Uni.new(0xF940).NFD.list ~~ (0x9E7F,), 'F940 -> 9E7F';
ok Uni.new(0xF941).NFD.list ~~ (0x8AD6,), 'F941 -> 8AD6';
ok Uni.new(0xF942).NFD.list ~~ (0x58DF,), 'F942 -> 58DF';
ok Uni.new(0xF943).NFD.list ~~ (0x5F04,), 'F943 -> 5F04';
ok Uni.new(0xF944).NFD.list ~~ (0x7C60,), 'F944 -> 7C60';
ok Uni.new(0xF945).NFD.list ~~ (0x807E,), 'F945 -> 807E';
ok Uni.new(0xF946).NFD.list ~~ (0x7262,), 'F946 -> 7262';
ok Uni.new(0xF947).NFD.list ~~ (0x78CA,), 'F947 -> 78CA';
ok Uni.new(0xF948).NFD.list ~~ (0x8CC2,), 'F948 -> 8CC2';
ok Uni.new(0xF949).NFD.list ~~ (0x96F7,), 'F949 -> 96F7';
ok Uni.new(0xF94A).NFD.list ~~ (0x58D8,), 'F94A -> 58D8';
ok Uni.new(0xF94B).NFD.list ~~ (0x5C62,), 'F94B -> 5C62';
ok Uni.new(0xF94C).NFD.list ~~ (0x6A13,), 'F94C -> 6A13';
ok Uni.new(0xF94D).NFD.list ~~ (0x6DDA,), 'F94D -> 6DDA';
ok Uni.new(0xF94E).NFD.list ~~ (0x6F0F,), 'F94E -> 6F0F';
ok Uni.new(0xF94F).NFD.list ~~ (0x7D2F,), 'F94F -> 7D2F';
ok Uni.new(0xF950).NFD.list ~~ (0x7E37,), 'F950 -> 7E37';
ok Uni.new(0xF951).NFD.list ~~ (0x964B,), 'F951 -> 964B';
ok Uni.new(0xF952).NFD.list ~~ (0x52D2,), 'F952 -> 52D2';
ok Uni.new(0xF953).NFD.list ~~ (0x808B,), 'F953 -> 808B';
ok Uni.new(0xF954).NFD.list ~~ (0x51DC,), 'F954 -> 51DC';
ok Uni.new(0xF955).NFD.list ~~ (0x51CC,), 'F955 -> 51CC';
ok Uni.new(0xF956).NFD.list ~~ (0x7A1C,), 'F956 -> 7A1C';
ok Uni.new(0xF957).NFD.list ~~ (0x7DBE,), 'F957 -> 7DBE';
ok Uni.new(0xF958).NFD.list ~~ (0x83F1,), 'F958 -> 83F1';
ok Uni.new(0xF959).NFD.list ~~ (0x9675,), 'F959 -> 9675';
ok Uni.new(0xF95A).NFD.list ~~ (0x8B80,), 'F95A -> 8B80';
ok Uni.new(0xF95B).NFD.list ~~ (0x62CF,), 'F95B -> 62CF';
ok Uni.new(0xF95C).NFD.list ~~ (0x6A02,), 'F95C -> 6A02';
ok Uni.new(0xF95D).NFD.list ~~ (0x8AFE,), 'F95D -> 8AFE';
ok Uni.new(0xF95E).NFD.list ~~ (0x4E39,), 'F95E -> 4E39';
ok Uni.new(0xF95F).NFD.list ~~ (0x5BE7,), 'F95F -> 5BE7';
ok Uni.new(0xF960).NFD.list ~~ (0x6012,), 'F960 -> 6012';
ok Uni.new(0xF961).NFD.list ~~ (0x7387,), 'F961 -> 7387';
ok Uni.new(0xF962).NFD.list ~~ (0x7570,), 'F962 -> 7570';
ok Uni.new(0xF963).NFD.list ~~ (0x5317,), 'F963 -> 5317';
ok Uni.new(0xF964).NFD.list ~~ (0x78FB,), 'F964 -> 78FB';
ok Uni.new(0xF965).NFD.list ~~ (0x4FBF,), 'F965 -> 4FBF';
ok Uni.new(0xF966).NFD.list ~~ (0x5FA9,), 'F966 -> 5FA9';
ok Uni.new(0xF967).NFD.list ~~ (0x4E0D,), 'F967 -> 4E0D';
ok Uni.new(0xF968).NFD.list ~~ (0x6CCC,), 'F968 -> 6CCC';
ok Uni.new(0xF969).NFD.list ~~ (0x6578,), 'F969 -> 6578';
ok Uni.new(0xF96A).NFD.list ~~ (0x7D22,), 'F96A -> 7D22';
ok Uni.new(0xF96B).NFD.list ~~ (0x53C3,), 'F96B -> 53C3';
ok Uni.new(0xF96C).NFD.list ~~ (0x585E,), 'F96C -> 585E';
ok Uni.new(0xF96D).NFD.list ~~ (0x7701,), 'F96D -> 7701';
ok Uni.new(0xF96E).NFD.list ~~ (0x8449,), 'F96E -> 8449';
ok Uni.new(0xF96F).NFD.list ~~ (0x8AAA,), 'F96F -> 8AAA';
ok Uni.new(0xF970).NFD.list ~~ (0x6BBA,), 'F970 -> 6BBA';
ok Uni.new(0xF971).NFD.list ~~ (0x8FB0,), 'F971 -> 8FB0';
ok Uni.new(0xF972).NFD.list ~~ (0x6C88,), 'F972 -> 6C88';
ok Uni.new(0xF973).NFD.list ~~ (0x62FE,), 'F973 -> 62FE';
ok Uni.new(0xF974).NFD.list ~~ (0x82E5,), 'F974 -> 82E5';
ok Uni.new(0xF975).NFD.list ~~ (0x63A0,), 'F975 -> 63A0';
ok Uni.new(0xF976).NFD.list ~~ (0x7565,), 'F976 -> 7565';
ok Uni.new(0xF977).NFD.list ~~ (0x4EAE,), 'F977 -> 4EAE';
ok Uni.new(0xF978).NFD.list ~~ (0x5169,), 'F978 -> 5169';
ok Uni.new(0xF979).NFD.list ~~ (0x51C9,), 'F979 -> 51C9';
ok Uni.new(0xF97A).NFD.list ~~ (0x6881,), 'F97A -> 6881';
ok Uni.new(0xF97B).NFD.list ~~ (0x7CE7,), 'F97B -> 7CE7';
ok Uni.new(0xF97C).NFD.list ~~ (0x826F,), 'F97C -> 826F';
ok Uni.new(0xF97D).NFD.list ~~ (0x8AD2,), 'F97D -> 8AD2';
ok Uni.new(0xF97E).NFD.list ~~ (0x91CF,), 'F97E -> 91CF';
ok Uni.new(0xF97F).NFD.list ~~ (0x52F5,), 'F97F -> 52F5';
ok Uni.new(0xF980).NFD.list ~~ (0x5442,), 'F980 -> 5442';
ok Uni.new(0xF981).NFD.list ~~ (0x5973,), 'F981 -> 5973';
ok Uni.new(0xF982).NFD.list ~~ (0x5EEC,), 'F982 -> 5EEC';
ok Uni.new(0xF983).NFD.list ~~ (0x65C5,), 'F983 -> 65C5';
ok Uni.new(0xF984).NFD.list ~~ (0x6FFE,), 'F984 -> 6FFE';
ok Uni.new(0xF985).NFD.list ~~ (0x792A,), 'F985 -> 792A';
ok Uni.new(0xF986).NFD.list ~~ (0x95AD,), 'F986 -> 95AD';
ok Uni.new(0xF987).NFD.list ~~ (0x9A6A,), 'F987 -> 9A6A';
ok Uni.new(0xF988).NFD.list ~~ (0x9E97,), 'F988 -> 9E97';
ok Uni.new(0xF989).NFD.list ~~ (0x9ECE,), 'F989 -> 9ECE';
ok Uni.new(0xF98A).NFD.list ~~ (0x529B,), 'F98A -> 529B';
ok Uni.new(0xF98B).NFD.list ~~ (0x66C6,), 'F98B -> 66C6';
ok Uni.new(0xF98C).NFD.list ~~ (0x6B77,), 'F98C -> 6B77';
ok Uni.new(0xF98D).NFD.list ~~ (0x8F62,), 'F98D -> 8F62';
ok Uni.new(0xF98E).NFD.list ~~ (0x5E74,), 'F98E -> 5E74';
ok Uni.new(0xF98F).NFD.list ~~ (0x6190,), 'F98F -> 6190';
ok Uni.new(0xF990).NFD.list ~~ (0x6200,), 'F990 -> 6200';
ok Uni.new(0xF991).NFD.list ~~ (0x649A,), 'F991 -> 649A';
ok Uni.new(0xF992).NFD.list ~~ (0x6F23,), 'F992 -> 6F23';
ok Uni.new(0xF993).NFD.list ~~ (0x7149,), 'F993 -> 7149';
ok Uni.new(0xF994).NFD.list ~~ (0x7489,), 'F994 -> 7489';
ok Uni.new(0xF995).NFD.list ~~ (0x79CA,), 'F995 -> 79CA';
ok Uni.new(0xF996).NFD.list ~~ (0x7DF4,), 'F996 -> 7DF4';
ok Uni.new(0xF997).NFD.list ~~ (0x806F,), 'F997 -> 806F';
ok Uni.new(0xF998).NFD.list ~~ (0x8F26,), 'F998 -> 8F26';
ok Uni.new(0xF999).NFD.list ~~ (0x84EE,), 'F999 -> 84EE';
ok Uni.new(0xF99A).NFD.list ~~ (0x9023,), 'F99A -> 9023';
ok Uni.new(0xF99B).NFD.list ~~ (0x934A,), 'F99B -> 934A';
ok Uni.new(0xF99C).NFD.list ~~ (0x5217,), 'F99C -> 5217';
ok Uni.new(0xF99D).NFD.list ~~ (0x52A3,), 'F99D -> 52A3';
ok Uni.new(0xF99E).NFD.list ~~ (0x54BD,), 'F99E -> 54BD';
ok Uni.new(0xF99F).NFD.list ~~ (0x70C8,), 'F99F -> 70C8';
ok Uni.new(0xF9A0).NFD.list ~~ (0x88C2,), 'F9A0 -> 88C2';
ok Uni.new(0xF9A1).NFD.list ~~ (0x8AAA,), 'F9A1 -> 8AAA';
ok Uni.new(0xF9A2).NFD.list ~~ (0x5EC9,), 'F9A2 -> 5EC9';
ok Uni.new(0xF9A3).NFD.list ~~ (0x5FF5,), 'F9A3 -> 5FF5';
ok Uni.new(0xF9A4).NFD.list ~~ (0x637B,), 'F9A4 -> 637B';
ok Uni.new(0xF9A5).NFD.list ~~ (0x6BAE,), 'F9A5 -> 6BAE';
ok Uni.new(0xF9A6).NFD.list ~~ (0x7C3E,), 'F9A6 -> 7C3E';
ok Uni.new(0xF9A7).NFD.list ~~ (0x7375,), 'F9A7 -> 7375';
ok Uni.new(0xF9A8).NFD.list ~~ (0x4EE4,), 'F9A8 -> 4EE4';
ok Uni.new(0xF9A9).NFD.list ~~ (0x56F9,), 'F9A9 -> 56F9';
ok Uni.new(0xF9AA).NFD.list ~~ (0x5BE7,), 'F9AA -> 5BE7';
ok Uni.new(0xF9AB).NFD.list ~~ (0x5DBA,), 'F9AB -> 5DBA';
ok Uni.new(0xF9AC).NFD.list ~~ (0x601C,), 'F9AC -> 601C';
ok Uni.new(0xF9AD).NFD.list ~~ (0x73B2,), 'F9AD -> 73B2';
ok Uni.new(0xF9AE).NFD.list ~~ (0x7469,), 'F9AE -> 7469';
ok Uni.new(0xF9AF).NFD.list ~~ (0x7F9A,), 'F9AF -> 7F9A';
ok Uni.new(0xF9B0).NFD.list ~~ (0x8046,), 'F9B0 -> 8046';
ok Uni.new(0xF9B1).NFD.list ~~ (0x9234,), 'F9B1 -> 9234';
ok Uni.new(0xF9B2).NFD.list ~~ (0x96F6,), 'F9B2 -> 96F6';
ok Uni.new(0xF9B3).NFD.list ~~ (0x9748,), 'F9B3 -> 9748';
ok Uni.new(0xF9B4).NFD.list ~~ (0x9818,), 'F9B4 -> 9818';
ok Uni.new(0xF9B5).NFD.list ~~ (0x4F8B,), 'F9B5 -> 4F8B';
ok Uni.new(0xF9B6).NFD.list ~~ (0x79AE,), 'F9B6 -> 79AE';
ok Uni.new(0xF9B7).NFD.list ~~ (0x91B4,), 'F9B7 -> 91B4';
ok Uni.new(0xF9B8).NFD.list ~~ (0x96B8,), 'F9B8 -> 96B8';
ok Uni.new(0xF9B9).NFD.list ~~ (0x60E1,), 'F9B9 -> 60E1';
ok Uni.new(0xF9BA).NFD.list ~~ (0x4E86,), 'F9BA -> 4E86';
ok Uni.new(0xF9BB).NFD.list ~~ (0x50DA,), 'F9BB -> 50DA';
ok Uni.new(0xF9BC).NFD.list ~~ (0x5BEE,), 'F9BC -> 5BEE';
ok Uni.new(0xF9BD).NFD.list ~~ (0x5C3F,), 'F9BD -> 5C3F';
ok Uni.new(0xF9BE).NFD.list ~~ (0x6599,), 'F9BE -> 6599';
ok Uni.new(0xF9BF).NFD.list ~~ (0x6A02,), 'F9BF -> 6A02';
ok Uni.new(0xF9C0).NFD.list ~~ (0x71CE,), 'F9C0 -> 71CE';
ok Uni.new(0xF9C1).NFD.list ~~ (0x7642,), 'F9C1 -> 7642';
ok Uni.new(0xF9C2).NFD.list ~~ (0x84FC,), 'F9C2 -> 84FC';
ok Uni.new(0xF9C3).NFD.list ~~ (0x907C,), 'F9C3 -> 907C';
ok Uni.new(0xF9C4).NFD.list ~~ (0x9F8D,), 'F9C4 -> 9F8D';
ok Uni.new(0xF9C5).NFD.list ~~ (0x6688,), 'F9C5 -> 6688';
ok Uni.new(0xF9C6).NFD.list ~~ (0x962E,), 'F9C6 -> 962E';
ok Uni.new(0xF9C7).NFD.list ~~ (0x5289,), 'F9C7 -> 5289';
ok Uni.new(0xF9C8).NFD.list ~~ (0x677B,), 'F9C8 -> 677B';
ok Uni.new(0xF9C9).NFD.list ~~ (0x67F3,), 'F9C9 -> 67F3';
ok Uni.new(0xF9CA).NFD.list ~~ (0x6D41,), 'F9CA -> 6D41';
ok Uni.new(0xF9CB).NFD.list ~~ (0x6E9C,), 'F9CB -> 6E9C';
ok Uni.new(0xF9CC).NFD.list ~~ (0x7409,), 'F9CC -> 7409';
ok Uni.new(0xF9CD).NFD.list ~~ (0x7559,), 'F9CD -> 7559';
ok Uni.new(0xF9CE).NFD.list ~~ (0x786B,), 'F9CE -> 786B';
ok Uni.new(0xF9CF).NFD.list ~~ (0x7D10,), 'F9CF -> 7D10';
ok Uni.new(0xF9D0).NFD.list ~~ (0x985E,), 'F9D0 -> 985E';
ok Uni.new(0xF9D1).NFD.list ~~ (0x516D,), 'F9D1 -> 516D';
ok Uni.new(0xF9D2).NFD.list ~~ (0x622E,), 'F9D2 -> 622E';
ok Uni.new(0xF9D3).NFD.list ~~ (0x9678,), 'F9D3 -> 9678';
ok Uni.new(0xF9D4).NFD.list ~~ (0x502B,), 'F9D4 -> 502B';
ok Uni.new(0xF9D5).NFD.list ~~ (0x5D19,), 'F9D5 -> 5D19';
ok Uni.new(0xF9D6).NFD.list ~~ (0x6DEA,), 'F9D6 -> 6DEA';
ok Uni.new(0xF9D7).NFD.list ~~ (0x8F2A,), 'F9D7 -> 8F2A';
ok Uni.new(0xF9D8).NFD.list ~~ (0x5F8B,), 'F9D8 -> 5F8B';
ok Uni.new(0xF9D9).NFD.list ~~ (0x6144,), 'F9D9 -> 6144';
ok Uni.new(0xF9DA).NFD.list ~~ (0x6817,), 'F9DA -> 6817';
ok Uni.new(0xF9DB).NFD.list ~~ (0x7387,), 'F9DB -> 7387';
ok Uni.new(0xF9DC).NFD.list ~~ (0x9686,), 'F9DC -> 9686';
ok Uni.new(0xF9DD).NFD.list ~~ (0x5229,), 'F9DD -> 5229';
ok Uni.new(0xF9DE).NFD.list ~~ (0x540F,), 'F9DE -> 540F';
ok Uni.new(0xF9DF).NFD.list ~~ (0x5C65,), 'F9DF -> 5C65';
ok Uni.new(0xF9E0).NFD.list ~~ (0x6613,), 'F9E0 -> 6613';
ok Uni.new(0xF9E1).NFD.list ~~ (0x674E,), 'F9E1 -> 674E';
ok Uni.new(0xF9E2).NFD.list ~~ (0x68A8,), 'F9E2 -> 68A8';
ok Uni.new(0xF9E3).NFD.list ~~ (0x6CE5,), 'F9E3 -> 6CE5';
ok Uni.new(0xF9E4).NFD.list ~~ (0x7406,), 'F9E4 -> 7406';
ok Uni.new(0xF9E5).NFD.list ~~ (0x75E2,), 'F9E5 -> 75E2';
ok Uni.new(0xF9E6).NFD.list ~~ (0x7F79,), 'F9E6 -> 7F79';
ok Uni.new(0xF9E7).NFD.list ~~ (0x88CF,), 'F9E7 -> 88CF';
ok Uni.new(0xF9E8).NFD.list ~~ (0x88E1,), 'F9E8 -> 88E1';
ok Uni.new(0xF9E9).NFD.list ~~ (0x91CC,), 'F9E9 -> 91CC';
ok Uni.new(0xF9EA).NFD.list ~~ (0x96E2,), 'F9EA -> 96E2';
ok Uni.new(0xF9EB).NFD.list ~~ (0x533F,), 'F9EB -> 533F';
ok Uni.new(0xF9EC).NFD.list ~~ (0x6EBA,), 'F9EC -> 6EBA';
ok Uni.new(0xF9ED).NFD.list ~~ (0x541D,), 'F9ED -> 541D';
ok Uni.new(0xF9EE).NFD.list ~~ (0x71D0,), 'F9EE -> 71D0';
ok Uni.new(0xF9EF).NFD.list ~~ (0x7498,), 'F9EF -> 7498';
ok Uni.new(0xF9F0).NFD.list ~~ (0x85FA,), 'F9F0 -> 85FA';
ok Uni.new(0xF9F1).NFD.list ~~ (0x96A3,), 'F9F1 -> 96A3';
ok Uni.new(0xF9F2).NFD.list ~~ (0x9C57,), 'F9F2 -> 9C57';
ok Uni.new(0xF9F3).NFD.list ~~ (0x9E9F,), 'F9F3 -> 9E9F';
ok Uni.new(0xF9F4).NFD.list ~~ (0x6797,), 'F9F4 -> 6797';
ok Uni.new(0xF9F5).NFD.list ~~ (0x6DCB,), 'F9F5 -> 6DCB';
ok Uni.new(0xF9F6).NFD.list ~~ (0x81E8,), 'F9F6 -> 81E8';
ok Uni.new(0xF9F7).NFD.list ~~ (0x7ACB,), 'F9F7 -> 7ACB';
ok Uni.new(0xF9F8).NFD.list ~~ (0x7B20,), 'F9F8 -> 7B20';
ok Uni.new(0xF9F9).NFD.list ~~ (0x7C92,), 'F9F9 -> 7C92';
ok Uni.new(0xF9FA).NFD.list ~~ (0x72C0,), 'F9FA -> 72C0';
ok Uni.new(0xF9FB).NFD.list ~~ (0x7099,), 'F9FB -> 7099';
ok Uni.new(0xF9FC).NFD.list ~~ (0x8B58,), 'F9FC -> 8B58';
ok Uni.new(0xF9FD).NFD.list ~~ (0x4EC0,), 'F9FD -> 4EC0';
ok Uni.new(0xF9FE).NFD.list ~~ (0x8336,), 'F9FE -> 8336';
ok Uni.new(0xF9FF).NFD.list ~~ (0x523A,), 'F9FF -> 523A';
ok Uni.new(0xFA00).NFD.list ~~ (0x5207,), 'FA00 -> 5207';
ok Uni.new(0xFA01).NFD.list ~~ (0x5EA6,), 'FA01 -> 5EA6';
ok Uni.new(0xFA02).NFD.list ~~ (0x62D3,), 'FA02 -> 62D3';
ok Uni.new(0xFA03).NFD.list ~~ (0x7CD6,), 'FA03 -> 7CD6';
ok Uni.new(0xFA04).NFD.list ~~ (0x5B85,), 'FA04 -> 5B85';
ok Uni.new(0xFA05).NFD.list ~~ (0x6D1E,), 'FA05 -> 6D1E';
ok Uni.new(0xFA06).NFD.list ~~ (0x66B4,), 'FA06 -> 66B4';
ok Uni.new(0xFA07).NFD.list ~~ (0x8F3B,), 'FA07 -> 8F3B';
ok Uni.new(0xFA08).NFD.list ~~ (0x884C,), 'FA08 -> 884C';
ok Uni.new(0xFA09).NFD.list ~~ (0x964D,), 'FA09 -> 964D';
ok Uni.new(0xFA0A).NFD.list ~~ (0x898B,), 'FA0A -> 898B';
ok Uni.new(0xFA0B).NFD.list ~~ (0x5ED3,), 'FA0B -> 5ED3';
ok Uni.new(0xFA0C).NFD.list ~~ (0x5140,), 'FA0C -> 5140';
ok Uni.new(0xFA0D).NFD.list ~~ (0x55C0,), 'FA0D -> 55C0';
ok Uni.new(0xFA10).NFD.list ~~ (0x585A,), 'FA10 -> 585A';
ok Uni.new(0xFA12).NFD.list ~~ (0x6674,), 'FA12 -> 6674';
ok Uni.new(0xFA15).NFD.list ~~ (0x51DE,), 'FA15 -> 51DE';
ok Uni.new(0xFA16).NFD.list ~~ (0x732A,), 'FA16 -> 732A';
ok Uni.new(0xFA17).NFD.list ~~ (0x76CA,), 'FA17 -> 76CA';
ok Uni.new(0xFA18).NFD.list ~~ (0x793C,), 'FA18 -> 793C';
ok Uni.new(0xFA19).NFD.list ~~ (0x795E,), 'FA19 -> 795E';
ok Uni.new(0xFA1A).NFD.list ~~ (0x7965,), 'FA1A -> 7965';
ok Uni.new(0xFA1B).NFD.list ~~ (0x798F,), 'FA1B -> 798F';
ok Uni.new(0xFA1C).NFD.list ~~ (0x9756,), 'FA1C -> 9756';
ok Uni.new(0xFA1D).NFD.list ~~ (0x7CBE,), 'FA1D -> 7CBE';
ok Uni.new(0xFA1E).NFD.list ~~ (0x7FBD,), 'FA1E -> 7FBD';
ok Uni.new(0xFA20).NFD.list ~~ (0x8612,), 'FA20 -> 8612';
ok Uni.new(0xFA22).NFD.list ~~ (0x8AF8,), 'FA22 -> 8AF8';
ok Uni.new(0xFA25).NFD.list ~~ (0x9038,), 'FA25 -> 9038';
ok Uni.new(0xFA26).NFD.list ~~ (0x90FD,), 'FA26 -> 90FD';
ok Uni.new(0xFA2A).NFD.list ~~ (0x98EF,), 'FA2A -> 98EF';
ok Uni.new(0xFA2B).NFD.list ~~ (0x98FC,), 'FA2B -> 98FC';
ok Uni.new(0xFA2C).NFD.list ~~ (0x9928,), 'FA2C -> 9928';
ok Uni.new(0xFA2D).NFD.list ~~ (0x9DB4,), 'FA2D -> 9DB4';
ok Uni.new(0xFA2E).NFD.list ~~ (0x90DE,), 'FA2E -> 90DE';
ok Uni.new(0xFA2F).NFD.list ~~ (0x96B7,), 'FA2F -> 96B7';
ok Uni.new(0xFA30).NFD.list ~~ (0x4FAE,), 'FA30 -> 4FAE';
ok Uni.new(0xFA31).NFD.list ~~ (0x50E7,), 'FA31 -> 50E7';
ok Uni.new(0xFA32).NFD.list ~~ (0x514D,), 'FA32 -> 514D';
ok Uni.new(0xFA33).NFD.list ~~ (0x52C9,), 'FA33 -> 52C9';
ok Uni.new(0xFA34).NFD.list ~~ (0x52E4,), 'FA34 -> 52E4';
ok Uni.new(0xFA35).NFD.list ~~ (0x5351,), 'FA35 -> 5351';
ok Uni.new(0xFA36).NFD.list ~~ (0x559D,), 'FA36 -> 559D';
ok Uni.new(0xFA37).NFD.list ~~ (0x5606,), 'FA37 -> 5606';
ok Uni.new(0xFA38).NFD.list ~~ (0x5668,), 'FA38 -> 5668';
ok Uni.new(0xFA39).NFD.list ~~ (0x5840,), 'FA39 -> 5840';
ok Uni.new(0xFA3A).NFD.list ~~ (0x58A8,), 'FA3A -> 58A8';
ok Uni.new(0xFA3B).NFD.list ~~ (0x5C64,), 'FA3B -> 5C64';
ok Uni.new(0xFA3C).NFD.list ~~ (0x5C6E,), 'FA3C -> 5C6E';
ok Uni.new(0xFA3D).NFD.list ~~ (0x6094,), 'FA3D -> 6094';
ok Uni.new(0xFA3E).NFD.list ~~ (0x6168,), 'FA3E -> 6168';
ok Uni.new(0xFA3F).NFD.list ~~ (0x618E,), 'FA3F -> 618E';
ok Uni.new(0xFA40).NFD.list ~~ (0x61F2,), 'FA40 -> 61F2';
ok Uni.new(0xFA41).NFD.list ~~ (0x654F,), 'FA41 -> 654F';
ok Uni.new(0xFA42).NFD.list ~~ (0x65E2,), 'FA42 -> 65E2';
ok Uni.new(0xFA43).NFD.list ~~ (0x6691,), 'FA43 -> 6691';
ok Uni.new(0xFA44).NFD.list ~~ (0x6885,), 'FA44 -> 6885';
ok Uni.new(0xFA45).NFD.list ~~ (0x6D77,), 'FA45 -> 6D77';
ok Uni.new(0xFA46).NFD.list ~~ (0x6E1A,), 'FA46 -> 6E1A';
ok Uni.new(0xFA47).NFD.list ~~ (0x6F22,), 'FA47 -> 6F22';
ok Uni.new(0xFA48).NFD.list ~~ (0x716E,), 'FA48 -> 716E';
ok Uni.new(0xFA49).NFD.list ~~ (0x722B,), 'FA49 -> 722B';
ok Uni.new(0xFA4A).NFD.list ~~ (0x7422,), 'FA4A -> 7422';
ok Uni.new(0xFA4B).NFD.list ~~ (0x7891,), 'FA4B -> 7891';
ok Uni.new(0xFA4C).NFD.list ~~ (0x793E,), 'FA4C -> 793E';
ok Uni.new(0xFA4D).NFD.list ~~ (0x7949,), 'FA4D -> 7949';
ok Uni.new(0xFA4E).NFD.list ~~ (0x7948,), 'FA4E -> 7948';
ok Uni.new(0xFA4F).NFD.list ~~ (0x7950,), 'FA4F -> 7950';
ok Uni.new(0xFA50).NFD.list ~~ (0x7956,), 'FA50 -> 7956';
ok Uni.new(0xFA51).NFD.list ~~ (0x795D,), 'FA51 -> 795D';
ok Uni.new(0xFA52).NFD.list ~~ (0x798D,), 'FA52 -> 798D';
ok Uni.new(0xFA53).NFD.list ~~ (0x798E,), 'FA53 -> 798E';
ok Uni.new(0xFA54).NFD.list ~~ (0x7A40,), 'FA54 -> 7A40';
ok Uni.new(0xFA55).NFD.list ~~ (0x7A81,), 'FA55 -> 7A81';
ok Uni.new(0xFA56).NFD.list ~~ (0x7BC0,), 'FA56 -> 7BC0';
ok Uni.new(0xFA57).NFD.list ~~ (0x7DF4,), 'FA57 -> 7DF4';
ok Uni.new(0xFA58).NFD.list ~~ (0x7E09,), 'FA58 -> 7E09';
ok Uni.new(0xFA59).NFD.list ~~ (0x7E41,), 'FA59 -> 7E41';
ok Uni.new(0xFA5A).NFD.list ~~ (0x7F72,), 'FA5A -> 7F72';
ok Uni.new(0xFA5B).NFD.list ~~ (0x8005,), 'FA5B -> 8005';
ok Uni.new(0xFA5C).NFD.list ~~ (0x81ED,), 'FA5C -> 81ED';
ok Uni.new(0xFA5D).NFD.list ~~ (0x8279,), 'FA5D -> 8279';
ok Uni.new(0xFA5E).NFD.list ~~ (0x8279,), 'FA5E -> 8279';
ok Uni.new(0xFA5F).NFD.list ~~ (0x8457,), 'FA5F -> 8457';
ok Uni.new(0xFA60).NFD.list ~~ (0x8910,), 'FA60 -> 8910';
ok Uni.new(0xFA61).NFD.list ~~ (0x8996,), 'FA61 -> 8996';
ok Uni.new(0xFA62).NFD.list ~~ (0x8B01,), 'FA62 -> 8B01';
ok Uni.new(0xFA63).NFD.list ~~ (0x8B39,), 'FA63 -> 8B39';
ok Uni.new(0xFA64).NFD.list ~~ (0x8CD3,), 'FA64 -> 8CD3';
ok Uni.new(0xFA65).NFD.list ~~ (0x8D08,), 'FA65 -> 8D08';
ok Uni.new(0xFA66).NFD.list ~~ (0x8FB6,), 'FA66 -> 8FB6';
ok Uni.new(0xFA67).NFD.list ~~ (0x9038,), 'FA67 -> 9038';
ok Uni.new(0xFA68).NFD.list ~~ (0x96E3,), 'FA68 -> 96E3';
ok Uni.new(0xFA69).NFD.list ~~ (0x97FF,), 'FA69 -> 97FF';
ok Uni.new(0xFA6A).NFD.list ~~ (0x983B,), 'FA6A -> 983B';
ok Uni.new(0xFA6B).NFD.list ~~ (0x6075,), 'FA6B -> 6075';
ok Uni.new(0xFA6C).NFD.list ~~ (0x242EE,), 'FA6C -> 242EE';
ok Uni.new(0xFA6D).NFD.list ~~ (0x8218,), 'FA6D -> 8218';
ok Uni.new(0xFA70).NFD.list ~~ (0x4E26,), 'FA70 -> 4E26';
ok Uni.new(0xFA71).NFD.list ~~ (0x51B5,), 'FA71 -> 51B5';
ok Uni.new(0xFA72).NFD.list ~~ (0x5168,), 'FA72 -> 5168';
ok Uni.new(0xFA73).NFD.list ~~ (0x4F80,), 'FA73 -> 4F80';
ok Uni.new(0xFA74).NFD.list ~~ (0x5145,), 'FA74 -> 5145';
ok Uni.new(0xFA75).NFD.list ~~ (0x5180,), 'FA75 -> 5180';
ok Uni.new(0xFA76).NFD.list ~~ (0x52C7,), 'FA76 -> 52C7';
ok Uni.new(0xFA77).NFD.list ~~ (0x52FA,), 'FA77 -> 52FA';
ok Uni.new(0xFA78).NFD.list ~~ (0x559D,), 'FA78 -> 559D';
ok Uni.new(0xFA79).NFD.list ~~ (0x5555,), 'FA79 -> 5555';
ok Uni.new(0xFA7A).NFD.list ~~ (0x5599,), 'FA7A -> 5599';
ok Uni.new(0xFA7B).NFD.list ~~ (0x55E2,), 'FA7B -> 55E2';
ok Uni.new(0xFA7C).NFD.list ~~ (0x585A,), 'FA7C -> 585A';
ok Uni.new(0xFA7D).NFD.list ~~ (0x58B3,), 'FA7D -> 58B3';
ok Uni.new(0xFA7E).NFD.list ~~ (0x5944,), 'FA7E -> 5944';
ok Uni.new(0xFA7F).NFD.list ~~ (0x5954,), 'FA7F -> 5954';
ok Uni.new(0xFA80).NFD.list ~~ (0x5A62,), 'FA80 -> 5A62';
ok Uni.new(0xFA81).NFD.list ~~ (0x5B28,), 'FA81 -> 5B28';
ok Uni.new(0xFA82).NFD.list ~~ (0x5ED2,), 'FA82 -> 5ED2';
ok Uni.new(0xFA83).NFD.list ~~ (0x5ED9,), 'FA83 -> 5ED9';
ok Uni.new(0xFA84).NFD.list ~~ (0x5F69,), 'FA84 -> 5F69';
ok Uni.new(0xFA85).NFD.list ~~ (0x5FAD,), 'FA85 -> 5FAD';
ok Uni.new(0xFA86).NFD.list ~~ (0x60D8,), 'FA86 -> 60D8';
ok Uni.new(0xFA87).NFD.list ~~ (0x614E,), 'FA87 -> 614E';
ok Uni.new(0xFA88).NFD.list ~~ (0x6108,), 'FA88 -> 6108';
ok Uni.new(0xFA89).NFD.list ~~ (0x618E,), 'FA89 -> 618E';
ok Uni.new(0xFA8A).NFD.list ~~ (0x6160,), 'FA8A -> 6160';
ok Uni.new(0xFA8B).NFD.list ~~ (0x61F2,), 'FA8B -> 61F2';
ok Uni.new(0xFA8C).NFD.list ~~ (0x6234,), 'FA8C -> 6234';
ok Uni.new(0xFA8D).NFD.list ~~ (0x63C4,), 'FA8D -> 63C4';
ok Uni.new(0xFA8E).NFD.list ~~ (0x641C,), 'FA8E -> 641C';
ok Uni.new(0xFA8F).NFD.list ~~ (0x6452,), 'FA8F -> 6452';
ok Uni.new(0xFA90).NFD.list ~~ (0x6556,), 'FA90 -> 6556';
ok Uni.new(0xFA91).NFD.list ~~ (0x6674,), 'FA91 -> 6674';
ok Uni.new(0xFA92).NFD.list ~~ (0x6717,), 'FA92 -> 6717';
ok Uni.new(0xFA93).NFD.list ~~ (0x671B,), 'FA93 -> 671B';
ok Uni.new(0xFA94).NFD.list ~~ (0x6756,), 'FA94 -> 6756';
ok Uni.new(0xFA95).NFD.list ~~ (0x6B79,), 'FA95 -> 6B79';
ok Uni.new(0xFA96).NFD.list ~~ (0x6BBA,), 'FA96 -> 6BBA';
ok Uni.new(0xFA97).NFD.list ~~ (0x6D41,), 'FA97 -> 6D41';
ok Uni.new(0xFA98).NFD.list ~~ (0x6EDB,), 'FA98 -> 6EDB';
ok Uni.new(0xFA99).NFD.list ~~ (0x6ECB,), 'FA99 -> 6ECB';
ok Uni.new(0xFA9A).NFD.list ~~ (0x6F22,), 'FA9A -> 6F22';
ok Uni.new(0xFA9B).NFD.list ~~ (0x701E,), 'FA9B -> 701E';
ok Uni.new(0xFA9C).NFD.list ~~ (0x716E,), 'FA9C -> 716E';
ok Uni.new(0xFA9D).NFD.list ~~ (0x77A7,), 'FA9D -> 77A7';
ok Uni.new(0xFA9E).NFD.list ~~ (0x7235,), 'FA9E -> 7235';
ok Uni.new(0xFA9F).NFD.list ~~ (0x72AF,), 'FA9F -> 72AF';
ok Uni.new(0xFAA0).NFD.list ~~ (0x732A,), 'FAA0 -> 732A';
ok Uni.new(0xFAA1).NFD.list ~~ (0x7471,), 'FAA1 -> 7471';
ok Uni.new(0xFAA2).NFD.list ~~ (0x7506,), 'FAA2 -> 7506';
ok Uni.new(0xFAA3).NFD.list ~~ (0x753B,), 'FAA3 -> 753B';
ok Uni.new(0xFAA4).NFD.list ~~ (0x761D,), 'FAA4 -> 761D';
ok Uni.new(0xFAA5).NFD.list ~~ (0x761F,), 'FAA5 -> 761F';
ok Uni.new(0xFAA6).NFD.list ~~ (0x76CA,), 'FAA6 -> 76CA';
ok Uni.new(0xFAA7).NFD.list ~~ (0x76DB,), 'FAA7 -> 76DB';
ok Uni.new(0xFAA8).NFD.list ~~ (0x76F4,), 'FAA8 -> 76F4';
ok Uni.new(0xFAA9).NFD.list ~~ (0x774A,), 'FAA9 -> 774A';
ok Uni.new(0xFAAA).NFD.list ~~ (0x7740,), 'FAAA -> 7740';
ok Uni.new(0xFAAB).NFD.list ~~ (0x78CC,), 'FAAB -> 78CC';
ok Uni.new(0xFAAC).NFD.list ~~ (0x7AB1,), 'FAAC -> 7AB1';
ok Uni.new(0xFAAD).NFD.list ~~ (0x7BC0,), 'FAAD -> 7BC0';
ok Uni.new(0xFAAE).NFD.list ~~ (0x7C7B,), 'FAAE -> 7C7B';
ok Uni.new(0xFAAF).NFD.list ~~ (0x7D5B,), 'FAAF -> 7D5B';
ok Uni.new(0xFAB0).NFD.list ~~ (0x7DF4,), 'FAB0 -> 7DF4';
ok Uni.new(0xFAB1).NFD.list ~~ (0x7F3E,), 'FAB1 -> 7F3E';
ok Uni.new(0xFAB2).NFD.list ~~ (0x8005,), 'FAB2 -> 8005';
ok Uni.new(0xFAB3).NFD.list ~~ (0x8352,), 'FAB3 -> 8352';
ok Uni.new(0xFAB4).NFD.list ~~ (0x83EF,), 'FAB4 -> 83EF';
ok Uni.new(0xFAB5).NFD.list ~~ (0x8779,), 'FAB5 -> 8779';
ok Uni.new(0xFAB6).NFD.list ~~ (0x8941,), 'FAB6 -> 8941';
ok Uni.new(0xFAB7).NFD.list ~~ (0x8986,), 'FAB7 -> 8986';
ok Uni.new(0xFAB8).NFD.list ~~ (0x8996,), 'FAB8 -> 8996';
ok Uni.new(0xFAB9).NFD.list ~~ (0x8ABF,), 'FAB9 -> 8ABF';
ok Uni.new(0xFABA).NFD.list ~~ (0x8AF8,), 'FABA -> 8AF8';
ok Uni.new(0xFABB).NFD.list ~~ (0x8ACB,), 'FABB -> 8ACB';
ok Uni.new(0xFABC).NFD.list ~~ (0x8B01,), 'FABC -> 8B01';
ok Uni.new(0xFABD).NFD.list ~~ (0x8AFE,), 'FABD -> 8AFE';
ok Uni.new(0xFABE).NFD.list ~~ (0x8AED,), 'FABE -> 8AED';
ok Uni.new(0xFABF).NFD.list ~~ (0x8B39,), 'FABF -> 8B39';
ok Uni.new(0xFAC0).NFD.list ~~ (0x8B8A,), 'FAC0 -> 8B8A';
ok Uni.new(0xFAC1).NFD.list ~~ (0x8D08,), 'FAC1 -> 8D08';
ok Uni.new(0xFAC2).NFD.list ~~ (0x8F38,), 'FAC2 -> 8F38';
ok Uni.new(0xFAC3).NFD.list ~~ (0x9072,), 'FAC3 -> 9072';
ok Uni.new(0xFAC4).NFD.list ~~ (0x9199,), 'FAC4 -> 9199';
ok Uni.new(0xFAC5).NFD.list ~~ (0x9276,), 'FAC5 -> 9276';
ok Uni.new(0xFAC6).NFD.list ~~ (0x967C,), 'FAC6 -> 967C';
ok Uni.new(0xFAC7).NFD.list ~~ (0x96E3,), 'FAC7 -> 96E3';
ok Uni.new(0xFAC8).NFD.list ~~ (0x9756,), 'FAC8 -> 9756';
ok Uni.new(0xFAC9).NFD.list ~~ (0x97DB,), 'FAC9 -> 97DB';
ok Uni.new(0xFACA).NFD.list ~~ (0x97FF,), 'FACA -> 97FF';
ok Uni.new(0xFACB).NFD.list ~~ (0x980B,), 'FACB -> 980B';
ok Uni.new(0xFACC).NFD.list ~~ (0x983B,), 'FACC -> 983B';
ok Uni.new(0xFACD).NFD.list ~~ (0x9B12,), 'FACD -> 9B12';
ok Uni.new(0xFACE).NFD.list ~~ (0x9F9C,), 'FACE -> 9F9C';
ok Uni.new(0xFACF).NFD.list ~~ (0x2284A,), 'FACF -> 2284A';
ok Uni.new(0xFAD0).NFD.list ~~ (0x22844,), 'FAD0 -> 22844';
ok Uni.new(0xFAD1).NFD.list ~~ (0x233D5,), 'FAD1 -> 233D5';
ok Uni.new(0xFAD2).NFD.list ~~ (0x3B9D,), 'FAD2 -> 3B9D';
ok Uni.new(0xFAD3).NFD.list ~~ (0x4018,), 'FAD3 -> 4018';
ok Uni.new(0xFAD4).NFD.list ~~ (0x4039,), 'FAD4 -> 4039';
ok Uni.new(0xFAD5).NFD.list ~~ (0x25249,), 'FAD5 -> 25249';
ok Uni.new(0xFAD6).NFD.list ~~ (0x25CD0,), 'FAD6 -> 25CD0';
