use v6.d;
use Test;

plan 12;

# TODO: move to S02?
# L<S02/Generic types/>

# Check it captures built-in types.
sub basic_capture(::T $x) { T }   #OK not used
isa-ok(basic_capture(42),  Int, 'captured built-in type');
isa-ok(basic_capture(4.2), Rat, 'captured built-in type');

# User defined ones too.
class Foo { }
isa-ok(basic_capture(Foo.new), Foo, 'captured user defined type');

# Check you can use captured type later in the signature.
sub two_the_same(::T $x, T $y) { 1 }   #OK not used
ok(two_the_same(42, 42), 'used captured type later in the sig');
my $ok = 1;
try {
    two_the_same(42, 4.2);
    $ok = 0;
}
ok($ok, 'used captured type later in the sig');

# Check you can use them to declare variables.
sub declare_cap_type(::T $x) {   #OK not used
    my T $y = 4.2;   #OK not used
    1
}
ok(declare_cap_type(3.3), 'can use captured type in declaration');
$ok = 1;
try {
    declare_cap_type(42);
    $ok = 0;
}
ok($ok, 'can use captured type in declaration');

#RT #114216
eval-lives-ok q':(::T $x)', "No error on type capture";

# RT #125537
{
    sub foo(::T) {
        {
            my T $b;
            is $b, Int, 'Type capture works on variable in nested scope';
        }
    }
    foo(1)
}

# RT #114724
{
    sub f (::T $g) {
        for ($g) -> T $h {
            return $h ~ ":" ~ T.perl
        }
    };
    is f("blah"), "blah:Str", 'Type variable matches in signature to "for" loop';
}

# RT #126383
{
    sub accum( ::T \a, T(Cool) \b ) { a += b };

    my $t = 3;
    accum( $t, 2/3 );
    is $t, 3, 'coerce to Int via type capture';

    $t = 3.0;
    accum( $t, 2/3 );
    is-approx $t, 3.666667, 'coerce to Rat via type capture';
}

# vim: ft=perl6
