/*
Copyright (c) 2002 Regents of The University of Michigan.
All Rights Reserved.

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appears in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of The University
of Michigan not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission. This software is supplied as is without expressed or
implied warranties of any kind.

Research Systems Unix Group
The University of Michigan
c/o Wesley Craig
4251 Plymouth Road B1F2, #2600
Ann Arbor, MI 48105-2785

http://rsug.itd.umich.edu/software/radmind
radmind@umich.edu
*/

#include <sys/types.h>
#include <string.h>
#include <stdio.h>
#include "ischild.h"

    int
ischild( const char *child, const char *parent )
{
    size_t parentlen;

    if ( parent == NULL ) {
        return 1;
    } else {
        parentlen = strlen( parent );
        if( parentlen > strlen( child )) {
            return 0;
        }       
        if(( strncmp( parent, child, parentlen ) == 0 ) &&
                child[ parentlen ] == '/' ) {
            return 1; 
        } else {
            return 0;
        }
    }
}
