/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */
 
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "copy.h"

extern int	errno;

    void
copy( char *src, char *dest, int overwrite )
{
    int         ifd, ofd, rr;
    char        buf[ MAXPATHLEN ] = { 0 };

    if ( access( dest, F_OK ) == 0 ) {
	if ( ! overwrite ) {
	    return;
	}
    }

    if (( ifd = open( src, O_RDONLY, 0 )) < 0 ) {
        fprintf( stderr, "open %s: %s\n", src, strerror( errno ));
        exit( 2 );
    }

    if (( ofd = open( dest, O_RDWR | O_CREAT | O_TRUNC, 0600 )) < 0 ) {
        fprintf( stderr, "open %s: %s\n", dest, strerror( errno ));
        exit( 2 );
    }

    while (( rr = read( ifd, buf, MAXPATHLEN )) > 0 ) {
        if ( write( ofd, buf, rr ) != rr ) {
            fprintf( stderr, "write error: %s\n", strerror( errno ));
            exit( 2 );
        }
    }

    ( void )close( ifd );
    ( void )close( ofd );

    if ( rr < 0 ) {
        fprintf( stderr, "read error: %s\n", strerror( errno ));
        exit( 2 );
    }
}
