/*
Copyright (c) 2002 Regents of The University of Michigan.
All Rights Reserved.

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appears in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of The University
of Michigan not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission. This software is supplied as is without expressed or
implied warranties of any kind.

Research Systems Unix Group
The University of Michigan
c/o Wesley Craig
4251 Plymouth Road B1F2, #2600
Ann Arbor, MI 48105-2785

http://rsug.itd.umich.edu/software/radmind
radmind@umich.edu
*/

#include <Security/AuthorizationTags.h>
#include <CoreFoundation/CoreFoundation.h>

#include <sys/types.h>
#include <sys/param.h>
#include <unistd.h>
#include "authtools.h"

extern int		errno;

    char *
nameforcmd( int command )
{
    switch ( command ) {
    case KTCHECK:
        return( "ktcheck" );
        
    case FSDIFFA:
    case FSDIFFC:
        return( "fsdiff" );
        
    case LAPPLY:
        return( "lapply" );
        
    case LCREATE:
        return( "lcreate" );
    
    default:
        break;
    }
    
    return( NULL );
}

    int
pathfortool( CFStringRef toolname, char path[ MAXPATHLEN ] )
{
    CFBundleRef		bundle;
    CFURLRef		resources;
    CFURLRef		toolURL;
    
    if (( bundle = CFBundleGetMainBundle()) == NULL )
        return( -1 );
    
    if (( resources = CFBundleCopyResourcesDirectoryURL( bundle )) == NULL ) {
        return( -1 );
    }
    
    toolURL = CFURLCreateCopyAppendingPathComponent(
                NULL,
                resources,
                toolname,
                FALSE );
                
    CFRelease( resources );
                
    if ( !toolURL )
        return( -1 );
        
    if ( CFURLGetFileSystemRepresentation(
                toolURL,
                TRUE,
                ( UInt8 * )path,
                MAXPATHLEN ) == FALSE ) {
        return( -1 );
    }
            
    CFRelease( toolURL );
    
    return( access( path, X_OK ));
}

