/*
 * Copyright (c) 2006 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import "UMWildcard.h"

#include <CoreFoundation/CoreFoundation.h>

#include <sys/param.h>
#include <stdlib.h>
#include <ctype.h>

int wildcard( unsigned char *, unsigned char *, int );

@implementation NSString(UMWildcardString)

    int
wildcard( unsigned char *wild, unsigned char *p, int sensitive )
{
    int		min, max;
    int		i;

    for (;;) {
	switch ( *wild ) {
	case '*' :
	    wild++;

	    if ( *wild == '\0' ) {
		return( 1 );
	    }
	    for ( i = 0; p[ i ] != '\0'; i++ ) {
		if ( wildcard( wild, &p[ i ], sensitive )) {
		    return( 1 );
		}
	    }
	    return( 0 );

	case '<' :
	    wild++;

	    if ( ! isdigit( (int)*p )) {
		return( 0 );
	    }
	    i = atoi( p );
	    while ( isdigit( (int)*p )) p++;

	    if ( ! isdigit( (int)*wild )) {
		return( 0 );
	    }
	    min = atoi( wild );
	    while ( isdigit( (int)*wild )) wild++;

	    if ( *wild++ != '-' ) {
		return( 0 );
	    }

	    if ( ! isdigit( (int)*wild )) {
		return( 0 );
	    }
	    max = atoi( wild );
	    while ( isdigit( (int)*wild )) wild++;

	    if ( *wild++ != '>' ) {
		return( 0 );
	    }

	    if (( i < min ) || ( i > max )) {
		return( 0 );
	    }
	    break;

	case '\\' :
	    wild++;
	default :
	    if ( sensitive ) {
	       if ( *wild != *p ) {
		   return( 0 );
	       }
	    } else {
	       if ( tolower(*wild) != tolower(*p) ) {
		  return( 0 );
		}
	    }
	    if ( *wild == '\0' ) {
		return( 1 );
	    }
	    wild++, p++;
	}
    }
}

- ( BOOL )matchesWildcard: ( NSString * )wild
	    caseSensitive: ( BOOL )caseSensitive
{
    BOOL		matches = NO;
    CFRange		range = { 0, 0 };
    unsigned char	buf[ MAXPATHLEN ], wildbuf[ MAXPATHLEN ];
    unsigned int	len;
    int			case_sensitive = 1;
    int			match;

    if ( self == nil || wild == nil ) {
	return( NO );
    }

    if ( !caseSensitive ) {
	case_sensitive = 0;
    }

    if (( len = [ self length ] ) >= MAXPATHLEN ) {
	NSLog( @"%@: path too long\n", self );
	return( NO );
    }
    memset( buf, '\0', sizeof( buf ));
    range.length = len;
    if ( CFStringGetBytes(( CFStringRef )self, range,
                    CFStringGetSystemEncoding(), 0,
                    FALSE, ( UInt8 * )buf, len, NULL ) == 0 ) {
	NSLog( @"CFStringGetBytes %@ failed", self );
	return( NO );
    }
    buf[ len ] = '\0';

    if (( len = [ wild length ] ) >= MAXPATHLEN ) {
	NSLog( @"%@: too long", self );
	return( NO );
    }
    memset( wildbuf, '\0', sizeof( wildbuf ));
    range.length = len;
    if ( CFStringGetBytes(( CFStringRef )wild, range,
                    CFStringGetSystemEncoding(), 0,
                    FALSE, ( UInt8 * )wildbuf, len, NULL ) == 0 ) {
	NSLog( @"CFStringGetBytes %@ failed", self );
	return( NO );
    }
    wildbuf[ len ] = '\0';

    match = wildcard( wildbuf, buf, case_sensitive );
    if ( match ) {
	matches = YES;
    }

    return( matches );
}

@end
