/*
 * Copyright (c) 2005 Regents of The University of Michigan.
 * All Rights Reserved.
 */

#import "NSAttributedString-Ellipsis.h"
#import "RTEAuditorDisplay.h"

@implementation RTEAuditorDisplay

- ( id )init
{
    if (( self = [ super init ] ) == nil ) {
	NSLog( @"%@ init failed", [ self class ] );
	return( nil );
    }
    
    _rteAuditorDisplayContents = nil;
    
    return( self );
}

- ( void )awakeFromNib
{
    [ auditResultsDisplayTable setDataSource: self ];
    [ auditResultsDisplayTable setDelegate: self ];
    [ auditResultsDisplayTable setAction:
	    @selector( auditResultsDisplayTableClick: ) ];
}

- ( void )displayAuditResults: ( id )results
	    parentWindow: ( NSWindow * )window
{
    if ( ! [ results isKindOfClass: [ NSArray class ]] ) {
	NSLog( @"%@: invalid audit results type", [ results class ] );
	return;
    }
    
    if ( window == nil ) {
	NSLog( @"%@: window is nil", NSStringFromSelector( _cmd ));
	return;
    }
    
    _rteAuditorDisplayContents = [ results retain ];
    
    [ auditResultsDisplayTable reloadData ];
    
    [ NSApp beginSheet: auditResultsPanel
	    modalForWindow: window
	    modalDelegate: self
	    didEndSelector: NULL
	    contextInfo: nil ];
}

- ( IBAction )closeAuditResultsSheet: ( id )sender
{
    [ auditResultsPanel orderOut: nil ];
    [ NSApp endSheet: auditResultsPanel ];
    
    if ( _rteAuditorDisplayContents ) {
	[ _rteAuditorDisplayContents release ];
	_rteAuditorDisplayContents = nil;
    }
}

- ( void )auditResultsDisplayTableClick: ( id )sender
{
    int			row = [ auditResultsDisplayTable selectedRow ];
    NSDictionary	*dict = nil;
    NSString		*analysis = @"";
    NSString		*path = @"";
    
    if ( row >= 0 ) {
	dict = [ _rteAuditorDisplayContents objectAtIndex: row ];
	analysis = [ dict objectForKey: @"RTEAuditorAnalysis" ];
	path = [ dict objectForKey: @"path" ];
    }
    
    [ auditResultsAnalysisField setStringValue: analysis ];
    [ auditResultsPathField setStringValue: path ];
}

/* tableview data source methods */
- ( int )numberOfRowsInTableView: ( NSTableView * )aTableView
{
    return( [ _rteAuditorDisplayContents count ] );
}

- ( id )tableView: ( NSTableView * )view
        objectValueForTableColumn: ( NSTableColumn * )column
        row: ( int )row
{
    NSDictionary	*dict = [ _rteAuditorDisplayContents objectAtIndex: row ];
    NSString            *key = [ column identifier ];
    
    if ( [ key isEqualToString: @"path" ] ) {
        NSString            *path = [ dict objectForKey: @"path" ];
        NSAttributedString  *attrString = [[[ NSAttributedString alloc ]
					    initWithString: path ] autorelease ];
        double              width = ( [ column width ] - 10.0 );

        attrString = [ attrString ellipsisAbbreviatedStringForWidth: width ];
        
        return( attrString );
    }
    
    return( [ dict objectForKey: key ] );
}

/* tableview delegate methods */
- ( void )tableViewSelectionDidChange: ( NSNotification * )notification
{
    [ self auditResultsDisplayTableClick: nil ];
}

@end
