/*
 * Copyright (c) 2005 Regents of The University of Michigan.
 * All Rights Reserved.
 */
 
#import "RTEAuditor.h"

@implementation RTEAuditor

- ( id )init
{
    if (( self = [ super init ] ) == nil ) {
	NSLog( @"%@ %@ failed.", [ self class ],
		NSStringFromSelector( _cmd ));
	return( nil );
    }
    
    _rteAuditResults = nil;    
    _rteAuditedTranscript = nil;
    
    return( self );
}

/* accessor methods */
- ( id )auditedTranscriptContents
{
    return( _rteAuditedTranscript );
}

- ( void )setAuditedTranscriptContents: ( id )contents
{
    if ( _rteAuditedTranscript != nil ) {
	[ _rteAuditedTranscript release ];
	_rteAuditedTranscript = nil;
    }
    
    if ( contents == nil ) {
	return;
    }
    
    _rteAuditedTranscript = [ contents retain ];
}

/* return YES if line is potentially dangerous */
- ( BOOL )auditLine: ( NSMutableDictionary * )line
{
    NSString	    *owner, *mode;
    NSString	    *objectType = @"unknown";
    int		    type;
    
    if ( line == nil ) {
	return( NO );
    }
    
    owner = [ line objectForKey: @"owner" ];
    mode = [ line objectForKey: @"perm" ];
    type = [[ line objectForKey: @"type" ] characterAtIndex: 0 ];
    
    if ( [ owner isEqualToString: @"0" ] ) {
	switch ( [ mode characterAtIndex: 0 ] ) {
	case '2':
	    [ line setObject: NSLocalizedString( @"setgid root", @"setgid root" )
			forKey: @"RTEAuditorAnalysis" ];
	    return( YES );
	    
	case '4':
	    [ line setObject: NSLocalizedString( @"setuid root", @"setuid root" )
			forKey: @"RTEAuditorAnalysis" ];
	    return( YES );
	default:
	    break;
	}
    }
    
    /* XXX surely there's a better way to do this. later. */
    if ( [ mode isEqualToString: @"0777" ] ||
	    [ mode isEqualToString: @"0666" ] ||
	    [ mode isEqualToString: @"0333" ] ||
	    [ mode isEqualToString: @"0222" ] ) {
	switch ( type ) {
	default:
	case 'a':
	case 'f':
	    objectType = NSLocalizedString( @"file", @"file" );
	    break;
	    
	case 'd':
	    objectType = NSLocalizedString( @"directory", @"directory" );
	    break;
	}
	
	[ line setObject:
		    [ NSString stringWithFormat:
			    NSLocalizedString( @"Unprotected world-writable %@",
						@"Unprotected world-writable %@" ),
						objectType ]
		forKey: @"RTEAuditorAnalysis" ];
	return( YES );
    }
    
    return( NO );
}

/*
 * Parse the dictionary for potentially insecure lines.
 * Return an array of problem lines.
 */
- ( NSMutableArray * )auditTranscriptContents: ( id )transcript
{
    int		    i;
    
    if ( transcript == nil ||
	    ! [ transcript isKindOfClass: [ NSArray class ]] ) {
	return( nil );
    }
    
    [ self setAuditedTranscriptContents: transcript ];
    _rteAuditResults = [[ NSMutableArray alloc ] init ];
    
    for ( i = 0; i < [ transcript count ]; i++ ) {
	if ( [ self auditLine: [ transcript objectAtIndex: i ]] ) {
	    [ _rteAuditResults addObject: [ transcript objectAtIndex: i ]];
	}
    }
    
    [ self setAuditedTranscriptContents: nil ];
    
    return( _rteAuditResults );
}

- ( void )dealloc
{
    if ( _rteAuditedTranscript != nil ) {
	[ _rteAuditedTranscript release ];
	_rteAuditedTranscript = nil;
    }
    if ( _rteAuditResults != nil ) {
	[ _rteAuditResults release ];
	_rteAuditResults = nil;
    }
    
    [ super dealloc ];
}

@end
