/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import "NSArray(CreateArgv).h"

@implementation NSArray(CreateArgv)

/* create an argv for use with execve. pointer must be freed if not NULL */
- ( int )argv: ( char *** )argv
{
    char			**av;
    int				i, ac = 0, count = [ self count ];
    
    if ( self == nil || count == 0 ) {
        *argv = NULL;
        return( 0 );
    }
    
    if (( av = ( char ** )malloc( sizeof( char * ) * ( count + 1 ))) == NULL ) {
        NSLog( @"malloc: %s", strerror( errno ));
        exit( 2 );
    }
    
    for ( i = 0; i < count; i++ ) {
        if (( av[ i ] = strdup(( char * )[[ self objectAtIndex: i ]
                                            UTF8String ] )) == NULL ) {
            NSLog( @"strdup: %s", strerror( errno ));
            exit( 2 );
        }
        ac++;
    }
    
    av[ i ] = NULL;
    *argv = av;
    
    return( ac );
}

@end
