/*
Copyright (c) 2002 Regents of The University of Michigan.
All Rights Reserved.

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appears in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of The University
of Michigan not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission. This software is supplied as is without expressed or
implied warranties of any kind.

Research Systems Unix Group
The University of Michigan
c/o Wesley Craig
4251 Plymouth Road B1F2, #2600
Ann Arbor, MI 48105-2785

http://rsug.itd.umich.edu/software/radmind
radmind@umich.edu
*/

#include <sys/param.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "code.h"

/*
 * Escape certain characters.  This code must match decode() *and*
 * argcargv().
 */
    char *
encode( char *line )
{
    /* static */
    static char	    buf[ 2 * MAXPATHLEN ];
    char	    *temp;    

    if ( strlen( line ) > MAXPATHLEN ) {
	fprintf( stderr, "ERROR: The path is too long\n" );
	exit( 1 );
    }

    temp = buf;
    for ( ; *line != '\0'; line++, temp++ ) {
	switch ( *line ) {
	case ' ' :
	    *temp = '\\';
	    temp++;
	    *temp = 'b';
	    break;
	case '\t' :
	    *temp = '\\';
	    temp++;
	    *temp = 't';
	    break;
	case '\n':
	    *temp = '\\';
	    temp++;
	    *temp = 'n';
	    break;
	case '\r':
	    *temp = '\\';
	    temp++;
	    *temp = 'r';
	    break;
	case '\\':
	    *temp = '\\';
	    temp++;
	    *temp = '\\';
	    break;
	default :
	    *temp = *line;
	    break;
	}
    }

    *temp = '\0';
    return( buf );
}

    char *
decode( char *line ) 
{
    /* static */
    static char     buf[ MAXPATHLEN ];
    char	    *temp;

    if ( strlen( line ) > ( 2 * MAXPATHLEN )) {
	fprintf( stderr, "ERROR:  The path name is too long\n" );
	exit( 1 );
    }

    temp = buf;

    for ( ; *line != '\0'; line++, temp++ ) {
	switch( *line ) {
	case '\\':
	    line++;
	    switch( *line ) {
	    case 'n':
		*temp = '\n';
		break;
	    case 't':
		*temp = '\t';
		break;
	    case 'b':
		*temp = ' ';
		break;
	    case 'r':
		*temp = '\r';
		break;
	    case '\\':
		*temp = '\\';
		break;
	    default:
		break;
	    }
	    break;
	default:
	    *temp = *line;
	    break;
	}
    }

    *temp = '\0';
    return( buf );
}
