/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#include <Security/AuthorizationTags.h>
#include <CoreFoundation/CoreFoundation.h>

#include <sys/types.h>
#include <sys/param.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>
#include "authtools.h"

extern int		errno;

    char *
nameforcmd( int command )
{
    switch ( command ) {
    case LCKSUM:
        return( "lcksum" );
        
    case LCREATE:
        return( "lcreate" );
        
    case LMERGE:
        return( "lmerge" );
        
    case RADMIND:
        return( "radmind" );
    
    case RM:
        return( "rm" );
    
    default:
        break;
    }
    
    return( NULL );
}

    int
pathfortool( char *tool, char path[ MAXPATHLEN ] )
{
    CFStringRef			toolname = CFStringCreateWithCString( NULL,
                                                tool,
                                                kCFStringEncodingMacRoman );
                                                
    if ( CFStringCompare( toolname, CFSTR( "rsmauthtool" ), 0 ) == 0 ) {
        CFBundleRef		bundle;
        CFURLRef		resources;
        CFURLRef		toolURL;
        
        if (( bundle = CFBundleGetMainBundle()) == NULL )
            return( -1 );
        
        if (( resources = CFBundleCopyResourcesDirectoryURL( bundle )) == NULL ) {
            return( -1 );
        }
        
        toolURL = CFURLCreateCopyAppendingPathComponent(
                    NULL,
                    resources,
                    toolname,
                    FALSE );
                    
        if ( !toolURL )
            return( -1 );
            
        if ( CFURLGetFileSystemRepresentation(
                    toolURL,
                    TRUE,
                    ( UInt8 * )path,
                    MAXPATHLEN ) == FALSE ) {
            return( -1 );
        }
                
        CFRelease( toolURL );
        CFRelease( resources );
    } else {
        char		*bindir;
        
        if ( strcmp( tool, "radmind" ) == 0 ) {
            bindir = "/usr/local/sbin";
        } else {
            bindir = "/usr/local/bin";
        }
        
        if ( snprintf( path, MAXPATHLEN, "%s/%s", bindir, tool )
                                                    >= MAXPATHLEN ) {
            syslog( LOG_ERR, "%s/%s: path too long", bindir, tool );
            return( -1 );
        }
    }
    
    if ( toolname ) {
        CFRelease( toolname );
    }
    
    return( access( path, X_OK ));
}
